/*!
* DevExtreme (dx.messages.zh.js)
* Version: 23.1.6
* Build date: Fri Oct 13 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        zh: {
            Yes: "\u662f",
            No: "\u5426",
            Cancel: "\u53d6\u6d88",
            Close: "\u95dc\u9589",
            Clear: "\u6e05\u9664",
            Done: "\u5b8c\u6210",
            Loading: "\u6b63\u5728\u52a0\u8f7d...",
            Select: "\u9009\u62e9...",
            Search: "\u641c\u7d22",
            Back: "\u8fd4\u56de",
            OK: "\u786e\u5b9a",
            "dxCollectionWidget-noDataText": "\u6ca1\u6709\u8981\u663e\u793a\u7684\u6570\u636e",
            "dxDropDownEditor-selectLabel": "\u9009\u62e9",
            "validation-required": "\u5fc5\u9700",
            "validation-required-formatted": "{0} \u662f\u5fc5\u9700\u7684",
            "validation-numeric": "\u503c\u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57",
            "validation-numeric-formatted": "{0} \u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57",
            "validation-range": "\u503c\u8d85\u51fa\u8303\u56f4",
            "validation-range-formatted": "{0} \u8d85\u51fa\u8303\u56f4",
            "validation-stringLength": "\u8be5\u503c\u7684\u957f\u5ea6\u4e0d\u6b63\u786e",
            "validation-stringLength-formatted": "{0} \u7684\u957f\u5ea6\u4e0d\u6b63\u786e",
            "validation-custom": "\u503c\u65e0\u6548",
            "validation-custom-formatted": "{0} \u503c\u65e0\u6548",
            "validation-async": "\u503c\u65e0\u6548",
            "validation-async-formatted": "{0} \u503c\u65e0\u6548",
            "validation-compare": "\u503c\u4e0d\u5339\u914d",
            "validation-compare-formatted": "{0} \u4e0d\u5339\u914d",
            "validation-pattern": "\u503c\u4e0d\u7b26\u5408\u8be5\u6a21\u5f0f",
            "validation-pattern-formatted": "{0} \u4e0d\u5339\u914d\u8be5\u6a21\u5f0f",
            "validation-email": "\u7535\u5b50\u90ae\u4ef6\u65e0\u6548",
            "validation-email-formatted": "{0} \u65e0\u6548",
            "validation-mask": "\u503c\u65e0\u6548",
            "dxLookup-searchPlaceholder": "\u6700\u5c0f\u5b57\u7b26\u6570: {0}",
            "dxList-pullingDownText": "\u4e0b\u62c9\u4ee5\u5237\u65b0...",
            "dxList-pulledDownText": "\u653e\u5f00\u4ee5\u5237\u65b0...",
            "dxList-refreshingText": "\u5237\u65b0\u4e2d...",
            "dxList-pageLoadingText": "\u6b63\u5728\u52a0\u8f7d...",
            "dxList-nextButtonText": "\u66f4\u591a",
            "dxList-selectAll": "\u5168\u9009",
            "dxListEditDecorator-delete": "\u5220\u9664",
            "dxListEditDecorator-more": "\u66f4\u591a",
            "dxScrollView-pullingDownText": "\u4e0b\u62c9\u4ee5\u5237\u65b0...",
            "dxScrollView-pulledDownText": "\u653e\u5f00\u4ee5\u5237\u65b0...",
            "dxScrollView-refreshingText": "\u5237\u65b0\u4e2d...",
            "dxScrollView-reachBottomText": "\u6b63\u5728\u52a0\u8f7d...",
            "dxDateBox-simulatedDataPickerTitleTime": "\u9009\u62e9\u65f6\u95f4",
            "dxDateBox-simulatedDataPickerTitleDate": "\u9009\u62e9\u65e5\u671f",
            "dxDateBox-simulatedDataPickerTitleDateTime": "\u9009\u62e9\u65e5\u671f\u548c\u65f6\u95f4",
            "dxDateBox-validation-datetime": "\u503c\u5fc5\u987b\u662f\u65e5\u671f\u6216\u65f6\u95f4",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "\u5f00\u59cb\u65e5\u671f",
            "dxDateRangeBox-endDateLabel": "\u7ed3\u675f\u65e5\u671f",
            "dxFileUploader-selectFile": "\u9009\u62e9\u6587\u4ef6",
            "dxFileUploader-dropFile": "\u6216\u8005\u628a\u6587\u4ef6\u653e\u5728\u6b64\u5904",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "\u4e0a\u4f20",
            "dxFileUploader-uploaded": "\u5df2\u4e0a\u4f20",
            "dxFileUploader-readyToUpload": "\u51c6\u5907\u4e0a\u4f20",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "\u4e0a\u4f20\u5931\u8d25",
            "dxFileUploader-invalidFileExtension": "\u6587\u4ef6\u7c7b\u578b\u9519\u8bef",
            "dxFileUploader-invalidMaxFileSize": "\u6587\u4ef6\u8fc7\u5927",
            "dxFileUploader-invalidMinFileSize": "\u6587\u4ef6\u8fc7\u5c0f",
            "dxRangeSlider-ariaFrom": "\u4ece",
            "dxRangeSlider-ariaTill": "\u81f3",
            "dxSwitch-switchedOnText": "\u5f00",
            "dxSwitch-switchedOffText": "\u5173",
            "dxForm-optionalMark": "\u53ef\u9009",
            "dxForm-requiredMessage": "{0} \u662f\u5fc5\u987b\u7684",
            "dxNumberBox-invalidValueMessage": "\u503c\u5fc5\u987b\u662f\u4e00\u4e2a\u6570\u5b57",
            "dxNumberBox-noDataText": "\u65e0\u6570\u636e",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "\u5217\u9009\u62e9\u5668",
            "dxDataGrid-columnChooserEmptyText": "\u5728\u8fd9\u91cc\u62d6\u52a8\u4e00\u5217\u9690\u85cf\u5b83",
            "dxDataGrid-groupContinuesMessage": "\u4e0b\u4e00\u9875",
            "dxDataGrid-groupContinuedMessage": "\u4e0a\u4e00\u9875",
            "dxDataGrid-groupHeaderText": "\u901a\u8fc7\u8be5\u5217\u5206\u7ec4",
            "dxDataGrid-ungroupHeaderText": "\u53d6\u6d88\u5206\u7ec4",
            "dxDataGrid-ungroupAllText": "\u53d6\u6d88\u6240\u6709\u5206\u7ec4",
            "dxDataGrid-editingEditRow": "\u7f16\u8f91",
            "dxDataGrid-editingSaveRowChanges": "\u4fdd\u5b58",
            "dxDataGrid-editingCancelRowChanges": "\u53d6\u6d88",
            "dxDataGrid-editingDeleteRow": "\u5220\u9664",
            "dxDataGrid-editingUndeleteRow": "\u53d6\u6d88\u5220\u9664",
            "dxDataGrid-editingConfirmDeleteMessage": "\u4f60\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u6761\u8bb0\u5f55\u5417\uff1f",
            "dxDataGrid-validationCancelChanges": "\u53d6\u6d88\u66f4\u6539",
            "dxDataGrid-groupPanelEmptyText": "\u62d6\u52a8\u5217\u6807\u9898\u81f3\u6b64\u4ee5\u8fdb\u884c\u5217\u5206\u7ec4",
            "dxDataGrid-noDataText": "\u65e0\u6570\u636e",
            "dxDataGrid-searchPanelPlaceholder": "\u641c\u7d22...",
            "dxDataGrid-filterRowShowAllText": "(\u5168\u90e8)",
            "dxDataGrid-filterRowResetOperationText": "\u91cd\u7f6e",
            "dxDataGrid-filterRowOperationEquals": "\u7b49\u4e8e",
            "dxDataGrid-filterRowOperationNotEquals": "\u4e0d\u7b49\u4e8e",
            "dxDataGrid-filterRowOperationLess": "\u5c0f\u4e8e",
            "dxDataGrid-filterRowOperationLessOrEquals": "\u5c0f\u4e8e\u6216\u7b49\u4e8e",
            "dxDataGrid-filterRowOperationGreater": "\u5927\u4e8e",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "\u5927\u4e8e\u6216\u7b49\u4e8e",
            "dxDataGrid-filterRowOperationStartsWith": "\u4ee5...\u5f00\u59cb",
            "dxDataGrid-filterRowOperationContains": "\u5305\u542b",
            "dxDataGrid-filterRowOperationNotContains": "\u4e0d\u5305\u542b",
            "dxDataGrid-filterRowOperationEndsWith": "\u7ed3\u675f\u4e8e",
            "dxDataGrid-filterRowOperationBetween": "\u4e4b\u95f4",
            "dxDataGrid-filterRowOperationBetweenStartText": "\u5f00\u59cb",
            "dxDataGrid-filterRowOperationBetweenEndText": "\u7ed3\u675f",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "\u5e94\u7528\u8fc7\u6ee4\u5668",
            "dxDataGrid-trueText": "\u771f",
            "dxDataGrid-falseText": "\u5047",
            "dxDataGrid-sortingAscendingText": "\u5347\u5e8f\u6392\u5e8f",
            "dxDataGrid-sortingDescendingText": "\u964d\u5e8f\u6392\u5e8f",
            "dxDataGrid-sortingClearText": "\u6e05\u9664\u6392\u5e8f",
            "dxDataGrid-editingSaveAllChanges": "\u4fdd\u5b58\u4fee\u6539",
            "dxDataGrid-editingCancelAllChanges": "\u653e\u5f03\u4fee\u6539",
            "dxDataGrid-editingAddRow": "\u6dfb\u52a0\u4e00\u884c",
            "dxDataGrid-summaryMin": "\u6700\u5c0f\u503c: {0}",
            "dxDataGrid-summaryMinOtherColumn": "{1} \u7684\u6700\u5c0f\u503c\u4e3a {0}",
            "dxDataGrid-summaryMax": "\u6700\u5927\u503c: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "{1} \u7684\u6700\u5927\u503c\u4e3a {0}",
            "dxDataGrid-summaryAvg": "\u5e73\u5747\u503c: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "{1} \u7684\u5e73\u5747\u503c\u4e3a {0}",
            "dxDataGrid-summarySum": "\u603b\u548c: {0}",
            "dxDataGrid-summarySumOtherColumn": "{1} \u7684\u603b\u548c\u4e3a {0}",
            "dxDataGrid-summaryCount": "\u8ba1\u6570: {0}",
            "dxDataGrid-columnFixingFix": "\u56fa\u5b9a",
            "dxDataGrid-columnFixingUnfix": "\u4e0d\u56fa\u5b9a",
            "dxDataGrid-columnFixingLeftPosition": "\u5411\u5de6",
            "dxDataGrid-columnFixingRightPosition": "\u5411\u53f3",
            "dxDataGrid-exportTo": "\u5bfc\u51fa",
            "dxDataGrid-exportToExcel": "\u5bfc\u51faExcel\u6587\u4ef6",
            "dxDataGrid-exporting": "\u5bfc\u51fa...",
            "dxDataGrid-excelFormat": "Excel\u6587\u4ef6",
            "dxDataGrid-selectedRows": "\u5df2\u9009\u884c",
            "dxDataGrid-exportSelectedRows": "\u5bfc\u51fa\u5df2\u9009\u884c",
            "dxDataGrid-exportAll": "\u5bfc\u51fa\u6240\u6709\u6570\u636e",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(\u7a7a\u767d)",
            "dxDataGrid-headerFilterOK": "\u597d",
            "dxDataGrid-headerFilterCancel": "\u53d6\u6d88",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "\u5217",
            "dxDataGrid-ariaValue": "\u503c",
            "dxDataGrid-ariaFilterCell": "\u8fc7\u6ee4\u5355\u5143",
            "dxDataGrid-ariaCollapse": "\u6298\u53e0",
            "dxDataGrid-ariaExpand": "\u5c55\u5f00",
            "dxDataGrid-ariaDataGrid": "\u6570\u636e\u7f51\u683c",
            "dxDataGrid-ariaSearchInGrid": "\u5728\u6570\u636e\u7f51\u683c\u4e2d\u641c\u7d22",
            "dxDataGrid-ariaSelectAll": "\u5168\u9009",
            "dxDataGrid-ariaSelectRow": "\u9009\u62e9\u884c",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "\u8fc7\u6ee4\u5668\u751f\u6210\u5668",
            "dxDataGrid-filterPanelCreateFilter": "\u521b\u5efa\u8fc7\u6ee4\u5668",
            "dxDataGrid-filterPanelClearFilter": "\u6e05\u7a7a",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u542f\u7528\u8be5\u8fc7\u6ee4\u5668",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "\u6dfb\u52a0",
            "dxPager-infoText": "\u7b2c{0}\u9875,\u5171{1}\u9875 ({2} \u4e2a\u9879\u76ee)",
            "dxPager-pagesCountText": "\u5230",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "\u5168\u90e8",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "\u5408\u8ba1",
            "dxPivotGrid-total": "{0} \u603b\u8ba1",
            "dxPivotGrid-fieldChooserTitle": "\u5b57\u6bb5\u9009\u62e9\u5668",
            "dxPivotGrid-showFieldChooser": "\u663e\u793a\u5b57\u6bb5\u9009\u62e9\u5668",
            "dxPivotGrid-expandAll": "\u5168\u90e8\u5c55\u5f00",
            "dxPivotGrid-collapseAll": "\u5168\u90e8\u6298\u53e0",
            "dxPivotGrid-sortColumnBySummary": '\u6309 "{0}" \u5217\u6392\u5e8f',
            "dxPivotGrid-sortRowBySummary": '\u6309 "{0}" \u884c\u6392\u5e8f',
            "dxPivotGrid-removeAllSorting": "\u6e05\u9664\u6240\u6709\u6392\u5e8f",
            "dxPivotGrid-dataNotAvailable": "\u4e0d\u9002\u7528",
            "dxPivotGrid-rowFields": "\u884c\u5b57\u6bb5",
            "dxPivotGrid-columnFields": "\u5217\u5b57\u6bb5",
            "dxPivotGrid-dataFields": "\u6570\u636e\u5b57\u6bb5",
            "dxPivotGrid-filterFields": "\u8fc7\u6ee4\u5b57\u6bb5",
            "dxPivotGrid-allFields": "\u6240\u6709\u5b57\u6bb5",
            "dxPivotGrid-columnFieldArea": "\u5c06\u5217\u62d6\u52a8\u5230\u6b64\u5904",
            "dxPivotGrid-dataFieldArea": "\u5c06\u6570\u636e\u62d6\u52a8\u5230\u6b64\u5904",
            "dxPivotGrid-rowFieldArea": "\u5c06\u884c\u5b57\u6bb5\u62d6\u5230\u5230\u6b64\u6b21",
            "dxPivotGrid-filterFieldArea": "\u62d6\u52a8\u7b5b\u9009\u5b57\u6bb5\u5230\u6b64\u5904",
            "dxScheduler-editorLabelTitle": "\u6807\u9898",
            "dxScheduler-editorLabelStartDate": "\u5f00\u59cb\u65e5\u671f",
            "dxScheduler-editorLabelEndDate": "\u7ed3\u675f\u65e5\u671f",
            "dxScheduler-editorLabelDescription": "\u63cf\u8ff0",
            "dxScheduler-editorLabelRecurrence": "\u91cd\u590d",
            "dxScheduler-openAppointment": "\u6253\u5f00\u65e5\u7a0b",
            "dxScheduler-recurrenceNever": "\u6c38\u4e0d",
            "dxScheduler-recurrenceMinutely": "Minutely",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "\u65e5\u5e38",
            "dxScheduler-recurrenceWeekly": "\u6bcf\u5468",
            "dxScheduler-recurrenceMonthly": "\u6bcf\u6708",
            "dxScheduler-recurrenceYearly": "\u6bcf\u5e74",
            "dxScheduler-recurrenceRepeatEvery": "\u6240\u6709",
            "dxScheduler-recurrenceRepeatOn": "Repeat On",
            "dxScheduler-recurrenceEnd": "\u505c\u6b62\u91cd\u590d",
            "dxScheduler-recurrenceAfter": "\u4e4b\u540e",
            "dxScheduler-recurrenceOn": "\u5728",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "\u65e5",
            "dxScheduler-recurrenceRepeatWeekly": "\u5468",
            "dxScheduler-recurrenceRepeatMonthly": "\u6708",
            "dxScheduler-recurrenceRepeatYearly": "\u5e74",
            "dxScheduler-switcherDay": "\u65e5",
            "dxScheduler-switcherWeek": "\u5468",
            "dxScheduler-switcherWorkWeek": "\u5de5\u4f5c\u5468",
            "dxScheduler-switcherMonth": "\u6708",
            "dxScheduler-switcherAgenda": "\u8bae\u7a0b",
            "dxScheduler-switcherTimelineDay": "\u65f6\u95f4\u8f74\u65e5",
            "dxScheduler-switcherTimelineWeek": "\u65f6\u95f4\u8f74\u5468",
            "dxScheduler-switcherTimelineWorkWeek": "\u65f6\u95f4\u8f74\u5de5\u4f5c\u5468",
            "dxScheduler-switcherTimelineMonth": "\u65f6\u95f4\u8f74\u6708",
            "dxScheduler-recurrenceRepeatOnDate": "\u4e8e\u65e5\u671f",
            "dxScheduler-recurrenceRepeatCount": "\u4e8b\u4ef6",
            "dxScheduler-allDay": "\u5168\u5929",
            "dxScheduler-confirmRecurrenceEditMessage": "\u4f60\u60f3\u53ea\u4fee\u6539\u8be5\u65e5\u7a0b\u8fd8\u662f\u60f3\u4fee\u6539\u6574\u4e2a\u7cfb\u5217\u7684\u65e5\u7a0b?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "\u4f60\u60f3\u53ea\u5220\u9664\u8fd9\u4e2a\u65e5\u7a0b\u8fd8\u662f\u60f3\u5220\u9664\u6574\u4e2a\u7cfb\u5217\u7684\u65e5\u7a0b?",
            "dxScheduler-confirmRecurrenceEditSeries": "\u4fee\u6539\u8be5\u7cfb\u5217\u7684\u65e5\u7a0b",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u5220\u9664\u8be5\u7cfb\u5217\u7684\u65e5\u7a0b",
            "dxScheduler-confirmRecurrenceEditOccurrence": "\u4fee\u6539\u65e5\u7a0b",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u5220\u9664\u65e5\u7a0b",
            "dxScheduler-noTimezoneTitle": "\u6ca1\u6709\u65f6\u533a",
            "dxScheduler-moreAppointments": "{0} \u66f4\u591a",
            "dxCalendar-todayButtonText": "\u4eca\u5929",
            "dxCalendar-ariaWidgetName": "\u65e5\u5386",
            "dxCalendar-ariaHotKeysInfo": "To navigate between views, press Control, and then Left Arrow or Right Arrow. To zoom in on a view, press Control, and then Down Arrow. To zoom out, press Control, and then Up Arrow.",
            "dxColorView-ariaRed": "\u7ea2\u8272",
            "dxColorView-ariaGreen": "\u7eff\u8272",
            "dxColorView-ariaBlue": "\u84dd\u8272",
            "dxColorView-ariaAlpha": "\u900f\u660e\u5ea6",
            "dxColorView-ariaHex": "\u8272\u6807",
            "dxTagBox-selected": "{0} \u5df2\u9009\u62e9",
            "dxTagBox-allSelected": "\u5df2\u5168\u9009 ({0})",
            "dxTagBox-moreSelected": "{0} \u66f4\u591a",
            "vizExport-printingButtonText": "\u6253\u5370",
            "vizExport-titleMenuText": "\u5bfc\u51fa\u4e2d/\u6253\u5370\u4e2d",
            "vizExport-exportButtonText": "{0} \u6587\u4ef6",
            "dxFilterBuilder-and": "\u4e0e",
            "dxFilterBuilder-or": "\u6216",
            "dxFilterBuilder-notAnd": "\u4e0e\u975e",
            "dxFilterBuilder-notOr": "\u6216\u975e",
            "dxFilterBuilder-addCondition": "\u6dfb\u52a0\u6761\u4ef6",
            "dxFilterBuilder-addGroup": "\u6dfb\u52a0\u7ec4",
            "dxFilterBuilder-enterValueText": "<\u8f93\u5165\u503c>",
            "dxFilterBuilder-filterOperationEquals": "\u7b49\u4e8e",
            "dxFilterBuilder-filterOperationNotEquals": "\u4e0d\u7b49\u4e8e",
            "dxFilterBuilder-filterOperationLess": "\u5c0f\u4e8e",
            "dxFilterBuilder-filterOperationLessOrEquals": "\u5c0f\u4e8e\u6216\u7b49\u4e8e",
            "dxFilterBuilder-filterOperationGreater": "\u5927\u4e8e",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\u5927\u4e8e\u6216\u7b49\u4e8e",
            "dxFilterBuilder-filterOperationStartsWith": "\u5f00\u59cb\u4e8e",
            "dxFilterBuilder-filterOperationContains": "\u5305\u542b",
            "dxFilterBuilder-filterOperationNotContains": "\u4e0d\u5305\u542b",
            "dxFilterBuilder-filterOperationEndsWith": "\u7ed3\u675f\u4e8e",
            "dxFilterBuilder-filterOperationIsBlank": "\u7a7a",
            "dxFilterBuilder-filterOperationIsNotBlank": "\u4e0d\u4e3a\u7a7a",
            "dxFilterBuilder-filterOperationBetween": "\u4e4b\u95f4",
            "dxFilterBuilder-filterOperationAnyOf": "\u4efb\u4f55\u4e00\u4e2a",
            "dxFilterBuilder-filterOperationNoneOf": "\u4efb\u4f55\u4e00\u4e2a\u90fd\u4e0d",
            "dxHtmlEditor-dialogColorCaption": "\u66f4\u6539\u5b57\u4f53\u989c\u8272",
            "dxHtmlEditor-dialogBackgroundCaption": "\u66f4\u6539\u80cc\u666f\u989c\u8272",
            "dxHtmlEditor-dialogLinkCaption": "\u6dfb\u52a0\u94fe\u63a5",
            "dxHtmlEditor-dialogLinkUrlField": "\u94fe\u63a5\u5730\u5740",
            "dxHtmlEditor-dialogLinkTextField": "\u94fe\u63a5\u6587\u5b57",
            "dxHtmlEditor-dialogLinkTargetField": "\u5728\u65b0\u7a97\u53e3\u4e2d\u6253\u5f00",
            "dxHtmlEditor-dialogImageCaption": "\u6dfb\u52a0\u56fe\u7247",
            "dxHtmlEditor-dialogImageUrlField": "\u56fe\u7247\u5730\u5740",
            "dxHtmlEditor-dialogImageAltField": "\u66ff\u4ee3\u6587\u5b57",
            "dxHtmlEditor-dialogImageWidthField": "\u5bbd (px)",
            "dxHtmlEditor-dialogImageHeightField": "\u957f (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "\u884c",
            "dxHtmlEditor-dialogInsertTableColumnsField": "\u5217",
            "dxHtmlEditor-dialogInsertTableCaption": "\u63d2\u5165\u8868\u683c",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "\u6807\u9898",
            "dxHtmlEditor-normalText": "\u6b63\u6587",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "\u5355\u5143\u683c\u5c5e\u6027",
            "dxHtmlEditor-tableProperties": "\u8868\u683c\u5c5e\u6027",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "\u8fb9\u6846",
            "dxHtmlEditor-style": "\u6837\u5f0f",
            "dxHtmlEditor-width": "\u5bbd\u5ea6",
            "dxHtmlEditor-height": "\u9ad8\u5ea6",
            "dxHtmlEditor-borderColor": "\u989c\u8272",
            "dxHtmlEditor-tableBackground": "\u80cc\u666f",
            "dxHtmlEditor-dimensions": "\u5c3a\u5bf8",
            "dxHtmlEditor-alignment": "\u5bf9\u9f50\u65b9\u5f0f",
            "dxHtmlEditor-horizontal": "\u6c34\u5e73\u65b9\u5411",
            "dxHtmlEditor-vertical": "\u5782\u76f4\u65b9\u5411",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxFileManager-newDirectoryName": "Untitled directory",
            "dxFileManager-rootDirectoryName": "Files",
            "dxFileManager-errorNoAccess": "Access Denied. Operation could not be completed.",
            "dxFileManager-errorDirectoryExistsFormat": "Directory '{0}' already exists.",
            "dxFileManager-errorFileExistsFormat": "File '{0}' already exists.",
            "dxFileManager-errorFileNotFoundFormat": "File '{0}' not found.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directory '{0}' not found.",
            "dxFileManager-errorWrongFileExtension": "File extension is not allowed.",
            "dxFileManager-errorMaxFileSizeExceeded": "File size exceeds the maximum allowed size.",
            "dxFileManager-errorInvalidSymbols": "This name contains invalid characters.",
            "dxFileManager-errorDefault": "Unspecified error.",
            "dxFileManager-errorDirectoryOpenFailed": "The directory cannot be opened",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "Copy to",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "Refresh",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "Clear selection",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Move",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copy to",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copy",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "Save",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "Create",
            "dxFileManager-dialogDeleteItemTitle": "Delete",
            "dxFileManager-dialogDeleteItemButtonText": "Delete",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "Cancel",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Name",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "General",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Org Chart",
            "dxDiagram-categoryContainers": "Containers",
            "dxDiagram-categoryCustom": "Custom",
            "dxDiagram-commandExportToSvg": "Export to SVG",
            "dxDiagram-commandExportToPng": "Export to PNG",
            "dxDiagram-commandExportToJpg": "Export to JPEG",
            "dxDiagram-commandUndo": "Undo",
            "dxDiagram-commandRedo": "Redo",
            "dxDiagram-commandFontName": "Font Name",
            "dxDiagram-commandFontSize": "Font Size",
            "dxDiagram-commandBold": "Bold",
            "dxDiagram-commandItalic": "Italic",
            "dxDiagram-commandUnderline": "Underline",
            "dxDiagram-commandTextColor": "Font Color",
            "dxDiagram-commandLineColor": "Line Color",
            "dxDiagram-commandLineWidth": "Line Width",
            "dxDiagram-commandLineStyle": "Line Style",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Dotted",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "Fill Color",
            "dxDiagram-commandAlignLeft": "Align Left",
            "dxDiagram-commandAlignCenter": "Align Center",
            "dxDiagram-commandAlignRight": "Align Right",
            "dxDiagram-commandConnectorLineType": "Connector Line Type",
            "dxDiagram-commandConnectorLineStraight": "Straight",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonal",
            "dxDiagram-commandConnectorLineStart": "Connector Line Start",
            "dxDiagram-commandConnectorLineEnd": "Connector Line End",
            "dxDiagram-commandConnectorLineNone": "None",
            "dxDiagram-commandConnectorLineArrow": "Arrow",
            "dxDiagram-commandFullscreen": "Full Screen",
            "dxDiagram-commandUnits": "Units",
            "dxDiagram-commandPageSize": "Page Size",
            "dxDiagram-commandPageOrientation": "Page Orientation",
            "dxDiagram-commandPageOrientationLandscape": "Landscape",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Page Color",
            "dxDiagram-commandShowGrid": "Show Grid",
            "dxDiagram-commandSnapToGrid": "Snap to Grid",
            "dxDiagram-commandGridSize": "Grid Size",
            "dxDiagram-commandZoomLevel": "Zoom Level",
            "dxDiagram-commandAutoZoom": "Auto Zoom",
            "dxDiagram-commandFitToContent": "Fit to Content",
            "dxDiagram-commandFitToWidth": "Fit to Width",
            "dxDiagram-commandAutoZoomByContent": "Auto Zoom by Content",
            "dxDiagram-commandAutoZoomByWidth": "Auto Zoom by Width",
            "dxDiagram-commandSimpleView": "Simple View",
            "dxDiagram-commandCut": "Cut",
            "dxDiagram-commandCopy": "Copy",
            "dxDiagram-commandPaste": "Paste",
            "dxDiagram-commandSelectAll": "Select All",
            "dxDiagram-commandDelete": "Delete",
            "dxDiagram-commandBringToFront": "Bring to Front",
            "dxDiagram-commandSendToBack": "Send to Back",
            "dxDiagram-commandLock": "Lock",
            "dxDiagram-commandUnlock": "Unlock",
            "dxDiagram-commandInsertShapeImage": "Insert Image...",
            "dxDiagram-commandEditShapeImage": "Change Image...",
            "dxDiagram-commandDeleteShapeImage": "Delete Image",
            "dxDiagram-commandLayoutLeftToRight": "Left-to-right",
            "dxDiagram-commandLayoutRightToLeft": "Right-to-left",
            "dxDiagram-commandLayoutTopToBottom": "Top-to-bottom",
            "dxDiagram-commandLayoutBottomToTop": "Bottom-to-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Cancel",
            "dxDiagram-dialogInsertShapeImageTitle": "Insert Image",
            "dxDiagram-dialogEditShapeImageTitle": "Change Image",
            "dxDiagram-dialogEditShapeImageSelectButton": "Select image",
            "dxDiagram-dialogEditShapeImageLabelText": "or drop a file here",
            "dxDiagram-uiExport": "Export",
            "dxDiagram-uiProperties": "Properties",
            "dxDiagram-uiSettings": "Settings",
            "dxDiagram-uiShowToolbox": "Show Toolbox",
            "dxDiagram-uiSearch": "Search",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tree",
            "dxDiagram-uiLayoutLayered": "Layered",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "Page",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Cross",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamond",
            "dxDiagram-shapeHeart": "Heart",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Star",
            "dxDiagram-shapeArrowLeft": "Left Arrow",
            "dxDiagram-shapeArrowUp": "Up Arrow",
            "dxDiagram-shapeArrowRight": "Right Arrow",
            "dxDiagram-shapeArrowDown": "Down Arrow",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "Left Right Arrow",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Decision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Predefined Process",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Multiple Documents",
            "dxDiagram-shapeManualInput": "Manual Input",
            "dxDiagram-shapePreparation": "Preparation",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Internal Storage",
            "dxDiagram-shapePaperTape": "Paper Tape",
            "dxDiagram-shapeManualOperation": "Manual Operation",
            "dxDiagram-shapeDelay": "Delay",
            "dxDiagram-shapeStoredData": "Stored Data",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "Merge",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "Or",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertical Container",
            "dxDiagram-shapeHorizontalContainer": "Horizontal Container",
            "dxDiagram-shapeCardDefaultText": "Person's Name",
            "dxDiagram-shapeCardWithImageOnLeft": "Card with Image on the Left",
            "dxDiagram-shapeCardWithImageOnTop": "Card with Image on the Top",
            "dxDiagram-shapeCardWithImageOnRight": "Card with Image on the Right",
            "dxGantt-dialogTitle": "Title",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "Add",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resources: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Undo",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "Expand All",
            "dxGantt-collapseAll": "Collapse All",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "Zoom In",
            "dxGantt-zoomOut": "Zoom Out",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "\u5347\u5e8f\u6392\u5e8f",
            "dxGantt-sortingDescendingText": "\u964d\u5e8f\u6392\u5e8f",
            "dxGantt-sortingClearText": "\u6e05\u9664\u6392\u5e8f",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}"
        }
    })
}));
