/*!
* DevExtreme (dx.messages.fa.js)
* Version: 23.1.6
* Build date: Fri Oct 13 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        fa: {
            Yes: "\u0628\u0644\u06cc",
            No: "\u062e\u06cc\u0631",
            Cancel: "\u0644\u063a\u0648",
            Close: "Close",
            Clear: "\u062d\u0630\u0641",
            Done: "\u062a\u0627\u06cc\u06cc\u062f",
            Loading: "\u062f\u0631 \u062d\u0627\u0644 \u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc...",
            Select: "\u0627\u0646\u062a\u062e\u0627\u0628...",
            Search: "\u062c\u0633\u062a\u062c\u0648",
            Back: "\u0628\u0627\u0632\u06af\u0634\u062a",
            OK: "\u062a\u0627\u06cc\u06cc\u062f",
            "dxCollectionWidget-noDataText": "(\u062f\u0627\u062f\u0647 \u0627\u06cc \u0628\u0631\u0627\u06cc \u0646\u0645\u0627\u06cc\u0634 \u0645\u0648\u062c\u0648\u062f \u0646\u0645\u06cc \u0628\u0627\u0634\u062f)",
            "dxDropDownEditor-selectLabel": "\u0627\u0646\u062a\u062e\u0627\u0628",
            "validation-required": "\u0627\u062c\u0628\u0627\u0631\u06cc",
            "validation-required-formatted": "{0} \u0627\u062c\u0628\u0627\u0631\u06cc \u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-numeric": "\u0645\u0642\u062f\u0627\u0631 \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0639\u062f\u062f \u0628\u0627\u0634\u062f",
            "validation-numeric-formatted": "{0} \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0639\u062f\u062f\u06cc \u0628\u0627\u0634\u062f",
            "validation-range": "\u0645\u0642\u062f\u0627\u0631 \u062e\u0627\u0631\u062c \u0627\u0632 \u0645\u062d\u062f\u0648\u062f\u0647 \u0645\u062c\u0627\u0632 \u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-range-formatted": "{0} \u062e\u0627\u0631\u062c \u0627\u0632 \u0645\u062d\u062f\u0648\u062f\u0647 \u0645\u062c\u0627\u0632 \u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-stringLength": "\u0637\u0648\u0644 \u0639\u0628\u0627\u0631\u062a \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-stringLength-formatted": "\u0637\u0648\u0644 {0} \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-custom": "\u0645\u0642\u062f\u0627\u0631 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0645\u0639\u062a\u0628\u0631 \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-custom-formatted": "{0} \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a",
            "validation-async": "\u0645\u0642\u062f\u0627\u0631 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-async-formatted": "{0} \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-compare": "\u0645\u0642\u0627\u062f\u06cc\u0631 \u0647\u0645\u062e\u0648\u0627\u0646\u06cc \u0646\u062f\u0627\u0631\u062f",
            "validation-compare-formatted": "{0} \u0647\u0645\u062e\u0648\u0627\u0646\u06cc \u0646\u062f\u0627\u0631\u062f",
            "validation-pattern": "\u0645\u0642\u062f\u0627\u0631 \u0645\u0637\u0627\u0628\u0642 \u0627\u0644\u06af\u0648 \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-pattern-formatted": "{0} \u0645\u0637\u0627\u0628\u0642 \u0627\u0644\u06af\u0648 \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-email": "\u0627\u06cc\u0645\u06cc\u0644 \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-email-formatted": "{0} \u0635\u062d\u06cc\u062d \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "validation-mask": "\u0645\u0642\u062f\u0627\u0631 \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a",
            "dxLookup-searchPlaceholder": "\u062d\u062f\u0627\u0642\u0644 \u062a\u0639\u062f\u0627\u062f \u06a9\u0627\u0631\u0627\u06a9\u062a\u0631: {0}",
            "dxList-pullingDownText": "\u0628\u0631\u0627\u06cc \u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 \u0628\u0647 \u067e\u0627\u06cc\u06cc\u0646 \u0628\u06a9\u0634\u06cc\u062f ...",
            "dxList-pulledDownText": "\u0627\u0646\u062a\u0634\u0627\u0631 \u0628\u0631\u0627\u06cc \u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 ...",
            "dxList-refreshingText": "\u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 ...",
            "dxList-pageLoadingText": "\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc...",
            "dxList-nextButtonText": "\u0628\u06cc\u0634\u062a\u0631",
            "dxList-selectAll": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0647\u0645\u0647",
            "dxListEditDecorator-delete": "\u062d\u0630\u0641",
            "dxListEditDecorator-more": "\u0628\u06cc\u0634\u062a\u0631",
            "dxScrollView-pullingDownText": "\u0628\u0631\u0627\u06cc \u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 \u0628\u0647 \u067e\u0627\u06cc\u06cc\u0646 \u0628\u06a9\u0634\u06cc\u062f ...",
            "dxScrollView-pulledDownText": "\u0627\u0646\u062a\u0634\u0627\u0631 \u0628\u0631\u0627\u06cc \u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 ...",
            "dxScrollView-refreshingText": "\u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646 ...",
            "dxScrollView-reachBottomText": "\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc...",
            "dxDateBox-simulatedDataPickerTitleTime": "\u0632\u0645\u0627\u0646 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u0646\u0645\u0627\u06cc\u06cc\u062f",
            "dxDateBox-simulatedDataPickerTitleDate": "\u062a\u0627\u0631\u06cc\u062e \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u0646\u0645\u0627\u06cc\u06cc\u062f",
            "dxDateBox-simulatedDataPickerTitleDateTime": "\u062a\u0627\u0631\u06cc\u062e \u0648 \u0632\u0645\u0627\u0646 \u0631\u0627 \u0627\u0646\u062a\u062e\u0627\u0628 \u0646\u0645\u0627\u06cc\u06cc\u062f",
            "dxDateBox-validation-datetime": "\u0645\u0642\u062f\u0627\u0631 \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u062a\u0627\u0631\u06cc\u062e \u0648 \u0632\u0645\u0627\u0646 \u0628\u0627\u0634\u062f",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Start Date",
            "dxDateRangeBox-endDateLabel": "End Date",
            "dxFileUploader-selectFile": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0641\u0627\u06cc\u0644",
            "dxFileUploader-dropFile": "\u0627\u06cc\u0646\u062c\u0627 \u062f\u0631\u06af \u0646\u0645\u0627\u06cc\u06cc\u062f",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "\u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc",
            "dxFileUploader-uploaded": "\u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc \u0634\u062f",
            "dxFileUploader-readyToUpload": "\u0622\u0645\u0627\u062f\u0647 \u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc",
            "dxFileUploader-uploadAbortedMessage": "\u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc \u0644\u063a\u0648 \u0634\u062f",
            "dxFileUploader-uploadFailedMessage": "\u062e\u0637\u0627 \u062f\u0631 \u0628\u0627\u0631\u06af\u0632\u0627\u0631\u06cc",
            "dxFileUploader-invalidFileExtension": "\u0641\u0627\u06cc\u0644 \u0627\u0646\u062a\u062e\u0627\u0628\u06cc \u0645\u062c\u0627\u0632 \u0646\u0645\u06cc \u0628\u0627\u0634\u062f",
            "dxFileUploader-invalidMaxFileSize": "\u0641\u0627\u06cc\u0644 \u062d\u062c\u0645 \u0628\u06cc\u0634\u062a\u0631\u06cc \u0627\u0632 \u0645\u0642\u062f\u0627\u0631 \u0645\u062c\u0627\u0632 \u062f\u0627\u0631\u062f",
            "dxFileUploader-invalidMinFileSize": "\u0641\u0627\u06cc\u0644 \u062d\u062c\u0645 \u06a9\u0645\u062a\u0631\u06cc \u0627\u0632 \u0645\u0642\u062f\u0627\u0631 \u0645\u062c\u0627\u0632 \u062f\u0627\u0631\u062f",
            "dxRangeSlider-ariaFrom": "\u0627\u0632",
            "dxRangeSlider-ariaTill": "\u062a\u0627",
            "dxSwitch-switchedOnText": "\u0641\u0639\u0627\u0644",
            "dxSwitch-switchedOffText": "\u063a\u06cc\u0631\u0641\u0639\u0627\u0644",
            "dxForm-optionalMark": "optional",
            "dxForm-requiredMessage": "{0} \u0627\u062c\u0628\u0627\u0631\u06cc \u0645\u06cc \u0628\u0627\u0634\u062f",
            "dxNumberBox-invalidValueMessage": "\u0645\u0642\u062f\u0627\u0631 \u0648\u0627\u0631\u062f \u0634\u062f\u0647 \u0645\u06cc \u0628\u0627\u06cc\u0633\u062a \u0639\u062f\u062f \u0628\u0627\u0634\u062f",
            "dxNumberBox-noDataText": "(\u0628\u062f\u0648\u0646 \u062f\u0627\u062f\u0647)",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "\u0627\u0646\u062a\u062e\u0628 \u0633\u062a\u0648\u0646",
            "dxDataGrid-columnChooserEmptyText": "\u0628\u0631\u0627\u06cc \u0639\u062f\u0645 \u0646\u0645\u0627\u06cc\u0634 \u0633\u062a\u0648\u0646\u060c \u0633\u062a\u0648\u0646 \u0631\u0627 \u0628\u0647 \u0627\u06cc\u0646 \u0642\u0633\u0645\u062a \u0628\u06a9\u0634\u06cc\u062f",
            "dxDataGrid-groupContinuesMessage": "\u0627\u062f\u0627\u0645\u0647 \u062f\u0631 \u0635\u0641\u062d\u0647 \u0628\u0639\u062f",
            "dxDataGrid-groupContinuedMessage": "\u0627\u062f\u0627\u0645\u0647 \u0627\u0632 \u0635\u0641\u062d\u0647 \u0642\u0628\u0644",
            "dxDataGrid-groupHeaderText": "\u06af\u0631\u0648\u0647 \u0628\u0646\u062f\u06cc \u0628\u0627 \u0633\u062a\u0648\u0646 \u062c\u0627\u0631\u06cc",
            "dxDataGrid-ungroupHeaderText": "\u062d\u0630\u0641 \u06af\u0631\u0648\u0647",
            "dxDataGrid-ungroupAllText": "\u062d\u0630\u0641 \u06a9\u0644\u06cc\u0647 \u06af\u0631\u0648\u0647 \u0647\u0627",
            "dxDataGrid-editingEditRow": "\u0648\u06cc\u0631\u0627\u06cc\u0634",
            "dxDataGrid-editingSaveRowChanges": "\u062b\u0628\u062a",
            "dxDataGrid-editingCancelRowChanges": "\u0644\u063a\u0648",
            "dxDataGrid-editingDeleteRow": "\u062d\u0630\u0641",
            "dxDataGrid-editingUndeleteRow": "\u0628\u0627\u0632\u06af\u0634\u062a \u062d\u0630\u0641",
            "dxDataGrid-editingConfirmDeleteMessage": "\u0622\u06cc\u0627 \u0645\u0627\u06cc\u0644 \u0628\u0647 \u062d\u0630\u0641 \u0622\u06cc\u062a\u0645 \u0627\u0646\u062a\u062e\u0627\u0628\u06cc \u0645\u06cc \u0628\u0627\u0634\u06cc\u062f?",
            "dxDataGrid-validationCancelChanges": "\u0644\u063a\u0648 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a",
            "dxDataGrid-groupPanelEmptyText": "\u062c\u0647\u062a \u06af\u0631\u0648\u0647 \u0628\u0646\u062f\u06cc \u0633\u062a\u0648\u0646 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0631\u0627 \u0628\u0627 \u0645\u0627\u0648\u0633 \u0628\u0647 \u0627\u06cc\u0646 \u0642\u0633\u0645\u062a \u0628\u06a9\u0634\u06cc\u062f",
            "dxDataGrid-noDataText": "\u0627\u0637\u0644\u0627\u0639\u0627\u062a\u06cc \u06cc\u0627\u0641\u062a \u0646\u0634\u062f",
            "dxDataGrid-searchPanelPlaceholder": "\u062c\u0633\u062a\u062c\u0648...",
            "dxDataGrid-filterRowShowAllText": "(\u0647\u0645\u0647)",
            "dxDataGrid-filterRowResetOperationText": "\u0634\u0631\u0648\u0639 \u0645\u062c\u062f\u062f",
            "dxDataGrid-filterRowOperationEquals": "\u0628\u0631\u0627\u0628\u0631",
            "dxDataGrid-filterRowOperationNotEquals": "\u0646\u0627\u0628\u0631\u0627\u0628\u0631",
            "dxDataGrid-filterRowOperationLess": "\u06a9\u0648\u0686\u06a9\u062a\u0631 \u0627\u0632",
            "dxDataGrid-filterRowOperationLessOrEquals": "\u06a9\u0648\u0686\u06a9\u062a\u0631 \u06cc\u0627 \u0645\u0633\u0627\u0648\u06cc \u0628\u0627",
            "dxDataGrid-filterRowOperationGreater": "\u0628\u0632\u0631\u06af\u062a\u0631 \u0627\u0632",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "\u0628\u0632\u0631\u06af\u062a\u0631 \u06cc\u0627 \u0645\u0633\u0627\u0648\u06cc \u0628\u0627",
            "dxDataGrid-filterRowOperationStartsWith": "\u0634\u0631\u0648\u0639 \u0628\u0627",
            "dxDataGrid-filterRowOperationContains": "\u0634\u0627\u0645\u0644",
            "dxDataGrid-filterRowOperationNotContains": "\u0634\u0627\u0645\u0644 \u0646\u0628\u0648\u062f\u0646",
            "dxDataGrid-filterRowOperationEndsWith": "\u067e\u0627\u06cc\u0627\u0646 \u0628\u0627",
            "dxDataGrid-filterRowOperationBetween": "\u0628\u06cc\u0646",
            "dxDataGrid-filterRowOperationBetweenStartText": "\u0634\u0631\u0648\u0639",
            "dxDataGrid-filterRowOperationBetweenEndText": "\u067e\u0627\u06cc\u0627\u0646",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "\u0627\u0639\u0645\u0627\u0644 \u0641\u06cc\u0644\u062a\u0631",
            "dxDataGrid-trueText": "\u0628\u0644\u06cc",
            "dxDataGrid-falseText": "\u062e\u06cc\u0631",
            "dxDataGrid-sortingAscendingText": "\u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc",
            "dxDataGrid-sortingDescendingText": "\u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc \u0645\u0639\u06a9\u0648\u0633",
            "dxDataGrid-sortingClearText": "\u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc \u067e\u06cc\u0634\u0641\u0631\u0636",
            "dxDataGrid-editingSaveAllChanges": "\u062b\u0628\u062a \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a",
            "dxDataGrid-editingCancelAllChanges": "\u0644\u063a\u0648 \u062a\u063a\u06cc\u06cc\u0631\u0627\u062a",
            "dxDataGrid-editingAddRow": "\u0627\u0641\u0632\u0648\u062f\u0646 \u0633\u0637\u0631",
            "dxDataGrid-summaryMin": "\u062d\u062f\u0627\u0642\u0644: {0}",
            "dxDataGrid-summaryMinOtherColumn": "\u062d\u062f\u0627\u0642\u0644 \u0645\u0642\u0627\u062f\u06cc\u0631 {1} \u0628\u0631\u0627\u0628\u0631 \u0628\u0627 {0}",
            "dxDataGrid-summaryMax": "\u062d\u062f\u0627\u06a9\u062b\u0631: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "\u062d\u062f\u0627\u06a9\u062b\u0631 \u0645\u0642\u0627\u062f\u06cc\u0631 {1} \u0628\u0631\u0627\u0628\u0631 \u0628\u0627 {0}",
            "dxDataGrid-summaryAvg": "\u0645\u06cc\u0627\u0646\u06af\u06cc\u0646: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "\u0645\u06cc\u0627\u0646\u06af\u06cc\u0646 \u0645\u0642\u0627\u062f\u06cc\u0631 {1} \u0628\u0631\u0627\u0628\u0631 \u0628\u0627 {0}",
            "dxDataGrid-summarySum": "\u062c\u0645\u0639: {0}",
            "dxDataGrid-summarySumOtherColumn": "\u062c\u0645\u0639 \u0645\u0642\u0627\u062f\u06cc\u0631 {1} \u0628\u0631\u0627\u0628\u0631 \u0628\u0627 {0}",
            "dxDataGrid-summaryCount": "\u062a\u0639\u062f\u0627\u062f: {0}",
            "dxDataGrid-columnFixingFix": "\u0633\u0627\u06cc\u0632 \u062b\u0627\u0628\u062a",
            "dxDataGrid-columnFixingUnfix": "\u0633\u0627\u06cc\u0632 \u0634\u0646\u0627\u0648\u0631",
            "dxDataGrid-columnFixingLeftPosition": "\u0646\u0645\u0627\u06cc\u0634 \u0627\u0632 \u0686\u067e",
            "dxDataGrid-columnFixingRightPosition": "\u0646\u0645\u0627\u06cc\u0634 \u0627\u0632 \u0631\u0627\u0633\u062a",
            "dxDataGrid-exportTo": "\u0627\u06cc\u062c\u0627\u062f \u0641\u0627\u06cc\u0644",
            "dxDataGrid-exportToExcel": "\u0627\u06cc\u062c\u0627\u062f \u0641\u0627\u06cc\u0644 \u0627\u06a9\u0633\u0644",
            "dxDataGrid-exporting": "\u062f\u0631 \u062d\u0627\u0644 \u0627\u06cc\u062c\u0627\u062f \u0641\u0627\u06cc\u0644...",
            "dxDataGrid-excelFormat": "\u0641\u0627\u06cc\u0644 \u0627\u06a9\u0633\u0644",
            "dxDataGrid-selectedRows": "\u0633\u0637\u0631\u0647\u0627\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u06cc",
            "dxDataGrid-exportSelectedRows": "\u0633\u0637\u0631\u0647\u0627\u06cc \u0627\u0646\u062a\u062e\u0627\u0628\u06cc",
            "dxDataGrid-exportAll": "\u06a9\u0644\u06cc\u0647 \u062f\u0627\u062f\u0647 \u0647\u0627",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(\u062e\u0627\u0644\u06cc)",
            "dxDataGrid-headerFilterOK": "\u062a\u0627\u06cc\u06cc\u062f",
            "dxDataGrid-headerFilterCancel": "\u0644\u063a\u0648",
            "dxDataGrid-ariaAdaptiveCollapse": "\u0639\u062f\u0645 \u0646\u0645\u0627\u06cc\u0634 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u062a\u06a9\u0645\u06cc\u0644\u06cc",
            "dxDataGrid-ariaAdaptiveExpand": "\u0646\u0645\u0627\u06cc\u0634 \u0627\u0637\u0644\u0627\u0639\u0627\u062a \u062a\u06a9\u0645\u06cc\u0644\u06cc",
            "dxDataGrid-ariaColumn": "\u0633\u062a\u0648\u0646",
            "dxDataGrid-ariaValue": "\u0645\u0642\u062f\u0627\u0631",
            "dxDataGrid-ariaFilterCell": "\u0641\u06cc\u0644\u062a\u0631 \u0633\u0644\u0648\u0644",
            "dxDataGrid-ariaCollapse": "\u0639\u062f\u0645 \u0646\u0645\u0627\u06cc\u0634",
            "dxDataGrid-ariaExpand": "\u0646\u0645\u0627\u06cc\u0634",
            "dxDataGrid-ariaDataGrid": "\u062c\u062f\u0648\u0644",
            "dxDataGrid-ariaSearchInGrid": "\u062c\u0633\u062a\u062c\u0648",
            "dxDataGrid-ariaSelectAll": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0647\u0645\u0647",
            "dxDataGrid-ariaSelectRow": "\u0627\u0646\u062a\u062e\u0628 \u0633\u0637\u0631",
            "dxDataGrid-ariaToolbar": "\u0646\u0648\u0627\u0631 \u0627\u0628\u0632\u0627\u0631",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "\u0641\u06cc\u0644\u062a\u0631",
            "dxDataGrid-filterPanelCreateFilter": "\u0627\u06cc\u062c\u0627\u062f \u0641\u06cc\u0644\u062a\u0631",
            "dxDataGrid-filterPanelClearFilter": "\u062d\u0630\u0641 \u0641\u06cc\u0644\u062a\u0631",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u0641\u0639\u0627\u0644 \u0646\u0645\u0648\u062f\u0646 \u0641\u06cc\u0644\u062a\u0631",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "\u062c\u0633\u062a\u062c\u0648 \u062f\u0631 \u0644\u06cc\u0633\u062a \u062f\u0631\u062e\u062a\u06cc",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "\u0627\u0641\u0632\u0648\u062f\u0646",
            "dxPager-infoText": "\u0635\u0641\u062d\u0647 {0} \u0627\u0632 {1} ({2} \u0622\u06cc\u062a\u0645)",
            "dxPager-pagesCountText": "\u0627\u0632",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "\u0647\u0645\u0647",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "\u062c\u0645\u0639 \u06a9\u0644",
            "dxPivotGrid-total": "\u062c\u0645\u0639 {0}",
            "dxPivotGrid-fieldChooserTitle": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0641\u06cc\u0644\u062f",
            "dxPivotGrid-showFieldChooser": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0641\u06cc\u0644\u062f",
            "dxPivotGrid-expandAll": "\u0646\u0645\u0627\u06cc\u0634 \u06a9\u0644\u06cc\u0647 \u0632\u06cc\u0631\u0645\u062c\u0645\u0648\u0639\u0647 \u0647\u0627",
            "dxPivotGrid-collapseAll": "\u0639\u062f\u0645 \u0646\u0645\u0627\u06cc\u0634 \u0632\u06cc\u0631\u0645\u062c\u0645\u0648\u0639\u0647 \u0647\u0627",
            "dxPivotGrid-sortColumnBySummary": '\u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc "{0}" \u0645\u0637\u0627\u0628\u0642 \u0628\u0627 \u0627\u06cc\u0646 \u0633\u062a\u0648\u0646',
            "dxPivotGrid-sortRowBySummary": '\u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc "{0}" \u0645\u0637\u0627\u0628\u0642 \u0628\u0627 \u0627\u06cc\u0646 \u0633\u0637\u0631',
            "dxPivotGrid-removeAllSorting": "\u062d\u0630\u0641 \u0645\u0631\u062a\u0628 \u0633\u0627\u0632\u06cc \u0627\u0637\u0644\u0627\u0639\u0627\u062a",
            "dxPivotGrid-dataNotAvailable": "(\u0628\u062f\u0648\u0646 \u062f\u0627\u062f\u0647)",
            "dxPivotGrid-rowFields": "\u0633\u0637\u0631\u0647\u0627",
            "dxPivotGrid-columnFields": "\u0633\u062a\u0648\u0646 \u0647\u0627",
            "dxPivotGrid-dataFields": "\u062f\u0627\u062f\u0647 \u0647\u0627",
            "dxPivotGrid-filterFields": "\u0641\u06cc\u0644\u062a\u0631\u0647\u0627",
            "dxPivotGrid-allFields": "\u06a9\u0644\u06cc\u0647 \u0627\u0637\u0644\u0627\u0639\u0627\u062a",
            "dxPivotGrid-columnFieldArea": "\u0641\u06cc\u0644\u062f\u0647\u0627\u06cc \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u0633\u062a\u0648\u0646 \u0631\u0627 \u0628\u0647 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0646\u062a\u0642\u0627\u0644 \u062f\u0647\u06cc\u062f (\u062f\u0631\u06af \u0646\u0645\u0627\u06cc\u06cc\u062f)",
            "dxPivotGrid-dataFieldArea": "\u0641\u06cc\u0644\u062f\u0647\u0627\u06cc \u062f\u0627\u062f\u0647 \u0627\u06cc \u0631\u0627 \u0628\u0647 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0646\u062a\u0642\u0627\u0644 \u062f\u0647\u06cc\u062f (\u062f\u0631\u06af \u0646\u0645\u0627\u06cc\u06cc\u062f)",
            "dxPivotGrid-rowFieldArea": "\u0641\u06cc\u0644\u062f\u0647\u0627\u06cc \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u0633\u0637\u0631 \u0631\u0627 \u0628\u0647 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0646\u062a\u0642\u0627\u0644 \u062f\u0647\u06cc\u062f (\u062f\u0631\u06af \u0646\u0645\u0627\u06cc\u06cc\u062f)",
            "dxPivotGrid-filterFieldArea": "\u0641\u06cc\u0644\u062f\u0647\u0627\u06cc \u0645\u0631\u0628\u0648\u0637 \u0628\u0647 \u0641\u06cc\u0644\u062a\u0631 \u0631\u0627 \u0628\u0647 \u0627\u06cc\u0646\u062c\u0627 \u0627\u0646\u062a\u0642\u0627\u0644 \u062f\u0647\u06cc\u062f (\u062f\u0631\u06af \u0646\u0645\u0627\u06cc\u06cc\u062f)",
            "dxScheduler-editorLabelTitle": "\u0645\u0648\u0636\u0648\u0639",
            "dxScheduler-editorLabelStartDate": "\u062a\u0627\u0631\u06cc\u062e \u0634\u0631\u0648\u0639",
            "dxScheduler-editorLabelEndDate": "\u062a\u0627\u0631\u06cc\u062e \u067e\u0627\u06cc\u0627\u0646",
            "dxScheduler-editorLabelDescription": "\u0634\u0631\u062d",
            "dxScheduler-editorLabelRecurrence": "\u062a\u06a9\u0631\u0627\u0631",
            "dxScheduler-openAppointment": "\u0642\u0631\u0627\u0631 \u0645\u0644\u0627\u0642\u0627\u062a \u0622\u0632\u0627\u062f",
            "dxScheduler-recurrenceNever": "\u0647\u0631\u06af\u0632",
            "dxScheduler-recurrenceMinutely": "\u0647\u0631 \u062f\u0642\u06cc\u0642\u0647",
            "dxScheduler-recurrenceHourly": "\u0633\u0627\u0639\u062a\u06cc",
            "dxScheduler-recurrenceDaily": "\u0631\u0648\u0632\u0627\u0646\u0647",
            "dxScheduler-recurrenceWeekly": "\u0647\u0641\u062a\u06af\u06cc",
            "dxScheduler-recurrenceMonthly": "\u0645\u0627\u0647\u0627\u0646\u0647",
            "dxScheduler-recurrenceYearly": "\u0633\u0627\u0644\u0627\u0646\u0647",
            "dxScheduler-recurrenceRepeatEvery": "\u062a\u06a9\u0631\u0627\u0631 \u0647\u0645\u0647",
            "dxScheduler-recurrenceRepeatOn": "\u062a\u06a9\u0631\u0627\u0631",
            "dxScheduler-recurrenceEnd": "\u067e\u0627\u06cc\u0627\u0646 \u062a\u06a9\u0631\u0627\u0631",
            "dxScheduler-recurrenceAfter": "\u0628\u0639\u062f \u0627\u0632",
            "dxScheduler-recurrenceOn": "\u0628\u0631",
            "dxScheduler-recurrenceRepeatMinutely": "\u062f\u0642\u06cc\u0642\u0647",
            "dxScheduler-recurrenceRepeatHourly": "\u0633\u0627\u0639\u062a",
            "dxScheduler-recurrenceRepeatDaily": "\u0631\u0648\u0632",
            "dxScheduler-recurrenceRepeatWeekly": "\u0647\u0641\u062a\u0647",
            "dxScheduler-recurrenceRepeatMonthly": "\u0645\u0627\u0647(\u0645\u0627\u0647\u0647\u0627)",
            "dxScheduler-recurrenceRepeatYearly": "\u0633\u0627\u0644(\u0647\u0627)",
            "dxScheduler-switcherDay": "\u0631\u0648\u0632",
            "dxScheduler-switcherWeek": "\u0647\u0641\u062a\u0647",
            "dxScheduler-switcherWorkWeek": "\u0647\u0641\u062a\u0647 \u06a9\u0627\u0631\u06cc",
            "dxScheduler-switcherMonth": "\u0645\u0627\u0647",
            "dxScheduler-switcherAgenda": "\u062f\u0633\u062a\u0648\u0631 \u062c\u0644\u0633\u0647",
            "dxScheduler-switcherTimelineDay": "\u0631\u0648\u0632\u0634\u0645\u0627\u0631",
            "dxScheduler-switcherTimelineWeek": "\u0647\u0641\u062a\u0647 \u062c\u062f\u0648\u0644 \u0632\u0645\u0627\u0646\u06cc",
            "dxScheduler-switcherTimelineWorkWeek": "\u0647\u0641\u062a\u0647 \u06a9\u0627\u0631 \u062c\u062f\u0648\u0644 \u0632\u0645\u0627\u0646\u06cc",
            "dxScheduler-switcherTimelineMonth": "\u0645\u0627\u0647 \u062c\u062f\u0648\u0644 \u0632\u0645\u0627\u0646\u06cc",
            "dxScheduler-recurrenceRepeatOnDate": "\u062f\u0631 \u062a\u0627\u0631\u06cc\u062e",
            "dxScheduler-recurrenceRepeatCount": "\u0631\u062e\u062f\u0627\u062f",
            "dxScheduler-allDay": "\u062a\u0645\u0627\u0645 \u0631\u0648\u0632",
            "dxScheduler-confirmRecurrenceEditMessage": "\u0622\u06cc\u0627 \u0645\u06cc \u062e\u0648\u0627\u0647\u06cc\u062f \u0641\u0642\u0637 \u0627\u06cc\u0646 \u0642\u0631\u0627\u0631 \u0645\u0644\u0627\u0642\u0627\u062a \u06cc\u0627 \u06a9\u0644 \u0645\u062c\u0645\u0648\u0639\u0647 \u0631\u0627 \u0648\u06cc\u0631\u0627\u06cc\u0634 \u06a9\u0646\u06cc\u062f\u061f",
            "dxScheduler-confirmRecurrenceDeleteMessage": "\u0622\u06cc\u0627 \u0645\u06cc \u062e\u0648\u0627\u0647\u06cc\u062f \u0641\u0642\u0637 \u0627\u06cc\u0646 \u0642\u0631\u0627\u0631 \u0645\u0644\u0627\u0642\u0627\u062a \u06cc\u0627 \u06a9\u0644 \u0645\u062c\u0645\u0648\u0639\u0647 \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u061f",
            "dxScheduler-confirmRecurrenceEditSeries": "\u0648\u06cc\u0631\u0627\u06cc\u0634 \u0633\u0631\u06cc\u0627\u0644",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u062d\u0630\u0641 \u0645\u062c\u0645\u0648\u0639\u0647 \u0647\u0627",
            "dxScheduler-confirmRecurrenceEditOccurrence": "\u0648\u06cc\u0631\u0627\u06cc\u0634 \u0642\u0631\u0627\u0631",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u062d\u0630\u0641 \u0642\u0631\u0627\u0631",
            "dxScheduler-noTimezoneTitle": "\u0628\u062f\u0648\u0646 \u0645\u0646\u0637\u0642\u0647 \u0632\u0645\u0627\u0646\u06cc",
            "dxScheduler-moreAppointments": "{0} \u0628\u06cc\u0634\u062a\u0631",
            "dxCalendar-todayButtonText": "\u0627\u0645\u0631\u0648\u0632",
            "dxCalendar-ariaWidgetName": "\u062a\u0642\u0648\u06cc\u0645",
            "dxCalendar-ariaHotKeysInfo": "To navigate between views, press Control, and then Left Arrow or Right Arrow. To zoom in on a view, press Control, and then Down Arrow. To zoom out, press Control, and then Up Arrow.",
            "dxColorView-ariaRed": "\u0642\u0631\u0645\u0632",
            "dxColorView-ariaGreen": "\u0633\u0628\u0632",
            "dxColorView-ariaBlue": "\u0622\u0628\u06cc",
            "dxColorView-ariaAlpha": "\u0634\u0641\u0627\u0641\u06cc\u062a",
            "dxColorView-ariaHex": "\u06a9\u062f \u0631\u0646\u06af",
            "dxTagBox-selected": "{0} \u0627\u0646\u062a\u062e\u0627\u0628 \u0634\u062f\u0647",
            "dxTagBox-allSelected": "\u0647\u0645\u0647 \u0627\u0646\u062a\u062e\u0627\u0628 \u0634\u062f\u0647 \u0627\u0646\u062f ({0})",
            "dxTagBox-moreSelected": "{0} \u0633\u0627\u06cc\u0631",
            "vizExport-printingButtonText": "\u0686\u0627\u067e",
            "vizExport-titleMenuText": "\u0635\u0627\u062f\u0631\u0627\u062a / \u0686\u0627\u067e",
            "vizExport-exportButtonText": "{0} \u067e\u0631\u0648\u0646\u062f\u0647",
            "dxFilterBuilder-and": "\u0648",
            "dxFilterBuilder-or": "\u06cc\u0627",
            "dxFilterBuilder-notAnd": "\u0648 \u0628\u062c\u0632",
            "dxFilterBuilder-notOr": "\u06cc\u0627 \u0628\u062c\u0632",
            "dxFilterBuilder-addCondition": "\u0627\u0641\u0632\u0648\u062f\u0646 \u0634\u0631\u0637",
            "dxFilterBuilder-addGroup": "\u0627\u0641\u0632\u0648\u062f\u0646 \u06af\u0631\u0648\u0647",
            "dxFilterBuilder-enterValueText": "<\u0645\u0642\u062f\u0627\u0631 \u0645\u0648\u0631\u062f \u0646\u0638\u0631 \u0631\u0627 \u0648\u0627\u0631\u062f \u0646\u0645\u0627\u06cc\u06cc\u062f>",
            "dxFilterBuilder-filterOperationEquals": "\u0628\u0631\u0627\u0628\u0631 \u0628\u0627",
            "dxFilterBuilder-filterOperationNotEquals": "\u0639\u062f\u0645 \u0628\u0631\u0627\u0628\u0631\u06cc \u0628\u0627",
            "dxFilterBuilder-filterOperationLess": "\u06a9\u0648\u0686\u06a9\u062a\u0631 \u0627\u0632",
            "dxFilterBuilder-filterOperationLessOrEquals": "\u06a9\u0648\u0686\u06a9\u062a\u0631 \u06cc\u0627 \u0645\u0633\u0627\u0648\u06cc \u0628\u0627",
            "dxFilterBuilder-filterOperationGreater": "\u0628\u0632\u0631\u06af\u062a\u0631 \u0627\u0632",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\u0628\u0632\u0631\u06af\u062a\u0631 \u06cc\u0627 \u0645\u0633\u0627\u0648\u06cc \u0628\u0627",
            "dxFilterBuilder-filterOperationStartsWith": "\u0634\u0631\u0648\u0639 \u0628\u0627",
            "dxFilterBuilder-filterOperationContains": "\u0634\u0627\u0645\u0644",
            "dxFilterBuilder-filterOperationNotContains": "\u0634\u0627\u0645\u0644 \u0646\u0628\u0648\u062f\u0646",
            "dxFilterBuilder-filterOperationEndsWith": "\u067e\u0627\u06cc\u0627\u0646 \u0628\u0627",
            "dxFilterBuilder-filterOperationIsBlank": "\u0628\u062f\u0648\u0646 \u0645\u0642\u062f\u0627\u0631",
            "dxFilterBuilder-filterOperationIsNotBlank": "\u062f\u0627\u0631\u0627\u06cc \u0645\u0642\u062f\u0627\u0631",
            "dxFilterBuilder-filterOperationBetween": "\u0628\u06cc\u0646",
            "dxFilterBuilder-filterOperationAnyOf": "\u0634\u0627\u0645\u0644 \u06cc\u06a9\u06cc \u0627\u0632",
            "dxFilterBuilder-filterOperationNoneOf": "\u0634\u0627\u0645\u0644 \u0647\u06cc\u0686\u06a9\u062f\u0627\u0645 \u0627\u0632",
            "dxHtmlEditor-dialogColorCaption": "\u062a\u063a\u06cc\u06cc\u0631 \u0631\u0646\u06af \u0642\u0644\u0645",
            "dxHtmlEditor-dialogBackgroundCaption": "\u062a\u063a\u06cc\u06cc\u0631 \u0631\u0646\u06af \u067e\u0633 \u0632\u0645\u06cc\u0646\u0647",
            "dxHtmlEditor-dialogLinkCaption": "\u0627\u0641\u0632\u0648\u062f\u0646 \u067e\u06cc\u0648\u0646\u062f",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "\u0645\u062a\u0646",
            "dxHtmlEditor-dialogLinkTargetField": "\u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u067e\u06cc\u0648\u0646\u062f \u062f\u0631 \u067e\u0646\u062c\u0631\u0647 \u062c\u062f\u06cc\u062f",
            "dxHtmlEditor-dialogImageCaption": "\u062a\u0635\u0648\u06cc\u0631 \u0627\u0636\u0627\u0641\u0647 \u06a9\u0646",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "\u0645\u062a\u0646 \u062c\u0627\u06cc\u06af\u0632\u06cc\u0646",
            "dxHtmlEditor-dialogImageWidthField": "\u0639\u0631\u0636 (\u067e\u06cc\u06a9\u0633\u0644)",
            "dxHtmlEditor-dialogImageHeightField": "\u0642\u062f (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "\u0631\u062f\u06cc\u0641",
            "dxHtmlEditor-dialogInsertTableColumnsField": "\u0633\u062a\u0648\u0646 \u0647\u0627",
            "dxHtmlEditor-dialogInsertTableCaption": "\u062f\u0631\u062c \u062c\u062f\u0648\u0644",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "\u0639\u0646\u0648\u0627\u0646",
            "dxHtmlEditor-normalText": "\u0645\u062a\u0646 \u0639\u0627\u062f\u06cc",
            "dxHtmlEditor-background": "Background",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Link",
            "dxHtmlEditor-image": "Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strike",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxFileManager-newDirectoryName": "\u0641\u0647\u0631\u0633\u062a \u0628\u062f\u0648\u0646 \u0639\u0646\u0648\u0627\u0646",
            "dxFileManager-rootDirectoryName": "\u0641\u0627\u06cc\u0644 \u0647\u0627",
            "dxFileManager-errorNoAccess": "\u062f\u0633\u062a\u0631\u0633\u06cc \u0645\u0645\u0646\u0648\u0639 \u0627\u0633\u062a. \u0639\u0645\u0644\u06cc\u0627\u062a \u0627\u0646\u062c\u0627\u0645 \u0646\u0634\u062f.",
            "dxFileManager-errorDirectoryExistsFormat": "\u0641\u0647\u0631\u0633\u062a {0} \u0627\u0632 \u0642\u0628\u0644 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.",
            "dxFileManager-errorFileExistsFormat": "\u067e\u0631\u0648\u0646\u062f\u0647 {0} \u0627\u0632 \u0642\u0628\u0644 \u0648\u062c\u0648\u062f \u062f\u0627\u0631\u062f.",
            "dxFileManager-errorFileNotFoundFormat": "\u067e\u0631\u0648\u0646\u062f\u0647 {0} \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f.",
            "dxFileManager-errorDirectoryNotFoundFormat": "\u0641\u0647\u0631\u0633\u062a {0} \u067e\u06cc\u062f\u0627 \u0646\u0634\u062f.",
            "dxFileManager-errorWrongFileExtension": "\u067e\u0633\u0648\u0646\u062f \u067e\u0631\u0648\u0646\u062f\u0647 \u0645\u062c\u0627\u0632 \u0646\u06cc\u0633\u062a.",
            "dxFileManager-errorMaxFileSizeExceeded": "\u0627\u0646\u062f\u0627\u0632\u0647 \u067e\u0631\u0648\u0646\u062f\u0647 \u0627\u0632 \u062d\u062f\u0627\u06a9\u062b\u0631 \u0627\u0646\u062f\u0627\u0632\u0647 \u0645\u062c\u0627\u0632 \u0628\u06cc\u0634\u062a\u0631 \u0627\u0633\u062a.",
            "dxFileManager-errorInvalidSymbols": "\u0627\u06cc\u0646 \u0646\u0627\u0645 \u062d\u0627\u0648\u06cc \u0646\u0648\u06cc\u0633\u0647 \u0647\u0627\u06cc \u0646\u0627\u0645\u0639\u062a\u0628\u0631 \u0627\u0633\u062a.",
            "dxFileManager-errorDefault": "\u062e\u0637\u0627\u06cc \u0646\u0627\u0645\u0634\u062e\u0635.",
            "dxFileManager-errorDirectoryOpenFailed": "\u0641\u0647\u0631\u0633\u062a \u0646\u0645\u06cc \u062a\u0648\u0627\u0646\u062f \u0628\u0627\u0632 \u0634\u0648\u062f",
            "dxFileManager-commandCreate": "\u062f\u0627\u06cc\u0631\u06a9\u062a\u0648\u0631\u06cc \u062c\u062f\u06cc\u062f",
            "dxFileManager-commandRename": "\u062a\u063a\u06cc\u06cc\u0631 \u0646\u0627\u0645",
            "dxFileManager-commandMove": "\u0627\u0646\u062a\u0642\u0627\u0644 \u0628\u0647",
            "dxFileManager-commandCopy": "\u06a9\u067e\u06cc \u062f\u0631",
            "dxFileManager-commandDelete": "\u062d\u0630\u0641",
            "dxFileManager-commandDownload": "\u062f\u0627\u0646\u0644\u0648\u062f",
            "dxFileManager-commandUpload": "\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u067e\u0631\u0648\u0646\u062f\u0647 \u0647\u0627",
            "dxFileManager-commandRefresh": "\u062a\u0627\u0632\u0647 \u06a9\u0631\u062f\u0646",
            "dxFileManager-commandThumbnails": "\u0646\u0645\u0627\u06cc\u0634 \u062a\u0635\u0627\u0648\u06cc\u0631 \u06a9\u0648\u0686\u06a9",
            "dxFileManager-commandDetails": "\u0646\u0645\u0627\u06cc\u0634 \u062c\u0632\u0626\u06cc\u0627\u062a",
            "dxFileManager-commandClearSelection": "\u067e\u0627\u06a9 \u06a9\u0631\u062f\u0646 \u0627\u0646\u062a\u062e\u0627\u0628",
            "dxFileManager-commandShowNavPane": "\u062a\u063a\u06cc\u06cc\u0631 \u067e\u0627\u0646\u0644 \u0646\u0627\u0648\u0628\u0631\u06cc",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "\u0627\u0646\u062a\u0642\u0627\u0644 \u0628\u0647",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "\u062d\u0631\u06a9\u062a",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "\u06a9\u067e\u06cc \u062f\u0631",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "\u06a9\u067e\u06cc",
            "dxFileManager-dialogRenameItemTitle": "\u062a\u063a\u06cc\u06cc\u0631 \u0646\u0627\u0645",
            "dxFileManager-dialogRenameItemButtonText": "\u0635\u0631\u0641\u0647 \u062c\u0648\u06cc\u06cc",
            "dxFileManager-dialogCreateDirectoryTitle": "\u062f\u0627\u06cc\u0631\u06a9\u062a\u0648\u0631\u06cc \u062c\u062f\u06cc\u062f",
            "dxFileManager-dialogCreateDirectoryButtonText": "\u0627\u06cc\u062c\u0627\u062f \u06a9\u0631\u062f\u0646",
            "dxFileManager-dialogDeleteItemTitle": "\u062d\u0630\u0641",
            "dxFileManager-dialogDeleteItemButtonText": "\u062d\u0630\u0641",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "\u0622\u06cc\u0627 \u0645\u0637\u0645\u0626\u0646 \u0647\u0633\u062a\u06cc\u062f \u06a9\u0647 \u0645\u06cc \u062e\u0648\u0627\u0647\u06cc\u062f {0} \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u061f",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "\u0622\u06cc\u0627 \u0645\u0637\u0645\u0626\u0646 \u0647\u0633\u062a\u06cc\u062f \u06a9\u0647 \u0645\u06cc \u062e\u0648\u0627\u0647\u06cc\u062f {0} \u0645\u0648\u0631\u062f \u0631\u0627 \u062d\u0630\u0641 \u06a9\u0646\u06cc\u062f\u061f",
            "dxFileManager-dialogButtonCancel": "\u0644\u063a\u0648",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "\u0627\u06cc\u062c\u0627\u062f \u06cc\u06a9 \u0641\u0647\u0631\u0633\u062a \u062f\u0631 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "\u06cc\u06a9 \u0641\u0647\u0631\u0633\u062a \u062f\u0631\u0648\u0646 {0} \u0627\u06cc\u062c\u0627\u062f \u06a9\u0631\u062f",
            "dxFileManager-editingCreateSingleItemErrorMessage": "\u0641\u0647\u0631\u0633\u062a \u0627\u06cc\u062c\u0627\u062f \u0646\u0634\u062f",
            "dxFileManager-editingCreateCommonErrorMessage": "\u0641\u0647\u0631\u0633\u062a \u0627\u06cc\u062c\u0627\u062f \u0646\u0634\u062f",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "\u062a\u063a\u06cc\u06cc\u0631 \u0646\u0627\u0645 \u06cc\u06a9 \u0645\u0648\u0631\u062f \u062f\u0631 \u062f\u0627\u062e\u0644 {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "\u062a\u063a\u06cc\u06cc\u0631 \u0646\u0627\u0645 \u06cc\u06a9 \u0645\u0648\u0631\u062f \u062f\u0631\u0648\u0646 {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "\u0646\u0627\u0645 \u0645\u0648\u0631\u062f \u062a\u063a\u06cc\u06cc\u0631 \u0646\u06a9\u0631\u062f",
            "dxFileManager-editingRenameCommonErrorMessage": "\u0646\u0627\u0645 \u0645\u0648\u0631\u062f \u062a\u063a\u06cc\u06cc\u0631 \u0646\u06a9\u0631\u062f",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "\u062d\u0630\u0641 \u0645\u0648\u0631\u062f \u0627\u0632 {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "\u062d\u0630\u0641 {0} \u0645\u0648\u0631\u062f \u0627\u0632 {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "\u0645\u0648\u0631\u062f\u06cc \u0627\u0632 {0} \u062d\u0630\u0641 \u0634\u062f",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "{0} \u0645\u0648\u0631\u062f \u0627\u0632 {1} \u062d\u0630\u0641 \u0634\u062f",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "\u0645\u0648\u0631\u062f \u062d\u0630\u0641 \u0646\u0634\u062f",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} \u0645\u0648\u0631\u062f \u062d\u0630\u0641 \u0646\u0634\u062f",
            "dxFileManager-editingDeleteCommonErrorMessage": "\u0628\u0631\u062e\u06cc \u0627\u0632 \u0645\u0648\u0627\u0631\u062f \u062d\u0630\u0641 \u0646\u0634\u062f\u0647 \u0627\u0646\u062f",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "\u062f\u0631 \u062d\u0627\u0644 \u0627\u0646\u062a\u0642\u0627\u0644 \u0645\u0648\u0631\u062f \u0628\u0647 {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "\u0627\u0646\u062a\u0642\u0627\u0644 {0} \u0645\u0648\u0631\u062f \u0628\u0647 {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "\u0645\u0648\u0631\u062f\u06cc \u0631\u0627 \u0628\u0647 {0} \u0645\u0646\u062a\u0642\u0644 \u06a9\u0631\u062f",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "{0} \u0645\u0648\u0631\u062f \u0628\u0647 {1} \u0645\u0646\u062a\u0642\u0644 \u0634\u062f",
            "dxFileManager-editingMoveSingleItemErrorMessage": "\u0645\u0648\u0631\u062f \u0645\u0646\u062a\u0642\u0644 \u0646\u0634\u062f",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} \u0645\u0648\u0631\u062f \u0645\u0646\u062a\u0642\u0644 \u0646\u0634\u062f",
            "dxFileManager-editingMoveCommonErrorMessage": "\u0628\u0631\u062e\u06cc \u0627\u0632 \u0645\u0648\u0627\u0631\u062f \u0645\u0646\u062a\u0642\u0644 \u0646\u0634\u062f\u0646\u062f",
            "dxFileManager-editingCopySingleItemProcessingMessage": "\u06a9\u067e\u06cc \u06a9\u0631\u062f\u0646 \u0645\u0648\u0631\u062f \u062f\u0631 {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "\u06a9\u067e\u06cc \u06a9\u0631\u062f\u0646 {0} \u0645\u0648\u0631\u062f \u062f\u0631 {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "\u0645\u0648\u0631\u062f\u06cc \u0631\u0627 \u062f\u0631 {0} \u06a9\u067e\u06cc \u06a9\u0631\u062f",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "{0} \u0645\u0648\u0631\u062f \u062f\u0631 {1} \u06a9\u067e\u06cc \u0634\u062f",
            "dxFileManager-editingCopySingleItemErrorMessage": "\u0645\u0648\u0631\u062f \u06a9\u067e\u06cc \u0646\u0634\u062f",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} \u0645\u0648\u0631\u062f \u06a9\u067e\u06cc \u0646\u0634\u062f",
            "dxFileManager-editingCopyCommonErrorMessage": "\u0628\u0631\u062e\u06cc \u0627\u0632 \u0645\u0648\u0627\u0631\u062f \u06a9\u067e\u06cc \u0646\u0634\u062f\u0646\u062f",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06cc\u06a9 \u0645\u0648\u0631\u062f \u062f\u0631 {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc {0} \u0645\u0648\u0631\u062f \u062f\u0631 {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\u0645\u0648\u0631\u062f\u06cc \u0631\u0627 \u062f\u0631 {0} \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0631\u062f",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "{0} \u0645\u0648\u0631\u062f \u0631\u0627 \u062f\u0631 {1} \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u06a9\u0631\u062f",
            "dxFileManager-editingUploadSingleItemErrorMessage": "\u0645\u0648\u0631\u062f \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} \u0645\u0648\u0631\u062f \u0628\u0627\u0631\u06af\u0630\u0627\u0631\u06cc \u0646\u0634\u062f",
            "dxFileManager-editingUploadCanceledMessage": "\u0644\u063a\u0648 \u0634\u062f",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "\u0646\u0627\u0645",
            "dxFileManager-listDetailsColumnCaptionDateModified": "\u062a\u0627\u0631\u06cc\u062e \u0627\u0635\u0644\u0627\u062d \u0634\u062f\u0647",
            "dxFileManager-listDetailsColumnCaptionFileSize": "\u062d\u062c\u0645 \u0641\u0627\u06cc\u0644",
            "dxFileManager-listThumbnailsTooltipTextSize": "\u0627\u0646\u062f\u0627\u0632\u0647",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "\u062a\u0627\u0631\u06cc\u062e \u0627\u0635\u0644\u0627\u062d \u0634\u062f\u0647",
            "dxFileManager-notificationProgressPanelTitle": "\u067e\u06cc\u0634 \u0631\u0641\u062a\u0646",
            "dxFileManager-notificationProgressPanelEmptyListText": "\u0628\u062f\u0648\u0646 \u0639\u0645\u0644\u06cc\u0627\u062a",
            "dxFileManager-notificationProgressPanelOperationCanceled": "\u0644\u063a\u0648 \u0634\u062f",
            "dxDiagram-categoryGeneral": "\u0639\u0645\u0648\u0645\u06cc",
            "dxDiagram-categoryFlowchart": "\u0646\u0645\u0648\u062f\u0627\u0631 \u0646\u0645\u0648\u062f\u0627\u0631",
            "dxDiagram-categoryOrgChart": "\u0686\u0627\u0631\u062a \u0633\u0627\u0632\u0645\u0627\u0646\u06cc",
            "dxDiagram-categoryContainers": "\u0638\u0631\u0648\u0641",
            "dxDiagram-categoryCustom": "\u0633\u0641\u0627\u0631\u0634\u06cc",
            "dxDiagram-commandExportToSvg": "\u0635\u0627\u062f\u0631\u0627\u062a \u0628\u0647 SVG",
            "dxDiagram-commandExportToPng": "\u0635\u0627\u062f\u0631\u0627\u062a \u0628\u0647 PNG",
            "dxDiagram-commandExportToJpg": "\u0635\u0627\u062f\u0631\u0627\u062a \u0628\u0647 JPEG",
            "dxDiagram-commandUndo": "\u0648\u0627\u06af\u0631\u062f",
            "dxDiagram-commandRedo": "\u062f\u0648\u0628\u0627\u0631\u0647",
            "dxDiagram-commandFontName": "\u0646\u0627\u0645 \u0642\u0644\u0645",
            "dxDiagram-commandFontSize": "\u0627\u0646\u062f\u0627\u0632\u0647 \u0641\u0648\u0646\u062a",
            "dxDiagram-commandBold": "\u067e\u0631\u0631\u0646\u06af",
            "dxDiagram-commandItalic": "\u0627\u06cc\u062a\u0627\u0644\u06cc\u06a9",
            "dxDiagram-commandUnderline": "\u0632\u06cc\u0631\u062e\u0637",
            "dxDiagram-commandTextColor": "\u0631\u0646\u06af \u0642\u0644\u0645",
            "dxDiagram-commandLineColor": "\u0631\u0646\u06af \u062e\u0637",
            "dxDiagram-commandLineWidth": "\u0639\u0631\u0636 \u062e\u0637",
            "dxDiagram-commandLineStyle": "\u0633\u0628\u06a9 \u062e\u0637",
            "dxDiagram-commandLineStyleSolid": "\u062c\u0627\u0645\u062f",
            "dxDiagram-commandLineStyleDotted": "\u062e\u0637 \u0686\u06cc\u0646",
            "dxDiagram-commandLineStyleDashed": "\u0646\u0642\u0637\u0647 \u0686\u06cc\u0646",
            "dxDiagram-commandFillColor": "\u067e\u0631 \u0631\u0646\u06af",
            "dxDiagram-commandAlignLeft": "\u062a\u0631\u0627\u0632 \u0686\u067e",
            "dxDiagram-commandAlignCenter": "Align Center",
            "dxDiagram-commandAlignRight": "\u0631\u0627\u0633\u062a \u0686\u06cc\u0646",
            "dxDiagram-commandConnectorLineType": "\u0646\u0648\u0639 \u062e\u0637 \u0627\u062a\u0635\u0627\u0644",
            "dxDiagram-commandConnectorLineStraight": "\u0633\u0631 \u0631\u0627\u0633\u062a",
            "dxDiagram-commandConnectorLineOrthogonal": "\u0627\u0631\u062a\u0648\u062f\u0646\u0633\u06cc",
            "dxDiagram-commandConnectorLineStart": "\u0634\u0631\u0648\u0639 \u0627\u062a\u0635\u0627\u0644 \u062f\u0647\u0646\u062f\u0647 \u062e\u0637",
            "dxDiagram-commandConnectorLineEnd": "\u0627\u0646\u062a\u0647\u0627\u06cc \u062e\u0637 \u0627\u062a\u0635\u0627\u0644",
            "dxDiagram-commandConnectorLineNone": "\u0647\u06cc\u0686 \u06cc\u06a9",
            "dxDiagram-commandConnectorLineArrow": "\u0641\u0644\u0634",
            "dxDiagram-commandFullscreen": "\u062a\u0645\u0627\u0645 \u0635\u0641\u062d\u0647",
            "dxDiagram-commandUnits": "\u0648\u0627\u062d\u062f\u0647\u0627",
            "dxDiagram-commandPageSize": "\u0627\u0646\u062f\u0627\u0632\u0647 \u0635\u0641\u062d\u0647",
            "dxDiagram-commandPageOrientation": "\u062c\u0647\u062a \u06af\u06cc\u0631\u06cc \u0635\u0641\u062d\u0647",
            "dxDiagram-commandPageOrientationLandscape": "\u0686\u0634\u0645 \u0627\u0646\u062f\u0627\u0632",
            "dxDiagram-commandPageOrientationPortrait": "\u067e\u0631\u062a\u0631\u0647",
            "dxDiagram-commandPageColor": "\u0631\u0646\u06af \u0635\u0641\u062d\u0647",
            "dxDiagram-commandShowGrid": "\u0646\u0645\u0627\u06cc\u0634 \u0634\u0628\u06a9\u0647",
            "dxDiagram-commandSnapToGrid": "\u0636\u0631\u0628\u0647 \u0645\u062d\u06a9\u0645 \u0648 \u0646\u0627\u06af\u0647\u0627\u0646\u06cc \u0628\u0647 \u0634\u0628\u06a9\u0647",
            "dxDiagram-commandGridSize": "\u0627\u0646\u062f\u0627\u0632\u0647 \u0634\u0628\u06a9\u0647",
            "dxDiagram-commandZoomLevel": "\u0633\u0637\u062d \u0628\u0632\u0631\u06af\u0646\u0645\u0627\u06cc\u06cc",
            "dxDiagram-commandAutoZoom": "\u0628\u0632\u0631\u06af\u0646\u0645\u0627\u06cc\u06cc \u062e\u0648\u062f\u06a9\u0627\u0631",
            "dxDiagram-commandFitToContent": "\u0645\u062a\u0646\u0627\u0633\u0628 \u0628\u0627 \u0645\u062d\u062a\u0648\u0627",
            "dxDiagram-commandFitToWidth": "\u0645\u062a\u0646\u0627\u0633\u0628 \u0628\u0627 \u0639\u0631\u0636",
            "dxDiagram-commandAutoZoomByContent": "\u0628\u0632\u0631\u06af\u0646\u0645\u0627\u06cc\u06cc \u062e\u0648\u062f\u06a9\u0627\u0631 \u0628\u0631\u0627\u0633\u0627\u0633 \u0645\u062d\u062a\u0648\u0627",
            "dxDiagram-commandAutoZoomByWidth": "\u0628\u0632\u0631\u06af\u0646\u0645\u0627\u06cc\u06cc \u062e\u0648\u062f\u06a9\u0627\u0631 \u0628\u0627 \u0639\u0631\u0636",
            "dxDiagram-commandSimpleView": "\u0646\u0645\u0627\u06cc \u0633\u0627\u062f\u0647",
            "dxDiagram-commandCut": "\u0642\u0637\u0639 \u06a9\u0631\u062f\u0646",
            "dxDiagram-commandCopy": "\u06a9\u067e\u06cc",
            "dxDiagram-commandPaste": "\u0686\u0633\u0628\u0627\u0646\u062f\u0646",
            "dxDiagram-commandSelectAll": "\u0627\u0646\u062a\u062e\u0627\u0628 \u0647\u0645\u0647",
            "dxDiagram-commandDelete": "\u062d\u0630\u0641",
            "dxDiagram-commandBringToFront": "\u0628\u0647 \u062c\u0644\u0648 \u0628\u06cc\u0627\u0648\u0631",
            "dxDiagram-commandSendToBack": "\u0627\u0631\u0633\u0627\u0644 \u0628\u0647 \u0639\u0642\u0628",
            "dxDiagram-commandLock": "\u0642\u0641\u0644 \u06a9\u0631\u062f\u0646",
            "dxDiagram-commandUnlock": "\u0628\u0627\u0632 \u06a9\u0631\u062f\u0646 \u0642\u0641\u0644",
            "dxDiagram-commandInsertShapeImage": "\u062f\u0631\u062c \u062a\u0635\u0648\u06cc\u0631 ...",
            "dxDiagram-commandEditShapeImage": "\u062a\u063a\u06cc\u06cc\u0631 \u062a\u0635\u0648\u06cc\u0631 ...",
            "dxDiagram-commandDeleteShapeImage": "\u062d\u0630\u0641 \u062a\u0635\u0648\u06cc\u0631",
            "dxDiagram-commandLayoutLeftToRight": "\u0686\u067e \u0628\u0647 \u0631\u0627\u0633\u062a",
            "dxDiagram-commandLayoutRightToLeft": "\u0631\u0627\u0633\u062a \u0628\u0647 \u0686\u067e",
            "dxDiagram-commandLayoutTopToBottom": "\u0628\u0627\u0644\u0627 \u0628\u0647 \u067e\u0627\u06cc\u06cc\u0646",
            "dxDiagram-commandLayoutBottomToTop": "\u067e\u0627\u06cc\u06cc\u0646 \u0628\u0647 \u0628\u0627\u0644\u0627",
            "dxDiagram-unitIn": "\u06a9\u0647 \u062f\u0631",
            "dxDiagram-unitCm": "\u0633\u0627\u0646\u062a\u06cc \u0645\u062a\u0631",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "\u062e\u0648\u0628",
            "dxDiagram-dialogButtonCancel": "\u0644\u063a\u0648",
            "dxDiagram-dialogInsertShapeImageTitle": "\u062f\u0631\u062c \u062a\u0635\u0648\u06cc\u0631",
            "dxDiagram-dialogEditShapeImageTitle": "\u062a\u063a\u06cc\u06cc\u0631 \u062a\u0635\u0648\u06cc\u0631",
            "dxDiagram-dialogEditShapeImageSelectButton": "\u0627\u0646\u062a\u062e\u0627\u0628 \u062a\u0635\u0648\u06cc\u0631",
            "dxDiagram-dialogEditShapeImageLabelText": "\u06cc\u0627 \u067e\u0631\u0648\u0646\u062f\u0647 \u0631\u0627 \u062f\u0631 \u0627\u06cc\u0646\u062c\u0627 \u0631\u0647\u0627 \u06a9\u0646\u06cc\u062f",
            "dxDiagram-uiExport": "\u0635\u0627\u062f\u0631\u0627\u062a",
            "dxDiagram-uiProperties": "Properties",
            "dxDiagram-uiSettings": "\u062a\u0646\u0638\u06cc\u0645\u0627\u062a",
            "dxDiagram-uiShowToolbox": "\u0646\u0645\u0627\u06cc\u0634 \u062c\u0639\u0628\u0647 \u0627\u0628\u0632\u0627\u0631",
            "dxDiagram-uiSearch": "\u062c\u0633\u062a\u062c\u0648 \u06a9\u0631\u062f\u0646",
            "dxDiagram-uiStyle": "\u0633\u0628\u06a9",
            "dxDiagram-uiLayout": "\u0686\u06cc\u062f\u0645\u0627\u0646",
            "dxDiagram-uiLayoutTree": "\u062f\u0631\u062e\u062a",
            "dxDiagram-uiLayoutLayered": "\u0644\u0627\u06cc\u0647 \u0627\u06cc",
            "dxDiagram-uiDiagram": "\u0646\u0645\u0648\u062f\u0627\u0631",
            "dxDiagram-uiText": "\u0645\u062a\u0646",
            "dxDiagram-uiObject": "\u0647\u062f\u0641 - \u0634\u06cc",
            "dxDiagram-uiConnector": "\u0627\u062a\u0635\u0627\u0644 \u062f\u0647\u0646\u062f\u0647",
            "dxDiagram-uiPage": "\u0635\u0641\u062d\u0647",
            "dxDiagram-shapeText": "\u0645\u062a\u0646",
            "dxDiagram-shapeRectangle": "\u0645\u0633\u062a\u0637\u06cc\u0644",
            "dxDiagram-shapeEllipse": "\u0628\u06cc\u0636\u06cc",
            "dxDiagram-shapeCross": "\u0635\u0644\u06cc\u0628",
            "dxDiagram-shapeTriangle": "\u0645\u062b\u0644\u062b",
            "dxDiagram-shapeDiamond": "\u0627\u0644\u0645\u0627\u0633",
            "dxDiagram-shapeHeart": "\u0642\u0644\u0628",
            "dxDiagram-shapePentagon": "\u067e\u0646\u062a\u0627\u06af\u0648\u0646",
            "dxDiagram-shapeHexagon": "\u0634\u0634 \u0636\u0644\u0639\u06cc",
            "dxDiagram-shapeOctagon": "\u0647\u0634\u062a \u0648\u062c\u0647\u06cc",
            "dxDiagram-shapeStar": "\u0633\u062a\u0627\u0631\u0647",
            "dxDiagram-shapeArrowLeft": "\u0641\u0644\u0634 \u0633\u0645\u062a \u0686\u067e",
            "dxDiagram-shapeArrowUp": "\u067e\u06cc\u06a9\u0627\u0646 \u0628\u0627\u0644\u0627",
            "dxDiagram-shapeArrowRight": "\u0641\u0644\u0634 \u0631\u0627\u0633\u062a",
            "dxDiagram-shapeArrowDown": "\u067e\u06cc\u06a9\u0627\u0646 \u0631\u0648 \u0628\u0647 \u067e\u0627\u06cc\u06cc\u0646",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "\u067e\u06cc\u06a9\u0627\u0646 \u0686\u067e \u0631\u0627\u0633\u062a",
            "dxDiagram-shapeProcess": "\u0631\u0648\u0646\u062f",
            "dxDiagram-shapeDecision": "\u062a\u0635\u0645\u06cc\u0645",
            "dxDiagram-shapeTerminator": "\u0646\u0627\u0628\u0648\u062f \u06a9\u0646\u0646\u062f\u0647",
            "dxDiagram-shapePredefinedProcess": "\u0641\u0631\u0622\u06cc\u0646\u062f \u0627\u0632 \u067e\u06cc\u0634 \u062a\u0639\u0631\u06cc\u0641 \u0634\u062f\u0647",
            "dxDiagram-shapeDocument": "\u0633\u0646\u062f",
            "dxDiagram-shapeMultipleDocuments": "\u0686\u0646\u062f\u06cc\u0646 \u0633\u0646\u062f",
            "dxDiagram-shapeManualInput": "\u0648\u0631\u0648\u062f\u06cc \u062f\u0633\u062a\u06cc",
            "dxDiagram-shapePreparation": "\u0622\u0645\u0627\u062f\u0647 \u0633\u0627\u0632\u06cc",
            "dxDiagram-shapeData": "\u062f\u0627\u062f\u0647 \u0647\u0627",
            "dxDiagram-shapeDatabase": "\u067e\u0627\u06cc\u06af\u0627\u0647 \u062f\u0627\u062f\u0647",
            "dxDiagram-shapeHardDisk": "\u0647\u0627\u0631\u062f \u062f\u06cc\u0633\u06a9",
            "dxDiagram-shapeInternalStorage": "\u062d\u0627\u0641\u0638\u0647 \u062f\u0627\u062e\u0644\u06cc",
            "dxDiagram-shapePaperTape": "\u0646\u0648\u0627\u0631 \u06a9\u0627\u063a\u0630\u06cc",
            "dxDiagram-shapeManualOperation": "\u0639\u0645\u0644\u06cc\u0627\u062a \u062f\u0633\u062a\u06cc",
            "dxDiagram-shapeDelay": "\u062a\u0627\u062e\u06cc\u0631 \u0627\u0646\u062f\u0627\u062e\u062a\u0646",
            "dxDiagram-shapeStoredData": "\u0627\u0637\u0644\u0627\u0639\u0627\u062a \u0630\u062e\u06cc\u0631\u0647 \u0634\u062f\u0647",
            "dxDiagram-shapeDisplay": "\u0646\u0645\u0627\u06cc\u0634 \u062f\u0627\u062f\u0646",
            "dxDiagram-shapeMerge": "\u0627\u062f\u063a\u0627\u0645",
            "dxDiagram-shapeConnector": "\u0627\u062a\u0635\u0627\u0644 \u062f\u0647\u0646\u062f\u0647",
            "dxDiagram-shapeOr": "\u06cc\u0627",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "\u06a9\u0627\u0646\u062a\u06cc\u0646\u0631",
            "dxDiagram-shapeVerticalContainer": "\u0638\u0631\u0641 \u0639\u0645\u0648\u062f\u06cc",
            "dxDiagram-shapeHorizontalContainer": "\u0638\u0631\u0641 \u0627\u0641\u0642\u06cc",
            "dxDiagram-shapeCardDefaultText": "\u0646\u0627\u0645 \u0634\u062e\u0635",
            "dxDiagram-shapeCardWithImageOnLeft": "\u06a9\u0627\u0631\u062a \u0628\u0627 \u062a\u0635\u0648\u06cc\u0631 \u062f\u0631 \u0633\u0645\u062a \u0686\u067e",
            "dxDiagram-shapeCardWithImageOnTop": "\u06a9\u0627\u0631\u062a \u0628\u0627 \u062a\u0635\u0648\u06cc\u0631 \u062f\u0631 \u0628\u0627\u0644\u0627",
            "dxDiagram-shapeCardWithImageOnRight": "\u06a9\u0627\u0631\u062a \u062f\u0627\u0631\u0627\u06cc \u062a\u0635\u0648\u06cc\u0631 \u062f\u0631 \u0633\u0645\u062a \u0631\u0627\u0633\u062a",
            "dxGantt-dialogTitle": "Title",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "Add",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resource: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Undo",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "Expand All",
            "dxGantt-collapseAll": "Collapse All",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "Zoom In",
            "dxGantt-zoomOut": "Zoom Out",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sort Ascending",
            "dxGantt-sortingDescendingText": "Sort Descending",
            "dxGantt-sortingClearText": "Clear Sorting",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}"
        }
    })
}));
