function IDdxScheduler(pform)
{
  CustomElement.call(this, pform);
}

IDdxScheduler.prototype = new CustomElement();
if(!IDdxScheduler.inited){
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/dx.material.blue.light.css", "CSS");
  IDdxScheduler.inited = true;
}


Object.defineProperty(IDdxScheduler.prototype, "configuration", {
  set: function (configuration) {
    this.dxScheduler_configuration = configuration;
    this.sc_timezone = configuration.timezone;
    this.sc_currentView = configuration.currentView;
    this.sc_currentDate = configuration.currentDate;
    this.sc_firstDayOfWeek = configuration.firstDayOfWeek;
    this.sc_startDayHour = configuration.startDayHour;
    this.sc_endDayHour = configuration.endDayHour;
    this.sc_showAllDayPanel = configuration.showAllDayPanel;
    this.sc_views = configuration.views;
    this.sc_cellDuration = configuration.cellDuration;
    this.sc_height = configuration.height;
    this.sc_width = configuration.width;
    this.sc_resources = configuration.resources;
   


    // update the options

    if(this.sc_rendered== true){
      if(this.sc_timezone){this.calendar.option("timezone",  this.sc_timezone);}
      if(this.sc_timcurrentViewezone){this.calendar.option("currentView",  this.sc_timcurrentViewezone);}
      if(this.sc_currentDate){this.calendar.option("currentDate",  this.sc_currentDate);}
      if(this.sc_firstDayOfWeek){this.calendar.option("firstDayOfWeek",  this.sc_firstDayOfWeek);}
      if(this.sc_startDayHour){this.calendar.option("startDayHour",  this.sc_startDayHour);}
      if(this.sc_endDayHour){this.calendar.option("endDayHour",  this.sc_endDayHour);}
      if(this.sc_showAllDayPanel){this.calendar.option("showAllDayPanel",  this.sc_showAllDayPanel);}
      if(this.sc_views){this.calendar.option("views",  this.sc_views);}
      if(this.sc_cellDuration){this.calendar.option("cellDuration",  this.sc_cellDuration);}
      if(this.sc_height>0){this.calendar.option("height",  this.sc_height);}
      if( this.sc_width>0){this.calendar.option("width",  this.sc_width);}
      if(this.sc_resources){this.calendar.option("resources",  this.sc_resources);}
    }
  }
});


IDdxScheduler.prototype.Realize = function (parent, cls) {
  if(!IDdxScheduler.inited) {
    IDdxScheduler.Realize = parent;
    this.scheduler_rendered = false
    return;
  }

  
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.calendarDiv = document.createElement("div");
  this.calendarDiv.setAttribute("id","myScheduler");
  parent.appendChild(this.calendarDiv);






  if (this.calendar) {
    this.calendar.destroy();
  }
  
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale(navigator.language);
    $('#myScheduler').dxScheduler({
      // DA MIGLIORARE
      dataSource: [],
      groups: ['employeeID'],
      cellDuration: 15,
      resources: [
        {
          fieldExpr: 'employeeID',
          allowMultiple: false,
          dataSource: [{}],
          label: 'Employee',
        },
      ],
      

      timeCellTemplate(itemData, itemIndex, itemElement) {
        const element = $(`<div>${itemData.text}</div>`);
        const { date } = itemData;
        element.append('<div class="cafe" />');
        return itemElement.append(element);
      },
      
      onAppointmentAdded: function(event) {
        if(event)
          pthis.SendEvent("AppointmentAdded", [event.appointmentData]);
      }, 

      onAppointmentAdding: function(event) {
        if(event)
          pthis.SendEvent("AppointmentAdding", [event.appointmentData]);
      }, 

      onAppointmentClick: function(event) {
        if(event){
          event.cancel = true;
          pthis.SendEvent("AppointmentClick", [event.appointmentData]);
        }
      }, 

      onAppointmentContextMenu: function(event) {
        if(event)
          pthis.SendEvent("AppointmentContextMenu", [event.appointmentData]);
      }, 

      
      // double click on event
      onAppointmentDblClick: function(event) {
        if(event){
          event.cancel = true;
          pthis.SendEvent("AppointmentDblClick", [event.appointmentData]);
        }           
      }, 

      onAppointmentDeleted: function(event) {
        if(event)
          pthis.SendEvent("AppointmentDeleted", [event.appointmentData]);
      }, 

      onAppointmentDeleting: function(event) {
        if(event)
          pthis.SendEvent("AppointmentDeleting", [event.appointmentData]);
      }, 

      onAppointmentFormOpening: function(event) {
        if(event)
          pthis.SendEvent("AppointmentFormOpening", [event.appointmentData]);
      }, 

      onAppointmentRendered: function(event) {
        if(event){
          // color is a custom property we defined in INDE: it is a String like #FFFFFF
          if(event.appointmentData.color){
            event.appointmentElement[0].style.backgroundColor = event.appointmentData.color;
          }
          pthis.SendEvent("AppointmentRendered", [event.appointmentData]);
        }
      },
        

      onAppointmentUpdated: function(event) {
        if(event)
          pthis.SendEvent("AppointmentUpdated", [event.appointmentData]);
      }, 
      onAppointmentUpdating: function(event) {
        if(event){
          if(event.oldData.editable){
            pthis.SendEvent("AppointmentUpdating", [event.oldData, event.newData]);
          }
          else{
            event.cancel = true;
          }
        }
      }, 
      onCellClick: function(event) {
        if(event)
          pthis.SendEvent("CellClick", [event.cellData]);
      }, 
      onCellContextMenu : function(event) {
        if(event)
          pthis.SendEvent("CellContextMenu", [event.cellData]);
      }, 
        // OK FINO QUA IN SU
      
      onContentReady  : function(event) {
        if(event)
          pthis.SendEvent("ContentReady", [event.element]);
      },
      onDisposing: function(info) {
        if(info)
          pthis.SendEvent("Disposing ", [info.value]);
      },
      
      onInitialized: function(info) {
        if(info)
          pthis.SendEvent("refreshed", [{something: "something"}]);
      },
      
      
      onOptionChanged: function(data) {
        if(data.name == "currentDate") {
          convertedDate = new Date(data.value).toLocaleDateString('it-IT');
          pthis.SendEvent("CurrentDateChanged", [data.name, convertedDate]);
        }
      },
      
      
      
      appointmentTooltipTemplate(data) {
        eventData = data.targetedAppointmentData;
        return $(`${"<div class='event-tooltip' style='font-size: 12px !important;'>"
                        + "<img width='20' height='20' src='"}${eventData.image}' />`
                        + '<div class=\'event-info\'>'
                            + `<div class='event-title'>${eventData.text}` + '</div>'
                            + '<div>' + `Tipo: ${eventData.type}</div>`
                            + '<div>' + `Descrizione: ${eventData.description}` + '</div>'
                        + '</div>'
                    + '</div>');
      },


      appointmentTemplate(data) {
        const eventData = data.targetedAppointmentData;
        return $(`${"<div class='showtime-preview' style='font-size: 12px !important;'>" 
                          + "<img width='20' height='20' src='"}${eventData.image}'/>`
                          + `<span style="white-space: break-spaces; height: auto;"><strong>${eventData.text}</strong></span>`
                          + `<div style="white-space: break-spaces; height: auto;">Tipo: ${eventData.type}`
                          + '</div>'
                          + `<div style="white-space: break-spaces; height: auto;">${eventData.description}</div>`
                      + '</div>');
      },

      dataCellTemplate(cellData, index, container) {
        const hours = cellData.startDate.getHours();
        /*if(hours > 12 && hours  <= 13){
          container.css('background-color', '#f5f5c9');
        }*/

        if(hours <= 8 || hours >= 17){
          container.css('background-color', '#f5f5f5');
        }


        const day = cellData.startDate.getDay();
        if(day == 0 || day == 6){
          container.css('background-color', '#ededed');
        }
      return container;
      },
      
    
      resourceCellTemplate(cellData) {
        const avatarAndName = document.createElement('div');
        avatarAndName.classList.add('resources');
        avatarAndName.style.backgroundColor = cellData.color;
      
        if (cellData.data.avatar){
          const image = document.createElement('img');
          image.src = cellData.data.avatar;
          image.width = 64;
          image.height = 64;
          image.alt = 'Foto profilo';
          const span = document.createElement('span');
          span.appendChild(image);
          avatarAndName.appendChild(span);
        }
        const textDiv = document.createElement('div');
        textDiv.textContent = cellData.text;
      
        
        avatarAndName.appendChild(textDiv);
      
        const container = document.createElement('div');
        container.appendChild(avatarAndName);
      
        return container;
      },

      
      dateCellTemplate(itemData, itemIndex, itemElement) {
        const dateHeaderContent = $(`<div>${itemData.text}</div>`);
        const actualDay = itemData.date.getDay();
        const isWekeendCheck = actualDay == 0 || actualDay == 6;
        if (isWekeendCheck) {
          itemElement.css('backgroundColor', '#ededed');
        }
        itemElement.css('font-weight', 600);
        itemElement.append(dateHeaderContent);
        return itemElement;
      },

      timeCellTemplate(itemData, itemIndex, itemElement) {
        const element = $(`<div>${itemData.text}</div>`);
        const { date } = itemData;
        const hours = date.getHours();
        if (hours >= 12 && hours < 13) {
          itemElement.css('font-color', 'rgb(242, 245, 188 / 40%');
        }
        const minutes = date.getMinutes();
        return itemElement.append(element);
      },
      
      }
      );
       
      function isWeekEnd(date) {
        const day = date.getDay();
        return day === 0 || day === 6;
      }
    
      function getCurrentTraining(date, employeeID) {
        const result = (date + employeeID) % 3;
        const currentTraining = `training-background-${result}`;
    
        return currentTraining;
      }
        
    this.calendar = $('#myScheduler').dxScheduler("instance");


    // set options
    if(this.sc_timezone){this.calendar.option("timezone",  this.sc_timezone);}
    if(this.sc_timcurrentViewezone){this.calendar.option("currentView",  this.sc_timcurrentViewezone);}
    if(this.sc_currentDate){this.calendar.option("currentDate",  this.sc_currentDate);}
    if(this.sc_firstDayOfWeek){this.calendar.option("firstDayOfWeek",  this.sc_firstDayOfWeek);}
    if(this.sc_startDayHour){this.calendar.option("startDayHour",  this.sc_startDayHour);}
    if(this.sc_endDayHour){this.calendar.option("endDayHour",  this.sc_endDayHour);}
    if(this.sc_showAllDayPanel){this.calendar.option("showAllDayPanel",  this.sc_showAllDayPanel);}
    if(this.sc_views){this.calendar.option("views",  this.sc_views);}
    if(this.sc_cellDuration){this.calendar.option("cellDuration",  this.sc_cellDuration);}
    if(this.sc_height>0){this.calendar.option("height",  this.sc_height);}
    if( this.sc_width>0){this.calendar.option("width",  this.sc_width);}
    if(this.sc_resources){this.calendar.option("resources",  this.sc_resources);}


    this.sc_rendered = true;
           
  }.bind(this), 350);

  this.calendar = $('#myScheduler').dxScheduler("dispose");
}

// custom procedure to udpate the dxScheduler Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDdxScheduler.prototype.updateConfiguration = function(data) {
  this.calendar = $('#myScheduler').dxScheduler(data);
}

// this procedure adds an Appointment in the dxScheduler
// from inde: USE an IDMAP in which store  text, employeeID, startDate and endDate
// to avoid inserting 2 times the same event, before inserting the event in the calendar we check if already exists 
IDdxScheduler.prototype.addEvent = function(data) {
  searchEvent = IDdxScheduler.prototype.findEvent(this.calendar._dataSource._items, data);
  if(!searchEvent){
    this.calendar.addAppointment (data);
  }
}

IDdxScheduler.prototype.findEvent = function(datasource, data) {
  if(data){
    if(data.ID){
      searchedID = data.ID
      dataSourceLenght = datasource.length;
      for(i = 0; i < dataSourceLenght; i++){
        if(datasource[i]){
          currentID = datasource[i].ID;
          if(currentID == searchedID){
            return datasource[i];
          }
        }
      }
    }
  }
}

// this procedure delete an Appointment from the dxScheduler
IDdxScheduler.prototype.deleteEvent = function(data) {
  if(data){
    if(data.ID){
      var foundEvent = IDdxScheduler.prototype.findEvent(this.calendar._dataSource._items, data);
      if(foundEvent){
        this.calendar.deleteAppointment(this.calendar._dataSource._items[i]);
      }
    }
  }
}

// this procedure changes the Options in the configuration IDdxScheduler 
IDdxScheduler.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      if(oName && oValue){
        this.calendar.option(oName, oValue);
      }
    }
  }
}


// this procedure changes language of this scheduler
IDdxScheduler.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

// this procedure delete an Appointment from the dxScheduler
IDdxScheduler.prototype.checkdatasource = function() {
 console.log(this.calendar._dataSource._items);
}

IDdxScheduler.prototype.Unrealize = function ()
{
  if (this.calendar)
    this.calendar.dispose();
  delete this.calendar;
  //
  if (this.calendarDiv.parentNode)
    this.calendarDiv.parentNode.removeChild(this.calendarDiv);
  delete this.calendarDiv;
}

/*
  Buttons js
*/
function test(buttonID,eventID){
  console.log("test has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}