function DevextremeManager(pform){
  CustomElement.call(this, pform);
}

DevextremeManager.prototype = new CustomElement();
DevextremeManager.Init = function() {
  if(DevextremeManager.inited){
    return
  }
  DevextremeManager.inited = true;
}


DevextremeManager.Init();

Object.defineProperty(DevextremeManager.prototype, "data", {
  get: function () {
    return this._data;
  },
  set: function (configuration) {
    this._configuration = configuration;
    this._data = configuration.data;
    this._devcomponent = configuration.component;
    this._customDiv = configuration.div;
        
    if(this.manager){
      this.Realize(DevextremeManager.Realize, DevextremeManager.cls);}
    else {
      if(DevextremeManager.Realize){
        this.Realize(DevextremeManager.Realize, DevextremeManager.cls);
      }
    }
  }
});


DevextremeManager.prototype.Realize = function (parent, cls) {

  if(!this._data){
    DevextremeManager.Realize = parent;
    DevextremeManager.cls = cls;
    return;
  }
  if(!DevextremeManager.inited || this._data.length == 0) {
    DevextremeManager.Realize = parent;
    DevextremeManager.cls = cls;
    return;
  }
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  this.managerDiv = document.createElement("div");
  this.managerDiv.setAttribute("id",this._customDiv);
  parent.appendChild(this.managerDiv);
  
  this.storedParent = parent;

  // avoid 2 or more equal instances of the pivot
  if (this._devinstance) {
    this._devinstance.destroy();
  }
  
  // call the single component Builder
  switch(this._devcomponent){
    case "workflow":
      createWorkflow(this);
  } 
}

DevextremeManager.prototype.setLocale   = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

DevextremeManager.prototype.Unrealize = function ()
{
  if (this._devinstance)
    this._devinstance.dispose();
  delete this._devinstance;
  if(this.managerDiv){
    if (this.managerDiv.parentNode)
      this.managerDiv.parentNode.removeChild(this.managerDiv);
    delete this.managerDiv;
  }
}

// workflow creator
function createWorkflow (managerInstance){
  window.setTimeout( function () {
    DevExpress.localization.locale(navigator.language);
    var customDivPrepared = '#' + managerInstance._customDiv
    $(customDivPrepared).dxDiagram({});      
    managerInstance._devinstance = $(customDivPrepared).dxDiagram("instance");
  }.bind(managerInstance), 350);
  managerInstance._devinstance = $(customDivPrepared).dxDiagram("dispose");
}




