/*!
* DevExtreme (dx.messages.vi.js)
* Version: 23.1.6
* Build date: Fri Oct 13 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        vi: {
            Yes: "C\xf3",
            No: "Kh\xf4ng",
            Cancel: "H\u1ee7y",
            Close: "\u0110\xf3ng",
            Clear: "L\xe0m s\u1ea1ch",
            Done: "Ho\xe0n t\u1ea5t",
            Loading: "\u0110ang t\u1ea3i...",
            Select: "L\u1ef1a ch\u1ecdn...",
            Search: "T\xecm ki\u1ebfm",
            Back: "Quay l\u1ea1i",
            OK: "OK",
            "dxCollectionWidget-noDataText": "Kh\xf4ng c\xf3 d\u1eef li\u1ec7u \u0111\u1ec3 hi\u1ec3n th\u1ecb",
            "dxDropDownEditor-selectLabel": "L\u1ef1a ch\u1ecdn",
            "validation-required": "B\u1eaft bu\u1ed9c",
            "validation-required-formatted": "{0} l\xe0 b\u1eaft bu\u1ed9c",
            "validation-numeric": "Gi\xe1 tr\u1ecb ph\u1ea3i l\xe0 m\u1ed9t s\u1ed1",
            "validation-numeric-formatted": "{0} ph\u1ea3i l\xe0 m\u1ed9t s\u1ed1",
            "validation-range": "Gi\xe1 tr\u1ecb ngo\xe0i kho\u1ea3ng",
            "validation-range-formatted": "{0} ngo\xe0i kho\u1ea3ng",
            "validation-stringLength": "\u0110\u1ed9 d\xe0i c\u1ee7a gi\xe1 tr\u1ecb kh\xf4ng \u0111\xfang",
            "validation-stringLength-formatted": "\u0110\u1ed9 d\xe0i c\u1ee7a {0} kh\xf4ng \u0111\xfang",
            "validation-custom": "Gi\xe1 tr\u1ecb kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-custom-formatted": "{0} kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-async": "Gi\xe1 tr\u1ecb kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-async-formatted": "{0} kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-compare": "C\xe1c gi\xe1 tr\u1ecb kh\xf4ng kh\u1edbp",
            "validation-compare-formatted": "{0} kh\xf4ng kh\u1edbp",
            "validation-pattern": "Gi\xe1 tr\u1ecb kh\xf4ng kh\u1edbp v\u1edbi khu\xf4n m\u1eabu",
            "validation-pattern-formatted": "{0} kh\xf4ng kh\u1edbp v\u1edbi khu\xf4n m\u1eabu",
            "validation-email": "Email kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-email-formatted": "{0} kh\xf4ng h\u1ee3p l\u1ec7",
            "validation-mask": "Gi\xe1 tr\u1ecb kh\xf4ng h\u1ee3p l\u1ec7",
            "dxLookup-searchPlaceholder": "S\u1ed1 k\xfd t\u1ef1 t\u1ed1i thi\u1ec3u: {0}",
            "dxList-pullingDownText": "K\xe9o xu\u1ed1ng \u0111\u1ec3 l\xe0m t\u01b0\u01a1i...",
            "dxList-pulledDownText": "Nh\u1ea3 ra \u0111\u1ec3 l\xe0m t\u01b0\u01a1i...",
            "dxList-refreshingText": "\u0110ang l\xe0m t\u01b0\u01a1i...",
            "dxList-pageLoadingText": "\u0110ang t\u1ea3i...",
            "dxList-nextButtonText": "Th\xeam",
            "dxList-selectAll": "Ch\u1ecdn T\u1ea5t c\u1ea3",
            "dxListEditDecorator-delete": "X\xf3a",
            "dxListEditDecorator-more": "Th\xeam",
            "dxScrollView-pullingDownText": "K\xe9o xu\u1ed1ng \u0111\u1ec3 l\xe0m t\u01b0\u01a1i...",
            "dxScrollView-pulledDownText": "Nh\u1ea3 ra \u0111\u1ec3 l\xe0m t\u01b0\u01a1i...",
            "dxScrollView-refreshingText": "L\xe0m t\u01b0\u01a1i...",
            "dxScrollView-reachBottomText": "\u0110ang t\u1ea3i...",
            "dxDateBox-simulatedDataPickerTitleTime": "L\u1ef1a ch\u1ecdn th\u1eddi gian",
            "dxDateBox-simulatedDataPickerTitleDate": "L\u1ef1a ch\u1ecdn ng\xe0y",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Ch\u1ecdn ng\xe0y v\xe0 gi\u1edd",
            "dxDateBox-validation-datetime": "Gi\xe1 tr\u1ecb ph\u1ea3i l\xe0 ng\xe0y ho\u1eb7c gi\u1edd",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Ng\xe0y b\u1eaft \u0111\u1ea7u",
            "dxDateRangeBox-endDateLabel": "Ng\xe0y k\u1ebft th\xfac",
            "dxFileUploader-selectFile": "Ch\u1ecdn t\u1eadp tin",
            "dxFileUploader-dropFile": "ho\u1eb7c Th\u1ea3 t\u1eadp tin v\xe0o \u0111\xe2y",
            "dxFileUploader-bytes": "byte",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "Upload",
            "dxFileUploader-uploaded": "\u0110\xe3 upload",
            "dxFileUploader-readyToUpload": "S\u1eb5n s\xe0ng \u0111\u1ec3 upload",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "Upload th\u1ea5t b\u1ea1i",
            "dxFileUploader-invalidFileExtension": "Ki\u1ec3u t\u1eadp tin kh\xf4ng cho ph\xe9p",
            "dxFileUploader-invalidMaxFileSize": "T\u1eadp tin qu\xe1 l\u1edbn",
            "dxFileUploader-invalidMinFileSize": "T\u1eadp tin qu\xe1 nh\u1ecf",
            "dxRangeSlider-ariaFrom": "T\u1eeb",
            "dxRangeSlider-ariaTill": "V\u1eabn",
            "dxSwitch-switchedOnText": "ON",
            "dxSwitch-switchedOffText": "OFF",
            "dxForm-optionalMark": "t\xf9y ch\u1ecdn",
            "dxForm-requiredMessage": "{0} l\xe0 b\u1eaft bu\u1ed9c",
            "dxNumberBox-invalidValueMessage": "Gi\xe1 tr\u1ecb ph\u1ea3i l\xe0 m\u1ed9t s\u1ed1",
            "dxNumberBox-noDataText": "Kh\xf4ng c\xf3 d\u1eef li\u1ec7u",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Tr\xecnh ch\u1ecdn c\u1ed9t",
            "dxDataGrid-columnChooserEmptyText": "K\xe9o m\u1ed9t c\u1ed9t v\xe0o \u0111\xe2y \u0111\u1ec3 \u1ea9n n\xf3 \u0111i",
            "dxDataGrid-groupContinuesMessage": "Ti\u1ebfp t\u1ee5c \u1edf trang ti\u1ebfp theo",
            "dxDataGrid-groupContinuedMessage": "\u0110\u01b0\u1ee3c ti\u1ebfp t\u1ee5c t\u1eeb trang tr\u01b0\u1edbc",
            "dxDataGrid-groupHeaderText": "Nh\xf3m theo C\u1ed9t n\xe0y",
            "dxDataGrid-ungroupHeaderText": "B\u1ecf Nh\xf3m",
            "dxDataGrid-ungroupAllText": "B\u1ecf Nh\xf3m t\u1ea5t c\u1ea3",
            "dxDataGrid-editingEditRow": "S\u1eeda",
            "dxDataGrid-editingSaveRowChanges": "L\u01b0u",
            "dxDataGrid-editingCancelRowChanges": "H\u1ee7y",
            "dxDataGrid-editingDeleteRow": "X\xf3a",
            "dxDataGrid-editingUndeleteRow": "Kh\xf4ng x\xf3a",
            "dxDataGrid-editingConfirmDeleteMessage": "B\u1ea1n c\xf3 th\u1eadt s\u1ef1 mu\u1ed1n x\xf3a b\u1ea3n ghi n\xe0y kh\xf4ng?",
            "dxDataGrid-validationCancelChanges": "H\u1ee7y b\u1ecf c\xe1c thay \u0111\u1ed5i",
            "dxDataGrid-groupPanelEmptyText": "K\xe9o ti\xeau \u0111\u1ec1 m\u1ed9t c\u1ed9t v\xe0o \u0111\xe2y \u0111\u1ec3 \u0111\u1ec3 nh\xf3m c\u1ed9t \u0111\xf3",
            "dxDataGrid-noDataText": "Kh\xf4ng c\xf3 d\u1eef li\u1ec7u",
            "dxDataGrid-searchPanelPlaceholder": "T\xecm ki\u1ebfm...",
            "dxDataGrid-filterRowShowAllText": "(T\u1ea5t c\u1ea3)",
            "dxDataGrid-filterRowResetOperationText": "L\xe0m l\u1ea1i",
            "dxDataGrid-filterRowOperationEquals": "B\u1eb1ng",
            "dxDataGrid-filterRowOperationNotEquals": "Kh\xf4ng b\u1eb1ng",
            "dxDataGrid-filterRowOperationLess": "Nh\u1ecf h\u01a1n",
            "dxDataGrid-filterRowOperationLessOrEquals": "Nh\u1ecf h\u01a1n ho\u1eb7c b\u1eb1ng",
            "dxDataGrid-filterRowOperationGreater": "L\u1edbn h\u01a1n",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "L\u1edbn h\u01a1n ho\u1eb7c b\u1eb1ng",
            "dxDataGrid-filterRowOperationStartsWith": "B\u1eaft \u0111\u1ea7u b\u1edfi",
            "dxDataGrid-filterRowOperationContains": "Ch\u1ee9a",
            "dxDataGrid-filterRowOperationNotContains": "Kh\xf4ng ch\u1ee9a",
            "dxDataGrid-filterRowOperationEndsWith": "K\u1ebft th\xfac b\u1edfi",
            "dxDataGrid-filterRowOperationBetween": "Gi\u1eefa",
            "dxDataGrid-filterRowOperationBetweenStartText": "B\u1eaft \u0111\u1ea7u",
            "dxDataGrid-filterRowOperationBetweenEndText": "K\u1ebft th\xfac",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "\xc1p d\u1ee5ng b\u1ed9 l\u1ecdc",
            "dxDataGrid-trueText": "\u0111\xfang",
            "dxDataGrid-falseText": "sai",
            "dxDataGrid-sortingAscendingText": "S\u1eafp x\u1ebfp T\u0103ng d\u1ea7n",
            "dxDataGrid-sortingDescendingText": "S\u1eafp x\u1ebfp Gi\u1ea3m d\u1ea7n",
            "dxDataGrid-sortingClearText": "Lo\u1ea1i b\u1ecf vi\u1ec7c s\u1eafp x\u1ebfp",
            "dxDataGrid-editingSaveAllChanges": "L\u01b0u l\u1ea1i c\xe1c thay \u0111\u1ed5i",
            "dxDataGrid-editingCancelAllChanges": "Lo\u1ea1i b\u1ecf c\xe1c thay \u0111\u1ed5i",
            "dxDataGrid-editingAddRow": "Th\xeam m\u1ed9t h\xe0ng",
            "dxDataGrid-summaryMin": "Nh\u1ecf nh\u1ea5t: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Nh\u1ecf nh\u1ea5t c\u1ee7a {1} l\xe0 {0}",
            "dxDataGrid-summaryMax": "L\u1edbn nh\u1ea5t: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "L\u1edbn nh\u1ea5t c\u1ee7a {1} l\xe0 {0}",
            "dxDataGrid-summaryAvg": "Trung b\xecnh: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Trung b\xecnh c\u1ee7a {1} l\xe0 {0}",
            "dxDataGrid-summarySum": "T\u1ed5ng: {0}",
            "dxDataGrid-summarySumOtherColumn": "T\u1ed5ng c\u1ee7a {1} l\xe0 {0}",
            "dxDataGrid-summaryCount": "S\u1ed1 l\u01b0\u1ee3ng: {0}",
            "dxDataGrid-columnFixingFix": "C\u1ed1 \u0111\u1ecbnh",
            "dxDataGrid-columnFixingUnfix": "Kh\xf4ng c\u1ed1 \u0111\u1ecbnh",
            "dxDataGrid-columnFixingLeftPosition": "\u0110\u1ebfn b\xean tr\xe1i",
            "dxDataGrid-columnFixingRightPosition": "\u0110\u1ebfn b\xean ph\u1ea3i",
            "dxDataGrid-exportTo": "Xu\u1ea5t ra",
            "dxDataGrid-exportToExcel": "Xu\u1ea5t ra T\u1eadp tin Excel",
            "dxDataGrid-exporting": "Xu\u1ea5t kh\u1ea9u...",
            "dxDataGrid-excelFormat": "T\u1eadp tin Excel",
            "dxDataGrid-selectedRows": "C\xe1c h\xe0ng \u0111\u01b0\u1ee3c ch\u1ecdn",
            "dxDataGrid-exportSelectedRows": "Xu\u1ea5t ra c\xe1c h\xe0ng \u0111\u01b0\u1ee3c ch\u1ecdn",
            "dxDataGrid-exportAll": "Xu\u1ea5t ra t\u1ea5t c\u1ea3 d\u1eef li\u1ec7u",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tr\u1ed1ng)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "H\u1ee7y",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "C\u1ed9t",
            "dxDataGrid-ariaValue": "Gi\xe1 tr\u1ecb",
            "dxDataGrid-ariaFilterCell": "L\u1ecdc \xf4",
            "dxDataGrid-ariaCollapse": "Thu l\u1ea1i",
            "dxDataGrid-ariaExpand": "M\u1edf ra",
            "dxDataGrid-ariaDataGrid": "L\u01b0\u1edbi d\u1eef li\u1ec7u",
            "dxDataGrid-ariaSearchInGrid": "T\xecm ki\u1ebfm trong l\u01b0\u1edbi d\u1eef li\u1ec7u",
            "dxDataGrid-ariaSelectAll": "Ch\u1ecdn t\u1ea5t c\u1ea3",
            "dxDataGrid-ariaSelectRow": "Ch\u1ecdn h\xe0ng",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Tr\xecnh d\u1ef1ng B\u1ed9 l\u1ecdc",
            "dxDataGrid-filterPanelCreateFilter": "T\u1ea1o B\u1ed9 l\u1ecdc",
            "dxDataGrid-filterPanelClearFilter": "Lo\u1ea1i b\u1ecf",
            "dxDataGrid-filterPanelFilterEnabledHint": "K\xedch ho\u1ea1t B\u1ed9 l\u1ecdc",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Th\xeam",
            "dxPager-infoText": "Trang {0} c\u1ee7a {1} ({2} m\u1ee5c)",
            "dxPager-pagesCountText": "c\u1ee7a",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "T\u1ea5t c\u1ea3",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "T\u1ed5ng t\u1ea5t c\u1ea3",
            "dxPivotGrid-total": "{0} T\u1ed5ng",
            "dxPivotGrid-fieldChooserTitle": "Tr\xecnh l\u1ef1a ch\u1ecdn Tr\u01b0\u1eddng",
            "dxPivotGrid-showFieldChooser": "Hi\u1ec3n th\u1ecb Tr\xecnh l\u1ef1a ch\u1ecdn Tr\u01b0\u1eddng",
            "dxPivotGrid-expandAll": "M\u1edf r\u1ed9ng t\u1ea5t c\u1ea3",
            "dxPivotGrid-collapseAll": "Thu l\u1ea1i t\u1ea5t c\u1ea3",
            "dxPivotGrid-sortColumnBySummary": 'S\u1eafp x\u1ebfp "{0}" theo C\u1ed9t n\xe0y',
            "dxPivotGrid-sortRowBySummary": 'S\u1eafp x\u1ebfp "{0}" theo H\xe0ng n\xe0y',
            "dxPivotGrid-removeAllSorting": "Lo\u1ea1i b\u1ecf t\u1ea5t c\u1ea3 vi\u1ec7c s\u1eafp x\u1ebfp",
            "dxPivotGrid-dataNotAvailable": "Kh\xf4ng c\xf3 s\u1eb5n",
            "dxPivotGrid-rowFields": "C\xe1c tr\u01b0\u1eddng c\u1ee7a h\xe0ng",
            "dxPivotGrid-columnFields": "C\xe1c tr\u01b0\u1eddng c\u1ee7a c\u1ed9t",
            "dxPivotGrid-dataFields": "C\xe1c tr\u01b0\u1eddng D\u1eef li\u1ec7u",
            "dxPivotGrid-filterFields": "L\u1ecdc c\xe1c tr\u01b0\u1eddng",
            "dxPivotGrid-allFields": "T\u1ea5t c\u1ea3 c\xe1c tr\u01b0\u1eddng",
            "dxPivotGrid-columnFieldArea": "Th\u1ea3 c\xe1c tr\u01b0\u1eddng c\u1ee7a c\u1ed9t v\xe0o \u0111\xe2y",
            "dxPivotGrid-dataFieldArea": "Th\u1ea3 c\xe1c tr\u01b0\u1eddng d\u1eef li\u1ec7u v\xe0o \u0111\xe2y",
            "dxPivotGrid-rowFieldArea": "Th\u1ea3 c\xe1c tr\u01b0\u1eddng c\u1ee7a h\xe0ng v\xe0o \u0111\xe2y",
            "dxPivotGrid-filterFieldArea": "Th\u1ea3 b\u1ed9 l\u1ecdc c\xe1c tr\u01b0\u1eddng v\xe0o \u0111\xe2y",
            "dxScheduler-editorLabelTitle": "Ch\u1ee7 \u0111\u1ec1",
            "dxScheduler-editorLabelStartDate": "Ng\xe0y b\u1eaft \u0111\u1ea7u",
            "dxScheduler-editorLabelEndDate": "Ng\xe0y k\u1ebft th\xfac",
            "dxScheduler-editorLabelDescription": "M\xf4 t\u1ea3",
            "dxScheduler-editorLabelRecurrence": "L\u1eb7p l\u1ea1i",
            "dxScheduler-openAppointment": "M\u1edf l\u1ecbch h\u1eb9n",
            "dxScheduler-recurrenceNever": "Kh\xf4ng bao gi\u1edd",
            "dxScheduler-recurrenceMinutely": "Minutely",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "H\xe0ng ng\xe0y",
            "dxScheduler-recurrenceWeekly": "H\xe0ng tu\u1ea7n",
            "dxScheduler-recurrenceMonthly": "H\xe0ng th\xe1ng",
            "dxScheduler-recurrenceYearly": "H\xe0ng n\u0103m",
            "dxScheduler-recurrenceRepeatEvery": "L\u1eb7p l\u1ea1i m\xe3i",
            "dxScheduler-recurrenceRepeatOn": "B\u1eadt ch\u1ebf \u0111\u1ed9 L\u1eb7p l\u1ea1i",
            "dxScheduler-recurrenceEnd": "K\u1ebft th\xfac vi\u1ec7c l\u1eb7p l\u1ea1i",
            "dxScheduler-recurrenceAfter": "Sau",
            "dxScheduler-recurrenceOn": "V\xe0o",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "ng\xe0y",
            "dxScheduler-recurrenceRepeatWeekly": "tu\u1ea7n",
            "dxScheduler-recurrenceRepeatMonthly": "th\xe1ng",
            "dxScheduler-recurrenceRepeatYearly": "n\u0103m",
            "dxScheduler-switcherDay": "Ng\xe0y",
            "dxScheduler-switcherWeek": "Tu\u1ea7n",
            "dxScheduler-switcherWorkWeek": "Tu\u1ea7n L\xe0m vi\u1ec7c",
            "dxScheduler-switcherMonth": "Th\xe1ng",
            "dxScheduler-switcherAgenda": "L\u1ecbch tr\xecnh",
            "dxScheduler-switcherTimelineDay": "D\xf2ng th\u1eddi gian Ng\xe0y",
            "dxScheduler-switcherTimelineWeek": "D\xf2ng th\u1eddi gian Tu\u1ea7n",
            "dxScheduler-switcherTimelineWorkWeek": "D\xf2ng th\u1eddi gian Tu\u1ea7n l\xe0m vi\u1ec7c",
            "dxScheduler-switcherTimelineMonth": "D\xf2ng th\u1eddi gian Th\xe1ng",
            "dxScheduler-recurrenceRepeatOnDate": "v\xe0o ng\xe0y",
            "dxScheduler-recurrenceRepeatCount": "s\u1ed1 l\u1ea7n di\u1ec5n ra",
            "dxScheduler-allDay": "C\u1ea3 ng\xe0y",
            "dxScheduler-confirmRecurrenceEditMessage": "B\u1ea1n c\xf3 mu\u1ed1n s\u1eeda ch\u1ec9 L\u1ecbch h\u1eb9n n\xe0y ho\u1eb7c To\xe0n b\u1ed9 chu\u1ed7i?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "B\u1ea1n c\xf3 mu\u1ed1n x\xf3a ch\u1ec9 L\u1ecbch h\u1eb9n n\xe0y ho\u1eb7c To\xe0n b\u1ed9 chu\u1ed7i?",
            "dxScheduler-confirmRecurrenceEditSeries": "S\u1eeda chu\u1ed7i",
            "dxScheduler-confirmRecurrenceDeleteSeries": "X\xf3a chu\u1ed7i",
            "dxScheduler-confirmRecurrenceEditOccurrence": "S\u1eeda L\u1ecbch h\u1eb9n",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "X\xf3a L\u1ecbch h\u1eb9n",
            "dxScheduler-noTimezoneTitle": "Kh\xf4ng c\xf3 m\xfai gi\u1edd",
            "dxScheduler-moreAppointments": "{0} th\xeam",
            "dxCalendar-todayButtonText": "H\xf4m nay",
            "dxCalendar-ariaWidgetName": "L\u1ecbch",
            "dxCalendar-ariaHotKeysInfo": "To navigate between views, press Control, and then Left Arrow or Right Arrow. To zoom in on a view, press Control, and then Down Arrow. To zoom out, press Control, and then Up Arrow.",
            "dxColorView-ariaRed": "\u0110\u1ecf",
            "dxColorView-ariaGreen": "Xanh l\xe1",
            "dxColorView-ariaBlue": "Xanh n\u01b0\u1edbc bi\u1ec3n",
            "dxColorView-ariaAlpha": "Trong su\u1ed1t",
            "dxColorView-ariaHex": "M\xe3 m\xe0u",
            "dxTagBox-selected": "{0} \u0111\xe3 \u0111\u01b0\u1ee3c ch\u1ecdn",
            "dxTagBox-allSelected": "T\u1ea5t c\u1ea3 \u0111\xe3 \u0111\u01b0\u1ee3c ch\u1ecdn ({0})",
            "dxTagBox-moreSelected": "{0} th\xeam",
            "vizExport-printingButtonText": "In",
            "vizExport-titleMenuText": "Xu\u1ea5t ra/In",
            "vizExport-exportButtonText": "{0} t\u1eadp tin",
            "dxFilterBuilder-and": "V\xe0",
            "dxFilterBuilder-or": "Ho\u1eb7c",
            "dxFilterBuilder-notAnd": "Kh\xf4ng V\xe0",
            "dxFilterBuilder-notOr": "Kh\xf4ng ho\u1eb7c",
            "dxFilterBuilder-addCondition": "Th\xeam \u0110i\u1ec1u ki\u1ec7n",
            "dxFilterBuilder-addGroup": "Th\xeam nh\xf3m",
            "dxFilterBuilder-enterValueText": "<nh\u1eadp gi\xe1 tr\u1ecb>",
            "dxFilterBuilder-filterOperationEquals": "B\u1eb1ng",
            "dxFilterBuilder-filterOperationNotEquals": "Kh\xf4ng b\u1eb1ng",
            "dxFilterBuilder-filterOperationLess": "Nh\u1ecf h\u01a1n",
            "dxFilterBuilder-filterOperationLessOrEquals": "Nh\u1ecf h\u01a1n ho\u1eb7c b\u1eb1ng",
            "dxFilterBuilder-filterOperationGreater": "L\xe0 l\u1edbn h\u01a1n",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "L\xe0 l\u1edbn h\u01a1n ho\u1eb7c b\u1eb1ng",
            "dxFilterBuilder-filterOperationStartsWith": "B\u1eaft \u0111\u1ea7u v\u1edbi",
            "dxFilterBuilder-filterOperationContains": "Ch\u1ee9a",
            "dxFilterBuilder-filterOperationNotContains": "Kh\xf4ng ch\u1ee9a",
            "dxFilterBuilder-filterOperationEndsWith": "K\u1ebft th\xfac b\u1edfi",
            "dxFilterBuilder-filterOperationIsBlank": "L\xe0 tr\u1ed1ng",
            "dxFilterBuilder-filterOperationIsNotBlank": "L\xe0 kh\xf4ng tr\u1ed1ng",
            "dxFilterBuilder-filterOperationBetween": "L\xe0 gi\u1eefa",
            "dxFilterBuilder-filterOperationAnyOf": "L\xe0 b\u1ea5t k\u1ef3 c\u1ee7a",
            "dxFilterBuilder-filterOperationNoneOf": "Kh\xf4ng kh\xf4ng c\xf3 c\u1ee7a",
            "dxHtmlEditor-dialogColorCaption": "\u0110\u1ed5i m\xe0u ph\xf4ng ch\u1eef",
            "dxHtmlEditor-dialogBackgroundCaption": "\u0110\u1ed5i m\xe0u n\u1ec1n",
            "dxHtmlEditor-dialogLinkCaption": "Th\xeam Li\xean k\u1ebft",
            "dxHtmlEditor-dialogLinkUrlField": "\u0110\u01b0\u1eddng d\u1eabn",
            "dxHtmlEditor-dialogLinkTextField": "V\u0103n b\u1ea3n",
            "dxHtmlEditor-dialogLinkTargetField": "M\u1edf li\xean k\u1ebft \u1edf c\u1eeda s\u1ed5 m\u1edbi",
            "dxHtmlEditor-dialogImageCaption": "Th\xeam h\xecnh \u1ea3nh",
            "dxHtmlEditor-dialogImageUrlField": "\u0110\u01b0\u1eddng d\u1eabn",
            "dxHtmlEditor-dialogImageAltField": "V\u0103n b\u1ea3n thay th\u1ebf",
            "dxHtmlEditor-dialogImageWidthField": "R\u1ed9ng (px)",
            "dxHtmlEditor-dialogImageHeightField": "Cao (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rows",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Columns",
            "dxHtmlEditor-dialogInsertTableCaption": "Insert Table",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Ti\xeau \u0111\u1ec1",
            "dxHtmlEditor-normalText": "Ch\u1eef b\xecnh th\u01b0\u1eddng",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxFileManager-newDirectoryName": "Th\u01b0 m\u1ee5c kh\xf4ng t\xean",
            "dxFileManager-rootDirectoryName": "C\xe1c t\u1eadp tin",
            "dxFileManager-errorNoAccess": "T\u1eeb ch\u1ed1i truy c\u1eadp. Thao t\xe1c kh\xf4ng th\u1ec3 ho\xe0n t\u1ea5t.",
            "dxFileManager-errorDirectoryExistsFormat": "Th\u01b0 m\u1ee5c '{0}' \u0111\xe3 t\u1ed3n t\u1ea1i.",
            "dxFileManager-errorFileExistsFormat": "T\u1eadp tin '{0}' \u0111\xe3 t\u1ed3n t\u1ea1i.",
            "dxFileManager-errorFileNotFoundFormat": "T\u1eadp tin '{0}' kh\xf4ng t\xecm th\u1ea5y",
            "dxFileManager-errorDirectoryNotFoundFormat": "Th\u01b0 m\u1ee5c '{0}' kh\xf4ng t\xecm th\u1ea5y",
            "dxFileManager-errorWrongFileExtension": "Ph\u1ea7n m\u1edf r\u1ed9ng c\u1ee7a t\u1eadp tin kh\xf4ng cho ph\xe9p",
            "dxFileManager-errorMaxFileSizeExceeded": "K\xedch th\u01b0\u1edbc c\u1ee7a t\u1eadp tin v\u01b0\u1ee3t qu\xe1 k\xedch th\u01b0\u1edbc t\u1ed1i \u0111a cho ph\xe9p",
            "dxFileManager-errorInvalidSymbols": "This name contains invalid characters.",
            "dxFileManager-errorDefault": "L\u1ed7i kh\xf4ng x\xe1c \u0111\u1ecbnh.",
            "dxFileManager-errorDirectoryOpenFailed": "The directory cannot be opened",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "Copy to",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "Refresh",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "Clear selection",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Move",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copy to",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copy",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "Save",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "Create",
            "dxFileManager-dialogDeleteItemTitle": "Delete",
            "dxFileManager-dialogDeleteItemButtonText": "Delete",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "Cancel",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Name",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "Chung",
            "dxDiagram-categoryFlowchart": "L\u01b0u \u0111\u1ed3",
            "dxDiagram-categoryOrgChart": "S\u01a1 \u0111\u1ed3 t\u1ed5 ch\u1ee9c",
            "dxDiagram-categoryContainers": "Tr\xecnh ch\u1ee9a",
            "dxDiagram-categoryCustom": "T\xf9y ch\u1ec9nh",
            "dxDiagram-commandExportToSvg": "Xu\u1ea5t ra SVG",
            "dxDiagram-commandExportToPng": "Xu\u1ea5t ra PNG",
            "dxDiagram-commandExportToJpg": "Xu\u1ea5t ra JPEG",
            "dxDiagram-commandUndo": "H\u1ee7y thao t\xe1c",
            "dxDiagram-commandRedo": "L\xe0m l\u1ea1i thao t\xe1c",
            "dxDiagram-commandFontName": "T\xean ph\xf4ng ch\u1eef",
            "dxDiagram-commandFontSize": "K\xedch th\u01b0\u1edbc ph\xf4ng ch\u1eef",
            "dxDiagram-commandBold": "\u0110\u1eadm",
            "dxDiagram-commandItalic": "Nghi\xeang",
            "dxDiagram-commandUnderline": "G\u1ea1ch d\u01b0\u1edbi",
            "dxDiagram-commandTextColor": "M\xe0u ch\u1eef",
            "dxDiagram-commandLineColor": "M\xe0u \u0111\u01b0\u1eddng",
            "dxDiagram-commandLineWidth": "Line Width",
            "dxDiagram-commandLineStyle": "Line Style",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Dotted",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "\u0110\u1ed5 m\xe0u",
            "dxDiagram-commandAlignLeft": "Canh tr\xe1i",
            "dxDiagram-commandAlignCenter": "Canh gi\u1eefa",
            "dxDiagram-commandAlignRight": "Canh ph\u1ea3i",
            "dxDiagram-commandConnectorLineType": "Lo\u1ea1i \u0111\u01b0\u1eddng n\u1ed1i",
            "dxDiagram-commandConnectorLineStraight": "Th\u1eb3ng",
            "dxDiagram-commandConnectorLineOrthogonal": "Tr\u1ef1c giao",
            "dxDiagram-commandConnectorLineStart": "B\u1eaft \u0111\u1ea7u \u0111\u01b0\u1eddng n\u1ed1i",
            "dxDiagram-commandConnectorLineEnd": "K\u1ebft th\xfac \u0111\u01b0\u1eddng n\u1ed1i",
            "dxDiagram-commandConnectorLineNone": "Kh\xf4ng",
            "dxDiagram-commandConnectorLineArrow": "M\u0169i t\xean",
            "dxDiagram-commandFullscreen": "To\xe0n m\xe0n h\xecnh",
            "dxDiagram-commandUnits": "\u0110\u01a1n v\u1ecb",
            "dxDiagram-commandPageSize": "K\xedch th\u01b0\u1edbc trang",
            "dxDiagram-commandPageOrientation": "Chi\u1ec1u c\u1ee7a trang",
            "dxDiagram-commandPageOrientationLandscape": "Trang ngang",
            "dxDiagram-commandPageOrientationPortrait": "Trang d\u1ecdc",
            "dxDiagram-commandPageColor": "M\xe0u trang",
            "dxDiagram-commandShowGrid": "Hi\u1ec3n th\u1ecb l\u01b0\u1edbi",
            "dxDiagram-commandSnapToGrid": "Neo v\xe0o l\u01b0\u1edbi",
            "dxDiagram-commandGridSize": "K\xedch th\u01b0\u1edbc l\u01b0\u1edbi",
            "dxDiagram-commandZoomLevel": "M\u1ee9c ph\xf3ng \u0111\u1ea1i",
            "dxDiagram-commandAutoZoom": "Ph\xf3ng \u0111\u1ea1i t\u1ef1 \u0111\u1ed9ng",
            "dxDiagram-commandFitToContent": "Fit to Content",
            "dxDiagram-commandFitToWidth": "Fit to Width",
            "dxDiagram-commandAutoZoomByContent": "Auto Zoom by Content",
            "dxDiagram-commandAutoZoomByWidth": "Auto Zoom by Width",
            "dxDiagram-commandSimpleView": "Ki\u1ec3u xem \u0111\u01a1n gi\u1ea3n",
            "dxDiagram-commandCut": "C\u1eaft",
            "dxDiagram-commandCopy": "Sao ch\xe9p",
            "dxDiagram-commandPaste": "D\xe1n",
            "dxDiagram-commandSelectAll": "Ch\u1ecdn t\u1ea5t c\u1ea3",
            "dxDiagram-commandDelete": "X\xf3a",
            "dxDiagram-commandBringToFront": "Mang \u0111\u1ebfn ph\xeda tr\u01b0\u1edbc",
            "dxDiagram-commandSendToBack": "Mang \u0111\u1ebfn ph\xeda sau",
            "dxDiagram-commandLock": "Kh\xf3a",
            "dxDiagram-commandUnlock": "M\u1edf kh\xf3a",
            "dxDiagram-commandInsertShapeImage": "Ch\xe8n \u1ea3nh...",
            "dxDiagram-commandEditShapeImage": "\u0110\u1ed5i \u1ea3nh...",
            "dxDiagram-commandDeleteShapeImage": "X\xf3a \u1ea3nh",
            "dxDiagram-commandLayoutLeftToRight": "Left-to-right",
            "dxDiagram-commandLayoutRightToLeft": "Right-to-left",
            "dxDiagram-commandLayoutTopToBottom": "Top-to-bottom",
            "dxDiagram-commandLayoutBottomToTop": "Bottom-to-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "H\u1ee7y",
            "dxDiagram-dialogInsertShapeImageTitle": "Ch\xe8n \u1ea3nh",
            "dxDiagram-dialogEditShapeImageTitle": "\u0110\u1ed5i \u1ea3nh",
            "dxDiagram-dialogEditShapeImageSelectButton": "Ch\u1ecdn \u1ea3nh",
            "dxDiagram-dialogEditShapeImageLabelText": "ho\u1eb7c th\u1ea3 t\u1eadp tin v\xe0o \u0111\xe2y",
            "dxDiagram-uiExport": "Xu\u1ea5t ra",
            "dxDiagram-uiProperties": "Thu\u1ed9c t\xednh",
            "dxDiagram-uiSettings": "Settings",
            "dxDiagram-uiShowToolbox": "Show Toolbox",
            "dxDiagram-uiSearch": "Search",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "C\xe2y",
            "dxDiagram-uiLayoutLayered": "\u0110\u01b0\u1ee3c x\u1ebfp t\u1ea7ng",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "Page",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Cross",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamond",
            "dxDiagram-shapeHeart": "Heart",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Star",
            "dxDiagram-shapeArrowLeft": "Left Arrow",
            "dxDiagram-shapeArrowUp": "Up Arrow",
            "dxDiagram-shapeArrowRight": "Right Arrow",
            "dxDiagram-shapeArrowDown": "Down Arrow",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "Left Right Arrow",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Decision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Predefined Process",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Multiple Documents",
            "dxDiagram-shapeManualInput": "Manual Input",
            "dxDiagram-shapePreparation": "Preparation",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Internal Storage",
            "dxDiagram-shapePaperTape": "Paper Tape",
            "dxDiagram-shapeManualOperation": "Manual Operation",
            "dxDiagram-shapeDelay": "Delay",
            "dxDiagram-shapeStoredData": "Stored Data",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "Merge",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "Or",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertical Container",
            "dxDiagram-shapeHorizontalContainer": "Horizontal Container",
            "dxDiagram-shapeCardDefaultText": "Person's Name",
            "dxDiagram-shapeCardWithImageOnLeft": "Card with Image on the Left",
            "dxDiagram-shapeCardWithImageOnTop": "Card with Image on the Top",
            "dxDiagram-shapeCardWithImageOnRight": "Card with Image on the Right",
            "dxGantt-dialogTitle": "Title",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "Add",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resources: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Undo",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "Expand All",
            "dxGantt-collapseAll": "Collapse All",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "Zoom In",
            "dxGantt-zoomOut": "Zoom Out",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "S\u1eafp x\u1ebfp T\u0103ng d\u1ea7n",
            "dxGantt-sortingDescendingText": "S\u1eafp x\u1ebfp Gi\u1ea3m d\u1ea7n",
            "dxGantt-sortingClearText": "Lo\u1ea1i b\u1ecf vi\u1ec7c s\u1eafp x\u1ebfp",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}"
        }
    })
}));
