/*!
* DevExtreme (dx.messages.cs.js)
* Version: 23.2.5
* Build date: Mon Mar 11 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        cs: {
            Yes: "Ano",
            No: "Ne",
            Cancel: "Zru\u0161it",
            Close: "Zav\u0159\xedt",
            Clear: "Smazat",
            Done: "Hotovo",
            Loading: "Nahr\xe1v\xe1n\xed...",
            Select: "V\xfdb\u011br...",
            Search: "Hledat",
            Back: "Zp\u011bt",
            OK: "OK",
            "dxCollectionWidget-noDataText": "\u017d\xe1dn\xe1 data k zobrazen\xed",
            "dxDropDownEditor-selectLabel": "V\xfdb\u011br",
            "validation-required": "povinn\xe9",
            "validation-required-formatted": "{0} je povinn\xfdch",
            "validation-numeric": "Hodnota mus\xed b\xfdt \u010d\xedslo",
            "validation-numeric-formatted": "{0} mus\xed b\xfdt \u010d\xedslo",
            "validation-range": "Hodnota je mimo rozsah",
            "validation-range-formatted": "{0} je mimo rozsah",
            "validation-stringLength": "D\xe9lka textov\xe9ho \u0159etezce nen\xed spr\xe1vn\xe1",
            "validation-stringLength-formatted": "D\xe9lka textu {0} nen\xed spr\xe1vn\xe1",
            "validation-custom": "Neplatn\xe1 hodnota",
            "validation-custom-formatted": "{0} je neplatn\xfdch",
            "validation-async": "Neplatn\xe1 hodnota",
            "validation-async-formatted": "{0} je neplatn\xfdch",
            "validation-compare": "Hodnoty se neshoduj\xed",
            "validation-compare-formatted": "{0} se neshoduje",
            "validation-pattern": "Hodnota neodpov\xedd\xe1 vzoru",
            "validation-pattern-formatted": "{0} neodpov\xedd\xe1 vzoru",
            "validation-email": "Neplatn\xfd email",
            "validation-email-formatted": "{0} nen\xed platn\xfd",
            "validation-mask": "Hodnota nen\xed platn\xe1",
            "dxLookup-searchPlaceholder": "Minim\xe1ln\xed po\u010det znak\u016f: {0}",
            "dxList-pullingDownText": "St\xe1hn\u011bte dol\u016f pro obnoven\xed...",
            "dxList-pulledDownText": "Uvoln\u011bte pro obnoven\xed...",
            "dxList-refreshingText": "Obnovuji...",
            "dxList-pageLoadingText": "Nahr\xe1v\xe1m...",
            "dxList-nextButtonText": "V\xedce",
            "dxList-selectAll": "Vybrat v\u0161e",
            "dxListEditDecorator-delete": "Smazat",
            "dxListEditDecorator-more": "V\xedce",
            "dxScrollView-pullingDownText": "St\xe1hn\u011bte dol\u016f pro obnoven\xed...",
            "dxScrollView-pulledDownText": "Uvoln\u011bte pro obnoven\xed...",
            "dxScrollView-refreshingText": "Obnovuji...",
            "dxScrollView-reachBottomText": "Nahr\xe1v\xe1m...",
            "dxDateBox-simulatedDataPickerTitleTime": "Vyberte \u010das",
            "dxDateBox-simulatedDataPickerTitleDate": "Vyberte datum",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Vyberte datum a \u010das",
            "dxDateBox-validation-datetime": "Hodnota mus\xed b\xfdt datum nebo \u010das",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Po\u010d\xe1te\u010dn\xed datum",
            "dxDateRangeBox-endDateLabel": "Koncov\xe9 datum",
            "dxFileUploader-selectFile": "Vyberte soubor",
            "dxFileUploader-dropFile": "nebo p\u0159eneste soubor sem",
            "dxFileUploader-bytes": "byt\u016f",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Nahr\xe1t",
            "dxFileUploader-uploaded": "Nahr\xe1no",
            "dxFileUploader-readyToUpload": "P\u0159ipraveno k nahr\xe1n\xed",
            "dxFileUploader-uploadAbortedMessage": "Nahr\xe1v\xe1n\xed zru\u0161eno",
            "dxFileUploader-uploadFailedMessage": "Nahr\xe1v\xe1n\xed selhalo",
            "dxFileUploader-invalidFileExtension": "Nepovolen\xfd typ souboru",
            "dxFileUploader-invalidMaxFileSize": "Soubor je p\u0159\xedli\u0161 velk\xfd",
            "dxFileUploader-invalidMinFileSize": "Soubor je p\u0159\xedli\u0161 mal\xfd",
            "dxRangeSlider-ariaFrom": "Od",
            "dxRangeSlider-ariaTill": "Do",
            "dxSwitch-switchedOnText": "ZAP",
            "dxSwitch-switchedOffText": "VYP",
            "dxForm-optionalMark": "voliteln\xfd",
            "dxForm-requiredMessage": "{0} je vy\u017eadov\xe1no",
            "dxNumberBox-invalidValueMessage": "Hodnota mus\xed b\xfdt \u010d\xedslo",
            "dxNumberBox-noDataText": "\u017d\xe1dn\xe1 data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "V\xfdb\u011br sloupc\u016f",
            "dxDataGrid-columnChooserEmptyText": "P\u0159esu\u0148te sloupec zde pro skyt\xed",
            "dxDataGrid-groupContinuesMessage": "Pokra\u010dovat na dal\u0161\xed stran\u011b",
            "dxDataGrid-groupContinuedMessage": "Pokra\u010dov\xe1n\xed z p\u0159edchoz\xed strany",
            "dxDataGrid-groupHeaderText": "Slou\u010dit sloupce",
            "dxDataGrid-ungroupHeaderText": "Odd\u011blit",
            "dxDataGrid-ungroupAllText": "Odd\u011blit v\u0161e",
            "dxDataGrid-editingEditRow": "Upravit",
            "dxDataGrid-editingSaveRowChanges": "Ulo\u017eit",
            "dxDataGrid-editingCancelRowChanges": "Zru\u0161it",
            "dxDataGrid-editingDeleteRow": "Smazat",
            "dxDataGrid-editingUndeleteRow": "Obnovit",
            "dxDataGrid-editingConfirmDeleteMessage": "Opravdu chcete smazat tento z\xe1znam?",
            "dxDataGrid-validationCancelChanges": "Zru\u0161it zm\u011bny",
            "dxDataGrid-groupPanelEmptyText": "P\u0159eneste hlavi\u010dku sloupce zde pro slou\u010den\xed",
            "dxDataGrid-noDataText": "\u017d\xe1dn\xe1 data",
            "dxDataGrid-searchPanelPlaceholder": "Hled\xe1n\xed...",
            "dxDataGrid-filterRowShowAllText": "(V\u0161e)",
            "dxDataGrid-filterRowResetOperationText": "Reset",
            "dxDataGrid-filterRowOperationEquals": "Rovn\xe1 se",
            "dxDataGrid-filterRowOperationNotEquals": "Nerovn\xe1 se",
            "dxDataGrid-filterRowOperationLess": "Men\u0161\xed",
            "dxDataGrid-filterRowOperationLessOrEquals": "Men\u0161\xed nebo rovno",
            "dxDataGrid-filterRowOperationGreater": "V\u011bt\u0161\xed",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "V\u011bt\u0161\xed nebo rovno",
            "dxDataGrid-filterRowOperationStartsWith": "Za\u010d\xedn\xe1 na",
            "dxDataGrid-filterRowOperationContains": "Obsahuje",
            "dxDataGrid-filterRowOperationNotContains": "Neobsahuje",
            "dxDataGrid-filterRowOperationEndsWith": "Kon\u010d\xed na",
            "dxDataGrid-filterRowOperationBetween": "Mezi",
            "dxDataGrid-filterRowOperationBetweenStartText": "Za\u010d\xedn\xe1",
            "dxDataGrid-filterRowOperationBetweenEndText": "Kon\u010d\xed",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Pou\u017e\xedt filtr",
            "dxDataGrid-trueText": "Plat\xed",
            "dxDataGrid-falseText": "Neplat\xed",
            "dxDataGrid-sortingAscendingText": "Srovnat vzestupn\u011b",
            "dxDataGrid-sortingDescendingText": "Srovnat sestupn\u011b",
            "dxDataGrid-sortingClearText": "Zru\u0161it rovn\xe1n\xed",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Ulo\u017eit zm\u011bny",
            "dxDataGrid-editingCancelAllChanges": "Zru\u0161it zm\u011bny",
            "dxDataGrid-editingAddRow": "P\u0159idat \u0159\xe1dek",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min {1} je {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max {1} je {0}",
            "dxDataGrid-summaryAvg": "Pr\u016fm.: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Pr\u016fm\u011br ze {1} je {0}",
            "dxDataGrid-summarySum": "Suma: {0}",
            "dxDataGrid-summarySumOtherColumn": "Suma {1} je {0}",
            "dxDataGrid-summaryCount": "Po\u010det: {0}",
            "dxDataGrid-columnFixingFix": "Uchytit",
            "dxDataGrid-columnFixingUnfix": "Uvolnit",
            "dxDataGrid-columnFixingLeftPosition": "Vlevo",
            "dxDataGrid-columnFixingRightPosition": "Vpravo",
            "dxDataGrid-exportTo": "Export",
            "dxDataGrid-exportToExcel": "Export do se\u0161itu Excel",
            "dxDataGrid-exporting": "Export...",
            "dxDataGrid-excelFormat": "soubor Excel",
            "dxDataGrid-selectedRows": "Vybran\xe9 \u0159\xe1dky",
            "dxDataGrid-exportSelectedRows": "Export vybran\xfdch \u0159\xe1dk\u016f",
            "dxDataGrid-exportAll": "Exportovat v\u0161echny z\xe1znamy",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(pr\xe1zdn\xe9)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Zru\u0161it",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Sloupec",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Hodnota",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtrovat bu\u0148ku",
            "dxDataGrid-ariaCollapse": "Sbalit",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Rozbalit",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Datov\xe1 m\u0159\xed\u017eka",
            "dxDataGrid-ariaSearchInGrid": "Hledat v datov\xe9 m\u0159\xed\u017ece",
            "dxDataGrid-ariaSelectAll": "Vybrat v\u0161e",
            "dxDataGrid-ariaSelectRow": "Vybrat \u0159\xe1dek",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Tvorba Filtru",
            "dxDataGrid-filterPanelCreateFilter": "Vytvo\u0159it Filtr",
            "dxDataGrid-filterPanelClearFilter": "Smazat",
            "dxDataGrid-filterPanelFilterEnabledHint": "Povolit Filtr",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "P\u0159idat",
            "dxPager-infoText": "Strana {0} ze {1} ({2} polo\u017eek)",
            "dxPager-pagesCountText": "ze",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "V\u0161e",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Celkem",
            "dxPivotGrid-total": "{0} Celkem",
            "dxPivotGrid-fieldChooserTitle": "V\xfdb\u011br pole",
            "dxPivotGrid-showFieldChooser": "Zobrazit v\xfdb\u011br pole",
            "dxPivotGrid-expandAll": "Rozbalit v\u0161e",
            "dxPivotGrid-collapseAll": "Sbalit v\u0161e",
            "dxPivotGrid-sortColumnBySummary": 'Srovnat "{0}" podle tohoto sloupce',
            "dxPivotGrid-sortRowBySummary": 'Srovnat "{0}" podle tohoto \u0159\xe1dku',
            "dxPivotGrid-removeAllSorting": "Odstranit ve\u0161ker\xe9 t\u0159\xedd\u011bn\xed",
            "dxPivotGrid-dataNotAvailable": "nedostupn\xe9",
            "dxPivotGrid-rowFields": "Pole \u0159\xe1dk\u016f",
            "dxPivotGrid-columnFields": "Pole sloupc\u016f",
            "dxPivotGrid-dataFields": "Pole dat",
            "dxPivotGrid-filterFields": "Filtrovat pole",
            "dxPivotGrid-allFields": "V\u0161echna pole",
            "dxPivotGrid-columnFieldArea": "Zde vlo\u017ete pole sloupc\u016f",
            "dxPivotGrid-dataFieldArea": "Zde vlo\u017ete pole dat",
            "dxPivotGrid-rowFieldArea": "Zde vlo\u017ete pole \u0159\xe1dk\u016f",
            "dxPivotGrid-filterFieldArea": "Zde vlo\u017ete filtr pole",
            "dxScheduler-editorLabelTitle": "P\u0159edm\u011bt",
            "dxScheduler-editorLabelStartDate": "Po\u010d\xe1te\u010dn\xed datum",
            "dxScheduler-editorLabelEndDate": "Koncov\xe9 datum",
            "dxScheduler-editorLabelDescription": "Popis",
            "dxScheduler-editorLabelRecurrence": "Opakovat",
            "dxScheduler-openAppointment": "Otev\u0159\xedt sch\u016fzku",
            "dxScheduler-recurrenceNever": "Nikdy",
            "dxScheduler-recurrenceMinutely": "Minutov\u011b",
            "dxScheduler-recurrenceHourly": "Hodinov\u011b",
            "dxScheduler-recurrenceDaily": "Denn\u011b",
            "dxScheduler-recurrenceWeekly": "T\xfddn\u011b",
            "dxScheduler-recurrenceMonthly": "M\u011bs\xed\u010dn\u011b",
            "dxScheduler-recurrenceYearly": "Ro\u010dn\u011b",
            "dxScheduler-recurrenceRepeatEvery": "Ka\u017ed\xfd",
            "dxScheduler-recurrenceRepeatOn": "Za\u010d\xe1tek opakov\xe1n\xed",
            "dxScheduler-recurrenceEnd": "Konec opakov\xe1n\xed",
            "dxScheduler-recurrenceAfter": "Po",
            "dxScheduler-recurrenceOn": "Zap",
            "dxScheduler-recurrenceRepeatMinutely": "minut(u)",
            "dxScheduler-recurrenceRepeatHourly": "hodin(u)",
            "dxScheduler-recurrenceRepeatDaily": "dn\xed",
            "dxScheduler-recurrenceRepeatWeekly": "t\xfddn\u016f",
            "dxScheduler-recurrenceRepeatMonthly": "m\u011bs\xedc\u016f",
            "dxScheduler-recurrenceRepeatYearly": "rok\u016f",
            "dxScheduler-switcherDay": "Den",
            "dxScheduler-switcherWeek": "T\xfdden",
            "dxScheduler-switcherWorkWeek": "Pracovn\xed t\xfdden",
            "dxScheduler-switcherMonth": "M\u011bs\xedc",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "\u010casov\xe1 osa den",
            "dxScheduler-switcherTimelineWeek": "\u010casov\xe1 osa t\xfdden",
            "dxScheduler-switcherTimelineWorkWeek": "\u010casov\xe1 osa pracovn\xed t\xfdden",
            "dxScheduler-switcherTimelineMonth": "\u010casov\xe1 osa m\u011bs\xedc",
            "dxScheduler-recurrenceRepeatOnDate": "na den",
            "dxScheduler-recurrenceRepeatCount": "v\xfdskyt\u016f",
            "dxScheduler-allDay": "Cel\xfd den",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Chcete upravit pouze tuto sch\u016fzku nebo celou s\xe9rii?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Chcete smazat pouze tuto sch\u016fzku nebo celou s\xe9rii?",
            "dxScheduler-confirmRecurrenceEditSeries": "Upravit s\xe9rii",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Smazat s\xe9rii",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Upravit sch\u016fzku",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Smazat sch\u016fzku",
            "dxScheduler-noTimezoneTitle": "Bez \u010dasov\xe9 z\xf3ny",
            "dxScheduler-moreAppointments": "{0} nav\xedc",
            "dxCalendar-todayButtonText": "Dnes",
            "dxCalendar-ariaWidgetName": "Kalend\xe1\u0159",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxColorView-ariaRed": "\u010cerven\xe1",
            "dxColorView-ariaGreen": "Zelen\xe1",
            "dxColorView-ariaBlue": "Modr\xe1",
            "dxColorView-ariaAlpha": "Pr\u016fhledn\xe1",
            "dxColorView-ariaHex": "K\xf3d barvy",
            "dxTagBox-selected": "{0} vybr\xe1no",
            "dxTagBox-allSelected": "V\u0161e vybr\xe1no ({0})",
            "dxTagBox-moreSelected": "{0} nav\xedc",
            "vizExport-printingButtonText": "Tisk",
            "vizExport-titleMenuText": "Export/import",
            "vizExport-exportButtonText": "{0} soubor\u016f",
            "dxFilterBuilder-and": "A",
            "dxFilterBuilder-or": "NEBO",
            "dxFilterBuilder-notAnd": "NAND",
            "dxFilterBuilder-notOr": "NOR",
            "dxFilterBuilder-addCondition": "P\u0159idat podm\xednku",
            "dxFilterBuilder-addGroup": "P\u0159idat skupinu",
            "dxFilterBuilder-enterValueText": "<vlo\u017ete hodnotu>",
            "dxFilterBuilder-filterOperationEquals": "Rovn\xe1 se",
            "dxFilterBuilder-filterOperationNotEquals": "Nerovn\xe1 se",
            "dxFilterBuilder-filterOperationLess": "Men\u0161\xed ne\u017e",
            "dxFilterBuilder-filterOperationLessOrEquals": "Men\u0161\xed nebo rovno ne\u017e",
            "dxFilterBuilder-filterOperationGreater": "V\u011bt\u0161\xed ne\u017e",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "V\u011bt\u0161\xed nebo rovno ne\u017e",
            "dxFilterBuilder-filterOperationStartsWith": "Za\u010d\xedn\xe1 na",
            "dxFilterBuilder-filterOperationContains": "Obsahuje",
            "dxFilterBuilder-filterOperationNotContains": "Neobsahuje",
            "dxFilterBuilder-filterOperationEndsWith": "Kon\u010d\xed na",
            "dxFilterBuilder-filterOperationIsBlank": "Je pr\xe1zdn\xe9",
            "dxFilterBuilder-filterOperationIsNotBlank": "Nen\xed pr\xe1zdn\xe9",
            "dxFilterBuilder-filterOperationBetween": "Mezi",
            "dxFilterBuilder-filterOperationAnyOf": "Libovoln\xfd z",
            "dxFilterBuilder-filterOperationNoneOf": "\u017d\xe1dn\xfd z",
            "dxHtmlEditor-dialogColorCaption": "Zm\u011bna barvy p\xedsma",
            "dxHtmlEditor-dialogBackgroundCaption": "Zm\u011bna barvy pozad\xed",
            "dxHtmlEditor-dialogLinkCaption": "Vlo\u017eit odkaz",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Text",
            "dxHtmlEditor-dialogLinkTargetField": "Otev\u0159\xedt odkaz v nov\xe9m okn\u011b",
            "dxHtmlEditor-dialogImageCaption": "Vlo\u017eit obr\xe1zek",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternativn\xed text",
            "dxHtmlEditor-dialogImageWidthField": "\u0160\xed\u0159ka (px)",
            "dxHtmlEditor-dialogImageHeightField": "V\xfd\u0161ka (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "\u0158\xe1dk\u016f",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Sloupc\u016f",
            "dxHtmlEditor-dialogInsertTableCaption": "Vlo\u017eit tabulku",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Nadpis",
            "dxHtmlEditor-normalText": "Norm\xe1ln\xed text",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Nepojmenovan\xe1 slo\u017eka",
            "dxFileManager-rootDirectoryName": "Soubory",
            "dxFileManager-errorNoAccess": "P\u0159\xedstup zablokov\xe1n. Operace nem\u016f\u017ee b\xfdt dokon\u010dena.",
            "dxFileManager-errorDirectoryExistsFormat": "Slo\u017eka '{0}' ji\u017e existuje.",
            "dxFileManager-errorFileExistsFormat": "Soubor '{0}' ji\u017e existuje.",
            "dxFileManager-errorFileNotFoundFormat": "Soubor '{0}' nenalezen.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Slo\u017eka '{0}' nebyla nalezena.",
            "dxFileManager-errorWrongFileExtension": "Typ souboru nen\xed povolen. Zak\xe1zan\xe1 p\u0159\xedpona",
            "dxFileManager-errorMaxFileSizeExceeded": "Soubor p\u0159ekro\u010dil maxim\xe1ln\xed povolenou velikost.",
            "dxFileManager-errorInvalidSymbols": "Zadan\xfd n\xe1zev obsahuje nepovolen\xe9 znaky.",
            "dxFileManager-errorDefault": "Nezn\xe1m\xe1 chyba.",
            "dxFileManager-errorDirectoryOpenFailed": "Nelze otev\u0159\xedt slo\u017eku",
            "dxFileManager-commandCreate": "Nov\xe1 slo\u017eka",
            "dxFileManager-commandRename": "P\u0159ejmenovat",
            "dxFileManager-commandMove": "P\u0159esunout",
            "dxFileManager-commandCopy": "Kop\xedrovat",
            "dxFileManager-commandDelete": "Smazat",
            "dxFileManager-commandDownload": "St\xe1hnout",
            "dxFileManager-commandUpload": "Nahr\xe1t soubory",
            "dxFileManager-commandRefresh": "Obnovit",
            "dxFileManager-commandThumbnails": "N\xe1hledy soubor\u016f",
            "dxFileManager-commandDetails": "Detailn\xed p\u0159ehled",
            "dxFileManager-commandClearSelection": "Zru\u0161it v\xfdb\u011br",
            "dxFileManager-commandShowNavPane": "P\u0159epnout naviga\u010dn\xed panel",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "P\u0159esunout do",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "P\u0159esunout",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kop\xedrovat do",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kop\xedrovat",
            "dxFileManager-dialogRenameItemTitle": "P\u0159ejmenovat",
            "dxFileManager-dialogRenameItemButtonText": "Ulo\u017eit",
            "dxFileManager-dialogCreateDirectoryTitle": "Nov\xe1 slo\u017eka",
            "dxFileManager-dialogCreateDirectoryButtonText": "Vytvo\u0159it",
            "dxFileManager-dialogDeleteItemTitle": "Odstranit",
            "dxFileManager-dialogDeleteItemButtonText": "Odstranit",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Opravdu chcete odstranit {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Opravdu chcete odstranit {0} polo\u017eek?",
            "dxFileManager-dialogButtonCancel": "Storno",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Vytv\xe1\u0159\xed se slo\u017eka v {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Vytvo\u0159ena slo\u017eka v {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Slo\u017eka nebyla vytvo\u0159ena",
            "dxFileManager-editingCreateCommonErrorMessage": "Slo\u017eka nebyla vytvo\u0159ena",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "P\u0159ejmenov\xe1n\xed polo\u017eky v {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "P\u0159ejmenov\xe1na polo\u017eka v {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Polo\u017eka nebyla p\u0159ejmenov\xe1na",
            "dxFileManager-editingRenameCommonErrorMessage": "Polo\u017eka nebyla p\u0159ejmenov\xe1na",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Odstra\u0148ov\xe1n\xed polo\u017eky z {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Odstra\u0148uje se {0} polo\u017eek z {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Odstran\u011bna polo\u017eka z {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Odstra\u0148eno {0} polo\u017eek z {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Polo\u017eka nebyla odstran\u011bna",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} polo\u017eek nebylo odstran\u011bno",
            "dxFileManager-editingDeleteCommonErrorMessage": "N\u011bkter\xe9 z polo\u017eek nebyly odstran\u011bny",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "P\u0159esouv\xe1n\xed polo\u017eky do {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "P\u0159esouv\xe1n\xed {0} polo\u017eek do {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Polo\u017eka p\u0159esunuta do {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "P\u0159esunuto {0} polo\u017eek do {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Polo\u017eka nebyla p\u0159esunuta",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} polo\u017eek nebylo p\u0159esunuto",
            "dxFileManager-editingMoveCommonErrorMessage": "N\u011bkter\xe9 polo\u017eky nebyly p\u0159esunuty",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kop\xedrov\xe1n\xed polo\u017eky do {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kop\xedrov\xe1n\xed {0} polo\u017eek do {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Kop\xedruje se polo\u017eka do {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Zkop\xedrov\xe1no {0} polo\u017eek do {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Polo\u017eka nebyla zkop\xedrov\xe1na",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} polo\u017eek nebylo zkop\xedrov\xe1no",
            "dxFileManager-editingCopyCommonErrorMessage": "N\u011bkter\xe9 polo\u017eky nebyly zkop\xedrov\xe1n\xfd",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Nahr\xe1v\xe1 se polo\u017eka {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "N\xe1hr\xe1v\xe1 se {0} polo\u017eek do {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Polo\u017eka nahr\xe1na do {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Nahr\xe1no {0} polo\u017eek do {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Polo\u017eka nebyla nahr\xe1na",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} polo\u017eek nebylo nahr\xe1no",
            "dxFileManager-editingUploadCanceledMessage": "Stornov\xe1no",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "N\xe1zev",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Datum zm\u011bny",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Velikost souboru",
            "dxFileManager-listThumbnailsTooltipTextSize": "Velikost",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Datum zm\u011bny",
            "dxFileManager-notificationProgressPanelTitle": "Pr\u016fb\u011bh",
            "dxFileManager-notificationProgressPanelEmptyListText": "\u017d\xe1dn\xe1 operace",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Stornov\xe1no",
            "dxDiagram-categoryGeneral": "Obecn\xe9",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Organiza\u010dn\xed graf",
            "dxDiagram-categoryContainers": "Kontejnery",
            "dxDiagram-categoryCustom": "Vlastn\xed",
            "dxDiagram-commandExportToSvg": "Export do SVG",
            "dxDiagram-commandExportToPng": "Export do PNG",
            "dxDiagram-commandExportToJpg": "Export do JPEG",
            "dxDiagram-commandUndo": "Zp\u011bt",
            "dxDiagram-commandRedo": "Znovu",
            "dxDiagram-commandFontName": "P\xedsmo",
            "dxDiagram-commandFontSize": "Velikost p\xedsma",
            "dxDiagram-commandBold": "Tu\u010dn\xe9",
            "dxDiagram-commandItalic": "Kurz\xedva",
            "dxDiagram-commandUnderline": "Podtr\u017een\xe9",
            "dxDiagram-commandTextColor": "Barva p\xedsma",
            "dxDiagram-commandLineColor": "Barva \u010d\xe1ry",
            "dxDiagram-commandLineWidth": "\u0160\xed\u0159ka \u010d\xe1ry",
            "dxDiagram-commandLineStyle": "Styl \u010d\xe1ry",
            "dxDiagram-commandLineStyleSolid": "Pln\xe1",
            "dxDiagram-commandLineStyleDotted": "Te\u010dkovan\xe1",
            "dxDiagram-commandLineStyleDashed": "\u010c\xe1rkovan\xe1",
            "dxDiagram-commandFillColor": "Barva v\xfdpln\u011b",
            "dxDiagram-commandAlignLeft": "Zarovnat vlevo",
            "dxDiagram-commandAlignCenter": "Zarovnat na st\u0159ed",
            "dxDiagram-commandAlignRight": "Zarovnat vpravo",
            "dxDiagram-commandConnectorLineType": "Typ \u010d\xe1ry",
            "dxDiagram-commandConnectorLineStraight": "P\u0159\xedm\xe1",
            "dxDiagram-commandConnectorLineOrthogonal": "Lomen\xe1",
            "dxDiagram-commandConnectorLineStart": "Tvar na za\u010d\xe1tku",
            "dxDiagram-commandConnectorLineEnd": "Tvar na konci",
            "dxDiagram-commandConnectorLineNone": "\u017d\xe1dn\xe1",
            "dxDiagram-commandConnectorLineArrow": "\u0160ipka",
            "dxDiagram-commandFullscreen": "Cel\xe1 obrazovka",
            "dxDiagram-commandUnits": "Jednotky",
            "dxDiagram-commandPageSize": "Velikost str\xe1nky",
            "dxDiagram-commandPageOrientation": "Orientace str\xe1nky",
            "dxDiagram-commandPageOrientationLandscape": "Na v\xfd\u0161ku",
            "dxDiagram-commandPageOrientationPortrait": "Na \u0161\xed\u0159ku",
            "dxDiagram-commandPageColor": "Barva str\xe1nky",
            "dxDiagram-commandShowGrid": "Zobrazit m\u0159\xed\u017eku",
            "dxDiagram-commandSnapToGrid": "P\u0159ichytit k m\u0159\xed\u017ece",
            "dxDiagram-commandGridSize": "Velikost m\u0159\xed\u017eky",
            "dxDiagram-commandZoomLevel": "M\u011b\u0159\xedtko",
            "dxDiagram-commandAutoZoom": "Automaticky",
            "dxDiagram-commandFitToContent": "P\u0159izp\u016fsobit obsahu",
            "dxDiagram-commandFitToWidth": "P\u0159izp\u016fsobit \u0161\xed\u0159ce",
            "dxDiagram-commandAutoZoomByContent": "Automaticky p\u0159izp\u016fsobovat obsahu",
            "dxDiagram-commandAutoZoomByWidth": "Automaticky p\u0159izp\u016fsobovat \u0161\xed\u0159ce",
            "dxDiagram-commandSimpleView": "Jednoduch\xe9 zobrazen\xed",
            "dxDiagram-commandCut": "Vyjmout",
            "dxDiagram-commandCopy": "Kop\xedrovat",
            "dxDiagram-commandPaste": "Vlo\u017eit",
            "dxDiagram-commandSelectAll": "Vybrat v\u0161e",
            "dxDiagram-commandDelete": "Odstranit",
            "dxDiagram-commandBringToFront": "P\u0159en\xe9st do pop\u0159\xe9d\xed",
            "dxDiagram-commandSendToBack": "P\u0159en\xe9st do pozad\xed",
            "dxDiagram-commandLock": "Zamknout",
            "dxDiagram-commandUnlock": "Odemknout",
            "dxDiagram-commandInsertShapeImage": "Vlo\u017eit obr\xe1zek...",
            "dxDiagram-commandEditShapeImage": "Zm\u011bnit obr\xe1zek...",
            "dxDiagram-commandDeleteShapeImage": "Odstranit obr\xe1zek",
            "dxDiagram-commandLayoutLeftToRight": "Zleva-do-prava",
            "dxDiagram-commandLayoutRightToLeft": "Zprava-do-leva",
            "dxDiagram-commandLayoutTopToBottom": "Zhora-dol\u016f",
            "dxDiagram-commandLayoutBottomToTop": "Zdola-nahoru",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "Ok",
            "dxDiagram-dialogButtonCancel": "Zru\u0161it",
            "dxDiagram-dialogInsertShapeImageTitle": "Vlo\u017eit obr\xe1zek",
            "dxDiagram-dialogEditShapeImageTitle": "Zm\u011bnit obr\xe1zek",
            "dxDiagram-dialogEditShapeImageSelectButton": "Vyberte obr\xe1zek",
            "dxDiagram-dialogEditShapeImageLabelText": "nebo p\u0159et\xe1hn\u011bte soubor zde",
            "dxDiagram-uiExport": "Export",
            "dxDiagram-uiProperties": "Vlastnosti",
            "dxDiagram-uiSettings": "Nastaven\xed",
            "dxDiagram-uiShowToolbox": "Zobrazit panel n\xe1stroj\u016f",
            "dxDiagram-uiSearch": "Hledat",
            "dxDiagram-uiStyle": "Styl",
            "dxDiagram-uiLayout": "Rozvr\u017een\xed",
            "dxDiagram-uiLayoutTree": "Strom",
            "dxDiagram-uiLayoutLayered": "Organizace",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Objekt",
            "dxDiagram-uiConnector": "Konektor",
            "dxDiagram-uiPage": "Str\xe1nka",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Obd\xe9ln\xedk",
            "dxDiagram-shapeEllipse": "Elipsa",
            "dxDiagram-shapeCross": "K\u0159\xed\u017e",
            "dxDiagram-shapeTriangle": "Troj\xfaheln\xedk",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "Srdce",
            "dxDiagram-shapePentagon": "P\u011bti\xfaheln\xedk",
            "dxDiagram-shapeHexagon": "\u0160esti\xfaheln\xedk",
            "dxDiagram-shapeOctagon": "Osmi\xfaheln\xedk",
            "dxDiagram-shapeStar": "Hv\u011bzda",
            "dxDiagram-shapeArrowLeft": "\u0160ipka vlevo",
            "dxDiagram-shapeArrowUp": "\u0160ipka nahoru",
            "dxDiagram-shapeArrowRight": "\u0160ipka vpravo",
            "dxDiagram-shapeArrowDown": "\u0160ipka dol\u016f",
            "dxDiagram-shapeArrowUpDown": "\u0160ipka nahoru a dol\u016f",
            "dxDiagram-shapeArrowLeftRight": "\u0160ipka vlevo a vpravo",
            "dxDiagram-shapeProcess": "Proces",
            "dxDiagram-shapeDecision": "Rozhodnut\xed",
            "dxDiagram-shapeTerminator": "Ukon\u010den\xed",
            "dxDiagram-shapePredefinedProcess": "Podprogram",
            "dxDiagram-shapeDocument": "Dokument",
            "dxDiagram-shapeMultipleDocuments": "Dokumenty",
            "dxDiagram-shapeManualInput": "Manu\xe1ln\xed vstup",
            "dxDiagram-shapePreparation": "P\u0159\xedprava",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Datab\xe1ze",
            "dxDiagram-shapeHardDisk": "Pevn\xfd disk",
            "dxDiagram-shapeInternalStorage": "Intern\xed \xfalo\u017ei\u0161t\u011b",
            "dxDiagram-shapePaperTape": "Pap\xedrov\xe1 p\xe1ska",
            "dxDiagram-shapeManualOperation": "Manu\xe1ln\xed operace",
            "dxDiagram-shapeDelay": "Zpo\u017ed\u011bn\xed",
            "dxDiagram-shapeStoredData": "Ulo\u017een\xe1 data",
            "dxDiagram-shapeDisplay": "Zobrazit",
            "dxDiagram-shapeMerge": "Slou\u010dit",
            "dxDiagram-shapeConnector": "Konektor",
            "dxDiagram-shapeOr": "Nebo",
            "dxDiagram-shapeSummingJunction": "A z\xe1rove\u0148",
            "dxDiagram-shapeContainerDefaultText": "Kontejner",
            "dxDiagram-shapeVerticalContainer": "Vertik\xe1ln\xed kontejner",
            "dxDiagram-shapeHorizontalContainer": "Horizont\xe1ln\xed kontejner",
            "dxDiagram-shapeCardDefaultText": "Karta osoby",
            "dxDiagram-shapeCardWithImageOnLeft": "Karta s obr\xe1zkem vlevo",
            "dxDiagram-shapeCardWithImageOnTop": "Karta s obr\xe1zkem naho\u0159e",
            "dxDiagram-shapeCardWithImageOnRight": "Karta s obr\xe1zkem vpravo",
            "dxGantt-dialogTitle": "N\xe1zev",
            "dxGantt-dialogStartTitle": "Za\u010d\xe1tek",
            "dxGantt-dialogEndTitle": "Konec",
            "dxGantt-dialogProgressTitle": "Pr\u016fb\u011bh",
            "dxGantt-dialogResourcesTitle": "Zdroje",
            "dxGantt-dialogResourceManagerTitle": "Spr\xe1vce zdroj\u016f",
            "dxGantt-dialogTaskDetailsTitle": "Detail \xfakolu",
            "dxGantt-dialogEditResourceListHint": "Editovat seznam zdroj\u016f",
            "dxGantt-dialogEditNoResources": "\u017d\xe1dn\xe9 zdroje",
            "dxGantt-dialogButtonAdd": "P\u0159idat",
            "dxGantt-contextMenuNewTask": "Nov\xfd \xfakol",
            "dxGantt-contextMenuNewSubtask": "Nov\xfd pod\xfakol",
            "dxGantt-contextMenuDeleteTask": "Odstranit \xfakol",
            "dxGantt-contextMenuDeleteDependency": "Odstranit z\xe1vislost",
            "dxGantt-dialogTaskDeleteConfirmation": "Odstran\u011bn\xedm \xfakolu dojde tak\xe9 k odstran\u011bn\xed v\u0161ech pod\u0159\xedzen\xfdch \xfakol\u016f. Opravdu si p\u0159ejete \xfakol odstranit?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Opravdu si p\u0159ejete odstranit z\xe1vislost z \xfakolu?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Odstran\u011bn\xedm zdroje dojde tak\xe9 k jeho odstran\u011bn\xed ze v\u0161ech \xfakol\u016f, ke kter\xfdm je zdroj p\u0159id\u011blen Opravdu si p\u0159ejete zdroj odstranit? Po\u010det zdroj\u016f: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "\xdakol, kter\xfd se pokou\u0161\xedte p\u0159esunout je propojen s dal\u0161\xedm \xfakolem pomoc\xed z\xe1vislosti. Tato zm\u011bna m\u016f\u017ee zp\u016fsobit konflikt mezi pravidly z\xe1vislost\xed. Jak si p\u0159ejete pokra\u010dovat?",
            "dxGantt-dialogConstraintViolationMessage": "\xdakol, kter\xfd se pokou\u0161\xedte p\u0159esunout je propojen s dal\u0161\xedm \xfakolem pomoc\xed z\xe1vislosti. Jak si p\u0159ejete pokra\u010dovat?",
            "dxGantt-dialogCancelOperationMessage": "Stornovat operaci",
            "dxGantt-dialogDeleteDependencyMessage": "Odstranit z\xe1vislost",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "P\u0159esunout \xfakol a zachovat z\xe1vislost",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Zp\u011bt",
            "dxGantt-redo": "Znovu",
            "dxGantt-expandAll": "Rozbalit v\u0161e",
            "dxGantt-collapseAll": "Sbalit v\u0161e",
            "dxGantt-addNewTask": "P\u0159idat nov\xfd \xfakol",
            "dxGantt-deleteSelectedTask": "Odstranit vybran\xfd \xfakol",
            "dxGantt-zoomIn": "P\u0159ibl\xed\u017eit",
            "dxGantt-zoomOut": "Odd\xe1lit",
            "dxGantt-fullScreen": "Cel\xe1 obrazovka",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Srovnat vzestupn\u011b",
            "dxGantt-sortingDescendingText": "Srovnat sestupn\u011b",
            "dxGantt-sortingClearText": "Zru\u0161it rovn\xe1n\xed",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}"
        }
    })
}));
