// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Gestore Tooltip
// ************************************************


// *****************************************************
// Classe TooltipManager
// Gestore dei tooltip
// *****************************************************
function TooltipManager()
{
  // Variabili del Tooltip Manager
  //
  this.BaseTooltip = null;    // Tooltip principale
  this.BaseTooltipBis = null; // Tooltip usato in caso di concorrenza
  this.CustomTooltip = null;  // Tooltip custom da sostituire al tooltip standard per gli oggetti che lo richiedono
  //
  this.Style = "info";   // Stile di default dei tooltip
  this.DelayShow = 1000; // Tempo in ms dopo il quale viene mostrato il tooltip
  this.DelayHide = 4000; // Tempo in ms dopo il quale viene nascosto il tooltip
  this.AnimDef = "fade:250"; // Tipo di animazione
  //
  this.OldXPos = -1; // Ultima posizione X del mouse
  this.OldYPos = -1; // Ultima posizione Y del mouse
  //
  this.Enabled = true; // Indica se il TooltipManager e' abilitato
  //
  this.Tooltips = new Array();  // Array dei tooltip spot
}


// ******************************************
// Inizializzazione del gestore
// ******************************************
TooltipManager.prototype.Init = function()
{
  // Creo il tooltip base
  this.BaseTooltip = new MessageTooltip(this);
  this.BaseTooltipBis = new MessageTooltip(this);
  //
  // Aggiungo al document i listener degli eventi
  // di MouseOver, MouseMove, MouseOut, MouseDown, Click e KeyDown
  // utili per mostrare i Tooltips
  /*var mo = new Function("ev","return RD3_TooltipManager.OnMouseOver(ev)");
  var mm = new Function("ev","return RD3_TooltipManager.OnMouseMove(ev)");
  var mt = new Function("ev","return RD3_TooltipManager.OnMouseOut(ev)");
  var md = new Function("ev","return RD3_TooltipManager.OnMouseDown(ev)");
  var mc = new Function("ev","return RD3_TooltipManager.OnClick(ev)");
  var kd = new Function("ev","return RD3_TooltipManager.OnKeyDown(ev)");
  //
  if (document.addEventListener)
  {
    document.addEventListener("mouseover", mo, true);
    document.addEventListener("mousemove", mm, true);
    document.addEventListener("mouseout", mt, true);
    document.addEventListener("mousedown", md, true);
    document.addEventListener("click", mc, true);
    document.body.addEventListener("keydown", kd, true);
  }
  else
  {
    document.attachEvent("onmouseover", mo);
    document.attachEvent("onmousemove", mm);
    document.attachEvent("onmouseout", mt);
    document.attachEvent("onmousedown", md);
    document.attachEvent("onclick", mc);
    document.body.attachEvent("onkeydown", kd);    
  }*/
}


// ************************************************
// Gestione del MouseOver su un oggetto
// ************************************************
TooltipManager.prototype.OnMouseOver = function(ev)
{
  
}

// ******************************************
// Gestione del MouseOver su un oggetto
// ******************************************
TooltipManager.prototype.OnMouseMove = function(ev)
{
  
}

// ************************************************
// Gestione del MouseDown su un oggetto
// ************************************************
TooltipManager.prototype.OnMouseDown = function(ev)
{
  
}

// ************************************************
// Gestione del Click su un oggetto
// ************************************************
TooltipManager.prototype.OnClick = function(ev)
{
  
}

// ************************************************
// Gestione del MouseOut su un oggetto
// ************************************************
TooltipManager.prototype.OnMouseOut = function(ev)
{
  
}

// ************************************************
// Gestione del KeyDown su un oggetto
// ************************************************
TooltipManager.prototype.OnKeyDown = function(ev)
{
  
}

// ************************************************
// Disattiva tutti i tooltip temporizzati
// ************************************************
TooltipManager.prototype.DeactivateAll = function()
{
  
}

// ************************************************
// Attiva o disattiva il TooltipManager
// ************************************************
TooltipManager.prototype.SetEnabled = function(enabled)
{
  this.Enabled = enabled;
}

// ************************************************
// Imposta il title di un'oggetto, se occorre
// ************************************************
TooltipManager.prototype.SetObjTitle = function (obj, title, parent, placement)
{
  // Se siamo disabilitati e non in mobile invece di mostrare i tooltip avanzati
  // uso quelli del browser (In touch i tooltip del browser non ci devono essere..)
  if (!this.Enabled && !RD3_Glb.IsTouch())
  {
    if (title != "") {
      // Se il tooltip e' gia' presente cambio semplicemente il titolo (ricrearlo non funziona)
     if ($(obj).data('bs.tooltip')) {
      $(obj).attr('data-original-title', title);
     }
     else {
       // Se non c'e' lo devo creare
       $(obj).tooltip({
          title : title,
          trigger: "hover",
          delay: { 
            show: this.DelayShow, 
            hide: 0 
          },
         placement: (placement ? placement : "auto bottom"),
          container: (parent ? parent : false)
       });
     }
    }
    else if ($(obj).tooltip)
      $(obj).tooltip('destroy')
  }
}

// ***************************************************************
// Gestisce un tooltip
// ***************************************************************
TooltipManager.prototype.HandleTooltip = function(node)
{
  
}

// ***************************************************************
// Evento notificato dalla deattivazione di un tooltip
// ***************************************************************
TooltipManager.prototype.OnDeactivate = function(tooltip)
{
  
}

// ****************************************************************
// Verifica se un oggetto e' visibile scorrendo la catena dei padri
// ****************************************************************
TooltipManager.prototype.IsObjVisible = function(obj)
{
  // Scorro la catena dei padri (obj compreso)
  while (obj && obj!=document.body)
  {
    // Se e' invisibile ... ho finito
    if (obj.style && (obj.style.display == "none" || obj.style.visibility == "hidden"))
      return false;
    //
    obj = obj.parentNode;
  }
  //
  // Se obj e' nullo allora non e' nel body (quindi invisibile)
  return (obj != null);
}

// ***************************************************************
// Disattiva tutti i tooltip attivati su oggetti di una form
// ***************************************************************
TooltipManager.prototype.ResetTooltip = function(node)
{
  
}

// ****************************************************************
// Verifica se un oggetto ha un padre con un certo ID
// ****************************************************************
TooltipManager.prototype.IsObjParent = function(obj, parentID)
{
  // Scorro la catena dei padri (obj compreso)
  obj = obj.parentNode;
  while (obj && obj!=document.body)
  {
    if (obj.getAttribute('id') == parentID)
      return true;
    //
    obj = obj.parentNode;
  }
  //
  return false;
}