function IDdxWorkflow(pform)
{
  CustomElement.call(this, pform);
}

IDdxWorkflow.prototype = new CustomElement();

IDdxWorkflow.Init = function() {
  if(IDdxWorkflow.inited){
    return
  }


  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/js/dx-diagram.js", "JS");
  CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/css/dx-diagram.min.css", "CSS");
  IDdxWorkflow.inited = true;
}

IDdxWorkflow.Init();

Object.defineProperty(IDdxWorkflow.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.workflow) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.workflow.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});


IDdxWorkflow.prototype.Realize = function (parent, cls) {
  //
  if(!IDdxWorkflow.inited) {
    IDdxWorkflow.Realize = parent;
    return;
  }
  //
  CustomElement.prototype.Realize.call(this, parent, cls);
  var pthis = this;
  
  this.workflowDiv = document.createElement("div");
  this.workflowDiv.setAttribute("id","myWorkflow");
  parent.appendChild(this.workflowDiv);

  if (this.workflow) {
    this.workflow.destroy();
  }
  
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale(navigator.language);
    $('#myWorkflow').dxDiagram({
      export: {fileName: "workflow"},
      contextMenu: {
        enabled: true,
        commands: ['bringToFront', 'sendToBack', 'lock', 'unlock'],
      },
      customShapes: 
      [{
        type: 'customTask',
        backgroundImageUrl: 'images/todo.png',
        backgroundImageWidth: 1,
        backgroundImageHeight:1,
        defaultWidth: 0.5,
        defaultHeight: 0.5,
        textTop: 0.7,
        textHeight: 0.3,
        category: 'ToDo',
        allowEditText: true,
        allowResize: true,
        allowEditImage: true,
        keepRatioOnAutoSize: true,
        maxWidth: 720,
        maxHeight: 720,
        },],
      contextToolbox: {
        enabled: true,
        category: 'node',
        shapeIconsPerRow: 5,
        width: 200,
      },
      historyToolbar: {
        visible: true,
      },
      viewToolbar: {
        visible: true,
        /* customization of commands in the ViewToolbar
        commands: ["zoomLevel", 
                    {name: "export", 
                    icon: "export", 
                    items: ["exportSvg","exportPng","exportJpg"],
                    }
                  ]*/
      },
      mainToolbar: {
        visible: true,
        commands: [
          { name: 'undo' },
          { name: 'redo' },
          { name: 'separator' },
          { name: 'fontName' },
          { name: 'fontSize' },
          { name: 'separator' },
          { name: 'bold' },
          { name: 'italic' },
          { name: 'underline' },
          { name: 'separator' },
          { name: 'fontColor' },
          { name: 'lineColor' },
          { name: 'fillColor' },
          { name: 'separator' },
        ],
      },
      toolbox: {
        visibility: 'visible',
        groups: ['general', {category: 'ToDo', title: "Undeletable Shapes"}],
        showSearch: true,
        shapeIconsPerRow: 5,
        width: 220,
      },

      onRequestEditOperation: function(event) {
        if(event.operation === "deleteShape")
        {
          if(event.args.shape.type == 'customTask'){
            event.allowed = false;
            showToast("Non puoi eliminare questo tipo di nodo.");
          }
        }
      },
      onItemClick: function(data) {
        // handle the click on a wkf node
        pthis.SendEvent("onItemClick", [data.item]);
      },
    });
                    
    this.workflow = $('#myWorkflow').dxDiagram("instance");
  }.bind(this), 350);

  this.workflow = $('#myWorkflow').dxDiagram("dispose");
}

// custom procedure to udpate the dxDiagram Configuration
// from inde: USE an IDMAP that will be decoded in "data"
IDdxWorkflow.prototype.updateConfiguration = function(data) {
  this.workflow = $('#myWorkflow').dxDiagram(data);
}



// this procedure changes the Options in the configuration IDdxWorkflow 
IDdxWorkflow.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      if(oName && oValue){
        this.workflow.option(oName, oValue);
      }
    }
  }
}

// this procedure changes language of this scheduler
IDdxWorkflow.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

// this procedure delete an Appointment from the dxDiagram
IDdxWorkflow.prototype.checkdatasource = function() {
 console.log(this.workflow._dataSource._items);
}

IDdxWorkflow.prototype.Unrealize = function ()
{
  if (this.workflow)
    this.workflow.dispose();
  delete this.workflow;
  //
  if (this.workflowDiv.parentNode)
    this.workflowDiv.parentNode.removeChild(this.workflowDiv);
  delete this.workflowDiv;
}

IDdxWorkflow.prototype.exportJson = function (){
  var jsonString = this.workflow.export();
  this.SendEvent("export", [jsonString]);
}

IDdxWorkflow.prototype.importJson = function (json){
  var jsonToImport = json;
  this.workflow.import(jsonToImport, false);
}

IDdxWorkflow.prototype.printwkf = function (){
  var imageString = "";
  const ff = function() {
    this.SendEvent("print", [imageString]);
  };
    this.workflow.exportTo('svg', ff);
  
}


/*
  Buttons js
*/
function test(buttonID,eventID){
  console.log("test has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}