function IDdxPivot(pform){
  CustomElement.call(this, pform);
}

IDdxPivot.prototype = new CustomElement();
IDdxPivot.Init = function() {
  if(IDdxPivot.inited){
    return
  }
  //CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/js/dx.web.js", "JS")

  
  //CustomElement.LoadRequirements("JSComponents/DevExtreme/Lib/js/dx.viz.js", "JS")
  IDdxPivot.inited = true;
}


IDdxPivot.Init();
Object.defineProperty(IDdxPivot.prototype, "options", {
  get: function () {
    return this.options;
  },
  set: function (value) {
    if (this.pivot) {
      var opt = (typeof value === String ? JSON.parse(value) : value);
      var keys = Object.keys(opt);
        for (var i = 0; i < keys.length; i++)
          this.pivot.setOption(prop, opt[prop]);
    }
    else
      this._options = value;
  }
});

Object.defineProperty(IDdxPivot.prototype, "data", {
  get: function () {
    return this._data;
  },
  set: function (configuration) {
    this._data = configuration.data;
    this._chartScript = configuration.chartScript;
    this._customDivPivot = configuration.divToUse + 'Pivot';
    this._customDivChart = configuration.divToUse + 'Chart';
    this._onlyPivot = configuration.onlyPivot;
    this._onlyChart = configuration.onlyChart;
    if (configuration.allowFiltering == -1){
      this._allowFiltering = true;
    } else{
      this._allowFiltering = false;
    }
    
    if(this.pivot){
      this.Realize(IDdxPivot.Realize, IDdxPivot.cls);}
    else {
      if(IDdxPivot.Realize){
        this.Realize(IDdxPivot.Realize, IDdxPivot.cls);
      }
    }
  }
});



IDdxPivot.prototype.Realize = function (parent, cls) {

  if(!this._data){
    IDdxPivot.Realize = parent;
    IDdxPivot.cls = cls;
    return;
  }

  if(!IDdxPivot.inited || this._data.length == 0) {
    IDdxPivot.Realize = parent;
    IDdxPivot.cls = cls;
    return;
  }
  CustomElement.prototype.Realize.call(this, parent, cls);

  var pthis = this;
  
  this.pivotDiv = document.createElement("div");
  this.pivotDiv.setAttribute("id",this._customDivPivot);

  if(this._onlyPivot == false){
    this.chartDiv = document.createElement("div");
    this.chartDiv.setAttribute("id", this._customDivChart);
    parent.appendChild(this.chartDiv);
  }
  parent.appendChild(this.pivotDiv);
 

  this.storedParent = parent;

  // avoid 2 or more equal instances of the pivot
  if (this.pivot) {
    this.pivot.destroy();
  }
  if (this.chart) {
    this.chart.destroy();
  }
  var pivotdiv = '#' + this._customDivPivot;
  var chartDiv = '#' + this._customDivChart;
  DevExpress.localization.locale('it');
  window.setTimeout( function () {
    var pthis = this;
    DevExpress.localization.locale(navigator.language);
    

    $(pivotdiv).dxPivotGrid({
      allowSortingBySummary: true,
      allowFiltering: true,
      showBorders: true,
      showColumnGrandTotals: false,
      showRowGrandTotals: false,
      showRowTotals: false,
      showColumnTotals: false,
      fieldChooser: {
        enabled: this._allowFiltering,
        height: 400,
      },
      dataSource: this._data,
    });

    if (this._onlyPivot == false) {
      eval(this._chartScript);  
    }

    this.pivot = $(pivotdiv).dxPivotGrid("instance");

  }.bind(this), 350);

  this.pivot = $(pivotdiv).dxPivotGrid("dispose");
 
}

IDdxPivot.prototype.setLocale   = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

IDdxPivot.prototype.Unrealize = function ()
{
  if (this.pivot)
    this.pivot.dispose();
  delete this.pivot;
  if(this.pivotDiv){
    if (this.pivotDiv.parentNode)
      this.pivotDiv.parentNode.removeChild(this.pivotDiv);
    delete this.pivotDiv;
  }
}

IDdxPivot.prototype.changeChartType = function (script){
  delete this.chart;
   if (this.chartDiv.parentNode){
    this.chartDiv.parentNode.removeChild(this.chartDiv);
  }      
  var chartDiv = '#' + this._customDivChart;
  var pivotdiv = '#' + this._customDivPivot;
  this.chartDiv = document.createElement("div");
  this.chartDiv.setAttribute("id", this._customDivChart);
  this.storedParent.insertBefore(this.chartDiv, this.pivotDiv);
  this._chartScript = script;
  eval(this._chartScript);
}

/*
  custom button
*/
function customButtonCommand(buttonID,eventID){
  console.log("CLICCAMI has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}