// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe Tab: Rappresenta una tab di una TabbedView
// ************************************************

function Tab(pview)
{
  // Proprieta' di questo oggetto di modello
  this.Image = "";          // Immagine della entry nella lista delle tab
  this.Header = "";         // Caption della entry nella lista delle tab
  this.Tooltip = "";        // Tooltip della entry nella lista delle tab
  this.Style = 0;           // Stile della tab
  this.Badge = "";          // Badge della Tab
  this.TabView = pview;     // Tabview padre
  this.Content = null;      // WebFrame contenuto in questa Tab: inizialmente viene inviato dal server un identificatore,
                            // poi nella realize viene caricato l'oggetto corretto
  //
  // Variabili di questo oggetto
  this.Selected = false;        // Se la tab e' selezionata o meno
  this.Visible = true;          // Se la tab e' visibile o meno (la visibilita' di una tab e' definita dalla visibilita' del suo contenuto)
  this.RecalcLayout = false;    // Se e' necessario rieseguire l'adapt del layout
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;    // Se vero, gli oggetti del DOM sono gia' stati creati  
  //
  // Oggetti DOM di questa Tab
  this.CaptionBox = null;         // Contenitore della caption della pagina
  this.LeftSpan = null;           // Span contenitore dell'immagine sinistra
  this.LeftImage = null;          // Immagine sinistra della caption
  this.HeaderCont = null;         // Span contenitore del nome della Tab e dell'immagine
  this.TabImg = null;             // Immagine della caption
  this.HeaderTxt = null;          // Testo della caption
  this.RightImage = null;         // Immagine destra della Caption
  this.BadgeObj = null;
  this.RefreshExposed = false;    // Devo inviare il messaggio di esposizione al contenuto?
  //
  this.ContentBox = null;         // Div in cui verra' renderizzato il contenuto  
  //
  // Altre Variabili necessarie per gestire questo oggetto
  this.AlreadySelected = false;   // False se questa Tab non e' mai stata selezionata
  //
	//this.TempImg = null;          // Elemento Img attualmente mostrat0 nella Tab (IE10+)
	//this.ImgSrc = null;           // Immagine attualmente mostrata nella Tab (IE10+)
}


// *******************************************************************
// Inizializza questo oggetto leggendo i dati da un nodo XML
// *******************************************************************
Tab.prototype.LoadFromXml = function(node) 
{
  this.LoadProperties(node);
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
Tab.prototype.ChangeProperties = function(node)
{
  // Proseguo con il cambio di proprieta'
  this.LoadProperties(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
Tab.prototype.LoadProperties = function(node)
{
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "img": this.SetImage(attrnode.nodeValue); break;
      case "cap": this.SetHeader(attrnode.nodeValue); break;
      case "tip": this.SetTooltip(attrnode.nodeValue); break;
      case "sty": this.SetStyle(parseInt(attrnode.nodeValue)); break;
      case "con": this.SetContent(attrnode.nodeValue); break;
      case "dcl": this.DeletePage(attrnode.nodeValue); break;
      case "bdg": this.SetBadge(attrnode.nodeValue); break;
      
      case "id": 
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
      break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
Tab.prototype.SetImage = function (value) {
  if (value != undefined)
    this.Image = value;
  //
  if (this.Realized) {
    if (this.Image != "") {
      // Mostro l'immagine corretta
      this.TabImg.src = RD3_Glb.GetImgSrc("images/" + this.Image);
      this.TabImg.style.display = "";
    }
    else
      this.TabImg.style.display = "none";
  }
}

Tab.prototype.SetHeader= function(value) 
{
  if (value!=undefined)
    this.Header = value;
  //
  if (this.Realized) {
  	if (this.HeaderTxt) {
      if (RD3_Glb.IsIconString(this.Header))
        this.HeaderTxt.innerHTML = RD3_Glb.HandleIconString(this.Header);
      else
    	  this.HeaderTxt.textContent = this.Header;
    }
  }
}

Tab.prototype.SetTooltip= function(value) 
{
  if (value!=undefined)
    this.Tooltip = value;
  //
  if (this.Realized)
    RD3_TooltipManager.SetObjTitle(this.CaptionBox, this.Tooltip);
}

Tab.prototype.SetBadge= function(value) 
{
  if (value!=undefined)
    this.Badge = value;
  //
  if (this.Realized)
  {
    if (this.Badge == "")
    {
      if (this.BadgeObj != null && this.BadgeObj.parentNode)
        this.BadgeObj.parentNode.removeChild(this.BadgeObj);
      //
      this.BadgeObj = null;
    }
    else
    {
      if (this.BadgeObj == null)
      {
        this.BadgeObj = document.createElement("span");
        this.BadgeObj.className = "badge";
        this.BadgeObj.style.marginLeft = "4px";
        this.HeaderCont.appendChild(this.BadgeObj);
      }
      //
      this.BadgeObj.innerHTML = this.Badge;
    }
  }
}

Tab.prototype.SetStyle= function(value) 
{
  if (value!=undefined)
    this.Style = value;
}

Tab.prototype.SetContent= function(value) 
{
  // Questa proprieta' non puo' cambiare a Run time
  this.Content = value;
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// contbox : oggetto in cui realizzare il contenuto della tab
// captcont : oggetto in cui realizzare la caption della tab
// ***************************************************************
Tab.prototype.Realize = function(contbox, captcont, blockMessage)
{
  // Per prima cosa carico il contenuto corretto
  if (!this.Content.Identifier)
    this.Content = RD3_DesktopManager.ObjectMap[this.Content];
  //
  // Informo il contenuto che io sono suo padre
  this.Content.ParentTab = this;
  this.Content.ParentFrame = this.TabView;
  //
  // Creo gli oggetti Dom relativi alla caption
  this.CaptionBox = document.createElement("li");
  this.CaptionBox.id = this.Identifier+":cap";
  //
  this.HeaderCont = document.createElement("a");
  this.HeaderCont.setAttribute("data-toggle", "tab");
  this.HeaderCont.setAttribute("href", RD3_Glb.escapeID("#"+this.Identifier));
  this.CaptionBox.appendChild(this.HeaderCont);
  //
  this.TabImg = document.createElement("img");
  this.HeaderCont.appendChild(this.TabImg);
  this.HeaderTxt = document.createElement("span");
  this.HeaderCont.appendChild(this.HeaderTxt);
  //
  // Creo il contenitore del contenuto
  this.ContentBox = document.createElement("div");
  this.ContentBox.className = "tab-pane";
  this.ContentBox.id = this.Identifier;
  //
  // Se il ridimansionamento è adatta la Tab non deve spingere ma essere contenuta all'interno dello spazio del padre
  if (this.TabView.WebForm.ResModeH !== RD3_Glb.FRESMODE_NONE)
    this.ContentBox.style.height = "100%";
  //
  // Assegno gli eventi agli oggetti della caption
  var _this = this;
  $(this.HeaderCont).on("show.bs.tab", function (ev) {
    _this.OnClick(ev);
  });
  //
  captcont.appendChild(this.CaptionBox);
  contbox.appendChild(this.ContentBox);
  //
  // Inizializzo questo oggetto
  this.Realized = true;
  this.SetImage();
  this.SetHeader();
  this.SetTooltip();
  this.SetStyle();
  this.SetBadge();
  //
  // Se ho un contenuto valido e questo non e' stato realizzato imposto da qua la mia visibilita'
  if (this.Content && !this.Content.Realized && !blockMessage)
    this.SetVisible(this.Content.Visible);
}


// *****************************************************************
// Rimuove gli oggetti dom e i riferimenti di questo oggetto perche'
// sta per essere distrutto
// *****************************************************************
Tab.prototype.Unrealize = function(blockMessage)
{
  // Passo il messaggio al mio contenuto
  if (!blockMessage)
  {
    if (this.Content.Unrealize)
      this.Content.Unrealize();
    else if (RD3_DesktopManager.ObjectMap[this.Content])
      RD3_DesktopManager.ObjectMap[this.Content].Unrealize();
  }
  //
  // Rimuovo i riferimenti dal DOM
  if (this.CaptionBox)
  {
    this.CaptionBox.parentNode.removeChild(this.CaptionBox);
    this.ContentBox.parentNode.removeChild(this.ContentBox);
  }
  //
  // Mi rimuovo dalla mappa degli oggetti
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  // Annullo i riferimenti
  this.CaptionBox = null;
  this.LeftSpan = null;  
  this.LeftImage = null; 
  this.HeaderCont = null;
  this.TabImg = null;    
  this.HeaderTxt = null; 
  this.RightImage = null;
  this.ContentBox = null; 
  this.BadgeObj = null;
  //
  this.Realized = false;
}


// ***************************************************************
// Gestisce il dimensionamento di questo oggetto
// ***************************************************************
Tab.prototype.AdaptLayout = function()
{
  
}


// ***************************************************************
// Metodo che rende questa pagina selezionata o meno
// ***************************************************************
Tab.prototype.SelectPage = function(sel)
{
  var old = this.Selected; 
  this.Selected = sel;
  //
  if (this.Selected && old !== this.Selected)
  {
    // Mi memorizzo che questa Tab e' stata gia' selezionata una volta: da adesso in poi 
    // si puo' fare la gestione del click lato client
    this.AlreadySelected = true;
    $(this.HeaderCont).tab("show");
    RD3_Glb.AddClass(this.ContentBox, "active");
    //
    if (this.Content && !this.Content.Realized) {
      this.Content.Realize(this.ContentBox);
      this.Content.CalcGridLayout();
      RD3_DesktopManager.WebEntryPoint.RefreshCommands = true;  // Chiediamo l'aggiornamento dei comandi in modo che le tooolbar siano disegnate anche per i nuovi pannelli
    }
    //
    if (this.Content) {
      if (this.Content.SetAlignHeader)
        this.Content.SetAlignHeader();
      else
        this.Content.AlignHeader = true;
    }
    //
    // Se ho saltato un resize perche' ero invisibile adesso lo devo fare
    if (this.SkippedViewportResize && this.Content && this.Content.Realized) {
      this.Content.OnViewportResize();
      delete this.SkippedViewportResize;
    }
  }
  else
  {
    // Nascondo il contenuto
    // Non devo fare nulla, ci pensa bootstrap quando viene selezionata un altra TAB
  }
}

// ***************************************************************
// Metodo che rende la entry di questa tab visibile o meno: 
// non dipende direttamente da questo oggetto ma viene chiamata dalla
// set visible del suo contenuto
// ***************************************************************
Tab.prototype.SetVisible = function(value)
{
  this.Visible = value;
  //
  if (this.Realized)
  {
    if (this.Visible)
    {
      // Rendo visibile la caption
      this.CaptionBox.style.display = "";
      //
      // Rendo visibile il suo contenuto (ci pensa bootstrap a non mostrarlo se non e' selezionata)
      this.ContentBox.style.display = "";
    }
    else
    {
      // Nascondo la caption
      this.CaptionBox.style.display = "none";
      //
      // Nascondo il contenuto
      this.ContentBox.style.display = "none";
    }
    //
    this.TabView.RecalcLayout = true;
  }
}

// ********************************************************************************
// Gestore evento di mouse over su una Tab
// ********************************************************************************
Tab.prototype.OnMouseOverObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di mouse out su una Tab
// ********************************************************************************
Tab.prototype.OnMouseOutObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di mouse down su una Tab
// ********************************************************************************
Tab.prototype.OnMouseDownObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di click su una Tab
// ********************************************************************************
Tab.prototype.OnClick= function(evento)
{
  var ev = new IDEvent("tab", this.Identifier, evento, this.TabView.ClickEventDef, this.TabView.Identifier);
  //
  // Mi seleziono lato client
  this.TabView.SetSelectedPage(this.TabView.FindTabIndex(this));
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
Tab.prototype.AfterProcessResponse= function()
{ 
  if (this.RecalcLayout)
    this.AdaptLayout();
  //
  // Certifico che ho effettuato il recalc
  this.RecalcLayout = false;
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
Tab.prototype.GetTooltip = function(tip, obj)
{
  if (this.Tooltip == "")
    return false;
  //
  tip.SetObj(this.CaptionBox);
  obj = this.CaptionBox;
  //
  tip.SetTitle(this.Header);
  tip.SetText(this.Tooltip);
  tip.SetAnchor(RD3_Glb.GetScreenLeft(obj) + (obj.offsetWidth/2), RD3_Glb.GetScreenTop(obj));
  tip.SetPosition(0);
  //
  return true;
}

// *********************************************************
// Elimina una pagina
// *********************************************************
Tab.prototype.DeletePage = function(value, blockMessage)
{
  // Mi cerco nell'array di mio padre
  var n = this.TabView.Tabs.length;
  for (var i=0; i<n; i++)
  {
    if (this.TabView.Tabs[i] == this)
    {
      // Prima elimino il mio Content
      if (this.Content && this.Content.DeleteFrame && !blockMessage)
        this.Content.DeleteFrame();
      //
      // Poi proseguo con me stesso
      this.TabView.Tabs.splice(i, 1);
      //
      this.Unrealize(blockMessage);
      this.TabView.SetPlacement();
      //
      break;
    }
  }
}

// **********************************************************************
// Deve tornare vero se l'oggetto e' draggabile
// **********************************************************************
Tab.prototype.IsDraggable = function(id)
{
  // La draggabilita' di una pagina dipende dalla tabbedview
  return this.TabView.CanDrag;
}

// **********************************************************************
// Restituisce l'oggetto Dom a cui associare un Popup Menu
// **********************************************************************
Tab.prototype.GetDOMObj = function()
{
  return this.CaptionBox;
}

// *****************************************************************************
// Restituisce l'oggetto visuale su cui deve venire applicata l'HL per il drag
// *****************************************************************************
Tab.prototype.DropElement = function()
{
  return this.CaptionBox;
}

// ********************************************************************************
// Compone la lista di drop della box
// ********************************************************************************
Tab.prototype.ComputeDropList = function(list, dragobj)
{
  if (!this.Realized)
    return;
  //
  // Questa pagina vuole essere droppata da dragobj?
  // Si da per scontato che la TabbedView abbia DragDrop attivo (lo controlla lei)
  if (this!=dragobj)
  {
    list.push(this);
    //
    // Calcolo le coordinate assolute...
    this.AbsLeft = RD3_Glb.GetScreenLeft(this.CaptionBox,true);
    this.AbsTop = RD3_Glb.GetScreenTop(this.CaptionBox,true);
    if (!RD3_Glb.IsIE())
    {
      // Sugli altri browser devo tenere conto della scrollbar...
      this.AbsLeft -= this.TabView.ContentBox.scrollLeft;
      this.AbsTop -= this.TabView.ContentBox.scrollTop;
    }
    //
    this.AbsRight = this.AbsLeft + this.CaptionBox.offsetWidth - 1;
    this.AbsBottom = this.AbsTop + this.CaptionBox.offsetHeight - 1;
  }
}

// *********************************************************
// Aggiorna lo stato di esposizione del contenuto
// *********************************************************
Tab.prototype.RefreshExposition = function()
{
  
}


Tab.prototype.CalcGridLayout = function()
{
  if (this.Content && this.Content.Realized)
      this.Content.CalcGridLayout();
};


Tab.prototype.OnViewportResize = function()
{
  if (this.Selected && this.Content && this.Content.Realized)
    this.Content.OnViewportResize();
  else
    this.SkippedViewportResize = true;
};