// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe WebForm: rappresenta una form aperta
// ************************************************
function WebForm() 
{
  // Proprieta' di questo oggetto di modello
  this.Identifier = "";                         // Codice della form (es: "frm:3")
  this.IdxForm = 0;                             // L'indice della form
  //
  this.Caption = "";                            // La caption
  this.WebCaption = "";                         // La caption (in formato HTML...)
  this.Image = "";                              // L'icona da mostrare
  this.Modal = 0;                               // 0=MDI, 1,-1: MODAL, 2: POPUP non modale
  this.Docked = false;                          // Se vero la form e' docked
  this.DockType = 0;                            // Indica il lato di aggancio della form
  this.Visible = true;                          // Visibilita' della form
  this.ToolbarPosition = RD3_Glb.FORMTOOL_LEFT; // Indica come e dove mostrare i bottoni della form
  this.BorderType = RD3_Glb.BORDER_THICK;       // Indica il tipo di bordo
  this.WindowState = RD3_Glb.WS_NORMAL;         // Stato della finestra
  this.VisualFlags = -1;                        // Flag visuali
  this.FormLeft = -1;                           // In caso di form modale, indicano dove deve apparire
  this.FormTop = -1;                            // In caso di form modale, indicano dove deve apparire
  this.FormWidth = -1;                          // In caso di form modale, indicano dove deve apparire
  this.FormHeight = -1;                         // In caso di form modale, indicano dove deve apparire
  this.NormalLeft = null;                       // Posizione e dimensione videata quando era in stato normale (e ora e' massimizzata o minimizzata)
  this.NormalTop = null;                        // Posizione e dimensione videata quando era in stato normale (e ora e' massimizzata o minimizzata)
  this.NormalWidth = null;                      // Posizione e dimensione videata quando era in stato normale (e ora e' massimizzata o minimizzata)
  this.NormalHeight = null;                     // Posizione e dimensione videata quando era in stato normale (e ora e' massimizzata o minimizzata)  
  this.NormalWindowState = null;
  this.ResModeW = RD3_Glb.FRESMODE_NONE;        // Modalita' di ridimensionamento della form
  this.ResModeH = RD3_Glb.FRESMODE_NONE;        // Modalita' di ridimensionamento della form
  this.PreviewFrame = null;                     // Il frame da mostrare in preview
  this.HandledKeys = 0;                         // Tasti da intercettare a livello di form
  this.BackButtonTxt = null;                    // Testo da mostrare nel back-button (qualora presente)
  this.CloseOnSelection = false;                // Devo chiudere la form quando si esegue una selezione?
  //this.ClassName = null;                      // Classe specifica da applicare alla Form
  //
  // Oggetti secondari gestiti da questo oggetto di modello
  this.Frames = new Array();                    // I frame che contengono gli oggetti visuali
  this.Messages = new Array();                  // Elenco dei messaggi della form
  //
  // Struttura per la definizione delle caratteristiche degli eventi di questo comando o command set
  //
  // Variabili secondarie di questo'oggetto
  this.AlreadyVisible = false;              // Questa form e' a video? 
  this.Animating = false;                   // C'e' un'animazione su questa form?
  this.OpenX = 0;                           // Posizione X di apertura della form modale (per zoom)
  this.OpenY=0;                             // Posizione Y di apertura della form modale (per zoom)
  this.PopupResAnim = false;                // Devo far partire l'animazione di resize della Popup?
  this.PopupResAnimating = false;           // Sto eseguendo l'animazione riguardante il popup?
  this.PopupRect = new Rect(-1,-1,-1,-1);   // Vecchia posizione della modale prima di fare il resize
  //
  // Click sui bottoni della toolbar della form deve andare prima al server
  // Ad esempio, l'evento di chiusura deve essere confermato dal server prima che il client
  // effettivamente possa chiudere la form. NOTA: non e' ammesso per la chiusura la
  // gestione locale  
  this.ClickEventDef = RD3_Glb.EVENT_ACTIVE;
  //
  // Click sulla form list per attivare la form
  this.ClickFLEventDef = RD3_Glb.EVENT_ACTIVE;
  //
  // Evento di resize/move
  this.ResizeEventDef = RD3_Glb.EVENT_ACTIVE;
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;        // Se vero, gli oggetti del DOM sono gia' stati creati
  this.RecalcLayout = false;    // Se vero, al termine della richiesta verra' adattato il layout
  this.AdaptToolbar = false;    // Se vero, al termine della richiesta verra' riadattata la toolbar
  this.NoOpacity = true;        // Le finestre di form modali non vogliono la trasparenza durante il D&D
  this.RecalcCommands = false;  // Se vero alla fine della richiesta verra' riverificata la visibilita' dei comandi
  this.AfterPopupResizeHide = false;  // Se vero alla fine di una animazione di resize popup viene nascosta la form
  //
  // Oggetti visuali riguardanti la form
  this.FormBox = null;           // Div globale della form: contiene tutta la form ed i suoi figli
  this.CaptionBox = null;        // Div che contiene la caption
  //
  this.ImgIcon = null;           // img che contiene l'icona da mostrare vicino alla caption
  this.CloseBtn = null;          // img che contiene l'immagine di chiusura della form
  this.ConfirmBtn = null;        // img che contiene l'immagine di conferma della form (per modali)
  this.MinBtn = null;            // Bottone di minizzazione
  this.MaxBtn = null;            // Bottone di massimizzazione
  this.HelpBtn = null;           // Bottone di help
  this.DebugBtn = null;          // Bottone di debug
  //
  this.CaptionTxt = null;        // span che contiene la caption della form (puo' contenere altro html..)
  this.FramesBox = null;         // Div che contiene i frames
  this.MessagesBox = null;       // Div che contiene tutti i messaggi
  //
  this.PopupFrame = null;        // PopupFrame in cui la form viene visualizzata se modale
  //
  // Oggetti visuali per gestire il titolo della form nella lista delle form attive
  this.FLBox = null;             // Contenitore della entry della form nella lista delle form aperte
  this.FLImg = null;             // Immagine nella form list
  //this.SubFormObj = null;      // Puntatore al SubForm object se sono una sub-form
}



// *******************************************************************
// Inizializza questo WebForm leggendo i dati da un nodo <frm> XML
// *******************************************************************
WebForm.prototype.LoadFromXml = function(node) 
{
  // Inizializzo le proprieta' locali
  this.LoadProperties(node);
  //
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i=0; i<n; i++) 
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    //
    // In base al tipo di oggetto, invio il messaggio di caricamento
    switch (nome)
    {
      case "msg":
      {
        var msg = new Message(this);
        msg.LoadFromXml(objnode);
        //
        // Verifchiamo se e' gia' presente
        var f = false;
        var nm = this.Messages.length;
        for (var im=0; im<nm; im++)
        {
          if (this.Messages[im].EqualsTo(msg))
          {
            f=true;
            this.Messages[im].Request = RD3_DesktopManager.CurrentRequest;
          }
        }
        if (!f)
          this.Messages.push(msg);
      }
      break;

      case "wfr":
      {
        var frame = new WebFrame(this);
        this.Frames.push(frame);
        frame.LoadFromXml(objnode);
      }
      break;

      case "bbr":
      {
        var frame = new ButtonBar(this);
        frame.LoadFromXml(objnode);
        this.Frames.push(frame);
      }
      break;

      case "tre":
      {
        var frame = new Tree(this);
        frame.LoadFromXml(objnode);
        this.Frames.push(frame);
      }
      break;

      case "book":
      {
        var frame = new Book(this);
        frame.LoadFromXml(objnode);
        this.Frames.push(frame);
      }
      break;

      case "pan":
      {
        var frame = new IDPanel(this);
        this.Frames.push(frame);
        frame.LoadFromXml(objnode);
      }
      break;
      
      case "suf":
      {
        var frame = new SubForm(this);
        this.Frames.push(frame);
        frame.LoadFromXml(objnode);
      }
      break;
      
      case "gra":
      {
        var frame = new Graph(this);
        frame.LoadFromXml(objnode);
        this.Frames.push(frame);
      }
      break;
      
      case "tbv":
      {
        var frame = new TabbedView(this);
        frame.LoadFromXml(objnode);
        this.Frames.push(frame);
      }
      break;
      
      case "tmh": // Timer di form multipla
      {
        RD3_DesktopManager.WebEntryPoint.TimerObj.LoadFromXml(objnode, true);
      }
      break;
      
      case "cmh": // Command set di form multipla
      {
        RD3_DesktopManager.WebEntryPoint.CmdObj.LoadFromXml(objnode, true);
      }
      break;

    }
  }    
  //
  // Riconnetto i figli di tutti i frames
  if (!this.Realized)
  {
    var n = this.Frames.length;
    for (var i=0; i<n; i++) 
    {
      var fr = this.Frames[i];
      if (fr.ChildFrame1)
      {
        fr.ChildFrame1 = RD3_DesktopManager.ObjectMap[fr.ChildFrame1];
      }
      if (fr.ChildFrame2)
      {
        fr.ChildFrame2 = RD3_DesktopManager.ObjectMap[fr.ChildFrame2];
      }
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
WebForm.prototype.ChangeProperties = function(node)
{
  // Semplicemente setto le proprieta' a partire dal nodo + verifico oggetti figli, come i messaggi
  this.LoadFromXml(node);
  //
  // Ci sono messaggi da realizzare?
  this.RealizeMessages();
  //
  // Verifica preview frame
   this.PopupPreview();
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
WebForm.prototype.LoadProperties = function(node)
{
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "idx": this.SetFormIndex(parseInt(valore)); break;
      case "cap": this.SetCaption(valore); break;
      case "wcp": this.SetWebCaption(valore); break;
      case "img": this.SetImage(valore); break;
      case "mod": this.SetModal(parseInt(valore)); break;
      case "doc": this.SetDocked(valore=="1"); break;
      case "dot": this.SetDockType(parseInt(valore)); break;
      case "vis": this.SetVisible(valore=="1", true); break;
      case "tbp": this.SetToolbarPosition(parseInt(valore)); break;
      case "bdt": this.SetBorderType(parseInt(valore)); break;
      case "vfl": this.SetVisualFlags(parseInt(valore)); break;
      case "wst": this.SetWindowState(parseInt(valore)); break;
      case "lef": this.SetFormLeft(parseInt(valore)); break;
      case "top": this.SetFormTop(parseInt(valore)); break;
      case "wid": this.SetFormWidth(parseInt(valore)); break;
      case "hei": this.SetFormHeight(parseInt(valore)); break;
      case "rew": this.SetResModeW(parseInt(valore)); break;
      case "reh": this.SetResModeH(parseInt(valore)); break;
      case "pre": this.SetPreview(valore); break;
      case "hks": this.SetHandledKeys(parseInt(valore)); break;
      case "bbt": this.SetBackButtonText(valore); break;
      case "cln": this.SetClassName(valore); break;

      case "clk": this.ClickEventDef = parseInt(valore); break;
      case "flc": this.ClickFLEventDef = parseInt(valore); break;
      case "res": this.ResizeEventDef = parseInt(valore); break;
      case "cls": this.CloseOnSelection = (valore=="1"); break;
      
      case "sha": this.ShowAnimDef = valore; break;
      case "mda": this.ModalAnimDef = valore; break;
      case "mga": this.MessageAnimDef = valore; break;
      case "lma": this.LastMessageAnimDef = valore; break;
      case "pra": this.PreviewAnimDef = valore; break;
      case "dka": this.DockedAnimDef = valore; break;
      case "ppr": this.PopResAnimDef = valore; break;
      case "own": this.Owner = valore; break;

      case "id": 
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
      break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
WebForm.prototype.SetFormIndex= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.IdxForm = value;
}

WebForm.prototype.SetModal= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.Modal = value;
}

WebForm.prototype.SetDocked= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.Docked = value;
}

WebForm.prototype.SetDockType= function(value) 
{
  var old = this.DockType;
  //
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.DockType = value;
}

WebForm.prototype.SetToolbarPosition= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.ToolbarPosition = value;
}

WebForm.prototype.SetBorderType= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.BorderType = value;
}

WebForm.prototype.SetVisualFlags= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.VisualFlags = value;
}

WebForm.prototype.SetResModeW= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.ResModeW = value;
}

WebForm.prototype.SetResModeH= function(value) 
{
  // Devo solo impostare il valore in quanto questa proprieta'
  // non puo' cambiare dopo che l'oggetto e' stato realizzato
  this.ResModeH = value;
}

WebForm.prototype.SetCaption= function(value) 
{
  if (value!=undefined)
    this.Caption = value;
  //
  if (this.Realized)
  {
    if (this.Caption != "" && (this.HasCaption() || this.ShowFormList()))
    {
      if (this.HasCaption())
      {  
        if (RD3_Glb.IsIconString(this.Caption))
          this.CaptionTxt.innerHTML = RD3_Glb.HandleIconString(this.Caption);
        else
          this.CaptionTxt.textContent = this.Caption;
        //
        // Devo mostrare la caption se non e' visibile (il padre viene staccato dal DOM
        // così si possono usare i selettori per impostare le altezze senza doverlo fare da javascript)
        if (this.CaptionBox.parentNode && !this.CaptionBox.parentNode.parentNode)
          this.FormBox.insertBefore(this.CaptionBox.parentNode, this.FormBox.firstChild);
      }
      else
      {
        // Devo nascondere la caption
        if (this.CaptionBox.parentNode && this.CaptionBox.parentNode.parentNode)
          this.FormBox.removeChild(this.CaptionBox.parentNode);
      }
      //
      if (this.ShowFormList())
      {
        if (this.FLBox) {
          if (RD3_Glb.IsIconString(this.Caption))
            this.FLBox.innerHTML = RD3_Glb.HandleIconString(this.Caption);
          else
            this.FLBox.textContent = this.Caption;
        }
        
      }
      //
      // Devo mostrare la caption nella Form List
      if (this.FLRow)
        this.FLRow.style.display = this.ShowFormList() ? "" : "none";
    }
    else
    {
      // Devo nascondere la caption
      this.FormBox.removeChild(this.CaptionBox.parentNode);
      //
      // Devo nascondere la caption
      if (this.FLRow)
        this.FLRow.style.display = "none";
    }
  }
}


WebForm.prototype.SetWebCaption= function(value) 
{
  if (value!=undefined)
    this.WebCaption = value;
  //
  if (this.Realized) {
    if (this.WebCaption != "" && this.HasCaption()) {
      this.CaptionTxt.innerHTML = RD3_Glb.HandleIconString(this.WebCaption);
      //
      // Devo mostrare la caption se non e' visibile (il padre viene staccato dal DOM
      // cosi' si possono usare i selettori per impostare le altezze senza doverlo fare da javascript)
      if (this.CaptionBox.parentNode && !this.CaptionBox.parentNode.parentNode)
        this.FormBox.insertBefore(this.CaptionBox.parentNode, this.FormBox.firstChild);
    }
    else {
      // Devo nascondere la caption
      if (this.CaptionBox.parentNode && this.CaptionBox.parentNode.parentNode)
        this.FormBox.removeChild(this.CaptionBox.parentNode);
    }
  }
}

WebForm.prototype.SetImage= function(value) 
{
  if (value!=undefined)
    this.Image = value;
  //
  if (this.Realized && this.ImgIcon)
  {
    if (this.Image == "")
    {
      // Nascondo l'icona
      this.ImgIcon.style.display = "none";
    }
    else
    {
      this.ImgIcon.src = RD3_Glb.GetImgSrc("images/" + this.Image);
      this.ImgIcon.style.display = "";
    }
    //
    if (this.ParentTab)
      this.ParentTab.SetImage(this.Image);
  }
}

WebForm.prototype.SetWindowState= function(value) 
{
  var old = this.WindowState;
  if (value!=undefined)
    this.WindowState = value;
}

// ******************************************************************
// Chiamata alla fine dell'animazione di resize modale, fa i tocchi 
// finali e decide se far fare o meno l'adaptlayout a GFX
// ******************************************************************
WebForm.prototype.AfterPopupResizeFinish = function() 
{
  return true;
}


WebForm.prototype.SetVisible= function(value, doanim) 
{
  var old = this.Visible;
  if (value!=undefined)
    this.Visible = value;
  //
  if (this.Realized && (old!=this.Visible || value==undefined))
  {
    if (doanim)
    {
      /*if (this.Docked)    // DOCKED
      {
        var fx = new GFX("docked", this.Visible, this, false);
        //
        // In caso di chiusura devo solo nascondere..
        fx.CloseFormAnimation = false;
        RD3_GFXManager.AddEffect(fx);
        //
        return;
      }
      //
      if (this.Modal==0)    // MDI
      {
        // Non devo fare niente, ci pensa il server a mandare la nuova active form..
        // Devo solo Gestire la Form List
        if (this.FLBox)
        {
          this.FLBox.style.display = this.Visible? "" : "none";        
          //
          if (this.Visible)
            this.AdaptFormListLayout();
        }
        //
        return;
      }
      if (this.Modal!=0)    // MODAL O POPUP
      {
        var fx = new GFX("modal", this.Visible, this, false);
        fx.CloseFormAnimation = false;
        RD3_GFXManager.AddEffect(fx);
        //
        if (this.FLBox)
        {
          this.FLBox.style.display = this.Visible? "" : "none";
          //
          if (this.Visible)
            this.AdaptFormListLayout();
        }
      }*/
    }
    else
    {
      this.FormBox.style.display = this.Visible? "" : "none";
      // 
      // Gestiamo la Form List
      if (this.FLBox)
        this.FLBox.style.display = this.Visible? "" : "none";
    }
  }
}


WebForm.prototype.SetFormLeft= function(value, skipanim) 
{
  if (value!=undefined)
  {
    var old = this.FormLeft;
    this.FormLeft = value;
  }
}

WebForm.prototype.SetFormTop= function(value, skipanim) 
{
  if (value!=undefined)
  {
    var old = this.FormTop;
    this.FormTop = value;
  }  
}

WebForm.prototype.SetFormWidth= function(value, skipanim) 
{
  if (value!=undefined)
  {
    var old = this.FormWidth;
    this.FormWidth = value;
  }
}

WebForm.prototype.SetFormHeight= function(value, skipanim) 
{
  if (value!=undefined)
  {
    var old = this.FormHeight;
    this.FormHeight = value;
  }
}


// ******************************************************
// Setter dei tasti intercettati dalla form
// ******************************************************
WebForm.prototype.SetHandledKeys = function(value)
{
  if (value!=undefined)
    this.HandledKeys = value;
  //
  // Questa proprieta' non puo' variare dopo essere stata inviata, e viene gestita
  // nel KBManager
}


// ******************************************************
// Setter del testo del BackButton
// ******************************************************
WebForm.prototype.SetBackButtonText = function(value)
{
  if (value!=undefined)
    this.BackButtonTxt = value;
}


WebForm.prototype.SetClassName = function(value) 
{
  var old = this.ClassName;
  if (value!=undefined)
    this.ClassName = value;
  //
  if (this.Realized && (old != this.ClassName || value == undefined)) {
    // Se c'e' un vecchio valore lo rimuovo, poi se ce n'e' uno nuovo lo aggiungo.
    // in questo modo posso gestire correttamente il cambio da classe "a" -> ""
    if (old)
      RD3_Glb.RemoveClass(this.FormBox, old);
    if (this.ClassName)
      RD3_Glb.AddClass(this.FormBox, this.ClassName);
  }
}


WebForm.prototype.SetPreview= function(value) 
{
  // Vedi anche funzione successiva
  this.PreviewFrame = value;
}


// ***************************************************************
// Mostra il preview impostato precedentemene
// ***************************************************************
WebForm.prototype.PopupPreview= function() 
{
  
}


// ***************************************************************
// Chiude il preview impostato precedentemene
// ***************************************************************
WebForm.prototype.ClosePreview= function() 
{
  
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
WebForm.prototype.Realize = function()
{
  // Calcolo dove dovro' inserire questa form
  var parent;
  var _this = this;
  var mob = RD3_Glb.IsMobile();
  var mob7 = RD3_Glb.IsMobile7();
	//
  if (this.SubFormObj)
  {
    if (this.SubFormObj instanceof SubForm)
      parent = this.SubFormObj.ContentBox;
    else if (this.SubFormObj instanceof BookBox)
      parent = this.SubFormObj.BoxBox;
  }
  else
    parent = RD3_DesktopManager.WebEntryPoint.FormsBox;
  //
  // Gestione apertura finestra modale
  if (this.Modal)
  {
    this.PopupFrame = new PopupFrame(this);
    //
    if (this.Modal == 2)
      this.PopupFrame.AutoClose = true;
    //
    this.PopupFrame.HasCaption = false;
    this.PopupFrame.Realize(this.Modal==2?"-popover":"-modal");
    parent = this.PopupFrame.ContentBox;
    //
    var addLg = true;
    if (this.ClassName && this.ClassName.indexOf("modal-sm") != -1) 
    {
      RD3_Glb.AddClass(this.PopupFrame.PopupDialog, "modal-sm");
      addLg = false;
    }
    else if (this.ClassName && this.ClassName.indexOf("modal-md") != -1)
      addLg = false;
    if (addLg)
      RD3_Glb.AddClass(this.PopupFrame.PopupDialog, "modal-lg");
  }
  //
  if (this.Docked)
  {
    if (this.DockType==RD3_Glb.FORMDOCK_LEFT)
      parent = RD3_DesktopManager.WebEntryPoint.LeftDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_TOP)
      parent = RD3_DesktopManager.WebEntryPoint.TopDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_RIGHT)
      parent = RD3_DesktopManager.WebEntryPoint.RightDockedBox;
    if (this.DockType==RD3_Glb.FORMDOCK_BOTTOM)
      parent = RD3_DesktopManager.WebEntryPoint.BottomDockedBox;
    //
    // Devo far scattare l'aggiornamento dei comandi (per mostrare le mie toolbar) solo
    // se io non sono la form attiva, dato che in quel caso scatterebbe automaticamente
    var actf = RD3_DesktopManager.WebEntryPoint.ActiveForm;
    if (!actf || (actf && actf.IdxForm != this.IdxForm))
      RD3_DesktopManager.WebEntryPoint.RefreshCommands = true;
  }
  //
  // Realizzo i miei oggetti visuali
  // Creo il mio contenitore globale
  this.FormBox = document.createElement("div");
  this.FormBox.setAttribute("id", this.Identifier);
  this.FormBox.className = "panel panel-default form-main-box";
  //
  // Creo la box per i frames
  this.FramesBox = document.createElement("div");
  this.FramesBox.setAttribute("id", this.Identifier+":frs");
  this.FramesBox.className = "panel-body form-body"+ (this.ResModeH === RD3_Glb.FRESMODE_NONE ? " form-body-fluid" : "");
  //
  // Creo la lista dei messaggi
  this.MessagesBox = document.createElement("div");
  this.MessagesBox.setAttribute("id", this.Identifier+":msg");
  this.MessagesBox.className = "form-message-container";
  //
  // Creo la box della caption
  var cptBox = document.createElement("div");
  cptBox.className = "panel-heading form-caption";
  //
  this.CaptionBox = document.createElement("h3");
  this.CaptionBox.setAttribute("id", this.Identifier+":cap");
  this.CaptionBox.className = "panel-title clearfix";
  cptBox.appendChild(this.CaptionBox);
  //
  // INIZIO GESTIONE TOOLBAR
  if (this.HasCloseButton())
  {
    this.CloseBtn = document.createElement("a");
    this.CloseBtn.setAttribute("id", this.Identifier+":clo");
    this.CloseBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_CLOSE, "fa-lg"));
    this.CloseBtn.className = "panel-caption-image";
    RD3_TooltipManager.SetObjTitle(this.CloseBtn, RD3_ServerParams.ChiudiForm, null, "auto right");
    this.CloseBtn.onclick = function(ev) {
      _this.OnClose(ev);
    };
  }
  //
  if (this.HasIcon())
  {
    this.ImgIcon = document.createElement("img");
    this.ImgIcon.setAttribute("id", this.Identifier+":ico");
    this.ImgIcon.className = "panel-caption-image";
    this.ImgIcon.ondblclick = function(ev) {
      _this.OnClose(ev);
    };
  }  
  //
  if (this.Modal)
  {
    if (this.HasConfirmButton())
    {
      this.ConfirmBtn = document.createElement("a");
      this.ConfirmBtn.setAttribute("id", this.Identifier+":con");
      this.ConfirmBtn.className = "panel-caption-image";
      this.ConfirmBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_CONFIRM, "fa-lg"));
      RD3_TooltipManager.SetObjTitle(this.ConfirmBtn, RD3_ServerParams.ModalConfirm);
      this.ConfirmBtn.onclick = function(ev) {
        _this.OnConfirm(ev);
      };
    }
    //
    if (this.HasHelpButton())
    {
      this.HelpBtn = document.createElement("a");
      this.HelpBtn.setAttribute("id", this.Identifier+":hlp");
      this.HelpBtn.className = "panel-caption-image";
      this.HelpBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_HELP, "fa-lg"));
      this.HelpBtn.onclick = function(ev) {
        RD3_DesktopManager.WebEntryPoint.OnHelpButton(ev);
      };
    }
    //
    if (this.HasDebugButton())
    {
      this.DebugBtn = document.createElement("a");
      this.DebugBtn.setAttribute("id", this.Identifier+":dbg");
      this.DebugBtn.className = "panel-caption-image";
      this.DebugBtn.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_DEBUG, "fa-lg"));
      this.DebugBtn.onclick = function(ev) {
        RD3_DesktopManager.WebEntryPoint.OnDebug(ev);
      };
    }
  }
  //
  // Ecco il testo  
  this.CaptionTxt = document.createElement("span");  
  //
  // Aggiungo gli oggetti al DOM
  this.RealizeToolbar();
  //
  this.FormBox.appendChild(cptBox);
  //
  //this.FormBox.appendChild(this.MessagesBox);
  this.FormBox.appendChild(this.FramesBox);
  this.RealizeFormList();
  //
  // Realizzo i frames... devo farlo seguendo la gerarchia.
  if (this.Frames[0])
   this.Frames[0].Realize(this.FramesBox);
  //
  // Realizzo i messaggi
  this.RealizeMessages();
  //
  // Eseguo l'impostazione iniziale delle mie proprieta' (quelle che cambiano l'aspetto visuale)
  this.Realized = true;
  this.SetImage();
  this.SetCaption();
  this.SetWebCaption();
  this.SetVisible();
  this.SetWindowState();
  this.SetFormLeft(null, true);   // In questo caso devo far saltarre l'animazione!
  this.SetFormTop(null, true);
  this.SetFormWidth(null, true);
  this.SetFormHeight(null, true);
  this.SetBackButtonText();
  this.SetClassName();
  //
  // SOLO alla fine attacco la form al DOM,
  // cosi' si fa prima
  parent.appendChild(this.FormBox);
  //
  // Ora che ho la form a video posso impostare la griglia
  this.CalcGridLayout();
  if (this.Modal) {
    if (this.FormHeight!=-1) 
      this.PopupFrame.SetHeight(this.FormHeight);
    else {
      // Se il contenuto e' piu' alto del massimale bootstrap (maxH-120px) oppure il contenuto non ha altezze esplicite 
      // fisso l'altezza alla massima altezza consentita da bootstrap
      var hh = this.Frames[0].CalcHeight(true) + 70;
      if (hh > window.innerHeight - 122 || this.ResModeH != RD3_Glb.FRESMODE_NONE)
        this.PopupFrame.SetHeight(window.innerHeight - 122);
      else
        this.PopupFrame.SetHeight(hh);
    }
    this.FormBox.style.height = "100%";
    this.PopupFrame.Open();
  }
}


// ********************************************************************************
//  Realizzo tutti i messaggi non ancora realizzati
// ********************************************************************************
WebForm.prototype.RealizeMessages = function()
{
  // Se non sono stata ancora realizzata, lascio perdere
  // Se non mostro messaggi, non realizzo niente!
  if (!this.Realized || !this.ShowMessages())
    return;
  //
  // Svuoto la messageBox
  var n = this.Messages.length;
  var newmsg = 0;
  for (var i=0; i<n; i++)
  {
    if (!this.Messages[i].Realized)
    {
      this.Messages[i].Realize(this.MessagesBox);
      newmsg++;
    }
  }
  //
  // Rimuovo i messaggi temporanei
  this.RemoveTemporaryMessages();
  //
  if (n > 0) {
    this.FormBox.insertBefore(this.MessagesBox, this.FramesBox);
    this.FramesBox.style.height = "calc(100% - "+ (38 + this.MessagesBox.offsetHeight) + "px)";
  }
  else if (this.MessagesBox.parentNode) {
    this.MessagesBox.parentNode.removeChild(this.MessagesBox);
    this.FramesBox.style.height = "";
  }
}


// ********************************************************************************
//  Torna true se la form e' veramente MODALE
// ********************************************************************************
WebForm.prototype.IsModalPopup = function()
{ 
  return (this.Modal==1 || this.Modal==-1);
}


// ********************************************************************************
//  Creo la entry della form nella lista delle form aperte 
// ********************************************************************************
WebForm.prototype.RealizeFormList = function()
{ 
  // Non creo la formlist se docked o modal, oppure se il menu' e' in alto o in basso
  if (!this.HasFormList())
    return;
  //
  if (RD3_DesktopManager.WebEntryPoint.HasSideMenu()) {
    var flt = null;
    //
    // Ottengo per prima cosa il div in cui inserire la entry
    var flt = RD3_DesktopManager.WebEntryPoint.FormsListBodyBox;
    var clall = RD3_DesktopManager.WebEntryPoint.CloseAllRow;
    //
    // Creo gli elementi del DOM
    this.FLRow = document.createElement("tr");
    this.FLRow.setAttribute("id", this.Identifier+":frl");
    var td = document.createElement("td");
    this.FLRow.appendChild(td);
    //
    this.FLBox = document.createElement("a");
    this.FLBox.className = "has-pointer";
    td.appendChild(this.FLBox);
    //
    this.FLBox.onclick = function (ev) {
      this.OnFLClick(ev);
    }.bind(this);
    //
    if (flt && clall)
      flt.insertBefore(this.FLRow, clall);
    else if (flt)
      flt.appendChild(this.FLRow);
  }
  else if (RD3_DesktopManager.WebEntryPoint.FormListBarMenuBox) {
    // Creo la entry nel menu dropdown
    this.FLRow = document.createElement("li");
    this.FLRow.setAttribute("id", this.Identifier+":frl");
    this.FLBox = document.createElement("a");
    this.FLRow.appendChild(this.FLBox);
    //
    //
    this.FLBox.onclick = function (ev) {
      this.OnFLClick(ev);
    }.bind(this);
    //
    RD3_DesktopManager.WebEntryPoint.FormListBarMenuBox.appendChild(this.FLRow);
  }
}


// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
WebForm.prototype.AdaptLayout = function(force)
{ 
  for (var i = 0; i < this.Frames.length; i++) {
    var fr = this.Frames[i];
    if (fr instanceof IDPanel && fr.Realized)
      fr.SetAlignHeader(true);
  }
}


// ********************************************************************************
// Adatta la toolbar di form per mettere le toolbar a destra
// ********************************************************************************
WebForm.prototype.AdaptToolbarLayout = function()
{
  
}



// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
WebForm.prototype.AdaptDocked = function()
{ 
  if (this.Docked)
  {
    if (this.DockType==RD3_Glb.FORMDOCK_TOP)
    {
      var h = this.Frames[0].Height + this.CaptionBox.offsetHeight + (this.MessagesBox.offsetHeight) + 2;
      //
      var s = RD3_Glb.GetCurrentStyle(this.FramesBox);
      h += parseInt("0"+s.paddingTop) + parseInt("0"+s.paddingBottom);
      //
      s = RD3_Glb.GetCurrentStyle(RD3_DesktopManager.WebEntryPoint.TopDockedBox);
      h += parseInt("0"+s.paddingTop) + parseInt("0"+s.paddingBottom);
      //
      RD3_DesktopManager.WebEntryPoint.TopDockedBox.style.height = this.Visible ?  h+"px" : "0px";
    }
    if (this.DockType==RD3_Glb.FORMDOCK_BOTTOM)
    {
      var h = this.Frames[0].Height + this.CaptionBox.offsetHeight + (this.MessagesBox.offsetHeight) + 2;
      var s = RD3_Glb.GetCurrentStyle(this.FramesBox);
      h += parseInt("0"+s.paddingTop) + parseInt("0"+s.paddingBottom);
      RD3_DesktopManager.WebEntryPoint.BottomDockedBox.style.height =this.Visible ?   h+"px" : "0px";
    }
  }
}



// ********************************************************************************
// Calcola le dimensioni della form list e ne adatta la larghezza
// ********************************************************************************
WebForm.prototype.AdaptFormListLayout = function()
{ 
  
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
WebForm.prototype.Unrealize = function()
{ 
  // Tolgo la form dal DOM
  if (this.FormBox && this.FormBox.parentNode)
    this.FormBox.parentNode.removeChild(this.FormBox);
  //
  // La tolgo dalla mappa degli oggetti
  RD3_DesktopManager.ObjectMap[this.Identifier] = null;
  //
  // Se sono una Form Multipla devo portare nella tomba i miei commandset
  if (this.IdxForm>65536)
   RD3_DesktopManager.WebEntryPoint.CmdObj.CloseMultipleForm(this.IdxForm);
  //
  // Passo il messaggio ai webframe
  this.Frames[0].Unrealize();
  //
  // Ora i messaggi
  var n = this.Messages.length;
  for (var i=0; i<n; i++)
    this.Messages[i].Unrealize();
  //
  // Elimino la entry dalla lista delle Form aperte
  if (this.FLRow && this.FLRow.parentNode)
    this.FLRow.parentNode.removeChild(this.FLRow);
  //
  // Elimino il popupframe
  if (this.PopupFrame)
    this.PopupFrame.Unrealize();
  //
  if (this.Docked)
  {
    // La struttura principale deve essere riadattata
    RD3_DesktopManager.WebEntryPoint.RecalcLayout = true;
    //
    // Se sono io la form attiva verra' notificato l'evento di cambio form attiva, se non sono io
    // l'evento non scatta e devo occuparmi io di fare nascondere le mie toolbar
    var actf = RD3_DesktopManager.WebEntryPoint.ActiveForm;
    if (actf && actf.IdxForm != this.IdxForm)
      RD3_DesktopManager.WebEntryPoint.RefreshCommands = true;
  }
  //
  // Rimuovo i collegamenti al DOM
  this.FormBox = null;
  this.CaptionBox = null;
  this.CloseBtn = null;
  this.ConfirmBtn = null;
  this.CaptionTxt = null;  
  this.FramesBox = null;   
  this.ImgIcon = null;
  //
  this.FLRow = null;
  this.FLBox = null;    
  this.FLImg = null;  
  //
  this.Realized = false;
}


// ********************************************************************************
// Gestore evento di click su pulsante CHIUDI
// ********************************************************************************
WebForm.prototype.OnClose= function(evento)
{ 
  var ev = new IDEvent("close", this.Identifier, evento, this.ClickEventDef);
  //
  // Devo fermare l'evento, altrimenti il click passa alla caption e
  // se e' doppio la massimizza
  if (evento)
    RD3_Glb.StopEvent(evento);
  //
  // Chiudo eventuali menu' popup rimasti aperti
  RD3_DesktopManager.WebEntryPoint.CmdObj.ClosePopup();
}


// ********************************************************************************
// Gestore evento di click su pulsante CONFERMA
// ********************************************************************************
WebForm.prototype.OnConfirm= function(evento)
{ 
  var ev = new IDEvent("confirm", this.Identifier, evento, this.ClickEventDef);
}

// ********************************************************************************
// Modifica del window state
// ********************************************************************************
WebForm.prototype.OnMaximize= function(evento)
{ 
  
}

WebForm.prototype.OnMinimize= function(evento)
{ 
  
}

WebForm.prototype.DontMinimize= function(evento)
{ 
  
}



// ********************************************************************************
// Imposto l'attivazione o meno di questa form: se value e' true e visible e' true
// la mostro, altrimenti la nascondo
// force = false o undefined: non imposta il display
// ********************************************************************************
WebForm.prototype.SetActive = function(value, force)
{
  if (!this.Realized)
    return;
  //
  if (this.IsModalPopup())
    return;
  if (this.Docked)
    return;
  //
  if (!force)
    force = false;
  //
  if (value && this.Visible)
  {
    if (force && this.Modal==0)
      this.FormBox.style.display = "";
    //
    if (this.PopupFrame)
      this.PopupFrame.BringToFront();
  }
  else
  {
    this.AlreadyVisible = false;
    //
    if (force && this.Modal==0)
      this.FormBox.style.display = "none";
  }
}


// ********************************************************************************
// Metto l'oggetto passato in una delle mie toolbar
// ********************************************************************************
WebForm.prototype.CaptureToolbarButton= function(obj)
{ 
  if (!obj)
    return;
  //
  var tb = this.GetFirstToolbar(true);
  if (tb)
  {
    // Eseguo operazione
    if (obj.parentNode)
      obj.parentNode.removeChild(obj);
    tb.insertBefore(obj, tb.firstChild);
  }
}


// ********************************************************************************
// Gestore evento di click sulla entry nella FormList
// popclk = true se chiamata dal click sul popup frame che serve quando si
// cerca di attivare la form
// ********************************************************************************
WebForm.prototype.OnFLClick= function(evento, popclk, nolocal)
{ 
  // Se sono una SubForm non mi interessa
  if (this.SubFormObj)
    return;
  //
  // Verifico se sono io la form attiva: se si non c'e' bisogno di fare altro
  var wep = RD3_DesktopManager.WebEntryPoint;
  if (wep.ActiveForm==this || wep.ActiveForm == this.Identifier)
    return;
  //
  // Lancio evento e faccio gestione locale se richiesto e se non ho un animazione bloccante in corso
  var ev = new IDEvent("flclk", this.Identifier, evento, this.ClickFLEventDef);
  if (ev.ClientSide && !RD3_GFXManager.Blocking() && !nolocal) {
    // Attivo la form chiamando il metodo di Wep
    wep.ActivateForm(this.Identifier);
    //
    // Chiudo eventuali menu' popup rimasti aperti
    wep.CmdObj.ClosePopup();
  }  
}


// ********************************************************************************
// Ho una Popup e il server ha cambiato la sua posizione o dimensione: devo animare
// questo cambiamento!
// ********************************************************************************
WebForm.prototype.StartPopupResizeGFX= function()
{
  
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
WebForm.prototype.AfterProcessResponse= function()
{ 
  if (this.RecalcGridLayout) 
  {
    this.CalcGridLayout();
    this.OnViewportResize();
    this.RecalcGridLayout = false;
  }
  //
  if (this.UpdateResizeSkipped)
  {
    delete this.UpdateResizeSkipped;
    this.OnViewportResize();
  }
  //
  // Se devo far ricalcolare la visibilita' dei comandi lo faccio ora
  if (this.RecalcCommands)
  {
    RD3_DesktopManager.WebEntryPoint.CmdObj.ActiveFormChanged();
    this.RecalcCommands = false;
  }
  //
  // Giro il messaggio ai frames
  var n = this.Frames.length;
  for (var i=0;i<n;i++)
    this.Frames[i].AfterProcessResponse();
}


// ********************************************************************************
// Devo dare il fuoco a qualcosa nella form
// ********************************************************************************
WebForm.prototype.Focus= function(startframe, gotop)
{ 
  return false;
}


// **********************************************************************
// Gestisco la pressione dei tasti FK a partire dalla form
// **********************************************************************
WebForm.prototype.HandleFunctionKeys = function(eve)
{
  var code = (eve.charCode) ? eve.charCode : eve.keyCode;
  var ok = false;
  //
  // Verifico la toolbar di form
  ok = RD3_DesktopManager.WebEntryPoint.CmdObj.HandleFunctionKeys(eve, this.IdxForm, -1);
  if (ok)
    return ok; // Nel caso esco subito perche' non devo fare verifiche ulteriori
  //
  // Calcolo il numero di FK da 1 a 48
  var fkn = (code - 111) + (eve.shiftKey ? 12 : 0) + (eve.ctrlKey ? 24 : 0);
  //
  // Vediamo se corrisponde ad uno dei miei tasti predefiniti
  if (fkn == RD3_ClientParams.FKCloseForm) {
    ok = true;
    this.OnClose(eve);
  }
  //
  // Passo il messaggio al desktop
  if (!ok)
    ok = RD3_DesktopManager.WebEntryPoint.HandleFunctionKeys(eve);
  //
  return ok;
}


// **********************************************************************
// Ritorna l'indice 0-based del frame indicato
// **********************************************************************
WebForm.prototype.GetFrameIndex = function(frame)
{
  var n = this.Frames.length;
  for (var i=0; i<n; i++) 
  {
    var fr = this.Frames[i];
    if (fr==frame)
    {
      return i;
    }
  }
  //
  return -1;
}


// ********************************************************************************
// Vediamo se uno dei panneli contenuti ha info-messages
// ********************************************************************************
WebForm.prototype.HasInfoMessages = function()
{ 
  var n = this.Frames.length;
  for (var i=0; i<n; i++) 
  {
    if (this.Frames[i].InfoMessage)
      return true;
  }
}


// ********************************************************************************
// Posso spostare la form se e' modale
// ********************************************************************************
WebForm.prototype.IsTransformable = function()
{
  // Se sono una sub-form di BookBox chiedo a lei
  if (this.SubFormObj && this.SubFormObj instanceof BookBox)
    return this.SubFormObj.IsTransformable();
  //
  return (this.PopupFrame!=null && (this.CanResize() || this.CanMove())) || (this.Docked && this.CanResize() && RD3_ServerParams.EnableFrameResize);
}

WebForm.prototype.IsDraggable = function()
{
  // Se sono una sub-form di BookBox chiedo a lei
  if (this.SubFormObj && this.SubFormObj instanceof BookBox)
    return this.SubFormObj.IsDraggable();
  //
  return false;
}

WebForm.prototype.DragObj = function(id)
{
  // Se una sub-form di BookBox
  if (this.SubFormObj && this.SubFormObj instanceof BookBox)
  {
    // E sono sull'intestazione, rispondo che occorre tirare la box
    if (id.substr(id.length-4)==":cap" || id.substr(id.length-4)==":txt")
      return this.SubFormObj;
    else
      return null;
  }
  else
    return this;
}

WebForm.prototype.IsMoveable = function()
{
  return this.PopupFrame!=null && this.CanMove();
}

WebForm.prototype.IsResizable = function()
{
  return (this.PopupFrame!=null && this.CanResize()) || (this.Docked && this.CanResize());
}

// ********************************************************************************
// Resituisce l'oggetto DOM su cui deve essere effettuata la trasformazione
// ********************************************************************************
WebForm.prototype.DropElement = function()
{
  if (this.Modal)
    return this.PopupFrame.PopupBox;
  else if (this.Docked)
    return this.FormBox;
}

// ********************************************************************************
// Metodo chiamato per effettuare la trasformazione
// ********************************************************************************
WebForm.prototype.OnTransform = function(x, y, w, h, evento)
{
  
}

// ********************************************************************************
// Applico il cursore di trasformazione alla caption
// ********************************************************************************
WebForm.prototype.ApplyCursor = function(cn)
{
  
}


// ********************************************************************************
// Salva le dimensioni attuali dei frames
// ********************************************************************************
WebForm.prototype.SaveSize = function()
{ 
  var n = this.Frames.length;
  for (var i=0; i<n; i++) 
  {
    this.Frames[i].SaveSize();
  }  
}


// ********************************************************************************
// Ripristina le dimensioni dei frames
// ********************************************************************************
WebForm.prototype.ResetSize = function()
{ 
  var n = this.Frames.length;
  for (var i=0; i<n; i++) 
  {
    this.Frames[i].ResetSize();
  }  
}


// ********************************************************************************
// Gestore evento di mouse over su uno degli oggetti di questa form
// ********************************************************************************
WebForm.prototype.OnMouseOverObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Gestore evento di mouse out su uno degli oggetti di questa form
// ********************************************************************************
WebForm.prototype.OnMouseOutObj= function(evento, obj)
{ 
 
}


// ********************************************************************************
// Gestore evento di mouse down su uno degli oggetti di questa form
// ********************************************************************************
WebForm.prototype.OnMouseDownObj= function(evento, obj)
{ 
  
}


// ********************************************************************************
// Funzioni per il reperimento degli stili visuali
// ********************************************************************************
WebForm.prototype.HasCaption= function()
{ 
  return this.VisualFlags & 0x1;
}

WebForm.prototype.CanResize= function()
{ 
  return false;
}

WebForm.prototype.CanMove= function()
{ 
  return false;
}

WebForm.prototype.HasMinButton= function()
{ 
  return false;
}

WebForm.prototype.HasMaxButton= function()
{ 
  return false;
}

WebForm.prototype.HasCloseButton= function()
{ 
  return (this.VisualFlags & 0x20) && this.ToolbarPosition!=0;
}

WebForm.prototype.HasConfirmButton= function()
{ 
  return (this.VisualFlags & 0x40) && this.IsModalPopup() && this.ToolbarPosition!=0;
}

WebForm.prototype.HasHelpButton= function()
{ 
  return (this.VisualFlags & 0x80) && RD3_DesktopManager.WebEntryPoint.HasHelpButton() && this.ToolbarPosition!=0;
}

WebForm.prototype.HasDebugButton= function()
{ 
  return (this.VisualFlags & 0x100) && RD3_DesktopManager.WebEntryPoint.HasDebugButton() && this.ToolbarPosition!=0;
}

WebForm.prototype.HasIcon= function()
{ 
  return (this.VisualFlags & 0x200);
}

WebForm.prototype.ShowMessages= function()
{ 
  return (this.VisualFlags & 0x400);
}

WebForm.prototype.HasBackButton= function()
{ 
  return false;
}

WebForm.prototype.ShowFormList = function()
{ 
  return (this.VisualFlags & 0x1000);
}

// ********************************************************************************
// Imposta la visibilita' dei bottoni della toolbar
// ********************************************************************************
WebForm.prototype.SetButtonVisibility= function(value)
{
  if (this.CloseBtn)
    this.CloseBtn.style.visibility = value;
  if (this.ConfirmBtn)
    this.ConfirmBtn.style.visibility = value;
  if (this.MinBtn)
    this.MinBtn.style.visibility = value;
  if (this.MaxBtn)
    this.MaxBtn.style.visibility = value;
  if (this.HelpBtn)
    this.HelpBtn.style.visibility = value;
  if (this.DebugBtn)
    this.DebugBtn.style.visibility = value;
  if (this.ImgIcon)
    this.ImgIcon.style.visibility = value;
}


// ********************************************************************************
// Prende un CommandSet di tipo 
// ********************************************************************************
WebForm.prototype.AttachToolbar= function(cmd)
{
  if (!cmd.MyToolBox)
    return;
  //
  if (cmd.MyToolBox.parentNode)
  {
    // La toolbar fa gia' parte della mia caption: non c'e' bisogno che me la riprenda...
    if (cmd.MyToolBox.parentNode == this.CaptionBox)
      return;
    //
    // Stacco la toolbar dal contenitore precedente
    cmd.MyToolBox.parentNode.removeChild(cmd.MyToolBox);
  }
  //
  // In base al tipo di toolbar, vediamo dove metterla
  switch(this.ToolbarPosition)
  {
    case RD3_Glb.FORMTOOL_NONE:
    case RD3_Glb.FORMTOOL_LEFT:
    case RD3_Glb.FORMTOOL_DISTRIB:
      this.CaptionBox.appendChild(cmd.MyToolBox);
      RD3_Glb.RemoveClass(cmd.MyToolBox, "pull-left");
      RD3_Glb.AddClass(cmd.MyToolBox, "pull-right");
    break;
    
    case RD3_Glb.FORMTOOL_RIGHT:
      this.CaptionBox.appendChild(cmd.MyToolBox);
      RD3_Glb.RemoveClass(cmd.MyToolBox, "pull-right");
      RD3_Glb.AddClass(cmd.MyToolBox, "pull-left");
    break;
  }
}


// *********************************************************
// Timer globale
// *********************************************************
WebForm.prototype.Tick = function()
{
  var n = this.Frames.length;
  for(var i=0; i<n; i++)
  {
    var f = this.Frames[i];
    if (f && f.Realized && f.Visible)
      f.Tick();
  }
}


// ********************************************************************************
//  Creo la entry della form list del menu' popup
// ********************************************************************************
WebForm.prototype.RealizeFormListPopup = function(popup, n)
{ 
  
}


// ********************************************************************************
//  Torna true se questa form e' parte della form list
// ********************************************************************************
WebForm.prototype.HasFormList = function()
{ 
  // Modali, docked e sub-form non hanno mai la voce nella form list
  if (this.IsModalPopup() || this.Docked || this.SubFormObj)
    return false;
  //
  return this.ShowFormList();
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
WebForm.prototype.GetTooltip = function(tip, obj)
{
  
}

// **********************************************************************
// La form per ora non vuole essere droppata, ma se mai spostata...
// **********************************************************************
WebForm.prototype.GetDropList= function()
{
  return null;  
}


// ********************************************************************************
// Su quali oggetti e' possibile droppare?
// ********************************************************************************
WebForm.prototype.ComputeDropList = function(list,dragobj)
{
  // Se non sono stato realizzato... o non posso... niente DropList
  if (!this.Realized)
    return;
  //
  // Calcolo form drag obj
  var df = null;
  if (dragobj.GetParentFrame)
  {
    df = dragobj.GetParentFrame();
    if (df)
      df = df.WebForm;
  }
  //
  // Anch'io voglio essere droppabile perche' sono popup e quindi
  // devo impedire che il drag su di me passi sotto
  if (this.Modal && !this.IsModalPopup())
  {
    list.push(this);
    //
    // Calcolo le coordinate assolute...
    var o = this.FormBox;
    this.AbsLeft = RD3_Glb.GetScreenLeft(o,true);
    this.AbsTop = RD3_Glb.GetScreenTop(o,true);
    this.AbsRight = this.AbsLeft + o.offsetWidth - 1;
    this.AbsBottom = this.AbsTop + o.offsetHeight - 1;  
  }  
  //
  // Ora i frames
  var m = this.Frames.length;
  for(var j=0; j<m; j++)
  {
    var fr = this.Frames[j];
    var ok = fr.CanDrop || df==fr.WebForm;
    if (fr.ComputeDropList && ok)
      fr.ComputeDropList(list,dragobj);
  }
}


// *********************************************************
// E' arrivato un click su questa form...
// Vediamo se sono la form attiva
// *********************************************************
WebForm.prototype.OnMouseDownForm = function(evento)
{
  
}


// *********************************************************
// Aggiunge gli oggetti alla toolbar della form
// in base alla posizione. La funzione e' stata estratta per
// facilitarne una eventuale customizzazione
// *********************************************************
WebForm.prototype.RealizeToolbar = function()
{
  switch(this.ToolbarPosition)
  {
    case RD3_Glb.FORMTOOL_NONE:
      if (this.ImgIcon) { 
        this.CaptionBox.appendChild(this.ImgIcon);
        RD3_Glb.AddClass(this.ImgIcon, "pull-left");
      }
      if (this.CaptionTxt)
        this.CaptionBox.appendChild(this.CaptionTxt); 
    break;
    
    case RD3_Glb.FORMTOOL_LEFT:
      if (this.ConfirmBtn) { 
        this.CaptionBox.appendChild(this.ConfirmBtn); 
        RD3_Glb.AddClass(this.ConfirmBtn, "pull-left");
      }
      if (this.CloseBtn)  {
        this.CaptionBox.appendChild(this.CloseBtn);
        RD3_Glb.AddClass(this.CloseBtn, "pull-left"); }
      if (this.HelpBtn) {
        this.CaptionBox.appendChild(this.HelpBtn);
        RD3_Glb.AddClass(this.HelpBtn, "pull-left"); }
      if (this.DebugBtn) {
        this.CaptionBox.appendChild(this.DebugBtn);
        RD3_Glb.AddClass(this.DebugBtn, "pull-left"); }
      if (this.ImgIcon) {
        this.CaptionBox.appendChild(this.ImgIcon);
        RD3_Glb.AddClass(this.ImgIcon, "pull-left"); }
      if (this.CaptionTxt)
        this.CaptionBox.appendChild(this.CaptionTxt);
    break;
    
    case RD3_Glb.FORMTOOL_RIGHT:
    case RD3_Glb.FORMTOOL_DISTRIB:
        if (this.ImgIcon) {
          this.CaptionBox.appendChild(this.ImgIcon);
          RD3_Glb.AddClass(this.ImgIcon, "pull-left"); }
        if (this.CaptionTxt)
          this.CaptionBox.appendChild(this.CaptionTxt);
        if (this.DebugBtn) {
          this.CaptionBox.appendChild(this.DebugBtn);
          RD3_Glb.AddClass(this.DebugBtn, "pull-right"); }
        if (this.HelpBtn) {
          this.CaptionBox.appendChild(this.HelpBtn);
          RD3_Glb.AddClass(this.HelpBtn, "pull-right"); }
        if (this.CloseBtn) {
          this.CaptionBox.appendChild(this.CloseBtn);
          RD3_Glb.AddClass(this.CloseBtn, "pull-right"); }
        if (this.ConfirmBtn) {
          this.CaptionBox.appendChild(this.ConfirmBtn);
          RD3_Glb.AddClass(this.ConfirmBtn, "pull-right"); }
    break;
  }
}


// ********************************************************************************
// Evento di inizio tocco sulla form (chiamato solo se si puo' scrollare)
// ********************************************************************************
WebForm.prototype.OnTouchStart = function(e)
{ 
  
}


// ********************************************************************************
// Evento di movimento del ditino sulla form (chiamato solo se si puo' scrollare)
// ********************************************************************************
WebForm.prototype.OnTouchMove = function(e)
{ 
  
}


// ********************************************************************************
// Evento di movimento del ditino sul pannello
// ********************************************************************************
WebForm.prototype.OnTouchEnd = function(e)
{ 
  
}


// ********************************************************************************
// Gestisce lo scroll via touch del pannello.
// v e' la velocita' di scroll in ms, il segno indica la direzione
// n e' il numero di volte che e' stata eseguita la funzione
// ********************************************************************************
WebForm.prototype.TouchScrollTimer = function(dummy, ap)
{ 
  
}


// ********************************************************************************
// Annulla timer di scroll
// ********************************************************************************
WebForm.prototype.ClearTouchScrollTimer = function()
{
  
}


//**********************************************************
// Gestione Resize Docked: funzioni per gestire il tipo di 
// resize consentito
//**********************************************************
WebForm.prototype.CanResizeW = function()
{
  if (this.Docked && (this.DockType==RD3_Glb.FORMDOCK_TOP || this.DockType==RD3_Glb.FORMDOCK_BOTTOM))
    return false;
  else
    return true;
}

WebForm.prototype.CanResizeH = function()
{
  if (this.Docked && (this.DockType==RD3_Glb.FORMDOCK_LEFT || this.DockType==RD3_Glb.FORMDOCK_RIGHT))
    return false;
  else
    return true;
}

WebForm.prototype.CanResizeL = function()
{
  if (this.Docked && this.DockType!=RD3_Glb.FORMDOCK_RIGHT)
    return false;
  else
    return true;
}

WebForm.prototype.CanResizeR = function()
{
  if (this.Docked && this.DockType!=RD3_Glb.FORMDOCK_LEFT)
    return false;
  else
    return true;
}

WebForm.prototype.CanResizeT = function()
{
  if (this.Docked && this.DockType!=RD3_Glb.FORMDOCK_BOTTOM)
    return false;
  else
    return true;
}

WebForm.prototype.CanResizeD = function()
{
  if (this.Docked && this.DockType!=RD3_Glb.FORMDOCK_TOP)
    return false;
  else
    return true;
}

WebForm.prototype.SetPage = function(page, title)
{
  if (!this.WelcomeBox)
  {
    this.WelcomeBox = document.createElement("iframe");
    this.WelcomeBox.className = "welcome-container";
    this.WelcomeBox.frameBorder = 0;
    this.MessagesBox.style.display = "none";
    this.FormBox.appendChild(this.WelcomeBox);
    this.SetActive(true);
  }
  this.WelcomeBox.src = page;
  this.SetWebCaption(title);
}

WebForm.prototype.Host = function(content, header)
{
  this.HostPage = true;
  //
  if (this.CaptionBox && this.CaptionBox.parentNode)
    this.CaptionBox.parentNode.removeChild(this.CaptionBox);
  //
  this.CaptionBox = header;
  this.FormBox.appendChild(header);
  this.FormBox.appendChild(content);
  this.SetActive(true);
  //
  this.ContentObj = content;
}

// ********************************************************************************
// Ritorna la prima toolbar di form o di frame per infilare dentro dei bottoni
// ********************************************************************************
WebForm.prototype.GetFirstToolbar = function(flref)
{
  if (this.HasCaption())
    return this.CaptionBox;
  //
  // Cerco un frame con una toolbar
  for (var i=0; i<this.Frames.length; i++) 
  {
    var fr = this.Frames[i];
    if (fr instanceof TabbedView)
    {
      if (fr.SelectedPage>=0 && !fr.Tabs[fr.SelectedPage].Content.OnlyContent)
        return fr.Tabs[fr.SelectedPage].Content.ToolbarBox;
    }
    else if (!fr.ChildFrame1 && !fr.OnlyContent)
    {
      if (flref && fr instanceof IDPanel && fr.Realized)
        fr.RefreshToolbar = true;
      return fr.ToolbarBox;
    }
  }
}


// ********************************************************************************
// Una popover si sta chiudendo
// ********************************************************************************
WebForm.prototype.OnAutoClosePopup = function(ev)
{
  this.OnClose(window.event);
  return false;
}


// ********************************************************************************
// Ritorna l'oggetto DOM della toolbar custom attaccata a questa form
// ********************************************************************************
WebForm.prototype.GetCustomToolbar= function()
{ 
  if (!this.CaptionBox)
    return;
  //
  var obj = this.CaptionBox.firstChild;
  while (obj)
  {
    if (RD3_Glb.HasClass(obj,"toolbar-form-container"))
      return obj;
    obj = obj.nextSibling;
  }
}

// ********************************************************************************
// Torna true se la messagebar e' effettivamente visibile a video
// ********************************************************************************
WebForm.prototype.MessageBarOpen= function()
{
  return this.MessageBarIsOpen;
}

// ********************************************************************************
// Apre la message bar per un certo numero di messaggi in modo animato
// ********************************************************************************
WebForm.prototype.OpenMessageBar= function(num)
{
  
}


// ********************************************************************************
// Gestione movimento message bar
// ********************************************************************************
WebForm.prototype.OnMessageBarMouseMove= function(ev)
{
  
}

WebForm.prototype.OnMessageBarMouseDown= function(ev)
{
  
}

WebForm.prototype.OnMessageBarMouseUp= function(ev)
{
  this.MessageBarStartPos = null;
}


WebForm.prototype.RemoveTemporaryMessages= function()
{
  // Rimuovo i messaggi temporanei
  for (var i=this.Messages.length-1; i>=0; i--)
  {
    if (this.Messages[i].Temporary)
    {
      // Se il messaggio riguarda un'altra richiesta lo elimino
      if (this.Messages[i].Request != RD3_DesktopManager.CurrentRequest && !RD3_DesktopManager.SkipClearTempMessages)
      {
        var m = this.Messages[i]; 
        this.Messages.splice(i,1);
        m.Close(true);
      }
    }
  }
}


// ********************************************************************************
// Gestore evento di click sulla caption
// ********************************************************************************
WebForm.prototype.OnCaptionClick= function(evento)
{
  
}

// ********************************************************************************
// Restituisce la Form Master (io oppure il vertice della gerarchia delle SubForm)
// ********************************************************************************
WebForm.prototype.GetMasterForm= function()
{ 
  if (this.SubFormObj == null)
    return this;
  //
  if (this.SubFormObj instanceof BookBox)
    return this.SubFormObj.ParentPage.ParentBook.WebForm.GetMasterForm();
  if (this.SubFormObj instanceof SubForm)
    return this.SubFormObj.WebForm.GetMasterForm();
  //
  return this;
}


// ********************************************************************************
// Abilita o disabilita le IDScroll della form per questa app mobile
// ********************************************************************************
WebForm.prototype.EnableIDScroll= function(stato)
{ 
  
}

//********************************************************************************
// Gestione del bottone back per Android
//********************************************************************************
WebForm.prototype.OnBackButton = function() 
{
  
}

// *******************************************************************
// Chiamato quando ho l'immagine da retinare
// *******************************************************************
WebForm.prototype.OnAdaptRetina = function(w, h, par)
{
  
}

// *******************************************************************
// Restituisce la larghezza in colonne della docked
// *******************************************************************
WebForm.prototype.GetDockedColumns = function()
{ 
  if (this.Docked)
    return Math.ceil(this.Frames[0].Width / 100);
  return 0;
};

WebForm.prototype.CalcGridLayout = function()
{ 
  this.Frames[0].CalcGridLayout();
};

/**
 * Resize della viewport
 */
WebForm.prototype.OnViewportResize = function()
{ 
  // Mi interessa mandare al server i dati di resize solo se sono la form principale attiva
  if (!this.SubFormObj && this.Modal == 0 && RD3_DesktopManager.WebEntryPoint.ActiveForm != this)
  {
    this.UpdateResizeSkipped = true;
    return;
  }
  //
  this.Frames[0].OnViewportResize();
  //
  // Calcolo le dimensioni per informarne il server delle nuove dimensioni
  var clw = this.FramesBox.clientWidth;
  var clh = this.FramesBox.clientHeight;
  if (this.Modal) 
    clh = this.PopupFrame.Height;
  //
  // Notifico l'evento di resize solo se almeno una delle dimensioni e' cambiata
  if (this.lastclw != clw || this.lastclh != clh)
  {
    var ev = new IDEvent("resize", this.Identifier, null, this.ResizeEventDef, null, clw, clh);
    this.lastclw = clw;
    this.lastclh = clh;
  }
};

/**
 * Inizializzazione dell'animazione di visualizzazione form
 */
WebForm.prototype.StartingFormAnimation = function()
{ 
  // Comunico ai vari frames
  for (var i=0; i<this.Frames.length; i++)
    this.Frames[i].StartingFormAnimation();
};