IF EXISTS (SELECT * FROM sys.objects WHERE type = 'FN' AND name = 'sf_QGAP_getTipoTitolo')
BEGIN
    DROP FUNCTION [dbo].[sf_QGAP_getTipoTitolo]
END
GO

CREATE FUNCTION dbo.sf_QGAP_getTipoTitolo (@ID_CESPITE INT)
RETURNS INT
AS
BEGIN

    DECLARE @result INT
	DECLARE @titoliInizialiCount INT 
	DECLARE @titoliInCollegamentiCount INT
	DECLARE @mesiRicorrenza int
	DECLARE @debugString varchar(50)

--compute the variables needed for the final decision
SELECT @titoliInizialiCount = 
(
select count(ID_EVA_REFERENCES) 
FROM EVA_REFERENCES ER 
WHERE ER.ID_EVA_REFERENCE_TYPES = 
(select RifTFIniziale from QGAP_CONFIGURATION) 
AND ER.ID_EVENTO = @ID_CESPITE
)

SELECT @titoliInCollegamentiCount = 
(
select count(ID_EVA_REFERENCES) 
FROM EVA_REFERENCES ER 
WHERE ER.ID_EVA_REFERENCE_TYPES = 
(select RifTFIniziale from QGAP_CONFIGURATION) 
AND ER.ID_FOR_ALL = @ID_CESPITE
)

SELECT @mesiRicorrenza = (select isnull(dbo.sf_GetIntCustomData(22,@ID_CESPITE,(select CDRicorrenza from QGAP_CONFIGURATION)),0) )

-- final decision

IF (@titoliInizialiCount=0 AND @mesiRicorrenza=0 AND @titoliInCollegamentiCount=0)
BEGIN
  SET @result = 2/*unico*/
END
ELSE IF (@titoliInizialiCount>0 AND  @mesiRicorrenza>0)
BEGIN
  SET @result = 1/*aggiornamento*/
END
ELSE IF (@titoliInCollegamentiCount>0 and @mesiRicorrenza=0)
BEGIN
  SET @result = 0/*iniziale*/
END
ELSE IF (@titoliInizialiCount=0 AND @titoliInCollegamentiCount=0 AND @mesiRicorrenza>0)
BEGIN
  SET @result = 3/*periodico*/
END
ELSE
BEGIN
  SET @result = -1
END
SET @debugString = 'RESULT: ' + cast(@result as varchar(10)) + 'TIC: '+cast(@titoliInizialiCount as varchar(10)) + ' - LNK: '+cast(@titoliInCollegamentiCount as varchar(10)) + ' - MESI: '+cast(@mesiRicorrenza as varchar(10))
    RETURN @result
END
GO	


IF EXISTS (SELECT * FROM sys.views WHERE name = 'V_QGAP_PERSONALE_TITOLI')
DROP VIEW V_QGAP_PERSONALE_TITOLI
GO
CREATE VIEW V_QGAP_PERSONALE_TITOLI AS 
select PA.ID_DIPENDENTE, F.ID_FUNZIONE, C.ID_CESPITE as ID_TITOLO_FORMATIVO, 
PA.COGNOME, PA.NOME, F.COD_FUNZIONE, 
C.COD_CESPITE, 
CASE WHEN (SELECT ISNULL(CDOreMinime,0) FROM QGAP_CONFIGURATION) = 0 THEN ISNULL(dbo.sf_GetIntCustomData(22,ID_CESPITE,(SELECT CDOreMinime FROM QGAP_CONFIGURATION)),0) ELSE ISNULL(dbo.sf_GetFloatCustomData(22,ID_CESPITE,(SELECT CDOreMinime FROM QGAP_CONFIGURATION)),0) END AS OreMinime, isnull(dbo.sf_GetIntCustomData(22,ID_CESPITE,(select CDEntroNGg from QGAP_CONFIGURATION)),0) as entroNGiorni, isnull(dbo.sf_GetIntCustomData(22,ID_CESPITE,(select CDRicorrenza from QGAP_CONFIGURATION)),0) as ricorrenza, 
dbo.sf_QGAP_getTipoTitolo (C.ID_CESPITE) as TipoTitolo, 
case dbo.sf_QGAP_getTipoTitolo (C.ID_CESPITE) 
when -1 then 'N/A' 
when 0 then 'iniziale' 
when 1 then 'aggiornamento' 
when 2 then 'unico' 
when 3 then 'periodico' 
else 'N/A' end as TipoTitoloDecoded 
from EVA_REFERENCES R 
join MSQ_FUNZIONI F ON ID_FUNZIONE= R.ID_FOR_ALL 
JOIN CES_ANAGRAFICA C on ID_CESPITE = R.ID_EVENTO 
join MSQ_PERS_FUNZIONI PF oN PF.ID_FUNZIONE = F.ID_FUNZIONE 
inner JOIN PER_ANAGRAFICA PA ON PA.ID_DIPENDENTE = PF.ID_DIPENDENTE
where ID_EVA_REFERENCE_TYPES = (select RifTitoloFunzione from QGAP_CONFIGURATION)
and ID_CESPITE_PADRE = (select IDCespitePadreTF from QGAP_CONFIGURATION)
GO