-- 1. sf_QGAP_getMatchingTitoloIniziale stored function created to find TitoloIniziale for given TitoloAggiornamento and function
-- 2. V_QGAP_PERSONALE_TITOLI modified to use sf_QGAP_getMatchingTitoloIniziale

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF object_id(N'sf_QGAP_getMatchingTitoloIniziale', N'FN') IS NOT NULL
    DROP FUNCTION sf_QGAP_getMatchingTitoloIniziale
GO
CREATE FUNCTION [dbo].[sf_QGAP_getMatchingTitoloIniziale] (@ID_CESPITE INT,@ID_FUNZIONE INT)
RETURNS INT
AS
BEGIN
DECLARE @RESULT INT
-- Get TF Iniziale only in case when passed TF is aggornamento
if dbo.sf_QGAP_getTipoTitolo(@ID_CESPITE) = 1
BEGIN

	DECLARE @RifTitoloFunzione INT
	DECLARE @RifTFIniziale INT
	DECLARE @IdFunzione INT
	--IDCespite of TF agg
	DECLARE @IdTFAgg INT

	set @IdTFAgg = @ID_CESPITE
	set @IdFunzione = @ID_FUNZIONE
	
	select @RifTitoloFunzione = RifTitoloFunzione from QGAP_CONFIGURATION
	select @RifTFIniziale = RifTFIniziale from QGAP_CONFIGURATION

	SET @RESULT = (
	--get TOP 1st record only because if GAP db does have wrong configuration of TF/functions it might result multiple records
	SELECT DISTINCT TOP 1
	ERF_TF_INIZ.ID_EVENTO 
	FROM 
	CES_ANAGRAFICA CA 
	INNER JOIN
	EVA_REFERENCES ER ON ER.ID_EVENTO= CA.ID_CESPITE AND ER.ID_EVA_REFERENCE_TYPES= @RifTitoloFunzione AND ER.ID_FOR_ALL=@IdFunzione
	INNER JOIN
	EVA_REFERENCES ERF_TF_INIZ ON ERF_TF_INIZ.ID_FOR_ALL = ER.ID_FOR_ALL 
	AND ERF_TF_INIZ.ID_EVA_REFERENCE_TYPES =@RifTitoloFunzione AND ERF_TF_INIZ.ID_EVENTO <> @IdTFAgg
	INNER JOIN
	CES_ANAGRAFICA CA_INIZ  ON CA_INIZ.ID_CESPITE = ERF_TF_INIZ.ID_EVENTO
	AND 
	ERF_TF_INIZ.ID_EVENTO IN 
	(
		SELECT ER.ID_FOR_ALL FROM EVA_REFERENCES ER
		INNER JOIN CES_ANAGRAFICA CA ON CA.ID_CESPITE = ER.ID_EVENTO
		AND CA.ID_CESPITE = @IdTFAgg
		AND ER.ID_EVA_REFERENCE_TYPES = @RifTFIniziale
	)
	WHERE
	CA.ID_CESPITE=@IdTFAgg 
)
END
RETURN @result
END

GO


