-- 1. sf_QGAP_getMatchingTitoloIniziale stored function created to find TitoloIniziale for given TitoloAggiornamento and function
-- 2. V_QGAP_PERSONALE_TITOLI modified to use sf_QGAP_getMatchingTitoloIniziale

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

IF object_id(N'sf_QGAP_getMatchingTitoloIniziale', N'FN') IS NOT NULL
    DROP FUNCTION sf_QGAP_getMatchingTitoloIniziale
GO
CREATE FUNCTION [dbo].[sf_QGAP_getMatchingTitoloIniziale] (@ID_CESPITE INT,@ID_FUNZIONE INT)
RETURNS INT
AS
BEGIN
DECLARE @RESULT INT
-- Get TF Iniziale only in case when passed TF is aggornamento
if dbo.sf_QGAP_getTipoTitolo(@ID_CESPITE) = 1
BEGIN

	DECLARE @RifTitoloFunzione INT
	DECLARE @IdFunzione INT
	--IDCespite of TF agg
	DECLARE @IdTFAgg INT

	set @IdTFAgg = @ID_CESPITE
	set @IdFunzione = @ID_FUNZIONE
	select @RifTitoloFunzione = RifTitoloFunzione from QGAP_CONFIGURATION

	SET @RESULT = (
	--get TOP 1st record only because if GAP db does have wrong configuration of TF/functions it might result multiple records
	SELECT DISTINCT TOP 1
	ERF_TF_INIZ.ID_EVENTO 
	FROM 
	CES_ANAGRAFICA CA 
	INNER JOIN
	EVA_REFERENCES ER ON ER.ID_EVENTO= CA.ID_CESPITE AND ER.ID_EVA_REFERENCE_TYPES= @RifTitoloFunzione AND ER.ID_FOR_ALL=@IdFunzione
	INNER JOIN
	EVA_REFERENCES ERF_TF_INIZ ON ERF_TF_INIZ.ID_FOR_ALL = ER.ID_FOR_ALL 
	AND ERF_TF_INIZ.ID_EVA_REFERENCE_TYPES =@RifTitoloFunzione AND ERF_TF_INIZ.ID_EVENTO <> @IdTFAgg
	INNER JOIN
	CES_ANAGRAFICA CA_INIZ  ON CA_INIZ.ID_CESPITE = ERF_TF_INIZ.ID_EVENTO
	WHERE
	CA.ID_CESPITE=@IdTFAgg
)
END
RETURN @result
END

GO


/****** Object:  View [dbo].[V_QGAP_PERSONALE_TITOLI]    Script Date: 10/1/2024 4:23:35 PM ******/

IF object_id(N'V_QGAP_PERSONALE_TITOLI', N'V') IS NOT NULL
    DROP VIEW V_QGAP_PERSONALE_TITOLI

GO

/****** Object:  View [dbo].[V_QGAP_PERSONALE_TITOLI]    Script Date: 10/1/2024 4:23:35 PM ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE VIEW [dbo].[V_QGAP_PERSONALE_TITOLI] AS 
SELECT PA.ID_DIPENDENTE, F.ID_FUNZIONE, C.ID_CESPITE AS ID_TITOLO_FORMATIVO, PA.COGNOME, PA.NOME, F.COD_FUNZIONE, C.COD_CESPITE, CASE WHEN
                      (SELECT ISNULL(CDOreMinime, 0)
                       FROM      QGAP_CONFIGURATION) = 0 THEN ISNULL(dbo.sf_GetIntCustomData(22, ID_CESPITE,
                      (SELECT CDOreMinime
                       FROM      QGAP_CONFIGURATION)), 0) ELSE ISNULL(dbo.sf_GetFloatCustomData(22, ID_CESPITE,
                      (SELECT CDOreMinime
                       FROM      QGAP_CONFIGURATION)), 0) END AS OreMinime, ISNULL(dbo.sf_GetIntCustomData(22, C.ID_CESPITE,
                      (SELECT CDEntroNGg
                       FROM      dbo.QGAP_CONFIGURATION)), 0) AS entroNGiorni, ISNULL(dbo.sf_GetIntCustomData(22, C.ID_CESPITE,
                      (SELECT CDRicorrenza
                       FROM      dbo.QGAP_CONFIGURATION)), 0) AS ricorrenza, dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) AS TipoTitolo, 
					   
					   CASE WHEN
                      ((SELECT LEFT(ISNULL(dbo.sf_GetComboCustomData(22, ID_CESPITE,
                                              (SELECT CDMetodoDiCalcolo
                                               FROM      QGAP_CONFIGURATION)), '0'), 1)
                        FROM      QGAP_CONFIGURATION) = '0') AND dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) = 1 THEN 'daFormIniz' WHEN
                      ((SELECT LEFT(ISNULL(dbo.sf_GetComboCustomData(22, ID_CESPITE,
                                              (SELECT CDMetodoDiCalcolo
                                               FROM      QGAP_CONFIGURATION)), '0'), 1)
                        FROM      QGAP_CONFIGURATION) = '1') AND dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) = 1 THEN 'daUltAgg' ELSE NULL END AS dettaglioAggiornamento
  					   ,dbo.sf_QGAP_getMatchingTitoloIniziale(C.ID_CESPITE,F.ID_FUNZIONE)  AS idTitoloIniziale,

						CASE dbo.sf_QGAP_getTipoTitolo(C.ID_CESPITE) 
                  WHEN - 1 THEN 'N/A' WHEN 0 THEN 'iniziale' WHEN 1 THEN 'aggiornamento' WHEN 2 THEN 'unico' WHEN 3 THEN 'periodico' ELSE 'N/A' END AS TipoTitoloDecoded
FROM     dbo.EVA_REFERENCES AS R INNER JOIN
                  dbo.MSQ_FUNZIONI AS F ON F.ID_FUNZIONE = R.ID_FOR_ALL INNER JOIN
                  dbo.CES_ANAGRAFICA AS C ON C.ID_CESPITE = R.ID_EVENTO INNER JOIN
                  dbo.MSQ_PERS_FUNZIONI AS PF ON PF.ID_FUNZIONE = F.ID_FUNZIONE INNER JOIN
                  dbo.PER_ANAGRAFICA AS PA ON PA.ID_DIPENDENTE = PF.ID_DIPENDENTE
WHERE  (R.ID_EVA_REFERENCE_TYPES =
                      (SELECT RifTitoloFunzione
                       FROM      dbo.QGAP_CONFIGURATION)) AND (C.ID_CESPITE_PADRE =
                      (SELECT IDCespitePadreTF
                       FROM      dbo.QGAP_CONFIGURATION))
GO



