create table ZZ_OBJECTS
(
  I_OBJECT char(36) not null,
  P_OBJECT char(36),
  TYPE     char(1),
  ATTRIB   varchar(10),
  IDENT    varchar(128),
  R_OBJECT varchar(36)
) ;
alter table ZZ_OBJECTS add primary key (I_OBJECT) ;
--
-- Intrinsic Field Transformation Stored Functions
--
create or replace function GetTDC(p_SRCVALUE character varying, p_TRANSFORMATI integer, p_FORMAT character varying, p_OFFSET integer, p_LENGHT integer)
returns character varying as $$
begin
  if p_TRANSFORMATI = 2 then
    return TRIM(p_SRCVALUE);
  elsif p_TRANSFORMATI = 3 then
    return SUBSTRING(p_SRCVALUE, p_OFFSET, p_LENGHT);
  end if;
  return p_SRCVALUE;
end;
$$ language plpgsql ;
--
--CC Building Gap Results table
--NC 2
--
 drop table GAPRESULTS cascade ;
create table GAPRESULTS
(
  GAPRESULTID          char(20)        not null,
  GAPRESULIDTF         varchar(20)     not null,
  GAPRESUIDEMP         varchar(20)     not null,
  GAPRESLASDAT         timestamp      ,
  GAPRESNEXDAT         timestamp      ,
  GAPRESULSTAT         integer         not null,
  GAPRESULHOUR         double precision  not null,
  GAPRESPROHOU         double precision  not null,
  GAPRESMISHOU         double precision  not null,
  GAPRESEXPDAT         timestamp      ,
  GAPRESULNOTE         varchar(50)    ,
  GAPRESUIDFUN         varchar(20)    
) ;
alter table GAPRESULTS add constraint GAPRESULTS_PK primary key (GAPRESULTID) ;
delete from ZZ_OBJECTS where I_OBJECT='8953D63C-FE83-4331-BD3C-251FC289EACA' ;
delete from ZZ_OBJECTS where P_OBJECT='8953D63C-FE83-4331-BD3C-251FC289EACA' ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('8953D63C-FE83-4331-BD3C-251FC289EACA', 'CFCFDB5C-E8BB-4D3F-A022-164EC589B01C', 'T', '', 'GAPRESULTS', '') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('3DA7FB1B-7609-4205-8C98-16A33F7EB430', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'YN120020NN', 'GAPRESULTID', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('9616E306-1303-4A8B-951F-8FFF66641A66', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN050020NN', 'GAPRESULIDTF', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('B41C30A7-5C56-4A22-80A9-DB851AEB2C8D', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN050020NN', 'GAPRESUIDEMP', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('9E3888D8-3408-4DF3-BDC4-C1764C962A3E', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NY060010NN', 'GAPRESLASDAT', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('B4EB3203-5A88-49B0-8366-E0EFA0EE583B', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NY060010NN', 'GAPRESNEXDAT', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('2AD6EEB0-9834-4A98-9746-8F1FCE682C3F', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN010009NN', 'GAPRESULSTAT', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('3BCCEB5C-7F42-4764-9AF7-1D155C25504E', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN020009NN', 'GAPRESULHOUR', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('12B09D24-B476-446E-8D4C-5CD12A0A3966', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN020009NN', 'GAPRESPROHOU', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('CED373B8-9A80-4332-882C-BC40642ACF32', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NN020009NN', 'GAPRESMISHOU', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('A0330C27-09CB-47F6-9C63-0DF04B4FB417', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NY060010NN', 'GAPRESEXPDAT', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('B15E7CB3-1B76-4BED-BC53-1C7041996675', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NY050050NN', 'GAPRESULNOTE', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('492EC4C6-8AA8-4F89-8015-810513075E3E', '8953D63C-FE83-4331-BD3C-251FC289EACA', 'F', 'NY050020NN', 'GAPRESUIDFUN', '000000000000000000') ;
--
--CC Building Periods table
--NC 3
--
 drop table PERIODS cascade ;
create table PERIODS
(
  PERIODID             char(20)        not null,
  PERIGAPRESID         char(20)        not null,
  PERIODSEQUEN         integer         not null,
  PERIODSTATUS         integer         not null,
  PERISTARDATE         timestamp      ,
  PERIOENDDATE         timestamp      ,
  PERIODHOURS          double precision  not null
) ;
alter table PERIODS add constraint PERIODS_PK primary key (PERIODID) ;
delete from ZZ_OBJECTS where I_OBJECT='B3A37CAC-1DE6-4A74-926A-A25727968DB9' ;
delete from ZZ_OBJECTS where P_OBJECT='B3A37CAC-1DE6-4A74-926A-A25727968DB9' ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'CFCFDB5C-E8BB-4D3F-A022-164EC589B01C', 'T', '', 'PERIODS', '') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('C83D7FF3-A862-4AA3-BC33-673CE31C1256', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'YN120020NN', 'PERIODID', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('F8E65BC1-FE2D-42FC-955D-C56CEE0AB251', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NN120020NN', 'PERIGAPRESID', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('02FBFCE0-53B9-473A-9B3C-C5432D352D49', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NN010009NN', 'PERIODSEQUEN', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('8AE25FF9-F5BC-4D14-AD8D-AB36A1A99F21', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NN010009NN', 'PERIODSTATUS', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('EA225E67-BE58-4589-A00D-F19106C1C67A', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NY060010NN', 'PERISTARDATE', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('FCD66796-B8B6-49F5-844B-B6449E318E06', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NY060010NN', 'PERIOENDDATE', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('FB7EB950-76AF-477E-B400-C48CA1D6822F', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'F', 'NN020009NN', 'PERIODHOURS', '000000000000000000') ;
--
--CC Building Settings table
--NC 4
--
 drop table SETTINGS cascade ;
create table SETTINGS
(
  SETTINGID            varchar(20)     not null,
  SETTCALCFREQ         integer         default 60 not null,
  SETTLASTCALC         timestamp      ,
  SETALLPETFME         integer         default 0 not null,
  SETTALLOCOVE         integer         default 0 not null,
  SETDISEMPTYP         integer         default 0 not null,
  SETDISCODFUN         integer         default 0 not null,
  SETTDISCODTF         integer         default 0 not null
) ;
alter table SETTINGS add constraint SETTINGS_PK primary key (SETTINGID) ;
delete from ZZ_OBJECTS where I_OBJECT='45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D' ;
delete from ZZ_OBJECTS where P_OBJECT='45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D' ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'CFCFDB5C-E8BB-4D3F-A022-164EC589B01C', 'T', '', 'SETTINGS', '') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('8F7C9331-5614-40B1-91F0-DC498DF4BED4', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'YN050020NN', 'SETTINGID', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('9EEA6069-C5AB-425F-AEF1-2BF578AB505C', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETTCALCFREQ', '000030360000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('11EA582C-22B5-4415-849B-AFD8A6B80416', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NY080016NN', 'SETTLASTCALC', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('4255378F-13A7-4460-A093-927B93FFDEA1', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETALLPETFME', '000000300000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('724379D0-C038-4DF0-801A-A04217DC99A2', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETTALLOCOVE', '000000300000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('236D2C30-90D0-4620-B841-0183D03A19C0', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETDISEMPTYP', '000000300000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('772AC884-7D49-445D-9B70-346CFA48DAAF', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETDISCODFUN', '000000300000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('17F98CE7-B033-4388-A469-CDF361023C1F', '45176AF4-D6A5-4E7E-8CA0-AC8630F8D64D', 'F', 'NN010009YN', 'SETTDISCODTF', '000000300000000000') ;
--
--CC Building Covering Tfs table
--NC 5
--
 drop table COVERINGTFS cascade ;
create table COVERINGTFS
(
  COVERINGTFID         char(20)        not null,
  IDCOVERINGTF         varchar(20)     not null,
  COVEIDCOVETF         varchar(20)     not null
) ;
alter table COVERINGTFS add constraint COVERINGTFS_PK primary key (COVERINGTFID) ;
delete from ZZ_OBJECTS where I_OBJECT='D9A6EF91-847C-4A5C-892A-C08BD0FF696D' ;
delete from ZZ_OBJECTS where P_OBJECT='D9A6EF91-847C-4A5C-892A-C08BD0FF696D' ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('D9A6EF91-847C-4A5C-892A-C08BD0FF696D', 'CFCFDB5C-E8BB-4D3F-A022-164EC589B01C', 'T', '', 'COVERINGTFS', '') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('2C001529-25E6-48ED-9029-E6D6594FC265', 'D9A6EF91-847C-4A5C-892A-C08BD0FF696D', 'F', 'YN120020NN', 'COVERINGTFID', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('557507E0-FFA6-41F3-AEAE-3897D2590302', 'D9A6EF91-847C-4A5C-892A-C08BD0FF696D', 'F', 'NN050020NN', 'IDCOVERINGTF', '000000000000000000') ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('687850EA-A926-4659-AB89-557D7961367E', 'D9A6EF91-847C-4A5C-892A-C08BD0FF696D', 'F', 'NN050020NN', 'COVEIDCOVETF', '000000000000000000') ;
--
--FF Building foreign keys...
--NT 1
--
--CC Building Periods - Gap Result foreign key
--NC 1
--
alter table PERIODS add constraint PERIOGAPRESU foreign key (PERIGAPRESID) references GAPRESULTS (GAPRESULTID) on delete cascade ;
insert into ZZ_OBJECTS (I_OBJECT, P_OBJECT, TYPE, ATTRIB, IDENT, R_OBJECT) values ('895D543E-5CFD-4395-B259-B324F4765222', 'B3A37CAC-1DE6-4A74-926A-A25727968DB9', 'L', '21N', 'PERIOGAPRESU', '8953D63C-FE83-4331-BD3C-251FC289EACA') ;
delete from periods;
delete from gapresults;
alter table GAPRESULTS alter column GAPRESULIDTF type integer USING GAPRESULIDTF :: integer;
update ZZ_OBJECTS set ATTRIB='NN010020NN',R_OBJECT='000000000000000000' where I_OBJECT='9616E306-1303-4A8B-951F-8FFF66641A66' ;
alter table GAPRESULTS alter column GAPRESUIDEMP type integer USING GAPRESUIDEMP :: integer;
update ZZ_OBJECTS set ATTRIB='NN010020NN',R_OBJECT='000000000000000000' where I_OBJECT='B41C30A7-5C56-4A22-80A9-DB851AEB2C8D' ;
alter table GAPRESULTS alter column GAPRESUIDFUN type integer USING GAPRESUIDFUN :: integer;
update ZZ_OBJECTS set ATTRIB='NY010020NN',R_OBJECT='000000000000000000' where I_OBJECT='492EC4C6-8AA8-4F89-8015-810513075E3E' ;
