// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PopupDelay: Implementa la finestra
// di attesa
// Estende PopupFrame
// ************************************************

function PopupDelay()
{
  this.MessageText = RD3_ServerParams.DelayDefaultMessage; // Il testo del messaggio da mostrare
  this.Progress = 0;                    // Intero da 0 a 100 che indica la percentuale di completamento
                                        // (se il tipo e' delay viene impostato autometicamente, se e' progress cambiando questo valore
                                        // cambia la lunghezza della linea)
  this.Total = -1;                      // Valore totale della progress bar calcolata dal server: serve per poter impostare il progresso in percentuale                                        
  this.Present = -1;                    // Valore attuale della progress bar impostata dal server: serve per calcolare il valore percentuale
  this.CanAbort = false;                // Mostrare o meno il pulsante di abort?
  this.DelayType = RD3_Glb.DELAY;       // 0 - delay 1 - progress
  //
  this.Identifier = "DELAY" + Math.floor(Math.random() * 100);  // Identificatore per gestire il timer
                                                                // (ci puo' essere un solo PopupDelay per volta, basterebbe anche una stringa fissa per identificatore)
  // Altre variabili di questo oggetto di modello
  this.Opened = false;
  this.Hidden = false;  // Per le delay a doppia comparsa indica se sono aperte ma ancora invisibili
  //
  // Elementi visuali della PopupDelay
  this.ProgressBoxContainer = null;  // Div che contiene tutta la progress bar
  this.ProgressBox = null;           // Div che lo stato si avanzamento
  this.InnerProgress = null;         // Div interno della progress Bar
  this.AbortButton = null;           // Pulsante di abort per le operazioni interrompibili
  //
  // Altre variabili di questo oggetto
  this.ProgressTimer = null;      // Timer per gestire il controllo di progresso lato server
  this.XmlReq = null;             // Oggetto che gestisce la richiesta al server del file XML
}
// Definisco l'estensione della classe
PopupDelay.prototype = new PopupFrame();


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// ***************************************************************
PopupDelay.prototype.Realize = function()
{
  // Impostazioni iniziali 
  this.Centered = true;
  this.Modal = true;
  this.HasCaption = false;
  this.CanMove = true;
  this.CanResize = false;
  this.Height = 0;
  this.Width = 0;
  //
  // Chiamo la classe base
  PopupFrame.prototype.Realize.call(this,"-message-box");
  RD3_Glb.AddClass(this.PopupDialog, "popup-delay-modal-dialog");
  //
  // Crea la progress bar esterna
  this.ProgressBoxContainer = document.createElement("div");
  this.ProgressBoxContainer.className = "progress";
  //
  this.ProgressBox = document.createElement("div");
  this.ProgressBox.className = "progress-bar";
  //
  // Crea l'header ed il titolo per il messaggio della Progress, facendoli partire nascosti
  this.Header = document.createElement("div");
  this.Header.className = "modal-header";
  this.Header.style.display = "none";
  this.HeaderTitle = document.createElement("h4");
  this.HeaderTitle.className = "modal-title";
  this.Header.appendChild(this.HeaderTitle);
  //
  // Crea il footer in cui mettere il pulsante di annullamento
  this.Footer = document.createElement("div");
  this.Footer.className = "modal-footer";
  //
  // Crea il pulsante di annullamento
  this.AbortButton = document.createElement("button");
  this.AbortButton.textContent = ClientMessages.MSG_POPUP_CancelButton;
  this.AbortButton.className = "btn btn-default";
  this.AbortButton.onclick = function(ev) {
    this.Abort(ev);
  }.bind(this);
  this.Footer.appendChild(this.AbortButton);
  //
  // Inserisce gli elementi nel DOM
  this.ProgressBoxContainer.appendChild(this.ProgressBox);
  this.ContentBox.appendChild(this.ProgressBoxContainer);
  this.PopupContent.appendChild(this.Footer);
  this.PopupContent.insertBefore(this.Header, this.PopupContent.firstChild);
  //
  // Impostazioni iniziali
  this.SetType();
  this.SetText();
  this.SetCanAbort();
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PopupDelay.prototype.Unrealize = function()
{
  if (this.Realized)
  {
    // Chiamo la classe base
    PopupFrame.prototype.Unrealize.call(this);  
    //
    // Cancello i riferimenti al DOM      
    this.ProgressBox = null;
  }
}

// ***************************************************
// Dimensiono la Box in base al contenuto
// ***************************************************
PopupDelay.prototype.AdaptLayout = function()
{
}


// ********************************************************************************
// Realizza e mostra a video questa popup
// side: 0 lato client, 1 o undefined lato server (usato solo per tipo delay,
// indica se deve andare sul server a verificare se gli e' stato richiesto di diventare
// una progress bar)
// ********************************************************************************
PopupDelay.prototype.Open = function(text, type, side)
{ 
  if (text!=undefined)
    this.SetText(text);
  if (type!=undefined)
    this.SetType(type);
  //
  if (!side)
    side = 1;
  //
  // Chiamo la classe base
  PopupFrame.prototype.Open.call(this);  
  //
  this.PopupBox.style.display = "";
  //
  // Delay Dialog: se non e' attivo attivo il timer di aggiornamento
  if (this.DelayType == RD3_Glb.DELAY)
  {
    // Attivo il timer per controllare se il server ha richiesto che diventi una progress bar
    if (side == 1)
      this.ProgressTimer = window.setTimeout(function() {
        this.RefreshProgressBar();
      }.bind(this), 500);
  }
  //
  this.Opened = true;
}


// ********************************************************************************
// Chiude la finestra
// ********************************************************************************
PopupDelay.prototype.Close = function()
{ 
  if (!this.Realized)
    return;
  //
  if (this.ProgressTimer)
  {
    clearTimeout(this.ProgressTimer);
    this.ProgressTimer = null;
  }
  //
  if (this.DelayShowTimer)
  {
    clearTimeout(this.DelayShowTimer);
    this.DelayShowTimer = null;
  }
  //
  // Svuoto la progress bar
  this.SetProgress(0);
  this.SetCanAbort(false);
  this.SetTotal(-1);
  this.SetPresent(-1);
  //
  // Chiamo la classe base
  PopupFrame.prototype.Close.call(this);
}


// ********************************************************************************
// Cambia il valore del testo del messaggio
// ********************************************************************************
PopupDelay.prototype.SetText = function(value)
{ 
  if (value != undefined)
    this.MessageText = value;
  //
  if (this.Realized)
  {
    var txt = this.MessageText;
    if (!txt || txt == "")
      txt = RD3_ServerParams.DelayDefaultMessage;
    //
    if (this.DelayType == RD3_Glb.DELAY) {
      this.ProgressBox.textContent = txt;
    }
    else {
      this.HeaderTitle.textContent = txt;
      this.ProgressBox.textContent = "";
    }
  }
}


// ********************************************************************************
// Imposta il tipo di delay: delay pura o progress bar
// ********************************************************************************
PopupDelay.prototype.SetType = function(value)
{ 
  if (value != undefined)
    this.DelayType = value;
  //
  if (this.Realized)
  {
    if (this.DelayType == RD3_Glb.DELAY)
    {
      this.Header.style.display = "none";
      this.ProgressBox.className = "progress-bar progress-bar-striped active";
      this.SetProgress(100);
    }
    else
    {
      this.Header.style.display = "";
      this.ProgressBox.className = "progress-bar";
      //
      // Azzero la progress bar
      this.SetProgress(0);
    }
  }
}


// ********************************************************************************
// Imposta il livello di progresso e se necessario aggiorna la visualizzazione
// Value e' la percentuale di completamento (intero da 0 a 100)
// ********************************************************************************
PopupDelay.prototype.SetProgress = function(value)
{ 
  // Aggiorno il valore del conteggio (se e' > 100 faccio il modulo)
  this.Progress = value>100 ? value%100 : value;
  // 
  // Allargo il div rappresentante lo stato di avanzamento
  this.ProgressBox.style.width = this.Progress + "%";
}


PopupDelay.prototype.SetTotal = function(value)
{ 
  this.Total = value;
}

PopupDelay.prototype.SetPresent = function(value)
{ 
  this.Present = value;
}

PopupDelay.prototype.SetCanAbort = function(value)
{ 
  if (value != undefined)
    this.CanAbort = value;
  //
  if (this.Realized) {
    this.Footer.style.display = this.CanAbort ? "" : "none";
  }
}


// ********************************************************************************
// Metodo chiamato per verificare la presenza sul server del file necessario per le
// operazioni interrompibili
// ********************************************************************************
PopupDelay.prototype.RefreshProgressBar = function()
{ 
  this.ProgressTimer = null;
  //
  if (window.RD4_Enabled)
    this.ProcessRequestChange();
  else
  {
    // Verifico la presenza del file XML facendo una richiesta
    this.XmlReq = RD3_DesktopManager.MessagePump.CreateRequest();
    //
    this.XmlReq.onreadystatechange = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'ProcessRequestChange', ev)");
    //
    // Invio la richiesta
    if (this.XmlReq.overrideMimeType)
      this.XmlReq.overrideMimeType('text/xml');
    this.XmlReq.open("GET", "temp/" + RD3_DesktopManager.WebEntryPoint.ProgressBarFile + "?NOCACHE=" + Math.random(), true);
    this.XmlReq.send("");
  }
}

// ********************************************************************************
// Metodo che scatta alla risposta da parte del server della lettura del file xml
// ********************************************************************************
PopupDelay.prototype.ProcessRequestChange = function()
{
  var ok = false;
  if (window.RD4_Enabled)
  { 
    ok = true;
    if (RD4_ApplicationManager.progress)
    {
      this.SetPresent(RD4_ApplicationManager.progress.present);
      this.SetTotal(RD4_ApplicationManager.progress.total);
      this.SetCanAbort(RD4_ApplicationManager.progress.canAbort);
      this.SetText(RD4_ApplicationManager.progress.message);
    }
  }
  else
  {
    // only if req shows "loaded"
    if (this.XmlReq.readyState == 4)
    {
      // only if "OK"
      if (this.XmlReq.status == 200)
      {
        // IE PATCH
        if (this.XmlReq.responseXML.childNodes.length==0 && document.all)
        {
          // IE non carica bene il documento XML se il server
          // non invia ContentType=text/xml... e a volte non succede!!!
          var xml = this.XmlReq.responseText;
          if (xml.indexOf("\n")!=-1)
            xml = xml.substring(xml.indexOf("\n")+1);
          this.XmlReq.responseXML.loadXML(xml);
        }
        //
        var xmlDoc = this.XmlReq.responseXML;
        this.ParseXML(xmlDoc);
        ok = true;
      }
      else
      {
        // alert("There was a problem retrieving the XML data:\n" + req.statusText);
        this.ProgressTimer = null;
      }
    }
  }
  //
  if (ok)
  {
    // Se non sono una progress bar lo divento
    if (this.DelayType != RD3_Glb.PROGRESS) {
      this.SetType(RD3_Glb.PROGRESS);
      if (this.MessageText != "")
        this.SetText();
    }
    //
    // Imposto il progresso percentuale
    this.SetProgress((this.Present/this.Total)*100);
    //
    // Rieffettuo la chiamata al server se sono ancora aperto
    if (this.Realized)
      this.ProgressTimer = window.setTimeout(function() {
        this.RefreshProgressBar();
      }.bind(this), 2000);
  }
}

// ********************************************************************************
// Metodo che elabora il file XML letto dal server
// ********************************************************************************
PopupDelay.prototype.ParseXML = function(xmldoc)
{ 
  var xmlNode = null;
  if (xmldoc.childNodes.length > 0)
  {
    xmlNode = xmldoc.childNodes[xmldoc.childNodes.length-1];
    for (var i=0; i<xmlNode.childNodes.length; i++)
    {
      var k = xmlNode.childNodes[i];
      switch (k.nodeName)
      {
        case "PRESENT":  this.SetPresent(parseInt(k.firstChild.nodeValue)); break;
        case "TOTAL":    this.SetTotal(parseInt(k.firstChild.nodeValue)); break;
        case "CANABORT": this.SetCanAbort(k.firstChild.nodeValue == "-1"); break;
        case "MESSAGE":  this.SetText(k.firstChild == null ? "" : k.firstChild.nodeValue); break;
      }
    }
  }
}


// ********************************************************
// Annulla l'operazione in corso
// ********************************************************
PopupDelay.prototype.Abort = function()
{
  // Se sto mostrando l'avanzamento di un upload
  if (this.FlashUploading)
  {
    // Disabilito il pulsante di abort
    this.AbortButton.disabled = true;
    //
    // Fermo il caricamento del file in corso
    this.FlashUploading.cancelUpload();
    //
    return;
  }
  //
  if (confirm(ClientMessages.DLG_DELAY_Abort))
  {
    // Disabilito il pulsante di abort
    this.AbortButton.disabled = true;
    //
    if (window.RD4_Enabled)
    {
      try
      {
        if (Shell.UseShellForSS())
          Shell.SendSSCmd("", "SetProgress", { aborted: true });
        else
        {
          var SSDBName = "SSManager";
          var db = openDatabase(SSDBName, "", SSDBName, 5*1024*1024);
          var SQL = "UPDATE Sessions SET Aborted = -1 WHERE SessionName = ''";
          try
          {
            db.transaction(function(tr) {tr.executeSql(SQL)});
          }
          catch (e)
          {
            throw e;
          }
          finally
          {
            if (db && db.close)
              db.close();
          }
        }
      }
      catch (e)
      {
        WriteToConsole("Error while aborting progress of main session", "error");
      }
    }
    else
    {
      var prfile = RD3_DesktopManager.WebEntryPoint.ProgressBarFile;
      var server = RD3_DesktopManager.WebEntryPoint.EntryPoint;
      //
      var flCSharp = (server.indexOf(".aspx")>0);
      if (flCSharp)
        server = "D_"+server;
      //
      this.XmlReq = RD3_DesktopManager.MessagePump.CreateRequest();
      this.XmlReq.open("GET", server + "?FN=" + prfile.substring(0, prfile.length-4) + "&NOCACHE=" + Math.floor(Math.random() * 1000000), true);
      this.XmlReq.send("");
    }
    //
    // Fermo un eventuale altra richiesta in coda
    if (this.ProgressTimer)
      window.clearTimeout(this.ProgressTimer);
  }
}

//**************************************************************************
// Attivo o meno la delay a doppio tocco
//**************************************************************************
PopupDelay.prototype.UseDoubleMode = function(ev)
{
  return false;
}

//************************************************************************************
// Click sul modal box in versione doppio tocco: devo far comparire la vera progress
//************************************************************************************
PopupDelay.prototype.OnModalMouseDown = function(ev)
{
}