// ****************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PGroup: Rappresenta un gruppo di campi 
// ***************************************************

function PGroup(ppanel)
{
  // Proprieta' di questo oggetto di modello
  this.VisualStyle = -1;                // Visual Style associato al gruppo (-1: vedi il padre)
  this.Flags = 0;                       // Flag del gruppo
  this.Image = "";                      // Immagine di sfondo associata al gruppo
  this.Header = "";                     // Caption del gruppo
  this.Tooltip = "";                    // Tooltip del gruppo
  this.ListLeft = 0;                    // Posizione nella lista
  this.ListTop = 0;                     // Posizione nella lista (<0 per un gruppo in lista)
  this.ListWidth = 0;                   // Dimensione nella lista
  this.ListHeight = 0;                  // Dimensione nella lista
  this.FormLeft = 0;                    // Posizione in dettaglio
  this.FormTop = 0;                     // Posizione in dettaglio
  this.FormWidth = 0;                   // Dimensione in dettaglio
  this.FormHeight = 0;                  // Dimensione in dettaglio
  this.Page = 0;                        // Pagina a cui appartiene il gruppo
  this.ListHeaderPos = 0;               // Posizione dell'header rispetto alla riga del gruppo in lista
  this.FormHeaderPos = 0;               // Posizione dell'header rispetto alla riga del gruppo in dettaglio
  this.HeaderHeight = 0;                // Altezza dell'Header
  this.HeaderWidth = 0;                 // Larghezza dell'Header
  this.InList = false;                  // Gruppo formato da soli campi in lista?
  this.Identifier = "";                 // Identificatore del gruppo (univoco)
  this.ClassName = "";                  // Classe del gruppo
  //
  // Altre variabili di modello...
  this.ParentPanel = ppanel;            // L'oggetto pannello cui il gruppo appartiene
  this.IsListPositioned = false;        // True se il gruppo in lista e' stato gia' posizionato (messa a false all'inizio del calclayout del pannello)
  //
  this.Collapsible = false;             // Il gruppo e' collassabile
  this.Collapsed = false;               // Il gruppo e' collassato
  this.FormGroupsColumns = 0;               // Colonne appartenenti al gruppo
  this.ListGroupsColumns = 0;               // Colonne appartenenti al gruppo
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;                // Se vero, gli oggetti del DOM sono gia' stati creati
  //
  // Oggetti visuali relativi al gruppo
  this.FormGroupBox = null;                 // Contenitore del gruppo in form
  this.ListCaption = null;                  // Elemento Text della caption in lista
  this.ListCaptionSA = null;                // Elemento Text della caption in lista (Scrolling Area)
  this.FormCaption = null;                  // Elemento Text della caption in form
  this.FormHeader = null;                   // Span che contiene l'header del gruppo in layout form 
  this.ListCollapseButton = null;           // Immagine che contiene il pulsante del collassamento
  this.FormCollapseButton = null;           // Immagine che contiene il pulsante del collassamento
}


// *******************************************************************
// Inizializza questo PField leggendo i dati da un nodo XML
// *******************************************************************
PGroup.prototype.LoadFromXml = function(node)
{
  // Inizializzo le proprieta' locali
  this.LoadProperties(node);
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
PGroup.prototype.ChangeProperties = function(node)
{
  // Normale cambio di proprieta'
  this.LoadProperties(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
PGroup.prototype.LoadProperties = function(node)
{
  // NPQ 2092: lo stato di collassamento deve essere gestito
  // dopo aver gestito gli attributi mfl e mff;
  // in Java gli attributi vengono elencati in ordine alfabetico
  var val = node.getAttribute("col");
  if (val == "0" || val == "1")
  {
    node.removeAttribute("col");
    node.setAttribute("col", val);
  }
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "flg": this.SetFlags(parseInt(valore)); break;
      case "img": this.SetImage(valore); break;
      case "cap": this.SetHeader(valore); break;
      case "tip": this.SetTooltip(valore); break;
      case "lle": this.SetListLeft(parseInt(valore)); break;
      case "lto": this.SetListTop(parseInt(valore)); break;
      case "lwi": this.SetListWidth(parseInt(valore)); break;
      case "lhe": this.SetListHeight(parseInt(valore)); break;
      case "fle": this.SetFormLeft(parseInt(valore)); break;
      case "fto": this.SetFormTop(parseInt(valore)); break;
      case "fwi": this.SetFormWidth(parseInt(valore)); break;
      case "fhe": this.SetFormHeight(parseInt(valore)); break;
      case "pag": this.SetPage(parseInt(valore)); break;
      case "lhp": this.SetListHeaderPosition(parseInt(valore)); break;
      case "fhp": this.SetFormHeaderPosition(parseInt(valore)); break;
      case "hhe": this.SetHeaderHeight(parseInt(valore)); break;
      case "hwi": this.SetHeaderWidth(parseInt(valore)); break;
      case "inl": this.SetInlist(valore == "1"); break;
      case "sty": this.SetVisualStyle(parseInt(valore)); break;
      case "clp": this.SetCollapsible(valore == "1"); break;
      case "col": this.SetCollapsed(valore == "1"); break;
      case "mfl": this.SetListMovedFields(valore == "1"); break;
      case "mff": this.SetFormMovedFields(valore == "1"); break;
      case "cln": this.SetClassName(valore); break;
      //
      case "cla": this.CollapseAnimDef = valore; break;
      //
      case "id": 
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
      break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
PGroup.prototype.SetFlags = function(value)
{
  var old = this.Flags;
  //
  if (value != undefined)
    this.Flags = value;
  //
  if (this.Realized)
  {
    // Vediamo cosa e' cambiato
    // Controllo visibilita'
    var wasvis = old & 0x02; // OBJ_VISIBLE
    var isvis  = this.Flags & 0x02;
    //
    if (wasvis!=isvis || value==undefined)
      this.UpdateVisibility(true);
    //
    // Controllo abilitazione
    var wasena = old & 0x01; // OBJ_ENABLED
    var isena  = this.Flags & 0x01;
    //
    if (wasena!=isena || value==undefined)
      this.ParentPanel.UpdateGroupEnability(this);
  }
}

PGroup.prototype.SetImage = function(value)
{
  if (value != undefined)
    this.Image = value;
  //
  if (this.Realized)
  {
    
  }
}

PGroup.prototype.SetHeader = function(value)
{
  var old = this.Header;
  if (value != undefined)
    this.Header = value;
  //
  if (this.Realized)
  {
    if (this.FormCaption){
      if (RD3_Glb.IsIconString(this.Header))
        this.FormCaption.innerHTML = RD3_Glb.HandleIconString(this.Header);
      else
        this.FormCaption.textContent = this.Header;
    }
  }
}

PGroup.prototype.SetTooltip = function(value)
{
  if (value != undefined)
    this.Tooltip = value;
  //
  if (this.Realized) {
    if (this.FormCaption)
      RD3_TooltipManager.SetObjTitle(this.FormCaption, this.Tooltip);
  }
}

PGroup.prototype.SetListLeft = function(value)
{
  if (value != undefined)
    this.ListLeft = value;
}

PGroup.prototype.SetListTop = function(value)
{
  if (value != undefined)
    this.ListTop = value;
}

PGroup.prototype.SetListWidth = function(value)
{
  if (value != undefined)
    this.ListWidth = value;
  //
  //
  if (this.Realized && this.ListGroupBox && this.ApplyListWidth && this.myListFields && this.myListFields.length > 0)
    this.ListGroupBox.style.maxWidth = (this.ListWidth + 15 + this.ListGroupsColumns*15) + "px";  // Magic Number, padding di panel-body (ho provato a calcolarlo a run-time ma non ci sono riuscito)
}

PGroup.prototype.SetListHeight = function(value)
{
  if (value != undefined)
    this.ListHeight = value;
}

PGroup.prototype.SetFormLeft = function(value)
{
  if (value != undefined)
    this.FormLeft = value;
}

PGroup.prototype.SetFormTop = function(value)
{
  if (value != undefined)
    this.FormTop = value;
}

PGroup.prototype.SetFormWidth = function(value)
{
  if (value != undefined)
    this.FormWidth = value;
  //
  if (this.Realized && this.FormGroupBox && this.ApplyFormWidth)
    this.FormGroupBox.style.maxWidth = (this.FormWidth + 15 + this.FormGroupsColumns*15) + "px";  // Magic Number, padding di panel-body (ho provato a calcolarlo a run-time ma non ci sono riuscito)
}

PGroup.prototype.SetFormHeight = function(value)
{
  if (value != undefined)
    this.FormHeight = value;
}

PGroup.prototype.SetPage = function(value)
{
  if (value != undefined)
    this.Page = value;
  //
  if (this.Realized)
    this.UpdateVisibility(true);
}

PGroup.prototype.SetListHeaderPosition = function(value)
{
  // Non puo' cambiare a run time ed e' utilizzato nei setter delle posizioni
  if (value != undefined)
    this.ListHeaderPos = value;
}

PGroup.prototype.SetFormHeaderPosition = function(value)
{
  // Non puo' cambiare a run time
  if (value != undefined)
    this.FormHeaderPos = value;
  if (this.Realized && this.FormHeader)
    this.FormHeader.style.display = (this.FormHeaderPos == 1) ? "none" : "";
}

PGroup.prototype.SetHeaderHeight = function(value)
{
  if (value != undefined)
    this.HeaderHeight = value;
}

PGroup.prototype.SetHeaderWidth = function(value)
{
  if (value != undefined)
    this.HeaderWidth = value;
}

PGroup.prototype.SetInlist = function(value)
{
  // Questa proprieta' non puo' cambiare a runtime
  if (value != undefined)
    this.InList = value;
}

PGroup.prototype.SetVisualStyle = function(value)
{
  if (value!=undefined)
  {
    if (value.Identifier)
    {
      // Era gia' un visual style
      this.VisualStyle = value;
    }
    else
    {
      if (value != -1)
        this.VisualStyle = RD3_DesktopManager.ObjectMap["vis:"+value];
      else 
        this.VisualStyle = value;
    }
  }
  //
  if (this.Realized)
  {
   
  }
}

PGroup.prototype.SetClassName = function(value) 
{
  var oldC = this.ClassName;
  if (value!=undefined) {
    this.ClassName = value;
    //
    if (this.ClassName && this.ClassName.indexOf("{{") != -1 && this.ClassName.indexOf("}}") != -1) {
      // L'utente ha impostato una classe per la cella bootstrap, la estraggo
      var begin = this.ClassName.indexOf("{{");
      var end = this.ClassName.indexOf("}}", begin + 2);
      this.BootstrapCellClass = this.ClassName.substring(begin + 2, end);
      //
      // Rimuovo la stringa dalla classe
      this.ClassName = this.ClassName.substring(0, begin) + this.ClassName.substring(end + 2);
    }
  }
  //
  // Se e' cambiata la classe o ancora non l'ho applicata allora la applico
  if (((oldC != this.ClassName) || value == undefined) && this.Realized) 
  {
    // Rimuovo la classe precedente
    if (oldC && oldC != "")
      RD3_Glb.RemoveClass2(this.FormGroupBox, oldC);
    //
    // Applico la nuova classe
    if (this.ClassName && this.ClassName != "")
      RD3_Glb.AddClass(this.FormGroupBox, this.ClassName);
  }
}

// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
PGroup.prototype.Realize = function(parent)
{
  // NOTA: parent qui e' undefined perche' il gruppo si deve
  //       realizzare sia nel layout form (FORMBOX) che lista (LISTBOX)
  //       viene quindi usato il riferimento al padre per recuperarli
  //
  // Creo gli oggetti per la lista se presente
  this.Realizing = true;
  //
  // Prendo i riferimenti ai miei campi
  this.myFormFields = [];
  this.myListFields = [];
  var nf = this.ParentPanel.Fields.length;
  this.ApplyFormWidth = true;
  this.ApplyListWidth = true;
  for (var i = 0; i < nf; i++) {
    var f = this.ParentPanel.Fields[i];
    if (f.InForm && f.Group == this) {
      this.myFormFields.push(f);
      //
      // Se uno dei miei campi ha stretch allora il gruppo deve riempire tutta la riga a sua
      // disposizione, altrimenti lo fisso a MaxWidth pari a quella impostata a design time
      if (f.FormHResMode === RD3_Glb.RESMODE_STRETCH)
        this.ApplyFormWidth = false;
    }
    //
    if (f.InList && !f.ListList && f.Group == this) {
      this.myListFields.push(f);
      //
      // Se uno dei miei campi ha stretch allora il gruppo deve riempire tutta la riga a sua
      // disposizione, altrimenti lo fisso a MaxWidth pari a quella impostata a design time
      if (f.ListHResMode === RD3_Glb.RESMODE_STRETCH)
        this.ApplyListWidth = false;
    }
  }
  //
  // Creo gli oggetti per il dettaglio se presenti
  if (this.ParentPanel.HasForm)
  {
    this.FormGroupBox = document.createElement("div");
    this.FormGroupBox.className = "panel panel-default panel-form-pgroup";
    this.FormGroupBox.id = this.Identifier + ":fht";
    //
    this.FormHeader = document.createElement("div");
    this.FormHeader.className = "panel-heading";
    this.FormHeader.setAttribute("id", this.Identifier+":hdr");
    //
    this.FormHeaderTitle = document.createElement("h3");
    this.FormHeaderTitle.className = "panel-title";
    //
    this.FormCaption = document.createElement(this.Collapsible ? "a" : "span");
    //
    this.FormCollapseBox = document.createElement("div");
    this.FormCollapseBox.className = "collapse in";
    this.FormCollapseBox.setAttribute("id", this.Identifier+":gfcb");
    //
    this.FormCollapseBody = document.createElement("div");
    this.FormCollapseBody.className = "panel-body";
    //
    // Assegno la struttura
    this.FormGroupBox.appendChild(this.FormHeader);
    this.FormGroupBox.appendChild(this.FormCollapseBox);
    this.FormHeader.appendChild(this.FormHeaderTitle);
    this.FormHeaderTitle.appendChild(this.FormCaption);
    this.FormCollapseBox.appendChild(this.FormCollapseBody);
  }
  //
  // Se ci sono dei campi fuori lista creo gli oggetti per il loro gruppo
  if (this.ParentPanel.HasList && this.myListFields.length > 0) {
    this.ListGroupBox = document.createElement("div");
    this.ListGroupBox.className = "panel panel-default panel-form-pgroup";
    this.ListGroupBox.id = this.Identifier + ":lht";
    //
    this.ListHeader = document.createElement("div");
    this.ListHeader.className = "panel-heading";
    this.ListHeader.setAttribute("id", this.Identifier+":lhdr");
    //
    this.ListHeaderTitle = document.createElement("h3");
    this.ListHeaderTitle.className = "panel-title";
    //
    this.ListCaption = document.createElement(this.Collapsible ? "a" : "span");
    //
    this.ListCollapseBox = document.createElement("div");
    this.ListCollapseBox.className = "collapse in";
    this.ListCollapseBox.setAttribute("id", this.Identifier+":glcb");
    //
    this.ListCollapseBody = document.createElement("div");
    this.ListCollapseBody.className = "panel-body";
    //
    // Assegno la struttura
    this.ListGroupBox.appendChild(this.ListHeader);
    this.ListGroupBox.appendChild(this.ListCollapseBox);
    this.ListHeader.appendChild(this.ListHeaderTitle);
    this.ListHeaderTitle.appendChild(this.ListCaption);
    this.ListCollapseBox.appendChild(this.ListCollapseBody);
  }
  //
  this.Realized = true;
  //
  this.SetFlags(); 
  this.SetImage();
  this.SetHeader();
  this.SetTooltip(); 
  this.SetListLeft();
  this.SetListTop();
  this.SetListWidth();
  this.SetListHeight();
  this.SetFormLeft();
  this.SetFormTop();
  this.SetFormWidth();
  this.SetFormHeight();
  this.SetPage();
  this.SetListHeaderPosition();
  this.SetFormHeaderPosition();
  this.SetHeaderHeight();
  this.SetHeaderWidth();
  this.SetInlist();
  this.SetVisualStyle();
  this.SetCollapsible();
  this.SetCollapsed();
  this.SetClassName();
  this.Realizing = false;
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PGroup.prototype.Unrealize = function()
{ 
  // Rimuovo il gruppo dal DOM
  if (this.FormGroupBox && this.FormGroupBox.parentNode)
    this.FormGroupBox.parentNode.removeChild(this.FormGroupBox);
  if (this.ListGroupBox && this.ListGroupBox.parentNode)
    this.ListGroupBox.parentNode.removeChild(this.ListGroupBox);
  //
  // Mi tolgo dalla mappa degli oggetti
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  // Elimino i riferimenti al DOM
  this.ListCaption = null;
  this.ListCaptionSA = null;
  this.ListCollapseButton = null;
  //
  this.FormGroupBox = null; 
  this.FormHeader = null;
  this.FormHeaderTitle = null;
  this.FormCaption = null;
  this.FormCollapseBox = null;
  this.FormCollapseBody = null;
  //
  this.ListGroupBox = null; 
  this.ListHeader = null;
  this.ListHeaderTitle = null;
  this.ListCaption = null;
  this.ListCollapseBox = null;
  this.ListCollapseBody = null;
  //
  this.myFormFields = null;
  this.myListFields = null;
  //
  this.Realized = false; 
}


// ********************************************************************************
// Restituisce true se questo gruppo e' visibile
// ********************************************************************************
PGroup.prototype.IsVisible = function()
{
  // Verifico se appartengo ad una pagina e la pagina e' visibile
  var vis = false;
  if (this.Page != -1)
  {
    if (this.ParentPanel.PanelPage == this.Page)
      vis = true;
    else
      vis = false;
  }
  else
    vis = true;
  //
  // Verifico la mia visibilita'
  if (vis)
  {
    // OBJ_VISIBLE = 0x2
    if ((this.Flags & 0x2) != 0)
      vis = true;
    else
      vis = false;
  }
  //
  return vis;
}


// ********************************************************************************
// Restituisce true se questo gruppo e' abilitato
// ********************************************************************************
PGroup.prototype.IsEnabled = function()
{
  return this.Flags & 0x01; // OBJ_ENABLED
}


// ********************************************************************************
// Gestisce la visibilita' del gruppo
// ********************************************************************************
PGroup.prototype.UpdateVisibility = function(updflag)
{
  // Aggiorno la visibilita' del gruppo
  var s = this.IsVisible();
  var df =  s ? "" : "none";
  //
  if (this.FormGroupBox)
    RD3_Glb.SetDisplay(this.FormGroupBox, df);
  if (this.ListGroupBox)
    RD3_Glb.SetDisplay(this.ListGroupBox, df);
  //
  // Avverto il pannello che la mia visibilita' e' cambiata
  // Sistemo anche l'abilitazione dei campi, infatti potrebbero essere rimasti
  // disabilitati perche' invisibili da sempre
  if (updflag) {
    this.ParentPanel.UpdateGroupVisibility(this);
    this.ParentPanel.UpdateGroupEnability(this);
  }
}


// ********************************************************************************
// Posiziona il gruppo nella posizione specificata in lista, solo se non e' gia' stato
// posizionato (IsListPositioned = false)
// ********************************************************************************
PGroup.prototype.SetListPosition = function(left, top, par, wid)
{
  
}


// ********************************************************************************
// Reimposto le variabili per il posizionamento in lista (con fixedcol>0)
// ********************************************************************************
PGroup.prototype.ResetListPosition = function()
{
  
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
PGroup.prototype.GetTooltip = function(tip, obj)
{
  if (this.Tooltip == "")
    return false;
  //
  var ok = false;
  if (obj == this.FormGroupBox || obj == this.FormHeader) {
    tip.SetObj(this.FormGroupBox);
    ok = true;
  }
  if (obj == this.ListGroupBox || obj == this.ListHeader) {
    tip.SetObj(this.ListGroupBox);
    ok = true;
  }
  //
  if (ok)
  {
    tip.SetTitle(this.Header);
    tip.SetText(this.Tooltip);
    tip.SetAutoAnchor(true);
    tip.SetPosition(2);
    return true;
  }
  //
  return false;
}

// *********************************************************
// Imposta la proprieta' Collapsible
// *********************************************************
PGroup.prototype.SetCollapsible = function(value) 
{
  var old = this.Collapsible;
  if (value!=undefined)
    this.Collapsible = value;
  //
  if (this.Realized)
  {
    // Se ci sono dei sotto pannnelli contenuti nel gruppo devo fare allineare correttamente le loro intestazioni
    // Devo usare un timer perche' se lo faccio subito vale tutto 0, mentre se lo faccio alla fine e' brutto
    var showFunction = function () {
      setTimeout(function () {
        if (this.myFormFields) {
          for (var i = 0; i < this.myFormFields.length; i++) {
            var f = this.myFormFields[i];
            if (f && f.SubFrame && f.SubFrame.Realized && f.Visible) 
            { 
              if (f.SubFrame.AlignListHeader)
                f.SubFrame.AlignListHeader();
              if (f.SubFrame instanceof TabbedView)
              {
                var fri = f.SubFrame.GetSelectedFrame();
                if (fri.AlignListHeader)
                  fri.AlignListHeader();
              }
            }
          }
        }
        if (this.myListFields) {
          for (var i = 0; i < this.myListFields.length; i++) {
            var f = this.myFormFields[i];
            if (f && f.SubFrame && f.SubFrame.Realized && f.Visible && f.SubFrame.AlignListHeader)
              f.SubFrame.AlignListHeader();
          }
        }
      }.bind(this), 50);
    }.bind(this);
    //
    if (this.FormCaption) {
      this.FormCaption.setAttribute("data-toggle", this.Collapsible ? "collapse" : "");
      this.FormCaption.href = this.Collapsible ? RD3_Glb.escapeID("#" + this.Identifier + ":gfcb") : "#";
      //
      if (this.FormCollapseBox) {
        $(this.FormCollapseBox).on('hidden.bs.collapse', function () {
          var ev = new IDEvent("grpcol", this.Identifier, null, RD3_Glb.EVENT_ACTIVE, "col");
        }.bind(this));
        $(this.FormCollapseBox).on('shown.bs.collapse', function () {
          var ev = new IDEvent("grpcol", this.Identifier, null, RD3_Glb.EVENT_ACTIVE, "exp");
        }.bind(this));
        //
        // Se ci sono dei sotto pannnelli contenuti nel gruppo devo fa allineare correttamente le loro intestazioni
        // Devo usare un timer perche' se lo faccio subito vale tutto 0, mentre se lo faccio alla fine e' brutto
        $(this.FormCollapseBox).on('show.bs.collapse', showFunction);
      }
    }
    //
    // Rendiamo visibile il contenuto se spegniamo la collassabilità
    if (this.FormCollapseBox && !this.Collapsible)
      this.FormCollapseBox.className = "collapse in";
    //
    if (this.ListCaption) {
      this.ListCaption.setAttribute("data-toggle", this.Collapsible ? "collapse" : "");
      this.ListCaption.href = this.Collapsible ? RD3_Glb.escapeID("#" + this.Identifier + ":glcb") : "#";
      //
      if (this.ListCollapseBox) {
        $(this.ListCollapseBox).on('hidden.bs.collapse', function () {
          var ev = new IDEvent("grpcol", this.Identifier, null, RD3_Glb.EVENT_ACTIVE, "col");
        }.bind(this));
        $(this.ListCollapseBox).on('shown.bs.collapse', function () {
          var ev = new IDEvent("grpcol", this.Identifier, null, RD3_Glb.EVENT_ACTIVE, "exp");
        }.bind(this));
        //
        // Se ci sono dei sotto pannnelli contenuti nel gruppo devo fa allineare correttamente le loro intestazioni
        // Devo usare un timer perche' se lo faccio subito vale tutto 0, mentre se lo faccio alla fine e' brutto
        $(this.ListCollapseBox).on('show.bs.collapse', showFunction);
      }
    }
    //
    // Rendiamo visibile il contenuto se spegniamo la collassabilità
    if (this.ListCollapseBox && !this.Collapsible)
      this.ListCollapseBox.className = "collapse in";
  }
}

PGroup.prototype.SetListMovedFields = function(value)
{
  this.ListMovedFields = value;
}

PGroup.prototype.SetFormMovedFields = function(value)
{
  this.FormMovedFields = value;
}

// *********************************************************
// Imposta la proprieta' Collapsed
// *********************************************************
PGroup.prototype.SetCollapsed = function(value, evento) 
{
  var old = this.Collapsed;
  if (value!=undefined)
    this.Collapsed = value;
  //
  if (this.Realized && (old!=this.Collapsed || value==undefined)) {
    // Durante la fase di realizzazione iniziale non serve usare le animazioni
    if (this.FormCollapseBox) {
      if (this.Realizing)
        this.FormCollapseBox.className = this.Collapsed ? "collapse" : "collapse in";
      else
        $(this.FormCollapseBox).collapse(this.Collapsed ? "hide" : "show");
    }
    //
    if (this.ListCollapseBox) {
      if (this.Realizing)
        this.ListCollapseBox.className = this.Collapsed ? "collapse" : "collapse in";
      else
        $(this.ListCollapseBox).collapse(this.Collapsed ? "hide" : "show");
    }
  }  
}

// ********************************************************************************
// Gestore evento di click sul pulsante Collapse
// ********************************************************************************
PGroup.prototype.OnCollapseClick= function(evento)
{ 
  
}

// ********************************************************************************
// La caption e' stata toccata dall'utente
// ********************************************************************************
PGroup.prototype.OnTouchDown= function(evento, click)
{
  
}


PGroup.prototype.OnTouchUp= function(evento, click)
{
 
}

/**
 * Chiamato dal pannello quando il gruppo deve realizzare se stesso ed i campi in Form
*/
PGroup.prototype.RealizeFormGroup = function(list)
{
  if ((!list && !this.FormGridContainer) || (list && (!this.ListGridContainer || !this.myListFields || this.myListFields.length == 0)))
    return;
  //
  // A questo punto devo riferirmi ai miei campi e creare la grigliatura in cui dovranno renderizzarsi
  var rows = [];
  //
  // Ordino i miei campi in base al TOP
  if (!list)
    this.myFormFields.sort(function(a, b) { return a.FormTop - b.FormTop; });
  if (this.myListFields && list)
    this.myListFields.sort(function(a, b) { return a.ListTop - b.ListTop; });
  //
  var n = list ? this.myListFields.length : this.myFormFields.length;
  for (var i=0; i < n; i++) {
    var f = list ? this.myListFields[i] : this.myFormFields[i];
    if ((!list && f.InForm) || (list && f.InList && !f.ListList)) {
      // Cerchiamo una riga in cui infilare il campo: deve sovrapporsi in Verticale
      // alle coordinate del campo
      var fr = {
        t: list ? f.ListTop : f.FormTop, 
        b: list ? f.ListTop + f.ListHeight : f.FormTop + f.FormHeight, 
        l: list ? f.ListLeft : f.FormLeft, 
        r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
      };
      //
      var fnd = false;
      for (var r = 0; r < rows.length; r++) {
        var rw = rows[r];
        if (RD3_Glb.RectIntersection(rw.rect, fr, 1)) {
          // Se c'è un intersezione allora devo 
          // - estendere il rect della riga in modo da coprire tutti e due i campi
          // - inserire il campo nella riga
          if (rw.rect.t > fr.t)
            rw.rect.t = fr.t;
          if (rw.rect.b < fr.b)
            rw.rect.b = fr.b;
          rw.fields.push(f);
          fnd = true;
          break;
        }
      }
      //
      // Se non ho trovato una riga che si intersechi con il campo 
      // allora ne aggiungo una
      if (!fnd) {
        rows.push({
          rect: fr,
          fields: [ f ],
          cols: []
        });
      }
    }
  }
  //
  // Adesso per ogni riga creata assegnamo i vari campi alle colonne se necessario
  if (list)
    this.FormGroupsColumns = 0;
  else
    this.ListGroupsColumns = 0;
  for (var r = 0; r < rows.length; r++) {
    var rdiv = document.createElement("div");
    rdiv.className = "row";
    if (list)
      this.ListCollapseBody.appendChild(rdiv);
    else
      this.FormCollapseBody.appendChild(rdiv);
    rows[r].rdiv = rdiv;
    this.AssignFieldsToColumns(rows[r], list);
  }
  //
  // Adesso posso dire ai campi in form di realizzarsi nel loro FormGridContainer
  if (list)
    this.ListGridRows = rows;
  else
    this.FormGridRows = rows;
  for (var i=0; i < n; i++) {
    var f = list ? this.myListFields[i] : this.myFormFields[i];
    if ((!list && f.FormGridContainer) || (list && f.ListGridContainer))
      f.RealizeFormField(list);
  }
  if (!list && this.ApplyFormWidth && this.FormGroupsColumns > 0)
    this.SetFormWidth();
  if (list && this.ApplyListWidth && this.ListGroupsColumns > 0)
    this.SetListWidth();
  //
  if (list)
    this.ListGridContainer.appendChild(this.ListGroupBox);
  else
    this.FormGridContainer.appendChild(this.FormGroupBox);
  //
  if (this.BootstrapCellClass != undefined) {
    if (list)
      this.ListGridContainer.className = this.BootstrapCellClass;
    else
      this.FormGridContainer.className = this.BootstrapCellClass;
  }
}


/**
 * Data una riga con dei campi ne assegna le colonne.
 */
PGroup.prototype.AssignFieldsToColumns = function(row, list)
{
  var cols = [];
  //
  var nf = row.fields.length;
  row.fields.sort(function(a, b) { return list ? a.ListLeft - b.ListLeft : a.FormLeft - b.FormLeft; });
  //
  for (var i=0; i<nf; i++) {
    var f = row.fields[i];
    //
    // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
    // alle coordinate del campo
    var fr = {
      t: list ? f.ListTop : f.FormTop, 
      b: list ? f.ListTop + f.ListHeight : f.FormTop + f.FormHeight, 
      l: list ? f.ListLeft : f.FormLeft, 
      r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
    };
    //
    var fnd = false;
    for (var r = 0; r < cols.length; r++) {
      var clm = cols[r];
      if (RD3_Glb.RectIntersection(clm.rect, fr, 2)) {
        // Se c'è un intersezione allora devo 
        // - estendere il rect della colonna in modo da coprire tutti e due i campi
        // - inserire il campo nella colonna
        if (fr.l < clm.rect.l)
          clm.rect.l = fr.l;
        if (fr.r > clm.rect.r)
          clm.rect.r = fr.r;
        clm.fields.push(f);
        fnd = true;
        break;
      }
    }
    //
    // Se non ho trovato una riga che si intersechi con il campo 
    // allora ne aggiungo una
    if (!fnd) {
      cols.push({
        rect: fr,
        fields: [ f ],
        rows: []
      });
    }
  }
  //
  if (!list && cols.length > this.FormGroupsColumns)
   this.FormGroupsColumns = cols.length;
  if (list && cols.length > this.ListGroupsColumns)
   this.ListGroupsColumns = cols.length;
  //
  // Per calcolare il column space (larghezza delle colonne) devo calcolare lo spazio totale occupato,
  // ordinare le colonne per posizione e poi estenderle fino a coprire l'intero spazio 
  // (ad esempio due campi affiancati generano due colonne separate, in questo caso devo estendere la prima colonna
  // fino alla seconda, così posso calcolare le proporzioni giuste)
  cols.sort(function(a, b) {
    var la = a.rect.l;
    var lb = b.rect.l;
    //
    if (la === lb)
      return 0;
    else if (lb > la)
      return -1;
    else
      return 1;
  });
  //
  // Calcolo la larghezza totale occupata dalle colonne (data dallo spazio dei campi)
  var w = 0;
  for (var ri = 0; ri < cols.length; ri++)
    w += (cols[ri].rect.r - cols[ri].rect.l + RD3_ClientParams.GridGutterLeft + RD3_ClientParams.GridGutterRight);
  //
  // Adesso se una colonna contiene più campi/gruppi bisogna dividerla in righe
  row.cols = cols;
  var leftSpace = 12;
  for (var r = 0; r < cols.length; r++) {
    var cdiv = document.createElement("div");
    var cspace = r === cols.length-1 ? leftSpace : Math.floor(((cols[r].rect.r - cols[r].rect.l + RD3_ClientParams.GridGutterLeft + RD3_ClientParams.GridGutterRight)/w)*12);
    if (cspace < 1)
      cspace = 1;
    leftSpace -= cspace;
    //
    // Qualcosa non va, in questo caso andiamo a capo..
    if (leftSpace < 0)
     leftSpace = 12;
    //
    cols[r].cspace = cspace;
    cdiv.className = "col-md-" + cspace;
    row.rdiv.appendChild(cdiv);
    cols[r].cdiv = cdiv;
    //
    if (cols[r].fields.length > 1)
      this.AssignFieldsToRow(cols[r], list);
    else {
      // La colonna contiene un solo campo/gruppo : gli assegno il suo container
      if (list)
        cols[r].fields[0].ListGridContainer = cdiv;
      else
        cols[r].fields[0].FormGridContainer = cdiv;
    }
  }
};

PGroup.prototype.AssignFieldsToRow = function(col, list)
{
  var rows = [];
  //
  var nf = col.fields.length;
  col.fields.sort(function(a, b) { return list ? a.ListTop - b.ListTop : a.FormTop - b.FormTop; });
  for (var i=0; i<nf; i++) {
    var f = col.fields[i];
    //
    // Cerchiamo una colonna in cui infilare il campo: deve sovrapporsi in Orizzontale
    // alle coordinate del campo
    var fr = {
      t: list ? f.ListTop :  f.FormTop, 
      b: list ? f.ListTop + f.ListHeight : f.FormTop + f.FormHeight, 
      l: list ? f.ListLeft : f.FormLeft, 
      r: list ? f.ListLeft + f.ListWidth : f.FormLeft + f.FormWidth
    };
    //
    var fnd = false;
    for (var r = 0; r < rows.length; r++) {
      var rw = rows[r];
      if (RD3_Glb.RectIntersection(rw.rect, fr, 1)) {
        // Se c'è un intersezione allora devo 
        // - estendere il rect della colonna in modo da coprire tutti e due i campi
        // - inserire il campo nella colonna
        if (rw.rect.t > fr.t)
          rw.rect.t = fr.l;
        if (rw.rect.b < fr.b)
          rw.rect.b = fr.b;
        rw.fields.push(f);
        fnd = true;
        break;
      }
    }
    //
    // Se non ho trovato una riga che si intersechi con il campo 
    // allora ne aggiungo una
    if (!fnd) {
      rows.push({
        rect: fr,
        fields: [ f ],
        cols: []
      });
    }    
  }
  //
  // Controllo : ci potrebbero essere campi completamente sovrapposti, in quel caso li sposto su righe differenti
  var r;
  for (r = 0; r < rows.length; r++) {
    var rw = rows[r];
    if (rw.fields.length > 1) {
      var o1 = rw.fields[0];
      var o1rect = {
        t: list ? o1.ListTop : o1.FormTop, 
        b: list ? o1.ListTop + o1.ListHeight : o1.FormTop + o1.FormHeight, 
        l: list ? o1.ListLeft : o1.FormLeft, 
        r: list ? o1.ListLeft + o1.ListWidth : o1.FormLeft + o1.FormWidth
      }
      //
      var hasOverlay = false;
      var ii;
      for (ii = 1; ii < rw.fields.length; ii++) {
        var o2 = rw.fields[ii];
        var o2rect = {
          t: list ? o2.ListTop : o2.FormTop, 
          b: list ? o2.ListTop + o2.ListHeight : o2.FormTop + o2.FormHeight, 
          l: list ? o2.ListLeft : o2.FormLeft, 
          r: list ? o2.ListLeft + o2.ListWidth : o2.FormLeft + o2.FormWidth
        }
        if (RD3_Glb.RectIntersection(o1rect, o2rect, 2) && RD3_Glb.RectIntersection(o1rect, o2rect, 1))
          hasOverlay = true;
      }
      if (hasOverlay) {
        var allFls = rw.fields;
        rw.fields = [ o1 ];
        rw.rect = o1rect;
        //
        // Adesso metto gli altri campi in tante righe da soli
        for (ii = allFls.length - 1; ii > 0; ii--) {
          var o2 = allFls[ii];
          var o2rect = {
            t: list ? o2.ListTop : o2.FormTop, 
            b: list ? o2.ListTop + o2.ListHeight : o2.FormTop + o2.FormHeight, 
            l: list ? o2.ListLeft : o2.FormLeft, 
            r: list ? o2.ListLeft + o2.ListWidth : o2.FormLeft + o2.FormWidth
          }
          var newRow = {
            rect: o2rect,
            fields: [ o2 ],
            cols: []
          }
          rows.splice(r + 1, 0, newRow);
        }
      }
    }
  }
  //
  // Adesso divido le righe in colonne
  col.rows = rows;
  for (r = 0; r < rows.length; r++) {
    var rdiv = document.createElement("div");
    rdiv.className = "row";
    col.cdiv.appendChild(rdiv);
    rows[r].rdiv = rdiv;
    this.AssignFieldsToColumns(rows[r], list);
  }
};