/*
  -------------------.-.--------------------
    OnlyOffice Editor INDE 23 with Fluid
                08/04/2024
                  Daniele
  ------------------------------------------
*/


Client.Editor = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);

  // I create an element div to handle the case OnlyOffice service is not available and void erorrs in inde frontend
  this.domObj = document.createElement("div");
  
  if(!Client.Editor.inited || !element.id) {
    Client.Editor.Realize = parent;
    this.Editor_rendered = false
    return;
  }
  
  if (this.EditorInstance) {
    this.EditorInstance.destroyEditor();
  }
  
  
  if(element.configuration)
  {
    // read the Configuration shared by InDe
    var configuration = element.configuration
    //this.id = element.id;
    this.domObj = document.createElement("div");
    this.domObj.id = `Editor_${element.configuration.id}`;
    this.containerID = element.configuration.id;
    parent.appendChildObject(this, this.domObj);
    this.EditorDiv = this.domObj;
      
    /*
      Store the Editor instance into this.EditorInstance
    */

    this.EditorInstance = new DocsAPI.DocEditor(`${this.domObj.id}`, {
      "document": {
        "fileType": configuration.document.fileType,
        "key": configuration.document.key,
        "title": configuration.document.title,
        "url": configuration.document.url,
      }, 
      "type": configuration.type,
      "documentType": configuration.documentType,
      "events": {
        "onDocumentStateChange": (event) => {
          Client.mainFrame.sendCommand("OOCOM", `content={id:"${this.containerID}",message:"documentStateChange",content: "actuallyEmpty"}`);
        }
      },
      "customization": {
        "uiTheme": "theme-light",
      },
      "editorConfig":{
        "coediting": {
          "mode": "strict",
          "change": false,
        },
        "callbackUrl" : configuration.editor.callbackUrl,
        "lang": configuration.editor.lang,
        "mode": configuration.editor.mode,
        "region": configuration.editor.region,
        "user": configuration.editor.user,
      }
    })

    this.sc_rendered = true;
    this.attachEvents(element.events);
  }
};

// Define extension of class
Client.Editor.prototype = new Client.Element();
Client.Editor.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Editor.getRequirements = function ()
{
  let prefix = Client.mainFrame.isIDF ? "fluid/" : "";
  let req = {};
  Client.Editor.inited = true;
  return req;
};


/*
  Destroy the editor
*/
Client.Editor.prototype.close = function (firstLevel, triggerAnimation)
{
  if(this.EditorInstance){
    this.EditorInstance.requestClose();
    this.EditorInstance.destroyEditor();
  }
}

