/*!
* DevExtreme (dx.messages.hu.js)
* Version: 23.2.5
* Build date: Mon Mar 11 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        hu: {
            Yes: "Igen",
            No: "Nem",
            Cancel: "M\xe9gse",
            Close: "Bez\xe1r\xe1s",
            Clear: "T\xf6rl\xe9s",
            Done: "K\xe9sz",
            Loading: "Bet\xf6lt\xe9s...",
            Select: "V\xe1laszt\xe1s...",
            Search: "Keres\xe9s",
            Back: "Vissza",
            OK: "OK",
            "dxCollectionWidget-noDataText": "Nincs megjelen\xedthet\u0151 adat",
            "dxDropDownEditor-selectLabel": "V\xe1laszt\xe1s",
            "validation-required": "K\xf6telez\u0151",
            "validation-required-formatted": "{0} k\xf6telez\u0151",
            "validation-numeric": "Az \xe9rt\xe9k sz\xe1m kell legyen",
            "validation-numeric-formatted": "{0} sz\xe1m kell legyen",
            "validation-range": "Az \xe9rt\xe9k tartom\xe1nyon k\xedv\xfclre esik",
            "validation-range-formatted": "{0} tartom\xe1nyon k\xedv\xfclre esik",
            "validation-stringLength": "Az \xe9rt\xe9k hossza helytelen",
            "validation-stringLength-formatted": "{0} hossza helytelen",
            "validation-custom": "\xc9rv\xe9nytelen \xe9rt\xe9k",
            "validation-custom-formatted": "{0} \xe9rv\xe9nytelen",
            "validation-async": "\xc9rv\xe9nytelen \xe9rt\xe9k",
            "validation-async-formatted": "{0} \xe9rv\xe9nytelen",
            "validation-compare": "Az \xe9rt\xe9kek nem egyeznek",
            "validation-compare-formatted": "{0} nem egyezik",
            "validation-pattern": "Az \xe9rt\xe9k nem illeszthet\u0151 a mint\xe1ra",
            "validation-pattern-formatted": "{0} nem illeszthet\u0151 a mint\xe1ra",
            "validation-email": "\xc9rv\xe9nytelen email",
            "validation-email-formatted": "{0} \xe9rv\xe9nytelen email",
            "validation-mask": "\xc9rv\xe9nytelen \xe9rt\xe9k",
            "dxLookup-searchPlaceholder": "Minimum karaktersz\xe1m: {0}",
            "dxList-pullingDownText": "H\xfazza le a friss\xedt\xe9shez...",
            "dxList-pulledDownText": "Engedje el a friss\xedt\xe9shez...",
            "dxList-refreshingText": "Friss\xedt\xe9s...",
            "dxList-pageLoadingText": "Bet\xf6lt\xe9s...",
            "dxList-nextButtonText": "Tov\xe1bb",
            "dxList-selectAll": "\xd6sszes kiv\xe1laszt\xe1sa",
            "dxListEditDecorator-delete": "T\xf6rl\xe9s",
            "dxListEditDecorator-more": "T\xf6bb",
            "dxScrollView-pullingDownText": "H\xfazza le a friss\xedt\xe9shez...",
            "dxScrollView-pulledDownText": "Engedje el a friss\xedt\xe9shez...",
            "dxScrollView-refreshingText": "Friss\xedt\xe9s...",
            "dxScrollView-reachBottomText": "Bet\xf6lt\xe9s...",
            "dxDateBox-simulatedDataPickerTitleTime": "V\xe1lasszon id\u0151t",
            "dxDateBox-simulatedDataPickerTitleDate": "V\xe1lasszon d\xe1tumot",
            "dxDateBox-simulatedDataPickerTitleDateTime": "V\xe1lasszon d\xe1tumot \xe9s id\u0151t",
            "dxDateBox-validation-datetime": "Az \xe9rt\xe9k d\xe1tum vagy id\u0151 kell legyen",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Kezd\xe9s d\xe1tuma",
            "dxDateRangeBox-endDateLabel": "Befejez\xe9s d\xe1tuma",
            "dxFileUploader-selectFile": "V\xe1lasszon f\xe1jlt",
            "dxFileUploader-dropFile": "vagy h\xfazza a f\xe1jlt ide",
            "dxFileUploader-bytes": "b\xe1jt",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Felt\xf6lt\xe9s",
            "dxFileUploader-uploaded": "Felt\xf6ltve",
            "dxFileUploader-readyToUpload": "Felt\xf6lt\xe9sre k\xe9sz",
            "dxFileUploader-uploadAbortedMessage": "Felt\xf6lt\xe9s megszak\xedtva",
            "dxFileUploader-uploadFailedMessage": "A felt\xf6lt\xe9s sikertelen",
            "dxFileUploader-invalidFileExtension": "Nem enged\xe9lyezett f\xe1jlt\xedpus",
            "dxFileUploader-invalidMaxFileSize": "T\xfal nagy f\xe1jl",
            "dxFileUploader-invalidMinFileSize": "T\xfal kicsi f\xe1jl",
            "dxRangeSlider-ariaFrom": "-t\xf3l",
            "dxRangeSlider-ariaTill": "-ig",
            "dxSwitch-switchedOnText": "BE",
            "dxSwitch-switchedOffText": "KI",
            "dxForm-optionalMark": "v\xe1laszthat\xf3",
            "dxForm-requiredMessage": "{0} k\xf6telez\u0151",
            "dxNumberBox-invalidValueMessage": "Az \xe9rt\xe9k sz\xe1m kell legyen",
            "dxNumberBox-noDataText": "Nincs adat",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Oszlopv\xe1laszt\xf3",
            "dxDataGrid-columnChooserEmptyText": "H\xfazza ide az oszlopot az elrejt\xe9shez",
            "dxDataGrid-groupContinuesMessage": "A k\xf6vetkez\u0151 oldalon folytat\xf3dik",
            "dxDataGrid-groupContinuedMessage": "Folytat\xe1s az el\u0151z\u0151 oldalr\xf3l",
            "dxDataGrid-groupHeaderText": "Csoportos\xedt\xe1s ezen oszlop szerint",
            "dxDataGrid-ungroupHeaderText": "Csoportbont\xe1s",
            "dxDataGrid-ungroupAllText": "\xd6sszes csoport bont\xe1sa",
            "dxDataGrid-editingEditRow": "Szerkeszt\xe9s",
            "dxDataGrid-editingSaveRowChanges": "Ment\xe9s",
            "dxDataGrid-editingCancelRowChanges": "M\xe9gse",
            "dxDataGrid-editingDeleteRow": "T\xf6rl\xe9s",
            "dxDataGrid-editingUndeleteRow": "Vissza\xe1ll\xedt\xe1s",
            "dxDataGrid-editingConfirmDeleteMessage": "Biztosan t\xf6rli ezt a rekordot?",
            "dxDataGrid-validationCancelChanges": "M\xf3dos\xedt\xe1sok elvet\xe9se",
            "dxDataGrid-groupPanelEmptyText": "H\xfazzon ide egy oszlopfejl\xe9cet a csoportos\xedt\xe1shoz",
            "dxDataGrid-noDataText": "Nincs adat",
            "dxDataGrid-searchPanelPlaceholder": "Keres\xe9s...",
            "dxDataGrid-filterRowShowAllText": "(Mind)",
            "dxDataGrid-filterRowResetOperationText": "Vissza\xe1ll\xedt\xe1s",
            "dxDataGrid-filterRowOperationEquals": "Egyenl\u0151",
            "dxDataGrid-filterRowOperationNotEquals": "Nem egyenl\u0151",
            "dxDataGrid-filterRowOperationLess": "Kisebb",
            "dxDataGrid-filterRowOperationLessOrEquals": "Kisebb vagy egyenl\u0151",
            "dxDataGrid-filterRowOperationGreater": "Nagyobb",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Nagyobb vagy egyenl\u0151",
            "dxDataGrid-filterRowOperationStartsWith": "Kezd\u0151dik",
            "dxDataGrid-filterRowOperationContains": "Tartalmazza",
            "dxDataGrid-filterRowOperationNotContains": "Nem tartalmazza",
            "dxDataGrid-filterRowOperationEndsWith": "V\xe9gz\u0151dik",
            "dxDataGrid-filterRowOperationBetween": "K\xf6z\xf6tt",
            "dxDataGrid-filterRowOperationBetweenStartText": "Kezdete",
            "dxDataGrid-filterRowOperationBetweenEndText": "V\xe9ge",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Sz\u0171r\u0151 alkalmaz\xe1sa",
            "dxDataGrid-trueText": "igaz",
            "dxDataGrid-falseText": "hamis",
            "dxDataGrid-sortingAscendingText": "N\xf6vekv\u0151",
            "dxDataGrid-sortingDescendingText": "Cs\xf6kken\u0151",
            "dxDataGrid-sortingClearText": "Rendez\xe9s t\xf6rl\xe9se",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "M\xf3dos\xedt\xe1sok ment\xe9se",
            "dxDataGrid-editingCancelAllChanges": "M\xf3dos\xedt\xe1sok elvet\xe9se",
            "dxDataGrid-editingAddRow": "Sor hozz\xe1ad\xe1sa",
            "dxDataGrid-summaryMin": "Minimum: {0}",
            "dxDataGrid-summaryMinOtherColumn": "{1} minimuma: {0}",
            "dxDataGrid-summaryMax": "Maximum: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "{1} maximuma: {0}",
            "dxDataGrid-summaryAvg": "\xc1tlag: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "{1} \xe1tlaga: {0}",
            "dxDataGrid-summarySum": "\xd6sszeg: {0}",
            "dxDataGrid-summarySumOtherColumn": "{1} \xf6sszege: {0}",
            "dxDataGrid-summaryCount": "Darabsz\xe1m: {0}",
            "dxDataGrid-columnFixingFix": "R\xf6gz\xedt\xe9s",
            "dxDataGrid-columnFixingUnfix": "Felold\xe1s",
            "dxDataGrid-columnFixingLeftPosition": "Balra",
            "dxDataGrid-columnFixingRightPosition": "Jobbra",
            "dxDataGrid-exportTo": "Export\xe1l\xe1s",
            "dxDataGrid-exportToExcel": "Export\xe1l\xe1s Excel f\xe1jlba",
            "dxDataGrid-exporting": "Export\xe1l\xe1s...",
            "dxDataGrid-excelFormat": "Excel f\xe1jl",
            "dxDataGrid-selectedRows": "Kiv\xe1lasztott sorok",
            "dxDataGrid-exportSelectedRows": "Kiv\xe1lasztott sorok export\xe1l\xe1sa",
            "dxDataGrid-exportAll": "Az \xf6sszes adat export\xe1l\xe1sa",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(\xdcresek)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "M\xe9gse",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Oszlop",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "\xc9rt\xe9k",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Sz\u0171r\u0151 cella",
            "dxDataGrid-ariaCollapse": "\xd6sszecsuk\xe1s",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Kibont\xe1s",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Adatr\xe1cs",
            "dxDataGrid-ariaSearchInGrid": "Keres\xe9s az adatr\xe1csban",
            "dxDataGrid-ariaSelectAll": "\xd6sszes kiv\xe1laszt\xe1sa",
            "dxDataGrid-ariaSelectRow": "Sor kiv\xe1laszt\xe1sa",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Sz\u0171r\u0151k\xe9sz\xedt\u0151",
            "dxDataGrid-filterPanelCreateFilter": "Sz\u0171r\u0151 l\xe9trehoz\xe1sa",
            "dxDataGrid-filterPanelClearFilter": "T\xf6rl\xe9s",
            "dxDataGrid-filterPanelFilterEnabledHint": "Sz\u0171r\u0151 enged\xe9lyez\xe9se",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Hozz\xe1ad\xe1s",
            "dxPager-infoText": "Oldal: {0}/{1} ({2} elem)",
            "dxPager-pagesCountText": "/",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Mind",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Teljes \xf6sszeg",
            "dxPivotGrid-total": "{0} \xd6sszeg",
            "dxPivotGrid-fieldChooserTitle": "Mez\u0151v\xe1laszt\xf3",
            "dxPivotGrid-showFieldChooser": "Mez\u0151v\xe1laszt\xf3 megjelen\xedt\xe9se",
            "dxPivotGrid-expandAll": "\xd6sszes kibont\xe1sa",
            "dxPivotGrid-collapseAll": "\xd6sszes \xf6sszecsuk\xe1sa",
            "dxPivotGrid-sortColumnBySummary": 'Rendez\xe9s "{0}" ezen oszlop alapj\xe1n',
            "dxPivotGrid-sortRowBySummary": 'Rendez\xe9s "{0}" ezen sor alapj\xe1n',
            "dxPivotGrid-removeAllSorting": "\xd6sszes rendez\xe9s t\xf6rl\xe9se",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "Sormez\u0151k",
            "dxPivotGrid-columnFields": "Oszlopmez\u0151k",
            "dxPivotGrid-dataFields": "Adatmez\u0151k",
            "dxPivotGrid-filterFields": "Sz\u0171r\u0151mez\u0151k",
            "dxPivotGrid-allFields": "\xd6sszes mez\u0151",
            "dxPivotGrid-columnFieldArea": "H\xfazza az oszlopmez\u0151ket ide",
            "dxPivotGrid-dataFieldArea": "H\xfazza az adatmez\u0151ket ide",
            "dxPivotGrid-rowFieldArea": "H\xfazza a sormez\u0151ket ide",
            "dxPivotGrid-filterFieldArea": "H\xfazza a sz\u0171r\u0151mez\u0151ket ide",
            "dxScheduler-editorLabelTitle": "T\xe1rgy",
            "dxScheduler-editorLabelStartDate": "Kezd\xe9s d\xe1tuma",
            "dxScheduler-editorLabelEndDate": "Befejez\xe9s d\xe1tuma",
            "dxScheduler-editorLabelDescription": "Le\xedr\xe1s",
            "dxScheduler-editorLabelRecurrence": "Ism\xe9tl\u0151d\xe9s",
            "dxScheduler-openAppointment": "Tal\xe1lkoz\xf3 megnyit\xe1sa",
            "dxScheduler-recurrenceNever": "Soha",
            "dxScheduler-recurrenceMinutely": "Percenk\xe9nt",
            "dxScheduler-recurrenceHourly": "\xd3r\xe1nk\xe9nt",
            "dxScheduler-recurrenceDaily": "Naponta",
            "dxScheduler-recurrenceWeekly": "Hetente",
            "dxScheduler-recurrenceMonthly": "Havonta",
            "dxScheduler-recurrenceYearly": "\xc9vente",
            "dxScheduler-recurrenceRepeatEvery": "Ism\xe9tl\u0151d\xe9s minden",
            "dxScheduler-recurrenceRepeatOn": "Ism\xe9tl\u0151d\xe9s",
            "dxScheduler-recurrenceEnd": "Ism\xe9tl\u0151d\xe9s v\xe9ge",
            "dxScheduler-recurrenceAfter": "Ut\xe1n",
            "dxScheduler-recurrenceOn": "Ekkor",
            "dxScheduler-recurrenceRepeatMinutely": "perc(ek)",
            "dxScheduler-recurrenceRepeatHourly": "\xf3ra(k)",
            "dxScheduler-recurrenceRepeatDaily": "nap(ok)",
            "dxScheduler-recurrenceRepeatWeekly": "h\xe9t(ek)",
            "dxScheduler-recurrenceRepeatMonthly": "h\xf3nap(ok)",
            "dxScheduler-recurrenceRepeatYearly": "\xe9v(ek)",
            "dxScheduler-switcherDay": "Nap",
            "dxScheduler-switcherWeek": "H\xe9t",
            "dxScheduler-switcherWorkWeek": "Munkah\xe9t",
            "dxScheduler-switcherMonth": "H\xf3nap",
            "dxScheduler-switcherAgenda": "Napt\xe1r",
            "dxScheduler-switcherTimelineDay": "Id\u0151vonal nap",
            "dxScheduler-switcherTimelineWeek": "Id\u0151vonal h\xe9t",
            "dxScheduler-switcherTimelineWorkWeek": "Id\u0151vonal munkah\xe9t",
            "dxScheduler-switcherTimelineMonth": "Id\u0151vonal h\xf3nap",
            "dxScheduler-recurrenceRepeatOnDate": "d\xe1tumon",
            "dxScheduler-recurrenceRepeatCount": "el\u0151fordul\xe1s(ok)",
            "dxScheduler-allDay": "Eg\xe9sz nap",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Csak ezt az alkalmat szeretn\xe9 szerkeszteni, vagy az \xf6sszes ism\xe9tl\u0151d\xe9st?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Csak ezt az alkalmat szeretn\xe9 t\xf6r\xf6lni, vagy az \xf6sszes ism\xe9tl\u0151d\xe9st?",
            "dxScheduler-confirmRecurrenceEditSeries": "Ism\xe9tl\u0151d\xe9s szerkeszt\xe9se",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Ism\xe9tl\u0151d\xe9s t\xf6rl\xe9se",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Alkalom szerkeszt\xe9se",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Alkalom t\xf6rl\xe9se",
            "dxScheduler-noTimezoneTitle": "Nincs id\u0151z\xf3na",
            "dxScheduler-moreAppointments": "{0} t\xf6bb",
            "dxCalendar-todayButtonText": "Ma",
            "dxCalendar-ariaWidgetName": "Napt\xe1r",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxColorView-ariaRed": "Piros",
            "dxColorView-ariaGreen": "Z\xf6ld",
            "dxColorView-ariaBlue": "K\xe9k",
            "dxColorView-ariaAlpha": "\xc1tl\xe1tsz\xf3s\xe1g",
            "dxColorView-ariaHex": "Sz\xednk\xf3d",
            "dxTagBox-selected": "{0} kiv\xe1lasztva",
            "dxTagBox-allSelected": "\xd6sszes kiv\xe1lasztva ({0})",
            "dxTagBox-moreSelected": "{0} t\xf6bb",
            "vizExport-printingButtonText": "Nyomtat\xe1s",
            "vizExport-titleMenuText": "Export\xe1l\xe1s/Nyomtat\xe1s",
            "vizExport-exportButtonText": "{0} f\xe1jl",
            "dxFilterBuilder-and": "\xc9s",
            "dxFilterBuilder-or": "Vagy",
            "dxFilterBuilder-notAnd": "Nem \xc9s",
            "dxFilterBuilder-notOr": "Nem Vagy",
            "dxFilterBuilder-addCondition": "Felt\xe9tel hozz\xe1ad\xe1sa",
            "dxFilterBuilder-addGroup": "Csoport hozz\xe1ad\xe1sa",
            "dxFilterBuilder-enterValueText": "<\xedrjon be egy \xe9rt\xe9ket>",
            "dxFilterBuilder-filterOperationEquals": "Egyenl\u0151",
            "dxFilterBuilder-filterOperationNotEquals": "Nem egyenl\u0151",
            "dxFilterBuilder-filterOperationLess": "Kisebb",
            "dxFilterBuilder-filterOperationLessOrEquals": "Kisebb vagy egyenl\u0151",
            "dxFilterBuilder-filterOperationGreater": "Nagyobb",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Nagyobb vagy egyenl\u0151",
            "dxFilterBuilder-filterOperationStartsWith": "Kezd\u0151dik",
            "dxFilterBuilder-filterOperationContains": "Tartalmazza",
            "dxFilterBuilder-filterOperationNotContains": "Nem tartalmazza",
            "dxFilterBuilder-filterOperationEndsWith": "V\xe9gz\u0151dik",
            "dxFilterBuilder-filterOperationIsBlank": "\xdcres",
            "dxFilterBuilder-filterOperationIsNotBlank": "Nem \xfcres",
            "dxFilterBuilder-filterOperationBetween": "K\xf6z\xf6tt",
            "dxFilterBuilder-filterOperationAnyOf": "Valamelyik",
            "dxFilterBuilder-filterOperationNoneOf": "Egyik sem",
            "dxHtmlEditor-dialogColorCaption": "Bet\u0171sz\xedn v\xe1laszt\xe1s",
            "dxHtmlEditor-dialogBackgroundCaption": "H\xe1tt\xe9rsz\xedn v\xe1laszt\xe1s",
            "dxHtmlEditor-dialogLinkCaption": "Link hozz\xe1ad\xe1sa",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Sz\xf6veg",
            "dxHtmlEditor-dialogLinkTargetField": "Link megnyit\xe1sa \xfaj ablakban",
            "dxHtmlEditor-dialogImageCaption": "K\xe9p hozz\xe1ad\xe1sa",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternat\xedv sz\xf6veg",
            "dxHtmlEditor-dialogImageWidthField": "Sz\xe9less\xe9g (px)",
            "dxHtmlEditor-dialogImageHeightField": "Magass\xe1g (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Sorok",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Oszlopok",
            "dxHtmlEditor-dialogInsertTableCaption": "T\xe1bla besz\xfar\xe1sa",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Fejl\xe9c",
            "dxHtmlEditor-normalText": "Norm\xe1l sz\xf6veg",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "N\xe9vtelen k\xf6nyvt\xe1r",
            "dxFileManager-rootDirectoryName": "F\xe1jlok",
            "dxFileManager-errorNoAccess": "Hozz\xe1f\xe9r\xe9s megtagadva. A m\u0171veletet nem lehet befejezni.",
            "dxFileManager-errorDirectoryExistsFormat": "'{0}' nev\u0171 k\xf6nyvt\xe1r m\xe1r l\xe9tezik.",
            "dxFileManager-errorFileExistsFormat": "'{0}' nev\u0171 f\xe1jl m\xe1r l\xe9tezik.",
            "dxFileManager-errorFileNotFoundFormat": "'{0}' nev\u0171 f\xe1jl nem tal\xe1lhat\xf3",
            "dxFileManager-errorDirectoryNotFoundFormat": "'{0}' nev\u0171 k\xf6nyvt\xe1r nem tal\xe1lhat\xf3",
            "dxFileManager-errorWrongFileExtension": "Nem enged\xe9lyezett f\xe1jlt\xedpus",
            "dxFileManager-errorMaxFileSizeExceeded": "A f\xe1jlm\xe9ret meghaladja a megengedett legnagyobb m\xe9retet",
            "dxFileManager-errorInvalidSymbols": "A n\xe9v \xe9rv\xe9nytelen karaktereket tartalmaz.",
            "dxFileManager-errorDefault": "Ismeretlen hiba.",
            "dxFileManager-errorDirectoryOpenFailed": "A k\xf6nyvt\xe1r nem nyithat\xf3 meg",
            "dxFileManager-commandCreate": "\xdaj k\xf6nyvt\xe1r",
            "dxFileManager-commandRename": "\xc1tnevez\xe9s",
            "dxFileManager-commandMove": "\xc1thelyez\xe9s",
            "dxFileManager-commandCopy": "M\xe1sol\xe1s",
            "dxFileManager-commandDelete": "T\xf6rl\xe9s",
            "dxFileManager-commandDownload": "Let\xf6lt\xe9s",
            "dxFileManager-commandUpload": "F\xe1jlok felt\xf6lt\xe9se",
            "dxFileManager-commandRefresh": "Friss\xedt\xe9s",
            "dxFileManager-commandThumbnails": "Miniat\u0171r n\xe9zet",
            "dxFileManager-commandDetails": "R\xe9szletek n\xe9zet",
            "dxFileManager-commandClearSelection": "Kijel\xf6l\xe9s t\xf6rl\xe9se",
            "dxFileManager-commandShowNavPane": "Navig\xe1ci\xf3s ablakt\xe1bla megjelen\xedt\xe9se/elrejt\xe9se",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "\xc1thelyez\xe9s",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "\xc1thelyez\xe9s",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "M\xe1sol\xe1s",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "M\xe1sol\xe1s",
            "dxFileManager-dialogRenameItemTitle": "\xc1tnevez\xe9s",
            "dxFileManager-dialogRenameItemButtonText": "Ment\xe9s",
            "dxFileManager-dialogCreateDirectoryTitle": "\xdaj k\xf6nyvt\xe1r",
            "dxFileManager-dialogCreateDirectoryButtonText": "L\xe9trehoz\xe1s",
            "dxFileManager-dialogDeleteItemTitle": "T\xf6rl\xe9s",
            "dxFileManager-dialogDeleteItemButtonText": "T\xf6rl\xe9s",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Biztosan t\xf6rli a k\xf6vetkez\u0151t: {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Biztosan t\xf6r\xf6lni szeretne {0} elemet?",
            "dxFileManager-dialogButtonCancel": "M\xe9gse",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "K\xf6nyvt\xe1r l\xe9trehoz\xe1sa a k\xf6vetkez\u0151ben: {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "K\xf6nyvt\xe1r l\xe9trehozva a k\xf6vetkez\u0151ben: {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "A k\xf6nyvt\xe1r nem lett l\xe9trehozva",
            "dxFileManager-editingCreateCommonErrorMessage": "A k\xf6nyvt\xe1r nem lett l\xe9trehozva",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Elem \xe1tnevez\xe9se a k\xf6vetkez\u0151ben: {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Elem \xe1tnevezve a k\xf6vetkez\u0151ben: {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Az elem nem lett \xe1tnevezve",
            "dxFileManager-editingRenameCommonErrorMessage": "Az elem nem lett \xe1tnevezve",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Elem t\xf6rl\xe9se innen: {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "{0} elem t\xf6rl\xe9se innen: {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Elem t\xf6r\xf6lve innen: {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "{0} elem t\xf6r\xf6lve innen: {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Az elem nem lett t\xf6r\xf6lve",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elem nem lett t\xf6r\xf6lve",
            "dxFileManager-editingDeleteCommonErrorMessage": "N\xe9h\xe1ny elem nem lett t\xf6r\xf6lve",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Elem \xe1thelyez\xe9se ide: {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "{0} elem \xe1thelyez\xe9se ide: {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Elem \xe1thelyezve ide: {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "{0} elem \xe1thelyezve ide: {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Az elem nem lett \xe1thelyezve",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} elem nem lett \xe1thelyezve",
            "dxFileManager-editingMoveCommonErrorMessage": "N\xe9h\xe1ny elem nem lett \xe1thelyezve",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Elem m\xe1sol\xe1sa ide: {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "{0} elem m\xe1sol\xe1sa ide: {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Elem \xe1tm\xe1solva ide: {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "{0} elem \xe1tm\xe1solva ide: {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Az elem nem lett \xe1tm\xe1solva",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} elem nem lett \xe1tm\xe1solva",
            "dxFileManager-editingCopyCommonErrorMessage": "N\xe9h\xe1ny elem nem lett \xe1tm\xe1solva",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Elem felt\xf6lt\xe9se ide: {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "{0} elem felt\xf6lt\xe9se ide: {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Elem felt\xf6ltve ide: {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "{0} elem felt\xf6ltve ide: {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Az elem nem lett felt\xf6ltve",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} elem nem lett felt\xf6ltve",
            "dxFileManager-editingUploadCanceledMessage": "T\xf6r\xf6lve",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "N\xe9v",
            "dxFileManager-listDetailsColumnCaptionDateModified": "M\xf3dos\xedt\xe1s d\xe1tuma",
            "dxFileManager-listDetailsColumnCaptionFileSize": "F\xe1jlm\xe9ret",
            "dxFileManager-listThumbnailsTooltipTextSize": "M\xe9ret",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "M\xf3dos\xedt\xe1s d\xe1tuma",
            "dxFileManager-notificationProgressPanelTitle": "Folyamat",
            "dxFileManager-notificationProgressPanelEmptyListText": "Nincsenek m\u0171veletek",
            "dxFileManager-notificationProgressPanelOperationCanceled": "T\xf6r\xf6lve",
            "dxDiagram-categoryGeneral": "\xc1ltal\xe1nos",
            "dxDiagram-categoryFlowchart": "Folyamat\xe1bra",
            "dxDiagram-categoryOrgChart": "Szervezeti \xe1bra",
            "dxDiagram-categoryContainers": "T\xe1rol\xf3k",
            "dxDiagram-categoryCustom": "Egyedi",
            "dxDiagram-commandExportToSvg": "Export\xe1l\xe1s SVG-be",
            "dxDiagram-commandExportToPng": "Export\xe1l\xe1s PNG-be",
            "dxDiagram-commandExportToJpg": "Export\xe1l\xe1s JPEG-be",
            "dxDiagram-commandUndo": "Visszavon\xe1s",
            "dxDiagram-commandRedo": "\xdajra",
            "dxDiagram-commandFontName": "Bet\u0171t\xedpus",
            "dxDiagram-commandFontSize": "Bet\u0171m\xe9ret",
            "dxDiagram-commandBold": "F\xe9lk\xf6v\xe9r",
            "dxDiagram-commandItalic": "D\u0151lt",
            "dxDiagram-commandUnderline": "Al\xe1h\xfazott",
            "dxDiagram-commandTextColor": "Bet\u0171sz\xedn",
            "dxDiagram-commandLineColor": "Vonal sz\xedne",
            "dxDiagram-commandLineWidth": "Vonal sz\xe9less\xe9ge",
            "dxDiagram-commandLineStyle": "Vonal st\xedlusa",
            "dxDiagram-commandLineStyleSolid": "T\xf6m\xf6r",
            "dxDiagram-commandLineStyleDotted": "Pontozott",
            "dxDiagram-commandLineStyleDashed": "Szaggatott",
            "dxDiagram-commandFillColor": "Kit\xf6lt\u0151 sz\xedn",
            "dxDiagram-commandAlignLeft": "Balra igaz\xedt\xe1s",
            "dxDiagram-commandAlignCenter": "K\xf6z\xe9pre igaz\xedt\xe1s",
            "dxDiagram-commandAlignRight": "Jobbra igaz\xedt\xe1s",
            "dxDiagram-commandConnectorLineType": "\xd6sszek\xf6t\u0151 vonal t\xedpusa",
            "dxDiagram-commandConnectorLineStraight": "Egyenes",
            "dxDiagram-commandConnectorLineOrthogonal": "Mer\u0151leges",
            "dxDiagram-commandConnectorLineStart": "\xd6sszek\xf6t\u0151 vonal kezdete",
            "dxDiagram-commandConnectorLineEnd": "\xd6sszek\xf6t\u0151 vonal v\xe9ge",
            "dxDiagram-commandConnectorLineNone": "Egyik sem",
            "dxDiagram-commandConnectorLineArrow": "Ny\xedl",
            "dxDiagram-commandFullscreen": "Teljes k\xe9perny\u0151",
            "dxDiagram-commandUnits": "Egys\xe9gek",
            "dxDiagram-commandPageSize": "Lapm\xe9ret",
            "dxDiagram-commandPageOrientation": "T\xe1jol\xe1s",
            "dxDiagram-commandPageOrientationLandscape": "Fekv\u0151",
            "dxDiagram-commandPageOrientationPortrait": "\xc1ll\xf3",
            "dxDiagram-commandPageColor": "Oldal sz\xedne",
            "dxDiagram-commandShowGrid": "R\xe1cs megjelen\xedt\xe9se",
            "dxDiagram-commandSnapToGrid": "R\xe1cshoz igaz\xedt\xe1s",
            "dxDiagram-commandGridSize": "R\xe1cs m\xe9rete",
            "dxDiagram-commandZoomLevel": "Nagy\xedt\xe1s",
            "dxDiagram-commandAutoZoom": "Automatikus nagy\xedt\xe1s",
            "dxDiagram-commandFitToContent": "Tartalomhoz igaz\xedt\xe1s",
            "dxDiagram-commandFitToWidth": "Sz\xe9less\xe9ghez igaz\xedt\xe1s",
            "dxDiagram-commandAutoZoomByContent": "Automatikus nagy\xedt\xe1s tartalom szerint",
            "dxDiagram-commandAutoZoomByWidth": "Automatikus nagy\xedt\xe1s sz\xe9less\xe9g szerint",
            "dxDiagram-commandSimpleView": "Egyszer\u0171s\xedtett n\xe9zet",
            "dxDiagram-commandCut": "Kiv\xe1g\xe1s",
            "dxDiagram-commandCopy": "M\xe1sol\xe1s",
            "dxDiagram-commandPaste": "Beilleszt\xe9s",
            "dxDiagram-commandSelectAll": "\xd6sszes kiv\xe1laszt\xe1sa",
            "dxDiagram-commandDelete": "T\xf6rl\xe9s",
            "dxDiagram-commandBringToFront": "El\u0151rehoz",
            "dxDiagram-commandSendToBack": "H\xe1trak\xfcld",
            "dxDiagram-commandLock": "R\xf6gz\xedt",
            "dxDiagram-commandUnlock": "Felold",
            "dxDiagram-commandInsertShapeImage": "K\xe9p besz\xfar\xe1sa...",
            "dxDiagram-commandEditShapeImage": "K\xe9p cser\xe9je...",
            "dxDiagram-commandDeleteShapeImage": "K\xe9p t\xf6rl\xe9se",
            "dxDiagram-commandLayoutLeftToRight": "Balr\xf3l jobbra",
            "dxDiagram-commandLayoutRightToLeft": "Jobbr\xf3l balra",
            "dxDiagram-commandLayoutTopToBottom": "Fentr\u0151l lefel\xe9",
            "dxDiagram-commandLayoutBottomToTop": "Lentr\u0151l felfel\xe9",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "M\xe9gse",
            "dxDiagram-dialogInsertShapeImageTitle": "K\xe9p besz\xfar\xe1sa",
            "dxDiagram-dialogEditShapeImageTitle": "K\xe9p cser\xe9je",
            "dxDiagram-dialogEditShapeImageSelectButton": "K\xe9p kiv\xe1laszt\xe1sa",
            "dxDiagram-dialogEditShapeImageLabelText": "vagy h\xfazza a f\xe1jlt ide",
            "dxDiagram-uiExport": "Export\xe1l\xe1s",
            "dxDiagram-uiProperties": "Tulajdons\xe1gok",
            "dxDiagram-uiSettings": "Be\xe1ll\xedt\xe1sok",
            "dxDiagram-uiShowToolbox": "Eszk\xf6zt\xe1r megjelen\xedt\xe9se",
            "dxDiagram-uiSearch": "Keres\xe9s",
            "dxDiagram-uiStyle": "St\xedlus",
            "dxDiagram-uiLayout": "Elrendez\xe9s",
            "dxDiagram-uiLayoutTree": "Fa",
            "dxDiagram-uiLayoutLayered": "R\xe9teges",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Sz\xf6veg",
            "dxDiagram-uiObject": "Objektum",
            "dxDiagram-uiConnector": "Csatlakoz\xf3",
            "dxDiagram-uiPage": "Oldal",
            "dxDiagram-shapeText": "Sz\xf6veg",
            "dxDiagram-shapeRectangle": "T\xe9glalap",
            "dxDiagram-shapeEllipse": "Ellipszis",
            "dxDiagram-shapeCross": "Kereszt",
            "dxDiagram-shapeTriangle": "H\xe1romsz\xf6g",
            "dxDiagram-shapeDiamond": "Rombusz",
            "dxDiagram-shapeHeart": "Sz\xedv",
            "dxDiagram-shapePentagon": "\xd6tsz\xf6g",
            "dxDiagram-shapeHexagon": "Hatsz\xf6g",
            "dxDiagram-shapeOctagon": "Nyolcsz\xf6g",
            "dxDiagram-shapeStar": "Csillag",
            "dxDiagram-shapeArrowLeft": "Balra ny\xedl",
            "dxDiagram-shapeArrowUp": "Felfel\xe9 ny\xedl",
            "dxDiagram-shapeArrowRight": "Jobbra ny\xedl",
            "dxDiagram-shapeArrowDown": "Lefel\xe9 ny\xedl",
            "dxDiagram-shapeArrowUpDown": "Fel-le ny\xedl",
            "dxDiagram-shapeArrowLeftRight": "Balra-jobbra ny\xedl",
            "dxDiagram-shapeProcess": "Folyamat",
            "dxDiagram-shapeDecision": "D\xf6nt\xe9s",
            "dxDiagram-shapeTerminator": "Lez\xe1r\xe1s",
            "dxDiagram-shapePredefinedProcess": "El\u0151re meghat\xe1rozott folyamat",
            "dxDiagram-shapeDocument": "Dokumentum",
            "dxDiagram-shapeMultipleDocuments": "T\xf6bb dokumentum",
            "dxDiagram-shapeManualInput": "K\xe9zi bevitel",
            "dxDiagram-shapePreparation": "El\u0151k\xe9sz\xedt\xe9s",
            "dxDiagram-shapeData": "Adat",
            "dxDiagram-shapeDatabase": "Adatb\xe1zis",
            "dxDiagram-shapeHardDisk": "Merevlemez",
            "dxDiagram-shapeInternalStorage": "Bels\u0151 t\xe1rol\xf3",
            "dxDiagram-shapePaperTape": "Pap\xedrszalag",
            "dxDiagram-shapeManualOperation": "K\xe9zi m\u0171velet",
            "dxDiagram-shapeDelay": "K\xe9s\xe9s",
            "dxDiagram-shapeStoredData": "T\xe1rolt adatok",
            "dxDiagram-shapeDisplay": "Kijelz\u0151",
            "dxDiagram-shapeMerge": "\xd6sszevon\xe1s",
            "dxDiagram-shapeConnector": "Csatlakoz\xf3",
            "dxDiagram-shapeOr": "Vagy",
            "dxDiagram-shapeSummingJunction": "\xd6sszegz\u0151 csom\xf3pont",
            "dxDiagram-shapeContainerDefaultText": "T\xe1rol\xf3",
            "dxDiagram-shapeVerticalContainer": "F\xfcgg\u0151leges t\xe1rol\xf3",
            "dxDiagram-shapeHorizontalContainer": "V\xedzszintes t\xe1rol\xf3",
            "dxDiagram-shapeCardDefaultText": "Szem\xe9ly neve",
            "dxDiagram-shapeCardWithImageOnLeft": "K\xe1rtya, bal oldalon k\xe9ppel",
            "dxDiagram-shapeCardWithImageOnTop": "K\xe1rtya, fel\xfcl k\xe9ppel",
            "dxDiagram-shapeCardWithImageOnRight": "K\xe1rtya, jobb oldalon k\xe9ppel",
            "dxGantt-dialogTitle": "C\xedm",
            "dxGantt-dialogStartTitle": "Kezd\xe9s",
            "dxGantt-dialogEndTitle": "Befejez\xe9s",
            "dxGantt-dialogProgressTitle": "Folyamat",
            "dxGantt-dialogResourcesTitle": "Er\u0151forr\xe1s",
            "dxGantt-dialogResourceManagerTitle": "Er\u0151forr\xe1s menedzser",
            "dxGantt-dialogTaskDetailsTitle": "Feladat r\xe9szletei",
            "dxGantt-dialogEditResourceListHint": "Er\u0151forr\xe1s lista szerkeszt\xe9se",
            "dxGantt-dialogEditNoResources": "Nincsenek er\u0151forr\xe1sok",
            "dxGantt-dialogButtonAdd": "Hozz\xe1ad\xe1s",
            "dxGantt-contextMenuNewTask": "\xdaj feladat",
            "dxGantt-contextMenuNewSubtask": "\xdaj alfeladat",
            "dxGantt-contextMenuDeleteTask": "Feladat t\xf6rl\xe9se",
            "dxGantt-contextMenuDeleteDependency": "F\xfcgg\u0151s\xe9g t\xf6rl\xe9se",
            "dxGantt-dialogTaskDeleteConfirmation": "A feladat t\xf6rl\xe9s\xe9vel az \xf6sszes f\xfcgg\u0151s\xe9ge \xe9s r\xe9szfeladata is t\xf6rl\u0151dik. Biztosan t\xf6rli ezt a feladatot?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Biztosan t\xf6rli a f\xfcgg\u0151s\xe9get a feladatb\xf3l?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Az er\u0151forr\xe1s t\xf6rl\xe9se egy\xfattal t\xf6rli azokb\xf3l a feladatokb\xf3l is, amelyekhez ez az er\u0151forr\xe1s tartozik. Biztosan t\xf6rli ezt az er\u0151forr\xe1st? Er\u0151forr\xe1s: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Az \xe1thelyezni k\xedv\xe1nt feladatot f\xfcgg\u0151s\xe9gi viszony kapcsolja \xf6ssze egy m\xe1sik feladattal. Ez a v\xe1ltoz\xe1s \xfctk\xf6zne a f\xfcgg\u0151s\xe9gi szab\xe1lyokkal. Hogyan szeretn\xe9 folytatni?",
            "dxGantt-dialogConstraintViolationMessage": "Az \xe1thelyezni k\xedv\xe1nt feladatot f\xfcgg\u0151s\xe9gi viszony kapcsolja \xf6ssze egy m\xe1sik feladattal. Hogyan szeretn\xe9 folytatni?",
            "dxGantt-dialogCancelOperationMessage": "M\u0171velet megszak\xedt\xe1sa",
            "dxGantt-dialogDeleteDependencyMessage": "F\xfcgg\u0151s\xe9g t\xf6rl\xe9se",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Helyezze \xe1t a feladatot, \xe9s tartsa meg a f\xfcgg\u0151s\xe9get",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Visszavon\xe1s",
            "dxGantt-redo": "M\xe9gis",
            "dxGantt-expandAll": "\xd6sszes kibont\xe1sa",
            "dxGantt-collapseAll": "\xd6sszes \xf6sszecsuk\xe1sa",
            "dxGantt-addNewTask": "\xdaj feladat hozz\xe1ad\xe1sa",
            "dxGantt-deleteSelectedTask": "Kiv\xe1lasztott feladat t\xf6rl\xe9se",
            "dxGantt-zoomIn": "Nagy\xedt\xe1s",
            "dxGantt-zoomOut": "Kicsiny\xedt\xe9s",
            "dxGantt-fullScreen": "Teljes k\xe9perny\u0151",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "N\xf6vekv\u0151",
            "dxGantt-sortingDescendingText": "Cs\xf6kken\u0151",
            "dxGantt-sortingClearText": "Rendez\xe9s t\xf6rl\xe9se",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}"
        }
    })
}));
