/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 23.2.5
 * Build date: Mon Mar 11 2024
 *
 * Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
! function() {
    var __webpack_modules__ = {
        81589:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/base_component.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoWrapperComponent = exports.InfernoComponent = exports.BaseInfernoComponent = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var effect_host_1 = __webpack_require__( /*! ./effect_host */ 53213);
                var areObjectsEqual = function(firstObject, secondObject) {
                    var bothAreObjects = firstObject instanceof Object && secondObject instanceof Object;
                    if (!bothAreObjects) {
                        return firstObject === secondObject
                    }
                    var firstObjectKeys = Object.keys(firstObject);
                    var secondObjectKeys = Object.keys(secondObject);
                    if (firstObjectKeys.length !== secondObjectKeys.length) {
                        return false
                    }
                    var hasDifferentElement = firstObjectKeys.some((function(key) {
                        return firstObject[key] !== secondObject[key]
                    }));
                    return !hasDifferentElement
                };
                var BaseInfernoComponent = function(_super) {
                    __extends(BaseInfernoComponent, _super);

                    function BaseInfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._pendingContext = _this.context;
                        return _this
                    }
                    BaseInfernoComponent.prototype.componentWillReceiveProps = function(_, context) {
                        this._pendingContext = null !== context && void 0 !== context ? context : {}
                    };
                    BaseInfernoComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        return !areObjectsEqual(this.props, nextProps) || !areObjectsEqual(this.state, nextState) || !areObjectsEqual(this.context, this._pendingContext)
                    };
                    return BaseInfernoComponent
                }(inferno_1.Component);
                exports.BaseInfernoComponent = BaseInfernoComponent;
                var InfernoComponent = function(_super) {
                    __extends(InfernoComponent, _super);

                    function InfernoComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this._effects = [];
                        return _this
                    }
                    InfernoComponent.prototype.createEffects = function() {
                        return []
                    };
                    InfernoComponent.prototype.updateEffects = function() {};
                    InfernoComponent.prototype.componentWillMount = function() {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentWillUpdate = function(_nextProps, _nextState, _context) {
                        effect_host_1.InfernoEffectHost.lock()
                    };
                    InfernoComponent.prototype.componentDidMount = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            _this._effects = _this.createEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.componentDidUpdate = function() {
                        var _this = this;
                        effect_host_1.InfernoEffectHost.callbacks.push((function() {
                            return _this.updateEffects()
                        }));
                        effect_host_1.InfernoEffectHost.callEffects()
                    };
                    InfernoComponent.prototype.destroyEffects = function() {
                        this._effects.forEach((function(e) {
                            return e.dispose()
                        }))
                    };
                    InfernoComponent.prototype.componentWillUnmount = function() {
                        this.destroyEffects()
                    };
                    return InfernoComponent
                }(BaseInfernoComponent);
                exports.InfernoComponent = InfernoComponent;
                var InfernoWrapperComponent = function(_super) {
                    __extends(InfernoWrapperComponent, _super);

                    function InfernoWrapperComponent() {
                        var _this = null !== _super && _super.apply(this, arguments) || this;
                        _this.vDomElement = null;
                        return _this
                    }
                    InfernoWrapperComponent.prototype.vDomUpdateClasses = function() {
                        var el = this.vDomElement;
                        var currentClasses = el.className.length ? el.className.split(" ") : [];
                        var addedClasses = currentClasses.filter((function(className) {
                            return el.dxClasses.previous.indexOf(className) < 0
                        }));
                        var removedClasses = el.dxClasses.previous.filter((function(className) {
                            return currentClasses.indexOf(className) < 0
                        }));
                        addedClasses.forEach((function(value) {
                            var indexInRemoved = el.dxClasses.removed.indexOf(value);
                            if (indexInRemoved > -1) {
                                el.dxClasses.removed.splice(indexInRemoved, 1)
                            } else {
                                el.dxClasses.added.push(value)
                            }
                        }));
                        removedClasses.forEach((function(value) {
                            var indexInAdded = el.dxClasses.added.indexOf(value);
                            if (indexInAdded > -1) {
                                el.dxClasses.added.splice(indexInAdded, 1)
                            } else {
                                el.dxClasses.removed.push(value)
                            }
                        }))
                    };
                    InfernoWrapperComponent.prototype.componentDidMount = function() {
                        var el = inferno_1.findDOMfromVNode(this.$LI, true);
                        this.vDomElement = el;
                        _super.prototype.componentDidMount.call(this);
                        el.dxClasses = el.dxClasses || {
                            removed: [],
                            added: [],
                            previous: []
                        };
                        el.dxClasses.previous = (null === el || void 0 === el ? void 0 : el.className.length) ? el.className.split(" ") : []
                    };
                    InfernoWrapperComponent.prototype.componentDidUpdate = function() {
                        _super.prototype.componentDidUpdate.call(this);
                        var el = this.vDomElement;
                        if (null !== el) {
                            el.dxClasses.added.forEach((function(className) {
                                return el.classList.add(className)
                            }));
                            el.dxClasses.removed.forEach((function(className) {
                                return el.classList.remove(className)
                            }));
                            el.dxClasses.previous = el.className.length ? el.className.split(" ") : []
                        }
                    };
                    InfernoWrapperComponent.prototype.shouldComponentUpdate = function(nextProps, nextState) {
                        var shouldUpdate = _super.prototype.shouldComponentUpdate.call(this, nextProps, nextState);
                        if (shouldUpdate) {
                            this.vDomUpdateClasses()
                        }
                        return shouldUpdate
                    };
                    return InfernoWrapperComponent
                }(InfernoComponent);
                exports.InfernoWrapperComponent = InfernoWrapperComponent
            },
        61080:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/create_context.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __extends = this && this.__extends || (extendStatics = function(d, b) {
                    extendStatics = Object.setPrototypeOf || {
                        __proto__: []
                    }
                    instanceof Array && function(d, b) {
                        d.__proto__ = b
                    } || function(d, b) {
                        for (var p in b) {
                            if (Object.prototype.hasOwnProperty.call(b, p)) {
                                d[p] = b[p]
                            }
                        }
                    };
                    return extendStatics(d, b)
                }, function(d, b) {
                    if ("function" !== typeof b && null !== b) {
                        throw new TypeError("Class extends value " + String(b) + " is not a constructor or null")
                    }
                    extendStatics(d, b);

                    function __() {
                        this.constructor = d
                    }
                    d.prototype = null === b ? Object.create(b) : (__.prototype = b.prototype, new __)
                });
                var extendStatics;
                var __assign = this && this.__assign || function() {
                    __assign = Object.assign || function(t) {
                        for (var s, i = 1, n = arguments.length; i < n; i++) {
                            s = arguments[i];
                            for (var p in s) {
                                if (Object.prototype.hasOwnProperty.call(s, p)) {
                                    t[p] = s[p]
                                }
                            }
                        }
                        return t
                    };
                    return __assign.apply(this, arguments)
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createContext = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var contextId = 0;
                exports.createContext = function(defaultValue) {
                    var id = contextId++;
                    return {
                        id: id,
                        defaultValue: defaultValue,
                        Provider: function(_super) {
                            __extends(class_1, _super);

                            function class_1() {
                                return null !== _super && _super.apply(this, arguments) || this
                            }
                            class_1.prototype.getChildContext = function() {
                                var _a;
                                return __assign(__assign({}, this.context), (_a = {}, _a[id] = this.props.value || defaultValue, _a))
                            };
                            class_1.prototype.render = function() {
                                return this.props.children
                            };
                            return class_1
                        }(inferno_1.Component)
                    }
                }
            },
        43956:
            /*!********************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/effect.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffect = void 0;
                var InfernoEffect = function() {
                    function InfernoEffect(effect, dependency) {
                        this.dependency = dependency;
                        this.effect = effect;
                        this.destroy = effect()
                    }
                    InfernoEffect.prototype.update = function(dependency) {
                        var currentDependency = this.dependency;
                        if (dependency) {
                            this.dependency = dependency
                        }
                        if (!dependency || dependency.some((function(d, i) {
                                return currentDependency[i] !== d
                            }))) {
                            this.dispose();
                            this.destroy = this.effect()
                        }
                    };
                    InfernoEffect.prototype.dispose = function() {
                        if (this.destroy) {
                            this.destroy()
                        }
                    };
                    return InfernoEffect
                }();
                exports.InfernoEffect = InfernoEffect
            },
        53213:
            /*!*************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/effect_host.js ***!
              \*************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffectHost = void 0;
                exports.InfernoEffectHost = {
                    lockCount: 0,
                    lock: function() {
                        this.lockCount++
                    },
                    callbacks: [],
                    callEffects: function() {
                        this.lockCount--;
                        if (this.lockCount < 0) {
                            throw new Error("Unexpected Effect Call")
                        }
                        if (0 === this.lockCount) {
                            var effects = this.callbacks;
                            this.callbacks = [];
                            effects.forEach((function(callback) {
                                return callback()
                            }))
                        }
                    }
                }
            },
        74219:
            /*!*******************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/index.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                var __createBinding = this && this.__createBinding || (Object.create ? function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    Object.defineProperty(o, k2, {
                        enumerable: true,
                        get: function() {
                            return m[k]
                        }
                    })
                } : function(o, m, k, k2) {
                    if (void 0 === k2) {
                        k2 = k
                    }
                    o[k2] = m[k]
                });
                var __exportStar = this && this.__exportStar || function(m, exports) {
                    for (var p in m) {
                        if ("default" !== p && !Object.prototype.hasOwnProperty.call(exports, p)) {
                            __createBinding(exports, m, p)
                        }
                    }
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                __exportStar(__webpack_require__( /*! ./base_component */ 81589), exports);
                __exportStar(__webpack_require__( /*! ./create_context */ 61080), exports);
                __exportStar(__webpack_require__( /*! ./effect */ 43956), exports);
                __exportStar(__webpack_require__( /*! ./effect_host */ 53213), exports);
                __exportStar(__webpack_require__( /*! ./portal */ 53159), exports);
                __exportStar(__webpack_require__( /*! ./ref_object */ 86687), exports);
                __exportStar(__webpack_require__( /*! ./re_render_effect */ 31620), exports);
                __exportStar(__webpack_require__( /*! ./mocked/hydrate */ 67604), exports);
                __exportStar(__webpack_require__( /*! ./render_template */ 32423), exports);
                __exportStar(__webpack_require__( /*! ./normalize_styles */ 73084), exports)
            },
        67604:
            /*!****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/mocked/hydrate.js ***!
              \****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hydrate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var shared_1 = __webpack_require__( /*! ./shared */ 45786);

                function isSamePropsInnerHTML(dom, props) {
                    return Boolean(props && props.dangerouslySetInnerHTML && props.dangerouslySetInnerHTML.__html && function(dom, innerHTML) {
                        var tempdom = document.createElement("i");
                        tempdom.innerHTML = innerHTML;
                        return tempdom.innerHTML === dom.innerHTML
                    }(dom, props.dangerouslySetInnerHTML.__html))
                }

                function hydrateChildren(parentVNode, parentNode, currentNode, context, isSVG, lifecycle) {
                    var childFlags = parentVNode.childFlags;
                    var children = parentVNode.children;
                    var props = parentVNode.props;
                    var flags = parentVNode.flags;
                    if (1 !== childFlags) {
                        if (2 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                inferno_1._M(children, parentNode, context, isSVG, null, lifecycle)
                            } else {
                                currentNode = hydrateVNode(children, parentNode, currentNode, context, isSVG, lifecycle);
                                currentNode = currentNode ? currentNode.nextSibling : null
                            }
                        } else if (16 === childFlags) {
                            if (shared_1.isNull(currentNode)) {
                                parentNode.appendChild(document.createTextNode(children))
                            } else if (1 !== parentNode.childNodes.length || 3 !== currentNode.nodeType) {
                                parentNode.textContent = children
                            } else if (currentNode.nodeValue !== children) {
                                currentNode.nodeValue = children
                            }
                            currentNode = null
                        } else if (12 & childFlags) {
                            var prevVNodeIsTextNode = false;
                            for (var i = 0, len = children.length; i < len; ++i) {
                                var child = children[i];
                                if (shared_1.isNull(currentNode) || prevVNodeIsTextNode && (16 & child.flags) > 0) {
                                    inferno_1._M(child, parentNode, context, isSVG, currentNode, lifecycle)
                                } else {
                                    currentNode = hydrateVNode(child, parentNode, currentNode, context, isSVG, lifecycle);
                                    currentNode = currentNode ? currentNode.nextSibling : null
                                }
                                prevVNodeIsTextNode = (16 & child.flags) > 0
                            }
                        }
                        if (0 === (8192 & flags)) {
                            var nextSibling = null;
                            while (currentNode) {
                                nextSibling = currentNode.nextSibling;
                                parentNode.removeChild(currentNode);
                                currentNode = nextSibling
                            }
                        }
                    } else if (!shared_1.isNull(parentNode.firstChild) && !isSamePropsInnerHTML(parentNode, props)) {
                        parentNode.textContent = "";
                        if (448 & flags) {
                            parentNode.defaultValue = ""
                        }
                    }
                }

                function hydrateText(vNode, parentDOM, dom) {
                    if (3 !== dom.nodeType) {
                        parentDOM.replaceChild(vNode.dom = document.createTextNode(vNode.children), dom)
                    } else {
                        var text = vNode.children;
                        if (dom.nodeValue !== text) {
                            dom.nodeValue = text
                        }
                        vNode.dom = dom
                    }
                    return vNode.dom
                }

                function hydrateVNode(vNode, parentDOM, currentDom, context, isSVG, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (14 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, isClass, lifecycle) {
                            var type = vNode.type;
                            var ref = vNode.ref;
                            var props = vNode.props || inferno_1.EMPTY_OBJ;
                            var currentNode;
                            if (isClass) {
                                var instance = inferno_1._CI(vNode, type, props, context, isSVG, lifecycle);
                                var input = instance.$LI;
                                currentNode = hydrateVNode(input, parentDOM, dom, instance.$CX, isSVG, lifecycle);
                                inferno_1._MCCC(ref, instance, lifecycle)
                            } else {
                                input = inferno_1._HI(inferno_1._RFC(vNode, context));
                                currentNode = hydrateVNode(input, parentDOM, dom, context, isSVG, lifecycle);
                                vNode.children = input;
                                inferno_1._MFCC(vNode, lifecycle)
                            }
                            return currentNode
                        }(vNode, parentDOM, currentDom, context, isSVG, (4 & flags) > 0, lifecycle)
                    }
                    if (481 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var props = vNode.props;
                            var className = vNode.className;
                            var flags = vNode.flags;
                            var ref = vNode.ref;
                            isSVG = isSVG || (32 & flags) > 0;
                            if (1 !== dom.nodeType) {
                                inferno_1._ME(vNode, null, context, isSVG, null, lifecycle);
                                parentDOM.replaceChild(vNode.dom, dom)
                            } else {
                                vNode.dom = dom;
                                hydrateChildren(vNode, dom, dom.firstChild, context, isSVG, lifecycle);
                                if (!shared_1.isNull(props)) {
                                    inferno_1._MP(vNode, flags, props, dom, isSVG)
                                }
                                if (shared_1.isNullOrUndef(className)) {
                                    if ("" !== dom.className) {
                                        dom.removeAttribute("class")
                                    }
                                } else if (isSVG) {
                                    dom.setAttribute("class", className)
                                } else {
                                    dom.className = className
                                }
                                inferno_1._MR(ref, dom, lifecycle)
                            }
                            return vNode.dom
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    if (16 & flags) {
                        return hydrateText(vNode, parentDOM, currentDom)
                    }
                    if (512 & flags) {
                        return vNode.dom = currentDom
                    }
                    if (8192 & flags) {
                        return function(vNode, parentDOM, dom, context, isSVG, lifecycle) {
                            var children = vNode.children;
                            if (2 === vNode.childFlags) {
                                hydrateText(children, parentDOM, dom);
                                return children.dom
                            }
                            hydrateChildren(vNode, parentDOM, dom, context, isSVG, lifecycle);
                            return function(vNode) {
                                var flags;
                                var children;
                                while (vNode) {
                                    flags = vNode.flags;
                                    if (2033 & flags) {
                                        return vNode.dom
                                    }
                                    children = vNode.children;
                                    if (8192 & flags) {
                                        vNode = 2 === vNode.childFlags ? children : children[children.length - 1]
                                    } else if (4 & flags) {
                                        vNode = children.$LI
                                    } else {
                                        vNode = children
                                    }
                                }
                                return null
                            }(children[children.length - 1])
                        }(vNode, parentDOM, currentDom, context, isSVG, lifecycle)
                    }
                    shared_1.throwError();
                    return null
                }
                exports.hydrate = function(input, parentDOM, callback) {
                    var dom = parentDOM.firstChild;
                    if (shared_1.isNull(dom)) {
                        inferno_1.render(input, parentDOM, callback)
                    } else {
                        var lifecycle = [];
                        if (!shared_1.isInvalid(input)) {
                            dom = hydrateVNode(input, parentDOM, dom, {}, false, lifecycle)
                        }
                        while (dom && (dom = dom.nextSibling)) {
                            parentDOM.removeChild(dom)
                        }
                        if (lifecycle.length > 0) {
                            var listener = void 0;
                            while (void 0 !== (listener = lifecycle.shift())) {
                                listener()
                            }
                        }
                    }
                    parentDOM.$V = input;
                    if (shared_1.isFunction(callback)) {
                        callback()
                    }
                }
            },
        45786:
            /*!***************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/mocked/shared.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.throwError = exports.isNull = exports.isFunction = exports.isInvalid = exports.isNullOrUndef = exports.ERROR_MSG = void 0;
                exports.ERROR_MSG = "a runtime error occured! Use Inferno in development environment to find the error.";
                exports.isNullOrUndef = function(o) {
                    return void 0 === o || null === o
                };
                exports.isInvalid = function(o) {
                    return null === o || false === o || true === o || void 0 === o
                };
                exports.isFunction = function(o) {
                    return "function" === typeof o
                };
                exports.isNull = function(o) {
                    return null === o
                };
                exports.throwError = function(message) {
                    if (!message) {
                        message = exports.ERROR_MSG
                    }
                    throw new Error("Inferno Error: " + message)
                }
            },
        73084:
            /*!******************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/normalize_styles.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports) {
                var __read = this && this.__read || function(o, n) {
                    var m = "function" === typeof Symbol && o[Symbol.iterator];
                    if (!m) {
                        return o
                    }
                    var r, e, i = m.call(o),
                        ar = [];
                    try {
                        while ((void 0 === n || n-- > 0) && !(r = i.next()).done) {
                            ar.push(r.value)
                        }
                    } catch (error) {
                        e = {
                            error: error
                        }
                    } finally {
                        try {
                            if (r && !r.done && (m = i.return)) {
                                m.call(i)
                            }
                        } finally {
                            if (e) {
                                throw e.error
                            }
                        }
                    }
                    return ar
                };
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.normalizeStyles = void 0;
                var NUMBER_STYLES = new Set(["animationIterationCount", "borderImageOutset", "borderImageSlice", "border-imageWidth", "boxFlex", "boxFlexGroup", "boxOrdinalGroup", "columnCount", "fillOpacity", "flex", "flexGrow", "flexNegative", "flexOrder", "flexPositive", "flexShrink", "floodOpacity", "fontWeight", "gridColumn", "gridRow", "lineClamp", "lineHeight", "opacity", "order", "orphans", "stopOpacity", "strokeDasharray", "strokeDashoffset", "strokeMiterlimit", "strokeOpacity", "strokeWidth", "tabSize", "widows", "zIndex", "zoom"]);
                var uppercasePattern = /[A-Z]/g;
                exports.normalizeStyles = function(styles) {
                    if (!(styles instanceof Object)) {
                        return
                    }
                    return Object.entries(styles).reduce((function(acc, _a) {
                        var _b = __read(_a, 2),
                            key = _b[0],
                            value = _b[1];
                        acc[(str = key, str.replace(uppercasePattern, "-$&").toLowerCase())] = function(value) {
                            if ("number" === typeof value) {
                                return true
                            }
                            return !Number.isNaN(Number(value))
                        }(value) ? function(style, value) {
                            return NUMBER_STYLES.has(style) ? value : value + "px"
                        }(key, value) : value;
                        var str;
                        return acc
                    }), {})
                }
            },
        53159:
            /*!********************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/portal.js ***!
              \********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Portal = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                exports.Portal = function(_a) {
                    var container = _a.container,
                        children = _a.children;
                    if (container) {
                        return inferno_1.createPortal(children, container)
                    }
                    return null
                }
            },
        31620:
            /*!******************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/re_render_effect.js ***!
              \******************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.createReRenderEffect = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var effect_1 = __webpack_require__( /*! ./effect */ 43956);
                exports.createReRenderEffect = function() {
                    return new effect_1.InfernoEffect((function() {
                        inferno_1.rerender()
                    }), [])
                }
            },
        86687:
            /*!************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/ref_object.js ***!
              \************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                })
            },
        32423:
            /*!*****************************************************************************!*\
              !*** ../../node_modules/@devextreme/runtime/cjs/inferno/render_template.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.hasTemplate = exports.renderTemplate = void 0;
                var inferno_1 = __webpack_require__( /*! inferno */ 65414);
                var inferno_create_element_1 = __webpack_require__( /*! inferno-create-element */ 99038);
                exports.renderTemplate = function(template, props, _component) {
                    setTimeout((function() {
                        inferno_1.render(inferno_create_element_1.createElement(template, props), function(props) {
                            var _a, _b;
                            return (null === (_a = props.container) || void 0 === _a ? void 0 : _a.get(0)) || (null === (_b = props.item) || void 0 === _b ? void 0 : _b.get(0))
                        }(props))
                    }), 0)
                };
                exports.hasTemplate = function(name, properties, _component) {
                    var value = properties[name];
                    return !!value && "string" !== typeof value
                }
            },
        99038:
            /*!*******************************************************************!*\
              !*** ../../node_modules/inferno-create-element/dist/index.esm.js ***!
              \*******************************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    createElement: function() {
                        return createElement
                    }
                });
                var inferno__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__( /*! inferno */ 65414);

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isString(o) {
                    return "string" === typeof o
                }

                function isUndefined(o) {
                    return void 0 === o
                }
                var componentHooks = {
                    onComponentDidMount: 1,
                    onComponentDidUpdate: 1,
                    onComponentShouldUpdate: 1,
                    onComponentWillMount: 1,
                    onComponentWillUnmount: 1,
                    onComponentWillUpdate: 1
                };

                function createElement(type, props, _children) {
                    var arguments$1 = arguments;
                    var children;
                    var ref = null;
                    var key = null;
                    var className = null;
                    var flags = 0;
                    var newProps;
                    var childLen = arguments.length - 2;
                    if (1 === childLen) {
                        children = _children
                    } else if (childLen > 1) {
                        children = [];
                        while (childLen-- > 0) {
                            children[childLen] = arguments$1[childLen + 2]
                        }
                    }
                    if (isString(type)) {
                        flags = (0, inferno__WEBPACK_IMPORTED_MODULE_0__.getFlagsForElementVnode)(type);
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop in props) {
                                if ("className" === prop || "class" === prop) {
                                    className = props[prop]
                                } else if ("key" === prop) {
                                    key = props.key
                                } else if ("children" === prop && isUndefined(children)) {
                                    children = props.children
                                } else if ("ref" === prop) {
                                    ref = props.ref
                                } else {
                                    if ("contenteditable" === prop) {
                                        flags |= 4096
                                    }
                                    newProps[prop] = props[prop]
                                }
                            }
                        }
                    } else {
                        flags = 2;
                        if (!isUndefined(children)) {
                            if (!props) {
                                props = {}
                            }
                            props.children = children
                        }
                        if (!isNullOrUndef(props)) {
                            newProps = {};
                            for (var prop$1 in props) {
                                if ("key" === prop$1) {
                                    key = props.key
                                } else if ("ref" === prop$1) {
                                    ref = props.ref
                                } else if (1 === componentHooks[prop$1]) {
                                    if (!ref) {
                                        ref = {}
                                    }
                                    ref[prop$1] = props[prop$1]
                                } else {
                                    newProps[prop$1] = props[prop$1]
                                }
                            }
                        }
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createComponentVNode)(flags, type, newProps, key, ref)
                    }
                    if (8192 & flags) {
                        return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createFragment)(1 === childLen ? [children] : children, 0, key)
                    }
                    return (0, inferno__WEBPACK_IMPORTED_MODULE_0__.createVNode)(flags, type, className, children, 0, newProps, key, ref)
                }
            },
        65414:
            /*!***********************************************************!*\
              !*** ../../node_modules/inferno/index.esm.js + 1 modules ***!
              \***********************************************************/
            function(__unused_webpack_module, __webpack_exports__, __webpack_require__) {
                __webpack_require__.r(__webpack_exports__);
                __webpack_require__.d(__webpack_exports__, {
                    Component: function() {
                        return Component
                    },
                    EMPTY_OBJ: function() {
                        return EMPTY_OBJ
                    },
                    Fragment: function() {
                        return Fragment
                    },
                    _CI: function() {
                        return createClassComponentInstance
                    },
                    _HI: function() {
                        return normalizeRoot
                    },
                    _M: function() {
                        return mount
                    },
                    _MCCC: function() {
                        return mountClassComponentCallbacks
                    },
                    _ME: function() {
                        return mountElement
                    },
                    _MFCC: function() {
                        return mountFunctionalComponentCallbacks
                    },
                    _MP: function() {
                        return mountProps
                    },
                    _MR: function() {
                        return mountRef
                    },
                    _RFC: function() {
                        return renderFunctionalComponent
                    },
                    __render: function() {
                        return __render
                    },
                    createComponentVNode: function() {
                        return createComponentVNode
                    },
                    createFragment: function() {
                        return createFragment
                    },
                    createPortal: function() {
                        return createPortal
                    },
                    createRef: function() {
                        return createRef
                    },
                    createRenderer: function() {
                        return createRenderer
                    },
                    createTextVNode: function() {
                        return createTextVNode
                    },
                    createVNode: function() {
                        return createVNode
                    },
                    directClone: function() {
                        return directClone
                    },
                    findDOMfromVNode: function() {
                        return findDOMfromVNode
                    },
                    forwardRef: function() {
                        return forwardRef
                    },
                    getFlagsForElementVnode: function() {
                        return getFlagsForElementVnode
                    },
                    linkEvent: function() {
                        return linkEvent
                    },
                    normalizeProps: function() {
                        return normalizeProps
                    },
                    options: function() {
                        return options
                    },
                    render: function() {
                        return render
                    },
                    rerender: function() {
                        return rerender
                    },
                    version: function() {
                        return version
                    }
                });
                var isArray = Array.isArray;

                function isStringOrNumber(o) {
                    var type = typeof o;
                    return "string" === type || "number" === type
                }

                function isNullOrUndef(o) {
                    return void 0 === o || null === o
                }

                function isInvalid(o) {
                    return null === o || false === o || true === o || void 0 === o
                }

                function isFunction(o) {
                    return "function" === typeof o
                }

                function isString(o) {
                    return "string" === typeof o
                }

                function isNull(o) {
                    return null === o
                }

                function combineFrom(first, second) {
                    var out = {};
                    if (first) {
                        for (var key in first) {
                            out[key] = first[key]
                        }
                    }
                    if (second) {
                        for (var key$1 in second) {
                            out[key$1] = second[key$1]
                        }
                    }
                    return out
                }

                function linkEvent(data, event) {
                    if (isFunction(event)) {
                        return {
                            data: data,
                            event: event
                        }
                    }
                    return null
                }

                function isLinkEventObject(o) {
                    return !isNull(o) && "object" === typeof o
                }
                var EMPTY_OBJ = {};
                var Fragment = "$F";

                function normalizeEventName(name) {
                    return name.substr(2).toLowerCase()
                }

                function appendChild(parentDOM, dom) {
                    parentDOM.appendChild(dom)
                }

                function insertOrAppend(parentDOM, newNode, nextNode) {
                    if (isNull(nextNode)) {
                        appendChild(parentDOM, newNode)
                    } else {
                        parentDOM.insertBefore(newNode, nextNode)
                    }
                }

                function removeChild(parentDOM, childNode) {
                    parentDOM.removeChild(childNode)
                }

                function callAll(arrayFn) {
                    for (var i = 0; i < arrayFn.length; i++) {
                        arrayFn[i]()
                    }
                }

                function findChildVNode(vNode, startEdge, flags) {
                    var children = vNode.children;
                    if (4 & flags) {
                        return children.$LI
                    }
                    if (8192 & flags) {
                        return 2 === vNode.childFlags ? children : children[startEdge ? 0 : children.length - 1]
                    }
                    return children
                }

                function findDOMfromVNode(vNode, startEdge) {
                    var flags;
                    while (vNode) {
                        flags = vNode.flags;
                        if (2033 & flags) {
                            return vNode.dom
                        }
                        vNode = findChildVNode(vNode, startEdge, flags)
                    }
                    return null
                }

                function removeVNodeDOM(vNode, parentDOM) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            removeChild(parentDOM, vNode.dom);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    removeVNodeDOM(children[i], parentDOM)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function moveVNodeDOM(vNode, parentDOM, nextNode) {
                    do {
                        var flags = vNode.flags;
                        if (2033 & flags) {
                            insertOrAppend(parentDOM, vNode.dom, nextNode);
                            return
                        }
                        var children = vNode.children;
                        if (4 & flags) {
                            vNode = children.$LI
                        }
                        if (8 & flags) {
                            vNode = children
                        }
                        if (8192 & flags) {
                            if (2 === vNode.childFlags) {
                                vNode = children
                            } else {
                                for (var i = 0, len = children.length; i < len; ++i) {
                                    moveVNodeDOM(children[i], parentDOM, nextNode)
                                }
                                return
                            }
                        }
                    } while (vNode)
                }

                function createDerivedState(instance, nextProps, state) {
                    if (instance.constructor.getDerivedStateFromProps) {
                        return combineFrom(state, instance.constructor.getDerivedStateFromProps(nextProps, state))
                    }
                    return state
                }
                var renderCheck = {
                    v: false
                };
                var options = {
                    componentComparator: null,
                    createVNode: null,
                    renderComplete: null
                };

                function setTextContent(dom, children) {
                    dom.textContent = children
                }

                function isLastValueSameLinkEvent(lastValue, nextValue) {
                    return isLinkEventObject(lastValue) && lastValue.event === nextValue.event && lastValue.data === nextValue.data
                }

                function mergeUnsetProperties(to, from) {
                    for (var propName in from) {
                        if (o = to[propName], void 0 === o) {
                            to[propName] = from[propName]
                        }
                    }
                    var o;
                    return to
                }

                function safeCall1(method, arg1) {
                    return !!isFunction(method) && (method(arg1), true)
                }

                function V(childFlags, children, className, flags, key, props, ref, type) {
                    this.childFlags = childFlags;
                    this.children = children;
                    this.className = className;
                    this.dom = null;
                    this.flags = flags;
                    this.key = void 0 === key ? null : key;
                    this.props = void 0 === props ? null : props;
                    this.ref = void 0 === ref ? null : ref;
                    this.type = type
                }

                function createVNode(flags, type, className, children, childFlags, props, key, ref) {
                    var childFlag = void 0 === childFlags ? 1 : childFlags;
                    var vNode = new V(childFlag, children, className, flags, key, props, ref, type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    if (0 === childFlag) {
                        normalizeChildren(vNode, vNode.children)
                    }
                    return vNode
                }

                function createComponentVNode(flags, type, props, key, ref) {
                    flags = function(flags, type) {
                        if (12 & flags) {
                            return flags
                        }
                        if (type.prototype && type.prototype.render) {
                            return 4
                        }
                        if (type.render) {
                            return 32776
                        }
                        return 8
                    }(flags, type);
                    var vNode = new V(1, null, null, flags, key, function(flags, type, props) {
                        var defaultProps = (32768 & flags ? type.render : type).defaultProps;
                        if (isNullOrUndef(defaultProps)) {
                            return props
                        }
                        if (isNullOrUndef(props)) {
                            return combineFrom(defaultProps, null)
                        }
                        return mergeUnsetProperties(props, defaultProps)
                    }(flags, type, props), function(flags, type, ref) {
                        if (4 & flags) {
                            return ref
                        }
                        var defaultHooks = (32768 & flags ? type.render : type).defaultHooks;
                        if (isNullOrUndef(defaultHooks)) {
                            return ref
                        }
                        if (isNullOrUndef(ref)) {
                            return defaultHooks
                        }
                        return mergeUnsetProperties(ref, defaultHooks)
                    }(flags, type, ref), type);
                    if (options.createVNode) {
                        options.createVNode(vNode)
                    }
                    return vNode
                }

                function createTextVNode(text, key) {
                    return new V(1, isNullOrUndef(text) || true === text || false === text ? "" : text, null, 16, key, null, null, null)
                }

                function createFragment(children, childFlags, key) {
                    var fragment = createVNode(8192, 8192, null, children, childFlags, null, key, null);
                    switch (fragment.childFlags) {
                        case 1:
                            fragment.children = createVoidVNode();
                            fragment.childFlags = 2;
                            break;
                        case 16:
                            fragment.children = [createTextVNode(children)];
                            fragment.childFlags = 4
                    }
                    return fragment
                }

                function normalizeProps(vNode) {
                    var props = vNode.props;
                    if (props) {
                        var flags = vNode.flags;
                        if (481 & flags) {
                            if (void 0 !== props.children && isNullOrUndef(vNode.children)) {
                                normalizeChildren(vNode, props.children)
                            }
                            if (void 0 !== props.className) {
                                if (isNullOrUndef(vNode.className)) {
                                    vNode.className = props.className || null
                                }
                                props.className = void 0
                            }
                        }
                        if (void 0 !== props.key) {
                            vNode.key = props.key;
                            props.key = void 0
                        }
                        if (void 0 !== props.ref) {
                            if (8 & flags) {
                                vNode.ref = combineFrom(vNode.ref, props.ref)
                            } else {
                                vNode.ref = props.ref
                            }
                            props.ref = void 0
                        }
                    }
                    return vNode
                }

                function directClone(vNodeToClone) {
                    var flags = -16385 & vNodeToClone.flags;
                    var props = vNodeToClone.props;
                    if (14 & flags) {
                        if (!isNull(props)) {
                            var propsToClone = props;
                            props = {};
                            for (var key in propsToClone) {
                                props[key] = propsToClone[key]
                            }
                        }
                    }
                    if (0 === (8192 & flags)) {
                        return new V(vNodeToClone.childFlags, vNodeToClone.children, vNodeToClone.className, flags, vNodeToClone.key, props, vNodeToClone.ref, vNodeToClone.type)
                    }
                    return function(vNodeToClone) {
                        var oldChildren = vNodeToClone.children;
                        var childFlags = vNodeToClone.childFlags;
                        return createFragment(2 === childFlags ? directClone(oldChildren) : oldChildren.map(directClone), childFlags, vNodeToClone.key)
                    }(vNodeToClone)
                }

                function createVoidVNode() {
                    return createTextVNode("", null)
                }

                function createPortal(children, container) {
                    var normalizedRoot = normalizeRoot(children);
                    return createVNode(1024, 1024, null, normalizedRoot, 0, null, normalizedRoot.key, container)
                }

                function _normalizeVNodes(nodes, result, index, currentKey) {
                    for (var len = nodes.length; index < len; index++) {
                        var n = nodes[index];
                        if (!isInvalid(n)) {
                            var newKey = currentKey + "$" + index;
                            if (isArray(n)) {
                                _normalizeVNodes(n, result, 0, newKey)
                            } else {
                                if (isStringOrNumber(n)) {
                                    n = createTextVNode(n, newKey)
                                } else {
                                    var oldKey = n.key;
                                    var isPrefixedKey = isString(oldKey) && "$" === oldKey[0];
                                    if (81920 & n.flags || isPrefixedKey) {
                                        n = directClone(n)
                                    }
                                    n.flags |= 65536;
                                    if (!isPrefixedKey) {
                                        if (isNull(oldKey)) {
                                            n.key = newKey
                                        } else {
                                            n.key = currentKey + oldKey
                                        }
                                    } else if (oldKey.substring(0, currentKey.length) !== currentKey) {
                                        n.key = currentKey + oldKey
                                    }
                                }
                                result.push(n)
                            }
                        }
                    }
                }

                function getFlagsForElementVnode(type) {
                    switch (type) {
                        case "svg":
                            return 32;
                        case "input":
                            return 64;
                        case "select":
                            return 256;
                        case "textarea":
                            return 128;
                        case Fragment:
                            return 8192;
                        default:
                            return 1
                    }
                }

                function normalizeChildren(vNode, children) {
                    var newChildren;
                    var newChildFlags = 1;
                    if (isInvalid(children)) {
                        newChildren = children
                    } else if (isStringOrNumber(children)) {
                        newChildFlags = 16;
                        newChildren = children
                    } else if (isArray(children)) {
                        var len = children.length;
                        for (var i = 0; i < len; ++i) {
                            var n = children[i];
                            if (isInvalid(n) || isArray(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                _normalizeVNodes(children, newChildren, i, "");
                                break
                            } else if (isStringOrNumber(n)) {
                                newChildren = newChildren || children.slice(0, i);
                                newChildren.push(createTextVNode(n, "$" + i))
                            } else {
                                var key = n.key;
                                var needsCloning = (81920 & n.flags) > 0;
                                var isNullKey = isNull(key);
                                var isPrefixed = isString(key) && "$" === key[0];
                                if (needsCloning || isNullKey || isPrefixed) {
                                    newChildren = newChildren || children.slice(0, i);
                                    if (needsCloning || isPrefixed) {
                                        n = directClone(n)
                                    }
                                    if (isNullKey || isPrefixed) {
                                        n.key = "$" + i
                                    }
                                    newChildren.push(n)
                                } else if (newChildren) {
                                    newChildren.push(n)
                                }
                                n.flags |= 65536
                            }
                        }
                        newChildren = newChildren || children;
                        if (0 === newChildren.length) {
                            newChildFlags = 1
                        } else {
                            newChildFlags = 8
                        }
                    } else {
                        newChildren = children;
                        newChildren.flags |= 65536;
                        if (81920 & children.flags) {
                            newChildren = directClone(children)
                        }
                        newChildFlags = 2
                    }
                    vNode.children = newChildren;
                    vNode.childFlags = newChildFlags;
                    return vNode
                }

                function normalizeRoot(input) {
                    if (isInvalid(input) || isStringOrNumber(input)) {
                        return createTextVNode(input, null)
                    }
                    if (isArray(input)) {
                        return createFragment(input, 0, null)
                    }
                    return 16384 & input.flags ? directClone(input) : input
                }
                var xlinkNS = "http://www.w3.org/1999/xlink";
                var xmlNS = "http://www.w3.org/XML/1998/namespace";
                var namespaces = {
                    "xlink:actuate": xlinkNS,
                    "xlink:arcrole": xlinkNS,
                    "xlink:href": xlinkNS,
                    "xlink:role": xlinkNS,
                    "xlink:show": xlinkNS,
                    "xlink:title": xlinkNS,
                    "xlink:type": xlinkNS,
                    "xml:base": xmlNS,
                    "xml:lang": xmlNS,
                    "xml:space": xmlNS
                };

                function getDelegatedEventObject(v) {
                    return {
                        onClick: v,
                        onDblClick: v,
                        onFocusIn: v,
                        onFocusOut: v,
                        onKeyDown: v,
                        onKeyPress: v,
                        onKeyUp: v,
                        onMouseDown: v,
                        onMouseMove: v,
                        onMouseUp: v,
                        onTouchEnd: v,
                        onTouchMove: v,
                        onTouchStart: v
                    }
                }
                var attachedEventCounts = getDelegatedEventObject(0);
                var attachedEvents = getDelegatedEventObject(null);
                var syntheticEvents = getDelegatedEventObject(true);

                function updateOrAddSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (!eventsObject) {
                        eventsObject = dom.$EV = getDelegatedEventObject(null)
                    }
                    if (!eventsObject[name]) {
                        if (1 === ++attachedEventCounts[name]) {
                            attachedEvents[name] = function(name) {
                                var attachedEvent = "onClick" === name || "onDblClick" === name ? function(name) {
                                    return function(event) {
                                        if (0 !== event.button) {
                                            event.stopPropagation();
                                            return
                                        }
                                        dispatchEvents(event, true, name, extendEventProperties(event))
                                    }
                                }(name) : function(name) {
                                    return function(event) {
                                        dispatchEvents(event, false, name, extendEventProperties(event))
                                    }
                                }(name);
                                document.addEventListener(normalizeEventName(name), attachedEvent);
                                return attachedEvent
                            }(name)
                        }
                    }
                    return eventsObject
                }

                function unmountSyntheticEvent(name, dom) {
                    var eventsObject = dom.$EV;
                    if (eventsObject && eventsObject[name]) {
                        if (0 === --attachedEventCounts[name]) {
                            document.removeEventListener(normalizeEventName(name), attachedEvents[name]);
                            attachedEvents[name] = null
                        }
                        eventsObject[name] = null
                    }
                }

                function dispatchEvents(event, isClick, name, eventData) {
                    var dom = function(event) {
                        return isFunction(event.composedPath) ? event.composedPath()[0] : event.target
                    }(event);
                    do {
                        if (isClick && dom.disabled) {
                            return
                        }
                        var eventsObject = dom.$EV;
                        if (eventsObject) {
                            var currentEvent = eventsObject[name];
                            if (currentEvent) {
                                eventData.dom = dom;
                                currentEvent.event ? currentEvent.event(currentEvent.data, event) : currentEvent(event);
                                if (event.cancelBubble) {
                                    return
                                }
                            }
                        }
                        dom = dom.parentNode
                    } while (!isNull(dom))
                }

                function stopPropagation() {
                    this.cancelBubble = true;
                    if (!this.immediatePropagationStopped) {
                        this.stopImmediatePropagation()
                    }
                }

                function isDefaultPrevented() {
                    return this.defaultPrevented
                }

                function isPropagationStopped() {
                    return this.cancelBubble
                }

                function extendEventProperties(event) {
                    var eventData = {
                        dom: document
                    };
                    event.isDefaultPrevented = isDefaultPrevented;
                    event.isPropagationStopped = isPropagationStopped;
                    event.stopPropagation = stopPropagation;
                    Object.defineProperty(event, "currentTarget", {
                        configurable: true,
                        get: function() {
                            return eventData.dom
                        }
                    });
                    return eventData
                }

                function triggerEventListener(props, methodName, e) {
                    if (props[methodName]) {
                        var listener = props[methodName];
                        if (listener.event) {
                            listener.event(listener.data, e)
                        } else {
                            listener(e)
                        }
                    } else {
                        var nativeListenerName = methodName.toLowerCase();
                        if (props[nativeListenerName]) {
                            props[nativeListenerName](e)
                        }
                    }
                }

                function createWrappedFunction(methodName, applyValue) {
                    var fnMethod = function(e) {
                        var vNode = this.$V;
                        if (!vNode) {
                            return
                        }
                        var props = vNode.props || EMPTY_OBJ;
                        var dom = vNode.dom;
                        if (isString(methodName)) {
                            triggerEventListener(props, methodName, e)
                        } else {
                            for (var i = 0; i < methodName.length; ++i) {
                                triggerEventListener(props, methodName[i], e)
                            }
                        }
                        if (isFunction(applyValue)) {
                            var newVNode = this.$V;
                            var newProps = newVNode.props || EMPTY_OBJ;
                            applyValue(newProps, dom, false, newVNode)
                        }
                    };
                    Object.defineProperty(fnMethod, "wrapped", {
                        configurable: false,
                        enumerable: false,
                        value: true,
                        writable: false
                    });
                    return fnMethod
                }

                function attachEvent(dom, eventName, handler) {
                    var previousKey = "$" + eventName;
                    var previousArgs = dom[previousKey];
                    if (previousArgs) {
                        if (previousArgs[1].wrapped) {
                            return
                        }
                        dom.removeEventListener(previousArgs[0], previousArgs[1]);
                        dom[previousKey] = null
                    }
                    if (isFunction(handler)) {
                        dom.addEventListener(eventName, handler);
                        dom[previousKey] = [eventName, handler]
                    }
                }

                function isCheckedType(type) {
                    return "checkbox" === type || "radio" === type
                }
                var onTextInputChange = createWrappedFunction("onInput", applyValueInput);
                var wrappedOnChange = createWrappedFunction(["onClick", "onChange"], applyValueInput);

                function emptywrapper(event) {
                    event.stopPropagation()
                }
                emptywrapper.wrapped = true;

                function applyValueInput(nextPropsOrEmpty, dom) {
                    var type = nextPropsOrEmpty.type;
                    var value = nextPropsOrEmpty.value;
                    var checked = nextPropsOrEmpty.checked;
                    var multiple = nextPropsOrEmpty.multiple;
                    var defaultValue = nextPropsOrEmpty.defaultValue;
                    var hasValue = !isNullOrUndef(value);
                    if (type && type !== dom.type) {
                        dom.setAttribute("type", type)
                    }
                    if (!isNullOrUndef(multiple) && multiple !== dom.multiple) {
                        dom.multiple = multiple
                    }
                    if (!isNullOrUndef(defaultValue) && !hasValue) {
                        dom.defaultValue = defaultValue + ""
                    }
                    if (isCheckedType(type)) {
                        if (hasValue) {
                            dom.value = value
                        }
                        if (!isNullOrUndef(checked)) {
                            dom.checked = checked
                        }
                    } else if (hasValue && dom.value !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    } else if (!isNullOrUndef(checked)) {
                        dom.checked = checked
                    }
                }

                function updateChildOptions(vNode, value) {
                    if ("option" === vNode.type) {
                        ! function(vNode, value) {
                            var props = vNode.props || EMPTY_OBJ;
                            var dom = vNode.dom;
                            dom.value = props.value;
                            if (props.value === value || isArray(value) && -1 !== value.indexOf(props.value)) {
                                dom.selected = true
                            } else if (!isNullOrUndef(value) || !isNullOrUndef(props.selected)) {
                                dom.selected = props.selected || false
                            }
                        }(vNode, value)
                    } else {
                        var children = vNode.children;
                        var flags = vNode.flags;
                        if (4 & flags) {
                            updateChildOptions(children.$LI, value)
                        } else if (8 & flags) {
                            updateChildOptions(children, value)
                        } else if (2 === vNode.childFlags) {
                            updateChildOptions(children, value)
                        } else if (12 & vNode.childFlags) {
                            for (var i = 0, len = children.length; i < len; ++i) {
                                updateChildOptions(children[i], value)
                            }
                        }
                    }
                }
                var onSelectChange = createWrappedFunction("onChange", applyValueSelect);

                function applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode) {
                    var multiplePropInBoolean = Boolean(nextPropsOrEmpty.multiple);
                    if (!isNullOrUndef(nextPropsOrEmpty.multiple) && multiplePropInBoolean !== dom.multiple) {
                        dom.multiple = multiplePropInBoolean
                    }
                    var index = nextPropsOrEmpty.selectedIndex;
                    if (-1 === index) {
                        dom.selectedIndex = -1
                    }
                    var childFlags = vNode.childFlags;
                    if (1 !== childFlags) {
                        var value = nextPropsOrEmpty.value;
                        if ((o = index, "number" === typeof o) && index > -1 && dom.options[index]) {
                            value = dom.options[index].value
                        }
                        if (mounting && isNullOrUndef(value)) {
                            value = nextPropsOrEmpty.defaultValue
                        }
                        updateChildOptions(vNode, value)
                    }
                    var o
                }
                var onTextareaInputChange = createWrappedFunction("onInput", applyValueTextArea);
                var wrappedOnChange$1 = createWrappedFunction("onChange");

                function applyValueTextArea(nextPropsOrEmpty, dom, mounting) {
                    var value = nextPropsOrEmpty.value;
                    var domValue = dom.value;
                    if (isNullOrUndef(value)) {
                        if (mounting) {
                            var defaultValue = nextPropsOrEmpty.defaultValue;
                            if (!isNullOrUndef(defaultValue) && defaultValue !== domValue) {
                                dom.defaultValue = defaultValue;
                                dom.value = defaultValue
                            }
                        }
                    } else if (domValue !== value) {
                        dom.defaultValue = value;
                        dom.value = value
                    }
                }

                function processElement(flags, vNode, dom, nextPropsOrEmpty, mounting, isControlled) {
                    if (64 & flags) {
                        applyValueInput(nextPropsOrEmpty, dom)
                    } else if (256 & flags) {
                        applyValueSelect(nextPropsOrEmpty, dom, mounting, vNode)
                    } else if (128 & flags) {
                        applyValueTextArea(nextPropsOrEmpty, dom, mounting)
                    }
                    if (isControlled) {
                        dom.$V = vNode
                    }
                }

                function addFormElementEventHandlers(flags, dom, nextPropsOrEmpty) {
                    if (64 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            if (isCheckedType(nextPropsOrEmpty.type)) {
                                attachEvent(dom, "change", wrappedOnChange);
                                attachEvent(dom, "click", emptywrapper)
                            } else {
                                attachEvent(dom, "input", onTextInputChange)
                            }
                        }(dom, nextPropsOrEmpty)
                    } else if (256 & flags) {
                        ! function(dom) {
                            attachEvent(dom, "change", onSelectChange)
                        }(dom)
                    } else if (128 & flags) {
                        ! function(dom, nextPropsOrEmpty) {
                            attachEvent(dom, "input", onTextareaInputChange);
                            if (nextPropsOrEmpty.onChange) {
                                attachEvent(dom, "change", wrappedOnChange$1)
                            }
                        }(dom, nextPropsOrEmpty)
                    }
                }

                function isControlledFormElement(nextPropsOrEmpty) {
                    return nextPropsOrEmpty.type && isCheckedType(nextPropsOrEmpty.type) ? !isNullOrUndef(nextPropsOrEmpty.checked) : !isNullOrUndef(nextPropsOrEmpty.value)
                }

                function createRef() {
                    return {
                        current: null
                    }
                }

                function forwardRef(render) {
                    return {
                        render: render
                    }
                }

                function unmountRef(ref) {
                    if (ref) {
                        if (!safeCall1(ref, null) && ref.current) {
                            ref.current = null
                        }
                    }
                }

                function mountRef(ref, value, lifecycle) {
                    if (ref && (isFunction(ref) || void 0 !== ref.current)) {
                        lifecycle.push((function() {
                            if (!safeCall1(ref, value) && void 0 !== ref.current) {
                                ref.current = value
                            }
                        }))
                    }
                }

                function remove(vNode, parentDOM) {
                    unmount(vNode);
                    removeVNodeDOM(vNode, parentDOM)
                }

                function unmount(vNode) {
                    var flags = vNode.flags;
                    var children = vNode.children;
                    var ref;
                    if (481 & flags) {
                        ref = vNode.ref;
                        var props = vNode.props;
                        unmountRef(ref);
                        var childFlags = vNode.childFlags;
                        if (!isNull(props)) {
                            var keys = Object.keys(props);
                            for (var i = 0, len = keys.length; i < len; i++) {
                                var key = keys[i];
                                if (syntheticEvents[key]) {
                                    unmountSyntheticEvent(key, vNode.dom)
                                }
                            }
                        }
                        if (12 & childFlags) {
                            unmountAllChildren(children)
                        } else if (2 === childFlags) {
                            unmount(children)
                        }
                    } else if (children) {
                        if (4 & flags) {
                            if (isFunction(children.componentWillUnmount)) {
                                children.componentWillUnmount()
                            }
                            unmountRef(vNode.ref);
                            children.$UN = true;
                            unmount(children.$LI)
                        } else if (8 & flags) {
                            ref = vNode.ref;
                            if (!isNullOrUndef(ref) && isFunction(ref.onComponentWillUnmount)) {
                                ref.onComponentWillUnmount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                            }
                            unmount(children)
                        } else if (1024 & flags) {
                            remove(children, vNode.ref)
                        } else if (8192 & flags) {
                            if (12 & vNode.childFlags) {
                                unmountAllChildren(children)
                            }
                        }
                    }
                }

                function unmountAllChildren(children) {
                    for (var i = 0, len = children.length; i < len; ++i) {
                        unmount(children[i])
                    }
                }

                function clearDOM(dom) {
                    dom.textContent = ""
                }

                function removeAllChildren(dom, vNode, children) {
                    unmountAllChildren(children);
                    if (8192 & vNode.flags) {
                        removeVNodeDOM(vNode, dom)
                    } else {
                        clearDOM(dom)
                    }
                }

                function patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom) {
                    var lastHtml = lastValue && lastValue.__html || "";
                    var nextHtml = nextValue && nextValue.__html || "";
                    if (lastHtml !== nextHtml) {
                        if (!isNullOrUndef(nextHtml) && ! function(dom, innerHTML) {
                                var tempdom = document.createElement("i");
                                tempdom.innerHTML = innerHTML;
                                return tempdom.innerHTML === dom.innerHTML
                            }(dom, nextHtml)) {
                            if (!isNull(lastVNode)) {
                                if (12 & lastVNode.childFlags) {
                                    unmountAllChildren(lastVNode.children)
                                } else if (2 === lastVNode.childFlags) {
                                    unmount(lastVNode.children)
                                }
                                lastVNode.children = null;
                                lastVNode.childFlags = 1
                            }
                            dom.innerHTML = nextHtml
                        }
                    }
                }

                function patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode) {
                    switch (prop) {
                        case "children":
                        case "childrenType":
                        case "className":
                        case "defaultValue":
                        case "key":
                        case "multiple":
                        case "ref":
                        case "selectedIndex":
                            break;
                        case "autoFocus":
                            dom.autofocus = !!nextValue;
                            break;
                        case "allowfullscreen":
                        case "autoplay":
                        case "capture":
                        case "checked":
                        case "controls":
                        case "default":
                        case "disabled":
                        case "hidden":
                        case "indeterminate":
                        case "loop":
                        case "muted":
                        case "novalidate":
                        case "open":
                        case "readOnly":
                        case "required":
                        case "reversed":
                        case "scoped":
                        case "seamless":
                        case "selected":
                            dom[prop] = !!nextValue;
                            break;
                        case "defaultChecked":
                        case "value":
                        case "volume":
                            if (hasControlledValue && "value" === prop) {
                                break
                            }
                            var value = isNullOrUndef(nextValue) ? "" : nextValue;
                            if (dom[prop] !== value) {
                                dom[prop] = value
                            }
                            break;
                        case "style":
                            ! function(lastAttrValue, nextAttrValue, dom) {
                                if (isNullOrUndef(nextAttrValue)) {
                                    dom.removeAttribute("style");
                                    return
                                }
                                var domStyle = dom.style;
                                var style;
                                var value;
                                if (isString(nextAttrValue)) {
                                    domStyle.cssText = nextAttrValue;
                                    return
                                }
                                if (!isNullOrUndef(lastAttrValue) && !isString(lastAttrValue)) {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        if (value !== lastAttrValue[style]) {
                                            domStyle.setProperty(style, value)
                                        }
                                    }
                                    for (style in lastAttrValue) {
                                        if (isNullOrUndef(nextAttrValue[style])) {
                                            domStyle.removeProperty(style)
                                        }
                                    }
                                } else {
                                    for (style in nextAttrValue) {
                                        value = nextAttrValue[style];
                                        domStyle.setProperty(style, value)
                                    }
                                }
                            }(lastValue, nextValue, dom);
                            break;
                        case "dangerouslySetInnerHTML":
                            patchDangerInnerHTML(lastValue, nextValue, lastVNode, dom);
                            break;
                        default:
                            if (syntheticEvents[prop]) {
                                ! function(name, lastEvent, nextEvent, dom) {
                                    if (isFunction(nextEvent)) {
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else if (isLinkEventObject(nextEvent)) {
                                        if (isLastValueSameLinkEvent(lastEvent, nextEvent)) {
                                            return
                                        }
                                        updateOrAddSyntheticEvent(name, dom)[name] = nextEvent
                                    } else {
                                        unmountSyntheticEvent(name, dom)
                                    }
                                }(prop, lastValue, nextValue, dom)
                            } else if (111 === prop.charCodeAt(0) && 110 === prop.charCodeAt(1)) {
                                ! function(name, lastValue, nextValue, dom) {
                                    if (isLinkEventObject(nextValue)) {
                                        if (isLastValueSameLinkEvent(lastValue, nextValue)) {
                                            return
                                        }
                                        nextValue = function(nextValue) {
                                            var ev = nextValue.event;
                                            return function(e) {
                                                ev(nextValue.data, e)
                                            }
                                        }(nextValue)
                                    }
                                    attachEvent(dom, normalizeEventName(name), nextValue)
                                }(prop, lastValue, nextValue, dom)
                            } else if (isNullOrUndef(nextValue)) {
                                dom.removeAttribute(prop)
                            } else if (isSVG && namespaces[prop]) {
                                dom.setAttributeNS(namespaces[prop], prop, nextValue)
                            } else {
                                dom.setAttribute(prop, nextValue)
                            }
                    }
                }

                function mountProps(vNode, flags, props, dom, isSVG) {
                    var hasControlledValue = false;
                    var isFormElement = (448 & flags) > 0;
                    if (isFormElement) {
                        hasControlledValue = isControlledFormElement(props);
                        if (hasControlledValue) {
                            addFormElementEventHandlers(flags, dom, props)
                        }
                    }
                    for (var prop in props) {
                        patchProp(prop, null, props[prop], dom, isSVG, hasControlledValue, null)
                    }
                    if (isFormElement) {
                        processElement(flags, vNode, dom, props, true, hasControlledValue)
                    }
                }

                function renderNewInput(instance, props, context) {
                    var nextInput = normalizeRoot(instance.render(props, instance.state, context));
                    var childContext = context;
                    if (isFunction(instance.getChildContext)) {
                        childContext = combineFrom(context, instance.getChildContext())
                    }
                    instance.$CX = childContext;
                    return nextInput
                }

                function createClassComponentInstance(vNode, Component, props, context, isSVG, lifecycle) {
                    var instance = new Component(props, context);
                    var usesNewAPI = instance.$N = Boolean(Component.getDerivedStateFromProps || instance.getSnapshotBeforeUpdate);
                    instance.$SVG = isSVG;
                    instance.$L = lifecycle;
                    vNode.children = instance;
                    instance.$BS = false;
                    instance.context = context;
                    if (instance.props === EMPTY_OBJ) {
                        instance.props = props
                    }
                    if (!usesNewAPI) {
                        if (isFunction(instance.componentWillMount)) {
                            instance.$BR = true;
                            instance.componentWillMount();
                            var pending = instance.$PS;
                            if (!isNull(pending)) {
                                var state = instance.state;
                                if (isNull(state)) {
                                    instance.state = pending
                                } else {
                                    for (var key in pending) {
                                        state[key] = pending[key]
                                    }
                                }
                                instance.$PS = null
                            }
                            instance.$BR = false
                        }
                    } else {
                        instance.state = createDerivedState(instance, props, instance.state)
                    }
                    instance.$LI = renderNewInput(instance, props, context);
                    return instance
                }

                function renderFunctionalComponent(vNode, context) {
                    var props = vNode.props || EMPTY_OBJ;
                    return 32768 & vNode.flags ? vNode.type.render(props, vNode.ref, context) : vNode.type(props, context)
                }

                function mount(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags |= 16384;
                    if (481 & flags) {
                        mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (4 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = createClassComponentInstance(vNode, vNode.type, vNode.props || EMPTY_OBJ, context, isSVG, lifecycle);
                            mount(instance.$LI, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                            mountClassComponentCallbacks(vNode.ref, instance, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & flags) {
                        ! function(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            mount(vNode.children = normalizeRoot(renderFunctionalComponent(vNode, context)), parentDOM, context, isSVG, nextNode, lifecycle)
                        }(vNode, parentDOM, context, isSVG, nextNode, lifecycle);
                        mountFunctionalComponentCallbacks(vNode, lifecycle)
                    } else if (512 & flags || 16 & flags) {
                        mountText(vNode, parentDOM, nextNode)
                    } else if (8192 & flags) {
                        ! function(vNode, context, parentDOM, isSVG, nextNode, lifecycle) {
                            var children = vNode.children;
                            var childFlags = vNode.childFlags;
                            if (12 & childFlags && 0 === children.length) {
                                childFlags = vNode.childFlags = 2;
                                children = vNode.children = createVoidVNode()
                            }
                            if (2 === childFlags) {
                                mount(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            } else {
                                mountArrayChildren(children, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                        }(vNode, context, parentDOM, isSVG, nextNode, lifecycle)
                    } else if (1024 & flags) {
                        ! function(vNode, context, parentDOM, nextNode, lifecycle) {
                            mount(vNode.children, vNode.ref, context, false, null, lifecycle);
                            var placeHolderVNode = createVoidVNode();
                            mountText(placeHolderVNode, parentDOM, nextNode);
                            vNode.dom = placeHolderVNode.dom
                        }(vNode, context, parentDOM, nextNode, lifecycle)
                    }
                }

                function mountText(vNode, parentDOM, nextNode) {
                    var dom = vNode.dom = document.createTextNode(vNode.children);
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                }

                function mountElement(vNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var flags = vNode.flags;
                    var props = vNode.props;
                    var className = vNode.className;
                    var childFlags = vNode.childFlags;
                    var dom = vNode.dom = function(tag, isSVG) {
                        if (isSVG) {
                            return document.createElementNS("http://www.w3.org/2000/svg", tag)
                        }
                        return document.createElement(tag)
                    }(vNode.type, isSVG = isSVG || (32 & flags) > 0);
                    var children = vNode.children;
                    if (!isNullOrUndef(className) && "" !== className) {
                        if (isSVG) {
                            dom.setAttribute("class", className)
                        } else {
                            dom.className = className
                        }
                    }
                    if (16 === childFlags) {
                        setTextContent(dom, children)
                    } else if (1 !== childFlags) {
                        var childrenIsSVG = isSVG && "foreignObject" !== vNode.type;
                        if (2 === childFlags) {
                            if (16384 & children.flags) {
                                vNode.children = children = directClone(children)
                            }
                            mount(children, dom, context, childrenIsSVG, null, lifecycle)
                        } else if (8 === childFlags || 4 === childFlags) {
                            mountArrayChildren(children, dom, context, childrenIsSVG, null, lifecycle)
                        }
                    }
                    if (!isNull(parentDOM)) {
                        insertOrAppend(parentDOM, dom, nextNode)
                    }
                    if (!isNull(props)) {
                        mountProps(vNode, flags, props, dom, isSVG)
                    }
                    mountRef(vNode.ref, dom, lifecycle)
                }

                function mountArrayChildren(children, dom, context, isSVG, nextNode, lifecycle) {
                    for (var i = 0; i < children.length; ++i) {
                        var child = children[i];
                        if (16384 & child.flags) {
                            children[i] = child = directClone(child)
                        }
                        mount(child, dom, context, isSVG, nextNode, lifecycle)
                    }
                }

                function mountClassComponentCallbacks(ref, instance, lifecycle) {
                    mountRef(ref, instance, lifecycle);
                    if (isFunction(instance.componentDidMount)) {
                        lifecycle.push(function(instance) {
                            return function() {
                                instance.componentDidMount()
                            }
                        }(instance))
                    }
                }

                function mountFunctionalComponentCallbacks(vNode, lifecycle) {
                    var ref = vNode.ref;
                    if (!isNullOrUndef(ref)) {
                        safeCall1(ref.onComponentWillMount, vNode.props || EMPTY_OBJ);
                        if (isFunction(ref.onComponentDidMount)) {
                            lifecycle.push(function(ref, vNode) {
                                return function() {
                                    ref.onComponentDidMount(findDOMfromVNode(vNode, true), vNode.props || EMPTY_OBJ)
                                }
                            }(ref, vNode))
                        }
                    }
                }

                function patch(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                    var nextFlags = nextVNode.flags |= 16384;
                    if (lastVNode.flags !== nextFlags || lastVNode.type !== nextVNode.type || lastVNode.key !== nextVNode.key || 2048 & nextFlags) {
                        if (16384 & lastVNode.flags) {
                            ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                                unmount(lastVNode);
                                if (0 !== (nextVNode.flags & lastVNode.flags & 2033)) {
                                    mount(nextVNode, null, context, isSVG, null, lifecycle);
                                    ! function(parentDOM, newDom, lastDom) {
                                        parentDOM.replaceChild(newDom, lastDom)
                                    }(parentDOM, nextVNode.dom, lastVNode.dom)
                                } else {
                                    mount(nextVNode, parentDOM, context, isSVG, findDOMfromVNode(lastVNode, true), lifecycle);
                                    removeVNodeDOM(lastVNode, parentDOM)
                                }
                            }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                        } else {
                            mount(nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                        }
                    } else if (481 & nextFlags) {
                        ! function(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle) {
                            var dom = nextVNode.dom = lastVNode.dom;
                            var lastProps = lastVNode.props;
                            var nextProps = nextVNode.props;
                            var isFormElement = false;
                            var hasControlledValue = false;
                            var nextPropsOrEmpty;
                            isSVG = isSVG || (32 & nextFlags) > 0;
                            if (lastProps !== nextProps) {
                                var lastPropsOrEmpty = lastProps || EMPTY_OBJ;
                                nextPropsOrEmpty = nextProps || EMPTY_OBJ;
                                if (nextPropsOrEmpty !== EMPTY_OBJ) {
                                    isFormElement = (448 & nextFlags) > 0;
                                    if (isFormElement) {
                                        hasControlledValue = isControlledFormElement(nextPropsOrEmpty)
                                    }
                                    for (var prop in nextPropsOrEmpty) {
                                        var lastValue = lastPropsOrEmpty[prop];
                                        var nextValue = nextPropsOrEmpty[prop];
                                        if (lastValue !== nextValue) {
                                            patchProp(prop, lastValue, nextValue, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                                if (lastPropsOrEmpty !== EMPTY_OBJ) {
                                    for (var prop$1 in lastPropsOrEmpty) {
                                        if (isNullOrUndef(nextPropsOrEmpty[prop$1]) && !isNullOrUndef(lastPropsOrEmpty[prop$1])) {
                                            patchProp(prop$1, lastPropsOrEmpty[prop$1], null, dom, isSVG, hasControlledValue, lastVNode)
                                        }
                                    }
                                }
                            }
                            var nextChildren = nextVNode.children;
                            var nextClassName = nextVNode.className;
                            if (lastVNode.className !== nextClassName) {
                                if (isNullOrUndef(nextClassName)) {
                                    dom.removeAttribute("class")
                                } else if (isSVG) {
                                    dom.setAttribute("class", nextClassName)
                                } else {
                                    dom.className = nextClassName
                                }
                            }
                            if (4096 & nextFlags) {
                                ! function(dom, nextChildren) {
                                    if (dom.textContent !== nextChildren) {
                                        dom.textContent = nextChildren
                                    }
                                }(dom, nextChildren)
                            } else {
                                patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, dom, context, isSVG && "foreignObject" !== nextVNode.type, null, lastVNode, lifecycle)
                            }
                            if (isFormElement) {
                                processElement(nextFlags, nextVNode, dom, nextPropsOrEmpty, false, hasControlledValue)
                            }
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, dom, lifecycle)
                            }
                        }(lastVNode, nextVNode, context, isSVG, nextFlags, lifecycle)
                    } else if (4 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var instance = nextVNode.children = lastVNode.children;
                            if (isNull(instance)) {
                                return
                            }
                            instance.$L = lifecycle;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastRef = lastVNode.ref;
                            var nextState = instance.state;
                            if (!instance.$N) {
                                if (isFunction(instance.componentWillReceiveProps)) {
                                    instance.$BR = true;
                                    instance.componentWillReceiveProps(nextProps, context);
                                    if (instance.$UN) {
                                        return
                                    }
                                    instance.$BR = false
                                }
                                if (!isNull(instance.$PS)) {
                                    nextState = combineFrom(nextState, instance.$PS);
                                    instance.$PS = null
                                }
                            }
                            updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, false, nextNode, lifecycle);
                            if (lastRef !== nextRef) {
                                unmountRef(lastRef);
                                mountRef(nextRef, instance, lifecycle)
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (8 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle) {
                            var shouldUpdate = true;
                            var nextProps = nextVNode.props || EMPTY_OBJ;
                            var nextRef = nextVNode.ref;
                            var lastProps = lastVNode.props;
                            var nextHooksDefined = !isNullOrUndef(nextRef);
                            var lastInput = lastVNode.children;
                            if (nextHooksDefined && isFunction(nextRef.onComponentShouldUpdate)) {
                                shouldUpdate = nextRef.onComponentShouldUpdate(lastProps, nextProps)
                            }
                            if (false !== shouldUpdate) {
                                if (nextHooksDefined && isFunction(nextRef.onComponentWillUpdate)) {
                                    nextRef.onComponentWillUpdate(lastProps, nextProps)
                                }
                                var nextInput = normalizeRoot(renderFunctionalComponent(nextVNode, context));
                                patch(lastInput, nextInput, parentDOM, context, isSVG, nextNode, lifecycle);
                                nextVNode.children = nextInput;
                                if (nextHooksDefined && isFunction(nextRef.onComponentDidUpdate)) {
                                    nextRef.onComponentDidUpdate(lastProps, nextProps)
                                }
                            } else {
                                nextVNode.children = lastInput
                            }
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, nextNode, lifecycle)
                    } else if (16 & nextFlags) {
                        ! function(lastVNode, nextVNode) {
                            var nextText = nextVNode.children;
                            var dom = nextVNode.dom = lastVNode.dom;
                            if (nextText !== lastVNode.children) {
                                dom.nodeValue = nextText
                            }
                        }(lastVNode, nextVNode)
                    } else if (512 & nextFlags) {
                        nextVNode.dom = lastVNode.dom
                    } else if (8192 & nextFlags) {
                        ! function(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle) {
                            var lastChildren = lastVNode.children;
                            var nextChildren = nextVNode.children;
                            var lastChildFlags = lastVNode.childFlags;
                            var nextChildFlags = nextVNode.childFlags;
                            var nextNode = null;
                            if (12 & nextChildFlags && 0 === nextChildren.length) {
                                nextChildFlags = nextVNode.childFlags = 2;
                                nextChildren = nextVNode.children = createVoidVNode()
                            }
                            var nextIsSingle = 0 !== (2 & nextChildFlags);
                            if (12 & lastChildFlags) {
                                var lastLen = lastChildren.length;
                                if (8 & lastChildFlags && 8 & nextChildFlags || nextIsSingle || !nextIsSingle && nextChildren.length > lastLen) {
                                    nextNode = findDOMfromVNode(lastChildren[lastLen - 1], false).nextSibling
                                }
                            }
                            patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lastVNode, lifecycle)
                        }(lastVNode, nextVNode, parentDOM, context, isSVG, lifecycle)
                    } else {
                        ! function(lastVNode, nextVNode, context, lifecycle) {
                            var lastContainer = lastVNode.ref;
                            var nextContainer = nextVNode.ref;
                            var nextChildren = nextVNode.children;
                            patchChildren(lastVNode.childFlags, nextVNode.childFlags, lastVNode.children, nextChildren, lastContainer, context, false, null, lastVNode, lifecycle);
                            nextVNode.dom = lastVNode.dom;
                            if (lastContainer !== nextContainer && !isInvalid(nextChildren)) {
                                var node = nextChildren.dom;
                                removeChild(lastContainer, node);
                                appendChild(nextContainer, node)
                            }
                        }(lastVNode, nextVNode, context, lifecycle)
                    }
                }

                function patchChildren(lastChildFlags, nextChildFlags, lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, parentVNode, lifecycle) {
                    switch (lastChildFlags) {
                        case 2:
                            switch (nextChildFlags) {
                                case 2:
                                    patch(lastChildren, nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    remove(lastChildren, parentDOM);
                                    break;
                                case 16:
                                    unmount(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    ! function(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle) {
                                        unmount(lastChildren);
                                        mountArrayChildren(nextChildren, parentDOM, context, isSVG, findDOMfromVNode(lastChildren, true), lifecycle);
                                        removeVNodeDOM(lastChildren, parentDOM)
                                    }(lastChildren, nextChildren, parentDOM, context, isSVG, lifecycle)
                            }
                            break;
                        case 1:
                            switch (nextChildFlags) {
                                case 2:
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    break;
                                case 16:
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                default:
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        case 16:
                            switch (nextChildFlags) {
                                case 16:
                                    ! function(lastChildren, nextChildren, parentDOM) {
                                        if (lastChildren !== nextChildren) {
                                            if ("" !== lastChildren) {
                                                parentDOM.firstChild.nodeValue = nextChildren
                                            } else {
                                                setTextContent(parentDOM, nextChildren)
                                            }
                                        }
                                    }(lastChildren, nextChildren, parentDOM);
                                    break;
                                case 2:
                                    clearDOM(parentDOM);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    clearDOM(parentDOM);
                                    break;
                                default:
                                    clearDOM(parentDOM);
                                    mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                            }
                            break;
                        default:
                            switch (nextChildFlags) {
                                case 16:
                                    unmountAllChildren(lastChildren);
                                    setTextContent(parentDOM, nextChildren);
                                    break;
                                case 2:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    mount(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle);
                                    break;
                                case 1:
                                    removeAllChildren(parentDOM, parentVNode, lastChildren);
                                    break;
                                default:
                                    var lastLength = 0 | lastChildren.length;
                                    var nextLength = 0 | nextChildren.length;
                                    if (0 === lastLength) {
                                        if (nextLength > 0) {
                                            mountArrayChildren(nextChildren, parentDOM, context, isSVG, nextNode, lifecycle)
                                        }
                                    } else if (0 === nextLength) {
                                        removeAllChildren(parentDOM, parentVNode, lastChildren)
                                    } else if (8 === nextChildFlags && 8 === lastChildFlags) {
                                        ! function(a, b, dom, context, isSVG, aLength, bLength, outerEdge, parentVNode, lifecycle) {
                                            var aEnd = aLength - 1;
                                            var bEnd = bLength - 1;
                                            var j = 0;
                                            var aNode = a[j];
                                            var bNode = b[j];
                                            var nextPos;
                                            var nextNode;
                                            outer: {
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[j] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[j] = bNode;
                                                    ++j;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[j];
                                                    bNode = b[j]
                                                }
                                                aNode = a[aEnd];bNode = b[bEnd];
                                                while (aNode.key === bNode.key) {
                                                    if (16384 & bNode.flags) {
                                                        b[bEnd] = bNode = directClone(bNode)
                                                    }
                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                    a[aEnd] = bNode;
                                                    aEnd--;
                                                    bEnd--;
                                                    if (j > aEnd || j > bEnd) {
                                                        break outer
                                                    }
                                                    aNode = a[aEnd];
                                                    bNode = b[bEnd]
                                                }
                                            }
                                            if (j > aEnd) {
                                                if (j <= bEnd) {
                                                    nextPos = bEnd + 1;
                                                    nextNode = nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge;
                                                    while (j <= bEnd) {
                                                        bNode = b[j];
                                                        if (16384 & bNode.flags) {
                                                            b[j] = bNode = directClone(bNode)
                                                        }++j;
                                                        mount(bNode, dom, context, isSVG, nextNode, lifecycle)
                                                    }
                                                }
                                            } else if (j > bEnd) {
                                                while (j <= aEnd) {
                                                    remove(a[j++], dom)
                                                }
                                            } else {
                                                ! function(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle) {
                                                    var aNode;
                                                    var bNode;
                                                    var nextPos;
                                                    var i = 0;
                                                    var aStart = j;
                                                    var bStart = j;
                                                    var aLeft = aEnd - j + 1;
                                                    var bLeft = bEnd - j + 1;
                                                    var sources = new Int32Array(bLeft + 1);
                                                    var canRemoveWholeContent = aLeft === aLength;
                                                    var moved = false;
                                                    var pos = 0;
                                                    var patched = 0;
                                                    if (bLength < 4 || (aLeft | bLeft) < 32) {
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                for (j = bStart; j <= bEnd; j++) {
                                                                    bNode = b[j];
                                                                    if (aNode.key === bNode.key) {
                                                                        sources[j - bStart] = i + 1;
                                                                        if (canRemoveWholeContent) {
                                                                            canRemoveWholeContent = false;
                                                                            while (aStart < i) {
                                                                                remove(a[aStart++], dom)
                                                                            }
                                                                        }
                                                                        if (pos > j) {
                                                                            moved = true
                                                                        } else {
                                                                            pos = j
                                                                        }
                                                                        if (16384 & bNode.flags) {
                                                                            b[j] = bNode = directClone(bNode)
                                                                        }
                                                                        patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                        ++patched;
                                                                        break
                                                                    }
                                                                }
                                                                if (!canRemoveWholeContent && j > bEnd) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    } else {
                                                        var keyIndex = {};
                                                        for (i = bStart; i <= bEnd; ++i) {
                                                            keyIndex[b[i].key] = i
                                                        }
                                                        for (i = aStart; i <= aEnd; ++i) {
                                                            aNode = a[i];
                                                            if (patched < bLeft) {
                                                                j = keyIndex[aNode.key];
                                                                if (void 0 !== j) {
                                                                    if (canRemoveWholeContent) {
                                                                        canRemoveWholeContent = false;
                                                                        while (i > aStart) {
                                                                            remove(a[aStart++], dom)
                                                                        }
                                                                    }
                                                                    sources[j - bStart] = i + 1;
                                                                    if (pos > j) {
                                                                        moved = true
                                                                    } else {
                                                                        pos = j
                                                                    }
                                                                    bNode = b[j];
                                                                    if (16384 & bNode.flags) {
                                                                        b[j] = bNode = directClone(bNode)
                                                                    }
                                                                    patch(aNode, bNode, dom, context, isSVG, outerEdge, lifecycle);
                                                                    ++patched
                                                                } else if (!canRemoveWholeContent) {
                                                                    remove(aNode, dom)
                                                                }
                                                            } else if (!canRemoveWholeContent) {
                                                                remove(aNode, dom)
                                                            }
                                                        }
                                                    }
                                                    if (canRemoveWholeContent) {
                                                        removeAllChildren(dom, parentVNode, a);
                                                        mountArrayChildren(b, dom, context, isSVG, outerEdge, lifecycle)
                                                    } else if (moved) {
                                                        var seq = function(arr) {
                                                            var arrI = 0;
                                                            var i = 0;
                                                            var j = 0;
                                                            var k = 0;
                                                            var u = 0;
                                                            var v = 0;
                                                            var c = 0;
                                                            var len = arr.length;
                                                            if (len > maxLen) {
                                                                maxLen = len;
                                                                result = new Int32Array(len);
                                                                p = new Int32Array(len)
                                                            }
                                                            for (; i < len; ++i) {
                                                                arrI = arr[i];
                                                                if (0 !== arrI) {
                                                                    j = result[k];
                                                                    if (arr[j] < arrI) {
                                                                        p[i] = j;
                                                                        result[++k] = i;
                                                                        continue
                                                                    }
                                                                    u = 0;
                                                                    v = k;
                                                                    while (u < v) {
                                                                        c = u + v >> 1;
                                                                        if (arr[result[c]] < arrI) {
                                                                            u = c + 1
                                                                        } else {
                                                                            v = c
                                                                        }
                                                                    }
                                                                    if (arrI < arr[result[u]]) {
                                                                        if (u > 0) {
                                                                            p[i] = result[u - 1]
                                                                        }
                                                                        result[u] = i
                                                                    }
                                                                }
                                                            }
                                                            u = k + 1;
                                                            var seq = new Int32Array(u);
                                                            v = result[u - 1];
                                                            while (u-- > 0) {
                                                                seq[u] = v;
                                                                v = p[v];
                                                                result[u] = 0
                                                            }
                                                            return seq
                                                        }(sources);
                                                        j = seq.length - 1;
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            } else if (j < 0 || i !== seq[j]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                nextPos = pos + 1;
                                                                moveVNodeDOM(bNode, dom, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge)
                                                            } else {
                                                                j--
                                                            }
                                                        }
                                                    } else if (patched !== bLeft) {
                                                        for (i = bLeft - 1; i >= 0; i--) {
                                                            if (0 === sources[i]) {
                                                                pos = i + bStart;
                                                                bNode = b[pos];
                                                                if (16384 & bNode.flags) {
                                                                    b[pos] = bNode = directClone(bNode)
                                                                }
                                                                nextPos = pos + 1;
                                                                mount(bNode, dom, context, isSVG, nextPos < bLength ? findDOMfromVNode(b[nextPos], true) : outerEdge, lifecycle)
                                                            }
                                                        }
                                                    }
                                                }(a, b, context, aLength, bLength, aEnd, bEnd, j, dom, isSVG, outerEdge, parentVNode, lifecycle)
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, parentVNode, lifecycle)
                                    } else {
                                        ! function(lastChildren, nextChildren, dom, context, isSVG, lastChildrenLength, nextChildrenLength, nextNode, lifecycle) {
                                            var commonLength = lastChildrenLength > nextChildrenLength ? nextChildrenLength : lastChildrenLength;
                                            var i = 0;
                                            var nextChild;
                                            var lastChild;
                                            for (; i < commonLength; ++i) {
                                                nextChild = nextChildren[i];
                                                lastChild = lastChildren[i];
                                                if (16384 & nextChild.flags) {
                                                    nextChild = nextChildren[i] = directClone(nextChild)
                                                }
                                                patch(lastChild, nextChild, dom, context, isSVG, nextNode, lifecycle);
                                                lastChildren[i] = nextChild
                                            }
                                            if (lastChildrenLength < nextChildrenLength) {
                                                for (i = commonLength; i < nextChildrenLength; ++i) {
                                                    nextChild = nextChildren[i];
                                                    if (16384 & nextChild.flags) {
                                                        nextChild = nextChildren[i] = directClone(nextChild)
                                                    }
                                                    mount(nextChild, dom, context, isSVG, nextNode, lifecycle)
                                                }
                                            } else if (lastChildrenLength > nextChildrenLength) {
                                                for (i = commonLength; i < lastChildrenLength; ++i) {
                                                    remove(lastChildren[i], dom)
                                                }
                                            }
                                        }(lastChildren, nextChildren, parentDOM, context, isSVG, lastLength, nextLength, nextNode, lifecycle)
                                    }
                            }
                    }
                }

                function updateClassComponent(instance, nextState, nextProps, parentDOM, context, isSVG, force, nextNode, lifecycle) {
                    var lastState = instance.state;
                    var lastProps = instance.props;
                    var usesNewAPI = Boolean(instance.$N);
                    var hasSCU = isFunction(instance.shouldComponentUpdate);
                    if (usesNewAPI) {
                        nextState = createDerivedState(instance, nextProps, nextState !== lastState ? combineFrom(lastState, nextState) : nextState)
                    }
                    if (force || !hasSCU || hasSCU && instance.shouldComponentUpdate(nextProps, nextState, context)) {
                        if (!usesNewAPI && isFunction(instance.componentWillUpdate)) {
                            instance.componentWillUpdate(nextProps, nextState, context)
                        }
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context;
                        var snapshot = null;
                        var nextInput = renderNewInput(instance, nextProps, context);
                        if (usesNewAPI && isFunction(instance.getSnapshotBeforeUpdate)) {
                            snapshot = instance.getSnapshotBeforeUpdate(lastProps, lastState)
                        }
                        patch(instance.$LI, nextInput, parentDOM, instance.$CX, isSVG, nextNode, lifecycle);
                        instance.$LI = nextInput;
                        if (isFunction(instance.componentDidUpdate)) {
                            ! function(instance, lastProps, lastState, snapshot, lifecycle) {
                                lifecycle.push((function() {
                                    instance.componentDidUpdate(lastProps, lastState, snapshot)
                                }))
                            }(instance, lastProps, lastState, snapshot, lifecycle)
                        }
                    } else {
                        instance.props = nextProps;
                        instance.state = nextState;
                        instance.context = context
                    }
                }
                var result;
                var p;
                var maxLen = 0;
                var hasDocumentAvailable = "undefined" !== typeof document;
                if (hasDocumentAvailable) {
                    if (window.Node) {
                        Node.prototype.$EV = null;
                        Node.prototype.$V = null
                    }
                }

                function __render(input, parentDOM, callback, context) {
                    var lifecycle = [];
                    var rootInput = parentDOM.$V;
                    renderCheck.v = true;
                    if (isNullOrUndef(rootInput)) {
                        if (!isNullOrUndef(input)) {
                            if (16384 & input.flags) {
                                input = directClone(input)
                            }
                            mount(input, parentDOM, context, false, null, lifecycle);
                            parentDOM.$V = input;
                            rootInput = input
                        }
                    } else if (isNullOrUndef(input)) {
                        remove(rootInput, parentDOM);
                        parentDOM.$V = null
                    } else {
                        if (16384 & input.flags) {
                            input = directClone(input)
                        }
                        patch(rootInput, input, parentDOM, context, false, null, lifecycle);
                        rootInput = parentDOM.$V = input
                    }
                    callAll(lifecycle);
                    renderCheck.v = false;
                    if (isFunction(callback)) {
                        callback()
                    }
                    if (isFunction(options.renderComplete)) {
                        options.renderComplete(rootInput, parentDOM)
                    }
                }

                function render(input, parentDOM, callback, context) {
                    if (void 0 === callback) {
                        callback = null
                    }
                    if (void 0 === context) {
                        context = EMPTY_OBJ
                    }
                    __render(input, parentDOM, callback, context)
                }

                function createRenderer(parentDOM) {
                    return function(lastInput, nextInput, callback, context) {
                        if (!parentDOM) {
                            parentDOM = lastInput
                        }
                        render(nextInput, parentDOM, callback, context)
                    }
                }
                var QUEUE = [];
                var nextTick = "undefined" !== typeof Promise ? Promise.resolve().then.bind(Promise.resolve()) : function(a) {
                    window.setTimeout(a, 0)
                };
                var microTaskPending = false;

                function queueStateChanges(component, newState, callback, force) {
                    var pending = component.$PS;
                    if (isFunction(newState)) {
                        newState = newState(pending ? combineFrom(component.state, pending) : component.state, component.props, component.context)
                    }
                    if (isNullOrUndef(pending)) {
                        component.$PS = newState
                    } else {
                        for (var stateKey in newState) {
                            pending[stateKey] = newState[stateKey]
                        }
                    }
                    if (!component.$BR) {
                        if (!renderCheck.v) {
                            if (0 === QUEUE.length) {
                                applyState(component, force);
                                if (isFunction(callback)) {
                                    callback.call(component)
                                }
                                return
                            }
                        }
                        if (-1 === QUEUE.indexOf(component)) {
                            QUEUE.push(component)
                        }
                        if (force) {
                            component.$F = true
                        }
                        if (!microTaskPending) {
                            microTaskPending = true;
                            nextTick(rerender)
                        }
                        if (isFunction(callback)) {
                            var QU = component.$QU;
                            if (!QU) {
                                QU = component.$QU = []
                            }
                            QU.push(callback)
                        }
                    } else if (isFunction(callback)) {
                        component.$L.push(callback.bind(component))
                    }
                }

                function callSetStateCallbacks(component) {
                    var queue = component.$QU;
                    for (var i = 0; i < queue.length; ++i) {
                        queue[i].call(component)
                    }
                    component.$QU = null
                }

                function rerender() {
                    var component;
                    microTaskPending = false;
                    while (component = QUEUE.shift()) {
                        if (!component.$UN) {
                            var force = component.$F;
                            component.$F = false;
                            applyState(component, force);
                            if (component.$QU) {
                                callSetStateCallbacks(component)
                            }
                        }
                    }
                }

                function applyState(component, force) {
                    if (force || !component.$BR) {
                        var pendingState = component.$PS;
                        component.$PS = null;
                        var lifecycle = [];
                        renderCheck.v = true;
                        updateClassComponent(component, combineFrom(component.state, pendingState), component.props, findDOMfromVNode(component.$LI, true).parentNode, component.context, component.$SVG, force, null, lifecycle);
                        callAll(lifecycle);
                        renderCheck.v = false
                    } else {
                        component.state = component.$PS;
                        component.$PS = null
                    }
                }
                var Component = function(props, context) {
                    this.state = null;
                    this.$BR = false;
                    this.$BS = true;
                    this.$PS = null;
                    this.$LI = null;
                    this.$UN = false;
                    this.$CX = null;
                    this.$QU = null;
                    this.$N = false;
                    this.$L = null;
                    this.$SVG = false;
                    this.$F = false;
                    this.props = props || EMPTY_OBJ;
                    this.context = context || EMPTY_OBJ
                };
                Component.prototype.forceUpdate = function(callback) {
                    if (this.$UN) {
                        return
                    }
                    queueStateChanges(this, {}, callback, true)
                };
                Component.prototype.setState = function(newState, callback) {
                    if (this.$UN) {
                        return
                    }
                    if (!this.$BS) {
                        queueStateChanges(this, newState, callback, false)
                    }
                };
                Component.prototype.render = function(_nextProps, _nextState, _nextContext) {
                    return null
                };
                var version = "7.4.11";
                if (false) {}
            },
        66798:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/common/m_charts.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.registerPattern = exports.registerGradient = exports.default = void 0;
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const graphicObjects = {};
                exports.registerPattern = options => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: "pattern"
                    }, options);
                    return id
                };
                exports.registerGradient = (type, options) => {
                    const id = (0, _utils.getNextDefsSvgId)();
                    graphicObjects[id] = _extends({
                        type: type
                    }, options);
                    return id
                };
                var _default = {
                    getGraphicObjects: () => graphicObjects
                };
                exports.default = _default
            },
        70100:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/license_validation_internal.js ***!
              \****************************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.parseLicenseKey = function(encodedKey) {};
                exports.peekValidationPerformed = function() {};
                exports.setLicenseCheckSkipCondition = function() {};
                exports.validateLicense = validateLicense;

                function validateLicense(licenseKey, version) {}
                var _default = {
                    validateLicense: validateLicense
                };
                exports.default = _default
            },
        24321:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/date.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.dateUtilsTs = void 0;
                const dateUtilsTs = {
                    addOffsets: (date, offsets) => {
                        const newDateMs = offsets.reduce((result, offset) => result + offset, date.getTime());
                        return new Date(newDateMs)
                    }
                };
                exports.dateUtilsTs = dateUtilsTs
            },
        18605:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/events/dblclick.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.name = exports.dblClick = void 0;
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 38377));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 73349));
                var _dom = __webpack_require__( /*! ../../core/utils/dom */ 3532);
                var _click = __webpack_require__( /*! ../../events/click */ 95429);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../events/utils/index */ 39611);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                exports.name = "dxdblclick";
                const NAMESPACED_CLICK_EVENT = (0, _index.addNamespace)(_click.name, "dxDblClick");
                const DblClick = _class.default.inherit({
                    ctor() {
                        this._handlerCount = 0;
                        this._forgetLastClick()
                    },
                    _forgetLastClick() {
                        this._firstClickTarget = null;
                        this._lastClickTimeStamp = -300
                    },
                    add() {
                        if (this._handlerCount <= 0) {
                            _events_engine.default.on(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT, this._clickHandler.bind(this))
                        }
                        this._handlerCount += 1
                    },
                    _clickHandler(e) {
                        const timeStamp = e.timeStamp || Date.now();
                        const timeBetweenClicks = timeStamp - this._lastClickTimeStamp;
                        const isSimulated = timeBetweenClicks < 0;
                        const isDouble = !isSimulated && timeBetweenClicks < 300;
                        if (isDouble) {
                            (0, _index.fireEvent)({
                                type: "dxdblclick",
                                target: (0, _dom.closestCommonParent)(this._firstClickTarget, e.target),
                                originalEvent: e
                            });
                            this._forgetLastClick()
                        } else {
                            this._firstClickTarget = e.target;
                            this._lastClickTimeStamp = timeStamp
                        }
                    },
                    remove() {
                        this._handlerCount -= 1;
                        if (this._handlerCount <= 0) {
                            this._forgetLastClick();
                            _events_engine.default.off(_dom_adapter.default.getDocument(), NAMESPACED_CLICK_EVENT, void 0);
                            this._handlerCount = 0
                        }
                    }
                });
                const dblClick = new DblClick;
                exports.dblClick = dblClick
            },
        60082:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/m_utils.js ***!
              \***********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _data = __webpack_require__( /*! ../../../core/utils/data */ 47617);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _position = __webpack_require__( /*! ../../../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 58664);
                var _string = __webpack_require__( /*! ../../../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _variable_wrapper = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/variable_wrapper */ 26974));
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 58201);
                var _data_source = __webpack_require__( /*! ../../../data/data_source/data_source */ 85273);
                var _utils = __webpack_require__( /*! ../../../data/data_source/utils */ 9234);
                var _utils2 = __webpack_require__( /*! ../../../data/utils */ 16454);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _format_helper = _interopRequireDefault(__webpack_require__( /*! ../../../format_helper */ 30343));
                var _load_panel = _interopRequireDefault(__webpack_require__( /*! ../../../ui/load_panel */ 97218));
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../../ui/shared/filtering */ 18740));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const DATE_INTERVAL_SELECTORS = {
                    year: value => value && value.getFullYear(),
                    month: value => value && value.getMonth() + 1,
                    day: value => value && value.getDate(),
                    quarter: value => value && Math.floor(value.getMonth() / 3) + 1,
                    hour: value => value && value.getHours(),
                    minute: value => value && value.getMinutes(),
                    second: value => value && value.getSeconds()
                };
                const getIntervalSelector = function() {
                    const data = arguments[1];
                    const value = this.calculateCellValue(data);
                    if (!(0, _type.isDefined)(value)) {
                        return null
                    }
                    if (isDateType(this.dataType)) {
                        const nameIntervalSelector = arguments[0];
                        return DATE_INTERVAL_SELECTORS[nameIntervalSelector](value)
                    }
                    if ("number" === this.dataType) {
                        const groupInterval = arguments[0];
                        return Math.floor(Number(value) / groupInterval) * groupInterval
                    }
                };
                const equalSelectors = function(selector1, selector2) {
                    if ((0, _type.isFunction)(selector1) && (0, _type.isFunction)(selector2)) {
                        if (selector1.originalCallback && selector2.originalCallback) {
                            return selector1.originalCallback === selector2.originalCallback && selector1.columnIndex === selector2.columnIndex
                        }
                    }
                    return selector1 === selector2
                };

                function isDateType(dataType) {
                    return "date" === dataType || "datetime" === dataType
                }
                const setEmptyText = function($container) {
                    $container.get(0).textContent = "\xa0"
                };
                const normalizeSortingInfo = function(sort) {
                    sort = sort || [];
                    const result = (0, _utils2.normalizeSortingInfo)(sort);
                    for (let i = 0; i < sort.length; i++) {
                        if (sort && sort[i] && void 0 !== sort[i].isExpanded) {
                            result[i].isExpanded = sort[i].isExpanded
                        }
                        if (sort && sort[i] && void 0 !== sort[i].groupInterval) {
                            result[i].groupInterval = sort[i].groupInterval
                        }
                    }
                    return result
                };
                const formatValue = function(value, options) {
                    const valueText = _format_helper.default.format(value, options.format) || value && value.toString() || "";
                    const formatObject = {
                        value: value,
                        valueText: options.getDisplayFormat ? options.getDisplayFormat(valueText) : valueText,
                        target: options.target || "row",
                        groupInterval: options.groupInterval
                    };
                    return options.customizeText ? options.customizeText.call(options, formatObject) : formatObject.valueText
                };
                const getSummaryText = function(summaryItem, summaryTexts) {
                    const displayFormat = summaryItem.displayFormat || summaryItem.columnCaption && summaryTexts["".concat(summaryItem.summaryType, "OtherColumn")] || summaryTexts[summaryItem.summaryType];
                    return formatValue(summaryItem.value, {
                        format: summaryItem.valueFormat,
                        getDisplayFormat: valueText => displayFormat ? (0, _string.format)(displayFormat, valueText, summaryItem.columnCaption) : valueText,
                        customizeText: summaryItem.customizeText
                    })
                };
                const getWidgetInstance = function($element) {
                    const editorData = $element.data && $element.data();
                    const dxComponents = editorData && editorData.dxComponents;
                    const widgetName = dxComponents && dxComponents[0];
                    return widgetName && editorData[widgetName]
                };
                const equalFilterParameters = function(filter1, filter2) {
                    if (Array.isArray(filter1) && Array.isArray(filter2)) {
                        if (filter1.length !== filter2.length) {
                            return false
                        }
                        for (let i = 0; i < filter1.length; i++) {
                            if (!equalFilterParameters(filter1[i], filter2[i])) {
                                return false
                            }
                        }
                        return true
                    }
                    if ((0, _type.isFunction)(filter1) && filter1.columnIndex >= 0 && (0, _type.isFunction)(filter2) && filter2.columnIndex >= 0) {
                        return filter1.columnIndex === filter2.columnIndex && (0, _data.toComparable)(filter1.filterValue) === (0, _data.toComparable)(filter2.filterValue) && (0, _data.toComparable)(filter1.selectedFilterOperation) === (0, _data.toComparable)(filter2.selectedFilterOperation)
                    }
                    return (0, _data.toComparable)(filter1) == (0, _data.toComparable)(filter2)
                };
                var _default = {
                    renderNoDataText($element) {
                        const that = this;
                        $element = $element || this.element();
                        if (!$element) {
                            return
                        }
                        const noDataClass = that.addWidgetPrefix("nodata");
                        let noDataElement = $element.find(".".concat(noDataClass)).last();
                        const isVisible = this._dataController.isEmpty();
                        const isLoading = this._dataController.isLoading();
                        if (!noDataElement.length) {
                            noDataElement = (0, _renderer.default)("<span>").addClass(noDataClass)
                        }
                        if (!noDataElement.parent().is($element)) {
                            noDataElement.appendTo($element)
                        }
                        if (isVisible && !isLoading) {
                            noDataElement.removeClass("dx-hidden").text(that._getNoDataText())
                        } else {
                            noDataElement.addClass("dx-hidden")
                        }
                    },
                    renderLoadPanel($element, $container, isLocalStore) {
                        const that = this;
                        let loadPanelOptions;
                        that._loadPanel && that._loadPanel.$element().remove();
                        loadPanelOptions = that.option("loadPanel");
                        if (loadPanelOptions && ("auto" === loadPanelOptions.enabled ? !isLocalStore : loadPanelOptions.enabled)) {
                            loadPanelOptions = (0, _extend.extend)({
                                shading: false,
                                message: loadPanelOptions.text,
                                container: $container
                            }, loadPanelOptions);
                            that._loadPanel = that._createComponent((0, _renderer.default)("<div>").appendTo($container), _load_panel.default, loadPanelOptions)
                        } else {
                            that._loadPanel = null
                        }
                    },
                    calculateLoadPanelPosition($element) {
                        const $window = (0, _renderer.default)((0, _window.getWindow)());
                        if ((0, _size.getHeight)($element) > (0, _size.getHeight)($window)) {
                            return {
                                of: $window,
                                boundary: $element,
                                collision: "fit"
                            }
                        }
                        return {
                            of: $element
                        }
                    },
                    getIndexByKey(key, items, keyName) {
                        let index = -1;
                        if (void 0 !== key && Array.isArray(items)) {
                            keyName = arguments.length <= 2 ? "key" : keyName;
                            for (let i = 0; i < items.length; i++) {
                                const item = (0, _type.isDefined)(keyName) ? items[i][keyName] : items[i];
                                if ((0, _common.equalByValue)(key, item)) {
                                    index = i;
                                    break
                                }
                            }
                        }
                        return index
                    },
                    combineFilters(filters, operation) {
                        var _a;
                        let resultFilter = [];
                        operation = operation || "and";
                        for (let i = 0; i < filters.length; i++) {
                            if (!filters[i]) {
                                continue
                            }
                            if (1 === (null === (_a = filters[i]) || void 0 === _a ? void 0 : _a.length) && "!" === filters[i][0]) {
                                if ("and" === operation) {
                                    return ["!"]
                                }
                                if ("or" === operation) {
                                    continue
                                }
                            }
                            if (resultFilter.length) {
                                resultFilter.push(operation)
                            }
                            resultFilter.push(filters[i])
                        }
                        if (1 === resultFilter.length) {
                            resultFilter = resultFilter[0]
                        }
                        if (resultFilter.length) {
                            return resultFilter
                        }
                        return
                    },
                    checkChanges(changes, changeNames) {
                        let changesWithChangeNamesCount = 0;
                        for (let i = 0; i < changeNames.length; i++) {
                            if (changes[changeNames[i]]) {
                                changesWithChangeNamesCount++
                            }
                        }
                        return changes.length && changes.length === changesWithChangeNamesCount
                    },
                    equalFilterParameters: equalFilterParameters,
                    proxyMethod(instance, methodName, defaultResult) {
                        if (!instance[methodName]) {
                            instance[methodName] = function() {
                                const dataSource = this._dataSource;
                                return dataSource ? dataSource[methodName].apply(dataSource, arguments) : defaultResult
                            }
                        }
                    },
                    formatValue: formatValue,
                    getFormatOptionsByColumn: (column, target) => ({
                        format: column.format,
                        getDisplayFormat: column.getDisplayFormat,
                        customizeText: column.customizeText,
                        target: target,
                        trueText: column.trueText,
                        falseText: column.falseText
                    }),
                    getDisplayValue(column, value, data, rowType) {
                        if (column.displayValueMap && void 0 !== column.displayValueMap[value]) {
                            return column.displayValueMap[value]
                        }
                        if (column.calculateDisplayValue && data && "group" !== rowType) {
                            return column.calculateDisplayValue(data)
                        }
                        if (column.lookup && !("group" === rowType && (column.calculateGroupValue || column.calculateDisplayValue))) {
                            return column.lookup.calculateCellValue(value)
                        }
                        return value
                    },
                    getGroupRowSummaryText(summaryItems, summaryTexts) {
                        let result = "(";
                        for (let i = 0; i < summaryItems.length; i++) {
                            const summaryItem = summaryItems[i];
                            result += (i > 0 ? ", " : "") + getSummaryText(summaryItem, summaryTexts)
                        }
                        return result + ")"
                    },
                    getSummaryText: getSummaryText,
                    normalizeSortingInfo: normalizeSortingInfo,
                    getFormatByDataType(dataType) {
                        switch (dataType) {
                            case "date":
                                return "shortDate";
                            case "datetime":
                                return "shortDateShortTime";
                            default:
                                return
                        }
                    },
                    getHeaderFilterGroupParameters(column, remoteGrouping) {
                        let result = [];
                        const dataField = column.dataField || column.name;
                        const groupInterval = _filtering.default.getGroupInterval(column);
                        if (groupInterval) {
                            (0, _iterator.each)(groupInterval, (index, interval) => {
                                result.push(remoteGrouping ? {
                                    selector: dataField,
                                    groupInterval: interval,
                                    isExpanded: index < groupInterval.length - 1
                                } : getIntervalSelector.bind(column, interval))
                            });
                            return result
                        }
                        if (remoteGrouping) {
                            result = [{
                                selector: dataField,
                                isExpanded: false
                            }]
                        } else {
                            result = function(data) {
                                let result = column.calculateCellValue(data);
                                if (void 0 === result || "" === result) {
                                    result = null
                                }
                                return result
                            };
                            if (column.sortingMethod) {
                                result = [{
                                    selector: result,
                                    compare: column.sortingMethod.bind(column)
                                }]
                            }
                        }
                        return result
                    },
                    equalSortParameters(sortParameters1, sortParameters2, ignoreIsExpanded) {
                        sortParameters1 = normalizeSortingInfo(sortParameters1);
                        sortParameters2 = normalizeSortingInfo(sortParameters2);
                        if (Array.isArray(sortParameters1) && Array.isArray(sortParameters2)) {
                            if (sortParameters1.length !== sortParameters2.length) {
                                return false
                            }
                            for (let i = 0; i < sortParameters1.length; i++) {
                                if (!equalSelectors(sortParameters1[i].selector, sortParameters2[i].selector) || sortParameters1[i].desc !== sortParameters2[i].desc || sortParameters1[i].groupInterval !== sortParameters2[i].groupInterval || !ignoreIsExpanded && Boolean(sortParameters1[i].isExpanded) !== Boolean(sortParameters2[i].isExpanded)) {
                                    return false
                                }
                            }
                            return true
                        }
                        return (!sortParameters1 || !sortParameters1.length) === (!sortParameters2 || !sortParameters2.length)
                    },
                    getPointsByColumns(items, pointCreated, isVertical, startColumnIndex) {
                        const cellsLength = items.length;
                        let notCreatePoint = false;
                        let item;
                        let offset;
                        let columnIndex = startColumnIndex || 0;
                        const result = [];
                        let rtlEnabled;
                        for (let i = 0; i <= cellsLength; i++) {
                            if (i < cellsLength) {
                                item = items.eq(i);
                                offset = item.offset();
                                rtlEnabled = "rtl" === item.css("direction")
                            }
                            const point = {
                                index: columnIndex,
                                x: offset ? offset.left + (!isVertical && rtlEnabled ^ i === cellsLength ? (0, _position.getBoundingRect)(item[0]).width : 0) : 0,
                                y: offset ? offset.top + (isVertical && i === cellsLength ? (0, _position.getBoundingRect)(item[0]).height : 0) : 0,
                                columnIndex: columnIndex
                            };
                            if (!isVertical && i > 0) {
                                const prevItemOffset = items.eq(i - 1).offset();
                                if (prevItemOffset.top < point.y) {
                                    point.y = prevItemOffset.top
                                }
                            }
                            if (pointCreated) {
                                notCreatePoint = pointCreated(point)
                            }
                            if (!notCreatePoint) {
                                result.push(point)
                            }
                            columnIndex++
                        }
                        return result
                    },
                    getExpandCellTemplate: () => ({
                        allowRenderToDetachedContainer: true,
                        render(container, options) {
                            const $container = (0, _renderer.default)(container);
                            if ((0, _type.isDefined)(options.value) && !(options.data && options.data.isContinuation) && !options.row.isNewRow) {
                                const rowsView = options.component.getView("rowsView");
                                $container.addClass("dx-datagrid-expand").addClass("dx-selection-disabled");
                                (0, _renderer.default)("<div>").addClass(options.value ? "dx-datagrid-group-opened" : "dx-datagrid-group-closed").appendTo($container);
                                rowsView.setAria("label", options.value ? rowsView.localize("dxDataGrid-ariaCollapse") : rowsView.localize("dxDataGrid-ariaExpand"), $container)
                            } else {
                                setEmptyText($container)
                            }
                        }
                    }),
                    setEmptyText: setEmptyText,
                    isDateType: isDateType,
                    getSelectionRange(focusedElement) {
                        try {
                            if (focusedElement) {
                                return {
                                    selectionStart: focusedElement.selectionStart,
                                    selectionEnd: focusedElement.selectionEnd
                                }
                            }
                        } catch (e) {}
                        return {}
                    },
                    setSelectionRange(focusedElement, selectionRange) {
                        try {
                            if (focusedElement && focusedElement.setSelectionRange) {
                                focusedElement.setSelectionRange(selectionRange.selectionStart, selectionRange.selectionEnd)
                            }
                        } catch (e) {}
                    },
                    focusAndSelectElement(component, $element) {
                        const isFocused = $element.is(":focus");
                        _events_engine.default.trigger($element, "focus");
                        const isSelectTextOnEditingStart = component.option("editing.selectTextOnEditStart");
                        const element = $element.get(0);
                        if (!isFocused && isSelectTextOnEditingStart && $element.is(".dx-texteditor-input") && !$element.is("[readonly]")) {
                            const editor = getWidgetInstance($element.closest(".dx-texteditor"));
                            (0, _deferred.when)(editor && editor._loadItemDeferred).done(() => {
                                element.select()
                            })
                        }
                    },
                    getWidgetInstance: getWidgetInstance,
                    getLastResizableColumnIndex(columns, resultWidths) {
                        const hasResizableColumns = columns.some(column => column && !column.command && !column.fixed && false !== column.allowResizing);
                        let lastColumnIndex;
                        for (lastColumnIndex = columns.length - 1; columns[lastColumnIndex]; lastColumnIndex--) {
                            const column = columns[lastColumnIndex];
                            const width = resultWidths && resultWidths[lastColumnIndex];
                            const allowResizing = !hasResizableColumns || false !== column.allowResizing;
                            if (!column.command && !column.fixed && "adaptiveHidden" !== width && allowResizing) {
                                break
                            }
                        }
                        return lastColumnIndex
                    },
                    isElementInCurrentGrid(controller, $element) {
                        if ($element && $element.length) {
                            const $grid = $element.closest(".".concat(controller.getWidgetContainerClass())).parent();
                            return $grid.is(controller.component.$element())
                        }
                        return false
                    },
                    isVirtualRowRendering(that) {
                        const rowRenderingMode = that.option("scrolling.rowRenderingMode");
                        const isVirtualMode = "virtual" === that.option("scrolling.mode");
                        const isAppendMode = "infinite" === that.option("scrolling.mode");
                        if (false === that.option("scrolling.legacyMode") && (isVirtualMode || isAppendMode)) {
                            return true
                        }
                        return "virtual" === rowRenderingMode
                    },
                    getPixelRatio: window => window.devicePixelRatio || 1,
                    getContentHeightLimit(browser) {
                        if (browser.mozilla) {
                            return 8e6
                        }
                        return 15e6 / this.getPixelRatio((0, _window.getWindow)())
                    },
                    normalizeLookupDataSource(lookup) {
                        let lookupDataSourceOptions;
                        if (lookup.items) {
                            lookupDataSourceOptions = lookup.items
                        } else {
                            lookupDataSourceOptions = lookup.dataSource;
                            if ((0, _type.isFunction)(lookupDataSourceOptions) && !_variable_wrapper.default.isWrapped(lookupDataSourceOptions)) {
                                lookupDataSourceOptions = lookupDataSourceOptions({})
                            }
                        }
                        return (0, _utils.normalizeDataSourceOptions)(lookupDataSourceOptions)
                    },
                    getWrappedLookupDataSource(column, dataSource, filter) {
                        if (!dataSource) {
                            return []
                        }
                        const lookupDataSourceOptions = this.normalizeLookupDataSource(column.lookup);
                        if (column.calculateCellValue !== column.defaultCalculateCellValue) {
                            return lookupDataSourceOptions
                        }
                        const hasGroupPaging = dataSource.remoteOperations().groupPaging;
                        const hasLookupOptimization = column.displayField && (0, _type.isString)(column.displayField);
                        let cachedUniqueRelevantItems;
                        let previousTake;
                        let previousSkip;
                        const sliceItems = (items, loadOptions) => {
                            var _a;
                            const start = null !== (_a = loadOptions.skip) && void 0 !== _a ? _a : 0;
                            const end = loadOptions.take ? start + loadOptions.take : items.length;
                            return items.slice(start, end)
                        };
                        const loadUniqueRelevantItems = loadOptions => {
                            const group = function(group) {
                                if (!Array.isArray(group)) {
                                    group = [group]
                                }
                                return group.map((item, i) => {
                                    if ((0, _type.isString)(item)) {
                                        return {
                                            selector: item,
                                            isExpanded: i < group.length - 1
                                        }
                                    }
                                    return item
                                })
                            }(hasLookupOptimization ? [column.dataField, column.displayField] : column.dataField);
                            const d = new _deferred.Deferred;
                            const canUseCache = cachedUniqueRelevantItems && (!hasGroupPaging || loadOptions.skip === previousSkip && loadOptions.take === previousTake);
                            if (canUseCache) {
                                d.resolve(sliceItems(cachedUniqueRelevantItems, loadOptions))
                            } else {
                                previousSkip = loadOptions.skip;
                                previousTake = loadOptions.take;
                                dataSource.load({
                                    filter: filter,
                                    group: group,
                                    take: hasGroupPaging ? loadOptions.take : void 0,
                                    skip: hasGroupPaging ? loadOptions.skip : void 0
                                }).done(items => {
                                    cachedUniqueRelevantItems = items;
                                    d.resolve(hasGroupPaging ? items : sliceItems(items, loadOptions))
                                }).fail(d.fail)
                            }
                            return d
                        };
                        const lookupDataSource = _extends(_extends({}, lookupDataSourceOptions), {
                            __dataGridSourceFilter: filter,
                            load: loadOptions => {
                                const d = new _deferred.Deferred;
                                loadUniqueRelevantItems(loadOptions).done(items => {
                                    if (0 === items.length) {
                                        d.resolve([]);
                                        return
                                    }
                                    const filter = this.combineFilters(items.flatMap(data => data.key).map(key => [column.lookup.valueExpr, key]), "or");
                                    const newDataSource = new _data_source.DataSource(_extends(_extends(_extends({}, lookupDataSourceOptions), loadOptions), {
                                        filter: this.combineFilters([filter, loadOptions.filter], "and"),
                                        paginate: false
                                    }));
                                    newDataSource.load().done(d.resolve).fail(d.fail)
                                }).fail(d.fail);
                                return d
                            },
                            key: column.lookup.valueExpr,
                            byKey(key) {
                                const d = (0, _deferred.Deferred)();
                                this.load({
                                    filter: [column.lookup.valueExpr, "=", key]
                                }).done(arr => {
                                    d.resolve(arr[0])
                                });
                                return d.promise()
                            }
                        });
                        return lookupDataSource
                    },
                    logHeaderFilterDeprecatedWarningIfNeed(component) {
                        const logWarning = component._logDeprecatedOptionWarning.bind(component);
                        if ((0, _type.isDefined)(component.option("headerFilter.allowSearch"))) {
                            logWarning("headerFilter.allowSearch", {
                                since: "23.1",
                                alias: "headerFilter.search.enabled"
                            })
                        }
                        if ((0, _type.isDefined)(component.option("headerFilter.searchTimeout"))) {
                            logWarning("headerFilter.searchTimeout", {
                                since: "23.1",
                                alias: "headerFilter.search.timeout"
                            })
                        }
                        const specificName = "dxPivotGrid" === component.NAME ? "dataSource.fields" : "columns";
                        const columns = component.option(specificName);
                        if (!Array.isArray(columns)) {
                            return
                        }
                        const logSpecificDeprecatedWarningIfNeed = columns => {
                            columns.forEach(column => {
                                var _a;
                                const headerFilter = column.headerFilter || {};
                                if ((0, _type.isDefined)(headerFilter.allowSearch)) {
                                    logWarning("".concat(specificName, "[].headerFilter.allowSearch"), {
                                        since: "23.1",
                                        alias: "".concat(specificName, "[].headerFilter.search.enabled")
                                    })
                                }
                                if ((0, _type.isDefined)(headerFilter.searchMode)) {
                                    logWarning("".concat(specificName, "[].headerFilter.searchMode"), {
                                        since: "23.1",
                                        alias: "".concat(specificName, "[].headerFilter.search.mode")
                                    })
                                }
                                if (null === (_a = column.columns) || void 0 === _a ? void 0 : _a.length) {
                                    logSpecificDeprecatedWarningIfNeed(column.columns)
                                }
                            })
                        };
                        logSpecificDeprecatedWarningIfNeed(columns)
                    }
                };
                exports.default = _default
            },
        86988:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/m_draggable.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _position = _interopRequireDefault(__webpack_require__( /*! ../animation/position */ 49387));
                var _translator = __webpack_require__( /*! ../animation/translator */ 31648);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../core/component_registrator */ 99393));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../core/dom_component */ 13046));
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _empty_template = __webpack_require__( /*! ../core/templates/empty_template */ 10688);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _inflector = __webpack_require__( /*! ../core/utils/inflector */ 78008);
                var _position2 = __webpack_require__( /*! ../core/utils/position */ 37518);
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _string = __webpack_require__( /*! ../core/utils/string */ 68752);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _view_port = __webpack_require__( /*! ../core/utils/view_port */ 77695);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _drag = __webpack_require__( /*! ../events/drag */ 23174);
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../events/pointer */ 93786));
                var _index = __webpack_require__( /*! ../events/utils/index */ 39611);
                var _animator = _interopRequireDefault(__webpack_require__( /*! ../ui/scroll_view/animator */ 6866));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const window = (0, _window.getWindow)();
                const DRAGGABLE = "dxDraggable";
                const DRAGSTART_EVENT_NAME = (0, _index.addNamespace)(_drag.start, DRAGGABLE);
                const DRAG_EVENT_NAME = (0, _index.addNamespace)(_drag.move, DRAGGABLE);
                const DRAGEND_EVENT_NAME = (0, _index.addNamespace)(_drag.end, DRAGGABLE);
                const DRAG_ENTER_EVENT_NAME = (0, _index.addNamespace)(_drag.enter, DRAGGABLE);
                const DRAGEND_LEAVE_EVENT_NAME = (0, _index.addNamespace)(_drag.leave, DRAGGABLE);
                const POINTERDOWN_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.down, DRAGGABLE);
                const KEYDOWN_EVENT_NAME = (0, _index.addNamespace)("keydown", DRAGGABLE);
                let targetDraggable;
                let sourceDraggable;
                const getMousePosition = event => ({
                    x: event.pageX - (0, _renderer.default)(window).scrollLeft(),
                    y: event.pageY - (0, _renderer.default)(window).scrollTop()
                });
                let ScrollHelper = function() {
                    function ScrollHelper(orientation, component) {
                        this._$scrollableAtPointer = null;
                        this._preventScroll = true;
                        this._component = component;
                        if ("vertical" === orientation) {
                            this._scrollValue = "scrollTop";
                            this._overFlowAttr = "overflowY";
                            this._sizeAttr = "height";
                            this._scrollSizeProp = "scrollHeight";
                            this._clientSizeProp = "clientHeight";
                            this._limitProps = {
                                start: "top",
                                end: "bottom"
                            }
                        } else {
                            this._scrollValue = "scrollLeft";
                            this._overFlowAttr = "overflowX";
                            this._sizeAttr = "width";
                            this._scrollSizeProp = "scrollWidth";
                            this._clientSizeProp = "clientWidth";
                            this._limitProps = {
                                start: "left",
                                end: "right"
                            }
                        }
                    }
                    var _proto = ScrollHelper.prototype;
                    _proto.updateScrollable = function(elements, mousePosition) {
                        let isScrollableFound = false;
                        elements.some(element => {
                            const $element = (0, _renderer.default)(element);
                            const isTargetOverOverlayWrapper = $element.hasClass("dx-overlay-wrapper");
                            const isTargetOverOverlayContent = $element.hasClass("dx-overlay-content");
                            if (isTargetOverOverlayWrapper || isTargetOverOverlayContent) {
                                return true
                            }
                            isScrollableFound = this._trySetScrollable(element, mousePosition);
                            return isScrollableFound
                        });
                        if (!isScrollableFound) {
                            this._$scrollableAtPointer = null;
                            this._scrollSpeed = 0
                        }
                    };
                    _proto.isScrolling = function() {
                        return !!this._scrollSpeed
                    };
                    _proto.isScrollable = function($element) {
                        return ("auto" === $element.css(this._overFlowAttr) || $element.hasClass("dx-scrollable-container")) && $element.prop(this._scrollSizeProp) > Math.ceil("width" === this._sizeAttr ? (0, _size.getWidth)($element) : (0, _size.getHeight)($element))
                    };
                    _proto._trySetScrollable = function(element, mousePosition) {
                        const that = this;
                        const $element = (0, _renderer.default)(element);
                        let distanceToBorders;
                        const sensitivity = that._component.option("scrollSensitivity");
                        let isScrollable = that.isScrollable($element);
                        if (isScrollable) {
                            distanceToBorders = that._calculateDistanceToBorders($element, mousePosition);
                            if (sensitivity > distanceToBorders[that._limitProps.start]) {
                                if (!that._preventScroll) {
                                    that._scrollSpeed = -that._calculateScrollSpeed(distanceToBorders[that._limitProps.start]);
                                    that._$scrollableAtPointer = $element
                                }
                            } else if (sensitivity > distanceToBorders[that._limitProps.end]) {
                                if (!that._preventScroll) {
                                    that._scrollSpeed = that._calculateScrollSpeed(distanceToBorders[that._limitProps.end]);
                                    that._$scrollableAtPointer = $element
                                }
                            } else {
                                isScrollable = false;
                                that._preventScroll = false
                            }
                        }
                        return isScrollable
                    };
                    _proto._calculateDistanceToBorders = function($area, mousePosition) {
                        const area = $area.get(0);
                        let areaBoundingRect;
                        if (area) {
                            areaBoundingRect = (0, _position2.getBoundingRect)(area);
                            return {
                                left: mousePosition.x - areaBoundingRect.left,
                                top: mousePosition.y - areaBoundingRect.top,
                                right: areaBoundingRect.right - mousePosition.x,
                                bottom: areaBoundingRect.bottom - mousePosition.y
                            }
                        }
                        return {}
                    };
                    _proto._calculateScrollSpeed = function(distance) {
                        const component = this._component;
                        const sensitivity = component.option("scrollSensitivity");
                        const maxSpeed = component.option("scrollSpeed");
                        return Math.ceil(((sensitivity - distance) / sensitivity) ** 2 * maxSpeed)
                    };
                    _proto.scrollByStep = function() {
                        const that = this;
                        if (that._$scrollableAtPointer && that._scrollSpeed) {
                            if (that._$scrollableAtPointer.hasClass("dx-scrollable-container")) {
                                const $scrollable = that._$scrollableAtPointer.closest(".dx-scrollable");
                                const scrollableInstance = $scrollable.data("dxScrollable") || $scrollable.data("dxScrollView");
                                if (scrollableInstance) {
                                    const nextScrollPosition = scrollableInstance.scrollOffset()[that._limitProps.start] + that._scrollSpeed;
                                    scrollableInstance.scrollTo({
                                        [that._limitProps.start]: nextScrollPosition
                                    })
                                }
                            } else {
                                const nextScrollPosition = that._$scrollableAtPointer[that._scrollValue]() + that._scrollSpeed;
                                that._$scrollableAtPointer[that._scrollValue](nextScrollPosition)
                            }
                            const dragMoveArgs = that._component._dragMoveArgs;
                            if (dragMoveArgs) {
                                that._component._dragMoveHandler(dragMoveArgs)
                            }
                        }
                    };
                    _proto.reset = function() {
                        this._$scrollableAtPointer = null;
                        this._scrollSpeed = 0;
                        this._preventScroll = true
                    };
                    _proto.isOutsideScrollable = function($scrollable, event) {
                        if (!$scrollable) {
                            return false
                        }
                        const scrollableSize = (0, _position2.getBoundingRect)($scrollable.get(0));
                        const start = scrollableSize[this._limitProps.start];
                        const size = scrollableSize[this._sizeAttr];
                        const mousePosition = getMousePosition(event);
                        const location = "width" === this._sizeAttr ? mousePosition.x : mousePosition.y;
                        return location < start || location > start + size
                    };
                    return ScrollHelper
                }();
                const ScrollAnimator = _animator.default.inherit({
                    ctor(strategy) {
                        this.callBase();
                        this._strategy = strategy
                    },
                    _step() {
                        const horizontalScrollHelper = this._strategy._horizontalScrollHelper;
                        const verticalScrollHelper = this._strategy._verticalScrollHelper;
                        horizontalScrollHelper && horizontalScrollHelper.scrollByStep();
                        verticalScrollHelper && verticalScrollHelper.scrollByStep()
                    }
                });
                const Draggable = _dom_component.default.inherit({
                    reset: _common.noop,
                    dragMove: _common.noop,
                    dragEnter: _common.noop,
                    dragLeave: _common.noop,
                    dragEnd(sourceEvent) {
                        const sourceDraggable = this._getSourceDraggable();
                        sourceDraggable._fireRemoveEvent(sourceEvent);
                        return (0, _deferred.Deferred)().resolve()
                    },
                    _fireRemoveEvent: _common.noop,
                    _getDefaultOptions() {
                        return (0, _extend.extend)(this.callBase(), {
                            onDragStart: null,
                            onDragMove: null,
                            onDragEnd: null,
                            onDragEnter: null,
                            onDragLeave: null,
                            onDragCancel: null,
                            onCancelByEsc: false,
                            onDrop: null,
                            immediate: true,
                            dragDirection: "both",
                            boundary: void 0,
                            boundOffset: 0,
                            allowMoveByClick: false,
                            itemData: null,
                            container: void 0,
                            dragTemplate: void 0,
                            contentTemplate: "content",
                            handle: "",
                            filter: "",
                            clone: false,
                            autoScroll: true,
                            scrollSpeed: 30,
                            scrollSensitivity: 60,
                            group: void 0,
                            data: void 0
                        })
                    },
                    _setOptionsByReference() {
                        this.callBase.apply(this, arguments);
                        (0, _extend.extend)(this._optionsByReference, {
                            component: true,
                            group: true,
                            itemData: true,
                            data: true
                        })
                    },
                    _init() {
                        this.callBase();
                        this._attachEventHandlers();
                        this._scrollAnimator = new ScrollAnimator(this);
                        this._horizontalScrollHelper = new ScrollHelper("horizontal", this);
                        this._verticalScrollHelper = new ScrollHelper("vertical", this);
                        this._initScrollTop = 0;
                        this._initScrollLeft = 0
                    },
                    _normalizeCursorOffset(offset) {
                        if ((0, _type.isObject)(offset)) {
                            offset = {
                                h: offset.x,
                                v: offset.y
                            }
                        }
                        offset = (0, _common.splitPair)(offset).map(value => parseFloat(value));
                        return {
                            left: offset[0],
                            top: 1 === offset.length ? offset[0] : offset[1]
                        }
                    },
                    _getNormalizedCursorOffset(offset, options) {
                        if ((0, _type.isFunction)(offset)) {
                            offset = offset.call(this, options)
                        }
                        return this._normalizeCursorOffset(offset)
                    },
                    _calculateElementOffset(options) {
                        let elementOffset;
                        let dragElementOffset;
                        const {
                            event: event
                        } = options;
                        const $element = (0, _renderer.default)(options.itemElement);
                        const $dragElement = (0, _renderer.default)(options.dragElement);
                        const isCloned = this._dragElementIsCloned();
                        const cursorOffset = this.option("cursorOffset");
                        let normalizedCursorOffset = {
                            left: 0,
                            top: 0
                        };
                        const currentLocate = this._initialLocate = (0, _translator.locate)($dragElement);
                        if (isCloned || options.initialOffset || cursorOffset) {
                            elementOffset = options.initialOffset || $element.offset();
                            if (cursorOffset) {
                                normalizedCursorOffset = this._getNormalizedCursorOffset(cursorOffset, options);
                                if (isFinite(normalizedCursorOffset.left)) {
                                    elementOffset.left = event.pageX
                                }
                                if (isFinite(normalizedCursorOffset.top)) {
                                    elementOffset.top = event.pageY
                                }
                            }
                            dragElementOffset = $dragElement.offset();
                            elementOffset.top -= dragElementOffset.top + (normalizedCursorOffset.top || 0) - currentLocate.top;
                            elementOffset.left -= dragElementOffset.left + (normalizedCursorOffset.left || 0) - currentLocate.left
                        }
                        return elementOffset
                    },
                    _initPosition(options) {
                        const $dragElement = (0, _renderer.default)(options.dragElement);
                        const elementOffset = this._calculateElementOffset(options);
                        if (elementOffset) {
                            this._move(elementOffset, $dragElement)
                        }
                        this._startPosition = (0, _translator.locate)($dragElement)
                    },
                    _startAnimator() {
                        if (!this._scrollAnimator.inProgress()) {
                            this._scrollAnimator.start()
                        }
                    },
                    _stopAnimator() {
                        this._scrollAnimator.stop()
                    },
                    _addWidgetPrefix(className) {
                        const componentName = this.NAME;
                        return (0, _inflector.dasherize)(componentName) + (className ? "-".concat(className) : "")
                    },
                    _getItemsSelector() {
                        return this.option("filter") || ""
                    },
                    _$content() {
                        const $element = this.$element();
                        const $wrapper = $element.children(".dx-template-wrapper");
                        return $wrapper.length ? $wrapper : $element
                    },
                    _attachEventHandlers() {
                        if (this.option("disabled")) {
                            return
                        }
                        let $element = this._$content();
                        let itemsSelector = this._getItemsSelector();
                        const allowMoveByClick = this.option("allowMoveByClick");
                        const data = {
                            direction: this.option("dragDirection"),
                            immediate: this.option("immediate"),
                            checkDropTarget: ($target, event) => {
                                const targetGroup = this.option("group");
                                const sourceGroup = this._getSourceDraggable().option("group");
                                const $scrollable = this._getScrollable($target);
                                if (this._verticalScrollHelper.isOutsideScrollable($scrollable, event) || this._horizontalScrollHelper.isOutsideScrollable($scrollable, event)) {
                                    return false
                                }
                                return sourceGroup && sourceGroup === targetGroup
                            }
                        };
                        if (allowMoveByClick) {
                            $element = this._getArea();
                            _events_engine.default.on($element, POINTERDOWN_EVENT_NAME, data, this._pointerDownHandler.bind(this))
                        }
                        if (">" === itemsSelector[0]) {
                            itemsSelector = itemsSelector.slice(1)
                        }
                        _events_engine.default.on($element, DRAGSTART_EVENT_NAME, itemsSelector, data, this._dragStartHandler.bind(this));
                        _events_engine.default.on($element, DRAG_EVENT_NAME, data, this._dragMoveHandler.bind(this));
                        _events_engine.default.on($element, DRAGEND_EVENT_NAME, data, this._dragEndHandler.bind(this));
                        _events_engine.default.on($element, DRAG_ENTER_EVENT_NAME, data, this._dragEnterHandler.bind(this));
                        _events_engine.default.on($element, DRAGEND_LEAVE_EVENT_NAME, data, this._dragLeaveHandler.bind(this));
                        if (this.option("onCancelByEsc")) {
                            _events_engine.default.on($element, KEYDOWN_EVENT_NAME, this._keydownHandler.bind(this))
                        }
                    },
                    _dragElementIsCloned() {
                        return this._$dragElement && this._$dragElement.hasClass(this._addWidgetPrefix("clone"))
                    },
                    _getDragTemplateArgs($element, $container) {
                        return {
                            container: (0, _element.getPublicElement)($container),
                            model: {
                                itemData: this.option("itemData"),
                                itemElement: (0, _element.getPublicElement)($element)
                            }
                        }
                    },
                    _createDragElement($element) {
                        let result = $element;
                        const clone = this.option("clone");
                        const $container = this._getContainer();
                        let template = this.option("dragTemplate");
                        if (template) {
                            template = this._getTemplate(template);
                            result = (0, _renderer.default)("<div>").appendTo($container);
                            template.render(this._getDragTemplateArgs($element, result))
                        } else if (clone) {
                            result = (0, _renderer.default)("<div>").appendTo($container);
                            $element.clone().css({
                                width: $element.css("width"),
                                height: $element.css("height")
                            }).appendTo(result)
                        }
                        return result.toggleClass(this._addWidgetPrefix("clone"), result.get(0) !== $element.get(0)).toggleClass("dx-rtl", this.option("rtlEnabled"))
                    },
                    _resetDragElement() {
                        if (this._dragElementIsCloned()) {
                            this._$dragElement.remove()
                        } else {
                            this._toggleDraggingClass(false)
                        }
                        this._$dragElement = null
                    },
                    _resetSourceElement() {
                        this._toggleDragSourceClass(false);
                        this._$sourceElement = null
                    },
                    _detachEventHandlers() {
                        _events_engine.default.off(this._$content(), ".".concat(DRAGGABLE));
                        _events_engine.default.off(this._getArea(), ".".concat(DRAGGABLE))
                    },
                    _move(position, $element) {
                        (0, _translator.move)($element || this._$dragElement, position)
                    },
                    _getDraggableElement(e) {
                        const $sourceElement = this._getSourceElement();
                        if ($sourceElement) {
                            return $sourceElement
                        }
                        const allowMoveByClick = this.option("allowMoveByClick");
                        if (allowMoveByClick) {
                            return this.$element()
                        }
                        let $target = (0, _renderer.default)(e && e.target);
                        const itemsSelector = this._getItemsSelector();
                        if (">" === itemsSelector[0]) {
                            const $items = this._$content().find(itemsSelector);
                            if (!$items.is($target)) {
                                $target = $target.closest($items)
                            }
                        }
                        return $target
                    },
                    _getSourceElement() {
                        const draggable = this._getSourceDraggable();
                        return draggable._$sourceElement
                    },
                    _pointerDownHandler(e) {
                        if ((0, _index.needSkipEvent)(e)) {
                            return
                        }
                        const position = {};
                        const $element = this.$element();
                        const dragDirection = this.option("dragDirection");
                        if ("horizontal" === dragDirection || "both" === dragDirection) {
                            position.left = e.pageX - $element.offset().left + (0, _translator.locate)($element).left - (0, _size.getWidth)($element) / 2
                        }
                        if ("vertical" === dragDirection || "both" === dragDirection) {
                            position.top = e.pageY - $element.offset().top + (0, _translator.locate)($element).top - (0, _size.getHeight)($element) / 2
                        }
                        this._move(position, $element);
                        this._getAction("onDragMove")(this._getEventArgs(e))
                    },
                    _isValidElement(event, $element) {
                        const handle = this.option("handle");
                        const $target = (0, _renderer.default)(event.originalEvent && event.originalEvent.target);
                        if (handle && !$target.closest(handle).length) {
                            return false
                        }
                        if (!$element.length) {
                            return false
                        }
                        return !$element.is(".dx-state-disabled, .dx-state-disabled *")
                    },
                    _dragStartHandler(e) {
                        const $element = this._getDraggableElement(e);
                        this.dragInProgress = true;
                        if (!this._isValidElement(e, $element)) {
                            e.cancel = true;
                            return
                        }
                        if (this._$sourceElement) {
                            return
                        }
                        const dragStartArgs = this._getDragStartArgs(e, $element);
                        this._getAction("onDragStart")(dragStartArgs);
                        if (dragStartArgs.cancel) {
                            e.cancel = true;
                            return
                        }
                        this.option("itemData", dragStartArgs.itemData);
                        this._setSourceDraggable();
                        this._$sourceElement = $element;
                        let initialOffset = $element.offset();
                        if (!this._hasClonedDraggable() && this.option("autoScroll")) {
                            this._initScrollTop = this._getScrollableScrollTop();
                            this._initScrollLeft = this._getScrollableScrollLeft();
                            initialOffset = this._getDraggableElementOffset(initialOffset.left, initialOffset.top)
                        }
                        const $dragElement = this._$dragElement = this._createDragElement($element);
                        this._toggleDraggingClass(true);
                        this._toggleDragSourceClass(true);
                        this._setGestureCoverCursor($dragElement.children());
                        const isFixedPosition = "fixed" === $dragElement.css("position");
                        this._initPosition((0, _extend.extend)({}, dragStartArgs, {
                            dragElement: $dragElement.get(0),
                            initialOffset: isFixedPosition && initialOffset
                        }));
                        this._getAction("onDraggableElementShown")(_extends(_extends({}, dragStartArgs), {
                            dragElement: $dragElement
                        }));
                        const $area = this._getArea();
                        const areaOffset = this._getAreaOffset($area);
                        const boundOffset = this._getBoundOffset();
                        const areaWidth = (0, _size.getOuterWidth)($area);
                        const areaHeight = (0, _size.getOuterHeight)($area);
                        const elementWidth = (0, _size.getWidth)($dragElement);
                        const elementHeight = (0, _size.getHeight)($dragElement);
                        const startOffset_left = $dragElement.offset().left - areaOffset.left,
                            startOffset_top = $dragElement.offset().top - areaOffset.top;
                        if ($area.length) {
                            e.maxLeftOffset = startOffset_left - boundOffset.left;
                            e.maxRightOffset = areaWidth - startOffset_left - elementWidth - boundOffset.right;
                            e.maxTopOffset = startOffset_top - boundOffset.top;
                            e.maxBottomOffset = areaHeight - startOffset_top - elementHeight - boundOffset.bottom
                        }
                        if (this.option("autoScroll")) {
                            this._startAnimator()
                        }
                    },
                    _getAreaOffset($area) {
                        const offset = $area && _position.default.offset($area);
                        return offset || {
                            left: 0,
                            top: 0
                        }
                    },
                    _toggleDraggingClass(value) {
                        this._$dragElement && this._$dragElement.toggleClass(this._addWidgetPrefix("dragging"), value)
                    },
                    _toggleDragSourceClass(value, $element) {
                        const $sourceElement = $element || this._$sourceElement;
                        $sourceElement && $sourceElement.toggleClass(this._addWidgetPrefix("source"), value)
                    },
                    _setGestureCoverCursor($element) {
                        (0, _renderer.default)(".".concat("dx-gesture-cover")).css("cursor", $element.css("cursor"))
                    },
                    _getBoundOffset() {
                        let boundOffset = this.option("boundOffset");
                        if ((0, _type.isFunction)(boundOffset)) {
                            boundOffset = boundOffset.call(this)
                        }
                        return (0, _string.quadToObject)(boundOffset)
                    },
                    _getArea() {
                        let area = this.option("boundary");
                        if ((0, _type.isFunction)(area)) {
                            area = area.call(this)
                        }
                        return (0, _renderer.default)(area)
                    },
                    _getContainer() {
                        let container = this.option("container");
                        if (void 0 === container) {
                            container = (0, _view_port.value)()
                        }
                        return (0, _renderer.default)(container)
                    },
                    _getDraggableElementOffset(initialOffsetX, initialOffsetY) {
                        var _a, _b, _c, _d;
                        const initScrollTop = this._initScrollTop;
                        const initScrollLeft = this._initScrollLeft;
                        const scrollTop = this._getScrollableScrollTop();
                        const scrollLeft = this._getScrollableScrollLeft();
                        const elementPosition = (0, _renderer.default)(this.element()).css("position");
                        const isFixedPosition = "fixed" === elementPosition;
                        const result = {
                            left: (null !== (_b = null === (_a = this._startPosition) || void 0 === _a ? void 0 : _a.left) && void 0 !== _b ? _b : 0) + initialOffsetX,
                            top: (null !== (_d = null === (_c = this._startPosition) || void 0 === _c ? void 0 : _c.top) && void 0 !== _d ? _d : 0) + initialOffsetY
                        };
                        if (isFixedPosition || this._hasClonedDraggable()) {
                            return result
                        }
                        return {
                            left: (0, _type.isNumeric)(scrollLeft) ? result.left + scrollLeft - initScrollLeft : result.left,
                            top: (0, _type.isNumeric)(scrollTop) ? result.top + scrollTop - initScrollTop : result.top
                        }
                    },
                    _hasClonedDraggable() {
                        return this.option("clone") || this.option("dragTemplate")
                    },
                    _dragMoveHandler(e) {
                        this._dragMoveArgs = e;
                        if (!this._$dragElement) {
                            e.cancel = true;
                            return
                        }
                        const offset = this._getDraggableElementOffset(e.offset.x, e.offset.y);
                        this._move(offset);
                        this._updateScrollable(e);
                        const eventArgs = this._getEventArgs(e);
                        this._getAction("onDragMove")(eventArgs);
                        if (true === eventArgs.cancel) {
                            return
                        }
                        const targetDraggable = this._getTargetDraggable();
                        targetDraggable.dragMove(e, scrollBy)
                    },
                    _updateScrollable(e) {
                        const that = this;
                        if (that.option("autoScroll")) {
                            const mousePosition = getMousePosition(e);
                            const allObjects = _dom_adapter.default.elementsFromPoint(mousePosition.x, mousePosition.y, this.$element().get(0));
                            that._verticalScrollHelper.updateScrollable(allObjects, mousePosition);
                            that._horizontalScrollHelper.updateScrollable(allObjects, mousePosition)
                        }
                    },
                    _getScrollable($element) {
                        let $scrollable;
                        $element.parents().toArray().some(parent => {
                            const $parent = (0, _renderer.default)(parent);
                            if (this._horizontalScrollHelper.isScrollable($parent) || this._verticalScrollHelper.isScrollable($parent)) {
                                $scrollable = $parent;
                                return true
                            }
                            return false
                        });
                        return $scrollable
                    },
                    _getScrollableScrollTop() {
                        var _a, _b;
                        return null !== (_b = null === (_a = this._getScrollable((0, _renderer.default)(this.element()))) || void 0 === _a ? void 0 : _a.scrollTop()) && void 0 !== _b ? _b : 0
                    },
                    _getScrollableScrollLeft() {
                        var _a, _b;
                        return null !== (_b = null === (_a = this._getScrollable((0, _renderer.default)(this.element()))) || void 0 === _a ? void 0 : _a.scrollLeft()) && void 0 !== _b ? _b : 0
                    },
                    _defaultActionArgs() {
                        const args = this.callBase.apply(this, arguments);
                        const component = this.option("component");
                        if (component) {
                            args.component = component;
                            args.element = component.element()
                        }
                        return args
                    },
                    _getEventArgs(e) {
                        const sourceDraggable = this._getSourceDraggable();
                        const targetDraggable = this._getTargetDraggable();
                        return {
                            event: e,
                            itemData: sourceDraggable.option("itemData"),
                            itemElement: (0, _element.getPublicElement)(sourceDraggable._$sourceElement),
                            fromComponent: sourceDraggable.option("component") || sourceDraggable,
                            toComponent: targetDraggable.option("component") || targetDraggable,
                            fromData: sourceDraggable.option("data"),
                            toData: targetDraggable.option("data")
                        }
                    },
                    _getDragStartArgs(e, $itemElement) {
                        const args = this._getEventArgs(e);
                        return {
                            event: args.event,
                            itemData: args.itemData,
                            itemElement: $itemElement,
                            fromData: args.fromData
                        }
                    },
                    _revertItemToInitialPosition() {
                        !this._dragElementIsCloned() && this._move(this._initialLocate, this._$sourceElement)
                    },
                    _dragEndHandler(e) {
                        const d = (0, _deferred.Deferred)();
                        const dragEndEventArgs = this._getEventArgs(e);
                        const dropEventArgs = this._getEventArgs(e);
                        const targetDraggable = this._getTargetDraggable();
                        let needRevertPosition = true;
                        this.dragInProgress = false;
                        try {
                            this._getAction("onDragEnd")(dragEndEventArgs)
                        } finally {
                            (0, _deferred.when)((0, _deferred.fromPromise)(dragEndEventArgs.cancel)).done(cancel => {
                                if (!cancel) {
                                    if (targetDraggable !== this) {
                                        targetDraggable._getAction("onDrop")(dropEventArgs)
                                    }
                                    if (!dropEventArgs.cancel) {
                                        needRevertPosition = false;
                                        (0, _deferred.when)((0, _deferred.fromPromise)(targetDraggable.dragEnd(dragEndEventArgs))).always(d.resolve);
                                        return
                                    }
                                }
                                d.resolve()
                            }).fail(d.resolve);
                            d.done(() => {
                                if (needRevertPosition) {
                                    this._revertItemToInitialPosition()
                                }
                                this._resetDragOptions(targetDraggable)
                            })
                        }
                    },
                    _isTargetOverAnotherDraggable(e) {
                        const sourceDraggable = this._getSourceDraggable();
                        if (this === sourceDraggable) {
                            return false
                        }
                        const $dragElement = sourceDraggable._$dragElement;
                        const $sourceDraggableElement = sourceDraggable.$element();
                        const $targetDraggableElement = this.$element();
                        const mousePosition = getMousePosition(e);
                        const elements = _dom_adapter.default.elementsFromPoint(mousePosition.x, mousePosition.y, this.element());
                        const firstWidgetElement = elements.filter(element => {
                            const $element = (0, _renderer.default)(element);
                            if ($element.hasClass(this._addWidgetPrefix())) {
                                return !$element.closest($dragElement).length
                            }
                            return false
                        })[0];
                        const $sourceElement = this._getSourceElement();
                        const isTargetOverItself = firstWidgetElement === $sourceDraggableElement.get(0);
                        const isTargetOverNestedDraggable = (0, _renderer.default)(firstWidgetElement).closest($sourceElement).length;
                        return !firstWidgetElement || firstWidgetElement === $targetDraggableElement.get(0) && !isTargetOverItself && !isTargetOverNestedDraggable
                    },
                    _dragEnterHandler(e) {
                        this._fireDragEnterEvent(e);
                        if (this._isTargetOverAnotherDraggable(e)) {
                            this._setTargetDraggable()
                        }
                        const sourceDraggable = this._getSourceDraggable();
                        sourceDraggable.dragEnter(e)
                    },
                    _dragLeaveHandler(e) {
                        this._fireDragLeaveEvent(e);
                        this._resetTargetDraggable();
                        if (this !== this._getSourceDraggable()) {
                            this.reset()
                        }
                        const sourceDraggable = this._getSourceDraggable();
                        sourceDraggable.dragLeave(e)
                    },
                    _keydownHandler(e) {
                        if (this.dragInProgress && "Escape" === e.key) {
                            this._keydownEscapeHandler(e)
                        }
                    },
                    _keydownEscapeHandler(e) {
                        const $sourceElement = this._getSourceElement();
                        if (!$sourceElement) {
                            return
                        }
                        const dragCancelEventArgs = this._getEventArgs(e);
                        this._getAction("onDragCancel")(dragCancelEventArgs);
                        if (dragCancelEventArgs.cancel) {
                            return
                        }
                        this.dragInProgress = false;
                        null === sourceDraggable || void 0 === sourceDraggable ? void 0 : sourceDraggable._toggleDraggingClass(false);
                        this._detachEventHandlers();
                        this._revertItemToInitialPosition();
                        const targetDraggable = this._getTargetDraggable();
                        this._resetDragOptions(targetDraggable);
                        this._attachEventHandlers()
                    },
                    _getAction(name) {
                        return this["_".concat(name, "Action")] || this._createActionByOption(name)
                    },
                    _getAnonymousTemplateName: () => "content",
                    _initTemplates() {
                        if (!this.option("contentTemplate")) {
                            return
                        }
                        this._templateManager.addDefaultTemplates({
                            content: new _empty_template.EmptyTemplate
                        });
                        this.callBase.apply(this, arguments)
                    },
                    _render() {
                        this.callBase();
                        this.$element().addClass(this._addWidgetPrefix());
                        const transclude = this._templateManager.anonymousTemplateName === this.option("contentTemplate");
                        const template = this._getTemplateByOption("contentTemplate");
                        if (template) {
                            (0, _renderer.default)(template.render({
                                container: this.element(),
                                transclude: transclude
                            }))
                        }
                    },
                    _optionChanged(args) {
                        const {
                            name: name
                        } = args;
                        switch (name) {
                            case "onDragStart":
                            case "onDragMove":
                            case "onDragEnd":
                            case "onDrop":
                            case "onDragEnter":
                            case "onDragLeave":
                            case "onDragCancel":
                            case "onDraggableElementShown":
                                this["_".concat(name, "Action")] = this._createActionByOption(name);
                                break;
                            case "dragTemplate":
                            case "contentTemplate":
                            case "container":
                            case "clone":
                                break;
                            case "allowMoveByClick":
                            case "dragDirection":
                            case "disabled":
                            case "boundary":
                            case "filter":
                            case "immediate":
                                this._resetDragElement();
                                this._detachEventHandlers();
                                this._attachEventHandlers();
                                break;
                            case "onCancelByEsc":
                                this._keydownHandler();
                                break;
                            case "autoScroll":
                                this._verticalScrollHelper.reset();
                                this._horizontalScrollHelper.reset();
                                break;
                            case "scrollSensitivity":
                            case "scrollSpeed":
                            case "boundOffset":
                            case "handle":
                            case "group":
                            case "data":
                            case "itemData":
                                break;
                            default:
                                this.callBase(args)
                        }
                    },
                    _getTargetDraggable() {
                        return targetDraggable || this
                    },
                    _getSourceDraggable() {
                        return sourceDraggable || this
                    },
                    _setTargetDraggable() {
                        const currentGroup = this.option("group");
                        const sourceDraggable = this._getSourceDraggable();
                        if (currentGroup && currentGroup === sourceDraggable.option("group")) {
                            targetDraggable = this
                        }
                    },
                    _setSourceDraggable() {
                        sourceDraggable = this
                    },
                    _resetSourceDraggable() {
                        sourceDraggable = null
                    },
                    _resetTargetDraggable() {
                        targetDraggable = null
                    },
                    _resetDragOptions(targetDraggable) {
                        this.reset();
                        targetDraggable.reset();
                        this._stopAnimator();
                        this._horizontalScrollHelper.reset();
                        this._verticalScrollHelper.reset();
                        this._resetDragElement();
                        this._resetSourceElement();
                        this._resetTargetDraggable();
                        this._resetSourceDraggable()
                    },
                    _dispose() {
                        this.callBase();
                        this._detachEventHandlers();
                        this._resetDragElement();
                        this._resetTargetDraggable();
                        this._resetSourceDraggable();
                        this._$sourceElement = null;
                        this._stopAnimator()
                    },
                    _fireDragEnterEvent(sourceEvent) {
                        const args = this._getEventArgs(sourceEvent);
                        this._getAction("onDragEnter")(args)
                    },
                    _fireDragLeaveEvent(sourceEvent) {
                        const args = this._getEventArgs(sourceEvent);
                        this._getAction("onDragLeave")(args)
                    }
                });
                (0, _component_registrator.default)(DRAGGABLE, Draggable);
                var _default = Draggable;
                exports.default = _default
            },
        90006:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/m_date_adapter.js ***!
              \************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _date = (obj = __webpack_require__( /*! ../../core/utils/date */ 91198), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;

                function _defineProperties(target, props) {
                    for (var i = 0; i < props.length; i++) {
                        var descriptor = props[i];
                        descriptor.enumerable = descriptor.enumerable || false;
                        descriptor.configurable = true;
                        if ("value" in descriptor) {
                            descriptor.writable = true
                        }
                        Object.defineProperty(target, (arg = descriptor.key, key = void 0, key = function(input, hint) {
                            if ("object" !== typeof input || null === input) {
                                return input
                            }
                            var prim = input[Symbol.toPrimitive];
                            if (void 0 !== prim) {
                                var res = prim.call(input, hint || "default");
                                if ("object" !== typeof res) {
                                    return res
                                }
                                throw new TypeError("@@toPrimitive must return a primitive value.")
                            }
                            return ("string" === hint ? String : Number)(input)
                        }(arg, "string"), "symbol" === typeof key ? key : String(key)), descriptor)
                    }
                    var arg, key
                }
                const toMs = _date.default.dateToMilliseconds;
                let DateAdapterCore = function() {
                    function DateAdapterCore(source) {
                        this._source = new Date(source.getTime ? source.getTime() : source)
                    }
                    var _proto = DateAdapterCore.prototype;
                    _proto.result = function() {
                        return this._source
                    };
                    _proto.getTimezoneOffset = function() {
                        let format = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : void 0;
                        const value = this._source.getTimezoneOffset();
                        if ("minute" === format) {
                            return value * toMs("minute")
                        }
                        return value
                    };
                    _proto.getTime = function() {
                        return this._source.getTime()
                    };
                    _proto.setTime = function(value) {
                        this._source.setTime(value);
                        return this
                    };
                    _proto.addTime = function(value) {
                        this._source.setTime(this._source.getTime() + value);
                        return this
                    };
                    _proto.setMinutes = function(value) {
                        this._source.setMinutes(value);
                        return this
                    };
                    _proto.addMinutes = function(value) {
                        this._source.setMinutes(this._source.getMinutes() + value);
                        return this
                    };
                    _proto.subtractMinutes = function(value) {
                        this._source.setMinutes(this._source.getMinutes() - value);
                        return this
                    };
                    ! function(Constructor, protoProps, staticProps) {
                        if (protoProps) {
                            _defineProperties(Constructor.prototype, protoProps)
                        }
                        if (staticProps) {
                            _defineProperties(Constructor, staticProps)
                        }
                        Object.defineProperty(Constructor, "prototype", {
                            writable: false
                        });
                        return Constructor
                    }(DateAdapterCore, [{
                        key: "source",
                        get: function() {
                            return this._source
                        }
                    }]);
                    return DateAdapterCore
                }();
                var _default = date => new DateAdapterCore(date);
                exports.default = _default
            },
        57880:
            /*!***************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/m_utils_time_zone.js ***!
              \***************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _date = __webpack_require__( /*! ../core/utils/date */ 24321);
                var _date2 = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date */ 91198));
                var _m_date_adapter = _interopRequireDefault(__webpack_require__( /*! ./m_date_adapter */ 90006));
                var _m_utils_timezones_data = _interopRequireDefault(__webpack_require__( /*! ./timezones/m_utils_timezones_data */ 23778));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const toMs = _date2.default.dateToMilliseconds;
                const createUTCDate = date => new Date(Date.UTC(date.getUTCFullYear(), date.getUTCMonth(), date.getUTCDate(), date.getUTCHours(), date.getUTCMinutes()));
                const getTimezoneOffsetChangeInMinutes = (startDate, endDate, updatedStartDate, updatedEndDate) => getDaylightOffset(updatedStartDate, updatedEndDate) - getDaylightOffset(startDate, endDate);
                const getDaylightOffset = (startDate, endDate) => new Date(startDate).getTimezoneOffset() - new Date(endDate).getTimezoneOffset();
                const getDaylightOffsetInMs = (startDate, endDate) => getDaylightOffset(startDate, endDate) * toMs("minute");
                const calculateTimezoneByValue = function(timezone) {
                    let date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                    if ("string" === typeof timezone) {
                        const dateUtc = createUTCDate(date);
                        return _m_utils_timezones_data.default.getTimeZoneOffsetById(timezone, dateUtc.getTime())
                    }
                    return timezone
                };
                const _getDaylightOffsetByTimezone = (startDate, endDate, timeZone) => calculateTimezoneByValue(timeZone, startDate) - calculateTimezoneByValue(timeZone, endDate);
                const isTimezoneChangeInDate = date => {
                    const startDayDate = new Date(new Date(date).setHours(0, 0, 0, 0));
                    const endDayDate = new Date(new Date(date).setHours(23, 59, 59, 0));
                    return startDayDate.getTimezoneOffset() - endDayDate.getTimezoneOffset() !== 0
                };
                const getClientTimezoneOffset = function() {
                    let date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                    return 6e4 * date.getTimezoneOffset()
                };
                const hasDSTInLocalTimeZone = () => {
                    const [startDate, endDate] = getExtremeDates();
                    return startDate.getTimezoneOffset() !== endDate.getTimezoneOffset()
                };
                const isEqualLocalTimeZoneByDeclaration = (timeZoneName, date) => {
                    const year = date.getFullYear();
                    const getOffset = date => -date.getTimezoneOffset() / 60;
                    const getDateAndMoveHourBack = dateStamp => new Date(dateStamp - 36e5);
                    const configTuple = _m_utils_timezones_data.default.getTimeZoneDeclarationTuple(timeZoneName, year);
                    const [summerTime, winterTime] = configTuple;
                    const noDSTInTargetTimeZone = configTuple.length < 2;
                    if (noDSTInTargetTimeZone) {
                        const targetTimeZoneOffset = _m_utils_timezones_data.default.getTimeZoneOffsetById(timeZoneName, date);
                        const localTimeZoneOffset = getOffset(date);
                        if (targetTimeZoneOffset !== localTimeZoneOffset) {
                            return false
                        }
                        return !hasDSTInLocalTimeZone()
                    }
                    const localSummerOffset = getOffset(new Date(summerTime.date));
                    const localWinterOffset = getOffset(new Date(winterTime.date));
                    if (localSummerOffset !== summerTime.offset) {
                        return false
                    }
                    if (localSummerOffset === getOffset(getDateAndMoveHourBack(summerTime.date))) {
                        return false
                    }
                    if (localWinterOffset !== winterTime.offset) {
                        return false
                    }
                    if (localWinterOffset === getOffset(getDateAndMoveHourBack(winterTime.date))) {
                        return false
                    }
                    return true
                };
                const getExtremeDates = () => {
                    const nowDate = new Date(Date.now());
                    const startDate = new Date;
                    const endDate = new Date;
                    startDate.setFullYear(nowDate.getFullYear(), 0, 1);
                    endDate.setFullYear(nowDate.getFullYear(), 6, 1);
                    return [startDate, endDate]
                };
                const isSummerToWinterDSTChange = timezoneDiff => timezoneDiff < 0;
                const utils = {
                    getDaylightOffset: getDaylightOffset,
                    getDaylightOffsetInMs: getDaylightOffsetInMs,
                    getTimezoneOffsetChangeInMinutes: getTimezoneOffsetChangeInMinutes,
                    getTimezoneOffsetChangeInMs: (startDate, endDate, updatedStartDate, updatedEndDate) => getTimezoneOffsetChangeInMinutes(startDate, endDate, updatedStartDate, updatedEndDate) * toMs("minute"),
                    calculateTimezoneByValue: calculateTimezoneByValue,
                    getCorrectedDateByDaylightOffsets: (convertedOriginalStartDate, convertedDate, date, timeZone, startDateTimezone) => {
                        const daylightOffsetByCommonTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, timeZone);
                        const daylightOffsetByAppointmentTimezone = _getDaylightOffsetByTimezone(convertedOriginalStartDate, convertedDate, startDateTimezone);
                        const diff = daylightOffsetByCommonTimezone - daylightOffsetByAppointmentTimezone;
                        return new Date(date.getTime() - diff * toMs("hour"))
                    },
                    isSameAppointmentDates: (startDate, endDate) => {
                        endDate = new Date(endDate.getTime() - 1);
                        return _date2.default.sameDate(startDate, endDate)
                    },
                    correctRecurrenceExceptionByTimezone: function(exception, exceptionByStartDate, timeZone, startDateTimeZone) {
                        let isBackConversion = arguments.length > 4 && void 0 !== arguments[4] ? arguments[4] : false;
                        let timezoneOffset = (exception.getTimezoneOffset() - exceptionByStartDate.getTimezoneOffset()) / 60;
                        if (startDateTimeZone) {
                            timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, startDateTimeZone)
                        } else if (timeZone) {
                            timezoneOffset = _getDaylightOffsetByTimezone(exceptionByStartDate, exception, timeZone)
                        }
                        return new Date(exception.getTime() + (isBackConversion ? -1 : 1) * timezoneOffset * toMs("hour"))
                    },
                    getClientTimezoneOffset: getClientTimezoneOffset,
                    getDiffBetweenClientTimezoneOffsets: function() {
                        let firstDate = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                        let secondDate = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                        return getClientTimezoneOffset(firstDate) - getClientTimezoneOffset(secondDate)
                    },
                    createUTCDateWithLocalOffset: date => {
                        if (!date) {
                            return null
                        }
                        return new Date(Date.UTC(date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()))
                    },
                    createDateFromUTCWithLocalOffset: date => {
                        const result = (0, _m_date_adapter.default)(date);
                        const timezoneOffsetBeforeInMin = result.getTimezoneOffset();
                        result.addTime(result.getTimezoneOffset("minute"));
                        result.subtractMinutes(timezoneOffsetBeforeInMin - result.getTimezoneOffset());
                        return result.source
                    },
                    createUTCDate: createUTCDate,
                    isTimezoneChangeInDate: isTimezoneChangeInDate,
                    getDateWithoutTimezoneChange: date => {
                        const clonedDate = new Date(date);
                        if (isTimezoneChangeInDate(clonedDate)) {
                            const result = new Date(clonedDate);
                            return new Date(result.setDate(result.getDate() + 1))
                        }
                        return clonedDate
                    },
                    hasDSTInLocalTimeZone: hasDSTInLocalTimeZone,
                    isEqualLocalTimeZone: function(timeZoneName) {
                        let date = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : new Date;
                        if (Intl) {
                            const localTimeZoneName = Intl.DateTimeFormat().resolvedOptions().timeZone;
                            if (localTimeZoneName === timeZoneName) {
                                return true
                            }
                        }
                        return isEqualLocalTimeZoneByDeclaration(timeZoneName, date)
                    },
                    isEqualLocalTimeZoneByDeclaration: isEqualLocalTimeZoneByDeclaration,
                    getTimeZones: function() {
                        let date = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : new Date;
                        const dateInUTC = createUTCDate(date);
                        return _m_utils_timezones_data.default.getDisplayedTimeZones(dateInUTC.getTime())
                    },
                    setOffsetsToDate: (targetDate, offsetsArray) => {
                        const newDateMs = offsetsArray.reduce((result, offset) => result + offset, targetDate.getTime());
                        return new Date(newDateMs)
                    },
                    addOffsetsWithoutDST: function(date) {
                        for (var _len = arguments.length, offsets = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                            offsets[_key - 1] = arguments[_key]
                        }
                        const newDate = _date.dateUtilsTs.addOffsets(date, offsets);
                        const daylightShift = getDaylightOffsetInMs(date, newDate);
                        if (!daylightShift) {
                            return newDate
                        }
                        const correctLocalDate = _date.dateUtilsTs.addOffsets(newDate, [-daylightShift]);
                        const daylightSecondShift = getDaylightOffsetInMs(newDate, correctLocalDate);
                        return !daylightSecondShift ? correctLocalDate : newDate
                    },
                    isNegativeMachineTimezone: () => (new Date).getTimezoneOffset() > 0,
                    isSummerTimeDSTChange: isSummerToWinterDSTChange,
                    getSummerToWinterTimeDSTDiffMs: (firstDate, secondDate) => {
                        const diffMinutes = getDaylightOffset(firstDate, secondDate);
                        const isSummerTimeChange = isSummerToWinterDSTChange(diffMinutes);
                        return isSummerTimeChange ? Math.abs(diffMinutes * toMs("minute")) : 0
                    }
                };
                var _default = utils;
                exports.default = _default
            },
        23778:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/timezones/m_utils_timezones_data.js ***!
              \******************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../core/errors */ 17381));
                var _math = __webpack_require__( /*! ../../../core/utils/math */ 60810);
                var _query = _interopRequireDefault(__webpack_require__( /*! ../../../data/query */ 96687));
                var _timezones_data = _interopRequireDefault(__webpack_require__( /*! ./timezones_data */ 28882));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const parseTimezone = timeZoneConfig => {
                    const {
                        offsets: offsets
                    } = timeZoneConfig;
                    const {
                        offsetIndices: offsetIndices
                    } = timeZoneConfig;
                    const {
                        untils: untils
                    } = timeZoneConfig;
                    const offsetList = offsets.split("|").map(value => parseInt(value));
                    const offsetIndexList = offsetIndices.split("").map(value => parseInt(value));
                    const dateList = (value = untils, value.split("|").map(until => {
                        if ("Infinity" === until) {
                            return null
                        }
                        return 1e3 * parseInt(until, 36)
                    })).map((accumulator = 0, value => accumulator += value));
                    var accumulator;
                    var value;
                    return {
                        offsetList: offsetList,
                        offsetIndexList: offsetIndexList,
                        dateList: dateList
                    }
                };
                let TimeZoneCache = function() {
                    function TimeZoneCache() {
                        this.map = new Map
                    }
                    var _proto = TimeZoneCache.prototype;
                    _proto.tryGet = function(id) {
                        if (!this.map.get(id)) {
                            const config = timeZoneDataUtils.getTimezoneById(id);
                            if (!config) {
                                return false
                            }
                            const timeZoneInfo = parseTimezone(config);
                            this.map.set(id, timeZoneInfo)
                        }
                        return this.map.get(id)
                    };
                    return TimeZoneCache
                }();
                const tzCache = new TimeZoneCache;
                const timeZoneDataUtils = {
                    _tzCache: tzCache,
                    _timeZones: _timezones_data.default.zones,
                    getDisplayedTimeZones(timestamp) {
                        const timeZones = this._timeZones.map(timezone => {
                            const timeZoneInfo = parseTimezone(timezone);
                            const offset = this.getUtcOffset(timeZoneInfo, timestamp);
                            const title = "(GMT ".concat(this.formatOffset(offset), ") ").concat(this.formatId(timezone.id));
                            return {
                                offset: offset,
                                title: title,
                                id: timezone.id
                            }
                        });
                        return (0, _query.default)(timeZones).sortBy("offset").toArray()
                    },
                    formatOffset(offset) {
                        const hours = Math.floor(offset);
                        const minutesInDecimal = offset - hours;
                        const signString = (0, _math.sign)(offset) >= 0 ? "+" : "-";
                        const hoursString = "0".concat(Math.abs(hours)).slice(-2);
                        const minutesString = minutesInDecimal > 0 ? ":".concat(60 * minutesInDecimal) : ":00";
                        return signString + hoursString + minutesString
                    },
                    formatId: id => id.split("/").join(" - ").split("_").join(" "),
                    getTimezoneById(id) {
                        if (!id) {
                            return
                        }
                        const tzList = this._timeZones;
                        for (let i = 0; i < tzList.length; i++) {
                            const currentId = tzList[i].id;
                            if (currentId === id) {
                                return tzList[i]
                            }
                        }
                        _errors.default.log("W0009", id);
                        return
                    },
                    getTimeZoneOffsetById(id, timestamp) {
                        const timeZoneInfo = tzCache.tryGet(id);
                        return timeZoneInfo ? this.getUtcOffset(timeZoneInfo, timestamp) : void 0
                    },
                    getTimeZoneDeclarationTuple(id, year) {
                        const timeZoneInfo = tzCache.tryGet(id);
                        return timeZoneInfo ? this.getTimeZoneDeclarationTupleCore(timeZoneInfo, year) : []
                    },
                    getTimeZoneDeclarationTupleCore(timeZoneInfo, year) {
                        const {
                            offsetList: offsetList
                        } = timeZoneInfo;
                        const {
                            offsetIndexList: offsetIndexList
                        } = timeZoneInfo;
                        const {
                            dateList: dateList
                        } = timeZoneInfo;
                        const tupleResult = [];
                        for (let i = 0; i < dateList.length; i++) {
                            const currentDate = dateList[i];
                            const currentYear = new Date(currentDate).getFullYear();
                            if (currentYear === year) {
                                const offset = offsetList[offsetIndexList[i + 1]];
                                tupleResult.push({
                                    date: currentDate,
                                    offset: -offset / 60
                                })
                            }
                            if (currentYear > year) {
                                break
                            }
                        }
                        return tupleResult
                    },
                    getUtcOffset(timeZoneInfo, dateTimeStamp) {
                        const {
                            offsetList: offsetList
                        } = timeZoneInfo;
                        const {
                            offsetIndexList: offsetIndexList
                        } = timeZoneInfo;
                        const {
                            dateList: dateList
                        } = timeZoneInfo;
                        const lastIntervalStartIndex = dateList.length - 1 - 1;
                        let index = lastIntervalStartIndex;
                        while (index >= 0 && dateTimeStamp < dateList[index]) {
                            index--
                        }
                        const offset = offsetList[offsetIndexList[index + 1]];
                        return -offset / 60 || offset
                    }
                };
                var _default = timeZoneDataUtils;
                exports.default = _default
            },
        28882:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/timezones/timezones_data.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.default = {
                    zones: [{
                        id: "Africa/Abidjan",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Accra",
                        untils: "-r507yk|1e3pak|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|Infinity",
                        offsets: "0.8667|0|-20",
                        offsetIndices: "012121212121212121212121212121212121212121212121"
                    }, {
                        id: "Africa/Addis_Ababa",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Algiers",
                        untils: "-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|53c00|9idxc0|3i040|51mw0|253uk0|9o2k0|92040|8l3s0|jutc0|4uy840|3rdzw0|46xc00|7x6o0|2xco40|8n180|7x9g0|9d440|kiqg0|9d440|9q2s0|9cyk0|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "0121212121212121232321212122321212"
                    }, {
                        id: "Africa/Asmara",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Asmera",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Bamako",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bangui",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Banjul",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bissau",
                        untils: "-u9rek0|wvoyo0|Infinity",
                        offsets: "62.3333|60|0",
                        offsetIndices: "012"
                    }, {
                        id: "Africa/Blantyre",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Brazzaville",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Bujumbura",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Cairo",
                        untils: "-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Africa/Casablanca",
                        untils: "-tblt9g|di7nxg|3huk0|51k40|2znuk0|2dp9g0|776k0|8nt2s0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|xqqk0|bp56s0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",
                        offsets: "30.3333|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Africa/Ceuta",
                        untils: "-qyiys0|7x3w0|2vt440|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|k69dc0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|129us0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Africa/Conakry",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Dakar",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Dar_es_Salaam",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Djibouti",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Douala",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/El_Aaiun",
                        untils: "-isdxk0|m2g0c0|vek0|4qak0|e1ms0|7pp80|cnms0|3afw0|fke5g0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",
                        offsets: "52.8|60|0|-60",
                        offsetIndices: "012323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Africa/Freetown",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Gaborone",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Harare",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Johannesburg",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Juba",
                        untils: "-kcrsis|kixuys|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|Infinity",
                        offsets: "-126.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212"
                    }, {
                        id: "Africa/Kampala",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Khartoum",
                        untils: "-kcrsow|kixv4w|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|9ac180|Infinity",
                        offsets: "-130.1333|-120|-180",
                        offsetIndices: "012121212121212121212121212121212121"
                    }, {
                        id: "Africa/Kigali",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Kinshasa",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lagos",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Libreville",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lome",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Luanda",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lubumbashi",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Lusaka",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Malabo",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Maputo",
                        untils: "-yvtfd8|Infinity",
                        offsets: "-130.3333|-120",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Maseru",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Mbabane",
                        untils: "-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",
                        offsets: "-90|-120|-180",
                        offsetIndices: "012121"
                    }, {
                        id: "Africa/Mogadishu",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Monrovia",
                        untils: "-qj6zc4|rl202a|Infinity",
                        offsets: "43.1333|44.5|0",
                        offsetIndices: "012"
                    }, {
                        id: "Africa/Nairobi",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Africa/Ndjamena",
                        untils: "-u9rk4c|zdk5cc|7iak0|Infinity",
                        offsets: "-60.2|-60|-120",
                        offsetIndices: "0121"
                    }, {
                        id: "Africa/Niamey",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Nouakchott",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Ouagadougou",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Porto-Novo",
                        untils: "-q9qbao|Infinity",
                        offsets: "-13.6|-60",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Sao_Tome",
                        untils: "-u9rhc0|1jbm840|irxc0|Infinity",
                        offsets: "36.75|0|-60",
                        offsetIndices: "0121"
                    }, {
                        id: "Africa/Timbuktu",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Africa/Tripoli",
                        untils: "-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",
                        offsets: "-52.7333|-60|-120",
                        offsetIndices: "012121212121212121212121212122122"
                    }, {
                        id: "Africa/Tunis",
                        untils: "-uozn3l|enxevl|b5uo0|53c00|u8w00|7x9g0|c8w80|7k800|z3w0|ew40|8bx80|9d440|9nx00|925o0|8l100|gi3440|7k800|b9k00|7vc00|51mw00|5ytc0|9d1c0|9d1c0|b9k00|7thc0|7m0tc0|7tk40|93us0|b5uo0|7k800|b5uo0|7x6o0|asw00|Infinity",
                        offsets: "-9.35|-60|-120",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "Africa/Windhoek",
                        untils: "-yvtdi0|kn7o60|9cyk0|oj2nw0|235k00|8lho0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "-90|-120|-180|-60",
                        offsetIndices: "01211313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Adak",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Anchorage",
                        untils: "-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "600|540|480",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Anguilla",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Antigua",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Araguaina",
                        untils: "-t85j2o|99k8mo|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|51udg0|64ak0|Infinity",
                        offsets: "192.8|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Argentina/Buenos_Aires",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232323232"
                    }, {
                        id: "America/Argentina/Catamarca",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Argentina/ComodRivadavia",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Argentina/Cordoba",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Argentina/Jujuy",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121323232"
                    }, {
                        id: "America/Argentina/La_Rioja",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231232321232"
                    }, {
                        id: "America/Argentina/Mendoza",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232312121321232"
                    }, {
                        id: "America/Argentina/Rio_Gallegos",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232321232"
                    }, {
                        id: "America/Argentina/Salta",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231323232"
                    }, {
                        id: "America/Argentina/San_Juan",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v2840|2txg0|1sgak0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323231232321232"
                    }, {
                        id: "America/Argentina/San_Luis",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|7pp80|b2aw0|71mk0|4qg40|6s8ik0|2txg0|1sgak0|14nw0|2gys0|b5xg0|7k580|b5xg0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121212321212"
                    }, {
                        id: "America/Argentina/Tucuman",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|mas0|1um2k0|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212323232313232123232"
                    }, {
                        id: "America/Argentina/Ushuaia",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v0dg0|12ys0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232321232"
                    }, {
                        id: "America/Aruba",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Asuncion",
                        untils: "-jy93zk|ldwofk|s4vw0|s6w40|7tek0|b0dg0|7rjw0|b0dg0|7rjw0|b0dg0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|ahus0|8a2k0|9eys0|9cyk0|9o840|7k580|b7s40|93p80|9gtg0|7nuk0|b42s0|7lzw0|b5xg0|7tek0|b9ms0|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|7kas0|b5rw0|7x9g0|ast80|a31g0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|776k0|biw40|8zzw0|905g0|9px80|905g0|9px80|9d440|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|Infinity",
                        offsets: "230.6667|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Atikokan",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101111"
                    }, {
                        id: "America/Atka",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Bahia_Banderas",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|asqg0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "421|420|360|480|300",
                        offsetIndices: "0121212131212121212121212121212121212142424242424242424242424242424242424242424242424242424242"
                    }, {
                        id: "America/Bahia",
                        untils: "-t85kv8|99kaf8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|4irc40|6u7w0|Infinity",
                        offsets: "154.0667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Barbados",
                        untils: "-o0aiaj|46b400|npv1mj|5rbw0|a31g0|8n180|a31g0|8n180|ag040|84ik0|Infinity",
                        offsets: "238.4833|240|180",
                        offsetIndices: "00121212121"
                    }, {
                        id: "America/Belem",
                        untils: "-t85j0s|99k8ks|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",
                        offsets: "193.9333|180|120",
                        offsetIndices: "012121212121212121212121212121"
                    }, {
                        id: "America/Belize",
                        untils: "-u52ic0|3edkc0|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|g2t2q0|3e580|4mcys0|2vmk0|Infinity",
                        offsets: "352.8|360|330|300",
                        offsetIndices: "01212121212121212121212121212121212121212121212121213131"
                    }, {
                        id: "America/Blanc-Sablon",
                        untils: "-qzp0o0|a2vw0|c5jxg0|1tzdw0|2dnc0|Infinity",
                        offsets: "240|180",
                        offsetIndices: "010110"
                    }, {
                        id: "America/Boa_Vista",
                        untils: "-t85grk|99k93k|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|62xk40|7k580|biw40|cvw0|Infinity",
                        offsets: "242.6667|240|180",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "America/Bogota",
                        untils: "-srdoy8|14f1hi8|ha580|Infinity",
                        offsets: "296.2667|300|240",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Boise",
                        untils: "-r0emw0|ast80|7x9g0|ast80|1um840|9s7jw0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|51k40|doik0|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|360",
                        offsetIndices: "0101012212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Buenos_Aires",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323232323232"
                    }, {
                        id: "America/Cambridge_Bay",
                        untils: "-q3gdc0|bjeec0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x6o0|ast80|ct40|7kj40|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|420|360|300",
                        offsetIndices: "0122131212121212121212121212121212121212121212233221212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Campo_Grande",
                        untils: "-t85hvw|99ka7w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "218.4667|240|180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Cancun",
                        untils: "-p1u7c0|vauo00|7ggw40|afuk0|8a840|afuk0|8a840|64ak0|4bms0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|51k40|Infinity",
                        offsets: "347.0667|360|300|240",
                        offsetIndices: "0123232321212121212121212121212121212121212"
                    }, {
                        id: "America/Caracas",
                        untils: "-u7lcxw|rlo83w|meoxm0|4dps00|Infinity",
                        offsets: "267.6667|270|240",
                        offsetIndices: "01212"
                    }, {
                        id: "America/Catamarca",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132321232"
                    }, {
                        id: "America/Cayenne",
                        untils: "-uj7yb4|tcw6r4|Infinity",
                        offsets: "209.3333|240|180",
                        offsetIndices: "012"
                    }, {
                        id: "America/Cayman",
                        untils: "-w757vc|Infinity",
                        offsets: "319.6|300",
                        offsetIndices: "01"
                    }, {
                        id: "America/Chicago",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Chihuahua",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "424.3333|420|360|300",
                        offsetIndices: "0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Coral_Harbour",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101111"
                    }, {
                        id: "America/Cordoba",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Costa_Rica",
                        untils: "-pjw8fn|ubtl3n|51ek0|doo40|51ek0|5jso40|8drw0|acas0|2xh80|Infinity",
                        offsets: "336.2167|360|300",
                        offsetIndices: "0121212121"
                    }, {
                        id: "America/Creston",
                        untils: "-rshz80|vbus0|Infinity",
                        offsets: "420|480",
                        offsetIndices: "010"
                    }, {
                        id: "America/Cuiaba",
                        untils: "-t85hm4|99k9y4|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|w5hg0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "224.3333|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Curacao",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Danmarkshavn",
                        untils: "-rvusjk|x8nx3k|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|53hk0|Infinity",
                        offsets: "74.6667|180|120|0",
                        offsetIndices: "01212121212121212121212121212121213"
                    }, {
                        id: "America/Dawson_Creek",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|69uk0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101011"
                    }, {
                        id: "America/Dawson",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|465k00|3e2is0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Denver",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Detroit",
                        untils: "-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "332.1833|360|300|240",
                        offsetIndices: "0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Dominica",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Edmonton",
                        untils: "-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "453.8667|420|360",
                        offsetIndices: "0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Eirunepe",
                        untils: "-t85f28|99ka68|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|7hg2s0|2t2t80|Infinity",
                        offsets: "279.4667|300|240",
                        offsetIndices: "0121212121212121212121212121212121"
                    }, {
                        id: "America/El_Salvador",
                        untils: "-pkm4tc|ymao5c|7k580|b5xg0|7k580|Infinity",
                        offsets: "356.8|360|300",
                        offsetIndices: "012121"
                    }, {
                        id: "America/Ensenada",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Fort_Nelson",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "01011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "America/Fort_Wayne",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Fortaleza",
                        untils: "-t85kvc|99kafc|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|puk0|id6s0|6h980|Infinity",
                        offsets: "154|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/Glace_Bay",
                        untils: "-z94kwc|89fk8c|a2vw0|c5jxg0|1tzdw0|2dnc0|3y8g40|7x3w0|9pa5g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "239.8|240|180",
                        offsetIndices: "012122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Godthab",
                        untils: "-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "206.9333|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Goose_Bay",
                        untils: "-qzp20k|a2vw0|8kjbw0|kzjyk|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|6y2s0|22420|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|240|180|120",
                        offsetIndices: "010232323232323233232323232323232323232323232323232323232324545454545454545454545454545454545454545454546454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454"
                    }, {
                        id: "America/Grand_Turk",
                        untils: "-u85og2|z3brw2|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|18ais0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121222121212121212121212121212121212121212121"
                    }, {
                        id: "America/Grenada",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Guadeloupe",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Guatemala",
                        untils: "-qqqskk|ss0akk|4ofw0|4tidg0|6djw0|3wwas0|8n180|7n5ms0|7x3w0|Infinity",
                        offsets: "362.0667|360|300",
                        offsetIndices: "0121212121"
                    }, {
                        id: "America/Guayaquil",
                        untils: "-kcr84o|wb620o|3jp80|Infinity",
                        offsets: "314|300|240",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Guyana",
                        untils: "-smcak8|vj4sz8|81rf90|Infinity",
                        offsets: "232.6667|225|180|240",
                        offsetIndices: "0123"
                    }, {
                        id: "America/Halifax",
                        untils: "-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "254.4|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Havana",
                        untils: "-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",
                        offsets: "329.6|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Hermosillo",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "443.8667|420|360|480",
                        offsetIndices: "0121212131212121"
                    }, {
                        id: "America/Indiana/Indianapolis",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Knox",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Indiana/Marengo",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|2wsas0|7x3w0|1c9440|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|fvt9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101011010101010101010101212121212111212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Petersburg",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|sfzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|eu02o0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010101010101010101010111011212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Tell_City",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|1tw580|9d440|9cyk0|9d440|9cvs0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101021211010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Indiana/Vevay",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|4gyis0|7txx80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|hfzhg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101101212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Vincennes",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|3fidg0|7x3w0|asys0|7x3w0|b5rw0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|2lz980|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010121211011212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indiana/Winamac",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8l40|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "01010110101010101010101010101010101010121211021212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Indianapolis",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Inuvik",
                        untils: "-8ve5c0|6fce80|9q000|71i2w0|ipzw0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|480|360|420",
                        offsetIndices: "0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Iqaluit",
                        untils: "-eb6ao0|1l3h80|2dq40|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|240|300|180|360",
                        offsetIndices: "01123212121212121212121212121212121212121212142212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Jamaica",
                        untils: "-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "America/Jujuy",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121232323121323232"
                    }, {
                        id: "America/Juneau",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9d1c0|9d1c0|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010001010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"
                    }, {
                        id: "America/Kentucky/Louisville",
                        untils: "-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Kentucky/Monticello",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|bs6g40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Knox_IN",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Kralendijk",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/La_Paz",
                        untils: "-jxzspo|84ik0|Infinity",
                        offsets: "272.6|212.6|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Lima",
                        untils: "-w25lpo|fcxjlo|4ml80|93us0|9cyk0|9d440|9cyk0|nw16s0|4ml80|e5c40|4ml80|1fr1g0|4ml80|1yiys0|4ml80|Infinity",
                        offsets: "308.6|300|240",
                        offsetIndices: "0121212121212121"
                    }, {
                        id: "America/Los_Angeles",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Louisville",
                        untils: "-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Lower_Princes",
                        untils: "-u7lckd|rlo7qd|Infinity",
                        offsets: "275.7833|270|240",
                        offsetIndices: "012"
                    }, {
                        id: "America/Maceio",
                        untils: "-t85ldw|99kaxw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|1wf1g0|7k580|biw40|puk0|id6s0|6h980|Infinity",
                        offsets: "142.8667|180|120",
                        offsetIndices: "012121212121212121212121212121212121212121"
                    }, {
                        id: "America/Managua",
                        untils: "-ijh6oo|ka1i0o|xqqk0|24p6s0|53980|dmtg0|53980|60itw0|dq240|53es0|235h80|4beis0|8zzw0|at4c0|7x140|Infinity",
                        offsets: "345.2|360|300",
                        offsetIndices: "0121212121212121"
                    }, {
                        id: "America/Manaus",
                        untils: "-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",
                        offsets: "240.0667|240|180",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Marigot",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Martinique",
                        untils: "-umcvcs|zz5x4s|8zzw0|Infinity",
                        offsets: "244.3333|240|180",
                        offsetIndices: "0121"
                    }, {
                        id: "America/Matamoros",
                        untils: "-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "400|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Mazatlan",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "425.6667|420|360|480",
                        offsetIndices: "0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Mendoza",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232312121321232"
                    }, {
                        id: "America/Menominee",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|a7n9g0|9px80|1at9g0|2396k0|9d1c0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010110101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Merida",
                        untils: "-p1u7c0|vauo00|hoyk0|6ys0c0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "358.4667|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Metlakatla",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|gpc840|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|3ylc0|2itg0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010101010102020200202020202020202020202020202020202020202"
                    }, {
                        id: "America/Mexico_City",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "396.6|420|360|300",
                        offsetIndices: "012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Miquelon",
                        untils: "-ulmyxk|zzqbdk|3m59g0|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "224.6667|240|180|120",
                        offsetIndices: "012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Moncton",
                        untils: "-z94i40|89fhg0|a2vw0|7mqqo0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|dmtg0|64ak0|cao40|6fek0|bkqs0|7iak0|6y5k0|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a2lo|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6uiyc|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240|180",
                        offsetIndices: "012121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Monterrey",
                        untils: "-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|Infinity",
                        offsets: "401.2667|360|300",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Montevideo",
                        untils: "-w4mll9|67elc0|1s74p9|9et80|9exe0|9czy0|9exe0|9czy0|3ydyq0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7k6m0|9q1e0|9czy0|asxe0|7x5a0|6do20|ppvy0|4mmm0|8g9qq0|901a0|38pe0|2inw0|2nf9g0|8zzw0|1e3s40|9o3y0|q8he0|2kik0|yxhg0|4bh80|s36s0|2vl60|905g0|5rg20|51ek0|weqs0|3yik0|e1ms0|4ofw0|erk40|3yik0|2vs40|gk7w0|41iys0|3wnw0|erk40|4bh80|c8tg0|64ak0|c8tg0|6u7w0|c8tg0|6h980|bvus0|6u7w0|614qs0|9q2s0|a31g0|7x3w0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "224.85|240|180|210|150|120|90",
                        offsetIndices: "001232323232323232323232324242525242525264252525252525252525252525252525252525252525252"
                    }, {
                        id: "America/Montreal",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Montserrat",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Nassau",
                        untils: "-u6m4c6|r7u7s6|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "309.5|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/New_York",
                        untils: "-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Nipigon",
                        untils: "-qzoxw0|a2vw0|bfxjw0|pmdk0|1tzb40|2dq40|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Nome",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l6c0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540|480",
                        offsetIndices: "011001010101010101010101010101010122323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Noronha",
                        untils: "-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "129.6667|120|60",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/Beulah",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/Center",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/North_Dakota/New_Salem",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Nuuk",
                        untils: "-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "206.9333|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Ojinaga",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "417.6667|420|360|300",
                        offsetIndices: "0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Panama",
                        untils: "-w757vc|Infinity",
                        offsets: "319.6|300",
                        offsetIndices: "01"
                    }, {
                        id: "America/Pangnirtung",
                        untils: "-pkmlc0|b0ke00|1tzdw0|2dnc0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|asw00|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|240|180|120|300|360",
                        offsetIndices: "012213121212121212121212121212121212114141414154414141414141414141414141414141414141414141414141414141414141414141414141414"
                    }, {
                        id: "America/Paramaribo",
                        untils: "-usj4g8|cixc0c|5lydbk|kcrm6c|Infinity",
                        offsets: "220.6667|220.8667|220.6|210|180",
                        offsetIndices: "01234"
                    }, {
                        id: "America/Phoenix",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101010"
                    }, {
                        id: "America/Port_of_Spain",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Port-au-Prince",
                        untils: "-rmk9ac|ylcf6c|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8aaw0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|3vpjw0|ast80|7x9g0|ast80|2stv00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|pkg40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "289|300|240",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Porto_Acre",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Porto_Velho",
                        untils: "-t85g60|99k8i0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",
                        offsets: "255.6|240|180",
                        offsetIndices: "012121212121212121212121212121"
                    }, {
                        id: "America/Puerto_Rico",
                        untils: "-efsnk0|1ppu40|2dnc0|Infinity",
                        offsets: "240|180",
                        offsetIndices: "0110"
                    }, {
                        id: "America/Punta_Arenas",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|2fnh80|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "0102021212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Rainy_River",
                        untils: "-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Rankin_Inlet",
                        untils: "-6s8lc0|4c6oo0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|360|240|300",
                        offsetIndices: "012131313131313131313131313131313131313131313331313131313131313131313131313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Recife",
                        untils: "-t85ljc|99kb3c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "139.6|180|120",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "America/Regina",
                        untils: "-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",
                        offsets: "418.6|420|360",
                        offsetIndices: "012121212121212121212121221212121212121212121212121212"
                    }, {
                        id: "America/Resolute",
                        untils: "-bnp9c0|97nco0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|360|240|300",
                        offsetIndices: "012131313131313131313131313131313131313131313331313131313331313131313131313131313131313131313131313131313131313131313131"
                    }, {
                        id: "America/Rio_Branco",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "America/Rosario",
                        untils: "-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",
                        offsets: "256.8|240|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212123232323132323232"
                    }, {
                        id: "America/Santa_Isabel",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Santarem",
                        untils: "-t85hvc|99ka7c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|Infinity",
                        offsets: "218.8|240|180",
                        offsetIndices: "0121212121212121212121212121212"
                    }, {
                        id: "America/Santiago",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "America/Santo_Domingo",
                        untils: "-j6hz1c|hiw29c|67zw0|1dy840|62ha0|cnle0|4h2m0|elyq0|47ta0|ei9e0|4bim0|eek20|4dda0|ecpe0|dkmtg0|1stc0|Infinity",
                        offsets: "280|300|240|270",
                        offsetIndices: "01213131313131212"
                    }, {
                        id: "America/Sao_Paulo",
                        untils: "-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "186.4667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Scoresbysund",
                        untils: "-rvurxk|x8ntpk|902o0|9cvs0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "87.8667|120|60|0",
                        offsetIndices: "0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/Shiprock",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Sitka",
                        untils: "-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420|540",
                        offsetIndices: "01101010101010101010101010101010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"
                    }, {
                        id: "America/St_Barthelemy",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Johns",
                        untils: "-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|90",
                        offsetIndices: "01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "America/St_Kitts",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Lucia",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Thomas",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/St_Vincent",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Swift_Current",
                        untils: "-xkq9d4|6l1h14|a2vw0|c5jxg0|1tz5k0|2dvo0|asys0|8n180|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|3yles0|9cyk0|s36s0|9cyk0|9d440|7x3w0|b5xg0|7k580|5j4lg0|Infinity",
                        offsets: "431.3333|420|360",
                        offsetIndices: "012122121212121212121212"
                    }, {
                        id: "America/Tegucigalpa",
                        untils: "-pfzh6k|yho0ik|7k580|b5xg0|7k580|96x1g0|4qak0|Infinity",
                        offsets: "348.8667|360|300",
                        offsetIndices: "01212121"
                    }, {
                        id: "America/Thule",
                        untils: "-rvuj9g|12yzilg|9cyk0|9d440|9cyk0|9q2s0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "275.1333|240|180",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Thunder_Bay",
                        untils: "-vbavc0|gr8qs0|1tzb40|2dq40|ctmlg0|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "0122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "America/Tijuana",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Toronto",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Tortola",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Vancouver",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Virgin",
                        untils: "-u6m79w|Infinity",
                        offsets: "246.0667|240",
                        offsetIndices: "01"
                    }, {
                        id: "America/Whitehorse",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "America/Winnipeg",
                        untils: "-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Yakutat",
                        untils: "-ek1tg0|1tz000|2e180|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1lbw0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "540|480",
                        offsetIndices: "01101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "America/Yellowknife",
                        untils: "-i9m2o0|3pk3o0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "0|420|360|300",
                        offsetIndices: "012213121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Antarctica/Casey",
                        untils: "-irxc0|lag4o0|73bo0|uz1o0|60l80|2fnh80|pz9g0|Infinity",
                        offsets: "0|-480|-660",
                        offsetIndices: "01212121"
                    }, {
                        id: "Antarctica/Davis",
                        untils: "-6rmdc0|42jdw0|27wgs0|l8uss0|7eqs0|unmk0|60qs0|Infinity",
                        offsets: "0|-420|-300",
                        offsetIndices: "01012121"
                    }, {
                        id: "Antarctica/DumontDUrville",
                        untils: "-c05eo0|2mks80|2i72g0|Infinity",
                        offsets: "0|-600",
                        offsetIndices: "0101"
                    }, {
                        id: "Antarctica/Macquarie",
                        untils: "-rsj4w0|8zzw0|11wqk0|f4kh40|a6p8g0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660|0",
                        offsetIndices: "0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101011"
                    }, {
                        id: "Antarctica/Mawson",
                        untils: "-8aelc0|t22y80|Infinity",
                        offsets: "0|-360|-300",
                        offsetIndices: "012"
                    }, {
                        id: "Antarctica/McMurdo",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Antarctica/Palmer",
                        untils: "-2lxhc0|31ho0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|46b6s0|8c2s0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",
                        offsets: "0|180|240|120",
                        offsetIndices: "0121212121213121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Antarctica/Rothera",
                        untils: "3lxs00|Infinity",
                        offsets: "0|180",
                        offsetIndices: "01"
                    }, {
                        id: "Antarctica/South_Pole",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Antarctica/Syowa",
                        untils: "-6qsqo0|Infinity",
                        offsets: "0|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Antarctica/Troll",
                        untils: "ibruo0|27pg0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-120",
                        offsetIndices: "00101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Antarctica/Vostok",
                        untils: "-6aaao0|Infinity",
                        offsets: "0|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Arctic/Longyearbyen",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Aden",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Almaty",
                        untils: "-nu1a90|37a0d0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",
                        offsets: "-307.8|-300|-360|-420",
                        offsetIndices: "012323232323232323232321232323232323232323232323232"
                    }, {
                        id: "Asia/Amman",
                        untils: "-kcrtbk|m566fk|60l80|awo40|7v980|awo40|7v980|ayis0|9gnw0|9b9g0|7v980|autg0|7v980|3e6840|9et80|9io40|9cyk0|9d440|9cyk0|9d440|9px80|ayis0|7rjw0|ag040|8a2k0|9zc40|8drw0|a31g0|8zzw0|9d440|9cyk0|9d440|8n180|ag040|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|epmo0|4deo0|9o5c0|9ew00|9b6o0|9ew00|9d1c0|9d1c0|9d1c0|asw00|7x6o0|afxc0|8n400|9d1c0|9d1c0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|wel80|51k40|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",
                        offsets: "-143.7333|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Anadyr",
                        untils: "-nu1sv8|379zj8|qi27w0|9et80|is040|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-709.9333|-720|-780|-840|-660",
                        offsetIndices: "01232121212121212121214121212121212121212121212121212121212141"
                    }, {
                        id: "Asia/Aqtau",
                        untils: "-nu15b4|379y74|qrh3w0|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-201.0667|-240|-300|-360",
                        offsetIndices: "012323232323232323232123232312121212121212121212"
                    }, {
                        id: "Asia/Aqtobe",
                        untils: "-nu16l4|379zh4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",
                        offsets: "-228.6667|-240|-300|-360",
                        offsetIndices: "0123232323232323232321232323232323232323232323232"
                    }, {
                        id: "Asia/Ashgabat",
                        untils: "-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",
                        offsets: "-233.5333|-240|-300|-360",
                        offsetIndices: "0123232323232323232323212"
                    }, {
                        id: "Asia/Ashkhabad",
                        untils: "-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",
                        offsets: "-233.5333|-240|-300|-360",
                        offsetIndices: "0123232323232323232323212"
                    }, {
                        id: "Asia/Atyrau",
                        untils: "-nu15m8|37a1a8|qrh140|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|j3440|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-207.7333|-180|-300|-360|-240",
                        offsetIndices: "01232323232323232323242323232323232324242424242"
                    }, {
                        id: "Asia/Baghdad",
                        untils: "-r50g80|xkn3w0|7v980|9b9g0|9gnw0|9eys0|9et80|9d440|9b9g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9f1k0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|Infinity",
                        offsets: "-177.6|-180|-240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Bahrain",
                        untils: "-q3gmvk|rctnrk|Infinity",
                        offsets: "-206.1333|-240|-180",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Baku",
                        untils: "-nu158c|h4tkwc|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|239ew0|asw00|7x3w0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-199.4|-180|-240|-300",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Bangkok",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Barnaul",
                        untils: "-q4ljic|5hu6uc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|38fo0|64og0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-335|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323232321212121212121212121212121212121212"
                    }, {
                        id: "Asia/Beirut",
                        untils: "-pyzew0|aunw0|88dg0|9et80|8yas0|a2vw0|a31g0|7k580|hjqo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|5lhs40|56yk0|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|autg0|7v980|2wxus0|8n180|a4w40|8n180|a4w40|8n180|a4w40|8n180|bs5g0|71mk0|alk40|86d80|a4w40|8n180|a4w40|8n180|a6qs0|80t80|905g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Bishkek",
                        untils: "-nu19tc|379zxc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|h8dc0|bkl80|8n180|a31g0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9db20|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|Infinity",
                        offsets: "-298.4|-300|-360|-420",
                        offsetIndices: "012323232323232323232321212121212121212121212121212"
                    }, {
                        id: "Asia/Brunei",
                        untils: "-mvofy4|3khxs4|Infinity",
                        offsets: "-459.6667|-450|-480",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Calcutta",
                        untils: "-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",
                        offsets: "-321.1667|-330|-390",
                        offsetIndices: "012121"
                    }, {
                        id: "Asia/Chita",
                        untils: "-q4cfog|5hkxgg|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnew0|Infinity",
                        offsets: "-453.8667|-480|-540|-600",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323232312"
                    }, {
                        id: "Asia/Choibalsan",
                        untils: "-xmct7c|11sndrc|2qk2k0|9eqg0|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|s6qk0|3nc0c0|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-458|-420|-480|-600|-540",
                        offsetIndices: "0123434343434343434343434343434343434343434343424242"
                    }, {
                        id: "Asia/Chongqing",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Chungking",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Colombo",
                        untils: "-xehask|isle6k|cajy0|1mp2u0|qetjw0|7x5a0|4xvqq0|Infinity",
                        offsets: "-319.5333|-330|-360|-390",
                        offsetIndices: "01231321"
                    }, {
                        id: "Asia/Dacca",
                        untils: "-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",
                        offsets: "-353.3333|-390|-330|-360|-420",
                        offsetIndices: "0121343"
                    }, {
                        id: "Asia/Damascus",
                        untils: "-q3gk20|5k6q0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|k4hk40|7yyk0|awo40|7tek0|b0dg0|7v980|awo40|7tek0|alk40|887w0|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|6bp80|cg840|6bp80|2eh1g0|8zzw0|9ts40|8zzw0|pvk40|c33w0|7cw40|cjrw0|6zxg0|btuk0|7rpg0|9gnw0|9d440|9cyk0|9et80|9et80|9rxg0|91uk0|92040|9et80|9o840|9et80|9d440|9et80|9eys0|9et80|9b9g0|9gnw0|99es0|9iik0|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|8y580|9q2s0|b5rw0|7x9g0|aunw0|7ig40|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|Infinity",
                        offsets: "-145.2|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Dhaka",
                        untils: "-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",
                        offsets: "-353.3333|-390|-330|-360|-420",
                        offsetIndices: "0121343"
                    }, {
                        id: "Asia/Dili",
                        untils: "-u9s4l8|fqcu98|hufs00|cpz440|Infinity",
                        offsets: "-502.3333|-480|-540",
                        offsetIndices: "01212"
                    }, {
                        id: "Asia/Dubai",
                        untils: "-q3gnko|Infinity",
                        offsets: "-221.2|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Dushanbe",
                        untils: "-nu18qo|379yuo|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|hp440|Infinity",
                        offsets: "-275.2|-300|-360|-420",
                        offsetIndices: "012323232323232323232321"
                    }, {
                        id: "Asia/Famagusta",
                        untils: "-p4bqac|rvhy2c|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|8h8w0|leog0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-135.8|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Gaza",
                        untils: "-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|7x3w0|asys0|8a5c0|ahs1o|71mic|bzk5o|69uic|cg840|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Harbin",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Hebron",
                        untils: "-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|82nw0|anes0|8a5c0|afxc0|73h80|bzk5o|69uic|1hs40|1lbw0|9d440|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Ho_Chi_Minh",
                        untils: "-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",
                        offsets: "-426.6667|-426.5|-420|-480|-540",
                        offsetIndices: "0123423232"
                    }, {
                        id: "Asia/Hong_Kong",
                        untils: "-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-456.7|-480|-540|-510",
                        offsetIndices: "0123212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Hovd",
                        untils: "-xmcoz0|11sncb0|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-366.6|-360|-420|-480",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Irkutsk",
                        untils: "-q28gn5|5fh175|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-417.0833|-420|-480|-540",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Istanbul",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "Asia/Jakarta",
                        untils: "-o0bdpc|4lzxc0|4wdzjc|1tu960|1cx860|11jta0|74uc20|Infinity",
                        offsets: "-427.2|-440|-450|-540|-480|-420",
                        offsetIndices: "01232425"
                    }, {
                        id: "Asia/Jayapura",
                        untils: "-jebm20|66bqe0|a37vy0|Infinity",
                        offsets: "-562.8|-540|-570",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Jerusalem",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Kabul",
                        untils: "-d1pkg0|Infinity",
                        offsets: "-240|-270",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Kamchatka",
                        untils: "-olrupo|3z045o|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-634.6|-660|-720|-780",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323212"
                    }, {
                        id: "Asia/Karachi",
                        untils: "-wvpb30|im3zt0|1mn180|33xpg0|a63o20|g72qo0|9cyk0|2y85g0|7v980|8hms0|aaak0|Infinity",
                        offsets: "-268.2|-330|-390|-300|-360",
                        offsetIndices: "012133434343"
                    }, {
                        id: "Asia/Kashgar",
                        untils: "-lx5pjw|Infinity",
                        offsets: "-350.3333|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Kathmandu",
                        untils: "-q3gt4s|yg2lus|Infinity",
                        offsets: "-341.2667|-330|-345",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Katmandu",
                        untils: "-q3gt4s|yg2lus|Infinity",
                        offsets: "-341.2667|-330|-345",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Khandyga",
                        untils: "-q4cjrp|5hl1jp|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|3fx40|4h6s0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",
                        offsets: "-542.2167|-480|-540|-600|-660",
                        offsetIndices: "0123232323232323232323212323232323232323232323232343434343434343432"
                    }, {
                        id: "Asia/Kolkata",
                        untils: "-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",
                        offsets: "-321.1667|-330|-390",
                        offsetIndices: "012121"
                    }, {
                        id: "Asia/Krasnoyarsk",
                        untils: "-q37l72|5gg8j2|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-371.4333|-360|-420|-480",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Kuala_Lumpur",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Asia/Kuching",
                        untils: "-mvof3k|3khwxk|1epvy0|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|3ajlc|1v2qk0|Infinity",
                        offsets: "-441.3333|-450|-480|-500|-540",
                        offsetIndices: "0123232323232323242"
                    }, {
                        id: "Asia/Kuwait",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Macao",
                        untils: "-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-454.1667|-480|-540|-600",
                        offsetIndices: "012323212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Macau",
                        untils: "-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-454.1667|-480|-540|-600",
                        offsetIndices: "012323212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Magadan",
                        untils: "-nu1nxc|37a05c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|s39k0|Infinity",
                        offsets: "-603.2|-600|-660|-720",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323232312"
                    }, {
                        id: "Asia/Makassar",
                        untils: "-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",
                        offsets: "-477.6|-480|-540",
                        offsetIndices: "00121"
                    }, {
                        id: "Asia/Manila",
                        untils: "-hb5y80|4qak0|2qidg0|1b2d80|4xf440|442k0|cdqdg0|9et80|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "010101010"
                    }, {
                        id: "Asia/Muscat",
                        untils: "-q3gnko|Infinity",
                        offsets: "-221.2|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Nicosia",
                        untils: "-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-133.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Novokuznetsk",
                        untils: "-nu36tc|37bu5c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-348.8|-360|-420|-480",
                        offsetIndices: "012323232323232323232321232323232323232323232323232323232323212"
                    }, {
                        id: "Asia/Novosibirsk",
                        untils: "-q4do0s|5hmbcs|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|2vh00|6hn40|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|wrpg0|Infinity",
                        offsets: "-331.6667|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323212121212121212121212121212121212121212"
                    }, {
                        id: "Asia/Omsk",
                        untils: "-q5xmx6|5j6d16|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-293.5|-300|-360|-420",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Oral",
                        untils: "-nu15ic|37a16c|qi2540|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|9d1c0|5reo0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-205.4|-180|-300|-360|-240",
                        offsetIndices: "01232323232323232424242424242424242424242424242"
                    }, {
                        id: "Asia/Phnom_Penh",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Pontianak",
                        untils: "-w6piww|cse2o0|4tnu2w|1wkei0|1cx860|11jta0|74uc20|cixam0|Infinity",
                        offsets: "-437.3333|-450|-540|-480|-420",
                        offsetIndices: "001213134"
                    }, {
                        id: "Asia/Pyongyang",
                        untils: "-w895yc|1yh10c|hk5da0|10ipmo0|1f4qo0|Infinity",
                        offsets: "-503|-510|-540",
                        offsetIndices: "012212"
                    }, {
                        id: "Asia/Qatar",
                        untils: "-q3gmvk|rctnrk|Infinity",
                        offsets: "-206.1333|-240|-180",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Qostanay",
                        untils: "-nu17s4|37a0o4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-254.4667|-240|-300|-360",
                        offsetIndices: "012323232323232323232123232323232323232323232323"
                    }, {
                        id: "Asia/Qyzylorda",
                        untils: "-nu184g|37a10g|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|ohhc0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|7osl00|Infinity",
                        offsets: "-261.8667|-240|-300|-360",
                        offsetIndices: "01232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Rangoon",
                        untils: "-q3gv5b|bnjp3b|1kh520|Infinity",
                        offsets: "-384.7833|-390|-540",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Riyadh",
                        untils: "-bwgbbg|Infinity",
                        offsets: "-186.8667|-180",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Saigon",
                        untils: "-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",
                        offsets: "-426.6667|-426.5|-420|-480|-540",
                        offsetIndices: "0123423232"
                    }, {
                        id: "Asia/Sakhalin",
                        untils: "-xl87rc|kvnarc|ikvh40|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|iq5g0|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-570.8|-540|-660|-720|-600",
                        offsetIndices: "01232323232323232323232423232323232424242424242424242424242424242"
                    }, {
                        id: "Asia/Samarkand",
                        untils: "-nu18eh|37a1ah|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|Infinity",
                        offsets: "-267.8833|-240|-300|-360",
                        offsetIndices: "01232323232323232323232"
                    }, {
                        id: "Asia/Seoul",
                        untils: "-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-507.8667|-510|-540|-600|-570",
                        offsetIndices: "012232323232141414141414123232"
                    }, {
                        id: "Asia/Shanghai",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "Asia/Singapore",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Asia/Srednekolymsk",
                        untils: "-nu1ogs|37a0os|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-614.8667|-600|-660|-720",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Taipei",
                        untils: "-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010101010101010"
                    }, {
                        id: "Asia/Tashkent",
                        untils: "-nu18tz|379yxz|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|Infinity",
                        offsets: "-277.1833|-300|-360|-420",
                        offsetIndices: "012323232323232323232321"
                    }, {
                        id: "Asia/Tbilisi",
                        untils: "-nu14an|h4tjyn|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9cvs0|9cyk0|9d440|9cyk0|9d440|ipzw0|9cyk0|9q2s0|tivw0|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|4ofw0|6hn40|7k800|Infinity",
                        offsets: "-179.1833|-180|-240|-300",
                        offsetIndices: "0123232323232323232323212121232323232323232323212"
                    }, {
                        id: "Asia/Tehran",
                        untils: "-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",
                        offsets: "-205.7333|-210|-240|-300|-270",
                        offsetIndices: "00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"
                    }, {
                        id: "Asia/Tel_Aviv",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Asia/Thimbu",
                        untils: "-bojclo|kxymno|Infinity",
                        offsets: "-358.6|-330|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Thimphu",
                        untils: "-bojclo|kxymno|Infinity",
                        offsets: "-358.6|-330|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Asia/Tokyo",
                        untils: "-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-540|-600",
                        offsetIndices: "010101010"
                    }, {
                        id: "Asia/Tomsk",
                        untils: "-q3zbqf|5h7z2f|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|1leo0|97k40|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|tw040|Infinity",
                        offsets: "-339.85|-360|-420|-480",
                        offsetIndices: "0123232323232323232323212323232323232323232323212121212121212121212"
                    }, {
                        id: "Asia/Ujung_Pandang",
                        untils: "-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",
                        offsets: "-477.6|-480|-540",
                        offsetIndices: "00121"
                    }, {
                        id: "Asia/Ulaanbaatar",
                        untils: "-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-427.5333|-420|-480|-540",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Ulan_Bator",
                        untils: "-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",
                        offsets: "-427.5333|-420|-480|-540",
                        offsetIndices: "012323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Urumqi",
                        untils: "-lx5pjw|Infinity",
                        offsets: "-350.3333|-360",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Ust-Nera",
                        untils: "-q4cl6u|5hl2yu|qi27w0|9eno0|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",
                        offsets: "-572.9|-480|-540|-720|-660|-600",
                        offsetIndices: "012343434343434343434345434343434343434343434343434343434343434345"
                    }, {
                        id: "Asia/Vientiane",
                        untils: "-pysda4|Infinity",
                        offsets: "-402.0667|-420",
                        offsetIndices: "01"
                    }, {
                        id: "Asia/Vladivostok",
                        untils: "-oligf7|3yqvf7|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-527.5167|-540|-600|-660",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Yakutsk",
                        untils: "-q4cioy|5hl0gy|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-518.9667|-480|-540|-600",
                        offsetIndices: "01232323232323232323232123232323232323232323232323232323232323232"
                    }, {
                        id: "Asia/Yangon",
                        untils: "-q3gv5b|bnjp3b|1kh520|Infinity",
                        offsets: "-384.7833|-390|-540",
                        offsetIndices: "0121"
                    }, {
                        id: "Asia/Yekaterinburg",
                        untils: "-rx5hw9|1kybx4|5pfyv5|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-242.55|-225.0833|-240|-300|-360",
                        offsetIndices: "012343434343434343434343234343434343434343434343434343434343434343"
                    }, {
                        id: "Asia/Yerevan",
                        untils: "-nu148o|h4tjwo|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|11t180|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",
                        offsets: "-178|-180|-240|-300",
                        offsetIndices: "0123232323232323232323212121212323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Azores",
                        untils: "-u9rbs0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "114.5333|120|60|0",
                        offsetIndices: "01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323233323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Bermuda",
                        untils: "-kvj2fu|n4pr3u|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "259.3|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Canary",
                        untils: "-oytbtc|ctvupc|hhq7s0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "61.6|60|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Cape_Verde",
                        untils: "-u9rbs0|g06lc0|1mn180|fpqwc0|Infinity",
                        offsets: "94.0667|120|60",
                        offsetIndices: "01212"
                    }, {
                        id: "Atlantic/Faeroe",
                        untils: "-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "27.0667|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Faroe",
                        untils: "-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "27.0667|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Atlantic/Jan_Mayen",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Atlantic/Madeira",
                        untils: "-u9rek0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "67.6|60|0|-60",
                        offsetIndices: "01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Atlantic/Reykjavik",
                        untils: "-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",
                        offsets: "88|60|0",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Atlantic/South_Georgia",
                        untils: "Infinity",
                        offsets: "120",
                        offsetIndices: "0"
                    }, {
                        id: "Atlantic/St_Helena",
                        untils: "-u9rgl4|Infinity",
                        offsets: "16.1333|0",
                        offsetIndices: "01"
                    }, {
                        id: "Atlantic/Stanley",
                        untils: "-u63pac|dbvxqc|8zzw0|9q2s0|8zzw0|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|4xp80|l1pus0|7k580|b5rw0|77c40|biqk0|id6s0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|77c40|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5xg0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|77c40|biqk0|77c40|biqk0|77c40|Infinity",
                        offsets: "231.4|240|180|120",
                        offsetIndices: "012121212121212323212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Australia/ACT",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Adelaide",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Brisbane",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "01010101010101010"
                    }, {
                        id: "Australia/Broken_Hill",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Canberra",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Currie",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Darwin",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "010101010"
                    }, {
                        id: "Australia/Eucla",
                        untils: "-rnstlc|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-525|-585",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Hobart",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/LHI",
                        untils: "5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",
                        offsets: "-600|-630|-690|-660",
                        offsetIndices: "0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"
                    }, {
                        id: "Australia/Lindeman",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010"
                    }, {
                        id: "Australia/Lord_Howe",
                        untils: "5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",
                        offsets: "-600|-630|-690|-660",
                        offsetIndices: "0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"
                    }, {
                        id: "Australia/Melbourne",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/North",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "010101010"
                    }, {
                        id: "Australia/NSW",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Perth",
                        untils: "-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Queensland",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "01010101010101010"
                    }, {
                        id: "Australia/South",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Sydney",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Tasmania",
                        untils: "-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/Victoria",
                        untils: "-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-600|-660",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Australia/West",
                        untils: "-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "0101010101010101010"
                    }, {
                        id: "Australia/Yancowinna",
                        untils: "-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-570|-630",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"
                    }, {
                        id: "Brazil/Acre",
                        untils: "-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",
                        offsets: "271.2|300|240",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "Brazil/DeNoronha",
                        untils: "-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",
                        offsets: "129.6667|120|60",
                        offsetIndices: "0121212121212121212121212121212121212121"
                    }, {
                        id: "Brazil/East",
                        untils: "-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",
                        offsets: "186.4667|180|120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Brazil/West",
                        untils: "-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",
                        offsets: "240.0667|240|180",
                        offsetIndices: "01212121212121212121212121212121"
                    }, {
                        id: "Canada/Atlantic",
                        untils: "-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "254.4|240|180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Canada/Central",
                        untils: "-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Eastern",
                        untils: "-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Mountain",
                        untils: "-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "453.8667|420|360",
                        offsetIndices: "0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Canada/Newfoundland",
                        untils: "-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "210.8667|150.8667|210|150|90",
                        offsetIndices: "01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Canada/Pacific",
                        untils: "-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Canada/Saskatchewan",
                        untils: "-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",
                        offsets: "418.6|420|360",
                        offsetIndices: "012121212121212121212121221212121212121212121212121212"
                    }, {
                        id: "Canada/Yukon",
                        untils: "-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",
                        offsets: "540|480|420",
                        offsetIndices: "01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "CET",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Chile/Continental",
                        untils: "-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "282.7667|300|240|180",
                        offsetIndices: "010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Chile/EasterIsland",
                        untils: "-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "437.4667|420|360|300",
                        offsetIndices: "012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "CST6CDT",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Cuba",
                        untils: "-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",
                        offsets: "329.6|300|240",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "EET",
                        untils: "3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Egypt",
                        untils: "-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",
                        offsets: "-120|-180",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Eire",
                        untils: "-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "25.35|-34.65|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "EST",
                        untils: "Infinity",
                        offsets: "300",
                        offsetIndices: "0"
                    }, {
                        id: "EST5EDT",
                        untils: "-r0ev80|ast80|7x9g0|ast80|bmtus0|1tzb40|2dq40|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Etc/GMT-0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-1",
                        untils: "Infinity",
                        offsets: "-60",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-10",
                        untils: "Infinity",
                        offsets: "-600",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-11",
                        untils: "Infinity",
                        offsets: "-660",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-12",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-13",
                        untils: "Infinity",
                        offsets: "-780",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-14",
                        untils: "Infinity",
                        offsets: "-840",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-2",
                        untils: "Infinity",
                        offsets: "-120",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-3",
                        untils: "Infinity",
                        offsets: "-180",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-4",
                        untils: "Infinity",
                        offsets: "-240",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-5",
                        untils: "Infinity",
                        offsets: "-300",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-6",
                        untils: "Infinity",
                        offsets: "-360",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-7",
                        untils: "Infinity",
                        offsets: "-420",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-8",
                        untils: "Infinity",
                        offsets: "-480",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT-9",
                        untils: "Infinity",
                        offsets: "-540",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+1",
                        untils: "Infinity",
                        offsets: "60",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+10",
                        untils: "Infinity",
                        offsets: "600",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+11",
                        untils: "Infinity",
                        offsets: "660",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+12",
                        untils: "Infinity",
                        offsets: "720",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+2",
                        untils: "Infinity",
                        offsets: "120",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+3",
                        untils: "Infinity",
                        offsets: "180",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+4",
                        untils: "Infinity",
                        offsets: "240",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+5",
                        untils: "Infinity",
                        offsets: "300",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+6",
                        untils: "Infinity",
                        offsets: "360",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+7",
                        untils: "Infinity",
                        offsets: "420",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+8",
                        untils: "Infinity",
                        offsets: "480",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT+9",
                        untils: "Infinity",
                        offsets: "540",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/GMT0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Greenwich",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/UCT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Universal",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/UTC",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Etc/Zulu",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Europe/Amsterdam",
                        untils: "-s0dvkk|7v980|a51o0|7x6o0|a2yo0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9b6o0|a2yo0|c51c0|6l1c0|902o0|9q000|ci000|682o0|bgyo0|79400|bitc0|779c0|bmio0|7gio0|bbeo0|7eo00|bd9c0|7ctc0|bf400|7ayo0|bvs00|6uao0|bko00|7idc0|b9k00|7gio0|bbeo0|7eo00|bf400|7ayo0|btxc0|21uc0|4uaz8|bitc0|779c0|bko00|7idc0|bd3s0|1aarpc|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-19.5333|-79.5333|-80|-20|-120|-60",
                        offsetIndices: "010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545"
                    }, {
                        id: "Europe/Andorra",
                        untils: "-c4xmo0|k3ctg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Astrakhan",
                        untils: "-nu2zkc|37bv8c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-192.2|-180|-240|-300",
                        offsetIndices: "012323232323232323212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Athens",
                        untils: "-rvv0cg|8bjasg|2vmk0|4hiw40|16ik0|scog0|7lx40|9o2k0|9eys0|4atzw0|6djw0|bplus0|bq800|71uw0|9d1c0|902o0|91xc0|9o5c0|905g0|9qgo0|9akg0|9iik0|99980|9dcg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-94.8667|-120|-180|-60",
                        offsetIndices: "012121313121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Belfast",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Belgrade",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Berlin",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|2o7w0|6bs00|2txg0|7k800|91xc0|9b9g0|1sqk0|2inw0|51k40|a2yo0|8n400|9q000|902o0|fx91c0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|-180",
                        offsetIndices: "01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Bratislava",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|0",
                        offsetIndices: "01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Brussels",
                        untils: "-ss5uo0|rrx80|7vc00|a4yw0|7x6o0|asw00|7x6o0|2wh40|5omo0|b5uo0|6uao0|cyo00|7ayo0|bko00|7rmo0|a2yo0|a2yo0|8n400|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|90b00|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|4deo0|1a36k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0121212101010101010101010101010101010101010101010101212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Bucharest",
                        untils: "-k29zi0|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|kp0dc0|6h980|9q000|905g0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-104.4|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Budapest",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|a31g0|8n180|autg0|bgvw0|b5jeg0|th9k0|7k800|9q000|9d1c0|9d1c0|awd00|9ew00|7q0c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|a4tc0|9q000|1va2g0|6u7w0|bxpg0|6u7w0|cjxg0|64ak0|cluw0|64g40|br3ek0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Busingen",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Chisinau",
                        untils: "-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-115|-104.4|-120|-180|-60|-240",
                        offsetIndices: "012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Copenhagen",
                        untils: "-rzo2w0|75bw0|cbs2w0|1aco80|7k800|9q000|9d1c0|9d1c0|9d1c0|6y000|dbmo0|6bs00|clpc0|51hc0|e1k00|4oio0|giutc0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Dublin",
                        untils: "-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "25.35|-34.65|0|-60",
                        offsetIndices: "01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Gibraltar",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|d0tp80|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101012121212121010121010101010101010101012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Guernsey",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Helsinki",
                        untils: "-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99.8167|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Isle_of_Man",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Istanbul",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "Europe/Jersey",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Kaliningrad",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|el00|z6o0|9kd80|82tg0|i9avw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-60|-120|-180|-240",
                        offsetIndices: "01010101010101121232323232323232322121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Kiev",
                        untils: "-nu11ng|37a03g|5vd6k0|kzv40|7k800|9q000|1oyg0|jipzs0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|51ek0|neqw0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-122.0667|-120|-180|-60|-240",
                        offsetIndices: "0121313242424242424242424242121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Kirov",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-198.8|-180|-240|-300",
                        offsetIndices: "01232323232323232321212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Lisbon",
                        untils: "-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "36.75|0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Ljubljana",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/London",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Luxembourg",
                        untils: "-y89550|68l290|75hg0|ast80|796s0|at1k0|7x6o0|3lh40|4zmo0|b6300|6u2c0|cytk0|7at40|bktk0|7rh40|a31g0|a2vw0|8n9k0|8zx40|9q2s0|9et80|9b9g0|a2vw0|8n6s0|9px80|905g0|a2vw0|905g0|a2vw0|8ncc0|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|42ao0|1aeak0|7k800|9q000|9d1c0|8n400|a2yo0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-24.6|-60|-120|0",
                        offsetIndices: "0121212131313131313131313131313131313131313131313131212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Madrid",
                        untils: "-qzlus0|8yas0|9cyk0|9eys0|2d2vw0|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|a2vw0|8n6s0|40lh80|5k2s0|9cyk0|1frw0|7z1c0|j1c80|8a2k0|13yt80|685g0|brzw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|1clx80|7x9g0|cswik0|905g0|9px80|905g0|8zzw0|9d440|9px80|905g0|9q5k0|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "010101010101010101210121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Malta",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9b6o0|8n400|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|9b6o0|9d1c0|ahs00|7m2o0|b45k0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|a4w40|8y580|9q2s0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Mariehamn",
                        untils: "-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99.8167|-120|-180",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Minsk",
                        untils: "-nu113c|379zjc|5r1mk0|pbf40|7k800|9q000|9d1c0|4oac0|j6dmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|sg2o0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|Infinity",
                        offsets: "-110|-120|-180|-60|-240",
                        offsetIndices: "01213131242424242424242424221212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Monaco",
                        untils: "-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|mdbo0|7x3w0|7x9g0|c8w80|7k800|9q000|9d1c0|9nzs0|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Moscow",
                        untils: "-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",
                        offsetIndices: "012132345464575454545454545454545455754545454545454545454545454545454545454545"
                    }, {
                        id: "Europe/Nicosia",
                        untils: "-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-133.4667|-120|-180",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Oslo",
                        untils: "-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Paris",
                        untils: "-uozn1x|2qx1lx|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|5p8w0|18rcc0|7k800|9q000|9d1c0|7efo0|29k40|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-9.35|0|-60|-120",
                        offsetIndices: "0121212121212121212121212121212121212121212121212123232332323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Podgorica",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Prague",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|0",
                        offsetIndices: "01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Riga",
                        untils: "-qznlky|7x6o0|a4tc0|2mg00|3myns0|7fhlky|gz180|p5v40|7k800|9q000|9d1c0|9d1c0|k7s0|j14ns0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|asw00|7x6o0|asw00|7x6o0|b5uo0|qaao0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-96.5667|-156.5667|-120|-180|-60|-240",
                        offsetIndices: "010102324242435353535353535353323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Rome",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Samara",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|jt1g0|89zs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",
                        offsets: "-200.3333|-180|-240|-300",
                        offsetIndices: "0123232323232323232121232323232323232323232323232323232323212"
                    }, {
                        id: "Europe/San_Marino",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Sarajevo",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Saratov",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|13m040|Infinity",
                        offsets: "-184.3|-180|-240|-300",
                        offsetIndices: "012323232323232321212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Simferopol",
                        untils: "-nu12ao|37a0qo|5xiyk0|iu340|7k800|9q000|9d1c0|iac0|jajmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|wrjw0|9cyk0|9d440|9cyk0|9d440|1sqk0|7k580|9d440|9cyk0|9q2s0|at4c0|7x9g0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x3w0|asqg0|Infinity",
                        offsets: "-136|-120|-180|-60|-240",
                        offsetIndices: "012131312424242424242424242121212424242212121212121212121212121212121212142"
                    }, {
                        id: "Europe/Skopje",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Sofia",
                        untils: "-e6dzw0|7k800|9q000|9d1c0|9d1c0|9d440|hqq240|9eys0|9o2k0|92040|9o2k0|90880|9pug0|90b00|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-120|-60|-180",
                        offsetIndices: "01010102020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"
                    }, {
                        id: "Europe/Stockholm",
                        untils: "-rzo2w0|75hg0|x5bew0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Tallinn",
                        untils: "-r3exx0|3re10|7x6o0|et6g0|ygov0|a1zgd0|ktx80|l94g0|7k800|9q000|9d1c0|8uac0|j27mk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asys0|7x6o0|b5uo0|19dc00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-99|-60|-120|-180|-240",
                        offsetIndices: "012102321212343434343434343433232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Tirane",
                        untils: "-t85vo8|dt2gw8|18pew0|7k800|m800|g7ot40|7rjw0|autg0|7x3w0|ayis0|7x3w0|b5xg0|7k580|b42s0|7lzw0|b42s0|7lzw0|b42s0|7x3w0|ahus0|7x3w0|b5xg0|7x3w0|a4w40|8jbw0|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-79.3333|-60|-120",
                        offsetIndices: "01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Tiraspol",
                        untils: "-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-115|-104.4|-120|-180|-60|-240",
                        offsetIndices: "012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "Europe/Ulyanovsk",
                        untils: "-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",
                        offsets: "-193.6|-180|-240|-300|-120",
                        offsetIndices: "01232323232323232321214121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Uzhgorod",
                        untils: "-fizzw0|1cm000|7k800|9q000|9d1c0|al900|cnms0|int140|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|e1sc0|iprk0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120|-180|-240",
                        offsetIndices: "010101023232323232323232320121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Vaduz",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vatican",
                        untils: "-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vienna",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|t6000|8a5c0|a7a800|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|iio0|ivmo0|91xc0|9b6o0|9d1c0|a2yo0|8n400|gfyyg0|8zzw0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Vilnius",
                        untils: "-rns980|1g224o|e75nc|4kqk0|acbs40|gpp40|pits0|7k800|9q000|9d1c0|65zo0|j4vx80|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x9g0|asw00|7x6o0|b5uo0|1s3eo0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-95.6|-60|-120|-180|-240",
                        offsetIndices: "012324323234545454545454545443434343434343434332334343434343434343434343434343434343434343434343434343434343434343434343"
                    }, {
                        id: "Europe/Volgograd",
                        untils: "-q3cw84|5glrw4|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|239c40|Infinity",
                        offsets: "-177.6667|-180|-240|-300",
                        offsetIndices: "012323232323232321212121212121212121212121212121212121212121212"
                    }, {
                        id: "Europe/Warsaw",
                        untils: "-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-60|-120|-180",
                        offsetIndices: "012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Zagreb",
                        untils: "-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Europe/Zaporozhye",
                        untils: "-nu12hc|37a0xc|5u1180|mc0g0|7k800|9q000|12qg0|jjc7s0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9cvs0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-140|-120|-180|-60|-240",
                        offsetIndices: "01213132424242424242424242422121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Europe/Zurich",
                        untils: "-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GB-Eire",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GB",
                        untils: "-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60|-120",
                        offsetIndices: "0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "GMT-0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT+0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "GMT0",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Greenwich",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Hongkong",
                        untils: "-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",
                        offsets: "-456.7|-480|-540|-510",
                        offsetIndices: "0123212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "HST",
                        untils: "Infinity",
                        offsets: "600",
                        offsetIndices: "0"
                    }, {
                        id: "Iceland",
                        untils: "-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",
                        offsets: "88|60|0",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Indian/Antananarivo",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Chagos",
                        untils: "-wvpc2s|1ag64us|Infinity",
                        offsets: "-289.6667|-300|-360",
                        offsetIndices: "012"
                    }, {
                        id: "Indian/Christmas",
                        untils: "Infinity",
                        offsets: "-420",
                        offsetIndices: "0"
                    }, {
                        id: "Indian/Cocos",
                        untils: "Infinity",
                        offsets: "-390",
                        offsetIndices: "0"
                    }, {
                        id: "Indian/Comoro",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Kerguelen",
                        untils: "-afrs00|Infinity",
                        offsets: "0|-300",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Mahe",
                        untils: "-x6pjlo|Infinity",
                        offsets: "-221.8|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Maldives",
                        untils: "-57x6y0|Infinity",
                        offsets: "-294|-300",
                        offsetIndices: "01"
                    }, {
                        id: "Indian/Mauritius",
                        untils: "-wvp9bc|13jnu7c|8bx80|dd0wc0|7x3w0|Infinity",
                        offsets: "-230|-240|-300",
                        offsetIndices: "012121"
                    }, {
                        id: "Indian/Mayotte",
                        untils: "-lnsetg|s8mhg|57v020|afrrb0|Infinity",
                        offsets: "-147.2667|-180|-150|-165",
                        offsetIndices: "01231"
                    }, {
                        id: "Indian/Reunion",
                        untils: "-uks29s|Infinity",
                        offsets: "-221.8667|-240",
                        offsetIndices: "01"
                    }, {
                        id: "Iran",
                        untils: "-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",
                        offsets: "-205.7333|-210|-240|-300|-270",
                        offsetIndices: "00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"
                    }, {
                        id: "Israel",
                        untils: "-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",
                        offsets: "-140.6667|-120|-180|-240",
                        offsetIndices: "012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Jamaica",
                        untils: "-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",
                        offsets: "307.1667|300|240",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "Japan",
                        untils: "-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",
                        offsets: "-540|-600",
                        offsetIndices: "010101010"
                    }, {
                        id: "Kwajalein",
                        untils: "-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",
                        offsets: "-660|-600|-540|720|-720",
                        offsetIndices: "012034"
                    }, {
                        id: "Libya",
                        untils: "-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",
                        offsets: "-52.7333|-60|-120",
                        offsetIndices: "012121212121212121212121212122122"
                    }, {
                        id: "MET",
                        untils: "-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-60|-120",
                        offsetIndices: "01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Mexico/BajaNorte",
                        untils: "-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "468.0667|420|480",
                        offsetIndices: "012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Mexico/BajaSur",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "425.6667|420|360|480",
                        offsetIndices: "0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Mexico/General",
                        untils: "-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",
                        offsets: "396.6|420|360|300",
                        offsetIndices: "012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "MST",
                        untils: "Infinity",
                        offsets: "420",
                        offsetIndices: "0"
                    }, {
                        id: "MST7MDT",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Navajo",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "NZ-CHAT",
                        untils: "-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-735|-765|-825",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "NZ",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Apia",
                        untils: "-usiiv4|kcrmt4|vp3la0|9odo0|902o0|4zbk0|4qog0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "686.9333|690|660|600|-840|-780",
                        offsetIndices: "01232345454545454545454545454545454545454545454545454545454"
                    }, {
                        id: "Pacific/Auckland",
                        untils: "-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-690|-750|-720|-780",
                        offsetIndices: "01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Bougainville",
                        untils: "-ecsh40|1n05g0|1071c40|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "0102"
                    }, {
                        id: "Pacific/Chatham",
                        untils: "-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",
                        offsets: "-735|-765|-825",
                        offsetIndices: "012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"
                    }, {
                        id: "Pacific/Chuuk",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Pacific/Easter",
                        untils: "-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",
                        offsets: "437.4667|420|360|300",
                        offsetIndices: "012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"
                    }, {
                        id: "Pacific/Efate",
                        untils: "-u964i4|11f4ba4|9cyk0|awo40|7tek0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|64ak0|e1ms0|4ofw0|Infinity",
                        offsets: "-673.2667|-660|-720",
                        offsetIndices: "0121212121212121212121"
                    }, {
                        id: "Pacific/Enderbury",
                        untils: "535io0|7yiqk0|Infinity",
                        offsets: "720|660|-780",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Fakaofo",
                        untils: "lx0jw0|Infinity",
                        offsets: "660|-780",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Fiji",
                        untils: "-sa2x4w|17bs00w|64dc0|cyo00|5reo0|53a5c0|64dc0|asw00|6uao0|bvs00|4oio0|e1k00|4oio0|eeio0|4bh80|erk40|3ylc0|erhc0|3ylc0|f4g00|3lmo0|f4g00|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|Infinity",
                        offsets: "-715.7333|-720|-780",
                        offsetIndices: "0121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Pacific/Funafuti",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Galapagos",
                        untils: "-kcr62o|spdryo|3lsas0|3jp80|Infinity",
                        offsets: "358.4|300|360",
                        offsetIndices: "01212"
                    }, {
                        id: "Pacific/Gambier",
                        untils: "-tvndoc|Infinity",
                        offsets: "539.8|540",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Guadalcanal",
                        untils: "-tvowac|Infinity",
                        offsets: "-639.8|-660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Guam",
                        untils: "-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "01020202020202020200"
                    }, {
                        id: "Pacific/Honolulu",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "Pacific/Johnston",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "Pacific/Kiritimati",
                        untils: "535eyo|7yirhc|Infinity",
                        offsets: "640|600|-840",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Kosrae",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|cm2540|f9l3w0|Infinity",
                        offsets: "-660|-540|-600|-720",
                        offsetIndices: "01021030"
                    }, {
                        id: "Pacific/Kwajalein",
                        untils: "-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",
                        offsets: "-660|-600|-540|720|-720",
                        offsetIndices: "012034"
                    }, {
                        id: "Pacific/Majuro",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|1h6w40|deat40|Infinity",
                        offsets: "-660|-540|-600|-720",
                        offsetIndices: "0102103"
                    }, {
                        id: "Pacific/Marquesas",
                        untils: "-tvncu0|Infinity",
                        offsets: "558|570",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Midway",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Nauru",
                        untils: "-pjxiws|ba66ys|1kwca0|hfzda0|Infinity",
                        offsets: "-667.6667|-690|-540|-720",
                        offsetIndices: "01213"
                    }, {
                        id: "Pacific/Niue",
                        untils: "-9wyz6o|ehcj4o|Infinity",
                        offsets: "680|690|660",
                        offsetIndices: "012"
                    }, {
                        id: "Pacific/Norfolk",
                        untils: "-9x0ps0|cfj8q0|6hc00|l6nk00|239aq0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",
                        offsets: "-672|-690|-750|-660|-720",
                        offsetIndices: "012134343434343434343434343434343434343434"
                    }, {
                        id: "Pacific/Noumea",
                        untils: "-u9645o|ye0ixo|4dbw0|ecqs0|4f6k0|99p700|4oio0|Infinity",
                        offsets: "-665.8|-660|-720",
                        offsetIndices: "01212121"
                    }, {
                        id: "Pacific/Pago_Pago",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Palau",
                        untils: "Infinity",
                        offsets: "-540",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Pitcairn",
                        untils: "es2cy0|Infinity",
                        offsets: "510|480",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Pohnpei",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",
                        offsets: "-660|-540|-600",
                        offsetIndices: "010210"
                    }, {
                        id: "Pacific/Ponape",
                        untils: "-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",
                        offsets: "-660|-540|-600",
                        offsetIndices: "010210"
                    }, {
                        id: "Pacific/Port_Moresby",
                        untils: "Infinity",
                        offsets: "-600",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Rarotonga",
                        untils: "4mj960|5rbw0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "012121212121212121212121212"
                    }, {
                        id: "Pacific/Saipan",
                        untils: "-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",
                        offsets: "-600|-540|-660",
                        offsetIndices: "01020202020202020200"
                    }, {
                        id: "Pacific/Samoa",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Tahiti",
                        untils: "-tvnayw|Infinity",
                        offsets: "598.2667|600",
                        offsetIndices: "01"
                    }, {
                        id: "Pacific/Tarawa",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Tongatapu",
                        untils: "-f4vrlc|uo2edc|8fpc0|bvs00|4bh80|eelg0|4bh80|7pmis0|3lmo0|Infinity",
                        offsets: "-740|-780|-840",
                        offsetIndices: "0121212121"
                    }, {
                        id: "Pacific/Truk",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Pacific/Wake",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Wallis",
                        untils: "Infinity",
                        offsets: "-720",
                        offsetIndices: "0"
                    }, {
                        id: "Pacific/Yap",
                        untils: "-su4zs0|29hes0|bkenw0|29fk40|Infinity",
                        offsets: "-600|-540",
                        offsetIndices: "01010"
                    }, {
                        id: "Poland",
                        untils: "-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "-84|-60|-120|-180",
                        offsetIndices: "012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "Portugal",
                        untils: "-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "36.75|0|-60|-120",
                        offsetIndices: "012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "PRC",
                        untils: "-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010"
                    }, {
                        id: "PST8PDT",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "ROC",
                        untils: "-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",
                        offsets: "-480|-540",
                        offsetIndices: "01010101010101010101010101010101010101010"
                    }, {
                        id: "ROK",
                        untils: "-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",
                        offsets: "-507.8667|-510|-540|-600|-570",
                        offsetIndices: "012232323232141414141414123232"
                    }, {
                        id: "Singapore",
                        untils: "-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",
                        offsets: "-415.4167|-420|-440|-450|-540|-480",
                        offsetIndices: "0123435"
                    }, {
                        id: "Turkey",
                        untils: "-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",
                        offsets: "-116.9333|-120|-180|-240",
                        offsetIndices: "0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"
                    }, {
                        id: "UCT",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "Universal",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "US/Alaska",
                        untils: "-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "600|540|480",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Aleutian",
                        untils: "-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "660|600|540",
                        offsetIndices: "011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Arizona",
                        untils: "-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101010"
                    }, {
                        id: "US/Central",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/East-Indiana",
                        untils: "-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300|240",
                        offsetIndices: "010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"
                    }, {
                        id: "US/Eastern",
                        untils: "-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "300|240",
                        offsetIndices: "01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Hawaii",
                        untils: "-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",
                        offsets: "630|570|600",
                        offsetIndices: "0101102"
                    }, {
                        id: "US/Indiana-Starke",
                        untils: "-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "360|300",
                        offsetIndices: "0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Michigan",
                        untils: "-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "332.1833|360|300|240",
                        offsetIndices: "0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"
                    }, {
                        id: "US/Mountain",
                        untils: "-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "420|360",
                        offsetIndices: "01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Pacific-New",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Pacific",
                        untils: "-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",
                        offsets: "480|420",
                        offsetIndices: "010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "US/Samoa",
                        untils: "-usij20|Infinity",
                        offsets: "682.8|660",
                        offsetIndices: "01"
                    }, {
                        id: "UTC",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }, {
                        id: "W-SU",
                        untils: "-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",
                        offsets: "-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",
                        offsetIndices: "012132345464575454545454545454545455754545454545454545454545454545454545454545"
                    }, {
                        id: "WET",
                        untils: "3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",
                        offsets: "0|-60",
                        offsetIndices: "010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"
                    }, {
                        id: "Zulu",
                        untils: "Infinity",
                        offsets: "0",
                        offsetIndices: "0"
                    }]
                }
            },
        41690:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/m_advanced_chart.js ***!
              \*************************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.AdvancedChart = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _base_axis = __webpack_require__( /*! ../../../viz/axes/base_axis */ 41278);
                var _series_family = __webpack_require__( /*! ../../../viz/core/series_family */ 1939);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _range_data_calculator = (obj = __webpack_require__( /*! ../../../viz/series/helpers/range_data_calculator */ 63407), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _range = __webpack_require__( /*! ../../../viz/translators/range */ 21177);
                var _utils2 = __webpack_require__( /*! ../../../viz/utils */ 34434);
                var _m_base_chart = __webpack_require__( /*! ./m_base_chart */ 14107);

                function _extends() {
                    _extends = Object.assign ? Object.assign.bind() : function(target) {
                        for (var i = 1; i < arguments.length; i++) {
                            var source = arguments[i];
                            for (var key in source) {
                                if (Object.prototype.hasOwnProperty.call(source, key)) {
                                    target[key] = source[key]
                                }
                            }
                        }
                        return target
                    };
                    return _extends.apply(this, arguments)
                }
                const {
                    isArray: isArray
                } = Array;

                function prepareAxis(axisOptions) {
                    if (isArray(axisOptions)) {
                        return 0 === axisOptions.length ? [{}] : axisOptions
                    }
                    return [axisOptions]
                }

                function setAxisVisualRangeByOption(arg, axis, isDirectOption, index) {
                    let options;
                    let visualRange;
                    if (isDirectOption) {
                        visualRange = arg.value;
                        options = {
                            skipEventRising: true
                        };
                        const wrappedVisualRange = wrapVisualRange(arg.fullName, visualRange);
                        if (wrappedVisualRange) {
                            options = {
                                allowPartialUpdate: true
                            };
                            visualRange = wrappedVisualRange
                        }
                    } else {
                        visualRange = ((0, _type.isDefined)(index) ? arg.value[index] : arg.value).visualRange
                    }
                    axis.visualRange(visualRange, options)
                }

                function wrapVisualRange(fullName, value) {
                    const pathElements = fullName.split(".");
                    const destElem = pathElements.at(-1);
                    if ("endValue" === destElem || "startValue" === destElem) {
                        return {
                            [destElem]: value
                        }
                    }
                    return
                }
                const AdvancedChart = _m_base_chart.BaseChart.inherit({
                    _fontFields: ["".concat("commonAxisSettings", ".label.").concat("font"), "".concat("commonAxisSettings", ".title.").concat("font")],
                    _partialOptionChangesMap: {
                        visualRange: "VISUAL_RANGE",
                        _customVisualRange: "VISUAL_RANGE",
                        strips: "REFRESH_AXES",
                        constantLines: "REFRESH_AXES"
                    },
                    _partialOptionChangesPath: {
                        argumentAxis: ["strips", "constantLines", "visualRange", "_customVisualRange"],
                        valueAxis: ["strips", "constantLines", "visualRange", "_customVisualRange"]
                    },
                    _initCore() {
                        this._panesClipRects = {};
                        this.callBase()
                    },
                    _disposeCore() {
                        const disposeObjectsInArray = this._disposeObjectsInArray;
                        const panesClipRects = this._panesClipRects;
                        this.callBase();
                        disposeObjectsInArray.call(panesClipRects, "fixed");
                        disposeObjectsInArray.call(panesClipRects, "base");
                        disposeObjectsInArray.call(panesClipRects, "wide");
                        this._panesClipRects = null;
                        this._labelsAxesGroup.linkOff();
                        this._labelsAxesGroup.dispose();
                        this._labelsAxesGroup = null
                    },
                    _dispose() {
                        const disposeObjectsInArray = this._disposeObjectsInArray;
                        this.callBase();
                        this.panes = null;
                        if (this._legend) {
                            this._legend.dispose();
                            this._legend = null
                        }
                        disposeObjectsInArray.call(this, "panesBackground");
                        disposeObjectsInArray.call(this, "seriesFamilies");
                        this._disposeAxes()
                    },
                    _createPanes() {
                        this._cleanPanesClipRects("fixed");
                        this._cleanPanesClipRects("base");
                        this._cleanPanesClipRects("wide")
                    },
                    _cleanPanesClipRects(clipArrayName) {
                        const clipArray = this._panesClipRects[clipArrayName];
                        (clipArray || []).forEach(clipRect => {
                            null === clipRect || void 0 === clipRect ? void 0 : clipRect.dispose()
                        });
                        this._panesClipRects[clipArrayName] = []
                    },
                    _getElementsClipRectID(paneName) {
                        const clipShape = this._panesClipRects.fixed[this._getPaneIndex(paneName)];
                        return null === clipShape || void 0 === clipShape ? void 0 : clipShape.id
                    },
                    _getPaneIndex(paneName) {
                        const name = paneName || "default";
                        return this.panes.findIndex(pane => pane.name === name)
                    },
                    _updateSize(forceUpdateCanvas) {
                        this.callBase();
                        if (forceUpdateCanvas && (0, _utils2.areCanvasesDifferent)(this.__currentCanvas, this._canvas)) {
                            this.__currentCanvas = (0, _utils2.floorCanvasDimensions)(this._canvas)
                        }(0, _utils.setCanvasValues)(this._canvas)
                    },
                    _reinitAxes() {
                        this.panes = this._createPanes();
                        this._populateAxes();
                        this._axesReinitialized = true
                    },
                    _populateAxes() {
                        const {
                            panes: panes
                        } = this;
                        const rotated = this._isRotated();
                        const argumentAxesOptions = prepareAxis(this.option("argumentAxis") || {})[0];
                        const valueAxisOption = this.option("valueAxis");
                        const valueAxesOptions = prepareAxis(valueAxisOption || {});
                        let argumentAxesPopulatedOptions = [];
                        const valueAxesPopulatedOptions = [];
                        const axisNames = [];
                        let valueAxesCounter = 0;
                        let paneWithNonVirtualAxis;
                        const crosshairMargins = this._getCrosshairMargins();

                        function getNextAxisName() {
                            const name = "defaultAxisName" + String(valueAxesCounter);
                            valueAxesCounter += 1;
                            return name
                        }
                        if (rotated) {
                            paneWithNonVirtualAxis = "right" === argumentAxesOptions.position ? panes[panes.length - 1].name : panes[0].name
                        } else {
                            paneWithNonVirtualAxis = "top" === argumentAxesOptions.position ? panes[0].name : panes[panes.length - 1].name
                        }
                        argumentAxesPopulatedOptions = (0, _utils.map)(panes, pane => {
                            const virtual = pane.name !== paneWithNonVirtualAxis;
                            return this._populateAxesOptions("argumentAxis", argumentAxesOptions, {
                                pane: pane.name,
                                name: null,
                                optionPath: "argumentAxis",
                                crosshairMargin: rotated ? crosshairMargins.x : crosshairMargins.y
                            }, rotated, virtual)
                        });
                        valueAxesOptions.forEach((axisOptions, priority) => {
                            var _a;
                            let axisPanes = [];
                            const {
                                name: name
                            } = axisOptions;
                            if (name && axisNames.includes(name)) {
                                this._incidentOccurred("E2102");
                                return
                            }
                            if (name) {
                                axisNames.push(name)
                            }
                            if (axisOptions.pane) {
                                axisPanes.push(axisOptions.pane)
                            }
                            if (null === (_a = axisOptions.panes) || void 0 === _a ? void 0 : _a.length) {
                                axisPanes = axisPanes.concat(axisOptions.panes.slice(0))
                            }
                            axisPanes = (0, _utils.unique)(axisPanes);
                            if (!axisPanes.length) {
                                axisPanes.push(void 0)
                            }
                            axisPanes.forEach(pane => {
                                const optionPath = isArray(valueAxisOption) ? "valueAxis[".concat(String(priority), "]") : "valueAxis";
                                valueAxesPopulatedOptions.push(this._populateAxesOptions("valueAxis", axisOptions, {
                                    name: name || getNextAxisName(),
                                    pane: pane,
                                    priority: priority,
                                    optionPath: optionPath,
                                    crosshairMargin: rotated ? crosshairMargins.y : crosshairMargins.x
                                }, rotated))
                            })
                        });
                        this._redesignAxes(argumentAxesPopulatedOptions, true, paneWithNonVirtualAxis);
                        this._redesignAxes(valueAxesPopulatedOptions, false)
                    },
                    _redesignAxes(options, isArgumentAxes, paneWithNonVirtualAxis) {
                        const axesBasis = [];
                        let axes = isArgumentAxes ? this._argumentAxes : this._valueAxes;
                        options.forEach(opt => {
                            const curAxes = null === axes || void 0 === axes ? void 0 : axes.filter(a => a.name === opt.name && (!(0, _type.isDefined)(opt.pane) && this.panes.some(p => p.name === a.pane) || a.pane === opt.pane));
                            if (null === curAxes || void 0 === curAxes ? void 0 : curAxes.length) {
                                curAxes.forEach(axis => {
                                    const axisTypes = function(groupsData, axis, isArgumentAxes) {
                                        if (isArgumentAxes) {
                                            return {
                                                argumentAxisType: groupsData.argumentAxisType,
                                                argumentType: groupsData.argumentType
                                            }
                                        }
                                        const {
                                            valueAxisType: valueAxisType,
                                            valueType: valueType
                                        } = groupsData.groups.find(g => g.valueAxis === axis);
                                        return {
                                            valueAxisType: valueAxisType,
                                            valueType: valueType
                                        }
                                    }(this._groupsData, axis, isArgumentAxes);
                                    axis.updateOptions(opt);
                                    if (isArgumentAxes) {
                                        axis.setTypes(axisTypes.argumentAxisType, axisTypes.argumentType, "argumentType")
                                    } else {
                                        axis.setTypes(axisTypes.valueAxisType, axisTypes.valueType, "valueType")
                                    }
                                    axis.validate();
                                    axesBasis.push({
                                        axis: axis
                                    })
                                })
                            } else {
                                axesBasis.push({
                                    options: opt
                                })
                            }
                        });
                        if (axes) {
                            (0, _iterator.reverseEach)(axes, (index, axis) => {
                                if (!axesBasis.some(basis => basis.axis && basis.axis === axis)) {
                                    this._disposeAxis(index, isArgumentAxes)
                                }
                            })
                        } else if (isArgumentAxes) {
                            axes = this._argumentAxes = []
                        } else {
                            axes = this._valueAxes = []
                        }
                        axesBasis.forEach(basis => {
                            let {
                                axis: axis
                            } = basis;
                            if (basis.axis && isArgumentAxes) {
                                basis.axis.isVirtual = basis.axis.pane !== paneWithNonVirtualAxis
                            } else if (basis.options) {
                                axis = this._createAxis(isArgumentAxes, basis.options, isArgumentAxes ? basis.options.pane !== paneWithNonVirtualAxis : void 0);
                                axes.push(axis)
                            }
                            axis.applyVisualRangeSetter(this._getVisualRangeSetter())
                        })
                    },
                    _disposeAxis(index, isArgumentAxis) {
                        const axes = isArgumentAxis ? this._argumentAxes : this._valueAxes;
                        const axis = axes[index];
                        if (!axis) {
                            return
                        }
                        axis.dispose();
                        axes.splice(index, 1)
                    },
                    _disposeAxes() {
                        const disposeObjectsInArray = this._disposeObjectsInArray;
                        disposeObjectsInArray.call(this, "_argumentAxes");
                        disposeObjectsInArray.call(this, "_valueAxes")
                    },
                    _appendAdditionalSeriesGroups() {
                        this._crosshairCursorGroup.linkAppend();
                        if (this._scrollBar) {
                            this._scrollBarGroup.linkAppend()
                        }
                    },
                    _getLegendTargets() {
                        return (this.series || []).map(s => {
                            const item = this._getLegendOptions(s);
                            item.legendData.series = s;
                            if (!s.getOptions().showInLegend) {
                                item.legendData.visible = false
                            }
                            return item
                        })
                    },
                    _legendItemTextField: "name",
                    _seriesPopulatedHandlerCore() {
                        this._processSeriesFamilies();
                        this._processValueAxisFormat()
                    },
                    _renderTrackers() {
                        for (let i = 0; i < this.series.length; i += 1) {
                            this.series[i].drawTrackers()
                        }
                    },
                    _specialProcessSeries() {
                        this._processSeriesFamilies()
                    },
                    _processSeriesFamilies() {
                        var _a;
                        const types = [];
                        const families = [];
                        let paneSeries;
                        const themeManager = this._themeManager;
                        const negativesAsZeroes = themeManager.getOptions("negativesAsZeroes");
                        const negativesAsZeros = themeManager.getOptions("negativesAsZeros");
                        const familyOptions = {
                            minBubbleSize: themeManager.getOptions("minBubbleSize"),
                            maxBubbleSize: themeManager.getOptions("maxBubbleSize"),
                            barGroupPadding: themeManager.getOptions("barGroupPadding"),
                            barGroupWidth: themeManager.getOptions("barGroupWidth"),
                            negativesAsZeroes: (0, _type.isDefined)(negativesAsZeroes) ? negativesAsZeroes : negativesAsZeros
                        };
                        if (null === (_a = this.seriesFamilies) || void 0 === _a ? void 0 : _a.length) {
                            this.seriesFamilies.forEach(family => {
                                family.updateOptions(familyOptions);
                                family.adjustSeriesValues()
                            });
                            return
                        }
                        this.series.forEach(item => {
                            if (!types.includes(item.type)) {
                                types.push(item.type)
                            }
                        });
                        this._getLayoutTargets().forEach(pane => {
                            paneSeries = this._getSeriesForPane(pane.name);
                            types.forEach(type => {
                                const family = new _series_family.SeriesFamily({
                                    type: type,
                                    pane: pane.name,
                                    minBubbleSize: familyOptions.minBubbleSize,
                                    maxBubbleSize: familyOptions.maxBubbleSize,
                                    barGroupPadding: familyOptions.barGroupPadding,
                                    barGroupWidth: familyOptions.barGroupWidth,
                                    negativesAsZeroes: familyOptions.negativesAsZeroes,
                                    rotated: this._isRotated()
                                });
                                family.add(paneSeries);
                                family.adjustSeriesValues();
                                families.push(family)
                            })
                        });
                        this.seriesFamilies = families
                    },
                    _updateSeriesDimensions() {
                        const seriesFamilies = this.seriesFamilies || [];
                        for (let i = 0; i < seriesFamilies.length; i += 1) {
                            const family = seriesFamilies[i];
                            family.updateSeriesValues();
                            family.adjustSeriesDimensions()
                        }
                    },
                    _getLegendCallBack(series) {
                        var _a;
                        return null === (_a = this._legend) || void 0 === _a ? void 0 : _a.getActionCallback(series)
                    },
                    _appendAxesGroups() {
                        this._stripsGroup.linkAppend();
                        this._gridGroup.linkAppend();
                        this._axesGroup.linkAppend();
                        this._labelsAxesGroup.linkAppend();
                        this._constantLinesGroup.linkAppend();
                        this._stripLabelAxesGroup.linkAppend();
                        this._scaleBreaksGroup.linkAppend()
                    },
                    _populateMarginOptions() {
                        const bubbleSize = function(size, panesCount, maxSize, rotated) {
                            const width = rotated ? size.width / panesCount : size.width;
                            const height = rotated ? size.height : size.height / panesCount;
                            return Math.min(width, height) * maxSize
                        }(this.getSize(), this.panes.length, this._themeManager.getOptions("maxBubbleSize"), this._isRotated());
                        let argumentMarginOptions = {};
                        this._valueAxes.forEach(valueAxis => {
                            const groupSeries = this.series.filter(series => series.getValueAxis() === valueAxis);
                            let marginOptions = {};
                            groupSeries.forEach(series => {
                                if (series.isVisible()) {
                                    const seriesMarginOptions = function(marginOptions, bubbleSize) {
                                        if (marginOptions.processBubbleSize) {
                                            marginOptions.size = bubbleSize
                                        }
                                        return marginOptions
                                    }(series.getMarginOptions(), bubbleSize);
                                    marginOptions = (0, _utils.mergeMarginOptions)(marginOptions, seriesMarginOptions);
                                    argumentMarginOptions = (0, _utils.mergeMarginOptions)(argumentMarginOptions, seriesMarginOptions)
                                }
                            });
                            valueAxis.setMarginOptions(marginOptions)
                        });
                        this._argumentAxes.forEach(a => a.setMarginOptions(argumentMarginOptions))
                    },
                    _populateBusinessRange(updatedAxis, keepRange) {
                        const rotated = this._isRotated();
                        const series = this._getVisibleSeries();
                        const argRanges = {};
                        const commonArgRange = new _range.Range({
                            rotated: !!rotated
                        });
                        const getPaneName = axis => axis.pane || "default";
                        this.panes.forEach(p => {
                            argRanges[p.name] = new _range.Range({
                                rotated: !!rotated
                            })
                        });
                        this._valueAxes.forEach(valueAxis => {
                            const groupRange = new _range.Range({
                                rotated: !!rotated,
                                pane: valueAxis.pane,
                                axis: valueAxis.name
                            });
                            const groupSeries = series.filter(series => series.getValueAxis() === valueAxis);
                            groupSeries.forEach(series => {
                                const seriesRange = series.getRangeData();
                                groupRange.addRange(seriesRange.val);
                                argRanges[getPaneName(valueAxis)].addRange(seriesRange.arg)
                            });
                            if (!updatedAxis || updatedAxis && groupSeries.length && valueAxis === updatedAxis) {
                                valueAxis.setGroupSeries(groupSeries);
                                valueAxis.setBusinessRange(groupRange, this._axesReinitialized || keepRange, this._argumentAxes[0]._lastVisualRangeUpdateMode)
                            }
                        });
                        if (!updatedAxis || updatedAxis && series.length) {
                            Object.keys(argRanges).forEach(p => commonArgRange.addRange(argRanges[p]));
                            const commonInterval = commonArgRange.interval;
                            this._argumentAxes.forEach(a => {
                                var _a;
                                const currentInterval = null !== (_a = argRanges[getPaneName(a)].interval) && void 0 !== _a ? _a : commonInterval;
                                a.setBusinessRange(new _range.Range(_extends(_extends({}, commonArgRange), {
                                    interval: currentInterval
                                })), this._axesReinitialized, void 0, this._groupsData.categories)
                            })
                        }
                        this._populateMarginOptions()
                    },
                    getArgumentAxis() {
                        return (this._argumentAxes || []).find(a => !a.isVirtual)
                    },
                    getValueAxis(name) {
                        return (this._valueAxes || []).find((0, _type.isDefined)(name) ? a => a.name === name : a => a.pane === this.defaultPane)
                    },
                    _getGroupsData() {
                        const groups = [];
                        this._valueAxes.forEach(axis => {
                            groups.push({
                                series: this.series.filter(series => series.getValueAxis() === axis),
                                valueAxis: axis,
                                valueOptions: axis.getOptions()
                            })
                        });
                        return {
                            groups: groups,
                            argumentAxes: this._argumentAxes,
                            argumentOptions: this._argumentAxes[0].getOptions()
                        }
                    },
                    _groupSeries() {
                        this._correctValueAxes(false);
                        this._groupsData = this._getGroupsData()
                    },
                    _processValueAxisFormat() {
                        const axesWithFullStackedFormat = [];
                        this.series.forEach(series => {
                            const axis = series.getValueAxis();
                            if (series.isFullStackedSeries()) {
                                axis.setPercentLabelFormat();
                                axesWithFullStackedFormat.push(axis)
                            }
                        });
                        this._valueAxes.forEach(axis => {
                            if (!axesWithFullStackedFormat.includes(axis)) {
                                axis.resetAutoLabelFormat()
                            }
                        })
                    },
                    _populateAxesOptions(typeSelector, userOptions, axisOptions, rotated, virtual) {
                        const preparedUserOptions = this._prepareStripsAndConstantLines(typeSelector, userOptions, rotated);
                        const options = (0, _extend2.extend)(true, {}, preparedUserOptions, axisOptions, this._prepareAxisOptions(typeSelector, preparedUserOptions, rotated));
                        if (virtual) {
                            options.visible = false;
                            options.tick.visible = false;
                            options.minorTick.visible = false;
                            options.label.visible = false;
                            options.title = {}
                        }
                        return options
                    },
                    _getValFilter: series => _range_data_calculator.default.getViewPortFilter(series.getValueAxis().visualRange() || {}),
                    _createAxis(isArgumentAxes, options, virtual) {
                        const typeSelector = isArgumentAxes ? "argumentAxis" : "valueAxis";
                        const renderingSettings = (0, _extend2.extend)({
                            renderer: this._renderer,
                            incidentOccurred: this._incidentOccurred,
                            eventTrigger: this._eventTrigger,
                            axisClass: isArgumentAxes ? "arg" : "val",
                            widgetClass: "dxc",
                            stripsGroup: this._stripsGroup,
                            stripLabelAxesGroup: this._stripLabelAxesGroup,
                            constantLinesGroup: this._constantLinesGroup,
                            scaleBreaksGroup: this._scaleBreaksGroup,
                            axesContainerGroup: this._axesGroup,
                            labelsAxesGroup: this._labelsAxesGroup,
                            gridGroup: this._gridGroup,
                            isArgumentAxis: isArgumentAxes,
                            getTemplate: template => this._getTemplate(template)
                        }, this._getAxisRenderingOptions(typeSelector));
                        const axis = new _base_axis.Axis(renderingSettings);
                        axis.updateOptions(options);
                        axis.isVirtual = virtual;
                        return axis
                    },
                    _applyVisualRangeByVirtualAxes: () => false,
                    _applyCustomVisualRangeOption(axis, range) {
                        if (axis.getOptions().optionPath) {
                            this._parseVisualRangeOption("".concat(axis.getOptions().optionPath, ".visualRange"), range)
                        }
                    },
                    _getVisualRangeSetter() {
                        return (axis, _ref) => {
                            let {
                                skipEventRising: skipEventRising,
                                range: range
                            } = _ref;
                            this._applyCustomVisualRangeOption(axis, range);
                            axis.setCustomVisualRange(range);
                            axis.skipEventRising = skipEventRising;
                            if (!this._applyVisualRangeByVirtualAxes(axis, range)) {
                                if (this._applyingChanges) {
                                    this._change_VISUAL_RANGE()
                                } else {
                                    this._requestChange(["VISUAL_RANGE"])
                                }
                            }
                        }
                    },
                    _getTrackerSettings() {
                        return (0, _extend2.extend)(this.callBase(), {
                            argumentAxis: this.getArgumentAxis()
                        })
                    },
                    _prepareStripsAndConstantLines(typeSelector, userOptions, rotated) {
                        userOptions = this._themeManager.getOptions(typeSelector, userOptions, rotated);
                        if (userOptions.strips) {
                            userOptions.strips.forEach((line, i) => {
                                userOptions.strips[i] = (0, _extend2.extend)(true, {}, userOptions.stripStyle, line)
                            })
                        }
                        if (userOptions.constantLines) {
                            userOptions.constantLines.forEach((line, i) => {
                                userOptions.constantLines[i] = (0, _extend2.extend)(true, {}, userOptions.constantLineStyle, line)
                            })
                        }
                        return userOptions
                    },
                    refresh() {
                        this._disposeAxes();
                        this.callBase()
                    },
                    _layoutAxes(drawAxes) {
                        drawAxes();
                        const needSpace = this.checkForMoreSpaceForPanesCanvas();
                        if (needSpace) {
                            const rect = this._rect.slice();
                            const size = this._layout.backward(rect, rect, [needSpace.width, needSpace.height]);
                            needSpace.width = Math.max(0, size[0]);
                            needSpace.height = Math.max(0, size[1]);
                            this._canvas = this._createCanvasFromRect(rect);
                            drawAxes(needSpace)
                        }
                    },
                    checkForMoreSpaceForPanesCanvas() {
                        return this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), this._isRotated())
                    },
                    _parseVisualRangeOption(fullName, value) {
                        var _a;
                        const name = fullName.split(/[.[]/)[0];
                        let index = fullName.match(/\d+/g);
                        index = (0, _type.isDefined)(index) ? parseInt(index[0], 10) : index;
                        if (fullName.indexOf("visualRange") > 0) {
                            if ("object" !== (0, _type.type)(value)) {
                                value = null !== (_a = wrapVisualRange(fullName, value)) && void 0 !== _a ? _a : value
                            }
                            this._setCustomVisualRange(name, index, value)
                        } else if (("object" === (0, _type.type)(value) || isArray(value)) && name.indexOf("Axis") > 0 && JSON.stringify(value).indexOf("visualRange") > 0) {
                            if ((0, _type.isDefined)(value.visualRange)) {
                                this._setCustomVisualRange(name, index, value.visualRange)
                            } else if (isArray(value)) {
                                value.forEach((a, i) => {
                                    if ((0, _type.isDefined)(a.visualRange)) {
                                        this._setCustomVisualRange(name, i, a.visualRange)
                                    }
                                })
                            }
                        }
                    },
                    _setCustomVisualRange(axesName, index, value) {
                        const options = this._options.silent(axesName);
                        if (!options) {
                            return
                        }
                        if (!(0, _type.isDefined)(index)) {
                            options._customVisualRange = value
                        } else {
                            options[index]._customVisualRange = value
                        }
                        this._axesReinitialized = true
                    },
                    _raiseZoomEndHandlers() {
                        this._valueAxes.forEach(axis => axis.handleZoomEnd())
                    },
                    _setOptionsByReference() {
                        this.callBase();
                        (0, _extend2.extend)(this._optionsByReference, {
                            "valueAxis.visualRange": true
                        })
                    },
                    _notifyOptionChanged(option, value) {
                        this.callBase.apply(this, arguments);
                        if (!this._optionChangedLocker) {
                            this._parseVisualRangeOption(option, value)
                        }
                    },
                    _notifyVisualRange() {
                        this._valueAxes.forEach(axis => {
                            const axisPath = axis.getOptions().optionPath;
                            if (axisPath) {
                                const path = "".concat(axisPath, ".visualRange");
                                const visualRange = (0, _utils.convertVisualRangeObject)(axis.visualRange(), !isArray(this.option(path)));
                                if (!axis.skipEventRising || !(0, _utils.rangesAreEqual)(visualRange, this.option(path))) {
                                    if (!this.option(axisPath) && "valueAxis" !== axisPath) {
                                        this.option(axisPath, {
                                            name: axis.name,
                                            visualRange: visualRange
                                        })
                                    } else {
                                        this.option(path, visualRange)
                                    }
                                } else {
                                    axis.skipEventRising = null
                                }
                            }
                        })
                    },
                    _notify() {
                        this.callBase();
                        this._axesReinitialized = false;
                        if (true !== this.option("disableTwoWayBinding")) {
                            this.skipOptionsRollBack = true;
                            this._notifyVisualRange();
                            this.skipOptionsRollBack = false
                        }
                    },
                    _getAxesForScaling() {
                        return this._valueAxes
                    },
                    _getAxesByOptionPath(arg, isDirectOption, optionName) {
                        const sourceAxes = this._getAxesForScaling();
                        let axes = [];
                        if (isDirectOption) {
                            let axisPath;
                            if (arg.fullName) {
                                axisPath = arg.fullName.slice(0, arg.fullName.indexOf("."))
                            }
                            axes = sourceAxes.filter(a => a.getOptions().optionPath === axisPath)
                        } else if ("object" === (0, _type.type)(arg.value)) {
                            axes = sourceAxes.filter(a => a.getOptions().optionPath === arg.name)
                        } else if (isArray(arg.value)) {
                            arg.value.forEach((v, index) => {
                                const axis = sourceAxes.filter(a => a.getOptions().optionPath === "".concat(arg.name, "[").concat(index, "]"))[0];
                                if ((0, _type.isDefined)(v[optionName]) && (0, _type.isDefined)(axis)) {
                                    axes[index] = axis
                                }
                            })
                        }
                        return axes
                    },
                    _optionChanged(arg) {
                        if (!this._optionChangedLocker) {
                            const optionName = "visualRange";
                            let axes;
                            const isDirectOption = arg.fullName.indexOf(optionName) > 0 ? true : this.getPartialChangeOptionsName(arg).indexOf(optionName) > -1 ? false : void 0;
                            if ((0, _type.isDefined)(isDirectOption)) {
                                axes = this._getAxesByOptionPath(arg, isDirectOption, optionName);
                                if (axes) {
                                    if (axes.length > 1 || isArray(arg.value)) {
                                        axes.forEach((a, index) => setAxisVisualRangeByOption(arg, a, isDirectOption, index))
                                    } else if (1 === axes.length) {
                                        setAxisVisualRangeByOption(arg, axes[0], isDirectOption)
                                    }
                                }
                            }
                        }
                        this.callBase(arg)
                    },
                    _change_VISUAL_RANGE() {
                        this._recreateSizeDependentObjects(false);
                        if (!this._changes.has("FULL_RENDER")) {
                            const resizePanesOnZoom = this.option("resizePanesOnZoom");
                            this._doRender({
                                force: true,
                                drawTitle: false,
                                drawLegend: false,
                                adjustAxes: null !== resizePanesOnZoom && void 0 !== resizePanesOnZoom ? resizePanesOnZoom : this.option("adjustAxesOnZoom") || false,
                                animate: false
                            });
                            this._raiseZoomEndHandlers()
                        }
                    },
                    resetVisualRange() {
                        this._valueAxes.forEach(axis => {
                            axis.resetVisualRange(false);
                            this._applyCustomVisualRangeOption(axis)
                        });
                        this._requestChange(["VISUAL_RANGE"])
                    },
                    _getCrosshairMargins: () => ({
                        x: 0,
                        y: 0
                    }),
                    _legendDataField: "series",
                    _adjustSeriesLabels: _common.noop,
                    _correctValueAxes: _common.noop
                });
                exports.AdvancedChart = AdvancedChart
            },
        14107:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/m_base_chart.js ***!
              \*********************************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.overlapping = exports.BaseChart = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _index = __webpack_require__( /*! ../../../events/utils/index */ 39611);
                var _layout_manager = __webpack_require__( /*! ../../../viz/chart_components/layout_manager */ 61189);
                var trackerModule = function(obj, nodeInterop) {
                    if (!nodeInterop && obj && obj.__esModule) {
                        return obj
                    }
                    if (null === obj || "object" !== typeof obj && "function" !== typeof obj) {
                        return {
                            default: obj
                        }
                    }
                    var cache = _getRequireWildcardCache(nodeInterop);
                    if (cache && cache.has(obj)) {
                        return cache.get(obj)
                    }
                    var newObj = {};
                    var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var key in obj) {
                        if ("default" !== key && Object.prototype.hasOwnProperty.call(obj, key)) {
                            var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
                            if (desc && (desc.get || desc.set)) {
                                Object.defineProperty(newObj, key, desc)
                            } else {
                                newObj[key] = obj[key]
                            }
                        }
                    }
                    newObj.default = obj;
                    if (cache) {
                        cache.set(obj, newObj)
                    }
                    return newObj
                }(__webpack_require__( /*! ../../../viz/chart_components/tracker */ 19957));
                var _chart_theme_manager = __webpack_require__( /*! ../../../viz/components/chart_theme_manager */ 99327);
                var _data_validator = __webpack_require__( /*! ../../../viz/components/data_validator */ 45865);
                var _legend = __webpack_require__( /*! ../../../viz/components/legend */ 16342);
                var _data_source = __webpack_require__( /*! ../../../viz/core/data_source */ 1539);
                var _export = __webpack_require__( /*! ../../../viz/core/export */ 82454);
                var _loading_indicator = __webpack_require__( /*! ../../../viz/core/loading_indicator */ 64758);
                var _title = __webpack_require__( /*! ../../../viz/core/title */ 17384);
                var _tooltip = __webpack_require__( /*! ../../../viz/core/tooltip */ 14371);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _base_series = __webpack_require__( /*! ../../../viz/series/base_series */ 54932);
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../core/m_base_widget */ 55845));
                var _rolling_stock = __webpack_require__( /*! ./rolling_stock */ 56136);

                function _getRequireWildcardCache(nodeInterop) {
                    if ("function" !== typeof WeakMap) {
                        return null
                    }
                    var cacheBabelInterop = new WeakMap;
                    var cacheNodeInterop = new WeakMap;
                    return (_getRequireWildcardCache = function(nodeInterop) {
                        return nodeInterop ? cacheNodeInterop : cacheBabelInterop
                    })(nodeInterop)
                }

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const {
                    isArray: isArray
                } = Array;
                const ACTIONS_BY_PRIORITY = ["_reinit", "_updateDataSource", "_dataInit", "_forceRender", "_resize"];

                function checkHeightRollingStock(rollingStocks, stubCanvas) {
                    const canvasSize = stubCanvas.end - stubCanvas.start;
                    let size = 0;
                    rollingStocks.forEach(rollingStock => {
                        size += rollingStock.getBoundingRect().width
                    });
                    while (canvasSize < size) {
                        size -= findAndKillSmallValue(rollingStocks)
                    }
                }

                function findAndKillSmallValue(rollingStocks) {
                    const smallestObject = rollingStocks.reduce((prev, rollingStock, index) => {
                        if (!rollingStock) {
                            return prev
                        }
                        const value = rollingStock.value();
                        return value < prev.value ? {
                            value: value,
                            rollingStock: rollingStock,
                            index: index
                        } : prev
                    }, {
                        rollingStock: void 0,
                        value: 1 / 0,
                        index: void 0
                    });
                    smallestObject.rollingStock.getLabels()[0].draw(false);
                    const {
                        width: width
                    } = smallestObject.rollingStock.getBoundingRect();
                    rollingStocks[smallestObject.index] = null;
                    return width
                }

                function checkStackOverlap(rollingStocks) {
                    let i;
                    let j;
                    let iLength;
                    let jLength;
                    let overlap = false;
                    for (i = 0, iLength = rollingStocks.length - 1; i < iLength; i++) {
                        for (j = i + 1, jLength = rollingStocks.length; j < jLength; j++) {
                            if (i !== j && checkStacksOverlapping(rollingStocks[i], rollingStocks[j], true)) {
                                overlap = true;
                                break
                            }
                        }
                        if (overlap) {
                            break
                        }
                    }
                    return overlap
                }

                function checkStacksOverlapping(firstRolling, secondRolling, inTwoSides) {
                    if (!firstRolling || !secondRolling) {
                        return
                    }
                    const firstRect = firstRolling.getBoundingRect();
                    const secondRect = secondRolling.getBoundingRect();
                    const oppositeOverlapping = inTwoSides ? firstRect.oppositeStart <= secondRect.oppositeStart && firstRect.oppositeEnd > secondRect.oppositeStart || secondRect.oppositeStart <= firstRect.oppositeStart && secondRect.oppositeEnd > firstRect.oppositeStart : true;
                    return firstRect.end > secondRect.start && oppositeOverlapping
                }

                function sortRollingStocksByValue(rollingStocks) {
                    const positiveRollingStocks = [];
                    const negativeRollingStocks = [];
                    rollingStocks.forEach(stock => {
                        if (stock.value() > 0) {
                            positiveRollingStocks.push(stock)
                        } else {
                            negativeRollingStocks.unshift(stock)
                        }
                    });
                    return positiveRollingStocks.concat(negativeRollingStocks)
                }

                function prepareOverlapStacks(rollingStocks) {
                    let root;
                    for (let i = 0; i < rollingStocks.length - 1; i += 1) {
                        const currentRollingStock = root || rollingStocks[i];
                        if (checkStacksOverlapping(currentRollingStock, rollingStocks[i + 1])) {
                            currentRollingStock.toChain(rollingStocks[i + 1]);
                            rollingStocks[i + 1] = null;
                            root = currentRollingStock
                        } else {
                            root = rollingStocks[i + 1] || currentRollingStock
                        }
                    }
                }

                function rollingStocksIsOut(rollingStock, canvas) {
                    return rollingStock.getBoundingRect().end > canvas.end
                }

                function moveRollingStock(rollingStocks, canvas) {
                    for (let i = 0; i < rollingStocks.length; i += 1) {
                        const currentRollingStock = rollingStocks[i];
                        let shouldSetCanvas = true;
                        if (null !== currentRollingStock && rollingStocksIsOut(currentRollingStock, canvas)) {
                            const currentBBox = currentRollingStock.getBoundingRect();
                            for (let j = i + 1; j < rollingStocks.length; j += 1) {
                                const nextRollingStock = rollingStocks[j];
                                if (nextRollingStock) {
                                    const nextBBox = nextRollingStock.getBoundingRect();
                                    if (nextBBox.end > currentBBox.start - (currentBBox.end - canvas.end)) {
                                        nextRollingStock.toChain(currentRollingStock);
                                        shouldSetCanvas = false;
                                        break
                                    }
                                }
                            }
                        }
                        if (shouldSetCanvas) {
                            null === currentRollingStock || void 0 === currentRollingStock ? void 0 : currentRollingStock.setRollingStockInCanvas(canvas)
                        }
                    }
                }
                const overlapping = {
                    resolveLabelOverlappingInOneDirection: function(points, canvas, isRotated, isInverted, shiftFunction) {
                        let customSorting = arguments.length > 5 && void 0 !== arguments[5] ? arguments[5] : () => 0;
                        const rollingStocks = [];
                        const stubCanvas = {
                            start: isRotated ? canvas.left : canvas.top,
                            end: isRotated ? canvas.width - canvas.right : canvas.height - canvas.bottom
                        };
                        let hasStackedSeries = false;
                        let sortRollingStocks;
                        points.forEach(p => {
                            if (!p) {
                                return
                            }
                            hasStackedSeries = hasStackedSeries || p.series.isStackedSeries() || p.series.isFullStackedSeries();
                            p.getLabels().forEach(l => {
                                if (l.isVisible()) {
                                    rollingStocks.push(new _rolling_stock.RollingStock(l, isRotated, shiftFunction))
                                }
                            })
                        });
                        if (hasStackedSeries) {
                            if (Number(!isRotated) ^ Number(isInverted)) {
                                rollingStocks.reverse()
                            }
                            sortRollingStocks = isInverted ? rollingStocks : sortRollingStocksByValue(rollingStocks)
                        } else {
                            const rollingStocksTmp = rollingStocks.slice();
                            sortRollingStocks = rollingStocks.sort((a, b) => customSorting(a, b) || a.getInitialPosition() - b.getInitialPosition() || rollingStocksTmp.indexOf(a) - rollingStocksTmp.indexOf(b))
                        }
                        if (!checkStackOverlap(sortRollingStocks)) {
                            return false
                        }
                        checkHeightRollingStock(sortRollingStocks, stubCanvas);
                        prepareOverlapStacks(sortRollingStocks);
                        sortRollingStocks.reverse();
                        moveRollingStock(sortRollingStocks, stubCanvas);
                        return true
                    }
                };
                exports.overlapping = overlapping;
                const BaseChart = _m_base_widget.default.inherit({
                    _eventsMap: {
                        onSeriesClick: {
                            name: "seriesClick"
                        },
                        onPointClick: {
                            name: "pointClick"
                        },
                        onArgumentAxisClick: {
                            name: "argumentAxisClick"
                        },
                        onLegendClick: {
                            name: "legendClick"
                        },
                        onSeriesSelectionChanged: {
                            name: "seriesSelectionChanged"
                        },
                        onPointSelectionChanged: {
                            name: "pointSelectionChanged"
                        },
                        onSeriesHoverChanged: {
                            name: "seriesHoverChanged"
                        },
                        onPointHoverChanged: {
                            name: "pointHoverChanged"
                        },
                        onDone: {
                            name: "done",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        },
                        onZoomStart: {
                            name: "zoomStart"
                        },
                        onZoomEnd: {
                            name: "zoomEnd"
                        }
                    },
                    _fontFields: ["legend.".concat("font"), "legend.title.".concat("font"), "legend.title.subtitle.".concat("font"), "commonSeriesSettings.label.".concat("font")],
                    _rootClassPrefix: "dxc",
                    _rootClass: "dxc-chart",
                    _initialChanges: ["INIT"],
                    _themeDependentChanges: ["REFRESH_SERIES_REINIT"],
                    _getThemeManagerOptions() {
                        const themeOptions = this.callBase.apply(this, arguments);
                        themeOptions.options = this.option();
                        return themeOptions
                    },
                    _createThemeManager() {
                        const chartOption = this.option();
                        const themeManager = new _chart_theme_manager.ThemeManager(this._getThemeManagerOptions());
                        themeManager.setTheme(chartOption.theme, chartOption.rtlEnabled);
                        return themeManager
                    },
                    _initCore() {
                        this._canvasClipRect = this._renderer.clipRect();
                        this._createHtmlStructure();
                        this._createLegend();
                        this._createTracker();
                        this._needHandleRenderComplete = true;
                        this.layoutManager = new _layout_manager.LayoutManager;
                        this._createScrollBar();
                        _events_engine.default.on(this._$element, "contextmenu", event => {
                            if ((0, _index.isTouchEvent)(event) || (0, _index.isPointerEvent)(event)) {
                                event.preventDefault()
                            }
                        });
                        _events_engine.default.on(this._$element, "MSHoldVisual", event => {
                            event.preventDefault()
                        })
                    },
                    _getLayoutItems: _common.noop,
                    _layoutManagerOptions() {
                        return this._themeManager.getOptions("adaptiveLayout")
                    },
                    _reinit() {
                        (0, _utils.setCanvasValues)(this._canvas);
                        this._reinitAxes();
                        this._requestChange(["DATA_SOURCE", "DATA_INIT", "CORRECT_AXIS", "FULL_RENDER"])
                    },
                    _correctAxes: _common.noop,
                    _createHtmlStructure() {
                        const renderer = this._renderer;
                        const {
                            root: root
                        } = renderer;
                        const createConstantLinesGroup = function() {
                            return renderer.g().attr({
                                class: "dxc-constant-lines-group"
                            }).linkOn(root, "constant-lines")
                        };
                        this._constantLinesGroup = {
                            dispose() {
                                this.under.dispose();
                                this.above.dispose()
                            },
                            linkOff() {
                                this.under.linkOff();
                                this.above.linkOff()
                            },
                            clear() {
                                this.under.linkRemove().clear();
                                this.above.linkRemove().clear()
                            },
                            linkAppend() {
                                this.under.linkAppend();
                                this.above.linkAppend()
                            }
                        };
                        this._labelsAxesGroup = renderer.g().attr({
                            class: "dxc-elements-axes-group"
                        });
                        const appendLabelsAxesGroup = () => {
                            this._labelsAxesGroup.linkOn(root, "elements")
                        };
                        this._backgroundRect = renderer.rect().attr({
                            fill: "gray",
                            opacity: 1e-4
                        }).append(root);
                        this._panesBackgroundGroup = renderer.g().attr({
                            class: "dxc-background"
                        }).append(root);
                        this._stripsGroup = renderer.g().attr({
                            class: "dxc-strips-group"
                        }).linkOn(root, "strips");
                        this._gridGroup = renderer.g().attr({
                            class: "dxc-grids-group"
                        }).linkOn(root, "grids");
                        this._panesBorderGroup = renderer.g().attr({
                            class: "dxc-border"
                        }).linkOn(root, "border");
                        this._axesGroup = renderer.g().attr({
                            class: "dxc-axes-group"
                        }).linkOn(root, "axes");
                        this._executeAppendBeforeSeries(appendLabelsAxesGroup);
                        this._stripLabelAxesGroup = renderer.g().attr({
                            class: "dxc-strips-labels-group"
                        }).linkOn(root, "strips-labels");
                        this._constantLinesGroup.under = createConstantLinesGroup();
                        this._seriesGroup = renderer.g().attr({
                            class: "dxc-series-group"
                        }).linkOn(root, "series");
                        this._executeAppendAfterSeries(appendLabelsAxesGroup);
                        this._constantLinesGroup.above = createConstantLinesGroup();
                        this._scaleBreaksGroup = renderer.g().attr({
                            class: "dxc-scale-breaks"
                        }).linkOn(root, "scale-breaks");
                        this._labelsGroup = renderer.g().attr({
                            class: "dxc-labels-group"
                        }).linkOn(root, "labels");
                        this._crosshairCursorGroup = renderer.g().attr({
                            class: "dxc-crosshair-cursor"
                        }).linkOn(root, "crosshair");
                        this._legendGroup = renderer.g().attr({
                            class: "dxc-legend",
                            "clip-path": this._getCanvasClipRectID()
                        }).linkOn(root, "legend").linkAppend(root).enableLinks();
                        this._scrollBarGroup = renderer.g().attr({
                            class: "dxc-scroll-bar"
                        }).linkOn(root, "scroll-bar")
                    },
                    _executeAppendBeforeSeries() {},
                    _executeAppendAfterSeries() {},
                    _disposeObjectsInArray(propName, fieldNames) {
                        (this[propName] || []).forEach(item => {
                            if (fieldNames && item) {
                                fieldNames.forEach(field => {
                                    var _a;
                                    null === (_a = item[field]) || void 0 === _a ? void 0 : _a.dispose()
                                })
                            } else {
                                null === item || void 0 === item ? void 0 : item.dispose()
                            }
                        });
                        this[propName] = null
                    },
                    _disposeCore() {
                        const disposeObject = propName => {
                            if (this[propName]) {
                                this[propName].dispose();
                                this[propName] = null
                            }
                        };
                        const unlinkGroup = name => {
                            this[name].linkOff()
                        };
                        const disposeObjectsInArray = this._disposeObjectsInArray;
                        this._renderer.stopAllAnimations();
                        disposeObjectsInArray.call(this, "series");
                        disposeObject("_tracker");
                        disposeObject("_crosshair");
                        this.layoutManager = this._userOptions = this._canvas = this._groupsData = null;
                        unlinkGroup("_stripsGroup");
                        unlinkGroup("_gridGroup");
                        unlinkGroup("_axesGroup");
                        unlinkGroup("_constantLinesGroup");
                        unlinkGroup("_stripLabelAxesGroup");
                        unlinkGroup("_panesBorderGroup");
                        unlinkGroup("_seriesGroup");
                        unlinkGroup("_labelsGroup");
                        unlinkGroup("_crosshairCursorGroup");
                        unlinkGroup("_legendGroup");
                        unlinkGroup("_scrollBarGroup");
                        unlinkGroup("_scaleBreaksGroup");
                        disposeObject("_canvasClipRect");
                        disposeObject("_panesBackgroundGroup");
                        disposeObject("_backgroundRect");
                        disposeObject("_stripsGroup");
                        disposeObject("_gridGroup");
                        disposeObject("_axesGroup");
                        disposeObject("_constantLinesGroup");
                        disposeObject("_stripLabelAxesGroup");
                        disposeObject("_panesBorderGroup");
                        disposeObject("_seriesGroup");
                        disposeObject("_labelsGroup");
                        disposeObject("_crosshairCursorGroup");
                        disposeObject("_legendGroup");
                        disposeObject("_scrollBarGroup");
                        disposeObject("_scaleBreaksGroup")
                    },
                    _getAnimationOptions() {
                        return this._themeManager.getOptions("animation")
                    },
                    _getDefaultSize: () => ({
                        width: 400,
                        height: 400
                    }),
                    _getOption(name) {
                        return this._themeManager.getOptions(name)
                    },
                    _applySize(rect) {
                        this._rect = rect.slice();
                        if (!this._changes.has("FULL_RENDER")) {
                            this._processRefreshData("_resize")
                        }
                    },
                    _resize() {
                        this._doRender(this.__renderOptions || {
                            animate: false,
                            isResize: true
                        })
                    },
                    _trackerType: "ChartTracker",
                    _createTracker() {
                        this._tracker = new trackerModule[this._trackerType]({
                            seriesGroup: this._seriesGroup,
                            renderer: this._renderer,
                            tooltip: this._tooltip,
                            legend: this._legend,
                            eventTrigger: this._eventTrigger
                        })
                    },
                    _getTrackerSettings() {
                        return (0, _extend.extend)({
                            chart: this
                        }, this._getSelectionModes())
                    },
                    _getSelectionModes() {
                        const themeManager = this._themeManager;
                        return {
                            seriesSelectionMode: themeManager.getOptions("seriesSelectionMode"),
                            pointSelectionMode: themeManager.getOptions("pointSelectionMode")
                        }
                    },
                    _updateTracker(trackerCanvases) {
                        this._tracker.update(this._getTrackerSettings());
                        this._tracker.setCanvases({
                            left: 0,
                            right: this._canvas.width,
                            top: 0,
                            bottom: this._canvas.height
                        }, trackerCanvases)
                    },
                    _createCanvasFromRect(rect) {
                        const currentCanvas = this._canvas;
                        return (0, _utils.setCanvasValues)({
                            left: rect[0],
                            top: rect[1],
                            right: currentCanvas.width - rect[2],
                            bottom: currentCanvas.height - rect[3],
                            width: currentCanvas.width,
                            height: currentCanvas.height
                        })
                    },
                    _doRender(_options) {
                        if (0 === this._canvas.width && 0 === this._canvas.height) {
                            return
                        }
                        this._resetIsReady();
                        const drawOptions = this._prepareDrawOptions(_options);
                        const {
                            recreateCanvas: recreateCanvas
                        } = drawOptions;
                        this._preserveOriginalCanvas();
                        if (recreateCanvas) {
                            this.__currentCanvas = this._canvas
                        } else {
                            this._canvas = this.__currentCanvas
                        }
                        recreateCanvas && this._updateCanvasClipRect(this._canvas);
                        this._canvas = this._createCanvasFromRect(this._rect);
                        this._renderer.stopAllAnimations(true);
                        this._cleanGroups();
                        const startTime = new Date;
                        this._renderElements(drawOptions);
                        this._lastRenderingTime = Number(new Date) - Number(startTime)
                    },
                    _preserveOriginalCanvas() {
                        this.__originalCanvas = this._canvas;
                        this._canvas = (0, _extend.extend)({}, this._canvas)
                    },
                    _layoutAxes: _common.noop,
                    _renderElements(drawOptions) {
                        const preparedOptions = this._prepareToRender(drawOptions);
                        const isRotated = this._isRotated();
                        const isLegendInside = this._isLegendInside();
                        const trackerCanvases = [];
                        (0, _extend.extend)({}, this._canvas);
                        let argBusinessRange;
                        let zoomMinArg;
                        let zoomMaxArg;
                        this._renderer.lock();
                        if (drawOptions.drawLegend && this._legend) {
                            this._legendGroup.linkAppend()
                        }
                        this.layoutManager.setOptions(this._layoutManagerOptions());
                        const layoutTargets = this._getLayoutTargets();
                        this._layoutAxes(needSpace => {
                            const axisDrawOptions = needSpace ? (0, _extend.extend)({}, drawOptions, {
                                animate: false,
                                recreateCanvas: true
                            }) : drawOptions;
                            const canvas = this._renderAxes(axisDrawOptions, preparedOptions);
                            this._shrinkAxes(needSpace, canvas)
                        });
                        this._applyClipRects(preparedOptions);
                        this._appendSeriesGroups();
                        this._createCrosshairCursor();
                        layoutTargets.forEach(_ref => {
                            let {
                                canvas: canvas
                            } = _ref;
                            trackerCanvases.push({
                                left: canvas.left,
                                right: canvas.width - canvas.right,
                                top: canvas.top,
                                bottom: canvas.height - canvas.bottom
                            })
                        });
                        if (this._scrollBar) {
                            argBusinessRange = this._argumentAxes[0].getTranslator().getBusinessRange();
                            if ("discrete" === argBusinessRange.axisType && argBusinessRange.categories && argBusinessRange.categories.length <= 1 || "discrete" !== argBusinessRange.axisType && argBusinessRange.min === argBusinessRange.max) {
                                zoomMinArg = zoomMaxArg = void 0
                            } else {
                                zoomMinArg = argBusinessRange.minVisible;
                                zoomMaxArg = argBusinessRange.maxVisible
                            }
                            this._scrollBar.init(argBusinessRange, !this._argumentAxes[0].getOptions().valueMarginsEnabled).setPosition(zoomMinArg, zoomMaxArg)
                        }
                        this._updateTracker(trackerCanvases);
                        this._updateLegendPosition(drawOptions, isLegendInside);
                        this._applyPointMarkersAutoHiding();
                        this._renderSeries(drawOptions, isRotated, isLegendInside);
                        this._renderGraphicObjects();
                        this._renderer.unlock()
                    },
                    _updateLegendPosition: _common.noop,
                    _createCrosshairCursor: _common.noop,
                    _appendSeriesGroups() {
                        this._seriesGroup.linkAppend();
                        this._labelsGroup.linkAppend();
                        this._appendAdditionalSeriesGroups()
                    },
                    _renderSeries(drawOptions, isRotated, isLegendInside) {
                        this._calculateSeriesLayout(drawOptions, isRotated);
                        this._renderSeriesElements(drawOptions, isLegendInside)
                    },
                    _calculateSeriesLayout(drawOptions, isRotated) {
                        drawOptions.hideLayoutLabels = this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), isRotated) && !this._themeManager.getOptions("adaptiveLayout").keepLabels;
                        this._updateSeriesDimensions(drawOptions)
                    },
                    _getArgFilter: () => () => true,
                    _getValFilter: () => () => true,
                    _getPointsToAnimation(series) {
                        const argViewPortFilter = this._getArgFilter();
                        return series.map(s => {
                            const valViewPortFilter = this._getValFilter(s);
                            return s.getPoints().filter(p => p.getOptions().visible && argViewPortFilter(p.argument) && (valViewPortFilter(p.getMinValue(true)) || valViewPortFilter(p.getMaxValue(true)))).length
                        })
                    },
                    _renderSeriesElements(drawOptions, isLegendInside) {
                        const {
                            series: series
                        } = this;
                        const resolveLabelOverlapping = this._themeManager.getOptions("resolveLabelOverlapping");
                        const pointsToAnimation = this._getPointsToAnimation(series);
                        series.forEach((singleSeries, index) => {
                            this._applyExtraSettings(singleSeries, drawOptions);
                            const animationEnabled = drawOptions.animate && pointsToAnimation[index] <= drawOptions.animationPointsLimit && this._renderer.animationEnabled();
                            singleSeries.draw(animationEnabled, drawOptions.hideLayoutLabels, this._getLegendCallBack(singleSeries))
                        });
                        if ("none" === resolveLabelOverlapping) {
                            this._adjustSeriesLabels(false)
                        } else {
                            this._locateLabels(resolveLabelOverlapping)
                        }
                        this._renderTrackers(isLegendInside);
                        this._tracker.repairTooltip();
                        this._renderExtraElements();
                        this._clearCanvas();
                        this._seriesElementsDrawn = true
                    },
                    _changesApplied() {
                        if (this._seriesElementsDrawn) {
                            this._seriesElementsDrawn = false;
                            this._drawn();
                            this._renderCompleteHandler()
                        }
                    },
                    _locateLabels(resolveLabelOverlapping) {
                        this._resolveLabelOverlapping(resolveLabelOverlapping)
                    },
                    _renderExtraElements() {},
                    _clearCanvas() {
                        this._canvas = this.__originalCanvas
                    },
                    _resolveLabelOverlapping(resolveLabelOverlapping) {
                        let func;
                        switch (resolveLabelOverlapping) {
                            case "stack":
                                func = this._resolveLabelOverlappingStack;
                                break;
                            case "hide":
                                func = this._resolveLabelOverlappingHide;
                                break;
                            case "shift":
                                func = this._resolveLabelOverlappingShift
                        }
                        return (0, _type.isFunction)(func) && func.call(this)
                    },
                    _getVisibleSeries() {
                        return (0, _common.grep)(this.getAllSeries(), series => series.isVisible())
                    },
                    _resolveLabelOverlappingHide() {
                        const labels = [];
                        let currentLabel;
                        let nextLabel;
                        let currentLabelRect;
                        let nextLabelRect;
                        let i;
                        let j;
                        let points;
                        const series = this._getVisibleSeries();
                        for (i = 0; i < series.length; i++) {
                            points = series[i].getVisiblePoints();
                            for (j = 0; j < points.length; j++) {
                                labels.push.apply(labels, points[j].getLabels())
                            }
                        }
                        for (i = 0; i < labels.length; i++) {
                            currentLabel = labels[i];
                            if (!currentLabel.isVisible()) {
                                continue
                            }
                            currentLabelRect = currentLabel.getBoundingRect();
                            for (j = i + 1; j < labels.length; j++) {
                                nextLabel = labels[j];
                                nextLabelRect = nextLabel.getBoundingRect();
                                if (firstRect = currentLabelRect, secondRect = nextLabelRect, (firstRect.x <= secondRect.x && secondRect.x <= firstRect.x + firstRect.width || firstRect.x >= secondRect.x && firstRect.x <= secondRect.x + secondRect.width) && (firstRect.y <= secondRect.y && secondRect.y <= firstRect.y + firstRect.height || firstRect.y >= secondRect.y && firstRect.y <= secondRect.y + secondRect.height)) {
                                    nextLabel.draw(false)
                                }
                            }
                        }
                        var firstRect, secondRect
                    },
                    _cleanGroups() {
                        this._stripsGroup.linkRemove().clear();
                        this._gridGroup.linkRemove().clear();
                        this._axesGroup.linkRemove().clear();
                        this._constantLinesGroup.clear();
                        this._stripLabelAxesGroup.linkRemove().clear();
                        this._labelsGroup.linkRemove().clear();
                        this._crosshairCursorGroup.linkRemove().clear();
                        this._scaleBreaksGroup.linkRemove().clear()
                    },
                    _allowLegendInsidePosition: () => false,
                    _createLegend() {
                        const legendSettings = function(legendDataField) {
                            const formatObjectFields = (name = legendDataField, {
                                nameField: "".concat(name, "Name"),
                                colorField: "".concat(name, "Color"),
                                indexField: "".concat(name, "Index")
                            });
                            var name;
                            return {
                                getFormatObject(data) {
                                    const res = {};
                                    res[formatObjectFields.indexField] = data.id;
                                    res[formatObjectFields.colorField] = data.states.normal.fill;
                                    res[formatObjectFields.nameField] = data.text;
                                    return res
                                },
                                textField: formatObjectFields.nameField
                            }
                        }(this._legendDataField);
                        this._legend = new _legend.Legend({
                            renderer: this._renderer,
                            widget: this,
                            group: this._legendGroup,
                            backgroundClass: "dxc-border",
                            itemGroupClass: "dxc-item",
                            titleGroupClass: "dxc-title",
                            textField: legendSettings.textField,
                            getFormatObject: legendSettings.getFormatObject,
                            allowInsidePosition: this._allowLegendInsidePosition()
                        });
                        this._updateLegend();
                        this._layout.add(this._legend)
                    },
                    _updateLegend() {
                        const themeManager = this._themeManager;
                        const legendOptions = themeManager.getOptions("legend");
                        const legendData = this._getLegendData();
                        legendOptions.containerBackgroundColor = themeManager.getOptions("containerBackgroundColor");
                        legendOptions._incidentOccurred = this._incidentOccurred;
                        this._legend.update(legendData, legendOptions, themeManager.theme("legend").title);
                        this._change(["LAYOUT"])
                    },
                    _prepareDrawOptions(drawOptions) {
                        const animationOptions = this._getAnimationOptions();
                        const options = (0, _extend.extend)({}, {
                            force: false,
                            adjustAxes: true,
                            drawLegend: true,
                            drawTitle: true,
                            animate: animationOptions.enabled,
                            animationPointsLimit: animationOptions.maxPointCountSupported
                        }, drawOptions, this.__renderOptions);
                        if (!(0, _type.isDefined)(options.recreateCanvas)) {
                            options.recreateCanvas = options.adjustAxes && options.drawLegend && options.drawTitle
                        }
                        return options
                    },
                    _processRefreshData(newRefreshAction) {
                        const currentRefreshActionPosition = ACTIONS_BY_PRIORITY.indexOf(this._currentRefreshData);
                        const newRefreshActionPosition = ACTIONS_BY_PRIORITY.indexOf(newRefreshAction);
                        if (!this._currentRefreshData || currentRefreshActionPosition >= 0 && newRefreshActionPosition < currentRefreshActionPosition) {
                            this._currentRefreshData = newRefreshAction
                        }
                        this._requestChange(["REFRESH"])
                    },
                    _getLegendData() {
                        return (0, _utils.map)(this._getLegendTargets(), item => {
                            const {
                                legendData: legendData
                            } = item;
                            const style = item.getLegendStyles;
                            let {
                                opacity: opacity
                            } = style.normal;
                            if (!item.visible) {
                                if (!(0, _type.isDefined)(opacity) || opacity > .3) {
                                    opacity = .3
                                }
                                legendData.textOpacity = .3
                            }
                            const opacityStyle = {
                                opacity: opacity
                            };
                            legendData.states = {
                                hover: (0, _extend.extend)({}, style.hover, opacityStyle),
                                selection: (0, _extend.extend)({}, style.selection, opacityStyle),
                                normal: (0, _extend.extend)({}, style.normal, opacityStyle)
                            };
                            return legendData
                        })
                    },
                    _getLegendOptions(item) {
                        return {
                            legendData: {
                                text: item[this._legendItemTextField],
                                id: item.index,
                                visible: true
                            },
                            getLegendStyles: item.getLegendStyles(),
                            visible: item.isVisible()
                        }
                    },
                    _disposeSeries(seriesIndex) {
                        var _a;
                        if (this.series) {
                            if ((0, _type.isDefined)(seriesIndex)) {
                                this.series[seriesIndex].dispose();
                                this.series.splice(seriesIndex, 1)
                            } else {
                                this.series.forEach(s => s.dispose());
                                this.series.length = 0
                            }
                        }
                        if (!(null === (_a = this.series) || void 0 === _a ? void 0 : _a.length)) {
                            this.series = []
                        }
                    },
                    _disposeSeriesFamilies() {
                        (this.seriesFamilies || []).forEach(family => {
                            family.dispose()
                        });
                        this.seriesFamilies = null;
                        this._needHandleRenderComplete = true
                    },
                    _optionChanged(arg) {
                        this._themeManager.resetOptions(arg.name);
                        this.callBase.apply(this, arguments)
                    },
                    _applyChanges() {
                        this._themeManager.update(this._options.silent());
                        this.callBase(...arguments)
                    },
                    _optionChangesMap: {
                        animation: "ANIMATION",
                        dataSource: "DATA_SOURCE",
                        palette: "PALETTE",
                        paletteExtensionMode: "PALETTE",
                        legend: "FORCE_DATA_INIT",
                        seriesTemplate: "FORCE_DATA_INIT",
                        export: "FORCE_RENDER",
                        valueAxis: "AXES_AND_PANES",
                        argumentAxis: "AXES_AND_PANES",
                        commonAxisSettings: "AXES_AND_PANES",
                        panes: "AXES_AND_PANES",
                        commonPaneSettings: "AXES_AND_PANES",
                        defaultPane: "AXES_AND_PANES",
                        containerBackgroundColor: "AXES_AND_PANES",
                        rotated: "ROTATED",
                        autoHidePointMarkers: "REFRESH_SERIES_REINIT",
                        customizePoint: "REFRESH_SERIES_REINIT",
                        customizeLabel: "REFRESH_SERIES_REINIT",
                        scrollBar: "SCROLL_BAR"
                    },
                    _optionChangesOrder: ["ROTATED", "PALETTE", "REFRESH_SERIES_REINIT", "USE_SPIDER_WEB", "AXES_AND_PANES", "INIT", "REINIT", "DATA_SOURCE", "REFRESH_SERIES_DATA_INIT", "DATA_INIT", "FORCE_DATA_INIT", "REFRESH_AXES", "CORRECT_AXIS"],
                    _customChangesOrder: ["ANIMATION", "REFRESH_SERIES_FAMILIES", "FORCE_FIRST_DRAWING", "FORCE_DRAWING", "FORCE_RENDER", "VISUAL_RANGE", "SCROLL_BAR", "REINIT", "REFRESH", "FULL_RENDER"],
                    _change_ANIMATION() {
                        this._renderer.updateAnimationOptions(this._getAnimationOptions())
                    },
                    _change_DATA_SOURCE() {
                        this._needHandleRenderComplete = true;
                        this._updateDataSource()
                    },
                    _change_PALETTE() {
                        this._themeManager.updatePalette();
                        this._refreshSeries("DATA_INIT")
                    },
                    _change_REFRESH_SERIES_DATA_INIT() {
                        this._refreshSeries("DATA_INIT")
                    },
                    _change_DATA_INIT() {
                        if ((!this.series || this.needToPopulateSeries) && !this._changes.has("FORCE_DATA_INIT")) {
                            this._dataInit()
                        }
                    },
                    _change_FORCE_DATA_INIT() {
                        this._dataInit()
                    },
                    _change_REFRESH_SERIES_FAMILIES() {
                        this._processSeriesFamilies();
                        this._populateBusinessRange();
                        this._processRefreshData("_forceRender")
                    },
                    _change_FORCE_RENDER() {
                        this._processRefreshData("_forceRender")
                    },
                    _change_AXES_AND_PANES() {
                        this._refreshSeries("INIT")
                    },
                    _change_ROTATED() {
                        this._createScrollBar();
                        this._refreshSeries("INIT")
                    },
                    _change_REFRESH_SERIES_REINIT() {
                        this._refreshSeries("INIT")
                    },
                    _change_REFRESH_AXES() {
                        (0, _utils.setCanvasValues)(this._canvas);
                        this._reinitAxes();
                        this._requestChange(["CORRECT_AXIS", "FULL_RENDER"])
                    },
                    _change_SCROLL_BAR() {
                        this._createScrollBar();
                        this._processRefreshData("_forceRender")
                    },
                    _change_REINIT() {
                        this._processRefreshData("_reinit")
                    },
                    _change_FORCE_DRAWING() {
                        this._resetComponentsAnimation()
                    },
                    _change_FORCE_FIRST_DRAWING() {
                        this._resetComponentsAnimation(true)
                    },
                    _resetComponentsAnimation(isFirstDrawing) {
                        this.series.forEach(s => {
                            s.resetApplyingAnimation(isFirstDrawing)
                        });
                        this._resetAxesAnimation(isFirstDrawing)
                    },
                    _resetAxesAnimation: _common.noop,
                    _refreshSeries(actionName) {
                        this.needToPopulateSeries = true;
                        this._requestChange([actionName])
                    },
                    _change_CORRECT_AXIS() {
                        this._correctAxes()
                    },
                    _doRefresh() {
                        const methodName = this._currentRefreshData;
                        if (methodName) {
                            this._currentRefreshData = null;
                            this._renderer.stopAllAnimations(true);
                            this[methodName]()
                        }
                    },
                    _updateCanvasClipRect(canvas) {
                        const width = Math.max(canvas.width - canvas.left - canvas.right, 0);
                        const height = Math.max(canvas.height - canvas.top - canvas.bottom, 0);
                        this._canvasClipRect.attr({
                            x: canvas.left,
                            y: canvas.top,
                            width: width,
                            height: height
                        });
                        this._backgroundRect.attr({
                            x: canvas.left,
                            y: canvas.top,
                            width: width,
                            height: height
                        })
                    },
                    _getCanvasClipRectID() {
                        return this._canvasClipRect.id
                    },
                    _dataSourceChangedHandler() {
                        if (this._changes.has("INIT")) {
                            this._requestChange(["DATA_INIT"])
                        } else {
                            this._requestChange(["FORCE_DATA_INIT"])
                        }
                    },
                    _dataInit() {
                        this._dataSpecificInit(true)
                    },
                    _processSingleSeries(singleSeries) {
                        singleSeries.createPoints(false)
                    },
                    _handleSeriesDataUpdated() {
                        if (this._getVisibleSeries().some(s => s.useAggregation())) {
                            this._populateMarginOptions()
                        }
                        this.series.forEach(s => this._processSingleSeries(s), this)
                    },
                    _dataSpecificInit(needRedraw) {
                        if (!this.series || this.needToPopulateSeries) {
                            this.series = this._populateSeries()
                        }
                        this._repopulateSeries();
                        this._seriesPopulatedHandlerCore();
                        this._populateBusinessRange();
                        this._tracker.updateSeries(this.series, this._changes.has("INIT"));
                        this._updateLegend();
                        if (needRedraw) {
                            this._requestChange(["FULL_RENDER"])
                        }
                    },
                    _forceRender() {
                        this._doRender({
                            force: true
                        })
                    },
                    _repopulateSeries() {
                        const themeManager = this._themeManager;
                        const data = this._dataSourceItems();
                        const dataValidatorOptions = themeManager.getOptions("dataPrepareSettings");
                        const seriesTemplate = themeManager.getOptions("seriesTemplate");
                        if (seriesTemplate) {
                            this._populateSeries(data)
                        }
                        this._groupSeries();
                        const parsedData = (0, _data_validator.validateData)(data, this._groupsData, this._incidentOccurred, dataValidatorOptions);
                        themeManager.resetPalette();
                        this.series.forEach(singleSeries => {
                            singleSeries.updateData(parsedData[singleSeries.getArgumentField()])
                        });
                        this._handleSeriesDataUpdated()
                    },
                    _renderCompleteHandler() {
                        let allSeriesInited = true;
                        if (this._needHandleRenderComplete) {
                            this.series.forEach(s => {
                                allSeriesInited = allSeriesInited && s.canRenderCompleteHandle()
                            });
                            if (allSeriesInited) {
                                this._needHandleRenderComplete = false;
                                this._eventTrigger("done", {
                                    target: this
                                })
                            }
                        }
                    },
                    _dataIsReady() {
                        return (0, _type.isDefined)(this.option("dataSource")) && this._dataIsLoaded()
                    },
                    _populateSeriesOptions(data) {
                        const themeManager = this._themeManager;
                        const seriesTemplate = themeManager.getOptions("seriesTemplate");
                        const seriesOptions = seriesTemplate ? (0, _utils.processSeriesTemplate)(seriesTemplate, data || []) : this.option("series");
                        const allSeriesOptions = isArray(seriesOptions) ? seriesOptions : seriesOptions ? [seriesOptions] : [];
                        const extraOptions = this._getExtraOptions();
                        let particularSeriesOptions;
                        let seriesTheme;
                        const seriesThemes = [];
                        const seriesVisibilityChanged = target => {
                            this._specialProcessSeries();
                            this._populateBusinessRange(target && target.getValueAxis(), true);
                            this._renderer.stopAllAnimations(true);
                            this._updateLegend();
                            this._requestChange(["FULL_RENDER"])
                        };
                        for (let i = 0; i < allSeriesOptions.length; i++) {
                            particularSeriesOptions = (0, _extend.extend)(true, {}, allSeriesOptions[i], extraOptions);
                            if (!(0, _type.isDefined)(particularSeriesOptions.name) || "" === particularSeriesOptions.name) {
                                particularSeriesOptions.name = "Series ".concat((i + 1).toString())
                            }
                            particularSeriesOptions.rotated = this._isRotated();
                            particularSeriesOptions.customizePoint = themeManager.getOptions("customizePoint");
                            particularSeriesOptions.customizeLabel = themeManager.getOptions("customizeLabel");
                            particularSeriesOptions.visibilityChanged = seriesVisibilityChanged;
                            particularSeriesOptions.incidentOccurred = this._incidentOccurred;
                            seriesTheme = themeManager.getOptions("series", particularSeriesOptions, allSeriesOptions.length);
                            if (this._checkPaneName(seriesTheme)) {
                                seriesThemes.push(seriesTheme)
                            }
                        }
                        return seriesThemes
                    },
                    _populateSeries(data) {
                        var _a;
                        const seriesBasis = [];
                        const incidentOccurred = this._incidentOccurred;
                        const seriesThemes = this._populateSeriesOptions(data);
                        let particularSeries;
                        let disposeSeriesFamilies = false;
                        this.needToPopulateSeries = false;
                        seriesThemes.forEach(theme => {
                            var _a;
                            const curSeries = null === (_a = this.series) || void 0 === _a ? void 0 : _a.find(s => s.name === theme.name && !seriesBasis.map(sb => sb.series).includes(s));
                            if (curSeries && curSeries.type === theme.type) {
                                seriesBasis.push({
                                    series: curSeries,
                                    options: theme
                                })
                            } else {
                                seriesBasis.push({
                                    options: theme
                                });
                                disposeSeriesFamilies = true
                            }
                        });
                        0 !== (null === (_a = this.series) || void 0 === _a ? void 0 : _a.length) && this._tracker.clearHover();
                        (0, _iterator.reverseEach)(this.series, (index, series) => {
                            if (!seriesBasis.some(s => series === s.series)) {
                                this._disposeSeries(index);
                                disposeSeriesFamilies = true
                            }
                        });
                        !disposeSeriesFamilies && (disposeSeriesFamilies = seriesBasis.some(sb => sb.series.name !== seriesThemes[sb.series.index].name));
                        this.series = [];
                        disposeSeriesFamilies && this._disposeSeriesFamilies();
                        this._themeManager.resetPalette();
                        const eventPipe = data => {
                            this.series.forEach(currentSeries => {
                                currentSeries.notify(data)
                            })
                        };
                        seriesBasis.forEach(basis => {
                            var _a, _b;
                            const seriesTheme = basis.options;
                            const argumentAxis = null !== (_b = null === (_a = this._argumentAxes) || void 0 === _a ? void 0 : _a.filter(a => a.pane === seriesTheme.pane)[0]) && void 0 !== _b ? _b : this.getArgumentAxis();
                            const renderSettings = {
                                commonSeriesModes: this._getSelectionModes(),
                                argumentAxis: argumentAxis,
                                valueAxis: this._getValueAxis(seriesTheme.pane, seriesTheme.axis)
                            };
                            if (basis.series) {
                                particularSeries = basis.series;
                                particularSeries.updateOptions(seriesTheme, renderSettings)
                            } else {
                                particularSeries = new _base_series.Series((0, _extend.extend)({
                                    renderer: this._renderer,
                                    seriesGroup: this._seriesGroup,
                                    labelsGroup: this._labelsGroup,
                                    eventTrigger: this._eventTrigger,
                                    eventPipe: eventPipe,
                                    incidentOccurred: incidentOccurred
                                }, renderSettings), seriesTheme)
                            }
                            if (!particularSeries.isUpdated) {
                                incidentOccurred("E2101", [seriesTheme.type])
                            } else {
                                particularSeries.index = this.series.length;
                                this.series.push(particularSeries)
                            }
                        });
                        return this.series
                    },
                    getStackedPoints(point) {
                        const stackName = point.series.getStackName();
                        return this._getVisibleSeries().reduce((stackPoints, series) => {
                            if (!(0, _type.isDefined)(series.getStackName()) || !(0, _type.isDefined)(stackName) || stackName === series.getStackName()) {
                                stackPoints = stackPoints.concat(series.getPointsByArg(point.argument))
                            }
                            return stackPoints
                        }, [])
                    },
                    getAllSeries: function() {
                        return (this.series || []).slice()
                    },
                    getSeriesByName: function(name) {
                        const found = (this.series || []).find(singleSeries => singleSeries.name === name);
                        return found || null
                    },
                    getSeriesByPos: function(pos) {
                        return (this.series || [])[pos]
                    },
                    clearSelection: function() {
                        this._tracker.clearSelection()
                    },
                    hideTooltip() {
                        this._tracker._hideTooltip()
                    },
                    clearHover() {
                        this._tracker.clearHover()
                    },
                    render(renderOptions) {
                        this.__renderOptions = renderOptions;
                        this.__forceRender = renderOptions && renderOptions.force;
                        this.callBase.apply(this, arguments);
                        this.__renderOptions = this.__forceRender = null;
                        return this
                    },
                    refresh() {
                        this._disposeSeries();
                        this._disposeSeriesFamilies();
                        this._requestChange(["CONTAINER_SIZE", "REFRESH_SERIES_REINIT"])
                    },
                    _getMinSize() {
                        const adaptiveLayout = this._layoutManagerOptions();
                        return [adaptiveLayout.width, adaptiveLayout.height]
                    },
                    _change_REFRESH() {
                        if (!this._changes.has("INIT")) {
                            this._doRefresh()
                        } else {
                            this._currentRefreshData = null
                        }
                    },
                    _change_FULL_RENDER() {
                        this._forceRender()
                    },
                    _change_INIT() {
                        this._reinit()
                    },
                    _stopCurrentHandling() {
                        if (this._disposed) {
                            return
                        }
                        this._tracker.stopCurrentHandling()
                    }
                });
                exports.BaseChart = BaseChart;
                ["series", "commonSeriesSettings", "dataPrepareSettings", "seriesSelectionMode", "pointSelectionMode", "synchronizeMultiAxes", "resolveLabelsOverlapping"].forEach(name => {
                    BaseChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_DATA_INIT"
                });
                ["adaptiveLayout", "crosshair", "resolveLabelOverlapping", "adjustOnZoom", "stickyHovering"].forEach(name => {
                    BaseChart.prototype._optionChangesMap[name] = "FORCE_RENDER"
                });
                ["minBubbleSize", "maxBubbleSize", "barGroupPadding", "barGroupWidth", "negativesAsZeroes", "negativesAsZeros"].forEach(name => {
                    BaseChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_FAMILIES"
                });
                BaseChart.addPlugin(_export.plugin);
                BaseChart.addPlugin(_title.plugin);
                BaseChart.addPlugin(_data_source.plugin);
                BaseChart.addPlugin(_tooltip.plugin);
                BaseChart.addPlugin(_loading_indicator.plugin);
                const {
                    _change_TITLE: _change_TITLE
                } = BaseChart.prototype;
                BaseChart.prototype._change_TITLE = function() {
                    _change_TITLE.apply(this, arguments);
                    this._change(["FORCE_RENDER"])
                }
            },
        56136:
            /*!**********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/rolling_stock.js ***!
              \**********************************************************************************************/
            function(__unused_webpack_module, exports) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.RollingStock = void 0;
                let RollingStock = function() {
                    function RollingStock(label, isRotated, shiftFunction) {
                        const bBox = label.getBoundingRect();
                        const {
                            x: x
                        } = bBox;
                        const {
                            y: y
                        } = bBox;
                        const endX = bBox.x + bBox.width;
                        const endY = bBox.y + bBox.height;
                        this.labels = [label];
                        this.shiftFunction = shiftFunction;
                        this.bBox = {
                            start: isRotated ? x : y,
                            width: isRotated ? bBox.width : bBox.height,
                            end: isRotated ? endX : endY,
                            oppositeStart: isRotated ? y : x,
                            oppositeEnd: isRotated ? endY : endX
                        };
                        this.initialPosition = isRotated ? bBox.x : bBox.y
                    }
                    var _proto = RollingStock.prototype;
                    _proto.toChain = function(nextRollingStock) {
                        const nextRollingStockBBox = nextRollingStock.getBoundingRect();
                        nextRollingStock.shift(nextRollingStockBBox.start - this.bBox.end);
                        this.changeBoxWidth(nextRollingStockBBox.width);
                        this.labels = this.labels.concat(nextRollingStock.labels)
                    };
                    _proto.getBoundingRect = function() {
                        return this.bBox
                    };
                    _proto.shift = function(shiftLength) {
                        this.labels.forEach(label => {
                            const bBox = label.getBoundingRect();
                            const coords = this.shiftFunction(bBox, shiftLength);
                            if (!label.hideInsideLabel(coords)) {
                                label.shift(coords.x, coords.y)
                            }
                        });
                        this.bBox.end -= shiftLength;
                        this.bBox.start -= shiftLength
                    };
                    _proto.setRollingStockInCanvas = function(canvas) {
                        if (this.bBox.end > canvas.end) {
                            this.shift(this.bBox.end - canvas.end)
                        }
                    };
                    _proto.getLabels = function() {
                        return this.labels
                    };
                    _proto.value = function() {
                        return this.labels[0].getData().value
                    };
                    _proto.getInitialPosition = function() {
                        return this.initialPosition
                    };
                    _proto.changeBoxWidth = function(width) {
                        this.bBox.end += width;
                        this.bBox.width += width
                    };
                    return RollingStock
                }();
                exports.RollingStock = RollingStock
            },
        55845:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/m_base_widget.js ***!
              \**********************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 20530));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_adapter */ 73349));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../../core/dom_component */ 13046));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 20576);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 62754);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 95479);
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 35922);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../events/core/events_engine */ 55994));
                var _base_theme_manager = __webpack_require__( /*! ../../../viz/core/base_theme_manager */ 43637);
                var _base_widget = __webpack_require__( /*! ../../../viz/core/base_widget.utils */ 98469);
                var _errors_warnings = _interopRequireDefault(__webpack_require__( /*! ../../../viz/core/errors_warnings */ 80726));
                var _helpers = __webpack_require__( /*! ../../../viz/core/helpers */ 3603);
                var _layout = _interopRequireDefault(__webpack_require__( /*! ../../../viz/core/layout */ 94551));
                var _renderer2 = __webpack_require__( /*! ../../../viz/core/renderers/renderer */ 56453);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 19157);
                var _utils2 = __webpack_require__( /*! ../../../viz/utils */ 34434);
                var _m_charts = _interopRequireDefault(__webpack_require__( /*! ../../common/m_charts */ 66798));

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const {
                    log: log
                } = _errors_warnings.default;
                const baseOptionMethod = _dom_component.default.prototype.option;

                function getTrue() {
                    return true
                }

                function getFalse() {
                    return false
                }

                function defaultOnIncidentOccurred(e) {
                    if (!e.component._eventsStrategy.hasEvent("incidentOccurred")) {
                        log.apply(null, [e.target.id].concat(e.target.args || []))
                    }
                }

                function pickPositiveValue(values) {
                    return values.reduce((result, value) => value > 0 && !result ? value : result, 0)
                }

                function callForEach(functions) {
                    functions.forEach(c => c())
                }
                const isServerSide = !(0, _window.hasWindow)();
                const baseWidget = isServerSide ? function() {
                    const emptyComponentConfig = {
                        _initTemplates() {},
                        ctor(element, options) {
                            this.callBase(element, options);
                            const sizedElement = _dom_adapter.default.createElement("div");
                            const width = options && (0, _type.isNumeric)(options.width) ? "".concat(options.width, "px") : "100%";
                            const height = options && (0, _type.isNumeric)(options.height) ? "".concat(options.height, "px") : "".concat(this._getDefaultSize().height, "px");
                            _dom_adapter.default.setStyle(sizedElement, "width", width);
                            _dom_adapter.default.setStyle(sizedElement, "height", height);
                            _dom_adapter.default.setClass(sizedElement, "dx-sized-element", false);
                            _dom_adapter.default.insertElement(element, sizedElement)
                        }
                    };
                    const EmptyComponent = _dom_component.default.inherit(emptyComponentConfig);
                    const originalInherit = EmptyComponent.inherit;
                    EmptyComponent.inherit = function(config) {
                        Object.keys(config).forEach(field => {
                            if ((0, _type.isFunction)(config[field]) && "_" !== field.substr(0, 1) && "option" !== field || "_dispose" === field || "_optionChanged" === field) {
                                config[field] = _common.noop
                            }
                        });
                        return originalInherit.call(this, config)
                    };
                    return EmptyComponent
                }() : _dom_component.default.inherit({
                    _eventsMap: {
                        onIncidentOccurred: {
                            name: "incidentOccurred",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        },
                        onDrawn: {
                            name: "drawn",
                            actionSettings: {
                                excludeValidators: ["disabled"]
                            }
                        }
                    },
                    _getDefaultOptions() {
                        return (0, _extend.extend)(this.callBase(), {
                            onIncidentOccurred: defaultOnIncidentOccurred
                        })
                    },
                    _useLinks: true,
                    _init() {
                        this._$element.children(".".concat("dx-sized-element")).remove();
                        this._graphicObjects = {};
                        this.callBase(...arguments);
                        this._changesLocker = 0;
                        this._optionChangedLocker = 0;
                        this._asyncFirstDrawing = true;
                        this._changes = (0, _helpers.changes)();
                        this._suspendChanges();
                        this._themeManager = this._createThemeManager();
                        this._themeManager.setCallback(() => {
                            this._requestChange(this._themeDependentChanges)
                        });
                        this._renderElementAttributes();
                        this._initRenderer();
                        const useLinks = this._useLinks;
                        if (useLinks) {
                            this._renderer.root.enableLinks().virtualLink("core").virtualLink("peripheral")
                        }
                        this._renderVisibilityChange();
                        this._attachVisibilityChangeHandlers();
                        this._toggleParentsScrollSubscription(this._isVisible());
                        this._initEventTrigger();
                        this._incidentOccurred = (0, _base_widget.createIncidentOccurred)(this.NAME, this._eventTrigger);
                        this._layout = new _layout.default;
                        if (useLinks) {
                            this._renderer.root.linkAfter("core")
                        }
                        this._initPlugins();
                        this._initCore();
                        if (useLinks) {
                            this._renderer.root.linkAfter()
                        }
                        this._change(this._initialChanges)
                    },
                    _createThemeManager() {
                        return new _base_theme_manager.BaseThemeManager(this._getThemeManagerOptions())
                    },
                    _getThemeManagerOptions() {
                        return {
                            themeSection: this._themeSection,
                            fontFields: this._fontFields
                        }
                    },
                    _initialChanges: ["LAYOUT", "RESIZE_HANDLER", "THEME", "DISABLED"],
                    _initPlugins() {
                        (0, _iterator.each)(this._plugins, (_, plugin) => {
                            plugin.init.call(this)
                        })
                    },
                    _disposePlugins() {
                        (0, _iterator.each)(this._plugins.slice().reverse(), (_, plugin) => {
                            plugin.dispose.call(this)
                        })
                    },
                    _change(codes) {
                        this._changes.add(codes)
                    },
                    _suspendChanges() {
                        this._changesLocker += 1
                    },
                    _resumeChanges() {
                        if (0 === --this._changesLocker && this._changes.count() > 0 && !this._applyingChanges) {
                            this._renderer.lock();
                            this._applyingChanges = true;
                            this._applyChanges();
                            this._changes.reset();
                            this._applyingChanges = false;
                            this._changesApplied();
                            this._renderer.unlock();
                            if (this._optionsQueue) {
                                this._applyQueuedOptions()
                            }
                            this.resolveItemsDeferred(this._legend ? [this._legend] : []);
                            this._optionChangedLocker += 1;
                            this._notify();
                            this._optionChangedLocker -= 1
                        }
                    },
                    resolveItemsDeferred(items) {
                        this._resolveDeferred(this._getTemplatesItems(items))
                    },
                    _collectTemplatesFromItems: items => items.reduce((prev, i) => ({
                        items: prev.items.concat(i.getTemplatesDef()),
                        groups: prev.groups.concat(i.getTemplatesGroups())
                    }), {
                        items: [],
                        groups: []
                    }),
                    _getTemplatesItems(items) {
                        const elements = this._collectTemplatesFromItems(items);
                        const extraItems = this._getExtraTemplatesItems();
                        return {
                            items: extraItems.items.concat(elements.items),
                            groups: extraItems.groups.concat(elements.groups),
                            launchRequest: [extraItems.launchRequest],
                            doneRequest: [extraItems.doneRequest]
                        }
                    },
                    _getExtraTemplatesItems: () => ({
                        items: [],
                        groups: [],
                        launchRequest: () => {},
                        doneRequest: () => {}
                    }),
                    _resolveDeferred(_ref) {
                        let {
                            items: items,
                            launchRequest: launchRequest,
                            doneRequest: doneRequest,
                            groups: groups
                        } = _ref;
                        this._setGroupsVisibility(groups, "hidden");
                        if (this._changesApplying) {
                            this._changesApplying = false;
                            callForEach(doneRequest);
                            return
                        }
                        let syncRendering = true;
                        _deferred.when.apply(this, items).done(() => {
                            if (syncRendering) {
                                this._setGroupsVisibility(groups, "visible");
                                return
                            }
                            callForEach(launchRequest);
                            this._changesApplying = true;
                            const changes = ["LAYOUT", "FULL_RENDER"];
                            if (this._asyncFirstDrawing) {
                                changes.push("FORCE_FIRST_DRAWING");
                                this._asyncFirstDrawing = false
                            } else {
                                changes.push("FORCE_DRAWING")
                            }
                            this._requestChange(changes);
                            this._setGroupsVisibility(groups, "visible")
                        });
                        syncRendering = false
                    },
                    _setGroupsVisibility(groups, visibility) {
                        groups.forEach(g => g.attr({
                            visibility: visibility
                        }))
                    },
                    _applyQueuedOptions() {
                        const queue = this._optionsQueue;
                        this._optionsQueue = null;
                        this.beginUpdate();
                        (0, _iterator.each)(queue, (_, action) => {
                            action()
                        });
                        this.endUpdate()
                    },
                    _requestChange(codes) {
                        this._suspendChanges();
                        this._change(codes);
                        this._resumeChanges()
                    },
                    _applyChanges() {
                        const changes = this._changes;
                        const order = this._totalChangesOrder;
                        const changesOrderLength = order.length;
                        for (let i = 0; i < changesOrderLength; i += 1) {
                            if (changes.has(order[i])) {
                                this["_change_".concat(order[i])]()
                            }
                        }
                    },
                    _optionChangesOrder: ["EVENTS", "THEME", "RENDERER", "RESIZE_HANDLER"],
                    _layoutChangesOrder: ["ELEMENT_ATTR", "CONTAINER_SIZE", "LAYOUT"],
                    _customChangesOrder: ["DISABLED"],
                    _change_EVENTS() {
                        this._eventTrigger.applyChanges()
                    },
                    _change_THEME() {
                        this._setThemeAndRtl()
                    },
                    _change_RENDERER() {
                        this._setRendererOptions()
                    },
                    _change_RESIZE_HANDLER() {
                        this._setupResizeHandler()
                    },
                    _change_ELEMENT_ATTR() {
                        this._renderElementAttributes();
                        this._change(["CONTAINER_SIZE"])
                    },
                    _change_CONTAINER_SIZE() {
                        this._updateSize()
                    },
                    _change_LAYOUT() {
                        this._setContentSize()
                    },
                    _change_DISABLED() {
                        const renderer = this._renderer;
                        const {
                            root: root
                        } = renderer;
                        if (this.option("disabled")) {
                            this._initDisabledState = root.attr("pointer-events");
                            root.attr({
                                "pointer-events": "none",
                                filter: renderer.getGrayScaleFilter().id
                            })
                        } else if ("none" === root.attr("pointer-events")) {
                            root.attr({
                                "pointer-events": (0, _type.isDefined)(this._initDisabledState) ? this._initDisabledState : null,
                                filter: null
                            })
                        }
                    },
                    _themeDependentChanges: ["RENDERER"],
                    _initRenderer() {
                        const rawCanvas = this._calculateRawCanvas();
                        this._canvas = (0, _utils2.floorCanvasDimensions)(rawCanvas);
                        this._renderer = new _renderer2.Renderer({
                            cssClass: "".concat(this._rootClassPrefix, " ").concat(this._rootClass),
                            pathModified: this.option("pathModified"),
                            container: this._$element[0]
                        });
                        this._renderer.resize(this._canvas.width, this._canvas.height)
                    },
                    _disposeRenderer() {
                        this._renderer.dispose()
                    },
                    _disposeGraphicObjects() {
                        Object.keys(this._graphicObjects).forEach(id => {
                            this._graphicObjects[id].dispose()
                        });
                        this._graphicObjects = null
                    },
                    _getAnimationOptions: _common.noop,
                    render() {
                        this._requestChange(["CONTAINER_SIZE"]);
                        const visible = this._isVisible();
                        this._toggleParentsScrollSubscription(visible);
                        !visible && this._stopCurrentHandling()
                    },
                    _toggleParentsScrollSubscription(subscribe) {
                        let $parents = (0, _renderer.default)(this._renderer.root.element).parents();
                        if ("generic" === _devices.default.real().platform) {
                            $parents = $parents.add((0, _window.getWindow)())
                        }
                        this._proxiedTargetParentsScrollHandler = this._proxiedTargetParentsScrollHandler || function() {
                            this._stopCurrentHandling()
                        }.bind(this);
                        _events_engine.default.off((0, _renderer.default)("").add(this._$prevRootParents), "scroll.viz_widgets", this._proxiedTargetParentsScrollHandler);
                        if (subscribe) {
                            _events_engine.default.on($parents, "scroll.viz_widgets", this._proxiedTargetParentsScrollHandler);
                            this._$prevRootParents = $parents
                        }
                    },
                    _stopCurrentHandling: _common.noop,
                    _dispose() {
                        if (this._disposed) {
                            return
                        }
                        this.callBase(...arguments);
                        this._toggleParentsScrollSubscription(false);
                        this._removeResizeHandler();
                        this._layout.dispose();
                        this._eventTrigger.dispose();
                        this._disposeCore();
                        this._disposePlugins();
                        this._disposeGraphicObjects();
                        this._disposeRenderer();
                        this._themeManager.dispose();
                        this._themeManager = null;
                        this._renderer = null;
                        this._eventTrigger = null
                    },
                    _initEventTrigger() {
                        this._eventTrigger = (0, _base_widget.createEventTrigger)(this._eventsMap, (name, actionSettings) => this._createActionByOption(name, actionSettings))
                    },
                    _calculateRawCanvas() {
                        const size = this.option("size") || {};
                        const margin = this.option("margin") || {};
                        const defaultCanvas = this._getDefaultSize() || {};
                        const getSizeOfSide = (size, side, getter) => {
                            if ((value = size[side], (0, _type.isDefined)(value) && value > 0) || !(0, _window.hasWindow)()) {
                                return 0
                            }
                            var value;
                            const elementSize = getter(this._$element);
                            return elementSize <= 1 ? 0 : elementSize
                        };
                        const elementWidth = getSizeOfSide(size, "width", x => (0, _size.getWidth)(x));
                        const elementHeight = getSizeOfSide(size, "height", x => (0, _size.getHeight)(x));
                        let canvas = {
                            width: size.width <= 0 ? 0 : pickPositiveValue([size.width, elementWidth, defaultCanvas.width]),
                            height: size.height <= 0 ? 0 : pickPositiveValue([size.height, elementHeight, defaultCanvas.height]),
                            left: pickPositiveValue([margin.left, defaultCanvas.left]),
                            top: pickPositiveValue([margin.top, defaultCanvas.top]),
                            right: pickPositiveValue([margin.right, defaultCanvas.right]),
                            bottom: pickPositiveValue([margin.bottom, defaultCanvas.bottom])
                        };
                        if (canvas.width - canvas.left - canvas.right <= 0 || canvas.height - canvas.top - canvas.bottom <= 0) {
                            canvas = {
                                width: 0,
                                height: 0
                            }
                        }
                        return canvas
                    },
                    _updateSize() {
                        const rawCanvas = this._calculateRawCanvas();
                        if ((0, _utils2.areCanvasesDifferent)(this._canvas, rawCanvas) || this.__forceRender) {
                            this._canvas = (0, _utils2.floorCanvasDimensions)(rawCanvas);
                            this._recreateSizeDependentObjects(true);
                            this._renderer.resize(this._canvas.width, this._canvas.height);
                            this._change(["LAYOUT"])
                        }
                    },
                    _recreateSizeDependentObjects: _common.noop,
                    _getMinSize: () => [0, 0],
                    _getAlignmentRect: _common.noop,
                    _setContentSize() {
                        const canvas = this._canvas;
                        const layout = this._layout;
                        let rect = canvas.width > 0 && canvas.height > 0 ? [canvas.left, canvas.top, canvas.width - canvas.right, canvas.height - canvas.bottom] : [0, 0, 0, 0];
                        rect = layout.forward(rect, this._getMinSize());
                        const nextRect = this._applySize(rect) || rect;
                        layout.backward(nextRect, this._getAlignmentRect() || nextRect)
                    },
                    _getOption(name, isScalar) {
                        const theme = this._themeManager.theme(name);
                        const option = this.option(name);
                        return isScalar ? void 0 !== option ? option : theme : (0, _extend.extend)(true, {}, theme, option)
                    },
                    _setupResizeHandler() {
                        const redrawOnResize = (0, _utils.parseScalar)(this._getOption("redrawOnResize", true), true);
                        if (this._disposeResizeHandler) {
                            this._removeResizeHandler()
                        }
                        this._disposeResizeHandler = (0, _base_widget.createResizeHandler)(this._$element[0], redrawOnResize, () => this._requestChange(["CONTAINER_SIZE"]))
                    },
                    _removeResizeHandler() {
                        if (this._disposeResizeHandler) {
                            this._disposeResizeHandler();
                            this._disposeResizeHandler = null
                        }
                    },
                    _onBeginUpdate: _common.noop,
                    beginUpdate() {
                        if (this._initialized && this._isUpdateAllowed()) {
                            this._onBeginUpdate();
                            this._suspendChanges()
                        }
                        this.callBase(...arguments);
                        return this
                    },
                    endUpdate() {
                        this.callBase();
                        this._isUpdateAllowed() && this._resumeChanges();
                        return this
                    },
                    option(name) {
                        if (this._initialized && this._applyingChanges && (arguments.length > 1 || (0, _type.isObject)(name))) {
                            this._optionsQueue = this._optionsQueue || [];
                            this._optionsQueue.push(this._getActionForUpdating(arguments))
                        } else {
                            return baseOptionMethod.apply(this, arguments)
                        }
                    },
                    _getActionForUpdating(args) {
                        return () => {
                            baseOptionMethod.apply(this, args)
                        }
                    },
                    _clean: _common.noop,
                    _render: _common.noop,
                    _optionChanged(arg) {
                        if (this._optionChangedLocker) {
                            return
                        }
                        const partialChanges = this.getPartialChangeOptionsName(arg);
                        let changes = [];
                        if (partialChanges.length > 0) {
                            partialChanges.forEach(pc => changes.push(this._partialOptionChangesMap[pc]))
                        } else {
                            changes.push(this._optionChangesMap[arg.name])
                        }
                        changes = changes.filter(c => !!c);
                        if (this._eventTrigger.change(arg.name)) {
                            this._change(["EVENTS"])
                        } else if (changes.length > 0) {
                            this._change(changes)
                        } else {
                            this.callBase.apply(this, arguments)
                        }
                    },
                    _notify: _common.noop,
                    _changesApplied: _common.noop,
                    _optionChangesMap: {
                        size: "CONTAINER_SIZE",
                        margin: "CONTAINER_SIZE",
                        redrawOnResize: "RESIZE_HANDLER",
                        theme: "THEME",
                        rtlEnabled: "THEME",
                        encodeHtml: "THEME",
                        elementAttr: "ELEMENT_ATTR",
                        disabled: "DISABLED"
                    },
                    _partialOptionChangesMap: {},
                    _partialOptionChangesPath: {},
                    getPartialChangeOptionsName(changedOption) {
                        const {
                            fullName: fullName
                        } = changedOption;
                        const sections = fullName.split(/[.]/);
                        const {
                            name: name
                        } = changedOption;
                        const {
                            value: value
                        } = changedOption;
                        const options = this._partialOptionChangesPath[name];
                        const partialChangeOptionsName = [];
                        if (options) {
                            if (true === options) {
                                partialChangeOptionsName.push(name)
                            } else {
                                options.forEach(op => {
                                    fullName.indexOf(op) >= 0 && partialChangeOptionsName.push(op)
                                });
                                if (1 === sections.length) {
                                    if ("object" === (0, _type.type)(value)) {
                                        this._addOptionsNameForPartialUpdate(value, options, partialChangeOptionsName)
                                    } else if ("array" === (0, _type.type)(value)) {
                                        if (value.length > 0 && value.every(item => this._checkOptionsForPartialUpdate(item, options))) {
                                            value.forEach(item => {
                                                this._addOptionsNameForPartialUpdate(item, options, partialChangeOptionsName)
                                            })
                                        }
                                    }
                                }
                            }
                        }
                        return partialChangeOptionsName.filter((value, index, self) => self.indexOf(value) === index)
                    },
                    _checkOptionsForPartialUpdate: (optionObject, options) => !Object.keys(optionObject).some(key => -1 === options.indexOf(key)),
                    _addOptionsNameForPartialUpdate(optionObject, options, partialChangeOptionsName) {
                        const optionKeys = Object.keys(optionObject);
                        if (this._checkOptionsForPartialUpdate(optionObject, options)) {
                            optionKeys.forEach(key => options.indexOf(key) > -1 && partialChangeOptionsName.push(key))
                        }
                    },
                    _visibilityChanged() {
                        this.render()
                    },
                    _setThemeAndRtl() {
                        this._themeManager.setTheme(this.option("theme"), this.option("rtlEnabled"))
                    },
                    _getRendererOptions() {
                        return {
                            rtl: this.option("rtlEnabled"),
                            encodeHtml: this.option("encodeHtml"),
                            animation: this._getAnimationOptions()
                        }
                    },
                    _setRendererOptions() {
                        this._renderer.setOptions(this._getRendererOptions())
                    },
                    svg() {
                        return this._renderer.svg()
                    },
                    getSize() {
                        const canvas = this._canvas || {};
                        return {
                            width: canvas.width,
                            height: canvas.height
                        }
                    },
                    isReady: getFalse,
                    _dataIsReady: getTrue,
                    _resetIsReady() {
                        this.isReady = getFalse
                    },
                    _renderGraphicObjects() {
                        const renderer = this._renderer;
                        const graphics = _m_charts.default.getGraphicObjects();
                        Object.keys(graphics).forEach(id => {
                            if (!this._graphicObjects[id]) {
                                const {
                                    type: type,
                                    colors: colors,
                                    rotationAngle: rotationAngle,
                                    template: template,
                                    width: width,
                                    height: height
                                } = graphics[id];
                                switch (type) {
                                    case "linear":
                                        this._graphicObjects[id] = renderer.linearGradient(colors, id, rotationAngle);
                                        break;
                                    case "radial":
                                        this._graphicObjects[id] = renderer.radialGradient(colors, id);
                                        break;
                                    case "pattern":
                                        this._graphicObjects[id] = renderer.customPattern(id, this._getTemplate(template), width, height)
                                }
                            }
                        })
                    },
                    _drawn() {
                        this.isReady = getFalse;
                        if (this._dataIsReady()) {
                            this._renderer.onEndAnimation(() => {
                                this.isReady = getTrue
                            })
                        }
                        this._eventTrigger("drawn", {})
                    }
                });
                var _default = baseWidget;
                exports.default = _default;
                (0, _helpers.replaceInherit)(baseWidget)
            },
        4096:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_chart.js ***!
              \***********************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 99393));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _math = __webpack_require__( /*! ../../core/utils/math */ 60810);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 58664);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 58201);
                var _crosshair = __webpack_require__( /*! ../../viz/chart_components/crosshair */ 97574);
                var _layout_manager = __webpack_require__( /*! ../../viz/chart_components/layout_manager */ 61189);
                var _multi_axes_synchronizer = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/multi_axes_synchronizer */ 42597));
                var _scroll_bar = __webpack_require__( /*! ../../viz/chart_components/scroll_bar */ 97882);
                var _shutter_zoom = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/shutter_zoom */ 70714));
                var _zoom_and_pan = _interopRequireDefault(__webpack_require__( /*! ../../viz/chart_components/zoom_and_pan */ 59345));
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _range_data_calculator = _interopRequireDefault(__webpack_require__( /*! ../../viz/series/helpers/range_data_calculator */ 63407));
                var _range = __webpack_require__( /*! ../../viz/translators/range */ 21177);
                var _utils2 = __webpack_require__( /*! ../../viz/utils */ 34434);
                var _m_advanced_chart = __webpack_require__( /*! ./chart_components/m_advanced_chart */ 41690);
                var _m_base_chart = __webpack_require__( /*! ./chart_components/m_base_chart */ 14107);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const DEFAULT_PANES = [{
                    name: "default",
                    border: {}
                }];
                const {
                    isArray: isArray
                } = Array;

                function changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility) {
                    const gridOpt = axis.getOptions().grid;
                    const minorGridOpt = axis.getOptions().minorGrid;
                    gridOpt.visible = gridVisibility;
                    minorGridOpt && (minorGridOpt.visible = minorGridVisibility)
                }

                function compareAxes(a, b) {
                    return a.priority - b.priority
                }

                function doesPaneExist(panes, paneName) {
                    let found = false;
                    (0, _iterator.each)(panes, (_, pane) => {
                        if (pane.name === paneName) {
                            found = true;
                            return false
                        }
                        return
                    });
                    return found
                }

                function accumulate(field, src1, src2, auxSpacing) {
                    const val1 = src1[field] || 0;
                    const val2 = src2[field] || 0;
                    return val1 + val2 + (val1 && val2 ? auxSpacing : 0)
                }

                function pickMax(field, src1, src2) {
                    return pickMaxValue(src1[field], src2[field])
                }

                function pickMaxValue(val1, val2) {
                    return Math.max(val1 || 0, val2 || 0)
                }

                function getAxisMargins(axis) {
                    return axis.getMargins()
                }

                function getHorizontalAxesMargins(axes, getMarginsFunc) {
                    return axes.reduce((margins, axis) => {
                        var _a;
                        const axisMargins = getMarginsFunc(axis);
                        const paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        const spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = accumulate("top", paneMargins, axisMargins, spacing);
                        paneMargins.bottom = accumulate("bottom", paneMargins, axisMargins, spacing);
                        paneMargins.left = pickMax("left", paneMargins, axisMargins);
                        paneMargins.right = pickMax("right", paneMargins, axisMargins);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        const orthogonalAxis = null === (_a = axis.getOrthogonalAxis) || void 0 === _a ? void 0 : _a.call(axis);
                        const shouldResetPositionMargin = (null === orthogonalAxis || void 0 === orthogonalAxis ? void 0 : orthogonalAxis.customPositionIsAvailable()) && (!axis.customPositionIsBoundaryOrthogonalAxis() || !orthogonalAxis.customPositionEqualsToPredefined());
                        if (shouldResetPositionMargin) {
                            margins[orthogonalAxis.getResolvedBoundaryPosition()] = 0
                        }
                        return margins
                    }, {
                        panes: {}
                    })
                }

                function getVerticalAxesMargins(axes) {
                    return axes.reduce((margins, axis) => {
                        const axisMargins = axis.getMargins();
                        const paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        const spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = pickMax("top", paneMargins, axisMargins);
                        paneMargins.bottom = pickMax("bottom", paneMargins, axisMargins);
                        paneMargins.left = accumulate("left", paneMargins, axisMargins, spacing);
                        paneMargins.right = accumulate("right", paneMargins, axisMargins, spacing);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        return margins
                    }, {
                        panes: {}
                    })
                }

                function performActionOnAxes(axes, action, actionArgument1, actionArgument2, actionArgument3) {
                    axes.forEach(axis => {
                        axis[action](null === actionArgument1 || void 0 === actionArgument1 ? void 0 : actionArgument1[axis.pane], (null === actionArgument2 || void 0 === actionArgument2 ? void 0 : actionArgument2[axis.pane]) || actionArgument2, actionArgument3)
                    })
                }

                function shrinkCanvases(isRotated, canvases, sizes, verticalMargins, horizontalMargins) {
                    function getMargin(side, margins, pane) {
                        const m = !(isRotated ? ["left", "right"] : ["top", "bottom"]).includes(side) ? margins : margins.panes[pane] || {};
                        return m[side]
                    }

                    function getMaxMargin(side, margins1, margins2, pane) {
                        return pickMaxValue(getMargin(side, margins1, pane), getMargin(side, margins2, pane))
                    }
                    const getOriginalField = field => "original".concat(field[0].toUpperCase()).concat(field.slice(1));

                    function shrink(canvases, paneNames, sizeField, startMargin, endMargin, oppositeMargins) {
                        paneNames = paneNames.sort((p1, p2) => canvases[p2][startMargin] - canvases[p1][startMargin]);
                        paneNames.forEach(pane => {
                            const canvas = canvases[pane];
                            oppositeMargins.forEach(margin => {
                                canvas[margin] = canvas[getOriginalField(margin)] + getMaxMargin(margin, verticalMargins, horizontalMargins, pane)
                            })
                        });
                        const firstPane = canvases[paneNames[0]];
                        const initialEmptySpace = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - canvases[paneNames.at(-1)][getOriginalField(startMargin)];
                        let emptySpace = paneNames.reduce((space, paneName) => {
                            const maxStartMargin = getMaxMargin(startMargin, verticalMargins, horizontalMargins, paneName);
                            const maxEndMargin = getMaxMargin(endMargin, verticalMargins, horizontalMargins, paneName);
                            return space - maxStartMargin - maxEndMargin
                        }, initialEmptySpace) - _utils.PANE_PADDING * (paneNames.length - 1);
                        emptySpace -= Object.keys(sizes).reduce((prev, key) => {
                            const currentHeight = !(0, _utils.isRelativeHeightPane)(sizes[key]) ? sizes[key].height : 0;
                            return prev + currentHeight
                        }, 0);
                        const initialOffset = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - (emptySpace < 0 ? emptySpace : 0);
                        paneNames.reduce((offset, pane) => {
                            const canvas = canvases[pane];
                            const paneSize = sizes[pane];
                            offset -= getMaxMargin(endMargin, verticalMargins, horizontalMargins, pane);
                            canvas[endMargin] = firstPane[sizeField] - offset;
                            offset -= !(0, _utils.isRelativeHeightPane)(paneSize) ? paneSize.height : Math.floor(emptySpace * paneSize.height);
                            canvas[startMargin] = offset;
                            offset -= getMaxMargin(startMargin, verticalMargins, horizontalMargins, pane) + _utils.PANE_PADDING;
                            return offset
                        }, initialOffset)
                    }
                    const paneNames = Object.keys(canvases);
                    if (!isRotated) {
                        shrink(canvases, paneNames, "height", "top", "bottom", ["left", "right"])
                    } else {
                        shrink(canvases, paneNames, "width", "left", "right", ["top", "bottom"])
                    }
                    return canvases
                }

                function drawAxesWithTicks(axes, condition, canvases, panesBorderOptions) {
                    if (condition) {
                        performActionOnAxes(axes, "createTicks", canvases);
                        _multi_axes_synchronizer.default.synchronize(axes)
                    }
                    performActionOnAxes(axes, "draw", !condition && canvases, panesBorderOptions)
                }

                function shiftAxis(side1, side2) {
                    const shifts = {};
                    return function(axis) {
                        if (!axis.customPositionIsAvailable() || axis.customPositionEqualsToPredefined()) {
                            const shift = shifts[axis.pane] = shifts[axis.pane] || {
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            };
                            const spacing = axis.getMultipleAxesSpacing();
                            const margins = axis.getMargins();
                            axis.shift(shift);
                            shift[side1] = accumulate(side1, shift, margins, spacing);
                            shift[side2] = accumulate(side2, shift, margins, spacing)
                        } else {
                            axis.shift({
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            })
                        }
                    }
                }

                function getCommonSize(side, margins) {
                    let size = 0;
                    let paneMargins;
                    Object.keys(margins.panes).forEach(pane => {
                        paneMargins = margins.panes[pane];
                        size += "height" === side ? paneMargins.top + paneMargins.bottom : paneMargins.left + paneMargins.right
                    });
                    return size
                }

                function checkUsedSpace(sizeShortage, side, axes, getMarginFunc) {
                    let size = 0;
                    if (sizeShortage[side] > 0) {
                        size = getCommonSize(side, getMarginFunc(axes, getAxisMargins));
                        performActionOnAxes(axes, "hideTitle");
                        sizeShortage[side] -= size - getCommonSize(side, getMarginFunc(axes, getAxisMargins))
                    }
                    if (sizeShortage[side] > 0) {
                        performActionOnAxes(axes, "hideOuterElements")
                    }
                }
                const isOverlay = (currentPoint, overlayPoint, pointRadius) => {
                    const pointHitsLeftBorder = overlayPoint.x - pointRadius <= currentPoint.x;
                    const pointHitsRightBorder = overlayPoint.x + pointRadius >= currentPoint.x;
                    const pointHitsTopBorder = overlayPoint.y - pointRadius <= currentPoint.y;
                    const pointHitsBottomBorder = overlayPoint.y + pointRadius >= currentPoint.y;
                    const isPointOverlappedHorizontally = pointHitsLeftBorder && pointHitsRightBorder;
                    const isPointOverlappedVertically = pointHitsTopBorder && pointHitsBottomBorder;
                    return isPointOverlappedHorizontally && isPointOverlappedVertically
                };
                const isPointOverlapped = (currentPoint, points, skipSamePointsComparing) => {
                    const radiusPoint = currentPoint.getOptions().size / 2;
                    for (let i = 0; i < points.length; i += 1) {
                        if (!skipSamePointsComparing) {
                            const isXCoordinateSame = points[i].x === currentPoint.x;
                            const isYCoordinateSame = points[i].y === currentPoint.y;
                            if (isXCoordinateSame && isYCoordinateSame) {
                                continue
                            }
                        }
                        if (isOverlay(currentPoint, points[i], radiusPoint)) {
                            return true
                        }
                    }
                    return false
                };
                const dxChart = _m_advanced_chart.AdvancedChart.inherit({
                    _themeSection: "chart",
                    _fontFields: ["crosshair.label.font"],
                    _initCore() {
                        this.paneAxis = {};
                        this.callBase()
                    },
                    _init() {
                        this._containerInitialHeight = (0, _window.hasWindow)() ? (0, _size.getHeight)(this._$element) : 0;
                        this.callBase()
                    },
                    _correctAxes() {
                        this._correctValueAxes(true)
                    },
                    _setDeprecatedOptions() {
                        this.callBase();
                        (0, _extend2.extend)(this._deprecatedOptions, {
                            "argumentAxis.aggregateByCategory": {
                                since: "23.1",
                                message: "Use the aggregation.enabled property"
                            }
                        })
                    },
                    _getExtraOptions: _common.noop,
                    _createPanes() {
                        let panes = this.option("panes");
                        let panesNameCounter = 0;
                        let defaultPane;
                        if (!panes || isArray(panes) && !panes.length) {
                            panes = DEFAULT_PANES
                        }
                        this.callBase();
                        defaultPane = this.option("defaultPane");
                        panes = (0, _extend2.extend)(true, [], isArray(panes) ? panes : [panes]);
                        (0, _iterator.each)(panes, (_, pane) => {
                            pane.name = !(0, _type.isDefined)(pane.name) ? "default" + panesNameCounter++ : pane.name
                        });
                        if ((0, _type.isDefined)(defaultPane)) {
                            if (!doesPaneExist(panes, defaultPane)) {
                                this._incidentOccurred("W2101", [defaultPane]);
                                defaultPane = panes[panes.length - 1].name
                            }
                        } else {
                            defaultPane = panes[panes.length - 1].name
                        }
                        this.defaultPane = defaultPane;
                        panes = this._isRotated() ? panes.reverse() : panes;
                        return panes
                    },
                    _getAxisRenderingOptions: () => ({
                        axisType: "xyAxes",
                        drawingType: "linear"
                    }),
                    _prepareAxisOptions(typeSelector, userOptions, rotated) {
                        return {
                            isHorizontal: "argumentAxis" === typeSelector !== rotated,
                            containerColor: this._themeManager.getOptions("containerBackgroundColor")
                        }
                    },
                    _checkPaneName(seriesTheme) {
                        const paneList = (0, _utils.map)(this.panes, pane => pane.name);
                        seriesTheme.pane = seriesTheme.pane || this.defaultPane;
                        return paneList.includes(seriesTheme.pane)
                    },
                    _initCustomPositioningAxes() {
                        const argumentAxis = this.getArgumentAxis();
                        const valueAxisName = argumentAxis.getOptions().customPositionAxis;
                        const valueAxis = this._valueAxes.find(v => v.pane === argumentAxis.pane && (!valueAxisName || valueAxisName === v.name));
                        this._valueAxes.forEach(v => {
                            if (argumentAxis !== v.getOrthogonalAxis()) {
                                v.getOrthogonalAxis = () => argumentAxis;
                                v.customPositionIsBoundaryOrthogonalAxis = () => argumentAxis.customPositionIsBoundary()
                            }
                        });
                        if ((0, _type.isDefined)(valueAxis) && valueAxis !== argumentAxis.getOrthogonalAxis()) {
                            argumentAxis.getOrthogonalAxis = () => valueAxis;
                            argumentAxis.customPositionIsBoundaryOrthogonalAxis = () => this._valueAxes.some(v => v.customPositionIsBoundary())
                        } else if ((0, _type.isDefined)(argumentAxis.getOrthogonalAxis()) && !(0, _type.isDefined)(valueAxis)) {
                            argumentAxis.getOrthogonalAxis = _common.noop
                        }
                    },
                    _getAllAxes() {
                        return this._argumentAxes.concat(this._valueAxes)
                    },
                    _resetAxesAnimation(isFirstDrawing, isHorizontal) {
                        let axes;
                        if ((0, _type.isDefined)(isHorizontal)) {
                            axes = isHorizontal ^ this._isRotated() ? this._argumentAxes : this._valueAxes
                        } else {
                            axes = this._getAllAxes()
                        }
                        axes.forEach(a => {
                            a.resetApplyingAnimation(isFirstDrawing)
                        })
                    },
                    _axesBoundaryPositioning() {
                        const allAxes = this._getAllAxes();
                        let boundaryStateChanged = false;
                        allAxes.forEach(a => {
                            if (!a.customPositionIsAvailable()) {
                                return
                            }
                            const prevBoundaryState = a.customPositionIsBoundary();
                            a._customBoundaryPosition = a.getCustomBoundaryPosition();
                            boundaryStateChanged = boundaryStateChanged || prevBoundaryState !== a.customPositionIsBoundary()
                        });
                        return boundaryStateChanged
                    },
                    _getCrosshairMargins() {
                        const crosshairOptions = this._getCrosshairOptions() || {};
                        const crosshairEnabled = crosshairOptions.enabled;
                        const margins = (0, _crosshair.getMargins)();
                        const horizontalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.horizontalLine.label);
                        const verticalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.verticalLine.label);
                        return {
                            x: crosshairEnabled && crosshairOptions.horizontalLine.visible && horizontalLabel.visible ? margins.x : 0,
                            y: crosshairEnabled && crosshairOptions.verticalLine.visible && verticalLabel.visible ? margins.y : 0
                        }
                    },
                    _getValueAxis(paneName, axisName) {
                        const valueAxes = this._valueAxes;
                        const valueAxisOptions = this.option("valueAxis") || {};
                        const valueAxesOptions = isArray(valueAxisOptions) ? valueAxisOptions : [valueAxisOptions];
                        const rotated = this._isRotated();
                        const crosshairMargins = this._getCrosshairMargins();
                        let axisOptions;
                        let axis;
                        axisName = axisName || function(axes, paneName, defaultPane) {
                            let result;
                            for (let i = 0; i < axes.length; i += 1) {
                                if (axes[i].pane === paneName || void 0 === axes[i].pane && paneName === defaultPane) {
                                    result = axes[i].name;
                                    break
                                }
                            }
                            if (!result) {
                                result = axes[0].name
                            }
                            return result
                        }(valueAxes, paneName, this.defaultPane);
                        axis = function findAxis(paneName, axisName, axes) {
                            const axisByName = axes.find(axis => axis.name === axisName && axis.pane === paneName);
                            if (axisByName) {
                                return axisByName
                            }
                            if (paneName) {
                                return findAxis(void 0, axisName, axes)
                            }
                        }(paneName, axisName, valueAxes);
                        if (!axis) {
                            axisOptions = function(valueAxes, valueAxesOptions, axisName) {
                                let result;
                                let axInd;
                                for (axInd = 0; axInd < valueAxesOptions.length; axInd += 1) {
                                    if (valueAxesOptions[axInd].name === axisName) {
                                        result = valueAxesOptions[axInd];
                                        result.priority = axInd;
                                        break
                                    }
                                }
                                if (!result) {
                                    for (axInd = 0; axInd < valueAxes.length; axInd += 1) {
                                        if (valueAxes[axInd].name === axisName) {
                                            result = valueAxes[axInd].getOptions();
                                            result.priority = valueAxes[axInd].priority;
                                            break
                                        }
                                    }
                                }
                                return result
                            }(valueAxes, valueAxesOptions, axisName);
                            if (!axisOptions) {
                                this._incidentOccurred("W2102", [axisName]);
                                axisOptions = {
                                    name: axisName,
                                    priority: valueAxes.length
                                }
                            }
                            axis = this._createAxis(false, this._populateAxesOptions("valueAxis", axisOptions, {
                                pane: paneName,
                                name: axisName,
                                optionPath: isArray(valueAxisOptions) ? "valueAxis[".concat(axisOptions.priority, "]") : "valueAxis",
                                crosshairMargin: rotated ? crosshairMargins.y : crosshairMargins.x
                            }, rotated));
                            axis.applyVisualRangeSetter(this._getVisualRangeSetter());
                            valueAxes.push(axis)
                        }
                        axis.setPane(paneName);
                        return axis
                    },
                    _correctValueAxes(needHideGrids) {
                        const synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        const valueAxes = this._valueAxes;
                        const paneWithAxis = {};
                        this.series.forEach(series => {
                            const axis = series.getValueAxis();
                            paneWithAxis[axis.pane] = true
                        });
                        this.panes.forEach(pane => {
                            const paneName = pane.name;
                            if (!paneWithAxis[paneName]) {
                                this._getValueAxis(paneName)
                            }
                            if (needHideGrids && synchronizeMultiAxes) {
                                ! function(axesForPane) {
                                    let axisShown = false;
                                    const hiddenStubAxis = [];
                                    const minorGridVisibility = axesForPane.some(axis => {
                                        const minorGridOptions = axis.getOptions().minorGrid;
                                        return null === minorGridOptions || void 0 === minorGridOptions ? void 0 : minorGridOptions.visible
                                    });
                                    const gridVisibility = axesForPane.some(axis => {
                                        const gridOptions = axis.getOptions().grid;
                                        return null === gridOptions || void 0 === gridOptions ? void 0 : gridOptions.visible
                                    });
                                    if (axesForPane.length > 1) {
                                        axesForPane.forEach(axis => {
                                            const gridOpt = axis.getOptions().grid;
                                            if (axisShown) {
                                                changeVisibilityAxisGrids(axis, false, false)
                                            } else if (null === gridOpt || void 0 === gridOpt ? void 0 : gridOpt.visible) {
                                                if (axis.getTranslator().getBusinessRange().isEmpty()) {
                                                    changeVisibilityAxisGrids(axis, false, false);
                                                    hiddenStubAxis.push(axis)
                                                } else {
                                                    axisShown = true;
                                                    changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility)
                                                }
                                            }
                                        });
                                        if (!axisShown && hiddenStubAxis.length) {
                                            changeVisibilityAxisGrids(hiddenStubAxis[0], gridVisibility, minorGridVisibility)
                                        }
                                    }
                                }(valueAxes.filter(axis => axis.pane === paneName))
                            }
                        });
                        this._valueAxes = valueAxes.filter(axis => {
                            if (!axis.pane) {
                                axis.setPane(this.defaultPane)
                            }
                            const paneExists = doesPaneExist(this.panes, axis.pane);
                            if (!paneExists) {
                                axis.dispose();
                                axis = null
                            }
                            return paneExists
                        }).sort(compareAxes);
                        const defaultAxis = this.getValueAxis();
                        this._valueAxes.forEach(axis => {
                            const {
                                optionPath: optionPath
                            } = axis.getOptions();
                            if (optionPath) {
                                const axesWithSamePath = this._valueAxes.filter(a => a.getOptions().optionPath === optionPath);
                                if (axesWithSamePath.length > 1) {
                                    if (axesWithSamePath.some(a => a === defaultAxis)) {
                                        axesWithSamePath.forEach(a => {
                                            if (a !== defaultAxis) {
                                                a.getOptions().optionPath = null
                                            }
                                        })
                                    } else {
                                        axesWithSamePath.forEach((a, i) => {
                                            if (0 !== i) {
                                                a.getOptions().optionPath = null
                                            }
                                        })
                                    }
                                }
                            }
                        })
                    },
                    _getSeriesForPane(paneName) {
                        const paneSeries = [];
                        (0, _iterator.each)(this.series, (_, oneSeries) => {
                            if (oneSeries.pane === paneName) {
                                paneSeries.push(oneSeries)
                            }
                        });
                        return paneSeries
                    },
                    _createPanesBorderOptions() {
                        const commonBorderOptions = this._themeManager.getOptions("commonPaneSettings").border;
                        const panesBorderOptions = {};
                        this.panes.forEach(pane => {
                            panesBorderOptions[pane.name] = (0, _extend2.extend)(true, {}, commonBorderOptions, pane.border)
                        });
                        return panesBorderOptions
                    },
                    _createScrollBar() {
                        var _a;
                        const scrollBarOptions = this._themeManager.getOptions("scrollBar") || {};
                        const scrollBarGroup = this._scrollBarGroup;
                        if (scrollBarOptions.visible) {
                            scrollBarOptions.rotated = this._isRotated();
                            this._scrollBar = (this._scrollBar || new _scroll_bar.ScrollBar(this._renderer, scrollBarGroup)).update(scrollBarOptions)
                        } else {
                            scrollBarGroup.linkRemove();
                            null === (_a = this._scrollBar) || void 0 === _a ? void 0 : _a.dispose();
                            this._scrollBar = null
                        }
                    },
                    _executeAppendAfterSeries(append) {
                        append()
                    },
                    _prepareToRender() {
                        const panesBorderOptions = this._createPanesBorderOptions();
                        this._createPanesBackground();
                        this._appendAxesGroups();
                        this._adjustViewport();
                        return panesBorderOptions
                    },
                    _adjustViewport() {
                        const adjustOnZoom = this._themeManager.getOptions("adjustOnZoom");
                        if (!adjustOnZoom) {
                            return
                        }
                        this._valueAxes.forEach(axis => axis.adjust())
                    },
                    _recreateSizeDependentObjects(isCanvasChanged) {
                        const series = this._getVisibleSeries();
                        const useAggregation = series.some(s => s.useAggregation());
                        const zoomChanged = this._isZooming();
                        if (!useAggregation) {
                            return
                        }
                        this._argumentAxes.forEach(axis => {
                            axis.updateCanvas(this._canvas, true)
                        });
                        series.forEach(series => {
                            if (series.useAggregation() && (isCanvasChanged || zoomChanged || !series._useAllAggregatedPoints)) {
                                series.createPoints()
                            }
                        });
                        this._processSeriesFamilies()
                    },
                    _isZooming() {
                        const argumentAxis = this.getArgumentAxis();
                        if (!(null === argumentAxis || void 0 === argumentAxis ? void 0 : argumentAxis.getTranslator())) {
                            return false
                        }
                        const businessRange = argumentAxis.getTranslator().getBusinessRange();
                        const zoomRange = argumentAxis.getViewport();
                        let min = zoomRange ? zoomRange.min : 0;
                        let max = zoomRange ? zoomRange.max : 0;
                        if ("logarithmic" === businessRange.axisType) {
                            min = (0, _utils.getLog)(min, businessRange.base);
                            max = (0, _utils.getLog)(max, businessRange.base)
                        }
                        const viewportDistance = "discrete" === businessRange.axisType ? (0, _utils.getCategoriesInfo)(businessRange.categories, min, max).categories.length : Math.abs(max - min);
                        let precision = (0, _math.getPrecision)(viewportDistance);
                        precision = precision > 1 ? 10 ** (precision - 2) : 1;
                        const zoomChanged = Math.round((this._zoomLength - viewportDistance) * precision) / precision !== 0;
                        this._zoomLength = viewportDistance;
                        return zoomChanged
                    },
                    _handleSeriesDataUpdated() {
                        const viewport = new _range.Range;
                        this.series.forEach(s => {
                            viewport.addRange(s.getArgumentRange())
                        });
                        this._argumentAxes.forEach(axis => {
                            axis.updateCanvas(this._canvas, true);
                            axis.setBusinessRange(viewport, this._axesReinitialized)
                        });
                        this.callBase()
                    },
                    _isLegendInside() {
                        return this._legend && "inside" === this._legend.getPosition()
                    },
                    _isRotated() {
                        return this._themeManager.getOptions("rotated")
                    },
                    _getLayoutTargets() {
                        return this.panes
                    },
                    _applyClipRects(panesBorderOptions) {
                        this._drawPanesBorders(panesBorderOptions);
                        this._createClipRectsForPanes();
                        this._applyClipRectsForAxes();
                        this._fillPanesBackground()
                    },
                    _updateLegendPosition(drawOptions, legendHasInsidePosition) {
                        if (drawOptions.drawLegend && this._legend && legendHasInsidePosition) {
                            const {
                                panes: panes
                            } = this;
                            const newCanvas = (0, _extend2.extend)({}, panes[0].canvas);
                            const layoutManager = new _layout_manager.LayoutManager;
                            newCanvas.right = panes[panes.length - 1].canvas.right;
                            newCanvas.bottom = panes[panes.length - 1].canvas.bottom;
                            layoutManager.layoutInsideLegend(this._legend, newCanvas)
                        }
                    },
                    _allowLegendInsidePosition: () => true,
                    _applyExtraSettings(series) {
                        const paneIndex = this._getPaneIndex(series.pane);
                        const panesClipRects = this._panesClipRects;
                        const wideClipRect = panesClipRects.wide[paneIndex];
                        series.setClippingParams(panesClipRects.base[paneIndex].id, null === wideClipRect || void 0 === wideClipRect ? void 0 : wideClipRect.id, this._getPaneBorderVisibility(paneIndex))
                    },
                    _updatePanesCanvases(drawOptions) {
                        if (!drawOptions.recreateCanvas) {
                            return
                        }(0, _utils.updatePanesCanvases)(this.panes, this._canvas, this._isRotated())
                    },
                    _normalizePanesHeight() {
                        (0, _utils.normalizePanesHeight)(this.panes)
                    },
                    _renderScaleBreaks() {
                        this._valueAxes.concat(this._argumentAxes).forEach(axis => {
                            axis.drawScaleBreaks()
                        })
                    },
                    _getArgFilter() {
                        return _range_data_calculator.default.getViewPortFilter(this.getArgumentAxis().visualRange() || {})
                    },
                    _hidePointsForSingleSeriesIfNeeded(series) {
                        const seriesPoints = series.getPoints();
                        let overlappedPointsCount = 0;
                        for (let i = 0; i < seriesPoints.length; i += 1) {
                            const currentPoint = seriesPoints[i];
                            const overlappingPoints = seriesPoints.slice(i + 1);
                            overlappedPointsCount += Number(isPointOverlapped(currentPoint, overlappingPoints));
                            if (overlappedPointsCount > seriesPoints.length / 2) {
                                series.autoHidePointMarkers = true;
                                break
                            }
                        }
                    },
                    _applyAutoHidePointMarkers(filteredSeries) {
                        let overlappingPoints = [];
                        const overlappedPointsCalculator = (pointsCount, currentPoint) => pointsCount + isPointOverlapped(currentPoint, overlappingPoints, true);
                        for (let i = filteredSeries.length - 1; i >= 0; i -= 1) {
                            const currentSeries = filteredSeries[i];
                            if (!currentSeries.autoHidePointMarkersEnabled()) {
                                continue
                            }
                            currentSeries.autoHidePointMarkers = false;
                            this._hidePointsForSingleSeriesIfNeeded(currentSeries);
                            if (!currentSeries.autoHidePointMarkers) {
                                const seriesPoints = currentSeries.getPoints();
                                const overlappingPointsCount = seriesPoints.reduce(overlappedPointsCalculator, 0);
                                if (overlappingPointsCount < seriesPoints.length) {
                                    overlappingPoints = overlappingPoints.concat(seriesPoints)
                                } else {
                                    currentSeries.autoHidePointMarkers = true
                                }
                            }
                        }
                    },
                    _applyPointMarkersAutoHiding() {
                        const allSeries = this.series;
                        if (!this._themeManager.getOptions("autoHidePointMarkers")) {
                            allSeries.forEach(s => {
                                s.autoHidePointMarkers = false
                            });
                            return
                        }
                        this.panes.forEach(_ref => {
                            let {
                                borderCoords: borderCoords,
                                name: name
                            } = _ref;
                            const series = allSeries.filter(s => s.pane === name && s.usePointsToDefineAutoHiding());
                            series.forEach(singleSeries => {
                                singleSeries.prepareCoordinatesForPoints()
                            });
                            const argAxis = this.getArgumentAxis();
                            const markersInfo = function(allSeries, filteredSeries, argAxis) {
                                const series = [];
                                const overloadedSeries = {};
                                const argVisualRange = argAxis.visualRange();
                                const argTranslator = argAxis.getTranslator();
                                const argViewPortFilter = _range_data_calculator.default.getViewPortFilter(argVisualRange || {});
                                filteredSeries.forEach(s => {
                                    const valAxis = s.getValueAxis();
                                    const valVisualRange = valAxis.getCanvasRange();
                                    const valTranslator = valAxis.getTranslator();
                                    const seriesIndex = allSeries.indexOf(s);
                                    const valViewPortFilter = _range_data_calculator.default.getViewPortFilter(valVisualRange || {});
                                    overloadedSeries[seriesIndex] = {};
                                    filteredSeries.forEach(sr => {
                                        overloadedSeries[seriesIndex][allSeries.indexOf(sr)] = 0
                                    });
                                    const seriesPoints = [];
                                    const pointsInViewport = s.getPoints().filter(p => p.getOptions().visible && argViewPortFilter(p.argument) && (valViewPortFilter(p.getMinValue(true)) || valViewPortFilter(p.getMaxValue(true))));
                                    pointsInViewport.forEach(p => {
                                        const tp = {
                                            seriesIndex: seriesIndex,
                                            argument: p.argument,
                                            value: p.getMaxValue(true),
                                            size: p.bubbleSize || p.getOptions().size,
                                            x: void 0,
                                            y: void 0
                                        };
                                        if (p.getMinValue(true) !== p.getMaxValue(true)) {
                                            const mp = (0, _extend2.extend)({}, tp);
                                            mp.value = p.getMinValue(true);
                                            mp.x = argTranslator.to(mp.argument, 1);
                                            mp.y = valTranslator.to(mp.value, 1);
                                            seriesPoints.push(mp)
                                        }
                                        tp.x = argTranslator.to(tp.argument, 1);
                                        tp.y = valTranslator.to(tp.value, 1);
                                        seriesPoints.push(tp)
                                    });
                                    overloadedSeries[seriesIndex].pointsCount = seriesPoints.length;
                                    overloadedSeries[seriesIndex].total = 0;
                                    overloadedSeries[seriesIndex].continuousSeries = 0;
                                    series.push({
                                        name: s.name,
                                        index: seriesIndex,
                                        points: seriesPoints
                                    })
                                });
                                return {
                                    series: series,
                                    overloadedSeries: overloadedSeries
                                }
                            }(allSeries, series, argAxis);
                            ! function(canvas, markersInfo, series) {
                                const area = canvas.width * canvas.height;
                                const seriesPoints = markersInfo.series;
                                for (let i = seriesPoints.length - 1; i >= 0; i -= 1) {
                                    const currentSeries = series.filter(s => s.name === seriesPoints[i].name)[0];
                                    const {
                                        points: points
                                    } = seriesPoints[i];
                                    const pointSize = points.length ? points[0].size : 0;
                                    const pointsArea = pointSize * pointSize * points.length;
                                    if (currentSeries.autoHidePointMarkersEnabled() && pointsArea >= area / seriesPoints.length) {
                                        const {
                                            index: index
                                        } = seriesPoints[i];
                                        currentSeries.autoHidePointMarkers = true;
                                        seriesPoints.splice(i, 1);
                                        series.splice(series.indexOf(currentSeries), 1);
                                        markersInfo.overloadedSeries[index] = null
                                    }
                                }
                            }(borderCoords, markersInfo, series);
                            if (markersInfo.series.length) {
                                const argVisualRange = argAxis.visualRange();
                                const argAxisIsDiscrete = "discrete" === argAxis.getOptions().type;
                                const sortingCallback = argAxisIsDiscrete ? (p1, p2) => argVisualRange.categories.indexOf(p1.argument) - argVisualRange.categories.indexOf(p2.argument) : (p1, p2) => p1.argument - p2.argument;
                                let points = [];
                                markersInfo.series.forEach(s => {
                                    points = points.concat(s.points)
                                });
                                points.sort(sortingCallback);
                                ! function(points, overloadedSeries) {
                                    let isContinuousSeries = false;
                                    for (let i = 0; i < points.length - 1; i += 1) {
                                        const curPoint = points[i];
                                        const {
                                            size: size
                                        } = curPoint;
                                        if ((0, _type.isDefined)(curPoint.x) && (0, _type.isDefined)(curPoint.y)) {
                                            for (let j = i + 1; j < points.length; j += 1) {
                                                const nextPoint = points[j];
                                                const nextX = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.x;
                                                const nextY = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.y;
                                                if (!(0, _type.isDefined)(nextX) || Math.abs(curPoint.x - nextX) >= size) {
                                                    isContinuousSeries = isContinuousSeries && j !== i + 1;
                                                    break
                                                } else {
                                                    const distance = (0, _type.isDefined)(nextX) && (0, _type.isDefined)(nextY) && Math.sqrt((curPoint.x - nextX) ** 2 + (curPoint.y - nextY) ** 2);
                                                    if (distance && distance < size) {
                                                        overloadedSeries[curPoint.seriesIndex][nextPoint.seriesIndex] += 1;
                                                        overloadedSeries[curPoint.seriesIndex].total += 1;
                                                        if (!isContinuousSeries) {
                                                            overloadedSeries[curPoint.seriesIndex].continuousSeries += 1;
                                                            isContinuousSeries = true
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }(points, markersInfo.overloadedSeries);
                                this._applyAutoHidePointMarkers(series)
                            }
                        })
                    },
                    _renderAxes(drawOptions, panesBorderOptions) {
                        function calculateTitlesWidth(axes) {
                            return axes.map(axis => {
                                if (!axis.getTitle) {
                                    return 0
                                }
                                const title = axis.getTitle();
                                return title ? title.bBox.width : 0
                            })
                        }
                        const rotated = this._isRotated();
                        const synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        const scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        const extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        const verticalAxes = rotated ? this._argumentAxes : this._valueAxes;
                        const verticalElements = rotated ? extendedArgAxes : this._valueAxes;
                        const horizontalAxes = rotated ? this._valueAxes : this._argumentAxes;
                        const horizontalElements = rotated ? this._valueAxes : extendedArgAxes;
                        const allAxes = verticalAxes.concat(horizontalAxes);
                        const allElements = allAxes.concat(scrollBar);
                        const verticalAxesFirstDrawing = verticalAxes.some(v => v.isFirstDrawing());
                        this._normalizePanesHeight();
                        this._updatePanesCanvases(drawOptions);
                        let panesCanvases = this.panes.reduce((canvases, pane) => {
                            canvases[pane.name] = (0, _extend2.extend)({}, pane.canvas);
                            return canvases
                        }, {});
                        const paneSizes = this.panes.reduce((sizes, pane) => {
                            sizes[pane.name] = {
                                height: pane.height,
                                unit: pane.unit
                            };
                            return sizes
                        }, {});
                        const cleanPanesCanvases = (0, _extend2.extend)(true, {}, panesCanvases);
                        this._initCustomPositioningAxes();
                        const needCustomAdjustAxes = this._axesBoundaryPositioning();
                        if (!drawOptions.adjustAxes && !needCustomAdjustAxes) {
                            drawAxesWithTicks(verticalAxes, !rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            drawAxesWithTicks(horizontalAxes, rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            performActionOnAxes(allAxes, "prepareAnimation");
                            this._renderScaleBreaks();
                            horizontalAxes.forEach(a => a.resolveOverlappingForCustomPositioning(verticalAxes));
                            verticalAxes.forEach(a => a.resolveOverlappingForCustomPositioning(horizontalAxes));
                            return false
                        }
                        if (needCustomAdjustAxes) {
                            allAxes.forEach(a => a.customPositionIsAvailable() && a.shift({
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            }))
                        }
                        if (this._scrollBar) {
                            this._scrollBar.setPane(this.panes)
                        }
                        let vAxesMargins = {
                            panes: {},
                            left: 0,
                            right: 0
                        };
                        let hAxesMargins = getHorizontalAxesMargins(horizontalElements, axis => axis.estimateMargins(panesCanvases[axis.pane]));
                        panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                        const drawAxesAndSetCanvases = isHorizontal => {
                            const axes = isHorizontal ? horizontalAxes : verticalAxes;
                            const condition = (isHorizontal ? rotated : !rotated) && synchronizeMultiAxes;
                            drawAxesWithTicks(axes, condition, panesCanvases, panesBorderOptions);
                            if (isHorizontal) {
                                hAxesMargins = getHorizontalAxesMargins(horizontalElements, getAxisMargins)
                            } else {
                                vAxesMargins = getVerticalAxesMargins(verticalElements)
                            }
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins)
                        };
                        drawAxesAndSetCanvases(false);
                        drawAxesAndSetCanvases(true);
                        if (!this._changesApplying && this._estimateTickIntervals(verticalAxes, panesCanvases)) {
                            drawAxesAndSetCanvases(false)
                        }
                        let oldTitlesWidth = calculateTitlesWidth(verticalAxes);
                        const visibleSeries = this._getVisibleSeries();
                        const pointsToAnimation = this._getPointsToAnimation(visibleSeries);
                        const axesIsAnimated = function(drawOptions, pointsToAnimation) {
                            const pointsCount = pointsToAnimation.reduce((sum, count) => sum + count, 0) / pointsToAnimation.length;
                            return drawOptions.animate && pointsCount <= drawOptions.animationPointsLimit
                        }(drawOptions, pointsToAnimation);
                        performActionOnAxes(allElements, "updateSize", panesCanvases, axesIsAnimated);
                        horizontalElements.forEach(shiftAxis("top", "bottom"));
                        verticalElements.forEach(shiftAxis("left", "right"));
                        this._renderScaleBreaks();
                        this.panes.forEach(pane => {
                            (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name])
                        });
                        this._valueAxes.forEach(axis => {
                            axis.setInitRange()
                        });
                        verticalAxes.forEach((axis, i) => {
                            var _a;
                            if (null === (_a = axis.hasWrap) || void 0 === _a ? void 0 : _a.call(axis)) {
                                const title = axis.getTitle();
                                const newTitleWidth = title ? title.bBox.width : 0;
                                const offset = newTitleWidth - oldTitlesWidth[i];
                                if ("right" === axis.getOptions().position) {
                                    vAxesMargins.right += offset
                                } else {
                                    vAxesMargins.left += offset;
                                    this.panes.forEach(_ref2 => {
                                        let {
                                            name: name
                                        } = _ref2;
                                        vAxesMargins.panes[name].left += offset
                                    })
                                }
                                panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                                performActionOnAxes(allElements, "updateSize", panesCanvases, false, false);
                                oldTitlesWidth = calculateTitlesWidth(verticalAxes)
                            }
                        });
                        if (verticalAxes.some(v => v.customPositionIsAvailable() && v.getCustomPosition() !== v._axisPosition)) {
                            axesIsAnimated && this._resetAxesAnimation(verticalAxesFirstDrawing, false);
                            performActionOnAxes(verticalAxes, "updateSize", panesCanvases, axesIsAnimated)
                        }
                        horizontalAxes.forEach(a => a.resolveOverlappingForCustomPositioning(verticalAxes));
                        verticalAxes.forEach(a => a.resolveOverlappingForCustomPositioning(horizontalAxes));
                        return cleanPanesCanvases
                    },
                    _getExtraTemplatesItems() {
                        const allAxes = (this._argumentAxes || []).concat(this._valueAxes || []);
                        const elements = this._collectTemplatesFromItems(allAxes);
                        return {
                            items: elements.items,
                            groups: elements.groups,
                            launchRequest() {
                                allAxes.forEach(a => {
                                    a.setRenderedState(true)
                                })
                            },
                            doneRequest() {
                                allAxes.forEach(a => {
                                    a.setRenderedState(false)
                                })
                            }
                        }
                    },
                    _estimateTickIntervals: (axes, canvases) => axes.some(axis => axis.estimateTickInterval(canvases[axis.pane])),
                    checkForMoreSpaceForPanesCanvas() {
                        const rotated = this._isRotated();
                        const panesAreCustomSized = this.panes.filter(p => p.unit).length === this.panes.length;
                        let needSpace = false;
                        if (panesAreCustomSized) {
                            let needHorizontalSpace = 0;
                            let needVerticalSpace = 0;
                            if (rotated) {
                                const argAxisRightMargin = this.getArgumentAxis().getMargins().right;
                                const rightPanesIndent = Math.min(...this.panes.map(p => p.canvas.right));
                                needHorizontalSpace = this._canvas.right + argAxisRightMargin - rightPanesIndent
                            } else {
                                const argAxisBottomMargin = this.getArgumentAxis().getMargins().bottom;
                                const bottomPanesIndent = Math.min(...this.panes.map(p => p.canvas.bottom));
                                needVerticalSpace = this._canvas.bottom + argAxisBottomMargin - bottomPanesIndent
                            }
                            needSpace = needHorizontalSpace > 0 || needVerticalSpace > 0 ? {
                                width: needHorizontalSpace,
                                height: needVerticalSpace
                            } : false;
                            if (0 !== needVerticalSpace) {
                                const realSize = this.getSize();
                                const customSize = this.option("size");
                                const container = this._$element[0];
                                const containerHasStyledHeight = !!parseInt(container.style.height, 10) || 0 !== this._containerInitialHeight;
                                if (!rotated && !(null === customSize || void 0 === customSize ? void 0 : customSize.height) && !containerHasStyledHeight) {
                                    this._forceResize(realSize.width, realSize.height + needVerticalSpace);
                                    needSpace = false
                                }
                            }
                        } else {
                            needSpace = this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), rotated, pane => ({
                                width: rotated && !!pane.unit,
                                height: !rotated && !!pane.unit
                            }))
                        }
                        return needSpace
                    },
                    _forceResize(width, height) {
                        this._renderer.resize(width, height);
                        this._updateSize(true);
                        this._setContentSize();
                        this._preserveOriginalCanvas();
                        this._updateCanvasClipRect(this._canvas)
                    },
                    _shrinkAxes(sizeShortage, panesCanvases) {
                        if (!sizeShortage || !panesCanvases) {
                            return
                        }
                        this._renderer.stopAllAnimations(true);
                        const rotated = this._isRotated();
                        const scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        const extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        const verticalAxes = rotated ? extendedArgAxes : this._valueAxes;
                        const horizontalAxes = rotated ? this._valueAxes : extendedArgAxes;
                        const allAxes = verticalAxes.concat(horizontalAxes);
                        if (sizeShortage.width || sizeShortage.height) {
                            checkUsedSpace(sizeShortage, "height", horizontalAxes, getHorizontalAxesMargins);
                            checkUsedSpace(sizeShortage, "width", verticalAxes, getVerticalAxesMargins);
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            const paneSizes = this.panes.reduce((sizes, pane) => {
                                sizes[pane.name] = {
                                    height: pane.height,
                                    unit: pane.unit
                                };
                                return sizes
                            }, {});
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, getVerticalAxesMargins(verticalAxes), getHorizontalAxesMargins(horizontalAxes, getAxisMargins));
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            horizontalAxes.forEach(shiftAxis("top", "bottom"));
                            verticalAxes.forEach(shiftAxis("left", "right"));
                            this.panes.forEach(pane => (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name]))
                        }
                    },
                    _isArgumentAxisBeforeScrollBar() {
                        var _a;
                        const argumentAxis = this.getArgumentAxis();
                        if (this._scrollBar) {
                            const argAxisPosition = argumentAxis.getResolvedBoundaryPosition();
                            const argAxisLabelPosition = null === (_a = argumentAxis.getOptions().label) || void 0 === _a ? void 0 : _a.position;
                            const scrollBarPosition = this._scrollBar.getOptions().position;
                            return argumentAxis.hasNonBoundaryPosition() || scrollBarPosition === argAxisPosition && argAxisLabelPosition !== scrollBarPosition
                        }
                        return false
                    },
                    _getPanesParameters() {
                        const {
                            panes: panes
                        } = this;
                        const params = [];
                        for (let i = 0; i < panes.length; i += 1) {
                            if (this._getPaneBorderVisibility(i)) {
                                params.push({
                                    coords: panes[i].borderCoords,
                                    clipRect: this._panesClipRects.fixed[i]
                                })
                            }
                        }
                        return params
                    },
                    _createCrosshairCursor() {
                        const options = this._themeManager.getOptions("crosshair") || {};
                        const argumentAxis = this.getArgumentAxis();
                        const axes = this._isRotated() ? [this._valueAxes, [argumentAxis]] : [
                            [argumentAxis], this._valueAxes
                        ];
                        const parameters = {
                            canvas: this._getCommonCanvas(),
                            panes: this._getPanesParameters(),
                            axes: axes
                        };
                        if (!(null === options || void 0 === options ? void 0 : options.enabled)) {
                            return
                        }
                        if (this._crosshair) {
                            this._crosshair.update(options, parameters)
                        } else {
                            this._crosshair = new _crosshair.Crosshair(this._renderer, options, parameters, this._crosshairCursorGroup)
                        }
                        this._crosshair.render()
                    },
                    _getCommonCanvas() {
                        let commonCanvas;
                        const {
                            panes: panes
                        } = this;
                        for (let i = 0; i < panes.length; i += 1) {
                            const {
                                canvas: canvas
                            } = panes[i];
                            if (!commonCanvas) {
                                commonCanvas = (0, _extend2.extend)({}, canvas)
                            } else {
                                commonCanvas.right = canvas.right;
                                commonCanvas.bottom = canvas.bottom
                            }
                        }
                        return commonCanvas
                    },
                    _createPanesBackground() {
                        const defaultBackgroundColor = this._themeManager.getOptions("commonPaneSettings").backgroundColor;
                        const renderer = this._renderer;
                        const rects = [];
                        this._panesBackgroundGroup.clear();
                        for (let i = 0; i < this.panes.length; i += 1) {
                            const backgroundColor = this.panes[i].backgroundColor || defaultBackgroundColor;
                            if (!backgroundColor || "none" === backgroundColor) {
                                rects.push(null);
                                continue
                            }
                            const rect = renderer.rect(0, 0, 0, 0).attr({
                                fill: (0, _utils.extractColor)(backgroundColor),
                                "stroke-width": 0
                            }).append(this._panesBackgroundGroup);
                            rects.push(rect)
                        }
                        this.panesBackground = rects
                    },
                    _fillPanesBackground() {
                        (0, _iterator.each)(this.panes, (i, pane) => {
                            const bc = pane.borderCoords;
                            if (null !== this.panesBackground[i]) {
                                this.panesBackground[i].attr({
                                    x: bc.left,
                                    y: bc.top,
                                    width: bc.width,
                                    height: bc.height
                                })
                            }
                        })
                    },
                    _calcPaneBorderCoords(pane) {
                        const {
                            canvas: canvas
                        } = pane;
                        const bc = pane.borderCoords = pane.borderCoords || {};
                        bc.left = canvas.left;
                        bc.top = canvas.top;
                        bc.right = canvas.width - canvas.right;
                        bc.bottom = canvas.height - canvas.bottom;
                        bc.width = Math.max(bc.right - bc.left, 0);
                        bc.height = Math.max(bc.bottom - bc.top, 0)
                    },
                    _drawPanesBorders(panesBorderOptions) {
                        const rotated = this._isRotated();
                        this._panesBorderGroup.linkRemove().clear();
                        (0, _iterator.each)(this.panes, (i, pane) => {
                            const borderOptions = panesBorderOptions[pane.name];
                            const attr = {
                                fill: "none",
                                stroke: borderOptions.color,
                                "stroke-opacity": borderOptions.opacity,
                                "stroke-width": borderOptions.width,
                                dashStyle: borderOptions.dashStyle,
                                "stroke-linecap": "square"
                            };
                            this._calcPaneBorderCoords(pane, rotated);
                            if (!borderOptions.visible) {
                                return
                            }
                            const bc = pane.borderCoords;
                            const segmentRectParams = (0, _utils2.prepareSegmentRectPoints)(bc.left, bc.top, bc.width, bc.height, borderOptions);
                            this._renderer.path(segmentRectParams.points, segmentRectParams.pathType).attr(attr).append(this._panesBorderGroup)
                        });
                        this._panesBorderGroup.linkAppend()
                    },
                    _createClipRect(clipArray, index, left, top, width, height) {
                        let clipRect = clipArray[index];
                        if (!clipRect) {
                            clipRect = this._renderer.clipRect(left, top, width, height);
                            clipArray[index] = clipRect
                        } else {
                            clipRect.attr({
                                x: left,
                                y: top,
                                width: width,
                                height: height
                            })
                        }
                    },
                    _createClipRectsForPanes() {
                        const canvas = this._canvas;
                        (0, _iterator.each)(this.panes, (i, pane) => {
                            let needWideClipRect = false;
                            const bc = pane.borderCoords;
                            let {
                                left: left
                            } = bc;
                            let {
                                top: top
                            } = bc;
                            let {
                                width: width
                            } = bc;
                            let {
                                height: height
                            } = bc;
                            const panesClipRects = this._panesClipRects;
                            this._createClipRect(panesClipRects.fixed, i, left, top, width, height);
                            this._createClipRect(panesClipRects.base, i, left, top, width, height);
                            (0, _iterator.each)(this.series, (_, series) => {
                                if (series.pane === pane.name && (series.isFinancialSeries() || series.areErrorBarsVisible())) {
                                    needWideClipRect = true
                                }
                            });
                            if (needWideClipRect) {
                                if (this._isRotated()) {
                                    top = 0;
                                    height = canvas.height
                                } else {
                                    left = 0;
                                    width = canvas.width
                                }
                                this._createClipRect(panesClipRects.wide, i, left, top, width, height)
                            } else {
                                panesClipRects.wide[i] = null
                            }
                        })
                    },
                    _applyClipRectsForAxes() {
                        const axes = this._getAllAxes();
                        const chartCanvasClipRectID = this._getCanvasClipRectID();
                        for (let i = 0; i < axes.length; i += 1) {
                            const elementsClipRectID = this._getElementsClipRectID(axes[i].pane);
                            axes[i].applyClipRects(elementsClipRectID, chartCanvasClipRectID)
                        }
                    },
                    _getPaneBorderVisibility(paneIndex) {
                        var _a;
                        const commonPaneBorderVisible = this._themeManager.getOptions("commonPaneSettings").border.visible;
                        const pane = this.panes[paneIndex];
                        const paneVisibility = null === (_a = null === pane || void 0 === pane ? void 0 : pane.border) || void 0 === _a ? void 0 : _a.visible;
                        return void 0 === paneVisibility ? commonPaneBorderVisible : paneVisibility
                    },
                    _getCanvasForPane(paneName) {
                        var _a;
                        return null === (_a = this.panes.find(pane => pane.name === paneName)) || void 0 === _a ? void 0 : _a.canvas
                    },
                    _getTrackerSettings() {
                        return (0, _extend2.extend)(this.callBase(), {
                            chart: this,
                            rotated: this._isRotated(),
                            crosshair: this._getCrosshairOptions().enabled ? this._crosshair : null,
                            stickyHovering: this._themeManager.getOptions("stickyHovering")
                        })
                    },
                    _resolveLabelOverlappingStack() {
                        const isRotated = this._isRotated();
                        const shiftDirection = isRotated ? (box, length) => ({
                            x: box.x - length,
                            y: box.y
                        }) : (box, length) => ({
                            x: box.x,
                            y: box.y - length
                        });
                        const processor = (a, b) => {
                            const coordPosition = isRotated ? 1 : 0;
                            const figureCenter1 = a.labels[0].getFigureCenter()[coordPosition];
                            const figureCenter12 = b.labels[0].getFigureCenter()[coordPosition];
                            if (figureCenter1 - figureCenter12 === 0) {
                                const translator = a.labels[0].getPoint().series.getValueAxis().getTranslator();
                                const direction = translator.isInverted() ? -1 : 1;
                                return (a.value() - b.value()) * direction
                            }
                            return 0
                        };
                        (0, _iterator.each)(this._getStackPoints(), (_, stacks) => {
                            (0, _iterator.each)(stacks, (_, points) => {
                                const isInverted = points[0].series.getValueAxis().getOptions().inverted;
                                _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points, this._getCommonCanvas(), isRotated, isInverted, shiftDirection, processor)
                            })
                        })
                    },
                    _getStackPoints() {
                        const stackPoints = {};
                        const visibleSeries = this._getVisibleSeries();
                        (0, _iterator.each)(visibleSeries, (_, singleSeries) => {
                            const points = singleSeries.getPoints();
                            const stackName = singleSeries.getStackName() || null;
                            (0, _iterator.each)(points, (_, point) => {
                                const {
                                    argument: argument
                                } = point;
                                if (!stackPoints[argument]) {
                                    stackPoints[argument] = {}
                                }
                                if (!stackPoints[argument][stackName]) {
                                    stackPoints[argument][stackName] = []
                                }
                                stackPoints[argument][stackName].push(point)
                            })
                        });
                        return stackPoints
                    },
                    _getCrosshairOptions() {
                        return this._getOption("crosshair")
                    },
                    zoomArgument(min, max) {
                        if (!this._initialized || !(0, _type.isDefined)(min) && !(0, _type.isDefined)(max)) {
                            return
                        }
                        this.getArgumentAxis().visualRange([min, max])
                    },
                    resetVisualRange() {
                        const axes = this._argumentAxes;
                        const nonVirtualArgumentAxis = this.getArgumentAxis();
                        axes.forEach(axis => {
                            axis.resetVisualRange(nonVirtualArgumentAxis !== axis);
                            this._applyCustomVisualRangeOption(axis)
                        });
                        this.callBase()
                    },
                    getVisibleArgumentBounds() {
                        const translator = this._argumentAxes[0].getTranslator();
                        const range = translator.getBusinessRange();
                        const isDiscrete = "discrete" === range.axisType;
                        const {
                            categories: categories
                        } = range;
                        return {
                            minVisible: isDiscrete ? range.minVisible || categories[0] : range.minVisible,
                            maxVisible: isDiscrete ? range.maxVisible || categories[categories.length - 1] : range.maxVisible
                        }
                    },
                    _change_FULL_RENDER() {
                        this.callBase();
                        if (this._changes.has("VISUAL_RANGE")) {
                            this._raiseZoomEndHandlers()
                        }
                    },
                    _getAxesForScaling() {
                        return [this.getArgumentAxis()].concat(this._valueAxes)
                    },
                    _applyVisualRangeByVirtualAxes(axis, range) {
                        if (axis.isArgumentAxis) {
                            if (axis !== this.getArgumentAxis()) {
                                return true
                            }
                            this._argumentAxes.filter(a => a !== axis).forEach(a => a.visualRange(range, {
                                start: true,
                                end: true
                            }))
                        }
                        return false
                    },
                    _raiseZoomEndHandlers() {
                        this._argumentAxes.forEach(axis => axis.handleZoomEnd());
                        this.callBase()
                    },
                    _setOptionsByReference() {
                        this.callBase();
                        (0, _extend2.extend)(this._optionsByReference, {
                            "argumentAxis.visualRange": true
                        })
                    },
                    option() {
                        const option = this.callBase(...arguments);
                        const valueAxis = this._options.silent("valueAxis");
                        if ("array" === (0, _type.type)(valueAxis)) {
                            for (let i = 0; i < valueAxis.length; i += 1) {
                                const optionPath = "valueAxis[".concat(i, "].visualRange");
                                this._optionsByReference[optionPath] = true
                            }
                        }
                        return option
                    },
                    _notifyVisualRange() {
                        const argAxis = this._argumentAxes[0];
                        const argumentVisualRange = (0, _utils.convertVisualRangeObject)(argAxis.visualRange(), !isArray(this.option("argumentAxis.visualRange")));
                        if (!argAxis.skipEventRising || !(0, _utils.rangesAreEqual)(argumentVisualRange, this.option("argumentAxis.visualRange"))) {
                            this.option("argumentAxis.visualRange", argumentVisualRange)
                        } else {
                            argAxis.skipEventRising = null
                        }
                        this.callBase()
                    }
                });
                dxChart.addPlugin(_shutter_zoom.default);
                dxChart.addPlugin(_zoom_and_pan.default);
                dxChart.addPlugin(_annotations.plugins.core);
                dxChart.addPlugin(_annotations.plugins.chart);
                (0, _component_registrator.default)("dxChart", dxChart);
                var _default = dxChart;
                exports.default = _default
            },
        88647:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_pie_chart.js ***!
              \***************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 99393));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 95479);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _consts = _interopRequireDefault(__webpack_require__( /*! ../../viz/components/consts */ 32410));
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _center_template = __webpack_require__( /*! ../../viz/core/center_template */ 56672);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _range = __webpack_require__( /*! ../../viz/translators/range */ 21177);
                var _translator1d = __webpack_require__( /*! ../../viz/translators/translator1d */ 17953);
                var _m_base_chart = __webpack_require__( /*! ./chart_components/m_base_chart */ 14107);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const {
                    states: states
                } = _consts.default;
                const seriesSpacing = _consts.default.pieSeriesSpacing;
                const NORMAL_STATE = states.normalMark;
                const HOVER_STATE = states.hoverMark;
                const SELECTED_STATE = states.selectedMark;
                const LEGEND_ACTIONS = [states.resetItem, states.applyHover, states.applySelected, states.applySelected];

                function shiftInColumnFunction(box, length) {
                    return {
                        x: box.x,
                        y: box.y - length
                    }
                }

                function dividePoints(series, points) {
                    return series.getVisiblePoints().reduce((r, point) => {
                        const angle = (0, _utils.normalizeAngle)(point.middleAngle);
                        (angle <= 90 || angle >= 270 ? r.right : r.left).push(point);
                        return r
                    }, points || {
                        left: [],
                        right: []
                    })
                }

                function resolveOverlappedLabels(points, shiftCallback, inverseDirection, canvas) {
                    let overlapped = false;
                    if (inverseDirection) {
                        points.left.reverse();
                        points.right.reverse()
                    }
                    overlapped = _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points.left, canvas, false, false, shiftCallback);
                    return _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points.right, canvas, false, false, shiftCallback) || overlapped
                }

                function correctPercentValue(value) {
                    if ((0, _type.isNumeric)(value)) {
                        if (value > 1) {
                            value = 1
                        } else if (value < 0) {
                            value = 0
                        }
                    } else {
                        value = void 0
                    }
                    return value
                }
                const pieSizeEqualizer = function() {
                    function removeFromList(list, item) {
                        return list.filter(li => li !== item)
                    }
                    let pies = [];
                    let timers = {};
                    return {
                        queue(pie) {
                            const group = pie.getSizeGroup();
                            pies = (list = pies, item = pie, removeFromList(list, item).concat(item));
                            var list, item;
                            clearTimeout(timers[group]);
                            timers[group] = setTimeout(() => {
                                ! function(group, allPies) {
                                    const pies = allPies.filter(p => p._isVisible() && p.getSizeGroup() === group);
                                    const minRadius = Math.min.apply(null, pies.map(p => p.getSizeGroupLayout().radius));
                                    const minPie = pies.filter(p => p.getSizeGroupLayout().radius === minRadius);
                                    pies.forEach(p => p.render({
                                        force: true,
                                        sizeGroupLayout: minPie.length ? minPie[0].getSizeGroupLayout() : {}
                                    }))
                                }(group, pies)
                            })
                        },
                        remove(pie) {
                            pies = removeFromList(pies, pie);
                            if (!pies.length) {
                                timers = {}
                            }
                        }
                    }
                }();
                const dxPieChart = _m_base_chart.BaseChart.inherit({
                    _themeSection: "pie",
                    _layoutManagerOptions() {
                        return (0, _extend2.extend)(true, {}, this.callBase(), {
                            piePercentage: correctPercentValue(this._themeManager.getOptions("diameter")),
                            minPiePercentage: correctPercentValue(this._themeManager.getOptions("minDiameter"))
                        })
                    },
                    _optionChangesMap: {
                        diameter: "REINIT",
                        minDiameter: "REINIT",
                        sizeGroup: "REINIT"
                    },
                    _disposeCore() {
                        pieSizeEqualizer.remove(this);
                        this.callBase()
                    },
                    _groupSeries() {
                        var _a;
                        const {
                            series: series
                        } = this;
                        this._groupsData = {
                            groups: [{
                                series: series,
                                valueOptions: {
                                    valueType: "numeric"
                                }
                            }],
                            argumentOptions: null === (_a = series[0]) || void 0 === _a ? void 0 : _a.getOptions()
                        }
                    },
                    getArgumentAxis: () => null,
                    _getValueAxis() {
                        const translator = (new _translator1d.Translator1D).setCodomain(360, 0);
                        return {
                            getTranslator: () => translator,
                            setBusinessRange(range) {
                                translator.setDomain(range.min, range.max)
                            }
                        }
                    },
                    _populateBusinessRange() {
                        this.series.map(series => {
                            const range = new _range.Range;
                            range.addRange(series.getRangeData().val);
                            series.getValueAxis().setBusinessRange(range);
                            return range
                        })
                    },
                    _specialProcessSeries() {
                        (0, _iterator.each)(this.series, (_, singleSeries) => {
                            singleSeries.arrangePoints()
                        })
                    },
                    _checkPaneName: () => true,
                    _processSingleSeries(singleSeries) {
                        this.callBase(singleSeries);
                        singleSeries.arrangePoints()
                    },
                    _handleSeriesDataUpdated() {
                        let maxPointCount = 0;
                        this.series.forEach(s => {
                            maxPointCount = Math.max(s.getPointsCount(), maxPointCount)
                        });
                        this.series.forEach(s => {
                            s.setMaxPointsCount(maxPointCount)
                        });
                        this.callBase()
                    },
                    _getLegendOptions(item) {
                        const legendItem = this.callBase(item);
                        const {
                            legendData: legendData
                        } = legendItem;
                        legendData.argument = item.argument;
                        legendData.argumentIndex = item.argumentIndex;
                        legendData.points = [item];
                        return legendItem
                    },
                    _getLegendTargets() {
                        const itemsByArgument = {};
                        (this.series || []).forEach(series => {
                            series.getPoints().forEach(point => {
                                const argument = point.argument.valueOf();
                                const index = series.getPointsByArg(argument).indexOf(point);
                                const key = argument.valueOf().toString() + index;
                                itemsByArgument[key] = itemsByArgument[key] || [];
                                const argumentCount = itemsByArgument[key].push(point);
                                point.index = itemsByArgument[key][argumentCount - 2] ? itemsByArgument[key][argumentCount - 2].index : Object.keys(itemsByArgument).length - 1;
                                point.argumentIndex = index
                            })
                        });
                        const items = [];
                        (0, _iterator.each)(itemsByArgument, (_, points) => {
                            points.forEach((point, index) => {
                                if (0 === index) {
                                    items.push(this._getLegendOptions(point));
                                    return
                                }
                                const item = items[items.length - 1];
                                item.legendData.points.push(point);
                                if (!item.visible) {
                                    item.visible = point.isVisible()
                                }
                            })
                        });
                        return items
                    },
                    _getLayoutTargets() {
                        return [{
                            canvas: this._canvas
                        }]
                    },
                    _getLayoutSeries(series, drawOptions) {
                        let layout;
                        const canvas = this._canvas;
                        let drawnLabels = false;
                        layout = this.layoutManager.applyPieChartSeriesLayout(canvas, series, true);
                        series.forEach(singleSeries => {
                            singleSeries.correctPosition(layout, canvas);
                            drawnLabels = singleSeries.drawLabelsWOPoints() || drawnLabels
                        });
                        if (drawnLabels) {
                            layout = this.layoutManager.applyPieChartSeriesLayout(canvas, series, drawOptions.hideLayoutLabels)
                        }
                        series.forEach(singleSeries => {
                            singleSeries.hideLabels()
                        });
                        this._sizeGroupLayout = {
                            x: layout.centerX,
                            y: layout.centerY,
                            radius: layout.radiusOuter,
                            drawOptions: drawOptions
                        };
                        return layout
                    },
                    _getLayoutSeriesForEqualPies(series, sizeGroupLayout) {
                        const canvas = this._canvas;
                        const layout = this.layoutManager.applyEqualPieChartLayout(series, sizeGroupLayout);
                        series.forEach(s => {
                            s.correctPosition(layout, canvas);
                            s.drawLabelsWOPoints()
                        });
                        this.layoutManager.correctPieLabelRadius(series, layout, canvas);
                        return layout
                    },
                    _updateSeriesDimensions(drawOptions) {
                        const visibleSeries = this._getVisibleSeries();
                        const lengthVisibleSeries = visibleSeries.length;
                        let innerRad;
                        let delta;
                        let layout;
                        const {
                            sizeGroupLayout: sizeGroupLayout
                        } = drawOptions;
                        if (lengthVisibleSeries) {
                            layout = sizeGroupLayout ? this._getLayoutSeriesForEqualPies(visibleSeries, sizeGroupLayout) : this._getLayoutSeries(visibleSeries, drawOptions);
                            delta = (layout.radiusOuter - layout.radiusInner - seriesSpacing * (lengthVisibleSeries - 1)) / lengthVisibleSeries;
                            innerRad = layout.radiusInner;
                            this._setGeometry(layout);
                            visibleSeries.forEach(singleSeries => {
                                singleSeries.correctRadius({
                                    radiusInner: innerRad,
                                    radiusOuter: innerRad + delta
                                });
                                innerRad += delta + seriesSpacing
                            })
                        }
                    },
                    _renderSeries(drawOptions, isRotated, isLegendInside) {
                        this._calculateSeriesLayout(drawOptions, isRotated);
                        if (!drawOptions.sizeGroupLayout && this.getSizeGroup()) {
                            pieSizeEqualizer.queue(this);
                            this._clearCanvas();
                            return
                        }
                        this._renderSeriesElements(drawOptions, isLegendInside)
                    },
                    _getCenter() {
                        return this._center
                    },
                    getInnerRadius() {
                        return this._innerRadius
                    },
                    _getLegendCallBack() {
                        const legend = this._legend;
                        const items = this._getLegendTargets().map(i => i.legendData);
                        return target => {
                            items.forEach(data => {
                                const points = [];
                                const callback = legend.getActionCallback({
                                    index: data.id
                                });
                                this.series.forEach(series => {
                                    const seriesPoints = series.getPointsByKeys(data.argument, data.argumentIndex);
                                    points.push.apply(points, seriesPoints)
                                });
                                if (target && target.argument === data.argument && target.argumentIndex === data.argumentIndex) {
                                    points.push(target)
                                }
                                callback(function(points) {
                                    let state = NORMAL_STATE;
                                    points.forEach(point => {
                                        var _a;
                                        const seriesOptions = null === (_a = point.series) || void 0 === _a ? void 0 : _a.getOptions();
                                        let pointState = point.fullState;
                                        if ("none" === (null === seriesOptions || void 0 === seriesOptions ? void 0 : seriesOptions.hoverMode)) {
                                            pointState &= ~HOVER_STATE
                                        }
                                        if ("none" === (null === seriesOptions || void 0 === seriesOptions ? void 0 : seriesOptions.selectionMode)) {
                                            pointState &= ~SELECTED_STATE
                                        }
                                        state |= pointState
                                    });
                                    return LEGEND_ACTIONS[state]
                                }(points))
                            })
                        }
                    },
                    _locateLabels(resolveLabelOverlapping) {
                        let iterationCount = 0;
                        let labelsWereOverlapped;
                        let wordWrapApplied;
                        do {
                            wordWrapApplied = this._adjustSeriesLabels("shift" === resolveLabelOverlapping);
                            labelsWereOverlapped = this._resolveLabelOverlapping(resolveLabelOverlapping)
                        } while ((labelsWereOverlapped || wordWrapApplied) && ++iterationCount < 5)
                    },
                    _adjustSeriesLabels(moveLabelsFromCenter) {
                        return this.series.reduce((r, s) => s.adjustLabels(moveLabelsFromCenter) || r, false)
                    },
                    _applyExtraSettings: _common.noop,
                    _resolveLabelOverlappingShift() {
                        const inverseDirection = "anticlockwise" === this.option("segmentsDirection");
                        const seriesByPosition = this.series.reduce((r, s) => {
                            (r[s.getOptions().label.position] || r.outside).push(s);
                            return r
                        }, {
                            inside: [],
                            columns: [],
                            outside: []
                        });
                        let labelsOverlapped = false;
                        const shiftFunction = (box, length) => (0, _utils.getVerticallyShiftedAngularCoords)(box, -length, this._center);
                        if (seriesByPosition.inside.length > 0) {
                            const pointsToResolve = seriesByPosition.inside.reduce((r, singleSeries) => {
                                const visiblePoints = singleSeries.getVisiblePoints();
                                return visiblePoints.reduce((r, point) => {
                                    r.left.push(point);
                                    return r
                                }, r)
                            }, {
                                left: [],
                                right: []
                            });
                            labelsOverlapped = resolveOverlappedLabels(pointsToResolve, shiftInColumnFunction, inverseDirection, this._canvas) || labelsOverlapped
                        }
                        labelsOverlapped = seriesByPosition.columns.reduce((r, singleSeries) => resolveOverlappedLabels(dividePoints(singleSeries), shiftInColumnFunction, inverseDirection, this._canvas) || r, labelsOverlapped);
                        if (seriesByPosition.outside.length > 0) {
                            labelsOverlapped = resolveOverlappedLabels(seriesByPosition.outside.reduce((r, singleSeries) => dividePoints(singleSeries, r), null), shiftFunction, inverseDirection, this._canvas) || labelsOverlapped
                        }
                        return labelsOverlapped
                    },
                    _setGeometry(_ref) {
                        let {
                            centerX: x,
                            centerY: y,
                            radiusInner: radiusInner
                        } = _ref;
                        this._center = {
                            x: x,
                            y: y
                        };
                        this._innerRadius = radiusInner
                    },
                    _disposeSeries() {
                        this.callBase.apply(this, arguments);
                        this._abstractSeries = null
                    },
                    _legendDataField: "point",
                    _legendItemTextField: "argument",
                    _applyPointMarkersAutoHiding: _common.noop,
                    _renderTrackers: _common.noop,
                    _trackerType: "PieTracker",
                    _createScrollBar: _common.noop,
                    _updateAxesLayout: _common.noop,
                    _applyClipRects: _common.noop,
                    _appendAdditionalSeriesGroups: _common.noop,
                    _prepareToRender: _common.noop,
                    _isLegendInside: _common.noop,
                    _renderAxes: _common.noop,
                    _shrinkAxes: _common.noop,
                    _isRotated: _common.noop,
                    _seriesPopulatedHandlerCore: _common.noop,
                    _reinitAxes: _common.noop,
                    _correctAxes: _common.noop,
                    _getExtraOptions() {
                        return {
                            startAngle: this.option("startAngle"),
                            innerRadius: this.option("innerRadius"),
                            segmentsDirection: this.option("segmentsDirection"),
                            type: this.option("type")
                        }
                    },
                    getSizeGroup() {
                        return this._themeManager.getOptions("sizeGroup")
                    },
                    getSizeGroupLayout() {
                        return this._sizeGroupLayout || {}
                    }
                });
                (0, _iterator.each)(["startAngle", "innerRadius", "segmentsDirection", "type"], (_, name) => {
                    dxPieChart.prototype._optionChangesMap[name] = "REFRESH_SERIES_DATA_INIT"
                });
                dxPieChart.addPlugin(_center_template.plugins.pieChart);
                dxPieChart.addPlugin(_annotations.plugins.core);
                dxPieChart.addPlugin(_annotations.plugins.pieChart);
                (0, _component_registrator.default)("dxPieChart", dxPieChart);
                var _default = dxPieChart;
                exports.default = _default
            },
        86139:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_polar_chart.js ***!
              \*****************************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = (obj = __webpack_require__( /*! ../../core/component_registrator */ 99393), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 20576);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 35922);
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77129);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 19157);
                var _m_advanced_chart = __webpack_require__( /*! ./chart_components/m_advanced_chart */ 41690);
                const dxPolarChart = _m_advanced_chart.AdvancedChart.inherit({
                    _themeSection: "polar",
                    _createPanes() {
                        this.callBase();
                        return [{
                            name: "default"
                        }]
                    },
                    _checkPaneName: () => true,
                    _getAxisRenderingOptions(typeSelector) {
                        const isArgumentAxis = "argumentAxis" === typeSelector;
                        let type = isArgumentAxis ? "circular" : "linear";
                        const useSpiderWeb = this.option("useSpiderWeb");
                        if (useSpiderWeb) {
                            type += "Spider"
                        }
                        return {
                            axisType: "polarAxes",
                            drawingType: type
                        }
                    },
                    _executeAppendBeforeSeries(append) {
                        append()
                    },
                    _prepareAxisOptions(typeSelector, axisOptions) {
                        const isArgumentAxis = "argumentAxis" === typeSelector;
                        const themeManager = this._themeManager;
                        const axisUserOptions = this.option("argumentAxis");
                        const argumentAxisOptions = themeManager.getOptions("argumentAxis", axisUserOptions) || {};
                        const startAngle = isFinite(argumentAxisOptions.startAngle) ? (0, _utils.normalizeAngle)(argumentAxisOptions.startAngle) : 0;
                        return {
                            type: this.option("useSpiderWeb") && isArgumentAxis ? "discrete" : axisOptions.type,
                            isHorizontal: true,
                            showCustomBoundaryTicks: isArgumentAxis,
                            startAngle: startAngle,
                            endAngle: startAngle + 360
                        }
                    },
                    _optionChangesMap: {
                        useSpiderWeb: "USE_SPIDER_WEB"
                    },
                    _change_USE_SPIDER_WEB() {
                        this._disposeAxes();
                        this._requestChange(["AXES_AND_PANES"])
                    },
                    _getExtraOptions() {
                        return {
                            spiderWidget: this.option("useSpiderWeb")
                        }
                    },
                    _prepareToRender() {
                        this._appendAxesGroups();
                        return {}
                    },
                    _calcCanvas() {
                        const canvas = (0, _extend.extend)({}, this._canvas);
                        const argumentAxis = this.getArgumentAxis();
                        const margins = argumentAxis.getMargins();
                        Object.keys(margins).forEach(margin => {
                            canvas[margin] = canvas["original".concat(margin[0].toUpperCase()).concat(margin.slice(1))] + margins[margin]
                        });
                        return canvas
                    },
                    _renderAxes() {
                        const valueAxis = this._getValueAxis();
                        const argumentAxis = this.getArgumentAxis();
                        argumentAxis.draw(this._canvas);
                        valueAxis.setSpiderTicks(argumentAxis.getSpiderTicks());
                        const canvas = this._calcCanvas();
                        argumentAxis.updateSize(canvas);
                        valueAxis.draw(canvas);
                        return canvas
                    },
                    _getValueAxis() {
                        return this._valueAxes[0]
                    },
                    _shrinkAxes(sizeStorage) {
                        const valueAxis = this._getValueAxis();
                        const argumentAxis = this.getArgumentAxis();
                        if (sizeStorage && (sizeStorage.width || sizeStorage.height)) {
                            argumentAxis.hideOuterElements();
                            const canvas = this._calcCanvas();
                            argumentAxis.updateSize(canvas);
                            valueAxis.updateSize(canvas)
                        }
                    },
                    checkForMoreSpaceForPanesCanvas() {
                        return this.layoutManager.needMoreSpaceForPanesCanvas([{
                            canvas: this.getArgumentAxis().getCanvas()
                        }], this._isRotated())
                    },
                    _getLayoutTargets() {
                        return [{
                            canvas: this._canvas
                        }]
                    },
                    _getSeriesForPane() {
                        return this.series
                    },
                    _applyClipRects() {
                        const canvasClipRectID = this._getCanvasClipRectID();
                        this._createClipPathForPane();
                        this.getArgumentAxis().applyClipRects(this._getElementsClipRectID(), canvasClipRectID);
                        this._getValueAxis().applyClipRects(this._getElementsClipRectID(), canvasClipRectID)
                    },
                    _createClipPathForPane() {
                        const valueAxis = this._getValueAxis();
                        let center = valueAxis.getCenter();
                        const radius = valueAxis.getRadius();
                        const panesClipRects = this._panesClipRects;
                        center = {
                            x: Math.round(center.x),
                            y: Math.round(center.y)
                        };
                        this._createClipCircle(panesClipRects.fixed, center.x, center.y, radius);
                        this._createClipCircle(panesClipRects.base, center.x, center.y, radius);
                        if (this.series.some(s => s.areErrorBarsVisible())) {
                            this._createClipCircle(panesClipRects.wide, center.x, center.y, radius)
                        } else {
                            panesClipRects.wide[0] = null
                        }
                    },
                    _createClipCircle(clipArray, left, top, radius) {
                        let clipCircle = clipArray[0];
                        if (!clipCircle) {
                            clipCircle = this._renderer.clipCircle(left, top, radius);
                            clipArray[0] = clipCircle
                        } else {
                            clipCircle.attr({
                                cx: left,
                                cy: top,
                                r: radius
                            })
                        }
                    },
                    _applyExtraSettings(series) {
                        const wideClipRect = this._panesClipRects.wide[0];
                        series.setClippingParams(this._panesClipRects.base[0].id, wideClipRect && wideClipRect.id, false, false)
                    },
                    getActualAngle(angle) {
                        return this.getArgumentAxis().getOptions().inverted ? 360 - angle : angle
                    },
                    getXYFromPolar(angle, radius, argument, value) {
                        const layoutInfo = {
                            angle: void 0,
                            radius: void 0,
                            x: void 0,
                            y: void 0
                        };
                        if (!(0, _type.isDefined)(angle) && !(0, _type.isDefined)(radius) && !(0, _type.isDefined)(argument) && !(0, _type.isDefined)(value)) {
                            return layoutInfo
                        }
                        const argAxis = this.getArgumentAxis();
                        const startAngle = argAxis.getAngles()[0];
                        let argAngle;
                        let translatedRadius;
                        if ((0, _type.isDefined)(argument)) {
                            argAngle = argAxis.getTranslator().translate(argument)
                        } else if (isFinite(angle)) {
                            argAngle = this.getActualAngle(angle)
                        } else if (!(0, _type.isDefined)(angle)) {
                            argAngle = 0
                        }
                        if ((0, _type.isDefined)(value)) {
                            translatedRadius = this.getValueAxis().getTranslator().translate(value)
                        } else if (isFinite(radius)) {
                            translatedRadius = radius
                        } else if (!(0, _type.isDefined)(radius)) {
                            translatedRadius = argAxis.getRadius()
                        }
                        if ((0, _type.isDefined)(argAngle) && (0, _type.isDefined)(translatedRadius)) {
                            const coords = (0, _utils.convertPolarToXY)(argAxis.getCenter(), startAngle, argAngle, translatedRadius);
                            (0, _extend.extend)(layoutInfo, coords, {
                                angle: argAxis.getTranslatedAngle(argAngle),
                                radius: translatedRadius
                            })
                        }
                        return layoutInfo
                    },
                    _applyPointMarkersAutoHiding: _common.noop,
                    _createScrollBar: _common.noop,
                    _isRotated: _common.noop,
                    _getCrosshairOptions: _common.noop,
                    _isLegendInside: _common.noop
                });
                dxPolarChart.addPlugin(_annotations.plugins.core);
                dxPolarChart.addPlugin(_annotations.plugins.polarChart);
                (0, _component_registrator.default)("dxPolarChart", dxPolarChart);
                var _default = dxPolarChart;
                exports.default = _default
            },
        23908:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/easing.js ***!
              \*****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.convertTransitionTimingFuncToEasing = void 0;
                exports.getEasing = function(name) {
                    return easing[name]
                };
                exports.setEasing = function(value) {
                    easing = value
                };
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                const CSS_TRANSITION_EASING_REGEX = /cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/;
                const TransitionTimingFuncMap = {
                    linear: "cubic-bezier(0, 0, 1, 1)",
                    swing: "cubic-bezier(0.445, 0.05, 0.55, 0.95)",
                    ease: "cubic-bezier(0.25, 0.1, 0.25, 1)",
                    "ease-in": "cubic-bezier(0.42, 0, 1, 1)",
                    "ease-out": "cubic-bezier(0, 0, 0.58, 1)",
                    "ease-in-out": "cubic-bezier(0.42, 0, 0.58, 1)"
                };
                const polynomBezier = function(x1, y1, x2, y2) {
                    const Cx = 3 * x1;
                    const Bx = 3 * (x2 - x1) - Cx;
                    const Ax = 1 - Cx - Bx;
                    const Cy = 3 * y1;
                    const By = 3 * (y2 - y1) - Cy;
                    const Ay = 1 - Cy - By;
                    const bezierX = function(t) {
                        return t * (Cx + t * (Bx + t * Ax))
                    };
                    const derivativeX = function(t) {
                        return Cx + t * (2 * Bx + 3 * t * Ax)
                    };
                    return function(t) {
                        return function(t) {
                            return t * (Cy + t * (By + t * Ay))
                        }(function(t) {
                            let x = t;
                            let i = 0;
                            let z;
                            while (i < 14) {
                                z = bezierX(x) - t;
                                if (Math.abs(z) < .001) {
                                    break
                                }
                                x -= z / derivativeX(x);
                                i++
                            }
                            return x
                        }(t))
                    }
                };
                let easing = {};
                exports.convertTransitionTimingFuncToEasing = function(cssTransitionEasing) {
                    cssTransitionEasing = TransitionTimingFuncMap[cssTransitionEasing] || cssTransitionEasing;
                    let coeffs = cssTransitionEasing.match(CSS_TRANSITION_EASING_REGEX);
                    let forceName;
                    if (!coeffs) {
                        forceName = "linear";
                        coeffs = TransitionTimingFuncMap[forceName].match(CSS_TRANSITION_EASING_REGEX)
                    }
                    coeffs = coeffs.slice(1, 5);
                    for (let i = 0; i < coeffs.length; i++) {
                        coeffs[i] = parseFloat(coeffs[i])
                    }
                    const easingName = forceName || "cubicbezier_" + coeffs.join("_").replace(/\./g, "p");
                    if (!(0, _type.isFunction)(easing[easingName])) {
                        easing[easingName] = function(x, t, b, c, d) {
                            return c * polynomBezier(coeffs[0], coeffs[1], coeffs[2], coeffs[3])(t / d) + b
                        }
                    }
                    return easingName
                }
            },
        90057:
            /*!****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/frame.js ***!
              \****************************************************************/
            function(__unused_webpack_module, exports, __webpack_require__) {
                exports.cancelAnimationFrame = function() {
                    setAnimationFrameMethods();
                    cancel.apply(window, arguments)
                };
                exports.requestAnimationFrame = function() {
                    setAnimationFrameMethods();
                    return request.apply(window, arguments)
                };
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _call_once = (obj = __webpack_require__( /*! ../core/utils/call_once */ 39618), obj && obj.__esModule ? obj : {
                    default: obj
                });
                var obj;
                const window = (0, _window.hasWindow)() ? (0, _window.getWindow)() : {};
                let request = function(callback) {
                    return setTimeout(callback, 1e3 / 60)
                };
                let cancel = function(requestID) {
                    clearTimeout(requestID)
                };
                const setAnimationFrameMethods = (0, _call_once.default)((function() {
                    const nativeRequest = window.requestAnimationFrame || window.webkitRequestAnimationFrame || window.mozRequestAnimationFrame || window.oRequestAnimationFrame || window.msRequestAnimationFrame;
                    const nativeCancel = window.cancelAnimationFrame || window.webkitCancelAnimationFrame || window.mozCancelAnimationFrame || window.oCancelAnimationFrame || window.msCancelAnimationFrame;
                    if (nativeRequest && nativeCancel) {
                        request = nativeRequest;
                        cancel = nativeCancel
                    }
                }))
            },
        87209:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/fx.js ***!
              \*************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../events/core/events_engine */ 55994));
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../core/errors */ 17381));
                var _element = __webpack_require__( /*! ../core/element */ 6415);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _easing = __webpack_require__( /*! ./easing */ 23908);
                var _frame = __webpack_require__( /*! ./frame */ 90057);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _position = _interopRequireDefault(__webpack_require__( /*! ./position */ 49387));
                var _remove = __webpack_require__( /*! ../events/remove */ 29007);
                var _index = __webpack_require__( /*! ../events/utils/index */ 39611);
                var _deferred = __webpack_require__( /*! ../core/utils/deferred */ 62754);
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                const removeEventName = (0, _index.addNamespace)(_remove.removeEvent, "dxFX");
                const RELATIVE_VALUE_REGEX = /^([+-])=(.*)/i;
                const TransitionAnimationStrategy = {
                    initAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "none"
                        });
                        if ("string" === typeof config.from) {
                            $element.addClass(config.from)
                        } else {
                            setProps($element, config.from)
                        }
                        const that = this;
                        const deferred = new _deferred.Deferred;
                        const cleanupWhen = config.cleanupWhen;
                        config.transitionAnimation = {
                            deferred: deferred,
                            finish: function() {
                                that._finishTransition($element);
                                if (cleanupWhen) {
                                    (0, _deferred.when)(deferred, cleanupWhen).always((function() {
                                        that._cleanup($element, config)
                                    }))
                                } else {
                                    that._cleanup($element, config)
                                }
                                deferred.resolveWith($element, [config, $element])
                            }
                        };
                        this._completeAnimationCallback($element, config).done((function() {
                            config.transitionAnimation.finish()
                        })).fail((function() {
                            deferred.rejectWith($element, [config, $element])
                        }));
                        if (!config.duration) {
                            config.transitionAnimation.finish()
                        }
                        $element.css("transform")
                    },
                    animate: function($element, config) {
                        this._startAnimation($element, config);
                        return config.transitionAnimation.deferred.promise()
                    },
                    _completeAnimationCallback: function($element, config) {
                        const that = this;
                        const startTime = Date.now() + config.delay;
                        const deferred = new _deferred.Deferred;
                        const transitionEndFired = new _deferred.Deferred;
                        const simulatedTransitionEndFired = new _deferred.Deferred;
                        let simulatedEndEventTimer;
                        const transitionEndEventFullName = (0, _support.transitionEndEventName)() + ".dxFX";
                        config.transitionAnimation.cleanup = function() {
                            clearTimeout(simulatedEndEventTimer);
                            clearTimeout(waitForJSCompleteTimer);
                            _events_engine.default.off($element, transitionEndEventFullName);
                            _events_engine.default.off($element, removeEventName)
                        };
                        _events_engine.default.one($element, transitionEndEventFullName, (function() {
                            if (Date.now() - startTime >= config.duration) {
                                transitionEndFired.reject()
                            }
                        }));
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            that.stop($element, config);
                            deferred.reject()
                        }));
                        const waitForJSCompleteTimer = setTimeout((function() {
                            simulatedEndEventTimer = setTimeout((function() {
                                simulatedTransitionEndFired.reject()
                            }), config.duration + config.delay + fx._simulatedTransitionEndDelay);
                            (0, _deferred.when)(transitionEndFired, simulatedTransitionEndFired).fail(function() {
                                deferred.resolve()
                            }.bind(this))
                        }));
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        $element.css({
                            transitionProperty: "all",
                            transitionDelay: config.delay + "ms",
                            transitionDuration: config.duration + "ms",
                            transitionTimingFunction: config.easing
                        });
                        if ("string" === typeof config.to) {
                            $element[0].className += " " + config.to
                        } else if (config.to) {
                            setProps($element, config.to)
                        }
                    },
                    _finishTransition: function($element) {
                        $element.css("transition", "none")
                    },
                    _cleanup: function($element, config) {
                        config.transitionAnimation.cleanup();
                        if ("string" === typeof config.from) {
                            $element.removeClass(config.from);
                            $element.removeClass(config.to)
                        }
                    },
                    stop: function($element, config, jumpToEnd) {
                        if (!config) {
                            return
                        }
                        if (jumpToEnd) {
                            config.transitionAnimation.finish()
                        } else {
                            if ((0, _type.isPlainObject)(config.to)) {
                                (0, _iterator.each)(config.to, (function(key) {
                                    $element.css(key, $element.css(key))
                                }))
                            }
                            this._finishTransition($element);
                            this._cleanup($element, config)
                        }
                    }
                };
                const FrameAnimationStrategy = {
                    initAnimation: function($element, config) {
                        setProps($element, config.from)
                    },
                    animate: function($element, config) {
                        const deferred = new _deferred.Deferred;
                        const that = this;
                        if (!config) {
                            return deferred.reject().promise()
                        }(0, _iterator.each)(config.to, (function(prop) {
                            if (void 0 === config.from[prop]) {
                                config.from[prop] = that._normalizeValue($element.css(prop))
                            }
                        }));
                        if (config.to.transform) {
                            config.from.transform = that._parseTransform(config.from.transform);
                            config.to.transform = that._parseTransform(config.to.transform)
                        }
                        config.frameAnimation = {
                            to: config.to,
                            from: config.from,
                            currentValue: config.from,
                            easing: (0, _easing.convertTransitionTimingFuncToEasing)(config.easing),
                            duration: config.duration,
                            startTime: (new Date).valueOf(),
                            finish: function() {
                                this.currentValue = this.to;
                                this.draw();
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId);
                                deferred.resolve()
                            },
                            draw: function() {
                                if (config.draw) {
                                    config.draw(this.currentValue);
                                    return
                                }
                                const currentValue = (0, _extend.extend)({}, this.currentValue);
                                if (currentValue.transform) {
                                    currentValue.transform = (0, _iterator.map)(currentValue.transform, (function(value, prop) {
                                        if ("translate" === prop) {
                                            return (0, _translator.getTranslateCss)(value)
                                        } else if ("scale" === prop) {
                                            return "scale(" + value + ")"
                                        } else if ("rotate" === prop.substr(0, prop.length - 1)) {
                                            return prop + "(" + value + "deg)"
                                        }
                                    })).join(" ")
                                }
                                $element.css(currentValue)
                            }
                        };
                        if (config.delay) {
                            config.frameAnimation.startTime += config.delay;
                            config.frameAnimation.delayTimeout = setTimeout((function() {
                                that._startAnimation($element, config)
                            }), config.delay)
                        } else {
                            that._startAnimation($element, config)
                        }
                        return deferred.promise()
                    },
                    _startAnimation: function($element, config) {
                        _events_engine.default.off($element, removeEventName);
                        _events_engine.default.on($element, removeEventName, (function() {
                            if (config.frameAnimation) {
                                (0, _frame.cancelAnimationFrame)(config.frameAnimation.animationFrameId)
                            }
                        }));
                        this._animationStep($element, config)
                    },
                    _parseTransform: function(transformString) {
                        const result = {};
                        (0, _iterator.each)(transformString.match(/\w+\d*\w*\([^)]*\)\s*/g), (function(i, part) {
                            const translateData = (0, _translator.parseTranslate)(part);
                            const scaleData = part.match(/scale\((.+?)\)/);
                            const rotateData = part.match(/(rotate.)\((.+)deg\)/);
                            if (translateData) {
                                result.translate = translateData
                            }
                            if (scaleData && scaleData[1]) {
                                result.scale = parseFloat(scaleData[1])
                            }
                            if (rotateData && rotateData[1]) {
                                result[rotateData[1]] = parseFloat(rotateData[2])
                            }
                        }));
                        return result
                    },
                    stop: function($element, config, jumpToEnd) {
                        const frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }(0, _frame.cancelAnimationFrame)(frameAnimation.animationFrameId);
                        clearTimeout(frameAnimation.delayTimeout);
                        if (jumpToEnd) {
                            frameAnimation.finish()
                        }
                        delete config.frameAnimation
                    },
                    _animationStep: function($element, config) {
                        const frameAnimation = config && config.frameAnimation;
                        if (!frameAnimation) {
                            return
                        }
                        const now = (new Date).valueOf();
                        if (now >= frameAnimation.startTime + frameAnimation.duration) {
                            frameAnimation.finish();
                            return
                        }
                        frameAnimation.currentValue = this._calcStepValue(frameAnimation, now - frameAnimation.startTime);
                        frameAnimation.draw();
                        const that = this;
                        frameAnimation.animationFrameId = (0, _frame.requestAnimationFrame)((function() {
                            that._animationStep($element, config)
                        }))
                    },
                    _calcStepValue: function(frameAnimation, currentDuration) {
                        const calcValueRecursively = function(from, to) {
                            const result = Array.isArray(to) ? [] : {};
                            (0, _iterator.each)(to, (function(propName, endPropValue) {
                                if ("string" === typeof endPropValue && false === parseFloat(endPropValue)) {
                                    return true
                                }
                                result[propName] = "object" === typeof endPropValue ? calcValueRecursively(from[propName], endPropValue) : function(propName) {
                                    const x = currentDuration / frameAnimation.duration;
                                    const t = currentDuration;
                                    const b = 1 * from[propName];
                                    const c = to[propName] - from[propName];
                                    const d = frameAnimation.duration;
                                    return (0, _easing.getEasing)(frameAnimation.easing)(x, t, b, c, d)
                                }(propName)
                            }));
                            return result
                        };
                        return calcValueRecursively(frameAnimation.from, frameAnimation.to)
                    },
                    _normalizeValue: function(value) {
                        const numericValue = parseFloat(value);
                        if (false === numericValue) {
                            return value
                        }
                        return numericValue
                    }
                };
                const FallbackToNoAnimationStrategy = {
                    initAnimation: function() {},
                    animate: function() {
                        return (new _deferred.Deferred).resolve().promise()
                    },
                    stop: _common.noop,
                    isSynchronous: true
                };
                const baseConfigValidator = function(config, animationType, validate, typeMessage) {
                    (0, _iterator.each)(["from", "to"], (function() {
                        if (!validate(config[this])) {
                            throw _errors.default.Error("E0010", animationType, this, typeMessage)
                        }
                    }))
                };
                const isObjectConfigValidator = function(config, animationType) {
                    return baseConfigValidator(config, animationType, (function(target) {
                        return (0, _type.isPlainObject)(target)
                    }), "a plain object")
                };
                const CssAnimationConfigurator = {
                    validateConfig: function(config) {
                        ! function(config, animationType) {
                            return baseConfigValidator(config, animationType, (function(target) {
                                return "string" === typeof target
                            }), "a string")
                        }(config, "css")
                    },
                    setup: function() {}
                };
                const positionAliases = {
                    top: {
                        my: "bottom center",
                        at: "top center"
                    },
                    bottom: {
                        my: "top center",
                        at: "bottom center"
                    },
                    right: {
                        my: "left center",
                        at: "right center"
                    },
                    left: {
                        my: "right center",
                        at: "left center"
                    }
                };
                const SlideAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "slide")
                    },
                    setup: function($element, config) {
                        const location = (0, _translator.locate)($element);
                        if ("slide" !== config.type) {
                            const positioningConfig = "slideIn" === config.type ? config.from : config.to;
                            positioningConfig.position = (0, _extend.extend)({
                                of: window
                            }, positionAliases[config.direction]);
                            setupPosition($element, positioningConfig)
                        }
                        this._setUpConfig(location, config.from);
                        this._setUpConfig(location, config.to);
                        (0, _translator.clearCache)($element)
                    },
                    _setUpConfig: function(location, config) {
                        config.left = "left" in config ? config.left : "+=0";
                        config.top = "top" in config ? config.top : "+=0";
                        this._initNewPosition(location, config)
                    },
                    _initNewPosition: function(location, config) {
                        const position = {
                            left: config.left,
                            top: config.top
                        };
                        delete config.left;
                        delete config.top;
                        let relativeValue = this._getRelativeValue(position.left);
                        if (void 0 !== relativeValue) {
                            position.left = relativeValue + location.left
                        } else {
                            config.left = 0
                        }
                        relativeValue = this._getRelativeValue(position.top);
                        if (void 0 !== relativeValue) {
                            position.top = relativeValue + location.top
                        } else {
                            config.top = 0
                        }
                        config.transform = (0, _translator.getTranslateCss)({
                            x: position.left,
                            y: position.top
                        })
                    },
                    _getRelativeValue: function(value) {
                        let relativeValue;
                        if ("string" === typeof value && (relativeValue = RELATIVE_VALUE_REGEX.exec(value))) {
                            return parseInt(relativeValue[1] + "1") * relativeValue[2]
                        }
                    }
                };
                const FadeAnimationConfigurator = {
                    setup: function($element, config) {
                        var _from$opacity, _to$opacity;
                        const from = config.from;
                        const to = config.to;
                        const defaultFromOpacity = "fadeOut" === config.type ? 1 : 0;
                        const defaultToOpacity = "fadeOut" === config.type ? 0 : 1;
                        let fromOpacity = (0, _type.isPlainObject)(from) ? String(null !== (_from$opacity = from.opacity) && void 0 !== _from$opacity ? _from$opacity : defaultFromOpacity) : String(from);
                        let toOpacity = (0, _type.isPlainObject)(to) ? String(null !== (_to$opacity = to.opacity) && void 0 !== _to$opacity ? _to$opacity : defaultToOpacity) : String(to);
                        if (!config.skipElementInitialStyles) {
                            fromOpacity = $element.css("opacity")
                        }
                        switch (config.type) {
                            case "fadeIn":
                                toOpacity = 1;
                                break;
                            case "fadeOut":
                                toOpacity = 0
                        }
                        config.from = {
                            visibility: "visible",
                            opacity: fromOpacity
                        };
                        config.to = {
                            opacity: toOpacity
                        }
                    }
                };
                const PopAnimationConfigurator = {
                    validateConfig: function(config) {
                        isObjectConfigValidator(config, "pop")
                    },
                    setup: function($element, config) {
                        const from = config.from;
                        const to = config.to;
                        const fromOpacity = "opacity" in from ? from.opacity : $element.css("opacity");
                        const toOpacity = "opacity" in to ? to.opacity : 1;
                        const fromScale = "scale" in from ? from.scale : 0;
                        const toScale = "scale" in to ? to.scale : 1;
                        config.from = {
                            opacity: fromOpacity
                        };
                        const translate = (0, _translator.getTranslate)($element);
                        config.from.transform = this._getCssTransform(translate, fromScale);
                        config.to = {
                            opacity: toOpacity
                        };
                        config.to.transform = this._getCssTransform(translate, toScale)
                    },
                    _getCssTransform: function(translate, scale) {
                        return (0, _translator.getTranslateCss)(translate) + "scale(" + scale + ")"
                    }
                };
                const animationConfigurators = {
                    custom: {
                        setup: function() {}
                    },
                    slide: SlideAnimationConfigurator,
                    slideIn: SlideAnimationConfigurator,
                    slideOut: SlideAnimationConfigurator,
                    fade: FadeAnimationConfigurator,
                    fadeIn: FadeAnimationConfigurator,
                    fadeOut: FadeAnimationConfigurator,
                    pop: PopAnimationConfigurator,
                    css: CssAnimationConfigurator
                };
                const defaultJSConfig = {
                    type: "custom",
                    from: {},
                    to: {},
                    duration: 400,
                    start: _common.noop,
                    complete: _common.noop,
                    easing: "ease",
                    delay: 0
                };
                const defaultCssConfig = {
                    duration: 400,
                    easing: "ease",
                    delay: 0
                };

                function setupAnimationOnElement() {
                    const $element = this.element;
                    const config = this.config;
                    setupPosition($element, config.from);
                    setupPosition($element, config.to);
                    this.configurator.setup($element, config);
                    $element.data("dxAnimData", this);
                    if (fx.off) {
                        config.duration = 0;
                        config.delay = 0
                    }
                    this.strategy.initAnimation($element, config);
                    if (config.start) {
                        const element = (0, _element.getPublicElement)($element);
                        config.start.apply(this, [element, config])
                    }
                }
                const startAnimationOnElement = function() {
                    const animation = this;
                    const $element = animation.element;
                    const config = animation.config;
                    animation.isStarted = true;
                    return animation.strategy.animate($element, config).done((function() {
                        ! function(animation) {
                            const $element = animation.element;
                            const config = animation.config;
                            $element.removeData("dxAnimData");
                            if (config.complete) {
                                const element = (0, _element.getPublicElement)($element);
                                config.complete.apply(this, [element, config])
                            }
                            animation.deferred.resolveWith(this, [$element, config])
                        }(animation)
                    })).fail((function() {
                        animation.deferred.rejectWith(this, [$element, config])
                    }))
                };
                const stopAnimationOnElement = function(jumpToEnd) {
                    const animation = this;
                    const $element = animation.element;
                    const config = animation.config;
                    clearTimeout(animation.startTimeout);
                    if (!animation.isStarted) {
                        animation.start()
                    }
                    animation.strategy.stop($element, config, jumpToEnd)
                };
                const scopedRemoveEvent = (0, _index.addNamespace)(_remove.removeEvent, "dxFXStartAnimation");
                const createAnimation = function(element, initialConfig) {
                    const defaultConfig = "css" === initialConfig.type ? defaultCssConfig : defaultJSConfig;
                    const config = (0, _extend.extend)(true, {}, defaultConfig, initialConfig);
                    const configurator = function(config) {
                        const result = animationConfigurators[config.type];
                        if (!result) {
                            throw _errors.default.Error("E0011", config.type)
                        }
                        return result
                    }(config);
                    const strategy = function(config) {
                        config = config || {};
                        const animationStrategies = {
                            transition: (0, _support.transition)() ? TransitionAnimationStrategy : FrameAnimationStrategy,
                            frame: FrameAnimationStrategy,
                            noAnimation: FallbackToNoAnimationStrategy
                        };
                        let strategy = config.strategy || "transition";
                        if ("css" === config.type && !(0, _support.transition)()) {
                            strategy = "noAnimation"
                        }
                        return animationStrategies[strategy]
                    }(config);
                    const animation = {
                        element: (0, _renderer.default)(element),
                        config: config,
                        configurator: configurator,
                        strategy: strategy,
                        isSynchronous: strategy.isSynchronous,
                        setup: setupAnimationOnElement,
                        start: startAnimationOnElement,
                        stop: stopAnimationOnElement,
                        deferred: new _deferred.Deferred
                    };
                    if ((0, _type.isFunction)(configurator.validateConfig)) {
                        configurator.validateConfig(config)
                    }! function(animation) {
                        _events_engine.default.off(animation.element, scopedRemoveEvent);
                        _events_engine.default.on(animation.element, scopedRemoveEvent, (function() {
                            fx.stop(animation.element)
                        }));
                        animation.deferred.always((function() {
                            _events_engine.default.off(animation.element, scopedRemoveEvent)
                        }))
                    }(animation);
                    return animation
                };

                function getAnimQueueData($element) {
                    return $element.data("dxAnimQueue") || []
                }
                const destroyAnimQueueData = function($element) {
                    $element.removeData("dxAnimQueue")
                };

                function isAnimating($element) {
                    return !!$element.data("dxAnimData")
                }

                function shiftFromAnimationQueue($element, queueData) {
                    queueData = getAnimQueueData($element);
                    if (!queueData.length) {
                        return
                    }
                    const animation = queueData.shift();
                    if (0 === queueData.length) {
                        destroyAnimQueueData($element)
                    }(function(animation) {
                        animation.setup();
                        if (fx.off || animation.isSynchronous) {
                            animation.start()
                        } else {
                            animation.startTimeout = setTimeout((function() {
                                animation.start()
                            }))
                        }
                        return animation.deferred.promise()
                    })(animation).done((function() {
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element)
                        }
                    }))
                }

                function setupPosition($element, config) {
                    if (!config || !config.position) {
                        return
                    }
                    const win = (0, _renderer.default)(window);
                    let left = 0;
                    let top = 0;
                    const position = _position.default.calculate($element, config.position);
                    const offset = $element.offset();
                    const currentPosition = $element.position();
                    if (currentPosition.top > offset.top) {
                        top = win.scrollTop()
                    }
                    if (currentPosition.left > offset.left) {
                        left = win.scrollLeft()
                    }(0, _extend.extend)(config, {
                        left: position.h.location - offset.left + currentPosition.left - left,
                        top: position.v.location - offset.top + currentPosition.top - top
                    });
                    delete config.position
                }

                function setProps($element, props) {
                    (0, _iterator.each)(props, (function(key, value) {
                        try {
                            $element.css(key, (0, _type.isFunction)(value) ? value() : value)
                        } catch (e) {}
                    }))
                }
                const fx = {
                    off: false,
                    animationTypes: animationConfigurators,
                    animate: function(element, config) {
                        const $element = (0, _renderer.default)(element);
                        if (!$element.length) {
                            return (new _deferred.Deferred).resolve().promise()
                        }
                        const animation = createAnimation($element, config);
                        ! function($element, animation) {
                            const queueData = getAnimQueueData($element);
                            ! function($element, queueData) {
                                $element.data("dxAnimQueue", queueData)
                            }($element, queueData);
                            queueData.push(animation);
                            if (!isAnimating($element)) {
                                shiftFromAnimationQueue($element, queueData)
                            }
                        }($element, animation);
                        return animation.deferred.promise()
                    },
                    createAnimation: createAnimation,
                    isAnimating: isAnimating,
                    stop: function(element, jumpToEnd) {
                        const $element = (0, _renderer.default)(element);
                        const queueData = getAnimQueueData($element);
                        (0, _iterator.each)(queueData, (function(_, animation) {
                            animation.config.delay = 0;
                            animation.config.duration = 0;
                            animation.isSynchronous = true
                        }));
                        if (!isAnimating($element)) {
                            shiftFromAnimationQueue($element, queueData)
                        }
                        const animation = $element.data("dxAnimData");
                        if (animation) {
                            animation.stop(jumpToEnd)
                        }
                        $element.removeData("dxAnimData");
                        destroyAnimQueueData($element)
                    },
                    _simulatedTransitionEndDelay: 100
                };
                var _default = fx;
                exports.default = _default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        49387:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/animation/position.js ***!
              \*******************************************************************/
            function(module, exports, __webpack_require__) {
                exports.default = void 0;
                var _size = __webpack_require__( /*! ../core/utils/size */ 58664);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../core/renderer */ 68374));
                var _common = __webpack_require__( /*! ../core/utils/common */ 20576);
                var _iterator = __webpack_require__( /*! ../core/utils/iterator */ 95479);
                var _window = __webpack_require__( /*! ../core/utils/window */ 58201);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../core/dom_adapter */ 73349));
                var _type = __webpack_require__( /*! ../core/utils/type */ 35922);
                var _extend = __webpack_require__( /*! ../core/utils/extend */ 13306);
                var _position = __webpack_require__( /*! ../core/utils/position */ 37518);
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../core/utils/browser */ 47810));
                var _translator = __webpack_require__( /*! ./translator */ 31648);
                var _support = __webpack_require__( /*! ../core/utils/support */ 60137);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../core/devices */ 20530));
                var _style = __webpack_require__( /*! ../core/utils/style */ 80968);

                function _interopRequireDefault(obj) {
                    return obj && obj.__esModule ? obj : {
                        default: obj
                    }
                }
                const window = (0, _window.getWindow)();
                const horzRe = /left|right/;
                const vertRe = /top|bottom/;
                const collisionRe = /fit|flip|none/;
                const scaleRe = /scale\(.+?\)/;
                const IS_SAFARI = _browser.default.safari;
                const normalizeAlign = function(raw) {
                    const result = {
                        h: "center",
                        v: "center"
                    };
                    const pair = (0, _common.splitPair)(raw);
                    if (pair) {
                        (0, _iterator.each)(pair, (function() {
                            const w = String(this).toLowerCase();
                            if (horzRe.test(w)) {
                                result.h = w
                            } else if (vertRe.test(w)) {
                                result.v = w
                            }
                        }))
                    }
                    return result
                };
                const normalizeOffset = function(raw, preventRound) {
                    return (0, _common.pairToObject)(raw, preventRound)
                };
                const getAlignFactor = function(align) {
                    switch (align) {
                        case "center":
                            return .5;
                        case "right":
                        case "bottom":
                            return 1;
                        default:
                            return 0
                    }
                };
                const inverseAlign = function(align) {
                    switch (align) {
                        case "left":
                            return "right";
                        case "right":
                            return "left";
                        case "top":
                            return "bottom";
                        case "bottom":
                            return "top";
                        default:
                            return align
                    }
                };
                const calculateOversize = function(data, bounds) {
                    let oversize = 0;
                    if (data.myLocation < bounds.min) {
                        oversize += bounds.min - data.myLocation
                    }
                    if (data.myLocation > bounds.max) {
                        oversize += data.myLocation - bounds.max
                    }
                    return oversize
                };
                const collisionSide = function(direction, data, bounds) {
                    if (data.myLocation < bounds.min) {
                        return "h" === direction ? "left" : "top"
                    }
                    if (data.myLocation > bounds.max) {
                        return "h" === direction ? "right" : "bottom"
                    }
                    return "none"
                };
                const initMyLocation = function(data) {
                    data.myLocation = data.atLocation + getAlignFactor(data.atAlign) * data.atSize - getAlignFactor(data.myAlign) * data.mySize + data.offset
                };
                const collisionResolvers = {
                    fit: function(data, bounds) {
                        let result = false;
                        if (data.myLocation > bounds.max) {
                            data.myLocation = bounds.max;
                            result = true
                        }
                        if (data.myLocation < bounds.min) {
                            data.myLocation = bounds.min;
                            result = true
                        }
                        data.fit = result
                    },
                    flip: function(data, bounds) {
                        data.flip = false;
                        if ("center" === data.myAlign && "center" === data.atAlign) {
                            return
                        }
                        if (data.myLocation < bounds.min || data.myLocation > bounds.max) {
                            const inverseData = (0, _extend.extend)({}, data, {
                                myAlign: inverseAlign(data.myAlign),
                                atAlign: inverseAlign(data.atAlign),
                                offset: -data.offset
                            });
                            initMyLocation(inverseData);
                            inverseData.oversize = calculateOversize(inverseData, bounds);
                            