// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe PopupFrame: rappresenta la base di tutti gli
// oggetti che appaiono in un contesto "popup"
// ************************************************

function PopupFrame(pform, owner)
{
  // Proprieta' di questo oggetto di modello
  // Sono le proprieta' base di tutti i frame
  this.Left = 0;            // Posizione del frame nella finestra browser
  this.Top = 0;             // Posizione del frame nella finestra browser
  this.Width = 0;           // Dimensioni del frame nella finestra browser
  this.Height = 0;          // Dimensioni del frame nella finestra browser
  this.Centered = true;     // Centrato nella finestra?
  this.Modal = true;        // Modalita' modale attiva?
  this.AutoClose = false;   // Permette all'utente di chiudere cliccando fuori
  this.ModalAnim = false;   // Forza animazione di form modale (dal basso)
  this.HasCaption = true;   // Ha la caption?
  this.WepClick = true;     // Avvisa il webentrypoint dei click?
  this.CanMove = true;      // Finestra spostabile?
  this.CanResize = false;               // Finestra ridimensionabile? (no di default..)
  this.Borders = 0;                     // RD3_Glb.BORDER_DEFAULT // Tipo di bordo della form popup
  //
  // Identificatore di questo oggetto, creato di default solo se non e' gia' 
  // gia' stato creato dalla classe che lo estende
  if (!this.Identifier)
    this.Identifier = "POPUP" + Math.floor(Math.random() * 1000);
  //
  // Variabili di collegamento con il DOM
  this.Realized = false;  // Se vero, gli oggetti del DOM sono gia' stati creati
  this.NoOpacity = true;  // Le finestre di popup non vogliono la trasparenza durante il D&D
  //
  // Oggetti visuali riguardanti la form
  this.PopupBox = null;   // Div globale del popup
  this.CoverBox = null;   // Div che copre totalmente il popup usato quando inattivo
  this.ModalBox = null;   // Div per bloccare l'input alle finestre sottostanti
  //
  this.CaptionBox = null; // Div che contiene la barra del titolo
  this.ContentBox = null; // Div che contiene il contenuto del frame
  //
  // Variabili per la gestione del bordo arrotondato
  this.CornerTL = null;     // Div con l'angolo da mostrare in alto a sinistra
  this.CornerTR = null;     // Div con l'angolo da mostrare in alto a destra
  this.CornerBL = null;     // Div con l'angolo da mostrare in basso a sinistra
  this.CornerBR = null;     // Div con l'angolo da mostrare in basso a destra
  this.BorderTop = null;    // Div con il bordo in alto
  this.BorderBottom = null; // Div con il bordo in basso
  this.BorderLeft = null;   // Div con il bordo a sinistra
  this.BorderRight = null;  // Div con il bordo a destra
  //
  // Variabili per la gestione del fuoco (caso MODALE)
  this.LastActiveObject = null;  // Oggetto che aveva il fuoco all'apertura della popup
  this.LastActiveElement = null; // Elemento che aveva il fuoco all'apertura della popup
  //
  this.TheForm = (pform)?pform:null; // Webform contenuta in questo popup
  this.Owner = owner;                // Oggetto che possiede la popup (non la form)
  this.ObjToAttach = null;           // Oggetto DOM a cui attaccarsi (per posizionamento e baffo) - puo' anche essere un Object contenente x e y (Point) - vedi Command::Popup
}


// ***************************************************************
// Setter delle proprieta'
// ***************************************************************
PopupFrame.prototype.SetLeft = function(value)
{
  if (value!=undefined)
    this.Left = value;
}

PopupFrame.prototype.SetTop = function(value)
{
  if (value!=undefined)
    this.Top = value;
}

PopupFrame.prototype.SetWidth = function(value)
{
  if (value!=undefined)
    this.Width = value;
  //
  if (this.Realized && this.Width > 0)
    this.ContentBox.style.width = this.Width + "px";
}

PopupFrame.prototype.SetHeight = function(value)
{
  if (value!=undefined)
    this.Height = value;
  //
  if (this.Realized && this.Height > 0)
    this.ContentBox.style.height = this.Height + "px";
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// hidden : true per le popup delay a doppia comparsa, non devo subito fare l'animazione
// ***************************************************************
PopupFrame.prototype.Realize = function(cls, hidden)
{
  if (!RD3_Glb.IsMobile())
    cls="";
  this.Classe = cls;
  //
  // Creo il popup-box e lo aggiungo "prima" al DOM
  this.PopupBox = document.createElement("div");
  this.PopupBox.className = "modal fade";
  this.PopupBox.id = this.Identifier + ":pb";
  this.PopupBox.setAttribute("data-keyboard", false);
  //
  // Gestione popup/autoclose (backdrop=false non copre lo sfondo mentre 'static' spegne la chiusura automatica)
  if (!this.Modal)
    this.PopupBox.setAttribute("data-backdrop", false);
  else if (!this.AutoClose)
    this.PopupBox.setAttribute("data-backdrop", "static");
  //
  this.PopupDialog = document.createElement("div");
  this.PopupDialog.className = "modal-dialog modal-dna";
  this.PopupBox.appendChild(this.PopupDialog);
  //
  this.PopupContent = document.createElement("div");
  this.PopupContent.className = "modal-content";
  this.PopupDialog.appendChild(this.PopupContent);
  //
  if (this.HasCaption)
  {
    this.CaptionBox = document.createElement("div");
    this.CaptionBox.className = "modal-header";
    this.CaptionBox.id = this.Identifier + ":cap";
    this.PopupContent.appendChild(this.CaptionBox);
  }
  //
  this.ContentBox = document.createElement("div");
  this.ContentBox.className = "modal-body";
  //
  this.PopupContent.appendChild(this.ContentBox);
  //
  document.body.appendChild(this.PopupBox);
  //
  this.Realized = true;
  //
  this.SetLeft();
  this.SetTop();
  this.SetWidth();
  this.SetHeight();
  this.AttachTo();
  //
  // Mi aggiungo nella mappa degli oggetti
  RD3_DesktopManager.ObjectMap.add(this.Identifier, this);
  //
  // Evento: quando vengo chiusa devo scatenare l'evento
  var _this = this;
  $(this.PopupBox).on('hidden.bs.modal', function (e) {
    _this.Close2();
  });
  //
  // Aggancio l'evento di comparsa completa (scatta una volta che l'animazione viene completata)
  $(this.PopupBox).on('shown.bs.modal', function (e) {
    try  {
      _this.ContentBox.tabIndex = 0;
      _this.ContentBox.focus();
    }
    catch(ex) {
      document.body.focus();
    }
    //
    if (_this.TheForm) {
      _this.TheForm.Animating = false;
      _this.TheForm.RealizeMessages();
      _this.TheForm.FormBox.style.overflow = "";
      RD3_DesktopManager.WebEntryPoint.HandleFinishFormAnimation(true);
    }
  });
}


// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
PopupFrame.prototype.AdaptLayout = function()
{ 

}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
PopupFrame.prototype.Unrealize = function()
{ 
  if (this.Realized) {
    if (this.OrgContentParent) {
      while(this.ContentBox.firstChild) {
        var obj = this.ContentBox.firstChild;
        this.ContentBox.removeChild(obj);
        this.OrgContentParent.appendChild(obj);
      }
    }
    if (this.OrgHeaderParent) {
      var obj = this.CaptionBox.firstChild;
      this.CaptionBox.removeChild(obj);
      this.OrgHeaderParent.insertBefore(obj,this.OrgHeaderSibling);
    }
    //
    // Su Chrome 29 a volte da' errore per il popupcontrol.. non si capisce chi l'annulla.. forse il garbage collector..
    if (this.PopupBox)
      this.PopupBox.parentNode.removeChild(this.PopupBox);
    if (this.ModalBox)
      this.ModalBox.parentNode.removeChild(this.ModalBox);
    if (this.ArrowBox)
      this.ArrowBox.parentNode.removeChild(this.ArrowBox);
    if (this.ArrowBorder)
      this.ArrowBorder.parentNode.removeChild(this.ArrowBorder);
  }
  //
  // Mi tolgo dalla mappa degli oggetti
  RD3_DesktopManager.ObjectMap[this.Identifier] = null;
  RD3_DesktopManager.ObjectMap.remove(this.Identifier);
  //
  // Rimuovo i riferimenti dal DOM
  this.PopupBox = null; 
  this.CoverBox = null; 
  this.ModalBox = null;   
  this.ArrowBox = null;   
  this.CaptionBox = null; 
  this.ContentBox = null; 
  this.TheForm = null;
  //
  this.Realized = false;
}


// ********************************************************************************
// Realizza e mostra a video questa popup
// ********************************************************************************
PopupFrame.prototype.Open = function()
{ 
  if (!this.Realized)
    this.Realize();
  //
  $(this.PopupBox).modal('show');
  this.Opened = true;
  //
  // Durante l'animazione di apertura mettiamo hidden, lo togliamo alla fine quando possiamo
  // fa aggiornare correttamente le dimensioni del DOM
  if (this.TheForm) {
    this.TheForm.FormBox.style.overflow = "hidden";
    this.TheForm.Animating = true;
  }
}


// ********************************************************************************
// Chiude la finestra
// ********************************************************************************
PopupFrame.prototype.Close = function()
{ 
  if (this.Realized)
    $(this.PopupBox).modal('hide');
  this.Opened = false;
}


// ********************************************************************************
// Chiude la finestra
// ********************************************************************************
PopupFrame.prototype.Close2 = function()
{ 
  if (this.Owner && this.Owner.OnClosePopup)
    this.Owner.OnClosePopup(this);
  //
  if (this.OnCloseCallBack)
    this.OnCloseCallBack();
  //
  // se sono un popup posso essere chiuso anche cliccando fuori, in questo caso devo avvertire e chiudere la form..
  // per sapere se sono in questo caso vedo se ho una form e se non ho OnCloseCallBack, in quel caso la chiusura del popup
  // non è stata scatenata da WEP perchè il server ha chiuso la Form, quindi deve essere stata scatenata da fuori
  if (this.AutoClose && !this.OnCloseCallBack && this.TheForm && this.TheForm.Realized && this.Opened)
    this.TheForm.OnClose();
  //
  this.Opened = false;
  this.Unrealize();
  //
  // Dobbiamo verificare se ci sono altre modali aperte, bootstrap quando chiude una modale toglie la classe modal-open dal body,
  // ma se ce ne sono altre aperte va rimessa (deve essere solo l'ultima modale a toglierla)
  var modals = document.getElementsByClassName("modal fade in");
  if (modals && modals.length > 0)
    document.body.className = "modal-open";
}


// ***********************************************************************************
// Restituisce true se a questo oggetto possono essere applicate delle trasformazioni
// ***********************************************************************************
PopupFrame.prototype.IsTransformable = function()
{
  return (this.CanMove || this.CanResize);
}


// ********************************************************************************
// Restituisce True se questo oggetto puo' essere spostato
// ********************************************************************************
PopupFrame.prototype.IsMoveable = function()
{
  return this.CanMove;
}


// ********************************************************************************
// Restituisce True se questo oggetto puo' essere ridimensionato
// ********************************************************************************
PopupFrame.prototype.IsResizable = function()
{
  return this.CanResize;
}


// ********************************************************************************
// Resituisce l'oggetto DOM su cui deve essere effettuata la trasformazione
// ********************************************************************************
PopupFrame.prototype.DropElement = function()
{
  return this.PopupBox;
}


// ********************************************************************************
// Metodo chiamato per effettuare la trasformazione
// ********************************************************************************
PopupFrame.prototype.OnTransform = function(x, y, w, h, evento)
{

}

// ********************************************************************************
// Metodo scatenato dal click sul frame
// ********************************************************************************
PopupFrame.prototype.OnClick = function(ev)
{

}


// ********************************************************************************
// Porta a galla il popup, sopra gli altri
// ********************************************************************************
PopupFrame.prototype.BringToFront = function()
{

}


// ********************************************************************************
// Imposta il popup come active o meno
// ********************************************************************************
PopupFrame.prototype.SetActive = function(value)
{

}


// ********************************************************************************
// Rende visibile la form o meno
// ********************************************************************************
PopupFrame.prototype.SetVisible= function(value)
{
  this.PopupBox.style.display = value?"":"none";
}


// ********************************************************************************
// Mostra o meno i bordi "grossi"
// ********************************************************************************
PopupFrame.prototype.ShowThickBorders= function(value)
{

}

// ********************************************************************************
// Applica il cursore al frame
// ********************************************************************************
PopupFrame.prototype.ApplyCursor = function(cn)
{

}


// ********************************************************************************
// Preleva un header ed un contenuto
// ********************************************************************************
PopupFrame.prototype.Host = function(hdrbox, cntbox, scroller, scrollTopMargin)
{

}


// ********************************************************************************
// Preleva un header ed un contenuto
// ********************************************************************************
PopupFrame.prototype.HostForm = function(form)
{

}


// ********************************************************************************
// Esegue autoclose se richiesto
// ********************************************************************************
PopupFrame.prototype.OnClickOut = function(hdrbox, cntbox)
{ 

}


// ***************************************************************
// Setter delle proprieta'
// ***************************************************************
PopupFrame.prototype.AttachTo = function(value)
{

}


// ***************************************************************
// Imposta il titolo "grezzo"
// ***************************************************************
PopupFrame.prototype.SetCaption = function(txt)
{
  if (this.CaptionBox)
  {
    if (!this.CaptionSpan) {
      this.CaptionSpan = document.createElement("span");
      this.CaptionSpan.className="popup-caption-span";
      this.CaptionBox.appendChild(this.CaptionSpan);
    }
    this.CaptionSpan.textContent = txt;
  }
}

PopupFrame.prototype.OnEndAnimation= function(evento)
{

}
