// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe Panel: Rappresenta un frame di tipo
// Grafico
// ************************************************

function Graph(pform)
{
  // Chiamo il costruttore superiore
  WebFrame.call(this,pform); 
  //
	// Proprieta' di questo oggetto di modello
  this.Library = -1;          // Libreria relativa al grafico
  this.File = "";             // Nome del file immagine o xml del grafico
  this.ImageWidth = 0;        // Dimensione dell'immagine
  this.ImageHeight = 0;       // Dimensione dell'immagine
  this.ErrText = "";          // Testo da presentare all'utente nel caso di errore nelle librerie J#
  //
  // Struttura per la definizione degli eventi di questo pannello
  this.ClickEventDef = RD3_Glb.EVENT_ACTIVE; // Click su un punto del grafico
	//
	// Oggetti DOM di questo grafico
	this.Img = null;            // Immagine del grafico JFreeChart
}
//
// Definisco l'estensione della classe
Graph.prototype = new WebFrame();



// *******************************************************************
// Inizializza questo Tree leggendo i dati da un nodo XML
// *******************************************************************
Graph.prototype.LoadFromXml = function(node) 
{
	// Chiamo la classe base
	WebFrame.prototype.LoadFromXml.call(this,node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
Graph.prototype.LoadProperties = function(node)
{
	// Chiamo la classe base
	WebFrame.prototype.LoadProperties.call(this,node);
	//
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
    	case "lib": this.SetLibrary(valore); break;
    	case "fil": this.SetFileName(valore); break;
    	case "gwi": this.SetGraphWidth(parseInt(valore)); break;
    	case "ghe": this.SetGraphHeight(parseInt(valore)); break;
    	case "ger": this.SetGraphErrText(valore); break;
			case "ged": this.SetGraphShowEditor(valore); break;
    	
    	case "clk": this.ClickEventDef = parseInt(valore); break;
    	
    	case "id": 
    		this.Identifier = valore;
    		RD3_DesktopManager.ObjectMap.add(valore, this);
    	break;
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
Graph.prototype.ChangeProperties = function(node)
{
	// Eseguo il cambio di proprieta'
	this.LoadProperties(node);
}


// ******************************************************************
// Setter delle proprieta'
// ******************************************************************
Graph.prototype.SetLibrary= function(value) 
{
	var old = this.Library;
	if (value!=undefined)
		this.Library = value;
	//
	if (this.Realized)
	{
		if (this.Library == RD3_Glb.CHARTJS)
      this.DrawChartJs();
    //
    if (this.Library == RD3_Glb.GOOGLECHART)
    {
      // Sostituisco l'immagine con un DIV
      if (this.Img)
        this.ContentBox.removeChild(this.Img);
      //
      // Creo l'oggetto su cui verra' disegnato il grafico
      this.Img = document.createElement("div");
      this.Img.setAttribute("id", this.Identifier+":chartDiv");
      this.Img.style.overflow = "hidden"; 
      this.ContentBox.appendChild(this.Img);
      //
      this.SetGoogleChart();
    }
	}
}

Graph.prototype.SetFileName= function(value) 
{
	if (value!=undefined)	
		this.File = value;
  //
  if (this.Realized) {
    if (this.Library == RD3_Glb.CHARTJS)
      this.DrawChartJs();
    else if (this.Library == RD3_Glb.GOOGLECHART)
      this.SetGoogleChart();
  }
}

Graph.prototype.SetGraphErrText= function(value) 
{
  this.ErrText = value;
  //
  if (this.Realized)
  {
    // Sostituisco l'immagine con un DIV contenente il testo di errore ricevuto dal server
    if (this.Img)
      this.ContentBox.removeChild(this.Img);
    //
	  this.Img = document.createElement("div");
  	this.Img.className = "graph-img-err";
	  this.Img.innerHTML = value;
  	this.ContentBox.appendChild(this.Img);
  }
}

Graph.prototype.SetGraphWidth= function(value) 
{
	if (value!=undefined)
		this.ImageWidth = value;
	//
	if (this.Realized)
	{
	  this.Img.style.width = this.ImageWidth + "px";
	}
}

Graph.prototype.SetGraphHeight= function(value) 
{
	if (value!=undefined)
		this.ImageHeight = value;
	//
	if (this.Realized)
	{
	  // IE 8 farebbe a meno del -1 ma IE7 no...
	  this.Img.style.height = (this.ImageHeight>0 ? (this.ImageHeight-1) : 0 ) + "px";
	}
}


// ***************************************************************
// Mostra la videata di configurazione del grafico (solo per GoogleChart)
// ***************************************************************
Graph.prototype.SetGraphShowEditor= function(value) 
{
  if (this.Realized && !this.chartEditor && this.Library == RD3_Glb.GOOGLECHART)
  {
    this.chartEditor = new google.visualization.ChartEditor();
    google.visualization.events.addListener(this.chartEditor, "ok", this.RedrawGoogleChart.bind(this));
    google.visualization.events.addListener(this.chartEditor, "cancel", this.CloseEditor.bind(this));
    //
    // HACK: la videata di configurazione non gestisce correttamente gli stili. Se i dati contengono la colonna di stile
    // il configuratore la mostra come se fosse una colonna di etichette. 
    // Devo toglierla prima di aprire la videata di configurazione
    // Step:
    //   1) cerco le colonne STYLE
    //   2) se le trovo le elimino
    //   3) apro il configuratore
    //   4) ripristino le colonne
    var data = this.wrapper.getDataTable();
    var oldData = new Array(data.Sf.length);
    //
    // 1) Cerco le colonne Style
    var styleIdx = [];
    for (var i = 0; i < data.Sf.length; i++)
      if (data.Sf[i].p && data.Sf[i].p.role === "style")
        styleIdx.push(i);
    //
    // 2) Elimino le colonne STYLE (se ce ne sono)
    for (var j = styleIdx.length - 1; j >=0; j--) {
      var idx = styleIdx[j];
      oldData[idx] = {col: data.Sf.splice(idx, 1)[0], rows: []};
      for (var i = 0; i < data.Tf.length; i++)
        oldData[idx].rows[i] = data.Tf[i].c.splice(idx,1)[0];
    }
    this.wrapper.setDataTable(data);
    //
    // 3) Apro il configuratore
    this.chartEditor.openDialog(this.wrapper, {});
    //
    // 4) Ripristino le colonne eliminate
    for (var j = 0; j < styleIdx.length; j++) {
      var idx = styleIdx[j];
      data.Sf.splice(idx, 0, oldData[idx].col);
      for (var i = 0; i < data.Tf.length; i++)
        data.Tf[i].c.splice(idx, 0, oldData[idx].rows[i]);
      //
      this.wrapper.setDataTable(data);
    }
  }
}


Graph.prototype.SetVisible = function(value)
{
	// Chiamo il metodo base
  WebFrame.prototype.SetVisible.call(this, value);
  //
  // Adatto il grafico e le sue dimensioni
  if (this.Realized && this.Visible)
    window.setTimeout(function() {
      this.OnViewportResize();
    }.bind(this), 0);
}


// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
Graph.prototype.Realize = function(parent)
{
  // Chiamo la classe base
	if (!this.Realized)
		WebFrame.prototype.Realize.call(this,parent);
	//
	// Creo gli oggetti del DOM
	this.Img = document.createElement("div");
	//
	// Assegno le classi agli oggetti
	this.Img.className = "graph-img";
	//
	// Aggiungo gli elementi al DOM
	this.ContentBox.appendChild(this.Img);
	//
	this.Realized = true;
	//
	// Inizializzazione
	this.SetLibrary();
	this.SetFileName();
	this.SetWidth();
	this.SetHeight();
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
Graph.prototype.Unrealize = function()
{ 
	// Chiamo la classe base
	WebFrame.prototype.Unrealize.call(this);
	//
	// Annullo i miei riferimenti
	this.Img = null;
	//
	this.Realized = false;
}


// ********************************************************************************
// Gestore evento di click su un punto del grafico
// ********************************************************************************
Graph.prototype.OnGraphClick= function(evento, point)
{ 
	if (this.Visible && this.Enabled)
	{
		// Posso lanciare il click!
		var ev = new IDEvent("graclk", this.Identifier, evento, this.ClickEventDef, point);
	}
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
Graph.prototype.AfterProcessResponse= function()
{ 
	// Chiamo la classe base
	WebFrame.prototype.AfterProcessResponse.call(this);
  //
  // Se devo disegnare il grafico Google Chart lo faccio adesso
  if (this.googleChartDraw) {
    this.wrapper.draw();
    delete this.googleChartDraw;
  }
}


// *********************************************************
// E' arrivato un click a livello di frame
// *********************************************************
Graph.prototype.OnFrameClick = function(evento, dbl, btn, x, y, xb, yb, tget)
{
	// cerco il punto nella mappa...
	var pointid = "";
	if (tget.tagName=="AREA")
	{
		var url = tget.href;
		var p1 = url.indexOf("'OnGraphClick', null,'");
		if (p1>0)
		{
			var p2 = url.indexOf("'",p1+22);
			if (p2>0)
				pointid = url.substring(p1+22,p2);
		}
	}
	//
	var ev = new IDEvent("rawclk", this.Identifier, evento, dbl?this.MouseDoubleClickEventDef:this.MouseClickEventDef, dbl, btn, Math.floor(xb)+"-"+Math.floor(yb), Math.floor(x)+"-"+Math.floor(y), pointid);
}


// *********************************************************
// Imposta il tooltip
// *********************************************************
Graph.prototype.GetTooltip = function(tip, obj)
{
  return WebFrame.prototype.GetTooltip.call(this, tip, obj);
}


// ********************************************
// Questa funzione disegna un grafico ChartJs
// ********************************************
Graph.prototype.DrawChartJs = function()
{
  // Se c'e' gia' un grafico, lo distruggo (sara' ricreato se necessario)
  if (this.chart) {
    this.chart.destroy();
    this.chart = null;
  }
  //
  if (!this.File) 
  {
    this.SetGraphErrText("No data to show");
    return;
  }
  //
  // Devo ricreare il canvas tutte le volte altrimenti il grafico non si dimensiona bene
  if (this.Img)
    this.ContentBox.removeChild(this.Img);
  this.Img = document.createElement("canvas");
  this.Img.width = this.ImageWidth;
  this.Img.height = this.ImageHeight;
  this.Img.setAttribute("id", this.Identifier+":chartDiv");
  this.Img.style.overflow = "hidden";
  //
  // Creo il grafico
  var options = JSON.parse(this.File);
  if (options.custom) 
  {
    // Se e' stato impostato il colore di sfondo del canvas
    if (options.custom.overallBackgroundColor) 
      this.Img.style.backgroundColor = options.custom.overallBackgroundColor;
    //
    // Se sono stati impostate le proprieta' per le etichette
    if (options.custom.fontLabels) 
    {
      Chart.defaults.global.defaultFontSize = options.custom.fontLabels.fontSize;
      Chart.defaults.global.defaultFontColor = options.custom.fontLabels.textColor;
      Chart.defaults.global.defaultFontFamily = options.custom.fontLabels.fontFamily;
    }
    this.ContentBox.appendChild(this.Img);
    //
    var ctx = this.Img.getContext("2d");
    Chart.pluginService.register({
      /*afterDraw: function(chartInstance) {
        // Se devo mostrare i valori sul grafico
        if (options.custom.showDataLabels) {
          var ctx = chartInstance.chart.ctx;
          ctx.font = Chart.helpers.fontString(Chart.defaults.global.defaultFontFamily, 'normal', Chart.defaults.global.defaultFontFamily);
          ctx.textAlign = 'center';
          ctx.textBaseline = 'bottom';
          ctx.fillStyle = Chart.defaults.global.defaultFontColor;
          //
          chartInstance.data.datasets.forEach(function (dataset) {
            for (var i = 0; i < dataset.data.length; i++) {
              var model = dataset._meta[Object.keys(dataset._meta)[0]].data[i]._model;
              if (options.type == "bubble")
                ctx.fillText(dataset.data[i].r, model.x, model.y - 2);
              else
                ctx.fillText(dataset.data[i], model.x, model.y - 2);
            }
          });
        }          
      },*/
      // 
      // Imposto il colore di sfondo interno al grafico
      beforeDraw: function (chart, easing) {
        if (options.custom.chartBackgroundColor) {
          var helpers = Chart.helpers;
          var ctx = chart.chart.ctx;
          var chartArea = chart.chartArea;
          ctx.save();
          ctx.fillStyle = options.custom.chartBackgroundColor;
          ctx.fillRect(chartArea.left, chartArea.top, chartArea.right - chartArea.left, chartArea.bottom - chartArea.top);
          ctx.restore();
        }
      }
    });
  }
  //
  // Se il grafico e' attivo imposto l'onClick
  if (this.Enabled) 
  {
    var pthis = this;
    options.options.onClick = function (ev, seriesIndex, pointIndex, data) {
       var point = pthis.chart.getElementAtEvent(ev);
       if (point.length > 0)
         RD3_DesktopManager.CallEventHandler(pthis.Identifier, 'OnGraphClick', null,'S'+((point[0]._datasetIndex + 1)<=9 ? '0' : '')+(point[0]._datasetIndex + 1)+'I'+(point[0]._index + 1));
      };
  }
  //
  // Creo il grafico
  try 
  {
    this.chart = new Chart(ctx, options);
  }
  catch(e) 
  {
    console.error(e);
  }
}

// ***********************************************
// Aggiorna grafico GoogleChart
// ***********************************************
Graph.prototype.SetGoogleChart = function()
{
  if (this.loadingGoogleLib)
    return;
  //
  // Se non sono ancora stati caricati, carico i packages necessari
  if(!google.visualization) 
  {
    this.loadingGoogleLib = true;
    //
    google.charts.load("45", {"packages": ["corechart", "calendar", "table", "timeline", "treemap", "gauge", "geochart", "orgchart", "charteditor"], "language": ClientMessages.GRA_LAN_CODE});
    google.charts.setOnLoadCallback(this.DrawGoogleChart.bind(this));
  }
  else
    this.DrawGoogleChart();
}


// ***********************************************
// Questa funzione disegna un grafico GoogleChart
// ***********************************************
Graph.prototype.DrawGoogleChart = function()
{  
  delete this.loadingGoogleLib;
  //
  if (!this.File) 
  {
    this.SetGraphErrText("No data to show");
    return;
  }
  //
  // Ottengo i dati e le opzioni da passare al grafico
  var parameters = JSON.parse(this.File);
  //
  // Costruisco la dataTable che contiene i dati che il grafico deve mostrare
  var data = new google.visualization.DataTable(parameters.data);
  //
  // Aggiungo l'altezza e la larghezza alle opzioni
  parameters.options.width = this.ImageWidth;
  parameters.options.height = this.ImageHeight;
  //
  // Imposto le opzioni del grafico
  var opzioni = {
            chartType: parameters.type,
            dataTable: data,
            options: parameters.options,
            containerId: this.Identifier+":chartDiv"
          };
  //
  // Creo il wrapper del grafico
  this.wrapper = new google.visualization.ChartWrapper(opzioni);
  //
  // Trovo l'elemento che deve contenere il grafico
  var pthis = this;
  var chartDiv = document.getElementById(this.Identifier + ":chartDiv");
  if (!chartDiv)
  {
    // Se c'e' un div d'errore lo tolgo e lo sostituisco con il div del grafico
    var errDivs = document.getElementsByClassName("graph-img-err");
    if (errDivs.length > 0) {
      for (var i = 0; i < errDivs.length; i++) {
        var d = errDivs[i];
        if (d.parentNode.id == this.ContentBox.id)
          this.ContentBox.removeChild(d);
      }
      //
      // Creo l'oggetto su cui verra' disegnato il grafico
      this.Img = document.createElement("div");
      this.Img.setAttribute("id", this.Identifier+":chartDiv");
      this.Img.style.overflow = "hidden"; 
      this.ContentBox.appendChild(this.Img);
      //
      var cb = document.getElementById(this.ContentBox.id);
      if (cb)
        this.wrapper.draw(); 
      else
        this.googleChartDraw = true;
    }
    else // Mi ricordo che devo disegnare il grafico quando tutto sara' pronto
      this.googleChartDraw = true;
  }
  else  // Disegno subito il grafico
    this.wrapper.draw();  
  //
  // Gestione del click sul grafico
  var pthis = this;
  var chartClick = function chartClick(){
    var chart = pthis.wrapper.getChart();
    var selection = chart.getSelection();
    if (selection.length > 0) 
    {
      for (var i = 0; i < selection.length; i++) 
      {
        var item = selection[i];
        var row = item.row == null ? 0 : item.row;
        var serie = item.column == null ? 0 : item.column;
        var point = data.getFormattedValue(row, serie);
        //
        RD3_DesktopManager.CallEventHandler(pthis.Identifier, 'OnGraphClick', null,'S'+((serie)<=9 ? '0' : '')+(serie)+'I'+(row + 1));
      }
    }
    //
    // Rimuovo la selezione
    setTimeout(function() {
      chart.setSelection([]);
    }, 100);
  };
  //
  // Se il grafico e' attivo imposto l'onClick
  if (this.Enabled)
    google.visualization.events.addListener(this.wrapper, "select", chartClick);
}


// ***************************************************
// Questa funzione ridisegna un grafico Google Chart
// ***************************************************
Graph.prototype.RedrawGoogleChart = function()
{
  if (this.googleChartDraw)
    return;
  //
  var opt;
  var chartType;
  var chartData;
  //
  // Se la chiamata e' dovuta ad una variazione delle opzioni prendo le opzioni dal chart editor
  // altrimenti le prendo direttamente dal grafico
  if (this.chartEditor)
  {
    opt = this.chartEditor.getChartWrapper().getOptions();
    chartType = this.chartEditor.getChartWrapper().getChartType();
  }
  else
  {
    var options = JSON.parse(this.File);
    opt = options.options;
    chartData = options.data;
    chartType = options.type;
  }
  //
  // Imposto le dimensioni
  opt.width = this.ImageWidth;
  opt.height = this.ImageHeight;
  //
  // Imposto le nuove configurazioni
  this.wrapper.setOptions(opt);
  if (chartData)
    this.wrapper.setDataTable(chartData);
  this.wrapper.setChartType(chartType);
  //
  // Se la chiamata e' dovuta ad una configurazione dell'utente
  if (this.chartEditor)
  {
    // Notifico l'evento onOptionsChanged
    var ev = new IDEvent("graopt", this.Identifier, undefined, RD3_Glb.EVENT_ACTIVE, JSON.stringify(opt), chartType);
    //
    // La videata di configurazione e' chiusa
    this.chartEditor = null;
  }  
  //
  // Ridisegno il grafico
  this.wrapper.draw();
}


// **********************************************************************************
// Questa funzione viene chiamata quando si chiude l'editor del grafico con annulla
// **********************************************************************************
Graph.prototype.CloseEditor = function()
{
  this.chartEditor = null;
}

Graph.prototype.OnViewportResize = function()
{
  // Imposto le dimensioni dell'immagine in modo che ci stia...
  var oldWidth = this.ImageWidth;
  var oldHeight = this.ImageHeight;
  this.SetGraphWidth(this.ContentBox.clientWidth - RD3_Glb.GetTotalPadding(this.ContentBox));
  //
  // If the resize of the form is none we should use the design heigth, if is ADAPT we must adapt to the parent height
  if (this.WebForm.ResModeH != RD3_Glb.FRESMODE_NONE)
    this.SetGraphHeight(this.ContentBox.clientHeight - RD3_Glb.GetVerticalTotalPadding(this.ContentBox));
  //
  // Lo devo fare ora perche' JQPlot, ChartJs e GoogleChart hanno bisogno che il DIV abbia le dimensioni gia' impostate
  // Se le dimensioni sono cambiate devo riaggiornare il grafico
  var updateChart = oldWidth != this.ImageWidth || oldHeight != this.ImageHeight;
  if (updateChart) 
  {
    if (this.Library == RD3_Glb.CHARTJS)
      this.DrawChartJs();
    else if (this.Library == RD3_Glb.GOOGLECHART) 
      this.SetGoogleChart();
  }
};