/*
  -------------------.-.--------------------
  Diagram Wrapper for INDE 24 for Fluid
                  07/05/2025
  ------------------------------------------
*/
let indeID = ""


Client.Diagram = function (element, parent, view)
{ 

  // call base constructor
  Client.Element.call(this, element, parent, view);

  // Initialization of properties. It starts from let configuration....

  if(Client.Diagram.inited && element.configuration && element.id){

    //  If the diagram was previously drawn we destroy the instance to create a new one
    if (this.diagram_instance) {

      this.diagram_instance.destroy();
    }
    // this generateID is needed to define the insertedShape ID
    let generatedID = 100;

    // create the store constant to store all data from the JSON (step) at the bottom of this file

    let storedShape = JSON.parse(element.storedShape)
    let storedConnection = JSON.parse(element.storedConnection)
    let storedShapeConfiguration = JSON.parse(element.storedShapeConfiguration)
    let isDiagramReadOnly = element.readOnly

    // all shape e connection saved 
    this.savedDataFromFrontEnd = element.savedDataFromFrontEnd; 

    // switch from ArrayStore to CustomStore because CustomStore handles more shape events when making changes to the diagram.
    this.store = new DevExpress.data.CustomStore({      
      load: () => storedShape,
      insert: (values) => {
        const newShape = {
          id: generateId(), 
          x: values.x || 0,
          y: values.y || 0,
          width: values.width || 1.5,
          height: values.height || 1,
          itemType: "shape",
          type: values.type || "startStop",
          dataItem: {
            Type: values.type || "startStop",
            description: (values.type === "startStop") ? "START" : "Descrizione",
            name: ""
          },
          color: null,
          text: "" // se serve
        };
      
        storedShape.push(newShape);
        Client.mainFrame.sendCommand("DXCOM",`content={id:${indeID},message:"onInserting",content: ${[JSON.stringify(newShape)]}}`);
      
        return newShape;
      },      
      update: (key, values) => {
        const index = storedShape.findIndex(item => item.id === key);
        if (index > -1) {
          Object.assign(storedShape[index], values);
          
        }
        return values;
      },
      remove: (key) => {
        const index = storedShape.findIndex(item => item.id === key);
        if (index > -1) {
          const deletedShape = storedShape[index]; 
          storedShape.splice(index, 1);           
          Client.mainFrame.sendCommand("DXCOM",`content={id:${indeID},message:"onDeleteShape",content: ${[JSON.stringify(deletedShape)]}}`);
      
          return key;
        }
      
        return null; // or manage the case here if not found
      }
    });

    this.edges = new DevExpress.data.CustomStore({
      load: function(loadOptions) {
        // Logic to load edge data
        // You can apply any filters or sorting via `loadOptions`
        return storedConnection; // Restituisce l'elenco degli edges
      },
      insert: function(values) {
        // Logic to insert a new edge
        const newEdge = { 
          id: generateId(),  
          ...values         
        };
        storedConnection.push(newEdge); // Add the new edge to `storedConnection`

        Client.mainFrame.sendCommand("DXCOM",`content={id:${indeID},message:"onInsertingConnection",content: ${[JSON.stringify(newEdge)]}}`);
        return newEdge; // Returns the newly inserted edge
      },

      update: function(key, values) {
        // Logic to update an existing edge
        let edge = storedConnection.find(e => e.id === key.id);
        Client.mainFrame.sendCommand("DXCOM",`content={id:${indeID},message:"onUpdateConnection",content: ${[JSON.stringify(edge)]}}`);
        if (edge) {
          Object.assign(edge, values); // Update edge values
        }
        return edge; 
      },
      
      remove: function(key) {
        // Logic to remove an edge
        const index = storedConnection.findIndex(e => e.id === key);
        if (index !== -1) {
          storedConnection.splice(index, 1); // Removes the edge
        }
        console.log("key shape rimossa", key)
        Client.mainFrame.sendCommand("DXCOM",`content={id:${indeID},message:"onDeleteConnection",content: ${[JSON.stringify(key)]}}`);
      },
      byKey: function(key) {
        // Returns the edge with the specified ID
        return storedConnection.find(e => e.id === key);
      }
    });
  



    // read the Configuration shared by INDE
    let configuration = element.configuration
    let diagram_name = configuration.diagram_name;
    let custom_shapes = configuration.custom_shapes;
    let diagram_content = configuration.diagram_content;
    let main_toolbar = configuration.main_toolbar;
    let toolbox = configuration.toolbox;
    let context_toolbox = configuration.context_toolbox;
    let view_toolbar = configuration.view_toolbar;

    this.id = element.id;
    this.indeFormIndex = configuration.indeFormIndex;
    indeID = this.indeFormIndex
    
    DevExpress.localization.locale(navigator.language);
    
    // the div that contains the diagram is created and the id is assign
    let diagramDiv = document.createElement("div");
    diagramDiv.id = `diagram_${indeID}`;
    parent.appendChildObject(this, diagramDiv);
    let selector = `#${diagramDiv.id}`;
    this.diagram_instance_div = diagramDiv;
 

    // Inde framework FE needs it
    this.domObj = diagramDiv;

    // Inizializza un oggetto vuoto per shapeDataMap
    const shapeDataMap = {};
    // Itera su storedShapeConfiguration per aggiungere ogni item a shapeDataMap
    storedShapeConfiguration.forEach(config => {
      shapeDataMap[config.type] = { description: config.description };
    });

    // here all the options is passed to the diagram using dxDiagram method
    $(selector).dxDiagram({
      customShapes: storedShapeConfiguration,
      /*
      //...custom_shapes,
    ],*/

      // THIS INSERTS INTO THE SHAPE THE TEXT FIELDS of the <text> dom if not present does not show any text fields.
      customShapeTemplate(item, $container) {
        const step = item.dataItem;
        const svgNS = 'http://www.w3.org/2000/svg';
        const $content = $(document.createElementNS(svgNS, 'svg')).addClass('template');
      
        $(document.createElementNS(svgNS, 'text'))
          .addClass('template-name')
          .attr({ x: '50%', y: '20%' })
          .text(step?.name || "Nome")
          .appendTo($content);
      
        $(document.createElementNS(svgNS, 'text'))
          .addClass('template-title')
          .attr({ x: '50%', y: '45%' })
          .text(step?.description || "Descrizione")
          .appendTo($content);
        /* to insert new buttons to edit or delete the shape  
        $(document.createElementNS(svgNS, 'text'))
          .addClass('template-button')
          .attr({ id: 'employee-edit', x: '40%', y: '85%' })
          .text('Modifica')
          .click(() => { editEmployee(step); })
          .appendTo($content);
          
        $(document.createElementNS(svgNS, 'text'))
          .addClass('template-button')
          .attr({ id: 'employee-delete', x: '62%', y: '85%' })
          .text('Cancella')
          .click(() => { deleteShape(step); })
          .appendTo($content);
        */
        $container.append($content);
      },
      // that function is used to add customShape to the lateral toolbox
      customShapeToolboxTemplate: function (item, $container) {

        //  Here descrizione is get from the dictionary
        const description = shapeDataMap[item.type]?.description || "Senza Descrizione";
        const $content = $(`
            <svg class='template'>
                <text x='50%' y='40%' text-anchor="middle">Nuovo</text>
                <text x='50%' y='70%' text-anchor="middle">${description}</text>
            </svg>
        `);
        $container.append($content);
    },
      /*customShapeToolboxTemplate(item, $container) {
        const $content = $("<svg class='template'>"
                  + "<text x='50%' y='40%'>Nuovo</text>"
                  + "<text x='50%' y='70%'>" + item.type + "</text>"
                  + '</svg >');
        $container.append($content);
      },*/

      export: {fileName: diagram_name},
      // we don't understand what contextMenu is but it's nothing relevant.
      contextMenu: {
        enabled: true,
        commands: ['bringToFront', 'sendToBack', 'lock', 'unlock'],
      },
      readOnly: isDiagramReadOnly,
      // here the data store part
      nodes: {
        dataSource: this.store,
        keyExpr: 'id',
        widthExpr: 'width',
        heightExpr: 'height',
        leftExpr: 'x',
        topExpr: 'y',
        // Custom Data Expression (gestisce solo il colore)
        customDataExpr: function(obj, value) {
            if (value === undefined) {
                return { color: obj.color };  // Restituisce un oggetto nuovo
            }
            obj.color = value.color;  // Aggiorna il valore nel nodo
        },
    
        // Style Expression (crea sempre un nuovo oggetto per evitare blocchi)
        styleExpr: function(obj) {
            return { fill: obj.color || '#FFFFFF' };  // Usa bianco di default se il colore è undefined
        },

        autoLayout: {
          type: 'off',
        },
      },
      edges: this.edges,
      historyToolbar: {
        visible: true,
      },
      viewToolbar: view_toolbar,
      mainToolbar: main_toolbar,
      contextToolbox: context_toolbox,
      toolbox: {
        visibility: toolbox.visibility,
        shapeIconsPerRow: toolbox.shapeIconsPerRow,
        showSearch: toolbox.showSearch,
        height:toolbox.height,
        width:toolbox.width,
        groups: [
          { category: 'step', description: 'Diagram Shape', expanded: true },
          /*{ category: 'start', description: 'Start & Stop', expanded: true },*/
          /*{ category: 'default', description: 'Daniele Shape', expanded: true }*/
        ],
      },
      propertiesPanel: {
        tabs: [
          {
            groups: [{ Descrizione: 'Page Properties', commands: ['pageSize', 'pageOrientation', 'pageColor'] }],
          },
        ],
      },
      /*onItemClick: function(data) {
        // handle the click on a wkf node
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"onItemClick",content: "${[data.item]}"}`);
      },*/
      onItemDblClick: function(data) {
        // handle the click on a wkf node
        let toSend = {
          key: data.item.key,
          id : data.item.id,
          text : data.item.text,
          x: data.item.position.x,
          y: data.item.position.y,
        };
       Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"onItemDblClick",content: ${[JSON.stringify(toSend)]}}`);
      },
    });

    // Store the dxDiagram instance into this.diagram_instance

    this.diagram_instance = $(selector).dxDiagram("instance");
    this.diagram_instance_div = diagramDiv
    this.attachEvents(element.events);

    // Configurazione degli edges nel diagramma
    this.diagram_instance.option("edges", {
      dataSource: this.edges,   
      keyExpr: "id",                  // La chiave primaria dell'edge
      textExpr: "text",               // La proprietà del testo dell'edge
      fromExpr: "fromId",             // La proprietà dell'origine (from)
      toExpr: "toId",                 // La proprietà della destinazione (to)
      fromPointIndexExpr: "fromPointIndex", // L'indice del punto di origine
      toPointIndexExpr: "toPointIndex"      // L'indice del punto di destinazione
    });
                      

    // Ottenere le shape e le connessioni
    const shapes = this.diagram_instance.getItems();
    


    if(diagram_content){
      this.diagram_instance.import(diagram_content, false);
    }
  }
  else {
    Client.Diagram.Realize = parent;
    this.diagram_instance_rendered = false
    return;
  }
};

// Inheriting properties from Client.Element
Client.Diagram.prototype = new Client.Element();
Client.Diagram.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Diagram.getRequirements = function ()
{
  Client.Diagram.inited = true;
  return {};
};

//  Destroy the diagram instance and remove the Div that has contained the diagram 
Client.Diagram.prototype.close = function (firstLevel, triggerAnimation)
{
  if (this.diagram_instance){this.diagram_instance.dispose();}
  delete this.diagram_instance;
  if(this.diagram_instance_div && this.diagram_instance_div.parentNode){this.diagram_instance_div.parentNode.removeChild(this.diagram_instance_div);}
  if(this.diagram_instance_div){delete this.diagram_instance_div;}
}

Client.Diagram.prototype.exportJson = function (){
  var jsonString = this.diagram.export();
  this.SendEvent("export", [jsonString]);
}
 
Client.Diagram.prototype.importJson = function (json){
    var jsonToImport = json;
    this.diagram.import(jsonToImport, false);
}
 
Client.Diagram.prototype.printwkf = function (){
  var imageString = "";
  const ff = function() {
    this.SendEvent("print", [imageString]);
  };
    this.diagram.exportTo('svg', ff);
}


// this procedure changes language of this scheduler
Client.Diagram.prototype.setLocale = function(localeString) {
  if(localeString) {
    DevExpress.localization.locale(localeString);
  }
}
Client.Diagram.prototype.getDataFromDiagram = function () {
  // 🔧 Funzione di pulizia shape
  function cleanShape(item) {
    const data = item.dataItem || item;
    const nested = data.dataItem || {};
    return {
      x: data.x,
      y: data.y,
      width: data.width,
      height: data.height,
      id: data.id,
      itemType: data.itemType,
      type: data.type,
      dataItem: {
        Type: nested.Type || "",
        description: nested.description || "",
        name: nested.name || ""
      },
      color: data.color
    };
  }

  // 🔧 Funzione di pulizia connector
  function cleanConnector(item) {
    const data = item.dataItem || item;
    return {
      id: data.id || item.id,
      itemType: data.itemType || item.itemType,
      fromId: data.fromId || item.fromId,
      fromPointIndex: data.fromPointIndex || item.fromPointIndex,
      toId: data.toId || item.toId,
      toPointIndex: data.toPointIndex || item.toPointIndex,
      text: data.text || item.text || ""
    };
  }

  // 🔁 Dispatcher per tipo
  function cleanDiagramData(rawItems) {
    return rawItems.map(item => {
      if ((item.itemType || item?.dataItem?.itemType) === "shape") {
        return cleanShape(item);
      } else if ((item.itemType || item?.dataItem?.itemType) === "connector") {
        return cleanConnector(item);
      } else {
        console.warn("Tipo sconosciuto, lasciato grezzo:", item);
        return item;
      }
    });
  }

  // 🎯 Get e pulizia
  const $el = $('[id^="diagram_"]').first();
  if (!$el.length) return console.error("Diagram element not found.");

  this.diagram_instance = $el.dxDiagram("instance");
  if (!this.diagram_instance) return console.error("Diagram instance not found.");

  const rawItems = this.diagram_instance.getItems();
  const cleanItems = cleanDiagramData(rawItems);
  this.savedDataFromFrontEnd = JSON.stringify(cleanItems);

  Client.mainFrame.sendEvents([{
    obj: this.id,
    id: "OnSaveDiagram",
    content: [this.savedDataFromFrontEnd]
  }]);
};

/* idea to delete shape clicking on delete buttons inside the shape
const deleteShape = function (shape) {
  this.store.push([{ type: 'remove', key: shape.ID }]);
};*/

Client.Diagram.prototype.setValues = function(data) {

  if (!this.diagram_instance) {
    console.error("Diagram instance non inizializzata.");
    return;
  }

  if (!data) {
    console.error("Dati insufficienti. Assicurati che 'data' contenga 'id' e 'text'.");
    return;
  }

  try {
    // Verifica che l'elemento esista nel diagramma
    const items = this.diagram_instance.getItems();
    const shape = items.find(item => item.id === data.id && item.itemType === "shape");

    if (!shape) {
      console.error(`Shape con ID ${data.id} non trovata o non è una shape valida.`);
      return;
    }

    // Aggiorna il testo della shape identificata dall'ID
    if(!data.description == null || !data.description == "") {
        this.store.push([{
          type: 'update',
          key: data.key,
          data: {
            description: data.description,
            dataItem: { description: data.description }
          },
        }]);
      }
      if(!data.text == null || !data.text == "") {     
        this.store.push([{
          type: 'update',
          key: data.key,
          data: {
            name: data.text,
            dataItem: { name: data.text }
          },
        }]);
      }
      if(!data.color == null || !data.color == "") {     
        this.store.push([{
          type: 'update',
          key: data.key,
          data: {
            color: data.color,
          },
        }]);
      }

  } catch (error) {
    console.error("Errore durante l'aggiornamento del testo della shape:", error);
  }
};

function generateId() {
  return Math.random().toString(36).substr(2, 9); // oppure un contatore incrementale
}