/*!
* DevExtreme (dx.messages.tr.js)
* Version: 23.2.5
* Build date: Mon Mar 11 2024
*
* Copyright (c) 2012 - 2024 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        tr: {
            Yes: "Evet",
            No: "Hay\u0131r",
            Cancel: "\u0130ptal",
            Close: "Kapat",
            Clear: "Temizle",
            Done: "Tamam",
            Loading: "Y\xfckleniyor...",
            Select: "Se\xe7...",
            Search: "Ara",
            Back: "Geri",
            OK: "Tamam",
            "dxCollectionWidget-noDataText": "G\xf6sterilecek bilgi yok",
            "dxDropDownEditor-selectLabel": "Select",
            "validation-required": "Zorunlu",
            "validation-required-formatted": "{0} gerekli",
            "validation-numeric": "De\u011fer bir say\u0131 olmal\u0131",
            "validation-numeric-formatted": "{0} bir say\u0131 olmal\u0131",
            "validation-range": "De\u011fer aral\u0131k d\u0131\u015f\u0131nda",
            "validation-range-formatted": "{0} aral\u0131k d\u0131\u015f\u0131nda",
            "validation-stringLength": "De\u011ferin uzunlu\u011fu do\u011fru de\u011fil",
            "validation-stringLength-formatted": "{0} uzunlu\u011fu do\u011fru de\u011fil",
            "validation-custom": "De\u011fer ge\xe7ersiz",
            "validation-custom-formatted": "{0} ge\xe7ersiz",
            "validation-async": "Value is invalid",
            "validation-async-formatted": "{0} is invalid",
            "validation-compare": "De\u011ferler e\u015fle\u015fmiyor",
            "validation-compare-formatted": "{0} e\u015fle\u015fmiyor",
            "validation-pattern": "De\u011fer kal\u0131pla e\u015fle\u015fmiyor",
            "validation-pattern-formatted": "{0} kal\u0131pla e\u015fle\u015fmiyor",
            "validation-email": "E-posta ge\xe7ersiz",
            "validation-email-formatted": "{0} ge\xe7ersiz",
            "validation-mask": "De\u011fer ge\xe7ersiz",
            "dxLookup-searchPlaceholder": "Minimum karakter say\u0131s\u0131: {0}",
            "dxList-pullingDownText": "Yenilemek i\xe7in a\u015fa\u011f\u0131ya \xe7ekin...",
            "dxList-pulledDownText": "Yenilemek i\xe7in b\u0131rak\u0131n...",
            "dxList-refreshingText": "Yenileniyor...",
            "dxList-pageLoadingText": "Y\xfckleniyor...",
            "dxList-nextButtonText": "Daha",
            "dxList-selectAll": "T\xfcm\xfcn\xfc Se\xe7",
            "dxListEditDecorator-delete": "Sil",
            "dxListEditDecorator-more": "Daha",
            "dxScrollView-pullingDownText": "Yenilemek i\xe7in a\u015fa\u011f\u0131ya \xe7ekin...",
            "dxScrollView-pulledDownText": "Yenilemek i\xe7in b\u0131rak\u0131n...",
            "dxScrollView-refreshingText": "Yenileniyor...",
            "dxScrollView-reachBottomText": "Y\xfckleniyor...",
            "dxDateBox-simulatedDataPickerTitleTime": "Saat se\xe7",
            "dxDateBox-simulatedDataPickerTitleDate": "Tarih se\xe7",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Tarih ve saati se\xe7in",
            "dxDateBox-validation-datetime": "De\u011fer bir tarih veya saat olmal\u0131d\u0131r",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Ba\u015flang\u0131\xe7 Tarihi",
            "dxDateRangeBox-endDateLabel": "Biti\u015f Tarihi",
            "dxFileUploader-selectFile": "Dosya se\xe7",
            "dxFileUploader-dropFile": "veya Dosyay\u0131 buraya b\u0131rak\u0131n",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Y\xfckleme",
            "dxFileUploader-uploaded": "Y\xfcklenen",
            "dxFileUploader-readyToUpload": "Y\xfcklemeye haz\u0131r",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "Y\xfckleme ba\u015far\u0131s\u0131z",
            "dxFileUploader-invalidFileExtension": "Dosya t\xfcr\xfcne izin verilmiyor",
            "dxFileUploader-invalidMaxFileSize": "Dosya \xe7ok b\xfcy\xfck",
            "dxFileUploader-invalidMinFileSize": "Dosya \xe7ok k\xfc\xe7\xfck",
            "dxRangeSlider-ariaFrom": "\u0130tibaren",
            "dxRangeSlider-ariaTill": "Kadar",
            "dxSwitch-switchedOnText": "A\xe7\u0131k",
            "dxSwitch-switchedOffText": "Kapal\u0131",
            "dxForm-optionalMark": "iste\u011fe ba\u011fl\u0131",
            "dxForm-requiredMessage": "{0} gerekli",
            "dxNumberBox-invalidValueMessage": "De\u011fer bir say\u0131 olmal\u0131",
            "dxNumberBox-noDataText": "Veri yok",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "S\xfctun Se\xe7ici",
            "dxDataGrid-columnChooserEmptyText": "S\xfctunu gizlemek i\xe7in buraya s\xfcr\xfckleyin",
            "dxDataGrid-groupContinuesMessage": "Bir sonraki sayfada devam ediyor",
            "dxDataGrid-groupContinuedMessage": "\xd6nceki sayfadan devam",
            "dxDataGrid-groupHeaderText": "Bu S\xfctuna G\xf6re Grupla",
            "dxDataGrid-ungroupHeaderText": "Grubu Kald\u0131r",
            "dxDataGrid-ungroupAllText": "T\xfcm Gruplar\u0131 Kald\u0131r",
            "dxDataGrid-editingEditRow": "D\xfczenle",
            "dxDataGrid-editingSaveRowChanges": "Kaydet",
            "dxDataGrid-editingCancelRowChanges": "\u0130ptal",
            "dxDataGrid-editingDeleteRow": "Sil",
            "dxDataGrid-editingUndeleteRow": "Silme",
            "dxDataGrid-editingConfirmDeleteMessage": "Bu kayd\u0131 silmek istedi\u011finize emin misiniz?",
            "dxDataGrid-validationCancelChanges": "De\u011fi\u015fiklikleri iptal et",
            "dxDataGrid-groupPanelEmptyText": "Bu s\xfctuna g\xf6re gruplamak i\xe7in bir s\xfctun ba\u015fl\u0131\u011f\u0131n\u0131 buraya s\xfcr\xfckleyin",
            "dxDataGrid-noDataText": "Veri yok",
            "dxDataGrid-searchPanelPlaceholder": "Arama...",
            "dxDataGrid-filterRowShowAllText": "(T\xfcm\xfc)",
            "dxDataGrid-filterRowResetOperationText": "S\u0131f\u0131rla",
            "dxDataGrid-filterRowOperationEquals": "E\u015fittir",
            "dxDataGrid-filterRowOperationNotEquals": "E\u015fit de\u011fil",
            "dxDataGrid-filterRowOperationLess": "Daha k\xfc\xe7\xfck",
            "dxDataGrid-filterRowOperationLessOrEquals": "Daha k\xfc\xe7\xfck veya e\u015fit",
            "dxDataGrid-filterRowOperationGreater": "Daha b\xfcy\xfck",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Daha b\xfcy\xfck veya e\u015fit",
            "dxDataGrid-filterRowOperationStartsWith": "\u0130le ba\u015flar",
            "dxDataGrid-filterRowOperationContains": "\u0130\xe7eren",
            "dxDataGrid-filterRowOperationNotContains": "\u0130\xe7ermeyen",
            "dxDataGrid-filterRowOperationEndsWith": "\u0130le biten",
            "dxDataGrid-filterRowOperationBetween": "Aras\u0131nda",
            "dxDataGrid-filterRowOperationBetweenStartText": "Ba\u015fla",
            "dxDataGrid-filterRowOperationBetweenEndText": "Biti\u015f",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Filtre uygula",
            "dxDataGrid-trueText": "evet",
            "dxDataGrid-falseText": "hay\u0131r",
            "dxDataGrid-sortingAscendingText": "Artan S\u0131ralama",
            "dxDataGrid-sortingDescendingText": "Azalan S\u0131ralama",
            "dxDataGrid-sortingClearText": "S\u0131ralamay\u0131 Temizle",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "De\u011fi\u015fiklikleri Kaydet",
            "dxDataGrid-editingCancelAllChanges": "De\u011fi\u015fiklikleri iptal et",
            "dxDataGrid-editingAddRow": "Sat\u0131r ekle",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "{1} min: {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "{1} max: {0}",
            "dxDataGrid-summaryAvg": "Ort: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "{1} ortalamas\u0131: {0}",
            "dxDataGrid-summarySum": "Top: {0}",
            "dxDataGrid-summarySumOtherColumn": "{1} toplam\u0131: {0}",
            "dxDataGrid-summaryCount": "Toplam: {0}",
            "dxDataGrid-columnFixingFix": "Sabitle",
            "dxDataGrid-columnFixingUnfix": "\xc7\xf6z",
            "dxDataGrid-columnFixingLeftPosition": "Sola",
            "dxDataGrid-columnFixingRightPosition": "Sa\u011fa",
            "dxDataGrid-exportTo": "D\u0131\u015fa aktar",
            "dxDataGrid-exportToExcel": "Excel dosyas\u0131na aktar",
            "dxDataGrid-exporting": "D\u0131\u015fa Aktar...",
            "dxDataGrid-excelFormat": "Excel dosyas\u0131",
            "dxDataGrid-selectedRows": "Se\xe7ili sat\u0131rlar",
            "dxDataGrid-exportSelectedRows": "Se\xe7ili sat\u0131rlar\u0131 aktar",
            "dxDataGrid-exportAll": "T\xfcm verileri d\u0131\u015fa aktar",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Blanks)",
            "dxDataGrid-headerFilterOK": "Tamam",
            "dxDataGrid-headerFilterCancel": "\u0130ptal",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "S\xfctun",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Veri",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtre h\xfccresi",
            "dxDataGrid-ariaCollapse": "Daralt",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Geni\u015flet",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Tablo",
            "dxDataGrid-ariaSearchInGrid": "Tabloda ara",
            "dxDataGrid-ariaSelectAll": "Hepsini se\xe7",
            "dxDataGrid-ariaSelectRow": "Sat\u0131r\u0131 se\xe7",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filtre Olu\u015fturucu",
            "dxDataGrid-filterPanelCreateFilter": "Filtre Olu\u015ftur",
            "dxDataGrid-filterPanelClearFilter": "Temizle",
            "dxDataGrid-filterPanelFilterEnabledHint": "Filtreyi etkinle\u015ftir",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Ekle",
            "dxPager-infoText": "Sayfa {0} / {1} ({2} veri)",
            "dxPager-pagesCountText": "aras\u0131nda",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "T\xfcm\xfc",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Genel Toplam",
            "dxPivotGrid-total": "{0} Toplam",
            "dxPivotGrid-fieldChooserTitle": "Alan Se\xe7ici",
            "dxPivotGrid-showFieldChooser": "Alan Se\xe7iciyi G\xf6ster",
            "dxPivotGrid-expandAll": "T\xfcm\xfcn\xfc Geni\u015flet",
            "dxPivotGrid-collapseAll": "T\xfcm\xfcn\xfc Daralt",
            "dxPivotGrid-sortColumnBySummary": '"{0}" Bu S\xfctuna G\xf6re S\u0131rala',
            "dxPivotGrid-sortRowBySummary": '"{0}" Bu Sat\u0131ra G\xf6re S\u0131rala',
            "dxPivotGrid-removeAllSorting": "T\xfcm S\u0131ralamalar\u0131 Kald\u0131r",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "Sat\u0131r Alanlar\u0131",
            "dxPivotGrid-columnFields": "S\xfctun Alanlar\u0131",
            "dxPivotGrid-dataFields": "Veri Alanlar\u0131",
            "dxPivotGrid-filterFields": "Filtre Alanlar\u0131",
            "dxPivotGrid-allFields": "T\xfcm Alanlar",
            "dxPivotGrid-columnFieldArea": "S\xfctun Alanlar\u0131n\u0131 Buraya B\u0131rak",
            "dxPivotGrid-dataFieldArea": "Veri Alanlar\u0131n\u0131 Buraya B\u0131rak",
            "dxPivotGrid-rowFieldArea": "Sat\u0131r Alanlar\u0131n\u0131 Buraya B\u0131rak",
            "dxPivotGrid-filterFieldArea": "Filtre Alanlar\u0131n\u0131 Buraya B\u0131rak",
            "dxScheduler-editorLabelTitle": "Konu",
            "dxScheduler-editorLabelStartDate": "Ba\u015flang\u0131\xe7 Tarihi",
            "dxScheduler-editorLabelEndDate": "Biti\u015f Tarihi",
            "dxScheduler-editorLabelDescription": "A\xe7\u0131klama",
            "dxScheduler-editorLabelRecurrence": "Tekrar",
            "dxScheduler-openAppointment": "Randevu A\xe7",
            "dxScheduler-recurrenceNever": "Asla",
            "dxScheduler-recurrenceMinutely": "Minutely",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "G\xfcnl\xfck",
            "dxScheduler-recurrenceWeekly": "Haftal\u0131k",
            "dxScheduler-recurrenceMonthly": "Ayl\u0131k",
            "dxScheduler-recurrenceYearly": "Y\u0131ll\u0131k",
            "dxScheduler-recurrenceRepeatEvery": "Her tekrarla",
            "dxScheduler-recurrenceRepeatOn": "Tekrarla",
            "dxScheduler-recurrenceEnd": "Tekrar\u0131 bitir",
            "dxScheduler-recurrenceAfter": "Sonra",
            "dxScheduler-recurrenceOn": "\u0130le",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "g\xfcnler",
            "dxScheduler-recurrenceRepeatWeekly": "haftalar",
            "dxScheduler-recurrenceRepeatMonthly": "aylar",
            "dxScheduler-recurrenceRepeatYearly": "y\u0131llar",
            "dxScheduler-switcherDay": "G\xfcn",
            "dxScheduler-switcherWeek": "Hafta",
            "dxScheduler-switcherWorkWeek": "\xc7al\u0131\u015fma Haftas\u0131",
            "dxScheduler-switcherMonth": "Ay",
            "dxScheduler-switcherAgenda": "Ajanda",
            "dxScheduler-switcherTimelineDay": "Zaman \xc7izelgesi G\xfcn\xfc",
            "dxScheduler-switcherTimelineWeek": "Zaman \xc7izelgesi Haftas\u0131",
            "dxScheduler-switcherTimelineWorkWeek": "Zaman \xc7izelgesi \xc7al\u0131\u015fma Haftas\u0131",
            "dxScheduler-switcherTimelineMonth": "TZaman \xc7izelgesi \xc7al\u0131\u015fma Ay\u0131",
            "dxScheduler-recurrenceRepeatOnDate": "tarihinde",
            "dxScheduler-recurrenceRepeatCount": "olaylar",
            "dxScheduler-allDay": "T\xfcm g\xfcn",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Yaln\u0131zca bu randevuyu veya t\xfcm diziyi d\xfczenlemek ister misiniz?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Yaln\u0131zca bu randevuyu veya t\xfcm diziyi silmek istiyor musunuz?",
            "dxScheduler-confirmRecurrenceEditSeries": "Serileri d\xfczenle",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Serileri sil",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Randevuyu d\xfczenle",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Randevuyu sil",
            "dxScheduler-noTimezoneTitle": "Saat dilimi yok",
            "dxScheduler-moreAppointments": "{0} daha",
            "dxCalendar-todayButtonText": "Bug\xfcn",
            "dxCalendar-ariaWidgetName": "Takvim",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxColorView-ariaRed": "K\u0131rm\u0131z\u0131",
            "dxColorView-ariaGreen": "Ye\u015fil",
            "dxColorView-ariaBlue": "Mavi",
            "dxColorView-ariaAlpha": "\u015eeffafl\u0131k",
            "dxColorView-ariaHex": "Renk kodu",
            "dxTagBox-selected": "{0} se\xe7ili",
            "dxTagBox-allSelected": "T\xfcm\xfc se\xe7ildi ({0})",
            "dxTagBox-moreSelected": "{0} daha",
            "vizExport-printingButtonText": "Yazd\u0131r",
            "vizExport-titleMenuText": "D\u0131\u015fa Aktar/Yazd\u0131r",
            "vizExport-exportButtonText": "{0} dosya",
            "dxFilterBuilder-and": "Ve",
            "dxFilterBuilder-or": "Veya",
            "dxFilterBuilder-notAnd": "De\u011fil Ve",
            "dxFilterBuilder-notOr": "De\u011fil Veya",
            "dxFilterBuilder-addCondition": "Ko\u015ful Ekle",
            "dxFilterBuilder-addGroup": "Grup Ekle",
            "dxFilterBuilder-enterValueText": "<de\u011fer gir>",
            "dxFilterBuilder-filterOperationEquals": "E\u015fit",
            "dxFilterBuilder-filterOperationNotEquals": "E\u015fit de\u011fil",
            "dxFilterBuilder-filterOperationLess": "Daha k\xfc\xe7\xfck",
            "dxFilterBuilder-filterOperationLessOrEquals": "Daha k\xfc\xe7\xfck veya e\u015fit",
            "dxFilterBuilder-filterOperationGreater": "Daha b\xfcy\xfck",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Daha b\xfcy\xfck veya e\u015fit",
            "dxFilterBuilder-filterOperationStartsWith": "\u0130le ba\u015flar",
            "dxFilterBuilder-filterOperationContains": "\u0130\xe7erir",
            "dxFilterBuilder-filterOperationNotContains": "\u0130\xe7ermez",
            "dxFilterBuilder-filterOperationEndsWith": "\u0130le biter",
            "dxFilterBuilder-filterOperationIsBlank": "Bo\u015f",
            "dxFilterBuilder-filterOperationIsNotBlank": "Bo\u015f de\u011fil",
            "dxFilterBuilder-filterOperationBetween": "Aras\u0131nda",
            "dxFilterBuilder-filterOperationAnyOf": "Herhangi biri",
            "dxFilterBuilder-filterOperationNoneOf": "Hi\xe7biri",
            "dxHtmlEditor-dialogColorCaption": "Yaz\u0131 Tipi Rengini De\u011fi\u015ftir",
            "dxHtmlEditor-dialogBackgroundCaption": "Arka Plan Rengini De\u011fi\u015ftir",
            "dxHtmlEditor-dialogLinkCaption": "Link Ekle",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Metin",
            "dxHtmlEditor-dialogLinkTargetField": "Linki yeni pencerede a\xe7",
            "dxHtmlEditor-dialogImageCaption": "Resim Ekle",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternatif metin",
            "dxHtmlEditor-dialogImageWidthField": "Geni\u015flik (px)",
            "dxHtmlEditor-dialogImageHeightField": "Y\xfckseklik (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Sat\u0131r",
            "dxHtmlEditor-dialogInsertTableColumnsField": "S\xfctun",
            "dxHtmlEditor-dialogInsertTableCaption": "Tablo Ekle",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Ba\u015fl\u0131k",
            "dxHtmlEditor-normalText": "Normal metin",
            "dxHtmlEditor-background": "Arka Plan Rengi",
            "dxHtmlEditor-bold": "Kal\u0131n",
            "dxHtmlEditor-color": "Yaz\u0131 Tipi Rengi",
            "dxHtmlEditor-font": "Yaz\u0131 Tipi",
            "dxHtmlEditor-italic": "Yat\u0131k",
            "dxHtmlEditor-link": "Ba\u011flant\u0131 Ekle",
            "dxHtmlEditor-image": "Resim Ekle",
            "dxHtmlEditor-size": "Boyut",
            "dxHtmlEditor-strike": "\xdcst\xfc \xc7izili",
            "dxHtmlEditor-subscript": "Alt Simge",
            "dxHtmlEditor-superscript": "\xdcst Simge",
            "dxHtmlEditor-underline": "At\u0131 \xc7izili",
            "dxHtmlEditor-blockquote": "\xd6bek",
            "dxHtmlEditor-header": "\xdcst Bilgi",
            "dxHtmlEditor-increaseIndent": "Girintiyi Art\u0131r",
            "dxHtmlEditor-decreaseIndent": "Girintiyi Azalt",
            "dxHtmlEditor-orderedList": "S\u0131ral\u0131 Liste",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxFileManager-newDirectoryName": "Untitled directory",
            "dxFileManager-rootDirectoryName": "Files",
            "dxFileManager-errorNoAccess": "Eri\u015fim reddedildi. \u0130\u015flem tamamlanam\u0131yor.",
            "dxFileManager-errorDirectoryExistsFormat": "Klas\xf6r '{0}' zaten var.",
            "dxFileManager-errorFileExistsFormat": "Dosya '{0}' zaten var.",
            "dxFileManager-errorFileNotFoundFormat": "Dosya '{0}' bulunamad\u0131",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directory '{0}' not found.",
            "dxFileManager-errorWrongFileExtension": "File extension is not allowed.",
            "dxFileManager-errorMaxFileSizeExceeded": "File size exceeds the maximum allowed size.",
            "dxFileManager-errorInvalidSymbols": "This name contains invalid characters.",
            "dxFileManager-errorDefault": "Belirtilmemi\u015f hata.",
            "dxFileManager-errorDirectoryOpenFailed": "The directory cannot be opened",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "Copy to",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "Refresh",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "Clear selection",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Move",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copy to",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copy",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "Save",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "Create",
            "dxFileManager-dialogDeleteItemTitle": "Delete",
            "dxFileManager-dialogDeleteItemButtonText": "Delete",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "Cancel",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Name",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "General",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Org Chart",
            "dxDiagram-categoryContainers": "Containers",
            "dxDiagram-categoryCustom": "Custom",
            "dxDiagram-commandExportToSvg": "Export to SVG",
            "dxDiagram-commandExportToPng": "Export to PNG",
            "dxDiagram-commandExportToJpg": "Export to JPEG",
            "dxDiagram-commandUndo": "Undo",
            "dxDiagram-commandRedo": "Redo",
            "dxDiagram-commandFontName": "Font Name",
            "dxDiagram-commandFontSize": "Font Size",
            "dxDiagram-commandBold": "Bold",
            "dxDiagram-commandItalic": "Italic",
            "dxDiagram-commandUnderline": "Underline",
            "dxDiagram-commandTextColor": "Font Color",
            "dxDiagram-commandLineColor": "Line Color",
            "dxDiagram-commandLineWidth": "Line Width",
            "dxDiagram-commandLineStyle": "Line Style",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Dotted",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "Fill Color",
            "dxDiagram-commandAlignLeft": "Align Left",
            "dxDiagram-commandAlignCenter": "Align Center",
            "dxDiagram-commandAlignRight": "Align Right",
            "dxDiagram-commandConnectorLineType": "Connector Line Type",
            "dxDiagram-commandConnectorLineStraight": "Straight",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonal",
            "dxDiagram-commandConnectorLineStart": "Connector Line Start",
            "dxDiagram-commandConnectorLineEnd": "Connector Line End",
            "dxDiagram-commandConnectorLineNone": "None",
            "dxDiagram-commandConnectorLineArrow": "Arrow",
            "dxDiagram-commandFullscreen": "Full Screen",
            "dxDiagram-commandUnits": "Units",
            "dxDiagram-commandPageSize": "Page Size",
            "dxDiagram-commandPageOrientation": "Page Orientation",
            "dxDiagram-commandPageOrientationLandscape": "Landscape",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Page Color",
            "dxDiagram-commandShowGrid": "Show Grid",
            "dxDiagram-commandSnapToGrid": "Snap to Grid",
            "dxDiagram-commandGridSize": "Grid Size",
            "dxDiagram-commandZoomLevel": "Zoom Level",
            "dxDiagram-commandAutoZoom": "Auto Zoom",
            "dxDiagram-commandFitToContent": "Fit to Content",
            "dxDiagram-commandFitToWidth": "Fit to Width",
            "dxDiagram-commandAutoZoomByContent": "Auto Zoom by Content",
            "dxDiagram-commandAutoZoomByWidth": "Auto Zoom by Width",
            "dxDiagram-commandSimpleView": "Simple View",
            "dxDiagram-commandCut": "Cut",
            "dxDiagram-commandCopy": "Copy",
            "dxDiagram-commandPaste": "Paste",
            "dxDiagram-commandSelectAll": "Select All",
            "dxDiagram-commandDelete": "Delete",
            "dxDiagram-commandBringToFront": "Bring to Front",
            "dxDiagram-commandSendToBack": "Send to Back",
            "dxDiagram-commandLock": "Lock",
            "dxDiagram-commandUnlock": "Unlock",
            "dxDiagram-commandInsertShapeImage": "Insert Image...",
            "dxDiagram-commandEditShapeImage": "Change Image...",
            "dxDiagram-commandDeleteShapeImage": "Delete Image",
            "dxDiagram-commandLayoutLeftToRight": "Left-to-right",
            "dxDiagram-commandLayoutRightToLeft": "Right-to-left",
            "dxDiagram-commandLayoutTopToBottom": "Top-to-bottom",
            "dxDiagram-commandLayoutBottomToTop": "Bottom-to-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Cancel",
            "dxDiagram-dialogInsertShapeImageTitle": "Insert Image",
            "dxDiagram-dialogEditShapeImageTitle": "Change Image",
            "dxDiagram-dialogEditShapeImageSelectButton": "Select image",
            "dxDiagram-dialogEditShapeImageLabelText": "or drop a file here",
            "dxDiagram-uiExport": "Export",
            "dxDiagram-uiProperties": "Properties",
            "dxDiagram-uiSettings": "Settings",
            "dxDiagram-uiShowToolbox": "Show Toolbox",
            "dxDiagram-uiSearch": "Search",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tree",
            "dxDiagram-uiLayoutLayered": "Layered",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "Page",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Cross",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamond",
            "dxDiagram-shapeHeart": "Heart",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Star",
            "dxDiagram-shapeArrowLeft": "Left Arrow",
            "dxDiagram-shapeArrowUp": "Up Arrow",
            "dxDiagram-shapeArrowRight": "Right Arrow",
            "dxDiagram-shapeArrowDown": "Down Arrow",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "Left Right Arrow",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Decision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Predefined Process",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Multiple Documents",
            "dxDiagram-shapeManualInput": "Manual Input",
            "dxDiagram-shapePreparation": "Preparation",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Internal Storage",
            "dxDiagram-shapePaperTape": "Paper Tape",
            "dxDiagram-shapeManualOperation": "Manual Operation",
            "dxDiagram-shapeDelay": "Delay",
            "dxDiagram-shapeStoredData": "Stored Data",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "Merge",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "Or",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertical Container",
            "dxDiagram-shapeHorizontalContainer": "Horizontal Container",
            "dxDiagram-shapeCardDefaultText": "Person's Name",
            "dxDiagram-shapeCardWithImageOnLeft": "Card with Image on the Left",
            "dxDiagram-shapeCardWithImageOnTop": "Card with Image on the Top",
            "dxDiagram-shapeCardWithImageOnRight": "Card with Image on the Right",
            "dxGantt-dialogTitle": "Title",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "Add",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resources: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Undo",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "Expand All",
            "dxGantt-collapseAll": "Collapse All",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "Zoom In",
            "dxGantt-zoomOut": "Zoom Out",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Artan S\u0131ralama",
            "dxGantt-sortingDescendingText": "Azalan S\u0131ralama",
            "dxGantt-sortingClearText": "S\u0131ralamay\u0131 Temizle",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}"
        }
    })
}));
