/**
 * 
 * Base template Configuration
 */

baseWidth = 180;
baseHeight = 150;

baseNodeMenuButtonX = baseWidth - 20;
baseNodeMenuButtonY = baseHeight - 20;

secondaryColor = "#95BFFA";
baseFieldsSharedAttributes = 'data-width="180" data-text-overflow="multiline" fill="#353535" x="90" text-anchor="middle"';


/**
 * Base template definition
 */ 
OrgChart.templates.base = Object.assign({}, OrgChart.templates.ana);
OrgChart.templates.base.node = `<rect x="0" y="0" rx="4" ry="4" filter="url(#shadow1)" width="${baseWidth}" height="${baseHeight}" fill="white" stroke-width="1" stroke="${secondaryColor}"></rect>` 
                             + `<line x1="0" y1="40" x2="180" y2="40" stroke-width="1" stroke="${secondaryColor}" />`; 

OrgChart.templates.base.size = [baseWidth, baseHeight];
OrgChart.templates.base.ripple = {
                                    radius: 0,
                                    color: "#e6e6e6",
                                    rect: null
                                };

OrgChart.templates.base.plus = `<circle cx="15" cy="15" r="12" fill="${secondaryColor}" stroke="#fff" stroke-width="1"></circle>`
                             + '<line x1="-2" y1="15" x2="32" y2="15" stroke-width="1" stroke="#fff"></line>'
                             + '<line x1="15" y1="-2" x2="15" y2="32" stroke-width="1" stroke="#fff"></line>';
OrgChart.templates.base.minus = `<circle cx="15" cy="15" r="12" fill="${secondaryColor}" stroke="#fff" stroke-width="1"></circle>`
                              + '<line x1="-2" y1="15" x2="32" y2="15" stroke-width="1" stroke="#fff"></line>';

OrgChart.templates.base.field_0 = `<text ${baseFieldsSharedAttributes} class="field_0" style="font-size: 12px;" y="25" font-weight="bold">{val}</text>`;
OrgChart.templates.base.field_1 = `<text ${baseFieldsSharedAttributes} class="field_1" style="font-size: 10px;" y="70" font-weight="bold">{val}</text>`;
OrgChart.templates.base.field_2 = `<text ${baseFieldsSharedAttributes} class="field_2" style="font-size: 8px;"  y="105">{val}</text>`;

OrgChart.templates.base.nodeMenuButton  = `<g style="cursor:pointer;" transform="matrix(1,0,0,1,${baseNodeMenuButtonX},${baseNodeMenuButtonY})" data-ctrl-n-menu-id="{id}">`
                                        + '<rect x="-4" y="-10" fill="#000000" fill-opacity="0" width="22" height="22">'
                                        + '</rect>'
                                        + `<line x1="0" y1="0" x2="0" y2="7" stroke-width="2" stroke="${secondaryColor}" />`
                                        + `<line x1="7" y1="0" x2="7" y2="7" stroke-width="2" stroke="${secondaryColor}" />`
                                        + `<line x1="14" y1="0" x2="14" y2="7" stroke-width="2" stroke="${secondaryColor}" />`
                                        + '</g>';
 