/*

  -------------------.-.--------------------
  DxScheduler Wrapper for INDE 23 with Fluid
                  12/12/2023
  ------------------------------------------
  
*/
let indeID = ""
Client.Scheduler = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);

  if(!Client.Scheduler.inited || !element.configuration || !element.id) {
    Client.Scheduler.Realize = parent;
    this.scheduler_rendered = false
    return;
  }
  

  /*
    If the scheduler was previously drawn we destroy the instance to create a new one
  */
  if (this.calendar) {
    this.calendar.destroy();
  }
    
  // read the Configuration shared by INDE
  var configuration = element.configuration
  this.dxScheduler_configuration = configuration;
  this.sc_timezone = configuration.timezone;
  this.sc_currentView = configuration.currentView;
  this.sc_currentDate = configuration.currentDate;
  this.sc_firstDayOfWeek = configuration.firstDayOfWeek;
  this.sc_startDayHour = configuration.startDayHour;
  this.sc_endDayHour = configuration.endDayHour;
  this.sc_showAllDayPanel = configuration.showAllDayPanel;
  this.sc_views = configuration.views;
  this.sc_cellDuration = configuration.cellDuration;
  this.sc_height = configuration.height;
  this.sc_width = configuration.width;
  this.sc_resources = configuration.resources;
  this.indeFormIndex = configuration.indeFormIndex;
  this.id = element.id;
  indeID = this.indeFormIndex

  /*
    Create the Div to put inside the dxScheduler
  */
  this.domObj = document.createElement("div");
  this.domObj.id = `scheduler_${indeID}`;
  parent.appendChildObject(this, this.domObj);
  this.calendarDiv = this.domObj;

  /*
    Draw the dxScheduler inside the Div
  */
  function isWeekEnd(date) {
    const day = date.getDay();
    return day === 0 || day === 6;
  }
  
  function getCurrentTraining(date, employeeID) {
    const result = (date + employeeID) % 3;
    const currentTraining = `training-background-${result}`;
    return currentTraining;
  }

  var selector = `#${this.domObj.id}`;
  DevExpress.localization.locale(navigator.language);
  $(selector).dxScheduler({

    /*
      Basic Configuration
    */
    id: indeID,
    dataSource: [],
    groups: ['employeeID'],
    cellDuration: 15,
    resources: [
      {
        fieldExpr: 'employeeID',
        allowMultiple: false,
        dataSource: [{}],
        label: 'Employee',
      },
    ],
    
    /*
      Events to be handled 
    */
       
    onInitialized: function(info) {
      if(info)
      {
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"refresh",content: "something"}`);
      }
    },
    
    onAppointmentClick: function(event) {
      if(event){
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"appointmentClick",content: "${event.appointmentData.ID}"}`);
      }
    }, 
    
    onAppointmentDblClick: function(event) {
      if(event){
        event.cancel = true;
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"appointmentDoubleClick",content: "${event.appointmentData.ID}"}`);
      }           
    }, 

    /*
    onOptionChanged: function(data) {
      if(data.name == "currentDate") {
        convertedDate = new Date(data.value).toLocaleDateString('it-IT');
        //this.SendEvent("CurrentDateChanged", [data.name, convertedDate]);
      }
    },
    */
    
        
    /*
      Rendering Part
    */

    timeCellTemplate(itemData, itemIndex, itemElement) {
      const element = $(`<div>${itemData.text}</div>`);
      const { date } = itemData;
      element.append('<div class="cafe" />');
      return itemElement.append(element);
    },

    appointmentTooltipTemplate(data) {
      eventData = data.targetedAppointmentData;
      return $(`${"<div class='event-tooltip' style='font-size: 12px !important;'>"
                      + "<img width='20' height='20' src='"}${eventData.image}' />`
                      + '<div class=\'event-info\'>'
                          + `<div class='event-title'>${eventData.text}` + '</div>'
                          + '<div>' + `Tipo: ${eventData.type}</div>`
                          + '<div>' + `Descrizione: ${eventData.description}` + '</div>'
                      + '</div>'
                  + '</div>');
    },


    appointmentTemplate(data) {
      const eventData = data.targetedAppointmentData;
      return $(`${"<div class='showtime-preview' style='font-size: 12px !important;'>" 
                        + "<img width='20' height='20' src='"}${eventData.image}'/>`
                        + `<span style="white-space: break-spaces; height: auto;"><strong>${eventData.text}</strong></span>`
                        + `<div style="white-space: break-spaces; height: auto;">Tipo: ${eventData.type}`
                        + '</div>'
                        + `<div style="white-space: break-spaces; height: auto;">${eventData.description}</div>`
                    + '</div>');
    },

    dataCellTemplate(cellData, index, container) {
      const hours = cellData.startDate.getHours();
      

      if(hours <= 8 || hours >= 17){
        container.css('background-color', '#f5f5f5');
      }


      const day = cellData.startDate.getDay();
      if(day == 0 || day == 6){
        container.css('background-color', '#ededed');
      }
    return container;
    },
    
    resourceCellTemplate(cellData) {
      const avatarAndName = document.createElement('div');
      avatarAndName.classList.add('resources');
      avatarAndName.style.backgroundColor = cellData.color;
      if (cellData.data.avatar){
        const image = document.createElement('img');
        image.src = cellData.data.avatar;
        image.width = 64;
        image.height = 64;
        image.alt = 'Foto profilo';
        const span = document.createElement('span');
        span.appendChild(image);
        avatarAndName.appendChild(span);
      }
      const textDiv = document.createElement('div');
      textDiv.textContent = cellData.text;
      avatarAndName.appendChild(textDiv);
      const container = document.createElement('div');
      container.appendChild(avatarAndName);
      return container;
    },

    
    dateCellTemplate(itemData, itemIndex, itemElement) {
      const dateHeaderContent = $(`<div>${itemData.text}</div>`);
      const actualDay = itemData.date.getDay();
      const isWekeendCheck = actualDay == 0 || actualDay == 6;
      if (isWekeendCheck) {
        itemElement.css('backgroundColor', '#ededed');
      }
      itemElement.css('font-weight', 600);
      itemElement.append(dateHeaderContent);
      return itemElement;
    },

    timeCellTemplate(itemData, itemIndex, itemElement) {
      const element = $(`<div>${itemData.text}</div>`);
      const { date } = itemData;
      const hours = date.getHours();
      if (hours >= 12 && hours < 13) {
        itemElement.css('font-color', 'rgb(242, 245, 188 / 40%');
      }
      const minutes = date.getMinutes();
      return itemElement.append(element);
    },
  });
       
  
  /*
    Store the dxScheduler instance into this.calendar
  */
  this.calendar = $(selector).dxScheduler("instance");

  
  /*
    set the options of the dxScheduler instance with the values read by element.configuration
  */
  if(this.sc_timezone){this.calendar.option("timezone",  this.sc_timezone);}
  if(this.sc_timcurrentViewezone){this.calendar.option("currentView",  this.sc_timcurrentViewezone);}
  if(this.sc_currentDate){this.calendar.option("currentDate",  this.sc_currentDate);}
  if(this.sc_firstDayOfWeek){this.calendar.option("firstDayOfWeek",  this.sc_firstDayOfWeek);}
  if(this.sc_startDayHour){this.calendar.option("startDayHour",  this.sc_startDayHour);}
  if(this.sc_endDayHour){this.calendar.option("endDayHour",  this.sc_endDayHour);}
  if(this.sc_showAllDayPanel){this.calendar.option("showAllDayPanel",  this.sc_showAllDayPanel);}
  if(this.sc_views){this.calendar.option("views",  this.sc_views);}
  if(this.sc_cellDuration){this.calendar.option("cellDuration",  this.sc_cellDuration);}
  if(this.sc_height>0){this.calendar.option("height",  this.sc_height);}
  if( this.sc_width>0){this.calendar.option("width",  this.sc_width);}
  if(this.sc_resources){this.calendar.option("resources",  this.sc_resources);}
  this.sc_rendered = true;
  this.attachEvents(element.events);
};

// Define extension of class
Client.Scheduler.prototype = new Client.Element();
Client.Scheduler.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Scheduler.getRequirements = function ()
{
  let prefix = Client.mainFrame.isIDF ? "fluid/" : "";
  let req = {};
  /*
    Here we have an example of how to load the required files
    req[prefix + "objects/Scheduler/js/dx.all.js"] = {type: "jc", name: "dx.all.js"};
    req[prefix + "objects/Scheduler/css/dx.light.css"] = {type: "cs", name: "dx.light.css"};
    req[prefix + "objects/Scheduler/js/jquery-3.5.1.min.js"] = {type: "jc", name: "jquery-3.5.1.min.js"};
  */
  Client.Scheduler.inited = true;
  return req;
};


/*
  Destroy the dxScheduler instance and remove the Div that has contained the dxScheduler
*/
Client.Scheduler.prototype.close = function (firstLevel, triggerAnimation)
{
  if (this.calendar){this.calendar.dispose();}
  delete this.calendar;
  if(this.calendarDiv && this.calendarDiv.parentNode){this.calendarDiv.parentNode.removeChild(this.calendarDiv);}
  if(this.calendarDiv){delete this.calendarDiv;}
}

// custom procedure to udpate the dxScheduler Configuration
// from inde: USE an IDMAP that will be decoded in "data"
Client.Scheduler.prototype.updateConfiguration = function(data) {
  this.calendar = $('#myScheduler').dxScheduler(data);
}

// this procedure adds an Appointment in the dxScheduler
// from inde: USE an IDMAP in which store  text, employeeID, startDate and endDate
// to avoid inserting 2 times the same event, before inserting the event in the calendar we check if already exists 
Client.Scheduler.prototype.addEvent = function(data) {
  searchEvent = this.findEvent(this.calendar._dataSource._items, data);
  if(!searchEvent){
    this.calendar.addAppointment (data);
  }
}

Client.Scheduler.prototype.findEvent = function(datasource, data) {
  if(data){
    if(data.ID){
      searchedID = data.ID
      dataSourceLenght = datasource.length;
      for(i = 0; i < dataSourceLenght; i++){
        if(datasource[i]){
          currentID = datasource[i].ID;
          if(currentID == searchedID){
            return datasource[i];
          }
        }
      }
    }
  }
}

Client.Scheduler.prototype.storeOption = function(optionName, optionValue) {
  switch(optionName){
    case "timezone":
      this.sc_timezone = optionValue;
    case "currentView":
      this.sc_timcurrentViewezone = optionValue;
    case "currentDate":
      this.sc_currentDate = optionValue;
    case "firstDayOfWeek":
      this.sc_firstDayOfWeek = optionValue;
    case "startDayHour":
      this.sc_startDayHour = optionValue;
    case "endDayHour":
      this.sc_endDayHour = optionValue;
    case "showAllDayPanel":
      this.sc_showAllDayPanel = optionValue;
    case "views":
      this.sc_views = optionValue;
    case "cellDuration":
      this.sc_cellDuration = optionValue;
    case "height":
      this.sc_height = optionValue;
    case "width":
      this.sc_width = optionValue;
    case "resources":
      this.sc_resources = optionValue;
    default: 
      console.log("Wrong usage!");
  }
}



// this procedure deletes an Appointment from the dxScheduler
Client.Scheduler.prototype.deleteEvent = function(data) {
  if(data){
    if(data.ID){
      var foundEvent = this.findEvent(this.calendar._dataSource._items, data);
      if(foundEvent){
        this.calendar.deleteAppointment(this.calendar._dataSource._items[i]);
      }
    }
  }
}

// this procedure changes the Options in the configuration Scheduler 
Client.Scheduler.prototype.setOptions = function(options) {
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;
      
      if(oName && oValue){
        this.storeOption(oName,oValue);
        /*
        switch(oName){
          case "timezone":
            this.sc_timezone = oValue;
          case "currentView":
            this.sc_timcurrentViewezone = oValue;
          case "currentDate":
            this.sc_currentDate = oValue;
          case "firstDayOfWeek":
            this.sc_firstDayOfWeek = oValue;
          case "startDayHour":
            this.sc_startDayHour = oValue;
          case "endDayHour":
            this.sc_endDayHour = oValue;
          case "showAllDayPanel":
            this.sc_showAllDayPanel = oValue;
          case "views":
            this.sc_views = oValue;
          case "cellDuration":
            this.sc_cellDuration = oValue;
          case "height":
            this.sc_height = oValue;
          case "width":
            this.sc_width = oValue;
          case "resources":
            this.sc_resources = oValue;
          default: 
            console.log("Wrong usage of setOption procedure of Scheduler");
        }
        */
        this.calendar.option(oName, oValue);
      }
    }
  }
}

// this procedure changes language of this scheduler
Client.Scheduler.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

// this procedure delete an Appointment from the dxScheduler
Client.Scheduler.prototype.checkdatasource = function() {
 console.log(this.calendar._dataSource._items);
}

/*
  Test Buttons js
*/
function test(buttonID,eventID){
  console.log("test has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}
