/*!
* DevExtreme (dx.viz.js)
* Version: 23.1.6
* Build date: Fri Oct 13 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";!function(){var t={66798:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.registerPattern=e.registerGradient=e.default=void 0;var i=n(19157);function a(){return(a=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var o={};e.registerPattern=function(t){var e=(0,i.getNextDefsSvgId)();return o[e]=a({type:"pattern"},t),e};e.registerGradient=function(t,e){var n=(0,i.getNextDefsSvgId)();return o[n]=a({type:t},e),n};var r={getGraphicObjects:function(){return o}};e.default=r},60082:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=w(n(68374)),a=n(20576),o=n(47617),r=n(62754),s=n(13306),l=n(95479),c=n(37518),u=n(58664),d=n(68752),h=n(35922),f=w(n(26974)),p=n(58201),g=n(85273),m=n(9234),_=n(16454),v=w(n(55994)),b=w(n(30343)),y=w(n(97218)),x=w(n(18740));function w(t){return t&&t.__esModule?t:{default:t}}function k(){return(k=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var S={year:function(t){return t&&t.getFullYear()},month:function(t){return t&&t.getMonth()+1},day:function(t){return t&&t.getDate()},quarter:function(t){return t&&Math.floor(t.getMonth()/3)+1},hour:function(t){return t&&t.getHours()},minute:function(t){return t&&t.getMinutes()},second:function(t){return t&&t.getSeconds()}},C=function(){var t=arguments[1],e=this.calculateCellValue(t);if(!(0,h.isDefined)(e))return null;if(A(this.dataType)){var n=arguments[0];return S[n](e)}if("number"===this.dataType){var i=arguments[0];return Math.floor(Number(e)/i)*i}};function A(t){return"date"===t||"datetime"===t}var E=function(t){t.get(0).textContent="\xa0"},T=function(t){t=t||[];for(var e=(0,_.normalizeSortingInfo)(t),n=0;n<t.length;n++)t&&t[n]&&void 0!==t[n].isExpanded&&(e[n].isExpanded=t[n].isExpanded),t&&t[n]&&void 0!==t[n].groupInterval&&(e[n].groupInterval=t[n].groupInterval);return e},I=function(t,e){var n=b.default.format(t,e.format)||t&&t.toString()||"",i={value:t,valueText:e.getDisplayFormat?e.getDisplayFormat(n):n,target:e.target||"row",groupInterval:e.groupInterval};return e.customizeText?e.customizeText.call(e,i):i.valueText},D=function(t,e){var n=t.displayFormat||t.columnCaption&&e["".concat(t.summaryType,"OtherColumn")]||e[t.summaryType];return I(t.value,{format:t.valueFormat,getDisplayFormat:function(e){return n?(0,d.format)(n,e,t.columnCaption):e},customizeText:t.customizeText})},O=function(t){var e=t.data&&t.data(),n=e&&e.dxComponents,i=n&&n[0];return i&&e[i]};var L={renderNoDataText:function(t){if(t=t||this.element()){var e=this.addWidgetPrefix("nodata"),n=t.find(".".concat(e)).last(),a=this._dataController.isEmpty(),o=this._dataController.isLoading();n.length||(n=(0,i.default)("<span>").addClass(e)),n.parent().is(t)||n.appendTo(t),a&&!o?n.removeClass("dx-hidden").text(this._getNoDataText()):n.addClass("dx-hidden")}},renderLoadPanel:function(t,e,n){var a;this._loadPanel&&this._loadPanel.$element().remove(),(a=this.option("loadPanel"))&&("auto"===a.enabled?!n:a.enabled)?(a=(0,s.extend)({shading:!1,message:a.text,container:e},a),this._loadPanel=this._createComponent((0,i.default)("<div>").appendTo(e),y.default,a)):this._loadPanel=null},calculateLoadPanelPosition:function(t){var e=(0,i.default)((0,p.getWindow)());return(0,u.getHeight)(t)>(0,u.getHeight)(e)?{of:e,boundary:t,collision:"fit"}:{of:t}},getIndexByKey:function(t,e,n){var i=-1;if(void 0!==t&&Array.isArray(e)){n=arguments.length<=2?"key":n;for(var o=0;o<e.length;o++){var r=(0,h.isDefined)(n)?e[o][n]:e[o];if((0,a.equalByValue)(t,r)){i=o;break}}}return i},combineFilters:function(t,e){var n,i=[];e=e||"and";for(var a=0;a<t.length;a++)if(t[a]){if(1===(null===(n=t[a])||void 0===n?void 0:n.length)&&"!"===t[a][0]){if("and"===e)return["!"];if("or"===e)continue}i.length&&i.push(e),i.push(t[a])}if(1===i.length&&(i=i[0]),i.length)return i},checkChanges:function(t,e){for(var n=0,i=0;i<e.length;i++)t[e[i]]&&n++;return t.length&&t.length===n},equalFilterParameters:function t(e,n){if(Array.isArray(e)&&Array.isArray(n)){if(e.length!==n.length)return!1;for(var i=0;i<e.length;i++)if(!t(e[i],n[i]))return!1;return!0}return(0,h.isFunction)(e)&&e.columnIndex>=0&&(0,h.isFunction)(n)&&n.columnIndex>=0?e.columnIndex===n.columnIndex&&(0,o.toComparable)(e.filterValue)===(0,o.toComparable)(n.filterValue)&&(0,o.toComparable)(e.selectedFilterOperation)===(0,o.toComparable)(n.selectedFilterOperation):(0,o.toComparable)(e)==(0,o.toComparable)(n)},proxyMethod:function(t,e,n){t[e]||(t[e]=function(){var t=this._dataSource;return t?t[e].apply(t,arguments):n})},formatValue:I,getFormatOptionsByColumn:function(t,e){return{format:t.format,getDisplayFormat:t.getDisplayFormat,customizeText:t.customizeText,target:e,trueText:t.trueText,falseText:t.falseText}},getDisplayValue:function(t,e,n,i){return t.displayValueMap&&void 0!==t.displayValueMap[e]?t.displayValueMap[e]:t.calculateDisplayValue&&n&&"group"!==i?t.calculateDisplayValue(n):!t.lookup||"group"===i&&(t.calculateGroupValue||t.calculateDisplayValue)?e:t.lookup.calculateCellValue(e)},getGroupRowSummaryText:function(t,e){for(var n="(",i=0;i<t.length;i++){var a=t[i];n+=(i>0?", ":"")+D(a,e)}return n+")"},getSummaryText:D,normalizeSortingInfo:T,getFormatByDataType:function(t){switch(t){case"date":return"shortDate";case"datetime":return"shortDateShortTime";default:return}},getHeaderFilterGroupParameters:function(t,e){var n=[],i=t.dataField||t.name,a=x.default.getGroupInterval(t);return a?((0,l.each)(a,(function(o,r){n.push(e?{selector:i,groupInterval:r,isExpanded:o<a.length-1}:C.bind(t,r))})),n):(e?n=[{selector:i,isExpanded:!1}]:(n=function(e){var n=t.calculateCellValue(e);return void 0!==n&&""!==n||(n=null),n},t.sortingMethod&&(n=[{selector:n,compare:t.sortingMethod.bind(t)}])),n)},equalSortParameters:function(t,e,n){if(t=T(t),e=T(e),Array.isArray(t)&&Array.isArray(e)){if(t.length!==e.length)return!1;for(var i=0;i<t.length;i++)if(a=t[i].selector,o=e[i].selector,!((0,h.isFunction)(a)&&(0,h.isFunction)(o)&&a.originalCallback&&o.originalCallback?a.originalCallback===o.originalCallback&&a.columnIndex===o.columnIndex:a===o)||t[i].desc!==e[i].desc||t[i].groupInterval!==e[i].groupInterval||!n&&Boolean(t[i].isExpanded)!==Boolean(e[i].isExpanded))return!1;return!0}var a,o;return(!t||!t.length)==(!e||!e.length)},getPointsByColumns:function(t,e,n,i){for(var a,o,r,s=t.length,l=!1,u=i||0,d=[],h=0;h<=s;h++){h<s&&(o=(a=t.eq(h)).offset(),r="rtl"===a.css("direction"));var f={index:u,x:o?o.left+(!n&&r^h===s?(0,c.getBoundingRect)(a[0]).width:0):0,y:o?o.top+(n&&h===s?(0,c.getBoundingRect)(a[0]).height:0):0,columnIndex:u};if(!n&&h>0){var p=t.eq(h-1).offset();p.top<f.y&&(f.y=p.top)}e&&(l=e(f)),l||d.push(f),u++}return d},getExpandCellTemplate:function(){return{allowRenderToDetachedContainer:!0,render:function(t,e){var n=(0,i.default)(t);if(!(0,h.isDefined)(e.value)||e.data&&e.data.isContinuation||e.row.isNewRow)E(n);else{var a=e.component.getView("rowsView");n.addClass("dx-datagrid-expand").addClass("dx-selection-disabled"),(0,i.default)("<div>").addClass(e.value?"dx-datagrid-group-opened":"dx-datagrid-group-closed").appendTo(n),a.setAria("label",e.value?a.localize("dxDataGrid-ariaCollapse"):a.localize("dxDataGrid-ariaExpand"),n)}}}},setEmptyText:E,isDateType:A,getSelectionRange:function(t){try{if(t)return{selectionStart:t.selectionStart,selectionEnd:t.selectionEnd}}catch(t){}return{}},setSelectionRange:function(t,e){try{t&&t.setSelectionRange&&t.setSelectionRange(e.selectionStart,e.selectionEnd)}catch(t){}},focusAndSelectElement:function(t,e){var n=e.is(":focus");v.default.trigger(e,"focus");var i=t.option("editing.selectTextOnEditStart"),a=e.get(0);if(!n&&i&&e.is(".dx-texteditor-input")&&!e.is("[readonly]")){var o=O(e.closest(".dx-texteditor"));(0,r.when)(o&&o._loadItemDeferred).done((function(){a.select()}))}},getWidgetInstance:O,getLastResizableColumnIndex:function(t,e){var n,i=t.some((function(t){return t&&!t.command&&!t.fixed&&!1!==t.allowResizing}));for(n=t.length-1;t[n];n--){var a=t[n],o=e&&e[n],r=!i||!1!==a.allowResizing;if(!a.command&&!a.fixed&&"adaptiveHidden"!==o&&r)break}return n},isElementInCurrentGrid:function(t,e){return!(!e||!e.length)&&e.closest(".".concat(t.getWidgetContainerClass())).parent().is(t.component.$element())},isVirtualRowRendering:function(t){var e=t.option("scrolling.rowRenderingMode"),n="virtual"===t.option("scrolling.mode"),i="infinite"===t.option("scrolling.mode");return!(!1!==t.option("scrolling.legacyMode")||!n&&!i)||"virtual"===e},getPixelRatio:function(t){return t.devicePixelRatio||1},getContentHeightLimit:function(t){return t.mozilla?8e6:15e6/this.getPixelRatio((0,p.getWindow)())},normalizeLookupDataSource:function(t){var e;return t.items?e=t.items:(e=t.dataSource,(0,h.isFunction)(e)&&!f.default.isWrapped(e)&&(e=e({}))),(0,m.normalizeDataSourceOptions)(e)},getWrappedLookupDataSource:function(t,e,n){var i=this;if(!e)return[];var a=this.normalizeLookupDataSource(t.lookup);if(t.calculateCellValue!==t.defaultCalculateCellValue)return a;var o,s,l,c=e.remoteOperations().groupPaging,u=t.displayField&&(0,h.isString)(t.displayField),d=function(t,e){var n,i=null!==(n=e.skip)&&void 0!==n?n:0,a=e.take?i+e.take:t.length;return t.slice(i,a)},f=function(i){var a=function(t){return Array.isArray(t)||(t=[t]),t.map((function(e,n){return(0,h.isString)(e)?{selector:e,isExpanded:n<t.length-1}:e}))}(u?[t.dataField,t.displayField]:t.dataField),f=new r.Deferred;return o&&(!c||i.skip===l&&i.take===s)?f.resolve(d(o,i)):(l=i.skip,s=i.take,e.load({filter:n,group:a,take:c?i.take:void 0,skip:c?i.skip:void 0}).done((function(t){o=t,f.resolve(c?t:d(t,i))})).fail(f.fail)),f};return k(k({},a),{__dataGridSourceFilter:n,load:function(e){var n=new r.Deferred;return f(e).done((function(o){if(0!==o.length){var r=i.combineFilters(o.flatMap((function(t){return t.key})).map((function(e){return[t.lookup.valueExpr,e]})),"or");new g.DataSource(k(k(k({},a),e),{filter:i.combineFilters([r,e.filter],"and"),paginate:!1})).load().done(n.resolve).fail(n.fail)}else n.resolve([])})).fail(n.fail),n},key:t.lookup.valueExpr,byKey:function(e){var n=(0,r.Deferred)();return this.load({filter:[t.lookup.valueExpr,"=",e]}).done((function(t){n.resolve(t[0])})),n.promise()}})},logHeaderFilterDeprecatedWarningIfNeed:function(t){var e=t._logDeprecatedOptionWarning.bind(t);(0,h.isDefined)(t.option("headerFilter.allowSearch"))&&e("headerFilter.allowSearch",{since:"23.1",alias:"headerFilter.search.enabled"}),(0,h.isDefined)(t.option("headerFilter.searchTimeout"))&&e("headerFilter.searchTimeout",{since:"23.1",alias:"headerFilter.search.timeout"});var n="dxPivotGrid"===t.NAME?"dataSource.fields":"columns",i=t.option(n);if(Array.isArray(i)){!function t(i){i.forEach((function(i){var a,o=i.headerFilter||{};(0,h.isDefined)(o.allowSearch)&&e("".concat(n,"[].headerFilter.allowSearch"),{since:"23.1",alias:"".concat(n,"[].headerFilter.search.enabled")}),(0,h.isDefined)(o.searchMode)&&e("".concat(n,"[].headerFilter.searchMode"),{since:"23.1",alias:"".concat(n,"[].headerFilter.search.mode")}),(null===(a=i.columns)||void 0===a?void 0:a.length)&&t(i.columns)}))}(i)}}};e.default=L},86988:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=A(n(49387)),a=n(31648),o=A(n(99393)),r=A(n(73349)),s=A(n(13046)),l=n(6415),c=A(n(68374)),u=n(10688),d=n(20576),h=n(62754),f=n(13306),p=n(78008),g=n(37518),m=n(58664),_=n(68752),v=n(35922),b=n(77695),y=n(58201),x=A(n(55994)),w=n(23174),k=A(n(93786)),S=n(39611),C=A(n(6866));function A(t){return t&&t.__esModule?t:{default:t}}function E(){return(E=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function T(t){return(T="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function I(t,e,n){return(e=function(t){var e=function(t,e){if("object"!==T(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==T(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"===T(e)?e:String(e)}(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}var D,O,L=(0,y.getWindow)(),M="dxDraggable",P=(0,S.addNamespace)(w.start,M),R=(0,S.addNamespace)(w.move,M),B=(0,S.addNamespace)(w.end,M),z=(0,S.addNamespace)(w.enter,M),q=(0,S.addNamespace)(w.leave,M),V=(0,S.addNamespace)(k.default.down,M),F=(0,S.addNamespace)("keydown",M),H=function(t){return{x:t.pageX-(0,c.default)(L).scrollLeft(),y:t.pageY-(0,c.default)(L).scrollTop()}},N=function(){function t(t,e){this._$scrollableAtPointer=null,this._preventScroll=!0,this._component=e,"vertical"===t?(this._scrollValue="scrollTop",this._overFlowAttr="overflowY",this._sizeAttr="height",this._scrollSizeProp="scrollHeight",this._clientSizeProp="clientHeight",this._limitProps={start:"top",end:"bottom"}):(this._scrollValue="scrollLeft",this._overFlowAttr="overflowX",this._sizeAttr="width",this._scrollSizeProp="scrollWidth",this._clientSizeProp="clientWidth",this._limitProps={start:"left",end:"right"})}var e=t.prototype;return e.updateScrollable=function(t,e){var n=this,i=!1;t.some((function(t){var a=(0,c.default)(t),o=a.hasClass("dx-overlay-wrapper"),r=a.hasClass("dx-overlay-content");return!(!o&&!r)||(i=n._trySetScrollable(t,e))})),i||(this._$scrollableAtPointer=null,this._scrollSpeed=0)},e.isScrolling=function(){return!!this._scrollSpeed},e.isScrollable=function(t){return("auto"===t.css(this._overFlowAttr)||t.hasClass("dx-scrollable-container"))&&t.prop(this._scrollSizeProp)>Math.ceil("width"===this._sizeAttr?(0,m.getWidth)(t):(0,m.getHeight)(t))},e._trySetScrollable=function(t,e){var n,i=(0,c.default)(t),a=this._component.option("scrollSensitivity"),o=this.isScrollable(i);return o&&(a>(n=this._calculateDistanceToBorders(i,e))[this._limitProps.start]?this._preventScroll||(this._scrollSpeed=-this._calculateScrollSpeed(n[this._limitProps.start]),this._$scrollableAtPointer=i):a>n[this._limitProps.end]?this._preventScroll||(this._scrollSpeed=this._calculateScrollSpeed(n[this._limitProps.end]),this._$scrollableAtPointer=i):(o=!1,this._preventScroll=!1)),o},e._calculateDistanceToBorders=function(t,e){var n,i=t.get(0);return i?(n=(0,g.getBoundingRect)(i),{left:e.x-n.left,top:e.y-n.top,right:n.right-e.x,bottom:n.bottom-e.y}):{}},e._calculateScrollSpeed=function(t){var e=this._component,n=e.option("scrollSensitivity"),i=e.option("scrollSpeed");return Math.ceil(Math.pow((n-t)/n,2)*i)},e.scrollByStep=function(){if(this._$scrollableAtPointer&&this._scrollSpeed){if(this._$scrollableAtPointer.hasClass("dx-scrollable-container")){var t=this._$scrollableAtPointer.closest(".dx-scrollable"),e=t.data("dxScrollable")||t.data("dxScrollView");if(e){var n=e.scrollOffset()[this._limitProps.start]+this._scrollSpeed;e.scrollTo(I({},this._limitProps.start,n))}}else{var i=this._$scrollableAtPointer[this._scrollValue]()+this._scrollSpeed;this._$scrollableAtPointer[this._scrollValue](i)}var a=this._component._dragMoveArgs;a&&this._component._dragMoveHandler(a)}},e.reset=function(){this._$scrollableAtPointer=null,this._scrollSpeed=0,this._preventScroll=!0},e.isOutsideScrollable=function(t,e){if(!t)return!1;var n=(0,g.getBoundingRect)(t.get(0)),i=n[this._limitProps.start],a=n[this._sizeAttr],o=H(e),r="width"===this._sizeAttr?o.x:o.y;return r<i||r>i+a},t}(),j=C.default.inherit({ctor:function(t){this.callBase(),this._strategy=t},_step:function(){var t=this._strategy._horizontalScrollHelper,e=this._strategy._verticalScrollHelper;t&&t.scrollByStep(),e&&e.scrollByStep()}}),G=s.default.inherit({reset:d.noop,dragMove:d.noop,dragEnter:d.noop,dragLeave:d.noop,dragEnd:function(t){return this._getSourceDraggable()._fireRemoveEvent(t),(0,h.Deferred)().resolve()},_fireRemoveEvent:d.noop,_getDefaultOptions:function(){return(0,f.extend)(this.callBase(),{onDragStart:null,onDragMove:null,onDragEnd:null,onDragEnter:null,onDragLeave:null,onDragCancel:null,onCancelByEsc:!1,onDrop:null,immediate:!0,dragDirection:"both",boundary:void 0,boundOffset:0,allowMoveByClick:!1,itemData:null,container:void 0,dragTemplate:void 0,contentTemplate:"content",handle:"",filter:"",clone:!1,autoScroll:!0,scrollSpeed:30,scrollSensitivity:60,group:void 0,data:void 0})},_setOptionsByReference:function(){this.callBase.apply(this,arguments),(0,f.extend)(this._optionsByReference,{component:!0,group:!0,itemData:!0,data:!0})},_init:function(){this.callBase(),this._attachEventHandlers(),this._scrollAnimator=new j(this),this._horizontalScrollHelper=new N("horizontal",this),this._verticalScrollHelper=new N("vertical",this),this._initScrollTop=0,this._initScrollLeft=0},_normalizeCursorOffset:function(t){return(0,v.isObject)(t)&&(t={h:t.x,v:t.y}),{left:(t=(0,d.splitPair)(t).map((function(t){return parseFloat(t)})))[0],top:1===t.length?t[0]:t[1]}},_getNormalizedCursorOffset:function(t,e){return(0,v.isFunction)(t)&&(t=t.call(this,e)),this._normalizeCursorOffset(t)},_calculateElementOffset:function(t){var e,n,i=t.event,o=(0,c.default)(t.itemElement),r=(0,c.default)(t.dragElement),s=this._dragElementIsCloned(),l=this.option("cursorOffset"),u={left:0,top:0},d=this._initialLocate=(0,a.locate)(r);return(s||t.initialOffset||l)&&(e=t.initialOffset||o.offset(),l&&(u=this._getNormalizedCursorOffset(l,t),isFinite(u.left)&&(e.left=i.pageX),isFinite(u.top)&&(e.top=i.pageY)),n=r.offset(),e.top-=n.top+(u.top||0)-d.top,e.left-=n.left+(u.left||0)-d.left),e},_initPosition:function(t){var e=(0,c.default)(t.dragElement),n=this._calculateElementOffset(t);n&&this._move(n,e),this._startPosition=(0,a.locate)(e)},_startAnimator:function(){this._scrollAnimator.inProgress()||this._scrollAnimator.start()},_stopAnimator:function(){this._scrollAnimator.stop()},_addWidgetPrefix:function(t){var e=this.NAME;return(0,p.dasherize)(e)+(t?"-".concat(t):"")},_getItemsSelector:function(){return this.option("filter")||""},_$content:function(){var t=this.$element(),e=t.children(".dx-template-wrapper");return e.length?e:t},_attachEventHandlers:function(){var t=this;if(!this.option("disabled")){var e=this._$content(),n=this._getItemsSelector(),i=this.option("allowMoveByClick"),a={direction:this.option("dragDirection"),immediate:this.option("immediate"),checkDropTarget:function(e,n){var i=t.option("group"),a=t._getSourceDraggable().option("group"),o=t._getScrollable(e);return!t._verticalScrollHelper.isOutsideScrollable(o,n)&&!t._horizontalScrollHelper.isOutsideScrollable(o,n)&&(a&&a===i)}};i&&(e=this._getArea(),x.default.on(e,V,a,this._pointerDownHandler.bind(this))),">"===n[0]&&(n=n.slice(1)),x.default.on(e,P,n,a,this._dragStartHandler.bind(this)),x.default.on(e,R,a,this._dragMoveHandler.bind(this)),x.default.on(e,B,a,this._dragEndHandler.bind(this)),x.default.on(e,z,a,this._dragEnterHandler.bind(this)),x.default.on(e,q,a,this._dragLeaveHandler.bind(this)),this.option("onCancelByEsc")&&x.default.on(e,F,this._keydownHandler.bind(this))}},_dragElementIsCloned:function(){return this._$dragElement&&this._$dragElement.hasClass(this._addWidgetPrefix("clone"))},_getDragTemplateArgs:function(t,e){return{container:(0,l.getPublicElement)(e),model:{itemData:this.option("itemData"),itemElement:(0,l.getPublicElement)(t)}}},_createDragElement:function(t){var e=t,n=this.option("clone"),i=this._getContainer(),a=this.option("dragTemplate");return a?(a=this._getTemplate(a),e=(0,c.default)("<div>").appendTo(i),a.render(this._getDragTemplateArgs(t,e))):n&&(e=(0,c.default)("<div>").appendTo(i),t.clone().css({width:t.css("width"),height:t.css("height")}).appendTo(e)),e.toggleClass(this._addWidgetPrefix("clone"),e.get(0)!==t.get(0)).toggleClass("dx-rtl",this.option("rtlEnabled"))},_resetDragElement:function(){this._dragElementIsCloned()?this._$dragElement.remove():this._toggleDraggingClass(!1),this._$dragElement=null},_resetSourceElement:function(){this._toggleDragSourceClass(!1),this._$sourceElement=null},_detachEventHandlers:function(){x.default.off(this._$content(),".".concat(M)),x.default.off(this._getArea(),".".concat(M))},_move:function(t,e){(0,a.move)(e||this._$dragElement,t)},_getDraggableElement:function(t){var e=this._getSourceElement();if(e)return e;if(this.option("allowMoveByClick"))return this.$element();var n=(0,c.default)(t&&t.target),i=this._getItemsSelector();if(">"===i[0]){var a=this._$content().find(i);a.is(n)||(n=n.closest(a))}return n},_getSourceElement:function(){return this._getSourceDraggable()._$sourceElement},_pointerDownHandler:function(t){if(!(0,S.needSkipEvent)(t)){var e={},n=this.$element(),i=this.option("dragDirection");"horizontal"!==i&&"both"!==i||(e.left=t.pageX-n.offset().left+(0,a.locate)(n).left-(0,m.getWidth)(n)/2),"vertical"!==i&&"both"!==i||(e.top=t.pageY-n.offset().top+(0,a.locate)(n).top-(0,m.getHeight)(n)/2),this._move(e,n),this._getAction("onDragMove")(this._getEventArgs(t))}},_isValidElement:function(t,e){var n=this.option("handle"),i=(0,c.default)(t.originalEvent&&t.originalEvent.target);return!(n&&!i.closest(n).length)&&(!!e.length&&!e.is(".dx-state-disabled, .dx-state-disabled *"))},_dragStartHandler:function(t){var e=this._getDraggableElement(t);if(this.dragInProgress=!0,this._isValidElement(t,e)){if(!this._$sourceElement){var n=this._getDragStartArgs(t,e);if(this._getAction("onDragStart")(n),n.cancel)t.cancel=!0;else{this.option("itemData",n.itemData),this._setSourceDraggable(),this._$sourceElement=e;var i=e.offset();!this._hasClonedDraggable()&&this.option("autoScroll")&&(this._initScrollTop=this._getScrollableScrollTop(),this._initScrollLeft=this._getScrollableScrollLeft(),i=this._getDraggableElementOffset(i.left,i.top));var a=this._$dragElement=this._createDragElement(e);this._toggleDraggingClass(!0),this._toggleDragSourceClass(!0),this._setGestureCoverCursor(a.children());var o="fixed"===a.css("position");this._initPosition((0,f.extend)({},n,{dragElement:a.get(0),initialOffset:o&&i})),this._getAction("onDraggableElementShown")(E(E({},n),{dragElement:a}));var r=this._getArea(),s=this._getAreaOffset(r),l=this._getBoundOffset(),c=(0,m.getOuterWidth)(r),u=(0,m.getOuterHeight)(r),d=(0,m.getWidth)(a),h=(0,m.getHeight)(a),p=a.offset().left-s.left,g=a.offset().top-s.top;r.length&&(t.maxLeftOffset=p-l.left,t.maxRightOffset=c-p-d-l.right,t.maxTopOffset=g-l.top,t.maxBottomOffset=u-g-h-l.bottom),this.option("autoScroll")&&this._startAnimator()}}}else t.cancel=!0},_getAreaOffset:function(t){return t&&i.default.offset(t)||{left:0,top:0}},_toggleDraggingClass:function(t){this._$dragElement&&this._$dragElement.toggleClass(this._addWidgetPrefix("dragging"),t)},_toggleDragSourceClass:function(t,e){var n=e||this._$sourceElement;n&&n.toggleClass(this._addWidgetPrefix("source"),t)},_setGestureCoverCursor:function(t){(0,c.default)(".".concat("dx-gesture-cover")).css("cursor",t.css("cursor"))},_getBoundOffset:function(){var t=this.option("boundOffset");return(0,v.isFunction)(t)&&(t=t.call(this)),(0,_.quadToObject)(t)},_getArea:function(){var t=this.option("boundary");return(0,v.isFunction)(t)&&(t=t.call(this)),(0,c.default)(t)},_getContainer:function(){var t=this.option("container");return void 0===t&&(t=(0,b.value)()),(0,c.default)(t)},_getDraggableElementOffset:function(t,e){var n,i,a,o,r=this._initScrollTop,s=this._initScrollLeft,l=this._getScrollableScrollTop(),u=this._getScrollableScrollLeft(),d="fixed"===(0,c.default)(this.element()).css("position"),h={left:(null!==(i=null===(n=this._startPosition)||void 0===n?void 0:n.left)&&void 0!==i?i:0)+t,top:(null!==(o=null===(a=this._startPosition)||void 0===a?void 0:a.top)&&void 0!==o?o:0)+e};return d||this._hasClonedDraggable()?h:{left:(0,v.isNumeric)(u)?h.left+u-s:h.left,top:(0,v.isNumeric)(l)?h.top+l-r:h.top}},_hasClonedDraggable:function(){return this.option("clone")||this.option("dragTemplate")},_dragMoveHandler:function(t){if(this._dragMoveArgs=t,this._$dragElement){var e=this._getDraggableElementOffset(t.offset.x,t.offset.y);this._move(e),this._updateScrollable(t);var n=this._getEventArgs(t);if(this._getAction("onDragMove")(n),!0!==n.cancel)this._getTargetDraggable().dragMove(t,scrollBy)}else t.cancel=!0},_updateScrollable:function(t){if(this.option("autoScroll")){var e=H(t),n=r.default.elementsFromPoint(e.x,e.y,this.$element().get(0));this._verticalScrollHelper.updateScrollable(n,e),this._horizontalScrollHelper.updateScrollable(n,e)}},_getScrollable:function(t){var e,n=this;return t.parents().toArray().some((function(t){var i=(0,c.default)(t);return!(!n._horizontalScrollHelper.isScrollable(i)&&!n._verticalScrollHelper.isScrollable(i))&&(e=i,!0)})),e},_getScrollableScrollTop:function(){var t,e;return null!==(e=null===(t=this._getScrollable((0,c.default)(this.element())))||void 0===t?void 0:t.scrollTop())&&void 0!==e?e:0},_getScrollableScrollLeft:function(){var t,e;return null!==(e=null===(t=this._getScrollable((0,c.default)(this.element())))||void 0===t?void 0:t.scrollLeft())&&void 0!==e?e:0},_defaultActionArgs:function(){var t=this.callBase.apply(this,arguments),e=this.option("component");return e&&(t.component=e,t.element=e.element()),t},_getEventArgs:function(t){var e=this._getSourceDraggable(),n=this._getTargetDraggable();return{event:t,itemData:e.option("itemData"),itemElement:(0,l.getPublicElement)(e._$sourceElement),fromComponent:e.option("component")||e,toComponent:n.option("component")||n,fromData:e.option("data"),toData:n.option("data")}},_getDragStartArgs:function(t,e){var n=this._getEventArgs(t);return{event:n.event,itemData:n.itemData,itemElement:e,fromData:n.fromData}},_revertItemToInitialPosition:function(){!this._dragElementIsCloned()&&this._move(this._initialLocate,this._$sourceElement)},_dragEndHandler:function(t){var e=this,n=(0,h.Deferred)(),i=this._getEventArgs(t),a=this._getEventArgs(t),o=this._getTargetDraggable(),r=!0;this.dragInProgress=!1;try{this._getAction("onDragEnd")(i)}finally{(0,h.when)((0,h.fromPromise)(i.cancel)).done((function(t){if(!t&&(o!==e&&o._getAction("onDrop")(a),!a.cancel))return r=!1,void(0,h.when)((0,h.fromPromise)(o.dragEnd(i))).always(n.resolve);n.resolve()})).fail(n.resolve),n.done((function(){r&&e._revertItemToInitialPosition(),e._resetDragOptions(o)}))}},_isTargetOverAnotherDraggable:function(t){var e=this,n=this._getSourceDraggable();if(this===n)return!1;var i=n._$dragElement,a=n.$element(),o=this.$element(),s=H(t),l=r.default.elementsFromPoint(s.x,s.y,this.element()).filter((function(t){var n=(0,c.default)(t);return!!n.hasClass(e._addWidgetPrefix())&&!n.closest(i).length}))[0],u=this._getSourceElement(),d=l===a.get(0),h=(0,c.default)(l).closest(u).length;return!l||l===o.get(0)&&!d&&!h},_dragEnterHandler:function(t){this._fireDragEnterEvent(t),this._isTargetOverAnotherDraggable(t)&&this._setTargetDraggable(),this._getSourceDraggable().dragEnter(t)},_dragLeaveHandler:function(t){this._fireDragLeaveEvent(t),this._resetTargetDraggable(),this!==this._getSourceDraggable()&&this.reset(),this._getSourceDraggable().dragLeave(t)},_keydownHandler:function(t){this.dragInProgress&&"Escape"===t.key&&this._keydownEscapeHandler(t)},_keydownEscapeHandler:function(t){if(this._getSourceElement()){var e=this._getEventArgs(t);if(this._getAction("onDragCancel")(e),!e.cancel){this.dragInProgress=!1,null==O||O._toggleDraggingClass(!1),this._detachEventHandlers(),this._revertItemToInitialPosition();var n=this._getTargetDraggable();this._resetDragOptions(n),this._attachEventHandlers()}}},_getAction:function(t){return this["_".concat(t,"Action")]||this._createActionByOption(t)},_getAnonymousTemplateName:function(){return"content"},_initTemplates:function(){this.option("contentTemplate")&&(this._templateManager.addDefaultTemplates({content:new u.EmptyTemplate}),this.callBase.apply(this,arguments))},_render:function(){this.callBase(),this.$element().addClass(this._addWidgetPrefix());var t=this._templateManager.anonymousTemplateName===this.option("contentTemplate"),e=this._getTemplateByOption("contentTemplate");e&&(0,c.default)(e.render({container:this.element(),transclude:t}))},_optionChanged:function(t){var e=t.name;switch(e){case"onDragStart":case"onDragMove":case"onDragEnd":case"onDrop":case"onDragEnter":case"onDragLeave":case"onDragCancel":case"onDraggableElementShown":this["_".concat(e,"Action")]=this._createActionByOption(e);break;case"dragTemplate":case"contentTemplate":case"container":case"clone":break;case"allowMoveByClick":case"dragDirection":case"disabled":case"boundary":case"filter":case"immediate":this._resetDragElement(),this._detachEventHandlers(),this._attachEventHandlers();break;case"onCancelByEsc":this._keydownHandler();break;case"autoScroll":this._verticalScrollHelper.reset(),this._horizontalScrollHelper.reset();break;case"scrollSensitivity":case"scrollSpeed":case"boundOffset":case"handle":case"group":case"data":case"itemData":break;default:this.callBase(t)}},_getTargetDraggable:function(){return D||this},_getSourceDraggable:function(){return O||this},_setTargetDraggable:function(){var t=this.option("group"),e=this._getSourceDraggable();t&&t===e.option("group")&&(D=this)},_setSourceDraggable:function(){O=this},_resetSourceDraggable:function(){O=null},_resetTargetDraggable:function(){D=null},_resetDragOptions:function(t){this.reset(),t.reset(),this._stopAnimator(),this._horizontalScrollHelper.reset(),this._verticalScrollHelper.reset(),this._resetDragElement(),this._resetSourceElement(),this._resetTargetDraggable(),this._resetSourceDraggable()},_dispose:function(){this.callBase(),this._detachEventHandlers(),this._resetDragElement(),this._resetTargetDraggable(),this._resetSourceDraggable(),this._$sourceElement=null,this._stopAnimator()},_fireDragEnterEvent:function(t){var e=this._getEventArgs(t);this._getAction("onDragEnter")(e)},_fireDragLeaveEvent:function(t){var e=this._getEventArgs(t);this._getAction("onDragLeave")(e)}});(0,o.default)(M,G);var Z=G;e.default=Z},90006:function(t,e,n){var i;function a(t){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function o(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,(o=i.key,r=void 0,r=function(t,e){if("object"!==a(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==a(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(o,"string"),"symbol"===a(r)?r:String(r)),i)}var o,r}Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var r=((i=n(91198))&&i.__esModule?i:{default:i}).default.dateToMilliseconds,s=function(){function t(t){this._source=new Date(t.getTime?t.getTime():t)}var e,n,i,a=t.prototype;return a.result=function(){return this._source},a.getTimezoneOffset=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:void 0,e=this._source.getTimezoneOffset();return"minute"===t?e*r("minute"):e},a.getTime=function(){return this._source.getTime()},a.setTime=function(t){return this._source.setTime(t),this},a.addTime=function(t){return this._source.setTime(this._source.getTime()+t),this},a.setMinutes=function(t){return this._source.setMinutes(t),this},a.addMinutes=function(t){return this._source.setMinutes(this._source.getMinutes()+t),this},a.subtractMinutes=function(t){return this._source.setMinutes(this._source.getMinutes()-t),this},e=t,(n=[{key:"source",get:function(){return this._source}}])&&o(e.prototype,n),i&&o(e,i),Object.defineProperty(e,"prototype",{writable:!1}),t}(),l=function(t){return new s(t)};e.default=l},57880:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=r(n(91198)),a=r(n(90006)),o=r(n(23778));function r(t){return t&&t.__esModule?t:{default:t}}function s(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var n=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=n){var i,a,o,r,s=[],l=!0,c=!1;try{if(o=(n=n.call(t)).next,0===e){if(Object(n)!==n)return;l=!1}else for(;!(l=(i=o.call(n)).done)&&(s.push(i.value),s.length!==e);l=!0);}catch(t){c=!0,a=t}finally{try{if(!l&&null!=n.return&&(r=n.return(),Object(r)!==r))return}finally{if(c)throw a}}return s}}(t,e)||function(t,e){if(!t)return;if("string"==typeof t)return l(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return l(t,e)}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var c=i.default.dateToMilliseconds,u=function(t){return new Date(Date.UTC(t.getUTCFullYear(),t.getUTCMonth(),t.getUTCDate(),t.getUTCHours(),t.getUTCMinutes()))},d=function(t,e,n,i){return h(n,i)-h(t,e)},h=function(t,e){return new Date(t).getTimezoneOffset()-new Date(e).getTimezoneOffset()},f=function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:new Date;if("string"==typeof t){var n=u(e);return o.default.getTimeZoneOffsetById(t,n.getTime())}return t},p=function(t,e,n){return f(n,t)-f(n,e)},g=function(t){var e=new Date(new Date(t).setHours(0,0,0,0)),n=new Date(new Date(t).setHours(23,59,59,0));return e.getTimezoneOffset()-n.getTimezoneOffset()!=0},m=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:new Date;return 6e4*t.getTimezoneOffset()},_=function(){var t=s(b(),2),e=t[0],n=t[1];return e.getTimezoneOffset()!==n.getTimezoneOffset()},v=function(t,e){var n=e.getFullYear(),i=function(t){return-t.getTimezoneOffset()/60},a=function(t){return new Date(t-36e5)},r=o.default.getTimeZoneDeclarationTuple(t,n),l=s(r,2),c=l[0],u=l[1];if(r.length<2)return o.default.getTimeZoneOffsetById(t,e)===i(e)&&!_();var d=i(new Date(c.date)),h=i(new Date(u.date));return d===c.offset&&(d!==i(a(c.date))&&(h===u.offset&&h!==i(a(u.date))))},b=function(){var t=new Date(Date.now()),e=new Date,n=new Date;return e.setFullYear(t.getFullYear(),0,1),n.setFullYear(t.getFullYear(),6,1),[e,n]},y={getDaylightOffset:h,getDaylightOffsetInMs:function(t,e){return h(t,e)*c("minute")},getTimezoneOffsetChangeInMinutes:d,getTimezoneOffsetChangeInMs:function(t,e,n,i){return d(t,e,n,i)*c("minute")},calculateTimezoneByValue:f,getCorrectedDateByDaylightOffsets:function(t,e,n,i,a){var o=p(t,e,i)-p(t,e,a);return new Date(n.getTime()-o*c("hour"))},isSameAppointmentDates:function(t,e){return e=new Date(e.getTime()-1),i.default.sameDate(t,e)},correctRecurrenceExceptionByTimezone:function(t,e,n,i){var a=arguments.length>4&&void 0!==arguments[4]&&arguments[4],o=(t.getTimezoneOffset()-e.getTimezoneOffset())/60;return i?o=p(e,t,i):n&&(o=p(e,t,n)),new Date(t.getTime()+(a?-1:1)*o*c("hour"))},getClientTimezoneOffset:m,getDiffBetweenClientTimezoneOffsets:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:new Date,e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:new Date;return m(t)-m(e)},createUTCDateWithLocalOffset:function(t){return t?new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds())):null},createDateFromUTCWithLocalOffset:function(t){var e=(0,a.default)(t),n=e.getTimezoneOffset();return e.addTime(e.getTimezoneOffset("minute")),e.subtractMinutes(n-e.getTimezoneOffset()),e.source},createUTCDate:u,isTimezoneChangeInDate:g,getDateWithoutTimezoneChange:function(t){var e=new Date(t);if(g(e)){var n=new Date(e);return new Date(n.setDate(n.getDate()+1))}return e},hasDSTInLocalTimeZone:_,isEqualLocalTimeZone:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:new Date;if(Intl){var n=Intl.DateTimeFormat().resolvedOptions().timeZone;if(n===t)return!0}return v(t,e)},isEqualLocalTimeZoneByDeclaration:v,getTimeZones:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:new Date,e=u(t);return o.default.getDisplayedTimeZones(e.getTime())},setOffsetsToDate:function(t,e){var n=e.reduce((function(t,e){return t+e}),t.getTime());return new Date(n)}};e.default=y},23778:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=s(n(17381)),a=n(60810),o=s(n(96687)),r=s(n(28882));function s(t){return t&&t.__esModule?t:{default:t}}var l=function(t){var e,n,i=t.offsets,a=t.offsetIndices,o=t.untils;return{offsetList:i.split("|").map((function(t){return parseInt(t)})),offsetIndexList:a.split("").map((function(t){return parseInt(t)})),dateList:(n=o,n.split("|").map((function(t){return"Infinity"===t?null:1e3*parseInt(t,36)}))).map((e=0,function(t){return e+=t}))}},c=new(function(){function t(){this.map=new Map}return t.prototype.tryGet=function(t){if(!this.map.get(t)){var e=u.getTimezoneById(t);if(!e)return!1;var n=l(e);this.map.set(t,n)}return this.map.get(t)},t}()),u={_tzCache:c,_timeZones:r.default.zones,getDisplayedTimeZones:function(t){var e=this,n=this._timeZones.map((function(n){var i=l(n),a=e.getUtcOffset(i,t);return{offset:a,title:"(GMT ".concat(e.formatOffset(a),") ").concat(e.formatId(n.id)),id:n.id}}));return(0,o.default)(n).sortBy("offset").toArray()},formatOffset:function(t){var e=Math.floor(t),n=t-e;return((0,a.sign)(t)>=0?"+":"-")+"0".concat(Math.abs(e)).slice(-2)+(n>0?":".concat(60*n):":00")},formatId:function(t){return t.split("/").join(" - ").split("_").join(" ")},getTimezoneById:function(t){if(t){for(var e=this._timeZones,n=0;n<e.length;n++){if(e[n].id===t)return e[n]}i.default.log("W0009",t)}},getTimeZoneOffsetById:function(t,e){var n=c.tryGet(t);return n?this.getUtcOffset(n,e):void 0},getTimeZoneDeclarationTuple:function(t,e){var n=c.tryGet(t);return n?this.getTimeZoneDeclarationTupleCore(n,e):[]},getTimeZoneDeclarationTupleCore:function(t,e){for(var n=t.offsetList,i=t.offsetIndexList,a=t.dateList,o=[],r=0;r<a.length;r++){var s=a[r],l=new Date(s).getFullYear();if(l===e){var c=n[i[r+1]];o.push({date:s,offset:-c/60})}if(l>e)break}return o},getUtcOffset:function(t,e){for(var n=t.offsetList,i=t.offsetIndexList,a=t.dateList,o=a.length-1-1;o>=0&&e<a[o];)o--;var r=n[i[o+1]];return-r/60||r}},d=u;e.default=d},28882:function(t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;e.default={zones:[{id:"Africa/Abidjan",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Accra",untils:"-r507yk|1e3pak|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|cjvlc|681qo|clq9c|681qo|cjvlc|681qo|cjvlc|681qo|Infinity",offsets:"0.8667|0|-20",offsetIndices:"012121212121212121212121212121212121212121212121"},{id:"Africa/Addis_Ababa",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Algiers",untils:"-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|53c00|9idxc0|3i040|51mw0|253uk0|9o2k0|92040|8l3s0|jutc0|4uy840|3rdzw0|46xc00|7x6o0|2xco40|8n180|7x9g0|9d440|kiqg0|9d440|9q2s0|9cyk0|Infinity",offsets:"-9.35|0|-60|-120",offsetIndices:"0121212121212121232321212122321212"},{id:"Africa/Asmara",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Asmera",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Bamako",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Bangui",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Banjul",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Bissau",untils:"-u9rek0|wvoyo0|Infinity",offsets:"62.3333|60|0",offsetIndices:"012"},{id:"Africa/Blantyre",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Brazzaville",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Bujumbura",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Cairo",untils:"-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",offsets:"-120|-180",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Africa/Casablanca",untils:"-tblt9g|di7nxg|3huk0|51k40|2znuk0|2dp9g0|776k0|8nt2s0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|xqqk0|bp56s0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",offsets:"30.3333|0|-60",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"Africa/Ceuta",untils:"-qyiys0|7x3w0|2vt440|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|k69dc0|657w0|3ifxg0|3jp80|va040|4qak0|e1ms0|7pp80|cnms0|3afw0|2xi840|129us0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Africa/Conakry",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Dakar",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Dar_es_Salaam",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Djibouti",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Douala",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/El_Aaiun",untils:"-isdxk0|m2g0c0|vek0|4qak0|e1ms0|7pp80|cnms0|3afw0|fke5g0|4qak0|e1ms0|45x80|d2g40|51ek0|c8tg0|64ak0|e1sc0|47uo0|1leo0|23xc0|asw00|3lmo0|1qyo0|40g00|7x6o0|4mo00|1stc0|4deo0|7x6o0|3ylc0|1stc0|51hc0|7x6o0|3lmo0|1stc0|5reo0|7k800|2vpc0|25s00|64dc0|7k800|2iqo0|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|1stc0|gkao0|1stc0|g7c00|25s00|g7c00|1stc0|g7c00|25s00|g7c00|25s00|g7c00|1stc0|g7c00|25s00|Infinity",offsets:"52.8|60|0|-60",offsetIndices:"012323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Africa/Freetown",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Gaborone",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Harare",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Johannesburg",untils:"-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",offsets:"-90|-120|-180",offsetIndices:"012121"},{id:"Africa/Juba",untils:"-kcrsis|kixuys|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|Infinity",offsets:"-126.4667|-120|-180",offsetIndices:"01212121212121212121212121212121212"},{id:"Africa/Kampala",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Khartoum",untils:"-kcrsow|kixv4w|8l6k0|a4w40|8n180|a6qs0|8n180|a31g0|8ovw0|a16s0|8qqk0|9zc40|8sl80|9xhg0|8wak0|9ts40|8y580|a4w40|8n180|a31g0|8ovw0|a16s0|8sl80|9xhg0|8ufw0|9vms0|8wak0|9ts40|8y580|a4w40|8ovw0|a16s0|8qqk0|7frw40|9ac180|Infinity",offsets:"-130.1333|-120|-180",offsetIndices:"012121212121212121212121212121212121"},{id:"Africa/Kigali",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Kinshasa",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Lagos",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Libreville",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Lome",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Luanda",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Lubumbashi",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Lusaka",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Malabo",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Maputo",untils:"-yvtfd8|Infinity",offsets:"-130.3333|-120",offsetIndices:"01"},{id:"Africa/Maseru",untils:"-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",offsets:"-90|-120|-180",offsetIndices:"012121"},{id:"Africa/Mbabane",untils:"-yvtdi0|kn7o60|9cyk0|9d440|9cyk0|Infinity",offsets:"-90|-120|-180",offsetIndices:"012121"},{id:"Africa/Mogadishu",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Monrovia",untils:"-qj6zc4|rl202a|Infinity",offsets:"43.1333|44.5|0",offsetIndices:"012"},{id:"Africa/Nairobi",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Africa/Ndjamena",untils:"-u9rk4c|zdk5cc|7iak0|Infinity",offsets:"-60.2|-60|-120",offsetIndices:"0121"},{id:"Africa/Niamey",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Nouakchott",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Ouagadougou",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Porto-Novo",untils:"-q9qbao|Infinity",offsets:"-13.6|-60",offsetIndices:"01"},{id:"Africa/Sao_Tome",untils:"-u9rhc0|1jbm840|irxc0|Infinity",offsets:"36.75|0|-60",offsetIndices:"0121"},{id:"Africa/Timbuktu",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Africa/Tripoli",untils:"-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",offsets:"-52.7333|-60|-120",offsetIndices:"012121212121212121212121212122122"},{id:"Africa/Tunis",untils:"-uozn3l|enxevl|b5uo0|53c00|u8w00|7x9g0|c8w80|7k800|z3w0|ew40|8bx80|9d440|9nx00|925o0|8l100|gi3440|7k800|b9k00|7vc00|51mw00|5ytc0|9d1c0|9d1c0|b9k00|7thc0|7m0tc0|7tk40|93us0|b5uo0|7k800|b5uo0|7x6o0|asw00|Infinity",offsets:"-9.35|-60|-120",offsetIndices:"0121212121212121212121212121212121"},{id:"Africa/Windhoek",untils:"-yvtdi0|kn7o60|9cyk0|oj2nw0|235k00|8lho0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|Infinity",offsets:"-90|-120|-180|-60",offsetIndices:"01211313131313131313131313131313131313131313131313131"},{id:"America/Adak",untils:"-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"660|600|540",offsetIndices:"011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Anchorage",untils:"-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"600|540|480",offsetIndices:"011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Anguilla",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Antigua",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Araguaina",untils:"-t85j2o|99k8mo|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|51udg0|64ak0|Infinity",offsets:"192.8|180|120",offsetIndices:"0121212121212121212121212121212121212121212121212121"},{id:"America/Argentina/Buenos_Aires",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323232323232"},{id:"America/Argentina/Catamarca",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132321232"},{id:"America/Argentina/ComodRivadavia",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132321232"},{id:"America/Argentina/Cordoba",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132323232"},{id:"America/Argentina/Jujuy",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323121323232"},{id:"America/Argentina/La_Rioja",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323231232321232"},{id:"America/Argentina/Mendoza",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232312121321232"},{id:"America/Argentina/Rio_Gallegos",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323232321232"},{id:"America/Argentina/Salta",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323231323232"},{id:"America/Argentina/San_Juan",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6qik0|3g880|8jbw0|6u7w0|bvus0|776k0|5v2840|2txg0|1sgak0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323231232321232"},{id:"America/Argentina/San_Luis",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|7pp80|b2aw0|71mk0|4qg40|6s8ik0|2txg0|1sgak0|14nw0|2gys0|b5xg0|7k580|b5xg0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323121212321212"},{id:"America/Argentina/Tucuman",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|mas0|1um2k0|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"0121212121212121212121212121212121212121212323232313232123232"},{id:"America/Argentina/Ushuaia",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|5v0dg0|12ys0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323232321232"},{id:"America/Aruba",untils:"-u7lckd|rlo7qd|Infinity",offsets:"275.7833|270|240",offsetIndices:"012"},{id:"America/Asuncion",untils:"-jy93zk|ldwofk|s4vw0|s6w40|7tek0|b0dg0|7rjw0|b0dg0|7rjw0|b0dg0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|9eys0|9cyk0|9eys0|9cyk0|9eys0|9et80|9eys0|9cyk0|ahus0|8a2k0|9eys0|9cyk0|9o840|7k580|b7s40|93p80|9gtg0|7nuk0|b42s0|7lzw0|b5xg0|7tek0|b9ms0|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|7kas0|b5rw0|7x9g0|ast80|a31g0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|776k0|biw40|8zzw0|905g0|9px80|905g0|9px80|9d440|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|a31g0|8n180|a31g0|8n180|a31g0|Infinity",offsets:"230.6667|240|180",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Atikokan",untils:"-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",offsets:"360|300",offsetIndices:"0101111"},{id:"America/Atka",untils:"-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"660|600|540",offsetIndices:"011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Bahia_Banderas",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|asqg0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"421|420|360|480|300",offsetIndices:"0121212131212121212121212121212121212142424242424242424242424242424242424242424242424242424242"},{id:"America/Bahia",untils:"-t85kv8|99kaf8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|4irc40|6u7w0|Infinity",offsets:"154.0667|180|120",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121"},{id:"America/Barbados",untils:"-o0aiaj|46b400|npv1mj|5rbw0|a31g0|8n180|a31g0|8n180|ag040|84ik0|Infinity",offsets:"238.4833|240|180",offsetIndices:"00121212121"},{id:"America/Belem",untils:"-t85j0s|99k8ks|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",offsets:"193.9333|180|120",offsetIndices:"012121212121212121212121212121"},{id:"America/Belize",untils:"-u52ic0|3edkc0|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|bvte0|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|bvte0|6u9a0|g2t2q0|3e580|4mcys0|2vmk0|Infinity",offsets:"352.8|360|330|300",offsetIndices:"01212121212121212121212121212121212121212121212121213131"},{id:"America/Blanc-Sablon",untils:"-qzp0o0|a2vw0|c5jxg0|1tzdw0|2dnc0|Infinity",offsets:"240|180",offsetIndices:"010110"},{id:"America/Boa_Vista",untils:"-t85grk|99k93k|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|62xk40|7k580|biw40|cvw0|Infinity",offsets:"242.6667|240|180",offsetIndices:"0121212121212121212121212121212121"},{id:"America/Bogota",untils:"-srdoy8|14f1hi8|ha580|Infinity",offsets:"296.2667|300|240",offsetIndices:"0121"},{id:"America/Boise",untils:"-r0emw0|ast80|7x9g0|ast80|1um840|9s7jw0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|51k40|doik0|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420|360",offsetIndices:"0101012212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Buenos_Aires",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvus0|6u7w0|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323232323232"},{id:"America/Cambridge_Bay",untils:"-q3gdc0|bjeec0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x6o0|ast80|ct40|7kj40|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|420|360|300",offsetIndices:"0122131212121212121212121212121212121212121212233221212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Campo_Grande",untils:"-t85hvw|99ka7w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",offsets:"218.4667|240|180",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Cancun",untils:"-p1u7c0|vauo00|7ggw40|afuk0|8a840|afuk0|8a840|64ak0|4bms0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|51k40|Infinity",offsets:"347.0667|360|300|240",offsetIndices:"0123232321212121212121212121212121212121212"},{id:"America/Caracas",untils:"-u7lcxw|rlo83w|meoxm0|4dps00|Infinity",offsets:"267.6667|270|240",offsetIndices:"01212"},{id:"America/Catamarca",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|5v42s0|z9g0|1u93w0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132321232"},{id:"America/Cayenne",untils:"-uj7yb4|tcw6r4|Infinity",offsets:"209.3333|240|180",offsetIndices:"012"},{id:"America/Cayman",untils:"-w757vc|Infinity",offsets:"319.6|300",offsetIndices:"01"},{id:"America/Chicago",untils:"-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Chihuahua",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"424.3333|420|360|300",offsetIndices:"0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Coral_Harbour",untils:"-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|Infinity",offsets:"360|300",offsetIndices:"0101111"},{id:"America/Cordoba",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132323232"},{id:"America/Costa_Rica",untils:"-pjw8fn|ubtl3n|51ek0|doo40|51ek0|5jso40|8drw0|acas0|2xh80|Infinity",offsets:"336.2167|360|300",offsetIndices:"0121212121"},{id:"America/Creston",untils:"-rshz80|vbus0|Infinity",offsets:"420|480",offsetIndices:"010"},{id:"America/Cuiaba",untils:"-t85hm4|99k9y4|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|w5hg0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",offsets:"224.3333|240|180",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Curacao",untils:"-u7lckd|rlo7qd|Infinity",offsets:"275.7833|270|240",offsetIndices:"012"},{id:"America/Danmarkshavn",untils:"-rvusjk|x8nx3k|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|53hk0|Infinity",offsets:"74.6667|180|120|0",offsetIndices:"01212121212121212121212121212121213"},{id:"America/Dawson_Creek",untils:"-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|69uk0|Infinity",offsets:"480|420",offsetIndices:"0101101010101010101010101010101010101010101010101010101011"},{id:"America/Dawson",untils:"-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|465k00|3e2is0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",offsets:"540|480|420",offsetIndices:"01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Denver",untils:"-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360",offsetIndices:"01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Detroit",untils:"-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"332.1833|360|300|240",offsetIndices:"0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/Dominica",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Edmonton",untils:"-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"453.8667|420|360",offsetIndices:"0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Eirunepe",untils:"-t85f28|99ka68|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|7hg2s0|2t2t80|Infinity",offsets:"279.4667|300|240",offsetIndices:"0121212121212121212121212121212121"},{id:"America/El_Salvador",untils:"-pkm4tc|ymao5c|7k580|b5xg0|7k580|Infinity",offsets:"356.8|360|300",offsetIndices:"012121"},{id:"America/Ensenada",untils:"-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"468.0667|420|480",offsetIndices:"012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Fort_Nelson",untils:"-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",offsets:"480|420",offsetIndices:"01011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"America/Fort_Wayne",untils:"-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Fortaleza",untils:"-t85kvc|99kafc|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|puk0|id6s0|6h980|Infinity",offsets:"154|180|120",offsetIndices:"0121212121212121212121212121212121212121"},{id:"America/Glace_Bay",untils:"-z94kwc|89fk8c|a2vw0|c5jxg0|1tzdw0|2dnc0|3y8g40|7x3w0|9pa5g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"239.8|240|180",offsetIndices:"012122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Godthab",untils:"-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"206.9333|180|120",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Goose_Bay",untils:"-qzp20k|a2vw0|8kjbw0|kzjyk|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|6y2s0|22420|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"210.8667|150.8667|210|150|240|180|120",offsetIndices:"010232323232323233232323232323232323232323232323232323232324545454545454545454545454545454545454545454546454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454"},{id:"America/Grand_Turk",untils:"-u85og2|z3brw2|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|18ais0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"307.1667|300|240",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121222121212121212121212121212121212121212121"},{id:"America/Grenada",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Guadeloupe",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Guatemala",untils:"-qqqskk|ss0akk|4ofw0|4tidg0|6djw0|3wwas0|8n180|7n5ms0|7x3w0|Infinity",offsets:"362.0667|360|300",offsetIndices:"0121212121"},{id:"America/Guayaquil",untils:"-kcr84o|wb620o|3jp80|Infinity",offsets:"314|300|240",offsetIndices:"0121"},{id:"America/Guyana",untils:"-smcak8|vj4sz8|81rf90|Infinity",offsets:"232.6667|225|180|240",offsetIndices:"0123"},{id:"America/Halifax",untils:"-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"254.4|240|180",offsetIndices:"0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Havana",untils:"-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",offsets:"329.6|300|240",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Hermosillo",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|Infinity",offsets:"443.8667|420|360|480",offsetIndices:"0121212131212121"},{id:"America/Indiana/Indianapolis",untils:"-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indiana/Knox",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Indiana/Marengo",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|2wsas0|7x3w0|1c9440|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|fvt9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"0101011010101010101010101212121212111212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indiana/Petersburg",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|sfzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|eu02o0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"01010110101010101010101010101010101010101010101010111011212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indiana/Tell_City",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|501ek0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|1tw580|9d440|9cyk0|9d440|9cvs0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"01010110101010101010101010101021211010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Indiana/Vevay",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|4gyis0|7txx80|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|hfzhg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"010101101212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indiana/Vincennes",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|3fidg0|7x3w0|asys0|7x3w0|b5rw0|7kas0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|2lz980|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"01010110101010101010101010101010121211011212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indiana/Winamac",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|465h80|9cyk0|9d440|9cyk0|ihslg0|asw00|6udg0|c8l40|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"01010110101010101010101010101010101010121211021212121212121212121212121212121212121212121212121212121212121"},{id:"America/Indianapolis",untils:"-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Inuvik",untils:"-8ve5c0|6fce80|9q000|71i2w0|ipzw0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|480|360|420",offsetIndices:"0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"America/Iqaluit",untils:"-eb6ao0|1l3h80|2dq40|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|240|300|180|360",offsetIndices:"01123212121212121212121212121212121212121212142212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Jamaica",untils:"-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",offsets:"307.1667|300|240",offsetIndices:"0121212121212121212121"},{id:"America/Jujuy",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|c8w80|776k0|ag040|7k2g0|bvus0|776k0|7qcg40|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"012121212121212121212121212121212121212121232323121323232"},{id:"America/Juneau",untils:"-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9d1c0|9d1c0|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420|540",offsetIndices:"01101010101010101010101010001010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"},{id:"America/Kentucky/Louisville",untils:"-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Kentucky/Monticello",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|bs6g40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"0101011010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Knox_IN",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Kralendijk",untils:"-u7lckd|rlo7qd|Infinity",offsets:"275.7833|270|240",offsetIndices:"012"},{id:"America/La_Paz",untils:"-jxzspo|84ik0|Infinity",offsets:"272.6|212.6|240",offsetIndices:"012"},{id:"America/Lima",untils:"-w25lpo|fcxjlo|4ml80|93us0|9cyk0|9d440|9cyk0|nw16s0|4ml80|e5c40|4ml80|1fr1g0|4ml80|1yiys0|4ml80|Infinity",offsets:"308.6|300|240",offsetIndices:"0121212121212121"},{id:"America/Los_Angeles",untils:"-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Louisville",untils:"-r0esg0|ast80|7x9g0|ast80|sg5g0|6bp80|a98o40|7x3w0|6w840|1tz8c0|2dsw0|ast9o|1sw2c|21gis0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|4bh80|3j3xc0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4g00|64dc0|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"0101010101101010101010101010101010101121212121212111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Lower_Princes",untils:"-u7lckd|rlo7qd|Infinity",offsets:"275.7833|270|240",offsetIndices:"012"},{id:"America/Maceio",untils:"-t85ldw|99kaxw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|2yl440|64ak0|1wf1g0|7k580|biw40|puk0|id6s0|6h980|Infinity",offsets:"142.8667|180|120",offsetIndices:"012121212121212121212121212121212121212121"},{id:"America/Managua",untils:"-ijh6oo|ka1i0o|xqqk0|24p6s0|53980|dmtg0|53980|60itw0|dq240|53es0|235h80|4beis0|8zzw0|at4c0|7x140|Infinity",offsets:"345.2|360|300",offsetIndices:"0121212121212121"},{id:"America/Manaus",untils:"-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",offsets:"240.0667|240|180",offsetIndices:"01212121212121212121212121212121"},{id:"America/Marigot",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Martinique",untils:"-umcvcs|zz5x4s|8zzw0|Infinity",offsets:"244.3333|240|180",offsetIndices:"0121"},{id:"America/Matamoros",untils:"-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"400|360|300",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Mazatlan",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"425.6667|420|360|480",offsetIndices:"0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Mendoza",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bktk0|71mk0|bqas0|73h80|bvus0|773s0|5unes0|6hes0|1p7mk0|3yik0|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232312121321232"},{id:"America/Menominee",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|asys0|7x3w0|a7n9g0|9px80|1at9g0|2396k0|9d1c0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"01010110101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Merida",untils:"-p1u7c0|vauo00|hoyk0|6ys0c0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"358.4667|360|300",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Metlakatla",untils:"-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|gpc840|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|3ylc0|2itg0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420|540",offsetIndices:"01101010101010101010101010101010102020200202020202020202020202020202020202020202"},{id:"America/Mexico_City",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"396.6|420|360|300",offsetIndices:"012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/Miquelon",untils:"-ulmyxk|zzqbdk|3m59g0|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"224.6667|240|180|120",offsetIndices:"012323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/Moncton",untils:"-z94i40|89fhg0|a2vw0|7mqqo0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|e1ms0|4ofw0|dmtg0|64ak0|cao40|6fek0|bkqs0|7iak0|6y5k0|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a2lo|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6uiyc|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240|180",offsetIndices:"012121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Monterrey",untils:"-p1u7c0|ykt480|ast80|3vppg0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"401.2667|360|300",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Montevideo",untils:"-w4mll9|67elc0|1s74p9|9et80|9exe0|9czy0|9exe0|9czy0|3ydyq0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7k6m0|9q1e0|9czy0|asxe0|7x5a0|6do20|ppvy0|4mmm0|8g9qq0|901a0|38pe0|2inw0|2nf9g0|8zzw0|1e3s40|9o3y0|q8he0|2kik0|yxhg0|4bh80|s36s0|2vl60|905g0|5rg20|51ek0|weqs0|3yik0|e1ms0|4ofw0|erk40|3yik0|2vs40|gk7w0|41iys0|3wnw0|erk40|4bh80|c8tg0|64ak0|c8tg0|6u7w0|c8tg0|6h980|bvus0|6u7w0|614qs0|9q2s0|a31g0|7x3w0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|ag040|8a2k0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"224.85|240|180|210|150|120|90",offsetIndices:"001232323232323232323232324242525242525264252525252525252525252525252525252525252525252"},{id:"America/Montreal",untils:"-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Montserrat",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Nassau",untils:"-u6m4c6|r7u7s6|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"309.5|300|240",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/New_York",untils:"-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Nipigon",untils:"-qzoxw0|a2vw0|bfxjw0|pmdk0|1tzb40|2dq40|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Nome",untils:"-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l6c0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"660|600|540|480",offsetIndices:"011001010101010101010101010101010122323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/Noronha",untils:"-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",offsets:"129.6667|120|60",offsetIndices:"0121212121212121212121212121212121212121"},{id:"America/North_Dakota/Beulah",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hc00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360|300",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121"},{id:"America/North_Dakota/Center",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360|300",offsetIndices:"010101101010101010101010101010101010101010101010101010101011212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/North_Dakota/New_Salem",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a5c0|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360|300",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Nuuk",untils:"-rvumf4|x8nqz4|8zrk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"206.9333|180|120",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Ojinaga",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|xes2s0|afuk0|8a840|afuk0|8aaw0|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"417.6667|420|360|300",offsetIndices:"0121212323221212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Panama",untils:"-w757vc|Infinity",offsets:"319.6|300",offsetIndices:"01"},{id:"America/Pangnirtung",untils:"-pkmlc0|b0ke00|1tzdw0|2dnc0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|asw00|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7xc80|ast80|7x6o0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|240|180|120|300|360",offsetIndices:"012213121212121212121212121212121212114141414154414141414141414141414141414141414141414141414141414141414141414141414141414"},{id:"America/Paramaribo",untils:"-usj4g8|cixc0c|5lydbk|kcrm6c|Infinity",offsets:"220.6667|220.8667|220.6|210|180",offsetIndices:"01234"},{id:"America/Phoenix",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",offsets:"420|360",offsetIndices:"01010101010"},{id:"America/Port_of_Spain",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Port-au-Prince",untils:"-rmk9ac|ylcf6c|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8aaw0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|3vpjw0|ast80|7x9g0|ast80|2stv00|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|pkg40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"289|300|240",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Porto_Acre",untils:"-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",offsets:"271.2|300|240",offsetIndices:"01212121212121212121212121212121"},{id:"America/Porto_Velho",untils:"-t85g60|99k8i0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|Infinity",offsets:"255.6|240|180",offsetIndices:"012121212121212121212121212121"},{id:"America/Puerto_Rico",untils:"-efsnk0|1ppu40|2dnc0|Infinity",offsets:"240|180",offsetIndices:"0110"},{id:"America/Punta_Arenas",untils:"-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|2fnh80|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",offsets:"282.7667|300|240|180",offsetIndices:"0102021212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"America/Rainy_River",untils:"-qzov40|a2vw0|bfxjw0|pmdk0|1tz8c0|2dsw0|ewvus0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"010111010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Rankin_Inlet",untils:"-6s8lc0|4c6oo0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|360|240|300",offsetIndices:"012131313131313131313131313131313131313131313331313131313131313131313131313131313131313131313131313131313131313131313131"},{id:"America/Recife",untils:"-t85ljc|99kb3c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",offsets:"139.6|180|120",offsetIndices:"0121212121212121212121212121212121212121"},{id:"America/Regina",untils:"-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",offsets:"418.6|420|360",offsetIndices:"012121212121212121212121221212121212121212121212121212"},{id:"America/Resolute",untils:"-bnp9c0|97nco0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|360|240|300",offsetIndices:"012131313131313131313131313131313131313131313331313131313331313131313131313131313131313131313131313131313131313131313131"},{id:"America/Rio_Branco",untils:"-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",offsets:"271.2|300|240",offsetIndices:"01212121212121212121212121212121"},{id:"America/Rosario",untils:"-px7ys0|5iv8k0|67zw0|a4w40|73h80|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|cls40|66580|cls40|66580|cls40|66580|cls40|67zw0|6a040|hy7w0|6a040|xovw0|3uys0|18nbw0|b0dg0|8ve2k0|3uys0|3yik0|bqas0|71mk0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|7m2qs0|4tzw0|biw40|776k0|bvus0|6u7w0|bvxk0|6u540|bvus0|776k0|7qcg40|3yik0|b5xg0|7k580|Infinity",offsets:"256.8|240|180|120",offsetIndices:"01212121212121212121212121212121212121212123232323132323232"},{id:"America/Santa_Isabel",untils:"-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"468.0667|420|480",offsetIndices:"012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Santarem",untils:"-t85hvc|99ka7c|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|Infinity",offsets:"218.8|240|180",offsetIndices:"0121212121212121212121212121212"},{id:"America/Santiago",untils:"-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",offsets:"282.7667|300|240|180",offsetIndices:"010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"America/Santo_Domingo",untils:"-j6hz1c|hiw29c|67zw0|1dy840|62ha0|cnle0|4h2m0|elyq0|47ta0|ei9e0|4bim0|eek20|4dda0|ecpe0|dkmtg0|1stc0|Infinity",offsets:"280|300|240|270",offsetIndices:"01213131313131212"},{id:"America/Sao_Paulo",untils:"-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",offsets:"186.4667|180|120",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Scoresbysund",untils:"-rvurxk|x8ntpk|902o0|9cvs0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"87.8667|120|60|0",offsetIndices:"0121323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/Shiprock",untils:"-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360",offsetIndices:"01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Sitka",untils:"-ek1w80|1tz2s0|2dyg0|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1leo0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420|540",offsetIndices:"01101010101010101010101010101010122020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202"},{id:"America/St_Barthelemy",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/St_Johns",untils:"-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"210.8667|150.8667|210|150|90",offsetIndices:"01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"America/St_Kitts",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/St_Lucia",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/St_Thomas",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/St_Vincent",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Swift_Current",untils:"-xkq9d4|6l1h14|a2vw0|c5jxg0|1tz5k0|2dvo0|asys0|8n180|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|3yles0|9cyk0|s36s0|9cyk0|9d440|7x3w0|b5xg0|7k580|5j4lg0|Infinity",offsets:"431.3333|420|360",offsetIndices:"012122121212121212121212"},{id:"America/Tegucigalpa",untils:"-pfzh6k|yho0ik|7k580|b5xg0|7k580|96x1g0|4qak0|Infinity",offsets:"348.8667|360|300",offsetIndices:"01212121"},{id:"America/Thule",untils:"-rvuj9g|12yzilg|9cyk0|9d440|9cyk0|9q2s0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"275.1333|240|180",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Thunder_Bay",untils:"-vbavc0|gr8qs0|1tzb40|2dq40|ctmlg0|9cyk0|9d440|9px80|9d440|9cyk0|s36s0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"0122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"America/Tijuana",untils:"-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"468.0667|420|480",offsetIndices:"012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Toronto",untils:"-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Tortola",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Vancouver",untils:"-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Virgin",untils:"-u6m79w|Infinity",offsets:"246.0667|240",offsetIndices:"01"},{id:"America/Whitehorse",untils:"-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",offsets:"540|480|420",offsetIndices:"01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"America/Winnipeg",untils:"-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Yakutat",untils:"-ek1tg0|1tz000|2e180|cawis0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1lbw0|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"540|480",offsetIndices:"01101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"America/Yellowknife",untils:"-i9m2o0|3pk3o0|1tz5k0|2dvo0|a7n3w0|9q000|7k85k0|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"0|420|360|300",offsetIndices:"012213121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Antarctica/Casey",untils:"-irxc0|lag4o0|73bo0|uz1o0|60l80|2fnh80|pz9g0|Infinity",offsets:"0|-480|-660",offsetIndices:"01212121"},{id:"Antarctica/Davis",untils:"-6rmdc0|42jdw0|27wgs0|l8uss0|7eqs0|unmk0|60qs0|Infinity",offsets:"0|-420|-300",offsetIndices:"01012121"},{id:"Antarctica/DumontDUrville",untils:"-c05eo0|2mks80|2i72g0|Infinity",offsets:"0|-600",offsetIndices:"0101"},{id:"Antarctica/Macquarie",untils:"-rsj4w0|8zzw0|11wqk0|f4kh40|a6p8g0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660|0",offsetIndices:"0102010101010101010101010101010101010101010101010101010101010101010101010101010101010101011"},{id:"Antarctica/Mawson",untils:"-8aelc0|t22y80|Infinity",offsets:"0|-360|-300",offsetIndices:"012"},{id:"Antarctica/McMurdo",untils:"-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-690|-750|-720|-780",offsetIndices:"01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Antarctica/Palmer",untils:"-2lxhc0|31ho0|bqas0|71mk0|bqas0|8ovw0|9d440|9px80|9d440|9cyk0|9d440|28t6k0|51ek0|46b6s0|8c2s0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|Infinity",offsets:"0|180|240|120",offsetIndices:"0121212121213121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Antarctica/Rothera",untils:"3lxs00|Infinity",offsets:"0|180",offsetIndices:"01"},{id:"Antarctica/South_Pole",untils:"-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-690|-750|-720|-780",offsetIndices:"01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Antarctica/Syowa",untils:"-6qsqo0|Infinity",offsets:"0|-180",offsetIndices:"01"},{id:"Antarctica/Troll",untils:"ibruo0|27pg0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-120",offsetIndices:"00101010101010101010101010101010101010101010101010101010101010101010"},{id:"Antarctica/Vostok",untils:"-6aaao0|Infinity",offsets:"0|-360",offsetIndices:"01"},{id:"Arctic/Longyearbyen",untils:"-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Asia/Aden",untils:"-bwgbbg|Infinity",offsets:"-186.8667|-180",offsetIndices:"01"},{id:"Asia/Almaty",untils:"-nu1a90|37a0d0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",offsets:"-307.8|-300|-360|-420",offsetIndices:"012323232323232323232321232323232323232323232323232"},{id:"Asia/Amman",untils:"-kcrtbk|m566fk|60l80|awo40|7v980|awo40|7v980|ayis0|9gnw0|9b9g0|7v980|autg0|7v980|3e6840|9et80|9io40|9cyk0|9d440|9cyk0|9d440|9px80|ayis0|7rjw0|ag040|8a2k0|9zc40|8drw0|a31g0|8zzw0|9d440|9cyk0|9d440|8n180|ag040|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|epmo0|4deo0|9o5c0|9ew00|9b6o0|9ew00|9d1c0|9d1c0|9d1c0|asw00|7x6o0|afxc0|8n400|9d1c0|9d1c0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|wel80|51k40|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",offsets:"-143.7333|-120|-180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Anadyr",untils:"-nu1sv8|379zj8|qi27w0|9et80|is040|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",offsets:"-709.9333|-720|-780|-840|-660",offsetIndices:"01232121212121212121214121212121212121212121212121212121212141"},{id:"Asia/Aqtau",untils:"-nu15b4|379y74|qrh3w0|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",offsets:"-201.0667|-240|-300|-360",offsetIndices:"012323232323232323232123232312121212121212121212"},{id:"Asia/Aqtobe",untils:"-nu16l4|379zh4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|Infinity",offsets:"-228.6667|-240|-300|-360",offsetIndices:"0123232323232323232321232323232323232323232323232"},{id:"Asia/Ashgabat",untils:"-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",offsets:"-233.5333|-240|-300|-360",offsetIndices:"0123232323232323232323212"},{id:"Asia/Ashkhabad",untils:"-nu16t8|379zp8|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|Infinity",offsets:"-233.5333|-240|-300|-360",offsetIndices:"0123232323232323232323212"},{id:"Asia/Atyrau",untils:"-nu15m8|37a1a8|qrh140|iruk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|j3440|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",offsets:"-207.7333|-180|-300|-360|-240",offsetIndices:"01232323232323232323242323232323232324242424242"},{id:"Asia/Baghdad",untils:"-r50g80|xkn3w0|7v980|9b9g0|9gnw0|9eys0|9et80|9d440|9b9g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9f1k0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|9ew00|9ew00|9d1c0|9ew00|9d1c0|9ew00|9d1c0|9ew00|Infinity",offsets:"-177.6|-180|-240",offsetIndices:"012121212121212121212121212121212121212121212121212121"},{id:"Asia/Bahrain",untils:"-q3gmvk|rctnrk|Infinity",offsets:"-206.1333|-240|-180",offsetIndices:"012"},{id:"Asia/Baku",untils:"-nu158c|h4tkwc|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|239ew0|asw00|7x3w0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-199.4|-180|-240|-300",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Bangkok",untils:"-pysda4|Infinity",offsets:"-402.0667|-420",offsetIndices:"01"},{id:"Asia/Barnaul",untils:"-q4ljic|5hu6uc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|38fo0|64og0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",offsets:"-335|-360|-420|-480",offsetIndices:"0123232323232323232323212323232321212121212121212121212121212121212"},{id:"Asia/Beirut",untils:"-pyzew0|aunw0|88dg0|9et80|8yas0|a2vw0|a31g0|7k580|hjqo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|5lhs40|56yk0|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|autg0|7v980|2wxus0|8n180|a4w40|8n180|a4w40|8n180|a4w40|8n180|bs5g0|71mk0|alk40|86d80|a4w40|8n180|a4w40|8n180|a6qs0|80t80|905g0|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|Infinity",offsets:"-120|-180",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Asia/Bishkek",untils:"-nu19tc|379zxc|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|h8dc0|bkl80|8n180|a31g0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|9db20|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|Infinity",offsets:"-298.4|-300|-360|-420",offsetIndices:"012323232323232323232321212121212121212121212121212"},{id:"Asia/Brunei",untils:"-mvofy4|3khxs4|Infinity",offsets:"-459.6667|-450|-480",offsetIndices:"012"},{id:"Asia/Calcutta",untils:"-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",offsets:"-321.1667|-330|-390",offsetIndices:"012121"},{id:"Asia/Chita",untils:"-q4cfog|5hkxgg|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnew0|Infinity",offsets:"-453.8667|-480|-540|-600",offsetIndices:"012323232323232323232321232323232323232323232323232323232323232312"},{id:"Asia/Choibalsan",untils:"-xmct7c|11sndrc|2qk2k0|9eqg0|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|s6qk0|3nc0c0|9ct00|9d9o0|9ct00|Infinity",offsets:"-458|-420|-480|-600|-540",offsetIndices:"0123434343434343434343434343434343434343434343424242"},{id:"Asia/Chongqing",untils:"-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010"},{id:"Asia/Chungking",untils:"-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010"},{id:"Asia/Colombo",untils:"-xehask|isle6k|cajy0|1mp2u0|qetjw0|7x5a0|4xvqq0|Infinity",offsets:"-319.5333|-330|-360|-390",offsetIndices:"01231321"},{id:"Asia/Dacca",untils:"-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",offsets:"-353.3333|-390|-330|-360|-420",offsetIndices:"0121343"},{id:"Asia/Damascus",untils:"-q3gk20|5k6q0|8n180|a31g0|8n180|a31g0|8n180|a31g0|8zzw0|k4hk40|7yyk0|awo40|7tek0|b0dg0|7v980|awo40|7tek0|alk40|887w0|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|7v980|awo40|7v980|awo40|7v980|ayis0|7v980|awo40|6bp80|cg840|6bp80|2eh1g0|8zzw0|9ts40|8zzw0|pvk40|c33w0|7cw40|cjrw0|6zxg0|btuk0|7rpg0|9gnw0|9d440|9cyk0|9et80|9et80|9rxg0|91uk0|92040|9et80|9o840|9et80|9d440|9et80|9eys0|9et80|9b9g0|9gnw0|99es0|9iik0|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|9eys0|9et80|9d440|9et80|9d440|8y580|9q2s0|b5rw0|7x9g0|aunw0|7ig40|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|Infinity",offsets:"-145.2|-120|-180",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Dhaka",untils:"-eqtpow|bmgyw|5lxg0|4qknw0|u4ijy0|a1400|Infinity",offsets:"-353.3333|-390|-330|-360|-420",offsetIndices:"0121343"},{id:"Asia/Dili",untils:"-u9s4l8|fqcu98|hufs00|cpz440|Infinity",offsets:"-502.3333|-480|-540",offsetIndices:"01212"},{id:"Asia/Dubai",untils:"-q3gnko|Infinity",offsets:"-221.2|-240",offsetIndices:"01"},{id:"Asia/Dushanbe",untils:"-nu18qo|379yuo|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|hp440|Infinity",offsets:"-275.2|-300|-360|-420",offsetIndices:"012323232323232323232321"},{id:"Asia/Famagusta",untils:"-p4bqac|rvhy2c|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|8h8w0|leog0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-135.8|-120|-180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212212121212121212121212121212121212121212121"},{id:"Asia/Gaza",untils:"-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|7x3w0|asys0|8a5c0|ahs1o|71mic|bzk5o|69uic|cg840|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",offsets:"-120|-180",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010100101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Asia/Harbin",untils:"-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010"},{id:"Asia/Hebron",untils:"-ffv9k0|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|5hoqs0|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|1sns0|3p6is0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|66as0|4vxc0|8n400|a2yo0|8n400|a2yo0|8n400|asw00|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|8n400|a2yo0|8ulg0|97ek0|8y580|9ts40|8hms0|a4qk0|82nw0|anes0|8a5c0|afxc0|73h80|bzk5o|69uic|1hs40|1lbw0|9d440|902o0|9q000|9cyk0|9d440|ast80|7z440|aqyk0|7z6w0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|7idc0|b7pc0|7vc00|auqo0|7vc00|auqo0|7vc00|auqo0|7vc00|b7pc0|Infinity",offsets:"-120|-180",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Asia/Ho_Chi_Minh",untils:"-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",offsets:"-426.6667|-426.5|-420|-480|-540",offsetIndices:"0123423232"},{id:"Asia/Hong_Kong",untils:"-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",offsets:"-456.7|-480|-540|-510",offsetIndices:"0123212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Hovd",untils:"-xmcoz0|11sncb0|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",offsets:"-366.6|-360|-420|-480",offsetIndices:"012323232323232323232323232323232323232323232323232"},{id:"Asia/Irkutsk",untils:"-q28gn5|5fh175|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-417.0833|-420|-480|-540",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Istanbul",untils:"-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",offsets:"-116.9333|-120|-180|-240",offsetIndices:"0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"},{id:"Asia/Jakarta",untils:"-o0bdpc|4lzxc0|4wdzjc|1tu960|1cx860|11jta0|74uc20|Infinity",offsets:"-427.2|-440|-450|-540|-480|-420",offsetIndices:"01232425"},{id:"Asia/Jayapura",untils:"-jebm20|66bqe0|a37vy0|Infinity",offsets:"-562.8|-540|-570",offsetIndices:"0121"},{id:"Asia/Jerusalem",untils:"-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",offsets:"-140.6667|-120|-180|-240",offsetIndices:"012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Kabul",untils:"-d1pkg0|Infinity",offsets:"-240|-270",offsetIndices:"01"},{id:"Asia/Kamchatka",untils:"-olrupo|3z045o|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",offsets:"-634.6|-660|-720|-780",offsetIndices:"012323232323232323232321232323232323232323232323232323232323212"},{id:"Asia/Karachi",untils:"-wvpb30|im3zt0|1mn180|33xpg0|a63o20|g72qo0|9cyk0|2y85g0|7v980|8hms0|aaak0|Infinity",offsets:"-268.2|-330|-390|-300|-360",offsetIndices:"012133434343"},{id:"Asia/Kashgar",untils:"-lx5pjw|Infinity",offsets:"-350.3333|-360",offsetIndices:"01"},{id:"Asia/Kathmandu",untils:"-q3gt4s|yg2lus|Infinity",offsets:"-341.2667|-330|-345",offsetIndices:"012"},{id:"Asia/Katmandu",untils:"-q3gt4s|yg2lus|Infinity",offsets:"-341.2667|-330|-345",offsetIndices:"012"},{id:"Asia/Khandyga",untils:"-q4cjrp|5hl1jp|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|3fx40|4h6s0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",offsets:"-542.2167|-480|-540|-600|-660",offsetIndices:"0123232323232323232323212323232323232323232323232343434343434343432"},{id:"Asia/Kolkata",untils:"-xehava|innm9a|bmfw0|5lxg0|1mn180|Infinity",offsets:"-321.1667|-330|-390",offsetIndices:"012121"},{id:"Asia/Krasnoyarsk",untils:"-q37l72|5gg8j2|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-371.4333|-360|-420|-480",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Kuala_Lumpur",untils:"-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",offsets:"-415.4167|-420|-440|-450|-540|-480",offsetIndices:"0123435"},{id:"Asia/Kuching",untils:"-mvof3k|3khwxk|1epvy0|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e3flc|4ohqo|e5a9c|4ohqo|e3flc|4ohqo|3ajlc|1v2qk0|Infinity",offsets:"-441.3333|-450|-480|-500|-540",offsetIndices:"0123232323232323242"},{id:"Asia/Kuwait",untils:"-bwgbbg|Infinity",offsets:"-186.8667|-180",offsetIndices:"01"},{id:"Asia/Macao",untils:"-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",offsets:"-454.1667|-480|-540|-600",offsetIndices:"012323212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Macau",untils:"-y0i2cy|jdvyoy|6onw0|ac580|8fs40|7v980|11luw0|awlc0|7vc00|ac800|bko00|7x6o0|9d1c0|7vc00|asw00|7x6o0|asw00|7x6o0|auqo0|88ao0|asw00|7x6o0|asw00|779c0|bitc0|779c0|bvs00|6uao0|bw1q0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cvs0|9d6w0|9cvs0|9d6w0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",offsets:"-454.1667|-480|-540|-600",offsetIndices:"012323212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Magadan",untils:"-nu1nxc|37a05c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|s39k0|Infinity",offsets:"-603.2|-600|-660|-720",offsetIndices:"012323232323232323232321232323232323232323232323232323232323232312"},{id:"Asia/Makassar",untils:"-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",offsets:"-477.6|-480|-540",offsetIndices:"00121"},{id:"Asia/Manila",untils:"-hb5y80|4qak0|2qidg0|1b2d80|4xf440|442k0|cdqdg0|9et80|Infinity",offsets:"-480|-540",offsetIndices:"010101010"},{id:"Asia/Muscat",untils:"-q3gnko|Infinity",offsets:"-221.2|-240",offsetIndices:"01"},{id:"Asia/Nicosia",untils:"-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-133.4667|-120|-180",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Novokuznetsk",untils:"-nu36tc|37bu5c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",offsets:"-348.8|-360|-420|-480",offsetIndices:"012323232323232323232321232323232323232323232323232323232323212"},{id:"Asia/Novosibirsk",untils:"-q4do0s|5hmbcs|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|2vh00|6hn40|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|wrpg0|Infinity",offsets:"-331.6667|-360|-420|-480",offsetIndices:"0123232323232323232323212323212121212121212121212121212121212121212"},{id:"Asia/Omsk",untils:"-q5xmx6|5j6d16|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-293.5|-300|-360|-420",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Oral",untils:"-nu15ic|37a16c|qi2540|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|9d1c0|5reo0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",offsets:"-205.4|-180|-300|-360|-240",offsetIndices:"01232323232323232424242424242424242424242424242"},{id:"Asia/Phnom_Penh",untils:"-pysda4|Infinity",offsets:"-402.0667|-420",offsetIndices:"01"},{id:"Asia/Pontianak",untils:"-w6piww|cse2o0|4tnu2w|1wkei0|1cx860|11jta0|74uc20|cixam0|Infinity",offsets:"-437.3333|-450|-540|-480|-420",offsetIndices:"001213134"},{id:"Asia/Pyongyang",untils:"-w895yc|1yh10c|hk5da0|10ipmo0|1f4qo0|Infinity",offsets:"-503|-510|-540",offsetIndices:"012212"},{id:"Asia/Qatar",untils:"-q3gmvk|rctnrk|Infinity",offsets:"-206.1333|-240|-180",offsetIndices:"012"},{id:"Asia/Qostanay",untils:"-nu17s4|37a0o4|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|Infinity",offsets:"-254.4667|-240|-300|-360",offsetIndices:"012323232323232323232123232323232323232323232323"},{id:"Asia/Qyzylorda",untils:"-nu184g|37a10g|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|ohhc0|cyo00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|7osl00|Infinity",offsets:"-261.8667|-240|-300|-360",offsetIndices:"01232323232323232323232323232323232323232323232"},{id:"Asia/Rangoon",untils:"-q3gv5b|bnjp3b|1kh520|Infinity",offsets:"-384.7833|-390|-540",offsetIndices:"0121"},{id:"Asia/Riyadh",untils:"-bwgbbg|Infinity",offsets:"-186.8667|-180",offsetIndices:"01"},{id:"Asia/Saigon",untils:"-x56934|2isioa|gj25iu|15ct80|8so00|tmtk0|4azjw0|2cmao0|8285c0|Infinity",offsets:"-426.6667|-426.5|-420|-480|-540",offsetIndices:"0123423232"},{id:"Asia/Sakhalin",untils:"-xl87rc|kvnarc|ikvh40|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|iq5g0|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",offsets:"-570.8|-540|-660|-720|-600",offsetIndices:"01232323232323232323232423232323232424242424242424242424242424242"},{id:"Asia/Samarkand",untils:"-nu18eh|37a1ah|qi27w0|s6qk0|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|Infinity",offsets:"-267.8833|-240|-300|-360",offsetIndices:"01232323232323232323232"},{id:"Asia/Seoul",untils:"-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",offsets:"-507.8667|-510|-540|-600|-570",offsetIndices:"012232323232141414141414123232"},{id:"Asia/Shanghai",untils:"-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010"},{id:"Asia/Singapore",untils:"-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",offsets:"-415.4167|-420|-440|-450|-540|-480",offsetIndices:"0123435"},{id:"Asia/Srednekolymsk",untils:"-nu1ogs|37a0os|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-614.8667|-600|-660|-720",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Taipei",untils:"-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010101010101010"},{id:"Asia/Tashkent",untils:"-nu18tz|379yxz|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|Infinity",offsets:"-277.1833|-300|-360|-420",offsetIndices:"012323232323232323232321"},{id:"Asia/Tbilisi",untils:"-nu14an|h4tjyn|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9cvs0|9cyk0|9d440|9cyk0|9d440|ipzw0|9cyk0|9q2s0|tivw0|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|4ofw0|6hn40|7k800|Infinity",offsets:"-179.1833|-180|-240|-300",offsetIndices:"0123232323232323232323212121232323232323232323212"},{id:"Asia/Tehran",untils:"-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",offsets:"-205.7333|-210|-240|-300|-270",offsetIndices:"00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"},{id:"Asia/Tel_Aviv",untils:"-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",offsets:"-140.6667|-120|-180|-240",offsetIndices:"012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Asia/Thimbu",untils:"-bojclo|kxymno|Infinity",offsets:"-358.6|-330|-360",offsetIndices:"012"},{id:"Asia/Thimphu",untils:"-bojclo|kxymno|Infinity",offsets:"-358.6|-330|-360",offsetIndices:"012"},{id:"Asia/Tokyo",untils:"-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",offsets:"-540|-600",offsetIndices:"010101010"},{id:"Asia/Tomsk",untils:"-q3zbqf|5h7z2f|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|1leo0|97k40|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|tw040|Infinity",offsets:"-339.85|-360|-420|-480",offsetIndices:"0123232323232323232323212323232323232323232323212121212121212121212"},{id:"Asia/Ujung_Pandang",untils:"-q3gzg0|6p5hc0|4u87w0|1w02k0|Infinity",offsets:"-477.6|-480|-540",offsetIndices:"00121"},{id:"Asia/Ulaanbaatar",untils:"-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",offsets:"-427.5333|-420|-480|-540",offsetIndices:"012323232323232323232323232323232323232323232323232"},{id:"Asia/Ulan_Bator",untils:"-xmcrsk|11sncck|2qk2k0|9et80|9eys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|1ckdo0|7x3w0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|4fio40|9ct00|9d9o0|9ct00|Infinity",offsets:"-427.5333|-420|-480|-540",offsetIndices:"012323232323232323232323232323232323232323232323232"},{id:"Asia/Urumqi",untils:"-lx5pjw|Infinity",offsets:"-350.3333|-360",offsetIndices:"01"},{id:"Asia/Ust-Nera",untils:"-q4cl6u|5hl2yu|qi27w0|9eno0|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|8ql00|1mlho0|Infinity",offsets:"-572.9|-480|-540|-720|-660|-600",offsetIndices:"012343434343434343434345434343434343434343434343434343434343434345"},{id:"Asia/Vientiane",untils:"-pysda4|Infinity",offsets:"-402.0667|-420",offsetIndices:"01"},{id:"Asia/Vladivostok",untils:"-oligf7|3yqvf7|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-527.5167|-540|-600|-660",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Yakutsk",untils:"-q4cioy|5hl0gy|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-518.9667|-480|-540|-600",offsetIndices:"01232323232323232323232123232323232323232323232323232323232323232"},{id:"Asia/Yangon",untils:"-q3gv5b|bnjp3b|1kh520|Infinity",offsets:"-384.7833|-390|-540",offsetIndices:"0121"},{id:"Asia/Yekaterinburg",untils:"-rx5hw9|1kybx4|5pfyv5|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-242.55|-225.0833|-240|-300|-360",offsetIndices:"012343434343434343434343234343434343434343434343434343434343434343"},{id:"Asia/Yerevan",untils:"-nu148o|h4tjwo|ckinw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|iq5g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|11t180|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|Infinity",offsets:"-178|-180|-240|-300",offsetIndices:"0123232323232323232323212121212323232323232323232323232323232"},{id:"Atlantic/Azores",untils:"-u9rbs0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"114.5333|120|60|0",offsetIndices:"01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323233323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Atlantic/Bermuda",untils:"-kvj2fu|n4pr3u|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"259.3|240|180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Atlantic/Canary",untils:"-oytbtc|ctvupc|hhq7s0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"61.6|60|0|-60",offsetIndices:"01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Atlantic/Cape_Verde",untils:"-u9rbs0|g06lc0|1mn180|fpqwc0|Infinity",offsets:"94.0667|120|60",offsetIndices:"01212"},{id:"Atlantic/Faeroe",untils:"-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"27.0667|0|-60",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Atlantic/Faroe",untils:"-wcehew|127keuw|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"27.0667|0|-60",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Atlantic/Jan_Mayen",untils:"-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Atlantic/Madeira",untils:"-u9rek0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5qbjo0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"67.6|60|0|-60",offsetIndices:"01212121212121212121212121212121212121212121232123212321232121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Atlantic/Reykjavik",untils:"-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",offsets:"88|60|0",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212"},{id:"Atlantic/South_Georgia",untils:"Infinity",offsets:"120",offsetIndices:"0"},{id:"Atlantic/St_Helena",untils:"-u9rgl4|Infinity",offsets:"16.1333|0",offsetIndices:"01"},{id:"Atlantic/Stanley",untils:"-u63pac|dbvxqc|8zzw0|9q2s0|8zzw0|a31g0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|4xp80|l1pus0|7k580|b5rw0|77c40|biqk0|id6s0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|77c40|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|biqk0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5rw0|7kas0|b5xg0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|77c40|biqk0|77c40|biqk0|77c40|Infinity",offsets:"231.4|240|180|120",offsetIndices:"012121212121212323212121212121212121212121212121212121212121212121212"},{id:"Australia/ACT",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Adelaide",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-570|-630",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Brisbane",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",offsets:"-600|-660",offsetIndices:"01010101010101010"},{id:"Australia/Broken_Hill",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-570|-630",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Canberra",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Currie",untils:"-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Darwin",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",offsets:"-570|-630",offsetIndices:"010101010"},{id:"Australia/Eucla",untils:"-rnstlc|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",offsets:"-525|-585",offsetIndices:"0101010101010101010"},{id:"Australia/Hobart",untils:"-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/LHI",untils:"5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",offsets:"-600|-630|-690|-660",offsetIndices:"0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"},{id:"Australia/Lindeman",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|Infinity",offsets:"-600|-660",offsetIndices:"010101010101010101010"},{id:"Australia/Lord_Howe",untils:"5tp880|c8uu0|6u7w0|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|777y0|b5w20|7k6m0|biuq0|7k6m0|biuq0|777y0|biuq0|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|7x820|asum0|b5w20|7x5a0|asxe0|7x5a0|asxe0|7x5a0|b5w20|7k6m0|b5w20|7x5a0|asxe0|7k6m0|b5w20|8a3y0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9pym0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9d2q0|9czy0|9q1e0|9czy0|9d2q0|9czy0|9d2q0|Infinity",offsets:"-600|-630|-690|-660",offsetIndices:"0121212121313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313131313"},{id:"Australia/Melbourne",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/North",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|Infinity",offsets:"-570|-630",offsetIndices:"010101010"},{id:"Australia/NSW",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Perth",untils:"-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",offsets:"-480|-540",offsetIndices:"0101010101010101010"},{id:"Australia/Queensland",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|97zuo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|Infinity",offsets:"-600|-660",offsetIndices:"01010101010101010"},{id:"Australia/South",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|7k800|b5uo0|6uao0|c8qo0|779c0|bitc0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-570|-630",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Sydney",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Tasmania",untils:"-rsj4w0|8zzw0|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|c9tms0|9d1c0|asw00|6uao0|bvs00|6uao0|bvs00|779c0|bvs00|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|b5uo0|7k800|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|bvs00|7k800|bitc0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x6o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|7x6o0|asw00|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/Victoria",untils:"-rnsx2c|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|b5uo0|7x6o0|bitc0|779c0|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|7x6o0|asw00|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-600|-660",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Australia/West",untils:"-rnsric|49s2c|cxfms0|4h180|9d440|9cyk0|ghf1g0|6hc00|4ir9c0|6hc00|40r400|5eg00|7p9hc0|5reo0|b5uo0|7x6o0|asw00|7x6o0|Infinity",offsets:"-480|-540",offsetIndices:"0101010101010101010"},{id:"Australia/Yancowinna",untils:"-rnsvoc|49s2c|cxfms0|4h180|9d440|9cyk0|9q2s0|8zzw0|eeiqs0|64dc0|clpc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|8a5c0|asw00|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|779c0|b5uo0|7k800|bitc0|7k800|bitc0|779c0|bitc0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|8a5c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-570|-630",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101"},{id:"Brazil/Acre",untils:"-t85fg0|99kak0|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|amves0|2t2t80|Infinity",offsets:"271.2|300|240",offsetIndices:"01212121212121212121212121212121"},{id:"Brazil/DeNoronha",untils:"-t85lzw|99k8rw|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|514g40|7k580|biw40|cvw0|iq5g0|6h980|Infinity",offsets:"129.6667|120|60",offsetIndices:"0121212121212121212121212121212121212121"},{id:"Brazil/East",untils:"-t85jd8|99k8x8|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5k02s0|6onw0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|cyqs0|5ed80|dbpg0|64ak0|cyqs0|64ak0|cls40|5rbw0|dbpg0|51ek0|dbpg0|6h980|c8tg0|6h980|c8tg0|64ak0|c8tg0|6u7w0|bxpg0|7iak0|biw40|6u7w0|biw40|7k580|biw40|6u7w0|c8tg0|6h980|dbpg0|5ed80|cls40|64ak0|dfes0|5nmk0|c8tg0|6h980|dbpg0|5rbw0|bvus0|6h980|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6u7w0|c8tg0|64ak0|cls40|64ak0|cls40|6h980|c8tg0|6h980|c8tg0|6h980|c8tg0|6h980|dbpg0|5ed80|Infinity",offsets:"186.4667|180|120",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Brazil/West",untils:"-t85gvw|99k97w|9a9c0|9io40|99980|8p65g0|6zuo0|bs2o0|67zw0|cjxg0|69uk0|cjxg0|4ml80|5mf440|49mk0|haas0|316k0|cls40|4ml80|cls40|66580|cls40|67zw0|981s40|6u7w0|biw40|5rbw0|d0lg0|5ed80|2yy2s0|6h980|Infinity",offsets:"240.0667|240|180",offsetIndices:"01212121212121212121212121212121"},{id:"Canada/Atlantic",untils:"-z94k80|777go0|9et80|st9o0|a2vw0|ssyk0|5rbw0|cv1g0|69uk0|c6ys0|6kyk0|ci2s0|67zw0|ci2s0|6w2k0|bu040|7lzw0|bu040|66580|bu040|7lzw0|bu040|64ak0|cls40|5v180|cv1g0|6j3w0|c6ys0|79180|b42s0|7lzw0|b42s0|7yyk0|bu040|64ak0|dbpg0|66580|cls40|5ed80|bu040|7lzw0|b42s0|7lzw0|cjxg0|66580|bh1g0|7lzw0|b42s0|7lzw0|6uj00|1tzdw0|2dnc0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|tw040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|1cm2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"254.4|240|180",offsetIndices:"0121212121212121212121212121212121212121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Canada/Central",untils:"-s0s7c0|7k580|tj700|a2vw0|9ok840|6u7w0|2a5hg0|1tz8c0|2dsw0|biw40|7x3w0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b7s40|7tek0|autg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|7x3w0|1cm2s0|7k580|1cm2s0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|asw00|7x6o0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Canada/Eastern",untils:"-qzoxw0|a2vw0|7yx60|aqzy0|9q8c0|7jzo0|bw0c0|6bp80|cedg0|6h980|c8tg0|6h980|bvus0|776k0|biw40|776k0|biw40|776k0|biw40|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|xjeo0|1tzb40|2dq40|asys0|7x3w0|ast80|7x3w0|asys0|7x3w0|asys0|b5rw0|7xf00|ast80|7x9g0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"01010101010101010101010101010101010101010101011101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Canada/Mountain",untils:"-x1yazk|629ink|a2vw0|8n6s0|29ek0|h6lg0|9px80|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|9l0g40|1tz5k0|2dvo0|tj1g0|7x3w0|ctzk40|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"453.8667|420|360",offsetIndices:"0121212121212122121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Canada/Newfoundland",untils:"-ris3ck|8bx80|ar440|a2vw0|9tjs0|53980|dkys0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|8zzw0|9q2s0|9cyk0|9q2s0|8zzw0|9q2s0|8zzw0|7tmw0|1wfuk|8zzw0|a3480|7k580|b5xg0|7k580|b5xg0|7k580|biw40|776k0|biw40|7k580|b5xg0|7k580|b5xg0|1pb260|2dly0|biw40|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|biw40|7k580|ag040|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a2lo|afuk0|8a840|asqg0|7xc80|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8tec|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"210.8667|150.8667|210|150|90",offsetIndices:"01010101010101010101010101010101010102323232323232323323232323232323232323232323232323232323232323232323232323232323232323232323232323232324232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Canada/Pacific",untils:"-qzopk0|a2vw0|c5jxg0|1tz2s0|2dyg0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"0101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Canada/Saskatchewan",untils:"-xkq9yc|6l1hmc|a2vw0|60enw0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|1b6840|9cyk0|9d440|8zzw0|9q2s0|9cyk0|9q2s0|9cyk0|9d440|9cyk0|66gc0|1tz5k0|2dvo0|a31g0|9cyk0|a31g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|tj1g0|9cyk0|9d440|Infinity",offsets:"418.6|420|360",offsetIndices:"012121212121212121212121221212121212121212121212121212"},{id:"Canada/Yukon",untils:"-qzoms0|a2vw0|asys0|882c0|bmiwc0|1tz000|2e180|a7n3w0|9q000|tiyo0|6qp440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|Infinity",offsets:"540|480|420",offsetIndices:"01010110201212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"CET",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Chile/Continental",untils:"-vauawq|3dlssq|157b7a|f4e0q|49hzba|aye0q|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|534ik0|351g0|229zw0|2gt80|awo40|2mg00|b73400|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",offsets:"282.7667|300|240|180",offsetIndices:"010202121212121212321232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Chile/EasterIsland",untils:"-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",offsets:"437.4667|420|360|300",offsetIndices:"012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"CST6CDT",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Cuba",untils:"-n7762o|1icfyo|69uk0|62s040|4ofw0|e1ms0|51ek0|e1ms0|4ofw0|1fhs40|4ofw0|e1ms0|4ofw0|9s9k40|67zw0|cedg0|6h980|9o840|7yyk0|b5xg0|7k580|bvus0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|8a2k0|ag040|8bx80|ae5g0|8drw0|acas0|9cyk0|9d440|9px80|905g0|9px80|9q2s0|7x3w0|8a840|ast80|7x9g0|ast80|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|8a2k0|ag040|8a2k0|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|905g0|a2vw0|905g0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|8n400|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|8a5c0|afxc0|8a5c0|afxc0|7x6o0|1cm000|6uao0|bvs00|779c0|bitc0|6uao0|bvs00|779c0|bvs00|779c0|c8qo0|779c0|b5uo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|Infinity",offsets:"329.6|300|240",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"EET",untils:"3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-120|-180",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Egypt",untils:"-fdls80|40d80|a31g0|7x3w0|a4w40|aqyk0|80ys0|b07w0|7tk40|b07w0|8jhg0|a8fw0|60go40|7el80|awo40|7v980|awqw0|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7tk40|ayd80|7tk40|b07w0|7tk40|ayd80|7tk40|ayd80|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|f9x80|3i040|eluk0|462s0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|b5rw0|7m5g0|awik0|7ves0|awik0|7ves0|ayd80|7ves0|awik0|7ves0|awik0|7ves0|aqvs0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7k580|b5xg0|6u7w0|bvus0|6h980|c8tg0|64ak0|cyqs0|5anw0|1jms0|12t80|1w22s0|25p80|1sw40|2vmk0|Infinity",offsets:"-120|-180",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Eire",untils:"-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"25.35|-34.65|0|-60",offsetIndices:"01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"EST",untils:"Infinity",offsets:"300",offsetIndices:"0"},{id:"EST5EDT",untils:"-r0ev80|ast80|7x9g0|ast80|bmtus0|1tzb40|2dq40|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Etc/GMT-0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/GMT-1",untils:"Infinity",offsets:"-60",offsetIndices:"0"},{id:"Etc/GMT-10",untils:"Infinity",offsets:"-600",offsetIndices:"0"},{id:"Etc/GMT-11",untils:"Infinity",offsets:"-660",offsetIndices:"0"},{id:"Etc/GMT-12",untils:"Infinity",offsets:"-720",offsetIndices:"0"},{id:"Etc/GMT-13",untils:"Infinity",offsets:"-780",offsetIndices:"0"},{id:"Etc/GMT-14",untils:"Infinity",offsets:"-840",offsetIndices:"0"},{id:"Etc/GMT-2",untils:"Infinity",offsets:"-120",offsetIndices:"0"},{id:"Etc/GMT-3",untils:"Infinity",offsets:"-180",offsetIndices:"0"},{id:"Etc/GMT-4",untils:"Infinity",offsets:"-240",offsetIndices:"0"},{id:"Etc/GMT-5",untils:"Infinity",offsets:"-300",offsetIndices:"0"},{id:"Etc/GMT-6",untils:"Infinity",offsets:"-360",offsetIndices:"0"},{id:"Etc/GMT-7",untils:"Infinity",offsets:"-420",offsetIndices:"0"},{id:"Etc/GMT-8",untils:"Infinity",offsets:"-480",offsetIndices:"0"},{id:"Etc/GMT-9",untils:"Infinity",offsets:"-540",offsetIndices:"0"},{id:"Etc/GMT",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/GMT+0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/GMT+1",untils:"Infinity",offsets:"60",offsetIndices:"0"},{id:"Etc/GMT+10",untils:"Infinity",offsets:"600",offsetIndices:"0"},{id:"Etc/GMT+11",untils:"Infinity",offsets:"660",offsetIndices:"0"},{id:"Etc/GMT+12",untils:"Infinity",offsets:"720",offsetIndices:"0"},{id:"Etc/GMT+2",untils:"Infinity",offsets:"120",offsetIndices:"0"},{id:"Etc/GMT+3",untils:"Infinity",offsets:"180",offsetIndices:"0"},{id:"Etc/GMT+4",untils:"Infinity",offsets:"240",offsetIndices:"0"},{id:"Etc/GMT+5",untils:"Infinity",offsets:"300",offsetIndices:"0"},{id:"Etc/GMT+6",untils:"Infinity",offsets:"360",offsetIndices:"0"},{id:"Etc/GMT+7",untils:"Infinity",offsets:"420",offsetIndices:"0"},{id:"Etc/GMT+8",untils:"Infinity",offsets:"480",offsetIndices:"0"},{id:"Etc/GMT+9",untils:"Infinity",offsets:"540",offsetIndices:"0"},{id:"Etc/GMT0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/Greenwich",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/UCT",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/Universal",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/UTC",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Etc/Zulu",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Europe/Amsterdam",untils:"-s0dvkk|7v980|a51o0|7x6o0|a2yo0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9b6o0|a2yo0|c51c0|6l1c0|902o0|9q000|ci000|682o0|bgyo0|79400|bitc0|779c0|bmio0|7gio0|bbeo0|7eo00|bd9c0|7ctc0|bf400|7ayo0|bvs00|6uao0|bko00|7idc0|b9k00|7gio0|bbeo0|7eo00|bf400|7ayo0|btxc0|21uc0|4uaz8|bitc0|779c0|bko00|7idc0|bd3s0|1aarpc|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-19.5333|-79.5333|-80|-20|-120|-60",offsetIndices:"010101010101010101010101010101010101010101012323234545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545454545"},{id:"Europe/Andorra",untils:"-c4xmo0|k3ctg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Astrakhan",untils:"-nu2zkc|37bv8c|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",offsets:"-192.2|-180|-240|-300",offsetIndices:"012323232323232323212121212121212121212121212121212121212121212"},{id:"Europe/Athens",untils:"-rvv0cg|8bjasg|2vmk0|4hiw40|16ik0|scog0|7lx40|9o2k0|9eys0|4atzw0|6djw0|bplus0|bq800|71uw0|9d1c0|902o0|91xc0|9o5c0|905g0|9qgo0|9akg0|9iik0|99980|9dcg0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-94.8667|-120|-180|-60",offsetIndices:"012121313121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Belfast",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Belgrade",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Berlin",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|2o7w0|6bs00|2txg0|7k800|91xc0|9b9g0|1sqk0|2inw0|51k40|a2yo0|8n400|9q000|902o0|fx91c0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120|-180",offsetIndices:"01010101010101210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Bratislava",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120|0",offsetIndices:"01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Brussels",untils:"-ss5uo0|rrx80|7vc00|a4yw0|7x6o0|asw00|7x6o0|2wh40|5omo0|b5uo0|6uao0|cyo00|7ayo0|bko00|7rmo0|a2yo0|a2yo0|8n400|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|90b00|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|4deo0|1a36k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0121212101010101010101010101010101010101010101010101212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Bucharest",untils:"-k29zi0|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|kp0dc0|6h980|9q000|905g0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-104.4|-120|-180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Budapest",untils:"-s0e080|7ves0|a4yw0|7x6o0|a31g0|8n180|autg0|bgvw0|b5jeg0|th9k0|7k800|9q000|9d1c0|9d1c0|awd00|9ew00|7q0c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|a4tc0|9q000|1va2g0|6u7w0|bxpg0|6u7w0|cjxg0|64ak0|cluw0|64g40|br3ek0|905g0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Busingen",untils:"-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Chisinau",untils:"-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-115|-104.4|-120|-180|-60|-240",offsetIndices:"012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Copenhagen",untils:"-rzo2w0|75bw0|cbs2w0|1aco80|7k800|9q000|9d1c0|9d1c0|9d1c0|6y000|dbmo0|6bs00|clpc0|51hc0|e1k00|4oio0|giutc0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Dublin",untils:"-rzcmlr|6uao0|9pytr|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|3g8800|8a5c0|bvs00|8n400|a2yo0|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"25.35|-34.65|0|-60",offsetIndices:"01232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Gibraltar",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|d0tp80|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"010101010101010101010101010101010101010101010101012121212121010121010101010101010101012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Guernsey",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Helsinki",untils:"-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-99.8167|-120|-180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Isle_of_Man",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Istanbul",untils:"-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",offsets:"-116.9333|-120|-180|-240",offsetIndices:"0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"},{id:"Europe/Jersey",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Kaliningrad",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|el00|z6o0|9kd80|82tg0|i9avw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-60|-120|-180|-240",offsetIndices:"01010101010101121232323232323232322121212121212121212121212121212121212121212121"},{id:"Europe/Kiev",untils:"-nu11ng|37a03g|5vd6k0|kzv40|7k800|9q000|1oyg0|jipzs0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|51ek0|neqw0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-122.0667|-120|-180|-60|-240",offsetIndices:"0121313242424242424242424242121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Kirov",untils:"-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-198.8|-180|-240|-300",offsetIndices:"01232323232323232321212121212121212121212121212121212121212121"},{id:"Europe/Lisbon",untils:"-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"36.75|0|-60|-120",offsetIndices:"012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Ljubljana",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/London",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Luxembourg",untils:"-y89550|68l290|75hg0|ast80|796s0|at1k0|7x6o0|3lh40|4zmo0|b6300|6u2c0|cytk0|7at40|bktk0|7rh40|a31g0|a2vw0|8n9k0|8zx40|9q2s0|9et80|9b9g0|a2vw0|8n6s0|9px80|905g0|a2vw0|905g0|a2vw0|8ncc0|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|42ao0|1aeak0|7k800|9q000|9d1c0|8n400|a2yo0|8l9c0|clpc0|79400|fwu800|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-24.6|-60|-120|0",offsetIndices:"0121212131313131313131313131313131313131313131313131212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Madrid",untils:"-qzlus0|8yas0|9cyk0|9eys0|2d2vw0|8sqs0|ssyk0|8n6s0|9px80|905g0|a2yo0|902o0|a2vw0|8n6s0|40lh80|5k2s0|9cyk0|1frw0|7z1c0|j1c80|8a2k0|13yt80|685g0|brzw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|a2vw0|8n6s0|1clx80|7x9g0|cswik0|905g0|9px80|905g0|8zzw0|9d440|9px80|905g0|9q5k0|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"010101010101010101210121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Malta",untils:"-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9b6o0|8n400|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|9b6o0|9d1c0|ahs00|7m2o0|b45k0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|a4w40|8y580|9q2s0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Mariehamn",untils:"-peghyd|ax3tqd|9gqo0|k31s80|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-99.8167|-120|-180",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Minsk",untils:"-nu113c|379zjc|5r1mk0|pbf40|7k800|9q000|9d1c0|4oac0|j6dmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|sg2o0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|Infinity",offsets:"-110|-120|-180|-60|-240",offsetIndices:"01213131242424242424242424221212121212121212121212121212121212121212"},{id:"Europe/Monaco",untils:"-uozn3l|2qx1nl|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|mdbo0|7x3w0|7x9g0|c8w80|7k800|9q000|9d1c0|9nzs0|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-9.35|0|-60|-120",offsetIndices:"01212121212121212121212121212121212121212121212121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Moscow",untils:"-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",offsetIndices:"012132345464575454545454545454545455754545454545454545454545454545454545454545"},{id:"Europe/Nicosia",untils:"-p4bq6g|rvhxyg|9cyk0|b42s0|7nuk0|8yas0|8zzw0|9q2s0|9et80|9b9g0|9cyk0|9q2s0|8zzw0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|9cyk0|9d440|9cyk0|9d440|at4c0|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-133.4667|-120|-180",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Oslo",untils:"-rzayo0|6qfs0|cgcqo0|15tsc0|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|70q5c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|b5uo0|7k800|7law00|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Paris",untils:"-uozn1x|2qx1lx|5luo0|8y800|a4tc0|7vc00|auqo0|7idc0|b7pc0|6sg00|cyo00|7ayo0|bko00|7rmo0|a2yo0|bvs00|6uao0|902o0|9q000|9d1c0|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|9d1c0|9d1c0|902o0|a2yo0|9d1c0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51po0|5p8w0|18rcc0|7k800|9q000|9d1c0|7efo0|29k40|922w0|8l9c0|fxlx80|9cyk0|9q5k0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-9.35|0|-60|-120",offsetIndices:"0121212121212121212121212121212121212121212121212123232332323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Podgorica",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Prague",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|9d1c0|b5uo0|7vc00|2vs40|4bk00|2vmk0|8n400|a2yo0|8n400|9o5c0|91xc0|fe6000|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120|0",offsetIndices:"01010101010101010201010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Riga",untils:"-qznlky|7x6o0|a4tc0|2mg00|3myns0|7fhlky|gz180|p5v40|7k800|9q000|9d1c0|9d1c0|k7s0|j14ns0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|asw00|7x6o0|asw00|7x6o0|b5uo0|qaao0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-96.5667|-156.5667|-120|-180|-60|-240",offsetIndices:"010102324242435353535353535353323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Rome",untils:"-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Samara",untils:"-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|jt1g0|89zs0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|j3440|7k800|Infinity",offsets:"-200.3333|-180|-240|-300",offsetIndices:"0123232323232323232121232323232323232323232323232323232323212"},{id:"Europe/San_Marino",untils:"-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Sarajevo",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Saratov",untils:"-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|13m040|Infinity",offsets:"-184.3|-180|-240|-300",offsetIndices:"012323232323232321212121212121212121212121212121212121212121212"},{id:"Europe/Simferopol",untils:"-nu12ao|37a0qo|5xiyk0|iu340|7k800|9q000|9d1c0|iac0|jajmk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|wrjw0|9cyk0|9d440|9cyk0|9d440|1sqk0|7k580|9d440|9cyk0|9q2s0|at4c0|7x9g0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x3w0|asqg0|Infinity",offsets:"-136|-120|-180|-60|-240",offsetIndices:"012131312424242424242424242121212424242212121212121212121212121212121212142"},{id:"Europe/Skopje",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Sofia",untils:"-e6dzw0|7k800|9q000|9d1c0|9d1c0|9d440|hqq240|9eys0|9o2k0|92040|9o2k0|90880|9pug0|90b00|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xhs0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-120|-60|-180",offsetIndices:"01010102020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020202020"},{id:"Europe/Stockholm",untils:"-rzo2w0|75hg0|x5bew0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Tallinn",untils:"-r3exx0|3re10|7x6o0|et6g0|ygov0|a1zgd0|ktx80|l94g0|7k800|9q000|9d1c0|8uac0|j27mk0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asys0|7x6o0|b5uo0|19dc00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-99|-60|-120|-180|-240",offsetIndices:"012102321212343434343434343433232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Tirane",untils:"-t85vo8|dt2gw8|18pew0|7k800|m800|g7ot40|7rjw0|autg0|7x3w0|ayis0|7x3w0|b5xg0|7k580|b42s0|7lzw0|b42s0|7lzw0|b42s0|7x3w0|ahus0|7x3w0|b5xg0|7x3w0|a4w40|8jbw0|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-79.3333|-60|-120",offsetIndices:"01212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Tiraspol",untils:"-r2p1bo|70f1to|fj8m0|6w5c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|geqo0|ha580|oc8g0|7k800|9q000|9d1c0|7cl00|j3pbw0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|25p80|7kdk0|9d1c0|9d1c0|9cvs0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|ast80|7xf00|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-115|-104.4|-120|-180|-60|-240",offsetIndices:"012323232323232323232424235353535353535353535323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"Europe/Ulyanovsk",untils:"-qcx400|5q5zo0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9q000|iq5g0|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|qnc40|Infinity",offsets:"-193.6|-180|-240|-300|-120",offsetIndices:"01232323232323232321214121212121212121212121212121212121212121212"},{id:"Europe/Uzhgorod",untils:"-fizzw0|1cm000|7k800|9q000|9d1c0|al900|cnms0|int140|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|eeio0|e1sc0|iprk0|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120|-180|-240",offsetIndices:"010101023232323232323232320121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Vaduz",untils:"-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Vatican",untils:"-rymys0|64ak0|9d440|9et80|88dg0|aunw0|7ig40|b5rw0|8n6s0|9cyk0|aau2s0|18r9k0|7k800|9q000|9d1c0|8l9c0|a4tc0|8j940|9f1k0|afxc0|89zs0|afxc0|7kdk0|b5uo0|979rs0|6h980|cls40|64dc0|clpc0|64dc0|cyo00|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|clpc0|64dc0|c8qo0|6hc00|clpc0|64dc0|clpc0|64dc0|c8qo0|6hc00|clpc0|6hc00|c8qo0|6hc00|9q5k0|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Vienna",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|t6000|8a5c0|a7a800|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|iio0|ivmo0|91xc0|9b6o0|9d1c0|a2yo0|8n400|gfyyg0|8zzw0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Vilnius",untils:"-rns980|1g224o|e75nc|4kqk0|acbs40|gpp40|pits0|7k800|9q000|9d1c0|65zo0|j4vx80|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x9g0|asw00|7x6o0|b5uo0|1s3eo0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-84|-95.6|-60|-120|-180|-240",offsetIndices:"012324323234545454545454545443434343434343434332334343434343434343434343434343434343434343434343434343434343434343434343"},{id:"Europe/Volgograd",untils:"-q3cw84|5glrw4|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|iq5g0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|s3400|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|239c40|Infinity",offsets:"-177.6667|-180|-240|-300",offsetIndices:"012323232323232321212121212121212121212121212121212121212121212"},{id:"Europe/Warsaw",untils:"-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-84|-60|-120|-180",offsetIndices:"012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Zagreb",untils:"-ezayw0|swz00|7k800|9q000|9d1c0|9d1c0|b7pc0|6qlc0|jl1hc0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Europe/Zaporozhye",untils:"-nu12hc|37a0xc|5u1180|mc0g0|7k800|9q000|12qg0|jjc7s0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9cvs0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9dcg0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-140|-120|-180|-60|-240",offsetIndices:"01213132424242424242424242422121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Europe/Zurich",untils:"-eyh6o0|7x6o0|asw00|7x6o0|k2zus0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"GB-Eire",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"GB",untils:"-rzcns0|6uao0|9q000|8c000|9o5c0|9ruo0|9b6o0|9ew00|9b6o0|auqo0|88ao0|9ew00|8y800|a2yo0|a2yo0|7k800|asw00|8a5c0|asw00|8n400|a2yo0|8n400|9q000|902o0|afxc0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|9d1c0|a2yo0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|a2yo0|b5uo0|51hc0|mbmk0|51hc0|c8qo0|6hc00|c8qo0|6uao0|bvs00|8n400|a4tc0|5clc0|4bms0|9q000|902o0|8a5c0|1frw0|64dc0|4bms0|6uao0|bvs00|7x6o0|asw00|8n400|9q000|902o0|9q000|9d1c0|9q000|902o0|8n400|9q000|902o0|a2yo0|8n400|afxc0|8n400|9q000|902o0|a2yo0|8n400|a2yo0|8n400|9q000|902o0|902o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|5reo0|1xhuo0|779c0|bitc0|779c0|bitc0|779c0|bitc0|779c0|bitc0|7k800|b5uo0|7k800|b5uo0|7k800|bitc0|779c0|bitc0|779c0|bitc0|7x3w0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60|-120",offsetIndices:"0101010101010101010101010101010101010101010101010121212121210101210101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"GMT-0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"GMT",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"GMT+0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"GMT0",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Greenwich",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Hongkong",untils:"-y0i0s0|j44dk0|5k000|4d4y0|2195i0|7x3w0|bj320|6uao0|bvs00|7x6o0|9d1c0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|8a5c0|asw00|7x6o0|ast80|77c40|biqk0|77c40|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|77c40|biqk0|77c40|bvp80|6udg0|bvp80|6udg0|bvp80|77c40|biqk0|77c40|biqk0|8n6s0|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9cyk0|1c9440|8a2k0|Infinity",offsets:"-456.7|-480|-540|-510",offsetIndices:"0123212121212121212121212121212121212121212121212121212121212121212121"},{id:"HST",untils:"Infinity",offsets:"600",offsetIndices:"0"},{id:"Iceland",untils:"-wcwx9c|4rpd9c|ci2s0|69uk0|du840|4xp80|du840|p7bw0|4w040|9bdzw0|9d6w0|64g40|cyl80|64dc0|clpc0|6hc00|bvs00|6uao0|bvs00|6uao0|bvs00|6uao0|c8qo0|6hc00|c8qo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|7x6o0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|asw00|8a5c0|Infinity",offsets:"88|60|0",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212"},{id:"Indian/Antananarivo",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Indian/Chagos",untils:"-wvpc2s|1ag64us|Infinity",offsets:"-289.6667|-300|-360",offsetIndices:"012"},{id:"Indian/Christmas",untils:"Infinity",offsets:"-420",offsetIndices:"0"},{id:"Indian/Cocos",untils:"Infinity",offsets:"-390",offsetIndices:"0"},{id:"Indian/Comoro",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Indian/Kerguelen",untils:"-afrs00|Infinity",offsets:"0|-300",offsetIndices:"01"},{id:"Indian/Mahe",untils:"-x6pjlo|Infinity",offsets:"-221.8|-240",offsetIndices:"01"},{id:"Indian/Maldives",untils:"-57x6y0|Infinity",offsets:"-294|-300",offsetIndices:"01"},{id:"Indian/Mauritius",untils:"-wvp9bc|13jnu7c|8bx80|dd0wc0|7x3w0|Infinity",offsets:"-230|-240|-300",offsetIndices:"012121"},{id:"Indian/Mayotte",untils:"-lnsetg|s8mhg|57v020|afrrb0|Infinity",offsets:"-147.2667|-180|-150|-165",offsetIndices:"01231"},{id:"Indian/Reunion",untils:"-uks29s|Infinity",offsets:"-221.8667|-240",offsetIndices:"01"},{id:"Iran",untils:"-s6m6uw|fnolc0|gm3h4w|777y0|b07w0|3pes0|42c20|9cyk0|9gtg0|9kd80|5ja5g0|7avw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|1av440|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9d440|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|9b9g0|9gnw0|Infinity",offsets:"-205.7333|-210|-240|-300|-270",offsetIndices:"00123214141414141414141414141414141414141414141414141414141414141414141414141414141414141414141414141"},{id:"Israel",untils:"-r50eig|bp54yg|19f3w0|7rv00|b02c0|7tk40|b07w0|8jhg0|a8lg0|8jhg0|a8ac0|t9s40|56vs0|35700|9b3w0|9gtg0|8jbw0|7tmw0|a6ig0|biyw0|8a5c0|9d1c0|902o0|7x6o0|e1eg0|4ofw0|dzxo0|4q500|doo40|64iw0|auqo0|7i500|8rfms0|51ek0|9q2s0|6u7w0|2khpg0|25s00|1weyo0|5reo0|bxmo0|7x3w0|cls40|5rbw0|bbhg0|7rjw0|asys0|7k580|c8tg0|6h980|ag040|7x3w0|asys0|8a2k0|asys0|8a2k0|ap9g0|80t80|ap9g0|7nuk0|b2840|80t80|9zc40|9iik0|9kis0|93p80|9mdg0|8qqk0|apf00|7x3w0|biw40|8zx40|9io40|8n180|9kis0|9vh80|8ulg0|9px80|9mdg0|8n180|9tuw0|9tmk0|8wg40|9gnw0|99es0|8qqk0|9zc40|9tmk0|8wg40|9gnw0|99es0|8qqk0|acas0|9gnw0|99es0|93p80|9mdg0|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|7tk40|b9h80|7glg0|b9h80|7glg0|b9h80|7glg0|b9h80|7tk40|awik0|7tk40|awik0|Infinity",offsets:"-140.6667|-120|-180|-240",offsetIndices:"012121212121321212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Jamaica",untils:"-u85og2|wbl182|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|Infinity",offsets:"307.1667|300|240",offsetIndices:"0121212121212121212121"},{id:"Japan",untils:"-bb4900|6uao0|afxc0|8a5c0|c8qo0|6hc00|c8qo0|6hc00|Infinity",offsets:"-540|-600",offsetIndices:"010101010"},{id:"Kwajalein",untils:"-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",offsets:"-660|-600|-540|720|-720",offsetIndices:"012034"},{id:"Libya",untils:"-q3gfrw|gl6ajw|422c0|xado0|4bbo0|wrpg0|4s580|1kdpg0|c05bw0|4mqs0|9et80|9d440|9et80|9eys0|9et80|9mdg0|95jw0|9io40|9cyk0|99es0|9et80|9eys0|9et80|9d440|9et80|b2840|3cf3w0|9kis0|9et80|7vqyw0|75eo0|asw00|Infinity",offsets:"-52.7333|-60|-120",offsetIndices:"012121212121212121212121212122122"},{id:"MET",untils:"-s0e080|7ves0|a4yw0|7x6o0|asw00|7x6o0|b8qdc0|1cm000|7k800|9q000|9d1c0|9d1c0|9d1c0|8l9c0|ggp1c0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-60|-120",offsetIndices:"01010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Mexico/BajaNorte",untils:"-p1u1s0|11jrw0|1sns00|1sgdc0|71s40|9cyk0|5iidg0|1q6700|4lfk0|190g40|eluk0|2r4o80|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|84qys0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|77c40|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"468.0667|420|480",offsetIndices:"012121211212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"Mexico/BajaSur",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|591h80|3ie2s0|axvpg0|dpgw40|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"425.6667|420|360|480",offsetIndices:"0121212131212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Mexico/General",untils:"-p1u4k0|2u7jw0|1sgdc0|8n400|7thc0|9eys0|3knek0|776k0|rf440|5t6k0|1evk40|71mk0|30p1g0|8n180|nufxo0|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|9q2s0|7k580|9q2s0|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|Infinity",offsets:"396.6|420|360|300",offsetIndices:"012121232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"MST",untils:"Infinity",offsets:"420",offsetIndices:"0"},{id:"MST7MDT",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|1tz5k0|2dvo0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Navajo",untils:"-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360",offsetIndices:"01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"NZ-CHAT",untils:"-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-735|-765|-825",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"NZ",untils:"-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-690|-750|-720|-780",offsetIndices:"01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Pacific/Apia",untils:"-usiiv4|kcrmt4|vp3la0|9odo0|902o0|4zbk0|4qog0|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"686.9333|690|660|600|-840|-780",offsetIndices:"01232345454545454545454545454545454545454545454545454545454"},{id:"Pacific/Auckland",untils:"-m01p20|64ak0|biw40|7x5a0|asxe0|7x5a0|asxe0|7x5a0|asxe0|8a3y0|afyq0|8a3y0|afyq0|afvy0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|asum0|7x820|b5ta0|7k9e0|b5ta0|7x820|hsl2m0|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-690|-750|-720|-780",offsetIndices:"01020202020202020202020202023232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Pacific/Bougainville",untils:"-ecsh40|1n05g0|1071c40|Infinity",offsets:"-600|-540|-660",offsetIndices:"0102"},{id:"Pacific/Chatham",untils:"-ciya10|f1tq90|5reo0|clpc0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6uao0|c8qo0|6hc00|b5uo0|8a5c0|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|afxc0|8a5c0|afxc0|8a5c0|afxc0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|8n400|a2yo0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|a2yo0|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|902o0|9q000|9d1c0|9q000|902o0|9q000|902o0|Infinity",offsets:"-735|-765|-825",offsetIndices:"012121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212"},{id:"Pacific/Chuuk",untils:"-su4zs0|29hes0|bkenw0|29fk40|Infinity",offsets:"-600|-540",offsetIndices:"01010"},{id:"Pacific/Easter",untils:"-jhfaew|ivmeuw|7k580|c8tg0|6h980|a31g0|7x3w0|asys0|7x3w0|b5xg0|7k580|ag040|8a2k0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|iq2o0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|9cyk0|9d440|7x3w0|asys0|7x3w0|b5xg0|7k580|9q2s0|8zzw0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|a31g0|9px80|9q2s0|7x3w0|b5xg0|7k580|b5xg0|7k580|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|8n180|a31g0|7x3w0|asys0|8zzw0|9q2s0|ast80|5eis0|cyl80|6hes0|c8nw0|6udg0|bvp80|6udg0|vonw0|4olg0|e1h80|4olg0|e1h80|4olg0|c8nw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|b5rw0|7x9g0|ast80|7x9g0|Infinity",offsets:"437.4667|420|360|300",offsetIndices:"012121212121212121212121212123232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323"},{id:"Pacific/Efate",untils:"-u964i4|11f4ba4|9cyk0|awo40|7tek0|9q2s0|8zzw0|9q2s0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9q2s0|64ak0|e1ms0|4ofw0|Infinity",offsets:"-673.2667|-660|-720",offsetIndices:"0121212121212121212121"},{id:"Pacific/Enderbury",untils:"535io0|7yiqk0|Infinity",offsets:"720|660|-780",offsetIndices:"012"},{id:"Pacific/Fakaofo",untils:"lx0jw0|Infinity",offsets:"660|-780",offsetIndices:"01"},{id:"Pacific/Fiji",untils:"-sa2x4w|17bs00w|64dc0|cyo00|5reo0|53a5c0|64dc0|asw00|6uao0|bvs00|4oio0|e1k00|4oio0|eeio0|4bh80|erk40|3ylc0|erhc0|3ylc0|f4g00|3lmo0|f4g00|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|38o00|fheo0|3lmo0|f4g00|3lmo0|Infinity",offsets:"-715.7333|-720|-780",offsetIndices:"0121212121212121212121212121212121212121212121212121212121212121"},{id:"Pacific/Funafuti",untils:"Infinity",offsets:"-720",offsetIndices:"0"},{id:"Pacific/Galapagos",untils:"-kcr62o|spdryo|3lsas0|3jp80|Infinity",offsets:"358.4|300|360",offsetIndices:"01212"},{id:"Pacific/Gambier",untils:"-tvndoc|Infinity",offsets:"539.8|540",offsetIndices:"01"},{id:"Pacific/Guadalcanal",untils:"-tvowac|Infinity",offsets:"-639.8|-660",offsetIndices:"01"},{id:"Pacific/Guam",untils:"-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",offsets:"-600|-540|-660",offsetIndices:"01020202020202020200"},{id:"Pacific/Honolulu",untils:"-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",offsets:"630|570|600",offsetIndices:"0101102"},{id:"Pacific/Johnston",untils:"-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",offsets:"630|570|600",offsetIndices:"0101102"},{id:"Pacific/Kiritimati",untils:"535eyo|7yirhc|Infinity",offsets:"640|600|-840",offsetIndices:"012"},{id:"Pacific/Kosrae",untils:"-su52k0|29hhk0|9cmd40|27sas0|29fk40|cm2540|f9l3w0|Infinity",offsets:"-660|-540|-600|-720",offsetIndices:"01021030"},{id:"Pacific/Kwajalein",untils:"-h817w0|27sas0|1hjus0|ddxug0|cgv6k0|Infinity",offsets:"-660|-600|-540|720|-720",offsetIndices:"012034"},{id:"Pacific/Majuro",untils:"-su52k0|29hhk0|9cmd40|27sas0|1h6w40|deat40|Infinity",offsets:"-660|-540|-600|-720",offsetIndices:"0102103"},{id:"Pacific/Marquesas",untils:"-tvncu0|Infinity",offsets:"558|570",offsetIndices:"01"},{id:"Pacific/Midway",untils:"-usij20|Infinity",offsets:"682.8|660",offsetIndices:"01"},{id:"Pacific/Nauru",untils:"-pjxiws|ba66ys|1kwca0|hfzda0|Infinity",offsets:"-667.6667|-690|-540|-720",offsetIndices:"01213"},{id:"Pacific/Niue",untils:"-9wyz6o|ehcj4o|Infinity",offsets:"680|690|660",offsetIndices:"012"},{id:"Pacific/Norfolk",untils:"-9x0ps0|cfj8q0|6hc00|l6nk00|239aq0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|Infinity",offsets:"-672|-690|-750|-660|-720",offsetIndices:"012134343434343434343434343434343434343434"},{id:"Pacific/Noumea",untils:"-u9645o|ye0ixo|4dbw0|ecqs0|4f6k0|99p700|4oio0|Infinity",offsets:"-665.8|-660|-720",offsetIndices:"01212121"},{id:"Pacific/Pago_Pago",untils:"-usij20|Infinity",offsets:"682.8|660",offsetIndices:"01"},{id:"Pacific/Palau",untils:"Infinity",offsets:"-540",offsetIndices:"0"},{id:"Pacific/Pitcairn",untils:"es2cy0|Infinity",offsets:"510|480",offsetIndices:"01"},{id:"Pacific/Pohnpei",untils:"-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",offsets:"-660|-540|-600",offsetIndices:"010210"},{id:"Pacific/Ponape",untils:"-su52k0|29hhk0|9cmd40|27sas0|29fk40|Infinity",offsets:"-660|-540|-600",offsetIndices:"010210"},{id:"Pacific/Port_Moresby",untils:"Infinity",offsets:"-600",offsetIndices:"0"},{id:"Pacific/Rarotonga",untils:"4mj960|5rbw0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|c8s20|6u9a0|c8s20|6ham0|c8s20|6ham0|c8s20|6ham0|Infinity",offsets:"630|570|600",offsetIndices:"012121212121212121212121212"},{id:"Pacific/Saipan",untils:"-en8eg0|1dl9g0|7s1k40|txp80|3frms0|qdrpo|7kgac|3ljw0|c8tg0|6u7w0|bvus0|6u7w0|16uo40|3ljw0|16aas0|4ivxo|cls2c|6h980|c65zw0|Infinity",offsets:"-600|-540|-660",offsetIndices:"01020202020202020200"},{id:"Pacific/Samoa",untils:"-usij20|Infinity",offsets:"682.8|660",offsetIndices:"01"},{id:"Pacific/Tahiti",untils:"-tvnayw|Infinity",offsets:"598.2667|600",offsetIndices:"01"},{id:"Pacific/Tarawa",untils:"Infinity",offsets:"-720",offsetIndices:"0"},{id:"Pacific/Tongatapu",untils:"-f4vrlc|uo2edc|8fpc0|bvs00|4bh80|eelg0|4bh80|7pmis0|3lmo0|Infinity",offsets:"-740|-780|-840",offsetIndices:"0121212121"},{id:"Pacific/Truk",untils:"-su4zs0|29hes0|bkenw0|29fk40|Infinity",offsets:"-600|-540",offsetIndices:"01010"},{id:"Pacific/Wake",untils:"Infinity",offsets:"-720",offsetIndices:"0"},{id:"Pacific/Wallis",untils:"Infinity",offsets:"-720",offsetIndices:"0"},{id:"Pacific/Yap",untils:"-su4zs0|29hes0|bkenw0|29fk40|Infinity",offsets:"-600|-540",offsetIndices:"01010"},{id:"Poland",untils:"-se9yk0|dvyc0|7ves0|a4yw0|7x6o0|asw00|7x6o0|aunw0|7x6o0|1evbs0|9fcwc0|18cao0|7k800|9q000|9d1c0|9gnw0|an980|9kd80|8fs40|922w0|ar1c0|7x6o0|a2yo0|8n400|9q000|902o0|4013w0|64dc0|9d1c0|9d1c0|clpc0|6hc00|9d1c0|9d1c0|c8qo0|6hc00|c8qo0|6hc00|c8qo0|6hc00|clpc0|64dc0|6j4tc0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"-84|-60|-120|-180",offsetIndices:"012121223212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"Portugal",untils:"-u9rhc0|2bufw0|6zxg0|66580|bq800|73k00|bodc0|71pc0|bq800|73k00|bq800|71pc0|bq800|1b2g00|9b6o0|saio0|8n400|9q000|902o0|a2yo0|902o0|a2yo0|8n400|st1c0|8n400|9d1c0|9d1c0|sg2o0|9d1c0|902o0|9q000|a2yo0|8n400|9d1c0|9d1c0|902o0|9q000|a2yo0|b5uo0|51hc0|bitc0|9d1c0|9ew00|88ao0|25p80|5reo0|3lpg0|779c0|1sqk0|6uao0|38qs0|6uao0|25p80|6hc00|38qs0|6uao0|25p80|6hc00|38qs0|8a5c0|9d1c0|9d9o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|s3400|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|5gyl40|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d440|9cyk0|9d440|9d1c0|9d1c0|9d1c0|9d1c0|9d440|9cyk0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"36.75|0|-60|-120",offsetIndices:"012121212121212121212121212121212121212121212321232123212321212121212121212121212121212121212121212121212121212121212121212121212122323232212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"PRC",untils:"-qh00w0|8sl80|asbpg0|6w2k0|7ves0|bxjw0|4mqs0|1vduk0|d4as0|75bw0|a31g0|aaak0|9d440|7v980|awo40|1dx80|j9xpo0|6u7w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010"},{id:"PST8PDT",untils:"-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|b9gdg0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"ROC",untils:"-gtzfk0|45slc0|c51c0|75bw0|a31g0|aaak0|9d440|7v980|awo40|7v980|awo40|7v980|awo40|7v980|7tk40|clmk0|7rpg0|b07w0|7rpg0|b07w0|7rpg0|9et80|9eys0|9et80|9d440|9et80|9d440|9et80|9d440|9et80|cjxg0|69uk0|ci2s0|69uk0|6its40|9et80|9d440|9et80|1yf9g0|4qak0|Infinity",offsets:"-480|-540",offsetIndices:"01010101010101010101010101010101010101010"},{id:"ROK",untils:"-w8966g|1yh18g|hkx5a0|1faao0|5cik0|ae5g0|8a2k0|ae5g0|8bx80|c8tg0|6h980|1bj6s0|l3aq0|6j3w0|d2g40|6u7w0|b5xg0|776k0|biw40|776k0|biw40|776k0|biw40|776k0|grs40|dfqxi0|7x6o0|asw00|7x6o0|Infinity",offsets:"-507.8667|-510|-540|-600|-570",offsetIndices:"012232323232141414141414123232"},{id:"Singapore",untils:"-xphpwd|eeb94d|4it32o|8n3jc|1v2p60|iy3o60|Infinity",offsets:"-415.4167|-420|-440|-450|-540|-480",offsetIndices:"0123435"},{id:"Turkey",untils:"-ux9xew|2wvx6w|7v980|1tjc40|aunw0|88dg0|9et80|8yas0|a2vw0|tzpg0|79180|awo40|7v980|7p4040|4zjw0|2vs40|f4d80|9vms0|1u5ek0|c5440|69uk0|acas0|8n180|a31g0|8n180|9q2s0|8zzw0|a31g0|8zzw0|a31g0|8n180|5md9g0|o9zw0|a6qs0|75bw0|4iwyw0|7x6o0|7kas0|b5rw0|75hg0|bkl80|77c40|biqk0|7x9g0|a2vw0|8n6s0|4iqc0|2nkw80|38l80|kdes0|8qtc0|8a5c0|9ew00|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|902o0|9q000|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7kdk0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7m2o0|b4000|7k800|b5uo0|7x6o0|asw00|7z1c0|ar1c0|7x6o0|bitc0|779c0|8fe80|Infinity",offsets:"-116.9333|-120|-180|-240",offsetIndices:"0121212121212121212121212121212121212121212121223212121212121212121212121212121212121212121212121212121212121212122"},{id:"UCT",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"Universal",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"US/Alaska",untils:"-ek1qo0|1tyx80|2e400|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"600|540|480",offsetIndices:"011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"US/Aleutian",untils:"-ek1nw0|1tyug0|2e6s0|b7yik0|12y080|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|1l940|7rs80|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"660|600|540",offsetIndices:"011001010101010101010101010101010111212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121212121"},{id:"US/Arizona",untils:"-r0epo0|ast80|7x9g0|ast80|bmtus0|zjedo|4olg0|9et80|bs6lmc|9cyk0|Infinity",offsets:"420|360",offsetIndices:"01010101010"},{id:"US/Central",untils:"-r0esg0|ast80|7x9g0|ast80|bvus0|776k0|7kas0|b5rw0|9d440|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|7x9g0|dbjw0|8a840|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"US/East-Indiana",untils:"-r0esg0|ast80|7x9g0|ast80|baw840|51ek0|6w840|1tz8c0|2dsw0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|19q7w0|asys0|5qonw0|9cyk0|9d440|9cyk0|ihslg0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300|240",offsetIndices:"010101011010101010101010101010121212121212121212121212121212121212121212121212121212121212121212121"},{id:"US/Eastern",untils:"-r0ev80|ast80|7x9g0|ast80|7x9g0|b5rw0|905g0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|6w840|1tzb40|2dq40|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"300|240",offsetIndices:"01010101010101010101010101010101010101010101010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"US/Hawaii",untils:"-j50la0|13l00|4jvb00|1tyvu0|2e5e0|votg0|Infinity",offsets:"630|570|600",offsetIndices:"0101102"},{id:"US/Indiana-Starke",untils:"-r0esg0|ast80|7x9g0|ast80|bmtus0|1tz8c0|2dsw0|tj1g0|7x3w0|asys0|7x3w0|asys0|7x3w0|b5xg0|7k580|b5xg0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|7x3w0|asys0|9px80|9d440|9cyk0|9d440|7x3w0|asys0|7x3w0|asys0|9cyk0|9d440|9px80|9d440|9cyk0|9d440|s3180|1twas0|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|7j5400|asw00|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"360|300",offsetIndices:"0101011010101010101010101010101010101010101010101010101010101010101010101010101010101010111010101010101010101010101010101010101010101010101010101010101010"},{id:"US/Michigan",untils:"-xx8dyd|5eraud|dyeyk0|1tzb40|2dq40|1c9440|7x3w0|9rlbxo|71s2c|9d440|9cyk0|2cmdg0|9cyk0|3lpg0|f4d80|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"332.1833|360|300|240",offsetIndices:"0123323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232323232"},{id:"US/Mountain",untils:"-r0epo0|ast80|7x9g0|ast80|7x9g0|b5rw0|7kas0|2vmk0|ataw40|1tz5k0|2dvo0|a7n9g0|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"420|360",offsetIndices:"01010101011010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"US/Pacific-New",untils:"-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"US/Pacific",untils:"-r0emw0|ast80|7x9g0|ast80|bmtus0|1tz2s0|2dyg0|1a3c5o|f2iic|owao0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|902o0|9q000|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|9d440|9cyk0|9d440|9cyk0|3lpg0|f4d80|64g40|clmk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|9d440|9px80|905g0|9px80|9d440|9cyk0|9d440|9cyk0|9d440|9cyk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|8a840|afuk0|8a840|afuk0|8a840|ast80|7x9g0|ast80|7x9g0|ast80|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6udg0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|6hes0|c8nw0|Infinity",offsets:"480|420",offsetIndices:"010101101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"US/Samoa",untils:"-usij20|Infinity",offsets:"682.8|660",offsetIndices:"01"},{id:"UTC",untils:"Infinity",offsets:"0",offsetIndices:"0"},{id:"W-SU",untils:"-rx5dmh|ipzua|97hc0|7yyk0|5i840|d9p80|1jwk7|2cvk0|s8o00|1qvw0|8fpc0|1jms0|is040|412as0|qi27w0|9et80|9d440|9et80|9d440|9et80|9eys0|9d6w0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d440|5reo0|3ljw0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|1vbzw0|Infinity",offsets:"-150.2833|-151.3167|-211.3167|-271.3167|-240|-180|-300|-120",offsetIndices:"012132345464575454545454545454545455754545454545454545454545454545454545454545"},{id:"WET",untils:"3s9ms0|902o0|9q000|9d1c0|9d1c0|9d1c0|9q000|902o0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9d1c0|9q000|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|7x6o0|b5uo0|7k800|b5uo0|7k800|b5uo0|7k800|b5uo0|7x6o0|asw00|7x6o0|asw00|Infinity",offsets:"0|-60",offsetIndices:"010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010101010"},{id:"Zulu",untils:"Infinity",offsets:"0",offsetIndices:"0"}]}},41690:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.AdvancedChart=void 0;var i,a=n(20576),o=n(13306),r=n(95479),s=n(35922),l=n(41278),c=n(1939),u=n(19157),d=(i=n(63407))&&i.__esModule?i:{default:i},h=n(21177),f=n(14107);function p(t){return(p="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function g(){return(g=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function m(t,e,n){return(e=function(t){var e=function(t,e){if("object"!==p(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==p(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"===p(e)?e:String(e)}(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}var _=Array.isArray;function v(t){return _(t)?0===t.length?[{}]:t:[t]}function b(t,e,n,i){var a,o;if(n){o=t.value,a={skipEventRising:!0};var r=y(t.fullName,o);r&&(a={allowPartialUpdate:!0},o=r)}else o=((0,s.isDefined)(i)?t.value[i]:t.value).visualRange;e.visualRange(o,a)}function y(t,e){var n=t.split(".").at(-1);if("endValue"===n||"startValue"===n)return m({},n,e)}var x=f.BaseChart.inherit({_fontFields:["".concat("commonAxisSettings",".label.").concat("font"),"".concat("commonAxisSettings",".title.").concat("font")],_partialOptionChangesMap:{visualRange:"VISUAL_RANGE",_customVisualRange:"VISUAL_RANGE",strips:"REFRESH_AXES",constantLines:"REFRESH_AXES"},_partialOptionChangesPath:{argumentAxis:["strips","constantLines","visualRange","_customVisualRange"],valueAxis:["strips","constantLines","visualRange","_customVisualRange"]},_initCore:function(){this._panesClipRects={},this.callBase()},_disposeCore:function(){var t=this._disposeObjectsInArray,e=this._panesClipRects;this.callBase(),t.call(e,"fixed"),t.call(e,"base"),t.call(e,"wide"),this._panesClipRects=null,this._labelsAxesGroup.linkOff(),this._labelsAxesGroup.dispose(),this._labelsAxesGroup=null},_dispose:function(){var t=this._disposeObjectsInArray;this.callBase(),this.panes=null,this._legend&&(this._legend.dispose(),this._legend=null),t.call(this,"panesBackground"),t.call(this,"seriesFamilies"),this._disposeAxes()},_createPanes:function(){this._cleanPanesClipRects("fixed"),this._cleanPanesClipRects("base"),this._cleanPanesClipRects("wide")},_cleanPanesClipRects:function(t){(this._panesClipRects[t]||[]).forEach((function(t){null==t||t.dispose()})),this._panesClipRects[t]=[]},_getElementsClipRectID:function(t){var e=this._panesClipRects.fixed[this._getPaneIndex(t)];return null==e?void 0:e.id},_getPaneIndex:function(t){var e=t||"default";return this.panes.findIndex((function(t){return t.name===e}))},_updateSize:function(){this.callBase(),(0,u.setCanvasValues)(this._canvas)},_reinitAxes:function(){this.panes=this._createPanes(),this._populateAxes(),this._axesReinitialized=!0},_populateAxes:function(){var t,e,n=this,i=this.panes,a=this._isRotated(),o=v(this.option("argumentAxis")||{})[0],r=this.option("valueAxis"),s=v(r||{}),l=[],c=[],d=0,h=this._getCrosshairMargins();function f(){var t="defaultAxisName"+String(d);return d+=1,t}e=a?"right"===o.position?i[i.length-1].name:i[0].name:"top"===o.position?i[0].name:i[i.length-1].name,t=(0,u.map)(i,(function(t){var i=t.name!==e;return n._populateAxesOptions("argumentAxis",o,{pane:t.name,name:null,optionPath:"argumentAxis",crosshairMargin:a?h.x:h.y},a,i)})),s.forEach((function(t,e){var i,o=[],s=t.name;s&&c.includes(s)?n._incidentOccurred("E2102"):(s&&c.push(s),t.pane&&o.push(t.pane),(null===(i=t.panes)||void 0===i?void 0:i.length)&&(o=o.concat(t.panes.slice(0))),(o=(0,u.unique)(o)).length||o.push(void 0),o.forEach((function(i){var o=_(r)?"valueAxis[".concat(String(e),"]"):"valueAxis";l.push(n._populateAxesOptions("valueAxis",t,{name:s||f(),pane:i,priority:e,optionPath:o,crosshairMargin:a?h.y:h.x},a))})))})),this._redesignAxes(t,!0,e),this._redesignAxes(l,!1)},_redesignAxes:function(t,e,n){var i=this,a=[],o=e?this._argumentAxes:this._valueAxes;t.forEach((function(t){var n=null==o?void 0:o.filter((function(e){return e.name===t.name&&(!(0,s.isDefined)(t.pane)&&i.panes.some((function(t){return t.name===e.pane}))||e.pane===t.pane)}));(null==n?void 0:n.length)?n.forEach((function(n){var o=function(t,e,n){if(n)return{argumentAxisType:t.argumentAxisType,argumentType:t.argumentType};var i=t.groups.find((function(t){return t.valueAxis===e}));return{valueAxisType:i.valueAxisType,valueType:i.valueType}}(i._groupsData,n,e);n.updateOptions(t),e?n.setTypes(o.argumentAxisType,o.argumentType,"argumentType"):n.setTypes(o.valueAxisType,o.valueType,"valueType"),n.validate(),a.push({axis:n})})):a.push({options:t})})),o?(0,r.reverseEach)(o,(function(t,n){a.some((function(t){return t.axis&&t.axis===n}))||i._disposeAxis(t,e)})):o=e?this._argumentAxes=[]:this._valueAxes=[],a.forEach((function(t){var a=t.axis;t.axis&&e?t.axis.isVirtual=t.axis.pane!==n:t.options&&(a=i._createAxis(e,t.options,e?t.options.pane!==n:void 0),o.push(a)),a.applyVisualRangeSetter(i._getVisualRangeSetter())}))},_disposeAxis:function(t,e){var n=e?this._argumentAxes:this._valueAxes,i=n[t];i&&(i.dispose(),n.splice(t,1))},_disposeAxes:function(){var t=this._disposeObjectsInArray;t.call(this,"_argumentAxes"),t.call(this,"_valueAxes")},_appendAdditionalSeriesGroups:function(){this._crosshairCursorGroup.linkAppend(),this._scrollBar&&this._scrollBarGroup.linkAppend()},_getLegendTargets:function(){var t=this;return(this.series||[]).map((function(e){var n=t._getLegendOptions(e);return n.legendData.series=e,e.getOptions().showInLegend||(n.legendData.visible=!1),n}))},_legendItemTextField:"name",_seriesPopulatedHandlerCore:function(){this._processSeriesFamilies(),this._processValueAxisFormat()},_renderTrackers:function(){for(var t=0;t<this.series.length;t+=1)this.series[t].drawTrackers()},_specialProcessSeries:function(){this._processSeriesFamilies()},_processSeriesFamilies:function(){var t,e,n=this,i=[],a=[],o=this._themeManager,r=o.getOptions("negativesAsZeroes"),l=o.getOptions("negativesAsZeros"),u={minBubbleSize:o.getOptions("minBubbleSize"),maxBubbleSize:o.getOptions("maxBubbleSize"),barGroupPadding:o.getOptions("barGroupPadding"),barGroupWidth:o.getOptions("barGroupWidth"),negativesAsZeroes:(0,s.isDefined)(r)?r:l};(null===(t=this.seriesFamilies)||void 0===t?void 0:t.length)?this.seriesFamilies.forEach((function(t){t.updateOptions(u),t.adjustSeriesValues()})):(this.series.forEach((function(t){i.includes(t.type)||i.push(t.type)})),this._getLayoutTargets().forEach((function(t){e=n._getSeriesForPane(t.name),i.forEach((function(i){var o=new c.SeriesFamily({type:i,pane:t.name,minBubbleSize:u.minBubbleSize,maxBubbleSize:u.maxBubbleSize,barGroupPadding:u.barGroupPadding,barGroupWidth:u.barGroupWidth,negativesAsZeroes:u.negativesAsZeroes,rotated:n._isRotated()});o.add(e),o.adjustSeriesValues(),a.push(o)}))})),this.seriesFamilies=a)},_updateSeriesDimensions:function(){for(var t=this.seriesFamilies||[],e=0;e<t.length;e+=1){var n=t[e];n.updateSeriesValues(),n.adjustSeriesDimensions()}},_getLegendCallBack:function(t){var e;return null===(e=this._legend)||void 0===e?void 0:e.getActionCallback(t)},_appendAxesGroups:function(){this._stripsGroup.linkAppend(),this._gridGroup.linkAppend(),this._axesGroup.linkAppend(),this._labelsAxesGroup.linkAppend(),this._constantLinesGroup.linkAppend(),this._stripLabelAxesGroup.linkAppend(),this._scaleBreaksGroup.linkAppend()},_populateMarginOptions:function(){var t,e,n,i,a,o,r=this,s=(t=this.getSize(),e=this.panes.length,n=this._themeManager.getOptions("maxBubbleSize"),i=this._isRotated(),a=i?t.width/e:t.width,o=i?t.height:t.height/e,Math.min(a,o)*n),l={};this._valueAxes.forEach((function(t){var e=r.series.filter((function(e){return e.getValueAxis()===t})),n={};e.forEach((function(t){if(t.isVisible()){var e=function(t,e){return t.processBubbleSize&&(t.size=e),t}(t.getMarginOptions(),s);n=(0,u.mergeMarginOptions)(n,e),l=(0,u.mergeMarginOptions)(l,e)}})),t.setMarginOptions(n)})),this._argumentAxes.forEach((function(t){return t.setMarginOptions(l)}))},_populateBusinessRange:function(t,e){var n=this,i=this._isRotated(),a=this._getVisibleSeries(),o={},r=new h.Range({rotated:!!i}),s=function(t){return t.pane||"default"};if(this.panes.forEach((function(t){o[t.name]=new h.Range({rotated:!!i})})),this._valueAxes.forEach((function(r){var l=new h.Range({rotated:!!i,pane:r.pane,axis:r.name}),c=a.filter((function(t){return t.getValueAxis()===r}));c.forEach((function(t){var e=t.getRangeData();l.addRange(e.val),o[s(r)].addRange(e.arg)})),(!t||t&&c.length&&r===t)&&(r.setGroupSeries(c),r.setBusinessRange(l,n._axesReinitialized||e,n._argumentAxes[0]._lastVisualRangeUpdateMode))})),!t||t&&a.length){Object.keys(o).forEach((function(t){return r.addRange(o[t])}));var l=r.interval;this._argumentAxes.forEach((function(t){var e,i=null!==(e=o[s(t)].interval)&&void 0!==e?e:l;t.setBusinessRange(new h.Range(g(g({},r),{interval:i})),n._axesReinitialized,void 0,n._groupsData.categories)}))}this._populateMarginOptions()},getArgumentAxis:function(){return(this._argumentAxes||[]).find((function(t){return!t.isVirtual}))},getValueAxis:function(t){var e=this;return(this._valueAxes||[]).find((0,s.isDefined)(t)?function(e){return e.name===t}:function(t){return t.pane===e.defaultPane})},_getGroupsData:function(){var t=this,e=[];return this._valueAxes.forEach((function(n){e.push({series:t.series.filter((function(t){return t.getValueAxis()===n})),valueAxis:n,valueOptions:n.getOptions()})})),{groups:e,argumentAxes:this._argumentAxes,argumentOptions:this._argumentAxes[0].getOptions()}},_groupSeries:function(){this._correctValueAxes(!1),this._groupsData=this._getGroupsData()},_processValueAxisFormat:function(){var t=[];this.series.forEach((function(e){var n=e.getValueAxis();e.isFullStackedSeries()&&(n.setPercentLabelFormat(),t.push(n))})),this._valueAxes.forEach((function(e){t.includes(e)||e.resetAutoLabelFormat()}))},_populateAxesOptions:function(t,e,n,i,a){var r=this._prepareStripsAndConstantLines(t,e,i),s=(0,o.extend)(!0,{},r,n,this._prepareAxisOptions(t,r,i));return a&&(s.visible=!1,s.tick.visible=!1,s.minorTick.visible=!1,s.label.visible=!1,s.title={}),s},_getValFilter:function(t){return d.default.getViewPortFilter(t.getValueAxis().visualRange()||{})},_createAxis:function(t,e,n){var i=this,a=t?"argumentAxis":"valueAxis",r=(0,o.extend)({renderer:this._renderer,incidentOccurred:this._incidentOccurred,eventTrigger:this._eventTrigger,axisClass:t?"arg":"val",widgetClass:"dxc",stripsGroup:this._stripsGroup,stripLabelAxesGroup:this._stripLabelAxesGroup,constantLinesGroup:this._constantLinesGroup,scaleBreaksGroup:this._scaleBreaksGroup,axesContainerGroup:this._axesGroup,labelsAxesGroup:this._labelsAxesGroup,gridGroup:this._gridGroup,isArgumentAxis:t,getTemplate:function(t){return i._getTemplate(t)}},this._getAxisRenderingOptions(a)),s=new l.Axis(r);return s.updateOptions(e),s.isVirtual=n,s},_applyVisualRangeByVirtualAxes:function(){return!1},_applyCustomVisualRangeOption:function(t,e){t.getOptions().optionPath&&this._parseVisualRangeOption("".concat(t.getOptions().optionPath,".visualRange"),e)},_getVisualRangeSetter:function(){var t=this;return function(e,n){var i=n.skipEventRising,a=n.range;t._applyCustomVisualRangeOption(e,a),e.setCustomVisualRange(a),e.skipEventRising=i,t._applyVisualRangeByVirtualAxes(e,a)||(t._applyingChanges?t._change_VISUAL_RANGE():t._requestChange(["VISUAL_RANGE"]))}},_getTrackerSettings:function(){return(0,o.extend)(this.callBase(),{argumentAxis:this.getArgumentAxis()})},_prepareStripsAndConstantLines:function(t,e,n){return(e=this._themeManager.getOptions(t,e,n)).strips&&e.strips.forEach((function(t,n){e.strips[n]=(0,o.extend)(!0,{},e.stripStyle,t)})),e.constantLines&&e.constantLines.forEach((function(t,n){e.constantLines[n]=(0,o.extend)(!0,{},e.constantLineStyle,t)})),e},refresh:function(){this._disposeAxes(),this.callBase()},_layoutAxes:function(t){t();var e=this.checkForMoreSpaceForPanesCanvas();if(e){var n=this._rect.slice(),i=this._layout.backward(n,n,[e.width,e.height]);e.width=Math.max(0,i[0]),e.height=Math.max(0,i[1]),this._canvas=this._createCanvasFromRect(n),t(e)}},checkForMoreSpaceForPanesCanvas:function(){return this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(),this._isRotated())},_parseVisualRangeOption:function(t,e){var n,i=this,a=t.split(/[.[]/)[0],o=t.match(/\d+/g);o=(0,s.isDefined)(o)?parseInt(o[0],10):o,t.indexOf("visualRange")>0?("object"!==(0,s.type)(e)&&(e=null!==(n=y(t,e))&&void 0!==n?n:e),this._setCustomVisualRange(a,o,e)):("object"===(0,s.type)(e)||_(e))&&a.indexOf("Axis")>0&&JSON.stringify(e).indexOf("visualRange")>0&&((0,s.isDefined)(e.visualRange)?this._setCustomVisualRange(a,o,e.visualRange):_(e)&&e.forEach((function(t,e){(0,s.isDefined)(t.visualRange)&&i._setCustomVisualRange(a,e,t.visualRange)})))},_setCustomVisualRange:function(t,e,n){var i=this._options.silent(t);i&&((0,s.isDefined)(e)?i[e]._customVisualRange=n:i._customVisualRange=n,this._axesReinitialized=!0)},_raiseZoomEndHandlers:function(){this._valueAxes.forEach((function(t){return t.handleZoomEnd()}))},_setOptionsByReference:function(){this.callBase(),(0,o.extend)(this._optionsByReference,{"valueAxis.visualRange":!0})},_notifyOptionChanged:function(t,e){this.callBase.apply(this,arguments),this._optionChangedLocker||this._parseVisualRangeOption(t,e)},_notifyVisualRange:function(){var t=this;this._valueAxes.forEach((function(e){var n=e.getOptions().optionPath;if(n){var i="".concat(n,".visualRange"),a=(0,u.convertVisualRangeObject)(e.visualRange(),!_(t.option(i)));e.skipEventRising&&(0,u.rangesAreEqual)(a,t.option(i))?e.skipEventRising=null:t.option(n)||"valueAxis"===n?t.option(i,a):t.option(n,{name:e.name,visualRange:a})}}))},_notify:function(){this.callBase(),this._axesReinitialized=!1,!0!==this.option("disableTwoWayBinding")&&(this.skipOptionsRollBack=!0,this._notifyVisualRange(),this.skipOptionsRollBack=!1)},_getAxesForScaling:function(){return this._valueAxes},_getAxesByOptionPath:function(t,e,n){var i,a=this._getAxesForScaling(),o=[];e?(t.fullName&&(i=t.fullName.slice(0,t.fullName.indexOf("."))),o=a.filter((function(t){return t.getOptions().optionPath===i}))):"object"===(0,s.type)(t.value)?o=a.filter((function(e){return e.getOptions().optionPath===t.name})):_(t.value)&&t.value.forEach((function(e,i){var r=a.filter((function(e){return e.getOptions().optionPath==="".concat(t.name,"[").concat(i,"]")}))[0];(0,s.isDefined)(e[n])&&(0,s.isDefined)(r)&&(o[i]=r)}));return o},_optionChanged:function(t){if(!this._optionChangedLocker){var e,n=t.fullName.indexOf("visualRange")>0||!(this.getPartialChangeOptionsName(t).indexOf("visualRange")>-1)&&void 0;(0,s.isDefined)(n)&&(e=this._getAxesByOptionPath(t,n,"visualRange"))&&(e.length>1||_(t.value)?e.forEach((function(e,i){return b(t,e,n,i)})):1===e.length&&b(t,e[0],n))}this.callBase(t)},_change_VISUAL_RANGE:function(){if(this._recreateSizeDependentObjects(!1),!this._changes.has("FULL_RENDER")){var t=this.option("resizePanesOnZoom");this._doRender({force:!0,drawTitle:!1,drawLegend:!1,adjustAxes:null!=t?t:this.option("adjustAxesOnZoom")||!1,animate:!1}),this._raiseZoomEndHandlers()}},resetVisualRange:function(){var t=this;this._valueAxes.forEach((function(e){e.resetVisualRange(!1),t._applyCustomVisualRangeOption(e)})),this._requestChange(["VISUAL_RANGE"])},_getCrosshairMargins:function(){return{x:0,y:0}},_legendDataField:"series",_adjustSeriesLabels:a.noop,_correctValueAxes:a.noop});e.AdvancedChart=x},14107:function(t,e,n){function i(t){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}Object.defineProperty(e,"__esModule",{value:!0}),e.overlapping=e.BaseChart=void 0;var a=n(20576),o=n(13306),r=n(95479),s=n(35922),l=C(n(55994)),c=n(39611),u=n(61189),d=function(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==i(t)&&"function"!=typeof t)return{default:t};var n=S(e);if(n&&n.has(t))return n.get(t);var a={},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in t)if("default"!==r&&Object.prototype.hasOwnProperty.call(t,r)){var s=o?Object.getOwnPropertyDescriptor(t,r):null;s&&(s.get||s.set)?Object.defineProperty(a,r,s):a[r]=t[r]}a.default=t,n&&n.set(t,a);return a}(n(19957)),h=n(99327),f=n(45865),p=n(16342),g=n(1539),m=n(82454),_=n(64758),v=n(17384),b=n(14371),y=n(19157),x=n(54932),w=C(n(55845)),k=n(56136);function S(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return(S=function(t){return t?n:e})(t)}function C(t){return t&&t.__esModule?t:{default:t}}var A=Array.isArray,E=["_reinit","_updateDataSource","_dataInit","_forceRender","_resize"];function T(t,e){var n=e.end-e.start,i=0;for(t.forEach((function(t){i+=t.getBoundingRect().width}));n<i;)i-=I(t)}function I(t){var e=t.reduce((function(t,e,n){if(!e)return t;var i=e.value();return i<t.value?{value:i,rollingStock:e,index:n}:t}),{rollingStock:void 0,value:1/0,index:void 0});e.rollingStock.getLabels()[0].draw(!1);var n=e.rollingStock.getBoundingRect().width;return t[e.index]=null,n}function D(t){var e,n,i,a,o=!1;for(e=0,i=t.length-1;e<i;e++){for(n=e+1,a=t.length;n<a;n++)if(e!==n&&O(t[e],t[n],!0)){o=!0;break}if(o)break}return o}function O(t,e,n){if(t&&e){var i=t.getBoundingRect(),a=e.getBoundingRect(),o=!n||(i.oppositeStart<=a.oppositeStart&&i.oppositeEnd>a.oppositeStart||a.oppositeStart<=i.oppositeStart&&a.oppositeEnd>i.oppositeStart);return i.end>a.start&&o}}function L(t){var e=[],n=[];return t.forEach((function(t){t.value()>0?e.push(t):n.unshift(t)})),e.concat(n)}function M(t){for(var e,n=0;n<t.length-1;n+=1){var i=e||t[n];O(i,t[n+1])?(i.toChain(t[n+1]),t[n+1]=null,e=i):e=t[n+1]||i}}function P(t,e){return t.getBoundingRect().end>e.end}function R(t,e){for(var n=0;n<t.length;n+=1){var i=t[n],a=!0;if(null!==i&&P(i,e))for(var o=i.getBoundingRect(),r=n+1;r<t.length;r+=1){var s=t[r];if(s)if(s.getBoundingRect().end>o.start-(o.end-e.end)){s.toChain(i),a=!1;break}}a&&(null==i||i.setRollingStockInCanvas(e))}}var B={resolveLabelOverlappingInOneDirection:function(t,e,n,i,a){var o,r=arguments.length>5&&void 0!==arguments[5]?arguments[5]:function(){return 0},s=[],l={start:n?e.left:e.top,end:n?e.width-e.right:e.height-e.bottom},c=!1;if(t.forEach((function(t){t&&(c=c||t.series.isStackedSeries()||t.series.isFullStackedSeries(),t.getLabels().forEach((function(t){t.isVisible()&&s.push(new k.RollingStock(t,n,a))})))})),c)Number(!n)^Number(i)&&s.reverse(),o=i?s:L(s);else{var u=s.slice();o=s.sort((function(t,e){return r(t,e)||t.getInitialPosition()-e.getInitialPosition()||u.indexOf(t)-u.indexOf(e)}))}return!!D(o)&&(T(o,l),M(o),o.reverse(),R(o,l),!0)}};e.overlapping=B;var z=w.default.inherit({_eventsMap:{onSeriesClick:{name:"seriesClick"},onPointClick:{name:"pointClick"},onArgumentAxisClick:{name:"argumentAxisClick"},onLegendClick:{name:"legendClick"},onSeriesSelectionChanged:{name:"seriesSelectionChanged"},onPointSelectionChanged:{name:"pointSelectionChanged"},onSeriesHoverChanged:{name:"seriesHoverChanged"},onPointHoverChanged:{name:"pointHoverChanged"},onDone:{name:"done",actionSettings:{excludeValidators:["disabled"]}},onZoomStart:{name:"zoomStart"},onZoomEnd:{name:"zoomEnd"}},_fontFields:["legend.".concat("font"),"legend.title.".concat("font"),"legend.title.subtitle.".concat("font"),"commonSeriesSettings.label.".concat("font")],_rootClassPrefix:"dxc",_rootClass:"dxc-chart",_initialChanges:["INIT"],_themeDependentChanges:["REFRESH_SERIES_REINIT"],_getThemeManagerOptions:function(){var t=this.callBase.apply(this,arguments);return t.options=this.option(),t},_createThemeManager:function(){var t=this.option(),e=new h.ThemeManager(this._getThemeManagerOptions());return e.setTheme(t.theme,t.rtlEnabled),e},_initCore:function(){this._canvasClipRect=this._renderer.clipRect(),this._createHtmlStructure(),this._createLegend(),this._createTracker(),this._needHandleRenderComplete=!0,this.layoutManager=new u.LayoutManager,this._createScrollBar(),l.default.on(this._$element,"contextmenu",(function(t){((0,c.isTouchEvent)(t)||(0,c.isPointerEvent)(t))&&t.preventDefault()})),l.default.on(this._$element,"MSHoldVisual",(function(t){t.preventDefault()}))},_getLayoutItems:a.noop,_layoutManagerOptions:function(){return this._themeManager.getOptions("adaptiveLayout")},_reinit:function(){(0,y.setCanvasValues)(this._canvas),this._reinitAxes(),this._requestChange(["DATA_SOURCE","DATA_INIT","CORRECT_AXIS","FULL_RENDER"])},_correctAxes:a.noop,_createHtmlStructure:function(){var t=this,e=this._renderer,n=e.root,i=function(){return e.g().attr({class:"dxc-constant-lines-group"}).linkOn(n,"constant-lines")};this._constantLinesGroup={dispose:function(){this.under.dispose(),this.above.dispose()},linkOff:function(){this.under.linkOff(),this.above.linkOff()},clear:function(){this.under.linkRemove().clear(),this.above.linkRemove().clear()},linkAppend:function(){this.under.linkAppend(),this.above.linkAppend()}},this._labelsAxesGroup=e.g().attr({class:"dxc-elements-axes-group"});var a=function(){t._labelsAxesGroup.linkOn(n,"elements")};this._backgroundRect=e.rect().attr({fill:"gray",opacity:1e-4}).append(n),this._panesBackgroundGroup=e.g().attr({class:"dxc-background"}).append(n),this._stripsGroup=e.g().attr({class:"dxc-strips-group"}).linkOn(n,"strips"),this._gridGroup=e.g().attr({class:"dxc-grids-group"}).linkOn(n,"grids"),this._panesBorderGroup=e.g().attr({class:"dxc-border"}).linkOn(n,"border"),this._axesGroup=e.g().attr({class:"dxc-axes-group"}).linkOn(n,"axes"),this._executeAppendBeforeSeries(a),this._stripLabelAxesGroup=e.g().attr({class:"dxc-strips-labels-group"}).linkOn(n,"strips-labels"),this._constantLinesGroup.under=i(),this._seriesGroup=e.g().attr({class:"dxc-series-group"}).linkOn(n,"series"),this._executeAppendAfterSeries(a),this._constantLinesGroup.above=i(),this._scaleBreaksGroup=e.g().attr({class:"dxc-scale-breaks"}).linkOn(n,"scale-breaks"),this._labelsGroup=e.g().attr({class:"dxc-labels-group"}).linkOn(n,"labels"),this._crosshairCursorGroup=e.g().attr({class:"dxc-crosshair-cursor"}).linkOn(n,"crosshair"),this._legendGroup=e.g().attr({class:"dxc-legend","clip-path":this._getCanvasClipRectID()}).linkOn(n,"legend").linkAppend(n).enableLinks(),this._scrollBarGroup=e.g().attr({class:"dxc-scroll-bar"}).linkOn(n,"scroll-bar")},_executeAppendBeforeSeries:function(){},_executeAppendAfterSeries:function(){},_disposeObjectsInArray:function(t,e){(this[t]||[]).forEach((function(t){e&&t?e.forEach((function(e){var n;null===(n=t[e])||void 0===n||n.dispose()})):null==t||t.dispose()})),this[t]=null},_disposeCore:function(){var t=this,e=function(e){t[e]&&(t[e].dispose(),t[e]=null)},n=function(e){t[e].linkOff()},i=this._disposeObjectsInArray;this._renderer.stopAllAnimations(),i.call(this,"series"),e("_tracker"),e("_crosshair"),this.layoutManager=this._userOptions=this._canvas=this._groupsData=null,n("_stripsGroup"),n("_gridGroup"),n("_axesGroup"),n("_constantLinesGroup"),n("_stripLabelAxesGroup"),n("_panesBorderGroup"),n("_seriesGroup"),n("_labelsGroup"),n("_crosshairCursorGroup"),n("_legendGroup"),n("_scrollBarGroup"),n("_scaleBreaksGroup"),e("_canvasClipRect"),e("_panesBackgroundGroup"),e("_backgroundRect"),e("_stripsGroup"),e("_gridGroup"),e("_axesGroup"),e("_constantLinesGroup"),e("_stripLabelAxesGroup"),e("_panesBorderGroup"),e("_seriesGroup"),e("_labelsGroup"),e("_crosshairCursorGroup"),e("_legendGroup"),e("_scrollBarGroup"),e("_scaleBreaksGroup")},_getAnimationOptions:function(){return this._themeManager.getOptions("animation")},_getDefaultSize:function(){return{width:400,height:400}},_getOption:function(t){return this._themeManager.getOptions(t)},_applySize:function(t){this._rect=t.slice(),this._changes.has("FULL_RENDER")||this._processRefreshData("_resize")},_resize:function(){this._doRender(this.__renderOptions||{animate:!1,isResize:!0})},_trackerType:"ChartTracker",_createTracker:function(){this._tracker=new d[this._trackerType]({seriesGroup:this._seriesGroup,renderer:this._renderer,tooltip:this._tooltip,legend:this._legend,eventTrigger:this._eventTrigger})},_getTrackerSettings:function(){return(0,o.extend)({chart:this},this._getSelectionModes())},_getSelectionModes:function(){var t=this._themeManager;return{seriesSelectionMode:t.getOptions("seriesSelectionMode"),pointSelectionMode:t.getOptions("pointSelectionMode")}},_updateTracker:function(t){this._tracker.update(this._getTrackerSettings()),this._tracker.setCanvases({left:0,right:this._canvas.width,top:0,bottom:this._canvas.height},t)},_createCanvasFromRect:function(t){var e=this._canvas;return(0,y.setCanvasValues)({left:t[0],top:t[1],right:e.width-t[2],bottom:e.height-t[3],width:e.width,height:e.height})},_doRender:function(t){if(0!==this._canvas.width||0!==this._canvas.height){this._resetIsReady();var e=this._prepareDrawOptions(t),n=e.recreateCanvas;this._preserveOriginalCanvas(),n?this.__currentCanvas=this._canvas:this._canvas=this.__currentCanvas,n&&this._updateCanvasClipRect(this._canvas),this._canvas=this._createCanvasFromRect(this._rect),this._renderer.stopAllAnimations(!0),this._cleanGroups();var i=new Date;this._renderElements(e),this._lastRenderingTime=Number(new Date)-Number(i)}},_preserveOriginalCanvas:function(){this.__originalCanvas=this._canvas,this._canvas=(0,o.extend)({},this._canvas)},_layoutAxes:a.noop,_renderElements:function(t){var e,n,i,a=this,r=this._prepareToRender(t),s=this._isRotated(),l=this._isLegendInside(),c=[];(0,o.extend)({},this._canvas);this._renderer.lock(),t.drawLegend&&this._legend&&this._legendGroup.linkAppend(),this.layoutManager.setOptions(this._layoutManagerOptions());var u=this._getLayoutTargets();this._layoutAxes((function(e){var n=e?(0,o.extend)({},t,{animate:!1,recreateCanvas:!0}):t,i=a._renderAxes(n,r);a._shrinkAxes(e,i)})),this._applyClipRects(r),this._appendSeriesGroups(),this._createCrosshairCursor(),u.forEach((function(t){var e=t.canvas;c.push({left:e.left,right:e.width-e.right,top:e.top,bottom:e.height-e.bottom})})),this._scrollBar&&("discrete"===(e=this._argumentAxes[0].getTranslator().getBusinessRange()).axisType&&e.categories&&e.categories.length<=1||"discrete"!==e.axisType&&e.min===e.max?n=i=void 0:(n=e.minVisible,i=e.maxVisible),this._scrollBar.init(e,!this._argumentAxes[0].getOptions().valueMarginsEnabled).setPosition(n,i)),this._updateTracker(c),this._updateLegendPosition(t,l),this._applyPointMarkersAutoHiding(),this._renderSeries(t,s,l),this._renderGraphicObjects(),this._renderer.unlock()},_updateLegendPosition:a.noop,_createCrosshairCursor:a.noop,_appendSeriesGroups:function(){this._seriesGroup.linkAppend(),this._labelsGroup.linkAppend(),this._appendAdditionalSeriesGroups()},_renderSeries:function(t,e,n){this._calculateSeriesLayout(t,e),this._renderSeriesElements(t,n)},_calculateSeriesLayout:function(t,e){t.hideLayoutLabels=this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(),e)&&!this._themeManager.getOptions("adaptiveLayout").keepLabels,this._updateSeriesDimensions(t)},_getArgFilter:function(){return function(){return!0}},_getValFilter:function(){return function(){return!0}},_getPointsToAnimation:function(t){var e=this,n=this._getArgFilter();return t.map((function(t){var i=e._getValFilter(t);return t.getPoints().filter((function(t){return t.getOptions().visible&&n(t.argument)&&(i(t.getMinValue(!0))||i(t.getMaxValue(!0)))})).length}))},_renderSeriesElements:function(t,e){var n=this,i=this.series,a=this._themeManager.getOptions("resolveLabelOverlapping"),o=this._getPointsToAnimation(i);i.forEach((function(e,i){n._applyExtraSettings(e,t);var a=t.animate&&o[i]<=t.animationPointsLimit&&n._renderer.animationEnabled();e.draw(a,t.hideLayoutLabels,n._getLegendCallBack(e))})),"none"===a?this._adjustSeriesLabels(!1):this._locateLabels(a),this._renderTrackers(e),this._tracker.repairTooltip(),this._renderExtraElements(),this._clearCanvas(),this._seriesElementsDrawn=!0},_changesApplied:function(){this._seriesElementsDrawn&&(this._seriesElementsDrawn=!1,this._drawn(),this._renderCompleteHandler())},_locateLabels:function(t){this._resolveLabelOverlapping(t)},_renderExtraElements:function(){},_clearCanvas:function(){this._canvas=this.__originalCanvas},_resolveLabelOverlapping:function(t){var e;switch(t){case"stack":e=this._resolveLabelOverlappingStack;break;case"hide":e=this._resolveLabelOverlappingHide;break;case"shift":e=this._resolveLabelOverlappingShift}return(0,s.isFunction)(e)&&e.call(this)},_getVisibleSeries:function(){return(0,a.grep)(this.getAllSeries(),(function(t){return t.isVisible()}))},_resolveLabelOverlappingHide:function(){var t,e,n,i,a,o,r,s,l,c=[],u=this._getVisibleSeries();for(a=0;a<u.length;a++)for(r=u[a].getVisiblePoints(),o=0;o<r.length;o++)c.push.apply(c,r[o].getLabels());for(a=0;a<c.length;a++)if((t=c[a]).isVisible())for(n=t.getBoundingRect(),o=a+1;o<c.length;o++)i=(e=c[o]).getBoundingRect(),l=i,((s=n).x<=l.x&&l.x<=s.x+s.width||s.x>=l.x&&s.x<=l.x+l.width)&&(s.y<=l.y&&l.y<=s.y+s.height||s.y>=l.y&&s.y<=l.y+l.height)&&e.draw(!1)},_cleanGroups:function(){this._stripsGroup.linkRemove().clear(),this._gridGroup.linkRemove().clear(),this._axesGroup.linkRemove().clear(),this._constantLinesGroup.clear(),this._stripLabelAxesGroup.linkRemove().clear(),this._labelsGroup.linkRemove().clear(),this._crosshairCursorGroup.linkRemove().clear(),this._scaleBreaksGroup.linkRemove().clear()},_allowLegendInsidePosition:function(){return!1},_createLegend:function(){var t,e,n,i=(t=this._legendDataField,{getFormatObject:function(t){var e={};return e[n.indexField]=t.id,e[n.colorField]=t.states.normal.fill,e[n.nameField]=t.text,e},textField:(n={nameField:"".concat(e=t,"Name"),colorField:"".concat(e,"Color"),indexField:"".concat(e,"Index")}).nameField});this._legend=new p.Legend({renderer:this._renderer,widget:this,group:this._legendGroup,backgroundClass:"dxc-border",itemGroupClass:"dxc-item",titleGroupClass:"dxc-title",textField:i.textField,getFormatObject:i.getFormatObject,allowInsidePosition:this._allowLegendInsidePosition()}),this._updateLegend(),this._layout.add(this._legend)},_updateLegend:function(){var t=this._themeManager,e=t.getOptions("legend"),n=this._getLegendData();e.containerBackgroundColor=t.getOptions("containerBackgroundColor"),e._incidentOccurred=this._incidentOccurred,this._legend.update(n,e,t.theme("legend").title),this._change(["LAYOUT"])},_prepareDrawOptions:function(t){var e=this._getAnimationOptions(),n=(0,o.extend)({},{force:!1,adjustAxes:!0,drawLegend:!0,drawTitle:!0,animate:e.enabled,animationPointsLimit:e.maxPointCountSupported},t,this.__renderOptions);return(0,s.isDefined)(n.recreateCanvas)||(n.recreateCanvas=n.adjustAxes&&n.drawLegend&&n.drawTitle),n},_processRefreshData:function(t){var e=E.indexOf(this._currentRefreshData),n=E.indexOf(t);(!this._currentRefreshData||e>=0&&n<e)&&(this._currentRefreshData=t),this._requestChange(["REFRESH"])},_getLegendData:function(){return(0,y.map)(this._getLegendTargets(),(function(t){var e=t.legendData,n=t.getLegendStyles,i=n.normal.opacity;t.visible||((!(0,s.isDefined)(i)||i>.3)&&(i=.3),e.textOpacity=.3);var a={opacity:i};return e.states={hover:(0,o.extend)({},n.hover,a),selection:(0,o.extend)({},n.selection,a),normal:(0,o.extend)({},n.normal,a)},e}))},_getLegendOptions:function(t){return{legendData:{text:t[this._legendItemTextField],id:t.index,visible:!0},getLegendStyles:t.getLegendStyles(),visible:t.isVisible()}},_disposeSeries:function(t){var e;this.series&&((0,s.isDefined)(t)?(this.series[t].dispose(),this.series.splice(t,1)):(this.series.forEach((function(t){return t.dispose()})),this.series.length=0)),(null===(e=this.series)||void 0===e?void 0:e.length)||(this.series=[])},_disposeSeriesFamilies:function(){(this.seriesFamilies||[]).forEach((function(t){t.dispose()})),this.seriesFamilies=null,this._needHandleRenderComplete=!0},_optionChanged:function(t){this._themeManager.resetOptions(t.name),this.callBase.apply(this,arguments)},_applyChanges:function(){this._themeManager.update(this._options.silent()),this.callBase.apply(this,arguments)},_optionChangesMap:{animation:"ANIMATION",dataSource:"DATA_SOURCE",palette:"PALETTE",paletteExtensionMode:"PALETTE",legend:"FORCE_DATA_INIT",seriesTemplate:"FORCE_DATA_INIT",export:"FORCE_RENDER",valueAxis:"AXES_AND_PANES",argumentAxis:"AXES_AND_PANES",commonAxisSettings:"AXES_AND_PANES",panes:"AXES_AND_PANES",commonPaneSettings:"AXES_AND_PANES",defaultPane:"AXES_AND_PANES",containerBackgroundColor:"AXES_AND_PANES",rotated:"ROTATED",autoHidePointMarkers:"REFRESH_SERIES_REINIT",customizePoint:"REFRESH_SERIES_REINIT",customizeLabel:"REFRESH_SERIES_REINIT",scrollBar:"SCROLL_BAR"},_optionChangesOrder:["ROTATED","PALETTE","REFRESH_SERIES_REINIT","USE_SPIDER_WEB","AXES_AND_PANES","INIT","REINIT","DATA_SOURCE","REFRESH_SERIES_DATA_INIT","DATA_INIT","FORCE_DATA_INIT","REFRESH_AXES","CORRECT_AXIS"],_customChangesOrder:["ANIMATION","REFRESH_SERIES_FAMILIES","FORCE_FIRST_DRAWING","FORCE_DRAWING","FORCE_RENDER","VISUAL_RANGE","SCROLL_BAR","REINIT","REFRESH","FULL_RENDER"],_change_ANIMATION:function(){this._renderer.updateAnimationOptions(this._getAnimationOptions())},_change_DATA_SOURCE:function(){this._needHandleRenderComplete=!0,this._updateDataSource()},_change_PALETTE:function(){this._themeManager.updatePalette(),this._refreshSeries("DATA_INIT")},_change_REFRESH_SERIES_DATA_INIT:function(){this._refreshSeries("DATA_INIT")},_change_DATA_INIT:function(){this.series&&!this.needToPopulateSeries||this._changes.has("FORCE_DATA_INIT")||this._dataInit()},_change_FORCE_DATA_INIT:function(){this._dataInit()},_change_REFRESH_SERIES_FAMILIES:function(){this._processSeriesFamilies(),this._populateBusinessRange(),this._processRefreshData("_forceRender")},_change_FORCE_RENDER:function(){this._processRefreshData("_forceRender")},_change_AXES_AND_PANES:function(){this._refreshSeries("INIT")},_change_ROTATED:function(){this._createScrollBar(),this._refreshSeries("INIT")},_change_REFRESH_SERIES_REINIT:function(){this._refreshSeries("INIT")},_change_REFRESH_AXES:function(){(0,y.setCanvasValues)(this._canvas),this._reinitAxes(),this._requestChange(["CORRECT_AXIS","FULL_RENDER"])},_change_SCROLL_BAR:function(){this._createScrollBar(),this._processRefreshData("_forceRender")},_change_REINIT:function(){this._processRefreshData("_reinit")},_change_FORCE_DRAWING:function(){this._resetComponentsAnimation()},_change_FORCE_FIRST_DRAWING:function(){this._resetComponentsAnimation(!0)},_resetComponentsAnimation:function(t){this.series.forEach((function(e){e.resetApplyingAnimation(t)})),this._resetAxesAnimation(t)},_resetAxesAnimation:a.noop,_refreshSeries:function(t){this.needToPopulateSeries=!0,this._requestChange([t])},_change_CORRECT_AXIS:function(){this._correctAxes()},_doRefresh:function(){var t=this._currentRefreshData;t&&(this._currentRefreshData=null,this._renderer.stopAllAnimations(!0),this[t]())},_updateCanvasClipRect:function(t){var e=Math.max(t.width-t.left-t.right,0),n=Math.max(t.height-t.top-t.bottom,0);this._canvasClipRect.attr({x:t.left,y:t.top,width:e,height:n}),this._backgroundRect.attr({x:t.left,y:t.top,width:e,height:n})},_getCanvasClipRectID:function(){return this._canvasClipRect.id},_dataSourceChangedHandler:function(){this._changes.has("INIT")?this._requestChange(["DATA_INIT"]):this._requestChange(["FORCE_DATA_INIT"])},_dataInit:function(){this._dataSpecificInit(!0)},_processSingleSeries:function(t){t.createPoints(!1)},_handleSeriesDataUpdated:function(){var t=this;this._getVisibleSeries().some((function(t){return t.useAggregation()}))&&this._populateMarginOptions(),this.series.forEach((function(e){return t._processSingleSeries(e)}),this)},_dataSpecificInit:function(t){this.series&&!this.needToPopulateSeries||(this.series=this._populateSeries()),this._repopulateSeries(),this._seriesPopulatedHandlerCore(),this._populateBusinessRange(),this._tracker.updateSeries(this.series,this._changes.has("INIT")),this._updateLegend(),t&&this._requestChange(["FULL_RENDER"])},_forceRender:function(){this._doRender({force:!0})},_repopulateSeries:function(){var t=this._themeManager,e=this._dataSourceItems(),n=t.getOptions("dataPrepareSettings");t.getOptions("seriesTemplate")&&this._populateSeries(e),this._groupSeries();var i=(0,f.validateData)(e,this._groupsData,this._incidentOccurred,n);t.resetPalette(),this.series.forEach((function(t){t.updateData(i[t.getArgumentField()])})),this._handleSeriesDataUpdated()},_renderCompleteHandler:function(){var t=!0;this._needHandleRenderComplete&&(this.series.forEach((function(e){t=t&&e.canRenderCompleteHandle()})),t&&(this._needHandleRenderComplete=!1,this._eventTrigger("done",{target:this})))},_dataIsReady:function(){return(0,s.isDefined)(this.option("dataSource"))&&this._dataIsLoaded()},_populateSeriesOptions:function(t){for(var e,n,i=this,a=this._themeManager,r=a.getOptions("seriesTemplate"),l=r?(0,y.processSeriesTemplate)(r,t||[]):this.option("series"),c=A(l)?l:l?[l]:[],u=this._getExtraOptions(),d=[],h=function(t){i._specialProcessSeries(),i._populateBusinessRange(t&&t.getValueAxis(),!0),i._renderer.stopAllAnimations(!0),i._updateLegend(),i._requestChange(["FULL_RENDER"])},f=0;f<c.length;f++)e=(0,o.extend)(!0,{},c[f],u),(0,s.isDefined)(e.name)&&""!==e.name||(e.name="Series ".concat((f+1).toString())),e.rotated=this._isRotated(),e.customizePoint=a.getOptions("customizePoint"),e.customizeLabel=a.getOptions("customizeLabel"),e.visibilityChanged=h,e.incidentOccurred=this._incidentOccurred,n=a.getOptions("series",e,c.length),this._checkPaneName(n)&&d.push(n);return d},_populateSeries:function(t){var e,n,i=this,a=[],s=this._incidentOccurred,l=this._populateSeriesOptions(t),c=!1;this.needToPopulateSeries=!1,l.forEach((function(t){var e,n=null===(e=i.series)||void 0===e?void 0:e.find((function(e){return e.name===t.name&&!a.map((function(t){return t.series})).includes(e)}));n&&n.type===t.type?a.push({series:n,options:t}):(a.push({options:t}),c=!0)})),0!==(null===(e=this.series)||void 0===e?void 0:e.length)&&this._tracker.clearHover(),(0,r.reverseEach)(this.series,(function(t,e){a.some((function(t){return e===t.series}))||(i._disposeSeries(t),c=!0)})),!c&&(c=a.some((function(t){return t.series.name!==l[t.series.index].name}))),this.series=[],c&&this._disposeSeriesFamilies(),this._themeManager.resetPalette();var u=function(t){i.series.forEach((function(e){e.notify(t)}))};return a.forEach((function(t){var e,a,r=t.options,l=null!==(a=null===(e=i._argumentAxes)||void 0===e?void 0:e.filter((function(t){return t.pane===r.pane}))[0])&&void 0!==a?a:i.getArgumentAxis(),c={commonSeriesModes:i._getSelectionModes(),argumentAxis:l,valueAxis:i._getValueAxis(r.pane,r.axis)};t.series?(n=t.series).updateOptions(r,c):n=new x.Series((0,o.extend)({renderer:i._renderer,seriesGroup:i._seriesGroup,labelsGroup:i._labelsGroup,eventTrigger:i._eventTrigger,eventPipe:u,incidentOccurred:s},c),r),n.isUpdated?(n.index=i.series.length,i.series.push(n)):s("E2101",[r.type])})),this.series},getStackedPoints:function(t){var e=t.series.getStackName();return this._getVisibleSeries().reduce((function(n,i){return(0,s.isDefined)(i.getStackName())&&(0,s.isDefined)(e)&&e!==i.getStackName()||(n=n.concat(i.getPointsByArg(t.argument))),n}),[])},getAllSeries:function(){return(this.series||[]).slice()},getSeriesByName:function(t){return(this.series||[]).find((function(e){return e.name===t}))||null},getSeriesByPos:function(t){return(this.series||[])[t]},clearSelection:function(){this._tracker.clearSelection()},hideTooltip:function(){this._tracker._hideTooltip()},clearHover:function(){this._tracker.clearHover()},render:function(t){return this.__renderOptions=t,this.__forceRender=t&&t.force,this.callBase.apply(this,arguments),this.__renderOptions=this.__forceRender=null,this},refresh:function(){this._disposeSeries(),this._disposeSeriesFamilies(),this._requestChange(["CONTAINER_SIZE","REFRESH_SERIES_REINIT"])},_getMinSize:function(){var t=this._layoutManagerOptions();return[t.width,t.height]},_change_REFRESH:function(){this._changes.has("INIT")?this._currentRefreshData=null:this._doRefresh()},_change_FULL_RENDER:function(){this._forceRender()},_change_INIT:function(){this._reinit()},_stopCurrentHandling:function(){this._tracker.stopCurrentHandling()}});e.BaseChart=z,["series","commonSeriesSettings","dataPrepareSettings","seriesSelectionMode","pointSelectionMode","synchronizeMultiAxes","resolveLabelsOverlapping"].forEach((function(t){z.prototype._optionChangesMap[t]="REFRESH_SERIES_DATA_INIT"})),["adaptiveLayout","crosshair","resolveLabelOverlapping","adjustOnZoom","stickyHovering"].forEach((function(t){z.prototype._optionChangesMap[t]="FORCE_RENDER"})),["minBubbleSize","maxBubbleSize","barGroupPadding","barGroupWidth","negativesAsZeroes","negativesAsZeros"].forEach((function(t){z.prototype._optionChangesMap[t]="REFRESH_SERIES_FAMILIES"})),z.addPlugin(m.plugin),z.addPlugin(v.plugin),z.addPlugin(g.plugin),z.addPlugin(b.plugin),z.addPlugin(_.plugin);var q=z.prototype._change_TITLE;z.prototype._change_TITLE=function(){q.apply(this,arguments),this._change(["FORCE_RENDER"])}},56136:function(t,e){Object.defineProperty(e,"__esModule",{value:!0}),e.RollingStock=void 0;var n=function(){function t(t,e,n){var i=t.getBoundingRect(),a=i.x,o=i.y,r=i.x+i.width,s=i.y+i.height;this.labels=[t],this.shiftFunction=n,this.bBox={start:e?a:o,width:e?i.width:i.height,end:e?r:s,oppositeStart:e?o:a,oppositeEnd:e?s:r},this.initialPosition=e?i.x:i.y}var e=t.prototype;return e.toChain=function(t){var e=t.getBoundingRect();t.shift(e.start-this.bBox.end),this.changeBoxWidth(e.width),this.labels=this.labels.concat(t.labels)},e.getBoundingRect=function(){return this.bBox},e.shift=function(t){var e=this;this.labels.forEach((function(n){var i=n.getBoundingRect(),a=e.shiftFunction(i,t);n.hideInsideLabel(a)||n.shift(a.x,a.y)})),this.bBox.end-=t,this.bBox.start-=t},e.setRollingStockInCanvas=function(t){this.bBox.end>t.end&&this.shift(this.bBox.end-t.end)},e.getLabels=function(){return this.labels},e.value=function(){return this.labels[0].getData().value},e.getInitialPosition=function(){return this.initialPosition},e.changeBoxWidth=function(t){this.bBox.end+=t,this.bBox.width+=t},t}();e.RollingStock=n},55845:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=k(n(20530)),a=k(n(73349)),o=k(n(13046)),r=k(n(68374)),s=n(20576),l=n(62754),c=n(13306),u=n(95479),d=n(58664),h=n(35922),f=n(58201),p=k(n(55994)),g=n(43637),m=n(98469),_=k(n(80726)),v=n(3603),b=k(n(94551)),y=n(56453),x=n(19157),w=k(n(66798));function k(t){return t&&t.__esModule?t:{default:t}}function S(){return(S=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var C=Math.floor,A=_.default.log,E=o.default.prototype.option;function T(){return!0}function I(){return!1}function D(t){t.component._eventsStrategy.hasEvent("incidentOccurred")||A.apply(null,[t.target.id].concat(t.target.args||[]))}function O(t){return t.reduce((function(t,e){return e>0&&!t?e:t}),0)}function L(t){t.forEach((function(t){return t()}))}function M(t){return S(S({},t),{height:C(t.height),width:C(t.width)})}var P,R,B,z=!(0,f.hasWindow)()?(P={_initTemplates:function(){},ctor:function(t,e){this.callBase(t,e);var n=a.default.createElement("div"),i=e&&(0,h.isNumeric)(e.width)?"".concat(e.width,"px"):"100%",o=e&&(0,h.isNumeric)(e.height)?"".concat(e.height,"px"):"".concat(this._getDefaultSize().height,"px");a.default.setStyle(n,"width",i),a.default.setStyle(n,"height",o),a.default.setClass(n,"dx-sized-element",!1),a.default.insertElement(t,n)}},R=o.default.inherit(P),B=R.inherit,R.inherit=function(t){return Object.keys(t).forEach((function(e){((0,h.isFunction)(t[e])&&"_"!==e.substr(0,1)&&"option"!==e||"_dispose"===e||"_optionChanged"===e)&&(t[e]=s.noop)})),B.call(this,t)},R):o.default.inherit({_eventsMap:{onIncidentOccurred:{name:"incidentOccurred",actionSettings:{excludeValidators:["disabled"]}},onDrawn:{name:"drawn",actionSettings:{excludeValidators:["disabled"]}}},_getDefaultOptions:function(){return(0,c.extend)(this.callBase(),{onIncidentOccurred:D})},_useLinks:!0,_init:function(){var t=this;this._$element.children(".".concat("dx-sized-element")).remove(),this._graphicObjects={},this.callBase.apply(this,arguments),this._changesLocker=0,this._optionChangedLocker=0,this._asyncFirstDrawing=!0,this._changes=(0,v.changes)(),this._suspendChanges(),this._themeManager=this._createThemeManager(),this._themeManager.setCallback((function(){t._requestChange(t._themeDependentChanges)})),this._renderElementAttributes(),this._initRenderer();var e=this._useLinks;e&&this._renderer.root.enableLinks().virtualLink("core").virtualLink("peripheral"),this._renderVisibilityChange(),this._attachVisibilityChangeHandlers(),this._toggleParentsScrollSubscription(this._isVisible()),this._initEventTrigger(),this._incidentOccurred=(0,m.createIncidentOccurred)(this.NAME,this._eventTrigger),this._layout=new b.default,e&&this._renderer.root.linkAfter("core"),this._initPlugins(),this._initCore(),e&&this._renderer.root.linkAfter(),this._change(this._initialChanges)},_createThemeManager:function(){return new g.BaseThemeManager(this._getThemeManagerOptions())},_getThemeManagerOptions:function(){return{themeSection:this._themeSection,fontFields:this._fontFields}},_initialChanges:["LAYOUT","RESIZE_HANDLER","THEME","DISABLED"],_initPlugins:function(){var t=this;(0,u.each)(this._plugins,(function(e,n){n.init.call(t)}))},_disposePlugins:function(){var t=this;(0,u.each)(this._plugins.slice().reverse(),(function(e,n){n.dispose.call(t)}))},_change:function(t){this._changes.add(t)},_suspendChanges:function(){this._changesLocker+=1},_resumeChanges:function(){0==--this._changesLocker&&this._changes.count()>0&&!this._applyingChanges&&(this._renderer.lock(),this._applyingChanges=!0,this._applyChanges(),this._changes.reset(),this._applyingChanges=!1,this._changesApplied(),this._renderer.unlock(),this._optionsQueue&&this._applyQueuedOptions(),this.resolveItemsDeferred(this._legend?[this._legend]:[]),this._optionChangedLocker+=1,this._notify(),this._optionChangedLocker-=1)},resolveItemsDeferred:function(t){this._resolveDeferred(this._getTemplatesItems(t))},_collectTemplatesFromItems:function(t){return t.reduce((function(t,e){return{items:t.items.concat(e.getTemplatesDef()),groups:t.groups.concat(e.getTemplatesGroups())}}),{items:[],groups:[]})},_getTemplatesItems:function(t){var e=this._collectTemplatesFromItems(t),n=this._getExtraTemplatesItems();return{items:n.items.concat(e.items),groups:n.groups.concat(e.groups),launchRequest:[n.launchRequest],doneRequest:[n.doneRequest]}},_getExtraTemplatesItems:function(){return{items:[],groups:[],launchRequest:function(){},doneRequest:function(){}}},_resolveDeferred:function(t){var e=this,n=t.items,i=t.launchRequest,a=t.doneRequest,o=t.groups;if(this._setGroupsVisibility(o,"hidden"),this._changesApplying)return this._changesApplying=!1,void L(a);var r=!0;l.when.apply(this,n).done((function(){if(r)e._setGroupsVisibility(o,"visible");else{L(i),e._changesApplying=!0;var t=["LAYOUT","FULL_RENDER"];e._asyncFirstDrawing?(t.push("FORCE_FIRST_DRAWING"),e._asyncFirstDrawing=!1):t.push("FORCE_DRAWING"),e._requestChange(t),e._setGroupsVisibility(o,"visible")}})),r=!1},_setGroupsVisibility:function(t,e){t.forEach((function(t){return t.attr({visibility:e})}))},_applyQueuedOptions:function(){var t=this._optionsQueue;this._optionsQueue=null,this.beginUpdate(),(0,u.each)(t,(function(t,e){e()})),this.endUpdate()},_requestChange:function(t){this._suspendChanges(),this._change(t),this._resumeChanges()},_applyChanges:function(){for(var t=this._changes,e=this._totalChangesOrder,n=e.length,i=0;i<n;i+=1)t.has(e[i])&&this["_change_".concat(e[i])]()},_optionChangesOrder:["EVENTS","THEME","RENDERER","RESIZE_HANDLER"],_layoutChangesOrder:["ELEMENT_ATTR","CONTAINER_SIZE","LAYOUT"],_customChangesOrder:["DISABLED"],_change_EVENTS:function(){this._eventTrigger.applyChanges()},_change_THEME:function(){this._setThemeAndRtl()},_change_RENDERER:function(){this._setRendererOptions()},_change_RESIZE_HANDLER:function(){this._setupResizeHandler()},_change_ELEMENT_ATTR:function(){this._renderElementAttributes(),this._change(["CONTAINER_SIZE"])},_change_CONTAINER_SIZE:function(){this._updateSize()},_change_LAYOUT:function(){this._setContentSize()},_change_DISABLED:function(){var t=this._renderer,e=t.root;this.option("disabled")?(this._initDisabledState=e.attr("pointer-events"),e.attr({"pointer-events":"none",filter:t.getGrayScaleFilter().id})):"none"===e.attr("pointer-events")&&e.attr({"pointer-events":(0,h.isDefined)(this._initDisabledState)?this._initDisabledState:null,filter:null})},_themeDependentChanges:["RENDERER"],_initRenderer:function(){var t=this._calculateRawCanvas();this._canvas=M(t),this._renderer=new y.Renderer({cssClass:"".concat(this._rootClassPrefix," ").concat(this._rootClass),pathModified:this.option("pathModified"),container:this._$element[0]}),this._renderer.resize(this._canvas.width,this._canvas.height)},_disposeRenderer:function(){this._renderer.dispose()},_disposeGraphicObjects:function(){var t=this;Object.keys(this._graphicObjects).forEach((function(e){t._graphicObjects[e].dispose()})),this._graphicObjects=null},_getAnimationOptions:s.noop,render:function(){this._requestChange(["CONTAINER_SIZE"]);var t=this._isVisible();this._toggleParentsScrollSubscription(t),!t&&this._stopCurrentHandling()},_toggleParentsScrollSubscription:function(t){var e=(0,r.default)(this._renderer.root.element).parents();"generic"===i.default.real().platform&&(e=e.add((0,f.getWindow)())),this._proxiedTargetParentsScrollHandler=this._proxiedTargetParentsScrollHandler||function(){this._stopCurrentHandling()}.bind(this),p.default.off((0,r.default)("").add(this._$prevRootParents),"scroll.viz_widgets",this._proxiedTargetParentsScrollHandler),t&&(p.default.on(e,"scroll.viz_widgets",this._proxiedTargetParentsScrollHandler),this._$prevRootParents=e)},_stopCurrentHandling:s.noop,_dispose:function(){this._disposed||(this.callBase.apply(this,arguments),this._toggleParentsScrollSubscription(!1),this._removeResizeHandler(),this._layout.dispose(),this._eventTrigger.dispose(),this._disposeCore(),this._disposePlugins(),this._disposeGraphicObjects(),this._disposeRenderer(),this._themeManager.dispose(),this._themeManager=null,this._renderer=null,this._eventTrigger=null)},_initEventTrigger:function(){var t=this;this._eventTrigger=(0,m.createEventTrigger)(this._eventsMap,(function(e,n){return t._createActionByOption(e,n)}))},_calculateRawCanvas:function(){var t=this,e=this.option("size")||{},n=this.option("margin")||{},i=this._getDefaultSize()||{},a=function(e,n,i){if(a=e[n],(0,h.isDefined)(a)&&a>0||!(0,f.hasWindow)())return 0;var a,o=i(t._$element);return o<=1?0:o},o=a(e,"width",(function(t){return(0,d.getWidth)(t)})),r=a(e,"height",(function(t){return(0,d.getHeight)(t)})),s={width:e.width<=0?0:O([e.width,o,i.width]),height:e.height<=0?0:O([e.height,r,i.height]),left:O([n.left,i.left]),top:O([n.top,i.top]),right:O([n.right,i.right]),bottom:O([n.bottom,i.bottom])};return(s.width-s.left-s.right<=0||s.height-s.top-s.bottom<=0)&&(s={width:0,height:0}),s},_updateSize:function(){var t,e,n,i,a=this._calculateRawCanvas();t=this._canvas,e=a,n=["width","height"].every((function(n){return Math.abs(t[n]-e[n])<1})),i=["left","right","top","bottom"].every((function(n){return t[n]===e[n]})),n&&i&&!this.__forceRender||(this._canvas=M(a),this._recreateSizeDependentObjects(!0),this._renderer.resize(this._canvas.width,this._canvas.height),this._change(["LAYOUT"]))},_recreateSizeDependentObjects:s.noop,_getMinSize:function(){return[0,0]},_getAlignmentRect:s.noop,_setContentSize:function(){var t=this._canvas,e=this._layout,n=t.width>0&&t.height>0?[t.left,t.top,t.width-t.right,t.height-t.bottom]:[0,0,0,0];n=e.forward(n,this._getMinSize());var i=this._applySize(n)||n;e.backward(i,this._getAlignmentRect()||i)},_getOption:function(t,e){var n=this._themeManager.theme(t),i=this.option(t);return e?void 0!==i?i:n:(0,c.extend)(!0,{},n,i)},_setupResizeHandler:function(){var t=this,e=(0,x.parseScalar)(this._getOption("redrawOnResize",!0),!0);this._disposeResizeHandler&&this._removeResizeHandler(),this._disposeResizeHandler=(0,m.createResizeHandler)(this._$element[0],e,(function(){return t._requestChange(["CONTAINER_SIZE"])}))},_removeResizeHandler:function(){this._disposeResizeHandler&&(this._disposeResizeHandler(),this._disposeResizeHandler=null)},_onBeginUpdate:s.noop,beginUpdate:function(){return this._initialized&&this._isUpdateAllowed()&&(this._onBeginUpdate(),this._suspendChanges()),this.callBase.apply(this,arguments),this},endUpdate:function(){return this.callBase(),this._isUpdateAllowed()&&this._resumeChanges(),this},option:function(t){if(!(this._initialized&&this._applyingChanges&&(arguments.length>1||(0,h.isObject)(t))))return E.apply(this,arguments);this._optionsQueue=this._optionsQueue||[],this._optionsQueue.push(this._getActionForUpdating(arguments))},_getActionForUpdating:function(t){var e=this;return function(){E.apply(e,t)}},_clean:s.noop,_render:s.noop,_optionChanged:function(t){var e=this;if(!this._optionChangedLocker){var n=this.getPartialChangeOptionsName(t),i=[];n.length>0?n.forEach((function(t){return i.push(e._partialOptionChangesMap[t])})):i.push(this._optionChangesMap[t.name]),i=i.filter((function(t){return!!t})),this._eventTrigger.change(t.name)?this._change(["EVENTS"]):i.length>0?this._change(i):this.callBase.apply(this,arguments)}},_notify:s.noop,_changesApplied:s.noop,_optionChangesMap:{size:"CONTAINER_SIZE",margin:"CONTAINER_SIZE",redrawOnResize:"RESIZE_HANDLER",theme:"THEME",rtlEnabled:"THEME",encodeHtml:"THEME",elementAttr:"ELEMENT_ATTR",disabled:"DISABLED"},_partialOptionChangesMap:{},_partialOptionChangesPath:{},getPartialChangeOptionsName:function(t){var e=this,n=t.fullName,i=n.split(/[.]/),a=t.name,o=t.value,r=this._partialOptionChangesPath[a],s=[];return r&&(!0===r?s.push(a):(r.forEach((function(t){n.indexOf(t)>=0&&s.push(t)})),1===i.length&&("object"===(0,h.type)(o)?this._addOptionsNameForPartialUpdate(o,r,s):"array"===(0,h.type)(o)&&o.length>0&&o.every((function(t){return e._checkOptionsForPartialUpdate(t,r)}))&&o.forEach((function(t){e._addOptionsNameForPartialUpdate(t,r,s)}))))),s.filter((function(t,e,n){return n.indexOf(t)===e}))},_checkOptionsForPartialUpdate:function(t,e){return!Object.keys(t).some((function(t){return-1===e.indexOf(t)}))},_addOptionsNameForPartialUpdate:function(t,e,n){var i=Object.keys(t);this._checkOptionsForPartialUpdate(t,e)&&i.forEach((function(t){return e.indexOf(t)>-1&&n.push(t)}))},_visibilityChanged:function(){this.render()},_setThemeAndRtl:function(){this._themeManager.setTheme(this.option("theme"),this.option("rtlEnabled"))},_getRendererOptions:function(){return{rtl:this.option("rtlEnabled"),encodeHtml:this.option("encodeHtml"),animation:this._getAnimationOptions()}},_setRendererOptions:function(){this._renderer.setOptions(this._getRendererOptions())},svg:function(){return this._renderer.svg()},getSize:function(){var t=this._canvas||{};return{width:t.width,height:t.height}},isReady:I,_dataIsReady:T,_resetIsReady:function(){this.isReady=I},_renderGraphicObjects:function(){var t=this,e=this._renderer,n=w.default.getGraphicObjects();Object.keys(n).forEach((function(i){if(!t._graphicObjects[i]){var a=n[i],o=a.type,r=a.colors,s=a.rotationAngle,l=a.template,c=a.width,u=a.height;switch(o){case"linear":t._graphicObjects[i]=e.linearGradient(r,i,s);break;case"radial":t._graphicObjects[i]=e.radialGradient(r,i);break;case"pattern":t._graphicObjects[i]=e.customPattern(i,t._getTemplate(l),c,u)}}}))},_drawn:function(){var t=this;this.isReady=I,this._dataIsReady()&&this._renderer.onEndAnimation((function(){t.isReady=T})),this._eventTrigger("drawn",{})}}),q=z;e.default=q,(0,v.replaceInherit)(z)},4096:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=S(n(99393)),a=n(20576),o=n(13306),r=n(95479),s=n(60810),l=n(58664),c=n(35922),u=n(58201),d=n(97574),h=n(61189),f=S(n(42597)),p=n(97882),g=S(n(70714)),m=S(n(59345)),_=n(77129),v=n(19157),b=S(n(63407)),y=n(21177),x=n(34434),w=n(41690),k=n(14107);function S(t){return t&&t.__esModule?t:{default:t}}function C(t){return function(t){if(Array.isArray(t))return A(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return A(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return A(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function A(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var E=[{name:"default",border:{}}],T=Array.isArray;function I(t,e,n){var i=t.getOptions().grid,a=t.getOptions().minorGrid;i.visible=e,a&&(a.visible=n)}function D(t,e){return t.priority-e.priority}function O(t,e){var n=!1;return(0,r.each)(t,(function(t,i){if(i.name===e)return n=!0,!1})),n}function L(t,e,n,i){var a=e[t]||0,o=n[t]||0;return a+o+(a&&o?i:0)}function M(t,e,n){return P(e[t],n[t])}function P(t,e){return Math.max(t||0,e||0)}function R(t){return t.getMargins()}function B(t,e){return t.reduce((function(t,n){var i,a=e(n),o=t.panes[n.pane]=t.panes[n.pane]||{},r=n.getMultipleAxesSpacing();o.top=L("top",o,a,r),o.bottom=L("bottom",o,a,r),o.left=M("left",o,a),o.right=M("right",o,a),t.top=M("top",o,t),t.bottom=M("bottom",o,t),t.left=M("left",o,t),t.right=M("right",o,t);var s=null===(i=n.getOrthogonalAxis)||void 0===i?void 0:i.call(n);return(null==s?void 0:s.customPositionIsAvailable())&&(!n.customPositionIsBoundaryOrthogonalAxis()||!s.customPositionEqualsToPredefined())&&(t[s.getResolvedBoundaryPosition()]=0),t}),{panes:{}})}function z(t){return t.reduce((function(t,e){var n=e.getMargins(),i=t.panes[e.pane]=t.panes[e.pane]||{},a=e.getMultipleAxesSpacing();return i.top=M("top",i,n),i.bottom=M("bottom",i,n),i.left=L("left",i,n,a),i.right=L("right",i,n,a),t.top=M("top",i,t),t.bottom=M("bottom",i,t),t.left=M("left",i,t),t.right=M("right",i,t),t}),{panes:{}})}function q(t,e,n,i,a){t.forEach((function(t){t[e](null==n?void 0:n[t.pane],(null==i?void 0:i[t.pane])||i,a)}))}function V(t,e,n,i,a){function o(e,n,i){return((t?["left","right"]:["top","bottom"]).includes(e)?n.panes[i]||{}:n)[e]}function r(t,e,n,i){return P(o(t,e,i),o(t,n,i))}var s=function(t){return"original".concat(t[0].toUpperCase()).concat(t.slice(1))};function l(t,e,o,l,c,u){(e=e.sort((function(e,n){return t[n][l]-t[e][l]}))).forEach((function(e){var n=t[e];u.forEach((function(t){n[t]=n[s(t)]+r(t,i,a,e)}))}));var d=t[e[0]],h=d[o]-d[s(c)]-t[e.at(-1)][s(l)],f=e.reduce((function(t,e){return t-r(l,i,a,e)-r(c,i,a,e)}),h)-v.PANE_PADDING*(e.length-1);f-=Object.keys(n).reduce((function(t,e){return t+((0,v.isRelativeHeightPane)(n[e])?0:n[e].height)}),0);var p=d[o]-d[s(c)]-(f<0?f:0);e.reduce((function(e,s){var u=t[s],h=n[s];return e-=r(c,i,a,s),u[c]=d[o]-e,e-=(0,v.isRelativeHeightPane)(h)?Math.floor(f*h.height):h.height,u[l]=e,e-=r(l,i,a,s)+v.PANE_PADDING}),p)}var c=Object.keys(e);return t?l(e,c,"width","left","right",["top","bottom"]):l(e,c,"height","top","bottom",["left","right"]),e}function F(t,e,n,i){e&&(q(t,"createTicks",n),f.default.synchronize(t)),q(t,"draw",!e&&n,i)}function H(t,e){var n={};return function(i){if(!i.customPositionIsAvailable()||i.customPositionEqualsToPredefined()){var a=n[i.pane]=n[i.pane]||{top:0,left:0,bottom:0,right:0},o=i.getMultipleAxesSpacing(),r=i.getMargins();i.shift(a),a[t]=L(t,a,r,o),a[e]=L(e,a,r,o)}else i.shift({top:0,left:0,bottom:0,right:0})}}function N(t,e){var n,i=0;return Object.keys(e.panes).forEach((function(a){n=e.panes[a],i+="height"===t?n.top+n.bottom:n.left+n.right})),i}function j(t,e,n,i){var a=0;t[e]>0&&(a=N(e,i(n,R)),q(n,"hideTitle"),t[e]-=a-N(e,i(n,R))),t[e]>0&&q(n,"hideOuterElements")}var G=function(t,e,n){var i=e.x-n<=t.x,a=e.x+n>=t.x,o=e.y-n<=t.y,r=e.y+n>=t.y;return i&&a&&(o&&r)},Z=function(t,e,n){for(var i=t.getOptions().size/2,a=0;a<e.length;a+=1){if(!n){var o=e[a].x===t.x,r=e[a].y===t.y;if(o&&r)continue}if(G(t,e[a],i))return!0}return!1};var W=w.AdvancedChart.inherit({_themeSection:"chart",_fontFields:["crosshair.label.font"],_initCore:function(){this.paneAxis={},this.callBase()},_init:function(){this._containerInitialHeight=(0,u.hasWindow)()?(0,l.getHeight)(this._$element):0,this.callBase()},_correctAxes:function(){this._correctValueAxes(!0)},_setDeprecatedOptions:function(){this.callBase(),(0,o.extend)(this._deprecatedOptions,{"argumentAxis.aggregateByCategory":{since:"23.1",message:"Use the aggregation.enabled property"}})},_getExtraOptions:a.noop,_createPanes:function(){var t,e=this.option("panes"),n=0;return(!e||T(e)&&!e.length)&&(e=E),this.callBase(),t=this.option("defaultPane"),e=(0,o.extend)(!0,[],T(e)?e:[e]),(0,r.each)(e,(function(t,e){e.name=(0,c.isDefined)(e.name)?e.name:"default"+n++})),(0,c.isDefined)(t)?O(e,t)||(this._incidentOccurred("W2101",[t]),t=e[e.length-1].name):t=e[e.length-1].name,this.defaultPane=t,e=this._isRotated()?e.reverse():e},_getAxisRenderingOptions:function(){return{axisType:"xyAxes",drawingType:"linear"}},_prepareAxisOptions:function(t,e,n){return{isHorizontal:"argumentAxis"===t!==n,containerColor:this._themeManager.getOptions("containerBackgroundColor")}},_checkPaneName:function(t){var e=(0,v.map)(this.panes,(function(t){return t.name}));return t.pane=t.pane||this.defaultPane,e.includes(t.pane)},_initCustomPositioningAxes:function(){var t=this,e=this.getArgumentAxis(),n=e.getOptions().customPositionAxis,i=this._valueAxes.find((function(t){return t.pane===e.pane&&(!n||n===t.name)}));this._valueAxes.forEach((function(t){e!==t.getOrthogonalAxis()&&(t.getOrthogonalAxis=function(){return e},t.customPositionIsBoundaryOrthogonalAxis=function(){return e.customPositionIsBoundary()})})),(0,c.isDefined)(i)&&i!==e.getOrthogonalAxis()?(e.getOrthogonalAxis=function(){return i},e.customPositionIsBoundaryOrthogonalAxis=function(){return t._valueAxes.some((function(t){return t.customPositionIsBoundary()}))}):(0,c.isDefined)(e.getOrthogonalAxis())&&!(0,c.isDefined)(i)&&(e.getOrthogonalAxis=a.noop)},_getAllAxes:function(){return this._argumentAxes.concat(this._valueAxes)},_resetAxesAnimation:function(t,e){((0,c.isDefined)(e)?e^this._isRotated()?this._argumentAxes:this._valueAxes:this._getAllAxes()).forEach((function(e){e.resetApplyingAnimation(t)}))},_axesBoundaryPositioning:function(){var t=this._getAllAxes(),e=!1;return t.forEach((function(t){if(t.customPositionIsAvailable()){var n=t.customPositionIsBoundary();t._customBoundaryPosition=t.getCustomBoundaryPosition(),e=e||n!==t.customPositionIsBoundary()}})),e},_getCrosshairMargins:function(){var t=this._getCrosshairOptions()||{},e=t.enabled,n=(0,d.getMargins)(),i=(0,o.extend)(!0,{},t.label,t.horizontalLine.label),a=(0,o.extend)(!0,{},t.label,t.verticalLine.label);return{x:e&&t.horizontalLine.visible&&i.visible?n.x:0,y:e&&t.verticalLine.visible&&a.visible?n.y:0}},_getValueAxis:function(t,e){var n,i,a=this._valueAxes,o=this.option("valueAxis")||{},r=T(o)?o:[o],s=this._isRotated(),l=this._getCrosshairMargins();return(i=function t(e,n,i){var a=i.find((function(t){return t.name===n&&t.pane===e}));return a||(e?t(void 0,n,i):void 0)}(t,e=e||function(t,e,n){for(var i,a=0;a<t.length;a+=1)if(t[a].pane===e||void 0===t[a].pane&&e===n){i=t[a].name;break}return i||(i=t[0].name),i}(a,t,this.defaultPane),a))||((n=function(t,e,n){var i,a;for(a=0;a<e.length;a+=1)if(e[a].name===n){(i=e[a]).priority=a;break}if(!i)for(a=0;a<t.length;a+=1)if(t[a].name===n){(i=t[a].getOptions()).priority=t[a].priority;break}return i}(a,r,e))||(this._incidentOccurred("W2102",[e]),n={name:e,priority:a.length}),(i=this._createAxis(!1,this._populateAxesOptions("valueAxis",n,{pane:t,name:e,optionPath:T(o)?"valueAxis[".concat(n.priority,"]"):"valueAxis",crosshairMargin:s?l.y:l.x},s))).applyVisualRangeSetter(this._getVisualRangeSetter()),a.push(i)),i.setPane(t),i},_correctValueAxes:function(t){var e=this,n=this._themeManager.getOptions("synchronizeMultiAxes"),i=this._valueAxes,a={};this.series.forEach((function(t){var e=t.getValueAxis();a[e.pane]=!0})),this.panes.forEach((function(o){var r,s,l,c,u,d=o.name;a[d]||e._getValueAxis(d),t&&n&&(r=i.filter((function(t){return t.pane===d})),s=!1,l=[],c=r.some((function(t){var e=t.getOptions().minorGrid;return null==e?void 0:e.visible})),u=r.some((function(t){var e=t.getOptions().grid;return null==e?void 0:e.visible})),r.length>1&&(r.forEach((function(t){var e=t.getOptions().grid;s?I(t,!1,!1):(null==e?void 0:e.visible)&&(t.getTranslator().getBusinessRange().isEmpty()?(I(t,!1,!1),l.push(t)):(s=!0,I(t,u,c)))})),!s&&l.length&&I(l[0],u,c)))})),this._valueAxes=i.filter((function(t){t.pane||t.setPane(e.defaultPane);var n=O(e.panes,t.pane);return n||(t.dispose(),t=null),n})).sort(D);var o=this.getValueAxis();this._valueAxes.forEach((function(t){var n=t.getOptions().optionPath;if(n){var i=e._valueAxes.filter((function(t){return t.getOptions().optionPath===n}));i.length>1&&(i.some((function(t){return t===o}))?i.forEach((function(t){t!==o&&(t.getOptions().optionPath=null)})):i.forEach((function(t,e){0!==e&&(t.getOptions().optionPath=null)})))}}))},_getSeriesForPane:function(t){var e=[];return(0,r.each)(this.series,(function(n,i){i.pane===t&&e.push(i)})),e},_createPanesBorderOptions:function(){var t=this._themeManager.getOptions("commonPaneSettings").border,e={};return this.panes.forEach((function(n){e[n.name]=(0,o.extend)(!0,{},t,n.border)})),e},_createScrollBar:function(){var t,e=this._themeManager.getOptions("scrollBar")||{},n=this._scrollBarGroup;e.visible?(e.rotated=this._isRotated(),this._scrollBar=(this._scrollBar||new p.ScrollBar(this._renderer,n)).update(e)):(n.linkRemove(),null===(t=this._scrollBar)||void 0===t||t.dispose(),this._scrollBar=null)},_executeAppendAfterSeries:function(t){t()},_prepareToRender:function(){var t=this._createPanesBorderOptions();return this._createPanesBackground(),this._appendAxesGroups(),this._adjustViewport(),t},_adjustViewport:function(){this._themeManager.getOptions("adjustOnZoom")&&this._valueAxes.forEach((function(t){return t.adjust()}))},_recreateSizeDependentObjects:function(t){var e=this,n=this._getVisibleSeries(),i=n.some((function(t){return t.useAggregation()})),a=this._isZooming();i&&(this._argumentAxes.forEach((function(t){t.updateCanvas(e._canvas,!0)})),n.forEach((function(e){e.useAggregation()&&(t||a||!e._useAllAggregatedPoints)&&e.createPoints()})),this._processSeriesFamilies())},_isZooming:function(){var t=this.getArgumentAxis();if(!(null==t?void 0:t.getTranslator()))return!1;var e=t.getTranslator().getBusinessRange(),n=t.getViewport(),i=n?n.min:0,a=n?n.max:0;"logarithmic"===e.axisType&&(i=(0,v.getLog)(i,e.base),a=(0,v.getLog)(a,e.base));var o="discrete"===e.axisType?(0,v.getCategoriesInfo)(e.categories,i,a).categories.length:Math.abs(a-i),r=(0,s.getPrecision)(o);r=r>1?Math.pow(10,r-2):1;var l=Math.round((this._zoomLength-o)*r)/r!=0;return this._zoomLength=o,l},_handleSeriesDataUpdated:function(){var t=this,e=new y.Range;this.series.forEach((function(t){e.addRange(t.getArgumentRange())})),this._argumentAxes.forEach((function(n){n.updateCanvas(t._canvas,!0),n.setBusinessRange(e,t._axesReinitialized)})),this.callBase()},_isLegendInside:function(){return this._legend&&"inside"===this._legend.getPosition()},_isRotated:function(){return this._themeManager.getOptions("rotated")},_getLayoutTargets:function(){return this.panes},_applyClipRects:function(t){this._drawPanesBorders(t),this._createClipRectsForPanes(),this._applyClipRectsForAxes(),this._fillPanesBackground()},_updateLegendPosition:function(t,e){if(t.drawLegend&&this._legend&&e){var n=this.panes,i=(0,o.extend)({},n[0].canvas),a=new h.LayoutManager;i.right=n[n.length-1].canvas.right,i.bottom=n[n.length-1].canvas.bottom,a.layoutInsideLegend(this._legend,i)}},_allowLegendInsidePosition:function(){return!0},_applyExtraSettings:function(t){var e=this._getPaneIndex(t.pane),n=this._panesClipRects,i=n.wide[e];t.setClippingParams(n.base[e].id,null==i?void 0:i.id,this._getPaneBorderVisibility(e))},_updatePanesCanvases:function(t){t.recreateCanvas&&(0,v.updatePanesCanvases)(this.panes,this._canvas,this._isRotated())},_normalizePanesHeight:function(){(0,v.normalizePanesHeight)(this.panes)},_renderScaleBreaks:function(){this._valueAxes.concat(this._argumentAxes).forEach((function(t){t.drawScaleBreaks()}))},_getArgFilter:function(){return b.default.getViewPortFilter(this.getArgumentAxis().visualRange()||{})},_hidePointsForSingleSeriesIfNeeded:function(t){for(var e=t.getPoints(),n=0,i=0;i<e.length;i+=1){var a=e[i],o=e.slice(i+1);if((n+=Number(Z(a,o)))>e.length/2){t.autoHidePointMarkers=!0;break}}},_applyAutoHidePointMarkers:function(t){for(var e=[],n=function(t,n){return t+Z(n,e,!0)},i=t.length-1;i>=0;i-=1){var a=t[i];if(a.autoHidePointMarkersEnabled()&&(a.autoHidePointMarkers=!1,this._hidePointsForSingleSeriesIfNeeded(a),!a.autoHidePointMarkers)){var o=a.getPoints();o.reduce(n,0)<o.length?e=e.concat(o):a.autoHidePointMarkers=!0}}},_applyPointMarkersAutoHiding:function(){var t=this,e=this.series;this._themeManager.getOptions("autoHidePointMarkers")?this.panes.forEach((function(n){var i=n.borderCoords,a=n.name,r=e.filter((function(t){return t.pane===a&&t.usePointsToDefineAutoHiding()}));r.forEach((function(t){t.prepareCoordinatesForPoints()}));var s=t.getArgumentAxis(),l=function(t,e,n){var i=[],a={},r=n.visualRange(),s=n.getTranslator(),l=b.default.getViewPortFilter(r||{});return e.forEach((function(n){var r=n.getValueAxis(),c=r.getCanvasRange(),u=r.getTranslator(),d=t.indexOf(n),h=b.default.getViewPortFilter(c||{});a[d]={},e.forEach((function(e){a[d][t.indexOf(e)]=0}));var f=[];n.getPoints().filter((function(t){return t.getOptions().visible&&l(t.argument)&&(h(t.getMinValue(!0))||h(t.getMaxValue(!0)))})).forEach((function(t){var e={seriesIndex:d,argument:t.argument,value:t.getMaxValue(!0),size:t.bubbleSize||t.getOptions().size,x:void 0,y:void 0};if(t.getMinValue(!0)!==t.getMaxValue(!0)){var n=(0,o.extend)({},e);n.value=t.getMinValue(!0),n.x=s.to(n.argument,1),n.y=u.to(n.value,1),f.push(n)}e.x=s.to(e.argument,1),e.y=u.to(e.value,1),f.push(e)})),a[d].pointsCount=f.length,a[d].total=0,a[d].continuousSeries=0,i.push({name:n.name,index:d,points:f})})),{series:i,overloadedSeries:a}}(e,r,s);if(function(t,e,n){for(var i=t.width*t.height,a=e.series,o=function(t){var o=n.filter((function(e){return e.name===a[t].name}))[0],r=a[t].points,s=r.length?r[0].size:0,l=s*s*r.length;if(o.autoHidePointMarkersEnabled()&&l>=i/a.length){var c=a[t].index;o.autoHidePointMarkers=!0,a.splice(t,1),n.splice(n.indexOf(o),1),e.overloadedSeries[c]=null}},r=a.length-1;r>=0;r-=1)o(r)}(i,l,r),l.series.length){var u=s.visualRange(),d="discrete"===s.getOptions().type?function(t,e){return u.categories.indexOf(t.argument)-u.categories.indexOf(e.argument)}:function(t,e){return t.argument-e.argument},h=[];l.series.forEach((function(t){h=h.concat(t.points)})),h.sort(d),function(t,e){for(var n=!1,i=0;i<t.length-1;i+=1){var a=t[i],o=a.size;if((0,c.isDefined)(a.x)&&(0,c.isDefined)(a.y))for(var r=i+1;r<t.length;r+=1){var s=t[r],l=null==s?void 0:s.x,u=null==s?void 0:s.y;if(!(0,c.isDefined)(l)||Math.abs(a.x-l)>=o){n=n&&r!==i+1;break}var d=(0,c.isDefined)(l)&&(0,c.isDefined)(u)&&Math.sqrt(Math.pow(a.x-l,2)+Math.pow(a.y-u,2));d&&d<o&&(e[a.seriesIndex][s.seriesIndex]+=1,e[a.seriesIndex].total+=1,n||(e[a.seriesIndex].continuousSeries+=1,n=!0))}}}(h,l.overloadedSeries),t._applyAutoHidePointMarkers(r)}})):e.forEach((function(t){t.autoHidePointMarkers=!1}))},_renderAxes:function(t,e){var n=this;function i(t){return t.map((function(t){if(!t.getTitle)return 0;var e=t.getTitle();return e?e.bBox.width:0}))}var a=this._isRotated(),r=this._themeManager.getOptions("synchronizeMultiAxes"),s=this._scrollBar?[this._scrollBar]:[],l=this._isArgumentAxisBeforeScrollBar()?this._argumentAxes.concat(s):s.concat(this._argumentAxes),c=a?this._argumentAxes:this._valueAxes,u=a?l:this._valueAxes,d=a?this._valueAxes:this._argumentAxes,h=a?this._valueAxes:l,f=c.concat(d),p=f.concat(s),g=c.some((function(t){return t.isFirstDrawing()}));this._normalizePanesHeight(),this._updatePanesCanvases(t);var m=this.panes.reduce((function(t,e){return t[e.name]=(0,o.extend)({},e.canvas),t}),{}),_=this.panes.reduce((function(t,e){return t[e.name]={height:e.height,unit:e.unit},t}),{}),v=(0,o.extend)(!0,{},m);this._initCustomPositioningAxes();var b=this._axesBoundaryPositioning();if(!t.adjustAxes&&!b)return F(c,!a&&r,m,e),F(d,a&&r,m,e),q(f,"prepareAnimation"),this._renderScaleBreaks(),d.forEach((function(t){return t.resolveOverlappingForCustomPositioning(c)})),c.forEach((function(t){return t.resolveOverlappingForCustomPositioning(d)})),!1;b&&f.forEach((function(t){return t.customPositionIsAvailable()&&t.shift({top:0,left:0,bottom:0,right:0})})),this._scrollBar&&this._scrollBar.setPane(this.panes);var y={panes:{},left:0,right:0},x=B(h,(function(t){return t.estimateMargins(m[t.pane])}));m=V(a,m,_,y,x);var w=function(t){F(t?d:c,(t?a:!a)&&r,m,e),t?x=B(h,R):y=z(u),m=V(a,m,_,y,x)};w(!1),w(!0),!this._changesApplying&&this._estimateTickIntervals(c,m)&&w(!1);var k=i(c),S=this._getVisibleSeries(),C=function(t,e){var n=e.reduce((function(t,e){return t+e}),0)/e.length;return t.animate&&n<=t.animationPointsLimit}(t,this._getPointsToAnimation(S));return q(p,"updateSize",m,C),h.forEach(H("top","bottom")),u.forEach(H("left","right")),this._renderScaleBreaks(),this.panes.forEach((function(t){(0,o.extend)(t.canvas,m[t.name])})),this._valueAxes.forEach((function(t){t.setInitRange()})),c.forEach((function(t,e){var o;if(null===(o=t.hasWrap)||void 0===o?void 0:o.call(t)){var r=t.getTitle(),s=(r?r.bBox.width:0)-k[e];"right"===t.getOptions().position?y.right+=s:(y.left+=s,n.panes.forEach((function(t){var e=t.name;y.panes[e].left+=s}))),m=V(a,m,_,y,x),q(p,"updateSize",m,!1,!1),k=i(c)}})),c.some((function(t){return t.customPositionIsAvailable()&&t.getCustomPosition()!==t._axisPosition}))&&(C&&this._resetAxesAnimation(g,!1),q(c,"updateSize",m,C)),d.forEach((function(t){return t.resolveOverlappingForCustomPositioning(c)})),c.forEach((function(t){return t.resolveOverlappingForCustomPositioning(d)})),v},_getExtraTemplatesItems:function(){var t=(this._argumentAxes||[]).concat(this._valueAxes||[]),e=this._collectTemplatesFromItems(t);return{items:e.items,groups:e.groups,launchRequest:function(){t.forEach((function(t){t.setRenderedState(!0)}))},doneRequest:function(){t.forEach((function(t){t.setRenderedState(!1)}))}}},_estimateTickIntervals:function(t,e){return t.some((function(t){return t.estimateTickInterval(e[t.pane])}))},checkForMoreSpaceForPanesCanvas:function(){var t=this._isRotated(),e=!1;if(this.panes.filter((function(t){return t.unit})).length===this.panes.length){var n=0,i=0;if(t){var a=this.getArgumentAxis().getMargins().right,o=Math.min.apply(Math,C(this.panes.map((function(t){return t.canvas.right}))));n=this._canvas.right+a-o}else{var r=this.getArgumentAxis().getMargins().bottom,s=Math.min.apply(Math,C(this.panes.map((function(t){return t.canvas.bottom}))));i=this._canvas.bottom+r-s}if(e=(n>0||i>0)&&{width:n,height:i},0!==i){var l=this.getSize(),c=this.option("size"),u=this._$element[0],d=!!parseInt(u.style.height,10)||0!==this._containerInitialHeight;t||(null==c?void 0:c.height)||d||(this._forceResize(l.width,l.height+i),e=!1)}}else e=this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(),t,(function(e){return{width:t&&!!e.unit,height:!t&&!!e.unit}}));return e},_forceResize:function(t,e){this._renderer.resize(t,e),this._updateSize(),this._setContentSize(),this._preserveOriginalCanvas(),this._updateCanvasClipRect(this._canvas)},_shrinkAxes:function(t,e){if(t&&e){this._renderer.stopAllAnimations(!0);var n=this._isRotated(),i=this._scrollBar?[this._scrollBar]:[],a=this._isArgumentAxisBeforeScrollBar()?this._argumentAxes.concat(i):i.concat(this._argumentAxes),r=n?a:this._valueAxes,s=n?this._valueAxes:a,l=r.concat(s);if(t.width||t.height){j(t,"height",s,B),j(t,"width",r,z),q(l,"updateSize",e);var c=this.panes.reduce((function(t,e){return t[e.name]={height:e.height,unit:e.unit},t}),{});q(l,"updateSize",e=V(n,e,c,z(r),B(s,R))),s.forEach(H("top","bottom")),r.forEach(H("left","right")),this.panes.forEach((function(t){return(0,o.extend)(t.canvas,e[t.name])}))}}},_isArgumentAxisBeforeScrollBar:function(){var t,e=this.getArgumentAxis();if(this._scrollBar){var n=e.getResolvedBoundaryPosition(),i=null===(t=e.getOptions().label)||void 0===t?void 0:t.position,a=this._scrollBar.getOptions().position;return e.hasNonBoundaryPosition()||a===n&&i!==a}return!1},_getPanesParameters:function(){for(var t=this.panes,e=[],n=0;n<t.length;n+=1)this._getPaneBorderVisibility(n)&&e.push({coords:t[n].borderCoords,clipRect:this._panesClipRects.fixed[n]});return e},_createCrosshairCursor:function(){var t=this._themeManager.getOptions("crosshair")||{},e=this.getArgumentAxis(),n=this._isRotated()?[this._valueAxes,[e]]:[[e],this._valueAxes],i={canvas:this._getCommonCanvas(),panes:this._getPanesParameters(),axes:n};(null==t?void 0:t.enabled)&&(this._crosshair?this._crosshair.update(t,i):this._crosshair=new d.Crosshair(this._renderer,t,i,this._crosshairCursorGroup),this._crosshair.render())},_getCommonCanvas:function(){for(var t,e=this.panes,n=0;n<e.length;n+=1){var i=e[n].canvas;t?(t.right=i.right,t.bottom=i.bottom):t=(0,o.extend)({},i)}return t},_createPanesBackground:function(){var t=this._themeManager.getOptions("commonPaneSettings").backgroundColor,e=this._renderer,n=[];this._panesBackgroundGroup.clear();for(var i=0;i<this.panes.length;i+=1){var a=this.panes[i].backgroundColor||t;if(a&&"none"!==a){var o=e.rect(0,0,0,0).attr({fill:(0,v.extractColor)(a),"stroke-width":0}).append(this._panesBackgroundGroup);n.push(o)}else n.push(null)}this.panesBackground=n},_fillPanesBackground:function(){var t=this;(0,r.each)(this.panes,(function(e,n){var i=n.borderCoords;null!==t.panesBackground[e]&&t.panesBackground[e].attr({x:i.left,y:i.top,width:i.width,height:i.height})}))},_calcPaneBorderCoords:function(t){var e=t.canvas,n=t.borderCoords=t.borderCoords||{};n.left=e.left,n.top=e.top,n.right=e.width-e.right,n.bottom=e.height-e.bottom,n.width=Math.max(n.right-n.left,0),n.height=Math.max(n.bottom-n.top,0)},_drawPanesBorders:function(t){var e=this,n=this._isRotated();this._panesBorderGroup.linkRemove().clear(),(0,r.each)(this.panes,(function(i,a){var o=t[a.name],r={fill:"none",stroke:o.color,"stroke-opacity":o.opacity,"stroke-width":o.width,dashStyle:o.dashStyle,"stroke-linecap":"square"};if(e._calcPaneBorderCoords(a,n),o.visible){var s=a.borderCoords,l=(0,x.prepareSegmentRectPoints)(s.left,s.top,s.width,s.height,o);e._renderer.path(l.points,l.pathType).attr(r).append(e._panesBorderGroup)}})),this._panesBorderGroup.linkAppend()},_createClipRect:function(t,e,n,i,a,o){var r=t[e];r?r.attr({x:n,y:i,width:a,height:o}):(r=this._renderer.clipRect(n,i,a,o),t[e]=r)},_createClipRectsForPanes:function(){var t=this,e=this._canvas;(0,r.each)(this.panes,(function(n,i){var a=!1,o=i.borderCoords,s=o.left,l=o.top,c=o.width,u=o.height,d=t._panesClipRects;t._createClipRect(d.fixed,n,s,l,c,u),t._createClipRect(d.base,n,s,l,c,u),(0,r.each)(t.series,(function(t,e){e.pane===i.name&&(e.isFinancialSeries()||e.areErrorBarsVisible())&&(a=!0)})),a?(t._isRotated()?(l=0,u=e.height):(s=0,c=e.width),t._createClipRect(d.wide,n,s,l,c,u)):d.wide[n]=null}))},_applyClipRectsForAxes:function(){for(var t=this._getAllAxes(),e=this._getCanvasClipRectID(),n=0;n<t.length;n+=1){var i=this._getElementsClipRectID(t[n].pane);t[n].applyClipRects(i,e)}},_getPaneBorderVisibility:function(t){var e,n=this._themeManager.getOptions("commonPaneSettings").border.visible,i=this.panes[t],a=null===(e=null==i?void 0:i.border)||void 0===e?void 0:e.visible;return void 0===a?n:a},_getCanvasForPane:function(t){var e;return null===(e=this.panes.find((function(e){return e.name===t})))||void 0===e?void 0:e.canvas},_getTrackerSettings:function(){return(0,o.extend)(this.callBase(),{chart:this,rotated:this._isRotated(),crosshair:this._getCrosshairOptions().enabled?this._crosshair:null,stickyHovering:this._themeManager.getOptions("stickyHovering")})},_resolveLabelOverlappingStack:function(){var t=this,e=this._isRotated(),n=e?function(t,e){return{x:t.x-e,y:t.y}}:function(t,e){return{x:t.x,y:t.y-e}},i=function(t,n){var i=e?1:0;if(t.labels[0].getFigureCenter()[i]-n.labels[0].getFigureCenter()[i]==0){var a=t.labels[0].getPoint().series.getValueAxis().getTranslator().isInverted()?-1:1;return(t.value()-n.value())*a}return 0};(0,r.each)(this._getStackPoints(),(function(a,o){(0,r.each)(o,(function(a,o){var r=o[0].series.getValueAxis().getOptions().inverted;k.overlapping.resolveLabelOverlappingInOneDirection(o,t._getCommonCanvas(),e,r,n,i)}))}))},_getStackPoints:function(){var t={},e=this._getVisibleSeries();return(0,r.each)(e,(function(e,n){var i=n.getPoints(),a=n.getStackName()||null;(0,r.each)(i,(function(e,n){var i=n.argument;t[i]||(t[i]={}),t[i][a]||(t[i][a]=[]),t[i][a].push(n)}))})),t},_getCrosshairOptions:function(){return this._getOption("crosshair")},zoomArgument:function(t,e){this._initialized&&((0,c.isDefined)(t)||(0,c.isDefined)(e))&&this.getArgumentAxis().visualRange([t,e])},resetVisualRange:function(){var t=this,e=this._argumentAxes,n=this.getArgumentAxis();e.forEach((function(e){e.resetVisualRange(n!==e),t._applyCustomVisualRangeOption(e)})),this.callBase()},getVisibleArgumentBounds:function(){var t=this._argumentAxes[0].getTranslator().getBusinessRange(),e="discrete"===t.axisType,n=t.categories;return{minVisible:e?t.minVisible||n[0]:t.minVisible,maxVisible:e?t.maxVisible||n[n.length-1]:t.maxVisible}},_change_FULL_RENDER:function(){this.callBase(),this._changes.has("VISUAL_RANGE")&&this._raiseZoomEndHandlers()},_getAxesForScaling:function(){return[this.getArgumentAxis()].concat(this._valueAxes)},_applyVisualRangeByVirtualAxes:function(t,e){if(t.isArgumentAxis){if(t!==this.getArgumentAxis())return!0;this._argumentAxes.filter((function(e){return e!==t})).forEach((function(t){return t.visualRange(e,{start:!0,end:!0})}))}return!1},_raiseZoomEndHandlers:function(){this._argumentAxes.forEach((function(t){return t.handleZoomEnd()})),this.callBase()},_setOptionsByReference:function(){this.callBase(),(0,o.extend)(this._optionsByReference,{"argumentAxis.visualRange":!0})},option:function(){var t=this.callBase.apply(this,arguments),e=this._options.silent("valueAxis");if("array"===(0,c.type)(e))for(var n=0;n<e.length;n+=1){var i="valueAxis[".concat(n,"].visualRange");this._optionsByReference[i]=!0}return t},_notifyVisualRange:function(){var t=this._argumentAxes[0],e=(0,v.convertVisualRangeObject)(t.visualRange(),!T(this.option("argumentAxis.visualRange")));t.skipEventRising&&(0,v.rangesAreEqual)(e,this.option("argumentAxis.visualRange"))?t.skipEventRising=null:this.option("argumentAxis.visualRange",e),this.callBase()}});W.addPlugin(g.default),W.addPlugin(m.default),W.addPlugin(_.plugins.core),W.addPlugin(_.plugins.chart),(0,i.default)("dxChart",W);var U=W;e.default=U},88647:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i=g(n(99393)),a=n(20576),o=n(13306),r=n(95479),s=n(35922),l=g(n(32410)),c=n(77129),u=n(56672),d=n(19157),h=n(21177),f=n(17953),p=n(14107);function g(t){return t&&t.__esModule?t:{default:t}}var m=l.default.states,_=l.default.pieSeriesSpacing,v=m.normalMark,b=m.hoverMark,y=m.selectedMark,x=[m.resetItem,m.applyHover,m.applySelected,m.applySelected];function w(t,e){return{x:t.x,y:t.y-e}}function k(t,e){return t.getVisiblePoints().reduce((function(t,e){var n=(0,d.normalizeAngle)(e.middleAngle);return(n<=90||n>=270?t.right:t.left).push(e),t}),e||{left:[],right:[]})}function S(t,e,n,i){var a;return n&&(t.left.reverse(),t.right.reverse()),a=p.overlapping.resolveLabelOverlappingInOneDirection(t.left,i,!1,!1,e),p.overlapping.resolveLabelOverlappingInOneDirection(t.right,i,!1,!1,e)||a}function C(t){return(0,s.isNumeric)(t)?t>1?t=1:t<0&&(t=0):t=void 0,t}var A=function(){function t(t,e){return t.filter((function(t){return t!==e}))}var e=[],n={};return{queue:function(i){var a,o=i.getSizeGroup();e=t(e,a=i).concat(a),clearTimeout(n[o]),n[o]=setTimeout((function(){!function(t,e){var n=e.filter((function(e){return e._isVisible()&&e.getSizeGroup()===t})),i=Math.min.apply(null,n.map((function(t){return t.getSizeGroupLayout().radius}))),a=n.filter((function(t){return t.getSizeGroupLayout().radius===i}));n.forEach((function(t){return t.render({force:!0,sizeGroupLayout:a.length?a[0].getSizeGroupLayout():{}})}))}(o,e)}))},remove:function(i){(e=t(e,i)).length||(n={})}}}(),E=p.BaseChart.inherit({_themeSection:"pie",_layoutManagerOptions:function(){return(0,o.extend)(!0,{},this.callBase(),{piePercentage:C(this._themeManager.getOptions("diameter")),minPiePercentage:C(this._themeManager.getOptions("minDiameter"))})},_optionChangesMap:{diameter:"REINIT",minDiameter:"REINIT",sizeGroup:"REINIT"},_disposeCore:function(){A.remove(this),this.callBase()},_groupSeries:function(){var t,e=this.series;this._groupsData={groups:[{series:e,valueOptions:{valueType:"numeric"}}],argumentOptions:null===(t=e[0])||void 0===t?void 0:t.getOptions()}},getArgumentAxis:function(){return null},_getValueAxis:function(){var t=(new f.Translator1D).setCodomain(360,0);return{getTranslator:function(){return t},setBusinessRange:function(e){t.setDomain(e.min,e.max)}}},_populateBusinessRange:function(){this.series.map((function(t){var e=new h.Range;return e.addRange(t.getRangeData().val),t.getValueAxis().setBusinessRange(e),e}))},_specialProcessSeries:function(){(0,r.each)(this.series,(function(t,e){e.arrangePoints()}))},_checkPaneName:function(){return!0},_processSingleSeries:function(t){this.callBase(t),t.arrangePoints()},_handleSeriesDataUpdated:function(){var t=0;this.series.forEach((function(e){t=Math.max(e.getPointsCount(),t)})),this.series.forEach((function(e){e.setMaxPointsCount(t)})),this.callBase()},_getLegendOptions:function(t){var e=this.callBase(t),n=e.legendData;return n.argument=t.argument,n.argumentIndex=t.argumentIndex,n.points=[t],e},_getLegendTargets:function(){var t=this,e={};(this.series||[]).forEach((function(t){t.getPoints().forEach((function(n){var i=n.argument.valueOf(),a=t.getPointsByArg(i).indexOf(n),o=i.valueOf().toString()+a;e[o]=e[o]||[];var r=e[o].push(n);n.index=e[o][r-2]?e[o][r-2].index:Object.keys(e).length-1,n.argumentIndex=a}))}));var n=[];return(0,r.each)(e,(function(e,i){i.forEach((function(e,i){if(0!==i){var a=n[n.length-1];a.legendData.points.push(e),a.visible||(a.visible=e.isVisible())}else n.push(t._getLegendOptions(e))}))})),n},_getLayoutTargets:function(){return[{canvas:this._canvas}]},_getLayoutSeries:function(t,e){var n,i=this._canvas,a=!1;return n=this.layoutManager.applyPieChartSeriesLayout(i,t,!0),t.forEach((function(t){t.correctPosition(n,i),a=t.drawLabelsWOPoints()||a})),a&&(n=this.layoutManager.applyPieChartSeriesLayout(i,t,e.hideLayoutLabels)),t.forEach((function(t){t.hideLabels()})),this._sizeGroupLayout={x:n.centerX,y:n.centerY,radius:n.radiusOuter,drawOptions:e},n},_getLayoutSeriesForEqualPies:function(t,e){var n=this._canvas,i=this.layoutManager.applyEqualPieChartLayout(t,e);return t.forEach((function(t){t.correctPosition(i,n),t.drawLabelsWOPoints()})),this.layoutManager.correctPieLabelRadius(t,i,n),i},_updateSeriesDimensions:function(t){var e,n,i,a=this._getVisibleSeries(),o=a.length,r=t.sizeGroupLayout;o&&(i=r?this._getLayoutSeriesForEqualPies(a,r):this._getLayoutSeries(a,t),n=(i.radiusOuter-i.radiusInner-_*(o-1))/o,e=i.radiusInner,this._setGeometry(i),a.forEach((function(t){t.correctRadius({radiusInner:e,radiusOuter:e+n}),e+=n+_})))},_renderSeries:function(t,e,n){if(this._calculateSeriesLayout(t,e),!t.sizeGroupLayout&&this.getSizeGroup())return A.queue(this),void this._clearCanvas();this._renderSeriesElements(t,n)},_getCenter:function(){return this._center},getInnerRadius:function(){return this._innerRadius},_getLegendCallBack:function(){var t=this,e=this._legend,n=this._getLegendTargets().map((function(t){return t.legendData}));return function(i){n.forEach((function(n){var a=[],o=e.getActionCallback({index:n.id});t.series.forEach((function(t){var e=t.getPointsByKeys(n.argument,n.argumentIndex);a.push.apply(a,e)})),i&&i.argument===n.argument&&i.argumentIndex===n.argumentIndex&&a.push(i),o(function(t){var e=v;return t.forEach((function(t){var n,i=null===(n=t.series)||void 0===n?void 0:n.getOptions(),a=t.fullState;"none"===(null==i?void 0:i.hoverMode)&&(a&=~b),"none"===(null==i?void 0:i.selectionMode)&&(a&=~y),e|=a})),x[e]}(a))}))}},_locateLabels:function(t){var e,n,i=0;do{n=this._adjustSeriesLabels("shift"===t),e=this._resolveLabelOverlapping(t)}while((e||n)&&++i<5)},_adjustSeriesLabels:function(t){return this.series.reduce((function(e,n){return n.adjustLabels(t)||e}),!1)},_applyExtraSettings:a.noop,_resolveLabelOverlappingShift:function(){var t=this,e="anticlockwise"===this.option("segmentsDirection"),n=this.series.reduce((function(t,e){return(t[e.getOptions().label.position]||t.outside).push(e),t}),{inside:[],columns:[],outside:[]}),i=!1;n.inside.length>0&&(i=S(n.inside.reduce((function(t,e){return e.getVisiblePoints().reduce((function(t,e){return t.left.push(e),t}),t)}),{left:[],right:[]}),w,e,this._canvas)||i);return i=n.columns.reduce((function(n,i){return S(k(i),w,e,t._canvas)||n}),i),n.outside.length>0&&(i=S(n.outside.reduce((function(t,e){return k(e,t)}),null),(function(e,n){return(0,d.getVerticallyShiftedAngularCoords)(e,-n,t._center)}),e,this._canvas)||i),i},_setGeometry:function(t){var e=t.centerX,n=t.centerY,i=t.radiusInner;this._center={x:e,y:n},this._innerRadius=i},_disposeSeries:function(){this.callBase.apply(this,arguments),this._abstractSeries=null},_legendDataField:"point",_legendItemTextField:"argument",_applyPointMarkersAutoHiding:a.noop,_renderTrackers:a.noop,_trackerType:"PieTracker",_createScrollBar:a.noop,_updateAxesLayout:a.noop,_applyClipRects:a.noop,_appendAdditionalSeriesGroups:a.noop,_prepareToRender:a.noop,_isLegendInside:a.noop,_renderAxes:a.noop,_shrinkAxes:a.noop,_isRotated:a.noop,_seriesPopulatedHandlerCore:a.noop,_reinitAxes:a.noop,_correctAxes:a.noop,_getExtraOptions:function(){return{startAngle:this.option("startAngle"),innerRadius:this.option("innerRadius"),segmentsDirection:this.option("segmentsDirection"),type:this.option("type")}},getSizeGroup:function(){return this._themeManager.getOptions("sizeGroup")},getSizeGroupLayout:function(){return this._sizeGroupLayout||{}}});(0,r.each)(["startAngle","innerRadius","segmentsDirection","type"],(function(t,e){E.prototype._optionChangesMap[e]="REFRESH_SERIES_DATA_INIT"})),E.addPlugin(u.plugins.pieChart),E.addPlugin(c.plugins.core),E.addPlugin(c.plugins.pieChart),(0,i.default)("dxPieChart",E);var T=E;e.default=T},86139:function(t,e,n){Object.defineProperty(e,"__esModule",{value:!0}),e.default=void 0;var i,a=(i=n(99393))&&i.__esModule?i:{default:i},o=n(20576),r=n(13306),s=n(35922),l=n(77129),c=n(19157),u=n(41690);var d=u.AdvancedChart.inherit({_themeSection:"polar",_createPanes:function(){return this.callBase(),[{name:"default"}]},_checkPaneName:function(){return!0},_getAxisRenderingOptions:function(t){var e="argumentAxis"===t?"circular":"linear";return this.option("useSpiderWeb")&&(e+="Spider"),{axisType:"polarAxes",drawingType:e}},_executeAppendBeforeSeries:function(t){t()},_prepareAxisOptions:function(t,e){var n="argumentAxis"===t,i=this._themeManager,a=this.option("argumentAxis"),o=i.getOptions("argumentAxis",a)||{},r=isFinite(o.startAngle)?(0,c.normalizeAngle)(o.startAngle):0;return{type:this.option("useSpiderWeb")&&n?"discrete":e.type,isHorizontal:!0,showCustomBoundaryTicks:n,startAngle:r,endAngle:r+360}},_optionChangesMap:{useSpiderWeb:"USE_SPIDER_WEB"},_change_USE_SPIDER_WEB:function(){this._disposeAxes(),this._requestChange(["AXES_AND_PANES"])},_getExtraOptions:function(){return{spiderWidget:this.option("useSpiderWeb")}},_prepareToRender:function(){return this._appendAxesGroups(),{}},_calcCanvas:function(){var t=(0,r.extend)({},this._canvas),e=this.getArgumentAxis().getMargins();return Object.keys(e).forEach((function(n){t[n]=t["original".concat(n[0].toUpperCase()).concat(n.slice(1))]+e[n]})),t},_renderAxes:function(){var t=this._getValueAxis(),e=this.getArgumentAxis();e.draw(this._canvas),t.setSpiderTicks(e.getSpiderTicks());var n=this._calcCanvas();return e.updateSize(n),t.draw(n),n},_getValueAxis:function(){return this._valueAxes[0]},_shrinkAxes:function(t){var e=this._getValueAxis(),n=this.getArgumentAxis();if(t&&(t.width||t.height)){n.hideOuterElements();var i=this._calcCanvas();n.updateSize(i),e.updateSize(i)}},checkForMoreSpaceForPanesCanvas:function(){return this.layoutManager.needMoreSpaceForPanesCanvas([{canvas:this.getArgumentAxis().getCanvas()}],this._isRotated())},_getLayoutTargets:function(){return[{canvas:this._canvas}]},_getSeriesForPane:function(){return this.series},_applyClipRects:function(){var t=this._getCanvasClipRectID();this._createClipPathForPane(),this.getArgumentAxis().applyClipRects(this._getElementsClipRectID(),t),this._getValueAxis().applyClipRects(this._getElementsClipRectID(),t)},_createClipPathForPane:function(){var t=this._getValueAxis(),e=t.getCenter(),n=t.getRadius(),i=this._panesClipRects;e={x:Math.round(e.x),y:Math.round(e.y)},this._createClipCircle(i.fixed,e.x,e.y,n),this._createClipCircle(i.base,e.x,e.y,n),this.series.some((function(t){return t.areErrorBarsVisible()}))?this._createClipCircle(i.wide,e.x,e.y,n):i.wide[0]=null},_createClipCircle:function(t,e,n,i){var a=t[0];a?a.attr({cx:e,cy:n,r:i}):(a=this._renderer.clipCircle(e,n,i),t[0]=a)},_applyExtraSettings:function(t){var e=this._panesClipRects.wide[0];t.setClippingParams(this._panesClipRects.base[0].id,e&&e.id,!1,!1)},getActualAngle:function(t){return this.getArgumentAxis().getOptions().inverted?360-t:t},getXYFromPolar:function(t,e,n,i){var a={angle:void 0,radius:void 0,x:void 0,y:void 0};if(!((0,s.isDefined)(t)||(0,s.isDefined)(e)||(0,s.isDefined)(n)||(0,s.isDefined)(i)))return a;var o,l,u=this.getArgumentAxis(),d=u.getAngles()[0];if((0,s.isDefined)(n)?o=u.getTranslator().translate(n):isFinite(t)?o=this.getActualAngle(t):(0,s.isDefined)(t)||(o=0),(0,s.isDefined)(i)?l=this.getValueAxis().getTranslator().translate(i):isFinite(e)?l=e:(0,s.isDefined)(e)||(l=u.getRadius()),(0,s.isDefined)(o)&&(0,s.isDefined)(l)){var h=(0,c.convertPolarToXY)(u.getCenter(),d,o,l);(0,r.extend)(a,h,{angle:u.getTranslatedAngle(o),radius:l})}return a},_applyPointMarkersAutoHiding:o.noop,_createScrollBar:o.noop,_isRotated:o.noop,_getCrosshairOptions:o.noop,_isLegendInside:o.noop});d.addPlugin(l.plugins.core),d.addPlugin(l.plugins.polarChart),(0,a.default)("dxPolarChart",d);var h=d;e.default=h},23908:function(t,e,n){e.convertTransitionTimingFuncToEasing=void 0,e.getEasing=function(t){return s[t]},e.setEasing=function(t){s=t};var i=n(35922),a=/cubic-bezier\((\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\s*,\s*(\d+(?:\.\d+)?)\)/,o={linear:"cubic-bezier(0, 0, 1, 1)",swing:"cubic-bezier(0.445, 0.05, 0.55, 0.95)",ease:"cubic-bezier(0.25, 0.1, 0.25, 1)","ease-in":"cubic-bezier(0.42, 0, 1, 1)","ease-out":"cubic-bezier(0, 0, 0.58, 1)","ease-in-out":"cubic-bezier(0.42, 0, 0.58, 1)"},r=function(t,e,n,i){var a=3*t,o=3*(n-t)-a,r=1-a-o,s=3*e,l=3*(i-e)-s,c=1-s-l,u=function(t){return t*(a+t*(o+t*r))},d=function(t){return a+t*(2*o+3*t*r)};return function(t){return function(t){return t*(s+t*(l+t*c))}(function(t){for(var e,n=t,i=0;i<14&&(e=u(n)-t,!(Math.abs(e)<.001));)n-=e/d(n),i++;return n}(t))}},s={};e.convertTransitionTimingFuncToEasing=function(t){var e,n=(t=o[t]||t).match(a);n||(n=o[e="linear"].match(a)),n=n.slice(1,5);for(var l=0;l<n.length;l++)n[l]=parseFloat(n[l]);var c=e||"cubicbezier_"+n.join("_").replace(/\./g,"p");return(0,i.isFunction)(s[c])||(s[c]=function(t,e,i,a,o){return a*r(n[0],n[1],n[2],n[3])(e/o)+i}),c}},90057:function(t,e,n){e.cancelAnimationFrame=function(){c(),l.apply(r,arguments)},e.requestAnimationFrame=function(){return c(),s.apply(r,arguments)};var i,a=n(58201),o=(i=n(39618))&&i.__esModule?i:{default:i};var r=(0,a.hasWindow)()?(0,a.getWindow)():{},s=function(t){return setTimeout(t,1e3/60)},l=function(t){clearTimeout(t)},c=(0,o.default)((function(){var t=r.requestAnimationFrame||r.webkitRequestAnimationFrame||r.mozRequestAnimationFrame||r.oRequestAnimationFrame||r.msRequestAnimationFrame,e=r.cancelAnimationFrame||r.webkitCancelAnimationFrame||r.mozCancelAnimationFrame||r.oCancelAnimationFrame||r.msCancelAnimationFrame;t&&e&&(s=t,l=e)}))},87209:function(t,e,n){e.default=void 0;var i=y(n(68374)),a=n(58201),o=y(n(55994)),r=y(n(17381)),s=n(6415),l=n(13306),c=n(35922),u=n(95479),d=n(31648),h=n(23908),f=n(90057),p=n(60137),g=y(n(49387)),m=n(29007),_=n(39611),v=n(62754),b=n(20576);function y(t){return t&&t.__esModule?t:{default:t}}function x(t){return(x="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var w=(0,a.getWindow)(),k=(0,_.addNamespace)(m.removeEvent,"dxFX"),S=/^([+-])=(.*)/i,C={initAnimation:function(t,e){t.css({transitionProperty:"none"}),"string"==typeof e.from?t.addClass(e.from):W(t,e.from);var n=this,i=new v.Deferred,a=e.cleanupWhen;e.transitionAnimation={deferred:i,finish:function(){n._finishTransition(t),a?(0,v.when)(i,a).always((function(){n._cleanup(t,e)})):n._cleanup(t,e),i.resolveWith(t,[e,t])}},this._completeAnimationCallback(t,e).done((function(){e.transitionAnimation.finish()})).fail((function(){i.rejectWith(t,[e,t])})),e.duration||e.transitionAnimation.finish(),t.css("transform")},animate:function(t,e){return this._startAnimation(t,e),e.transitionAnimation.deferred.promise()},_completeAnimationCallback:function(t,e){var n,i=this,a=Date.now()+e.delay,r=new v.Deferred,s=new v.Deferred,l=new v.Deferred,c=(0,p.transitionEndEventName)()+".dxFX";e.transitionAnimation.cleanup=function(){clearTimeout(n),clearTimeout(u),o.default.off(t,c),o.default.off(t,k)},o.default.one(t,c,(function(){Date.now()-a>=e.duration&&s.reject()})),o.default.off(t,k),o.default.on(t,k,(function(){i.stop(t,e),r.reject()}));var u=setTimeout((function(){n=setTimeout((function(){l.reject()}),e.duration+e.delay+U._simulatedTransitionEndDelay),(0,v.when)(s,l).fail(function(){r.resolve()}.bind(this))}));return r.promise()},_startAnimation:function(t,e){t.css({transitionProperty:"all",transitionDelay:e.delay+"ms",transitionDuration:e.duration+"ms",transitionTimingFunction:e.easing}),"string"==typeof e.to?t[0].className+=" "+e.to:e.to&&W(t,e.to)},_finishTransition:function(t){t.css("transition","none")},_cleanup:function(t,e){e.transitionAnimation.cleanup(),"string"==typeof e.from&&(t.removeClass(e.from),t.removeClass(e.to))},stop:function(t,e,n){e&&(n?e.transitionAnimation.finish():((0,c.isPlainObject)(e.to)&&(0,u.each)(e.to,(function(e){t.css(e,t.css(e))})),this._finishTransition(t),this._cleanup(t,e)))}},A={initAnimation:function(t,e){W(t,e.from)},animate:function(t,e){var n=new v.Deferred,i=this;return e?((0,u.each)(e.to,(function(n){void 0===e.from[n]&&(e.from[n]=i._normalizeValue(t.css(n)))})),e.to.transform&&(e.from.transform=i._parseTransform(e.from.transform),e.to.transform=i._parseTransform(e.to.transform)),e.frameAnimation={to:e.to,from:e.from,currentValue:e.from,easing:(0,h.convertTransitionTimingFuncToEasing)(e.easing),duration:e.duration,startTime:(new Date).valueOf(),finish:function(){this.currentValue=this.to,this.draw(),(0,f.cancelAnimationFrame)(e.frameAnimation.animationFrameId),n.resolve()},draw:function(){if(e.draw)e.draw(this.currentValue);else{var n=(0,l.extend)({},this.currentValue);n.transform&&(n.transform=(0,u.map)(n.transform,(function(t,e){return"translate"===e?(0,d.getTranslateCss)(t):"scale"===e?"scale("+t+")":"rotate"===e.substr(0,e.length-1)?e+"("+t+"deg)":void 0})).join(" ")),t.css(n)}}},e.delay?(e.frameAnimation.startTime+=e.delay,e.frameAnimation.delayTimeout=setTimeout((function(){i._startAnimation(t,e)}),e.delay)):i._startAnimation(t,e),n.promise()):n.reject().promise()},_startAnimation:function(t,e){o.default.off(t,k),o.default.on(t,k,(function(){e.frameAnimation&&(0,f.cancelAnimationFrame)(e.frameAnimation.animationFrameId)})),this._animationStep(t,e)},_parseTransform:function(t){var e={};return(0,u.each)(t.match(/\w+\d*\w*\([^)]*\)\s*/g),(function(t,n){var i=(0,d.parseTranslate)(n),a=n.match(/scale\((.+?)\)/),o=n.match(/(rotate.)\((.+)deg\)/);i&&(e.translate=i),a&&a[1]&&(e.scale=parseFloat(a[1])),o&&o[1]&&(e[o[1]]=parseFloat(o[2]))})),e},stop:function(t,e,n){var i=e&&e.frameAnimation;i&&((0,f.cancelAnimationFrame)(i.animationFrameId),clearTimeout(i.delayTimeout),n&&i.finish(),delete e.frameAnimation)},_animationStep:function(t,e){var n=e&&e.frameAnimation;if(n){var i=(new Date).valueOf();if(i>=n.startTime+n.duration)n.finish();else{n.currentValue=this._calcStepValue(n,i-n.startTime),n.draw();var a=this;n.animationFrameId=(0,f.requestAnimationFrame)((function(){a._animationStep(t,e)}))}}},_calcStepValue:function(t,e){return function n(i,a){var o=Array.isArray(a)?[]:{};return(0,u.each)(a,(function(r,s){if("string"==typeof s&&!1===parseFloat(s))return!0;o[r]="object"===x(s)?n(i[r],s):function(n){var o=e/t.duration,r=e,s=1*i[n],l=a[n]-i[n],c=t.duration;return(0,h.getEasing)(t.easing)(o,r,s,l,c)}(r)})),o}(t.from,t.to)},_normalizeValue:function(t){var e=parseFloat(t);return!1===e?t:e}},E={initAnimation:function(){},animate:function(){return(new v.Deferred).resolve().promise()},stop:b.noop,isSynchronous:!0},T=function(t,e,n,i){(0,u.each)(["from","to"],(function(){if(!n(t[this]))throw r.default.Error("E0010",e,this,i)}))},I=function(t,e){return T(t,e,(function(t){return(0,c.isPlainObject)(t)}),"a plain object")},D={top:{my:"bottom center",at:"top center"},bottom:{my:"top center",at:"bottom center"},right:{my:"left center",at:"right center"},left:{my:"right center",at:"left center"}},O={validateConfig:function(t){I(t,"slide")},setup:function(t,e){var n=(0,d.locate)(t);if("slide"!==e.type){var i="slideIn"===e.type?e.from:e.to;i.position=(0,l.extend)({of:w},D[e.direction]),Z(t,i)}this._setUpConfig(n,e.from),this._setUpConfig(n,e.to),(0,d.clearCache)(t)},_setUpConfig:function(t,e){e.left="left"in e?e.left:"+=0",e.top="top"in e?e.top:"+=0",this._initNewPosition(t,e)},_initNewPosition:function(t,e){var n={left:e.left,top:e.top};delete e.left,delete e.top;var i=this._getRelativeValue(n.left);void 0!==i?n.left=i+t.left:e.left=0,void 0!==(i=this._getRelativeValue(n.top))?n.top=i+t.top:e.top=0,e.transform=(0,d.getTranslateCss)({x:n.left,y:n.top})},_getRelativeValue:function(t){var e;if("string"==typeof t&&(e=S.exec(t)))return parseInt(e[1]+"1")*e[2]}},L={setup:function(t,e){var n,i,a=e.from,o=e.to,r="fadeOut"===e.type?1:0,s="fadeOut"===e.type?0:1,l=(0,c.isPlainObject)(a)?String(null!==(n=a.opacity)&&void 0!==n?n:r):String(a),u=(0,c.isPlainObject)(o)?String(null!==(i=o.opacity)&&void 0!==i?i:s):String(o);switch(e.skipElementInitialStyles||(l=t.css("opacity")),e.type){case"fadeIn":u=1;break;case"fadeOut":u=0}e.from={visibility:"visible",opacity:l},e.to={opacity:u}}},M={custom:{setup:function(){}},slide:O,slideIn:O,slideOut:O,fade:L,fadeIn:L,fadeOut:L,pop:{validateConfig:function(t){I(t,"pop")},setup:function(t,e){var n=e.from,i=e.to,a="opacity"in n?n.opacity:t.css("opacity"),o="opacity"in i?i.opacity:1,r="scale"in n?n.scale:0,s="scale"in i?i.scale:1;e.from={opacity:a};var l=(0,d.getTranslate)(t);e.from.transform=this._getCssTransform(l,r),e.to={opacity:o},e.to.transform=this._getCssTransform(l,s)},_getCssTransform:function(t,e){return(0,d.getTranslateCss)(t)+"scale("+e+")"}},css:{validateConfig:function(t){!function(t,e){T(t,e,(function(t){return"string"==typeof t}),"a string")}(t,"css")},setup:function(){}}},P={type:"custom",from:{},to:{},duration:400,start:b.noop,complete:b.noop,easing:"ease",delay:0},R={duration:400,easing:"ease",delay:0};function B(){var t=this.element,e=this.config;if(Z(t,e.from),Z(t,e.to),this.configurator.setup(t,e),t.data("dxAnimData",this),U.off&&(e.duration=0,e.delay=0),this.strategy.initAnimation(t,e),e.start){var n=(0,s.getPublicElement)(t);e.start.apply(this,[n,e])}}var z=function(){var t=this,e=t.element,n=t.config;return t.isStarted=!0,t.strategy.animate(e,n).done((function(){!function(t){var e=t.element,n=t.config;if(e.removeData("dxAnimData"),n.complete){var i=(0,s.getPublicElement)(e);n.complete.apply(this,[i,n])}t.deferred.resolveWith(this,[e,n])}(t)})).fail((function(){t.deferred.rejectWith(this,[e,n])}))},q=function(t){var e=this.element,n=this.config;clearTimeout(this.startTimeout),this.isStarted||this.start(),this.strategy.stop(e,n,t)},V=(0,_.addNamespace)(m.removeEvent,"dxFXStartAnimation"),F=function(t,e){var n="css"===e.type?R:P,a=(0,l.extend)(!0,{},n,e),s=function(t){var e=M[t.type];if(!e)throw r.default.Error("E0011",t.type);return e}(a),u=function(t){t=t||{};var e={transition:(0,p.transition)()?C:A,frame:A,noAnimation:E},n=t.strategy||"transition";return"css"!==t.type||(0,p.transition)()||(n="noAnimation"),e[n]}(a),d={element:(0,i.default)(t),config:a,configurator:s,strategy:u,isSynchronous:u.isSynchronous,setup:B,start:z,stop:q,deferred:new v.Deferred};return(0,c.isFunction)(s.validateConfig)&&s.validateConfig(a),function(t){o.default.off(t.element,V),o.default.on(t.element,V,(function(){U.stop(t.element)})),t.deferred.always((function(){o.default.off(t.element,V)}))}(d),d};function H(t){return t.data("dxAnimQueue")||[]}var N=function(t){t.removeData("dxAnimQueue")};function j(t){return!!t.data("dxAnimData")}function G(t,e){if((e=H(t)).length){var n=e.shift();0===e.length&&N(t),function(t){t.setup(),U.off||t.isSynchronous?t.start():t.startTimeout=setTimeout((function(){t.start()}));return t.deferred.promise()}(n).done((function(){j(t)||G(t)}))}}function Z(t,e){if(e&&e.position){var n=(0,i.default)(w),a=0,o=0,r=g.default.calculate(t,e.position),s=t.offset(),c=t.position();c.top>s.top&&(o=n.scrollTop()),c.left>s.left&&(a=n.scrollLeft()),(0,l.extend)(e,{left:r.h.location-s.left+c.left-a,top:r.v.location-s.top+c.top-o}),delete e.position}}function W(t,e){(0,u.each)(e,(function(e,n){try{t.css(e,(0,c.isFunction)(n)?n():n)}catch(t){}}))}var U={off:!1,animationTypes:M,animate:function(t,e){var n=(0,i.default)(t);if(!n.length)return(new v.Deferred).resolve().promise();var a=F(n,e);return function(t,e){var n=H(t);(function(t,e){t.data("dxAnimQueue",e)})(t,n),n.push(e),j(t)||G(t,n)}(n,a),a.deferred.promise()},createAnimation:F,isAnimating:j,stop:function(t,e){var n=(0,i.default)(t),a=H(n);(0,u.each)(a,(function(t,e){e.config.delay=0,e.config.duration=0,e.isSynchronous=!0})),j(n)||G(n,a);var o=n.data("dxAnimData");o&&o.stop(e),n.removeData("dxAnimData"),N(n)},_simulatedTransitionEndDelay:100},K=U;e.default=K,t.exports=e.default,t.exports.default=e.default},49387:function(t,e,n){e.default=void 0;var i=n(58664),a=_(n(68374)),o=n(20576),r=n(95479),s=n(58201),l=_(n(73349)),c=n(35922),u=n(13306),d=n(37518),h=_(n(47810)),f=n(31648),p=n(60137),g=_(n(20530)),m=n(80968);function _(t){return t&&t.__esModule?t:{default:t}}var v,b=(0,s.getWindow)(),y=/left|right/,x=/top|bottom/,w=/fit|flip|none/,k=/scale\(.+?\)/,S=h.default.safari,C=function(t){var e={h:"center",v:"center"},n=(0,o.splitPair)(t);return n&&(0,r.each)(n,(function(){var t=String(this).toLowerCase();y.test(t)?e.h=t:x.test(t)&&(e.v=t)})),e},A=function(t,e){return(0,o.pairToObject)(t,e)},E=function(t){switch(t){case"center":return.5;case"right":case"bottom":return 1;default:return 0}},T=function(t){switch(t){case"left":return"right";case"right":return"left";case"top":return"bottom";case"bottom":return"top";default:return t}},I=function(t,e){var n=0;return t.myLocation<e.min&&(n+=e.min-t.myLocation),t.myLocation>e.max&&(n+=t.myLocation-e.max),n},D=function(t,e,n){return e.myLocation<n.min?"h"===t?"left":"top":e.myLocation>n.max?"h"===t?"right":"bottom":"none"},O=function(t){t.myLocation=t.atLocation+E(t.atAlign)*t.atSize-E(t.myAlign)*t.mySize+t.offset},L={fit:function(t,e){var n=!1;t.myLocation>e.max&&(t.myLocation=e.max,n=!0),t.myLocation<e.min&&(t.myLocation=e.min,n=!0),t.fit=n},flip:function(t,e){if(t.flip=!1,("center"!==t.myAlign||"center"!==t.atAlign)&&(t.myLocation<e.min||t.myLocation>e.max)){var n=(0,u.extend)({},t,{myAlign:T(t.myAlign),atAlign:T(t.atAlign),offset:-t.offset});O(n),n.oversize=I(n,e),(n.myLocation>=e.min&&n.myLocation<=e.max||t.oversize>n.oversize)&&(t.myLocation=n.myLocation,t.oversize=n.oversize,t.flip=!0)}},flipfit:function(t,e){this.flip(t,e),this.fit(t,e)},none:function(t){t.oversize=0}},M=function(){var t=(0,a.default)("<div>").css({width:100,height:100,overflow:"scroll",position:"absolute",top:-9999}).appendTo((0,a.default)("body")),e=t.get(0).offsetWidth-t.get(0).clientWidth;t.remove(),v=e},P={h:{location:0,flip:!1,fit:!1,oversize:0},v:{location:0,flip:!1,fit:!1,oversize:0}},R=function(t,e){var n=(0,a.default)(t),r=n.offset(),s=(0,u.extend)(!0,{},P,{h:{location:r.left},v:{location:r.top}});if(!e)return s;var h=C(e.my),f=C(e.at),m=(0,a.default)(e.of).length&&e.of||b,_=A(e.offset,e.precise),y=function(t){var e=(0,o.splitPair)(t),n=String(e&&e[0]).toLowerCase(),i=String(e&&e[1]).toLowerCase();return w.test(n)||(n="none"),w.test(i)||(i=n),{h:n,v:i}}(e.collision),x=e.boundary,k=A(e.boundaryOffset,e.precise),E={mySize:(0,i.getOuterWidth)(n),myAlign:h.h,atAlign:f.h,offset:_.h,collision:y.h,boundaryOffset:k.h},T={mySize:(0,i.getOuterHeight)(n),myAlign:h.v,atAlign:f.v,offset:_.v,collision:y.v,boundaryOffset:k.v};if(m.preventDefault)E.atLocation=m.pageX,T.atLocation=m.pageY,E.atSize=0,T.atSize=0;else if(m=(0,a.default)(m),(0,c.isWindow)(m[0]))E.atLocation=m.scrollLeft(),T.atLocation=m.scrollTop(),"phone"===g.default.real().deviceType&&m[0].visualViewport?(E.atLocation=Math.max(E.atLocation,m[0].visualViewport.offsetLeft),T.atLocation=Math.max(T.atLocation,m[0].visualViewport.offsetTop),E.atSize=m[0].visualViewport.width,T.atSize=m[0].visualViewport.height):(E.atSize=m[0].innerWidth>m[0].outerWidth?m[0].innerWidth:(0,i.getWidth)(m),T.atSize=m[0].innerHeight>m[0].outerHeight||S?m[0].innerHeight:(0,i.getHeight)(m));else if(9===m[0].nodeType)E.atLocation=0,T.atLocation=0,E.atSize=(0,i.getWidth)(m),T.atSize=(0,i.getHeight)(m);else{var R=(0,d.getBoundingRect)(m.get(0)),B=z(m);E.atLocation=B.left,T.atLocation=B.top,E.atSize=Math.max(R.width,(0,i.getOuterWidth)(m)),T.atSize=Math.max(R.height,(0,i.getOuterHeight)(m))}O(E),O(T);var q=function(){var t=(0,a.default)(b),e=(0,i.getWidth)(t),n=(0,i.getHeight)(t),o=t.scrollLeft(),r=t.scrollTop(),s=l.default.getDocumentElement(),u=p.touch?s.clientWidth/e:1,d=p.touch?s.clientHeight/n:1;void 0===v&&M();var h=e,f=n;if(x&&!(0,c.isWindow)(x)){var g=(0,a.default)(x),m=g.offset();o=m.left,r=m.top,h=(0,i.getWidth)(g),f=(0,i.getHeight)(g)}return{h:{min:o+E.boundaryOffset,max:o+h/u-E.mySize-E.boundaryOffset},v:{min:r+T.boundaryOffset,max:r+f/d-T.mySize-T.boundaryOffset}}}();E.oversize=I(E,q.h),T.oversize=I(T,q.v),E.collisionSide=D("h",E,q.h),T.collisionSide=D("v",T,q.v),L[E.collision]&&L[E.collision](E,q.h),L[T.collision]&&L[T.collision](T,q.v);var V=function(t){return e.precise?t:Math.round(t)};return(0,u.extend)(!0,s,{h:{location:V(E.myLocation),oversize:V(E.oversize),fit:E.fit,flip:E.flip,collisionSide:E.collisionSide},v:{location:V(T.myLocation),oversize:V(T.oversize),fit:T.fit,flip:T.flip,collisionSide:T.collisionSide},precise:e.precise}),s},B=function(t,e,n,i){var a=(0,c.isDefined)(t.style)&&!l.default.isNode(t.style),o=i?n.replace(e,""):n;if(a)(0,m.setStyle)(t,o,!1);else{var r=l.default.createAttribute("style");r.value=o,t.setAttributeNode(r)}},z=function t(e){var n,i,a=arguments.length>1&&void 0!==arguments[1]?arguments[1]:e,o=a.get(0);if(!o)return e.offset();var r,s=(null===(n=o.getAttribute)||void 0===n?void 0:n.call(o,"style"))||"",l=null===(i=s.match(k))||void 0===i?void 0:i[0];return l?(B(o,l,s,!0),r=t(e,a.parent()),B(o,l,s,!1)):r=t(e,a.parent()),r},q=function(t,e){var n=(0,a.default)(t);if(!e)return n.offset();(0,f.resetPosition)(n,!0);var i=z(n),o=e.h&&e.v?e:R(n,e),r=function(t){return e.precise?t:Math.round(t)};return(0,f.move)(n,{left:o.h.location-r(i.left),top:o.v.location-r(i.top)}),o};q.inverseAlign||(q.inverseAlign=T),q.normalizeAlign||(q.normalizeAlign=C);var V={calculateScrollbarWidth:M,calculate:R,setup:q,offset:function(t){return t=(0,a.default)(t).get(0),(0,c.isWindow)(t)?null:t&&"pageY"in t&&"pageX"in t?{top:t.pageY,left:t.pageX}:(0,a.default)(t).offset()}};e.default=V,t.exports=e.default,t.exports.default=e.default},42814:function(t,e,n){e.presets=e.PresetCollection=void 0;var i=n(58664),a=n(44297),o=n(95479),r=n(13306),s=c(n(20530)),l=c(n(87209));function c(t){return t&&t.__esModule?t:{default:t}}var u={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},d=a.Component.inherit({ctor:function(){this.callBase.apply(this,arguments),this._registeredPresets=[],this.resetToDefaults()},_getDefaultOptions:function(){return(0,r.extend)(this.callBase(),{defaultAnimationDuration:400,defaultAnimationDelay:0,defaultStaggerAnimationDuration:300,defaultStaggerAnimationDelay:40,defaultStaggerAnimationStartDelay:500})},_defaultOptionsRules:function(){return this.callBase().concat([{device:function(t){return t.phone},options:{defaultStaggerAnimationDuration:350,defaultStaggerAnimationDelay:50,defaultStaggerAnimationStartDelay:0}},{device:function(){return s.default.current().android||s.default.real.android},options:{defaultAnimationDelay:100}}])},_getPresetOptionName:function(t){return"preset_"+t},_createAndroidSlideAnimationConfig:function(t,e){var n=this,a=function(t){return{type:"slide",delay:void 0===t.delay?n.option("defaultAnimationDelay"):t.delay,duration:void 0===t.duration?n.option("defaultAnimationDuration"):t.duration}};return{enter:function(n,o){var r=(0,i.getWidth)(n.parent())*e,s=o.direction,c=a(o);return c.to={left:0,opacity:1},c.from="forward"===s?{left:r,opacity:t}:"backward"===s?{left:-r,opacity:t}:{left:0,opacity:0},l.default.createAnimation(n,c)},leave:function(n,o){var r=(0,i.getWidth)(n.parent())*e,s=o.direction,c=a(o);return c.from={left:0,opacity:1},c.to="forward"===s?{left:-r,opacity:t}:"backward"===s?{left:r,opacity:t}:{left:0,opacity:0},l.default.createAnimation(n,c)}}},_createOpenDoorConfig:function(){var t=this,e=function(e){return{type:"css",extraCssClasses:"dx-opendoor-animation",delay:void 0===e.delay?t.option("defaultAnimationDelay"):e.delay,duration:void 0===e.duration?t.option("defaultAnimationDuration"):e.duration}};return{enter:function(t,n){var i=n.direction,a=e(n);return a.delay="none"===i?a.delay:a.duration,a.from="dx-enter dx-opendoor-animation"+u[i],a.to="dx-enter-active",l.default.createAnimation(t,a)},leave:function(t,n){var i=n.direction,a=e(n);return a.from="dx-leave dx-opendoor-animation"+u[i],a.to="dx-leave-active",l.default.createAnimation(t,a)}}},_createWinPopConfig:function(){var t=this,e={type:"css",extraCssClasses:"dx-win-pop-animation",duration:t.option("defaultAnimationDuration")};return{enter:function(n,i){var a=e,o=i.direction;return a.delay="none"===o?t.option("defaultAnimationDelay"):t.option("defaultAnimationDuration")/2,a.from="dx-enter dx-win-pop-animation"+u[o],a.to="dx-enter-active",l.default.createAnimation(n,a)},leave:function(n,i){var a=e,o=i.direction;return a.delay=t.option("defaultAnimationDelay"),a.from="dx-leave dx-win-pop-animation"+u[o],a.to="dx-leave-active",l.default.createAnimation(n,a)}}},resetToDefaults:function(){this.clear(),this.registerDefaultPresets(),this.applyChanges()},clear:function(t){var e=this,n=[];(0,o.each)(this._registeredPresets,(function(i,a){t&&t!==a.name?n.push(a):e.option(e._getPresetOptionName(a.name),void 0)})),this._registeredPresets=n,this.applyChanges()},registerPreset:function(t,e){this._registeredPresets.push({name:t,config:e})},applyChanges:function(){var t=this,e=[];(0,o.each)(this._registeredPresets,(function(n,i){var a={device:i.config.device,options:{}};a.options[t._getPresetOptionName(i.name)]=i.config.animation,e.push(a)})),this._setOptionsByDevice(e)},getPreset:function(t){for(var e=t;"string"==typeof e;)e=this.option(this._getPresetOptionName(e));return e},registerDefaultPresets:function(){this.registerPreset("pop",{animation:{extraCssClasses:"dx-android-pop-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("openDoor",{animation:this._createOpenDoorConfig()}),this.registerPreset("win-pop",{animation:this._createWinPopConfig()}),this.registerPreset("fade",{animation:{extraCssClasses:"dx-fade-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("slide",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(1,1)}),this.registerPreset("slide",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-slide",{animation:{extraCssClasses:"dx-ios7-slide-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("overflow",{animation:{extraCssClasses:"dx-overflow-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return!s.default.current().android&&!s.default.real.android},animation:{extraCssClasses:"dx-ios7-toolbar-animation",delay:this.option("defaultAnimationDelay"),duration:this.option("defaultAnimationDuration")}}),this.registerPreset("ios7-toolbar",{device:function(){return s.default.current().android||s.default.real.android},animation:this._createAndroidSlideAnimationConfig(0,.4)}),this.registerPreset("stagger-fade",{animation:{extraCssClasses:"dx-fade-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-slide",{animation:{extraCssClasses:"dx-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-slide",{animation:{extraCssClasses:"dx-fade-slide-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-drop",{animation:{extraCssClasses:"dx-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-drop",{animation:{extraCssClasses:"dx-fade-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-rise",{animation:{extraCssClasses:"dx-fade-rise-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-3d-drop",{animation:{extraCssClasses:"dx-3d-drop-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}}),this.registerPreset("stagger-fade-zoom",{animation:{extraCssClasses:"dx-fade-zoom-animation",staggerDelay:this.option("defaultStaggerAnimationDelay"),duration:this.option("defaultStaggerAnimationDuration"),delay:this.option("defaultStaggerAnimationStartDelay")}})}});e.PresetCollection=d;var h=new d;e.presets=h},52431:function(t,e,n){e.TransitionExecutor=void 0;var i=h(n(68374)),a=h(n(38377)),o=n(13306),r=n(20576),s=n(35922),l=n(95479),c=h(n(87209)),u=n(42814),d=n(62754);function h(t){return t&&t.__esModule?t:{default:t}}var f={forward:" dx-forward",backward:" dx-backward",none:" dx-no-direction",undefined:" dx-no-direction"},p=a.default.inherit({ctor:function(){this._accumulatedDelays={enter:0,leave:0},this._animations=[],this.reset()},_createAnimations:function(t,e,n,a){t=(0,i.default)(t);var o=this,r=[];n=n||{};var s=this._prepareElementAnimationConfig(e,n,a);return s&&t.each((function(){var t=o._createAnimation((0,i.default)(this),s,n);t&&(t.element.addClass("dx-animating"),t.setup(),r.push(t))})),r},_prepareElementAnimationConfig:function(t,e,n){var i;if("string"==typeof t){var a=t;t=u.presets.getPreset(a)}if(t)if((0,s.isFunction)(t[n]))i=t[n];else{if(!(i=(0,o.extend)({skipElementInitialStyles:!0,cleanupWhen:this._completePromise},t,e)).type||"css"===i.type){var r="dx-"+n,l=(i.extraCssClasses?" "+i.extraCssClasses:"")+f[i.direction];i.type="css",i.from=(i.from||r)+l,i.to=i.to||r+"-active"}i.staggerDelay=i.staggerDelay||0,i.delay=i.delay||0,i.staggerDelay&&(i.delay+=this._accumulatedDelays[n],this._accumulatedDelays[n]+=i.staggerDelay)}else i=void 0;return i},_createAnimation:function(t,e,n){var i;return(0,s.isPlainObject)(e)?i=c.default.createAnimation(t,e):(0,s.isFunction)(e)&&(i=e(t,n)),i},_startAnimations:function(){for(var t=this._animations,e=0;e<t.length;e++)t[e].start()},_stopAnimations:function(t){for(var e=this._animations,n=0;n<e.length;n++)e[n].stop(t)},_clearAnimations:function(){for(var t=this._animations,e=0;e<t.length;e++)t[e].element.removeClass("dx-animating");this._animations.length=0},reset:function(){this._accumulatedDelays.enter=0,this._accumulatedDelays.leave=0,this._clearAnimations(),this._completeDeferred=new d.Deferred,this._completePromise=this._completeDeferred.promise()},enter:function(t,e,n){var i=this._createAnimations(t,e,n,"enter");this._animations.push.apply(this._animations,i)},leave:function(t,e,n){var i=this._createAnimations(t,e,n,"leave");this._animations.push.apply(this._animations,i)},start:function(){var t,e=this;if(this._animations.length){var n=(0,l.map)(this._animations,(function(t){var e=new d.Deferred;return t.deferred.always((function(){e.resolve()})),e.promise()}));t=d.when.apply(i.default,n).always((function(){e._completeDeferred.resolve(),e.reset()})),(0,r.executeAsync)((function(){e._startAnimations()}))}else e.reset(),t=(new d.Deferred).resolve().promise();return t},stop:function(t){this._stopAnimations(t)}});e.TransitionExecutor=p},31648:function(t,e,n){e.resetPosition=e.parseTranslate=e.move=e.locate=e.getTranslateCss=e.getTranslate=e.clearCache=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i},o=n(97906),r=n(35922);var s=/matrix(3d)?\((.+?)\)/,l=/translate(?:3d)?\((.+?)\)/;function c(t){return"string"===(0,r.type)(t)&&"%"===t[t.length-1]}function u(t,e){t.length&&(0,o.data)(t.get(0),"dxTranslator",e)}e.locate=function(t){t=(0,a.default)(t);var e=f(t);return{left:e.x,top:e.y}};var d=function(t){t.length&&(0,o.removeData)(t.get(0),"dxTranslator")};e.clearCache=d;var h=function(t){return t.x=t.x||0,t.y=t.y||0,"translate("+(c(t.x)?t.x:t.x+"px")+", "+(c(t.y)?t.y:t.y+"px")+")"};e.getTranslateCss=h;var f=function(t){var e=t.length?(0,o.data)(t.get(0),"dxTranslator"):null;if(!e){var n=(t.css("transform")||h({x:0,y:0})).match(s),i=n&&n[1];n?(n=n[2].split(","),"3d"===i?n=n.slice(12,15):(n.push(0),n=n.slice(4,7))):n=[0,0,0],u(t,e={x:parseFloat(n[0]),y:parseFloat(n[1]),z:parseFloat(n[2])})}return e};e.getTranslate=f;e.move=function(t,e){t=(0,a.default)(t);var n,i=e.left,o=e.top;void 0===i?(n=f(t)).y=o||0:void 0===o?(n=f(t)).x=i||0:u(t,n={x:i||0,y:o||0,z:0}),t.css({transform:h(n)}),(c(i)||c(o))&&d(t)};e.resetPosition=function(t,e){var n;t=(0,a.default)(t);var i={left:0,top:0,transform:"none"};e&&(n=t.css("transition"),i.transition="none"),t.css(i),d(t),e&&(t.get(0).offsetHeight,t.css("transition",n))};e.parseTranslate=function(t){var e=t.match(l);if(e&&e[1])return e=e[1].split(","),e={x:parseFloat(e[0]),y:parseFloat(e[1]),z:parseFloat(e[2])}}},72505:function(t,e,n){var i=n(36991);i.common=i.common||{},i.common.charts=n(29932),t.exports=i.common.charts},36991:function(t,e,n){var i=n(58201).getWindow(),a=i.DevExpress=i.DevExpress||{},o=a.errors=n(17381);if(a._DEVEXTREME_BUNDLE_INITIALIZED)throw o.Error("E0024");a._DEVEXTREME_BUNDLE_INITIALIZED=!0,a.clientExporter=n(78292),a.excelExporter=n(2994),a.pdfExporter=n(44194),a.VERSION=n(36739).version,a.Class=n(38377),a.DOMComponent=n(13046),a.Component=n(44297).Component,a.registerComponent=n(99393),a.devices=n(20530),a.Color=n(52752);var r=n(90057);a.utils={},a.utils.requestAnimationFrame=r.requestAnimationFrame,a.utils.cancelAnimationFrame=r.cancelAnimationFrame,a.utils.initMobileViewport=n(88185).p,a.utils.getTimeZones=n(88673).Z,a.utils.extendFromObject=n(13306).extendFromObject,a.utils.triggerShownEvent=n(80506).triggerShownEvent,a.utils.triggerHidingEvent=n(80506).triggerHidingEvent,a.utils.resetActiveElement=n(3532).resetActiveElement,a.utils.findBestMatches=n(20576).findBestMatches,a.createQueue=n(59504).create,a.utils.dom=n(3532),a.utils.common=n(20576),a.utils.date=n(91198),a.utils.browser=n(47810),a.utils.inflector=n(78008),a.utils.iterator=n(95479),a.utils.readyCallbacks=n(24311),a.utils.resizeCallbacks=n(55814),a.utils.console=n(30869),a.utils.string=n(68752),a.utils.support=n(60137),a.utils.ajax=n(37208),a.viewPort=n(77695).value,a.hideTopOverlay=n(60628),a.formatHelper=n(30343),a.config=n(80209),a.animationPresets=n(42814).presets,a.fx=n(87209),a.TransitionExecutor=n(52431).TransitionExecutor,a.AnimationPresetCollection=n(42814).PresetCollection,a.events=n(66365),a.events.click=n(95429),a.events.utils=n(39611),a.events.GestureEmitter=n(98621),a.localization=n(94484),a.templateRendered=n(81033).renderedCallbacks,a.setTemplateEngine=n(72987).setTemplateEngine,t.exports=a},86635:function(t,e,n){var i=n(36991),a=n(17381);t.exports=i.data=i.data||{},Object.defineProperty(i.data,"errorHandler",{get:function(){return n(18438).errorHandler},set:function(t){a.log("W0003","DevExpress.data","errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(t)}}),Object.defineProperty(i.data,"_errorHandler",{get:function(){return n(18438).handleError},set:function(t){a.log("W0003","DevExpress.data","_errorHandler","21.1","Use the 'setErrorHandler' method instead"),n(18438).setErrorHandler(t)}}),i.data.setErrorHandler=n(18438).setErrorHandler,i.data.DataSource=n(33546),i.data.query=n(96687),i.data.Store=n(67403),i.data.ArrayStore=n(26562),i.data.CustomStore=n(88036),i.data.LocalStore=n(82837),i.data.base64_encode=n(16454).base64_encode,i.data.applyChanges=n(36893),i.data.Guid=n(73176),i.data.utils={},i.data.utils.compileGetter=n(47617).compileGetter,i.data.utils.compileSetter=n(47617).compileSetter,i.EndpointSelector=n(8162),i.data.queryImpl=n(77549).queryImpl,i.data.queryAdapters=n(16135);var o=n(16454);i.data.utils.normalizeBinaryCriterion=o.normalizeBinaryCriterion,i.data.utils.normalizeSortingInfo=o.normalizeSortingInfo,i.data.utils.errorMessageFromXhr=o.errorMessageFromXhr,i.data.utils.aggregators=o.aggregators,i.data.utils.keysEqual=o.keysEqual,i.data.utils.isDisjunctiveOperator=o.isDisjunctiveOperator,i.data.utils.isConjunctiveOperator=o.isConjunctiveOperator,i.data.utils.processRequestResultLock=o.processRequestResultLock,i.data.utils.toComparable=n(47617).toComparable,i.data.utils.multiLevelGroup=n(99236).multiLevelGroup,i.data.utils.arrangeSortingInfo=n(99236).arrangeSortingInfo,i.data.utils.normalizeDataSourceOptions=n(9234).normalizeDataSourceOptions},72343:function(t,e,n){n(86635),DevExpress.data.ODataStore=n(341),DevExpress.data.ODataContext=n(47256),DevExpress.data.utils=DevExpress.data.utils||{},DevExpress.data.utils.odata={},DevExpress.data.utils.odata.keyConverters=n(77869).keyConverters,DevExpress.data.EdmLiteral=n(77869).EdmLiteral;var i=n(77869);DevExpress.data.utils.odata.serializePropName=i.serializePropName,DevExpress.data.utils.odata.serializeValue=i.serializeValue,DevExpress.data.utils.odata.serializeKey=i.serializeKey,DevExpress.data.utils.odata.sendRequest=i.sendRequest,DevExpress.data.queryAdapters=DevExpress.data.queryAdapters||{},DevExpress.data.queryAdapters.odata=n(54263).odata},85357:function(t,e,n){var i=n(36991);n(78475),n(71582),n(49281),n(74872),n(46949),n(908),n(60316),n(7239),n(95429),n(49166),n(85272),n(23174),n(11699),n(24028),n(93786),n(34309),n(91093),t.exports=i},94620:function(t,e,n){var i=n(85357).data=n(86635);i.odata=n(72343),t.exports=i},66312:function(t,e,n){var i=n(85357);n(94620),n(72505);var a=i.viz=n(20802);a.currentTheme=n(86231).currentTheme,a.registerTheme=n(86231).registerTheme,a.exportFromMarkup=n(5259).exportFromMarkup,a.getMarkup=n(5259).getMarkup,a.exportWidgets=n(5259).exportWidgets,a.currentPalette=n(23696).currentPalette,a.getPalette=n(23696).getPalette,a.generateColors=n(23696).generateColors,a.registerPalette=n(23696).registerPalette,a.refreshTheme=n(86231).refreshTheme,a.dxChart=n(99511),a.dxPieChart=n(72111),a.dxPolarChart=n(80919),a.dxLinearGauge=n(99630),a.dxCircularGauge=n(39847),a.dxBarGauge=n(45888),a.dxRangeSelector=n(82879),a.dxVectorMap=n(81849),a.map={},a.map.sources={},a.map.projection=n(102).projection,a.dxSparkline=n(43759),a.dxBullet=n(88950),a.dxTreeMap=n(15584),a.dxFunnel=n(30187),a.dxSankey=n(34377),a.getTheme=n(86231).getTheme,a.findTheme=n(86231).getTheme,a.refreshAll=n(86231).refreshTheme,a.refreshPaths=n(34434).refreshPaths,a.gauges={__internals:{}},a._dashboard={},a._dashboard.Renderer=n(56453).Renderer,a._dashboard.SvgElement=n(56453).SvgElement,a._dashboard.patchFontOptions=n(19157).patchFontOptions,t.exports=a},20802:function(t,e,n){n(36991),t.exports=DevExpress.viz=DevExpress.viz||{}},52752:function(t,e){e.default=void 0;var n={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},i=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10)]}},{re:/^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,process:function(t){return[parseInt(t[1],10),parseInt(t[2],10),parseInt(t[3],10),parseFloat(t[4])]}},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16)]}},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:function(t){return[parseInt(t[1],16),parseInt(t[2],16),parseInt(t[3],16),Number((parseInt(t[4],16)/255).toFixed(2))]}},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16),Number((parseInt(t[4]+t[4],16)/255).toFixed(2))]}},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:function(t){return[parseInt(t[1]+t[1],16),parseInt(t[2]+t[2],16),parseInt(t[3]+t[3],16)]}},{re:/^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(t){var e=parseInt(t[1],10),n=parseInt(t[2],10),i=parseInt(t[3],10),a=s(e,n,i);return[a[0],a[1],a[2],1,[e,n,i]]}},{re:/^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:function(t){var e=parseInt(t[1],10),n=parseInt(t[2],10),i=parseInt(t[3],10),a=u(e,n,i);return[a[0],a[1],a[2],1,null,[e,n,i]]}}],a=Math.round;function o(t){var e;this.baseColor=t,t&&(e=String(t).toLowerCase().replace(/ /g,""),e=function(t){if("transparent"===t)return[0,0,0,0];for(var e,n=0,a=i.length;n<a;++n)if(e=i[n].re.exec(t))return i[n].process(e);return null}(e=n[e]?"#"+n[e]:e)),e||(this.colorIsInvalid=!0),e=e||{},this.r=r(e[0]),this.g=r(e[1]),this.b=r(e[2]),this.a=r(e[3],1,1),e[4]?this.hsv={h:e[4][0],s:e[4][1],v:e[4][2]}:this.hsv=function(t,e,n){var i,a,o=Math.max(t,e,n),r=Math.min(t,e,n),s=o-r,l=o;if(a=0===o?0:1-r/o,o===r)i=0;else switch(o){case t:i=(e-n)/s*60,e<n&&(i+=360);break;case e:i=(n-t)/s*60+120;break;case n:i=(t-e)/s*60+240}return a*=100,l*=100/255,{h:Math.round(i),s:Math.round(a),v:Math.round(l)}}(this.r,this.g,this.b),e[5]?this.hsl={h:e[5][0],s:e[5][1],l:e[5][2]}:this.hsl=function(t,e,n){t=d(t,255),e=d(e,255),n=d(n,255);var i,o,r=Math.max(t,e,n),s=Math.min(t,e,n),l=r+s,c=l/2;if(r===s)i=o=0;else{var u=r-s;o=c>.5?u/(2-l):u/l,i=function(t,e,n,i){switch(Math.max(t,e,n)){case t:return(e-n)/i+(e<n?6:0);case e:return(n-t)/i+2;case n:return(t-e)/i+4}}(t,e,n,u),i/=6}return{h:a(360*i),s:a(100*o),l:a(100*c)}}(this.r,this.g,this.b)}function r(t,e,n){return e=e||0,n=n||255,t<0||isNaN(t)?e:t>n?n:t}function s(t,e,n){var i,a,o,r=(100-e)*n/100,s=t%60/60*(n-r),l=r+s,c=n-s;switch(Math.floor(t%360/60)){case 0:i=n,a=l,o=r;break;case 1:i=c,a=n,o=r;break;case 2:i=r,a=n,o=l;break;case 3:i=r,a=c,o=n;break;case 4:i=l,a=r,o=n;break;case 5:i=n,a=r,o=c}return[Math.round(2.55*i),Math.round(2.55*a),Math.round(2.55*o)]}function l(t,e){var n=e;return"r"===t&&(n=e+1/3),"b"===t&&(n=e-1/3),n}function c(t,e,n){return(n=function(t){return t<0&&(t+=1),t>1&&(t-=1),t}(n))<1/6?t+6*(e-t)*n:n<.5?e:n<2/3?t+(e-t)*(2/3-n)*6:t}function u(t,e,n){var i,o,r;if(t=d(t,360),e=d(e,100),n=d(n,100),0===e)i=o=r=n;else{var s=n<.5?n*(1+e):n+e-n*e,u=2*n-s;i=c(u,s,l("r",t)),o=c(u,s,l("g",t)),r=c(u,s,l("b",t))}return[a(255*i),a(255*o),a(255*r)]}function d(t,e){return t=Math.min(e,Math.max(0,parseFloat(t))),Math.abs(t-e)<1e-6?1:t%e/parseFloat(e)}function h(t,e,n){return e=e||0,n=n||255,!(t%1!=0||t<e||t>n||"number"!=typeof t||isNaN(t))}o.prototype={constructor:o,highlight:function(t){return t=t||10,this.alter(t).toHex()},darken:function(t){return t=t||10,this.alter(-t).toHex()},alter:function(t){var e=new o;return e.r=r(this.r+t),e.g=r(this.g+t),e.b=r(this.b+t),e},blend:function(t,e){var n=t instanceof o?t:new o(t),i=new o;return i.r=r(a(this.r*(1-e)+n.r*e)),i.g=r(a(this.g*(1-e)+n.g*e)),i.b=r(a(this.b*(1-e)+n.b*e)),i},toHex:function(){return t=this.r,e=this.g,n=this.b,"#"+(16777216|t<<16|e<<8|n).toString(16).slice(1);var t,e,n},getPureColor:function(){return new o("rgb("+s(this.hsv.h,100,100).join(",")+")")},isValidHex:function(t){return/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(t)},isValidRGB:function(t,e,n){return!!(h(t)&&h(e)&&h(n))},isValidAlpha:function(t){return!(isNaN(t)||t<0||t>1||"number"!=typeof t)},colorIsInvalid:!1,fromHSL:function(t){var e=new o,n=u(t.h,t.s,t.l);return e.r=n[0],e.g=n[1],e.b=n[2],e}};var f=o;e.default=f,t.exports=e.default,t.exports.default=e.default},29932:function(t,e,n){Object.defineProperty(e,"registerGradient",{enumerable:!0,get:function(){return i.registerGradient}}),Object.defineProperty(e,"registerPattern",{enumerable:!0,get:function(){return i.registerPattern}});var i=n(66798)},62414:function(t,e,n){e.default=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i},o=n(58201),r=n(35922),s=n(95479);var l=function(){function t(t,e){e=e||{},this._action=t,this._context=e.context||(0,o.getWindow)(),this._beforeExecute=e.beforeExecute,this._afterExecute=e.afterExecute,this._component=e.component,this._validatingTargetName=e.validatingTargetName;var n=this._excludeValidators={};if(e.excludeValidators)for(var i=0;i<e.excludeValidators.length;i++)n[e.excludeValidators[i]]=!0}var e=t.prototype;return e.execute=function(){var t={action:this._action,args:Array.prototype.slice.call(arguments),context:this._context,component:this._component,validatingTargetName:this._validatingTargetName,cancel:!1,handled:!1},e=this._beforeExecute,n=this._afterExecute,i=t.args[0]||{};if(this._validateAction(t)&&(null==e||e.call(this._context,t),!t.cancel)){var a=this._executeAction(t);if(!i.cancel)return null==n||n.call(this._context,t),a}},e._validateAction=function(e){var n=this._excludeValidators,i=t.executors;for(var a in i)if(!n[a]){var o,r=i[a];if(null===(o=r.validate)||void 0===o||o.call(r,e),e.cancel)return!1}return!0},e._executeAction=function(e){var n,i=t.executors;for(var a in i){var o,r=i[a];if(null===(o=r.execute)||void 0===o||o.call(r,e),e.handled){n=e.result;break}}return n},t.registerExecutor=function(e,n){(0,r.isPlainObject)(e)?(0,s.each)(e,t.registerExecutor):t.executors[e]=n},t.unregisterExecutor=function(){for(var e=arguments.length,n=new Array(e),i=0;i<e;i++)n[i]=arguments[i];(0,s.each)(n,(function(){delete t.executors[this]}))},t}();e.default=l,l.executors={};var c=function(t){return function(e){if(e.args.length){var n=e.args[0],i=n[e.validatingTargetName]||n.element;i&&t((0,a.default)(i))&&(e.cancel=!0)}}};l.registerExecutor({disabled:{validate:c((function(t){return t.is(".dx-state-disabled, .dx-state-disabled *")}))},readOnly:{validate:c((function(t){return t.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")}))},undefined:{execute:function(t){t.action||(t.result=void 0,t.handled=!0)}},func:{execute:function(t){(0,r.isFunction)(t.action)&&(t.result=t.action.call(t.context,t.args[0]),t.handled=!0)}}}),t.exports=e.default,t.exports.default=e.default},38377:function(t,e,n){e.default=void 0;var i,a=(i=n(17381))&&i.__esModule?i:{default:i},o=n(35922);var r,s=function(t,e,n){return function(){var i=this.callBase;this.callBase=t[e];try{return n.apply(this,arguments)}finally{this.callBase=i}}},l=function(t){var e,n,i;if(!t)return this;for(n in t)i=t[n],e="function"==typeof this.prototype[n]&&"function"==typeof i,this.prototype[n]=e?s(this.parent.prototype,n,i):i;return this},c=function(){var t,e,n,i=this,a=Object.prototype.hasOwnProperty.bind(i),o=!a("_includedCtors")&&!a("_includedPostCtors");for(o&&(i._includedCtors=i._includedCtors.slice(0),i._includedPostCtors=i._includedPostCtors.slice(0)),n=0;n<arguments.length;n++)for(e in(t=arguments[n]).ctor&&i._includedCtors.push(t.ctor),t.postCtor&&i._includedPostCtors.push(t.postCtor),t)"ctor"!==e&&"postCtor"!==e&&"default"!==e&&(i.prototype[e]=t[e]);return i},u=function(t){if(!Object.prototype.hasOwnProperty.bind(this)("parent")&&this.parent){var e=Object.getPrototypeOf(this);return e===t||e.subclassOf(t)}return this.parent===t||!(!this.parent||!this.parent.subclassOf)&&this.parent.subclassOf(t)},d=function(){throw a.default.Error("E0001")},h=(r=Object.prototype.hasOwnProperty,function(t,e){for(var n in t){if(!r.call(t,n))return;e[n]=t[n]}}),f=function(){};f.inherit=function(t){var e=function(){if(!this||(0,o.isWindow)(this)||"function"!=typeof this.constructor)throw a.default.Error("E0003");var t,e=this,n=e.ctor,i=e.constructor._includedCtors,r=e.constructor._includedPostCtors;for(t=0;t<i.length;t++)i[t].call(e);for(n&&n.apply(e,arguments),t=0;t<r.length;t++)r[t].call(e)};return e.prototype=function(t){var e=function(){};return e.prototype=t.prototype,new e}(this),h(this,e),e.inherit=this.inherit,e.abstract=d,e.redefine=l,e.include=c,e.subclassOf=u,e.parent=this,e._includedCtors=this._includedCtors?this._includedCtors.slice(0):[],e._includedPostCtors=this._includedPostCtors?this._includedPostCtors.slice(0):[],e.prototype.constructor=e,e.redefine(t),e},f.abstract=d;var p=f;e.default=p,t.exports=e.default,t.exports.default=e.default},44297:function(t,e,n){e.Component=void 0;var i=_(n(80209)),a=n(13306),o=n(95683),r=n(45434),s=_(n(38377)),l=_(n(62414)),c=_(n(17381)),u=_(n(44504)),d=n(80566),h=n(9321),f=n(90889),p=n(35922),g=n(20576),m=n(47617);function _(t){return t&&t.__esModule?t:{default:t}}var v=function(t){return t.charAt(2).toLowerCase()+t.substr(3)},b=s.default.inherit({_setDeprecatedOptions:function(){this._deprecatedOptions={}},_getDeprecatedOptions:function(){return this._deprecatedOptions},_getDefaultOptions:function(){return{onInitialized:null,onOptionChanged:null,onDisposing:null,defaultOptionsRules:null}},_defaultOptionsRules:function(){return[]},_setOptionsByDevice:function(t){this._options.applyRules(t)},_convertRulesToOptions:function(t){return(0,r.convertRulesToOptions)(t)},_isInitialOptionValue:function(t){return this._options.isInitial(t)},_setOptionsByReference:function(){this._optionsByReference={}},_getOptionsByReference:function(){return this._optionsByReference},ctor:function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:{},e=t._optionChangedCallbacks,n=t._disposingCallbacks;this.NAME=(0,h.name)(this.constructor),this._eventsStrategy=d.EventsStrategy.create(this,t.eventsStrategy),this._updateLockCount=0,this._optionChangedCallbacks=e||(0,u.default)(),this._disposingCallbacks=n||(0,u.default)(),this.postponedOperations=new f.PostponedOperations,this._createOptions(t)},_createOptions:function(t){var e=this;this.beginUpdate();try{this._setOptionsByReference(),this._setDeprecatedOptions(),this._options=new o.Options(this._getDefaultOptions(),this._getDefaultOptions(),this._getOptionsByReference(),this._getDeprecatedOptions()),this._options.onChanging((function(t,n,i){return e._initialized&&e._optionChanging(t,n,i)})),this._options.onDeprecated((function(t,n){return e._logDeprecatedOptionWarning(t,n)})),this._options.onChanged((function(t,n,i){return e._notifyOptionChanged(t,n,i)})),this._options.onStartChange((function(){return e.beginUpdate()})),this._options.onEndChange((function(){return e.endUpdate()})),this._options.addRules(this._defaultOptionsRules()),t&&t.onInitializing&&t.onInitializing.apply(this,[t]),this._setOptionsByDevice(t.defaultOptionsRules),this._initOptions(t)}finally{this.endUpdate()}},_initOptions:function(t){this.option(t)},_init:function(){var t=this;this._createOptionChangedAction(),this.on("disposing",(function(e){t._disposingCallbacks.fireWith(t,[e])}))},_logDeprecatedOptionWarning:function(t,e){var n=e.message||"Use the '".concat(e.alias,"' option instead");c.default.log("W0001",this.NAME,t,e.since,n)},_logDeprecatedComponentWarning:function(t,e){c.default.log("W0000",this.NAME,t,"Use the '".concat(e,"' widget instead"))},_createOptionChangedAction:function(){this._optionChangedAction=this._createActionByOption("onOptionChanged",{excludeValidators:["disabled","readOnly"]})},_createDisposingAction:function(){this._disposingAction=this._createActionByOption("onDisposing",{excludeValidators:["disabled","readOnly"]})},_optionChanged:function(t){switch(t.name){case"onDisposing":case"onInitialized":break;case"onOptionChanged":this._createOptionChangedAction()}},_dispose:function(){this._optionChangedCallbacks.empty(),this._createDisposingAction(),this._disposingAction(),this._eventsStrategy.dispose(),this._options.dispose(),this._disposed=!0},_lockUpdate:function(){this._updateLockCount++},_unlockUpdate:function(){this._updateLockCount=Math.max(this._updateLockCount-1,0)},_isUpdateAllowed:function(){return 0===this._updateLockCount},_isInitializingRequired:function(){return!this._initializing&&!this._initialized},isInitialized:function(){return this._initialized},_commitUpdate:function(){this.postponedOperations.callPostponedOperations(),this._isInitializingRequired()&&this._initializeComponent()},_initializeComponent:function(){this._initializing=!0;try{this._init()}finally{this._initializing=!1,this._lockUpdate(),this._createActionByOption("onInitialized",{excludeValidators:["disabled","readOnly"]})(),this._unlockUpdate(),this._initialized=!0}},instance:function(){return this},beginUpdate:function(){this._lockUpdate()},endUpdate:function(){this._unlockUpdate(),this._isUpdateAllowed()&&this._commitUpdate()},_optionChanging:g.noop,_notifyOptionChanged:function(t,e,n){if(this._initialized)for(var i=[t].concat(this._options.getAliasesByName(t)),o=0;o<i.length;o++){var r=i[o],s={name:(0,m.getPathParts)(r)[0],fullName:r,value:e,previousValue:n};0!==r.indexOf("_",0)&&(this._optionChangedCallbacks.fireWith(this,[(0,a.extend)(this._defaultActionArgs(),s)]),this._optionChangedAction((0,a.extend)({},s))),this._disposed||this._cancelOptionChange===r||this._optionChanged(s)}},initialOption:function(t){return this._options.initial(t)},_defaultActionConfig:function(){return{context:this,component:this}},_defaultActionArgs:function(){return{component:this}},_createAction:function(t,e){var n,i=this;return function(o){return(0,p.isDefined)(o)||(o={}),(0,p.isPlainObject)(o)||(o={actionValue:o}),(n=n||new l.default(t,(0,a.extend)({},e,i._defaultActionConfig()))).execute.call(n,(0,a.extend)(o,i._defaultActionArgs()))}},_createActionByOption:function(t,e){var n,o,r,s=this;e=(0,a.extend)({},e);var l=function(){if(!o){if(e=e||{},"string"!=typeof t)throw c.default.Error("E0008");0===t.indexOf("on")&&(o=v(t)),r=s.option(t)}if(n||r||e.beforeExecute||e.afterExecute||s._eventsStrategy.hasEvent(o)){if(!n){var a=e.beforeExecute;e.beforeExecute=function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];a&&a.apply(s,e),s._eventsStrategy.fireEvent(o,e[0].args)},n=s._createAction(r,e)}for(var l=arguments.length,u=new Array(l),d=0;d<l;d++)u[d]=arguments[d];if((0,i.default)().wrapActionsBeforeExecute){var h=s.option("beforeActionExecute")||g.noop,f=h(s,n,e)||n;return f.apply(s,u)}return n.apply(s,u)}};return(0,i.default)().wrapActionsBeforeExecute?l:(this.option("onActionCreated")||g.noop)(this,l,e)||l},on:function(t,e){return this._eventsStrategy.on(t,e),this},off:function(t,e){return this._eventsStrategy.off(t,e),this},hasActionSubscription:function(t){return!!this._options.silent(t)||this._eventsStrategy.hasEvent(v(t))},isOptionDeprecated:function(t){return this._options.isDeprecated(t)},_setOptionWithoutOptionChange:function(t,e){this._cancelOptionChange=t,this.option(t,e),this._cancelOptionChange=!1},_getOptionValue:function(t,e){var n=this.option(t);return(0,p.isFunction)(n)?n.bind(e)():n},option:function(){var t;return(t=this._options).option.apply(t,arguments)},resetOption:function(t){this.beginUpdate(),this._options.reset(t),this.endUpdate()}});e.Component=b},99393:function(t,e,n){e.default=void 0;var i=s(n(68374)),a=s(n(5554)),o=s(n(17381)),r=n(9321);function s(t){return t&&t.__esModule?t:{default:t}}a.default.add((function(t,e){i.default.fn[t]=function(n){var i,a="string"==typeof n;if(a){var r=n,s=[].slice.call(arguments).slice(1);this.each((function(){var n=e.getInstance(this);if(!n)throw o.default.Error("E0009",t);var a=n[r].apply(n,s);void 0===i&&(i=a)}))}else this.each((function(){var t=e.getInstance(this);t?t.option(n):new e(this,n)})),i=this;return i}}));var l=function(t,e,n){n?e[t]=n:n=e,(0,r.name)(n,t),a.default.fire(t,n)};e.default=l,t.exports=e.default,t.exports.default=e.default},5554:function(t,e,n){var i;e.default=void 0;var a=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);e.default=a,t.exports=e.default,t.exports.default=e.default},80209:function(t,e,n){e.default=void 0;var i,a=n(13306),o=(i=n(17381))&&i.__esModule?i:{default:i};var r={rtlEnabled:!1,defaultCurrency:"USD",defaultUseCurrencyAccountingStyle:!0,oDataFilterToLower:!0,serverDecimalSeparator:".",decimalSeparator:".",thousandsSeparator:",",forceIsoDateParsing:!0,wrapActionsBeforeExecute:!0,useLegacyStoreResult:!1,useJQuery:void 0,editorStylingMode:void 0,useLegacyVisibleIndex:!1,floatingActionButtonConfig:{icon:"add",closeIcon:"close",label:"",position:{at:"right bottom",my:"right bottom",offset:{x:-16,y:-16}},maxSpeedDialActionCount:5,shading:!1,direction:"auto"},optionsParser:function(t){"{"!==t.trim().charAt(0)&&(t="{"+t+"}");try{return JSON.parse(t)}catch(e){try{return JSON.parse(s(t))}catch(n){throw o.default.Error("E3018",e,t)}}}},s=function(t){return t.replace(/'/g,'"').replace(/,\s*([\]}])/g,"$1").replace(/([{,])\s*([^":\s]+)\s*:/g,'$1"$2":')},l=["decimalSeparator","thousandsSeparator"],c=function(){if(!arguments.length)return r;var t=arguments.length<=0?void 0:arguments[0];l.forEach((function(e){if(t[e]){var n="Now, the ".concat(e," is selected based on the specified locale.");o.default.log("W0003","config",e,"19.2",n)}})),(0,a.extend)(r,t)};"undefined"!=typeof DevExpress&&DevExpress.config&&c(DevExpress.config);var u=c;e.default=u,t.exports=e.default,t.exports.default=e.default},20530:function(t,e,n){e.default=void 0;var i=n(58664),a=m(n(68374)),o=n(58201),r=n(13306),s=n(35922),l=m(n(17381)),c=m(n(44504)),u=m(n(24311)),d=m(n(55814)),h=n(80566),f=n(36613),p=n(77695),g=m(n(80209));function m(t){return t&&t.__esModule?t:{default:t}}var _=(0,o.getWindow)(),v={iPhone:"iPhone",iPhone5:"iPhone",iPhone6:"iPhone",iPhone6plus:"iPhone",iPad:"iPad",iPadMini:"iPad Mini",androidPhone:"Android Mobile",androidTablet:"Android",msSurface:"Windows ARM Tablet PC",desktop:"desktop"},b={deviceType:"desktop",platform:"generic",version:[],phone:!1,tablet:!1,android:!1,ios:!1,generic:!0,grade:"A",mac:!1},y={generic:function(t){var e=/windows phone/i.test(t)||t.match(/WPDesktop/),n=!e&&/Windows(.*)arm(.*)Tablet PC/i.test(t),i=!e&&!n&&/msapphost/i.test(t),a=/((intel|ppc) mac os x)/.test(t.toLowerCase());return e||n||i||a?{deviceType:e?"phone":n?"tablet":"desktop",platform:"generic",version:[],grade:"A",mac:a}:null},appleTouchDevice:function(t){var e=(0,o.getNavigator)(),n=/Macintosh/i.test(t)&&(null==e?void 0:e.maxTouchPoints)>2;if(!/ip(hone|od|ad)/i.test(t)&&!n)return null;var i=/ip(hone|od)/i.test(t),a=t.match(/os\s{0,}X? (\d+)_(\d+)_?(\d+)?/i);return{deviceType:i?"phone":"tablet",platform:"ios",version:a?[parseInt(a[1],10),parseInt(a[2],10),parseInt(a[3]||0,10)]:[],grade:480===_.screen.height?"B":"A"}},android:function(t){var e=/android|htc_|silk/i.test(t),n=/windows phone/i.test(t);if(!e||n)return null;var i=/mobile/i.test(t),a=t.match(/android (\d+)\.?(\d+)?\.?(\d+)?/i),o=a?[parseInt(a[1],10),parseInt(a[2]||0,10),parseInt(a[3]||0,10)]:[];return{deviceType:i?"phone":"tablet",platform:"android",version:o,grade:o.length>1&&(o[0]<4||4===o[0]&&o[1]<4)?"B":"A"}}},x=[y.appleTouchDevice,y.android,y.generic],w=new(function(){function t(t){this._window=(null==t?void 0:t.window)||_,this._realDevice=this._getDevice(),this._currentDevice=void 0,this._currentOrientation=void 0,this._eventsStrategy=new h.EventsStrategy(this),this.changed=(0,c.default)(),(0,o.hasWindow)()&&(u.default.add(this._recalculateOrientation.bind(this)),d.default.add(this._recalculateOrientation.bind(this)))}var e=t.prototype;return e.current=function(t){if(t)return this._currentDevice=this._getDevice(t),this._forced=!0,void this.changed.fire();if(!this._currentDevice){t=void 0;try{t=this._getDeviceOrNameFromWindowScope()}catch(e){t=this._getDeviceNameFromSessionStorage()}finally{t||(t=this._getDeviceNameFromSessionStorage()),t&&(this._forced=!0)}this._currentDevice=this._getDevice(t)}return this._currentDevice},e.real=function(t){return(0,r.extend)({},this._realDevice)},e.orientation=function(){return this._currentOrientation},e.isForced=function(){return this._forced},e.isRippleEmulator=function(){return!!this._window.tinyHippos},e._getCssClasses=function(t){var e=[],n=this._realDevice;return(t=t||this.current()).deviceType&&(e.push("dx-device-".concat(t.deviceType)),"desktop"!==t.deviceType&&e.push("dx-device-mobile")),e.push("dx-device-".concat(n.platform)),n.version&&n.version.length&&e.push("dx-device-".concat(n.platform,"-").concat(n.version[0])),this.isSimulator()&&e.push("dx-simulator"),(0,g.default)().rtlEnabled&&e.push("dx-rtl"),e},e.attachCssClasses=function(t,e){this._deviceClasses=this._getCssClasses(e).join(" "),(0,a.default)(t).addClass(this._deviceClasses)},e.detachCssClasses=function(t){(0,a.default)(t).removeClass(this._deviceClasses)},e.isSimulator=function(){try{return this._isSimulator||(0,o.hasWindow)()&&this._window.top!==this._window.self&&this._window.top["dx-force-device"]||this.isRippleEmulator()}catch(t){return!1}},e.forceSimulator=function(){this._isSimulator=!0},e._getDevice=function(t){if("genericPhone"===t&&(t={deviceType:"phone",platform:"generic",generic:!0}),(0,s.isPlainObject)(t))return this._fromConfig(t);var e;if(t){if(!(e=v[t]))throw l.default.Error("E0005")}else e=(0,o.getNavigator)().userAgent;return this._fromUA(e)},e._getDeviceOrNameFromWindowScope=function(){var t;return(0,o.hasWindow)()&&(this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"])&&(t=this._window.top["dx-force-device-object"]||this._window.top["dx-force-device"]),t},e._getDeviceNameFromSessionStorage=function(){var t=(0,f.sessionStorage)();if(t){var e=t.getItem("dx-force-device");try{return JSON.parse(e)}catch(t){return e}}},e._fromConfig=function(t){var e=(0,r.extend)({},b,this._currentDevice,t),n={phone:"phone"===e.deviceType,tablet:"tablet"===e.deviceType,android:"android"===e.platform,ios:"ios"===e.platform,generic:"generic"===e.platform};return(0,r.extend)(e,n)},e._fromUA=function(t){for(var e=0;e<x.length;e+=1){var n=(0,x[e])(t);if(n)return this._fromConfig(n)}return b},e._changeOrientation=function(){var t=(0,a.default)(this._window),e=(0,i.getHeight)(t)>(0,i.getWidth)(t)?"portrait":"landscape";this._currentOrientation!==e&&(this._currentOrientation=e,this._eventsStrategy.fireEvent("orientationChanged",[{orientation:e}]))},e._recalculateOrientation=function(){var t=(0,i.getWidth)(this._window);this._currentWidth!==t&&(this._currentWidth=t,this._changeOrientation())},e.on=function(t,e){return this._eventsStrategy.on(t,e),this},e.off=function(t,e){return this._eventsStrategy.off(t,e),this},t}()),k=(0,p.value)();k&&w.attachCssClasses(k),p.changeCallback.add((function(t,e){w.detachCssClasses(e),w.attachCssClasses(t)}));var S=w;e.default=S,t.exports=e.default,t.exports.default=e.default},73349:function(t,e,n){e.default=void 0;var i,a=(i=n(20476))&&i.__esModule?i:{default:i},o=n(20576),r=n(90330);function s(t){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var l={querySelectorAll:function(t,e){return t.querySelectorAll(e)},elementMatches:function(t,e){var n=this;return(t.matches||t.matchesSelector||t.mozMatchesSelector||t.msMatchesSelector||t.oMatchesSelector||t.webkitMatchesSelector||function(e){var i=t.document||t.ownerDocument;if(!i)return!1;for(var a=n.querySelectorAll(i,e),o=0;o<a.length;o++)if(a[o]===t)return!0}).call(t,e)},createElement:function(t,e){return(e=e||this._document).createElement(t)},createElementNS:function(t,e,n){return(n=n||this._document).createElementNS(t,e)},createTextNode:function(t,e){return(e=e||this._document).createTextNode(t)},createAttribute:function(t,e){return(e=e||this._document).createAttribute(t)},isNode:function(t){return t&&"object"===s(t)&&"nodeType"in t&&"nodeName"in t},isElementNode:function(t){return t&&1===t.nodeType},isTextNode:function(t){return t&&3===t.nodeType},isDocument:function(t){return t&&9===t.nodeType},isDocumentFragment:function(t){return t&&11===t.nodeType},removeElement:function(t){var e=t&&t.parentNode;e&&e.removeChild(t)},insertElement:function(t,e,n){t&&e&&t!==e&&(n?t.insertBefore(e,n):t.appendChild(e))},getAttribute:function(t,e){return t.getAttribute(e)},setAttribute:function(t,e,n){"style"===e?t.style.cssText=n:t.setAttribute(e,n)},removeAttribute:function(t,e){t.removeAttribute(e)},setProperty:function(t,e,n){t[e]=n},setText:function(t,e){t&&(t.textContent=e)},setClass:function(t,e,n){1===t.nodeType&&e&&(n?t.classList.add(e):t.classList.remove(e))},setStyle:function(t,e,n){t.style[e]=n||""},_document:"undefined"==typeof document?void 0:document,getDocument:function(){return this._document},getActiveElement:function(t){return this.getRootNode(t).activeElement},getRootNode:function(t){var e,n;return null!==(e=null==t||null===(n=t.getRootNode)||void 0===n?void 0:n.call(t))&&void 0!==e?e:this._document},getBody:function(){return this._document.body},createDocumentFragment:function(){return this._document.createDocumentFragment()},getDocumentElement:function(){return this._document.documentElement},getLocation:function(){return this._document.location},getSelection:function(){return this._document.selection},getReadyState:function(){return this._document.readyState},getHead:function(){return this._document.head},hasDocumentProperty:function(t){return t in this._document},listen:function(t,e,n,i){return t&&"addEventListener"in t?(t.addEventListener(e,n,i),function(){t.removeEventListener(e,n)}):o.noop},elementsFromPoint:function(t,e,n){var i=this.getRootNode(n);return i.host?(0,r.getShadowElementsFromPoint)(t,e,i):i.elementsFromPoint(t,e)}},c=(0,a.default)(l);e.default=c,t.exports=e.default,t.exports.default=e.default},13046:function(t,e,n){e.default=void 0;var i=b(n(68374)),a=b(n(80209)),o=b(n(17381)),r=b(n(55814)),s=n(44297),l=n(14192),c=n(9321),u=n(90330),d=n(97906),h=n(95479),f=n(13306),p=n(6415),g=n(20576),m=n(35922),_=n(58201),v=n(72918);function b(t){return t&&t.__esModule?t:{default:t}}var y=s.Component.abstract,x=s.Component.inherit({_getDefaultOptions:function(){return(0,f.extend)(this.callBase(),{width:void 0,height:void 0,rtlEnabled:(0,a.default)().rtlEnabled,elementAttr:{},disabled:!1,integrationOptions:{}},this._useTemplates()?l.TemplateManager.createDefaultOptions():{})},ctor:function(t,e){this._customClass=null,this._createElement(t),(0,c.attachInstanceToElement)(this._$element,this,this._dispose),this.callBase(e)},_createElement:function(t){this._$element=(0,i.default)(t)},_getSynchronizableOptionsForCreateComponent:function(){return["rtlEnabled","disabled","templatesRenderAsynchronously"]},_checkFunctionValueDeprecation:function(t){var e=this;this.option("_ignoreFunctionValueDeprecation")||t.forEach((function(t){(0,m.isFunction)(e.option(t))&&o.default.log("W0017",t)}))},_visibilityChanged:y,_dimensionChanged:y,_init:function(){this.callBase(),this._checkFunctionValueDeprecation(["width","height","maxHeight","maxWidth","minHeight","minWidth","popupHeight","popupWidth"]),this._attachWindowResizeCallback(),this._initTemplateManager()},_setOptionsByDevice:function(t){this.callBase([].concat(this.constructor._classCustomRules||[],t||[]))},_isInitialOptionValue:function(t){return!(this.constructor._classCustomRules&&Object.prototype.hasOwnProperty.call(this._convertRulesToOptions(this.constructor._classCustomRules),t))&&this.callBase(t)},_attachWindowResizeCallback:function(){if(this._isDimensionChangeSupported()){var t=this._windowResizeCallBack=this._dimensionChanged.bind(this);r.default.add(t)}},_isDimensionChangeSupported:function(){return this._dimensionChanged!==y},_renderComponent:function(){this._initMarkup(),(0,_.hasWindow)()&&this._render()},_initMarkup:function(){var t=(this.option()||{}).rtlEnabled;this._renderElementAttributes(),this._toggleRTLDirection(t),this._renderVisibilityChange(),this._renderDimensions()},_render:function(){this._attachVisibilityChangeHandlers(),(0,u.addShadowDomStyles)(this.$element())},_renderElementAttributes:function(){var t=(this.option()||{}).elementAttr,e=(0,f.extend)({},t),n=e.class;delete e.class,this.$element().attr(e).removeClass(this._customClass).addClass(n),this._customClass=n},_renderVisibilityChange:function(){(this._isDimensionChangeSupported()&&this._attachDimensionChangeHandlers(),this._isVisibilityChangeSupported())&&this.$element().addClass("dx-visibility-change-handler")},_renderDimensions:function(){var t=this.$element(),e=t.get(0),n=this._getOptionValue("width",e),i=this._getOptionValue("height",e);this._isCssUpdateRequired(e,i,n)&&t.css({width:null===n?"":n,height:null===i?"":i})},_isCssUpdateRequired:function(t,e,n){return!!((0,m.isDefined)(n)||(0,m.isDefined)(e)||t.style.width||t.style.height)},_attachDimensionChangeHandlers:function(){var t=this,e=this.$element(),n="".concat(this.NAME,"VisibilityChange");v.resize.off(e,{namespace:n}),v.resize.on(e,(function(){return t._dimensionChanged()}),{namespace:n})},_attachVisibilityChangeHandlers:function(){var t=this;if(this._isVisibilityChangeSupported()){var e=this.$element(),n="".concat(this.NAME,"VisibilityChange");this._isHidden=!this._isVisible(),v.visibility.off(e,{namespace:n}),v.visibility.on(e,(function(){return t._checkVisibilityChanged("shown")}),(function(){return t._checkVisibilityChanged("hiding")}),{namespace:n})}},_isVisible:function(){return this.$element().is(":visible")},_checkVisibilityChanged:function(t){this._isVisible()&&("hiding"!==t||this._isHidden?"shown"===t&&this._isHidden&&(this._isHidden=!1,this._visibilityChanged(!0)):(this._visibilityChanged(!1),this._isHidden=!0))},_isVisibilityChangeSupported:function(){return this._visibilityChanged!==y&&(0,_.hasWindow)()},_clean:g.noop,_modelByElement:function(){var t=this.option().modelByElement,e=this.$element();return t?t(e):void 0},_invalidate:function(){if(this._isUpdateAllowed())throw o.default.Error("E0007");this._requireRefresh=!0},_refresh:function(){this._clean(),this._renderComponent()},_dispose:function(){this._templateManager&&this._templateManager.dispose(),this.callBase(),this._clean(),this._detachWindowResizeCallback()},_detachWindowResizeCallback:function(){this._isDimensionChangeSupported()&&r.default.remove(this._windowResizeCallBack)},_toggleRTLDirection:function(t){this.$element().toggleClass("dx-rtl",t)},_createComponent:function(t,e){var n=this,a=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=(0,g.grep)(this._getSynchronizableOptionsForCreateComponent(),(function(t){return!(t in a)})),r=this.option(),s=r.integrationOptions,l=this.option(),c=l.nestedComponentOptions;c=c||g.noop;var u=(0,f.extend)({integrationOptions:s},c(this));o.forEach((function(t){return u[t]=n.option(t)})),this._extendConfig(a,u);var d=void 0;if((0,m.isString)(e)){var h=(0,i.default)(t)[e](a);d=h[e]("instance")}else t&&((d=e.getInstance(t))?d.option(a):d=new e(t,a));if(d){var p=function(t){var e=t.name,n=t.value;o.includes(e)&&d.option(e,n)};this.on("optionChanged",p),d.on("disposing",(function(){return n.off("optionChanged",p)}))}return d},_extendConfig:function(t,e){(0,h.each)(e,(function(e,n){!Object.prototype.hasOwnProperty.call(t,e)&&(t[e]=n)}))},_defaultActionConfig:function(){var t=this.$element(),e=this._modelByElement(t);return(0,f.extend)(this.callBase(),{context:e})},_defaultActionArgs:function(){var t=this.$element(),e=this._modelByElement(t),n=this.element();return(0,f.extend)(this.callBase(),{element:n,model:e})},_optionChanged:function(t){switch(t.name){case"width":case"height":this._renderDimensions();break;case"rtlEnabled":this._invalidate();break;case"elementAttr":this._renderElementAttributes();break;case"disabled":case"integrationOptions":break;default:this.callBase(t)}},_removeAttributes:function(t){for(var e=t.attributes,n=e.length-1;n>=0;n--){var i=e[n];if(i){var a=i.name;a.indexOf("aria-")&&-1===a.indexOf("dx-")&&"role"!==a&&"style"!==a&&"tabindex"!==a||t.removeAttribute(a)}}},_removeClasses:function(t){t.className=t.className.split(" ").filter((function(t){return 0!==t.lastIndexOf("dx-",0)})).join(" ")},_updateDOMComponent:function(t){t?this._renderComponent():this._requireRefresh&&(this._requireRefresh=!1,this._refresh())},endUpdate:function(){var t=this._isInitializingRequired();this.callBase(),this._isUpdateAllowed()&&this._updateDOMComponent(t)},$element:function(){return this._$element},element:function(){var t=this.$element();return(0,p.getPublicElement)(t)},dispose:function(){var t=this.$element().get(0);(0,d.cleanDataRecursive)(t,!0),t.textContent="",this._removeAttributes(t),this._removeClasses(t)},resetOption:function(t){if(this.callBase(t),"width"===t||"height"===t){var e=this.initialOption(t);!(0,m.isDefined)(e)&&this.$element().css(t,"")}},_getAnonymousTemplateName:function(){},_initTemplateManager:function(){if(!this._templateManager&&this._useTemplates()){var t=this.option().integrationOptions,e=(void 0===t?{}:t).createTemplate;this._templateManager=new l.TemplateManager(e,this._getAnonymousTemplateName()),this._initTemplates()}},_initTemplates:function(){var t=this,e=this._templateManager.extractTemplates(this.$element()),n=e.templates,i=e.anonymousTemplateMeta,a=this.option("integrationOptions.templates.".concat(i.name));n.forEach((function(e){var n=e.name,i=e.template;t._options.silent("integrationOptions.templates.".concat(n),i)})),i.name&&!a&&(this._options.silent("integrationOptions.templates.".concat(i.name),i.template),this._options.silent("_hasAnonymousTemplateContent",!0))},_getTemplateByOption:function(t){return this._getTemplate(this.option(t))},_getTemplate:function(t){var e=this.option("integrationOptions.templates"),n=this.option("templatesRenderAsynchronously"),i=this.option("integrationOptions.skipTemplates");return this._templateManager.getTemplate(t,e,{isAsyncTemplate:n,skipTemplates:i},this)},_saveTemplate:function(t,e){this._setOptionWithoutOptionChange("integrationOptions.templates."+t,this._templateManager._createTemplate(e))},_useTemplates:function(){return!0}});x.getInstance=function(t){return(0,c.getInstanceByElement)((0,i.default)(t),this)},x.defaultOptions=function(t){this._classCustomRules=this._classCustomRules||[],this._classCustomRules.push(t)};var w=x;e.default=w,t.exports=e.default,t.exports.default=e.default},6415:function(t,e){e.getPublicElement=function(t){return n(t)},e.setPublicElementWrapper=function(t){n=t};var n=function(t){return t&&t.get(0)}},97906:function(t,e,n){e.afterCleanData=function(t){d=t},e.beforeCleanData=function(t){u=t},e.cleanData=function(t){return s.cleanData.call(this,t)},e.cleanDataRecursive=function(t,e){if(!i.default.isElementNode(t))return;var n=t.getElementsByTagName("*");s.cleanData(n),e&&s.cleanData([t])},e.data=function(){return s.data.apply(this,arguments)},e.getDataStrategy=function(){return s},e.removeData=function(t,e){return s.removeData.call(this,t,e)},e.strategyChanging=e.setDataStrategy=void 0;var i=r(n(73349)),a=r(n(55994)),o=r(n(83358));function r(t){return t&&t.__esModule?t:{default:t}}var s,l=new WeakMap,c=new o.default;e.strategyChanging=c;var u=function(){},d=function(){},h=function(t){c.fire(t);var e=(s=t).cleanData;s.cleanData=function(t){u(t);var n=e.call(this,t);return d(t),n}};e.setDataStrategy=h,h({data:function(){var t=arguments[0],e=arguments[1],n=arguments[2];if(t){var i=l.get(t);return i||(i={},l.set(t,i)),void 0===e?i:2===arguments.length?i[e]:(i[e]=n,n)}},removeData:function(t,e){if(t)if(void 0===e)l.delete(t);else{var n=l.get(t);n&&delete n[e]}},cleanData:function(t){for(var e=0;e<t.length;e++)a.default.off(t[e]),l.delete(t[e])}})},17381:function(t,e,n){var i;e.default=void 0;var a=(0,((i=n(95640))&&i.__esModule?i:{default:i}).default)({E0001:"Method is not implemented",E0002:"Member name collision: {0}",E0003:"A class must be instantiated using the 'new' keyword",E0004:"The NAME property of the component is not specified",E0005:"Unknown device",E0006:"Unknown endpoint key is requested",E0007:"'Invalidate' method is called outside the update transaction",E0008:"Type of the option name is not appropriate to create an action",E0009:"Component '{0}' has not been initialized for an element",E0010:"Animation configuration with the '{0}' type requires '{1}' configuration as {2}",E0011:"Unknown animation type '{0}'",E0012:"jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",E0013:"KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",E0014:"The 'release' method shouldn't be called for an unlocked Lock object",E0015:"Queued task returned an unexpected result",E0017:"Event namespace is not defined",E0018:"DevExpress.ui.DevExpressPopup widget is required",E0020:"Template engine '{0}' is not supported",E0021:"Unknown theme is set: {0}",E0022:"LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",E0023:"Template name is not specified",E0024:"DevExtreme bundle already included",E0025:"Unexpected argument type",E0100:"Unknown validation type is detected",E0101:"Misconfigured range validation rule is detected",E0102:"Misconfigured comparison validation rule is detected",E0103:"validationCallback of an asynchronous rule should return a jQuery or a native promise",E0110:"Unknown validation group is detected",E0120:"Adapter for a DevExpressValidator component cannot be configured",E0121:"The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",W0000:"'{0}' is deprecated in {1}. {2}",W0001:"{0} - '{1}' option is deprecated in {2}. {3}",W0002:"{0} - '{1}' method is deprecated in {2}. {3}",W0003:"{0} - '{1}' property is deprecated in {2}. {3}",W0004:"Timeout for theme loading is over: {0}",W0005:"'{0}' event is deprecated in {1}. {2}",W0006:"Invalid recurrence rule: '{0}'",W0007:"'{0}' Globalize culture is not defined",W0008:"Invalid view name: '{0}'",W0009:"Invalid time zone name: '{0}'",W0010:"{0} is deprecated in {1}. {2}",W0011:"Number parsing is invoked while the parser is not defined",W0012:"Date parsing is invoked while the parser is not defined",W0013:"'{0}' file is deprecated in {1}. {2}",W0014:"{0} - '{1}' type is deprecated in {2}. {3}",W0015:"Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",W0016:'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',W0017:'Setting the "{0}" property with a function is deprecated since v21.2',W0018:'Setting the "position" property with a function is deprecated since v21.2'});e.default=a,t.exports=e.default,t.exports.default=e.default},80566:function(t,e,n){e.EventsStrategy=void 0;var i,a=(i=n(44504))&&i.__esModule?i:{default:i},o=n(95479),r=n(35922);var s=function(){function t(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};this._events={},this._owner=t,this._options=e}t.create=function(e,n){return n?(0,r.isFunction)(n)?n(e):n:new t(e)};var e=t.prototype;return e.hasEvent=function(t){var e=this._events[t];return!!e&&e.has()},e.fireEvent=function(t,e){var n=this._events[t];return n&&n.fireWith(this._owner,e),this._owner},e.on=function(t,e){var n=this;if((0,r.isPlainObject)(t))(0,o.each)(t,(function(t,e){n.on(t,e)}));else{var i=this._events[t];i||(i=(0,a.default)({syncStrategy:this._options.syncStrategy}),this._events[t]=i),(i.originalAdd||i.add).call(i,e)}},e.off=function(t,e){var n=this._events[t];n&&((0,r.isFunction)(e)?n.remove(e):n.empty())},e.dispose=function(){(0,o.each)(this._events,(function(t,e){e.empty()}))},t}();e.EventsStrategy=s},73176:function(t,e,n){var i;e.default=void 0;var a=((i=n(38377))&&i.__esModule?i:{default:i}).default.inherit({ctor:function(t){t&&(t=String(t)),this._value=this._normalize(t||this._generate())},_normalize:function(t){for(t=t.replace(/[^a-f0-9]/gi,"").toLowerCase();t.length<32;)t+="0";return[t.substr(0,8),t.substr(8,4),t.substr(12,4),t.substr(16,4),t.substr(20,12)].join("-")},_generate:function(){for(var t="",e=0;e<32;e++)t+=Math.round(15*Math.random()).toString(16);return t},toString:function(){return this._value},valueOf:function(){return this._value},toJSON:function(){return this._value}});e.default=a,t.exports=e.default,t.exports.default=e.default},83448:function(t,e,n){e.default=void 0;var i,a=n(58201),o=(i=n(20476))&&i.__esModule?i:{default:i};var r=(0,a.getWindow)(),s={getXhr:function(){return new r.XMLHttpRequest}},l=(0,o.default)(s);e.default=l,t.exports=e.default,t.exports.default=e.default},15334:function(t,e,n){e.default=void 0;var i=n(55285),a=n(44105),o=n(87456),r=c(n(73349)),s=n(97906),l=c(n(20476));function c(t){return t&&t.__esModule?t:{default:t}}var u=function(t){var e=t.parentNode;if(e){var n=t.nextSibling;(0,s.cleanDataRecursive)(t),e.$V=t.$V,(0,i.render)(null,e),e.insertBefore(t,n),t.innerHTML="",delete e.$V}delete t.$V},d=(0,l.default)({createElement:function(t,e){return(0,o.createElement)(t,e)},remove:u,onAfterRender:function(){a.InfernoEffectHost.callEffects()},onPreRender:function(){a.InfernoEffectHost.lock()},render:function(t,e,n,s){if(s)(0,i.render)((0,o.createElement)(t,e),n);else{var l=n.parentNode,c=null==n?void 0:n.nextSibling,d=r.default.createElement("div");d.appendChild(n);var h=r.default.createDocumentFragment().appendChild(d);!!n.$V&&u(n),(0,a.hydrate)((0,o.createElement)(t,e),h),n.$V=h.$V,l&&l.insertBefore(n,c)}}});e.default=d,t.exports=e.default,t.exports.default=e.default},83358:function(t,e,n){e.default=void 0;var i,a=n(95479),o=(i=n(44504))&&i.__esModule?i:{default:i};var r=function(){function t(){this.memory=[],this.callbacks=(0,o.default)()}var e=t.prototype;return e.add=function(t){(0,a.each)(this.memory,(function(e,n){return t.apply(t,n)})),this.callbacks.add(t)},e.remove=function(t){this.callbacks.remove(t)},e.fire=function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];this.memory.push(e),this.callbacks.fire.apply(this.callbacks,e)},t}();e.default=r,t.exports=e.default,t.exports.default=e.default},95683:function(t,e,n){e.Options=void 0;var i=n(35922),a=n(20576),o=n(9030),r=n(47617),s=n(45434),l=n(13306);function c(t){return(c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function u(){return(u=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function d(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,(a=i.key,o=void 0,o=function(t,e){if("object"!==c(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==c(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(a,"string"),"symbol"===c(o)?o:String(o)),i)}var a,o}var h=function(){function t(t,e,n,i){var a=this;this._deprecatedCallback,this._startChangeCallback,this._endChangeCallback,this._default=e,this._deprecated=i,this._deprecatedNames=[],this._initDeprecatedNames(),this._optionManager=new o.OptionManager(t,n),this._optionManager.onRelevantNamesPrepared((function(t,e,n,i){return a._setRelevantNames(t,e,n,i)})),this._cachedOptions={},this._rules=[]}var e,n,c,h=t.prototype;return h._initDeprecatedNames=function(){for(var t in this._deprecated)this._deprecatedNames.push(t)},h._getByRules=function(t){return t=Array.isArray(t)?this._rules.concat(t):this._rules,(0,s.convertRulesToOptions)(t)},h._notifyDeprecated=function(t){var e=this._deprecated[t];e&&this._deprecatedCallback(t,e)},h._setRelevantNames=function(t,e,n,i){if(e){var a=this._normalizeName(e,i);a&&a!==e&&(this._setField(t,a,n),this._clearField(t,e))}},h._setField=function(t,e,n){var i="",a=null;do{i=i?".".concat(i):"",i=(0,s.getFieldName)(e)+i,a=(e=(0,s.getParentName)(e))?this._optionManager.get(t,e,!1):t}while(!a);a[i]=n},h._clearField=function(t,e){delete t[e];var n=(0,s.getParentName)(e),i=n?this._optionManager.get(t,n,!1):t;i&&delete i[(0,s.getFieldName)(e)]},h._normalizeName=function(t,e){if(this._deprecatedNames.length&&t)for(var n=0;n<this._deprecatedNames.length;n++)if(this._deprecatedNames[n]===t){var i=this._deprecated[t];if(i)return!e&&this._notifyDeprecated(t),i.alias||t}return t},h.addRules=function(t){this._rules=t.concat(this._rules)},h.applyRules=function(t){var e=this._getByRules(t);this.silent(e)},h.dispose=function(){this._deprecatedCallback=a.noop,this._startChangeCallback=a.noop,this._endChangeCallback=a.noop,this._optionManager.dispose()},h.onChanging=function(t){this._optionManager.onChanging(t)},h.onChanged=function(t){this._optionManager.onChanged(t)},h.onDeprecated=function(t){this._deprecatedCallback=t},h.onStartChange=function(t){this._startChangeCallback=t},h.onEndChange=function(t){this._endChangeCallback=t},h.isInitial=function(t){var e=this.silent(t),n=this.initial(t);return(0,i.isFunction)(e)&&(0,i.isFunction)(n)?e.toString()===n.toString():(0,a.equalByValue)(e,n)},h.initial=function(t){return(0,s.getNestedOptionValue)(this._initial,t)},h.option=function(t,e){var n=arguments.length<2&&"object"!==(0,i.type)(t);if(n)return this._optionManager.get(void 0,this._normalizeName(t));this._startChangeCallback();try{this._optionManager.set(t,e)}finally{this._endChangeCallback()}},h.silent=function(t,e){var n=arguments.length<2&&"object"!==(0,i.type)(t);if(n)return this._optionManager.get(void 0,t,void 0,!0);this._optionManager.set(t,e,void 0,!0)},h.reset=function(t){var e=this;if(t){var n=(0,r.getPathParts)(t).reduce((function(t,n){return t?t[n]:e.initial(n)}),null),a=(0,i.isObject)(n)?u({},n):n;this._optionManager.set(t,a,!1)}},h.getAliasesByName=function(t){var e=this;return Object.keys(this._deprecated).filter((function(n){return t===e._deprecated[n].alias}))},h.isDeprecated=function(t){return Object.prototype.hasOwnProperty.call(this._deprecated,t)},h.cache=function(t,e){var n=arguments.length<2;if(n)return this._cachedOptions[t];this._cachedOptions[t]=(0,l.extend)(this._cachedOptions[t],e)},e=t,(n=[{key:"_initial",get:function(){if(!this._initialOptions){var t=this._getByRules(this.silent("defaultOptionsRules"));this._initialOptions=this._default,this._optionManager._setByReference(this._initialOptions,t)}return this._initialOptions},set:function(t){this._initialOptions=t}}])&&d(e.prototype,n),c&&d(e,c),Object.defineProperty(e,"prototype",{writable:!1}),t}();e.Options=h},9030:function(t,e,n){e.OptionManager=void 0;var i=n(47617),a=n(20576),o=n(49036),r=n(13306),s=n(35922),l=n(45434),c={},u={},d=function(){function t(t,e){this._options=t,this._optionsByReference=e,this._changingCallback,this._changedCallback,this._namePreparedCallbacks}var e=t.prototype;return e._setByReference=function(t,e){for(var n in(0,r.extend)(!0,t,e),this._optionsByReference)Object.prototype.hasOwnProperty.call(e,n)&&(t[n]=e[n])},e._setPreparedValue=function(t,e,n,a){var r=this.get(this._options,t,!1);if(!(0,o.equals)(r,e)){var l=(0,i.getPathParts)(t);!a&&this._changingCallback(t,r,e),u[t]=u[t]||(0,i.compileSetter)(t),u[t](this._options,e,{functionsAsIs:!0,merge:(0,s.isDefined)(n)?n:!this._optionsByReference[t],unwrapObservables:l.length>1&&!!this._optionsByReference[l[0]]}),!a&&this._changedCallback(t,e,r)}},e._prepareRelevantNames=function(t,e,n,i){if((0,s.isPlainObject)(n))for(var a in n)this._prepareRelevantNames(t,"".concat(e,".").concat(a),n[a]);this._namePreparedCallbacks(t,e,n,i)},e.get=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:this._options,e=arguments.length>1?arguments[1]:void 0,n=arguments.length>2?arguments[2]:void 0;return c[e]=c[e]||(0,i.compileGetter)(e),c[e](t,{functionsAsIs:!0,unwrapObservables:n})},e.set=function(t,e,n,i){for(var a in t=(0,l.normalizeOptions)(t,e))this._prepareRelevantNames(t,a,t[a],i);for(var o in t)this._setPreparedValue(o,t[o],n,i)},e.onRelevantNamesPrepared=function(t){this._namePreparedCallbacks=t},e.onChanging=function(t){this._changingCallback=t},e.onChanged=function(t){this._changedCallback=t},e.dispose=function(){this._changingCallback=a.noop,this._changedCallback=a.noop},t}();e.OptionManager=d},45434:function(t,e,n){e.normalizeOptions=e.getParentName=e.getNestedOptionValue=e.getFieldName=e.deviceMatch=e.createDefaultOptionRules=e.convertRulesToOptions=void 0;var i,a=(i=n(20530))&&i.__esModule?i:{default:i},o=n(35922),r=n(20576),s=n(13306),l=n(47617);function c(t){return(c="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function u(t,e,n){return(e=function(t){var e=function(t,e){if("object"!==c(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==c(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"===c(e)?e:String(e)}(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}var d={};e.convertRulesToOptions=function(t){var e=a.default.current();return t.reduce((function(t,n){var i=n.device,a=n.options,r=i||{};return((0,o.isFunction)(r)?r(e):h(e,r))&&(0,s.extend)(!0,t,a),t}),{})};e.normalizeOptions=function(t,e){return"string"!=typeof t?t:u({},t,e)};var h=function(t,e){return(0,o.isEmptyObject)(e)||(0,r.findBestMatches)(t,[e]).length>0};e.deviceMatch=h;e.getFieldName=function(t){return t.substr(t.lastIndexOf(".")+1)};e.getParentName=function(t){return t.substr(0,t.lastIndexOf("."))};e.getNestedOptionValue=function(t,e){return d[e]=d[e]||(0,l.compileGetter)(e),d[e](t,{functionsAsIs:!0})};e.createDefaultOptionRules=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[];return t}},90889:function(t,e,n){e.PostponedOperations=void 0;var i=n(62754),a=n(35922);function o(t){return function(t){if(Array.isArray(t))return r(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var s=function(){function t(){this._postponedOperations={}}var e=t.prototype;return e.add=function(t,e,n){if(t in this._postponedOperations)n&&this._postponedOperations[t].promises.push(n);else{var a=new i.Deferred;this._postponedOperations[t]={fn:e,completePromise:a,promises:n?[n]:[]}}return this._postponedOperations[t].completePromise.promise()},e.callPostponedOperations=function(){for(var t in this._postponedOperations){var e=this._postponedOperations[t];(0,a.isDefined)(e)&&(e.promises&&e.promises.length?i.when.apply(void 0,o(e.promises)).done(e.fn).then(e.completePromise.resolve):e.fn().done(e.completePromise.resolve))}this._postponedOperations={}},t}();e.PostponedOperations=s},68374:function(t,e,n){var i;e.default=void 0;var a=((i=n(82981))&&i.__esModule?i:{default:i}).default.get();e.default=a,t.exports=e.default,t.exports.default=e.default},82981:function(t,e,n){e.default=void 0;var i,a=n(97906),o=(i=n(73349))&&i.__esModule?i:{default:i},r=n(58201),s=n(35922),l=n(80968),c=n(58664),u=n(61371);var d,h=(0,r.getWindow)(),f=function(t,e){return t?"string"==typeof t?"body"===t?(this[0]=e?e.body:o.default.getBody(),this.length=1,this):(e=e||o.default.getDocument(),"<"===t[0]?(this[0]=o.default.createElement(t.slice(1,-1),e),this.length=1,this):([].push.apply(this,o.default.querySelectorAll(e,t)),this)):o.default.isNode(t)||(0,s.isWindow)(t)?(this[0]=t,this.length=1,this):Array.isArray(t)?([].push.apply(this,t),this):d(t.toArray?t.toArray():[t]):(this.length=0,this)};(d=function(t,e){return new f(t,e)}).fn={dxRenderer:!0},f.prototype=d.fn;var p=function(t,e){for(var n=0;n<this.length;n++){var i=d(this[n]);i[t].apply(i,e)}return this},g=function(t,e,n){null!=n&&!1!==n?o.default.setAttribute(t,e,n):o.default.removeAttribute(t,e)};f.prototype.show=function(){return this.toggle(!0)},f.prototype.hide=function(){return this.toggle(!1)},f.prototype.toggle=function(t){return this[0]&&this.toggleClass("dx-state-invisible",!t),this},f.prototype.attr=function(t,e){if(this.length>1&&arguments.length>1)return p.call(this,"attr",arguments);if(!this[0])return(0,s.isObject)(t)||void 0!==e?this:void 0;if(!this[0].getAttribute)return this.prop(t,e);if("string"==typeof t&&1===arguments.length){var n=this[0].getAttribute(t);return null==n?void 0:n}if((0,s.isPlainObject)(t))for(var i in t)this.attr(i,t[i]);else g(this[0],t,e);return this},f.prototype.removeAttr=function(t){return this[0]&&o.default.removeAttribute(this[0],t),this},f.prototype.prop=function(t,e){if(!this[0])return this;if("string"==typeof t&&1===arguments.length)return this[0][t];if((0,s.isPlainObject)(t))for(var n in t)this.prop(n,t[n]);else o.default.setProperty(this[0],t,e);return this},f.prototype.addClass=function(t){return this.toggleClass(t,!0)},f.prototype.removeClass=function(t){return this.toggleClass(t,!1)},f.prototype.hasClass=function(t){if(!this[0]||void 0===this[0].className)return!1;for(var e=t.split(" "),n=0;n<e.length;n++){if(this[0].classList){if(this[0].classList.contains(e[n]))return!0}else if((((0,s.isString)(this[0].className)?this[0].className:o.default.getAttribute(this[0],"class"))||"").split(" ").indexOf(e[n])>=0)return!0}return!1},f.prototype.toggleClass=function(t,e){if(this.length>1)return p.call(this,"toggleClass",arguments);if(!this[0]||!t)return this;e=void 0===e?!this.hasClass(t):e;for(var n=t.split(" "),i=0;i<n.length;i++)o.default.setClass(this[0],n[i],e);return this},f.prototype.html=function(t){return arguments.length?(this.empty(),"string"==typeof t&&!(0,u.isTablePart)(t)||"number"==typeof t?(this[0].innerHTML=t,this):this.append((0,u.parseHTML)(t))):this[0].innerHTML};var m=function(t,e){if(this[0]&&t){"string"==typeof t?t=(0,u.parseHTML)(t):t.nodeType?t=[t]:(0,s.isNumeric)(t)&&(t=[o.default.createTextNode(t)]);for(var n=0;n<t.length;n++){var i=t[n],a=this[0];"TABLE"===a.tagName&&"TR"===i.tagName&&a.tBodies&&a.tBodies.length&&(a=a.tBodies[0]),o.default.insertElement(a,i.nodeType?i:i[0],e)}}},_=function(t,e){if(this[0]&&this[0].style&&!(null===e||"number"==typeof e&&isNaN(e))){t=(0,l.styleProp)(t);for(var n=0;n<this.length;n++)this[n].style[t]=(0,l.normalizeStyleProp)(t,e)}};f.prototype.css=function(t,e){if((0,s.isString)(t)){if(2!==arguments.length){if(!this[0])return;t=(0,l.styleProp)(t);var n=h.getComputedStyle(this[0])[t]||this[0].style[t];return(0,s.isNumeric)(n)?n.toString():n}_.call(this,t,e)}else if((0,s.isPlainObject)(t))for(var i in t)_.call(this,i,t[i]);return this},f.prototype.prepend=function(t){if(arguments.length>1){for(var e=0;e<arguments.length;e++)this.prepend(arguments[e]);return this}return m.apply(this,[t,this[0].firstChild]),this},f.prototype.append=function(t){if(arguments.length>1){for(var e=0;e<arguments.length;e++)this.append(arguments[e]);return this}return m.apply(this,[t]),this},f.prototype.prependTo=function(t){if(this.length>1){for(var e=this.length-1;e>=0;e--)d(this[e]).prependTo(t);return this}return(t=d(t))[0]&&o.default.insertElement(t[0],this[0],t[0].firstChild),this},f.prototype.appendTo=function(t){return this.length>1?p.call(this,"appendTo",arguments):(o.default.insertElement(d(t)[0],this[0]),this)},f.prototype.insertBefore=function(t){return t&&t[0]&&o.default.insertElement(t[0].parentNode,this[0],t[0]),this},f.prototype.insertAfter=function(t){return t&&t[0]&&o.default.insertElement(t[0].parentNode,this[0],t[0].nextSibling),this},f.prototype.before=function(t){return this[0]&&o.default.insertElement(this[0].parentNode,t[0],this[0]),this},f.prototype.after=function(t){return this[0]&&o.default.insertElement(this[0].parentNode,t[0],this[0].nextSibling),this},f.prototype.wrap=function(t){if(this[0]){var e=d(t);e.insertBefore(this),e.append(this)}return this},f.prototype.wrapInner=function(t){var e=this.contents();return e.length?e.wrap(t):this.append(t),this},f.prototype.replaceWith=function(t){if(t&&t[0])return t.is(this)?this:(t.insertBefore(this),this.remove(),t)},f.prototype.remove=function(){return this.length>1?p.call(this,"remove",arguments):((0,a.cleanDataRecursive)(this[0],!0),o.default.removeElement(this[0]),this)},f.prototype.detach=function(){return this.length>1?p.call(this,"detach",arguments):(o.default.removeElement(this[0]),this)},f.prototype.empty=function(){return this.length>1?p.call(this,"empty",arguments):((0,a.cleanDataRecursive)(this[0]),o.default.setText(this[0],""),this)},f.prototype.clone=function(){for(var t=[],e=0;e<this.length;e++)t.push(this[e].cloneNode(!0));return d(t)},f.prototype.text=function(t){if(!arguments.length){for(var e="",n=0;n<this.length;n++)e+=this[n]&&this[n].textContent||"";return e}var i=(0,s.isFunction)(t)?t():t;return(0,a.cleanDataRecursive)(this[0],!1),o.default.setText(this[0],(0,s.isDefined)(i)?i:""),this},f.prototype.val=function(t){return 1===arguments.length?this.prop("value",(0,s.isDefined)(t)?t:""):this.prop("value")},f.prototype.contents=function(){if(!this[0])return d();var t=[];return t.push.apply(t,this[0].childNodes),d(t)},f.prototype.find=function(t){var e=d();if(!t)return e;var n,i=[];if("string"==typeof t)for(t=t.trim(),n=0;n<this.length;n++){var a=this[n];if(o.default.isElementNode(a)){var r=a.getAttribute("id"),s=r||"dx-query-children";r||g(a,"id",s);var l=(s="[id='"+s+"'] ")+t.replace(/([^\\])(,)/g,"$1, "+s);i.push.apply(i,o.default.querySelectorAll(a,l)),g(a,"id",r)}else(o.default.isDocument(a)||o.default.isDocumentFragment(a))&&i.push.apply(i,o.default.querySelectorAll(a,t))}else for(n=0;n<this.length;n++)t=o.default.isNode(t)?t:t[0],this[n]!==t&&this[n].contains(t)&&i.push(t);return e.add(i)};var v=function(t,e){var n;return!(e=null!==(n=e.host)&&void 0!==n?n:e).nodeType||!!(e.offsetWidth||e.offsetHeight||e.getClientRects().length)};f.prototype.filter=function(t){if(!t)return d();if(":visible"===t)return this.filter(v);if(":hidden"===t)return this.filter((function(t,e){return!v(0,e)}));for(var e=[],n=0;n<this.length;n++){var i=this[n];if(o.default.isElementNode(i)&&"string"===(0,s.type)(t))o.default.elementMatches(i,t)&&e.push(i);else if(o.default.isNode(t)||(0,s.isWindow)(t))t===i&&e.push(i);else if((0,s.isFunction)(t))t.call(i,n,i)&&e.push(i);else for(var a=0;a<t.length;a++)t[a]===i&&e.push(i)}return d(e)},f.prototype.not=function(t){for(var e=[],n=this.filter(t).toArray(),i=0;i<this.length;i++)-1===n.indexOf(this[i])&&e.push(this[i]);return d(e)},f.prototype.is=function(t){return!!this.filter(t).length},f.prototype.children=function(t){for(var e=[],n=0;n<this.length;n++)for(var i=this[n]?this[n].childNodes:[],a=0;a<i.length;a++)o.default.isElementNode(i[a])&&e.push(i[a]);return e=d(e),t?e.filter(t):e},f.prototype.siblings=function(){var t=this[0];if(!t||!t.parentNode)return d();for(var e=[],n=t.parentNode.childNodes||[],i=0;i<n.length;i++){var a=n[i];o.default.isElementNode(a)&&a!==t&&e.push(a)}return d(e)},f.prototype.each=function(t){for(var e=0;e<this.length&&!1!==t.call(this[e],e,this[e]);e++);},f.prototype.index=function(t){return t?(t=d(t),this.toArray().indexOf(t[0])):this.parent().children().index(this)},f.prototype.get=function(t){return this[t<0?this.length+t:t]},f.prototype.eq=function(t){return t=t<0?this.length+t:t,d(this[t])},f.prototype.first=function(){return this.eq(0)},f.prototype.last=function(){return this.eq(-1)},f.prototype.select=function(){for(var t=0;t<this.length;t+=1)this[t].select&&this[t].select();return this},f.prototype.parent=function(t){if(!this[0])return d();var e=d(this[0].parentNode);return!t||e.is(t)?e:d()},f.prototype.parents=function(t){for(var e=[],n=this.parent();n&&n[0]&&!o.default.isDocument(n[0]);)o.default.isElementNode(n[0])&&(t&&!n.is(t)||e.push(n.get(0))),n=n.parent();return d(e)},f.prototype.closest=function(t){if(this.is(t))return this;for(var e=this.parent();e&&e.length;){if(e.is(t))return e;e=e.parent()}return d()},f.prototype.next=function(t){if(!this[0])return d();var e=d(this[0].nextSibling);if(!arguments.length)return e;for(;e&&e.length;){if(e.is(t))return e;e=e.next()}return d()},f.prototype.prev=function(){return this[0]?d(this[0].previousSibling):d()},f.prototype.add=function(t){for(var e=d(t),n=this.toArray(),i=0;i<e.length;i++){var a=e[i];-1===n.indexOf(a)&&n.push(a)}return d(n)};var b=[];f.prototype.splice=function(){return d(b.splice.apply(this,arguments))},f.prototype.slice=function(){return d(b.slice.apply(this,arguments))},f.prototype.toArray=function(){return b.slice.call(this)},f.prototype.offset=function(){if(this[0])return(0,c.getOffset)(this[0])},f.prototype.offsetParent=function(){if(!this[0])return d();for(var t=d(this[0].offsetParent);t[0]&&"static"===t.css("position");)t=d(t[0].offsetParent);return t=t[0]?t:d(o.default.getDocumentElement())},f.prototype.position=function(){if(this[0]){var t,e=parseFloat(this.css("marginTop")),n=parseFloat(this.css("marginLeft"));if("fixed"===this.css("position"))return{top:(t=this[0].getBoundingClientRect()).top-e,left:t.left-n};t=this.offset();var i=this.offsetParent(),a={top:0,left:0};return"HTML"!==i[0].nodeName&&(a=i.offset()),a={top:a.top+parseFloat(i.css("borderTopWidth")),left:a.left+parseFloat(i.css("borderLeftWidth"))},{top:t.top-a.top-e,left:t.left-a.left-n}}},[{name:"scrollLeft",offsetProp:"pageXOffset",scrollWindow:function(t,e){t.scrollTo(e,t.pageYOffset)}},{name:"scrollTop",offsetProp:"pageYOffset",scrollWindow:function(t,e){t.scrollTo(t.pageXOffset,e)}}].forEach((function(t){var e=t.name;f.prototype[e]=function(n){if(this[0]){var i=(0,c.getWindowByElement)(this[0]);return void 0===n?i?i[t.offsetProp]:this[0][e]:(i?t.scrollWindow(i,n):this[0][e]=n,this)}}})),f.prototype.data=function(t,e){if(this[0])return arguments.length<2?a.data.call(d,this[0],t):(a.data.call(d,this[0],t,e),this)},f.prototype.removeData=function(t){return this[0]&&(0,a.removeData)(this[0],t),this};var y=function(){return d.apply(this,arguments)};Object.defineProperty(y,"fn",{enumerable:!0,configurable:!0,get:function(){return d.fn},set:function(t){d.fn=t}});var x={set:function(t){d=t},get:function(){return y}};e.default=x,t.exports=e.default,t.exports.default=e.default},91784:function(t,e,n){e.default=void 0;var i=n(20576),a=n(58201),o=(0,a.getWindow)(),r={observe:i.noop,unobserve:i.noop,disconnect:i.noop},s=new(function(){function t(){var t=this;if(!(0,a.hasWindow)()||!o.ResizeObserver)return r;this._callbacksMap=new Map,this._observer=new o.ResizeObserver((function(e){e.forEach((function(e){var n;null===(n=t._callbacksMap.get(e.target))||void 0===n||n(e)}))}))}var e=t.prototype;return e.observe=function(t,e){this._callbacksMap.set(t,e),this._observer.observe(t)},e.unobserve=function(t){this._callbacksMap.delete(t),this._observer.unobserve(t)},e.disconnect=function(){this._callbacksMap.clear(),this._observer.disconnect()},t}());e.default=s,t.exports=e.default,t.exports.default=e.default},14192:function(t,e,n){e.TemplateManager=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i},o=n(35922),r=n(20576),s=n(13306),l=n(68494),c=n(10688),u=n(69697);function d(t){return(d="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function h(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,(a=i.key,o=void 0,o=function(t,e){if("object"!==d(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==d(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(a,"string"),"symbol"===d(o)?o:String(o)),i)}var a,o}var f=new l.FunctionTemplate((function(t){var e=t.model,n=t.parent,i=e.widget;if(!i)return(0,a.default)();var o=(0,a.default)("<div>"),r=e.options||{};return n?n._createComponent(o,i,r):o[i](r),o})),p=function(){function t(t,e){this._tempTemplates=[],this._defaultTemplates={},this._anonymousTemplateName=e||"template",this._createElement=t||u.defaultCreateElement,this._createTemplateIfNeeded=this._createTemplateIfNeeded.bind(this)}t.createDefaultOptions=function(){return{integrationOptions:{watchMethod:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};return n.skipImmediate||e(t()),r.noop},templates:{"dx-polymorph-widget":f},useDeferUpdateForTemplates:!0}}};var e,n,i,d=t.prototype;return d.addDefaultTemplates=function(t){this._defaultTemplates=(0,s.extend)({},this._defaultTemplates,t)},d.dispose=function(){this._tempTemplates.forEach((function(t){t.template.dispose&&t.template.dispose()})),this._tempTemplates=[]},d.extractTemplates=function(t){return{templates:this._extractTemplates(t),anonymousTemplateMeta:this._extractAnonymousTemplate(t)}},d._extractTemplates=function(t){var e=this,n=(0,u.findTemplates)(t,"dxTemplate"),i=(0,u.suitableTemplatesByName)(n);return n.forEach((function(t){var e=t.element,n=t.options.name;e===i[n]?(0,a.default)(e).addClass("dx-template-wrapper").detach():(0,a.default)(e).remove()})),Object.keys(i).map((function(t){return{name:t,template:e._createTemplate(i[t])}}))},d._extractAnonymousTemplate=function(t){var e=t.contents().detach();return e.filter((function(t,e){var n=3===e.nodeType,i=(0,a.default)(e).text().trim().length<1;return!(n&&i)})).length>0?{template:this._createTemplate(e),name:this._anonymousTemplateName}:{}},d._createTemplateIfNeeded=function(t){var e=this._tempTemplates.filter((function(e){return e.source===(0,u.templateKey)(t)}))[0];if(e)return e.template;var n=this._createTemplate(t);return this._tempTemplates.push({template:n,source:(0,u.templateKey)(t)}),n},d._createTemplate=function(t){return this._createElement((0,u.validateTemplateSource)(t))},d.getTemplate=function(t,e,n,i){var r=this,s=n.isAsyncTemplate,d=n.skipTemplates;return(0,o.isFunction)(t)?new l.FunctionTemplate((function(n){var h=t.apply(i,(0,u.getNormalizedTemplateArgs)(n));if(!(0,o.isDefined)(h))return new c.EmptyTemplate;var f=!1,p=(0,u.acquireTemplate)(h,(function(t){return t.nodeType||(0,o.isRenderer)(t)&&!(0,a.default)(t).is("script")?new l.FunctionTemplate((function(){return t})):(f=!0,r._createTemplate(t))}),e,s,d,r._defaultTemplates),g=p.render(n);return f&&p.dispose&&p.dispose(),g})):(0,u.acquireTemplate)(t,this._createTemplateIfNeeded,e,s,d,this._defaultTemplates)},e=t,(n=[{key:"anonymousTemplateName",get:function(){return this._anonymousTemplateName}}])&&h(e.prototype,n),i&&h(e,i),Object.defineProperty(e,"prototype",{writable:!1}),t}();e.TemplateManager=p},93280:function(t,e,n){e.BindableTemplate=void 0;var i=l(n(68374)),a=n(81033),o=l(n(55994)),r=n(29007),s=n(35922);function l(t){return t&&t.__esModule?t:{default:t}}function c(t,e){return(c=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var u=function(t,e,n,i,a){var o,r=function(t,e,n){return e((function(){return t}),n)}(t,e,(function(t){o&&o(),(0,s.isPrimitive)(t)?a(t):o=function(t,e,n,i,a){var o={},r=n.slice(),s=n.map((function(n){var s=i[n];return e(s?function(){return s(t)}:function(){return t[n]},(function(t){if(o[n]=t,r.length){var e=r.indexOf(n);e>=0&&r.splice(e,1)}r.length||a(o)}))}));return function(){s.forEach((function(t){return t()}))}}(t,e,n,i,a)}));return function(){o&&o(),r&&r()}},d=function(t){var e,n;function a(e,n,i,a){var o;return(o=t.call(this)||this)._render=e,o._fields=n,o._fieldsMap=a||{},o._watchMethod=i,o}return n=t,(e=a).prototype=Object.create(n.prototype),e.prototype.constructor=e,c(e,n),a.prototype._renderCore=function(t){var e=this,n=(0,i.default)(t.container),a=u(t.model,this._watchMethod,this._fields,this._fieldsMap,(function(i){n.empty(),e._render(n,i,t.model)}));return o.default.on(n,r.removeEvent,a),n.contents()},a}(a.TemplateBase);e.BindableTemplate=d},91627:function(t,e,n){function i(t,e){return(i=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}e.ChildDefaultTemplate=void 0;var a=function(t){var e,n;function a(e){var n;return(n=t.call(this)||this).name=e,n}return n=t,(e=a).prototype=Object.create(n.prototype),e.prototype.constructor=e,i(e,n),a}(n(81033).TemplateBase);e.ChildDefaultTemplate=a},10688:function(t,e,n){e.EmptyTemplate=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i};function o(t,e){return(o=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var r=function(t){var e,n;function i(){return t.apply(this,arguments)||this}return n=t,(e=i).prototype=Object.create(n.prototype),e.prototype.constructor=e,o(e,n),i.prototype._renderCore=function(){return(0,a.default)()},i}(n(81033).TemplateBase);e.EmptyTemplate=r},68494:function(t,e,n){e.FunctionTemplate=void 0;var i=n(81033),a=n(3532);function o(t,e){return(o=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var r=function(t){var e,n;function i(e){var n;return(n=t.call(this)||this)._render=e,n}return n=t,(e=i).prototype=Object.create(n.prototype),e.prototype.constructor=e,o(e,n),i.prototype._renderCore=function(t){return(0,a.normalizeTemplateElement)(this._render(t))},i}(i.TemplateBase);e.FunctionTemplate=r},9545:function(t,e,n){e.Template=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i},o=n(81033),r=n(3532),s=n(72987);function l(t,e){return(l=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}(0,s.registerTemplateEngine)("default",{compile:function(t){return(0,r.normalizeTemplateElement)(t)},render:function(t,e,n){return t.clone()}}),(0,s.setTemplateEngine)("default");var c=function(t){var e,n;function i(e){var n;return(n=t.call(this)||this)._element=e,n}n=t,(e=i).prototype=Object.create(n.prototype),e.prototype.constructor=e,l(e,n);var o=i.prototype;return o._renderCore=function(t){var e=t.transclude;return e||this._compiledTemplate||(this._compiledTemplate=(0,s.getCurrentTemplateEngine)().compile(this._element)),(0,a.default)("<div>").append(e?this._element:(0,s.getCurrentTemplateEngine)().render(this._compiledTemplate,t.model,t.index)).contents()},o.source=function(){return(0,a.default)(this._element).clone()},i}(o.TemplateBase);e.Template=c},81033:function(t,e,n){e.renderedCallbacks=e.TemplateBase=void 0;var i=c(n(68374)),a=c(n(73349)),o=c(n(44504)),r=n(3532),s=n(80506),l=c(n(17381));function c(t){return t&&t.__esModule?t:{default:t}}var u=(0,o.default)({syncStrategy:!0});e.renderedCallbacks=u;var d=function(){function t(){}var e=t.prototype;return e.render=function(t){var e,n=(t=t||{}).onRendered;return delete t.onRendered,e=t.renovated&&t.transclude&&this._element?(0,i.default)("<div>").append(this._element).contents():this._renderCore(t),this._ensureResultInContainer(e,t.container),u.fire(e,t.container),n&&n(),e},e._ensureResultInContainer=function(t,e){if(e){var n=(0,i.default)(e),o=(0,r.contains)(n.get(0),t.get(0));if(n.append(t),!o)a.default.getBody().contains(n.get(0))&&(0,s.triggerShownEvent)(t)}},e._renderCore=function(){throw l.default.Error("E0001")},t}();e.TemplateBase=d},72987:function(t,e,n){e.getCurrentTemplateEngine=function(){return r},e.registerTemplateEngine=function(t,e){s[t]=e},e.setTemplateEngine=function(t){if((0,a.isString)(t)){if(!(r=s[t]))throw o.default.Error("E0020",t)}else r=t};var i,a=n(35922),o=(i=n(17381))&&i.__esModule?i:{default:i};var r,s={}},37208:function(t,e,n){e.default=void 0;var i=n(62754),a=u(n(73349)),o=u(n(83448)),r=n(58201),s=n(13306),l=n(35922),c=u(n(20476));function u(t){return t&&t.__esModule?t:{default:t}}var d=(0,r.getWindow)(),h=function(t){var e=a.default.createElement("script");for(var n in t)e[n]=t[n];return e},f=function(t){t.parentNode.removeChild(t)},p=function(t){return a.default.getHead().appendChild(t)},g=function(t){var e=h({text:t});p(e),f(e)},m=function(t,e){var n=t.data,i="string"==typeof n,a=t.url||d.location.href;return i||t.cache||((n=n||{})._=Date.now()),n&&!t.upload&&(i||(n=function(t){var e=[];for(var n in t){var i=t[n];void 0!==i&&(null===i&&(i=""),"function"==typeof i&&(i=i()),e.push(encodeURIComponent(n)+"="+encodeURIComponent(i)))}return e.join("&")}(n)),"GET"===_(t)?(""!==n&&(a+=(a.indexOf("?")>-1?"&":"?")+n),n=null):e["Content-Type"]&&e["Content-Type"].indexOf("application/x-www-form-urlencoded")>-1&&(n=n.replace(/%20/g,"+"))),{url:a,parameters:n}};function _(t){return(t.method||"GET").toUpperCase()}var v=function(t){var e=t.headers||{};return e["Content-Type"]=e["Content-Type"]||function(t){var e;return t.data&&!t.upload&&"GET"!==_(t)&&(e="application/x-www-form-urlencoded;charset=utf-8"),t.contentType||e}(t),e.Accept=e.Accept||function(t){var e=t.dataType||"*",n="text/javascript, application/javascript, application/ecmascript, application/x-ecmascript",i={"*":"*/*",text:"text/plain",html:"text/html",xml:"application/xml, text/xml",json:"application/json, text/javascript",jsonp:n,script:n};return(0,s.extendFromObject)(i,t.accepts,!0),i[e]?i[e]+("*"!==e?", */*; q=0.01":""):i["*"]}(t),t.crossDomain||e["X-Requested-With"]||(e["X-Requested-With"]="XMLHttpRequest"),e},b=(0,c.default)({sendRequest:function(t){var e,n=o.default.getXhr(),s=new i.Deferred,c=s.promise(),u=!(0,l.isDefined)(t.async)||t.async,b=t.dataType,y=t.timeout||0;t.crossDomain=function(t){if(!(0,r.hasWindow)())return!0;var e=!1,n=a.default.createElement("a"),i=a.default.createElement("a");n.href=d.location.href;try{i.href=t,i.href=i.href,e=n.protocol+"//"+n.host!=i.protocol+"//"+i.host}catch(t){e=!0}return e}(t.url);var x="jsonp"===b||"script"===b;void 0===t.cache&&(t.cache=!x);var w=function(t){if("jsonp"===t.dataType){var e=Math.random().toString().replace(/\D/g,""),n=t.jsonpCallback||"dxCallback"+Date.now()+"_"+e,i=t.jsonp||"callback";return t.data=t.data||{},t.data[i]=n,n}}(t),k=v(t),S=m(t,k),C=S.url,A=S.parameters;if(w&&(d[w]=function(t){s.resolve(t,"success",n)}),t.crossDomain&&x){return function(t){var e=h({src:t});return new Promise((function(t,n){var i={load:t,error:n},o=function(t){i[t.type](),f(e)};for(var r in i)a.default.listen(e,r,o);p(e)}))}(C).then((function(){"jsonp"!==b&&s.resolve(null,"success",n)}),(function(){s.reject(n,"error")})),c}if(t.crossDomain&&!("withCredentials"in n))return s.reject(n,"error"),c;if(n.open(_(t),C,u,t.username,t.password),u&&(n.timeout=y,e=function(t,e){return t&&setTimeout((function(){e.customStatus="timeout",e.abort()}),t)}(y,n)),n.onreadystatechange=function(t){var i;4===n.readyState&&(clearTimeout(e),200<=(i=n.status)&&i<300?function(t){return 204!==t}(n.status)?function(t,e,n){var i=function(t){return t.responseType&&"text"!==t.responseType||"string"!=typeof t.responseText?t.response:t.responseText}(e);switch(n){case"jsonp":g(i);break;case"script":g(i),t.resolve(i,"success",e);break;case"json":try{t.resolve(JSON.parse(i),"success",e)}catch(n){t.reject(e,"parsererror",n)}break;default:t.resolve(i,"success",e)}}(s,n,b):s.resolve(null,"nocontent",n):s.reject(n,n.customStatus||"error"))},t.upload&&(n.upload.onprogress=t.upload.onprogress,n.upload.onloadstart=t.upload.onloadstart,n.upload.onabort=t.upload.onabort),t.xhrFields)for(var E in t.xhrFields)n[E]=t.xhrFields[E];for(var T in"arraybuffer"===t.responseType&&(n.responseType=t.responseType),k)Object.prototype.hasOwnProperty.call(k,T)&&(0,l.isDefined)(k[T])&&n.setRequestHeader(T,k[T]);return t.beforeSend&&t.beforeSend(n),n.send(A),c.abort=function(){n.abort()},c}});e.default=b,t.exports=e.default,t.exports.default=e.default},89386:function(t,e,n){e.wrapToArray=e.removeDuplicates=e.normalizeIndexes=e.groupBy=e.getUniqueValues=e.getIntersection=void 0;var i,a=n(35922),o=n(48013),r=(i=n(80209))&&i.__esModule?i:{default:i};function s(t){return function(t){if(Array.isArray(t))return l(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return l(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return l(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function l(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function c(t){return t.reduce((function(t,e){var n,i=(null!==(n=t.get(e))&&void 0!==n?n:0)+1;return t.set(e,i),t}),new Map)}e.wrapToArray=function(t){return Array.isArray(t)?t:[t]};e.getUniqueValues=function(t){return s(new Set(t))};e.getIntersection=function(t,e){var n=c(e);return t.filter((function(t){var e=n.get(t);return e&&n.set(t,e-1),e}))};e.removeDuplicates=function(){var t=arguments.length>0&&void 0!==arguments[0]?arguments[0]:[],e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:[],n=c(e);return t.filter((function(t){var e=n.get(t);return e&&n.set(t,e-1),!e}))};e.normalizeIndexes=function(t,e,n,i){var s={},l=(0,r.default)().useLegacyVisibleIndex,c=0,u=function(t){return!(0,a.isDefined)(t[e])&&(!i||i(t))};t.forEach((function(t){var i=t[e];i>=0?(s[i]=s[i]||[],t===n?s[i].unshift(t):s[i].push(t)):t[e]=void 0})),l||t.forEach((function(t){if(u(t)){for(;s[c];)c++;s[c]=[t],c++}})),c=0,(0,o.orderEach)(s,(function(t,n){n.forEach((function(n){t>=0&&(n[e]=c++)}))})),l&&t.forEach((function(t){u(t)&&(t[e]=c++)}))};e.groupBy=function(t,e){return t.reduce((function(t,n){var i,a=e(n);return t[a]=null!==(i=t[a])&&void 0!==i?i:[],t[a].push(n),t}),{})}},34671:function(t,e,n){e.isKeysEqual=e.findChanges=void 0;var i=n(35922),a=function(t,e){var n=e(t);if((0,i.isObject)(n))try{return JSON.stringify(n)}catch(t){return n}return n},o=function(t,e,n,i){return e[n[a(t,i)]]};e.isKeysEqual=function(t,e){if(t.length!==e.length)return!1;for(var n=0;n<e.length;n++)if(t[n]!==e[n])return!1;return!0};e.findChanges=function(t,e,n,i){var r={},s={},l=0,c=0,u=[];t.forEach((function(t,e){var i=a(t,n);r[i]=e})),e.forEach((function(t,e){var i=a(t,n);s[i]=e}));for(var d=Math.max(t.length,e.length),h=0;h<d+l;h++){var f=e[h],p=h-l+c,g=t[p];if(!f||g&&!o(g,e,s,n))g&&(u.push({type:"remove",key:n(g),index:h,oldItem:g}),c++,h--);else{var m=a(f,n),_=r[m],v=t[_];if(v){if(_!==p)return;i(v,f)||u.push({type:"update",data:f,key:n(f),index:h,oldItem:v})}else l++,u.push({type:"insert",data:f,index:h})}}return u}},47810:function(t,e,n){e.default=void 0;var i=n(13306),a=(0,n(58201).getNavigator)(),o=/(webkit)[ /]([\w.]+)/,r=/(mozilla)(?:.*? rv:([\w.]+))/,s=function(t){t=t.toLowerCase();var e={},n=o.exec(t)||t.indexOf("compatible")<0&&r.exec(t)||[],i=n[1],a=n[2];return"webkit"===i&&(e.webkit=!0,t.indexOf("chrome")>=0||t.indexOf("crios")>=0?(i="chrome",a=(a=/(?:chrome|crios)\/(\d+\.\d+)/.exec(t))&&a[1]):t.indexOf("fxios")>=0?(i="mozilla",a=(a=/fxios\/(\d+\.\d+)/.exec(t))&&a[1]):t.indexOf("safari")>=0&&/version|phantomjs/.test(t)?(i="safari",a=(a=/(?:version|phantomjs)\/([0-9.]+)/.exec(t))&&a[1]):(i="unknown",a=(a=/applewebkit\/([0-9.]+)/.exec(t))&&a[1])),i&&(e[i]=!0,e.version=a),e},l=(0,i.extend)({_fromUA:s},s(a.userAgent));e.default=l,t.exports=e.default,t.exports.default=e.default},39618:function(t,e){e.default=void 0;var n=function(t){var e,n=function(){return e=t.apply(this,arguments),n=function(){return e},e};return function(){return n.apply(this,arguments)}};e.default=n,t.exports=e.default,t.exports.default=e.default},44504:function(t,e){e.default=void 0;var n=function(t){this._options=t||{},this._list=[],this._queue=[],this._firing=!1,this._fired=!1,this._firingIndexes=[]};n.prototype._fireCore=function(t,e){var n=this._firingIndexes,i=this._list,a=this._options.stopOnFalse,o=n.length;for(n[o]=0;n[o]<i.length;n[o]++){if(!1===i[n[o]].apply(t,e)&&a)break}n.pop()},n.prototype.add=function(t){return"function"!=typeof t||this._options.unique&&this.has(t)||this._list.push(t),this},n.prototype.remove=function(t){var e=this._list,n=this._firingIndexes,i=e.indexOf(t);if(i>-1&&(e.splice(i,1),this._firing&&n.length))for(var a=0;a<n.length;a++)i<=n[a]&&n[a]--;return this},n.prototype.has=function(t){var e=this._list;return t?e.indexOf(t)>-1:!!e.length},n.prototype.empty=function(t){return this._list=[],this},n.prototype.fireWith=function(t,e){var n=this._queue;if(e=(e=e||[]).slice?e.slice():e,this._options.syncStrategy)this._firing=!0,this._fireCore(t,e);else{if(n.push([t,e]),this._firing)return;for(this._firing=!0;n.length;){var i=n.shift();this._fireCore(i[0],i[1])}}return this._firing=!1,this._fired=!0,this},n.prototype.fire=function(){this.fireWith(this,arguments)},n.prototype.fired=function(){return this._fired};var i=function(t){return new n(t)};e.default=i,t.exports=e.default,t.exports.default=e.default},20576:function(t,e,n){e.splitPair=e.pairToObject=e.normalizeKey=e.noop=e.grep=e.getKeyHash=e.findBestMatches=e.executeAsync=e.escapeRegExp=e.equalByValue=e.ensureDefined=e.denormalizeKey=e.deferUpdater=e.deferUpdate=e.deferRenderer=e.deferRender=e.asyncNoop=e.applyServerDecimalSeparator=void 0;var i=c(n(80209)),a=c(n(73176)),o=n(62754),r=n(47617),s=n(95479),l=n(35922);function c(t){return t&&t.__esModule?t:{default:t}}function u(){return(u=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}e.ensureDefined=function(t,e){return(0,l.isDefined)(t)?t:e};e.executeAsync=function(t,e){var n=new o.Deferred,i=e||this,a={promise:n.promise(),abort:function(){clearTimeout(s),n.rejectWith(i)}},r=function(){var e=t.call(i);e&&e.done&&(0,l.isFunction)(e.done)?e.done((function(){n.resolveWith(i)})):n.resolveWith(i)},s=(arguments[2]||setTimeout)(r,"number"==typeof e?e:0);return a};var d,h=[],f=[],p=[],g=function(t,e,n){if(d&&d!==t)return h.push(e),f.push(t),n=n||new o.Deferred,p.push(n),n;var i=d,a=p.length;d=t;var r=e();return r||(p.length>a?r=o.when.apply(this,p.slice(a)):n&&n.resolve()),d=i,n&&r&&r.done&&r.done(n.resolve).fail(n.reject),!d&&h.length&&("render"===f.shift()?m:_)(h.shift(),p.shift()),r||(0,o.when)()},m=function(t,e){return g("render",t,e)};e.deferRender=m;var _=function(t,e){return g("update",t,e)};e.deferUpdate=_;e.deferRenderer=function(t){return function(){var e=this;return g("render",(function(){return t.call(e)}))}};e.deferUpdater=function(t){return function(){var e=this;return g("update",(function(){return t.call(e)}))}};e.findBestMatches=function(t,e,n){var i=[],a=0;return(0,s.each)(e,(function(e,o){var r=0,l=n?n(o):o;(0,s.each)(t,(function(t,e){var n=l[t];if(void 0!==n){if(!v(n,e))return r=-1,!1;r++}})),r<a||(r>a&&(i.length=0,a=r),i.push(o))})),i};var v=function(t,e){if(Array.isArray(t)&&Array.isArray(e)){var n=!1;return(0,s.each)(t,(function(t,i){if(i!==e[t])return n=!0,!1})),!n}return t===e},b=function(t){var e,n;switch((0,l.type)(t)){case"string":return t.split(/\s+/,2);case"object":return[null!==(e=t.x)&&void 0!==e?e:t.h,null!==(n=t.y)&&void 0!==n?n:t.v];case"number":return[t];case"array":return t;default:return null}};e.splitPair=b;e.normalizeKey=function(t){var e=(0,l.isString)(t)?t:t.toString(),n=e.match(/[^a-zA-Z0-9_]/g);return n&&(0,s.each)(n,(function(t,n){e=e.replace(n,"__"+n.charCodeAt()+"__")})),e};e.denormalizeKey=function(t){var e=t.match(/__\d+__/g);return e&&e.forEach((function(e){var n=parseInt(e.replace("__",""));t=t.replace(e,String.fromCharCode(n))})),t};e.pairToObject=function(t,e){var n=b(t),i=e?parseFloat(n&&n[0]):parseInt(n&&n[0],10),a=e?parseFloat(n&&n[1]):parseInt(n&&n[1],10);return isFinite(i)||(i=0),isFinite(a)||(a=i),{h:i,v:a}};e.getKeyHash=function(t){if(t instanceof a.default)return t.toString();if((0,l.isObject)(t)||Array.isArray(t))try{var e=JSON.stringify(t);return"{}"===e?t:e}catch(e){return t}return t};e.escapeRegExp=function(t){return t.replace(/[[\]{}\-()*+?.\\^$|\s]/g,"\\$&")};e.applyServerDecimalSeparator=function(t){var e=(0,i.default)().serverDecimalSeparator;return(0,l.isDefined)(t)&&(t=t.toString().replace(".",e)),t};e.noop=function(){};e.asyncNoop=function(){return(new o.Deferred).resolve().promise()};e.grep=function(t,e,n){for(var i=[],a=!n,o=0;o<t.length;o++)!!e(t[o],o)===a&&i.push(t[o]);return i};var y=function(t,e,n,i){return t.length===e.length&&!t.some((function(t,a){return!k(t,e[a],n+1,u({},i,{strict:!0}))}))},x=function(t,e,n,i){var a=Object.keys(t),o=Object.keys(e);if(a.length!==o.length)return!1;var r=new Set(o);return!a.some((function(a){return!r.has(a)||!k(t[a],e[a],n+1,i)}))},w={maxDepth:3,strict:!0},k=function(t,e,n,i){var a=i.strict,o=i.maxDepth,s=(0,r.toComparable)(t,!0),c=(0,r.toComparable)(e,!0);switch(!0){case a?s===c:s==c:case n>=o:return!0;case(0,l.isObject)(s)&&(0,l.isObject)(c):return x(s,c,n,i);case Array.isArray(s)&&Array.isArray(c):return y(s,c,n,i);default:return!1}};e.equalByValue=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:w,i=u({},w,n);return k(t,e,0,i)}},49036:function(t,e,n){e.equals=void 0;var i,a=(i=n(73349))&&i.__esModule?i:{default:i},o=n(47617),r=n(35922);function s(t){return(s="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}e.equals=function(t,e){return t=(0,o.toComparable)(t,!0),e=(0,o.toComparable)(e,!0),t&&e&&(0,r.isRenderer)(t)&&(0,r.isRenderer)(e)?e.is(t):!(t==t||e==e)||(0===t&&0===e?function(t,e){return 1/t==1/e}(t,e):!(null!==t&&"object"===s(t)&&!a.default.isElementNode(t))&&t===e)}},30869:function(t,e,n){e.logger=e.debug=void 0;var i=n(35922),a=function(){},o=function(t){return"undefined"!=typeof console&&(0,i.isFunction)(console[t])?console[t].bind(console):a},r={log:o("log"),info:o("info"),warn:o("warn"),error:o("error")};e.logger=r;var s=function(){function t(t,e){if(!t)throw new Error(e)}return{assert:t,assertParam:function(e,n){t(null!=e,n)}}}();e.debug=s},47617:function(t,e,n){e.toComparable=e.getPathParts=e.compileSetter=e.compileGetter=void 0;var i=c(n(17381)),a=c(n(38377)),o=n(48013),r=n(35922),s=n(95479),l=c(n(26974));function c(t){return t&&t.__esModule?t:{default:t}}var u=l.default.unwrap,d=l.default.isWrapped,h=l.default.assign,f=function(t){return(e=t,e.replace(/\[/g,".").replace(/\]/g,"")).split(".");var e};e.getPathParts=f;var p=function(t,e,n,a){if("this"===e)throw new i.default.Error("E4016");var o=t[e];a.unwrapObservables&&d(o)?h(o,n):t[e]=n},g=function(t){return(t=t||{}).unwrapObservables=void 0===t.unwrapObservables||t.unwrapObservables,t};function m(t,e){return e.unwrapObservables?u(t):t}var _=function(t){if(arguments.length>1&&(t=[].slice.call(arguments)),!t||"this"===t)return function(t){return t};if("string"==typeof t){var e=f(t);return function(t,n){for(var i=(n=g(n)).functionsAsIs,a=("defaultValue"in n),o=m(t,n),s=0;s<e.length;s++){if(!o){if(null==o&&a)return n.defaultValue;break}var l=e[s];if(a&&(0,r.isObject)(o)&&!(l in o))return n.defaultValue;var c=m(o[l],n);!i&&(0,r.isFunction)(c)&&(c=c.call(o)),o=c}return o}}return Array.isArray(t)?v(t):(0,r.isFunction)(t)?t:void 0};function v(t){for(var e={},n=0,i=t.length;n<i;n++){var a=t[n];e[a]=_(a)}return function(t,n){var i;return(0,s.each)(e,(function(e){var a=this(t,n);if(void 0!==a){for(var o=i||(i={}),r=e.split("."),s=r.length-1,l=0;l<s;l++){var c=r[l];c in o||(o[c]={}),o=o[c]}o[r[s]]=a}})),i}}e.compileGetter=_;var b=function(t,e,n,i){if((0,r.isDefined)(n))return n;var a={};return p(t,e,a,i),a};e.compileSetter=function(t){var e=(t=f(t||"this")).length-1;return function(n,i,a){var s=m(n,a=g(a));t.forEach((function(t,n){var l=function(t,e,n){return n=n||{},m("this"===e?t:t[e],n)}(s,t,a),c=!a.functionsAsIs&&(0,r.isFunction)(l)&&!d(l);n===e?a.merge&&(0,r.isPlainObject)(i)&&(!(0,r.isDefined)(l)||(0,r.isPlainObject)(l))?(l=b(s,t,l,a),(0,o.deepExtendArraySafe)(l,i,!1,!0)):c?s[t](i):p(s,t,i,a):(l=b(s,t,l,a),c&&(l=l.call(s)),s=l)}))}};e.toComparable=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{};if(t instanceof Date)return t.getTime();if(t&&t instanceof a.default&&t.valueOf)return t.valueOf();if(!e&&"string"==typeof t){var i;if("base"===(null==n||null===(i=n.collatorOptions)||void 0===i?void 0:i.sensitivity)){var o=/[\u0300-\u036f]/g;t=t.normalize("NFD").replace(o,"")}return null!=n&&n.locale?t.toLocaleLowerCase(n.locale):t.toLowerCase()}return t}},91198:function(t,e,n){e.default=void 0;var i=n(35922),a=n(60810),o=n(95479),r=n(78008),s=n(25050);function l(t,e,n){return(l=c()?Reflect.construct.bind():function(t,e,n){var i=[null];i.push.apply(i,e);var a=new(Function.bind.apply(t,i));return n&&u(a,n.prototype),a}).apply(null,arguments)}function c(){if("undefined"==typeof Reflect||!Reflect.construct)return!1;if(Reflect.construct.sham)return!1;if("function"==typeof Proxy)return!0;try{return Boolean.prototype.valueOf.call(Reflect.construct(Boolean,[],(function(){}))),!0}catch(t){return!1}}function u(t,e){return(u=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var d=["millisecond","second","minute","hour","day","week","month","quarter","year"],h=function(t){var e,n,i,a=["millisecond","second","minute","hour","day","month","year"],o={};for(e=a.length-1;e>=0;e--)i=a[e],(n=Math.floor(t/(0,s.toMilliseconds)(i)))>0&&(o[i+"s"]=n,t-=f(i,n));return o};function f(t,e){return(0,s.toMilliseconds)(t)*e}function p(t){var e,n=-1;return(0,i.isString)(t)?t:(0,i.isObject)(t)?((0,o.each)(t,(function(t,i){for(e=0;e<d.length;e++)i&&(t===d[e]+"s"||t===d[e])&&n<e&&(n=e)})),d[n]):""}var g={millisecond:"millisecond",second:"longtime",minute:"shorttime",hour:"shorttime",day:"day",week:"day",month:"month",quarter:"quarter",year:"year"};var m=function(t){return Math.floor(t/3)},_=function(t){return 3*m(t)};function v(t,e,n,i){t=new Date(t.getTime());var a,o,r=new Date(t.getTime()),s=p(e);switch(s){case"second":t=new Date(1e3*Math.floor(r.getTime()/1e3));break;case"minute":t=new Date(6e4*Math.floor(r.getTime()/6e4));break;case"hour":t=new Date(36e5*Math.floor(r.getTime()/36e5));break;case"year":t.setMonth(0);case"month":t.setDate(1);case"day":t.setHours(0,0,0,0);break;case"week":(t=T(t,i||0)).setHours(0,0,0,0);break;case"quarter":a=_(t.getMonth()),o=t.getMonth(),t.setDate(1),t.setHours(0,0,0,0),o!==a&&t.setMonth(a)}return n&&"hour"!==s&&"minute"!==s&&"second"!==s&&P(r,t),t}function b(t){return v(t,"day")}function y(t,e,n){var a=new Date(t.getTime()),o=(0,i.isString)(e)?k(e.toLowerCase()):(0,i.isNumeric)(e)?h(e):e;return o.years&&a.setFullYear(a.getFullYear()+o.years*n),o.quarters&&a.setMonth(a.getMonth()+3*o.quarters*n),o.months&&a.setMonth(a.getMonth()+o.months*n),o.weeks&&a.setDate(a.getDate()+7*o.weeks*n),o.days&&a.setDate(a.getDate()+o.days*n),o.hours&&a.setTime(a.getTime()+36e5*o.hours*n),o.minutes&&a.setTime(a.getTime()+6e4*o.minutes*n),o.seconds&&a.setTime(a.getTime()+1e3*o.seconds*n),o.milliseconds&&a.setTime(a.getTime()+o.milliseconds*n),a}var x=function(t,e,n){var o=n?-1:1;return(0,i.isDate)(t)?y(t,e,o):(0,a.adjust)(t+e*o,e)};function w(t){return B(t.getFullYear(),t.getMonth()+1,0).getDate()}function k(t){var e={};switch(t){case"year":e.years=1;break;case"month":e.months=1;break;case"quarter":e.months=3;break;case"week":e.weeks=1;break;case"day":e.days=1;break;case"hour":e.hours=1;break;case"minute":e.minutes=1;break;case"second":e.seconds=1;break;case"millisecond":e.milliseconds=1}return e}function S(t,e){return C(t,e)&&t.getMonth()===e.getMonth()}function C(t,e){return t&&e&&t.getFullYear()===e.getFullYear()}function A(t){return t&&t.getFullYear()-t.getFullYear()%100}function E(t){return t&&t.getFullYear()-t.getFullYear()%10}function T(t,e){var n=(t.getDay()-e+7)%7,i=new Date(t);return i.setDate(t.getDate()-n),i}function I(t){return Date.UTC(t.getFullYear(),t.getMonth(),t.getDate())}function D(t){return new Date(t,0,1)}function O(t){return new Date(t,11,31)}function L(t,e){var n=t.getDay()-e+1;return n<=0&&(n+=7),n}function M(t,e,n){var a=t;return(0,i.isDefined)(t)?((0,i.isDefined)(e)&&t<e&&(a=e),(0,i.isDefined)(n)&&t>n&&(a=n),a):t}function P(t,e){if((0,i.isDefined)(t)){var n=e.getHours()-t.getHours();if(0!==n){var a=1===n||-23===n?-1:1,o=new Date(e.getTime()+36e5*a);(a>0||o.getDate()===e.getDate())&&e.setTime(o.getTime())}}}function R(t,e){return 60*(e.getTimezoneOffset()-t.getTimezoneOffset())*1e3}var B=function(t){var e=l(Date,Array.prototype.slice.call(arguments));return e.setFullYear(t),e},z={dateUnitIntervals:d,convertMillisecondsToDateUnits:h,dateToMilliseconds:function(t){var e=0;return(0,i.isObject)(t)&&(0,o.each)(t,(function(t,n){e+=f(t.substr(0,t.length-1),n)})),(0,i.isString)(t)&&(e=f(t,1)),e},getNextDateUnit:function(t,e){switch(p(t)){case"millisecond":return"second";case"second":return"minute";case"minute":return"hour";case"hour":return"day";case"day":return e?"week":"month";case"week":return"month";case"month":return"quarter";case"quarter":case"year":return"year";default:return 0}},convertDateUnitToMilliseconds:f,getDateUnitInterval:p,getDateFormatByTickInterval:function(t){return g[p(t)]||""},getDatesDifferences:function(t,e){var n=0,i={year:t.getFullYear()!==e.getFullYear(),month:t.getMonth()!==e.getMonth(),day:t.getDate()!==e.getDate(),hour:t.getHours()!==e.getHours(),minute:t.getMinutes()!==e.getMinutes(),second:t.getSeconds()!==e.getSeconds(),millisecond:t.getMilliseconds()!==e.getMilliseconds()};return(0,o.each)(i,(function(t,e){e&&n++})),0===n&&0!==R(t,e)&&(i.hour=!0,n++),i.count=n,i},correctDateWithUnitBeginning:v,trimTime:b,setToDayEnd:function(t){var e=b(t);return e.setDate(e.getDate()+1),new Date(e.getTime()-1)},roundDateByStartDayHour:function(t,e){var n=this.dateTimeFromDecimal(e),i=new Date(t);return(t.getHours()===n.hours&&t.getMinutes()<n.minutes||t.getHours()<n.hours)&&i.setHours(n.hours,n.minutes,0,0),i},dateTimeFromDecimal:function(t){return{hours:Math.floor(t),minutes:t%1*60}},addDateInterval:y,addInterval:x,getSequenceByInterval:function(t,e,n){var a,o=[];for(o.push((0,i.isDate)(t)?new Date(t.getTime()):t),a=t;a<e;)a=x(a,n),o.push(a);return o},getDateIntervalByString:k,sameHoursAndMinutes:function(t,e){return t&&e&&t.getHours()===e.getHours()&&t.getMinutes()===e.getMinutes()},sameDate:function(t,e){return S(t,e)&&t.getDate()===e.getDate()},sameMonthAndYear:S,sameMonth:S,sameYear:C,sameDecade:function(t,e){if((0,i.isDefined)(t)&&(0,i.isDefined)(e)){var n=t.getFullYear()-t.getFullYear()%10,a=e.getFullYear()-e.getFullYear()%10;return t&&e&&n===a}},sameCentury:function(t,e){if((0,i.isDefined)(t)&&(0,i.isDefined)(e)){var n=t.getFullYear()-t.getFullYear()%100,a=e.getFullYear()-e.getFullYear()%100;return t&&e&&n===a}},getDifferenceInMonth:function(t){var e=1;return"year"===t&&(e=12),"decade"===t&&(e=120),"century"===t&&(e=1200),e},getDifferenceInMonthForCells:function(t){var e=1;return"decade"===t&&(e=12),"century"===t&&(e=120),e},getFirstYearInDecade:E,getFirstDecadeInCentury:A,getShortDateFormat:function(){return"yyyy/MM/dd"},getViewFirstCellDate:function(t,e){return"month"===t?B(e.getFullYear(),e.getMonth(),1):"year"===t?B(e.getFullYear(),0,e.getDate()):"decade"===t?B(E(e),e.getMonth(),e.getDate()):"century"===t?B(A(e),e.getMonth(),e.getDate()):void 0},getViewLastCellDate:function(t,e){return"month"===t?B(e.getFullYear(),e.getMonth(),w(e)):"year"===t?B(e.getFullYear(),11,e.getDate()):"decade"===t?B(E(e)+9,e.getMonth(),e.getDate()):"century"===t?B(A(e)+90,e.getMonth(),e.getDate()):void 0},getViewDown:function(t){switch(t){case"century":return"decade";case"decade":return"year";case"year":return"month"}},getViewUp:function(t){switch(t){case"month":return"year";case"year":return"decade";case"decade":return"century"}},getLastMonthDay:w,getLastMonthDate:function(t){if((0,i.isDefined)(t))return B(t.getFullYear(),t.getMonth()+1,0)},getFirstMonthDate:function(t){if((0,i.isDefined)(t))return B(t.getFullYear(),t.getMonth(),1)},getFirstWeekDate:T,getWeekNumber:function t(e,n,i){var a=L(D(e.getFullYear()),n),o=L(O(e.getFullYear()),n),r=7-a+1,l=Math.ceil((function(t){var e=I(t)-I(D(t.getFullYear()));return 1+Math.floor(e/(0,s.toMilliseconds)("day"))}(e)-r)/7);switch(i){case"fullWeek":return 7===r&&l++,0===l?t(O(e.getFullYear()-1),n,i):l;case"firstDay":return r>0&&l++,(l>52&&!(7===a||7===o)||54===l)&&(l=1),l;case"firstFourDays":return r>3&&l++,l>52&&!(4===a||4===o)&&(l=1),0===l?t(O(e.getFullYear()-1),n,i):l}},normalizeDateByWeek:function(t,e){var n=z.getDatesInterval(t,e,"day"),i=new Date(t);return n>=6&&(i=new Date(i.setDate(i.getDate()+7))),i},getQuarter:m,getFirstQuarterMonth:_,dateInRange:function(t,e,n,i){return"date"===i&&(e=e&&z.correctDateWithUnitBeginning(e,"day"),n=n&&z.correctDateWithUnitBeginning(n,"day"),t=t&&z.correctDateWithUnitBeginning(t,"day")),M(t,e,n)===t},intervalsOverlap:function(t){var e=t.firstMin,n=t.firstMax,i=t.secondMin,a=t.secondMax;return e<=i&&i<=n||e>i&&e<a||e<a&&n>a},roundToHour:function(t){var e=new Date(t.getTime());return e.setHours(e.getHours()+1),e.setMinutes(0),e},normalizeDate:M,getViewMinBoundaryDate:function(t,e){var n=B(e.getFullYear(),e.getMonth(),1);return"month"===t?n:(n.setMonth(0),"year"===t||("decade"===t&&n.setFullYear(E(e)),"century"===t&&n.setFullYear(A(e))),n)},getViewMaxBoundaryDate:function(t,e){var n=new Date(e);return n.setDate(w(e)),"month"===t?n:(n.setMonth(11),n.setDate(w(n)),"year"===t||("decade"===t&&n.setFullYear(E(e)+9),"century"===t&&n.setFullYear(A(e)+99)),n)},fixTimezoneGap:P,getTimezonesDifference:R,makeDate:function(t){return new Date(t)},getDatesInterval:function(t,e,n){var i=e.getTime()-t.getTime(),a=(0,s.toMilliseconds)(n)||1;return Math.floor(i/a)},getDatesOfInterval:function(t,e,n){for(var i=[],a=new Date(t.getTime());a<e;)i.push(new Date(a.getTime())),a=this.addInterval(a,n);return i},createDateWithFullYear:B,getMachineTimezoneName:function(){return"undefined"!=typeof Intl?Intl.DateTimeFormat().resolvedOptions().timeZone:null},sameView:function(t,e,n){return z[(0,r.camelize)("same "+t)](e,n)}},q=z;e.default=q,t.exports=e.default,t.exports.default=e.default},69434:function(t,e,n){e.default=void 0;var i=s(n(80209)),a=n(40594),o=s(n(15564)),r=n(35922);function s(t){return t&&t.__esModule?t:{default:t}}var l=/^(\d{4,})(-)?(\d{2})(-)?(\d{2})(?:T(\d{2})(:)?(\d{2})?(:)?(\d{2}(?:\.(\d{1,3})\d*)?)?)?(Z|([+-])(\d{2})(:)?(\d{2})?)?$/,c=/^(\d{2}):(\d{2})(:(\d{2}))?$/,u=["","yyyy","","MM","","dd","THH","","mm","","ss",".SSS"],d=/^(\d{4})\/(\d{2})\/(\d{2})$/,h=function(t,e){var n;return(0,r.isString)(t)&&!e&&(n=function(t){var e=t.match(l);if(!e)return(e=t.match(c))?new Date(0,0,0,f(e[1]),f(e[2]),f(e[4])):void 0;var n=f(e[1]),i=--e[3],a=e[5],o=0,r=0,s=function(t){return n<100&&t.setFullYear(n),t};o=f(e[14]),r=f(e[16]),"-"===e[13]&&(o=-o,r=-r);var u=f(e[6])-o,d=f(e[8])-r,h=f(e[10]),p=(g=e[11],f(g=g||"")*Math.pow(10,3-g.length));var g;if(e[12])return s(new Date(Date.UTC(n,i,a,u,d,h,p)));return s(new Date(n,i,a,u,d,h,p))}(t)),n||function(t){var e="yyyy/MM/dd"===p(t),n=!(0,r.isDate)(t)&&Date.parse(t);if(!n&&e){var i=t.match(d);if(i){var a=new Date(f(i[1]),f(i[2]),f(i[3]));return a.setFullYear(f(i[1])),a.setMonth(f(i[2])-1),a.setDate(f(i[3])),a}}return(0,r.isNumeric)(n)?new Date(n):t}(t)};function f(t){return+t||0}var p=function(t){return"number"==typeof t?"number":(0,r.isString)(t)?((0,i.default)().forceIsoDateParsing&&(e=function(t,e){var n=t.match(l),i="";if(!n)return(n=t.match(c))?n[3]?"HH:mm:ss":"HH:mm":void 0;for(var a=1;a<u.length;a++)n[a]&&(i+=u[a]||n[a]);return"Z"===n[12]&&(i+="'Z'"),n[14]&&(n[15]?i+="xxx":n[16]?i+="xx":i+="x"),i}(t)),e||(t.indexOf(":")>=0?"yyyy/MM/dd HH:mm:ss":"yyyy/MM/dd")):t?null:void 0;var e},g={dateParser:h,deserializeDate:function(t){return"number"==typeof t?new Date(t):h(t,!(0,i.default)().forceIsoDateParsing)},serializeDate:function(t,e){return e?(0,r.isDate)(t)?"number"===e?t&&t.valueOf?t.valueOf():null:(0,a.getFormatter)(e,o.default)(t):null:t},getDateSerializationFormat:p};e.default=g,t.exports=e.default,t.exports.default=e.default},62754:function(t,e,n){e.Deferred=function(){return new l},e.fromPromise=c,e.setStrategy=function(t){l=t.Deferred,u=t.when},e.when=function(){return u.apply(this,arguments)};var i,a=n(35922),o=n(13306),r=(i=n(44504))&&i.__esModule?i:{default:i};var s=[{method:"resolve",handler:"done",state:"resolved"},{method:"reject",handler:"fail",state:"rejected"},{method:"notify",handler:"progress"}],l=function(){var t=this;this._state="pending",this._promise={},s.forEach(function(e){var n=e.method;this[n+"Callbacks"]=(0,r.default)(),this[n]=function(){return this[n+"With"](this._promise,arguments)}.bind(this),this._promise[e.handler]=function(e){if(!e)return this;var i=t[n+"Callbacks"];return i.fired()?e.apply(t[n+"Context"],t[n+"Args"]):i.add(function(t,n){e.apply(t,n)}.bind(this)),this}}.bind(this)),this._promise.always=function(t){return this.done(t).fail(t)},this._promise.catch=function(t){return this.then(null,t)},this._promise.then=function(t,e){var n=new l;return["done","fail"].forEach(function(i){var o="done"===i?t:e;this[i]((function(){if(o){var t=o&&o.apply(this,arguments);(0,a.isDeferred)(t)?t.done(n.resolve).fail(n.reject):(0,a.isPromise)(t)?t.then(n.resolve,n.reject):n.resolve.apply(this,(0,a.isDefined)(t)?[t]:arguments)}else n["done"===i?"resolve":"reject"].apply(this,arguments)}))}.bind(this)),n.promise()},this._promise.state=function(){return t._state},this._promise.promise=function(e){return e?(0,o.extend)(e,t._promise):t._promise},this._promise.promise(this)};function c(t,e){if((0,a.isDeferred)(t))return t;if((0,a.isPromise)(t)){var n=new l;return t.then((function(){n.resolveWith.apply(n,[e].concat([[].slice.call(arguments)]))}),(function(){n.rejectWith.apply(n,[e].concat([[].slice.call(arguments)]))})),n}return(new l).resolveWith(e,[t])}s.forEach((function(t){var e=t.method,n=t.state;l.prototype[e+"With"]=function(t,i){var a=this[e+"Callbacks"];return"pending"===this.state()&&(this[e+"Args"]=i,this[e+"Context"]=t,n&&(this._state=n),a.fire(t,i)),this}}));var u=function(){if(1===arguments.length)return c(arguments[0]);for(var t=[].slice.call(arguments),e=[],n=0,i=new l,o=function(a){return function(o){e[a]=this,t[a]=arguments.length>1?[].slice.call(arguments):o,++n===t.length&&i.resolveWith(e,t)}},r=0;r<t.length;r++)(0,a.isDeferred)(t[r])?t[r].promise().done(o(r)).fail(i.reject):n++;return n===t.length&&i.resolveWith(e,t),i.promise()}},20476:function(t,e,n){e.default=function(t){var e=s.default.inherit(t),n=e,i=new n(t),l={},c=function(e,n){(0,r.each)(e,(function(e){(0,o.isFunction)(i[e])?!n&&t[e]||(t[e]=function(){return i[e].apply(t,arguments)}):(n&&(l[e]=t[e]),t[e]=i[e])}))};return c(t,!0),t.inject=function(t){n=n.inherit(t),i=new n,c(t)},t.resetInjection=function(){(0,a.extend)(t,l),n=e,i=new e},t};var i,a=n(13306),o=n(35922),r=n(95479),s=(i=n(38377))&&i.__esModule?i:{default:i};t.exports=e.default,t.exports.default=e.default},3532:function(t,e,n){e.resetActiveElement=e.replaceWith=e.normalizeTemplateElement=e.isElementInDom=e.insertBefore=e.extractTemplateMarkup=e.createTextElementHiddenCopy=e.contains=e.closestCommonParent=e.clipboardText=e.clearSelection=void 0;var i=l(n(73349)),a=l(n(68374)),o=n(95479),r=n(35922),s=n(58201);function l(t){return t&&t.__esModule?t:{default:t}}var c=(0,s.getWindow)();e.resetActiveElement=function(){var t,e=i.default.getActiveElement();e&&e!==i.default.getBody()&&(null===(t=e.blur)||void 0===t||t.call(e))};e.clearSelection=function(){var t=c.getSelection();if(t&&"Caret"!==t.type)if(t.empty)t.empty();else if(t.removeAllRanges)try{t.removeAllRanges()}catch(t){}};e.closestCommonParent=function(t,e){var n=(0,a.default)(t),i=(0,a.default)(e);if(n[0]===i[0])return n[0];for(var o=n.parents(),r=i.parents(),s=-Math.min(o.length,r.length);s<0;s++)if(o.get(s)===r.get(s))return o.get(s)};e.extractTemplateMarkup=function(t){var e=(t=(0,a.default)(t)).length&&t.filter((function(){var t=(0,a.default)(this);return t.is("script[type]")&&t.attr("type").indexOf("script")<0}));return e.length?e.eq(0).html():(t=(0,a.default)("<div>").append(t)).html()};e.normalizeTemplateElement=function t(e){var n=(0,r.isDefined)(e)&&(e.nodeType||(0,r.isRenderer)(e))?(0,a.default)(e):(0,a.default)("<div>").html(e).contents();return 1===n.length&&(n.is("script")?n=t(n.html().trim()):n.is("table")&&(n=n.children("tbody").contents())),n};e.clipboardText=function(t,e){var n=t.originalEvent&&t.originalEvent.clipboardData||c.clipboardData;if(!e)return n&&n.getData("Text");n&&n.setData("Text",e)};e.contains=function t(e,n){return!!n&&((0,r.isWindow)(e)?t(e.document,n):e.contains(n)||t(e,function(t){if(t.getRootNode){var e=t.getRootNode().host;if(!(0,r.isString)(e))return e}}(n)))};e.createTextElementHiddenCopy=function(t,e,n){var i=c.getComputedStyle((0,a.default)(t).get(0)),o=n&&n.includePaddings;return(0,a.default)("<div>").text(e).css({fontStyle:i.fontStyle,fontVariant:i.fontVariant,fontWeight:i.fontWeight,fontSize:i.fontSize,fontFamily:i.fontFamily,letterSpacing:i.letterSpacing,border:i.border,paddingTop:o?i.paddingTop:"",paddingRight:o?i.paddingRight:"",paddingBottom:o?i.paddingBottom:"",paddingLeft:o?i.paddingLeft:"",visibility:"hidden",whiteSpace:"pre",position:"absolute",float:"left"})};var u=function(t,e){return e&&i.default.insertElement(t.parentNode,e,t),t};e.insertBefore=u;e.replaceWith=function(t,e){if(e&&e[0])return e.is(t)?t:((0,o.each)(e,(function(e,n){u(t[0],n)})),t.remove(),e)};e.isElementInDom=function(t){var e=null==t?void 0:t.get(0),n=null==e?void 0:e.getRootNode().host;return!!(0,a.default)(n||e).closest((0,s.getWindow)().document).length}},95640:function(t,e,n){e.default=function(t,e){var n={ERROR_MESSAGES:(0,i.extend)(e,t),Error:function(){return u([].slice.call(arguments))},log:function(t){var e="log";/^E\d+$/.test(t)?e="error":/^W\d+$/.test(t)&&(e="warn"),a.logger[e]("log"===e?t:s([].slice.call(arguments)))}};function s(t){var e=t[0];return c(e,l(e,t=t.slice(1)))}function l(t,e){return e=[n.ERROR_MESSAGES[t]].concat(e),o.format.apply(this,e).replace(/\.*\s*?$/,"")}function c(t,e){return o.format.apply(this,["{0} - {1}. See:\n{2}",t,e,d(t)])}function u(t){var e=t[0],n=l(e,t=t.slice(1)),a=d(e),o=c(e,n);return(0,i.extend)(new Error(o),{__id:e,__details:n,url:a})}function d(t){return r+t}return n};var i=n(13306),a=n(30869),o=n(68752),r="http://js.devexpress.com/error/"+n(36739).version.split(".").slice(0,2).join("_")+"/";t.exports=e.default,t.exports.default=e.default},13306:function(t,e,n){e.extendFromObject=e.extend=void 0;var i=n(35922);e.extendFromObject=function(t,e,n){for(var i in t=t||{},e)if(Object.prototype.hasOwnProperty.call(e,i)){var a=e[i];i in t&&!n||(t[i]=a)}return t};e.extend=function t(e){var n=1,a=!1;for("boolean"==typeof(e=e||{})&&(a=e,e=arguments[1]||{},n++);n<arguments.length;n++){var o=arguments[n];if(null!=o)for(var r in o){var s=e[r],l=o[r],c=!1,u=void 0;"__proto__"!==r&&"constructor"!==r&&e!==l&&(a&&l&&((0,i.isPlainObject)(l)||(c=Array.isArray(l)))?(u=c?s&&Array.isArray(s)?s:[]:s&&(0,i.isPlainObject)(s)?s:{},e[r]=t(a,u,l)):void 0!==l&&(e[r]=l))}}return e}},61371:function(t,e,n){e.parseHTML=e.isTablePart=void 0;var i,a=(i=n(73349))&&i.__esModule?i:{default:i};function o(t){return function(t){if(Array.isArray(t))return r(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var s=/<([a-z][^/\0>\x20\t\r\n\f]+)/i,l={default:{tagsCount:0,startTags:"",endTags:""},thead:{tagsCount:1,startTags:"<table>",endTags:"</table>"},td:{tagsCount:3,startTags:"<table><tbody><tr>",endTags:"</tr></tbody></table>"},col:{tagsCount:2,startTags:"<table><colgroup>",endTags:"</colgroup></table>"},tr:{tagsCount:2,startTags:"<table><tbody>",endTags:"</tbody></table>"}};l.tbody=l.colgroup=l.caption=l.tfoot=l.thead,l.th=l.td;e.parseHTML=function(t){if("string"!=typeof t)return null;var e=a.default.createDocumentFragment().appendChild(a.default.createElement("div")),n=s.exec(t),i=n&&n[1].toLowerCase(),r=l[i]||l.default;e.innerHTML=r.startTags+t+r.endTags;for(var c=0;c<r.tagsCount;c++)e=e.lastChild;return o(e.childNodes)};e.isTablePart=function(t){var e=s.exec(t);return e&&e[1]in l}},44899:function(t,e,n){e.getImageSourceType=e.getImageContainer=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i};var o=function(t){return!(!t||"string"!=typeof t)&&(/^\s*<svg[^>]*>(.|\r?\n)*?<\/svg>\s*$/i.test(t)?"svg":/data:.*base64|\.|[^<\s]\/{1,1}/.test(t)?"image":/^[\w-_]+$/.test(t)?"dxIcon":!!/^\s?([\w-_]\s?)+$/.test(t)&&"fontIcon")};e.getImageSourceType=o;e.getImageContainer=function(t){switch(o(t)){case"image":return(0,a.default)("<img>").attr("src",t).addClass("dx-icon");case"fontIcon":return(0,a.default)("<i>").addClass("".concat("dx-icon"," ").concat(t));case"dxIcon":return(0,a.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-icon","-").concat(t));case"svg":return(0,a.default)("<i>").addClass("".concat("dx-icon"," ").concat("dx-svg-icon")).append(t);default:return null}}},78008:function(t,e,n){e.underscore=e.titleize=e.humanize=e.dasherize=e.captionize=e.camelize=void 0;var i=n(95479),a=function(t){return null==t?"":String(t)},o=function(t){return a(t).charAt(0).toUpperCase()+t.substr(1)},r=function(t){return a(t).replace(/([a-z\d])([A-Z])/g,"$1 $2").split(/[\s_-]+/)},s=function(t){return(0,i.map)(r(t),(function(t){return t.toLowerCase()})).join("-")};e.dasherize=s;e.underscore=function(t){return s(t).replace(/-/g,"_")};e.camelize=function(t,e){return(0,i.map)(r(t),(function(t,n){return t=t.toLowerCase(),(e||n>0)&&(t=o(t)),t})).join("")};e.humanize=function(t){return o(s(t).replace(/-/g," "))};e.titleize=function(t){return(0,i.map)(r(t),(function(t){return o(t.toLowerCase())})).join(" ")};var l=["0","1","2","3","4","5","6","7","8","9"];e.captionize=function(t){var e,n,i=[],a=!1,o=!1;for(e=0;e<t.length;e++)o=(n=t.charAt(e))===n.toUpperCase()&&"-"!==n&&")"!==n&&"/"!==n||n in l,"_"===n||"."===n?(n=" ",o=!0):0===e?(n=n.toUpperCase(),o=!0):!a&&o&&i.length>0&&i.push(" "),i.push(n),a=o;return i.join("")}},95479:function(t,e){e.reverseEach=e.map=e.each=void 0;e.map=function(t,e){if(Array.isArray(t))return t.map(e);var n=[];for(var i in t)n.push(e(t[i],i));return n};e.each=function(t,e){if(t){if("length"in t)for(var n=0;n<t.length&&!1!==e.call(t[n],n,t[n]);n++);else for(var i in t)if(!1===e.call(t[i],i,t[i]))break;return t}};e.reverseEach=function(t,e){if(t&&"length"in t&&0!==t.length)for(var n=t.length-1;n>=0&&!1!==e.call(t[n],n,t[n]);n--);}},88933:function(t,e,n){e.default=void 0;var i,a=(i=n(17381))&&i.__esModule?i:{default:i};var o=function(){var t={},e=function(e){return t[e]||0};return{obtain:function(n){t[n]=e(n)+1},release:function(n){var i=e(n);if(i<1)throw a.default.Error("E0014");1===i?delete t[n]:t[n]=i-1},locked:function(t){return e(t)>0}}};e.default=o,t.exports=e.default,t.exports.default=e.default},60810:function(t,e,n){e.adjust=function(t,e){var n,r=o(e||0)+2,s=t.toString().split("."),l=t,c=Math.abs(t),u=(0,i.isExponential)(t),d=c>1?10:0;if(1===s.length)return t;u||((0,i.isExponential)(e)&&(r=s[0].length+a(e)),t=(t=c)-Math.floor(t)+d);if(r=function(){return"0.000300"!==3e-4.toPrecision(3)}()&&a(t)>6||r>7?15:7,!u&&(n=parseFloat(t.toPrecision(r)).toString().split("."))[0]===d.toString())return parseFloat(s[0]+"."+n[1]);return parseFloat(l.toPrecision(r))},e.fitIntoRange=void 0,e.getExponent=a,e.getExponentLength=function(t){var e,n=t.toString();return(null===(e=n.split(".")[1])||void 0===e?void 0:e.length)||parseInt(n.split("e-")[1])||0},e.getPrecision=o,e.getRemainderByDivision=function(t,e,n){if(e===parseInt(e))return t%e;var i=s(t/e,n);return(i-parseInt(i))*e},e.getRoot=r,e.inRange=void 0,e.multiplyInExponentialForm=function(t,e){var n=function(t){var e=t.toExponential().split("e"),n=parseFloat(e[0]);return{exponent:parseInt(e[1]),mantissa:n}}(t);return parseFloat("".concat(n.mantissa,"e").concat(n.exponent+e))},e.roundFloatPart=s,e.sign=void 0,e.solveCubicEquation=function(t,e,n,i){if(Math.abs(t)<1e-8){if(t=e,e=n,n=i,Math.abs(t)<1e-8)return t=e,e=n,Math.abs(t)<1e-8?[]:[-e/t];var a=e*e-4*t*n;return Math.abs(a)<1e-8?[-e/(2*t)]:a>0?[(-e+Math.sqrt(a))/(2*t),(-e-Math.sqrt(a))/(2*t)]:[]}var o,s,l=(3*t*n-e*e)/(3*t*t),c=(2*e*e*e-9*t*e*n+27*t*t*i)/(27*t*t*t);if(Math.abs(l)<1e-8)o=[r(-c,3)];else if(Math.abs(c)<1e-8)o=[0].concat(l<0?[Math.sqrt(-l),-Math.sqrt(-l)]:[]);else{var u=c*c/4+l*l*l/27;if(Math.abs(u)<1e-8)o=[-1.5*c/l,3*c/l];else if(u>0)s=r(-c/2-Math.sqrt(u),3),o=[s-l/(3*s)];else{s=2*Math.sqrt(-l/3);var d=Math.acos(3*c/l/s)/3,h=2*Math.PI/3;o=[s*Math.cos(d),s*Math.cos(d-h),s*Math.cos(d-2*h)]}}for(var f=0;f<o.length;f++)o[f]-=e/(3*t);return o},e.trunc=function(t){return Math.trunc?Math.trunc(t):t>0?Math.floor(t):Math.ceil(t)};var i=n(35922);e.sign=function(t){return 0===t?0:t/Math.abs(t)};e.fitIntoRange=function(t,e,n){var i=!e&&0!==e,a=!n&&0!==n;return i&&(e=a?t:Math.min(t,n)),a&&(n=i?t:Math.max(t,e)),Math.min(Math.max(t,e),n)};function a(t){return Math.abs(parseInt(t.toExponential().split("e")[1]))}function o(t){var e=t.toString();if(e.indexOf(".")<0)return 0;var n=e.split("."),i=n[1].indexOf("e");return i>=0?i:n[1].length}function r(t,e){if(t<0&&e%2!=1)return NaN;var n=Math.pow(Math.abs(t),1/e);return e%2==1&&t<0?-n:n}function s(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return parseFloat(t.toFixed(e))}e.inRange=function(t,e,n){return t>=e&&t<=n}},48013:function(t,e,n){e.orderEach=e.deepExtendArraySafe=e.clone=void 0;var i,a=n(35922),o=(i=n(26974))&&i.__esModule?i:{default:i};var r=function(){function t(){}return function(e){return t.prototype=e,new t}}();e.clone=r;e.orderEach=function(t,e){var n,i,o=[];for(n in t)Object.prototype.hasOwnProperty.call(t,n)&&o.push(n);for(o.sort((function(t,e){var n=(0,a.isNumeric)(t),i=(0,a.isNumeric)(e);return n&&i?t-e:n&&!i?-1:!n&&i?1:t<e?-1:t>e?1:0})),i=0;i<o.length;i++)e(n=o[i],t[n])};var s=function(t,e,n,i){!i&&o.default.isWrapped(t[e])?o.default.assign(t[e],n):t[e]=n};e.deepExtendArraySafe=function t(e,n,i,o){var r,l;for(var c in n)if(r=e[c],l=n[c],"__proto__"!==c&&"constructor"!==c&&e!==l){if((0,a.isPlainObject)(l))l=t((i?(0,a.isObject)(r):(0,a.isPlainObject)(r))?r:{},l,i,o);void 0!==l&&r!==l&&s(e,c,l,o)}return e}},37518:function(t,e,n){e.getDefaultAlignment=e.getBoundingRect=void 0;var i,a=(i=n(80209))&&i.__esModule?i:{default:i},o=n(35922);e.getDefaultAlignment=function(t){return(null!=t?t:(0,a.default)().rtlEnabled)?"right":"left"};e.getBoundingRect=function(t){return(0,o.isWindow)(t)?{width:t.outerWidth,height:t.outerHeight}:t.getBoundingClientRect()}},9321:function(t,e,n){e.attachInstanceToElement=function(t,e,n){var i=(0,a.data)(t.get(0)),r=u(e.constructor);i[r]=e,n&&o.default.one(t,s.removeEvent,(function(){n.call(e)}));i.dxComponents||(i.dxComponents=[]);i.dxComponents.push(r)},e.getInstanceByElement=function(t,e){var n=u(e);return(0,a.data)(t.get(0),n)},e.name=void 0;var i,a=n(97906),o=(i=n(55994))&&i.__esModule?i:{default:i},r=n(35922),s=n(29007);var l=new WeakMap,c=0,u=function(t,e){if(!(0,r.isDefined)(e)){if(!l.has(t)){var n="dxPrivateComponent"+c++;return l.set(t,n),n}return l.get(t)}l.set(t,e)};e.name=u},59504:function(t,e,n){e.create=r,e.enqueue=void 0;var i,a=(i=n(17381))&&i.__esModule?i:{default:i},o=n(62754);function r(t){var e=[],n=!1;function i(){for(;e.length;){n=!0;var t=e.shift()();if(void 0!==t){if(t.then)return void(0,o.when)(t).always(i);throw a.default.Error("E0015")}}n=!1}return{add:function(a,o){t?(e[0]&&o&&o(e[0]),e=[a]):e.push(a),n||i()},busy:function(){return n}}}var s=r().add;e.enqueue=s},24311:function(t,e,n){e.default=void 0;var i=s(n(73349)),a=s(n(20476)),o=n(58201),r=s(n(39618));function s(t){return t&&t.__esModule?t:{default:t}}var l=[],c=(0,r.default)((function(){var t=i.default.listen(i.default.getDocument(),"DOMContentLoaded",(function(){u.fire(),t()}))})),u={add:function(t){var e=(0,o.hasWindow)();e&&"loading"!==i.default.getReadyState()?t():(l.push(t),e&&c())},fire:function(){l.forEach((function(t){return t()})),l=[]}},d=(0,a.default)(u);e.default=d,t.exports=e.default,t.exports.default=e.default},55814:function(t,e,n){e.default=void 0;var i=n(58201),a=l(n(73349)),o=l(n(44504)),r=l(n(24311)),s=l(n(39618));function l(t){return t&&t.__esModule?t:{default:t}}var c=function(){var t,e=(0,o.default)(),n=e.add,l=e.remove;if(!(0,i.hasWindow)())return e;var c,u=function(){var t=(0,i.getWindow)();return{width:t.innerWidth,height:t.innerHeight}},d=function(){var n,i=u();i.width===t.width&&i.height===t.height||(i.width===t.width&&(n="height"),i.height===t.height&&(n="width"),t=i,e.fire(n))},h=(0,s.default)((function(){t=u()}));return e.add=function(){var t=n.apply(e,arguments);return h(),r.default.add((function(){!c&&e.has()&&(c=a.default.listen((0,i.getWindow)(),"resize",d))})),t},e.remove=function(){var t=l.apply(e,arguments);return!e.has()&&c&&(c(),c=void 0),t},e}();e.default=c,t.exports=e.default,t.exports.default=e.default},49601:function(t,e,n){e.SelectionFilterCreator=void 0;var i=n(20576),a=n(35922);e.SelectionFilterCreator=function(t,e){var n;this.getLocalFilter=function(t,e,n,a){return e=void 0===e?i.equalByValue:e,r.bind(this,e,t,n,a)},this.getExpr=function(n){var i;if(n)return t.forEach((function(t,o){var r;i=i||[],o>0&&i.push(e?"and":"or"),r=(0,a.isString)(n)?s(n,t):function(t,n){for(var i=[],a=0,o=t.length;a<o;a++){var r=t[a],l=n&&n[r],c=s(r,l);if(!c)break;a>0&&i.push(e?"or":"and"),i.push(c)}return i}(n,t),i.push(r)})),i&&1===i.length&&(i=i[0]),i},this.getCombinedFilter=function(t,n){var i=arguments.length>2&&void 0!==arguments[2]&&arguments[2],a=this.getExpr(t),o=a;return(i||e)&&n&&(a?((o=[]).push(a),o.push(n)):o=n),o};var o=function(t,e,n){return Array.isArray(n)?t.map((function(t){return e(t)})):t};function r(r,s,l,c,u){var d,h,f=s(u);if(!l&&(d=(0,i.getKeyHash)(f),!(0,a.isObject)(d)))return function(e,a){if(!n){n={};for(var r=o(t,e,a),s=0;s<r.length;s++)n[(0,i.getKeyHash)(r[s])]=!0}return n}(s,c)[d]?!e:!!e;for(h=0;h<t.length;h++)if(r(t[h],f))return!e;return!!e}function s(t,n){if(void 0!==n)return[t,e?"<>":"=",n]}}},90330:function(t,e){e.addShadowDomStyles=function(t){var e,o=t.get(0),r=null===(e=o.getRootNode)||void 0===e?void 0:e.call(o);if(null==r||!r.host)return;n||a(n=i(r),o.ownerDocument.styleSheets,!1);var s=i(r);a(s,r.styleSheets,!0),r.adoptedStyleSheets=[n,s]},e.getShadowElementsFromPoint=function(t,e,n){var i=(a=0,o=[],Object.defineProperties({push:function(t){return o.push(t),this},shift:function(){return a++,o[a-1]}},{length:{get:function(){return o.length-a},configurable:!0,enumerable:!0},items:{get:function(){return o},configurable:!0,enumerable:!0}})).push(n);var a,o;for(;i.length;)for(var s=i.shift(),l=0;l<s.childNodes.length;l++){var c=s.childNodes[l];c.nodeType===Node.ELEMENT_NODE&&r(c,t,e)&&"none"!==getComputedStyle(c).pointerEvents&&i.push(c)}var u=i.items.reverse();return u.pop(),u};var n=null;function i(t){try{return new CSSStyleSheet}catch(n){var e=t.ownerDocument.createElement("style");return t.appendChild(e),e.sheet}}function a(t,e,n){for(var i=0;i<e.length;i++){var a=e[i];try{for(var r=0;r<a.cssRules.length;r++)o(t,a.cssRules[r],n)}catch(t){}}}function o(t,e,n){var i,a,o,r,s,l;(n||(null===(i=e.selectorText)||void 0===i?void 0:i.includes("dx-"))||(null===(a=e.cssRules)||void 0===a||null===(o=a[0])||void 0===o||null===(r=o.selectorText)||void 0===r?void 0:r.includes("dx-"))||(null===(s=e.name)||void 0===s?void 0:s.startsWith("dx-"))||"DXIcons"===(null===(l=e.style)||void 0===l?void 0:l.fontFamily))&&t.insertRule(e.cssText,t.cssRules.length)}function r(t,e,n){var i=t.getBoundingClientRect();return i&&e>=i.left&&e<i.right&&n>=i.top&&n<i.bottom}},58664:function(t,e,n){e.setWidth=e.setOuterWidth=e.setOuterHeight=e.setInnerWidth=e.setInnerHeight=e.setHeight=e.parseHeight=e.implementationsMap=e.getWindowByElement=e.getWidth=e.getVisibleHeight=e.getVerticalOffsets=e.getSize=e.getOuterWidth=e.getOuterHeight=e.getOffset=e.getInnerWidth=e.getInnerHeight=e.getHeight=e.getElementBoxParams=e.addOffsetToMinHeight=e.addOffsetToMaxHeight=void 0;var i,a=n(58201),o=(i=n(73349))&&i.__esModule?i:{default:i},r=n(35922);var s=(0,a.getWindow)(),l=["auto","none","inherit","initial"],c=function(t,e){var n=0;return e.forEach((function(e){n+=parseFloat(t[e])||0})),n},u=function(t,e){var n="width"===t?"Left":"Top",i="width"===t?"Right":"Bottom";return{padding:c(e,["padding"+n,"padding"+i]),border:c(e,["border"+n+"Width","border"+i+"Width"]),margin:c(e,["margin"+n,"margin"+i])}};e.getElementBoxParams=u;var d=function(t){var e,n=(null==t||null===(e=t.ownerDocument)||void 0===e?void 0:e.defaultView)||s;return n.getComputedStyle&&n.getComputedStyle(t)},h=function(t,e,n,i){var a;return(null==e?void 0:e[n])||(null===(a=t.style)||void 0===a?void 0:a[n])||i},f={content:0,padding:1,border:2,margin:3,"content-box":0,"border-box":2},p={width:["left","right"],height:["top","bottom"]};function g(t,e,n,i){var a=function(t,e,n){return parseFloat(h(t,e,n,"0"))||0},o="border"===n?"-width":"";return a(t,i,"".concat(n,"-").concat(p[e][0]).concat(o))+a(t,i,"".concat(n,"-").concat(p[e][1]).concat(o))}var m=function(t,e,n){var i="width"===e?"offsetWidth":"offsetHeight",a=d(t),o=h(t,a,e);""!==o&&"auto"!==o||(o=t[i]),o=parseFloat(o)||0;var r=h(t,a,"boxSizing","content-box"),s=f[n||r],l=f[r];if(void 0===s||void 0===l)throw new Error;if(l===s)return o;var c=Math.sign(s-l),u=!1,p=!1,m=!1,_=!1;1===c&&(s+=1,l+=1);for(var v=l;v!==s;v+=c)switch(v){case f.content:break;case f.padding:u=c*g(t,e,"padding",a);break;case f.border:p=c*g(t,e,"border",a);break;case f.margin:m=c*g(t,e,"margin",a)}if(u||p){var b=(!1===u?c*g(t,e,"padding",a):u)+(!1===p?c*g(t,e,"border",a):p);_=c*Math.max(0,Math.floor(t[i]-o-c*b))||0}return o+m+u+p+_};e.getSize=m;var _=function(t,e,n){return t.indexOf("px")>0?t=parseInt(t.replace("px","")):t.indexOf("%")>0?t=parseInt(t.replace("%",""))*function(t){return(0,r.isWindow)(t)?t.innerHeight:t.offsetHeight}(e)/100:isNaN(t)?t.indexOf("vh")>0?t=s.innerHeight/100*parseInt(t.replace("vh","")):n&&t.indexOf("em")>0&&(t=parseFloat(t.replace("em",""))*parseFloat(s.getComputedStyle(n).fontSize)):t=parseInt(t),t};e.parseHeight=_;var v=function(t,e,n){return t?l.indexOf(t)>-1?e?null:t:((0,r.isString)(t)&&(t=_(t,n)),(0,r.isNumeric)(t)?Math.max(0,t+e):"calc("+t+(e<0?" - ":" ")+Math.abs(e)+"px)"):null};e.addOffsetToMaxHeight=function(t,e,n){var i=v(t,e,n);return null!==i?i:"none"};e.addOffsetToMinHeight=function(t,e,n){var i=v(t,e,n);return null!==i?i:0};e.getVerticalOffsets=function(t,e){if(!t)return 0;var n=u("height",s.getComputedStyle(t));return n.padding+n.border+(e?n.margin:0)};e.getVisibleHeight=function(t){if(t){var e=t.getBoundingClientRect();if(e.height)return e.height}return 0};var b={getWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["width"].concat(e))},setWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["width"].concat(e))},getHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["height"].concat(e))},setHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["height"].concat(e))},getOuterWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["outerWidth"].concat(e))},setOuterWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["outerWidth"].concat(e))},getOuterHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["outerHeight"].concat(e))},setOuterHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["outerHeight"].concat(e))},getInnerWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["innerWidth"].concat(e))},setInnerWidth:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["innerWidth"].concat(e))},getInnerHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["innerHeight"].concat(e))},setInnerHeight:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return y.apply(void 0,["innerHeight"].concat(e))}};function y(t,e,n){return 2===arguments.length?x(e,t):x(e,t,n)}e.implementationsMap=b;e.getWidth=function(t){return b.getWidth(t)};e.setWidth=function(t,e){return b.setWidth(t,e)};e.getHeight=function(t){return b.getHeight(t)};e.setHeight=function(t,e){return b.setHeight(t,e)};e.getOuterWidth=function(t,e){return b.getOuterWidth(t,e||!1)};e.setOuterWidth=function(t,e){return b.setOuterWidth(t,e)};e.getOuterHeight=function(t,e){return b.getOuterHeight(t,e||!1)};e.setOuterHeight=function(t,e){return b.setOuterHeight(t,e)};e.getInnerWidth=function(t){return b.getInnerWidth(t)};e.setInnerWidth=function(t,e){return b.setInnerWidth(t,e)};e.getInnerHeight=function(t){return b.getInnerHeight(t)};e.setInnerHeight=function(t,e){return b.setInnerHeight(t,e)};var x=function t(e,n,i){var a=n.toLowerCase().indexOf("width")>=0?"Width":"Height",s=a.toLowerCase(),l=0===n.indexOf("outer"),c=0===n.indexOf("inner"),h=2===arguments.length||"boolean"==typeof i;if((0,r.isRenderer)(e)){if(e.length>1&&!h){for(var f=0;f<e.length;f++)t(e[f],n,i);return}e=e[0]}if(e){if((0,r.isWindow)(e))return l?e["inner"+a]:o.default.getDocumentElement()["client"+a];if(o.default.isDocument(e)){var p=o.default.getDocumentElement(),g=o.default.getBody();return Math.max(g["scroll"+a],g["offset"+a],p["scroll"+a],p["offset"+a],p["client"+a])}if(h){var _="content";return l&&(_=i?"margin":"border"),c&&(_="padding"),m(e,s,_)}if((0,r.isNumeric)(i)){var v=d(e),b=u(s,v),y="border-box"===v.boxSizing;i=Number(i),l?i-=y?0:b.border+b.padding:c?i+=y?b.border:-b.padding:y&&(i+=b.border+b.padding)}return i+=(0,r.isNumeric)(i)?"px":"",o.default.setStyle(e,s,i),null}},w=function(t){return(0,r.isWindow)(t)?t:t.defaultView};e.getWindowByElement=w;e.getOffset=function(t){if(!t.getClientRects().length)return{top:0,left:0};var e=t.getBoundingClientRect(),n=w(t.ownerDocument),i=t.ownerDocument.documentElement;return{top:e.top+n.pageYOffset-i.clientTop,left:e.left+n.pageXOffset-i.clientLeft}}},36613:function(t,e,n){e.sessionStorage=void 0;var i=(0,n(58201).getWindow)();e.sessionStorage=function(){var t;try{t=i.sessionStorage}catch(t){}return t}},68752:function(t,e,n){e.encodeHtml=void 0,e.format=function(t){for(var e=arguments.length,n=new Array(e>1?e-1:0),a=1;a<e;a++)n[a-1]=arguments[a];if((0,i.isFunction)(t))return t.apply(void 0,n);return n.forEach((function(e,n){(0,i.isString)(e)&&(e=e.replace(/\$/g,"$$$$"));var a=new RegExp("\\{"+n+"\\}","gm");t=t.replace(a,e)})),t},e.replaceAll=e.quadToObject=e.isEmpty=void 0;var i=n(35922);function a(t){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var o,r=(o=[new RegExp("&","g"),new RegExp('"',"g"),new RegExp("'","g"),new RegExp("<","g"),new RegExp(">","g")],function(t){return String(t).replace(o[0],"&amp;").replace(o[1],"&quot;").replace(o[2],"&#39;").replace(o[3],"&lt;").replace(o[4],"&gt;")});e.encodeHtml=r;e.quadToObject=function(t){var e=function(t){switch(a(t)){case"string":return t.split(/\s+/,4);case"object":return[t.x||t.h||t.left,t.y||t.v||t.top,t.x||t.h||t.right,t.y||t.v||t.bottom];case"number":return[t];default:return t}}(t),n=parseInt(e&&e[0],10),i=parseInt(e&&e[1],10),o=parseInt(e&&e[2],10),r=parseInt(e&&e[3],10);return isFinite(n)||(n=0),isFinite(i)||(i=n),isFinite(o)||(o=n),isFinite(r)||(r=i),{top:i,right:o,bottom:r,left:n}};var s=function(t,e,n){return t.replace(new RegExp("("+(e+"").replace(/([+*?.[^\]$(){}><|=!:])/g,"\\$1")+")","gi"),n)};e.replaceAll=s;var l,c=(l=/\s/g,function(t){return!t||!t.replace(l,"")});e.isEmpty=c},80968:function(t,e,n){e.stylePropPrefix=e.styleProp=e.setWidth=e.setStyle=e.setHeight=e.parsePixelValue=e.normalizeStyleProp=void 0;var i=n(78008),a=s(n(39618)),o=n(35922),r=s(n(73349));function s(t){return t&&t.__esModule?t:{default:t}}function l(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var n=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=n){var i,a,o,r,s=[],l=!0,c=!1;try{if(o=(n=n.call(t)).next,0===e){if(Object(n)!==n)return;l=!1}else for(;!(l=(i=o.call(n)).done)&&(s.push(i.value),s.length!==e);l=!0);}catch(t){c=!0,a=t}finally{try{if(!l&&null!=n.return&&(r=n.return(),Object(r)!==r))return}finally{if(c)throw a}}return s}}(t,e)||function(t,e){if(!t)return;if("string"==typeof t)return c(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return c(t,e)}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function c(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var u=["","Webkit","Moz","O","Ms"],d={"":"",Webkit:"-webkit-",Moz:"-moz-",O:"-o-",ms:"-ms-"},h=(0,a.default)((function(){return r.default.createElement("dx").style}));e.styleProp=function(t){if(t in h())return t;var e=t;t=t.charAt(0).toUpperCase()+t.substr(1);for(var n=1;n<u.length;n++){var i=u[n].toLowerCase()+t;if(i in h())return i}return e};e.stylePropPrefix=function(t){return function(t,e){var n;t=(0,i.camelize)(t,!0);for(var a=0,o=u.length;a<o;a++){var r=u[a],s=r+t;if(void 0===(n=e((0,i.camelize)(s),r))&&(n=e(s,r)),void 0!==n)break}return n||""}(t,(function(t,e){if(t in h())return d[e]}))};var f=["fillOpacity","columnCount","flexGrow","flexShrink","fontWeight","lineHeight","opacity","zIndex","zoom"];e.parsePixelValue=function(t){return(0,o.isNumeric)(t)?t:(0,o.isString)(t)?Number(t.replace("px","")):NaN};e.normalizeStyleProp=function(t,e){return(0,o.isNumeric)(e)&&-1===f.indexOf(t)&&(e+="px"),e};var p=function(t,e,n){if(t){n=(0,o.isNumeric)(n)?n+="px":n;for(var i=0;i<t.length;++i)t[i].style[e]=n}};e.setWidth=function(t,e){p(t,"width",e)};e.setHeight=function(t,e){p(t,"height",e)};e.setStyle=function(t,e){var n=!(arguments.length>2&&void 0!==arguments[2])||arguments[2];if(n){var i=[].slice.call(t.style);i.forEach((function(e){t.style.removeProperty(e)}))}e.split(";").forEach((function(e){var n=e.split(":").map((function(t){return t.trim()}));if(2===n.length){var i=l(n,2),a=i[0],o=i[1];t.style[a]=o}}))}},60137:function(t,e,n){e.pointerEvents=e.nativeScrolling=e.inputType=e.animation=void 0,Object.defineProperty(e,"styleProp",{enumerable:!0,get:function(){return s.styleProp}}),Object.defineProperty(e,"stylePropPrefix",{enumerable:!0,get:function(){return s.stylePropPrefix}}),e.transitionEndEventName=e.transition=e.touchEvents=e.touch=e.supportProp=void 0;var i=l(n(73349)),a=l(n(39618)),o=n(58201),r=l(n(20530)),s=n(80968);function l(t){return t&&t.__esModule?t:{default:t}}var c=(0,o.getNavigator)().maxTouchPoints,u={webkitTransition:"webkitTransitionEnd",MozTransition:"transitionend",OTransition:"oTransitionEnd",transition:"transitionend"},d=function(t){return!!(0,s.styleProp)(t)};e.supportProp=d;e.inputType=function(t){if("text"===t)return!0;var e=i.default.createElement("input");try{return e.setAttribute("type",t),e.value="wrongValue",!e.value}catch(t){return!1}};var h=function(t,e){return(t("ontouchstart")||!!e)&&!t("callPhantom")}(o.hasProperty,c);e.touchEvents=h;var f=(0,o.hasProperty)("PointerEvent");e.pointerEvents=f;var p=h||f&&!!c;e.touch=p;var g=(0,a.default)((function(){return d("transition")}));e.transition=g;var m=(0,a.default)((function(){return u[(0,s.styleProp)("transition")]}));e.transitionEndEventName=m;var _=(0,a.default)((function(){return d("animation")}));e.animation=_;var v,b,y,x=(v=r.default.real(),b=v.platform,y=v.mac,"ios"===b||"android"===b||y);e.nativeScrolling=x},19155:function(t,e,n){e.HIDDEN_FOR_EXPORT=void 0,e.getSvgElement=function(t){return i.default.isNode(t)?t:(new s.DOMParser).parseFromString(t,"image/svg+xml").childNodes[0]},e.getSvgMarkup=function(t,e){return function(t){var e=!0;-1===t.indexOf("xmlns:xlink")&&(t=t.replace("<svg",'<svg xmlns:xlink="http://www.w3.org/1999/xlink"'));return(t=t.replace(/xmlns="[\s\S]*?"/gi,(function(t){return e?(e=!1,t):""}))).replace(/xmlns:NS1="[\s\S]*?"/gi,"").replace(/NS1:xmlns:xlink="([\s\S]*?)"/gi,'xmlns:xlink="$1"')}((n=function(t,e){var n=i.default.createElement("div"),a=t.cloneNode(!0);return e&&(0,o.default)(a).css("backgroundColor",e),n.appendChild(a),n.innerHTML}(t,e),n.replace(/&quot;/gi,"&#34;").replace(/&amp;/gi,"&#38;").replace(/&apos;/gi,"&#39;").replace(/&lt;/gi,"&#60;").replace(/&gt;/gi,"&#62;").replace(/&nbsp;/gi,"&#160;").replace(/&shy;/gi,"&#173;")));var n};var i=r(n(73349)),a=n(58201),o=r(n(68374));function r(t){return t&&t.__esModule?t:{default:t}}var s=(0,a.getWindow)();e.HIDDEN_FOR_EXPORT="hidden-for-export"},69697:function(t,e,n){e.validateTemplateSource=e.templateKey=e.suitableTemplatesByName=e.getNormalizedTemplateArgs=e.findTemplates=e.defaultCreateElement=e.addPublicElementNormalization=e.addOneRenderedCall=e.acquireTemplate=e.acquireIntegrationTemplate=void 0;var i=_(n(80209)),a=_(n(20530)),o=n(6415),r=_(n(17381)),s=_(n(68374)),l=n(91627),c=n(10688),u=n(9545),d=n(81033),h=n(89386),f=n(20576),p=n(3532),g=n(13306),m=n(35922);function _(t){return t&&t.__esModule?t:{default:t}}function v(){return(v=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}e.findTemplates=function(t,e){var n=(0,s.default)(t).contents().filter("[".concat("data-options",'*="').concat(e,'"]'));return[].slice.call(n).map((function(t){var n=(0,s.default)(t).attr("data-options")||"";return{element:t,options:(0,i.default)().optionsParser(n)[e]}})).filter((function(t){return!!t.options}))};e.suitableTemplatesByName=function(t){var e=(0,h.groupBy)(t,(function(t){return t.options.name}));if(e[void 0])throw r.default.Error("E0023");var n={};return Object.keys(e).forEach((function(t){var i,o=null===(i=(0,f.findBestMatches)(a.default.current(),e[t],(function(t){return t.options}))[0])||void 0===i?void 0:i.element;o&&(n[t]=o)})),n};var b=function(t){var e=t.render.bind(t);return(0,g.extend)({},t,{render:function(t){var n=e(t);return t&&t.onRendered&&t.onRendered(),n}})};e.addOneRenderedCall=b;var y=function(t){var e=t.render.bind(t);return(0,g.extend)({},t,{render:function(t){var n=(0,s.default)(t.container);return e(v({},t,{container:(0,o.getPublicElement)(n)}))}})};e.addPublicElementNormalization=y;e.getNormalizedTemplateArgs=function(t){var e=[];return"model"in t&&e.push(t.model),"index"in t&&e.push(t.index),e.push(t.container),e};e.validateTemplateSource=function(t){return"string"==typeof t?(0,p.normalizeTemplateElement)(t):t};e.templateKey=function(t){return(0,m.isRenderer)(t)&&t[0]||t};e.defaultCreateElement=function(t){return new u.Template(t)};var x=function(t,e,n,i){var a=null;return i&&-1!==i.indexOf(t)||!(a=e[t])||a instanceof d.TemplateBase||((0,m.isFunction)(a.render)&&(a=y(a)),n||(a=b(a))),a};e.acquireIntegrationTemplate=x;e.acquireTemplate=function(t,e,n,i,a,o){return null==t?new c.EmptyTemplate:t instanceof l.ChildDefaultTemplate?o[t.name]:t instanceof d.TemplateBase?t:(0,m.isFunction)(t.render)&&!(0,m.isRenderer)(t)?i?t:b(t):t.nodeType||(0,m.isRenderer)(t)?e((0,s.default)(t)):x(t,n,i,a)||o[t]||e(t)}},35922:function(t,e){function n(t){return(n="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}e.type=e.isWindow=e.isString=e.isRenderer=e.isPromise=e.isPrimitive=e.isPlainObject=e.isObject=e.isNumeric=e.isFunction=e.isExponential=e.isEvent=e.isEmptyObject=e.isDefined=e.isDeferred=e.isDate=e.isBoolean=void 0;var i={"[object Array]":"array","[object Date]":"date","[object Object]":"object","[object String]":"string"},a=function(t){if(null===t)return"null";var e=Object.prototype.toString.call(t);return"object"===n(t)?i[e]||"object":n(t)};e.type=a;e.isBoolean=function(t){return"boolean"==typeof t};e.isExponential=function(t){return r(t)&&-1!==t.toString().indexOf("e")};e.isDate=function(t){return"date"===a(t)};e.isDefined=function(t){return null!=t};var o=function(t){return"function"==typeof t};e.isFunction=o;e.isString=function(t){return"string"==typeof t};var r=function(t){return"number"==typeof t&&isFinite(t)||!isNaN(t-parseFloat(t))};e.isNumeric=r;e.isObject=function(t){return"object"===a(t)};e.isEmptyObject=function(t){var e;for(e in t)return!1;return!0};e.isPlainObject=function(t){if(!t||"object"!==a(t))return!1;var e=Object.getPrototypeOf(t);if(!e)return!0;var n=Object.hasOwnProperty.call(e,"constructor")&&e.constructor;return"function"==typeof n&&Object.toString.call(n)===Object.toString.call(Object)};e.isPrimitive=function(t){return-1===["object","array","function"].indexOf(a(t))};e.isWindow=function(t){return null!=t&&t===t.window};e.isRenderer=function(t){return!(!t||!t.jquery&&!t.dxRenderer)};e.isPromise=function(t){return!!t&&o(t.then)};e.isDeferred=function(t){return!!t&&o(t.done)&&o(t.fail)};e.isEvent=function(t){return!(!t||!t.preventDefault)}},26974:function(t,e,n){e.default=void 0;var i,a=n(30869);var o=(0,((i=n(20476))&&i.__esModule?i:{default:i}).default)({isWrapped:function(){return!1},isWritableWrapped:function(){return!1},wrap:function(t){return t},unwrap:function(t){return t},assign:function(){a.logger.error("Method 'assign' should not be used for not wrapped variables. Use 'isWrapped' method for ensuring.")}});e.default=o,t.exports=e.default,t.exports.default=e.default},58020:function(t,e){e.compare=function(t,e,n){function i(t){return"string"==typeof t?t.split("."):"number"==typeof t?[t]:t}t=i(t),e=i(e);var a=Math.max(t.length,e.length);isFinite(n)&&(a=Math.min(a,n));for(var o=0;o<a;o++){var r=parseInt(t[o]||0,10),s=parseInt(e[o]||0,10);if(r<s)return-1;if(r>s)return 1}return 0}},77695:function(t,e,n){e.changeCallback=void 0,e.originalViewPort=function(){return u},e.value=void 0;var i=r(n(68374)),a=r(n(24311)),o=r(n(44504));function r(t){return t&&t.__esModule?t:{default:t}}var s=a.default.add,l=(0,o.default)();e.changeCallback=l;var c,u=(0,i.default)(),d=function(t){if(!arguments.length)return c;var e=(0,i.default)(t);u=e;var n=!!e.length,a=d();c=n?e:(0,i.default)("body"),l.fire(n?d():(0,i.default)(),a)};e.value=d,s((function(){d(".dx-viewport")}))},58201:function(t,e,n){e.setWindow=e.hasWindow=e.hasProperty=e.getWindow=e.getNavigator=e.getCurrentScreenFactor=e.defaultScreenFactorFunc=void 0;var i,a=(i=n(73349))&&i.__esModule?i:{default:i};var o="undefined"!=typeof window,r=function(){return o};e.hasWindow=r;var s=r()?window:void 0;s||((s={}).window=s);e.getWindow=function(){return s};e.setWindow=function(t,e){o=void 0===e?"undefined"!=typeof window&&window===t:e,s=t};e.hasProperty=function(t){return r()&&t in s};var l=function(t){return t<768?"xs":t<992?"sm":t<1200?"md":"lg"};e.defaultScreenFactorFunc=l;e.getCurrentScreenFactor=function(t){return(t||l)(a.default.getDocumentElement().clientWidth)};e.getNavigator=function(){return r()?s.navigator:{userAgent:""}}},36739:function(t,e){e.version=void 0;e.version="23.1.6"},67403:function(t,e,n){e.default=void 0;var i=f(n(38377)),a=n(80566),o=n(95479),r=n(18438),s=n(16454),l=n(47617),c=f(n(99236)),u=n(62754),d=n(20576),h=n(35922);function f(t){return t&&t.__esModule?t:{default:t}}function p(t){return function(t){if(Array.isArray(t))return g(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return g(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return g(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function g(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function m(){return(m=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var _,v=i.default.abstract,b=c.default.queryByOptions,y={},x=i.default.inherit({_langParams:{},ctor:function(t){var e=this;t=t||{},this._eventsStrategy=new a.EventsStrategy(this),(0,o.each)(["onLoaded","onLoading","onInserted","onInserting","onUpdated","onUpdating","onPush","onRemoved","onRemoving","onModified","onModifying"],(function(n,i){i in t&&e.on(i.slice(2).toLowerCase(),t[i])})),this._key=t.key,this._errorHandler=t.errorHandler,this._useDefaultSearch=!0},_clearCache:d.noop,_customLoadOptions:function(){return null},key:function(){return this._key},keyOf:function(t){return this._keyGetter||(this._keyGetter=(0,l.compileGetter)(this.key())),this._keyGetter(t)},_requireKey:function(){if(!this.key())throw r.errors.Error("E4005")},load:function(t){var e=this;return t=t||{},this._eventsStrategy.fireEvent("loading",[t]),this._withLock(this._loadImpl(t)).done((function(n){e._eventsStrategy.fireEvent("loaded",[n,t])}))},_loadImpl:function(t){return(0,h.isEmptyObject)(this._langParams)||((t=t||{})._langParams=m({},this._langParams,t._langParams)),b(this.createQuery(t),t).enumerate()},_withLock:function(t){var e=new u.Deferred;return t.done((function(){var t=this,n=arguments;s.processRequestResultLock.promise().done((function(){e.resolveWith(t,n)}))})).fail((function(){e.rejectWith(this,arguments)})),e},createQuery:v,totalCount:function(t){return this._totalCountImpl(t)},_totalCountImpl:function(t){return b(this.createQuery(t),t,!0).count()},byKey:function(t,e){return this._addFailHandlers(this._withLock(this._byKeyImpl(t,e)))},_byKeyImpl:v,insert:function(t){var e=this;return e._eventsStrategy.fireEvent("modifying"),e._eventsStrategy.fireEvent("inserting",[t]),e._addFailHandlers(e._insertImpl(t).done((function(t,n){e._eventsStrategy.fireEvent("inserted",[t,n]),e._eventsStrategy.fireEvent("modified")})))},_insertImpl:v,update:function(t,e){var n=this;return n._eventsStrategy.fireEvent("modifying"),n._eventsStrategy.fireEvent("updating",[t,e]),n._addFailHandlers(n._updateImpl(t,e).done((function(){n._eventsStrategy.fireEvent("updated",[t,e]),n._eventsStrategy.fireEvent("modified")})))},_updateImpl:v,push:function(t){var e=this,n={changes:t,waitFor:[]};this._eventsStrategy.fireEvent("beforePushAggregation",[n]),u.when.apply(void 0,p(n.waitFor)).done((function(){e._pushImpl(t),e._eventsStrategy.fireEvent("beforePush",[{changes:t}]),e._eventsStrategy.fireEvent("push",[t])}))},_pushImpl:d.noop,remove:function(t){var e=this;return e._eventsStrategy.fireEvent("modifying"),e._eventsStrategy.fireEvent("removing",[t]),e._addFailHandlers(e._removeImpl(t).done((function(t){e._eventsStrategy.fireEvent("removed",[t]),e._eventsStrategy.fireEvent("modified")})))},_removeImpl:v,_addFailHandlers:function(t){return t.fail(this._errorHandler).fail(r.handleError)},on:function(t,e){return this._eventsStrategy.on(t,e),this},off:function(t,e){return this._eventsStrategy.off(t,e),this}});x.create=function(t,e){if(!(t in y))throw r.errors.Error("E4020",t);return new y[t](e)},x.registerClass=function(t,e){return e&&(y[e]=t),t},x.inherit=(_=x.inherit,function(t,e){var n=_.apply(this,[t]);return x.registerClass(n,e),n});var w=x;e.default=w,t.exports=e.default,t.exports.default=e.default},36893:function(t,e,n){e.default=void 0;var i=n(60637).applyChanges;e.default=i,t.exports=e.default,t.exports.default=e.default},35042:function(t,e,n){e.default=void 0;var i,a=(i=n(38377))&&i.__esModule?i:{default:i},o=n(35922),r=n(95479),s=n(47617),l=n(62754),c=n(18438),u=n(16454);var d=a.default.inherit({toArray:function(){var t=[];for(this.reset();this.next();)t.push(this.current());return t},countable:function(){return!1}}),h=d.inherit({ctor:function(t){this.array=t,this.index=-1},next:function(){return this.index+1<this.array.length&&(this.index++,!0)},current:function(){return this.array[this.index]},reset:function(){this.index=-1},toArray:function(){return this.array.slice(0)},countable:function(){return!0},count:function(){return this.array.length}}),f=d.inherit({ctor:function(t){this.iter=t},next:function(){return this.iter.next()},current:function(){return this.iter.current()},reset:function(){return this.iter.reset()}}),p=f.inherit({ctor:function(t,e){this.callBase(t),this.index=-1,this.mapper=e},current:function(){return this.mapper(this.callBase(),this.index)},next:function(){var t=this.callBase();return t&&this.index++,t}}),g=d.inherit({ctor:function(t,e,n,i){this.langParams=t.langParams,t instanceof p||((t=new p(t,this._wrap)).langParams=this.langParams),this.iter=t,this.rules=[{getter:e,desc:n,compare:i,langParams:this.langParams}]},thenBy:function(t,e,n){var i=new g(this.sortedIter||this.iter,t,e,n);return this.sortedIter||(i.rules=this.rules.concat(i.rules)),i},next:function(){return this._ensureSorted(),this.sortedIter.next()},current:function(){return this._ensureSorted(),this.sortedIter.current()},reset:function(){delete this.sortedIter},countable:function(){return this.sortedIter||this.iter.countable()},count:function(){return this.sortedIter?this.sortedIter.count():this.iter.count()},_ensureSorted:function(){var t=this;t.sortedIter||((0,r.each)(t.rules,(function(){this.getter=(0,s.compileGetter)(this.getter)})),t.sortedIter=new p(new h(this.iter.toArray().sort((function(e,n){return t._compare(e,n)}))),t._unwrap))},_wrap:function(t,e){return{index:e,value:t}},_unwrap:function(t){return t.value},_getDefaultCompare:function(t){return function(e,n){return function(t,e,n){return(0,o.isString)(t)&&(0,o.isString)(e)&&(null!=n&&n.locale||null!=n&&n.collatorOptions)?new Intl.Collator((null==n?void 0:n.locale)||void 0,(null==n?void 0:n.collatorOptions)||void 0).compare(t,e):(t=(0,s.toComparable)(t,!1,n),e=(0,s.toComparable)(e,!1,n),null===t&&null!==e?-1:null!==t&&null===e||void 0===t&&void 0!==e?1:void 0!==t&&void 0===e||t<e?-1:t>e?1:0)}(e,n,t)}},_compare:function(t,e){var n=t.index,i=e.index;if((t=t.value)===(e=e.value))return n-i;for(var a=0,o=this.rules.length;a<o;a++){var r=this.rules[a],s=r.getter(t),l=r.getter(e),c=(r.compare||this._getDefaultCompare(r.langParams))(s,l);if(c)return r.desc?-c:c}return n-i}}),m=function(){var t={},e=function(e){return(0,s.toComparable)(e,!1,t)},n=function(e){var n;return(0,o.isDefined)(e)?null!==(n=t)&&void 0!==n&&n.locale?e.toLocaleString(t.locale):e.toString():""};function i(t,n,i){return function(a){a=e(t(a));var o=function(t){return""===t||0===t||!1===t}(n)?a===n:a==n;return i&&(o=!o),o}}return function(a,l){return t=l||{},(0,o.isFunction)(a)?a:(0,u.isGroupCriterion)(a)?function(e){var n=[],i=!1,a=!1;return(0,r.each)(e,(function(){if(Array.isArray(this)||(0,o.isFunction)(this)){if(n.length>1&&i!==a)throw new c.errors.Error("E4019");n.push(m(this,t)),i=a,a=!0}else a=(0,u.isConjunctiveOperator)(this)})),function(t){for(var e=i,a=0;a<n.length;a++)if(n[a](t)!==i){e=!i;break}return e}}(a):(0,u.isUnaryOperation)(a)?function(e){var n=e[0],i=m(e[1],t);if("!"===n)return function(t){return!i(t)};throw c.errors.Error("E4003",n)}(a):function(t){t=(0,u.normalizeBinaryCriterion)(t);var a=(0,s.compileGetter)(t[0]),o=t[1],r=t[2];r=e(r);var l=function(t,n){return t=e(a(t)),(null!=r&&null!=t||r===t)&&n(t,r)};switch(o.toLowerCase()){case"=":return i(a,r);case"<>":return i(a,r,!0);case">":return function(t){return l(t,(function(t,e){return t>e}))};case"<":return function(t){return l(t,(function(t,e){return t<e}))};case">=":return function(t){return l(t,(function(t,e){return t>=e}))};case"<=":return function(t){return l(t,(function(t,e){return t<=e}))};case"startswith":return function(t){return 0===e(n(a(t))).indexOf(r)};case"endswith":return function(t){var i=e(n(a(t))),o=n(r);if(i.length<o.length)return!1;var s=i.lastIndexOf(r);return-1!==s&&s===i.length-r.length};case"contains":return function(t){return e(n(a(t))).indexOf(r)>-1};case"notcontains":return function(t){return-1===e(n(a(t))).indexOf(r)}}throw c.errors.Error("E4003",o)}(a)}}(),_=f.inherit({ctor:function(t,e){this.callBase(t),this.langParams=t.langParams,this.criteria=m(e,this.langParams)},next:function(){for(;this.iter.next();)if(this.criteria(this.current()))return!0;return!1}}),v=d.inherit({ctor:function(t,e){this.iter=t,this.getter=e},next:function(){return this._ensureGrouped(),this.groupedIter.next()},current:function(){return this._ensureGrouped(),this.groupedIter.current()},reset:function(){delete this.groupedIter},countable:function(){return!!this.groupedIter},count:function(){return this.groupedIter.count()},_ensureGrouped:function(){if(!this.groupedIter){var t={},e=[],n=this.iter,i=(0,s.compileGetter)(this.getter);for(n.reset();n.next();){var a=n.current(),o=i(a);o in t?t[o].push(a):(t[o]=[a],e.push(o))}this.groupedIter=new h((0,r.map)(e,(function(e){return{key:e,items:t[e]}})))}}}),b=f.inherit({ctor:function(t,e){this.callBase(t),this.getter=(0,s.compileGetter)(e)},current:function(){return this.getter(this.callBase())},countable:function(){return this.iter.countable()},count:function(){return this.iter.count()}}),y=f.inherit({ctor:function(t,e,n){this.callBase(t),this.skip=Math.max(0,e),this.take=Math.max(0,n),this.pos=0},next:function(){if(this.pos>=this.skip+this.take)return!1;for(;this.pos<this.skip&&this.iter.next();)this.pos++;return this.pos++,this.iter.next()},reset:function(){this.callBase(),this.pos=0},countable:function(){return this.iter.countable()},count:function(){return Math.min(this.iter.count()-this.skip,this.take)}}),x=function t(e,n){n=n||{},e instanceof d||(e=new h(e)),n.langParams&&(e.langParams=n.langParams);var i=function(t){var e=n.errorHandler;e&&e(t),(0,c.handleError)(t)},a=function(t){var n=(new l.Deferred).fail(i),a=t.step,o=t.finalize;try{e.reset();for(var r=("seed"in t?t.seed:e.next()?e.current():NaN);e.next();)r=a(r,e.current());n.resolve(o?o(r):r)}catch(t){n.reject(t)}return n.promise()},r=function(t){return a(u.aggregators[t])},f=function(t){return(0,o.isFunction)(t)||Array.isArray(t)||(t=[].slice.call(arguments)),m(new b(e,t))},p=function(t){return f((0,s.compileGetter)(t))};function m(e){return t(e,n)}return{toArray:function(){return e.toArray()},enumerate:function(){var t=(new l.Deferred).fail(i);try{t.resolve(e.toArray())}catch(e){t.reject(e)}return t.promise()},setLangParams:function(t){e.langParams=t},sortBy:function(t,n,i){return m(new g(e,t,n,i))},thenBy:function(t,n,i){if(e instanceof g)return m(e.thenBy(t,n,i));throw c.errors.Error("E4004")},filter:function(t){return Array.isArray(t)||(t=[].slice.call(arguments)),m(new _(e,t))},slice:function(t,n){return void 0===n&&(n=Number.MAX_VALUE),m(new y(e,t,n))},select:f,groupBy:function(t){return m(new v(e,t))},aggregate:function(t,e,n){return a(arguments.length<2?{step:arguments[0]}:{seed:t,step:e,finalize:n})},count:function(){if(e.countable()){var t=(new l.Deferred).fail(i);try{t.resolve(e.count())}catch(e){t.reject(e)}return t.promise()}return r("count")},sum:function(t){return t?p(t).sum():r("sum")},min:function(t){return t?p(t).min():r("min")},max:function(t){return t?p(t).max():r("max")},avg:function(t){return t?p(t).avg():r("avg")}}};e.default=x,t.exports=e.default,t.exports.default=e.default},26562:function(t,e,n){e.default=void 0;var i=n(16454),a=l(n(96687)),o=n(18438),r=l(n(67403)),s=n(60637);function l(t){return t&&t.__esModule?t:{default:t}}var c=r.default.inherit({ctor:function(t){t=Array.isArray(t)?{data:t}:t||{},this.callBase(t);var e=t.data;if(e&&!Array.isArray(e))throw o.errors.Error("E4006");this._array=e||[]},createQuery:function(){return(0,a.default)(this._array,{errorHandler:this._errorHandler})},_byKeyImpl:function(t){var e=(0,s.indexByKey)(this,this._array,t);return-1===e?(0,i.rejectedPromise)(o.errors.Error("E4009")):(0,i.trivialPromise)(this._array[e])},_insertImpl:function(t){return(0,s.insert)(this,this._array,t)},_pushImpl:function(t){(0,s.applyBatch)({keyInfo:this,data:this._array,changes:t})},_updateImpl:function(t,e){return(0,s.update)(this,this._array,t,e)},_removeImpl:function(t){return(0,s.remove)(this,this._array,t)},clear:function(){this._eventsStrategy.fireEvent("modifying"),this._array=[],this._eventsStrategy.fireEvent("modified")}},"array");e.default=c,t.exports=e.default,t.exports.default=e.default},60637:function(t,e,n){e.applyBatch=b,e.applyChanges=function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},i=n.keyExpr,a=void 0===i?"id":i,o=n.immutable,r=void 0===o||o,s=(0,c.compileGetter)(a),l={key:function(){return a},keyOf:function(t){return s(t)}};return b({keyInfo:l,data:t,changes:e,immutable:r,disableCache:!0,logError:!0})},e.createObjectWithChanges=v,e.indexByKey=S,e.insert=w,e.remove=k,e.update=x;var i=n(35922),a=d(n(80209)),o=d(n(73176)),r=n(13306),s=n(18438),l=n(48013),c=n(47617),u=n(16454);function d(t){return t&&t.__esModule?t:{default:t}}function h(t){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function f(t){return function(t){if(Array.isArray(t))return p(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return p(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return p(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function p(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function g(){return(g=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function m(t,e,n,i){return i?function t(e,n,i,a){var o;if(a){for(var r=0;r<n.length;r++)if(o=t(e,n[r].items||n[r].collapsedItems||[]||[],i,a-1))return o}else if(S(e,n,i)>=0)return n}(t,e,n,i)||[]:e}function _(t,e,n){t._dataByKeyMap&&(t._dataByKeyMap[JSON.stringify(e)]=n,t._dataByKeyMapLength+=n?1:-1)}function v(t,e){var n=function t(e,n,a){a=a||new WeakMap;var o=e?Object.create(Object.getPrototypeOf(e)):{};e&&a.set(e,o);var r=g({},e);for(var s in(0,l.deepExtendArraySafe)(o,r,!0,!0),r){var c=r[s],u=null==n?void 0:n[s];(0,i.isObject)(c)&&!(0,i.isPlainObject)(c)&&(0,i.isObject)(u)&&!a.has(c)&&(o[s]=t(c,u,a))}for(var d in o){var h=o[d];(0,i.isObject)(h)&&a.has(h)&&(o[d]=a.get(h))}return o}(t,e);return(0,l.deepExtendArraySafe)(n,e,!0,!0)}function b(t){var e=t.keyInfo,n=t.data,a=t.changes,o=t.groupCount,r=t.useInsertIndex,s=t.immutable,l=t.disableCache,c=t.logError,u=t.skipCopying,d=!0===s?f(n):n;return a.forEach((function(t){var n="insert"===t.type?d:m(e,d,t.key,o);switch(!l&&function(t,e){if(t.key()&&(!e._dataByKeyMap||e._dataByKeyMapLength!==e.length)){for(var n={},i=e.length,a=0;a<i;a++)n[JSON.stringify(t.keyOf(e[a]))]=e[a];e._dataByKeyMap=n,e._dataByKeyMapLength=i}}(e,n),t.type){case"update":x(e,n,t.key,t.data,!0,s,c);break;case"insert":w(e,n,t.data,r&&(0,i.isDefined)(t.index)?t.index:-1,!0,c,u);break;case"remove":k(e,n,t.key,!0,c)}})),d}function y(t,e,n){return t?e&&s.errors.log(n):(0,u.rejectedPromise)(s.errors.Error(n))}function x(t,e,n,o,r,s,c){var d,h=t.key();if(h){if(function(t,e){for(var n="string"==typeof e?e.split():e.slice();n.length;)if(n.shift()in t)return!0;return!1}(o,h)&&!(0,u.keysEqual)(h,n,t.keyOf(o)))return y(r,c,"E4017");if(!(d=function(t,e){if(t._dataByKeyMap)return t._dataByKeyMap[JSON.stringify(e)]}(e,n))){var f=S(t,e,n);if(f<0)return y(r,c,"E4009");if(d=e[f],!0===s&&(0,i.isDefined)(d)){var p=v(d,o);return e[f]=p,!r&&(0,u.trivialPromise)(p,n)}}}else d=n;if((0,l.deepExtendArraySafe)(d,o,!0),!r)return(0,a.default)().useLegacyStoreResult?(0,u.trivialPromise)(n,o):(0,u.trivialPromise)(d,n)}function w(t,e,n,l,c,d,f){var p,g=t.key(),m=(0,i.isPlainObject)(n)&&!f?(0,r.extend)({},n):n;if(g){if(void 0===(p=t.keyOf(m))||"object"===h(p)&&(0,i.isEmptyObject)(p)){if(Array.isArray(g))throw s.errors.Error("E4007");p=m[g]=String(new o.default)}else if(void 0!==e[S(t,e,p)])return y(c,d,"E4008")}else p=m;if(l>=0?e.splice(l,0,m):e.push(m),_(e,p,m),!c)return(0,u.trivialPromise)((0,a.default)().useLegacyStoreResult?n:m,p)}function k(t,e,n,i,a){var o=S(t,e,n);return o>-1&&(e.splice(o,1),_(e,n,null)),i?o<0?y(i,a,"E4009"):void 0:(0,u.trivialPromise)(n)}function S(t,e,n){var i=t.key();if(!function(t,e){return!t._dataByKeyMap||t._dataByKeyMap[JSON.stringify(e)]}(e,n))return-1;for(var a=0,o=e.length;a<o;a++)if((0,u.keysEqual)(i,t.keyOf(e[a]),n))return a;return-1}},88036:function(t,e,n){e.default=void 0;var i=f(n(68374)),a=n(16454),o=n(60637),r=n(35922),s=f(n(80209)),l=n(18438),c=f(n(67403)),u=f(n(35042)),d=f(n(99236)),h=n(62754);function f(t){return t&&t.__esModule?t:{default:t}}function p(t){return t&&(0,r.isFunction)(t.then)}function g(t){return(new h.Deferred).resolve(t).promise()}function m(t,e){if(!(0,r.isFunction)(e))throw l.errors.Error("E4011",t)}function _(t){throw l.errors.Error("E4012",t)}function v(t){function e(t){var e=t[0],n=t[1];return e&&e.getResponseHeader?(0,a.errorMessageFromXhr)(e,n):null}return function(n){var i;(i=n instanceof Error?n:new Error(e(arguments)||n&&String(n)||"Unknown error")).message!==a.XHR_ERROR_UNLOAD&&t.reject(i)}}function b(t,e){var n,i=t._loadFunc;return m("load",i),n=i.apply(t,[e]),Array.isArray(n)?n=g(n):null==n?n=g([]):p(n)||_("load"),(0,h.fromPromise)(n)}function y(t,e,n,i){if(e.__rawData)i(e.__rawData);else{var a=e.__rawDataPromise||b(e,n);e._cacheRawData&&(e.__rawDataPromise=a),a.always((function(){delete e.__rawDataPromise})).done((function(t){e._cacheRawData&&(e.__rawData=t),i(t)})).fail(v(t))}}function x(t,e,n,a){var o={};"userData"in(n=n||{})&&(o.userData=n.userData),y(t,e,o,(function(o){var r,s,l,c,f=(0,u.default)(o,{errorHandler:e._errorHandler}),p=[];a||((r=d.default.queryByOptions(f,n))===f?l=o.slice(0):p.push(r.enumerate().done((function(t){l=t})))),(n.requireTotalCount||a)&&((s=d.default.queryByOptions(f,n,!0))===f?c=o.length:p.push(s.count().done((function(t){c=t})))),h.when.apply(i.default,p).done((function(){a?t.resolve(c):n.requireTotalCount?t.resolve(l,{totalCount:c}):t.resolve(l)})).fail((function(e){t.reject(e)}))}))}var w=c.default.inherit({ctor:function(t){t=t||{},this.callBase(t),this._useDefaultSearch=!!t.useDefaultSearch||"raw"===t.loadMode,this._loadMode=t.loadMode,this._cacheRawData=!1!==t.cacheRawData,this._loadFunc=t.load,this._totalCountFunc=t.totalCount,this._byKeyFunc=t.byKey,this._insertFunc=t.insert,this._updateFunc=t.update,this._removeFunc=t.remove},_clearCache:function(){delete this.__rawData},createQuery:function(){throw l.errors.Error("E4010")},clearRawDataCache:function(){this._clearCache()},_totalCountImpl:function(t){var e=new h.Deferred;return"raw"!==this._loadMode||this._totalCountFunc?(function(t,e){var n,i=t._totalCountFunc;if(!(0,r.isFunction)(i))throw l.errors.Error("E4021");return p(n=i.apply(t,[e]))||(n=Number(n),isFinite(n)||_("totalCount"),n=g(n)),(0,h.fromPromise)(n)}(this,t).done((function(t){e.resolve(Number(t))})).fail(v(e)),e=this._addFailHandlers(e)):x(e,this,t,!0),e.promise()},_pushImpl:function(t){this.__rawData&&(0,o.applyBatch)({keyInfo:this,data:this.__rawData,changes:t})},_loadImpl:function(t){var e=new h.Deferred;return"raw"===this._loadMode?x(e,this,t,!1):(b(this,t).done((function(t,n){e.resolve(t,n)})).fail(v(e)),e=this._addFailHandlers(e)),e.promise()},_byKeyImpl:function(t,e){var n=new h.Deferred;return this._byKeyViaLoad()?(this._requireKey(),function(t,e,n){y(t,e,{},(function(i){for(var o,r=e.key(),s=0,c=i.length;s<c;s++)if(o=i[s],(0,a.keysEqual)(r,e.keyOf(i[s]),n))return void t.resolve(o);t.reject(l.errors.Error("E4009"))}))}(n,this,t)):function(t,e,n){var i,a=t._byKeyFunc;return m("byKey",a),p(i=a.apply(t,[e,n]))||(i=g(i)),(0,h.fromPromise)(i)}(this,t,e).done((function(t){n.resolve(t)})).fail(v(n)),n.promise()},_byKeyViaLoad:function(){return"raw"===this._loadMode&&!this._byKeyFunc},_insertImpl:function(t){var e,n=this,i=n._insertFunc,a=new h.Deferred;return m("insert",i),p(e=i.apply(n,[t]))||(e=g(e)),(0,h.fromPromise)(e).done((function(e){(0,s.default)().useLegacyStoreResult?a.resolve(t,e):a.resolve(e||t,n.keyOf(e))})).fail(v(a)),a.promise()},_updateImpl:function(t,e){var n,i=this._updateFunc,a=new h.Deferred;return m("update",i),p(n=i.apply(this,[t,e]))||(n=g(n)),(0,h.fromPromise)(n).done((function(n){(0,s.default)().useLegacyStoreResult?a.resolve(t,e):a.resolve(n||e,t)})).fail(v(a)),a.promise()},_removeImpl:function(t){var e,n=this._removeFunc,i=new h.Deferred;return m("remove",n),p(e=n.apply(this,[t]))||(e=g()),(0,h.fromPromise)(e).done((function(){i.resolve(t)})).fail(v(i)),i.promise()}});e.default=w,t.exports=e.default,t.exports.default=e.default},33546:function(t,e,n){e.default=void 0;var i=n(85273).DataSource;e.default=i,t.exports=e.default,t.exports.default=e.default},85273:function(t,e,n){e.DataSource=void 0;var i=_(n(38377)),a=n(13306),o=n(20576),r=n(95479),s=n(35922),l=n(16454),c=n(60637),u=_(n(88036)),d=n(80566),h=n(18438),f=n(59504),p=n(62754),g=_(n(88665)),m=n(9234);function _(t){return t&&t.__esModule?t:{default:t}}function v(){return(v=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function b(t){return function(t){if(Array.isArray(t))return y(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return y(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return y(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function y(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var x=i.default.inherit({ctor:function(t){var e,n=this;if(t=(0,m.normalizeDataSourceOptions)(t),this._eventsStrategy=new d.EventsStrategy(this,{syncStrategy:!0}),this._store=t.store,this._changedTime=0,0!==t.pushAggregationTimeout){var i,a,o=void 0===t.pushAggregationTimeout?function(){return 5*n._changedTime}:t.pushAggregationTimeout,s=(0,l.throttleChanges)((function(t){i.resolve(),p.when.apply(void 0,b(a)).done((function(){return n._onPush(t)})),a=void 0,i=void 0}),o);this._onPushHandler=function(t){n._aggregationTimeoutId=s(t.changes),i||(i=new p.Deferred),a=t.waitFor,t.waitFor.push(i.promise())},this._store.on("beforePushAggregation",this._onPushHandler)}else this._onPushHandler=function(t){return n._onPush(t)},this._store.on("push",this._onPushHandler);this._storeLoadOptions=this._extractLoadOptions(t),this._mapFunc=t.map,this._postProcessFunc=t.postProcess,this._pageIndex=void 0!==t.pageIndex?t.pageIndex:0,this._pageSize=void 0!==t.pageSize?t.pageSize:20,this._loadingCount=0,this._loadQueue=this._createLoadQueue(),this._searchValue="searchValue"in t?t.searchValue:null,this._searchOperation=t.searchOperation||"contains",this._searchExpr=t.searchExpr,this._paginate=t.paginate,this._reshapeOnPush=null!==(e=t.reshapeOnPush)&&void 0!==e&&e,(0,r.each)(["onChanged","onLoadError","onLoadingChanged","onCustomizeLoadResult","onCustomizeStoreLoadOptions"],(function(e,i){i in t&&n.on(i.substr(2,1).toLowerCase()+i.substr(3),t[i])})),this._operationManager=new g.default,this._init()},_init:function(){this._items=[],this._userData={},this._totalCount=-1,this._isLoaded=!1,(0,s.isDefined)(this._paginate)||(this._paginate=!this.group()),this._isLastPage=!this._paginate},dispose:function(){var t;this._store.off("beforePushAggregation",this._onPushHandler),this._store.off("push",this._onPushHandler),this._eventsStrategy.dispose(),clearTimeout(this._aggregationTimeoutId),null===(t=this._delayedLoadTask)||void 0===t||t.abort(),this._operationManager.cancelAll(),delete this._store,delete this._items,delete this._delayedLoadTask,this._disposed=!0},_extractLoadOptions:function(t){var e={},n=["sort","filter","langParams","select","group","requireTotalCount"],i=this._store._customLoadOptions();return i&&(n=n.concat(i)),(0,r.each)(n,(function(){e[this]=t[this]})),e},loadOptions:function(){return this._storeLoadOptions},items:function(){return this._items},pageIndex:function(t){if(!(0,s.isNumeric)(t))return this._pageIndex;this._pageIndex=t,this._isLastPage=!this._paginate},paginate:function(t){if(!(0,s.isBoolean)(t))return this._paginate;this._paginate!==t&&(this._paginate=t,this.pageIndex(0))},pageSize:function(t){if(!(0,s.isNumeric)(t))return this._pageSize;this._pageSize=t},isLastPage:function(){return this._isLastPage},generateStoreLoadOptionAccessor:function(t){var e=this;return function(n){var i=(0,m.normalizeStoreLoadOptionAccessorArguments)(n);if(void 0===i)return e._storeLoadOptions[t];e._storeLoadOptions[t]=i}},sort:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return this.generateStoreLoadOptionAccessor("sort")(e)},filter:function(){var t=(0,m.normalizeStoreLoadOptionAccessorArguments)(arguments);if(void 0===t)return this._storeLoadOptions.filter;this._storeLoadOptions.filter=t,this.pageIndex(0)},group:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return this.generateStoreLoadOptionAccessor("group")(e)},select:function(){for(var t=arguments.length,e=new Array(t),n=0;n<t;n++)e[n]=arguments[n];return this.generateStoreLoadOptionAccessor("select")(e)},requireTotalCount:function(t){if(!(0,s.isBoolean)(t))return this._storeLoadOptions.requireTotalCount;this._storeLoadOptions.requireTotalCount=t},searchValue:function(t){if(arguments.length<1)return this._searchValue;this._searchValue=t,this.pageIndex(0)},searchOperation:function(t){if(!(0,s.isString)(t))return this._searchOperation;this._searchOperation=t,this.pageIndex(0)},searchExpr:function(t){var e=arguments.length;if(0===e)return this._searchExpr;e>1&&(t=[].slice.call(arguments)),this._searchExpr=t,this.pageIndex(0)},store:function(){return this._store},key:function(){var t;return null===(t=this._store)||void 0===t?void 0:t.key()},totalCount:function(){return this._totalCount},isLoaded:function(){return this._isLoaded},isLoading:function(){return this._loadingCount>0},beginLoading:function(){this._changeLoadingCount(1)},endLoading:function(){this._changeLoadingCount(-1)},_createLoadQueue:function(){return(0,f.create)()},_changeLoadingCount:function(t){var e=this.isLoading();this._loadingCount+=t;var n=this.isLoading();e^n&&this._eventsStrategy.fireEvent("loadingChanged",[n])},_scheduleLoadCallbacks:function(t){var e=this;this.beginLoading(),t.always((function(){e.endLoading()}))},_scheduleFailCallbacks:function(t){var e=this;t.fail((function(){for(var t=arguments.length,n=new Array(t),i=0;i<t;i++)n[i]=arguments[i];n[0]!==m.CANCELED_TOKEN&&e._eventsStrategy.fireEvent("loadError",n)}))},_fireChanged:function(t){var e=new Date;this._eventsStrategy.fireEvent("changed",t),this._changedTime=new Date-e},_scheduleChangedCallbacks:function(t){var e=this;t.done((function(){return e._fireChanged()}))},loadSingle:function(t,e){var n=this,i=new p.Deferred,a=this.key(),o=this._store,r=this._createStoreLoadOptions(),l=function(t){var e=Array.isArray(t)&&!t.length;!(0,s.isDefined)(t)||e?i.reject(new h.errors.Error("E4009")):(Array.isArray(t)||(t=[t]),i.resolve(n._applyMapFunction(t)[0]))};this._scheduleFailCallbacks(i),arguments.length<2&&(e=t,t=a),delete r.skip,delete r.group,delete r.refresh,delete r.pageIndex,delete r.searchString;var c=function(){return o instanceof u.default&&!o._byKeyViaLoad()};return(t===a||c()?o.byKey(e,r):(r.take=1,r.filter=r.filter?[r.filter,[t,e]]:[t,e],o.load(r))).fail(i.reject).done(l),i.promise()},load:function(){var t=this,e=new p.Deferred,n=function(){if(!t._disposed&&(0,m.isPending)(e))return t._loadFromStore(i,e)};this._scheduleLoadCallbacks(e),this._scheduleFailCallbacks(e),this._scheduleChangedCallbacks(e);var i=this._createLoadOperation(e);return this._eventsStrategy.fireEvent("customizeStoreLoadOptions",[i]),this._loadQueue.add((function(){return"number"==typeof i.delay?t._delayedLoadTask=(0,o.executeAsync)(n,i.delay):n(),e.promise()})),e.promise({operationId:i.operationId})},_onPush:function(t){var e=this;if(this._reshapeOnPush)this.load();else{var n={changes:t};this._eventsStrategy.fireEvent("changing",[n]);var i=this.group(),a=this.items(),o=0,r=this.paginate()||i?t.filter((function(t){return"update"===t.type})):t;i&&(o=Array.isArray(i)?i.length:1),this._mapFunc&&r.forEach((function(t){"insert"===t.type&&(t.data=e._mapFunc(t.data))})),n.postProcessChanges&&(r=n.postProcessChanges(r)),(0,c.applyBatch)({keyInfo:this.store(),data:a,changes:r,groupCount:o,useInsertIndex:!0}),this._fireChanged([{changes:t}])}},_createLoadOperation:function(t){var e=this,n=this._operationManager.add(t),i=this._createStoreLoadOptions();return this._store&&!(0,s.isEmptyObject)(null==i?void 0:i.langParams)&&(this._store._langParams=v({},this._store._langParams,i.langParams)),t.always((function(){return e._operationManager.remove(n)})),{operationId:n,storeLoadOptions:i}},reload:function(){return this.store()._clearCache(),this._init(),this.load()},cancel:function(t){return this._operationManager.cancel(t)},cancelAll:function(){return this._operationManager.cancelAll()},_addSearchOptions:function(t){this._disposed||(this.store()._useDefaultSearch?this._addSearchFilter(t):(t.searchOperation=this._searchOperation,t.searchValue=this._searchValue,t.searchExpr=this._searchExpr))},_createStoreLoadOptions:function(){var t=(0,a.extend)({},this._storeLoadOptions);return this._addSearchOptions(t),this._paginate&&this._pageSize&&(t.skip=this._pageIndex*this._pageSize,t.take=this._pageSize),t.userData=this._userData,t},_addSearchFilter:function(t){var e=this._searchValue,n=this._searchOperation,i=this._searchExpr,a=[];e&&(i||(i="this"),Array.isArray(i)||(i=[i]),(0,r.each)(i,(function(t,i){a.length&&a.push("or"),a.push([i,n,e])})),t.filter?t.filter=[a,t.filter]:t.filter=a)},_loadFromStore:function(t,e){var n=this,i=function(i,o){if(!n._disposed&&(0,m.isPending)(e)){var r=(0,a.extend)((0,m.normalizeLoadResult)(i,o),t);n._eventsStrategy.fireEvent("customizeLoadResult",[r]),(0,p.when)(r.data).done((function(t){r.data=t,n._processStoreLoadResult(r,e)})).fail(e.reject)}};return t.data?(new p.Deferred).resolve(t.data).done(i):this.store().load(t.storeLoadOptions).done(i).fail(e.reject)},_processStoreLoadResult:function(t,e){var n=this,i=t.data,a=t.extra,o=t.storeLoadOptions,r=function(){return n._isLoaded=!0,n._totalCount=isFinite(a.totalCount)?a.totalCount:-1,e.resolve(i,a)};this._disposed||(i=this._applyPostProcessFunction(this._applyMapFunction(i)),(0,s.isObject)(a)||(a={}),this._items=i,(!i.length||!this._paginate||this._pageSize&&i.length<this._pageSize)&&(this._isLastPage=!0),o.requireTotalCount&&!isFinite(a.totalCount)?n.store().totalCount(o).done((function(t){a.totalCount=t,r()})).fail(e.reject):r())},_applyMapFunction:function(t){return this._mapFunc?(0,m.mapDataRespectingGrouping)(t,this._mapFunc,this.group()):t},_applyPostProcessFunction:function(t){return this._postProcessFunc?this._postProcessFunc(t):t},on:function(t,e){return this._eventsStrategy.on(t,e),this},off:function(t,e){return this._eventsStrategy.off(t,e),this}});e.DataSource=x},88665:function(t,e,n){e.default=void 0;var i=n(9234),a=function(){function t(){this._counter=-1,this._deferreds={}}var e=t.prototype;return e.add=function(t){return this._counter++,this._deferreds[this._counter]=t,this._counter},e.remove=function(t){return delete this._deferreds[t]},e.cancel=function(t){return t in this._deferreds&&(this._deferreds[t].reject(i.CANCELED_TOKEN),!0)},e.cancelAll=function(){for(;this._counter>-1;)this.cancel(this._counter),this._counter--},t}();e.default=a,t.exports=e.default,t.exports.default=e.default},9234:function(t,e,n){e.normalizeStoreLoadOptionAccessorArguments=e.normalizeLoadResult=e.normalizeDataSourceOptions=e.mapDataRespectingGrouping=e.isPending=e.CANCELED_TOKEN=void 0;var i=h(n(37208)),a=h(n(67403)),o=h(n(26562)),r=n(95479),s=h(n(88036)),l=n(13306),c=n(35922),u=n(16454),d=["items"];function h(t){return t&&t.__esModule?t:{default:t}}function f(){return(f=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function p(t,e){if(null==t)return{};var n,i,a=function(t,e){if(null==t)return{};var n,i,a={},o=Object.keys(t);for(i=0;i<o.length;i++)n=o[i],e.indexOf(n)>=0||(a[n]=t[n]);return a}(t,e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(t);for(i=0;i<o.length;i++)n=o[i],e.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(t,n)&&(a[n]=t[n])}return a}e.CANCELED_TOKEN="canceled";e.isPending=function(t){return"pending"===t.state()};e.normalizeStoreLoadOptionAccessorArguments=function(t){switch(t.length){case 0:return;case 1:return t[0]}return[].slice.call(t)};var g=function(t,e,n){return(0,r.map)(t,(function(t){t.items;return f({},p(t,d),{items:m(t.items,e-1,n)})}))},m=function(t,e,n){return Array.isArray(t)?e?g(t,e,n):(0,r.map)(t,n):t};e.mapDataRespectingGrouping=function(t,e,n){var i=n?(0,u.normalizeSortingInfo)(n).length:0;return m(t,i,e)};e.normalizeLoadResult=function(t,e){var n;return null!==(n=t)&&void 0!==n&&n.data&&(e=t,t=t.data),Array.isArray(t)||(t=[t]),{data:t,extra:e}};var _=function(t,e){return new s.default({load:function(){return i.default.sendRequest({url:t,dataType:"json"})},loadMode:null==e?void 0:e.fromUrlLoadMode})};e.normalizeDataSourceOptions=function(t,e){var n,i,u;return"string"==typeof t&&(t={paginate:!1,store:_(t,e)}),void 0===t&&(t=[]),void 0===(t=Array.isArray(t)||t instanceof a.default?{store:t}:(0,l.extend)({},t)).store&&(t.store=[]),n=t.store,"load"in t?n=function(t){var e={};return(0,r.each)(["useDefaultSearch","key","load","loadMode","cacheRawData","byKey","lookup","totalCount","insert","update","remove"],(function(){e[this]=t[this],delete t[this]})),new s.default(e)}(t):Array.isArray(n)?n=new o.default(n):(0,c.isPlainObject)(n)&&(i=(0,l.extend)({},n),u=i.type,delete i.type,n=a.default.create(u,i)),t.store=n,t}},8162:function(t,e,n){e.default=void 0;var i,a=(i=n(17381))&&i.__esModule?i:{default:i};var o,r,s=(0,n(58201).getWindow)();var l=function(t){var e;this.config=t,o="ms-appx:"===s.location.protocol,e=s.location.hostname,r=/^(localhost$|127\.)/i.test(e)};l.prototype={urlFor:function(t){var e=this.config[t];if(!e)throw a.default.Error("E0006");return e.production&&(o&&!Debug.debuggerEnabled||!o&&!r)?e.production:e.local}};var c=l;e.default=c,t.exports=e.default,t.exports.default=e.default},18438:function(t,e,n){e.setErrorHandler=e.handleError=e.errors=e.errorHandler=void 0;var i=o(n(95640)),a=o(n(17381));function o(t){return t&&t.__esModule?t:{default:t}}var r=(0,i.default)(a.default.ERROR_MESSAGES,{E4000:"[DevExpress.data]: {0}",E4001:"Unknown aggregating function is detected: '{0}'",E4002:"Unsupported OData protocol version is used",E4003:"Unknown filter operation is used: {0}",E4004:"The thenby() method is called before the sortby() method",E4005:"Store requires a key expression for this operation",E4006:"ArrayStore 'data' option must be an array",E4007:"Compound keys cannot be auto-generated",E4008:"Attempt to insert an item with a duplicated key",E4009:"Data item cannot be found",E4010:"CustomStore does not support creating queries",E4011:"Custom Store method is not implemented or is not a function: {0}",E4012:"Custom Store method returns an invalid value: {0}",E4013:"Local Store requires the 'name' configuration option is specified",E4014:"Unknown data type is specified for ODataStore: {0}",E4015:"Unknown entity name or alias is used: {0}",E4016:"The compileSetter(expr) method is called with 'self' passed as a parameter",E4017:"Keys cannot be modified",E4018:"The server has returned a non-numeric value in a response to an item count request",E4019:"Mixing of group operators inside a single group of filter expression is not allowed",E4020:"Unknown store type is detected: {0}",E4021:"The server response does not provide the totalCount value",E4022:"The server response does not provide the groupCount value",E4023:"Could not parse the following XML: {0}",E4024:"String function {0} cannot be used with the data field {1} of type {2}.",W4000:"Data returned from the server has an incorrect structure",W4001:'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',W4002:"Data loading has failed for some cells due to the following error: {0}"});e.errors=r;var s=null;e.errorHandler=s;e.handleError=function(t){var e;null===(e=s)||void 0===e||e(t)};e.setErrorHandler=function(t){return e.errorHandler=s=t}},82837:function(t,e,n){e.default=void 0;var i=c(n(55994)),a=c(n(73349)),o=n(58201),r=c(n(38377)),s=n(18438),l=c(n(26562));function c(t){return t&&t.__esModule?t:{default:t}}var u=(0,o.getWindow)(),d=r.default.abstract,h={dom:r.default.inherit({ctor:function(t,e){this._store=t,this._dirty=!!e.data,this.save();var n=this._immediate=e.immediate,o=Math.max(100,e.flushInterval||1e4);if(!n){var r=this.save.bind(this);setInterval(r,o),i.default.on(u,"beforeunload",r),u.cordova&&a.default.listen(a.default.getDocument(),"pause",r,!1)}},notifyChanged:function(){this._dirty=!0,this._immediate&&this.save()},load:function(){this._store._array=this._loadImpl(),this._dirty=!1},save:function(){this._dirty&&(this._saveImpl(this._store._array),this._dirty=!1)},_loadImpl:d,_saveImpl:d}).inherit({ctor:function(t,e){var n=e.name;if(!n)throw s.errors.Error("E4013");this._key="dx-data-localStore-"+n,this.callBase(t,e)},_loadImpl:function(){var t=u.localStorage.getItem(this._key);return t?JSON.parse(t):[]},_saveImpl:function(t){t.length?u.localStorage.setItem(this._key,JSON.stringify(t)):u.localStorage.removeItem(this._key)}})},f=l.default.inherit({ctor:function(t){t="string"==typeof t?{name:t}:t||{},this.callBase(t),this._backend=new h[t.backend||"dom"](this,t),this._backend.load()},_clearCache:function(){this._backend.load()},clear:function(){this.callBase(),this._backend.notifyChanged()},_insertImpl:function(t){var e=this._backend;return this.callBase(t).done(e.notifyChanged.bind(e))},_updateImpl:function(t,e){var n=this._backend;return this.callBase(t,e).done(n.notifyChanged.bind(n))},_removeImpl:function(t){var e=this._backend;return this.callBase(t).done(e.notifyChanged.bind(e))}},"local");e.default=f,t.exports=e.default,t.exports.default=e.default},47256:function(t,e,n){e.default=void 0;var i=h(n(38377)),a=n(13306),o=n(35922),r=n(95479),s=n(18438),l=h(n(341)),c=h(n(63081)),u=n(77869),d=n(62754);function h(t){return t&&t.__esModule?t:{default:t}}n(54263);var f=i.default.inherit({ctor:function(t){var e=this;this._requestDispatcher=new c.default(t),this._errorHandler=t.errorHandler,(0,r.each)(t.entities||[],(function(n,i){e[n]=new l.default((0,a.extend)({},t,{url:"".concat(e._requestDispatcher.url,"/").concat(encodeURIComponent(i.name||n))},i))}))},get:function(t,e){return this.invoke(t,e,"GET")},invoke:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:"POST";n=n.toLowerCase();var i,a=new d.Deferred,r="".concat(this._requestDispatcher.url,"/").concat(encodeURIComponent(t));return 4===this.version()&&("get"===n?(r=(0,u.formatFunctionInvocationUrl)(r,(0,u.escapeServiceOperationParams)(e,this.version())),e=null):"post"===n&&(i=e,e=null)),(0,d.when)(this._requestDispatcher.sendRequest(r,n,(0,u.escapeServiceOperationParams)(e,this.version()),i)).done((function(e){(0,o.isPlainObject)(e)&&t in e&&(e=e[t]),a.resolve(e)})).fail(this._errorHandler).fail(s.handleError).fail(a.reject),a.promise()},objectLink:function(t,e){var n=this[t];if(!n)throw s.errors.Error("E4015",t);return(0,o.isDefined)(e)?{__metadata:{uri:n._byKeyUrl(e)}}:null},version:function(){return this._requestDispatcher.version}});e.default=f,t.exports=e.default,t.exports.default=e.default},54263:function(t,e,n){e.odata=void 0;var i=n(35922),a=n(95479),o=d(n(80209)),r=n(13306),s=d(n(16135)),l=n(77869),c=n(18438),u=n(16454);function d(t){return t&&t.__esModule?t:{default:t}}var h,f,p,g,m,_,v,b,y,x,w,k,S=["contains","notcontains","startswith","endswith"],C=(m=function(t,e){return function(n,i){var a=[t,"("];return f&&(n=-1===n.indexOf("tolower(")?"tolower(".concat(n,")"):n,i=i.toLowerCase()),e?a.push(i,",",n):a.push(n,",",i),a.push(")"),a.join("")}},_={"=":(g=function(t){return function(e,n){return"".concat(e," ").concat(t," ").concat(n)}})("eq"),"<>":g("ne"),">":g("gt"),">=":g("ge"),"<":g("lt"),"<=":g("le"),startswith:m("startswith"),endswith:m("endswith")},v=(0,r.extend)({},_,{contains:m("substringof",!0),notcontains:m("not substringof",!0)}),b=(0,r.extend)({},_,{contains:m("contains"),notcontains:m("not contains")}),y=function(t){var e,n,i=(t=(0,u.normalizeBinaryCriterion)(t))[1],a=t[0],o=p&&p[a];if(o&&(n=i,S.some((function(t){return t===n})))&&"String"!==o)throw new c.errors.Error("E4024",i,a,o);var r=(4===h?b:v)[i.toLowerCase()];if(!r)throw c.errors.Error("E4003",i);var s=t[2];return null!==(e=p)&&void 0!==e&&e[a]&&(s=(0,l.convertPrimitiveValue)(p[a],s)),r((0,l.serializePropName)(a),(0,l.serializeValue)(s,h))},x=function(t){var e=t[0],n=k(t[1]);if("!"===e)return"not (".concat(n,")");throw c.errors.Error("E4003",e)},w=function(t){var e,n,i=[];return(0,a.each)(t,(function(t,a){if(Array.isArray(a)){if(i.length>1&&e!==n)throw new c.errors.Error("E4019");i.push("(".concat(k(a),")")),e=n,n="and"}else n=(0,u.isConjunctiveOperator)(this)?"and":"or"})),i.join(" ".concat(e," "))},k=function(t){return Array.isArray(t[0])?w(t):(0,u.isUnaryOperation)(t)?x(t):y(t)},function(t,e,n,i){return p=n,f=null!=i?i:(0,o.default)().oDataFilterToLower,h=e,k(t)}),A=function(t){var e,n,a,o,s=[],c=[],u=t.expand,d=t.version||2,h=function(){return n||void 0!==a},f=function t(e){for(var n=0;n<e.length;n++){if((0,i.isFunction)(e[n]))return!0;if(Array.isArray(e[n])&&t(e[n]))return!0}return!1},p=function(){var i={};if(o||(s.length&&(i.$orderby=s.join(",")),n&&(i.$skip=n),void 0!==a&&(i.$top=a),i.$select=(0,l.generateSelect)(d,e)||void 0,i.$expand=(0,l.generateExpand)(d,u,e)||void 0),c.length){var r=c.length<2?c[0]:c,h=null==t?void 0:t.fieldTypes,f=null==t?void 0:t.filterToLower;i.$filter=C(r,d,h,f)}return o&&(i.$top=0),(t.requireTotalCount||o)&&(4!==d?i.$inlinecount="allpages":i.$count="true"),i};return{optimize:function(t){for(var e=-1,n=0;n<t.length;n++)if("select"===t[n].name){e=n;break}if(!(e<0)&&(0,i.isFunction)(t[e].args[0])){var a=t[1+e];a&&"slice"===a.name&&(t[1+e]=t[e],t[e]=a)}},exec:function(e){return(0,l.sendRequest)(d,{url:e,params:(0,r.extend)(p(),null==t?void 0:t.params)},{beforeSend:t.beforeSend,jsonp:t.jsonp,withCredentials:t.withCredentials,countOnly:o,deserializeDates:t.deserializeDates,fieldTypes:t.fieldTypes,isPaged:isFinite(a)})},multiSort:function(t){var e;if(h())return!1;for(var n=0;n<t.length;n++){var i=t[n][0],a=!!t[n][1],o=void 0;if("string"!=typeof i)return!1;o=(0,l.serializePropName)(i),a&&(o+=" desc"),(e=e||[]).push(o)}s=e},slice:function(t,e){if(h())return!1;n=t,a=e},filter:function(t){return!h()&&(Array.isArray(t)||(t=[].slice.call(arguments)),!f(t)&&(c.length&&c.push("and"),void c.push(t)))},select:function(t){if(e||(0,i.isFunction)(t))return!1;Array.isArray(t)||(t=[].slice.call(arguments)),e=t},count:function(){return o=!0}}};s.default.odata=A;var E=A;e.odata=E},63081:function(t,e,n){e.default=void 0;var i=n(77869);function a(t){return(a="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function o(t,e){for(var n=0;n<e.length;n++){var i=e[n];i.enumerable=i.enumerable||!1,i.configurable=!0,"value"in i&&(i.writable=!0),Object.defineProperty(t,(o=i.key,r=void 0,r=function(t,e){if("object"!==a(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==a(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(o,"string"),"symbol"===a(r)?r:String(r)),i)}var o,r}n(54263);var r=function(){function t(t){t=t||{},this._url=String(t.url).replace(/\/+$/,""),this._beforeSend=t.beforeSend,this._jsonp=t.jsonp,this._version=t.version||2,this._withCredentials=t.withCredentials,this._deserializeDates=t.deserializeDates,this._filterToLower=t.filterToLower}var e,n,a;return t.prototype.sendRequest=function(t,e,n,a){return(0,i.sendRequest)(this.version,{url:t,method:e,params:n||{},payload:a},{beforeSend:this._beforeSend,jsonp:this._jsonp,withCredentials:this._withCredentials,deserializeDates:this._deserializeDates})},e=t,(n=[{key:"version",get:function(){return this._version}},{key:"beforeSend",get:function(){return this._beforeSend}},{key:"url",get:function(){return this._url}},{key:"jsonp",get:function(){return this._jsonp}},{key:"filterToLower",get:function(){return this._filterToLower}}])&&o(e.prototype,n),a&&o(e,a),Object.defineProperty(e,"prototype",{writable:!1}),t}();e.default=r,t.exports=e.default,t.exports.default=e.default},341:function(t,e,n){e.default=void 0;var i=n(35922),a=d(n(80209)),o=n(77869),r=n(18438),s=d(n(96687)),l=d(n(67403)),c=d(n(63081)),u=n(62754);function d(t){return t&&t.__esModule?t:{default:t}}function h(t){return(h="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function f(t,e,n){return(e=function(t){var e=function(t,e){if("object"!==h(t)||null===t)return t;var n=t[Symbol.toPrimitive];if(void 0!==n){var i=n.call(t,e||"default");if("object"!==h(i))return i;throw new TypeError("@@toPrimitive must return a primitive value.")}return("string"===e?String:Number)(t)}(t,"string");return"symbol"===h(e)?e:String(e)}(e))in t?Object.defineProperty(t,e,{value:n,enumerable:!0,configurable:!0,writable:!0}):t[e]=n,t}n(54263);var p=l.default.inherit({ctor:function(t){this.callBase(t),this._requestDispatcher=new c.default(t);var e=this.key(),n=t.fieldTypes,i=t.keyType;if(i){var a="string"==typeof i;e||(e=a?"5d46402c-7899-4ea9-bd81-8b73c47c7683":Object.keys(i),this._legacyAnonymousKey=e),a&&(i=function(t,e){return f({},t,e)}(e,i)),n=function(t,e){var n={};for(var i in t)n[i]=t[i];for(var a in e)a in n?n[a]!==e[a]&&r.errors.log("W4001",a):n[a]=e[a];return n}(n,i)}this._fieldTypes=n||{},2===this.version()?this._updateMethod="MERGE":this._updateMethod="PATCH"},_customLoadOptions:function(){return["expand","customQueryParams"]},_byKeyImpl:function(t,e){var n={};return e&&(n.$expand=(0,o.generateExpand)(this.version(),e.expand,e.select)||void 0,n.$select=(0,o.generateSelect)(this.version(),e.select)||void 0),this._requestDispatcher.sendRequest(this._byKeyUrl(t),"GET",n)},createQuery:function(t){var e,n,a={adapter:"odata",beforeSend:this._requestDispatcher.beforeSend,errorHandler:this._errorHandler,jsonp:this._requestDispatcher.jsonp,version:this._requestDispatcher.version,withCredentials:this._requestDispatcher._withCredentials,expand:null==t?void 0:t.expand,requireTotalCount:null==t?void 0:t.requireTotalCount,deserializeDates:this._requestDispatcher._deserializeDates,fieldTypes:this._fieldTypes};if(n=null!==(e=null==t?void 0:t.urlOverride)&&void 0!==e?e:this._requestDispatcher.url,(0,i.isDefined)(this._requestDispatcher.filterToLower)&&(a.filterToLower=this._requestDispatcher.filterToLower),null!=t&&t.customQueryParams){var r=(0,o.escapeServiceOperationParams)(null==t?void 0:t.customQueryParams,this.version());4===this.version()?n=(0,o.formatFunctionInvocationUrl)(n,r):a.params=r}return(0,s.default)(n,a)},_insertImpl:function(t){var e=this;this._requireKey();var n=new u.Deferred;return(0,u.when)(this._requestDispatcher.sendRequest(this._requestDispatcher.url,"POST",null,t)).done((function(i){return n.resolve(i&&!(0,a.default)().useLegacyStoreResult?i:t,e.keyOf(i))})).fail(n.reject),n.promise()},_updateImpl:function(t,e){var n=new u.Deferred;return(0,u.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(t),this._updateMethod,null,e)).done((function(i){return(0,a.default)().useLegacyStoreResult?n.resolve(t,e):n.resolve(i||e,t)})).fail(n.reject),n.promise()},_removeImpl:function(t){var e=new u.Deferred;return(0,u.when)(this._requestDispatcher.sendRequest(this._byKeyUrl(t),"DELETE")).done((function(){return e.resolve(t)})).fail(e.reject),e.promise()},_convertKey:function(t){var e=t,n=this._fieldTypes,i=this.key()||this._legacyAnonymousKey;if(Array.isArray(i)){e={};for(var a=0;a<i.length;a++){var r=i[a];e[r]=(0,o.convertPrimitiveValue)(n[r],t[r])}}else n[i]&&(e=(0,o.convertPrimitiveValue)(n[i],t));return e},_byKeyUrl:function(t){var e=this._requestDispatcher.url,n=this._convertKey(t);return"".concat(e,"(").concat(encodeURIComponent((0,o.serializeKey)(n,this.version())),")")},version:function(){return this._requestDispatcher.version}},"odata");e.default=p,t.exports=e.default,t.exports.default=e.default},77869:function(t,e,n){e.serializeValue=e.serializePropName=e.serializeKey=e.sendRequest=e.keyConverters=e.generateSelect=e.generateExpand=e.formatFunctionInvocationUrl=e.escapeServiceOperationParams=e.convertPrimitiveValue=e.EdmLiteral=void 0;var i=p(n(38377)),a=n(13306),o=n(35922),r=n(95479),s=p(n(37208)),l=p(n(73176)),c=n(20576),u=n(62754),d=n(18438),h=n(16454),f=n(68752);function p(t){return t&&t.__esModule?t:{default:t}}function g(t){return(g="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}var m=/^(\{{0,1}([0-9a-fA-F]){8}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){4}-([0-9a-fA-F]){12}\}{0,1})$/,_=/^\/Date\((-?\d+)((\+|-)?(\d+)?)\)\/$/,v=/^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}(\.\d+)?(Z|[-+]{1}\d{2}(:?)(\d{2})?)?$/,b="application/json;odata=verbose",y=function(t){return"string"===(0,o.type)(t)?t.split():t},x=function(t){return/\./.test(t)},w=function(t,e,n){for(t=String(t);t.length<e;)t=n?"".concat(t,"0"):"0".concat(t);return t},k=function(t,e,n){var i=[],a=function(t){return w(t,2)};return i.push(t.getFullYear()),i.push("-"),i.push(a(t.getMonth()+1)),i.push("-"),i.push(a(t.getDate())),e&&t.getHours()+t.getMinutes()+t.getSeconds()+t.getMilliseconds()<1||(i.push("T"),i.push(a(t.getHours())),i.push(":"),i.push(a(t.getMinutes())),i.push(":"),i.push(a(t.getSeconds())),t.getMilliseconds()&&(i.push("."),i.push(w(t.getMilliseconds(),3))),n||i.push("Z")),i.join("")},S=function(t){var e=new Date(60*new Date(0).getTimezoneOffset()*1e3),n=t.replace("Z","").split("T"),i=/(\d{4})-(\d{2})-(\d{2})/.exec(n[0]),a=/(\d{2}):(\d{2}):(\d{2})\.?(\d{0,7})?/.exec(n[1]);if(e.setFullYear(Number(i[1])),e.setMonth(Number(i[2])-1),e.setDate(Number(i[3])),Array.isArray(a)&&a.length){e.setHours(Number(a[1])),e.setMinutes(Number(a[2])),e.setSeconds(Number(a[3]));var o=(a[4]||"").slice(0,3);o=w(o,3,!0),e.setMilliseconds(Number(o))}return e},C=function(t){var e=[];for(var n in t)e.push(n+"="+t[n]);return e.join("&")};e.sendRequest=function t(e,n,i){var o=i.deserializeDates,r=i.fieldTypes,l=i.countOnly,c=i.isPaged,f=new u.Deferred,p=function(t,e){var n,i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},o=function(e){return JSON.stringify(e,(function(e,n){if(!(this[e]instanceof Date))return n;switch(n=k(this[e]),t){case 2:return n.substr(0,n.length-1);case 3:case 4:return n;default:throw d.errors.Error("E4002")}}))};e=(0,a.extend)({async:!0,method:"get",url:"",params:{},payload:null,headers:{},timeout:3e4},e),null===(n=i.beforeSend)||void 0===n||n.call(i,e);var r=e,s=r.async,l=r.timeout,c=r.headers,u=e,h=u.url,f=u.method,p=i.jsonp,g=i.withCredentials,m="get"===(f=(f||"get").toLowerCase()),_=m&&p,v=(0,a.extend)({},e.params),y=m?v:o(e.payload),x=!m&&C(v),w=!m&&b;return x&&(h+=(h.indexOf("?")>-1?"&":"?")+x),_&&(y.$format="json"),{url:h,data:y,dataType:_?"jsonp":"json",jsonp:_&&"$callback",method:f,async:s,timeout:l,headers:c,contentType:w,accepts:{json:[b,"text/plain"].join()},xhrFields:{withCredentials:g}}}(e,n,i);return s.default.sendRequest(p).always((function(n,a){var s=A(n,a,{deserializeDates:o,fieldTypes:r},p),u=s.error,g=s.data,m=s.count,_=s.nextUrl;if(u)u.message!==h.XHR_ERROR_UNLOAD&&f.reject(u);else if(l)isFinite(m)?f.resolve(m):f.reject(new d.errors.Error("E4018"));else if(_&&!c)/^(?:[a-z]+:)?\/{2,2}/i.test(_)||(_=function(t,e){var n,i,a,o=(i=t,a=i.indexOf("?"),a>-1?i.substr(0,a):i).split("/"),r=e.split("/");for(o.pop();r.length;)".."===(n=r.shift())?o.pop():o.push(n);return o.join("/")}(p.url,_)),t(e,{url:_},i).fail(f.reject).done((function(t){return f.resolve(g.concat(t))}));else{var v=isFinite(m)?{totalCount:m}:void 0;f.resolve(g,v)}})),f.promise()};var A=function(t,e,n,i){var r=function(t,e,n){var i,o,r,s;if("nocontent"===e)return null;var l="Unknown error",c=t,u=200,d={requestOptions:n};if("success"!==e){var f=t.status,p=t.responseText;u=f,l=(0,h.errorMessageFromXhr)(t,e);try{c=JSON.parse(p)}catch(t){}}var g=(null===(i=c)||void 0===i?void 0:i.then)||(null===(o=c)||void 0===o?void 0:o.error)||(null===(r=c)||void 0===r?void 0:r["odata.error"])||(null===(s=c)||void 0===s?void 0:s["@odata.error"]);if(g){l=function(t){var e,n,i=t;"message"in t&&(e=(null===(n=t.message)||void 0===n?void 0:n.value)||t.message);for(;i=i.innererror||i.internalexception;){var a;if(e=null!==(a=i.message)&&void 0!==a?a:e,i.internalexception&&-1===e.indexOf("inner exception"))break}return e}(g)||l,d.errorDetails=g,200===u&&(u=500);var m=Number(g.code);isFinite(m)&&m>=400&&(u=m)}return u>=400||0===u?(d.httpStatus=u,(0,a.extend)(Error(l),d)):null}(t,e,i);if(r)return{error:r};if(!(0,o.isPlainObject)(t))return{data:t};var s="d"in t&&(Array.isArray(t.d)||(0,o.isObject)(t.d))?E(t):T(t);return D(s,n),s},E=function(t){var e,n=t.d;return(0,o.isDefined)(n)?{data:null!==(e=n.results)&&void 0!==e?e:n,nextUrl:n.__next,count:parseInt(n.__count,10)}:{error:Error("Malformed or unsupported JSON response received")}},T=function(t){var e;return{data:null!==(e=t.value)&&void 0!==e?e:t,nextUrl:t["@odata.nextLink"],count:parseInt(t["@odata.count"],10)}},I=i.default.inherit({ctor:function(t){this._value=t},valueOf:function(){return this._value}});e.EdmLiteral=I;var D=function t(e){var n=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{};(0,r.each)(e,(function(i,a){if(null!==a&&"object"===g(a))"results"in a&&(e[i]=a.results),t(e[i],n);else if("string"==typeof a){var o=n.fieldTypes,r=n.deserializeDates;if((!o||"String"!==o[i])&&m.test(a)&&(e[i]=new l.default(a)),!1!==r)if(a.match(_)){var s=new Date(Number(RegExp.$1)+60*RegExp.$2*1e3);e[i]=new Date(s.valueOf()+60*s.getTimezoneOffset()*1e3)}else v.test(a)&&(e[i]=new Date(S(e[i]).valueOf()))}}))},O=function(t){return t instanceof I?t.valueOf():t.replace(/\./g,"/")};e.serializePropName=O;var L=function(t){return t instanceof Date?"datetime'".concat(k(t,!0,!0),"'"):t instanceof l.default?"guid'".concat(t,"'"):t instanceof I?t.valueOf():"string"==typeof t?function(t){return"'".concat(t.replace(/'/g,"''"),"'")}(t):String(t)},M=function(t,e){switch(e){case 2:case 3:return L(t);case 4:return function t(e){return e instanceof Date?k(e,!1,!1):e instanceof l.default?e.valueOf():Array.isArray(e)?"[".concat(e.map((function(e){return t(e)})).join(","),"]"):L(e)}(t);default:throw d.errors.Error("E4002")}};e.serializeValue=M;e.serializeKey=function(t,e){if((0,o.isPlainObject)(t)){var n=[];return(0,r.each)(t,(function(t,i){return n.push("".concat(O(t),"=").concat(M(i,e)))})),n.join()}return M(t,e)};var P={String:function(t){return"".concat(t)},Int32:function(t){return Math.floor(t)},Int64:function(t){return t instanceof I?t:new I("".concat(t,"L"))},Guid:function(t){return t instanceof l.default?t:new l.default(t)},Boolean:function(t){return!!t},Single:function(t){return t instanceof I?t:new I(t+"f")},Decimal:function(t){return t instanceof I?t:new I(t+"m")}};e.keyConverters=P;e.convertPrimitiveValue=function(t,e){if(null===e)return null;var n=P[t];if(!n)throw d.errors.Error("E4014",t);return n(e)};e.generateSelect=function(t,e){if(e)return t<4?O(e.join()):(0,c.grep)(e,x,!0).join()};var R=function(t){var e=[];return(0,r.each)(t,(function(t,n){return e.push("".concat(t).concat(function t(e){var n="",i=[],a=[];return(0,r.each)(e,(function(e,n){Array.isArray(n)&&[].push.apply(i,n),(0,o.isPlainObject)(n)&&a.push("".concat(e).concat(t(n)))})),(i.length||a.length)&&(n+="(",i.length&&(n+="$select=".concat((0,r.map)(i,O).join())),a.length&&(i.length&&(n+=";"),n+="$expand=".concat((0,r.map)(a,O).join())),n+=")"),n}(n)))})),e.join()},B=function(t,e,n){return(0,r.each)(t,(function(t,i){return function t(e,n,i){var a=i(n,e.shift(),e);!1!==a&&t(e,a,i)}(i.split("."),e,n)}))};e.generateExpand=function(t,e,n){return t<4?function(t,e){var n={};return t&&(0,r.each)(y(t),(function(){n[O(this)]=1})),e&&(0,r.each)(y(e),(function(){var t=this.split(".");t.length<2||(t.pop(),n[O(t.join("."))]=1)})),(0,r.map)(n,(function(t,e){return e})).join()}(e,n):function(t,e){var n={};if(t||e)return t&&B(y(t),n,(function(t,e,n){return t[e]=t[e]||{},!!n.length&&t[e]})),e&&B((0,c.grep)(y(e),x),n,(function(t,e,n){return n.length?t[e]=t[e]||{}:(t[e]=t[e]||[],t[e].push(e),!1)})),R(n)}(e,n)};e.formatFunctionInvocationUrl=function(t,e){return(0,f.format)("{0}({1})",t,(0,r.map)(e||{},(function(t,e){return(0,f.format)("{0}={1}",e,t)})).join(","))};e.escapeServiceOperationParams=function(t,e){if(!t)return t;var n={};return(0,r.each)(t,(function(t,i){n[t]=M(i,e)})),n}},96687:function(t,e,n){e.default=void 0;var i=n(77549),a=function(){var t=Array.isArray(arguments[0])?"array":"remote";return i.queryImpl[t].apply(this,arguments)};e.default=a,t.exports=e.default,t.exports.default=e.default},16135:function(t,e){e.default=void 0;e.default={},t.exports=e.default,t.exports.default=e.default},77549:function(t,e,n){e.queryImpl=void 0;var i=o(n(35042)),a=o(n(41428));function o(t){return t&&t.__esModule?t:{default:t}}var r={array:i.default,remote:a.default};e.queryImpl=r},41428:function(t,e,n){e.default=void 0;var i=c(n(16135)),a=n(18438),o=n(95479),r=n(35922),s=n(62754),l=c(n(35042));function c(t){return t&&t.__esModule?t:{default:t}}var u=function t(e,n,c){c=c||[],n=n||{};var u=function(t,e){return{name:t,args:e}},d=function(t){var d,h,f,p,g,m,_,v=new s.Deferred,b=function(t){var e=n.errorHandler;e&&e(t),(0,a.handleError)(t),v.reject(t)};function y(t){switch(t.name){case"sortBy":return g=[t.args],!0;case"thenBy":if(!g)throw a.errors.Error("E4004");return g.push(t.args),!0}return!1}try{d=n.adapter,(0,r.isFunction)(d)||(d=i.default[d]),h=d(n),f=[].concat(c).concat(t);var x=h.optimize;for(x&&x(f);f.length;){if(!y(p=f[0])){if(g){f.unshift(u("multiSort",[g])),g=null;continue}if("enumerate"!==String(p.name)&&(!h[p.name]||!1===h[p.name].apply(h,p.args)))break}f.shift()}m=f[0],_=[],m&&"multiSort"===m.name&&(f.shift(),(0,o.each)(m.args[0],(function(){_.push(u(_.length?"thenBy":"sortBy",this))}))),f=_.concat(f),h.exec(e).done((function(t,e){if(f.length){var i=(0,l.default)(t,{errorHandler:n.errorHandler});(0,o.each)(f,(function(){i=i[this.name].apply(i,this.args)})),i.done(v.resolve).fail(v.reject)}else v.resolve(t,e)})).fail(b)}catch(t){b(t)}return v.promise()},h={};return(0,o.each)(["sortBy","thenBy","filter","slice","select","groupBy"],(function(){var i=String(this);h[i]=function(){return t(e,n,c.concat(u(i,arguments)))}})),(0,o.each)(["count","min","max","sum","avg","aggregate","enumerate"],(function(){var t=String(this);h[t]=function(){return d.call(this,u(t,arguments))}})),h};e.default=u,t.exports=e.default,t.exports.default=e.default},99236:function(t,e,n){e.default=void 0;var i,a=n(20576),o=n(13306),r=n(95479),s=(i=n(35042))&&i.__esModule?i:{default:i},l=n(16454);function c(t,e){return t=t.groupBy(e[0].selector),e.length>1&&(t=t.select((function(t){return(0,o.extend)({},t,{items:c((0,s.default)(t.items),e.slice(1)).toArray()})}))),t}function u(t,e){var n=[];return(0,r.each)(t,(function(t,i){(0,a.grep)(e,(function(t){return i.selector===t.selector})).length<1&&n.push(i)})),n.concat(e)}var d={multiLevelGroup:c,arrangeSortingInfo:u,queryByOptions:function(t,e,n){var i,a,o,s=(e=e||{}).filter;if(null!==(i=e)&&void 0!==i&&i.langParams&&(null===(a=(o=t).setLangParams)||void 0===a||a.call(o,e.langParams)),s&&(t=t.filter(s)),n)return t;var d=e.sort,h=e.select,f=e.group,p=e.skip,g=e.take;return f&&((f=(0,l.normalizeSortingInfo)(f)).keepInitialKeyOrder=!!e.group.keepInitialKeyOrder),(d||f)&&(d=(0,l.normalizeSortingInfo)(d||[]),f&&!f.keepInitialKeyOrder&&(d=u(f,d)),(0,r.each)(d,(function(e){t=t[e?"thenBy":"sortBy"](this.selector,this.desc,this.compare)}))),h&&(t=t.select(h)),f&&(t=c(t,f)),(g||p)&&(t=t.slice(p||0,g)),t}};e.default=d,t.exports=e.default,t.exports.default=e.default},16454:function(t,e,n){e.errorMessageFromXhr=e.base64_encode=e.aggregators=e.XHR_ERROR_UNLOAD=void 0,e.isConjunctiveOperator=function(t){return/^(and|&&|&)$/i.test(t)},e.isDisjunctiveOperator=function(t){return/^(or|\|\||\|)$/i.test(t)},e.rejectedPromise=e.processRequestResultLock=e.normalizeSortingInfo=e.normalizeBinaryCriterion=e.keysEqual=e.isUnaryOperation=e.isGroupCriterion=void 0,e.throttleChanges=function(t,e){var n=[],a=function(t,e){var n;return function(){var a=this;return n||(n=setTimeout((function(){n=void 0,t.call(a)}),(0,i.isFunction)(e)?e():e)),n}}((function(){t.call(this,n),n=[]}),e);return function(t){var e,i;Array.isArray(t)&&(e=n).push.apply(e,function(t){if(Array.isArray(t))return d(t)}(i=t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(i)||function(t,e){if(t){if("string"==typeof t)return d(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?d(t,e):void 0}}(i)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}());return a.call(this,n)}},e.trivialPromise=void 0;var i=n(35922),a=u(n(73349)),o=u(n(24311)),r=n(58201),s=n(95479),l=n(62754),c=n(20576);function u(t){return t&&t.__esModule?t:{default:t}}function d(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}var h=o.default.add;e.XHR_ERROR_UNLOAD="DEVEXTREME_XHR_ERROR_UNLOAD";e.normalizeBinaryCriterion=function(t){return[t[0],t.length<3?"=":String(t[1]).toLowerCase(),t.length<2||t[t.length-1]]};e.normalizeSortingInfo=function(t){return Array.isArray(t)||(t=[t]),(0,s.map)(t,(function(t){var e={selector:(0,i.isFunction)(t)||"string"==typeof t?t:t.getter||t.field||t.selector,desc:!(!t.desc&&"d"!==String(t.dir).charAt(0).toLowerCase())};return t.compare&&(e.compare=t.compare),e}))};var f,p,g=(p={timeout:"Network connection timeout",error:"Unspecified network error",parsererror:"Unexpected server response"},h((function(){var t=(0,r.getWindow)();a.default.listen(t,"beforeunload",(function(){f=!0}))})),function(t,e){return f?"DEVEXTREME_XHR_ERROR_UNLOAD":t.status<400?function(t){var e=p[t];return e||t}(e):t.statusText});e.errorMessageFromXhr=g;var m={count:{seed:0,step:function(t){return 1+t}},sum:{seed:0,step:function(t,e){return t+e}},min:{step:function(t,e){return e<t?e:t}},max:{step:function(t,e){return e>t?e:t}},avg:{seed:[0,0],step:function(t,e){return[t[0]+e,t[1]+1]},finalize:function(t){return t[1]?t[0]/t[1]:NaN}}};e.aggregators=m;var _,v,b=(v=0,{obtain:function(){0===v&&(_=new l.Deferred),v++},release:function(){--v<1&&_.resolve()},promise:function(){return(0===v?(new l.Deferred).resolve():_).promise()},reset:function(){v=0,_&&_.resolve()}});e.processRequestResultLock=b;e.keysEqual=function(t,e,n){if(Array.isArray(t)){for(var i,a=(0,s.map)(e,(function(t,e){return e})),o=0;o<a.length;o++)if(i=a[o],!(0,c.equalByValue)(e[i],n[i],{strict:!1}))return!1;return!0}return(0,c.equalByValue)(e,n,{strict:!1})};e.base64_encode=function(t){Array.isArray(t)||(t=function(t){var e,n,i=[];for(n=0;n<t.length;n++)(e=t.charCodeAt(n))<128?i.push(e):e<2048?i.push(192+(e>>6),128+(63&e)):e<65536?i.push(224+(e>>12),128+(e>>6&63),128+(63&e)):e<2097152&&i.push(240+(e>>18),128+(e>>12&63),128+(e>>6&63),128+(63&e));return i}(String(t)));var e="";function n(t){return"ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=".charAt(t)}for(var i=0;i<t.length;i+=3){var a=t[i],o=t[i+1],r=t[i+2];e+=(0,s.map)([a>>2,(3&a)<<4|o>>4,isNaN(o)?64:(15&o)<<2|r>>6,isNaN(r)?64:63&r],n).join("")}return e};e.isUnaryOperation=function(t){return"!"===t[0]&&Array.isArray(t[1])};e.isGroupCriterion=function(t){var e,n=t[0],a=t[1];return!!Array.isArray(n)||!(!(0,i.isFunction)(n)||!Array.isArray(a)&&!(0,i.isFunction)(a)&&"and"!==(e=a)&&"or"!==e)};e.trivialPromise=function(){var t=new l.Deferred;return t.resolve.apply(t,arguments).promise()};e.rejectedPromise=function(){var t=new l.Deferred;return t.reject.apply(t,arguments).promise()}},53305:function(t,e,n){e.default=void 0;var i,a=n(85273),o=n(13306),r=n(9234),s=(i=n(97326))&&i.__esModule?i:{default:i};var l={postCtor:function(){this.on("disposing",function(){this._disposeDataSource()}.bind(this))},_refreshDataSource:function(){this._initDataSource(),this._loadDataSource()},_initDataSource:function(){var t,e,n="_getSpecificDataSourceOption"in this?this._getSpecificDataSourceOption():this.option("dataSource");this._disposeDataSource(),n&&(n instanceof a.DataSource?(this._isSharedDataSource=!0,this._dataSource=n):(t="_dataSourceOptions"in this?this._dataSourceOptions():{},e=this._dataSourceType?this._dataSourceType():a.DataSource,n=(0,r.normalizeDataSourceOptions)(n,{fromUrlLoadMode:"_dataSourceFromUrlLoadMode"in this&&this._dataSourceFromUrlLoadMode()}),this._dataSource=new e((0,o.extend)(!0,{},t,n))),"_normalizeDataSource"in this&&(this._dataSource=this._normalizeDataSource(this._dataSource)),this._addDataSourceHandlers(),this._initDataController())},_initDataController:function(){var t,e=null===(t=this.option)||void 0===t?void 0:t.call(this,"_dataController"),n=this._dataSource;this._dataController=e||new s.default(n)},_addDataSourceHandlers:function(){"_dataSourceChangedHandler"in this&&this._addDataSourceChangeHandler(),"_dataSourceLoadErrorHandler"in this&&this._addDataSourceLoadErrorHandler(),"_dataSourceLoadingChangedHandler"in this&&this._addDataSourceLoadingChangedHandler(),this._addReadyWatcher()},_addReadyWatcher:function(){this._dataSource.on("loadingChanged",function(t){this._ready&&this._ready(!t)}.bind(this))},_addDataSourceChangeHandler:function(){var t=this._dataSource;this._proxiedDataSourceChangedHandler=function(e){this._dataSourceChangedHandler(t.items(),e)}.bind(this),t.on("changed",this._proxiedDataSourceChangedHandler)},_addDataSourceLoadErrorHandler:function(){this._proxiedDataSourceLoadErrorHandler=this._dataSourceLoadErrorHandler.bind(this),this._dataSource.on("loadError",this._proxiedDataSourceLoadErrorHandler)},_addDataSourceLoadingChangedHandler:function(){this._proxiedDataSourceLoadingChangedHandler=this._dataSourceLoadingChangedHandler.bind(this),this._dataSource.on("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)},_loadDataSource:function(){var t=this._dataSource;t&&(t.isLoaded()?this._proxiedDataSourceChangedHandler&&this._proxiedDataSourceChangedHandler():t.load())},_loadSingle:function(t,e){return t="this"===t?this._dataSource.key()||"this":t,this._dataSource.loadSingle(t,e)},_isLastPage:function(){return!this._dataSource||this._dataSource.isLastPage()||!this._dataSource._pageSize},_isDataSourceLoading:function(){return this._dataSource&&this._dataSource.isLoading()},_disposeDataSource:function(){this._dataSource&&(this._isSharedDataSource?(delete this._isSharedDataSource,this._proxiedDataSourceChangedHandler&&this._dataSource.off("changed",this._proxiedDataSourceChangedHandler),this._proxiedDataSourceLoadErrorHandler&&this._dataSource.off("loadError",this._proxiedDataSourceLoadErrorHandler),this._proxiedDataSourceLoadingChangedHandler&&this._dataSource.off("loadingChanged",this._proxiedDataSourceLoadingChangedHandler)):this._dataSource.dispose(),delete this._dataSource,delete this._proxiedDataSourceChangedHandler,delete this._proxiedDataSourceLoadErrorHandler,delete this._proxiedDataSourceLoadingChangedHandler)},getDataSource:function(){return this._dataSource||null}};e.default=l,t.exports=e.default,t.exports.default=e.default},95429:function(t,e,n){e.name=void 0;var i=p(n(68374)),a=p(n(55994)),o=p(n(20530)),r=p(n(73349)),s=n(3532),l=n(90057),c=n(39611),u=n(27575),d=p(n(93786)),h=p(n(31391)),f=p(n(82495));function p(t){return t&&t.__esModule?t:{default:t}}e.name="dxclick";l.requestAnimationFrame,l.cancelAnimationFrame;var g=null,m=null,_=function(){m=null},v=function(t){var e=t.originalEvent,n=m===e||e&&e.DXCLICK_FIRED;!(!t.which||1===t.which)||g||n||(e&&(e.DXCLICK_FIRED=!0),(0,u.unsubscribeNodesDisposing)(m,_),m=e,(0,u.subscribeNodesDisposing)(m,_),(0,c.fireEvent)({type:"dxclick",originalEvent:t}))},b=h.default.inherit({ctor:function(t){this.callBase(t),a.default.on(this.getElement(),"click",v)},start:function(t){g=null},cancel:function(){g=!0},dispose:function(){a.default.off(this.getElement(),"click",v)}});!function(){if(!o.default.real().generic){var t=null,e=!1,n=r.default.getDocument();a.default.subscribeGlobal(n,(0,c.addNamespace)(d.default.down,"NATIVE_CLICK_FIXER"),(function(n){t=n.target,e=n.isDefaultPrevented()})),a.default.subscribeGlobal(n,(0,c.addNamespace)("click","NATIVE_CLICK_FIXER"),(function(n){var a,o=(0,i.default)(n.target);e||!t||o.is(t)||(0,i.default)(t).is("label")||(a=o,!(0,i.default)(a).is("input, textarea, select, button ,:focus, :focus *"))||(0,s.resetActiveElement)(),t=null,e=!1}))}}(),(0,f.default)({emitter:b,bubble:!0,events:["dxclick"]})},49166:function(t,e,n){e.name=void 0;var i=d(n(68374)),a=d(n(55994)),o=n(60137),r=d(n(20530)),s=d(n(38377)),l=d(n(85788)),c=n(39611),u=d(n(11699));function d(t){return t&&t.__esModule?t:{default:t}}var h=(0,c.addNamespace)("contextmenu","dxContexMenu"),f=(0,c.addNamespace)(u.default.name,"dxContexMenu"),p=s.default.inherit({setup:function(t){var e=(0,i.default)(t);a.default.on(e,h,this._contextMenuHandler.bind(this)),(o.touch||r.default.isSimulator())&&a.default.on(e,f,this._holdHandler.bind(this))},_holdHandler:function(t){(0,c.isMouseEvent)(t)&&!r.default.isSimulator()||this._fireContextMenu(t)},_contextMenuHandler:function(t){this._fireContextMenu(t)},_fireContextMenu:function(t){return(0,c.fireEvent)({type:"dxcontextmenu",originalEvent:t})},teardown:function(t){a.default.off(t,".dxContexMenu")}});(0,l.default)("dxcontextmenu",new p);e.name="dxcontextmenu"},91633:function(t,e,n){e.lock=e.inactive=e.active=void 0;var i=d(n(38377)),a=n(20576),o=n(3532),r=d(n(20530)),s=n(39611),l=d(n(93786)),c=d(n(31391)),u=d(n(82495));function d(t){return t&&t.__esModule?t:{default:t}}e.active="dxactive";e.inactive="dxinactive";var h,f=i.default.inherit({ctor:function(t,e){this._timeout=t,this._fire=e},start:function(){var t=this;this._schedule((function(){t.force()}))},_schedule:function(t){this.stop(),this._timer=setTimeout(t,this._timeout)},stop:function(){clearTimeout(this._timer)},force:function(){this._fired||(this.stop(),this._fire(),this._fired=!0)},fired:function(){return this._fired}}),p=c.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._active=new f(0,a.noop),this._inactive=new f(0,a.noop)},configure:function(t,e){switch(e){case"dxactive":t.activeTimeout=t.timeout;break;case"dxinactive":t.inactiveTimeout=t.timeout}this.callBase(t)},start:function(t){if(h){var e=(0,o.contains)(this.getElement().get(0),h.getElement().get(0)),n=!h._active.fired();if(e&&n)return void this._cancel();h._inactive.force()}h=this,this._initEvents(t),this._active.start()},_initEvents:function(t){var e=this,n=this._getEmitterTarget(t),i=(0,s.isMouseEvent)(t),o=r.default.isSimulator()||!i,l=(0,a.ensureDefined)(this.activeTimeout,30),c=(0,a.ensureDefined)(this.inactiveTimeout,400);this._active=new f(o?l:0,(function(){e._fireEvent("dxactive",t,{target:n})})),this._inactive=new f(o?c:0,(function(){e._fireEvent("dxinactive",t,{target:n}),h=null}))},cancel:function(t){this.end(t)},end:function(t){var e=t.type!==l.default.up;e?this._active.stop():this._active.force(),this._inactive.start(),e&&this._inactive.force()},dispose:function(){this._active.stop(),this._inactive.stop(),h===this&&(h=null),this.callBase()},lockInactive:function(){return this._active.force(),this._inactive.stop(),h=null,this._cancel(),this._inactive.force.bind(this._inactive)}});p.lock=function(t){var e=h?h.lockInactive():a.noop;t.done(e)},(0,u.default)({emitter:p,events:["dxactive","dxinactive"]});var g=p.lock;e.lock=g},31391:function(t,e,n){e.default=void 0;var i=c(n(68374)),a=n(20576),o=c(n(38377)),r=c(n(44504)),s=n(13306),l=n(39611);function c(t){return t&&t.__esModule?t:{default:t}}var u=o.default.inherit({ctor:function(t){this._$element=(0,i.default)(t),this._cancelCallback=(0,r.default)(),this._acceptCallback=(0,r.default)()},getElement:function(){return this._$element},validate:function(t){return!(0,l.isDxMouseWheelEvent)(t)},validatePointers:function(t){return 1===(0,l.hasTouches)(t)},allowInterruptionByMouseWheel:function(){return!0},configure:function(t){(0,s.extend)(this,t)},addCancelCallback:function(t){this._cancelCallback.add(t)},removeCancelCallback:function(){this._cancelCallback.empty()},_cancel:function(t){this._cancelCallback.fire(this,t)},addAcceptCallback:function(t){this._acceptCallback.add(t)},removeAcceptCallback:function(){this._acceptCallback.empty()},_accept:function(t){this._acceptCallback.fire(this,t)},_requestAccept:function(t){this._acceptRequestEvent=t},_forgetAccept:function(){this._accept(this._acceptRequestEvent),this._acceptRequestEvent=null},start:a.noop,move:a.noop,end:a.noop,cancel:a.noop,reset:function(){this._acceptRequestEvent&&this._accept(this._acceptRequestEvent)},_fireEvent:function(t,e,n){var i=(0,s.extend)({type:t,originalEvent:e,target:this._getEmitterTarget(e),delegateTarget:this.getElement().get(0)},n);return(e=(0,l.fireEvent)(i)).cancel&&this._cancel(e),e},_getEmitterTarget:function(t){return(this.delegateSelector?(0,i.default)(t.target).closest(this.delegateSelector):this.getElement()).get(0)},dispose:a.noop});e.default=u,t.exports=e.default,t.exports.default=e.default},82495:function(t,e,n){e.default=void 0;var i=g(n(68374)),a=g(n(24311)),o=g(n(73349)),r=g(n(55994)),s=n(97906),l=g(n(38377)),c=n(13306),u=n(95479),d=g(n(85788)),h=n(39611),f=g(n(93786)),p=n(765);function g(t){return t&&t.__esModule?t:{default:t}}var m=new(l.default.inherit({ctor:function(){this._attachHandlers(),this.reset(),this._proxiedCancelHandler=this._cancelHandler.bind(this),this._proxiedAcceptHandler=this._acceptHandler.bind(this)},_attachHandlers:function(){a.default.add(function(){var t=o.default.getDocument();r.default.subscribeGlobal(t,(0,h.addNamespace)(f.default.down,"dxEventManager"),this._pointerDownHandler.bind(this)),r.default.subscribeGlobal(t,(0,h.addNamespace)(f.default.move,"dxEventManager"),this._pointerMoveHandler.bind(this)),r.default.subscribeGlobal(t,(0,h.addNamespace)([f.default.up,f.default.cancel].join(" "),"dxEventManager"),this._pointerUpHandler.bind(this)),r.default.subscribeGlobal(t,(0,h.addNamespace)(p.name,"dxEventManager"),this._mouseWheelHandler.bind(this))}.bind(this))},_eachEmitter:function(t){for(var e=this._activeEmitters||[],n=0;e.length>n;){var i=e[n];if(!1===t(i))break;e[n]===i&&n++}},_applyToEmitters:function(t,e){this._eachEmitter((function(n){n[t].call(n,e)}))},reset:function(){this._eachEmitter(this._proxiedCancelHandler),this._activeEmitters=[]},resetEmitter:function(t){this._proxiedCancelHandler(t)},_pointerDownHandler:function(t){(0,h.isMouseEvent)(t)&&t.which>1||this._updateEmitters(t)},_updateEmitters:function(t){this._isSetChanged(t)&&(this._cleanEmitters(t),this._fetchEmitters(t))},_isSetChanged:function(t){var e=this._closestEmitter(t),n=this._emittersSet||[],i=e.length!==n.length;return(0,u.each)(e,(function(t,e){return!(i=i||n[t]!==e)})),this._emittersSet=e,i},_closestEmitter:function(t){var e=this,n=[],a=(0,i.default)(t.target);function o(i,a){a&&a.validatePointers(t)&&a.validate(t)&&(a.addCancelCallback(e._proxiedCancelHandler),a.addAcceptCallback(e._proxiedAcceptHandler),n.push(a))}for(;a.length;){var r=(0,s.data)(a.get(0),"dxEmitter")||[];(0,u.each)(r,o),a=a.parent()}return n},_acceptHandler:function(t,e){var n=this;this._eachEmitter((function(i){i!==t&&n._cancelEmitter(i,e)}))},_cancelHandler:function(t,e){this._cancelEmitter(t,e)},_cancelEmitter:function(t,e){var n=this._activeEmitters;e?t.cancel(e):t.reset(),t.removeCancelCallback(),t.removeAcceptCallback();var i=n.indexOf(t);i>-1&&n.splice(i,1)},_cleanEmitters:function(t){this._applyToEmitters("end",t),this.reset(t)},_fetchEmitters:function(t){this._activeEmitters=this._emittersSet.slice(),this._applyToEmitters("start",t)},_pointerMoveHandler:function(t){this._applyToEmitters("move",t)},_pointerUpHandler:function(t){this._updateEmitters(t)},_mouseWheelHandler:function(t){this._allowInterruptionByMouseWheel()&&(t.pointers=[null],this._pointerDownHandler(t),this._adjustWheelEvent(t),this._pointerMoveHandler(t),t.pointers=[],this._pointerUpHandler(t))},_allowInterruptionByMouseWheel:function(){var t=!0;return this._eachEmitter((function(e){return t=e.allowInterruptionByMouseWheel()&&t})),t},_adjustWheelEvent:function(t){var e=null;if(this._eachEmitter((function(n){if(n.gesture){var i=n.getDirection(t);return"horizontal"!==i&&!t.shiftKey||"vertical"!==i&&t.shiftKey?(e=n,!1):void 0}})),e){var n=e.getDirection(t),i="both"===n&&!t.shiftKey||"vertical"===n;t[i?"pageY":"pageX"]+=t.delta}},isActive:function(t){var e=!1;return this._eachEmitter((function(n){e=e||n.getElement().is(t)})),e}})),_=function(t){var e=t.emitter,n=t.events[0],i=t.events;(0,u.each)(i,(function(a,o){(0,d.default)(o,{noBubble:!t.bubble,setup:function(t){var i=(0,s.data)(t,"dxEmitterSubscription")||{},a=(0,s.data)(t,"dxEmitter")||{},r=a[n]||new e(t);i[o]=!0,a[n]=r,(0,s.data)(t,"dxEmitter",a),(0,s.data)(t,"dxEmitterSubscription",i)},add:function(t,e){(0,s.data)(t,"dxEmitter")[n].configure((0,c.extend)({delegateSelector:e.selector},e.data),e.type)},teardown:function(t){var e=(0,s.data)(t,"dxEmitterSubscription"),a=(0,s.data)(t,"dxEmitter"),r=a[n];delete e[o];var l=!0;(0,u.each)(i,(function(t,n){return l=l&&!e[n]})),l&&(m.isActive(t)&&m.resetEmitter(r),r&&r.dispose(),delete a[n])}})}))};e.default=_,t.exports=e.default,t.exports.default=e.default},85788:function(t,e,n){e.default=void 0;var i,a=n(95479),o=(i=n(94553))&&i.__esModule?i:{default:i};var r=function(t,e){var n={};"noBubble"in e&&(n.noBubble=e.noBubble),"bindType"in e&&(n.bindType=e.bindType),"delegateType"in e&&(n.delegateType=e.delegateType),(0,a.each)(["setup","teardown","add","remove","trigger","handle","_default","dispose"],(function(t,i){e[i]&&(n[i]=function(){var t=[].slice.call(arguments);return t.unshift(this),e[i].apply(e,t)})})),o.default.fire(t,n)};r.callbacks=o.default;var s=r;e.default=s,t.exports=e.default,t.exports.default=e.default},94553:function(t,e,n){var i;e.default=void 0;var a=new(((i=n(83358))&&i.__esModule?i:{default:i}).default);e.default=a,t.exports=e.default,t.exports.default=e.default},55994:function(t,e,n){e.default=void 0;var i=f(n(94553)),a=n(13306),o=f(n(73349)),r=n(58201),s=f(n(20476)),l=n(35922),c=f(n(44504)),u=f(n(17381)),d=f(n(2418)),h=f(n(39618));function f(t){return t&&t.__esModule?t:{default:t}}function p(t){return(p="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}function g(){return(g=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var m=(0,r.getWindow)(),_={mouseenter:"mouseover",mouseleave:"mouseout",pointerenter:"pointerover",pointerleave:"pointerout"},v={focusin:"focus",focusout:"blur"},b=["blur","focus","load"],y=["touchmove","wheel","mousewheel","touchstart"];function x(t,e){return!(0,l.isWindow)(t)&&"#document"!==t.nodeName&&o.default.elementMatches(t,e)}var w,k,S,C=new WeakMap,A=0,E=(k={},i.default.add((function(t,e){k[t]=e})),{getField:function(t,e){return k[t]&&k[t][e]},callMethod:function(t,e,n,i){return k[t]&&k[t][e]&&k[t][e].apply(n,i)}}),T=(0,s.default)({on:D(P(B((function(t,e,n,i,a){L(t,e).addHandler(a,n,i)})))),one:D(P((function(t,e,n,i,a){T.on(t,e,n,i,(function i(){T.off(t,e,n,i),a.apply(this,arguments)}))}))),off:D((S=B((function(t,e,n,i){L(t,e).removeHandler(i,n)})),function(t,e,n,i){"function"==typeof n&&(i=n,n=void 0),S(t,e,n,i)})),trigger:D(R((function(t,e,n){var i=e.type,o=L(t,e.type);if(E.callMethod(i,"trigger",t,[e,n]),o.callHandlers(e,n),!(E.getField(i,"noBubble")||e.isPropagationStopped()||-1!==b.indexOf(i))){var r=[];!function t(e){var n,i=null!==(n=e.parentNode)&&void 0!==n?n:(0,l.isObject)(e.host)?e.host:null;i&&(r.push(i),t(i))}(t),r.push(m);for(var s=0;r[s]&&!e.isPropagationStopped();){L(r[s],e.type).callHandlers((0,a.extend)(e,{currentTarget:r[s]}),n),s++}}(t.nodeType||(0,l.isWindow)(t))&&(E.callMethod(i,"_default",t,[e,n]),function(t,e){var n=v[t]||t;if(function(t,e){return"click"===t&&"a"===e.localName}(t,e))return;(0,l.isFunction)(e[n])&&(w=t,e[n](),w=void 0)}(i,t))}))),triggerHandler:D(R((function(t,e,n){L(t,e.type).callHandlers(e,n)})))});function I(t,e){var n=t[0];if(n)if(o.default.isNode(n)||(0,l.isWindow)(n))e.apply(T,t);else{if((0,l.isString)(n)||!("length"in n))throw u.default.Error("E0025");var i=Array.prototype.slice.call(t,0);Array.prototype.forEach.call(n,(function(t){i[0]=t,I(i,e)}))}}function D(t){return function(){I(arguments,t)}}var O=(0,h.default)((function(){var t=!1;try{var e=Object.defineProperty({},"passive",{get:function(){return t=!0,!0}});m.addEventListener("test",null,e)}catch(t){}return t}));function L(t,e){var n=C.get(t),i=(e=e||"").split("."),a=i.slice(1),r=!!i[0];e=i[0]||"dxEmptyEventType",n||(n={},C.set(t,n)),n[e]||(n[e]={handleObjects:[],nativeHandler:null});var s=n[e];return{addHandler:function(n,i,c){var u=function(i,a){var o,r,s=[i],u=i.currentTarget,d=i.relatedTarget;e in _&&(o=d&&u&&(d===u||function t(e,n){return(0,l.isWindow)(e)?t(e.document,n):e.contains?e.contains(n):!!(n.compareDocumentPosition(e)&n.DOCUMENT_POSITION_CONTAINS)}(u,d))),void 0!==a&&s.push(a),E.callMethod(e,"handle",t,[i,c]),o||(r=n.apply(u,s)),!1===r&&(i.preventDefault(),i.stopPropagation())},d={handler:n,wrappedHandler:function(e,n){if(!w||e.type!==w)if(e.data=c,e.delegateTarget=t,i)for(var a=e.target;a&&a!==t;)x(a,i)&&(e.currentTarget=a,u(e,n)),a=a.parentNode;else e.currentTarget=e.delegateTarget||e.target,u(e,n)},selector:i,type:e,data:c,namespace:a.join("."),namespaces:a,guid:++A};s.handleObjects.push(d);var h,f,p=1===s.handleObjects.length&&r;p&&(p=!E.callMethod(e,"setup",t,[c,a,n])),p&&(s.nativeHandler=(f=e,function(t,e){var n=L(this,f);t=T.Event(t),n.callHandlers(t,e)}),O()&&y.indexOf(e)>-1&&(h={passive:!1}),s.removeListener=o.default.listen(t,_[e]||e,s.nativeHandler,h)),E.callMethod(e,"add",t,[d])},removeHandler:function(i,o){var s=function(e){var r,s=n[e];s.handleObjects.length?(s.handleObjects=s.handleObjects.filter((function(n){var s=a.length&&!M(n.namespaces,a)||i&&n.handler!==i||o&&n.selector!==o;return s||(r=n.handler,E.callMethod(e,"remove",t,[n])),s})),!s.handleObjects.length&&"dxEmptyEventType"!==e&&(E.callMethod(e,"teardown",t,[a,r]),s.nativeHandler&&s.removeListener(),delete n[e])):delete n[e]};if(r)s(e);else for(var l in n)s(l);0===Object.keys(n).length&&C.delete(t)},callHandlers:function(t,e){var i=!1,o=function(n){i||a.length&&!M(n.namespaces,a)||(n.wrappedHandler(t,e),i=t.isImmediatePropagationStopped())};s.handleObjects.forEach(o),a.length&&n.dxEmptyEventType&&n.dxEmptyEventType.handleObjects.forEach(o)}}}function M(t,e){for(var n=0;n<e.length;n++)if(t.indexOf(e[n])<0)return!1;return!0}function P(t){return function(e,n,i,a,o){o||(o=a,a=void 0),"string"!=typeof i&&(a=i,i=void 0),o||"string"!=typeof n||(o=a||i,i=void 0,a=void 0),t(e,n,i,a,o)}}function R(t){return function(e,n,i){"string"==typeof n&&(n={type:n}),n.target||(n.target=e),n.currentTarget=e,n.delegateTarget||(n.delegateTarget=e),!n.type&&n.originalEvent&&(n.type=n.originalEvent.type),t(e,n instanceof T.Event?n:T.Event(n),i)}}function B(t){var e=function(e,n){if(n&&n.indexOf(" ")>-1){var i=Array.prototype.slice.call(arguments,0);n.split(" ").forEach((function(e){i[1]=e,t.apply(this,i)}))}else t.apply(this,arguments)};return function(t,n){if("object"===p(n)){var i=Array.prototype.slice.call(arguments,0);for(var a in n)i[1]=a,i[i.length-1]=n[a],e.apply(this,i)}else e.apply(this,arguments)}}function z(t){if(function(t){return null==t.which&&0===t.type.indexOf("key")}(t))return null!=t.charCode?t.charCode:t.keyCode;if(function(t){return!t.which&&void 0!==t.button&&/^(?:mouse|pointer|contextmenu|drag|drop)|click/.test(t.type)}(t)){return{1:1,2:3,3:1,4:2}[t.button]}return t.which}function q(t){t&&(T.Event=t,T.Event.prototype=t.prototype)}function V(t,e,n){Object.defineProperty(n||T.Event.prototype,t,{enumerable:!0,configurable:!0,get:function(){return this.originalEvent&&e(this.originalEvent)},set:function(e){Object.defineProperty(this,t,{enumerable:!0,configurable:!0,writable:!0,value:e})}})}q(function(t){return T.Event=function(e,n){if(!(this instanceof T.Event))return new T.Event(e,n);e||(e={}),"string"==typeof e&&(e={type:e}),n||(n={}),t.call(this,e,n)},g(T.Event.prototype,{_propagationStopped:!1,_immediatePropagationStopped:!1,_defaultPrevented:!1,isPropagationStopped:function(){return!!(this._propagationStopped||this.originalEvent&&this.originalEvent.propagationStopped)},stopPropagation:function(){this._propagationStopped=!0,this.originalEvent&&this.originalEvent.stopPropagation()},isImmediatePropagationStopped:function(){return this._immediatePropagationStopped},stopImmediatePropagation:function(){this.stopPropagation(),this._immediatePropagationStopped=!0,this.originalEvent&&this.originalEvent.stopImmediatePropagation()},isDefaultPrevented:function(){return!!(this._defaultPrevented||this.originalEvent&&this.originalEvent.defaultPrevented)},preventDefault:function(){this._defaultPrevented=!0,this.originalEvent&&this.originalEvent.preventDefault()}}),T.Event}((function(t,e){var n;t instanceof T.Event||(0,r.hasWindow)()&&t instanceof m.Event||(null===(n=t.view)||void 0===n?void 0:n.Event)&&t instanceof t.view.Event?(this.originalEvent=t,this.type=t.type,this.currentTarget=void 0,Object.prototype.hasOwnProperty.call(t,"isTrusted")&&(this.isTrusted=t.isTrusted),this.timeStamp=t.timeStamp||Date.now()):g(this,t),V("which",z,this),0===t.type.indexOf("touch")&&(delete e.pageX,delete e.pageY),g(this,e),this.guid=++A}))),["target","relatedTarget","delegateTarget","altKey","bubbles","cancelable","changedTouches","ctrlKey","detail","eventPhase","metaKey","shiftKey","view","char","code","charCode","key","keyCode","button","buttons","offsetX","offsetY","pointerId","pointerType","targetTouches","toElement","touches"].forEach((function(t){return V(t,(function(e){return e[t]}))})),(0,d.default)(V);var F=(0,c.default)(),H=(0,c.default)();T.set=function(t){F.fire(),T.inject(t),q(t.Event),H.fire()},T.subscribeGlobal=function(){I(arguments,P((function(){var t=arguments;T.on.apply(this,t),F.add((function(){var e=Array.prototype.slice.call(t,0);e.splice(3,1),T.off.apply(this,e)})),H.add((function(){T.on.apply(this,t)}))})))},T.forcePassiveFalseEventNames=y,T.passiveEventHandlersSupported=O;var N=T;e.default=N,t.exports=e.default,t.exports.default=e.default},2418:function(t,e){e.default=function(t){n.forEach((function(e){t(e,(function(t){return function(t,e){if(e[t]&&!e.touches||!e.touches)return e[t];var n=e.touches.length?e.touches:e.changedTouches;if(!n.length)return;return n[0][t]}(e,t)}))}),this)};var n=["pageX","pageY","screenX","screenY","clientX","clientY"];t.exports=e.default,t.exports.default=e.default},51661:function(t,e,n){e.default=void 0;var i=s(n(68374)),a=s(n(55994)),o=s(n(38377)),r=n(39611);function s(t){return t&&t.__esModule?t:{default:t}}var l=function(t){return{keyName:(0,r.normalizeKeyName)(t),key:t.key,code:t.code,ctrl:t.ctrlKey,location:t.location,metaKey:t.metaKey,shift:t.shiftKey,alt:t.altKey,which:t.which,originalEvent:t}},c=o.default.inherit({_keydown:(0,r.addNamespace)("keydown","KeyboardProcessor"),_compositionStart:(0,r.addNamespace)("compositionstart","KeyboardProcessor"),_compositionEnd:(0,r.addNamespace)("compositionend","KeyboardProcessor"),ctor:function(t){var e=this;(t=t||{}).element&&(this._element=(0,i.default)(t.element)),t.focusTarget&&(this._focusTarget=t.focusTarget),this._handler=t.handler,this._element&&(this._processFunction=function(t){var n=(0,i.default)(e._focusTarget).toArray(),a=e._focusTarget&&e._focusTarget!==t.target&&!n.includes(t.target),o=e._isComposingJustFinished&&229===t.which||e._isComposing||a;e._isComposingJustFinished=!1,o||e.process(t)},this._toggleProcessingWithContext=this.toggleProcessing.bind(this),a.default.on(this._element,this._keydown,this._processFunction),a.default.on(this._element,this._compositionStart,this._toggleProcessingWithContext),a.default.on(this._element,this._compositionEnd,this._toggleProcessingWithContext))},dispose:function(){this._element&&(a.default.off(this._element,this._keydown,this._processFunction),a.default.off(this._element,this._compositionStart,this._toggleProcessingWithContext),a.default.off(this._element,this._compositionEnd,this._toggleProcessingWithContext)),this._element=void 0,this._handler=void 0},process:function(t){this._handler(l(t))},toggleProcessing:function(t){var e=t.type;this._isComposing="compositionstart"===e,this._isComposingJustFinished=!this._isComposing}});c.createKeyDownOptions=l;var u=c;e.default=u,t.exports=e.default,t.exports.default=e.default},765:function(t,e,n){e.name=void 0;var i=s(n(68374)),a=s(n(55994)),o=s(n(85788)),r=n(39611);function s(t){return t&&t.__esModule?t:{default:t}}e.name="dxmousewheel";var l={setup:function(t){var e=(0,i.default)(t);a.default.on(e,(0,r.addNamespace)("wheel","dxWheel"),l._wheelHandler.bind(l))},teardown:function(t){a.default.off(t,".".concat("dxWheel"))},_wheelHandler:function(t){var e=t.originalEvent,n=e.deltaMode,i=e.deltaY,a=e.deltaX,o=e.deltaZ;(0,r.fireEvent)({type:"dxmousewheel",originalEvent:t,delta:this._normalizeDelta(i,n),deltaX:a,deltaY:i,deltaZ:o,deltaMode:n,pointerType:"mouse"}),t.stopPropagation()},_normalizeDelta:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:0;return 0===e?-t:-30*t}};(0,o.default)("dxmousewheel",l)},85272:function(t,e,n){e.name=void 0;var i=u(n(55994)),a=n(3532),o=u(n(73349)),r=u(n(38377)),s=u(n(85788)),l=n(95429),c=n(39611);function u(t){return t&&t.__esModule?t:{default:t}}e.name="dxdblclick";var d=(0,c.addNamespace)(l.name,"dxDblClick"),h=r.default.inherit({ctor:function(){this._handlerCount=0,this._forgetLastClick()},_forgetLastClick:function(){this._firstClickTarget=null,this._lastClickTimeStamp=-300},add:function(){this._handlerCount<=0&&i.default.on(o.default.getDocument(),d,this._clickHandler.bind(this)),this._handlerCount++},_clickHandler:function(t){var e=t.timeStamp||Date.now(),n=e-this._lastClickTimeStamp;!(n<0)&&n<300?((0,c.fireEvent)({type:"dxdblclick",target:(0,a.closestCommonParent)(this._firstClickTarget,t.target),originalEvent:t}),this._forgetLastClick()):(this._firstClickTarget=t.target,this._lastClickTimeStamp=e)},remove:function(){this._handlerCount--,this._handlerCount<=0&&(this._forgetLastClick(),i.default.off(o.default.getDocument(),d))}});(0,s.default)("dxdblclick",new h)},23174:function(t,e,n){function i(t){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}e.start=e.move=e.leave=e.enter=e.end=e.drop=void 0;var a=p(n(68374)),o=n(97906),r=n(89386),s=function(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==i(t)&&"function"!=typeof t)return{default:t};var n=f(e);if(n&&n.has(t))return n.get(t);var a={},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in t)if("default"!==r&&Object.prototype.hasOwnProperty.call(t,r)){var s=o?Object.getOwnPropertyDescriptor(t,r):null;s&&(s.get||s.set)?Object.defineProperty(a,r,s):a[r]=t[r]}a.default=t,n&&n.set(t,a);return a}(n(95479)),l=n(3532),c=p(n(85788)),u=n(39611),d=p(n(98621)),h=p(n(82495));function f(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return(f=function(t){return t?n:e})(t)}function p(t){return t&&t.__esModule?t:{default:t}}e.start="dxdragstart";e.move="dxdrag";e.end="dxdragend";var g="dxdragenter";e.enter=g;var m="dxdragleave";e.leave=m;var _="dxdrop";e.drop=_;var v=[],b=[],y=[],x={setup:function(t,e){v.includes(t)||(v.push(t),b.push([]),y.push(e||{}))},add:function(t,e){var n=v.indexOf(t);this.updateEventsCounter(t,e.type,1);var i=e.selector;b[n].includes(i)||b[n].push(i)},updateEventsCounter:function(t,e,n){if([g,m,_].indexOf(e)>-1){var i=(0,o.data)(t,"dxDragEventsCount")||0;(0,o.data)(t,"dxDragEventsCount",Math.max(0,i+n))}},remove:function(t,e){this.updateEventsCounter(t,e.type,-1)},teardown:function(t){if(!(0,o.data)(t,"dxDragEventsCount")){var e=v.indexOf(t);v.splice(e,1),b.splice(e,1),y.splice(e,1),(0,o.removeData)(t,"dxDragEventsCount")}}};(0,c.default)(g,x),(0,c.default)(m,x),(0,c.default)(_,x);var w=d.default.inherit({ctor:function(t){this.callBase(t),this.direction="both"},_init:function(t){this._initEvent=t},_start:function(t){if(t=this._fireEvent("dxdragstart",this._initEvent),this._maxLeftOffset=t.maxLeftOffset,this._maxRightOffset=t.maxRightOffset,this._maxTopOffset=t.maxTopOffset,this._maxBottomOffset=t.maxBottomOffset,t.targetElements||null===t.targetElements){var e=(0,r.wrapToArray)(t.targetElements||[]);this._dropTargets=s.map(e,(function(t){return(0,a.default)(t).get(0)}))}else this._dropTargets=v},_move:function(t){var e=(0,u.eventData)(t),n=this._calculateOffset(e);t=this._fireEvent("dxdrag",t,{offset:n}),this._processDropTargets(t),t._cancelPreventDefault||t.preventDefault()},_calculateOffset:function(t){return{x:this._calculateXOffset(t),y:this._calculateYOffset(t)}},_calculateXOffset:function(t){if("vertical"!==this.direction){var e=t.x-this._startEventData.x;return this._fitOffset(e,this._maxLeftOffset,this._maxRightOffset)}return 0},_calculateYOffset:function(t){if("horizontal"!==this.direction){var e=t.y-this._startEventData.y;return this._fitOffset(e,this._maxTopOffset,this._maxBottomOffset)}return 0},_fitOffset:function(t,e,n){return null!=e&&(t=Math.max(t,-e)),null!=n&&(t=Math.min(t,n)),t},_processDropTargets:function(t){var e=this._findDropTarget(t);e===this._currentDropTarget||(this._fireDropTargetEvent(t,m),this._currentDropTarget=e,this._fireDropTargetEvent(t,g))},_fireDropTargetEvent:function(t,e){if(this._currentDropTarget){var n={type:e,originalEvent:t,draggingElement:this._$element.get(0),target:this._currentDropTarget};(0,u.fireEvent)(n)}},_findDropTarget:function(t){var e,n=this;return s.each(v,(function(i,o){if(n._checkDropTargetActive(o)){var r,l,c,u,d=(0,a.default)(o);s.each((r=d,l=v.indexOf(r.get(0)),c=b[l].filter((function(t){return t})),u=r.find(c.join(", ")),b[l].includes(void 0)&&(u=u.add(r)),u),(function(i,o){var r=(0,a.default)(o);n._checkDropTarget(function(t){var e=v.indexOf(t.get(0));return y[e]}(d),r,(0,a.default)(e),t)&&(e=o)}))}})),e},_checkDropTargetActive:function(t){var e=!1;return s.each(this._dropTargets,(function(n,i){return!(e=e||i===t||(0,l.contains)(i,t))})),e},_checkDropTarget:function(t,e,n,i){if(e.get(0)===(0,a.default)(i.target).get(0))return!1;var o,r,s=(r=e,(o=t).itemPositionFunc?o.itemPositionFunc(r):r.offset());if(i.pageX<s.left)return!1;if(i.pageY<s.top)return!1;var l=function(t,e){return t.itemSizeFunc?t.itemSizeFunc(e):{width:e.get(0).getBoundingClientRect().width,height:e.get(0).getBoundingClientRect().height}}(t,e);return!(i.pageX>s.left+l.width)&&(!(i.pageY>s.top+l.height)&&((!n.length||!n.closest(e).length)&&(!(t.checkDropTarget&&!t.checkDropTarget(e,i))&&e)))},_end:function(t){var e=(0,u.eventData)(t);this._fireEvent("dxdragend",t,{offset:this._calculateOffset(e)}),this._fireDropTargetEvent(t,_),delete this._currentDropTarget}});(0,h.default)({emitter:w,events:["dxdragstart","dxdrag","dxdragend"]})},98621:function(t,e,n){e.default=void 0;var i=g(n(68374)),a=g(n(55994)),o=g(n(20530)),r=n(80968),s=g(n(39618)),l=n(3532),c=g(n(24311)),u=n(60810),d=n(20576),h=n(35922),f=n(39611),p=g(n(31391));function g(t){return t&&t.__esModule?t:{default:t}}var m=c.default.add,_=Math.abs,v=10,b=(0,s.default)((function(){var t="desktop"===o.default.real().deviceType;if(!(0,r.styleProp)("pointer-events")||!t)return d.noop;var e=(0,i.default)("<div>").addClass("dx-gesture-cover").css("pointerEvents","none");return a.default.subscribeGlobal(e,"dxmousewheel",(function(t){t.preventDefault()})),m((function(){e.appendTo("body")})),function(t,n){e.css("pointerEvents",t?"all":"none"),t&&e.css("cursor",n)}})),y=p.default.inherit({gesture:!0,configure:function(t){this.getElement().css("msTouchAction",t.immediate?"pinch-zoom":""),this.callBase(t)},allowInterruptionByMouseWheel:function(){return 2!==this._stage},getDirection:function(){return this.direction},_cancel:function(){this.callBase.apply(this,arguments),this._toggleGestureCover(!1),this._stage=0},start:function(t){t._needSkipEvent||(0,f.needSkipEvent)(t)?this._cancel(t):(this._startEvent=(0,f.createEvent)(t),this._startEventData=(0,f.eventData)(t),this._stage=1,this._init(t),this._setupImmediateTimer())},_setupImmediateTimer:function(){var t;clearTimeout(this._immediateTimer),this._immediateAccepted=!1,this.immediate&&(0!==this.immediateTimeout?this._immediateTimer=setTimeout(function(){this._immediateAccepted=!0}.bind(this),null!==(t=this.immediateTimeout)&&void 0!==t?t:180):this._immediateAccepted=!0)},move:function(t){if(1===this._stage&&this._directionConfirmed(t)){if(this._stage=2,this._resetActiveElement(),this._toggleGestureCover(!0),this._clearSelection(t),this._adjustStartEvent(t),this._start(this._startEvent),0===this._stage)return;this._requestAccept(t),this._move(t),this._forgetAccept()}else 2===this._stage&&(this._clearSelection(t),this._move(t))},_directionConfirmed:function(t){var e=this._getTouchBoundary(t),n=(0,f.eventDelta)(this._startEventData,(0,f.eventData)(t)),i=_(n.x),a=_(n.y),o=this._validateMove(e,i,a),r=this._validateMove(e,a,i),s=this.getDirection(t);return"both"===s&&(o||r)||"horizontal"===s&&o||"vertical"===s&&r||this._immediateAccepted},_validateMove:function(t,e,n){return e&&e>=t&&(!this.immediate||e>=n)},_getTouchBoundary:function(t){return this.immediate||(0,f.isDxMouseWheelEvent)(t)?0:v},_adjustStartEvent:function(t){var e=this._getTouchBoundary(t),n=(0,f.eventDelta)(this._startEventData,(0,f.eventData)(t));this._startEvent.pageX+=(0,u.sign)(n.x)*e,this._startEvent.pageY+=(0,u.sign)(n.y)*e},_resetActiveElement:function(){"ios"===o.default.real().platform&&this.getElement().find(":focus").length&&(0,l.resetActiveElement)()},_toggleGestureCover:function(t){this._toggleGestureCoverImpl(t)},_toggleGestureCoverImpl:function(t){2===this._stage&&function(t,e){b()(t,e)}(t,this.getElement().css("cursor"))},_clearSelection:function(t){(0,f.isDxMouseWheelEvent)(t)||(0,f.isTouchEvent)(t)||(0,l.clearSelection)()},end:function(t){this._toggleGestureCover(!1),2===this._stage?this._end(t):1===this._stage&&this._stop(t),this._stage=0},dispose:function(){clearTimeout(this._immediateTimer),this.callBase.apply(this,arguments),this._toggleGestureCover(!1)},_init:d.noop,_start:d.noop,_move:d.noop,_stop:d.noop,_end:d.noop});y.initialTouchBoundary=v,y.touchBoundary=function(t){if(!(0,h.isDefined)(t))return v;v=t};var x=y;e.default=x,t.exports=e.default,t.exports.default=e.default},37334:function(t,e,n){e.default=void 0;var i=u(n(55994)),a=u(n(38377)),o=n(39611),r=u(n(98621)),s=u(n(82495)),l=n(90057),c=u(n(20530));function u(t){return t&&t.__esModule?t:{default:t}}var d,h,f,p=a.default.abstract,g=c.default.real(),m=a.default.inherit((d=(0,o.addNamespace)("scroll","dxScrollEmitter"),{ctor:function(t){var e=this;this._element=t,this._locked=!1,this._proxiedScroll=function(t){e._disposed||e._scroll(t)},i.default.on(this._element,d,this._proxiedScroll)},_scroll:p,check:function(t,e){this._locked&&e()},dispose:function(){this._disposed=!0,i.default.off(this._element,d,this._proxiedScroll)}})),_=m.inherit({ctor:function(t,e){this.callBase(t),this._timeout=e},_scroll:function(){this._prepare(),this._forget()},_prepare:function(){this._timer&&this._clearTimer(),this._locked=!0},_clearTimer:function(){clearTimeout(this._timer),this._locked=!1,this._timer=null},_forget:function(){var t=this;this._timer=setTimeout((function(){t._clearTimer()}),this._timeout)},dispose:function(){this.callBase(),this._clearTimer()}}),v=_.inherit({ctor:function(t){this.callBase(t,400),this._lastWheelDirection=null},check:function(t,e){this._checkDirectionChanged(t),this.callBase(t,e)},_checkDirectionChanged:function(t){if((0,o.isDxMouseWheelEvent)(t)){var e=t.shiftKey||!1,n=null!==this._lastWheelDirection&&e!==this._lastWheelDirection;this._lastWheelDirection=e,this._locked=this._locked&&!n}else this._lastWheelDirection=null}}),b=_.inherit({ctor:function(t){this.callBase(t,400)}});h=g.ios,f=g.android,(h||f)&&(b=m.inherit({_scroll:function(){this._locked=!0;var t=this;(0,l.cancelAnimationFrame)(this._scrollFrame),this._scrollFrame=(0,l.requestAnimationFrame)((function(){t._locked=!1}))},check:function(t,e){(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame);var n=this,i=this.callBase;this._checkFrame=(0,l.requestAnimationFrame)((function(){i.call(n,t,e),n._locked=!1}))},dispose:function(){this.callBase(),(0,l.cancelAnimationFrame)(this._scrollFrame),(0,l.cancelAnimationFrame)(this._checkFrame)}}));var y,x=r.default.inherit((y=Math.round(1e3/60),{ctor:function(t){this.callBase.apply(this,arguments),this.direction="both",this._pointerLocker=new b(t),this._wheelLocker=new v(t)},validate:function(){return!0},configure:function(t){t.scrollTarget&&(this._pointerLocker.dispose(),this._wheelLocker.dispose(),this._pointerLocker=new b(t.scrollTarget),this._wheelLocker=new v(t.scrollTarget)),this.callBase(t)},_init:function(t){this._wheelLocker.check(t,function(){(0,o.isDxMouseWheelEvent)(t)&&this._accept(t)}.bind(this)),this._pointerLocker.check(t,function(){var e=this.isNative&&(0,o.isMouseEvent)(t);(0,o.isDxMouseWheelEvent)(t)||e||this._accept(t)}.bind(this)),this._fireEvent("dxscrollinit",t),this._prevEventData=(0,o.eventData)(t)},move:function(t){this.callBase.apply(this,arguments),t.isScrollingEvent=this.isNative||t.isScrollingEvent},_start:function(t){this._savedEventData=(0,o.eventData)(t),this._fireEvent("dxscrollstart",t),this._prevEventData=(0,o.eventData)(t)},_move:function(t){var e=(0,o.eventData)(t);this._fireEvent("dxscroll",t,{delta:(0,o.eventDelta)(this._prevEventData,e)}),(0,o.eventDelta)(this._savedEventData,e).time>200&&(this._savedEventData=this._prevEventData),this._prevEventData=(0,o.eventData)(t)},_end:function(t){var e=(0,o.eventDelta)(this._prevEventData,(0,o.eventData)(t)),n={x:0,y:0};if(!(0,o.isDxMouseWheelEvent)(t)&&e.time<100){var i=(0,o.eventDelta)(this._savedEventData,this._prevEventData),a=y/i.time;n={x:i.x*a,y:i.y*a}}this._fireEvent("dxscrollend",t,{velocity:n})},_stop:function(t){this._fireEvent("dxscrollstop",t)},cancel:function(t){this.callBase.apply(this,arguments),this._fireEvent("dxscrollcancel",t)},dispose:function(){this.callBase.apply(this,arguments),this._pointerLocker.dispose(),this._wheelLocker.dispose()},_clearSelection:function(){if(!this.isNative)return this.callBase.apply(this,arguments)},_toggleGestureCover:function(){if(!this.isNative)return this.callBase.apply(this,arguments)}}));(0,s.default)({emitter:x,events:["dxscrollinit","dxscrollstart","dxscroll","dxscrollend","dxscrollstop","dxscrollcancel"]});var w={init:"dxscrollinit",start:"dxscrollstart",move:"dxscroll",end:"dxscrollend",stop:"dxscrollstop",cancel:"dxscrollcancel",scroll:"scroll"};e.default=w,t.exports=e.default,t.exports.default=e.default},11699:function(t,e,n){e.default=void 0;var i=n(39611),a=r(n(31391)),o=r(n(82495));function r(t){return t&&t.__esModule?t:{default:t}}var s=Math.abs,l=a.default.inherit({start:function(t){this._startEventData=(0,i.eventData)(t),this._startTimer(t)},_startTimer:function(t){var e="timeout"in this?this.timeout:750;this._holdTimer=setTimeout(function(){this._requestAccept(t),this._fireEvent("dxhold",t,{target:t.target}),this._forgetAccept()}.bind(this),e)},move:function(t){this._touchWasMoved(t)&&this._cancel(t)},_touchWasMoved:function(t){var e=(0,i.eventDelta)(this._startEventData,(0,i.eventData)(t));return s(e.x)>5||s(e.y)>5},end:function(){this._stopTimer()},_stopTimer:function(){clearTimeout(this._holdTimer)},cancel:function(){this._stopTimer()},dispose:function(){this._stopTimer()}});(0,o.default)({emitter:l,bubble:!0,events:["dxhold"]});var c={name:"dxhold"};e.default=c,t.exports=e.default,t.exports.default=e.default},24028:function(t,e,n){e.start=e.end=void 0;var i=u(n(55994)),a=n(97906),o=u(n(38377)),r=u(n(20530)),s=u(n(85788)),l=n(39611),c=u(n(93786));function u(t){return t&&t.__esModule?t:{default:t}}e.start="dxhoverstart";var d=(0,l.addNamespace)(c.default.enter,"dxHoverStart");e.end="dxhoverend";var h=(0,l.addNamespace)(c.default.leave,"dxHoverEnd"),f=o.default.inherit({noBubble:!0,ctor:function(){this._handlerArrayKeyPath=this._eventNamespace+"_HandlerStore"},setup:function(t){(0,a.data)(t,this._handlerArrayKeyPath,{})},add:function(t,e){var n=this,o=function(t){n._handler(t)};i.default.on(t,this._originalEventName,e.selector,o),(0,a.data)(t,this._handlerArrayKeyPath)[e.guid]=o},_handler:function(t){(0,l.isTouchEvent)(t)||r.default.isSimulator()||(0,l.fireEvent)({type:this._eventName,originalEvent:t,delegateTarget:t.delegateTarget})},remove:function(t,e){var n=(0,a.data)(t,this._handlerArrayKeyPath)[e.guid];i.default.off(t,this._originalEventName,e.selector,n)},teardown:function(t){(0,a.removeData)(t,this._handlerArrayKeyPath)}}),p=f.inherit({ctor:function(){this._eventNamespace="dxHoverStart",this._eventName="dxhoverstart",this._originalEventName=d,this.callBase()},_handler:function(t){(t.pointers||[]).length||this.callBase(t)}}),g=f.inherit({ctor:function(){this._eventNamespace="dxHoverEnd",this._eventName="dxhoverend",this._originalEventName=h,this.callBase()}});(0,s.default)("dxhoverstart",new p),(0,s.default)("dxhoverend",new g)},66365:function(t,e,n){e.triggerHandler=e.trigger=e.one=e.on=e.off=e.Event=void 0;var i,a=(i=n(55994))&&i.__esModule?i:{default:i};var o=a.default.on;e.on=o;var r=a.default.one;e.one=r;var s=a.default.off;e.off=s;var l=a.default.trigger;e.trigger=l;var c=a.default.triggerHandler;e.triggerHandler=c;var u=a.default.Event;e.Event=u},93786:function(t,e,n){function i(t){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}e.default=void 0;var a=function(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==i(t)&&"function"!=typeof t)return{default:t};var n=h(e);if(n&&n.has(t))return n.get(t);var a={},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in t)if("default"!==r&&Object.prototype.hasOwnProperty.call(t,r)){var s=o?Object.getOwnPropertyDescriptor(t,r):null;s&&(s.get||s.set)?Object.defineProperty(a,r,s):a[r]=t[r]}a.default=t,n&&n.set(t,a);return a}(n(60137)),o=n(95479),r=d(n(20530)),s=d(n(85788)),l=d(n(69120)),c=d(n(66509)),u=d(n(87720));function d(t){return t&&t.__esModule?t:{default:t}}function h(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return(h=function(t){return t?n:e})(t)}var f=function(t,e){var n=e.tablet,i=e.phone;return!t.touch||n||i?t.touch?l.default:c.default:u.default}(a,r.default.real());(0,o.each)(f.map,(function(t,e){(0,s.default)(t,new f(t,e))}));var p={down:"dxpointerdown",up:"dxpointerup",move:"dxpointermove",cancel:"dxpointercancel",enter:"dxpointerenter",leave:"dxpointerleave",over:"dxpointerover",out:"dxpointerout"};e.default=p,t.exports=e.default,t.exports.default=e.default},88136:function(t,e,n){e.default=void 0;var i=l(n(55994)),a=l(n(47810)),o=l(n(73349)),r=l(n(38377)),s=n(39611);function l(t){return t&&t.__esModule?t:{default:t}}var c=r.default.inherit({ctor:function(t,e){this._eventName=t,this._originalEvents=(0,s.addNamespace)(e,"dxPointerEvents"),this._handlerCount=0,this.noBubble=this._isNoBubble()},_isNoBubble:function(){var t=this._eventName;return"dxpointerenter"===t||"dxpointerleave"===t},_handler:function(t){var e,n=this._getDelegateTarget(t),i={type:this._eventName,pointerType:t.pointerType||(0,s.eventSource)(t),originalEvent:t,delegateTarget:n,timeStamp:a.default.mozilla?(new Date).getTime():t.timeStamp},o=t.originalEvent;if(null!=o&&null!==(e=o.target)&&void 0!==e&&e.shadowRoot){var r,l,c=null!==(r=o.path)&&void 0!==r?r:null===(l=o.composedPath)||void 0===l?void 0:l.call(o);i.target=c[0]}return this._fireEvent(i)},_getDelegateTarget:function(t){var e;return this.noBubble&&(e=t.delegateTarget),e},_fireEvent:function(t){return(0,s.fireEvent)(t)},_setSelector:function(t){this._selector=this.noBubble&&t?t.selector:null},_getSelector:function(){return this._selector},setup:function(){return!0},add:function(t,e){if(this._handlerCount<=0||this.noBubble){t=this.noBubble?t:o.default.getDocument(),this._setSelector(e);var n=this;i.default.on(t,this._originalEvents,this._getSelector(),(function(t){n._handler(t)}))}this.noBubble||this._handlerCount++},remove:function(t){this._setSelector(t),this.noBubble||this._handlerCount--},teardown:function(t){this._handlerCount&&!this.noBubble||(t=this.noBubble?t:o.default.getDocument(),".dxPointerEvents"!==this._originalEvents&&i.default.off(t,this._originalEvents,this._getSelector()))},dispose:function(t){t=this.noBubble?t:o.default.getDocument(),i.default.off(t,this._originalEvents)}});e.default=c,t.exports=e.default,t.exports.default=e.default},66509:function(t,e,n){e.default=void 0;var i=n(13306),a=r(n(88136)),o=r(n(25544));function r(t){return t&&t.__esModule?t:{default:t}}var s,l={dxpointerdown:"mousedown",dxpointermove:"mousemove",dxpointerup:"mouseup",dxpointercancel:"",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},c=function(t){return t.pointerId=1,{pointers:s.pointers(),pointerId:1}},u=!1,d=function(){u||(s=new o.default(l,(function(){return!0})),u=!0)},h=a.default.inherit({ctor:function(){this.callBase.apply(this,arguments),d()},_fireEvent:function(t){return this.callBase((0,i.extend)(c(t.originalEvent),t))}});h.map=l,h.normalize=c,h.activate=d,h.resetObserver=function(){s.reset()};var f=h;e.default=f,t.exports=e.default,t.exports.default=e.default},87720:function(t,e,n){e.default=void 0;var i=n(13306),a=l(n(88136)),o=l(n(66509)),r=l(n(69120)),s=n(39611);function l(t){return t&&t.__esModule?t:{default:t}}var c=!1,u=function(){c||(o.default.activate(),c=!0)},d=a.default.inherit({EVENT_LOCK_TIMEOUT:100,ctor:function(){this.callBase.apply(this,arguments),u()},_handler:function(t){var e=(0,s.isMouseEvent)(t);if(e||(this._skipNextEvents=!0),!e||!this._mouseLocked){if(!e||!this._skipNextEvents)return this.callBase(t);this._skipNextEvents=!1,this._mouseLocked=!0,clearTimeout(this._unlockMouseTimer);var n=this;this._unlockMouseTimer=setTimeout((function(){n._mouseLocked=!1}),this.EVENT_LOCK_TIMEOUT)}},_fireEvent:function(t){var e=(0,s.isMouseEvent)(t.originalEvent)?o.default.normalize:r.default.normalize;return this.callBase((0,i.extend)(e(t.originalEvent),t))},dispose:function(){this.callBase(),this._skipNextEvents=!1,this._mouseLocked=!1,clearTimeout(this._unlockMouseTimer)}});d.map={dxpointerdown:"touchstart mousedown",dxpointermove:"touchmove mousemove",dxpointerup:"touchend mouseup",dxpointercancel:"touchcancel",dxpointerover:"mouseover",dxpointerout:"mouseout",dxpointerenter:"mouseenter",dxpointerleave:"mouseleave"},d.resetObserver=o.default.resetObserver;var h=d;e.default=h,t.exports=e.default,t.exports.default=e.default},25544:function(t,e,n){e.default=void 0;var i=n(95479),a=r(n(24311)),o=r(n(73349));function r(t){return t&&t.__esModule?t:{default:t}}var s=function(t,e){a.default.add((function(){t.split(" ").forEach((function(t){o.default.listen(o.default.getDocument(),t,e,!0)}))}))},l=function(t,e,n){n=n||function(){};var a=[],o=function(t){var n=-1;return(0,i.each)(a,(function(i,a){return!e(t,a)||(n=i,!1)})),n},r=function(t){var e=o(t);e>-1&&a.splice(e,1)};s(t.dxpointerdown,(function(t){-1===o(t)&&(n(t),a.push(t))})),s(t.dxpointermove,(function(t){a[o(t)]=t})),s(t.dxpointerup,r),s(t.dxpointercancel,r),this.pointers=function(){return a},this.reset=function(){a=[]}};e.default=l,t.exports=e.default,t.exports.default=e.default},69120:function(t,e,n){e.default=void 0;var i=s(n(20530)),a=n(13306),o=n(95479),r=s(n(88136));function s(t){return t&&t.__esModule?t:{default:t}}var l=function(t){var e=[];return(0,o.each)(t.touches,(function(t,n){e.push((0,a.extend)({pointerId:n.identifier},n))})),{pointers:e,pointerId:t.changedTouches[0].identifier}},c=function(t){return"ios"===i.default.real().platform&&("dxpointerdown"===t||"dxpointerup"===t)},u=r.default.inherit({ctor:function(){this.callBase.apply(this,arguments),this._pointerId=0},_handler:function(t){if(c(this._eventName)){var e=t.changedTouches[0];if(this._pointerId===e.identifier&&0!==this._pointerId)return;this._pointerId=e.identifier}return this.callBase.apply(this,arguments)},_fireEvent:function(t){return this.callBase((0,a.extend)(l(t.originalEvent),t))}});u.map={dxpointerdown:"touchstart",dxpointermove:"touchmove",dxpointerup:"touchend",dxpointercancel:"touchcancel",dxpointerover:"",dxpointerout:"",dxpointerenter:"",dxpointerleave:""},u.normalize=l;var d=u;e.default=d,t.exports=e.default,t.exports.default=e.default},29007:function(t,e,n){e.removeEvent=void 0;var i=s(n(68374)),a=n(97906),o=s(n(55994)),r=s(n(85788));function s(t){return t&&t.__esModule?t:{default:t}}e.removeEvent="dxremove";(0,a.beforeCleanData)((function(t){t=[].slice.call(t);for(var e=0;e<t.length;e++){var n=(0,i.default)(t[e]);n.prop("dxRemoveEvent")&&(n[0].dxRemoveEvent=null,o.default.triggerHandler(n,"dxremove"))}})),(0,r.default)("dxremove",{noBubble:!0,setup:function(t){(0,i.default)(t).prop("dxRemoveEvent",!0)}})},72918:function(t,e,n){e.visibility=e.resize=e.keyboard=e.hover=e.focus=e.dxClick=e.click=e.active=void 0;var i=r(n(55994)),a=r(n(51661)),o=n(39611);function r(t){return t&&t.__esModule?t:{default:t}}function s(t,e){return e?(0,o.addNamespace)(t,e):t}function l(t,e){return"function"==typeof t?t(e):t.execute(e)}var c={on:function(t,e,n,a){var o=a.selector,r=a.showTimeout,c=a.hideTimeout,u=a.namespace;i.default.on(t,s("dxactive",u),o,{timeout:r},(function(t){return l(e,{event:t,element:t.currentTarget})})),i.default.on(t,s("dxinactive",u),o,{timeout:c},(function(t){return l(n,{event:t,element:t.currentTarget})}))},off:function(t,e){var n=e.namespace,a=e.selector;i.default.off(t,s("dxactive",n),a),i.default.off(t,s("dxinactive",n),a)}};e.active=c;var u={on:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=n.namespace;i.default.on(t,s("dxresize",a),e)},off:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.namespace;i.default.off(t,s("dxresize",n))}};e.resize=u;var d={on:function(t,e,n,a){var o=a.selector,r=a.namespace;i.default.on(t,s("dxhoverend",r),o,(function(t){return n(t)})),i.default.on(t,s("dxhoverstart",r),o,(function(t){return l(e,{element:t.target,event:t})}))},off:function(t,e){var n=e.selector,a=e.namespace;i.default.off(t,s("dxhoverstart",a),n),i.default.off(t,s("dxhoverend",a),n)}};e.hover=d;var h={on:function(t,e,n,a){var o=a.namespace;i.default.on(t,s("dxhiding",o),n),i.default.on(t,s("dxshown",o),e)},off:function(t,e){var n=e.namespace;i.default.off(t,s("dxhiding",n)),i.default.off(t,s("dxshown",n))}};e.visibility=h;var f={on:function(t,e,n,a){var o=a.namespace;i.default.on(t,s("focusin",o),e),i.default.on(t,s("focusout",o),n)},off:function(t,e){var n=e.namespace;i.default.off(t,s("focusin",n)),i.default.off(t,s("focusout",n))},trigger:function(t){return i.default.trigger(t,"focus")}};e.focus=f;var p={on:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=n.namespace;i.default.on(t,s("dxclick",a),e)},off:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.namespace;i.default.off(t,s("dxclick",n))}};e.dxClick=p;var g={on:function(t,e){var n=arguments.length>2&&void 0!==arguments[2]?arguments[2]:{},a=n.namespace;i.default.on(t,s("click",a),e)},off:function(t){var e=arguments.length>1&&void 0!==arguments[1]?arguments[1]:{},n=e.namespace;i.default.off(t,s("click",n))}};e.click=g;var m=0,_={},v={on:function(t,e,n){var i="keyboardProcessorId".concat(m++);return _[i]=new a.default({element:t,focusTarget:e,handler:n}),i},off:function(t){t&&_[t]&&(_[t].dispose(),delete _[t])},_getProcessor:function(t){return _[t]}};e.keyboard=v},34309:function(t,e,n){e.swipe=e.start=e.end=void 0;var i=n(58664),a=n(39611),o=s(n(98621)),r=s(n(82495));function s(t){return t&&t.__esModule?t:{default:t}}e.start="dxswipestart";e.swipe="dxswipe";e.end="dxswipeend";var l={horizontal:{defaultItemSizeFunc:function(){return(0,i.getWidth)(this.getElement())},getBounds:function(){return[this._maxLeftOffset,this._maxRightOffset]},calcOffsetRatio:function(t){return((0,a.eventData)(t).x-(this._savedEventData&&this._savedEventData.x||0))/this._itemSizeFunc().call(this,t)},isFastSwipe:function(t){var e=(0,a.eventData)(t);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(e.x-this._tickData.x)>=e.time-this._tickData.time}},vertical:{defaultItemSizeFunc:function(){return(0,i.getHeight)(this.getElement())},getBounds:function(){return[this._maxTopOffset,this._maxBottomOffset]},calcOffsetRatio:function(t){return((0,a.eventData)(t).y-(this._savedEventData&&this._savedEventData.y||0))/this._itemSizeFunc().call(this,t)},isFastSwipe:function(t){var e=(0,a.eventData)(t);return this.FAST_SWIPE_SPEED_LIMIT*Math.abs(e.y-this._tickData.y)>=e.time-this._tickData.time}}},c=o.default.inherit({TICK_INTERVAL:300,FAST_SWIPE_SPEED_LIMIT:10,ctor:function(t){this.callBase(t),this.direction="horizontal",this.elastic=!0},_getStrategy:function(){return l[this.direction]},_defaultItemSizeFunc:function(){return this._getStrategy().defaultItemSizeFunc.call(this)},_itemSizeFunc:function(){return this.itemSizeFunc||this._defaultItemSizeFunc},_init:function(t){this._tickData=(0,a.eventData)(t)},_start:function(t){this._savedEventData=(0,a.eventData)(t),(t=this._fireEvent("dxswipestart",t)).cancel||(this._maxLeftOffset=t.maxLeftOffset,this._maxRightOffset=t.maxRightOffset,this._maxTopOffset=t.maxTopOffset,this._maxBottomOffset=t.maxBottomOffset)},_move:function(t){var e=this._getStrategy(),n=(0,a.eventData)(t),i=e.calcOffsetRatio.call(this,t);i=this._fitOffset(i,this.elastic),n.time-this._tickData.time>this.TICK_INTERVAL&&(this._tickData=n),this._fireEvent("dxswipe",t,{offset:i}),!1!==t.cancelable&&t.preventDefault()},_end:function(t){var e=this._getStrategy(),n=e.calcOffsetRatio.call(this,t),i=e.isFastSwipe.call(this,t),a=n,o=this._calcTargetOffset(n,i);a=this._fitOffset(a,this.elastic),o=this._fitOffset(o,!1),this._fireEvent("dxswipeend",t,{offset:a,targetOffset:o})},_fitOffset:function(t,e){var n=this._getStrategy().getBounds.call(this);return t<-n[0]?e?(-2*n[0]+t)/3:-n[0]:t>n[1]?e?(2*n[1]+t)/3:n[1]:t},_calcTargetOffset:function(t,e){var n;return e?(n=Math.ceil(Math.abs(t)),t<0&&(n=-n)):n=Math.round(t),n}});(0,r.default)({emitter:c,events:["dxswipestart","dxswipe","dxswipeend"]})},91093:function(t,e,n){function i(t){return(i="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}e.zoomstart=e.zoomend=e.zoom=e.translatestart=e.translateend=e.translate=e.transformstart=e.transformend=e.transform=e.rotatestart=e.rotateend=e.rotate=e.pinchstart=e.pinchend=e.pinch=void 0;var a=n(60810),o=function(t,e){if(!e&&t&&t.__esModule)return t;if(null===t||"object"!==i(t)&&"function"!=typeof t)return{default:t};var n=u(e);if(n&&n.has(t))return n.get(t);var a={},o=Object.defineProperty&&Object.getOwnPropertyDescriptor;for(var r in t)if("default"!==r&&Object.prototype.hasOwnProperty.call(t,r)){var s=o?Object.getOwnPropertyDescriptor(t,r):null;s&&(s.get||s.set)?Object.defineProperty(a,r,s):a[r]=t[r]}a.default=t,n&&n.set(t,a);return a}(n(95479)),r=n(39611),s=c(n(31391)),l=c(n(82495));function c(t){return t&&t.__esModule?t:{default:t}}function u(t){if("function"!=typeof WeakMap)return null;var e=new WeakMap,n=new WeakMap;return(u=function(t){return t?n:e})(t)}var d="start",h="",f="end",p=[],g=function(t,e){p.push({name:t,args:e})};g("transform",{scale:!0,deltaScale:!0,rotation:!0,deltaRotation:!0,translation:!0,deltaTranslation:!0}),g("translate",{translation:!0,deltaTranslation:!0}),g("pinch",{scale:!0,deltaScale:!0}),g("rotate",{rotation:!0,deltaRotation:!0});var m=function(t){var e,n,i=t.pointers;return e=i[0],{x:(n=i[1]).pageX-e.pageX,y:-n.pageY+e.pageY,centerX:.5*(n.pageX+e.pageX),centerY:.5*(n.pageY+e.pageY)}},_=function(t){return Math.sqrt(t.x*t.x+t.y*t.y)},v=function(t,e){return _(t)/_(e)},b=function(t,e){var n=t.x*e.x+t.y*e.y,i=_(t)*_(e);return 0===i?0:(0,a.sign)(t.x*e.y-e.x*t.y)*Math.acos((0,a.fitIntoRange)(n/i,-1,1))},y=function(t,e){return{x:t.centerX-e.centerX,y:t.centerY-e.centerY}},x=s.default.inherit({validatePointers:function(t){return(0,r.hasTouches)(t)>1},start:function(t){this._accept(t);var e=m(t);this._startVector=e,this._prevVector=e,this._fireEventAliases(d,t)},move:function(t){var e=m(t),n=this._getEventArgs(e);this._fireEventAliases(h,t,n),this._prevVector=e},end:function(t){var e=this._getEventArgs(this._prevVector);this._fireEventAliases(f,t,e)},_getEventArgs:function(t){return{scale:v(t,this._startVector),deltaScale:v(t,this._prevVector),rotation:b(t,this._startVector),deltaRotation:b(t,this._prevVector),translation:y(t,this._startVector),deltaTranslation:y(t,this._prevVector)}},_fireEventAliases:function(t,e,n){n=n||{},o.each(p,function(i,a){var r={};o.each(a.args,(function(t){t in n&&(r[t]=n[t])})),this._fireEvent("dx"+a.name+t,e,r)}.bind(this))}}),w=p.reduce((function(t,e){return[d,h,f].forEach((function(n){t.push("dx"+e.name+n)})),t}),[]);(0,l.default)({emitter:x,events:w});var k={};o.each(w,(function(t,e){k[e.substring("dx".length)]=e}));var S=k.transformstart,C=k.transform,A=k.transformend,E=k.translatestart,T=k.translate,I=k.translateend,D=k.zoomstart,O=k.zoom,L=k.zoomend,M=k.pinchstart,P=k.pinch,R=k.pinchend,B=k.rotatestart,z=k.rotate,q=k.rotateend;e.rotateend=q,e.rotate=z,e.rotatestart=B,e.pinchend=R,e.pinch=P,e.pinchstart=M,e.zoomend=L,e.zoom=O,e.zoomstart=D,e.translateend=I,e.translate=T,e.translatestart=E,e.transformend=A,e.transform=C,e.transformstart=S},19141:function(t,e,n){e.default=void 0;var i,a=(i=n(17381))&&i.__esModule?i:{default:i};var o=function t(e,n){if(!n)throw a.default.Error("E0017");return Array.isArray(e)?e.map((function(e){return t(e,n)})).join(" "):-1!==e.indexOf(" ")?t(e.split(/\s+/g),n):"".concat(e,".").concat(n)};e.default=o,t.exports=e.default,t.exports.default=e.default},27575:function(t,e,n){e.unsubscribeNodesDisposing=e.subscribeNodesDisposing=void 0;var i,a=(i=n(55994))&&i.__esModule?i:{default:i},o=n(29007);function r(t){return t&&[t.target,t.delegateTarget,t.relatedTarget,t.currentTarget].filter((function(t){return!!t}))}e.subscribeNodesDisposing=function(t,e){a.default.one(r(t),o.removeEvent,e)};e.unsubscribeNodesDisposing=function(t,e){a.default.off(r(t),o.removeEvent,e)}},39611:function(t,e,n){e.stopEventsSkipping=e.setEventFixMethod=e.normalizeKeyName=e.needSkipEvent=e.isTouchEvent=e.isPointerEvent=e.isMouseEvent=e.isKeyboardEvent=e.isFakeClickEvent=e.isDxMouseWheelEvent=e.isCommandKeyPressed=e.hasTouches=e.getChar=e.forceSkipEvents=e.fireEvent=e.eventSource=e.eventDelta=e.eventData=e.createEvent=e.addNamespace=void 0;var i=c(n(68374)),a=c(n(19141)),o=c(n(55994)),r=n(95479),s=n(13306),l=n(31421);function c(t){return t&&t.__esModule?t:{default:t}}var u={backspace:"backspace",tab:"tab",enter:"enter",escape:"escape",pageup:"pageUp",pagedown:"pageDown",end:"end",home:"home",arrowleft:"leftArrow",arrowup:"upArrow",arrowright:"rightArrow",arrowdown:"downArrow",delete:"del"," ":"space",f:"F",a:"A","*":"asterisk","-":"minus",alt:"alt",control:"control",shift:"shift"},d={8:"backspace",9:"tab",13:"enter",27:"escape",33:"pageUp",34:"pageDown",35:"end",36:"home",37:"leftArrow",38:"upArrow",39:"rightArrow",40:"downArrow",46:"del",32:"space",70:"F",65:"A",106:"asterisk",109:"minus",189:"minus",173:"minus",16:"shift",17:"control",18:"alt"},h={dx:/^dx/i,mouse:/(mouse|wheel)/i,touch:/^touch/i,keyboard:/^key/i,pointer:/^(ms)?pointer/i},f=function(t){return t},p=function(t){return"dx"===m(t)},g=function(t){return"touch"===m(t)},m=function(t){var e=t.type,n="other";return(0,r.each)(h,(function(t){if(this.test(e))return n=t,!1})),n};e.eventSource=m;var _=function(t){return"pointer"===m(t)};e.isPointerEvent=_;var v=function(t){return function(t){return"mouse"===m(t)}(t)||(_(t)||p(t))&&"mouse"===t.pointerType};e.isMouseEvent=v;var b=function(t){return t&&"dxmousewheel"===t.type};e.isDxMouseWheelEvent=b;var y=function(t){return g(t)||(_(t)||p(t))&&"touch"===t.pointerType};e.isTouchEvent=y;e.isKeyboardEvent=function(t){return"keyboard"===m(t)};e.isFakeClickEvent=function(t){var e=t.screenX,n=t.offsetX,i=t.pageX;return 0===e&&!n&&0===i};e.eventData=function(t){return{x:t.pageX,y:t.pageY,time:t.timeStamp}};e.eventDelta=function(t,e){return{x:e.x-t.x,y:e.y-t.y,time:e.time-t.time||1}};e.hasTouches=function(t){var e=t.originalEvent,n=t.pointers;return g(t)?(e.touches||[]).length:p(t)?(n||[]).length:0};var x=!1;e.forceSkipEvents=function(){return x=!0};e.stopEventsSkipping=function(){return x=!1};e.needSkipEvent=function(t){if(x)return!0;var e=t.target,n=(0,i.default)(e),a=(null==e?void 0:e.isContentEditable)||(null==e?void 0:e.hasAttribute("contenteditable")),o=n.is("input, textarea, select")||a;return b(t)?!(n.is("textarea")&&n.hasClass("dx-texteditor-input")||a)&&(n.is("input[type='number'], textarea, select")&&n.is(":focus")):v(t)?o||t.which>1:y(t)?o&&(0,l.focused)(n):void 0};e.setEventFixMethod=function(t){return f=t};var w=function(t,e){var n=function(t){return f(o.default.Event(t,t),t)}(t);return e&&(0,s.extend)(n,e),n};e.createEvent=w;e.fireEvent=function(t){var e=t.originalEvent,n=t.delegateTarget,i=w(e,t);return o.default.trigger(n||i.target,i),i};e.normalizeKeyName=function(t){var e=t.key,n=t.which,i=u[null==e?void 0:e.toLowerCase()]||e,a=d[n];return a&&i===e?a:!i&&n?String.fromCharCode(n):i};e.getChar=function(t){var e=t.key,n=t.which;return e||String.fromCharCode(n)};var k=a.default;e.addNamespace=k;e.isCommandKeyPressed=function(t){var e=t.ctrlKey,n=t.metaKey;return e||n}},80506:function(t,e,n){e.triggerShownEvent=e.triggerResizeEvent=e.triggerHidingEvent=void 0;var i=o(n(68374)),a=o(n(55994));function o(t){return t&&t.__esModule?t:{default:t}}var r=function(t){return function(e){for(var n=(0,i.default)(e||"body"),o=n.filter(".dx-visibility-change-handler").add(n.find(".dx-visibility-change-handler")),r=0;r<o.length;r++)a.default.triggerHandler(o[r],t)}},s=r("dxshown");e.triggerShownEvent=s;var l=r("dxhiding");e.triggerHidingEvent=l;var c=r("dxresize");e.triggerResizeEvent=c},2994:function(t,e,n){Object.defineProperty(e,"exportDataGrid",{enumerable:!0,get:function(){return i.exportDataGrid}}),Object.defineProperty(e,"exportPivotGrid",{enumerable:!0,get:function(){return a.exportPivotGrid}});var i=n(8572),a=n(77328)},78292:function(t,e,n){e.export=function(t,e,n){if(!t)return(new s.Deferred).resolve();var a=e.exportingAction,o=e.exportedAction,l=e.fileSavingAction,c={fileName:e.fileName,format:e.format,cancel:!1};(0,r.isBoolean)(e.selectedRowsOnly)&&(c.selectedRowsOnly=e.selectedRowsOnly);if((0,r.isFunction)(a)&&a(c),!c.cancel)return n(t,e).then((function(t){if((0,r.isFunction)(o)&&o(),(0,r.isFunction)(l)&&(c.data=t,l(c)),!c.cancel){var n="xlsx"===e.format?"EXCEL":e.format;i.fileSaver.saveAs(c.fileName,n,t)}}));return(new s.Deferred).resolve()},Object.defineProperty(e,"fileSaver",{enumerable:!0,get:function(){return i.fileSaver}}),e.svg=e.pdf=e.image=void 0;var i=n(48351),a=n(12173),o=n(37596),r=n(35922),s=n(62754),l=n(30855);var c={creator:a.imageCreator,getData:a.getData,testFormats:a.testFormats};e.image=c;var u={getData:l.getData};e.pdf=u;var d={creator:o.svgCreator,getData:o.getData};e.svg=d},5332:function(t,e,n){e.ExportLoadPanel=void 0;var i=c(n(68374)),a=n(13306),o=c(n(28109)),r=n(35922),s=c(n(97218)),l=c(n(13615));function c(t){return t&&t.__esModule?t:{default:t}}var u=function(){function t(t,e,n,a){this._$targetElement=e,this._$container=n,this._loadPanel=t._createComponent((0,i.default)("<div>").addClass("dx-export-loadpanel").appendTo(this._$container),s.default,this.getOptions(a))}var e=t.prototype;return e.getDefaultOptions=function(){return{animation:null,shading:!1,height:90,width:200,container:this._$container}},e.getOptions=function(t){return(0,r.isDefined)(t.text)?t.message=t.text:t.message=o.default.format("dxDataGrid-exporting"),(0,a.extend)(this.getDefaultOptions(),t)},e.show=function(){this._loadPanel.option("position",l.default.calculateLoadPanelPosition(this._$targetElement)),this._loadPanel.show()},e.dispose=function(){(0,i.default)(this._loadPanel.element()).remove(),delete this._loadPanel},t}();e.ExportLoadPanel=u},11385:function(t,e,n){e.Export=void 0;var i=n(35922),a=n(38526),o=n(13306),r=n(5332),s=n(58201),l={getFullOptions:function(t){var e=(0,o.extend)({},t);if(!(0,i.isDefined)(e.worksheet)||!(0,i.isObject)(e.worksheet))throw Error('The "worksheet" field must contain an object.');if((0,i.isDefined)(e.topLeftCell)){if((0,i.isString)(e.topLeftCell)){var n=e.worksheet.getCell(e.topLeftCell),a=n.row,r=n.col;e.topLeftCell={row:a,column:r}}}else e.topLeftCell={row:1,column:1};return(0,i.isDefined)(e.keepColumnWidths)||(e.keepColumnWidths=!0),(0,i.isDefined)(e.loadPanel)||(e.loadPanel={}),(0,i.isDefined)(e.loadPanel.enabled)||(e.loadPanel.enabled=!0),(0,i.isDefined)(e.encodeExecutableContent)||(e.encodeExecutableContent=!1),e},convertDateForExcelJS:function(t){return new Date(Date.UTC(t.getFullYear(),t.getMonth(),t.getDate(),t.getHours(),t.getMinutes(),t.getSeconds(),t.getMilliseconds()))},setNumberFormat:function(t,e){t.numFmt=e},getCellStyles:function(t){var e=this,n=t.getStyles();return n.forEach((function(t){var n=e.tryConvertToExcelNumberFormat(t.format,t.dataType);(0,i.isDefined)(n)&&(n=n.replace(/&quot;/g,'"')),t.numberFormat=n})),n},tryConvertToExcelNumberFormat:function(t,e){var n=a.ExportFormat.formatObjectConverter(t,e),i=n.currency;return t=n.format,e=n.dataType,a.ExportFormat.convertFormat(t,n.precision,e,i)},setAlignment:function(t,e,n){var a;t.alignment=null!==(a=t.alignment)&&void 0!==a?a:{},(0,i.isDefined)(e)&&(t.alignment.wrapText=e),(0,i.isDefined)(n)&&(t.alignment.horizontal=n),t.alignment.vertical="top"},setColumnsWidth:function(t,e,n){if((0,i.isDefined)(e))for(var a=0;a<e.length;a++){var o=e[a];"number"==typeof o&&isFinite(o)&&(t.getColumn(n+a).width=Math.min(255,Math.floor(o/7*100)/100))}},export:function(t,e,n,i){var a,l,c=this,u=t.component,d=t.worksheet,h=t.topLeftCell,f=t.keepColumnWidths,p=t.selectedRowsOnly,g=t.loadPanel,m=t.encodeExecutableContent,_=u.getDataProvider(p),v=(null===(a=u._getInternalInstance)||void 0===a?void 0:a.call(u))||u,b=v.option("loadPanel")&&v.option("loadPanel").enabled;if(b&&u.option("loadPanel.enabled",!1),g.enabled&&(0,s.hasWindow)()){var y=n(u),x=i(u);(l=new r.ExportLoadPanel(u,y,x,g)).show()}var w=!!u.option("wordWrapEnabled");d.properties.outlineProperties={summaryBelow:!1,summaryRight:!1};var k={from:{row:h.row,column:h.column},to:{row:h.row,column:h.column}};return new Promise((function(n){_.ready().done((function(){var i=_.getColumns(),a=_.getRowsCount(),r=new e(u,_,d,t);f&&c.setColumnsWidth(d,_.getColumnsWidths(),k.from.column),r._exportAllFieldHeaders(i,c.setAlignment);var s=r._getFieldHeaderRowsCount();k.to.row=k.from.row+s;for(var l=c.getCellStyles(_),h=0;h<a;h++){var p=k.from.row+s+h,g=d.getRow(p),v=0;r._isRowFieldHeadersRow(h)&&(v=_.getRowAreaColCount(),r._exportFieldHeaders("row",p,0,v,c.setAlignment)),r._trySetOutlineLevel(g,h),c.exportRow(_,r,g,h,v,i.length,w,l,m),k.to.row=p}r.mergedRangesManager.applyMergedRages(),k.to.column+=i.length>0?i.length-1:0;var b=d.views[0]||{};u.option("rtlEnabled")&&(b.rightToLeft=!0),r._isFrozenZone(_)&&(-1===Object.keys(b).indexOf("state")&&(0,o.extend)(b,r._getWorksheetFrozenState(k)),r._trySetAutoFilter(k)),Object.keys(b).length>0&&(d.views=[b]),n(k)})).always((function(){b&&u.option("loadPanel.enabled",b),g.enabled&&(0,s.hasWindow)()&&l.dispose()}))}))},exportRow:function(t,e,n,o,r,s,l,c,u){for(var d=r;d<s;d++){var h=t.getCellData(o,d,!0),f=n.getCell(e._getFirstColumnIndex()+d);e.mergedRangesManager.updateMergedRanges(f,o,d,e);var p=e.mergedRangesManager.findMergedCellInfo(o,d,e._isHeaderCell(o,d));if((0,i.isDefined)(p)&&f!==p.masterCell)f.style=p.masterCell.style,f.value=p.masterCell.value;else if((0,i.isDate)(h.value)?f.value=this.convertDateForExcelJS(h.value):f.value=h.value,(0,i.isDefined)(f.value)){var g=c[t.getStyleId(o,d)],m=g.bold,_=g.alignment,v=g.numberFormat;(0,i.isDefined)(v)?this.setNumberFormat(f,v):(0,i.isString)(f.value)&&/^[@=+-]/.test(f.value)&&this.setNumberFormat(f,"@"),e._trySetFont(f,m),this.setAlignment(f,l,_)}e._customizeCell(f,h.cellSourceData),u&&(f.value=a.ExportFormat.encode(f.value))}}};e.Export=l},8572:function(t,e,n){e.exportDataGrid=function(t){return a.Export.export(function(t){if(!(0,i.isDefined)(t)||!(0,i.isObject)(t))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,i.isDefined)(t.component)||!(0,i.isObject)(t.component)||"dxDataGrid"!==t.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');(0,i.isDefined)(t.selectedRowsOnly)||(t.selectedRowsOnly=!1);(0,i.isDefined)(t.autoFilterEnabled)||(t.autoFilterEnabled=!1);return a.Export.getFullOptions(t)}(t),r,s,l)};var i=n(35922),a=n(11385),o=n(31980),r=function(){function t(t,e,n,i){this.component=t,this.dataProvider=e,this.worksheet=n,this.mergedRangesManager=new o.MergedRangesManager(e,n),this.topLeftCell=i.topLeftCell,this.customizeCell=i.customizeCell,this.autoFilterEnabled=i.autoFilterEnabled}var e=t.prototype;return e._getFirstColumnIndex=function(){return this.topLeftCell.column},e._getFieldHeaderRowsCount=function(){return 0},e._trySetAutoFilter=function(t){if(this.autoFilterEnabled&&!(0,i.isDefined)(this.worksheet.autoFilter)&&this.dataProvider.getRowsCount()>0){var e={from:{row:t.from.row+this.dataProvider.getHeaderRowCount()-1,column:t.from.column},to:t.to};this.worksheet.autoFilter=e}},e._trySetFont=function(t,e){(0,i.isDefined)(e)&&(t.font=t.font||{},t.font.bold=e)},e._getWorksheetFrozenState=function(t){return{state:"frozen",ySplit:t.from.row+this.dataProvider.getFrozenArea().y-1}},e._trySetOutlineLevel=function(t,e){e>=this.dataProvider.getHeaderRowCount()&&(t.outlineLevel=this.dataProvider.getGroupLevel(e))},e._isFrozenZone=function(t){return t.getHeaderRowCount()>0},e._isHeaderCell=function(t){return t<this.dataProvider.getHeaderRowCount()},e._isInfoCell=function(){return!1},e._allowToMergeRange=function(){return!0},e._getAllFieldHeaders=function(){return[]},e._customizeCell=function(t,e){(0,i.isFunction)(this.customizeCell)&&this.customizeCell({excelCell:t,gridCell:e})},e._exportFieldHeaders=function(){},e._exportAllFieldHeaders=function(){},e._isRowFieldHeadersRow=function(){},t}();function s(t){return t.getView("rowsView").element()}function l(t){return t.getView("rowsView").element().parent()}},38526:function(t,e,n){e.ExportFormat=void 0;var i=n(68752),a=u(n(18016)),o=u(n(91500)),r=n(35922),s=n(59937),l=n(9821),c=n(13306);function u(t){return t&&t.__esModule?t:{default:t}}n(89740);var d={thousands:"#,##0{0},&quot;K&quot;",millions:"#,##0{0},,&quot;M&quot;",billions:"#,##0{0},,,&quot;B&quot;",trillions:"#,##0{0},,,,&quot;T&quot;",percent:"0{0}%",decimal:"#{0}",fixedpoint:"#,##0{0}",exponential:"0{0}E+00",currency:" "},h=/a+/g,f=/E/g,p=/dE+/g,g=/L/g,m=/h/g,_=/./g;function v(t){var e=(o.default.format(new Date(2009,8,8,6,5,4),t)||"").toString(),n=(0,s.getFormat)((function(e){return o.default.format(e,t)}));return n&&(n=function(t){return t.split("/").join("\\/").split("'").map((function(t,e){return e%2==0?t.replace(h,"AM/PM").replace(p,"d").replace(f,"d").replace(g,"M").replace(m,"H").split("[").join("\\[").split("]").join("\\]"):t?t.replace(_,"\\$&"):"'"})).join("")}(n),n=function(t){var e=(0,l.getLanguageId)(),n=e?e.toString(16):"",i="";if(function(t){for(var e,n=0;n<t.length;n++)if((e=t.charCodeAt(n))>=1632&&e<1642)return!0;return!1}(t)){for(;n.length<3;)n="0"+n;i="[$-2010"+n+"]"}else n&&(i="[$-"+n+"]");return i}(e)+n),n}function b(t){return!!t&&(!!/^[@=\t\r]/.test(t)||!!/^[+-]/.test(t)&&!(0,r.isNumeric)(t))}var y={formatObjectConverter:function(t,e){var n={format:t,precision:t&&t.precision,dataType:e};return(0,r.isObject)(t)?(0,c.extend)(n,t,{format:t.formatter||t.type,currency:t.currency}):n},convertFormat:function(t,e,n,o){if((0,r.isDefined)(t)){if("date"===n)return v(t);if((0,r.isString)(t)&&d[t.toLowerCase()])return function(t,e,n){var o,r;return(r="currency"===t?a.default.getOpenXmlCurrencyFormat(n):d[t.toLowerCase()])&&(o=(0,i.format)(r,function(t,e){var n,i;if(e>0){for(n="decimal"!==t?".":"",i=0;i<e;i++)n+="0";return n}return""}(t,e))),o}(t,e,o)}},encode:function(t){var e=!1;if(!function(t){return!(!t||t.length<2)&&b(t)}(t)?function(t,e){return!(!t||t.length<4||t[0]!==e)&&b(t.substring(1,t.length-1))}(t,'"')&&(t=t.substring(1,t.length-1),e=!0):e=!0,e){var n="".concat('"').concat('"');return"\"'"+t.replaceAll('"',n)+'"'}return t}};e.ExportFormat=y},31980:function(t,e){e.MergedRangesManager=void 0;var n=function(){function t(t,e){this.dataProvider=t,this.worksheet=e,this.mergedCells=[],this.mergedRanges=[]}var e=t.prototype;return e.updateMergedRanges=function(t,e,n,i){if(i._isHeaderCell(e,n)&&!this.isCellInMergedRanges(e,n)){var a=this.dataProvider.getCellMerging(e,n),o=a.rowspan,r=a.colspan;if(r||o){var s=i._allowToMergeRange(e,n,o,r);if(this.updateMergedCells(t,e,n,o,r),s){var l=i._isInfoCell(e,n)&&i._allowExportRowFieldHeaders();this.mergedRanges.push({masterCell:t,rowspan:o-(l&&o>0),colspan:r})}}}},e.isCellInMergedRanges=function(t,e){return this.mergedCells[t]&&this.mergedCells[t][e]},e.findMergedCellInfo=function(t,e,n){if(n&&this.isCellInMergedRanges(t,e))return this.mergedCells[t][e]},e.updateMergedCells=function(t,e,n,i,a){for(var o=e;o<=e+i;o++)for(var r=n;r<=n+a;r++)this.mergedCells[o]||(this.mergedCells[o]=[]),this.mergedCells[o][r]={masterCell:t}},e.addMergedRange=function(t,e,n){this.mergedRanges.push({masterCell:t,rowspan:e,colspan:n})},e.applyMergedRages=function(){var t=this;this.mergedRanges.forEach((function(e){var n=e.masterCell.fullAddress.row,i=e.masterCell.fullAddress.col,a=n+e.rowspan,o=i+e.colspan;t.worksheet.mergeCells(n,i,a,o)}))},t}();e.MergedRangesManager=n},77328:function(t,e,n){e.exportPivotGrid=function(t){return a.Export.export(function(t){if(!(0,i.isDefined)(t)||!(0,i.isObject)(t))throw Error('The "exportPivotGrid" method requires a configuration object.');if(!(0,i.isDefined)(t.component)||!(0,i.isObject)(t.component)||"dxPivotGrid"!==t.component.NAME)throw Error('The "component" field must contain a PivotGrid instance.');(0,i.isDefined)(t.mergeRowFieldValues)||(t.mergeRowFieldValues=!0);(0,i.isDefined)(t.mergeColumnFieldValues)||(t.mergeColumnFieldValues=!0);(0,i.isDefined)(t.exportDataFieldHeaders)||(t.exportDataFieldHeaders=!1);(0,i.isDefined)(t.exportRowFieldHeaders)||(t.exportRowFieldHeaders=!1);(0,i.isDefined)(t.exportColumnFieldHeaders)||(t.exportColumnFieldHeaders=!1);(0,i.isDefined)(t.exportFilterFieldHeaders)||(t.exportFilterFieldHeaders=!1);return a.Export.getFullOptions(t)}(t),c,u,d)};var i=n(35922),a=n(11385),o=n(37518),r=n(78008),s=n(31980);function l(){return(l=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var c=function(){function t(t,e,n,i){this.component=t,this.dataProvider=e,this.worksheet=n,this.mergedRangesManager=new s.MergedRangesManager(e,n),this.topLeftCell=i.topLeftCell,this.customizeCell=i.customizeCell,this.mergeColumnFieldValues=i.mergeColumnFieldValues,this.mergeRowFieldValues=i.mergeRowFieldValues,this.exportFilterFieldHeaders=i.exportFilterFieldHeaders,this.exportDataFieldHeaders=i.exportDataFieldHeaders,this.exportColumnFieldHeaders=i.exportColumnFieldHeaders,this.exportRowFieldHeaders=i.exportRowFieldHeaders,this.rtlEnabled=t.option("rtlEnabled"),this.rowHeaderLayout=t.option("rowHeaderLayout"),this.wrapText=!!t.option("wordWrapEnabled"),this.filterFieldHeaders=this._tryGetFieldHeaders("filter"),this.dataFieldHeaders=this._tryGetFieldHeaders("data"),this.columnFieldHeaders=this._tryGetFieldHeaders("column"),this.rowFieldHeaders=this._tryGetFieldHeaders("row")}var e=t.prototype;return e._getFirstColumnIndex=function(){return this.topLeftCell.column},e._getWorksheetFrozenState=function(t){var e=this.dataProvider.getFrozenArea(),n=e.x,i=e.y;return{state:"frozen",xSplit:t.from.column+n-1,ySplit:t.from.row+i+this._getFieldHeaderRowsCount()-1}},e._getFieldHeaderRowsCount=function(){return 0+this._allowExportFilterFieldHeaders()+(this._allowExportDataFieldHeaders()||this._allowExportColumnFieldHeaders())},e._isFrozenZone=function(){return!0},e._isHeaderCell=function(t,e){return t<this.dataProvider.getColumnAreaRowCount()||e<this.dataProvider.getRowAreaColCount()},e._getDefaultFieldHeaderCellsData=function(t){return{text:t,value:t}},e._isInfoCell=function(t,e){return t<this.dataProvider.getColumnAreaRowCount()&&e<this.dataProvider.getRowAreaColCount()},e._allowToMergeRange=function(t,e,n,i){return!(this.dataProvider.isColumnAreaCell(t,e)&&!this.mergeColumnFieldValues&&i||this.dataProvider.isRowAreaCell(t,e)&&!this.mergeRowFieldValues&&n)},e._trySetAutoFilter=function(){},e._trySetFont=function(t,e){(0,i.isDefined)(e)&&(t.font=t.font||{},t.font.bold=e)},e._getFieldHeaderStyles=function(){var t={style:"thin",color:{argb:"FF7E7E7E"}};return{alignment:(0,o.getDefaultAlignment)(this.rtlEnabled),bold:!0,border:{bottom:t,left:t,right:t,top:t}}},e._trySetOutlineLevel=function(){},e._getAllFieldHeaders=function(){return this.dataProvider._exportController.getDataSource()._descriptions},e._tryGetFieldHeaders=function(t){if(!this["export".concat((0,r.camelize)(t,!0),"FieldHeaders")])return[];var e=this._getAllFieldHeaders()["data"===t?"values":"".concat(t,"s")].filter((function(e){return e.area===t}));return"right"===(0,o.getDefaultAlignment)(this.rtlEnabled)&&e.sort((function(t,e){return e.areaIndex-t.areaIndex})),e.map((function(t){return t.caption}))},e._customizeCell=function(t,e,n){(0,i.isFunction)(this.customizeCell)&&!n&&this.customizeCell({excelCell:t,pivotCell:e})},e._isRowFieldHeadersRow=function(t){var e=this._isInfoCell(t,0)&&"row"===this.dataProvider.getCellData(t+1,0,!0).cellSourceData.area;return this._allowExportRowFieldHeaders()&&e},e._exportAllFieldHeaders=function(t,e){var n=t.length,i=this.dataProvider.getRowAreaColCount(),a=this.topLeftCell.row;this._allowExportFilterFieldHeaders()&&(this._exportFieldHeaders("filter",a,0,n,e),a++),this._allowExportDataFieldHeaders()&&(this._exportFieldHeaders("data",a,0,i,e),this._allowExportColumnFieldHeaders()||this._exportFieldHeaders("column",a,i,n-i,e)),this._allowExportColumnFieldHeaders()&&(this._allowExportDataFieldHeaders()||this._exportFieldHeaders("data",a,0,i,e),this._exportFieldHeaders("column",a,i,n-i,e))},e._exportFieldHeaders=function(t,e,n,i,a){var o=this["".concat(t,"FieldHeaders")],r=this.worksheet.getRow(e),s="row"!==t||"row"===t&&"tree"===this.rowHeaderLayout;s&&this.mergedRangesManager.addMergedRange(r.getCell(this.topLeftCell.column+n),0,i-1);for(var c=0;c<i;c++){var u,d=r.getCell(this.topLeftCell.column+n+c),h=o,f=h.length>i||s?h.join(", "):h[c];u=l({},this._getDefaultFieldHeaderCellsData(f),{headerType:t}),d.value=f,this._applyHeaderStyles(d,a),this._customizeCell(d,u)}},e._applyHeaderStyles=function(t,e){var n=this._getFieldHeaderStyles(),i=n.bold,a=n.alignment,o=n.border;this._trySetFont(t,i),e(t,this.wrapText,a),t.border=o},e._allowExportRowFieldHeaders=function(){return this.rowFieldHeaders.length>0},e._allowExportFilterFieldHeaders=function(){return this.filterFieldHeaders.length>0},e._allowExportDataFieldHeaders=function(){return this.dataFieldHeaders.length>0},e._allowExportColumnFieldHeaders=function(){return this.columnFieldHeaders.length>0},t}();function u(t){return t._dataArea.groupElement()}function d(t){return t.$element()}},48351:function(t,e,n){e.fileSaver=e.MIME_TYPES=void 0;var i=l(n(73349)),a=n(58201),o=l(n(96688)),r=n(35922),s=n(30869);function l(t){return t&&t.__esModule?t:{default:t}}var c=(0,a.getWindow)(),u=(0,a.getNavigator)(),d={EXCEL:"xlsx",CSS:"css",PNG:"png",JPEG:"jpeg",GIF:"gif",SVG:"svg",PDF:"pdf"},h={CSS:"text/css",EXCEL:"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",PNG:"image/png",JPEG:"image/jpeg",GIF:"image/gif",SVG:"image/svg+xml",PDF:"application/pdf"};e.MIME_TYPES=h;var f={_revokeObjectURLTimeout:3e4,_getDataUri:function(t,e){var n=this._getMimeType(t);return"data:".concat(n,";base64,").concat(e)},_getMimeType:function(t){return h[t]||"application/octet-stream"},_linkDownloader:function(t,e){var n=i.default.createElement("a");return n.download=t,n.href=e,n.target="_blank",n},_winJSBlobSave:function(t,e,n){var i=new Windows.Storage.Pickers.FileSavePicker;i.suggestedStartLocation=Windows.Storage.Pickers.PickerLocationId.documentsLibrary;var a=d[n];if(a){var o=this._getMimeType(n);i.fileTypeChoices.insert(o,["."+a])}i.suggestedFileName=e,i.pickSaveFileAsync().then((function(e){e&&e.openAsync(Windows.Storage.FileAccessMode.readWrite).then((function(e){var n=t.msDetachStream();Windows.Storage.Streams.RandomAccessStream.copyAsync(n,e).then((function(){e.flushAsync().done((function(){n.close(),e.close()}))}))}))}))},_click:function(t){try{t.dispatchEvent(new MouseEvent("click",{cancelable:!0}))}catch(n){var e=i.default.getDocument().createEvent("MouseEvents");e.initMouseEvent("click",!0,!0,c,0,0,0,80,20,!1,!1,!1,!1,0,null),t.dispatchEvent(e)}},_saveBlobAs:function(t,e,n){var i=this;if(this._blobSaved=!1,(0,r.isDefined)(u.msSaveOrOpenBlob))u.msSaveOrOpenBlob(n,t),this._blobSaved=!0;else if((0,r.isDefined)(c.WinJS))this._winJSBlobSave(n,t,e),this._blobSaved=!0;else{var a=c.URL||c.webkitURL||c.mozURL||c.msURL||c.oURL;if((0,r.isDefined)(a)){var o=a.createObjectURL(n),l=this._linkDownloader(t,o);setTimeout((function(){a.revokeObjectURL(o),i._objectUrlRevoked=!0}),this._revokeObjectURLTimeout),this._click(l)}else s.logger.warn("window.URL || window.webkitURL || window.mozURL || window.msURL || window.oURL is not defined")}},saveAs:function(t,e,n){var i=d[e];if(i&&(t+="."+i),(0,r.isFunction)(c.Blob))this._saveBlobAs(t,e,n);else{(0,r.isDefined)(u.userAgent.match(/iPad/i))||o.default.log("E1034");var a=this._linkDownloader(t,this._getDataUri(e,n));this._click(a)}}};e.fileSaver=f},12173:function(t,e,n){e.calcScaledInfo=W,e.getData=function(t,e){return Z.getData(t,e)},e.imageCreator=void 0,e.testFormats=function(t){var e=Z._createCanvas(100,100,0);return t.reduce((function(t,n){var i=("image/"+n).toLowerCase();return-1!==e.toDataURL(i).indexOf(i)?t.supported.push(n):t.unsupported.push(n),t}),{supported:[],unsupported:[]})};var i=p(n(68374)),a=p(n(52752)),o=n(35922),r=n(19155),s=n(95479),l=n(13306),c=p(n(73349)),u=n(3532),d=n(58201),h=n(78008),f=n(62754);function p(t){return t&&t.__esModule?t:{default:t}}var g,m=(0,d.getWindow)(),_=Math,v=_.PI,b=_.min,y=_.abs,x=_.sqrt,w=_.pow,k=_.atan2,S=_.cos,C=_.sin,A=Number;function E(t,e,n,i,a,o,r,s){var l=(t+n)/2,c=(e+i)/2,u=k(e-i,t-n),d=o?1:-1;u+=v/180*90*(r?1:-1);var h=x(w(n-t,2)+w(i-e,2))/2,f=x(y(w(a,2)-w(h,2))),p=l+d*(f*S(u)),g=c+d*(f*C(u)),m=k(e-g,t-p),_=k(i-g,n-p);s.arc(p,g,a,m,_,!r)}function T(t,e){var n,i=g(t.attributes||{}),a=(0,l.extend)({},i,{text:t.textContent.replace(/\s+/g," "),textAlign:"middle"===i["text-anchor"]?"center":i["text-anchor"]}),r=i.transform;return r&&((n=r.match(/translate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),a.translateX=A(n[0]),a.translateY=n[1]?A(n[1]):0),(n=r.match(/rotate\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),a.rotationAngle=A(n[0]),a.rotationX=n[1]&&A(n[1]),a.rotationY=n[2]&&A(n[2])),(n=r.match(/scale\(-*\d+([.]\d+)*(,*\s*-*\d+([.]\d+)*)*/))&&(n=n[0].match(/-*\d+([.]\d+)*/g),a.scaleX=A(n[0]),n.length>1?a.scaleY=A(n[1]):a.scaleY=a.scaleX)),function(t,e,n){var i,a=t.style||{};for(i in a)""!==a[i]&&(e[(0,h.camelize)(i)]=a[i]);n&&c.default.isElementNode(t)&&(a=m.getComputedStyle(t),["fill","stroke","stroke-width","font-family","font-size","font-style","font-weight"].forEach((function(t){t in a&&""!==a[t]&&(e[(0,h.camelize)(t)]=a[t])})),["opacity","fill-opacity","stroke-opacity"].forEach((function(t){t in a&&""!==a[t]&&"1"!==a[t]&&(e[t]=A(a[t]))})));e.textDecoration=e.textDecoration||e.textDecorationLine,e.globalAlpha=(0,o.isDefined)(e.opacity)?e.opacity:e.globalAlpha}(t,a,e),a}function I(t){var e=t&&t.match(/url\(.*#(.*?)["']?\)/i);return e&&e[1]}function D(t,e){var n=[];e.fontSize=e.fontSize||"10px",e.fontFamily=e.fontFamily||"sans-serif",e.fill=e.fill||"#000",e.fontStyle&&n.push(e.fontStyle),e.fontWeight&&n.push(e.fontWeight),n.push(e.fontSize),n.push(e.fontFamily),t.font=n.join(" "),t.textAlign=e.textAlign,t.fillStyle=e.fill,t.globalAlpha=e.globalAlpha}function O(t,e,n){D(t,e),R(t,e,n),e.text&&t.fillText(e.text,e.x||0,e.y||0),H(t,e,!0),function(t,e,n){if(!e.textDecoration||"none"===e.textDecoration)return;var i=e.x,a=t.measureText(e.text).width,o=parseInt(e.fontSize,10),r=.05*o<1?1:.05*o,s=e.y;switch(e.textDecoration){case"line-through":s-=o/3+r/2;break;case"overline":s-=o-r;break;case"underline":s+=r}t.rect(i,s,a,r),N(t,e,n),H(t,e)}(t,e,n)}function L(t){for(var e=t.childNodes,n=0;n<e.length;n++)if("tspan"===e[n].tagName)return!0;return!1}function M(t,e,n,i){var a=t.tagName,o="text"===a||"tspan"===a||void 0===a,s="image"===a,c=8===t.nodeType,u=(0,l.extend)({},n,T(t,i.rootAppended));if("hidden"!==u.visibility&&!u[r.HIDDEN_FOR_EXPORT]&&!c){var d;switch(e.save(),!s&&B(e,u),z(e,u,i),function(t){t.strokeOpacity=void 0!==t["stroke-opacity"]?t["stroke-opacity"]:1,t.fillOpacity=void 0!==t["fill-opacity"]?t["fill-opacity"]:1,void 0!==t.opacity&&(t.strokeOpacity*=t.opacity,t.fillOpacity*=t.opacity)}(u),e.beginPath(),t.tagName){case void 0:O(e,u,i);break;case"text":case"tspan":!function t(e,n,i,a){for(var o,r=[],s=0,c=0;c<e.length;c++){var u=e[c];if(void 0===u.tagName)M(u,n,i,a);else if("tspan"===u.tagName||"text"===u.tagName){var d=T(u,a.rootAppended),h=(0,l.extend)({},i,d);if("tspan"===u.tagName&&L(u)){t(u.childNodes,n,h,a);continue}h.textAlign="start",o&&void 0===d.x||(o={elements:[],options:[],widths:[],offsets:[]},r.push(o)),void 0!==d.y&&(s=0),void 0!==d.dy&&(s+=parseFloat(d.dy)),o.elements.push(u),o.options.push(h),o.offsets.push(s),D(n,h),o.widths.push(n.measureText(h.text).width)}}r.forEach((function(e){var o=e.widths.reduce((function(t,e){return t+e}),0),r=0,s=0;"center"===i.textAlign&&(r=o/2),"end"===i.textAlign&&(r=o),e.options.forEach((function(t,n){var i=e.widths[n];t.x=t.x-r+s,t.y+=e.offsets[n],s+=i})),e.elements.forEach((function(i,o){t(i.childNodes,n,e.options[o],a)}))}))}(t.childNodes,e,u,i);break;case"image":d=function(t,e,n){var i=new f.Deferred,a=new m.Image;return a.onload=function(){t.save(),t.globalAlpha=e.globalAlpha,B(t,e),z(t,e,n),t.drawImage(a,e.x||0,e.y||0,e.width,e.height),t.restore(),i.resolve()},a.onerror=function(){i.resolve()},a.setAttribute("crossOrigin","anonymous"),a.src=e.href||e["xlink:href"],i}(e,u,i);break;case"path":!function(t,e){var n,i,a,o=e.replace(/,/g," ").split(/([A-Z])/i).filter((function(t){return""!==t.trim()})),r=0;do{switch(n=(o[r+1]||"").trim().split(" "),o[r]){case"M":t.moveTo(A(n[0]),A(n[1])),r+=2;break;case"L":for(var s=0;s<n.length/2;s++)t.lineTo(A(n[2*s]),A(n[2*s+1]));r+=2;break;case"C":t.bezierCurveTo(A(n[0]),A(n[1]),A(n[2]),A(n[3]),A(n[4]),A(n[5])),r+=2;break;case"a":a=(i=o[r-1].trim().split(" ")).length-1,E(A(i[a-1]),A(i[a]),A(i[a-1])+A(n[5]),A(i[a])+A(n[6]),A(n[0]),A(n[3]),A(n[4]),t),r+=2;break;case"A":a=(i=o[r-1].trim().split(" ")).length-1,E(A(i[a-1]),A(i[a]),A(n[5]),A(n[6]),A(n[0]),A(n[3]),A(n[4]),t),r+=2;break;case"Z":t.closePath(),r+=1;break;default:r++}}while(r<o.length)}(e,u.d);break;case"rect":!function(t,e){var n=e.x,i=e.y,a=e.width,o=e.height,r=e.rx;r?(r=b(r,a/2,o/2),t.save(),t.translate(n,i),t.moveTo(a/2,0),t.arcTo(a,0,a,o,r),t.arcTo(a,o,0,o,r),t.arcTo(0,o,0,0,r),t.arcTo(0,0,r,0,r),t.lineTo(a/2,0),t.restore()):t.rect(n,i,a,o)}(e,u),e.closePath();break;case"circle":e.arc(u.cx,u.cy,u.r,0,2*v,1)}return o||(R(e,u,i),s||(d=N(e,u,i)),H(e,u)),P(e,u,i,t,"linear"),P(e,u,i,t,"radial"),e.restore(),d}}function P(t,e,n,i,a){var o=n.linearGradients,r=n.radialGradients,s="linear"===a?o:r;if(0!==Object.keys(s).length){var l=I(e.fill);if(l&&s[l]){var c=i.getBBox(),u=c.x+c.width/2,d=c.y+c.height/2,h=Math.max(c.height/2,c.width/2),f="linear"===a?t.createLinearGradient(c.x,0,c.x+c.width,0):t.createRadialGradient(u,d,0,u,d,h);if(s[l].colors.forEach((function(t){var e=parseInt(t.offset.replace(/%/,""));f.addColorStop(e/100,t.stopColor)})),"linear"===a){var p,g,m=null!==(p=(null===(g=s[l].transform)||void 0===g?void 0:g.replace(/\D/g,""))*Math.PI/180)&&void 0!==p?p:0;t.translate(u,d),t.rotate(m),t.translate(-u,-d)}t.globalAlpha=e.opacity,t.fillStyle=f,t.fill()}}}function R(t,e,n){var i,a=I(e.filter);a&&((i=n.filters[a])||(i={offsetX:0,offsetY:0,blur:0,color:"#000"}),t.shadowOffsetX=i.offsetX,t.shadowOffsetY=i.offsetY,t.shadowColor=i.color,t.shadowBlur=i.blur)}function B(t,e){t.translate(e.translateX||0,e.translateY||0),e.translateX=void 0,e.translateY=void 0,e.rotationAngle&&(t.translate(e.rotationX||0,e.rotationY||0),t.rotate(e.rotationAngle*v/180),t.translate(-(e.rotationX||0),-(e.rotationY||0)),e.rotationAngle=void 0,e.rotationX=void 0,e.rotationY=void 0),isFinite(e.scaleX)&&(t.scale(e.scaleX,e.scaleY),e.scaleX=void 0,e.scaleY=void 0)}function z(t,e,n){e["clip-path"]&&(M(n.clipPaths[I(e["clip-path"])],t,{},n),t.clip(),e["clip-path"]=void 0)}function q(t){var e,n={colors:[],transform:null===(e=t.attributes.gradientTransform)||void 0===e?void 0:e.textContent};return(0,s.each)(t.childNodes,(function(t,e){var i=e.attributes;n.colors.push({offset:i.offset.value,stopColor:i["stop-color"].value})})),n}function V(t){var e,n,i={};return(0,s.each)(t.childNodes,(function(t,o){var r=o.attributes;if(r.result)switch(r.result.value){case"gaussianBlurResult":i.blur=A(r.stdDeviation.value);break;case"offsetResult":i.offsetX=A(r.dx.value),i.offsetY=A(r.dy.value);break;case"floodResult":e=r["flood-color"]?r["flood-color"].value:"#000",n=r["flood-opacity"]?r["flood-opacity"].value:1,i.color=function(t,e){var n=new a.default(t);return"rgba("+n.r+","+n.g+","+n.b+","+e+")"}(e,n)}})),i}function F(t,e,n,i){return function t(e,n){for(var i=arguments.length>2&&void 0!==arguments[2]?arguments[2]:new f.Deferred,a=0;a<e.length;a++){var r=n(e[a]);if((0,o.isPromise)(r)){r.then((function(){t(Array.prototype.slice.call(e,a+1),n,i)}));break}}return a===e.length&&i.resolve(),i}(t,(function(t){switch(t.tagName&&t.tagName.toLowerCase()){case"g":case"svg":var a=(0,l.extend)({},n,T(t,i.rootAppended));e.save(),B(e,a),z(e,a,i);var r=function(){e.restore()},s=F(t.childNodes,e,a,i);return(0,o.isPromise)(s)?s.then(r):r(),s;case"defs":return F(t.childNodes,e,{},i);case"clippath":i.clipPaths[t.attributes.id.textContent]=t.childNodes[0];break;case"pattern":i.patterns[t.attributes.id.textContent]=t;break;case"filter":i.filters[t.id]=V(t);break;case"lineargradient":i.linearGradients[t.attributes.id.textContent]=q(t);break;case"radialgradient":i.radialGradients[t.attributes.id.textContent]=q(t);break;default:return M(t,e,n,i)}}))}function H(t,e,n){var i=e.stroke;i&&"none"!==i&&0!==e["stroke-width"]&&(!function(t,e){var n=e["stroke-dasharray"]&&e["stroke-dasharray"].match(/(\d+)/g);n&&n.length&&(n=(0,s.map)(n,(function(t){return A(t)})),t.setLineDash(n))}(t,e),t.lineJoin=e["stroke-linejoin"],t.lineWidth=e["stroke-width"],t.globalAlpha=e.strokeOpacity,t.strokeStyle=i,n?t.strokeText(e.text,e.x,e.y):t.stroke(),t.globalAlpha=1)}function N(t,e,n){var i,a=e.fill;if(a&&"none"!==a)if(-1===a.search(/url/))t.fillStyle=a,t.globalAlpha=e.fillOpacity,t.fill(),t.globalAlpha=1;else{var r=n.patterns[I(a)];if(!r)return;i=function(t,e,n,i){var a=T(e,n.rootAppended),r=Z._createCanvas(a.width,a.height,0),s=r.getContext("2d"),l=F(e.childNodes,s,a,n),c=function(){t.fillStyle=t.createPattern(r,"repeat"),t.globalAlpha=i.fillOpacity,t.fill(),t.globalAlpha=1};return(0,o.isPromise)(l)?l.then(c):c(),l}(t,r,n,e)}return i}function j(t,e,n){return F(t.childNodes,e.getContext("2d"),{},{clipPaths:{},patterns:{},filters:{},linearGradients:{},radialGradients:{},rootAppended:n})}function G(t,e){var n=e.width,i=e.height,a=e.backgroundColor,o=e.margin,s=e.svgToCanvas,l=void 0===s?j:s,d=W(n,i),h=Z._createCanvas(d.width,d.height,o),p=h.getContext("2d");p.setTransform(d.pixelRatio,0,0,d.pixelRatio,0,0);var g,m=(0,r.getSvgElement)(t),_=c.default.isElementNode(t);return p.translate(o,o),c.default.getBody().appendChild(h),_||((g=function(){var t=c.default.createElement("div");return t.style.left="-9999px",t.style.position="absolute",t}()).appendChild(m),c.default.getBody().appendChild(g)),m.attributes.direction&&(h.dir=m.attributes.direction.textContent),function(t,e,n,i,a){t.fillStyle=i||"#ffffff",t.fillRect(-a,-a,e+2*a,n+2*a)}(p,n,i,a,o),(0,f.fromPromise)(l(m,h,_&&(0,u.contains)(c.default.getBody(),t))).then((function(){return h})).always((function(){g&&c.default.getBody().removeChild(g),c.default.getBody().removeChild(h)}))}g=function(t){var e,n={};return(0,s.each)(t,(function(t,i){e=i.textContent,isFinite(e)&&(e=A(e)),n[i.name.toLowerCase()]=e})),n};var Z={getImageData:function(t,e){var n="image/"+e.format;return(0,o.isFunction)(e.__parseAttributesFn)&&(g=e.__parseAttributesFn),G(t,e).then((function(t){return function(t,e){var n=t.toDataURL(e,1);return m.atob(n.substring(("data:"+e+";base64,").length))}(t,n)}))},getData:function(t,e){var n=this;return Z.getImageData(t,e).then((function(t){var i="image/"+e.format;return(0,o.isFunction)(m.Blob)&&!e.useBase64?n._getBlob(t,i):n._getBase64(t)}))},_getBlob:function(t,e){var n,i=new Uint8Array(t.length);for(n=0;n<t.length;n++)i[n]=t.charCodeAt(n);return new m.Blob([i.buffer],{type:e})},_getBase64:function(t){return m.btoa(t)},_createCanvas:function(t,e,n){var a=(0,i.default)("<canvas>")[0];return a.width=t+2*n,a.height=e+2*n,a.hidden=!0,a}};function W(t,e){var n=m.devicePixelRatio||1;return{pixelRatio:n,width:t*n,height:e*n}}e.imageCreator=Z},18577:function(t,e,n){e.Export=void 0;var i=n(35922),a=n(13306),o=u(n(91500)),r=u(n(18016)),s=u(n(28109)),l=n(5332),c=n(58201);function u(t){return t&&t.__esModule?t:{default:t}}var d={getFullOptions:function(t){var e=(0,a.extend)({},t);if(!(0,i.isDefined)(e.jsPDFDocument)||!(0,i.isObject)(e.jsPDFDocument))throw Error('The "jsPDFDocument" field must contain a jsPDF instance.');if(!(0,i.isDefined)(e.jsPDFDocument.autoTable)||!(0,i.isFunction)(e.jsPDFDocument.autoTable))throw Error('The "exportDataGrid" method requires a autoTable plugin for jsPDF object.');if((0,i.isDefined)(e.keepColumnWidths)||(e.keepColumnWidths=!0),(0,i.isDefined)(e.autoTableOptions)){if(!(0,i.isObject)(e.autoTableOptions))throw Error('The "autoTableOptions" option must be of object type.');e.autoTableOptions=(0,a.extend)(!0,{},this._getDefaultAutoTableOptions(),e.autoTableOptions)}else e.autoTableOptions=this._getDefaultAutoTableOptions();return(0,i.isDefined)(e.loadPanel)||(e.loadPanel={}),(0,i.isDefined)(e.loadPanel.enabled)||(e.loadPanel.enabled=!0),(0,i.isDefined)(e.loadPanel.text)||(e.loadPanel.text=s.default.format("dxDataGrid-exporting")),e},_getDefaultAutoTableOptions:function(){return{theme:"plain",tableLineColor:149,tableLineWidth:.1,styles:{textColor:51,lineColor:149,lineWidth:0},columnStyles:{},headStyles:{fontStyle:"normal",textColor:149,lineWidth:.1},bodyStyles:{lineWidth:.1},head:[],body:[]}},export:function(t){var e,n,a=this,o=t.jsPDFDocument,r=t.autoTableOptions,s=t.component,u=t.customizeCell,d=t.keepColumnWidths,h=t.selectedRowsOnly,f=t.loadPanel,p=(null===(e=s._getInternalInstance)||void 0===e?void 0:e.call(s))||s,g=p.option("loadPanel")&&p.option("loadPanel").enabled;if(g&&s.option("loadPanel.enabled",!1),f.enabled&&(0,c.hasWindow)()){var m=s.getView("rowsView");(n=new l.ExportLoadPanel(s,m.element(),m.element().parent(),f)).show()}var _=s.getDataProvider(h),v=!!s.option("wordWrapEnabled");return new Promise((function(t){_.ready().done((function(){var e=_.getColumns(),n=_.getStyles(),s=_.getRowsCount(),l=_.getHeaderRowCount(),c=[];if(d){var h=a._tryGetPdfColumnWidths(r.tableWidth,_.getColumnsWidths());(0,i.isDefined)(h)&&(0,i.isDefined)(r.columnStyles)&&a._setColumnWidths(r.columnStyles,h)}for(var f=0;f<s;f++){for(var p=[],g=0;g<e.length;g++){var m=_.getCellData(f,g,!0),b=m.value,y=m.cellSourceData,x=n[_.getStyleId(f,g)],w={content:a._getFormattedValue(b,x.format),styles:a._getPDFCellStyles(y.rowType,e[g].alignment,x,v)};if("header"===y.rowType){var k=a._tryGetMergeRange(f,g,c,_);k&&k.rowSpan>0&&(w.rowSpan=k.rowSpan+1),k&&k.colSpan>0&&(w.colSpan=k.colSpan+1),(!(c[f]&&c[f][g])||w.rowSpan>1||w.colSpan>1)&&((0,i.isFunction)(u)&&u({gridCell:y,pdfCell:w}),p.push(w))}else if("group"!==y.rowType||(0,i.isDefined)(w.content)||1!==p.length){var S;w.content=null!==(S=w.content)&&void 0!==S?S:"",(0,i.isFunction)(u)&&u({gridCell:y,pdfCell:w}),p.push(w)}else{var C;p[0].colSpan=null!==(C=p[0].colSpan)&&void 0!==C?C:1,p[0].colSpan++}}f<l?r.head.push(p):r.body.push(p)}o.autoTable(r),t()})).always((function(){g&&s.option("loadPanel.enabled",g),f.enabled&&(0,c.hasWindow)()&&n.dispose()}))}))},_getFormattedValue:function(t,e){if((0,i.isDefined)(e)){if((0,i.isDate)(t))return o.default.format(t,e);if((0,i.isNumeric)(t))return r.default.format(t,e)}return t},_getPDFCellStyles:function(t,e,n,i){var a=n.alignment,o=n.bold,r="header"===t?e:a,s={};return r&&(s.halign=r),o&&"header"!==t&&(s.fontStyle="bold"),i&&(s.cellWidth="wrap"),s},_tryGetMergeRange:function(t,e,n,i){if(!n[t]||!n[t][e]){var a=i.getCellMerging(t,e),o=a.colspan,r=a.rowspan;if(o||r){for(var s=t;s<=t+r;s++)for(var l=e;l<=e+o;l++)n[s]||(n[s]=[]),n[s][l]=!0;return{rowSpan:r,colSpan:o}}}},_tryGetPdfColumnWidths:function(t,e){if((0,i.isNumeric)(t)&&(0,i.isDefined)(e)){var n=e.reduce((function(t,e){return t+e}),0);return e.map((function(e){return t*e/n}))}},_setColumnWidths:function(t,e){e.forEach((function(e,n){t[n]=t[n]||{},t[n].cellWidth=e}))}};e.Export=d},83152:function(t,e,n){e.exportDataGrid=function(t){return a.Export.export(function(t){if(!(0,i.isDefined)(t)||!(0,i.isObject)(t))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,i.isDefined)(t.component)||!(0,i.isObject)(t.component)||"dxDataGrid"!==t.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');(0,i.isDefined)(t.selectedRowsOnly)||(t.selectedRowsOnly=!1);return a.Export.getFullOptions(t)}(t))};var i=n(35922),a=n(18577)},66867:function(t,e,n){e.addNewPage=function(t){t.addPage(),function(t){(0,i.isDefined)(t.getLineWidth)||(t.__borderWidth=null)}(t)},e.drawCellsContent=function(t,e,n,o){n.forEach((function(n){var s=n._rect,c=n.gridCell,h=function(t,e){if(null==t)return{};var n,i,a=function(t,e){if(null==t)return{};var n,i,a={},o=Object.keys(t);for(i=0;i<o.length;i++)n=o[i],e.indexOf(n)>=0||(a[n]=t[n]);return a}(t,e);if(Object.getOwnPropertySymbols){var o=Object.getOwnPropertySymbols(t);for(i=0;i<o.length;i++)n=o[i],e.indexOf(n)>=0||Object.prototype.propertyIsEnumerable.call(t,n)&&(a[n]=t[n])}return a}(n,r),f=s.x,g=s.y,m=s.w,_=s.h,v={doc:t,rect:{x:f,y:g,w:m,h:_},pdfCell:h,gridCell:c,cancel:!1};null==e||e(v),v.cancel||(function(t,e){(0,i.isDefined)(e.backgroundColor)&&(p(t,"fill",e.backgroundColor),u(t,e._rect.x,e._rect.y,e._rect.w,e._rect.h,"F"))}(t,n),function(t,e,n){if((0,i.isDefined)(e.text)&&""!==e.text){var o=e.textColor,r=e.font,s=e._rect,c=e.padding;!function(t,e,n){var o=e.textColor,r=e.font;p(t,"text",(0,i.isDefined)(o)?o:n.textColor);var s=(0,i.isDefined)(r)?(0,a.extend)({},n.font,r):n.font,l=t.getFont();(s.name!==l.fontName||s.style!==l.fontStyle||(0,i.isDefined)(s.weight))&&t.setFont(s.name,s.style,s.weight);s.size!==t.getFontSize()&&t.setFontSize(s.size)}(t,{textColor:o,font:r},n);var u,h,f={x:s.x+c.left,y:s.y+c.top,w:s.w-(c.left+c.right),h:s.h-(c.top+c.bottom)};if((0,i.isDefined)(e._textLeftOffset)||(0,i.isDefined)(e._textTopOffset))f.x=f.x+(null!==(u=e._textLeftOffset)&&void 0!==u?u:0),f.y=f.y+(null!==(h=e._textTopOffset)&&void 0!==h?h:0),t.saveGraphicsState(),function(t,e,n,i,a){t.moveTo(l(e),l(n)),t.lineTo(l(e+i),l(n)),t.lineTo(l(e+i),l(n+a)),t.lineTo(l(e),l(n+a)),t.clip(),t.discardPath()}(t,e._rect.x,e._rect.y,e._rect.w,e._rect.h);d(t,e.text,f,e.verticalAlign,e.horizontalAlign,e._internalTextOptions),((0,i.isDefined)(e._textLeftOffset)||(0,i.isDefined)(e._textTopOffset))&&t.restoreGraphicsState()}}(t,n,o))}))},e.drawCellsLines=function(t,e,n){e.filter((function(t){return!(0,i.isDefined)(t.borderColor)})).forEach((function(e){h(t,e._rect,e,n)})),e.filter((function(t){return(0,i.isDefined)(t.borderColor)})).forEach((function(e){h(t,e._rect,e,n)}))},e.drawGridLines=function(t,e,n,i){h(t,e,n,i)},e.drawLine=c,e.drawRect=u,e.drawTextInRect=d,e.getDocumentStyles=function(t){var e=t.getFont();return{borderWidth:g(t),borderColor:t.getDrawColor(),font:{name:e.fontName,style:e.fontStyle,size:t.getFontSize()},textColor:t.getTextColor()}},e.roundToThreeDecimals=l,e.setDocumentStyles=function(t,e){var n=e.borderWidth,i=e.borderColor,a=e.font,o=e.textColor,r=t.getFont();r.fontName===a.name&&r.fontStyle===a.style||t.setFont(a.name,a.style,void 0);t.getFontSize()!==a.size&&t.setFontSize(a.size);g(t)!==n&&m(t,n);t.getDrawColor()!==i&&t.setDrawColor(i);t.getTextColor()!==o&&t.setTextColor(o)};var i=n(35922),a=n(13306),o=n(79262),r=["_rect","gridCell"];function s(t){return t.charAt(0).toUpperCase()+t.slice(1)}function l(t){return Math.round(1e3*t)/1e3}function c(t,e,n,i,a){t.line(l(e),l(n),l(i),l(a))}function u(t,e,n,a,o,r){(0,i.isDefined)(r)?t.rect(l(e),l(n),l(a),l(o),r):t.rect(l(e),l(n),l(a),l(o))}function d(t,e,n,i,r,s){var c=e.split("\n"),u=c.length,d=(0,o.calculateTextHeight)(t,c[0],t.getFont(),{wordWrapEnabled:!1,targetRectWidth:1e9}),h=null!=i?i:"middle",f=null!=r?r:"left",p={top:0,middle:.5,bottom:1},g=n.y+n.h*p[h]-d*(u-1)*p[h]+function(t){return(t.getLineHeightFactor()-1.15)*t.getFontSize()}(t),m=n.x+n.w*{left:0,center:.5,right:1}[f],_=(0,a.extend)({baseline:h,align:f},s);t.text(c.join("\n"),l(m),l(g),_)}function h(t,e,n,a){var o=n.borderWidth,r=n.borderColor,s=n.drawLeftBorder,l=void 0===s||s,d=n.drawRightBorder,h=void 0===d||d,p=n.drawTopBorder,g=void 0===p||p,m=n.drawBottomBorder,_=void 0===m||m;if(!(0,i.isDefined)(e))throw"rect is required";(l||h||g||_)&&(l&&h&&g&&_?(f(t,{borderWidth:o,borderColor:r},a),u(t,e.x,e.y,e.w,e.h)):(f(t,{borderWidth:o,borderColor:r},a),g&&c(t,e.x,e.y,e.x+e.w,e.y),l&&c(t,e.x,e.y,e.x,e.y+e.h),h&&c(t,e.x+e.w,e.y,e.x+e.w,e.y+e.h),_&&c(t,e.x,e.y+e.h,e.x+e.w,e.y+e.h)))}function f(t,e,n){var a=e.borderWidth,r=e.borderColor,s=(0,i.isDefined)(a)?a:n.borderWidth;s!==g(t)&&m(t,(0,o.toPdfUnit)(t,s)),p(t,"draw",(0,i.isDefined)(r)?r:n.borderColor)}function p(t,e,n){var i="get".concat(s(e),"Color"),a="set".concat(s(e),"Color"),o=n.ch1,r=void 0===o?n:o,l=n.ch2,c=n.ch3,u=n.ch4;t.__private__.decodeColorString(t.__private__.encodeColorString({ch1:r,ch2:l,ch3:c,ch4:u,precision:"text"===e?3:2}))===t[i]()&&"fill"!==e||t[a].apply(t,[r,l,c,u].filter((function(t){return void 0!==t})))}function g(t){var e;return(0,i.isDefined)(t.getLineWidth)?t.getLineWidth():null!==(e=t.__borderWidth)&&void 0!==e?e:.200025}function m(t,e){t.setLineWidth(e),(0,i.isDefined)(t.getLineWidth)||(t.__borderWidth=e)}},17195:function(t,e,n){e.Export=void 0;var i,a=n(35922),o=n(13306),r=n(30646),s=n(65322),l=n(41269),c=n(27504),u=n(22775),d=n(66867),h=n(79262),f=(i=n(28109))&&i.__esModule?i:{default:i},p=n(5332),g=n(58201);function m(){return(m=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var _={getFullOptions:function(t){var e=t.jsPDFDocument,n=(0,o.extend)({},t);return(0,a.isDefined)(n.topLeft)||(n.topLeft={x:0,y:0}),(0,a.isDefined)(n.indent)||(n.indent=0),(0,a.isDefined)(n.repeatHeaders)||(n.repeatHeaders=!0),(0,a.isDefined)(n.margin)||(n.margin=(0,h.toPdfUnit)(e,40)),n.margin=(0,r.normalizeBoundaryValue)(n.margin),Array.isArray(n.columnWidths)||(n.columnWidths=[]),(0,a.isDefined)(n.loadPanel)||(n.loadPanel={}),(0,a.isDefined)(n.loadPanel.enabled)||(n.loadPanel.enabled=!0),(0,a.isDefined)(n.loadPanel.text)||(n.loadPanel.text=f.default.format("dxDataGrid-exporting")),n},export:function(t){var e,n,i=t.jsPDFDocument,o=t.component,f=t.selectedRowsOnly,_=t.loadPanel,v=(null===(e=o._getInternalInstance)||void 0===e?void 0:e.call(o))||o,b=v.option("loadPanel")&&v.option("loadPanel").enabled;if(b&&o.option("loadPanel.enabled",!1),_.enabled&&(0,g.hasWindow)()){var y=o.getView("rowsView");(n=new p.ExportLoadPanel(o,y.element(),y.element().parent(),_)).show()}var x=o.getDataProvider(f);return new Promise((function(e){x.ready().done((function(){var n,f,p=(0,c.generateRowsInfo)(i,x,o,null===(n=t.rowOptions)||void 0===n||null===(f=n.headerStyles)||void 0===f?void 0:f.backgroundColor);t.customizeCell&&p.forEach((function(e){return e.cells.forEach((function(e){return t.customizeCell(e)}))})),(0,r.normalizeRowsInfo)(p),(0,s.initializeCellsWidth)(i,x,p,t),(0,s.resizeFirstColumnByIndentLevel)(p,t),(0,s.applyColSpans)(p),(0,s.calculateHeights)(i,p,t),(0,s.applyRowSpans)(p),(0,l.updateRowsAndCellsHeights)(i,p),(0,s.calculateCoordinates)(i,p,t),(0,s.applyBordersConfig)(p),(0,h.applyWordWrap)(i,p);var g=(0,d.getDocumentStyles)(i),_=!!o.option("rtlEnabled"),v=(0,u.splitByPages)(i,p,t,(function(t){var e,n=t.sourceRect,o=t.leftRect,r=t.rightRect,s={},l={};if((null===(e=n.sourceCellInfo.text)||void 0===e?void 0:e.length)>0)if(_){var c=i.getTextWidth(n.sourceCellInfo.text)>o.w,u=!(0,a.isDefined)(n.sourceCellInfo.horizontalAlign)||"right"===n.sourceCellInfo.horizontalAlign;if(c||!u){var d,h,f,p,g,v;if("right"===(null===(d=n.sourceCellInfo)||void 0===d?void 0:d.horizontalAlign))g=(p=null!==(v=n.sourceCellInfo._textLeftOffset)&&void 0!==v?v:0)+o.w;else"center"===(null===(h=n.sourceCellInfo)||void 0===h?void 0:h.horizontalAlign)?p=(g=n.x+n.w-(r.x+r.w)+n.sourceCellInfo._rect.w/2-o.w/2)-r.w:"left"===(null===(f=n.sourceCellInfo)||void 0===f?void 0:f.horizontalAlign)&&(p=(g=n.x+n.w-(r.x+r.w))-r.w);s=m({},{_textLeftOffset:p}),l=m({},{_textLeftOffset:g})}else l=m({},{text:""})}else{var b=i.getTextWidth(n.sourceCellInfo.text)>o.w,y=!(0,a.isDefined)(n.sourceCellInfo.horizontalAlign)||"left"===n.sourceCellInfo.horizontalAlign;if(b||!y){var x,w,k,S,C,A;if("left"===(null===(x=n.sourceCellInfo)||void 0===x?void 0:x.horizontalAlign))C=(S=null!==(A=n.sourceCellInfo._textLeftOffset)&&void 0!==A?A:0)-o.w;else if("center"===(null===(w=n.sourceCellInfo)||void 0===w?void 0:w.horizontalAlign)){var E,T=null!==(E=n.sourceCellInfo._textLeftOffset)&&void 0!==E?E:0;S=T+(n.x+n.w/2)-(o.x+o.w/2),C=T+(n.x+n.w/2)-(r.x+r.w/2)}else"right"===(null===(k=n.sourceCellInfo)||void 0===k?void 0:k.horizontalAlign)&&(S=n.x+n.w-(o.x+o.w),C=n.x+n.w-(r.x+r.w));s=m({},{_textLeftOffset:S}),l=m({},{_textLeftOffset:C})}else l=m({},{text:""})}o.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},s),r.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},l)}),(function(t){var e,n=t.sourceRect,a=t.topRect,o=t.bottomRect,r={},s={};if((null===(e=n.sourceCellInfo.text)||void 0===e?void 0:e.length)>0){var l,c=i.getTextDimensions(n.sourceCellInfo.text).h>a.h,u="top"===(null===(l=n.sourceCellInfo)||void 0===l?void 0:l.verticalAlign);if(c||!u){var d,h,f,p,g,_;if("top"===(null===(d=n.sourceCellInfo)||void 0===d?void 0:d.verticalAlign))g=(p=null!==(_=n.sourceCellInfo._textTopOffset)&&void 0!==_?_:0)-a.h;else if("middle"===(null===(h=n.sourceCellInfo)||void 0===h?void 0:h.verticalAlign)){var v,b=null!==(v=n.sourceCellInfo._textTopOffset)&&void 0!==v?v:0;p=b+(n.y+n.h/2)-(a.y+a.h/2),g=b+(n.y+n.h/2)-(o.y+o.h/2)}else"bottom"===(null===(f=n.sourceCellInfo)||void 0===f?void 0:f.verticalAlign)&&(p=n.y+n.h-(a.y+a.h),g=n.y+n.h-(o.y+o.h));r=m({},{_textTopOffset:p}),s=m({},{_textTopOffset:g})}else s=m({},{text:""})}a.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},r),o.sourceCellInfo=m({},n.sourceCellInfo,{debugSourceCellInfo:n.sourceCellInfo},s)}));_&&(0,h.applyRtl)(i,v,t),v.forEach((function(e,n){if(n>0&&(0,d.addNewPage)(i),(0,d.drawCellsContent)(i,t.customDrawCell,e,g),(0,d.drawCellsLines)(i,e,g),(0,a.isDefined)(e)&&0===e.length){var o=(0,s.calculateTableSize)(i,e,t),r=(0,c.getBaseTableStyle)();(0,d.drawGridLines)(i,o,r,g)}})),(0,d.setDocumentStyles)(i,g),e()})).always((function(){b&&o.option("loadPanel.enabled",b),_.enabled&&(0,g.hasWindow)()&&n.dispose()}))}))}};e.Export=_},41269:function(t,e,n){e.updateRowsAndCellsHeights=function(t,e){var n=function(t,e){var n=Array.from({length:e.length},(function(){return 0}));return s(e).forEach((function(o){o.cells.filter((function(t){return(0,i.isDefined)(t.rowSpan)})).forEach((function(i){var r=(0,a.calculateTargetRectWidth)(i.pdfCell._rect.w,i.pdfCell.padding),s=(0,a.calculateTextHeight)(t,i.pdfCell.text,i.pdfCell.font,{wordWrapEnabled:i.pdfCell.wordWrapEnabled,targetRectWidth:r})+i.pdfCell.padding.top+i.pdfCell.padding.bottom,l=i.rowSpan+1,c=e.slice(o.rowIndex,o.rowIndex+l).reduce((function(t,e){return t+e.height+n[e.rowIndex]}),0);if(s>c)for(var u=(s-c)/l,d=o.rowIndex;d<o.rowIndex+l;d++)n[d]+=u}))})),n}(t,e);e.forEach((function(t){t.height+=n[t.rowIndex]})),e.forEach((function(t){t.cells.forEach((function(n){var i,a=(null!==(i=n.rowSpan)&&void 0!==i?i:0)+1;n.pdfCell._rect.h=e.slice(t.rowIndex,t.rowIndex+a).reduce((function(t,e){return t+e.height}),0)}))}))};var i=n(35922),a=n(79262);function o(t){return function(t){if(Array.isArray(t))return r(t)}(t)||function(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}(t)||function(t,e){if(!t)return;if("string"==typeof t)return r(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return r(t,e)}(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function r(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function s(t){var e=function(t){var e=t.cells.map((function(t){var e;return null!==(e=t.rowSpan)&&void 0!==e?e:0}));return Math.max.apply(Math,o(e))};return o(t).sort((function(t,n){var i=e(t),a=e(n);return i>a?1:a>i?-1:0}))}},30646:function(t,e,n){e.normalizeBoundaryValue=a,e.normalizeRowsInfo=function(t){t.forEach((function(t){t.cells.forEach((function(t){var e=t.pdfCell;e.padding=a(e.padding)}))}))};var i=n(35922);function a(t){var e,n,a,o;return(0,i.isNumeric)(t)?{top:t,right:t,bottom:t,left:t}:{top:null!==(e=null==t?void 0:t.top)&&void 0!==e?e:0,right:null!==(n=null==t?void 0:t.right)&&void 0!==n?n:0,bottom:null!==(a=null==t?void 0:t.bottom)&&void 0!==a?a:0,left:null!==(o=null==t?void 0:t.left)&&void 0!==o?o:0}}},79262:function(t,e,n){e.applyRtl=function(t,e,n){e.forEach((function(e){e.forEach((function(e){var i=a(t)-(e._rect.x+e._rect.w),o=n.margin.left-n.margin.right;e._rect.x=i+o}))}))},e.applyWordWrap=function(t,e){e.forEach((function(e){e.cells.forEach((function(e){var n=e.pdfCell;if((0,i.isDefined)(n.text)){var a=o(t,n.text,n.font,{wordWrapEnabled:n.wordWrapEnabled,targetRectWidth:r(n._rect.w,n.padding)});n.text=a.join("\n")}}))}))},e.calculateRowHeight=function(t,e,n){if(e.length!==n.length)throw"the cells count must be equal to the count of the columns";for(var a=0,o=0;o<e.length;o++)if(!(0,i.isDefined)(e[o].rowSpan)){var s=e[o].pdfCell.text,c=e[o].pdfCell.padding,u=e[o].pdfCell.font,d=e[o].pdfCell.wordWrapEnabled,h=r(n[o],c);if((0,i.isDefined)(s)){var f=(""!==s?l(t,s,u,{wordWrapEnabled:d,targetRectWidth:h}):0)+c.top+c.bottom;a<f&&(a=f)}}return a},e.calculateTargetRectWidth=r,e.calculateTextHeight=l,e.getPageHeight=function(t){return t.internal.pageSize.getHeight()},e.getPageWidth=a,e.getTextDimensions=s,e.getTextLines=o,e.toPdfUnit=function(t,e){var n=1/t.internal.scaleFactor;return e*n};var i=n(35922);function a(t){return t.internal.pageSize.getWidth()}function o(t,e,n,i){var a=i.wordWrapEnabled,o=i.targetRectWidth;if(a){var r=t.getFont(null==n?void 0:n.name,null==n?void 0:n.style);return t.splitTextToSize(e,o,{fontSize:(null==n?void 0:n.size)||t.getFontSize(),fontName:r.fontName,fontStyle:r.fontStyle})}var l=e.split("\n").filter((function(t){return""!==t})).join(" ");if(s(t,l,n).w<=o)return[l];for(var c=s(t,l+"...",n).w;l.length>0&&c>o;){var u=0;c>=2*o&&(u=l.length/2),u<1&&(u=1),c=s(t,(l=l.substring(0,l.length-u))+"...",n).w}return[l+"..."]}function r(t,e){var n=t-(e.left+e.right);return n>=0?n:0}function s(t,e,n){return t.getTextDimensions(e,{font:t.getFont(null==n?void 0:n.name,null==n?void 0:n.style),fontSize:(null==n?void 0:n.size)||t.getFontSize()})}function l(t,e,n,i){var a=i.wordWrapEnabled,r=i.targetRectWidth;return s(t,e,n).h*o(t,e,n,{wordWrapEnabled:a,targetRectWidth:r}).length*t.getLineHeightFactor()}},65322:function(t,e,n){e.applyBordersConfig=function(t){for(var e=0;e<t.length;e++)for(var n=t[e].cells,a=0;a<n.length;a++){var o=n[a].pdfCell,r=a>=1?n[a-1].pdfCell:null,s=e>=1?t[e-1].cells[a].pdfCell:null;!1!==o.drawLeftBorder||(0,i.isDefined)(n[a].colSpan)?(0,i.isDefined)(o.drawLeftBorder)||(0,i.isDefined)(r)&&!1===r.drawRightBorder&&(o.drawLeftBorder=!1):(0,i.isDefined)(r)&&(r.drawRightBorder=!1),!1===o.drawTopBorder?(0,i.isDefined)(s)&&(s.drawBottomBorder=!1):(0,i.isDefined)(o.drawTopBorder)||(0,i.isDefined)(s)&&!1===s.drawBottomBorder&&(o.drawTopBorder=!1)}},e.applyColSpans=function(t){for(var e=0;e<t.length;e++)for(var n=t[e],a=0;a<n.cells.length;a++){var o=n.cells[a];if((0,i.isDefined)(o.colSpan)&&!(0,i.isDefined)(o.pdfCell.isMerged))for(var r=1;r<=o.colSpan;r++){var s=t[e].cells[a+r];o.pdfCell._rect.w+=s.pdfCell._rect.w,s.pdfCell._rect.w=0,s.pdfCell.isMerged=!0}}},e.applyRowSpans=function(t){for(var e=0;e<t.length;e++)for(var n=t[e],a=0;a<n.cells.length;a++){var o=n.cells[a];if((0,i.isDefined)(o.rowSpan)&&!(0,i.isDefined)(o.pdfCell.isMerged))for(var r=1;r<=o.rowSpan;r++){var s=t[e+r].cells[a];o.pdfCell._rect.h+=s.pdfCell._rect.h,s.pdfCell._rect.h=0,s.pdfCell.isMerged=!0}}},e.calculateCoordinates=function(t,e,n){var i,a=null==n?void 0:n.topLeft,o=null==n?void 0:n.margin,r=(null!==(i=null==a?void 0:a.y)&&void 0!==i?i:0)+o.top;e.forEach((function(t){var e,i=(null!==(e=null==a?void 0:a.x)&&void 0!==e?e:0)+o.left,s=t.indentLevel*n.indent;t.cells.forEach((function(t){t.pdfCell._rect.x=i+s,t.pdfCell._rect.y=r,i+=t.pdfCell._rect.w})),r+=t.height}))},e.calculateHeights=function(t,e,n){e.forEach((function(e){var o,r=e.cells.map((function(t){return t.pdfCell}));if(n.onRowExporting){var s={rowCells:r};n.onRowExporting(s),(0,i.isDefined)(s.rowHeight)&&(o=s.rowHeight)}e.height=(0,i.isDefined)(o)?o:(0,a.calculateRowHeight)(t,e.cells,r.map((function(t){return t._rect.w}))),r.forEach((function(t){t._rect.h=e.height}))}))},e.calculateTableSize=function(t,e,n){var a,o,r,s,l,c,u,d,h,f;e.forEach((function(t){(!(0,i.isDefined)(u)||u>t._rect.x)&&(u=t._rect.x),(!(0,i.isDefined)(d)||d>t._rect.y)&&(d=t._rect.y),(!(0,i.isDefined)(h)||h<t._rect.x+t._rect.w)&&(h=t._rect.x+t._rect.w),(!(0,i.isDefined)(f)||f<t._rect.y+t._rect.h)&&(f=t._rect.y+t._rect.h)}));var p=null!==(a=null!==(o=u)&&void 0!==o?o:null==n||null===(r=n.topLeft)||void 0===r?void 0:r.x)&&void 0!==a?a:0,g=null!==(s=null!==(l=d)&&void 0!==l?l:null==n||null===(c=n.topLeft)||void 0===c?void 0:c.y)&&void 0!==s?s:0,m=(0,i.isDefined)(h)?h-p:0,_=(0,i.isDefined)(f)?f-g:0;return{x:p,y:g,w:m,h:_}},e.initializeCellsWidth=function(t,e,n,r){var s=function(t,e,n,r,s){var l=e.getColumnsWidths().map((function(e){return(0,a.toPdfUnit)(t,null!=e?e:150)})),c=l.filter((function(t,e){return!(0,i.isDefined)(s[e])})).reduce(o,0),u=s.filter((function(t){return(0,i.isNumeric)(t)})).reduce(o,0),d=function(t,e,n){return(0,a.getPageWidth)(t)-e-n.left-n.right}(t,n,r),h=u<d?(d-u)/c:1;return l.map((function(t,e){var n;return null!==(n=s[e])&&void 0!==n?n:t*h}))}(t,e,r.topLeft.x,r.margin,r.columnWidths);n.forEach((function(t){t.cells.forEach((function(t,e){t.gridCell;t.pdfCell._rect.w=s[e]}))}))},e.resizeFirstColumnByIndentLevel=function(t,e){t.forEach((function(t){t.cells[0].pdfCell._rect.w-=t.indentLevel*e.indent}))};var i=n(35922),a=n(79262),o=function(t,e){return t+e}},27504:function(t,e,n){e.generateRowsInfo=function(t,e,n,i){for(var a=[],o=e.getRowsCount(),r=!!n.option("wordWrapEnabled"),s=!!n.option("rtlEnabled"),l=e.getColumns(),c=e.getStyles(),d=0;d<o;d++){var h=e.getCellData(d,0,!0).cellSourceData.rowType,f="header"!==h?e.getGroupLevel(d):0,p=a[d-1];"groupFooter"===h&&"groupFooter"===(null==p?void 0:p.rowType)&&(f=p.indentLevel-1),a.push({rowType:h,indentLevel:f,cells:u({doc:t,dataProvider:e,rowIndex:d,wordWrapEnabled:r,columns:l,styles:c,rowType:h,backgroundColor:"header"===h?i:void 0,rtlEnabled:s}),rowIndex:d})}return a},e.getBaseTableStyle=function(){return c.base};var i=n(35922),a=s(n(91500)),o=s(n(18016)),r=n(79262);function s(t){return t&&t.__esModule?t:{default:t}}function l(){return(l=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}var c={base:{font:{size:10},borderWidth:.5,borderColor:"#979797"},header:{textColor:"#979797"},group:{},data:{},groupFooter:{},totalFooter:{}};function u(t){for(var e=t.doc,n=t.dataProvider,a=t.rowIndex,o=t.wordWrapEnabled,s=t.columns,c=t.styles,u=t.rowType,f=t.backgroundColor,p=t.rtlEnabled,g=[],m=0;m<s.length;m++){var _,v=n.getCellData(a,m,!0),b=c[n.getStyleId(a,m)],y=d(s[m],u,b),x=p?"right":"left",w=(0,r.toPdfUnit)(e,5),k={text:h(v.value,b.format),verticalAlign:"middle",horizontalAlign:null!==(_=y.alignment)&&void 0!==_?_:x,wordWrapEnabled:o,backgroundColor:f,padding:{top:w,right:w,bottom:w,left:w},_rect:{},_internalTextOptions:{}};p&&(k._internalTextOptions.isInputVisual=!1,k._internalTextOptions.isOutputVisual=!0,k._internalTextOptions.isInputRtl=!0,k._internalTextOptions.isOutputRtl=!1);var S={gridCell:v.cellSourceData,pdfCell:l({},k,y)};if("header"===u){var C=n.getCellMerging(a,m);C&&C.rowspan>0&&(S.rowSpan=C.rowspan),C&&C.colspan>0&&(S.colSpan=C.colspan)}else if("group"===u){var A=p?"drawRightBorder":"drawLeftBorder",E=p?"drawLeftBorder":"drawRightBorder";if(S.pdfCell[A]=0===m,S.pdfCell[E]=m===s.length-1,m>0){var T=g.slice(1).reduce((function(t,e){return t&&!(0,i.isDefined)(e.pdfCell.text)}),!0);if(!(0,i.isDefined)(S.pdfCell.text)&&T){g[0].pdfCell[E]=!0;for(var I=0;I<g.length;I++)g[I].colSpan=g.length;S.colSpan=g.length}}}g.push(S)}return g}function d(t,e,n){var i=l({},c.base,c[e]),a="header"===e?t.alignment:n.alignment;return a&&(i.alignment=a),n.bold&&"header"!==e&&(i.font=l({},i.font,{style:"bold"})),i}function h(t,e){if((0,i.isDefined)(e)){if((0,i.isDate)(t))return a.default.format(t,e);if((0,i.isNumeric)(t))return o.default.format(t,e)}return null==t?void 0:t.toString()}},72666:function(t,e,n){e.createOnSplitMultiPageRow=void 0;var i=n(79262);function a(){return(a=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function o(t,e,n){return a({},t,{sourceCellInfo:a({},t.sourceCellInfo,{text:e}),y:n})}e.createOnSplitMultiPageRow=function(t,e,n,a){return function(r,s){var l=[],c=[],u=0,d=0;return s.forEach((function(s){var h=s.w,f=s.sourceCellInfo,p=!r&&e.repeatHeaders?n:n+e.topLeft.y,g=(0,i.getTextDimensions)(t,f.text,f.font).h,m=f.padding.top+f.padding.bottom,_=a.y-p-m-e.margin.top,v=Math.floor(_/(g*t.getLineHeightFactor())),b=(0,i.getTextLines)(t,f.text,f.font,{wordWrapEnabled:f.wordWrapEnabled,targetRectWidth:h});if(v<b.length){var y=b.slice(0,v).join("\n"),x=(0,i.calculateTextHeight)(t,y,f.font,{wordWrapEnabled:f.wordWrapEnabled,targetRectWidth:h});u=Math.max(u,x+m),d=s.h-x,l.push(o(s,y,e.margin.top)),c.push(o(s,b.slice(v).join("\n"),e.margin.top))}else{var w=(0,i.calculateTextHeight)(t,f.text,f.font,{wordWrapEnabled:f.wordWrapEnabled,targetRectWidth:h});u=Math.max(u,w+m),d=Math.max(d,w+m),l.push(o(s,f.text,e.margin.top)),c.push(o(s,"",e.margin.top))}})),l.forEach((function(t){return t.h=u})),c.forEach((function(t){return t.h=d})),[l,c]}}},10830:function(t,e){function n(){return(n=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function i(t,e){return function(t){if(Array.isArray(t))return t}(t)||function(t,e){var n=null==t?null:"undefined"!=typeof Symbol&&t[Symbol.iterator]||t["@@iterator"];if(null!=n){var i,a,o,r,s=[],l=!0,c=!1;try{if(o=(n=n.call(t)).next,0===e){if(Object(n)!==n)return;l=!1}else for(;!(l=(i=o.call(n)).done)&&(s.push(i.value),s.length!==e);l=!0);}catch(t){c=!0,a=t}finally{try{if(!l&&null!=n.return&&(r=n.return(),Object(r)!==r))return}finally{if(c)throw a}}return s}}(t,e)||function(t,e){if(!t)return;if("string"==typeof t)return a(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);"Object"===n&&t.constructor&&(n=t.constructor.name);if("Map"===n||"Set"===n)return Array.from(t);if("Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))return a(t,e)}(t,e)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function a(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}e.getMultiPageRowPages=e.checkPageContainsOnlyHeader=void 0;var o=function(t){return"header"===(null==t?void 0:t.sourceCellInfo.gridCell.rowType)};e.checkPageContainsOnlyHeader=function(t,e){return e&&o(t[t.length-1])};e.getMultiPageRowPages=function(t,e,a,r,s){if(!r)return[];var l=t[t.length-1],c=e[t.length];if(!c||o(c))return[];if(s(a,c.h)&&!a)return[];var u=e.filter((function(t){return t.y===c.y})),d=function(t,e,a,o,r){for(var s=i(o(e,t),2),l=s[0],c=s[1],u=[e?l.map((function(t){return n({},t,{y:a})})):l];!r(!1,c[0].h);){var d=i(o(!1,c),2);l=d[0],c=d[1],u.push(l)}return[u,c]}(u,a,l.y+l.h,r,s),h=i(d,2),f=h[0];return function(t,e,n){e.forEach((function(t,e){t.sourceCellInfo.text=n[e].sourceCellInfo.text,t.h=n[e].h}));var i=t.indexOf(e[e.length-1])+1;if(!(i>=t.length))for(var a=t[i].y-(e[0].y+n[0].h),o=i;o<t.length;o++)t[o].y=t[o].y-a}(e,u,h[1]),f}},22775:function(t,e,n){e.splitByPages=function(t,e,n,i,r){if(0===e.length)return[[]];var l={x:(0,a.getPageWidth)(t)-n.margin.right,y:(0,a.getPageHeight)(t)-n.margin.bottom},u=e.filter((function(t){return"header"===t.rowType})),d=u.reduce((function(t,e){return t+e.height}),0),h=g(p(e),n.margin.top,"y","h",(function(t,e){var i=!t&&n.repeatHeaders?d:0;return(0,o.roundToThreeDecimals)(e+i)<=(0,o.roundToThreeDecimals)(l.y)}),(function(t,e,n,i){var a={sourceRect:t,topRect:{x:t.x,y:t.y,w:t.w,h:e-t.y},bottomRect:{x:t.x,y:e,w:t.w,h:t.h-(e-t.y)}};r(a),n.push(a.topRect),i.push(a.bottomRect)}),(0,s.createOnSplitMultiPageRow)(t,n,d,l));if(n.repeatHeaders)for(var m=1;m<h.length;m++){h[m].forEach((function(t){return t.y+=d}));var _=p(u);_.forEach((function(t){t.y-=n.topLeft.y})),h[m]=[].concat(c(_),c(h[m]))}var v=0;for(;v<h.length;){var b=g(h[v],n.margin.left,"x","w",(function(t,e){return(0,o.roundToThreeDecimals)(e)<=(0,o.roundToThreeDecimals)(l.x)}),(function(t,e,n,a){var o={sourceRect:t,leftRect:{x:t.x,y:t.y,w:e-t.x,h:t.h},rightRect:{x:e,y:t.y,w:t.w-(e-t.x),h:t.h}};i(o),n.push(o.leftRect),a.push(o.rightRect)}));b.length>1?(h.splice.apply(h,[v,1].concat(c(b))),v+=b.length):v+=1}return h.map((function(t){return t.map((function(t){return f({},t.sourceCellInfo,{_rect:t})}))}))};var i=n(35922),a=n(79262),o=n(66867),r=n(10830),s=n(72666);function l(t){return function(t){if(Array.isArray(t))return t}(t)||d(t)||u(t)||function(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function c(t){return function(t){if(Array.isArray(t))return h(t)}(t)||d(t)||u(t)||function(){throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function u(t,e){if(t){if("string"==typeof t)return h(t,e);var n=Object.prototype.toString.call(t).slice(8,-1);return"Object"===n&&t.constructor&&(n=t.constructor.name),"Map"===n||"Set"===n?Array.from(t):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?h(t,e):void 0}}function d(t){if("undefined"!=typeof Symbol&&null!=t[Symbol.iterator]||null!=t["@@iterator"])return Array.from(t)}function h(t,e){(null==e||e>t.length)&&(e=t.length);for(var n=0,i=new Array(e);n<e;n++)i[n]=t[n];return i}function f(){return(f=Object.assign?Object.assign.bind():function(t){for(var e=1;e<arguments.length;e++){var n=arguments[e];for(var i in n)Object.prototype.hasOwnProperty.call(n,i)&&(t[i]=n[i])}return t}).apply(this,arguments)}function p(t){return[].concat.apply([],t.map((function(t){return t.cells.filter((function(t){return!(0,i.isDefined)(t.pdfCell.isMerged)})).map((function(t){return f({},t.pdfCell._rect,{sourceCellInfo:f({},t.pdfCell,{gridCell:t.gridCell})})}))})))}function g(t,e,n,a,o,s,u){for(var d=[],h=c(t),f=function(t,n){return o(t,n+e)},p=function(){var t=0,p=h.filter((function(e){var i=e[n]+e[a];return!!o(0===d.length,i)&&(t<=i&&(t=i),!0)})),g=(0,r.checkPageContainsOnlyHeader)(p,0===d.length),m=(0,r.getMultiPageRowPages)(p,h,g,u,f);if(h.filter((function(e){var i=e[n],o=e[n]+e[a];return t-i>.001&&o-t>.001})).forEach((function(e){s(e,t,p,h);var n=h.indexOf(e);-1!==n&&h.splice(n,1)})),p.forEach((function(t){var e=h.indexOf(t);-1!==e&&h.splice(e,1)})),h.forEach((function(a){a[n]=(0,i.isDefined)(t)?a[n]-t+e:a[n]})),g&&m.length>0){var _=l(m),v=_[0],b=_.slice(1);d.push([].concat(c(p),c(v))),d.push.apply(d,c(b))}else if(p.length>0)d.push(p),d.push.apply(d,c(m));else{if(!(m.length>0))return d.push(h),"break";d.push.apply(d,c(m)),d.push(h)}};h.length>0;){if("break"===p())break}return d}},654:function(t,e,n){e.exportDataGrid=function(t){return r.Export.export(function(t){if(!(0,a.isDefined)(t)||!(0,a.isObject)(t))throw Error('The "exportDataGrid" method requires a configuration object.');if(!(0,a.isDefined)(t.component)||!(0,a.isObject)(t.component)||"dxDataGrid"!==t.component.NAME)throw Error('The "component" field must contain a DataGrid instance.');if(!(0,a.isDefined)(t.jsPDFDocument)||!(0,a.isObject)(t.jsPDFDocument))throw Error('The "jsPDFDocument" field must contain a jsPDF instance.');(0,a.isDefined)(t.autoTableOptions)&&o.default.log("W0001","Export","autoTableOptions","22.1","You can migrate from exporting to PDF with the AutoTable plugin to a new export system. See the following topic for more information: ".concat("https://supportcenter.devexpress.com/ticket/details/t1077554"));return r.Export.getFullOptions(t)}(t))};var i,a=n(35922),o=(i=n(17381))&&i.__esModule?i:{default:i},r=n(17195)},29982:function(t,e){e.exportGantt=function(t){var e=t.component;return null==e?void 0:e.exportToPdf(t)}},30855:function(t,e,n){e.getData=function(t,e){return o.imageCreator.getImageData(t,(0,s.extend)({},e,{format:"JPEG"})).then((function(t){var n,a,s=function(t,e,n){var a=2*(e.margin||0),r=(0,o.calcScaledInfo)(e.width,e.height),s=r.width,l=r.height;l+=a;var u=(.75*(s+=a)).toFixed(2),d=(.75*l).toFixed(2),h=Math.floor(s),f=Math.floor(l),p="%PDF-1.3\r\n2 0 obj\r\n<</ProcSet[/PDF/ImageB/ImageC/ImageI]/XObject<</I0 5 0 R>>>>\r\nendobj\r\n4 0 obj\r\n<</Type/Pages/Kids[1 0 R]/Count 1>>\r\nendobj\r\n7 0 obj\r\n<</OpenAction[1 0 R /FitH null]/Type/Catalog/Pages 4 0 R/PageLayout/OneColumn>>\r\nendobj\r\n1 0 obj\r\n<</Type/Page/Resources 2 0 R/MediaBox[0 0 _width_ _height_]/Contents 3 0 R/Parent 4 0 R>>\r\nendobj\r\n".replace("_width_",u).replace("_height_",d),g="3 0 obj\r\n<</Length 52>>stream\r\n0.20 w\n0 G\nq _width_ 0 0 _height_ 0.00 0.00 cm /I0 Do Q\r\nendstream\r\nendobj\r\n".replace("_width_",u).replace("_height_",d),m="6 0 obj\r\n<</CreationDate _date_/Producer(DevExtreme _version_)>>\r\nendobj\r\n".replace("_date_",n).replace("_version_",i.version),_="5 0 obj\r\n<</Type/XObject/Subtype/Image/Width _width_/Height _height_/ColorSpace/DeviceRGB/BitsPerComponent 8/Filter/DCTDecode/Length _length_>>stream\r\n".replace("_width_",h).replace("_height_",f).replace("_length_",t.length)+t+"\r\nendstream\r\nendobj\r\n",v=(x=p.length,w=g.length,k=m.length,"xref\r\n0 8\r\n0000000000 65535 f\r\n0000000241 00000 n\r\n0000000010 00000 n\r\n_main_ 00000 n\r\n0000000089 00000 n\r\n_image_ 00000 n\r\n_info_ 00000 n\r\n0000000143 00000 n\r\n".replace("_main_",c(x+"",10)).replace("_info_",c(x+w+"",10)).replace("_image_",c(x+w+k+"",10))),b=p+g+m+_,y="trailer\r\n<<\r\n/Size 8\r\n/Root 7 0 R\r\n/Info 6 0 R\r\n>>\r\nstartxref\r\n_length_\r\n%%EOF".replace("_length_",b.length);var x,w,k;return b+v+y}(t,e,(n=new Date,a=[n.getUTCFullYear(),u(n.getUTCMonth()),u(n.getUTCDate()),u(n.getUTCHours()),u(n.getUTCMinutes()),u(n.getUTCSeconds())],"(D:".concat(a.join(""),"Z00'00')")));return(0,r.isFunction)(l.Blob)?function(t){for(var e=0,n=new Uint8Array(t.length);e<t.length;e++)n[e]=t.charCodeAt(e);return new l.Blob([n.buffer],{type:"application/pdf"})}(s):function(t){return l.btoa(t)}(s)}))};var i=n(36739),a=n(58201),o=n(12173),r=n(35922),s=n(13306),l=(0,a.getWindow)(),c=function t(e,n){return e.length<n?t("0"+e,n):e};function u(t){return 1===t.toString().length?"0".concat(t):t}},37596:function(t,e,n){e.getData=function(t,e){return h.getData(t,e)},e.svgCreator=void 0;var i=u(n(68374)),a=u(n(37208)),o=n(58201),r=n(35922),s=n(95479),l=n(19155),c=n(62754);function u(t){return t&&t.__esModule?t:{default:t}}var d=(0,o.getWindow)(),h={_markup:"",_imageArray:{},_imageDeferreds:[],_getBinaryFile:function(t,e){a.default.sendRequest({url:t,method:"GET",responseType:"arraybuffer"}).done(e).fail((function(){e(!1)}))},_loadImages:function(){var t=this;(0,s.each)(t._imageArray,(function(e){var n=new c.Deferred;t._imageDeferreds.push(n),t._getBinaryFile(e,(function(i){if(!i)return delete t._imageArray[e],void n.resolve();var a,o="",r=new Uint8Array(i),s=r.byteLength;for(a=0;a<s;a++)o+=String.fromCharCode(r[a]);t._imageArray[e]="data:image/png;base64,"+d.btoa(o),n.resolve()}))}))},_parseImages:function(t){var e,n=this;"image"===t.tagName&&(e=(0,i.default)(t).attr("href")||(0,i.default)(t).attr("xlink:href"),n._imageArray[e]||(n._imageArray[e]="")),(0,s.each)(t.childNodes,(function(t,e){n._parseImages(e)}))},_prepareImages:function(t){return this._parseImages(t),this._loadImages(),c.when.apply(i.default,this._imageDeferreds)},getData:function(t,e){var n,a=this,o=(0,l.getSvgElement)(t),c=(0,i.default)(o);return c.find("[".concat(l.HIDDEN_FOR_EXPORT,"]")).remove(),n='<?xml version="1.0" encoding="UTF-8" standalone="yes" ?>'+(0,l.getSvgMarkup)(c.get(0),e.backgroundColor),a._prepareImages(o).then((function(){return(0,s.each)(a._imageArray,(function(t,e){var i="href=['|\"]".concat(t,"['|\"]");n=n.replace(new RegExp(i,"gi"),'href="'.concat(e,'"'))})),(0,r.isFunction)(d.Blob)?a._getBlob(n):a._getBase64(n)}))},_getBlob:function(t){return new d.Blob([t],{type:"image/svg+xml"})},_getBase64:function(t){return d.btoa(t)}};e.svgCreator=h},30343:function(t,e,n){e.default=void 0;var i=n(35922),a=l(n(91198)),o=l(n(18016)),r=l(n(91500)),s=l(n(20476));function l(t){return t&&t.__esModule?t:{default:t}}n(89740);var c=(0,s.default)({format:function(t,e){var n=(0,i.isString)(e)&&""!==e||(0,i.isPlainObject)(e)||(0,i.isFunction)(e),a=(0,i.isNumeric)(t)||(0,i.isDate)(t);return n&&a?(0,i.isFunction)(e)?e(t):((0,i.isString)(e)&&(e={type:e}),(0,i.isNumeric)(t)?o.default.format(t,e):(0,i.isDate)(t)?r.default.format(t,e):void 0):(0,i.isDefined)(t)?t.toString():""},getTimeFormat:function(t){return t?"longtime":"shorttime"},_normalizeFormat:function(t){return Array.isArray(t)?1===t.length?t[0]:function(e){return t.map((function(t){return r.default.format(e,t)})).join(" ")}:t},getDateFormatByDifferences:function(t,e){var n=[],i=e&&t.millisecond&&!(t.year||t.month||t.day);if(i){n.push((function(t){return t.getSeconds()+t.getMilliseconds()/1e3+"s"}))}else t.millisecond&&n.push("millisecond");if((t.hour||t.minute||!i&&t.second)&&n.unshift(this.getTimeFormat(t.second)),t.year&&t.month&&t.day)return e&&"month"===e?"monthandyear":(n.unshift("shortdate"),this._normalizeFormat(n));if(t.year&&t.month)return"monthandyear";if(t.year&&t.quarter)return"quarterandyear";if(t.year)return"year";if(t.quarter)return"quarter";if(t.month&&t.day){if(e){n.unshift((function(t){return r.default.getMonthNames("abbreviated")[t.getMonth()]+" "+r.default.format(t,"day")}))}else n.unshift("monthandday");return this._normalizeFormat(n)}if(t.month)return"month";if(t.day){if(e)n.unshift("day");else{n.unshift((function(t){return r.default.format(t,"dayofweek")+", "+r.default.format(t,"day")}))}return this._normalizeFormat(n)}return this._normalizeFormat(n)},getDateFormatByTicks:function(t){var e,n,i;if(t.length>1)for(e=a.default.getDatesDifferences(t[0],t[1]),i=1;i<t.length-1;i++)n=a.default.getDatesDifferences(t[i],t[i+1]),e.count<n.count&&(e=n);else e={year:!0,month:!0,day:!0,hour:t[0].getHours()>0,minute:t[0].getMinutes()>0,second:t[0].getSeconds()>0,millisecond:t[0].getMilliseconds()>0};return this.getDateFormatByDifferences(e)},getDateFormatByTickInterval:function(t,e,n){var o,r=function(t,e,n){switch(e){case"year":case"quarter":t.month=n;case"month":t.day=n;case"week":case"day":t.hour=n;case"hour":t.minute=n;case"minute":t.second=n;case"second":t.millisecond=n}};n=(0,i.isString)(n)?n.toLowerCase():n;var s,l,c,u=a.default.getDatesDifferences(t,e);return t!==e&&(s=u,l=t>e?e:t,!(c=t>e?t:e).getMilliseconds()&&c.getSeconds()?c.getSeconds()-l.getSeconds()==1&&(s.millisecond=!0,s.second=!1):!c.getSeconds()&&c.getMinutes()?c.getMinutes()-l.getMinutes()==1&&(s.second=!0,s.minute=!1):!c.getMinutes()&&c.getHours()?c.getHours()-l.getHours()==1&&(s.minute=!0,s.hour=!1):!c.getHours()&&c.getDate()>1?c.getDate()-l.getDate()==1&&(s.hour=!0,s.day=!1):1===c.getDate()&&c.getMonth()?c.getMonth()-l.getMonth()==1&&(s.day=!0,s.month=!1):!c.getMonth()&&c.getFullYear()&&c.getFullYear()-l.getFullYear()==1&&(s.month=!0,s.year=!1)),r(u,o=a.default.getDateUnitInterval(u),!0),r(u,o=a.default.getDateUnitInterval(n||"second"),!1),u[{week:"day"}[o]||o]=!0,this.getDateFormatByDifferences(u)}});e.default=c,t.exports=e.default,t.exports.default=e.default},71582:function(t,e,n){n(78475),n(38971),n(12993),n(11579),n(21298)},21298:function(t,e,n){var i=a(n(62414));function a(t){return t&&t.__esModule?t:{default:t}}a(n(62387)).default&&i.default.registerExecutor({ngExpression:{execute:function(t){"string"==typeof t.action&&t.context.$eval(t.action)}}})},38971:function(t,e,n){var i=x(n(68374)),a=x(n(62387)),o=x(n(55994)),r=x(n(80209)),s=x(n(5554)),l=x(n(38377)),c=x(n(44504)),u=n(35922),d=n(95479),h=x(n(88933)),f=x(n(96452)),p=n(76165),g=x(n(69155)),m=x(n(11050)),_=n(47617),v=n(13306),b=n(49036),y=n(78008);function x(t){return t&&t.__esModule?t:{default:t}}function w(t){return(w="function"==typeof Symbol&&"symbol"==typeof Symbol.iterator?function(t){return typeof t}:function(t){return t&&"function"==typeof Symbol&&t.constructor===Symbol&&t!==Symbol.prototype?"symbol":typeof t})(t)}if(a.default){var k=function(t,e){return e.$root.$$phase?t(e):e.$apply((function(){return t(e)}))},S=l.default.inherit({ctor:function(t){this._componentDisposing=(0,c.default)(),this._optionChangedCallbacks=(0,c.default)(),this._ngLocker=new h.default,this._scope=t.scope,this._$element=t.$element,this._$templates=t.$templates,this._componentClass=t.componentClass,this._parse=t.parse,this._compile=t.compile,this._itemAlias=t.itemAlias,this._transcludeFn=t.transcludeFn,this._digestCallbacks=t.dxDigestCallbacks,this._normalizeOptions(t.ngOptions),this._initComponentBindings(),this._initComponent(this._scope),t.ngOptions||this._addOptionsStringWatcher(t.ngOptionsString)},_addOptionsStringWatcher:function(t){var e=this,n=this._scope.$watch(t,(function(t){t&&(n(),e._normalizeOptions(t),e._initComponentBindings(),e._component.option(e._evalOptions(e._scope)))}));this._componentDisposing.add(n)},_normalizeOptions:function(t){var e=this;this._ngOptions=(0,v.extendFromObject)({},t),t&&(!Object.prototype.hasOwnProperty.call(t,"bindingOptions")&&t.bindingOptions&&(this._ngOptions.bindingOptions=t.bindingOptions),t.bindingOptions&&(0,d.each)(t.bindingOptions,(function(t,n){"string"===(0,u.type)(n)&&(e._ngOptions.bindingOptions[t]={dataPath:n})})))},_initComponent:function(t){this._component=new this._componentClass(this._$element,this._evalOptions(t)),this._component._isHidden=!0,this._handleDigestPhase()},_handleDigestPhase:function(){var t=this,e=function(){t._component.beginUpdate()},n=function(){t._component.endUpdate()};this._digestCallbacks.begin.add(e),this._digestCallbacks.end.add(n),this._componentDisposing.add((function(){t._digestCallbacks.begin.remove(e),t._digestCallbacks.end.remove(n)}))},_initComponentBindings:function(){var t=this,e={};this._ngOptions.bindingOptions&&((0,d.each)(this._ngOptions.bindingOptions,(function(n,i){var a,o,r=n.search(/\[|\./),s=r>-1?n.substring(0,r):n,l=i.dataPath,c=!0,u=!1;void 0!==i.deep&&(u=c=!!i.deep),e[s]||(e[s]={}),e[s][n]=l;!function e(){var i=Array.isArray(t._scope.$eval(l))&&!u?"$watchCollection":"$watch";a!==i&&(o&&o(),o=t._scope[i](l,(function(i,a){t._ngLocker.locked(n)||(t._ngLocker.obtain(n),t._component.option(n,i),e(),(0,b.equals)(a,i)&&t._ngLocker.locked(n)&&t._ngLocker.release(n))}),c),a=i)}(),t._componentDisposing.add(o)})),this._optionChangedCallbacks.add((function(n){var i=n.name,a=n.fullName,o=n.component;if(t._ngLocker.locked(a))t._ngLocker.release(a);else if(e&&e[i]){var r=t._scope.$root.$$phase,s=function(){t._ngLocker.obtain(a)};r?t._digestCallbacks.begin.add(s):s(),k((function(){(0,d.each)(e[i],(function(e,i){if(t._optionsAreLinked(a,e)){var r=o.option(e);t._parse(i).assign(t._scope,r);var s=t._parse(i)(t._scope);s!==r&&n.component.option(e,s)}}))}),t._scope);var l=function e(){t._ngLocker.locked(a)&&t._ngLocker.release(a),t._digestCallbacks.begin.remove(s),t._digestCallbacks.end.remove(e)};r?t._digestCallbacks.end.addPrioritized(l):l()}})))},_optionsAreNested:function(t,e){var n=t[e.length];return 0===t.indexOf(e)&&("."===n||"["===n)},_optionsAreLinked:function(t,e){return t===e||(t.length>e.length?this._optionsAreNested(t,e):this._optionsAreNested(e,t))},_compilerByTemplate:function(t){var e=this,n=this._getScopeItemsPath();return function(a){var r=(0,i.default)(t).clone(),s=a.model&&a.model.constructor===e._scope.$root.constructor?a.model:a.noModel?e._scope:e._createScopeWithData(a);n&&e._synchronizeScopes(s,n,a.index),r.appendTo(a.container),a.noModel||o.default.on(r,"$destroy",(function(){!s.$parent||s.$destroy()}));var l=e._compile(r,e._transcludeFn);return e._applyAsync((function(t){l(t,null,{parentBoundTranscludeFn:e._transcludeFn})}),s),r}},_applyAsync:function(t,e){var n=this;if(t(e),!e.$root.$$phase&&!this._renderingTimer){var i=function(){clearTimeout(n._renderingTimer)};this._renderingTimer=setTimeout((function(){e.$apply(),n._renderingTimer=null,n._componentDisposing.remove(i)})),this._componentDisposing.add(i)}},_getScopeItemsPath:function(){if(this._componentClass.subclassOf(m.default)&&this._ngOptions.bindingOptions&&this._ngOptions.bindingOptions.items)return this._ngOptions.bindingOptions.items.dataPath},_createScopeWithData:function(t){var e=this._scope.$new();return this._itemAlias&&(e[this._itemAlias]=t.model),(0,u.isDefined)(t.index)&&(e.$index=t.index),e},_synchronizeScopes:function(t,e,n){this._itemAlias&&"object"!==w(t[this._itemAlias])&&this._synchronizeScopeField({parentScope:this._scope,childScope:t,fieldPath:this._itemAlias,parentPrefix:e,itemIndex:n})},_synchronizeScopeField:function(t){var e=t.parentScope,n=t.childScope,i=t.fieldPath,a=t.parentPrefix,o=t.itemIndex,r=i===this._itemAlias?"":"."+i,s=void 0!==o,l=[a];if(s){if(!(0,u.isNumeric)(o))return;l.push("[",o,"]")}l.push(r);var c=l.join(""),d=e.$watch(c,(function(t,e){t!==e&&(0,_.compileSetter)(i)(n,t)})),h=n.$watch(i,(function(t,n){if(t!==n){if(s&&!(0,_.compileGetter)(a)(e)[o])return void h();(0,_.compileSetter)(c)(e,t)}}));this._componentDisposing.add([d,h])},_evalOptions:function(t){var e=this,n=(0,v.extendFromObject)({},this._ngOptions);return delete n.bindingOptions,this._ngOptions.bindingOptions&&(0,d.each)(this._ngOptions.bindingOptions,(function(e,i){n[e]=t.$eval(i.dataPath)})),n._optionChangedCallbacks=this._optionChangedCallbacks,n._disposingCallbacks=this._componentDisposing,n.onActionCreated=function(e,n,i){if(i&&"rendering"===i.category)return n;return function(){var e=this,i=arguments;return t&&t.$root&&!t.$root.$$phase?k((function(){return n.apply(e,i)}),t):n.apply(this,i)}},n.beforeActionExecute=n.onActionCreated,n.nestedComponentOptions=function(t){return{templatesRenderAsynchronously:t.option("templatesRenderAsynchronously"),forceApplyBindings:t.option("forceApplyBindings"),modelByElement:t.option("modelByElement"),onActionCreated:t.option("onActionCreated"),beforeActionExecute:t.option("beforeActionExecute"),nestedComponentOptions:t.option("nestedComponentOptions")}},n.templatesRenderAsynchronously=!0,(0,r.default)().wrapActionsBeforeExecute&&(n.forceApplyBindings=function(){k((function(){}),t)}),n.integrationOptions={createTemplate:function(t){return new p.NgTemplate(t,e._compilerByTemplate.bind(e))},watchMethod:function(n,i,a){var o,s=(a=a||{}).skipImmediate,l=t.$watch((function(){var t=n();return t instanceof Date&&(t=t.valueOf()),t}),(function(t){var e=o===t;!s&&(!e||e&&a.deep)&&i(t),s=!1}),a.deep);return s||(o=n(),i(o)),(0,r.default)().wrapActionsBeforeExecute&&e._applyAsync((function(){}),t),l},templates:{"dx-polymorph-widget":{render:function(t){var n=t.model.widget;if(n){var a=(0,i.default)("<div>").attr((0,y.dasherize)(n),"options").get(0),o=e._scope.$new();o.options=t.model.options,t.container.append(a),e._compile(a)(o)}}}}},n.modelByElement=function(){return t},n}});S=S.inherit({ctor:function(t){this._componentName=t.componentName,this._ngModel=t.ngModel,this._ngModelController=t.ngModelController,this.callBase.apply(this,arguments)},_isNgModelRequired:function(){return f.default.isEditor(this._componentClass.prototype)&&this._ngModel},_initComponentBindings:function(){this.callBase.apply(this,arguments),this._initNgModelBinding()},_initNgModelBinding:function(){var t=this;if(this._isNgModelRequired()){var e=this._scope.$watch(this._ngModel,(function(e,n){t._ngLocker.locked("value")||e!==n&&t._component.option("value",e)}));this._optionChangedCallbacks.add((function(e){t._ngLocker.obtain("value");try{if("value"!==e.name)return;t._ngModelController.$setViewValue(e.value)}finally{t._ngLocker.locked("value")&&t._ngLocker.release("value")}})),this._componentDisposing.add(e)}},_evalOptions:function(){if(!this._isNgModelRequired())return this.callBase.apply(this,arguments);var t=this.callBase.apply(this,arguments);return t.value=this._parse(this._ngModel)(this._scope),t}});var C={},A=function(t){var e="dxValidator"!==t?1:10;g.default.directive(t,["$compile","$parse","dxDigestCallbacks",function(n,i,a){return{restrict:"A",require:"^?ngModel",priority:e,compile:function(e){var o=C[t],r=(o.prototype._useTemplates?o.prototype._useTemplates():function t(e,n){if(!Object.prototype.hasOwnProperty.bind(e)("parent")&&e.parent){var i=Object.getPrototypeOf(e);return i.prototype[n]?function(){return i.prototype[n]()}:t(i,n)}var a=e.parent.prototype[n];return a?function(){return a()}:a&&e.parent.subclassOf?t(e.parent,n):function(){}}(o,"_useTemplates")())?e.contents().detach():null;return function(e,s,l,c,u){s.append(r),k((function(){new S({componentClass:o,componentName:t,compile:n,parse:i,$element:s,scope:e,ngOptionsString:l[t],ngOptions:l[t]?e.$eval(l[t]):{},ngModel:l.ngModel,ngModelController:c,transcludeFn:u,itemAlias:l.dxItemAlias,dxDigestCallbacks:a})}),e)}}}}])};s.default.add((function(t,e){C[t]||A(t),C[t]=e}))}},11579:function(t,e,n){var i=o(n(44504)),a=o(n(69155));function o(t){return t&&t.__esModule?t:{default:t}}o(n(62387)).default&&a.default.service("dxDigestCallbacks",["$rootScope",function(t){var e=(0,i.default)(),n=(0,i.default)(),a=(0,i.default)(),o=!1;return t.$watch((function(){o||(o=!0,e.fire(),t.$$postDigest((function(){o=!1,n.fire(),a.fire()})))})),{begin:{add:function(t){o&&t(),e.add(t)},remove:e.remove.bind(e)},end:{add:a.add.bind(a),addPrioritized:n.add.bind(n),remove:a.remove.bind(a)}}}])},12993:function(t,e,n){var i=r(n(94553)),a=r(n(55994)),o=r(n(69155));function r(t){return t&&t.__esModule?t:{default:t}}r(n(62387)).default&&i.default.add((function(t){var e=t.slice(0,2)+t.charAt(2).toUpperCase()+t.slice(3);o.default.directive(e,["$parse",function(n){return function(i,o,r){var s,l=r[e].trim(),c={};"{"===l.charAt(0)?(c=i.$eval(l),s=n(c.execute)):s=n(r[e]),a.default.on(o,t,c,(function(t){i.$apply((function(){s(i,{$event:t})}))}))}}])}))},69155:function(t,e,n){e.default=void 0;var i,a=(i=n(62387))&&i.__esModule?i:{default:i};var o={};a.default&&(o=a.default.module("dx",[]));var r=o;e.default=r,t.exports=e.default,t.exports.default=e.default},76165:function(t,e,n){e.NgTemplate=void 0;var i,a=(i=n(68374))&&i.__esModule?i:{default:i},o=n(81033),r=n(35922),s=n(3532);function l(t,e){return(l=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var c=function(t){var e,n;function i(e,n){var i;return(i=t.call(this)||this)._element=e,i._compiledTemplate=n((0,s.normalizeTemplateElement)(i._element)),i}n=t,(e=i).prototype=Object.create(n.prototype),e.prototype.constructor=e,l(e,n);var o=i.prototype;return o._renderCore=function(t){var e=this._compiledTemplate;return(0,r.isFunction)(e)?e(t):e},o.source=function(){return(0,a.default)(this._element).clone()},i}(o.TemplateBase);e.NgTemplate=c},78475:function(t,e,n){var i=s(n(96073)),a=n(58020),o=s(n(95640)),r=s(n(72722));function s(t){return t&&t.__esModule?t:{default:t}}if(n(17394),n(59228),n(66809),n(32185),n(711),n(27387),n(95063),n(63200),n(87481),n(30829),(0,r.default)()&&(0,a.compare)(i.default.fn.jquery,[1,10])<0)throw o.default.Error("E0012")},30829:function(t,e,n){var i=o(n(96073)),a=o(n(37208));function o(t){return t&&t.__esModule?t:{default:t}}(0,o(n(72722)).default)()&&a.default.inject({sendRequest:function(t){return t.responseType||t.upload?this.callBase.apply(this,[t]):i.default.ajax(t)}})},87481:function(t,e,n){var i=r(n(96073)),a=r(n(5554)),o=r(n(17381));function r(t){return t&&t.__esModule?t:{default:t}}if(i.default){a.default.add((function(t,e){i.default.fn[t]=function(n){var i,a="string"==typeof n;if(a){var r=n,s=[].slice.call(arguments).slice(1);this.each((function(){var n=e.getInstance(this);if(!n)throw o.default.Error("E0009",t);var a=n[r].apply(n,s);void 0===i&&(i=a)}))}else this.each((function(){var t=e.getInstance(this);t?t.option(n):new e(this,n)})),i=this;return i}}))}},66809:function(t,e,n){var i=r(n(96073)),a=n(62754),o=n(58020);function r(t){return t&&t.__esModule?t:{default:t}}if((0,r(n(72722)).default)()){var s=i.default.Deferred,l={Deferred:s};l.when=(0,o.compare)(i.default.fn.jquery,[3])<0?i.default.when:function(t){return 0===arguments.length?(new s).resolve():1===arguments.length?t&&t.then?t:(new s).resolve(t):i.default.when.apply(i.default,arguments)},(0,a.setStrategy)(l)}},27387:function(t,e,n){var i,a=(i=n(96073))&&i.__esModule?i:{default:i},o=n(23908);a.default&&(0,o.setEasing)(a.default.easing)},63200:function(t,e,n){var i,a=n(6415);(0,((i=n(72722))&&i.__esModule?i:{default:i}).default)()&&(0,a.setPublicElementWrapper)((function(t){return t}))},95063:function(t,e,n){var i=o(n(96073)),a=n(97906);function o(t){return t&&t.__esModule?t:{default:t}}(0,o(n(72722)).default)()&&(0,a.setDataStrategy)(i.default)},711:function(t,e,n){var i=l(n(96073)),a=l(n(55994)),o=l(n(72722)),r=l(n(94553)),s=l(n(73349));function l(t){return t&&t.__esModule?t:{default:t}}(0,o.default)()&&(r.default.add((function(t,e){i.default.event.special[t]=e})),a.default.passiveEventHandlersSupported()&&a.default.forcePassiveFalseEventNames.forEach((function(t){i.default.event.special[t]={setup:function(e,n,i){s.default.listen(this,t,i,{passive:!1})}}})),a.default.set({on:function(t){(0,i.default)(t).on.apply((0,i.default)(t),Array.prototype.slice.call(arguments,1))},one:function(t){(0,i.default)(t).one.apply((0,i.default)(t),Array.prototype.slice.call(arguments,1))},off:function(t){(0,i.default)(t).off.apply((0,i.default)(t),Array.prototype.slice.call(arguments,1))},trigger:function(t){(0,i.default)(t).trigger.apply((0,i.default)(t),Array.prototype.slice.call(arguments,1))},triggerHandler:function(t){(0,i.default)(t).triggerHandler.apply((0,i.default)(t),Array.prototype.slice.call(arguments,1))},Event:i.default.Event}))},32185:function(t,e,n){var i=r(n(96073)),a=n(89729),o=r(n(24311));function r(t){return t&&t.__esModule?t:{default:t}}if(i.default&&!a.themeReadyCallback.fired()){var s=i.default.holdReady||i.default.fn.holdReady;s(!0),a.themeReadyCallback.add((function(){o.default.add((function(){s(!1)}))}))}},59228:function(t,e,n){var i=d(n(96073)),a=d(n(72722)),o=n(58020),r=n(95479),s=n(35922),l=n(39611),c=d(n(85788)),u=d(n(2418));function d(t){return t&&t.__esModule?t:{default:t}}if((0,a.default)())if((0,o.compare)(i.default.fn.jquery,[3])<0){var h={2:"touch",3:"pen",4:"mouse"};(0,r.each)(["MSPointerDown","MSPointerMove","MSPointerUp","MSPointerCancel","MSPointerOver","MSPointerOut","mouseenter","mouseleave","pointerdown","pointermove","pointerup","pointercancel","pointerover","pointerout","pointerenter","pointerleave"],(function(){i.default.event.fixHooks[this]={filter:function(t,e){var n=e.pointerType;return(0,s.isNumeric)(n)&&(t.pointerType=h[n]),t},props:i.default.event.mouseHooks.props.concat(["pointerId","pointerType","originalTarget","width","height","pressure","result","tiltX","charCode","tiltY","detail","isPrimary","prevValue"])}})),(0,r.each)(["touchstart","touchmove","touchend","touchcancel"],(function(){i.default.event.fixHooks[this]={filter:function(t,e){return(0,u.default)((function(n,i){t[n]=i(e)})),t},props:i.default.event.mouseHooks.props.concat(["touches","changedTouches","targetTouches","detail","result","originalTarget","charCode","prevValue"])}})),i.default.event.fixHooks.wheel=i.default.event.mouseHooks;var f={props:i.default.event.mouseHooks.props.concat(["pointerType","pointerId","pointers"])};c.default.callbacks.add((function(t){i.default.event.fixHooks[t]=f}));(0,l.setEventFixMethod)((function(t,e){for(var n=i.default.event.fixHooks[e.type]||i.default.event.mouseHooks,a=n.props?i.default.event.props.concat(n.props):i.default.event.props,o=a.length;o--;){var r=a[o];t[r]=e[r]}return n.filter?n.filter(t,e):t}))}else(0,u.default)((function(t,e){i.default.event.addProp(t,e)}))},17394:function(t,e,n){var i=o(n(96073)),a=o(n(82981));function o(t){return t&&t.__esModule?t:{default:t}}(0,o(n(72722)).default)()&&a.default.set(i.default)},72722:function(t,e,n){e.default=function(){return i.default&&(0,a.default)().useJQuery};var i=o(n(96073)),a=o(n(80209));function o(t){return t&&t.__esModule?t:{default:t}}var r=(0,a.default)().useJQuery;i.default&&!1!==r&&(0,a.default)({useJQuery:!0}),t.exports=e.default,t.exports.default=e.default},49281:function(t,e,n){var i=r(n(76130)),a=r(n(17381)),o=n(58020);function r(t){return t&&t.__esModule?t:{default:t}}if(n(89135),n(70883),n(89620),n(24935),n(74942),n(27521),n(61823),i.default&&(0,o.compare)(i.default.version,[2,3])<0)throw a.default.Error("E0013")},27521:function(t,e,n){var i,a=n(97906),o=(i=n(76130))&&i.__esModule?i:{default:i},r=n(58020),s=n(45994);if(o.default){var l=o.default.utils.domNodeDisposal.cleanExternalData;(0,a.afterCleanData)((function(t){var e;for(e=0;e<t.length;e++)t[e].cleanedByJquery=!0;for(e=0;e<t.length;e++)t[e].cleanedByKo||o.default.cleanNode(t[e]),delete t[e].cleanedByKo;for(e=0;e<t.length;e++)delete t[e].cleanedByJquery})),o.default.utils.domNodeDisposal.cleanExternalData=function(t){t.cleanedByKo=!0,(0,s.getClosestNodeWithKoCreation)(t)&&(t.cleanedByJquery||(0,a.cleanData)([t]))},a.strategyChanging.add((function(t){!!t.fn&&(0,r.compare)(t.fn.jquery,[2,0])<0&&((0,a.afterCleanData)((function(){})),o.default.utils.domNodeDisposal.cleanExternalData=l)}))}},61823:function(t,e,n){var i,a=(i=n(76130))&&i.__esModule?i:{default:i},o=n(58020),r=n(97906);if(a.default){r.strategyChanging.add((function(t){!!t.fn&&(0,o.compare)(t.fn.jquery,[2,0])<0&&function(t){var e=function(t,e){var n=function(){a.default.cleanNode(this)};e?t.each(n):t.find("*").each(n)},n=t.fn.empty;t.fn.empty=function(){return e(this,!1),n.apply(this,arguments)};var i=t.fn.remove;t.fn.remove=function(t,n){if(!n){var a=this;t&&(a=a.filter(t)),e(a,!0)}return i.call(this,t,n)};var o=t.fn.html;t.fn.html=function(t){return"string"==typeof t&&e(this,!1),o.apply(this,arguments)};var r=t.fn.replaceWith;t.fn.replaceWith=function(){var t=r.apply(this,arguments);return this.parent().length||e(this,!0),t}}(t)}))}},89135:function(t,e,n){var i=v(n(68374)),a=v(n(76130)),o=v(n(44504)),r=n(35922),s=v(n(5554)),l=v(n(14390)),c=v(n(55845)),u=v(n(27135)),d=v(n(42160)),h=v(n(4741)),f=n(1129),p=v(n(96452)),g=v(n(88933)),m=n(45994),_=v(n(80209));function v(t){return t&&t.__esModule?t:{default:t}}if(a.default){var b=[];s.default.add((function(t,e){!function(t,e){p.default.isEditor(e.prototype)&&b.push(t),a.default.bindingHandlers[t]={init:function(t,n){var s,p,v=(0,i.default)(t),b=(0,o.default)(),y={},x=(0,_.default)().knockout,w=x&&x.isBindingPropertyPredicateName,k={onInitializing:function(e){var i=this;y=this._getOptionsByReference(),a.default.computed((function(){var t,o=a.default.unwrap(n());(s&&s.beginUpdate(),p=w&&o&&o[w],T(o),s)?s.endUpdate():null==o||null===(t=o.onInitializing)||void 0===t||t.call(i,e)}),null,{disposeWhenNodeIsRemoved:t}),s=this},modelByElement:function(t){if(t.length){var e=(0,m.getClosestNodeWithContext)(t.get(0));return a.default.dataFor(e)}},nestedComponentOptions:function(t){return{modelByElement:t.option("modelByElement"),nestedComponentOptions:t.option("nestedComponentOptions")}},_optionChangedCallbacks:b,integrationOptions:{watchMethod:function(t,e,n){var i=(n=n||{}).skipImmediate,o=a.default.computed((function(){var n=a.default.unwrap(t());i||e(n),i=!1}));return function(){o.dispose()}},templates:{"dx-polymorph-widget":{render:function(t){var e=a.default.utils.unwrapObservable(t.model.widget);if(e){var n=(0,i.default)("<div>").attr("data-bind",e+": options").get(0);(0,i.default)(t.container).append(n),a.default.applyBindings(t.model,n)}}}},createTemplate:function(t){return new f.KoTemplate(t)}}},S={},C=function(t,e,n){var i=v.data("dxKoLocks"),o=n?a.default.unwrap(e):e;if(a.default.isWriteableObservable(e)&&(S[t]=e),s){if(i.locked(t))return;i.obtain(t);try{a.default.ignoreDependencies?a.default.ignoreDependencies(s.option,s,[t,o]):s.option(t,o)}finally{i.release(t)}}else k[t]=o},A=function(t){var e=t.fullName,n=t.value;if(e in S){var i=this._$element.data("dxKoLocks");if(!i.locked(e)){i.obtain(e);try{S[e](n)}finally{i.release(e)}}}},E=function(e,n,i){var o;i!==w&&(!p||p(i,n,e)?(a.default.computed((function(){var t=e[n];C(i,t,!0),o=a.default.unwrap(t)}),null,{disposeWhenNodeIsRemoved:t}),(0,r.isPlainObject)(o)&&(y[i]||T(o,i))):C(i,e[n],!1))};function T(t,e){for(var n in t)Object.prototype.hasOwnProperty.call(t,n)&&E(t,n,e?[e,n].join("."):n)}return b.add(A),v.data("dxKoCreation",!0).data("dxKoLocks",new g.default),new e(v,k),k=null,{controlsDescendantBindings:e.subclassOf(l.default)||e.subclassOf(c.default)||e.subclassOf(u.default)&&!(s instanceof h.default)||s instanceof d.default}}},"dxValidator"===t&&(a.default.bindingHandlers.dxValidator.after=b)}(t,e)}))}},89620:function(t,e,n){var i,a=(i=n(76130))&&i.__esModule?i:{default:i},o=n(44899);a.default&&(a.default.bindingHandlers.dxControlsDescendantBindings={init:function(t,e){return{controlsDescendantBindings:a.default.unwrap(e())}}},a.default.bindingHandlers.dxIcon={init:function(t,e){var n=a.default.utils.unwrapObservable(e())||{},i=(0,o.getImageContainer)(n);a.default.virtualElements.emptyNode(t),i&&a.default.virtualElements.prepend(t,i.get(0))},update:function(t,e){var n=a.default.utils.unwrapObservable(e())||{},i=(0,o.getImageContainer)(n);a.default.virtualElements.emptyNode(t),i&&a.default.virtualElements.prepend(t,i.get(0))}},a.default.virtualElements.allowedBindings.dxIcon=!0)},70883:function(t,e,n){var i=c(n(68374)),a=c(n(55994)),o=c(n(76130)),r=n(35922),s=c(n(94553)),l=n(39611);function c(t){return t&&t.__esModule?t:{default:t}}o.default&&s.default.add((function(t){var e=(0,l.addNamespace)(t,t+"Binding");o.default.bindingHandlers[t]={update:function(t,n,s,l){var c=(0,i.default)(t),u=o.default.utils.unwrapObservable(n()),d=u.execute?u.execute:u;a.default.off(c,e),a.default.on(c,e,(0,r.isPlainObject)(u)?u:{},(function(t){d.call(l,l,t)}))}}}))},1129:function(t,e,n){e.KoTemplate=void 0;var i=u(n(68374)),a=u(n(73349)),o=u(n(76130)),r=n(35922),s=n(81033),l=n(3532),c=n(45994);function u(t){return t&&t.__esModule?t:{default:t}}function d(t,e){return(d=Object.setPrototypeOf?Object.setPrototypeOf.bind():function(t,e){return t.__proto__=e,t})(t,e)}var h=function(t){var e,n;function s(e){var n;return(n=t.call(this)||this)._element=e,n._template=(0,i.default)("<div>").append((0,l.normalizeTemplateElement)(e)),n._registerKoTemplate(),n}n=t,(e=s).prototype=Object.create(n.prototype),e.prototype.constructor=e,d(e,n);var u=s.prototype;return u._registerKoTemplate=function(){var t=this._template.get(0);new o.default.templateSources.anonymousTemplate(t).nodes(t)},u._prepareDataForContainer=function(t,e){if(e&&e.length){var n=(0,c.getClosestNodeWithContext)(e.get(0)),i=o.default.contextFor(n);if(t=void 0!==t?t:o.default.dataFor(n)||{},i)return t===i.$data?i:i.createChildContext(t)}return function(t){var e=a.default.createElement("div");o.default.applyBindingsToNode(e,null,t);var n=o.default.contextFor(e);return o.default.cleanNode(e),n}(t).createChildContext(t)},u._renderCore=function(t){var e=this._prepareDataForContainer(t.model,(0,i.default)(t.container));(0,r.isDefined)(t.index)&&(e.$index=t.index);var n,a=(0,i.default)("<div>").appendTo(t.container);return o.default.renderTemplate(this._template.get(0),e,{afterRender:function(t){n=(0,i.default)(t)}},a.get(0),"replaceNode"),n},u.source=function(){return(0,i.default)(this._element).clone()},u.dispose=function(){this._template.remove()},s}(s.TemplateBase);e.KoTemplate=h},45994:function(t,e,n){e.getClosestNodeWithKoCreation=e.getClosestNodeWithContext=void 0;var i=o(n(76130)),a=o(n(68374));function o(t){return t&&t.__esModule?t:{default:t}}e.getClosestNodeWithContext=function t(e){return!i.default.contextFor(e)&&e.parentNode?t(e.parentNode):e};e.getClosestNodeWithKoCreation=function t(e){var n=(0,a.default)(e).data();return n&&n.dxKoCreation?e:e.parentNode?t(e.parentNode):null}},24935:function(t,e,n){var i=n(95479),a=n(13306),o=d(n(38377)),r=n(80566),s=d(n(90964)),l=n(62754),c=d(n(73176)),u=d(n(76130));function d(t){return t&&t.__esModule?t:{default:t}}if(u.default){var h=o.default.inherit({ctor:function(t,e){var n=this,o=e.name,s=e.validationRules;this.target=t,this.name=o,this.isValid=u.default.observable(!0),this.validationError=u.default.observable(),this.validationErrors=u.default.observable(),this.validationStatus=u.default.observable("valid"),this._eventsStrategy=new r.EventsStrategy(this),this.validationRules=(0,i.map)(s,(function(t,e){return(0,a.extend)({},t,{validator:n,index:e})})),this._validationInfo={result:null,deferred:null}},_updateValidationResult:function(t){if(this._validationInfo.result&&this._validationInfo.result.id===t.id)for(var e in t)"id"!==e&&"complete"!==e&&(this._validationInfo.result[e]=t[e]);else{var n=this._validationInfo.deferred&&this._validationInfo.result.complete;this._validationInfo.result=(0,a.extend)({},t,{complete:n})}},validate:function(){var t=this,e=this._validationInfo&&this._validationInfo.result,n=this.target();if(e&&"pending"===e.status&&e.value===n)return(0,a.extend)({},e);var i=s.default.validate(n,this.validationRules,this.name);return i.id=(new c.default).toString(),this._applyValidationResult(i),i.complete&&i.complete.then((function(e){e.id===t._validationInfo.result.id&&t._applyValidationResult(e)})),(0,a.extend)({},this._validationInfo.result)},reset:function(){this.target(null);var t={id:null,isValid:!0,brokenRule:null,pendingRules:null,status:"valid",complete:null};return this._applyValidationResult(t),t},_applyValidationResult:function(t){if(t.validator=this,this._updateValidationResult(t),this.target.dxValidator.isValid(this._validationInfo.result.isValid),this.target.dxValidator.validationError(this._validationInfo.result.brokenRule),this.target.dxValidator.validationErrors(this._validationInfo.result.brokenRules),this.target.dxValidator.validationStatus(this._validationInfo.result.status),"pending"===t.status)return this._validationInfo.deferred||(this._validationInfo.deferred=new l.Deferred,this._validationInfo.result.complete=this._validationInfo.deferred.promise()),void this._eventsStrategy.fireEvent("validating",[this._validationInfo.result]);"pending"!==t.status&&(this._eventsStrategy.fireEvent("validated",[t]),this._validationInfo.deferred&&(this._validationInfo.deferred.resolve(t),this._validationInfo.deferred=null))},on:function(t,e){return this._eventsStrategy.on(t,e),this},off:function(t,e){return this._eventsStrategy.off(t,e),this}});u.default.extenders.dxValidator=function(t,e){return t.dxValidator=new h(t,e),t.subscribe(t.dxValidator.validate.bind(t.dxValidator)),t},s.default.registerModelForValidation=function(t){(0,i.each)(t,(function(e,n){u.default.isObservable(n)&&n.dxValidator&&s.default.registerValidatorInGroup(t,n.dxValidator)}))},s.default.unregisterModelForValidation=function(t){(0,i.each)(t,(function(e,n){u.default.isObservable(n)&&n.dxValidator&&s.default.removeRegisteredValidator(t,n.dxValidator)}))},s.default.validateModel=s.default.validateGroup}},74942:function(t,e,n){var i=o(n(76130)),a=o(n(26974));function o(t){return t&&t.__esModule?t:{default:t}}i.default&&a.default.inject({isWrapped:i.default.isObservable,isWritableWrapped:i.default.isWritableObservable,wrap:i.default.observable,unwrap:function(t){return i.default.isObservable(t)?i.default.utils.unwrapObservable(t):this.callBase(t)},assign:function(t,e){i.default.isObservable(t)?t(e):this.callBase(t,e)}})},94484:function(t,e,n){Object.defineProperty(e,"date",{enumerable:!0,get:function(){return r.default}}),e.disableIntl=function(){"intl"===o.default.engine()&&o.default.resetInjection();"intl"===r.default.engine()&&r.default.resetInjection()},e.locale=e.loadMessages=e.formatNumber=e.formatMessage=e.formatDate=void 0,Object.defineProperty(e,"message",{enumerable:!0,get:function(){return a.default}}),Object.defineProperty(e,"number",{enumerable:!0,get:function(){return o.default}}),e.parseNumber=e.parseDate=void 0;var i=s(n(91331)),a=s(n(28109)),o=s(n(18016)),r=s(n(91500));function s(t){return t&&t.__esModule?t:{default:t}}n(89740);var l=i.default.locale.bind(i.default);e.locale=l;var c=a.default.load.bind(a.default);e.loadMessages=c;var u=a.default.format.bind(a.default);e.formatMessage=u;var d=o.default.format.bind(o.default);e.formatNumber=d;var h=o.default.parse.bind(o.default);e.parseNumber=h;var f=r.default.format.bind(r.default);e.formatDate=f;var p=r.default.parse.bind(r.default);e.parseDate=p},71868:function(t,e){e.default=void 0;e.default={af:"\xa4#,##0.00;(\xa4#,##0.00)","af-NA":"\xa4#,##0.00;(\xa4#,##0.00)",agq:"#,##0.00\xa4",ak:"\xa4#,##0.00",am:"\xa4#,##0.00;(\xa4#,##0.00)",ar:"\xa4#,##0.00;(\xa4#,##0.00)","ar-AE":"\xa4#,##0.00;(\xa4#,##0.00)","ar-BH":"\xa4#,##0.00;(\xa4#,##0.00)","ar-DJ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-DZ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-EG":"\xa4#,##0.00;(\xa4#,##0.00)","ar-EH":"\xa4#,##0.00;(\xa4#,##0.00)","ar-ER":"\xa4#,##0.00;(\xa4#,##0.00)","ar-IL":"\xa4#,##0.00;(\xa4#,##0.00)","ar-IQ":"\xa4#,##0.00;(\xa4#,##0.00)","ar-JO":"\xa4#,##0.00;(\xa4#,##0.00)","ar-KM":"\xa4#,##0.00;(\xa4#,##0.00)","ar-KW":"\xa4#,##0.00;(\xa4#,##0.00)","ar-LB":"\xa4#,##0.00;(\xa4#,##0.00)","ar-LY":"\xa4#,##0.00;(\xa4#,##0.00)","ar-MA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-MR":"\xa4#,##0.00;(\xa4#,##0.00)","ar-OM":"\xa4#,##0.00;(\xa4#,##0.00)","ar-PS":"\xa4#,##0.00;(\xa4#,##0.00)","ar-QA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SA":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SD":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SO":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SS":"\xa4#,##0.00;(\xa4#,##0.00)","ar-SY":"\xa4#,##0.00;(\xa4#,##0.00)","ar-TD":"\xa4#,##0.00;(\xa4#,##0.00)","ar-TN":"\xa4#,##0.00;(\xa4#,##0.00)","ar-YE":"\xa4#,##0.00;(\xa4#,##0.00)",as:"\xa4\xa0#,##,##0.00",asa:"#,##0.00\xa0\xa4",ast:"#,##0.00\xa0\xa4",az:"#,##0.00\xa0\xa4","az-Cyrl":"#,##0.00\xa0\xa4","az-Latn":"#,##0.00\xa0\xa4",bas:"#,##0.00\xa0\xa4",be:"#,##0.00\xa0\xa4","be-tarask":"#,##0.00\xa0\xa4",bem:"\xa4#,##0.00;(\xa4#,##0.00)",bez:"#,##0.00\xa4",bg:"0.00\xa0\xa4;(0.00\xa0\xa4)",bm:"\xa4#,##0.00;(\xa4#,##0.00)",bn:"#,##,##0.00\xa4;(#,##,##0.00\xa4)","bn-IN":"#,##,##0.00\xa4;(#,##,##0.00\xa4)",bo:"\xa4\xa0#,##0.00","bo-IN":"\xa4\xa0#,##0.00",br:"#,##0.00\xa0\xa4",brx:"\xa4\xa0#,##,##0.00",bs:"#,##0.00\xa0\xa4","bs-Cyrl":"#,##0.00\xa0\xa4","bs-Latn":"#,##0.00\xa0\xa4",ca:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-AD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-ES-valencia":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-FR":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ca-IT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ccp:"#,##,##0.00\xa4;(#,##,##0.00\xa4)","ccp-IN":"#,##,##0.00\xa4;(#,##,##0.00\xa4)",ce:"#,##0.00\xa0\xa4",ceb:"\xa4#,##0.00;(\xa4#,##0.00)",cgg:"\xa4#,##0.00",chr:"\xa4#,##0.00;(\xa4#,##0.00)",ckb:"\xa4\xa0#,##0.00","ckb-IR":"\xa4\xa0#,##0.00",cs:"#,##0.00\xa0\xa4",cy:"\xa4#,##0.00;(\xa4#,##0.00)",da:"#,##0.00\xa0\xa4","da-GL":"#,##0.00\xa0\xa4",dav:"\xa4#,##0.00;(\xa4#,##0.00)",de:"#,##0.00\xa0\xa4","de-AT":"#,##0.00\xa0\xa4","de-BE":"#,##0.00\xa0\xa4","de-CH":"#,##0.00\xa0\xa4","de-IT":"#,##0.00\xa0\xa4","de-LI":"#,##0.00\xa0\xa4","de-LU":"#,##0.00\xa0\xa4",dje:"#,##0.00\xa4",doi:"\xa4#,##0.00",dsb:"#,##0.00\xa0\xa4",dua:"#,##0.00\xa0\xa4",dyo:"#,##0.00\xa0\xa4",dz:"\xa4#,##,##0.00",ebu:"\xa4#,##0.00;(\xa4#,##0.00)",ee:"\xa4#,##0.00;(\xa4#,##0.00)","ee-TG":"\xa4#,##0.00;(\xa4#,##0.00)",el:"#,##0.00\xa0\xa4","el-CY":"#,##0.00\xa0\xa4",en:"\xa4#,##0.00;(\xa4#,##0.00)","en-001":"\xa4#,##0.00;(\xa4#,##0.00)","en-150":"#,##0.00\xa0\xa4","en-AE":"\xa4#,##0.00;(\xa4#,##0.00)","en-AG":"\xa4#,##0.00;(\xa4#,##0.00)","en-AI":"\xa4#,##0.00;(\xa4#,##0.00)","en-AS":"\xa4#,##0.00;(\xa4#,##0.00)","en-AT":"\xa4\xa0#,##0.00","en-AU":"\xa4#,##0.00;(\xa4#,##0.00)","en-BB":"\xa4#,##0.00;(\xa4#,##0.00)","en-BE":"#,##0.00\xa0\xa4","en-BI":"\xa4#,##0.00;(\xa4#,##0.00)","en-BM":"\xa4#,##0.00;(\xa4#,##0.00)","en-BS":"\xa4#,##0.00;(\xa4#,##0.00)","en-BW":"\xa4#,##0.00;(\xa4#,##0.00)","en-BZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-CA":"\xa4#,##0.00;(\xa4#,##0.00)","en-CC":"\xa4#,##0.00;(\xa4#,##0.00)","en-CH":"\xa4\xa0#,##0.00;\xa4-#,##0.00","en-CK":"\xa4#,##0.00;(\xa4#,##0.00)","en-CM":"\xa4#,##0.00;(\xa4#,##0.00)","en-CX":"\xa4#,##0.00;(\xa4#,##0.00)","en-CY":"\xa4#,##0.00;(\xa4#,##0.00)","en-DE":"#,##0.00\xa0\xa4","en-DG":"\xa4#,##0.00;(\xa4#,##0.00)","en-DK":"#,##0.00\xa0\xa4","en-DM":"\xa4#,##0.00;(\xa4#,##0.00)","en-ER":"\xa4#,##0.00;(\xa4#,##0.00)","en-FI":"#,##0.00\xa0\xa4","en-FJ":"\xa4#,##0.00;(\xa4#,##0.00)","en-FK":"\xa4#,##0.00;(\xa4#,##0.00)","en-FM":"\xa4#,##0.00;(\xa4#,##0.00)","en-GB":"\xa4#,##0.00;(\xa4#,##0.00)","en-GD":"\xa4#,##0.00;(\xa4#,##0.00)","en-GG":"\xa4#,##0.00;(\xa4#,##0.00)","en-GH":"\xa4#,##0.00;(\xa4#,##0.00)","en-GI":"\xa4#,##0.00;(\xa4#,##0.00)","en-GM":"\xa4#,##0.00;(\xa4#,##0.00)","en-GU":"\xa4#,##0.00;(\xa4#,##0.00)","en-GY":"\xa4#,##0.00;(\xa4#,##0.00)","en-HK":"\xa4#,##0.00;(\xa4#,##0.00)","en-IE":"\xa4#,##0.00;(\xa4#,##0.00)","en-IL":"\xa4#,##0.00;(\xa4#,##0.00)","en-IM":"\xa4#,##0.00;(\xa4#,##0.00)","en-IN":"\xa4#,##0.00;(\xa4#,##0.00)","en-IO":"\xa4#,##0.00;(\xa4#,##0.00)","en-JE":"\xa4#,##0.00;(\xa4#,##0.00)","en-JM":"\xa4#,##0.00;(\xa4#,##0.00)","en-KE":"\xa4#,##0.00;(\xa4#,##0.00)","en-KI":"\xa4#,##0.00;(\xa4#,##0.00)","en-KN":"\xa4#,##0.00;(\xa4#,##0.00)","en-KY":"\xa4#,##0.00;(\xa4#,##0.00)","en-LC":"\xa4#,##0.00;(\xa4#,##0.00)","en-LR":"\xa4#,##0.00;(\xa4#,##0.00)","en-LS":"\xa4#,##0.00;(\xa4#,##0.00)","en-MG":"\xa4#,##0.00;(\xa4#,##0.00)","en-MH":"\xa4#,##0.00;(\xa4#,##0.00)","en-MO":"\xa4#,##0.00;(\xa4#,##0.00)","en-MP":"\xa4#,##0.00;(\xa4#,##0.00)","en-MS":"\xa4#,##0.00;(\xa4#,##0.00)","en-MT":"\xa4#,##0.00;(\xa4#,##0.00)","en-MU":"\xa4#,##0.00;(\xa4#,##0.00)","en-MV":"\xa4\xa0#,##0.00","en-MW":"\xa4#,##0.00;(\xa4#,##0.00)","en-MY":"\xa4#,##0.00;(\xa4#,##0.00)","en-NA":"\xa4#,##0.00;(\xa4#,##0.00)","en-NF":"\xa4#,##0.00;(\xa4#,##0.00)","en-NG":"\xa4#,##0.00;(\xa4#,##0.00)","en-NL":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","en-NR":"\xa4#,##0.00;(\xa4#,##0.00)","en-NU":"\xa4#,##0.00;(\xa4#,##0.00)","en-NZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-PG":"\xa4#,##0.00;(\xa4#,##0.00)","en-PH":"\xa4#,##0.00;(\xa4#,##0.00)","en-PK":"\xa4#,##0.00;(\xa4#,##0.00)","en-PN":"\xa4#,##0.00;(\xa4#,##0.00)","en-PR":"\xa4#,##0.00;(\xa4#,##0.00)","en-PW":"\xa4#,##0.00;(\xa4#,##0.00)","en-RW":"\xa4#,##0.00;(\xa4#,##0.00)","en-SB":"\xa4#,##0.00;(\xa4#,##0.00)","en-SC":"\xa4#,##0.00;(\xa4#,##0.00)","en-SD":"\xa4#,##0.00;(\xa4#,##0.00)","en-SE":"#,##0.00\xa0\xa4","en-SG":"\xa4#,##0.00;(\xa4#,##0.00)","en-SH":"\xa4#,##0.00;(\xa4#,##0.00)","en-SI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","en-SL":"\xa4#,##0.00;(\xa4#,##0.00)","en-SS":"\xa4#,##0.00;(\xa4#,##0.00)","en-SX":"\xa4#,##0.00;(\xa4#,##0.00)","en-SZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-TC":"\xa4#,##0.00;(\xa4#,##0.00)","en-TK":"\xa4#,##0.00;(\xa4#,##0.00)","en-TO":"\xa4#,##0.00;(\xa4#,##0.00)","en-TT":"\xa4#,##0.00;(\xa4#,##0.00)","en-TV":"\xa4#,##0.00;(\xa4#,##0.00)","en-TZ":"\xa4#,##0.00;(\xa4#,##0.00)","en-UG":"\xa4#,##0.00;(\xa4#,##0.00)","en-UM":"\xa4#,##0.00;(\xa4#,##0.00)","en-VC":"\xa4#,##0.00;(\xa4#,##0.00)","en-VG":"\xa4#,##0.00;(\xa4#,##0.00)","en-VI":"\xa4#,##0.00;(\xa4#,##0.00)","en-VU":"\xa4#,##0.00;(\xa4#,##0.00)","en-WS":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZA":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZM":"\xa4#,##0.00;(\xa4#,##0.00)","en-ZW":"\xa4#,##0.00;(\xa4#,##0.00)",eo:"\xa4\xa0#,##0.00",es:"#,##0.00\xa0\xa4","es-419":"\xa4#,##0.00","es-AR":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","es-BO":"\xa4#,##0.00","es-BR":"\xa4#,##0.00","es-BZ":"\xa4#,##0.00","es-CL":"\xa4#,##0.00","es-CO":"\xa4#,##0.00","es-CR":"\xa4#,##0.00","es-CU":"\xa4#,##0.00","es-DO":"\xa4#,##0.00;(\xa4#,##0.00)","es-EA":"#,##0.00\xa0\xa4","es-EC":"\xa4#,##0.00","es-GQ":"#,##0.00\xa0\xa4","es-GT":"\xa4#,##0.00","es-HN":"\xa4#,##0.00","es-IC":"#,##0.00\xa0\xa4","es-MX":"\xa4#,##0.00","es-NI":"\xa4#,##0.00","es-PA":"\xa4#,##0.00","es-PE":"\xa4#,##0.00","es-PH":"#,##0.00\xa0\xa4","es-PR":"\xa4#,##0.00","es-PY":"\xa4#,##0.00","es-SV":"\xa4#,##0.00","es-US":"\xa4#,##0.00","es-UY":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","es-VE":"\xa4#,##0.00",et:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",eu:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ewo:"#,##0.00\xa0\xa4",fa:"\u200e\xa4\xa0#,##0.00;\u200e(\xa4\xa0#,##0.00)","fa-AF":"\xa4\xa0#,##0.00;\u200e(\xa4\xa0#,##0.00)",ff:"#,##0.00\xa0\xa4","ff-Adlm":"\xa4\xa0#,##0.00","ff-Adlm-BF":"\xa4\xa0#,##0.00","ff-Adlm-CM":"\xa4\xa0#,##0.00","ff-Adlm-GH":"\xa4\xa0#,##0.00","ff-Adlm-GM":"\xa4\xa0#,##0.00","ff-Adlm-GW":"\xa4\xa0#,##0.00","ff-Adlm-LR":"\xa4\xa0#,##0.00","ff-Adlm-MR":"\xa4\xa0#,##0.00","ff-Adlm-NE":"\xa4\xa0#,##0.00","ff-Adlm-NG":"\xa4\xa0#,##0.00","ff-Adlm-SL":"\xa4\xa0#,##0.00","ff-Adlm-SN":"\xa4\xa0#,##0.00","ff-Latn":"#,##0.00\xa0\xa4","ff-Latn-BF":"#,##0.00\xa0\xa4","ff-Latn-CM":"#,##0.00\xa0\xa4","ff-Latn-GH":"#,##0.00\xa0\xa4","ff-Latn-GM":"#,##0.00\xa0\xa4","ff-Latn-GN":"#,##0.00\xa0\xa4","ff-Latn-GW":"#,##0.00\xa0\xa4","ff-Latn-LR":"#,##0.00\xa0\xa4","ff-Latn-MR":"#,##0.00\xa0\xa4","ff-Latn-NE":"#,##0.00\xa0\xa4","ff-Latn-NG":"#,##0.00\xa0\xa4","ff-Latn-SL":"#,##0.00\xa0\xa4",fi:"#,##0.00\xa0\xa4",fil:"\xa4#,##0.00;(\xa4#,##0.00)",fo:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fo-DK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",fr:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BJ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-BL":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CH":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CI":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-CM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-DJ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-DZ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GP":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-GQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-HT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-KM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-LU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-ML":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MR":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-MU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-NC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-NE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-PF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-PM":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-RE":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-RW":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SC":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-SY":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TG":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-TN":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-VU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-WF":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","fr-YT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",fur:"\xa4\xa0#,##0.00",fy:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",ga:"\xa4#,##0.00;(\xa4#,##0.00)","ga-GB":"\xa4#,##0.00;(\xa4#,##0.00)",gd:"\xa4#,##0.00;(\xa4#,##0.00)",gl:"#,##0.00\xa0\xa4",gsw:"#,##0.00\xa0\xa4","gsw-FR":"#,##0.00\xa0\xa4","gsw-LI":"#,##0.00\xa0\xa4",gu:"\xa4#,##,##0.00;(\xa4#,##,##0.00)",guz:"\xa4#,##0.00;(\xa4#,##0.00)",gv:"\xa4#,##0.00",ha:"\xa4\xa0#,##0.00","ha-GH":"\xa4\xa0#,##0.00","ha-NE":"\xa4\xa0#,##0.00",haw:"\xa4#,##0.00;(\xa4#,##0.00)",he:"#,##0.00\xa0\xa4",hi:"\xa4#,##,##0.00","hi-Latn":"\xa4#,##,##0.00",hr:"#,##0.00\xa0\xa4","hr-BA":"#,##0.00\xa0\xa4",hsb:"#,##0.00\xa0\xa4",hu:"#,##0.00\xa0\xa4",hy:"#,##0.00\xa0\xa4",ia:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",id:"\xa4#,##0.00",ig:"\xa4#,##0.00;(\xa4#,##0.00)",ii:"\xa4\xa0#,##0.00",is:"#,##0.00\xa0\xa4",it:"#,##0.00\xa0\xa4","it-CH":"#,##0.00\xa0\xa4","it-SM":"#,##0.00\xa0\xa4","it-VA":"#,##0.00\xa0\xa4",ja:"\xa4#,##0.00;(\xa4#,##0.00)",jgo:"\xa4\xa0#,##0.00",jmc:"\xa4#,##0.00",jv:"\xa4\xa0#,##0.00",ka:"#,##0.00\xa0\xa4",kab:"#,##0.00\xa4",kam:"\xa4#,##0.00;(\xa4#,##0.00)",kde:"\xa4#,##0.00;(\xa4#,##0.00)",kea:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",kgp:"\xa4\xa0#,##0.00",khq:"#,##0.00\xa4",ki:"\xa4#,##0.00;(\xa4#,##0.00)",kk:"#,##0.00\xa0\xa4",kkj:"\xa4\xa0#,##0.00",kl:"\xa4#,##0.00;\xa4-#,##0.00",kln:"\xa4#,##0.00;(\xa4#,##0.00)",km:"#,##0.00\xa4;(#,##0.00\xa4)",kn:"\xa4#,##0.00;(\xa4#,##0.00)",ko:"\xa4#,##0.00;(\xa4#,##0.00)","ko-KP":"\xa4#,##0.00;(\xa4#,##0.00)",kok:"\xa4#,##0.00;(\xa4#,##0.00)",ks:"\xa4#,##0.00","ks-Arab":"\xa4#,##0.00","ks-Deva":"\xa4\xa0#,##0.00",ksb:"#,##0.00\xa4",ksf:"#,##0.00\xa0\xa4",ksh:"#,##0.00\xa0\xa4",ku:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",kw:"\xa4#,##0.00",ky:"#,##0.00\xa0\xa4",lag:"\xa4\xa0#,##0.00",lb:"#,##0.00\xa0\xa4",lg:"#,##0.00\xa4",lkt:"\xa4\xa0#,##0.00",ln:"#,##0.00\xa0\xa4","ln-AO":"#,##0.00\xa0\xa4","ln-CF":"#,##0.00\xa0\xa4","ln-CG":"#,##0.00\xa0\xa4",lo:"\xa4#,##0.00;\xa4-#,##0.00",lrc:"\xa4\xa0#,##0.00","lrc-IQ":"\xa4\xa0#,##0.00",lt:"#,##0.00\xa0\xa4",lu:"#,##0.00\xa4",luo:"#,##0.00\xa4",luy:"\xa4#,##0.00;\xa4-\xa0#,##0.00",lv:"#,##0.00\xa0\xa4",mai:"\xa4\xa0#,##0.00",mas:"\xa4#,##0.00;(\xa4#,##0.00)","mas-TZ":"\xa4#,##0.00;(\xa4#,##0.00)",mer:"\xa4#,##0.00;(\xa4#,##0.00)",mfe:"\xa4\xa0#,##0.00",mg:"\xa4#,##0.00",mgh:"\xa4\xa0#,##0.00",mgo:"\xa4\xa0#,##0.00",mi:"\xa4\xa0#,##0.00",mk:"#,##0.00\xa0\xa4",ml:"\xa4#,##0.00;(\xa4#,##0.00)",mn:"\xa4\xa0#,##0.00",mni:"\xa4\xa0#,##0.00","mni-Beng":"\xa4\xa0#,##0.00",mr:"\xa4#,##0.00;(\xa4#,##0.00)",ms:"\xa4#,##0.00;(\xa4#,##0.00)","ms-BN":"\xa4#,##0.00;(\xa4#,##0.00)","ms-ID":"\xa4#,##0.00","ms-SG":"\xa4#,##0.00;(\xa4#,##0.00)",mt:"\xa4#,##0.00",mua:"\xa4#,##0.00;(\xa4#,##0.00)",my:"\xa4\xa0#,##0.00",mzn:"\xa4\xa0#,##0.00",naq:"\xa4#,##0.00",nb:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nb-SJ":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nd:"\xa4#,##0.00;(\xa4#,##0.00)",nds:"\xa4\xa0#,##0.00","nds-NL":"\xa4\xa0#,##0.00",ne:"\xa4\xa0#,##,##0.00","ne-IN":"\xa4\xa0#,##,##0.00",nl:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-AW":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-BE":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-BQ":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-CW":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-SR":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)","nl-SX":"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nmg:"#,##0.00\xa0\xa4",nn:"#,##0.00\xa0\xa4",nnh:"\xa4\xa0#,##0.00",no:"\xa4\xa0#,##0.00;(\xa4\xa0#,##0.00)",nus:"\xa4#,##0.00;(\xa4#,##0.00)",nyn:"\xa4#,##0.00",om:"\xa4#,##0.00","om-KE":"\xa4#,##0.00",or:"\xa4#,##0.00;(\xa4#,##0.00)",os:"\xa4\xa0#,##0.00","os-RU":"\xa4\xa0#,##0.00",pa:"\xa4\xa0#,##0.00","pa-Arab":"\xa4\xa0#,##0.00","pa-Guru":"\xa4\xa0#,##0.00",pcm:"\xa4#,##0.00",pl:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",ps:"\xa4#,##0.00;(\xa4#,##0.00)","ps-PK":"\xa4#,##0.00;(\xa4#,##0.00)",pt:"\xa4\xa0#,##0.00","pt-AO":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-CH":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-CV":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-GQ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-GW":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-LU":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-MO":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-MZ":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-PT":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-ST":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","pt-TL":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",qu:"\xa4\xa0#,##0.00","qu-BO":"\xa4\xa0#,##0.00","qu-EC":"\xa4\xa0#,##0.00",rm:"#,##0.00\xa0\xa4",rn:"#,##0.00\xa4",ro:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","ro-MD":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",rof:"\xa4#,##0.00",ru:"#,##0.00\xa0\xa4","ru-BY":"#,##0.00\xa0\xa4","ru-KG":"#,##0.00\xa0\xa4","ru-KZ":"#,##0.00\xa0\xa4","ru-MD":"#,##0.00\xa0\xa4","ru-UA":"#,##0.00\xa0\xa4",rw:"\xa4\xa0#,##0.00",rwk:"#,##0.00\xa4",sa:"\xa4\xa0#,##0.00",sah:"#,##0.00\xa0\xa4",saq:"\xa4#,##0.00;(\xa4#,##0.00)",sat:"\xa4\xa0#,##0.00","sat-Olck":"\xa4\xa0#,##0.00",sbp:"#,##0.00\xa4",sc:"#,##0.00\xa0\xa4",sd:"\xa4\xa0#,##0.00","sd-Arab":"\xa4\xa0#,##0.00","sd-Deva":"\xa4\xa0#,##0.00",se:"#,##0.00\xa0\xa4","se-FI":"#,##0.00\xa0\xa4","se-SE":"#,##0.00\xa0\xa4",seh:"#,##0.00\xa4",ses:"#,##0.00\xa4",sg:"\xa4#,##0.00;\xa4-#,##0.00",shi:"#,##0.00\xa4","shi-Latn":"#,##0.00\xa4","shi-Tfng":"#,##0.00\xa4",si:"\xa4#,##0.00;(\xa4#,##0.00)",sk:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",sl:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",smn:"#,##0.00\xa0\xa4",sn:"\xa4#,##0.00;(\xa4#,##0.00)",so:"\xa4#,##0.00;(\xa4#,##0.00)","so-DJ":"\xa4#,##0.00;(\xa4#,##0.00)","so-ET":"\xa4#,##0.00;(\xa4#,##0.00)","so-KE":"\xa4#,##0.00;(\xa4#,##0.00)",sq:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sq-MK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sq-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",sr:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-BA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-ME":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Cyrl-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-BA":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-ME":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)","sr-Latn-XK":"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",su:"\xa4#,##0.00","su-Latn":"\xa4#,##0.00",sv:"#,##0.00\xa0\xa4","sv-AX":"#,##0.00\xa0\xa4","sv-FI":"#,##0.00\xa0\xa4",sw:"\xa4\xa0#,##0.00","sw-CD":"\xa4\xa0#,##0.00","sw-KE":"\xa4\xa0#,##0.00","sw-UG":"\xa4\xa0#,##0.00",ta:"\xa4#,##0.00;(\xa4#,##0.00)","ta-LK":"\xa4#,##0.00;(\xa4#,##0.00)","ta-MY":"\xa4#,##0.00;(\xa4#,##0.00)","ta-SG":"\xa4#,##0.00;(\xa4#,##0.00)",te:"\xa4#,##0.00;(\xa4#,##0.00)",teo:"\xa4#,##0.00;(\xa4#,##0.00)","teo-KE":"\xa4#,##0.00;(\xa4#,##0.00)",tg:"#,##0.00\xa0\xa4",th:"\xa4#,##0.00;(\xa4#,##0.00)",ti:"\xa4#,##0.00","ti-ER":"\xa4#,##0.00",tk:"#,##0.00\xa0\xa4",to:"\xa4\xa0#,##0.00",tr:"\xa4#,##0.00;(\xa4#,##0.00)","tr-CY":"\xa4#,##0.00;(\xa4#,##0.00)",tt:"#,##0.00\xa0\xa4",twq:"#,##0.00\xa4",tzm:"#,##0.00\xa0\xa4",ug:"\xa4#,##0.00;(\xa4#,##0.00)",uk:"#,##0.00\xa0\xa4",und:"\xa4\xa0#,##0.00",ur:"\xa4#,##0.00;(\xa4#,##0.00)","ur-IN":"\xa4#,##0.00;(\xa4#,##0.00)",uz:"#,##0.00\xa0\xa4","uz-Arab":"\xa4\xa0#,##0.00","uz-Cyrl":"#,##0.00\xa0\xa4","uz-Latn":"#,##0.00\xa0\xa4",vai:"\xa4#,##0.00;(\xa4#,##0.00)","vai-Latn":"\xa4#,##0.00;(\xa4#,##0.00)","vai-Vaii":"\xa4#,##0.00;(\xa4#,##0.00)",vi:"#,##0.00\xa0\xa4",vun:"\xa4#,##0.00",wae:"\xa4\xa0#,##0.00",wo:"\xa4\xa0#,##0.00",xh:"\xa4#,##0.00",xog:"#,##0.00\xa0\xa4",yav:"#,##0.00\xa0\xa4;(#,##0.00\xa0\xa4)",yi:"\xa4\xa0#,##0.00",yo:"\xa4#,##0.00;(\xa4#,##0.00)","yo-BJ":"\xa4#,##0.00;(\xa4#,##0.00)",yrl:"\xa4\xa0#,##0.00","yrl-CO":"\xa4\xa0#,##0.00","yrl-VE":"\xa4\xa0#,##0.00",yue:"\xa4#,##0.00;(\xa4#,##0.00)","yue-Hans":"\xa4#,##0.00;(\xa4#,##0.00)","yue-Hant":"\xa4#,##0.00;(\xa4#,##0.00)",zgh:"#,##0.00\xa4",zh:"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-HK":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-MO":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hans-SG":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant-HK":"\xa4#,##0.00;(\xa4#,##0.00)","zh-Hant-MO":"\xa4#,##0.00;(\xa4#,##0.00)",zu:"\xa4#,##0.00;(\xa4#,##0.00)"},t.exports=e.default,t.exports.default=e.default},35608:function(t,e){e.enCldr=void 0;e.enCldr={main:{en:{identity:{version:{_cldrVersion:"36"}},dates:{calendars:{gregorian:{months:{format:{abbreviated:{1:"Jan",2:"Feb",3:"Mar",4:"Apr",5:"May",6:"Jun",7:"Jul",8:"Aug",9:"Sep",10:"Oct",11:"Nov",12:"Dec"},narrow:{1:"J",2:"F",3:"M",4:"A",5:"M",6:"J",7:"J",8:"A",9:"S",10:"O",11:"N",12:"D"},wide:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"}},"stand-alone":{abbreviated:{1:"Jan",2:"Feb",3:"Mar",4:"Apr",5:"May",6:"Jun",7:"Jul",8:"Aug",9:"Sep",10:"Oct",11:"Nov",12:"Dec"},narrow:{1:"J",2:"F",3:"M",4:"A",5:"M",6:"J",7:"J",8:"A",9:"S",10:"O",11:"N",12:"D"},wide:{1:"January",2:"February",3:"March",4:"April",5:"May",6:"June",7:"July",8:"August",9:"September",10:"October",11:"November",12:"December"}}},days:{format:{abbreviated:{sun:"Sun",mon:"Mon",tue:"Tue",wed:"Wed",thu:"Thu",fri:"Fri",sat:"Sat"},narrow:{sun:"S",mon:"M",tue:"T",wed:"W",thu:"T",fri:"F",sat:"S"},short:{sun:"Su",mon:"Mo",tue:"Tu",wed:"We",thu:"Th",fri:"Fr",sat:"Sa"},wide:{sun:"Sunday",mon:"Monday",tue:"Tuesday",wed:"Wednesday",thu:"Thursday",fri:"Friday",sat:"Saturday"}},"stand-alone":{abbreviated:{sun:"Sun",mon:"Mon",tue:"Tue",wed:"Wed",thu:"Thu",fri:"Fri",sat:"Sat"},narrow:{sun:"S",mon:"M",tue:"T",wed:"W",thu:"T",fri:"F",sat:"S"},short:{sun:"Su",mon:"Mo",tue:"Tu",wed:"We",thu:"Th",fri:"Fr",sat:"Sa"},wide:{sun:"Sunday",mon:"Monday",tue:"Tuesday",wed:"Wednesday",thu:"Thursday",fri:"Friday",sat:"Saturday"}}},quarters:{format:{abbreviated:{1:"Q1",2:"Q2",3:"Q3",4:"Q4"},narrow:{1:"1",2:"2",3:"3",4:"4"},wide:{1:"1st quarter",2:"2nd quarter",3:"3rd quarter",4:"4th quarter"}},"stand-alone":{abbreviated:{1:"Q1",2:"Q2",3:"Q3",4:"Q4"},narrow:{1:"1",2:"2",3:"3",4:"4"},wide:{1:"1st quarter",2:"2nd quarter",3:"3rd quarter",4:"4th quarter"}}},dayPeriods:{format:{abbreviated:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"},narrow:{midnight:"mi",am:"a","am-alt-variant":"am",noon:"n",pm:"p","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"},wide:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"in the morning",afternoon1:"in the afternoon",evening1:"in the evening",night1:"at night"}},"stand-alone":{abbreviated:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"},narrow:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"},wide:{midnight:"midnight",am:"AM","am-alt-variant":"am",noon:"noon",pm:"PM","pm-alt-variant":"pm",morning1:"morning",afternoon1:"afternoon",evening1:"evening",night1:"night"}}},eras:{eraNames:{0:"Before Christ",1:"Anno Domini","0-alt-variant":"Before Common Era","1-alt-variant":"Common Era"},eraAbbr:{0:"BC",1:"AD","0-alt-variant":"BCE","1-alt-variant":"CE"},eraNarrow:{0:"B",1:"A","0-alt-variant":"BCE","1-alt-variant":"CE"}},dateFormats:{full:"EEEE, MMMM d, y",long:"MMMM d, y",medium:"MMM d, y",short:"M/d/yy"},timeFormats:{full:"h:mm:ss a zzzz",long:"h:mm:ss a z",medium:"h:mm:ss a",short:"h:mm a"},dateTimeFormats:{full:"{1} 'at' {0}",long:"{1} 'at' {0}",medium:"{1}, {0}",short:"{1}, {0}",availableFormats:{Bh:"h B",Bhm:"h:mm B",Bhms:"h:mm:ss B",d:"d",E:"ccc",EBhm:"E h:mm B",EBhms:"E h:mm:ss B",Ed:"d E",Ehm:"E h:mm a",EHm:"E HH:mm",Ehms:"E h:mm:ss a",EHms:"E HH:mm:ss",Gy:"y G",GyMMM:"MMM y G",GyMMMd:"MMM d, y G",GyMMMEd:"E, MMM d, y G",h:"h a",H:"HH",hm:"h:mm a",Hm:"HH:mm",hms:"h:mm:ss a",Hms:"HH:mm:ss",hmsv:"h:mm:ss a v",Hmsv:"HH:mm:ss v",hmv:"h:mm a v",Hmv:"HH:mm v",M:"L",Md:"M/d",MEd:"E, M/d",MMM:"LLL",MMMd:"MMM d",MMMEd:"E, MMM d",MMMMd:"MMMM d","MMMMW-count-one":"'week' W 'of' MMMM","MMMMW-count-other":"'week' W 'of' MMMM",ms:"mm:ss",y:"y",yM:"M/y",yMd:"M/d/y",yMEd:"E, M/d/y",yMMM:"MMM y",yMMMd:"MMM d, y",yMMMEd:"E, MMM d, y",yMMMM:"MMMM y",yQQQ:"QQQ y",yQQQQ:"QQQQ y","yw-count-one":"'week' w 'of' Y","yw-count-other":"'week' w 'of' Y"}}}}},numbers:{defaultNumberingSystem:"latn",otherNumberingSystems:{native:"latn"},minimumGroupingDigits:"1","symbols-numberSystem-latn":{decimal:".",group:",",list:";",percentSign:"%",plusSign:"+",minusSign:"-",exponential:"E",superscriptingExponent:"\xd7",perMille:"\u2030",infinity:"\u221e",nan:"NaN",timeSeparator:":"},"decimalFormats-numberSystem-latn":{standard:"#,##0.###"},"scientificFormats-numberSystem-latn":{standard:"#E0"},"percentFormats-numberSystem-latn":{standard:"#,##0%"},"currencyFormats-numberSystem-latn":{currencySpacing:{beforeCurrency:{currencyMatch:"[:^S:]",surroundingMatch:"[:digit:]",insertBetween:"\xa0"},afterCurrency:{currencyMatch:"[:^S:]",surroundingMatch:"[:digit:]",insertBetween:"\xa0"}},standard:"\xa4#,##0.00",accounting:"\xa4#,##0.00;(\xa4#,##0.00)"},currencies:{ADP:{symbol:"ADP"},AED:{symbol:"AED"},AFA:{symbol:"AFA"},AFN:{symbol:"AFN"},ALK:{symbol:"ALK"},ALL:{symbol:"ALL"},AMD:{symbol:"AMD"},ANG:{symbol:"ANG"},AOA:{symbol:"AOA","symbol-alt-narrow":"Kz"},AOK:{symbol:"AOK"},AON:{symbol:"AON"},AOR:{symbol:"AOR"},ARA:{symbol:"ARA"},ARL:{symbol:"ARL"},ARM:{symbol:"ARM"},ARP:{symbol:"ARP"},ARS:{symbol:"ARS","symbol-alt-narrow":"$"},ATS:{symbol:"ATS"},AUD:{symbol:"A$","symbol-alt-narrow":"$"},AWG:{symbol:"AWG"},AZM:{symbol:"AZM"},AZN:{symbol:"AZN"},BAD:{symbol:"BAD"},BAM:{symbol:"BAM","symbol-alt-narrow":"KM"},BAN:{symbol:"BAN"},BBD:{symbol:"BBD","symbol-alt-narrow":"$"},BDT:{symbol:"BDT","symbol-alt-narrow":"\u09f3"},BEC:{symbol:"BEC"},BEF:{symbol:"BEF"},BEL:{symbol:"BEL"},BGL:{symbol:"BGL"},BGM:{symbol:"BGM"},BGN:{symbol:"BGN"},BGO:{symbol:"BGO"},BHD:{symbol:"BHD"},BIF:{symbol:"BIF"},BMD:{symbol:"BMD","symbol-alt-narrow":"$"},BND:{symbol:"BND","symbol-alt-narrow":"$"},BOB:{symbol:"BOB","symbol-alt-narrow":"Bs"},BOL:{symbol:"BOL"},BOP:{symbol:"BOP"},BOV:{symbol:"BOV"},BRB:{symbol:"BRB"},BRC:{symbol:"BRC"},BRE:{symbol:"BRE"},BRL:{symbol:"R$","symbol-alt-narrow":"R$"},BRN:{symbol:"BRN"},BRR:{symbol:"BRR"},BRZ:{symbol:"BRZ"},BSD:{symbol:"BSD","symbol-alt-narrow":"$"},BTN:{symbol:"BTN"},BUK:{symbol:"BUK"},BWP:{symbol:"BWP","symbol-alt-narrow":"P"},BYB:{symbol:"BYB"},BYN:{symbol:"BYN","symbol-alt-narrow":"\u0440."},BYR:{symbol:"BYR"},BZD:{symbol:"BZD","symbol-alt-narrow":"$"},CAD:{symbol:"CA$","symbol-alt-narrow":"$"},CDF:{symbol:"CDF"},CHE:{symbol:"CHE"},CHF:{symbol:"CHF"},CHW:{symbol:"CHW"},CLE:{symbol:"CLE"},CLF:{symbol:"CLF"},CLP:{symbol:"CLP","symbol-alt-narrow":"$"},CNH:{symbol:"CNH"},CNX:{symbol:"CNX"},CNY:{symbol:"CN\xa5","symbol-alt-narrow":"\xa5"},COP:{symbol:"COP","symbol-alt-narrow":"$"},COU:{symbol:"COU"},CRC:{symbol:"CRC","symbol-alt-narrow":"\u20a1"},CSD:{symbol:"CSD"},CSK:{symbol:"CSK"},CUC:{symbol:"CUC","symbol-alt-narrow":"$"},CUP:{symbol:"CUP","symbol-alt-narrow":"$"},CVE:{symbol:"CVE"},CYP:{symbol:"CYP"},CZK:{symbol:"CZK","symbol-alt-narrow":"K\u010d"},DDM:{symbol:"DDM"},DEM:{symbol:"DEM"},DJF:{symbol:"DJF"},DKK:{symbol:"DKK","symbol-alt-narrow":"kr"},DOP:{symbol:"DOP","symbol-alt-narrow":"$"},DZD:{symbol:"DZD"},ECS:{symbol:"ECS"},ECV:{symbol:"ECV"},EEK:{symbol:"EEK"},EGP:{symbol:"EGP","symbol-alt-narrow":"E\xa3"},ERN:{symbol:"ERN"},ESA:{symbol:"ESA"},ESB:{symbol:"ESB"},ESP:{symbol:"ESP","symbol-alt-narrow":"\u20a7"},ETB:{symbol:"ETB"},EUR:{symbol:"\u20ac","symbol-alt-narrow":"\u20ac"},FIM:{symbol:"FIM"},FJD:{symbol:"FJD","symbol-alt-narrow":"$"},FKP:{symbol:"FKP","symbol-alt-narrow":"\xa3"},FRF:{symbol:"FRF"},GBP:{symbol:"\xa3","symbol-alt-narrow":"\xa3"},GEK:{symbol:"GEK"},GEL:{symbol:"GEL","symbol-alt-narrow":"\u20be"},GHC:{symbol:"GHC"},GHS:{symbol:"GHS"},GIP:{symbol:"GIP","symbol-alt-narrow":"\xa3"},GMD:{symbol:"GMD"},GNF:{symbol:"GNF","symbol-alt-narrow":"FG"},GNS:{symbol:"GNS"},GQE:{symbol:"GQE"},GRD:{symbol:"GRD"},GTQ:{symbol:"GTQ","symbol-alt-narrow":"Q"},GWE:{symbol:"GWE"},GWP:{symbol:"GWP"},GYD:{symbol:"GYD","symbol-alt-narrow":"$"},HKD:{symbol:"HK$","symbol-alt-narrow":"$"},HNL:{symbol:"HNL","symbol-alt-narrow":"L"},HRD:{symbol:"HRD"},HRK:{symbol:"HRK","symbol-alt-narrow":"kn"},HTG:{symbol:"HTG"},HUF:{symbol:"HUF","symbol-alt-narrow":"Ft"},IDR:{symbol:"IDR","symbol-alt-narrow":"Rp"},IEP:{symbol:"IEP"},ILP:{symbol:"ILP"},ILR:{symbol:"ILR"},ILS:{symbol:"\u20aa","symbol-alt-narrow":"\u20aa"},INR:{symbol:"\u20b9","symbol-alt-narrow":"\u20b9"},IQD:{symbol:"IQD"},IRR:{symbol:"IRR"},ISJ:{symbol:"ISJ"},ISK:{symbol:"ISK","symbol-alt-narrow":"kr"},ITL:{symbol:"ITL"},JMD:{symbol:"JMD","symbol-alt-narrow":"$"},JOD:{symbol:"JOD"},JPY:{symbol:"\xa5","symbol-alt-narrow":"\xa5"},KES:{symbol:"KES"},KGS:{symbol:"KGS"},KHR:{symbol:"KHR","symbol-alt-narrow":"\u17db"},KMF:{symbol:"KMF","symbol-alt-narrow":"CF"},KPW:{symbol:"KPW","symbol-alt-narrow":"\u20a9"},KRH:{symbol:"KRH"},KRO:{symbol:"KRO"},KRW:{symbol:"\u20a9","symbol-alt-narrow":"\u20a9"},KWD:{symbol:"KWD"},KYD:{symbol:"KYD","symbol-alt-narrow":"$"},KZT:{symbol:"KZT","symbol-alt-narrow":"\u20b8"},LAK:{symbol:"LAK","symbol-alt-narrow":"\u20ad"},LBP:{symbol:"LBP","symbol-alt-narrow":"L\xa3"},LKR:{symbol:"LKR","symbol-alt-narrow":"Rs"},LRD:{symbol:"LRD","symbol-alt-narrow":"$"},LSL:{symbol:"LSL"},LTL:{symbol:"LTL","symbol-alt-narrow":"Lt"},LTT:{symbol:"LTT"},LUC:{symbol:"LUC"},LUF:{symbol:"LUF"},LUL:{symbol:"LUL"},LVL:{symbol:"LVL","symbol-alt-narrow":"Ls"},LVR:{symbol:"LVR"},LYD:{symbol:"LYD"},MAD:{symbol:"MAD"},MAF:{symbol:"MAF"},MCF:{symbol:"MCF"},MDC:{symbol:"MDC"},MDL:{symbol:"MDL"},MGA:{symbol:"MGA","symbol-alt-narrow":"Ar"},MGF:{symbol:"MGF"},MKD:{symbol:"MKD"},MKN:{symbol:"MKN"},MLF:{symbol:"MLF"},MMK:{symbol:"MMK","symbol-alt-narrow":"K"},MNT:{symbol:"MNT","symbol-alt-narrow":"\u20ae"},MOP:{symbol:"MOP"},MRO:{symbol:"MRO"},MRU:{symbol:"MRU"},MTL:{symbol:"MTL"},MTP:{symbol:"MTP"},MUR:{symbol:"MUR","symbol-alt-narrow":"Rs"},MVP:{symbol:"MVP"},MVR:{symbol:"MVR"},MWK:{symbol:"MWK"},MXN:{symbol:"MX$","symbol-alt-narrow":"$"},MXP:{symbol:"MXP"},MXV:{symbol:"MXV"},MYR:{symbol:"MYR","symbol-alt-narrow":"RM"},MZE:{symbol:"MZE"},MZM:{symbol:"MZM"},MZN:{symbol:"MZN"},NAD:{symbol:"NAD","symbol-alt-narrow":"$"},NGN:{symbol:"NGN","symbol-alt-narrow":"\u20a6"},NIC:{symbol:"NIC"},NIO:{symbol:"NIO","symbol-alt-narrow":"C$"},NLG:{symbol:"NLG"},NOK:{symbol:"NOK","symbol-alt-narrow":"kr"},NPR:{symbol:"NPR","symbol-alt-narrow":"Rs"},NZD:{symbol:"NZ$","symbol-alt-narrow":"$"},OMR:{symbol:"OMR"},PAB:{symbol:"PAB"},PEI:{symbol:"PEI"},PEN:{symbol:"PEN"},PES:{symbol:"PES"},PGK:{symbol:"PGK"},PHP:{symbol:"PHP","symbol-alt-narrow":"\u20b1"},PKR:{symbol:"PKR","symbol-alt-narrow":"Rs"},PLN:{symbol:"PLN","symbol-alt-narrow":"z\u0142"},PLZ:{symbol:"PLZ"},PTE:{symbol:"PTE"},PYG:{symbol:"PYG","symbol-alt-narrow":"\u20b2"},QAR:{symbol:"QAR"},RHD:{symbol:"RHD"},ROL:{symbol:"ROL"},RON:{symbol:"RON","symbol-alt-narrow":"lei"},RSD:{symbol:"RSD"},RUB:{symbol:"RUB","symbol-alt-narrow":"\u20bd"},RUR:{symbol:"RUR","symbol-alt-narrow":"\u0440."},RWF:{symbol:"RWF","symbol-alt-narrow":"RF"},SAR:{symbol:"SAR"},SBD:{symbol:"SBD","symbol-alt-narrow":"$"},SCR:{symbol:"SCR"},SDD:{symbol:"SDD"},SDG:{symbol:"SDG"},SDP:{symbol:"SDP"},SEK:{symbol:"SEK","symbol-alt-narrow":"kr"},SGD:{symbol:"SGD","symbol-alt-narrow":"$"},SHP:{symbol:"SHP","symbol-alt-narrow":"\xa3"},SIT:{symbol:"SIT"},SKK:{symbol:"SKK"},SLL:{symbol:"SLL"},SOS:{symbol:"SOS"},SRD:{symbol:"SRD","symbol-alt-narrow":"$"},SRG:{symbol:"SRG"},SSP:{symbol:"SSP","symbol-alt-narrow":"\xa3"},STD:{symbol:"STD"},STN:{symbol:"STN","symbol-alt-narrow":"Db"},SUR:{symbol:"SUR"},SVC:{symbol:"SVC"},SYP:{symbol:"SYP","symbol-alt-narrow":"\xa3"},SZL:{symbol:"SZL"},THB:{symbol:"THB","symbol-alt-narrow":"\u0e3f"},TJR:{symbol:"TJR"},TJS:{symbol:"TJS"},TMM:{symbol:"TMM"},TMT:{symbol:"TMT"},TND:{symbol:"TND"},TOP:{symbol:"TOP","symbol-alt-narrow":"T$"},TPE:{symbol:"TPE"},TRL:{symbol:"TRL"},TRY:{symbol:"TRY","symbol-alt-narrow":"\u20ba"},TTD:{symbol:"TTD","symbol-alt-narrow":"$"},TWD:{symbol:"NT$","symbol-alt-narrow":"$"},TZS:{symbol:"TZS"},UAH:{symbol:"UAH","symbol-alt-narrow":"\u20b4"},UAK:{symbol:"UAK"},UGS:{symbol:"UGS"},UGX:{symbol:"UGX"},USD:{symbol:"$","symbol-alt-narrow":"$"},USN:{symbol:"USN"},USS:{symbol:"USS"},UYI:{symbol:"UYI"},UYP:{symbol:"UYP"},UYU:{symbol:"UYU","symbol-alt-narrow":"$"},UYW:{symbol:"UYW"},UZS:{symbol:"UZS"},VEB:{symbol:"VEB"},VEF:{symbol:"VEF","symbol-alt-narrow":"Bs"},VES:{symbol:"VES"},VND:{symbol:"\u20ab","symbol-alt-narrow":"\u20ab"},VNN:{symbol:"VNN"},VUV:{symbol:"VUV"},WST:{symbol:"WST"},XAF:{symbol:"FCFA"},XAG:{symbol:"XAG"},XAU:{symbol:"XAU"},XBA:{symbol:"XBA"},XBB:{symbol:"XBB"},XBC:{symbol:"XBC"},XBD:{symbol:"XBD"},XCD:{symbol:"EC$","symbol-alt-narrow":"$"},XDR:{symbol:"XDR"},XEU:{symbol:"XEU"},XFO:{symbol:"XFO"},XFU:{symbol:"XFU"},XOF:{symbol:"CFA"},XPD:{symbol:"XPD"},XPF:{symbol:"CFPF"},XPT:{symbol:"XPT"},XRE:{symbol:"XRE"},XSU:{symbol:"XSU"},XTS:{symbol:"XTS"},XUA:{symbol:"XUA"},XXX:{symbol:"\xa4"},YDD:{symbol:"YDD"},YER:{symbol:"YER"},YUD:{symbol:"YUD"},YUM:{symbol:"YUM"},YUN:{symbol:"YUN"},YUR:{symbol:"YUR"},ZAL:{symbol:"ZAL"},ZAR:{symbol:"ZAR","symbol-alt-narrow":"R"},ZMK:{symbol:"ZMK"},ZMW:{symbol:"ZMW","symbol-alt-narrow":"ZK"},ZRN:{symbol:"ZRN"},ZRZ:{symbol:"ZRZ"},ZWD:{symbol:"ZWD"},ZWL:{symbol:"ZWL"},ZWR:{symbol:"ZWR"}}}}}}},92286:function(t,e){e.default=void 0;e.default={"af-NA":1,agq:1,ak:1,ar:6,"ar-EH":1,"ar-ER":1,"ar-KM":1,"ar-LB":1,"ar-MA":1,"ar-MR":1,"ar-PS":1,"ar-SO":1,"ar-SS":1,"ar-TD":1,"ar-TN":1,asa:1,ast:1,az:1,"az-Cyrl":1,bas:1,be:1,bem:1,bez:1,bg:1,bm:1,br:1,bs:1,"bs-Cyrl":1,ca:1,ce:1,cgg:1,ckb:6,cs:1,cy:1,da:1,de:1,dje:1,dsb:1,dua:1,dyo:1,ee:1,el:1,"en-001":1,"en-AE":6,"en-BI":1,"en-MP":1,"en-MV":5,"en-SD":6,eo:1,es:1,et:1,eu:1,ewo:1,fa:6,ff:1,"ff-Adlm":1,fi:1,fo:1,fr:1,"fr-DJ":6,"fr-DZ":6,"fr-SY":6,fur:1,fy:1,ga:1,gd:1,gl:1,gsw:1,gv:1,ha:1,hr:1,hsb:1,hu:1,hy:1,ia:1,ig:1,is:1,it:1,jgo:1,jmc:1,ka:1,kab:6,kde:1,kea:1,khq:1,kk:1,kkj:1,kl:1,"ko-KP":1,ksb:1,ksf:1,ksh:1,ku:1,kw:1,ky:1,lag:1,lb:1,lg:1,ln:1,lrc:6,lt:1,lu:1,lv:1,"mas-TZ":1,mfe:1,mg:1,mgo:1,mi:1,mk:1,mn:1,ms:1,mua:1,mzn:6,naq:1,nds:1,nl:1,nmg:1,nnh:1,no:1,nus:1,nyn:1,os:1,pcm:1,pl:1,ps:6,"pt-AO":1,"pt-CH":1,"pt-CV":1,"pt-GQ":1,"pt-GW":1,"pt-LU":1,"pt-ST":1,"pt-TL":1,"qu-BO":1,"qu-EC":1,rm:1,rn:1,ro:1,rof:1,ru:1,rw:1,rwk:1,sah:1,sbp:1,sc:1,se:1,ses:1,sg:1,shi:1,"shi-Latn":1,si:1,sk:1,sl:1,smn:1,so:1,"so-DJ":6,sq:1,sr:1,"sr-Latn":1,sv:1,sw:1,"ta-LK":1,"ta-MY":1,teo:1,tg:1,"ti-ER":1,tk:1,to:1,tr:1,tt:1,twq:1,tzm:1,uk:1,uz:1,"uz-Arab":6,"uz-Cyrl":1,vai:1,"vai-Latn":1,vi:1,vun:1,wae:1,wo:1,xog:1,yav:1,yi:1,yo:1,zgh:1},t.exports=e.default,t.exports.default=e.default},73806:function(t,e){e.default=void 0;e.default={"en-150":"en-001","en-AG":"en-001","en-AI":"en-001","en-AU":"en-001","en-BB":"en-001","en-BM":"en-001","en-BS":"en-001","en-BW":"en-001","en-BZ":"en-001","en-CC":"en-001","en-CK":"en-001","en-CM":"en-001","en-CX":"en-001","en-CY":"en-001","en-DG":"en-001","en-DM":"en-001","en-ER":"en-001","en-FJ":"en-001","en-FK":"en-001","en-FM":"en-001","en-GB":"en-001","en-GD":"en-001","en-GG":"en-001","en-GH":"en-001","en-GI":"en-001","en-GM":"en-001","en-GY":"en-001","en-HK":"en-001","en-IE":"en-001","en-IL":"en-001","en-IM":"en-001","en-IN":"en-001","en-IO":"en-001","en-JE":"en-001","en-JM":"en-001","en-KE":"en-001","en-KI":"en-001","en-KN":"en-001","en-KY":"en-001","en-LC":"en-001","en-LR":"en-001","en-LS":"en-001","en-MG":"en-001","en-MO":"en-001","en-MS":"en-001","en-MT":"en-001","en-MU":"en-001","en-MV":"en-001","en-MW":"en-001","en-MY":"en-001","en-NA":"en-001","en-NF":"en-001","en-NG":"en-001","en-NR":"en-001","en-NU":"en-001","en-NZ":"en-001","en-PG":"en-001","en-PK":"en-001","en-PN":"en-001","en-PW":"en-001","en-RW":"en-001","en-SB":"en-001","en-SC":"en-001","en-SD":"en-001","en-SG":"en-001","en-SH":"en-001","en-SL":"en-001","en-SS":"en-001","en-SX":"en-001","en-SZ":"en-001","en-TC":"en-001","en-TK":"en-001","en-TO":"en-001","en-TT":"en-001","en-TV":"en-001","en-TZ":"en-001","en-UG":"en-001","en-VC":"en-001","en-VG":"en-001","en-VU":"en-001","en-WS":"en-001","en-ZA":"en-001","en-ZM":"en-001","en-ZW":"en-001","en-AT":"en-150","en-BE":"en-150","en-CH":"en-150","en-DE":"en-150","en-DK":"en-150","en-FI":"en-150","en-NL":"en-150","en-SE":"en-150","en-SI":"en-150","hi-Latn":"en-IN","es-AR":"es-419","es-BO":"es-419","es-BR":"es-419","es-BZ":"es-419","es-CL":"es-419","es-CO":"es-419","es-CR":"es-419","es-CU":"es-419","es-DO":"es-419","es-EC":"es-419","es-GT":"es-419","es-HN":"es-419","es-MX":"es-419","es-NI":"es-419","es-PA":"es-419","es-PE":"es-419","es-PR":"es-419","es-PY":"es-419","es-SV":"es-419","es-US":"es-419","es-UY":"es-419","es-VE":"es-419",nb:"no",nn:"no","pt-AO":"pt-PT","pt-CH":"pt-PT","pt-CV":"pt-PT","pt-FR":"pt-PT","pt-GQ":"pt-PT","pt-GW":"pt-PT","pt-LU":"pt-PT","pt-MO":"pt-PT","pt-MZ":"pt-PT","pt-ST":"pt-PT","pt-TL":"pt-PT","az-Arab":"und","az-Cyrl":"und","bal-Latn":"und","blt-Latn":"und","bm-Nkoo":"und","bs-Cyrl":"und","byn-Latn":"und","cu-Glag":"und","dje-Arab":"und","dyo-Arab":"und","en-Dsrt":"und","en-Shaw":"und","ff-Adlm":"und","ff-Arab":"und","ha-Arab":"und","iu-Latn":"und","kk-Arab":"und","ks-Deva":"und","ku-Arab":"und","ky-Arab":"und","ky-Latn":"und","ml-Arab":"und","mn-Mong":"und","mni-Mtei":"und","ms-Arab":"und","pa-Arab":"und","sat-Deva":"und","sd-Deva":"und","sd-Khoj":"und","sd-Sind":"und","shi-Latn":"und","so-Arab":"und","sr-Latn":"und","sw-Arab":"und","tg-Arab":"und","ug-Cyrl":"und","uz-Arab":"und","uz-Cyrl":"und","vai-Latn":"und","wo-Arab":"und","yo-Arab":"und","yue-Hans":"und","zh-Hant":"und","zh-Hant-MO":"zh-Hant-HK"},t.exports=e.default,t.exports.default=e.default},57421:function(t,e){e.supplementalCldr=void 0;e.supplementalCldr={supplemental:{version:{_unicodeVersion:"12.1.0",_cldrVersion:"36"},likelySubtags:{aa:"aa-Latn-ET",aai:"aai-Latn-ZZ",aak:"aak-Latn-ZZ",aau:"aau-Latn-ZZ",ab:"ab-Cyrl-GE",abi:"abi-Latn-ZZ",abq:"abq-Cyrl-ZZ",abr:"abr-Latn-GH",abt:"abt-Latn-ZZ",aby:"aby-Latn-ZZ",acd:"acd-Latn-ZZ",ace:"ace-Latn-ID",ach:"ach-Latn-UG",ada:"ada-Latn-GH",ade:"ade-Latn-ZZ",adj:"adj-Latn-ZZ",adp:"adp-Tibt-BT",ady:"ady-Cyrl-RU",adz:"adz-Latn-ZZ",ae:"ae-Avst-IR",aeb:"aeb-Arab-TN",aey:"aey-Latn-ZZ",af:"af-Latn-ZA",agc:"agc-Latn-ZZ",agd:"agd-Latn-ZZ",agg:"agg-Latn-ZZ",agm:"agm-Latn-ZZ",ago:"ago-Latn-ZZ",agq:"agq-Latn-CM",aha:"aha-Latn-ZZ",ahl:"ahl-Latn-ZZ",aho:"aho-Ahom-IN",ajg:"ajg-Latn-ZZ",ak:"ak-Latn-GH",akk:"akk-Xsux-IQ",ala:"ala-Latn-ZZ",ali:"ali-Latn-ZZ",aln:"aln-Latn-XK",alt:"alt-Cyrl-RU",am:"am-Ethi-ET",amm:"amm-Latn-ZZ",amn:"amn-Latn-ZZ",amo:"amo-Latn-NG",amp:"amp-Latn-ZZ",an:"an-Latn-ES",anc:"anc-Latn-ZZ",ank:"ank-Latn-ZZ",ann:"ann-Latn-ZZ",any:"any-Latn-ZZ",aoj:"aoj-Latn-ZZ",aom:"aom-Latn-ZZ",aoz:"aoz-Latn-ID",apc:"apc-Arab-ZZ",apd:"apd-Arab-TG",ape:"ape-Latn-ZZ",apr:"apr-Latn-ZZ",aps:"aps-Latn-ZZ",apz:"apz-Latn-ZZ",ar:"ar-Arab-EG",arc:"arc-Armi-IR","arc-Nbat":"arc-Nbat-JO","arc-Palm":"arc-Palm-SY",arh:"arh-Latn-ZZ",arn:"arn-Latn-CL",aro:"aro-Latn-BO",arq:"arq-Arab-DZ",ars:"ars-Arab-SA",ary:"ary-Arab-MA",arz:"arz-Arab-EG",as:"as-Beng-IN",asa:"asa-Latn-TZ",ase:"ase-Sgnw-US",asg:"asg-Latn-ZZ",aso:"aso-Latn-ZZ",ast:"ast-Latn-ES",ata:"ata-Latn-ZZ",atg:"atg-Latn-ZZ",atj:"atj-Latn-CA",auy:"auy-Latn-ZZ",av:"av-Cyrl-RU",avl:"avl-Arab-ZZ",avn:"avn-Latn-ZZ",avt:"avt-Latn-ZZ",avu:"avu-Latn-ZZ",awa:"awa-Deva-IN",awb:"awb-Latn-ZZ",awo:"awo-Latn-ZZ",awx:"awx-Latn-ZZ",ay:"ay-Latn-BO",ayb:"ayb-Latn-ZZ",az:"az-Latn-AZ","az-Arab":"az-Arab-IR","az-IQ":"az-Arab-IQ","az-IR":"az-Arab-IR","az-RU":"az-Cyrl-RU",ba:"ba-Cyrl-RU",bal:"bal-Arab-PK",ban:"ban-Latn-ID",bap:"bap-Deva-NP",bar:"bar-Latn-AT",bas:"bas-Latn-CM",bav:"bav-Latn-ZZ",bax:"bax-Bamu-CM",bba:"bba-Latn-ZZ",bbb:"bbb-Latn-ZZ",bbc:"bbc-Latn-ID",bbd:"bbd-Latn-ZZ",bbj:"bbj-Latn-CM",bbp:"bbp-Latn-ZZ",bbr:"bbr-Latn-ZZ",bcf:"bcf-Latn-ZZ",bch:"bch-Latn-ZZ",bci:"bci-Latn-CI",bcm:"bcm-Latn-ZZ",bcn:"bcn-Latn-ZZ",bco:"bco-Latn-ZZ",bcq:"bcq-Ethi-ZZ",bcu:"bcu-Latn-ZZ",bdd:"bdd-Latn-ZZ",be:"be-Cyrl-BY",bef:"bef-Latn-ZZ",beh:"beh-Latn-ZZ",bej:"bej-Arab-SD",bem:"bem-Latn-ZM",bet:"bet-Latn-ZZ",bew:"bew-Latn-ID",bex:"bex-Latn-ZZ",bez:"bez-Latn-TZ",bfd:"bfd-Latn-CM",bfq:"bfq-Taml-IN",bft:"bft-Arab-PK",bfy:"bfy-Deva-IN",bg:"bg-Cyrl-BG",bgc:"bgc-Deva-IN",bgn:"bgn-Arab-PK",bgx:"bgx-Grek-TR",bhb:"bhb-Deva-IN",bhg:"bhg-Latn-ZZ",bhi:"bhi-Deva-IN",bhl:"bhl-Latn-ZZ",bho:"bho-Deva-IN",bhy:"bhy-Latn-ZZ",bi:"bi-Latn-VU",bib:"bib-Latn-ZZ",big:"big-Latn-ZZ",bik:"bik-Latn-PH",bim:"bim-Latn-ZZ",bin:"bin-Latn-NG",bio:"bio-Latn-ZZ",biq:"biq-Latn-ZZ",bjh:"bjh-Latn-ZZ",bji:"bji-Ethi-ZZ",bjj:"bjj-Deva-IN",bjn:"bjn-Latn-ID",bjo:"bjo-Latn-ZZ",bjr:"bjr-Latn-ZZ",bjt:"bjt-Latn-SN",bjz:"bjz-Latn-ZZ",bkc:"bkc-Latn-ZZ",bkm:"bkm-Latn-CM",bkq:"bkq-Latn-ZZ",bku:"bku-Latn-PH",bkv:"bkv-Latn-ZZ",blt:"blt-Tavt-VN",bm:"bm-Latn-ML",bmh:"bmh-Latn-ZZ",bmk:"bmk-Latn-ZZ",bmq:"bmq-Latn-ML",bmu:"bmu-Latn-ZZ",bn:"bn-Beng-BD",bng:"bng-Latn-ZZ",bnm:"bnm-Latn-ZZ",bnp:"bnp-Latn-ZZ",bo:"bo-Tibt-CN",boj:"boj-Latn-ZZ",bom:"bom-Latn-ZZ",bon:"bon-Latn-ZZ",bpy:"bpy-Beng-IN",bqc:"bqc-Latn-ZZ",bqi:"bqi-Arab-IR",bqp:"bqp-Latn-ZZ",bqv:"bqv-Latn-CI",br:"br-Latn-FR",bra:"bra-Deva-IN",brh:"brh-Arab-PK",brx:"brx-Deva-IN",brz:"brz-Latn-ZZ",bs:"bs-Latn-BA",bsj:"bsj-Latn-ZZ",bsq:"bsq-Bass-LR",bss:"bss-Latn-CM",bst:"bst-Ethi-ZZ",bto:"bto-Latn-PH",btt:"btt-Latn-ZZ",btv:"btv-Deva-PK",bua:"bua-Cyrl-RU",buc:"buc-Latn-YT",bud:"bud-Latn-ZZ",bug:"bug-Latn-ID",buk:"buk-Latn-ZZ",bum:"bum-Latn-CM",buo:"buo-Latn-ZZ",bus:"bus-Latn-ZZ",buu:"buu-Latn-ZZ",bvb:"bvb-Latn-GQ",bwd:"bwd-Latn-ZZ",bwr:"bwr-Latn-ZZ",bxh:"bxh-Latn-ZZ",bye:"bye-Latn-ZZ",byn:"byn-Ethi-ER",byr:"byr-Latn-ZZ",bys:"bys-Latn-ZZ",byv:"byv-Latn-CM",byx:"byx-Latn-ZZ",bza:"bza-Latn-ZZ",bze:"bze-Latn-ML",bzf:"bzf-Latn-ZZ",bzh:"bzh-Latn-ZZ",bzw:"bzw-Latn-ZZ",ca:"ca-Latn-ES",can:"can-Latn-ZZ",cbj:"cbj-Latn-ZZ",cch:"cch-Latn-NG",ccp:"ccp-Cakm-BD",ce:"ce-Cyrl-RU",ceb:"ceb-Latn-PH",cfa:"cfa-Latn-ZZ",cgg:"cgg-Latn-UG",ch:"ch-Latn-GU",chk:"chk-Latn-FM",chm:"chm-Cyrl-RU",cho:"cho-Latn-US",chp:"chp-Latn-CA",chr:"chr-Cher-US",cic:"cic-Latn-US",cja:"cja-Arab-KH",cjm:"cjm-Cham-VN",cjv:"cjv-Latn-ZZ",ckb:"ckb-Arab-IQ",ckl:"ckl-Latn-ZZ",cko:"cko-Latn-ZZ",cky:"cky-Latn-ZZ",cla:"cla-Latn-ZZ",cme:"cme-Latn-ZZ",cmg:"cmg-Soyo-MN",co:"co-Latn-FR",cop:"cop-Copt-EG",cps:"cps-Latn-PH",cr:"cr-Cans-CA",crh:"crh-Cyrl-UA",crj:"crj-Cans-CA",crk:"crk-Cans-CA",crl:"crl-Cans-CA",crm:"crm-Cans-CA",crs:"crs-Latn-SC",cs:"cs-Latn-CZ",csb:"csb-Latn-PL",csw:"csw-Cans-CA",ctd:"ctd-Pauc-MM",cu:"cu-Cyrl-RU","cu-Glag":"cu-Glag-BG",cv:"cv-Cyrl-RU",cy:"cy-Latn-GB",da:"da-Latn-DK",dad:"dad-Latn-ZZ",daf:"daf-Latn-ZZ",dag:"dag-Latn-ZZ",dah:"dah-Latn-ZZ",dak:"dak-Latn-US",dar:"dar-Cyrl-RU",dav:"dav-Latn-KE",dbd:"dbd-Latn-ZZ",dbq:"dbq-Latn-ZZ",dcc:"dcc-Arab-IN",ddn:"ddn-Latn-ZZ",de:"de-Latn-DE",ded:"ded-Latn-ZZ",den:"den-Latn-CA",dga:"dga-Latn-ZZ",dgh:"dgh-Latn-ZZ",dgi:"dgi-Latn-ZZ",dgl:"dgl-Arab-ZZ",dgr:"dgr-Latn-CA",dgz:"dgz-Latn-ZZ",dia:"dia-Latn-ZZ",dje:"dje-Latn-NE",dnj:"dnj-Latn-CI",dob:"dob-Latn-ZZ",doi:"doi-Arab-IN",dop:"dop-Latn-ZZ",dow:"dow-Latn-ZZ",drh:"drh-Mong-CN",dri:"dri-Latn-ZZ",drs:"drs-Ethi-ZZ",dsb:"dsb-Latn-DE",dtm:"dtm-Latn-ML",dtp:"dtp-Latn-MY",dts:"dts-Latn-ZZ",dty:"dty-Deva-NP",dua:"dua-Latn-CM",duc:"duc-Latn-ZZ",dud:"dud-Latn-ZZ",dug:"dug-Latn-ZZ",dv:"dv-Thaa-MV",dva:"dva-Latn-ZZ",dww:"dww-Latn-ZZ",dyo:"dyo-Latn-SN",dyu:"dyu-Latn-BF",dz:"dz-Tibt-BT",dzg:"dzg-Latn-ZZ",ebu:"ebu-Latn-KE",ee:"ee-Latn-GH",efi:"efi-Latn-NG",egl:"egl-Latn-IT",egy:"egy-Egyp-EG",eka:"eka-Latn-ZZ",eky:"eky-Kali-MM",el:"el-Grek-GR",ema:"ema-Latn-ZZ",emi:"emi-Latn-ZZ",en:"en-Latn-US","en-Shaw":"en-Shaw-GB",enn:"enn-Latn-ZZ",enq:"enq-Latn-ZZ",eo:"eo-Latn-001",eri:"eri-Latn-ZZ",es:"es-Latn-ES",esg:"esg-Gonm-IN",esu:"esu-Latn-US",et:"et-Latn-EE",etr:"etr-Latn-ZZ",ett:"ett-Ital-IT",etu:"etu-Latn-ZZ",etx:"etx-Latn-ZZ",eu:"eu-Latn-ES",ewo:"ewo-Latn-CM",ext:"ext-Latn-ES",fa:"fa-Arab-IR",faa:"faa-Latn-ZZ",fab:"fab-Latn-ZZ",fag:"fag-Latn-ZZ",fai:"fai-Latn-ZZ",fan:"fan-Latn-GQ",ff:"ff-Latn-SN","ff-Adlm":"ff-Adlm-GN",ffi:"ffi-Latn-ZZ",ffm:"ffm-Latn-ML",fi:"fi-Latn-FI",fia:"fia-Arab-SD",fil:"fil-Latn-PH",fit:"fit-Latn-SE",fj:"fj-Latn-FJ",flr:"flr-Latn-ZZ",fmp:"fmp-Latn-ZZ",fo:"fo-Latn-FO",fod:"fod-Latn-ZZ",fon:"fon-Latn-BJ",for:"for-Latn-ZZ",fpe:"fpe-Latn-ZZ",fqs:"fqs-Latn-ZZ",fr:"fr-Latn-FR",frc:"frc-Latn-US",frp:"frp-Latn-FR",frr:"frr-Latn-DE",frs:"frs-Latn-DE",fub:"fub-Arab-CM",fud:"fud-Latn-WF",fue:"fue-Latn-ZZ",fuf:"fuf-Latn-GN",fuh:"fuh-Latn-ZZ",fuq:"fuq-Latn-NE",fur:"fur-Latn-IT",fuv:"fuv-Latn-NG",fuy:"fuy-Latn-ZZ",fvr:"fvr-Latn-SD",fy:"fy-Latn-NL",ga:"ga-Latn-IE",gaa:"gaa-Latn-GH",gaf:"gaf-Latn-ZZ",gag:"gag-Latn-MD",gah:"gah-Latn-ZZ",gaj:"gaj-Latn-ZZ",gam:"gam-Latn-ZZ",gan:"gan-Hans-CN",gaw:"gaw-Latn-ZZ",gay:"gay-Latn-ID",gba:"gba-Latn-ZZ",gbf:"gbf-Latn-ZZ",gbm:"gbm-Deva-IN",gby:"gby-Latn-ZZ",gbz:"gbz-Arab-IR",gcr:"gcr-Latn-GF",gd:"gd-Latn-GB",gde:"gde-Latn-ZZ",gdn:"gdn-Latn-ZZ",gdr:"gdr-Latn-ZZ",geb:"geb-Latn-ZZ",gej:"gej-Latn-ZZ",gel:"gel-Latn-ZZ",gez:"gez-Ethi-ET",gfk:"gfk-Latn-ZZ",ggn:"ggn-Deva-NP",ghs:"ghs-Latn-ZZ",gil:"gil-Latn-KI",gim:"gim-Latn-ZZ",gjk:"gjk-Arab-PK",gjn:"gjn-Latn-ZZ",gju:"gju-Arab-PK",gkn:"gkn-Latn-ZZ",gkp:"gkp-Latn-ZZ",gl:"gl-Latn-ES",glk:"glk-Arab-IR",gmm:"gmm-Latn-ZZ",gmv:"gmv-Ethi-ZZ",gn:"gn-Latn-PY",gnd:"gnd-Latn-ZZ",gng:"gng-Latn-ZZ",god:"god-Latn-ZZ",gof:"gof-Ethi-ZZ",goi:"goi-Latn-ZZ",gom:"gom-Deva-IN",gon:"gon-Telu-IN",gor:"gor-Latn-ID",gos:"gos-Latn-NL",got:"got-Goth-UA",grb:"grb-Latn-ZZ",grc:"grc-Cprt-CY","grc-Linb":"grc-Linb-GR",grt:"grt-Beng-IN",grw:"grw-Latn-ZZ",gsw:"gsw-Latn-CH",gu:"gu-Gujr-IN",gub:"gub-Latn-BR",guc:"guc-Latn-CO",gud:"gud-Latn-ZZ",gur:"gur-Latn-GH",guw:"guw-Latn-ZZ",gux:"gux-Latn-ZZ",guz:"guz-Latn-KE",gv:"gv-Latn-IM",gvf:"gvf-Latn-ZZ",gvr:"gvr-Deva-NP",gvs:"gvs-Latn-ZZ",gwc:"gwc-Arab-ZZ",gwi:"gwi-Latn-CA",gwt:"gwt-Arab-ZZ",gyi:"gyi-Latn-ZZ",ha:"ha-Latn-NG","ha-CM":"ha-Arab-CM","ha-SD":"ha-Arab-SD",hag:"hag-Latn-ZZ",hak:"hak-Hans-CN",ham:"ham-Latn-ZZ",haw:"haw-Latn-US",haz:"haz-Arab-AF",hbb:"hbb-Latn-ZZ",hdy:"hdy-Ethi-ZZ",he:"he-Hebr-IL",hhy:"hhy-Latn-ZZ",hi:"hi-Deva-IN",hia:"hia-Latn-ZZ",hif:"hif-Latn-FJ",hig:"hig-Latn-ZZ",hih:"hih-Latn-ZZ",hil:"hil-Latn-PH",hla:"hla-Latn-ZZ",hlu:"hlu-Hluw-TR",hmd:"hmd-Plrd-CN",hmt:"hmt-Latn-ZZ",hnd:"hnd-Arab-PK",hne:"hne-Deva-IN",hnj:"hnj-Hmng-LA",hnn:"hnn-Latn-PH",hno:"hno-Arab-PK",ho:"ho-Latn-PG",hoc:"hoc-Deva-IN",hoj:"hoj-Deva-IN",hot:"hot-Latn-ZZ",hr:"hr-Latn-HR",hsb:"hsb-Latn-DE",hsn:"hsn-Hans-CN",ht:"ht-Latn-HT",hu:"hu-Latn-HU",hui:"hui-Latn-ZZ",hy:"hy-Armn-AM",hz:"hz-Latn-NA",ia:"ia-Latn-001",ian:"ian-Latn-ZZ",iar:"iar-Latn-ZZ",iba:"iba-Latn-MY",ibb:"ibb-Latn-NG",iby:"iby-Latn-ZZ",ica:"ica-Latn-ZZ",ich:"ich-Latn-ZZ",id:"id-Latn-ID",idd:"idd-Latn-ZZ",idi:"idi-Latn-ZZ",idu:"idu-Latn-ZZ",ife:"ife-Latn-TG",ig:"ig-Latn-NG",igb:"igb-Latn-ZZ",ige:"ige-Latn-ZZ",ii:"ii-Yiii-CN",ijj:"ijj-Latn-ZZ",ik:"ik-Latn-US",ikk:"ikk-Latn-ZZ",ikt:"ikt-Latn-CA",ikw:"ikw-Latn-ZZ",ikx:"ikx-Latn-ZZ",ilo:"ilo-Latn-PH",imo:"imo-Latn-ZZ",in:"in-Latn-ID",inh:"inh-Cyrl-RU",io:"io-Latn-001",iou:"iou-Latn-ZZ",iri:"iri-Latn-ZZ",is:"is-Latn-IS",it:"it-Latn-IT",iu:"iu-Cans-CA",iw:"iw-Hebr-IL",iwm:"iwm-Latn-ZZ",iws:"iws-Latn-ZZ",izh:"izh-Latn-RU",izi:"izi-Latn-ZZ",ja:"ja-Jpan-JP",jab:"jab-Latn-ZZ",jam:"jam-Latn-JM",jbo:"jbo-Latn-001",jbu:"jbu-Latn-ZZ",jen:"jen-Latn-ZZ",jgk:"jgk-Latn-ZZ",jgo:"jgo-Latn-CM",ji:"ji-Hebr-UA",jib:"jib-Latn-ZZ",jmc:"jmc-Latn-TZ",jml:"jml-Deva-NP",jra:"jra-Latn-ZZ",jut:"jut-Latn-DK",jv:"jv-Latn-ID",jw:"jw-Latn-ID",ka:"ka-Geor-GE",kaa:"kaa-Cyrl-UZ",kab:"kab-Latn-DZ",kac:"kac-Latn-MM",kad:"kad-Latn-ZZ",kai:"kai-Latn-ZZ",kaj:"kaj-Latn-NG",kam:"kam-Latn-KE",kao:"kao-Latn-ML",kbd:"kbd-Cyrl-RU",kbm:"kbm-Latn-ZZ",kbp:"kbp-Latn-ZZ",kbq:"kbq-Latn-ZZ",kbx:"kbx-Latn-ZZ",kby:"kby-Arab-NE",kcg:"kcg-Latn-NG",kck:"kck-Latn-ZW",kcl:"kcl-Latn-ZZ",kct:"kct-Latn-ZZ",kde:"kde-Latn-TZ",kdh:"kdh-Arab-TG",kdl:"kdl-Latn-ZZ",kdt:"kdt-Thai-TH",kea:"kea-Latn-CV",ken:"ken-Latn-CM",kez:"kez-Latn-ZZ",kfo:"kfo-Latn-CI",kfr:"kfr-Deva-IN",kfy:"kfy-Deva-IN",kg:"kg-Latn-CD",kge:"kge-Latn-ID",kgf:"kgf-Latn-ZZ",kgp:"kgp-Latn-BR",kha:"kha-Latn-IN",khb:"khb-Talu-CN",khn:"khn-Deva-IN",khq:"khq-Latn-ML",khs:"khs-Latn-ZZ",kht:"kht-Mymr-IN",khw:"khw-Arab-PK",khz:"khz-Latn-ZZ",ki:"ki-Latn-KE",kij:"kij-Latn-ZZ",kiu:"kiu-Latn-TR",kiw:"kiw-Latn-ZZ",kj:"kj-Latn-NA",kjd:"kjd-Latn-ZZ",kjg:"kjg-Laoo-LA",kjs:"kjs-Latn-ZZ",kjy:"kjy-Latn-ZZ",kk:"kk-Cyrl-KZ","kk-AF":"kk-Arab-AF","kk-Arab":"kk-Arab-CN","kk-CN":"kk-Arab-CN","kk-IR":"kk-Arab-IR","kk-MN":"kk-Arab-MN",kkc:"kkc-Latn-ZZ",kkj:"kkj-Latn-CM",kl:"kl-Latn-GL",kln:"kln-Latn-KE",klq:"klq-Latn-ZZ",klt:"klt-Latn-ZZ",klx:"klx-Latn-ZZ",km:"km-Khmr-KH",kmb:"kmb-Latn-AO",kmh:"kmh-Latn-ZZ",kmo:"kmo-Latn-ZZ",kms:"kms-Latn-ZZ",kmu:"kmu-Latn-ZZ",kmw:"kmw-Latn-ZZ",kn:"kn-Knda-IN",knf:"knf-Latn-GW",knp:"knp-Latn-ZZ",ko:"ko-Kore-KR",koi:"koi-Cyrl-RU",kok:"kok-Deva-IN",kol:"kol-Latn-ZZ",kos:"kos-Latn-FM",koz:"koz-Latn-ZZ",kpe:"kpe-Latn-LR",kpf:"kpf-Latn-ZZ",kpo:"kpo-Latn-ZZ",kpr:"kpr-Latn-ZZ",kpx:"kpx-Latn-ZZ",kqb:"kqb-Latn-ZZ",kqf:"kqf-Latn-ZZ",kqs:"kqs-Latn-ZZ",kqy:"kqy-Ethi-ZZ",kr:"kr-Latn-ZZ",krc:"krc-Cyrl-RU",kri:"kri-Latn-SL",krj:"krj-Latn-PH",krl:"krl-Latn-RU",krs:"krs-Latn-ZZ",kru:"kru-Deva-IN",ks:"ks-Arab-IN",ksb:"ksb-Latn-TZ",ksd:"ksd-Latn-ZZ",ksf:"ksf-Latn-CM",ksh:"ksh-Latn-DE",ksj:"ksj-Latn-ZZ",ksr:"ksr-Latn-ZZ",ktb:"ktb-Ethi-ZZ",ktm:"ktm-Latn-ZZ",kto:"kto-Latn-ZZ",ktr:"ktr-Latn-MY",ku:"ku-Latn-TR","ku-Arab":"ku-Arab-IQ","ku-LB":"ku-Arab-LB",kub:"kub-Latn-ZZ",kud:"kud-Latn-ZZ",kue:"kue-Latn-ZZ",kuj:"kuj-Latn-ZZ",kum:"kum-Cyrl-RU",kun:"kun-Latn-ZZ",kup:"kup-Latn-ZZ",kus:"kus-Latn-ZZ",kv:"kv-Cyrl-RU",kvg:"kvg-Latn-ZZ",kvr:"kvr-Latn-ID",kvx:"kvx-Arab-PK",kw:"kw-Latn-GB",kwj:"kwj-Latn-ZZ",kwo:"kwo-Latn-ZZ",kwq:"kwq-Latn-ZZ",kxa:"kxa-Latn-ZZ",kxc:"kxc-Ethi-ZZ",kxe:"kxe-Latn-ZZ",kxm:"kxm-Thai-TH",kxp:"kxp-Arab-PK",kxw:"kxw-Latn-ZZ",kxz:"kxz-Latn-ZZ",ky:"ky-Cyrl-KG","ky-Arab":"ky-Arab-CN","ky-CN":"ky-Arab-CN","ky-Latn":"ky-Latn-TR","ky-TR":"ky-Latn-TR",kye:"kye-Latn-ZZ",kyx:"kyx-Latn-ZZ",kzj:"kzj-Latn-MY",kzr:"kzr-Latn-ZZ",kzt:"kzt-Latn-MY",la:"la-Latn-VA",lab:"lab-Lina-GR",lad:"lad-Hebr-IL",lag:"lag-Latn-TZ",lah:"lah-Arab-PK",laj:"laj-Latn-UG",las:"las-Latn-ZZ",lb:"lb-Latn-LU",lbe:"lbe-Cyrl-RU",lbu:"lbu-Latn-ZZ",lbw:"lbw-Latn-ID",lcm:"lcm-Latn-ZZ",lcp:"lcp-Thai-CN",ldb:"ldb-Latn-ZZ",led:"led-Latn-ZZ",lee:"lee-Latn-ZZ",lem:"lem-Latn-ZZ",lep:"lep-Lepc-IN",leq:"leq-Latn-ZZ",leu:"leu-Latn-ZZ",lez:"lez-Cyrl-RU",lg:"lg-Latn-UG",lgg:"lgg-Latn-ZZ",li:"li-Latn-NL",lia:"lia-Latn-ZZ",lid:"lid-Latn-ZZ",lif:"lif-Deva-NP","lif-Limb":"lif-Limb-IN",lig:"lig-Latn-ZZ",lih:"lih-Latn-ZZ",lij:"lij-Latn-IT",lis:"lis-Lisu-CN",ljp:"ljp-Latn-ID",lki:"lki-Arab-IR",lkt:"lkt-Latn-US",lle:"lle-Latn-ZZ",lln:"lln-Latn-ZZ",lmn:"lmn-Telu-IN",lmo:"lmo-Latn-IT",lmp:"lmp-Latn-ZZ",ln:"ln-Latn-CD",lns:"lns-Latn-ZZ",lnu:"lnu-Latn-ZZ",lo:"lo-Laoo-LA",loj:"loj-Latn-ZZ",lok:"lok-Latn-ZZ",lol:"lol-Latn-CD",lor:"lor-Latn-ZZ",los:"los-Latn-ZZ",loz:"loz-Latn-ZM",lrc:"lrc-Arab-IR",lt:"lt-Latn-LT",ltg:"ltg-Latn-LV",lu:"lu-Latn-CD",lua:"lua-Latn-CD",luo:"luo-Latn-KE",luy:"luy-Latn-KE",luz:"luz-Arab-IR",lv:"lv-Latn-LV",lwl:"lwl-Thai-TH",lzh:"lzh-Hans-CN",lzz:"lzz-Latn-TR",mad:"mad-Latn-ID",maf:"maf-Latn-CM",mag:"mag-Deva-IN",mai:"mai-Deva-IN",mak:"mak-Latn-ID",man:"man-Latn-GM","man-GN":"man-Nkoo-GN","man-Nkoo":"man-Nkoo-GN",mas:"mas-Latn-KE",maw:"maw-Latn-ZZ",maz:"maz-Latn-MX",mbh:"mbh-Latn-ZZ",mbo:"mbo-Latn-ZZ",mbq:"mbq-Latn-ZZ",mbu:"mbu-Latn-ZZ",mbw:"mbw-Latn-ZZ",mci:"mci-Latn-ZZ",mcp:"mcp-Latn-ZZ",mcq:"mcq-Latn-ZZ",mcr:"mcr-Latn-ZZ",mcu:"mcu-Latn-ZZ",mda:"mda-Latn-ZZ",mde:"mde-Arab-ZZ",mdf:"mdf-Cyrl-RU",mdh:"mdh-Latn-PH",mdj:"mdj-Latn-ZZ",mdr:"mdr-Latn-ID",mdx:"mdx-Ethi-ZZ",med:"med-Latn-ZZ",mee:"mee-Latn-ZZ",mek:"mek-Latn-ZZ",men:"men-Latn-SL",mer:"mer-Latn-KE",met:"met-Latn-ZZ",meu:"meu-Latn-ZZ",mfa:"mfa-Arab-TH",mfe:"mfe-Latn-MU",mfn:"mfn-Latn-ZZ",mfo:"mfo-Latn-ZZ",mfq:"mfq-Latn-ZZ",mg:"mg-Latn-MG",mgh:"mgh-Latn-MZ",mgl:"mgl-Latn-ZZ",mgo:"mgo-Latn-CM",mgp:"mgp-Deva-NP",mgy:"mgy-Latn-TZ",mh:"mh-Latn-MH",mhi:"mhi-Latn-ZZ",mhl:"mhl-Latn-ZZ",mi:"mi-Latn-NZ",mif:"mif-Latn-ZZ",min:"min-Latn-ID",mis:"mis-Hatr-IQ","mis-Medf":"mis-Medf-NG",miw:"miw-Latn-ZZ",mk:"mk-Cyrl-MK",mki:"mki-Arab-ZZ",mkl:"mkl-Latn-ZZ",mkp:"mkp-Latn-ZZ",mkw:"mkw-Latn-ZZ",ml:"ml-Mlym-IN",mle:"mle-Latn-ZZ",mlp:"mlp-Latn-ZZ",mls:"mls-Latn-SD",mmo:"mmo-Latn-ZZ",mmu:"mmu-Latn-ZZ",mmx:"mmx-Latn-ZZ",mn:"mn-Cyrl-MN","mn-CN":"mn-Mong-CN","mn-Mong":"mn-Mong-CN",mna:"mna-Latn-ZZ",mnf:"mnf-Latn-ZZ",mni:"mni-Beng-IN",mnw:"mnw-Mymr-MM",mo:"mo-Latn-RO",moa:"moa-Latn-ZZ",moe:"moe-Latn-CA",moh:"moh-Latn-CA",mos:"mos-Latn-BF",mox:"mox-Latn-ZZ",mpp:"mpp-Latn-ZZ",mps:"mps-Latn-ZZ",mpt:"mpt-Latn-ZZ",mpx:"mpx-Latn-ZZ",mql:"mql-Latn-ZZ",mr:"mr-Deva-IN",mrd:"mrd-Deva-NP",mrj:"mrj-Cyrl-RU",mro:"mro-Mroo-BD",ms:"ms-Latn-MY","ms-CC":"ms-Arab-CC","ms-ID":"ms-Arab-ID",mt:"mt-Latn-MT",mtc:"mtc-Latn-ZZ",mtf:"mtf-Latn-ZZ",mti:"mti-Latn-ZZ",mtr:"mtr-Deva-IN",mua:"mua-Latn-CM",mur:"mur-Latn-ZZ",mus:"mus-Latn-US",mva:"mva-Latn-ZZ",mvn:"mvn-Latn-ZZ",mvy:"mvy-Arab-PK",mwk:"mwk-Latn-ML",mwr:"mwr-Deva-IN",mwv:"mwv-Latn-ID",mww:"mww-Hmnp-US",mxc:"mxc-Latn-ZW",mxm:"mxm-Latn-ZZ",my:"my-Mymr-MM",myk:"myk-Latn-ZZ",mym:"mym-Ethi-ZZ",myv:"myv-Cyrl-RU",myw:"myw-Latn-ZZ",myx:"myx-Latn-UG",myz:"myz-Mand-IR",mzk:"mzk-Latn-ZZ",mzm:"mzm-Latn-ZZ",mzn:"mzn-Arab-IR",mzp:"mzp-Latn-ZZ",mzw:"mzw-Latn-ZZ",mzz:"mzz-Latn-ZZ",na:"na-Latn-NR",nac:"nac-Latn-ZZ",naf:"naf-Latn-ZZ",nak:"nak-Latn-ZZ",nan:"nan-Hans-CN",nap:"nap-Latn-IT",naq:"naq-Latn-NA",nas:"nas-Latn-ZZ",nb:"nb-Latn-NO",nca:"nca-Latn-ZZ",nce:"nce-Latn-ZZ",ncf:"ncf-Latn-ZZ",nch:"nch-Latn-MX",nco:"nco-Latn-ZZ",ncu:"ncu-Latn-ZZ",nd:"nd-Latn-ZW",ndc:"ndc-Latn-MZ",nds:"nds-Latn-DE",ne:"ne-Deva-NP",neb:"neb-Latn-ZZ",new:"new-Deva-NP",nex:"nex-Latn-ZZ",nfr:"nfr-Latn-ZZ",ng:"ng-Latn-NA",nga:"nga-Latn-ZZ",ngb:"ngb-Latn-ZZ",ngl:"ngl-Latn-MZ",nhb:"nhb-Latn-ZZ",nhe:"nhe-Latn-MX",nhw:"nhw-Latn-MX",nif:"nif-Latn-ZZ",nii:"nii-Latn-ZZ",nij:"nij-Latn-ID",nin:"nin-Latn-ZZ",niu:"niu-Latn-NU",niy:"niy-Latn-ZZ",niz:"niz-Latn-ZZ",njo:"njo-Latn-IN",nkg:"nkg-Latn-ZZ",nko:"nko-Latn-ZZ",nl:"nl-Latn-NL",nmg:"nmg-Latn-CM",nmz:"nmz-Latn-ZZ",nn:"nn-Latn-NO",nnf:"nnf-Latn-ZZ",nnh:"nnh-Latn-CM",nnk:"nnk-Latn-ZZ",nnm:"nnm-Latn-ZZ",nnp:"nnp-Wcho-IN",no:"no-Latn-NO",nod:"nod-Lana-TH",noe:"noe-Deva-IN",non:"non-Runr-SE",nop:"nop-Latn-ZZ",nou:"nou-Latn-ZZ",nqo:"nqo-Nkoo-GN",nr:"nr-Latn-ZA",nrb:"nrb-Latn-ZZ",nsk:"nsk-Cans-CA",nsn:"nsn-Latn-ZZ",nso:"nso-Latn-ZA",nss:"nss-Latn-ZZ",ntm:"ntm-Latn-ZZ",ntr:"ntr-Latn-ZZ",nui:"nui-Latn-ZZ",nup:"nup-Latn-ZZ",nus:"nus-Latn-SS",nuv:"nuv-Latn-ZZ",nux:"nux-Latn-ZZ",nv:"nv-Latn-US",nwb:"nwb-Latn-ZZ",nxq:"nxq-Latn-CN",nxr:"nxr-Latn-ZZ",ny:"ny-Latn-MW",nym:"nym-Latn-TZ",nyn:"nyn-Latn-UG",nzi:"nzi-Latn-GH",oc:"oc-Latn-FR",ogc:"ogc-Latn-ZZ",okr:"okr-Latn-ZZ",okv:"okv-Latn-ZZ",om:"om-Latn-ET",ong:"ong-Latn-ZZ",onn:"onn-Latn-ZZ",ons:"ons-Latn-ZZ",opm:"opm-Latn-ZZ",or:"or-Orya-IN",oro:"oro-Latn-ZZ",oru:"oru-Arab-ZZ",os:"os-Cyrl-GE",osa:"osa-Osge-US",ota:"ota-Arab-ZZ",otk:"otk-Orkh-MN",ozm:"ozm-Latn-ZZ",pa:"pa-Guru-IN","pa-Arab":"pa-Arab-PK","pa-PK":"pa-Arab-PK",pag:"pag-Latn-PH",pal:"pal-Phli-IR","pal-Phlp":"pal-Phlp-CN",pam:"pam-Latn-PH",pap:"pap-Latn-AW",pau:"pau-Latn-PW",pbi:"pbi-Latn-ZZ",pcd:"pcd-Latn-FR",pcm:"pcm-Latn-NG",pdc:"pdc-Latn-US",pdt:"pdt-Latn-CA",ped:"ped-Latn-ZZ",peo:"peo-Xpeo-IR",pex:"pex-Latn-ZZ",pfl:"pfl-Latn-DE",phl:"phl-Arab-ZZ",phn:"phn-Phnx-LB",pil:"pil-Latn-ZZ",pip:"pip-Latn-ZZ",pka:"pka-Brah-IN",pko:"pko-Latn-KE",pl:"pl-Latn-PL",pla:"pla-Latn-ZZ",pms:"pms-Latn-IT",png:"png-Latn-ZZ",pnn:"pnn-Latn-ZZ",pnt:"pnt-Grek-GR",pon:"pon-Latn-FM",ppa:"ppa-Deva-IN",ppo:"ppo-Latn-ZZ",pra:"pra-Khar-PK",prd:"prd-Arab-IR",prg:"prg-Latn-001",ps:"ps-Arab-AF",pss:"pss-Latn-ZZ",pt:"pt-Latn-BR",ptp:"ptp-Latn-ZZ",puu:"puu-Latn-GA",pwa:"pwa-Latn-ZZ",qu:"qu-Latn-PE",quc:"quc-Latn-GT",qug:"qug-Latn-EC",rai:"rai-Latn-ZZ",raj:"raj-Deva-IN",rao:"rao-Latn-ZZ",rcf:"rcf-Latn-RE",rej:"rej-Latn-ID",rel:"rel-Latn-ZZ",res:"res-Latn-ZZ",rgn:"rgn-Latn-IT",rhg:"rhg-Arab-MM",ria:"ria-Latn-IN",rif:"rif-Tfng-MA","rif-NL":"rif-Latn-NL",rjs:"rjs-Deva-NP",rkt:"rkt-Beng-BD",rm:"rm-Latn-CH",rmf:"rmf-Latn-FI",rmo:"rmo-Latn-CH",rmt:"rmt-Arab-IR",rmu:"rmu-Latn-SE",rn:"rn-Latn-BI",rna:"rna-Latn-ZZ",rng:"rng-Latn-MZ",ro:"ro-Latn-RO",rob:"rob-Latn-ID",rof:"rof-Latn-TZ",roo:"roo-Latn-ZZ",rro:"rro-Latn-ZZ",rtm:"rtm-Latn-FJ",ru:"ru-Cyrl-RU",rue:"rue-Cyrl-UA",rug:"rug-Latn-SB",rw:"rw-Latn-RW",rwk:"rwk-Latn-TZ",rwo:"rwo-Latn-ZZ",ryu:"ryu-Kana-JP",sa:"sa-Deva-IN",saf:"saf-Latn-GH",sah:"sah-Cyrl-RU",saq:"saq-Latn-KE",sas:"sas-Latn-ID",sat:"sat-Latn-IN",sav:"sav-Latn-SN",saz:"saz-Saur-IN",sba:"sba-Latn-ZZ",sbe:"sbe-Latn-ZZ",sbp:"sbp-Latn-TZ",sc:"sc-Latn-IT",sck:"sck-Deva-IN",scl:"scl-Arab-ZZ",scn:"scn-Latn-IT",sco:"sco-Latn-GB",scs:"scs-Latn-CA",sd:"sd-Arab-PK","sd-Deva":"sd-Deva-IN","sd-Khoj":"sd-Khoj-IN","sd-Sind":"sd-Sind-IN",sdc:"sdc-Latn-IT",sdh:"sdh-Arab-IR",se:"se-Latn-NO",sef:"sef-Latn-CI",seh:"seh-Latn-MZ",sei:"sei-Latn-MX",ses:"ses-Latn-ML",sg:"sg-Latn-CF",sga:"sga-Ogam-IE",sgs:"sgs-Latn-LT",sgw:"sgw-Ethi-ZZ",sgz:"sgz-Latn-ZZ",shi:"shi-Tfng-MA",shk:"shk-Latn-ZZ",shn:"shn-Mymr-MM",shu:"shu-Arab-ZZ",si:"si-Sinh-LK",sid:"sid-Latn-ET",sig:"sig-Latn-ZZ",sil:"sil-Latn-ZZ",sim:"sim-Latn-ZZ",sjr:"sjr-Latn-ZZ",sk:"sk-Latn-SK",skc:"skc-Latn-ZZ",skr:"skr-Arab-PK",sks:"sks-Latn-ZZ",sl:"sl-Latn-SI",sld:"sld-Latn-ZZ",sli:"sli-Latn-PL",sll:"sll-Latn-ZZ",sly:"sly-Latn-ID",sm:"sm-Latn-WS",sma:"sma-Latn-SE",smj:"smj-Latn-SE",smn:"smn-Latn-FI",smp:"smp-Samr-IL",smq:"smq-Latn-ZZ",sms:"sms-Latn-FI",sn:"sn-Latn-ZW",snc:"snc-Latn-ZZ",snk:"snk-Latn-ML",snp:"snp-Latn-ZZ",snx:"snx-Latn-ZZ",sny:"sny-Latn-ZZ",so:"so-Latn-SO",sog:"sog-Sogd-UZ",sok:"sok-Latn-ZZ",soq:"soq-Latn-ZZ",sou:"sou-Thai-TH",soy:"soy-Latn-ZZ",spd:"spd-Latn-ZZ",spl:"spl-Latn-ZZ",sps:"sps-Latn-ZZ",sq:"sq-Latn-AL",sr:"sr-Cyrl-RS","sr-ME":"sr-Latn-ME","sr-RO":"sr-Latn-RO","sr-RU":"sr-Latn-RU","sr-TR":"sr-Latn-TR",srb:"srb-Sora-IN",srn:"srn-Latn-SR",srr:"srr-Latn-SN",srx:"srx-Deva-IN",ss:"ss-Latn-ZA",ssd:"ssd-Latn-ZZ",ssg:"ssg-Latn-ZZ",ssy:"ssy-Latn-ER",st:"st-Latn-ZA",stk:"stk-Latn-ZZ",stq:"stq-Latn-DE",su:"su-Latn-ID",sua:"sua-Latn-ZZ",sue:"sue-Latn-ZZ",suk:"suk-Latn-TZ",sur:"sur-Latn-ZZ",sus:"sus-Latn-GN",sv:"sv-Latn-SE",sw:"sw-Latn-TZ",swb:"swb-Arab-YT",swc:"swc-Latn-CD",swg:"swg-Latn-DE",swp:"swp-Latn-ZZ",swv:"swv-Deva-IN",sxn:"sxn-Latn-ID",sxw:"sxw-Latn-ZZ",syl:"syl-Beng-BD",syr:"syr-Syrc-IQ",szl:"szl-Latn-PL",ta:"ta-Taml-IN",taj:"taj-Deva-NP",tal:"tal-Latn-ZZ",tan:"tan-Latn-ZZ",taq:"taq-Latn-ZZ",tbc:"tbc-Latn-ZZ",tbd:"tbd-Latn-ZZ",tbf:"tbf-Latn-ZZ",tbg:"tbg-Latn-ZZ",tbo:"tbo-Latn-ZZ",tbw:"tbw-Latn-PH",tbz:"tbz-Latn-ZZ",tci:"tci-Latn-ZZ",tcy:"tcy-Knda-IN",tdd:"tdd-Tale-CN",tdg:"tdg-Deva-NP",tdh:"tdh-Deva-NP",tdu:"tdu-Latn-MY",te:"te-Telu-IN",ted:"ted-Latn-ZZ",tem:"tem-Latn-SL",teo:"teo-Latn-UG",tet:"tet-Latn-TL",tfi:"tfi-Latn-ZZ",tg:"tg-Cyrl-TJ","tg-Arab":"tg-Arab-PK","tg-PK":"tg-Arab-PK",tgc:"tgc-Latn-ZZ",tgo:"tgo-Latn-ZZ",tgu:"tgu-Latn-ZZ",th:"th-Thai-TH",thl:"thl-Deva-NP",thq:"thq-Deva-NP",thr:"thr-Deva-NP",ti:"ti-Ethi-ET",tif:"tif-Latn-ZZ",tig:"tig-Ethi-ER",tik:"tik-Latn-ZZ",tim:"tim-Latn-ZZ",tio:"tio-Latn-ZZ",tiv:"tiv-Latn-NG",tk:"tk-Latn-TM",tkl:"tkl-Latn-TK",tkr:"tkr-Latn-AZ",tkt:"tkt-Deva-NP",tl:"tl-Latn-PH",tlf:"tlf-Latn-ZZ",tlx:"tlx-Latn-ZZ",tly:"tly-Latn-AZ",tmh:"tmh-Latn-NE",tmy:"tmy-Latn-ZZ",tn:"tn-Latn-ZA",tnh:"tnh-Latn-ZZ",to:"to-Latn-TO",tof:"tof-Latn-ZZ",tog:"tog-Latn-MW",toq:"toq-Latn-ZZ",tpi:"tpi-Latn-PG",tpm:"tpm-Latn-ZZ",tpz:"tpz-Latn-ZZ",tqo:"tqo-Latn-ZZ",tr:"tr-Latn-TR",tru:"tru-Latn-TR",trv:"trv-Latn-TW",trw:"trw-Arab-ZZ",ts:"ts-Latn-ZA",tsd:"tsd-Grek-GR",tsf:"tsf-Deva-NP",tsg:"tsg-Latn-PH",tsj:"tsj-Tibt-BT",tsw:"tsw-Latn-ZZ",tt:"tt-Cyrl-RU",ttd:"ttd-Latn-ZZ",tte:"tte-Latn-ZZ",ttj:"ttj-Latn-UG",ttr:"ttr-Latn-ZZ",tts:"tts-Thai-TH",ttt:"ttt-Latn-AZ",tuh:"tuh-Latn-ZZ",tul:"tul-Latn-ZZ",tum:"tum-Latn-MW",tuq:"tuq-Latn-ZZ",tvd:"tvd-Latn-ZZ",tvl:"tvl-Latn-TV",tvu:"tvu-Latn-ZZ",twh:"twh-Latn-ZZ",twq:"twq-Latn-NE",txg:"txg-Tang-CN",ty:"ty-Latn-PF",tya:"tya-Latn-ZZ",tyv:"tyv-Cyrl-RU",tzm:"tzm-Latn-MA",ubu:"ubu-Latn-ZZ",udm:"udm-Cyrl-RU",ug:"ug-Arab-CN","ug-Cyrl":"ug-Cyrl-KZ","ug-KZ":"ug-Cyrl-KZ","ug-MN":"ug-Cyrl-MN",uga:"uga-Ugar-SY",uk:"uk-Cyrl-UA",uli:"uli-Latn-FM",umb:"umb-Latn-AO",und:"en-Latn-US","und-002":"en-Latn-NG","und-003":"en-Latn-US","und-005":"pt-Latn-BR","und-009":"en-Latn-AU","und-011":"en-Latn-NG","und-013":"es-Latn-MX","und-014":"sw-Latn-TZ","und-015":"ar-Arab-EG","und-017":"sw-Latn-CD","und-018":"en-Latn-ZA","und-019":"en-Latn-US","und-021":"en-Latn-US","und-029":"es-Latn-CU","und-030":"zh-Hans-CN","und-034":"hi-Deva-IN","und-035":"id-Latn-ID","und-039":"it-Latn-IT","und-053":"en-Latn-AU","und-054":"en-Latn-PG","und-057":"en-Latn-GU","und-061":"sm-Latn-WS","und-142":"zh-Hans-CN","und-143":"uz-Latn-UZ","und-145":"ar-Arab-SA","und-150":"ru-Cyrl-RU","und-151":"ru-Cyrl-RU","und-154":"en-Latn-GB","und-155":"de-Latn-DE","und-202":"en-Latn-NG","und-419":"es-Latn-419","und-AD":"ca-Latn-AD","und-Adlm":"ff-Adlm-GN","und-AE":"ar-Arab-AE","und-AF":"fa-Arab-AF","und-Aghb":"lez-Aghb-RU","und-Ahom":"aho-Ahom-IN","und-AL":"sq-Latn-AL","und-AM":"hy-Armn-AM","und-AO":"pt-Latn-AO","und-AQ":"und-Latn-AQ","und-AR":"es-Latn-AR","und-Arab":"ar-Arab-EG","und-Arab-CC":"ms-Arab-CC","und-Arab-CN":"ug-Arab-CN","und-Arab-GB":"ks-Arab-GB","und-Arab-ID":"ms-Arab-ID","und-Arab-IN":"ur-Arab-IN","und-Arab-KH":"cja-Arab-KH","und-Arab-MM":"rhg-Arab-MM","und-Arab-MN":"kk-Arab-MN","und-Arab-MU":"ur-Arab-MU","und-Arab-NG":"ha-Arab-NG","und-Arab-PK":"ur-Arab-PK","und-Arab-TG":"apd-Arab-TG","und-Arab-TH":"mfa-Arab-TH","und-Arab-TJ":"fa-Arab-TJ","und-Arab-TR":"az-Arab-TR","und-Arab-YT":"swb-Arab-YT","und-Armi":"arc-Armi-IR","und-Armn":"hy-Armn-AM","und-AS":"sm-Latn-AS","und-AT":"de-Latn-AT","und-Avst":"ae-Avst-IR","und-AW":"nl-Latn-AW","und-AX":"sv-Latn-AX","und-AZ":"az-Latn-AZ","und-BA":"bs-Latn-BA","und-Bali":"ban-Bali-ID","und-Bamu":"bax-Bamu-CM","und-Bass":"bsq-Bass-LR","und-Batk":"bbc-Batk-ID","und-BD":"bn-Beng-BD","und-BE":"nl-Latn-BE","und-Beng":"bn-Beng-BD","und-BF":"fr-Latn-BF","und-BG":"bg-Cyrl-BG","und-BH":"ar-Arab-BH","und-Bhks":"sa-Bhks-IN","und-BI":"rn-Latn-BI","und-BJ":"fr-Latn-BJ","und-BL":"fr-Latn-BL","und-BN":"ms-Latn-BN","und-BO":"es-Latn-BO","und-Bopo":"zh-Bopo-TW","und-BQ":"pap-Latn-BQ","und-BR":"pt-Latn-BR","und-Brah":"pka-Brah-IN","und-Brai":"fr-Brai-FR","und-BT":"dz-Tibt-BT","und-Bugi":"bug-Bugi-ID","und-Buhd":"bku-Buhd-PH","und-BV":"und-Latn-BV","und-BY":"be-Cyrl-BY","und-Cakm":"ccp-Cakm-BD","und-Cans":"cr-Cans-CA","und-Cari":"xcr-Cari-TR","und-CD":"sw-Latn-CD","und-CF":"fr-Latn-CF","und-CG":"fr-Latn-CG","und-CH":"de-Latn-CH","und-Cham":"cjm-Cham-VN","und-Cher":"chr-Cher-US","und-CI":"fr-Latn-CI","und-CL":"es-Latn-CL","und-CM":"fr-Latn-CM","und-CN":"zh-Hans-CN","und-CO":"es-Latn-CO","und-Copt":"cop-Copt-EG","und-CP":"und-Latn-CP","und-Cprt":"grc-Cprt-CY","und-CR":"es-Latn-CR","und-CU":"es-Latn-CU","und-CV":"pt-Latn-CV","und-CW":"pap-Latn-CW","und-CY":"el-Grek-CY","und-Cyrl":"ru-Cyrl-RU","und-Cyrl-AL":"mk-Cyrl-AL","und-Cyrl-BA":"sr-Cyrl-BA","und-Cyrl-GE":"ab-Cyrl-GE","und-Cyrl-GR":"mk-Cyrl-GR","und-Cyrl-MD":"uk-Cyrl-MD","und-Cyrl-RO":"bg-Cyrl-RO","und-Cyrl-SK":"uk-Cyrl-SK","und-Cyrl-TR":"kbd-Cyrl-TR","und-Cyrl-XK":"sr-Cyrl-XK","und-CZ":"cs-Latn-CZ","und-DE":"de-Latn-DE","und-Deva":"hi-Deva-IN","und-Deva-BT":"ne-Deva-BT","und-Deva-FJ":"hif-Deva-FJ","und-Deva-MU":"bho-Deva-MU","und-Deva-PK":"btv-Deva-PK","und-DJ":"aa-Latn-DJ","und-DK":"da-Latn-DK","und-DO":"es-Latn-DO","und-Dogr":"doi-Dogr-IN","und-Dupl":"fr-Dupl-FR","und-DZ":"ar-Arab-DZ","und-EA":"es-Latn-EA","und-EC":"es-Latn-EC","und-EE":"et-Latn-EE","und-EG":"ar-Arab-EG","und-Egyp":"egy-Egyp-EG","und-EH":"ar-Arab-EH","und-Elba":"sq-Elba-AL","und-Elym":"arc-Elym-IR","und-ER":"ti-Ethi-ER","und-ES":"es-Latn-ES","und-ET":"am-Ethi-ET","und-Ethi":"am-Ethi-ET","und-EU":"en-Latn-GB","und-EZ":"de-Latn-EZ","und-FI":"fi-Latn-FI","und-FO":"fo-Latn-FO","und-FR":"fr-Latn-FR","und-GA":"fr-Latn-GA","und-GE":"ka-Geor-GE","und-Geor":"ka-Geor-GE","und-GF":"fr-Latn-GF","und-GH":"ak-Latn-GH","und-GL":"kl-Latn-GL","und-Glag":"cu-Glag-BG","und-GN":"fr-Latn-GN","und-Gong":"wsg-Gong-IN","und-Gonm":"esg-Gonm-IN","und-Goth":"got-Goth-UA","und-GP":"fr-Latn-GP","und-GQ":"es-Latn-GQ","und-GR":"el-Grek-GR","und-Gran":"sa-Gran-IN","und-Grek":"el-Grek-GR","und-Grek-TR":"bgx-Grek-TR","und-GS":"und-Latn-GS","und-GT":"es-Latn-GT","und-Gujr":"gu-Gujr-IN","und-Guru":"pa-Guru-IN","und-GW":"pt-Latn-GW","und-Hanb":"zh-Hanb-TW","und-Hang":"ko-Hang-KR","und-Hani":"zh-Hani-CN","und-Hano":"hnn-Hano-PH","und-Hans":"zh-Hans-CN","und-Hant":"zh-Hant-TW","und-Hatr":"mis-Hatr-IQ","und-Hebr":"he-Hebr-IL","und-Hebr-CA":"yi-Hebr-CA","und-Hebr-GB":"yi-Hebr-GB","und-Hebr-SE":"yi-Hebr-SE","und-Hebr-UA":"yi-Hebr-UA","und-Hebr-US":"yi-Hebr-US","und-Hira":"ja-Hira-JP","und-HK":"zh-Hant-HK","und-Hluw":"hlu-Hluw-TR","und-HM":"und-Latn-HM","und-Hmng":"hnj-Hmng-LA","und-Hmnp":"mww-Hmnp-US","und-HN":"es-Latn-HN","und-HR":"hr-Latn-HR","und-HT":"ht-Latn-HT","und-HU":"hu-Latn-HU","und-Hung":"hu-Hung-HU","und-IC":"es-Latn-IC","und-ID":"id-Latn-ID","und-IL":"he-Hebr-IL","und-IN":"hi-Deva-IN","und-IQ":"ar-Arab-IQ","und-IR":"fa-Arab-IR","und-IS":"is-Latn-IS","und-IT":"it-Latn-IT","und-Ital":"ett-Ital-IT","und-Jamo":"ko-Jamo-KR","und-Java":"jv-Java-ID","und-JO":"ar-Arab-JO","und-JP":"ja-Jpan-JP","und-Jpan":"ja-Jpan-JP","und-Kali":"eky-Kali-MM","und-Kana":"ja-Kana-JP","und-KE":"sw-Latn-KE","und-KG":"ky-Cyrl-KG","und-KH":"km-Khmr-KH","und-Khar":"pra-Khar-PK","und-Khmr":"km-Khmr-KH","und-Khoj":"sd-Khoj-IN","und-KM":"ar-Arab-KM","und-Knda":"kn-Knda-IN","und-Kore":"ko-Kore-KR","und-KP":"ko-Kore-KP","und-KR":"ko-Kore-KR","und-Kthi":"bho-Kthi-IN","und-KW":"ar-Arab-KW","und-KZ":"ru-Cyrl-KZ","und-LA":"lo-Laoo-LA","und-Lana":"nod-Lana-TH","und-Laoo":"lo-Laoo-LA","und-Latn-AF":"tk-Latn-AF","und-Latn-AM":"ku-Latn-AM","und-Latn-CN":"za-Latn-CN","und-Latn-CY":"tr-Latn-CY","und-Latn-DZ":"fr-Latn-DZ","und-Latn-ET":"en-Latn-ET","und-Latn-GE":"ku-Latn-GE","und-Latn-IR":"tk-Latn-IR","und-Latn-KM":"fr-Latn-KM","und-Latn-MA":"fr-Latn-MA","und-Latn-MK":"sq-Latn-MK","und-Latn-MM":"kac-Latn-MM","und-Latn-MO":"pt-Latn-MO","und-Latn-MR":"fr-Latn-MR","und-Latn-RU":"krl-Latn-RU","und-Latn-SY":"fr-Latn-SY","und-Latn-TN":"fr-Latn-TN","und-Latn-TW":"trv-Latn-TW","und-Latn-UA":"pl-Latn-UA","und-LB":"ar-Arab-LB","und-Lepc":"lep-Lepc-IN","und-LI":"de-Latn-LI","und-Limb":"lif-Limb-IN","und-Lina":"lab-Lina-GR","und-Linb":"grc-Linb-GR","und-Lisu":"lis-Lisu-CN","und-LK":"si-Sinh-LK","und-LS":"st-Latn-LS","und-LT":"lt-Latn-LT","und-LU":"fr-Latn-LU","und-LV":"lv-Latn-LV","und-LY":"ar-Arab-LY","und-Lyci":"xlc-Lyci-TR","und-Lydi":"xld-Lydi-TR","und-MA":"ar-Arab-MA","und-Mahj":"hi-Mahj-IN","und-Maka":"mak-Maka-ID","und-Mand":"myz-Mand-IR","und-Mani":"xmn-Mani-CN","und-Marc":"bo-Marc-CN","und-MC":"fr-Latn-MC","und-MD":"ro-Latn-MD","und-ME":"sr-Latn-ME","und-Medf":"mis-Medf-NG","und-Mend":"men-Mend-SL","und-Merc":"xmr-Merc-SD","und-Mero":"xmr-Mero-SD","und-MF":"fr-Latn-MF","und-MG":"mg-Latn-MG","und-MK":"mk-Cyrl-MK","und-ML":"bm-Latn-ML","und-Mlym":"ml-Mlym-IN","und-MM":"my-Mymr-MM","und-MN":"mn-Cyrl-MN","und-MO":"zh-Hant-MO","und-Modi":"mr-Modi-IN","und-Mong":"mn-Mong-CN","und-MQ":"fr-Latn-MQ","und-MR":"ar-Arab-MR","und-Mroo":"mro-Mroo-BD","und-MT":"mt-Latn-MT","und-Mtei":"mni-Mtei-IN","und-MU":"mfe-Latn-MU","und-Mult":"skr-Mult-PK","und-MV":"dv-Thaa-MV","und-MX":"es-Latn-MX","und-MY":"ms-Latn-MY","und-Mymr":"my-Mymr-MM","und-Mymr-IN":"kht-Mymr-IN","und-Mymr-TH":"mnw-Mymr-TH","und-MZ":"pt-Latn-MZ","und-NA":"af-Latn-NA","und-Nand":"sa-Nand-IN","und-Narb":"xna-Narb-SA","und-Nbat":"arc-Nbat-JO","und-NC":"fr-Latn-NC","und-NE":"ha-Latn-NE","und-Newa":"new-Newa-NP","und-NI":"es-Latn-NI","und-Nkoo":"man-Nkoo-GN","und-NL":"nl-Latn-NL","und-NO":"nb-Latn-NO","und-NP":"ne-Deva-NP","und-Nshu":"zhx-Nshu-CN","und-Ogam":"sga-Ogam-IE","und-Olck":"sat-Olck-IN","und-OM":"ar-Arab-OM","und-Orkh":"otk-Orkh-MN","und-Orya":"or-Orya-IN","und-Osge":"osa-Osge-US","und-Osma":"so-Osma-SO","und-PA":"es-Latn-PA","und-Palm":"arc-Palm-SY","und-Pauc":"ctd-Pauc-MM","und-PE":"es-Latn-PE","und-Perm":"kv-Perm-RU","und-PF":"fr-Latn-PF","und-PG":"tpi-Latn-PG","und-PH":"fil-Latn-PH","und-Phag":"lzh-Phag-CN","und-Phli":"pal-Phli-IR","und-Phlp":"pal-Phlp-CN","und-Phnx":"phn-Phnx-LB","und-PK":"ur-Arab-PK","und-PL":"pl-Latn-PL","und-Plrd":"hmd-Plrd-CN","und-PM":"fr-Latn-PM","und-PR":"es-Latn-PR","und-Prti":"xpr-Prti-IR","und-PS":"ar-Arab-PS","und-PT":"pt-Latn-PT","und-PW":"pau-Latn-PW","und-PY":"gn-Latn-PY","und-QA":"ar-Arab-QA","und-QO":"en-Latn-DG","und-RE":"fr-Latn-RE","und-Rjng":"rej-Rjng-ID","und-RO":"ro-Latn-RO","und-Rohg":"rhg-Rohg-MM","und-RS":"sr-Cyrl-RS","und-RU":"ru-Cyrl-RU","und-Runr":"non-Runr-SE","und-RW":"rw-Latn-RW","und-SA":"ar-Arab-SA","und-Samr":"smp-Samr-IL","und-Sarb":"xsa-Sarb-YE","und-Saur":"saz-Saur-IN","und-SC":"fr-Latn-SC","und-SD":"ar-Arab-SD","und-SE":"sv-Latn-SE","und-Sgnw":"ase-Sgnw-US","und-Shaw":"en-Shaw-GB","und-Shrd":"sa-Shrd-IN","und-SI":"sl-Latn-SI","und-Sidd":"sa-Sidd-IN","und-Sind":"sd-Sind-IN","und-Sinh":"si-Sinh-LK","und-SJ":"nb-Latn-SJ","und-SK":"sk-Latn-SK","und-SM":"it-Latn-SM","und-SN":"fr-Latn-SN","und-SO":"so-Latn-SO","und-Sogd":"sog-Sogd-UZ","und-Sogo":"sog-Sogo-UZ","und-Sora":"srb-Sora-IN","und-Soyo":"cmg-Soyo-MN","und-SR":"nl-Latn-SR","und-ST":"pt-Latn-ST","und-Sund":"su-Sund-ID","und-SV":"es-Latn-SV","und-SY":"ar-Arab-SY","und-Sylo":"syl-Sylo-BD","und-Syrc":"syr-Syrc-IQ","und-Tagb":"tbw-Tagb-PH","und-Takr":"doi-Takr-IN","und-Tale":"tdd-Tale-CN","und-Talu":"khb-Talu-CN","und-Taml":"ta-Taml-IN","und-Tang":"txg-Tang-CN","und-Tavt":"blt-Tavt-VN","und-TD":"fr-Latn-TD","und-Telu":"te-Telu-IN","und-TF":"fr-Latn-TF","und-Tfng":"zgh-Tfng-MA","und-TG":"fr-Latn-TG","und-Tglg":"fil-Tglg-PH","und-TH":"th-Thai-TH","und-Thaa":"dv-Thaa-MV","und-Thai":"th-Thai-TH","und-Thai-CN":"lcp-Thai-CN","und-Thai-KH":"kdt-Thai-KH","und-Thai-LA":"kdt-Thai-LA","und-Tibt":"bo-Tibt-CN","und-Tirh":"mai-Tirh-IN","und-TJ":"tg-Cyrl-TJ","und-TK":"tkl-Latn-TK","und-TL":"pt-Latn-TL","und-TM":"tk-Latn-TM","und-TN":"ar-Arab-TN","und-TO":"to-Latn-TO","und-TR":"tr-Latn-TR","und-TV":"tvl-Latn-TV","und-TW":"zh-Hant-TW","und-TZ":"sw-Latn-TZ","und-UA":"uk-Cyrl-UA","und-UG":"sw-Latn-UG","und-Ugar":"uga-Ugar-SY","und-UY":"es-Latn-UY","und-UZ":"uz-Latn-UZ","und-VA":"it-Latn-VA","und-Vaii":"vai-Vaii-LR","und-VE":"es-Latn-VE","und-VN":"vi-Latn-VN","und-VU":"bi-Latn-VU","und-Wara":"hoc-Wara-IN","und-Wcho":"nnp-Wcho-IN","und-WF":"fr-Latn-WF","und-WS":"sm-Latn-WS","und-XK":"sq-Latn-XK","und-Xpeo":"peo-Xpeo-IR","und-Xsux":"akk-Xsux-IQ","und-YE":"ar-Arab-YE","und-Yiii":"ii-Yiii-CN","und-YT":"fr-Latn-YT","und-Zanb":"cmg-Zanb-MN","und-ZW":"sn-Latn-ZW",unr:"unr-Beng-IN","unr-Deva":"unr-Deva-NP","unr-NP":"unr-Deva-NP",unx:"unx-Beng-IN",uok:"uok-Latn-ZZ",ur:"ur-Arab-PK",uri:"uri-Latn-ZZ",urt:"urt-Latn-ZZ",urw:"urw-Latn-ZZ",usa:"usa-Latn-ZZ",utr:"utr-Latn-ZZ",uvh:"uvh-Latn-ZZ",uvl:"uvl-Latn-ZZ",uz:"uz-Latn-UZ","uz-AF":"uz-Arab-AF","uz-Arab":"uz-Arab-AF","uz-CN":"uz-Cyrl-CN",vag:"vag-Latn-ZZ",vai:"vai-Vaii-LR",van:"van-Latn-ZZ",ve:"ve-Latn-ZA",vec:"vec-Latn-IT",vep:"vep-Latn-RU",vi:"vi-Latn-VN",vic:"vic-Latn-SX",viv:"viv-Latn-ZZ",vls:"vls-Latn-BE",vmf:"vmf-Latn-DE",vmw:"vmw-Latn-MZ",vo:"vo-Latn-001",vot:"vot-Latn-RU",vro:"vro-Latn-EE",vun:"vun-Latn-TZ",vut:"vut-Latn-ZZ",wa:"wa-Latn-BE",wae:"wae-Latn-CH",waj:"waj-Latn-ZZ",wal:"wal-Ethi-ET",wan:"wan-Latn-ZZ",war:"war-Latn-PH",wbp:"wbp-Latn-AU",wbq:"wbq-Telu-IN",wbr:"wbr-Deva-IN",wci:"wci-Latn-ZZ",wer:"wer-Latn-ZZ",wgi:"wgi-Latn-ZZ",whg:"whg-Latn-ZZ",wib:"wib-Latn-ZZ",wiu:"wiu-Latn-ZZ",wiv:"wiv-Latn-ZZ",wja:"wja-Latn-ZZ",wji:"wji-Latn-ZZ",wls:"wls-Latn-WF",wmo:"wmo-Latn-ZZ",wnc:"wnc-Latn-ZZ",wni:"wni-Arab-KM",wnu:"wnu-Latn-ZZ",wo:"wo-Latn-SN",wob:"wob-Latn-ZZ",wos:"wos-Latn-ZZ",wrs:"wrs-Latn-ZZ",wsg:"wsg-Gong-IN",wsk:"wsk-Latn-ZZ",wtm:"wtm-Deva-IN",wuu:"wuu-Hans-CN",wuv:"wuv-Latn-ZZ",wwa:"wwa-Latn-ZZ",xav:"xav-Latn-BR",xbi:"xbi-Latn-ZZ",xcr:"xcr-Cari-TR",xes:"xes-Latn-ZZ",xh:"xh-Latn-ZA",xla:"xla-Latn-ZZ",xlc:"xlc-Lyci-TR",xld:"xld-Lydi-TR",xmf:"xmf-Geor-GE",xmn:"xmn-Mani-CN",xmr:"xmr-Merc-SD",xna:"xna-Narb-SA",xnr:"xnr-Deva-IN",xog:"xog-Latn-UG",xon:"xon-Latn-ZZ",xpr:"xpr-Prti-IR",xrb:"xrb-Latn-ZZ",xsa:"xsa-Sarb-YE",xsi:"xsi-Latn-ZZ",xsm:"xsm-Latn-ZZ",xsr:"xsr-Deva-NP",xwe:"xwe-Latn-ZZ",yam:"yam-Latn-ZZ",yao:"yao-Latn-MZ",yap:"yap-Latn-FM",yas:"yas-Latn-ZZ",yat:"yat-Latn-ZZ",yav:"yav-Latn-CM",yay:"yay-Latn-ZZ",yaz:"yaz-Latn-ZZ",yba:"yba-Latn-ZZ",ybb:"ybb-Latn-CM",yby:"yby-Latn-ZZ",yer:"yer-Latn-ZZ",ygr:"ygr-Latn-ZZ",ygw:"ygw-Latn-ZZ",yi:"yi-Hebr-001",yko:"yko-Latn-ZZ",yle:"yle-Latn-ZZ",ylg:"ylg-Latn-ZZ",yll:"yll-Latn-ZZ",yml:"yml-Latn-ZZ",yo:"yo-Latn-NG",yon:"yon-Latn-ZZ",yrb:"yrb-Latn-ZZ",yre:"yre-Latn-ZZ",yrl:"yrl-Latn-BR",yss:"yss-Latn-ZZ",yua:"yua-Latn-MX",yue:"yue-Hant-HK","yue-CN":"yue-Hans-CN","yue-Hans":"yue-Hans-CN",yuj:"yuj-Latn-ZZ",yut:"yut-Latn-ZZ",yuw:"yuw-Latn-ZZ",za:"za-Latn-CN",zag:"zag-Latn-SD",zdj:"zdj-Arab-KM",zea:"zea-Latn-NL",zgh:"zgh-Tfng-MA",zh:"zh-Hans-CN","zh-AU":"zh-Hant-AU","zh-BN":"zh-Hant-BN","zh-Bopo":"zh-Bopo-TW","zh-GB":"zh-Hant-GB","zh-GF":"zh-Hant-GF","zh-Hanb":"zh-Hanb-TW","zh-Hant":"zh-Hant-TW","zh-HK":"zh-Hant-HK","zh-ID":"zh-Hant-ID","zh-MO":"zh-Hant-MO","zh-MY":"zh-Hant-MY","zh-PA":"zh-Hant-PA","zh-PF":"zh-Hant-PF","zh-PH":"zh-Hant-PH","zh-SR":"zh-Hant-SR","zh-TH":"zh-Hant-TH","zh-TW":"zh-Hant-TW","zh-US":"zh-Hant-US","zh-VN":"zh-Hant-VN",zhx:"zhx-Nshu-CN",zia:"zia-Latn-ZZ",zlm:"zlm-Latn-TG",zmi:"zmi-Latn-MY",zne:"zne-Latn-ZZ",zu:"zu-Latn-ZA",zza:"zza-Latn-TR"},timeData:{AX:{_allowed:"H",_preferred:"H"},BQ:{_allowed:"H",_preferred:"H"},CP:{_allowed:"H",_preferred:"H"},CZ:{_allowed:"H",_preferred:"H"},DK:{_allowed:"H",_preferred:"H"},FI:{_allowed:"H",_preferred:"H"},ID:{_allowed:"H",_preferred:"H"},IS:{_allowed:"H",_preferred:"H"},ML:{_allowed:"H",_preferred:"H"},NE:{_allowed:"H",_preferred:"H"},RU:{_allowed:"H",_preferred:"H"},SE:{_allowed:"H",_preferred:"H"},SJ:{_allowed:"H",_preferred:"H"},SK:{_allowed:"H",_preferred:"H"},AS:{_allowed:"h H",_preferred:"h"},BT:{_allowed:"h H",_preferred:"h"},DJ:{_allowed:"h H",_preferred:"h"},ER:{_allowed:"h H",_preferred:"h"},GH:{_allowed:"h H",_preferred:"h"},IN:{_allowed:"h H",_preferred:"h"},LS:{_allowed:"h H",_preferred:"h"},PG:{_allowed:"h H",_preferred:"h"},PW:{_allowed:"h H",_preferred:"h"},SO:{_allowed:"h H",_preferred:"h"},TO:{_allowed:"h H",_preferred:"h"},VU:{_allowed:"h H",_preferred:"h"},WS:{_allowed:"h H",_preferred:"h"},"001":{_allowed:"H h",_preferred:"H"},AL:{_allowed:"h H hB",_preferred:"h"},TD:{_allowed:"h H hB",_preferred:"h"},ca_ES:{_allowed:"H h hB",_preferred:"H"},CF:{_allowed:"H h hB",_preferred:"H"},CM:{_allowed:"H h hB",_preferred:"H"},fr_CA:{_allowed:"H h hB",_preferred:"H"},gl_ES:{_allowed:"H h hB",_preferred:"H"},it_CH:{_allowed:"H h hB",_preferred:"H"},it_IT:{_allowed:"H h hB",_preferred:"H"},LU:{_allowed:"H h hB",_preferred:"H"},NP:{_allowed:"H h hB",_preferred:"H"},PF:{_allowed:"H h hB",_preferred:"H"},SC:{_allowed:"H h hB",_preferred:"H"},SM:{_allowed:"H h hB",_preferred:"H"},SN:{_allowed:"H h hB",_preferred:"H"},TF:{_allowed:"H h hB",_preferred:"H"},VA:{_allowed:"H h hB",_preferred:"H"},CY:{_allowed:"h H hb hB",_preferred:"h"},GR:{_allowed:"h H hb hB",_preferred:"h"},CO:{_allowed:"h H hB hb",_preferred:"h"},DO:{_allowed:"h H hB hb",_preferred:"h"},KP:{_allowed:"h H hB hb",_preferred:"h"},KR:{_allowed:"h H hB hb",_preferred:"h"},NA:{_allowed:"h H hB hb",_preferred:"h"},PA:{_allowed:"h H hB hb",_preferred:"h"},PR:{_allowed:"h H hB hb",_preferred:"h"},VE:{_allowed:"h H hB hb",_preferred:"h"},AC:{_allowed:"H h hb hB",_preferred:"H"},AI:{_allowed:"H h hb hB",_preferred:"H"},BW:{_allowed:"H h hb hB",_preferred:"H"},BZ:{_allowed:"H h hb hB",_preferred:"H"},CC:{_allowed:"H h hb hB",_preferred:"H"},CK:{_allowed:"H h hb hB",_preferred:"H"},CX:{_allowed:"H h hb hB",_preferred:"H"},DG:{_allowed:"H h hb hB",_preferred:"H"},FK:{_allowed:"H h hb hB",_preferred:"H"},GB:{_allowed:"H h hb hB",_preferred:"H"},GG:{_allowed:"H h hb hB",_preferred:"H"},GI:{_allowed:"H h hb hB",_preferred:"H"},IE:{_allowed:"H h hb hB",_preferred:"H"},IM:{_allowed:"H h hb hB",_preferred:"H"},IO:{_allowed:"H h hb hB",_preferred:"H"},JE:{_allowed:"H h hb hB",_preferred:"H"},LT:{_allowed:"H h hb hB",_preferred:"H"},MK:{_allowed:"H h hb hB",_preferred:"H"},MN:{_allowed:"H h hb hB",_preferred:"H"},MS:{_allowed:"H h hb hB",_preferred:"H"},NF:{_allowed:"H h hb hB",_preferred:"H"},NG:{_allowed:"H h hb hB",_preferred:"H"},NR:{_allowed:"H h hb hB",_preferred:"H"},NU:{_allowed:"H h hb hB",_preferred:"H"},PN:{_allowed:"H h hb hB",_preferred:"H"},SH:{_allowed:"H h hb hB",_preferred:"H"},SX:{_allowed:"H h hb hB",_preferred:"H"},TA:{_allowed:"H h hb hB",_preferred:"H"},ZA:{_allowed:"H h hb hB",_preferred:"H"},af_ZA:{_allowed:"H h hB hb",_preferred:"H"},AR:{_allowed:"H h hB hb",_preferred:"H"},CL:{_allowed:"H h hB hb",_preferred:"H"},CR:{_allowed:"H h hB hb",_preferred:"H"},CU:{_allowed:"H h hB hb",_preferred:"H"},EA:{_allowed:"H h hB hb",_preferred:"H"},es_BO:{_allowed:"H h hB hb",_preferred:"H"},es_BR:{_allowed:"H h hB hb",_preferred:"H"},es_EC:{_allowed:"H h hB hb",_preferred:"H"},es_ES:{_allowed:"H h hB hb",_preferred:"H"},es_GQ:{_allowed:"H h hB hb",_preferred:"H"},es_PE:{_allowed:"H h hB hb",_preferred:"H"},GT:{_allowed:"H h hB hb",_preferred:"H"},HN:{_allowed:"H h hB hb",_preferred:"H"},IC:{_allowed:"H h hB hb",_preferred:"H"},KG:{_allowed:"H h hB hb",_preferred:"H"},KM:{_allowed:"H h hB hb",_preferred:"H"},LK:{_allowed:"H h hB hb",_preferred:"H"},MA:{_allowed:"H h hB hb",_preferred:"H"},MX:{_allowed:"H h hB hb",_preferred:"H"},NI:{_allowed:"H h hB hb",_preferred:"H"},PY:{_allowed:"H h hB hb",_preferred:"H"},SV:{_allowed:"H h hB hb",_preferred:"H"},UY:{_allowed:"H h hB hb",_preferred:"H"},JP:{_allowed:"H h K",_preferred:"H"},AD:{_allowed:"H hB",_preferred:"H"},AM:{_allowed:"H hB",_preferred:"H"},AO:{_allowed:"H hB",_preferred:"H"},AT:{_allowed:"H hB",_preferred:"H"},AW:{_allowed:"H hB",_preferred:"H"},BE:{_allowed:"H hB",_preferred:"H"},BF:{_allowed:"H hB",_preferred:"H"},BJ:{_allowed:"H hB",_preferred:"H"},BL:{_allowed:"H hB",_preferred:"H"},BR:{_allowed:"H hB",_preferred:"H"},CG:{_allowed:"H hB",_preferred:"H"},CI:{_allowed:"H hB",_preferred:"H"},CV:{_allowed:"H hB",_preferred:"H"},DE:{_allowed:"H hB",_preferred:"H"},EE:{_allowed:"H hB",_preferred:"H"},FR:{_allowed:"H hB",_preferred:"H"},GA:{_allowed:"H hB",_preferred:"H"},GF:{_allowed:"H hB",_preferred:"H"},GN:{_allowed:"H hB",_preferred:"H"},GP:{_allowed:"H hB",_preferred:"H"},GW:{_allowed:"H hB",_preferred:"H"},HR:{_allowed:"H hB",_preferred:"H"},IL:{_allowed:"H hB",_preferred:"H"},IT:{_allowed:"H hB",_preferred:"H"},KZ:{_allowed:"H hB",_preferred:"H"},MC:{_allowed:"H hB",_preferred:"H"},MD:{_allowed:"H hB",_preferred:"H"},MF:{_allowed:"H hB",_preferred:"H"},MQ:{_allowed:"H hB",_preferred:"H"},MZ:{_allowed:"H hB",_preferred:"H"},NC:{_allowed:"H hB",_preferred:"H"},NL:{_allowed:"H hB",_preferred:"H"},PM:{_allowed:"H hB",_preferred:"H"},PT:{_allowed:"H hB",_preferred:"H"},RE:{_allowed:"H hB",_preferred:"H"},RO:{_allowed:"H hB",_preferred:"H"},SI:{_allowed:"H hB",_preferred:"H"},SR:{_allowed:"H hB",_preferred:"H"},ST:{_allowed:"H hB",_preferred:"H"},TG:{_allowed:"H hB",_preferred:"H"},TR:{_allowed:"H hB",_preferred:"H"},WF:{_allowed:"H hB",_preferred:"H"},YT:{_allowed:"H hB",_preferred:"H"},BD:{_allowed:"h hB H",_preferred:"h"},PK:{_allowed:"h hB H",_preferred:"h"},AZ:{_allowed:"H hB h",_preferred:"H"},BA:{_allowed:"H hB h",_preferred:"H"},BG:{_allowed:"H hB h",_preferred:"H"},CH:{_allowed:"H hB h",_preferred:"H"},GE:{_allowed:"H hB h",_preferred:"H"},LI:{_allowed:"H hB h",_preferred:"H"},ME:{_allowed:"H hB h",_preferred:"H"},RS:{_allowed:"H hB h",_preferred:"H"},UA:{_allowed:"H hB h",_preferred:"H"},UZ:{_allowed:"H hB h",_preferred:"H"},XK:{_allowed:"H hB h",_preferred:"H"},AG:{_allowed:"h hb H hB",_preferred:"h"},AU:{_allowed:"h hb H hB",_preferred:"h"},BB:{_allowed:"h hb H hB",_preferred:"h"},BM:{_allowed:"h hb H hB",_preferred:"h"},BS:{_allowed:"h hb H hB",_preferred:"h"},CA:{_allowed:"h hb H hB",_preferred:"h"},DM:{_allowed:"h hb H hB",_preferred:"h"},en_001:{_allowed:"h hb H hB",_preferred:"h"},FJ:{_allowed:"h hb H hB",_preferred:"h"},FM:{_allowed:"h hb H hB",_preferred:"h"},GD:{_allowed:"h hb H hB",_preferred:"h"},GM:{_allowed:"h hb H hB",_preferred:"h"},GU:{_allowed:"h hb H hB",_preferred:"h"},GY:{_allowed:"h hb H hB",_preferred:"h"},JM:{_allowed:"h hb H hB",_preferred:"h"},KI:{_allowed:"h hb H hB",_preferred:"h"},KN:{_allowed:"h hb H hB",_preferred:"h"},KY:{_allowed:"h hb H hB",_preferred:"h"},LC:{_allowed:"h hb H hB",_preferred:"h"},LR:{_allowed:"h hb H hB",_preferred:"h"},MH:{_allowed:"h hb H hB",_preferred:"h"},MP:{_allowed:"h hb H hB",_preferred:"h"},MW:{_allowed:"h hb H hB",_preferred:"h"},NZ:{_allowed:"h hb H hB",_preferred:"h"},SB:{_allowed:"h hb H hB",_preferred:"h"},SG:{_allowed:"h hb H hB",_preferred:"h"},SL:{_allowed:"h hb H hB",_preferred:"h"},SS:{_allowed:"h hb H hB",_preferred:"h"},SZ:{_allowed:"h hb H hB",_preferred:"h"},TC:{_allowed:"h hb H hB",_preferred:"h"},TT:{_allowed:"h hb H hB",_preferred:"h"},UM:{_allowed:"h hb H hB",_preferred:"h"},US:{_allowed:"h hb H hB",_preferred:"h"},VC:{_allowed:"h hb H hB",_preferred:"h"},VG:{_allowed:"h hb H hB",_preferred:"h"},VI:{_allowed:"h hb H hB",_preferred:"h"},ZM:{_allowed:"h hb H hB",_preferred:"h"},BO:{_allowed:"H hB h hb",_preferred:"H"},EC:{_allowed:"H hB h hb",_preferred:"H"},ES:{_allowed:"H hB h hb",_preferred:"H"},GQ:{_allowed:"H hB h hb",_preferred:"H"},PE:{_allowed:"H hB h hb",_preferred:"H"},AE:{_allowed:"h hB hb H",_preferred:"h"},ar_001:{_allowed:"h hB hb H",_preferred:"h"},BH:{_allowed:"h hB hb H",_preferred:"h"},DZ:{_allowed:"h hB hb H",_preferred:"h"},EG:{_allowed:"h hB hb H",_preferred:"h"},EH:{_allowed:"h hB hb H",_preferred:"h"},IQ:{_allowed:"h hB hb H",_preferred:"h"},JO:{_allowed:"h hB hb H",_preferred:"h"},KW:{_allowed:"h hB hb H",_preferred:"h"},LB:{_allowed:"h hB hb H",_preferred:"h"},LY:{_allowed:"h hB hb H",_preferred:"h"},MR:{_allowed:"h hB hb H",_preferred:"h"},OM:{_allowed:"h hB hb H",_preferred:"h"},PH:{_allowed:"h hB hb H",_preferred:"h"},PS:{_allowed:"h hB hb H",_preferred:"h"},QA:{_allowed:"h hB hb H",_preferred:"h"},SA:{_allowed:"h hB hb H",_preferred:"h"},SD:{_allowed:"h hB hb H",_preferred:"h"},SY:{_allowed:"h hB hb H",_preferred:"h"},TN:{_allowed:"h hB hb H",_preferred:"h"},YE:{_allowed:"h hB hb H",_preferred:"h"},AF:{_allowed:"H hb hB h",_preferred:"H"},LA:{_allowed:"H hb hB h",_preferred:"H"},LV:{_allowed:"H hB hb h",_preferred:"H"},TL:{_allowed:"H hB hb h",_preferred:"H"},zu_ZA:{_allowed:"H hB hb h",_preferred:"H"},CD:{_allowed:"hB H",_preferred:"H"},IR:{_allowed:"hB H",_preferred:"H"},hi_IN:{_allowed:"hB h H",_preferred:"h"},kn_IN:{_allowed:"hB h H",_preferred:"h"},ml_IN:{_allowed:"hB h H",_preferred:"h"},te_IN:{_allowed:"hB h H",_preferred:"h"},KH:{_allowed:"hB h H hb",_preferred:"h"},ta_IN:{_allowed:"hB h hb H",_preferred:"h"},BN:{_allowed:"hb hB h H",_preferred:"h"},MY:{_allowed:"hb hB h H",_preferred:"h"},CN:{_allowed:"hB hb h H",_preferred:"h"},ET:{_allowed:"hB hb h H",_preferred:"h"},gu_IN:{_allowed:"hB hb h H",_preferred:"h"},HK:{_allowed:"hB hb h H",_preferred:"h"},MO:{_allowed:"hB hb h H",_preferred:"h"},mr_IN:{_allowed:"hB hb h H",_preferred:"h"},pa_IN:{_allowed:"hB hb h H",_preferred:"h"},TW:{_allowed:"hB hb h H",_preferred:"h"},KE:{_allowed:"hB hb H h",_preferred:"H"},MM:{_allowed:"hB hb H h",_preferred:"H"},TZ:{_allowed:"hB hb H h",_preferred:"H"},UG:{_allowed:"hB hb H h",_preferred:"H"}},weekData:{minDays:{"001":"1",AD:"4",AN:"4",AT:"4",AX:"4",BE:"4",BG:"4",CH:"4",CZ:"4",DE:"4",DK:"4",EE:"4",ES:"4",FI:"4",FJ:"4",FO:"4",FR:"4",GB:"4",GF:"4",GG:"4",GI:"4",GP:"4",GR:"4",GU:"1",HU:"4",IE:"4",IM:"4",IS:"4",IT:"4",JE:"4",LI:"4",LT:"4",LU:"4",MC:"4",MQ:"4",NL:"4",NO:"4",PL:"4",PT:"4",RE:"4",RU:"4",SE:"4",SJ:"4",SK:"4",SM:"4",UM:"1",US:"1",VA:"4",VI:"1"},firstDay:{"001":"mon",AD:"mon",AE:"sat",AF:"sat",AG:"sun",AI:"mon",AL:"mon",AM:"mon",AN:"mon",AR:"mon",AS:"sun",AT:"mon",AU:"sun",AX:"mon",AZ:"mon",BA:"mon",BD:"sun",BE:"mon",BG:"mon",BH:"sat",BM:"mon",BN:"mon",BR:"sun",BS:"sun",BT:"sun",BW:"sun",BY:"mon",BZ:"sun",CA:"sun",CH:"mon",CL:"mon",CM:"mon",CN:"sun",CO:"sun",CR:"mon",CY:"mon",CZ:"mon",DE:"mon",DJ:"sat",DK:"mon",DM:"sun",DO:"sun",DZ:"sat",EC:"mon",EE:"mon",EG:"sat",ES:"mon",ET:"sun",FI:"mon",FJ:"mon",FO:"mon",FR:"mon",GB:"mon","GB-alt-variant":"sun",GE:"mon",GF:"mon",GP:"mon",GR:"mon",GT:"sun",GU:"sun",HK:"sun",HN:"sun",HR:"mon",HU:"mon",ID:"sun",IE:"mon",IL:"sun",IN:"sun",IQ:"sat",IR:"sat",IS:"mon",IT:"mon",JM:"sun",JO:"sat",JP:"sun",KE:"sun",KG:"mon",KH:"sun",KR:"sun",KW:"sat",KZ:"mon",LA:"sun",LB:"mon",LI:"mon",LK:"mon",LT:"mon",LU:"mon",LV:"mon",LY:"sat",MC:"mon",MD:"mon",ME:"mon",MH:"sun",MK:"mon",MM:"sun",MN:"mon",MO:"sun",MQ:"mon",MT:"sun",MV:"fri",MX:"sun",MY:"mon",MZ:"sun",NI:"sun",NL:"mon",NO:"mon",NP:"sun",NZ:"mon",OM:"sat",PA:"sun",PE:"sun",PH:"sun",PK:"sun",PL:"mon",PR:"sun",PT:"sun",PY:"sun",QA:"sat",RE:"mon",RO:"mon",RS:"mon",RU:"mon",SA:"sun",SD:"sat",SE:"mon",SG:"sun",SI:"mon",SK:"mon",SM:"mon",SV:"sun",SY:"sat",TH:"sun",TJ:"mon",TM:"mon",TR:"mon",TT:"sun",TW:"sun",UA:"mon",UM:"sun",US:"sun",UY:"mon",UZ:"mon",VA:"mon",VE:"sun",VI:"sun",VN:"mon",WS:"sun",XK:"mon",YE:"sun",ZA:"sun",ZW:"sun"},weekendStart:{"001":"sat",AE:"fri",AF:"thu",BH:"fri",DZ:"fri",EG:"fri",IL:"fri",IN:"sun",IQ:"fri",IR:"fri",JO:"fri",KW:"fri",LY:"fri",OM:"fri",QA:"fri",SA:"fri",SD:"fri",SY:"fri",UG:"sun",YE:"fri"},weekendEnd:{"001":"sun",AE:"sat",AF:"fri",BH:"sat",DZ:"sat",EG:"sat",IL:"sat",IQ:"sat",IR:"fri",JO:"sat",KW:"sat",LY:"sat",OM:"sat",QA:"sat",SA:"sat",SD:"sat",SY:"sat",YE:"sat"},af:{_ordering:"weekOfDate weekOfInterval weekOfMonth"},"am az bs cs cy da el et hi ky lt mk sk ta th":{_ordering:"weekOfYear weekOfMonth"},"ar fil gu hu hy id kk ko":{_ordering:"weekOfMonth"},"be ro ru":{_ordering:"weekOfInterval weekOfMonth"},"bg de iw pt ur zh":{_ordering:"weekOfDate weekOfMonth weekOfInterval"},"ca es fr gl":{_ordering:"weekOfDate"},"en bn ja ka":{_ordering:"weekOfDate weekOfMonth"},eu:{_ordering:"weekOfMonth weekOfDate"},"fa hr it lv pl si sr uk uz":{_ordering:"weekOfMonth weekOfInterval"},"fi zh-TW":{_ordering:"weekOfYear weekOfDate weekOfMonth"},"is mn no sv vi":{_ordering:"weekOfYear weekOfMonth weekOfInterval"},"km mr":{_ordering:"weekOfMonth weekOfYear"},"kn ml pa":{_ordering:"weekOfMonth weekOfDate weekOfYear"},"lo sq":{_ordering:"weekOfMonth weekOfInterval weekOfDate weekOfYear"},"ms tr":{_ordering:"weekOfMonth weekOfYear weekOfInterval weekOfDate"},nl:{_ordering:"weekOfDate weekOfYear weekOfMonth"},sl:{_ordering:"weekOfInterval"},"sw te":{_ordering:"weekOfMonth weekOfInterval weekOfYear"},und:{_ordering:"weekOfYear"},zu:{_ordering:"weekOfYear weekOfInterval"}},currencyData:{fractions:{ADP:{_rounding:"0",_digits:"0"},AFN:{_rounding:"0",_digits:"0"},ALL:{_rounding:"0",_digits:"0"},AMD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},BHD:{_rounding:"0",_digits:"3"},BIF:{_rounding:"0",_digits:"0"},BYN:{_rounding:"0",_digits:"2"},BYR:{_rounding:"0",_digits:"0"},CAD:{_rounding:"0",_digits:"2",_cashRounding:"5"},CHF:{_rounding:"0",_digits:"2",_cashRounding:"5"},CLF:{_rounding:"0",_digits:"4"},CLP:{_rounding:"0",_digits:"0"},COP:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},CRC:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},CZK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},DEFAULT:{_rounding:"0",_digits:"2"},DJF:{_rounding:"0",_digits:"0"},DKK:{_rounding:"0",_digits:"2",_cashRounding:"50"},ESP:{_rounding:"0",_digits:"0"},GNF:{_rounding:"0",_digits:"0"},GYD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},HUF:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},IDR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},IQD:{_rounding:"0",_digits:"0"},IRR:{_rounding:"0",_digits:"0"},ISK:{_rounding:"0",_digits:"0"},ITL:{_rounding:"0",_digits:"0"},JOD:{_rounding:"0",_digits:"3"},JPY:{_rounding:"0",_digits:"0"},KMF:{_rounding:"0",_digits:"0"},KPW:{_rounding:"0",_digits:"0"},KRW:{_rounding:"0",_digits:"0"},KWD:{_rounding:"0",_digits:"3"},LAK:{_rounding:"0",_digits:"0"},LBP:{_rounding:"0",_digits:"0"},LUF:{_rounding:"0",_digits:"0"},LYD:{_rounding:"0",_digits:"3"},MGA:{_rounding:"0",_digits:"0"},MGF:{_rounding:"0",_digits:"0"},MMK:{_rounding:"0",_digits:"0"},MNT:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},MRO:{_rounding:"0",_digits:"0"},MUR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},NOK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},OMR:{_rounding:"0",_digits:"3"},PKR:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},PYG:{_rounding:"0",_digits:"0"},RSD:{_rounding:"0",_digits:"0"},RWF:{_rounding:"0",_digits:"0"},SEK:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},SLL:{_rounding:"0",_digits:"0"},SOS:{_rounding:"0",_digits:"0"},STD:{_rounding:"0",_digits:"0"},SYP:{_rounding:"0",_digits:"0"},TMM:{_rounding:"0",_digits:"0"},TND:{_rounding:"0",_digits:"3"},TRL:{_rounding:"0",_digits:"0"},TWD:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},TZS:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},UGX:{_rounding:"0",_digits:"0"},UYI:{_rounding:"0",_digits:"0"},UYW:{_rounding:"0",_digits:"4"},UZS:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},VEF:{_rounding:"0",_digits:"2",_cashRounding:"0",_cashDigits:"0"},VND:{_rounding:"0",_digits:"0"},VUV:{_rounding:"0",_digits:"0"},XAF:{_rounding:"0",_digits:"0"},XOF:{_rounding:"0",_digits:"0"},XPF:{_rounding:"0",_digits:"0"},YER:{_rounding:"0",_digits:"0"},ZMK:{_rounding:"0",_digits:"0"},ZWD:{_rounding:"0",_digits:"0"}},region:{AC:[{SHP:{_from:"1976-01-01"}}],AD:[{ESP:{_from:"1873-01-01",_to:"2002-02-28"}},{ADP:{_from:"1936-01-01",_to:"2001-12-31"}},{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],AE:[{AED:{_from:"1973-05-19"}}],AF:[{AFA:{_from:"1927-03-14",_to:"2002-12-31"}},{AFN:{_from:"2002-10-07"}}],AG:[{XCD:{_from:"1965-10-06"}}],AI:[{XCD:{_from:"1965-10-06"}}],AL:[{ALK:{_from:"1946-11-01",_to:"1965-08-16"}},{ALL:{_from:"1965-08-16"}}],AM:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-11-22"}},{AMD:{_from:"1993-11-22"}}],AO:[{AOK:{_from:"1977-01-08",_to:"1991-03-01"}},{AON:{_from:"1990-09-25",_to:"2000-02-01"}},{AOR:{_from:"1995-07-01",_to:"2000-02-01"}},{AOA:{_from:"1999-12-13"}}],AQ:[{XXX:{_tender:"false"}}],AR:[{ARM:{_from:"1881-11-05",_to:"1970-01-01"}},{ARL:{_from:"1970-01-01",_to:"1983-06-01"}},{ARP:{_from:"1983-06-01",_to:"1985-06-14"}},{ARA:{_from:"1985-06-14",_to:"1992-01-01"}},{ARS:{_from:"1992-01-01"}}],AS:[{USD:{_from:"1904-07-16"}}],AT:[{ATS:{_from:"1947-12-04",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],AU:[{AUD:{_from:"1966-02-14"}}],AW:[{ANG:{_from:"1940-05-10",_to:"1986-01-01"}},{AWG:{_from:"1986-01-01"}}],AX:[{EUR:{_from:"1999-01-01"}}],AZ:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1994-01-01"}},{AZM:{_from:"1993-11-22",_to:"2006-12-31"}},{AZN:{_from:"2006-01-01"}}],BA:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1992-07-01"}},{YUR:{_from:"1992-07-01",_to:"1993-10-01"}},{BAD:{_from:"1992-07-01",_to:"1994-08-15"}},{BAN:{_from:"1994-08-15",_to:"1997-07-01"}},{BAM:{_from:"1995-01-01"}}],BB:[{XCD:{_from:"1965-10-06",_to:"1973-12-03"}},{BBD:{_from:"1973-12-03"}}],BD:[{INR:{_from:"1835-08-17",_to:"1948-04-01"}},{PKR:{_from:"1948-04-01",_to:"1972-01-01"}},{BDT:{_from:"1972-01-01"}}],BE:[{NLG:{_from:"1816-12-15",_to:"1831-02-07"}},{BEF:{_from:"1831-02-07",_to:"2002-02-28"}},{BEC:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{BEL:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{EUR:{_from:"1999-01-01"}}],BF:[{XOF:{_from:"1984-08-04"}}],BG:[{BGO:{_from:"1879-07-08",_to:"1952-05-12"}},{BGM:{_from:"1952-05-12",_to:"1962-01-01"}},{BGL:{_from:"1962-01-01",_to:"1999-07-05"}},{BGN:{_from:"1999-07-05"}}],BH:[{BHD:{_from:"1965-10-16"}}],BI:[{BIF:{_from:"1964-05-19"}}],BJ:[{XOF:{_from:"1975-11-30"}}],BL:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],BM:[{BMD:{_from:"1970-02-06"}}],BN:[{MYR:{_from:"1963-09-16",_to:"1967-06-12"}},{BND:{_from:"1967-06-12"}}],BO:[{BOV:{_tender:"false"}},{BOL:{_from:"1863-06-23",_to:"1963-01-01"}},{BOP:{_from:"1963-01-01",_to:"1986-12-31"}},{BOB:{_from:"1987-01-01"}}],BQ:[{ANG:{_from:"2010-10-10",_to:"2011-01-01"}},{USD:{_from:"2011-01-01"}}],BR:[{BRZ:{_from:"1942-11-01",_to:"1967-02-13"}},{BRB:{_from:"1967-02-13",_to:"1986-02-28"}},{BRC:{_from:"1986-02-28",_to:"1989-01-15"}},{BRN:{_from:"1989-01-15",_to:"1990-03-16"}},{BRE:{_from:"1990-03-16",_to:"1993-08-01"}},{BRR:{_from:"1993-08-01",_to:"1994-07-01"}},{BRL:{_from:"1994-07-01"}}],BS:[{BSD:{_from:"1966-05-25"}}],BT:[{INR:{_from:"1907-01-01"}},{BTN:{_from:"1974-04-16"}}],BU:[{BUK:{_from:"1952-07-01",_to:"1989-06-18"}}],BV:[{NOK:{_from:"1905-06-07"}}],BW:[{ZAR:{_from:"1961-02-14",_to:"1976-08-23"}},{BWP:{_from:"1976-08-23"}}],BY:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1994-11-08"}},{BYB:{_from:"1994-08-01",_to:"2000-12-31"}},{BYR:{_from:"2000-01-01",_to:"2017-01-01"}},{BYN:{_from:"2016-07-01"}}],BZ:[{BZD:{_from:"1974-01-01"}}],CA:[{CAD:{_from:"1858-01-01"}}],CC:[{AUD:{_from:"1966-02-14"}}],CD:[{ZRZ:{_from:"1971-10-27",_to:"1993-11-01"}},{ZRN:{_from:"1993-11-01",_to:"1998-07-01"}},{CDF:{_from:"1998-07-01"}}],CF:[{XAF:{_from:"1993-01-01"}}],CG:[{XAF:{_from:"1993-01-01"}}],CH:[{CHE:{_tender:"false"}},{CHW:{_tender:"false"}},{CHF:{_from:"1799-03-17"}}],CI:[{XOF:{_from:"1958-12-04"}}],CK:[{NZD:{_from:"1967-07-10"}}],CL:[{CLF:{_tender:"false"}},{CLE:{_from:"1960-01-01",_to:"1975-09-29"}},{CLP:{_from:"1975-09-29"}}],CM:[{XAF:{_from:"1973-04-01"}}],CN:[{CNY:{_from:"1953-03-01"}},{CNX:{_tender:"false",_from:"1979-01-01",_to:"1998-12-31"}},{CNH:{_tender:"false",_from:"2010-07-19"}}],CO:[{COU:{_tender:"false"}},{COP:{_from:"1905-01-01"}}],CP:[{XXX:{_tender:"false"}}],CR:[{CRC:{_from:"1896-10-26"}}],CS:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{CSD:{_from:"2002-05-15",_to:"2006-06-03"}},{EUR:{_from:"2003-02-04",_to:"2006-06-03"}}],CU:[{CUP:{_from:"1859-01-01"}},{USD:{_from:"1899-01-01",_to:"1959-01-01"}},{CUC:{_from:"1994-01-01"}}],CV:[{PTE:{_from:"1911-05-22",_to:"1975-07-05"}},{CVE:{_from:"1914-01-01"}}],CW:[{ANG:{_from:"2010-10-10"}}],CX:[{AUD:{_from:"1966-02-14"}}],CY:[{CYP:{_from:"1914-09-10",_to:"2008-01-31"}},{EUR:{_from:"2008-01-01"}}],CZ:[{CSK:{_from:"1953-06-01",_to:"1993-03-01"}},{CZK:{_from:"1993-01-01"}}],DD:[{DDM:{_from:"1948-07-20",_to:"1990-10-02"}}],DE:[{DEM:{_from:"1948-06-20",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],DG:[{USD:{_from:"1965-11-08"}}],DJ:[{DJF:{_from:"1977-06-27"}}],DK:[{DKK:{_from:"1873-05-27"}}],DM:[{XCD:{_from:"1965-10-06"}}],DO:[{USD:{_from:"1905-06-21",_to:"1947-10-01"}},{DOP:{_from:"1947-10-01"}}],DZ:[{DZD:{_from:"1964-04-01"}}],EA:[{EUR:{_from:"1999-01-01"}}],EC:[{ECS:{_from:"1884-04-01",_to:"2000-10-02"}},{ECV:{_tender:"false",_from:"1993-05-23",_to:"2000-01-09"}},{USD:{_from:"2000-10-02"}}],EE:[{SUR:{_from:"1961-01-01",_to:"1992-06-20"}},{EEK:{_from:"1992-06-21",_to:"2010-12-31"}},{EUR:{_from:"2011-01-01"}}],EG:[{EGP:{_from:"1885-11-14"}}],EH:[{MAD:{_from:"1976-02-26"}}],ER:[{ETB:{_from:"1993-05-24",_to:"1997-11-08"}},{ERN:{_from:"1997-11-08"}}],ES:[{ESP:{_from:"1868-10-19",_to:"2002-02-28"}},{ESB:{_tender:"false",_from:"1975-01-01",_to:"1994-12-31"}},{ESA:{_tender:"false",_from:"1978-01-01",_to:"1981-12-31"}},{EUR:{_from:"1999-01-01"}}],ET:[{ETB:{_from:"1976-09-15"}}],EU:[{XEU:{_tender:"false",_from:"1979-01-01",_to:"1998-12-31"}},{EUR:{_from:"1999-01-01"}}],FI:[{FIM:{_from:"1963-01-01",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],FJ:[{FJD:{_from:"1969-01-13"}}],FK:[{FKP:{_from:"1901-01-01"}}],FM:[{JPY:{_from:"1914-10-03",_to:"1944-01-01"}},{USD:{_from:"1944-01-01"}}],FO:[{DKK:{_from:"1948-01-01"}}],FR:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GA:[{XAF:{_from:"1993-01-01"}}],GB:[{GBP:{_from:"1694-07-27"}}],GD:[{XCD:{_from:"1967-02-27"}}],GE:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-06-11"}},{GEK:{_from:"1993-04-05",_to:"1995-09-25"}},{GEL:{_from:"1995-09-23"}}],GF:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GG:[{GBP:{_from:"1830-01-01"}}],GH:[{GHC:{_from:"1979-03-09",_to:"2007-12-31"}},{GHS:{_from:"2007-07-03"}}],GI:[{GIP:{_from:"1713-01-01"}}],GL:[{DKK:{_from:"1873-05-27"}}],GM:[{GMD:{_from:"1971-07-01"}}],GN:[{GNS:{_from:"1972-10-02",_to:"1986-01-06"}},{GNF:{_from:"1986-01-06"}}],GP:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],GQ:[{GQE:{_from:"1975-07-07",_to:"1986-06-01"}},{XAF:{_from:"1993-01-01"}}],GR:[{GRD:{_from:"1954-05-01",_to:"2002-02-28"}},{EUR:{_from:"2001-01-01"}}],GS:[{GBP:{_from:"1908-01-01"}}],GT:[{GTQ:{_from:"1925-05-27"}}],GU:[{USD:{_from:"1944-08-21"}}],GW:[{GWE:{_from:"1914-01-01",_to:"1976-02-28"}},{GWP:{_from:"1976-02-28",_to:"1997-03-31"}},{XOF:{_from:"1997-03-31"}}],GY:[{GYD:{_from:"1966-05-26"}}],HK:[{HKD:{_from:"1895-02-02"}}],HM:[{AUD:{_from:"1967-02-16"}}],HN:[{HNL:{_from:"1926-04-03"}}],HR:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1991-12-23"}},{HRD:{_from:"1991-12-23",_to:"1995-01-01"}},{HRK:{_from:"1994-05-30"}}],HT:[{HTG:{_from:"1872-08-26"}},{USD:{_from:"1915-01-01"}}],HU:[{HUF:{_from:"1946-07-23"}}],IC:[{EUR:{_from:"1999-01-01"}}],ID:[{IDR:{_from:"1965-12-13"}}],IE:[{GBP:{_from:"1800-01-01",_to:"1922-01-01"}},{IEP:{_from:"1922-01-01",_to:"2002-02-09"}},{EUR:{_from:"1999-01-01"}}],IL:[{ILP:{_from:"1948-08-16",_to:"1980-02-22"}},{ILR:{_from:"1980-02-22",_to:"1985-09-04"}},{ILS:{_from:"1985-09-04"}}],IM:[{GBP:{_from:"1840-01-03"}}],IN:[{INR:{_from:"1835-08-17"}}],IO:[{USD:{_from:"1965-11-08"}}],IQ:[{EGP:{_from:"1920-11-11",_to:"1931-04-19"}},{INR:{_from:"1920-11-11",_to:"1931-04-19"}},{IQD:{_from:"1931-04-19"}}],IR:[{IRR:{_from:"1932-05-13"}}],IS:[{DKK:{_from:"1873-05-27",_to:"1918-12-01"}},{ISJ:{_from:"1918-12-01",_to:"1981-01-01"}},{ISK:{_from:"1981-01-01"}}],IT:[{ITL:{_from:"1862-08-24",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],JE:[{GBP:{_from:"1837-01-01"}}],JM:[{JMD:{_from:"1969-09-08"}}],JO:[{JOD:{_from:"1950-07-01"}}],JP:[{JPY:{_from:"1871-06-01"}}],KE:[{KES:{_from:"1966-09-14"}}],KG:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-05-10"}},{KGS:{_from:"1993-05-10"}}],KH:[{KHR:{_from:"1980-03-20"}}],KI:[{AUD:{_from:"1966-02-14"}}],KM:[{KMF:{_from:"1975-07-06"}}],KN:[{XCD:{_from:"1965-10-06"}}],KP:[{KPW:{_from:"1959-04-17"}}],KR:[{KRO:{_from:"1945-08-15",_to:"1953-02-15"}},{KRH:{_from:"1953-02-15",_to:"1962-06-10"}},{KRW:{_from:"1962-06-10"}}],KW:[{KWD:{_from:"1961-04-01"}}],KY:[{JMD:{_from:"1969-09-08",_to:"1971-01-01"}},{KYD:{_from:"1971-01-01"}}],KZ:[{KZT:{_from:"1993-11-05"}}],LA:[{LAK:{_from:"1979-12-10"}}],LB:[{LBP:{_from:"1948-02-02"}}],LC:[{XCD:{_from:"1965-10-06"}}],LI:[{CHF:{_from:"1921-02-01"}}],LK:[{LKR:{_from:"1978-05-22"}}],LR:[{LRD:{_from:"1944-01-01"}}],LS:[{ZAR:{_from:"1961-02-14"}},{LSL:{_from:"1980-01-22"}}],LT:[{SUR:{_from:"1961-01-01",_to:"1992-10-01"}},{LTT:{_from:"1992-10-01",_to:"1993-06-25"}},{LTL:{_from:"1993-06-25",_to:"2014-12-31"}},{EUR:{_from:"2015-01-01"}}],LU:[{LUF:{_from:"1944-09-04",_to:"2002-02-28"}},{LUC:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{LUL:{_tender:"false",_from:"1970-01-01",_to:"1990-03-05"}},{EUR:{_from:"1999-01-01"}}],LV:[{SUR:{_from:"1961-01-01",_to:"1992-07-20"}},{LVR:{_from:"1992-05-07",_to:"1993-10-17"}},{LVL:{_from:"1993-06-28",_to:"2013-12-31"}},{EUR:{_from:"2014-01-01"}}],LY:[{LYD:{_from:"1971-09-01"}}],MA:[{MAF:{_from:"1881-01-01",_to:"1959-10-17"}},{MAD:{_from:"1959-10-17"}}],MC:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{MCF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MD:[{MDC:{_from:"1992-06-01",_to:"1993-11-29"}},{MDL:{_from:"1993-11-29"}}],ME:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{DEM:{_from:"1999-10-02",_to:"2002-05-15"}},{EUR:{_from:"2002-01-01"}}],MF:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MG:[{MGF:{_from:"1963-07-01",_to:"2004-12-31"}},{MGA:{_from:"1983-11-01"}}],MH:[{USD:{_from:"1944-01-01"}}],MK:[{MKN:{_from:"1992-04-26",_to:"1993-05-20"}},{MKD:{_from:"1993-05-20"}}],ML:[{XOF:{_from:"1958-11-24",_to:"1962-07-02"}},{MLF:{_from:"1962-07-02",_to:"1984-08-31"}},{XOF:{_from:"1984-06-01"}}],MM:[{BUK:{_from:"1952-07-01",_to:"1989-06-18"}},{MMK:{_from:"1989-06-18"}}],MN:[{MNT:{_from:"1915-03-01"}}],MO:[{MOP:{_from:"1901-01-01"}}],MP:[{USD:{_from:"1944-01-01"}}],MQ:[{FRF:{_from:"1960-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],MR:[{XOF:{_from:"1958-11-28",_to:"1973-06-29"}},{MRO:{_from:"1973-06-29",_to:"2018-06-30"}},{MRU:{_from:"2018-01-01"}}],MS:[{XCD:{_from:"1967-02-27"}}],MT:[{MTP:{_from:"1914-08-13",_to:"1968-06-07"}},{MTL:{_from:"1968-06-07",_to:"2008-01-31"}},{EUR:{_from:"2008-01-01"}}],MU:[{MUR:{_from:"1934-04-01"}}],MV:[{MVP:{_from:"1947-01-01",_to:"1981-07-01"}},{MVR:{_from:"1981-07-01"}}],MW:[{MWK:{_from:"1971-02-15"}}],MX:[{MXV:{_tender:"false"}},{MXP:{_from:"1822-01-01",_to:"1992-12-31"}},{MXN:{_from:"1993-01-01"}}],MY:[{MYR:{_from:"1963-09-16"}}],MZ:[{MZE:{_from:"1975-06-25",_to:"1980-06-16"}},{MZM:{_from:"1980-06-16",_to:"2006-12-31"}},{MZN:{_from:"2006-07-01"}}],NA:[{ZAR:{_from:"1961-02-14"}},{NAD:{_from:"1993-01-01"}}],NC:[{XPF:{_from:"1985-01-01"}}],NE:[{XOF:{_from:"1958-12-19"}}],NF:[{AUD:{_from:"1966-02-14"}}],NG:[{NGN:{_from:"1973-01-01"}}],NI:[{NIC:{_from:"1988-02-15",_to:"1991-04-30"}},{NIO:{_from:"1991-04-30"}}],NL:[{NLG:{_from:"1813-01-01",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],NO:[{SEK:{_from:"1873-05-27",_to:"1905-06-07"}},{NOK:{_from:"1905-06-07"}}],NP:[{INR:{_from:"1870-01-01",_to:"1966-10-17"}},{NPR:{_from:"1933-01-01"}}],NR:[{AUD:{_from:"1966-02-14"}}],NU:[{NZD:{_from:"1967-07-10"}}],NZ:[{NZD:{_from:"1967-07-10"}}],OM:[{OMR:{_from:"1972-11-11"}}],PA:[{PAB:{_from:"1903-11-04"}},{USD:{_from:"1903-11-18"}}],PE:[{PES:{_from:"1863-02-14",_to:"1985-02-01"}},{PEI:{_from:"1985-02-01",_to:"1991-07-01"}},{PEN:{_from:"1991-07-01"}}],PF:[{XPF:{_from:"1945-12-26"}}],PG:[{AUD:{_from:"1966-02-14",_to:"1975-09-16"}},{PGK:{_from:"1975-09-16"}}],PH:[{PHP:{_from:"1946-07-04"}}],PK:[{INR:{_from:"1835-08-17",_to:"1947-08-15"}},{PKR:{_from:"1948-04-01"}}],PL:[{PLZ:{_from:"1950-10-28",_to:"1994-12-31"}},{PLN:{_from:"1995-01-01"}}],PM:[{FRF:{_from:"1972-12-21",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],PN:[{NZD:{_from:"1969-01-13"}}],PR:[{ESP:{_from:"1800-01-01",_to:"1898-12-10"}},{USD:{_from:"1898-12-10"}}],PS:[{JOD:{_from:"1950-07-01",_to:"1967-06-01"}},{ILP:{_from:"1967-06-01",_to:"1980-02-22"}},{ILS:{_from:"1985-09-04"}},{JOD:{_from:"1996-02-12"}}],PT:[{PTE:{_from:"1911-05-22",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],PW:[{USD:{_from:"1944-01-01"}}],PY:[{PYG:{_from:"1943-11-01"}}],QA:[{QAR:{_from:"1973-05-19"}}],RE:[{FRF:{_from:"1975-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],RO:[{ROL:{_from:"1952-01-28",_to:"2006-12-31"}},{RON:{_from:"2005-07-01"}}],RS:[{YUM:{_from:"1994-01-24",_to:"2002-05-15"}},{CSD:{_from:"2002-05-15",_to:"2006-10-25"}},{RSD:{_from:"2006-10-25"}}],RU:[{RUR:{_from:"1991-12-25",_to:"1998-12-31"}},{RUB:{_from:"1999-01-01"}}],RW:[{RWF:{_from:"1964-05-19"}}],SA:[{SAR:{_from:"1952-10-22"}}],SB:[{AUD:{_from:"1966-02-14",_to:"1978-06-30"}},{SBD:{_from:"1977-10-24"}}],SC:[{SCR:{_from:"1903-11-01"}}],SD:[{EGP:{_from:"1889-01-19",_to:"1958-01-01"}},{GBP:{_from:"1889-01-19",_to:"1958-01-01"}},{SDP:{_from:"1957-04-08",_to:"1998-06-01"}},{SDD:{_from:"1992-06-08",_to:"2007-06-30"}},{SDG:{_from:"2007-01-10"}}],SE:[{SEK:{_from:"1873-05-27"}}],SG:[{MYR:{_from:"1963-09-16",_to:"1967-06-12"}},{SGD:{_from:"1967-06-12"}}],SH:[{SHP:{_from:"1917-02-15"}}],SI:[{SIT:{_from:"1992-10-07",_to:"2007-01-14"}},{EUR:{_from:"2007-01-01"}}],SJ:[{NOK:{_from:"1905-06-07"}}],SK:[{CSK:{_from:"1953-06-01",_to:"1992-12-31"}},{SKK:{_from:"1992-12-31",_to:"2009-01-01"}},{EUR:{_from:"2009-01-01"}}],SL:[{GBP:{_from:"1808-11-30",_to:"1966-02-04"}},{SLL:{_from:"1964-08-04"}}],SM:[{ITL:{_from:"1865-12-23",_to:"2001-02-28"}},{EUR:{_from:"1999-01-01"}}],SN:[{XOF:{_from:"1959-04-04"}}],SO:[{SOS:{_from:"1960-07-01"}}],SR:[{NLG:{_from:"1815-11-20",_to:"1940-05-10"}},{SRG:{_from:"1940-05-10",_to:"2003-12-31"}},{SRD:{_from:"2004-01-01"}}],SS:[{SDG:{_from:"2007-01-10",_to:"2011-09-01"}},{SSP:{_from:"2011-07-18"}}],ST:[{STD:{_from:"1977-09-08",_to:"2017-12-31"}},{STN:{_from:"2018-01-01"}}],SU:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}}],SV:[{SVC:{_from:"1919-11-11",_to:"2001-01-01"}},{USD:{_from:"2001-01-01"}}],SX:[{ANG:{_from:"2010-10-10"}}],SY:[{SYP:{_from:"1948-01-01"}}],SZ:[{SZL:{_from:"1974-09-06"}}],TA:[{GBP:{_from:"1938-01-12"}}],TC:[{USD:{_from:"1969-09-08"}}],TD:[{XAF:{_from:"1993-01-01"}}],TF:[{FRF:{_from:"1959-01-01",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],TG:[{XOF:{_from:"1958-11-28"}}],TH:[{THB:{_from:"1928-04-15"}}],TJ:[{RUR:{_from:"1991-12-25",_to:"1995-05-10"}},{TJR:{_from:"1995-05-10",_to:"2000-10-25"}},{TJS:{_from:"2000-10-26"}}],TK:[{NZD:{_from:"1967-07-10"}}],TL:[{TPE:{_from:"1959-01-02",_to:"2002-05-20"}},{IDR:{_from:"1975-12-07",_to:"2002-05-20"}},{USD:{_from:"1999-10-20"}}],TM:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1993-11-01"}},{TMM:{_from:"1993-11-01",_to:"2009-01-01"}},{TMT:{_from:"2009-01-01"}}],TN:[{TND:{_from:"1958-11-01"}}],TO:[{TOP:{_from:"1966-02-14"}}],TP:[{TPE:{_from:"1959-01-02",_to:"2002-05-20"}},{IDR:{_from:"1975-12-07",_to:"2002-05-20"}}],TR:[{TRL:{_from:"1922-11-01",_to:"2005-12-31"}},{TRY:{_from:"2005-01-01"}}],TT:[{TTD:{_from:"1964-01-01"}}],TV:[{AUD:{_from:"1966-02-14"}}],TW:[{TWD:{_from:"1949-06-15"}}],TZ:[{TZS:{_from:"1966-06-14"}}],UA:[{SUR:{_from:"1961-01-01",_to:"1991-12-25"}},{RUR:{_from:"1991-12-25",_to:"1992-11-13"}},{UAK:{_from:"1992-11-13",_to:"1993-10-17"}},{UAH:{_from:"1996-09-02"}}],UG:[{UGS:{_from:"1966-08-15",_to:"1987-05-15"}},{UGX:{_from:"1987-05-15"}}],UM:[{USD:{_from:"1944-01-01"}}],US:[{USN:{_tender:"false"}},{USS:{_tender:"false",_to:"2014-03-01"}},{USD:{_from:"1792-01-01"}}],UY:[{UYI:{_tender:"false"}},{UYW:{_tender:"false"}},{UYP:{_from:"1975-07-01",_to:"1993-03-01"}},{UYU:{_from:"1993-03-01"}}],UZ:[{UZS:{_from:"1994-07-01"}}],VA:[{ITL:{_from:"1870-10-19",_to:"2002-02-28"}},{EUR:{_from:"1999-01-01"}}],VC:[{XCD:{_from:"1965-10-06"}}],VE:[{VEB:{_from:"1871-05-11",_to:"2008-06-30"}},{VEF:{_from:"2008-01-01",_to:"2018-08-20"}},{VES:{_from:"2018-08-20"}}],VG:[{USD:{_from:"1833-01-01"}},{GBP:{_from:"1833-01-01",_to:"1959-01-01"}}],VI:[{USD:{_from:"1837-01-01"}}],VN:[{VNN:{_from:"1978-05-03",_to:"1985-09-14"}},{VND:{_from:"1985-09-14"}}],VU:[{VUV:{_from:"1981-01-01"}}],WF:[{XPF:{_from:"1961-07-30"}}],WS:[{WST:{_from:"1967-07-10"}}],XK:[{YUM:{_from:"1994-01-24",_to:"1999-09-30"}},{DEM:{_from:"1999-09-01",_to:"2002-03-09"}},{EUR:{_from:"2002-01-01"}}],YD:[{YDD:{_from:"1965-04-01",_to:"1996-01-01"}}],YE:[{YER:{_from:"1990-05-22"}}],YT:[{KMF:{_from:"1975-01-01",_to:"1976-02-23"}},{FRF:{_from:"1976-02-23",_to:"2002-02-17"}},{EUR:{_from:"1999-01-01"}}],YU:[{YUD:{_from:"1966-01-01",_to:"1990-01-01"}},{YUN:{_from:"1990-01-01",_to:"1992-07-24"}},{YUM:{_from:"1994-01-24",_to:"2002-05-15"}}],ZA:[{ZAR:{_from:"1961-02-14"}},{ZAL:{_tender:"false",_from:"1985-09-01",_to:"1995-03-13"}}],ZM:[{ZMK:{_from:"1968-01-16",_to:"2013-01-01"}},{ZMW:{_from:"2013-01-01"}}],ZR:[{ZRZ:{_from:"1971-10-27",_to:"1993-11-01"}},{ZRN:{_from:"1993-11-01",_to:"1998-07-31"}}],ZW:[{RHD:{_from:"1970-02-17",_to:"1980-04-18"}},{ZWD:{_from:"1980-04-18",_to:"2008-08-01"}},{ZWR:{_from:"2008-08-01",_to:"2009-02-02"}},{ZWL:{_from:"2009-02-02",_to:"2009-04-12"}},{USD:{_from:"2009-04-12"}}],ZZ:[{XAG:{_tender:"false"}},{XAU:{_tender:"false"}},{XBA:{_tender:"false"}},{XBB:{_tender:"false"}},{XBC:{_tender:"false"}},{XBD:{_tender:"false"}},{XDR:{_tender:"false"}},{XPD:{_tender:"false"}},{XPT:{_tender:"false"}},{XSU:{_tender:"false"}},{XTS:{_tender:"false"}},{XUA:{_tender:"false"}},{XXX:{_tender:"false"}},{XRE:{_tender:"false",_to:"1999-11-30"}},{XFU:{_tender:"false",_to:"2013-11-30"}},{XFO:{_tender:"false",_from:"1930-01-01",_to:"2003-04-01"}}]}},numberingSystems:{adlm:{_digits:"\ud83a\udd50\ud83a\udd51\ud83a\udd52\ud83a\udd53\ud83a\udd54\ud83a\udd55\ud83a\udd56\ud83a\udd57\ud83a\udd58\ud83a\udd59",_type:"numeric"},ahom:{_digits:"\ud805\udf30\ud805\udf31\ud805\udf32\ud805\udf33\ud805\udf34\ud805\udf35\ud805\udf36\ud805\udf37\ud805\udf38\ud805\udf39",_type:"numeric"},arab:{_digits:"\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669",_type:"numeric"},arabext:{_digits:"\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9",_type:"numeric"},armn:{_rules:"armenian-upper",_type:"algorithmic"},armnlow:{_rules:"armenian-lower",_type:"algorithmic"},bali:{_digits:"\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59",_type:"numeric"},beng:{_digits:"\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef",_type:"numeric"},bhks:{_digits:"\ud807\udc50\ud807\udc51\ud807\udc52\ud807\udc53\ud807\udc54\ud807\udc55\ud807\udc56\ud807\udc57\ud807\udc58\ud807\udc59",_type:"numeric"},brah:{_digits:"\ud804\udc66\ud804\udc67\ud804\udc68\ud804\udc69\ud804\udc6a\ud804\udc6b\ud804\udc6c\ud804\udc6d\ud804\udc6e\ud804\udc6f",_type:"numeric"},cakm:{_digits:"\ud804\udd36\ud804\udd37\ud804\udd38\ud804\udd39\ud804\udd3a\ud804\udd3b\ud804\udd3c\ud804\udd3d\ud804\udd3e\ud804\udd3f",_type:"numeric"},cham:{_digits:"\uaa50\uaa51\uaa52\uaa53\uaa54\uaa55\uaa56\uaa57\uaa58\uaa59",_type:"numeric"},cyrl:{_rules:"cyrillic-lower",_type:"algorithmic"},deva:{_digits:"\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f",_type:"numeric"},ethi:{_rules:"ethiopic",_type:"algorithmic"},fullwide:{_digits:"\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19",_type:"numeric"},geor:{_rules:"georgian",_type:"algorithmic"},gong:{_digits:"\ud807\udda0\ud807\udda1\ud807\udda2\ud807\udda3\ud807\udda4\ud807\udda5\ud807\udda6\ud807\udda7\ud807\udda8\ud807\udda9",_type:"numeric"},gonm:{_digits:"\ud807\udd50\ud807\udd51\ud807\udd52\ud807\udd53\ud807\udd54\ud807\udd55\ud807\udd56\ud807\udd57\ud807\udd58\ud807\udd59",_type:"numeric"},grek:{_rules:"greek-upper",_type:"algorithmic"},greklow:{_rules:"greek-lower",_type:"algorithmic"},gujr:{_digits:"\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef",_type:"numeric"},guru:{_digits:"\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f",_type:"numeric"},hanidays:{_rules:"zh/SpelloutRules/spellout-numbering-days",_type:"algorithmic"},hanidec:{_digits:"\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d",_type:"numeric"},hans:{_rules:"zh/SpelloutRules/spellout-cardinal",_type:"algorithmic"},hansfin:{_rules:"zh/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},hant:{_rules:"zh_Hant/SpelloutRules/spellout-cardinal",_type:"algorithmic"},hantfin:{_rules:"zh_Hant/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},hebr:{_rules:"hebrew",_type:"algorithmic"},hmng:{_digits:"\ud81a\udf50\ud81a\udf51\ud81a\udf52\ud81a\udf53\ud81a\udf54\ud81a\udf55\ud81a\udf56\ud81a\udf57\ud81a\udf58\ud81a\udf59",_type:"numeric"},hmnp:{_digits:"\ud838\udd40\ud838\udd41\ud838\udd42\ud838\udd43\ud838\udd44\ud838\udd45\ud838\udd46\ud838\udd47\ud838\udd48\ud838\udd49",_type:"numeric"},java:{_digits:"\ua9d0\ua9d1\ua9d2\ua9d3\ua9d4\ua9d5\ua9d6\ua9d7\ua9d8\ua9d9",_type:"numeric"},jpan:{_rules:"ja/SpelloutRules/spellout-cardinal",_type:"algorithmic"},jpanfin:{_rules:"ja/SpelloutRules/spellout-cardinal-financial",_type:"algorithmic"},jpanyear:{_rules:"ja/SpelloutRules/spellout-numbering-year-latn",_type:"algorithmic"},kali:{_digits:"\ua900\ua901\ua902\ua903\ua904\ua905\ua906\ua907\ua908\ua909",_type:"numeric"},khmr:{_digits:"\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9",_type:"numeric"},knda:{_digits:"\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef",_type:"numeric"},lana:{_digits:"\u1a80\u1a81\u1a82\u1a83\u1a84\u1a85\u1a86\u1a87\u1a88\u1a89",_type:"numeric"},lanatham:{_digits:"\u1a90\u1a91\u1a92\u1a93\u1a94\u1a95\u1a96\u1a97\u1a98\u1a99",_type:"numeric"},laoo:{_digits:"\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9",_type:"numeric"},latn:{_digits:"0123456789",_type:"numeric"},lepc:{_digits:"\u1c40\u1c41\u1c42\u1c43\u1c44\u1c45\u1c46\u1c47\u1c48\u1c49",_type:"numeric"},limb:{_digits:"\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f",_type:"numeric"},mathbold:{_digits:"\ud835\udfce\ud835\udfcf\ud835\udfd0\ud835\udfd1\ud835\udfd2\ud835\udfd3\ud835\udfd4\ud835\udfd5\ud835\udfd6\ud835\udfd7",_type:"numeric"},mathdbl:{_digits:"\ud835\udfd8\ud835\udfd9\ud835\udfda\ud835\udfdb\ud835\udfdc\ud835\udfdd\ud835\udfde\ud835\udfdf\ud835\udfe0\ud835\udfe1",_type:"numeric"},mathmono:{_digits:"\ud835\udff6\ud835\udff7\ud835\udff8\ud835\udff9\ud835\udffa\ud835\udffb\ud835\udffc\ud835\udffd\ud835\udffe\ud835\udfff",_type:"numeric"},mathsanb:{_digits:"\ud835\udfec\ud835\udfed\ud835\udfee\ud835\udfef\ud835\udff0\ud835\udff1\ud835\udff2\ud835\udff3\ud835\udff4\ud835\udff5",_type:"numeric"},mathsans:{_digits:"\ud835\udfe2\ud835\udfe3\ud835\udfe4\ud835\udfe5\ud835\udfe6\ud835\udfe7\ud835\udfe8\ud835\udfe9\ud835\udfea\ud835\udfeb",_type:"numeric"},mlym:{_digits:"\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f",_type:"numeric"},modi:{_digits:"\ud805\ude50\ud805\ude51\ud805\ude52\ud805\ude53\ud805\ude54\ud805\ude55\ud805\ude56\ud805\ude57\ud805\ude58\ud805\ude59",_type:"numeric"},mong:{_digits:"\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819",_type:"numeric"},mroo:{_digits:"\ud81a\ude60\ud81a\ude61\ud81a\ude62\ud81a\ude63\ud81a\ude64\ud81a\ude65\ud81a\ude66\ud81a\ude67\ud81a\ude68\ud81a\ude69",_type:"numeric"},mtei:{_digits:"\uabf0\uabf1\uabf2\uabf3\uabf4\uabf5\uabf6\uabf7\uabf8\uabf9",_type:"numeric"},mymr:{_digits:"\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049",_type:"numeric"},mymrshan:{_digits:"\u1090\u1091\u1092\u1093\u1094\u1095\u1096\u1097\u1098\u1099",_type:"numeric"},mymrtlng:{_digits:"\ua9f0\ua9f1\ua9f2\ua9f3\ua9f4\ua9f5\ua9f6\ua9f7\ua9f8\ua9f9",_type:"numeric"},newa:{_digits:"\ud805\udc50\ud805\udc51\ud805\udc52\ud805\udc53\ud805\udc54\ud805\udc55\ud805\udc56\ud805\udc57\ud805\udc58\ud805\udc59",_type:"numeric"},nkoo:{_digits:"\u07c0\u07c1\u07c2\u07c3\u07c4\u07c5\u07c6\u07c7\u07c8\u07c9",_type:"numeric"},olck:{_digits:"\u1c50\u1c51\u1c52\u1c53\u1c54\u1c55\u1c56\u1c57\u1c58\u1c59",_type:"numeric"},orya:{_digits:"\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f",_type:"numeric"},osma:{_digits:"\ud801\udca0\ud801\udca1\ud801\udca2\ud801\udca3\ud801\udca4\ud801\udca5\ud801\udca6\ud801\udca7\ud801\udca8\ud801\udca9",_type:"numeric"},rohg:{_digits:"\ud803\udd30\ud803\udd31\ud803\udd32\ud803\udd33\ud803\udd34\ud803\udd35\ud803\udd36\ud803\udd37\ud803\udd38\ud803\udd39",_type:"numeric"},roman:{_rules:"roman-upper",_type:"algorithmic"},romanlow:{_rules:"roman-lower",_type:"algorithmic"},saur:{_digits:"\ua8d0\ua8d1\ua8d2\ua8d3\ua8d4\ua8d5\ua8d6\ua8d7\ua8d8\ua8d9",_type:"numeric"},shrd:{_digits:"\ud804\uddd0\ud804\uddd1\ud804\uddd2\ud804\uddd3\ud804\uddd4\ud804\uddd5\ud804\uddd6\ud804\uddd7\ud804\uddd8\ud804\uddd9",_type:"numeric"},sind:{_digits:"\ud804\udef0\ud804\udef1\ud804\udef2\ud804\udef3\ud804\udef4\ud804\udef5\ud804\udef6\ud804\udef7\ud804\udef8\ud804\udef9",_type:"numeric"},sinh:{_digits:"\u0de6\u0de7\u0de8\u0de9\u0dea\u0deb\u0dec\u0ded\u0dee\u0def",_type:"numeric"},sora:{_digits:"\ud804\udcf0\ud804\udcf1\ud804\udcf2\ud804\udcf3\ud804\udcf4\ud804\udcf5\ud804\udcf6\ud804\udcf7\ud804\udcf8\ud804\udcf9",_type:"numeric"},sund:{_digits:"\u1bb0\u1bb1\u1bb2\u1bb3\u1bb4\u1bb5\u1bb6\u1bb7\u1bb8\u1bb9",_type:"numeric"},takr:{_digits:"\ud805\udec0\ud805\udec1\ud805\udec2\ud805\udec3\ud805\udec4\ud805\udec5\ud805\udec6\ud805\udec7\ud805\udec8\ud805\udec9",_type:"numeric"},talu:{_digits:"\u19d0\u19d1\u19d2\u19d3\u19d4\u19d5\u19d6\u19d7\u19d8\u19d9",_type:"numeric"},taml:{_rules:"tamil",_type:"algorithmic"},tamldec:{_digits:"\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef",_type:"numeric"},telu:{_digits:"\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f",_type:"numeric"},thai:{_digits:"\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59",_type:"numeric"},tibt:{_digits:"\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29",_type:"numeric"},tirh:{_digits:"\ud805\udcd0\ud805\udcd1\ud805\udcd2\ud805\udcd3\ud805\udcd4\ud805\udcd5\ud805\udcd6\ud805\udcd7\ud805\udcd8\ud805\udcd9",_type:"numeric"},vaii:{_digits:"\ua620\ua621\ua622\ua623\ua624\ua625\ua626\ua627\ua628\ua629",_type:"numeric"},wara:{_digits:"\ud806\udce0\ud806\udce1\ud806\udce2\ud806\udce3\ud806\udce4\ud806\udce5\ud806\udce6\ud806\udce7\ud806\udce8\ud806\udce9",_type:"numeric"},wcho:{_digits:"\ud838\udef0\ud838\udef1\ud838\udef2\ud838\udef3\ud838\udef4\ud838\udef5\ud838\udef6\ud838\udef7\ud838\udef8\ud838\udef9",_type:"numeric"}}}}},91331:function(t,e,n){e.default=void 0;var i=r(n(20476)),a=r(n(73806)),o=r(n(49198));function r(t){return t&&t.__esModule?t:{default:t}}var s,l=(0,i.default)({locale:(s="en",function(t){if(!t)return s;s=t}),getValueByClosestLocale:function(t){for(var e,n=this.locale(),i=t(n);!i&&!e;)(n=(0,o.default)(a.default,n))?i=t(n):e=!0;return void 0===i&&"en"!==n?t("en"):i}});e.default=l,t.exports=e.default,t.exports.default=e.default},89740:function(t,e,n){e.default=void 0;var i=n(13306),a={_formatNumberCore:function(t,e,n){if("currency"===e){n.precision=n.precision||0;var a=this.format(t,(0,i.extend)({},n,{type:"fixedpoint"})),o=this.getCurrencySymbol().symbol.replace(/\$/g,"$$$$");return a=a.replace(/^(\D*)(\d.*)/,"$1"+o+"$2")}return this.callBase.apply(this,arguments)},getCurrencySymbol:function(){return{symbol:"$"}},getOpenXmlCurrencyFormat:function(){return"$#,##0{0}_);\\($#,##0{0}\\)"}};e.default=a,t.exports=e.default,t.exports.default=e.default},91500:function(t,e,n){e.default=void 0;var i=g(n(20476)),a=n(35922),o=n(95479),r=g(n(17381)),s=n(40594),l=n(59937),c=n(2892),u=g(n(15564)),d=g(n(92286)),h=g(n(91331)),f=g(n(18016)),p=g(n(13024));function g(t){return t&&t.__esModule?t:{default:t}}var m="undefined"!=typeof Intl,_={shortdate:"M/d/y",shorttime:"h:mm a",longdate:"EEEE, MMMM d, y",longtime:"h:mm:ss a",monthandday:"MMMM d",monthandyear:"MMMM y",quarterandyear:"QQQ y",day:"d",year:"y",shortdateshorttime:"M/d/y, h:mm a",longdatelongtime:"EEEE, MMMM d, y, h:mm:ss a",month:"LLLL",shortyear:"yy",dayofweek:"EEEE",quarter:"QQQ",hour:"HH",minute:"mm",second:"ss",millisecond:"SSS","datetime-local":"yyyy-MM-ddTHH':'mm':'ss"},v={year:["y","yy","yyyy"],day:["d","dd"],month:["M","MM","MMM","MMMM"],hours:["H","HH","h","hh","ah"],minutes:["m","mm"],seconds:["s","ss"],milliseconds:["S","SS","SSS"]},b=(0,i.default)({engine:function(){return"base"},_getPatternByFormat:function(t){return _[t.toLowerCase()]},_expandPattern:function(t){return this._getPatternByFormat(t)||t},formatUsesMonthName:function(t){return-1!==this._expandPattern(t).indexOf("MMMM")},formatUsesDayName:function(t){return-1!==this._expandPattern(t).indexOf("EEEE")},getFormatParts:function(t){var e=this._getPatternByFormat(t)||t,n=[];return(0,o.each)(e.split(/\W+/),(function(t,e){(0,o.each)(v,(function(t,i){i.includes(e)&&n.push(t)}))})),n},getMonthNames:function(t){return u.default.getMonthNames(t)},getDayNames:function(t){return u.default.getDayNames(t)},getQuarterNames:function(t){return u.default.getQuarterNames(t)},getPeriodNames:function(t){return u.default.getPeriodNames(t)},getTimeSeparator:function(){return":"},is24HourFormat:function(t){for(var e=new Date(2017,0,20,11,0,0,0),n=new Date(2017,0,20,23,0,0,0),i=this.format(e,t),a=this.format(n,t),o=0;o<i.length;o++)if(i[o]!==a[o])return!isNaN(parseInt(i[o]))},format:function(t,e){if(t){if(!e)return t;var n;if("function"==typeof e)n=e;else if(e.formatter)n=e.formatter;else if(e=e.type||e,(0,a.isString)(e))return e=_[e.toLowerCase()]||e,f.default.convertDigits((0,s.getFormatter)(e,this)(t));if(n)return n(t)}},parse:function(t,e){var n,i,a=this;if(t){if(!e)return this.parse(t,"shortdate");if(e.parser)return e.parser(t);if("string"!=typeof e||_[e.toLowerCase()]){i=function(t){var n=a.format(t,e);return f.default.convertDigits(n,!0)};try{n=(0,l.getFormat)(i)}catch(t){}}else n=e;if(n)return t=f.default.convertDigits(t,!0),(0,c.getParser)(n,this)(t);r.default.log("W0012");var o=new Date(t);if(o&&!isNaN(o.getTime()))return o}},firstDayOfWeekIndex:function(){var t=h.default.getValueByClosestLocale((function(t){return d.default[t]}));return void 0===t?0:t}});m&&b.inject(p.default);var y=b;e.default=y,t.exports=e.default,t.exports.default=e.default},15564:function(t,e,n){e.default=void 0;var i=n(95479),a=["January","February","March","April","May","June","July","August","September","October","November","December"],o=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"],r=["AM","PM"],s=["Q1","Q2","Q3","Q4"],l=function(t,e){var n={abbreviated:3,short:2,narrow:1};return(0,i.map)(t,(function(t){return t.substr(0,n[e])}))},c={getMonthNames:function(t){return l(a,t)},getDayNames:function(t){return l(o,t)},getQuarterNames:function(t){return s},getPeriodNames:function(t){return r}};e.default=c,t.exports=e.default,t.exports.default=e.default},18121:function(t,e){e.defaultMessages=void 0;e.defaultMessages={en:{Yes:"Yes",No:"No",Cancel:"Cancel",Close:"Close",Clear:"Clear",Done:"Done",Loading:"Loading...",Select:"Select...",Search:"Search",Back:"Back",OK:"OK","dxCollectionWidget-noDataText":"No data to display","dxDropDownEditor-selectLabel":"Select","validation-required":"Required","validation-required-formatted":"{0} is required","validation-numeric":"Value must be a number","validation-numeric-formatted":"{0} must be a number","validation-range":"Value is out of range","validation-range-formatted":"{0} is out of range","validation-stringLength":"The length of the value is not correct","validation-stringLength-formatted":"The length of {0} is not correct","validation-custom":"Value is invalid","validation-custom-formatted":"{0} is invalid","validation-async":"Value is invalid","validation-async-formatted":"{0} is invalid","validation-compare":"Values do not match","validation-compare-formatted":"{0} does not match","validation-pattern":"Value does not match pattern","validation-pattern-formatted":"{0} does not match pattern","validation-email":"Email is invalid","validation-email-formatted":"{0} is invalid","validation-mask":"Value is invalid","dxLookup-searchPlaceholder":"Minimum character number: {0}","dxList-pullingDownText":"Pull down to refresh...","dxList-pulledDownText":"Release to refresh...","dxList-refreshingText":"Refreshing...","dxList-pageLoadingText":"Loading...","dxList-nextButtonText":"More","dxList-selectAll":"Select All","dxListEditDecorator-delete":"Delete","dxListEditDecorator-more":"More","dxScrollView-pullingDownText":"Pull down to refresh...","dxScrollView-pulledDownText":"Release to refresh...","dxScrollView-refreshingText":"Refreshing...","dxScrollView-reachBottomText":"Loading...","dxDateBox-simulatedDataPickerTitleTime":"Select time","dxDateBox-simulatedDataPickerTitleDate":"Select date","dxDateBox-simulatedDataPickerTitleDateTime":"Select date and time","dxDateBox-validation-datetime":"Value must be a date or time","dxDateRangeBox-invalidStartDateMessage":"Start value must be a date","dxDateRangeBox-invalidEndDateMessage":"End value must be a date","dxDateRangeBox-startDateOutOfRangeMessage":"Start date is out of range","dxDateRangeBox-endDateOutOfRangeMessage":"End date is out of range","dxDateRangeBox-startDateLabel":"Start Date","dxDateRangeBox-endDateLabel":"End Date","dxFileUploader-selectFile":"Select a file","dxFileUploader-dropFile":"or Drop a file here","dxFileUploader-bytes":"bytes","dxFileUploader-kb":"kb","dxFileUploader-Mb":"Mb","dxFileUploader-Gb":"Gb","dxFileUploader-upload":"Upload","dxFileUploader-uploaded":"Uploaded","dxFileUploader-readyToUpload":"Ready to upload","dxFileUploader-uploadAbortedMessage":"Upload cancelled","dxFileUploader-uploadFailedMessage":"Upload failed","dxFileUploader-invalidFileExtension":"File type is not allowed","dxFileUploader-invalidMaxFileSize":"File is too large","dxFileUploader-invalidMinFileSize":"File is too small","dxRangeSlider-ariaFrom":"From","dxRangeSlider-ariaTill":"Till","dxSwitch-switchedOnText":"ON","dxSwitch-switchedOffText":"OFF","dxForm-optionalMark":"optional","dxForm-requiredMessage":"{0} is required","dxNumberBox-invalidValueMessage":"Value must be a number","dxNumberBox-noDataText":"No data","dxDataGrid-emptyHeaderWithColumnChooserText":"Use {0} to display columns","dxDataGrid-emptyHeaderWithGroupPanelText":"Drag a column from the group panel here","dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText":"Use {0} or drag a column from the group panel","dxDataGrid-emptyHeaderColumnChooserText":"column chooser","dxDataGrid-columnChooserTitle":"Column Chooser","dxDataGrid-columnChooserEmptyText":"Drag a column here to hide it","dxDataGrid-groupContinuesMessage":"Continues on the next page","dxDataGrid-groupContinuedMessage":"Continued from the previous page","dxDataGrid-groupHeaderText":"Group by This Column","dxDataGrid-ungroupHeaderText":"Ungroup","dxDataGrid-ungroupAllText":"Ungroup All","dxDataGrid-editingEditRow":"Edit","dxDataGrid-editingSaveRowChanges":"Save","dxDataGrid-editingCancelRowChanges":"Cancel","dxDataGrid-editingDeleteRow":"Delete","dxDataGrid-editingUndeleteRow":"Undelete","dxDataGrid-editingConfirmDeleteMessage":"Are you sure you want to delete this record?","dxDataGrid-validationCancelChanges":"Cancel changes","dxDataGrid-groupPanelEmptyText":"Drag a column header here to group by that column","dxDataGrid-noDataText":"No data","dxDataGrid-searchPanelPlaceholder":"Search...","dxDataGrid-filterRowShowAllText":"(All)","dxDataGrid-filterRowResetOperationText":"Reset","dxDataGrid-filterRowOperationEquals":"Equals","dxDataGrid-filterRowOperationNotEquals":"Does not equal","dxDataGrid-filterRowOperationLess":"Less than","dxDataGrid-filterRowOperationLessOrEquals":"Less than or equal to","dxDataGrid-filterRowOperationGreater":"Greater than","dxDataGrid-filterRowOperationGreaterOrEquals":"Greater than or equal to","dxDataGrid-filterRowOperationStartsWith":"Starts with","dxDataGrid-filterRowOperationContains":"Contains","dxDataGrid-filterRowOperationNotContains":"Does not contain","dxDataGrid-filterRowOperationEndsWith":"Ends with","dxDataGrid-filterRowOperationBetween":"Between","dxDataGrid-filterRowOperationBetweenStartText":"Start","dxDataGrid-filterRowOperationBetweenEndText":"End","dxDataGrid-ariaSearchBox":"Search box","dxDataGrid-applyFilterText":"Apply filter","dxDataGrid-trueText":"true","dxDataGrid-falseText":"false","dxDataGrid-sortingAscendingText":"Sort Ascending","dxDataGrid-sortingDescendingText":"Sort Descending","dxDataGrid-sortingClearText":"Clear Sorting","dxDataGrid-editingSaveAllChanges":"Save changes","dxDataGrid-editingCancelAllChanges":"Discard changes","dxDataGrid-editingAddRow":"Add a row","dxDataGrid-summaryMin":"Min: {0}","dxDataGrid-summaryMinOtherColumn":"Min of {1} is {0}","dxDataGrid-summaryMax":"Max: {0}","dxDataGrid-summaryMaxOtherColumn":"Max of {1} is {0}","dxDataGrid-summaryAvg":"Avg: {0}","dxDataGrid-summaryAvgOtherColumn":"Avg of {1} is {0}","dxDataGrid-summarySum":"Sum: {0}","dxDataGrid-summarySumOtherColumn":"Sum of {1} is {0}","dxDataGrid-summaryCount":"Count: {0}","dxDataGrid-columnFixingFix":"Fix","dxDataGrid-columnFixingUnfix":"Unfix","dxDataGrid-columnFixingLeftPosition":"To the left","dxDataGrid-columnFixingRightPosition":"To the right","dxDataGrid-exportTo":"Export","dxDataGrid-exportToExcel":"Export to Excel file","dxDataGrid-exporting":"Exporting...","dxDataGrid-excelFormat":"Excel file","dxDataGrid-selectedRows":"Selected rows","dxDataGrid-exportSelectedRows":"Export selected rows to {0}","dxDataGrid-exportAll":"Export all data to {0}","dxDataGrid-headerFilterLabel":"Filter options","dxDataGrid-headerFilterIndicatorLabel":"Show filter options for column '{0}'","dxDataGrid-headerFilterEmptyValue":"(Blanks)","dxDataGrid-headerFilterOK":"OK","dxDataGrid-headerFilterCancel":"Cancel","dxDataGrid-ariaAdaptiveCollapse":"Hide additional data","dxDataGrid-ariaAdaptiveExpand":"Display additional data","dxDataGrid-ariaColumn":"Column","dxDataGrid-ariaValue":"Value","dxDataGrid-ariaFilterCell":"Filter cell","dxDataGrid-ariaCollapse":"Collapse","dxDataGrid-ariaExpand":"Expand","dxDataGrid-ariaDataGrid":"Data grid with {0} rows and {1} columns","dxDataGrid-ariaSearchInGrid":"Search in the data grid","dxDataGrid-ariaSelectAll":"Select all","dxDataGrid-ariaSelectRow":"Select row","dxDataGrid-ariaToolbar":"Data grid toolbar","dxDataGrid-ariaEditForm":"Edit form","dxDataGrid-filterBuilderPopupTitle":"Filter Builder","dxDataGrid-filterPanelCreateFilter":"Create Filter","dxDataGrid-filterPanelClearFilter":"Clear","dxDataGrid-filterPanelFilterEnabledHint":"Enable the filter","dxTreeList-ariaTreeList":"Tree list with {0} rows and {1} columns","dxTreeList-ariaSearchInGrid":"Search in the tree list","dxTreeList-ariaToolbar":"Tree list toolbar","dxTreeList-editingAddRowToNode":"Add","dxPager-infoText":"Page {0} of {1} ({2} items)","dxPager-pagesCountText":"of","dxPager-pageSize":"Items per page: {0}","dxPager-pageSizesAllText":"All","dxPager-page":"Page {0}","dxPager-prevPage":"Previous Page