/*

  -------------------.-.--------------------
  Orgchart BalkanChart Wrapper for INDE 23 for Fluid
                  06/05/2024
		OrgChart.VERSION="8.02.69"
  ------------------------------------------
  
*/
logOrgchartJsVersion = function(){
	console.log(
		"\n\n------------------------------------------------------------------------------------\n\n" 
		+ "Orgchart powered with Balkan OrgChartJS, version: " + OrgChart.VERSION 
		+ "\n\n------------------------------------------------------------------------------------\n\n"
	);
};


/*
	Client.Orgchart constructor
*/
Client.Orgchart = function (element, parent, view)
{
  let orgchart_ready_to_be_instanciated =  Client.Orgchart.inited && element.configuration && element.id;
  if(orgchart_ready_to_be_instanciated) {
    if (this.orgchart) {
    	this.orgchart.destroy();
    }

	logOrgchartJsVersion();
	      
    let configuration = element.configuration;
    let orgchartNodes = configuration.nodes;
	let enableSearch = configuration.enableSearch;
	let enableDragDrop = configuration.enableDragDrop;
	let assistantSeparation = configuration.assistantSeparation;
    this.indeFormIndex = configuration.indeFormIndex;

    let diagramDiv = document.createElement("div");
    diagramDiv.id = `diagram_${this.indeFormIndex}`;
	parent.appendChildObject(this, diagramDiv);

	this.id = element.id;
	this.domObj = diagramDiv;

	this.orgchart = new OrgChart(document.getElementById(diagramDiv.id), {
		enableSearch: enableSearch,
		enableDragDrop: enableDragDrop,    
		showXScroll: OrgChart.scroll.visible,
		showYScroll: OrgChart.scroll.visible,
		mouseScrool: OrgChart.action.zoom,
		assistantSeparation: assistantSeparation,
		toolbar: {
			zoom: true,
			fit: true,
		},
		
		template: "node",
		tags: {
			"assistant": {
				template: "assistant"
			}
		},
		nodeMenu: {
			openNodeDetails: {
				text: "Apri",
				icon: OrgChart.icon.details(20, 20, '#039BE5'),
				onClick: ((nodeId) => {
					Client.mainFrame.sendCommand("ORGCHART_COM", `content=
					{
						id:${this.indeFormIndex},
						message:"EditNode",
						content:
						{
							id: ${nodeId}
						}
					}`);
				})
			}, 
			addNodeRequest: {
				text: "Aggiungi elemento",
				icon: OrgChart.icon.add(20, 20, '#039BE5'),
				onClick: ((nodeId) => {
					Client.mainFrame.sendCommand("ORGCHART_COM", `content=
					{
						id:${this.indeFormIndex},
						message:"AddNodeRequest",
						content:
						{
							newNodeParentId: ${nodeId}
						}
					}`);
				})
			}, 
			addAssistantNodeRequest: {
				text: "Aggiungi assistente",
				icon: OrgChart.icon.add(20, 20, '#039BE5'),
				onClick: ((nodeId) => {
					Client.mainFrame.sendCommand("ORGCHART_COM", `content=
					{
						id:${this.indeFormIndex},
						message:"AddAssistantNodeRequest",
						content:
						{
							newNodeParentId: ${nodeId}
						}
					}`);
				})
			}, 
			removeNode: {
				text: "Elimina",
				icon: OrgChart.icon.remove(20, 20, '#039BE5'),
				onClick: ((nodeId) => {
					Client.mainFrame.sendCommand("ORGCHART_COM", `content=
					{
						id:${this.indeFormIndex},
						message:"DeleteNodeRequest",
						content:
						{
							id: ${nodeId}
						}
					}`);
				})
			},
		},
		nodeContextMenu: {
			
		},
		menu: { 
			svg: {
				text: "Esporta immagine"
			}
		},
		nodeBinding: {
			field_0: "concept",
			field_1: "name",
			field_2: "description",
			img_0: "img"
		},
		

	});

	
	this.orgchart.onNodeClick((data) => {
		Client.mainFrame.sendCommand("ORGCHART_COM", `content=
		{
			id:${this.indeFormIndex},
			message:"NodeClick",
			content:
			{
				id: ${data.node.id}, 
				childrenIds: [${data.node.childrenIds}]
			}
		}`); 
		return false;  
	});

	this.orgchart.onDrop((data) => {
		let dragId = data.dragId;
		let dropId = data.dropId;
		if(dragId>0 && dragId != dropId && dropId>0) {
			Client.mainFrame.sendCommand("ORGCHART_COM", `content=
			{
				id:${this.indeFormIndex},
				message:"ChangeNodeParent",
				content:
				{
					nodeId: ${dragId}, 
					newParent: ${dropId}
				}
			}`);
		}		
	});

	if(orgchartNodes && orgchartNodes.length > 0) {
		this.orgchart.load(orgchartNodes);
	}

    //this.attachEvents(element.events);   
  }
  else {
	Client.Orgchart.Realize = parent;
  }
};

Client.Orgchart.prototype = new Client.Element();

Client.Orgchart.getRequirements = function ()
{
	Client.Orgchart.inited = true;
	let req = {};
	req["assets/orgchartLib/templates/node.js"] = {type: "jc", name: "node.js"};
	req["assets/orgchartLib/templates/assistant.js"] = {type: "jc", name: "assistant.js"};
 	return req;
};

/*
	Handle form closure
*/
Client.Orgchart.prototype.close = function (firstLevel, triggerAnimation)
{
	if (this.orgchart) {
		delete this.orgchart;
		delete this.domObj;
	}
}

/*
	Handle Nodes operations
*/
Client.Orgchart.prototype.addNode = function (node) {
	this.orgchart.addNode(node);
}
Client.Orgchart.prototype.removeNode = function (id) {
	if(id !="" && id != null) {
		this.orgchart.removeNode(id);
	}
}
Client.Orgchart.prototype.updateNode = function (node) {
	if(node.id !="" && node.id != null) {
		this.orgchart.updateNode(node);
	}
}