// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe Book: Rappresenta un frame di tipo
// Book
// ************************************************

function Book(pform)
{
  // Chiamo il costruttore superiore
  WebFrame.call(this,pform);
  //
  // Proprieta' di questo oggetto di modello
  this.SelectedPage = 0;		          // La pagina selezionata nell'anteprima
  this.TotalPages = 0;                // Il numero totale di pagine del book
  this.TotalPagesConfirmed = false;   // Il numero totale di pagine e' quello definitivo?
  this.HideBorder = false;   					// Devo nascondere il bordo della pagina?
  this.WantDragHL = false;            // Vuole evidenziare il punto di drag delle box?
  this.WantDropRestore = true;        // Vuole ripristinare l'oggetto iniziale al momento del drop?
  this.EnabledCommands = -5;          // Maschera dei comandi abilitati (tutti tranne l'esportazione)
  this.CacheSize = 1;                 // Numero di pagine contemporaneamente presenti sul client
  this.FixedWidth = 0;                // Zona fissa a sinistra nelle pagine
  this.FixedHeight = 0;               // Zona fissa in alto nelle pagine
  //
  this.ScrollOrientation = 0;         // 0=orizzontale, 1=verticale
  this.SnapToPage = true;         		// true/false
  this.OptimizeDOM = false;	         	// se true organizza scrolling stile iBook
  //
  // Oggetti secondari gestiti da questo oggetto di modello
  this.Pages = new Array();        // Lista delle pagine dell'anteprima
  this.PlaceHolders = new Array(); // Lista dei placeholders al posto delle pagine
  this.MobilePageContainer = null; // Contenitore delle pagine che viene scrollato in caso mobile
  this.RefreshMobileContainer= true; // Indica se devo aggiornare il container visuale
  this.ForceSetPage = false; 				 // Indica se devo forzare l'aggiornamento della pagina nel container mobile
  //
  // Variabili per la gestione delle animazioni
  this.AnimatingNum = null;   // Numero della pagina che sto attualmente animando (null se non c'e' nessuna animazione in corso)
  this.ActivePage = 0;        // Numero della pagina attualmente selzionata nell'anteprima (durante l'animazione e' diversa da SelectedPage)
  this.Fx = null;             // Animazione in corso
  //
  // Struttura per la definizione degli eventi di questo pannello
  this.ToolbarEventDef = RD3_Glb.EVENT_ACTIVE;
  //
  // Oggetti visuali relativi alla Toolbar
  this.StatusBarTxt = null;              // Span contenitore della status bar
  this.ToolbarNav = null;             // Span contenitore delle immagini della toolbar di navigazione
  this.NextImg = null;                // Immagine avanti di una pagina
  this.PrevImg = null;                // Immagine indietro di una pagina
  this.BeginImg = null;               // Immagine Vai all'inizio
  this.EndImg = null;                 // Immagine Vai alla fine
  this.PrintImg = null;               // Immagine Stampa
  this.ExportImg = null;              // Immagine Esporta
  this.ToolbarSeparator1 = null;      // Separatore tra il nome del book ed i comandi di navigazione
  this.ToolbarSeparator2 = null;      // Separattore tra i comandi di navigazione ed il pulsante stampa
}
//
// Definisco l'estensione della classe
Book.prototype = new WebFrame();


// *******************************************************************
// Inizializza questo Tree leggendo i dati da un nodo <wfr> XML
// *******************************************************************
Book.prototype.LoadFromXml = function(node) 
{
  // Chiamo la classe base
  WebFrame.prototype.LoadFromXml.call(this,node);
  //
  // Carico nodi dell'albero
  //
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i=0; i<n; i++) 
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    //
    // In base al tipo di oggetto, invio il messaggio di caricamento
    switch (nome)
    {
      case "pag":
      {
        // Leggo il nodo di primo livello, e poi passo il messaggio di caricamento
        // Attenzione: e' la Page che si infila nel punto giusto dell'array Pages
        var newnode = new BookPage(this);
        newnode.LoadFromXml(objnode);
      }
      break;
    }
  }    
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
Book.prototype.LoadProperties = function(node)
{
  // Chiamo la classe base
  WebFrame.prototype.LoadProperties.call(this,node);
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "pag": this.SetSelectedPage(parseInt(valore)); break;
      case "ptt": this.SetTotalPages(parseInt(valore)); break;
      case "pcf": this.SetTotalPagesConfirmed(valore=="1"); break;
      case "hib": this.SetHideBorder(valore=="1"); break;
      case "enc": this.SetEnabledCommands(parseInt(valore)); break;
      case "dgp": this.DeletePage(parseInt(valore)); break;
      case "csz": this.SetCacheSize(parseInt(valore)); break;
      case "fiw": this.SetFixedWidth(parseInt(valore)); break;
      case "fih": this.SetFixedHeight(parseInt(valore)); break;
      case "scd": this.SetScrollDir(parseInt(valore)); break;
      case "fsn": this.SetForceSnap(valore=="1"); break;
      case "opt": this.SetOptimizeDOM(valore=="1"); break;
      
      case "tck": this.ToolbarEventDef = parseInt(valore); break;
      
      case "cpa": this.ChangePageAnimDef = valore; break;
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
Book.prototype.ChangeProperties = function(node)
{
  // Vediamo se nel nodo di cambiamento sono indicati anche nodi figli...
  var objlist = node.childNodes;
  //
  // In IE il primo nodo e' gia' l'elemento, negli altri il primo nodo e' un "\n"
  var pag = RD3_Glb.HasNode(node, "pag");
  //
  if (objlist.length>0 && pag)
  {
    // In questo caso elimino i figli miei e poi carico gli altri
    this.LoadFromXml(node);
    //
    // Realizzo le nuove pagine arrivate
    var reshow = false;
    if (RD3_Glb.IsFirefox(3) && this.Realized && this.ContentBox.style.display!="none")
    {
      // Spengo per un attimo il content box cosi' FFX non sfarfalla
      this.ContentBox.style.display = "none";
      reshow = true;
    }
    //
    if (this.Realized)
      this.Realize(null);
    //
    // Mostro (di nuovo?) la pagina selezionata
    this.SetSelectedPage(this.SelectedPage);
    //
    // Cambio la status bar del book
    this.SetCaption();
    //
    if (reshow && this.Realized)
      this.ContentBox.style.display = "";
  }
  else
  {
    // Normale cambio di proprieta'
    this.LoadProperties(node);
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
Book.prototype.SetSelectedPage= function(value) 
{
	var old = this.SelectedPage;
  if (value!=undefined)
    this.SelectedPage = value;
  //
  if (this.Realized)
  {
    // Cerco la pagina attualmente selezionata e quella da selezionare
    var oldp = null;
    var newp = null;
    if (old!=this.SelectedPage)
    {
    	this.RefreshMobileContainer = true;
    	this.ForceSetPage = true;
    }
    //
    if (!RD3_Glb.IsMobile())
    {
	    var n = this.Pages.length;
	    for (var i=0; i<n; i++)
	    {
	      var p = this.Pages[i];
	      if (p)
	      {
	        // Se la pagina e' quella da selezionare me la memorizzo per fare l'animazione
	        if (p.Number == this.SelectedPage)
	        {  
	          newp = p;
	          //
	          if (p.Number == this.ActivePage)
	            oldp = p;
	        } 
	        else
	        {
	          // Se e' la pagina attualmente attiva me la memorizzo per fare l'animazione, altrimenti la disattivo per sicurezza
	          if (p.Number == this.ActivePage)
	            oldp = p;
	          else
	            p.SetActive(false);
	        }  
	      }
	    }
	    //
	    // Faccio l'animazione se devo cambiare veramente pagina (e ho una pagina nuova da mostrare..)
	    if (oldp != newp && newp)
	    {
	      // Decido la direzione dello spostamento true ingresso da sinistra, false ingresso da destra
	      var side = true;
	      if (oldp)
	      {
	        side = (oldp.Number >= newp.Number);
	      }  
	      //
	      // Se non ho una animazione in corso oppure se sto animando la pagina sbagliata eseguo la nuova animazione
	      if (!this.AnimatingNum || this.AnimatingNum != newp.Number)
	      {
	        this.Fx = new GFX("book", side, newp, value==undefined, oldp, this.ChangePageAnimDef);
	        RD3_GFXManager.AddEffect(this.Fx);
	        //
	        // Se l'animazione e' skippata va subito al Finish e annulla Fx e AnimatingNum, quindi in quel caso non devo
	        // impostare AnimatingNum, altrimenti dopo ci sara' un errore Javascript perche' c'e' AnimatingNum e non Fx
	        if (this.Fx)
	          this.AnimatingNum = newp.Number;
	      }
	    }
	    else if (this.SelectedPage==0 && oldp)
	    {
	      // Devo passare da una pagina a nessuna pagina
	      if (!this.AnimatingNum || this.AnimatingNum != 0)
	      {
	        this.Fx = new GFX("book", true, null, value==undefined, oldp, this.ChangePageAnimDef);
	        RD3_GFXManager.AddEffect(this.Fx);
	        //
	        // Se l'animazione e' skippata va subito al Finish e annulla Fx e AnimatingNum, quindi in quel caso non devo
	        // impostare AnimatingNum, altrimenti dopo ci sara' un errore Javascript perche' c'e' AnimatingNum e non Fx
	        if (this.Fx)
	          this.AnimatingNum = 0;
	      }
	    }
	  }
  }
}

Book.prototype.SetTotalPages= function(value) 
{
	var old = this.TotalPages;
  if (value!=undefined)
    this.TotalPages = value;
  //
  if (this.Realized)
  {
  	if (old!=this.TotalPages && value!=undefined)
  		this.RefreshMobileContainer = true;
    //
    // Se stavo mostrando una pagina e non ci sono pi pagine, vado in pagina 0
    if (old!=this.TotalPages && this.SelectedPage && this.TotalPages == 0)
      this.SetSelectedPage(0);
  	//
    this.SetCaption();
  }
}

Book.prototype.SetTotalPagesConfirmed= function(value) 
{
	var old = this.TotalPagesConfirmed;
  if (value!=undefined)
    this.TotalPagesConfirmed = value;
  //
  if (this.Realized)
  {
  	if (old!=this.TotalPagesConfirmed && value!=undefined)
  		this.RefreshMobileContainer = true;
  	//
    this.SetCaption();
  }
}

Book.prototype.SetScrollDir= function(value) 
{
	var old = this.ScrollOrientation;
  if (value!=undefined)
    this.ScrollOrientation = value;
  //
  if (this.Realized)
  {
  	if (old!=this.ScrollOrientation && value!=undefined)
  		this.RefreshMobileContainer = true;
  }
}

Book.prototype.SetForceSnap= function(value) 
{
	var old = this.SnapToPage;
  if (value!=undefined)
    this.SnapToPage = value;
  //
  if (this.Realized)
  {
  	if (old!=this.SnapToPage && value!=undefined)
  		this.RefreshMobileContainer = true;
  }
}

Book.prototype.SetOptimizeDOM= function(value) 
{
	var old = this.OptimizeDOM;
  if (value!=undefined)
    this.OptimizeDOM = value;
  //
  if (this.Realized)
  {
  	if (old!=this.OptimizeDOM && value!=undefined)
  		this.RefreshMobileContainer = true;
  }
}


Book.prototype.SetHideBorder= function(value) 
{
  if (value!=undefined)
    this.HideBorder = value;
}

Book.prototype.SetEnabledCommands = function(value)
{
  if (value!=undefined)
    this.EnabledCommands = value; 
  //
  if (this.Realized)
  {
    this.UpdateToolbar();
  }
}

Book.prototype.SetCacheSize = function(value)
{
  if (value!=undefined)
    this.CacheSize = value; 
}

Book.prototype.SetFixedWidth = function(value)
{
  var old = this.FixedWidth;
  if (value!=undefined)
    this.FixedWidth = value;
  //
  if (old != this.FixedWidth)
    this.UpdateFixed = true;
}

Book.prototype.SetFixedHeight = function(value)
{
  var old = this.FixedHeight;
  if (value!=undefined)
    this.FixedHeight = value; 
  //
  if (old != this.FixedHeight)
    this.UpdateFixed = true;
}

// ***************************************************************
// Elimina una particolare pagina dall'elenco delle pagine presenti nel client
// ***************************************************************
Book.prototype.DeletePage = function(value)
{
  var p = this.Pages[value];
  if (p)
    p.Unrealize();
}

// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
Book.prototype.Realize = function(parent)
{
  var realizing = this.Realized;
  //
  // Chiamo la classe base
  if (!this.Realized)
    WebFrame.prototype.Realize.call(this,parent);
  //
  // Aggiungo una classe in modo da rendere position:relative (così i miei figli possono prendere position absolute senza problemi)
  RD3_Glb.AddClass(this.ContentBox, "book-frame-container");  
  //
  //if (!realizing)
  	//this.UpdateMobileContainer();
  //
  // Ora realizzo tutte le pagine non ancora realizzate pagina selezionata
  var n = this.Pages.length;
  for (var i=0; i<n; i++)
  {
    if (this.Pages[i])
    {
      this.Pages[i].Realize(this.MobilePageContainer?this.MobilePageContainer:this.ContentBox);
      //
      // Attivo le pagine solo durante la realizzazione iniziale: negli altri casi passo dalla SetSelectedPage con Realized = true
      if (!realizing)
        this.Pages[i].SetActive(this.Pages[i].Number == this.SelectedPage);
    }
  }
  //
  this.UpdateToolbar();
  this.UpdateFixedZones();
}


// ********************************************************************************
// Calcola le dimensioni dei div in base alla dimensione del contenuto
// ********************************************************************************
Book.prototype.AdaptLayout = function()
{ 
  // Se non sono realizzato non faccio nulla (es: potrei essere in una tab non ancora mostrata)
  if (!this.Realized)
    return;
  //
  // Faccio questo per eliminare eventuali scrollbar messe dai browser..
  var ov = this.ContentBox.style.overflow;
  this.ContentBox.style.overflow = "hidden";
  //
  // Chiamo la classe base
  WebFrame.prototype.AdaptLayout.call(this);
  //
  // Giro il messaggio alle pagine
  var n = this.Pages.length;
  for (var i=0; i<n; i++)
  {
    if (this.Pages[i])
      this.Pages[i].AdaptLayout();
  }
  //
  // Rimetto lo stile corretto, adesso che le dimensioni sono giuste sta al browser decidere se mettere o meno le scrollbar
  this.ContentBox.style.overflow = ov;
  //
  this.RefreshMobileContainer = true;
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
Book.prototype.AfterProcessResponse= function()
{ 
  // Chiamo la classe base che esegue un recalc layout se richiesto
  WebFrame.prototype.AfterProcessResponse.call(this);
  //
  // Giro il messaggio alle pagine
  var n = this.Pages.length;
  for (var i=0; i<n; i++)
  {
    if (this.Pages[i])
      this.Pages[i].AfterProcessResponse();
  }
  //
  if (this.RefreshMobileContainer)
  {
  	this.UpdateMobileContainer();
  	//
  	// Se devo ricalcolare il layout a causa dell'apparizione di una pagina, lo faccio subito
    if (this.RecalcLayout)
    {
  	  this.RecalcLayout = false;
      this.AdaptLayout();
      //
      // l'ho appena fatto!
      this.RefreshMobileContainer = false; 
  	}
  }
  //
  // Se devo aggiornare la zona fissa, lo faccio
  if (this.UpdateFixed)
  {
    this.UpdateFixed = false;
    this.UpdateFixedZones();
  }
}


//***************************************************************
// Metodi della classe base ridefiniti
//***************************************************************

// ***************************************************************
// Crea gli oggetti DOM relativi alla Toolbar
// ***************************************************************
Book.prototype.RealizeToolbar = function()
{
  // Chiamo il metodo base
  WebFrame.prototype.RealizeToolbar.call(this);
  //
  // Creo gli oggetti Dom Specifici di questa Toolbar
  this.StatusBarTxt = document.createElement("span");
  //
  this.ToolbarNav = document.createElement("div");
  this.ToolbarNav.className = "btn-group";
  this.ToolbarCommandGroup = document.createElement("div");
  this.ToolbarCommandGroup.className = "btn-group";
  //
  this.NextImg = document.createElement("button");
  this.NextImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_NEXT));
  this.PrevImg = document.createElement("button");
  this.PrevImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PREV));
  this.BeginImg = document.createElement("button");
  this.BeginImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_TOP));
  this.EndImg = document.createElement("button");
  this.EndImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_BOTTOM));
  //
  this.PrintImg = document.createElement("button");
  this.PrintImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_PRINT));
  this.ExportImg = document.createElement("button");
  this.ExportImg.appendChild(RD3_Glb.createFAImage(RD3_ClientParams.FA_ICON_EXPORT));
	//  
  this.BeginImg.setAttribute("id", this.Identifier+":top");
  this.PrevImg.setAttribute("id", this.Identifier+":next");
  this.NextImg.setAttribute("id", this.Identifier+":prev");
  this.EndImg.setAttribute("id", this.Identifier+":bottom");
  this.ExportImg.setAttribute("id", this.Identifier+":print");
  //
  // Imposto le classi
  this.StatusBarTxt.className = (this.SmallIcons) ? "book-toolbarsmall-status" : "book-toolbar-status";
  this.NextImg.className = "btn btn-default";
  this.PrevImg.className = "btn btn-default";
  this.BeginImg.className = "btn btn-default";
  this.EndImg.className = "btn btn-default";
  this.PrintImg.className = "btn btn-default";
  this.ExportImg.className = "btn btn-default";
  //
  // Assegno i Tooltip RTC
  RD3_TooltipManager.SetObjTitle(this.NextImg, RD3_ServerParams.BookPaginaSucc);
  RD3_TooltipManager.SetObjTitle(this.PrevImg, RD3_ServerParams.BookPaginaPrec);
  RD3_TooltipManager.SetObjTitle(this.BeginImg, RD3_ServerParams.BookInizio);
  RD3_TooltipManager.SetObjTitle(this.EndImg, RD3_ServerParams.BookFine);
  RD3_TooltipManager.SetObjTitle(this.PrintImg, RD3_ServerParams.CreatePDF);
  RD3_TooltipManager.SetObjTitle(this.ExportImg, RD3_ServerParams.TooltipExport);
  //
  // Imposto la gestione dei vari click
  var _this = this;
  this.NextImg.onclick = function (ev) { _this.OnToolbarClick(ev, "next"); };
  this.PrevImg.onclick = function (ev) { _this.OnToolbarClick(ev, "prev"); };
  this.BeginImg.onclick = function (ev) { _this.OnToolbarClick(ev, "top"); };
  this.EndImg.onclick = function (ev) { _this.OnToolbarClick(ev, "bottom"); };
  this.PrintImg.onclick = function (ev) { _this.OnToolbarClick(ev, "print"); };
  this.ExportImg.onclick = function (ev) { _this.OnToolbarClick(ev, "csv"); };
  //
  // Aggiungo gli elementi al DOM
  this.ToolbarBox.appendChild(this.StatusBarTxt);
  this.ToolbarBox.appendChild(this.ToolbarNav);
  this.ToolbarBox.appendChild(this.ToolbarCommandGroup);
  //
  this.ToolbarNav.appendChild(this.BeginImg);
  this.ToolbarNav.appendChild(this.PrevImg);
  this.ToolbarNav.appendChild(this.NextImg);
  this.ToolbarNav.appendChild(this.EndImg);
  //
  this.ToolbarCommandGroup.appendChild(this.PrintImg);
  this.ToolbarCommandGroup.appendChild(this.ExportImg);
}

Book.prototype.SetCaption= function(value) 
{
  if (value!=undefined)
    this.Caption = value;
  //
  if (this.Realized && !this.OnlyContent)
  {
    var captxt = RD3_Glb.FormatMessage(RD3_ServerParams.PaginaNM, this.SelectedPage, this.TotalPages)+(this.TotalPagesConfirmed ? "" : "+");
    this.CaptionTxt.innerHTML = RD3_Glb.HandleIconString(this.Caption);
    this.StatusBarTxt.innerHTML = (this.Caption != "" && this.Caption != " " ? ": " : "") + captxt;       
  }
}


Book.prototype.SetCollapsed = function(value, immediate) 
{
  // Chiamo la classe base
  WebFrame.prototype.SetCollapsed.call(this, value);
}

Book.prototype.SetShowToolbar = function(value) 
{
  // Chiamo la classe base
  WebFrame.prototype.SetShowToolbar.call(this, value);
  //
  if (this.Realized)
  {
    this.UpdateToolbar();
  }
}

Book.prototype.SetShowStatusBar = function(value) 
{
  // Chiamo la classe base
  WebFrame.prototype.SetShowStatusBar.call(this, value);
  //
  if (this.Realized)
  {
    var sh = !this.Collapsed && this.ShowStatusBar;
    this.StatusBarTxt.style.display = sh ? "" : "none";
  }
}

//***************************************************
// Fine ridefinizione funzioni
//***************************************************


// ********************************************************************************
// Mostra o nasconde i pulsanti della toolbar a seconda dello stato
// ********************************************************************************
Book.prototype.UpdateToolbar = function() 
{
  this.ToolbarNav.style.display = this.IsCommandEnabled(RD3_Glb.BCM_NAVIGATION) ? "" : "none";
  //
  if (this.IsCommandEnabled(RD3_Glb.BCM_PRINT)) {
    if (!this.PrintImg.parentNode)
      if (!this.ToolbarCommandGroup.firstChild)
        this.ToolbarCommandGroup.appendChild(this.PrintImg);
      else 
        this.ToolbarCommandGroup.insertBefore(this.PrintImg, this.ToolbarCommandGroup.firstChild);
  }
  else if (this.PrintImg.parentNode)
    this.PrintImg.parentNode.removeChild(this.PrintImg);
  //
  if (this.IsCommandEnabled(RD3_Glb.BCM_CSV)) {
    if (!this.ExportImg.parentNode)
        this.ToolbarCommandGroup.appendChild(this.ExportImg);
  }
  else if (this.ExportImg.parentNode)
    this.ExportImg.parentNode.removeChild(this.ExportImg);
}


// ****************************************************************
// Torna TRUE se il comando e' abilitato
// ****************************************************************
Book.prototype.IsCommandEnabled = function(cmd)
{
  return (this.EnabledCommands & cmd) && this.ShowToolbar && !this.Collapsed;
}



// ********************************************************************************
// Gestore evento di click su un pulsante della Toolbar
// button: 'next', 'prev', 'top', 'bottom', 'print'
// ********************************************************************************
Book.prototype.OnToolbarClick= function(evento, button, pag)
{
  var evt = this.ToolbarEventDef;
  //
  // Calcolo la pagina a cui devo andare e verifico se ce l'ho gia' in cache
  var vai = false;
  var selpg = this.SelectedPage;
  switch (button)
  {
    case "next": selpg += 1; break;
    case "prev": selpg -= 1; break;
    case "top":  selpg = 1;  break;
    case "bottom": selpg = (this.TotalPagesConfirmed? this.TotalPages : -1 ); break;
    case "goto":  selpg = pag;  break;
  }
  //
  if (this.TotalPagesConfirmed && selpg>this.TotalPages)
    selpg = this.TotalPages;
  //
  // Decido se operare lato client (no in caso di esportazione)
  if (selpg > 0 && this.Pages[selpg] && button != "csv")
    vai = true;
  //
  // Se non ho la pagina in cache mando l'evento immediatamente
  if (!vai || this.CacheSize != 1)
    evt |= RD3_Glb.EVENT_IMMEDIATE;
  var ev = new IDEvent("booktb", this.Identifier, evento, evt, button, pag);
  //
  // Se l'evento puo' essere gestito lato client e ho la pagina in cache la mostro
  if (ev.ClientSide== 1 && vai && selpg!=this.SelectedPage) {
    this.SetSelectedPage(selpg);
    //
    // Cambio la status bar del book
    this.SetCaption();  
  }
}


// **********************************************************************
// Metodo che svuota la cache delle pagine
// **********************************************************************
Book.prototype.ResetCache = function(ev, node)
{
  // Elimino dalla cache tutte le pagine non visibili... 
  // Tengo quella attualmente visibile cosi' posso lavorare in differenziale
  var from = (this.CacheSize == 1 ? 0 : parseInt(node.getAttribute("from")));
  var to = (this.CacheSize == 1 ? 0 : parseInt(node.getAttribute("to")));
  var n = this.Pages.length;
  for (var i = 0; i<n; i++)
  {
    var p = this.Pages[i];
    if (!p)
      continue;
    //
    // Single-page: elimino tutte le pagine tranne quella attiva
    if (this.CacheSize == 1 || from == 0 || to == 0)
    {
      if (p.Number != this.SelectedPage)
        p.Unrealize();
    }
    else
    {
      // Multi-page: elimino tutte le pagine fuori dall'intervallo comunicato dal server
      if (p.Number < from || p.Number > to)
        p.Unrealize();
    }
  }
  //
  // Dovro' ricalcolare il layout!
  this.RecalcLayout = true;
}


// ********************************************************************************
// Toglie gli elementi visuali dal DOM perche' questo oggetto sta per essere
// distrutto
// ********************************************************************************
Book.prototype.Unrealize = function()
{ 
  // Chiamo la classe base
  WebFrame.prototype.Unrealize.call(this);
  //
  // Tolgo tutte le pagine
  var n = this.Pages.length;
  for (var i = 0; i<n; i++)
  {
    var p = this.Pages[i];
    if (p)
      p.Unrealize();
  }
}


// ********************************************************************************
// Gestore eventi di mouse su un pulsante della Toolbar di pannello
// Il parametro deve valere "" per bottone senza effetti, "hover" per highlight
// e "down" per effetto cliccato
// ********************************************************************************
Book.prototype.OnToolMouseUse = function(evento, parametro)
{ 
  
}


// ********************************************************************************
// Il resize deve essere mandato immediatamente al server?
// ********************************************************************************
Book.prototype.IsResizeImmediate = function()
{
  // Devo ottenere immediatamente la nuova immagine del grafico...
  return true; 
}

// ********************************************************************************
// Gestisce l'aumento della larghezza/altezza di box e sezioni quando i loro figli
// hanno bordo e loro no
// ********************************************************************************
Book.prototype.ParGrowWidth = function(obj, absRight, brdw)
{
  while (obj)
  {
    var robrd = obj.VisStyle.GetBookOffset(true);
    //
    // Se ha un suo bordo... non devo fare altro! Ci avra' gia' pensato lui ai suoi padri
    if (robrd.w!=0)
      return;
    //
    // Se il suo bordo right e' inferiore a quello fornito... da ora in poi non mi
    // interessa piu'... i suoi figli saranno sicuramente lontani dal bordo right!
    if (obj.XAbsPx+obj.WPx<absRight)
      return;
    //
    // Se gli e' gia' stato detto... ho finito. Ci avra' gia' pensato qualcun altro
    if (obj.StretchW>=brdw)
      return;
    //
    // Lui si deve allargare!
    obj.StretchW = Math.max((!obj.StretchW ? 0 : obj.StretchW), brdw);
    //
    // Risalgo: se obj e' una sezione, suo padre e' una box, se obj e' una box, suo padre e' una sezione
    if (obj instanceof BookSection)
      obj = obj.MastroBox;
    else
      obj = obj.ParentSect;
  }
}
Book.prototype.ParGrowHeight = function(obj, absBottom, brdh)
{
  while (obj)
  {
    var robrd = obj.VisStyle.GetBookOffset(true);
    //
    // Se ha un suo bordo... non devo fare altro! Ci avra' gia' pensato lui ai suoi padri
    if (robrd.h!=0)
      return;
    //
    // Se il suo bordo bottom e' inferiore a quello fornito... da ora in poi non mi
    // interessa piu'... i suoi figli saranno sicuramente lontani dal bordo bottom!
    if (obj.YAbsPx+obj.HPx<absBottom)
      return;
    //
    // Se gli e' gia' stato detto... ho finito. Ci avra' gia' pensato qualcun altro
    if (obj.StretchH>=brdh)
      return;
    //
    // Si deve allargare!
    obj.StretchH = Math.max((!obj.StretchH ? 0 : obj.StretchH), brdh);
    //
    // Risalgo: se obj e' una sezione, suo padre e' una box, se obj e' una box, suo padre e' una sezione
    if (obj instanceof BookSection)
      obj = obj.MastroBox;
    else
      obj = obj.ParentSect;
  }
}


// *********************************************************
// E' arrivato un click a livello di frame
// *********************************************************
Book.prototype.OnFrameClick = function(evento, dbl, btn, x, y, xb, yb, tget)
{
  // Risalgo alla DIV della box
  while (tget && tget.tagName!="DIV")
    tget = tget.parentNode;
  //
  // Se non ho trovato un oggetto valido, non faccio altro
  if (!tget)
    return;
  //
  // calcolo box alla quale e' avvenuto il click
  var id = RD3_Glb.GetRD3ObjectId(tget);
  //
  // Prendiamo l'oggetto vero
  var obj = RD3_DesktopManager.ObjectMap[id];
  var box = obj;
  //
  // Cliccata sezione? vediamo se e' trasparente!
  if (obj && obj instanceof BookSection)
  {
    // Sezione trasparente, risalgo alla box
    if (obj.SectionBox.style.backgroundColor=="transparent")
    {
      if (obj.ParentBox)
      {
        id = obj.ParentBox.Identifier;
        box = obj.ParentBox;
      }
      else
      {
        id = obj.MastroBox.Identifier;
        box = obj.MastroBox;
      }
    }
  }
  //
  // Convertiamo le coordinate rispetto alla box nella UM del book
  if (box instanceof BookBox)
  {
    x = xb - RD3_Glb.GetScreenLeft(box.BoxBox);
    y = yb - RD3_Glb.GetScreenTop(box.BoxBox);  
    var r = new Rect(x,y,0,0);
    box.AdaptCoords(r);
    x = r.x;
    y = r.y;
  }
  //
  var ev = new IDEvent("rawclk", this.Identifier, evento, dbl?this.MouseDoubleClickEventDef:this.MouseClickEventDef, dbl, btn, Math.floor(xb)+"-"+Math.floor(yb), Math.floor(x)+"-"+Math.floor(y), id);
}

// *********************************************************
// Imposta il tooltip
// *********************************************************
Book.prototype.GetTooltip = function(tip, obj)
{
  // Ora guardiamo se e' un bottone della tooltbar di pannello
  var ok = false;
  if (obj == this.BeginImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_BookInizio);
    tip.SetText(RD3_ServerParams.BookInizio);
    ok = true;
  }
  else if (obj == this.PrevImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_BookPaginaPrec);
    tip.SetText(RD3_ServerParams.BookPaginaPrec);
    ok = true;
  }
  else if (obj == this.NextImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_BookPaginaSucc);
    tip.SetText(RD3_ServerParams.BookPaginaSucc);
    ok = true;
  }
  else if (obj == this.EndImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_BookFine);
    tip.SetText(RD3_ServerParams.BookFine);
    ok = true;
  }
  else if (obj == this.PrintImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_CreatePDF);
    tip.SetText(RD3_ServerParams.CreatePDF);
    ok = true;
  }
  else if (obj == this.ExportImg)
  {
    tip.SetTitle(ClientMessages.TIP_TITLE_TooltipExport);
    tip.SetText(RD3_ServerParams.TooltipExport);
    ok = true;
  }
  //
  if (ok)
  {
    // Di default i bottoni di book mostrano il tooltip centrato sopra di essi
    tip.SetAnchor(RD3_Glb.GetScreenLeft(obj) + ((obj.offsetWidth-4)/2), RD3_Glb.GetScreenTop(obj));
    tip.SetPosition(0);
    return true;
  }
  else
    return WebFrame.prototype.GetTooltip.call(this, tip, obj);
}


// ********************************************************************************
// Compone la lista di drop della pagina
// ********************************************************************************
Book.prototype.ComputeDropList = function(list, dragobj)
{
  // Se non sono stato realizzato o non ho pagine... niente DropList
  if (!this.Realized || this.Pages.length == 0)
    return;
  //
  this.Pages[this.ActivePage].ComputeDropList(list, dragobj);
}


// ********************************************************************************
// Evento di inizio tocco sul book
// ********************************************************************************
Book.prototype.OnTouchStart = function(e)
{ 
  
}


// ********************************************************************************
// Evento di movimento del ditino sul pannello
// ********************************************************************************
Book.prototype.OnTouchMove = function(e)
{ 
  
}


// ********************************************************************************
// Evento di movimento del ditino sul pannello
// ********************************************************************************
Book.prototype.OnTouchEnd = function(e)
{ 
  
}


// ********************************************************************************
// Gestisce lo scroll via touch del pannello.
// v e' la velocita' di scroll in ms, il segno indica la direzione
// n e' il numero di volte che e' stata eseguita la funzione
// ********************************************************************************
Book.prototype.TouchScrollTimer = function(dummy, ap)
{ 
  
}


// ********************************************************************************
// Annulla timer di scroll
// ********************************************************************************
Book.prototype.ClearTouchScrollTimer = function()
{
  
}


// ********************************************************************************
// Gestisce evento di touch
// ********************************************************************************
Book.prototype.HandleTouchEvent = function(e, evtype)
{
  
}


// ********************************************************************************
// Aggiorna il box che si occupa di contenere e scrollare le pagine nel caso mobile
// ********************************************************************************
Book.prototype.UpdateMobileContainer = function()
{ 
  
}


// ********************************************************************************
// Mostra la pagina indicata
// ********************************************************************************
Book.prototype.OnScrollToPage = function(ev, d, pag)
{ 
	if (pag!=this.SelectedPage)
	{
		this.OnToolbarClick(ev, "goto", pag);
	}
}

// ********************************************************************************
// Aggiorna le zone fisse
// ********************************************************************************
Book.prototype.UpdateFixedZones = function()
{
  // Controllo tutte le pagine
  var n = this.Pages.length;
  for (var i=0; i<n; i++)
  {
    var p = this.Pages[i];
    if (p)
      p.UpdateFixedZones();
  }
  //
  // Attacco l'evento per gestire le zone fisse
  this.ContentBox.onscroll = new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Identifier+"', 'OnScroll', ev)");        
}

// ********************************************************************************
// Scroll della pagina: se ci sono zone fisse avviso la pagina
// ********************************************************************************
Book.prototype.OnScroll = function(ev)
{
  if (this.Pages[this.SelectedPage])
    this.Pages[this.SelectedPage].OnScroll(ev);
}
