/*!
* DevExtreme (dx.messages.ro.js)
* Version: 23.1.6
* Build date: Fri Oct 13 2023
*
* Copyright (c) 2012 - 2023 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        ro: {
            Yes: "Da",
            No: "Nu",
            Cancel: "Anulare",
            Close: "\xcenchide",
            Clear: "Cur\u0103\u021b\u0103",
            Done: "Gata",
            Loading: "Inc\u0103rcare...",
            Select: "Selecteaz\u0103...",
            Search: "Caut\u0103",
            Back: "\xcenapoi",
            OK: "OK",
            "dxCollectionWidget-noDataText": "Nu exist\u0103 date",
            "dxDropDownEditor-selectLabel": "Selecteaz\u0103",
            "validation-required": "Obligatoriu",
            "validation-required-formatted": "{0} este obligatoriu",
            "validation-numeric": "Valoarea trebuie sa fie un num\u0103r",
            "validation-numeric-formatted": "{0} trebuie sa fie un num\u0103r",
            "validation-range": "Valoarea dep\u0103\u0219e\u0219te limita",
            "validation-range-formatted": "{0} dep\u0103\u0219e\u0219te limita",
            "validation-stringLength": "Lungimea valorii nu este corect\u0103",
            "validation-stringLength-formatted": "Lungimea pentru {0} nu este corect\u0103",
            "validation-custom": "Valoarea nu este valid\u0103",
            "validation-custom-formatted": "{0} nu este valid\u0103",
            "validation-async": "Valoarea nu este valid\u0103",
            "validation-async-formatted": "{0} valoarea nu este valid\u0103",
            "validation-compare": "Valorile nu corespund",
            "validation-compare-formatted": "{0} nu corespunde",
            "validation-pattern": "Valoarea nu corespunde modelului",
            "validation-pattern-formatted": "{0} nu corespunde modelului",
            "validation-email": "Adresa de email nu este valid",
            "validation-email-formatted": "{0} nu este valid\u0103",
            "validation-mask": "Valoarea nu este valid\u0103",
            "dxLookup-searchPlaceholder": "Num\u0103rul minim de caractere: {0}",
            "dxList-pullingDownText": "Trage\u021bi \xeen jos pentru a actualiza...",
            "dxList-pulledDownText": "Elibera\u021bi pentru a actualiza...",
            "dxList-refreshingText": "Actualizare...",
            "dxList-pageLoadingText": "\xcenc\u0103rcare...",
            "dxList-nextButtonText": "Mai mult",
            "dxList-selectAll": "Selecteaz\u0103 Tot",
            "dxListEditDecorator-delete": "\u0218terge",
            "dxListEditDecorator-more": "Mai mult",
            "dxScrollView-pullingDownText": "Trage\u021bi \xeen jos pentru a actualiza...",
            "dxScrollView-pulledDownText": "Elibera\u021bi pentru a actualiza...",
            "dxScrollView-refreshingText": "Actualizare...",
            "dxScrollView-reachBottomText": "\xcenc\u0103rcare...",
            "dxDateBox-simulatedDataPickerTitleTime": "Selecteaz\u0103 timpul",
            "dxDateBox-simulatedDataPickerTitleDate": "Selecteaz\u0103 data",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Selecteaz\u0103 data \u0219i timpul",
            "dxDateBox-validation-datetime": "Valoarea trebuie s\u0103 fie o dat\u0103 sau timp",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Data de \xeenceput",
            "dxDateRangeBox-endDateLabel": "Data de \xeencheiere",
            "dxFileUploader-selectFile": "Selecteaz\u0103 fi\u0219ierul",
            "dxFileUploader-dropFile": "sau plasa\u021bi fi\u0219ierul aici",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "kb",
            "dxFileUploader-Mb": "Mb",
            "dxFileUploader-Gb": "Gb",
            "dxFileUploader-upload": "\xcencarc\u0103",
            "dxFileUploader-uploaded": "\xcenc\u0103rcat",
            "dxFileUploader-readyToUpload": "Gata pentru \xeenc\u0103rcare",
            "dxFileUploader-uploadAbortedMessage": "\xcenc\u0103rcare anulat\u0103",
            "dxFileUploader-uploadFailedMessage": "\xcenc\u0103rcare e\u0219uat\u0103",
            "dxFileUploader-invalidFileExtension": "Tipul fi\u0219ierului nu este permis",
            "dxFileUploader-invalidMaxFileSize": "Fi\u0219ierul este prea mare",
            "dxFileUploader-invalidMinFileSize": "Fi\u0219ierul este prea mic",
            "dxRangeSlider-ariaFrom": "Din",
            "dxRangeSlider-ariaTill": "P\xe2n\u0103",
            "dxSwitch-switchedOnText": "Pornit",
            "dxSwitch-switchedOffText": "Oprit",
            "dxForm-optionalMark": "optional",
            "dxForm-requiredMessage": "{0} este obligatoriu",
            "dxNumberBox-invalidValueMessage": "Valoarea trebuie sa fie un numr\u0103",
            "dxNumberBox-noDataText": "Nu exist\u0103 date",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Alege coloana",
            "dxDataGrid-columnChooserEmptyText": "Trage coloana aici pentru a o ascunde",
            "dxDataGrid-groupContinuesMessage": "Continu\u0103 pe pagina urmatoare",
            "dxDataGrid-groupContinuedMessage": "Continu\u0103 de la pagina anterioar\u0103",
            "dxDataGrid-groupHeaderText": "Grupeaz\u0103 dup\u0103 aceast\u0103 coloan\u0103",
            "dxDataGrid-ungroupHeaderText": "Degrupeaz\u0103",
            "dxDataGrid-ungroupAllText": "Degrupeaz\u0103 Tot",
            "dxDataGrid-editingEditRow": "Editare",
            "dxDataGrid-editingSaveRowChanges": "Salvare",
            "dxDataGrid-editingCancelRowChanges": "Anulare",
            "dxDataGrid-editingDeleteRow": "\u0218terge",
            "dxDataGrid-editingUndeleteRow": "Anula\u021bi \u0219tergerea",
            "dxDataGrid-editingConfirmDeleteMessage": "Sigur dori\u021bi s\u0103 \u0219terge\u021bi aceast\u0103 \xeenregistrare?",
            "dxDataGrid-validationCancelChanges": "Anuleaz\u0103 modific\u0103rile",
            "dxDataGrid-groupPanelEmptyText": "Trage\u021bi aici un antet de coloan\u0103 pentru a grupa dup\u0103 acea coloan\u0103",
            "dxDataGrid-noDataText": "Nu exist\u0103 date",
            "dxDataGrid-searchPanelPlaceholder": "Caut\u0103...",
            "dxDataGrid-filterRowShowAllText": "(Tot)",
            "dxDataGrid-filterRowResetOperationText": "Resetare",
            "dxDataGrid-filterRowOperationEquals": "Egal",
            "dxDataGrid-filterRowOperationNotEquals": "Nu este egal",
            "dxDataGrid-filterRowOperationLess": "Mai pu\u021bin dec\xe2t",
            "dxDataGrid-filterRowOperationLessOrEquals": "Mai pu\u021bin dec\xe2t sau egal",
            "dxDataGrid-filterRowOperationGreater": "Mai mare dec\xe2t",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Mai mare dec\xe2t sau egal",
            "dxDataGrid-filterRowOperationStartsWith": "\xcencepe cu",
            "dxDataGrid-filterRowOperationContains": "Con\u021bine",
            "dxDataGrid-filterRowOperationNotContains": "Nu con\u021bine",
            "dxDataGrid-filterRowOperationEndsWith": "Se termin\u0103 cu",
            "dxDataGrid-filterRowOperationBetween": "\xcentre",
            "dxDataGrid-filterRowOperationBetweenStartText": "\xcencepe",
            "dxDataGrid-filterRowOperationBetweenEndText": "Sf\xe2r\u0219it",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Aplica filtre",
            "dxDataGrid-trueText": "adev\u0103rat",
            "dxDataGrid-falseText": "fals",
            "dxDataGrid-sortingAscendingText": "Sortare cresc\u0103toare",
            "dxDataGrid-sortingDescendingText": "Sortare descresc\u0103toare",
            "dxDataGrid-sortingClearText": "Cur\u0103\u021b\u0103 Sortarea",
            "dxDataGrid-editingSaveAllChanges": "Salveaz\u0103 modific\u0103rile",
            "dxDataGrid-editingCancelAllChanges": "Renun\u0163\u0103 la modific\u0103ri",
            "dxDataGrid-editingAddRow": "Adaug\u0103 un r\xe2nd",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min of {1} este {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max of {1} este {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Med of {1} este {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Sum of {1} este {0}",
            "dxDataGrid-summaryCount": "Num\u0103r\u0103: {0}",
            "dxDataGrid-columnFixingFix": "Fixare",
            "dxDataGrid-columnFixingUnfix": "Defixare",
            "dxDataGrid-columnFixingLeftPosition": "La st\xe2nga",
            "dxDataGrid-columnFixingRightPosition": "La dreapta",
            "dxDataGrid-exportTo": "Export",
            "dxDataGrid-exportToExcel": "Exportare fi\u0219ier Excel ",
            "dxDataGrid-exporting": "Exportare...",
            "dxDataGrid-excelFormat": "Fi\u0219ier Excel",
            "dxDataGrid-selectedRows": "Selecteaz\u0103 r\xe2nd",
            "dxDataGrid-exportSelectedRows": "Export\u0103 r\xe2ndul selectat",
            "dxDataGrid-exportAll": "Export\u0103 toate datele ",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Gol)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Anulare",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Coloan\u0103",
            "dxDataGrid-ariaValue": "Valoare",
            "dxDataGrid-ariaFilterCell": "Celul\u0103 de filtrare",
            "dxDataGrid-ariaCollapse": "Restr\xe2ngere",
            "dxDataGrid-ariaExpand": "Extindere",
            "dxDataGrid-ariaDataGrid": "Gril\u0103 de date",
            "dxDataGrid-ariaSearchInGrid": "Caut\u0103 in grila de date",
            "dxDataGrid-ariaSelectAll": "Selecteaz\u0103 tot",
            "dxDataGrid-ariaSelectRow": "Selecteaz\u0103 r\xe2nd",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filtreaz\u0103 Constructor",
            "dxDataGrid-filterPanelCreateFilter": "Creaz\u0103 Fi\u0219ier",
            "dxDataGrid-filterPanelClearFilter": "Cur\u0103\u021b\u0103",
            "dxDataGrid-filterPanelFilterEnabledHint": "Activa\u021bi filtrul",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Adaug\u0103",
            "dxPager-infoText": "Pagina {0} de {1} ({2} obiecte)",
            "dxPager-pagesCountText": "de",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Tot",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous Page",
            "dxPager-nextPage": "Next Page",
            "dxPager-ariaLabel": "Page Navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Total general",
            "dxPivotGrid-total": "{0} Total",
            "dxPivotGrid-fieldChooserTitle": "Selector de C\xe2mp",
            "dxPivotGrid-showFieldChooser": "Afi\u0219eaz\u0103 Selectorul de C\xe2mp",
            "dxPivotGrid-expandAll": "Extindere total\u0103",
            "dxPivotGrid-collapseAll": "Restr\xe2ngere total\u0103",
            "dxPivotGrid-sortColumnBySummary": 'Sorteaz\u0103 "{0}" dup\u0103 Aceasta Coloan\u0103',
            "dxPivotGrid-sortRowBySummary": 'Sorteaz\u0103 "{0}" dup\u0103 Aceast R\xe2nd',
            "dxPivotGrid-removeAllSorting": "Elimin\u0103 Toat\u0103 Sortarea",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "C\xe2mpuri de r\xe2nd",
            "dxPivotGrid-columnFields": "C\xe2mpuri de coloan\u0103",
            "dxPivotGrid-dataFields": "C\xe2mpuri de date",
            "dxPivotGrid-filterFields": "Filter Fields",
            "dxPivotGrid-allFields": "C\xe2mpuri de filtrare",
            "dxPivotGrid-columnFieldArea": "Plasa\u021bi c\xe2mpurile de coloan\u0103 aici",
            "dxPivotGrid-dataFieldArea": "Plasa\u021bi c\xe2mpurile de date aici",
            "dxPivotGrid-rowFieldArea": "Plasa\u021bi c\xe2mpurile r\xe2ndului aici",
            "dxPivotGrid-filterFieldArea": "Plasa\u021bi c\xe2mpurile de filtrare aici",
            "dxScheduler-editorLabelTitle": "Subiect",
            "dxScheduler-editorLabelStartDate": "Data de \xeenceput",
            "dxScheduler-editorLabelEndDate": "Data de \xeencheiere",
            "dxScheduler-editorLabelDescription": "Descriere",
            "dxScheduler-editorLabelRecurrence": "Repet\u0103",
            "dxScheduler-openAppointment": "Deschide\u021bi rezervarea",
            "dxScheduler-recurrenceNever": "Niciodat\u0103",
            "dxScheduler-recurrenceMinutely": "In fiecare minut",
            "dxScheduler-recurrenceHourly": "Orar",
            "dxScheduler-recurrenceDaily": "Zilnic",
            "dxScheduler-recurrenceWeekly": "S\u0103pt\u0103m\xe2nal",
            "dxScheduler-recurrenceMonthly": "Lunar",
            "dxScheduler-recurrenceYearly": "Anual",
            "dxScheduler-recurrenceRepeatEvery": "Repet\u0103 fiecare",
            "dxScheduler-recurrenceRepeatOn": "Repet\u0103 pe",
            "dxScheduler-recurrenceEnd": "Termina\u021bi repetarea",
            "dxScheduler-recurrenceAfter": "Dup\u0103",
            "dxScheduler-recurrenceOn": "Pe",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "ore(s)",
            "dxScheduler-recurrenceRepeatDaily": "zile(s)",
            "dxScheduler-recurrenceRepeatWeekly": "s\u0103pt\u0103m\xe2ni(s)",
            "dxScheduler-recurrenceRepeatMonthly": "luni(s)",
            "dxScheduler-recurrenceRepeatYearly": "ani(s)",
            "dxScheduler-switcherDay": "Zi",
            "dxScheduler-switcherWeek": "S\u0103pt\u0103m\xe2n\u0103",
            "dxScheduler-switcherWorkWeek": "S\u0103pt\u0103m\xe2n\u0103 de lucru",
            "dxScheduler-switcherMonth": "Lun\u0103",
            "dxScheduler-switcherAgenda": "Agend\u0103",
            "dxScheduler-switcherTimelineDay": "Orar zilnic",
            "dxScheduler-switcherTimelineWeek": "Orar s\u0103pt\u0103m\xe2nal",
            "dxScheduler-switcherTimelineWorkWeek": "Orar de lucru s\u0103pt\u0103m\xe2nal ",
            "dxScheduler-switcherTimelineMonth": "Orar lunar",
            "dxScheduler-recurrenceRepeatOnDate": "pe data",
            "dxScheduler-recurrenceRepeatCount": "apari\u021bie(s)",
            "dxScheduler-allDay": "Tot\u0103 ziua",
            "dxScheduler-confirmRecurrenceEditMessage": "Dori\u021bi s\u0103 edita\u021bi doar aceast\u0103 programare sau \xeentreaga serie?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Dori\u021bi s\u0103 \u0219terge\u021bi doar aceast\u0103 programare sau \xeentreaga serie?",
            "dxScheduler-confirmRecurrenceEditSeries": "Edita\u021bi serie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u0218terge\u021bi serie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Editare rezervare",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u0218tergere rezervare",
            "dxScheduler-noTimezoneTitle": "F\u0103r\u0103 fus orar",
            "dxScheduler-moreAppointments": "{0} mai mult",
            "dxCalendar-todayButtonText": "Ast\u0103zi",
            "dxCalendar-ariaWidgetName": "Calendar",
            "dxCalendar-ariaHotKeysInfo": "To navigate between views, press Control, and then Left Arrow or Right Arrow. To zoom in on a view, press Control, and then Down Arrow. To zoom out, press Control, and then Up Arrow.",
            "dxColorView-ariaRed": "Ro\u0219u",
            "dxColorView-ariaGreen": "Verde",
            "dxColorView-ariaBlue": "Albastru",
            "dxColorView-ariaAlpha": "Tranparent",
            "dxColorView-ariaHex": "Cod de culoare",
            "dxTagBox-selected": "{0} selectat",
            "dxTagBox-allSelected": "Toate selctate ({0})",
            "dxTagBox-moreSelected": "{0} mai mult",
            "vizExport-printingButtonText": "Printare",
            "vizExport-titleMenuText": "Exportare/Printare",
            "vizExport-exportButtonText": "{0} fi\u0219ier",
            "dxFilterBuilder-and": "\u0219i",
            "dxFilterBuilder-or": "Sau",
            "dxFilterBuilder-notAnd": "Nu \u0219i",
            "dxFilterBuilder-notOr": "Nu sau",
            "dxFilterBuilder-addCondition": "Adaug\u0103 condi\u021bie",
            "dxFilterBuilder-addGroup": "Adaug\u0103 grup",
            "dxFilterBuilder-enterValueText": "<introduce\u021bi o valoare>",
            "dxFilterBuilder-filterOperationEquals": "Egal",
            "dxFilterBuilder-filterOperationNotEquals": "Nu este egal",
            "dxFilterBuilder-filterOperationLess": "Este mai pu\u021bin dec\xe2t",
            "dxFilterBuilder-filterOperationLessOrEquals": "Este mai pu\u021bin dec\xe2t sau egal",
            "dxFilterBuilder-filterOperationGreater": "Este mai mare dec\xe2t",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Este mai mare dec\xe2t sau egal",
            "dxFilterBuilder-filterOperationStartsWith": "Incepe cu",
            "dxFilterBuilder-filterOperationContains": "Con\u021bine",
            "dxFilterBuilder-filterOperationNotContains": "Nu con\u021bine",
            "dxFilterBuilder-filterOperationEndsWith": "Se termina cu",
            "dxFilterBuilder-filterOperationIsBlank": "Este gol",
            "dxFilterBuilder-filterOperationIsNotBlank": "Nu este gol",
            "dxFilterBuilder-filterOperationBetween": "Este \xeentre",
            "dxFilterBuilder-filterOperationAnyOf": "Este oricare dintre",
            "dxFilterBuilder-filterOperationNoneOf": "Nu este nici una dintre",
            "dxHtmlEditor-dialogColorCaption": "Schimb\u0103 culoarea fontului",
            "dxHtmlEditor-dialogBackgroundCaption": "Schimb\u0103 culoarea de fundal",
            "dxHtmlEditor-dialogLinkCaption": "Adaug\u0103 Link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Text",
            "dxHtmlEditor-dialogLinkTargetField": "Dechide link-ul intr-o nou\u0103 fereastr\u0103",
            "dxHtmlEditor-dialogImageCaption": "Adaug\u0103 imagine",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Text alternativ",
            "dxHtmlEditor-dialogImageWidthField": "L\u0103\u0163ime (px)",
            "dxHtmlEditor-dialogImageHeightField": "\xcen\u0103l\u0163ime (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "R\xe2nd",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Coloan\u0103",
            "dxHtmlEditor-dialogInsertTableCaption": "Introduce\u021bi tabelul",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Titlu",
            "dxHtmlEditor-normalText": "Text normal",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxFileManager-newDirectoryName": "Director f\u0103r\u0103 titlu",
            "dxFileManager-rootDirectoryName": "Fi\u015fiere",
            "dxFileManager-errorNoAccess": "Acces interzis. Opera\u021biunea nu a putut fi finalizat\u0103.",
            "dxFileManager-errorDirectoryExistsFormat": "Directorul '{0}' exist\u0103 deja.",
            "dxFileManager-errorFileExistsFormat": "Fi\u015fierul '{0}' exist\u0103 deja.",
            "dxFileManager-errorFileNotFoundFormat": "Fi\u015fierul '{0}' nu a fost g\u0103sit.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directorul '{0}' nu a fost g\u0103sit.",
            "dxFileManager-errorWrongFileExtension": "Extensia de fi\u0219ier nu este permis\u0103.",
            "dxFileManager-errorMaxFileSizeExceeded": "Dimensiunea fi\u0219ierului dep\u0103\u0219e\u0219te dimensiunea maxim\u0103 permis\u0103.",
            "dxFileManager-errorInvalidSymbols": "Acest nume con\u021bine caractere nevalide.",
            "dxFileManager-errorDefault": "Eroare nespecificat\u0103.",
            "dxFileManager-errorDirectoryOpenFailed": "Directorul nu poate fi deschis",
            "dxFileManager-commandCreate": "Director nou",
            "dxFileManager-commandRename": "Redenumire",
            "dxFileManager-commandMove": "Mut\u0103 la",
            "dxFileManager-commandCopy": "Copiaz\u0103 in",
            "dxFileManager-commandDelete": "\u0218terge",
            "dxFileManager-commandDownload": "Descarc\u0103",
            "dxFileManager-commandUpload": "Incarc\u0103 fi\u015fier",
            "dxFileManager-commandRefresh": "Re\xeencarca",
            "dxFileManager-commandThumbnails": "Vizualizare miniaturi",
            "dxFileManager-commandDetails": "Vizualizare detali",
            "dxFileManager-commandClearSelection": "Selec\u021bie clar\u0103",
            "dxFileManager-commandShowNavPane": "Comuta\u021bi panoul de navigare",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Mut\u0103 la",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Mut\u0103",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copiaz\u0103 in",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copiaz\u0103",
            "dxFileManager-dialogRenameItemTitle": "Redenumire",
            "dxFileManager-dialogRenameItemButtonText": "Salaveaz\u0103",
            "dxFileManager-dialogCreateDirectoryTitle": "Director nou",
            "dxFileManager-dialogCreateDirectoryButtonText": "Creaz\u0103",
            "dxFileManager-dialogDeleteItemTitle": "\u0218terge",
            "dxFileManager-dialogDeleteItemButtonText": "\u0218terge",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Sigur dori\u021bi s\u0103 \u0219terge\u021bi{0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Sigur dori\u021bi s\u0103 \u0219terge\u021bi  {0} elementul?",
            "dxFileManager-dialogButtonCancel": "Anulare",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Crearea unui director \xeen interior {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Crearea unui director \xeen interior {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directorul nu a fost creat",
            "dxFileManager-editingCreateCommonErrorMessage": "Directorul nu a fost creat",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Redenumirea unui element din interior {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Redenumirea unui element din interior {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Elementul nu a fost redenumit",
            "dxFileManager-editingRenameCommonErrorMessage": "Elementul nu a fost redenumit",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "\u0218tergerea unui element din {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "\u0218tergerea {0} elementelor din {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "\u0218tergerea unui element din  {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "\u0218tergerea {0} elementelor din {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Elementul nu a fost \u0219ters",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elementele nu a fost \u0219terse",
            "dxFileManager-editingDeleteCommonErrorMessage": "Unele elemente nu au fost \u0219terse",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Mutarea unui element \xeen {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Mutarea {0} elementului \xeen {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Mutarea unui element \xeen {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Mutarea  {0} elementului \xeen  {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Elementul nu a fost mutat",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} elementele nu a fost mutate",
            "dxFileManager-editingMoveCommonErrorMessage": "Unele elemente nu a fost mutate",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copierea unui element \xeen {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copiere {0} element \xeen {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copierea unui element \xeen {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copiere {0} element \xeen {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Elementul nu a fost copiat",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} elementul nu a fost copiat",
            "dxFileManager-editingCopyCommonErrorMessage": "Unele elemente nu au fost copiate",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\xcenc\u0103rcarea unui element \xeen {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\xcenc\u0103rcarea {0} elementului \xeen {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\xcenc\u0103rcarea unui element \xeen {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "\xcenc\u0103rcarea {0} elementului \xeen {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Elementul nu a fost \xeenc\u0103rcat",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} elementele nu au fost \xeenc\u0103rcate",
            "dxFileManager-editingUploadCanceledMessage": "Anulare",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Nume",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Data modificata",
            "dxFileManager-listDetailsColumnCaptionFileSize": "M\u0103rime fi\u0219ier",
            "dxFileManager-listThumbnailsTooltipTextSize": "M\u0103rime",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Data modificata",
            "dxFileManager-notificationProgressPanelTitle": "Progres",
            "dxFileManager-notificationProgressPanelEmptyListText": "F\u0103r\u0103 opera\u021biuni",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Anulare",
            "dxDiagram-categoryGeneral": "General",
            "dxDiagram-categoryFlowchart": "Diagrama de flux",
            "dxDiagram-categoryOrgChart": "Organigrama",
            "dxDiagram-categoryContainers": "Containere",
            "dxDiagram-categoryCustom": "Personalizat",
            "dxDiagram-commandExportToSvg": "Exporta\u021bi \xeen SVG",
            "dxDiagram-commandExportToPng": "Exporta\u021bi \xeen PNG",
            "dxDiagram-commandExportToJpg": "Exporta\u021bi \xeen JPEG",
            "dxDiagram-commandUndo": "Anula",
            "dxDiagram-commandRedo": "Reface",
            "dxDiagram-commandFontName": "Fontulul numelui",
            "dxDiagram-commandFontSize": "Marimea fontului",
            "dxDiagram-commandBold": "Bold",
            "dxDiagram-commandItalic": "Italic",
            "dxDiagram-commandUnderline": "Subliniat",
            "dxDiagram-commandTextColor": "Culoarea fontului",
            "dxDiagram-commandLineColor": "culoarea liniei",
            "dxDiagram-commandLineWidth": "L\u0103\u021bimea liniei",
            "dxDiagram-commandLineStyle": "stilul liniei",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Punctat",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "Culoare umplere",
            "dxDiagram-commandAlignLeft": "Aliniat la st\xe2nga",
            "dxDiagram-commandAlignCenter": "Aliniat la centru",
            "dxDiagram-commandAlignRight": "Aliniere la dreapta",
            "dxDiagram-commandConnectorLineType": "Tipul liniei conectorului",
            "dxDiagram-commandConnectorLineStraight": "Drept",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonal",
            "dxDiagram-commandConnectorLineStart": "Pornire linie conector",
            "dxDiagram-commandConnectorLineEnd": "Sf\xe2r\u0219itul liniei conectorului",
            "dxDiagram-commandConnectorLineNone": "Niciunul",
            "dxDiagram-commandConnectorLineArrow": "S\u0103geat\u0103",
            "dxDiagram-commandFullscreen": "Ecran complet",
            "dxDiagram-commandUnits": "Unit\u0103\u021bi",
            "dxDiagram-commandPageSize": "M\u0103rime pagin\u0103",
            "dxDiagram-commandPageOrientation": "Orientare pagin\u0103",
            "dxDiagram-commandPageOrientationLandscape": "Vedere",
            "dxDiagram-commandPageOrientationPortrait": "Portret",
            "dxDiagram-commandPageColor": "Culoare pagina",
            "dxDiagram-commandShowGrid": "Afisare grila",
            "dxDiagram-commandSnapToGrid": "Fixare la gril\u0103",
            "dxDiagram-commandGridSize": "Dimensiune gril\u0103",
            "dxDiagram-commandZoomLevel": "Nivel zoom",
            "dxDiagram-commandAutoZoom": "Zoom automat",
            "dxDiagram-commandFitToContent": "Se potrive\u0219te con\u021binutului",
            "dxDiagram-commandFitToWidth": "Se potrive\u0219te l\u0103\u021bimii",
            "dxDiagram-commandAutoZoomByContent": "M\u0103rire automat\u0103 dup\u0103 con\u021binut",
            "dxDiagram-commandAutoZoomByWidth": "M\u0103rire automat\u0103 dup\u0103 l\u0103\u021bime",
            "dxDiagram-commandSimpleView": "Vedere simpla",
            "dxDiagram-commandCut": "T\u0103iat",
            "dxDiagram-commandCopy": "Copiat",
            "dxDiagram-commandPaste": "Lipire",
            "dxDiagram-commandSelectAll": "Selecteaz\u0103 tot",
            "dxDiagram-commandDelete": "\u0218terge",
            "dxDiagram-commandBringToFront": "Aduce\u021bi \xeen fa\u021b\u0103",
            "dxDiagram-commandSendToBack": "Timite \xeenapoi",
            "dxDiagram-commandLock": "Blocare",
            "dxDiagram-commandUnlock": "Deblocare",
            "dxDiagram-commandInsertShapeImage": "Introdu imaginea...",
            "dxDiagram-commandEditShapeImage": "Mofica imaginea...",
            "dxDiagram-commandDeleteShapeImage": "\u0218terge imaginea",
            "dxDiagram-commandLayoutLeftToRight": "De la st\xe2nga la dreapta",
            "dxDiagram-commandLayoutRightToLeft": "De la dreapta la st\xe2nga",
            "dxDiagram-commandLayoutTopToBottom": "De sus p\xe2n\u0103 jos",
            "dxDiagram-commandLayoutBottomToTop": "De jos p\xe2n\u0103 sus",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Anulare",
            "dxDiagram-dialogInsertShapeImageTitle": "Introdu imaginea",
            "dxDiagram-dialogEditShapeImageTitle": "Mofica imaginea",
            "dxDiagram-dialogEditShapeImageSelectButton": "Selecteaz\u0103 imaginea",
            "dxDiagram-dialogEditShapeImageLabelText": "sau plasa\u021bi fi\u0219ierul aici",
            "dxDiagram-uiExport": "Export\u0103",
            "dxDiagram-uiProperties": "Propert\u0103\u021bi",
            "dxDiagram-uiSettings": "Set\u0103ri",
            "dxDiagram-uiShowToolbox": "Afi\u0219a\u021bi caseta de instrumente",
            "dxDiagram-uiSearch": "Caut\u0103",
            "dxDiagram-uiStyle": "Stil",
            "dxDiagram-uiLayout": "Aspect",
            "dxDiagram-uiLayoutTree": "Aspect",
            "dxDiagram-uiLayoutLayered": "Stratificat",
            "dxDiagram-uiDiagram": "Diagram\u0103",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Objectiect",
            "dxDiagram-uiConnector": "Conector",
            "dxDiagram-uiPage": "Pagin\u0103",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Dreptunghi",
            "dxDiagram-shapeEllipse": "Elips\u0103",
            "dxDiagram-shapeCross": "Travers\u0103",
            "dxDiagram-shapeTriangle": "Triunghi",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "Inim\u0103",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Start",
            "dxDiagram-shapeArrowLeft": "S\u0103geata st\xe2ng\u0103",
            "dxDiagram-shapeArrowUp": "S\u0103geata \xeen sus",
            "dxDiagram-shapeArrowRight": "S\u0103geata dreapt\u0103",
            "dxDiagram-shapeArrowDown": "S\u0103geata \xeen jos",
            "dxDiagram-shapeArrowUpDown": "S\u0103geata sus jos",
            "dxDiagram-shapeArrowLeftRight": "S\u0103geata st\xe2ng\u0103 dreapta",
            "dxDiagram-shapeProcess": "Proces",
            "dxDiagram-shapeDecision": "Decizie",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Proces predefinit",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Documente multiple",
            "dxDiagram-shapeManualInput": "Introducere manual\u0103",
            "dxDiagram-shapePreparation": "Preparare",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Baza de date",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Stocare intern\u0103",
            "dxDiagram-shapePaperTape": "Banda de hartie",
            "dxDiagram-shapeManualOperation": "Operare manuale",
            "dxDiagram-shapeDelay": "\xcent\xe2rziere",
            "dxDiagram-shapeStoredData": "Date stocate",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "\xcembina\u021bi",
            "dxDiagram-shapeConnector": "Conector",
            "dxDiagram-shapeOr": "Or",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Recipient",
            "dxDiagram-shapeVerticalContainer": "Recipient Vertical",
            "dxDiagram-shapeHorizontalContainer": "Recipient orizontal",
            "dxDiagram-shapeCardDefaultText": "Numele persoanei",
            "dxDiagram-shapeCardWithImageOnLeft": "Card cu imagine \xeen st\xe2nga",
            "dxDiagram-shapeCardWithImageOnTop": "Card cu imagine deasupra",
            "dxDiagram-shapeCardWithImageOnRight": "Card cu imagine \xeen dreapta",
            "dxGantt-dialogTitle": "Titlu",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "Sf\xe2r\u0219it",
            "dxGantt-dialogProgressTitle": "Progres",
            "dxGantt-dialogResourcesTitle": "Resurse",
            "dxGantt-dialogResourceManagerTitle": "Manager de resurse",
            "dxGantt-dialogTaskDetailsTitle": "Detalii activitate",
            "dxGantt-dialogEditResourceListHint": "Edita\u021bi lista de resurse",
            "dxGantt-dialogEditNoResources": "F\u0103r\u0103 resurs\u0103",
            "dxGantt-dialogButtonAdd": "Adaug\u0103",
            "dxGantt-contextMenuNewTask": "Activitate nou\u0103",
            "dxGantt-contextMenuNewSubtask": "Subactivitate nou\u0103",
            "dxGantt-contextMenuDeleteTask": "\u0218terge\u021bi activitatea",
            "dxGantt-contextMenuDeleteDependency": "\u0218terge depnden\u021b\u0103",
            "dxGantt-dialogTaskDeleteConfirmation": "\u0218tergerea unui activitate, de asemenea \u0219terge toate dependen\u021bele \u0219i subtichetele sale. Sigur dori\u021bi s\u0103 \u0219terge\u021bi aceast tichet?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Sigur dori\u021bi s\u0103 \u0219terge\u021bi dependen\u021ba din tichet?",
            "dxGantt-dialogResourcesDeleteConfirmation": "\u0218tergerea unei resurse, de asemenea \u0219tergea acesteia din tichetul c\u0103ruia \xeei este atribuit\u0103 aceast\u0103 resurs\u0103. Sigur dori\u021bi s\u0103 \u0219terge\u021bi aceste resurse? Resurs\u0103: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Tichetul pe care \xeencerca\u021bi s\u0103 \xeel muta\u021bi este legat de un al doilea tichet printr-o rela\u021bie de dependen\u021b\u0103. Aceast\u0103 modificare ar intra \xeen conflict cu regulile de dependen\u021b\u0103. Cum dori\u021bi s\u0103 continua\u021bi?",
            "dxGantt-dialogConstraintViolationMessage": "Tichetul pe care \xeencerca\u021bi s\u0103 \xeel muta\u021bi este legat de un al doilea tichet printr-o rela\u021bie de dependen\u021b\u0103. Cum dori\u021bi s\u0103 continua\u021bi?",
            "dxGantt-dialogCancelOperationMessage": "Anula\u021bi opera\u021biunea",
            "dxGantt-dialogDeleteDependencyMessage": "\u0218terge\u021bi dependen\u021ba",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Muta\u021bi tichetul \u0219i p\u0103stra\u021bi dependen\u021ba",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Anula\u021bi",
            "dxGantt-redo": "Refa\u021bi",
            "dxGantt-expandAll": "Expanda\u021bi tot",
            "dxGantt-collapseAll": "Restrange\u021bi tot",
            "dxGantt-addNewTask": "Ad\u0103uga\u0163i o activitate nou\u0103",
            "dxGantt-deleteSelectedTask": "\u0218terge\u021bi activitatea selectat\u0103",
            "dxGantt-zoomIn": "M\u0103rire",
            "dxGantt-zoomOut": "Mic\u0219orare",
            "dxGantt-fullScreen": "Ecran complet",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sort Ascending",
            "dxGantt-sortingDescendingText": "Sort Descending",
            "dxGantt-sortingClearText": "Clear Sorting",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}"
        }
    })
}));
