// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe base per la definizione di eventi locali
// ************************************************

function GFX(classe, flin, obj, skip, objout, customType)
{
  this.Classe = classe; // Classe di oggetti da animare: menu, sidebar, body, docked...
  this.Flin = flin;     // true->in, false->out
  this.Obj = obj;       // L'oggetto su cui si deve agire (puo' anche essere un WebForm nel caso di animazione di Form)
  this.ObjOut = objout; // Nel caso l'animazione richieda due oggetti questo e' l'oggetto su cui eseguire l'animazione di uscita..
  this.Skipped = skip;  // Mi memorizzo perche' la durata e' ZERO (skippata da codice o per configurazione)
  //
  this.Tipo = RD3_ClientParams.GFXDef[this.Classe]; // Tipo e Durata in ms dell'effetto grafico. Es: "fold:250"
  //
  // Se e' stata specificata un'animazione differente prendo quella
  if (customType)
    this.Tipo = customType;
  //
  this.Durata = 250;    // ms
  //
  this.Blocking = false;
  this.WebkitTick = 0;
  //
  var p = this.Tipo.indexOf(":");
  if (p>-1)
  {
    // L'animazione e' bloccante se tipo contiene !
    var exc = this.Tipo.indexOf("!");
    if (exc != -1)
    {
      this.Blocking = true;
      this.Tipo = this.Tipo.substring(0,exc);
    }
    //
    this.Durata = parseInt(this.Tipo.substring(p+1));
    this.Tipo = this.Tipo.substring(0,p);
  }
  //
  if (skip || this.Tipo=="none" || !RD3_ClientParams.EnableGFX || RD3_Glb.IsMobile())
    this.Durata = 0;
  //
  this.Finished = false; // Effetto terminato?
  this.Started = false;  // Effetto iniziato? (fatto almeno un Tick..)
  //
  this.CloseFormAnimation = false;  // Animazione di chiusura form?
  //
  this.OldValue = false;            // Per alcune animazioni e' necessario sapere il valore 'vecchio' del parametro per decidere cosa fare
  //
  // Variabili di gestione del collapse e del passaggio tra lista e dettaglio
  this.Immediate = false;
  //
  // Variabili per le animazioni di book
  this.UnrealizeOnFinish = false;   // True se alla fine dell'animazione devo fare l'unrealize della pagina animata in ingresso (sostituita da quella arrivata dal server, vedi BookPage.SetNumber)
  //
  this.ExecuteFinish = false;       // Semaforo per fare eseguire la fine dell'animazione

  this.id = Math.floor(Math.random()*500000); 
}


// **************************************************************************** 
// Esegue lo start dell'animazione
// ****************************************************************************
GFX.prototype.Start = function()
{
  // Se non devo eseguirlo passo subito nello stato finale.
  // Non inizializzo la data proprio per dare l'informazione che l'effetto non e' mai partito
  if (this.Durata==0)
  {
    this.SetFinished();
    return;
  }
  //
  this.StartDate = new Date(); // Istante iniziale
  if (this.Obj && this.Obj.style)
    this.ObjOverflow = this.Obj.style.overflow; // Overflow iniziale
  //
  // Inizializzo lo stato degli oggetti in base alla classe
  switch(this.Classe)
  {
    case "start":
      //
      this.StartStart();
      //
    break;
    
    case "form":
      //
      this.FormStart();
      //
    break;
    
    case "tree":
      //
      this.TreeStart();
      //
    break;
    
    case "list":
      //
      this.ListStart();
      //
    break;
       
    case "book":
      //
      this.BookStart();
      //
    break;
    
    case "redirect":
      //
      this.RedirectStart();
      //
    break;
    
    case "preview":
      //
      this.PreviewStart();
      //
    break;
    
    case "tooltip":
      //
      this.TooltipStart();
      //
    break;
    
    case "combo":
      //
      this.ComboStart();
      //
    break;
  }
}


// **************************************************************************** 
// fa avanzare gli effetti grafici 
// ****************************************************************************
GFX.prototype.Tick = function()
{
  // Fail safe, se l'animazion non e' finita perchè non è scattato l'evento di endAnimation la finisco comunque
  if (this.IsWebKit && this.Started)
  {
    this.WebkitTick++;
    if (this.WebkitTick > 20 && !this.Finished)
      this.SetFinished();
  }
  //
  if (this.IsFinished())
    return;
  //
  if (!this.Started && !RD3_Glb.IsIE(10, false))
  {
    // Se c'e' un'altra animazione webkit, la sovrapposizione rompe assai
    // allora aspetto serializzandole
    if (RD3_GFXManager.WebKitAnimating())
      return;
    //
    // E' la prima volta che arrivo nel tick
    // vediamo se posso gestire l'animazione tramite web kit
    this.StartWebKit();
  } 
  //
  this.Started = true;
  //
  // Se sto davvero utilizzando webkit per l'animazione non devo fare nulla qui
  if (this.IsWebKit)
    return;
  //
  var d = new Date(); // Istante attuale
  var perc = (d-this.StartDate)/this.Durata; // Percentuale di completamento (da 0 a 1)
  if (perc>=1)
  { 
    perc = 1;
    //
    // Se il semaforo e' true allora finisco l'animazione
    if (this.ExecuteFinish)
    {  
      this.SetFinished();
      return;
    } 
  }
  //
  // Interpolazione quadratica
  perc=Math.sqrt(perc);
  //
  // Eseguo avanzamento effetto
  switch(this.Classe)
  {
    case "start":
      //
      this.StartTick(perc);
      //
    break;
    
    case "form":
      //
      this.FormTick(perc);
      //
    break;

    case "tree":
      //
      this.TreeTick(perc);
      //
    break;
    
    case "list":
      //
      this.ListTick(perc);
      //
    break;

    case "book":
      //
      this.BookTick(perc);
      //
    break;
    
    case "redirect":
      //
      this.RedirectTick(perc);
      //
    break;
    
    case "preview":
      //
      this.PreviewTick(perc);
      //
    break;
    
    case "tooltip":
      //
      this.TooltipTick(perc);
      //
    break;
    
    case "combo":
      //
      this.ComboTick(perc);
      //
    break;
  }
  //
  if (perc==1)
  {
    // Metto a true il semaforo: al prossimo tick l'animazione viene completata
    this.ExecuteFinish = true;
  }
}


// **************************************************************************** 
// Imposta lo stato finale dell'oggetto perche' l'effetto e' terminato
// ****************************************************************************
GFX.prototype.SetFinished= function()
{
  if (this.IsWebKit)
  {
    // Per webkit, ObjW puo' essere negatvo
    if (this.ObjW<0)
      this.ObjW = - this.ObjW;
    if (this.ObjH<0)
      this.ObjH = - this.ObjH;
  }
  //
  if (this.TargetObj)
  {
    RD3_Glb.RemoveEndTransaction(this.TargetObj, RD3_GFXManager.OnEndAnimation, false);
    this.TargetObj = null;
  }
  this.ResetWebKitTiming();
  //
  switch (this.Classe)
  {
    case "start":
      //
      this.StartFinish();
      //
    break;
    
    case "form":
      //
      this.FormFinish();
      //
    break;
    
    case "tree":
      //
      this.TreeFinish();
      //
    break;
    
    case "list":
      //
      this.ListFinish();
      //
    break;

    case "book":
      //
      this.BookFinish();
      //
    break;
    
    case "redirect":
      //
      this.RedirectFinish();
      //
    break;
    
    case "preview":
      //
      this.PreviewFinish();
      //
    break;
    
    case "tooltip":
      //
      this.TooltipFinish();
      //
    break;
    
    case "combo":
      //
      this.ComboFinish();
      //
    break;
  }
  //
  this.Finished = true;
  //
  // Elimino i riferimenti degli oggetti animati
  this.Obj = null;
  this.ObjOut = null;
}


// **************************************************************************** 
// ritorna vero se l'effetto e' terminato e deve essere rimosso
// ****************************************************************************
GFX.prototype.IsFinished= function()
{
  return this.Finished;
}


// ************************************************
// Conclude le animazioni su un determinato oggetto
// ************************************************
GFX.prototype.FinishGFX = function(fx)
{
  var fin = false;
  //
  // Ci puo' essere una sola animazione di form attiva in un dato istante
  if (this.Classe == "form" && fx.Classe == "form")
    fin = true;
  //
  // Ci puo' essere una sola animazione per docked alla stessa posizione, 
  if (this.Classe == "docked" && fx.Classe == "docked" && this.Obj && this.Obj.DockType == fx.Obj.DockType)
  {
    // Se sono una animazione di ingresso vinco io (e quella di uscita muore..) altrimenti devo finire io e continuare lei
    if (this.Flin)
      return true;
    else
    {
      fin = true;
      this.ObjDockType = this.Obj.DockType;
    }
  }
  //
  if (fx.Obj==this.Obj && this.CanBeFinished(fx.Classe, fx.Tipo))
    fin = true;
  //
  if (fin)
  {
    // Se l'animazione e' gia' partita finisco andando nello stato finale,
    // altrimenti ci sono alcuni casi (risposte concatenate) in cui se l'animazione non e' partita
    // non vado nello stato finale
    if (!this.Started && !this.Finished)
    {
      if (this.Classe=="list" && fx.Classe == "list")
        this.Finished = true;
    }
    //
    // Se l'oggetto in uscita di entrambe le animazioni e lo stesso e siamo entrambe animazioni di chiusura 
    // io non posso eliminare la form, altrimenti la prossima animazione non troverebbe l'oggetto: allora
    // elimino la mia impostazione di chiusura
    if (this.Classe == "form" && fx.Classe == "form" && this.ObjOut==fx.ObjOut && this.CloseFormAnimation && fx.CloseFormAnimation)
      this.CloseFormAnimation = false;
  }
  if (fin && !this.Finished)
    this.SetFinished();
  //
  // La fine dell'animazione ha sovrascritto il parametro AlreadyVisible.. lo metto a false
  if (this.Classe == "form" && fx.Classe == "form" && this.Obj && this.Obj.Realized)
  {
    this.Obj.AlreadyVisible = false;
  }
  //
  return this.BlockAnim(fx.Classe, fx.Tipo, fx);
}


// ************************************************
// True se questa animazione puo' essere bloccata da un
// animazione del tipo e classe specificata
// ************************************************
GFX.prototype.CanBeFinished = function(classe, tipo)
{
  // Un animazione di Messaggio non puo' bloccare un animazione di form
  if (this.Classe == "form" && classe == "message")
    return false;
  return true;
}


// ************************************************
// True se questa animazione deve vincere rispetto
//  a quella specificata, che deve essere bloccata
// ************************************************
GFX.prototype.BlockAnim = function(classe, tipo, fx)
{
  // Un animazione di Messaggio non puo' bloccare un animazione di form
  if (this.Classe == "form" && classe == "message")
    return true;
  //
  // Ci puo' essere una sola animazione per docked alla stessa posizione
  if (this.Classe == "docked" && classe == "docked" && ((this.Obj && this.Obj.DockType==fx.Obj.DockType)||(this.ObjDockType==fx.Obj.DockType)))
    return true;
  //
  return false;
}

// ************************************************
// Esegue lo start di una animazione di Form
// ************************************************
GFX.prototype.FormStart = function()
{
  this.InFrm = (this.Obj.Identifier) ? true : false;                      // L'oggetto di ingresso e' una WebForm o un Div?
  this.OutFrm = (this.ObjOut && this.ObjOut.Identifier) ? true : false;   // L'oggetto di uscita e' una WebForm o un Div?
  //
  // Dico alle form che sono animate
  if (this.InFrm)
    this.Obj.Animating = true;
  if (this.OutFrm)
    this.ObjOut.Animating = true;
  //
  var s =  this.InFrm ? this.Obj.FormBox.style : this.Obj.style;
  var so = null;
  if (this.ObjOut)
    so = this.OutFrm ? this.ObjOut.FormBox.style : this.ObjOut.style;
  //
  // Posiziono gli oggetti in maniera assoluta in modo da poterli spostare
  // Devo anche gestire il padding di FormsBox, quando li posiziono assolutamente non viene più
  // applicato, quindi lo devo applicare temporaneamente all'oggetto (per la welcome o IE invece devo
  // modificare la larghezza..)
  var pad = RD3_Glb.GetRightPadding(RD3_DesktopManager.WebEntryPoint.FormsBox);
  if (RD3_DesktopManager.WebEntryPoint.MenuType == RD3_Glb.MENUTYPE_MENUBAR)
    pad = pad*2;
  //
  s.position = "absolute";
  if (this.InFrm && !RD3_Glb.IsIE()) {
    s.marginRight = pad + "px";
    s.width = "calc(100% - " + pad + "px)";
  }
  else 
    s.width = "calc(100% - " + pad + "px)";
  if (this.ObjOut) {
    so.position = "absolute";
    if (this.OutFrm && !RD3_Glb.IsIE()) {
      so.marginRight = pad + "px";
      so.width = "calc(100% - " + pad + "px)";
    }
    else 
      so.width = "calc(100% - " + pad + "px)";
  }
  //
  // Gestisco gli overflow
  this.ObjOv = s.overflow;
  s.overflow = "hidden";
  if (this.ObjOut)
  {
    this.ObjOutOv = so.overflow;
    so.overflow = "hidden";
  }
  //
  // Li rendo entrambi visibili
  s.display = "";
  if (this.ObjOut)
    so.display = "";
  //
  // Le animazioni di Fold non le supportiamo
  if (this.Tipo == "fold-h" || this.Tipo == "fold-v")
    this.Tipo = this.Tipo.replace("fold","scroll");
  //
  // Imposto le proprieta' iniziali
  var wk = this.WillBeWebKit();
  var isIe = (RD3_Glb.IsIE() || RD3_Glb.IsFirefox());
  //
  // Inizializzo in base al tipo di animazione
  if (this.Tipo == "fade")
  {
    s.opacity = 0;
    //
    // Se ho un oggetto da fare uscire lo mostro con opacita' minima..
    if (this.ObjOut)
      so.opacity = 1;
  }
  if (this.Tipo == "scroll-v")
  {
    if (this.Flin)
    {
      // Scroll dall'alto al basso
      // Posiziono la form nuova in alto
      this.ObjH = RD3_DesktopManager.WebEntryPoint.FormsBox.offsetHeight;
      this.ObjH -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingTop"));
      this.ObjH -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingBottom"));
      if (wk) {
        if (isIe)
          s.transform = "translate3d(0px, -" + this.ObjH + "px, 0px)";
        else
          s.webkitTransform = "translate3d(0px, -" + this.ObjH + "px, 0px)";
      }
      else
        s.top = "-" + this.ObjH + "px";
    }
    else
    {
      // Scroll dal basso all'alto
      // Posiziono la form nuova in basso
      this.ObjH = RD3_DesktopManager.WebEntryPoint.FormsBox.offsetHeight;
      this.ObjPadding = parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingTop"));
      this.ObjH -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingBottom"));
      if (wk)
      {
        if (isIe)
          s.transform = "translate3d(0px, " + this.ObjH + "px, 0px)";
        else
          s.webkitTransform = "translate3d(0px, " + this.ObjH + "px, 0px)";
        this.ObjH = -this.ObjH;
      }
      else
        s.top = (this.ObjH) + "px";
    }
  }
  if (this.Tipo == "scroll-h")
  {
    if (this.Flin)
    {
      // Scroll dall'dx a sx
      // Posiziono la form nuova a destra
      this.ObjW = RD3_DesktopManager.WebEntryPoint.FormsBox.offsetWidth;
      this.ObjW -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingLeft"));
      this.ObjW -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingRight"));
      if (wk)
      {
        if (isIe)
          s.transform = "translate3d(" + this.ObjW + "px, 0px, 0px)";
        else
          s.webkitTransform = "translate3d(" + this.ObjW + "px, 0px, 0px)";
        this.ObjW = -this.ObjW;
      }
      else
        s.left = (this.ObjW) + "px";
    }
    else
    {
      // Scroll da sx a dx
      // Posiziono la form nuova a sx
      this.ObjW = RD3_DesktopManager.WebEntryPoint.FormsBox.offsetWidth;
      this.ObjW -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingLeft"));
      this.ObjW -= parseFloat(RD3_Glb.GetStyleProp(RD3_DesktopManager.WebEntryPoint.FormsBox, "paddingRight"));
      if (wk) {
        if (isIe)
          s.transform = "translate3d(-" + this.ObjW + "px, 0px, 0px)";
        else
          s.webkitTransform = "translate3d(-" + this.ObjW + "px, 0px, 0px)";
      }
      else
        s.left = "-" + this.ObjW + "px";
    }
  }
  //
  // Faccio l'adapt iniziale per mostrare correttamente i campi
  if(this.InFrm)
  {
    var rec = this.Obj.RecalcLayout;
    this.Obj.StartingFormAnimation();
    this.Obj.RecalcLayout = rec;
    this.StartDate = new Date(); // Istante iniziale : lo reimposto perche' l'adapt e' lento..
  }
}


// ************************************************
// Tick di una animazione di Form
// ************************************************
GFX.prototype.FormTick = function(perc)
{
  // Accedo agli stili necessari (gli oggetti possono essere Div o WebForm)
  var si = this.InFrm ? this.Obj.FormBox.style : this.Obj.style;
  var frsi = this.InFrm ? this.Obj.FramesBox.style : null;
  var so = null;
  var frso = null;
  if (this.ObjOut)
  {
    // Se ho un oggetto da fare uscire accedo ai suoi stili
    so = this.OutFrm ? this.ObjOut.FormBox.style : this.ObjOut.style;
    frso = this.OutFrm ? this.ObjOut.FramesBox.style : null;
  }
  //
  if (this.Tipo == "fade")
  {
    // Applico il fading corretto all'oggetto in entrata
    if (RD3_Glb.IsIE(10, false))
    {
      si.filter = "filter: alpha(opacity = "+Math.floor(perc*100)+");";
      if (frsi)
        frsi.filter = "filter: alpha(opacity = "+Math.floor(perc*100)+");";
    }
    else
    {
      si.opacity = perc;
    }
    //
    // Se ho un oggetto da fare uscire applico il fade inverso a lui
    if (this.ObjOut)
    {
      if (RD3_Glb.IsIE(10, false))
      {
        so.filter = "filter: alpha(opacity = "+Math.floor(100 - (perc*100))+");";
        if (frso)
          frso.filter = "filter: alpha(opacity = "+Math.floor(100 - (perc*100))+");";
      }
      else
      {
        so.opacity = 1 - perc;
      }
    }
  }
  if (this.Tipo == "scroll-v")
  {
    if (this.Flin)
    {
      // Scroll dall'alto al basso
      si.top = "-" + Math.floor(this.ObjH - perc*this.ObjH) + "px";
      if (this.ObjOut)
        so.top = Math.floor(perc*this.ObjH) + "px";
    }
    else
    {
      // Scroll dal basso all'alto
      si.top = Math.floor(this.ObjH - perc*this.ObjH  + this.ObjPadding) + "px";
      if (this.ObjOut)
        so.top = Math.floor(0 - perc*this.ObjH) + "px";
    }
  }
  if (this.Tipo == "scroll-h")
  {
    if (this.Flin)
    {
      // Scroll da dx a sx
      si.left = "-" + Math.floor(this.ObjW - perc*this.ObjW) + "px";
      if (this.ObjOut)
        so.left = Math.floor(perc*this.ObjW) + "px";
    }
    else
    {
      // Scroll da sx a dx
      si.left = Math.floor(this.ObjW - perc*this.ObjW) + "px";
      if (this.ObjOut)
        so.left = Math.floor(0 - perc*this.ObjW) + "px";
    }
  }
  if (this.Tipo == "fold-h")
  {
    if (this.Flin)
    {
      // Fold da dx a sx
      si.width = Math.floor(perc*this.ObjW) + "px";
      si.left = Math.floor(this.ObjW - (perc*this.ObjW)) + "px";
      //
      if (this.ObjOut)
        so.width = Math.floor((1-perc)*this.ObjW) + "px";
    }
    else
    {
      // Fold da sx a dx
      si.width = Math.floor(perc*this.ObjW) + "px";
      if (this.ObjOut)
      {
        so.width = Math.floor((1-perc)*this.ObjW) + "px";
        so.left = Math.floor(perc*this.ObjW) + "px";
      }
    }
  }
  if (this.Tipo == "fold-v")
  {
    if (this.Flin)
    {
      // Fold da up a dn
      si.height = Math.floor(perc*this.ObjH) + "px";
      //
      if (this.ObjOut)
      {
        so.height = Math.floor((1-perc)*this.ObjH) + "px";
        so.top = Math.floor(perc*this.ObjH) + "px";
      }
      //
      var ob = this.InFrm ? this.Obj.FormBox : this.Obj;
      ob.scrollTop = "0px";
    }
    else
    {
      // Fold da dn a up
      si.height = Math.floor(perc*this.ObjH) + "px";
      si.top = Math.floor(this.ObjH - (perc*this.ObjH)  + this.ObjPadding) + "px";
      //
      if (this.ObjOut)
      {
        so.height = Math.floor((1-perc)*this.ObjH) + "px";
      }
    }
  }
}


// ************************************************
// Fine di una animazione di Form
// ************************************************
GFX.prototype.FormFinish = function()
{
  this.InFrm = (this.Obj.Identifier) ? true : false;                      // L'oggetto di ingresso e' una WebForm o un Div?
  this.OutFrm = (this.ObjOut && this.ObjOut.Identifier) ? true : false;   // L'oggetto di uscita e' una WebForm o un Div?
  //
  // Dico alle form che la loro animazione e' finita
  if (this.InFrm)
    this.Obj.Animating = false;
  if (this.OutFrm)
    this.ObjOut.Animating = false;
  // 
  //
  // Accedo agli stili necessari (gli oggetti possono essere Div o WebForm)
  var si = this.InFrm ? this.Obj.FormBox.style : this.Obj.style;
  var frsi = this.InFrm ? this.Obj.FramesBox.style : null;
  var so = null;
  var frso = null;
  if (this.ObjOut)
  {
    so = this.OutFrm ? this.ObjOut.FormBox.style : this.ObjOut.style;
    frso = this.OutFrm ? this.ObjOut.FramesBox.style : null;
  }
  //
  // Se ho animato un oggetto in uscita resetto le sue impostazioni
  if (this.ObjOut)
  {
    so.position = "";
    so.top = "";
    so.left = "";
    if (this.OutFrm && !RD3_Glb.IsIE()) {
      so.marginRight = "";
      so.width = "";
    }
    else
      so.width = "";
    if (this.IsWebKit)
      so.webkitTransform = "";
    if (this.ObjOutOv!=undefined)
      so.overflow = this.ObjOutOv;
    if (RD3_Glb.IsIE(10, false))
    {
      so.removeAttribute("filter");
      if (frso)
        frso.removeAttribute("filter");
    }
    else
    {
      so.opacity=1;
    }
  }
  //
  // Mostro l'oggetto da fare entrare rimuovendo il filtro o togliendo l'opacita'
  if (RD3_Glb.IsIE(10, false))
  {
    si.removeAttribute("filter");
    if (frsi)
      frsi.removeAttribute("filter");
  }
  else
  {
    si.opacity=1;
  }
  //
  // Reimposto la posizione corretta
  si.position = "";
  si.top = "";
  si.left = "";
  if (this.InFrm && !RD3_Glb.IsIE()) {
    si.marginRight = "";
    si.width = "";
  }
  else
    si.width = "";
  if (this.IsWebKit)
    si.webkitTransform = "";
  if (this.ObjOv!=undefined)
    si.overflow = this.ObjOv;
  //
  // Se gli oggetti non sono form (quindi e' il wepbox..) li nascondo o mostro direttamente
  if (!this.OutFrm && this.ObjOut)
    this.ObjOut.style.display = "none";
  if (!this.InFrm)
    this.Obj.style.display = "";
  // 
  // Se sono una animazione di chiusura form devo fare l'unrealize della form ed eliminarla dallo stack
  if (this.CloseFormAnimation && this.ObjOut && this.Classe == "form")
  {
    RD3_DesktopManager.WebEntryPoint.CompleteCloseFormAnimation(this.ObjOut, !this.InForm);
  }
  //
  var wep = RD3_DesktopManager.WebEntryPoint;
  //
  if (this.InFrm)
  {
    wep.ActiveForm = this.Obj;
  }
  else
  {
    wep.ActiveForm = null;
    wep.VisibleForm = null;
  }
  //
  var mustadapt = (this.Tipo == "none" || this.Durata == 0) && (this.Obj != this.ObjOut) ? true : false;
  if (mustadapt && this.Obj && this.InFrm)
    this.Obj.StartingFormAnimation();
  //
  wep.HandleFinishFormAnimation(mustadapt);
}

// ************************************************
// Start dell'animazione di avvio
// ************************************************
GFX.prototype.StartStart = function()
{
  // All'inizio puo' essere attivato un evento di fading sul body
  // Rendo il body completamente trasparente, per ora
  if (RD3_Glb.IsIE(10, false))
    document.body.style.filter = "filter: alpha(opacity = 0);";
  else
    document.body.style.opacity = 0;
}


// ************************************************
// Tick dell'animazione di avvio
// ************************************************
GFX.prototype.StartTick = function(perc)
{
  // All'inizio puo' essere attivato un evento di fading sul body
  // Rendo il body completamente trasparente, per ora
  if (RD3_Glb.IsIE(10, false))
    document.body.style.filter = "filter: alpha(opacity = "+Math.floor(perc*100)+");";
  else
    document.body.style.opacity = perc;  
}


// ************************************************
// Fine dell'animazione di avvio
// ************************************************
GFX.prototype.StartFinish = function()
{
  // All'inizio puo' essere attivato un evento di fading sul body
  // Rendo il body completamente trasparente, per ora
  if (RD3_Glb.IsIE(10, false))
    document.body.style.removeAttribute("filter");
  else
    document.body.style.opacity=1;
  //
  var wep = RD3_DesktopManager.WebEntryPoint;
  if (wep.ActiveForm)
    wep.ActiveForm.Animating = false;
  //
  var nf = wep.StackForm.length;
  for (var t=0;t<nf;t++)
  {
    if (wep.StackForm[t].Docked)
      wep.StackForm[t].Animating = false;
  }
  //
  if (RD3_GFXManager.FocusFldId && RD3_GFXManager.FocusFldId != "")
  {
    RD3_DesktopManager.HandleFocus2(RD3_GFXManager.FocusFldId, RD3_GFXManager.FocusFldRow);
    //
    RD3_GFXManager.FocusFldId = "";
    RD3_GFXManager.FocusFldRow = 0;
  }
}


// ************************************************
// Inizio dell'animazione di fading dei nodi
// ************************************************
GFX.prototype.TreeStart = function()
{
  var s = this.Obj.style;
  s.display = "";  // Metto l'oggetto nel DOM in modo da poterne calcolare l'altezza che deve raggiungere
  //
  this.ObjEndSize = this.Obj.offsetHeight;
  //
  if (this.Flin)
    s.height = "0px";      // Imposto lo stato iniziale
  else
    s.height = this.Obj.offsetHeight+"px";  // Imposto lo stato iniziale: forzo l'altezza da css, se no dando subito l'overflow hidden sfarfalla
  //
  s.overflow = "hidden"; // Siccome devo modificare l'altezza dell'oggetto non voglio che mostri parti interne
}


// ************************************************
// Tick dell'animazione di fading dei nodi
// ************************************************
GFX.prototype.TreeTick = function(perc)
{
  var w = 0;
  var cw = 0;
  if (this.Flin)
  {
    w = Math.floor(this.ObjEndSize*perc);
  }
  else
  {
    w = Math.floor(this.ObjEndSize*(1-perc));
  }
  //
  this.Obj.style.height = w+"px";
}


// ************************************************
// Fine dell'animazione di fading dei nodi
// ************************************************
GFX.prototype.TreeFinish = function()
{
  if (this.StartDate)
  {
    this.Obj.style.overflow = "";
  }
  this.Obj.style.display = this.Flin?"":"none";
  this.Obj.style.height = "";
}

// ************************************************
// Inizio di una animazione di Lista/Dettaglio
// ************************************************
GFX.prototype.ListStart = function()
{
  // Animazione del passaggio da Lista/Dettaglio e viceversa, animazioni supportate:
  // Fade, Scroll, Fold : Flin = true : Lista -> Dettaglio, false: Lista <- Dettaglio 
  // L'oggetto passato e' il Pannello
  // Devo avere tutti e due i layout per l'animazione: se non li ho passo subito in stato finale..
  if (!this.Obj.ListBox || !this.Obj.FormBox)
  {
    this.SetFinished();
    return;
  }
  if ((this.Flin && this.Obj.FormBox.style.display!="none") || (!this.Flin && this.Obj.ListBox.style.display!="none"))
  {
    // Il Layout che mi e' chiesto e' gia' visibile: vado subito in stato finale..
    this.SetFinished();
    return;
  }
  //
  // Rendo visibili tutti e due i Layout
  this.Obj.ListBox.style.display = "";
  this.Obj.FormBox.style.display = "";
  //
  // Bug di IE: devo forzare usando anche la visibility
  var isIe = RD3_Glb.IsIE(); 
  if (isIe) {
    this.Obj.ListBox.style.visibility = "";
    this.Obj.FormBox.style.visibility = "";
  }
  isIe = isIe || RD3_Glb.IsFirefox();
  //
  this.Obj.AnimatingPanel = true;
  var rec = this.Obj.RecalcLayout;
  this.Obj.AlignListHeader();
  this.Obj.AdaptLayout();
  this.StartDate = new Date(); // Istante iniziale : lo reimposto perche' l'adapt e' lento..
  this.Obj.RecalcLayout = rec;
  //
  // Le animazioni di Fold non le supportiamo
  if (this.Tipo == "fold-h" || this.Tipo == "fold-v")
    this.Tipo = this.Tipo.replace("fold","scroll");
  //
  // Impostazioni specifiche per tipo di animazione
  if (this.Tipo == "fade") {
    // Se devo passare in dettaglio do' opacita' 0 al dettaglio e 100 alla lista
    if (this.Flin) {
      this.Obj.FormBox.style.opacity = 0;
      this.Obj.ListBox.style.opacity = 1;
    }
    else {
      // Se devo passare in lista do' opacita' 0 alla lista e 100 al dettaglio
      this.Obj.FormBox.style.opacity = 1;
      this.Obj.ListBox.style.opacity = 0;
    }
  }
  //
  if (this.Tipo == "scroll-h")  {
    // Metto l'overflow hidden al content box
    this.XOver = this.Obj.ContentBox.style.overflowX;
    this.YOver = this.Obj.ContentBox.style.overflowY;
    this.Obj.ContentBox.style.overflowX = "hidden";
    this.Obj.ContentBox.style.overflowY = "hidden";
    //
    // Leggo la dimensione orizzontale di cui scrollare
    this.ObjH = this.Obj.ContentBox.offsetWidth;
    //
    // La lista e' sotto il dettaglio, quindi devo leggerne la dimensione e traslarla in verticale in
    // modo che sia visibile
    this.DetailH = this.Obj.FormBox.offsetHeight;
    //
    // Posiziono i Div nelle posizioni giuste
    if (this.Flin)
    {
      // Detail sulla destra e Lista a 0 (ma sollevata in modo da essere visibile)
      if (isIe) {
        this.Obj.FormBox.style.transform = "translate3d("+this.ObjH+"px, 0px, 0px)";
        this.ObjH = -this.ObjH;
        //
        this.Obj.ListBox.style.transform = "translate3d(0px, -"+this.DetailH+"px, 0px)";
      }
      else {
        this.Obj.FormBox.style.webkitTransform = "translate3d("+this.ObjH+"px, 0px, 0px)";
        this.ObjH = -this.ObjH;
        //
        this.Obj.ListBox.style.webkitTransform = "translate3d(0px, -"+this.DetailH+"px, 0px)";
      }
    }
    else
    {
      // Posiziono la lista sulla sinista
      if (isIe) {
        this.Obj.ListBox.style.transform = "translate3d(-"+this.ObjH+"px, -"+this.DetailH+"px, 0px)";
        this.Obj.FormBox.style.transform = "translate3d(0px, 0px, 0px)";
      }
      else {
        this.Obj.ListBox.style.webkitTransform = "translate3d(-"+this.ObjH+"px, -"+this.DetailH+"px, 0px)";
        this.Obj.FormBox.style.webkitTransform = "translate3d(0px, 0px, 0px)";
      }
    }
  }
  //
  if (this.Tipo == "scroll-v")  {
    // Metto l'overflow hidden al content box
    this.XOver = this.Obj.ContentBox.style.overflowX;
    this.YOver = this.Obj.ContentBox.style.overflowY;
    this.Obj.ContentBox.style.overflowX = "hidden";
    this.Obj.ContentBox.style.overflowY = "hidden";
    //
    // Leggo la dimensione verticale di cui scrollare
    this.ObjH = this.Obj.ContentBox.offsetHeight;
    //
    // Posiziono i Div nelle posizioni giuste
    if (this.Flin)
    {
      // Posiziono il dettaglio sotto
      if (isIe) {
        this.Obj.FormBox.style.transform = "translate3d(0px, "+this.ObjH+"px, 0px)";
        this.Obj.ListBox.style.transform = "translate3d(0px, -"+this.ObjH+"px, 0px)"; 
      }
      else {
        this.Obj.FormBox.style.webkitTransform = "translate3d(0px, "+this.ObjH+"px, 0px)";
        this.Obj.ListBox.style.webkitTransform = "translate3d(0px, -"+this.ObjH+"px, 0px)";
      }
    }
    else
    {
      // Posiziono la lista sopra
      if (isIe) {
        this.Obj.FormBox.style.transform = "translate3d(0px, 0px, 0px)";
        this.Obj.ListBox.style.transform = "translate3d(0px, -"+(this.ObjH*2)+"px, 0px)";
      }
      else {
        this.Obj.FormBox.style.webkitTransform = "translate3d(0px, 0px, 0px)";
        this.Obj.ListBox.style.webkitTransform = "translate3d(0px, -"+(this.ObjH*2)+"px, 0px)";
      }
    }
  }
  //
  // Devo forzare il reflow per far applicare bene il translate, 
  // altrimenti lo applica troppo tardi e l'animazione va in diagonale..
  var tmp = this.Obj.ListBox.offsetHeight;
}


// ************************************************
// Tick di una animazione di Lista/Dettaglio
// ************************************************
GFX.prototype.ListTick = function(perc)
{
  if (this.Tipo == "fade")
  {
    // Uso un Fade in due Fasi: nel primo 50% faccio il fading out, nel restante faccio il fading In
    if (this.Flin)
    {
      if (perc<0.5)
      {
        // Faccio il fading out della lista, raddoppiando la percentuale..
        if (RD3_Glb.IsIE(10, false))
          this.Obj.ListBox.style.filter = "filter: alpha(opacity = "+Math.floor(100-((perc*2)*100))+");";
        else
          this.Obj.ListBox.style.opacity = 1 - (perc*2);
      }
      else
      {
        // Faccio il fading in del dettaglio: per sicurezza forzo a 0 la lista..
        if (RD3_Glb.IsIE(10, false))
          this.Obj.ListBox.style.filter = "filter: alpha(opacity = 0);";
        else
          this.Obj.ListBox.style.opacity = 0;
        //
        if (RD3_Glb.IsIE(10, false))
          this.Obj.FormBox.style.filter = "filter: alpha(opacity = "+Math.floor(perc*100)+");";
        else
          this.Obj.FormBox.style.opacity = perc;
      }
    }
    else
    {
      if (perc<0.5)
      {
        // Faccio il fading out del dettaglio, raddoppiando la percentuale..
        if (RD3_Glb.IsIE(10, false))
          this.Obj.FormBox.style.filter = "filter: alpha(opacity = "+Math.floor(100-((perc*2)*100))+");";
        else
          this.Obj.FormBox.style.opacity = 1 - (perc*2);
      }
      else
      {
        // Faccio il fading in della lista: per sicurezza forzo a 0 il dettaglio..
        if (RD3_Glb.IsIE(10, false))
          this.Obj.FormBox.style.filter = "filter: alpha(opacity = 0);";
        else
          this.Obj.FormBox.style.opacity = 0;
        //
        if (RD3_Glb.IsIE(10, false))
          this.Obj.ListBox.style.filter = "filter: alpha(opacity = "+Math.floor(perc*100)+");";
        else
          this.Obj.ListBox.style.opacity = perc;
      }
    }
  }
  //
  if (this.Tipo == "scroll-h")
  {
    if (this.Flin)
    {
      this.Obj.FormBox.style.left = this.ObjH*(1-perc) + "px";
      this.Obj.ListBox.style.left = 0 - this.ObjH*perc + "px";
    }
    else
    {
      this.Obj.FormBox.style.left = this.ObjH*perc + "px";
      this.Obj.ListBox.style.left = 0 - this.ObjH*(1-perc) + "px";
    }
  }
  //
  if (this.Tipo == "scroll-v")
  {
    if (this.Flin)
    {
      this.Obj.FormBox.style.top = this.ObjH*(1-perc) + "px";
      this.Obj.ListBox.style.top = 0 - this.ObjH*perc + "px";
    }
    else
    {
      this.Obj.FormBox.style.top = this.ObjH*perc + "px";
      this.Obj.ListBox.style.top = 0 - this.ObjH*(1-perc) + "px";
    }
  }
  //
  if (this.Tipo == "fold-h")
  {
    if (this.Flin)
    {
      // Restringo la lista
      this.Obj.ListBox.style.width= this.ObjH - (perc*this.ObjH) + "px";
      //
      // Allargo il dettaglio e lo sposto indietro per riprendere lo spazio
      this.Obj.FormBox.style.width = (perc*this.ObjH) + "px";
      this.Obj.FormBox.style.left = this.ObjH - (perc*this.ObjH) + "px";
    }
    else
    {
      // Allargo la lista
      this.Obj.ListBox.style.width = (perc*this.ObjH) + "px";
      //
      // Restringo il dettaglio e lo sposto a sinistra
      this.Obj.FormBox.style.width = this.ObjH - (perc*this.ObjH) + "px";
      this.Obj.FormBox.style.left = (perc*this.ObjH) + "px";
    }
  }
  //
  if (this.Tipo == "fold-v")
  {
    if (this.Flin)
    {
      // Restringo la lista
      this.Obj.ListBox.style.height= this.ObjH - (perc*this.ObjH) + "px";
      //
      // Allargo il dettaglio e lo sposto sopra per riprendere lo spazio
      this.Obj.FormBox.style.height = (perc*this.ObjH) + "px";
      this.Obj.FormBox.style.top = this.ObjH - (perc*this.ObjH) + "px";
    }
    else
    {
      // Allargo la lista
      this.Obj.ListBox.style.height = (perc*this.ObjH) + "px";
      //
      // Restringo il dettaglio e lo sposto sotto
      this.Obj.FormBox.style.height = this.ObjH - (perc*this.ObjH) + "px";
      this.Obj.FormBox.style.top = (perc*this.ObjH) + "px";
    }
  }
}


// ************************************************
// Fine di una animazione di Lista/Dettaglio
// ************************************************
GFX.prototype.ListFinish = function()
{
  // Impostazione per webkit
  if (this.ObjH<0)
    this.ObjH = -this.ObjH;
  //
  // Ora rendo visibile il layout giusto
  if (this.Obj.HasList && this.Obj.ListBox)
  {
    var s = this.Obj.ListBox.style;
    s.display = (this.Obj.PanelMode==RD3_Glb.PANEL_LIST) ? "" : "none";
    //
    // Tolgo il filtro del fading
    if (RD3_Glb.IsIE(10, false))
      s.removeAttribute("filter");
    else
      s.opacity=1;
    //
    // Rimetto le posizioni giuste
    if (this.IsWebKit)
      s.transform = "";
    s.left = "";
    s.top = "";    
  }
  if (this.Obj.HasForm && this.Obj.FormBox)
  {
    var s = this.Obj.FormBox.style;
    s.display = (this.Obj.PanelMode==RD3_Glb.PANEL_FORM) ? "" : "none";
    //
    // Tolgo il filtro del fading
    if (RD3_Glb.IsIE(10, false))
      s.removeAttribute("filter");
    else
      s.opacity=1;
    //
    // Posiziono correttamente gli oggetti
    if (this.IsWebKit)
      s.transform = "";
    s.left = "";
    s.top = "";
  }
  //
  // Ripristino gli overflow corretti
  // ma solo se li ho modificati (quindi se ho saltato l'animazione non faccio nulla)
  var cs = this.Obj.ContentBox.style;
  if (this.Durata != 0 && this.Tipo != "none") 
  {
    if (this.XOver)
      cs.overflowX = this.XOver;
    else
      cs.overflowX = "";
    //
    if (this.YOver)
      cs.overflowY = this.YOver;
    else
      cs.overflowY = "";
  }
  //
  this.Obj.AnimatingPanel = false;
  //
  // Al termine devo adattare il layout e mostrare i valori se arrivo qui in maniera immediata
  // Non spingo un SetActual qui perche' chi la usa in modo immediato
  // deve poi farlo lui e sarebbe una duplicazione
  if (this.Durata == 0 || this.Tipo == "none")
  {
    if (this.Immediate)
      this.Obj.AdaptLayout();
    else
      this.Obj.RecalcLayout = true;
  }
  //
  // A volte, sembra non bastare l'impostazione della proprieta' style.display...
  // Occorre forzare! (e' un bug di IE)
  if (RD3_Glb.IsIE())
  {
    if (this.Obj.PanelMode==RD3_Glb.PANEL_LIST && !this.Obj.Realizing)
    {
      this.Obj.FormBox.style.visibility = "hidden";
      this.Obj.ListBox.style.visibility = "";
    }
    if (this.Obj.PanelMode==RD3_Glb.PANEL_FORM && !this.Obj.Realizing)
    {
      this.Obj.FormBox.style.visibility = "";
      this.Obj.ListBox.style.visibility = "hidden";
    }
  }
  //
  this.Obj.ResetPosition = true;
  this.Obj.RefreshToolbar = true;
}


// **************************************************
// Start dell'animazione delle pagine del book
// **************************************************
GFX.prototype.BookStart = function()
{
  // Se non ho nessun oggetto da animare finisco subito l'animazione
  if (!this.Obj && !this.ObjOut)
  {
    this.SetFinished();
    return; 
  }
  //
  // Metto a hidden l'overflow del contenitore delle pagine,  selezionando l'oggetto disponibile
  this.ParentStyle = this.Obj ? this.Obj.ParentBook.ContentBox.style : this.ObjOut.ParentBook.ContentBox.style;
  this.OverX =  this.ParentStyle.overflowX;
  this.OverY =  this.ParentStyle.overflowY;
  this.ParentStyle.overflowX = "hidden";
  this.ParentStyle.overflowY = "hidden";
  //
  // Rendo visibili le pagine
  if (this.Obj)
  {
    this.ObjStyle = this.Obj.PageBox.style;
    this.ObjStyle.display = "";
    this.ObjStyle.zIndex = "20"; // Alzo l'indice della in ingresso, in modo che sia sempre visibile sopra quella vecchia e quella entrante
  }
  if (this.ObjOut)
  {
    this.ObjOutStyle = this.ObjOut.PageBox.style;
    this.ObjOutStyle.display = "";
    this.ObjOutStyle.zIndex = "19";
  }
  //
  // Se non ho mai fatto l'adapt iniziale lo faccio ora, in modo da fare comparire la pagina gia' con le box posizionate
  if (this.Obj && !this.Obj.Adapted)
    this.Obj.AdaptLayout();
  // 
  // Impostazioni specifiche per animazione
  if (this.Tipo == "fade")
  {
    // Metto a 0 l'opacita' della pagina da fare entrare e a 1 quella della pagina da fare uscire (se c'e')
    if (this.Obj)
    {
      if (RD3_Glb.IsIE(10, false))
        this.ObjStyle.filter = "filter: alpha(opacity = 0);";
      else
        this.ObjStyle.opacity = 0;
    }
    //
    if (this.ObjOut)
    {
      if (RD3_Glb.IsIE(10, false))
        this.ObjOutStyle.filter = "filter: alpha(opacity = 100);";
      else
        this.ObjOutStyle.opacity = 1;
    }
  }
  //
  if (this.Tipo == "fold")
    this.Tipo = "scroll";
  //
  if (this.Tipo == "scroll")
  {
    // Leggo le dimensioni degli oggetti coinvolti
    var bookw = this.Obj ? this.Obj.ParentBook.ContentBox.offsetWidth : this.ObjOut.ParentBook.ContentBox.offsetWidth;
    var newpgw = this.Obj ? this.Obj.PageBox.offsetWidth : this.ObjOut.PageBox.offsetWidth;
    var oldpgw = this.ObjOut ? this.ObjOut.PageBox.offsetWidth : newpgw;
    //
    // Decido la dimensione di cui scrollare
    // Se entrambe le pagine sono piu' piccole del book scrollo della dimensione del book
    if (newpgw < bookw  && oldpgw<bookw)
    {
      this.ObjW = bookw;
    }
    else
    {
      // Se devo scrollare da sinistra la dimensione di cui scrollare e' quella nuova, altrimenti e' quella vecchia
      this.ObjW = this.Flin ? newpgw : oldpgw;
    }
    //
    if (this.Obj)
    {
      var isIe = (RD3_Glb.IsIE() || RD3_Glb.IsFirefox());
      if (this.Flin)
      {
        // Posiziono la nuova pagina a sinistra
        if (this.WillBeWebKit()){
          if (isIe)
            this.ObjStyle.transform = "translate3d(-" + this.ObjW + "px, 0px, 0px)";
          else
            this.ObjStyle.webkitTransform = "translate3d(-" + this.ObjW + "px, 0px, 0px)";
        }
        else
          this.ObjStyle.left = "-" + this.ObjW + "px";
      }
      else
      {
        // Posiziono la nuova pagina a destra
        if (this.WillBeWebKit())
        {
          if (isIe)
            this.ObjStyle.transform = "translate3d(" + this.ObjW + "px, 0px, 0px)";
          else
            this.ObjStyle.webkitTransform = "translate3d(" + this.ObjW + "px, 0px, 0px)";
          this.ObjW = -this.ObjW;
        }
        else
          this.ObjStyle.left = this.ObjW + "px";
      }
    }
  }
  //
  this.StartDate = new Date(); // Istante iniziale : lo reimposto per dare fluidita' all'animazione
}


// **************************************************
// Tick dell'animazione delle pagine del book
// **************************************************
GFX.prototype.BookTick = function(perc)
{
  if (this.Tipo == "fade")
  {
    var percout = perc;
    var percin = perc;
    //
    // Se ho una pagina da nascondere per la prima parte della transizione nascondo lei e basta
    if (this.ObjOut)
    {
      percout = 1-(perc);
    }
    //
    if (this.Obj)
    {
      if (RD3_Glb.IsIE(10, false))
        this.ObjStyle.filter = "filter: alpha(opacity = "+(percin*100)+");";
      else
        this.ObjStyle.opacity = percin;
    }
    //
    if (this.ObjOut)
    {
      if (RD3_Glb.IsIE(10, false))
        this.ObjOutStyle.filter = "filter: alpha(opacity = "+(percout*100)+");";
      else
        this.ObjOutStyle.opacity = percout;
    }
  }
  if (this.Tipo == "scroll")
  {
    if (this.Flin)
    {
      // Sposto a destra la vecchia pagina se c'e'
      if (this.ObjOut)
      {
        this.ObjOutStyle.left = (this.ObjW*perc) + "px";
      }
      //
      // Sposto a destra la nuova pagina
      if (this.Obj)
        this.ObjStyle.left = 0 - (this.ObjW * (1-perc)) + "px";
    }
    else
    {
      // Sposto a sinistra la vecchia pagina (se presente)
      if (this.ObjOut)
      {
        this.ObjOutStyle.left = 0 - (this.ObjW*perc) + "px";
      }
      // Sposto a sinistra la nuova pagina
      if (this.Obj)
        this.ObjStyle.left = this.ObjW * (1-perc) + "px";
    }
  }
  if (this.Tipo == "fold")
  {
    if (this.Flin)
    {
      // Allargo la nuova pagina a sinistra
      if (this.Obj)
        this.ObjStyle.width = (perc*this.ObjW) + "px";
      //
      // Restringo la vecchia pagina e la sposto a destra
      if (this.ObjOut)
      {
        this.ObjOutStyle.width = ((1-perc)*this.ObjW) + "px";
        this.ObjOutStyle.left = (perc*this.ObjW) + "px";
      }
    }
    else
    {
      // Allargo la nuova pagina e la sposto a sinistra
      if (this.Obj)
      {
        this.ObjStyle.width = (perc*this.ObjW) + "px";
        this.ObjStyle.left = ((1-perc)*this.ObjW) + "px";
      }
      //
      // Restringo la vecchia pagina
      if (this.ObjOut)
        this.ObjOutStyle.width = ((1-perc)*this.ObjW) + "px";
    }
  }
}


// **************************************************
// Fine dell'animazione delle pagine del book
// **************************************************
GFX.prototype.BookFinish = function()
{
  // Se non ho nessun oggetto da animare finisco subito l'animazione
  if (!this.Obj && !this.ObjOut)
    return; 
  //
  // Se sono arrivato qui senza aver fatto lo start accedo agli stili che mi servono
  if (!this.ParentStyle)
    this.ParentStyle = this.Obj ? this.Obj.ParentBook.ContentBox.style : this.ObjOut.ParentBook.ContentBox.style;
  if (!this.ObjStyle && this.Obj)
    this.ObjStyle = this.Obj.PageBox.style;
  if (!this.ObjOutStyle && this.ObjOut)
    this.ObjOutStyle = this.ObjOut.PageBox.style;
  //
  if (this.ObjOut)
  {
    // Nascondo la vecchia pagina
    this.ObjOut.SetActive(false);
    //
    // Tolgo il filtro
    if (RD3_Glb.IsIE(10, false))
      this.ObjOutStyle.removeAttribute("filter");
    else
      this.ObjOutStyle.opacity=1;
    //
    this.ObjOutStyle.zIndex = "";
    this.ObjOutStyle.left = "";
    if (this.IsWebKit)
      this.ObjOutStyle.webkitTransform = "";
    //
    this.ObjOutStyle.overflow = this.OldPagOv ? this.OldPagOv : "";
    if (this.ObjOutW)
      this.ObjOutStyle.width = this.ObjOutW;
  }
  //
  if (this.Obj)
  {
    // Tolgo il filtro
    if (RD3_Glb.IsIE(10, false))
      this.ObjStyle.removeAttribute("filter");
    else
      this.ObjStyle.opacity=1;
    //
    this.ObjStyle.zIndex = "";
    this.ObjStyle.left = "";
    if (this.IsWebKit)
      this.ObjStyle.webkitTransform = "";
    this.ObjStyle.overflow = this.NewPagOv ? this.NewPagOv : "";
    //
    if (this.UnrealizeOnFinish)
    {
      // In questo caso Obj non e' la vera pagina: durante l'animazione il server ne ha mandata un altra che ha preso il suo posto,
      // Obj quindi alla fine dell'animazione deve scomparire e fare comparire la pagina vera.. pero' devo fare adattare la pagina vera prima di cancellare
      // la vecchia copia, altrimenti per un istante compare la pagina bianca..
      var ps = this.Obj.ParentBook.Pages[this.Obj.ParentBook.SelectedPage];
      ps.SetActive(true);
      ps.AdaptLayout();
      //
      this.Obj.UnrealizeDelayed();
    }
    else
    {
      // Mostro la pagina
      this.Obj.SetActive(true);
    }
  }
  //
  // Ripristino l'overflow del book
  this.ParentStyle.overflowX = this.OverX ? this.OverX : "";
  this.ParentStyle.overflowY = this.OverY ? this.OverY : "";
  //
  // Aggiorno la caption del book
  var parbook = this.Obj ? this.Obj.ParentBook : this.ObjOut.ParentBook;
  parbook.SetCaption();
  parbook.AnimatingNum = null;
  parbook.Fx = null;
  //
  // Annullo i riferimenti
  this.ParentStyle = null;
  this.ObjStyle = null;
  this.ObjOutStyle = null;
  this.Obj = null;
  this.ObjOut = null;
}

// ***************************************************************
// Start dell'animazione di redirect dell'applicazione
// ***************************************************************
GFX.prototype.RedirectStart = function()
{
  
}


// ***************************************************************
// Tick dell'animazione di redirect dell'applicazione
// ***************************************************************
GFX.prototype.RedirectTick = function(perc)
{
  if (RD3_Glb.IsIE(10, false))
    document.body.style.filter = "filter: alpha(opacity = "+Math.floor(100 -(perc*100))+");";
  else
    document.body.style.opacity = 1 - perc;
}


// ***************************************************************
// Fine dell'animazione di redirect dell'applicazione
// ***************************************************************
GFX.prototype.RedirectFinish = function()
{
  // Chiudo la finestra se mi sono arrivati !!! 
  if (this.Url == "!!!")
  {
    // Usiamo qualche trucco
    if (RD3_Glb.IsIE())
      window.open('','_parent','');   // IE non chiede piu' conferma
    else if (RD3_Glb.IsChrome() || RD3_Glb.IsSafari())
      window.open('', '_self', '');   // Chrome e Safari chiudono la pagina
    //
    window.close();
    return;
  }
  document.location.assign(this.Url);
}


// ***************************************************************
// Start dell'animazione di comparsa o scomparsa del preview Frame
// ***************************************************************
GFX.prototype.PreviewStart = function()
{
  // Accedo agli stili necessari all'animazione
  if (this.Obj.Frames[0].FrameBox)
  {
    this.FrSty = this.Obj.Frames[0].FrameBox.style;
  }
  else
  {
    this.Fr1sty = this.Obj.Frames[0].ChildBox1.style;
    this.Fr2sty = this.Obj.Frames[0].ChildBox2.style;
  }
  this.Presty = this.Obj.PreviewFrame.FrameBox.style;
  //
  // Animazione di ingresso
  if (this.Flin)
  {
    // Per prima cosa rendo visibile il contenuto originale e lo sovrappongo alla preview
    if (this.Obj.Frames[0].FrameBox)
    {
      this.FrSty.display = "";
    }
    else
    {
      this.Fr1sty.display = "";
      this.Fr2sty.display = "";
    }
    //
    if (this.Tipo == "fade")
    {
      // Posiziono in alto il previewframe
      this.Presty.top = "0px";
      //
      // Metto al Preview Frame Opacita' 0 per renderlo invisibile
      if (RD3_Glb.IsIE(10, false))
        this.Presty.filter = "filter: alpha(opacity = 0);";
      else
        this.Presty.opacity = 0;
    }
    //
    if (this.Tipo == "scroll")
    {
      // Posiziono in alto il previewframe
      this.Presty.top = "0px";
      //
      // Modifico la toolbar: la posiziono in alto e con zindex 10 in modo che il contenuto gli passi sotto 
      // e non sopra
      this.ToolSty = this.Obj.PreviewFrame.ToolbarBox.style;
      this.ToolSty.zIndex = 10;
      this.ToolSty.position = "absolute";
      this.ToolSty.top = "0px";
      this.ToolH = this.Obj.PreviewFrame.ToolbarBox.offsetHeight;
      //
      // In ingresso posiziono il preview frame sopra il contenuto originale
      this.ObjH = this.Obj.PreviewFrame.ContentBox.offsetHeight;
      //
      // Accedo allo stile del contenuto : faro' lo scroll di quello
      this.Presty = this.Obj.PreviewFrame.ContentBox.style;
      //
      this.Presty.top = "-" + (this.ObjH + this.ToolH)  + "px";
      this.Ofx = this.Presty.overflowX;
      this.Ofy = this.Presty.overflowY;
      //
      // Tolgo la scrollbar se no su ffx viene male
      this.Presty.overflowX = "hidden";
      this.Presty.overflowY = "hidden";
      //
      this.Presty.backgroundColor = RD3_Glb.GetStyleProp(this.Obj.FormBox, "backgroundColor");
    }
    //
    if (this.Tipo == "fold")
    {
      // Posiziono in alto il previewframe
      this.Presty.top = "0px";
      //
      // Leggo la dimensione da raggiungere
      this.ObjH = this.Obj.PreviewFrame.ContentBox.offsetHeight;
      //
      // Accedo allo stile del contenuto : faro' il fold di quello
      this.Presty = this.Obj.PreviewFrame.ContentBox.style;
      //
      // Metto a 0 l'altezza del contenuto
      this.Presty.height = "0px";
      //
      this.Presty.backgroundColor = RD3_Glb.GetStyleProp(this.Obj.FormBox, "backgroundColor");
    }
  }
  else  // Animazione di uscita
  {
    // Per prima cosa rendo visibile il contenuto originale
    if (this.Obj.Frames[0].FrameBox)
    {
      this.FrSty.display = "";
    }
    else
    {
      this.Fr1sty.display = "";
      this.Fr2sty.display = "";
    }
    //
    if (this.Tipo == "fade")
    {
      // Mantengo posizionato in alto il previewframe
      this.Presty.top = "0px";
      //
      // Nascondo il contenuto originario
      if (this.Obj.Frames[0].FrameBox)
      {
        if (RD3_Glb.IsIE(10, false))
          this.FrSty.filter = "filter: alpha(opacity = 0);";
        else
          this.FrSty.opacity = 0;
      }
      else
      {
        if (RD3_Glb.IsIE(10, false))
        {
          this.Fr1sty.filter = "filter: alpha(opacity = 0);";
          this.Fr2sty.filter = "filter: alpha(opacity = 0);";
        }
        else
        {
          this.Fr1sty.opacity = 0;
          this.Fr2sty.opacity = 0;
        }
      }
    }
    //
    if (this.Tipo == "scroll")
    {
      // Sposto il contenuto e non la toolbar!
      this.Presty = this.Obj.PreviewFrame.ContentBox.style;
      //
      // Modifico la toolbar: la posiziono in alto e con zindex 10 in modo che il contenuto gli passi sotto 
      // e non sopra
      this.ToolSty = this.Obj.PreviewFrame.ToolbarBox.style;
      this.ToolSty.zIndex = 10;
      this.ToolSty.position = "absolute";
      this.ToolSty.top = "0px";
      this.ToolH = this.Obj.PreviewFrame.ToolbarBox.offsetHeight;
      //
      // Leggo la dimensione del Preview Frame
      this.ObjH = this.Obj.PreviewFrame.ContentBox.offsetHeight;
      //
      this.Ofx = this.Presty.overflowX;
      this.Ofy = this.Presty.overflowY;
      //
      // Tolgo la scrollbar se no su ffx viene male
      this.Presty.overflowX = "hidden";
      this.Presty.overflowY = "hidden";
      //
      this.Presty.backgroundColor = RD3_Glb.GetStyleProp(this.Obj.FormBox, "backgroundColor");
    }
    //
    if (this.Tipo == "fold")
    {
      // Posiziono in alto il previewframe
      this.Presty.top = "0px";
      //
      // Leggo la dimensione attuale
      this.ObjH = this.Obj.PreviewFrame.ContentBox.offsetHeight;
      //
      // Accedo allo stile del contenuto : faro' il fold di quello
      this.Presty = this.Obj.PreviewFrame.ContentBox.style;
      //
      this.Presty.backgroundColor = RD3_Glb.GetStyleProp(this.Obj.FormBox, "backgroundColor");
    }
  }  
}


// ***************************************************************
// Tick dell'animazione di comparsa o scomparsa del preview Frame
// ***************************************************************
GFX.prototype.PreviewTick = function(perc)
{  
  if (this.Tipo == "fade")
  {
    if (this.Flin)
    {
      // Aumento la visibilita' del PreviewFrame
      if (RD3_Glb.IsIE(10, false))
        this.Presty.filter = "filter: alpha(opacity = " + 100*perc + ");";
      else
        this.Presty.opacity = perc;
      //
      // Nascondo gli altri frame
      if (this.Obj.Frames[0].FrameBox)
      {
        if (RD3_Glb.IsIE(10, false))
          this.FrSty.filter = "filter: alpha(opacity = " + (100 - (100*perc)) + ");";
        else
          this.FrSty.opacity = 1 - perc;
      }
      else
      {
        if (RD3_Glb.IsIE(10, false))
        {
          this.Fr1sty.filter = "filter: alpha(opacity = " + (100 - (100*perc)) + ");";
          this.Fr2sty.filter = "filter: alpha(opacity = " + (100 - (100*perc)) + ");";
        }
        else
        {
          this.Fr1sty.opacity = 1 - perc;
          this.Fr2sty.opacity = 1 - perc;
        }
      }
    }
    else
    {
      // Diminuisco la visibilita' del PreviewFrame
      if (RD3_Glb.IsIE(10, false))
        this.Presty.filter = "filter: alpha(opacity = " + (100 - (100*perc)) + ");";
      else
        this.Presty.opacity = 1 - perc;
      //
      // Mostro gli altri frame
      if (this.Obj.Frames[0].FrameBox)
      {
        if (RD3_Glb.IsIE(10, false))
          this.FrSty.filter = "filter: alpha(opacity = " + 100*perc + ");";
        else
          this.FrSty.opacity = perc;
      }
      else
      {
        if (RD3_Glb.IsIE(10, false))
        {
          this.Fr1sty.filter = "filter: alpha(opacity = " + 100*perc + ");";
          this.Fr2sty.filter = "filter: alpha(opacity = " + 100*perc + ");";
        }
        else
        {
          this.Fr1sty.opacity = perc;
          this.Fr2sty.opacity = perc;
        }
      }
    }
  }
  //
  if (this.Tipo == "scroll")
  {
    if (this.Flin)
    {
      this.Presty.top = ((0 - ((1-perc)*this.ObjH)) + this.ToolH) + "px";
    }
    else
    {
      this.Presty.top = ((0 - (perc*this.ObjH)) + this.ToolH) + "px";
    }
  }
  //
  if (this.Tipo == "fold")
  {
    if (this.Flin)
    {
      this.Presty.height = (perc*this.ObjH) + "px";
    }
    else
    {
      this.Presty.height = (this.ObjH - (perc*this.ObjH)) + "px";
    }
  }
}


// ***************************************************************
// Fine dell'animazione di comparsa o scomparsa del preview Frame
// ***************************************************************
GFX.prototype.PreviewFinish = function()
{
  if (this.Durata == 0 || this.Tipo == "none")
  {
    // Ho saltato lo start: accedo qui a tutti gli stili necessari
    if (this.Obj.Frames[0].FrameBox)
    {
      this.FrSty = this.Obj.Frames[0].FrameBox.style;
    }
    else
    {
      this.Fr1sty = this.Obj.Frames[0].ChildBox1.style;
      this.Fr2sty = this.Obj.Frames[0].ChildBox2.style;
    }
    //
    if (this.Tipo == "fade") 
      this.Presty = this.Obj.PreviewFrame.FrameBox.style;
    else
      this.Presty = this.Obj.PreviewFrame.ContentBox.style;
    //
    this.ToolSty = this.Obj.PreviewFrame.ToolbarBox.style;
    this.ToolH = this.Obj.PreviewFrame.ToolbarBox.offsetHeight;
  }
  //
  //
  if (this.IsWebKit)
    this.Obj.PreviewFrame.ContentBox.style.webkitTransform = "";
  //
  if (this.Flin)
  {
    // Nascondo gli altri frame
    if (this.Obj.Frames[0].FrameBox)
    {
      this.FrSty.display = "none";
    }
    else
    {
      this.Fr1sty.display = "none";
      this.Fr2sty.display = "none";
    }
    //
    if (this.Tipo == "fade")
    {
      // Rimuovo l'opacita' ed i filtri da tutti gli elementi
      if (RD3_Glb.IsIE(10, false))
        this.Presty.removeAttribute("filter");
      else
        this.Presty.opacity=1;
      //
      if (this.Obj.Frames[0].FrameBox)
      {
        if (RD3_Glb.IsIE(10, false))
          this.FrSty.removeAttribute("filter");
        else
          this.FrSty.opacity=1;
      }
      else
      {
        if (RD3_Glb.IsIE(10, false))
        {
          this.Fr1sty.removeAttribute("filter");
          this.Fr2sty.removeAttribute("filter");
        }
        else
        {
          this.Fr1sty.opacity=1;
          this.Fr2sty.opacity=1;
        }
      }
    }
    //
    if (this.Tipo == "scroll")
    {
      if (this.Ofx)
        this.Presty.overflowX = this.Ofx;
      if (this.Ofy)
        this.Presty.overflowY = this.Ofy;
      this.Presty.top = this.ToolH + "px";
      this.Presty.backgroundColor = "";
      //
      this.ToolSty.zIndex = 0;
      this.ToolSty.position = "";
      this.ToolSty.top = "";
    }
    //
    if (this.Tipo == "fold")
    {
      this.Presty.backgroundColor = "";
    }
    //
    this.Obj.RecalcLayout = false;
  }
  else
  {
    // Faccio riapparire il frame zero
    if (this.Obj.Frames[0].FrameBox)
    {
      this.Obj.Frames[0].FrameBox.style.display = "";
    }
    else
    {
      this.Obj.Frames[0].ChildBox1.style.display = "";
      this.Obj.Frames[0].ChildBox2.style.display = "";
    }
    //
    // Distruggo il form di preview
    this.Obj.PreviewFrame.Unrealize();
    //
    // Lo tolgo dall'array dei frames
    var n = this.Obj.Frames.length;
    for (var i=0;i<n;i++)
    {
      if (this.Obj.Frames[i]==this.Obj.PreviewFrame)
      {
        this.Obj.Frames.splice(i,1);
        break;
      }
    }
    //
    this.Obj.PreviewFrame = null;
    //
    if (this.Tipo == "fade")
    {
      // Rimuovo l'opacita' ed i filtri da tutti gli elementi
      if (this.Obj.Frames[0].FrameBox)
      {
        if (RD3_Glb.IsIE(10, false))
          this.FrSty.removeAttribute("filter");
        else
          this.FrSty.opacity=1;
      }
      else
      {
        if (RD3_Glb.IsIE(10, false))
        {
          this.Fr1sty.removeAttribute("filter");
          this.Fr2sty.removeAttribute("filter");
        }
        else
        {
          this.Fr1sty.opacity=1;
          this.Fr2sty.opacity=1;
        }
      }
    }
  }
  //
  // Ora rimuovo tutti i riferimenti..
  this.Presty = null;
  this.FrSty = null;
  this.Fr1sty = null;
  this.Fr2sty = null;
}


// ***************************************************************
// Inizio dell'animazione del Tooltip
// ***************************************************************
GFX.prototype.TooltipStart = function()
{
  // Supporta solo l'animazione fade, Flin da' la direzione del fade: true fading in , false fading out e chiusura
  //
  // Se devo far comparire il Tooltip per prima cosa lo faccio aprire
  if (this.Flin)
  {
    this.Obj.Open();
    //
    // Se sono su IE devo inscatolare il Tooltip dentro un altro div, altrimenti per un suo baco i bordi non
    // compaiono finche' non tolgo il filtro (calcola il bounding box basandosi solo sul div, mentre i bordi sono fuori..)
    if (RD3_Glb.IsIE(10, false))
    {
      var ttsty = this.Obj.PopupBox.style;
      this.Ttop = parseInt(ttsty.top, 10);
      this.Tleft = parseInt(ttsty.left, 10);
      this.Twidth = parseInt(ttsty.width, 10);
      this.Theight = parseInt(ttsty.height, 10);
      //
      // Creo il div di inscatolamento e lo posiziono un po' piu' in alto a sinistra (in modo da contenere il baffo..) e un po' piu' largo..
      this.Wraptt = document.createElement("DIV");
      var sty = this.Wraptt.style;
      //
      // Decido la dimensione di cui allargare il DIV: 
      // Altezza o larghezza massima baffo + dimensione bordo + distanza bordo baffo
      var offs = (this.Obj.WhiskerBase>this.Obj.WhiskerHeight) ? this.Obj.WhiskerBase : this.Obj.WhiskerHeight;
      offs += (this.Obj.BorderRoundWidth + this.Obj.WhiskerOffset);
      //
      sty.top = (this.Ttop-offs)+"px";
      sty.left = (this.Tleft-offs)+"px";
      sty.width = (this.Twidth + (offs*2)) + "px";
      sty.height = (this.Theight + (offs*2)) + "px";
      sty.position = "absolute";
      //
      // Riparento e riposiziono il tooltip..
      ttsty.top = offs + "px";
      ttsty.left = offs + "px";
      //
      // Il tooltip deve stare sopra a tutto
      this.Wraptt.style.zIndex = 200;
      //
      this.Wraptt.appendChild(this.Obj.PopupBox);
      document.body.appendChild(this.Wraptt);
    }
    //
    // Mi memorizzo un riferimento allo stile che mi serve per fare l'animazione
    this.ObjStyle = RD3_Glb.IsIE(10, false) ? this.Wraptt.style : this.Obj.PopupBox.style;
    //
    // Ora lo rendo invisibile
    if (RD3_Glb.IsIE(10, false))
      this.ObjStyle.filter = "filter: alpha(opacity = 0);";
    else
      this.ObjStyle.opacity = 0;
  }
  else
  {
    // Se sono su IE devo inscatolare il Tooltip dentro un altro div, altrimenti per un suo baco i bordi non
    // compaiono finche' non tolgo il filtro (calcola il bounding box basandosi solo sul div, mentre i bordi sono fuori..)
    if (RD3_Glb.IsIE(10, false))
    {
      var ttsty = this.Obj.PopupBox.style;
      this.Ttop = parseInt(ttsty.top, 10);
      this.Tleft = parseInt(ttsty.left, 10);
      this.Twidth = parseInt(ttsty.width, 10);
      this.Theight = parseInt(ttsty.height, 10);
      //
      // Creo il div di inscatolamento e lo posiziono un po' piu' in alto a sinistra (in modo da contenere il baffo..) e un po' piu' largo..
      this.Wraptt = document.createElement("DIV");
      var sty = this.Wraptt.style;
      //
      // Decido la dimensione di cui allargare il DIV: 
      // Altezza o larghezza massima baffo + dimensione bordo + distanza bordo baffo
      var offs = (this.Obj.WhiskerBase>this.Obj.WhiskerHeight) ? this.Obj.WhiskerBase : this.Obj.WhiskerHeight;
      offs += (this.Obj.BorderRoundWidth + this.Obj.WhiskerOffset);
      //
      sty.top = (this.Ttop-offs)+"px";
      sty.left = (this.Tleft-offs)+"px";
      sty.width = (this.Twidth + (offs*2)) + "px";
      sty.height = (this.Theight + (offs*2)) + "px";
      sty.position = "absolute";
      //
      // Riparento e riposiziono il tooltip..
      ttsty.top = offs + "px";
      ttsty.left = offs + "px";
      //
      // Il tooltip deve stare sopra a tutto
      this.Wraptt.style.zIndex = 200;
      //
      this.Wraptt.appendChild(this.Obj.PopupBox);
      document.body.appendChild(this.Wraptt);
    }
    //
    // Mi memorizzo un riferimento allo stile che mi serve per fare l'animazione
    this.ObjStyle = RD3_Glb.IsIE(10, false) ? this.Wraptt.style : this.Obj.PopupBox.style;
  }
}

// ***************************************************************
// Tick dell'animazione del Tooltip
// ***************************************************************
GFX.prototype.TooltipTick = function(perc)
{
  // Decido la percentuale in base alla direzione dell'animazione
  var percanim = this.Flin ? perc : (1-perc);
  //
  if (RD3_Glb.IsIE(10, false))
    this.ObjStyle.filter = "filter: alpha(opacity = "+Math.floor(percanim*100)+");";
  else
    this.ObjStyle.opacity = percanim;
}


// ***************************************************************
// Fine dell'animazione del Tooltip
// ***************************************************************
GFX.prototype.TooltipFinish = function()
{
  if (this.Flin)
  {
    // Se ho saltato lo start e devo far comparire il Tooltip faccio qui l'open
    if (this.Durata == 0 || this.Tipo == "none")
    {
      this.Obj.Open();
      this.ObjStyle = this.Obj.PopupBox.style;
    }
    else
    {
      // Se sono su IE oltre a togliere il filtro devo togliere dal DOM il nuovo div e rirpristinare il ttoltip
      if (RD3_Glb.IsIE(10, false))
      {
        var ttsty = this.Obj.PopupBox.style;
        //
        // Riparento e riposiziono il tooltip..
        ttsty.top = this.Ttop + "px";
        ttsty.left = this.Tleft + "px";
        //
        document.body.removeChild(this.Wraptt);
        document.body.appendChild(this.Obj.PopupBox);
        //
        this.Wraptt = null;
        this.ObjStyle = this.Obj.PopupBox.style;
      }
    }
    //
    // Tolgo il filtro o l'opacita'
    if (RD3_Glb.IsIE(10, false))
      this.ObjStyle.removeAttribute("filter");
    else
      this.ObjStyle.opacity=1;
  }
  else
  {
    // Se sono su IE oltre a togliere il filtro devo togliere dal DOM il nuovo div e rirpristinare il ttoltip
    if (RD3_Glb.IsIE(10, false) && !(this.Durata == 0 || this.Tipo == "none"))
    {
      var ttsty = this.Obj.PopupBox.style;
      //
      // Riparento e riposiziono il tooltip..
      ttsty.top = this.Ttop + "px";
      ttsty.left = this.Tleft + "px";
      //
      document.body.removeChild(this.Wraptt);
      document.body.appendChild(this.Obj.PopupBox);
      //
      this.Wraptt = null;
      this.ObjStyle = this.Obj.PopupBox.style;
    }
    //
    // Se ho animato tolgo l'opacita' e il filtro
    if (!(this.Durata == 0 || this.Tipo == "none"))
    {
      // Tolgo il filtro o l'opacita'
      if (RD3_Glb.IsIE(10, false))
        this.ObjStyle.removeAttribute("filter");
      else
        this.ObjStyle.opacity=1;
    }
    //
    // Chiudo il Tooltip
    this.Obj.Close();
  }
}


// ***************************************************************
// Inizio dell'animazione della combo
// ***************************************************************
GFX.prototype.ComboStart = function()
{
  // Apertura della combo
  if (this.Flin)
  {
    // Mi memorizzo la dimensione finale, il top e la posizione della scrollbar
    this.ObjH = this.Obj.ComboPopup.offsetHeight;
    this.ObjT = this.Obj.ComboPopup.offsetTop;
    this.ObjScr = this.Obj.ComboPopup.scrollTop;
    //
    // Minimizzo il Popup e nascondo le scrollbar
    this.Obj.ComboPopup.style.height = "0px";
    this.Obj.ComboPopup.style.overflow = "hidden";
    //
    // Se il popup e' sopra il valore sposto il top del popup
    if (this.Obj.ComboUpper)
     this.Obj.ComboPopup.style.top = this.ObjT + this.ObjH + "px";
  }
  else  // Chiusura della combo
  {
    // Mi memorizzo la dimensione iniziale, il top e la posizione della scrollbar
    this.ObjH = this.Obj.ComboPopup.offsetHeight;
    this.ObjT = this.Obj.ComboPopup.offsetTop;
    this.ObjScr = this.Obj.ComboPopup.scrollTop;
    //
    // Nascondo le scrollbar
    this.Obj.ComboPopup.style.overflow = "hidden";
  }
  //
  this.Obj.AnimatingCombo = true;
}


// ***************************************************************
// Tick dell'animazione della combo
// ***************************************************************
GFX.prototype.ComboTick = function(perc)
{
  // Se la combo e' stata "ricostruita" abbandono l'animazione
  // Nei book puo' capitare a causa del differenziatore...
  if (!this.Obj.ComboUpper && !this.Obj.ComboPopup)
    return;
  //
  // Apertura della combo
  if (this.Flin)
  {
    if (this.Tipo=="scroll")
    {
      if (this.Obj.ComboUpper)
      {
        this.Obj.ComboPopup.style.height = (perc*this.ObjH)+"px";
        this.Obj.ComboPopup.style.top = this.ObjT + Math.floor((1-perc)*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr;
      }
      else
      {
        this.Obj.ComboPopup.style.height = (perc*this.ObjH)+"px";
        //
        // Sotto Firefox non posso andare a modificare lo scrolltop, se no sfarfalla ed e' orribile..
        // quind sotto ffx il comportamento di scroll e fold e' uguale..
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr + Math.floor((1-perc)*this.ObjH);
      }
    }
    if (this.Tipo=="fold")
    {
      if (this.Obj.ComboUpper)
      {
        this.Obj.ComboPopup.style.height = (perc*this.ObjH)+"px";
        this.Obj.ComboPopup.style.top = this.ObjT + Math.floor((1-perc)*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr + Math.floor((1-perc)*this.ObjH);
      } 
      else
      {
        this.Obj.ComboPopup.style.height = (perc*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr;
      }
    }
  }
  else  // Chiusura della combo
  {
    if (this.Tipo=="scroll")
    {
      if (this.Obj.ComboUpper)
      {
        this.Obj.ComboPopup.style.height = ((1-perc)*this.ObjH)+"px";
        this.Obj.ComboPopup.style.top = this.ObjT + Math.floor(perc*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr;
      }
      else
      {
        this.Obj.ComboPopup.style.height = ((1-perc)*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr + Math.floor(perc*this.ObjH);
      }
    }
    if (this.Tipo=="fold")
    {
      if (this.Obj.ComboUpper)
      {
        this.Obj.ComboPopup.style.height = ((1-perc)*this.ObjH)+"px";
         this.Obj.ComboPopup.style.top = this.ObjT + Math.floor(perc*this.ObjH)+"px";
         //
         if (!RD3_Glb.IsFirefox(3))
           this.Obj.ComboPopup.scrollTop = this.ObjScr + Math.floor(perc*this.ObjH); 
      }
      else
      {
        this.Obj.ComboPopup.style.height = ((1-perc)*this.ObjH)+"px";
        //
        if (!RD3_Glb.IsFirefox(3))
          this.Obj.ComboPopup.scrollTop = this.ObjScr;
      }
    }
  }
}


// ***************************************************************
// Fine dell'animazione della combo
// ***************************************************************
GFX.prototype.ComboFinish = function()
{
  // Se la combo e' stata "ricostruita" abbandono l'animazione
  // Nei book puo' capitare a causa del differenziatore...
  if (!this.Obj.ComboPopup)
    return;
  //
  // Apertura della combo
  if (this.Flin)
  {
    // Ripristino il Popup e nascondo le scrollbar
    this.Obj.ComboPopup.style.overflow = "";
    this.Obj.AdaptPopupLayout(true);
    //
    // Mi assicuro che l'item selezionato sia visibile
    //this.Obj.EnsureItemVisible();
    //
    // Se non l'ho ancora fatto, avvio il timer di riposizionamento
    if (!this.Obj.ComboPopupTimer)
      this.Obj.ComboPopupTimer = window.setInterval(new Function("ev","return RD3_DesktopManager.CallEventHandler('"+this.Obj.Identifier+"', 'OnTimerTick', ev, true)"), 250);
  }
  else  // Chiusura della combo
  {
    // Ripristino l'overflow e le dimensioni
    this.Obj.ComboPopup.style.height = "";
    this.Obj.ComboPopup.style.overflow = "";
    //
    // Nascondo la combo
    this.Obj.ComboPopup.style.display = "none";
  }
  //
  this.Obj.AnimatingCombo = false;
}


// ************************************************
// Dato lo stile "s", ne imposta il timing
// tramite webkit
// ************************************************
GFX.prototype.SetWebKitTiming = function(s)
{
  if (RD3_Glb.IsIE() || RD3_Glb.IsFirefox())
    s.transitionDuration = this.Durata + "ms";
  else
    s.webkitTransitionDuration = this.Durata + "ms";
  //
  if (!this.WebKitStyles)
    this.WebKitStyles = new Array();
  this.WebKitStyles.push(s);
}


// ************************************************
// Resetta le proprieta' di transizione delle
// animazioni webkit
// ************************************************
GFX.prototype.ResetWebKitTiming = function(s)
{
  if (this.WebKitStyles)
  {
    var i=0;
    for (i=0;i<this.WebKitStyles.length;i++)
    {
      this.WebKitStyles[i].transitionProperty = "";
      this.WebKitStyles[i].transitionDuration = "";
      this.WebKitStyles[i].transitionDelay = "";
      //
      this.WebKitStyles[i].webkitTransitionProperty = "";
      this.WebKitStyles[i].webkitTransitionDuration = "";
      this.WebKitStyles[i].webkitTransitionDelay = "";
    }
    this.WebKitStyles = null;
  }
}


// ***************************************************************
// Fine dell'animazione tramite webkit
// ***************************************************************
GFX.prototype.OnEndAnimation = function(ev)
{
  if (this.IsFinished())
    return;
  //
  if (this.IsMyAnimation(ev))
  {
    if (this.TargetObj)
      RD3_Glb.RemoveEndTransaction(this.TargetObj, RD3_GFXManager.OnEndAnimation, false);
    delete this.TargetObj;
    // Sembra che la fine ritardata non sia di grande utilizzo
    // concludo l'animazione... fra qualche istante
    //if (this.Classe!="tab")
    //  this.WebkitTick = 4;
    //else
    this.SetFinished();
    //
    // e indico che ero io
    return true;
  }
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.IsMyAnimation = function(ev)
{
  if (this.Obj == ev.target || (this.Obj && this.TargetObj == ev.target))
    return true;
  //
  return false;
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.StartWebKit = function()
{
  if (!RD3_ClientParams.UseWebKitGFX)
    return;
  //
  switch(this.Classe)
  {
    case "start":
      this.WebKitOpacityStart(1, this.Obj, true);
    break;

    case "redirect":
      this.WebKitOpacityStart(0, this.Obj, true);
    break;

    case "form":
      this.WebKitFormStart();
    break;

    case "list":
      this.WebKitListStart();
    break;
    
    case "book":
      this.WebKitBookStart();
    break;
    
    case "tooltip":
      this.WebKitOpacityStart(this.Flin?"1":"0", this.Obj.PopupBox, true);
    break;
    
    case "preview":
      this.WebKitPreviewStart();
    break;
  }
}


// ***************************************************************
// Torna TRUE se l'animazione sara' gestita tramite webkit
// Solo alcuni tipi hanno il problema di saperlo prima...
// ***************************************************************
GFX.prototype.WillBeWebKit = function()
{
  if (!RD3_ClientParams.UseWebKitGFX || RD3_Glb.IsIE(10, false))
    return;
  //
  switch(this.Classe)
  {
    case "start":
      if (true == true)
        return true;
    break;

    case "form":
      if (this.Tipo == "scroll-h" || this.Tipo == "scroll-v")
        return true;
    break;
    
    case "list":
      if (this.Tipo == "scroll-h" || this.Tipo == "scroll-v")
        return true;
    break;
    
    case "book":
      if (this.Obj && this.ObjOut && this.Tipo == "scroll")
        return true;
    break;
    
   case "preview":
      if (this.Tipo == "scroll")
        return true;
    break;
  }
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitOpacityStart = function(op, obj, seteve)
{
  if (!obj)
    return;
  //
  // Segnalo che l'animazione sara' gestita tramite webkit
  this.IsWebKit = true;
  //
  // Attacco l'evento all'oggetto body
  if (seteve)
  {
    RD3_Glb.RemoveEndTransaction(obj, RD3_GFXManager.OnEndAnimation, false);
    RD3_Glb.AddEndTransaction(obj, RD3_GFXManager.OnEndAnimation, false);
    this.TargetObj = obj;
  }
  //
  var s = obj.style;
  //
  // Imposto le proprieta' di trasformazione della opacita'
  if (RD3_Glb.IsIE())
    s.transitionProperty="opacity";
  else
    s.webkitTransitionProperty="opacity";
  this.SetWebKitTiming(s);
  s.opacity = op;
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitTranslateStart = function(obj, seteve, directionX, val)
{
  if (directionX)
    this.InitWebKitTranslate(obj, seteve, val, 0);
  else
    this.InitWebKitTranslate(obj, seteve, 0, val);
}

GFX.prototype.InitWebKitTranslate = function(obj, seteve, valX, valY)
{
  if (!obj)
    return;
  //
  // Segnalo che l'animazione sara' gestita tramite webkit
  this.IsWebKit = true;
  var ie = (RD3_Glb.IsIE() || RD3_Glb.IsFirefox());
  //
  // Attacco l'evento all'oggetto body
  if (seteve)
  {
    RD3_Glb.RemoveEndTransaction(obj, RD3_GFXManager.OnEndAnimation, false);
    RD3_Glb.AddEndTransaction(obj, RD3_GFXManager.OnEndAnimation, false);
    this.TargetObj = obj;
  }
  //
  var s = obj.style;
  //
  // Imposto le proprieta' di trasformazione del posizionamento
  if (ie)
    s.transitionProperty="transform";
  else
    s.webkitTransitionProperty="transform";
  this.SetWebKitTiming(s);
  if (ie)
    s.transform = "translate3d(" + (valX ? valX : "0") + "px, " + (valY ? valY : "0") + "px, 0px)";
  else
    s.webkitTransform = "translate3d(" + (valX ? valX : "0") + "px, " + (valY ? valY : "0") + "px, 0px)";
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitFormStart = function()
{
  if (this.WillBeWebKit()) {
    var obj = this.InFrm ? this.Obj.FormBox : this.Obj;
    //
    var objout = null;
    if (this.ObjOut)
      objout = this.OutFrm ? this.ObjOut.FormBox : this.ObjOut;
    //
    var prop = (this.Tipo == "scroll-h")? true : false;
    var val = (this.Tipo == "scroll-h")? this.ObjW:this.ObjH;
    //
    if (objout)
      this.WebKitTranslateStart(objout, false, prop, val);
    //
    this.WebKitTranslateStart(obj, true, prop, 0);
  }
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitListStart = function()
{
  if (this.WillBeWebKit()) {
    var o1 = (this.Flin)?this.Obj.FormBox:this.Obj.ListBox;
    var o2 = (this.Flin)?this.Obj.ListBox:this.Obj.FormBox;
    //
    // Gestione animazione
    if (this.Tipo == "scroll-h") {
      this.InitWebKitTranslate(o2, false, this.ObjH, (o2 === this.Obj.ListBox ? -this.DetailH : 0));
      this.InitWebKitTranslate(o1, true, 0, (o1 === this.Obj.ListBox ? -this.DetailH : 0));
    }
    else {
      this.InitWebKitTranslate(o2, false, 0, this.ObjH);
      this.InitWebKitTranslate(o1, true, 0, 0);
    }
  }
}


// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitBookStart = function()
{
  if (this.WillBeWebKit())
  {
    // Gestione animazione
    if (this.ObjOut)
      this.WebKitTranslateStart(this.ObjOut.PageBox, false, true, this.ObjW);
    if (this.Obj)
      this.WebKitTranslateStart(this.Obj.PageBox, true, true, 0);
  }
}

// ***************************************************************
// Inizio animazione tramite webkit (se si puo')
// ***************************************************************
GFX.prototype.WebKitPreviewStart = function()
{
  if (this.WillBeWebKit())
  {
    var h = this.Flin?this.ObjH+2*this.ToolH:-this.ObjH-2*this.ToolH;
    this.WebKitTranslateStart(this.Obj.PreviewFrame.ContentBox, true, false, h);
  }
}
