
function IDdxDataGrid(pform){
  CustomElement.call(this, pform);
}

IDdxDataGrid.prototype = new CustomElement();
IDdxDataGrid.Init = function() {
  if(IDdxDataGrid.inited){
    return
  }
  IDdxDataGrid.inited = true;
}

IDdxDataGrid.Init();

Object.defineProperty(IDdxDataGrid.prototype, "data", {
  get: function () {
    return this._data;
  },
  set: function (configuration) {
    this._data = configuration.data;

    // easly access the properties passed through data -> configuration
    this.datasource = configuration.data.datasource;
    this.columns = configuration.data.columns;
    this.editing = configuration.data.editing;
    this.filters = configuration.data.filters;
    this.DivID = configuration.data.DivID;
    if(this.dataGrid){
      this.Realize(IDdxDataGrid.Realize, IDdxDataGrid.cls);}
    else {
      if(IDdxDataGrid.Realize){
        this.Realize(IDdxDataGrid.Realize, IDdxDataGrid.cls);
      }
    }
  }
});



IDdxDataGrid.prototype.Realize = function (parent, cls) {
  // wait for _data to proceed and void reinit all 
  var readyToProceed = this._data && IDdxDataGrid.inited;
  if(readyToProceed){
    CustomElement.prototype.Realize.call(this, parent, cls);

    var pthis = this;
    
    // temp div to use is "myDataGridId", we should pass it
    var divIdToUseForDataGrid = this.DivID;
    this.dataGridDiv = document.createElement("div");
    this.dataGridDiv.setAttribute("id", divIdToUseForDataGrid);
    parent.appendChild(this.dataGridDiv);
    
    this.storedParent = parent;

    DevExpress.localization.locale('it');


    // Inizializza il dxDataGrid
    window.setTimeout( function () {
      this.dataGrid = new DevExpress.ui.dxDataGrid("#"+ this.DivID, {
        dataSource: this.datasource,
        editing: this.editing,
        columns: this.columns,
        columnAutoWidth: true,
        showBorders: true,
        allowColumnResizing: true,
        columnResizingMode: 'nextColumn',
        searchPanel: {
          visible: true,
        },

        // setup filters
        filterRow: this.filters.filterRow,
        filterPanel: this.filters.filterPanel,
        headerFilter: this.filters.headerFilter,

        // events that we can easly handle 
        onEditingStart() {
          console.log('EditingStart');
        },
        onInitNewRow() {
          console.log('InitNewRow');
        },
        onRowInserting() {
          console.log('RowInserting');
        },
        onRowInserted() {
          console.log('RowInserted');
        },
        onRowUpdating() {
          console.log('RowUpdating');
        },
        onRowUpdated() {
          console.log('RowUpdated');
        },
        onRowRemoving() {
          console.log('RowRemoving');
        },
        onRowRemoved() {
          console.log('RowRemoved');
        },
        onSaving() {
          console.log('Saving');
        },
        onSaved() {
          console.log('Saved');
        },
        onEditCanceling() {
          console.log('EditCanceling');
        },
        onEditCanceled() {
          console.log('EditCanceled');
        }, 
      });
    }.bind(this), 500);
    this.dxDataGrid = $('#' + this.DivID).dxDataGrid("instance");
  }
  else{
    IDdxDataGrid.Realize = parent;
    IDdxDataGrid.cls = cls;
  }
}

IDdxDataGrid.prototype.setLocale   = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

IDdxDataGrid.prototype.Unrealize = function ()
{
  if (this.dataGrid)
    this.dataGrid.dispose();
  delete this.dataGrid;
  if(this.dataGridDiv){
    if (this.dataGridDiv.parentNode)
      this.dataGridDiv.parentNode.removeChild(this.dataGridDiv);
    delete this.dataGridDiv;
  }
}

/*
  custom button prototype

function customButtonCommand(buttonID,eventID){
  console.log("CLICCAMI has been pressed: "+ eventID);
  RD3_SendCommand("@button@button=" + buttonID + ";Event="+ eventID);
}
*/