// ************************************************
// Instant Developer RD3 Framework for Bootstrap
// (c) 1999-2016 Pro Gamma Srl - All rights reserved
//
// Classe TabbedView: gestisce una serie di frame
// in modalita' Tabbed
// ************************************************

function TabbedView(pform)
{
  // Chiamo il costruttore superiore
  WebFrame.call(this,pform); 
  //
  // Proprieta' di questo oggetto di modello
  this.SelectedPage = 0;         // Indice della pagina selezionata
  this.Placement = 0;           // Posizione delle linguette (Non modificabile a RunTime)
  this.HiddenTabs = false;      // Mostrare le linguette? (Toolbar)
  this.AutoSize = false;        // Dimensionare la tab come pagina mostrata attualmente
  this.Tabs = new Array();      // Array delle Pagine interne
  this.OnlyTabs = false;        // Se True la TabbedView si dimensionera' in modo da mostrare solo le Tab
  //
  // Struttura per la definizione degli eventi di questa tabbed
  this.ClickEventDef = RD3_Glb.EVENT_ACTIVE; // Click su una tab  
  //
  // Variabili di collegamento con il DOM
  this.Realized = false; // Se vero, gli oggetti del DOM sono gia' stati creati
}
//
// Definisco l'estensione della classe
TabbedView.prototype = new WebFrame();


// *******************************************************************
// Inizializza questo oggetto leggendo i dati da un nodo XML
// *******************************************************************
TabbedView.prototype.LoadFromXml = function(node) 
{
  // Chiamo la classe base
  WebFrame.prototype.LoadFromXml.call(this,node);
  //
  // Carico le tab
  var objlist = node.childNodes;
  var n = objlist.length;
  //
  // Ciclo su tutti i nodi che rappresentano oggetti figli
  for (var i=0; i<n; i++) 
  {
    var objnode = objlist.item(i);
    var nome = objnode.nodeName;
    //
    // In base al tipo di oggetto, invio il messaggio di caricamento
    switch (nome)
    {
      case "tab":
      {
        // Leggo il nodo di primo livello, e poi passo il messaggio
        // di caricamento
        var newtab = new Tab(this);
        newtab.LoadFromXml(objnode);
        this.Tabs.push(newtab);
        //
        // Se sono gia' stata realizzata, realizzo subito la pagina
        if (this.Realized) {
          newtab.Realize(this.ContentBox, this.TabListContainer);
          this.SetPlacement();
          //
          // Se dovevo selezionare questa tab, lo faccio ora che e' arrivata
          if (this.DelayedSelPage < this.Tabs.length) {
            this.SetSelectedPage();
            this.DelayedSelPage = undefined;
          }
        }
      }
      break;
    }
  }
}


// **********************************************************************
// Esegue un evento di change che riguarda le proprieta' di questo oggetto
// **********************************************************************
TabbedView.prototype.ChangeProperties = function(node)
{
  // Semplicemente setto le proprieta' a partire dal nodo + verifico oggetti figli, come nuove pagine
  this.LoadFromXml(node);
}


// **************************************************************
// Inizializza le proprieta' di questo oggetto leggendole dal
// nodo xml arrivato.
// **************************************************************
TabbedView.prototype.LoadProperties = function(node)
{
  // Chiamo la classe base
  WebFrame.prototype.LoadProperties.call(this,node);
  //
  // Ciclo su tutti gli attributi del nodo
  var attrlist = node.attributes;
  var n = attrlist.length;
  for (var i=0; i<n; i++)
  {
    var attrnode = attrlist.item(i);
    var nome = attrnode.nodeName;
    var valore = attrnode.nodeValue;
    //
    switch(nome)
    {
      case "sel": this.SetSelectedPage(parseInt(attrnode.nodeValue) - 1); break;
      case "pla": this.SetPlacement(parseInt(attrnode.nodeValue)); break;
      case "hid": this.SetHiddenTabs(attrnode.nodeValue == "1"); break;
      case "asz": this.SetAutoSize(attrnode.nodeValue == "1"); break;

      case "clk": this.ClickEventDef = parseInt(attrnode.nodeValue); break;

      case "cpa": this.ChangePageAnimDef = valore; break;

      case "id": 
        this.Identifier = valore;
        RD3_DesktopManager.ObjectMap.add(valore, this);
      break;
    }
  }
}


// *******************************************************************
// Setter delle proprieta'
// *******************************************************************
TabbedView.prototype.SetSelectedPage= function(value, skipAnim) 
{
  if (skipAnim == undefined)
    skipAnim = false;
  //
  var old = this.SelectedPage;
  if (value!=undefined)
    this.SelectedPage = value; // Nel server l'array inizia da 1
  //
  if (this.Realized && (old!=this.SelectedPage || value==undefined))
  { 
    // Se il server ha richiesto una pagina che non c'e'... forse deve ancora arrivare
    // Mi ricordo che quando arriva devo selezionare la pagina!
    if (this.SelectedPage >= this.Tabs.length)
    {
      this.DelayedSelPage = this.SelectedPage;
      return;
    }
    //
    // Trovo la Tab attualmente selezionata
    var sel = null;
    var n = this.Tabs.length;
    var pos = 0;
    for (var i=0; i<n; i++) {
      if(this.Tabs[i].Selected)
        sel = this.Tabs[i];
    }
    //
    // Il server e' 1-based, noi siamo 0-based. Se il server dice "pagina 0" intende "nessuna pagina" e a noi arriva value=-1
    if (this.SelectedPage != -1)
      this.Tabs[this.SelectedPage].SelectPage(true);
    //
    if (sel) {
      // Se necessario nascondo la pagina attualmente selezionata andando in uno stato 'completamente vuoto'
      if (this.SelectedPage == -1) {
        RD3_Glb.RemoveClass(sel.ContentBox, "active");
        RD3_Glb.RemoveClass(sel.CaptionBox, "active");
      }
      //
      sel.Selected = false;
    }
  }
}

TabbedView.prototype.SetPlacement= function(value) 
{
  if (value!=undefined)
    this.Placement = value;
}

TabbedView.prototype.SetHiddenTabs= function(value) 
{
  if (value!=undefined)
    this.HiddenTabs = value;
  //
  if (this.Realized)
    this.ToolbarBox.style.display = this.HiddenTabs ? "none" : "";
}

TabbedView.prototype.SetAutoSize= function(value) 
{
  if (value!=undefined)
    this.AutoSize = value;
  //
  if (this.Realized)
  {
    // TODO
  }
}

TabbedView.prototype.SetOnlyTabs= function(value) 
{
  if (value!=undefined)
    this.OnlyTabs = value;
}

// *******************************************************************
// Setter delle proprieta' ridefinite (ridefiniscono i metodi base,
// che darebbero errore in caso di tabbed perche' non esistono
// gli oggetti)
// *******************************************************************

TabbedView.prototype.SetCollapsible= function(value) 
{
  // Proprieta' non gestita in una Tabbed
  if (value!=undefined)
    this.Collapsible = value;
}

TabbedView.prototype.SetCollapsed= function(value) 
{
  // Proprieta' non gestita in una Tabbed
  if (value!=undefined)
    this.Collapsed = value;
}

TabbedView.prototype.SetImage= function(value) 
{
  // Proprieta' non gestita in una Tabbed
  if (value!=undefined)
    this.Image = value;
}

TabbedView.prototype.SetCaption= function(value) 
{
  // Proprieta' non gestita in una Tabbed
  if (value!=undefined)
    this.Caption = value;
}

TabbedView.prototype.SetSmallIcon= function(value) 
{
  // Proprieta' non gestita in una Tabbed
  if (value!=undefined)
    this.SmallIcons = value;
}

TabbedView.prototype.SetVisible = function(value)
{
  // Chiamo il metodo base
  WebFrame.prototype.SetVisible.call(this, value);
  //
  // Adatto la toolbar adesso che sono visibile
  if (this.Realized && !this.HiddenTabs && this.Visible)
    window.setTimeout(function() {
      this.AdaptToolbarHeight();
    }.bind(this), 0);
}

// ***************************************************************
// Crea gli oggetti DOM utili a questo oggetto
// L'oggetto parent indica all'oggetto dove devono essere contenuti
// i suoi oggetti figli nel DOM
// ***************************************************************
TabbedView.prototype.Realize = function(parent)
{
  // Chiamo la classe base
  if (!this.Realized)
    WebFrame.prototype.Realize.call(this,parent);
  this.ToolbarBox.className = this.ToolbarBox.className + " tabbed-view-header-box";
  this.ContentBox.className = this.ContentBox.className + " tab-content tabbed-view-content-box";
  this.FrameBox.className += " tabbed-view-frame-box";
  //
  // Faccio realizzare i miei figli nella pagina contenitore
  var n = this.Tabs.length;
  for (var i=0; i<n; i++)
    this.Tabs[i].Realize(this.ContentBox, this.TabListContainer);
  //
  // Inizializzazione iniziale
  this.Realized = true;
  this.SetSelectedPage();
  this.SetPlacement();
  this.SetHiddenTabs();
  this.SetAutoSize();
}


// *****************************************************************
// Rimuove gli oggetti dom e i riferimenti di questo oggetto perche'
// sta per essere distrutto
// *****************************************************************
TabbedView.prototype.Unrealize = function()
{
  // Chiamo la classe base
  WebFrame.prototype.Unrealize.call(this);
  //
  // Passo il messaggio anche alle Tab che cosi' possono gestire i subframes
  var n = this.Tabs.length;
  for (var i=0; i<n; i++)
  {
    this.Tabs[i].Unrealize();
  }
}


// ***************************************************************
// Crea gli oggetti DOM relativi alla Toolbar della Tabbed
// ***************************************************************
TabbedView.prototype.RealizeToolbar = function()
{
  // Creo solo il contenitore esterno delle Tabbed, tutto il resto verra' fatto dalla
  // realize delle Tab
  this.ToolbarBox = document.createElement("div");
  this.ToolbarBox.setAttribute("id", "tl:" + this.Identifier);
  this.ToolbarBox.className = "panel-heading";
  //
  this.TabListContainer = document.createElement("ul");
  this.TabListContainer.className = "nav nav-"+ (this.Style=== "pills" ? "pills" : "tabs");
  this.TabListContainer.setAttribute("role", "tablist"); 
  this.ToolbarBox.appendChild(this.TabListContainer);
  //
  this.FrameBox.appendChild(this.ToolbarBox);
}


// *******************************************************************
// Ritorna l'indice di una tabbed
// *******************************************************************
TabbedView.prototype.FindTabIndex= function(tab) 
{
  var n = this.Tabs.length;
  for (var i=0; i<n; i++)
    if (this.Tabs[i]==tab)
      return i;
  //
  return -1;
}


// ********************************************************************************
// Devo gestire le variazioni avvenute
// ********************************************************************************
TabbedView.prototype.AfterProcessResponse= function()
{ 
  // Chiamo la classe base
  WebFrame.prototype.AfterProcessResponse.call(this);
  //
  // Passo il messaggio anche alle Tab
  var n = this.Tabs.length;
  for (var i=0;i<n;i++)
    this.Tabs[i].AfterProcessResponse();
}


// ********************************************************************************
// Torna il frame attualmente visibile
// ********************************************************************************
TabbedView.prototype.GetSelectedFrame= function()
{
  var t = this.Tabs[this.SelectedPage];
  if (t)
    return t.Content;
  return null;
}


// *********************************************************
// E' arrivato un click a livello di frame
// *********************************************************
TabbedView.prototype.OnFrameClick = function(evento, dbl, btn, x, y, xb, yb, tget)
{
}

// ********************************************************************************
// Compone la lista di drop per le pagine
// ********************************************************************************
TabbedView.prototype.ComputeDropList = function(list, dragobj)
{
  // Se non sono stato realizzato ... niente DropList
  if (!this.Realized)
    return;
  //
  if (!this.CanDrop)
    return;
  //
  list.push(this);
  //
  // Calcolo le coordinate assolute...
  var o = this.ToolbarBox;
  this.AbsLeft = RD3_Glb.GetScreenLeft(o,true);
  this.AbsTop = RD3_Glb.GetScreenTop(o,true);
  if (!RD3_Glb.IsIE())
  {
    // Sugli altri browser devo tenere conto della scrollbar...
    this.AbsLeft -= this.ToolbarBox.scrollLeft;
    this.AbsTop -= this.ToolbarBox.scrollTop;
  }
  //
  this.AbsRight = this.AbsLeft + o.offsetWidth - 1;
  this.AbsBottom = this.AbsTop + o.offsetHeight - 1;
  //
  // Giro su tutte le pagine e lo chiedo a loro
  var n = this.Tabs.length;
  for (var i = 0; i<n; i++)
  {
    this.Tabs[i].ComputeDropList(list, dragobj);
  }
}

TabbedView.prototype.OnMouseUp = function(evento)
{
  
}

TabbedView.prototype.OnMouseDown = function(evento)
{
}

TabbedView.prototype.GetContentOffset = function()
{ 
  if (this.Placement == RD3_Glb.TABOR_BOTTOM || this.Placement == RD3_Glb.TABOR_TOP)
    return this.ToolbarBox.offsetHeight;
  //
  return 0;
}

// ********************************************************************************
// Indica quanto il contenuto deve essere piu' stretto del frame.. (per tabbed 
// verticali)
// ********************************************************************************
TabbedView.prototype.GetHContentOffset = function()
{ 
  if (this.Placement == RD3_Glb.TABOR_RIGHT || this.Placement == RD3_Glb.TABOR_LEFT)
  {
    var ret = this.ToolbarBox.offsetHeight;
    //
    // Devo farlo perche' magari il display e' stato messo a none ma ancora le dimensioni non sono state aggiornate..
    if (this.ToolbarBox.style.display == "none")
      ret = 0;
    //
    return ret;
  }
  //
  return 0;
}

TabbedView.prototype.CalcGridLayout = function()
{
  // Chiamo il metodo base
  WebFrame.prototype.CalcGridLayout.call(this);
  //
  // Adesso devo gestire le pagine: il loro contenuto se è realizzato deve essere dimensionato al 100% se il resize è STRETCH
  var n = this.Tabs.length;
  for (var i=0; i<n; i++)
    this.Tabs[i].CalcGridLayout();
};

TabbedView.prototype.OnViewportResize = function()
{
  this.AdaptToolbarHeight();
  //
  if (this.Realized && this.Tabs && this.Tabs.length > 0)
    for (var i=0; i < this.Tabs.length; i++)
      this.Tabs[i].OnViewportResize();
};

TabbedView.prototype.AdaptToolbarHeight = function()
{
  // Gestisco l'altezza della caption
  this.ToolbarBox.style.flexBasis = (this.TabListContainer.offsetHeight + RD3_Glb.GetTopPadding(this.ToolbarBox) + 3) + "px";
};