/*

  -------------------.-.--------------------
  dxHtmlEditor Wrapper for INDE 25 with Fluid
  19/01/2026
  ------------------------------------------
  
*/

Client.devextremeHTMLEditor = function (element, parent, view)
{
  if(!Client.devextremeHTMLEditor.inited || !element.configuration || !element.id) {
    return;
  }
  
  if (this.htmlEditor) {
    this.htmlEditor.destroy();
  }
    
  DevExpress.localization.locale(navigator.language);

  let configuration = element.configuration;
  let isReadOnly = configuration.readOnly;
  this.indeFormIndex = configuration.indeFormIndex;
  this.indeID = configuration.indeFormIndex;
  let indeID = this.indeID
  this.id = element.id;
  let editorHeight = configuration.height;
  let editorValue = configuration.value;
  
  /*
    Create the Div to put inside the dxHtmlEditor
  */
  this.domObj = document.createElement("div");
  this.domObj.id = `HTMLEditor_${indeID}`;
  parent.appendChildObject(this, this.domObj);
  this.htmlEditorDiv = this.domObj;

  /*
    Draw the dxHtmlEditor inside the Div
  */
  let htmlEditorSelector = `#${this.domObj.id}`;
  $(htmlEditorSelector).dxHtmlEditor({
    readOnly : isReadOnly,
    height: editorHeight,
    value: editorValue,
    valueType: "html",
    imageUpload: {
        tabs: ['file', 'url'],
        fileUploadMode: 'base64',
    },
    tableContextMenu: { enabled: true },
    tableResizing: { enabled: true },
    toolbar: {
        multiline: true,
        items: [
            'undo', 'redo', 'separator',
            {
                name: 'size',
                acceptedValues: ['8pt', '10pt', '12pt', '14pt', '18pt', '24pt', '36pt'],
                options: { 
                        inputAttr: { 'aria-label': 'Font size' } 
				},
            },
            {
                name: 'font',
                acceptedValues: ['Arial', 'Courier New', 'Georgia', 'Impact', 'Lucida Console', 'Tahoma', 'Times New Roman', 'Verdana'],
                options: { 
						inputAttr: { 'aria-label': 'Font family' } 
				},
            },
            'separator', 'bold', 'italic', 'strike', 'underline', 'separator', 'color', 'background', 'separator',
            'alignLeft', 'alignCenter', 'alignRight', 'alignJustify', 'separator',
            'orderedList', 'bulletList'
        ],
    },
    mediaResizing: {
    enabled: true,
    },
    onValueChanged({ component, value }) {
		var encodedHTML = btoa(value);// encodeURIComponent(value);
        Client.mainFrame.sendCommand(`DXCOM`, `content={id:${indeID},message:"htmlEditor_valueChanged",content: "${encodedHTML}"}`)
    },
  });

  /*
    Store the dxHtmlEditor instance into this.htmlEditor
  */
  this.htmlEditor = $(htmlEditorSelector).dxHtmlEditor("instance");
  this.attachEvents(element.events);
};

// Define extension of class
Client.devextremeHTMLEditor.prototype = new Client.Element();
Client.devextremeHTMLEditor.eventProperties = ["id"] 


/*
  Manage the Requirements 
*/
Client.devextremeHTMLEditor.getRequirements = function ()
{
    Client.devextremeHTMLEditor.inited = true;
    let req = {};
    return req;
};


/*
  Destroy the dxHtmlEditor instance and remove the Div that has contained the dxHtmlEditor
*/
Client.devextremeHTMLEditor.prototype.close = function (firstLevel, triggerAnimation)
{
    if (this.htmlEditor) {
		delete this.htmlEditor;
		delete this.domObj;
	}
}