/*

  -------------------.-.--------------------
  DxScheduler Wrapper for INDE 25 with Fluid
                  19/01/2026
  ------------------------------------------
  
*/
Client.Scheduler = function (element, parent, view)
{
  Client.Element.call(this, element, parent, view);

  if(!Client.Scheduler.inited || !element.configuration || !element.id) {
    Client.Scheduler.Realize = parent;
    this.scheduler_rendered = false
    return;
  }
  

  /*
    If the scheduler was previously drawn we destroy the instance to create a new one
  */
  if (this.calendar) {
    this.calendar.destroy();
  }
    
  // read the Configuration shared by INDE
  var configuration = element.configuration
  this.dxScheduler_configuration = configuration;
  this.sc_timezone = configuration.timezone;
  this.sc_currentView = configuration.currentView;
  this.sc_currentDate = configuration.currentDate;
  this.sc_firstDayOfWeek = configuration.firstDayOfWeek;
  this.sc_startDayHour = configuration.startDayHour;
  this.sc_endDayHour = configuration.endDayHour;
  this.sc_showAllDayPanel = configuration.showAllDayPanel;
  this.sc_views = configuration.views;
  this.sc_cellDuration = configuration.cellDuration;
  this.sc_height = configuration.height;
  this.sc_width = configuration.width;
  this.sc_resources = configuration.resources;
  this.indeFormIndex = configuration.indeFormIndex;
  this.id = element.id;
  let indeID = this.indeFormIndex
  this.indeID = indeID;

  /*
    Create the Div to put inside the dxScheduler
  */
  this.domObj = document.createElement("div");
  this.domObj.id = `scheduler_${indeID}`;
  parent.appendChildObject(this, this.domObj);
  this.calendarDiv = this.domObj;

  /*
    Draw the dxScheduler inside the Div
  */
  
  var selector = `#${this.domObj.id}`;
  DevExpress.localization.locale(navigator.language);
  $(selector).dxScheduler({
    /*
      Basic Configuration
    */
    id: indeID,
    dataSource: [],
    groups: ['employeeID'],
    cellDuration: 15,
    resources: [
      {
        fieldExpr: 'employeeID',
        allowMultiple: false,
        dataSource: [{}],
        label: 'Employee',
      },
    ],
    
    /*
      Events to be handled 
    */
       
    onInitialized: function(info) {
      if(info)
      {
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"refresh",content: "something"}`);
      }
    },
    
    onAppointmentClick: function(event) {
      if(event){
        event.cancel = true;
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"appointmentClick",content: "${event.appointmentData.ID}"}`);
      }
    }, 
    
    onAppointmentDblClick: function(event) {
      if(event){
        event.cancel = true;
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeID},message:"appointmentDoubleClick",content: "${event.appointmentData.ID}"}`);
      }           
    }, 

          
    /*
      Rendering Part
    */

    timeCellTemplate(itemData, itemIndex, itemElement) {
      const element = $(`<div>${itemData.text}</div>`);
      const { date } = itemData;
      element.append('<div class="cafe" />');
      return itemElement.append(element);
    },

    appointmentTooltipTemplate(data) {
      eventData = data.targetedAppointmentData;
      return $(`${"<div class='event-tooltip' style='font-size: 12px !important;'>"
                  + "<img width='12' height='12' src='"}${eventData.image}' />`
                  + '<div class=\'event-info\'>'
                    + `<div class='event-title' style="white-space: break-spaces; height: auto; color: black;>${eventData.text}` + '</div>'
                    + `<div style="white-space: break-spaces; height: auto; color: black;"> Tipo: ${eventData.type}</div>`
                    + `<div style="white-space: break-spaces; height: auto; color: black;"> Descrizione: ${eventData.description}</div>`
                  + '</div>'
                + '</div>');
    },

    appointmentTemplate(data) {
      const eventData = data.targetedAppointmentData;
      return $(`${"<div class='showtime-preview' style='font-size: 12px !important;'>" 
                  + "<img width='12' height='12' src='"}${eventData.image}'/>`
                  + `<span style="white-space: break-spaces; height: auto; color: black;"> ${eventData.type} - ${eventData.text}</span>`
                + '</div>');
    },

    dataCellTemplate(cellData, index, container) {
      const hours = cellData.startDate.getHours();
      

      if(hours <= 8 || hours >= 17){
        container.css('background-color', '#f5f5f5');
      }


      const day = cellData.startDate.getDay();
      if(day == 0 || day == 6){
        container.css('background-color', '#ededed');
      }
    return container;
    },
    
    resourceCellTemplate(cellData) {
      const avatarAndName = document.createElement('div');
      avatarAndName.classList.add('resources');
      avatarAndName.style.backgroundColor = cellData.color;
      if (cellData.data.avatar){
        const image = document.createElement('img');
        image.src = cellData.data.avatar;
        image.width = 64;
        image.height = 64;
        image.alt = 'Foto profilo';
        const span = document.createElement('span');
        span.appendChild(image);
        avatarAndName.appendChild(span);
      }
      const textDiv = document.createElement('div');
      textDiv.textContent = cellData.text;
      avatarAndName.appendChild(textDiv);
      const container = document.createElement('div');
      container.appendChild(avatarAndName);
      return container;
    },

    
    dateCellTemplate(itemData, itemIndex, itemElement) {
      const dateHeaderContent = $(`<div>${itemData.text}</div>`);
      const actualDay = itemData.date.getDay();
      const isWekeendCheck = actualDay == 0 || actualDay == 6;
      if (isWekeendCheck) {
        itemElement.css('backgroundColor', '#ededed');
      }
      itemElement.css('font-weight', 600);
      itemElement.append(dateHeaderContent);
      return itemElement;
    },

    timeCellTemplate(itemData, itemIndex, itemElement) {
      const element = $(`<div>${itemData.text}</div>`);
      const { date } = itemData;
      const hours = date.getHours();
      if (hours >= 12 && hours < 13) {
        itemElement.css('font-color', 'rgb(242, 245, 188 / 40%');
      }
      const minutes = date.getMinutes();
      return itemElement.append(element);
    },
  });
       
  
  /*
    Store the dxScheduler instance into this.calendar
  */
  this.calendar = $(selector).dxScheduler("instance");


  /*
    set the options of the dxScheduler instance with the values read by element.configuration
    Wrap in setTimeout to ensure workspace is fully initialized
  */
  var self = this;
  setTimeout(function() {
    if(self.sc_timezone){self.calendar.option("timezone",  self.sc_timezone);}
    if(self.sc_currentView){self.calendar.option("currentView",  self.sc_currentView);}
    if(self.sc_currentDate){self.calendar.option("currentDate",  self.sc_currentDate);}
    if(self.sc_firstDayOfWeek){self.calendar.option("firstDayOfWeek",  self.sc_firstDayOfWeek);}
    if(self.sc_startDayHour){self.calendar.option("startDayHour",  self.sc_startDayHour);}
    if(self.sc_endDayHour){self.calendar.option("endDayHour",  self.sc_endDayHour);}
    if(self.sc_showAllDayPanel){self.calendar.option("showAllDayPanel",  self.sc_showAllDayPanel);}
    if(self.sc_views){self.calendar.option("views",  self.sc_views);}
    if(self.sc_cellDuration){self.calendar.option("cellDuration",  self.sc_cellDuration);}
    if(self.sc_height>0){self.calendar.option("height",  self.sc_height);}
    if(self.sc_width>0){self.calendar.option("width",  self.sc_width);}
    if(self.sc_resources){self.calendar.option("resources",  self.sc_resources);}
    self.sc_rendered = true;
  }, 0);

  this.attachEvents(element.events);
};

// Define extension of class
Client.Scheduler.prototype = new Client.Element();
Client.Scheduler.eventProperties = ["id"] 

/*
  Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated)
  In this case I put the required files directly in the DesktopFluid.html template
*/
Client.Scheduler.getRequirements = function ()
{
  let prefix = Client.mainFrame.isIDF ? "fluid/" : "";
  let req = {};
  Client.Scheduler.inited = true;
  return req;
};


/*
  Destroy the dxScheduler instance and remove the Div that has contained the dxScheduler
*/
Client.Scheduler.prototype.close = function (firstLevel, triggerAnimation)
{
  if (this.calendar){this.calendar.dispose();}
  delete this.calendar;
  if(this.calendarDiv && this.calendarDiv.parentNode){this.calendarDiv.parentNode.removeChild(this.calendarDiv);}
  if(this.calendarDiv){delete this.calendarDiv;}
}


// this procedure adds an Appointment in the dxScheduler
// from inde: USE an IDMAP in which store  text, employeeID, startDate and endDate
// to avoid inserting 2 times the same event, before inserting the event in the calendar we check if already exists
Client.Scheduler.prototype.addEvent = function(data) {
  if(!this.calendar) {
    console.warn("Scheduler not fully initialized yet");
    return;
  }

  try {
    const dataSource = this.calendar.getDataSource();
    if(!dataSource) {
      console.warn("Scheduler dataSource not ready yet");
      return;
    }

    const items = dataSource.items();
    searchEvent = this.findEvent(items, data);
    if(!searchEvent){
      this.calendar.addAppointment(data);
    }
  } catch(e) {
    console.error("Error adding appointment:", e);
  }
}

Client.Scheduler.prototype.findEvent = function(datasource, data) {
  if(data){
    if(data.ID){
      searchedID = data.ID
      dataSourceLenght = datasource.length;
      for(i = 0; i < dataSourceLenght; i++){
        if(datasource[i]){
          currentID = datasource[i].ID;
          if(currentID == searchedID){
            return datasource[i];
          }
        }
      }
    }
  }
}

Client.Scheduler.prototype.storeOption = function(optionName, optionValue) {
  switch(optionName){
    case "timezone":
      this.sc_timezone = optionValue;
    case "currentView":
      this.sc_currentView = optionValue;
    case "currentDate":
      this.sc_currentDate = optionValue;
    case "firstDayOfWeek":
      this.sc_firstDayOfWeek = optionValue;
    case "startDayHour":
      this.sc_startDayHour = optionValue;
    case "endDayHour":
      this.sc_endDayHour = optionValue;
    case "showAllDayPanel":
      this.sc_showAllDayPanel = optionValue;
    case "views":
      this.sc_views = optionValue;
    case "cellDuration":
      this.sc_cellDuration = optionValue;
    case "height":
      this.sc_height = optionValue;
    case "width":
      this.sc_width = optionValue;
    case "resources":
      this.sc_resources = optionValue;
    default: 
      console.log("Wrong usage!");
  }
}



// this procedure deletes an Appointment from the dxScheduler
Client.Scheduler.prototype.deleteEvent = function(data) {
  if(!this.calendar) {
    console.warn("Scheduler not fully initialized yet");
    return;
  }

  try {
    if(data && data.ID){
      const dataSource = this.calendar.getDataSource();
      if(!dataSource) {
        console.warn("Scheduler dataSource not ready yet");
        return;
      }

      const items = dataSource.items();
      var foundEvent = this.findEvent(items, data);
      if(foundEvent){
        this.calendar.deleteAppointment(foundEvent);
      }
    }
  } catch(e) {
    console.error("Error deleting appointment:", e);
  }
}

// this procedure changes the Options in the configuration Scheduler
Client.Scheduler.prototype.setOptions = function(options) {
  if(!this.calendar) {
    console.warn("Scheduler not fully initialized yet");
    return;
  }
  if(options.length > 0){
    for(i = 0; i < options.length; i++){
      currentOption = options[i];
      oName = currentOption.name;
      oValue = currentOption.value;

      if(oName && oValue){
        this.storeOption(oName,oValue);
        this.calendar.option(oName, oValue);
      }
    }
  }
}

// this procedure changes language of this scheduler
Client.Scheduler.prototype.setLocale = function(localeString) {
  if(localeString)
  {
    DevExpress.localization.locale(localeString);
  }
}

