/*
  -------------------.-.--------------------
  Diagram Wrapper for INDE 25 for Fluid
                  19/01/2026
  ------------------------------------------
*/
let indeFormID = ""

// // Attach a keydown event handler to the document or the diagram container
// document.addEventListener('keydown', function(e) {
//     // Check if Ctrl (or Meta on Mac) and Z are pressed
//     if ((e.ctrlKey || e.metaKey) && e.key === 'z') {
//         e.preventDefault(); // Prevent the default undo action
//         return false;
//     }
// });


/**
 * Create DevExtreme Diagram class
 * @param {*} diagram Diagram INDE object
 * @param {*} parent 
 * @param {*} view 
 * @returns 
 */
Client.Diagram = function (diagram, parent, view) {

  // call base constructor
  Client.Element.call(this, diagram, parent, view);

  // Initialization of properties. It starts from let configuration....
  if (Client.Diagram.inited && diagram.configuration && diagram.id) {

    //  If the diagram was previously drawn we destroy the instance to create a new one
    if (this.diagram_instance) {
      this.diagram_instance.destroy();
    }

    /** Step storage used by CustomStore do not modify directly. USE this.step ! */
    let storedSteps = [];
    if (diagram.storedShape != "") {
      storedSteps = JSON.parse(diagram.storedShape); //do not modify directly
    }

    /** Flow storage used by CustomStore do not modify directly. USE this.flow ! */
    let internalStoredFlows = [];
    if (diagram.storedConnection != "") {
      internalStoredFlows = JSON.parse(diagram.storedConnection)
    }
    this.storedFlows = internalStoredFlows;

    /** Configuration passed from INDE ! */
    let storedShapeConfiguration = JSON.parse(diagram.storedShapeConfiguration)
    let isDiagramReadOnly = diagram.readOnly

    function debugData() {
      console.log("### DEBUG ###");
      console.log("STEPS");
      console.table(storedSteps);
      console.log("FLOWS");
      console.table(internalStoredFlows);
    }

    debugData();

    /** CustomStore of STEPS */
    this.steps = new DevExpress.data.CustomStore({
      key: "id", //name of property set as identifier
      load: () => {
        return storedSteps;
      },
      insert: (stepToAdd) => {
        storedSteps.push(stepToAdd);

        console.log("CustomStore step insert", stepToAdd);
        console.table(storedSteps);

        //Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onInsertingStep",content: ${[JSON.stringify(newStep)]}}`);

        return stepToAdd;
      },
      update: (key, updateParams) => {
        console.log("CustomStore step update key e values", key, updateParams);

        const index = storedSteps.findIndex(item => item.id === key);
        let updatedStep = null;

        if (index > -1) {
          // se nel dataItem arriva un newId, sostituisco
          updatedStep = storedSteps[index];
          if (updatedStep != null) {
            updatedStep.x = updateParams.x;
            updatedStep.y = updateParams.y;
            updatedStep.height = updateParams.height;
            updatedStep.width = updateParams.width;
            updatedStep.color = updateParams.color;
            updatedStep.dataItem.name = updateParams.name || updatedStep.dataItem.name;
            updatedStep.dataItem.description = updateParams.description || updatedStep.dataItem.description;

            Object.assign(storedSteps[index], updatedStep);
            Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onUpdateStep",content: ${[JSON.stringify(updatedStep)]}}`);
            console.log(" => Sent to INDE the onUpdateStep message to update", updatedStep);

            // controlla tutti i flow collegati a questo step e modifica i points            
            const diagramInstance = $(selector).dxDiagram("instance");
            const flowsConnectedToEditedStep = diagramInstance.getItems().filter(flow => flow.dataItem.fromId === key || flow.dataItem.toId === key);


            flowsConnectedToEditedStep.forEach(flow => {
              if (flow.points != null || flow.points != "") {
                const pointsString = flow.points.map(point => JSON.stringify({ x: point.x, y: point.y })).join(',');
                const dataToSend = {
                  connectorId: flow.key,
                  points: pointsString
                };
                Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onFlowPointsChanged",content: ${[JSON.stringify(dataToSend)]}}`);
                console.log(" => Sent to INDE the onFlowPointsChanged message to update", dataToSend);
              }
            });
          }

          // console.log("CustomStore step.update", key, updatedStep);
          console.table(storedSteps);

          return storedSteps[index];
        } else {
          console.error("CustomStore step.update " + key + " not found")
          return null;
        }
      },
      remove: (itemIdToRemove) => {
        console.log("CustomStore step index to be deleted", itemIdToRemove);
        const index = storedSteps.findIndex(item => item.id === itemIdToRemove);
        let deletedStep = null;
        if (index > -1) {
          deletedStep = storedSteps[index];
          storedSteps.splice(index, 1);

          console.log(" => CustomStore step remove", deletedStep);

          //notify INDE of step deletion
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onDeleteStep",content: ${[JSON.stringify(deletedStep)]}}`);
          console.log(" => Sent to INDE the onDeleteStep message to delete", deletedStep);

          //console.table(storedSteps);
          return itemIdToRemove;
        } else {
          console.error(" => CustomStore step.remove " + itemIdToRemove + " not found")
          return null; // or manage the case here if not found
        }
      }
    });

    /** CustomStore of FLOWS */
    this.flows = new DevExpress.data.CustomStore({
      key: "id",  //name of property set as identifier
      load: () => {
        return internalStoredFlows;
      },
      insert: function (flowToAdd) {
        //if flow is null, generate ID
        if (flowToAdd.id == "" || flowToAdd.id == null) {
          flowToAdd.id = generateId();
        };
        flowToAdd.itemType = "connector"

        internalStoredFlows.push(flowToAdd); // Add the new flow to `storedFlow`
        console.log("CustomStore flow insert", flowToAdd)
        //console.table(internalStoredFlows);

        //notify INDE of new flow
        Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onInsertingFlow",content: ${[JSON.stringify(flowToAdd)]}}`);
        console.log(" => Sent to INDE the onInsertingFlow message to add flow", flowToAdd);

        return flowToAdd; // Returns the newly inserted edge
      },
      update: function (key, flowObj) {
        console.log("CustomStore flow update key e values", key, flowObj)
        let flowIndex = internalStoredFlows.findIndex(item => item.id === key);
        if (flowIndex > -1) {
          let flow = internalStoredFlows[flowIndex]; //.find(item => item.id === key);
          flow.text = flowObj.text;
          flow.fromId = flowObj.fromId;
          flow.toId = flowObj.toId;
          flow.fromPointIndex = flowObj.fromPointIndex
          flow.toPointIndex = flowObj.toPointIndex
          flow.points = flowObj.points

          /*if(flowObj.points != null || flowObj.points != "") {
            flow.points = flowObj.points.map(point => JSON.stringify({ x: point.x, y: point.y })).join(',');
          }*/


          Object.assign(internalStoredFlows[flowIndex], flow);
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onUpdateFlow",content:${[JSON.stringify(flow)]}}`);
          console.log(" => Sent to INDE the onUpdateFlow message to update", flow);
          //console.table(internalStoredFlows);

          return flow;
        } else {
          console.error(" => CustomStore flow.update " + key + " not found")
          return null;
        }
      },
      remove: function (key) {
        // Logic to remove an edge
        const index = internalStoredFlows.findIndex(e => e.id === key);
        console.log("CustomStore flow index to be deleted", index);
        if (index > -1) {
          const deletedFlow = internalStoredFlows[index];
          internalStoredFlows.splice(index, 1); // Removes the edge
          console.log(" => CustomStore flow remove", deletedFlow);

          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onDeleteFlow",content: ${[JSON.stringify(deletedFlow)]}}`);
          console.log(" => Sent to INDE the onDeleteFlow message to delete", deletedFlow);
          return deletedFlow;
        }
        else {
          console.error(" => CustomStore flow remove " + key + " not found")
        }
        return null;
      },
      byKey: function (key) {
        // Returns the edge with the specified ID
        return internalStoredFlows.find(item => item.id === key);
      }
    });

    // read the Configuration shared by INDE
    let indeConfig_diagram_name = diagram.configuration.diagram_name;
    let indeConfig_diagram_content = diagram.configuration.diagram_content;
    let indeConfig_main_toolbar = diagram.configuration.main_toolbar;
    let indeConfig_toolbox = diagram.configuration.toolbox;
    let indeConfig_context_toolbox = diagram.configuration.context_toolbox;
    let indeConfig_view_toolbar = diagram.configuration.view_toolbar;

    this.id = diagram.id;
    indeFormID = diagram.configuration.indeFormIndex

    DevExpress.localization.locale(navigator.language);

    // the div that contains the diagram is created and the id is assign
    let diagramDiv = document.createElement("div");
    diagramDiv.id = `diagram_${indeFormID}`;
    parent.appendChildObject(this, diagramDiv);
    let selector = `#${diagramDiv.id}`;
    this.diagram_instance_div = diagramDiv;

    // Inde framework FE needs it DON'T TOUCH THIS
    this.domObj = diagramDiv;

    // Initialize new object for shapeDataMap
    const shapeDataMap = {};

    // Itera su storedShapeConfiguration per aggiungere ogni item a shapeDataMap
    storedShapeConfiguration.forEach(config => {
      shapeDataMap[config.type] = { description: config.description };
    });

    /** Variable to track connector editing state */
    let isEditingConnector = false;
    let pendingConnectorData = null;

    /** Setup dxDiagram object */
    $(selector).dxDiagram({

      onInitialized(e) {
        if (!e.component._isLoaded) {
          console.log("JS onInitialized");
          e.component._isLoaded = true;
          const diagram = e.component;

          // Remove shortcut for Undo
          delete diagram._diagramInstance.commandManager.shortcutsToCommand[65626];

          // Read readonly state
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onDiagramInitialized",content: ${[JSON.stringify("")]}}`)
          console.log(" => Sent to INDE the onDiagramInitialized message");
        }
      },

      customShapes: storedShapeConfiguration,

      // THIS INSERTS INTO THE SHAPE THE TEXT FIELDS using foreignObject for full CSS support
      customShapeTemplate(item, $container) {
        const step = item.dataItem;
        const svgNS = 'http://www.w3.org/2000/svg';
        const $content = $(document.createElementNS(svgNS, 'svg')).addClass('template');

        // Crea foreignObject per supportare HTML e CSS
        const foreignObject = document.createElementNS(svgNS, 'foreignObject');
        foreignObject.setAttribute('x', '0');
        foreignObject.setAttribute('y', '0');
        foreignObject.setAttribute('width', '100%');
        foreignObject.setAttribute('height', '100%');

        // Crea container HTML per i testi
        const htmlContainer = document.createElement('div');
        htmlContainer.className = 'diagram-shape-container';

        // Crea elemento per il nome
        const nameElement = document.createElement('div');
        nameElement.className = 'template-name';
        nameElement.textContent = step?.dataItem.name || "";
        htmlContainer.appendChild(nameElement);

        // Crea elemento per la descrizione
        const descriptionElement = document.createElement('div');
        descriptionElement.className = 'template-title';
        descriptionElement.textContent = step?.dataItem.description || "";
        htmlContainer.appendChild(descriptionElement);

        /* to insert new buttons to edit or delete the shape
        const editButton = document.createElement('div');
        editButton.className = 'template-button';
        editButton.id = 'shape-edit';
        editButton.textContent = 'Modifica';
        editButton.onclick = () => { editEmployee(step); };
        htmlContainer.appendChild(editButton);

        const deleteButton = document.createElement('div');
        deleteButton.className = 'template-button';
        deleteButton.id = 'shape-delete';
        deleteButton.textContent = 'Cancella';
        deleteButton.onclick = () => { deleteShape(step); };
        htmlContainer.appendChild(deleteButton);
        */

        foreignObject.appendChild(htmlContainer);
        $content.append(foreignObject);
        $container.append($content);
      },
      // that function is used to add customShape to the lateral toolbox
      customShapeToolboxTemplate: function (item, $container) {

        //  Here descrizione is get from the dictionary
        const description = shapeDataMap[item.type]?.description || "Senza Descrizione";
        const $content = $(`
            <svg class='template'>
                <text x='50%' y='40%' text-anchor="middle">Nuovo</text>
                <text x='50%' y='70%' text-anchor="middle">${description}</text>
            </svg>
        `);
        $container.append($content);
      },

      export: { fileName: indeConfig_diagram_name },

      // we don't understand what contextMenu is but it's nothing relevant.
      contextMenu: {
        enabled: true,
        commands: ['bringToFront', 'sendToBack', 'lock', 'unlock'],
      },

      readOnly: isDiagramReadOnly,

      /** Configuration of nodes properties */
      nodes: {
        dataSource: this.steps,
        keyExpr: 'id',
        widthExpr: 'width',
        heightExpr: 'height',
        leftExpr: 'x',
        topExpr: 'y',
        // Custom Data Expression (gestisce solo il colore)
        customDataExpr: function (obj, value) {
          if (value === undefined) {
            return { color: obj.color };  // Restituisce un oggetto nuovo
          }
          obj.color = value.color;  // Aggiorna il valore nel nodo
        },

        // Style Expression (crea sempre un nuovo oggetto per evitare blocchi)
        styleExpr: function (obj) {
          return { fill: obj.color || '#FFFFFF' };  // Usa bianco di default se il colore è undefined
        },

        autoLayout: {
          type: 'off',
        },
      },

      /** Configuration of edges properties */
      edges: {
        dataSource: this.flows,
        keyExpr: "id",                        // La chiave primaria dell'edge
        textExpr: "text",                     // La proprietà del testo dell'edge
        fromExpr: "fromId",                   // La proprietà dell'origine (from)
        toExpr: "toId",                       // La proprietà della destinazione (to)
        fromPointIndexExpr: "fromPointIndex", // L'indice del punto di origine
        toPointIndexExpr: "toPointIndex",      // L'indice del punto di destinazione
        pointsExpr: "points"
      },

      historyToolbar: { visible: false, },
      viewToolbar: indeConfig_view_toolbar,
      mainToolbar: indeConfig_main_toolbar,
      contextToolbox: indeConfig_context_toolbox,
      toolbox: {
        // visibility: indeConfig_toolbox.visibility,
        visibility: false,
        shapeIconsPerRow: indeConfig_toolbox.shapeIconsPerRow,
        showSearch: indeConfig_toolbox.showSearch,
        height: indeConfig_toolbox.height,
        width: indeConfig_toolbox.width,
        groups: [{ category: 'step', description: 'Diagram Shape', expanded: true },],
      },
      propertiesPanel: {
        tabs: [{ groups: [{ Descrizione: 'Page Properties', commands: ['pageSize', 'pageOrientation', 'pageColor'] }], },],
      },

      onCustomCommand: function (e) {
        if (e.name === "blocca-sblocca") {
          let diagramInstance = e.component;
          const currentReadOnly = diagramInstance.option("readOnly");
          let payload = {
            isReadOnly: currentReadOnly,
          };
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID}, message:"setUnsetReadOnlyMode", content: ${[JSON.stringify(payload)]}}`);
        }
      },

      // this event helps you to block some operation you have in e. Doc for more info -> https://js.devexpress.com/jQuery/Documentation/ApiReference/UI_Components/dxDiagram/Configuration/#onRequestEditOperation
      onRequestEditOperation: function (e) {
        if (
          e.operation === "changeConnectorText" ||
          e.operation === "moveConnectorText" ||
          e.operation === "beforeChangeConnectorText"
        ) {
          e.allowed = false;
        }
        if (e.operation === "changeConnectorPoints") {
          // Debug per vedere cosa contiene l'evento

          var args = e.args;
          var connector = args.connector;
          var newPoints = args.newPoints;

          // Aggiorna lo stato: stiamo modificando il connector
          isEditingConnector = true;
          pendingConnectorData = {
            connector: connector,
            points: newPoints
          };

        }
      },

      onItemDblClick: function (data) {
        const diagramInstance = $(selector).dxDiagram("instance");
        const isReadOnlyWhenClick = diagramInstance.option("readOnly")
        const item = data.item

        if (isReadOnlyWhenClick) {
          // if in readonly don't do anything
          return;
        }
        console.log("JS onItemDblClick", data.item)

        if (item.itemType == "connector") {
          let toSend = {
            key: data.item.key,
            id: data.item.id,
            text: data.item.text,
            fromId: data.item.fromId,
            fromKey: data.item.fromKey,
            toId: data.item.toId,
            toKey: data.item.toKey,

          };
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onFlowDblClick",content: ${[JSON.stringify(toSend)]}}`);
          console.log(" => Sent to INDE the onFlowDblClick message to edit flow details", toSend);
        }
        else if (item.itemType == "shape") {
          // handle the click on a wkf node
          let toSend = {
            key: data.item.key,
            id: data.item.id,
            text: data.item.text,
            x: data.item.position.x,
            y: data.item.position.y,
          };
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onStepDblClick",content: ${[JSON.stringify(toSend)]}}`);
          console.log(" => Sent to INDE the onStepDblClick message to edit step details", toSend);
        }
      }
    });

    /** the current instance of the diagram  */
    this.diagram_instance = $(selector).dxDiagram("instance");
    //this.diagram_instance_div = diagramDiv
    this.attachEvents(diagram.events);

    // track when the mouse is release after editing the flow
    diagramDiv.addEventListener('mouseup', function () {
      if (isEditingConnector && pendingConnectorData) {
        if (pendingConnectorData.points != "" || pendingConnectorData.points != null) {
          const pointsString = pendingConnectorData.points.map(point => JSON.stringify({ x: point.x, y: point.y })).join(',');
          console.log("JS mouseup flow points update", pendingConnectorData.connector.key, pointsString)

          const dataToSend = {
            connectorId: pendingConnectorData.connector.key,
            points: pointsString
          }

          // Invia i dati a INDE
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onFlowPointsChanged",content: ${[JSON.stringify(dataToSend)]}}`);
          console.log(" => Sent to INDE the onFlowPointsChanged message to edit flow details", dataToSend);

          // Reset stato
          isEditingConnector = false;
          pendingConnectorData = null;
        };
      }
    });

    // Listener anche per touch devices
    diagramDiv.addEventListener('touchend', function () {
      if (isEditingConnector && pendingConnectorData) {
        if (pendingConnectorData.points != "" || pendingConnectorData.points != null) {
          const pointsString = pendingConnectorData.points.map(point => JSON.stringify({ x: point.x, y: point.y })).join(',');
          console.log("JS touchend flow points update", pendingConnectorData.connector.key, pointsString)

          const dataToSend = {
            connectorId: pendingConnectorData.connector.key,
            points: pointsString
          };

          // Invia i dati a INDE
          console.log("points to send", dataToSend);
          Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"onFlowPointsChanged",content: ${[JSON.stringify(dataToSend)]}}`);
          console.log(" => Sent to INDE the onFlowPointsChanged message to edit flow details", dataToSend);

          // Reset stato
          isEditingConnector = false;
          pendingConnectorData = null;
        }
      }
    });

    // Ottenere le shape e le connessioni
    //const shapes = this.diagram_instance.getItems();

    //import the diagram passed from INDE
    if (indeConfig_diagram_content) {
      $(selector).dxDiagram("instance").import(indeConfig_diagram_content, false);
    }
  }
  else {
    Client.Diagram.Realize = parent;
    this.diagram_instance_rendered = false
    return;
  }
};

/** Inheriting properties from Client.Element */
Client.Diagram.prototype = new Client.Element();

Client.Diagram.eventProperties = ["id"]

/** Manage the Requirements of this Class Scheduler (so the requirements for dxScheduler to be instantiated). In this case I put the required files directly in the DesktopFluid.html template */
Client.Diagram.getRequirements = function () {
  Client.Diagram.inited = true;
  return {};
};

/** Destroy the diagram instance and remove the Div that has contained the diagram  */
Client.Diagram.prototype.close = function (firstLevel, triggerAnimation) {

  if (this.diagram_instance) {
    this.diagram_instance.dispose();
  }

  delete this.diagram_instance;

  if (this.diagram_instance_div) {
    $(this.diagram_instance_div).off();
    this.diagram_instance_div.innerHTML = "";
  }

  if (this.diagram_instance_div && this.diagram_instance_div.parentNode) {
    this.diagram_instance_div.parentNode.removeChild(this.diagram_instance_div);
  }

  delete this.diagram_instance_div;
};


/** Export the diagram state as JSON */
Client.Diagram.prototype.exportJson = function () {
  var jsonString = this.diagram.export();
  this.SendEvent("export", [jsonString]);
}

/** Import diagram state from JSON */
Client.Diagram.prototype.importJson = function (json) {
  this.diagram.import(json, false);
}

/** Print current diagram as SVG file */
Client.Diagram.prototype.printwkf = function () {
  var imageString = "";
  const ff = function () {
    this.SendEvent("print", [imageString]);
  };
  this.diagram.exportTo('svg', ff);
}

/** Changes language */
Client.Diagram.prototype.setLocale = function (localeString) {
  if (localeString.length > 1) {
    DevExpress.localization.locale(localeString);
  }
}

/** Get the diagram state from current DOM and trigger the event "OnSaveDiagram" with content equals the state as JSON  */
Client.Diagram.prototype.getDataFromDiagram = function () {

  function cleanShape(item) {
    return {
      x: item.dataItem.x,
      y: item.dataItem.y,
      width: item.dataItem.width,
      height: item.dataItem.height,
      id: item.dataItem.id,
      itemType: item.dataItem.itemType,
      type: item.dataItem.type,
      dataItem: {
        Type: item.dataItem.dataItem.Type || "",
        description: item.dataItem.dataItem.description || "",
        name: item.dataItem.dataItem.name || ""
      },
      color: item.dataItem.color
    };
  }

  function cleanConnector(item) {
    return {
      id: item.dataItem.id || item.id,
      itemType: item.dataItem.itemType || item.itemType,
      fromId: item.dataItem.fromId || item.fromId,
      fromPointIndex: item.dataItem.fromPointIndex || item.fromPointIndex,
      toId: item.dataItem.toId || item.toId,
      toPointIndex: item.dataItem.toPointIndex || item.toPointIndex,
      text: item.dataItem.text || item.text || ""
    };
  }

  function cleanDiagramData(rawItems) {
    return rawItems.map(item => {
      if ((item.itemType || item?.dataItem?.itemType) === "shape") {
        return cleanShape(item);
      } else if ((item.itemType || item?.dataItem?.itemType) === "connector") {
        return cleanConnector(item);
      } else {
        console.warn("Tipo sconosciuto, lasciato grezzo:", item);
        return item;
      }
    });
  }

  const rawItems = this.diagram_instance.getItems();
  const cleanItems = cleanDiagramData(rawItems);
  this.savedDataFromFrontEnd = JSON.stringify(cleanItems);

  Client.mainFrame.sendEvents([{ obj: this.id, id: "OnSaveDiagram", content: [this.savedDataFromFrontEnd] }]);
};

/**
 * Add a step to the current diagram. 
 * @param {*} idStep this will be the id of the shape. Needed by dxDiagram
 */
Client.Diagram.prototype.addStep = function (idStep) {
  let newStep = {
    id: idStep.toString(),
    x: 4.5,
    y: 0.25,
    width: 1.5,
    height: 1,
    itemType: "shape",
    type: "step",
    dataItem: {
      Type: "step",
      description: "()",
      name: "Step",
      color: "#ffffff",
    }
  };

  console.log("FROM INDE: addStep function", idStep, newStep);
  //push service update internal data and update visualization: https://js.devexpress.com/jQuery/Documentation/Guide/Data_Binding/Data_Layer/#Data_Modification/Integration_with_Push_Services
  this.steps.push([{ type: "insert", data: newStep }]);

  this.diagram_instance.repaint();
}

/**
 * Add a START tp the current diagram. 
 * @param {*} idStep id step from INDE
 */
Client.Diagram.prototype.addStart = function (idStep) {
  console.log("FROM INDE: addStart function", idStep);

  let newStep = {
    id: idStep.toString(),
    x: 4.5,
    y: 0.25,
    width: 1.5,
    height: 1,
    itemType: "shape",
    type: "startStop",
    dataItem: {
      Type: "startStop",
      description: "START",
      name: "",
      color: "#228b22",
    }
  };
  //push service update internal data and update visualization: https://js.devexpress.com/jQuery/Documentation/Guide/Data_Binding/Data_Layer/#Data_Modification/Integration_with_Push_Services
  this.steps.push([{ type: "insert", data: newStep }]);

  this.diagram_instance.repaint();
}

/**
 * Add a STOP tp the current diagram. 
 * @param {*} idStep id step from INDE
 */
Client.Diagram.prototype.addStop = function (idStep) {
  console.log("FROM INDE: addStop function", idStep);

  let newStep = {
    id: idStep.toString(),
    x: 4.5,
    y: 0.25,
    width: 1.5,
    height: 1,
    itemType: "shape",
    type: "startStop",
    dataItem: {
      Type: "startStop",
      description: "STOP",
      name: "",
      color: "#d53032",
    }
  };
  //push service update internal data and update visualization: https://js.devexpress.com/jQuery/Documentation/Guide/Data_Binding/Data_Layer/#Data_Modification/Integration_with_Push_Services
  this.steps.push([{ type: "insert", data: newStep }]);

  this.diagram_instance.repaint();
}

/**
 * Update a step on the diagram (usually Title and subtitle)
 * @param {*} idStep the id step number
 * @param {*} title main description of the step
 * @param {*} subtitle second row print in the step (generally the executor)
 */
Client.Diagram.prototype.updateStep = function (idStep, title, subtitle) {
  console.log("FROM INDE: updateStep function", idStep, title, subtitle);
  try {
    if (idStep == null) {
      console.error(" => updateStep function => IdStep null");
      return;
    }

    this.steps.push([{
      type: 'update',
      key: idStep.toString(),
      data: {
        dataItem: {
          description: title,
          name: subtitle
        }
      }
    }]);
  } catch (error) {
    console.error(" => Errore durante l'aggiornamento dello step:", error);
  }
};

/**
 * delete a step from devextreme diagram
 * @param {*} idStep id step to delete
 */
Client.Diagram.prototype.deleteStep = function (idStep) {
  console.log("FROM INDE: delete step function: ", idStep);
  try {
    this.steps.push([{
      type: 'remove',
      key: idStep.toString(),
    }]);
  } catch (error) {
    console.error(" => Errore durante la cancellazione dello step:", error);
  }
};


/**
 * Update the name of a flow on the diagram
 * @param {*} idFlow flowid to update
 * @param {*} flowText new text property value
 */
Client.Diagram.prototype.updateFlow = function (idFlow, flowText) {
  console.log("FROM INDE: updateFlow function", idFlow, flowText);
  try {
    const index = this.storedFlows.findIndex(item => item.id === idFlow.toString());
    if (index >= 0) {
      let newFlow = this.storedFlows[index];
      newFlow.text = flowText;

      this.flows.push([{
        type: 'update',
        key: idFlow.toString(),
        data: newFlow
      }]);
    } else {
      console.error(" => Error updateFlow function => idFlow not found", idFlow)
    }
  } catch (error) {
    console.error(" => Errore durante l'aggiornamento del flow:", error);
  }
};

/**
 * change flow id from inde
 * @param {*} originalFlowKey original key
 * @param {*} newFlowKey new key
 */
Client.Diagram.prototype.changeFlowId = function (originalFlowKey, newFlowKey) {
  console.log("FROM INDE: changeFlowId", originalFlowKey, newFlowKey);
  try {
    const index = this.storedFlows.findIndex(item => item.id === originalFlowKey.toString());
    if (index >= 0) {
      let newFlow = this.storedFlows[index];

      console.log(" => flow to be edited", newFlow);
      newFlow.id = newFlowKey.toString();
    } else {
      console.error(" => changeFlowId function => originalFlowKey not found", originalFlowKey)
    }
  } catch (error) {
    console.error(" => Errore durante l'aggiornamento del flow:", error);
  }
};

/**
 * delete a flow from INDE
 * @param {*} idFlow id flow to delete
 */
Client.Diagram.prototype.deleteFlow = function (idFlow) {
  console.log("FROM INDE: delete flow function: ", idFlow);
  try {

    this.flows.push([{
      type: 'remove',
      key: idFlow.toString(),
    }]);
    this.flows.remove(idFlow.toString());
  } catch (error) {
    console.error(" => Errore durante la cancellazione del flow:", error);
  }
};

/**
 * toggle the read only mode of the diagram
 * @param {*} data not used anymore
 */
Client.Diagram.prototype.toggleReadOnlyMode = function (data) {
  const currentReadOnly = this.diagram_instance.option("readOnly");
  if (currentReadOnly == false) {
    this.diagram_instance.option("readOnly", true);
  }
  else {
    this.diagram_instance.option("readOnly", false);
  }
}

/**
 * set the state of the read only mode of the diagram
 * @param {*} data boolean to set the state
 */
Client.Diagram.prototype.setReadOnlyMode = function (data) {
  console.log("FROM INDE: setReadOnlyMode", data)
  if (typeof data === "boolean") {
    this.diagram_instance.option("readOnly", data);
  }
}

/**
 * Get the current readonly state of the diagram
 * @returns boolean
 */

Client.Diagram.prototype.isReadOnlyState = function () {
  //let diagramInstance = this.diagram_instance;
  let currentState = this.diagram_instance.option("readOnly")
  const toSend = {
    state: currentState
  }
  console.log("idReadOnlyState", toSend);

  Client.mainFrame.sendCommand("DXCOM", `content={id:${indeFormID},message:"on",content: ${[JSON.stringify(toSend)]}}`);
  return
}

Client.Diagram.prototype.updateShapesJson = function (jsonShape) {
  console.log("FROM INDE: updated Shape JSON", jsonShape);
  let diagramInstance = this.diagram_instance;
  
  storedSteps = JSON.parse(jsonShape);

  storedSteps.forEach(element => {
    this.steps.push([{
      type: 'update',
      key: element.id.toString(),
      data: element
    }]);
  });

};


/* update collections */
Client.Diagram.prototype.updateCollections = function (JSONSteps, JSONFlows) {
  console.log("collections:", JSONSteps, JSONFlows )

  var newSteps = JSON.parse(JSONSteps);
  newSteps.forEach(element => {

    this.steps.push([{
      type: 'remove',
      key: element.id.toString(),
    }]);

    this.steps.push([{
      type: 'insert',
      key: element.id.toString(),
      data: element
    }]);
  });


  var newFlows = JSON.parse(JSONFlows);
  newFlows.forEach(element => {
    this.flows.push([{
      type: 'remove',
      key: element.id.toString(),
    }]);

    this.flows.push([{
      type: 'insert',
      key: element.id.toString(),
      data: element
    }]);
  });
}

function generateId() {
  return Math.random().toString(36).substr(2, 9);
}

