/*!
* DevExtreme (dx.all.d.ts)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/

  interface JQuery<TElement = HTMLElement> {}
  interface JQuery<TElement = HTMLElement> {
    dxAccordion(): JQuery;
    dxAccordion(options: 'instance'): DevExpress.ui.dxAccordion;
    dxAccordion(options: DevExpress.ui.dxAccordion.Properties): JQuery;
    dxAccordion(options: string): any;
    dxAccordion(options: string, ...params: any[]): any;

    dxActionSheet(): JQuery;
    dxActionSheet(options: 'instance'): DevExpress.ui.dxActionSheet;
    dxActionSheet(options: DevExpress.ui.dxActionSheet.Properties): JQuery;
    dxActionSheet(options: string): any;
    dxActionSheet(options: string, ...params: any[]): any;

    dxAutocomplete(): JQuery;
    dxAutocomplete(options: 'instance'): DevExpress.ui.dxAutocomplete;
    dxAutocomplete(options: DevExpress.ui.dxAutocomplete.Properties): JQuery;
    dxAutocomplete(options: string): any;
    dxAutocomplete(options: string, ...params: any[]): any;

    dxBarGauge(): JQuery;
    dxBarGauge(options: 'instance'): DevExpress.viz.dxBarGauge;
    dxBarGauge(options: DevExpress.viz.dxBarGauge.Properties): JQuery;
    dxBarGauge(options: string): any;
    dxBarGauge(options: string, ...params: any[]): any;

    dxBox(): JQuery;
    dxBox(options: 'instance'): DevExpress.ui.dxBox;
    dxBox(options: DevExpress.ui.dxBox.Properties): JQuery;
    dxBox(options: string): any;
    dxBox(options: string, ...params: any[]): any;

    dxBullet(): JQuery;
    dxBullet(options: 'instance'): DevExpress.viz.dxBullet;
    dxBullet(options: DevExpress.viz.dxBullet.Properties): JQuery;
    dxBullet(options: string): any;
    dxBullet(options: string, ...params: any[]): any;

    dxButton(): JQuery;
    dxButton(options: 'instance'): DevExpress.ui.dxButton;
    dxButton(options: DevExpress.ui.dxButton.Properties): JQuery;
    dxButton(options: string): any;
    dxButton(options: string, ...params: any[]): any;

    dxButtonGroup(): JQuery;
    dxButtonGroup(options: 'instance'): DevExpress.ui.dxButtonGroup;
    dxButtonGroup(options: DevExpress.ui.dxButtonGroup.Properties): JQuery;
    dxButtonGroup(options: string): any;
    dxButtonGroup(options: string, ...params: any[]): any;

    dxCalendar(): JQuery;
    dxCalendar(options: 'instance'): DevExpress.ui.dxCalendar;
    dxCalendar(options: DevExpress.ui.dxCalendar.Properties): JQuery;
    dxCalendar(options: string): any;
    dxCalendar(options: string, ...params: any[]): any;

    dxChart(): JQuery;
    dxChart(options: 'instance'): DevExpress.viz.dxChart;
    dxChart(options: DevExpress.viz.dxChart.Properties): JQuery;
    dxChart(options: string): any;
    dxChart(options: string, ...params: any[]): any;

    dxCheckBox(): JQuery;
    dxCheckBox(options: 'instance'): DevExpress.ui.dxCheckBox;
    dxCheckBox(options: DevExpress.ui.dxCheckBox.Properties): JQuery;
    dxCheckBox(options: string): any;
    dxCheckBox(options: string, ...params: any[]): any;

    dxCircularGauge(): JQuery;
    dxCircularGauge(options: 'instance'): DevExpress.viz.dxCircularGauge;
    dxCircularGauge(options: DevExpress.viz.dxCircularGauge.Properties): JQuery;
    dxCircularGauge(options: string): any;
    dxCircularGauge(options: string, ...params: any[]): any;

    dxColorBox(): JQuery;
    dxColorBox(options: 'instance'): DevExpress.ui.dxColorBox;
    dxColorBox(options: DevExpress.ui.dxColorBox.Properties): JQuery;
    dxColorBox(options: string): any;
    dxColorBox(options: string, ...params: any[]): any;

    dxChat(): JQuery;
    dxChat(options: 'instance'): DevExpress.ui.dxChat;
    dxChat(options: DevExpress.ui.dxChat.Properties): JQuery;
    dxChat(options: string): any;
    dxChat(options: string, ...params: any[]): any;

    dxContextMenu(): JQuery;
    dxContextMenu(options: 'instance'): DevExpress.ui.dxContextMenu;
    dxContextMenu(options: DevExpress.ui.dxContextMenu.Properties): JQuery;
    dxContextMenu(options: string): any;
    dxContextMenu(options: string, ...params: any[]): any;

    dxDataGrid(): JQuery;
    dxDataGrid(options: 'instance'): DevExpress.ui.dxDataGrid;
    dxDataGrid(options: DevExpress.ui.dxDataGrid.Properties): JQuery;
    dxDataGrid(options: string): any;
    dxDataGrid(options: string, ...params: any[]): any;

    dxDateBox(): JQuery;
    dxDateBox(options: 'instance'): DevExpress.ui.dxDateBox;
    dxDateBox(options: DevExpress.ui.dxDateBox.Properties): JQuery;
    dxDateBox(options: string): any;
    dxDateBox(options: string, ...params: any[]): any;

    dxDateRangeBox(): JQuery;
    dxDateRangeBox(options: 'instance'): DevExpress.ui.dxDateRangeBox;
    dxDateRangeBox(options: DevExpress.ui.dxDateRangeBox.Properties): JQuery;
    dxDateRangeBox(options: string): any;
    dxDateRangeBox(options: string, ...params: any[]): any;

    dxDiagram(): JQuery;
    dxDiagram(options: 'instance'): DevExpress.ui.dxDiagram;
    dxDiagram(options: DevExpress.ui.dxDiagram.Properties): JQuery;
    dxDiagram(options: string): any;
    dxDiagram(options: string, ...params: any[]): any;

    dxDraggable(): JQuery;
    dxDraggable(options: 'instance'): DevExpress.ui.dxDraggable;
    dxDraggable(options: DevExpress.ui.dxDraggable.Properties): JQuery;
    dxDraggable(options: string): any;
    dxDraggable(options: string, ...params: any[]): any;

    dxDrawer(): JQuery;
    dxDrawer(options: 'instance'): DevExpress.ui.dxDrawer;
    dxDrawer(options: DevExpress.ui.dxDrawer.Properties): JQuery;
    dxDrawer(options: string): any;
    dxDrawer(options: string, ...params: any[]): any;

    dxDropDownBox(): JQuery;
    dxDropDownBox(options: 'instance'): DevExpress.ui.dxDropDownBox;
    dxDropDownBox(options: DevExpress.ui.dxDropDownBox.Properties): JQuery;
    dxDropDownBox(options: string): any;
    dxDropDownBox(options: string, ...params: any[]): any;

    dxDropDownButton(): JQuery;
    dxDropDownButton(options: 'instance'): DevExpress.ui.dxDropDownButton;
    dxDropDownButton(
      options: DevExpress.ui.dxDropDownButton.Properties
    ): JQuery;
    dxDropDownButton(options: string): any;
    dxDropDownButton(options: string, ...params: any[]): any;

    dxFileManager(): JQuery;
    dxFileManager(options: 'instance'): DevExpress.ui.dxFileManager;
    dxFileManager(options: DevExpress.ui.dxFileManager.Properties): JQuery;
    dxFileManager(options: string): any;
    dxFileManager(options: string, ...params: any[]): any;

    dxFileUploader(): JQuery;
    dxFileUploader(options: 'instance'): DevExpress.ui.dxFileUploader;
    dxFileUploader(options: DevExpress.ui.dxFileUploader.Properties): JQuery;
    dxFileUploader(options: string): any;
    dxFileUploader(options: string, ...params: any[]): any;

    dxFilterBuilder(): JQuery;
    dxFilterBuilder(options: 'instance'): DevExpress.ui.dxFilterBuilder;
    dxFilterBuilder(options: DevExpress.ui.dxFilterBuilder.Properties): JQuery;
    dxFilterBuilder(options: string): any;
    dxFilterBuilder(options: string, ...params: any[]): any;

    dxForm(): JQuery;
    dxForm(options: 'instance'): DevExpress.ui.dxForm;
    dxForm(options: DevExpress.ui.dxForm.Properties): JQuery;
    dxForm(options: string): any;
    dxForm(options: string, ...params: any[]): any;

    dxFunnel(): JQuery;
    dxFunnel(options: 'instance'): DevExpress.viz.dxFunnel;
    dxFunnel(options: DevExpress.viz.dxFunnel.Properties): JQuery;
    dxFunnel(options: string): any;
    dxFunnel(options: string, ...params: any[]): any;

    dxGallery(): JQuery;
    dxGallery(options: 'instance'): DevExpress.ui.dxGallery;
    dxGallery(options: DevExpress.ui.dxGallery.Properties): JQuery;
    dxGallery(options: string): any;
    dxGallery(options: string, ...params: any[]): any;

    dxGantt(): JQuery;
    dxGantt(options: 'instance'): DevExpress.ui.dxGantt;
    dxGantt(options: DevExpress.ui.dxGantt.Properties): JQuery;
    dxGantt(options: string): any;
    dxGantt(options: string, ...params: any[]): any;

    dxHtmlEditor(): JQuery;
    dxHtmlEditor(options: 'instance'): DevExpress.ui.dxHtmlEditor;
    dxHtmlEditor(options: DevExpress.ui.dxHtmlEditor.Properties): JQuery;
    dxHtmlEditor(options: string): any;
    dxHtmlEditor(options: string, ...params: any[]): any;

    dxLinearGauge(): JQuery;
    dxLinearGauge(options: 'instance'): DevExpress.viz.dxLinearGauge;
    dxLinearGauge(options: DevExpress.viz.dxLinearGauge.Properties): JQuery;
    dxLinearGauge(options: string): any;
    dxLinearGauge(options: string, ...params: any[]): any;

    dxList(): JQuery;
    dxList(options: 'instance'): DevExpress.ui.dxList;
    dxList(options: DevExpress.ui.dxList.Properties): JQuery;
    dxList(options: string): any;
    dxList(options: string, ...params: any[]): any;

    dxLoadIndicator(): JQuery;
    dxLoadIndicator(options: 'instance'): DevExpress.ui.dxLoadIndicator;
    dxLoadIndicator(options: DevExpress.ui.dxLoadIndicator.Properties): JQuery;
    dxLoadIndicator(options: string): any;
    dxLoadIndicator(options: string, ...params: any[]): any;

    dxLoadPanel(): JQuery;
    dxLoadPanel(options: 'instance'): DevExpress.ui.dxLoadPanel;
    dxLoadPanel(options: DevExpress.ui.dxLoadPanel.Properties): JQuery;
    dxLoadPanel(options: string): any;
    dxLoadPanel(options: string, ...params: any[]): any;

    dxLookup(): JQuery;
    dxLookup(options: 'instance'): DevExpress.ui.dxLookup;
    dxLookup(options: DevExpress.ui.dxLookup.Properties): JQuery;
    dxLookup(options: string): any;
    dxLookup(options: string, ...params: any[]): any;

    dxMap(): JQuery;
    dxMap(options: 'instance'): DevExpress.ui.dxMap;
    dxMap(options: DevExpress.ui.dxMap.Properties): JQuery;
    dxMap(options: string): any;
    dxMap(options: string, ...params: any[]): any;

    dxMenu(): JQuery;
    dxMenu(options: 'instance'): DevExpress.ui.dxMenu;
    dxMenu(options: DevExpress.ui.dxMenu.Properties): JQuery;
    dxMenu(options: string): any;
    dxMenu(options: string, ...params: any[]): any;

    dxMultiView(): JQuery;
    dxMultiView(options: 'instance'): DevExpress.ui.dxMultiView;
    dxMultiView(options: DevExpress.ui.dxMultiView.Properties): JQuery;
    dxMultiView(options: string): any;
    dxMultiView(options: string, ...params: any[]): any;

    dxNumberBox(): JQuery;
    dxNumberBox(options: 'instance'): DevExpress.ui.dxNumberBox;
    dxNumberBox(options: DevExpress.ui.dxNumberBox.Properties): JQuery;
    dxNumberBox(options: string): any;
    dxNumberBox(options: string, ...params: any[]): any;

    dxPagination(): JQuery;
    dxPagination(options: 'instance'): DevExpress.ui.dxPagination;
    dxPagination(options: DevExpress.ui.dxPagination.Properties): JQuery;
    dxPagination(options: string): any;
    dxPagination(options: string, ...params: any[]): any;

    dxPieChart(): JQuery;
    dxPieChart(options: 'instance'): DevExpress.viz.dxPieChart;
    dxPieChart(options: DevExpress.viz.dxPieChart.Properties): JQuery;
    dxPieChart(options: string): any;
    dxPieChart(options: string, ...params: any[]): any;

    dxPivotGrid(): JQuery;
    dxPivotGrid(options: 'instance'): DevExpress.ui.dxPivotGrid;
    dxPivotGrid(options: DevExpress.ui.dxPivotGrid.Properties): JQuery;
    dxPivotGrid(options: string): any;
    dxPivotGrid(options: string, ...params: any[]): any;

    dxPivotGridFieldChooser(): JQuery;
    dxPivotGridFieldChooser(
      options: 'instance'
    ): DevExpress.ui.dxPivotGridFieldChooser;
    dxPivotGridFieldChooser(
      options: DevExpress.ui.dxPivotGridFieldChooser.Properties
    ): JQuery;
    dxPivotGridFieldChooser(options: string): any;
    dxPivotGridFieldChooser(options: string, ...params: any[]): any;

    dxPolarChart(): JQuery;
    dxPolarChart(options: 'instance'): DevExpress.viz.dxPolarChart;
    dxPolarChart(options: DevExpress.viz.dxPolarChart.Properties): JQuery;
    dxPolarChart(options: string): any;
    dxPolarChart(options: string, ...params: any[]): any;

    dxPopover(): JQuery;
    dxPopover(options: 'instance'): DevExpress.ui.dxPopover;
    dxPopover(options: DevExpress.ui.dxPopover.Properties): JQuery;
    dxPopover(options: string): any;
    dxPopover(options: string, ...params: any[]): any;

    dxPopup(): JQuery;
    dxPopup(options: 'instance'): DevExpress.ui.dxPopup;
    dxPopup(options: DevExpress.ui.dxPopup.Properties): JQuery;
    dxPopup(options: string): any;
    dxPopup(options: string, ...params: any[]): any;

    dxProgressBar(): JQuery;
    dxProgressBar(options: 'instance'): DevExpress.ui.dxProgressBar;
    dxProgressBar(options: DevExpress.ui.dxProgressBar.Properties): JQuery;
    dxProgressBar(options: string): any;
    dxProgressBar(options: string, ...params: any[]): any;

    dxRadioGroup(): JQuery;
    dxRadioGroup(options: 'instance'): DevExpress.ui.dxRadioGroup;
    dxRadioGroup(options: DevExpress.ui.dxRadioGroup.Properties): JQuery;
    dxRadioGroup(options: string): any;
    dxRadioGroup(options: string, ...params: any[]): any;

    dxRangeSelector(): JQuery;
    dxRangeSelector(options: 'instance'): DevExpress.viz.dxRangeSelector;
    dxRangeSelector(options: DevExpress.viz.dxRangeSelector.Properties): JQuery;
    dxRangeSelector(options: string): any;
    dxRangeSelector(options: string, ...params: any[]): any;

    dxRangeSlider(): JQuery;
    dxRangeSlider(options: 'instance'): DevExpress.ui.dxRangeSlider;
    dxRangeSlider(options: DevExpress.ui.dxRangeSlider.Properties): JQuery;
    dxRangeSlider(options: string): any;
    dxRangeSlider(options: string, ...params: any[]): any;

    dxRecurrenceEditor(): JQuery;
    dxRecurrenceEditor(options: 'instance'): DevExpress.ui.dxRecurrenceEditor;
    dxRecurrenceEditor(
      options: DevExpress.ui.dxRecurrenceEditor.Properties
    ): JQuery;
    dxRecurrenceEditor(options: string): any;
    dxRecurrenceEditor(options: string, ...params: any[]): any;

    dxResizable(): JQuery;
    dxResizable(options: 'instance'): DevExpress.ui.dxResizable;
    dxResizable(options: DevExpress.ui.dxResizable.Properties): JQuery;
    dxResizable(options: string): any;
    dxResizable(options: string, ...params: any[]): any;

    dxResponsiveBox(): JQuery;
    dxResponsiveBox(options: 'instance'): DevExpress.ui.dxResponsiveBox;
    dxResponsiveBox(options: DevExpress.ui.dxResponsiveBox.Properties): JQuery;
    dxResponsiveBox(options: string): any;
    dxResponsiveBox(options: string, ...params: any[]): any;

    dxSankey(): JQuery;
    dxSankey(options: 'instance'): DevExpress.viz.dxSankey;
    dxSankey(options: DevExpress.viz.dxSankey.Properties): JQuery;
    dxSankey(options: string): any;
    dxSankey(options: string, ...params: any[]): any;

    dxScheduler(): JQuery;
    dxScheduler(options: 'instance'): DevExpress.ui.dxScheduler;
    dxScheduler(options: DevExpress.ui.dxScheduler.Properties): JQuery;
    dxScheduler(options: string): any;
    dxScheduler(options: string, ...params: any[]): any;

    dxScrollView(): JQuery;
    dxScrollView(options: 'instance'): DevExpress.ui.dxScrollView;
    dxScrollView(options: DevExpress.ui.dxScrollView.Properties): JQuery;
    dxScrollView(options: string): any;
    dxScrollView(options: string, ...params: any[]): any;

    dxSelectBox(): JQuery;
    dxSelectBox(options: 'instance'): DevExpress.ui.dxSelectBox;
    dxSelectBox(options: DevExpress.ui.dxSelectBox.Properties): JQuery;
    dxSelectBox(options: string): any;
    dxSelectBox(options: string, ...params: any[]): any;

    dxSlider(): JQuery;
    dxSlider(options: 'instance'): DevExpress.ui.dxSlider;
    dxSlider(options: DevExpress.ui.dxSlider.Properties): JQuery;
    dxSlider(options: string): any;
    dxSlider(options: string, ...params: any[]): any;

    dxSplitter(): JQuery;
    dxSplitter(options: 'instance'): DevExpress.ui.dxSplitter;
    dxSplitter(options: DevExpress.ui.dxSplitter.Properties): JQuery;
    dxSplitter(options: string): any;
    dxSplitter(options: string, ...params: any[]): any;

    dxStepper(): JQuery;
    dxStepper(options: 'instance'): DevExpress.ui.dxStepper;
    dxStepper(options: DevExpress.ui.dxStepper.Properties): JQuery;
    dxStepper(options: string): any;
    dxStepper(options: string, ...params: any[]): any;

    dxSortable(): JQuery;
    dxSortable(options: 'instance'): DevExpress.ui.dxSortable;
    dxSortable(options: DevExpress.ui.dxSortable.Properties): JQuery;
    dxSortable(options: string): any;
    dxSortable(options: string, ...params: any[]): any;

    dxSparkline(): JQuery;
    dxSparkline(options: 'instance'): DevExpress.viz.dxSparkline;
    dxSparkline(options: DevExpress.viz.dxSparkline.Properties): JQuery;
    dxSparkline(options: string): any;
    dxSparkline(options: string, ...params: any[]): any;

    dxSpeechToText(): JQuery;
    dxSpeechToText(options: 'instance'): DevExpress.ui.dxSpeechToText;
    dxSpeechToText(options: DevExpress.ui.dxSpeechToText.Properties): JQuery;
    dxSpeechToText(options: string): any;
    dxSpeechToText(options: string, ...params: any[]): any;

    dxSpeedDialAction(): JQuery;
    dxSpeedDialAction(options: 'instance'): DevExpress.ui.dxSpeedDialAction;
    dxSpeedDialAction(
      options: DevExpress.ui.dxSpeedDialAction.Properties
    ): JQuery;
    dxSpeedDialAction(options: string): any;
    dxSpeedDialAction(options: string, ...params: any[]): any;

    dxSwitch(): JQuery;
    dxSwitch(options: 'instance'): DevExpress.ui.dxSwitch;
    dxSwitch(options: DevExpress.ui.dxSwitch.Properties): JQuery;
    dxSwitch(options: string): any;
    dxSwitch(options: string, ...params: any[]): any;

    dxTabPanel(): JQuery;
    dxTabPanel(options: 'instance'): DevExpress.ui.dxTabPanel;
    dxTabPanel(options: DevExpress.ui.dxTabPanel.Properties): JQuery;
    dxTabPanel(options: string): any;
    dxTabPanel(options: string, ...params: any[]): any;

    dxTabs(): JQuery;
    dxTabs(options: 'instance'): DevExpress.ui.dxTabs;
    dxTabs(options: DevExpress.ui.dxTabs.Properties): JQuery;
    dxTabs(options: string): any;
    dxTabs(options: string, ...params: any[]): any;

    dxTagBox(): JQuery;
    dxTagBox(options: 'instance'): DevExpress.ui.dxTagBox;
    dxTagBox(options: DevExpress.ui.dxTagBox.Properties): JQuery;
    dxTagBox(options: string): any;
    dxTagBox(options: string, ...params: any[]): any;

    dxTextArea(): JQuery;
    dxTextArea(options: 'instance'): DevExpress.ui.dxTextArea;
    dxTextArea(options: DevExpress.ui.dxTextArea.Properties): JQuery;
    dxTextArea(options: string): any;
    dxTextArea(options: string, ...params: any[]): any;

    dxTextBox(): JQuery;
    dxTextBox(options: 'instance'): DevExpress.ui.dxTextBox;
    dxTextBox(options: DevExpress.ui.dxTextBox.Properties): JQuery;
    dxTextBox(options: string): any;
    dxTextBox(options: string, ...params: any[]): any;

    dxTileView(): JQuery;
    dxTileView(options: 'instance'): DevExpress.ui.dxTileView;
    dxTileView(options: DevExpress.ui.dxTileView.Properties): JQuery;
    dxTileView(options: string): any;
    dxTileView(options: string, ...params: any[]): any;

    dxToast(): JQuery;
    dxToast(options: 'instance'): DevExpress.ui.dxToast;
    dxToast(options: DevExpress.ui.dxToast.Properties): JQuery;
    dxToast(options: string): any;
    dxToast(options: string, ...params: any[]): any;

    dxToolbar(): JQuery;
    dxToolbar(options: 'instance'): DevExpress.ui.dxToolbar;
    dxToolbar(options: DevExpress.ui.dxToolbar.Properties): JQuery;
    dxToolbar(options: string): any;
    dxToolbar(options: string, ...params: any[]): any;

    dxTooltip(): JQuery;
    dxTooltip(options: 'instance'): DevExpress.ui.dxTooltip;
    dxTooltip(options: DevExpress.ui.dxTooltip.Properties): JQuery;
    dxTooltip(options: string): any;
    dxTooltip(options: string, ...params: any[]): any;

    dxTreeList(): JQuery;
    dxTreeList(options: 'instance'): DevExpress.ui.dxTreeList;
    dxTreeList(options: DevExpress.ui.dxTreeList.Properties): JQuery;
    dxTreeList(options: string): any;
    dxTreeList(options: string, ...params: any[]): any;

    dxTreeMap(): JQuery;
    dxTreeMap(options: 'instance'): DevExpress.viz.dxTreeMap;
    dxTreeMap(options: DevExpress.viz.dxTreeMap.Properties): JQuery;
    dxTreeMap(options: string): any;
    dxTreeMap(options: string, ...params: any[]): any;

    dxTreeView(): JQuery;
    dxTreeView(options: 'instance'): DevExpress.ui.dxTreeView;
    dxTreeView(options: DevExpress.ui.dxTreeView.Properties): JQuery;
    dxTreeView(options: string): any;
    dxTreeView(options: string, ...params: any[]): any;

    dxValidationGroup(): JQuery;
    dxValidationGroup(options: 'instance'): DevExpress.ui.dxValidationGroup;
    dxValidationGroup(
      options: DevExpress.ui.dxValidationGroup.Properties
    ): JQuery;
    dxValidationGroup(options: string): any;
    dxValidationGroup(options: string, ...params: any[]): any;

    dxValidationMessage(): JQuery;
    dxValidationMessage(options: 'instance'): DevExpress.ui.dxValidationMessage;
    dxValidationMessage(
      options: DevExpress.ui.dxValidationMessage.Properties
    ): JQuery;
    dxValidationMessage(options: string): any;
    dxValidationMessage(options: string, ...params: any[]): any;

    dxValidationSummary(): JQuery;
    dxValidationSummary(options: 'instance'): DevExpress.ui.dxValidationSummary;
    dxValidationSummary(
      options: DevExpress.ui.dxValidationSummary.Properties
    ): JQuery;
    dxValidationSummary(options: string): any;
    dxValidationSummary(options: string, ...params: any[]): any;

    dxValidator(): JQuery;
    dxValidator(options: 'instance'): DevExpress.ui.dxValidator;
    dxValidator(options: DevExpress.ui.dxValidator.Properties): JQuery;
    dxValidator(options: string): any;
    dxValidator(options: string, ...params: any[]): any;

    dxVectorMap(): JQuery;
    dxVectorMap(options: 'instance'): DevExpress.viz.dxVectorMap;
    dxVectorMap(options: DevExpress.viz.dxVectorMap.Properties): JQuery;
    dxVectorMap(options: string): any;
    dxVectorMap(options: string, ...params: any[]): any;
  }
  interface JQueryEventObject {}
  interface JQueryPromise<T> {}

declare module DevExpress {
  /**
   * A base class for all components and UI components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class Component<TProperties> {
    constructor(options?: TProperties);
    /**
     * Postpones rendering that can negatively affect performance until the endUpdate() method is called.
     */
    beginUpdate(): void;
    /**
     * Refreshes the UI component after a call of the beginUpdate() method.
     */
    endUpdate(): void;
    /**
     * Gets the UI component&apos;s instance. Use it to access other methods of the UI component.
     */
    instance(): this;
    /**
     * Detaches all event handlers from a single event.
     */
    off(eventName: string): this;
    /**
     * Detaches a particular event handler from a single event.
     */
    off(eventName: string, eventHandler: Function): this;
    /**
     * Subscribes to an event.
     */
    on(eventName: string, eventHandler: Function): this;
    /**
     * Subscribes to events.
     */
    on(events: { [key: string]: Function }): this;
    /**
     * Gets all UI component properties.
     */
    option(): TProperties;
    /**
     * Gets the value of a single property.
     */
    option<TPropertyName extends string>(
      optionName: TPropertyName
    ): TPropertyName extends keyof TProperties
      ? TProperties[TPropertyName]
      : unknown;
    /**
     * Updates the value of a single property.
     */
    option<TPropertyName extends string>(
      optionName: TPropertyName,
      optionValue: TPropertyName extends keyof TProperties
        ? TProperties[TPropertyName]
        : unknown
    ): void;
    /**
     * Updates the values of several properties.
     */
    option(options: Partial<TProperties>): void;
    /**
     * Resets a property to its default value.
     */
    resetOption(optionName: string): void;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ComponentOptions<
    TDisposingEvent,
    TInitializedEvent,
    TOptionChangedEvent
  > {
    /**
     * A function that is executed before the UI component is disposed of.
     */
    onDisposing?: (e: TDisposingEvent) => void;
    /**
     * A function used in JavaScript frameworks to save the UI component instance.
     */
    onInitialized?: (e: TInitializedEvent) => void;
    /**
     * A function that is executed after a UI component property is changed.
     */
    onOptionChanged?: (e: TOptionChangedEvent) => void;
  }
  /**
   * Gets the current global configuration.
   */
  export function config(): DevExpress.common.GlobalConfig;
  /**
    * Configures your application before its launch.
    */
   export function config(config: DevExpress.common.GlobalConfig): void;
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class DataHelperMixin {
    /**
     * Gets the DataSource instance.
     */
    getDataSource(): DevExpress.common.data.DataSource;
  }
  /**
   * Specifies the device-dependent default configuration properties for a component.
   */
  export type DefaultOptionsRule<T> = {
    device?:
      | DevExpress.common.core.environment.Device
      | DevExpress.common.core.environment.Device[]
      | ((device: DevExpress.common.core.environment.Device) => boolean);
    options: DevExpress.core.DeepPartial<T>;
  };
  /**
   * A base class for all components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class DOMComponent<
    TProperties = DevExpress.DOMComponent.Properties
  > extends Component<TProperties> {
    _templateManager: DevExpress.core.TemplateManager;

    _cancelOptionChange?: string | boolean;

    constructor(
      element: DevExpress.core.UserDefinedElement,
      options?: TProperties
    );

    /**
     * Gets the instance of a UI component found using its DOM node.
     */
    static getInstance(
      element: DevExpress.core.UserDefinedElement
    ): DOMComponent<DevExpress.DOMComponent.Properties>;

    /**
     * Specifies the device-dependent default configuration properties for this component.
     */
    static defaultOptions<TProperties = DevExpress.DOMComponent.Properties>(
      rule: DefaultOptionsRule<TProperties>
    ): void;

    /**
     * Disposes of all the resources allocated to the widget instance.
     */
    dispose(): void;
    /**
     * Gets the root UI component element.
     */
    element(): DevExpress.core.DxElement;

    $element(): DevExpress.core.InternalElement<Element>;
    _getTemplate(template: unknown): DevExpress.core.FunctionTemplate;
    _invalidate(): void;
    _refresh(): void;
    _notifyOptionChanged(
      fullName: string,
      value: unknown,
      previousValue: unknown
    ): void;
    _createElement(element: HTMLElement): void;
    _validateOptions(options: TProperties): TProperties;
  }
  module DOMComponent {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface DOMComponentInstance extends DOMComponent<Properties> {}
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type OptionChangedEventInfo<TComponent> =
      DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type Properties = DOMComponentOptions<DOMComponentInstance>;
  }

  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DOMComponentOptions<TComponent>
    extends ComponentOptions<
      DevExpress.common.core.events.EventInfo<TComponent>,
      DevExpress.common.core.events.InitializedEventInfo<TComponent>,
      DevExpress.DOMComponent.OptionChangedEventInfo<TComponent>
    > {
    /**
     * Specifies the global attributes to be attached to the UI component&apos;s container element.
     */
    elementAttr?: { [key: string]: any };
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string | undefined;
    /**
     * A function that is executed before the UI component is disposed of.
     */
    onDisposing?: (
      e: DevExpress.common.core.events.EventInfo<TComponent>
    ) => void;
    /**
     * A function that is executed after a UI component property is changed.
     */
    onOptionChanged?: (
      e: DevExpress.DOMComponent.OptionChangedEventInfo<TComponent>
    ) => void;
    /**
     * Switches the UI component to a right-to-left representation.
     */
    rtlEnabled?: boolean;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string | undefined;
  }
  /**
   * Configures the load panel.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ExportLoadPanel {
    /**
     * Specifies whether the load panel is enabled.
     */
    enabled?: boolean;
    /**
     * Specifies text displayed on the load panel.
     */
    text?: string;
    /**
     * Specifies the width of the load panel in pixels.
     */
    width?: number;
    /**
     * Specifies the height of the load panel in pixels.
     */
    height?: number;
    /**
     * Specifies whether to show the loading indicator.
     */
    showIndicator?: boolean;
    /**
     * Specifies the path to a custom load indicator image.
     * @deprecated Use indicatorOptions instead.
     */
    indicatorSrc?: string;
    /**
     * Configures the load indicator.
     */
    indicatorOptions?: DevExpress.ui.dxLoadPanel.LoadPanelIndicatorProperties;
    /**
     * Specifies whether to show the pane of the load panel.
     */
    showPane?: boolean;
    /**
     * Specifies whether to shade the UI component when the load panel is shown.
     */
    shading?: boolean;
    /**
     * Specifies the shading color. Applies only if shading is true.
     */
    shadingColor?: string;
  }
  export type FloatingActionButtonDirection = 'auto' | 'up' | 'down';
  /**
   * Registers a new component in the DevExpress.ui namespace.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export function registerComponent<TComponent>(
    name: string,
    componentClass: DevExpress.core.ComponentFactory<TComponent>
  ): void;
  /**
   * Registers a new component in the specified namespace.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export function registerComponent<TComponent>(
    name: string,
    namespace: {
      [key: string]: DevExpress.core.ComponentFactory<DOMComponent>;
    },
    componentClass: DevExpress.core.ComponentFactory<TComponent>
  ): void;
  /**
   * Sets custom functions that compile and render templates.
   */
  export function setTemplateEngine(templateEngineOptions: {
    compile?: Function;
    render?: Function;
  }): void;
  /**
   * A template notation used to specify templates for UI component elements.
   */
  export type template = string | Function | DevExpress.core.UserDefinedElement;
  /**
   * An object that serves as a namespace for the methods required to perform validation.
   */
  export class validationEngine {
    /**
     * Gets the default validation group.
     */
    static getGroupConfig(): any;
    /**
     * Gets a validation group with a specific key.
     */
    static getGroupConfig(group: string | any): any;
    /**
     * Registers all the Validator objects extending fields of the specified ViewModel.
     */
    static registerModelForValidation(model: any): void;
    /**
     * Resets the values and validation result of the editors that belong to the default validation group.
     */
    static resetGroup(): void;
    /**
     * Resets the values and validation result of the editors that belong to the specified validation group.
     */
    static resetGroup(group: string | any): void;
    /**
     * Unregisters all the Validator objects extending fields of the specified ViewModel.
     */
    static unregisterModelForValidation(model: any): void;
    /**
     * Validates editors from the default validation group.
     */
    static validateGroup(): DevExpress.ui.dxValidationGroup.ValidationResult;
    /**
     * Validates editors from a specific validation group.
     */
    static validateGroup(
      group: string | any
    ): DevExpress.ui.dxValidationGroup.ValidationResult;
    /**
     * Validates a view model.
     */
    static validateModel(model: any): any;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type VersionAssertion = {
    packageName: string;
    version: string;
  };
}
declare module DevExpress.aiIntegration {
  /**
   * A class that activates AI services in DevExpress UI components.
   */
  export class AIIntegration {
    /**
     * @docid
     * @param provider
     */
    constructor(provider: AIProvider);
    changeStyle(
      params: ChangeStyleCommandParams,
      callbacks: RequestCallbacks<ChangeStyleCommandResult>
    ): () => void;
    changeTone(
      params: ChangeToneCommandParams,
      callbacks: RequestCallbacks<ChangeToneCommandResult>
    ): () => void;
    execute(
      params: ExecuteCommandParams,
      callbacks: RequestCallbacks<ExecuteCommandResult>
    ): () => void;
    expand(
      params: ExpandCommandParams,
      callbacks: RequestCallbacks<ExpandCommandResult>
    ): () => void;
    proofread(
      params: ProofreadCommandParams,
      callbacks: RequestCallbacks<ProofreadCommandResult>
    ): () => void;
    shorten(
      params: ShortenCommandParams,
      callbacks: RequestCallbacks<ShortenCommandResult>
    ): () => void;
    summarize(
      params: SummarizeCommandParams,
      callbacks: RequestCallbacks<SummarizeCommandResult>
    ): () => void;
    translate(
      params: TranslateCommandParams,
      callbacks: RequestCallbacks<TranslateCommandResult>
    ): () => void;
    smartPaste(
      params: SmartPasteCommandParams,
      callbacks: RequestCallbacks<SmartPasteCommandResult>
    ): () => void;
    generateGridColumn(
      params: GenerateGridColumnCommandParams,
      callbacks: RequestCallbacks<GenerateGridColumnCommandResult>
    ): () => void;
  }
  /**
   * An object responsible for sending requests to an AI service.
   */
  export type AIProvider = {
    /**
     * A function that sends a request to an AI service.
     */
    sendRequest: (params: RequestParams) => Response;
  };
  /**
   * An object that contains an AI response.
   */
  export type AIResponse = string | Record<PropertyKey, any>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ChangeStyleCommandParams = {
    text: string;
    writingStyle: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ChangeStyleCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ChangeToneCommandParams = {
    text: string;
    tone: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ChangeToneCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ExecuteCommandParams = {
    text: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ExecuteCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ExpandCommandParams = {
    text: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ExpandCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type FieldInfo = {
    name: string;
    format: string;
    type?: SmartPasteFieldType;
    instruction?: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type GenerateGridColumnCommandParams = {
    text: string;
    data: Record<PropertyKey, unknown>;
    additionalInfo?: Record<PropertyKey, unknown>;
  };
  /**
   * 
   */
  export type GenerateGridColumnCommandResponse =
    | string
    | {
        /**
         * 
         */
        data: string | Record<PropertyKey, string>;
      };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type GenerateGridColumnCommandResult = {
    data: Record<PropertyKey, string>;
  };
  /**
   * A prompt for the AI model.
   */
  export type Prompt = {
    /**
     * Direct instructions for the AI model.
     */
    system?: string;
    /**
     * A user message to the AI model.
     */
    user?: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ProofreadCommandParams = {
    text: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ProofreadCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type RequestCallbacks<T> = {
    onChunk?: (chunk: string) => void;
    onComplete?: (finalResponse: T) => void;
    onError?: (error: Error) => void;
  };
  /**
   * An object with request parameters for AI service.
   */
  export type RequestParams = {
    /**
     * The prompt sent to the AI model.
     */
    prompt: Prompt;
    /**
     * Additional data sent to the AI model.
     */
    data?: RequestParamsData;
  };
  /**
   * An object that contains additional data to be sent to an AI model.
   */
  export type RequestParamsData = Record<PropertyKey, any>;
  /**
   * An object returned by the sendRequest function.
   */
  export type Response = {
    /**
     * A promise that resolves with the final AI-generated text.
     */
    promise: Promise<AIResponse>;
    /**
     * A function that cancels the request.
     */
    abort: () => void;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ShortenCommandParams = {
    text: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ShortenCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SmartPasteCommandParams = {
    text: string;
    fields: FieldInfo[];
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SmartPasteCommandResult = Array<{
    name: string;
    value: SmartPasteResultFieldType;
  }>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SmartPasteFieldType =
    | 'color'
    | 'boolean'
    | 'string'
    | 'stringArray'
    | 'number'
    | 'numberRange'
    | 'date'
    | 'dateRange';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SmartPasteResultFieldType =
    | string
    | string[]
    | number
    | number[]
    | Date
    | Date[]
    | boolean;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SummarizeCommandParams = {
    text: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SummarizeCommandResult = string;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type TranslateCommandParams = {
    text: string;
    lang: string;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type TranslateCommandResult = string;
}
declare module DevExpress.animation {
  /**
   * @deprecated Use the DevExpress.common.core.animation.AnimationConfig type from common/core/animation instead
   */
  export type animationConfig =
    DevExpress.common.core.animation.AnimationConfig;
  /**
   * @deprecated Use the DevExpress.common.core.animation.PositionConfig type from common/core/animation instead
   */
  export interface positionConfig
    extends DevExpress.common.core.animation.PositionConfig {}
}
declare module DevExpress.common {
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type AnimationType =
    | 'css'
    | 'fade'
    | 'fadeIn'
    | 'fadeOut'
    | 'pop'
    | 'slide'
    | 'slideIn'
    | 'slideOut';
  export type ApplyValueMode = 'instantly' | 'useButtons';
  /**
   * A custom validation rule that is checked asynchronously. Use async rules for server-side validation.
   */
  export type AsyncRule = {
    /**
     * If true, the validationCallback is not executed for null, undefined, false, and empty strings.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Indicates whether the rule should always be checked for the target value or only when the value changes.
     */
    reevaluate?: boolean;
    /**
     * Specifies the rule type. Set it to &apos;async&apos; to use the AsyncRule.
     */
    type: 'async';
    /**
     * A function that validates the target value.
     */
    validationCallback?: (options: ValidationCallbackData) => PromiseLike<any>;
  };
  export type ButtonStyle = 'text' | 'outlined' | 'contained';
  export type ButtonType = 'danger' | 'default' | 'normal' | 'success';
  /**
   * A validation rule that requires validated values to match a specified expression.
   */
  export type CompareRule = {
    /**
     * Specifies the function whose return value is used for comparison with the validated value.
     */
    comparisonTarget?: () => any;
    /**
     * Specifies the operator to be used for comparing the validated value with the target.
     */
    comparisonType?: ComparisonOperator;
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the rule type. Set it to &apos;compare&apos; to use the CompareRule.
     */
    type: 'compare';
  };
  export type ComparisonOperator =
    | '!='
    | '!=='
    | '<'
    | '<='
    | '=='
    | '==='
    | '>'
    | '>=';
  /**
   * A rule with custom validation logic.
   */
  export type CustomRule = {
    /**
     * If true, the validationCallback is not executed for null, undefined, false, and empty strings.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Indicates whether the rule should be always checked for the target value or only when the target value changes.
     */
    reevaluate?: boolean;
    /**
     * Specifies the rule type. Set it to &apos;custom&apos; to use the CustomRule.
     */
    type: 'custom';
    /**
     * A function that validates the target value.
     */
    validationCallback?: (options: ValidationCallbackData) => boolean;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type DataSourceEventName = 'changed' | 'loadError' | 'loadingChanged';
  export type DataStructure = 'plain' | 'tree';
  export type DataType =
    | 'string'
    | 'number'
    | 'date'
    | 'boolean'
    | 'object'
    | 'datetime';
  export type DateLike = Date | number | string | null;
  export type Direction = 'bottom' | 'left' | 'right' | 'top';
  export type DisplayMode = 'adaptive' | 'compact' | 'full';
  export type DragDirection = 'both' | 'horizontal' | 'vertical';
  export type Draggable =
    DevExpress.core.OmitInternal<DevExpress.ui.dxDraggable>;
  export type DragHighlight = 'push' | 'indicate';
  export type EditorStyle = 'outlined' | 'underlined' | 'filled';
  /**
   * A validation rule that requires that the validated field match the Email pattern.
   */
  export type EmailRule = {
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the rule type. Set it to &apos;email&apos; to use the EmailRule.
     */
    type: 'email';
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type EventName = 'orientationChanged';
  export type ExportFormat = 'GIF' | 'JPEG' | 'PDF' | 'PNG' | 'SVG';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type ExternalFormat = Intl.DateTimeFormatOptions | Intl.NumberFormatOptions;
  export type FieldChooserLayout = 0 | 1 | 2;
  export type FirstDayOfWeek = 0 | 1 | 2 | 3 | 4 | 5 | 6;
  export type Format =
    | 'billions'
    | 'currency'
    | 'day'
    | 'decimal'
    | 'exponential'
    | 'fixedPoint'
    | 'largeNumber'
    | 'longDate'
    | 'longTime'
    | 'millions'
    | 'millisecond'
    | 'month'
    | 'monthAndDay'
    | 'monthAndYear'
    | 'percent'
    | 'quarter'
    | 'quarterAndYear'
    | 'shortDate'
    | 'shortTime'
    | 'thousands'
    | 'trillions'
    | 'year'
    | 'dayOfWeek'
    | 'hour'
    | 'longDateLongTime'
    | 'minute'
    | 'second'
    | 'shortDateShortTime';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface FormatObject {
    /**
     * Specifies a 3-letter ISO 4217 code for currency. Applies only if the type is &apos;currency&apos;.
     */
    currency?: string;
    /**
     * Specifies whether to apply the accounting style to formatted numbers of the `currency` type.
     */
    useCurrencyAccountingStyle?: boolean;
    /**
     * A function that converts numeric or date-time values to a string.
     */
    formatter?: (value: number | Date) => string;
    /**
     * Parses string values into numeric or date-time values. Should be used with formatter or one of the predefined formats.
     */
    parser?: (value: string) => number | Date;
    /**
     * Specifies a precision for values of numeric or currency format types.
     */
    precision?: number;
    /**
     * Specifies a predefined format. Does not apply if you have specified the formatter function.
     */
    type?: PredefinedFormat | string;
  }
  /**
   * Specifies settings that affect all DevExtreme UI components.
   */
  export type GlobalConfig = {
    versionAssertions?: VersionAssertion[];
    /**
     * A decimal separator. No longer applies.
     * @deprecated 
     */
    decimalSeparator?: string;
    /**
     * The default currency. Accepts a 3-letter ISO 4217 code.
     */
    defaultCurrency?: string;
    /**
     * Specifies whether to apply the accounting style to formatted numbers of the `currency` type.
     */
    defaultUseCurrencyAccountingStyle?: boolean;
    /**
     * Specifies whether to copy DevExtreme stylesheets into the Shadow DOM.
     */
    copyStylesToShadowDom?: boolean;
    /**
     * Specifies how editors&apos; text fields are styled in your application.
     */
    editorStylingMode?: EditorStyle | undefined;
    /**
     * Configures a Floating Action Button (FAB) that emits a stack of related actions (speed dial).
     */
    floatingActionButtonConfig?: {
      /**
       * Specifies the icon the FAB displays when the speed dial is opened.
       */
      closeIcon?: string;
      /**
       * Specifies the direction in which to open the speed dial menu.
       */
      direction?: FloatingActionButtonDirection;
      /**
       * Specifies the icon the FAB displays when the speed dial is closed.
       */
      icon?: string;
      /**
       * Specifies the text label displayed inside the FAB.
       */
      label?: string;
      /**
       * Limits the number of speed dial actions.
       */
      maxSpeedDialActionCount?: number;
      /**
       * Positions the FAB on the screen.
       */
      position?:
        | PositionAlignment
        | DevExpress.common.core.animation.PositionConfig
        | Function;
      /**
       * If true, the background should be shaded when the speed dial menu is open.
       */
      shading?: boolean;
    };
    /**
     * Specifies whether dates are parsed and serialized according to the ISO 8601 standard in all browsers.
     */
    forceIsoDateParsing?: boolean;
    /**
     * Specifies whether to convert string values to lowercase in filter and search requests to OData services. Applies to the following operations: &apos;startswith&apos;, &apos;endswith&apos;, &apos;contains&apos;, and &apos;notcontains&apos;.
     */
    oDataFilterToLower?: boolean;
    /**
     * @deprecated Attention! This field is not documented and should only be specified in a limited number of use cases. For more information, please submit a ticket to our Support Center.
     */
    pointerEventStrategy?: 'mouse-and-touch' | 'mouse' | 'touch';
    /**
     * Specifies whether the UI components support a right-to-left representation. Available for individual UI components as well.
     */
    rtlEnabled?: boolean;
    /**
     * The decimal separator that is used when submitting a value to the server.
     */
    serverDecimalSeparator?: string;
    /**
     * A group separator. No longer applies.
     * @deprecated 
     */
    thousandsSeparator?: string;
    /**
     * 
     */
    useLegacyStoreResult?: boolean;
    /**
     * 
     */
    useLegacyVisibleIndex?: boolean;
    /**
     * A license key.
     */
    licenseKey?: string;
    buyNowLink?: string;
    licensingDocLink?: string;
  };
  export type HorizontalAlignment = 'center' | 'left' | 'right';
  export type HorizontalEdge = 'left' | 'right';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type HttpMethod = 'GET' | 'POST' | 'PATCH' | 'MERGE';
  export type LabelMode = 'static' | 'floating' | 'hidden' | 'outside';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type LoadFunctionResult<T> =
    | T
    | DevExpress.core.utils.DxPromise<T>
    | PromiseLike<T>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type LoadResultArray<TItem = any> =
    | Array<TItem>
    | Array<DevExpress.common.data.GroupItem<TItem>>;
  export type MaskMode = 'always' | 'onFocus';
  export type Mode = 'auto';
  /**
   * A validation rule that demands that the validated field has a numeric value.
   */
  export type NumericRule = {
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the rule type. Set it to &apos;numeric&apos; to use the NumericRule.
     */
    type: 'numeric';
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ODataRequestOptions {
    accepts: any;
    async: boolean;
    contentType: string | boolean;
    data: any;
    dataType: string;
    headers: any;
    jsonp?: boolean;
    method: string;
    timeout: number;
    url: string;
    xhrFields: any;
  }
  export type Orientation = 'horizontal' | 'vertical';
  export type PageLoadMode = 'nextButton' | 'scrollBottom';
  export type PageOrientation = 'portrait' | 'landscape';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type PagerBase = {
    /**
     * Specifies the pager&apos;s display mode.
     */
    displayMode?: DisplayMode;
    /**
     * Specifies the page information text.
     */
    infoText?: string;
    /**
     * Specifies whether to show the page information.
     */
    showInfo?: boolean;
    /**
     * Specifies whether to show navigation buttons.
     */
    showNavigationButtons?: boolean;
    /**
     * Specifies page size selector visibility.
     */
    showPageSizeSelector?: boolean | Mode;
    /**
     * Specifies an aria-label attribute for the pager.
     */
    label?: string;
  };
  /**
   * A validation rule that requires that the validated field match a specified pattern.
   */
  export type PatternRule = {
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the regular expression that the validated value must match.
     */
    pattern?: RegExp | string;
    /**
     * Specifies the rule type. Set it to &apos;pattern&apos; to use the PatternRule.
     */
    type: 'pattern';
  };
  export type Position = 'bottom' | 'left' | 'right' | 'top';
  export type PositionAlignment =
    | 'bottom'
    | 'center'
    | 'left'
    | 'left bottom'
    | 'left top'
    | 'right'
    | 'right bottom'
    | 'right top'
    | 'top';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type PredefinedFormat = Format;
  /**
   * A validation rule that demands the target value be within the specified value range (including the range&apos;s end points).
   */
  export type RangeRule = {
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the maximum value allowed for the validated value.
     */
    max?: Date | number | string;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the minimum value allowed for the validated value.
     */
    min?: Date | number | string;
    /**
     * Indicates whether the rule should be always checked for the target value or only when the target value changes.
     */
    reevaluate?: boolean;
    /**
     * Specifies the rule type. Set it to &apos;range&apos; to use the RangeRule.
     */
    type: 'range';
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ReducedNativeEventInfo<
    TComponent extends DevExpress.common.grids.GridBase
  > = Required<
    Pick<
      DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        DevExpress.events.PointerInteractionEvent
      >,
      'component' | 'event'
    >
  >;
  /**
   * A validation rule that rejects empty and invalid values.
   */
  export type RequiredRule = {
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Indicates whether to remove the Space characters from the validated value.
     */
    trim?: boolean;
    /**
     * Specifies the rule type. Set it to &apos;required&apos; to use the RequiredRule.
     */
    type: 'required';
  };
  export type Scrollable =
    DevExpress.core.OmitInternal<DevExpress.ui.dxScrollable>;
  export type ScrollbarMode = 'always' | 'never' | 'onHover' | 'onScroll';
  export type ScrollDirection = 'both' | 'horizontal' | 'vertical';
  export type ScrollMode = 'standard' | 'virtual';
  export type SearchMode = 'contains' | 'startswith' | 'equals';
  export type SelectAllMode = 'allPages' | 'page';
  export type SimplifiedSearchMode = 'contains' | 'startswith';
  export type SingleMultipleAllOrNone = 'single' | 'multiple' | 'all' | 'none';
  export type SingleMultipleOrNone = 'single' | 'multiple' | 'none';
  export type SingleOrMultiple = 'single' | 'multiple';
  export type SingleOrNone = 'single' | 'none';
  export type SliderValueChangeMode = 'onHandleMove' | 'onHandleRelease';
  export type Sortable = DevExpress.core.OmitInternal<DevExpress.ui.dxSortable>;
  export type SortOrder = 'asc' | 'desc';
  export type StoreType = 'array' | 'local' | 'odata';
  /**
   * A validation rule that demands the target value length be within the specified value range (including the range&apos;s end points).
   */
  export type StringLengthRule = {
    /**
     * If set to true, empty values are valid.
     */
    ignoreEmptyValue?: boolean;
    /**
     * Specifies the maximum length allowed for the validated value.
     */
    max?: number;
    /**
     * Specifies the message that is shown if the rule is broken.
     */
    message?: string;
    /**
     * Specifies the minimum length allowed for the validated value.
     */
    min?: number;
    /**
     * Indicates whether or not to remove the Space characters from the validated value.
     */
    trim?: boolean;
    /**
     * Specifies the rule type. Set it to &apos;stringLength&apos; to use the StringLengthRule.
     */
    type: 'stringLength';
  };
  export type SubmenuShowMode = 'onClick' | 'onHover';
  export type TabsIconPosition = 'top' | 'end' | 'bottom' | 'start';
  export type TabsStyle = 'primary' | 'secondary';
  export type TextBoxPredefinedButton = 'clear';
  /**
   * 
   */
  export type TextEditorButton = {
    /**
     * Specifies whether to place the button before or after the input text field.
     */
    location?: TextEditorButtonLocation;
    /**
     * Specifies the button&apos;s name.
     */
    name?: string | undefined;
    /**
     * Configures the Button UI component used as the action button.
     */
    options?: DevExpress.ui.dxButton.Properties | undefined;
  };
  export type TextEditorButtonLocation = 'after' | 'before';
  export type ToolbarItemComponent =
    | 'dxAutocomplete'
    | 'dxButton'
    | 'dxButtonGroup'
    | 'dxCheckBox'
    | 'dxDateBox'
    | 'dxDropDownButton'
    | 'dxMenu'
    | 'dxSelectBox'
    | 'dxSwitch'
    | 'dxTabs'
    | 'dxTextBox';
  export type ToolbarItemLocation = 'after' | 'before' | 'center';
  export type TooltipShowMode = 'always' | 'onHover';
  export type ValidationCallbackData = {
    value?: any;
    rule: any;
    validator: any;
    data?: any;
    column?: any;
    formItem?: any;
  };
  export type ValidationMessageMode = 'always' | 'auto';
  /**
   * Specifies a validation rule.
   */
  export type ValidationRule =
    | AsyncRule
    | CompareRule
    | CustomRule
    | EmailRule
    | NumericRule
    | PatternRule
    | RangeRule
    | RequiredRule
    | StringLengthRule;
  export type ValidationRuleType =
    | 'required'
    | 'numeric'
    | 'range'
    | 'stringLength'
    | 'custom'
    | 'compare'
    | 'pattern'
    | 'email'
    | 'async';
  export type ValidationStatus = 'valid' | 'invalid' | 'pending';
  export type VerticalAlignment = 'bottom' | 'center' | 'top';
  export type VerticalEdge = 'bottom' | 'top';
}
declare module DevExpress.common.charts {
  export type AnimationEaseMode = 'easeOutCubic' | 'linear';
  export type AnnotationType = 'text' | 'image' | 'custom';
  export type ArgumentAxisHoverMode = 'allArgumentPoints' | 'none';
  export type AxisScaleType = 'continuous' | 'discrete' | 'logarithmic';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface BaseLegend {
    /**
     * Colors the legend&apos;s background.
     */
    backgroundColor?: string | undefined;
    /**
     * Configures the legend&apos;s border.
     */
    border?: {
      /**
       * Colors the legend&apos;s border.
       */
      color?: string;
      /**
       * Makes all the legend&apos;s corners rounded.
       */
      cornerRadius?: number;
      /**
       * Sets a dash style for the legend&apos;s border.
       */
      dashStyle?: DashStyle;
      /**
       * Specifies the transparency of the legend&apos;s border.
       */
      opacity?: number | undefined;
      /**
       * Shows the legend&apos;s border.
       */
      visible?: boolean;
      /**
       * Specifies the width of the legend&apos;s border in pixels.
       */
      width?: number;
    };
    /**
     * Arranges legend items into several columns.
     */
    columnCount?: number;
    /**
     * Specifies an empty space between item columns in pixels.
     */
    columnItemSpacing?: number;
    /**
     * Specifies the legend items&apos; font properties.
     */
    font?: Font;
    /**
     * Along with verticalAlignment, specifies the legend&apos;s position.
     */
    horizontalAlignment?: HorizontalAlignment;
    /**
     * Specifies the text&apos;s position relative to the marker in a legend item.
     */
    itemTextPosition?: Position | undefined;
    /**
     * Aligns items in the last column or row (depending on the legend&apos;s orientation). Applies when legend items are not divided into columns or rows equally.
     */
    itemsAlignment?: HorizontalAlignment | undefined;
    /**
     * Generates an empty space, measured in pixels, around the legend.
     */
    margin?:
      | number
      | {
          /**
           * Specifies the legend&apos;s bottom margin in pixels.
           */
          bottom?: number;
          /**
           * Specifies the legend&apos;s left margin in pixels.
           */
          left?: number;
          /**
           * Specifies the legend&apos;s right margin in pixels.
           */
          right?: number;
          /**
           * Specifies the legend&apos;s top margin in pixels.
           */
          top?: number;
        };
    /**
     * Specifies the marker&apos;s size in a legend item in pixels.
     */
    markerSize?: number;
    /**
     * Arranges legend items vertically (in a column) or horizontally (in a row). The default value is &apos;horizontal&apos; if the legend.horizontalAlignment is &apos;center&apos;. Otherwise, it is &apos;vertical&apos;.
     */
    orientation?: Orientation | undefined;
    /**
     * Generates an empty space, measured in pixels, between the legend&apos;s left/right border and its items.
     */
    paddingLeftRight?: number;
    /**
     * Generates an empty space, measured in pixels, between the legend&apos;s top/bottom border and its items.
     */
    paddingTopBottom?: number;
    /**
     * Arranges legend items in several rows.
     */
    rowCount?: number;
    /**
     * Specifies an empty space between item rows in pixels.
     */
    rowItemSpacing?: number;
    /**
     * Configures the legend title.
     */
    title?:
      | {
          /**
           * Specifies the legend title&apos;s font properties.
           */
          font?: Font;
          /**
           * Along with verticalAlignment, specifies the legend title&apos;s position.
           */
          horizontalAlignment?: HorizontalAlignment | undefined;
          /**
           * Generates space around the legend title.
           */
          margin?: {
            /**
             * Specifies the legend title&apos;s bottom margin.
             */
            bottom?: number;
            /**
             * Specifies the legend title&apos;s left margin.
             */
            left?: number;
            /**
             * Specifies the legend title&apos;s right margin.
             */
            right?: number;
            /**
             * Specifies the legend title&apos;s top margin.
             */
            top?: number;
          };
          /**
           * Reserves a pixel-measured space for the legend title.
           */
          placeholderSize?: number | undefined;
          /**
           * Configures the legend subtitle. The subtitle appears only if the title is specified.
           */
          subtitle?:
            | {
                /**
                 * Specifies the legend subtitle&apos;s font properties.
                 */
                font?: Font;
                /**
                 * Specifies the distance between the legend&apos;s title and subtitle in pixels.
                 */
                offset?: number;
                /**
                 * Specifies the subtitle&apos;s text.
                 */
                text?: string;
              }
            | string;
          /**
           * Specifies the legend title&apos;s text.
           */
          text?: string;
          /**
           * Specifies the legend title&apos;s vertical alignment.
           */
          verticalAlignment?: VerticalEdge;
        }
      | string;
    /**
     * Along with horizontalAlignment, specifies the legend&apos;s position.
     */
    verticalAlignment?: VerticalEdge;
    /**
     * Specifies the legend&apos;s visibility.
     */
    visible?: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface BaseLegendItem {
    /**
     * A legend item marker.
     */
    marker?: {
      /**
       * The marker&apos;s color.
       */
      fill?: string;
      /**
       * The marker&apos;s opacity.
       */
      opacity?: number;
      /**
       * The markerSize in pixels.
       */
      size?: number;
      /**
       * The marker&apos;s state.
       */
      state?: LegendMarkerState;
    };
    /**
     * The text that the legend item displays.
     */
    text?: string;
    /**
     * Indicates and specifies whether the legend item is visible.
     */
    visible?: boolean;
  }
  export type ChartsAxisLabelOverlap = 'rotate' | 'stagger' | 'none' | 'hide';
  /**
   * Specifies the chart&apos;s color.
   */
  export type ChartsColor = {
    /**
     * Specifies the base color for series, points and labels.
     */
    base?: string | undefined;
    /**
     * Specifies the id of the gradient or pattern.
     */
    fillId?: string | undefined;
  };
  export type ChartsDataType = 'datetime' | 'numeric' | 'string';
  export type ChartsLabelOverlap = 'hide' | 'none' | 'stack';
  export type DashStyle = 'dash' | 'dot' | 'longDash' | 'solid';
  export type DiscreteAxisDivisionMode = 'betweenLabels' | 'crossLabels';
  /**
   * Font properties.
   */
  export type Font = {
    /**
     * Specifies font color.
     */
    color?: string;
    /**
     * Specifies font family.
     */
    family?: string;
    /**
     * Specifies font opacity.
     */
    opacity?: number;
    /**
     * Specifies font size.
     */
    size?: string | number;
    /**
     * Specifies font weight. Accepts values from 100 to 900 in increments of 100. Higher values increase boldness.
     */
    weight?: number;
  };
  /**
   * Specifies colors on which gradient is based.
   */
  export type GradientColor = {
    /**
     * Specifies the starting point of a color.
     */
    offset: number | string | undefined;
    /**
     * Specifies one of the gradient colors.
     */
    color: string | undefined;
  };
  export type HatchDirection = 'left' | 'none' | 'right';
  export type LabelOverlap = 'hide' | 'none';
  export type LabelPosition = 'columns' | 'inside' | 'outside';
  export type LegendHoverMode = 'excludePoints' | 'includePoints' | 'none';
  /**
   * An object that provides information about a legend item.
   */
  export interface LegendItem extends BaseLegendItem {
    /**
     * The series that the item represents on the legend.
     */
    series?: DevExpress.viz.baseSeriesObject;
  }
  export type LegendMarkerState = 'normal' | 'hovered' | 'selected';
  export type Palette =
    | 'Bright'
    | 'Harmony Light'
    | 'Ocean'
    | 'Pastel'
    | 'Soft'
    | 'Soft Pastel'
    | 'Vintage'
    | 'Violet'
    | 'Carmine'
    | 'Dark Moon'
    | 'Dark Violet'
    | 'Green Mist'
    | 'Soft Blue'
    | 'Material'
    | 'Office';
  export type PaletteColorSet = 'simpleSet' | 'indicatingSet' | 'gradientSet';
  export type PaletteExtensionMode = 'alternate' | 'blend' | 'extrapolate';
  export type PointInteractionMode =
    | 'allArgumentPoints'
    | 'allSeriesPoints'
    | 'none'
    | 'onlyPoint';
  export type PointSymbol =
    | 'circle'
    | 'cross'
    | 'polygon'
    | 'square'
    | 'triangle'
    | 'triangleDown'
    | 'triangleUp';
  /**
   * Registers a new gradient.
   */
  export function registerGradient(
    type: string,
    options: { rotationAngle?: number; colors: Array<GradientColor> }
  ): string;
  /**
   * Registers a new pattern.
   */
  export function registerPattern(options: {
    width: number | string;
    height: number | string;
    template: (container: SVGGElement) => void;
  }): string;
  export type RelativePosition = 'inside' | 'outside';
  /**
   * A class describing a scale break range. Inherited by scale breaks in the Chart and RangeSelector.
   */
  export type ScaleBreak = {
    /**
     * Along with the startValue property, limits the scale break.
     */
    endValue?: number | Date | string | undefined;
    /**
     * Along with the endValue property, limits the scale break.
     */
    startValue?: number | Date | string | undefined;
  };
  export type ScaleBreakLineStyle = 'straight' | 'waved';
  export type SeriesHoverMode =
    | 'allArgumentPoints'
    | 'allSeriesPoints'
    | 'excludePoints'
    | 'includePoints'
    | 'nearestPoint'
    | 'none'
    | 'onlyPoint';
  export interface SeriesLabel {
    /**
     * Aligns point labels in relation to their points.
     */
    alignment?: HorizontalAlignment;
    /**
     * Formats the point argument before it is displayed in the point label. To format the point value, use the format property.
     */
    argumentFormat?: DevExpress.common.core.localization.Format | undefined;
    /**
     * Colors the point labels&apos; background. The default color is inherited from the points.
     */
    backgroundColor?: string | undefined;
    /**
     * Configures the borders of point labels.
     */
    border?: {
      /**
       * Colors the border.
       */
      color?: string | undefined;
      /**
       * Specifies the dash style of the border.
       */
      dashStyle?: DashStyle | undefined;
      /**
       * Makes the border visible.
       */
      visible?: boolean;
      /**
       * Specifies the width of the border in pixels.
       */
      width?: number;
    };
    /**
     * Configures the label connectors.
     */
    connector?: {
      /**
       * Colors the connectors.
       */
      color?: string | undefined;
      /**
       * Makes the connectors visible. Applies only if label.visible is set to true.
       */
      visible?: boolean;
      /**
       * Specifies the width of the connectors in pixels.
       */
      width?: number;
    };
    /**
     * Customizes text displayed by point labels.
     */
    customizeText?: (pointInfo: any) => string;
    /**
     * Specifies font properties for point labels.
     */
    font?: Font;
    /**
     * Formats the point value before it is displayed in the point label.
     */
    format?: DevExpress.common.core.localization.Format | undefined;
    /**
     * Along with verticalOffset, shifts point labels from their initial positions.
     */
    horizontalOffset?: number;
    /**
     * Specifies whether to display point labels inside or outside of series points. Applies only to bubble, range-like and bar-like series.
     */
    position?: RelativePosition;
    /**
     * Rotates point labels.
     */
    rotationAngle?: number;
    /**
     * Specifies whether or not to show labels for points with zero value. Applies only to bar-like series.
     */
    showForZeroValues?: boolean;
    /**
     * Along with horizontalOffset, shifts point labels from their initial positions.
     */
    verticalOffset?: number;
    /**
     * Makes the point labels visible.
     */
    visible?: boolean;
    /**
     * Specifies the label&apos;s text.
     */
    displayFormat?: string | undefined;
  }
  export interface SeriesPoint {
    /**
     * Configures the appearance of the series point border in scatter, line- and area-like series.
     */
    border?: {
      /**
       * Colors the border.
       */
      color?: string | undefined;
      /**
       * Makes the border visible.
       */
      visible?: boolean;
      /**
       * Sets the width of the border in pixels.
       */
      width?: number;
    };
    /**
     * Colors the series points.
     */
    color?: string | ChartsColor | undefined;
    /**
     * Specifies series elements to be highlighted when a user pauses on a series point.
     */
    hoverMode?: PointInteractionMode;
    /**
     * Configures the appearance adopted by a series point when a user pauses on it.
     */
    hoverStyle?: {
      /**
       * Configures the appearance of the point border when a user pauses on the point.
       */
      border?: {
        /**
         * Specifies the color of the point border when the point is in the hovered state.
         */
        color?: string | undefined;
        /**
         * Makes the border visible when a user pauses on the series point.
         */
        visible?: boolean;
        /**
         * Specifies the width of the point border when the point is in the hovered state.
         */
        width?: number;
      };
      /**
       * Specifies the color of series points in the hovered state.
       */
      color?: string | ChartsColor | undefined;
      /**
       * Specfies the diameter of series points in the hovered state.
       */
      size?: number | undefined;
    };
    /**
     * Substitutes the standard point symbols with an image.
     */
    image?:
      | string
      | undefined
      | {
          /**
           * Specifies the height of the image used instead of a point marker.
           */
          height?:
            | number
            | {
                /**
                 * Specifies the height of the image that represents the maximum point in a range area series.
                 */
                rangeMaxPoint?: number | undefined;
                /**
                 * Specifies the height of the image that represents the minimum point in a range area series.
                 */
                rangeMinPoint?: number | undefined;
              };
          /**
           * Specifies the URL of the image to be used as a point marker.
           */
          url?:
            | string
            | undefined
            | {
                /**
                 * Specifies the URL of the image to be used as a maximum point marker.
                 */
                rangeMaxPoint?: string | undefined;
                /**
                 * Specifies the URL of the image to be used as a maximum point marker.
                 */
                rangeMinPoint?: string | undefined;
              };
          /**
           * Specifies the width of an image that is used as a point marker.
           */
          width?:
            | number
            | {
                /**
                 * Specifies the width of the image that represents the maximum point in a range area series.
                 */
                rangeMaxPoint?: number | undefined;
                /**
                 * Specifies the width of the image that represents the minimum point in a range area series.
                 */
                rangeMinPoint?: number | undefined;
              };
        };
    /**
     * Specifies series elements to be highlighted when a user selects a series point.
     */
    selectionMode?: PointInteractionMode;
    /**
     * Configures the appearance of a selected series point.
     */
    selectionStyle?: {
      /**
       * Configures the border of a selected point.
       */
      border?: {
        /**
         * Specifies the color of the point border when the point is selected.
         */
        color?: string | undefined;
        /**
         * Makes the border of a selected point visible.
         */
        visible?: boolean;
        /**
         * Specifies the width of the point border when the point is selected.
         */
        width?: number;
      };
      /**
       * Specifies the color of series points in the selected state.
       */
      color?: string | ChartsColor | undefined;
      /**
       * Specfies the diameter of series points in the selected state.
       */
      size?: number | undefined;
    };
    /**
     * Specifies the diameter of series points in pixels.
     */
    size?: number;
    /**
     * Specifies which symbol should represent series points in scatter, line- and area-like series.
     */
    symbol?: PointSymbol;
    /**
     * Makes the series points visible.
     */
    visible?: boolean;
  }
  export type SeriesSelectionMode =
    | 'allArgumentPoints'
    | 'allSeriesPoints'
    | 'excludePoints'
    | 'includePoints'
    | 'none'
    | 'onlyPoint';
  export type SeriesType =
    | 'area'
    | 'bar'
    | 'bubble'
    | 'candlestick'
    | 'fullstackedarea'
    | 'fullstackedbar'
    | 'fullstackedline'
    | 'fullstackedspline'
    | 'fullstackedsplinearea'
    | 'line'
    | 'rangearea'
    | 'rangebar'
    | 'scatter'
    | 'spline'
    | 'splinearea'
    | 'stackedarea'
    | 'stackedbar'
    | 'stackedline'
    | 'stackedspline'
    | 'stackedsplinearea'
    | 'steparea'
    | 'stepline'
    | 'stock';
  export type ShiftLabelOverlap = 'hide' | 'none' | 'shift';
  export type TextOverflow = 'ellipsis' | 'hide' | 'none';
  export type Theme =
    | 'generic.dark'
    | 'generic.light'
    | 'generic.contrast'
    | 'generic.carmine'
    | 'generic.darkmoon'
    | 'generic.darkviolet'
    | 'generic.greenmist'
    | 'generic.softblue'
    | 'material.blue.light'
    | 'material.lime.light'
    | 'material.orange.light'
    | 'material.purple.light'
    | 'material.teal.light';
  export type TimeInterval =
    | 'day'
    | 'hour'
    | 'millisecond'
    | 'minute'
    | 'month'
    | 'quarter'
    | 'second'
    | 'week'
    | 'year';
  /**
   * A class describing various time intervals. Inherited by tick intervals in Chart and RangeSelector.
   */
  export type TimeIntervalConfig =
    | number
    | {
        /**
         * Specifies the time interval measured in days. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        days?: number;
        /**
         * Specifies the time interval measured in hours. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        hours?: number;
        /**
         * Specifies the time interval measured in milliseconds. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        milliseconds?: number;
        /**
         * Specifies the time interval measured in minutes. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        minutes?: number;
        /**
         * Specifies the time interval measured in months. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        months?: number;
        /**
         * Specifies the time interval measured in quarters. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        quarters?: number;
        /**
         * Specifies the time interval measured in seconds. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        seconds?: number;
        /**
         * Specifies the time interval measured in weeks. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        weeks?: number;
        /**
         * Specifies the time interval measured in years. Accepts integer values. Available only for an axis/scale that displays date-time values.
         */
        years?: number;
      }
    | TimeInterval
    | undefined;
  export type ValueAxisVisualRangeUpdateMode = 'auto' | 'keep' | 'reset';
  export type ValueErrorBarDisplayMode = 'auto' | 'high' | 'low' | 'none';
  export type ValueErrorBarType =
    | 'fixed'
    | 'percent'
    | 'stdDeviation'
    | 'stdError'
    | 'variance';
  /**
   * 
   */
  export type VisualRange = {
    /**
     * The range&apos;s end value.
     */
    endValue?: number | Date | string | undefined;
    /**
     * The range&apos;s length.
     */
    length?: TimeIntervalConfig;
    /**
     * The range&apos;s start value.
     */
    startValue?: number | Date | string | undefined;
  };
  export type VisualRangeUpdateMode = 'auto' | 'keep' | 'reset' | 'shift';
  export type WordWrap = 'normal' | 'breakWord' | 'none';
  export type ZoomPanAction = 'zoom' | 'pan';
}
declare module DevExpress.common.core.animation {
  /**
   * Defines animation properties.
   */
  export type AnimationConfig = {
    /**
     * A function called after animation is completed.
     */
    complete?: (
      $element: DevExpress.core.DxElement,
      config: AnimationConfig
    ) => void;
    /**
     * A number specifying wait time before animation execution.
     */
    delay?: number;
    /**
     * Specifies the animation direction for the &apos;slideIn&apos; and &apos;slideOut&apos; animation types.
     */
    direction?: Direction | undefined;
    /**
     * A number specifying the time in milliseconds spent on animation.
     */
    duration?: number;
    /**
     * A string specifying the easing function for animation.
     */
    easing?: string;
    /**
     * Specifies an initial animation state. Use the to property to specify the final state.
     */
    from?: AnimationState;
    /**
     * A number specifying the time period to wait before the animation of the next stagger item starts.
     */
    staggerDelay?: number | undefined;
    /**
     * A function called before animation is started.
     */
    start?: (
      $element: DevExpress.core.DxElement,
      config: AnimationConfig
    ) => void;
    /**
     * Specifies a final animation state. Use the from property to specify an initial state.
     */
    to?: AnimationState;
    /**
     * A string value specifying the animation type.
     */
    type?: AnimationType;
  };
  /**
   * A repository of animations.
   */
  export const animationPresets: {
    /**
     * Applies the changes made in the animation repository.
     */
    applyChanges(): void;
    /**
     * Removes all animations from the repository.
     */
    clear(): void;
    /**
     * Deletes an animation with a specific name.
     */
    clear(name: string): void;
    /**
     * Gets the configuration of an animation with a specific name.
     */
    getPreset(name: string): AnimationConfig;
    /**
     * Registers predefined animations in the animation repository.
     */
    registerDefaultPresets(): void;
    /**
     * Adds an animation with a specific name to the animation repository.
     */
    registerPreset(
      name: string,
      config: {
        animation: AnimationConfig;
        device?: DevExpress.common.core.environment.Device;
      }
    ): void;
    /**
     * Deletes all custom animations.
     */
    resetToDefaults(): void;
  };
  /**
   * Describes an animation state.
   */
  export type AnimationState =
    | string
    | number
    | {
        /**
         * Element opacity.
         */
        opacity: number;
      }
    | {
        /**
         * A value that controls element size.
         */
        scale: number;
      }
    | {
        /**
         * Element position.
         */
        position: PositionConfig;
      }
    | {
        /**
         * A shortcut that positions the element&apos;s left side relative to the parent element.
         */
        left: number;
      }
    | {
        /**
         * A shortcut that positions the element&apos;s top side relative to the parent element.
         */
        top: number;
      };
  /**
   * Cancels an animation frame request scheduled with the requestAnimationFrame method.
   */
  export function cancelAnimationFrame(requestID: number): void;
  export type CollisionResolution = 'fit' | 'flip' | 'flipfit' | 'none';
  export type CollisionResolutionCombination =
    | 'fit'
    | 'fit flip'
    | 'fit flipfit'
    | 'fit none'
    | 'flip'
    | 'flip fit'
    | 'flip none'
    | 'flipfit'
    | 'flipfit fit'
    | 'flipfit none'
    | 'none'
    | 'none fit'
    | 'none flip'
    | 'none flipfit';
  /**
   * An object that serves as a namespace for the methods that are used to animate UI elements.
   */
  export const fx: {
    /**
     * Animates an element.
     */
    animate(
      element: Element,
      config: AnimationConfig
    ): DevExpress.core.utils.DxPromise<void>;

    /**
     * Checks whether an element is being animated.
     */
    isAnimating(element: Element): boolean;

    /**
     * Stops an element&apos;s animation.
     */
    stop(element: Element, jumpToEnd: boolean): void;
  };
  /**
   * Configures the position of an overlay element.
   */
  export type PositionConfig = {
    /**
     * Specifies the target element&apos;s side or corner where the overlay element should be positioned.
     */
    at?:
      | PositionAlignment
      | {
          /**
           * Specifies a position in the horizontal direction (for left, right, or center alignment).
           */
          x?: HorizontalAlignment;
          /**
           * Specifies a position in the vertical direction (for top, bottom, or center alignment).
           */
          y?: VerticalAlignment;
        };
    /**
     * A boundary element in which the overlay element must be positioned.
     */
    boundary?: string | DevExpress.core.UserDefinedElement | Window;
    /**
     * Specifies the offset of boundaries from the boundary element.
     */
    boundaryOffset?:
      | string
      | {
          /**
           * Specifies a horizontal offset.
           */
          x?: number;
          /**
           * Specifies a vertical offset.
           */
          y?: number;
        };
    /**
     * Specifies how to resolve collisions - when the overlay element exceeds the boundary element.
     */
    collision?:
      | CollisionResolutionCombination
      | {
          /**
           * Specifies how to resolve horizontal collisions.
           */
          x?: CollisionResolution;
          /**
           * Specifies how to resolve vertical collisions.
           */
          y?: CollisionResolution;
        };
    /**
     * Specifies the overlay element&apos;s side or corner to align with a target element.
     */
    my?:
      | PositionAlignment
      | {
          /**
           * Specifies a position in the horizontal direction (for left, right, or center alignment).
           */
          x?: HorizontalAlignment;
          /**
           * Specifies a position in the vertical direction (for top, bottom, or center alignment).
           */
          y?: VerticalAlignment;
        };
    /**
     * The target element relative to which the overlay element should be positioned.
     */
    of?: string | DevExpress.core.UserDefinedElement | Window;
    /**
     * Specifies the overlay element&apos;s offset from a specified position.
     */
    offset?:
      | string
      | {
          /**
           * Specifies a horizontal offset.
           */
          x?: number;
          /**
           * Specifies a vertical offset.
           */
          y?: number;
        };
  };
  /**
   * Makes the browser call a function to update animation before the next repaint.
   */
  export function requestAnimationFrame(callback: Function): number;
  /**
   * The manager that performs several specified animations at a time.
   */
  export class TransitionExecutor {
    /**
     * Registers the set of elements that should be animated as &apos;entering&apos; using the specified animation configuration.
     */
    enter(
      elements: DevExpress.core.UserDefinedElementsArray,
      animation: AnimationConfig | string
    ): void;
    /**
     * Registers a set of elements that should be animated as &apos;leaving&apos; using the specified animation configuration.
     */
    leave(
      elements: DevExpress.core.UserDefinedElementsArray,
      animation: AnimationConfig | string
    ): void;
    /**
     * Deletes all the animations registered in the Transition Executor by using the enter(elements, animation) and leave(elements, animation) methods.
     */
    reset(): void;
    /**
     * Starts all the animations registered using the enter(elements, animation) and leave(elements, animation) methods beforehand.
     */
    start(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Stops all started animations.
     */
    stop(): void;
  }
}
declare module DevExpress.common.core.environment {
  /**
   * The device object defines the device on which the application is running.
   */
  export type Device = {
    /**
     * Indicates whether or not the device platform is Android.
     */
    android?: boolean;
    /**
     * Specifies the type of the device on which the application is running.
     */
    deviceType?: 'phone' | 'tablet' | 'desktop';
    /**
     * Indicates whether or not the device platform is generic, which means that the application will look and behave according to a generic &apos;light&apos; or &apos;dark&apos; theme.
     */
    generic?: boolean;
    /**
     * Specifies a performance grade of the current device.
     */
    grade?: 'A' | 'B' | 'C';
    /**
     * Indicates whether or not the device platform is iOS.
     */
    ios?: boolean;
    /**
     * Indicates whether or not the device type is &apos;phone&apos;.
     */
    phone?: boolean;
    /**
     * Specifies the platform of the device on which the application is running.
     */
    platform?: 'android' | 'ios' | 'generic';
    /**
     * Indicates whether or not the device type is &apos;tablet&apos;.
     */
    tablet?: boolean;
    /**
     * Specifies an array with the major and minor versions of the device platform.
     */
    version?: Array<number>;
  };
  /**
    * 
    */
   export const devices: DevExpress.core.DevicesObject;
  /**
   * Gets a list of time zone objects from the IANA time zone database.
   */
  export function getTimeZones(
    date?: Date,
    timeZones?: string[]
  ): Array<SchedulerTimeZone>;
  /**
   * Hides the last displayed overlay UI component.
   */
  export function hideTopOverlay(): boolean;
  /**
   * Sets parameters for the viewport meta tag. Takes effect for mobile applications only.
   */
  export function initMobileViewport(options: {
    allowZoom?: boolean;
    allowPan?: boolean;
    allowSelection?: boolean;
  }): void;
  /**
   * A time zone object.
   */
  export type SchedulerTimeZone = {
    /**
     * A time zone text string from the IANA database.
     */
    id: string;
    /**
     * A GMT offset.
     */
    offset: number;
    /**
     * A time zone in the following format: `(GMT ±[hh]:[mm]) [id]`.
     */
    title: string;
  };
}
declare module DevExpress.common.core.events {
  /**
   * 
   */
  export type AsyncCancelable = {
    /**
     * 
     */
    cancel: boolean | PromiseLike<boolean>;
  };
  /**
   * A type used in events. Specifies whether the event is cancelable.
   */
  export type Cancelable = {
    /**
     * Specifies whether the event is cancelable.
     */
    cancel?: boolean;
  };
  /**
   * Specifies arguments of `optionChanged` event.
   */
  export type ChangedOptionInfo = {
    /**
     * The modified property if it belongs to the first level. Otherwise, the first-level property into which it is nested.
     */
    readonly name: string;
    /**
     * The path to the modified property that includes all parent properties.
     */
    readonly fullName: string;
    /**
     * The modified property&apos;s new value.
     */
    readonly value?: any;
    /**
     * The UI component&apos;s previous value.
     */
    readonly previousValue?: any;
  };
  /**
   * A type that contains fields common for all events (`component`, `element`, `model`).
   */
  export type EventInfo<TComponent> = {
    /**
     * The UI component&apos;s instance.
     */
    readonly component: TComponent;
    /**
     * The UI component&apos;s container.
     */
    readonly element: DevExpress.core.DxElement;
    /**
     * Model data. Available only if you use Knockout.
     */
    readonly model?: any;
  };
  export type EventObject = DevExpress.events.EventObject;
  /**
   * Specifies arguments of `initialized` event.
   */
  export type InitializedEventInfo<TComponent> = {
    /**
     * The UI component&apos;s instance.
     */
    readonly component?: TComponent;
    /**
     * The UI component&apos;s container.
     */
    readonly element?: DevExpress.core.DxElement;
  };
  /**
   * Specifies item information used in events related to a component&apos;s items.
   */
  export type ItemInfo<TItemData = any> = {
    /**
     * The item&apos;s data.
     */
    readonly itemData?: TItemData;
    /**
     * The item&apos;s container.
     */
    readonly itemElement: DevExpress.core.DxElement;
    /**
     * The item&apos;s index.
     */
    readonly itemIndex: number;
  };
  /**
   * A type that contains fields common for all events (`component`, `element`, `model`) and the `event` field.
   */
  export type NativeEventInfo<TComponent, TNativeEvent = Event> = {
    /**
     * The UI component&apos;s instance.
     */
    readonly component: TComponent;
    /**
     * The UI component&apos;s container.
     */
    readonly element: DevExpress.core.DxElement;
    /**
     * Model data. Available only if you use Knockout.
     */
    readonly model?: any;
    /**
     * A native browser event with additional fields from `EventObject`.
     */
    readonly event?: DevExpress.events.DxEvent<TNativeEvent>;
  };
  /**
   * Detaches all handlers from the specified elements.
   */
  export function off(element: Element | Array<Element>): void;
  /**
   * Detaches all handlers of the specified event from the specified elements.
   */
  export function off(
    element: Element | Array<Element>,
    eventName: string
  ): void;
  /**
   * Detaches an event handler from the specified elements.
   */
  export function off(
    element: Element | Array<Element>,
    eventName: string,
    handler: Function
  ): void;
  /**
   * Detaches all event handlers of the specified type attached using the on(element, eventName, selector, data, handler) or on(element, eventName, selector, handler) method.
   */
  export function off(
    element: Element | Array<Element>,
    eventName: string,
    selector: string
  ): void;
  /**
   * Detaches the specified event handler attached using the on(element, eventName, selector, data, handler) or on(element, eventName, selector, handler) method.
   */
  export function off(
    element: Element | Array<Element>,
    eventName: string,
    selector: string,
    handler: Function
  ): void;
  /**
   * Attaches an event handler to the specified elements. Allows you to pass custom data to the handler.
   */
  export function on(
    element: Element | Array<Element>,
    eventName: string,
    data: any,
    handler: Function
  ): void;
  /**
   * Attaches an event handler to the specified elements.
   */
  export function on(
    element: Element | Array<Element>,
    eventName: string,
    handler: Function
  ): void;
  /**
   * Attaches an event handler to the specified elements&apos; descendants. Allows you to pass custom data to the handler.
   */
  export function on(
    element: Element | Array<Element>,
    eventName: string,
    selector: string,
    data: any,
    handler: Function
  ): void;
  /**
   * Attaches an event handler to the specified elements&apos; descendants.
   */
  export function on(
    element: Element | Array<Element>,
    eventName: string,
    selector: string,
    handler: Function
  ): void;
  /**
   * Attaches an event handler that is executed only once to the specified elements. Allows you to pass custom data to the handler.
   */
  export function one(
    element: Element | Array<Element>,
    eventName: string,
    data: any,
    handler: Function
  ): void;
  /**
   * Attaches an event handler that is executed only once to the specified elements.
   */
  export function one(
    element: Element | Array<Element>,
    eventName: string,
    handler: Function
  ): void;
  /**
   * Attaches an event handler that is executed only once to the specified elements&apos; descendants. Allows you to pass custom data to the handler.
   */
  export function one(
    element: Element | Array<Element>,
    eventName: string,
    selector: string,
    data: any,
    handler: Function
  ): void;
  /**
   * Attaches an event handler that is executed only once to the specified elements&apos; descendants.
   */
  export function one(
    element: Element | Array<Element>,
    eventName: string,
    selector: string,
    handler: Function
  ): void;
  /**
   * Triggers an event for the specified elements.
   */
  export function trigger(
    element: Element | Array<Element>,
    event: string | DevExpress.events.DxEvent
  ): void;
  /**
   * Triggers an event for the specified elements. Allows you to pass custom parameters to event handlers.
   */
  export function trigger(
    element: Element | Array<Element>,
    event: string | DevExpress.events.DxEvent,
    extraParameters: any
  ): void;
}
declare module DevExpress.common.core.localization {
  /**
   * Formats values.
   */
  export type Format =
    | FormatObject
    | PredefinedFormat
    | string
    | ((value: number | Date) => string)
    | ((value: Date) => string)
    | ((value: number) => string)
    | ExternalFormat
    | undefined;
  /**
   * Converts a Date object to a string using the specified format.
   */
  export function formatDate(value: Date, format: Format): string;
  /**
   * Substitutes the provided value(s) for placeholders in a message that the key specifies.
   */
  export function formatMessage(key: string, ...values: Array<string>): string;
  /**
   * Converts a numeric value to a string using the specified format.
   */
  export function formatNumber(value: number, format: Format): string;
  /**
   * Loads localized messages.
   */
  export function loadMessages(messages: any): void;
  /**
   * Gets the current locale identifier.
   */
  export function locale(): string;
  /**
    * Sets the current locale identifier.
    */
   export function locale(locale: string): void;
  /**
   * Parses a string into a Date object.
   */
  export function parseDate(text: string, format: Format): Date;
  /**
   * Parses a string into a numeric value.
   */
  export function parseNumber(text: string, format: Format): number;
}
declare module DevExpress.common.data {
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class AbstractStore<TItem = any, TKey = any> extends Store<
    TItem,
    TKey
  > {
    constructor(
      options?: DevExpress.common.data.AbstractStore.Options<TItem, TKey>
    );
    /**
     * Starts loading data.
     */
    load(): DevExpress.core.utils.DxExtendedPromise<Array<TItem>>;
    /**
     * Starts loading data.
     */
    load(
      options: LoadOptions<TItem>
    ): DevExpress.core.utils.DxExtendedPromise<Array<TItem>>;
  }
  module AbstractStore {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type Options<TItem = any, TKey = any> = AbstractStoreOptions<
      TItem,
      TKey
    >;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface AbstractStoreOptions<TItem = any, TKey = any>
    extends StoreOptions<TItem, TKey> {
    /**
     * A function that is executed after data is loaded to the store.
     */
    onLoaded?: (result: Array<TItem>, loadOptions: LoadOptions<TItem>) => void;
  }
  /**
   * Applies an array of changes to a source data array.
   */
  export function applyChanges(
    data: Array<any>,
    changes: Array<any>,
    options?: { keyExpr?: string | Array<string>; immutable?: boolean }
  ): Array<any>;
  /**
   * The ArrayStore is a store that provides an interface for loading and editing an in-memory array and handling related events.
   */
  export class ArrayStore<TItem = any, TKey = any> extends AbstractStore<
    TItem,
    TKey
  > {
    constructor(options?: ArrayStoreOptions<TItem, TKey>);
    /**
     * Gets a data item with a specific key.
     */
    byKey(key: TKey): DevExpress.core.utils.DxPromise<TItem>;
    /**
     * Clears all the ArrayStore&apos;s associated data.
     */
    clear(): void;
    /**
     * Creates a Query for the underlying array.
     */
    createQuery(): Query;
  }
  /**
   * 
   */
  export type ArrayStoreOptions<TItem = any, TKey = any> = AbstractStoreOptions<
    TItem,
    TKey
  > & {
    /**
     * Specifies the store&apos;s associated array.
     */
    data?: Array<TItem>;
  };
  /**
   * Encodes a string or array of bytes in Base64.
   */
  export function base64_encode(input: string | Array<number>): string;
  /**
   * Compiles a getter function from a getter expression.
   */
  export function compileGetter(expr: string | Array<string>): Function;
  /**
   * Compiles a setter function from a setter expression.
   */
  export function compileSetter(expr: string | Array<string>): Function;
  /**
   * The CustomStore enables you to implement custom data access logic for consuming data from any source.
   */
  export class CustomStore<TItem = any, TKey = any> extends Store<TItem, TKey> {
    constructor(options?: CustomStoreOptions<TItem, TKey>);
    /**
     * Gets a data item with a specific key.
     */
    byKey(
      key: TKey,
      extraOptions?: LoadOptions<TItem>
    ): DevExpress.core.utils.DxPromise<TItem>;
    /**
     * Deletes data from the cache. Takes effect only if the cacheRawData property is true.
     */
    clearRawDataCache(): void;
    /**
     * Starts loading data.
     */
    load(): DevExpress.core.utils.DxExtendedPromise<LoadResult<TItem>>;
    /**
     * Starts loading data.
     */
    load(
      options: LoadOptions<TItem>
    ): DevExpress.core.utils.DxExtendedPromise<LoadResult<TItem>>;
  }
  /**
   * 
   */
  export type CustomStoreOptions<TItem = any, TKey = any> = StoreOptions<
    TItem,
    TKey
  > & {
    /**
     * Specifies a custom implementation of the byKey(key) method.
     */
    byKey?: (
      key: TKey,
      extraOptions?: LoadOptions<TItem>
    ) => PromiseLike<TItem>;
    /**
     * Specifies whether raw data should be saved in the cache. Applies only if loadMode is &apos;raw&apos;.
     */
    cacheRawData?: boolean;
    /**
     * Specifies a custom implementation of the insert(values) method.
     */
    insert?: (values: TItem) => PromiseLike<TItem>;
    /**
     * Specifies a custom implementation of the load(options) method.
     */
    load: (
      options: LoadOptions<TItem>
    ) => LoadFunctionResult<LoadResult<TItem>>;
    /**
     * Specifies how data returned by the load function is treated.
     */
    loadMode?: 'processed' | 'raw';
    /**
     * A function that is executed after data is loaded to the store.
     */
    onLoaded?: (
      result: LoadResult<TItem>,
      loadOptions: LoadOptions<TItem>
    ) => void;
    /**
     * Specifies a custom implementation of the remove(key) method.
     */
    remove?: (key: TKey) => PromiseLike<void>;
    /**
     * Specifies a custom implementation of the totalCount(options) method.
     */
    totalCount?: (loadOptions: {
      filter?: FilterDescriptor | Array<FilterDescriptor>;
      group?: GroupDescriptor<TItem> | Array<GroupDescriptor<TItem>>;
    }) => PromiseLike<number>;
    /**
     * Specifies a custom implementation of the update(key, values) method.
     */
    update?: (key: TKey, values: TItem) => PromiseLike<any>;
    /**
     * Specifies whether the store combines the search and filter expressions. Defaults to true if the loadMode is &apos;raw&apos; and false if it is &apos;processed&apos;.
     */
    useDefaultSearch?: boolean | undefined;
  };
  /**
   * The DataSource is an object that provides an API for processing data from an underlying store.
   */
  export class DataSource<TItem = any, TKey = any> {
    constructor(data: Array<TItem>);
    constructor(
      options:
        | CustomStoreOptions<TItem, TKey>
        | DataSourceOptions<any, any, TItem, TKey>
    );
    constructor(store: DevExpress.data.utils.Store<TItem, TKey>);
    constructor(url: string);
    /**
     * Cancels the load operation with a specific identifier.
     */
    cancel(operationId: number): boolean;
    /**
     * Disposes of all the resources allocated to the DataSource instance.
     */
    dispose(): void;
    /**
     * Gets the filter property&apos;s value.
     */
    filter(): FilterDescriptor | Array<FilterDescriptor>;
    /**
     * Sets the filter property&apos;s value.
     */
    filter(filterExpr: FilterDescriptor | Array<FilterDescriptor>): void;
    /**
     * Gets the group property&apos;s value.
     */
    group(): GroupDescriptor<TItem> | Array<GroupDescriptor<TItem>>;
    /**
     * Sets the group property&apos;s value.
     */
    group(
      groupExpr: GroupDescriptor<TItem> | Array<GroupDescriptor<TItem>>
    ): void;
    /**
     * Checks whether the count of items on the current page is less than the pageSize. Takes effect only with enabled paging.
     */
    isLastPage(): boolean;
    /**
     * Checks whether data is loaded in the DataSource.
     */
    isLoaded(): boolean;
    /**
     * Checks whether data is being loaded in the DataSource.
     */
    isLoading(): boolean;
    /**
     * Gets an array of data items on the current page.
     */
    items(): Array<any>;
    /**
     * Gets the value of the underlying store&apos;s key property.
     */
    key(): string | Array<string>;
    /**
     * Starts loading data.
     */
    load(): DevExpress.core.utils.DxExtendedPromise<any>;
    /**
     * Gets an object with current data processing settings.
     */
    loadOptions(): LoadOptions<TItem>;
    /**
     * Detaches all event handlers from a single event.
     */
    off(eventName: DataSourceEventName): this;
    /**
     * Detaches a particular event handler from a single event.
     */
    off(eventName: DataSourceEventName, eventHandler: Function): this;
    /**
     * Subscribes to an event.
     */
    on(eventName: DataSourceEventName, eventHandler: Function): this;
    /**
     * Subscribes to events.
     */
    on(events: { [key in DataSourceEventName]?: Function }): this;
    /**
     * Gets the current page index.
     */
    pageIndex(): number;
    /**
     * Sets the index of the page that should be loaded on the next load() method call.
     */
    pageIndex(newIndex: number): void;
    /**
     * Gets the page size.
     */
    pageSize(): number;
    /**
     * Sets the page size.
     */
    pageSize(value: number): void;
    /**
     * Gets the paginate property&apos;s value.
     */
    paginate(): boolean;
    /**
     * Sets the paginate property&apos;s value.
     */
    paginate(value: boolean): void;
    /**
     * Clears currently loaded DataSource items and calls the load() method.
     */
    reload(): DevExpress.core.utils.DxExtendedPromise<any>;
    /**
     * Gets the requireTotalCount property&apos;s value.
     */
    requireTotalCount(): boolean;
    /**
     * Sets the requireTotalCount property&apos;s value.
     */
    requireTotalCount(value: boolean): void;
    /**
     * Gets the searchExpr property&apos;s value.
     */
    searchExpr(): string & Function & Array<string | Function>;
    /**
     * Sets the searchExpr property&apos;s value.
     */
    searchExpr(expr: string | Function | Array<string | Function>): void;
    /**
     * Gets the searchOperation property&apos;s value.
     */
    searchOperation(): string;
    /**
     * Sets the searchOperation property&apos;s value.
     */
    searchOperation(op: string): void;
    /**
     * Gets the searchValue property&apos;s value.
     */
    searchValue(): any;
    /**
     * Sets the searchValue property&apos;s value.
     */
    searchValue(value: any): void;
    /**
     * Gets the select property&apos;s value.
     */
    select(): SelectDescriptor<TItem>;
    /**
     * Sets the select property&apos;s value.
     */
    select(expr: SelectDescriptor<TItem>): void;
    /**
     * Gets the sort property&apos;s value.
     */
    sort(): SortDescriptor<TItem> | Array<SortDescriptor<TItem>>;
    /**
     * Sets the sort property&apos;s value.
     */
    sort(sortExpr: SortDescriptor<TItem> | Array<SortDescriptor<TItem>>): void;
    /**
     * Gets the instance of the store underlying the DataSource.
     */
    store(): DevExpress.data.utils.Store<TItem, TKey>;
    /**
     * Gets the number of data items in the store after the last load() operation without paging. Takes effect only if requireTotalCount is true
     */
    totalCount(): number;
  }
  /**
   * 
   */
  export type DataSourceOptions<
    TStoreItem = any,
    TMappedItem = TStoreItem,
    TItem = TMappedItem,
    TKey = any
  > = {
    /**
     * Custom parameters that should be passed to an OData service with the load query. Available only for the ODataStore.
     */
    customQueryParams?: any;
    /**
     * Specifies the navigation properties to be loaded with the OData entity. Available only for the ODataStore.
     */
    expand?: Array<string> | string;
    /**
     * Specifies data filtering conditions.
     */
    filter?: FilterDescriptor | Array<FilterDescriptor>;
    /**
     * Specifies data grouping properties.
     */
    group?: GroupDescriptor<TItem> | Array<GroupDescriptor<TItem>>;
    /**
      * Specifies parameters for language-specific sorting and filtering.
      */
     langParams?: LangParams;
    /**
     * Specifies an item mapping function.
     */
    map?: (dataItem: TStoreItem) => TMappedItem;
    /**
     * A function that is executed after data is loaded.
     */
    onChanged?: (e: { readonly changes?: Array<TMappedItem> }) => void;
    /**
     * A function that is executed when data loading fails.
     */
    onLoadError?: (error: { readonly message?: string }) => void;
    /**
     * A function that is executed when the data loading status changes.
     */
    onLoadingChanged?: (isLoading: boolean) => void;
    /**
     * Specifies the maximum number of data items per page. Applies only if paginate is true.
     */
    pageSize?: number;
    /**
     * Specifies whether the DataSource loads data items by pages or all at once. Defaults to false if group is set; otherwise, true.
     */
    paginate?: boolean | undefined;
    /**
     * Specifies a post processing function.
     */
    postProcess?: (data: Array<TMappedItem>) => Array<TItem>;
    /**
     * Specifies the period (in milliseconds) when changes are aggregated before pushing them to the DataSource.
     */
    pushAggregationTimeout?: number | undefined;
    /**
     * Specifies whether the DataSource requests the total count of data items in the storage.
     */
    requireTotalCount?: boolean;
    /**
     * Specifies whether to reapply sorting, filtering, grouping, and other data processing operations after receiving a push.
     */
    reshapeOnPush?: boolean;
    /**
     * Specifies the fields to search.
     */
    searchExpr?: string | Function | Array<string | Function>;
    /**
     * Specifies the comparison operation used in searching.
     */
    searchOperation?: SearchOperation;
    /**
     * Specifies the value to which the search expression is compared.
     */
    searchValue?: any;
    /**
     * Specifies the fields to select from data objects.
     */
    select?: SelectDescriptor<TItem>;
    /**
     * Specifies data sorting properties.
     */
    sort?: SortDescriptor<TItem> | Array<SortDescriptor<TItem>>;
    /**
     * Configures the store underlying the DataSource.
     */
    store?:
      | Array<TStoreItem>
      | DevExpress.data.utils.Store<TStoreItem, TKey>
      | DevExpress.data.utils.StoreOptions<TStoreItem, TKey>;
  };
  /**
   * The EdmLiteral is an object for working with primitive data types from the OData&apos;s Abstract Type System that are not supported in JavaScript.
   */
  export class EdmLiteral {
    constructor(value: string);
    /**
     * Gets the EdmLiteral&apos;s value converted to a string.
     */
    valueOf(): string;
  }
  /**
   * The EndpointSelector is an object for managing OData endpoints in your application.
   */
  export class EndpointSelector {
    constructor(options: any);
    /**
     * Gets an endpoint with a specific key.
     */
    urlFor(key: string): string;
  }
  /**
   * Specifies the function that is executed when a data layer object throws an error.
   * @deprecated Use setErrorHandler instead.
   */
  export function errorHandler(e: Error): void;
  /**
   * 
   */
  export type FilterDescriptor = DevExpress.data.FilterDescriptor;
  /**
   * 
   */
  export type GroupDescriptor<T> = DevExpress.data.GroupDescriptor<T>;
  export type GroupingInterval = DevExpress.data.GroupingInterval;
  /**
   * An additional type for LoadResult.
   */
  export type GroupItem<TItem = any> = {
    /**
     * A key to group items by.
     */
    key: any | string | number;
    /**
     * Contains an array of items or GroupItems, or nothing.
     */
    items: Array<TItem> | Array<GroupItem<TItem>> | null;
    /**
     * A total number of items.
     */
    count?: number;
    /**
     * A summary array that contains the resulting values in the same order as the summary definitions.
     */
    summary?: Array<any>;
  };
  /**
   * A type guard function that checks whether LoadResult is an array of GroupItems.
   */
  export function isGroupItemsArray<TItem>(
    res: LoadResult<TItem>
  ): res is Array<GroupItem<TItem>>;
  /**
   * A type guard function that checks whether LoadResult is an array of items.
   */
  export function isItemsArray<TItem>(
    res: LoadResult<TItem>
  ): res is Array<TItem>;
  /**
   * A type guard function that checks whether LoadResult is a LoadResultObject.
   */
  export function isLoadResultObject<TItem>(
    res: LoadResult<TItem>
  ): res is LoadResultObject<TItem>;
  /**
   * Contains built-in OData type converters (for String, Int32, Int64, Boolean, Single, Decimal, and Guid) and allows you to register a custom type converter.
   */
  export var keyConverters: any;
  /**
   * Specifies parameters for language-specific sorting and filtering.
   */
  export type LangParams = {
    /**
     * Specifies the locale whose features affect sorting and filtering.
     */
    locale: string;
    /**
     * Specifies Intl.Collator options.
     */
    collatorOptions?: Intl.CollatorOptions;
  };
  /**
   * This section describes the loadOptions object&apos;s fields.
   */
  export type LoadOptions<T = any> = DevExpress.data.LoadOptions<T>;
  /**
   * Specifies returned data of the `load()` method in CustomStore.
   */
  export type LoadResult<TItem = any> =
    | Object
    | LoadResultArray<TItem>
    | LoadResultObject<TItem>;
  /**
   * An additional type for LoadResult.
   */
  export type LoadResultObject<TItem = any> = {
    /**
     * Contains an array of items or GroupItems.
     */
    data: Array<TItem> | Array<GroupItem<TItem>>;
    /**
     * A total number of items.
     */
    totalCount?: number;
    /**
     * A summary array that contains the resulting values in the same order as the summary definitions.
     */
    summary?: Array<any>;
    /**
     * A number of groups.
     */
    groupCount?: number;
  };
  /**
   * The LocalStore is a store that provides an interface for loading and editing data from HTML Web Storage (also known as window.localStorage) and handling related events.
   */
  export class LocalStore<TItem = any, TKey = any> extends ArrayStore<
    TItem,
    TKey
  > {
    constructor(options?: LocalStoreOptions<TItem, TKey>);
    /**
     * Removes data from the local storage.
     */
    clear(): void;
  }
  /**
   * 
   */
  export type LocalStoreOptions<TItem = any, TKey = any> = ArrayStoreOptions<
    TItem,
    TKey
  > & {
    /**
     * Specifies a delay in milliseconds between when data changes and the moment these changes are saved in the local storage. Applies only if immediate is false.
     */
    flushInterval?: number;
    /**
     * Specifies whether the LocalStore saves changes in the local storage immediately.
     */
    immediate?: boolean;
    /**
     * Specifies the name under which data should be saved in the local storage. The `dx-data-localStore-` prefix will be added to the name.
     */
    name?: string;
  };
  /**
   * The ODataContext is an object that provides access to an entire OData service.
   */
  export class ODataContext {
    constructor(options?: ODataContextOptions);
    /**
     * Invokes an OData operation that returns a value.
     */
    get(
      operationName: string,
      params: any
    ): DevExpress.core.utils.DxPromise<any>;
    /**
     * Invokes an OData operation that returns nothing.
     */
    invoke(
      operationName: string,
      params: any,
      httpMethod: HttpMethod
    ): DevExpress.core.utils.DxPromise<void>;
    /**
     * Gets a link to an entity with a specific key.
     */
    objectLink(entityAlias: string, key: any | string | number): any;
  }
  /**
   * 
   */
  export type ODataContextOptions = {
    /**
     * Specifies a function that customizes the request before it is sent to the server.
     */
    beforeSend?: (options: {
      url: string;
      async: boolean;
      method: string;
      timeout: number;
      params: any;
      payload: any;
      headers: any;
    }) => void;
    /**
     * Specifies whether stores in the ODataContext serialize/parse date-time values.
     */
    deserializeDates?: boolean;
    /**
     * Specifies entity collections to be accessed.
     */
    entities?: any;
    /**
     * Specifies a function that is executed when the ODataContext throws an error.
     */
    errorHandler?: (e: {
      httpStatus: number;
      errorDetails: any;
      requestOptions: ODataRequestOptions;
    }) => void;
    /**
     * Specifies whether to convert string values to lowercase in filter and search requests. Applies to the following operations: &apos;startswith&apos;, &apos;endswith&apos;, &apos;contains&apos;, and &apos;notcontains&apos;.
     */
    filterToLower?: boolean;
    /**
     * Specifies whether data should be sent using JSONP.
     */
    jsonp?: boolean;
    /**
     * Specifies the URL of an OData service.
     */
    url?: string;
    /**
     * Specifies the OData version.
     */
    version?: number;
    /**
     * Specifies whether to send cookies, authorization headers, and client certificates in a cross-origin request.
     */
    withCredentials?: boolean;
  };
  /**
   * The ODataStore is a store that provides an interface for loading and editing data from an individual OData entity collection and handling related events.
   */
  export class ODataStore<TItem = any, TKey = any> extends AbstractStore<
    TItem,
    TKey
  > {
    constructor(options?: ODataStoreOptions<TItem, TKey>);
    /**
     * Gets an entity with a specific key.
     */
    byKey(
      key: TKey,
      extraOptions?: {
        expand?: string | Array<string>;
        select?: string | Array<string>;
      }
    ): DevExpress.core.utils.DxPromise<TItem>;
    /**
     * Creates a Query for the OData endpoint.
     */
    createQuery(loadOptions?: {
      expand?: string | Array<string>;
      requireTotalCount?: boolean;
      customQueryParams?: any;
    }): Query;
  }
  /**
   * 
   */
  export type ODataStoreOptions<TItem = any, TKey = any> = AbstractStoreOptions<
    TItem,
    TKey
  > & {
    /**
     * Specifies a function that customizes the request before it is sent to the server.
     */
    beforeSend?: (options: {
      url: string;
      async: boolean;
      method: string;
      timeout: number;
      params: any;
      payload: any;
      headers: any;
    }) => void;
    /**
     * Specifies whether the store serializes/parses date-time values.
     */
    deserializeDates?: boolean;
    /**
     * Specifies a function that is executed when the ODataStore throws an error.
     */
    errorHandler?: (e: {
      httpStatus: number;
      errorDetails: any;
      requestOptions: ODataRequestOptions;
    }) => void;
    /**
     * Specifies the data field types. Accepts the following types: &apos;String&apos;, &apos;Int32&apos;, &apos;Int64&apos;, &apos;Boolean&apos;, &apos;Single&apos;, &apos;Decimal&apos; and &apos;Guid&apos;.
     */
    fieldTypes?: any;
    /**
     * Specifies whether to convert string values to lowercase in filter and search requests. Applies to the following operations: &apos;startswith&apos;, &apos;endswith&apos;, &apos;contains&apos;, and &apos;notcontains&apos;.
     */
    filterToLower?: boolean;
    /**
     * Specifies whether data should be sent using JSONP.
     */
    jsonp?: boolean;
    /**
     * Specifies the type of the key property or properties.
     */
    keyType?:
      | 'String'
      | 'Int32'
      | 'Int64'
      | 'Guid'
      | 'Boolean'
      | 'Single'
      | 'Decimal'
      | any;
    /**
     * Specifies the URL of an OData entity collection.
     */
    url?: string;
    /**
     * Specifies the OData version.
     */
    version?: number;
    /**
     * Specifies whether to send cookies, authorization headers, and client certificates in a cross-origin request.
     */
    withCredentials?: boolean;
  };
  /**
   * Creates a Query instance.
   */
  export function query(array: Array<any>, queryOptions?: any): Query;
  /**
   * Creates a Query instance that accesses a remote data service using its URL.
   */
  export function query(url: string, queryOptions: any): Query;
  /**
   * The Query is an object that provides a chainable interface for making data queries.
   */
  export type Query = {
    /**
     * Calculates a custom summary for all data items.
     */
    aggregate(
      seed: any,
      step: Function,
      finalize: Function
    ): DevExpress.core.utils.DxPromise<any>;
    /**
     * Calculates a custom summary for all data items.
     */
    aggregate(step: Function): DevExpress.core.utils.DxPromise<any>;
    /**
     * Calculates the average of all values. Applies only to numeric arrays.
     */
    avg(): DevExpress.core.utils.DxPromise<number>;
    /**
     * Calculates the average of all values found using a getter.
     */
    avg(getter: any): DevExpress.core.utils.DxPromise<number>;
    /**
     * Calculates the number of data items.
     */
    count(): DevExpress.core.utils.DxPromise<number>;
    /**
     * Executes the Query. This is an asynchronous alternative to the toArray() method.
     */
    enumerate(): DevExpress.core.utils.DxPromise<any>;
    /**
     * Filters data items using a filter expression.
     */
    filter(criteria: Array<any>): Query;
    /**
     * Filters data items using a custom function.
     */
    filter(predicate: Function): Query;
    /**
     * Groups data items by the specified getter.
     */
    groupBy(getter: any): Query;
    /**
     * Calculates the maximum value. Applies only to numeric arrays.
     */
    max(): DevExpress.core.utils.DxPromise<number | Date>;
    /**
     * Calculates the maximum of all values found using a getter.
     */
    max(getter: any): DevExpress.core.utils.DxPromise<number | Date>;
    /**
     * Calculates the minimum value. Applies only to numeric arrays.
     */
    min(): DevExpress.core.utils.DxPromise<number | Date>;
    /**
     * Calculates the minumum of all values found using a getter.
     */
    min(getter: any): DevExpress.core.utils.DxPromise<number | Date>;
    /**
     * Selects individual fields from data objects.
     */
    select(...getters: any[]): Query;
    /**
     * Gets a specified number of data items starting from a given index.
     */
    slice(skip: number, take?: number): Query;
    /**
     * Sorts data items by the specified getter in ascending order.
     */
    sortBy(getter: any): Query;
    /**
     * Sorts data items by the specified getter in the specified sorting order.
     */
    sortBy(getter: any, desc: boolean): Query;
    /**
     * Calculates the sum of all values.
     */
    sum(): DevExpress.core.utils.DxPromise<number>;
    /**
     * Calculates the sum of all values found using a getter.
     */
    sum(getter: any): DevExpress.core.utils.DxPromise<number>;
    /**
     * Sorts data items by one more getter in ascending order.
     */
    thenBy(getter: any): Query;
    /**
     * Sorts data items by one more getter in the specified sorting order.
     */
    thenBy(getter: any, desc: boolean): Query;
    /**
     * Gets data items associated with the Query. This is a synchronous alternative to the enumerate() method.
     */
    toArray(): Array<any>;
  };
  /**
   * Specifies returned data of the `load()` method in CustomStore.
   * @deprecated Use LoadResult instead.
   */
  export type ResolvedData<TItem = any> = LoadResult<TItem>;
  export type SearchOperation = DevExpress.data.SearchOperation;
  /**
   * 
   */
  export type SelectDescriptor<T> = DevExpress.data.SelectDescriptor<T>;
  /**
   * A method that specifies a function to be executed when a Data Layer component throws an error.
   */
  export function setErrorHandler(handler: (e: Error) => void): void;
  /**
   * 
   */
  export type SortDescriptor<T> = DevExpress.data.SortDescriptor<T>;
  /**
   * The base class for all Stores.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class Store<TItem = any, TKey = any> {
    constructor(options?: StoreOptions<TItem, TKey>);
    /**
     * Adds a data item to the store.
     */
    insert(values: TItem): DevExpress.core.utils.DxExtendedPromise<TItem>;
    /**
     * Gets the key property (or properties) as specified in the key property.
     */
    key(): string | Array<string>;
    /**
     * Gets a data item&apos;s key value.
     */
    keyOf(obj: TItem): TKey;
    /**
     * Detaches all event handlers from a single event.
     */
    off(eventName: DevExpress.data.StoreEventName): this;
    /**
     * Detaches a particular event handler from a single event.
     */
    off(
      eventName: DevExpress.data.StoreEventName,
      eventHandler: Function
    ): this;
    /**
     * Subscribes to an event.
     */
    on(eventName: DevExpress.data.StoreEventName, eventHandler: Function): this;
    /**
     * Subscribes to events.
     */
    on(events: { [key in DevExpress.data.StoreEventName]?: Function }): this;
    /**
     * Pushes data changes to the store and notifies the DataSource.
     */
    push(
      changes: Array<{
        type: 'insert' | 'update' | 'remove';
        data?: DevExpress.core.DeepPartial<TItem>;
        key?: TKey;
        index?: number;
      }>
    ): void;
    /**
     * Removes a data item with a specific key from the store.
     */
    remove(key: TKey): DevExpress.core.utils.DxPromise<void>;
    /**
     * Gets the total count of items the load() function returns.
     */
    totalCount(obj: {
      filter?: FilterDescriptor | Array<FilterDescriptor>;
      group?: GroupDescriptor<TItem> | Array<GroupDescriptor<TItem>>;
    }): DevExpress.core.utils.DxPromise<number>;
    /**
     * Updates a data item with a specific key.
     */
    update(
      key: TKey,
      values: DevExpress.core.DeepPartial<TItem>
    ): DevExpress.core.utils.DxExtendedPromise<TItem>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type StoreOptions<TItem = any, TKey = any> = {
    /**
     * Specifies the function that is executed when the store throws an error.
     */
    errorHandler?: Function;
    /**
     * Specifies the key property (or properties) that provide(s) key values to access data items. Each key value must be unique.
     */
    key?: string | Array<string>;
    /**
     * A function that is executed after a data item is added to the store.
     */
    onInserted?: (values: TItem, key: TKey) => void;
    /**
     * A function that is executed before a data item is added to the store.
     */
    onInserting?: (values: TItem) => void;
    /**
     * A function that is executed before data is loaded to the store.
     */
    onLoading?: (loadOptions: LoadOptions<TItem>) => void;
    /**
     * A function that is executed after a data item is added, updated, or removed from the store.
     */
    onModified?: Function;
    /**
     * A function that is executed before a data item is added, updated, or removed from the store.
     */
    onModifying?: Function;
    /**
     * The function executed before changes are pushed to the store.
     */
    onPush?: (changes: Array<TItem>) => void;
    /**
     * A function that is executed after a data item is removed from the store.
     */
    onRemoved?: (key: TKey) => void;
    /**
     * A function that is executed before a data item is removed from the store.
     */
    onRemoving?: (key: TKey) => void;
    /**
     * A function that is executed after a data item is updated in the store.
     */
    onUpdated?: (key: TKey, values: TItem) => void;
    /**
     * A function that is executed before a data item is updated in the store.
     */
    onUpdating?: (key: TKey, values: TItem) => void;
  };
  /**
   * A total summary expression for `loadOptions`.
   */
  export type SummaryDescriptor<T> = DevExpress.data.SummaryDescriptor<T>;
}
declare module DevExpress.common.Export.excel {
  export type DataGridCell = DevExpress.excelExporter.ExcelDataGridCell;
  /**
   * Properties that can be passed to the exportDataGrid(options) method from the excelExporter module.
   */
  export type DataGridExportOptions =
    DevExpress.excelExporter.ExcelExportBaseOptions & {
      /**
       * A DataGrid instance. This setting is required.
       */
      component?: DevExpress.ui.dxDataGrid | undefined;
      /**
       * Specifies whether to export only selected rows.
       */
      selectedRowsOnly?: boolean;
      /**
       * Specifies whether to enable Excel filtering in the document.
       */
      autoFilterEnabled?: boolean;
      /**
       * Customizes an Excel cell after creation.
       */
      customizeCell?: (options: {
        gridCell?: DataGridCell;
        excelCell?: any;
      }) => void;
    };
  /**
   * Exports grid data to Excel.
   */
  export function exportDataGrid(
    options: DataGridExportOptions
  ): DevExpress.core.utils.DxPromise<DevExpress.excelExporter.CellRange>;
  /**
   * Exports pivot grid data to Excel.
   */
  export function exportPivotGrid(
    options: PivotGridExportOptions
  ): DevExpress.core.utils.DxPromise<DevExpress.excelExporter.CellRange>;
  export type PivotGridCell = DevExpress.excelExporter.ExcelPivotGridCell;
  /**
   * Properties that can be passed to the exportPivotGrid(options) method from the excelExporter module.
   */
  export type PivotGridExportOptions =
    DevExpress.excelExporter.ExcelExportBaseOptions & {
      /**
       * A PivotGrid instance. This setting is required.
       */
      component?: DevExpress.ui.dxPivotGrid | undefined;
      /**
       * Specifies whether to merge neighbouring cells in the row field if they have the same values.
       */
      mergeRowFieldValues?: boolean;
      /**
       * Specifies whether to merge neighbouring cells in the column field if they have the same values.
       */
      mergeColumnFieldValues?: boolean;
      /**
       * Specifies whether to export headers of the filter fields on the field panel.
       */
      exportFilterFieldHeaders?: boolean;
      /**
       * Specifies whether to export headers of the data fields on the field panel.
       */
      exportDataFieldHeaders?: boolean;
      /**
       * Specifies whether to export headers of the column fields on the field panel.
       */
      exportColumnFieldHeaders?: boolean;
      /**
       * Specifies whether to export headers of the row fields on the field panel.
       */
      exportRowFieldHeaders?: boolean;
      /**
       * Customizes an Excel cell after creation.
       */
      customizeCell?: (options: {
        pivotCell?: PivotGridCell;
        excelCell?: any;
      }) => void;
    };
}
declare module DevExpress.common.Export.pdf {
  /**
   * An object that configures export to PDF settings in a DataGrid cell.
   */
  export type Cell = {
    /**
     * Specifies the background color of the cell.
     */
    backgroundColor?: string;
    /**
     * Specifies the color of the cell&apos;s outer borders.
     */
    borderColor?: string;
    /**
     * Specifies the width of the cell&apos;s borders.
     */
    borderWidth?: number;
    /**
     * Specifies whether to show cell&apos;s left border.
     */
    drawLeftBorder?: boolean;
    /**
     * Specifies whether to show cell&apos;s top border.
     */
    drawTopBorder?: boolean;
    /**
     * Specifies whether to show cell&apos;s right border.
     */
    drawRightBorder?: boolean;
    /**
     * Specifies whether to show cell&apos;s bottom border.
     */
    drawBottomBorder?: boolean;
    /**
     * An object that contains information about the font&apos;s size, name, and style.
     */
    font?: {
      /**
       * Specifies the font size.
       */
      size?: number;
      /**
       * Specifies the font name.
       */
      name?: string;
      /**
       * Specifies the font style.
       */
      style?: 'normal' | 'bold' | 'italic';
    };
    /**
     * Specifies the horizontal alignment for the text inside the exported cell.
     */
    horizontalAlign?: 'left' | 'center' | 'right';
    /**
     * Specifies the top, bottom, left, and right paddings of the DataGrid cell.
     */
    padding?: {
      /**
       * Specifies the top padding of the DataGrid cell.
       */
      top?: number;
      /**
       * Specifies the left padding of the DataGrid cell.
       */
      left?: number;
      /**
       * Specifies the right padding of the DataGrid cell.
       */
      right?: number;
      /**
       * Specifies the bottom padding of the DataGrid cell.
       */
      bottom?: number;
    };
    /**
     * The cell&apos;s text.
     */
    text?: string;
    /**
     * Specifies the text color for the cell.
     */
    textColor?: string;
    /**
     * Specifies the vertical alignment for the text inside the exported cell.
     */
    verticalAlign?: 'top' | 'middle' | 'bottom';
    /**
     * Specifies whether to enable word wrapping in the resulting PDF file.
     */
    wordWrapEnabled?: boolean;
  };
  export type DataGridCell = DevExpress.pdfExporter.PdfDataGridCell;
  /**
   * Properties that can be passed as a parameter to the exportDataGrid(options) method from the pdfExporter module.
   */
  export type DataGridExportOptions = {
    /**
     * A jsPDF instance. This setting is required.
     */
    jsPDFDocument?: object | undefined;
    /**
     * A DataGrid instance. This setting is required.
     */
    component?: DevExpress.ui.dxDataGrid | undefined;
    /**
     * Specifies the top left position of the DataGrid in the exported PDF document. Contains x and y properties. You can locate this position only below the page margins.
     */
    topLeft?: {
      /**
       * Specifies the horizontal position of the exported DataGrid.
       */
      x?: number;
      /**
       * Specifies the vertical position of the exported DataGrid.
       */
      y?: number;
    };
    /**
     * Specifies a custom width for the exported DataGrid columns.
     */
    columnWidths?: Array<number> | undefined;
    /**
     * Specifies the width of the indent of data rows relative to their group header row.
     */
    indent?: number;
    /**
     * Specifies the margin for the top, bottom, left, and right sides of the exported Grid.
     */
    margin?: {
      /**
       * Specifies the margin at the top of the page.
       */
      top?: number;
      /**
       * Specifies the margin at the left side of the page.
       */
      left?: number;
      /**
       * Specifies the margin at the right side of the page.
       */
      right?: number;
      /**
       * Specifies the margin at the bottom of the page.
       */
      bottom?: number;
    };
    /**
     * Specifies whether to repeat the DataGrid column headers on each page.
     */
    repeatHeaders?: boolean;
    /**
     * Specifies whether or not to export only selected rows.
     */
    selectedRowsOnly?: boolean;
    /**
     * A function that allows you to draw cell content of the exported DataGrid. This function is executed before the cell is exported.
     */
    customDrawCell?: (options: {
      gridCell?: DataGridCell;
      pdfCell?: Cell;
      doc?: any;
      rect?: { x: number; y: number; h: number; w: number };
      cancel?: boolean;
    }) => void;
    /**
     * Customizes a cell in PDF after creation.
     */
    customizeCell?: (options: {
      gridCell?: DataGridCell;
      pdfCell?: Cell;
    }) => void;
    /**
     * A function that allows you to customize the height of the exported row. This function is executed before the row export.
     */
    onRowExporting?: (options: {
      rowCells?: Array<Cell>;
      rowHeight?: number;
    }) => void;
    /**
     * Configures the load panel.
     */
    loadPanel?: ExportLoadPanel;
  };
  /**
   * Exports grid data to a PDF file.
   */
  export function exportDataGrid(
    options: DataGridExportOptions
  ): DevExpress.core.utils.DxPromise<void>;
  /**
   * Exports Gantt data to a PDF file.
   */
  export function exportGantt(
    options: GanttExportOptions
  ): DevExpress.core.utils.DxPromise<any>;
  /**
   * Configures a custom font used for the Gantt data export.
   */
  export type GanttExportFont = {
    /**
     * A custom font object.
     */
    fontObject: object | undefined;
    /**
     * The font name.
     */
    name: string | undefined;
    /**
     * The font style.
     */
    style?: string;
    /**
     * The font weight.
     */
    weight?: string | number | undefined;
  };
  /**
   * Properties that you can pass as a parameter to the exportGantt(options) method from the pdfExporter module.
   */
  export type GanttExportOptions = {
    /**
     * A function that creates a PDF document.
     */
    createDocumentMethod?: (options: any) => object;
    /**
     * A jsPDF instance. This setting is required.
     */
    jsPDFDocument?: object | undefined;
    /**
     * A Gantt instance. This setting is required.
     */
    component?: DevExpress.ui.dxGantt | undefined;
    /**
     * Specifies the document size.
     */
    format?: string | object | undefined;
    /**
     * Specifies whether to use horizontal orientation for the document.
     */
    landscape?: boolean;
    /**
     * Specifies the file name.
     */
    fileName?: string | undefined;
    /**
     * Specifies the outer indents of the exported area.
     */
    margins?: object | undefined;
    /**
     * Specifies which part of the component to export (chart area, tree list area, or the entire component).
     */
    exportMode?: DevExpress.ui.dxGantt.GanttPdfExportMode;
    /**
     * Specifies the date range for which to export tasks.
     */
    dateRange?: DevExpress.ui.dxGantt.GanttPdfExportDateRange | object;
    /**
     * Specifies the font.
     */
    font?: GanttExportFont;
  };
}
declare module DevExpress.common.grids {
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type AdaptiveDetailRowPreparingInfo = {
    /**
     * 
     */
    readonly formOptions: any;
  };
  export type AIColumnMode = 'auto' | 'manual';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type AIColumnRequestCreatingInfo<TRowData = any> = {
    /**
     * The AI column that initiated the request.
     */
    readonly column: ColumnBase;
    /**
     * widget data included in the AI request.
     */
    data: TRowData[];
    /**
     * Allows you to cancel the AI request.
     */
    cancel?: boolean;
    /**
     * Additional data to include in the request.
     */
    additionalInfo?: Record<string, any>;
    /**
     * Configures whether the component uses cached results.
     */
    useCache?: boolean;
  };
  export type ApplyChangesMode = 'instantly' | 'onDemand';
  export type ApplyFilterMode = 'auto' | 'onClick';
  /**
   * Configures AI options for a column.
   */
  export type ColumnAIOptions = {
    /**
     * Binds the column to an AI service.
     */
    aiIntegration?: DevExpress.aiIntegration.AIIntegration | undefined;
    /**
     * The column&apos;s initial AI prompt.
     */
    prompt?: string;
    /**
     * Configures whether the column sends AI requests automatically or on demand.
     */
    mode?: AIColumnMode;
    /**
     * Configures menu button visibility in the AI column header.
     */
    showHeaderMenu?: boolean;
    /**
     * Text displayed in AI column cells if the AI service returns no data.
     */
    noDataText?: string;
    /**
     * Text displayed in AI column cells that contain empty values.
     */
    emptyText?: string;
    /**
     * Configures the AI column&apos;s prompt editor popup (a DevExtreme Popup component).
     */
    popup?: DevExpress.ui.dxPopup.Properties;
    /**
     * Configures the AI column&apos;s prompt editor input (a DevExtreme TextArea component).
     */
    editorOptions?: DevExpress.ui.dxTextBox.Properties;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ColumnBase<TRowData = any> {
    /**
     * Configures AI options for the column.
     */
    ai?: ColumnAIOptions;
    /**
     * Aligns the content of the column.
     */
    alignment?: HorizontalAlignment | undefined;
    /**
     * Specifies whether a user can edit values in the column at runtime. By default, inherits the value of the editing.allowUpdating property.
     */
    allowEditing?: boolean;
    /**
     * Specifies whether data can be filtered by this column. Applies only if filterRow.visible is true.
     */
    allowFiltering?: boolean;
    /**
     * Specifies whether a user can fix the column at runtime. Applies only if columnFixing.enabled is true.
     */
    allowFixing?: boolean;
    /**
     * Specifies whether the header filter can be used to filter data by this column. Applies only if headerFilter.visible is true. By default, inherits the value of the allowFiltering property.
     */
    allowHeaderFiltering?: boolean;
    /**
     * Specifies whether a user can hide the column using the column chooser at runtime. Applies only if columnChooser.enabled is true.
     */
    allowHiding?: boolean;
    /**
     * Specifies whether users can reorder this column. Overrides the allowColumnReordering property value.
     */
    allowReordering?: boolean;
    /**
     * Specifies whether a user can resize the column at runtime. Applies only if allowColumnResizing is true.
     */
    allowResizing?: boolean;
    /**
     * Specifies whether this column can be searched. Applies only if searchPanel.visible is true. Inherits the value of the allowFiltering property by default.
     */
    allowSearch?: boolean;
    /**
     * Specifies whether a user can sort rows by this column at runtime. Applies only if sorting.mode differs from &apos;none&apos;.
     */
    allowSorting?: boolean;
    /**
     * Calculates custom cell values. Use this function to create an unbound data column.
     */
    calculateCellValue?: (this: ColumnBase, rowData: TRowData) => any;
    defaultCalculateCellValue?: this['calculateCellValue'];
    /**
     * Calculates custom display values for column cells. Requires specifying the dataField or calculateCellValue property. Used in lookup optimization.
     */
    calculateDisplayValue?:
      | string
      | ((this: ColumnBase, rowData: TRowData) => any);
    /**
     * Specifies the column&apos;s custom rules to filter data.
     */
    calculateFilterExpression?: (
      this: ColumnBase,
      filterValue: any,
      selectedFilterOperation: string | null,
      target: string
    ) => string | Array<any> | Function;
    defaultCalculateFilterExpression?: this['calculateFilterExpression'];
    /**
     * Calculates custom values used to sort this column.
     */
    calculateSortValue?:
      | string
      | ((this: ColumnBase, rowData: TRowData) => any);
    /**
     * Specifies a caption for the column.
     */
    caption?: string | undefined;
    /**
     * Specifies a CSS class to be applied to the column.
     */
    cssClass?: string | undefined;
    /**
     * Customizes the text displayed in column cells.
     */
    customizeText?: (
      this: ColumnBase,
      cellInfo: ColumnCustomizeTextArg
    ) => string;
    /**
     * Binds the column to a field of the dataSource.
     */
    dataField?: string | undefined;
    /**
     * Casts column values to a specific data type.
     */
    dataType?: DataType | undefined;
    /**
     * Configures the default UI component used for editing and filtering in the filter row.
     */
    editorOptions?: any;
    /**
     * Specifies whether HTML tags are displayed as plain text or applied to the values of the column.
     */
    encodeHtml?: boolean;
    /**
     * In a boolean column, replaces all false items with a specified text. Applies only if showEditorAlways property is false.
     */
    falseText?: string;
    /**
     * Specifies available filter operations. Applies if allowFiltering is true and the filterRow and/or filterPanel are visible.
     */
    filterOperations?: Array<FilterOperation | string>;
    /**
     * Specifies whether a user changes the current filter by including (selecting) or excluding (clearing the selection of) values. Applies only if headerFilter.visible and allowHeaderFiltering are true.
     */
    filterType?: FilterType;
    /**
     * Specifies the value to display in the filter row.
     */
    filterValue?: any | undefined;
    /**
     * Sets the values in the header filter.
     */
    filterValues?: Array<any>;
    /**
     * Fixes the column.
     */
    fixed?: boolean;
    /**
     * Specifies the column position. Applies only if columns[].fixed is true.
     */
    fixedPosition?: FixedPosition | undefined;
    /**
     * Configures the form item that the column produces in the editing state. Applies only if editing.mode is &apos;form&apos; or &apos;popup&apos;.
     */
    formItem?: DevExpress.ui.dxForm.SimpleItem;
    /**
     * Formats a value before it is displayed in a column cell.
     */
    format?: DevExpress.common.core.localization.Format;
    /**
     * Specifies data settings for the header filter.
     */
    headerFilter?: ColumnHeaderFilter | undefined;
    /**
     * Specifies the order in which columns are hidden when the UI component adapts to the screen or container size. Ignored if allowColumnResizing is `true` and columnResizingMode is &apos;widget&apos;.
     */
    hidingPriority?: number | undefined;
    /**
     * Specifies whether the column organizes other columns into bands.
     */
    isBand?: boolean | undefined;
    /**
     * Specifies properties of a lookup column.
     */
    lookup?: ColumnLookup | undefined;
    /**
     * Specifies the minimum width of the column.
     */
    minWidth?: number | undefined;
    /**
     * Specifies the column&apos;s unique identifier. If not set in code, this value is inherited from the dataField.
     */
    name?: string | undefined;
    /**
     * Specifies the band column that owns the current column. Accepts the index of the band column in the columns array.
     */
    ownerBand?: number | undefined;
    /**
     * Specifies whether to render the column after other columns and elements. Use if column cells have a complex template. Requires the width property specified.
     */
    renderAsync?: boolean;
    /**
     * Specifies a filter operation that applies when users use the filter row to filter the column.
     */
    selectedFilterOperation?: SelectedFilterOperation | undefined;
    /**
     * Specifies a function to be invoked after the user has edited a cell value, but before it is saved in the data source.
     */
    setCellValue?: (
      this: ColumnBase,
      newData: DevExpress.core.DeepPartial<TRowData>,
      value: any,
      currentRowData: TRowData
    ) => void | PromiseLike<void>;
    defaultSetCellValue?: this['setCellValue'];
    /**
     * Specifies whether the column displays its values in editors.
     */
    showEditorAlways?: boolean;
    /**
     * Specifies whether the column chooser can contain the column header.
     */
    showInColumnChooser?: boolean;
    /**
     * Specifies the index according to which columns participate in sorting.
     */
    sortIndex?: number | undefined;
    /**
     * Specifies the sort order of column values.
     */
    sortOrder?: SortOrder | undefined;
    /**
     * Specifies a custom comparison function for sorting. Applies only when sorting is performed on the client.
     */
    sortingMethod?:
      | ((this: ColumnBase, value1: any, value2: any) => number)
      | undefined;
    /**
     * In a boolean column, replaces all true items with a specified text. Applies only if showEditorAlways property is false.
     */
    trueText?: string;
    /**
     * Specifies validation rules to be checked when cell values are updated.
     */
    validationRules?: Array<ValidationRule>;
    /**
     * Specifies whether the column is visible, that is, occupies space in the table.
     */
    visible?: boolean;
    /**
     * Specifies the position of the column regarding other columns in the resulting UI component.
     */
    visibleIndex?: number | undefined;
    /**
     * Specifies the column&apos;s width in pixels or as a percentage. Ignored if it is less than minWidth.
     */
    width?: number | string | undefined;
  }
  /**
   * Allows you to customize buttons in the edit column or create a custom command column. Applies only if the column&apos;s type is &apos;buttons&apos;.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ColumnButtonBase {
    /**
     * Specifies a CSS class to be applied to the button.
     */
    cssClass?: string;
    /**
     * Specifies the text for the hint that appears when the button is hovered over or long-pressed.
     */
    hint?: string;
    /**
     * Specifies the button&apos;s icon.
     */
    icon?: string;
    /**
     * Specifies the button&apos;s text. Applies only if the button&apos;s icon is not specified.
     */
    text?: string;
  }
  /**
   * Configures the column chooser.
   */
  export type ColumnChooser = {
    /**
     * Specifies whether searching is enabled in the column chooser.
     * @deprecated Use `search.enabled` instead.
     */
    allowSearch?: boolean;
    /**
     * Specifies a container in which the column chooser should be rendered.
     */
    container?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies text displayed by the column chooser when it is empty.
     */
    emptyPanelText?: string;
    /**
     * Specifies whether a user can open the column chooser.
     */
    enabled?: boolean;
    /**
     * Specifies the height of the column chooser.
     */
    height?: number | string;
    /**
     * Specifies how a user manages columns using the column chooser.
     */
    mode?: ColumnChooserMode;
    /**
     * Configures the column chooser&apos;s position.
     */
    position?: DevExpress.common.core.animation.PositionConfig | undefined;
    /**
     * Configures the column chooser&apos;s search functionality.
     */
    search?: ColumnChooserSearchConfig;
    /**
     * Specifies a delay in milliseconds between when a user finishes typing in the column chooser&apos;s search panel, and when the search is executed.
     * @deprecated Use `search.timeout` instead.
     */
    searchTimeout?: number;
    /**
     * Configures column selection functionality within the column chooser.
     */
    selection?: ColumnChooserSelectionConfig;
    /**
     * Specifies the title of the column chooser.
     */
    title?: string;
    /**
     * Specifies the width of the column chooser.
     */
    width?: number | string;
    /**
     * Specifies the sort order of column headers.
     */
    sortOrder?: SortOrder | undefined;
  };
  export type ColumnChooserMode = 'dragAndDrop' | 'select';
  /**
   * Configures the column chooser&apos;s search functionality.
   */
  export type ColumnChooserSearchConfig = {
    /**
     * Configures the search box.
     */
    editorOptions?: any;
    /**
     * Specifies whether search is enabled in the column chooser.
     */
    enabled?: boolean;
    /**
     * Specifies a timeout, in milliseconds, during which a user may continue to modify the search value without starting the search operation.
     */
    timeout?: number;
  };
  /**
   * Configures column selection functionality within the column chooser.
   */
  export type ColumnChooserSelectionConfig = {
    /**
     * Specifies whether a &apos;Select All&apos; option is available to users.
     */
    allowSelectAll?: boolean;
    /**
     * Specifies whether selection is recursive.
     */
    recursive?: boolean;
    /**
     * Specifies whether an item becomes selected if a user clicks the item&apos;s label.
     */
    selectByClick?: boolean;
  };
  export type ColumnCustomizeTextArg = {
    value?: any;
    valueText?: string;
    target?: string;
    groupInterval?: string | number;
  };
  /**
   * Configures column fixing.
   */
  export type ColumnFixing = {
    /**
     * Enables column fixing.
     */
    enabled?: boolean;
    /**
     * Contains properties that specify texts for column fixing commands in the context menu of a column header.
     */
    texts?: ColumnFixingTexts;
    /**
     * Contains properties that specify icons for column fixing commands in the context menu of a column header.
     */
    icons?: ColumnFixingIcons;
  };
  /**
   * Configures column fixing icons.
   */
  export type ColumnFixingIcons = {
    /**
     * Specifies an icon for the context menu item that fixes a column.
     */
    fix?: string;
    /**
     * Specifies an icon for the context menu subitem that fixes a column to the left edge of the UI component.
     */
    leftPosition?: string;
    /**
     * Specifies an icon for the context menu subitem that fixes a column to the right edge of the UI component.
     */
    rightPosition?: string;
    /**
     * Specifies an icon for the context menu item that unfixes a column.
     */
    unfix?: string;
    /**
     * Specifies an icon for the context menu subitem that enables sticky column behavior.
     */
    stickyPosition?: string;
  };
  /**
   * Contains properties that specify texts for column fixing commands in the context menu of a column header.
   */
  export type ColumnFixingTexts = {
    /**
     * Specifies text for the context menu item that fixes a column.
     */
    fix?: string;
    /**
     * Specifies text for the context menu subitem that fixes a column to the left edge of the UI component.
     */
    leftPosition?: string;
    /**
     * Specifies text for the context menu subitem that fixes a column to the right edge of the UI component.
     */
    rightPosition?: string;
    /**
     * Specifies text for the context menu item that unfixes a column.
     */
    unfix?: string;
    /**
     * Specifies text for the context menu subitem that enables sticky column behavior.
     */
    stickyPosition?: string;
  };
  /**
   * Specifies data settings for the header filter.
   */
  export type ColumnHeaderFilter = {
    /**
     * Specifies whether searching is enabled in the header filter.
     * @deprecated Use `search.enabled` instead.
     */
    allowSearch?: boolean;
    /**
     * Specifies whether a &apos;Select All&apos; option is available to users.
     */
    allowSelectAll?: boolean;
    /**
     * Specifies the header filter&apos;s data source.
     */
    dataSource?:
      | DevExpress.ui.dxFilterBuilder.FilterLookupDataSource<any>
      | ((options: {
          component?: any;
          dataSource?: DevExpress.common.data.DataSourceOptions | null;
        }) => void)
      | undefined;
    /**
     * Specifies how the header filter combines values into groups.
     */
    groupInterval?: HeaderFilterGroupInterval | number | undefined;
    /**
     * Specifies the height of the popup menu containing filtering values.
     */
    height?: number | string | undefined;
    /**
     * Configures the header filter&apos;s search functionality.
     */
    search?: ColumnHeaderFilterSearchConfig;
    /**
     * Specifies a comparison operation used to search header filter values.
     * @deprecated Use `search.mode` instead.
     */
    searchMode?: SearchMode;
    /**
     * Specifies the width of the popup menu containing filtering values.
     */
    width?: number | string | undefined;
  };
  /**
   * Configures the header filter&apos;s search.
   */
  export type ColumnHeaderFilterSearchConfig = HeaderFilterSearchConfig & {
    /**
     * Specifies a data object&apos;s field name or an expression whose value is compared to the search string.
     */
    searchExpr?: string | Function | Array<string | Function> | undefined;
  };
  export type ColumnLookup = {
    /**
     * Specifies whether to display the Clear button in lookup column cells while they are being edited.
     */
    allowClearing?: boolean;
    /**
     * Specifies the data source for the lookup column.
     */
    dataSource?:
      | DevExpress.ui.dxFilterBuilder.FilterLookupDataSource<any>
      | ((options: {
          data?: any;
          key?: any;
        }) => DevExpress.ui.dxFilterBuilder.FilterLookupDataSource<any>)
      | null
      | undefined;
    /**
     * Specifies the data source field whose values must be displayed.
     */
    displayExpr?: string | ((data: any) => string) | undefined;
    /**
     * Specifies the data field whose values should be replaced with values from the displayExpr field.
     */
    valueExpr?: string | undefined;
    /**
     * 
     */
    calculateCellValue?: (rowData: any) => any;
  };
  export type ColumnResizeMode = 'nextColumn' | 'widget';
  /**
   * 
   */
  export type DataChange<TRowData = any, TKey = any> = {
    /**
     * The key of the row being created, updated, or removed.
     */
    key: TKey;
    /**
     * Data change type.
     */
    type: DataChangeType;
    /**
     * An object with updated row fields.
     */
    data: DevExpress.core.DeepPartial<TRowData>;
    /**
     * A key that identifies a record after which a new record should be inserted. Applies only if the type is &apos;insert&apos;.
     */
    insertAfterKey?: TKey;
    /**
     * A key that identifies the record before which a new record should be inserted. Applies only if the type is &apos;insert&apos;.
     */
    insertBeforeKey?: TKey;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DataChangeInfo<TRowData = any, TKey = any> = {
    /**
     * 
     */
    readonly changes: Array<DataChange<TRowData, TKey>>;
  };
  export type DataChangeType = 'insert' | 'update' | 'remove';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DataErrorOccurredInfo = {
    /**
     * 
     */
    readonly error?: Error;
  };
  export type DataRenderMode = 'standard' | 'virtual';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DragDropInfo = {
    readonly dropInsideItem: boolean;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DragReorderInfo = {
    readonly dropInsideItem: boolean;
    promise?: PromiseLike<void>;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DragStartEventInfo<TRowData = any> {
    itemData?: TRowData;
    readonly itemElement: DevExpress.core.DxElement;
    readonly fromIndex: number;
    readonly fromData?: any;
  }
  /**
   * Overriden.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface EditingBase<TRowData = any, TKey = any> {
    /**
     * Specifies if confirmation is required when a user deletes a row.
     */
    confirmDelete?: boolean;
    /**
     * An array of pending row changes.
     */
    changes?: Array<DataChange<TRowData, TKey>>;
    /**
     * The name of a column being edited. Applies only if editing.mode is &apos;cell&apos; or &apos;batch&apos;.
     */
    editColumnName?: string;
    /**
     * The key(s) of a row being edited.
     */
    editRowKey?: TKey;
    /**
     * Configures the form. Used only if editing.mode is &apos;form&apos; or &apos;popup&apos;.
     */
    form?: DevExpress.ui.dxForm.Properties;
    /**
     * Specifies how a user edits data.
     */
    mode?: GridsEditMode;
    /**
     * Configures the popup. Used only if editing.mode is &apos;popup&apos;.
     */
    popup?: DevExpress.ui.dxPopup.Properties;
    /**
     * Specifies operations that are performed after saving changes.
     */
    refreshMode?: GridsEditRefreshMode;
    /**
     * Specifies whether to select text in a cell when a user starts editing.
     */
    selectTextOnEditStart?: boolean;
    /**
     * Specifies whether a single or double click should switch a cell to the editing state. Applies if editing.mode is &apos;cell&apos; or &apos;batch&apos;.
     */
    startEditAction?: StartEditAction;
    /**
     * Contains properties that specify texts for editing-related UI elements.
     */
    texts?: EditingTextsBase;
    /**
     * Specifies whether the edit column uses icons instead of links.
     */
    useIcons?: boolean;
  }
  /**
   * Contains properties that specify texts for editing-related UI elements.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface EditingTextsBase {
    /**
     * Specifies text for a hint that appears when a user pauses on the global &apos;Add&apos; button. Applies only if editing.allowAdding is true.
     */
    addRow?: string;
    /**
     * Specifies text for a hint that appears when a user pauses on the &apos;Discard&apos; button. Applies only if editing.mode is &apos;batch&apos;.
     */
    cancelAllChanges?: string;
    /**
     * Specifies text for a button that cancels changes in a row. Applies only if editing.allowUpdating is true and editing.mode is &apos;row&apos;, &apos;popup&apos; or &apos;form&apos;.
     */
    cancelRowChanges?: string;
    /**
     * Specifies a message that prompts a user to confirm deletion.
     */
    confirmDeleteMessage?: string;
    /**
     * Specifies a title for the window that asks a user to confirm deletion.
     */
    confirmDeleteTitle?: string;
    /**
     * Specifies text for buttons that delete rows. Applies only if allowDeleting is true.
     */
    deleteRow?: string;
    /**
     * Specifies text for buttons that switch rows into the editing state. Applies only if allowUpdating is true.
     */
    editRow?: string;
    /**
     * Specifies text for a hint that appears when a user pauses on the global &apos;Save&apos; button. Applies only if editing.mode is &apos;batch&apos;.
     */
    saveAllChanges?: string;
    /**
     * Specifies text for a button that saves changes made in a row. Applies only if allowUpdating is true and editing.mode is &apos;row&apos;, &apos;popup&apos; or &apos;form&apos;.
     */
    saveRowChanges?: string;
    /**
     * Specifies text for buttons that recover deleted rows. Applies only if allowDeleting is true and editing.mode is &apos;batch&apos;.
     */
    undeleteRow?: string;
    /**
     * Specifies text for a hint appearing when a user pauses on the button that cancels changes in a cell. Applies only if editing.mode is &apos;cell&apos; and data validation is enabled.
     */
    validationCancelChanges?: string;
  }
  export type EnterKeyAction = 'startEdit' | 'moveFocus';
  export type EnterKeyDirection = 'none' | 'column' | 'row';
  export type FilterOperation =
    | '='
    | '<>'
    | '<'
    | '<='
    | '>'
    | '>='
    | 'contains'
    | 'endswith'
    | 'isblank'
    | 'isnotblank'
    | 'notcontains'
    | 'startswith'
    | 'between'
    | 'anyof'
    | 'noneof';
  /**
   * Configures the filter panel.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface FilterPanel<TComponent = any, TRowData = any, TKey = any> {
    /**
     * Customizes the filter expression&apos;s text representation.
     */
    customizeText?: (e: FilterPanelCustomizeTextArg<TComponent>) => string;
    /**
     * Specifies whether the filter expression is applied.
     */
    filterEnabled?: boolean;
    /**
     * Specifies texts for the filter panel&apos;s elements.
     */
    texts?: FilterPanelTexts;
    /**
     * Specifies whether the filter panel is visible.
     */
    visible?: boolean;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface FilterPanelCustomizeTextArg<TComponent> {
    readonly component: TComponent;
    readonly filterValue: any;
    readonly text: string;
  }
  /**
   * Specifies texts for the filter panel&apos;s elements.
   */
  export type FilterPanelTexts = {
    /**
     * The text of the &apos;Clear&apos; link.
     */
    clearFilter?: string;
    /**
     * The text of the &apos;Create Filter&apos; link.
     */
    createFilter?: string;
    /**
     * The hint of the checkbox that applies the filter.
     */
    filterEnabledHint?: string;
  };
  /**
   * Configures the filter row.
   */
  export type FilterRow = {
    /**
     * Specifies when to apply a filter.
     */
    applyFilter?: ApplyFilterMode;
    /**
     * Specifies text for a hint that appears when a user pauses on a button that applies the filter.
     */
    applyFilterText?: string;
    /**
     * Specifies a placeholder for the editor that specifies the end of a range when a user selects the &apos;between&apos; filter operation.
     */
    betweenEndText?: string;
    /**
     * Specifies a placeholder for the editor that specifies the start of a range when a user selects the &apos;between&apos; filter operation.
     */
    betweenStartText?: string;
    /**
     * Specifies descriptions for filter operations on the filter list.
     */
    operationDescriptions?: FilterRowOperationDescriptions;
    /**
     * Specifies text for the reset operation on the filter list.
     */
    resetOperationText?: string;
    /**
     * Specifies text for the item that clears the applied filter. Used only when a cell of the filter row contains a select box.
     */
    showAllText?: string;
    /**
     * Specifies whether icons that open the filter lists are visible.
     */
    showOperationChooser?: boolean;
    /**
     * Specifies whether the filter row is visible.
     */
    visible?: boolean;
  };
  /**
   * Specifies descriptions for filter operations on the filter list.
   */
  export type FilterRowOperationDescriptions = {
    /**
     * A description for the &apos;between&apos; operation.
     */
    between?: string;
    /**
     * A description for the &apos;contains&apos; operation.
     */
    contains?: string;
    /**
     * A description for the &apos;endswith&apos; operation.
     */
    endsWith?: string;
    /**
     * A description for the &apos;=&apos; operation.
     */
    equal?: string;
    /**
     * A description for the &apos;&gt;&apos; operation.
     */
    greaterThan?: string;
    /**
     * A description for the &apos;&gt;=&apos; operation.
     */
    greaterThanOrEqual?: string;
    /**
     * A description for the &apos;&lt;&apos; operation.
     */
    lessThan?: string;
    /**
     * A description for the &apos;&lt;=&apos; operation.
     */
    lessThanOrEqual?: string;
    /**
     * A description for the &apos;notcontains&apos; operation.
     */
    notContains?: string;
    /**
     * A description for the &apos;&lt;&gt;&apos; operation.
     */
    notEqual?: string;
    /**
     * A description for the &apos;startswith&apos; operation.
     */
    startsWith?: string;
  };
  export type FilterType = 'exclude' | 'include';
  export type FixedPosition = 'left' | 'right' | 'sticky';
  /**
   * The base class for UI components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface GridBase<TRowData = any, TKey = any> {
    /**
     * Aborts AI column requests.
     */
    abortAIColumnRequest(columnName: string): void;
    /**
     * Populates the AI column with values.
     */
    sendAIColumnRequest(columnName: string): void;
    /**
     * Refreshes the values of an AI column.
     */
    refreshAIColumn(columnName: string): void;
    /**
     * Resets all cell values of an AI column to emptyText.
     */
    clearAIColumn(columnName: string): void;
    /**
     * Gets AI-generated text from a specific cell within an AI column.
     */
    getAIColumnText(columnName: string, key: TKey): string;

    /**
     * Shows the load panel.
     */
    beginCustomLoading(messageText: string): void;
    /**
     * Gets a data object with a specific key.
     */
    byKey(key: TKey): DevExpress.core.utils.DxPromise<TRowData>;
    /**
     * Discards changes that a user made to data.
     */
    cancelEditData(): void;
    /**
     * Gets the value of a cell with a specific row index and a data field, column caption or name.
     */
    cellValue(rowIndex: number, dataField: string): any;
    /**
     * Sets a new value to a cell with a specific row index and a data field, column caption or name.
     */
    cellValue(rowIndex: number, dataField: string, value: any): void;
    /**
     * Gets the value of a cell with specific row and column indexes.
     */
    cellValue(rowIndex: number, visibleColumnIndex: number): any;
    /**
     * Sets a new value to a cell with specific row and column indexes.
     */
    cellValue(rowIndex: number, visibleColumnIndex: number, value: any): void;
    /**
     * Clears all filters applied to UI component rows.
     */
    clearFilter(): void;
    /**
     * Clears all row filters of a specific type.
     */
    clearFilter(filterName: string): void;
    /**
     * Clears selection of all rows on all pages.
     */
    clearSelection(): void;
    /**
     * Clears sorting settings of all columns at once.
     */
    clearSorting(): void;
    /**
     * Switches the cell being edited back to the normal state. Takes effect only if editing.mode is batch or cell and showEditorAlways is false.
     */
    closeEditCell(): void;
    /**
     * Collapses the currently expanded adaptive detail row (if there is one).
     */
    collapseAdaptiveDetailRow(): void;
    /**
     * Gets the data column count. Includes visible and hidden columns, excludes command columns.
     */
    columnCount(): number;
    /**
     * Gets all properties of a column with a specific identifier.
     */
    columnOption(id: number | string): any;
    /**
     * Gets the value of a single column property.
     */
    columnOption(id: number | string, optionName: string): any;
    /**
     * Updates the value of a single column property.
     */
    columnOption(
      id: number | string,
      optionName: string,
      optionValue: any
    ): void;
    /**
     * Updates the values of several column properties.
     */
    columnOption(id: number | string, options: any): void;
    /**
     * Removes a column.
     */
    deleteColumn(id: number | string): void;
    /**
     * Removes a row with a specific index.
     */
    deleteRow(rowIndex: number): void;
    /**
     * Clears the selection of all rows on all pages or the currently rendered page only.
     */
    deselectAll(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Cancels the selection of rows with specific keys.
     */
    deselectRows(keys: Array<any>): DevExpress.core.utils.DxPromise<any>;
    /**
     * Switches a cell with a specific row index and a data field to the editing state. Takes effect only if the editing mode is &apos;batch&apos; or &apos;cell&apos;.
     */
    editCell(rowIndex: number, dataField: string): void;
    /**
     * Switches a cell with specific row and column indexes to the editing state. Takes effect only if the editing mode is &apos;batch&apos; or &apos;cell&apos;.
     */
    editCell(rowIndex: number, visibleColumnIndex: number): void;
    /**
     * Switches a row with a specific index to the editing state. Takes effect only if the editing mode is &apos;row&apos;, &apos;popup&apos; or &apos;form&apos;.
     */
    editRow(rowIndex: number): void;
    /**
     * Hides the load panel.
     */
    endCustomLoading(): void;
    /**
     * Expands an adaptive detail row.
     */
    expandAdaptiveDetailRow(key: TKey): void;
    /**
     * Gets a filter expression applied to the UI component&apos;s data source using the filter(filterExpr) method and the DataSource&apos;s filter property.
     */
    filter(): any;
    /**
     * Applies a filter to the dataSource.
     */
    filter(filterExpr: any): void;
    focus(): void;
    /**
     * Sets focus on a specific cell.
     */
    focus(element: DevExpress.core.UserDefinedElement): void;
    /**
     * Gets a cell with a specific row index and a data field, column caption or name.
     */
    getCellElement(
      rowIndex: number,
      dataField: string
    ): DevExpress.core.DxElement | undefined;
    /**
     * Gets a cell with specific row and column indexes.
     */
    getCellElement(
      rowIndex: number,
      visibleColumnIndex: number
    ): DevExpress.core.DxElement | undefined;
    /**
     * Gets the total filter that combines all the filters applied.
     */
    getCombinedFilter(): any;
    /**
     * Gets the total filter that combines all the filters applied.
     */
    getCombinedFilter(returnDataField: boolean): any;
    getDataSource(): DevExpress.common.data.DataSource<TRowData, TKey>;
    /**
     * Gets the key of a row with a specific index.
     */
    getKeyByRowIndex(rowIndex: number): TKey | undefined;
    /**
     * Gets the container of a row with a specific index.
     */
    getRowElement(
      rowIndex: number
    ): DevExpress.core.UserDefinedElementsArray | undefined;
    /**
     * Gets the index of a row with a specific key.
     */
    getRowIndexByKey(key: TKey): number;
    /**
     * Gets the instance of the UI component&apos;s scrollable part.
     */
    getScrollable(): Scrollable;
    /**
     * Gets the index of a visible column.
     */
    getVisibleColumnIndex(id: number | string): number;
    /**
     * Checks whether the UI component has unsaved changes.
     */
    hasEditData(): boolean;
    /**
     * Hides the column chooser.
     */
    hideColumnChooser(): void;
    /**
     * Checks whether an adaptive detail row is expanded or collapsed.
     */
    isAdaptiveDetailRowExpanded(key: TKey): boolean;
    /**
     * Checks whether a row with a specific key is focused.
     */
    isRowFocused(key: TKey): boolean;
    /**
     * Checks whether a row with a specific key is selected.
     */
    isRowSelected(key: TKey): boolean;
    /**
     * Gets a data object&apos;s key.
     */
    keyOf(obj: TRowData): TKey;
    /**
     * Navigates to a row with the specified key.
     */
    navigateToRow(key: TKey): DevExpress.core.utils.DxPromise<void>;
    /**
     * Gets the total page count.
     */
    pageCount(): number;
    /**
     * Gets the current page index.
     */
    pageIndex(): number;
    /**
     * Switches the UI component to a specific page using a zero-based index.
     */
    pageIndex(newIndex: number): DevExpress.core.utils.DxPromise<void>;
    /**
     * Gets the current page size.
     */
    pageSize(): number;
    /**
     * Sets the page size.
     */
    pageSize(value: number): void;
    /**
     * Reloads data and repaints data rows.
     */
    refresh(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Reloads data and repaints all or only updated data rows.
     */
    refresh(changesOnly: boolean): DevExpress.core.utils.DxPromise<void>;
    /**
     * Repaints specific rows.
     */
    repaintRows(rowIndexes: Array<number>): void;
    /**
     * Saves changes that a user made to data.
     */
    saveEditData(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Seeks a search string in the columns whose allowSearch property is true.
     */
    searchByText(text: string): void;
    /**
     * Selects all rows.
     */
    selectAll(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Selects rows with specific keys.
     */
    selectRows(
      keys: Array<TKey>,
      preserve: boolean
    ): DevExpress.core.utils.DxPromise<Array<TRowData>>;
    /**
     * Selects rows with specific indexes.
     */
    selectRowsByIndexes(
      indexes: Array<number>
    ): DevExpress.core.utils.DxPromise<Array<TRowData>>;
    /**
     * Shows the column chooser.
     */
    showColumnChooser(): void;
    /**
     * Gets the current UI component state.
     */
    state(): any;
    /**
     * Sets the UI component state.
     */
    state(state: any): void;
    /**
     * Recovers a row deleted in batch editing mode.
     */
    undeleteRow(rowIndex: number): void;
    /**
     * Updates the UI component&apos;s content after resizing.
     */
    updateDimensions(): void;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type GridBaseOptions<
    TComponent extends GridBase<TRowData, TKey>,
    TRowData = any,
    TKey = any
  > = Omit<
    GridBaseOptionsBlank<TComponent, TRowData, TKey>,
    'focusStateEnabled'
  > & {
    /**
     * Binds the widget to an AI service.
     */
    aiIntegration?: DevExpress.aiIntegration.AIIntegration | undefined;
    /**
     * Specifies whether a user can reorder columns.
     */
    allowColumnReordering?: boolean;
    /**
     * Specifies whether a user can resize columns.
     */
    allowColumnResizing?: boolean;
    /**
     * Automatically scrolls the component to the focused row when the focusedRowKey is changed.
     */
    autoNavigateToFocusedRow?: boolean;
    /**
     * Specifies whether data should be cached.
     */
    cacheEnabled?: boolean;
    /**
     * Enables a hint that appears when a user hovers the mouse pointer over a cell with truncated content.
     */
    cellHintEnabled?: boolean;
    /**
     * Specifies if the component adjusts column widths to fit content.
     */
    columnAutoWidth?: boolean;
    /**
     * Configures the column chooser.
     */
    columnChooser?: ColumnChooser;
    /**
     * Configures column fixing.
     */
    columnFixing?: ColumnFixing;
    /**
     * Specifies whether the UI component hides columns to adapt to the screen or container size. Ignored if allowColumnResizing is `true` and columnResizingMode is &apos;widget&apos;.
     */
    columnHidingEnabled?: boolean;
    /**
     * Specifies the minimum width of columns.
     */
    columnMinWidth?: number | undefined;
    /**
     * Specifies how the UI component resizes columns. Applies only if allowColumnResizing is true.
     */
    columnResizingMode?: ColumnResizeMode;
    /**
     * Specifies the width for all data columns. Has a lower priority than the column.width property.
     */
    columnWidth?: number | Mode | undefined;
    /**
     * Overridden.
     */
    columns?: Array<ColumnBase<TRowData> | string> | undefined;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TRowData, TKey> | null;
    /**
     * Specifies the format in which date-time values should be sent to the server.
     */
    dateSerializationFormat?: string;
    /**
     * Overriden.
     */
    editing?: EditingBase<TRowData, TKey>;
    /**
     * Indicates whether to show the error row.
     */
    errorRowEnabled?: boolean;
    /**
     * Configures the integrated filter builder.
     */
    filterBuilder?: DevExpress.ui.dxFilterBuilder.Properties;
    /**
     * Configures the popup in which the integrated filter builder is shown.
     */
    filterBuilderPopup?: DevExpress.ui.dxPopup.Properties;
    /**
     * Configures the filter panel.
     */
    filterPanel?: FilterPanel<TComponent, TRowData, TKey>;
    /**
     * Configures the filter row.
     */
    filterRow?: FilterRow;
    /**
     * Specifies whether to synchronize the filter row, header filter, and filter builder. The synchronized filter expression is stored in the filterValue property.
     */
    filterSyncEnabled?: boolean | Mode;
    /**
     * Specifies a filter expression.
     */
    filterValue?: string | Array<any> | Function;
    /**
     * The index of the column that contains the focused data cell. This index is taken from the columns array.
     */
    focusedColumnIndex?: number;
    /**
     * Specifies whether the focused row feature is enabled.
     */
    focusedRowEnabled?: boolean;
    /**
     * Specifies or indicates the focused data row&apos;s index.
     */
    focusedRowIndex?: number;
    /**
     * Specifies initially or currently focused grid row&apos;s key.
     */
    focusedRowKey?: TKey | undefined;
    /**
     * Configures the header filter feature.
     */
    headerFilter?: HeaderFilter;
    /**
     * Specifies whether to highlight rows and cells with edited data. repaintChangesOnly should be true.
     */
    highlightChanges?: boolean;
    /**
     * Configures keyboard navigation.
     */
    keyboardNavigation?: KeyboardNavigation;
    /**
     * Configures the load panel.
     */
    loadPanel?: LoadPanel;
    /**
     * Specifies a text string shown when the widget does not display any data.
     */
    noDataText?: string;
    /**
     * A function that is executed before an adaptive detail row is rendered.
     */
    onAdaptiveDetailRowPreparing?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        AdaptiveDetailRowPreparingInfo
    ) => void;
    /**
     * A function that is executed when an error occurs in the data source.
     */
    onDataErrorOccurred?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DataErrorOccurredInfo
    ) => void;
    /**
     * A function that is executed after row changes are discarded.
     */
    onEditCanceled?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DataChangeInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed when the edit operation is canceled, but row changes are not yet discarded.
     */
    onEditCanceling?: (
      e: DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<TComponent> &
        DataChangeInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before a new row is added to the UI component.
     */
    onInitNewRow?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        NewRowInfo<TRowData>
    ) => void;
    /**
     * A function that is executed when the UI component is in focus and a key has been pressed down.
     */
    onKeyDown?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent
      > &
        KeyDownInfo
    ) => void;
    /**
     * A function that is executed after a row is collapsed.
     */
    onRowCollapsed?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> & RowKeyInfo<TKey>
    ) => void;
    /**
     * A function that is executed before a row is collapsed.
     */
    onRowCollapsing?: (
      e: DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<TComponent> &
        RowKeyInfo<TKey>
    ) => void;
    /**
     * A function that is executed after a row is expanded.
     */
    onRowExpanded?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> & RowKeyInfo<TKey>
    ) => void;
    /**
     * A function that is executed before a row is expanded.
     */
    onRowExpanding?: (
      e: DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<TComponent> &
        RowKeyInfo<TKey>
    ) => void;
    /**
     * A function that is executed after a new row has been inserted into the data source.
     */
    onRowInserted?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowInsertedInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before a new row is inserted into the data source.
     */
    onRowInserting?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowInsertingInfo<TRowData>
    ) => void;
    /**
     * A function that is executed after a row has been removed from the data source.
     */
    onRowRemoved?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowRemovedInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before a row is removed from the data source.
     */
    onRowRemoving?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowRemovingInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after a row has been updated in the data source.
     */
    onRowUpdated?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowUpdatedInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before a row is updated in the data source.
     */
    onRowUpdating?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowUpdatingInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after cells in a row are validated against validation rules.
     */
    onRowValidating?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        RowValidatingInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after row changes are saved.
     */
    onSaved?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DataChangeInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before pending row changes are saved.
     */
    onSaving?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        SavingInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after selecting a row or clearing its selection.
     */
    onSelectionChanged?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        SelectionChangedInfo<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before the toolbar is created.
     */
    onToolbarPreparing?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        ToolbarPreparingInfo
    ) => void;
    /**
     * Configures the pager.
     */
    pager?: Pager;
    /**
     * Configures paging.
     */
    paging?: PagingBase;
    /**
     * Specifies whether to render the filter row, command columns, and columns with showEditorAlways set to true after other elements.
     */
    renderAsync?: boolean;
    /**
     * Specifies whether to repaint only those cells whose data changed.
     */
    repaintChangesOnly?: boolean;
    /**
     * Specifies whether rows should be shaded differently.
     */
    rowAlternationEnabled?: boolean;
    /**
     * Configures row reordering using drag and drop gestures.
     */
    rowDragging?: RowDragging<TComponent, TRowData, TKey>;
    /**
     * 
     */
    scrolling?: ScrollingBase;
    /**
     * Configures the search panel.
     */
    searchPanel?: SearchPanel;
    /**
     * Allows you to select rows or determine which rows are selected.
     */
    selectedRowKeys?: Array<TKey>;
    /**
     * 
     */
    selection?: SelectionBase;
    /**
     * Specifies whether the outer borders of the UI component are visible.
     */
    showBorders?: boolean;
    /**
     * Specifies whether column headers are visible.
     */
    showColumnHeaders?: boolean;
    /**
     * Specifies whether vertical lines that separate one column from another are visible.
     */
    showColumnLines?: boolean;
    /**
     * Specifies whether horizontal lines that separate one row from another are visible.
     */
    showRowLines?: boolean;
    /**
     * Configures runtime sorting.
     */
    sorting?: Sorting;
    /**
     * Configures state storing.
     */
    stateStoring?: StateStoring;
    /**
     * Specifies whether to enable two-way data binding.
     */
    twoWayBindingEnabled?: boolean;
    /**
     * Specifies whether text that does not fit into a column should be wrapped.
     */
    wordWrapEnabled?: boolean;
    /**
     * Specifies whether to show only relevant values in the header filter and filter row.
     */
    syncLookupFilterValues?: boolean;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface GridBaseOptionsBlank<
    TComponent extends GridBase<TRowData, TKey>,
    TRowData = any,
    TKey = any
  > extends DevExpress.ui.WidgetOptions<TComponent> {
    /**
     * 
     */
    focusStateEnabled?: any;
  }
  export type GridsContextMenuTarget =
    | 'toolbar'
    | 'header'
    | 'content'
    | 'footer';
  export type GridsEditMode = 'batch' | 'cell' | 'row' | 'form' | 'popup';
  export type GridsEditRefreshMode = 'full' | 'reshape' | 'repaint';
  export type GroupExpandMode = 'buttonClick' | 'rowClick';
  /**
   * Configures the header filter feature.
   */
  export type HeaderFilter = {
    /**
     * Specifies whether searching is enabled in the header filter.
     * @deprecated Use DataGrid search.enabled or TreeList search.enabled instead.
     */
    allowSearch?: boolean;
    /**
     * Specifies whether a &apos;Select All&apos; option is available to users.
     */
    allowSelectAll?: boolean;
    /**
     * Specifies the height of the popup menu that contains values for filtering.
     */
    height?: number | string;
    /**
     * Configures the header filter&apos;s search box.
     */
    search?: HeaderFilterSearchConfig;
    /**
     * Specifies a delay in milliseconds between when a user finishes typing in the header filter&apos;s search panel, and when the search is executed.
     * @deprecated Use DataGrid search.timeout or TreeList search.timeout instead.
     */
    searchTimeout?: number;
    /**
     * Contains properties that specify text for various elements of the popup menu.
     */
    texts?: HeaderFilterTexts;
    /**
     * Specifies whether header filter icons are visible.
     */
    visible?: boolean;
    /**
     * Specifies the width of the popup menu that contains values for filtering.
     */
    width?: number | string;
  };
  export type HeaderFilterGroupInterval =
    | 'day'
    | 'hour'
    | 'minute'
    | 'month'
    | 'quarter'
    | 'second'
    | 'year';
  /**
   * Configures the header filter&apos;s search functionality.
   */
  export type HeaderFilterSearchConfig = {
    /**
     * Configures the search box.
     */
    editorOptions?: any;
    /**
     * Specifies whether search UI is enabled in the header filter.
     */
    enabled?: boolean;
    /**
     * Specifies a comparison operation used to search header filter values.
     */
    mode?: SearchMode;
    /**
     * Specifies a timeout, in milliseconds, during which a user may continue to modify the search value without starting the search operation.
     */
    timeout?: number;
  };
  /**
   * Contains properties that specify text for various elements of the popup menu.
   */
  export type HeaderFilterTexts = {
    /**
     * Specifies text for the button that closes the popup menu without applying a filter.
     */
    cancel?: string;
    /**
     * Specifies a name for the item that represents empty values in the popup menu.
     */
    emptyValue?: string;
    /**
     * Specifies text for the button that applies the specified filter.
     */
    ok?: string;
  };
  /**
   * Configures keyboard navigation.
   */
  export type KeyboardNavigation = {
    /**
     * Specifies whether users can enter a new cell value on a key press. Applies if editing.mode is &apos;cell&apos; or &apos;batch&apos;.
     */
    editOnKeyPress?: boolean;
    /**
     * Enables keyboard navigation.
     */
    enabled?: boolean;
    /**
     * Specifies whether the Enter key switches the cell or row to the edit state or moves focus in the enterKeyDirection. Applies for all edit modes, except &apos;popup&apos;.
     */
    enterKeyAction?: EnterKeyAction;
    /**
     * Specifies the direction in which to move focus when a user presses Enter. Applies if editing.mode is &apos;cell&apos; or &apos;batch&apos;.
     */
    enterKeyDirection?: EnterKeyDirection;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type KeyDownInfo = {
    /**
     * 
     */
    handled: boolean;
  };
  /**
   * Configures the load panel.
   */
  export type LoadPanel = {
    /**
     * Enables displaying the load panel automatically.
     */
    enabled?: boolean | Mode;
    /**
     * Specifies the height of the load panel in pixels.
     */
    height?: number | string;
    /**
     * Specifies the path to a custom load indicator image.
     * @deprecated Use the loadPanel.indicatorOptions option instead.
     */
    indicatorSrc?: string;
    /**
     * Configures the load indicator.
     */
    indicatorOptions?: DevExpress.ui.dxLoadPanel.LoadPanelIndicatorProperties;
    /**
     * Specifies whether to shade the UI component when the load panel is shown.
     */
    shading?: boolean;
    /**
     * Specifies the shading color. Applies only if shading is true.
     */
    shadingColor?: string;
    /**
     * Specifies whether to show the loading indicator.
     */
    showIndicator?: boolean;
    /**
     * Specifies whether to show the pane of the load panel.
     */
    showPane?: boolean;
    /**
     * Specifies text displayed on the load panel.
     */
    text?: string;
    /**
     * Specifies the width of the load panel in pixels.
     */
    width?: number | string;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface NewRowInfo<TRowData = any> {
    /**
     * 
     */
    data: TRowData;
    /**
     * 
     */
    promise?: PromiseLike<void>;
  }
  export type NewRowPosition =
    | 'first'
    | 'last'
    | 'pageBottom'
    | 'pageTop'
    | 'viewportBottom'
    | 'viewportTop';
  /**
   * Configures the pager.
   */
  export type Pager = PagerBase & {
    /**
     * Specifies the available page sizes in the page size selector.
     */
    allowedPageSizes?: Array<number | PagerPageSize> | Mode;

    /**
     * Specifies whether the pager is visible.
     */
    visible?: boolean | Mode;
  };
  export type PagerPageSize = 'all' | 'auto';
  /**
   * Configures paging.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface PagingBase {
    /**
     * Enables paging.
     */
    enabled?: boolean;
    /**
     * Specifies the page to be displayed using a zero-based index.
     */
    pageIndex?: number;
    /**
     * Specifies the page size.
     */
    pageSize?: number;
  }
  /**
   * Configures row reordering using drag and drop gestures.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type RowDragging<
    TComponent extends GridBase<TRowData, TKey>,
    TRowData = any,
    TKey = any
  > = {
    /**
     * Allows users to drop a row inside another row.
     */
    allowDropInsideItem?: boolean;
    /**
     * Allows row reordering using drag and drop gestures.
     */
    allowReordering?: boolean;
    /**
     * Enables automatic scrolling while dragging a row beyond the viewport.
     */
    autoScroll?: boolean;
    /**
     * Specifies a DOM element that limits the dragging area.
     */
    boundary?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies a custom container in which the draggable row should be rendered.
     */
    container?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies the cursor offset from the dragged row.
     */
    cursorOffset?:
      | string
      | {
          /**
           * Specifies the horizontal cursor offset from the dragged row in pixels.
           */
          x?: number;
          /**
           * Specifies the vertical cursor offset from the dragged row in pixels.
           */
          y?: number;
        };
    /**
     * A container for custom data.
     */
    data?: any | undefined;
    /**
     * Specifies the directions in which a row can be dragged.
     */
    dragDirection?: DragDirection;
    /**
     * Specifies custom markup to be shown instead of the item being dragged.
     */
    dragTemplate?:
      | template
      | ((
          dragInfo: RowDraggingTemplateData<TRowData>,
          containerElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement)
      | undefined;
    /**
     * Specifies how to highlight the row&apos;s drop position.
     */
    dropFeedbackMode?: DragHighlight;
    /**
     * Specifies a CSS selector for draggable rows.
     * @deprecated 
     */
    filter?: string;
    /**
     * Allows you to group several UI components so that users can drag and drop rows between them.
     */
    group?: string | undefined;
    /**
     * Specifies a CSS selector (ID or class) for the element(s) that should act as the drag handle(s).
     */
    handle?: string;
    /**
     * A function that is called when a new row is added.
     */
    onAdd?: (
      e: ReducedNativeEventInfo<TComponent> &
        RowDraggingEventInfo<TRowData> &
        DragDropInfo
    ) => void;
    /**
     * A function that is called when the dragged row&apos;s position is changed.
     */
    onDragChange?: (
      e: DevExpress.common.core.events.Cancelable &
        ReducedNativeEventInfo<TComponent> &
        RowDraggingEventInfo<TRowData> &
        DragDropInfo
    ) => void;
    /**
     * A function that is called when the drag gesture is finished.
     */
    onDragEnd?: (
      e: DevExpress.common.core.events.Cancelable &
        ReducedNativeEventInfo<TComponent> &
        RowDraggingEventInfo<TRowData> &
        DragDropInfo
    ) => void;
    /**
     * A function that is called every time a draggable row is moved.
     */
    onDragMove?: (
      e: DevExpress.common.core.events.Cancelable &
        ReducedNativeEventInfo<TComponent> &
        RowDraggingEventInfo<TRowData> &
        DragDropInfo
    ) => void;
    /**
     * A function that is called when the drag gesture is initialized.
     */
    onDragStart?: (
      e: DevExpress.common.core.events.Cancelable &
        ReducedNativeEventInfo<TComponent> &
        DragStartEventInfo<TRowData>
    ) => void;
    /**
     * A function that is called when a draggable row is removed.
     */
    onRemove?: (
      e: ReducedNativeEventInfo<TComponent> & RowDraggingEventInfo<TRowData>
    ) => void;
    /**
     * A function that is called when the draggable rows are reordered.
     */
    onReorder?: (
      e: ReducedNativeEventInfo<TComponent> &
        RowDraggingEventInfo<TRowData> &
        DragReorderInfo
    ) => void;
    /**
     * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
     */
    scrollSensitivity?: number;
    /**
     * Specifies the scrolling speed when dragging a row beyond the viewport. Applies only if autoScroll is true.
     */
    scrollSpeed?: number;
    /**
     * Shows or hides row dragging icons.
     */
    showDragIcons?: boolean;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowDraggingEventInfo<TRowData = any> {
    readonly itemData?: TRowData;
    readonly itemElement: DevExpress.core.DxElement;
    readonly fromIndex: number;
    readonly toIndex: number;
    readonly fromComponent: Sortable | Draggable;
    readonly toComponent: Sortable | Draggable;
    readonly fromData?: any;
    readonly toData?: any;
  }
  export type RowDraggingTemplateData<TRowData = any> = {
    readonly itemData: TRowData;
    readonly itemElement: DevExpress.core.DxElement;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type RowInsertedInfo<TRowData = any, TKey = any> = {
    /**
     * 
     */
    readonly data: TRowData;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    readonly error: Error;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type RowInsertingInfo<TRowData = any> = {
    /**
     * 
     */
    data: TRowData;
    /**
     * 
     */
    cancel: boolean | PromiseLike<boolean> | PromiseLike<void>;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type RowKeyInfo<TKey = any> = {
    /**
     * 
     */
    readonly key: TKey;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowRemovedInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly data: TRowData;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    readonly error: Error;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowRemovingInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly data: TRowData;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    cancel: boolean | PromiseLike<boolean> | PromiseLike<void>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowUpdatedInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly data: TRowData;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    readonly error: Error;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowUpdatingInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly oldData: TRowData;
    /**
     * 
     */
    newData: DevExpress.core.DeepPartial<TRowData>;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    cancel: boolean | PromiseLike<boolean> | PromiseLike<void>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RowValidatingInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly brokenRules: Array<ValidationRule>;
    /**
     * 
     */
    isValid: boolean;
    /**
     * 
     */
    readonly key: TKey;
    /**
     * 
     */
    readonly newData: DevExpress.core.DeepPartial<TRowData>;
    /**
     * @docid
     * @type object
     */
    /**
     * 
     */
    readonly oldData: TRowData;
    /**
     * 
     */
    errorText: string;
    /**
     * 
     */
    promise?: PromiseLike<void>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface SavingInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    changes: Array<DataChange<TRowData, TKey>>;
    /**
     * 
     */
    promise?: PromiseLike<void>;
    /**
     * 
     */
    cancel: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ScrollingBase {
    /**
     * Specifies the rendering mode for columns. Applies when columns are left outside the viewport. Requires the columnWidth, columnAutoWidth, or width (for all columns) property specified.
     */
    columnRenderingMode?: DataRenderMode;
    /**
     * Specifies whether the UI component should load adjacent pages. Applies only if scrolling.mode is &apos;virtual&apos; or &apos;infinite&apos;.
     */
    preloadEnabled?: boolean;
    /**
     * Specifies the rendering mode for loaded rows.
     */
    rowRenderingMode?: DataRenderMode;
    /**
     * Specifies whether a user can scroll the content with a swipe gesture. Applies only if useNative is false.
     */
    scrollByContent?: boolean;
    /**
     * Specifies whether a user can scroll the content with the scrollbar. Applies only if useNative is false.
     */
    scrollByThumb?: boolean;
    /**
     * Specifies when to show scrollbars. Applies only if useNative is false.
     */
    showScrollbar?: ScrollbarMode;
    /**
     * Specifies whether the widget should use native or simulated scrolling.
     */
    useNative?: boolean | Mode;
    /**
     * Specifies whether to render rows after a user stops scrolling or at the same time as the user scrolls the widget.
     */
    renderAsync?: boolean | undefined;
  }
  /**
   * Configures the search panel.
   */
  export type SearchPanel = {
    /**
     * Notifies the UI component whether search is case-sensitive to ensure that search results are highlighted correctly. Applies only if highlightSearchText is true.
     */
    highlightCaseSensitive?: boolean;
    /**
     * Specifies whether found substrings should be highlighted.
     */
    highlightSearchText?: boolean;
    /**
     * Specifies a placeholder for the search panel.
     */
    placeholder?: string;
    /**
     * Specifies whether the UI component should search against all columns or only visible ones.
     */
    searchVisibleColumnsOnly?: boolean;
    /**
     * Sets a search string for the search panel.
     */
    text?: string;
    /**
     * Specifies whether the search panel is visible or not.
     */
    visible?: boolean;
    /**
     * Specifies the width of the search panel in pixels.
     */
    width?: string | number;
  };
  export type SelectedFilterOperation =
    | '<'
    | '<='
    | '<>'
    | '='
    | '>'
    | '>='
    | 'between'
    | 'contains'
    | 'endswith'
    | 'notcontains'
    | 'startswith';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface SelectionBase {
    /**
     * Allows users to simultaneously select all or current page rows (depending on the selectAllMode).
     */
    allowSelectAll?: boolean;
    /**
     * Specifies the selection mode.
     */
    mode?: SingleMultipleOrNone;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface SelectionChangedInfo<TRowData = any, TKey = any> {
    /**
     * 
     */
    readonly currentSelectedRowKeys: Array<TKey>;
    /**
     * 
     */
    readonly currentDeselectedRowKeys: Array<TKey>;
    /**
     * 
     */
    readonly selectedRowKeys: Array<TKey>;
    /**
     * 
     */
    readonly selectedRowsData: Array<TRowData>;
  }
  export type SelectionColumnDisplayMode =
    | 'always'
    | 'none'
    | 'onClick'
    | 'onLongTap';
  /**
   * Configures runtime sorting.
   */
  export type Sorting = {
    /**
     * Specifies text for the context menu item that sets an ascending sort order in a column.
     */
    ascendingText?: string;
    /**
     * Specifies text for the context menu item that clears sorting settings for a column.
     */
    clearText?: string;
    /**
     * Specifies text for the context menu item that sets a descending sort order in a column.
     */
    descendingText?: string;
    /**
     * Specifies the sorting mode.
     */
    mode?: SingleMultipleOrNone;
    /**
     * Specifies whether to display sort indexes in column headers. Applies only when sorting.mode is &apos;multiple&apos; and data is sorted by two or more columns.
     */
    showSortIndexes?: boolean;
  };
  export type StartEditAction = 'click' | 'dblClick';
  export type StateStoreType = 'custom' | 'localStorage' | 'sessionStorage';
  /**
   * Configures state storing.
   */
  export type StateStoring = {
    /**
     * Specifies a function that is executed on state loading. Applies only if the type is &apos;custom&apos;.
     */
    customLoad?: () => PromiseLike<any>;
    /**
     * Specifies a function that is executed on state change. Applies only if the type is &apos;custom&apos;.
     */
    customSave?: (gridState: any) => any;
    /**
     * Enables state storing.
     */
    enabled?: boolean;
    /**
     * Specifies the delay in milliseconds between when a user makes a change and when this change is saved.
     */
    savingTimeout?: number;
    /**
     * Specifies the key for storing the UI component state.
     */
    storageKey?: string;
    /**
     * Specifies the type of storage where the state is saved.
     */
    type?: StateStoreType;
  };
  export type SummaryType = 'avg' | 'count' | 'custom' | 'max' | 'min' | 'sum';
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ToolbarPreparingInfo {
    /**
     * 
     */
    toolbarOptions: DevExpress.ui.dxToolbar.Properties;
  }
}
declare module DevExpress.core {
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type ComponentFactory<TComponent> = {
    new (
      element: UserDefinedElement,
      options?: Record<string, unknown>
    ): TComponent;
    getInstance(element: UserDefinedElement): TComponent;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface Condition {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface Condition extends JQueryEventObject {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface Coordinates {
    left: number;
    top: number;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DeepPartial<T> =
    | T
    | (T extends Scalar
        ? T
        : {
            [P in keyof T]?: DeepPartial<T[P]>;
          });
  /**
   * An object that serves as a namespace for the methods and events specifying information on the current device.
   */
  export class DevicesObject {
    constructor(options?: { window?: Window });
    /**
     * Gets information on the current device.
     */
    current(): DevExpress.common.core.environment.Device;
    /**
     * Overrides actual device information to force the application to operate as if it was running on a specified device.
     */
    current(
      deviceName: string | DevExpress.common.core.environment.Device
    ): void;
    /**
     * Detaches all event handlers from a single event.
     */
    off(eventName: DevExpress.common.EventName): this;
    /**
     * Detaches a particular event handler from a single event.
     */
    off(eventName: DevExpress.common.EventName, eventHandler: Function): this;
    /**
     * Subscribes to an event.
     */
    on(eventName: DevExpress.common.EventName, eventHandler: Function): this;
    /**
     * Subscribes to events.
     */
    on(events: { [key in DevExpress.common.EventName]?: Function }): this;
    /**
     * Returns the current device orientation.
     */
    orientation(): 'portrait' | 'landscape' | undefined;
    /**
     * Returns real information about the current device regardless of the value passed to the DevExpress.devices.current(deviceName) method.
     */
    real(): DevExpress.common.core.environment.Device;
    isSimulator(): boolean;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxElement = DxElement<HTMLElement>;
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DxElement<T extends Element = HTMLElement> = {} extends Condition
    ? T
    : ElementWrapper<T>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxElementWrapper {
    add(selector: string): this;

    addClass(className: string): this;

    after(element: Element | dxElementWrapper): this;

    append(element: Element | dxElementWrapper): this;

    appendTo(element: Element | dxElementWrapper): this;

    attr(attributeName: string, value: string | number | boolean | null): this;

    attr(attributeName: string): string | undefined;

    before(element: Element | dxElementWrapper): this;

    children(selector?: string): this;

    clone(): this;

    closest(selector: string | dxElementWrapper | Node): this;

    contents(): this;

    css(propertyName: string, value: string | number): this;
    css(properties: Record<string, any>): this;
    css(propertyName: string): string | undefined;

    data(key: string, value?: any): this;

    detach(): this;

    each(
      func: (this: Element, index: number, element: Element) => boolean
    ): this;

    empty(): this;

    eq(index: number): this;

    filter(selector: string): this;

    find(selector_element: string | Element | dxElementWrapper): this;

    first(): this;

    get(index: number): Element;

    hasClass(className: string): boolean;

    hide(): this;

    html(value?: string): this;

    index(element?: Element | dxElementWrapper): number;

    insertAfter(element: Element | dxElementWrapper): this;

    insertBefore(element: Element | dxElementWrapper): this;

    is(selector: string | dxElementWrapper): boolean;

    last(): this;

    next(selector?: string): this;

    not(selector: string): this;

    offset(): Coordinates | undefined;

    offsetParent(): this;

    parent(selector?: string): this;

    parents(selector?: string): this;

    position(): Coordinates | undefined;

    prepend(element: Element | dxElementWrapper): this;

    prependTo(element: Element | dxElementWrapper): this;

    prev(): this;

    prop(propertyName: string, value: string | number | boolean): this;

    remove(element?: Element | dxElementWrapper): this;

    removeAttr(attributeName: string): this;

    removeClass(className: string): this;

    removeData(key: string): this;

    replaceWith(element: Element | dxElementWrapper): this;

    scrollLeft(value?: string | undefined): this;

    scrollTop(value?: string): this;

    show(): this;

    siblings(): this;

    slice(start?: number, end?: number): this;

    splice(start: number, deleteCount?: number): this;

    text(text: string | number | boolean): this;
    text(): string;

    toArray(): Element[];

    toggle(value?: boolean | string): this;

    toggleClass(className: string, value?: boolean): this;

    trim(): this;

    val(value?: string | string[] | number): this;

    wrap(wrappingElement: this | Element | string): this;

    wrapInner(wrappingElement: this | Element | string): this;

    length: number;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxSVGElement = DxElement<SVGElement>;
  /**
   * A custom template&apos;s markup.
   */
  export type dxTemplate = Template;
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTemplateOptions {
    /**
     * Specifies the name of the template.
     */
    name?: string;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ElementsArrayWrapper<T extends Element> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface ElementsArrayWrapper<T extends Element> extends JQuery<T> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ElementWrapper<T extends Element> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface ElementWrapper<T extends Element> extends JQuery<T> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class FunctionTemplate {
    render(template: {
      container: unknown;
      model?: object;
      transclude?: boolean;
    }): DxElement;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type InternalElement<T extends Element> = {} extends Condition
    ? dxElementWrapper
    : InternalElementWrapper<T>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface InternalElementWrapper<T extends Element> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface InternalElementWrapper<T extends Element> extends JQuery<T> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type OmitInternal<T> = Omit<T, `${'_' | '$'}${any}`>;

  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface PromiseType<T> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface PromiseType<T> extends JQueryPromise<T> {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type Scalar =
    | undefined
    | null
    | string
    | String
    | number
    | Number
    | bigint
    | BigInteger
    | boolean
    | Boolean
    | Date
    | Function
    | Symbol
    | Array<unknown>;

  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class Template {
    constructor(options?: dxTemplateOptions);
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class TemplateManager {
    anonymousTemplateName: string;
    addDefaultTemplates(templates: Record<string, unknown>): void;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type UserDefinedElement<T extends Element = Element> =
    {} extends Condition ? T : ElementWrapper<T> | T;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type UserDefinedElementsArray = {} extends Condition
    ? Array<Element>
    : ElementsArrayWrapper<Element>;
}
declare module DevExpress.core.utils {
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DxExtendedPromise<T> = DxPromise<T> & {
    then<TResult1 = T, TResult2 = never>(
      onFulfilled?:
        | ((
            value: T,
            extraParameters?: any
          ) => TResult1 | PromiseLike<TResult1>)
        | undefined
        | null,
      onRejected?:
        | ((reason: any) => TResult2 | PromiseLike<TResult2>)
        | undefined
        | null
    ): PromiseLike<TResult1 | TResult2>;
  };
  /**
    * 
    * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
    */
   export type DxPromise<T = void> = {} extends PromiseType<T>
    ? Promise<T>
    : PromiseType<T>;
}
declare module DevExpress.data {
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DataSourceLike<TItem, TKey = any> =
    | string
    | Array<TItem>
    | DevExpress.data.utils.Store<TItem, TKey>
    | DataSourceOptionsStub<any, any, TItem>
    | DevExpress.common.data.DataSource<TItem, TKey>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DataSourceOptionsStub<
    TStoreItem = any,
    TMappedItem = TStoreItem,
    TItem = TMappedItem
  > {
    customQueryParams?: any;
    expand?: Array<string> | string;
    filter?:
      | DevExpress.common.data.FilterDescriptor
      | Array<DevExpress.common.data.FilterDescriptor>;
    group?:
      | DevExpress.common.data.GroupDescriptor<TItem>
      | Array<DevExpress.common.data.GroupDescriptor<TItem>>;
    langParams?: DevExpress.common.data.LangParams;
    map?: (dataItem: TStoreItem) => TMappedItem;
    onChanged?: (e: { readonly changes?: Array<TMappedItem> }) => void;
    onLoadError?: (error: { readonly message?: string }) => void;
    onLoadingChanged?: (isLoading: boolean) => void;
    pageSize?: number;
    paginate?: boolean;
    postProcess?: (data: Array<TMappedItem>) => Array<TItem>;
    pushAggregationTimeout?: number;
    requireTotalCount?: boolean;
    reshapeOnPush?: boolean;
    searchExpr?: string | Function | Array<string | Function>;
    searchOperation?: DevExpress.common.data.SearchOperation;
    searchValue?: any;
    select?: DevExpress.common.data.SelectDescriptor<TItem>;
    sort?:
      | DevExpress.common.data.SortDescriptor<TItem>
      | Array<DevExpress.common.data.SortDescriptor<TItem>>;
    store?:
      | Array<TStoreItem>
      | DevExpress.data.utils.Store<TStoreItem, any>
      | DevExpress.data.utils.StoreOptions<TStoreItem, any>;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type FilterDescriptor = any;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type GroupDescriptor<T> =
    | KeySelector<T>
    | (OrderingDescriptor<T> & {
        groupInterval?: number | GroupingInterval;
        isExpanded?: boolean;
      });
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type GroupingInterval =
    | 'year'
    | 'quarter'
    | 'month'
    | 'day'
    | 'dayOfWeek'
    | 'hour'
    | 'minute'
    | 'second';
  /**
   * The Guid is an object used to generate and contain a GUID.
   */
  export class Guid {
    constructor();
    constructor(value: string);
    /**
     * Gets the GUID. Works identically to the valueOf() method.
     */
    toString(): string;
    /**
     * Gets the GUID. Works identically to the toString() method.
     */
    valueOf(): string;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type KeySelector<T> =
    | string
    | ((source: T) => string | number | Date | Object);
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface LoadOptions<T = any> {
    /**
     * An object for storing additional settings that should be sent to the server. Relevant to the ODataStore only.
     */
    customQueryParams?: any;
    /**
     * Specifies the start date of the date navigator range. Relevant to the Scheduler only.
     */
    startDate?: Date;
    /**
     * Specifies the end date of the date navigator range. Relevant to the Scheduler only.
     */
    endDate?: Date;
    /**
     * An array of strings that represent the names of navigation properties to be loaded simultaneously with the ODataStore.
     */
    expand?: Array<string>;
    /**
     * A filter expression.
     */
    filter?: FilterDescriptor | Array<FilterDescriptor>;
    /**
     * A group expression.
     */
    group?: GroupDescriptor<T> | Array<GroupDescriptor<T>>;
    /**
     * A group summary expression. Used with the group setting.
     */
    groupSummary?: SummaryDescriptor<T> | Array<SummaryDescriptor<T>>;
    /**
     * The IDs of the rows being expanded. Relevant only when the CustomStore is used in the TreeList UI component.
     */
    parentIds?: Array<any>;
    /**
     * Indicates whether a top-level group count is required. Used in conjunction with the filter, take, skip, requireTotalCount, and group settings.
     */
    requireGroupCount?: boolean;
    /**
     * Indicates whether the total count of data objects is needed.
     */
    requireTotalCount?: boolean;
    /**
     * A data field or expression whose value is compared to the search value.
     */
    searchExpr?: string | Function | Array<string | Function>;
    /**
     * A comparison operation.
     */
    searchOperation?: SearchOperation;
    /**
     * The current search value.
     */
    searchValue?: any;
    /**
     * A select expression.
     */
    select?: SelectDescriptor<T>;
    /**
     * The number of data objects to be skipped from the result set&apos;s start. In conjunction with take, used to implement paging.
     */
    skip?: number;
    /**
     * A sort expression.
     */
    sort?: SortDescriptor<T> | Array<SortDescriptor<T>>;
    /**
     * The number of data objects to be loaded. In conjunction with skip, used to implement paging.
     */
    take?: number;
    /**
     * A total summary expression.
     */
    totalSummary?: SummaryDescriptor<T> | Array<SummaryDescriptor<T>>;
    /**
     * An object for storing additional settings that should be sent to the server.
     */
    userData?: any;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type OrderingDescriptor<T> = SelectionDescriptor<T> & {
    desc?: boolean;
  };
  /**
   * The PivotGridDataSource is an object that provides an API for processing data from an underlying store. This object is used in the PivotGrid UI component.
   */
  export class PivotGridDataSource {
    constructor(options?: DevExpress.data.PivotGridDataSource.Options);
    /**
     * Collapses all header items of a field with the specified identifier.
     */
    collapseAll(id: number | string): void;
    /**
     * Collapses a specific header item.
     */
    collapseHeaderItem(area: string, path: Array<string | number | Date>): void;
    /**
     * Provides access to the facts that were used to calculate a specific summary value.
     */
    createDrillDownDataSource(options: {
      columnPath?: Array<string | number | Date>;
      rowPath?: Array<string | number | Date>;
      dataIndex?: number;
      maxRowCount?: number;
      customColumns?: Array<string>;
    }): DevExpress.common.data.DataSource;
    /**
     * Disposes of all the resources allocated to the PivotGridDataSource instance.
     */
    dispose(): void;
    /**
     * Expands all the header items of a field with the specified identifier.
     */
    expandAll(id: number | string): void;
    /**
     * Expands a specific header item.
     */
    expandHeaderItem(area: string, path: Array<any>): void;
    /**
     * Gets all the properties of a field with the specified identifier.
     */
    field(id: number | string): any;
    /**
     * Updates field options&apos; values.
     */
    field(id: number | string, options: any): void;
    /**
     * Gets all the fields including those generated automatically.
     */
    fields(): Array<DevExpress.data.PivotGridDataSource.Field>;
    /**
     * Specifies a new fields collection.
     */
    fields(fields: Array<DevExpress.data.PivotGridDataSource.Field>): void;
    /**
     * Gets the filter property&apos;s value. Does not affect an XmlaStore.
     */
    filter(): any;
    /**
     * Sets the filter property&apos;s value. Does not affect an XmlaStore.
     */
    filter(filterExpr: any): void;
    /**
     * Gets all the fields within an area.
     */
    getAreaFields(
      area: string,
      collectGroups: boolean
    ): Array<DevExpress.data.PivotGridDataSource.Field>;
    /**
     * Gets the loaded data. Another data portion is loaded every time a header item is expanded.
     */
    getData(): any;
    /**
     * Checks whether the PivotGridDataSource is loading data.
     */
    isLoading(): boolean;
    /**
     * Starts loading data.
     */
    load(): DevExpress.core.utils.DxPromise<any>;
    /**
     * Detaches all event handlers from a single event.
     */
    off(eventName: DevExpress.data.PivotGridDataSource.EventName): this;
    /**
     * Detaches a particular event handler from a single event.
     */
    off(
      eventName: DevExpress.data.PivotGridDataSource.EventName,
      eventHandler: Function
    ): this;
    /**
     * Subscribes to an event.
     */
    on(
      eventName: DevExpress.data.PivotGridDataSource.EventName,
      eventHandler: Function
    ): this;
    /**
     * Subscribes to events.
     */
    on(events: {
      [key in DevExpress.data.PivotGridDataSource.EventName]?: Function;
    }): this;
    /**
     * Clears the loaded PivotGridDataSource data and calls the load() method.
     */
    reload(): DevExpress.core.utils.DxPromise<any>;
    /**
     * Gets the current PivotGridDataSource state. Part of the PivotGrid UI component&apos;s state storing feature.
     */
    state(): any;
    /**
     * Sets the PivotGridDataSource state. Part of the PivotGrid UI component&apos;s state storing feature.
     */
    state(state: any): void;
  }
  module PivotGridDataSource {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type EventName =
      | 'changed'
      | 'fieldsPrepared'
      | 'loadError'
      | 'loadingChanged';
    export type Options = PivotGridDataSourceOptions;
    export type PivotGridArea = 'column' | 'data' | 'filter' | 'row';
    export type PivotGridDataType = 'date' | 'number' | 'string';
    export type PivotGridGroupInterval =
      | 'day'
      | 'dayOfWeek'
      | 'month'
      | 'quarter'
      | 'year';
    export type PivotGridRunningTotalMode = 'column' | 'row';
    export type PivotGridSortBy = 'displayText' | 'value' | 'none';
    export type PivotGridStoreType = 'array' | 'local' | 'odata' | 'xmla';
    export type PivotGridSummaryDisplayMode =
      | 'absoluteVariation'
      | 'percentOfColumnGrandTotal'
      | 'percentOfColumnTotal'
      | 'percentOfGrandTotal'
      | 'percentOfRowGrandTotal'
      | 'percentOfRowTotal'
      | 'percentVariation';
  }
  /**
   * @deprecated Use Field instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface PivotGridDataSourceField {
    /**
     * Specifies whether to take neighboring groups&apos; summary values into account when calculating a running total and absolute or percent variation.
     */
    allowCrossGroupCalculation?: boolean;
    /**
     * Allows users to expand/collapse all header items within the same header level. Ignored if the PivotGridDataSource&apos;s paginate property is true.
     */
    allowExpandAll?: boolean;
    /**
     * Specifies whether a user can filter the field&apos;s values.
     */
    allowFiltering?: boolean;
    /**
     * Specifies whether a user can change the field&apos;s sorting.
     */
    allowSorting?: boolean;
    /**
     * Allows users to sort the pivot grid by summary values instead of field values. Ignored if the PivotGridDataSource&apos;s paginate property is true.
     */
    allowSortingBySummary?: boolean;
    /**
     * Specifies the field&apos;s area.
     */
    area?: DevExpress.data.PivotGridDataSource.PivotGridArea | undefined;
    /**
     * Specifies the field&apos;s order among the other fields in the same area. Corresponds to the field&apos;s order in the fields array by default.
     */
    areaIndex?: number;
    /**
     * Specifies a custom aggregate function. Applies only if the summaryType is &apos;custom&apos; and the remoteOperations is false. Cannot be used with an XmlaStore.
     */
    calculateCustomSummary?: (options: {
      summaryProcess?: string;
      value?: any;
      totalValue?: any;
    }) => void;
    /**
     * Specifies a custom post-processing function for summary values.
     */
    calculateSummaryValue?: (
      e: DevExpress.ui.dxPivotGridSummaryCell
    ) => number | null;
    /**
     * Specifies the field&apos;s caption to be displayed in the field chooser and on the field panel.
     */
    caption?: string;
    /**
     * Customizes the text displayed in summary cells.
     */
    customizeText?: (cellInfo: {
      value?: string | number | Date;
      valueText?: string;
    }) => string;
    /**
     * Specifies which data source field provides data for the pivot grid field.
     */
    dataField?: string;
    /**
     * Casts field values to a specific data type.
     */
    dataType?: DevExpress.data.PivotGridDataSource.PivotGridDataType;
    /**
     * Specifies the name of the directory in which the field is located when displayed in the field chooser.
     */
    displayFolder?: string;
    /**
     * Specifies whether to expand all items within the field&apos;s header level.
     */
    expanded?: boolean;
    /**
     * Specifies whether a user changes the current filter by including (selecting) or excluding (clearing the selection of) values.
     */
    filterType?: DevExpress.common.grids.FilterType;
    /**
     * Specifies the values by which the field is filtered.
     */
    filterValues?: Array<any>;
    /**
     * Formats field values before they are displayed.
     */
    format?: DevExpress.common.core.localization.Format;
    /**
     * Specifies the field&apos;s index within its group.
     */
    groupIndex?: number;
    /**
     * Specifies how the field&apos;s values are combined into groups for the headers. Cannot be used with an XmlaStore.
     */
    groupInterval?:
      | DevExpress.data.PivotGridDataSource.PivotGridGroupInterval
      | number;
    /**
     * Specifies the name of the field&apos;s group.
     */
    groupName?: string;
    /**
     * Configures the field&apos;s header filter.
     */
    headerFilter?: {
      allowSearch?: boolean;
      /**
       * Specifies whether a &apos;Select All&apos; option is available to users.
       */
      allowSelectAll?: boolean;
      height?: number;
      /**
       * Configures the header filter&apos;s search functionality.
       */
      search?: DevExpress.common.grids.HeaderFilterSearchConfig;
      width?: number;
    };
    /**
     * Specifies whether the field should be treated as a measure (a field providing data for calculation).
     */
    isMeasure?: boolean;
    /**
     * Specifies the field&apos;s unique identifier.
     */
    name?: string;
    /**
     * Specifies whether to calculate the running total by rows or by columns.
     */
    runningTotal?: DevExpress.data.PivotGridDataSource.PivotGridRunningTotalMode;
    /**
     * Specifies a function that combines field values into groups.
     */
    selector?: Function;
    /**
     * Specifies whether to display the field&apos;s grand totals. Applies only if the field is in the data area.
     */
    showGrandTotals?: boolean;
    /**
     * Specifies whether to display the field&apos;s totals.
     */
    showTotals?: boolean;
    /**
     * Specifies whether to display the field&apos;s summary values. Applies only if the field is in the data area. Inherits the showTotals&apos; value by default.
     */
    showValues?: boolean;
    /**
     * Specifies how the field&apos;s values in the headers should be sorted.
     */
    sortBy?: DevExpress.data.PivotGridDataSource.PivotGridSortBy;
    /**
     * Sorts the field&apos;s values in the headers by the specified measure&apos;s summary values. Accepts the measure&apos;s name, caption, dataField, or index in the fields array.
     */
    sortBySummaryField?: string;
    /**
     * Specifies a path to the column or row whose summary values should be used to sort the field&apos;s values in the headers.
     */
    sortBySummaryPath?: Array<number | string>;
    /**
     * Specifies the field values&apos; sorting order.
     */
    sortOrder?: DevExpress.common.SortOrder;
    /**
     * Specifies a custom comparison function that sorts the field&apos;s values in the headers.
     */
    sortingMethod?: (
      a: { value?: string | number; children?: Array<any> },
      b: { value?: string | number; children?: Array<any> }
    ) => number;
    /**
     * Specifies a predefined post-processing function. Does not apply when the calculateSummaryValue property is set.
     */
    summaryDisplayMode?: DevExpress.data.PivotGridDataSource.PivotGridSummaryDisplayMode;
    /**
     * Specifies how to aggregate the field&apos;s data. Cannot be used with an XmlaStore.
     */
    summaryType?: DevExpress.common.grids.SummaryType | string;
    /**
     * Specifies whether the field is visible in the pivot grid and field chooser.
     */
    visible?: boolean;
    /**
     * Specifies the field&apos;s width in pixels when the field is displayed in the pivot grid.
     */
    width?: number;
    /**
     * Specifies whether text that does not fit into a header item should be wrapped.
     */
    wordWrapEnabled?: boolean;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface PivotGridDataSourceOptions {
    /**
     * Configures pivot grid fields.
     */
    fields?: Array<DevExpress.data.PivotGridDataSource.Field>;
    /**
     * Specifies data filtering conditions. Cannot be used with an XmlaStore.
     */
    filter?: string | Array<any> | Function;
    /**
     * A function that is executed after data is successfully loaded.
     */
    onChanged?: Function;
    /**
     * A function that is executed when all fields are loaded from the store and they are ready to be displayed in the PivotGrid.
     */
    onFieldsPrepared?: (
      fields: Array<DevExpress.data.PivotGridDataSource.Field>
    ) => void;
    /**
     * A function that is executed when data loading fails.
     */
    onLoadError?: (error: any) => void;
    /**
     * A function that is executed when the data loading status changes.
     */
    onLoadingChanged?: (isLoading: boolean) => void;
    /**
     * Specifies whether the PivotGridDataSource should load data in portions. Can be used only with an XmlaStore.
     */
    paginate?: boolean;
    /**
     * Specifies whether the data processing operations (filtering, grouping, summary calculation) should be performed on the server.
     */
    remoteOperations?: boolean;
    /**
     * Specifies whether to auto-generate pivot grid fields from the store&apos;s data.
     */
    retrieveFields?: boolean;
    /**
     * Configures the DataSource&apos;s underlying store.
     */
    store?:
      | DevExpress.data.utils.Store
      | DevExpress.data.utils.StoreOptions
      | XmlaStore
      | (XmlaStoreOptions & { type: 'xmla' })
      | Array<{
          /**
           * Specifies the PivotGridDataSource&apos;s storage type.
           */
          type?: DevExpress.data.PivotGridDataSource.PivotGridStoreType;
        }>
      | {
          /**
           * Specifies the PivotGridDataSource&apos;s storage type.
           */
          type?: DevExpress.data.PivotGridDataSource.PivotGridStoreType;
        };
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SearchOperation =
    | '='
    | '<>'
    | '>'
    | '>='
    | '<'
    | '<='
    | 'startswith'
    | 'endswith'
    | 'contains'
    | 'notcontains';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SelectDescriptor<T> =
    | string
    | Array<string>
    | ((source: T) => any);
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SelectionDescriptor<T> = {
    selector: KeySelector<T>;
  };
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SortDescriptor<T> = KeySelector<T> | OrderingDescriptor<T>;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  type StoreEventName =
    | 'loaded'
    | 'loading'
    | 'inserted'
    | 'inserting'
    | 'updated'
    | 'updating'
    | 'push'
    | 'removed'
    | 'removing'
    | 'modified'
    | 'modifying';
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type SummaryDescriptor<T> =
    | KeySelector<T>
    | (SelectionDescriptor<T> & {
        summaryType?: 'sum' | 'avg' | 'min' | 'max' | 'count';
      });
  /**
   * The XmlaStore is a store that provides an interface for accessing an OLAP cube according to the XMLA standard.
   */
  export class XmlaStore {
    constructor(options?: XmlaStoreOptions);
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface XmlaStoreOptions {
    /**
     * Specifies a function that customizes the request before it is sent to the server.
     */
    beforeSend?: (options: {
      url?: string;
      method?: string;
      headers?: any;
      xhrFields?: any;
      data?: string;
      dataType?: string;
    }) => void;
    /**
     * Specifies the database (or initial catalog) that contains the OLAP cube to use.
     */
    catalog?: string;
    /**
     * Specifies the name of the OLAP cube to use from the catalog.
     */
    cube?: string;
    /**
     * Specifies the OLAP server&apos;s URL.
     */
    url?: string;
  }
}
declare module DevExpress.data.ArrayStore {
  /**
   * @deprecated Use DevExpress.common.data.ArrayStoreOptions from /common/data instead
   */
  export type Options<
    TItem = any,
    TKey = any
  > = DevExpress.common.data.ArrayStoreOptions<TItem, TKey>;
}
declare module DevExpress.data.CustomStore {
  /**
   * @deprecated Use DevExpress.common.data.CustomStoreOptions from /common/data instead
   */
  export type Options<
    TItem = any,
    TKey = any
  > = DevExpress.common.data.CustomStoreOptions<TItem, TKey>;
}
declare module DevExpress.data.LocalStore {
  /**
   * @deprecated Use DevExpress.common.data.LocalStoreOptions from /common/data instead
   */
  export type Options<
    TItem = any,
    TKey = any
  > = DevExpress.common.data.LocalStoreOptions<TItem, TKey>;
}
declare module DevExpress.data.ODataStore {
  export type Options<
    TItem = any,
    TKey = any
  > = DevExpress.common.data.ODataStoreOptions<TItem, TKey>;
}
declare module DevExpress.data.PivotGridDataSource {
  /**
   * Configures pivot grid fields.
   */
  export type Field = PivotGridDataSourceField;
}
declare module DevExpress.data.utils {
  export type Store<TItem = any, TKey = any> =
    | DevExpress.common.data.CustomStore<TItem, TKey>
    | DevExpress.common.data.ArrayStore<TItem, TKey>
    | DevExpress.common.data.LocalStore<TItem, TKey>
    | DevExpress.common.data.ODataStore<TItem, TKey>;
  export type StoreOptions<TItem = any, TKey = any> =
    | DevExpress.common.data.CustomStoreOptions<TItem, TKey>
    | (DevExpress.common.data.ArrayStoreOptions<TItem, TKey> & {
        type: 'array';
      })
    | (DevExpress.common.data.LocalStoreOptions<TItem, TKey> & {
        type: 'local';
      })
    | (DevExpress.common.data.ODataStoreOptions<TItem, TKey> & {
        type: 'odata';
      });
}
declare module DevExpress.events {
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type DxEvent<TNativeEvent = Event> = {} extends EventType
    ? EventObject<TNativeEvent> & TNativeEvent
    : Omit<EventType, 'originalEvent'> & {
        /**
         * 
         */
        originalEvent: TNativeEvent;
      };
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type event = DxEvent;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type EventObject<TNativeEvent = Event> = {
    /**
     * The DOM element within the current event propagation stage.
     */
    currentTarget: Element;

    /**
     * Data passed to the event handler.
     */
    data: any;

    /**
     * The DOM element to which the currently-called event handler was attached.
     */
    delegateTarget: Element;

    /**
     * The native JavaScript event contained in the DevExtreme event.
     */
    originalEvent: TNativeEvent;

    /**
     * The DOM element that initiated the event.
     */
    target: Element;
    /**
     * Checks if the preventDefault() method was called on this event object.
     */
    isDefaultPrevented(): boolean;
    /**
     * Checks if the stopImmediatePropagation() method was called on this event object.
     */
    isImmediatePropagationStopped(): boolean;
    /**
     * Checks if the stopPropagation() method was called on this event object.
     */
    isPropagationStopped(): boolean;
    /**
     * Prevents the event&apos;s default action from triggering.
     */
    preventDefault(): void;
    /**
     * Stops the event&apos;s propagation up the DOM tree, preventing the rest of the handlers from being executed.
     */
    stopImmediatePropagation(): void;
    /**
     * Stops the event&apos;s propagation up the DOM tree, keeping parent handlers unnotified of the event.
     */
    stopPropagation(): void;
  };
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export function eventsHandler(event: DxEvent, extraParameters: any): boolean;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface EventType {}
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface EventType extends JQueryEventObject {
    cancel?: boolean;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type InteractionEvent = PointerInteractionEvent | KeyboardEvent;
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type PointerInteractionEvent = MouseEvent | TouchEvent | PointerEvent;
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export function triggerHandler(
    element: Element | Array<Element>,
    event: string | DxEvent
  ): void;
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export function triggerHandler(
    element: Element | Array<Element>,
    event: string | DxEvent,
    extraParameters: any
  ): void;
}
declare module DevExpress.excelExporter {
  /**
   * 
   */
  export interface CellAddress {
    /**
     * The index of a row that contains the cell.
     */
    row?: number;
    /**
     * The index of a column that contains the cell.
     */
    column?: number;
  }
  /**
   * The coordinates of the exported DataGrid in the Excel file.
   */
  export interface CellRange {
    /**
     * Coordinates of the top left cell.
     */
    from?: CellAddress;
    /**
     * Coordinates of the bottom right cell.
     */
    to?: CellAddress;
  }
  /**
   * @deprecated Use DataGridCell instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ExcelDataGridCell {
    /**
     * The configuration of the cell&apos;s column.
     */
    column?: DevExpress.ui.dxDataGrid.Column;
    /**
     * The data object of the cell&apos;s row.
     */
    data?: any;
    /**
     * The group index of the cell&apos;s row. Available when the rowType is &apos;group&apos;.
     */
    groupIndex?: number;
    /**
     * Information about group summary items the cell represents.
     */
    groupSummaryItems?: Array<{
      /**
       * The group summary item&apos;s identifier.
       */
      name?: string;
      /**
       * The group summary item&apos;s raw value.
       */
      value?: any;
    }>;
    /**
     * The type of the cell&apos;s row.
     */
    rowType?: string;
    /**
     * The identifier of the total summary item that the cell represents.
     */
    totalSummaryItemName?: string;
    /**
     * The cell&apos;s raw value.
     */
    value?: any;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ExcelExportBaseOptions {
    /**
     * An Excel worksheet to which the grid should be exported.
     */
    worksheet?: object | undefined;
    /**
     * A cell used as a start position for export.
     */
    topLeftCell?: CellAddress | string;
    /**
     * Specifies whether Excel columns should have the same width as their source UI component&apos;s columns.
     */
    keepColumnWidths?: boolean;
    /**
     * Configures the load panel.
     */
    loadPanel?: ExportLoadPanel;
    /**
     * Specifies if the CSV export routine saves potentially dangerous content as plain text data.
     */
    encodeExecutableContent?: boolean;
  }
  /**
   * @deprecated Use PivotGridCell instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ExcelPivotGridCell extends DevExpress.ui.dxPivotGrid.Cell {
    /**
     * The area to which the cell belongs.
     */
    area?: 'column' | 'row' | 'data';
    /**
     * A zero-based index that indicates the position of the cell&apos;s row.
     */
    rowIndex?: number;
    /**
     * A zero-based index that indicates the position of the cell&apos;s column.
     */
    columnIndex?: number;
    /**
     * The header type. Available if the cell belongs to the field panel.
     */
    headerType?: 'column' | 'row' | 'data' | 'filter';
  }
}
declare module DevExpress.fileManagement {
  /**
   * A custom file system provider allows you to implement custom APIs to access and use file systems.
   */
  export class CustomFileSystemProvider extends FileSystemProviderBase {
    constructor(
      options?: DevExpress.fileManagement.CustomFileSystemProvider.Options
    );
  }
  module CustomFileSystemProvider {
    export type Options = CustomFileSystemProviderOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface CustomFileSystemProviderOptions
    extends FileSystemProviderBaseOptions<CustomFileSystemProvider> {
    /**
     * A function that cancels the file upload.
     */
    abortFileUpload?: (
      file: File,
      uploadInfo: UploadInfo,
      destinationDirectory: FileSystemItem
    ) => PromiseLike<any> | any;

    /**
     * A function that copies files or directories.
     */
    copyItem?: (
      item: FileSystemItem,
      destinationDirectory: FileSystemItem
    ) => PromiseLike<any> | any;

    /**
     * A function that creates a directory.
     */
    createDirectory?: (
      parentDirectory: FileSystemItem,
      name: string
    ) => PromiseLike<any> | any;

    /**
     * A function that deletes a file or directory.
     */
    deleteItem?: (item: FileSystemItem) => PromiseLike<any> | any;

    /**
     * A function that downloads files.
     */
    downloadItems?: (items: Array<FileSystemItem>) => void;

    /**
     * A function that gets file system items.
     */
    getItems?: (
      parentDirectory: FileSystemItem
    ) => PromiseLike<Array<any>> | Array<any>;

    /**
     * A function that get items content.
     */
    getItemsContent?: (items: Array<FileSystemItem>) => PromiseLike<any> | any;

    /**
     * A function or the name of a data source field that provides information on whether a file or directory contains sub directories.
     */
    hasSubDirectoriesExpr?: string | Function;

    /**
     * A function that moves files and directories.
     */
    moveItem?: (
      item: FileSystemItem,
      destinationDirectory: FileSystemItem
    ) => PromiseLike<any> | any;

    /**
     * A function that renames files and directories.
     */
    renameItem?: (
      item: FileSystemItem,
      newName: string
    ) => PromiseLike<any> | any;

    /**
     * A function that uploads a file in chunks.
     */
    uploadFileChunk?: (
      file: File,
      uploadInfo: UploadInfo,
      destinationDirectory: FileSystemItem
    ) => PromiseLike<any> | any;
  }
  /**
   * An object that contains information about the error.
   */
  export class FileSystemError {
    constructor(
      errorCode?: number,
      fileSystemItem?: FileSystemItem,
      errorText?: string
    );
    /**
     * The processed file or directory.
     */
    fileSystemItem?: FileSystemItem;

    /**
     * The error code.
     */
    errorCode?: number;

    /**
     * The error message.
     */
    errorText?: string;
  }
  /**
   * An object that provides information about a file system item (file or directory) in the FileManager UI component.
   */
  export class FileSystemItem {
    constructor(path: string, isDirectory: boolean, pathKeys?: Array<string>);

    /**
     * The file system item&apos;s path.
     */
    path: string;

    /**
     * The file system item&apos;s path specified in keys.
     */
    pathKeys: Array<string>;

    /**
     * The file system item&apos;s key.
     */
    key: string;

    /**
     * The file system item&apos;s name.
     */
    name: string;

    /**
     * A timestamp that indicates when the file system item was last modified.
     */
    dateModified: Date;

    /**
     * The file system item&apos;s size (in bytes).
     */
    size: number;

    /**
     * Specifies whether the file system item is a directory.
     */
    isDirectory: boolean;

    /**
     * Specifies whether a directory has subdirectories.
     */
    hasSubDirectories: boolean;

    /**
     * An icon (URL) to be used as the file system item&apos;s thumbnail.
     */
    thumbnail: string;

    /**
     * The file system data object that stores information about the file system item (name, size, modification date, etc.).
     */
    dataItem: any;

    /**
     * Gets a file&apos;s extension.
     */
    getFileExtension(): string;
  }
  /**
   * Contains base provider settings.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class FileSystemProviderBase {
    constructor(options?: FileSystemProviderBaseOptions);
    /**
     * Gets file system items.
     */
    getItems(
      parentDirectory: FileSystemItem
    ): DevExpress.core.utils.DxPromise<Array<FileSystemItem>>;

    /**
     * Renames a file or directory.
     */
    renameItem(
      item: FileSystemItem,
      newName: string
    ): DevExpress.core.utils.DxPromise<any>;

    /**
     * Creates a directory.
     */
    createDirectory(
      parentDirectory: FileSystemItem,
      name: string
    ): DevExpress.core.utils.DxPromise<any>;

    /**
     * Deletes files or directories.
     */
    deleteItems(
      items: Array<FileSystemItem>
    ): Array<DevExpress.core.utils.DxPromise<any>>;

    /**
     * Moves files and directories.
     */
    moveItems(
      items: Array<FileSystemItem>,
      destinationDirectory: FileSystemItem
    ): Array<DevExpress.core.utils.DxPromise<any>>;

    /**
     * Copies files or directories.
     */
    copyItems(
      items: Array<FileSystemItem>,
      destinationDirectory: FileSystemItem
    ): Array<DevExpress.core.utils.DxPromise<any>>;

    /**
     * Uploads a file in chunks.
     */
    uploadFileChunk(
      fileData: File,
      uploadInfo: UploadInfo,
      destinationDirectory: FileSystemItem
    ): DevExpress.core.utils.DxPromise<any>;

    /**
     * Cancels the file upload.
     */
    abortFileUpload(
      fileData: File,
      uploadInfo: UploadInfo,
      destinationDirectory: FileSystemItem
    ): DevExpress.core.utils.DxPromise<any>;

    /**
     * Downloads files.
     */
    downloadItems(items: Array<FileSystemItem>): void;

    /**
     * Gets items content.
     */
    getItemsContent(
      items: Array<FileSystemItem>
    ): DevExpress.core.utils.DxPromise<any>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface FileSystemProviderBaseOptions<T = FileSystemProviderBase> {
    /**
     * Specifies which data field provides timestamps that indicate when a file was last modified.
     */
    dateModifiedExpr?: string | Function;
    /**
     * Specifies which data field provides information about whether a file system item is a directory.
     */
    isDirectoryExpr?: string | Function;
    /**
     * Specifies the data field that provides keys.
     */
    keyExpr?: string | Function;
    /**
     * Specifies which data field provides file and directory names.
     */
    nameExpr?: string | Function;
    /**
     * Specifies which data field provides file sizes.
     */
    sizeExpr?: string | Function;
    /**
     * Specifies which data field provides icons to be used as thumbnails.
     */
    thumbnailExpr?: string | Function;
  }
  /**
   * The Object file system provider works with a file system represented by an in-memory array of JSON objects.
   */
  export class ObjectFileSystemProvider extends FileSystemProviderBase {
    constructor(
      options?: DevExpress.fileManagement.ObjectFileSystemProvider.Options
    );
  }
  module ObjectFileSystemProvider {
    export type Options = ObjectFileSystemProviderOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ObjectFileSystemProviderOptions
    extends FileSystemProviderBaseOptions<ObjectFileSystemProvider> {
    /**
     * Specifies which data field provides information about files content.
     */
    contentExpr?: string | Function;
    /**
     * Specifies an array of data objects that represent files and directories.
     */
    data?: Array<any>;
    /**
     * Specifies which data field provides information about nested files and directories.
     */
    itemsExpr?: string | Function;
  }
  /**
   * The Remote file system provider works with a file system located on the server.
   */
  export class RemoteFileSystemProvider extends FileSystemProviderBase {
    constructor(
      options?: DevExpress.fileManagement.RemoteFileSystemProvider.Options
    );
  }
  module RemoteFileSystemProvider {
    export type Options = RemoteFileSystemProviderOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface RemoteFileSystemProviderOptions
    extends FileSystemProviderBaseOptions<RemoteFileSystemProvider> {
    /**
     * Specifies a function that customizes an Ajax request before it is sent to the server.
     */
    beforeAjaxSend?: (options: {
      headers?: any;
      xhrFields?: any;
      formData?: any;
    }) => void;
    /**
     * Specifies a function that customizes a form submit request before it is sent to the server.
     */
    beforeSubmit?: (options: { formData?: any }) => void;
    /**
     * Specifies the URL of an endpoint used to access and modify a file system located on the server.
     */
    endpointUrl?: string;
    /**
     * Specifies which data field provides information about whether a directory has subdirectories.
     */
    hasSubDirectoriesExpr?: string | Function;
    /**
     * Specifies the request headers.
     */
    requestHeaders?: any;
  }
  /**
   * An object that provides information about the file upload session.
   */
  export interface UploadInfo {
    /**
     * The number of bytes that is uploaded to the server.
     */
    bytesUploaded: number;

    /**
     * The number of uploaded chunks and chunks that are to be uploaded.
     */
    chunkCount: number;

    /**
     * Custom information that you can pass during file upload. For instance, you can specify a custom file ID when the first part of a file is being uploaded.
     */
    customData: any;

    /**
     * The binary content of the uploading chunk.
     */
    chunkBlob: Blob;

    /**
     * The index of the uploading chunk.
     */
    chunkIndex: number;
  }
}
declare module DevExpress.pdfExporter {
  /**
   * @deprecated Use DataGridCell instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface PdfDataGridCell
    extends DevExpress.common.Export.excel.DataGridCell {}
}
declare module DevExpress.ui {
  /**
   * An object that describes an appointment in the Scheduler UI component.
   */
  export type Appointment = dxSchedulerAppointment;
  /**
   * Specifies dependency between the screen factor and the count of columns.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface ColCountResponsible {
    /**
     * The count of columns for a large screen size.
     */
    lg?: number | undefined;
    /**
     * The count of columns for a middle-sized screen.
     */
    md?: number | undefined;
    /**
     * The count of columns for a small-sized screen.
     */
    sm?: number | undefined;
    /**
     * The count of columns for an extra small-sized screen.
     */
    xs?: number | undefined;
  }
  /**
   * The base class for UI components containing an item collection.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class CollectionWidget<
    TProperties extends CollectionWidgetOptions<any, TItem, TKey>,
    TItem extends DevExpress.ui.CollectionWidget.ItemLike = any,
    TKey = any
  > extends Widget<TProperties> {
    getDataSource(): DevExpress.common.data.DataSource<TItem, TKey>;
  }
  module CollectionWidget {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ItemLike = string | CollectionWidgetItem | any;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface SelectionChangeInfo<TItem extends ItemLike = any> {
      /**
       * 
       */
      readonly addedItems: Array<TItem>;
      /**
       * 
       */
      readonly removedItems: Array<TItem>;
    }
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type SelectionChangingEventBase<TComponent> =
      DevExpress.common.core.events.AsyncCancelable &
        DevExpress.common.core.events.EventInfo<TComponent> &
        SelectionChangeInfo;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface CollectionWidgetItem {
    /**
     * Specifies whether the UI component item responds to user interaction.
     */
    disabled?: boolean;
    /**
     * Specifies the HTML markup to be inserted into the item element.
     */
    html?: string;
    /**
     * Specifies a template that should be used to render this item only.
     */
    template?:
      | template
      | ((
          itemData: this,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies text displayed for the UI component item.
     */
    text?: string;
    /**
     * Specifies whether or not a UI component item must be displayed.
     */
    visible?: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface CollectionWidgetOptions<
    TComponent extends CollectionWidget<any, TItem, TKey> | any,
    TItem extends DevExpress.ui.CollectionWidget.ItemLike = any,
    TKey = any
  > extends WidgetOptions<TComponent> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * The time period in milliseconds before the onItemHold event is raised.
     */
    itemHoldTimeout?: number;
    /**
     * Specifies a custom template for items.
     */
    itemTemplate?:
      | template
      | ((
          itemData: TItem,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies the key property that provides key values to access data items. Each key value must be unique.
     */
    keyExpr?: string | Function;
    /**
     * Specifies the text or HTML markup displayed by the UI component if the item collection is empty.
     */
    noDataText?: string;
    /**
     * A function that is executed when a collection item is clicked or tapped.
     */
    onItemClick?:
      | ((
          e: DevExpress.common.core.events.NativeEventInfo<
            TComponent,
            MouseEvent | PointerEvent
          > &
            DevExpress.common.core.events.ItemInfo<TItem>
        ) => void)
      | string;
    /**
     * A function that is executed when a collection item is right-clicked or pressed.
     */
    onItemContextMenu?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        DevExpress.events.PointerInteractionEvent
      > &
        DevExpress.common.core.events.ItemInfo<TItem>
    ) => void;
    /**
     * A function that is executed when a collection item has been held for a specified period.
     */
    onItemHold?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        DevExpress.events.PointerInteractionEvent
      > &
        DevExpress.common.core.events.ItemInfo<TItem>
    ) => void;
    /**
     * A function that is executed after a collection item is rendered.
     */
    onItemRendered?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.common.core.events.ItemInfo<TItem>
    ) => void;
    /**
     * A function that is called before selection changes.
     */
    onSelectionChanging?: (
      e: DevExpress.ui.CollectionWidget.SelectionChangingEventBase<TComponent>
    ) => void;
    /**
     * A function that is called after selection changes.
     */
    onSelectionChanged?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>
    ) => void;
    /**
     * The index of the currently selected UI component item.
     */
    selectedIndex?: number;
    /**
     * The selected item object.
     */
    selectedItem?: TItem;
    /**
     * Specifies an array of currently selected item keys.
     */
    selectedItemKeys?: Array<TKey>;
    /**
     * An array of currently selected item objects.
     */
    selectedItems?: Array<TItem>;
  }
  export interface CustomDialogOptions {
    title?: string;
    messageHtml?: string;
    buttons?: Array<dxButtonOptions>;
    showTitle?: boolean;
    message?: string;
    dragEnabled?: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class DataExpressionMixin {
    constructor(options?: DataExpressionMixinOptions);
    getDataSource(): DevExpress.common.data.DataSource;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DataExpressionMixinOptions<T = DataExpressionMixin> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<
      CollectionWidgetItem | any
    > | null;
    /**
     * Specifies the data field whose values should be displayed.
     */
    displayExpr?: string | ((item: any) => string) | undefined;
    /**
     * Specifies a custom template for items.
     */
    itemTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<CollectionWidgetItem | any>;
    /**
     * Specifies the currently selected value. May be an object if dataSource contains objects, the store key is specified, and valueExpr is not set.
     */
    value?: any;
    /**
     * Specifies which data field provides unique values to the UI component&apos;s value.
     */
    valueExpr?: string | ((item: any) => string | number | boolean);
  }
  /**
   * A drop-down editor UI component.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class DateBoxBase<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue = DevExpress.ui.dxDateBox.Properties
  > extends dxDropDownEditor<TProperties> {
    /**
     * Closes the drop-down editor.
     */
    close(): void;
    /**
     * Opens the drop-down editor.
     */
    open(): void;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DateBoxBaseOptions<TComponent>
    extends Omit<dxDropDownEditorOptions<TComponent>, 'fieldAddons'> {
    /**
     * Specifies the Apply button&apos;s text.
     */
    applyButtonText?: string;
    /**
     * Configures the calendar&apos;s value picker.
     */
    calendarOptions?: dxCalendarOptions;
    /**
     * Specifies the Cancel button&apos;s text.
     */
    cancelButtonText?: string;
    /**
     * Specifies the date value serialization format.
     */
    dateSerializationFormat?: string | undefined;
    /**
     * Specifies the date&apos;s display format.
     */
    displayFormat?: DevExpress.common.core.localization.Format;
    /**
     * The latest date that can be selected in the UI component.
     */
    max?: DevExpress.common.DateLike | undefined;
    /**
     * The earliest date that can be selected in the UI component.
     */
    min?: DevExpress.common.DateLike | undefined;
    /**
     * Specified the Today button&apos;s text.
     */
    todayButtonText?: string;
    /**
     * Specifies whether to use an input mask based on the displayFormat property.
     */
    useMaskBehavior?: boolean;
    /**
     * Configures the drop-down that holds the content.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
  }
  /**
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export const DateRangeBoxBase: Omit<typeof DateBoxBase, 'new' | 'prototype'> &
    (new (
      element: DevExpress.core.UserDefinedElement,
      options?: DevExpress.ui.dxDateRangeBox.Properties
    ) => Omit<
      DateBoxBase<DevExpress.ui.dxDateRangeBox.Properties>,
      'field' | 'reset'
    >);
  /**
    * 
    * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
    */
   export interface DraggableBase {}
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface DraggableBaseOptions<TComponent>
    extends DOMComponentOptions<TComponent> {
    /**
     * Enables automatic scrolling while dragging an item beyond the viewport.
     */
    autoScroll?: boolean;
    /**
     * Specifies a DOM element that limits the dragging area.
     */
    boundary?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies a custom container in which the draggable item should be rendered.
     */
    container?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies the cursor offset from the dragged item.
     */
    cursorOffset?:
      | string
      | {
          /**
           * Specifies the horizontal cursor offset from the dragged item in pixels.
           */
          x?: number;
          /**
           * Specifies the vertical cursor offset from the dragged item in pixels.
           */
          y?: number;
        };
    /**
     * A container for custom data.
     */
    data?: any | undefined;
    /**
     * Specifies the directions in which an item can be dragged.
     */
    dragDirection?: DevExpress.common.DragDirection;
    /**
     * Allows you to group several UI components, so that users can drag and drop items between them.
     */
    group?: string | undefined;
    /**
     * Specifies a CSS selector (ID or class) that should act as the drag handle(s) for the item(s).
     */
    handle?: string;
    /**
     * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
     */
    scrollSensitivity?: number;
    /**
     * Specifies the scrolling speed when dragging an item beyond the viewport. Applies only if autoScroll is true.
     */
    scrollSpeed?: number;
  }
  /**
   * The Accordion UI component contains several panels displayed one under another. These panels can be collapsed or expanded by an end user, which makes this UI component very useful for presenting information in a limited amount of space.
   */
  export class dxAccordion<
    TItem extends DevExpress.ui.dxAccordion.ItemLike = any,
    TKey = any
  > extends CollectionWidget<dxAccordionOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Collapses an item with a specific index.
     */
    collapseItem(index: number): DevExpress.core.utils.DxPromise<void>;
    /**
     * Expands an item with a specific index.
     */
    expandItem(index: number): DevExpress.core.utils.DxPromise<void>;
    /**
     * Updates the dimensions of the UI component contents.
     */
    updateDimensions(): DevExpress.core.utils.DxPromise<void>;
  }
  module dxAccordion {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxAccordion<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxAccordion<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      ItemTitleClickEvent: ItemTitleClickEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxAccordion<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxAccordion<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxAccordion<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxAccordion<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxAccordion<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemTitleClick event handler&apos;s argument.
     */
    export type ItemTitleClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxAccordion<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxAccordion<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxAccordionOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxAccordion<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxAccordionItem extends CollectionWidgetItem {
    /**
     * Specifies the icon to be displayed in the panel&apos;s title.
     */
    icon?: string;
    /**
     * Specifies text displayed for the UI component item title.
     */
    title?: string;
    /**
     * Specifies a template that should be used to render the title for this item only.
     */
    titleTemplate?:
      | template
      | (() => string | DevExpress.core.UserDefinedElement);
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxAccordionOptions<
    TItem extends DevExpress.ui.dxAccordion.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxAccordion<TItem, TKey>, TItem, TKey> {
    /**
     * A number specifying the time in milliseconds spent on the animation of the expanding or collapsing of a panel.
     */
    animationDuration?: number;
    /**
     * Specifies whether all items can be collapsed or whether at least one item must always be expanded.
     */
    collapsible?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether to render the panel&apos;s content when it is displayed. If false, the content is rendered immediately.
     */
    deferRendering?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string | undefined;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies a custom template for items.
     */
    itemTemplate?:
      | template
      | ((
          itemData: TItem,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies a custom template for item titles.
     */
    itemTitleTemplate?:
      | template
      | ((
          itemData: TItem,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies whether the UI component can expand several items or only a single item at once.
     */
    multiple?: boolean;
    /**
     * A function that is executed when an accordion item&apos;s title is clicked or tapped.
     */
    onItemTitleClick?:
      | ((
          e: DevExpress.ui.dxAccordion.ItemTitleClickEvent<TItem, TKey>
        ) => void)
      | string;
    /**
     * Specifies whether to repaint only those elements whose data changed.
     */
    repaintChangesOnly?: boolean;
    /**
     * The index number of the currently expanded item.
     */
    selectedIndex?: number;
  }
  /**
   * The ActionSheet UI component is a sheet containing a set of buttons located one under the other. These buttons usually represent several choices relating to a single task.
   */
  export class dxActionSheet<
    TItem extends DevExpress.ui.dxActionSheet.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidget<dxActionSheetOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Hides the UI component.
     */
    hide(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows the UI component.
     */
    show(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows or hides the UI component depending on the argument.
     */
    toggle(showing: boolean): DevExpress.core.utils.DxPromise<void>;
  }
  module dxActionSheet {
    /**
     * The type of the cancelClick event handler&apos;s argument.
     */
    export type CancelClickEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxActionSheet<TItem, TKey>>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxActionSheet<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxActionSheet<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike<TKey>, TKey> = {
      Properties: Properties<TItem, TKey>;
      CancelClickEvent: CancelClickEvent<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxActionSheet<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxActionSheet<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxActionSheet<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxActionSheet<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike<TKey> = string | Item<TKey> | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxActionSheet<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxActionSheet<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = dxActionSheetOptions<TItem, TKey>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxActionSheetItem<TKey = any> extends CollectionWidgetItem {
    /**
     * Specifies the icon to be displayed on the action sheet button.
     */
    icon?: string;
    /**
     * A handler for the click event raised for the button representing the given action sheet button.
     */
    onClick?:
      | ((
          e: DevExpress.common.core.events.NativeEventInfo<
            dxActionSheet<this, TKey>,
            MouseEvent | PointerEvent
          >
        ) => void)
      | string;
    /**
     * Specifies the type of the button that is an action sheet item.
     */
    type?: DevExpress.common.ButtonType | string;
    /**
     * Specifies which style to apply to the button that is an action sheet item.
     */
    stylingMode?: DevExpress.common.ButtonStyle;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxActionSheetOptions<
    TItem extends DevExpress.ui.dxActionSheet.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidgetOptions<dxActionSheet<TItem, TKey>, TItem, TKey> {
    /**
     * The text displayed in the button that closes the action sheet.
     */
    cancelText?: string;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * A function that is executed when the Cancel button is clicked or tapped.
     */
    onCancelClick?:
      | ((e: DevExpress.ui.dxActionSheet.CancelClickEvent<TItem, TKey>) => void)
      | string;
    /**
     * Specifies whether or not to display the Cancel button in action sheet.
     */
    showCancelButton?: boolean;
    /**
     * A Boolean value specifying whether or not the title of the action sheet is visible.
     */
    showTitle?: boolean;
    /**
     * Specifies the element the action sheet popover points at. Applies only if usePopover is true.
     */
    target?: string | DevExpress.core.UserDefinedElement;
    /**
     * The title of the action sheet.
     */
    title?: string;
    /**
     * Specifies whether or not to show the action sheet within a Popover UI component.
     */
    usePopover?: boolean;
    /**
     * A Boolean value specifying whether or not the ActionSheet UI component is visible.
     */
    visible?: boolean;
  }
  /**
   * The AutoComplete UI component is a textbox that provides suggestions while a user types into it.
   */
  export class dxAutocomplete extends dxDropDownList<dxAutocompleteOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxAutocomplete.Properties['value']): void;
  }
  module dxAutocomplete {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxAutocomplete>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxAutocomplete,
      ClipboardEvent
    >;
    export type Properties = dxAutocompleteOptions;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxAutocomplete> &
        DevExpress.ui.dxDropDownList.SelectionChangedInfo;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxAutocomplete,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxAutocompleteOptions
    extends dxDropDownListOptions<dxAutocomplete> {
    /**
     * Specifies the maximum count of items displayed by the UI component.
     */
    maxItemCount?: number;
    /**
     * The minimum number of characters that must be entered into the text box to begin a search.
     */
    minSearchLength?: number;
    /**
     * Specifies whether the drop-down button is visible.
     */
    showDropDownButton?: boolean;
    /**
     * Specifies the current value displayed by the UI component.
     */
    value?: string | null;
    /**
     * Configures the drop-down field which holds the content.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
  }
  /**
   * The Box UI component allows you to arrange various elements within it. Separate and adaptive, the Box UI component acts as a building block for the layout.
   */
  export class dxBox<
    TItem extends DevExpress.ui.dxBox.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidget<dxBoxOptions<TItem, TKey>, TItem, TKey> {}
  module dxBox {
    export type BoxDirection = 'col' | 'row';
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxBox<TItem, TKey>>;
    export type CrosswiseDistribution = 'center' | 'end' | 'start' | 'stretch';
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxBox<TItem, TKey>>;
    export type Distribution =
      | 'center'
      | 'end'
      | 'space-around'
      | 'space-between'
      | 'start';
    export type ExplicitTypes<TItem extends ItemLike<TKey>, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<dxBox<TItem, TKey>>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxBox<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxBox<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxBox<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike<TKey> = string | Item<TKey> | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxBox<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxBox<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = dxBoxOptions<TItem, TKey>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxBoxItem<TKey = any> extends CollectionWidgetItem {
    /**
     * Specifies the base size of an item element along the main direction.
     */
    baseSize?: number | string;
    /**
     * Holds a Box configuration object for the item.
     */
    box?: dxBoxOptions<any, TKey> | undefined;
    /**
     * Specifies the ratio value used to count the item element size along the main direction.
     */
    ratio?: number;
    /**
     * A factor that defines how much an item shrinks relative to the rest of the items in the container.
     */
    shrink?: number;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxBoxOptions<
    TItem extends DevExpress.ui.dxBox.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidgetOptions<dxBox<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies how UI component items are aligned along the main direction.
     */
    align?: DevExpress.ui.dxBox.Distribution;
    /**
     * Specifies how UI component items are aligned cross-wise.
     */
    crossAlign?: DevExpress.ui.dxBox.CrosswiseDistribution;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies the direction of item positioning in the UI component.
     */
    direction?: DevExpress.ui.dxBox.BoxDirection;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
  }
  /**
   * The Button UI component is a simple button that performs specified commands when a user clicks it.
   */
  export class dxButton extends Widget<dxButtonOptions> {}
  module dxButton {
    /**
     * The type of the click event handler&apos;s argument.
     */
    export type ClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxButton,
      KeyboardEvent | MouseEvent | PointerEvent
    > & {
      /**
       * 
       */
      validationGroup?: any;
    };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxButton>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxButton>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxButton>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxButton> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxButtonOptions;
    export type TemplateData = {
      readonly text?: string;
      readonly icon?: string;
    };
  }
  /**
   * The ButtonGroup is a UI component that contains a set of toggle buttons and can be used as a mode switcher.
   */
  export class dxButtonGroup extends Widget<dxButtonGroupOptions> {}
  module dxButtonGroup {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxButtonGroup>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxButtonGroup>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxButtonGroup>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxButtonGroup,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxButtonGroup> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxButtonGroupOptions;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxButtonGroup> &
        DevExpress.ui.CollectionWidget.SelectionChangeInfo;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxButtonGroupItem extends CollectionWidgetItem {
    /**
     * Specifies a text for the hint that appears when the button is hovered over or long-pressed.
     */
    hint?: string;
    /**
     * Specifies the icon to be displayed on the button.
     */
    icon?: string;
    /**
     * Specifies the button type.
     */
    type?: DevExpress.common.ButtonType | string;

    /**
     * Specifies the global attributes to be attached to the button group item&apos;s container element.
     */
    elementAttr?: { [key: string]: any };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxButtonGroupOptions extends WidgetOptions<dxButtonGroup> {
    /**
     * Specifies a template for all the buttons in the group.
     */
    buttonTemplate?:
      | template
      | ((
          buttonData: any,
          buttonContent: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * 
     */
    focusStateEnabled?: boolean;
    /**
     * 
     */
    hoverStateEnabled?: boolean;
    /**
     * Configures buttons in the group.
     */
    items?: Array<DevExpress.ui.dxButtonGroup.Item>;
    /**
     * Specifies which data field provides keys used to distinguish between the selected buttons.
     */
    keyExpr?: string | Function;
    /**
     * A function that is executed when a button is clicked or tapped.
     */
    onItemClick?: (e: DevExpress.ui.dxButtonGroup.ItemClickEvent) => void;
    /**
     * A function that is executed when a button is selected or selection is canceled.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxButtonGroup.SelectionChangedEvent
    ) => void;
    /**
     * Contains keys of selected buttons and allows you to specify initial button selection state.
     */
    selectedItemKeys?: Array<any>;
    /**
     * Contains the data objects that correspond to the selected buttons. The data objects are taken from the items array.
     */
    selectedItems?: Array<any>;
    /**
     * Specifies the button selection mode.
     */
    selectionMode?: DevExpress.common.SingleMultipleOrNone;
    /**
     * Specifies how buttons in the group are styled.
     */
    stylingMode?: DevExpress.common.ButtonStyle;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxButtonOptions extends WidgetOptions<dxButton> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the icon to be displayed on the button.
     */
    icon?: string;
    /**
     * A function that is executed when the Button is clicked or tapped.
     */
    onClick?: (e: DevExpress.ui.dxButton.ClickEvent) => void;
    /**
     * Specifies how the button is styled.
     */
    stylingMode?: DevExpress.common.ButtonStyle;
    /**
     * Specifies a custom template for the Button UI component.
     */
    template?:
      | template
      | ((
          data: DevExpress.ui.dxButton.TemplateData,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * The text displayed on the button.
     */
    text?: string;
    /**
     * Specifies the button type.
     */
    type?: DevExpress.common.ButtonType | string;
    /**
     * Specifies whether the button submits an HTML form.
     */
    useSubmitBehavior?: boolean;
    /**
     * Specifies the name of the validation group to be accessed in the click event handler.
     */
    validationGroup?: string | undefined;
  }
  /**
   * The Calendar is a UI component that displays a calendar and allows an end user to select the required date within a specified date range.
   */
  export class dxCalendar extends Editor<dxCalendarOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxCalendar.Properties['value']): void;
  }
  module dxCalendar {
    export type CalendarSelectionMode = 'single' | 'multiple' | 'range';
    export type CalendarZoomLevel = 'century' | 'decade' | 'month' | 'year';
    export type CellTemplateData = {
      readonly date?: Date;
      readonly view: string;
      readonly text?: string;
    };
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ComponentDisabledDate<T> {
      component: T;
      readonly date: Date;
      readonly view: string;
    }
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxCalendar>;
    /**
     * Specifies dates that users cannot select.
     */
    export type DisabledDate = ComponentDisabledDate<dxCalendar>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxCalendar>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxCalendar>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxCalendar> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxCalendarOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCalendar,
        DevExpress.events.InteractionEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
    export type WeekNumberRule =
      | 'auto'
      | 'firstDay'
      | 'fullWeek'
      | 'firstFourDays';
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxCalendarOptions extends EditorOptions<dxCalendar> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies a custom template for calendar cells.
     */
    cellTemplate?:
      | template
      | ((
          itemData: DevExpress.ui.dxCalendar.CellTemplateData,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the date-time value serialization format.
     */
    dateSerializationFormat?: string | undefined;
    /**
     * Specifies dates that users cannot select.
     */
    disabledDates?:
      | Array<Date>
      | ((data: DevExpress.ui.dxCalendar.DisabledDate) => boolean);
    /**
     * Specifies the first day of a week.
     */
    firstDayOfWeek?: DevExpress.common.FirstDayOfWeek | undefined;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * The latest date the UI component allows to select.
     */
    max?: DevExpress.common.DateLike;
    /**
     * Specifies the maximum zoom level of the calendar.
     */
    maxZoomLevel?: DevExpress.ui.dxCalendar.CalendarZoomLevel;
    /**
     * The earliest date the UI component allows to select.
     */
    min?: DevExpress.common.DateLike;
    /**
     * Specifies the minimum zoom level of the calendar.
     */
    minZoomLevel?: DevExpress.ui.dxCalendar.CalendarZoomLevel;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies one of three selection modes: single, multiple, or range.
     */
    selectionMode?: DevExpress.ui.dxCalendar.CalendarSelectionMode;
    /**
     * Specifies whether a user can select a week by clicking on a week number.
     */
    selectWeekOnClick?: boolean;
    /**
     * Specifies whether or not the UI component displays a button that selects the current date.
     */
    showTodayButton?: boolean;
    /**
     * Specifies whether to display a column with week numbers.
     */
    showWeekNumbers?: boolean;
    /**
     * The text displayed on the Today button.
     */
    todayButtonText?: string;
    /**
     * Specifies a week number calculation rule.
     */
    weekNumberRule?: DevExpress.ui.dxCalendar.WeekNumberRule;
    /**
     * An object or a value that specifies the date and time selected in the calendar.
     */
    value?: DevExpress.common.DateLike | DevExpress.common.DateLike[];
    /**
     * Specifies the current calendar zoom level.
     */
    zoomLevel?: DevExpress.ui.dxCalendar.CalendarZoomLevel;
  }
  /**
   * CardView is a UI component that uses a &apos;card&apos; layout to present information.
   */
  export class dxCardView<
    TCardData = unknown,
    TKey = unknown
  > extends Widget<DevExpress.ui.dxCardView.Properties> {
    /**
     * Gets the container of a card with a specific index.
     */
    getCardElement(cardIndex: number): DevExpress.core.DxElement;
    /**
     * Gets currently rendered cards.
     */
    getVisibleCards(): DevExpress.ui.dxCardView.CardInfo[];
    /**
     * Gets the index of a card with a specific key.
     */
    getCardIndexByKey(key: TKey): number;
    /**
     * Gets the key of a card with a specific index.
     */
    getKeyByCardIndex(cardIndex: number): TKey;
    /**
     * Gets the instance of the UI component&apos;s scrollable part.
     */
    getScrollable(): dxScrollable;
    /**
     * Displays the load panel.
     */
    beginCustomLoading(text?: string): void;
    /**
     * Hides the load panel.
     */
    endCustomLoading(): void;
    /**
     * Clears sorting settings of all columns.
     */
    clearSorting(): void;
    /**
     * Gets the total filter that combines all the filters applied.
     */
    getCombinedFilter(): any;
    /**
     * Clears all filters applied to UI component cards.
     */
    clearFilter(): void;
    /**
     * Hides the column chooser.
     */
    hideColumnChooser(): void;
    /**
     * Shows the column chooser.
     */
    showColumnChooser(): void;
    /**
     * Searches for a string in columns whose allowSearch property is `true`.
     */
    searchByText(text: string): void;

    /**
     * Adds an empty card and switches it to the editing state.
     */
    addCard(): void;
    /**
     * Discards changes that a user made to data.
     */
    cancelEditData(): void;
    /**
     * Removes a card with a specific index.
     */
    deleteCard(cardIndex: number): void;
    /**
     * Switches a card with a specific index to the editing state.
     */
    editCard(cardIndex: number): void;
    /**
     * Checks whether the UI component has unsaved changes.
     */
    hasEditData(): void;
    /**
     * Saves changes that a user made to data.
     */
    saveEditData(): void;

    /**
      * Gets a data object with a specific key.
      */
     byKey(key: TKey): TCardData;
    /**
     * Gets the DataSource instance.
     */
    getDataSource(): DevExpress.common.data.DataSource<TCardData, TKey>;
    /**
     * Gets a data item&apos;s key value.
     */
    keyOf(obj: TCardData): TKey;
    /**
     * Gets the total page count.
     */
    pageCount(): number;
    /**
     * Gets the current page index.
     */
    pageIndex(): number;
    /**
     * Switches the UI component to a specific page using a zero-based index.
     */
    pageIndex(value: number): void;
    /**
     * Gets the current page size.
     */
    pageSize(): number;
    /**
     * Sets the page size.
     */
    pageSize(value: number): void;
    /**
     * Gets the total card count.
     */
    totalCount(): number;

    /**
     * Selects cards with specific keys.
     */
    selectCards(keys: Array<TKey>, preserve: boolean): void;
    /**
     * Cancels the selection of cards with specific keys.
     */
    deselectCards(keys: Array<TKey>): void;
    /**
     * Selects all cards.
     */
    selectAll(): void;
    /**
     * Clears the selection of all cards on all pages or the currently rendered page only.
     */
    deselectAll(): void;
    /**
     * Clears selection of all cards on all pages.
     */
    clearSelection(): void;
    /**
     * Gets the selected cards&apos; data objects.
     */
    getSelectedCardsData(): Array<TCardData>;
    /**
     * Gets the selected card keys.
     */
    getSelectedCardKeys(): Array<TKey>;
    /**
     * Checks whether a card with a specific key is selected.
     */
    isCardSelected(key: TKey): boolean;
  }
  module dxCardView {
    /**
     * The argument type in the cardClick event.
     */
    export type CardClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxCardView,
      DevExpress.events.PointerInteractionEvent
    > &
      WithCardInfo;
    /**
     * The argument type in the cardDblClick event.
     */
    export type CardDblClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCardView,
        DevExpress.events.PointerInteractionEvent
      > &
        WithCardInfo;
    export type CardHeaderPredefinedItem =
      | 'selectionCheckBox'
      | 'updateButton'
      | 'deleteButton';
    /**
     * The argument type in the cardHoverChanged event.
     */
    export type CardHoverChangedEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> &
        WithCardInfo & {
          /**
           * Indicates whether the pointer entered or left the card. Can be either &apos;mouseover&apos; or &apos;mouseout&apos;.
           */
          eventType: string;
        };
    /**
     * The argument type in the cardInserted event.
     */
    export type CardInsertedEvent<TCardData = unknown> =
      DevExpress.common.core.events.EventInfo<dxCardView> & {
        /**
         * The data of the card.
         */
        data: DevExpress.core.DeepPartial<TCardData>;
      };
    /**
     * The argument type in the cardInserting event.
     */
    export type CardInsertingEvent<TCardData = unknown> =
      DevExpress.common.core.events.EventInfo<dxCardView> &
        DevExpress.common.core.events.Cancelable & {
          /**
           * The data of the card.
           */
          data: DevExpress.core.DeepPartial<TCardData>;
        };
    /**
     * The argument type in the cardPrepared event.
     */
    export type CardPreparedEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> & WithCardInfo;
    /**
     * The argument type in the cardRemoved event.
     */
    export type CardRemovedEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> & {
      /**
       * The data of the card.
       */
      data: TCardData;
      /**
       * The card&apos;s key.
       */
      key: TKey;
    };
    /**
     * The argument type in the cardRemoving event.
     */
    export type CardRemovingEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> &
      DevExpress.common.core.events.Cancelable & {
        /**
         * The data of the card.
         */
        data: TCardData;
        /**
         * The card&apos;s key.
         */
        key: TKey;
      };
    /**
     * Specifies card template data.
     */
    export type CardTemplateData = {
      card: CardInfo;
    };
    /**
     * The argument type in the cardUpdated event.
     */
    export type CardUpdatedEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> & {
      /**
       * The updated data of the card.
       */
      data: TCardData;
      /**
       * The card&apos;s key.
       */
      key: TKey;
    };
    /**
     * The argument type in the cardUpdating event.
     */
    export type CardUpdatingEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> &
      DevExpress.common.core.events.Cancelable & {
        /**
         * The card&apos;s key.
         */
        key: TKey;
        /**
         * The card&apos;s old data.
         */
        oldData: TCardData;
        /**
         * The card&apos;s updated data.
         */
        newData: DevExpress.core.DeepPartial<TCardData>;
      };
    /**
     * The data of column template.
     */
    export type ColumnTemplateData<TCardData = unknown, TKey = unknown> = {
      column: Column<TCardData, TKey>;
    };
    /**
     * The argument type in the contextMenuPreparing event.
     */
    export type ContextMenuPreparingEvent<TCardData = unknown> =
      DevExpress.common.core.events.EventInfo<dxCardView> & {
        /**
         * Items to be displayed in the context menu.
         */
        items?: any[];
        /**
         * The name of the element on which the context menu is invoked: &apos;headerPanel&apos;, &apos;content&apos;, or &apos;toolbar&apos;.
         */
        readonly target: ContextMenuTarget;
        /**
         * The target element&apos;s container.
         */
        readonly targetElement: DevExpress.core.DxElement;
        /**
         * The index of the column on which the context menu is invoked.
         */
        readonly columnIndex?: number;
        /**
         * The column&apos;s configuration.
         */
        readonly column?: Column;
        /**
         * The index of the card on which the context menu is invoked.
         */
        readonly cardIndex?: number;
        /**
         * The card properties.
         */
        readonly card?: TCardData;
      };

    export type ContextMenuTarget = 'toolbar' | 'headerPanel' | 'content';
    /**
     * The argument type in the editCanceled event.
     */
    export type EditCanceledEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> & {
        /**
         * Discarded card changes.
         */
        changes: DevExpress.common.grids.DataChange[];
      };
    /**
     * The argument type in the editCanceling event.
     */
    export type EditCancelingEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> &
        DevExpress.common.core.events.Cancelable & {
          /**
           * Card changes to be discarded.
           */
          changes: DevExpress.common.grids.DataChange[];
        };
    /**
     * Configures editing.
     */
    export type Editing<TCardData = unknown, TKey = unknown> = {
      /**
       * Specifies whether a user can add new cards.
       */
      allowAdding?: boolean;
      /**
       * Specifies whether a user can delete cards.
       */
      allowDeleting?: boolean;
      /**
       * Specifies whether a user can update cards.
       */
      allowUpdating?: boolean;
      /**
       * An array of pending row changes.
       */
      changes?: DevExpress.common.grids.DataChange<TCardData, TKey>[];
      /**
       * Specifies if confirmation is required when a user deletes a row.
       */
      confirmDelete?: boolean;
      /**
       * The key(s) of a card being edited.
       */
      editCardKey?: TKey | null;
      /**
       * Configures the form inside the editing popup.
       */
      form?: DevExpress.ui.dxForm.Properties;
      /**
       * Configures the editing popup.
       */
      popup?: DevExpress.ui.dxPopup.Properties;
      /**
       * 
       */
      texts?: EditingTexts;
    };
    /**
     * The argument type in the editingStart event.
     */
    export type EditingStartEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> &
      DevExpress.common.core.events.Cancelable & {
        /**
         * The data of a card to be edited.
         */
        data: TCardData;
        /**
         * The card&apos;s key.
         */
        key: TKey;
      };
    export type ExplicitTypes<TCardData = unknown, TKey = unknown> = {
      Properties: Properties<TCardData, TKey>;
    };
    /**
     * The argument type in the fieldCaptionClick event.
     */
    export type FieldCaptionClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCardView,
        DevExpress.events.PointerInteractionEvent
      > &
        WithFieldCaptionInfo;
    /**
     * The argument type in the fieldCaptionDblClick event.
     */
    export type FieldCaptionDblClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCardView,
        DevExpress.events.PointerInteractionEvent
      > &
        WithFieldCaptionInfo;
    /**
     * The argument type in the fieldCaptionPrepared event.
     */
    export type FieldCaptionPreparedEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> &
        WithFieldCaptionInfo;
    /**
     * Specifies a custom template for the field.
     */
    export type FieldTemplateData = {
      /**
       * Information about the field.
       */
      field: FieldInfo;
    };
    /**
     * The argument type in the fieldValueClick event.
     */
    export type FieldValueClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCardView,
        DevExpress.events.PointerInteractionEvent
      > &
        WithFieldValueInfo;
    /**
     * The argument type in the fieldValueDblClick event.
     */
    export type FieldValueDblClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCardView,
        DevExpress.events.PointerInteractionEvent
      > &
        WithFieldValueInfo;
    /**
     * The argument type in the fieldValuePrepared event.
     */
    export type FieldValuePreparedEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> & WithFieldValueInfo;

    /**
     * The argument type in the focusedCardChanged event.
     */
    export type FocusedCardChanged =
      DevExpress.common.core.events.EventInfo<dxCardView> & WithCardInfo;
    /**
     * The argument type in the initNewCard event.
     */
    export type InitNewCardEvent<TCardData = unknown> =
      DevExpress.common.core.events.EventInfo<dxCardView> & {
        /**
         * The data of the inserted card; initially empty.
         */
        data: DevExpress.core.DeepPartial<TCardData>;
        /**
         * Assign a Promise to this field to perform an asynchronous operation, such as a request to the server.
         */
        promise?: PromiseLike<void>;
      };
    /**
     * The argument type in the optionChanged event.
     */
    export type OptionChangedEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView<TCardData, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;

    export type PredefinedToolbarItem =
      | 'columnChooserButton'
      | 'searchPanel'
      | 'addCardButton'
      | 'selectAllButton'
      | 'clearSelectionButton';
    export type Properties<
      TCardData = unknown,
      TKey = unknown
    > = dxCardViewOptions<TCardData, TKey>;
    /**
     * The argument type in the saved event.
     */
    export type SavedEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> & {
        /**
         * All card data (including changes). Differs from onSaving, which only consists of pending changes.
         */
        changes: DevExpress.common.grids.DataChange[];
      };
    /**
     * The argument type in the saving event.
     */
    export type SavingEvent =
      DevExpress.common.core.events.EventInfo<dxCardView> &
        DevExpress.common.core.events.Cancelable & {
          /**
           * Assign a Promise to this field to perform an asynchronous operation, such as a request to a server.
           */
          promise?: PromiseLike<void>;
          /**
           * Pending row changes; a copy of the editing.changes array. Includes only card changes, unlike onSaved, which contains all card data (including changes).
           */
          changes: DevExpress.common.grids.DataChange[];
        };
    /**
     * The argument type in the selectionChanged event.
     */
    export type SelectionChangedEvent<
      TCardData = unknown,
      TKey = unknown
    > = DevExpress.common.core.events.EventInfo<dxCardView> & {
      /**
       * The data of all selected cards.
       */
      selectedCardsData: Array<TCardData>;
      /**
       * The keys of all selected cards.
       */
      selectedCardKeys: Array<TKey>;
      /**
       * The keys of the cards that were selected.
       */
      currentSelectedCardKeys: Array<TKey>;
      /**
       * The keys of the cards whose selection was cleared.
       */
      currentDeselectedCardKeys: Array<TKey>;
    };

    /**
     * Configures runtime selection.
     */
    export type SelectionConfiguration = {
      /**
       * Allows users to simultaneously select all or current page cards (depending on selectAllMode).
       */
      allowSelectAll?: boolean;
      /**
       * Specifies the selection mode.
       */
      mode?: DevExpress.common.SingleMultipleOrNone;
      /**
       * Specifies the mode for selecting cards. Applies only if selection.allowSelectAll is `true`.
       */
      selectAllMode?: DevExpress.common.SelectAllMode;
      /**
       * Specifies when to display card selection checkboxes.
       */
      showCheckBoxesMode?: DevExpress.common.grids.SelectionColumnDisplayMode;
    };

    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type WithCardInfo = {
      /**
       * 
       */
      readonly card: CardInfo;
      /**
       * 
       */
      readonly cardElement: DevExpress.core.DxElement;
    };
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type WithFieldCaptionInfo = {
      /**
       * 
       */
      readonly field: FieldInfo;
      /**
       * 
       */
      readonly fieldCaptionElement: DevExpress.core.DxElement;
    };
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type WithFieldValueInfo = {
      /**
       * 
       */
      readonly field: FieldInfo;
      /**
       * 
       */
      readonly fieldValueElement: DevExpress.core.DxElement;
    };
  }
  /**
   * @deprecated Use DevExpress.ui.dxCardView.Editing instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxCardViewEditing<
    TCardData = unknown,
    TKey = unknown
  > = DevExpress.ui.dxCardView.Editing<TCardData, TKey>;

  /**
   * @deprecated Use DevExpress.ui.dxCardView.FieldInfo instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxCardViewFieldInfo = DevExpress.ui.dxCardView.FieldInfo;

  /**
   * 
   * @deprecated 
   */
  export interface dxCardViewOptions<TCardData = unknown, TKey = unknown>
    extends Omit<WidgetOptions<dxCardView>, 'onOptionChanged'> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TCardData, TKey>;
    /**
     * Configures paging.
     */
    paging?: DevExpress.ui.dxCardView.Paging;
    /**
     * Specifies the key property (or properties) that supply key values to access data items. Each key value must be unique. This property applies only if data is a simple array.
     */
    keyExpr?: string | string[];
    /**
     * Notifies CardView of the server&apos;s data processing operations.
     */
    remoteOperations?:
      | DevExpress.ui.dxCardView.RemoteOperations
      | boolean
      | DevExpress.common.Mode;
    /**
     * A function that is executed when an error occurs in the data source.
     */
    onDataErrorOccurred?: (
      e: DevExpress.common.core.events.EventInfo<dxCardView> &
        DevExpress.common.grids.DataErrorOccurredInfo
    ) => void;

    /**
     * Configures the pager.
     */
    pager?: DevExpress.common.grids.Pager;

    /**
     * An array of CardView columns.
     */
    columns?: (
      | DevExpress.ui.dxCardView.ColumnProperties<TCardData, TKey>
      | string
    )[];

    /**
     * Specifies whether a user can reorder columns.
     */
    allowColumnReordering?: boolean;

    /**
     * Configures the header panel.
     */
    headerPanel?: DevExpress.ui.dxCardView.HeaderPanel<TCardData, TKey>;

    /**
     * Configures scrolling.
     */
    scrolling?: {
      /**
       * Specifies whether a user can scroll the content with a swipe gesture. Applies only if useNative is `false`.
       */
      scrollByContent?: boolean;
      /**
       * Specifies whether a user can scroll the content with the scrollbar. Applies only if useNative is `false`.
       */
      scrollByThumb?: boolean;
      /**
       * Specifies when to display scroll bars. Applies only if useNative is `false`.
       */
      showScrollbar?: DevExpress.common.ScrollbarMode;
      /**
       * Specifies whether CardView should use native or simulated scrolling.
       */
      useNative?: boolean | DevExpress.common.Mode;
    };
    /**
     * Indicates whether to show the error row.
     */
    errorRowEnabled?: boolean;
    /**
     * Configures the load panel.
     */
    loadPanel?: dxLoadPanelOptions;
    /**
     * Specifies a text string to display when no data appears in CardView.
     */
    noDataText?: string;
    /**
     * Specifies a custom template to be displayed when no data appears in CardView.
     */
    noDataTemplate?:
      | template
      | ((
          e: { text: string },
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the number of cards per row.
     */
    cardsPerRow?: number | DevExpress.common.Mode;
    /**
     * Specifies the minimum width of the card.
     */
    cardMinWidth?: number;
    /**
     * Specifies the maximum width of the card.
     */
    cardMaxWidth?: number;
    /**
     * Specifies whether text that does not fit into a field should be wrapped.
     */
    wordWrapEnabled?: boolean;
    /**
     * Configures the card cover.
     */
    cardCover?: DevExpress.ui.dxCardView.CardCover<TCardData>;
    /**
     * Specifies a custom template for the card.
     */
    cardTemplate?:
      | template
      | ((
          data: DevExpress.ui.dxCardView.CardTemplateData,
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies a custom template for card content.
     */
    cardContentTemplate?:
      | template
      | ((
          data: DevExpress.ui.dxCardView.CardTemplateData,
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Displays a hint when the mouse hovers over truncated field content.
     */
    fieldHintEnabled?: boolean;
    /**
     * A function that is executed when a card is clicked or tapped.
     */
    onCardClick?: (e: DevExpress.ui.dxCardView.CardClickEvent) => void;
    /**
     * A function that is executed when a card is double-clicked or double-tapped.
     */
    onCardDblClick?: (e: DevExpress.ui.dxCardView.CardDblClickEvent) => void;
    /**
     * A function that is executed after a card is created.
     */
    onCardPrepared?: (e: DevExpress.ui.dxCardView.CardPreparedEvent) => void;
    /**
     * A function that is executed when a field caption is clicked or tapped.
     */
    onFieldCaptionClick?: (
      e: DevExpress.ui.dxCardView.FieldCaptionClickEvent
    ) => void;
    /**
     * A function that is executed when a field caption is double-clicked or double-tapped.
     */
    onFieldCaptionDblClick?: (
      e: DevExpress.ui.dxCardView.FieldCaptionDblClickEvent
    ) => void;
    /**
     * A function that is executed after a field caption is created.
     */
    onFieldCaptionPrepared?: (
      e: DevExpress.ui.dxCardView.FieldCaptionPreparedEvent
    ) => void;
    /**
     * A function that is executed when a field value is clicked or tapped.
     */
    onFieldValueClick?: (
      e: DevExpress.ui.dxCardView.FieldValueClickEvent
    ) => void;
    /**
     * A function that is executed when a field value is double-clicked or double-tapped.
     */
    onFieldValueDblClick?: (
      e: DevExpress.ui.dxCardView.FieldValueDblClickEvent
    ) => void;
    /**
     * A function that is executed after a field value is created.
     */
    onFieldValuePrepared?: (
      e: DevExpress.ui.dxCardView.FieldValuePreparedEvent
    ) => void;
    /**
     * A function that is executed after the pointer enters or leaves a card.
     */
    onCardHoverChanged?: (
      e: DevExpress.ui.dxCardView.CardHoverChangedEvent
    ) => void;
    /**
     * Specifies a custom template for a card footer.
     */
    cardFooterTemplate?:
      | template
      | ((
          data: DevExpress.ui.dxCardView.CardTemplateData,
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Configures the card header.
     */
    cardHeader?: DevExpress.ui.dxCardView.CardHeader;

    /**
     * Specifies whether the UI component changes its appearance when a user hovers over it.
     */
    hoverStateEnabled?: boolean;

    /**
     * Configures the toolbar.
     */
    toolbar?: DevExpress.ui.dxCardView.Toolbar;

    /**
     * Configures sorting.
     */
    sorting?: DevExpress.common.grids.Sorting;

    /**
     * Specifies a filter expression.
     */
    filterValue?: string | Array<any> | Function;
    /**
     * Configures the integrated filter builder popup.
     */
    filterBuilderPopup?: DevExpress.ui.dxPopup.Properties;
    /**
     * Configures the filter builder.
     */
    filterBuilder?: dxFilterBuilderOptions;
    /**
     * Configures the filter panel.
     */
    filterPanel?: DevExpress.common.grids.FilterPanel<dxCardView>;
    /**
     * Configures the column chooser.
     */
    columnChooser?: DevExpress.common.grids.ColumnChooser;
    /**
     * Configures the search panel.
     */
    searchPanel?: DevExpress.common.grids.SearchPanel;
    /**
     * Configures the header filter.
     */
    headerFilter?: DevExpress.common.grids.HeaderFilter;

    /**
     * Configures editing.
     */
    editing?: DevExpress.ui.dxCardView.Editing<TCardData, TKey>;
    /**
     * A function that is executed after card changes are discarded.
     */
    onEditCanceled?: (e: DevExpress.ui.dxCardView.EditCanceledEvent) => void;
    /**
     * A function that is executed when the edit operation is canceled, but card changes are not yet discarded.
     */
    onEditCanceling?: (e: DevExpress.ui.dxCardView.EditCancelingEvent) => void;
    /**
     * A function that is executed before a card switches to the editing state.
     */
    onEditingStart?: (e: DevExpress.ui.dxCardView.EditingStartEvent) => void;
    /**
     * A function that is executed before a new card is added to the UI component.
     */
    onInitNewCard?: (
      e: DevExpress.ui.dxCardView.InitNewCardEvent<TCardData>
    ) => void;
    /**
     * A function that is executed after a new card is inserted into the data source.
     */
    onCardInserted?: (e: DevExpress.ui.dxCardView.CardInsertedEvent) => void;
    /**
     * A function that is executed before a new card is inserted into the data source.
     */
    onCardInserting?: (e: DevExpress.ui.dxCardView.CardInsertingEvent) => void;
    /**
     * A function that is executed after a card was removed from the data source.
     */
    onCardRemoved?: (e: DevExpress.ui.dxCardView.CardRemovedEvent) => void;
    /**
     * A function that is executed before a card is removed from the data source.
     */
    onCardRemoving?: (e: DevExpress.ui.dxCardView.CardRemovingEvent) => void;
    /**
     * A function that is executed after a card is updated in the data source.
     */
    onCardUpdated?: (e: DevExpress.ui.dxCardView.CardUpdatedEvent) => void;
    /**
     * A function that is executed before a card is updated in the data source.
     */
    onCardUpdating?: (e: DevExpress.ui.dxCardView.CardUpdatingEvent) => void;
    /**
     * A function that is executed after a widget property is changed.
     */
    onOptionChanged?: (e: DevExpress.ui.dxCardView.OptionChangedEvent) => void;
    /**
     * A function that is executed after card changes are saved.
     */
    onSaved?: (e: DevExpress.ui.dxCardView.SavedEvent) => void;
    /**
     * A function that is executed before pending card changes are saved.
     */
    onSaving?: (e: DevExpress.ui.dxCardView.SavingEvent) => void;

    /**
     * Allows you to select cards or determine which cards are selected.
     */
    selectedCardKeys?: Array<TKey>;
    /**
     * Configures runtime selection.
     */
    selection?: DevExpress.ui.dxCardView.SelectionConfiguration;
    /**
     * A function that is executed when a card is selected or its selection is cleared.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxCardView.SelectionChangedEvent
    ) => void;

    /**
     * A function that is executed after the focused card changes.
     */
    onFocusedCardChanged?: (
      e: DevExpress.ui.dxCardView.FocusedCardChanged
    ) => void;

    /**
     * A function that is executed before the context menu is rendered.
     */
    onContextMenuPreparing?: (
      e: DevExpress.ui.dxCardView.ContextMenuPreparingEvent<TCardData>
    ) => void;
  }
  /**
   * @deprecated Use DevExpress.ui.dxCardView.Toolbar instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxCardViewToolbar = DevExpress.ui.dxCardView.Toolbar;
  /**
   * @deprecated Use DevExpress.ui.dxCardView.ToolbarItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxCardViewToolbarItem = DevExpress.ui.dxCardView.ToolbarItem;
  /**
   * The Chat UI component is an interactive interface that allows users to send and receive messages in real time.
   */
  export class dxChat extends Widget<DevExpress.ui.dxChat.Properties> {
    /**
     * Renders a new message.
     */
    renderMessage(message: DevExpress.ui.dxChat.Message): void;

    getDataSource(): DevExpress.common.data.DataSource<DevExpress.ui.dxChat.Message>;
  }
  module dxChat {
    /**
     * The argument type in the attachmentDownloadClick event.
     */
    export type AttachmentDownloadClickEvent =
      DevExpress.common.core.events.EventInfo<dxChat> & {
        /**
         * Attachments that are selected for download (single attachment if fileUploaderOptions.multiple is set to `false`).
         */
        readonly attachment?: Attachment;
      };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxChat>;
    export type EmptyViewTemplateData = {
      readonly component: dxChat;
      readonly texts: {
        readonly message: string;
        readonly prompt: string;
      };
    };
    export type ExplicitTypes = {
      Properties: Properties;
      DisposingEvent: DisposingEvent;
      InitializedEvent: InitializedEvent;
      OptionChangedEvent: OptionChangedEvent;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxChat>;
    /**
     * The argument type in the messageDeleted event.
     */
    export type MessageDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxChat> & {
        /**
         * The message that was deleted.
         */
        readonly message: Message;
      };
    /**
     * The argument type in the messageDeleting event.
     */
    export type MessageDeletingEvent =
      DevExpress.common.core.events.AsyncCancelable &
        DevExpress.common.core.events.EventInfo<dxChat> & {
          /**
           * The message that is being deleted.
           */
          readonly message: Message;
        };
    /**
     * The argument type in the messageEditCanceled event.
     */
    export type MessageEditCanceledEvent =
      DevExpress.common.core.events.EventInfo<dxChat> & {
        /**
         * The message which editing was canceled.
         */
        readonly message: Message;
      };
    /**
     * The argument type in the messageEditingStart event.
     */
    export type MessageEditingStartEvent =
      DevExpress.common.core.events.AsyncCancelable &
        DevExpress.common.core.events.EventInfo<dxChat> & {
          /**
           * The message which editing started.
           */
          readonly message: Message;
        };
    /**
     * The argument type in the messageEntered event.
     */
    export type MessageEnteredEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxChat,
        DevExpress.events.InteractionEvent
      > & {
        /**
         * The message that was entered into the chat.
         */
        readonly message: Message;
      };
    export type MessageTemplateData = {
      readonly component: dxChat;
      readonly message?: Message;
    };
    /**
     * The argument type in the messageUpdated event.
     */
    export type MessageUpdatedEvent =
      DevExpress.common.core.events.EventInfo<dxChat> & {
        /**
         * The message that was updated.
         */
        readonly message: Message;
        /**
         * The updated text from the input field.
         */
        readonly text: string;
      };
    /**
     * The argument type in the messageUpdating event.
     */
    export type MessageUpdatingEvent =
      DevExpress.common.core.events.AsyncCancelable &
        DevExpress.common.core.events.EventInfo<dxChat> & {
          /**
           * The message to be updated.
           */
          readonly message: Message;
          /**
           * The updated text from the input field.
           */
          readonly text: string;
        };
    /**
     * The argument type in the optionChanged event.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxChat> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxChatOptions;
    /**
     * The argument type in the typingEnd event.
     */
    export type TypingEndEvent =
      DevExpress.common.core.events.EventInfo<dxChat> & {
        /**
         * The user who stopped typing.
         */
        readonly user: User;
      };
    /**
     * The argument type in the typingStart.
     */
    export type TypingStartEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxChat,
        UIEvent & { target: HTMLInputElement }
      > & {
        /**
         * The user who started typing.
         */
        readonly user?: User;
      };
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxChatOptions extends WidgetOptions<dxChat> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Configures file upload options.
     */
    fileUploaderOptions?: Omit<
      DevExpress.ui.dxFileUploader.Properties,
      'dialogTrigger' | 'showFileList' | 'uploadMode' | 'value'
    >;
    /**
     * Specifies whether the Chat&apos;s input element can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the current chat user (messages displayed on the right side).
     */
    user?: DevExpress.ui.dxChat.User;
    /**
     * Specifies an array of chat messages.
     */
    items?: Array<DevExpress.ui.dxChat.Message>;
    /**
     * Configures editing.
     */
    editing?: {
      /**
       * Specifies whether a user can update messages. Called for each message when defined as a function.
       */
      allowUpdating?:
        | boolean
        | ((options: {
            component?: dxChat;
            message?: DevExpress.ui.dxChat.Message;
          }) => boolean);
      /**
       * Specifies whether a user can delete messages. Called for each message when defined as a function.
       */
      allowDeleting?:
        | boolean
        | ((options: {
            component?: dxChat;
            message?: DevExpress.ui.dxChat.Message;
          }) => boolean);
    };
    /**
     * Specifies a custom template for the Chat message container when the component displays no messages.
     */
    emptyViewTemplate?:
      | template
      | null
      | ((
          data: DevExpress.ui.dxChat.EmptyViewTemplateData,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<DevExpress.ui.dxChat.Message> | null;
    /**
     * Specifies the day header format.
     */
    dayHeaderFormat?: DevExpress.common.core.localization.Format;
    /**
     * Specifies whether the Chat UI component displays newly entered messages immediately. This property only applies if dataSource is used.
     */
    reloadOnChange?: boolean;
    /**
     * A list of available alerts.
     */
    alerts?: Array<DevExpress.ui.dxChat.Alert>;
    /**
     * Specifies a custom template for a chat message.
     */
    messageTemplate?:
      | template
      | null
      | ((
          data: DevExpress.ui.dxChat.MessageTemplateData,
          messageBubbleElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the message timestamp format.
     */
    messageTimestampFormat?: DevExpress.common.core.localization.Format;
    /**
     * An array of users who are currently typing.
     */
    typingUsers?: Array<DevExpress.ui.dxChat.User>;
    /**
     * Specifies whether to show day headers.
     */
    showDayHeaders?: boolean;
    /**
     * Specifies whether to show user names.
     */
    showUserName?: boolean;
    /**
     * Specifies whether to show avatars.
     */
    showAvatar?: boolean;
    /**
     * Specifies whether to show message time stamps.
     */
    showMessageTimestamp?: boolean;
    /**
     * A function that is executed after a user clicks the &apos;Download&apos; button.
     */
    onAttachmentDownloadClick?:
      | ((e: DevExpress.ui.dxChat.AttachmentDownloadClickEvent) => void)
      | undefined;
    /**
     * A function that is executed after a message is entered into the chat.
     */
    onMessageEntered?:
      | ((e: DevExpress.ui.dxChat.MessageEnteredEvent) => void)
      | undefined;
    /**
     * A function that is called after a user starts typing.
     */
    onTypingStart?:
      | ((e: DevExpress.ui.dxChat.TypingStartEvent) => void)
      | undefined;
    /**
     * A function that is called 2 seconds after a user stops typing or after a message is entered.
     */
    onTypingEnd?:
      | ((e: DevExpress.ui.dxChat.TypingEndEvent) => void)
      | undefined;
    /**
     * A function that is executed before a message is removed from the UI.
     */
    onMessageDeleting?:
      | ((e: DevExpress.ui.dxChat.MessageDeletingEvent) => void)
      | undefined;
    /**
     * A function that is executed after a message was removed from the UI.
     */
    onMessageDeleted?:
      | ((e: DevExpress.ui.dxChat.MessageDeletedEvent) => void)
      | undefined;
    /**
     * A function that is executed before a message switches to the editing state.
     */
    onMessageEditingStart?:
      | ((e: DevExpress.ui.dxChat.MessageEditingStartEvent) => void)
      | undefined;
    /**
     * A function that is executed after message changes are discarded.
     */
    onMessageEditCanceled?:
      | ((e: DevExpress.ui.dxChat.MessageEditCanceledEvent) => void)
      | undefined;
    /**
     * A function that is executed before a message is edited in the UI.
     */
    onMessageUpdating?:
      | ((e: DevExpress.ui.dxChat.MessageUpdatingEvent) => void)
      | undefined;
    /**
     * A function that is executed after a message was edited in the UI.
     */
    onMessageUpdated?:
      | ((e: DevExpress.ui.dxChat.MessageUpdatedEvent) => void)
      | undefined;
  }
  /**
   * The CheckBox is a small box, which when selected by the end user, shows that a particular feature has been enabled or a specific property has been chosen.
   */
  export class dxCheckBox extends Editor<dxCheckBoxOptions> {
    /**
     * Removes focus from the check box.
     */
    blur(): void;
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxCheckBox.Properties['value']): void;
  }
  module dxCheckBox {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxCheckBox>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxCheckBox>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxCheckBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxCheckBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxCheckBoxOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxCheckBox,
        DevExpress.events.InteractionEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxCheckBoxOptions extends EditorOptions<dxCheckBox> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether users can set the CheckBox state to indeterminate.
     */
    enableThreeStateBehavior?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the check box icon&apos;s width and height.
     */
    iconSize?: number | string | undefined;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies the text displayed by the check box.
     */
    text?: string;
    /**
     * Specifies the UI component state.
     */
    value?: boolean | null | undefined;
  }
  /**
   * The ColorBox is a UI component that allows an end user to enter a color or pick it out from the drop-down editor.
   */
  export class dxColorBox extends dxDropDownEditor<dxColorBoxOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxColorBox.Properties['value']): void;
  }
  module dxColorBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxColorBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxColorBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxColorBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxColorBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxColorBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxColorBox,
      ClipboardEvent
    >;
    export type Properties = dxColorBoxOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxColorBox,
        KeyboardEvent | MouseEvent | PointerEvent | UIEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxColorBoxOptions
    extends dxDropDownEditorOptions<dxColorBox> {
    /**
     * Specifies the text displayed on the button that applies changes and closes the drop-down editor.
     */
    applyButtonText?: string;
    /**
     * Specifies the way an end user applies the selected value.
     */
    applyValueMode?: DevExpress.common.ApplyValueMode;
    /**
     * Specifies the text displayed on the button that cancels changes and closes the drop-down editor.
     */
    cancelButtonText?: string;
    /**
     * Specifies whether or not the UI component value includes the alpha channel component.
     */
    editAlphaChannel?: boolean;
    /**
     * Specifies a custom template for the input field. Must contain the TextBox UI component.
     * @deprecated Use the fieldAddons option instead.
     */
    fieldTemplate?:
      | template
      | ((
          value: string,
          fieldElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the size of a step by which a handle is moved using a keyboard shortcut.
     */
    keyStep?: number;
    /**
     * Specifies the currently selected value.
     */
    value?: string | null;
    /**
     * Configures the drop-down field which holds the content.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
  }
  /**
   * The ContextMenu UI component displays a single- or multi-level context menu. An end user invokes this menu by a right click or a long press.
   */
  export class dxContextMenu<
    TItem extends DevExpress.ui.dxContextMenu.ItemLike = any,
    TKey = any
  > extends dxMenuBase<dxContextMenuOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Hides the UI component.
     */
    hide(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows the UI component.
     */
    show(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows or hides the UI component depending on the argument.
     */
    toggle(showing: boolean): DevExpress.core.utils.DxPromise<void>;
  }
  module dxContextMenu {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
    export type ContextSubmenuDirection = 'auto' | 'left' | 'right';
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike = any, TKey = any> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      HiddenEvent: HiddenEvent<TItem, TKey>;
      HidingEvent: HidingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      PositioningEvent: PositioningEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
      ShowingEvent: ShowingEvent<TItem, TKey>;
      ShownEvent: ShownEvent<TItem, TKey>;
    };
    /**
     * The type of the hidden event handler&apos;s argument.
     */
    export type HiddenEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
    /**
     * The type of the hiding event handler&apos;s argument.
     */
    export type HidingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxContextMenu<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxContextMenu<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxContextMenu<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the positioning event handler&apos;s argument.
     */
    export type PositioningEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxContextMenu<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > & {
      /**
       * 
       */
      readonly position: DevExpress.common.core.animation.PositionConfig;
    };
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxContextMenuOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    /**
     * The type of the showing event handler&apos;s argument.
     */
    export type ShowingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
    /**
     * The type of the shown event handler&apos;s argument.
     */
    export type ShownEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxContextMenu<TItem, TKey>>;
  }
  /**
   * @deprecated Use DevExpress.ui.dxContextMenu.Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxContextMenuItem extends dxMenuBaseItem {
    /**
     * Specifies nested menu items.
     */
    items?: Array<DevExpress.ui.dxContextMenu.Item>;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxContextMenuOptions<
    TItem extends DevExpress.ui.dxContextMenu.ItemLike = any,
    TKey = any
  > extends dxMenuBaseOptions<dxContextMenu<TItem, TKey>, TItem, TKey> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether to hide the UI component if a user clicks outside it.
     */
    hideOnOutsideClick?:
      | boolean
      | ((
          event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>
        ) => boolean);
    /**
     * Holds an array of menu items.
     */
    items?: Array<TItem>;
    /**
     * A function that is executed after the ContextMenu is hidden.
     */
    onHidden?: (
      e: DevExpress.ui.dxContextMenu.HiddenEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before the ContextMenu is hidden.
     */
    onHiding?: (
      e: DevExpress.ui.dxContextMenu.HidingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before the ContextMenu is positioned.
     */
    onPositioning?: (
      e: DevExpress.ui.dxContextMenu.PositioningEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before the ContextMenu is shown.
     */
    onShowing?: (
      e: DevExpress.ui.dxContextMenu.ShowingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed after the ContextMenu is shown.
     */
    onShown?: (e: DevExpress.ui.dxContextMenu.ShownEvent<TItem, TKey>) => void;
    /**
     * An object defining UI component positioning properties.
     */
    position?: DevExpress.common.core.animation.PositionConfig;
    /**
     * Specifies properties used to display the UI component.
     */
    showEvent?:
      | {
          /**
           * The delay in milliseconds after which the UI component is displayed.
           */
          delay?: number | undefined;
          /**
           * Specifies the event names on which the UI component is shown.
           */
          name?: string | undefined;
        }
      | string;
    /**
     * Specifies the direction at which submenus are displayed.
     */
    submenuDirection?: DevExpress.ui.dxContextMenu.ContextSubmenuDirection;
    /**
     * The target element associated with the context menu.
     */
    target?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * A Boolean value specifying whether or not the UI component is visible.
     */
    visible?: boolean;
  }
  /**
   * The DataGrid is a UI component that represents data from a local or remote source in the form of a grid. This UI component offers such basic features as sorting, grouping, filtering, as well as more advanced capabilities, like state storing, client-side exporting, master-detail interface, and many others.
   */
  export class dxDataGrid<TRowData = any, TKey = any>
    extends Widget<dxDataGridOptions<TRowData, TKey>>
    implements DevExpress.common.grids.GridBase<TRowData, TKey>
  {
    /**
     * Adds a new column.
     */
    addColumn(
      columnOptions: DevExpress.ui.dxDataGrid.Column<TRowData, TKey> | string
    ): void;
    /**
     * Adds an empty data row and switches it to the editing state.
     */
    addRow(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Ungroups grid records.
     */
    clearGrouping(): void;
    /**
     * Collapses master rows or groups of a specific level.
     */
    collapseAll(groupIndex?: number): void;
    /**
     * Collapses a group or a master row with a specific key.
     */
    collapseRow(key: TKey): DevExpress.core.utils.DxPromise<void>;
    /**
     * Expands master rows or groups of a specific level. Does not apply if data is remote.
     */
    expandAll(groupIndex?: number): void;
    /**
     * Expands a group or a master row with a specific key.
     */
    expandRow(key: TKey): DevExpress.core.utils.DxPromise<void>;
    /**
     * Gets the currently selected rows&apos; keys.
     */
    getSelectedRowKeys(): Array<TKey> &
      DevExpress.core.utils.DxPromise<Array<TKey>>;
    /**
     * Gets the selected rows&apos; data objects.
     */
    getSelectedRowsData(): Array<TRowData> &
      DevExpress.core.utils.DxPromise<Array<TRowData>>;
    /**
     * Gets the value of a total summary item.
     */
    getTotalSummaryValue(summaryItemName: string): any;
    /**
     * Gets all visible columns.
     */
    getVisibleColumns(): Array<DevExpress.ui.dxDataGrid.Column<TRowData, TKey>>;
    /**
     * Gets all visible columns at a specific hierarchical level of column headers. Use it to access banded columns.
     */
    getVisibleColumns(
      headerLevel: number
    ): Array<DevExpress.ui.dxDataGrid.Column<TRowData, TKey>>;
    /**
     * Gets currently rendered rows.
     */
    getVisibleRows(): Array<DevExpress.ui.dxDataGrid.Row<TRowData, TKey>>;
    /**
     * Checks whether a specific group or master row is expanded or collapsed.
     */
    isRowExpanded(key: TKey): boolean;
    /**
     * Checks whether a row found using its data object is selected. Takes effect only if selection.deferred is true.
     */
    isRowSelected(data: TRowData): boolean;
    isRowSelected(key: TKey): boolean;
    /**
     * Gets the total row count.
     */
    totalCount(): number;
    abortAIColumnRequest(columnName: string): void;
    sendAIColumnRequest(columnName: string): void;
    refreshAIColumn(columnName: string): void;
    clearAIColumn(columnName: string): void;
    getAIColumnText(columnName: string, key: TKey): string;
    beginCustomLoading(messageText: string): void;
    byKey(key: TKey): DevExpress.core.utils.DxPromise<TRowData>;
    cancelEditData(): void;
    cellValue(rowIndex: number, dataField: string): any;
    cellValue(rowIndex: number, dataField: string, value: any): void;
    cellValue(rowIndex: number, visibleColumnIndex: number): any;
    cellValue(rowIndex: number, visibleColumnIndex: number, value: any): void;
    clearFilter(): void;
    clearFilter(filterName: string): void;
    clearSelection(): void;
    clearSorting(): void;
    closeEditCell(): void;
    collapseAdaptiveDetailRow(): void;
    columnCount(): number;
    columnOption(id: number | string): any;
    columnOption(id: number | string, optionName: string): any;
    columnOption(
      id: number | string,
      optionName: string,
      optionValue: any
    ): void;
    columnOption(id: number | string, options: any): void;
    deleteColumn(id: number | string): void;
    deleteRow(rowIndex: number): void;
    deselectAll(): DevExpress.core.utils.DxPromise<void>;
    deselectRows(
      keys: Array<TKey>
    ): DevExpress.core.utils.DxPromise<Array<TRowData>>;
    editCell(rowIndex: number, dataField: string): void;
    editCell(rowIndex: number, visibleColumnIndex: number): void;
    editRow(rowIndex: number): void;
    endCustomLoading(): void;
    expandAdaptiveDetailRow(key: TKey): void;
    filter(): any;
    filter(filterExpr: any): void;
    focus(): void;
    focus(element: DevExpress.core.UserDefinedElement): void;
    getCellElement(
      rowIndex: number,
      dataField: string
    ): DevExpress.core.DxElement | undefined;
    getCellElement(
      rowIndex: number,
      visibleColumnIndex: number
    ): DevExpress.core.DxElement | undefined;
    getCombinedFilter(): any;
    getCombinedFilter(returnDataField: boolean): any;
    getDataSource(): DevExpress.common.data.DataSource<TRowData, TKey>;
    getKeyByRowIndex(rowIndex: number): TKey | undefined;
    getRowElement(
      rowIndex: number
    ): DevExpress.core.UserDefinedElementsArray | undefined;
    getRowIndexByKey(key: TKey): number;
    getScrollable(): DevExpress.common.Scrollable;
    getVisibleColumnIndex(id: number | string): number;
    hasEditData(): boolean;
    hideColumnChooser(): void;
    isAdaptiveDetailRowExpanded(key: TKey): boolean;
    isRowFocused(key: TKey): boolean;
    keyOf(obj: TRowData): TKey;
    navigateToRow(key: TKey): DevExpress.core.utils.DxPromise<void>;
    pageCount(): number;
    pageIndex(): number;
    pageIndex(newIndex: number): DevExpress.core.utils.DxPromise<void>;
    pageSize(): number;
    pageSize(value: number): void;
    refresh(): DevExpress.core.utils.DxPromise<void>;
    refresh(changesOnly: boolean): DevExpress.core.utils.DxPromise<void>;
    repaintRows(rowIndexes: Array<number>): void;
    saveEditData(): DevExpress.core.utils.DxPromise<void>;
    searchByText(text: string): void;
    selectAll(): DevExpress.core.utils.DxPromise<void>;
    selectRows(
      keys: Array<TKey>,
      preserve: boolean
    ): DevExpress.core.utils.DxPromise<Array<TRowData>>;
    selectRowsByIndexes(
      indexes: Array<number>
    ): DevExpress.core.utils.DxPromise<Array<TRowData>>;
    showColumnChooser(): void;
    state(): any;
    state(state: any): void;
    undeleteRow(rowIndex: number): void;
    updateDimensions(): void;
  }
  module dxDataGrid {
    /**
     * The type of the adaptiveDetailRowPreparing event handler&apos;s argument.
     */
    export type AdaptiveDetailRowPreparingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.AdaptiveDetailRowPreparingInfo;
    /**
     * The argument type in the aIColumnRequestCreating event.
     */
    export type AIColumnRequestCreatingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.AIColumnRequestCreatingInfo<TRowData>;
    /**
     * The type of the cellClick event handler&apos;s argument.
     */
    export type CellClickEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly displayValue?: any;
      /**
       * 
       */
      readonly text: string;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly column: Column<TRowData, TKey>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly cellElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly row: Row<TRowData, TKey>;
    };
    /**
     * The type of the cellDblClick event handler&apos;s argument.
     */
    export type CellDblClickEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly displayValue?: any;
      /**
       * 
       */
      readonly text: string;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly column: Column<TRowData, TKey>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly cellElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly row: Row<TRowData, TKey>;
    };
    /**
     * The type of the cellHoverChanged event handler&apos;s argument.
     */
    export type CellHoverChangedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly eventType: string;
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly text: string;
      /**
       * 
       */
      readonly displayValue?: any;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly column: Column<TRowData, TKey>;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly cellElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly row: Row<TRowData, TKey>;
    };
    /**
     * The type of the cellPrepared event handler&apos;s argument.
     */
    export type CellPreparedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly displayValue?: any;
      /**
       * 
       */
      readonly text: string;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly column: Column<TRowData, TKey>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly row: Row<TRowData, TKey>;
      /**
       * 
       */
      readonly isSelected?: boolean;
      /**
       * 
       */
      readonly isExpanded?: boolean;
      /**
       * 
       */
      readonly isNewRow?: boolean;
      /**
       * 
       */
      readonly cellElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly watch?: Function;
      /**
       * 
       */
      readonly oldValue?: any;
    };
    export type Column<TRowData = any, TKey = any> = dxDataGridColumn<
      TRowData,
      TKey
    >;
    /**
     * @deprecated Use Column instead
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ColumnBase<TRowData = any> =
      DevExpress.common.grids.ColumnBase<TRowData>;
    export type ColumnButton<
      TRowData = any,
      TKey = any
    > = dxDataGridColumnButton<TRowData, TKey>;
    /**
     * @deprecated Use ColumnButton instead
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ColumnButtonBase = DevExpress.common.grids.ColumnButtonBase;
    /**
     * 
     */
    export type ColumnButtonClickEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      row?: Row<TRowData, TKey>;
      /**
       * 
       */
      column?: Column<TRowData, TKey>;
    };
    export type ColumnButtonTemplateData<TRowData = any, TKey = any> = {
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly data?: TRowData;
      readonly key?: TKey;
      readonly columnIndex: number;
      readonly column: Column<TRowData, TKey>;
      readonly rowIndex: number;
      readonly rowType: string;
      readonly row: Row<TRowData, TKey>;
    };
    export type ColumnCellTemplateData<TRowData = any, TKey = any> = {
      readonly data?: TRowData;
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly value?: any;
      readonly oldValue?: any;
      readonly displayValue?: any;
      readonly text: string;
      readonly columnIndex: number;
      readonly rowIndex: number;
      readonly column: Column<TRowData, TKey>;
      readonly row: Row<TRowData, TKey>;
      readonly rowType: string;
      readonly watch?: Function;
    };
    export type ColumnEditCellTemplateData<TRowData = any, TKey = any> = {
      readonly setValue?: any;
      readonly data?: TRowData;
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly value?: any;
      readonly displayValue?: any;
      readonly text: string;
      readonly columnIndex: number;
      readonly rowIndex: number;
      readonly column: Column<TRowData, TKey>;
      readonly row: Row<TRowData, TKey>;
      readonly rowType: string;
      readonly watch?: Function;
    };
    export type ColumnGroupCellTemplateData<TRowData = any, TKey = any> = {
      readonly data?: GroupData<TRowData>;
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly value?: any;
      readonly text: string;
      readonly displayValue?: any;
      readonly columnIndex: number;
      readonly rowIndex: number;
      readonly column: Column<TRowData, TKey>;
      readonly row: Row<GroupData<TRowData>, GroupKey>;
      readonly summaryItems: Array<any>;
      readonly groupContinuesMessage?: string;
      readonly groupContinuedMessage?: string;
    };
    export type ColumnHeaderCellTemplateData<TRowData = any, TKey = any> = {
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly columnIndex: number;
      readonly column: Column<TRowData, TKey>;
    };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>>;
    /**
     * The type of the contextMenuPreparing event handler&apos;s argument.
     */
    export type ContextMenuPreparingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      items?: Array<any>;
      /**
       * 
       */
      readonly target: DevExpress.common.grids.GridsContextMenuTarget;
      /**
       * 
       */
      readonly targetElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly column?: Column<TRowData, TKey>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly row?: Row<TRowData, TKey>;
    };
    export type CustomSummaryInfo<TRowData = any, TKey = any> = {
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly name?: string;
      readonly summaryProcess: string;
      readonly value?: any;
      totalValue?: any;
      readonly groupIndex?: number;
    };
    /**
     * The type of the dataErrorOccurred event handler&apos;s argument.
     */
    export type DataErrorOccurredEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.DataErrorOccurredInfo;
    export type DataGridCommandColumnType =
      | 'adaptive'
      | 'ai'
      | 'buttons'
      | 'detailExpand'
      | 'groupExpand'
      | 'selection'
      | 'drag';
    export type DataGridExportFormat = 'pdf' | 'xlsx';
    export type DataGridPredefinedColumnButton =
      | 'cancel'
      | 'delete'
      | 'edit'
      | 'save'
      | 'undelete';
    export type DataGridPredefinedToolbarItem =
      | 'addRowButton'
      | 'applyFilterButton'
      | 'columnChooserButton'
      | 'exportButton'
      | 'groupPanel'
      | 'revertButton'
      | 'saveButton'
      | 'searchPanel';
    export type DataGridScrollMode = 'infinite' | 'standard' | 'virtual';
    export type DataRowTemplateData<TRowData = any, TKey = any> = {
      readonly key: TKey;
      readonly data: TRowData;
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly values: Array<any>;
      readonly rowIndex: number;
      readonly columns: Array<Column<TRowData, TKey>>;
      readonly isSelected?: boolean;
      readonly isExpanded?: boolean;
    };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type dxDataGridToolbar = Toolbar;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type dxDataGridToolbarItem = ToolbarItem;
    /**
     * The type of the editCanceled event handler&apos;s argument.
     */
    export type EditCanceledEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.DataChangeInfo<TRowData, TKey>;
    /**
     * The type of the editCanceling event handler&apos;s argument.
     */
    export type EditCancelingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.DataChangeInfo<TRowData, TKey>;
    /**
     * Configures editing.
     */
    export type Editing<TRowData = any, TKey = any> = EditingBase<
      TRowData,
      TKey
    > & {
      /**
       * Specifies whether a user can add new rows.
       */
      allowAdding?: boolean;
      /**
       * Specifies whether a user can delete rows. It is called for each data row when defined as a function.
       */
      allowDeleting?:
        | boolean
        | ((options: {
            component?: dxDataGrid<TRowData, TKey>;
            row?: Row<TRowData, TKey>;
          }) => boolean);
      /**
       * Specifies whether a user can update rows. It is called for each data row when defined as a function.
       */
      allowUpdating?:
        | boolean
        | ((options: {
            component?: dxDataGrid<TRowData, TKey>;
            row?: Row<TRowData, TKey>;
          }) => boolean);
      /**
       * Contains properties that specify texts for editing-related UI elements.
       */
      texts?: any;
      /**
       * Specifies a position for a new row.
       */
      newRowPosition?: DevExpress.common.grids.NewRowPosition;
    };
    /**
     * @deprecated Use Editing instead
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type EditingBase<
      TRowData = any,
      TKey = any
    > = DevExpress.common.grids.EditingBase<TRowData, TKey>;
    /**
     * The type of the editingStart event handler&apos;s argument.
     */
    export type EditingStartEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
        /**
         * 
         */
        readonly data: TRowData;
        /**
         * 
         */
        readonly key: TKey;
        /**
         * 
         */
        readonly column?: Column<TRowData, TKey>;
      };
    export type EditingTexts = DevExpress.common.grids.EditingTextsBase;
    /**
     * The type of the editorPrepared event handler&apos;s argument.
     */
    export type EditorPreparedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly parentType: string;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly setValue?: any;
      /**
       * 
       */
      updateValueTimeout?: number;
      /**
       * 
       */
      readonly width?: number;
      /**
       * 
       */
      readonly disabled: boolean;
      /**
       * 
       */
      readonly rtlEnabled: boolean;
      /**
       * 
       */
      readonly editorElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly readOnly: boolean;
      /**
       * 
       */
      readonly dataField?: string;
      /**
       * 
       */
      readonly row?: Row<TRowData, TKey>;
    };
    /**
     * The type of the editorPreparing event handler&apos;s argument.
     */
    export type EditorPreparingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly parentType: string;
      /**
       * 
       */
      readonly value?: any;
      /**
       * 
       */
      readonly setValue?: any;
      /**
       * 
       */
      updateValueTimeout?: number;
      /**
       * 
       */
      readonly width?: number;
      /**
       * 
       */
      readonly disabled: boolean;
      /**
       * 
       */
      readonly rtlEnabled: boolean;
      /**
       * 
       */
      cancel: boolean;
      /**
       * 
       */
      readonly editorElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly readOnly: boolean;
      /**
       * 
       */
      editorName: string;
      /**
       * 
       */
      editorOptions: any;
      /**
       * 
       */
      readonly dataField?: string;
      /**
       * 
       */
      readonly row?: Row<TRowData, TKey>;
    };
    export type ExplicitTypes<TRowData, TKey> = {
      AdaptiveDetailRowPreparingEvent: AdaptiveDetailRowPreparingEvent<
        TRowData,
        TKey
      >;
      CellClickEvent: CellClickEvent<TRowData, TKey>;
      CellDblClickEvent: CellDblClickEvent<TRowData, TKey>;
      CellHoverChangedEvent: CellHoverChangedEvent<TRowData, TKey>;
      CellPreparedEvent: CellPreparedEvent<TRowData, TKey>;
      Column: Column<TRowData, TKey>;
      ColumnButton: ColumnButton<TRowData, TKey>;
      ColumnButtonClickEvent: ColumnButtonClickEvent<TRowData, TKey>;
      ColumnButtonTemplateData: ColumnButtonTemplateData<TRowData, TKey>;
      ColumnCellTemplateData: ColumnCellTemplateData<TRowData, TKey>;
      ColumnEditCellTemplateData: ColumnEditCellTemplateData<TRowData, TKey>;
      ColumnGroupCellTemplateData: ColumnGroupCellTemplateData<TRowData, TKey>;
      ColumnHeaderCellTemplateData: ColumnHeaderCellTemplateData<
        TRowData,
        TKey
      >;
      ContentReadyEvent: ContentReadyEvent<TRowData, TKey>;
      ContextMenuPreparingEvent: ContextMenuPreparingEvent<TRowData, TKey>;
      CustomSummaryInfo: CustomSummaryInfo<TRowData, TKey>;
      DataErrorOccurredEvent: DataErrorOccurredEvent<TRowData, TKey>;
      DataRowTemplateData: DataRowTemplateData<TRowData, TKey>;
      DisposingEvent: DisposingEvent<TRowData, TKey>;
      EditCanceledEvent: EditCanceledEvent<TRowData, TKey>;
      EditCancelingEvent: EditCancelingEvent<TRowData, TKey>;
      Editing: Editing<TRowData, TKey>;
      EditingStartEvent: EditingStartEvent<TRowData, TKey>;
      EditorPreparedEvent: EditorPreparedEvent<TRowData, TKey>;
      EditorPreparingEvent: EditorPreparingEvent<TRowData, TKey>;
      Export: Export;
      ExportingEvent: ExportingEvent<TRowData, TKey>;
      ExportTexts: ExportTexts;
      FocusedCellChangedEvent: FocusedCellChangedEvent<TRowData, TKey>;
      FocusedCellChangingEvent: FocusedCellChangingEvent<TRowData, TKey>;
      FocusedRowChangedEvent: FocusedRowChangedEvent<TRowData, TKey>;
      FocusedRowChangingEvent: FocusedRowChangingEvent<TRowData, TKey>;
      GroupData: GroupData<TRowData>;
      Grouping: Grouping;
      GroupingTexts: GroupingTexts;
      GroupPanel: GroupPanel;
      InitializedEvent: InitializedEvent<TRowData, TKey>;
      InitNewRowEvent: InitNewRowEvent<TRowData, TKey>;
      KeyDownEvent: KeyDownEvent<TRowData, TKey>;
      MasterDetail: MasterDetail<TRowData, TKey>;
      MasterDetailTemplateData: MasterDetailTemplateData<TRowData, TKey>;
      OptionChangedEvent: OptionChangedEvent<TRowData, TKey>;
      Properties: Properties<TRowData, TKey>;
      Row: Row<TRowData, TKey>;
      RowClickEvent: RowClickEvent<TRowData, TKey>;
      RowCollapsedEvent: RowCollapsedEvent<TRowData, TKey>;
      RowCollapsingEvent: RowCollapsingEvent<TRowData, TKey>;
      RowDblClickEvent: RowDblClickEvent<TRowData, TKey>;
      RowDraggingAddEvent: RowDraggingAddEvent<TRowData, TKey>;
      RowDraggingChangeEvent: RowDraggingChangeEvent<TRowData, TKey>;
      RowDraggingEndEvent: RowDraggingEndEvent<TRowData, TKey>;
      RowDraggingMoveEvent: RowDraggingMoveEvent<TRowData, TKey>;
      RowDraggingRemoveEvent: RowDraggingRemoveEvent<TRowData, TKey>;
      RowDraggingReorderEvent: RowDraggingReorderEvent<TRowData, TKey>;
      RowDraggingStartEvent: RowDraggingStartEvent<TRowData, TKey>;
      RowDraggingTemplateData: DevExpress.common.grids.RowDraggingTemplateData<TRowData>;
      RowExpandedEvent: RowExpandedEvent<TRowData, TKey>;
      RowExpandingEvent: RowExpandingEvent<TRowData, TKey>;
      RowInsertedEvent: RowInsertedEvent<TRowData, TKey>;
      RowInsertingEvent: RowInsertingEvent<TRowData, TKey>;
      RowPreparedEvent: RowPreparedEvent<TRowData, TKey>;
      RowRemovedEvent: RowRemovedEvent<TRowData, TKey>;
      RowRemovingEvent: RowRemovingEvent<TRowData, TKey>;
      RowTemplateData: RowTemplateData<TRowData, TKey>;
      RowUpdatedEvent: RowUpdatedEvent<TRowData, TKey>;
      RowUpdatingEvent: RowUpdatingEvent<TRowData, TKey>;
      RowValidatingEvent: RowValidatingEvent<TRowData, TKey>;
      SavedEvent: SavedEvent<TRowData, TKey>;
      SavingEvent: SavingEvent<TRowData, TKey>;
      Scrolling: Scrolling;
      Selection: Selection;
      SelectionChangedEvent: SelectionChangedEvent<TRowData, TKey>;
      Summary: Summary<TRowData, TKey>;
      SummaryGroupItem: SummaryGroupItem;
      SummaryItemTextInfo: SummaryItemTextInfo;
      SummaryTexts: SummaryTexts;
      SummaryTotalItem: SummaryTotalItem;
      Toolbar: Toolbar;
      ToolbarItem: ToolbarItem;
      ToolbarPreparingEvent: ToolbarPreparingEvent<TRowData, TKey>;
    };
    /**
     * Configures client-side exporting.
     */
    export type Export = {
      /**
       * Allows users to export selected rows only.
       */
      allowExportSelectedData?: boolean;
      /**
       * Adds the Export button to the DataGrid&apos;s toolbar.
       */
      enabled?: boolean;
      /**
       * Specifies the availability and captions of data export buttons.
       */
      formats?: ('xlsx' | 'pdf' | string)[];
      /**
       * Configures the texts of export commands, buttons, and hints.
       */
      texts?: ExportTexts;
    };
    /**
     * The type of the exporting event handler&apos;s argument.
     */
    export type ExportingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
        /**
         * 
         */
        fileName?: string;
        /**
         * 
         */
        selectedRowsOnly: boolean;
        /**
         * 
         */
        format: DataGridExportFormat | string;
      };
    /**
     * Configures the texts of export commands, buttons, and hints.
     */
    export type ExportTexts = {
      /**
       * The text or hint of the command that exports all data.
       */
      exportAll?: string;
      /**
       * The text of the command that exports selected rows. Applies when the allowExportSelectedData property is true.
       */
      exportSelectedRows?: string;
      /**
       * The hint of the Export button when the allowExportSelectedData property is true.
       */
      exportTo?: string;
    };
    export type FilterPanel<
      TRowData = any,
      TKey = any
    > = DevExpress.common.grids.FilterPanel<dxDataGrid, TRowData, TKey>;
    export type FilterPanelCustomizeTextArg =
      DevExpress.common.grids.FilterPanelCustomizeTextArg<dxDataGrid>;
    /**
     * The type of the focusedCellChanged event handler&apos;s argument.
     */
    export type FocusedCellChangedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly cellElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly columnIndex: number;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly row?: Row<TRowData, TKey>;
      /**
       * 
       */
      readonly column?: Column<TRowData, TKey>;
    };
    /**
     * The type of the focusedCellChanging event handler&apos;s argument.
     */
    export type FocusedCellChangingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxDataGrid<TRowData, TKey>,
        DevExpress.events.InteractionEvent
      > & {
        /**
         * 
         */
        readonly cellElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly prevColumnIndex: number;
        /**
         * 
         */
        readonly prevRowIndex: number;
        /**
         * 
         */
        newColumnIndex: number;
        /**
         * 
         */
        newRowIndex: number;
        /**
         * 
         */
        readonly rows: Array<Row<TRowData, TKey>>;
        /**
         * 
         */
        readonly columns: Array<Column<TRowData, TKey>>;
        /**
         * 
         */
        isHighlighted: boolean;
      };
    /**
     * The type of the focusedRowChanged event handler&apos;s argument.
     */
    export type FocusedRowChangedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly rowElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly row?: Row<TRowData, TKey>;
    };
    /**
     * The type of the focusedRowChanging event handler&apos;s argument.
     */
    export type FocusedRowChangingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxDataGrid<TRowData, TKey>,
        DevExpress.events.InteractionEvent
      > & {
        /**
         * 
         */
        readonly rowElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly prevRowIndex: number;
        /**
         * 
         */
        newRowIndex: number;
        /**
         * 
         */
        readonly rows: Array<Row<TRowData, TKey>>;
      };
    /**
     * Specifies a group of elements in a template.
     */
    export type GroupData<TRowData> = {
      key: any;
      items: Array<TRowData> | Array<GroupData<TRowData>> | null;
      /**
       * @deprecated Attention! This property is for internal purposes only.
       */
      collapsedItems?: Array<TRowData> | Array<GroupData<TRowData>>;
      /**
       * @deprecated Attention! This property is for internal purposes only.
       */
      aggregates?: Array<any>;
      /**
       * @deprecated Attention! This property is for internal purposes only.
       */
      summary?: Array<any>;
      /**
       * @deprecated Attention! This property is for internal purposes only.
       */
      isContinuation?: boolean;
      /**
       * @deprecated Attention! This property is for internal purposes only.
       */
      isContinuationOnNextPage?: boolean;
    };
    /**
     * Configures grouping.
     */
    export type Grouping = {
      /**
       * Specifies whether the user can collapse grouped records in a grid or not.
       */
      allowCollapsing?: boolean;
      /**
       * Specifies whether groups appear expanded or not.
       */
      autoExpandAll?: boolean;
      /**
       * Enables the user to group data using the context menu.
       */
      contextMenuEnabled?: boolean;
      /**
       * Specifies the event on which a group will be expanded/collapsed.
       */
      expandMode?: DevExpress.common.grids.GroupExpandMode;
      /**
       * Defines the texts of grouping-related visual elements.
       */
      texts?: GroupingTexts;
    };
    /**
     * Defines the texts of grouping-related visual elements.
     */
    export type GroupingTexts = {
      /**
       * Specifies the text of the context menu item that groups data by a specific column.
       */
      groupByThisColumn?: string;
      /**
       * Specifies the message displayed in a group row when the corresponding group is continued from the previous page.
       */
      groupContinuedMessage?: string;
      /**
       * Specifies the message displayed in a group row when the corresponding group continues on the next page.
       */
      groupContinuesMessage?: string;
      /**
       * Specifies the text of the context menu item that clears grouping settings of a specific column.
       */
      ungroup?: string;
      /**
       * Specifies the text of the context menu item that clears grouping settings of all columns.
       */
      ungroupAll?: string;
    };
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type GroupKey = any[];
    /**
     * Configures the group panel.
     */
    export type GroupPanel = {
      /**
       * Specifies whether columns can be dragged onto or from the group panel.
       */
      allowColumnDragging?: boolean;
      /**
       * Specifies text displayed by the group panel when it does not contain any columns.
       */
      emptyPanelText?: string;
      /**
       * Specifies whether the group panel is visible or not.
       */
      visible?: boolean | DevExpress.common.Mode;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxDataGrid<TRowData, TKey>
    >;
    /**
     * The type of the initNewRow event handler&apos;s argument.
     */
    export type InitNewRowEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.NewRowInfo<TRowData>;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      KeyboardEvent
    > &
      DevExpress.common.grids.KeyDownInfo;
    /**
     * Allows you to build a master-detail interface in the grid.
     */
    export type MasterDetail<TRowData = any, TKey = any> = {
      /**
       * Specifies whether detail sections appear expanded or collapsed.
       */
      autoExpandAll?: boolean;
      /**
       * Enables an end-user to expand/collapse detail sections.
       */
      enabled?: boolean;
      /**
       * Specifies a custom template for detail sections.
       */
      template?:
        | template
        | ((
            detailElement: DevExpress.core.DxElement,
            detailInfo: MasterDetailTemplateData<TRowData, TKey>
          ) => any);
    };
    export type MasterDetailTemplateData<TRowData = any, TKey = any> = {
      readonly key: TKey;
      readonly data: TRowData;
      readonly watch?: Function;
    };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type OverriddenKeys =
      | 'columns'
      | 'customizeColumns'
      | 'dataRowTemplate'
      | 'editing'
      | 'export'
      | 'grouping'
      | 'groupPanel'
      | 'keyExpr'
      | 'masterDetail'
      | 'onCellClick'
      | 'onCellDblClick'
      | 'onCellHoverChanged'
      | 'onCellPrepared'
      | 'onContextMenuPreparing'
      | 'onEditingStart'
      | 'onEditorPrepared'
      | 'onEditorPreparing'
      | 'onExporting'
      | 'onFocusedCellChanged'
      | 'onFocusedCellChanging'
      | 'onFocusedRowChanged'
      | 'onFocusedRowChanging'
      | 'onRowClick'
      | 'onRowDblClick'
      | 'onRowPrepared'
      | 'remoteOperations'
      | 'rowTemplate'
      | 'scrolling'
      | 'selection'
      | 'selectionFilter'
      | 'sortByGroupSummaryInfo'
      | 'summary'
      | 'toolbar';
    export type Paging = DevExpress.common.grids.PagingBase;
    export type Properties<TRowData = any, TKey = any> = dxDataGridOptions<
      TRowData,
      TKey
    >;
    /**
     * A grid row.
     */
    export type Row<TRowData = any, TKey = any> = {
      /**
       * The data object represented by the row.
       */
      readonly data: TRowData;
      /**
       * The group index of the row. Available when the rowType is &apos;group&apos;.
       */
      readonly groupIndex?: number;
      /**
       * Indicates whether the row is in the editing state.
       */
      readonly isEditing?: boolean;
      /**
       * Indicates whether the row is expanded or collapsed. Available if rowType is &apos;data&apos; or &apos;group&apos;.
       */
      readonly isExpanded?: boolean;
      /**
       * Indicates that the row is added, but not yet saved. Available if rowType is &apos;data&apos;.
       */
      readonly isNewRow?: boolean;
      /**
       * Indicates whether the row is selected. Available if rowType is &apos;data&apos;.
       */
      readonly isSelected?: boolean;
      /**
       * The key of the data object represented by the row.
       */
      readonly key: TKey;
      /**
       * The visible index of the row.
       */
      readonly rowIndex: number;
      /**
       * The row&apos;s type.
       */
      readonly rowType: string;
      /**
       * Values of the row as they exist in the data source.
       */
      readonly values: Array<any>;
    };
    /**
     * The type of the rowClick event handler&apos;s argument.
     */
    export type RowClickEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly values: Array<any>;
      /**
       * 
       */
      readonly columns: Array<Column<TRowData, TKey>>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly isSelected?: boolean;
      /**
       * 
       */
      readonly isExpanded?: boolean;
      /**
       * 
       */
      readonly isNewRow?: boolean;
      /**
       * 
       */
      readonly groupIndex?: number;
      /**
       * 
       */
      readonly rowElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly handled: boolean;
    };
    /**
     * The type of the rowCollapsed event handler&apos;s argument.
     */
    export type RowCollapsedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowKeyInfo<TKey>;
    /**
     * The type of the rowCollapsing event handler&apos;s argument.
     */
    export type RowCollapsingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowKeyInfo<TKey>;
    /**
     * The type of the rowDblClick event handler&apos;s argument.
     */
    export type RowDblClickEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxDataGrid<TRowData, TKey>,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly values: Array<any>;
      /**
       * 
       */
      readonly columns: Array<Column<TRowData, TKey>>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly isSelected?: boolean;
      /**
       * 
       */
      readonly isExpanded?: boolean;
      /**
       * 
       */
      readonly isNewRow?: boolean;
      /**
       * 
       */
      readonly groupIndex?: number;
      /**
       * 
       */
      readonly rowElement: DevExpress.core.DxElement;
    };
    export type RowDragging<
      TRowData = any,
      TKey = any
    > = DevExpress.common.grids.RowDragging<dxDataGrid, TRowData, TKey>;
    export type RowDraggingAddEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData> &
      DevExpress.common.grids.DragDropInfo;
    export type RowDraggingChangeEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData> &
      DevExpress.common.grids.DragDropInfo;
    export type RowDraggingEndEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData> &
      DevExpress.common.grids.DragDropInfo;
    export type RowDraggingMoveEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData> &
      DevExpress.common.grids.DragDropInfo;
    export type RowDraggingRemoveEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData>;
    export type RowDraggingReorderEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowDraggingEventInfo<TRowData> &
      DevExpress.common.grids.DragReorderInfo;
    export type RowDraggingStartEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.ReducedNativeEventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.DragStartEventInfo<TRowData>;
    /**
     * The type of the rowExpanded event handler&apos;s argument.
     */
    export type RowExpandedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowKeyInfo<TKey>;
    /**
     * The type of the rowExpanding event handler&apos;s argument.
     */
    export type RowExpandingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowKeyInfo<TKey>;
    /**
     * The type of the rowInserted event handler&apos;s argument.
     */
    export type RowInsertedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowInsertedInfo<TRowData, TKey>;
    /**
     * The type of the rowInserting event handler&apos;s argument.
     */
    export type RowInsertingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowInsertingInfo<TRowData>;
    /**
     * The type of the rowPrepared event handler&apos;s argument.
     */
    export type RowPreparedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> & {
      /**
       * 
       */
      readonly data: TRowData;
      /**
       * 
       */
      readonly key: TKey;
      /**
       * 
       */
      readonly values: Array<any>;
      /**
       * 
       */
      readonly columns: Array<Column<TRowData, TKey>>;
      /**
       * 
       */
      readonly rowIndex: number;
      /**
       * 
       */
      readonly rowType: string;
      /**
       * 
       */
      readonly groupIndex?: number;
      /**
       * 
       */
      readonly isSelected?: boolean;
      /**
       * 
       */
      readonly isExpanded?: boolean;
      /**
       * 
       */
      readonly isNewRow?: boolean;
      /**
       * 
       */
      readonly rowElement: DevExpress.core.DxElement;
    };
    /**
     * The type of the rowRemoved event handler&apos;s argument.
     */
    export type RowRemovedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowRemovedInfo<TRowData, TKey>;
    /**
     * The type of the rowRemoving event handler&apos;s argument.
     */
    export type RowRemovingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowRemovingInfo<TRowData, TKey>;
    export type RowTemplateData<TRowData = any, TKey = any> = {
      readonly key: TKey;
      readonly data: TRowData;
      readonly component: dxDataGrid<TRowData, TKey>;
      readonly values: Array<any>;
      readonly rowIndex: number;
      readonly columns: Array<Column<TRowData, TKey>>;
      readonly isSelected?: boolean;
      readonly rowType: string;
      readonly groupIndex?: number;
      readonly isExpanded?: boolean;
    };
    /**
     * The type of the rowUpdated event handler&apos;s argument.
     */
    export type RowUpdatedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowUpdatedInfo<TRowData, TKey>;
    /**
     * The type of the rowUpdating event handler&apos;s argument.
     */
    export type RowUpdatingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowUpdatingInfo<TRowData, TKey>;
    /**
     * The type of the rowValidating event handler&apos;s argument.
     */
    export type RowValidatingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.RowValidatingInfo<TRowData, TKey>;
    /**
     * The type of the saved event handler&apos;s argument.
     */
    export type SavedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.DataChangeInfo<TRowData, TKey>;
    /**
     * The type of the saving event handler&apos;s argument.
     */
    export type SavingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.SavingInfo<TRowData, TKey>;
    /**
     * Configures scrolling.
     */
    export type Scrolling = ScrollingBase & {
      /**
       * Specifies the scrolling mode.
       */
      mode?: DataGridScrollMode;
    };
    /**
     * @deprecated Use Scrolling instead
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ScrollingBase = DevExpress.common.grids.ScrollingBase;
    export type Selection = SelectionBase & {
      /**
       * Makes selection deferred.
       */
      deferred?: boolean;
      /**
       * Specifies how to filter selected DataGrid rows based on sensitivity.
       */
      sensitivity?: SelectionSensitivity;
      /**
       * Specifies the mode in which all the records are selected. Applies only if selection.allowSelectAll is true.
       */
      selectAllMode?: DevExpress.common.SelectAllMode;
      /**
       * Specifies when to display the selection column and row selection checkboxes. Applies only if selection.mode is &apos;multiple&apos;.
       */
      showCheckBoxesMode?: DevExpress.common.grids.SelectionColumnDisplayMode;
    };
    /**
     * @deprecated Use Selection instead
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type SelectionBase = DevExpress.common.grids.SelectionBase;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.SelectionChangedInfo<TRowData, TKey>;
    export type SelectionSensitivity = 'base' | 'accent' | 'case' | 'variant';
    /**
     * Allows you to sort groups according to the values of group summary items.
     */
    export type SortByGroupSummaryInfoItem = {
      /**
       * Specifies the identifier of the column that must be used in grouping so that sorting by group summary item values be applied.
       */
      groupColumn?: string | undefined;
      /**
       * Specifies the sort order of group summary item values.
       */
      sortOrder?: DevExpress.common.SortOrder | undefined;
      /**
       * Specifies the group summary item whose values must be used to sort groups.
       */
      summaryItem?: string | number | undefined;
    };
    /**
     * Specifies the properties of the grid summary.
     */
    export type Summary<TRowData = any, TKey = any> = {
      /**
       * Specifies a custom aggregate function. This function is called for summary items whose summaryType is &apos;custom&apos;.
       */
      calculateCustomSummary?: (
        options: CustomSummaryInfo<TRowData, TKey>
      ) => void;
      /**
       * Specifies items of the group summary.
       */
      groupItems?: Array<SummaryGroupItem> | undefined;
      /**
       * Specifies whether to recalculate summaries while a user edits data.
       */
      recalculateWhileEditing?: boolean;
      /**
       * Specifies whether to skip empty strings, null and undefined values when calculating a summary. Does not apply when you use a remote data source.
       */
      skipEmptyValues?: boolean;
      /**
       * Contains properties that specify text patterns for summary items.
       */
      texts?: SummaryTexts;
      /**
       * Specifies items of the total summary.
       */
      totalItems?: Array<SummaryTotalItem> | undefined;
    };
    /**
     * Specifies items of the group summary.
     */
    export type SummaryGroupItem = {
      /**
       * Indicates whether to display group summary items in parentheses after the group row header or to align them by the corresponding columns within the group row.
       */
      alignByColumn?: boolean;
      /**
       * Specifies the column that provides data for a group summary item.
       */
      column?: string | undefined;
      /**
       * Customizes the text to be displayed in the summary item.
       */
      customizeText?: (itemInfo: SummaryItemTextInfo) => string;
      /**
       * Specifies the summary item&apos;s text.
       */
      displayFormat?: string | undefined;
      /**
       * Specifies the group summary item&apos;s identifier.
       */
      name?: string | undefined;
      /**
       * Specifies the column that must hold the summary item when this item is displayed in the group footer or aligned by a column in the group row.
       */
      showInColumn?: string | undefined;
      /**
       * Specifies whether or not a summary item must be displayed in the group footer.
       */
      showInGroupFooter?: boolean;
      /**
       * Specifies whether to skip empty strings, null, and undefined values when calculating a summary. Does not apply when you use a remote data source.
       */
      skipEmptyValues?: boolean;
      /**
       * Specifies how to aggregate data for the group summary item.
       */
      summaryType?: DevExpress.common.grids.SummaryType | string | undefined;
      /**
       * Specifies a summary item value&apos;s display format.
       */
      valueFormat?: DevExpress.common.core.localization.Format | undefined;
    };
    export type SummaryItemTextInfo = {
      readonly value?: string | number | Date;
      readonly valueText: string;
    };
    /**
     * Contains properties that specify text patterns for summary items.
     */
    export type SummaryTexts = {
      /**
       * Specifies a pattern for the &apos;avg&apos; summary items when they are displayed in the parent column.
       */
      avg?: string;
      /**
       * Specifies a pattern for the &apos;avg&apos; summary items displayed in a group row or in any other column rather than the parent one.
       */
      avgOtherColumn?: string;
      /**
       * Specifies a pattern for the &apos;count&apos; summary items.
       */
      count?: string;
      /**
       * Specifies a pattern for the &apos;max&apos; summary items when they are displayed in the parent column.
       */
      max?: string;
      /**
       * Specifies a pattern for the &apos;max&apos; summary items displayed in a group row or in any other column rather than the parent one.
       */
      maxOtherColumn?: string;
      /**
       * Specifies a pattern for the &apos;min&apos; summary items when they are displayed in the parent column.
       */
      min?: string;
      /**
       * Specifies a pattern for the &apos;min&apos; summary items displayed in a group row or in any other column rather than the parent one.
       */
      minOtherColumn?: string;
      /**
       * Specifies a pattern for the &apos;sum&apos; summary items when they are displayed in the parent column.
       */
      sum?: string;
      /**
       * Specifies a pattern for the &apos;sum&apos; summary items displayed in a group row or in any other column rather than the parent one.
       */
      sumOtherColumn?: string;
    };
    /**
     * Specifies items of the total summary.
     */
    export type SummaryTotalItem = {
      /**
       * Specifies the alignment of a summary item.
       */
      alignment?: DevExpress.common.HorizontalAlignment | undefined;
      /**
       * Specifies the column that provides data for a summary item.
       */
      column?: string | undefined;
      /**
       * Specifies a CSS class to be applied to a summary item.
       */
      cssClass?: string | undefined;
      /**
       * Customizes the text to be displayed in the summary item.
       */
      customizeText?: (itemInfo: SummaryItemTextInfo) => string;
      /**
       * Specifies the summary item&apos;s text.
       */
      displayFormat?: string | undefined;
      /**
       * Specifies the total summary item&apos;s identifier.
       */
      name?: string | undefined;
      /**
       * Specifies the column that must hold the summary item.
       */
      showInColumn?: string | undefined;
      /**
       * 
       */
      skipEmptyValues?: boolean;
      /**
       * Specifies how to aggregate data for the total summary item.
       */
      summaryType?: DevExpress.common.grids.SummaryType | string | undefined;
      /**
       * Specifies a summary item value&apos;s display format.
       */
      valueFormat?: DevExpress.common.core.localization.Format | undefined;
    };
    /**
     * The type of the toolbarPreparing event handler&apos;s argument.
     */
    export type ToolbarPreparingEvent<
      TRowData = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxDataGrid<TRowData, TKey>> &
      DevExpress.common.grids.ToolbarPreparingInfo;
  }
  /**
   * @deprecated Use the DevExpress.ui.dxDataGrid.Column type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDataGridColumn<TRowData = any, TKey = any>
    extends DevExpress.ui.dxDataGrid.ColumnBase<TRowData> {
    /**
     * Specifies whether data from this column should be exported. Applies only if the column is visible.
     */
    allowExporting?: boolean;
    /**
     * Specifies whether the user can group data by values of this column. Applies only when grouping is enabled.
     */
    allowGrouping?: boolean;
    /**
     * Specifies whether groups appear expanded or not when records are grouped by a specific column. Setting this property makes sense only when grouping is allowed for this column.
     */
    autoExpandGroup?: boolean;
    /**
     * Allows you to customize buttons in the edit column or create a custom command column. Applies only if the column&apos;s type is &apos;buttons&apos;.
     */
    buttons?: Array<
      | DevExpress.ui.dxDataGrid.DataGridPredefinedColumnButton
      | DevExpress.ui.dxDataGrid.ColumnButton<TRowData, TKey>
    >;
    /**
     * Sets custom column values used to group grid records.
     */
    calculateGroupValue?:
      | string
      | ((this: DevExpress.ui.dxDataGrid.ColumnBase, rowData: TRowData) => any);
    /**
     * Specifies a custom template for data cells.
     */
    cellTemplate?:
      | template
      | ((
          cellElement: DevExpress.core.DxElement,
          cellInfo: DevExpress.ui.dxDataGrid.ColumnCellTemplateData<
            TRowData,
            TKey
          >
        ) => any);
    /**
     * An array of grid columns.
     */
    columns?:
      | Array<DevExpress.ui.dxDataGrid.Column<TRowData, TKey> | string>
      | undefined;
    /**
     * Specifies a custom template for data cells in an editing state.
     */
    editCellTemplate?:
      | template
      | ((
          cellElement: DevExpress.core.DxElement,
          cellInfo: DevExpress.ui.dxDataGrid.ColumnEditCellTemplateData<
            TRowData,
            TKey
          >
        ) => any);
    /**
     * Specifies a custom template for group cells (group rows).
     */
    groupCellTemplate?:
      | template
      | ((
          cellElement: DevExpress.core.DxElement,
          cellInfo: DevExpress.ui.dxDataGrid.ColumnGroupCellTemplateData<
            TRowData,
            TKey
          >
        ) => any);
    /**
     * Specifies the index of a column when grid records are grouped by the values of this column.
     */
    groupIndex?: number | undefined;
    /**
     * Specifies a custom template for column headers.
     */
    headerCellTemplate?:
      | template
      | ((
          columnHeader: DevExpress.core.DxElement,
          headerInfo: DevExpress.ui.dxDataGrid.ColumnHeaderCellTemplateData<
            TRowData,
            TKey
          >
        ) => any);
    /**
     * Specifies whether or not to display the column when grid records are grouped by it.
     */
    showWhenGrouped?: boolean;
    /**
     * Specifies the command column that this object customizes.
     */
    type?: DevExpress.ui.dxDataGrid.DataGridCommandColumnType;
  }
  /**
   * @deprecated Use the DataGrid's ColumnButton type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDataGridColumnButton<TRowData = any, TKey = any>
    extends DevExpress.ui.dxDataGrid.ColumnButtonBase {
    /**
     * The name used to identify a built-in button.
     */
    name?: DevExpress.ui.dxDataGrid.DataGridPredefinedColumnButton | string;
    /**
     * A function that is executed when the button is clicked or tapped.
     */
    onClick?: (
      e: DevExpress.ui.dxDataGrid.ColumnButtonClickEvent<TRowData, TKey>
    ) => void;
    /**
     * Specifies a custom button template.
     */
    template?:
      | template
      | ((
          cellElement: DevExpress.core.DxElement,
          cellInfo: DevExpress.ui.dxDataGrid.ColumnButtonTemplateData<
            TRowData,
            TKey
          >
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the button&apos;s visibility.
     */
    visible?:
      | boolean
      | ((options: {
          component?: dxDataGrid<TRowData, TKey>;
          row?: DevExpress.ui.dxDataGrid.Row<TRowData, TKey>;
          column?: DevExpress.ui.dxDataGrid.Column<TRowData, TKey>;
        }) => boolean);
    /**
     * Specifies whether the button is disabled.
     */
    disabled?:
      | boolean
      | ((options: {
          component?: dxDataGrid<TRowData, TKey>;
          row?: DevExpress.ui.dxDataGrid.Row<TRowData, TKey>;
          column?: DevExpress.ui.dxDataGrid.Column<TRowData, TKey>;
        }) => boolean);
  }
  /**
   * 
   * @deprecated 
   */
  export type dxDataGridOptions<TRowData = any, TKey = any> = Omit<
    DevExpress.common.grids.GridBaseOptions<
      dxDataGrid<TRowData, TKey>,
      TRowData,
      TKey
    >,
    DevExpress.ui.dxDataGrid.OverriddenKeys
  > & {
    /**
     * An array of grid columns.
     */
    columns?:
      | Array<DevExpress.ui.dxDataGrid.Column<TRowData, TKey> | string>
      | undefined;
    /**
     * Customizes columns after they are created.
     */
    customizeColumns?: (
      columns: Array<DevExpress.ui.dxDataGrid.Column<TRowData, TKey>>
    ) => void;
    /**
     * Configures editing.
     */
    editing?: DevExpress.ui.dxDataGrid.Editing<TRowData, TKey>;
    /**
     * Configures client-side exporting.
     */
    export?: DevExpress.ui.dxDataGrid.Export;
    /**
     * Configures the group panel.
     */
    groupPanel?: DevExpress.ui.dxDataGrid.GroupPanel;
    /**
     * Configures grouping.
     */
    grouping?: DevExpress.ui.dxDataGrid.Grouping;
    /**
     * Specifies the key property (or properties) that provide(s) key values to access data items. Each key value must be unique. This property applies only if data is a simple array.
     */
    keyExpr?: string | Array<string> | undefined;
    /**
     * Allows you to build a master-detail interface in the grid.
     */
    masterDetail?: DevExpress.ui.dxDataGrid.MasterDetail<TRowData, TKey>;
    /**
     * A function that is executed when a cell is clicked or tapped. Executed before onRowClick.
     */
    onCellClick?: (
      e: DevExpress.ui.dxDataGrid.CellClickEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed when a cell is double-clicked or double-tapped. Executed before onRowDblClick.
     */
    onCellDblClick?: (
      e: DevExpress.ui.dxDataGrid.CellDblClickEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after the pointer enters or leaves a cell.
     */
    onCellHoverChanged?: (
      e: DevExpress.ui.dxDataGrid.CellHoverChangedEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after a grid cell is created.
     */
    onCellPrepared?: (
      e: DevExpress.ui.dxDataGrid.CellPreparedEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before the context menu is rendered.
     */
    onContextMenuPreparing?: (
      e: DevExpress.ui.dxDataGrid.ContextMenuPreparingEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before a cell or row switches to the editing state.
     */
    onEditingStart?: (
      e: DevExpress.ui.dxDataGrid.EditingStartEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after an editor is created. Not executed for cells with an editCellTemplate.
     */
    onEditorPrepared?: (
      options: DevExpress.ui.dxDataGrid.EditorPreparedEvent<TRowData, TKey>
    ) => void;
    /**
     * A function used to customize cell editors. Not executed for cells with an editCellTemplate.
     */
    onEditorPreparing?: (
      e: DevExpress.ui.dxDataGrid.EditorPreparingEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before data is exported.
     */
    onExporting?: (
      e: DevExpress.ui.dxDataGrid.ExportingEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after the focused cell changes. Applies only to cells in data or group rows.
     */
    onFocusedCellChanged?: (
      e: DevExpress.ui.dxDataGrid.FocusedCellChangedEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before the focused cell changes. Applies only to cells in data or group rows.
     */
    onFocusedCellChanging?: (
      e: DevExpress.ui.dxDataGrid.FocusedCellChangingEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after the focused row changes. Applies only to data or group rows. focusedRowEnabled should be true.
     */
    onFocusedRowChanged?: (
      e: DevExpress.ui.dxDataGrid.FocusedRowChangedEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed before the focused row changes. Applies only to data or group rows. focusedRowEnabled should be true.
     */
    onFocusedRowChanging?: (
      e: DevExpress.ui.dxDataGrid.FocusedRowChangingEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed when a row is clicked or tapped.
     */
    onRowClick?: (
      e: DevExpress.ui.dxDataGrid.RowClickEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed when a row is double-clicked or double-tapped. Executed after onCellDblClick.
     */
    onRowDblClick?: (
      e: DevExpress.ui.dxDataGrid.RowDblClickEvent<TRowData, TKey>
    ) => void;
    /**
     * A function that is executed after a row is created.
     */
    onRowPrepared?: (
      e: DevExpress.ui.dxDataGrid.RowPreparedEvent<TRowData, TKey>
    ) => void;
    /**
     * Specifies DataGrid operations to be executed on the server side.
     */
    remoteOperations?:
      | boolean
      | {
          /**
           * Specifies whether or not filtering must be performed on the server side.
           */
          filtering?: boolean;
          /**
           * Specifies whether paging by groups should be performed on the server side.
           */
          groupPaging?: boolean;
          /**
           * Specifies whether or not grouping must be performed on the server side.
           */
          grouping?: boolean;
          /**
           * Specifies whether or not paging must be performed on the server side.
           */
          paging?: boolean;
          /**
           * Specifies whether or not sorting must be performed on the server side.
           */
          sorting?: boolean;
          /**
           * Specifies whether or not summaries summaries are calculated on the server-side.
           */
          summary?: boolean;
        }
      | DevExpress.common.Mode;
    /**
     * Specifies a custom template for rows.
     * @deprecated Use the dataRowTemplate option instead.
     */
    rowTemplate?:
      | template
      | ((
          rowElement: DevExpress.core.DxElement,
          rowInfo: DevExpress.ui.dxDataGrid.RowTemplateData<TRowData, TKey>
        ) => any);
    /**
     * Specifies a custom template for data rows.
     */
    dataRowTemplate?:
      | template
      | ((
          rowElement: DevExpress.core.DxElement,
          rowInfo: DevExpress.ui.dxDataGrid.DataRowTemplateData<TRowData, TKey>
        ) => any);
    /**
     * Configures scrolling.
     */
    scrolling?: DevExpress.ui.dxDataGrid.Scrolling;
    /**
     * Configures runtime selection.
     */
    selection?: DevExpress.ui.dxDataGrid.Selection;
    /**
     * Specifies filters for the rows that must be selected initially. Applies only if selection.deferred is true.
     */
    selectionFilter?: string | Array<any> | Function;
    /**
     * Allows you to sort groups according to the values of group summary items.
     */
    sortByGroupSummaryInfo?:
      | Array<DevExpress.ui.dxDataGrid.SortByGroupSummaryInfoItem>
      | undefined;
    /**
     * Specifies the properties of the grid summary.
     */
    summary?: DevExpress.ui.dxDataGrid.Summary<TRowData, TKey>;
    /**
     * Configures the toolbar.
     */
    toolbar?: DevExpress.ui.dxDataGrid.Toolbar | undefined;
    /**
     * A function that is executed before an AI column request is created.
     */
    onAIColumnRequestCreating?: (
      e: DevExpress.ui.dxDataGrid.AIColumnRequestCreatingEvent
    ) => void;
  };
  /**
   * @deprecated Use DevExpress.ui.dxDataGrid.Row instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxDataGridRowObject<
    TRowData = any,
    TKey = any
  > = DevExpress.ui.dxDataGrid.Row<TRowData, TKey>;
  /**
   * The DateBox is a UI component that displays date and time in a specified format, and enables a user to pick or type in the required date/time value.
   */
  export class dxDateBox extends DateBoxBase<DevExpress.ui.dxDateBox.Properties> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxDateBox.Properties['value']): void;
  }
  module dxDateBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxDateBox>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxDateBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      ClipboardEvent
    >;
    export type DatePickerType = 'calendar' | 'list' | 'native' | 'rollers';
    export type DateType = 'date' | 'datetime' | 'time';
    export type DisabledDate =
      DevExpress.ui.dxCalendar.ComponentDisabledDate<dxDateBox>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDateBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDateBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxDateBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDateBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateBox,
      ClipboardEvent
    >;
    export type Properties = dxDateBoxOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxDateBox,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDateBoxOptions extends DateBoxBaseOptions<dxDateBox> {
    /**
     * Specifies whether or not adaptive UI component rendering is enabled on a small screen.
     */
    adaptivityEnabled?: boolean;
    /**
     * Specifies the message displayed if the specified date is later than the max value or earlier than the min value.
     */
    dateOutOfRangeMessage?: string;
    /**
     * Specifies dates that users cannot select. Applies only if pickerType is &apos;calendar&apos;.
     */
    disabledDates?:
      | Array<Date>
      | ((data: DevExpress.ui.dxDateBox.DisabledDate) => boolean);
    /**
     * Specifies the attributes to be passed on to the underlying HTML element.
     */
    inputAttr?: any;
    /**
     * Specifies the interval between neighboring values in the popup list in minutes.
     */
    interval?: number;
    /**
     * Specifies the message displayed if the typed value is not a valid date or time.
     */
    invalidDateMessage?: string;
    /**
     * Specifies a text string used to annotate the editor&apos;s value.
     */
    label?: string;
    /**
     * Specifies the maximum number of characters you can enter into the textbox.
     */
    maxLength?: string | number;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies the type of the date/time picker.
     */
    pickerType?: DevExpress.ui.dxDateBox.DatePickerType;
    /**
     * Specifies a placeholder for the input field.
     */
    placeholder?: string;
    /**
     * Specifies whether to show the analog clock in the value picker. Applies only if type is &apos;datetime&apos; and pickerType is &apos;calendar&apos;.
     */
    showAnalogClock?: boolean;
    /**
     * The read-only property that stores the text displayed by the UI component input element.
     */
    text?: string;
    /**
     * A format used to display date/time information.
     */
    type?: DevExpress.ui.dxDateBox.DateType;
    /**
     * Specifies the currently selected date and time.
     */
    value?: DevExpress.common.DateLike;
  }
  /**
   * DateRangeBox is a UI component that allows a user to select a date range (pick or enter start and end dates).
   */
  export class dxDateRangeBox extends DateRangeBoxBase {
    /**
     * Gets the `` element of the UI component&apos;s end date field.
     */
    endDateField(): DevExpress.core.DxElement;
    /**
     * Gets the `` element of the UI component&apos;s start date field.
     */
    startDateField(): DevExpress.core.DxElement;
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxDateRangeBox.Properties['value']): void;
  }
  module dxDateRangeBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent =
      DevExpress.common.core.events.NativeEventInfo<dxDateRangeBox>;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxDateRangeBox>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxDateRangeBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDateRangeBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDateRangeBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxDateRangeBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDateRangeBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDateRangeBox,
      ClipboardEvent
    >;
    /**
     * 
     */
    export type Properties = Omit<
      DateBoxBaseOptions<dxDateRangeBox>,
      'inputAttr' | 'label' | 'maxLength' | 'name' | 'placeholder' | 'text'
    > & {
      /**
       * Specifies whether the UI component disables date selection before the start date and after the end date.
       */
      disableOutOfRangeSelection?: boolean;
      /**
       * Specifies the range&apos;s end date.
       */
      endDate?: DevExpress.common.DateLike;
      /**
       * Specifies the attributes passed to the end date input field.
       */
      endDateInputAttr?: any;
      /**
       * Specifies the label of the end date input field.
       */
      endDateLabel?: string;
      /**
       * Specifies the name attribute of the end date input field.
       */
      endDateName?: string;
      /**
       * Specifies the message displayed if the specified end date is later than the max value or earlier than the min value.
       */
      endDateOutOfRangeMessage?: string;
      /**
       * Specifies a placeholder for the end date input field.
       */
      endDatePlaceholder?: string;
      /**
       * Returns the text displayed by the end date input field.
       */
      endDateText?: string;
      /**
       * Specifies a message for invalid end date input.
       */
      invalidEndDateMessage?: string;
      /**
       * Specifies a message for invalid start date input.
       */
      invalidStartDateMessage?: string;
      /**
       * Specifies whether the UI component displays a single-month calendar or a multi-month calendar.
       */
      multiView?: boolean;
      /**
       * Specifies whether a user can open the popup calendar by clicking an input field.
       */
      openOnFieldClick?: boolean;
      /**
       * Specifies the start date of date range.
       */
      startDate?: DevExpress.common.DateLike;
      /**
       * Specifies the attributes passed to the start date input field.
       */
      startDateInputAttr?: any;
      /**
       * Specifies a label of the start date input field.
       */
      startDateLabel?: string;
      /**
       * Specifies the name attribute of the start date input field.
       */
      startDateName?: string;
      /**
       * Specifies the message displayed if the specified start date is later than the max value or earlier than the min value.
       */
      startDateOutOfRangeMessage?: string;
      /**
       * Specifies a placeholder for the start date input field.
       */
      startDatePlaceholder?: string;
      /**
       * Returns the text displayed by the start date input field.
       */
      startDateText?: string;
      /**
       * An array that specifies the selected range (start and end dates).
       */
      value?: DevExpress.common.DateLike[];
    };
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxDateRangeBox,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * The Diagram UI component provides a visual interface to help you design new and modify existing diagrams.
   */
  export class dxDiagram extends Widget<dxDiagramOptions> {
    /**
     * Gets the DataSource instance.
     */
    getNodeDataSource(): DevExpress.common.data.DataSource;
    /**
     * Returns the DataSource instance.
     */
    getEdgeDataSource(): DevExpress.common.data.DataSource;
    /**
     * Returns a shape or connector object specified by its key.
     */
    getItemByKey(key: Object): DevExpress.ui.dxDiagram.Item;
    /**
     * Returns a shape or connector object specified by its internal identifier.
     */
    getItemById(id: string): DevExpress.ui.dxDiagram.Item;
    /**
     * Returns an array of diagram items.
     */
    getItems(): Array<DevExpress.ui.dxDiagram.Item>;
    /**
     * Returns an array of selected diagram items.
     */
    getSelectedItems(): Array<DevExpress.ui.dxDiagram.Item>;
    /**
     * Selects the specified items.
     */
    setSelectedItems(items: Array<DevExpress.ui.dxDiagram.Item>): void;
    /**
     * Scrolls the view area to the specified item.
     */
    scrollToItem(item: DevExpress.ui.dxDiagram.Item): void;
    /**
     * Exports the diagram data to a JSON object.
     */
    export(): string;
    /**
     * Exports the diagram to an image format.
     */
    exportTo(
      format: DevExpress.ui.dxDiagram.DiagramExportFormat,
      callback: Function
    ): void;
    /**
     * Imports the diagram data.
     */
    import(data: string, updateExistingItemsOnly?: boolean): void;
    /**
     * Updates the diagram toolboxes.
     */
    updateToolbox(): void;
    /**
     * Fits the diagram content into the work area. The maximum scale is 100%.
     */
    fitToContent(): void;
    /**
     * Fits the diagram content&apos;s width into the work area width. The maximum scale is 100%.
     */
    fitToWidth(): void;
  }
  module dxDiagram {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram>;
    /**
     * The type of the customCommand event handler&apos;s argument.
     */
    export type CustomCommandEvent = {
      /**
       * 
       */
      readonly component: dxDiagram;
      /**
       * 
       */
      readonly element: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly name: string;
    };
    export type CustomShapeTemplateData = {
      readonly item: dxDiagramShape;
    };
    export type CustomShapeToolboxTemplateData = {
      readonly item: dxDiagramShape;
    };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDiagram>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> & {
        /**
         * 
         */
        readonly item: Item;
      };
    /**
     * The type of the itemDblClick event handler&apos;s argument.
     */
    export type ItemDblClickEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> & {
        /**
         * 
         */
        readonly item: Item;
      };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxDiagramOptions;
    /**
     * The type of the requestEditOperation event handler&apos;s argument.
     */
    export type RequestEditOperationEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> & {
        /**
         * 
         */
        readonly operation:
          | 'addShape'
          | 'addShapeFromToolbox'
          | 'deleteShape'
          | 'deleteConnector'
          | 'changeConnection'
          | 'changeConnectorPoints';
        /**
         * 
         */
        readonly args:
          | dxDiagramAddShapeArgs
          | dxDiagramAddShapeFromToolboxArgs
          | dxDiagramDeleteShapeArgs
          | dxDiagramDeleteConnectorArgs
          | dxDiagramChangeConnectionArgs
          | dxDiagramChangeConnectorPointsArgs
          | dxDiagramBeforeChangeShapeTextArgs
          | dxDiagramChangeShapeTextArgs
          | dxDiagramBeforeChangeConnectorTextArgs
          | dxDiagramChangeConnectorTextArgs
          | dxDiagramResizeShapeArgs
          | dxDiagramMoveShapeArgs;
        /**
         * 
         */
        readonly reason: RequestEditOperationReason;
        /**
         * 
         */
        allowed?: boolean;
      };
    /**
     * The type of the requestLayoutUpdate event handler&apos;s argument.
     */
    export type RequestLayoutUpdateEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> & {
        /**
         * 
         */
        readonly changes: any[];
        /**
         * 
         */
        allowed?: boolean;
      };
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDiagram> & {
        /**
         * 
         */
        readonly items: Array<Item>;
      };
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramAddShapeArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
    /**
     * A position where the shape is being added.
     */
    position?: {
      /**
       * A horizontal position where the shape is being added.
       */
      x?: number;
      /**
       * A vertical position where the shape is being added.
       */
      y?: number;
    };
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramAddShapeFromToolboxArgs {
    /**
     * The type of the processed shape.
     */
    shapeType?: DevExpress.ui.dxDiagram.ShapeType | string;
  }
  /**
   * Contains information about the processed connector.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramBeforeChangeConnectorTextArgs {
    /**
     * The processed connector.
     */
    connector?: dxDiagramConnector;
    /**
     * The index of the processed text in the connector&apos;s texts collection.
     */
    index?: number;
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramBeforeChangeShapeTextArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
  }
  /**
   * Contains information about the processed connection.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramChangeConnectionArgs {
    /**
     * The new connected shape.
     */
    newShape?: dxDiagramShape;
    /**
     * The previous connected shape.
     */
    oldShape?: dxDiagramShape;
    /**
     * The processed connector.
     */
    connector?: dxDiagramConnector;
    /**
     * The index of the processed point in the shape&apos;s connection point collection.
     */
    connectionPointIndex?: number;
    /**
     * The position of the connector in the processed point.
     */
    connectorPosition?: DevExpress.ui.dxDiagram.ConnectorPosition;
  }
  /**
   * Contains information about the processed connector.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramChangeConnectorPointsArgs {
    /**
     * The processed connector.
     */
    connector?: dxDiagramConnector;
    /**
     * The array of new connection points.
     */
    newPoints?: Array<{
      /**
       * A horizontal position of the point.
       */
      x?: number;
      /**
       * A vertical position of the point.
       */
      y?: number;
    }>;
    /**
     * The array of previous connection points.
     */
    oldPoints?: Array<{
      /**
       * A horizontal position of the point.
       */
      x?: number;
      /**
       * A vertical position of the point.
       */
      y?: number;
    }>;
  }
  /**
   * Contains information about the processed connector.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramChangeConnectorTextArgs {
    /**
     * The processed connector.
     */
    connector?: dxDiagramConnector;
    /**
     * The index of the processed text in the connector&apos;s texts collection.
     */
    index?: number;
    /**
     * The new connector text.
     */
    text?: string;
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramChangeShapeTextArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
    /**
     * The new shape text.
     */
    text?: string;
  }
  /**
   * An object that provides information about a connector in the Diagram UI component.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramConnector extends DevExpress.ui.dxDiagram.Item {
    /**
     * Specifies the connector&apos;s start node key.
     */
    fromKey?: any;
    /**
     * Gets the connector&apos;s start node identifier.
     */
    fromId?: string;
    /**
     * The index of a shape connection point where the connector starts.
     */
    fromPointIndex?: number;
    /**
     * Gets the connector&apos;s key points.
     */
    points?: Array<{
      /**
       * A horizontal position of the point.
       */
      x?: number;
      /**
       * A vertical position of the point.
       */
      y?: number;
    }>;

    /**
     * Specifies the connector&apos;s text.
     */
    texts?: Array<string>;
    /**
     * Specifies the connector&apos;s end node key.
     */
    toKey?: any;
    /**
     * Gets the connector&apos;s end node identifier.
     */
    toId?: string;
    /**
     * The index of the shape connection point where the connector ends.
     */
    toPointIndex?: number;
  }
  /**
   * Contains information about the processed connector.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramDeleteConnectorArgs {
    /**
     * The processed connector.
     */
    connector?: dxDiagramConnector;
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramDeleteShapeArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramItem {
    /**
     * Returns the data item that is bound to the diagram item.
     */
    dataItem?: any;
    /**
     * Specifies the item&apos;s internal identifier.
     */
    id?: string;
    /**
     * Gets the item&apos;s key from a data source.
     */
    key?: Object;
    /**
     * Returns the type of the item.
     */
    itemType?: DevExpress.ui.dxDiagram.ItemType;
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramMoveShapeArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
    /**
     * The new shape position.
     */
    newPosition?: {
      /**
       * The new horizontal shape position specified in units.
       */
      x?: number;
      /**
       * The new vertical shape position specified in units.
       */
      y?: number;
    };
    /**
     * The previous shape position.
     */
    oldPosition?: {
      /**
       * The previous horizontal shape position specified in units.
       */
      x?: number;
      /**
       * The previous vertical shape position specified in units.
       */
      y?: number;
    };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramOptions extends WidgetOptions<dxDiagram> {
    /**
     * Specifies how the Diagram UI component automatically zooms the work area.
     */
    autoZoomMode?: DevExpress.ui.dxDiagram.AutoZoomMode;
    /**
     * Configures the context menu&apos;s settings.
     */
    contextMenu?: {
      /**
       * Lists commands in the context menu.
       */
      commands?: Array<
        DevExpress.ui.dxDiagram.CustomCommand | DevExpress.ui.dxDiagram.Command
      >;
      /**
       * Specifies whether the context menu is enabled.
       */
      enabled?: boolean;
    };
    /**
     * Configures the context toolbox&apos;s settings.
     */
    contextToolbox?: {
      /**
       * Specifies the category of shapes that are displayed in the context toolbox.
       */
      category?: DevExpress.ui.dxDiagram.ShapeCategory | string;
      /**
       * Specifies how shapes are displayed in the context toolbox.
       */
      displayMode?: DevExpress.ui.dxDiagram.ToolboxDisplayMode;
      /**
       * Specifies the context toolbox&apos;s availability.
       */
      enabled?: boolean;
      /**
       * Specifies the number of shape icons in a row.
       */
      shapeIconsPerRow?: number;
      /**
       * Lists the shapes that are displayed in the context toolbox. The built-in shape types are shown in the Shape Types section.
       */
      shapes?: Array<DevExpress.ui.dxDiagram.ShapeType> | Array<string>;
      /**
       * Specifies the context toolbox&apos;s width in pixels.
       */
      width?: number;
    };
    /**
     * A function that is executed after a custom command item was clicked and allows you to implement the custom command&apos;s logic.
     */
    onCustomCommand?: (e: DevExpress.ui.dxDiagram.CustomCommandEvent) => void;
    /**
     * Specifies a custom template for shapes.
     */
    customShapeTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement<SVGElement>,
          data: DevExpress.ui.dxDiagram.CustomShapeTemplateData
        ) => any);
    /**
     * Specifies a custom template for shapes in the toolbox.
     */
    customShapeToolboxTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement<SVGElement>,
          data: DevExpress.ui.dxDiagram.CustomShapeToolboxTemplateData
        ) => any);
    /**
     * Provide access to an array of custom shapes.
     */
    customShapes?: Array<{
      /**
       * Specifies whether a card shape&apos;s image can be edited.
       */
      allowEditImage?: boolean;
      /**
       * Specifies whether the shape&apos;s text can be edited.
       */
      allowEditText?: boolean;
      /**
       * Specifies whether the shape can be resized.
       */
      allowResize?: boolean;
      /**
       * Specifies the shape background image&apos;s fractional height.
       */
      backgroundImageHeight?: number;
      /**
       * Specifies the shape background image&apos;s left offset.
       */
      backgroundImageLeft?: number;
      /**
       * Specifies the shape background image&apos;s top offset.
       */
      backgroundImageTop?: number;
      /**
       * Specifies the shape background image&apos;s URL.
       */
      backgroundImageUrl?: string;
      /**
       * Specifies the shape image displayed in the toolbox.
       */
      backgroundImageToolboxUrl?: string;
      /**
       * Specifies the shape background image&apos;s fractional width.
       */
      backgroundImageWidth?: number;
      /**
       * Specifies the base shape type for the custom shape. The built-in shape types are shown in the Shape Types section.
       */
      baseType?: DevExpress.ui.dxDiagram.ShapeType | string;
      /**
       * Specifies a category to which the custom shape belongs.
       */
      category?: string;
      /**
       * An array of the shape&apos;s connection points.
       */
      connectionPoints?: Array<{
        /**
         * Specifies the horizontal offset.
         */
        x?: number;
        /**
         * Specifies the vertical offset.
         */
        y?: number;
      }>;
      /**
       * Specifies the initial height of the shape.
       */
      defaultHeight?: number;
      /**
       * Specifies the URL of an image displayed in a card shape.
       */
      defaultImageUrl?: string;
      /**
       * Specifies the initial text of the shape.
       */
      defaultText?: string;
      /**
       * Specifies the initial width of the shape.
       */
      defaultWidth?: number;
      /**
       * Specifies the shape image&apos;s fractional height.
       */
      imageHeight?: number;
      /**
       * Specifies the shape image&apos;s left offset.
       */
      imageLeft?: number;
      /**
       * Specifies the shape image&apos;s top offset.
       */
      imageTop?: number;
      /**
       * Specifies the shape image&apos;s fractional width.
       */
      imageWidth?: number;
      /**
       * Specifies whether the shape maintains its width-to-height ratio on auto resize.
       */
      keepRatioOnAutoSize?: boolean;
      /**
       * Specifies the maximum height of the shape.
       */
      maxHeight?: number;
      /**
       * Specifies the maximum width of the shape.
       */
      maxWidth?: number;
      /**
       * Specifies the maximum height of the shape.
       */
      minHeight?: number;
      /**
       * Specifies the minimum width of the shape.
       */
      minWidth?: number;
      /**
       * Specifies a custom template for the shape.
       */
      template?:
        | template
        | ((
            container: DevExpress.core.DxElement<SVGElement>,
            data: DevExpress.ui.dxDiagram.CustomShapeTemplateData
          ) => any);
      /**
       * Specifies the shape template&apos;s fractional height.
       */
      templateHeight?: number;
      /**
       * Specifies the shape template&apos;s left offset.
       */
      templateLeft?: number;
      /**
       * Specifies the shape template&apos;s top offset.
       */
      templateTop?: number;
      /**
       * Specifies the shape template&apos;s fractional width.
       */
      templateWidth?: number;
      /**
       * Specifies the shape text container&apos;s height.
       */
      textHeight?: number;
      /**
       * Specifies the shape text&apos;s left offset.
       */
      textLeft?: number;
      /**
       * Specifies the shape text&apos;s top offset.
       */
      textTop?: number;
      /**
       * Specifies the shape text container&apos;s width.
       */
      textWidth?: number;
      /**
       * Specifies the shape&apos;s tooltip in the toolbox panel.
       */
      title?: string;
      /**
       * Specifies a custom template for the shape in the toolbox.
       */
      toolboxTemplate?:
        | template
        | ((
            container: DevExpress.core.DxElement<SVGElement>,
            data: DevExpress.ui.dxDiagram.CustomShapeToolboxTemplateData
          ) => any);
      /**
       * Specifies the aspect ratio of the shape in the toolbox.
       */
      toolboxWidthToHeightRatio?: number;
      /**
       * Specifies the custom shape&apos;s identifier.
       */
      type?: string;
    }>;
    /**
     * Configures default item properties.
     */
    defaultItemProperties?: {
      /**
       * Specifies a default item style.
       */
      style?: Object;
      /**
       * Specifies an item&apos;s default text style.
       */
      textStyle?: Object;
      /**
       * Specifies the default type of a connector.
       */
      connectorLineType?: DevExpress.ui.dxDiagram.ConnectorLineType;
      /**
       * Specifies the default tip of a connector&apos;s start point.
       */
      connectorLineStart?: DevExpress.ui.dxDiagram.ConnectorLineEnd;
      /**
       * Specifies the default tip of a connector&apos;s end point.
       */
      connectorLineEnd?: DevExpress.ui.dxDiagram.ConnectorLineEnd;
      /**
       * Specifies the default minimum width of a shape.
       */
      shapeMinWidth?: number | undefined;
      /**
       * Specifies the default maximum width of a shape.
       */
      shapeMaxWidth?: number | undefined;
      /**
       * Specifies the default minimum height of a shape.
       */
      shapeMinHeight?: number | undefined;
      /**
       * Specifies the default maximum height of a shape.
       */
      shapeMaxHeight?: number | undefined;
    };
    /**
     * Specifies which editing operations a user can perform.
     */
    editing?: {
      /**
       * Specifies whether a user can add a shape.
       */
      allowAddShape?: boolean;
      /**
       * Specifies whether a user can delete a shape.
       */
      allowDeleteShape?: boolean;
      /**
       * Specifies whether a user can delete a connector.
       */
      allowDeleteConnector?: boolean;
      /**
       * Specifies whether a user can change a connection.
       */
      allowChangeConnection?: boolean;
      /**
       * Specifies whether a user can change connector points.
       */
      allowChangeConnectorPoints?: boolean;
      /**
       * Specifies whether a user can change a connector&apos;s text.
       */
      allowChangeConnectorText?: boolean;
      /**
       * Specifies whether a user can change a shape&apos;s text.
       */
      allowChangeShapeText?: boolean;
      /**
       * Specifies whether a user can resize a shape.
       */
      allowResizeShape?: boolean;
      /**
       * Specifies whether a user can move a shape.
       */
      allowMoveShape?: boolean;
    };
    /**
     * Allows you to bind the collection of diagram edges to a data source. For more information, see the Data Binding section.
     */
    edges?: {
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s custom data.
       */
      customDataExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Binds the edges collection to the specified data. Specify this property if you use node and edge data sources.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s start node key.
       */
      fromExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s line start tip.
       */
      fromLineEndExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an index of a shape connection point where an edge starts.
       */
      fromPointIndexExpr?:
        | string
        | ((data: any, value?: any) => any)
        | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s key.
       */
      keyExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s line type.
       */
      lineTypeExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression whose Boolean value indicates whether an edge is locked.
       */
      lockedExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s key points.
       */
      pointsExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge style.
       */
      styleExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns edge text.
       */
      textExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s text style.
       */
      textStyleExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s end node key.
       */
      toExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s line end tip.
       */
      toLineEndExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an index of a shape connection point where an edge ends.
       */
      toPointIndexExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an edge&apos;s z-index.
       */
      zIndexExpr?: string | ((data: any, value?: any) => any) | undefined;
    };
    /**
     * Configures export settings.
     */
    export?: {
      /**
       * Specifies the name of the file to which the diagram is exported.
       */
      fileName?: string;
    };
    /**
     * Specifies whether or not to display the UI component in full-screen mode.
     */
    fullScreen?: boolean;
    /**
     * Specifies the grid pitch.
     */
    gridSize?:
      | number
      | {
          /**
           * An array that specifies the _Grid Size_ combobox items on &apos;Properties&apos; panel.
           */
          items?: Array<number>;
          /**
           * Specifies the grid&apos;s pitch.
           */
          value?: number;
        };
    /**
     * Allows you to bind the collection of diagram nodes to a data source. For more information, see the Data Binding section.
     */
    nodes?: {
      /**
       * Specifies an auto-layout algorithm that the UI component uses to build a diagram.
       */
      autoLayout?:
        | DevExpress.ui.dxDiagram.DataLayoutType
        | {
            /**
             * Specifies the diagram layout orientation.
             */
            orientation?: DevExpress.common.Orientation;
            /**
             * Specifies an auto-layout algorithm that is used to automatically arrange shapes.
             */
            type?: DevExpress.ui.dxDiagram.DataLayoutType;
          };
      /**
       * Specifies whether or not a shape size is automatically changed to fit the text when the UI component is bound to a data source.
       */
      autoSizeEnabled?: boolean;
      /**
       * Specifies the name of a data source field or an expression that returns a key of a node&apos;s parent container node.
       */
      containerKeyExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns a container&apos;s nested items.
       */
      containerChildrenExpr?:
        | string
        | ((data: any, value?: any) => any)
        | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s custom data.
       */
      customDataExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Binds the nodes collection to the specified data. For more information, see the Data Binding section.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s height.
       */
      heightExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns an image URL or Base64 encoded image for a node.
       */
      imageUrlExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s child items.
       */
      itemsExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns node keys.
       */
      keyExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns the x-coordinate of a node&apos;s left border.
       */
      leftExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression whose Boolean value indicates whether a node is locked.
       */
      lockedExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns a parent node key for a node.
       */
      parentKeyExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns a node style.
       */
      styleExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns node texts.
       */
      textExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s text style.
       */
      textStyleExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns the y-coordinate of a node&apos;s top border.
       */
      topExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns the shape type for a node.
       */
      typeExpr?: string | ((data: any, value?: any) => any);
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s width.
       */
      widthExpr?: string | ((data: any, value?: any) => any) | undefined;
      /**
       * Specifies the name of a data source field or an expression that returns a node&apos;s z-index.
       */
      zIndexExpr?: string | ((data: any, value?: any) => any) | undefined;
    };
    /**
     * Indicates whether diagram content has unsaved changes.
     */
    hasChanges?: boolean;
    /**
     * A function that is executed after a shape or connector is clicked.
     */
    onItemClick?: (e: DevExpress.ui.dxDiagram.ItemClickEvent) => void;
    /**
     * A function that is executed after a shape or connector is double-clicked.
     */
    onItemDblClick?: (e: DevExpress.ui.dxDiagram.ItemDblClickEvent) => void;
    /**
     * A function that is executed after the selection is changed in the Diagram.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxDiagram.SelectionChangedEvent
    ) => void;
    /**
     * A function that allows you to prohibit an edit operation at run time.
     */
    onRequestEditOperation?: (
      e: DevExpress.ui.dxDiagram.RequestEditOperationEvent
    ) => void;
    /**
     * A function that allows you to specify whether or not the UI component should reapply its auto layout after diagram data is reloaded.
     */
    onRequestLayoutUpdate?: (
      e: DevExpress.ui.dxDiagram.RequestLayoutUpdateEvent
    ) => void;
    /**
     * Specifies the color of a diagram page.
     */
    pageColor?: string;
    /**
     * Specifies the page orientation.
     */
    pageOrientation?: DevExpress.common.PageOrientation;
    /**
     * Specifies a size of pages.
     */
    pageSize?: {
      /**
       * Specifies the page height.
       */
      height?: number;
      /**
       * An array that specifies the page size items in the _Page Size_ combobox on _Properties Panel_.
       */
      items?: Array<{
        /**
         * Specifies the page height.
         */
        height?: number;
        /**
         * Specifies the display text.
         */
        text?: string;
        /**
         * Specifies the page width.
         */
        width?: number;
      }>;
      /**
       * Specifies the page width.
       */
      width?: number;
    };
    /**
     * Configures the Properties panel settings.
     */
    propertiesPanel?: {
      /**
       * Contains an array of tabs in the Properties panel.
       */
      tabs?: Array<{
        /**
         * Lists commands in a tab.
         */
        commands?: Array<
          | DevExpress.ui.dxDiagram.CustomCommand
          | DevExpress.ui.dxDiagram.Command
        >;
        /**
         * Contains an array of command groups in the tab.
         */
        groups?: Array<{
          /**
           * Lists commands in a group.
           */
          commands?: Array<
            | DevExpress.ui.dxDiagram.CustomCommand
            | DevExpress.ui.dxDiagram.Command
          >;
          /**
           * Specifies a title of the group.
           */
          title?: string;
        }>;
        /**
         * Specifies the tab&apos;s title.
         */
        title?: string;
      }>;
      /**
       * Specifies the panel&apos;s visibility.
       */
      visibility?: DevExpress.ui.dxDiagram.PanelVisibility;
    };
    /**
     * Specifies whether the diagram is read-only.
     */
    readOnly?: boolean;
    /**
     * Specifies whether grid lines are visible.
     */
    showGrid?: boolean;
    /**
     * Switch the Diagram UI component to simple view mode.
     */
    simpleView?: boolean;
    /**
     * Specifies whether or not the UI component uses native scrolling.
     */
    useNativeScrolling?: boolean;
    /**
     * Specifies whether diagram elements should snap to grid lines.
     */
    snapToGrid?: boolean;
    /**
     * Configures the main toolbar settings.
     */
    mainToolbar?: {
      /**
       * Lists commands in the toolbar.
       */
      commands?: Array<
        DevExpress.ui.dxDiagram.CustomCommand | DevExpress.ui.dxDiagram.Command
      >;
      /**
       * Specifies the toolbar&apos;s visibility.
       */
      visible?: boolean;
    };
    /**
     * Configures the history toolbar&apos;s settings.
     */
    historyToolbar?: {
      /**
       * Lists commands in the history toolbar.
       */
      commands?: Array<
        DevExpress.ui.dxDiagram.CustomCommand | DevExpress.ui.dxDiagram.Command
      >;
      /**
       * Specifies the history toolbar&apos;s visibility.
       */
      visible?: boolean;
    };
    /**
     * Configures the view toolbar settings.
     */
    viewToolbar?: {
      /**
       * Lists commands in the toolbar.
       */
      commands?: Array<
        DevExpress.ui.dxDiagram.CustomCommand | DevExpress.ui.dxDiagram.Command
      >;
      /**
       * Specifies the view toolbar&apos;s visibility.
       */
      visible?: boolean;
    };
    /**
     * Configures the toolbox settings.
     */
    toolbox?: {
      /**
       * Lists toolbox groups.
       */
      groups?:
        | Array<{
            /**
             * Specifies the category of shapes that are displayed in the group.
             */
            category?: DevExpress.ui.dxDiagram.ShapeCategory | string;
            /**
             * Specifies how shapes are displayed in the toolbox.
             */
            displayMode?: DevExpress.ui.dxDiagram.ToolboxDisplayMode;
            /**
             * Specifies whether the group is expanded.
             */
            expanded?: boolean;
            /**
             * Lists the shapes in the group. The built-in shape types are shown in the Shape Types section.
             */
            shapes?: Array<DevExpress.ui.dxDiagram.ShapeType> | Array<string>;
            /**
             * Specifies the group title in the toolbox.
             */
            title?: string;
          }>
        | Array<DevExpress.ui.dxDiagram.ShapeCategory>;
      /**
       * Specifies the number of shape icons in a row.
       */
      shapeIconsPerRow?: number;
      /**
       * Specifies whether the search box is visible.
       */
      showSearch?: boolean;
      /**
       * Specifies the toolbar&apos;s visibility.
       */
      visibility?: DevExpress.ui.dxDiagram.PanelVisibility;
      /**
       * Specifies the toolbox&apos;s width in pixels.
       */
      width?: number | undefined;
    };
    /**
     * Specifies the measurement unit for size properties.
     */
    units?: DevExpress.ui.dxDiagram.Units;
    /**
     * Specifies the measurement unit that is displayed in user interface elements.
     */
    viewUnits?: DevExpress.ui.dxDiagram.Units;
    /**
     * Specifies the zoom level.
     */
    zoomLevel?:
      | number
      | {
          /**
           * An array that specifies the zoom level items in the _Zoom Level_ combobox on &apos;Properties&apos; panel.
           */
          items?: Array<number>;
          /**
           * Specifies the zoom level.
           */
          value?: number | undefined;
        };
  }
  /**
   * Contains information about the processed shape.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramResizeShapeArgs {
    /**
     * The processed shape.
     */
    shape?: dxDiagramShape;
    /**
     * The new shape size.
     */
    newSize?: {
      /**
       * The new shape height.
       */
      height?: number;
      /**
       * The new shape width.
       */
      width?: number;
    };
    /**
     * The previous shape size.
     */
    oldSize?: {
      /**
       * The previous shape height.
       */
      height?: number;
      /**
       * The previous shape width.
       */
      width?: number;
    };
  }
  /**
   * An object that provides information about a shape in the Diagram UI component.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDiagramShape extends DevExpress.ui.dxDiagram.Item {
    /**
     * Specifies the shape&apos;s text.
     */
    text?: string;
    /**
     * Specifies the shape type. The built-in shape types are shown in the Shape Types section.
     */
    type?: DevExpress.ui.dxDiagram.ShapeType | string;
    /**
     * Specifies the position of the top left shape corner relative to the top left corner of the diagram work area.
     */
    position?: {
      /**
       * The horizontal shape position specified in units.
       */
      x?: number;
      /**
       * The vertical shape position specified in units.
       */
      y?: number;
    };

    /**
     * Specifies the shape size.
     */
    size?: {
      /**
       * The shape height specified in units.
       */
      height?: number;
      /**
       * The shape width specified in units.
       */
      width?: number;
    };
    /**
     * Gets an array of attached connector identifiers.
     */
    attachedConnectorIds?: Array<String>;
    /**
     * Gets the identifier of the container that stores the shape.
     */
    containerId?: string;
    /**
     * Gets identifiers of shapes stored in the container.
     */
    containerChildItemIds?: Array<String>;
    /**
     * Gets whether the container is expanded.
     */
    containerExpanded?: boolean;
  }
  /**
   * Draggable is a user interface utility that allows UI component elements to be dragged and dropped.
   */
  export class dxDraggable
    extends DOMComponent<dxDraggableOptions>
    implements DraggableBase {}
  module dxDraggable {
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDraggable>;
    /**
     * The type of the dragEnd event handler&apos;s argument.
     */
    export type DragEndEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxDraggable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly itemData?: any;
        /**
         * 
         */
        readonly itemElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly toComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly fromData?: any;
        /**
         * 
         */
        readonly toData?: any;
      };
    /**
     * The type of the dragMove event handler&apos;s argument.
     */
    export type DragMoveEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxDraggable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly itemData?: any;
        /**
         * 
         */
        readonly itemElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly toComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly fromData?: any;
        /**
         * 
         */
        readonly toData?: any;
      };
    /**
     * The type of the dragStart event handler&apos;s argument.
     */
    export type DragStartEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxDraggable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        itemData?: any;
        /**
         * 
         */
        readonly itemElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromData?: any;
      };
    export type DragTemplateData = {
      readonly itemData?: any;
      readonly itemElement: DevExpress.core.DxElement;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDraggable>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDraggable> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxDraggableOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDraggableOptions
    extends DraggableBaseOptions<dxDraggable> {
    /**
     * Allows a user to drag clones of items instead of actual items.
     */
    clone?: boolean;
    /**
     * Specifies custom markup to be shown instead of the item being dragged.
     */
    dragTemplate?:
      | template
      | ((
          dragInfo: DevExpress.ui.dxDraggable.DragTemplateData,
          containerElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement)
      | undefined;
    /**
     * A function that is called when a drag gesture is finished.
     */
    onDragEnd?: (e: DevExpress.ui.dxDraggable.DragEndEvent) => void;
    /**
     * A function that is called every time a draggable item is moved.
     */
    onDragMove?: (e: DevExpress.ui.dxDraggable.DragMoveEvent) => void;
    /**
     * A function that is called when a drag gesture is initialized.
     */
    onDragStart?: (e: DevExpress.ui.dxDraggable.DragStartEvent) => void;
  }
  /**
   * The Drawer is a dismissible or permanently visible panel used for navigation in responsive web application layouts.
   */
  export class dxDrawer extends Widget<dxDrawerOptions> {
    /**
     * Gets the drawer&apos;s content.
     */
    content(): DevExpress.core.DxElement;
    /**
     * Closes the drawer.
     */
    hide(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Opens the drawer.
     */
    show(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Opens or closes the drawer, reversing the current state.
     */
    toggle(): DevExpress.core.utils.DxPromise<void>;
  }
  module dxDrawer {
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDrawer>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDrawer>;
    export type OpenedStateMode = 'overlap' | 'shrink' | 'push';
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDrawer> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type PanelLocation =
      | 'left'
      | 'right'
      | 'top'
      | 'bottom'
      | 'before'
      | 'after';
    export type Properties = dxDrawerOptions;
    export type RevealMode = 'slide' | 'expand';
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDrawerOptions extends WidgetOptions<dxDrawer> {
    /**
     * Specifies the duration of the drawer&apos;s opening and closing animation (in milliseconds). Applies only if animationEnabled is true.
     */
    animationDuration?: number;
    /**
     * Specifies whether to use an opening and closing animation.
     */
    animationEnabled?: boolean;
    /**
     * Specifies whether to close the drawer if a user clicks or taps the view area.
     */
    closeOnOutsideClick?:
      | boolean
      | ((
          event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>
        ) => boolean);
    /**
     * Specifies the drawer&apos;s width or height (depending on the drawer&apos;s position) in the opened state.
     */
    maxSize?: number;
    /**
     * Specifies the drawer&apos;s width or height (depending on the drawer&apos;s position) in the closed state.
     */
    minSize?: number;
    /**
     * Specifies whether the drawer is opened.
     */
    opened?: boolean;
    /**
     * Specifies how the drawer interacts with the view in the opened state.
     */
    openedStateMode?: DevExpress.ui.dxDrawer.OpenedStateMode;
    /**
     * Specifies the drawer&apos;s position in relation to the view.
     */
    position?: DevExpress.ui.dxDrawer.PanelLocation;
    /**
     * Specifies the drawer&apos;s reveal mode.
     */
    revealMode?: DevExpress.ui.dxDrawer.RevealMode;
    /**
     * Specifies whether to shade the view when the drawer is opened.
     */
    shading?: boolean;
    /**
     * Specifies the drawer&apos;s content.
     */
    template?: template | ((Element: DevExpress.core.DxElement) => any);
  }
  /**
   * The DropDownBox UI component consists of a text field, which displays the current value, and a drop-down field, which can contain any UI element.
   */
  export class dxDropDownBox extends dxDropDownEditor<dxDropDownBoxOptions> {
    getDataSource(): DevExpress.common.data.DataSource;
  }
  module dxDropDownBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownBox>;
    export type ContentTemplateData = {
      component: dxDropDownBox;
      readonly value?: any;
    };
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDropDownBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownBox,
      ClipboardEvent
    >;
    export type Properties = dxDropDownBoxOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxDropDownBox,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDropDownBoxOptions
    extends DataExpressionMixinOptions<dxDropDownBox>,
      dxDropDownEditorOptions<dxDropDownBox> {
    /**
     * Specifies whether the UI component allows a user to enter a custom value.
     */
    acceptCustomValue?: boolean;
    /**
     * Specifies a custom template for the drop-down content.
     */
    contentTemplate?:
      | template
      | ((
          templateData: DevExpress.ui.dxDropDownBox.ContentTemplateData,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<any> | null;
    /**
     * Customizes text before it is displayed in the input field.
     */
    displayValueFormatter?: (value: string | Array<any>) => string;
    /**
     * Specifies a custom template for the text field. Must contain the TextBox UI component.
     * @deprecated Use the fieldAddons option instead.
     */
    fieldTemplate?:
      | template
      | ((
          value: any,
          fieldElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * An array of items used to synchronize the DropDownBox with an embedded UI component.
     */
    items?: Array<any>;
    /**
     * Specifies whether a user can open the drop-down list by clicking a text field.
     */
    openOnFieldClick?: boolean;
    /**
     * Specifies the DOM events after which the UI component&apos;s value should be updated.
     */
    valueChangeEvent?: string;

    /**
     * Configures the drop-down field which holds the content.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
  }
  /**
   * The DropDownButton is a button that opens a drop-down menu.
   */
  export class dxDropDownButton extends Widget<dxDropDownButtonOptions> {
    /**
     * Closes the drop-down menu.
     */
    close(): DevExpress.core.utils.DxPromise<void>;
    getDataSource(): DevExpress.common.data.DataSource;
    /**
     * Opens the drop-down menu.
     */
    open(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Opens or closes the drop-down menu, reversing the current state.
     */
    toggle(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Opens or closes the drop-down menu, depending on the argument.
     */
    toggle(visibility: boolean): DevExpress.core.utils.DxPromise<void>;
  }
  module dxDropDownButton {
    /**
     * The type of the buttonClick event handler&apos;s argument.
     */
    export type ButtonClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxDropDownButton,
        KeyboardEvent | MouseEvent | PointerEvent
      > & {
        /**
         * 
         */
        readonly selectedItem?: any;
      };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownButton>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownButton>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxDropDownButton>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxDropDownButton,
      KeyboardEvent | MouseEvent | PointerEvent
    > & {
      /**
       * 
       */
      readonly itemData?: any;
      /**
       * 
       */
      readonly itemElement: DevExpress.core.DxElement;
    };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownButton> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxDropDownButtonOptions;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxDropDownButton> & {
        /**
         * 
         */
        readonly item: any;
        /**
         * 
         */
        readonly previousItem: any;
      };
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDropDownButtonItem extends DevExpress.ui.dxList.Item {
    /**
     * A handler for the click event raised for a certain item in the drop-down field.
     */
    onClick?:
      | ((e: DevExpress.ui.dxDropDownButton.ItemClickEvent) => void)
      | string;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDropDownButtonOptions
    extends WidgetOptions<dxDropDownButton> {
    /**
     * Provides data for the drop-down menu.
     */
    dataSource?: DevExpress.data.DataSourceLike<
      DevExpress.ui.dxDropDownButton.Item | any
    > | null;
    /**
     * Specifies whether to wait until the drop-down menu is opened the first time to render its content. Specifies whether to render the view&apos;s content when it is displayed. If false, the content is rendered immediately.
     */
    deferRendering?: boolean;
    /**
     * Specifies the data field whose values should be displayed in the drop-down menu.
     */
    displayExpr?: string | ((itemData: any) => string) | undefined;
    /**
     * Specifies custom content for the drop-down field.
     */
    dropDownContentTemplate?:
      | template
      | ((
          data:
            | Array<string | number | any>
            | DevExpress.common.data.DataSource,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Configures the drop-down field.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
    /**
     * Specifies whether users can use keyboard to focus the UI component.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user hovers the mouse pointer over it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the button&apos;s icon.
     */
    icon?: string | undefined;
    /**
     * Specifies a custom template for drop-down menu items.
     */
    itemTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Provides drop-down menu items.
     */
    items?: Array<DevExpress.ui.dxDropDownButton.Item | any>;
    /**
     * Specifies which data field provides keys used to distinguish between the selected drop-down menu items.
     */
    keyExpr?: string;
    /**
     * Specifies the text or HTML markup displayed in the drop-down menu when it does not contain any items.
     */
    noDataText?: string;
    /**
     * A function that is executed when the button is clicked or tapped. If splitButton is true, this function is executed for the action button only.
     */
    onButtonClick?:
      | ((e: DevExpress.ui.dxDropDownButton.ButtonClickEvent) => void)
      | string;
    /**
     * A function that is executed when a drop-down menu item is clicked.
     */
    onItemClick?:
      | ((e: DevExpress.ui.dxDropDownButton.ItemClickEvent) => void)
      | string;
    /**
     * A function that is executed when an item is selected or selection is canceled. In effect when useSelectMode is true.
     */
    onSelectionChanged?:
      | ((e: DevExpress.ui.dxDropDownButton.SelectionChangedEvent) => void)
      | string;
    /**
     * Specifies whether the drop-down menu is opened.
     */
    opened?: boolean;
    /**
     * Contains the selected item&apos;s data. Available when useSelectMode is true.
     */
    selectedItem?: string | number | any;
    /**
     * Contains the selected item&apos;s key and allows you to specify the initially selected item. Applies when useSelectMode is true.
     */
    selectedItemKey?: string | number;
    /**
     * Specifies whether the arrow icon should be displayed.
     */
    showArrowIcon?: boolean;
    /**
     * Specifies whether to split the button in two: one executes an action, the other opens and closes the drop-down menu.
     */
    splitButton?: boolean;
    /**
     * Specifies how the button is styled.
     */
    stylingMode?: DevExpress.common.ButtonStyle;
    /**
     * Specifies a custom template for the base button in DropDownButton.
     */
    template?:
      | template
      | ((
          data: DevExpress.ui.dxButton.TemplateData,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the button&apos;s text. Applies only if useSelectMode is false.
     */
    text?: string;
    /**
     * Specifies the drop-down button type.
     */
    type?: DevExpress.common.ButtonType | string;
    /**
     * Specifies whether the UI component stores the selected drop-down menu item.
     */
    useSelectMode?: boolean;
    /**
     * Specifies whether text that exceeds the drop-down list width should be wrapped.
     */
    wrapItemText?: boolean;
    /**
     * Specifies whether the widget uses item&apos;s text a title attribute.
     */
    useItemTextAsTitle?: boolean;
  }
  /**
   * A drop-down editor UI component.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxDropDownEditor<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue = DevExpress.ui.dxDropDownEditor.Properties
  > extends dxTextBox<TProperties> {
    /**
     * Closes the drop-down editor.
     */
    close(): void;
    /**
     * Gets the popup window&apos;s content.
     */
    content(): DevExpress.core.DxElement;
    /**
     * Gets the UI component&apos;s `` element.
     */
    field(): DevExpress.core.DxElement;
    /**
     * Opens the drop-down editor.
     */
    open(): void;
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: TProperties['value']): void;
  }
  module dxDropDownEditor {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface DropDownButtonTemplateDataModel {
      readonly text?: string;
      readonly icon?: string;
    }
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface DropDownEditorInstance extends dxDropDownEditor<Properties> {}
    export type DropDownPredefinedButton = 'clear' | 'dropDown';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type Properties = dxDropDownEditorOptions<DropDownEditorInstance>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDropDownEditorOptions<TComponent>
    extends Omit<dxTextBoxOptions<TComponent>, 'validationMessagePosition'> {
    /**
     * Specifies whether or not the UI component allows an end user to enter a custom value.
     */
    acceptCustomValue?: boolean;
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies the way an end user applies the selected value.
     */
    applyValueMode?: DevExpress.common.ApplyValueMode;
    /**
     * Configures the drop-down field which holds the content.
     */
    dropDownOptions?:
      | DevExpress.ui.dxPopup.Properties
      | DevExpress.ui.dxPopover.Properties;
    /**
     * Allows you to add custom buttons to the input text field.
     */
    buttons?: Array<
      | DevExpress.ui.dxDropDownEditor.DropDownPredefinedButton
      | DevExpress.common.TextEditorButton
    >;
    /**
     * Specifies whether to render the drop-down field&apos;s content when it is displayed. If false, the content is rendered immediately.
     */
    deferRendering?: boolean;
    /**
     * Specifies a custom template for the drop-down button.
     */
    dropDownButtonTemplate?:
      | template
      | ((
          buttonData: DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies widget input field addons.
     */
    fieldAddons?: FieldAddons;
    /**
     * A function that is executed once the drop-down editor is closed.
     */
    onClosed?: (e: DevExpress.common.core.events.EventInfo<TComponent>) => void;
    /**
     * A function that is executed once the drop-down editor is opened.
     */
    onOpened?: (e: DevExpress.common.core.events.EventInfo<TComponent>) => void;
    /**
     * Specifies whether a user can open the drop-down list by clicking a text field.
     */
    openOnFieldClick?: boolean;
    /**
     * Specifies whether or not the drop-down editor is displayed.
     */
    opened?: boolean;
    /**
     * Specifies whether the drop-down button is visible.
     */
    showDropDownButton?: boolean;
    /**
     * Specifies the position of a validation message relative to the component. The validation message describes the validation rules that this component&apos;s value does not satisfy.
     */
    validationMessagePosition?:
      | DevExpress.common.Position
      | DevExpress.common.Mode;
    /**
     * Specifies the currently selected value.
     */
    value?: any;
  }
  /**
   * A base class for drop-down list UI components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxDropDownList<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue
  > extends dxDropDownEditor<TProperties> {
    getDataSource(): DevExpress.common.data.DataSource;
  }
  module dxDropDownList {
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface SelectionChangedInfo<T = any> {
      /**
       * 
       */
      readonly selectedItem: T;
    }
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxDropDownListOptions<TComponent>
    extends DataExpressionMixinOptions<TComponent>,
      Omit<dxDropDownEditorOptions<TComponent>, 'fieldAddons'> {
    /**
     * Returns the value currently displayed by the UI component.
     */
    displayValue?: string | undefined;
    /**
     * Specifies a custom template for group captions.
     */
    groupTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether data items should be grouped.
     */
    grouped?: boolean;
    /**
     * The minimum number of characters that must be entered into the text box to begin a search. Applies only if searchEnabled is true.
     */
    minSearchLength?: number;
    /**
     * Specifies the text or HTML markup displayed by the UI component if the item collection is empty.
     */
    noDataText?: string;
    /**
     * A function that is executed when a list item is clicked or tapped.
     */
    onItemClick?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent | MouseEvent | PointerEvent
      > &
        DevExpress.common.core.events.ItemInfo
    ) => void;
    /**
     * A function that is executed when a list item is selected or selection is canceled.
     */
    onSelectionChanged?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.ui.dxDropDownList.SelectionChangedInfo
    ) => void;
    /**
     * A function that is executed after the UI component&apos;s value is changed.
     */
    onValueChanged?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo
    ) => void;
    /**
     * Specifies whether to allow search operations.
     */
    searchEnabled?: boolean;
    /**
     * Specifies the name of a data source item field or an expression whose value is compared to the search criterion.
     */
    searchExpr?: string | Function | Array<string | Function>;
    /**
     * Specifies a comparison operation used to search UI component items.
     */
    searchMode?: DevExpress.common.SimplifiedSearchMode;
    /**
     * Specifies the time delay, in milliseconds, after the last character has been typed in, before a search is executed.
     */
    searchTimeout?: number;
    /**
     * Gets the currently selected item.
     */
    selectedItem?: any;
    /**
     * Specifies whether or not the UI component displays unfiltered values until a user types a number of characters exceeding the minSearchLength property value.
     */
    showDataBeforeSearch?: boolean;
    /**
     * Specifies the currently selected value. May be an object if dataSource contains objects, the store key is specified, and valueExpr is not set.
     */
    value?: any;
    /**
     * Specifies the DOM events after which the UI component&apos;s value should be updated.
     */
    valueChangeEvent?: string;
    /**
     * Specifies whether text that exceeds the drop-down list width should be wrapped.
     */
    wrapItemText?: boolean;
    /**
     * Specifies whether the widget uses item&apos;s text a title attribute.
     */
    useItemTextAsTitle?: boolean;
  }
  /**
   * The FileManager is a UI component that allows users to upload, select, and manage files and directories in different file storages.
   */
  export class dxFileManager extends Widget<dxFileManagerOptions> {
    /**
     * Gets the current directory object.
     */
    getCurrentDirectory(): any;
    /**
     * Gets the selected items.
     */
    getSelectedItems(): Array<any>;
    /**
     * Reloads data and repaints the UI component.
     */
    refresh(): DevExpress.core.utils.DxPromise<any>;
  }
  module dxFileManager {
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ActionEventInfo {
      /**
       * 
       */
      errorCode?: number;
      /**
       * 
       */
      errorText: string;
      /**
       * 
       */
      cancel: boolean | PromiseLike<void>;
    }
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager>;
    /**
     * The type of the contextMenuItemClick event handler&apos;s argument.
     */
    export type ContextMenuItemClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxFileManager,
        KeyboardEvent | PointerEvent | MouseEvent
      > & {
        /**
         * 
         */
        readonly itemData: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly itemIndex: number;
        /**
         * 
         */
        readonly fileSystemItem?: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly viewArea: FileManagerViewArea;
      };
    /**
     * The type of the contextMenuShowing event handler&apos;s argument.
     */
    export type ContextMenuShowingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.NativeEventInfo<
          dxFileManager,
          KeyboardEvent | PointerEvent | MouseEvent
        > & {
          /**
           * 
           */
          readonly fileSystemItem?: DevExpress.fileManagement.FileSystemItem;
          /**
           * 
           */
          readonly targetElement?: DevExpress.core.DxElement;
          /**
           * 
           */
          readonly viewArea: FileManagerViewArea;
        };
    /**
     * The type of the currentDirectoryChanged event handler&apos;s argument.
     */
    export type CurrentDirectoryChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly directory: DevExpress.fileManagement.FileSystemItem;
      };
    /**
     * The type of the directoryCreated event handler&apos;s argument.
     */
    export type DirectoryCreatedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly parentDirectory: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly name: string;
      };
    /**
     * The type of the directoryCreating event handler&apos;s argument.
     */
    export type DirectoryCreatingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly parentDirectory: DevExpress.fileManagement.FileSystemItem;
          /**
           * 
           */
          readonly name: string;
        };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager>;
    /**
     * The type of the errorOccurred event handler&apos;s argument.
     */
    export type ErrorOccurredEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly errorCode?: number;
        /**
         * 
         */
        errorText?: string;
        /**
         * 
         */
        readonly fileSystemItem?: DevExpress.fileManagement.FileSystemItem;
      };
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type FileManagerItemViewMode = 'details' | 'thumbnails';
    export type FileManagerPredefinedContextMenuItem =
      | 'create'
      | 'upload'
      | 'refresh'
      | 'download'
      | 'move'
      | 'copy'
      | 'rename'
      | 'delete';
    export type FileManagerPredefinedToolbarItem =
      | 'showNavPane'
      | 'create'
      | 'upload'
      | 'refresh'
      | 'switchView'
      | 'download'
      | 'move'
      | 'copy'
      | 'rename'
      | 'delete'
      | 'clearSelection'
      | 'separator';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type FileManagerViewArea = 'navPane' | 'itemView';
    /**
     * The type of the fileUploaded event handler&apos;s argument.
     */
    export type FileUploadedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly fileData: File;
        /**
         * 
         */
        readonly parentDirectory: DevExpress.fileManagement.FileSystemItem;
      };
    /**
     * The type of the fileUploading event handler&apos;s argument.
     */
    export type FileUploadingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly fileData: File;
          /**
           * 
           */
          readonly destinationDirectory: DevExpress.fileManagement.FileSystemItem;
        };
    /**
     * The type of the focusedItemChanged event handler&apos;s argument.
     */
    export type FocusedItemChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly item?: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly itemElement?: DevExpress.core.DxElement;
      };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxFileManager>;
    /**
     * The type of the itemCopied event handler&apos;s argument.
     */
    export type ItemCopiedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly sourceItem: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly parentDirectory: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly itemName: string;
        /**
         * 
         */
        readonly itemPath: string;
      };
    /**
     * The type of the itemCopying event handler&apos;s argument.
     */
    export type ItemCopyingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly item: DevExpress.fileManagement.FileSystemItem;
          /**
           * 
           */
          readonly destinationDirectory: DevExpress.fileManagement.FileSystemItem;
        };
    /**
     * The type of the itemDeleted event handler&apos;s argument.
     */
    export type ItemDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly item: DevExpress.fileManagement.FileSystemItem;
      };
    /**
     * The type of the itemDeleting event handler&apos;s argument.
     */
    export type ItemDeletingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly item: DevExpress.fileManagement.FileSystemItem;
        };
    /**
     * The type of the itemDownloading event handler&apos;s argument.
     */
    export type ItemDownloadingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly item: DevExpress.fileManagement.FileSystemItem;
        };
    /**
     * The type of the itemMoved event handler&apos;s argument.
     */
    export type ItemMovedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly sourceItem: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly parentDirectory: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly itemName: string;
        /**
         * 
         */
        readonly itemPath: string;
      };
    /**
     * The type of the itemMoving event handler&apos;s argument.
     */
    export type ItemMovingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly item: DevExpress.fileManagement.FileSystemItem;
          /**
           * 
           */
          readonly destinationDirectory: DevExpress.fileManagement.FileSystemItem;
        };
    /**
     * The type of the itemRenamed event handler&apos;s argument.
     */
    export type ItemRenamedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly sourceItem: DevExpress.fileManagement.FileSystemItem;
        /**
         * 
         */
        readonly itemName: string;
      };
    /**
     * The type of the itemRenaming event handler&apos;s argument.
     */
    export type ItemRenamingEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        ActionEventInfo & {
          /**
           * 
           */
          readonly item: DevExpress.fileManagement.FileSystemItem;
          /**
           * 
           */
          readonly newName: string;
        };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxFileManagerOptions;
    /**
     * The type of the selectedFileOpened event handler&apos;s argument.
     */
    export type SelectedFileOpenedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly file: DevExpress.fileManagement.FileSystemItem;
      };
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFileManager> & {
        /**
         * 
         */
        readonly currentSelectedItemKeys: Array<string>;
        /**
         * 
         */
        readonly currentDeselectedItemKeys: Array<string>;
        /**
         * 
         */
        readonly selectedItems: Array<DevExpress.fileManagement.FileSystemItem>;
        /**
         * 
         */
        readonly selectedItemKeys: Array<string>;
      };
    /**
     * The type of the toolbarItemClick event handler&apos;s argument.
     */
    export type ToolbarItemClickEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxFileManager,
        PointerEvent | MouseEvent
      > & {
        /**
         * 
         */
        readonly itemData: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly itemIndex: number;
      };
  }
  /**
   * Configures the context menu.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerContextMenu {
    /**
     * Configures context menu items&apos; settings.
     */
    items?: Array<
      | DevExpress.ui.dxFileManager.ContextMenuItem
      | DevExpress.ui.dxFileManager.FileManagerPredefinedContextMenuItem
    >;
  }
  /**
   * @deprecated Use DevExpress.ui.dxFileManager.ContextMenuItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerContextMenuItem
    extends DevExpress.ui.dxContextMenu.Item {
    /**
     * Configures settings of a context menu item&apos;s subitems.
     */
    items?: Array<DevExpress.ui.dxFileManager.ContextMenuItem>;
    /**
     * Specifies the context menu item&apos;s name.
     */
    name?:
      | DevExpress.ui.dxFileManager.FileManagerPredefinedContextMenuItem
      | string;
    /**
     * Specifies the context menu item&apos;s visibility.
     */
    visible?: boolean | undefined;
    /**
     * 
     */
    template?: template | (() => string | DevExpress.core.UserDefinedElement);
  }
  /**
   * Configures the column.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerDetailsColumn {
    /**
     * Specifies the column alignment.
     */
    alignment?: DevExpress.common.HorizontalAlignment | undefined;
    /**
     * Specifies the column caption.
     */
    caption?: string | undefined;
    /**
     * Specifies a CSS class to be applied to the column.
     */
    cssClass?: string | undefined;
    /**
     * Specifies which data field provides data for the column.
     */
    dataField?: string | undefined;
    /**
     * Casts column values to a specific data type.
     */
    dataType?: DevExpress.common.DataType | undefined;
    /**
     * Specifies the order in which columns are hidden when the UI component adapts to the screen or container size.
     */
    hidingPriority?: number | undefined;
    /**
     * Specifies the order in which the column is sorted.
     */
    sortIndex?: number | undefined;
    /**
     * Specifies the sort order of column values.
     */
    sortOrder?: DevExpress.common.SortOrder | undefined;
    /**
     * Specifies the column visibility.
     */
    visible?: boolean;
    /**
     * Specifies the position of the column in the resulting UI component.
     */
    visibleIndex?: number | undefined;
    /**
     * Specifies the column width.
     */
    width?: number | string | undefined;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerOptions extends WidgetOptions<dxFileManager> {
    /**
     * Specifies the allowed upload file extensions.
     */
    allowedFileExtensions?: Array<string>;
    /**
     * Configures the context menu settings.
     */
    contextMenu?: dxFileManagerContextMenu;
    /**
     * Specifies the path that is used when the FileManager is initialized.
     */
    currentPath?: string;
    /**
     * Specifies an array of path keys to the current location.
     */
    currentPathKeys?: Array<string>;
    /**
     * Customizes columns in details view. Applies only if itemView.mode is &apos;details&apos;.
     */
    customizeDetailColumns?: (
      columns: Array<dxFileManagerDetailsColumn>
    ) => Array<dxFileManagerDetailsColumn>;
    /**
     * Allows you to provide custom icons to be used as thumbnails.
     */
    customizeThumbnail?: (
      fileSystemItem: DevExpress.fileManagement.FileSystemItem
    ) => string;
    /**
     * Specifies the file system provider.
     */
    fileSystemProvider?: any;
    /**
     * Configures the file and directory view.
     */
    itemView?: {
      /**
       * Configures the &apos;Details&apos; file system representation mode.
       */
      details?: {
        /**
         * Configures the columns.
         */
        columns?: Array<dxFileManagerDetailsColumn | string>;
      };
      /**
       * Specifies the file system representation mode.
       */
      mode?: DevExpress.ui.dxFileManager.FileManagerItemViewMode;
      /**
       * Specifies whether to display folders in the view. When this property is false, folders are displayed in the navigation pane only.
       */
      showFolders?: boolean;
      /**
       * Specifies whether to display the parent directory in the view.
       */
      showParentFolder?: boolean;
    };
    /**
     * Configures notification settings.
     */
    notifications?: {
      /**
       * Specifies whether to show the progress panel.
       */
      showPanel?: boolean;
      /**
       * Specifies whether to show the pop-up notification window.
       */
      showPopup?: boolean;
    };
    /**
     * A function that is executed when a context menu item is clicked.
     */
    onContextMenuItemClick?: (
      e: DevExpress.ui.dxFileManager.ContextMenuItemClickEvent
    ) => void;
    /**
     * A function that is executed before a context menu is displayed.
     */
    onContextMenuShowing?: (
      e: DevExpress.ui.dxFileManager.ContextMenuShowingEvent
    ) => void;
    /**
     * A function that is executed when the current directory is changed.
     */
    onCurrentDirectoryChanged?: (
      e: DevExpress.ui.dxFileManager.CurrentDirectoryChangedEvent
    ) => void;
    /**
     * A function that is executed when the selected file is opened.
     */
    onSelectedFileOpened?: (
      e: DevExpress.ui.dxFileManager.SelectedFileOpenedEvent
    ) => void;
    /**
     * A function that is executed when a file system item is selected or selection is canceled.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxFileManager.SelectionChangedEvent
    ) => void;
    /**
     * A function that is executed when a toolbar item is clicked.
     */
    onToolbarItemClick?: (
      e: DevExpress.ui.dxFileManager.ToolbarItemClickEvent
    ) => void;
    /**
     * A function that is executed when the focused item is changed.
     */
    onFocusedItemChanged?: (
      e: DevExpress.ui.dxFileManager.FocusedItemChangedEvent
    ) => void;
    /**
     * A function that is executed when an error occurs.
     */
    onErrorOccurred?: (
      e: DevExpress.ui.dxFileManager.ErrorOccurredEvent
    ) => void;
    /**
     * A function that is executed before a directory is created.
     */
    onDirectoryCreating?: (
      e: DevExpress.ui.dxFileManager.DirectoryCreatingEvent
    ) => void;
    /**
     * A function that is executed when a directory is created.
     */
    onDirectoryCreated?: (
      e: DevExpress.ui.dxFileManager.DirectoryCreatedEvent
    ) => void;
    /**
     * A function that is executed before a file or directory is renamed.
     */
    onItemRenaming?: (e: DevExpress.ui.dxFileManager.ItemRenamingEvent) => void;
    /**
     * A function that is executed when a file or directory is renamed.
     */
    onItemRenamed?: (e: DevExpress.ui.dxFileManager.ItemRenamedEvent) => void;
    /**
     * A function that is executed before a file or directory is moved.
     */
    onItemMoving?: (e: DevExpress.ui.dxFileManager.ItemMovingEvent) => void;
    /**
     * A function that is executed when a file or directory is moved.
     */
    onItemMoved?: (e: DevExpress.ui.dxFileManager.ItemMovedEvent) => void;
    /**
     * A function that is executed before a file or directory is copied.
     */
    onItemCopying?: (e: DevExpress.ui.dxFileManager.ItemCopyingEvent) => void;
    /**
     * A function that is executed when a file or directory is copied.
     */
    onItemCopied?: (e: DevExpress.ui.dxFileManager.ItemCopiedEvent) => void;
    /**
     * A function that is executed before a file or directory is deleted.
     */
    onItemDeleting?: (e: DevExpress.ui.dxFileManager.ItemDeletingEvent) => void;
    /**
     * A function that is executed when a file or directory is deleted.
     */
    onItemDeleted?: (e: DevExpress.ui.dxFileManager.ItemDeletedEvent) => void;
    /**
     * A function that is executed before the file is uploaded.
     */
    onFileUploading?: (
      e: DevExpress.ui.dxFileManager.FileUploadingEvent
    ) => void;
    /**
     * A function that is executed when a file is successfully uploaded.
     */
    onFileUploaded?: (e: DevExpress.ui.dxFileManager.FileUploadedEvent) => void;
    /**
     * A function that is executed before a file is downloaded.
     */
    onItemDownloading?: (
      e: DevExpress.ui.dxFileManager.ItemDownloadingEvent
    ) => void;
    /**
     * Specifies actions that a user is allowed to perform on files and directories.
     */
    permissions?: {
      /**
       * Specifies whether a user is allowed to copy files and directories.
       */
      copy?: boolean;
      /**
       * Specifies whether a user is allowed to create files and directories.
       */
      create?: boolean;
      /**
       * Specifies whether a user is allowed to download files.
       */
      download?: boolean;
      /**
       * Specifies whether a user is allowed to move files and directories.
       */
      move?: boolean;
      /**
       * Specifies whether a user is allowed to delete files and directories.
       */
      delete?: boolean;
      /**
       * Specifies whether a user is allowed to rename files and directories.
       */
      rename?: boolean;
      /**
       * Specifies whether a user is allowed to upload files.
       */
      upload?: boolean;
    };
    /**
     * Specifies the root directory display name.
     */
    rootFolderName?: string;
    /**
     * Specifies whether a user can select a single or multiple files and directories in the item view simultaneously.
     */
    selectionMode?: DevExpress.common.SingleOrMultiple;
    /**
     * Contains an array of initially or currently selected files and directories&apos; keys.
     */
    selectedItemKeys?: Array<string>;
    /**
     * Specifies a key of the initially or currently focused item.
     */
    focusedItemKey?: string;
    /**
     * Configures toolbar settings.
     */
    toolbar?: dxFileManagerToolbar;
    /**
     * Configures upload settings.
     */
    upload?: {
      /**
       * Specifies the maximum upload file size, in bytes.
       */
      maxFileSize?: number;
      /**
       * Specifies a chunk size, in bytes.
       */
      chunkSize?: number;
    };
  }
  /**
   * Configures the toolbar.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerToolbar {
    /**
     * Configures settings of the toolbar items that are visible when users select files.
     */
    fileSelectionItems?: Array<
      | DevExpress.ui.dxFileManager.ToolbarItem
      | DevExpress.ui.dxFileManager.FileManagerPredefinedToolbarItem
    >;
    /**
     * Configures toolbar items&apos; settings.
     */
    items?: Array<
      | DevExpress.ui.dxFileManager.ToolbarItem
      | DevExpress.ui.dxFileManager.FileManagerPredefinedToolbarItem
    >;
  }
  /**
   * @deprecated Use ToolbarItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileManagerToolbarItem
    extends DevExpress.ui.dxToolbar.Item {
    /**
     * Specifies the icon to be displayed on the toolbar item.
     */
    icon?: string;
    /**
     * Specifies the toolbar item&apos;s location.
     */
    location?: DevExpress.common.ToolbarItemLocation;
    /**
     * Specifies the toolbar item&apos;s name.
     */
    name?:
      | DevExpress.ui.dxFileManager.FileManagerPredefinedToolbarItem
      | string;
    /**
     * Specifies the toolbar item&apos;s visibility.
     */
    visible?: boolean | undefined;
    /**
     * 
     */
    html?: string;
    /**
     * 
     */
    template?: template | (() => string | DevExpress.core.UserDefinedElement);
    /**
     * 
     */
    menuItemTemplate?:
      | template
      | (() => string | DevExpress.core.UserDefinedElement);
  }
  /**
   * The FileUploader UI component enables an end user to upload files to the server. An end user can select files in the file explorer or drag and drop files to the FileUploader area on the page.
   */
  export class dxFileUploader extends Editor<dxFileUploaderOptions> {
    /**
     * Uploads all the selected files.
     */
    upload(): void;
    /**
     * Uploads a file with the specified index.
     */
    upload(fileIndex: number): void;
    /**
     * Uploads the specified file.
     */
    upload(file: File): void;
    /**
     * Cancels the file upload.
     */
    abortUpload(): void;
    /**
     * Cancels the file upload.
     */
    abortUpload(fileIndex: number): void;
    /**
     * Cancels the file upload.
     */
    abortUpload(file: File): void;
    /**
     * Removes a file with the specified index.
     */
    removeFile(fileIndex: number): void;
    /**
     * Removes a file.
     */
    removeFile(file: File): void;
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxFileUploader.Properties['value']): void;
  }
  module dxFileUploader {
    /**
     * The type of the beforeSend event handler&apos;s argument.
     */
    export type BeforeSendEvent =
      DevExpress.common.core.events.EventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly request: XMLHttpRequest;
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly uploadInfo?: DevExpress.fileManagement.UploadInfo;
      };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxFileUploader>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxFileUploader>;
    /**
     * The type of the dropZoneEnter event handler&apos;s argument.
     */
    export type DropZoneEnterEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxFileUploader,
        PointerEvent | MouseEvent
      > & {
        /**
         * 
         */
        readonly dropZoneElement: DevExpress.core.DxElement;
      };
    /**
     * The type of the dropZoneLeave event handler&apos;s argument.
     */
    export type DropZoneLeaveEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxFileUploader,
        PointerEvent | MouseEvent
      > & {
        /**
         * 
         */
        readonly dropZoneElement: DevExpress.core.DxElement;
      };
    /**
     * The type of the filesUploaded event handler&apos;s argument.
     */
    export type FilesUploadedEvent =
      DevExpress.common.core.events.EventInfo<dxFileUploader>;
    export type FileUploadMode = 'instantly' | 'useButtons' | 'useForm';
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxFileUploader>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFileUploader> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the progress event handler&apos;s argument.
     */
    export type ProgressEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly segmentSize: number;
        /**
         * 
         */
        readonly bytesLoaded: number;
        /**
         * 
         */
        readonly bytesTotal: number;
        /**
         * 
         */
        readonly request: XMLHttpRequest;
      };
    export type Properties = dxFileUploaderOptions;
    /**
     * The type of the uploadAborted event handler&apos;s argument.
     */
    export type UploadAbortedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly request: XMLHttpRequest;
        /**
         * 
         */
        message: string;
      };
    /**
     * The type of the uploaded event handler&apos;s argument.
     */
    export type UploadedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly request: XMLHttpRequest;
        /**
         * 
         */
        message: string;
      };
    /**
     * The type of the uploadError event handler&apos;s argument.
     */
    export type UploadErrorEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly request: XMLHttpRequest;
        /**
         * 
         */
        readonly error: any;
        /**
         * 
         */
        message: string;
      };
    export type UploadHttpMethod = 'POST' | 'PUT';
    /**
     * The type of the uploadStarted event handler&apos;s argument.
     */
    export type UploadStartedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly file: File;
        /**
         * 
         */
        readonly request: XMLHttpRequest;
      };
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxFileUploader> & {
        /**
         * 
         */
        readonly value?: Array<File>;
        /**
         * 
         */
        readonly previousValue?: Array<File>;
      };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFileUploaderOptions extends EditorOptions<dxFileUploader> {
    /**
     * A function that cancels the file upload.
     */
    abortUpload?: (
      file: File,
      uploadInfo?: DevExpress.fileManagement.UploadInfo
    ) => PromiseLike<any> | any;
    /**
     * Specifies file types users can select in the Open File dialog. The default value accepts all file types.
     */
    accept?: string;
    /**
     * Specifies if an end user can remove a file from the selection and interrupt uploading.
     */
    allowCanceling?: boolean;
    /**
     * Restricts file extensions that can be uploaded to the server.
     */
    allowedFileExtensions?: Array<string>;
    /**
     * Specifies the chunk size in bytes. Applies only if uploadMode is &apos;instantly&apos; or &apos;useButtons&apos;. Requires a server that can process file chunks.
     */
    chunkSize?: number;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the FileUploader component changes the state of all its buttons when users hover over them.
     */
    hoverStateEnabled?: boolean;
    /**
     * The text displayed when the extension of the file being uploaded is not an allowed file extension.
     */
    invalidFileExtensionMessage?: string;
    /**
     * The text displayed when the size of the file being uploaded is greater than the maxFileSize.
     */
    invalidMaxFileSizeMessage?: string;
    /**
     * The text displayed when the size of the file being uploaded is less than the minFileSize.
     */
    invalidMinFileSizeMessage?: string;
    /**
     * Specifies the attributes to be passed on to the underlying `` element of the `file` type.
     */
    inputAttr?: any;
    /**
     * Specifies the text displayed on the area to which an end user can drop a file.
     */
    labelText?: string;
    /**
     * Specifies the maximum file size (in bytes) allowed for uploading. Applies only if uploadMode is &apos;instantly&apos; or &apos;useButtons&apos;.
     */
    maxFileSize?: number;
    /**
     * Specifies the minimum file size (in bytes) allowed for uploading. Applies only if uploadMode is &apos;instantly&apos; or &apos;useButtons&apos;.
     */
    minFileSize?: number;
    /**
     * Specifies whether the UI component enables an end user to select a single file or multiple files.
     */
    multiple?: boolean;
    /**
     * Specifies the value passed to the name attribute of the underlying input element. Required to access uploaded files on the server.
     */
    name?: string;
    /**
     * A function that allows you to customize the request before it is sent to the server.
     */
    onBeforeSend?: (e: DevExpress.ui.dxFileUploader.BeforeSendEvent) => void;
    /**
     * A function that is executed when the mouse enters a drop zone while dragging a file.
     */
    onDropZoneEnter?: (
      e: DevExpress.ui.dxFileUploader.DropZoneEnterEvent
    ) => void;
    /**
     * A function that is executed when the mouse leaves a drop zone as it drags a file.
     */
    onDropZoneLeave?: (
      e: DevExpress.ui.dxFileUploader.DropZoneLeaveEvent
    ) => void;
    /**
     * A function that is executed when the file upload process is complete.
     */
    onFilesUploaded?: (
      e: DevExpress.ui.dxFileUploader.FilesUploadedEvent
    ) => void;
    /**
     * A function that is executed when a file segment is uploaded.
     */
    onProgress?: (e: DevExpress.ui.dxFileUploader.ProgressEvent) => void;
    /**
     * A function that is executed when the file upload is aborted.
     */
    onUploadAborted?: (
      e: DevExpress.ui.dxFileUploader.UploadAbortedEvent
    ) => void;
    /**
     * A function that is executed when an error occurs during the file upload.
     */
    onUploadError?: (e: DevExpress.ui.dxFileUploader.UploadErrorEvent) => void;
    /**
     * A function that is executed when the file upload is started.
     */
    onUploadStarted?: (
      e: DevExpress.ui.dxFileUploader.UploadStartedEvent
    ) => void;
    /**
     * A function that is executed when a file is successfully uploaded.
     */
    onUploaded?: (e: DevExpress.ui.dxFileUploader.UploadedEvent) => void;
    /**
     * A function that is executed when one or several files are added to or removed from the selection.
     */
    onValueChanged?: (
      e: DevExpress.ui.dxFileUploader.ValueChangedEvent
    ) => void;
    /**
     * Gets the current progress in percentages.
     */
    progress?: number;
    /**
     * The message displayed by the UI component when it is ready to upload the specified files.
     */
    readyToUploadMessage?: string;
    /**
     * The text displayed on the button that opens the file browser.
     */
    selectButtonText?: string;
    /**
     * Specifies whether or not the UI component displays the list of selected files.
     */
    showFileList?: boolean;
    /**
     * Specifies the HTML element which invokes the file upload dialog.
     */
    dialogTrigger?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies the HTML element in which users can drag and drop files for upload.
     */
    dropZone?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * The text displayed on the button that starts uploading.
     */
    uploadButtonText?: string;
    /**
     * A function that uploads a file in chunks.
     */
    uploadChunk?: (
      file: File,
      uploadInfo: DevExpress.fileManagement.UploadInfo
    ) => PromiseLike<any> | any;
    /**
     * The message displayed by the UI component on uploading failure.
     */
    uploadFailedMessage?: string;
    /**
     * The message displayed by the UI component when the file upload is cancelled.
     */
    uploadAbortedMessage?: string;
    /**
     * A function that uploads a file.
     */
    uploadFile?: (
      file: File,
      progressCallback: Function
    ) => PromiseLike<any> | any;
    /**
     * Specifies headers for the upload request.
     */
    uploadHeaders?: any;
    /**
     * Specifies custom data for the upload request.
     */
    uploadCustomData?: any;
    /**
     * Specifies the method for the upload request.
     */
    uploadMethod?: DevExpress.ui.dxFileUploader.UploadHttpMethod;
    /**
     * Specifies how the UI component uploads files.
     */
    uploadMode?: DevExpress.ui.dxFileUploader.FileUploadMode;
    /**
     * Specifies a target Url for the upload request.
     */
    uploadUrl?: string;
    /**
     * The message displayed by the UI component when uploading is finished.
     */
    uploadedMessage?: string;
    /**
     * Specifies a File instance representing the selected file. Read-only when uploadMode is &apos;useForm&apos;.
     */
    value?: Array<File>;
  }
  /**
   * The FilterBuilder UI component allows a user to build complex filter expressions with an unlimited number of filter conditions, combined by logical operations using the UI.
   */
  export class dxFilterBuilder extends Widget<dxFilterBuilderOptions> {
    /**
     * Gets a filter expression that contains only operations supported by the DataSource.
     */
    getFilterExpression(): string | Array<any> | Function;
  }
  module dxFilterBuilder {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxFilterBuilder>;
    export type CustomOperation = dxFilterBuilderCustomOperation;
    export type CustomOperationEditorTemplate = {
      readonly value?: string | number | Date;
      readonly field: Field;
      readonly setValue: Function;
    };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxFilterBuilder>;
    /**
     * The type of the editorPrepared event handler&apos;s argument.
     */
    export type EditorPreparedEvent =
      DevExpress.common.core.events.EventInfo<dxFilterBuilder> & {
        /**
         * 
         */
        readonly value?: any;
        /**
         * 
         */
        readonly setValue: any;
        /**
         * 
         */
        readonly editorElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly editorName: string;
        /**
         * 
         */
        readonly dataField?: string;
        /**
         * 
         */
        readonly filterOperation?: string;
        /**
         * 
         */
        updateValueTimeout?: number;
        /**
         * 
         */
        readonly width?: number;
        /**
         * 
         */
        readonly readOnly: boolean;
        /**
         * 
         */
        readonly disabled: boolean;
        /**
         * 
         */
        readonly rtlEnabled: boolean;
      };
    /**
     * The type of the editorPreparing event handler&apos;s argument.
     */
    export type EditorPreparingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxFilterBuilder> & {
          /**
           * 
           */
          readonly value?: any;
          /**
           * 
           */
          readonly setValue: any;
          /**
           * 
           */
          readonly editorElement?: DevExpress.core.DxElement;
          /**
           * 
           */
          editorName: string;
          /**
           * 
           */
          editorOptions?: any;
          /**
           * 
           */
          readonly dataField?: string;
          /**
           * 
           */
          readonly filterOperation?: string;
          /**
           * 
           */
          updateValueTimeout?: number;
          /**
           * 
           */
          readonly width?: number;
          /**
           * 
           */
          readonly readOnly: boolean;
          /**
           * 
           */
          readonly disabled: boolean;
          /**
           * 
           */
          readonly rtlEnabled: boolean;
        };
    export type FieldEditorTemplate = {
      readonly value?: string | number | Date;
      readonly filterOperation?: string;
      readonly field: Field;
      readonly setValue: Function;
    };
    /**
     * Information about a FilterBuilder field.
     */
    export type FieldInfo = {
      /**
       * Unformatted field value (set in the editor).
       */
      value?: string | number | Date;
      /**
       * The value with the format applied.
       */
      valueText?: string;
      /**
       * Field configuration.
       */
      field?: Field;
    };
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type FilterBuilderOperation =
      | '='
      | '<>'
      | '<'
      | '<='
      | '>'
      | '>='
      | 'contains'
      | 'endswith'
      | 'isblank'
      | 'isnotblank'
      | 'notcontains'
      | 'startswith'
      | 'between';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type FilterLookupDataSource<T> = Exclude<
      DevExpress.data.DataSourceLike<T>,
      string | DevExpress.common.data.DataSource
    >;
    export type GroupOperation = 'and' | 'or' | 'notAnd' | 'notOr';
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxFilterBuilder>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFilterBuilder> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxFilterBuilderOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.EventInfo<dxFilterBuilder> & {
        /**
         * 
         */
        readonly value?: any;
        /**
         * 
         */
        readonly previousValue?: any;
      };
  }
  /**
   * @deprecated Use the CustomOperation type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFilterBuilderCustomOperation {
    /**
     * Specifies a function that returns a filter expression for this custom operation.
     */
    calculateFilterExpression?: (
      filterValue: any,
      field: Field
    ) => string | Array<any> | Function;
    /**
     * Specifies the operation&apos;s caption.
     */
    caption?: string | undefined;
    /**
     * Customizes the field value&apos;s text representation.
     */
    customizeText?: (
      fieldInfo: DevExpress.ui.dxFilterBuilder.FieldInfo
    ) => string;
    /**
     * Specifies for which data types the operation is available by default.
     */
    dataTypes?: Array<DevExpress.common.DataType> | undefined;
    /**
     * Specifies a custom template for the UI component used to edit the field value.
     */
    editorTemplate?:
      | template
      | ((
          conditionInfo: DevExpress.ui.dxFilterBuilder.CustomOperationEditorTemplate,
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether the operation can have a value. If it can, the editor is displayed.
     */
    hasValue?: boolean;
    /**
     * Specifies the icon that should represent the filter operation.
     */
    icon?: string | undefined;
    /**
     * Specifies the operation&apos;s identifier.
     */
    name?: string | undefined;
  }
  /**
   * @deprecated Use the Field type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFilterBuilderField {
    /**
     * Specifies the field&apos;s custom rules to filter data.
     */
    calculateFilterExpression?: (
      filterValue: any,
      selectedFilterOperation: string
    ) => string | Array<any> | Function;
    /**
     * Specifies the data field&apos;s caption.
     */
    caption?: string | undefined;
    /**
     * Customizes the input value&apos;s display text.
     */
    customizeText?: (
      fieldInfo: DevExpress.ui.dxFilterBuilder.FieldInfo
    ) => string;
    /**
     * Specifies the name of a field to be filtered.
     */
    dataField?: string | undefined;
    /**
     * Casts field values to a specific data type.
     */
    dataType?: DevExpress.common.DataType;
    /**
     * Configures the UI component used to edit the field value.
     */
    editorOptions?: any;
    /**
     * Specifies the editor&apos;s custom template.
     */
    editorTemplate?:
      | template
      | ((
          conditionInfo: DevExpress.ui.dxFilterBuilder.FieldEditorTemplate,
          container: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the false value text. Applies only if dataType is &apos;boolean&apos;.
     */
    falseText?: string;
    /**
     * Specifies a set of available filter operations.
     */
    filterOperations?: Array<
      DevExpress.ui.dxFilterBuilder.FilterBuilderOperation | string
    >;
    /**
     * Formats a value before it is displayed.
     */
    format?: DevExpress.common.core.localization.Format;
    /**
     * Configures the lookup field.
     */
    lookup?: {
      /**
       * Specifies whether to display the Clear button in the lookup field while it is being edited.
       */
      allowClearing?: boolean;
      /**
       * Specifies the lookup data source.
       */
      dataSource?:
        | DevExpress.ui.dxFilterBuilder.FilterLookupDataSource<any>
        | null
        | undefined;
      /**
       * Specifies the data field whose values should be displayed.
       */
      displayExpr?: string | ((data: any) => string) | undefined;
      /**
       * Specifies the data field whose values should be replaced with values from the displayExpr field.
       */
      valueExpr?:
        | string
        | ((data: any) => string | number | boolean)
        | undefined;
    };
    /**
     * Specifies the field&apos;s name. Use it to distinguish the field from other fields when they have identical dataField values.
     */
    name?: string | undefined;
    /**
     * Specifies the true value text. Applies only if dataType is &apos;boolean&apos;.
     */
    trueText?: string;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFilterBuilderOptions
    extends WidgetOptions<dxFilterBuilder> {
    /**
     * Specifies whether the UI component can display hierarchical data fields.
     */
    allowHierarchicalFields?: boolean;
    /**
     * Configures custom filter operations.
     */
    customOperations?: Array<DevExpress.ui.dxFilterBuilder.CustomOperation>;
    /**
     * Configures fields.
     */
    fields?: Array<Field>;
    /**
     * Specifies filter operation descriptions.
     */
    filterOperationDescriptions?: {
      /**
       * The &apos;between&apos; operation&apos;s description.
       */
      between?: string;
      /**
       * The &apos;contains&apos; operation&apos;s description.
       */
      contains?: string;
      /**
       * The &apos;endswith&apos; operation&apos;s description.
       */
      endsWith?: string;
      /**
       * The &apos;=&apos; operation&apos;s description.
       */
      equal?: string;
      /**
       * The &apos;&gt;&apos; operation&apos;s description.
       */
      greaterThan?: string;
      /**
       * The &apos;&gt;=&apos; operation&apos;s description.
       */
      greaterThanOrEqual?: string;
      /**
       * The &apos;isblank&apos; operation&apos;s description.
       */
      isBlank?: string;
      /**
       * The &apos;isnotblank&apos; operation&apos;s description.
       */
      isNotBlank?: string;
      /**
       * The &apos;&lt;&apos; operation&apos;s description.
       */
      lessThan?: string;
      /**
       * The &apos;&lt;=&apos; operation&apos;s description.
       */
      lessThanOrEqual?: string;
      /**
       * The &apos;notcontains&apos; operation&apos;s description.
       */
      notContains?: string;
      /**
       * The &apos;&lt;&gt;&apos; operation&apos;s description.
       */
      notEqual?: string;
      /**
       * The &apos;startswith&apos; operation&apos;s description.
       */
      startsWith?: string;
    };
    /**
     * Specifies group operation descriptions.
     */
    groupOperationDescriptions?: {
      /**
       * The &apos;and&apos; operation&apos;s description.
       */
      and?: string;
      /**
       * The &apos;notand&apos; operation&apos;s description.
       */
      notAnd?: string;
      /**
       * The &apos;notor&apos; operation&apos;s description.
       */
      notOr?: string;
      /**
       * The &apos;or&apos; operation&apos;s description.
       */
      or?: string;
    };
    /**
     * Specifies a set of available group operations.
     */
    groupOperations?: Array<DevExpress.ui.dxFilterBuilder.GroupOperation>;
    /**
     * Specifies groups&apos; maximum nesting level.
     */
    maxGroupLevel?: number | undefined;
    /**
     * A function that is executed after an editor is created.
     */
    onEditorPrepared?: (
      e: DevExpress.ui.dxFilterBuilder.EditorPreparedEvent
    ) => void;
    /**
     * A function that is executed before an editor is created.
     */
    onEditorPreparing?: (
      e: DevExpress.ui.dxFilterBuilder.EditorPreparingEvent
    ) => void;
    /**
     * A function that is executed after the UI component&apos;s value is changed.
     */
    onValueChanged?: (
      e: DevExpress.ui.dxFilterBuilder.ValueChangedEvent
    ) => void;
    /**
     * Allows you to specify a filter.
     */
    value?: string | Array<any> | Function;
  }
  /**
   * The Form UI component represents fields of a data object as a collection of label-editor pairs. These pairs can be arranged in several groups, tabs and columns.
   */
  export class dxForm extends Widget<dxFormOptions> {
    /**
     * Gets a button&apos;s instance.
     */
    getButton(name: string): dxButton | undefined;
    /**
     * Gets an editor instance. Takes effect only if the form item is visible.
     */
    getEditor(dataField: string): Editor | undefined;
    /**
     * Gets a form item&apos;s configuration.
     */
    itemOption(id: string): any;
    /**
     * Updates the value of a single item option.
     */
    itemOption(id: string, option: string, value: any): void;
    /**
     * Updates the values of several item properties.
     */
    itemOption(id: string, options: any): void;
    /**
     * Resets editor values to their default values.
     */
    clear(): void;
    /**
     * Resets editors to specified or initial values.
     */
    reset(editorsData?: Record<string, any>): void;
    /**
     * Populates the Form with AI-generated values based on supplied text.
     */
    smartPaste(text?: string): void;
    /**
     * Merges the passed `data` object with formData. Matching properties in formData are overwritten and new properties added.
     */
    updateData(data: any): void;
    /**
     * Updates a formData field and the corresponding editor.
     */
    updateData(dataField: string, value: any): void;
    /**
     * Updates the dimensions of the UI component contents.
     */
    updateDimensions(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Validates the values of all editors on the form against the list of the validation rules specified for each form item.
     */
    validate(): DevExpress.ui.dxValidationGroup.ValidationResult;
  }
  module dxForm {
    export type AIResult = Record<
      string,
      DevExpress.aiIntegration.SmartPasteResultFieldType
    >;
    /**
     * The argument type in the contentReady event.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxForm>;
    /**
     * The argument type in the disposing event.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxForm>;
    /**
     * The argument type in the editorEnterKey event.
     */
    export type EditorEnterKeyEvent =
      DevExpress.common.core.events.EventInfo<dxForm> & {
        /**
         * 
         */
        readonly dataField?: string;
      };
    /**
     * The argument type in the fieldDataChanged event.
     */
    export type FieldDataChangedEvent =
      DevExpress.common.core.events.EventInfo<dxForm> & {
        /**
         * 
         */
        readonly dataField?: string;
        /**
         * 
         */
        readonly value?: any;
      };
    export type FormItemComponent =
      | 'dxAutocomplete'
      | 'dxCalendar'
      | 'dxCheckBox'
      | 'dxColorBox'
      | 'dxDateBox'
      | 'dxDateRangeBox'
      | 'dxDropDownBox'
      | 'dxHtmlEditor'
      | 'dxLookup'
      | 'dxNumberBox'
      | 'dxRadioGroup'
      | 'dxRangeSlider'
      | 'dxSelectBox'
      | 'dxSlider'
      | 'dxSwitch'
      | 'dxTagBox'
      | 'dxTextArea'
      | 'dxTextBox';
    export type FormItemType =
      | 'empty'
      | 'group'
      | 'simple'
      | 'tabbed'
      | 'button';
    export type FormLabelMode = 'static' | 'floating' | 'hidden' | 'outside';
    export type FormPredefinedButtonItem = 'reset' | 'submit' | 'smartPaste';
    export type GroupCaptionTemplateData = {
      readonly caption?: string;
      readonly component: dxForm;
      readonly name?: string;
    };
    export type GroupItemTemplateData = {
      readonly component: dxForm;
      readonly formData?: any;
    };
    /**
     * The argument type in the initialized event.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxForm>;
    export type LabelLocation = 'left' | 'right' | 'top';
    /**
     * The argument type in the optionChanged event.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxForm> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxFormOptions;
    export type SimpleItemLabelTemplateData = SimpleItemTemplateData & {
      text: string;
    };
    export type SimpleItemTemplateData = {
      readonly component: dxForm;
      readonly dataField?: string;
      readonly editorOptions?: any;
      readonly editorType?: string;
      readonly name?: string;
    };
    /**
     * The argument type in the smartPasted event.
     */
    export type SmartPastedEvent =
      DevExpress.common.core.events.EventInfo<dxForm> & SmartPasteInfo;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type SmartPasteInfo = {
      /**
       * Specifies Smart Paste results. Data from this object populates the Form.
       */
      readonly aiResult: AIResult;
    };
    /**
     * The argument type in the smartPasting event.
     */
    export type SmartPastingEvent =
      DevExpress.common.core.events.EventInfo<dxForm> &
        DevExpress.common.core.events.AsyncCancelable &
        SmartPasteInfo;
  }
  /**
   * @deprecated Use ButtonItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormButtonItem {
    /**
     * Configures the button.
     */
    buttonOptions?: dxButtonOptions | undefined;
    /**
     * Specifies how many columns the item spans.
     */
    colSpan?: number | undefined;
    /**
     * Specifies a CSS class to be applied to the item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the button&apos;s horizontal alignment.
     */
    horizontalAlignment?: DevExpress.common.HorizontalAlignment;
    /**
     * Specifies the item&apos;s type. Set it to &apos;button&apos; to create a button item.
     */
    itemType?: DevExpress.ui.dxForm.FormItemType;
    /**
     * Specifies the item&apos;s identifier.
     */
    name?: DevExpress.ui.dxForm.FormPredefinedButtonItem | string | undefined;
    /**
     * Specifies the button&apos;s vertical alignment.
     */
    verticalAlignment?: DevExpress.common.VerticalAlignment;
    /**
     * Specifies whether the item is visible.
     */
    visible?: boolean;
    /**
     * Specifies the item&apos;s position regarding other items in a group, tab, or the whole UI component.
     */
    visibleIndex?: number | undefined;
  }
  /**
   * @deprecated Use EmptyItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormEmptyItem {
    /**
     * Specifies the number of columns spanned by the item.
     */
    colSpan?: number | undefined;
    /**
     * Specifies a CSS class to be applied to the form item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the item&apos;s type. Set it to &apos;empty&apos; to create an empty item.
     */
    itemType?: DevExpress.ui.dxForm.FormItemType;
    /**
     * Specifies a name that identifies the form item.
     */
    name?: string | undefined;
    /**
     * Specifies whether or not the current form item is visible.
     */
    visible?: boolean;
    /**
     * Specifies the sequence number of the item in a form, group or tab.
     */
    visibleIndex?: number | undefined;
  }
  /**
   * @deprecated Use GroupItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormGroupItem {
    /**
     * Specifies whether or not all group item labels are aligned.
     */
    alignItemLabels?: boolean;
    /**
     * Specifies the group caption.
     */
    caption?: string | undefined;
    /**
     * Specifies a template that can be used to replace group captions with custom content.
     */
    captionTemplate?:
      | template
      | ((
          data: DevExpress.ui.dxForm.GroupCaptionTemplateData,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * The count of columns in the group layout.
     */
    colCount?: number;
    /**
     * Specifies the relation between the screen size qualifier and the number of columns in the grouped layout.
     */
    colCountByScreen?: any | undefined;
    /**
     * Specifies the number of columns spanned by the item.
     */
    colSpan?: number | undefined;
    /**
     * Specifies a CSS class to be applied to the form item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the item&apos;s type. Set it to &apos;group&apos; to create a group item.
     */
    itemType?: DevExpress.ui.dxForm.FormItemType;
    /**
     * Holds an array of form items displayed within the group.
     */
    items?: Array<DevExpress.ui.dxForm.Item> | undefined;
    /**
     * Specifies a name that identifies the form item.
     */
    name?: string | undefined;
    /**
     * A template to be used for rendering a group item.
     */
    template?:
      | template
      | ((
          data: DevExpress.ui.dxForm.GroupItemTemplateData,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether or not the current form item is visible.
     */
    visible?: boolean;
    /**
     * Specifies the sequence number of the item in a form, group or tab.
     */
    visibleIndex?: number | undefined;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormOptions extends WidgetOptions<dxForm> {
    /**
     * Binds the Form to an AI service.
     */
    aiIntegration?: DevExpress.aiIntegration.AIIntegration | undefined;
    /**
     * Specifies whether all item labels are aligned. Applies only to labels outside their editors (see labelMode).
     */
    alignItemLabels?: boolean;
    /**
     * Specifies whether item labels in all groups are aligned. Applies only to labels outside their editors (see labelMode).
     */
    alignItemLabelsInAllGroups?: boolean;
    /**
     * The count of columns in the form layout.
     */
    colCount?: number | DevExpress.common.Mode;
    /**
     * Specifies the number of Form columns for different screen sizes.
     */
    colCountByScreen?: any | undefined;
    /**
     * Specifies a function that customizes a form item after it has been created.
     */
    customizeItem?: (item: DevExpress.ui.dxForm.Item) => void;
    /**
     * Provides the Form&apos;s data. Gets updated every time form fields change.
     */
    formData?: any;
    /**
     * Holds an array of form items.
     */
    items?: Array<DevExpress.ui.dxForm.Item> | undefined;
    /**
     * Specifies the location of a label against the editor. Applies only to labels outside their editors (see labelMode).
     */
    labelLocation?: DevExpress.ui.dxForm.LabelLocation;
    /**
     * Specifies a display mode for item labels.
     */
    labelMode?: DevExpress.ui.dxForm.FormLabelMode;
    /**
     * The minimum column width used for calculating column count in the form layout. Applies only if colCount property is &apos;auto&apos;.
     */
    minColWidth?: number;
    /**
     * A function that is executed when the Enter key has been pressed while an editor is focused.
     */
    onEditorEnterKey?: (e: DevExpress.ui.dxForm.EditorEnterKeyEvent) => void;
    /**
     * A function that is executed when the value of a formData object field is changed.
     */
    onFieldDataChanged?: (
      e: DevExpress.ui.dxForm.FieldDataChangedEvent
    ) => void;
    /**
     * A function that is executed before an AI service populates the Form.
     */
    onSmartPasting?: (e: DevExpress.ui.dxForm.SmartPastingEvent) => void;
    /**
     * A function that is executed after an AI service populates the Form.
     */
    onSmartPasted?: (e: DevExpress.ui.dxForm.SmartPastedEvent) => void;
    /**
     * The text displayed for optional fields. Applies only if showOptionalMark is true.
     */
    optionalMark?: string;
    /**
     * Specifies whether all editors on the form are read-only. Applies only to non-templated items.
     */
    readOnly?: boolean;
    /**
     * The text displayed for required fields.
     */
    requiredMark?: string;
    /**
     * Specifies the message that is shown for end-users if a required field value is not specified.
     */
    requiredMessage?: string;
    /**
     * Specifies a function that categorizes screens by their width.
     */
    screenByWidth?: Function;
    /**
     * A Boolean value specifying whether to enable or disable form scrolling.
     */
    scrollingEnabled?: boolean;
    /**
     * Specifies whether a colon is displayed at the end of form labels. Applies only to labels outside their editors (see labelMode).
     */
    showColonAfterLabel?: boolean;
    /**
     * Specifies whether or not the optional mark is displayed for optional fields.
     */
    showOptionalMark?: boolean;
    /**
     * Specifies whether or not the required mark is displayed for required fields.
     */
    showRequiredMark?: boolean;
    /**
     * Specifies whether or not the total validation summary is displayed on the form.
     */
    showValidationSummary?: boolean;
    /**
     * Gives a name to the internal validation group.
     */
    validationGroup?: string | undefined;
    /**
     * Specifies whether current editor values differ from initial values.
     */
    readonly isDirty?: boolean;
  }
  /**
   * @deprecated Use SimpleItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormSimpleItem {
    /**
     * Specifies options for an AI service that parses Smart Paste data.
     */
    aiOptions?: {
      /**
       * Specifies an individual item instruction for the AI service.
       */
      instruction?: string | undefined;
      /**
       * Marks the item as disabled for AI processing.
       */
      disabled?: boolean;
    };
    /**
     * Specifies the number of columns spanned by the item.
     */
    colSpan?: number | undefined;
    /**
     * Specifies a CSS class to be applied to the form item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the path to the formData object field bound to the current form item.
     */
    dataField?: string | undefined;
    /**
     * Configures the form item&apos;s editor.
     */
    editorOptions?: any | undefined;
    /**
     * Specifies which editor UI component is used to display and edit the form item value.
     */
    editorType?: DevExpress.ui.dxForm.FormItemComponent;
    /**
     * Specifies the help text displayed for the current form item.
     */
    helpText?: string | undefined;
    /**
     * Specifies if the current form item is required.
     */
    isRequired?: boolean | undefined;
    /**
     * Specifies the item&apos;s type. Set it to &apos;simple&apos; to create a simple item.
     */
    itemType?: DevExpress.ui.dxForm.FormItemType;
    /**
     * Specifies properties for the form item label.
     */
    label?: {
      /**
       * Specifies the label&apos;s horizontal alignment. Applies only to labels outside their editors (see labelMode).
       */
      alignment?: DevExpress.common.HorizontalAlignment;
      /**
       * Specifies the location of a label against the editor. Applies only to labels outside their editors (see labelMode).
       */
      location?: DevExpress.ui.dxForm.LabelLocation;
      /**
       * Specifies whether a colon is displayed at the end of the current label. Applies only to labels outside their editors (see labelMode).
       */
      showColon?: boolean;
      /**
       * A template that can be used to replace the label with custom content. Applies only to labels outside their editors (see labelMode).
       */
      template?:
        | template
        | ((
            itemData: DevExpress.ui.dxForm.SimpleItemLabelTemplateData,
            itemElement: DevExpress.core.DxElement
          ) => string | DevExpress.core.UserDefinedElement);
      /**
       * Specifies the label text.
       */
      text?: string | undefined;
      /**
       * Controls the visibility of the label outside the editor.
       */
      visible?: boolean;
    };
    /**
     * Specifies a name that identifies the form item.
     */
    name?: string | undefined;
    /**
     * A template that can be used to replace the default editor with custom content.
     */
    template?:
      | template
      | ((
          data: DevExpress.ui.dxForm.SimpleItemTemplateData,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * An array of validation rules to be checked for the form item editor.
     */
    validationRules?: Array<
      | DevExpress.common.RequiredRule
      | DevExpress.common.NumericRule
      | DevExpress.common.RangeRule
      | DevExpress.common.StringLengthRule
      | DevExpress.common.CustomRule
      | DevExpress.common.CompareRule
      | DevExpress.common.PatternRule
      | DevExpress.common.EmailRule
      | DevExpress.common.AsyncRule
    >;
    /**
     * Specifies whether or not the current form item is visible.
     */
    visible?: boolean;
    /**
     * Specifies the sequence number of the item in a form, group or tab.
     */
    visibleIndex?: number | undefined;
  }
  /**
   * @deprecated Use TabbedItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxFormTabbedItem {
    /**
     * Specifies the number of columns spanned by the item.
     */
    colSpan?: number | undefined;
    /**
     * Specifies a CSS class to be applied to the form item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the item&apos;s type. Set it to &apos;tabbed&apos; to create a tabbed item.
     */
    itemType?: DevExpress.ui.dxForm.FormItemType;
    /**
     * Specifies a name that identifies the form item.
     */
    name?: string | undefined;
    /**
     * Holds a configuration object for the TabPanel UI component used to display the current form item.
     */
    tabPanelOptions?: dxTabPanelOptions | undefined;
    /**
     * An array of tab configuration objects.
     */
    tabs?: Array<{
      /**
       * Specifies whether or not labels of items displayed within the current tab are aligned.
       */
      alignItemLabels?: boolean;
      /**
       * Specifies a badge text for the tab.
       */
      badge?: string | undefined;
      /**
       * The count of columns in the tab layout.
       */
      colCount?: number;
      /**
       * Specifies the relation between the screen size qualifier and the number of columns in the tabbed layout.
       */
      colCountByScreen?: any | undefined;
      /**
       * Specifies whether the tab responds to user interaction.
       */
      disabled?: boolean;
      /**
       * Specifies the icon to be displayed on the tab.
       */
      icon?: string | undefined;
      /**
       * Holds an array of form items displayed within the tab.
       */
      items?: Array<DevExpress.ui.dxForm.Item> | undefined;
      /**
       * The template to be used for rendering the tab.
       */
      tabTemplate?:
        | template
        | ((
            tabData: any,
            tabIndex: number,
            tabElement: DevExpress.core.DxElement
          ) => any)
        | undefined;
      /**
       * The template to be used for rendering the tab content.
       */
      template?:
        | template
        | ((
            tabData: any,
            tabIndex: number,
            tabElement: DevExpress.core.DxElement
          ) => any)
        | undefined;
      /**
       * Specifies the tab title.
       */
      title?: string | undefined;
    }>;
    /**
     * Specifies whether or not the current form item is visible.
     */
    visible?: boolean;
    /**
     * Specifies the sequence number of the item in a form, group or tab.
     */
    visibleIndex?: number | undefined;
  }
  /**
   * The Gallery is a UI component that displays a collection of images in a carousel. The UI component is supplied with various navigation controls that allow a user to switch between images.
   */
  export class dxGallery<
    TItem extends DevExpress.ui.dxGallery.ItemLike = any,
    TKey = any
  > extends CollectionWidget<dxGalleryOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Shows a specific image.
     */
    goToItem(
      itemIndex: number,
      animation: boolean
    ): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows the next image.
     */
    nextItem(animation: boolean): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows the previous image.
     */
    prevItem(animation: boolean): DevExpress.core.utils.DxPromise<void>;
  }
  module dxGallery {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxGallery<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxGallery<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxGallery<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxGallery<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxGallery<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxGallery<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxGallery<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxGallery<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxGalleryOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxGallery<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGalleryItem extends CollectionWidgetItem {
    /**
     * Specifies the text passed to the alt attribute of the image markup element.
     */
    imageAlt?: string;
    /**
     * Specifies the URL of the image displayed by the item.
     */
    imageSrc?: string;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxGalleryOptions<
    TItem extends DevExpress.ui.dxGallery.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxGallery<TItem, TKey>, TItem, TKey> {
    /**
     * The time, in milliseconds, spent on slide animation.
     */
    animationDuration?: number;
    /**
     * Specifies whether or not to animate the displayed item change.
     */
    animationEnabled?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * A Boolean value specifying whether or not to allow users to switch between items by clicking an indicator.
     */
    indicatorEnabled?: boolean;
    /**
     * Specifies the width of an area used to display a single image.
     */
    initialItemWidth?: number | undefined;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * A Boolean value specifying whether or not to scroll back to the first item after the last item is swiped.
     */
    loop?: boolean;
    /**
     * Specifies the text or HTML markup displayed by the UI component if the item collection is empty.
     */
    noDataText?: string;
    /**
     * The index of the currently active gallery item.
     */
    selectedIndex?: number;
    /**
     * A Boolean value specifying whether or not to display an indicator that points to the selected gallery item.
     */
    showIndicator?: boolean;
    /**
     * A Boolean value that specifies the availability of the &apos;Forward&apos; and &apos;Back&apos; navigation buttons.
     */
    showNavButtons?: boolean;
    /**
     * The time interval in milliseconds, after which the gallery switches to the next item.
     */
    slideshowDelay?: number;
    /**
     * Specifies if the UI component stretches images to fit the total gallery width.
     */
    stretchImages?: boolean;
    /**
     * A Boolean value specifying whether or not to allow users to switch between items by swiping.
     */
    swipeEnabled?: boolean;
    /**
     * Specifies whether or not to display parts of previous and next images along the sides of the current image.
     */
    wrapAround?: boolean;
  }
  /**
   * The Gantt is a UI component that displays the task flow and dependencies between tasks.
   */
  export class dxGantt extends Widget<dxGanttOptions> {
    /**
     * Gets the task data.
     */
    getTaskData(key: any): any;
    /**
     * Gets the dependency data.
     */
    getDependencyData(key: any): any;
    /**
     * Gets the resource data.
     */
    getResourceData(key: any): any;
    /**
     * Gets the resource assignment data.
     */
    getResourceAssignmentData(key: any): any;
    /**
     * Inserts a new task.
     */
    insertTask(data: any): void;
    /**
     * Deletes a task.
     */
    deleteTask(key: any): void;
    /**
     * Updates the task data.
     */
    updateTask(key: any, data: any): void;
    /**
     * Inserts a new dependency.
     */
    insertDependency(data: any): void;
    /**
     * Deletes a dependency.
     */
    deleteDependency(key: any): void;
    /**
     * Inserts a new resource.
     */
    insertResource(data: any, taskKeys?: Array<any>): void;
    /**
     * Deletes a resource.
     */
    deleteResource(key: any): void;
    /**
     * Assigns a resource to a task.
     */
    assignResourceToTask(resourceKey: any, taskKey: any): void;
    /**
     * Removes a resource from the task.
     */
    unassignResourceFromTask(resourceKey: any, taskKey: any): void;
    /**
     * Gets resources assigned to a task.
     */
    getTaskResources(key: any): Array<any>;
    /**
     * Gets the keys of the visible tasks.
     */
    getVisibleTaskKeys(): Array<any>;
    /**
     * Gets the keys of the visible dependencies.
     */
    getVisibleDependencyKeys(): Array<any>;
    /**
     * Gets the keys of the visible resources.
     */
    getVisibleResourceKeys(): Array<any>;
    /**
     * Gets the keys of the visible resource assignments.
     */
    getVisibleResourceAssignmentKeys(): Array<any>;
    /**
     * Updates the dimensions of the UI component contents.
     */
    updateDimensions(): void;
    /**
     * Scrolls the Gantt chart to the specified date.
     */
    scrollToDate(date: Date | Number | string): void;
    /**
     * Invokes the &apos;Resource Manager&apos; dialog.
     */
    showResourceManagerDialog(): void;
    /**
     * Expands all tasks.
     */
    expandAll(): void;
    /**
     * Collapses all tasks.
     */
    collapseAll(): void;
    /**
     * Expands all tasks down to the specified hierarchical level.
     */
    expandAllToLevel(level: Number): void;
    /**
     * Expands a task&apos;s parent tasks.
     */
    expandToTask(key: any): void;
    /**
     * Collapses a task.
     */
    collapseTask(key: any): void;
    /**
     * Expands a task.
     */
    expandTask(key: any): void;
    /**
     * Reloads data and repaints the Gantt component.
     */
    refresh(): DevExpress.core.utils.DxPromise<void>;
    /**
     * Shows or hides task resources.
     */
    showResources(value: boolean): void;
    /**
     * Shows or hides dependencies between tasks.
     */
    showDependencies(value: boolean): void;
    /**
     * Zooms in the Gantt chart.
     */
    zoomIn(): void;
    /**
     * Zooms out the Gantt chart.
     */
    zoomOut(): void;
    /**
     * Removes all resources from the task.
     */
    unassignAllResourcesFromTask(taskKey: any): void;
    /**
     * Invokes the &apos;Task Details&apos; dialog.
     */
    showTaskDetailsDialog(taskKey: any): void;
  }
  module dxGantt {
    export type Column<TRowData = any, TKey = any> = dxGanttColumn<
      TRowData,
      TKey
    >;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxGantt>;
    /**
     * The type of the contextMenuPreparing event handler&apos;s argument.
     */
    export type ContextMenuPreparingEvent =
      DevExpress.common.core.events.Cancelable & {
        /**
         * 
         */
        readonly component?: dxGantt;
        /**
         * 
         */
        readonly element?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly event?: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>;
        /**
         * 
         */
        readonly targetKey?: any;
        /**
         * 
         */
        readonly targetType?: string;
        /**
         * 
         */
        readonly data?: any;
        /**
         * 
         */
        readonly items?: Array<any>;
      };
    /**
     * The type of the customCommand event handler&apos;s argument.
     */
    export type CustomCommandEvent = {
      /**
       * 
       */
      readonly component?: dxGantt;
      /**
       * 
       */
      readonly element?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly name: string;
    };
    /**
     * The type of the dependencyDeleted event handler&apos;s argument.
     */
    export type DependencyDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the dependencyDeleting event handler&apos;s argument.
     */
    export type DependencyDeletingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
          /**
           * 
           */
          readonly key: any;
        };
    /**
     * The type of the dependencyInserted event handler&apos;s argument.
     */
    export type DependencyInsertedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the dependencyInserting event handler&apos;s argument.
     */
    export type DependencyInsertingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
        };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxGantt>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type GanttPdfExportDateRange = 'all' | 'visible';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type GanttPdfExportMode = 'all' | 'treeList' | 'chart';
    export type GanttPredefinedContextMenuItem =
      | 'undo'
      | 'redo'
      | 'expandAll'
      | 'collapseAll'
      | 'addTask'
      | 'deleteTask'
      | 'zoomIn'
      | 'zoomOut'
      | 'deleteDependency'
      | 'taskDetails'
      | 'resourceManager';
    export type GanttPredefinedToolbarItem =
      | 'separator'
      | 'undo'
      | 'redo'
      | 'expandAll'
      | 'collapseAll'
      | 'addTask'
      | 'deleteTask'
      | 'zoomIn'
      | 'zoomOut'
      | 'taskDetails'
      | 'fullScreen'
      | 'resourceManager'
      | 'showResources'
      | 'showDependencies';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type GanttRenderScaleType =
      | 'minutes'
      | 'hours'
      | 'sixHours'
      | 'days'
      | 'weeks'
      | 'months'
      | 'quarters'
      | 'years'
      | 'fiveYears';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type GanttScaleType =
      | 'auto'
      | 'minutes'
      | 'hours'
      | 'sixHours'
      | 'days'
      | 'weeks'
      | 'months'
      | 'quarters'
      | 'years';
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type GanttTaskTitlePosition = 'inside' | 'outside' | 'none';
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxGantt>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type ProgressTooltipTemplateData = {
      readonly progress: number;
    };
    export type Properties = dxGanttOptions;
    /**
     * The type of the resourceAssigned event handler&apos;s argument.
     */
    export type ResourceAssignedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the resourceAssigning event handler&apos;s argument.
     */
    export type ResourceAssigningEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
        };
    /**
     * The type of the resourceDeleted event handler&apos;s argument.
     */
    export type ResourceDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the resourceDeleting event handler&apos;s argument.
     */
    export type ResourceDeletingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
          /**
           * 
           */
          readonly key: any;
        };
    /**
     * The type of the resourceInserted event handler&apos;s argument.
     */
    export type ResourceInsertedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the resourceInserting event handler&apos;s argument.
     */
    export type ResourceInsertingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
        };
    /**
     * The type of the resourceManagerDialogShowing event handler&apos;s argument.
     */
    export type ResourceManagerDialogShowingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: Array<any>;
        };
    /**
     * The type of the resourceUnassigned event handler&apos;s argument.
     */
    export type ResourceUnassignedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the resourceUnassigning event handler&apos;s argument.
     */
    export type ResourceUnassigningEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
          /**
           * 
           */
          readonly key: any;
        };
    /**
     * The type of the scaleCellPrepared event handler&apos;s argument.
     */
    export type ScaleCellPreparedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxGantt> & {
        /**
         * 
         */
        readonly scaleIndex: number;
        /**
         * 
         */
        readonly scaleType: GanttRenderScaleType;
        /**
         * 
         */
        readonly scaleElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly separatorElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly startDate: Date;
        /**
         * 
         */
        readonly endDate: Date;
      };
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly selectedRowKey?: any;
      };
    /**
     * The type of the taskClick event handler&apos;s argument.
     */
    export type TaskClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxGantt,
      PointerEvent | MouseEvent
    > & {
      /**
       * 
       */
      readonly key?: any;
      /**
       * 
       */
      readonly data?: any;
    };
    export type TaskContentTemplateData = {
      readonly cellSize: any;
      readonly isMilestone: boolean;
      readonly taskData: any;
      readonly taskHTML: any;
      readonly taskPosition: any;
      readonly taskResources: Array<any>;
      readonly taskSize: any;
    };
    /**
     * The type of the taskDblClick event handler&apos;s argument.
     */
    export type TaskDblClickEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxGantt,
        PointerEvent | MouseEvent
      > & {
        /**
         * 
         */
        readonly key?: any;
        /**
         * 
         */
        readonly data?: any;
      };
    /**
     * The type of the taskDeleted event handler&apos;s argument.
     */
    export type TaskDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the taskDeleting event handler&apos;s argument.
     */
    export type TaskDeletingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the taskEditDialogShowing event handler&apos;s argument.
     */
    export type TaskEditDialogShowingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxGantt> & {
          /**
           * 
           */
          readonly values: any;
          /**
           * 
           */
          readonly key: any;
          /**
           * 
           */
          readonly readOnlyFields?: Array<string>;
          /**
           * 
           */
          readonly hiddenFields?: Array<string>;
        };
    /**
     * The type of the taskInserted event handler&apos;s argument.
     */
    export type TaskInsertedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values?: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the taskInserting event handler&apos;s argument.
     */
    export type TaskInsertingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
      };
    /**
     * The type of the taskMoving event handler&apos;s argument.
     */
    export type TaskMovingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly newValues: any;
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the taskUpdated event handler&apos;s argument.
     */
    export type TaskUpdatedEvent =
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    /**
     * The type of the taskUpdating event handler&apos;s argument.
     */
    export type TaskUpdatingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxGantt> & {
        /**
         * 
         */
        readonly newValues: any;
        /**
         * 
         */
        readonly values: any;
        /**
         * 
         */
        readonly key: any;
      };
    export type TimeTooltipTemplateData = {
      readonly start: Date;
      readonly end: Date;
    };
  }
  /**
   * @deprecated Use the Column type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxGanttColumn<TRowData = any, TKey = any> = Omit<
    dxGanttColumnBlank<TRowData, TKey>,
    | 'allowEditing'
    | 'allowFixing'
    | 'allowHiding'
    | 'allowReordering'
    | 'allowResizing'
    | 'allowSearch'
    | 'buttons'
    | 'columns'
    | 'editCellTemplate'
    | 'editorOptions'
    | 'fixed'
    | 'fixedPosition'
    | 'formItem'
    | 'hidingPriority'
    | 'isBand'
    | 'lookup'
    | 'name'
    | 'ownerBand'
    | 'renderAsync'
    | 'setCellValue'
    | 'showEditorAlways'
    | 'showInColumnChooser'
    | 'type'
    | 'validationRules'
  >;
  /**
   * Configures the column.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  interface dxGanttColumnBlank<TRowData = any, TKey = any>
    extends DevExpress.ui.dxTreeList.Column<TRowData, TKey> {
    /**
     * 
     */
    allowEditing: any;
    /**
     * 
     */
    allowFixing: any;
    /**
     * 
     */
    allowHiding: any;
    /**
     * 
     */
    allowReordering: any;
    /**
     * 
     */
    allowResizing: any;
    /**
     * 
     */
    allowSearch: any;
    /**
     * 
     */
    buttons: any;
    /**
     * 
     */
    columns: any;
    /**
     * 
     */
    editorOptions: any;
    /**
     * 
     */
    editCellTemplate: any;
    /**
     * 
     */
    fixed: any;
    /**
     * 
     */
    fixedPosition: any;
    /**
     * 
     */
    formItem: any;
    /**
     * 
     */
    hidingPriority: any;
    /**
     * 
     */
    isBand: any;
    /**
     * 
     */
    lookup: any;
    /**
     * 
     */
    name: any;
    /**
     * 
     */
    ownerBand: any;
    /**
     * 
     */
    renderAsync: any;
    /**
     * 
     */
    setCellValue: any;
    /**
     * 
     */
    showEditorAlways: any;
    /**
     * 
     */
    showInColumnChooser: any;
    /**
     * 
     */
    validationRules: any;
    /**
     * 
     */
    type: any;
  }
  /**
   * Configures the context menu.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttContextMenu {
    /**
     * Specifies whether the context menu is enabled in the UI component.
     */
    enabled?: boolean;
    /**
     * Configures context menu item settings.
     */
    items?: Array<
      | DevExpress.ui.dxGantt.ContextMenuItem
      | DevExpress.ui.dxGantt.GanttPredefinedContextMenuItem
    >;
  }
  /**
   * @deprecated Use ContextMenuItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttContextMenuItem
    extends DevExpress.ui.dxContextMenu.Item {
    /**
     * Specifies the context menu item name.
     */
    name?: DevExpress.ui.dxGantt.GanttPredefinedContextMenuItem | string;
  }
  /**
   * Configures the filter row.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttFilterRow {
    /**
     * Specifies the null text for the editor that sets the end of a range for the &apos;between&apos; filter operation.
     */
    betweenEndText?: string;
    /**
     * Specifies the null text for the editor that sets the start of a range for the &apos;between&apos; filter operation.
     */
    betweenStartText?: string;
    /**
     * Specifies descriptions for filter operations in the filter list.
     */
    operationDescriptions?: dxGanttFilterRowOperationDescriptions;
    /**
     * Specifies text for the &apos;reset&apos; operation.
     */
    resetOperationText?: string;
    /**
     * Specifies text for the &apos;All&apos; filter operation.
     */
    showAllText?: string;
    /**
     * Specifies whether to display filter icons.
     */
    showOperationChooser?: boolean;
    /**
     * Specifies whether the filter row is visible.
     */
    visible?: boolean;
  }
  /**
   * Contains descriptions for filter operations in the filter list.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttFilterRowOperationDescriptions {
    /**
     * Text for the &apos;Between&apos; operation.
     */
    between?: string;
    /**
     * Text for the &apos;Contains&apos; operation.
     */
    contains?: string;
    /**
     * Text for the &apos;Ends with&apos; operation.
     */
    endsWith?: string;
    /**
     * Text for the &apos;Equals&apos; operation.
     */
    equal?: string;
    /**
     * Text for the &apos;Greater than&apos; operation.
     */
    greaterThan?: string;
    /**
     * Text for the &apos;Greater than or equal to&apos; operation.
     */
    greaterThanOrEqual?: string;
    /**
     * Text for the &apos;Less than&apos; operation.
     */
    lessThan?: string;
    /**
     * Text for the &apos;Less than or equal to&apos; operation.
     */
    lessThanOrEqual?: string;
    /**
     * Text for the &apos;Does not contain&apos; operation.
     */
    notContains?: string;
    /**
     * Text for the &apos;Does not equal&apos; operation.
     */
    notEqual?: string;
    /**
     * Text for the &apos;Starts with&apos; operation.
     */
    startsWith?: string;
  }
  /**
   * Configures the header filter.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttHeaderFilter {
    /**
     * Specifies whether to enable searching in the header filter.
     * @deprecated Use search.enabled instead.
     */
    allowSearch?: boolean;
    /**
     * Specifies whether a &apos;Select All&apos; option is available to users.
     */
    allowSelectAll?: boolean;
    /**
     * Specifies the height of the popup window that contains values for filtering.
     */
    height?: number;
    /**
     * Configures the header filter&apos;s search functionality.
     */
    search?: DevExpress.common.grids.HeaderFilterSearchConfig;
    /**
     * Specifies a delay in milliseconds between typing a search string and the search execution.
     * @deprecated Use search.timeout instead.
     */
    searchTimeout?: number;
    /**
     * Contains properties that specify text for various elements of the popup window.
     */
    texts?: dxGanttHeaderFilterTexts;
    /**
     * Specifies whether to show header filter icons.
     */
    visible?: boolean;
    /**
     * Specifies the width of the popup window that contains values for filtering.
     */
    width?: number;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttHeaderFilterTexts {
    /**
     * Specifies text for the &apos;Cancel&apos; button in the popup window.
     */
    cancel?: string;
    /**
     * Specifies text for the &apos;(Blank)&apos; item in the popup window.
     */
    emptyValue?: string;
    /**
     * Specifies text for the &apos;OK&apos; button in the popup window.
     */
    ok?: string;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttOptions extends WidgetOptions<dxGantt> {
    /**
     * Specifies whether users can select tasks in the Gantt.
     */
    allowSelection?: boolean;
    /**
     * An array of columns in the Gantt.
     */
    columns?: Array<DevExpress.ui.dxGantt.Column | string> | undefined;
    /**
     * Configures dependencies.
     */
    dependencies?: {
      /**
       * Binds the UI component to the data source which contains dependencies.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the data field that provides keys for dependencies.
       */
      keyExpr?: string | Function;
      /**
       * Specifies the data field that provides predecessor IDs.
       */
      predecessorIdExpr?: string | Function;
      /**
       * Specifies the data field that provides successor IDs.
       */
      successorIdExpr?: string | Function;
      /**
       * Specifies the data field that provides dependency types.
       */
      typeExpr?: string | Function;
    };
    /**
     * Configures edit properties.
     */
    editing?: {
      /**
       * Specifies whether a user can add dependencies.
       */
      allowDependencyAdding?: boolean;
      /**
       * Specifies whether a user can delete dependencies.
       */
      allowDependencyDeleting?: boolean;
      /**
       * Specifies whether a user can add resources. tasks.
       */
      allowResourceAdding?: boolean;
      /**
       * Specifies whether a user can delete resources.
       */
      allowResourceDeleting?: boolean;
      /**
       * For internal use only.
       */
      allowResourceUpdating?: boolean;
      /**
       * Specifies whether a user can add tasks.
       */
      allowTaskAdding?: boolean;
      /**
       * Specifies whether a user can delete tasks.
       */
      allowTaskDeleting?: boolean;
      /**
       * Specifies whether users can update a task&apos;s resources.
       */
      allowTaskResourceUpdating?: boolean;
      /**
       * Specifies whether a user can update tasks.
       */
      allowTaskUpdating?: boolean;
      /**
       * Specifies whether a user can edit tasks, resources and dependencies.
       */
      enabled?: boolean;
    };
    /**
     * Configures validation properties.
     */
    validation?: {
      /**
       * Enables task dependencies validation.
       */
      validateDependencies?: boolean;
      /**
       * Specifies whether to recalculate the parent task&apos;s duration and progress when its child tasks are modified.
       */
      autoUpdateParentTasks?: boolean;
      /**
       * Specifies whether users can move or resize a predecessor to change a gap before a successor according to the dependency rules.
       */
      enablePredecessorGap?: boolean;
    };
    /**
     * Configures sort settings.
     */
    sorting?: dxGanttSorting;
    /**
     * Configures filter row settings.
     */
    filterRow?: dxGanttFilterRow;
    /**
     * Configures the header filter settings.
     */
    headerFilter?: dxGanttHeaderFilter;
    /**
     * A function that is executed after users select a task or clear its selection.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxGantt.SelectionChangedEvent
    ) => void;
    /**
     * A function that is executed after a custom command item was clicked. Allows you to implement a custom command&apos;s functionality.
     */
    onCustomCommand?: (e: DevExpress.ui.dxGantt.CustomCommandEvent) => void;
    /**
     * A function that is executed before the context menu is rendered.
     */
    onContextMenuPreparing?: (
      e: DevExpress.ui.dxGantt.ContextMenuPreparingEvent
    ) => void;
    /**
     * A function that is executed before a task is inserted.
     */
    onTaskInserting?: (e: DevExpress.ui.dxGantt.TaskInsertingEvent) => void;
    /**
     * A function that is executed when a task is inserted.
     */
    onTaskInserted?: (e: DevExpress.ui.dxGantt.TaskInsertedEvent) => void;
    /**
     * A function that is executed before a task is deleted.
     */
    onTaskDeleting?: (e: DevExpress.ui.dxGantt.TaskDeletingEvent) => void;
    /**
     * A function that is executed when a task is deleted.
     */
    onTaskDeleted?: (e: DevExpress.ui.dxGantt.TaskDeletedEvent) => void;
    /**
     * A function that is executed before a task is updated.
     */
    onTaskUpdating?: (e: DevExpress.ui.dxGantt.TaskUpdatingEvent) => void;
    /**
     * A function that is executed when a task is updated.
     */
    onTaskUpdated?: (e: DevExpress.ui.dxGantt.TaskUpdatedEvent) => void;
    /**
     * A function that is executed before a task is moved.
     */
    onTaskMoving?: (e: DevExpress.ui.dxGantt.TaskMovingEvent) => void;
    /**
     * A function that is executed before the edit dialog is shown.
     */
    onTaskEditDialogShowing?: (
      e: DevExpress.ui.dxGantt.TaskEditDialogShowingEvent
    ) => void;
    /**
     * A function that is executed before the Resource Manager dialog is shown.
     */
    onResourceManagerDialogShowing?: (
      e: DevExpress.ui.dxGantt.ResourceManagerDialogShowingEvent
    ) => void;
    /**
     * A function that is executed before a dependency is inserted.
     */
    onDependencyInserting?: (
      e: DevExpress.ui.dxGantt.DependencyInsertingEvent
    ) => void;
    /**
     * A function that is executed when a dependency is inserted.
     */
    onDependencyInserted?: (
      e: DevExpress.ui.dxGantt.DependencyInsertedEvent
    ) => void;
    /**
     * A function that is executed before a dependency is deleted.
     */
    onDependencyDeleting?: (
      e: DevExpress.ui.dxGantt.DependencyDeletingEvent
    ) => void;
    /**
     * A function that is executed when a dependency is deleted.
     */
    onDependencyDeleted?: (
      e: DevExpress.ui.dxGantt.DependencyDeletedEvent
    ) => void;
    /**
     * A function that is executed before a resource is inserted.
     */
    onResourceInserting?: (
      e: DevExpress.ui.dxGantt.ResourceInsertingEvent
    ) => void;
    /**
     * A function that is executed when a resource is inserted.
     */
    onResourceInserted?: (
      e: DevExpress.ui.dxGantt.ResourceInsertedEvent
    ) => void;
    /**
     * A function that is executed before a resource is deleted.
     */
    onResourceDeleting?: (
      e: DevExpress.ui.dxGantt.ResourceDeletingEvent
    ) => void;
    /**
     * A function that is executed when a resource is deleted.
     */
    onResourceDeleted?: (e: DevExpress.ui.dxGantt.ResourceDeletedEvent) => void;
    /**
     * A function that is executed before a resource is assigned to a task.
     */
    onResourceAssigning?: (
      e: DevExpress.ui.dxGantt.ResourceAssigningEvent
    ) => void;
    /**
     * A function that is executed when a resource is assigned to a task.
     */
    onResourceAssigned?: (
      e: DevExpress.ui.dxGantt.ResourceAssignedEvent
    ) => void;
    /**
     * A function that is executed before a resource is unassigned from a task.
     */
    onResourceUnassigning?: (
      e: DevExpress.ui.dxGantt.ResourceUnassigningEvent
    ) => void;
    /**
     * A function that is executed when a resource is unassigned from a task.
     */
    onResourceUnassigned?: (
      e: DevExpress.ui.dxGantt.ResourceUnassignedEvent
    ) => void;
    /**
     * A function that is executed when a user clicks a task.
     */
    onTaskClick?: (e: DevExpress.ui.dxGantt.TaskClickEvent) => void;
    /**
     * A function that is executed when a user double-clicks a task.
     */
    onTaskDblClick?: (e: DevExpress.ui.dxGantt.TaskDblClickEvent) => void;
    /**
     * A function that is executed before a scale cell is prepared.
     */
    onScaleCellPrepared?: (
      e: DevExpress.ui.dxGantt.ScaleCellPreparedEvent
    ) => void;

    /**
     * Configures resource assignments.
     */
    resourceAssignments?: {
      /**
       * Binds the UI component to the data source, which contains resource assignments.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the data field that provides keys for resource assignments.
       */
      keyExpr?: string | Function;
      /**
       * Specifies the data field that provides resource IDs.
       */
      resourceIdExpr?: string | Function;
      /**
       * Specifies the data field that provides task IDs.
       */
      taskIdExpr?: string | Function;
    };
    /**
     * Configures task resources.
     */
    resources?: {
      /**
       * Specifies the data field that provides resources&apos; color.
       */
      colorExpr?: string | Function;
      /**
       * Binds the UI component to the data source, which contains resources.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the data field that provides keys for resources.
       */
      keyExpr?: string | Function;
      /**
       * Specifies the data field that provides resource texts.
       */
      textExpr?: string | Function;
    };
    /**
     * Specifies the zoom level of tasks in the Gantt chart.
     */
    scaleType?: DevExpress.ui.dxGantt.GanttScaleType;
    /**
     * Configures zoom range settings.
     */
    scaleTypeRange?: {
      /**
       * Specifies the minimum zoom level of tasks in the Gantt chart.
       */
      min?: DevExpress.ui.dxGantt.GanttScaleType;
      /**
       * Specifies the maximum zoom level of tasks in the Gantt chart.
       */
      max?: DevExpress.ui.dxGantt.GanttScaleType;
    };
    /**
     * Allows you to select a row or determine which row is selected.
     */
    selectedRowKey?: any | undefined;
    /**
     * Specifies whether to display task resources.
     */
    showResources?: boolean;
    /**
     * Specifies whether to display dependencies between tasks.
     */
    showDependencies?: boolean;
    /**
     * Specifies whether to show/hide horizontal faint lines that separate tasks.
     */
    showRowLines?: boolean;
    /**
     * Specifies the width of task list columns in pixels.
     */
    taskListWidth?: number;
    /**
     * Specifies a task&apos;s title position.
     */
    taskTitlePosition?: DevExpress.ui.dxGantt.GanttTaskTitlePosition;
    /**
     * Specifies the first day of a week.
     */
    firstDayOfWeek?: DevExpress.common.FirstDayOfWeek | undefined;
    /**
     * Configures tasks.
     */
    tasks?: {
      /**
       * Specifies the data field that provides tasks&apos; color.
       */
      colorExpr?: string | Function;
      /**
       * Binds the UI component to the data source which contains tasks.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies the data field that provides tasks&apos; end dates.
       */
      endExpr?: string | Function;
      /**
       * Specifies the data field that provides keys for tasks.
       */
      keyExpr?: string | Function;
      /**
       * Specifies the data field that provides tasks&apos; parent IDs.
       */
      parentIdExpr?: string | Function;
      /**
       * Specifies the data field that provides tasks&apos; progress.
       */
      progressExpr?: string | Function;
      /**
       * Specifies the data field that provides tasks&apos; start dates.
       */
      startExpr?: string | Function;
      /**
       * Specifies the data field that provides task titles.
       */
      titleExpr?: string | Function;
    };
    /**
     * Configures toolbar settings.
     */
    toolbar?: dxGanttToolbar;
    /**
     * Configures the context menu settings.
     */
    contextMenu?: dxGanttContextMenu;
    /**
     * Configures strip lines.
     */
    stripLines?: Array<dxGanttStripLine>;
    /**
     * Specifies custom content for the task tooltip.
     */
    taskTooltipContentTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement,
          task: any
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies custom content for the tooltip that displays the task&apos;s start and end time while the task is resized in the UI.
     */
    taskTimeTooltipContentTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement,
          item: DevExpress.ui.dxGantt.TimeTooltipTemplateData
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies custom content for the tooltip that displays the task&apos;s progress while the progress handler is resized in the UI.
     */
    taskProgressTooltipContentTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement,
          item: DevExpress.ui.dxGantt.ProgressTooltipTemplateData
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies custom content for the task.
     */
    taskContentTemplate?:
      | template
      | ((
          container: DevExpress.core.DxElement,
          item: DevExpress.ui.dxGantt.TaskContentTemplateData
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the root task&apos;s identifier.
     */
    rootValue?: any;
    /**
     * Specifies the start date of the date interval in the Gantt chart.
     */
    startDateRange?: Date;
    /**
     * Specifies the end date of the date interval in the Gantt chart.
     */
    endDateRange?: Date;
  }
  /**
   * Configures sorting.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttSorting {
    /**
     * Specifies text for the context menu item that sets an ascending sort order in a column.
     */
    ascendingText?: string;
    /**
     * Specifies text for the context menu item that clears sorting settings for a column.
     */
    clearText?: string;
    /**
     * Specifies text for the context menu item that sets a descending sort order in a column.
     */
    descendingText?: string;
    /**
     * Specifies sort mode.
     */
    mode?: DevExpress.common.SingleMultipleOrNone | string;
    /**
     * Specifies whether to display sort indexes in column headers. Applies only when sorting.mode is &apos;multiple&apos; and data is sorted by two or more columns.
     */
    showSortIndexes?: boolean;
  }
  /**
   * Configures a strip line.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttStripLine {
    /**
     * Specifies the name of the cascading style sheet (CSS) class associated with the strip line.
     */
    cssClass?: string | undefined;
    /**
     * Specifies the end point of the strip line.
     */
    end?: Date | number | string | (() => Date | number | string) | undefined;
    /**
     * Specifies the start point of the strip line.
     */
    start?: Date | number | string | (() => Date | number | string) | undefined;
    /**
     * Specifies the strip line&apos;s title.
     */
    title?: string | undefined;
  }
  /**
   * Configures the toolbar.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttToolbar {
    /**
     * Configures toolbar items&apos; settings.
     */
    items?: Array<
      | DevExpress.ui.dxGantt.ToolbarItem
      | DevExpress.ui.dxGantt.GanttPredefinedToolbarItem
    >;
  }
  /**
   * @deprecated Use ToolbarItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxGanttToolbarItem extends DevExpress.ui.dxToolbar.Item {
    /**
     * Specifies the toolbar item&apos;s name.
     */
    name?: DevExpress.ui.dxGantt.GanttPredefinedToolbarItem | string;
    /**
     * Specifies the toolbar item&apos;s location.
     */
    location?: DevExpress.common.ToolbarItemLocation;
  }
  /**
   * HTML Editor is a WYSIWYG editor that allows you to format textual and visual content and to output it in HTML. HTML Editor is built on top of and requires the DevExtreme Quill.
   */
  export class dxHtmlEditor extends Editor<dxHtmlEditorOptions> {
    /**
     * Removes focus from the content field of the editor.
     */
    blur(): void;
    /**
     * Clears the history of changes.
     */
    clearHistory(): void;
    /**
     * Deletes content from the given range.
     */
    delete(index: number, length: number): void;
    /**
     * Applies a format to the selected content. Cannot be used with embedded formats.
     */
    format(
      formatName: DevExpress.ui.dxHtmlEditor.HtmlEditorFormat | string,
      formatValue: any
    ): void;
    /**
     * Applies a single block format to all lines in the given range.
     */
    formatLine(
      index: number,
      length: number,
      formatName: DevExpress.ui.dxHtmlEditor.HtmlEditorFormat | string,
      formatValue: any
    ): void;
    /**
     * Applies several block formats to all lines in the given range.
     */
    formatLine(index: number, length: number, formats: any): void;
    /**
     * Applies a single text format to all characters in the given range.
     */
    formatText(
      index: number,
      length: number,
      formatName: DevExpress.ui.dxHtmlEditor.HtmlEditorFormat | string,
      formatValue: any
    ): void;
    /**
     * Applies several text formats to all characters in the given range.
     */
    formatText(index: number, length: number, formats: any): void;
    /**
     * Gets a format, module, or Parchment.
     */
    get(componentPath: string): any;
    /**
     * Retrieves the pixel position and size of a selection at a specified location.
     */
    getBounds(index: number, length: number): any;
    /**
     * Retrieves formatting of the text within the current selection range.
     */
    getFormat(): any;
    /**
     * Gets formats applied to the content in the specified range.
     */
    getFormat(index: number, length: number): any;
    /**
     * Gets the entire content&apos;s length.
     */
    getLength(): number;
    /**
     * Gets the instance of a module.
     */
    getModule(moduleName: string): any;
    /**
     * Gets the DevExtreme Quill&apos;s instance.
     */
    getQuillInstance(): any;
    /**
     * Gets the selected content&apos;s position and length.
     */
    getSelection(focus?: boolean | undefined): any;
    /**
     * Retrieves text content from the HTML Editor.
     */
    getText(index: number, length: number): string;
    /**
     * Inserts an embedded content at the specified position.
     */
    insertEmbed(index: number, type: string, config: any): void;
    /**
     * Inserts text into the HTML Editor.
     */
    insertText(
      index: number,
      text: string,
      formatName: DevExpress.ui.dxHtmlEditor.HtmlEditorFormat | string,
      formatValue: any
    ): void;
    /**
     * Inserts formatted text at the specified position. Used with all formats except embedded.
     */
    insertText(index: number, text: string, formats: any): void;
    /**
     * Reapplies the most recent undone change. Repeated calls reapply preceding undone changes.
     */
    redo(): void;
    /**
     * Registers custom formats and modules.
     */
    register(modules: any): void;
    /**
     * Removes all formatting and embedded content from the specified range.
     */
    removeFormat(index: number, length: number): void;
    /**
     * Selects and highlights content in the specified range.
     */
    setSelection(index: number, length: number): void;
    /**
     * Reverses the most recent change. Repeated calls reverse preceding changes.
     */
    undo(): void;
  }
  module dxHtmlEditor {
    export type AIChangeStyleOption =
      | 'formal'
      | 'informal'
      | 'technical'
      | 'business'
      | 'creative'
      | 'journalistic'
      | 'academic'
      | 'persuasive'
      | 'narrative'
      | 'expository'
      | 'descriptive'
      | 'conversational';
    export type AIChangeToneOption =
      | 'professional'
      | 'casual'
      | 'straightforward'
      | 'confident'
      | 'friendly';
    export type AICommandName =
      | 'summarize'
      | 'proofread'
      | 'expand'
      | 'shorten'
      | 'changeStyle'
      | 'changeTone'
      | 'translate'
      | 'askAI';
    /**
     * An extended type for command names. Includes predefined and custom command names.
     */
    export type AICommandNameExtended = AICommandName | 'custom';
    export type AITranslateOption =
      | 'arabic'
      | 'chinese'
      | 'english'
      | 'french'
      | 'german'
      | 'japanese'
      | 'spanish';
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxHtmlEditor>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxHtmlEditor>;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxHtmlEditor,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxHtmlEditor,
      FocusEvent
    >;
    export type HtmlEditorFormat =
      | 'background'
      | 'bold'
      | 'color'
      | 'font'
      | 'italic'
      | 'link'
      | 'size'
      | 'strike'
      | 'script'
      | 'underline'
      | 'blockquote'
      | 'header'
      | 'indent'
      | 'list'
      | 'align'
      | 'code-block';
    export type HtmlEditorImageUploadMode = 'base64' | 'server' | 'both';
    export type HtmlEditorImageUploadTab = 'url' | 'file';
    export type HtmlEditorPredefinedContextMenuItem =
      | 'background'
      | 'bold'
      | 'color'
      | 'font'
      | 'italic'
      | 'link'
      | 'image'
      | 'strike'
      | 'subscript'
      | 'superscript'
      | 'underline'
      | 'blockquote'
      | 'increaseIndent'
      | 'decreaseIndent'
      | 'orderedList'
      | 'bulletList'
      | 'alignLeft'
      | 'alignCenter'
      | 'alignRight'
      | 'alignJustify'
      | 'codeBlock'
      | 'variable'
      | 'undo'
      | 'redo'
      | 'clear'
      | 'insertTable'
      | 'insertHeaderRow'
      | 'insertRowAbove'
      | 'insertRowBelow'
      | 'insertColumnLeft'
      | 'insertColumnRight'
      | 'deleteColumn'
      | 'deleteRow'
      | 'deleteTable'
      | 'cellProperties'
      | 'tableProperties';
    export type HtmlEditorPredefinedToolbarItem =
      | 'background'
      | 'bold'
      | 'color'
      | 'font'
      | 'italic'
      | 'link'
      | 'image'
      | 'size'
      | 'strike'
      | 'subscript'
      | 'superscript'
      | 'underline'
      | 'blockquote'
      | 'header'
      | 'increaseIndent'
      | 'decreaseIndent'
      | 'orderedList'
      | 'bulletList'
      | 'alignLeft'
      | 'alignCenter'
      | 'alignRight'
      | 'alignJustify'
      | 'codeBlock'
      | 'variable'
      | 'separator'
      | 'undo'
      | 'redo'
      | 'clear'
      | 'cellProperties'
      | 'tableProperties'
      | 'insertTable'
      | 'insertHeaderRow'
      | 'insertRowAbove'
      | 'insertRowBelow'
      | 'insertColumnLeft'
      | 'insertColumnRight'
      | 'deleteColumn'
      | 'deleteRow'
      | 'deleteTable'
      | 'ai';
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxHtmlEditor>;
    export interface MentionTemplateData {
      readonly marker: string;
      readonly id?: string | number;
      readonly value?: any;
    }
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxHtmlEditor> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxHtmlEditorOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxHtmlEditor,
        KeyboardEvent | ClipboardEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorImageUpload {
    /**
     * Specifies a target Url for the upload request.
     */
    uploadUrl?: string | undefined;
    /**
     * Specifies a target directory for uploaded images.
     */
    uploadDirectory?: string | undefined;
    /**
     * Specifies how the HTML Editor UI component uploads files.
     */
    fileUploadMode?: DevExpress.ui.dxHtmlEditor.HtmlEditorImageUploadMode;
    /**
     * Contains an array of tabs in the &apos;Add an Image&apos; dialog.
     */
    tabs?: Array<
      | DevExpress.ui.dxHtmlEditor.ImageUploadTab
      | DevExpress.ui.dxHtmlEditor.HtmlEditorImageUploadTab
    >;
    /**
     * Configures the file uploader options.
     */
    fileUploaderOptions?: DevExpress.ui.dxFileUploader.Properties;
  }
  /**
   * @deprecated Use ImageUploadTab instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorImageUploadTabItem {
    /**
     * Specifies the tab&apos;s name.
     */
    name?: DevExpress.ui.dxHtmlEditor.HtmlEditorImageUploadTab | undefined;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorMediaResizing {
    /**
     * Specifies media types that can be resized. Currently, only images are supported.
     */
    allowedTargets?: Array<string>;
    /**
     * Enables media resizing.
     */
    enabled?: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorMention {
    /**
     * Provides data for the suggestion list.
     */
    dataSource?: DevExpress.data.DataSourceLike<any> | null;
    /**
     * Specifies the data field whose values should be displayed in the suggestion list.
     */
    displayExpr?: string | ((item: any) => string);
    /**
     * Specifies a custom template for suggestion list items.
     */
    itemTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the prefix that a user enters to activate mentions. You can use different prefixes with different dataSources.
     */
    marker?: string;
    /**
     * Specifies the minimum number of characters that a user should type to trigger the search.
     */
    minSearchLength?: number;
    /**
     * Specifies one or several data fields to search.
     */
    searchExpr?: string | Function | Array<string | Function>;
    /**
     * Specifies the delay between when a user stops typing and when the search is executed.
     */
    searchTimeout?: number;
    /**
     * Specifies a custom template for mentions.
     */
    template?:
      | template
      | ((
          mentionData: DevExpress.ui.dxHtmlEditor.MentionTemplateData,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies which data field provides unique values to the template&apos;s `id` parameter.
     */
    valueExpr?: string | Function;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorOptions extends EditorOptions<dxHtmlEditor> {
    /**
     * Binds the AI service to the HTML Editor.
     */
    aiIntegration?: DevExpress.aiIntegration.AIIntegration | undefined;
    /**
     * Allows users to break content into multiple lines within a single block element. The Shift + Enter key combination generates the new line.
     */
    allowSoftLineBreak?: boolean;
    /**
     * Allows you to customize the DevExtreme Quill and 3rd-party modules.
     */
    customizeModules?: (config: any) => void;
    /**
     * Allows you to convert an HTML Editor value between different markups.
     */
    converter?: DevExpress.ui.dxHtmlEditor.Converter | undefined;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Configures media resizing.
     */
    mediaResizing?: dxHtmlEditorMediaResizing;
    /**
     * Configures table resize.
     */
    tableResizing?: dxHtmlEditorTableResizing;
    /**
     * Configures mentions.
     */
    mentions?: Array<dxHtmlEditorMention>;
    /**
     * Configures table context menu settings.
     */
    tableContextMenu?: dxHtmlEditorTableContextMenu;
    /**
     * Configures the image upload.
     */
    imageUpload?: dxHtmlEditorImageUpload;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * A function that is executed when the UI component gets focus.
     */
    onFocusIn?: (e: DevExpress.ui.dxHtmlEditor.FocusInEvent) => void;
    /**
     * A function that is executed when the UI component loses focus.
     */
    onFocusOut?: (e: DevExpress.ui.dxHtmlEditor.FocusOutEvent) => void;
    /**
     * Specifies the text displayed when the input field is empty.
     */
    placeholder?: string;
    /**
     * Configures the UI component&apos;s toolbar.
     */
    toolbar?: dxHtmlEditorToolbar;
    /**
     * Configures variables that are placeholders for values created once text is processed.
     */
    variables?: dxHtmlEditorVariables;
    /**
     * Specifies how the HTML Editor&apos;s toolbar and content field are styled.
     */
    stylingMode?: DevExpress.common.EditorStyle;
  }
  /**
   * Configures table context menu settings.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorTableContextMenu {
    /**
     * Specifies whether to enable the table context menu.
     */
    enabled?: boolean;
    /**
     * Configures context menu items.
     */
    items?: Array<
      | DevExpress.ui.dxHtmlEditor.ContextMenuItem
      | DevExpress.ui.dxHtmlEditor.HtmlEditorPredefinedContextMenuItem
    >;
  }
  /**
   * @deprecated Use DevExpress.ui.dxHtmlEditor.ContextMenuItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorTableContextMenuItem
    extends DevExpress.ui.dxMenu.MenuBasePlainItem {
    /**
     * A name used to identify the context menu item.
     */
    name?:
      | DevExpress.ui.dxHtmlEditor.HtmlEditorPredefinedContextMenuItem
      | undefined;
    /**
     * Configures nested context menu items.
     */
    items?: Array<
      | DevExpress.ui.dxHtmlEditor.ContextMenuItem
      | DevExpress.ui.dxHtmlEditor.HtmlEditorPredefinedContextMenuItem
    >;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorTableResizing {
    /**
     * The minimum column width.
     */
    minColumnWidth?: number;
    /**
     * The minimum row height.
     */
    minRowHeight?: number;
    /**
     * Enables users to resize tables.
     */
    enabled?: boolean;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorToolbar {
    /**
     * Specifies the container in which to place the toolbar.
     */
    container?: string | DevExpress.core.UserDefinedElement;
    /**
     * Configures toolbar items. These items allow users to format text and execute commands.
     */
    items?: Array<
      | DevExpress.ui.dxHtmlEditor.ToolbarItem
      | DevExpress.ui.dxHtmlEditor.HtmlEditorPredefinedToolbarItem
    >;
    /**
     * Specifies whether or not items are arranged into multiple lines when their combined width exceeds the toolbar width.
     */
    multiline?: boolean;
  }
  /**
   * @deprecated Use ToolbarItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorToolbarItem
    extends DevExpress.ui.dxToolbar.Item {
    /**
     * Specifies the predefined item that this object customizes or a format with multiple choices.
     */
    name?: DevExpress.ui.dxHtmlEditor.HtmlEditorPredefinedToolbarItem | string;
    /**
     * Specifies values for a format with multiple choices. Should be used with the name.
     */
    acceptedValues?: Array<string | number | boolean>;
    /**
     * Specifies a location for the item on the toolbar.
     */
    location?: DevExpress.common.ToolbarItemLocation;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxHtmlEditorVariables {
    /**
     * Specifies a collection of variables available for a user.
     */
    dataSource?: DevExpress.data.DataSourceLike<string> | null;
    /**
     * Specifies the special character(s) that should surround the variables.
     */
    escapeChar?: string | Array<string>;
  }
  /**
   * Specifies markup for a UI component item.
   */
  export var dxItem: any;
  /**
   * The List is a UI component that represents a collection of items in a scrollable list.
   */
  export class dxList<
    TItem extends DevExpress.ui.dxList.ItemLike = any,
    TKey = any
  > extends CollectionWidget<dxListOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Gets the UI component&apos;s height in pixels.
     */
    clientHeight(): number;
    /**
     * Collapses a group with a specific index.
     */
    collapseGroup(groupIndex: number): DevExpress.core.utils.DxPromise<void>;
    /**
     * Removes an item found using its DOM node.
     */
    deleteItem(itemElement: Element): DevExpress.core.utils.DxPromise<void>;
    /**
     * Removes an item with a specific index.
     */
    deleteItem(itemIndex: number | any): DevExpress.core.utils.DxPromise<void>;
    /**
     * Expands a group with a specific index.
     */
    expandGroup(groupIndex: number): DevExpress.core.utils.DxPromise<void>;
    /**
     * Checks whether an item found using its DOM node is selected.
     */
    isItemSelected(itemElement: Element): boolean;
    /**
     * Checks whether an item with a specific index is selected.
     */
    isItemSelected(itemIndex: number | any): boolean;
    /**
     * Reloads list data.
     */
    reload(): void;
    /**
     * Reorders items found using their DOM nodes.
     */
    reorderItem(
      itemElement: Element,
      toItemElement: Element
    ): DevExpress.core.utils.DxPromise<void>;
    /**
     * Reorders items with specific indexes.
     */
    reorderItem(
      itemIndex: number | any,
      toItemIndex: number | any
    ): DevExpress.core.utils.DxPromise<void>;
    /**
     * Scrolls the content by a specified distance.
     */
    scrollBy(distance: number): void;
    /**
     * Gets the content&apos;s height in pixels.
     */
    scrollHeight(): number;
    /**
     * Scrolls the content to a specific position.
     */
    scrollTo(location: number): void;
    /**
     * Scrolls the content to an item found using its DOM node.
     */
    scrollToItem(itemElement: Element): void;
    /**
     * Scrolls the content to an item with a specific index.
     */
    scrollToItem(itemIndex: number | any): void;
    /**
     * Gets the top scroll offset.
     */
    scrollTop(): number;
    /**
     * Selects all items.
     */
    selectAll(): void;
    /**
     * Selects an item found using its DOM node.
     */
    selectItem(itemElement: Element): void;
    /**
     * Selects an item with a specific index.
     */
    selectItem(itemIndex: number | any): void;
    /**
     * Cancels the selection of all items.
     */
    unselectAll(): void;
    /**
     * Cancels the selection of an item found using its DOM node.
     */
    unselectItem(itemElement: Element): void;
    /**
     * Cancels the selection of an item with a specific index.
     */
    unselectItem(itemIndex: number | any): void;
    /**
     * Updates the UI component scrollbar according to UI component content size.
     */
    updateDimensions(): DevExpress.core.utils.DxPromise<void>;
  }
  module dxList {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      GroupRenderedEvent: GroupRenderedEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemDeletedEvent: ItemDeletedEvent<TItem, TKey>;
      ItemDeletingEvent: ItemDeletingEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      ItemReorderedEvent: ItemReorderedEvent<TItem, TKey>;
      ItemSwipeEvent: ItemSwipeEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      PageLoadingEvent: PageLoadingEvent<TItem, TKey>;
      PullRefreshEvent: PullRefreshEvent<TItem, TKey>;
      ScrollEvent: ScrollEvent<TItem, TKey>;
      SelectAllValueChangedEvent: SelectAllValueChangedEvent<TItem, TKey>;
      SelectionChangingEvent: SelectionChangingEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the groupRendered event handler&apos;s argument.
     */
    export type GroupRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> & {
      /**
       * 
       */
      readonly groupData?: any;
      /**
       * 
       */
      readonly groupElement?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly groupIndex?: number;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<dxList<TItem, TKey>>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxList<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      ListItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxList<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      ListItemInfo<TItem>;
    /**
     * The type of the itemDeleted event handler&apos;s argument.
     */
    export type ItemDeletedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      ListItemInfo<TItem>;
    export type ItemDeleteMode =
      | 'context'
      | 'slideButton'
      | 'slideItem'
      | 'static'
      | 'swipe'
      | 'toggle';
    /**
     * The type of the itemDeleting event handler&apos;s argument.
     */
    export type ItemDeletingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      ListItemInfo<TItem> & {
        /**
         * 
         */
        cancel?: boolean | PromiseLike<boolean> | PromiseLike<void>;
      };
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxList<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      ListItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends Item | any = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemReordered event handler&apos;s argument.
     */
    export type ItemReorderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      ListItemInfo<TItem> & {
        /**
         * 
         */
        readonly fromIndex: number;
        /**
         * 
         */
        readonly toIndex: number;
      };
    /**
     * The type of the itemSwipe event handler&apos;s argument.
     */
    export type ItemSwipeEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxList<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      ListItemInfo<TItem> & {
        /**
         * 
         */
        readonly direction: string;
      };
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ListItemInfo<TItem extends ItemLike> {
      /**
       * 
       */
      readonly itemData?: TItem;
      /**
       * 
       */
      readonly itemElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly itemIndex: number | { group: number; item: number };
    }
    export type ListMenuMode = 'context' | 'slide';
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the pageLoading event handler&apos;s argument.
     */
    export type PageLoadingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>>;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxListOptions<TItem, TKey>;
    /**
     * The type of the pullRefresh event handler&apos;s argument.
     */
    export type PullRefreshEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>>;
    /**
     * The type of the scroll event handler&apos;s argument.
     */
    export type ScrollEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxList<TItem, TKey>,
      Event
    > &
      ScrollInfo;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ScrollInfo {
      /**
       * 
       */
      readonly scrollOffset?: any;
      /**
       * 
       */
      readonly reachedLeft: boolean;
      /**
       * 
       */
      readonly reachedRight: boolean;
      /**
       * 
       */
      readonly reachedTop: boolean;
      /**
       * 
       */
      readonly reachedBottom: boolean;
    }
    /**
     * The type of the selectAllValueChanged event handler&apos;s argument.
     */
    export type SelectAllValueChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> & {
      /**
       * 
       */
      readonly value: boolean;
    };
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxList<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    /**
     * The type of the selectionChanging event handler&apos;s argument.
     */
    export type SelectionChangingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.ui.CollectionWidget.SelectionChangingEventBase<
      dxList<TItem, TKey>
    >;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxListItem extends CollectionWidgetItem {
    /**
     * Specifies the text of a badge displayed for the list item.
     */
    badge?: string;
    /**
     * Specifies the list item&apos;s icon.
     */
    icon?: string;
    /**
     * Specifies the name of the list items group in a grouped list.
     */
    key?: string;
    /**
     * Specifies whether or not to display a chevron for the list item.
     */
    showChevron?: boolean;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxListOptions<
    TItem extends DevExpress.ui.dxList.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxList<TItem, TKey>, TItem, TKey>,
      SearchBoxMixinOptions {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether or not an end user can delete list items.
     */
    allowItemDeleting?: boolean;
    /**
     * A Boolean value specifying whether to enable or disable the bounce-back effect.
     */
    bounceEnabled?: boolean;
    /**
     * Specifies whether or not an end user can collapse groups.
     */
    collapsibleGroups?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies the data field whose values should be displayed. Defaults to &apos;text&apos; when the data source contains objects.
     */
    displayExpr?: string | ((item: TItem) => string) | undefined;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies a custom template for group captions.
     */
    groupTemplate?:
      | template
      | ((
          groupData: any,
          groupIndex: number,
          groupElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether data items should be grouped.
     */
    grouped?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies whether or not to show the loading panel when the DataSource bound to the UI component is loading data.
     */
    indicateLoading?: boolean;
    /**
     * Specifies the way a user can delete items from the list.
     */
    itemDeleteMode?: DevExpress.ui.dxList.ItemDeleteMode;
    /**
     * Configures item reordering using drag and drop gestures.
     */
    itemDragging?: dxSortableOptions;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies the array of items for a context menu called for a list item.
     */
    menuItems?: Array<{
      /**
       * Holds on a function called when the item is clicked.
       */
      action?: (itemElement: DevExpress.core.DxElement, itemData: TItem) => any;
      /**
       * Specifies the menu item text.
       */
      text?: string;
    }>;
    /**
     * Specifies whether an item context menu is shown when a user holds or swipes an item.
     */
    menuMode?: DevExpress.ui.dxList.ListMenuMode;
    /**
     * The text displayed on the button used to load the next page from the data source.
     */
    nextButtonText?: string;
    /**
     * A function that is executed when a group element is rendered.
     */
    onGroupRendered?: (
      e: DevExpress.ui.dxList.GroupRenderedEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed when a collection item is clicked or tapped.
     */
    onItemClick?:
      | ((e: DevExpress.ui.dxList.ItemClickEvent<TItem, TKey>) => void)
      | string;
    /**
     * A function that is executed when a collection item is right-clicked or pressed.
     */
    onItemContextMenu?: (
      e: DevExpress.ui.dxList.ItemContextMenuEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed after a list item is deleted from the data source.
     */
    onItemDeleted?: (
      e: DevExpress.ui.dxList.ItemDeletedEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before a collection item is deleted from the data source.
     */
    onItemDeleting?: (
      e: DevExpress.ui.dxList.ItemDeletingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed when a collection item has been held for a specified period.
     */
    onItemHold?: (e: DevExpress.ui.dxList.ItemHoldEvent<TItem, TKey>) => void;
    /**
     * A function that is executed after a list item is moved to another position.
     */
    onItemReordered?: (
      e: DevExpress.ui.dxList.ItemReorderedEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed when a list item is swiped.
     */
    onItemSwipe?: (e: DevExpress.ui.dxList.ItemSwipeEvent<TItem, TKey>) => void;
    /**
     * A function that is executed before the next page is loaded.
     */
    onPageLoading?: (
      e: DevExpress.ui.dxList.PageLoadingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed when the &apos;pull to refresh&apos; gesture is performed. Supported on mobile devices only.
     */
    onPullRefresh?: (
      e: DevExpress.ui.dxList.PullRefreshEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed on each scroll gesture.
     */
    onScroll?: (e: DevExpress.ui.dxList.ScrollEvent<TItem, TKey>) => void;
    /**
     * A function that is executed when the &apos;Select All&apos; check box value is changed. Applies only if the selectionMode is &apos;all&apos;.
     */
    onSelectAllValueChanged?: (
      e: DevExpress.ui.dxList.SelectAllValueChangedEvent<TItem, TKey>
    ) => void;
    /**
     * Specifies whether the next page is loaded when a user scrolls the UI component to the bottom or when the &apos;next&apos; button is clicked.
     */
    pageLoadMode?: DevExpress.common.PageLoadMode;
    /**
     * Specifies the text shown in the pullDown panel, which is displayed when the list is scrolled to the bottom.
     */
    pageLoadingText?: string;
    /**
     * A Boolean value specifying whether or not the UI component supports the &apos;pull down to refresh&apos; gesture.
     */
    pullRefreshEnabled?: boolean;
    /**
     * Specifies the text displayed in the pullDown panel when the list is pulled below the refresh threshold.
     */
    pulledDownText?: string;
    /**
     * Specifies the text shown in the pullDown panel while the list is being pulled down to the refresh threshold.
     */
    pullingDownText?: string;
    /**
     * Specifies the text displayed in the pullDown panel while the list is being refreshed.
     */
    refreshingText?: string;
    /**
     * Specifies whether to repaint only those elements whose data changed.
     */
    repaintChangesOnly?: boolean;
    /**
     * A Boolean value specifying if the list is scrolled by content.
     */
    scrollByContent?: boolean;
    /**
     * Specifies whether a user can scroll the content with the scrollbar. Applies only if useNativeScrolling is false.
     */
    scrollByThumb?: boolean;
    /**
     * A Boolean value specifying whether to enable or disable list scrolling.
     */
    scrollingEnabled?: boolean;
    /**
     * Specifies the mode in which all items are selected.
     */
    selectAllMode?: DevExpress.common.SelectAllMode;
    /**
     * Specifies whether an item is selected if a user clicks it.
     */
    selectByClick?: boolean;
    /**
     * Specifies item selection mode.
     */
    selectionMode?: DevExpress.common.SingleMultipleAllOrNone;
    /**
     * Specifies when the UI component shows the scrollbar.
     */
    showScrollbar?: DevExpress.common.ScrollbarMode;
    /**
     * Specifies whether or not to display controls used to select list items. Not available if selectionMode is set to &apos;none&apos;.
     */
    showSelectionControls?: boolean;
    /**
     * Specifies the text displayed at the &apos;Select All&apos; check box.
     */
    selectAllText?: string;
    /**
     * Specifies whether or not the UI component uses native scrolling.
     */
    useNativeScrolling?: boolean;
  }
  /**
   * The LoadIndicator is a UI element notifying the viewer that a process is in progress.
   */
  export class dxLoadIndicator extends Widget<dxLoadIndicatorOptions> {}
  module dxLoadIndicator {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxLoadIndicator>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxLoadIndicator>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxLoadIndicator>;
    export type LoadingAnimationType = 'circle' | 'sparkle';
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxLoadIndicator> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxLoadIndicatorOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxLoadIndicatorOptions
    extends WidgetOptions<dxLoadIndicator> {
    /**
     * Specifies the animation type for LoadIndicator.
     */
    animationType?: DevExpress.ui.dxLoadIndicator.LoadingAnimationType;
    /**
     * Specifies the path to a custom load indicator image.
     */
    indicatorSrc?: string;
  }
  /**
   * The LoadPanel is an overlay UI component notifying the viewer that loading is in progress.
   */
  export class dxLoadPanel extends dxOverlay<dxLoadPanelOptions> {}
  module dxLoadPanel {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
    /**
     * The type of the hidden event handler&apos;s argument.
     */
    export type HiddenEvent =
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
    /**
     * The type of the hiding event handler&apos;s argument.
     */
    export type HidingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxLoadPanel>;
    /**
     * Configures the load indicator.
     */
    export type LoadPanelIndicatorProperties = {
      /**
       * Chooses between predefined load indicator animations.
       */
      animationType?: DevExpress.ui.dxLoadIndicator.LoadingAnimationType;
      /**
       * Specifies the path to a custom load indicator image.
       */
      src?: string;
      /**
       * Configures the load indicator&apos;s height.
       */
      height?: number | string | undefined;
      /**
       * Configures the load indicator width.
       */
      width?: number | string | undefined;
    };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxLoadPanel> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxLoadPanelOptions;
    /**
     * The type of the showing event handler&apos;s argument.
     */
    export type ShowingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
    /**
     * The type of the shown event handler&apos;s argument.
     */
    export type ShownEvent =
      DevExpress.common.core.events.EventInfo<dxLoadPanel>;
  }
  /**
   * Configures UI component visibility animations. This object contains two fields: show and hide.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxLoadPanelAnimation extends dxOverlayAnimation {
    /**
     * An object that defines the animation properties used when the UI component is being hidden.
     */
    hide?: DevExpress.common.core.animation.AnimationConfig;
    /**
     * An object that defines the animation properties used when the UI component is being shown.
     */
    show?: DevExpress.common.core.animation.AnimationConfig;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxLoadPanelOptions extends dxOverlayOptions<dxLoadPanel> {
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: dxLoadPanelAnimation;
    /**
     * Specifies the UI component&apos;s container.
     */
    container?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * The delay in milliseconds after which the load panel is displayed.
     */
    delay?: number;
    /**
     * Specifies whether or not the UI component can be focused.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies the path to a custom load indicator image.
     * @deprecated Use the indicatorOptions option instead.
     */
    indicatorSrc?: string;
    /**
     * Configures the load indicator.
     */
    indicatorOptions?: DevExpress.ui.dxLoadPanel.LoadPanelIndicatorProperties;
    /**
     * Specifies the maximum height the UI component can reach while resizing.
     */
    maxHeight?: number | string;
    /**
     * Specifies the maximum width the UI component can reach while resizing.
     */
    maxWidth?: number | string;
    /**
     * Specifies the text displayed in the load panel. Ignored in the Material Design theme.
     */
    message?: string;
    /**
     * Positions the UI component.
     */
    position?:
      | DevExpress.common.PositionAlignment
      | DevExpress.common.core.animation.PositionConfig
      | Function;
    /**
     * Specifies the shading color. Applies only if shading is enabled.
     */
    shadingColor?: string;
    /**
     * A Boolean value specifying whether or not to show a load indicator.
     */
    showIndicator?: boolean;
    /**
     * A Boolean value specifying whether or not to show the pane behind the load indicator.
     */
    showPane?: boolean;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The Lookup is a UI component that allows an end user to search for an item in a collection shown in a drop-down menu.
   */
  export class dxLookup extends dxDropDownList<dxLookupOptions> {}
  module dxLookup {
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent = DevExpress.common.core.events.EventInfo<dxLookup>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxLookup>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxLookup>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxLookup>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxLookup,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent = DevExpress.common.core.events.EventInfo<dxLookup>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxLookup> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the pageLoading event handler&apos;s argument.
     */
    export type PageLoadingEvent =
      DevExpress.common.core.events.EventInfo<dxLookup>;
    export type Properties = dxLookupOptions;
    /**
     * The type of the pullRefresh event handler&apos;s argument.
     */
    export type PullRefreshEvent =
      DevExpress.common.core.events.EventInfo<dxLookup>;
    /**
     * The type of the scroll event handler&apos;s argument.
     */
    export type ScrollEvent = DevExpress.common.core.events.NativeEventInfo<
      dxLookup,
      MouseEvent | Event
    > &
      DevExpress.ui.dxList.ScrollInfo;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxLookup> &
        DevExpress.ui.dxDropDownList.SelectionChangedInfo;
    export type TitleRenderedEvent =
      DevExpress.common.core.events.EventInfo<dxLookup> &
        DevExpress.ui.dxPopup.TitleRenderedInfo;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxLookup,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxLookupOptions extends dxDropDownListOptions<dxLookup> {
    /**
     * The text displayed on the Apply button.
     */
    applyButtonText?: string;
    /**
     * Specifies the way an end user applies the selected value.
     */
    applyValueMode?: DevExpress.common.ApplyValueMode;
    /**
     * The text displayed on the Cancel button.
     */
    cancelButtonText?: string;
    /**
     * Specifies whether or not the UI component cleans the search box when the popup window is displayed.
     */
    cleanSearchOnOpening?: boolean;
    /**
     * The text displayed on the Clear button.
     */
    clearButtonText?: string;
    /**
     * Specifies a custom template for the input field.
     */
    fieldTemplate?:
      | template
      | ((
          selectedItem: any,
          fieldElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies a custom template for group captions.
     */
    groupTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether data items should be grouped.
     */
    grouped?: boolean;
    /**
     * The text displayed on the button used to load the next page from the data source.
     */
    nextButtonText?: string;
    /**
     * A function that is executed before the next page is loaded.
     */
    onPageLoading?: (e: DevExpress.ui.dxLookup.PageLoadingEvent) => void;
    /**
     * A function that is executed when the &apos;pull to refresh&apos; gesture is performed on the drop-down item list. Supported on mobile devices only.
     */
    onPullRefresh?: (e: DevExpress.ui.dxLookup.PullRefreshEvent) => void;
    /**
     * A function that is executed on each scroll gesture performed on the drop-down item list.
     */
    onScroll?: (e: DevExpress.ui.dxLookup.ScrollEvent) => void;
    /**
     * A function that is executed after the UI component&apos;s value is changed.
     */
    onValueChanged?: (e: DevExpress.ui.dxLookup.ValueChangedEvent) => void;
    /**
     * Specifies whether the next page is loaded when a user scrolls the UI component to the bottom or when the &apos;next&apos; button is clicked.
     */
    pageLoadMode?: DevExpress.common.PageLoadMode;
    /**
     * Specifies the text shown in the pullDown panel, which is displayed when the UI component is scrolled to the bottom.
     */
    pageLoadingText?: string;
    /**
     * The text displayed by the UI component when nothing is selected.
     */
    placeholder?: string;
    /**
     * A Boolean value specifying whether or not the UI component supports the &apos;pull down to refresh&apos; gesture.
     */
    pullRefreshEnabled?: boolean;
    /**
     * Specifies the text displayed in the pullDown panel when the UI component is pulled below the refresh threshold.
     */
    pulledDownText?: string;
    /**
     * Specifies the text shown in the pullDown panel while the list is being pulled down to the refresh threshold.
     */
    pullingDownText?: string;
    /**
     * Specifies the text displayed in the pullDown panel while the UI component is being refreshed.
     */
    refreshingText?: string;
    /**
     * Specifies whether the search box is visible.
     */
    searchEnabled?: boolean;
    /**
     * The text that is provided as a hint in the lookup&apos;s search bar.
     */
    searchPlaceholder?: string;
    /**
     * Specifies whether to display the Cancel button in the lookup window.
     */
    showCancelButton?: boolean;
    /**
     * Specifies whether to display the Clear button in the lookup window.
     */
    showClearButton?: boolean;
    /**
     * Specifies the DOM events after which the UI component&apos;s search results should be updated.
     */
    searchStartEvent?: string;
    /**
     * Specifies whether or not the UI component uses native scrolling.
     */
    useNativeScrolling?: boolean;
    /**
     * Specifies whether to show lookup contents in the Popover UI component.
     */
    usePopover?: boolean;
    /**
     * Specifies whether to vertically align the drop-down menu so that the selected item is in its center. Applies only in Material Design themes.
     */
    dropDownCentered?: boolean;
    /**
     * Configures the drop-down field.
     */
    dropDownOptions?: DevExpress.ui.dxPopover.Properties;
  }
  /**
   * The Map is an interactive UI component that displays a geographic map with markers and routes.
   */
  export class dxMap extends Widget<dxMapOptions> {
    /**
     * Adds a marker to the map.
     */
    addMarker(
      markerOptions: any | Array<any>
    ): DevExpress.core.utils.DxPromise<any>;
    /**
     * Adds a route to the map.
     */
    addRoute(options: any | Array<any>): DevExpress.core.utils.DxPromise<any>;
    /**
     * Removes a marker from the map.
     */
    removeMarker(
      marker: any | number | Array<any>
    ): DevExpress.core.utils.DxPromise<void>;
    /**
     * Removes a route from the map.
     */
    removeRoute(
      route: any | number | Array<any>
    ): DevExpress.core.utils.DxPromise<void>;
  }
  module dxMap {
    /**
     * The type of the click event handler&apos;s argument.
     */
    export type ClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxMap,
      MouseEvent | PointerEvent
    > & {
      /**
       * The clicked location.
       */
      location: MapLocation;
    };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent = DevExpress.common.core.events.EventInfo<dxMap>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxMap>;
    export type MapProvider = 'azure' | 'bing' | 'google' | 'googleStatic';
    export type MapType = 'hybrid' | 'roadmap' | 'satellite';
    /**
     * The type of the markerAdded event handler&apos;s argument.
     */
    export type MarkerAddedEvent =
      DevExpress.common.core.events.EventInfo<dxMap> & {
        /**
         * 
         */
        readonly options: any;
        /**
         * 
         */
        originalMarker: any;
      };
    /**
     * The type of the markerRemoved event handler&apos;s argument.
     */
    export type MarkerRemovedEvent =
      DevExpress.common.core.events.EventInfo<dxMap> & {
        /**
         * 
         */
        readonly options?: any;
      };
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxMap> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxMapOptions;
    /**
     * The type of the ready event handler&apos;s argument.
     */
    export type ReadyEvent = DevExpress.common.core.events.EventInfo<dxMap> & {
      /**
       * 
       */
      originalMap: any;
    };
    /**
     * The type of the routeAdded event handler&apos;s argument.
     */
    export type RouteAddedEvent =
      DevExpress.common.core.events.EventInfo<dxMap> & {
        /**
         * 
         */
        readonly options: any;
        /**
         * 
         */
        originalRoute: any;
      };
    export type RouteMode = 'driving' | 'walking';
    /**
     * The type of the routeRemoved event handler&apos;s argument.
     */
    export type RouteRemovedEvent =
      DevExpress.common.core.events.EventInfo<dxMap> & {
        /**
         * 
         */
        readonly options?: any;
      };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMapOptions extends WidgetOptions<dxMap> {
    /**
     * Keys to authenticate the component within map providers.
     */
    apiKey?:
      | string
      | {
          /**
           * A key used to authenticate the component within Azure Maps.
           */
          azure?: string;
          /**
           * A key used to authenticate the component within Bing Maps.
           * @deprecated 
           */
          bing?: string;
          /**
           * A key used to authenticate the component within Google Maps.
           */
          google?: string;
          /**
           * A key used to authenticate the component within Google Maps Static.
           */
          googleStatic?: string;
        };
    /**
     * Specifies whether the UI component automatically adjusts center and zoom property values when adding a new marker or route, or if a new UI component contains markers or routes by default.
     */
    autoAdjust?: boolean;
    /**
     * An object, a string, or an array specifying which part of the map is displayed at the UI component&apos;s center using coordinates. The UI component can change this value if autoAdjust is enabled.
     */
    center?: any | string | Array<number>;
    /**
     * Specifies whether or not map UI component controls are available.
     */
    controls?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * A URL pointing to the custom icon to be used for map markers.
     */
    markerIconSrc?: string;
    /**
     * An array of markers displayed on a map.
     */
    markers?: Array<{
      /**
       * A URL pointing to the custom icon to be used for the marker.
       */
      iconSrc?: string;
      /**
       * Specifies the marker location.
       */
      location?: any | string | Array<number>;
      /**
       * A callback function performed when the marker is clicked.
       */
      onClick?: Function;
      /**
       * A tooltip to be used for the marker.
       */
      tooltip?:
        | string
        | {
            /**
             * Specifies whether a tooltip is visible by default or not.
             */
            isShown?: boolean;
            /**
             * Specifies the text or HTML markup displayed in the tooltip.
             */
            text?: string;
          };
    }>;
    /**
     * A function that is executed when any location on the map is clicked or tapped.
     */
    onClick?: ((e: DevExpress.ui.dxMap.ClickEvent) => void) | string;
    /**
     * A function that is executed when a marker is created on the map.
     */
    onMarkerAdded?: (e: DevExpress.ui.dxMap.MarkerAddedEvent) => void;
    /**
     * A function that is executed when a marker is removed from the map.
     */
    onMarkerRemoved?: (e: DevExpress.ui.dxMap.MarkerRemovedEvent) => void;
    /**
     * A function that is executed when the map is ready.
     */
    onReady?: (e: DevExpress.ui.dxMap.ReadyEvent) => void;
    /**
     * A function that is executed when a route is created on the map.
     */
    onRouteAdded?: (e: DevExpress.ui.dxMap.RouteAddedEvent) => void;
    /**
     * A function that is executed when a route is removed from the map.
     */
    onRouteRemoved?: (e: DevExpress.ui.dxMap.RouteRemovedEvent) => void;
    /**
     * The name of the current map data provider.
     */
    provider?: DevExpress.ui.dxMap.MapProvider;
    /**
     * A provider configuration object.
     */
    providerConfig?: {
      /**
       * Specifies a map ID for the `google` and `googleStatic` providers.
       */
      mapId?: string;
      /**
       * Specifies whether to use advanced markers with the `google` and `googleStatic` providers.
       * @deprecated 
       */
      useAdvancedMarkers?: boolean;
    };
    /**
     * An array of routes shown on the map.
     */
    routes?: Array<{
      /**
       * Specifies the color of the line displaying the route.
       */
      color?: string;
      /**
       * Contains an array of objects making up the route.
       */
      locations?: Array<any>;
      /**
       * Specifies a transportation mode to be used in the displayed route.
       */
      mode?: DevExpress.ui.dxMap.RouteMode | string;
      /**
       * Specifies the opacity of the line displaying the route.
       */
      opacity?: number;
      /**
       * Specifies the thickness of the line displaying the route in pixels.
       */
      weight?: number;
    }>;
    /**
     * The type of a map to display.
     */
    type?: DevExpress.ui.dxMap.MapType;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
    /**
     * The map&apos;s zoom level. The UI component can change this value if autoAdjust is enabled.
     */
    zoom?: number;
  }
  /**
   * The Menu UI component is a panel with clickable items. A click on an item opens a drop-down menu, which can contain several submenus.
   */
  export class dxMenu<
    TItem extends DevExpress.ui.dxMenu.ItemLike = any,
    TKey = any
  > extends dxMenuBase<dxMenuOptions<TItem, TKey>, TItem, TKey> {}
  module dxMenu {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike = any, TKey = any> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
      SubmenuHiddenEvent: SubmenuHiddenEvent<TItem, TKey>;
      SubmenuHidingEvent: SubmenuHidingEvent<TItem, TKey>;
      SubmenuShowingEvent: SubmenuShowingEvent<TItem, TKey>;
      SubmenuShownEvent: SubmenuShownEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<dxMenu<TItem, TKey>>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxMenu<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxMenu<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface MenuBasePlainItem extends CollectionWidgetItem {
      /**
       * Specifies whether a group separator is displayed over the item.
       */
      beginGroup?: boolean;
      /**
       * Specifies if a menu is closed when a user clicks the item. Does not apply to the root items.
       */
      closeMenuOnClick?: boolean;
      /**
       * Specifies whether the menu item responds to user interaction.
       */
      disabled?: boolean;
      /**
       * Specifies the menu item&apos;s icon.
       */
      icon?: string;
      /**
       * Specifies whether or not a user can select a menu item.
       */
      selectable?: boolean;
      /**
       * Specifies whether or not the item is selected.
       */
      selected?: boolean;
      /**
       * Specifies the text inserted into the item element.
       */
      text?: string;
      /**
       * Specifies whether or not the menu item is visible.
       */
      visible?: boolean;
    }
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxMenuOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    export type SubmenuDirection = 'auto' | 'leftOrTop' | 'rightOrBottom';
    /**
     * The type of the submenuHidden event handler&apos;s argument.
     */
    export type SubmenuHiddenEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> & {
      /**
       * 
       */
      readonly itemData?: TItem;
      /**
       * 
       */
      readonly rootItem?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly submenuContainer?: DevExpress.core.DxElement;
    };
    /**
     * The type of the submenuHiding event handler&apos;s argument.
     */
    export type SubmenuHidingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> & {
        /**
         * 
         */
        readonly itemData?: TItem;
        /**
         * 
         */
        readonly rootItem?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly submenuContainer?: DevExpress.core.DxElement;
      };
    /**
     * The type of the submenuShowing event handler&apos;s argument.
     */
    export type SubmenuShowingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> & {
      /**
       * 
       */
      readonly itemData?: TItem;
      /**
       * 
       */
      readonly rootItem?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly submenuContainer?: DevExpress.core.DxElement;
    };
    /**
     * The type of the submenuShown event handler&apos;s argument.
     */
    export type SubmenuShownEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMenu<TItem, TKey>> & {
      /**
       * 
       */
      readonly itemData?: TItem;
      /**
       * 
       */
      readonly rootItem?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly submenuContainer?: DevExpress.core.DxElement;
    };
  }
  /**
   * The base class for UI components containing an item collection.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxMenuBase<
    TProperties extends dxMenuBaseOptions<any, TItem, TKey>,
    TItem extends DevExpress.ui.dxMenuBase.ItemLike = any,
    TKey = any
  > extends HierarchicalCollectionWidget<TProperties, TItem, TKey> {
    /**
     * Selects an item found using its DOM node.
     */
    selectItem(itemElement: Element): void;
    /**
     * Cancels the selection of an item found using its DOM node.
     */
    unselectItem(itemElement: Element): void;
  }
  module dxMenuBase {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = dxMenuBaseItem | any;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMenuBaseItem
    extends DevExpress.ui.dxMenu.MenuBasePlainItem {
    /**
     * Specifies nested menu items.
     */
    items?: Array<dxMenuBaseItem>;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMenuBaseOptions<
    TComponent extends dxMenuBase<any, TItem, TKey>,
    TItem extends DevExpress.ui.dxMenuBase.ItemLike = any,
    TKey = any
  > extends Omit<
      HierarchicalCollectionWidgetOptions<TComponent, TItem, TKey>,
      'dataSource'
    > {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: {
      /**
       * An object that defines the animation properties used when the UI component is being hidden.
       */
      hide?: DevExpress.common.core.animation.AnimationConfig;
      /**
       * An object that defines the animation properties used when the UI component is being shown.
       */
      show?: DevExpress.common.core.animation.AnimationConfig;
    };
    /**
     * Specifies the name of the CSS class to be applied to the root menu level and all submenus.
     */
    cssClass?: string;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Holds an array of menu items.
     */
    items?: Array<TItem>;
    /**
     * Specifies whether an item is selected if a user clicks it.
     */
    selectByClick?: boolean;
    /**
     * Specifies the selection mode supported by the menu.
     */
    selectionMode?: DevExpress.common.SingleOrNone;
    /**
     * Specifies properties of submenu showing and hiding.
     */
    showSubmenuMode?:
      | {
          /**
           * Specifies the delay of submenu show and hiding.
           */
          delay?:
            | {
                /**
                 * The time span after which the submenu is hidden.
                 */
                hide?: number;
                /**
                 * The time span after which the submenu is shown.
                 */
                show?: number;
              }
            | number;
          /**
           * Specifies the mode name.
           */
          name?: DevExpress.common.SubmenuShowMode;
        }
      | DevExpress.common.SubmenuShowMode;
  }
  /**
   * @deprecated Use DevExpress.ui.dxMenu.Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMenuItem extends dxMenuBaseItem {
    /**
     * Specifies nested menu items.
     */
    items?: Array<DevExpress.ui.dxMenu.Item>;
    /**
     * Specifies a web address to be opened when a user clicks on an item.
     */
    url?: string;
    /**
     * Specifies link attributes for the url option.
     */
    linkAttr?: { [key: string]: any };
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxMenuOptions<
    TItem extends DevExpress.ui.dxMenu.ItemLike = any,
    TKey = any
  > extends dxMenuBaseOptions<dxMenu<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies whether adaptive rendering is enabled. This property is in effect only if the orientation is &apos;horizontal&apos;.
     */
    adaptivityEnabled?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether or not the submenu is hidden when the mouse pointer leaves it.
     */
    hideSubmenuOnMouseLeave?: boolean;
    /**
     * Holds an array of menu items.
     */
    items?: Array<TItem>;
    /**
     * A function that is executed after a submenu is hidden.
     */
    onSubmenuHidden?: (
      e: DevExpress.ui.dxMenu.SubmenuHiddenEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before a submenu is hidden.
     */
    onSubmenuHiding?: (
      e: DevExpress.ui.dxMenu.SubmenuHidingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed before a submenu is displayed.
     */
    onSubmenuShowing?: (
      e: DevExpress.ui.dxMenu.SubmenuShowingEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed after a submenu is displayed.
     */
    onSubmenuShown?: (
      e: DevExpress.ui.dxMenu.SubmenuShownEvent<TItem, TKey>
    ) => void;
    /**
     * Specifies whether the menu has horizontal or vertical orientation.
     */
    orientation?: DevExpress.common.Orientation;
    /**
     * Specifies properties for showing and hiding the first level submenu.
     */
    showFirstSubmenuMode?:
      | {
          /**
           * Specifies the delay in submenu showing and hiding.
           */
          delay?:
            | {
                /**
                 * The time span after which the submenu is hidden.
                 */
                hide?: number;
                /**
                 * The time span after which the submenu is shown.
                 */
                show?: number;
              }
            | number;
          /**
           * Specifies the mode name.
           */
          name?: DevExpress.common.SubmenuShowMode;
        }
      | DevExpress.common.SubmenuShowMode;
    /**
     * Specifies the direction at which the submenus are displayed.
     */
    submenuDirection?: DevExpress.ui.dxMenu.SubmenuDirection;
  }
  /**
   * The MultiView is a UI component that contains several views. An end user navigates through the views by swiping them in the horizontal direction.
   */
  export class dxMultiView<
    TItem extends DevExpress.ui.dxMultiView.ItemLike = any,
    TKey = any
  > extends CollectionWidget<
    DevExpress.ui.dxMultiView.Properties<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxMultiView {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMultiView<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMultiView<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxMultiView<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxMultiView<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxMultiView<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxMultiView<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMultiView<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMultiView<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxMultiViewOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxMultiView<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMultiViewBaseOptions<
    TComponent extends dxMultiView<TItem, TKey> = dxMultiView<any, any>,
    TItem extends DevExpress.ui.dxMultiView.ItemLike = any,
    TKey = any
  > extends Omit<CollectionWidgetOptions<TComponent, TItem, TKey>, 'keyExpr'> {
    /**
     * Specifies whether or not to animate the displayed item change.
     */
    animationEnabled?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether to render the view&apos;s content when it is displayed. If false, the content is rendered immediately.
     */
    deferRendering?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * A Boolean value specifying whether or not to scroll back to the first item after the last item is swiped.
     */
    loop?: boolean;
    /**
     * The index of the currently displayed item.
     */
    selectedIndex?: number;
    /**
     * A Boolean value specifying whether or not to allow users to change the selected index by swiping.
     */
    swipeEnabled?: boolean;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxMultiViewItem extends CollectionWidgetItem {}
  /**
   * 
   * @deprecated 
   */
  export interface dxMultiViewOptions<
    TItem extends DevExpress.ui.dxMultiView.ItemLike = any,
    TKey = any
  > extends dxMultiViewBaseOptions<dxMultiView<TItem, TKey>, TItem, TKey> {}
  /**
   * The NumberBox is a UI component that displays a numeric value and allows a user to modify it by typing in a value, and incrementing or decrementing it using the keyboard or mouse.
   */
  export class dxNumberBox extends dxTextEditor<dxNumberBoxOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxNumberBox.Properties['value']): void;
  }
  module dxNumberBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      Event
    >;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxNumberBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxNumberBox>;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxNumberBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      KeyboardEvent
    >;
    export type NumberBoxPredefinedButton = 'clear' | 'spins';
    export type NumberBoxType = 'number' | 'text' | 'tel';
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxNumberBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxNumberBox,
      ClipboardEvent
    >;
    export type Properties = dxNumberBoxOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxNumberBox,
        DevExpress.events.InteractionEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxNumberBoxOptions extends dxTextEditorOptions<dxNumberBox> {
    /**
     * Allows you to add custom buttons to the input text field.
     */
    buttons?: Array<
      | DevExpress.ui.dxNumberBox.NumberBoxPredefinedButton
      | DevExpress.common.TextEditorButton
    >;
    /**
     * Specifies the value&apos;s display format and controls user input accordingly.
     */
    format?: DevExpress.common.core.localization.Format;
    /**
     * Specifies the text of the message displayed if the specified value is not a number.
     */
    invalidValueMessage?: string;
    /**
     * The maximum value accepted by the number box.
     */
    max?: number | undefined;
    /**
     * The minimum value accepted by the number box.
     */
    min?: number | undefined;
    /**
     * Specifies the value to be passed to the type attribute of the underlying `` element.
     */
    mode?: DevExpress.ui.dxNumberBox.NumberBoxType;
    /**
     * Specifies whether to show the buttons that change the value by a step.
     */
    showSpinButtons?: boolean;
    /**
     * Specifies how much the UI component&apos;s value changes when using the spin buttons, Up/Down arrow keys, or mouse wheel.
     */
    step?: number;
    /**
     * Specifies whether to use touch friendly spin buttons. Applies only if showSpinButtons is true.
     */
    useLargeSpinButtons?: boolean;
    /**
     * The current number box value.
     */
    value?: number;
  }
  /**
   * The Overlay UI component represents a window overlaying the current view. It displays data located within the HTML element representing the UI component.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxOverlay<TProperties> extends Widget<TProperties> {
    /**
     * Gets the UI component&apos;s content.
     */
    content(): DevExpress.core.DxElement;
    /**
     * Hides the UI component.
     */
    hide(): DevExpress.core.utils.DxPromise<boolean>;
    /**
     * Recalculates the UI component&apos;s size and position without rerendering.
     */
    repaint(): void;
    /**
     * Shows the UI component.
     */
    show(): DevExpress.core.utils.DxPromise<boolean>;
    /**
     * Shows or hides the UI component depending on the argument.
     */
    toggle(showing: boolean): DevExpress.core.utils.DxPromise<boolean>;
  }
  /**
   * Configures UI component visibility animations. This object contains two fields: show and hide.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxOverlayAnimation {
    /**
     * An object that defines the animation properties used when the UI component is being hidden.
     */
    hide?: DevExpress.common.core.animation.AnimationConfig;
    /**
     * An object that defines the animation properties used when the UI component is being shown.
     */
    show?: DevExpress.common.core.animation.AnimationConfig;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxOverlayOptions<TComponent>
    extends WidgetOptions<TComponent> {
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: dxOverlayAnimation;
    /**
     * Specifies a custom template for the UI component content.
     */
    contentTemplate?:
      | template
      | ((
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies whether to render the UI component&apos;s content when it is displayed. If false, the content is rendered immediately.
     */
    deferRendering?: boolean;
    /**
     * Specifies the global attributes to be attached to the UI component&apos;s container element.
     * @deprecated 
     */
    elementAttr?: any;
    /**
     * Specifies whether to hide the UI component if a user clicks outside it.
     */
    hideOnOutsideClick?:
      | boolean
      | ((
          event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>
        ) => boolean);
    /**
     * Specifies whether to hide the widget when users scroll one of its parent elements.
     */
    hideOnParentScroll?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies the maximum height the UI component can reach while resizing.
     */
    maxHeight?: number | string;
    /**
     * Specifies the maximum width the UI component can reach while resizing.
     */
    maxWidth?: number | string;
    /**
     * Specifies the minimum height the UI component can reach while resizing.
     */
    minHeight?: number | string;
    /**
     * Specifies the minimum width the UI component can reach while resizing.
     */
    minWidth?: number | string;
    /**
     * A function that is executed after the UI component is hidden.
     */
    onHidden?: (e: DevExpress.common.core.events.EventInfo<TComponent>) => void;
    /**
     * A function that is executed before the UI component is hidden.
     */
    onHiding?: (
      e: DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<TComponent>
    ) => void;
    /**
     * A function that is executed before the UI component is displayed.
     */
    onShowing?: (
      e: DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<TComponent>
    ) => void;
    /**
     * A function that is executed after the UI component is displayed.
     */
    onShown?: (e: DevExpress.common.core.events.EventInfo<TComponent>) => void;
    /**
     * Positions the UI component.
     */
    position?: any;
    /**
     * Specifies whether to shade the background when the UI component is active.
     */
    shading?: boolean;
    /**
     * Specifies the shading color. Applies only if shading is enabled.
     */
    shadingColor?: string;
    /**
     * A Boolean value specifying whether or not the UI component is visible.
     */
    visible?: boolean;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
    /**
     * Specifies the global attributes for the UI component&apos;s wrapper element.
     */
    wrapperAttr?: any;
  }
  /**
   * Pagination is a UI component that allows users to navigate through pages and change page size at runtime. Pagination UI includes a page navigator and several optional elements: a page size selector, navigation buttons, and page information.
   */
  export class dxPagination extends Widget<DevExpress.ui.dxPagination.Properties> {
    /**
     * Gets the number of pages.
     */
    getPageCount(): number;
  }
  module dxPagination {
    export type PageSize = number | 'all';
    export type Properties = dxPaginationOptions;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxPaginationOptions
    extends DevExpress.common.PagerBase,
      WidgetOptions<dxPagination> {
    /**
     * Specifies the page index.
     */
    pageIndex?: number;

    /**
     * Specifies the page size.
     */
    pageSize?: number;

    /**
     * Specifies the total number of items.
     */
    itemCount?: number;

    /**
     * Specifies page sizes available in the page size selector.
     */
    allowedPageSizes?: Array<DevExpress.ui.dxPagination.PageSize>;
  }
  /**
   * The PivotGrid is a UI component that allows you to display and analyze multi-dimensional data from a local storage or an OLAP cube.
   */
  export class dxPivotGrid extends Widget<dxPivotGridOptions> {
    /**
     * Binds a Chart to the PivotGrid.
     */
    bindChart(
      chart: string | DevExpress.core.DxElement | any,
      integrationOptions: {
        inverted?: boolean;
        dataFieldsDisplayMode?: string;
        putDataFieldsInto?: string;
        alternateDataFields?: boolean;
        processCell?: Function;
        customizeChart?: Function;
        customizeSeries?: Function;
      }
    ): Function & null;
    /**
     * Gets the PivotGridDataSource instance.
     */
    getDataSource(): DevExpress.data.PivotGridDataSource;
    /**
     * Gets the Popup instance of the field chooser window.
     */
    getFieldChooserPopup(): dxPopup;
    /**
     * Updates the UI component to the size of its content.
     */
    updateDimensions(): void;
  }
  module dxPivotGrid {
    /**
     * The type of the cellClick event handler&apos;s argument.
     */
    export type CellClickEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxPivotGrid,
        MouseEvent | PointerEvent
      > & {
        /**
         * 
         */
        readonly area?: string;
        /**
         * 
         */
        readonly cellElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly cell?: Cell;
        /**
         * 
         */
        readonly rowIndex?: number;
        /**
         * 
         */
        readonly columnIndex?: number;
        /**
         * 
         */
        readonly columnFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
        /**
         * 
         */
        readonly rowFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
        /**
         * 
         */
        readonly dataFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
      };
    /**
     * The type of the cellPrepared event handler&apos;s argument.
     */
    export type CellPreparedEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGrid> & {
        /**
         * 
         */
        readonly area?: string;
        /**
         * 
         */
        readonly cellElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly cell?: Cell;
        /**
         * 
         */
        readonly rowIndex?: number;
        /**
         * 
         */
        readonly columnIndex?: number;
      };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGrid>;
    /**
     * The type of the contextMenuPreparing event handler&apos;s argument.
     */
    export type ContextMenuPreparingEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGrid> & {
        /**
         * 
         */
        readonly area?: string;
        /**
         * 
         */
        readonly cell?: Cell;
        /**
         * 
         */
        readonly cellElement?: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly columnIndex?: number;
        /**
         * 
         */
        readonly rowIndex?: number;
        /**
         * 
         */
        readonly dataFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
        /**
         * 
         */
        readonly rowFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
        /**
         * 
         */
        readonly columnFields?: Array<DevExpress.data.PivotGridDataSource.Field>;
        /**
         * 
         */
        readonly field?: DevExpress.data.PivotGridDataSource.Field;
        /**
         * 
         */
        items?: Array<any>;
      };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGrid>;
    /**
     * The type of the exporting event handler&apos;s argument.
     */
    export type ExportingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxPivotGrid> & {
        /**
         * 
         */
        fileName?: string;
      };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxPivotGrid>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGrid> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type PivotGridDataFieldArea = 'column' | 'row';
    export type PivotGridRowHeaderLayout = 'standard' | 'tree';
    export type PivotGridTotalDisplayMode =
      | 'both'
      | 'columns'
      | 'none'
      | 'rows';
    export type Properties = dxPivotGridOptions;
  }
  /**
   * A complementary UI component for the PivotGrid that allows you to manage data displayed in the PivotGrid. The field chooser is already integrated in the PivotGrid and can be invoked using the context menu. If you need to continuously display the field chooser near the PivotGrid UI component, use the PivotGridFieldChooser UI component.
   */
  export class dxPivotGridFieldChooser extends Widget<dxPivotGridFieldChooserOptions> {
    /**
     * Applies changes made in the UI component to the PivotGrid. Takes effect only if applyChangesMode is &apos;onDemand&apos;.
     */
    applyChanges(): void;
    /**
     * Cancels changes made in the UI component without applying them to the PivotGrid. Takes effect only if applyChangesMode is &apos;onDemand&apos;.
     */
    cancelChanges(): void;
    /**
     * Gets the PivotGridDataSource instance.
     */
    getDataSource(): DevExpress.data.PivotGridDataSource;
    /**
     * Updates the UI component to the size of its content.
     */
    updateDimensions(): void;
  }
  module dxPivotGridFieldChooser {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGridFieldChooser>;
    /**
     * The type of the contextMenuPreparing event handler&apos;s argument.
     */
    export type ContextMenuPreparingEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGridFieldChooser> & {
        /**
         * 
         */
        readonly area?: string;
        /**
         * 
         */
        readonly field?: DevExpress.data.PivotGridDataSource.Field;
        /**
         * 
         */
        readonly event?: DevExpress.events.DxEvent;
        /**
         * 
         */
        items?: Array<any>;
      };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGridFieldChooser>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxPivotGridFieldChooser>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxPivotGridFieldChooser> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxPivotGridFieldChooserOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPivotGridFieldChooserOptions
    extends WidgetOptions<dxPivotGridFieldChooser> {
    /**
     * Specifies whether the field chooser allows search operations in the &apos;All Fields&apos; section.
     */
    allowSearch?: boolean;
    /**
     * Specifies when to apply changes made in the UI component to the PivotGrid.
     */
    applyChangesMode?: DevExpress.common.grids.ApplyChangesMode;
    /**
     * The data source of a PivotGrid UI component.
     */
    dataSource?: DevExpress.data.PivotGridDataSource | null;
    /**
     * Specifies whether HTML tags are displayed as plain text or applied to the values of the header filter.
     */
    encodeHtml?: boolean;
    /**
     * Configures the header filter feature.
     */
    headerFilter?: {
      /**
       * Specifies whether searching is enabled in the header filter.
       * @deprecated Use search.enabled instead.
       */
      allowSearch?: boolean;
      /**
       * Specifies whether a &apos;Select All&apos; option is available to users.
       */
      allowSelectAll?: boolean;
      /**
       * Specifies the height of the popup menu containing filtering values.
       */
      height?: number;
      /**
       * Configures the header filter&apos;s search functionality.
       */
      search?: DevExpress.common.grids.HeaderFilterSearchConfig;
      /**
       * Specifies a delay in milliseconds between when a user finishes typing in the header filter&apos;s search panel, and when the search is executed.
       * @deprecated Use search.timeout instead.
       */
      searchTimeout?: number;
      /**
       * Specifies whether to show all field values or only those that satisfy the other applied filters.
       */
      showRelevantValues?: boolean;
      /**
       * Configures the texts of the popup menu&apos;s elements.
       */
      texts?: {
        /**
         * Specifies the text of the button that closes the popup menu without applying a filter.
         */
        cancel?: string;
        /**
         * Specifies the name of the item that represents empty values in the popup menu.
         */
        emptyValue?: string;
        /**
         * Specifies the text of the button that applies a filter.
         */
        ok?: string;
      };
      /**
       * Specifies the width of the popup menu containing filtering values.
       */
      width?: number;
    };
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies the field chooser layout.
     */
    layout?: DevExpress.common.FieldChooserLayout;
    /**
     * A function that is executed before the context menu is rendered.
     */
    onContextMenuPreparing?: (
      e: DevExpress.ui.dxPivotGridFieldChooser.ContextMenuPreparingEvent
    ) => void;
    /**
     * Specifies a delay in milliseconds between when a user finishes typing in the field chooser&apos;s search panel, and when the search is executed.
     */
    searchTimeout?: number;
    /**
     * The UI component&apos;s state.
     */
    state?: any;
    /**
     * Strings that can be changed or localized in the PivotGridFieldChooser UI component.
     */
    texts?: {
      /**
       * The string to display instead of All Fields.
       */
      allFields?: string;
      /**
       * The string to display instead of Column Fields.
       */
      columnFields?: string;
      /**
       * The string to display instead of Data Fields.
       */
      dataFields?: string;
      /**
       * The string to display instead of Filter Fields.
       */
      filterFields?: string;
      /**
       * The string to display instead of Row Fields.
       */
      rowFields?: string;
    };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPivotGridOptions extends WidgetOptions<dxPivotGrid> {
    /**
     * Allows users to expand/collapse all header items within the same header level. Ignored if the PivotGridDataSource&apos;s paginate property is true.
     */
    allowExpandAll?: boolean;
    /**
     * Allows a user to filter fields by selecting or deselecting values in the popup menu.
     */
    allowFiltering?: boolean;
    /**
     * Allows an end user to change sorting properties.
     */
    allowSorting?: boolean;
    /**
     * Allows users to sort the pivot grid by summary values instead of field values. Ignored if the PivotGridDataSource&apos;s paginate property is true.
     */
    allowSortingBySummary?: boolean;
    /**
     * Specifies the area to which data field headers must belong.
     */
    dataFieldArea?: DevExpress.ui.dxPivotGrid.PivotGridDataFieldArea;
    /**
     * Binds the UI component to data.
     */
    dataSource?:
      | Array<any>
      | DevExpress.data.PivotGridDataSource
      | DevExpress.data.PivotGridDataSource.Options
      | null;
    /**
     * Specifies whether HTML tags are displayed as plain text or applied to cell values.
     */
    encodeHtml?: boolean;
    /**
     * Configures client-side exporting.
     */
    export?: {
      /**
       * Enables client-side exporting.
       */
      enabled?: boolean;
    };
    /**
     * The Field Chooser configuration properties.
     */
    fieldChooser?: {
      /**
       * Specifies whether the field chooser allows search operations in the &apos;All Fields&apos; section.
       */
      allowSearch?: boolean;
      /**
       * Specifies when to apply changes made in the field chooser to the PivotGrid.
       */
      applyChangesMode?: DevExpress.common.grids.ApplyChangesMode;
      /**
       * Enables or disables the field chooser.
       */
      enabled?: boolean;
      /**
       * Specifies the field chooser height.
       */
      height?: number;
      /**
       * Specifies the field chooser layout.
       */
      layout?: DevExpress.common.FieldChooserLayout;
      /**
       * Specifies a delay in milliseconds between when a user finishes typing in the field chooser&apos;s search panel, and when the search is executed.
       */
      searchTimeout?: number;
      /**
       * Strings that can be changed or localized in the pivot grid&apos;s integrated Field Chooser.
       */
      texts?: {
        /**
         * The string to display instead of All Fields.
         */
        allFields?: string;
        /**
         * The string to display instead of Column Fields.
         */
        columnFields?: string;
        /**
         * The string to display instead of Data Fields.
         */
        dataFields?: string;
        /**
         * The string to display instead of Filter Fields.
         */
        filterFields?: string;
        /**
         * The string to display instead of Row Fields.
         */
        rowFields?: string;
      };
      /**
       * Specifies the text to display as a title of the field chooser popup window.
       */
      title?: string;
      /**
       * Specifies the field chooser width.
       */
      width?: number;
    };
    /**
     * Configures the field panel.
     */
    fieldPanel?: {
      /**
       * Makes fields on the field panel draggable.
       */
      allowFieldDragging?: boolean;
      /**
       * Shows/hides column fields on the field panel.
       */
      showColumnFields?: boolean;
      /**
       * Shows/hides data fields on the field panel.
       */
      showDataFields?: boolean;
      /**
       * Shows/hides filter fields on the field panel.
       */
      showFilterFields?: boolean;
      /**
       * Shows/hides row fields on the field panel.
       */
      showRowFields?: boolean;
      /**
       * Specifies the placeholders of the field areas.
       */
      texts?: {
        /**
         * Specifies the placeholder of the column field area.
         */
        columnFieldArea?: string;
        /**
         * Specifies the placeholder of the data field area.
         */
        dataFieldArea?: string;
        /**
         * Specifies the placeholder of the filter field area.
         */
        filterFieldArea?: string;
        /**
         * Specifies the placeholder of the row field area.
         */
        rowFieldArea?: string;
      };
      /**
       * Shows/hides the field panel.
       */
      visible?: boolean;
    };
    /**
     * Configures the header filter feature.
     */
    headerFilter?: {
      /**
       * Specifies whether searching is enabled in the header filter.
       * @deprecated Use search.enabled instead.
       */
      allowSearch?: boolean;
      /**
       * Specifies whether a &apos;Select All&apos; option is available to users.
       */
      allowSelectAll?: boolean;
      /**
       * Specifies the height of the popup menu containing filtering values.
       */
      height?: number;
      /**
       * Configures the header filter&apos;s search functionality.
       */
      search?: DevExpress.common.grids.HeaderFilterSearchConfig;
      /**
       * Specifies a delay in milliseconds between when a user finishes typing in the header filter&apos;s search panel, and when the search is executed.
       * @deprecated Use search.timeout instead.
       */
      searchTimeout?: number;
      /**
       * Specifies whether to show all field values or only those that satisfy the other applied filters.
       */
      showRelevantValues?: boolean;
      /**
       * Configures the texts of the popup menu&apos;s elements.
       */
      texts?: {
        /**
         * Specifies the text of the button that closes the popup menu without applying a filter.
         */
        cancel?: string;
        /**
         * Specifies the name of the item that represents empty values in the popup menu.
         */
        emptyValue?: string;
        /**
         * Specifies the text of the button that applies a filter.
         */
        ok?: string;
      };
      /**
       * Specifies the width of the popup menu containing filtering values.
       */
      width?: number;
    };
    /**
     * Specifies whether or not to hide rows and columns with no data.
     */
    hideEmptySummaryCells?: boolean;
    /**
     * Specifies properties configuring the load panel.
     */
    loadPanel?: {
      /**
       * Enables or disables the load panel.
       */
      enabled?: boolean;
      /**
       * Specifies the height of the load panel.
       */
      height?: number;
      /**
       * Specifies the path to a custom load indicator image.
       */
      indicatorSrc?: string;
      /**
       * Specifies whether to shade the UI component when the load panel appears.
       */
      shading?: boolean;
      /**
       * Specifies the shading color. Applies only if shading is true.
       */
      shadingColor?: string;
      /**
       * Specifies whether or not to show a load indicator.
       */
      showIndicator?: boolean;
      /**
       * Specifies whether or not to show load panel background.
       */
      showPane?: boolean;
      /**
       * Specifies the text to display inside a load panel.
       */
      text?: string;
      /**
       * Specifies the width of the load panel.
       */
      width?: number;
    };
    /**
     * A function that is executed when a pivot grid cell is clicked or tapped.
     */
    onCellClick?: (e: DevExpress.ui.dxPivotGrid.CellClickEvent) => void;
    /**
     * A function that is executed after a pivot grid cell is created.
     */
    onCellPrepared?: (e: DevExpress.ui.dxPivotGrid.CellPreparedEvent) => void;
    /**
     * A function that is executed before the context menu is rendered.
     */
    onContextMenuPreparing?: (
      e: DevExpress.ui.dxPivotGrid.ContextMenuPreparingEvent
    ) => void;
    /**
     * A function that is executed before data is exported.
     */
    onExporting?: (e: DevExpress.ui.dxPivotGrid.ExportingEvent) => void;
    /**
     * Specifies the layout of items in the row header.
     */
    rowHeaderLayout?: DevExpress.ui.dxPivotGrid.PivotGridRowHeaderLayout;
    /**
     * A configuration object specifying scrolling properties.
     */
    scrolling?: {
      /**
       * Specifies the scrolling mode.
       */
      mode?: DevExpress.common.ScrollMode;
      /**
       * Specifies whether or not the UI component uses native scrolling.
       */
      useNative?: boolean | DevExpress.common.Mode;
    };
    /**
     * Specifies whether the outer borders of the grid are visible or not.
     */
    showBorders?: boolean;
    /**
     * Specifies whether to display the Grand Total column.
     */
    showColumnGrandTotals?: boolean;
    /**
     * Specifies whether to display the Total columns.
     */
    showColumnTotals?: boolean;
    /**
     * Specifies whether to display the Grand Total row.
     */
    showRowGrandTotals?: boolean;
    /**
     * Specifies whether to display the Total rows. Applies only if rowHeaderLayout is &apos;standard&apos;.
     */
    showRowTotals?: boolean;
    /**
     * Specifies where to show the total rows or columns.
     */
    showTotalsPrior?: DevExpress.ui.dxPivotGrid.PivotGridTotalDisplayMode;
    /**
     * A configuration object specifying properties related to state storing.
     */
    stateStoring?: {
      /**
       * Specifies a function that is executed on state loading. Applies only if the type is &apos;custom&apos;.
       */
      customLoad?: () => PromiseLike<any>;
      /**
       * Specifies a function that is executed on state change. Applies only if the type is &apos;custom&apos;.
       */
      customSave?: (state: any) => any;
      /**
       * Specifies whether or not a grid saves its state.
       */
      enabled?: boolean;
      /**
       * Specifies the delay between the last change of a grid state and the operation of saving this state in milliseconds.
       */
      savingTimeout?: number;
      /**
       * Specifies a unique key to be used for storing the grid state.
       */
      storageKey?: string;
      /**
       * Specifies the type of storage to be used for state storing.
       */
      type?: DevExpress.common.grids.StateStoreType;
    };
    /**
     * Strings that can be changed or localized in the PivotGrid UI component.
     */
    texts?: {
      /**
       * The string to display as a Collapse All context menu item.
       */
      collapseAll?: string;
      /**
       * Specifies text displayed in a cell when its data is unavailable for some reason.
       */
      dataNotAvailable?: string;
      /**
       * The string to display as an Expand All context menu item.
       */
      expandAll?: string;
      /**
       * The string to display as an Export to Excel file context menu item.
       */
      exportToExcel?: string;
      /**
       * The string to display as a header of the Grand Total row and column.
       */
      grandTotal?: string;
      /**
       * Specifies the text displayed when a pivot grid does not contain any fields.
       */
      noData?: string;
      /**
       * The string to display as a Remove All Sorting context menu item.
       */
      removeAllSorting?: string;
      /**
       * The string to display as a Show Field Chooser context menu item.
       */
      showFieldChooser?: string;
      /**
       * The string to display as a Sort Column by Summary Value context menu item.
       */
      sortColumnBySummary?: string;
      /**
       * The string to display as a Sort Row by Summary Value context menu item.
       */
      sortRowBySummary?: string;
      /**
       * The string to display as a header of the Total row and column.
       */
      total?: string;
    };
    /**
     * Specifies whether long text in header items should be wrapped.
     */
    wordWrapEnabled?: boolean;
  }
  /**
   * @deprecated Use Cell instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPivotGridPivotGridCell {
    /**
     * The cell&apos;s column path. Available for data area cells only.
     */
    columnPath?: Array<string | number | Date>;
    /**
     * The type of the column to which the cell belongs. Available for data area cells only.
     */
    columnType?: 'D' | 'T' | 'GT';
    /**
     * The data field&apos;s index. Available for data area cells only.
     */
    dataIndex?: number;
    /**
     * Indicates whether the cell is expanded. Available for row or column area cells only.
     */
    expanded?: boolean;
    /**
     * The path to the row/column cell. Available for row or column area cells only.
     */
    path?: Array<string | number | Date>;
    /**
     * The cell&apos;s row path. Available for data area cells only.
     */
    rowPath?: Array<string | number | Date>;
    /**
     * The type of the row to which the cell belongs. Available for data area cells only.
     */
    rowType?: 'D' | 'T' | 'GT';
    /**
     * The text displayed in the cell.
     */
    text?: string;
    /**
     * The cell&apos;s type. Available for row or column area cells only.
     */
    type?: 'D' | 'T' | 'GT';
    /**
     * The cell&apos;s value.
     */
    value?: any;
  }
  /**
   * An object exposing methods that manipulate a summary cell and provide access to its neighboring cells.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPivotGridSummaryCell {
    /**
     * Gets the child cell in a specified direction.
     */
    child(
      direction: string,
      fieldValue: number | string
    ): dxPivotGridSummaryCell;
    /**
     * Gets all child cells in a specified direction.
     */
    children(direction: string): Array<dxPivotGridSummaryCell>;
    /**
     * Gets a pivot grid field that corresponds to the summary cell.
     */
    field(area: string): DevExpress.data.PivotGridDataSource.Field;
    /**
     * Gets the Grand Total of the entire pivot grid.
     */
    grandTotal(): dxPivotGridSummaryCell;
    /**
     * Gets a partial Grand Total cell of a row or column.
     */
    grandTotal(direction: string): dxPivotGridSummaryCell;
    /**
     * Indicates whether the summaryDisplayMode or calculateSummaryValue post-processed the summary value.
     */
    isPostProcessed(
      field: DevExpress.data.PivotGridDataSource.Field | string
    ): boolean;
    /**
     * Gets the cell next to the current one in a specified direction.
     */
    next(direction: string): dxPivotGridSummaryCell;
    /**
     * Gets the cell next to current in a specified direction.
     */
    next(direction: string, allowCrossGroup: boolean): dxPivotGridSummaryCell;
    /**
     * Gets the parent cell in a specified direction.
     */
    parent(direction: string): dxPivotGridSummaryCell;
    /**
     * Gets the cell prior to the current one in a specified direction.
     */
    prev(direction: string): dxPivotGridSummaryCell;
    /**
     * Gets the cell previous to current in a specified direction.
     */
    prev(direction: string, allowCrossGroup: boolean): dxPivotGridSummaryCell;
    /**
     * Gets the cell located by the path of the source cell with one field value changed.
     */
    slice(
      field: DevExpress.data.PivotGridDataSource.Field,
      value: number | string
    ): dxPivotGridSummaryCell;
    /**
     * Gets the summary cell value.
     */
    value(): any;
    /**
     * Gets the value of any field associated with the summary cell.
     */
    value(field: DevExpress.data.PivotGridDataSource.Field | string): any;
    /**
     * Gets the value of any field associated with the summary cell.
     */
    value(
      field: DevExpress.data.PivotGridDataSource.Field | string,
      postProcessed: boolean
    ): any;
    /**
     * Gets the summary cell value.
     */
    value(postProcessed: boolean): any;
  }
  /**
   * The Popover is a UI component that shows notifications within a box with an arrow pointing to a specified UI element.
   */
  export class dxPopover<
    TProperties = DevExpress.ui.dxPopover.Properties
  > extends dxPopup<TProperties> {
    show(): DevExpress.core.utils.DxPromise<boolean>;
    /**
     * Shows the UI component for a target element.
     */
    show(
      target: string | DevExpress.core.UserDefinedElement
    ): DevExpress.core.utils.DxPromise<boolean>;
  }
  module dxPopover {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the hidden event handler&apos;s argument.
     */
    export type HiddenEvent =
      DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the hiding event handler&apos;s argument.
     */
    export type HidingEvent = DevExpress.common.core.events.AsyncCancelable &
      DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxPopover>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxPopover> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface PopoverInstance extends dxPopover<Properties> {}
    export type Properties = dxPopoverOptions<PopoverInstance>;
    /**
     * The type of the showing event handler&apos;s argument.
     */
    export type ShowingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the shown event handler&apos;s argument.
     */
    export type ShownEvent = DevExpress.common.core.events.EventInfo<dxPopover>;
    /**
     * The type of the titleRendered event handler&apos;s argument.
     */
    export type TitleRenderedEvent =
      DevExpress.common.core.events.EventInfo<dxPopover> &
        DevExpress.ui.dxPopup.TitleRenderedInfo;
  }
  /**
   * Configures UI component visibility animations. This object contains two fields: show and hide.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPopoverAnimation extends dxPopupAnimation {
    /**
     * An object that defines the animation properties used when the UI component is being hidden.
     */
    hide?: DevExpress.common.core.animation.AnimationConfig;
    /**
     * An object that defines the animation properties used when the UI component is being shown.
     */
    show?: DevExpress.common.core.animation.AnimationConfig;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPopoverOptions<TComponent>
    extends dxPopupOptions<TComponent> {
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: dxPopoverAnimation;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies properties of popover hiding. Ignored if the shading property is set to true.
     */
    hideEvent?:
      | {
          /**
           * The delay in milliseconds after which the UI component is hidden.
           */
          delay?: number | undefined;
          /**
           * Specifies the event names on which the UI component is hidden.
           */
          name?: string | undefined;
        }
      | string
      | undefined;
    /**
     * Specifies whether to hide the UI component if a user clicks outside the popover window or outside the target element.
     */
    hideOnOutsideClick?:
      | boolean
      | ((
          event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>
        ) => boolean);
    /**
     * Specifies whether to hide the widget when users scroll one of its parent elements.
     */
    hideOnParentScroll?: boolean;
    /**
     * An object defining UI component positioning properties.
     */
    position?:
      | DevExpress.common.Position
      | DevExpress.common.core.animation.PositionConfig;
    /**
     * Specifies whether to shade the background when the UI component is active.
     */
    shading?: boolean;
    /**
     * Specifies properties for displaying the UI component.
     */
    showEvent?:
      | {
          /**
           * The delay in milliseconds after which the UI component is displayed.
           */
          delay?: number | undefined;
          /**
           * Specifies the event names on which the UI component is shown.
           */
          name?: string | undefined;
        }
      | string
      | undefined;
    /**
     * A Boolean value specifying whether or not to display the title in the overlay window.
     */
    showTitle?: boolean;
    /**
     * Specifies the element against which to position the widget. If target is `undefined`, the component cannot be displayed.
     */
    target?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The Popup UI component is a pop-up window overlaying the current view.
   */
  export class dxPopup<
    TProperties = DevExpress.ui.dxPopup.Properties
  > extends dxOverlay<TProperties> {}
  module dxPopup {
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxPopup>;
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxPopup>;
    export type HiddenEvent = DevExpress.common.core.events.EventInfo<dxPopup>;
    export type HidingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxPopup>;
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxPopup>;
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxPopup> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface PopupInstance extends dxPopup<Properties> {}
    export type Properties = dxPopupOptions<PopupInstance>;
    export type ResizeEndEvent = DevExpress.common.core.events.NativeEventInfo<
      dxPopup,
      MouseEvent | TouchEvent
    > &
      DevExpress.ui.dxResizable.ResizeInfo;
    export type ResizeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxPopup,
      MouseEvent | TouchEvent
    > &
      DevExpress.ui.dxResizable.ResizeInfo;
    export type ResizeStartEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxPopup,
        MouseEvent | TouchEvent
      > &
        DevExpress.ui.dxResizable.ResizeInfo;
    export type ShowingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxPopup>;
    export type ShownEvent = DevExpress.common.core.events.EventInfo<dxPopup>;
    export type TitleRenderedEvent =
      DevExpress.common.core.events.EventInfo<dxPopup> & TitleRenderedInfo;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface TitleRenderedInfo {
      readonly titleElement: DevExpress.core.DxElement;
    }
    export type ToolbarLocation = 'bottom' | 'top';
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPopupAnimation extends dxOverlayAnimation {
    /**
     * An object that defines the animation properties used when the UI component is being hidden.
     */
    hide?: DevExpress.common.core.animation.AnimationConfig;
    /**
     * An object that defines the animation properties used when the UI component is being shown.
     */
    show?: DevExpress.common.core.animation.AnimationConfig;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxPopupOptions<TComponent>
    extends dxOverlayOptions<TComponent> {
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: dxPopupAnimation;
    /**
     * Specifies the container in which to render the UI component.
     */
    container?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies an element with boundaries within which users can drag and resize the Popup. Ignored if the dragOutsideBoundary property is set to true.
     */
    dragAndResizeArea?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies whether or not to allow a user to drag the popup window.
     */
    dragEnabled?: boolean;
    /**
     * Allows users to drag the Popup within the browser window or beyond the window&apos;s borders.
     */
    dragOutsideBoundary?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether to display the Popup in full-screen mode.
     */
    fullScreen?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * A function that is executed each time the UI component is resized by one pixel.
     */
    onResize?: (e: DevExpress.ui.dxPopup.ResizeEvent) => void;
    /**
     * A function that is executed when resizing ends.
     */
    onResizeEnd?: (e: DevExpress.ui.dxPopup.ResizeEndEvent) => void;
    /**
     * A function that is executed when resizing starts.
     */
    onResizeStart?: (e: DevExpress.ui.dxPopup.ResizeStartEvent) => void;
    /**
     * A function that is executed when the UI component&apos;s title is rendered.
     */
    onTitleRendered?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.ui.dxPopup.TitleRenderedInfo
    ) => void;
    /**
     * Positions the UI component.
     */
    position?:
      | DevExpress.common.PositionAlignment
      | DevExpress.common.core.animation.PositionConfig
      | Function;
    /**
     * Specifies whether to enable page scrolling when the UI component is visible.
     */
    enableBodyScroll?: boolean;
    /**
     * Specifies whether or not an end user can resize the UI component.
     */
    resizeEnabled?: boolean;
    /**
     * Specifies whether to display the widget at the initial position when users reopen it.
     */
    restorePosition?: boolean;
    /**
     * Specifies whether or not the UI component displays the Close button.
     */
    showCloseButton?: boolean;
    /**
     * A Boolean value specifying whether or not to display the title in the popup window.
     */
    showTitle?: boolean;
    /**
     * The title in the overlay window.
     */
    title?: string;
    /**
     * Specifies a custom template for the UI component title. Does not apply if the title is defined.
     */
    titleTemplate?:
      | template
      | ((
          titleElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Configures toolbar items.
     */
    toolbarItems?: Array<DevExpress.ui.dxPopup.ToolbarItem>;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The ProgressBar is a UI component that shows current progress.
   */
  export class dxProgressBar extends dxTrackBar<dxProgressBarOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxProgressBar.Properties['value']): void;
  }
  module dxProgressBar {
    /**
     * The type of the complete event handler&apos;s argument.
     */
    export type CompleteEvent =
      DevExpress.common.core.events.NativeEventInfo<dxProgressBar>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxProgressBar>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxProgressBar>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxProgressBar>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxProgressBar> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxProgressBarOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxProgressBar> &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxProgressBarOptions
    extends dxTrackBarOptions<dxProgressBar> {
    /**
     * A function that is executed when the value reaches the maximum.
     */
    onComplete?: (e: DevExpress.ui.dxProgressBar.CompleteEvent) => void;
    /**
     * Specifies whether or not the UI component displays a progress status.
     */
    showStatus?: boolean;
    /**
     * Specifies a format for the progress status.
     */
    statusFormat?: string | ((ratio: number, value: number) => string);
    /**
     * The current UI component value.
     */
    value?: number | false;
  }
  /**
   * The RadioGroup is a UI component that contains a set of radio buttons and allows an end user to make a single selection from the set.
   */
  export class dxRadioGroup extends Editor<dxRadioGroupOptions> {
    getDataSource(): DevExpress.common.data.DataSource;
  }
  module dxRadioGroup {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxRadioGroup>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxRadioGroup>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxRadioGroup>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxRadioGroup> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxRadioGroupOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxRadioGroup,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxRadioGroupOptions
    extends EditorOptions<dxRadioGroup>,
      DataExpressionMixinOptions<dxRadioGroup> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the radio group layout.
     */
    layout?: DevExpress.common.Orientation;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies the UI component&apos;s value.
     */
    value?: any;
  }
  /**
   * The RangeSlider is a UI component that allows an end user to choose a range of numeric values.
   */
  export class dxRangeSlider extends dxTrackBar<dxRangeSliderOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxRangeSlider.Properties['value']): void;
  }
  module dxRangeSlider {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxRangeSlider>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxRangeSlider>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxRangeSlider>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxRangeSlider> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxRangeSliderOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxRangeSlider,
        DevExpress.events.InteractionEvent | UIEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo & {
          /**
           * 
           */
          readonly start?: number;
          /**
           * 
           */
          readonly end?: number;
          /**
           * 
           */
          readonly value?: Array<number>;
        };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxRangeSliderOptions
    extends dxSliderBaseOptions<dxRangeSlider> {
    /**
     * The right edge of the interval currently selected using the range slider.
     */
    end?: number;
    /**
     * The value to be assigned to the name attribute of the underlying `` element.
     */
    endName?: string;
    /**
     * A function that is executed after the UI component&apos;s value is changed.
     */
    onValueChanged?: (e: DevExpress.ui.dxRangeSlider.ValueChangedEvent) => void;
    /**
     * The left edge of the interval currently selected using the range slider.
     */
    start?: number;
    /**
     * The value to be assigned to the name attribute of the underlying `` element.
     */
    startName?: string;
    /**
     * Specifies the UI component&apos;s value.
     */
    value?: Array<number>;
  }
  /**
   * A base class for editors.
   */
  export class dxRecurrenceEditor extends Editor<dxRecurrenceEditorOptions> {}
  module dxRecurrenceEditor {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxRecurrenceEditor>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxRecurrenceEditor>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxRecurrenceEditor>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxRecurrenceEditor> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type Properties = dxRecurrenceEditorOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<dxRecurrenceEditor, Event> &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxRecurrenceEditorOptions
    extends EditorOptions<dxRecurrenceEditor> {
    /**
     * Specifies the UI component&apos;s value.
     */
    value?: string;
  }
  /**
   * The Resizable UI component enables its content to be resizable in the UI.
   */
  export class dxResizable extends DOMComponent<dxResizableOptions> {}
  module dxResizable {
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxResizable>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxResizable>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxResizable> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxResizableOptions;
    /**
     * The type of the resizeEnd event handler&apos;s argument.
     */
    export type ResizeEndEvent = DevExpress.common.core.events.NativeEventInfo<
      dxResizable,
      MouseEvent | TouchEvent
    > &
      ResizeInfo;
    /**
     * The type of the resize event handler&apos;s argument.
     */
    export type ResizeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxResizable,
      MouseEvent | TouchEvent
    > &
      ResizeInfo;
    export type ResizeHandle = 'bottom' | 'left' | 'right' | 'top' | 'all';
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ResizeInfo {
      /**
       * 
       */
      readonly width: number;
      /**
       * 
       */
      readonly height: number;
    }
    /**
     * The type of the resizeStart event handler&apos;s argument.
     */
    export type ResizeStartEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxResizable,
        MouseEvent | TouchEvent
      > &
        ResizeInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxResizableOptions extends DOMComponentOptions<dxResizable> {
    /**
     * Specifies the area within which users can resize the UI component.
     */
    area?: string | DevExpress.core.UserDefinedElement | undefined;
    /**
     * Specifies which borders of the UI component element are used as a handle.
     */
    handles?: DevExpress.ui.dxResizable.ResizeHandle | string;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies whether to resize the UI component&apos;s content proportionally when you use corner handles.
     */
    keepAspectRatio?: boolean;
    /**
     * Specifies the upper height boundary for resizing.
     */
    maxHeight?: number;
    /**
     * Specifies the upper width boundary for resizing.
     */
    maxWidth?: number;
    /**
     * Specifies the lower height boundary for resizing.
     */
    minHeight?: number;
    /**
     * Specifies the lower width boundary for resizing.
     */
    minWidth?: number;
    /**
     * A function that is executed each time the UI component is resized by one pixel.
     */
    onResize?: (e: DevExpress.ui.dxResizable.ResizeEvent) => void;
    /**
     * A function that is executed when resizing ends.
     */
    onResizeEnd?: (e: DevExpress.ui.dxResizable.ResizeEndEvent) => void;
    /**
     * A function that is executed when resizing starts.
     */
    onResizeStart?: (e: DevExpress.ui.dxResizable.ResizeStartEvent) => void;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The ResponsiveBox UI component allows you to create an application or a website with a layout adapted to different screen sizes.
   */
  export class dxResponsiveBox<
    TItem extends DevExpress.ui.dxResponsiveBox.ItemLike = any,
    TKey = any
  > extends CollectionWidget<
    dxResponsiveBoxOptions<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxResponsiveBox {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxResponsiveBox<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxResponsiveBox<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxResponsiveBox<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxResponsiveBox<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxResponsiveBox<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxResponsiveBox<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxResponsiveBox<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxResponsiveBox<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxResponsiveBoxOptions<TItem, TKey>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxResponsiveBoxItem extends CollectionWidgetItem {
    /**
     * Specifies the item location and size against the UI component grid.
     */
    location?:
      | {
          /**
           * Specifies which column the element should occupy. Accepts an index from the cols array.
           */
          col?: number;
          /**
           * Specifies how many columns the element should span.
           */
          colspan?: number | undefined;
          /**
           * Specifies which row the element should occupy. Accepts an index from the rows array.
           */
          row?: number;
          /**
           * Specifies how many rows the element should span.
           */
          rowspan?: number | undefined;
          /**
           * Decides on which screens the current location settings should be applied to the element.
           */
          screen?: string | undefined;
        }
      | Array<{
          col?: number;
          colspan?: number;
          row?: number;
          rowspan?: number;
          screen?: string;
        }>;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxResponsiveBoxOptions<
    TItem extends DevExpress.ui.dxResponsiveBox.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxResponsiveBox<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies the collection of columns for the grid used to position layout elements.
     */
    cols?: Array<{
      /**
       * The column&apos;s base width. Calculated automatically when the singleColumnScreen property arranges all elements in a single column.
       */
      baseSize?: number | string;
      /**
       * The column width ratio.
       */
      ratio?: number;
      /**
       * Decides on which screens the current column is rendered.
       */
      screen?: string | undefined;
      /**
       * A factor that defines how much a column width shrinks relative to the rest of the columns in the container.
       */
      shrink?: number;
    }>;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies the collection of rows for the grid used to position layout elements.
     */
    rows?: Array<{
      /**
       * The row&apos;s base height. Calculated automatically when the singleColumnScreen property arranges all elements in a single column.
       */
      baseSize?: number | string;
      /**
       * The row height ratio.
       */
      ratio?: number;
      /**
       * Decides on which screens the current row is rendered.
       */
      screen?: string | undefined;
      /**
       * A factor that defines how much a row height shrinks relative to the rest of the rows in the container.
       */
      shrink?: number;
    }>;
    /**
     * Specifies the function returning the size qualifier depending on the screen&apos;s width.
     */
    screenByWidth?: Function;
    /**
     * Specifies on which screens all layout elements should be arranged in a single column. Accepts a single or several size qualifiers separated by a space.
     */
    singleColumnScreen?: string;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The Scheduler is a UI component that represents scheduled data and allows a user to manage and edit it.
   */
  export class dxScheduler extends Widget<dxSchedulerOptions> {
    /**
     * Adds an appointment.
     */
    addAppointment(appointment: Appointment): void;
    /**
     * Deletes an appointment from the timetable and its object from the data source.
     */
    deleteAppointment(appointment: Appointment): void;
    /**
     * Deletes a recurring appointment occurrence.
     */
    deleteRecurrence(
      appointmentData: Appointment,
      date: Date | string,
      recurrenceEditMode: DevExpress.ui.dxScheduler.RecurrenceEditMode
    ): void;
    getDataSource(): DevExpress.common.data.DataSource;
    /**
     * Gets the current view&apos;s end date.
     */
    getEndViewDate(): Date;
    /**
     * Gets the current view&apos;s start date.
     */
    getStartViewDate(): Date;
    /**
     * Hides an appointment edit form.
     */
    hideAppointmentPopup(saveChanges?: boolean): void;
    /**
     * Hides an appointment&apos;s or cell overflow indicator&apos;s tooltip.
     */
    hideAppointmentTooltip(): void;
    /**
     * Scrolls the current view to a specified position. Available for all views except &apos;agenda&apos;. You should specify the height property to use this method.
     */
    scrollTo(date: Date, group?: object, allDay?: boolean): void;
    /**
     * Shows the appointment edit form.
     */
    showAppointmentPopup(
      appointmentData?: Appointment,
      createNewAppointment?: boolean,
      currentAppointmentData?: Appointment
    ): void;
    /**
     * Shows a tooltip for a target element.
     */
    showAppointmentTooltip(
      appointmentData: Appointment,
      target: string | DevExpress.core.UserDefinedElement,
      currentAppointmentData?: Appointment
    ): void;
    /**
     * Updates an appointment.
     */
    updateAppointment(target: Appointment, appointment: Appointment): void;
  }
  module dxScheduler {
    export type AllDayPanelMode = 'all' | 'allDay' | 'hidden';
    /**
     * The type of the appointmentAdded event handler&apos;s argument.
     */
    export type AppointmentAddedEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly appointmentData: Appointment;
        /**
         * 
         */
        readonly error?: Error;
      };
    /**
     * The type of the appointmentAdding event handler&apos;s argument.
     */
    export type AppointmentAddingEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly appointmentData: Appointment;
        /**
         * 
         */
        cancel: boolean | PromiseLike<boolean>;
      };
    /**
     * The type of the appointmentClick event handler&apos;s argument.
     */
    export type AppointmentClickEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.NativeEventInfo<
          dxScheduler,
          KeyboardEvent | MouseEvent | PointerEvent
        > &
        TargetedAppointmentInfo & {
          /**
           * 
           */
          readonly appointmentElement: DevExpress.core.DxElement;
        };
    /**
     * Information about a cell overflow indicator.
     */
    export type AppointmentCollectorTemplateData = {
      /**
       * The count of hidden appointments.
       */
      readonly appointmentCount: number;
      /**
       * Initially hidden appointments that are displayed after a user clicks an overflow indicator.
       */
      readonly items: Appointment[];
      /**
       * Indicates whether the overflow indicator is compact.
       */
      readonly isCompact: boolean;
    };
    /**
     * The type of the appointmentContextMenu event handler&apos;s argument.
     */
    export type AppointmentContextMenuEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxScheduler,
        DevExpress.events.PointerInteractionEvent
      > &
        TargetedAppointmentInfo & {
          /**
           * 
           */
          readonly appointmentElement: DevExpress.core.DxElement;
        };
    /**
     * The type of the appointmentDblClick event handler&apos;s argument.
     */
    export type AppointmentDblClickEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.NativeEventInfo<
          dxScheduler,
          MouseEvent | PointerEvent
        > &
        TargetedAppointmentInfo & {
          /**
           * 
           */
          readonly appointmentElement: DevExpress.core.DxElement;
        };
    /**
     * The type of the appointmentDeleted event handler&apos;s argument.
     */
    export type AppointmentDeletedEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly appointmentData: Appointment;
        /**
         * 
         */
        readonly error?: Error;
      };
    /**
     * The type of the appointmentDeleting event handler&apos;s argument.
     */
    export type AppointmentDeletingEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly appointmentData: Appointment;
        /**
         * 
         */
        cancel: boolean | PromiseLike<boolean>;
      };
    export type AppointmentDraggingAddEvent = AppointmentDraggingEvent & {
      readonly fromComponent?: dxSortable | dxDraggable;
      readonly toComponent?: dxSortable | dxDraggable;
      readonly toData?: any;
    };
    export type AppointmentDraggingEndEvent =
      DevExpress.common.core.events.Cancelable &
        AppointmentDraggingEvent & {
          readonly fromComponent?: dxSortable | dxDraggable;
          readonly toComponent?: dxSortable | dxDraggable;
          readonly toData?: any;
          readonly toItemData?: any;
        };
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface AppointmentDraggingEvent {
      readonly component: dxScheduler;
      readonly event?: DevExpress.events.DxEvent<MouseEvent | TouchEvent>;
      readonly itemData?: any;
      readonly itemElement?: DevExpress.core.DxElement;
      readonly fromData?: any;
    }
    export type AppointmentDraggingMoveEvent =
      DevExpress.common.core.events.Cancelable &
        AppointmentDraggingEvent & {
          readonly fromComponent?: dxSortable | dxDraggable;
          readonly toComponent?: dxSortable | dxDraggable;
          readonly toData?: any;
        };
    export type AppointmentDraggingRemoveEvent = AppointmentDraggingEvent & {
      readonly fromComponent?: dxSortable | dxDraggable;
      readonly toComponent?: dxSortable | dxDraggable;
    };
    export type AppointmentDraggingStartEvent =
      DevExpress.common.core.events.Cancelable &
        Omit<AppointmentDraggingEvent, 'itemData'> & {
          itemData?: any;
        };
    export type AppointmentFormIconsShowMode =
      | 'both'
      | 'main'
      | 'recurrence'
      | 'none';
    /**
     * The type of the appointmentFormOpening event handler&apos;s argument.
     */
    export type AppointmentFormOpeningEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxScheduler> & {
          /**
           * 
           */
          readonly appointmentData?: Appointment;
          /**
           * 
           */
          readonly form: dxForm;
          /**
           * 
           */
          readonly popup: dxPopup;
        };
    /**
     * 
     */
    export type AppointmentFormProperties = DevExpress.ui.dxForm.Properties & {
      /**
       * 
       */
      iconsShowMode?: AppointmentFormIconsShowMode;
    };
    /**
     * The type of the appointmentRendered event handler&apos;s argument.
     */
    export type AppointmentRenderedEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> &
        TargetedAppointmentInfo & {
          /**
           * 
           */
          readonly appointmentElement: DevExpress.core.DxElement;
        };
    /**
     * 
     */
    export type AppointmentTemplateData = TargetedAppointmentInfo;
    /**
     * Specifies appointments information in AppointmentTooltipShowingEvent.
     */
    export type AppointmentTooltipShowingAppointmentInfo = {
      readonly appointmentData: Appointment;
      readonly currentAppointmentData: Appointment;
      readonly color: PromiseLike<string>;
    };
    /**
     * The type of the appointmentTooltipShowing event handler&apos;s argument.
     */
    export type AppointmentTooltipShowingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxScheduler> & {
          /**
           * 
           */
          readonly targetElement: DevExpress.core.DxElement;
          /**
           * 
           */
          readonly appointments: AppointmentTooltipShowingAppointmentInfo[];
        };
    /**
     * 
     */
    export type AppointmentTooltipTemplateData = TargetedAppointmentInfo & {
      /**
       * 
       */
      readonly isButtonClicked: boolean;
    };
    /**
     * The type of the appointmentUpdated event handler&apos;s argument.
     */
    export type AppointmentUpdatedEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly appointmentData: Appointment;
        /**
         * 
         */
        readonly error?: Error;
      };
    /**
     * The type of the appointmentUpdating event handler&apos;s argument.
     */
    export type AppointmentUpdatingEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> & {
        /**
         * 
         */
        readonly oldData: any;
        /**
         * 
         */
        readonly newData: any;
        /**
         * 
         */
        cancel?: boolean | PromiseLike<boolean>;
      };
    export type CellAppointmentsLimit = 'auto' | 'unlimited';
    /**
     * The type of the cellClick event handler&apos;s argument.
     */
    export type CellClickEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxScheduler,
        KeyboardEvent | MouseEvent | PointerEvent
      > & {
        /**
         * 
         */
        readonly cellData: any;
        /**
         * 
         */
        readonly cellElement: DevExpress.core.DxElement;
      };
    /**
     * The type of the cellContextMenu event handler&apos;s argument.
     */
    export type CellContextMenuEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxScheduler,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly cellData: any;
        /**
         * 
         */
        readonly cellElement: DevExpress.core.DxElement;
      };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler>;
    export type DateNavigatorTextInfo = {
      readonly startDate: Date;
      readonly endDate: Date;
      readonly text: string;
    };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxScheduler>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxScheduler> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxSchedulerOptions;
    export type RecurrenceEditMode = 'dialog' | 'occurrence' | 'series';
    export type SchedulerPredefinedDateNavigatorItem =
      | 'prev'
      | 'next'
      | 'dateInterval';
    export type SchedulerPredefinedToolbarItem =
      | 'today'
      | 'dateNavigator'
      | 'viewSwitcher';
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface TargetedAppointmentInfo {
      /**
       * 
       */
      readonly appointmentData: Appointment;
      /**
       * 
       */
      readonly targetedAppointmentData?: Appointment;
    }
    export type ViewType =
      | 'agenda'
      | 'day'
      | 'month'
      | 'timelineDay'
      | 'timelineMonth'
      | 'timelineWeek'
      | 'timelineWorkWeek'
      | 'week'
      | 'workWeek';
  }
  /**
   * @deprecated Use the Scheduler's Appointment type instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxSchedulerAppointment = CollectionWidgetItem & {
    /**
     * Specifies whether the appointment lasts all day.
     */
    allDay?: boolean;
    /**
     * Specifies a detail description of the appointment.
     */
    description?: string;
    /**
     * Specifies whether the appointment responds to user interaction.
     */
    disabled?: boolean;
    /**
     * Specifies the ending of the appointment.
     */
    endDate?: Date | string;
    /**
     * Specifies the time zone for an appointment&apos;s endDate. Accepts values from the IANA time zone database.
     */
    endDateTimeZone?: string;
    /**
     * Specifies the HTML markup to be inserted into the appointment element.
     */
    html?: string;
    /**
     * Specifies the start date and time of one or more appointments to exclude from a series. This property requires that you also set recurrenceRule.
     */
    recurrenceException?: string;
    /**
     * Specifies a recurrence rule based on which the Scheduler generates an appointment series.
     */
    recurrenceRule?: string;
    /**
     * Specifies the start of the appointment.
     */
    startDate?: Date | string;
    /**
     * Specifies the time zone for an appointment&apos;s startDate. Accepts values from the IANA time zone database.
     */
    startDateTimeZone?: string;
    /**
     * Specifies a template that should be used to render this appointment only.
     */
    template?: template;
    /**
     * Specifies the subject of the appointment.
     */
    text?: string;
    /**
     * Specifies whether or not an appointment must be displayed.
     */
    visible?: boolean;
  } & Record<string, any>;
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSchedulerOptions extends WidgetOptions<dxScheduler> {
    /**
     * Specifies whether the UI component adapts to small screens.
     */
    adaptivityEnabled?: boolean;
    /**
     * Specifies the name of the data source item field whose value defines whether or not the corresponding appointment is an all-day appointment.
     */
    allDayExpr?: string;
    /**
     * Specifies a custom template for cell overflow indicators.
     */
    appointmentCollectorTemplate?:
      | template
      | ((
          data: DevExpress.ui.dxScheduler.AppointmentCollectorTemplateData,
          collectorElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Configures appointment reordering using drag and drop gestures.
     */
    appointmentDragging?: {
      /**
       * Enables automatic scrolling while dragging an appointment beyond the viewport.
       */
      autoScroll?: boolean;
      /**
       * A container for custom data.
       */
      data?: any | undefined;
      /**
       * Allows you to group several UI components so that users can drag and drop appointments between them.
       */
      group?: string | undefined;
      /**
       * A function that is called when a new appointment is added.
       */
      onAdd?: (
        e: DevExpress.ui.dxScheduler.AppointmentDraggingAddEvent
      ) => void;
      /**
       * A function that is called when the dragged appointment&apos;s position is changed.
       */
      onDragEnd?: (
        e: DevExpress.ui.dxScheduler.AppointmentDraggingEndEvent
      ) => void;
      /**
       * A function that is called every time a draggable appointment is moved.
       */
      onDragMove?: (
        e: DevExpress.ui.dxScheduler.AppointmentDraggingMoveEvent
      ) => void;
      /**
       * A function that is called when the drag gesture is initialized.
       */
      onDragStart?: (
        e: DevExpress.ui.dxScheduler.AppointmentDraggingStartEvent
      ) => void;
      /**
       * A function that is called when a draggable appointment is removed.
       */
      onRemove?: (
        e: DevExpress.ui.dxScheduler.AppointmentDraggingRemoveEvent
      ) => void;
      /**
       * Specifies the distance in pixels from the edge of viewport at which scrolling should start. Applies only if autoScroll is true.
       */
      scrollSensitivity?: number;
      /**
       * Specifies the scrolling speed when dragging an appointment beyond the viewport. Applies only if autoScroll is true.
       */
      scrollSpeed?: number;
    };
    /**
     * Specifies a custom template for appointments.
     */
    appointmentTemplate?:
      | template
      | ((
          model: DevExpress.ui.dxScheduler.AppointmentTemplateData,
          itemIndex: number,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies a custom template for tooltips displayed when users click an appointment or cell overflow indicator.
     */
    appointmentTooltipTemplate?:
      | template
      | ((
          model: DevExpress.ui.dxScheduler.AppointmentTooltipTemplateData,
          itemIndex: number,
          contentElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies cell duration in minutes. This property&apos;s value should divide the interval between startDayHour and endDayHour into even parts.
     */
    cellDuration?: number;
    /**
     * Specifies whether or not an end user can scroll the view in both directions at the same time.
     */
    crossScrollingEnabled?: boolean;
    /**
     * Specifies the current date.
     */
    currentDate?: Date | number | string;
    /**
     * Specifies the displayed view. Accepts name or type of a view available in the views array.
     */
    currentView?: DevExpress.ui.dxScheduler.ViewType | string;
    /**
     * Customizes the date navigator&apos;s text.
     */
    customizeDateNavigatorText?:
      | ((info: DevExpress.ui.dxScheduler.DateNavigatorTextInfo) => string)
      | undefined;
    /**
     * Specifies a custom template for table cells.
     */
    dataCellTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<Appointment> | null;
    /**
     * Specifies a custom template for day scale items.
     */
    dateCellTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the format in which date-time values should be sent to the server.
     */
    dateSerializationFormat?: string | undefined;
    /**
     * Specifies the name of the data source item field whose value holds the description of the corresponding appointment.
     */
    descriptionExpr?: string;
    /**
     * Configures appointment editing options, such as available operations.
     */
    editing?:
      | boolean
      | {
          /**
           * Specifies whether or not an end user can add appointments.
           */
          allowAdding?: boolean;
          /**
           * Specifies whether or not an end user can delete appointments.
           */
          allowDeleting?: boolean;
          /**
           * Specifies whether users can drag and drop appointments.
           */
          allowDragging?: boolean;
          /**
           * Specifies whether or not an end user can change an appointment duration. note] Resizing a [recurring appointment and choosing &apos;Edit Series&apos; in the &apos;Edit Recurring Appointment&apos; popup changes the start date of the recurring appointment series. The component removes all appointments before the modified appointment.
           */
          allowResizing?: boolean;
          /**
           * Specifies whether users can edit appointment time zones.
           */
          allowTimeZoneEditing?: boolean;
          /**
           * Specifies whether or not an end user can change appointment properties.
           */
          allowUpdating?: boolean;
          /**
           * Configures the Form component within the Scheduler&apos;s appointment edit form.
           */
          form?: DevExpress.ui.dxScheduler.AppointmentFormProperties;
          /**
           * Configures the Popup component that contains the Scheduler appointment edit form.
           */
          popup?: DevExpress.ui.dxPopup.Properties;
        };
    /**
     * Specifies the name of the data source item field that defines the ending of an appointment.
     */
    endDateExpr?: string;
    /**
     * Specifies the name of the data source item field that defines the timezone of the appointment end date.
     */
    endDateTimeZoneExpr?: string;
    /**
     * Specifies the last hour on the time scale. Accepts integer values from 0 to 24.
     */
    endDayHour?: number;
    /**
     * Specifies the first day of a week. Does not apply to the agenda view.
     */
    firstDayOfWeek?: DevExpress.common.FirstDayOfWeek | undefined;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * If true, appointments are grouped by date first and then by resource; opposite if false. Applies only if appointments are grouped and groupOrientation is &apos;horizontal&apos;.
     */
    groupByDate?: boolean;
    /**
     * Specifies the resource kinds by which the scheduler&apos;s appointments are grouped in a timetable.
     */
    groups?: Array<string>;
    /**
     * Specifies the time interval between when the date-time indicator changes its position, in milliseconds.
     */
    indicatorUpdateInterval?: number;
    /**
     * The latest date the UI component allows you to select.
     */
    max?: Date | number | string | undefined;
    /**
     * Specifies the limit of full-sized appointments displayed per cell. Applies to all views except &apos;agenda&apos;.
     */
    maxAppointmentsPerCell?:
      | number
      | DevExpress.ui.dxScheduler.CellAppointmentsLimit;
    /**
     * The earliest date the UI component allows you to select.
     */
    min?: Date | number | string | undefined;
    /**
     * Specifies the text or HTML markup displayed by the UI component if the item collection is empty. Available for the Agenda view only.
     */
    noDataText?: string;
    /**
     * A function that is executed after an appointment is added to the data source.
     */
    onAppointmentAdded?: (
      e: DevExpress.ui.dxScheduler.AppointmentAddedEvent
    ) => void;
    /**
     * A function that is executed before an appointment is added to the data source.
     */
    onAppointmentAdding?: (
      e: DevExpress.ui.dxScheduler.AppointmentAddingEvent
    ) => void;
    /**
     * A function that is executed when an appointment is clicked or tapped.
     */
    onAppointmentClick?:
      | ((e: DevExpress.ui.dxScheduler.AppointmentClickEvent) => void)
      | string;
    /**
     * A function that is executed when a user attempts to open the browser&apos;s context menu for an appointment. Allows you to replace this context menu with a custom context menu.
     */
    onAppointmentContextMenu?:
      | ((e: DevExpress.ui.dxScheduler.AppointmentContextMenuEvent) => void)
      | string;
    /**
     * A function that is executed when an appointment is double-clicked or double-tapped.
     */
    onAppointmentDblClick?:
      | ((e: DevExpress.ui.dxScheduler.AppointmentDblClickEvent) => void)
      | string;
    /**
     * A function that is executed after an appointment is deleted from the data source.
     */
    onAppointmentDeleted?: (
      e: DevExpress.ui.dxScheduler.AppointmentDeletedEvent
    ) => void;

    /**
     * A function that is executed before an appointment is deleted from the data source.
     */
    onAppointmentDeleting?: (
      e: DevExpress.ui.dxScheduler.AppointmentDeletingEvent
    ) => void;
    /**
     * Occurs before showing an appointment&apos;s tooltip.
     */
    onAppointmentTooltipShowing?: (
      e: DevExpress.ui.dxScheduler.AppointmentTooltipShowingEvent
    ) => void;
    /**
     * A function that is executed before Scheduler displays the appointment edit form.
     */
    onAppointmentFormOpening?: (
      e: DevExpress.ui.dxScheduler.AppointmentFormOpeningEvent
    ) => void;
    /**
     * A function that is executed when an appointment is rendered.
     */
    onAppointmentRendered?: (
      e: DevExpress.ui.dxScheduler.AppointmentRenderedEvent
    ) => void;
    /**
     * A function that is executed after an appointment is updated in the data source.
     */
    onAppointmentUpdated?: (
      e: DevExpress.ui.dxScheduler.AppointmentUpdatedEvent
    ) => void;
    /**
     * A function that is executed before an appointment is updated in the data source.
     */
    onAppointmentUpdating?: (
      e: DevExpress.ui.dxScheduler.AppointmentUpdatingEvent
    ) => void;
    /**
     * A function that is executed when a view cell is clicked.
     */
    onCellClick?:
      | ((e: DevExpress.ui.dxScheduler.CellClickEvent) => void)
      | string;
    /**
     * A function that is executed when a user attempts to open the browser&apos;s context menu for a cell. Allows you to replace this context menu with a custom context menu.
     */
    onCellContextMenu?:
      | ((e: DevExpress.ui.dxScheduler.CellContextMenuEvent) => void)
      | string;
    /**
     * Specifies the edit mode for recurring appointments.
     */
    recurrenceEditMode?: DevExpress.ui.dxScheduler.RecurrenceEditMode;
    /**
     * Specifies the name of the data source item field that defines exceptions for the current recurring appointment.
     */
    recurrenceExceptionExpr?: string;
    /**
     * Specifies the name of the data source item field that defines a recurrence rule for generating recurring appointments.
     */
    recurrenceRuleExpr?: string;
    /**
     * Specifies whether filtering is performed on the server or client side.
     */
    remoteFiltering?: boolean;
    /**
     * Specifies a custom template for resource headers.
     */
    resourceCellTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies an array of resources available in the scheduler.
     */
    resources?: Array<{
      /**
       * Specifies whether you can assign several resources of this kind to an appointment.
       */
      allowMultiple?: boolean;
      /**
       * Specifies the resource object field that is used as a resource color.
       */
      colorExpr?: string;
      /**
       * Specifies available resource instances.
       */
      dataSource?: DevExpress.data.DataSourceLike<any> | null;
      /**
       * Specifies which field from the resource data objects provides values to be displayed in the resource editor.
       */
      displayExpr?: string | ((resource: any) => string);
      /**
       * The name of the appointment object field that specifies a resource of this kind.
       */
      fieldExpr?: string;
      /**
       * Specifies a resource icon.
       */
      icon?: string;
      /**
       * Specifies a resource label.
       */
      label?: string;
      /**
       * Specifies whether appointments are colored like this resource kind.
       */
      useColorAsDefault?: boolean;
      /**
       * Specifies the resource object field that is used as a value of the Resource editor in the Appointment popup window.
       */
      valueExpr?: string | Function;
    }>;
    /**
     * Configures scrolling.
     */
    scrolling?: dxSchedulerScrolling;
    /**
     * The data of the currently selected cells.
     */
    selectedCellData?: Array<any>;
    /**
     * Specifies whether to apply shading to cover the timetable up to the current time.
     */
    shadeUntilCurrentTime?: boolean;
    /**
     * Specifies the &apos;All-day&apos; panel&apos;s visibility. Setting this property to false hides the panel along with the all-day appointments.
     */
    showAllDayPanel?: boolean;
    /**
     * Specifies the current date-time indicator&apos;s visibility.
     */
    showCurrentTimeIndicator?: boolean;
    /**
     * Specifies the name of the data source item field that defines the start of an appointment.
     */
    startDateExpr?: string;
    /**
     * Specifies the name of the data source item field that defines the timezone of the appointment start date.
     */
    startDateTimeZoneExpr?: string;
    /**
     * Specifies the first hour on the time scale. Accepts integer values from 0 to 24.
     */
    startDayHour?: number;
    /**
     * Specifies the name of the data source item field that holds the subject of an appointment.
     */
    textExpr?: string;
    /**
     * Specifies a custom template for time scale items.
     */
    timeCellTemplate?:
      | template
      | ((
          itemData: any,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the time zone for the Scheduler&apos;s grid. Accepts values from the IANA time zone database.
     */
    timeZone?: string;
    /**
     * Specifies whether a user can switch views using tabs or a drop-down menu.
     */
    useDropDownViewSwitcher?: boolean;
    /**
     * Specifies the display mode for the All day panel.
     */
    allDayPanelMode?: DevExpress.ui.dxScheduler.AllDayPanelMode;
    /**
     * Specifies the minute offset applied to configured day durations in all views.
     */
    offset?: number;
    /**
     * Specifies and configures the views to be available in the view switcher.
     */
    views?: Array<
      | 'day'
      | 'week'
      | 'workWeek'
      | 'month'
      | 'timelineDay'
      | 'timelineWeek'
      | 'timelineWorkWeek'
      | 'timelineMonth'
      | 'agenda'
      | {
          /**
           * Specifies the number of dates that can be shown at a time in the agenda view.
           */
          agendaDuration?: number;
          /**
           * Specifies a custom template for cell overflow indicators in this view.
           */
          appointmentCollectorTemplate?:
            | template
            | ((
                data: DevExpress.ui.dxScheduler.AppointmentCollectorTemplateData,
                collectorElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * Specifies a custom template for appointments.
           */
          appointmentTemplate?:
            | template
            | ((
                model: DevExpress.ui.dxScheduler.AppointmentTemplateData,
                itemIndex: number,
                contentElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * Specifies a custom template for tooltips displayed when users click an appointment or cell overflow indicator in this view.
           */
          appointmentTooltipTemplate?:
            | template
            | ((
                model: DevExpress.ui.dxScheduler.AppointmentTooltipTemplateData,
                itemIndex: number,
                contentElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * The cell duration in minutes.
           */
          cellDuration?: number;
          /**
           * Specifies a custom template for table cells.
           */
          dataCellTemplate?:
            | template
            | ((
                itemData: any,
                itemIndex: number,
                itemElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * Specifies a custom template for date scale items.
           */
          dateCellTemplate?:
            | template
            | ((
                itemData: any,
                itemIndex: number,
                itemElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * Specifies the last hour on the view&apos;s time scale. Accepts integer values from 0 to 24.
           */
          endDayHour?: number;
          /**
           * The first day of a week. Does not apply to the agenda view.
           */
          firstDayOfWeek?: DevExpress.common.FirstDayOfWeek | undefined;
          /**
           * If true, appointments are grouped by date first and then by resource; opposite if false. Applies only if appointments are grouped and groupOrientation is &apos;horizontal&apos;.
           */
          groupByDate?: boolean;
          /**
           * Arranges resource headers vertically (in a column) or horizontally (in a row).
           */
          groupOrientation?: DevExpress.common.Orientation;
          /**
           * The resource kinds by which appointments are grouped.
           */
          groups?: Array<string>;
          /**
           * Multiplies the default view interval. Applies to all view types except &apos;agenda&apos;.
           */
          intervalCount?: number;
          /**
           * Specifies the limit of full-sized appointments displayed per cell. Applies to all views except &apos;agenda&apos;.
           */
          maxAppointmentsPerCell?:
            | number
            | DevExpress.ui.dxScheduler.CellAppointmentsLimit;
          /**
           * A custom view name displayed in the view switcher.
           */
          name?: string | undefined;
          /**
           * Specifies a custom template for resource headers.
           */
          resourceCellTemplate?:
            | template
            | ((
                itemData: any,
                itemIndex: number,
                itemElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * Specifies the date from which to start counting the view interval. Applies to all view types except &apos;agenda&apos;.
           */
          startDate?: Date | number | string | undefined;
          /**
           * Specifies the first hour on the view&apos;s time scale. Accepts integer values from 0 to 24.
           */
          startDayHour?: number;
          /**
           * Specifies a custom template for time scale items.
           */
          timeCellTemplate?:
            | template
            | ((
                itemData: any,
                itemIndex: number,
                itemElement: DevExpress.core.DxElement
              ) => string | DevExpress.core.UserDefinedElement);
          /**
           * The type of the view.
           */
          type?: DevExpress.ui.dxScheduler.ViewType | undefined;
          /**
           * Configures scrolling for a view.
           */
          scrolling?: dxSchedulerScrolling;
          /**
           * Specifies the display mode for the All day panel.
           */
          allDayPanelMode?: DevExpress.ui.dxScheduler.AllDayPanelMode;
          /**
           * Specifies the minute offset applied to configured day durations in the view.
           */
          offset?: number;
        }
    >;
    /**
     * Configures the toolbar.
     */
    toolbar?: DevExpress.ui.dxScheduler.Toolbar | undefined;
  }
  /**
   * 
   */
  export interface dxSchedulerScrolling {
    /**
     * Specifies the scrolling mode.
     */
    mode?: DevExpress.common.ScrollMode;
  }
  /**
   * @deprecated Use DevExpress.ui.dxScheduler.Toolbar instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxSchedulerToolbar = DevExpress.ui.dxScheduler.Toolbar;
  /**
   * @deprecated Use DevExpress.ui.dxScheduler.ToolbarItem instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export type dxSchedulerToolbarItem = DevExpress.ui.dxScheduler.ToolbarItem;
  /**
   * A UI component used to display scrollable content.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxScrollable<
    TProperties = DevExpress.ui.dxScrollable.Properties
  > extends DOMComponent<TProperties> {
    /**
     * Gets the UI component&apos;s height.
     */
    clientHeight(): number;
    /**
     * Gets the UI component&apos;s width.
     */
    clientWidth(): number;
    /**
     * Gets the UI component&apos;s content.
     */
    content(): DevExpress.core.DxElement;
    /**
     * Scrolls the content by a specific distance.
     */
    scrollBy(distance: number | any): void;
    /**
     * Gets the scrollable content&apos;s height in pixels.
     */
    scrollHeight(): number;
    /**
     * Gets the left scroll offset.
     */
    scrollLeft(): number;
    /**
     * Gets the scroll offset.
     */
    scrollOffset(): any;
    /**
     * Scrolls the content to a specific position.
     */
    scrollTo(targetLocation: number | any): void;
    /**
     * Scrolls content to an element.
     */
    scrollToElement(element: DevExpress.core.UserDefinedElement): void;
    /**
     * Gets the top scroll offset.
     */
    scrollTop(): number;
    /**
     * Gets the scrollable content&apos;s width in pixels.
     */
    scrollWidth(): number;
    /**
     * Updates the scrollable contents&apos; dimensions.
     */
    update(): DevExpress.core.utils.DxPromise<void>;
  }
  module dxScrollable {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type Properties = dxScrollableOptions<ScrollableInstance>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface ScrollableInstance extends dxScrollable<Properties> {}
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ScrollEventInfo<T>
      extends DevExpress.common.core.events.NativeEventInfo<
        T,
        WheelEvent | MouseEvent | Event
      > {
      /**
       * 
       */
      readonly scrollOffset?: any;
      /**
       * 
       */
      readonly reachedLeft?: boolean;
      /**
       * 
       */
      readonly reachedRight?: boolean;
      /**
       * 
       */
      readonly reachedTop?: boolean;
      /**
       * 
       */
      readonly reachedBottom?: boolean;
    }
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxScrollableOptions<TComponent>
    extends DOMComponentOptions<TComponent> {
    /**
     * A Boolean value specifying whether to enable or disable the bounce-back effect.
     */
    bounceEnabled?: boolean;
    /**
     * A string value specifying the available scrolling directions.
     */
    direction?: DevExpress.common.ScrollDirection;
    /**
     * Specifies whether the UI component responds to user interaction.
     */
    disabled?: boolean;
    /**
     * A function that is executed on each scroll gesture.
     */
    onScroll?: (
      e: DevExpress.ui.dxScrollable.ScrollEventInfo<TComponent>
    ) => void;
    /**
     * A function that is executed each time the UI component is updated.
     */
    onUpdated?: (
      e: DevExpress.ui.dxScrollable.ScrollEventInfo<TComponent>
    ) => void;
    /**
     * A Boolean value specifying whether or not an end user can scroll the UI component content swiping it up or down. Applies only if useNative is false
     */
    scrollByContent?: boolean;
    /**
     * Specifies whether a user can scroll the content with the scrollbar. Applies only if useNative is false.
     */
    scrollByThumb?: boolean;
    /**
     * Specifies when the UI component shows the scrollbar.
     */
    showScrollbar?: 'onScroll' | 'onHover' | 'always' | 'never';
    /**
     * Indicates whether to use native or simulated scrolling.
     */
    useNative?: boolean;
  }
  /**
   * The ScrollView is a UI component that enables a user to scroll its content.
   */
  export class dxScrollView extends dxScrollable<dxScrollViewOptions> {
    /**
     * Locks the UI component until the release(preventScrollBottom) method is called and executes the function passed to the onPullDown property and the handler assigned to the pullDown event.
     */
    refresh(): void;
    /**
     * Notifies the ScrollView that data loading is finished.
     */
    release(
      preventScrollBottom: boolean
    ): DevExpress.core.utils.DxPromise<void>;
  }
  module dxScrollView {
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxScrollView>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxScrollView>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxScrollView> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxScrollViewOptions;
    /**
     * The type of the pullDown event handler&apos;s argument.
     */
    export type PullDownEvent =
      DevExpress.common.core.events.EventInfo<dxScrollView>;
    /**
     * The type of the reachBottom event handler&apos;s argument.
     */
    export type ReachBottomEvent =
      DevExpress.common.core.events.EventInfo<dxScrollView>;
    /**
     * The type of the scroll event handler&apos;s argument.
     */
    export type ScrollEvent =
      DevExpress.ui.dxScrollable.ScrollEventInfo<dxScrollView>;
    /**
     * The type of the updated event handler&apos;s argument.
     */
    export type UpdatedEvent =
      DevExpress.ui.dxScrollable.ScrollEventInfo<dxScrollView>;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxScrollViewOptions
    extends dxScrollableOptions<dxScrollView> {
    /**
     * A function that is executed when the &apos;pull to refresh&apos; gesture is performed. Supported on mobile devices only.
     */
    onPullDown?: (e: DevExpress.ui.dxScrollView.PullDownEvent) => void;
    /**
     * A function that is executed when the content is scrolled down to the bottom.
     */
    onReachBottom?: (e: DevExpress.ui.dxScrollView.ReachBottomEvent) => void;
    /**
     * Specifies the text shown in the pullDown panel when pulling the content down lowers the refresh threshold.
     */
    pulledDownText?: string;
    /**
     * Specifies the text shown in the pullDown panel while pulling the content down to the refresh threshold.
     */
    pullingDownText?: string;
    /**
     * Specifies the text shown in the pullDown panel displayed when content is scrolled to the bottom.
     */
    reachBottomText?: string;
    /**
     * Specifies the text shown in the pullDown panel displayed when the content is being refreshed.
     */
    refreshingText?: string;
  }
  /**
   * The SelectBox UI component is an editor that allows an end user to select an item from a drop-down list.
   */
  export class dxSelectBox<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue = DevExpress.ui.dxSelectBox.Properties
  > extends dxDropDownList<TProperties> {}
  module dxSelectBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      ClipboardEvent
    >;
    /**
     * The type of the customItemCreating event handler&apos;s argument.
     */
    export type CustomItemCreatingEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox> &
        CustomItemCreatingInfo;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface CustomItemCreatingInfo {
      /**
       * 
       */
      readonly text?: string;
      /**
       * 
       */
      customItem?: string | any | PromiseLike<any>;
    }
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSelectBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      KeyboardEvent
    >;
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSelectBox,
      ClipboardEvent
    >;
    export type Properties = dxSelectBoxOptions<SelectBoxInstance>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface SelectBoxInstance extends dxSelectBox<Properties> {}
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSelectBox> &
        DevExpress.ui.dxDropDownList.SelectionChangedInfo;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxSelectBox,
        KeyboardEvent | MouseEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSelectBoxOptions<TComponent>
    extends dxDropDownListOptions<TComponent> {
    /**
     * Specifies whether the UI component allows a user to enter a custom value. Requires the onCustomItemCreating handler implementation.
     */
    acceptCustomValue?: boolean;
    /**
     * Specifies a custom template for the text field. Must contain the TextBox UI component.
     * @deprecated Use the fieldAddons option instead.
     */
    fieldTemplate?:
      | template
      | ((
          selectedItem: any,
          fieldElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies widget input field addons.
     */
    fieldAddons?: FieldAddons;
    /**
     * A function that is executed when a user adds a custom item. Requires acceptCustomValue to be set to true.
     */
    onCustomItemCreating?: (
      e: DevExpress.common.core.events.EventInfo<TComponent> &
        DevExpress.ui.dxSelectBox.CustomItemCreatingInfo
    ) => void;
    /**
     * Specifies whether a user can open the drop-down list by clicking a text field.
     */
    openOnFieldClick?: boolean;
    /**
     * The text that is provided as a hint in the select box editor.
     */
    placeholder?: string;
    /**
     * Specifies whether the drop-down button is visible.
     */
    showDropDownButton?: boolean;
    /**
     * Specifies whether or not to display selection controls.
     */
    showSelectionControls?: boolean;
    /**
     * Specifies the DOM event after which the custom item should be created. Applies only if acceptCustomValue is enabled.
     */
    customItemCreateEvent?: string;
    /**
     * Configures the drop-down field which holds the content.
     */
    dropDownOptions?: DevExpress.ui.dxPopup.Properties;
  }
  /**
   * The Slider is a UI component that allows an end user to set a numeric value on a continuous range of possible values.
   */
  export class dxSlider extends dxTrackBar<dxSliderOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxSlider.Properties['value']): void;
  }
  module dxSlider {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxSlider>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSlider>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSlider>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSlider> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxSliderOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxSlider,
        DevExpress.events.InteractionEvent | UIEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
    * A base class for track bar UI components.
    * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
    */
   export interface dxSliderBase {}
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSliderBaseOptions<TComponent>
    extends dxTrackBarOptions<TComponent> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the step by which a handle moves when a user presses Page Up or Page Down.
     */
    keyStep?: number;
    /**
     * Configures the labels displayed at the min and max values.
     */
    label?: {
      /**
       * Formats a value before it is displayed in a label.
       */
      format?: DevExpress.common.core.localization.Format;
      /**
       * Specifies whether labels are over or under the scale.
       */
      position?: DevExpress.common.VerticalEdge;
      /**
       * Specifies whether slider labels are visible.
       */
      visible?: boolean;
    };
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies whether to highlight the selected range.
     */
    showRange?: boolean;
    /**
     * Specifies the step by which the UI component&apos;s value changes when a user drags a handler.
     */
    step?: number;
    /**
     * Configures a tooltip.
     */
    tooltip?: {
      /**
       * Specifies whether a tooltip is enabled.
       */
      enabled?: boolean;
      /**
       * Specifies a tooltip&apos;s display format.
       */
      format?: DevExpress.common.core.localization.Format;
      /**
       * Specifies whether a tooltip is over or under the slider.
       */
      position?: DevExpress.common.VerticalEdge;
      /**
       * Specifies when the UI component shows a tooltip.
       */
      showMode?: DevExpress.common.TooltipShowMode;
    };
    /**
     * Specifies when to change the component&apos;s value.
     */
    valueChangeMode?: DevExpress.common.SliderValueChangeMode;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSliderOptions extends dxSliderBaseOptions<dxSlider> {
    /**
     * The current slider value.
     */
    value?: number;
  }
  /**
   * Sortable is a user interface utility that allows a UI component&apos;s items to be reordered via drag and drop gestures.
   */
  export class dxSortable
    extends DOMComponent<dxSortableOptions>
    implements DraggableBase
  {
    /**
     * Updates Sortable&apos;s dimensions. Call this method after items are added or their dimensions are changed during dragging.
     */
    update(): void;
  }
  module dxSortable {
    /**
     * The type of the add event handler&apos;s argument.
     */
    export interface AddEvent {
      /**
       * 
       */
      readonly component: dxSortable;
      /**
       * 
       */
      readonly element: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly model?: any;
      /**
       * 
       */
      readonly event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>;
      /**
       * 
       */
      readonly itemData?: any;
      /**
       * 
       */
      readonly itemElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly fromIndex: number;
      /**
       * 
       */
      readonly toIndex: number;
      /**
       * 
       */
      readonly fromComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly toComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly fromData?: any;
      /**
       * 
       */
      readonly toData?: any;
      /**
       * 
       */
      readonly dropInsideItem: boolean;
    }
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSortable>;
    /**
     * The type of the dragChange event handler&apos;s argument.
     */
    export type DragChangeEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxSortable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly itemData?: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromIndex?: number;
        /**
         * 
         */
        readonly toIndex?: number;
        /**
         * 
         */
        readonly fromComponent?: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly toComponent?: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly fromData?: any;
        /**
         * 
         */
        readonly toData?: any;
        /**
         * 
         */
        readonly dropInsideItem?: boolean;
      };
    /**
     * The type of the dragEnd event handler&apos;s argument.
     */
    export type DragEndEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxSortable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly itemData?: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromIndex: number;
        /**
         * 
         */
        readonly toIndex: number;
        /**
         * 
         */
        readonly fromComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly toComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly fromData?: any;
        /**
         * 
         */
        readonly toData?: any;
        /**
         * 
         */
        readonly dropInsideItem: boolean;
      };
    /**
     * The type of the dragMove event handler&apos;s argument.
     */
    export type DragMoveEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxSortable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        readonly itemData?: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromIndex: number;
        /**
         * 
         */
        readonly toIndex: number;
        /**
         * 
         */
        readonly fromComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly toComponent: dxSortable | dxDraggable;
        /**
         * 
         */
        readonly fromData?: any;
        /**
         * 
         */
        readonly toData?: any;
        /**
         * 
         */
        readonly dropInsideItem: boolean;
      };
    /**
     * The type of the dragStart event handler&apos;s argument.
     */
    export type DragStartEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.NativeEventInfo<
        dxSortable,
        DevExpress.events.PointerInteractionEvent
      > & {
        /**
         * 
         */
        itemData?: any;
        /**
         * 
         */
        readonly itemElement: DevExpress.core.DxElement;
        /**
         * 
         */
        readonly fromIndex: number;
        /**
         * 
         */
        readonly fromData?: any;
      };
    export interface DragTemplateData {
      readonly itemData?: any;
      readonly itemElement: DevExpress.core.DxElement;
      readonly fromIndex: number;
    }
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSortable>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSortable> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxSortableOptions;
    /**
     * The type of the remove event handler&apos;s argument.
     */
    export type RemoveEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSortable,
      DevExpress.events.PointerInteractionEvent
    > & {
      /**
       * 
       */
      readonly itemData?: any;
      /**
       * 
       */
      readonly itemElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly fromIndex: number;
      /**
       * 
       */
      readonly toIndex: number;
      /**
       * 
       */
      readonly fromComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly toComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly fromData?: any;
      /**
       * 
       */
      readonly toData?: any;
    };
    /**
     * The type of the reorder event handler&apos;s argument.
     */
    export type ReorderEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSortable,
      DevExpress.events.PointerInteractionEvent
    > & {
      /**
       * 
       */
      readonly itemData?: any;
      /**
       * 
       */
      readonly itemElement: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly fromIndex: number;
      /**
       * 
       */
      readonly toIndex: number;
      /**
       * 
       */
      readonly fromComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly toComponent: dxSortable | dxDraggable;
      /**
       * 
       */
      readonly fromData?: any;
      /**
       * 
       */
      readonly toData?: any;
      /**
       * 
       */
      readonly dropInsideItem: boolean;
      /**
       * 
       */
      promise?: PromiseLike<void>;
    };
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSortableOptions extends DraggableBaseOptions<dxSortable> {
    /**
     * Allows a user to drop an item inside another item.
     */
    allowDropInsideItem?: boolean;
    /**
     * Allows a user to reorder sortable items.
     */
    allowReordering?: boolean;
    /**
     * Specifies custom markup to be shown instead of the item being dragged.
     */
    dragTemplate?:
      | template
      | ((
          dragInfo: DevExpress.ui.dxSortable.DragTemplateData,
          containerElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement)
      | undefined;
    /**
     * Specifies how to highlight the item&apos;s drop position.
     */
    dropFeedbackMode?: DevExpress.common.DragHighlight;
    /**
     * Specifies a CSS selector for the items that can be dragged.
     */
    filter?: string;
    /**
     * Notifies the UI component of the items&apos; orientation.
     */
    itemOrientation?: DevExpress.common.Orientation;
    /**
     * Moves an element in the HTML markup when it is dropped.
     */
    moveItemOnDrop?: boolean;
    /**
     * A function that is called when a new item is added.
     */
    onAdd?: (e: DevExpress.ui.dxSortable.AddEvent) => void;
    /**
     * A function that is called when the dragged item&apos;s position in the list is changed.
     */
    onDragChange?: (e: DevExpress.ui.dxSortable.DragChangeEvent) => void;
    /**
     * A function that is called when the drag gesture is finished.
     */
    onDragEnd?: (e: DevExpress.ui.dxSortable.DragEndEvent) => void;
    /**
     * A function that is called every time a draggable item is moved.
     */
    onDragMove?: (e: DevExpress.ui.dxSortable.DragMoveEvent) => void;
    /**
     * A function that is called when a drag gesture is initialized.
     */
    onDragStart?: (e: DevExpress.ui.dxSortable.DragStartEvent) => void;
    /**
     * A function that is called when a draggable item is removed.
     */
    onRemove?: (e: DevExpress.ui.dxSortable.RemoveEvent) => void;
    /**
     * A function that is called when the draggable items are reordered.
     */
    onReorder?: (e: DevExpress.ui.dxSortable.ReorderEvent) => void;
  }
  /**
   * The SpeechToText UI component is TBA.
   */
  export class dxSpeechToText extends Widget<DevExpress.ui.dxSpeechToText.Properties> {}
  module dxSpeechToText {
    /**
     * The argument type in the contentReady event.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText>;
    /**
     * The argument type in the disposing event.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText>;
    /**
     * The argument type in the end event.
     */
    export type EndEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText> & {
        event: Event;
      };
    /**
     * The argument type in the error event.
     */
    export type ErrorEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText> & {
        event: Event;
      };
    export type ExplicitTypes = {
      Properties: Properties;
      ContentReadyEvent: ContentReadyEvent;
      DisposingEvent: DisposingEvent;
      InitializedEvent: InitializedEvent;
      OptionChangedEvent: OptionChangedEvent;
      StartClickEvent: StartClickEvent;
      StopClickEvent: StopClickEvent;
      ResultEvent: ResultEvent;
      ErrorEvent: ErrorEvent;
    };
    /**
     * The argument type in the initialized event.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSpeechToText>;
    /**
     * The argument type in the optionChanged event.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * 
     */
    export interface Properties extends WidgetOptions<dxSpeechToText> {
      /**
       * Allows you to implement custom speech recognition engines.
       */
      customSpeechRecognizer?: CustomSpeechRecognizer;

      /**
       * The SpeechToText button text in the initial component state.
       */
      startText?: string;

      /**
       * The SpeechToText button text in the &apos;listening&apos; component state.
       */
      stopText?: string;

      /**
       * Specifies SpeechToText button styling.
       */
      stylingMode?: DevExpress.common.ButtonStyle;

      /**
       * The SpeechToText button icon in the initial component state.
       */
      startIcon?: string;

      /**
       * The SpeechToText button icon in the &apos;listening&apos; component state.
       */
      stopIcon?: string;

      /**
       * Specifies the SpeechToText button type.
       */
      type?: DevExpress.common.ButtonType | string;

      /**
       * Configures the Web Speech API (SpeechRecognition properties).
       */
      speechRecognitionConfig?:
        | SpeechRecognitionConfig
        | { [key: string]: any };

      /**
       * A function that is executed when the SpeechToText button is clicked or tapped in the initial component state.
       */
      onStartClick?: ((e: StartClickEvent) => void) | undefined;

      /**
       * A function that is executed when the SpeechToText button is clicked or tapped in the &apos;listening&apos; component state.
       */
      onStopClick?: ((e: StopClickEvent) => void) | undefined;

      /**
       * A function that is executed when the Web Speech API returns a result.
       */
      onResult?: ((e: ResultEvent) => void) | undefined;

      /**
       * A function that is executed when the Web Speech API encounters an error.
       */
      onError?: ((e: ErrorEvent) => void) | undefined;

      /**
       * A function that is executed when the Web Speech API finishes transcription and SpeechToText switches to the initial component state.
       */
      onEnd?: ((e: EndEvent) => void) | undefined;
    }
    /**
     * The argument type in the result event.
     */
    export type ResultEvent =
      DevExpress.common.core.events.EventInfo<dxSpeechToText> & {
        event: Event;
      };
    /**
     * The argument type in the startClick event.
     */
    export type StartClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSpeechToText,
      DevExpress.events.InteractionEvent
    >;
    /**
     * The argument type in the stopClick event.
     */
    export type StopClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSpeechToText,
      DevExpress.events.InteractionEvent
    >;
  }
  /**
   * The SpeedDialAction is a button that performs a custom action. It can be represented by a Floating Action Button (FAB) or a button in a speed dial menu opened with the FAB.
   */
  export class dxSpeedDialAction extends Widget<dxSpeedDialActionOptions> {}
  module dxSpeedDialAction {
    /**
     * The type of the click event handler&apos;s argument.
     */
    export type ClickEvent = DevExpress.common.core.events.NativeEventInfo<
      dxSpeedDialAction,
      MouseEvent | PointerEvent
    > & {
      /**
       * 
       */
      actionElement?: DevExpress.core.DxElement;
    };
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxSpeedDialAction> & {
        /**
         * 
         */
        actionElement?: DevExpress.core.DxElement;
      };
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSpeedDialAction>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSpeedDialAction>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSpeedDialAction> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxSpeedDialActionOptions;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSpeedDialActionOptions
    extends WidgetOptions<dxSpeedDialAction> {
    /**
     * Specifies the icon the FAB or speed dial action button displays.
     */
    icon?: string;
    /**
     * Allows you to reorder action buttons in the speed dial menu.
     */
    index?: number;
    /**
     * Specifies the text label displayed inside the FAB or near the speed dial action button.
     */
    label?: string;
    /**
     * A function that is executed when the FAB or speed dial action button is clicked or tapped.
     */
    onClick?: (e: DevExpress.ui.dxSpeedDialAction.ClickEvent) => void;
    /**
     * A function that is executed when the UI component is rendered and each time the component is repainted.
     */
    onContentReady?: (
      e: DevExpress.ui.dxSpeedDialAction.ContentReadyEvent
    ) => void;
    /**
     * Allows you to hide the FAB from the view or the action from the speed dial menu.
     */
    visible?: boolean;
  }
  /**
   * Splitter is a UI component that allows you to divide a page or section into multiple adjustable panes.
   */
  export class dxSplitter<
    TItem extends DevExpress.ui.dxSplitter.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidget<
    DevExpress.ui.dxSplitter.Properties<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxSplitter {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxSplitter<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxSplitter<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike<TKey>, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxSplitter<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxSplitter<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemCollapsed event handler&apos;s argument.
     */
    export type ItemCollapsedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxSplitter<TKey>,
      DevExpress.events.InteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TKey>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxSplitter<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemExpanded event handler&apos;s argument.
     */
    export type ItemExpandedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxSplitter<TKey>,
      DevExpress.events.InteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TKey>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike<TKey> = string | Item<TKey> | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxSplitter<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxSplitter<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike<TKey> = any,
      TKey = any
    > = dxSplitterOptions<TItem, TKey>;
    /**
     * The type of the resizeEnd event handler&apos;s argument.
     */
    export type ResizeEndEvent<TKey = any> =
      DevExpress.common.core.events.NativeEventInfo<
        dxSplitter<TKey>,
        DevExpress.events.InteractionEvent
      > &
        ResizeInfo;
    /**
     * The type of the resize event handler&apos;s argument.
     */
    export type ResizeEvent<TKey = any> =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.NativeEventInfo<
          dxSplitter<TKey>,
          DevExpress.events.InteractionEvent
        > &
        ResizeInfo;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface ResizeInfo {
      /**
       * A resize handle element.
       */
      readonly handleElement?: DevExpress.core.DxElement;
    }
    /**
     * The type of the resizeStart event handler&apos;s argument.
     */
    export type ResizeStartEvent<TKey = any> =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.NativeEventInfo<
          dxSplitter<TKey>,
          DevExpress.events.InteractionEvent
        > &
        ResizeInfo;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSplitterItem<TKey = any> extends CollectionWidgetItem {
    /**
     * Specifies a splitter inside an item (pane).
     */
    splitter?: DevExpress.ui.dxSplitter.Properties<any, TKey> | undefined;
    /**
     * Specifies the initial size of an item (pane) in pixels or as a percentage. The size changes after any layout alteration.
     */
    size?: number | string | undefined;
    /**
     * Specifies the maximum size of an item (pane) in pixels or as a percentage.
     */
    maxSize?: number | string | undefined;
    /**
     * Specifies the minimum size of an item (pane) in pixels or as a percentage.
     */
    minSize?: number | string | undefined;
    /**
     * Specifies the size of a collapsible item (pane) when collapsed in pixels or as a percentage.
     */
    collapsedSize?: number | string | undefined;
    /**
     * Specifies whether an item (pane) is initially collapsed.
     */
    collapsed?: boolean;
    /**
     * Specifies whether an item (pane) is collapsible.
     */
    collapsible?: boolean;
    /**
     * Specifies whether an item (pane) is resizable.
     */
    resizable?: boolean;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxSplitterOptions<
    TItem extends DevExpress.ui.dxSplitter.ItemLike<TKey> = any,
    TKey = any
  > extends CollectionWidgetOptions<dxSplitter<TItem, TKey>, TItem, TKey> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies item orientation (layout).
     */
    orientation?: DevExpress.common.Orientation;
    /**
     * An array of items (panes) displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies whether to allow the Splitter to take focus and allow keyboard navigation.
     */
    allowKeyboardNavigation?: boolean;
    /**
     * Specifies the size of a separator bar in pixels.
     */
    separatorSize?: number;
    /**
     * A function that is executed each time an item (pane) is resized by one pixel.
     */
    onResize?: (e: DevExpress.ui.dxSplitter.ResizeEvent) => void;
    /**
     * A function that is called when resizing ends.
     */
    onResizeEnd?: (e: DevExpress.ui.dxSplitter.ResizeEndEvent) => void;
    /**
     * A function that is called when resizing starts.
     */
    onResizeStart?: (e: DevExpress.ui.dxSplitter.ResizeStartEvent) => void;
    /**
     * A function that is executed after an item (pane) is expanded.
     */
    onItemExpanded?: (e: DevExpress.ui.dxSplitter.ItemExpandedEvent) => void;
    /**
     * A function that is executed after an item (pane) is collapsed.
     */
    onItemCollapsed?: (e: DevExpress.ui.dxSplitter.ItemCollapsedEvent) => void;
  }
  /**
   * A Stepper is a UI component that displays progress as a user moves through a sequence of steps.
   */
  export class dxStepper<
    TItem extends DevExpress.ui.dxStepper.ItemLike = any,
    TKey = any
  > extends CollectionWidget<
    DevExpress.ui.dxStepper.Properties<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxStepper {
    /**
     * The argument type in the disposing event.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxStepper<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
      SelectionChangingEvent: SelectionChangingEvent<TItem, TKey>;
    };
    /**
     * The argument type in the initialized event.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxStepper<TItem, TKey>
    >;
    /**
     * The argument type in the itemClick event.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxStepper<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The argument type in the itemContextMenu event.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxStepper<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The argument type in the itemRendered event.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxStepper<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The argument type in the optionChanged event.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxStepper<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxStepperOptions<TItem, TKey>;
    /**
     * The argument type in the selectionChanged event.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxStepper<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    /**
     * The argument type in the selectionChanging event.
     */
    export type SelectionChangingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.ui.CollectionWidget.SelectionChangingEventBase<
      dxStepper<TItem, TKey>
    >;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxStepperItem extends CollectionWidgetItem {
    /**
     * Specifies the indicator icon.
     */
    icon?: string;
    /**
     * Specifies the caption displayed next to the step.
     */
    label?: string;
    /**
     * Specifies the hint text that appears when an item (step) is hovered over or long-pressed.
     */
    hint?: string;
    /**
     * Marks the step as optional.
     */
    optional?: boolean;
    /**
     * Specifies a visual indicator for validation.
     */
    isValid?: boolean;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxStepperOptions<
    TItem extends DevExpress.ui.dxStepper.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxStepper<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies whether Stepper changes its appearance when in the active state (when an end user interacts with it).
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its appearance when a user hovers over it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies if items are selected automatically when focused by keyboard.
     */
    selectOnFocus?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies the Stepper orientation.
     */
    orientation?: DevExpress.common.Orientation;
    /**
     * Specifies a navigation mode (linear/non-linear).
     */
    linear?: boolean;
    /**
     * An array of items (steps) displayed by the Stepper component.
     */
    items?: Array<TItem>;
  }
  /**
   * The Switch is a UI component that can be in two states: &apos;On&apos; and &apos;Off&apos;.
   */
  export class dxSwitch extends Editor<dxSwitchOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxSwitch.Properties['value']): void;
  }
  module dxSwitch {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxSwitch>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxSwitch>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxSwitch>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxSwitch> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxSwitchOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxSwitch,
        DevExpress.events.InteractionEvent | UIEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxSwitchOptions extends EditorOptions<dxSwitch> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * Specifies the text displayed when the UI component is switched off.
     */
    switchedOffText?: string;
    /**
     * Specifies the text displayed when the UI component is switched on.
     */
    switchedOnText?: string;
    /**
     * A Boolean value specifying whether the current switch state is &apos;On&apos; or &apos;Off&apos;.
     */
    value?: boolean;
  }
  /**
   * The TabPanel is a UI component consisting of the Tabs and MultiView UI components. It automatically synchronizes the selected tab with the currently displayed view, and vice versa.
   */
  export class dxTabPanel<
    TItem extends DevExpress.ui.dxTabPanel.ItemLike = any,
    TKey = any
  > extends CollectionWidget<
    DevExpress.ui.dxTabPanel.Properties<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxTabPanel {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangingEvent: SelectionChangingEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
      TitleClickEvent: TitleClickEvent<TItem, TKey>;
      TitleHoldEvent: TitleHoldEvent<TItem, TKey>;
      TitleRenderedEvent: TitleRenderedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxTabPanel<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabPanel<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabPanel<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabPanel<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxTabPanelOptions<TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    /**
     * The type of the selectionChanging event handler&apos;s argument.
     */
    export type SelectionChangingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.ui.CollectionWidget.SelectionChangingEventBase<
      dxTabPanel<TItem, TKey>
    >;
    /**
     * 
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export interface TabPanelItemInfo<TItem extends ItemLike> {
      /**
       * 
       */
      readonly itemData?: TItem;
      /**
       * 
       */
      readonly itemElement?: DevExpress.core.DxElement;
      /**
       * 
       */
      readonly itemIndex: number;
    }
    /**
     * The type of the titleClick event handler&apos;s argument.
     */
    export type TitleClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabPanel<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      TabPanelItemInfo<TItem>;
    /**
     * The type of the titleHold event handler&apos;s argument.
     */
    export type TitleHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabPanel<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      TabPanelItemInfo<TItem>;
    /**
     * The type of the titleRendered event handler&apos;s argument.
     */
    export type TitleRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabPanel<TItem, TKey>> &
      TabPanelItemInfo<TItem>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTabPanelItem extends DevExpress.ui.dxMultiView.Item {
    /**
     * Specifies a badge text for the tab.
     */
    badge?: string;
    /**
     * Specifies the icon to be displayed in the tab&apos;s title.
     */
    icon?: string;
    /**
     * Specifies a template that should be used to render the tab for this item only.
     */
    tabTemplate?:
      | template
      | (() => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the item title text displayed on a corresponding tab.
     */
    title?: string;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxTabPanelOptions<
    TItem extends DevExpress.ui.dxTabPanel.ItemLike = any,
    TKey = any
  > extends dxMultiViewBaseOptions<dxTabPanel<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies whether or not to animate the displayed item change.
     */
    animationEnabled?: boolean;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies a custom template for item titles.
     */
    itemTitleTemplate?:
      | template
      | ((
          itemData: TItem,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies icon position relative to the text inside the tab.
     */
    iconPosition?: DevExpress.common.TabsIconPosition;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies the key property used to access data items. Each key value must be unique.
     */
    keyExpr?: string | Function;
    /**
     * A function that is executed when a tab is clicked or tapped.
     */
    onTitleClick?:
      | ((e: DevExpress.ui.dxTabPanel.TitleClickEvent<TItem, TKey>) => void)
      | string;
    /**
     * A function that is executed when a tab has been held for a specified period.
     */
    onTitleHold?: (
      e: DevExpress.ui.dxTabPanel.TitleHoldEvent<TItem, TKey>
    ) => void;
    /**
     * A function that is executed after a tab is rendered.
     */
    onTitleRendered?: (
      e: DevExpress.ui.dxTabPanel.TitleRenderedEvent<TItem, TKey>
    ) => void;
    /**
     * Specifies whether to repaint only those elements whose data changed.
     */
    repaintChangesOnly?: boolean;
    /**
     * A Boolean value specifying if tabs in the title are scrolled by content.
     */
    scrollByContent?: boolean;
    /**
     * A Boolean indicating whether or not to add scrolling support for tabs in the title.
     */
    scrollingEnabled?: boolean;
    /**
     * Specifies whether navigation buttons should be available when tabs exceed the UI component&apos;s width.
     */
    showNavButtons?: boolean;
    /**
     * Specifies the styling mode for the active tab.
     */
    stylingMode?: DevExpress.common.TabsStyle;
    /**
     * A Boolean value specifying whether or not to allow users to change the selected index by swiping.
     */
    swipeEnabled?: boolean;
    /**
     * Specifies tab position relative to the panel.
     */
    tabsPosition?: DevExpress.common.Position;
  }
  /**
   * The Tabs component is a tab strip used to switch between pages or views. This UI component is included in the TabPanel UI component, but you can use Tabs separately as well.
   */
  export class dxTabs<
    TItem extends DevExpress.ui.dxTabs.ItemLike = any,
    TKey = any
  > extends CollectionWidget<
    DevExpress.ui.dxTabs.Properties<TItem, TKey>,
    TItem,
    TKey
  > {}
  module dxTabs {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabs<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabs<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
      SelectionChangedEvent: SelectionChangedEvent<TItem, TKey>;
      SelectionChangingEvent: SelectionChangingEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<dxTabs<TItem, TKey>>;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabs<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabs<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTabs<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    export type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabs<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabs<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxTabsBaseOptions<dxTabs<TItem, TKey>, TItem, TKey>;
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTabs<TItem, TKey>> &
      DevExpress.ui.CollectionWidget.SelectionChangeInfo<TItem>;
    /**
     * The type of the selectionChanging event handler&apos;s argument.
     */
    export type SelectionChangingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.ui.CollectionWidget.SelectionChangingEventBase<
      dxTabs<TItem, TKey>
    >;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTabsBaseOptions<
    TComponent extends dxTabs<TItem, TKey> = dxTabs<any, any>,
    TItem extends DevExpress.ui.dxTabs.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<TComponent, TItem, TKey> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies icon position relative to the text inside the tab.
     */
    iconPosition?: DevExpress.common.TabsIconPosition;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies component orientation.
     */
    orientation?: DevExpress.common.Orientation;
    /**
     * Specifies whether to repaint only those elements whose data changed.
     */
    repaintChangesOnly?: boolean;
    /**
     * Specifies whether or not an end user can scroll tabs by swiping.
     */
    scrollByContent?: boolean;
    /**
     * Specifies whether or not an end user can scroll tabs.
     */
    scrollingEnabled?: boolean;
    /**
     * Specifies whether the UI component enables an end user to select only a single item or multiple items.
     */
    selectionMode?: DevExpress.common.SingleOrMultiple;
    /**
     * Specifies whether navigation buttons should be available when tabs exceed the UI component&apos;s width.
     */
    showNavButtons?: boolean;
    /**
     * Specifies the styling mode for the active tab.
     */
    stylingMode?: DevExpress.common.TabsStyle;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTabsItem extends CollectionWidgetItem {
    /**
     * Specifies a badge text for the tab.
     */
    badge?: string;
    /**
     * Specifies the icon to be displayed on the tab.
     */
    icon?: string;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxTabsOptions<
    TItem extends DevExpress.ui.dxTabs.ItemLike = any,
    TKey = any
  > extends DevExpress.ui.dxTabs.Properties<TItem, TKey> {}
  /**
   * The TagBox UI component is an editor that allows an end user to select multiple items from a drop-down list.
   */
  export class dxTagBox extends dxSelectBox<dxTagBoxOptions> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: DevExpress.ui.dxTagBox.Properties['value']): void;
  }
  module dxTagBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      Event
    >;
    /**
     * The type of the closed event handler&apos;s argument.
     */
    export type ClosedEvent = DevExpress.common.core.events.EventInfo<dxTagBox>;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox>;
    /**
     * The type of the customItemCreating event handler&apos;s argument.
     */
    export type CustomItemCreatingEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox> &
        DevExpress.ui.dxSelectBox.CustomItemCreatingInfo;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox>;
    export type DropDownButtonTemplateData =
      DevExpress.ui.dxDropDownEditor.DropDownButtonTemplateDataModel;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxTagBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent =
      DevExpress.common.core.events.NativeEventInfo<dxTagBox> &
        DevExpress.common.core.events.ItemInfo;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTagBox,
      KeyboardEvent
    >;
    /**
     * The type of the multiTagPreparing event handler&apos;s argument.
     */
    export type MultiTagPreparingEvent =
      DevExpress.common.core.events.Cancelable &
        DevExpress.common.core.events.EventInfo<dxTagBox> & {
          /**
           * 
           */
          readonly multiTagElement: DevExpress.core.DxElement;
          /**
           * 
           */
          readonly selectedItems?: Array<string | number | any>;
          /**
           * 
           */
          text?: string;
        };
    /**
     * The type of the opened event handler&apos;s argument.
     */
    export type OpenedEvent = DevExpress.common.core.events.EventInfo<dxTagBox>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxTagBoxOptions;
    /**
     * The type of the selectAllValueChanged event handler&apos;s argument.
     */
    export type SelectAllValueChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox> & {
        /**
         * 
         */
        readonly value: boolean;
      };
    /**
     * The type of the selectionChanged event handler&apos;s argument.
     */
    export type SelectionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTagBox> &
        DevExpress.ui.CollectionWidget.SelectionChangeInfo<
          string | number | any
        >;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxTagBox,
        KeyboardEvent | MouseEvent | PointerEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTagBoxOptions
    extends Pick<
      dxSelectBoxOptions<dxTagBox>,
      Exclude<keyof dxSelectBoxOptions<dxTagBox>, 'onSelectionChanged'>
    > {
    /**
     * Specifies how the UI component applies values.
     */
    applyValueMode?: DevExpress.common.ApplyValueMode;
    /**
     * A Boolean value specifying whether or not to hide selected items.
     */
    hideSelectedItems?: boolean;
    /**
     * Specifies the limit on displayed tags. On exceeding it, the UI component replaces all tags with a single multi-tag that displays the number of selected items.
     */
    maxDisplayedTags?: number | undefined;
    /**
     * A Boolean value specifying whether or not the UI component is multiline.
     */
    multiline?: boolean;
    /**
     * A function that is executed before the multi-tag is rendered.
     */
    onMultiTagPreparing?: (
      e: DevExpress.ui.dxTagBox.MultiTagPreparingEvent
    ) => void;
    /**
     * A function that is executed when the &apos;Select All&apos; check box value is changed. Applies only if showSelectionControls is true.
     */
    onSelectAllValueChanged?: (
      e: DevExpress.ui.dxTagBox.SelectAllValueChangedEvent
    ) => void;
    /**
     * A function that is executed when a list item is selected or selection is canceled.
     */
    onSelectionChanged?: (
      e: DevExpress.ui.dxTagBox.SelectionChangedEvent
    ) => void;
    /**
     * Specifies the mode in which all items are selected.
     */
    selectAllMode?: DevExpress.common.SelectAllMode;
    /**
     * Gets the currently selected items.
     */
    selectedItems?: Array<string | number | any>;
    /**
     * Specifies the text displayed at the &apos;Select All&apos; check box.
     */
    selectAllText?: string;
    /**
     * Specifies whether the drop-down button is visible.
     */
    showDropDownButton?: boolean;
    /**
     * Specifies the maximum filter query length in characters.
     */
    maxFilterQueryLength?: number;
    /**
     * Specifies whether the multi-tag is shown without ordinary tags.
     */
    showMultiTagOnly?: boolean;
    /**
     * Specifies a custom template for tags.
     */
    tagTemplate?:
      | template
      | ((
          itemData: any,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
    /**
     * Specifies the selected items.
     */
    value?: Array<string | number | any>;
  }
  /**
   * The TextArea is a UI component that enables a user to enter and edit a multi-line text.
   */
  export class dxTextArea extends dxTextBox<dxTextAreaOptions> {}
  module dxTextArea {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      Event
    >;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxTextArea>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxTextArea>;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxTextArea>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      KeyboardEvent
    >;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTextArea> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextArea,
      ClipboardEvent
    >;
    export type Properties = dxTextAreaOptions;
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxTextArea,
        DevExpress.events.InteractionEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTextAreaOptions extends dxTextBoxOptions<dxTextArea> {
    /**
     * A Boolean value specifying whether or not the auto resizing mode is enabled.
     */
    autoResizeEnabled?: boolean;
    /**
     * Specifies the maximum height of the UI component.
     */
    maxHeight?: number | string | undefined;
    /**
     * Specifies the minimum height of the UI component.
     */
    minHeight?: number | string | undefined;
    /**
     * Specifies whether or not the UI component checks the inner text for spelling mistakes.
     */
    spellcheck?: boolean;
  }
  /**
   * The TextBox is a UI component that enables a user to enter and edit a single line of text.
   */
  export class dxTextBox<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue = DevExpress.ui.dxTextBox.Properties
  > extends dxTextEditor<TProperties> {
    /**
     * Resets the value property to the value passed as an argument.
     */
    reset(value?: TProperties['value']): void;
  }
  module dxTextBox {
    /**
     * The type of the change event handler&apos;s argument.
     */
    export type ChangeEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      Event
    >;
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxTextBox>;
    /**
     * The type of the copy event handler&apos;s argument.
     */
    export type CopyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      ClipboardEvent
    >;
    /**
     * The type of the cut event handler&apos;s argument.
     */
    export type CutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      ClipboardEvent
    >;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxTextBox>;
    /**
     * The type of the enterKey event handler&apos;s argument.
     */
    export type EnterKeyEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      KeyboardEvent
    >;
    /**
     * The type of the focusIn event handler&apos;s argument.
     */
    export type FocusInEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      FocusEvent
    >;
    /**
     * The type of the focusOut event handler&apos;s argument.
     */
    export type FocusOutEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      FocusEvent
    >;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxTextBox>;
    /**
     * The type of the input event handler&apos;s argument.
     */
    export type InputEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      UIEvent & { target: HTMLInputElement }
    >;
    /**
     * The type of the keyDown event handler&apos;s argument.
     */
    export type KeyDownEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      KeyboardEvent
    >;
    export type KeyPressEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      KeyboardEvent
    >;
    /**
     * The type of the keyUp event handler&apos;s argument.
     */
    export type KeyUpEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      KeyboardEvent
    >;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTextBox> &
        DevExpress.common.core.events.ChangedOptionInfo;
    /**
     * The type of the paste event handler&apos;s argument.
     */
    export type PasteEvent = DevExpress.common.core.events.NativeEventInfo<
      dxTextBox,
      ClipboardEvent
    >;
    export type Properties = dxTextBoxOptions<TextBoxInstance>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface TextBoxInstance extends dxTextBox<Properties> {}
    export type TextBoxType =
      | 'email'
      | 'password'
      | 'search'
      | 'tel'
      | 'text'
      | 'url';
    /**
     * The type of the valueChanged event handler&apos;s argument.
     */
    export type ValueChangedEvent =
      DevExpress.common.core.events.NativeEventInfo<
        dxTextBox,
        DevExpress.events.InteractionEvent | Event
      > &
        DevExpress.ui.Editor.ValueChangedInfo;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTextBoxOptions<TComponent>
    extends dxTextEditorOptions<TComponent> {
    /**
     * Specifies the maximum number of characters you can enter into the textbox.
     */
    maxLength?: string | number;
    /**
     * The &apos;mode&apos; attribute value of the actual HTML input element representing the text box.
     */
    mode?: DevExpress.ui.dxTextBox.TextBoxType;
    /**
     * Specifies a value the UI component displays.
     */
    value?: string;
  }
  /**
   * A base class for text editing UI components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxTextEditor<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue = DevExpress.ui.dxTextEditor.Properties
  > extends Editor<TProperties> {
    /**
     * Removes focus from the input element.
     */
    blur(): void;
    /**
     * Sets focus to the input element representing the UI component.
     */
    focus(): void;
    /**
     * Gets an instance of a custom action button.
     */
    getButton(name: string): dxButton | undefined;
  }
  module dxTextEditor {
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type Properties = dxTextEditorOptions<TextEditorInstance>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    interface TextEditorInstance extends dxTextEditor<Properties> {}
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTextEditorOptions<TComponent>
    extends EditorOptions<TComponent> {
    /**
     * Allows you to add custom buttons to the input text field.
     */
    buttons?: Array<
      | string
      | DevExpress.common.TextBoxPredefinedButton
      | DevExpress.common.TextEditorButton
    >;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the attributes to be passed on to the underlying HTML element.
     */
    inputAttr?: any;
    /**
     * Specifies a text string used to annotate the editor&apos;s value.
     */
    label?: string;
    /**
     * Specifies the label&apos;s display mode.
     */
    labelMode?: DevExpress.common.LabelMode;
    /**
     * The editor mask that specifies a custom input format.
     */
    mask?: string;
    /**
     * Specifies a mask placeholder. A single character is recommended.
     */
    maskChar?: string;
    /**
     * A message displayed when the entered text does not match the specified pattern.
     */
    maskInvalidMessage?: string;
    /**
     * Specifies custom mask rules.
     */
    maskRules?: any;
    /**
     * The value to be assigned to the `name` attribute of the underlying HTML element.
     */
    name?: string;
    /**
     * A function that is executed when the UI component loses focus after the text field&apos;s content was changed using the keyboard.
     */
    onChange?: (
      e: DevExpress.common.core.events.NativeEventInfo<TComponent, Event>
    ) => void;
    /**
     * A function that is executed when the UI component&apos;s input has been copied.
     */
    onCopy?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        ClipboardEvent
      >
    ) => void;
    /**
     * A function that is executed when the UI component&apos;s input has been cut.
     */
    onCut?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        ClipboardEvent
      >
    ) => void;
    /**
     * A function that is executed when the Enter key has been pressed while the UI component is focused.
     */
    onEnterKey?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent
      >
    ) => void;
    /**
     * A function that is executed when the UI component gets focus.
     */
    onFocusIn?: (
      e: DevExpress.common.core.events.NativeEventInfo<TComponent, FocusEvent>
    ) => void;
    /**
     * A function that is executed when the UI component loses focus.
     */
    onFocusOut?: (
      e: DevExpress.common.core.events.NativeEventInfo<TComponent, FocusEvent>
    ) => void;
    /**
     * A function that is executed each time the UI component&apos;s input is changed while the UI component is focused.
     */
    onInput?: (
      e: DevExpress.common.core.events.NativeEventInfo<TComponent, UIEvent>
    ) => void;
    /**
     * A function that is executed when a user is pressing a key on the keyboard.
     */
    onKeyDown?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent
      >
    ) => void;
    /**
     * A function that is executed when a user releases a key on the keyboard.
     */
    onKeyUp?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        KeyboardEvent
      >
    ) => void;
    /**
     * A function that is executed when the UI component&apos;s input has been pasted.
     */
    onPaste?: (
      e: DevExpress.common.core.events.NativeEventInfo<
        TComponent,
        ClipboardEvent
      >
    ) => void;
    /**
     * Specifies a text string displayed when the editor&apos;s value is empty.
     */
    placeholder?: string;
    /**
     * Specifies whether to display the Clear button in the UI component.
     */
    showClearButton?: boolean;
    /**
     * Specifies when the UI component shows the mask. Applies only if useMaskedValue is true.
     */
    showMaskMode?: DevExpress.common.MaskMode;
    /**
     * Specifies whether or not the UI component checks the inner text for spelling mistakes.
     */
    spellcheck?: boolean;
    /**
     * Specifies how the UI component&apos;s text field is styled.
     */
    stylingMode?: DevExpress.common.EditorStyle;
    /**
     * The read-only property that holds the text displayed by the UI component input element.
     */
    text?: string;
    /**
     * Specifies whether the value should contain mask characters or not.
     */
    useMaskedValue?: boolean;
    /**
     * Specifies the editor&apos;s value.
     */
    value?: any;
    /**
     * Specifies the DOM events after which the UI component&apos;s value should be updated.
     */
    valueChangeEvent?: string;
  }
  /**
   * The TileView UI component contains a collection of tiles. Tiles can store much more information than ordinary buttons, that is why they are very popular in apps designed for touch devices.
   */
  export class dxTileView<
    TItem extends DevExpress.ui.dxTileView.ItemLike = any,
    TKey = any
  > extends CollectionWidget<dxTileViewOptions<TItem, TKey>, TItem, TKey> {
    /**
     * Gets the current scroll position.
     */
    scrollPosition(): number;
  }
  module dxTileView {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTileView<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTileView<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxTileView<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTileView<TItem, TKey>,
      KeyboardEvent | MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTileView<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxTileView<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTileView<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxTileView<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxTileViewOptions<TItem, TKey>;
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTileViewItem extends CollectionWidgetItem {
    /**
     * Specifies a multiplier for the baseItemHeight property value (for the purpose of obtaining the actual item height).
     */
    heightRatio?: number;
    /**
     * Specifies a multiplier for the baseItemWidth property value (for the purpose of obtaining the actual item width).
     */
    widthRatio?: number;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxTileViewOptions<
    TItem extends DevExpress.ui.dxTileView.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxTileView<TItem, TKey>, TItem, TKey> {
    /**
     * Specifies whether the UI component changes its visual state as a result of user interaction.
     */
    activeStateEnabled?: boolean;
    /**
     * Specifies the height of the base tile view item.
     */
    baseItemHeight?: number;
    /**
     * Specifies the width of the base tile view item.
     */
    baseItemWidth?: number;
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * Specifies whether the UI component is oriented horizontally or vertically.
     */
    direction?: DevExpress.common.Orientation;
    /**
     * Specifies whether the UI component can be focused using keyboard navigation.
     */
    focusStateEnabled?: boolean;
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies whether the UI component changes its state when a user pauses on it.
     */
    hoverStateEnabled?: boolean;
    /**
     * Specifies the distance in pixels between adjacent tiles.
     */
    itemMargin?: number;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies when the UI component shows the scrollbar.
     */
    showScrollbar?: DevExpress.common.ScrollbarMode;
  }
  /**
   * The Toast is a UI component that provides pop-up notifications.
   */
  export class dxToast extends dxOverlay<dxToastOptions> {}
  module dxToast {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxToast>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxToast>;
    /**
     * The type of the hidden event handler&apos;s argument.
     */
    export type HiddenEvent = DevExpress.common.core.events.EventInfo<dxToast>;
    /**
     * The type of the hiding event handler&apos;s argument.
     */
    export type HidingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxToast>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxToast>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxToast> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxToastOptions;
    /**
     * The type of the showing event handler&apos;s argument.
     */
    export type ShowingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxToast>;
    /**
     * The type of the shown event handler&apos;s argument.
     */
    export type ShownEvent = DevExpress.common.core.events.EventInfo<dxToast>;
    export type ToastType = 'custom' | 'error' | 'info' | 'success' | 'warning';
  }
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxToastAnimation extends dxOverlayAnimation {
    /**
     * An object that defines the animation properties used when the UI component is being hidden.
     */
    hide?: DevExpress.common.core.animation.AnimationConfig;
    /**
     * An object that defines the animation properties used when the UI component is being shown.
     */
    show?: DevExpress.common.core.animation.AnimationConfig;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxToastOptions extends dxOverlayOptions<dxToast> {
    /**
     * Configures UI component visibility animations. This object contains two fields: show and hide.
     */
    animation?: dxToastAnimation;
    /**
     * A Boolean value specifying whether or not the toast is closed if a user clicks it.
     */
    closeOnClick?: boolean;
    /**
     * A Boolean value specifying whether or not the toast is closed if a user swipes it out of the screen boundaries.
     */
    closeOnSwipe?: boolean;
    /**
     * The time span in milliseconds during which the Toast UI component is visible.
     */
    displayTime?: number;
    /**
     * Specifies whether to hide the UI component if a user clicks outside it.
     */
    hideOnOutsideClick?:
      | boolean
      | ((
          event: DevExpress.events.DxEvent<DevExpress.events.PointerInteractionEvent>
        ) => boolean);
    /**
     * Specifies the UI component&apos;s height.
     */
    height?: number | string;
    /**
     * Specifies the maximum width the UI component can reach while resizing.
     */
    maxWidth?: number | string;
    /**
     * The Toast message text.
     */
    message?: string;
    /**
     * Specifies the minimum width the UI component can reach while resizing.
     */
    minWidth?: number | string;
    /**
     * Positions the UI component.
     */
    position?: DevExpress.common.core.animation.PositionConfig | string;
    /**
     * Specifies whether to shade the background when the UI component is active.
     */
    shading?: boolean;
    /**
     * Specifies the Toast UI component type.
     */
    type?: DevExpress.ui.dxToast.ToastType;
    /**
     * Specifies the UI component&apos;s width.
     */
    width?: number | string;
  }
  /**
   * The Toolbar is a UI component containing items that usually manage screen content. Those items can be plain text or UI components.
   */
  export class dxToolbar<
    TItem extends DevExpress.ui.dxToolbar.ItemLike = any,
    TKey = any
  > extends CollectionWidget<dxToolbarOptions<TItem, TKey>, TItem, TKey> {}
  module dxToolbar {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxToolbar<TItem, TKey>>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxToolbar<TItem, TKey>>;
    export type ExplicitTypes<TItem extends ItemLike, TKey> = {
      Properties: Properties<TItem, TKey>;
      ContentReadyEvent: ContentReadyEvent<TItem, TKey>;
      DisposingEvent: DisposingEvent<TItem, TKey>;
      InitializedEvent: InitializedEvent<TItem, TKey>;
      ItemClickEvent: ItemClickEvent<TItem, TKey>;
      ItemContextMenuEvent: ItemContextMenuEvent<TItem, TKey>;
      ItemHoldEvent: ItemHoldEvent<TItem, TKey>;
      ItemRenderedEvent: ItemRenderedEvent<TItem, TKey>;
      OptionChangedEvent: OptionChangedEvent<TItem, TKey>;
    };
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.InitializedEventInfo<
      dxToolbar<TItem, TKey>
    >;
    /**
     * The type of the itemClick event handler&apos;s argument.
     */
    export type ItemClickEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxToolbar<TItem, TKey>,
      MouseEvent | PointerEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemContextMenu event handler&apos;s argument.
     */
    export type ItemContextMenuEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxToolbar<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * The type of the itemHold event handler&apos;s argument.
     */
    export type ItemHoldEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.NativeEventInfo<
      dxToolbar<TItem, TKey>,
      DevExpress.events.PointerInteractionEvent
    > &
      DevExpress.common.core.events.ItemInfo<TItem>;
    /**
     * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
     */
    type ItemLike = string | Item | any;
    /**
     * The type of the itemRendered event handler&apos;s argument.
     */
    export type ItemRenderedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxToolbar<TItem, TKey>> &
      DevExpress.common.core.events.ItemInfo<TItem>;
    export type LocateInMenuMode = 'always' | 'auto' | 'never';
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent<
      TItem extends ItemLike = any,
      TKey = any
    > = DevExpress.common.core.events.EventInfo<dxToolbar<TItem, TKey>> &
      DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties<
      TItem extends ItemLike = any,
      TKey = any
    > = dxToolbarOptions<TItem, TKey>;
    export type ShowTextMode = 'always' | 'inMenu';
  }
  /**
   * @deprecated Use Item instead
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxToolbarItem extends CollectionWidgetItem {
    /**
     * Specifies a CSS class to be applied to the item.
     */
    cssClass?: string | undefined;
    /**
     * Specifies when to display an item in the toolbar&apos;s overflow menu.
     */
    locateInMenu?: DevExpress.ui.dxToolbar.LocateInMenuMode;
    /**
     * Specifies a location for the item on the toolbar.
     */
    location?: DevExpress.common.ToolbarItemLocation;
    /**
     * Specifies a template that should be used to render a menu item.
     */
    menuItemTemplate?:
      | template
      | (() => string | DevExpress.core.UserDefinedElement);
    /**
     * Configures the DevExtreme UI component used as a toolbar item.
     */
    options?: any;
    /**
     * Specifies when to display the text for the UI component item.
     */
    showText?: DevExpress.ui.dxToolbar.ShowTextMode;
    /**
     * A UI component that presents a toolbar item. To configure it, use the options object.
     */
    widget?: DevExpress.common.ToolbarItemComponent;
  }
  /**
   * 
   * @deprecated 
   */
  export interface dxToolbarOptions<
    TItem extends DevExpress.ui.dxToolbar.ItemLike = any,
    TKey = any
  > extends CollectionWidgetOptions<dxToolbar<TItem, TKey>, TItem, TKey> {
    /**
     * Binds the UI component to data.
     */
    dataSource?: DevExpress.data.DataSourceLike<TItem, TKey> | null;
    /**
     * An array of items displayed by the UI component.
     */
    items?: Array<TItem>;
    /**
     * Specifies whether or not the Toolbar arranges items into multiple lines when their combined width exceeds the Toolbar width.
     */
    multiline?: boolean;
    /**
     * Specifies a custom template for menu items.
     */
    menuItemTemplate?:
      | template
      | ((
          itemData: TItem,
          itemIndex: number,
          itemElement: DevExpress.core.DxElement
        ) => string | DevExpress.core.UserDefinedElement);
  }
  /**
   * The Tooltip UI component displays a tooltip for a specified element on the page.
   */
  export class dxTooltip extends dxPopover<dxTooltipOptions> {}
  module dxTooltip {
    /**
     * The type of the contentReady event handler&apos;s argument.
     */
    export type ContentReadyEvent =
      DevExpress.common.core.events.EventInfo<dxTooltip>;
    /**
     * The type of the disposing event handler&apos;s argument.
     */
    export type DisposingEvent =
      DevExpress.common.core.events.EventInfo<dxTooltip>;
    /**
     * The type of the hidden event handler&apos;s argument.
     */
    export type HiddenEvent =
      DevExpress.common.core.events.EventInfo<dxTooltip>;
    /**
     * The type of the hiding event handler&apos;s argument.
     */
    export type HidingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxTooltip>;
    /**
     * The type of the initialized event handler&apos;s argument.
     */
    export type InitializedEvent =
      DevExpress.common.core.events.InitializedEventInfo<dxTooltip>;
    /**
     * The type of the optionChanged event handler&apos;s argument.
     */
    export type OptionChangedEvent =
      DevExpress.common.core.events.EventInfo<dxTooltip> &
        DevExpress.common.core.events.ChangedOptionInfo;
    export type Properties = dxTooltipOptions;
    /**
     * The type of the showing event handler&apos;s argument.
     */
    export type ShowingEvent = DevExpress.common.core.events.Cancelable &
      DevExpress.common.core.events.EventInfo<dxTooltip>;
    /**
     * The type of the shown event handler&apos;s argument.
     */
    export type ShownEvent = DevExpress.common.core.events.EventInfo<dxTooltip>;
  }
  /**
   * 
   * @deprecated 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTooltipOptions extends dxPopoverOptions<dxTooltip> {}
  /**
   * A base class for track bar UI components.
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export class dxTrackBar<
    TProperties extends DevExpress.ui.Editor.EditorOptionsWithValue
  > extends Editor<TProperties> {}
  /**
   * 
   * @deprecated Attention! This type is for internal purposes only. If you used it previously, please submit a ticket to our {@link https://supportcenter.devexpress.com/ticket/create Support Center}. We will check if there is an alternative solution.
   */
  export interface dxTrackBarOptions<TComponent>
    extends EditorOptions<TComponent> {
    /**
     * The maximum value the UI component can accept.
     */
    max?: number;
    /**
     * The minimum value the UI component can accept.
     */
    min?: number;
  }
  /**
   * The TreeList is a UI component that represents data from a local or remote source in the form of a multi-column tree view. This UI component offers such features as sorting, filtering, editing, selection, etc.
   */
  export class dxTreeList<TRowData = any, TKey = any>
    extends Widget<dxTreeListOptions<TRowData, TKey>>
    implements DevExpress.common.grids.GridBase<TRowData, TKey>
  {
    /**
     * Adds a new column.
     */
    addColumn(
      columnOptions: DevExpress.ui.dxTreeList.Column<TRowData, TKey> | string
    ): void;
    /**
     * Adds an empty data row to the highest hierarchical level and switches