/*!
* DevExtreme (dx.messages.uk.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        uk: {
            Yes: "\u0422\u0430\u043a",
            No: "\u041d\u0456",
            Cancel: "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            CheckState: "\u041f\u0435\u0440\u0435\u0432\u0456\u0440\u0438\u0442\u0438 \u0441\u0442\u0430\u043d",
            Close: "\u0417\u0430\u043a\u0440\u0438\u0442\u0438",
            Clear: "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438",
            Done: "\u0413\u043e\u0442\u043e\u0432\u043e",
            Loading: "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f...",
            Select: "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c...",
            Search: "\u041f\u043e\u0448\u0443\u043a",
            Back: "\u041d\u0430\u0437\u0430\u0434",
            OK: "OK",
            Today: "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456",
            Yesterday: "\u0412\u0447\u043e\u0440\u0430",
            "dxCollectionWidget-noDataText": "\u041d\u0435\u043c\u0430\u0454 \u0434\u0430\u043d\u0438\u0445 \u0434\u043b\u044f \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDropDownEditor-selectLabel": "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c",
            "validation-required": "\u041e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0435 \u043f\u043e\u043b\u0435",
            "validation-required-formatted": "\u041f\u043e\u043b\u0435 {0} \u0454 \u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0438\u043c",
            "validation-numeric": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0447\u0438\u0441\u043b\u043e\u043c",
            "validation-numeric-formatted": "{0} \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0447\u0438\u0441\u043b\u043e\u043c",
            "validation-range": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043f\u043e\u0437\u0430 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u043c \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c",
            "validation-range-formatted": "{0} \u043f\u043e\u0437\u0430 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u043c \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c",
            "validation-stringLength": "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430 \u0434\u043e\u0432\u0436\u0438\u043d\u0430 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f",
            "validation-stringLength-formatted": "\u041d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430 \u0434\u043e\u0432\u0436\u0438\u043d\u0430 \u0434\u043b\u044f {0}",
            "validation-custom": "\u041d\u0435\u0434\u0456\u0439\u0441\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f",
            "validation-custom-formatted": "{0} \u0454 \u043d\u0435\u0434\u0456\u0439\u0441\u043d\u0438\u043c",
            "validation-async": "\u041d\u0435\u0434\u0456\u0439\u0441\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f",
            "validation-async-formatted": "{0} \u0454 \u043d\u0435\u0434\u0456\u0439\u0441\u043d\u0438\u043c",
            "validation-compare": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043d\u0435 \u0441\u043f\u0456\u0432\u043f\u0430\u0434\u0430\u044e\u0442\u044c",
            "validation-compare-formatted": "{0} \u043d\u0435 \u0441\u043f\u0456\u0432\u043f\u0430\u0434\u0430\u0454",
            "validation-pattern": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043d\u0435 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0454 \u0448\u0430\u0431\u043b\u043e\u043d\u0443",
            "validation-pattern-formatted": "{0} \u043d\u0435 \u0432\u0456\u0434\u043f\u043e\u0432\u0456\u0434\u0430\u0454 \u0448\u0430\u0431\u043b\u043e\u043d\u0443",
            "validation-email": "\u041d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u0430 \u0430\u0434\u0440\u0435\u0441\u0430 \u0435\u043b\u0435\u043a\u0442\u0440\u043e\u043d\u043d\u043e\u0457 \u043f\u043e\u0448\u0442\u0438",
            "validation-email-formatted": "{0} \u0454 \u043d\u0435\u043a\u043e\u0440\u0435\u043a\u0442\u043d\u043e\u044e \u0430\u0434\u0440\u0435\u0441\u043e\u044e",
            "validation-mask": "\u041d\u0435\u0434\u0456\u0439\u0441\u043d\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f",
            "dxLookup-searchPlaceholder": "\u041c\u0456\u043d\u0456\u043c\u0430\u043b\u044c\u043d\u0430 \u043a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c \u0441\u0438\u043c\u0432\u043e\u043b\u0456\u0432: {0}",
            "dxList-pullingDownText": "\u041f\u043e\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0432\u043d\u0438\u0437, \u0449\u043e\u0431 \u043e\u043d\u043e\u0432\u0438\u0442\u0438...",
            "dxList-pulledDownText": "\u0412\u0456\u0434\u043f\u0443\u0441\u0442\u0456\u0442\u044c, \u0449\u043e\u0431 \u043e\u043d\u043e\u0432\u0438\u0442\u0438...",
            "dxList-refreshingText": "\u041e\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f...",
            "dxList-pageLoadingText": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f...",
            "dxList-nextButtonText": "\u0429\u0435",
            "dxList-selectAll": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0435",
            "dxList-listAriaLabel": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442\u0438",
            "dxList-listAriaLabel-deletable": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442\u0438, \u044f\u043a\u0456 \u043c\u043e\u0436\u043d\u0430 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxListEditDecorator-delete": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxListEditDecorator-more": "\u0429\u0435",
            "dxList-selectAll-indeterminate": "\u0412\u0438\u0431\u0440\u0430\u043d\u043e \u0447\u0430\u0441\u0442\u043a\u043e\u0432\u043e",
            "dxList-selectAll-checked": "\u0412\u0438\u0431\u0440\u0430\u043d\u043e",
            "dxList-selectAll-notChecked": "\u041d\u0435 \u0432\u0438\u0431\u0440\u0430\u043d\u043e",
            "dxList-ariaRoleDescription": "\u0421\u043f\u0438\u0441\u043e\u043a",
            "dxList-listAriaLabel-itemContent": "\u0412\u043c\u0456\u0441\u0442 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0441\u043f\u0438\u0441\u043a\u0443",
            "dxScrollView-pullingDownText": "\u041f\u043e\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0432\u043d\u0438\u0437, \u0449\u043e\u0431 \u043e\u043d\u043e\u0432\u0438\u0442\u0438...",
            "dxScrollView-pulledDownText": "\u0412\u0456\u0434\u043f\u0443\u0441\u0442\u0456\u0442\u044c, \u0449\u043e\u0431 \u043e\u043d\u043e\u0432\u0438\u0442\u0438...",
            "dxScrollView-refreshingText": "\u041e\u043d\u043e\u0432\u043b\u0435\u043d\u043d\u044f...",
            "dxScrollView-reachBottomText": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f...",
            "dxDateBox-simulatedDataPickerTitleTime": "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c \u0447\u0430\u0441",
            "dxDateBox-simulatedDataPickerTitleDate": "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c \u0434\u0430\u0442\u0443",
            "dxDateBox-simulatedDataPickerTitleDateTime": "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c \u0434\u0430\u0442\u0443 \u0442\u0430 \u0447\u0430\u0441",
            "dxDateBox-validation-datetime": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0434\u0430\u0442\u043e\u044e, \u0430\u0431\u043e \u0447\u0430\u0441\u043e\u043c",
            "dxDateRangeBox-invalidStartDateMessage": "\u041f\u043e\u0447\u0430\u0442\u043a\u043e\u0432\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0434\u0430\u0442\u043e\u044e",
            "dxDateRangeBox-invalidEndDateMessage": "\u041a\u0456\u043d\u0446\u0435\u0432\u0435 \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0434\u0430\u0442\u043e\u044e",
            "dxDateRangeBox-startDateOutOfRangeMessage": "\u041f\u043e\u0447\u0430\u0442\u043a\u043e\u0432\u0430 \u0434\u0430\u0442\u0430 \u043f\u043e\u0437\u0430 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u043c \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c",
            "dxDateRangeBox-endDateOutOfRangeMessage": "\u041a\u0456\u043d\u0446\u0435\u0432\u0430 \u0434\u0430\u0442\u0430 \u043f\u043e\u0437\u0430 \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u043c \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d\u043e\u043c",
            "dxDateRangeBox-startDateLabel": "\u0414\u0430\u0442\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443",
            "dxDateRangeBox-endDateLabel": "\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f",
            "dxFileUploader-selectFile": "\u0412\u0438\u0431\u0435\u0440\u0456\u0442\u044c \u0444\u0430\u0439\u043b",
            "dxFileUploader-dropFile": "\u0430\u0431\u043e \u043f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u044e\u0434\u0438",
            "dxFileUploader-bytes": "\u0431\u0430\u0439\u0442",
            "dxFileUploader-kb": "\u041a\u0411",
            "dxFileUploader-Mb": "\u041c\u0411",
            "dxFileUploader-Gb": "\u0413\u0411",
            "dxFileUploader-upload": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0438\u0442\u0438",
            "dxFileUploader-uploaded": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e",
            "dxFileUploader-readyToUpload": "\u0413\u043e\u0442\u043e\u0432\u043e \u0434\u043e \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxFileUploader-uploadAbortedMessage": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f \u0441\u043a\u0430\u0441\u043e\u0432\u0430\u043d\u043e",
            "dxFileUploader-uploadFailedMessage": "\u041f\u043e\u043c\u0438\u043b\u043a\u0430 \u043f\u0456\u0434 \u0447\u0430\u0441 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxFileUploader-invalidFileExtension": "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u0439 \u0442\u0438\u043f \u0444\u0430\u0439\u043b\u0443",
            "dxFileUploader-invalidMaxFileSize": "\u0424\u0430\u0439\u043b \u0437\u0430\u0432\u0435\u043b\u0438\u043a\u0438\u0439",
            "dxFileUploader-invalidMinFileSize": "\u0424\u0430\u0439\u043b \u0437\u0430\u043c\u0430\u043b\u0438\u0439",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "\u0412\u0456\u0434",
            "dxRangeSlider-ariaTill": "\u0414\u043e",
            "dxSwitch-switchedOnText": "\u0423\u0412\u0406\u041c\u041a.",
            "dxSwitch-switchedOffText": "\u0412\u0418\u041c\u041a.",
            "dxForm-optionalMark": "\u043d\u0435\u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u043e",
            "dxForm-requiredMessage": "{0} \u2014 \u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u0435 \u043f\u043e\u043b\u0435",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "\u0421\u043a\u0438\u043d\u0443\u0442\u0438",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u0447\u0438\u0441\u043b\u043e\u043c",
            "dxNumberBox-noDataText": "\u041d\u0435\u043c\u0430\u0454 \u0434\u0430\u043d\u0438\u0445",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 {0}, \u0449\u043e\u0431 \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0437\u0438\u0442\u0438 \u0441\u0442\u043e\u0432\u043f\u0446\u0456",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0441\u044e\u0434\u0438 \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u0437 \u043f\u0430\u043d\u0435\u043b\u0456 \u0433\u0440\u0443\u043f\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 {0} \u0430\u0431\u043e \u043f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u0437 \u043f\u0430\u043d\u0435\u043b\u0456 \u0433\u0440\u0443\u043f\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-emptyHeaderColumnChooserText": "\u0432\u0438\u0431\u0456\u0440 \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432",
            "dxDataGrid-columnChooserTitle": "\u0412\u0438\u0431\u0456\u0440 \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432",
            "dxDataGrid-columnChooserEmptyText": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0441\u044e\u0434\u0438 \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c, \u0449\u043e\u0431 \u043f\u0440\u0438\u0445\u043e\u0432\u0430\u0442\u0438 \u0439\u043e\u0433\u043e",
            "dxDataGrid-groupContinuesMessage": "\u041f\u0440\u043e\u0434\u043e\u0432\u0436\u0435\u043d\u043d\u044f \u043d\u0430 \u043d\u0430\u0441\u0442\u0443\u043f\u043d\u0456\u0439 \u0441\u0442\u043e\u0440\u0456\u043d\u0446\u0456",
            "dxDataGrid-groupContinuedMessage": "\u041f\u0440\u043e\u0434\u043e\u0432\u0436\u0435\u043d\u043d\u044f \u0437 \u043f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u044c\u043e\u0457 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxDataGrid-groupHeaderText": "\u0413\u0440\u0443\u043f\u0443\u0432\u0430\u0442\u0438 \u0437\u0430 \u0446\u0438\u043c \u0441\u0442\u043e\u0432\u043f\u0446\u0435\u043c",
            "dxDataGrid-ungroupHeaderText": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0433\u0440\u0443\u043f\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-ungroupAllText": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0432\u0441\u0456 \u0433\u0440\u0443\u043f\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-editingEditRow": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438",
            "dxDataGrid-editingSaveRowChanges": "\u0417\u0431\u0435\u0440\u0435\u0433\u0442\u0438",
            "dxDataGrid-editingCancelRowChanges": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxDataGrid-editingDeleteRow": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxDataGrid-editingUndeleteRow": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f",
            "dxDataGrid-editingConfirmDeleteMessage": "\u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0446\u0435\u0439 \u0437\u0430\u043f\u0438\u0441?",
            "dxDataGrid-validationCancelChanges": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0437\u043c\u0456\u043d\u0438",
            "dxDataGrid-groupPanelEmptyText": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0441\u044e\u0434\u0438 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441\u0442\u043e\u0432\u043f\u0446\u044f \u0434\u043b\u044f \u0433\u0440\u0443\u043f\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-noDataText": "\u041d\u0435\u043c\u0430\u0454 \u0434\u0430\u043d\u0438\u0445",
            "dxDataGrid-searchPanelPlaceholder": "\u041f\u043e\u0448\u0443\u043a...",
            "dxDataGrid-filterRowShowAllText": "(\u0423\u0441\u0456)",
            "dxDataGrid-filterRowResetOperationText": "\u0421\u043a\u0438\u043d\u0443\u0442\u0438",
            "dxDataGrid-filterRowOperationEquals": "\u0414\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxDataGrid-filterRowOperationNotEquals": "\u041d\u0435 \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxDataGrid-filterRowOperationLess": "\u041c\u0435\u043d\u0448\u0435 \u043d\u0456\u0436",
            "dxDataGrid-filterRowOperationLessOrEquals": "\u041c\u0435\u043d\u0448\u0435 \u0430\u0431\u043e \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxDataGrid-filterRowOperationGreater": "\u0411\u0456\u043b\u044c\u0448\u0435 \u043d\u0456\u0436",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "\u0411\u0456\u043b\u044c\u0448\u0435 \u0430\u0431\u043e \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxDataGrid-filterRowOperationStartsWith": "\u041f\u043e\u0447\u0438\u043d\u0430\u0454\u0442\u044c\u0441\u044f \u0437",
            "dxDataGrid-filterRowOperationContains": "\u041c\u0456\u0441\u0442\u0438\u0442\u044c",
            "dxDataGrid-filterRowOperationNotContains": "\u041d\u0435 \u043c\u0456\u0441\u0442\u0438\u0442\u044c",
            "dxDataGrid-filterRowOperationEndsWith": "\u0417\u0430\u043a\u0456\u043d\u0447\u0443\u0454\u0442\u044c\u0441\u044f \u043d\u0430",
            "dxDataGrid-filterRowOperationBetween": "\u041c\u0456\u0436",
            "dxDataGrid-filterRowOperationBetweenStartText": "\u041f\u043e\u0447\u0430\u0442\u043e\u043a",
            "dxDataGrid-filterRowOperationBetweenEndText": "\u041a\u0456\u043d\u0435\u0446\u044c",
            "dxDataGrid-ariaSearchBox": "\u041f\u043e\u043b\u0435 \u043f\u043e\u0448\u0443\u043a\u0443",
            "dxDataGrid-applyFilterText": "\u0417\u0430\u0441\u0442\u043e\u0441\u0443\u0432\u0430\u0442\u0438 \u0444\u0456\u043b\u044c\u0442\u0440",
            "dxDataGrid-trueText": "\u0442\u0430\u043a",
            "dxDataGrid-falseText": "\u043d\u0456",
            "dxDataGrid-sortingAscendingText": "\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0437\u0430 \u0437\u0440\u043e\u0441\u0442\u0430\u043d\u043d\u044f\u043c",
            "dxDataGrid-sortingDescendingText": "\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0437\u0430 \u0441\u043f\u0430\u0434\u0430\u043d\u043d\u044f\u043c",
            "dxDataGrid-sortingClearText": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-ariaNotSortedColumn": "\u0421\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u0431\u0435\u0437 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-ariaSortedAscendingColumn": "\u0421\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u0432\u0456\u0434\u0441\u043e\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430 \u0437\u0440\u043e\u0441\u0442\u0430\u043d\u043d\u044f\u043c",
            "dxDataGrid-ariaSortedDescendingColumn": "\u0421\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u0432\u0456\u0434\u0441\u043e\u0440\u0442\u043e\u0432\u0430\u043d\u0438\u0439 \u0437\u0430 \u0441\u043f\u0430\u0434\u0430\u043d\u043d\u044f\u043c",
            "dxDataGrid-ariaSortIndex": "\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f {0}",
            "dxDataGrid-editingSaveAllChanges": "\u0417\u0431\u0435\u0440\u0435\u0433\u0442\u0438 \u0437\u043c\u0456\u043d\u0438",
            "dxDataGrid-editingCancelAllChanges": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0437\u043c\u0456\u043d\u0438",
            "dxDataGrid-editingAddRow": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043a",
            "dxDataGrid-summaryMin": "\u041c\u0456\u043d\u0456\u043c\u0443\u043c: {0}",
            "dxDataGrid-summaryMinOtherColumn": "\u041c\u0456\u043d\u0456\u043c\u0443\u043c \u0443 {1}: {0}",
            "dxDataGrid-summaryMax": "\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "\u041c\u0430\u043a\u0441\u0438\u043c\u0443\u043c \u0443 {1}: {0}",
            "dxDataGrid-summaryAvg": "\u0421\u0435\u0440\u0435\u0434\u043d\u0454: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "\u0421\u0435\u0440\u0435\u0434\u043d\u0454 \u043f\u043e {1}: {0}",
            "dxDataGrid-summarySum": "\u0421\u0443\u043c\u0430: {0}",
            "dxDataGrid-summarySumOtherColumn": "\u0421\u0443\u043c\u0430 \u043f\u043e {1}: {0}",
            "dxDataGrid-summaryCount": "\u041a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c: {0}",
            "dxDataGrid-columnFixingFix": "\u0417\u0430\u0444\u0456\u043a\u0441\u0443\u0432\u0430\u0442\u0438 \u043f\u043e\u0437\u0438\u0446\u0456\u044e",
            "dxDataGrid-columnFixingUnfix": "\u0417\u043d\u044f\u0442\u0438 \u0444\u0456\u043a\u0441\u0430\u0446\u0456\u044e",
            "dxDataGrid-columnFixingLeftPosition": "\u0417\u043b\u0456\u0432\u0430",
            "dxDataGrid-columnFixingRightPosition": "\u0421\u043f\u0440\u0430\u0432\u0430",
            "dxDataGrid-columnFixingStickyPosition": "\u041f\u0440\u0438\u043a\u0440\u0456\u043f\u043b\u0435\u043d\u043e",
            "dxDataGrid-exportTo": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438",
            "dxDataGrid-exportToExcel": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0443 \u0444\u0430\u0439\u043b Excel",
            "dxDataGrid-exporting": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f...",
            "dxDataGrid-excelFormat": "\u0424\u0430\u0439\u043b Excel",
            "dxDataGrid-selectedRows": "\u0412\u0438\u0431\u0440\u0430\u043d\u0456 \u0440\u044f\u0434\u043a\u0438",
            "dxDataGrid-exportSelectedRows": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0432\u0438\u0431\u0440\u0430\u043d\u0456 \u0440\u044f\u0434\u043a\u0438 \u0443 {0}",
            "dxDataGrid-exportAll": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0432\u0441\u0456 \u0434\u0430\u043d\u0456 \u0443 {0}",
            "dxDataGrid-headerFilterLabel": "\u041f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0438 \u0444\u0456\u043b\u044c\u0442\u0440\u0430",
            "dxDataGrid-headerFilterIndicatorLabel": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440\u0438 \u0444\u0456\u043b\u044c\u0442\u0440\u0430 \u0434\u043b\u044f \u0441\u0442\u043e\u0432\u043f\u0446\u044f \xab{0}\xbb",
            "dxDataGrid-headerFilterEmptyValue": "(\u041f\u043e\u0440\u043e\u0436\u043d\u044c\u043e)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxDataGrid-ariaAdaptiveCollapse": "\u0421\u0445\u043e\u0432\u0430\u0442\u0438 \u0434\u043e\u0434\u0430\u0442\u043a\u043e\u0432\u0456 \u0434\u0430\u043d\u0456",
            "dxDataGrid-ariaAdaptiveExpand": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u0434\u043e\u0434\u0430\u0442\u043a\u043e\u0432\u0456 \u0434\u0430\u043d\u0456",
            "dxDataGrid-ariaColumn": "\u0421\u0442\u043e\u0432\u043f\u0435\u0446\u044c",
            "dxDataGrid-ariaColumnHeader": "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441\u0442\u043e\u0432\u043f\u0446\u044f",
            "dxDataGrid-ariaValue": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f",
            "dxDataGrid-ariaError": "\u041f\u043e\u043c\u0438\u043b\u043a\u0430",
            "dxDataGrid-ariaRevertButton": "\u041d\u0430\u0442\u0438\u0441\u043d\u0456\u0442\u044c Escape, \u0449\u043e\u0431 \u0441\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0437\u043c\u0456\u043d\u0438",
            "dxDataGrid-ariaFilterCell": "\u041a\u043e\u043c\u0456\u0440\u043a\u0430 \u0444\u0456\u043b\u044c\u0442\u0440\u0430",
            "dxDataGrid-ariaCollapse": "\u0417\u0433\u043e\u0440\u043d\u0443\u0442\u0438",
            "dxDataGrid-ariaModifiedCell": "\u0417\u043c\u0456\u043d\u0435\u043d\u043e",
            "dxDataGrid-ariaDeletedCell": "\u0412\u0438\u0434\u0430\u043b\u0435\u043d\u043e",
            "dxDataGrid-ariaEditableCell": "\u0414\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0434\u043b\u044f \u0440\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-ariaExpand": "\u0420\u043e\u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438",
            "dxDataGrid-ariaCollapsedRow": "\u0417\u0433\u043e\u0440\u043d\u0443\u0442\u0438\u0439 \u0440\u044f\u0434\u043e\u043a",
            "dxDataGrid-ariaExpandedRow": "\u0420\u043e\u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438\u0439 \u0440\u044f\u0434\u043e\u043a",
            "dxDataGrid-ariaDataGrid": "\u0422\u0430\u0431\u043b\u0438\u0446\u044f \u0437 {0} \u0440\u044f\u0434\u043a\u0430\u043c\u0438 \u0442\u0430 {1} \u0441\u0442\u043e\u0432\u043f\u0446\u044f\u043c\u0438",
            "dxDataGrid-ariaSearchInGrid": "\u041f\u043e\u0448\u0443\u043a \u0443 \u0442\u0430\u0431\u043b\u0438\u0446\u0456",
            "dxDataGrid-ariaSelectAll": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0456",
            "dxDataGrid-ariaSelectRow": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043a",
            "dxDataGrid-ariaToolbar": "\u041f\u0430\u043d\u0435\u043b\u044c \u0456\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0456\u0432 \u0442\u0430\u0431\u043b\u0438\u0446\u0456",
            "dxDataGrid-ariaEditForm": "\u0424\u043e\u0440\u043c\u0430 \u0440\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDataGrid-filterBuilderPopupTitle": "\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u0444\u0456\u043b\u044c\u0442\u0440\u0456\u0432",
            "dxDataGrid-filterPanelCreateFilter": "\u0421\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u0444\u0456\u043b\u044c\u0442\u0440",
            "dxDataGrid-filterPanelClearFilter": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438",
            "dxDataGrid-filterPanelFilterEnabledHint": "\u0423\u0432\u0456\u043c\u043a\u043d\u0443\u0442\u0438 \u0444\u0456\u043b\u044c\u0442\u0440",
            "dxDataGrid-masterDetail": "\u041a\u043e\u043c\u0456\u0440\u043a\u0430 \u0437 \u0434\u0435\u0442\u0430\u043b\u044f\u043c\u0438",
            "dxDataGrid-moveColumnToTheRight": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0432\u043f\u0440\u0430\u0432\u043e",
            "dxDataGrid-moveColumnToTheLeft": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0432\u043b\u0456\u0432\u043e",
            "dxTreeList-ariaTreeList": "\u0414\u0435\u0440\u0435\u0432\u043e\u043f\u043e\u0434\u0456\u0431\u043d\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a \u0437 {0} \u0440\u044f\u0434\u043a\u0430\u043c\u0438 \u0456 {1} \u0441\u0442\u043e\u0432\u043f\u0446\u044f\u043c\u0438",
            "dxTreeList-ariaExpandableInstruction": "\u041d\u0430\u0442\u0438\u0441\u043d\u0456\u0442\u044c Ctrl + \u0441\u0442\u0440\u0456\u043b\u043a\u0443 \u0432\u043f\u0440\u0430\u0432\u043e, \u0449\u043e\u0431 \u0440\u043e\u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0432\u0443\u0437\u043e\u043b, \u0430\u0431\u043e Ctrl + \u0441\u0442\u0440\u0456\u043b\u043a\u0443 \u0432\u043b\u0456\u0432\u043e, \u0449\u043e\u0431 \u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0439\u043e\u0433\u043e",
            "dxTreeList-ariaSearchInGrid": "\u041f\u043e\u0448\u0443\u043a \u0443 \u0434\u0435\u0440\u0435\u0432\u0456",
            "dxTreeList-ariaToolbar": "\u041f\u0430\u043d\u0435\u043b\u044c \u0456\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u0435\u0440\u0435\u0432\u043e\u043f\u043e\u0434\u0456\u0431\u043d\u043e\u0433\u043e \u0441\u043f\u0438\u0441\u043a\u0443",
            "dxTreeList-editingAddRowToNode": "\u0414\u043e\u0434\u0430\u0442\u0438",
            "dxPager-infoText": "\u0421\u0442\u043e\u0440\u0456\u043d\u043a\u0430 {0} \u0437 {1} ({2} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432)",
            "dxPager-pagesCountText": "\u0437",
            "dxPager-pageSize": "\u041a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c \u043d\u0430 \u0441\u0442\u043e\u0440\u0456\u043d\u0446\u0456: {0}",
            "dxPager-pageSizesAllText": "\u0423\u0441\u0456",
            "dxPager-page": "\u0421\u0442\u043e\u0440\u0456\u043d\u043a\u0430 {0}",
            "dxPager-prevPage": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxPager-nextPage": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0430 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxPager-ariaLabel": "\u041d\u0430\u0432\u0456\u0433\u0430\u0446\u0456\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430\u043c\u0438",
            "dxPager-ariaPageSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxPager-ariaPageNumber": "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxPagination-infoText": "\u0421\u0442\u043e\u0440\u0456\u043d\u043a\u0430 {0} \u0437 {1} ({2} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432)",
            "dxPagination-pagesCountText": "\u0437",
            "dxPagination-pageSize": "\u041a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c \u043d\u0430 \u0441\u0442\u043e\u0440\u0456\u043d\u0446\u0456: {0}",
            "dxPagination-pageSizesAllText": "\u0423\u0441\u0456",
            "dxPagination-page": "\u0421\u0442\u043e\u0440\u0456\u043d\u043a\u0430 {0}",
            "dxPagination-prevPage": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxPagination-nextPage": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0430 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxPagination-ariaLabel": "\u041d\u0430\u0432\u0456\u0433\u0430\u0446\u0456\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430\u043c\u0438",
            "dxPagination-ariaPageSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxPagination-ariaPageNumber": "\u041d\u043e\u043c\u0435\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxPivotGrid-grandTotal": "\u0417\u0430\u0433\u0430\u043b\u043e\u043c",
            "dxPivotGrid-total": "\u0423\u0441\u044c\u043e\u0433\u043e \u043f\u043e {0}",
            "dxPivotGrid-fieldChooserTitle": "\u0412\u0438\u0431\u0456\u0440 \u043f\u043e\u043b\u0456\u0432",
            "dxPivotGrid-showFieldChooser": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u0432\u0438\u0431\u0456\u0440 \u043f\u043e\u043b\u0456\u0432",
            "dxPivotGrid-expandAll": "\u0420\u043e\u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0432\u0441\u0435",
            "dxPivotGrid-collapseAll": "\u0417\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0432\u0441\u0435",
            "dxPivotGrid-sortColumnBySummary": '\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 "{0}" \u0437\u0430 \u0446\u0438\u043c \u0441\u0442\u043e\u0432\u043f\u0446\u0435\u043c',
            "dxPivotGrid-sortRowBySummary": '\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 "{0}" \u0437\u0430 \u0446\u0438\u043c \u0440\u044f\u0434\u043a\u043e\u043c',
            "dxPivotGrid-removeAllSorting": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxPivotGrid-dataNotAvailable": "\u041d/\u0414",
            "dxPivotGrid-rowFields": "\u041f\u043e\u043b\u044f \u0440\u044f\u0434\u043a\u0456\u0432",
            "dxPivotGrid-columnFields": "\u041f\u043e\u043b\u044f \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432",
            "dxPivotGrid-dataFields": "\u041f\u043e\u043b\u044f \u0434\u0430\u043d\u0438\u0445",
            "dxPivotGrid-filterFields": "\u041f\u043e\u043b\u044f \u0444\u0456\u043b\u044c\u0442\u0440\u0430\u0446\u0456\u0457",
            "dxPivotGrid-allFields": "\u0423\u0441\u0456 \u043f\u043e\u043b\u044f",
            "dxPivotGrid-columnFieldArea": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u043f\u043e\u043b\u044f \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432 \u0441\u044e\u0434\u0438",
            "dxPivotGrid-dataFieldArea": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u043f\u043e\u043b\u044f \u0434\u0430\u043d\u0438\u0445 \u0441\u044e\u0434\u0438",
            "dxPivotGrid-rowFieldArea": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u043f\u043e\u043b\u044f \u0440\u044f\u0434\u043a\u0456\u0432 \u0441\u044e\u0434\u0438",
            "dxPivotGrid-filterFieldArea": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u043f\u043e\u043b\u044f \u0444\u0456\u043b\u044c\u0442\u0440\u0430\u0446\u0456\u0457 \u0441\u044e\u0434\u0438",
            "dxScheduler-dateRange": "\u0437 {0} \u043f\u043e {1}",
            "dxScheduler-ariaLabel": "\u041f\u043b\u0430\u043d\u0443\u0432\u0430\u043b\u044c\u043d\u0438\u043a. \u0412\u0438\u0434 {0}: {1}, \u043f\u043e\u0434\u0456\u0439: {2}",
            "dxScheduler-ariaLabel-currentIndicator-present": "\u0406\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043e\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u0447\u0430\u0441\u0443 \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0436\u0430\u0454\u0442\u044c\u0441\u044f \u0443 \u043f\u043e\u0434\u0430\u043d\u043d\u0456",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "\u0406\u043d\u0434\u0438\u043a\u0430\u0442\u043e\u0440 \u043f\u043e\u0442\u043e\u0447\u043d\u043e\u0433\u043e \u0447\u0430\u0441\u0443 \u043d\u0435 \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0436\u0430\u0454\u0442\u044c\u0441\u044f \u043d\u0430 \u0435\u043a\u0440\u0430\u043d\u0456",
            "dxScheduler-appointmentAriaLabel-group": "\u0413\u0440\u0443\u043f\u0430: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "\u041f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u043d\u0430 \u043f\u043e\u0434\u0456\u044f",
            "dxScheduler-appointmentListAriaLabel": "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u0434\u0456\u0439",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "\u0422\u0435\u043c\u0430",
            "dxScheduler-editorLabelStartDate": "\u0414\u0430\u0442\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443",
            "dxScheduler-editorLabelEndDate": "\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f",
            "dxScheduler-editorLabelDescription": "\u041e\u043f\u0438\u0441",
            "dxScheduler-editorLabelRecurrence": "\u041f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u043d\u044f",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456",
            "dxScheduler-navigationPrevious": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxScheduler-navigationNext": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0430 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxScheduler-openAppointment": "\u0412\u0456\u0434\u043a\u0440\u0438\u0442\u0438 \u043f\u043e\u0434\u0456\u044e",
            "dxScheduler-recurrenceNever": "\u041d\u0456\u043a\u043e\u043b\u0438",
            "dxScheduler-recurrenceMinutely": "\u0429\u043e\u0445\u0432\u0438\u043b\u0438\u043d\u0438",
            "dxScheduler-recurrenceHourly": "\u0429\u043e\u0433\u043e\u0434\u0438\u043d\u0438",
            "dxScheduler-recurrenceDaily": "\u0429\u043e\u0434\u043d\u044f",
            "dxScheduler-recurrenceWeekly": "\u0429\u043e\u0442\u0438\u0436\u043d\u044f",
            "dxScheduler-recurrenceMonthly": "\u0429\u043e\u043c\u0456\u0441\u044f\u0446\u044f",
            "dxScheduler-recurrenceYearly": "\u0429\u043e\u0440\u043e\u043a\u0443",
            "dxScheduler-recurrenceRepeatEvery": "\u041f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u0442\u0438 \u043a\u043e\u0436\u043d\u0456",
            "dxScheduler-recurrenceRepeatOn": "\u041f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u0442\u0438 \u0443",
            "dxScheduler-recurrenceEnd": "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u043d\u044f",
            "dxScheduler-recurrenceAfter": "\u041f\u0456\u0441\u043b\u044f",
            "dxScheduler-recurrenceOn": "\u0423",
            "dxScheduler-recurrenceUntilDateLabel": "\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u043d\u044f",
            "dxScheduler-recurrenceOccurrenceLabel": "\u041a\u0456\u043b\u044c\u043a\u0456\u0441\u0442\u044c \u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u044c",
            "dxScheduler-recurrenceRepeatMinutely": "\u0445\u0432\u0438\u043b\u0438\u043d\u0430(\u0438)",
            "dxScheduler-recurrenceRepeatHourly": "\u0433\u043e\u0434\u0438\u043d\u0430(\u0438)",
            "dxScheduler-recurrenceRepeatDaily": "\u0434\u0435\u043d\u044c(\u0434\u043d\u0456)",
            "dxScheduler-recurrenceRepeatWeekly": "\u0442\u0438\u0436\u0434\u0435\u043d\u044c(\u043d\u0456)",
            "dxScheduler-recurrenceRepeatMonthly": "\u043c\u0456\u0441\u044f\u0446\u044c(\u0456)",
            "dxScheduler-recurrenceRepeatYearly": "\u0440\u0456\u043a(\u0438)",
            "dxScheduler-switcherDay": "\u0414\u0435\u043d\u044c",
            "dxScheduler-switcherWeek": "\u0422\u0438\u0436\u0434\u0435\u043d\u044c",
            "dxScheduler-switcherWorkWeek": "\u0420\u043e\u0431\u043e\u0447\u0438\u0439 \u0442\u0438\u0436\u0434\u0435\u043d\u044c",
            "dxScheduler-switcherMonth": "\u041c\u0456\u0441\u044f\u0446\u044c",
            "dxScheduler-switcherAgenda": "\u041f\u043e\u0440\u044f\u0434\u043e\u043a \u0434\u0435\u043d\u043d\u0438\u0439",
            "dxScheduler-switcherTimelineDay": "\u0428\u043a\u0430\u043b\u0430 \u0447\u0430\u0441\u0443 (\u0434\u0435\u043d\u044c)",
            "dxScheduler-switcherTimelineWeek": "\u0428\u043a\u0430\u043b\u0430 \u0447\u0430\u0441\u0443 (\u0442\u0438\u0436\u0434\u0435\u043d\u044c)",
            "dxScheduler-switcherTimelineWorkWeek": "\u0428\u043a\u0430\u043b\u0430 \u0447\u0430\u0441\u0443 (\u0440\u043e\u0431\u043e\u0447\u0438\u0439 \u0442\u0438\u0436\u0434\u0435\u043d\u044c)",
            "dxScheduler-switcherTimelineMonth": "\u0428\u043a\u0430\u043b\u0430 \u0447\u0430\u0441\u0443 (\u043c\u0456\u0441\u044f\u0446\u044c)",
            "dxScheduler-recurrenceRepeatOnDate": "\u0443 \u0434\u0430\u0442\u0443",
            "dxScheduler-recurrenceRepeatCount": "\u043f\u043e\u0432\u0442\u043e\u0440\u0435\u043d\u044c",
            "dxScheduler-allDay": "\u0423\u0432\u0435\u0441\u044c \u0434\u0435\u043d\u044c",
            "dxScheduler-ariaEditForm": "\u0424\u043e\u0440\u043c\u0430 \u0440\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxScheduler-confirmRecurrenceEditTitle": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u043d\u043d\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u043d\u043e\u0457 \u043f\u043e\u0434\u0456\u0457",
            "dxScheduler-confirmRecurrenceDeleteTitle": "\u0412\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u043f\u043e\u0432\u0442\u043e\u0440\u044e\u0432\u0430\u043d\u043e\u0457 \u043f\u043e\u0434\u0456\u0457",
            "dxScheduler-confirmRecurrenceEditMessage": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438 \u043b\u0438\u0448\u0435 \u0446\u044e \u043f\u043e\u0434\u0456\u044e \u0447\u0438 \u0432\u0441\u044e \u0441\u0435\u0440\u0456\u044e?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u043b\u0438\u0448\u0435 \u0446\u044e \u043f\u043e\u0434\u0456\u044e \u0447\u0438 \u0432\u0441\u044e \u0441\u0435\u0440\u0456\u044e?",
            "dxScheduler-confirmRecurrenceEditSeries": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438 \u0441\u0435\u0440\u0456\u044e",
            "dxScheduler-confirmRecurrenceDeleteSeries": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0441\u0435\u0440\u0456\u044e",
            "dxScheduler-confirmRecurrenceEditOccurrence": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438 \u043f\u043e\u0434\u0456\u044e",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u043f\u043e\u0434\u0456\u044e",
            "dxScheduler-noTimezoneTitle": "\u0411\u0435\u0437 \u0447\u0430\u0441\u043e\u0432\u043e\u0433\u043e \u043f\u043e\u044f\u0441\u0443",
            "dxScheduler-moreAppointments": "\u0449\u0435 {0}",
            "dxCalendar-currentDay": "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456",
            "dxCalendar-currentMonth": "\u041f\u043e\u0442\u043e\u0447\u043d\u0438\u0439 \u043c\u0456\u0441\u044f\u0446\u044c",
            "dxCalendar-currentYear": "\u041f\u043e\u0442\u043e\u0447\u043d\u0438\u0439 \u0440\u0456\u043a",
            "dxCalendar-currentYearRange": "\u041f\u043e\u0442\u043e\u0447\u043d\u0438\u0439 \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d \u0440\u043e\u043a\u0456\u0432",
            "dxCalendar-todayButtonText": "\u0421\u044c\u043e\u0433\u043e\u0434\u043d\u0456",
            "dxCalendar-ariaWidgetName": "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440",
            "dxCalendar-previousMonthButtonLabel": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0456\u0439 \u043c\u0456\u0441\u044f\u0446\u044c",
            "dxCalendar-previousYearButtonLabel": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0456\u0439 \u0440\u0456\u043a",
            "dxCalendar-previousDecadeButtonLabel": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0454 \u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-previousCenturyButtonLabel": "\u041f\u043e\u043f\u0435\u0440\u0435\u0434\u043d\u0454 \u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-nextMonthButtonLabel": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0438\u0439 \u043c\u0456\u0441\u044f\u0446\u044c",
            "dxCalendar-nextYearButtonLabel": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0438\u0439 \u0440\u0456\u043a",
            "dxCalendar-nextDecadeButtonLabel": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0435 \u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-nextCenturyButtonLabel": "\u041d\u0430\u0441\u0442\u0443\u043f\u043d\u0435 \u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-captionMonthLabel": "\u0412\u0438\u0431\u0456\u0440 \u043c\u0456\u0441\u044f\u0446\u044f",
            "dxCalendar-captionYearLabel": "\u0412\u0438\u0431\u0456\u0440 \u0440\u043e\u043a\u0443",
            "dxCalendar-captionDecadeLabel": "\u0412\u0438\u0431\u0456\u0440 \u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-captionCenturyLabel": "\u0412\u0438\u0431\u0456\u0440 \u0441\u0442\u043e\u043b\u0456\u0442\u0442\u044f",
            "dxCalendar-selectedDate": "\u041e\u0431\u0440\u0430\u043d\u0430 \u0434\u0430\u0442\u0430: {0}",
            "dxCalendar-selectedDates": "\u041e\u0431\u0440\u0430\u043d\u0456 \u0434\u0430\u0442\u0438",
            "dxCalendar-selectedDateRange": "\u041e\u0431\u0440\u0430\u043d\u0438\u0439 \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d \u0434\u0430\u0442: \u0437 {0} \u043f\u043e {1}",
            "dxCalendar-selectedMultipleDateRange": "\u0437 {0} \u043f\u043e {1}",
            "dxCalendar-selectedDateRangeCount": "\u041e\u0431\u0440\u0430\u043d\u043e {0} \u0434\u0456\u0430\u043f\u0430\u0437\u043e\u043d(\u0456\u0432) \u0434\u0430\u0442",
            "dxCalendar-readOnlyLabel": "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440 \u043b\u0438\u0448\u0435 \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0433\u043b\u044f\u0434\u0443",
            "dxCardView-ariaSearchInGrid": "\u041f\u043e\u0448\u0443\u043a \u0443 \u043f\u043e\u0434\u0430\u043d\u043d\u0456 \u043a\u0430\u0440\u0442\u043e\u043a",
            "dxCardView-ariaHeaderItemLabel": "\u041d\u0430\u0437\u0432\u0430 \u043f\u043e\u043b\u044f: {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "\u0412\u0456\u0434\u0441\u043e\u0440\u0442\u043e\u0432\u0430\u043d\u043e \u0437\u0430 \u0437\u0440\u043e\u0441\u0442\u0430\u043d\u043d\u044f\u043c",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "\u0412\u0456\u0434\u0441\u043e\u0440\u0442\u043e\u0432\u0430\u043d\u043e \u0437\u0430 \u0441\u043f\u0430\u0434\u0430\u043d\u043d\u044f\u043c",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "\u0406\u043d\u0434\u0435\u043a\u0441 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f: {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "\u0417\u0430\u0441\u0442\u043e\u0441\u043e\u0432\u0430\u043d\u043e \u0444\u0456\u043b\u044c\u0442\u0440 \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430",
            "dxCardView-ariaSelectCard": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u043a\u0430\u0440\u0442\u043a\u0443",
            "dxCardView-ariaCardView": "\u041f\u043e\u0434\u0430\u043d\u043d\u044f \u0443 \u0432\u0438\u0433\u043b\u044f\u0434\u0456 \u043a\u0430\u0440\u0442\u043e\u043a \u0437 {0} \u043a\u0430\u0440\u0442\u043a\u0430\u043c\u0438. \u041a\u043e\u0436\u043d\u0430 \u043a\u0430\u0440\u0442\u043a\u0430 \u043c\u0456\u0441\u0442\u0438\u0442\u044c {1} \u043f\u043e\u043b\u0456\u0432",
            "dxCardView-ariaCard": "\u041a\u0430\u0440\u0442\u043a\u0430",
            "dxCardView-ariaEditableCard": "\u0420\u0435\u0434\u0430\u0433\u043e\u0432\u0430\u043d\u0430 \u043a\u0430\u0440\u0442\u043a\u0430",
            "dxCardView-ariaCardPosition": "\u0420\u044f\u0434\u043e\u043a {0}, \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c {1}",
            "dxCardView-ariaSelectedCardState": "\u0412\u0438\u0431\u0440\u0430\u043d\u043e",
            "dxCardView-ariaNotSelectedCardState": "\u041d\u0435 \u0432\u0438\u0431\u0440\u0430\u043d\u043e",
            "dxCardView-selectAll": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0435",
            "dxCardView-clearSelection": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u0432\u0438\u0431\u0456\u0440",
            "dxCardView-cardNoImageAriaLabel": "\u0417\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f \u0432\u0456\u0434\u0441\u0443\u0442\u043d\u0454",
            "dxCardView-headerItemDropZoneText": "\u041f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a \u0441\u044e\u0434\u0438",
            "dxCardView-emptyHeaderPanelText": "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 {0} \u0434\u043b\u044f \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432",
            "dxCardView-emptyHeaderPanelColumnChooserText": "\u0432\u0438\u0431\u0456\u0440 \u0441\u0442\u043e\u0432\u043f\u0446\u0456\u0432",
            "dxAvatar-defaultImageAlt": "\u0410\u0432\u0430\u0442\u0430\u0440",
            "dxChat-elementAriaLabel": "\u0427\u0430\u0442",
            "dxChat-textareaPlaceholder": "\u0412\u0432\u0435\u0434\u0456\u0442\u044c \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f",
            "dxChat-sendButtonAriaLabel": "\u041d\u0430\u0434\u0456\u0441\u043b\u0430\u0442\u0438",
            "dxChat-cancelEditingButtonAriaLabel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxChat-editingMessageCaption": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u043d\u043d\u044f \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f",
            "dxChat-defaultUserName": "\u041d\u0435\u0432\u0456\u0434\u043e\u043c\u0438\u0439 \u043a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0447",
            "dxChat-messageListAriaLabel": "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u044c",
            "dxChat-alertListAriaLabel": "\u0421\u043f\u0438\u0441\u043e\u043a \u043f\u043e\u043c\u0438\u043b\u043e\u043a",
            "dxChat-emptyListMessage": "\u0423 \u0446\u044c\u043e\u043c\u0443 \u0447\u0430\u0442\u0456 \u0449\u0435 \u043d\u0435\u043c\u0430\u0454 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u044c",
            "dxChat-emptyListPrompt": "\u041d\u0430\u043f\u0438\u0448\u0456\u0442\u044c \u043f\u0435\u0440\u0448\u0435 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f",
            "dxChat-typingMessageSingleUser": "{0} \u043d\u0430\u0431\u0438\u0440\u0430\u0454 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f...",
            "dxChat-typingMessageTwoUsers": "{0} \u0456 {1} \u043d\u0430\u0431\u0438\u0440\u0430\u044e\u0442\u044c \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} \u0442\u0430 {2} \u043d\u0430\u0431\u0438\u0440\u0430\u044e\u0442\u044c \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f...",
            "dxChat-typingMessageMultipleUsers": "{0} \u0442\u0430 \u0456\u043d\u0448\u0456 \u043d\u0430\u0431\u0438\u0440\u0430\u044e\u0442\u044c \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f...",
            "dxChat-editedMessageText": "\u0412\u0456\u0434\u0440\u0435\u0434\u0430\u0433\u043e\u0432\u0430\u043d\u043e",
            "dxChat-editingEditMessage": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438",
            "dxChat-editingDeleteMessage": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxChat-editingDeleteConfirmText": "\u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0446\u0435 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f?",
            "dxChat-deletedMessageText": "\u0426\u0435 \u043f\u043e\u0432\u0456\u0434\u043e\u043c\u043b\u0435\u043d\u043d\u044f \u0431\u0443\u043b\u043e \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e",
            "dxChat-defaultImageAlt": "\u0417\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f, \u043d\u0430\u0434\u0456\u0441\u043b\u0430\u043d\u0435 \u0432 \u0447\u0430\u0442\u0456",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "\u0427\u0435\u0440\u0432\u043e\u043d\u0438\u0439",
            "dxColorView-ariaGreen": "\u0417\u0435\u043b\u0435\u043d\u0438\u0439",
            "dxColorView-ariaBlue": "\u0421\u0438\u043d\u0456\u0439",
            "dxColorView-ariaAlpha": "\u041f\u0440\u043e\u0437\u043e\u0440\u0456\u0441\u0442\u044c",
            "dxColorView-ariaHex": "\u041a\u043e\u0434 \u043a\u043e\u043b\u044c\u043e\u0440\u0443",
            "dxTagBox-selected": "\u0412\u0438\u0431\u0440\u0430\u043d\u043e: {0}",
            "dxTagBox-allSelected": "\u0423\u0441\u0456 \u0432\u0438\u0431\u0440\u0430\u043d\u043e ({0})",
            "dxTagBox-moreSelected": "\u0429\u0435 {0}",
            "dxTagBox-tagRoleDescription": "\u041c\u0456\u0442\u043a\u0430. \u041d\u0430\u0442\u0438\u0441\u043d\u0456\u0442\u044c \u043a\u043d\u043e\u043f\u043a\u0443 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f, \u0449\u043e\u0431 \u043f\u0440\u0438\u0431\u0440\u0430\u0442\u0438 \u043c\u0456\u0442\u043a\u0443",
            "dxTagBox-ariaRoleDescription": "\u041f\u043e\u043b\u0435 \u0437 \u043c\u0456\u0442\u043a\u0430\u043c\u0438",
            "vizExport-printingButtonText": "\u0414\u0440\u0443\u043a\u0443\u0432\u0430\u0442\u0438",
            "vizExport-titleMenuText": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442/\u0414\u0440\u0443\u043a",
            "vizExport-exportButtonText": "\u0424\u0430\u0439\u043b {0}",
            "dxFilterBuilder-and": "\u0406",
            "dxFilterBuilder-or": "\u0410\u0431\u043e",
            "dxFilterBuilder-notAnd": "\u041d\u0435 \u0406",
            "dxFilterBuilder-notOr": "\u041d\u0435 \u0410\u0431\u043e",
            "dxFilterBuilder-addCondition": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0443\u043c\u043e\u0432\u0443",
            "dxFilterBuilder-addGroup": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0433\u0440\u0443\u043f\u0443",
            "dxFilterBuilder-enterValueText": "<\u0432\u0432\u0435\u0434\u0456\u0442\u044c \u0437\u043d\u0430\u0447\u0435\u043d\u043d\u044f>",
            "dxFilterBuilder-filterOperationEquals": "\u0414\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxFilterBuilder-filterOperationNotEquals": "\u041d\u0435 \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxFilterBuilder-filterOperationLess": "\u041c\u0435\u043d\u0448\u0435 \u043d\u0456\u0436",
            "dxFilterBuilder-filterOperationLessOrEquals": "\u041c\u0435\u043d\u0448\u0435 \u0430\u0431\u043e \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxFilterBuilder-filterOperationGreater": "\u0411\u0456\u043b\u044c\u0448\u0435 \u043d\u0456\u0436",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "\u0411\u0456\u043b\u044c\u0448\u0435 \u0430\u0431\u043e \u0434\u043e\u0440\u0456\u0432\u043d\u044e\u0454",
            "dxFilterBuilder-filterOperationStartsWith": "\u041f\u043e\u0447\u0438\u043d\u0430\u0454\u0442\u044c\u0441\u044f \u0437",
            "dxFilterBuilder-filterOperationContains": "\u041c\u0456\u0441\u0442\u0438\u0442\u044c",
            "dxFilterBuilder-filterOperationNotContains": "\u041d\u0435 \u043c\u0456\u0441\u0442\u0438\u0442\u044c",
            "dxFilterBuilder-filterOperationEndsWith": "\u0417\u0430\u043a\u0456\u043d\u0447\u0443\u0454\u0442\u044c\u0441\u044f \u043d\u0430",
            "dxFilterBuilder-filterOperationIsBlank": "\u041f\u043e\u0440\u043e\u0436\u043d\u0454",
            "dxFilterBuilder-filterOperationIsNotBlank": "\u041d\u0435 \u0454 \u043f\u043e\u0440\u043e\u0436\u043d\u0456\u043c",
            "dxFilterBuilder-filterOperationBetween": "\u041c\u0456\u0436",
            "dxFilterBuilder-filterOperationAnyOf": "\u041e\u0434\u0438\u043d \u0437",
            "dxFilterBuilder-filterOperationNoneOf": "\u0416\u043e\u0434\u0435\u043d \u0437",
            "dxFilterBuilder-filterAriaRootElement": "\u041a\u043e\u043d\u0441\u0442\u0440\u0443\u043a\u0442\u043e\u0440 \u0444\u0456\u043b\u044c\u0442\u0440\u0456\u0432",
            "dxFilterBuilder-filterAriaGroupLevel": "\u0420\u0456\u0432\u0435\u043d\u044c {0}",
            "dxFilterBuilder-filterAriaGroupItem": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u0433\u0440\u0443\u043f\u0438",
            "dxFilterBuilder-filterAriaOperationButton": "\u041e\u043f\u0435\u0440\u0430\u0446\u0456\u044f",
            "dxFilterBuilder-filterAriaAddButton": "\u0414\u043e\u0434\u0430\u0442\u0438",
            "dxFilterBuilder-filterAriaRemoveButton": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 {0}",
            "dxFilterBuilder-filterAriaItemField": "\u041f\u043e\u043b\u0435 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430",
            "dxFilterBuilder-filterAriaItemOperation": "\u041e\u043f\u0435\u0440\u0430\u0446\u0456\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430",
            "dxFilterBuilder-filterAriaItemValue": "\u0417\u043d\u0430\u0447\u0435\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430",
            "dxHtmlEditor-dialogColorCaption": "\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043a\u043e\u043b\u0456\u0440 \u0442\u0435\u043a\u0441\u0442\u0443",
            "dxHtmlEditor-dialogBackgroundCaption": "\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u043a\u043e\u043b\u0456\u0440 \u0444\u043e\u043d\u0443",
            "dxHtmlEditor-dialogLinkCaption": "\u0414\u043e\u0434\u0430\u0442\u0438 \u043f\u043e\u0441\u0438\u043b\u0430\u043d\u043d\u044f",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "\u0422\u0435\u043a\u0441\u0442",
            "dxHtmlEditor-dialogLinkTargetField": "\u0412\u0456\u0434\u043a\u0440\u0438\u0442\u0438 \u043f\u043e\u0441\u0438\u043b\u0430\u043d\u043d\u044f \u0432 \u043d\u043e\u0432\u043e\u043c\u0443 \u0432\u0456\u043a\u043d\u0456",
            "dxHtmlEditor-dialogImageCaption": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "\u0410\u043b\u044c\u0442\u0435\u0440\u043d\u0430\u0442\u0438\u0432\u043d\u0438\u0439 \u0442\u0435\u043a\u0441\u0442",
            "dxHtmlEditor-dialogImageWidthField": "\u0428\u0438\u0440\u0438\u043d\u0430 (\u043f\u0456\u043a\u0441)",
            "dxHtmlEditor-dialogImageHeightField": "\u0412\u0438\u0441\u043e\u0442\u0430 (\u043f\u0456\u043a\u0441)",
            "dxHtmlEditor-dialogInsertTableRowsField": "\u0420\u044f\u0434\u043a\u0438",
            "dxHtmlEditor-dialogInsertTableColumnsField": "\u0421\u0442\u043e\u0432\u043f\u0446\u0456",
            "dxHtmlEditor-dialogInsertTableCaption": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044e",
            "dxHtmlEditor-dialogUpdateImageCaption": "\u041e\u043d\u043e\u0432\u0438\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxHtmlEditor-dialogImageUpdateButton": "\u041e\u043d\u043e\u0432\u0438\u0442\u0438",
            "dxHtmlEditor-dialogImageAddButton": "\u0414\u043e\u0434\u0430\u0442\u0438",
            "dxHtmlEditor-dialogImageSpecifyUrl": "\u0417 \u0456\u043d\u0442\u0435\u0440\u043d\u0435\u0442\u0443",
            "dxHtmlEditor-dialogImageSelectFile": "\u0417 \u043f\u0440\u0438\u0441\u0442\u0440\u043e\u044e",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "\u0417\u0431\u0435\u0440\u0456\u0433\u0430\u0442\u0438 \u043f\u0440\u043e\u043f\u043e\u0440\u0446\u0456\u0457",
            "dxHtmlEditor-dialogImageEncodeToBase64": "\u041a\u043e\u0434\u0443\u0432\u0430\u0442\u0438 \u0432 Base64",
            "dxHtmlEditor-heading": "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a",
            "dxHtmlEditor-normalText": "\u0417\u0432\u0438\u0447\u0430\u0439\u043d\u0438\u0439 \u0442\u0435\u043a\u0441\u0442",
            "dxHtmlEditor-background": "\u041a\u043e\u043b\u0456\u0440 \u0444\u043e\u043d\u0443",
            "dxHtmlEditor-bold": "\u0416\u0438\u0440\u043d\u0438\u0439",
            "dxHtmlEditor-color": "\u041a\u043e\u043b\u0456\u0440 \u0442\u0435\u043a\u0441\u0442\u0443",
            "dxHtmlEditor-font": "\u0428\u0440\u0438\u0444\u0442",
            "dxHtmlEditor-italic": "\u041a\u0443\u0440\u0441\u0438\u0432",
            "dxHtmlEditor-link": "\u0414\u043e\u0434\u0430\u0442\u0438 \u043f\u043e\u0441\u0438\u043b\u0430\u043d\u043d\u044f",
            "dxHtmlEditor-image": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxHtmlEditor-size": "\u0420\u043e\u0437\u043c\u0456\u0440",
            "dxHtmlEditor-strike": "\u0417\u0430\u043a\u0440\u0435\u0441\u043b\u0435\u043d\u0438\u0439",
            "dxHtmlEditor-subscript": "\u041d\u0438\u0436\u043d\u0456\u0439 \u0456\u043d\u0434\u0435\u043a\u0441",
            "dxHtmlEditor-superscript": "\u0412\u0435\u0440\u0445\u043d\u0456\u0439 \u0456\u043d\u0434\u0435\u043a\u0441",
            "dxHtmlEditor-underline": "\u041f\u0456\u0434\u043a\u0440\u0435\u0441\u043b\u0435\u043d\u0438\u0439",
            "dxHtmlEditor-blockquote": "\u0426\u0438\u0442\u0430\u0442\u0430",
            "dxHtmlEditor-header": "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a",
            "dxHtmlEditor-increaseIndent": "\u0417\u0431\u0456\u043b\u044c\u0448\u0438\u0442\u0438 \u0432\u0456\u0434\u0441\u0442\u0443\u043f",
            "dxHtmlEditor-decreaseIndent": "\u0417\u043c\u0435\u043d\u0448\u0438\u0442\u0438 \u0432\u0456\u0434\u0441\u0442\u0443\u043f",
            "dxHtmlEditor-orderedList": "\u041d\u0443\u043c\u0435\u0440\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a",
            "dxHtmlEditor-bulletList": "\u041c\u0430\u0440\u043a\u043e\u0432\u0430\u043d\u0438\u0439 \u0441\u043f\u0438\u0441\u043e\u043a",
            "dxHtmlEditor-alignLeft": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u043b\u0456\u0432\u043e\u043c\u0443 \u043a\u0440\u0430\u044e",
            "dxHtmlEditor-alignCenter": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u0446\u0435\u043d\u0442\u0440\u0443",
            "dxHtmlEditor-alignRight": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u043f\u0440\u0430\u0432\u043e\u043c\u0443 \u043a\u0440\u0430\u044e",
            "dxHtmlEditor-alignJustify": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u0448\u0438\u0440\u0438\u043d\u0456",
            "dxHtmlEditor-codeBlock": "\u0411\u043b\u043e\u043a \u043a\u043e\u0434\u0443",
            "dxHtmlEditor-variable": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0437\u043c\u0456\u043d\u043d\u0443",
            "dxHtmlEditor-undo": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxHtmlEditor-redo": "\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0438",
            "dxHtmlEditor-clear": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0444\u043e\u0440\u043c\u0430\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxHtmlEditor-insertTable": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044e",
            "dxHtmlEditor-insertHeaderRow": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043a \u0437\u0430\u0433\u043e\u043b\u043e\u0432\u043a\u0430",
            "dxHtmlEditor-insertRowAbove": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043a \u0432\u0438\u0449\u0435",
            "dxHtmlEditor-insertRowBelow": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0440\u044f\u0434\u043e\u043a \u043d\u0438\u0436\u0447\u0435",
            "dxHtmlEditor-insertColumnLeft": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u043b\u0456\u0432\u043e\u0440\u0443\u0447",
            "dxHtmlEditor-insertColumnRight": "\u0414\u043e\u0434\u0430\u0442\u0438 \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c \u043f\u0440\u0430\u0432\u043e\u0440\u0443\u0447",
            "dxHtmlEditor-deleteColumn": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0441\u0442\u043e\u0432\u043f\u0435\u0446\u044c",
            "dxHtmlEditor-deleteRow": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0440\u044f\u0434\u043e\u043a",
            "dxHtmlEditor-deleteTable": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0442\u0430\u0431\u043b\u0438\u0446\u044e",
            "dxHtmlEditor-cellProperties": "\u0412\u043b\u0430\u0441\u0442\u0438\u0432\u043e\u0441\u0442\u0456 \u043a\u043e\u043c\u0456\u0440\u043a\u0438",
            "dxHtmlEditor-tableProperties": "\u0412\u043b\u0430\u0441\u0442\u0438\u0432\u043e\u0441\u0442\u0456 \u0442\u0430\u0431\u043b\u0438\u0446\u0456",
            "dxHtmlEditor-insert": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438",
            "dxHtmlEditor-delete": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxHtmlEditor-border": "\u0420\u0430\u043c\u043a\u0430",
            "dxHtmlEditor-style": "\u0421\u0442\u0438\u043b\u044c",
            "dxHtmlEditor-width": "\u0428\u0438\u0440\u0438\u043d\u0430",
            "dxHtmlEditor-height": "\u0412\u0438\u0441\u043e\u0442\u0430",
            "dxHtmlEditor-borderColor": "\u041a\u043e\u043b\u0456\u0440",
            "dxHtmlEditor-borderWidth": "\u0422\u043e\u0432\u0449\u0438\u043d\u0430 \u0440\u0430\u043c\u043a\u0438",
            "dxHtmlEditor-tableBackground": "\u0424\u043e\u043d \u0442\u0430\u0431\u043b\u0438\u0446\u0456",
            "dxHtmlEditor-dimensions": "\u0420\u043e\u0437\u043c\u0456\u0440\u0438",
            "dxHtmlEditor-alignment": "\u0412\u0438\u0440\u0456\u0432\u043d\u044e\u0432\u0430\u043d\u043d\u044f",
            "dxHtmlEditor-horizontal": "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0435",
            "dxHtmlEditor-vertical": "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u0435",
            "dxHtmlEditor-paddingVertical": "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u0456 \u0432\u0456\u0434\u0441\u0442\u0443\u043f\u0438",
            "dxHtmlEditor-paddingHorizontal": "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0456 \u0432\u0456\u0434\u0441\u0442\u0443\u043f\u0438",
            "dxHtmlEditor-pixels": "\u041f\u0456\u043a\u0441\u0435\u043b\u0456",
            "dxHtmlEditor-list": "\u0421\u043f\u0438\u0441\u043e\u043a",
            "dxHtmlEditor-ordered": "\u041d\u0443\u043c\u0435\u0440\u043e\u0432\u0430\u043d\u0438\u0439",
            "dxHtmlEditor-bullet": "\u041c\u0430\u0440\u043a\u043e\u0432\u0430\u043d\u0438\u0439",
            "dxHtmlEditor-align": "\u0412\u0438\u0440\u0456\u0432\u043d\u044e\u0432\u0430\u043d\u043d\u044f",
            "dxHtmlEditor-center": "\u041f\u043e \u0446\u0435\u043d\u0442\u0440\u0443",
            "dxHtmlEditor-left": "\u041b\u0456\u0432\u043e\u0440\u0443\u0447",
            "dxHtmlEditor-right": "\u041f\u0440\u0430\u0432\u043e\u0440\u0443\u0447",
            "dxHtmlEditor-indent": "\u0412\u0456\u0434\u0441\u0442\u0443\u043f",
            "dxHtmlEditor-justify": "\u041f\u043e \u0448\u0438\u0440\u0438\u043d\u0456",
            "dxHtmlEditor-borderStyleNone": "\u043d\u0435\u043c\u0430\u0454",
            "dxHtmlEditor-borderStyleHidden": "\u043f\u0440\u0438\u0445\u043e\u0432\u0430\u043d\u043e",
            "dxHtmlEditor-borderStyleDotted": "\u043f\u0443\u043d\u043a\u0442\u0438\u0440\u043d\u0430",
            "dxHtmlEditor-borderStyleDashed": "\u0448\u0442\u0440\u0438\u0445\u043e\u0432\u0430",
            "dxHtmlEditor-borderStyleSolid": "\u0441\u0443\u0446\u0456\u043b\u044c\u043d\u0430",
            "dxHtmlEditor-borderStyleDouble": "\u043f\u043e\u0434\u0432\u0456\u0439\u043d\u0430",
            "dxHtmlEditor-borderStyleGroove": "\u0431\u043e\u0440\u043e\u0437\u043d\u0430",
            "dxHtmlEditor-borderStyleRidge": "\u0433\u0440\u0435\u0431\u0456\u043d\u044c",
            "dxHtmlEditor-borderStyleInset": "\u0432\u0442\u0438\u0441\u043d\u0443\u0442\u0430",
            "dxHtmlEditor-borderStyleOutset": "\u0432\u0438\u043f\u0443\u043a\u043b\u0430",
            "dxHtmlEditor-aiDialogTitle": "AI \u0410\u0441\u0438\u0441\u0442\u0435\u043d\u0442",
            "dxHtmlEditor-aiDialogError": "\u0429\u043e\u0441\u044c \u043f\u0456\u0448\u043b\u043e \u043d\u0435 \u0442\u0430\u043a. \u0421\u043f\u0440\u043e\u0431\u0443\u0439\u0442\u0435 \u0449\u0435 \u0440\u0430\u0437.",
            "dxHtmlEditor-aiDialogCanceled": "\u0413\u0435\u043d\u0435\u0440\u0430\u0446\u0456\u044e \u0441\u043a\u0430\u0441\u043e\u0432\u0430\u043d\u043e",
            "dxHtmlEditor-aiReplace": "\u0417\u0430\u043c\u0456\u043d\u0438\u0442\u0438",
            "dxHtmlEditor-aiInsertAbove": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0432\u0438\u0449\u0435",
            "dxHtmlEditor-aiInsertBelow": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u043d\u0438\u0436\u0447\u0435",
            "dxHtmlEditor-aiCopy": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u0442\u0438",
            "dxHtmlEditor-aiRegenerate": "\u0417\u0433\u0435\u043d\u0435\u0440\u0443\u0432\u0430\u0442\u0438 \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e",
            "dxHtmlEditor-aiGenerate": "\u0417\u0433\u0435\u043d\u0435\u0440\u0443\u0432\u0430\u0442\u0438",
            "dxHtmlEditor-aiCancel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "\u041f\u0443\u043d\u043a\u0442 \u043f\u0430\u043d\u0435\u043b\u0456 \u0456\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0456\u0432 AI \u0410\u0441\u0438\u0441\u0442\u0435\u043d\u0442\u0430",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "\u0420\u0435\u0437\u0443\u043b\u044c\u0442\u0430\u0442 AI \u0410\u0441\u0438\u0441\u0442\u0435\u043d\u0442\u0430",
            "dxHtmlEditor-aiAskPlaceholder": "\u041f\u043e\u043f\u0440\u043e\u0441\u0456\u0442\u044c AI \u0437\u043c\u0456\u043d\u0438\u0442\u0438 \u0442\u0435\u043a\u0441\u0442",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "\u0411\u0435\u0437 \u043d\u0430\u0437\u0432\u0438",
            "dxFileManager-rootDirectoryName": "\u0424\u0430\u0439\u043b\u0438",
            "dxFileManager-errorNoAccess": "\u0414\u043e\u0441\u0442\u0443\u043f \u0437\u0430\u0431\u043e\u0440\u043e\u043d\u0435\u043d\u043e. \u041e\u043f\u0435\u0440\u0430\u0446\u0456\u044e \u043d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044f \u0437\u0430\u0432\u0435\u0440\u0448\u0438\u0442\u0438.",
            "dxFileManager-errorDirectoryExistsFormat": "\u041f\u0430\u043f\u043a\u0430 \xab{0}\xbb \u0432\u0436\u0435 \u0456\u0441\u043d\u0443\u0454.",
            "dxFileManager-errorFileExistsFormat": "\u0424\u0430\u0439\u043b \xab{0}\xbb \u0432\u0436\u0435 \u0456\u0441\u043d\u0443\u0454.",
            "dxFileManager-errorFileNotFoundFormat": "\u0424\u0430\u0439\u043b \xab{0}\xbb \u043d\u0435 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e.",
            "dxFileManager-errorDirectoryNotFoundFormat": "\u041f\u0430\u043f\u043a\u0443 \xab{0}\xbb \u043d\u0435 \u0437\u043d\u0430\u0439\u0434\u0435\u043d\u043e.",
            "dxFileManager-errorWrongFileExtension": "\u041d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0435 \u0440\u043e\u0437\u0448\u0438\u0440\u0435\u043d\u043d\u044f \u0444\u0430\u0439\u043b\u0443.",
            "dxFileManager-errorMaxFileSizeExceeded": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0444\u0430\u0439\u043b\u0443 \u043f\u0435\u0440\u0435\u0432\u0438\u0449\u0443\u0454 \u043c\u0430\u043a\u0441\u0438\u043c\u0430\u043b\u044c\u043d\u043e \u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0438\u0439.",
            "dxFileManager-errorInvalidSymbols": "\u041d\u0430\u0437\u0432\u0430 \u043c\u0456\u0441\u0442\u0438\u0442\u044c \u043d\u0435\u0434\u043e\u043f\u0443\u0441\u0442\u0438\u043c\u0456 \u0441\u0438\u043c\u0432\u043e\u043b\u0438.",
            "dxFileManager-errorDefault": "\u041d\u0435\u0432\u0438\u0437\u043d\u0430\u0447\u0435\u043d\u0430 \u043f\u043e\u043c\u0438\u043b\u043a\u0430.",
            "dxFileManager-errorDirectoryOpenFailed": "\u041d\u0435\u043c\u043e\u0436\u043b\u0438\u0432\u043e \u0432\u0456\u0434\u043a\u0440\u0438\u0442\u0438 \u043f\u0430\u043f\u043a\u0443.",
            "dxFileManager-commandCreate": "\u0421\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u043f\u0430\u043f\u043a\u0443",
            "dxFileManager-commandRename": "\u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u0443\u0432\u0430\u0442\u0438",
            "dxFileManager-commandMove": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0434\u043e",
            "dxFileManager-commandCopy": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u0442\u0438 \u0434\u043e",
            "dxFileManager-commandDelete": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxFileManager-commandDownload": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0438\u0442\u0438",
            "dxFileManager-commandUpload": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0438\u0442\u0438 \u0444\u0430\u0439\u043b\u0438",
            "dxFileManager-commandRefresh": "\u041e\u043d\u043e\u0432\u0438\u0442\u0438",
            "dxFileManager-commandThumbnails": "\u041f\u0435\u0440\u0435\u0433\u043b\u044f\u0434 \u0435\u0441\u043a\u0456\u0437\u0456\u0432",
            "dxFileManager-commandDetails": "\u041f\u0435\u0440\u0435\u0433\u043b\u044f\u0434 \u0434\u0435\u0442\u0430\u043b\u0435\u0439",
            "dxFileManager-commandClearSelection": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0432\u0438\u0431\u0456\u0440",
            "dxFileManager-commandShowNavPane": "\u041f\u0435\u0440\u0435\u043c\u043a\u043d\u0443\u0442\u0438 \u043d\u0430\u0432\u0456\u0433\u0430\u0446\u0456\u0439\u043d\u0443 \u043f\u0430\u043d\u0435\u043b\u044c",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0434\u043e",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u0442\u0438 \u0434\u043e",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u0442\u0438",
            "dxFileManager-dialogRenameItemTitle": "\u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u0443\u0432\u0430\u0442\u0438",
            "dxFileManager-dialogRenameItemButtonText": "\u0417\u0431\u0435\u0440\u0435\u0433\u0442\u0438",
            "dxFileManager-dialogCreateDirectoryTitle": "\u041d\u043e\u0432\u0430 \u043f\u0430\u043f\u043a\u0430",
            "dxFileManager-dialogCreateDirectoryButtonText": "\u0421\u0442\u0432\u043e\u0440\u0438\u0442\u0438",
            "dxFileManager-dialogDeleteItemTitle": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxFileManager-dialogDeleteItemButtonText": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "\u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "\u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432?",
            "dxFileManager-dialogButtonCancel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "\u0421\u0442\u0432\u043e\u0440\u0435\u043d\u043d\u044f \u043f\u0430\u043f\u043a\u0438 \u0432 {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "\u041f\u0430\u043f\u043a\u0443 \u0441\u0442\u0432\u043e\u0440\u0435\u043d\u043e \u0432 {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "\u041d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044f \u0441\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u043f\u0430\u043f\u043a\u0443",
            "dxFileManager-editingCreateCommonErrorMessage": "\u041d\u0435 \u0432\u0434\u0430\u043b\u043e\u0441\u044f \u0441\u0442\u0432\u043e\u0440\u0438\u0442\u0438 \u043f\u0430\u043f\u043a\u0443",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "\u041f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u0443\u0432\u0430\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0432 {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043e \u0432 {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingRenameCommonErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0435\u0440\u0435\u0439\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "\u0412\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0437 {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "\u0412\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0437 {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e \u0437 {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "\u0412\u0438\u0434\u0430\u043b\u0435\u043d\u043e {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0437 {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u043d\u0435 \u0431\u0443\u043b\u043e \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e",
            "dxFileManager-editingDeleteCommonErrorMessage": "\u0414\u0435\u044f\u043a\u0456 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0438 \u043d\u0435 \u0431\u0443\u043b\u043e \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "\u041f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043e {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "\u041f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043d\u044f {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043e \u0434\u043e {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "\u041f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043e {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u043f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043e",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u043d\u0435 \u043f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043e",
            "dxFileManager-editingMoveCommonErrorMessage": "\u0414\u0435\u044f\u043a\u0456 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0438 \u043d\u0435 \u0431\u0443\u043b\u043e \u043f\u0435\u0440\u0435\u043c\u0456\u0449\u0435\u043d\u043e",
            "dxFileManager-editingCopySingleItemProcessingMessage": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043e {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u043d\u043d\u044f {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u0441\u043a\u043e\u043f\u0456\u0439\u043e\u0432\u0430\u043d\u043e \u0434\u043e {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "\u0421\u043a\u043e\u043f\u0456\u0439\u043e\u0432\u0430\u043d\u043e {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0441\u043a\u043e\u043f\u0456\u0439\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u043d\u0435 \u0441\u043a\u043e\u043f\u0456\u0439\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingCopyCommonErrorMessage": "\u0414\u0435\u044f\u043a\u0456 \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0438 \u043d\u0435 \u0431\u0443\u043b\u043e \u0441\u043a\u043e\u043f\u0456\u0439\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0430 \u0434\u043e {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043d\u044f {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e \u0434\u043e {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "\u0417\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e {0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u0434\u043e {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u043d\u0435 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e",
            "dxFileManager-editingUploadCanceledMessage": "\u0421\u043a\u0430\u0441\u043e\u0432\u0430\u043d\u043e",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u043d\u0435 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} \u0435\u043b\u0435\u043c\u0435\u043d\u0442\u0456\u0432 \u043d\u0435 \u0437\u0430\u0432\u0430\u043d\u0442\u0430\u0436\u0435\u043d\u043e",
            "dxFileManager-listDetailsColumnCaptionName": "\u041d\u0430\u0437\u0432\u0430",
            "dxFileManager-listDetailsColumnCaptionDateModified": "\u0414\u0430\u0442\u0430 \u0437\u043c\u0456\u043d\u0438",
            "dxFileManager-listDetailsColumnCaptionFileSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0444\u0430\u0439\u043b\u0443",
            "dxFileManager-listThumbnailsTooltipTextSize": "\u0420\u043e\u0437\u043c\u0456\u0440",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "\u0414\u0430\u0442\u0430 \u0437\u043c\u0456\u043d\u0438",
            "dxFileManager-notificationProgressPanelTitle": "\u041f\u0440\u043e\u0433\u0440\u0435\u0441",
            "dxFileManager-notificationProgressPanelEmptyListText": "\u041d\u0435\u043c\u0430\u0454 \u043e\u043f\u0435\u0440\u0430\u0446\u0456\u0439",
            "dxFileManager-notificationProgressPanelOperationCanceled": "\u0421\u043a\u0430\u0441\u043e\u0432\u0430\u043d\u043e",
            "dxDiagram-categoryGeneral": "\u0417\u0430\u0433\u0430\u043b\u044c\u043d\u0456",
            "dxDiagram-categoryFlowchart": "\u0411\u043b\u043e\u043a-\u0441\u0445\u0435\u043c\u0430",
            "dxDiagram-categoryOrgChart": "\u041e\u0440\u0433\u0441\u0442\u0440\u0443\u043a\u0442\u0443\u0440\u0430",
            "dxDiagram-categoryContainers": "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440\u0438",
            "dxDiagram-categoryCustom": "\u041a\u043e\u0440\u0438\u0441\u0442\u0443\u0432\u0430\u0446\u044c\u043a\u0456",
            "dxDiagram-commandExportToSvg": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0432 SVG",
            "dxDiagram-commandExportToPng": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0432 PNG",
            "dxDiagram-commandExportToJpg": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0432 JPEG",
            "dxDiagram-commandUndo": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxDiagram-commandRedo": "\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0438",
            "dxDiagram-commandFontName": "\u0428\u0440\u0438\u0444\u0442",
            "dxDiagram-commandFontSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0448\u0440\u0438\u0444\u0442\u0443",
            "dxDiagram-commandBold": "\u0416\u0438\u0440\u043d\u0438\u0439",
            "dxDiagram-commandItalic": "\u041a\u0443\u0440\u0441\u0438\u0432",
            "dxDiagram-commandUnderline": "\u041f\u0456\u0434\u043a\u0440\u0435\u0441\u043b\u0435\u043d\u0438\u0439",
            "dxDiagram-commandTextColor": "\u041a\u043e\u043b\u0456\u0440 \u0442\u0435\u043a\u0441\u0442\u0443",
            "dxDiagram-commandLineColor": "\u041a\u043e\u043b\u0456\u0440 \u043b\u0456\u043d\u0456\u0457",
            "dxDiagram-commandLineWidth": "\u0422\u043e\u0432\u0449\u0438\u043d\u0430 \u043b\u0456\u043d\u0456\u0457",
            "dxDiagram-commandLineStyle": "\u0421\u0442\u0438\u043b\u044c \u043b\u0456\u043d\u0456\u0457",
            "dxDiagram-commandLineStyleSolid": "\u0421\u0443\u0446\u0456\u043b\u044c\u043d\u0430",
            "dxDiagram-commandLineStyleDotted": "\u041f\u0443\u043d\u043a\u0442\u0438\u0440\u043d\u0430",
            "dxDiagram-commandLineStyleDashed": "\u0428\u0442\u0440\u0438\u0445\u043e\u0432\u0430",
            "dxDiagram-commandFillColor": "\u041a\u043e\u043b\u0456\u0440 \u0437\u0430\u043b\u0438\u0432\u043a\u0438",
            "dxDiagram-commandAlignLeft": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u043b\u0456\u0432\u043e\u043c\u0443 \u043a\u0440\u0430\u044e",
            "dxDiagram-commandAlignCenter": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u0446\u0435\u043d\u0442\u0440\u0443",
            "dxDiagram-commandAlignRight": "\u0412\u0438\u0440\u0456\u0432\u043d\u044f\u0442\u0438 \u043f\u043e \u043f\u0440\u0430\u0432\u043e\u043c\u0443 \u043a\u0440\u0430\u044e",
            "dxDiagram-commandConnectorLineType": "\u0422\u0438\u043f \u0437'\u0454\u0434\u043d\u0443\u0432\u0430\u043b\u044c\u043d\u043e\u0457 \u043b\u0456\u043d\u0456\u0457",
            "dxDiagram-commandConnectorLineStraight": "\u041f\u0440\u044f\u043c\u0430",
            "dxDiagram-commandConnectorLineOrthogonal": "\u041e\u0440\u0442\u043e\u0433\u043e\u043d\u0430\u043b\u044c\u043d\u0430",
            "dxDiagram-commandConnectorLineStart": "\u041f\u043e\u0447\u0430\u0442\u043e\u043a \u0437'\u0454\u0434\u043d\u0430\u043d\u043d\u044f",
            "dxDiagram-commandConnectorLineEnd": "\u041a\u0456\u043d\u0435\u0446\u044c \u0437'\u0454\u0434\u043d\u0430\u043d\u043d\u044f",
            "dxDiagram-commandConnectorLineNone": "\u041d\u0435\u043c\u0430\u0454",
            "dxDiagram-commandConnectorLineArrow": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430",
            "dxDiagram-commandFullscreen": "\u041d\u0430 \u0432\u0435\u0441\u044c \u0435\u043a\u0440\u0430\u043d",
            "dxDiagram-commandUnits": "\u041e\u0434\u0438\u043d\u0438\u0446\u0456 \u0432\u0438\u043c\u0456\u0440\u0443",
            "dxDiagram-commandPageSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxDiagram-commandPageOrientation": "\u041e\u0440\u0456\u0454\u043d\u0442\u0430\u0446\u0456\u044f \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxDiagram-commandPageOrientationLandscape": "\u0410\u043b\u044c\u0431\u043e\u043c\u043d\u0430",
            "dxDiagram-commandPageOrientationPortrait": "\u041a\u043d\u0438\u0436\u043a\u043e\u0432\u0430",
            "dxDiagram-commandPageColor": "\u041a\u043e\u043b\u0456\u0440 \u0441\u0442\u043e\u0440\u0456\u043d\u043a\u0438",
            "dxDiagram-commandShowGrid": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u0441\u0456\u0442\u043a\u0443",
            "dxDiagram-commandSnapToGrid": "\u041f\u0440\u0438\u0432'\u044f\u0437\u043a\u0430 \u0434\u043e \u0441\u0456\u0442\u043a\u0438",
            "dxDiagram-commandGridSize": "\u0420\u043e\u0437\u043c\u0456\u0440 \u0441\u0456\u0442\u043a\u0438",
            "dxDiagram-commandZoomLevel": "\u041c\u0430\u0441\u0448\u0442\u0430\u0431",
            "dxDiagram-commandAutoZoom": "\u0410\u0432\u0442\u043e\u043c\u0430\u0441\u0448\u0442\u0430\u0431",
            "dxDiagram-commandFitToContent": "\u041c\u0430\u0441\u0448\u0442\u0430\u0431 \u0437\u0430 \u0432\u043c\u0456\u0441\u0442\u043e\u043c",
            "dxDiagram-commandFitToWidth": "\u041c\u0430\u0441\u0448\u0442\u0430\u0431 \u0437\u0430 \u0448\u0438\u0440\u0438\u043d\u043e\u044e",
            "dxDiagram-commandAutoZoomByContent": "\u0410\u0432\u0442\u043e\u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u0437\u0430 \u0432\u043c\u0456\u0441\u0442\u043e\u043c",
            "dxDiagram-commandAutoZoomByWidth": "\u0410\u0432\u0442\u043e\u043c\u0430\u0441\u0448\u0442\u0430\u0431 \u0437\u0430 \u0448\u0438\u0440\u0438\u043d\u043e\u044e",
            "dxDiagram-commandSimpleView": "\u0421\u043f\u0440\u043e\u0449\u0435\u043d\u0435 \u0432\u0456\u0434\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDiagram-commandCut": "\u0412\u0438\u0440\u0456\u0437\u0430\u0442\u0438",
            "dxDiagram-commandCopy": "\u041a\u043e\u043f\u0456\u044e\u0432\u0430\u0442\u0438",
            "dxDiagram-commandPaste": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438",
            "dxDiagram-commandSelectAll": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0432\u0441\u0435",
            "dxDiagram-commandDelete": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438",
            "dxDiagram-commandBringToFront": "\u041d\u0430 \u043f\u0435\u0440\u0435\u0434\u043d\u0456\u0439 \u043f\u043b\u0430\u043d",
            "dxDiagram-commandSendToBack": "\u041d\u0430 \u0437\u0430\u0434\u043d\u0456\u0439 \u043f\u043b\u0430\u043d",
            "dxDiagram-commandLock": "\u0417\u0430\u0431\u043b\u043e\u043a\u0443\u0432\u0430\u0442\u0438",
            "dxDiagram-commandUnlock": "\u0420\u043e\u0437\u0431\u043b\u043e\u043a\u0443\u0432\u0430\u0442\u0438",
            "dxDiagram-commandInsertShapeImage": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f...",
            "dxDiagram-commandEditShapeImage": "\u0417\u043c\u0456\u043d\u0438\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f...",
            "dxDiagram-commandDeleteShapeImage": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDiagram-commandLayoutLeftToRight": "\u0417\u043b\u0456\u0432\u0430 \u043d\u0430\u043f\u0440\u0430\u0432\u043e",
            "dxDiagram-commandLayoutRightToLeft": "\u0421\u043f\u0440\u0430\u0432\u0430 \u043d\u0430\u043b\u0456\u0432\u043e",
            "dxDiagram-commandLayoutTopToBottom": "\u0417\u0433\u043e\u0440\u0438 \u0434\u043e\u043d\u0438\u0437\u0443",
            "dxDiagram-commandLayoutBottomToTop": "\u0417\u043d\u0438\u0437\u0443 \u0432\u0433\u043e\u0440\u0443",
            "dxDiagram-unitIn": "\u0434\u044e\u0439\u043c",
            "dxDiagram-unitCm": "\u0441\u043c",
            "dxDiagram-unitPx": "\u043f\u0456\u043a\u0441",
            "dxDiagram-dialogButtonOK": "\u041e\u041a",
            "dxDiagram-dialogButtonCancel": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxDiagram-dialogInsertShapeImageTitle": "\u0412\u0441\u0442\u0430\u0432\u0438\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDiagram-dialogEditShapeImageTitle": "\u0417\u043c\u0456\u043d\u0430 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDiagram-dialogEditShapeImageSelectButton": "\u0412\u0438\u0431\u0440\u0430\u0442\u0438 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f",
            "dxDiagram-dialogEditShapeImageLabelText": "\u0430\u0431\u043e \u043f\u0435\u0440\u0435\u0442\u044f\u0433\u043d\u0456\u0442\u044c \u0444\u0430\u0439\u043b \u0441\u044e\u0434\u0438",
            "dxDiagram-uiExport": "\u0415\u043a\u0441\u043f\u043e\u0440\u0442",
            "dxDiagram-uiProperties": "\u0412\u043b\u0430\u0441\u0442\u0438\u0432\u043e\u0441\u0442\u0456",
            "dxDiagram-uiSettings": "\u041d\u0430\u043b\u0430\u0448\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDiagram-uiShowToolbox": "\u041f\u0430\u043d\u0435\u043b\u044c \u0456\u043d\u0441\u0442\u0440\u0443\u043c\u0435\u043d\u0442\u0456\u0432",
            "dxDiagram-uiSearch": "\u041f\u043e\u0448\u0443\u043a",
            "dxDiagram-uiStyle": "\u0421\u0442\u0438\u043b\u044c",
            "dxDiagram-uiLayout": "\u0420\u043e\u0437\u043c\u0456\u0442\u043a\u0430",
            "dxDiagram-uiLayoutTree": "\u0414\u0435\u0440\u0435\u0432\u043e",
            "dxDiagram-uiLayoutLayered": "\u0428\u0430\u0440\u043e\u0432\u0430",
            "dxDiagram-uiDiagram": "\u0414\u0456\u0430\u0433\u0440\u0430\u043c\u0430",
            "dxDiagram-uiText": "\u0422\u0435\u043a\u0441\u0442",
            "dxDiagram-uiObject": "\u041e\u0431'\u0454\u043a\u0442",
            "dxDiagram-uiConnector": "\u0417'\u0454\u0434\u043d\u0443\u0432\u0430\u0447",
            "dxDiagram-uiPage": "\u0421\u0442\u043e\u0440\u0456\u043d\u043a\u0430",
            "dxDiagram-shapeText": "\u0422\u0435\u043a\u0441\u0442",
            "dxDiagram-shapeRectangle": "\u041f\u0440\u044f\u043c\u043e\u043a\u0443\u0442\u043d\u0438\u043a",
            "dxDiagram-shapeEllipse": "\u0415\u043b\u0456\u043f\u0441",
            "dxDiagram-shapeCross": "\u0425\u0440\u0435\u0441\u0442",
            "dxDiagram-shapeTriangle": "\u0422\u0440\u0438\u043a\u0443\u0442\u043d\u0438\u043a",
            "dxDiagram-shapeDiamond": "\u0420\u043e\u043c\u0431",
            "dxDiagram-shapeHeart": "\u0421\u0435\u0440\u0446\u0435",
            "dxDiagram-shapePentagon": "\u041f'\u044f\u0442\u0438\u043a\u0443\u0442\u043d\u0438\u043a",
            "dxDiagram-shapeHexagon": "\u0428\u0435\u0441\u0442\u0438\u043a\u0443\u0442\u043d\u0438\u043a",
            "dxDiagram-shapeOctagon": "\u0412\u043e\u0441\u044c\u043c\u0438\u043a\u0443\u0442\u043d\u0438\u043a",
            "dxDiagram-shapeStar": "\u0417\u0456\u0440\u043a\u0430",
            "dxDiagram-shapeArrowLeft": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u043b\u0456\u0432\u043e",
            "dxDiagram-shapeArrowUp": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u0433\u043e\u0440\u0443",
            "dxDiagram-shapeArrowRight": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u043f\u0440\u0430\u0432\u043e",
            "dxDiagram-shapeArrowDown": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u043d\u0438\u0437",
            "dxDiagram-shapeArrowUpDown": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u0433\u043e\u0440\u0443-\u0432\u043d\u0438\u0437",
            "dxDiagram-shapeArrowLeftRight": "\u0421\u0442\u0440\u0456\u043b\u043a\u0430 \u0432\u043b\u0456\u0432\u043e-\u0432\u043f\u0440\u0430\u0432\u043e",
            "dxDiagram-shapeProcess": "\u041f\u0440\u043e\u0446\u0435\u0441",
            "dxDiagram-shapeDecision": "\u0420\u0456\u0448\u0435\u043d\u043d\u044f",
            "dxDiagram-shapeTerminator": "\u0422\u0435\u0440\u043c\u0456\u043d\u0430\u0442\u043e\u0440",
            "dxDiagram-shapePredefinedProcess": "\u0417\u0430\u0437\u0434\u0430\u043b\u0435\u0433\u0456\u0434\u044c \u0432\u0438\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0439 \u043f\u0440\u043e\u0446\u0435\u0441",
            "dxDiagram-shapeDocument": "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442",
            "dxDiagram-shapeMultipleDocuments": "\u041a\u0456\u043b\u044c\u043a\u0430 \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0456\u0432",
            "dxDiagram-shapeManualInput": "\u0412\u0432\u0435\u0434\u0435\u043d\u043d\u044f \u0432\u0440\u0443\u0447\u043d\u0443",
            "dxDiagram-shapePreparation": "\u041f\u0456\u0434\u0433\u043e\u0442\u043e\u0432\u043a\u0430",
            "dxDiagram-shapeData": "\u0414\u0430\u043d\u0456",
            "dxDiagram-shapeDatabase": "\u0411\u0430\u0437\u0430 \u0434\u0430\u043d\u0438\u0445",
            "dxDiagram-shapeHardDisk": "\u0416\u043e\u0440\u0441\u0442\u043a\u0438\u0439 \u0434\u0438\u0441\u043a",
            "dxDiagram-shapeInternalStorage": "\u0412\u043d\u0443\u0442\u0440\u0456\u0448\u043d\u0454 \u0441\u0445\u043e\u0432\u0438\u0449\u0435",
            "dxDiagram-shapePaperTape": "\u041f\u0430\u043f\u0435\u0440\u043e\u0432\u0430 \u0441\u0442\u0440\u0456\u0447\u043a\u0430",
            "dxDiagram-shapeManualOperation": "\u0420\u0443\u0447\u043d\u0430 \u043e\u043f\u0435\u0440\u0430\u0446\u0456\u044f",
            "dxDiagram-shapeDelay": "\u0417\u0430\u0442\u0440\u0438\u043c\u043a\u0430",
            "dxDiagram-shapeStoredData": "\u0417\u0431\u0435\u0440\u0435\u0436\u0435\u043d\u0456 \u0434\u0430\u043d\u0456",
            "dxDiagram-shapeDisplay": "\u0414\u0438\u0441\u043f\u043b\u0435\u0439",
            "dxDiagram-shapeMerge": "\u041e\u0431'\u0454\u0434\u043d\u0430\u043d\u043d\u044f",
            "dxDiagram-shapeConnector": "\u0417'\u0454\u0434\u043d\u0443\u0432\u0430\u0447",
            "dxDiagram-shapeOr": "\u0410\u0431\u043e",
            "dxDiagram-shapeSummingJunction": "\u0421\u0443\u043c\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxDiagram-shapeContainerDefaultText": "\u041a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440",
            "dxDiagram-shapeVerticalContainer": "\u0412\u0435\u0440\u0442\u0438\u043a\u0430\u043b\u044c\u043d\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440",
            "dxDiagram-shapeHorizontalContainer": "\u0413\u043e\u0440\u0438\u0437\u043e\u043d\u0442\u0430\u043b\u044c\u043d\u0438\u0439 \u043a\u043e\u043d\u0442\u0435\u0439\u043d\u0435\u0440",
            "dxDiagram-shapeCardDefaultText": "\u0406\u043c'\u044f \u043e\u0441\u043e\u0431\u0438",
            "dxDiagram-shapeCardWithImageOnLeft": "\u041a\u0430\u0440\u0442\u043a\u0430 \u0437 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f\u043c \u0437\u043b\u0456\u0432\u0430",
            "dxDiagram-shapeCardWithImageOnTop": "\u041a\u0430\u0440\u0442\u043a\u0430 \u0437 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f\u043c \u0437\u0432\u0435\u0440\u0445\u0443",
            "dxDiagram-shapeCardWithImageOnRight": "\u041a\u0430\u0440\u0442\u043a\u0430 \u0437 \u0437\u043e\u0431\u0440\u0430\u0436\u0435\u043d\u043d\u044f\u043c \u0441\u043f\u0440\u0430\u0432\u0430",
            "dxGantt-dialogTitle": "\u0417\u0430\u0433\u043e\u043b\u043e\u0432\u043e\u043a",
            "dxGantt-dialogStartTitle": "\u041f\u043e\u0447\u0430\u0442\u043e\u043a",
            "dxGantt-dialogEndTitle": "\u0417\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f",
            "dxGantt-dialogProgressTitle": "\u0412\u0438\u043a\u043e\u043d\u0430\u043d\u043e",
            "dxGantt-dialogResourcesTitle": "\u0420\u0435\u0441\u0443\u0440\u0441\u0438",
            "dxGantt-dialogResourceManagerTitle": "\u041a\u0435\u0440\u0443\u0432\u0430\u043d\u043d\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0430\u043c\u0438",
            "dxGantt-dialogTaskDetailsTitle": "\u0414\u0435\u0442\u0430\u043b\u0456 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-dialogEditResourceListHint": "\u0420\u0435\u0434\u0430\u0433\u0443\u0432\u0430\u0442\u0438 \u0441\u043f\u0438\u0441\u043e\u043a \u0440\u0435\u0441\u0443\u0440\u0441\u0456\u0432",
            "dxGantt-dialogEditNoResources": "\u041d\u0435\u043c\u0430\u0454 \u0440\u0435\u0441\u0443\u0440\u0441\u0456\u0432",
            "dxGantt-dialogButtonAdd": "\u0414\u043e\u0434\u0430\u0442\u0438",
            "dxGantt-contextMenuNewTask": "\u041d\u043e\u0432\u0435 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-contextMenuNewSubtask": "\u041d\u043e\u0432\u0435 \u043f\u0456\u0434\u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-contextMenuDeleteTask": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-contextMenuDeleteDependency": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044c",
            "dxGantt-dialogTaskDeleteConfirmation": "\u041f\u0456\u0434 \u0447\u0430\u0441 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f \u0431\u0443\u0434\u0435 \u0442\u0430\u043a\u043e\u0436 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043e \u0432\u0441\u0456 \u0439\u043e\u0433\u043e \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0456 \u0442\u0430 \u043f\u0456\u0434\u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f. \u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0446\u0435 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f?",
            "dxGantt-dialogDependencyDeleteConfirmation": "\u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044c \u0432\u0456\u0434 \u0446\u044c\u043e\u0433\u043e \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f?",
            "dxGantt-dialogResourcesDeleteConfirmation": "\u041f\u0456\u0441\u043b\u044f \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u043d\u044f \u0440\u0435\u0441\u0443\u0440\u0441\u0443 \u0432\u0456\u043d \u0442\u0430\u043a\u043e\u0436 \u0431\u0443\u0434\u0435 \u0432\u0438\u0434\u0430\u043b\u0435\u043d\u0438\u0439 \u0437 \u0443\u0441\u0456\u0445 \u043f\u043e\u0432'\u044f\u0437\u0430\u043d\u0438\u0445 \u0437\u0430\u0432\u0434\u0430\u043d\u044c. \u0412\u0438 \u0432\u043f\u0435\u0432\u043d\u0435\u043d\u0456, \u0449\u043e \u0445\u043e\u0447\u0435\u0442\u0435 \u0432\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0446\u0456 \u0440\u0435\u0441\u0443\u0440\u0441\u0438? \u0420\u0435\u0441\u0443\u0440\u0441\u0438: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "\u0417\u0430\u0432\u0434\u0430\u043d\u043d\u044f, \u044f\u043a\u0435 \u0432\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u043f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438, \u043f\u043e\u0432'\u044f\u0437\u0430\u043d\u0435 \u0456\u0437 \u0456\u043d\u0448\u0438\u043c \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f\u043c \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044e. \u0426\u044f \u0437\u043c\u0456\u043d\u0430 \u043f\u043e\u0440\u0443\u0448\u0443\u0454 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0435\u0439. \u042f\u043a \u0432\u0438 \u0445\u043e\u0447\u0435\u0442\u0435 \u0434\u0456\u044f\u0442\u0438 \u0434\u0430\u043b\u0456?",
            "dxGantt-dialogConstraintViolationMessage": "\u0417\u0430\u0432\u0434\u0430\u043d\u043d\u044f, \u044f\u043a\u0435 \u0432\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u043f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438, \u043f\u043e\u0432'\u044f\u0437\u0430\u043d\u0435 \u0456\u0437 \u0456\u043d\u0448\u0438\u043c \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f\u043c \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044e. \u042f\u043a \u0432\u0438 \u0445\u043e\u0447\u0435\u0442\u0435 \u0434\u0456\u044f\u0442\u0438 \u0434\u0430\u043b\u0456?",
            "dxGantt-dialogCancelOperationMessage": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438 \u043e\u043f\u0435\u0440\u0430\u0446\u0456\u044e",
            "dxGantt-dialogDeleteDependencyMessage": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044c",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f \u0442\u0430 \u0437\u0431\u0435\u0440\u0435\u0433\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u0456\u0441\u0442\u044c",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "\u0417\u0430\u0432\u0434\u0430\u043d\u043d\u044f, \u044f\u043a\u0435 \u0432\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u043f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438, \u043c\u0430\u0454 \u043a\u0456\u043b\u044c\u043a\u0430 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0435\u0439 \u0437 \u0456\u043d\u0448\u0438\u043c\u0438 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f\u043c\u0438. \u0426\u044f \u0437\u043c\u0456\u043d\u0430 \u043f\u043e\u0440\u0443\u0448\u0443\u0454 \u043f\u0440\u0430\u0432\u0438\u043b\u0430 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0435\u0439. \u042f\u043a \u0432\u0438 \u0445\u043e\u0447\u0435\u0442\u0435 \u0434\u0456\u044f\u0442\u0438 \u0434\u0430\u043b\u0456?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "\u0417\u0430\u0432\u0434\u0430\u043d\u043d\u044f, \u044f\u043a\u0435 \u0432\u0438 \u043d\u0430\u043c\u0430\u0433\u0430\u0454\u0442\u0435\u0441\u044c \u043f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438, \u043c\u0430\u0454 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0456 \u0437 \u0456\u043d\u0448\u0438\u043c\u0438 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f\u043c\u0438. \u042f\u043a \u0432\u0438 \u0445\u043e\u0447\u0435\u0442\u0435 \u0434\u0456\u044f\u0442\u0438 \u0434\u0430\u043b\u0456?",
            "dxGantt-dialogDeleteDependenciesMessage": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0456",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "\u041f\u0435\u0440\u0435\u043c\u0456\u0441\u0442\u0438\u0442\u0438 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f \u0442\u0430 \u0437\u0431\u0435\u0440\u0435\u0433\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0456",
            "dxGantt-undo": "\u0421\u043a\u0430\u0441\u0443\u0432\u0430\u0442\u0438",
            "dxGantt-redo": "\u041f\u043e\u0432\u0442\u043e\u0440\u0438\u0442\u0438",
            "dxGantt-expandAll": "\u0420\u043e\u0437\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0432\u0441\u0435",
            "dxGantt-collapseAll": "\u0417\u0433\u043e\u0440\u043d\u0443\u0442\u0438 \u0432\u0441\u0435",
            "dxGantt-addNewTask": "\u0414\u043e\u0434\u0430\u0442\u0438 \u043d\u043e\u0432\u0435 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-deleteSelectedTask": "\u0412\u0438\u0434\u0430\u043b\u0438\u0442\u0438 \u0432\u0438\u0431\u0440\u0430\u043d\u0435 \u0437\u0430\u0432\u0434\u0430\u043d\u043d\u044f",
            "dxGantt-zoomIn": "\u0417\u0431\u0456\u043b\u044c\u0448\u0438\u0442\u0438",
            "dxGantt-zoomOut": "\u0417\u043c\u0435\u043d\u0448\u0438\u0442\u0438",
            "dxGantt-fullScreen": "\u041d\u0430 \u0432\u0435\u0441\u044c \u0435\u043a\u0440\u0430\u043d",
            "dxGantt-quarter": "\u041a\u0432. {0}",
            "dxGantt-sortingAscendingText": "\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0437\u0430 \u0437\u0440\u043e\u0441\u0442\u0430\u043d\u043d\u044f\u043c",
            "dxGantt-sortingDescendingText": "\u0421\u043e\u0440\u0442\u0443\u0432\u0430\u0442\u0438 \u0437\u0430 \u0441\u043f\u0430\u0434\u0430\u043d\u043d\u044f\u043c",
            "dxGantt-sortingClearText": "\u041e\u0447\u0438\u0441\u0442\u0438\u0442\u0438 \u0441\u043e\u0440\u0442\u0443\u0432\u0430\u043d\u043d\u044f",
            "dxGantt-showResources": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u0440\u0435\u0441\u0443\u0440\u0441\u0438",
            "dxGantt-showDependencies": "\u041f\u043e\u043a\u0430\u0437\u0430\u0442\u0438 \u0437\u0430\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u0456",
            "dxGantt-dialogStartDateValidation": "\u0414\u0430\u0442\u0430 \u043f\u043e\u0447\u0430\u0442\u043a\u0443 \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u043f\u0456\u0441\u043b\u044f {0}",
            "dxGantt-dialogEndDateValidation": "\u0414\u0430\u0442\u0430 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u043d\u044f \u043c\u0430\u0454 \u0431\u0443\u0442\u0438 \u043f\u0456\u0441\u043b\u044f {0}",
            "dxGallery-itemName": "\u0415\u043b\u0435\u043c\u0435\u043d\u0442 \u0433\u0430\u043b\u0435\u0440\u0435\u0457",
            "dxMultiView-elementAriaRoleDescription": "\u041a\u0456\u043b\u044c\u043a\u0430 \u043f\u0440\u0435\u0434\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u044c",
            "dxMultiView-elementAriaLabel": "\u0412\u0438\u043a\u043e\u0440\u0438\u0441\u0442\u043e\u0432\u0443\u0439\u0442\u0435 \u043a\u043b\u0430\u0432\u0456\u0448\u0456 \u0437\u0456 \u0441\u0442\u0440\u0456\u043b\u043a\u0430\u043c\u0438 \u0430\u0431\u043e \u043f\u0440\u043e\u0432\u0435\u0434\u0456\u0442\u044c \u043f\u0430\u043b\u044c\u0446\u0435\u043c \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0445\u043e\u0434\u0443 \u043c\u0456\u0436 \u043f\u0435\u0440\u0435\u0433\u043b\u044f\u0434\u0430\u043c\u0438",
            "dxMultiView-itemAriaRoleDescription": "\u041f\u0435\u0440\u0435\u0433\u043b\u044f\u0434",
            "dxMultiView-itemAriaLabel": "{0} \u0437 {1}",
            "dxSplitter-resizeHandleAriaLabel": "\u0420\u043e\u0437\u0434\u0456\u043b\u044e\u0432\u0430\u0447",
            "dxSplitter-resizeHandleAriaRoleDescription": "\u0420\u043e\u0437\u0434\u0456\u043b\u044e\u0432\u0430\u0447",
            "dxStepper-optionalMark": "(\u041d\u0435\u043e\u0431\u043e\u0432'\u044f\u0437\u043a\u043e\u0432\u043e)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
