/*!
* DevExtreme (dx.messages.sv.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        sv: {
            Yes: "Ja",
            No: "Nej",
            Cancel: "Avbryt",
            CheckState: "Kontrollera status",
            Close: "St\xe4ng",
            Clear: "Rensa",
            Done: "Klar",
            Loading: "Laddar...",
            Select: "V\xe4lj...",
            Search: "S\xf6k",
            Back: "Tillbaka",
            OK: "OK",
            Today: "Idag",
            Yesterday: "Ig\xe5r",
            "dxCollectionWidget-noDataText": "Inga data att visa",
            "dxDropDownEditor-selectLabel": "V\xe4lj",
            "validation-required": "Obligatoriskt",
            "validation-required-formatted": "{0} \xe4r obligatoriskt",
            "validation-numeric": "V\xe4rdet m\xe5ste vara ett nummer",
            "validation-numeric-formatted": "{0} m\xe5ste vara ett nummer",
            "validation-range": "V\xe4rdet \xe4r utanf\xf6r till\xe5tet intervall",
            "validation-range-formatted": "{0} \xe4r utanf\xf6r till\xe5tet intervall",
            "validation-stringLength": "V\xe4rdets l\xe4ngd \xe4r inte korrekt",
            "validation-stringLength-formatted": "L\xe4ngden p\xe5 {0} \xe4r inte korrekt",
            "validation-custom": "Ogiltigt v\xe4rde",
            "validation-custom-formatted": "{0} \xe4r ogiltigt",
            "validation-async": "Ogiltigt v\xe4rde",
            "validation-async-formatted": "{0} \xe4r ogiltigt",
            "validation-compare": "V\xe4rdena matchar inte",
            "validation-compare-formatted": "{0} matchar inte",
            "validation-pattern": "V\xe4rdet matchar inte m\xf6nstret",
            "validation-pattern-formatted": "{0} matchar inte m\xf6nstret",
            "validation-email": "Ogiltig e-postadress",
            "validation-email-formatted": "{0} \xe4r ogiltigt",
            "validation-mask": "V\xe4rdet \xe4r ogiltigt",
            "dxLookup-searchPlaceholder": "Minsta antal tecken: {0}",
            "dxList-pullingDownText": "Dra ner\xe5t f\xf6r att uppdatera...",
            "dxList-pulledDownText": "Sl\xe4pp f\xf6r att uppdatera...",
            "dxList-refreshingText": "Uppdaterar...",
            "dxList-pageLoadingText": "Laddar...",
            "dxList-nextButtonText": "Mer",
            "dxList-selectAll": "V\xe4lj alla",
            "dxList-listAriaLabel": "Objekt",
            "dxList-listAriaLabel-deletable": "Borttagbara objekt",
            "dxListEditDecorator-delete": "Radera",
            "dxListEditDecorator-more": "Mer",
            "dxList-selectAll-indeterminate": "Delvis markerad",
            "dxList-selectAll-checked": "Markerad",
            "dxList-selectAll-notChecked": "Inte markerad",
            "dxList-ariaRoleDescription": "Lista",
            "dxList-listAriaLabel-itemContent": "Listobjektets inneh\xe5ll",
            "dxScrollView-pullingDownText": "Dra ner\xe5t f\xf6r att uppdatera...",
            "dxScrollView-pulledDownText": "Sl\xe4pp f\xf6r att uppdatera...",
            "dxScrollView-refreshingText": "Uppdaterar...",
            "dxScrollView-reachBottomText": "Laddar...",
            "dxDateBox-simulatedDataPickerTitleTime": "V\xe4lj tid",
            "dxDateBox-simulatedDataPickerTitleDate": "V\xe4lj datum",
            "dxDateBox-simulatedDataPickerTitleDateTime": "V\xe4lj datum och tid",
            "dxDateBox-validation-datetime": "V\xe4rdet m\xe5ste vara ett datum eller en tid",
            "dxDateRangeBox-invalidStartDateMessage": "Startv\xe4rdet m\xe5ste vara ett datum",
            "dxDateRangeBox-invalidEndDateMessage": "Slutv\xe4rdet m\xe5ste vara ett datum",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Startdatum \xe4r utanf\xf6r till\xe5tet intervall",
            "dxDateRangeBox-endDateOutOfRangeMessage": "Slutdatum \xe4r utanf\xf6r till\xe5tet intervall",
            "dxDateRangeBox-startDateLabel": "Startdatum",
            "dxDateRangeBox-endDateLabel": "Slutdatum",
            "dxFileUploader-selectFile": "V\xe4lj fil",
            "dxFileUploader-dropFile": "eller sl\xe4pp filen h\xe4r",
            "dxFileUploader-bytes": "byte",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Ladda upp",
            "dxFileUploader-uploaded": "Uppladdad",
            "dxFileUploader-readyToUpload": "Klar att ladda upp",
            "dxFileUploader-uploadAbortedMessage": "Uppladdning avbruten",
            "dxFileUploader-uploadFailedMessage": "Uppladdningen misslyckades",
            "dxFileUploader-invalidFileExtension": "Filtypen \xe4r inte till\xe5ten",
            "dxFileUploader-invalidMaxFileSize": "Filen \xe4r f\xf6r stor",
            "dxFileUploader-invalidMinFileSize": "Filen \xe4r f\xf6r liten",
            "dxFileUploader-fileListLabel": "Fillista",
            "dxFileUploader-removeFileButtonLabel": "Ta bort fil {0}",
            "dxFileUploader-uploadFileButtonLabel": "Ladda upp fil {0}",
            "dxRangeSlider-ariaFrom": "Fr\xe5n",
            "dxRangeSlider-ariaTill": "Till",
            "dxSwitch-switchedOnText": "P\xc5",
            "dxSwitch-switchedOffText": "AV",
            "dxForm-optionalMark": "valfri",
            "dxForm-requiredMessage": "{0} \xe4r obligatoriskt",
            "dxForm-smartPasteButtonText": "Smart klistra in",
            "dxForm-resetButtonText": "\xc5terst\xe4ll",
            "dxForm-submitButtonText": "Skicka",
            "dxNumberBox-invalidValueMessage": "V\xe4rdet m\xe5ste vara ett nummer",
            "dxNumberBox-noDataText": "Inga data",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Be AI generera kolumnens v\xe4rden",
            "dxDataGrid-aiPromptEditorApplyButton": "Till\xe4mpa",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Generera om data",
            "dxDataGrid-aiPromptEditorStopButton": "Stoppa",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Anv\xe4nd {0} f\xf6r att visa kolumner",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Dra en kolumn fr\xe5n grupperingspanelen hit",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Anv\xe4nd {0} eller dra en kolumn fr\xe5n grupperingspanelen",
            "dxDataGrid-emptyHeaderColumnChooserText": "kolumnv\xe4ljaren",
            "dxDataGrid-columnChooserTitle": "Kolumnv\xe4ljare",
            "dxDataGrid-columnChooserEmptyText": "Dra en kolumn hit f\xf6r att d\xf6lja den",
            "dxDataGrid-groupContinuesMessage": "Forts\xe4tter p\xe5 n\xe4sta sida",
            "dxDataGrid-groupContinuedMessage": "Forts\xe4ttning fr\xe5n f\xf6reg\xe5ende sida",
            "dxDataGrid-groupHeaderText": "Gruppera enligt denna kolumn",
            "dxDataGrid-ungroupHeaderText": "Avgruppera",
            "dxDataGrid-ungroupAllText": "Avgruppera allt",
            "dxDataGrid-editingEditRow": "Redigera",
            "dxDataGrid-editingSaveRowChanges": "Spara",
            "dxDataGrid-editingCancelRowChanges": "Avbryt",
            "dxDataGrid-editingDeleteRow": "Radera",
            "dxDataGrid-editingUndeleteRow": "\xc5ngra radering",
            "dxDataGrid-editingConfirmDeleteMessage": "\xc4r du s\xe4ker p\xe5 att du vill radera denna post?",
            "dxDataGrid-validationCancelChanges": "Avbryt \xe4ndringarna",
            "dxDataGrid-groupPanelEmptyText": "Dra en kolumnrubrik hit f\xf6r att gruppera enligt den kolumnen",
            "dxDataGrid-noDataText": "Inga data",
            "dxDataGrid-searchPanelPlaceholder": "S\xf6k...",
            "dxDataGrid-filterRowShowAllText": "(Allt)",
            "dxDataGrid-filterRowResetOperationText": "\xc5terst\xe4ll",
            "dxDataGrid-filterRowOperationEquals": "\xc4r lika med",
            "dxDataGrid-filterRowOperationNotEquals": "\xc4r olika",
            "dxDataGrid-filterRowOperationLess": "Mindre \xe4n",
            "dxDataGrid-filterRowOperationLessOrEquals": "Mindre \xe4n eller lika med",
            "dxDataGrid-filterRowOperationGreater": "St\xf6rre \xe4n",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "St\xf6rre \xe4n eller lika med",
            "dxDataGrid-filterRowOperationStartsWith": "B\xf6rjar med",
            "dxDataGrid-filterRowOperationContains": "Inneh\xe5ller",
            "dxDataGrid-filterRowOperationNotContains": "Inneh\xe5ller inte",
            "dxDataGrid-filterRowOperationEndsWith": "Slutar med",
            "dxDataGrid-filterRowOperationBetween": "Mellan",
            "dxDataGrid-filterRowOperationBetweenStartText": "Start",
            "dxDataGrid-filterRowOperationBetweenEndText": "Slut",
            "dxDataGrid-ariaSearchBox": "S\xf6kruta",
            "dxDataGrid-applyFilterText": "Anv\xe4nd filter",
            "dxDataGrid-trueText": "sant",
            "dxDataGrid-falseText": "falskt",
            "dxDataGrid-sortingAscendingText": "Sortera stigande",
            "dxDataGrid-sortingDescendingText": "Sortera fallande",
            "dxDataGrid-sortingClearText": "Rensa sortering",
            "dxDataGrid-ariaNotSortedColumn": "Ej sorterad kolumn",
            "dxDataGrid-ariaSortedAscendingColumn": "Kolumn sorterad i stigande ordning",
            "dxDataGrid-ariaSortedDescendingColumn": "Kolumn sorterad i fallande ordning",
            "dxDataGrid-ariaSortIndex": "Sorteringsindex {0}",
            "dxDataGrid-editingSaveAllChanges": "Spara \xe4ndringar",
            "dxDataGrid-editingCancelAllChanges": "\xc5ngra \xe4ndringar",
            "dxDataGrid-editingAddRow": "L\xe4gg till rad",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Minimiv\xe4rde av {1} \xe4r {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maxv\xe4rde av {1} \xe4r {0}",
            "dxDataGrid-summaryAvg": "Medel: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Medelv\xe4rde av {1} \xe4r {0}",
            "dxDataGrid-summarySum": "Summa: {0}",
            "dxDataGrid-summarySumOtherColumn": "Summan av {1} \xe4r {0}",
            "dxDataGrid-summaryCount": "Antal: {0}",
            "dxDataGrid-columnFixingFix": "F\xe4st position",
            "dxDataGrid-columnFixingUnfix": "Lossa",
            "dxDataGrid-columnFixingLeftPosition": "V\xe4nster",
            "dxDataGrid-columnFixingRightPosition": "H\xf6ger",
            "dxDataGrid-columnFixingStickyPosition": "Fast",
            "dxDataGrid-exportTo": "Exportera",
            "dxDataGrid-exportToExcel": "Exportera till Excel-fil",
            "dxDataGrid-exporting": "Exporterar...",
            "dxDataGrid-excelFormat": "Excel-fil",
            "dxDataGrid-selectedRows": "Valda rader",
            "dxDataGrid-exportSelectedRows": "Exportera valda rader",
            "dxDataGrid-exportAll": "Exportera allt",
            "dxDataGrid-headerFilterLabel": "Filteralternativ",
            "dxDataGrid-headerFilterIndicatorLabel": "Visa filteralternativ f\xf6r kolumn '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tomma)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Avbryt",
            "dxDataGrid-ariaAdaptiveCollapse": "D\xf6lj ytterligare data",
            "dxDataGrid-ariaAdaptiveExpand": "Visa ytterligare data",
            "dxDataGrid-ariaColumn": "Kolumn",
            "dxDataGrid-ariaColumnHeader": "Kolumnrubrik",
            "dxDataGrid-ariaValue": "V\xe4rde",
            "dxDataGrid-ariaError": "Fel",
            "dxDataGrid-ariaRevertButton": "Tryck p\xe5 Escape f\xf6r att \xe5ngra \xe4ndringar",
            "dxDataGrid-ariaFilterCell": "Filtrera cell",
            "dxDataGrid-ariaCollapse": "Kollapsa",
            "dxDataGrid-ariaModifiedCell": "\xc4ndrad",
            "dxDataGrid-ariaDeletedCell": "Raderad",
            "dxDataGrid-ariaEditableCell": "Redigerbar",
            "dxDataGrid-ariaExpand": "Expandera",
            "dxDataGrid-ariaCollapsedRow": "Kollapsad rad",
            "dxDataGrid-ariaExpandedRow": "Expanderad rad",
            "dxDataGrid-ariaDataGrid": "Datarutn\xe4t",
            "dxDataGrid-ariaSearchInGrid": "S\xf6k i datarutn\xe4tet",
            "dxDataGrid-ariaSelectAll": "V\xe4lj alla",
            "dxDataGrid-ariaSelectRow": "V\xe4lj rad",
            "dxDataGrid-ariaToolbar": "Datarutn\xe4tsverktygsf\xe4lt",
            "dxDataGrid-ariaEditForm": "Redigeringsformul\xe4r",
            "dxDataGrid-filterBuilderPopupTitle": "Filterverktyg",
            "dxDataGrid-filterPanelCreateFilter": "Skapa filter",
            "dxDataGrid-filterPanelClearFilter": "Rensa",
            "dxDataGrid-filterPanelFilterEnabledHint": "Aktivera filter",
            "dxDataGrid-masterDetail": "Cell med detaljer",
            "dxDataGrid-moveColumnToTheRight": "Flytta till h\xf6ger",
            "dxDataGrid-moveColumnToTheLeft": "Flytta till v\xe4nster",
            "dxTreeList-ariaTreeList": "Tr\xe4dlista med {0} rader och {1} kolumner",
            "dxTreeList-ariaExpandableInstruction": "Tryck Ctrl + h\xf6gerpil f\xf6r att expandera den fokuserade noden och Ctrl + v\xe4nsterpil f\xf6r att kollapsa den",
            "dxTreeList-ariaSearchInGrid": "S\xf6k i tr\xe4dlistan",
            "dxTreeList-ariaToolbar": "Tr\xe4dlistans verktygsf\xe4lt",
            "dxTreeList-editingAddRowToNode": "L\xe4gg till",
            "dxPager-infoText": "Sida {0} av {1} ({2} uppgifter)",
            "dxPager-pagesCountText": "av",
            "dxPager-pageSize": "Objekt per sida: {0}",
            "dxPager-pageSizesAllText": "Allt",
            "dxPager-page": "Sida {0}",
            "dxPager-prevPage": "F\xf6reg\xe5ende sida",
            "dxPager-nextPage": "N\xe4sta sida",
            "dxPager-ariaLabel": "Sidnavigering",
            "dxPager-ariaPageSize": "Sidstorlek",
            "dxPager-ariaPageNumber": "Sidnummer",
            "dxPagination-infoText": "Sida {0} av {1} ({2} uppgifter)",
            "dxPagination-pagesCountText": "av",
            "dxPagination-pageSize": "Objekt per sida: {0}",
            "dxPagination-pageSizesAllText": "Allt",
            "dxPagination-page": "Sida {0}",
            "dxPagination-prevPage": "F\xf6reg\xe5ende sida",
            "dxPagination-nextPage": "N\xe4sta sida",
            "dxPagination-ariaLabel": "Sidnavigering",
            "dxPagination-ariaPageSize": "Sidstorlek",
            "dxPagination-ariaPageNumber": "Sidnummer",
            "dxPivotGrid-grandTotal": "Totalsumma",
            "dxPivotGrid-total": "{0} Summa",
            "dxPivotGrid-fieldChooserTitle": "F\xe4ltv\xe4ljare",
            "dxPivotGrid-showFieldChooser": "Visa f\xe4ltv\xe4ljare",
            "dxPivotGrid-expandAll": "Expandera alla",
            "dxPivotGrid-collapseAll": "Kollapsa alla",
            "dxPivotGrid-sortColumnBySummary": 'Sortera "{0}" enligt denna kolumn',
            "dxPivotGrid-sortRowBySummary": 'Sortera "{0}" enligt denna rad',
            "dxPivotGrid-removeAllSorting": "Ta bort all sortering",
            "dxPivotGrid-dataNotAvailable": "Saknas",
            "dxPivotGrid-rowFields": "Radf\xe4lt",
            "dxPivotGrid-columnFields": "Kolumnf\xe4lt",
            "dxPivotGrid-dataFields": "Dataf\xe4lt",
            "dxPivotGrid-filterFields": "Filterf\xe4lt",
            "dxPivotGrid-allFields": "Alla f\xe4lt",
            "dxPivotGrid-columnFieldArea": "Sl\xe4pp kolumnf\xe4lt h\xe4r",
            "dxPivotGrid-dataFieldArea": "Sl\xe4pp dataf\xe4lt h\xe4r",
            "dxPivotGrid-rowFieldArea": "Sl\xe4pp radf\xe4lt h\xe4r",
            "dxPivotGrid-filterFieldArea": "Sl\xe4pp filterf\xe4lt h\xe4r",
            "dxScheduler-dateRange": "fr\xe5n {0} till {1}",
            "dxScheduler-ariaLabel": "Schemal\xe4ggare. {0}-vy: {1} med {2} bokningar",
            "dxScheduler-ariaLabel-currentIndicator-present": "Aktuell tidsindikator visas i vyn",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "Aktuell tidsindikator visas inte p\xe5 sk\xe4rmen",
            "dxScheduler-appointmentAriaLabel-group": "Grupp: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "\xc5terkommande bokning",
            "dxScheduler-appointmentListAriaLabel": "Bokningslista",
            "dxScheduler-newPopupTitle": "Ny bokning",
            "dxScheduler-editPopupTitle": "Redigera bokning",
            "dxScheduler-editPopupSaveButtonText": "Spara",
            "dxScheduler-editorLabelTitle": "\xc4mne",
            "dxScheduler-editorLabelStartDate": "Startdatum",
            "dxScheduler-editorLabelEndDate": "Slutdatum",
            "dxScheduler-editorLabelDescription": "Beskrivning",
            "dxScheduler-editorLabelRecurrence": "Upprepa",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Idag",
            "dxScheduler-navigationPrevious": "F\xf6reg\xe5ende sida",
            "dxScheduler-navigationNext": "N\xe4sta sida",
            "dxScheduler-openAppointment": "\xd6ppna bokning",
            "dxScheduler-recurrenceNever": "Aldrig",
            "dxScheduler-recurrenceMinutely": "Varje minut",
            "dxScheduler-recurrenceHourly": "Varje timme",
            "dxScheduler-recurrenceDaily": "Varje dag",
            "dxScheduler-recurrenceWeekly": "Varje vecka",
            "dxScheduler-recurrenceMonthly": "Varje m\xe5nad",
            "dxScheduler-recurrenceYearly": "Varje \xe5r",
            "dxScheduler-recurrenceRepeatEvery": "Varje",
            "dxScheduler-recurrenceRepeatOn": "Upprepa p\xe5",
            "dxScheduler-recurrenceEnd": "Upprepningen slutar",
            "dxScheduler-recurrenceAfter": "Efter",
            "dxScheduler-recurrenceOn": "P\xe5",
            "dxScheduler-recurrenceUntilDateLabel": "Datum d\xe5 upprepningen slutar",
            "dxScheduler-recurrenceOccurrenceLabel": "Antal f\xf6rekomster",
            "dxScheduler-recurrenceRepeatMinutely": "minuter",
            "dxScheduler-recurrenceRepeatHourly": "timmar",
            "dxScheduler-recurrenceRepeatDaily": "dagar",
            "dxScheduler-recurrenceRepeatWeekly": "veckor",
            "dxScheduler-recurrenceRepeatMonthly": "m\xe5nader",
            "dxScheduler-recurrenceRepeatYearly": "\xe5r",
            "dxScheduler-switcherDay": "Dag",
            "dxScheduler-switcherWeek": "Vecka",
            "dxScheduler-switcherWorkWeek": "Arbetsvecka",
            "dxScheduler-switcherMonth": "M\xe5nad",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Tidslinje dag",
            "dxScheduler-switcherTimelineWeek": "Tidslinje vecka",
            "dxScheduler-switcherTimelineWorkWeek": "Tidslinje arbetsvecka",
            "dxScheduler-switcherTimelineMonth": "Tidslinje m\xe5nad",
            "dxScheduler-recurrenceRepeatOnDate": "p\xe5 datumet",
            "dxScheduler-recurrenceRepeatCount": "upprepning(ar)",
            "dxScheduler-allDay": "Hela dagen",
            "dxScheduler-ariaEditForm": "Redigeringsformul\xe4r",
            "dxScheduler-confirmRecurrenceEditTitle": "Redigera \xe5terkommande bokning",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Radera \xe5terkommande bokning",
            "dxScheduler-confirmRecurrenceEditMessage": "Vill du redigera bara denna avtalade tid eller hela serien?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Vill du radera bara denna avtalade tid eller hela serien?",
            "dxScheduler-confirmRecurrenceEditSeries": "Redigera serien",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Radera serien",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Redigera avtalad tid",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Radera avtalad tid",
            "dxScheduler-noTimezoneTitle": "Ingen tidszon",
            "dxScheduler-moreAppointments": "{0} mer",
            "dxCalendar-currentDay": "Idag",
            "dxCalendar-currentMonth": "Aktuell m\xe5nad",
            "dxCalendar-currentYear": "Aktuellt \xe5r",
            "dxCalendar-currentYearRange": "Aktuellt \xe5rsintervall",
            "dxCalendar-todayButtonText": "Idag",
            "dxCalendar-ariaWidgetName": "Kalender",
            "dxCalendar-previousMonthButtonLabel": "F\xf6reg\xe5ende m\xe5nad",
            "dxCalendar-previousYearButtonLabel": "F\xf6reg\xe5ende \xe5r",
            "dxCalendar-previousDecadeButtonLabel": "F\xf6reg\xe5ende \xe5rtionde",
            "dxCalendar-previousCenturyButtonLabel": "F\xf6reg\xe5ende \xe5rhundrade",
            "dxCalendar-nextMonthButtonLabel": "N\xe4sta m\xe5nad",
            "dxCalendar-nextYearButtonLabel": "N\xe4sta \xe5r",
            "dxCalendar-nextDecadeButtonLabel": "N\xe4sta \xe5rtionde",
            "dxCalendar-nextCenturyButtonLabel": "N\xe4sta \xe5rhundrade",
            "dxCalendar-captionMonthLabel": "M\xe5nadsval",
            "dxCalendar-captionYearLabel": "\xc5rsval",
            "dxCalendar-captionDecadeLabel": "Val av \xe5rtionde",
            "dxCalendar-captionCenturyLabel": "Val av \xe5rhundrade",
            "dxCalendar-selectedDate": "Det valda datumet \xe4r {0}",
            "dxCalendar-selectedDates": "Valda datum",
            "dxCalendar-selectedDateRange": "Det valda datumintervallet \xe4r fr\xe5n {0} till {1}",
            "dxCalendar-selectedMultipleDateRange": "fr\xe5n {0} till {1}",
            "dxCalendar-selectedDateRangeCount": "Det finns {0} valda datumintervall",
            "dxCalendar-readOnlyLabel": "Skrivskyddad kalender",
            "dxCardView-ariaSearchInGrid": "S\xf6k i kortvyn",
            "dxCardView-ariaHeaderItemLabel": "F\xe4ltnamn {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorterad i stigande ordning",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorterad i fallande ordning",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sorteringsindex {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Rubrikfilter till\xe4mpat",
            "dxCardView-ariaSelectCard": "V\xe4lj kort",
            "dxCardView-ariaCardView": "Kortvy med {0} kort. Varje kort har {1} f\xe4lt",
            "dxCardView-ariaCard": "Kort",
            "dxCardView-ariaEditableCard": "Redigerbart kort",
            "dxCardView-ariaCardPosition": "Rad {0}, kolumn {1}",
            "dxCardView-ariaSelectedCardState": "Valt",
            "dxCardView-ariaNotSelectedCardState": "Inte valt",
            "dxCardView-selectAll": "Markera alla",
            "dxCardView-clearSelection": "Rensa markering",
            "dxCardView-cardNoImageAriaLabel": "Ingen bild",
            "dxCardView-headerItemDropZoneText": "Sl\xe4pp rubrikobjektet h\xe4r",
            "dxCardView-emptyHeaderPanelText": "Anv\xe4nd {0} f\xf6r att visa kolumner",
            "dxCardView-emptyHeaderPanelColumnChooserText": "kolumnv\xe4ljaren",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chatt",
            "dxChat-textareaPlaceholder": "Skriv ett meddelande",
            "dxChat-sendButtonAriaLabel": "Skicka",
            "dxChat-cancelEditingButtonAriaLabel": "Avbryt",
            "dxChat-editingMessageCaption": "Redigera meddelande",
            "dxChat-defaultUserName": "Ok\xe4nd anv\xe4ndare",
            "dxChat-messageListAriaLabel": "Meddelandelista",
            "dxChat-alertListAriaLabel": "Fellista",
            "dxChat-emptyListMessage": "Det finns inga meddelanden i den h\xe4r chatten",
            "dxChat-emptyListPrompt": "Skriv ditt f\xf6rsta meddelande",
            "dxChat-typingMessageSingleUser": "{0} skriver...",
            "dxChat-typingMessageTwoUsers": "{0} och {1} skriver...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} och {2} skriver...",
            "dxChat-typingMessageMultipleUsers": "{0} och andra skriver...",
            "dxChat-editedMessageText": "Redigerat",
            "dxChat-editingEditMessage": "Redigera",
            "dxChat-editingDeleteMessage": "Radera",
            "dxChat-editingDeleteConfirmText": "\xc4r du s\xe4ker p\xe5 att du vill radera det h\xe4r meddelandet?",
            "dxChat-deletedMessageText": "Det h\xe4r meddelandet har raderats",
            "dxChat-defaultImageAlt": "Bild delad i chatten",
            "dxChat-fileViewLabel": "Fillista",
            "dxChat-downloadButtonLabel": "Ladda ner fil {0}",
            "dxChat-fileLimitReachedWarning": "Du valde f\xf6r m\xe5nga filer. V\xe4lj h\xf6gst {0} filer och f\xf6rs\xf6k igen.",
            "dxColorView-ariaRed": "R\xf6d",
            "dxColorView-ariaGreen": "Gr\xf6n",
            "dxColorView-ariaBlue": "Bl\xe5",
            "dxColorView-ariaAlpha": "Transparens",
            "dxColorView-ariaHex": "F\xe4rgkod",
            "dxTagBox-selected": "{0} valda",
            "dxTagBox-allSelected": "Alla valda ({0})",
            "dxTagBox-moreSelected": "{0} mer",
            "dxTagBox-tagRoleDescription": "Tagg. Tryck p\xe5 raderingsknappen f\xf6r att ta bort den h\xe4r taggen",
            "dxTagBox-ariaRoleDescription": "Taggruta",
            "vizExport-printingButtonText": "Skriv ut",
            "vizExport-titleMenuText": "Export/Utskrift",
            "vizExport-exportButtonText": "{0}-fil",
            "dxFilterBuilder-and": "Och",
            "dxFilterBuilder-or": "Eller",
            "dxFilterBuilder-notAnd": "Inte och",
            "dxFilterBuilder-notOr": "Inte eller",
            "dxFilterBuilder-addCondition": "L\xe4gg till villkor",
            "dxFilterBuilder-addGroup": "L\xe4gg till grupp",
            "dxFilterBuilder-enterValueText": "<ange v\xe4rde>",
            "dxFilterBuilder-filterOperationEquals": "\xc4r lika med",
            "dxFilterBuilder-filterOperationNotEquals": "\xc4r olika",
            "dxFilterBuilder-filterOperationLess": "Mindre \xe4n",
            "dxFilterBuilder-filterOperationLessOrEquals": "Mindre \xe4n eller lika med",
            "dxFilterBuilder-filterOperationGreater": "St\xf6rre \xe4n",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "St\xf6rre \xe4n eller lika med",
            "dxFilterBuilder-filterOperationStartsWith": "B\xf6rjar med",
            "dxFilterBuilder-filterOperationContains": "Inneh\xe5ller",
            "dxFilterBuilder-filterOperationNotContains": "Inneh\xe5ller inte",
            "dxFilterBuilder-filterOperationEndsWith": "Slutar med",
            "dxFilterBuilder-filterOperationIsBlank": "\xc4r tom",
            "dxFilterBuilder-filterOperationIsNotBlank": "\xc4r inte tom",
            "dxFilterBuilder-filterOperationBetween": "Mellan",
            "dxFilterBuilder-filterOperationAnyOf": "N\xe5gon av",
            "dxFilterBuilder-filterOperationNoneOf": "Ingen av",
            "dxFilterBuilder-filterAriaRootElement": "Filterbyggare",
            "dxFilterBuilder-filterAriaGroupLevel": "Niv\xe5 {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Gruppobjekt",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "L\xe4gg till",
            "dxFilterBuilder-filterAriaRemoveButton": "Ta bort {0}",
            "dxFilterBuilder-filterAriaItemField": "F\xe4lt",
            "dxFilterBuilder-filterAriaItemOperation": "\xc5tg\xe4rd",
            "dxFilterBuilder-filterAriaItemValue": "V\xe4rde",
            "dxHtmlEditor-dialogColorCaption": "\xc4ndra textf\xe4rg",
            "dxHtmlEditor-dialogBackgroundCaption": "\xc4ndra bakgrundsf\xe4rg",
            "dxHtmlEditor-dialogLinkCaption": "L\xe4gg till l\xe4nk",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Text",
            "dxHtmlEditor-dialogLinkTargetField": "\xd6ppna l\xe4nken i ett nytt f\xf6nster",
            "dxHtmlEditor-dialogImageCaption": "L\xe4gg till bild",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternativ text",
            "dxHtmlEditor-dialogImageWidthField": "Bredd (px)",
            "dxHtmlEditor-dialogImageHeightField": "H\xf6jd (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rader",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Kolumner",
            "dxHtmlEditor-dialogInsertTableCaption": "Infoga tabell",
            "dxHtmlEditor-dialogUpdateImageCaption": "Uppdatera bild",
            "dxHtmlEditor-dialogImageUpdateButton": "Uppdatera",
            "dxHtmlEditor-dialogImageAddButton": "L\xe4gg till",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Fr\xe5n webben",
            "dxHtmlEditor-dialogImageSelectFile": "Fr\xe5n den h\xe4r enheten",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Beh\xe5ll proportioner",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Koda till Base64",
            "dxHtmlEditor-heading": "Rubrik",
            "dxHtmlEditor-normalText": "Normal text",
            "dxHtmlEditor-background": "Bakgrundsf\xe4rg",
            "dxHtmlEditor-bold": "Fetstil",
            "dxHtmlEditor-color": "Textf\xe4rg",
            "dxHtmlEditor-font": "Typsnitt",
            "dxHtmlEditor-italic": "Kursiv",
            "dxHtmlEditor-link": "L\xe4gg till l\xe4nk",
            "dxHtmlEditor-image": "L\xe4gg till bild",
            "dxHtmlEditor-size": "Storlek",
            "dxHtmlEditor-strike": "Genomstruken",
            "dxHtmlEditor-subscript": "Neds\xe4nkt",
            "dxHtmlEditor-superscript": "Upph\xf6jd",
            "dxHtmlEditor-underline": "Understruken",
            "dxHtmlEditor-blockquote": "Blockcitat",
            "dxHtmlEditor-header": "Rubrik",
            "dxHtmlEditor-increaseIndent": "\xd6ka indrag",
            "dxHtmlEditor-decreaseIndent": "Minska indrag",
            "dxHtmlEditor-orderedList": "Numrerad lista",
            "dxHtmlEditor-bulletList": "Punktlista",
            "dxHtmlEditor-alignLeft": "V\xe4nsterjustera",
            "dxHtmlEditor-alignCenter": "Centrera",
            "dxHtmlEditor-alignRight": "H\xf6gerjustera",
            "dxHtmlEditor-alignJustify": "Justera",
            "dxHtmlEditor-codeBlock": "Kodblock",
            "dxHtmlEditor-variable": "L\xe4gg till variabel",
            "dxHtmlEditor-undo": "\xc5ngra",
            "dxHtmlEditor-redo": "G\xf6r om",
            "dxHtmlEditor-clear": "Rensa formatering",
            "dxHtmlEditor-insertTable": "Infoga tabell",
            "dxHtmlEditor-insertHeaderRow": "Infoga rubrikrad",
            "dxHtmlEditor-insertRowAbove": "Infoga rad ovanf\xf6r",
            "dxHtmlEditor-insertRowBelow": "Infoga rad nedanf\xf6r",
            "dxHtmlEditor-insertColumnLeft": "Infoga kolumn till v\xe4nster",
            "dxHtmlEditor-insertColumnRight": "Infoga kolumn till h\xf6ger",
            "dxHtmlEditor-deleteColumn": "Ta bort kolumn",
            "dxHtmlEditor-deleteRow": "Ta bort rad",
            "dxHtmlEditor-deleteTable": "Ta bort tabell",
            "dxHtmlEditor-cellProperties": "Cellinst\xe4llningar",
            "dxHtmlEditor-tableProperties": "Tabellinst\xe4llningar",
            "dxHtmlEditor-insert": "Infoga",
            "dxHtmlEditor-delete": "Ta bort",
            "dxHtmlEditor-border": "Kantlinje",
            "dxHtmlEditor-style": "Stil",
            "dxHtmlEditor-width": "Bredd",
            "dxHtmlEditor-height": "H\xf6jd",
            "dxHtmlEditor-borderColor": "F\xe4rg",
            "dxHtmlEditor-borderWidth": "Kantlinjens bredd",
            "dxHtmlEditor-tableBackground": "Bakgrund",
            "dxHtmlEditor-dimensions": "M\xe5tt",
            "dxHtmlEditor-alignment": "Justering",
            "dxHtmlEditor-horizontal": "Horisontell",
            "dxHtmlEditor-vertical": "Vertikal",
            "dxHtmlEditor-paddingVertical": "Vertikal fyllning",
            "dxHtmlEditor-paddingHorizontal": "Horisontell fyllning",
            "dxHtmlEditor-pixels": "Pixlar",
            "dxHtmlEditor-list": "Lista",
            "dxHtmlEditor-ordered": "Numrerad",
            "dxHtmlEditor-bullet": "Punktlista",
            "dxHtmlEditor-align": "Justera",
            "dxHtmlEditor-center": "Centrera",
            "dxHtmlEditor-left": "V\xe4nster",
            "dxHtmlEditor-right": "H\xf6ger",
            "dxHtmlEditor-indent": "Indrag",
            "dxHtmlEditor-justify": "Justera",
            "dxHtmlEditor-borderStyleNone": "ingen",
            "dxHtmlEditor-borderStyleHidden": "dold",
            "dxHtmlEditor-borderStyleDotted": "prickad",
            "dxHtmlEditor-borderStyleDashed": "streckad",
            "dxHtmlEditor-borderStyleSolid": "heldragen",
            "dxHtmlEditor-borderStyleDouble": "dubbel",
            "dxHtmlEditor-borderStyleGroove": "sp\xe5r",
            "dxHtmlEditor-borderStyleRidge": "\xe5s",
            "dxHtmlEditor-borderStyleInset": "neds\xe4nkt",
            "dxHtmlEditor-borderStyleOutset": "upph\xf6jd",
            "dxHtmlEditor-aiDialogTitle": "AI-assistent",
            "dxHtmlEditor-aiDialogError": "N\xe5got gick fel. F\xf6rs\xf6k igen.",
            "dxHtmlEditor-aiDialogCanceled": "Generering avbruten",
            "dxHtmlEditor-aiReplace": "Ers\xe4tt",
            "dxHtmlEditor-aiInsertAbove": "Infoga ovanf\xf6r",
            "dxHtmlEditor-aiInsertBelow": "Infoga nedanf\xf6r",
            "dxHtmlEditor-aiCopy": "Kopiera",
            "dxHtmlEditor-aiRegenerate": "Generera om",
            "dxHtmlEditor-aiGenerate": "Generera",
            "dxHtmlEditor-aiCancel": "Avbryt",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI-assistent verktygsf\xe4ltspost",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI-assistent resultat",
            "dxHtmlEditor-aiAskPlaceholder": "Be AI \xe4ndra text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Namnl\xf6s katalog",
            "dxFileManager-rootDirectoryName": "Filer",
            "dxFileManager-errorNoAccess": "\xc5tkomst nekad. \xc5tg\xe4rden kunde inte slutf\xf6ras.",
            "dxFileManager-errorDirectoryExistsFormat": "Katalogen '{0}' finns redan.",
            "dxFileManager-errorFileExistsFormat": "Filen '{0}' finns redan.",
            "dxFileManager-errorFileNotFoundFormat": "Filen '{0}' hittades inte.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Katalogen '{0}' hittades inte.",
            "dxFileManager-errorWrongFileExtension": "Filtypen \xe4r inte till\xe5ten.",
            "dxFileManager-errorMaxFileSizeExceeded": "Filstorleken \xf6verskrider den maximalt till\xe5tna storleken.",
            "dxFileManager-errorInvalidSymbols": "Namnet inneh\xe5ller ogiltiga tecken.",
            "dxFileManager-errorDefault": "Ospecificerat fel.",
            "dxFileManager-errorDirectoryOpenFailed": "Katalogen kunde inte \xf6ppnas",
            "dxFileManager-commandCreate": "Ny katalog",
            "dxFileManager-commandRename": "Byt namn",
            "dxFileManager-commandMove": "Flytta till",
            "dxFileManager-commandCopy": "Kopiera till",
            "dxFileManager-commandDelete": "Radera",
            "dxFileManager-commandDownload": "Ladda ner",
            "dxFileManager-commandUpload": "Ladda upp filer",
            "dxFileManager-commandRefresh": "Uppdatera",
            "dxFileManager-commandThumbnails": "Miniatyrvy",
            "dxFileManager-commandDetails": "Detaljvy",
            "dxFileManager-commandClearSelection": "Rensa markering",
            "dxFileManager-commandShowNavPane": "V\xe4xla navigeringspanel",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Flytta till",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Flytta",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kopiera till",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopiera",
            "dxFileManager-dialogRenameItemTitle": "Byt namn",
            "dxFileManager-dialogRenameItemButtonText": "Spara",
            "dxFileManager-dialogCreateDirectoryTitle": "Ny katalog",
            "dxFileManager-dialogCreateDirectoryButtonText": "Skapa",
            "dxFileManager-dialogDeleteItemTitle": "Radera",
            "dxFileManager-dialogDeleteItemButtonText": "Radera",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "\xc4r du s\xe4ker p\xe5 att du vill radera {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "\xc4r du s\xe4ker p\xe5 att du vill radera {0} objekt?",
            "dxFileManager-dialogButtonCancel": "Avbryt",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Skapar en katalog i {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Katalog skapad i {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Katalogen skapades inte",
            "dxFileManager-editingCreateCommonErrorMessage": "Katalogen skapades inte",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Byter namn p\xe5 ett objekt i {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Bytte namn p\xe5 ett objekt i {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Objektet byttes inte namn",
            "dxFileManager-editingRenameCommonErrorMessage": "Objektet byttes inte namn",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Raderar ett objekt fr\xe5n {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Raderar {0} objekt fr\xe5n {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Raderade ett objekt fr\xe5n {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Raderade {0} objekt fr\xe5n {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Objektet raderades inte",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} objekt raderades inte",
            "dxFileManager-editingDeleteCommonErrorMessage": "Vissa objekt raderades inte",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Flyttar ett objekt till {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Flyttar {0} objekt till {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Flyttade ett objekt till {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Flyttade {0} objekt till {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Objektet flyttades inte",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} objekt flyttades inte",
            "dxFileManager-editingMoveCommonErrorMessage": "Vissa objekt flyttades inte",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kopierar ett objekt till {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kopierar {0} objekt till {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Kopierade ett objekt till {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Kopierade {0} objekt till {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Objektet kopierades inte",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} objekt kopierades inte",
            "dxFileManager-editingCopyCommonErrorMessage": "Vissa objekt kopierades inte",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Laddar upp ett objekt till {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Laddar upp {0} objekt till {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Laddade upp ett objekt till {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Laddade upp {0} objekt till {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Objektet laddades inte upp",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} objekt laddades inte upp",
            "dxFileManager-editingUploadCanceledMessage": "Avbruten",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Objektet laddades inte ner",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} objekt laddades inte ner",
            "dxFileManager-listDetailsColumnCaptionName": "Namn",
            "dxFileManager-listDetailsColumnCaptionDateModified": "\xc4ndringsdatum",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Filstorlek",
            "dxFileManager-listThumbnailsTooltipTextSize": "Storlek",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "\xc4ndringsdatum",
            "dxFileManager-notificationProgressPanelTitle": "F\xf6rlopp",
            "dxFileManager-notificationProgressPanelEmptyListText": "Inga operationer",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Avbruten",
            "dxDiagram-categoryGeneral": "Allm\xe4nt",
            "dxDiagram-categoryFlowchart": "Fl\xf6desschema",
            "dxDiagram-categoryOrgChart": "Organisationsschema",
            "dxDiagram-categoryContainers": "Beh\xe5llare",
            "dxDiagram-categoryCustom": "Anpassad",
            "dxDiagram-commandExportToSvg": "Exportera till SVG",
            "dxDiagram-commandExportToPng": "Exportera till PNG",
            "dxDiagram-commandExportToJpg": "Exportera till JPEG",
            "dxDiagram-commandUndo": "\xc5ngra",
            "dxDiagram-commandRedo": "G\xf6r om",
            "dxDiagram-commandFontName": "Typsnitt",
            "dxDiagram-commandFontSize": "Textstorlek",
            "dxDiagram-commandBold": "Fetstil",
            "dxDiagram-commandItalic": "Kursiv",
            "dxDiagram-commandUnderline": "Understruken",
            "dxDiagram-commandTextColor": "Textf\xe4rg",
            "dxDiagram-commandLineColor": "Linjef\xe4rg",
            "dxDiagram-commandLineWidth": "Linjebredd",
            "dxDiagram-commandLineStyle": "Linjestil",
            "dxDiagram-commandLineStyleSolid": "Heldragen",
            "dxDiagram-commandLineStyleDotted": "Prickad",
            "dxDiagram-commandLineStyleDashed": "Streckad",
            "dxDiagram-commandFillColor": "Fyllnadsf\xe4rg",
            "dxDiagram-commandAlignLeft": "V\xe4nsterjustera",
            "dxDiagram-commandAlignCenter": "Centrera",
            "dxDiagram-commandAlignRight": "H\xf6gerjustera",
            "dxDiagram-commandConnectorLineType": "Anslutningstyp",
            "dxDiagram-commandConnectorLineStraight": "Rak",
            "dxDiagram-commandConnectorLineOrthogonal": "Vinkelr\xe4t",
            "dxDiagram-commandConnectorLineStart": "Anslutning start",
            "dxDiagram-commandConnectorLineEnd": "Anslutning slut",
            "dxDiagram-commandConnectorLineNone": "Ingen",
            "dxDiagram-commandConnectorLineArrow": "Pil",
            "dxDiagram-commandFullscreen": "Helsk\xe4rm",
            "dxDiagram-commandUnits": "Enheter",
            "dxDiagram-commandPageSize": "Sidstorlek",
            "dxDiagram-commandPageOrientation": "Orientering",
            "dxDiagram-commandPageOrientationLandscape": "Liggande",
            "dxDiagram-commandPageOrientationPortrait": "St\xe5ende",
            "dxDiagram-commandPageColor": "Sidf\xe4rg",
            "dxDiagram-commandShowGrid": "Visa rutn\xe4t",
            "dxDiagram-commandSnapToGrid": "F\xe4st mot rutn\xe4t",
            "dxDiagram-commandGridSize": "Rutn\xe4tsstorlek",
            "dxDiagram-commandZoomLevel": "Zoomniv\xe5",
            "dxDiagram-commandAutoZoom": "Autozoom",
            "dxDiagram-commandFitToContent": "Anpassa till inneh\xe5ll",
            "dxDiagram-commandFitToWidth": "Anpassa till bredd",
            "dxDiagram-commandAutoZoomByContent": "Autozoom efter inneh\xe5ll",
            "dxDiagram-commandAutoZoomByWidth": "Autozoom efter bredd",
            "dxDiagram-commandSimpleView": "F\xf6renklad vy",
            "dxDiagram-commandCut": "Klipp ut",
            "dxDiagram-commandCopy": "Kopiera",
            "dxDiagram-commandPaste": "Klistra in",
            "dxDiagram-commandSelectAll": "Markera alla",
            "dxDiagram-commandDelete": "Radera",
            "dxDiagram-commandBringToFront": "L\xe4gg \xf6verst",
            "dxDiagram-commandSendToBack": "L\xe4gg underst",
            "dxDiagram-commandLock": "L\xe5s",
            "dxDiagram-commandUnlock": "L\xe5s upp",
            "dxDiagram-commandInsertShapeImage": "Infoga bild...",
            "dxDiagram-commandEditShapeImage": "Byt bild...",
            "dxDiagram-commandDeleteShapeImage": "Radera bild",
            "dxDiagram-commandLayoutLeftToRight": "V\xe4nster till h\xf6ger",
            "dxDiagram-commandLayoutRightToLeft": "H\xf6ger till v\xe4nster",
            "dxDiagram-commandLayoutTopToBottom": "Uppifr\xe5n och ned",
            "dxDiagram-commandLayoutBottomToTop": "Nedifr\xe5n och upp",
            "dxDiagram-unitIn": "tum",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Avbryt",
            "dxDiagram-dialogInsertShapeImageTitle": "Infoga bild",
            "dxDiagram-dialogEditShapeImageTitle": "Byt bild",
            "dxDiagram-dialogEditShapeImageSelectButton": "V\xe4lj bild",
            "dxDiagram-dialogEditShapeImageLabelText": "eller sl\xe4pp en fil h\xe4r",
            "dxDiagram-uiExport": "Exportera",
            "dxDiagram-uiProperties": "Egenskaper",
            "dxDiagram-uiSettings": "Inst\xe4llningar",
            "dxDiagram-uiShowToolbox": "Visa verktygsl\xe5da",
            "dxDiagram-uiSearch": "S\xf6k",
            "dxDiagram-uiStyle": "Stil",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tr\xe4d",
            "dxDiagram-uiLayoutLayered": "Lager",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Text",
            "dxDiagram-uiObject": "Objekt",
            "dxDiagram-uiConnector": "Anslutning",
            "dxDiagram-uiPage": "Sida",
            "dxDiagram-shapeText": "Text",
            "dxDiagram-shapeRectangle": "Rektangel",
            "dxDiagram-shapeEllipse": "Ellips",
            "dxDiagram-shapeCross": "Kors",
            "dxDiagram-shapeTriangle": "Triangel",
            "dxDiagram-shapeDiamond": "Romb",
            "dxDiagram-shapeHeart": "Hj\xe4rta",
            "dxDiagram-shapePentagon": "Femh\xf6rning",
            "dxDiagram-shapeHexagon": "Sexh\xf6rning",
            "dxDiagram-shapeOctagon": "\xc5tth\xf6rning",
            "dxDiagram-shapeStar": "Stj\xe4rna",
            "dxDiagram-shapeArrowLeft": "V\xe4nsterpil",
            "dxDiagram-shapeArrowUp": "Upp\xe5tpil",
            "dxDiagram-shapeArrowRight": "H\xf6gerpil",
            "dxDiagram-shapeArrowDown": "Ned\xe5tpil",
            "dxDiagram-shapeArrowUpDown": "Upp- och nedpil",
            "dxDiagram-shapeArrowLeftRight": "V\xe4nster-h\xf6gerpil",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Beslut",
            "dxDiagram-shapeTerminator": "Avslut",
            "dxDiagram-shapePredefinedProcess": "F\xf6rdefinierad process",
            "dxDiagram-shapeDocument": "Dokument",
            "dxDiagram-shapeMultipleDocuments": "Flera dokument",
            "dxDiagram-shapeManualInput": "Manuell inmatning",
            "dxDiagram-shapePreparation": "F\xf6rberedelse",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Databas",
            "dxDiagram-shapeHardDisk": "H\xe5rddisk",
            "dxDiagram-shapeInternalStorage": "Intern lagring",
            "dxDiagram-shapePaperTape": "Papperstejp",
            "dxDiagram-shapeManualOperation": "Manuell operation",
            "dxDiagram-shapeDelay": "F\xf6rdr\xf6jning",
            "dxDiagram-shapeStoredData": "Lagrad data",
            "dxDiagram-shapeDisplay": "Visning",
            "dxDiagram-shapeMerge": "Sammanfoga",
            "dxDiagram-shapeConnector": "Anslutning",
            "dxDiagram-shapeOr": "Eller",
            "dxDiagram-shapeSummingJunction": "Summationspunkt",
            "dxDiagram-shapeContainerDefaultText": "Beh\xe5llare",
            "dxDiagram-shapeVerticalContainer": "Vertikal beh\xe5llare",
            "dxDiagram-shapeHorizontalContainer": "Horisontell beh\xe5llare",
            "dxDiagram-shapeCardDefaultText": "Personnamn",
            "dxDiagram-shapeCardWithImageOnLeft": "Kort med bild till v\xe4nster",
            "dxDiagram-shapeCardWithImageOnTop": "Kort med bild ovanf\xf6r",
            "dxDiagram-shapeCardWithImageOnRight": "Kort med bild till h\xf6ger",
            "dxGantt-dialogTitle": "Titel",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "Slut",
            "dxGantt-dialogProgressTitle": "F\xf6rlopp",
            "dxGantt-dialogResourcesTitle": "Resurser",
            "dxGantt-dialogResourceManagerTitle": "Resurshanterare",
            "dxGantt-dialogTaskDetailsTitle": "Uppgiftsdetaljer",
            "dxGantt-dialogEditResourceListHint": "Redigera resurslista",
            "dxGantt-dialogEditNoResources": "Inga resurser",
            "dxGantt-dialogButtonAdd": "L\xe4gg till",
            "dxGantt-contextMenuNewTask": "Ny uppgift",
            "dxGantt-contextMenuNewSubtask": "Ny deluppgift",
            "dxGantt-contextMenuDeleteTask": "Radera uppgift",
            "dxGantt-contextMenuDeleteDependency": "Radera beroende",
            "dxGantt-dialogTaskDeleteConfirmation": "Att radera en uppgift tar \xe4ven bort alla beroenden och deluppgifter. \xc4r du s\xe4ker p\xe5 att du vill radera denna uppgift?",
            "dxGantt-dialogDependencyDeleteConfirmation": "\xc4r du s\xe4ker p\xe5 att du vill radera beroendet fr\xe5n uppgiften?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Att radera en resurs tar \xe4ven bort den fr\xe5n tilldelade uppgifter. \xc4r du s\xe4ker p\xe5 att du vill radera dessa resurser? Resurser: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Uppgiften du f\xf6rs\xf6ker flytta \xe4r kopplad till en annan uppgift via ett beroende. Denna \xe4ndring bryter mot beroenderegler. Hur vill du forts\xe4tta?",
            "dxGantt-dialogConstraintViolationMessage": "Uppgiften du f\xf6rs\xf6ker flytta \xe4r kopplad till en annan uppgift via ett beroende. Hur vill du forts\xe4tta?",
            "dxGantt-dialogCancelOperationMessage": "Avbryt \xe5tg\xe4rden",
            "dxGantt-dialogDeleteDependencyMessage": "Radera beroendet",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Flytta uppgiften och beh\xe5ll beroendet",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "Uppgiften du f\xf6rs\xf6ker flytta \xe4r kopplad till flera andra uppgifter via beroenden. Denna \xe4ndring bryter mot beroenderegler. Hur vill du forts\xe4tta?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "Uppgiften du f\xf6rs\xf6ker flytta \xe4r kopplad till flera andra uppgifter via beroenden. Hur vill du forts\xe4tta?",
            "dxGantt-dialogDeleteDependenciesMessage": "Radera beroendena",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Flytta uppgiften och beh\xe5ll beroendena",
            "dxGantt-undo": "\xc5ngra",
            "dxGantt-redo": "G\xf6r om",
            "dxGantt-expandAll": "Expandera alla",
            "dxGantt-collapseAll": "Kollapsa alla",
            "dxGantt-addNewTask": "L\xe4gg till ny uppgift",
            "dxGantt-deleteSelectedTask": "Radera vald uppgift",
            "dxGantt-zoomIn": "Zooma in",
            "dxGantt-zoomOut": "Zooma ut",
            "dxGantt-fullScreen": "Helsk\xe4rm",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sortera stigande",
            "dxGantt-sortingDescendingText": "Sortera fallande",
            "dxGantt-sortingClearText": "Rensa sortering",
            "dxGantt-showResources": "Visa resurser",
            "dxGantt-showDependencies": "Visa beroenden",
            "dxGantt-dialogStartDateValidation": "Startdatum m\xe5ste vara efter {0}",
            "dxGantt-dialogEndDateValidation": "Slutdatum m\xe5ste vara efter {0}",
            "dxGallery-itemName": "Gallerielement",
            "dxMultiView-elementAriaRoleDescription": "Fler vyer",
            "dxMultiView-elementAriaLabel": "Anv\xe4nd piltangenterna eller svep f\xf6r att v\xe4xla mellan vyer",
            "dxMultiView-itemAriaRoleDescription": "Vy",
            "dxMultiView-itemAriaLabel": "{0} av {1}",
            "dxSplitter-resizeHandleAriaLabel": "Delningslist",
            "dxSplitter-resizeHandleAriaRoleDescription": "Avgr\xe4nsare",
            "dxStepper-optionalMark": "(Valfritt)",
            "dxSpeechToText-ariaLabelStart": "Tryck f\xf6r att starta r\xf6sttranskribering",
            "dxSpeechToText-ariaLabelStop": "Tryck f\xf6r att stoppa r\xf6sttranskribering"
        }
    })
}));
