/*!
* DevExtreme (dx.messages.pt.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        pt: {
            Yes: "Sim",
            No: "N\xe3o",
            Cancel: "Cancelar",
            CheckState: "Verificar estado",
            Close: "Fechar",
            Clear: "Limpar",
            Done: "Conclu\xeddo",
            Loading: "Carregando ...",
            Select: "Selecione ...",
            Search: "Pesquisar ...",
            Back: "Voltar",
            OK: "OK",
            Today: "Hoje",
            Yesterday: "Ontem",
            "dxCollectionWidget-noDataText": "Sem dados",
            "dxDropDownEditor-selectLabel": "Selecione",
            "validation-required": "Preenchimento obrigat\xf3rio",
            "validation-required-formatted": "{0} \xe9 de preenchimento obrigat\xf3rio",
            "validation-numeric": "Valor deve ser um n\xfamero",
            "validation-numeric-formatted": "{0} deve ser um n\xfamero",
            "validation-range": "Valor est\xe1 fora do intervalo",
            "validation-range-formatted": "{0} est\xe1 fora do intervalo",
            "validation-stringLength": "O comprimento do valor n\xe3o est\xe1 correto",
            "validation-stringLength-formatted": "O comprimento de {0} n\xe3o est\xe1 correto",
            "validation-custom": "Valor inv\xe1lido",
            "validation-custom-formatted": "{0} \xe9 inv\xe1lido",
            "validation-async": "Valor inv\xe1lido",
            "validation-async-formatted": "{0} \xe9 inv\xe1lido",
            "validation-compare": "Valores n\xe3o coincidem",
            "validation-compare-formatted": "{0} n\xe3o coincidem",
            "validation-pattern": "Valor n\xe3o corresponde ao padr\xe3o",
            "validation-pattern-formatted": "{0} n\xe3o corresponde ao padr\xe3o",
            "validation-email": "Email inv\xe1lido",
            "validation-email-formatted": "{0} \xe9 inv\xe1lido",
            "validation-mask": "Valor inv\xe1lido",
            "dxLookup-searchPlaceholder": "N\xfamero m\xednimo de caracteres: {0}",
            "dxList-pullingDownText": "Puxar para baixo para recarregar...",
            "dxList-pulledDownText": "Soltar para recarregar...",
            "dxList-refreshingText": "Recarregando ...",
            "dxList-pageLoadingText": "A carregar ...",
            "dxList-nextButtonText": "Mais",
            "dxList-selectAll": "Selecionar todos",
            "dxList-listAriaLabel": "Itens",
            "dxList-listAriaLabel-deletable": "Itens delet\xe1veis",
            "dxListEditDecorator-delete": "Eliminar",
            "dxListEditDecorator-more": "Mais",
            "dxList-selectAll-indeterminate": "Meio marcado",
            "dxList-selectAll-checked": "Marcado",
            "dxList-selectAll-notChecked": "N\xe3o marcado",
            "dxList-ariaRoleDescription": "List",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Puxar para baixo para recarregar...",
            "dxScrollView-pulledDownText": "Soltar para recarregar...",
            "dxScrollView-refreshingText": "Recarregando ...",
            "dxScrollView-reachBottomText": "A carregar ...",
            "dxDateBox-simulatedDataPickerTitleTime": "Selecionar hora",
            "dxDateBox-simulatedDataPickerTitleDate": "Selecionar data",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Selecionar data e hora",
            "dxDateBox-validation-datetime": "Valor deve ser uma data ou hora",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Data de In\xedcio",
            "dxDateRangeBox-endDateLabel": "Data Final",
            "dxFileUploader-selectFile": "Selecionar arquivo",
            "dxFileUploader-dropFile": "ou Soltar arquivo aqui",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Upload",
            "dxFileUploader-uploaded": "Upload conclu\xeddo",
            "dxFileUploader-readyToUpload": "Pronto para upload",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelado",
            "dxFileUploader-uploadFailedMessage": "Upload falhou",
            "dxFileUploader-invalidFileExtension": "Tipo de arquivo n\xe3o \xe9 permitido",
            "dxFileUploader-invalidMaxFileSize": "O arquivo \xe9 muito grande",
            "dxFileUploader-invalidMinFileSize": "O arquivo \xe9 muito pequeno",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "De {0}",
            "dxRangeSlider-ariaTill": "At\xe9 {0}",
            "dxSwitch-switchedOnText": "LIGADO",
            "dxSwitch-switchedOffText": "DESLIGADO",
            "dxForm-optionalMark": "opcional",
            "dxForm-requiredMessage": "{0} \xe9 de preenchimento obrigat\xf3rio",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "Limpar",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "Valor deve ser um n\xfamero",
            "dxNumberBox-noDataText": "Sem dados",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} para exibir colunas",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Arraste uma coluna do painel do grupo aqui",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} ou arraste uma coluna do painel do grupo",
            "dxDataGrid-emptyHeaderColumnChooserText": "seletor de coluna",
            "dxDataGrid-columnChooserTitle": "Seletor de Colunas",
            "dxDataGrid-columnChooserEmptyText": "Arraste uma coluna para at\xe9 aqui para escond\xea-la",
            "dxDataGrid-groupContinuesMessage": "Continua na p\xe1gina seguinte",
            "dxDataGrid-groupContinuedMessage": "Continua\xe7\xe3o da p\xe1gina anterior",
            "dxDataGrid-groupHeaderText": "Agrupar pela coluna",
            "dxDataGrid-ungroupHeaderText": "Remover grupo",
            "dxDataGrid-ungroupAllText": "Remover todos os grupos",
            "dxDataGrid-editingEditRow": "Editar",
            "dxDataGrid-editingSaveRowChanges": "Salvar",
            "dxDataGrid-editingCancelRowChanges": "Cancelar",
            "dxDataGrid-editingDeleteRow": "Eliminar",
            "dxDataGrid-editingUndeleteRow": "Recuperar",
            "dxDataGrid-editingConfirmDeleteMessage": "Tem certeza que deseja eliminar este registro?",
            "dxDataGrid-validationCancelChanges": "Cancelar altera\xe7\xf5es",
            "dxDataGrid-groupPanelEmptyText": "Arrastar o cabe\xe7alho de uma coluna para aqui para agrupar por essa coluna",
            "dxDataGrid-noDataText": "Sem dados",
            "dxDataGrid-searchPanelPlaceholder": "Pesquisar ...",
            "dxDataGrid-filterRowShowAllText": "(Todos)",
            "dxDataGrid-filterRowResetOperationText": "Limpar",
            "dxDataGrid-filterRowOperationEquals": "Igual",
            "dxDataGrid-filterRowOperationNotEquals": "Diferente",
            "dxDataGrid-filterRowOperationLess": "Menor que",
            "dxDataGrid-filterRowOperationLessOrEquals": "Menor que ou igual a",
            "dxDataGrid-filterRowOperationGreater": "Maior que",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Maior que ou igual a",
            "dxDataGrid-filterRowOperationStartsWith": "Come\xe7a com",
            "dxDataGrid-filterRowOperationContains": "Cont\xe9m",
            "dxDataGrid-filterRowOperationNotContains": "N\xe3o cont\xe9m",
            "dxDataGrid-filterRowOperationEndsWith": "Termina com",
            "dxDataGrid-filterRowOperationBetween": "Entre",
            "dxDataGrid-filterRowOperationBetweenStartText": "In\xedcio",
            "dxDataGrid-filterRowOperationBetweenEndText": "Fim",
            "dxDataGrid-ariaSearchBox": "Caixa de pesquisa",
            "dxDataGrid-applyFilterText": "Aplicar filtro",
            "dxDataGrid-trueText": "verdadeiro",
            "dxDataGrid-falseText": "falso",
            "dxDataGrid-sortingAscendingText": "Ordenar ascendentemente",
            "dxDataGrid-sortingDescendingText": "Ordenar descendentemente",
            "dxDataGrid-sortingClearText": "Limpar ordena\xe7\xe3o",
            "dxDataGrid-ariaNotSortedColumn": "Coluna n\xe3o ordenada",
            "dxDataGrid-ariaSortedAscendingColumn": "Coluna ordenada em ordem crescente",
            "dxDataGrid-ariaSortedDescendingColumn": "Coluna ordenada em ordem decrescente",
            "dxDataGrid-ariaSortIndex": "\xcdndice de ordena\xe7\xe3o {0}",
            "dxDataGrid-editingSaveAllChanges": "Salvar todas as altera\xe7\xf5es",
            "dxDataGrid-editingCancelAllChanges": "Descartar altera\xe7\xf5es",
            "dxDataGrid-editingAddRow": "Adicionar uma linha",
            "dxDataGrid-summaryMin": "M\xedn: {0}",
            "dxDataGrid-summaryMinOtherColumn": "M\xedn de {1} \xe9 {0}",
            "dxDataGrid-summaryMax": "M\xe1x: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "M\xe1x de {1} \xe9 {0}",
            "dxDataGrid-summaryAvg": "M\xe9d: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "M\xe9dia de {1} \xe9 {0}",
            "dxDataGrid-summarySum": "Soma: {0}",
            "dxDataGrid-summarySumOtherColumn": "Soma de {1} \xe9 {0}",
            "dxDataGrid-summaryCount": "Contagem: {0}",
            "dxDataGrid-columnFixingFix": "Definir posi\xe7\xe3o fixa",
            "dxDataGrid-columnFixingUnfix": "Desfixar",
            "dxDataGrid-columnFixingLeftPosition": "Esquerda",
            "dxDataGrid-columnFixingRightPosition": "Direita",
            "dxDataGrid-columnFixingStickyPosition": "Fixo",
            "dxDataGrid-exportTo": "Exportar para",
            "dxDataGrid-exportToExcel": "Exportar para Excel",
            "dxDataGrid-exporting": "Exportar...",
            "dxDataGrid-excelFormat": "Planilha Excel",
            "dxDataGrid-selectedRows": "Linhas selecionadas",
            "dxDataGrid-exportSelectedRows": "Exportar linhas selecionadas",
            "dxDataGrid-exportAll": "Exportar todos os dados",
            "dxDataGrid-headerFilterLabel": "Op\xe7\xf5es de filtro",
            "dxDataGrid-headerFilterIndicatorLabel": "Mostrar op\xe7\xf5es de filtro para coluna '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Vazio)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Cancelar",
            "dxDataGrid-ariaAdaptiveCollapse": "Ocultar dados adicionais",
            "dxDataGrid-ariaAdaptiveExpand": "Exibir dados adicionais",
            "dxDataGrid-ariaColumn": "Coluna",
            "dxDataGrid-ariaColumnHeader": "Cabe\xe7alho da coluna",
            "dxDataGrid-ariaValue": "Valor",
            "dxDataGrid-ariaError": "Erro",
            "dxDataGrid-ariaRevertButton": "Pressione Escape para descartar as altera\xe7\xf5es",
            "dxDataGrid-ariaFilterCell": "Filtro de c\xe9lula",
            "dxDataGrid-ariaCollapse": "Contrair",
            "dxDataGrid-ariaModifiedCell": "Modificado",
            "dxDataGrid-ariaDeletedCell": "Deletado",
            "dxDataGrid-ariaEditableCell": "Edit\xe1vel",
            "dxDataGrid-ariaExpand": "Expandir",
            "dxDataGrid-ariaCollapsedRow": "Linha recolhida",
            "dxDataGrid-ariaExpandedRow": "Linha expandida",
            "dxDataGrid-ariaDataGrid": "Grelha de dados",
            "dxDataGrid-ariaSearchInGrid": "Pesquisar na grade de dados",
            "dxDataGrid-ariaSelectAll": "Selecionar todos",
            "dxDataGrid-ariaSelectRow": "Selecionar linha",
            "dxDataGrid-ariaToolbar": "Barra de ferramentas da grade de dados",
            "dxDataGrid-ariaEditForm": "Formul\xe1rio de edi\xe7\xe3o",
            "dxDataGrid-filterBuilderPopupTitle": "Construtor de filtro",
            "dxDataGrid-filterPanelCreateFilter": "Criar filtro",
            "dxDataGrid-filterPanelClearFilter": "Limpar",
            "dxDataGrid-filterPanelFilterEnabledHint": "Habilitar o filtro",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Pesquisar na lista de \xe1rvores",
            "dxTreeList-ariaToolbar": "Barra de ferramentas da lista de \xe1rvores",
            "dxTreeList-editingAddRowToNode": "Adicionar",
            "dxPager-infoText": "P\xe1gina {0} de {1} ({2} itens)",
            "dxPager-pagesCountText": "de",
            "dxPager-pageSize": "Itens por p\xe1gina: {0}",
            "dxPager-pageSizesAllText": "Todos",
            "dxPager-page": "P\xe1gina {0}",
            "dxPager-prevPage": "P\xe1gina anterior",
            "dxPager-nextPage": "Pr\xf3xima p\xe1gina",
            "dxPager-ariaLabel": "Navega\xe7\xe3o na p\xe1gina",
            "dxPager-ariaPageSize": "Tamanho da p\xe1gina",
            "dxPager-ariaPageNumber": "N\xfamero de p\xe1ginas",
            "dxPagination-infoText": "P\xe1gina {0} de {1} ({2} itens)",
            "dxPagination-pagesCountText": "de",
            "dxPagination-pageSize": "Itens por p\xe1gina: {0}",
            "dxPagination-pageSizesAllText": "Todos",
            "dxPagination-page": "P\xe1gina {0}",
            "dxPagination-prevPage": "P\xe1gina anterior",
            "dxPagination-nextPage": "Pr\xf3xima p\xe1gina",
            "dxPagination-ariaLabel": "Navega\xe7\xe3o na p\xe1gina",
            "dxPagination-ariaPageSize": "Tamanho da p\xe1gina",
            "dxPagination-ariaPageNumber": "N\xfamero de p\xe1ginas",
            "dxPivotGrid-grandTotal": "Grande Total",
            "dxPivotGrid-total": "{0} Total",
            "dxPivotGrid-fieldChooserTitle": "Seletor de Colunas",
            "dxPivotGrid-showFieldChooser": "Mostrar Seletor de Colunas",
            "dxPivotGrid-expandAll": "Expandir Tudo",
            "dxPivotGrid-collapseAll": "Contrair Tudo",
            "dxPivotGrid-sortColumnBySummary": 'Ordenar "{0}" por esta Coluna',
            "dxPivotGrid-sortRowBySummary": 'Ordenar "{0}" por esta Linha',
            "dxPivotGrid-removeAllSorting": "Remover Todas as Ordena\xe7\xf5es",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "Campos de Linha",
            "dxPivotGrid-columnFields": "Campos de Coluna",
            "dxPivotGrid-dataFields": "Campos de Dados",
            "dxPivotGrid-filterFields": "Campos de Filtro",
            "dxPivotGrid-allFields": "Todos os Campos",
            "dxPivotGrid-columnFieldArea": "Arraste os campos de coluna at\xe9 aqui",
            "dxPivotGrid-dataFieldArea": "Arraste os campos de dados at\xe9 aqui",
            "dxPivotGrid-rowFieldArea": "Arraste os campos de linha at\xe9 aqui",
            "dxPivotGrid-filterFieldArea": "Arraste os campos de filtro at\xe9 aqui",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Grupo: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Compromisso recorrente",
            "dxScheduler-appointmentListAriaLabel": "Lista de compromissos",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Assunto",
            "dxScheduler-editorLabelStartDate": "Data de In\xedcio",
            "dxScheduler-editorLabelEndDate": "Data Final",
            "dxScheduler-editorLabelDescription": "Descri\xe7\xe3o",
            "dxScheduler-editorLabelRecurrence": "Repetir",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "P\xe1gina anterior",
            "dxScheduler-navigationNext": "Pr\xf3xima p\xe1gina",
            "dxScheduler-openAppointment": "Abrir compromisso",
            "dxScheduler-recurrenceNever": "Nunca",
            "dxScheduler-recurrenceMinutely": "Minuciosamente",
            "dxScheduler-recurrenceHourly": "De hora em hora",
            "dxScheduler-recurrenceDaily": "Diariamente",
            "dxScheduler-recurrenceWeekly": "Semanalmente",
            "dxScheduler-recurrenceMonthly": "Mensalmente",
            "dxScheduler-recurrenceYearly": "Anualmente",
            "dxScheduler-recurrenceRepeatEvery": "Todos",
            "dxScheduler-recurrenceRepeatOn": "Repetir em",
            "dxScheduler-recurrenceEnd": "Fim da repeti\xe7\xe3o",
            "dxScheduler-recurrenceAfter": "Depois de",
            "dxScheduler-recurrenceOn": "A",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minuto(s)",
            "dxScheduler-recurrenceRepeatHourly": "hora(s)",
            "dxScheduler-recurrenceRepeatDaily": "dia(s)",
            "dxScheduler-recurrenceRepeatWeekly": "semana(s)",
            "dxScheduler-recurrenceRepeatMonthly": "m\xeas(es)",
            "dxScheduler-recurrenceRepeatYearly": "ano(s)",
            "dxScheduler-switcherDay": "Dia",
            "dxScheduler-switcherWeek": "Semana",
            "dxScheduler-switcherWorkWeek": "Dias \xfateis",
            "dxScheduler-switcherMonth": "M\xeas",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Linha de tempo Dia",
            "dxScheduler-switcherTimelineWeek": "Linha de tempo Semana",
            "dxScheduler-switcherTimelineWorkWeek": "Linha de tempo Dias \xfateis",
            "dxScheduler-switcherTimelineMonth": "Linha de tempo M\xeas",
            "dxScheduler-recurrenceRepeatOnDate": "na data",
            "dxScheduler-recurrenceRepeatCount": "ocorr\xeancia(s)",
            "dxScheduler-allDay": "Todo o dia",
            "dxScheduler-ariaEditForm": "Editar formul\xe1rio",
            "dxScheduler-confirmRecurrenceEditTitle": "Editar compromisso recorrente",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Excluir compromisso recorrente",
            "dxScheduler-confirmRecurrenceEditMessage": "Deseja editar s\xf3 este compromisso ou a s\xe9rie toda?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Deseja eliminar s\xf3 este compromisso ou a s\xe9rie toda?",
            "dxScheduler-confirmRecurrenceEditSeries": "Editar s\xe9rie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Eliminar s\xe9rie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Editar compromisso",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Eliminar compromisso",
            "dxScheduler-noTimezoneTitle": "Sem fuso hor\xe1rio",
            "dxScheduler-moreAppointments": "{0} mais",
            "dxCalendar-currentDay": "Hoje",
            "dxCalendar-currentMonth": "M\xeas atual",
            "dxCalendar-currentYear": "Ano atual",
            "dxCalendar-currentYearRange": "Intervalo de ano atual",
            "dxCalendar-todayButtonText": "Hoje",
            "dxCalendar-ariaWidgetName": "Calend\xe1rio",
            "dxCalendar-previousMonthButtonLabel": "M\xeas anterior",
            "dxCalendar-previousYearButtonLabel": "Ano anterior",
            "dxCalendar-previousDecadeButtonLabel": "D\xe9cada anterior",
            "dxCalendar-previousCenturyButtonLabel": "S\xe9culo anterior",
            "dxCalendar-nextMonthButtonLabel": "Pr\xf3ximo m\xeas",
            "dxCalendar-nextYearButtonLabel": "Pr\xf3ximo ano",
            "dxCalendar-nextDecadeButtonLabel": "Pr\xf3xima d\xe9cada",
            "dxCalendar-nextCenturyButtonLabel": "Pr\xf3ximo s\xe9culo",
            "dxCalendar-captionMonthLabel": "Sele\xe7\xe3o de m\xeas",
            "dxCalendar-captionYearLabel": "Sele\xe7\xe3o de ano",
            "dxCalendar-captionDecadeLabel": "Sele\xe7\xe3o de d\xe9cada",
            "dxCalendar-captionCenturyLabel": "Sele\xe7\xe3o de s\xe9culo",
            "dxCalendar-selectedDate": "A data selecionada \xe9 {0}",
            "dxCalendar-selectedDates": "As datas selecionadas",
            "dxCalendar-selectedDateRange": "O intervalo de datas selecionado \xe9 de {0} a {1}",
            "dxCalendar-selectedMultipleDateRange": "de {0} a {1}",
            "dxCalendar-selectedDateRangeCount": "H\xe1 {0} intervalos de datas selecionados",
            "dxCalendar-readOnlyLabel": "Calend\xe1rio somente leitura",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Digite uma mensagem",
            "dxChat-sendButtonAriaLabel": "Enviar",
            "dxChat-cancelEditingButtonAriaLabel": "Cancelar",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Usu\xe1rio desconhecido",
            "dxChat-messageListAriaLabel": "Lista de mensagens",
            "dxChat-alertListAriaLabel": "Lista de erros",
            "dxChat-emptyListMessage": "N\xe3o h\xe1 mensagens neste chat",
            "dxChat-emptyListPrompt": "Escreva sua primeira mensagem",
            "dxChat-typingMessageSingleUser": "{0} est\xe1 digitando...",
            "dxChat-typingMessageTwoUsers": "{0} e {1} est\xe3o digitando...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} e {2} est\xe3o digitando...",
            "dxChat-typingMessageMultipleUsers": "{0} e outros est\xe3o digitando...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "Editar",
            "dxChat-editingDeleteMessage": "Eliminar",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "Vermelho",
            "dxColorView-ariaGreen": "Verde",
            "dxColorView-ariaBlue": "Azul",
            "dxColorView-ariaAlpha": "Transpar\xeancia",
            "dxColorView-ariaHex": "C\xf3digo de cor",
            "dxTagBox-selected": "{0} selecionados",
            "dxTagBox-allSelected": "Todos selecionados ({0})",
            "dxTagBox-moreSelected": "{0} mais",
            "dxTagBox-tagRoleDescription": "Tag. Pressione o bot\xe3o de deletar para remover esta tag",
            "dxTagBox-ariaRoleDescription": "Tag box",
            "vizExport-printingButtonText": "Imprimir",
            "vizExport-titleMenuText": "Exportar/Imprimir",
            "vizExport-exportButtonText": "{0}-Arquivo",
            "dxFilterBuilder-and": "E",
            "dxFilterBuilder-or": "OU",
            "dxFilterBuilder-notAnd": "N\xc3O E",
            "dxFilterBuilder-notOr": "N\xc3O OU",
            "dxFilterBuilder-addCondition": "Adicionar condi\xe7\xe3o",
            "dxFilterBuilder-addGroup": "Adicionar Grupo",
            "dxFilterBuilder-enterValueText": "<preencha com um valor>",
            "dxFilterBuilder-filterOperationEquals": "Igual",
            "dxFilterBuilder-filterOperationNotEquals": "Diferente",
            "dxFilterBuilder-filterOperationLess": "Menor que",
            "dxFilterBuilder-filterOperationLessOrEquals": "Menor ou igual que",
            "dxFilterBuilder-filterOperationGreater": "Maior que",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Maior ou igual que",
            "dxFilterBuilder-filterOperationStartsWith": "Come\xe7a com",
            "dxFilterBuilder-filterOperationContains": "Cont\xe9m",
            "dxFilterBuilder-filterOperationNotContains": "N\xe3o cont\xe9m",
            "dxFilterBuilder-filterOperationEndsWith": "Termina com",
            "dxFilterBuilder-filterOperationIsBlank": "\xc9 vazio",
            "dxFilterBuilder-filterOperationIsNotBlank": "N\xe3o \xe9 vazio",
            "dxFilterBuilder-filterOperationBetween": "Entre",
            "dxFilterBuilder-filterOperationAnyOf": "Algum de",
            "dxFilterBuilder-filterOperationNoneOf": "Nenhum de",
            "dxFilterBuilder-filterAriaRootElement": "Construtor de filtro",
            "dxFilterBuilder-filterAriaGroupLevel": "N\xedvel {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Item de grupo",
            "dxFilterBuilder-filterAriaOperationButton": "Opera\xe7\xe3o",
            "dxFilterBuilder-filterAriaAddButton": "Adicionar",
            "dxFilterBuilder-filterAriaRemoveButton": "Remover {0}",
            "dxFilterBuilder-filterAriaItemField": "Campo do item",
            "dxFilterBuilder-filterAriaItemOperation": "Opera\xe7\xe3o do item",
            "dxFilterBuilder-filterAriaItemValue": "Valor do item",
            "dxHtmlEditor-dialogColorCaption": "Alterar cor da fonte",
            "dxHtmlEditor-dialogBackgroundCaption": "Alterar cor de plano de fundo",
            "dxHtmlEditor-dialogLinkCaption": "Adicionar link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Texto",
            "dxHtmlEditor-dialogLinkTargetField": "Abrir link em nova janela",
            "dxHtmlEditor-dialogImageCaption": "Adicionar imagem",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Texto alternativo",
            "dxHtmlEditor-dialogImageWidthField": "Largura (px)",
            "dxHtmlEditor-dialogImageHeightField": "Altura (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Linhas",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Colunas",
            "dxHtmlEditor-dialogInsertTableCaption": "Inserir tabela",
            "dxHtmlEditor-dialogUpdateImageCaption": "Atualizar imagem",
            "dxHtmlEditor-dialogImageUpdateButton": "Atualizar",
            "dxHtmlEditor-dialogImageAddButton": "Adicionar",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Da web",
            "dxHtmlEditor-dialogImageSelectFile": "Deste dispositivo",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Manter a propor\xe7\xe3o",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Codificar para Base64",
            "dxHtmlEditor-heading": "Cabe\xe7alho",
            "dxHtmlEditor-normalText": "Texto normal",
            "dxHtmlEditor-background": "Cor de fundo",
            "dxHtmlEditor-bold": "Negrito",
            "dxHtmlEditor-color": "Cor da fonte",
            "dxHtmlEditor-font": "Fonte",
            "dxHtmlEditor-italic": "It\xe1lico",
            "dxHtmlEditor-link": "Adicionar link",
            "dxHtmlEditor-image": "Adicionar imagem",
            "dxHtmlEditor-size": "Tamanho",
            "dxHtmlEditor-strike": "Tachado",
            "dxHtmlEditor-subscript": "Subscrito",
            "dxHtmlEditor-superscript": "Sobrescrito",
            "dxHtmlEditor-underline": "Sublinhado",
            "dxHtmlEditor-blockquote": "Bloco de cita\xe7\xe3o",
            "dxHtmlEditor-header": "Cabe\xe7alho",
            "dxHtmlEditor-increaseIndent": "Aumentar recuo",
            "dxHtmlEditor-decreaseIndent": "Diminuir recuo",
            "dxHtmlEditor-orderedList": "Lista ordenada",
            "dxHtmlEditor-bulletList": "Lista de marcadores",
            "dxHtmlEditor-alignLeft": "Alinhar \xe0 esquerda",
            "dxHtmlEditor-alignCenter": "Alinhar no centro",
            "dxHtmlEditor-alignRight": "Alinhar \xe0 direita",
            "dxHtmlEditor-alignJustify": "Justificar",
            "dxHtmlEditor-codeBlock": "Bloco de c\xf3digo",
            "dxHtmlEditor-variable": "Adicionar vari\xe1vel",
            "dxHtmlEditor-undo": "Desfazer",
            "dxHtmlEditor-redo": "Refazer",
            "dxHtmlEditor-clear": "Limpar formata\xe7\xe3o",
            "dxHtmlEditor-insertTable": "Inserir tabela",
            "dxHtmlEditor-insertHeaderRow": "Inserir linha de cabe\xe7alho",
            "dxHtmlEditor-insertRowAbove": "Inserir linha acima",
            "dxHtmlEditor-insertRowBelow": "Inserir linha abaixo",
            "dxHtmlEditor-insertColumnLeft": "Inserir coluna \xe0 esquerda",
            "dxHtmlEditor-insertColumnRight": "Inserir coluna \xe0 direita",
            "dxHtmlEditor-deleteColumn": "Deletar coluna",
            "dxHtmlEditor-deleteRow": "Deletar linha",
            "dxHtmlEditor-deleteTable": "Deletar tabela",
            "dxHtmlEditor-cellProperties": "Propriedades da c\xe9lula",
            "dxHtmlEditor-tableProperties": "Propriedades da tabela",
            "dxHtmlEditor-insert": "Inserir",
            "dxHtmlEditor-delete": "Deletar",
            "dxHtmlEditor-border": "Bordas",
            "dxHtmlEditor-style": "Estilo",
            "dxHtmlEditor-width": "Largura",
            "dxHtmlEditor-height": "Altura",
            "dxHtmlEditor-borderColor": "Cor",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Fundo",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alinhamento",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Preenchimento vertical",
            "dxHtmlEditor-paddingHorizontal": "Preenchimento horizontal",
            "dxHtmlEditor-pixels": "P\xedxeis",
            "dxHtmlEditor-list": "Lista",
            "dxHtmlEditor-ordered": "Ordenado",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Alinhar",
            "dxHtmlEditor-center": "Centro",
            "dxHtmlEditor-left": "Esquerda",
            "dxHtmlEditor-right": "Direita",
            "dxHtmlEditor-indent": "Recuar",
            "dxHtmlEditor-justify": "Justificar",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Diret\xf3rio sem t\xedtulo",
            "dxFileManager-rootDirectoryName": "Arquivos",
            "dxFileManager-errorNoAccess": "Acesso negado. A opera\xe7\xe3o n\xe3o p\xf4de ser conclu\xedda.",
            "dxFileManager-errorDirectoryExistsFormat": "O diret\xf3rio '{0}' j\xe1 existe.",
            "dxFileManager-errorFileExistsFormat": "O arquivo '{0}' j\xe1 existe.",
            "dxFileManager-errorFileNotFoundFormat": "Arquivo '{0}' n\xe3o encontrado.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Diret\xf3rio '{0}' n\xe3o encontrado.",
            "dxFileManager-errorWrongFileExtension": "A extens\xe3o do arquivo n\xe3o \xe9 permitida.",
            "dxFileManager-errorMaxFileSizeExceeded": "O tamanho do arquivo excede o tamanho m\xe1ximo permitido.",
            "dxFileManager-errorInvalidSymbols": "Este nome cont\xe9m caracteres inv\xe1lidos.",
            "dxFileManager-errorDefault": "Erro n\xe3o especificado.",
            "dxFileManager-errorDirectoryOpenFailed": "O diret\xf3rio n\xe3o pode ser aberto",
            "dxFileManager-commandCreate": "Novo diret\xf3rio",
            "dxFileManager-commandRename": "Renomear",
            "dxFileManager-commandMove": "Mover para",
            "dxFileManager-commandCopy": "Copiar para",
            "dxFileManager-commandDelete": "Deletar",
            "dxFileManager-commandDownload": "Baixar",
            "dxFileManager-commandUpload": "Fazer upload de arquivos",
            "dxFileManager-commandRefresh": "Atualizar",
            "dxFileManager-commandThumbnails": "Exibir miniaturas",
            "dxFileManager-commandDetails": "Ver detalhes",
            "dxFileManager-commandClearSelection": "Limpar sele\xe7\xe3o",
            "dxFileManager-commandShowNavPane": "Alternar painel de navega\xe7\xe3o",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Mover para",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Mover",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copiar para",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copiar",
            "dxFileManager-dialogRenameItemTitle": "Renomear",
            "dxFileManager-dialogRenameItemButtonText": "Salvar",
            "dxFileManager-dialogCreateDirectoryTitle": "Novo diret\xf3rio",
            "dxFileManager-dialogCreateDirectoryButtonText": "Criar",
            "dxFileManager-dialogDeleteItemTitle": "Deletar",
            "dxFileManager-dialogDeleteItemButtonText": "Deletar",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Tem certeza de que deseja excluir {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Tem certeza de que deseja excluir {0} itens?",
            "dxFileManager-dialogButtonCancel": "Cancelar",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Criando um diret\xf3rio dentro de {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Criou um diret\xf3rio dentro de {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "O diret\xf3rio n\xe3o foi criado",
            "dxFileManager-editingCreateCommonErrorMessage": "O diret\xf3rio n\xe3o foi criado",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renomeando um item dentro de {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renomeou um item dentro de {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "O item n\xe3o foi renomeado",
            "dxFileManager-editingRenameCommonErrorMessage": "O item n\xe3o foi renomeado",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Excluindo um item de {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Excluindo {0} itens de {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Excluiu um item de {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "{0} itens exclu\xeddos de {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "O item n\xe3o foi exclu\xeddo",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} itens n\xe3o foram exclu\xeddos",
            "dxFileManager-editingDeleteCommonErrorMessage": "Alguns itens n\xe3o foram exclu\xeddos",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Movendo um item para {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Movendo {0} itens para {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moveu um item para {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Movidos {0} itens para {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "O item n\xe3o foi movido",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} itens n\xe3o foram movidos",
            "dxFileManager-editingMoveCommonErrorMessage": "Alguns itens n\xe3o foram movidos",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copiando um item para {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copiando {0} itens para {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copiou um item para {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copiou {0} itens para {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "O item n\xe3o foi copiado",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} itens n\xe3o foram copiados",
            "dxFileManager-editingCopyCommonErrorMessage": "Alguns itens n\xe3o foram copiados",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Carregando um item para {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Fazendo upload de {0} itens para {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Carregou um item para {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Carregado {0} itens para {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "O item n\xe3o foi carregado",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} itens n\xe3o foram carregados",
            "dxFileManager-editingUploadCanceledMessage": "Cancelado",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "O item n\xe3o foi baixado",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} itens n\xe3o foram baixados",
            "dxFileManager-listDetailsColumnCaptionName": "Nome",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Data de modifica\xe7\xe3o",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Tamanho do arquivo",
            "dxFileManager-listThumbnailsTooltipTextSize": "Tamanho",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Data de modifica\xe7\xe3o",
            "dxFileManager-notificationProgressPanelTitle": "Progresso",
            "dxFileManager-notificationProgressPanelEmptyListText": "Nenhuma opera\xe7\xe3o",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Cancelado",
            "dxDiagram-categoryGeneral": "Geral",
            "dxDiagram-categoryFlowchart": "Fluxograma",
            "dxDiagram-categoryOrgChart": "Organograma",
            "dxDiagram-categoryContainers": "Cont\xeaineres",
            "dxDiagram-categoryCustom": "Personalizado",
            "dxDiagram-commandExportToSvg": "Exportar para SVG",
            "dxDiagram-commandExportToPng": "Exportar para PNG",
            "dxDiagram-commandExportToJpg": "Exportar para JPG",
            "dxDiagram-commandUndo": "Desfazer",
            "dxDiagram-commandRedo": "Refazer",
            "dxDiagram-commandFontName": "Nome da fonte",
            "dxDiagram-commandFontSize": "Tamanho da fonte",
            "dxDiagram-commandBold": "Negrito",
            "dxDiagram-commandItalic": "It\xe1lico",
            "dxDiagram-commandUnderline": "Sublinhado",
            "dxDiagram-commandTextColor": "Cor da fonte",
            "dxDiagram-commandLineColor": "Cor da linha",
            "dxDiagram-commandLineWidth": "Espessura da linha",
            "dxDiagram-commandLineStyle": "Estilo da linha",
            "dxDiagram-commandLineStyleSolid": "S\xf3lido",
            "dxDiagram-commandLineStyleDotted": "Pontilhado",
            "dxDiagram-commandLineStyleDashed": "Tracejado",
            "dxDiagram-commandFillColor": "Cor de preenchimento",
            "dxDiagram-commandAlignLeft": "Alinhar \xe0 esquerda",
            "dxDiagram-commandAlignCenter": "Centralizar horizontalmente",
            "dxDiagram-commandAlignRight": "Alinhar \xe0 direita",
            "dxDiagram-commandConnectorLineType": "Tipo de conex\xe3o",
            "dxDiagram-commandConnectorLineStraight": "Reto",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonal",
            "dxDiagram-commandConnectorLineStart": "Conector de in\xedcio de linha",
            "dxDiagram-commandConnectorLineEnd": "Conector de fim de linha",
            "dxDiagram-commandConnectorLineNone": "Nenhum",
            "dxDiagram-commandConnectorLineArrow": "Flecha",
            "dxDiagram-commandFullscreen": "Tela cheia",
            "dxDiagram-commandUnits": "Unidades",
            "dxDiagram-commandPageSize": "Tamanho da p\xe1gina",
            "dxDiagram-commandPageOrientation": "Orienta\xe7\xe3o",
            "dxDiagram-commandPageOrientationLandscape": "Paiagem",
            "dxDiagram-commandPageOrientationPortrait": "Retrato",
            "dxDiagram-commandPageColor": "Cor da p\xe1gina",
            "dxDiagram-commandShowGrid": "Mostrar grade",
            "dxDiagram-commandSnapToGrid": "Ajustar \xe0 grade",
            "dxDiagram-commandGridSize": "Tamanho da grade",
            "dxDiagram-commandZoomLevel": "N\xedvel de zoom",
            "dxDiagram-commandAutoZoom": "Zoom autom\xe1tico",
            "dxDiagram-commandFitToContent": "Ajustar ao conte\xfado",
            "dxDiagram-commandFitToWidth": "Ajustar \xe0 largura",
            "dxDiagram-commandAutoZoomByContent": "Zoom autom\xe1tico por conte\xfado",
            "dxDiagram-commandAutoZoomByWidth": "Zoom autom\xe1tico por largura",
            "dxDiagram-commandSimpleView": "Visualiza\xe7\xe3o simples",
            "dxDiagram-commandCut": "Cortar",
            "dxDiagram-commandCopy": "Copiar",
            "dxDiagram-commandPaste": "Colar",
            "dxDiagram-commandSelectAll": "Selecionar tudo",
            "dxDiagram-commandDelete": "Remover",
            "dxDiagram-commandBringToFront": "Trazer para a frente",
            "dxDiagram-commandSendToBack": "Enviar para o fundo",
            "dxDiagram-commandLock": "Bloquear",
            "dxDiagram-commandUnlock": "Desbloquear",
            "dxDiagram-commandInsertShapeImage": "Inserir imagem...",
            "dxDiagram-commandEditShapeImage": "Alterar imagem...",
            "dxDiagram-commandDeleteShapeImage": "Remover imagem",
            "dxDiagram-commandLayoutLeftToRight": "Da esquerda para a direita",
            "dxDiagram-commandLayoutRightToLeft": "Da direita para a esquerda",
            "dxDiagram-commandLayoutTopToBottom": "De cima para baixo",
            "dxDiagram-commandLayoutBottomToTop": "De baixo para cima",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "Aceitar",
            "dxDiagram-dialogButtonCancel": "Cancelar",
            "dxDiagram-dialogInsertShapeImageTitle": "Inserir imagem",
            "dxDiagram-dialogEditShapeImageTitle": "Alterar imagem",
            "dxDiagram-dialogEditShapeImageSelectButton": "Selecionar imagem",
            "dxDiagram-dialogEditShapeImageLabelText": "ou arraste um arquivo aqui",
            "dxDiagram-uiExport": "Exportar",
            "dxDiagram-uiProperties": "Propriedades",
            "dxDiagram-uiSettings": "Configura\xe7\xf5es",
            "dxDiagram-uiShowToolbox": "Exibir ferramentas",
            "dxDiagram-uiSearch": "Pesquisar",
            "dxDiagram-uiStyle": "Estilo",
            "dxDiagram-uiLayout": "Leiaute",
            "dxDiagram-uiLayoutTree": "\xc1rvores",
            "dxDiagram-uiLayoutLayered": "N\xedveis",
            "dxDiagram-uiDiagram": "Diagrama",
            "dxDiagram-uiText": "Texto",
            "dxDiagram-uiObject": "Objeto",
            "dxDiagram-uiConnector": "Conector",
            "dxDiagram-uiPage": "P\xe1gina",
            "dxDiagram-shapeText": "Texto",
            "dxDiagram-shapeRectangle": "Ret\xe2ngulo",
            "dxDiagram-shapeEllipse": "Elipse",
            "dxDiagram-shapeCross": "Cruz",
            "dxDiagram-shapeTriangle": "Tri\xe2ngulo",
            "dxDiagram-shapeDiamond": "Diamante",
            "dxDiagram-shapeHeart": "Cora\xe7\xe3o",
            "dxDiagram-shapePentagon": "Pent\xe1gono",
            "dxDiagram-shapeHexagon": "Hex\xe1gono",
            "dxDiagram-shapeOctagon": "Oct\xf3gono",
            "dxDiagram-shapeStar": "Estrela",
            "dxDiagram-shapeArrowLeft": "Flecha \xe0 esquerda",
            "dxDiagram-shapeArrowUp": "Flecha para cima",
            "dxDiagram-shapeArrowRight": "Flecha \xe0 direita",
            "dxDiagram-shapeArrowDown": "Flecha para baixo",
            "dxDiagram-shapeArrowUpDown": "Flecha para cima e para baixo",
            "dxDiagram-shapeArrowLeftRight": "Flecha \xe0 esquerda e direita",
            "dxDiagram-shapeProcess": "Processo",
            "dxDiagram-shapeDecision": "Decis\xe3o",
            "dxDiagram-shapeTerminator": "Exterminador",
            "dxDiagram-shapePredefinedProcess": "Processo predefinido",
            "dxDiagram-shapeDocument": "Documento",
            "dxDiagram-shapeMultipleDocuments": "V\xe1rios documentos",
            "dxDiagram-shapeManualInput": "Entrada manual",
            "dxDiagram-shapePreparation": "Prepara\xe7\xe3o",
            "dxDiagram-shapeData": "Dados",
            "dxDiagram-shapeDatabase": "Base de dados",
            "dxDiagram-shapeHardDisk": "Disco r\xedgido",
            "dxDiagram-shapeInternalStorage": "Mem\xf3ria interna",
            "dxDiagram-shapePaperTape": "Fita de papel",
            "dxDiagram-shapeManualOperation": "Opera\xe7\xe3o manual",
            "dxDiagram-shapeDelay": "Atraso",
            "dxDiagram-shapeStoredData": "Dados armazenados",
            "dxDiagram-shapeDisplay": "Tela",
            "dxDiagram-shapeMerge": "Fus\xe3o",
            "dxDiagram-shapeConnector": "Conector",
            "dxDiagram-shapeOr": "Ou",
            "dxDiagram-shapeSummingJunction": "Jun\xe7\xe3o de soma",
            "dxDiagram-shapeContainerDefaultText": "Cont\xeainer",
            "dxDiagram-shapeVerticalContainer": "Cont\xeainer vertical",
            "dxDiagram-shapeHorizontalContainer": "Cont\xeainer horizontal",
            "dxDiagram-shapeCardDefaultText": "Nome",
            "dxDiagram-shapeCardWithImageOnLeft": "Cart\xe3o com imagem \xe0 esquerda",
            "dxDiagram-shapeCardWithImageOnTop": "Cart\xe3o com imagem na parte superior",
            "dxDiagram-shapeCardWithImageOnRight": "Cart\xe3o com imagem \xe0 direita",
            "dxGantt-dialogTitle": "T\xedtulo",
            "dxGantt-dialogStartTitle": "Iniciar",
            "dxGantt-dialogEndTitle": "Encerrar",
            "dxGantt-dialogProgressTitle": "Progresso",
            "dxGantt-dialogResourcesTitle": "Recursos",
            "dxGantt-dialogResourceManagerTitle": "Gerenciador de recursos",
            "dxGantt-dialogTaskDetailsTitle": "Detalhes da tarefa",
            "dxGantt-dialogEditResourceListHint": "Editar lista de recursos",
            "dxGantt-dialogEditNoResources": "Sem recursos",
            "dxGantt-dialogButtonAdd": "Adicionar",
            "dxGantt-contextMenuNewTask": "Nova tarefa",
            "dxGantt-contextMenuNewSubtask": "Nova subtarefa",
            "dxGantt-contextMenuDeleteTask": "Excluir tarefa",
            "dxGantt-contextMenuDeleteDependency": "Excluir depend\xeancia",
            "dxGantt-dialogTaskDeleteConfirmation": "Excluir uma tarefa tamb\xe9m exclui suas depend\xeancias e subtarefas. Voc\xea tem certeza que quer excluir essa tarefa?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Voc\xea tem certeza que quer excluir a depend\xeancia desta tarefa?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Ao excluir o recurso, ele tamb\xe9m ser\xe1 excluido das tarefas em que est\xe1 atribu\xeddo. Tem certeza que quer excluir estes recursos? Recurso: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "A tarefa a ser movida est\xe1 ligada a uma outra tarefa, por uma rela\xe7\xe3o de depend\xeancia. Esta altera\xe7\xe3o conflita com as regras de depend\xeancias. Como voc\xea gostaria de proceder?",
            "dxGantt-dialogConstraintViolationMessage": "A tarefa a ser movida est\xe1 ligada a uma outra tarefa, por uma rela\xe7\xe3o de depend\xeancia. Como voc\xea gostaria de proceder?",
            "dxGantt-dialogCancelOperationMessage": "Cancelar opera\xe7\xe3o",
            "dxGantt-dialogDeleteDependencyMessage": "Excluir a depend\xeancia",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Mover a tarefa e manter a depend\xeancia",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "A tarefa que voc\xea est\xe1 tentando mover est\xe1 vinculada a outras tarefas por rela\xe7\xf5es de depend\xeancia. Essa altera\xe7\xe3o entraria em conflito com as regras de depend\xeancia. Como voc\xea gostaria de proceder?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "A tarefa que voc\xea est\xe1 tentando mover est\xe1 vinculada a outras tarefas por rela\xe7\xf5es de depend\xeancia. Como voc\xea gostaria de proceder?",
            "dxGantt-dialogDeleteDependenciesMessage": "Exclua as rela\xe7\xf5es de depend\xeancia",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Mova a tarefa e mantenha as depend\xeancias",
            "dxGantt-undo": "Desfazer",
            "dxGantt-redo": "Refazer",
            "dxGantt-expandAll": "Expandir tudo",
            "dxGantt-collapseAll": "Contrair tudo",
            "dxGantt-addNewTask": "Nova tarefa",
            "dxGantt-deleteSelectedTask": "Excluir tarefas selecionadas",
            "dxGantt-zoomIn": "Aumentar zoom",
            "dxGantt-zoomOut": "Diminuir zoom",
            "dxGantt-fullScreen": "Tela cheia",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Ordenar ascendentemente",
            "dxGantt-sortingDescendingText": "Ordenar descendentemente",
            "dxGantt-sortingClearText": "Limpar ordena\xe7\xe3o",
            "dxGantt-showResources": "Mostrar recursos",
            "dxGantt-showDependencies": "Mostrar depend\xeancias",
            "dxGantt-dialogStartDateValidation": "A data de in\xedcio deve ser ap\xf3s {0}",
            "dxGantt-dialogEndDateValidation": "A data de t\xe9rmino deve ser posterior a {0}",
            "dxGallery-itemName": "Item da galeria",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use as teclas de seta ou deslize para navegar entre as visualiza\xe7\xf5es",
            "dxMultiView-itemAriaRoleDescription": "Visualiza\xe7\xe3o",
            "dxMultiView-itemAriaLabel": "{0} de {1}",
            "dxSplitter-resizeHandleAriaLabel": "Barra de divis\xe3o",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
