/*!
* DevExtreme (dx.messages.nl.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        nl: {
            Yes: "Ja",
            No: "Nee",
            Cancel: "Annuleren",
            CheckState: "Check state",
            Close: "Sluiten",
            Clear: "Wissen",
            Done: "Klaar",
            Loading: "Laden...",
            Select: "Selecteer...",
            Search: "Zoeken",
            Back: "Terug",
            OK: "OK",
            Today: "Vandaag",
            Yesterday: "Gisteren",
            "dxCollectionWidget-noDataText": "Geen gegevens om te tonen",
            "dxDropDownEditor-selectLabel": "Selecteer",
            "validation-required": "Verplicht",
            "validation-required-formatted": "{0} is verplicht",
            "validation-numeric": "Waarde moet numeriek zijn",
            "validation-numeric-formatted": "{0} moet numeriek zijn",
            "validation-range": "Waarde is niet binnen het bereik",
            "validation-range-formatted": "{0} is niet binnen het bereik",
            "validation-stringLength": "De lengte van de waarde is niet correct",
            "validation-stringLength-formatted": "De lengte van {0}  is niet correct",
            "validation-custom": "Waarde is ongeldig",
            "validation-custom-formatted": "{0} is ongeldig",
            "validation-async": "Waarde is ongeldig",
            "validation-async-formatted": "{0} is ongeldig",
            "validation-compare": "Waardes komen niet overeen",
            "validation-compare-formatted": "{0} komen niet overeen",
            "validation-pattern": "Waarde komt niet overeen met het patroon",
            "validation-pattern-formatted": "{0} komt niet overeen met het patroon",
            "validation-email": "Email is niet geldig",
            "validation-email-formatted": "{0} is niet geldig",
            "validation-mask": "Waarde is niet geldig",
            "dxLookup-searchPlaceholder": "Minimum aantal karakters: {0}",
            "dxList-pullingDownText": "Trek naar beneden om te vernieuwen...",
            "dxList-pulledDownText": "Laat los om te vernieuwen...",
            "dxList-refreshingText": "Vernieuwen...",
            "dxList-pageLoadingText": "Laden...",
            "dxList-nextButtonText": "Meer",
            "dxList-selectAll": "Selecteer alles",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "Verwijderen",
            "dxListEditDecorator-more": "Meer",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxList-ariaRoleDescription": "List",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Trek naar beneden om te vernieuwen...",
            "dxScrollView-pulledDownText": "Laat los om te vernieuwen...",
            "dxScrollView-refreshingText": "Vernieuwen...",
            "dxScrollView-reachBottomText": "Laden...",
            "dxDateBox-simulatedDataPickerTitleTime": "Selecteer tijd",
            "dxDateBox-simulatedDataPickerTitleDate": "Selecteer datum",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Selecteer datum and tijd",
            "dxDateBox-validation-datetime": "Waarde moet een datum of tijd zijn",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Startdatum",
            "dxDateRangeBox-endDateLabel": "Einddatum",
            "dxFileUploader-selectFile": "Selecteer bestand",
            "dxFileUploader-dropFile": "of sleep bestand hier",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Uploaden",
            "dxFileUploader-uploaded": "Ge\xfcpload",
            "dxFileUploader-readyToUpload": "Klaar om te uploaden",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "Uploaden is mislukt",
            "dxFileUploader-invalidFileExtension": "Dit bestandstype is niet toegestaan",
            "dxFileUploader-invalidMaxFileSize": "Het bestand is te groot",
            "dxFileUploader-invalidMinFileSize": "Het bestand is te klein",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "Van",
            "dxRangeSlider-ariaTill": "Tot",
            "dxSwitch-switchedOnText": "AAN",
            "dxSwitch-switchedOffText": "UIT",
            "dxForm-optionalMark": "optioneel",
            "dxForm-requiredMessage": "{0} is verplicht",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "Reset",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "Waarde moet een nummer zijn",
            "dxNumberBox-noDataText": "Geen gegevens",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Kolom kiezer",
            "dxDataGrid-columnChooserEmptyText": "Sleep hier een kolomkop om hem te verbergen",
            "dxDataGrid-groupContinuesMessage": "Gaat verder op de volgende pagina",
            "dxDataGrid-groupContinuedMessage": "Vervolg van de vorige pagina",
            "dxDataGrid-groupHeaderText": "Groepeer op deze kolom",
            "dxDataGrid-ungroupHeaderText": "Degroeperen",
            "dxDataGrid-ungroupAllText": "Alle degroeperen",
            "dxDataGrid-editingEditRow": "Wijzigen",
            "dxDataGrid-editingSaveRowChanges": "Opslaan",
            "dxDataGrid-editingCancelRowChanges": "Annuleren",
            "dxDataGrid-editingDeleteRow": "Verwijderen",
            "dxDataGrid-editingUndeleteRow": "Ongedaan maken",
            "dxDataGrid-editingConfirmDeleteMessage": "Moet dit record verwijderd worden?",
            "dxDataGrid-validationCancelChanges": "Wijzigingen annuleren",
            "dxDataGrid-groupPanelEmptyText": "Sleep hier een kolomkop om er op te groeperen",
            "dxDataGrid-noDataText": "Geen gegevens",
            "dxDataGrid-searchPanelPlaceholder": "Zoeken...",
            "dxDataGrid-filterRowShowAllText": "(Alle)",
            "dxDataGrid-filterRowResetOperationText": "Reset",
            "dxDataGrid-filterRowOperationEquals": "Gelijk aan",
            "dxDataGrid-filterRowOperationNotEquals": "Niet gelijk aan",
            "dxDataGrid-filterRowOperationLess": "Kleiner dan",
            "dxDataGrid-filterRowOperationLessOrEquals": "Kleiner dan of gelijk aan",
            "dxDataGrid-filterRowOperationGreater": "Groter dan",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Groter dan of gelijk aan",
            "dxDataGrid-filterRowOperationStartsWith": "Begint met",
            "dxDataGrid-filterRowOperationContains": "Bevat",
            "dxDataGrid-filterRowOperationNotContains": "Bevat niet",
            "dxDataGrid-filterRowOperationEndsWith": "Eindigt met",
            "dxDataGrid-filterRowOperationBetween": "Tussen",
            "dxDataGrid-filterRowOperationBetweenStartText": "Begin",
            "dxDataGrid-filterRowOperationBetweenEndText": "Einde",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Filter toepassen",
            "dxDataGrid-trueText": "waar",
            "dxDataGrid-falseText": "niet waar",
            "dxDataGrid-sortingAscendingText": "Sorteer oplopend",
            "dxDataGrid-sortingDescendingText": "Sorteer aflopend",
            "dxDataGrid-sortingClearText": "Sortering wissen",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Wijzigingen opslaan",
            "dxDataGrid-editingCancelAllChanges": "Wijzigingen annuleren",
            "dxDataGrid-editingAddRow": "Rij toevoegen",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min van {1} is {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max van {1} is {0}",
            "dxDataGrid-summaryAvg": "Gem: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Gem van {1} is {0}",
            "dxDataGrid-summarySum": "Som: {0}",
            "dxDataGrid-summarySumOtherColumn": "Som van {1} is {0}",
            "dxDataGrid-summaryCount": "Aantal: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Exporteren",
            "dxDataGrid-exportToExcel": "Exporteer naar Excel bestand",
            "dxDataGrid-exporting": "Exporteren...",
            "dxDataGrid-excelFormat": "Excel bestand",
            "dxDataGrid-selectedRows": "Geselecteerde rijen",
            "dxDataGrid-exportSelectedRows": "Exporteer geselecteerde rijen",
            "dxDataGrid-exportAll": "Exporteer alle gegevens",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Leeg)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Annuleren",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Kolom",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Waarde",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filter cel",
            "dxDataGrid-ariaCollapse": "Inklappen",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Uitklappen",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Gegevenstabel met {0} rijen en {1} kolommen",
            "dxDataGrid-ariaSearchInGrid": "Zoeken in gegevenstabel",
            "dxDataGrid-ariaSelectAll": "Selecteer alle",
            "dxDataGrid-ariaSelectRow": "Selecteer rij",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filterbouwer",
            "dxDataGrid-filterPanelCreateFilter": "Maak filter",
            "dxDataGrid-filterPanelClearFilter": "Wissen",
            "dxDataGrid-filterPanelFilterEnabledHint": "Filter activeren",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Toevoegen",
            "dxPager-infoText": "Pagina {0} van {1} ({2} items)",
            "dxPager-pagesCountText": "van",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Alle",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous page",
            "dxPager-nextPage": "Next page",
            "dxPager-ariaLabel": "Page navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "Pagina {0} van {1} ({2} items)",
            "dxPagination-pagesCountText": "van",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "Alle",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "Previous page",
            "dxPagination-nextPage": "Next page",
            "dxPagination-ariaLabel": "Page navigation",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Eindtotaal",
            "dxPivotGrid-total": "{0} Totaal",
            "dxPivotGrid-fieldChooserTitle": "Veldenkiezer",
            "dxPivotGrid-showFieldChooser": "Toon veldenkiezer",
            "dxPivotGrid-expandAll": "Alle uitklappen",
            "dxPivotGrid-collapseAll": "Alle inklappen",
            "dxPivotGrid-sortColumnBySummary": 'Sorteer "{0}" op deze kolom',
            "dxPivotGrid-sortRowBySummary": 'Sorteer "{0}" op Deze Rij',
            "dxPivotGrid-removeAllSorting": "Verwijderen alle sorteringen",
            "dxPivotGrid-dataNotAvailable": "N/B",
            "dxPivotGrid-rowFields": "Rijvelden",
            "dxPivotGrid-columnFields": "Kolomvelden",
            "dxPivotGrid-dataFields": "Gegevensvelden",
            "dxPivotGrid-filterFields": "Filtervelden",
            "dxPivotGrid-allFields": "Alle velden",
            "dxPivotGrid-columnFieldArea": "Sleep kolomvelden hier",
            "dxPivotGrid-dataFieldArea": "Sleep gegevensvelden hier",
            "dxPivotGrid-rowFieldArea": "Sleep rijvelden hier",
            "dxPivotGrid-filterFieldArea": "Sleep filtervelden hier",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-appointmentListAriaLabel": "Appointment list",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Onderwerp",
            "dxScheduler-editorLabelStartDate": "Startdatum",
            "dxScheduler-editorLabelEndDate": "Einddatum",
            "dxScheduler-editorLabelDescription": "Omschrijving",
            "dxScheduler-editorLabelRecurrence": "Herhalen",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "Afspraak openen",
            "dxScheduler-recurrenceNever": "Nooit",
            "dxScheduler-recurrenceMinutely": "Elke minuut",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "Dagelijks",
            "dxScheduler-recurrenceWeekly": "Wekelijks",
            "dxScheduler-recurrenceMonthly": "Maandelijks",
            "dxScheduler-recurrenceYearly": "Jaarlijks",
            "dxScheduler-recurrenceRepeatEvery": "Herhaal elke",
            "dxScheduler-recurrenceRepeatOn": "Repeat On",
            "dxScheduler-recurrenceEnd": "Einde herhaling",
            "dxScheduler-recurrenceAfter": "Na",
            "dxScheduler-recurrenceOn": "Aan",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "dag(en)",
            "dxScheduler-recurrenceRepeatWeekly": "week/weken",
            "dxScheduler-recurrenceRepeatMonthly": "maand(en)",
            "dxScheduler-recurrenceRepeatYearly": "jaar/jaren",
            "dxScheduler-switcherDay": "Dag",
            "dxScheduler-switcherWeek": "Week",
            "dxScheduler-switcherWorkWeek": "Werkweek",
            "dxScheduler-switcherMonth": "Maand",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Tijdslijn dag",
            "dxScheduler-switcherTimelineWeek": "Tijdslijn week",
            "dxScheduler-switcherTimelineWorkWeek": "Tijdslijn werkweek",
            "dxScheduler-switcherTimelineMonth": "Tijdslijn maand",
            "dxScheduler-recurrenceRepeatOnDate": "op datum",
            "dxScheduler-recurrenceRepeatCount": "keer",
            "dxScheduler-allDay": "Hele dag",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Alleen deze afspraak of de hele serie wijzigen?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Alleen deze afspraak of de volledige serie verwijderen?",
            "dxScheduler-confirmRecurrenceEditSeries": "Serie wijzigen",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Serie verwijderen",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Afspraak wijzigen",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Afspraak verwijderen",
            "dxScheduler-noTimezoneTitle": "Geen tijdszone",
            "dxScheduler-moreAppointments": "Nog {0}",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "Vandaag",
            "dxCalendar-ariaWidgetName": "Kalender",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-cancelEditingButtonAriaLabel": "Annuleren",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "Wijzigen",
            "dxChat-editingDeleteMessage": "Verwijderen",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "Rood",
            "dxColorView-ariaGreen": "Groen",
            "dxColorView-ariaBlue": "Blauw",
            "dxColorView-ariaAlpha": "Transparantie",
            "dxColorView-ariaHex": "Kleurcode",
            "dxTagBox-selected": "{0} geselecteerd",
            "dxTagBox-allSelected": "Alles geselecteerd ({0})",
            "dxTagBox-moreSelected": "Nog {0}",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "dxTagBox-ariaRoleDescription": "Tag box",
            "vizExport-printingButtonText": "Afdrukken",
            "vizExport-titleMenuText": "Exporteren/Afdrukken",
            "vizExport-exportButtonText": "{0} bestand",
            "dxFilterBuilder-and": "En",
            "dxFilterBuilder-or": "Of",
            "dxFilterBuilder-notAnd": "Niet en",
            "dxFilterBuilder-notOr": "Niet of",
            "dxFilterBuilder-addCondition": "Voorwaarde toevoegen",
            "dxFilterBuilder-addGroup": "Groep toevoegen",
            "dxFilterBuilder-enterValueText": "<vul waarde in>",
            "dxFilterBuilder-filterOperationEquals": "Gelijk aan",
            "dxFilterBuilder-filterOperationNotEquals": "Niet gelijk aan",
            "dxFilterBuilder-filterOperationLess": "Is kleiner dan",
            "dxFilterBuilder-filterOperationLessOrEquals": "Is kleiner dan of gelijk aan",
            "dxFilterBuilder-filterOperationGreater": "Is groter dan",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Is groter dan of gelijk aan",
            "dxFilterBuilder-filterOperationStartsWith": "Begint met",
            "dxFilterBuilder-filterOperationContains": "Bevat",
            "dxFilterBuilder-filterOperationNotContains": "Bevat niet",
            "dxFilterBuilder-filterOperationEndsWith": "Eindigt met",
            "dxFilterBuilder-filterOperationIsBlank": "Is leeg",
            "dxFilterBuilder-filterOperationIsNotBlank": "Is niet leeg",
            "dxFilterBuilder-filterOperationBetween": "Is tussen",
            "dxFilterBuilder-filterOperationAnyOf": "Is een van",
            "dxFilterBuilder-filterOperationNoneOf": "Is geen van",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Tekstkleur wijzigen",
            "dxHtmlEditor-dialogBackgroundCaption": "Achtergrondkleur wijzigen",
            "dxHtmlEditor-dialogLinkCaption": "Link toevoegen",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Tekst",
            "dxHtmlEditor-dialogLinkTargetField": "Open link in een nieuw venster",
            "dxHtmlEditor-dialogImageCaption": "Afbeelding toevoegen",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternatieve tekst",
            "dxHtmlEditor-dialogImageWidthField": "Breedte (px)",
            "dxHtmlEditor-dialogImageHeightField": "Hoogte (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rows",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Columns",
            "dxHtmlEditor-dialogInsertTableCaption": "Insert Table",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Titel",
            "dxHtmlEditor-normalText": "Normale tekst",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Nieuwe folder",
            "dxFileManager-rootDirectoryName": "Bestanden",
            "dxFileManager-errorNoAccess": "Geen toegang. Operatie afgebroken.",
            "dxFileManager-errorDirectoryExistsFormat": "Folder '{0}' bestaat al.",
            "dxFileManager-errorFileExistsFormat": "Bestand '{0}' bestaat al.",
            "dxFileManager-errorFileNotFoundFormat": "Bestand '{0}' niet gevonden.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Folder '{0}' bestaat al.",
            "dxFileManager-errorWrongFileExtension": "Deze bestandsextensie is niet toegestaan.",
            "dxFileManager-errorMaxFileSizeExceeded": "De bestandsgrootte overschrijdt de toegestane limiet",
            "dxFileManager-errorInvalidSymbols": "Deze naam bevat ongeldige tekens.",
            "dxFileManager-errorDefault": "Er is een ongedefinieerde fout opgetreden",
            "dxFileManager-errorDirectoryOpenFailed": "De folder kan niet geopend worden",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "Copy to",
            "dxFileManager-commandDelete": "Delete",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "Refresh",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "Clear selection",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Move",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copy to",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copy",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "Save",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "Create",
            "dxFileManager-dialogDeleteItemTitle": "Delete",
            "dxFileManager-dialogDeleteItemButtonText": "Delete",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "Cancel",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Name",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "Algemeen",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Organigram",
            "dxDiagram-categoryContainers": "Container",
            "dxDiagram-categoryCustom": "Aangepast",
            "dxDiagram-commandExportToSvg": "Exporteer naar SVG",
            "dxDiagram-commandExportToPng": "Exporteer naar PNG",
            "dxDiagram-commandExportToJpg": "Exporteer naar JPEG",
            "dxDiagram-commandUndo": "Ongedaan maken",
            "dxDiagram-commandRedo": "Opnieuw doen",
            "dxDiagram-commandFontName": "Lettertype",
            "dxDiagram-commandFontSize": "Lettergrootte",
            "dxDiagram-commandBold": "Vet",
            "dxDiagram-commandItalic": "Cursief",
            "dxDiagram-commandUnderline": "Onderstreept",
            "dxDiagram-commandTextColor": "Letterkleur",
            "dxDiagram-commandLineColor": "Lijnkleur",
            "dxDiagram-commandLineWidth": "Lijndikte",
            "dxDiagram-commandLineStyle": "Lijnstijl",
            "dxDiagram-commandLineStyleSolid": "Doorgetrokken",
            "dxDiagram-commandLineStyleDotted": "Gestippeld",
            "dxDiagram-commandLineStyleDashed": "Gestreept",
            "dxDiagram-commandFillColor": "Vulkleur",
            "dxDiagram-commandAlignLeft": "Links uitlijnen",
            "dxDiagram-commandAlignCenter": "Centreren",
            "dxDiagram-commandAlignRight": "Rechts uitlijnen",
            "dxDiagram-commandConnectorLineType": "Verbindingslijn type",
            "dxDiagram-commandConnectorLineStraight": "Recht",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonaal",
            "dxDiagram-commandConnectorLineStart": "Verbindingslijn begin",
            "dxDiagram-commandConnectorLineEnd": "Verbindingslijn eind",
            "dxDiagram-commandConnectorLineNone": "Geen",
            "dxDiagram-commandConnectorLineArrow": "Pijl",
            "dxDiagram-commandFullscreen": "Volledige schermweergave",
            "dxDiagram-commandUnits": "Eenheden",
            "dxDiagram-commandPageSize": "Pagina grootte",
            "dxDiagram-commandPageOrientation": "Pagina ori\xebntatie",
            "dxDiagram-commandPageOrientationLandscape": "Landschap",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Pagina kleur",
            "dxDiagram-commandShowGrid": "Toon raster",
            "dxDiagram-commandSnapToGrid": "Plak aan raster",
            "dxDiagram-commandGridSize": "Raster grootte",
            "dxDiagram-commandZoomLevel": "Zoom niveau",
            "dxDiagram-commandAutoZoom": "Automatische zoom",
            "dxDiagram-commandFitToContent": "Aan inhoud aanpassen",
            "dxDiagram-commandFitToWidth": "Aan breedte aanpassen",
            "dxDiagram-commandAutoZoomByContent": "Automatisch aan inhoud aanpassen",
            "dxDiagram-commandAutoZoomByWidth": "Automatisch aan breedte aanpassen",
            "dxDiagram-commandSimpleView": "Eenvoudige weergave",
            "dxDiagram-commandCut": "Knippen",
            "dxDiagram-commandCopy": "Kopi\xebren",
            "dxDiagram-commandPaste": "Plakken",
            "dxDiagram-commandSelectAll": "Alles selecteren",
            "dxDiagram-commandDelete": "Verwijderen",
            "dxDiagram-commandBringToFront": "Naar voorgrond",
            "dxDiagram-commandSendToBack": "Naar achtergrond",
            "dxDiagram-commandLock": "Vergrendelen",
            "dxDiagram-commandUnlock": "Ontgrendelen",
            "dxDiagram-commandInsertShapeImage": "Afbeeldingsobject invoegen",
            "dxDiagram-commandEditShapeImage": "Afbeeldingsobject aanpassen",
            "dxDiagram-commandDeleteShapeImage": "Afbeeldingsobject verwijderen",
            "dxDiagram-commandLayoutLeftToRight": "Links-naar-rechts",
            "dxDiagram-commandLayoutRightToLeft": "Rechts-naar-links",
            "dxDiagram-commandLayoutTopToBottom": "Boven-naar-beneden",
            "dxDiagram-commandLayoutBottomToTop": "Beneden-naar-boven",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Annuleren",
            "dxDiagram-dialogInsertShapeImageTitle": "Afbeelding invoegen",
            "dxDiagram-dialogEditShapeImageTitle": "Afbeelding aanpassen",
            "dxDiagram-dialogEditShapeImageSelectButton": "Selecteer afbeelding",
            "dxDiagram-dialogEditShapeImageLabelText": "of sleep de afbeelding hier",
            "dxDiagram-uiExport": "Exporteren",
            "dxDiagram-uiProperties": "Eigenschappen",
            "dxDiagram-uiSettings": "Instellingen",
            "dxDiagram-uiShowToolbox": "Gereedschapskist",
            "dxDiagram-uiSearch": "Zoeken",
            "dxDiagram-uiStyle": "Stijl",
            "dxDiagram-uiLayout": "Opmaak",
            "dxDiagram-uiLayoutTree": "Opmaakboom",
            "dxDiagram-uiLayoutLayered": "Gelaagde opmaak",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Tekst",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Verbinding",
            "dxDiagram-uiPage": "Pagina",
            "dxDiagram-shapeText": "Tekst",
            "dxDiagram-shapeRectangle": "Rechthoek",
            "dxDiagram-shapeEllipse": "Ovaal",
            "dxDiagram-shapeCross": "Kruis",
            "dxDiagram-shapeTriangle": "Driehoek",
            "dxDiagram-shapeDiamond": "Diamand",
            "dxDiagram-shapeHeart": "Hart",
            "dxDiagram-shapePentagon": "Vijfhoek",
            "dxDiagram-shapeHexagon": "Zeshoek",
            "dxDiagram-shapeOctagon": "Achthoek",
            "dxDiagram-shapeStar": "Ster",
            "dxDiagram-shapeArrowLeft": "Pijl naar links",
            "dxDiagram-shapeArrowUp": "Pijl naar boven",
            "dxDiagram-shapeArrowRight": "Pijl naar rechts",
            "dxDiagram-shapeArrowDown": "Pijl naar beneden",
            "dxDiagram-shapeArrowUpDown": "Pijl naar boven en beneden",
            "dxDiagram-shapeArrowLeftRight": "Pijl naar links en rechts",
            "dxDiagram-shapeProcess": "Proces",
            "dxDiagram-shapeDecision": "Beslissing",
            "dxDiagram-shapeTerminator": "Aflsuiter",
            "dxDiagram-shapePredefinedProcess": "Gedefinieerd proces",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Meerdere documenten",
            "dxDiagram-shapeManualInput": "Handmatige invoer",
            "dxDiagram-shapePreparation": "Voorbereiding",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Harde schijf",
            "dxDiagram-shapeInternalStorage": "Interne opslag",
            "dxDiagram-shapePaperTape": "Papierband",
            "dxDiagram-shapeManualOperation": "Handmatige operatie",
            "dxDiagram-shapeDelay": "Vertraging",
            "dxDiagram-shapeStoredData": "Opgeslagen data",
            "dxDiagram-shapeDisplay": "Weergave",
            "dxDiagram-shapeMerge": "Samenvoegen",
            "dxDiagram-shapeConnector": "Verbinding",
            "dxDiagram-shapeOr": "Of",
            "dxDiagram-shapeSummingJunction": "Optelkruising",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertikale container",
            "dxDiagram-shapeHorizontalContainer": "Horizontale container",
            "dxDiagram-shapeCardDefaultText": "Tekst",
            "dxDiagram-shapeCardWithImageOnLeft": "Kaart met afbeelding links",
            "dxDiagram-shapeCardWithImageOnTop": "Kaart met afbeelding boven",
            "dxDiagram-shapeCardWithImageOnRight": "Kaart met afbeelding rechts",
            "dxGantt-dialogTitle": "Titel",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "Eind",
            "dxGantt-dialogProgressTitle": "Voortgang",
            "dxGantt-dialogResourcesTitle": "Bronnen",
            "dxGantt-dialogResourceManagerTitle": "Beheer bronnen",
            "dxGantt-dialogTaskDetailsTitle": "Taak details",
            "dxGantt-dialogEditResourceListHint": "Pas bronnen aan",
            "dxGantt-dialogEditNoResources": "Geen bronnen",
            "dxGantt-dialogButtonAdd": "Toevoegen",
            "dxGantt-contextMenuNewTask": "Nieuwe taak",
            "dxGantt-contextMenuNewSubtask": "Nieuwe sub-taak",
            "dxGantt-contextMenuDeleteTask": "Verwijder taak",
            "dxGantt-contextMenuDeleteDependency": "Verwijder afhankelijkheid",
            "dxGantt-dialogTaskDeleteConfirmation": "Door het verwijderen van deze taak zullen ook alle subtaken en verbindingen verwijderd worden. Zeker weten?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Moet deze afhankelijkheid van de taak verwijderd worden?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Door deze bron te verwijderen, wordt deze ook uit alle taken verwijderd waaraan hij is toegewezen. Zeker weten om bron '{0}' te verwijderen?",
            "dxGantt-dialogConstraintCriticalViolationMessage": "De taak die verplaatst moet worden is gekoppeld aan een andere taak door een afhankelijkheidsrelatie. Deze wijziging is in strijd met de afhankelijkheidsregels. Hoe verder?",
            "dxGantt-dialogConstraintViolationMessage": "De taak die verplaatst moet worden is gekoppeld aan een andere taak door een afhankelijkheidsrelatie. Hoe verder?",
            "dxGantt-dialogCancelOperationMessage": "Annuleer de operatie",
            "dxGantt-dialogDeleteDependencyMessage": "Verwijder de afhankelijkheid",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Verplaats de taak en behoud de afhankelijkheid",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "Ongedaan maken",
            "dxGantt-redo": "Opnieuw doen",
            "dxGantt-expandAll": "Alles uitklappen",
            "dxGantt-collapseAll": "Alles inklappen",
            "dxGantt-addNewTask": "Nieuwe taak",
            "dxGantt-deleteSelectedTask": "Verwijder geselecteerde taak",
            "dxGantt-zoomIn": "Inzoomen",
            "dxGantt-zoomOut": "Uitzoomen",
            "dxGantt-fullScreen": "Volledig scherm",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sorteer oplopend",
            "dxGantt-sortingDescendingText": "Sorteer aflopend",
            "dxGantt-sortingClearText": "Sortering wissen",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
