/*!
* DevExtreme (dx.messages.nb.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        nb: {
            Yes: "Ja",
            No: "Nei",
            Cancel: "Avbryt",
            CheckState: "Check state",
            Close: "Lukke",
            Clear: "Slett",
            Done: "Fullf\xf8rt",
            Loading: "Laster...",
            Select: "Velg...",
            Search: "S\xf8k",
            Back: "Tilbake",
            OK: "OK",
            Today: "I dag",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "Ingen data \xe5 vise",
            "dxDropDownEditor-selectLabel": "Velg",
            "validation-required": "P\xe5krevd",
            "validation-required-formatted": "{0} er p\xe5krevd",
            "validation-numeric": "Verdi m\xe5 v\xe6re et tall",
            "validation-numeric-formatted": "{0} m\xe5 v\xe6re et tall",
            "validation-range": "Verdien er utenfor intervall",
            "validation-range-formatted": "{0} er utenfor intervall",
            "validation-stringLength": "Tekstverdiens lengde er ikke korrekt",
            "validation-stringLength-formatted": "Tekstlengden p\xe5 {0} er ikke korrekt",
            "validation-custom": "Verdien er ugyldig",
            "validation-custom-formatted": "{0} er ugyldig",
            "validation-async": "Verdien er ugyldig",
            "validation-async-formatted": "{0} er ugyldig",
            "validation-compare": "Verdiene matcher ikke",
            "validation-compare-formatted": "{0} matcher ikke",
            "validation-pattern": "Verdien matcher ikke m\xf8nsteret",
            "validation-pattern-formatted": "{0} matcher ikke m\xf8nsteret",
            "validation-email": "E-post er ikke gyldig",
            "validation-email-formatted": "{0} er ugyldig",
            "validation-mask": "Verdien er ugyldig",
            "dxLookup-searchPlaceholder": "Minste antall tegn: {0}",
            "dxList-pullingDownText": "Trekk ned for \xe5 oppdatere...",
            "dxList-pulledDownText": "Slipp for \xe5 oppdatere...",
            "dxList-refreshingText": "Oppdaterer...",
            "dxList-pageLoadingText": "Laster...",
            "dxList-nextButtonText": "Mer",
            "dxList-selectAll": "Velg alle",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "Slett",
            "dxListEditDecorator-more": "Mer",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxList-ariaRoleDescription": "List",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Dra ned for \xe5 oppdatere...",
            "dxScrollView-pulledDownText": " Slipp for \xe5 oppdatere...",
            "dxScrollView-refreshingText": "Oppdaterer...",
            "dxScrollView-reachBottomText": "Laster...",
            "dxDateBox-simulatedDataPickerTitleTime": "Velg tid",
            "dxDateBox-simulatedDataPickerTitleDate": "Velg dato",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Velg dato og tid",
            "dxDateBox-validation-datetime": "Verdien m\xe5 v\xe6re dato eller tid",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "Startdato",
            "dxDateRangeBox-endDateLabel": "Sluttdato",
            "dxFileUploader-selectFile": "Velg fil",
            "dxFileUploader-dropFile": "eller dropp filen her",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Last opp",
            "dxFileUploader-uploaded": "Opplastet",
            "dxFileUploader-readyToUpload": "Klar til \xe5 laste opp",
            "dxFileUploader-uploadAbortedMessage": "Opplastingen avbrutt",
            "dxFileUploader-uploadFailedMessage": "Opplastingen feilet",
            "dxFileUploader-invalidFileExtension": "Filtypen er ikke tillatt",
            "dxFileUploader-invalidMaxFileSize": "Filen er for stor",
            "dxFileUploader-invalidMinFileSize": "Filen er for liten",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "Fra",
            "dxRangeSlider-ariaTill": "Til",
            "dxSwitch-switchedOnText": "P\xc5",
            "dxSwitch-switchedOffText": "AV",
            "dxForm-optionalMark": "Valgfri",
            "dxForm-requiredMessage": "{0} er p\xe5krevd",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "Tilbakestill",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "Verdien m\xe5 v\xe6re et tall",
            "dxNumberBox-noDataText": "Ingen data",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Kolonnevelger",
            "dxDataGrid-columnChooserEmptyText": "Dra kolonnen hit for \xe5 skjule den",
            "dxDataGrid-groupContinuesMessage": "Fortsetter p\xe5 neste side",
            "dxDataGrid-groupContinuedMessage": "Fortsettelse fra forrige side",
            "dxDataGrid-groupHeaderText": "Grupp\xe9r etter denne kolonnen",
            "dxDataGrid-ungroupHeaderText": "Avgrupp\xe9r",
            "dxDataGrid-ungroupAllText": "Avgrupp\xe9r alle",
            "dxDataGrid-editingEditRow": "Endre",
            "dxDataGrid-editingSaveRowChanges": "Lagre",
            "dxDataGrid-editingCancelRowChanges": "Avbryt",
            "dxDataGrid-editingDeleteRow": "Slett",
            "dxDataGrid-editingUndeleteRow": "Angre sletting",
            "dxDataGrid-editingConfirmDeleteMessage": "Er du sikker p\xe5 at du vil slette denne oppf\xf8ringen?",
            "dxDataGrid-validationCancelChanges": "Avbryt endringer",
            "dxDataGrid-groupPanelEmptyText": "Dra en kolonneoverskrift hit for \xe5 gruppere etter den kolonnen",
            "dxDataGrid-noDataText": "Ingen data",
            "dxDataGrid-searchPanelPlaceholder": "S\xf8k...",
            "dxDataGrid-filterRowShowAllText": "(Alle)",
            "dxDataGrid-filterRowResetOperationText": "Tilbakestill",
            "dxDataGrid-filterRowOperationEquals": "Er lik",
            "dxDataGrid-filterRowOperationNotEquals": "Er ikke lik",
            "dxDataGrid-filterRowOperationLess": "Mindre enn",
            "dxDataGrid-filterRowOperationLessOrEquals": "Mindre enn eller lik",
            "dxDataGrid-filterRowOperationGreater": "St\xf8rre enn",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "St\xf8rre enn eller lik",
            "dxDataGrid-filterRowOperationStartsWith": "Begynner med",
            "dxDataGrid-filterRowOperationContains": "Inneholder",
            "dxDataGrid-filterRowOperationNotContains": "Inneholder ikke",
            "dxDataGrid-filterRowOperationEndsWith": "Ender med",
            "dxDataGrid-filterRowOperationBetween": "Mellom",
            "dxDataGrid-filterRowOperationBetweenStartText": "Start",
            "dxDataGrid-filterRowOperationBetweenEndText": "Slutt",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Bruk filter",
            "dxDataGrid-trueText": "sant",
            "dxDataGrid-falseText": "usant",
            "dxDataGrid-sortingAscendingText": "Sort\xe9r stigende",
            "dxDataGrid-sortingDescendingText": "Sort\xe9r fallende",
            "dxDataGrid-sortingClearText": "Nullstill sortering",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Lagre endringer",
            "dxDataGrid-editingCancelAllChanges": "Forkast endringer",
            "dxDataGrid-editingAddRow": "Legg til rad",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min av {1} er {0}",
            "dxDataGrid-summaryMax": "Maks: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maks av {1} er {0}",
            "dxDataGrid-summaryAvg": "Gj.snitt: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Gj.snitt av {1} er {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Summen av {1} er {0}",
            "dxDataGrid-summaryCount": "Telling: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Eksport\xe9r",
            "dxDataGrid-exportToExcel": "Eksport\xe9r til Excel fil",
            "dxDataGrid-exporting": "Eksport\xe9rer...",
            "dxDataGrid-excelFormat": "Excel fil",
            "dxDataGrid-selectedRows": "Valgte rader",
            "dxDataGrid-exportSelectedRows": "Eksport\xe9r valgte rader",
            "dxDataGrid-exportAll": "Eksport\xe9r all data",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tom)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Avbryt",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Kolonne",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "Verdi",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtr\xe9r celle",
            "dxDataGrid-ariaCollapse": "Skjul",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Utvid",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Data rutenett",
            "dxDataGrid-ariaSearchInGrid": "S\xf8k i data rutenett",
            "dxDataGrid-ariaSelectAll": "Velg alle",
            "dxDataGrid-ariaSelectRow": "Velg rad",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filterbygger",
            "dxDataGrid-filterPanelCreateFilter": "Velg filter",
            "dxDataGrid-filterPanelClearFilter": "Slett",
            "dxDataGrid-filterPanelFilterEnabledHint": "Aktiv\xe9r filter",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "Legg til",
            "dxPager-infoText": "Side {0} av {1} ({2} punkter)",
            "dxPager-pagesCountText": "av",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "Alle",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Previous page",
            "dxPager-nextPage": "Next page",
            "dxPager-ariaLabel": "Page navigation",
            "dxPager-ariaPageSize": "Page size",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "Side {0} av {1} ({2} punkter)",
            "dxPagination-pagesCountText": "av",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "Alle",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "Previous page",
            "dxPagination-nextPage": "Next page",
            "dxPagination-ariaLabel": "Page navigation",
            "dxPagination-ariaPageSize": "Page size",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Totalsum",
            "dxPivotGrid-total": "{0} Totalt",
            "dxPivotGrid-fieldChooserTitle": "Feltvelger",
            "dxPivotGrid-showFieldChooser": "Vis feltvelger",
            "dxPivotGrid-expandAll": "Utvid alle",
            "dxPivotGrid-collapseAll": "Skjul alle",
            "dxPivotGrid-sortColumnBySummary": 'Sort\xe9r "{0}" p\xe5 denne kolonnen',
            "dxPivotGrid-sortRowBySummary": 'Sort\xe9r "{0}" p\xe5 denne raden',
            "dxPivotGrid-removeAllSorting": "Fjern all sortering",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "Radfelter",
            "dxPivotGrid-columnFields": "Kolonnefelter",
            "dxPivotGrid-dataFields": "Datafelter",
            "dxPivotGrid-filterFields": "Filterfelter",
            "dxPivotGrid-allFields": "Alle felter",
            "dxPivotGrid-columnFieldArea": "Slipp kolonnefelter her",
            "dxPivotGrid-dataFieldArea": "Slipp datafelter her",
            "dxPivotGrid-rowFieldArea": "Slipp radfelter her",
            "dxPivotGrid-filterFieldArea": "Slipp filterfelter her",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-appointmentListAriaLabel": "Appointment list",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Emne",
            "dxScheduler-editorLabelStartDate": "Startdato",
            "dxScheduler-editorLabelEndDate": "Sluttdato",
            "dxScheduler-editorLabelDescription": "Beskrivelse",
            "dxScheduler-editorLabelRecurrence": "Gjenta",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "\xc5pen avtale",
            "dxScheduler-recurrenceNever": "Aldri",
            "dxScheduler-recurrenceMinutely": "Hvert minutt",
            "dxScheduler-recurrenceHourly": "Per time",
            "dxScheduler-recurrenceDaily": "Daglig",
            "dxScheduler-recurrenceWeekly": "Ukentlig",
            "dxScheduler-recurrenceMonthly": "M\xe5nedlig",
            "dxScheduler-recurrenceYearly": "\xc5rlig",
            "dxScheduler-recurrenceRepeatEvery": "Gjenta hver",
            "dxScheduler-recurrenceRepeatOn": "Gjenta p\xe5",
            "dxScheduler-recurrenceEnd": "Avslutt gjentakelse",
            "dxScheduler-recurrenceAfter": "Etter",
            "dxScheduler-recurrenceOn": "P\xe5",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minutt(er)",
            "dxScheduler-recurrenceRepeatHourly": "time(r)",
            "dxScheduler-recurrenceRepeatDaily": "dag(er)",
            "dxScheduler-recurrenceRepeatWeekly": "uke(r)",
            "dxScheduler-recurrenceRepeatMonthly": "m\xe5ned(er)",
            "dxScheduler-recurrenceRepeatYearly": "\xe5r",
            "dxScheduler-switcherDay": "Dag",
            "dxScheduler-switcherWeek": "Uke",
            "dxScheduler-switcherWorkWeek": "Arbeidsuke",
            "dxScheduler-switcherMonth": "M\xe5ned",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Tidslinje dag",
            "dxScheduler-switcherTimelineWeek": "Tidslinje uke",
            "dxScheduler-switcherTimelineWorkWeek": "Tidslinje arbeidsuke",
            "dxScheduler-switcherTimelineMonth": "Tidslinje m\xe5ned",
            "dxScheduler-recurrenceRepeatOnDate": "p\xe5 dato",
            "dxScheduler-recurrenceRepeatCount": "tilfelle(r)",
            "dxScheduler-allDay": "Hele dagen",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Vil du kun endre denne avtalen eller hele serien?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Vil du kun slette denne avtalen eller hele serien? ",
            "dxScheduler-confirmRecurrenceEditSeries": "Endre serie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Slette serie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Endre avtale",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Slette avtale",
            "dxScheduler-noTimezoneTitle": "Ingen tidssone",
            "dxScheduler-moreAppointments": "{0} mer",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "I dag",
            "dxCalendar-ariaWidgetName": "Kalender",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-cancelEditingButtonAriaLabel": "Avbryt",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "Endre",
            "dxChat-editingDeleteMessage": "Slett",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "R\xf8d",
            "dxColorView-ariaGreen": "Gr\xf8nn",
            "dxColorView-ariaBlue": "Bl\xe5",
            "dxColorView-ariaAlpha": "\xc5penhet",
            "dxColorView-ariaHex": "Fargekode",
            "dxTagBox-selected": "{0} valgt",
            "dxTagBox-allSelected": "Alle valgt ({0})",
            "dxTagBox-moreSelected": "{0} flere",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "dxTagBox-ariaRoleDescription": "Tag box",
            "vizExport-printingButtonText": "Skriv ut",
            "vizExport-titleMenuText": "Eksporterer/Skriver ut",
            "vizExport-exportButtonText": "{0} filer",
            "dxFilterBuilder-and": "Og",
            "dxFilterBuilder-or": "Eller",
            "dxFilterBuilder-notAnd": "Ikke og",
            "dxFilterBuilder-notOr": "Ikke eller",
            "dxFilterBuilder-addCondition": "Legg til betingelse",
            "dxFilterBuilder-addGroup": "Legg til gruppe",
            "dxFilterBuilder-enterValueText": "<enter a value>",
            "dxFilterBuilder-filterOperationEquals": "Er lik",
            "dxFilterBuilder-filterOperationNotEquals": "Er ikke lik",
            "dxFilterBuilder-filterOperationLess": "Er mindre enn",
            "dxFilterBuilder-filterOperationLessOrEquals": "Er mindre eller lik",
            "dxFilterBuilder-filterOperationGreater": "Er st\xf8rre enn",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Er st\xf8rre enn eller lik",
            "dxFilterBuilder-filterOperationStartsWith": "Begynner med",
            "dxFilterBuilder-filterOperationContains": "Inneholder",
            "dxFilterBuilder-filterOperationNotContains": "Inneholder ikke",
            "dxFilterBuilder-filterOperationEndsWith": "Slutter med",
            "dxFilterBuilder-filterOperationIsBlank": "Er tom",
            "dxFilterBuilder-filterOperationIsNotBlank": "Er ikke tom",
            "dxFilterBuilder-filterOperationBetween": "Er mellom",
            "dxFilterBuilder-filterOperationAnyOf": "Er noen av",
            "dxFilterBuilder-filterOperationNoneOf": "Er ingen av",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Skift fontfarge",
            "dxHtmlEditor-dialogBackgroundCaption": "Skift bakgrunnsfarge",
            "dxHtmlEditor-dialogLinkCaption": "Legg til link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Tekst",
            "dxHtmlEditor-dialogLinkTargetField": "\xc5pne link i nytt vindu",
            "dxHtmlEditor-dialogImageCaption": "Legg til bilde",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternativ tekst",
            "dxHtmlEditor-dialogImageWidthField": "Bredde (px)",
            "dxHtmlEditor-dialogImageHeightField": "H\xf8yde (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rad",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Kolonne",
            "dxHtmlEditor-dialogInsertTableCaption": "Sett inn tabell",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "Update",
            "dxHtmlEditor-dialogImageAddButton": "Add",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Overskrift",
            "dxHtmlEditor-normalText": "Normal tekst",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "Bold",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "Font",
            "dxHtmlEditor-italic": "Italic",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "Header",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "Undo",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "Delete",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Width",
            "dxHtmlEditor-height": "Height",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "Left",
            "dxHtmlEditor-right": "Right",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Katalog uten navn",
            "dxFileManager-rootDirectoryName": "Filer",
            "dxFileManager-errorNoAccess": "Ingen tilgang. Operasjonen kunne ikke fullf\xf8res.",
            "dxFileManager-errorDirectoryExistsFormat": "Katalog '{0}' eksisterer allerede.",
            "dxFileManager-errorFileExistsFormat": "Fil '{0}' eksisterer allerede.",
            "dxFileManager-errorFileNotFoundFormat": "Fil '{0}' ble ikke funnet. ",
            "dxFileManager-errorDirectoryNotFoundFormat": "Katalogen '{0}' ble ikke funnet.",
            "dxFileManager-errorWrongFileExtension": "Filtypen er ikke tillatt.",
            "dxFileManager-errorMaxFileSizeExceeded": "Filst\xf8rrelsen overg\xe5r maksimal tillatt st\xf8rrelse.",
            "dxFileManager-errorInvalidSymbols": "Dette navnet inneholder ugyldige tegn. ",
            "dxFileManager-errorDefault": "Uspesifisert feil.",
            "dxFileManager-errorDirectoryOpenFailed": "Katalogen kan ikke \xe5pnes",
            "dxFileManager-commandCreate": "Ny katalog",
            "dxFileManager-commandRename": "Endre navn",
            "dxFileManager-commandMove": "Flytt til",
            "dxFileManager-commandCopy": "Kopi\xe9r til",
            "dxFileManager-commandDelete": "Slett",
            "dxFileManager-commandDownload": "Last ned",
            "dxFileManager-commandUpload": "Last opp filer",
            "dxFileManager-commandRefresh": "Oppdat\xe9r",
            "dxFileManager-commandThumbnails": "Miniatyrbildevisning",
            "dxFileManager-commandDetails": "Detailvisning",
            "dxFileManager-commandClearSelection": "Frigj\xf8r valg",
            "dxFileManager-commandShowNavPane": "Veksle navigasjonsrute",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Flytt til",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Flytt",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kopier til",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopier",
            "dxFileManager-dialogRenameItemTitle": "Endre navn",
            "dxFileManager-dialogRenameItemButtonText": "Lagre",
            "dxFileManager-dialogCreateDirectoryTitle": "Ny katalog",
            "dxFileManager-dialogCreateDirectoryButtonText": "Opprett",
            "dxFileManager-dialogDeleteItemTitle": "Slett",
            "dxFileManager-dialogDeleteItemButtonText": "Slett",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Er du sikker p\xe5 at du slette {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Er du sikker p\xe5 at du slette {0} elementer?",
            "dxFileManager-dialogButtonCancel": "Avbryt",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Oppretter en mappe inne i {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Opprettet en mappe inne i {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Katalog ble ikke opprettet",
            "dxFileManager-editingCreateCommonErrorMessage": "Katalog ble ikke opprettet",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Endrer navn p\xe5 et element inne i {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Endret navn p\xe5 et element inne i {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Navneendring p\xe5 p\xe5 element ble ikke utf\xf8rt",
            "dxFileManager-editingRenameCommonErrorMessage": "Navneendring p\xe5 element ble ikke utf\xf8rt",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Sletter et element fra {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Sletter {0} elementer fra {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Slettet et element fra {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Slettet {0} elementer fra {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Element ble ikke slettet",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elementer ble ikke slettet",
            "dxFileManager-editingDeleteCommonErrorMessage": "Noen elementer ble ikke slettet",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Flytter et element til {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Flytter {0} elementer til {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Flyttet et element til {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Flyttet {0} elementer til {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Element ble ikke flyttet",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} elementer ble ikke flyttet",
            "dxFileManager-editingMoveCommonErrorMessage": "Noen elementer ble ikke flyttet",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kopierer et element til {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kopierer {0} elementer til {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Kopierte et element til {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Kopierte {0} elementer til {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Elementet ble ikke kopiert",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} elementer ble ikke kopiert",
            "dxFileManager-editingCopyCommonErrorMessage": "Noen elementer ble ikke kopiert",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Laster opp et element til {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Laster opp {0} elementer til {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Lastet opp et element til {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Lastet opp {0} elementer til {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Elementet ble ikke lastet opp",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} elementer ble ikke lastet opp",
            "dxFileManager-editingUploadCanceledMessage": "Avbrutt",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "Navn",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Dato endret",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Filst\xf8rrelse",
            "dxFileManager-listThumbnailsTooltipTextSize": "St\xf8rrelse",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Dato endret",
            "dxFileManager-notificationProgressPanelTitle": "Fremdrift",
            "dxFileManager-notificationProgressPanelEmptyListText": "Ingen operasjoner",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Avbrutt",
            "dxDiagram-categoryGeneral": "Generell",
            "dxDiagram-categoryFlowchart": "Flytskjema",
            "dxDiagram-categoryOrgChart": "Org. kart",
            "dxDiagram-categoryContainers": "Beholdere",
            "dxDiagram-categoryCustom": "Tilpasset",
            "dxDiagram-commandExportToSvg": "Eksport\xe9r til SVG",
            "dxDiagram-commandExportToPng": "Eksport\xe9r til PNG",
            "dxDiagram-commandExportToJpg": "Eksport\xe9r til JPEG",
            "dxDiagram-commandUndo": "Angre",
            "dxDiagram-commandRedo": "Gj\xf8r om",
            "dxDiagram-commandFontName": "Fontnavn",
            "dxDiagram-commandFontSize": "Fontst\xf8rrelse",
            "dxDiagram-commandBold": "Fet",
            "dxDiagram-commandItalic": "Kursiv",
            "dxDiagram-commandUnderline": "Understrek",
            "dxDiagram-commandTextColor": "Fontfarge",
            "dxDiagram-commandLineColor": "Linjefarge",
            "dxDiagram-commandLineWidth": "Linjebredde",
            "dxDiagram-commandLineStyle": "Linjestil",
            "dxDiagram-commandLineStyleSolid": "Heltrukket",
            "dxDiagram-commandLineStyleDotted": "Prikket",
            "dxDiagram-commandLineStyleDashed": "Stiplet",
            "dxDiagram-commandFillColor": "Fyllfarge",
            "dxDiagram-commandAlignLeft": "Venstrejust\xe9r",
            "dxDiagram-commandAlignCenter": "Sentr\xe9r",
            "dxDiagram-commandAlignRight": "H\xf8yrejust\xe9r",
            "dxDiagram-commandConnectorLineType": "Tilkoblingslinjetype",
            "dxDiagram-commandConnectorLineStraight": "Rett",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonal",
            "dxDiagram-commandConnectorLineStart": "Tilkoblingslinje start",
            "dxDiagram-commandConnectorLineEnd": "Tilkoblingslinje slutt",
            "dxDiagram-commandConnectorLineNone": "Ingen",
            "dxDiagram-commandConnectorLineArrow": "Pil",
            "dxDiagram-commandFullscreen": "Fullskjerm",
            "dxDiagram-commandUnits": "Enheter",
            "dxDiagram-commandPageSize": "Sidest\xf8rrelse",
            "dxDiagram-commandPageOrientation": "Sideretning",
            "dxDiagram-commandPageOrientationLandscape": "Landskap",
            "dxDiagram-commandPageOrientationPortrait": "Portrett",
            "dxDiagram-commandPageColor": "Sidefarge",
            "dxDiagram-commandShowGrid": "Vis rutenett",
            "dxDiagram-commandSnapToGrid": "Fest til rutenett",
            "dxDiagram-commandGridSize": "Rutenettst\xf8rrelse",
            "dxDiagram-commandZoomLevel": "Zoomniv\xe5",
            "dxDiagram-commandAutoZoom": "Autozoom",
            "dxDiagram-commandFitToContent": "Tilpass til innhold",
            "dxDiagram-commandFitToWidth": "Tilpass til bredde",
            "dxDiagram-commandAutoZoomByContent": "Autozoom til innhold",
            "dxDiagram-commandAutoZoomByWidth": "Autozoom til bredde",
            "dxDiagram-commandSimpleView": "Enkel visning",
            "dxDiagram-commandCut": "Klipp",
            "dxDiagram-commandCopy": "Kopi\xe9r",
            "dxDiagram-commandPaste": "Lim inn",
            "dxDiagram-commandSelectAll": "Velg alle",
            "dxDiagram-commandDelete": "Slett",
            "dxDiagram-commandBringToFront": "Flytt til front",
            "dxDiagram-commandSendToBack": "Flytt til bak",
            "dxDiagram-commandLock": "L\xe5s",
            "dxDiagram-commandUnlock": "L\xe5s opp",
            "dxDiagram-commandInsertShapeImage": "Sett inn bilde...",
            "dxDiagram-commandEditShapeImage": "Endre bilde...",
            "dxDiagram-commandDeleteShapeImage": "Slett bilde",
            "dxDiagram-commandLayoutLeftToRight": "Venstre-til-h\xf8yre",
            "dxDiagram-commandLayoutRightToLeft": "H\xf8yre-til-venstre",
            "dxDiagram-commandLayoutTopToBottom": "Topp-til-bunn",
            "dxDiagram-commandLayoutBottomToTop": "Bunn-til-topp",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Avbryt",
            "dxDiagram-dialogInsertShapeImageTitle": "Sett inn bilde",
            "dxDiagram-dialogEditShapeImageTitle": "Endre bilde",
            "dxDiagram-dialogEditShapeImageSelectButton": "Velg bilde",
            "dxDiagram-dialogEditShapeImageLabelText": "eller slipp filen her",
            "dxDiagram-uiExport": "Eksport\xe9r",
            "dxDiagram-uiProperties": "Egenskaper",
            "dxDiagram-uiSettings": "Innstillinger",
            "dxDiagram-uiShowToolbox": "Vis verkt\xf8ykasse",
            "dxDiagram-uiSearch": "S\xf8k",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tre",
            "dxDiagram-uiLayoutLayered": "Lagdelt",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Tekst",
            "dxDiagram-uiObject": "Objekt",
            "dxDiagram-uiConnector": "Kobling",
            "dxDiagram-uiPage": "Side",
            "dxDiagram-shapeText": "Tekst",
            "dxDiagram-shapeRectangle": "Rektangel",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Kryss",
            "dxDiagram-shapeTriangle": "Triangel",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "Hjerte",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Heksagon",
            "dxDiagram-shapeOctagon": "Oktagon",
            "dxDiagram-shapeStar": "Stjerne",
            "dxDiagram-shapeArrowLeft": "Venstrepil",
            "dxDiagram-shapeArrowUp": "Pil opp",
            "dxDiagram-shapeArrowRight": "H\xf8yrepil",
            "dxDiagram-shapeArrowDown": "Pil ned",
            "dxDiagram-shapeArrowUpDown": "Opp ned pil",
            "dxDiagram-shapeArrowLeftRight": "Venstre h\xf8yre pil",
            "dxDiagram-shapeProcess": "Prosess",
            "dxDiagram-shapeDecision": "Avgj\xf8relse",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Forh\xe5ndsdefinert prosess",
            "dxDiagram-shapeDocument": "Dokument",
            "dxDiagram-shapeMultipleDocuments": "Flere dokumenter",
            "dxDiagram-shapeManualInput": "Manuell input",
            "dxDiagram-shapePreparation": "Forberedelse",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Harddisk",
            "dxDiagram-shapeInternalStorage": "Intern lagring",
            "dxDiagram-shapePaperTape": "Papirtape",
            "dxDiagram-shapeManualOperation": "Manuell operasjon",
            "dxDiagram-shapeDelay": "Forsinkelse",
            "dxDiagram-shapeStoredData": "Lagret data",
            "dxDiagram-shapeDisplay": "Visning",
            "dxDiagram-shapeMerge": "Sl\xe5 sammen",
            "dxDiagram-shapeConnector": "Kobling",
            "dxDiagram-shapeOr": "Eller",
            "dxDiagram-shapeSummingJunction": "Summeringskryss",
            "dxDiagram-shapeContainerDefaultText": "Beholder",
            "dxDiagram-shapeVerticalContainer": "Vertikal beholder",
            "dxDiagram-shapeHorizontalContainer": "Horisontal beholder",
            "dxDiagram-shapeCardDefaultText": "Persons navn",
            "dxDiagram-shapeCardWithImageOnLeft": "Kort med bilde p\xe5 venstre side",
            "dxDiagram-shapeCardWithImageOnTop": "Kort med bilde \xf8verst",
            "dxDiagram-shapeCardWithImageOnRight": "Kort med bilde p\xe5 h\xf8yre side",
            "dxGantt-dialogTitle": "Tittel",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "Slutt",
            "dxGantt-dialogProgressTitle": "Utf\xf8ring",
            "dxGantt-dialogResourcesTitle": "Ressurser",
            "dxGantt-dialogResourceManagerTitle": "Ressursforvalter",
            "dxGantt-dialogTaskDetailsTitle": "Oppgavedetaljer",
            "dxGantt-dialogEditResourceListHint": "Endre ressursliste",
            "dxGantt-dialogEditNoResources": "Ingen ressurser",
            "dxGantt-dialogButtonAdd": "Legg til",
            "dxGantt-contextMenuNewTask": "Ny oppgave",
            "dxGantt-contextMenuNewSubtask": "Ny underoppgave",
            "dxGantt-contextMenuDeleteTask": "Slett oppgave",
            "dxGantt-contextMenuDeleteDependency": "Slett avhengighet",
            "dxGantt-dialogTaskDeleteConfirmation": "Ved \xe5 slette en oppgave, s\xe5 sletter du ogs\xe5 dens avhengigheter og underoppgaver. Er du sikker p\xe5 at du \xf8nsker \xe5 slette denne oppgaven?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Er du sikker p\xe5 at du \xf8nsker \xe5 slette avhengighetene fra denne oppgaven?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Ved \xe5 slette en ressurs , s\xe5 sletter du den ogs\xe5 fra oppgavene der denne ressursen er tildelt. Er du sikker p\xe5 at du \xf8nsker \xe5 slette disse ressursene? Ressurs: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Oppgaven du fors\xf8ker \xe5 flytte er koblet til en annen oppgave ved en avhengighetsrelasjon. Denne endringen vil v\xe6re i strid med avhengighetsregler. Hvordan \xf8nsker du \xe5 fortsette?",
            "dxGantt-dialogConstraintViolationMessage": "Oppgaven du fors\xf8ker \xe5 flytte er koblet til en annen oppgave ved en avhengighetsrelasjon. Hvordan \xf8nsker du \xe5 fortsette?",
            "dxGantt-dialogCancelOperationMessage": "Avbryt operasjonen",
            "dxGantt-dialogDeleteDependencyMessage": "Slett avhengigheten",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Flytt oppgaven og behold avhengigheten",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "angre",
            "dxGantt-redo": "gj\xf8r om",
            "dxGantt-expandAll": "Utvid alle",
            "dxGantt-collapseAll": "Skjul alle",
            "dxGantt-addNewTask": "Legg til ny oppgave",
            "dxGantt-deleteSelectedTask": "Slett valgte oppgave",
            "dxGantt-zoomIn": "Zoom inn",
            "dxGantt-zoomOut": "Zoom ut",
            "dxGantt-fullScreen": "Fullskjerm",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sort Ascending",
            "dxGantt-sortingDescendingText": "Sort Descending",
            "dxGantt-sortingClearText": "Clear Sorting",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
