/*!
* DevExtreme (dx.messages.lv.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        lv: {
            Yes: "J\u0101",
            No: "N\u0113",
            Cancel: "Atcelt",
            CheckState: "Check state",
            Close: "Aizv\u0113rt",
            Clear: "Not\u012br\u012bt",
            Done: "Gatavs",
            Loading: "L\u0101d\u0113...",
            Select: "Izv\u0113l\u0113ties...",
            Search: "Mekl\u0113t",
            Back: "Atpaka\u013c",
            OK: "OK",
            Today: "\u0160odien",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "Nav datu ko att\u0113lot",
            "dxDropDownEditor-selectLabel": "Izv\u0113l\u0113ties",
            "validation-required": "Oblig\u0101ts",
            "validation-required-formatted": "{0} is oblig\u0101ts",
            "validation-numeric": "V\u0113rt\u012bbai j\u0101b\u016bt skaitlim",
            "validation-numeric-formatted": "{0} j\u0101b\u016bt skaitlim",
            "validation-range": "V\u0113rt\u012bba ir \u0101rpus diapazona",
            "validation-range-formatted": "{0} v\u0113rt\u012bba ir \u0101rpus diapazona",
            "validation-stringLength": "V\u0113rt\u012bbas garums nav korekts",
            "validation-stringLength-formatted": "Garums v\u0113rt\u012bbai {0} nav korekts",
            "validation-custom": "V\u0113rt\u012bba ir neder\u012bga",
            "validation-custom-formatted": "{0} ir neder\u012bga",
            "validation-async": "V\u0113rt\u012bba ir neder\u012bga",
            "validation-async-formatted": "{0} ir neder\u012bga",
            "validation-compare": "V\u0113rt\u012bbas nesakr\u012bt",
            "validation-compare-formatted": "{0} nesakr\u012bt",
            "validation-pattern": "V\u0113rt\u012bba neatbilst paternam",
            "validation-pattern-formatted": "{0} neatbilst paternam",
            "validation-email": "E-pasts ir nekorekts",
            "validation-email-formatted": "{0} ir nekorekts",
            "validation-mask": "V\u0113rt\u012bba ir nekorekta",
            "dxLookup-searchPlaceholder": "Minim\u0101lais simbolu skaits: {0}",
            "dxList-pullingDownText": "Vilkt lej\u0101 lai atjaunotu...",
            "dxList-pulledDownText": "Atlaist lai atjaunotu...",
            "dxList-refreshingText": "Atjauno...",
            "dxList-pageLoadingText": "L\u0101d\u0113...",
            "dxList-nextButtonText": "Vair\u0101k",
            "dxList-selectAll": "Izv\u0113l\u0113ties visu",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "Dz\u0113st",
            "dxListEditDecorator-more": "Vair\u0101k",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxList-ariaRoleDescription": "List",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Vilkt lej\u0101 lai atjaunotu...",
            "dxScrollView-pulledDownText": "Atlaist lai atjaunotu...",
            "dxScrollView-refreshingText": "Atjauno...",
            "dxScrollView-reachBottomText": "Iel\u0101d\u0113...",
            "dxDateBox-simulatedDataPickerTitleTime": "Izv\u0113l\u0113ties laiku",
            "dxDateBox-simulatedDataPickerTitleDate": "Izv\u0113l\u0113ties datumu",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Izv\u0113l\u0113ties datumu un laiku",
            "dxDateBox-validation-datetime": "V\u0113rt\u012bbai j\u0101b\u016bt datumam vai laikam",
            "dxDateRangeBox-invalidStartDateMessage": "S\u0101kuma v\u0113rt\u012bbai j\u0101b\u016bt datumam",
            "dxDateRangeBox-invalidEndDateMessage": "Beigu v\u0113rt\u012bbai j\u0101b\u016bt datumam",
            "dxDateRangeBox-startDateOutOfRangeMessage": "S\u0101kuma datums ir \u0101rpus diapazona",
            "dxDateRangeBox-endDateOutOfRangeMessage": "Beigu datums ir \u0101rpus diapazona",
            "dxDateRangeBox-startDateLabel": "S\u0101kuma Datums",
            "dxDateRangeBox-endDateLabel": "Beigu Datums",
            "dxFileUploader-selectFile": "Izv\u0113l\u0113ties failu",
            "dxFileUploader-dropFile": "vai Nomest failu \u0161eit",
            "dxFileUploader-bytes": "baiti",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Aug\u0161upiel\u0101d\u0113t",
            "dxFileUploader-uploaded": "Aug\u0161upiel\u0101d\u0113ts",
            "dxFileUploader-readyToUpload": "Gatavs aug\u0161upiel\u0101dei",
            "dxFileUploader-uploadAbortedMessage": "Aug\u0161upiel\u0101de atcelta",
            "dxFileUploader-uploadFailedMessage": "Aug\u0161upiel\u0101d\u0113jot k\u013c\u016bda",
            "dxFileUploader-invalidFileExtension": "Faila tips nav at\u013cauts",
            "dxFileUploader-invalidMaxFileSize": "Fails ir p\u0101r\u0101k liels",
            "dxFileUploader-invalidMinFileSize": "Fails ir p\u0101r\u0101k mazs",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "No",
            "dxRangeSlider-ariaTill": "L\u012bdz",
            "dxSwitch-switchedOnText": "ON",
            "dxSwitch-switchedOffText": "OFF",
            "dxForm-optionalMark": "neoblig\u0101ts",
            "dxForm-requiredMessage": "{0} ir oblig\u0101ts",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "Atiestat\u012bt",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "V\u0113rt\u012bbai j\u0101b\u016bt skaitlim",
            "dxNumberBox-noDataText": "Nav datu",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Izmanto {0} lai att\u0113lotu kolonnas",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Nomest kolonu no grup\u0113\u0161anas pane\u013ca \u0161eit",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Izmanto {0} vai nomet kolonnu no grup\u0113\u0161anas pane\u013ca",
            "dxDataGrid-emptyHeaderColumnChooserText": "kolonnu izv\u0113lne",
            "dxDataGrid-columnChooserTitle": "Kolonnu Izv\u0113lne",
            "dxDataGrid-columnChooserEmptyText": "Nomest kolonnu lai to pasl\u0113ptu",
            "dxDataGrid-groupContinuesMessage": "Turpin\u0101jums n\u0101kamaj\u0101 lap\u0101",
            "dxDataGrid-groupContinuedMessage": "Turpin\u0101jums no iepriek\u0161\u0113j\u0101s lapas",
            "dxDataGrid-groupHeaderText": "Grup\u0113t p\u0113c \u0160\u012bs Kolonnas",
            "dxDataGrid-ungroupHeaderText": "Atgrup\u0113t",
            "dxDataGrid-ungroupAllText": "Atgrup\u0113t Visu",
            "dxDataGrid-editingEditRow": "Redi\u0123\u0113t",
            "dxDataGrid-editingSaveRowChanges": "Saglab\u0101t",
            "dxDataGrid-editingCancelRowChanges": "Atcelt",
            "dxDataGrid-editingDeleteRow": "Dz\u0113st",
            "dxDataGrid-editingUndeleteRow": "Atgriezt",
            "dxDataGrid-editingConfirmDeleteMessage": "Vai tie\u0161\u0101m v\u0113laties dz\u0113st \u0161o ierakstu?",
            "dxDataGrid-validationCancelChanges": "Atcelt izmai\u0146as",
            "dxDataGrid-groupPanelEmptyText": "Nomest kolonnas galveni \u0161eit p\u0113c kuras grup\u0113t",
            "dxDataGrid-noDataText": "Nav datu",
            "dxDataGrid-searchPanelPlaceholder": "Mekl\u0113t...",
            "dxDataGrid-filterRowShowAllText": "(Viss)",
            "dxDataGrid-filterRowResetOperationText": "Atiestat\u012bt",
            "dxDataGrid-filterRowOperationEquals": "Ir vien\u0101ds",
            "dxDataGrid-filterRowOperationNotEquals": "Nav vien\u0101ds",
            "dxDataGrid-filterRowOperationLess": "Maz\u0101k par",
            "dxDataGrid-filterRowOperationLessOrEquals": "Maz\u0101k vai vien\u0101di ar",
            "dxDataGrid-filterRowOperationGreater": "Vair\u0101k par",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Vair\u0101k vai vien\u0101di ar",
            "dxDataGrid-filterRowOperationStartsWith": "S\u0101kas ar",
            "dxDataGrid-filterRowOperationContains": "Satur",
            "dxDataGrid-filterRowOperationNotContains": "Nesatur",
            "dxDataGrid-filterRowOperationEndsWith": "Beidzas ar",
            "dxDataGrid-filterRowOperationBetween": "Starp",
            "dxDataGrid-filterRowOperationBetweenStartText": "S\u0101kums",
            "dxDataGrid-filterRowOperationBetweenEndText": "Beigas",
            "dxDataGrid-ariaSearchBox": "Mekl\u0113\u0161anas kaste",
            "dxDataGrid-applyFilterText": "Iestat\u012bt filtru",
            "dxDataGrid-trueText": "true",
            "dxDataGrid-falseText": "false",
            "dxDataGrid-sortingAscendingText": "K\u0101rtot Augo\u0161i",
            "dxDataGrid-sortingDescendingText": "K\u0101rtot Dilsto\u0161i",
            "dxDataGrid-sortingClearText": "Not\u012br\u012bt K\u0101rto\u0161anu",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Saglab\u0101t izmai\u0146as",
            "dxDataGrid-editingCancelAllChanges": "Atcelt izmai\u0146as",
            "dxDataGrid-editingAddRow": "Pievienot rindu",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min no {1} ir {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max no {1} ir {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Avg no {1} ir {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Sum of {1} is {0}",
            "dxDataGrid-summaryCount": "Skaits: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "Left",
            "dxDataGrid-columnFixingRightPosition": "Right",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "Eksport\u0113t",
            "dxDataGrid-exportToExcel": "Eksport\u0113t uz Excel failu",
            "dxDataGrid-exporting": "Eksport\u0113...",
            "dxDataGrid-excelFormat": "Excel fails",
            "dxDataGrid-selectedRows": "Izv\u0113l\u0113t\u0101s rindas",
            "dxDataGrid-exportSelectedRows": "Eksport\u0113t izv\u0113l\u0113t\u0101s rindas uz {0}",
            "dxDataGrid-exportAll": "Eksport\u0113t visus datus uz {0}",
            "dxDataGrid-headerFilterLabel": "Filtra opcijas",
            "dxDataGrid-headerFilterIndicatorLabel": "R\u0101d\u012bt filtra opcijas kolonnai '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tuk\u0161i)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Atcelt",
            "dxDataGrid-ariaAdaptiveCollapse": "Sl\u0113pt papildus datus",
            "dxDataGrid-ariaAdaptiveExpand": "R\u0101d\u012bt papildus datus",
            "dxDataGrid-ariaColumn": "Kolonna",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "V\u0113rt\u012bba",
            "dxDataGrid-ariaError": "Error",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filtr\u0113t \u0161\u016bnu",
            "dxDataGrid-ariaCollapse": "Sav\u0113rst",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "Deleted",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Izv\u0113rst",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Datu tabula ar {0} rind\u0101m un {1} kolonn\u0101m",
            "dxDataGrid-ariaSearchInGrid": "Mekl\u0113t datu tabul\u0101",
            "dxDataGrid-ariaSelectAll": "Izv\u0113l\u0113ties visu",
            "dxDataGrid-ariaSelectRow": "Izv\u0113l\u0113ties rindu",
            "dxDataGrid-ariaToolbar": "Datu tabulas r\u012bkjosla",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filtra veidot\u0101js",
            "dxDataGrid-filterPanelCreateFilter": "Izveidot filtru",
            "dxDataGrid-filterPanelClearFilter": "Not\u012br\u012bt",
            "dxDataGrid-filterPanelFilterEnabledHint": "Iesp\u0113jot filtru",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Mekl\u0113t kok\u0101",
            "dxTreeList-ariaToolbar": "Koka r\u012bkjosla",
            "dxTreeList-editingAddRowToNode": "Pievienot",
            "dxPager-infoText": "Lapa {0} no {1} ({2} rindas)",
            "dxPager-pagesCountText": "no",
            "dxPager-pageSize": "Rindas lap\u0101: {0}",
            "dxPager-pageSizesAllText": "Viss",
            "dxPager-page": "Lapa {0}",
            "dxPager-prevPage": "Iepriek\u0161\u0113j\u0101 Lapa",
            "dxPager-nextPage": "N\u0101kam\u0101 Lapa",
            "dxPager-ariaLabel": "Lapu Navig\u0101cija",
            "dxPager-ariaPageSize": "Lapas izm\u0113rs",
            "dxPager-ariaPageNumber": "Lapas numurs",
            "dxPagination-infoText": "Lapa {0} no {1} ({2} rindas)",
            "dxPagination-pagesCountText": "no",
            "dxPagination-pageSize": "Rindas lap\u0101: {0}",
            "dxPagination-pageSizesAllText": "Viss",
            "dxPagination-page": "Lapa {0}",
            "dxPagination-prevPage": "Iepriek\u0161\u0113j\u0101 Lapa",
            "dxPagination-nextPage": "N\u0101kam\u0101 Lapa",
            "dxPagination-ariaLabel": "Lapu Navig\u0101cija",
            "dxPagination-ariaPageSize": "Lapas izm\u0113rs",
            "dxPagination-ariaPageNumber": "Lapas numurs",
            "dxPivotGrid-grandTotal": "Kopsumm\u0101",
            "dxPivotGrid-total": "{0} Summ\u0101",
            "dxPivotGrid-fieldChooserTitle": "Lauka izv\u0113le",
            "dxPivotGrid-showFieldChooser": "R\u0101d\u012bt Lauka Izv\u0113li",
            "dxPivotGrid-expandAll": "Izv\u0113rst Visu",
            "dxPivotGrid-collapseAll": "Sav\u0113rst Visu",
            "dxPivotGrid-sortColumnBySummary": 'K\u0101rtot "{0}" p\u0113c \u0160\u012bs Kolonnas',
            "dxPivotGrid-sortRowBySummary": 'K\u0101rtot "{0}" p\u0113c \u0160\u012bs Rindas',
            "dxPivotGrid-removeAllSorting": "No\u0146emt Visu K\u0101rto\u0161anu",
            "dxPivotGrid-dataNotAvailable": "N/A",
            "dxPivotGrid-rowFields": "Rindas Lauki",
            "dxPivotGrid-columnFields": "Kolonnas Lauki",
            "dxPivotGrid-dataFields": "Datu Lauki",
            "dxPivotGrid-filterFields": "Filtra Lauki",
            "dxPivotGrid-allFields": "Visi Lauki",
            "dxPivotGrid-columnFieldArea": "Nomest Kolonnu Laukus \u0160eit",
            "dxPivotGrid-dataFieldArea": "Nomest Datu Laukus \u0160eit",
            "dxPivotGrid-rowFieldArea": "Nomest Rindu Laukus \u0160eit",
            "dxPivotGrid-filterFieldArea": "Nomest Filtra Laukus \u0160eit",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-appointmentListAriaLabel": "Appointment list",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Nosaukums",
            "dxScheduler-editorLabelStartDate": "S\u0101kuma Datums",
            "dxScheduler-editorLabelEndDate": "Beigu Datums",
            "dxScheduler-editorLabelDescription": "Apraksts",
            "dxScheduler-editorLabelRecurrence": "Atk\u0101rtot",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "Previous page",
            "dxScheduler-navigationNext": "Next page",
            "dxScheduler-openAppointment": "Atv\u0113rt apmekl\u0113jumu",
            "dxScheduler-recurrenceNever": "Nekad",
            "dxScheduler-recurrenceMinutely": "Katru min\u016bti",
            "dxScheduler-recurrenceHourly": "Ik stundu",
            "dxScheduler-recurrenceDaily": "Ik dienu",
            "dxScheduler-recurrenceWeekly": "Ik ned\u0113\u013cu",
            "dxScheduler-recurrenceMonthly": "Ik m\u0113nesi",
            "dxScheduler-recurrenceYearly": "Ik gadu",
            "dxScheduler-recurrenceRepeatEvery": "Atk\u0101rtot Katru",
            "dxScheduler-recurrenceRepeatOn": "Atk\u0101rtot",
            "dxScheduler-recurrenceEnd": "P\u0101rst\u0101t Atk\u0101rto\u0161anu",
            "dxScheduler-recurrenceAfter": "P\u0113c",
            "dxScheduler-recurrenceOn": "On",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "min\u016bte(s)",
            "dxScheduler-recurrenceRepeatHourly": "stunda(s)",
            "dxScheduler-recurrenceRepeatDaily": "diena(s)",
            "dxScheduler-recurrenceRepeatWeekly": "ned\u0113\u013ca(s)",
            "dxScheduler-recurrenceRepeatMonthly": "m\u0113ne\u0161u(s)",
            "dxScheduler-recurrenceRepeatYearly": "gadu(s)",
            "dxScheduler-switcherDay": "Diena",
            "dxScheduler-switcherWeek": "Ned\u0113\u013ca",
            "dxScheduler-switcherWorkWeek": "Darba Ned\u0113\u013ca",
            "dxScheduler-switcherMonth": "M\u0113nesis",
            "dxScheduler-switcherAgenda": "K\u0101rt\u012bba",
            "dxScheduler-switcherTimelineDay": "Laika skala Diena",
            "dxScheduler-switcherTimelineWeek": "Laik skala Ned\u0113\u013ca",
            "dxScheduler-switcherTimelineWorkWeek": "Laika skala Darba Ned\u0113\u013ca",
            "dxScheduler-switcherTimelineMonth": "Laika skala M\u0113nesis",
            "dxScheduler-recurrenceRepeatOnDate": "datum\u0101",
            "dxScheduler-recurrenceRepeatCount": "atk\u0101rto\u0161an\u0101(s)",
            "dxScheduler-allDay": "Visa diena",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Vai v\u0113laties atk\u0101rtot \u0161o apmekl\u0113jumu vai visu apmekl\u0113jumu sec\u012bbu?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Vai v\u0113laties dz\u0113st \u0161o apmekl\u0113jumu vai visu apmekl\u0113jumu sec\u012bbu?",
            "dxScheduler-confirmRecurrenceEditSeries": "Redi\u0123\u0113t sec\u012bbu",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Dz\u0113st sec\u012bbu",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Redi\u0123\u0113t apmekl\u0113jumu",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Dz\u0113st apmekl\u0113jumu",
            "dxScheduler-noTimezoneTitle": "Nav laika josla",
            "dxScheduler-moreAppointments": "{0} vair\u0101k",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "\u0160odien",
            "dxCalendar-ariaWidgetName": "Kalend\u0101rs",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "Next year",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-cancelEditingButtonAriaLabel": "Atcelt",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "Redi\u0123\u0113t",
            "dxChat-editingDeleteMessage": "Dz\u0113st",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "Sarkans",
            "dxColorView-ariaGreen": "Za\u013c\u0161",
            "dxColorView-ariaBlue": "Zils",
            "dxColorView-ariaAlpha": "Caursp\u012bd\u012bba",
            "dxColorView-ariaHex": "Kr\u0101sas kods",
            "dxTagBox-selected": "{0} izv\u0113l\u0113tie",
            "dxTagBox-allSelected": "Visi izv\u0113l\u0113tie ({0})",
            "dxTagBox-moreSelected": "{0} vair\u0101k",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "dxTagBox-ariaRoleDescription": "Tag box",
            "vizExport-printingButtonText": "Druk\u0101t",
            "vizExport-titleMenuText": "Eksport\u0113\u0161ana/Druk\u0101\u0161ana",
            "vizExport-exportButtonText": "{0} fails",
            "dxFilterBuilder-and": "Un",
            "dxFilterBuilder-or": "Vai",
            "dxFilterBuilder-notAnd": "Ne Un",
            "dxFilterBuilder-notOr": "Ne Vai",
            "dxFilterBuilder-addCondition": "Pievienot Nosac\u012bjumu",
            "dxFilterBuilder-addGroup": "Pievienot Grupu",
            "dxFilterBuilder-enterValueText": "<ievad\u012bt v\u0113rt\u012bbu>",
            "dxFilterBuilder-filterOperationEquals": "Vien\u0101ds",
            "dxFilterBuilder-filterOperationNotEquals": "Nav vien\u0101ds",
            "dxFilterBuilder-filterOperationLess": "Maz\u0101ks par",
            "dxFilterBuilder-filterOperationLessOrEquals": "Maz\u0101ks vai vien\u0101ds ar",
            "dxFilterBuilder-filterOperationGreater": "Liel\u0101ks par",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Liel\u0101ks vai vien\u0101ds ar",
            "dxFilterBuilder-filterOperationStartsWith": "S\u0101kas ar",
            "dxFilterBuilder-filterOperationContains": "Satur",
            "dxFilterBuilder-filterOperationNotContains": "Nesatur",
            "dxFilterBuilder-filterOperationEndsWith": "Beidzas Ar",
            "dxFilterBuilder-filterOperationIsBlank": "Ir tuk\u0161s",
            "dxFilterBuilder-filterOperationIsNotBlank": "Nav tuk\u0161s",
            "dxFilterBuilder-filterOperationBetween": "Ir starp",
            "dxFilterBuilder-filterOperationAnyOf": "Ir viens no",
            "dxFilterBuilder-filterOperationNoneOf": "Nav neviens no",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Add",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Nomain\u012bt Fonta Kr\u0101su",
            "dxHtmlEditor-dialogBackgroundCaption": "Nomain\u012bt Fona Kr\u0101su",
            "dxHtmlEditor-dialogLinkCaption": "Pievienot saiti",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Teksts",
            "dxHtmlEditor-dialogLinkTargetField": "Atv\u0113rt saiti jaun\u0101 log\u0101",
            "dxHtmlEditor-dialogImageCaption": "Pievienot bildi",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternat\u012bvs",
            "dxHtmlEditor-dialogImageWidthField": "Platums (px)",
            "dxHtmlEditor-dialogImageHeightField": "Augstums (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rindas",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Kolonnas",
            "dxHtmlEditor-dialogInsertTableCaption": "Ievietot Tabulu",
            "dxHtmlEditor-dialogUpdateImageCaption": "Atjaunot Bildi",
            "dxHtmlEditor-dialogImageUpdateButton": "Atjaunot",
            "dxHtmlEditor-dialogImageAddButton": "Pievienot",
            "dxHtmlEditor-dialogImageSpecifyUrl": "No T\u012bkla",
            "dxHtmlEditor-dialogImageSelectFile": "No \u0160\u012bs Ier\u012bces",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Saglab\u0101t Aspekta Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Kod\u0113t uz Base64",
            "dxHtmlEditor-heading": "Virsraksts",
            "dxHtmlEditor-normalText": "Parasts teksts",
            "dxHtmlEditor-background": "Fona Kr\u0101sa",
            "dxHtmlEditor-bold": "Biezs",
            "dxHtmlEditor-color": "Fonta Kr\u0101sa",
            "dxHtmlEditor-font": "Fonts",
            "dxHtmlEditor-italic": "Sl\u012bps",
            "dxHtmlEditor-link": "Pievienot Saiti",
            "dxHtmlEditor-image": "Pievienot Bildi",
            "dxHtmlEditor-size": "Izm\u0113rs",
            "dxHtmlEditor-strike": "Sv\u012btrots",
            "dxHtmlEditor-subscript": "Apak\u0161raksts",
            "dxHtmlEditor-superscript": "Aug\u0161raksts",
            "dxHtmlEditor-underline": "Pasv\u012btrojums",
            "dxHtmlEditor-blockquote": "Cit\u0101ts",
            "dxHtmlEditor-header": "Galvene",
            "dxHtmlEditor-increaseIndent": "Palielin\u0101t Atstarpi",
            "dxHtmlEditor-decreaseIndent": "Samazin\u0101t Ievilkumu",
            "dxHtmlEditor-orderedList": "Sak\u0101rtots Saraksts",
            "dxHtmlEditor-bulletList": "Atz\u012bm\u0113ts Saraksts",
            "dxHtmlEditor-alignLeft": "Izl\u012bdzin\u0101t pa Kreisi",
            "dxHtmlEditor-alignCenter": "Centr\u0113t",
            "dxHtmlEditor-alignRight": "Izl\u012bdzin\u0101t pa Labi",
            "dxHtmlEditor-alignJustify": "Izl\u012bdzin\u0101t Taisnoti",
            "dxHtmlEditor-codeBlock": "Koda Gabals",
            "dxHtmlEditor-variable": "Pievienot Main\u012bgo",
            "dxHtmlEditor-undo": "Atcelt",
            "dxHtmlEditor-redo": "Atsaukt Atcel\u0161anu",
            "dxHtmlEditor-clear": "Not\u012br\u012bt Format\u0113jumu",
            "dxHtmlEditor-insertTable": "Ievietot Tabulu",
            "dxHtmlEditor-insertHeaderRow": "Ievietot Galvenes Rindu",
            "dxHtmlEditor-insertRowAbove": "Ievietot Rindu Virs",
            "dxHtmlEditor-insertRowBelow": "Ievietot Rindu Zem",
            "dxHtmlEditor-insertColumnLeft": "Ievietot Kolonnu pa Kreisi",
            "dxHtmlEditor-insertColumnRight": "Ievietot Kolonnu pa Labi",
            "dxHtmlEditor-deleteColumn": "Dz\u0113st Kolonnu",
            "dxHtmlEditor-deleteRow": "Dz\u0113st Rindu",
            "dxHtmlEditor-deleteTable": "Dz\u0113st Tabulu",
            "dxHtmlEditor-cellProperties": "\u0160\u016bnas \u012apa\u0161\u012bbas",
            "dxHtmlEditor-tableProperties": "Tabulas \u012apa\u0161\u012bbas",
            "dxHtmlEditor-insert": "Ielikt",
            "dxHtmlEditor-delete": "Dz\u0113st",
            "dxHtmlEditor-border": "Robe\u017ea",
            "dxHtmlEditor-style": "Stils",
            "dxHtmlEditor-width": "Platums",
            "dxHtmlEditor-height": "Augstums",
            "dxHtmlEditor-borderColor": "Kr\u0101sa",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Fons",
            "dxHtmlEditor-dimensions": "Dimensijas",
            "dxHtmlEditor-alignment": "Centr\u0113jums",
            "dxHtmlEditor-horizontal": "Horizont\u0101ls",
            "dxHtmlEditor-vertical": "Vertik\u0101ls",
            "dxHtmlEditor-paddingVertical": "Vertik\u0101ls Pop\u0113jums",
            "dxHtmlEditor-paddingHorizontal": "Horizont\u0101ls Pop\u0113jums",
            "dxHtmlEditor-pixels": "Pikse\u013ci",
            "dxHtmlEditor-list": "Saraksts",
            "dxHtmlEditor-ordered": "Sak\u0101rtots",
            "dxHtmlEditor-bullet": "Iez\u012bm\u0113ts",
            "dxHtmlEditor-align": "Centr\u0113jums",
            "dxHtmlEditor-center": "Centrs",
            "dxHtmlEditor-left": "Pa Kreisi",
            "dxHtmlEditor-right": "Pa Labi",
            "dxHtmlEditor-indent": "Ievilkums",
            "dxHtmlEditor-justify": "Taisnot",
            "dxHtmlEditor-borderStyleNone": "none",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "solid",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Nenosaukta direktorija",
            "dxFileManager-rootDirectoryName": "Faili",
            "dxFileManager-errorNoAccess": "Piek\u013cuve liegta. Oper\u0101ciju nevar\u0113ja izpild\u012bt.",
            "dxFileManager-errorDirectoryExistsFormat": "Direktorija '{0}' jau eksist\u0113.",
            "dxFileManager-errorFileExistsFormat": "Fails '{0}' jau eksist\u0113.",
            "dxFileManager-errorFileNotFoundFormat": "Fails '{0}' nav atrasts.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Direktorija '{0}' nav atrasta",
            "dxFileManager-errorWrongFileExtension": "Faila papla\u0161in\u0101jums nav at\u013cauts.",
            "dxFileManager-errorMaxFileSizeExceeded": "Faila izm\u0113rs p\u0101rsniedz maksim\u0101lo at\u013cauto.",
            "dxFileManager-errorInvalidSymbols": "Nosaukums satur neat\u013cautus simbolus.",
            "dxFileManager-errorDefault": "Nespecific\u0113ta k\u013c\u016bda.",
            "dxFileManager-errorDirectoryOpenFailed": "Direktoriju nevar atv\u0113rt",
            "dxFileManager-commandCreate": "Jauna direktorija",
            "dxFileManager-commandRename": "P\u0101rsaukt",
            "dxFileManager-commandMove": "P\u0101rvietot Uz",
            "dxFileManager-commandCopy": "Kop\u0113t Uz",
            "dxFileManager-commandDelete": "Dz\u0113st",
            "dxFileManager-commandDownload": "Lejupiel\u0101d\u0113t",
            "dxFileManager-commandUpload": "Aug\u0161upiel\u0101d\u0113t Failus",
            "dxFileManager-commandRefresh": "Atjaunot",
            "dxFileManager-commandThumbnails": "S\u012bkt\u0113lu Skats",
            "dxFileManager-commandDetails": "Detaliz\u0113ts Skats",
            "dxFileManager-commandClearSelection": "Not\u012br\u012bt izv\u0113lni",
            "dxFileManager-commandShowNavPane": "P\u0101rsl\u0113gt navig\u0101cijas r\u016bti",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "P\u0101rvietot uz",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "P\u0101rvietot",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kop\u0113t uz",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kop\u0113t",
            "dxFileManager-dialogRenameItemTitle": "P\u0101rsaukt",
            "dxFileManager-dialogRenameItemButtonText": "Saglab\u0101t",
            "dxFileManager-dialogCreateDirectoryTitle": "Jauna direktorija",
            "dxFileManager-dialogCreateDirectoryButtonText": "Izveidot",
            "dxFileManager-dialogDeleteItemTitle": "Dz\u0113st",
            "dxFileManager-dialogDeleteItemButtonText": "Dz\u0113st",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Vai tie\u0161\u0101m v\u0113laties dz\u0113st {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Vai tie\u0161\u0101m v\u0113laties dz\u0113st {0} ierakstus?",
            "dxFileManager-dialogButtonCancel": "Atcelt",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Izveidot direktoriju iek\u0161 {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Izveidota direktorija iek\u0161 {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Direktorija netika izveidota",
            "dxFileManager-editingCreateCommonErrorMessage": "Direktorija netika izveidota",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "P\u0101rsauc ierakstu iek\u0161 {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "P\u0101rsaukts ieraksts iek\u0161 {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Ieraksts netika p\u0101rsaukts",
            "dxFileManager-editingRenameCommonErrorMessage": "Ieraksts netika p\u0101rsaukts",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Dz\u0113\u0161 ierakstu no {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Dz\u0113\u0161t {0} ierakstus no {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Izdz\u0113sts ieraksts no {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Izdz\u0113sti {0} ieraksti no {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Ieraksts netika izdz\u0113sts",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} ieraksti netika izdz\u0113sti",
            "dxFileManager-editingDeleteCommonErrorMessage": "Da\u017ei ieraksti netika izdz\u0113sti",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "P\u0101rvieto ierakstu uz {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "P\u0101rvieto {0} ierakstus uz {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "P\u0101rvietoja ierakstu uz {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "P\u0101rvietoja {0} ierakstus uz {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Ieraksts netika p\u0101rvietots",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} ieraksti ",
            "dxFileManager-editingMoveCommonErrorMessage": "Da\u017ei ieraksti netika dz\u0113st",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kop\u0113 ierakstu uz {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kop\u0113 {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Nokop\u0113ja ierakstu uz {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Nokop\u0113ja {0} ierakstus uz {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Ieraksts netika nokop\u0113ts",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} ieraksti netika nokop\u0113ti",
            "dxFileManager-editingCopyCommonErrorMessage": "Da\u017ei ieraksti netika nokop\u0113ti",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Aug\u0161upiel\u0101d\u0113 ierakstu uz {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Aug\u0161upiel\u0101d\u0113 {0} ierakstus uz {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Aug\u0161upiel\u0101d\u0113ja ierakstu uz {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Aug\u0161up\u0113ja {0} ierakstus uz {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Ieraksts netika aug\u0161upiel\u0101d\u0113ts",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} ieraksti netika aug\u0161upiel\u0101d\u0113ti",
            "dxFileManager-editingUploadCanceledMessage": "Atcelts",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Ieraksts netika lejupiel\u0101d\u0113ts",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} ieraksti netika lejupiel\u0101d\u0113ti",
            "dxFileManager-listDetailsColumnCaptionName": "Nosaukums",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Modifik\u0101cijas Datums",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Faila Izm\u0113rs",
            "dxFileManager-listThumbnailsTooltipTextSize": "Izm\u0113rs",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Modifik\u0101cijas Datums",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "Nav oper\u0101cijas",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Atcelts",
            "dxDiagram-categoryGeneral": "Visp\u0101r\u0113ji",
            "dxDiagram-categoryFlowchart": "Bloksh\u0113ma",
            "dxDiagram-categoryOrgChart": "Organiz\u0101cijas diagramma",
            "dxDiagram-categoryContainers": "Konteineri",
            "dxDiagram-categoryCustom": "Piel\u0101goti",
            "dxDiagram-commandExportToSvg": "Eksport\u0113t uz SVG",
            "dxDiagram-commandExportToPng": "Eksport\u0113t uz PNG",
            "dxDiagram-commandExportToJpg": "Eksport\u0113t uz JPEG",
            "dxDiagram-commandUndo": "Atcelt",
            "dxDiagram-commandRedo": "Atsaukt Atcel\u0161anu",
            "dxDiagram-commandFontName": "Fonta nosaukums",
            "dxDiagram-commandFontSize": "Fonta izm\u0113rs",
            "dxDiagram-commandBold": "Biezs",
            "dxDiagram-commandItalic": "Sl\u012bps",
            "dxDiagram-commandUnderline": "Pasv\u012btrots",
            "dxDiagram-commandTextColor": "Fonta Kr\u0101sa",
            "dxDiagram-commandLineColor": "L\u012bnijas Kr\u0101sa",
            "dxDiagram-commandLineWidth": "L\u012bnijas Platums",
            "dxDiagram-commandLineStyle": "L\u012bnijas Stils",
            "dxDiagram-commandLineStyleSolid": "Solid",
            "dxDiagram-commandLineStyleDotted": "Nep\u0101rtraukti",
            "dxDiagram-commandLineStyleDashed": "Str\u012bpaini",
            "dxDiagram-commandFillColor": "Aizpild\u012bt Kr\u0101su",
            "dxDiagram-commandAlignLeft": "Centr\u0113t Pa Kreisi",
            "dxDiagram-commandAlignCenter": "Centr\u0113t Vid\u016b",
            "dxDiagram-commandAlignRight": "Centr\u0113t Pa Labi",
            "dxDiagram-commandConnectorLineType": "Konektora L\u012bnijas Tips",
            "dxDiagram-commandConnectorLineStraight": "Taisni",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogon\u0101li",
            "dxDiagram-commandConnectorLineStart": "Konektora L\u012bnijas S\u0101kums",
            "dxDiagram-commandConnectorLineEnd": "Konektora L\u012bnijas Beigas",
            "dxDiagram-commandConnectorLineNone": "Nav",
            "dxDiagram-commandConnectorLineArrow": "Bulta",
            "dxDiagram-commandFullscreen": "Pilnekr\u0101ns",
            "dxDiagram-commandUnits": "Vien\u012bbas",
            "dxDiagram-commandPageSize": "Lapas Izm\u0113rs",
            "dxDiagram-commandPageOrientation": "Lapas Orient\u0101cija",
            "dxDiagram-commandPageOrientationLandscape": "Ainava",
            "dxDiagram-commandPageOrientationPortrait": "Portrets",
            "dxDiagram-commandPageColor": "Lapas Kr\u0101sa",
            "dxDiagram-commandShowGrid": "R\u0101d\u012bt Tabulu",
            "dxDiagram-commandSnapToGrid": "Piestiprin\u0101t Tabulai",
            "dxDiagram-commandGridSize": "Tabulas Izm\u0113rs",
            "dxDiagram-commandZoomLevel": "Pietuvin\u0101jums",
            "dxDiagram-commandAutoZoom": "Autm\u0101tiski pietuvin\u0101t",
            "dxDiagram-commandFitToContent": "Piel\u0101got Saturam",
            "dxDiagram-commandFitToWidth": "Piel\u0101got Platumam",
            "dxDiagram-commandAutoZoomByContent": "Autom\u0101tiski Tuvin\u0101t p\u0113c Satura",
            "dxDiagram-commandAutoZoomByWidth": "Autom\u0101tiski Tuvin\u0101t p\u0113c Platuma",
            "dxDiagram-commandSimpleView": "Parasts Skats",
            "dxDiagram-commandCut": "Izgriezt",
            "dxDiagram-commandCopy": "Kop\u0113t",
            "dxDiagram-commandPaste": "Iel\u012bm\u0113t",
            "dxDiagram-commandSelectAll": "Izv\u0113l\u0113ties Visu",
            "dxDiagram-commandDelete": "Dz\u0113st",
            "dxDiagram-commandBringToFront": "Novietot priek\u0161\u0101",
            "dxDiagram-commandSendToBack": "Novietot aizmugur\u0113",
            "dxDiagram-commandLock": "Sl\u0113gt",
            "dxDiagram-commandUnlock": "Atsl\u0113gt",
            "dxDiagram-commandInsertShapeImage": "Ievietot Att\u0113lu...",
            "dxDiagram-commandEditShapeImage": "Main\u012bt Att\u0113lu...",
            "dxDiagram-commandDeleteShapeImage": "Dz\u0113st Att\u0113lu",
            "dxDiagram-commandLayoutLeftToRight": "Kreisi-uz-labi",
            "dxDiagram-commandLayoutRightToLeft": "Labi-uz-kreisi",
            "dxDiagram-commandLayoutTopToBottom": "Aug\u0161a-uz-apak\u0161u",
            "dxDiagram-commandLayoutBottomToTop": "Apak\u0161a-uz-aug\u0161u",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Atcelt",
            "dxDiagram-dialogInsertShapeImageTitle": "Ievietot",
            "dxDiagram-dialogEditShapeImageTitle": "Nomain\u012bt Att\u0113lu",
            "dxDiagram-dialogEditShapeImageSelectButton": "Izv\u0113l\u0113ties att\u0113lu",
            "dxDiagram-dialogEditShapeImageLabelText": "vai nomest failu \u0161eit",
            "dxDiagram-uiExport": "Eksport\u0113t",
            "dxDiagram-uiProperties": "\u012apa\u0161\u012bbas",
            "dxDiagram-uiSettings": "Iestat\u012bjumi",
            "dxDiagram-uiShowToolbox": "R\u0101d\u012bt R\u012bkjoslu",
            "dxDiagram-uiSearch": "Mekl\u0113t",
            "dxDiagram-uiStyle": "Stils",
            "dxDiagram-uiLayout": "Izk\u0101rtojums",
            "dxDiagram-uiLayoutTree": "Koks",
            "dxDiagram-uiLayoutLayered": "Sl\u0101\u0146ots",
            "dxDiagram-uiDiagram": "Diagramma",
            "dxDiagram-uiText": "Teksts",
            "dxDiagram-uiObject": "Objekts",
            "dxDiagram-uiConnector": "Konektors",
            "dxDiagram-uiPage": "Lapa",
            "dxDiagram-shapeText": "Teksts",
            "dxDiagram-shapeRectangle": "Taisnst\u016bris",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Krusts",
            "dxDiagram-shapeTriangle": "Tr\u012bsst\u016bris",
            "dxDiagram-shapeDiamond": "Dimants",
            "dxDiagram-shapeHeart": "Sirds",
            "dxDiagram-shapePentagon": "Pentagons",
            "dxDiagram-shapeHexagon": "Heksagons",
            "dxDiagram-shapeOctagon": "Oktagons",
            "dxDiagram-shapeStar": "Zvaigzne",
            "dxDiagram-shapeArrowLeft": "Bulta pa Kreisi",
            "dxDiagram-shapeArrowUp": "Bulta uz Aug\u0161u",
            "dxDiagram-shapeArrowRight": "Bulta pa Labi",
            "dxDiagram-shapeArrowDown": "Bulta uz Leju",
            "dxDiagram-shapeArrowUpDown": "Bulta Aug\u0161\u0101 Lej\u0101",
            "dxDiagram-shapeArrowLeftRight": "Bulta pa Labi pa Kreisi",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Izv\u0113le",
            "dxDiagram-shapeTerminator": "Beigas",
            "dxDiagram-shapePredefinedProcess": "Iepriek\u0161defin\u0113ts Process",
            "dxDiagram-shapeDocument": "Dokuments",
            "dxDiagram-shapeMultipleDocuments": "Vair\u0101ki Dokumenti",
            "dxDiagram-shapeManualInput": "Manu\u0101la Ievade",
            "dxDiagram-shapePreparation": "Sagatave",
            "dxDiagram-shapeData": "Dati",
            "dxDiagram-shapeDatabase": "Datub\u0101ze",
            "dxDiagram-shapeHardDisk": "Cietais Disks",
            "dxDiagram-shapeInternalStorage": "Iek\u0161\u0113j\u0101 Kr\u0101tuve",
            "dxDiagram-shapePaperTape": "Pap\u012bra Lente",
            "dxDiagram-shapeManualOperation": "Manu\u0101la Oper\u0101cija",
            "dxDiagram-shapeDelay": "Aizkave",
            "dxDiagram-shapeStoredData": "Saglab\u0101ti Dati",
            "dxDiagram-shapeDisplay": "Displejs",
            "dxDiagram-shapeMerge": "Sapl\u016bde",
            "dxDiagram-shapeConnector": "Konektors",
            "dxDiagram-shapeOr": "Vai",
            "dxDiagram-shapeSummingJunction": "Summ\u0113\u0161anas krustojums",
            "dxDiagram-shapeContainerDefaultText": "Konteineris",
            "dxDiagram-shapeVerticalContainer": "Vertik\u0101ls Konteineris",
            "dxDiagram-shapeHorizontalContainer": "Horizont\u0101ls Konteineris",
            "dxDiagram-shapeCardDefaultText": "Personas V\u0101rds",
            "dxDiagram-shapeCardWithImageOnLeft": "Karti\u0146a ar Att\u0113lu pa Kreisi",
            "dxDiagram-shapeCardWithImageOnTop": "Karti\u0146a ar Att\u0113lu Aug\u0161\u0101",
            "dxDiagram-shapeCardWithImageOnRight": "Karti\u0146a ar Att\u0113lu pa Labi",
            "dxGantt-dialogTitle": "Virsraksts",
            "dxGantt-dialogStartTitle": "S\u0101kums",
            "dxGantt-dialogEndTitle": "Beigas",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resursi",
            "dxGantt-dialogResourceManagerTitle": "Resursu Kr\u0101tuve",
            "dxGantt-dialogTaskDetailsTitle": "Uzdevuma Deta\u013cas",
            "dxGantt-dialogEditResourceListHint": "Redi\u0123\u0113t Resursu Sarakstu",
            "dxGantt-dialogEditNoResources": "Nav Resursu",
            "dxGantt-dialogButtonAdd": "Pievienot",
            "dxGantt-contextMenuNewTask": "Jauns Uzdevums",
            "dxGantt-contextMenuNewSubtask": "Jauns Apak\u0161uzdevums",
            "dxGantt-contextMenuDeleteTask": "Dz\u0113st Uzdevumu",
            "dxGantt-contextMenuDeleteDependency": "Dz\u0113st sasaistes",
            "dxGantt-dialogTaskDeleteConfirmation": "Dz\u0113\u0161ot uzdevumu tiek ar\u012b dz\u0113stas visas t\u0101 sasaistes un apak\u0161uzdevumi. Vai tie\u0161\u0101m v\u0113laties dz\u0113st \u0161o uzdevumu?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Vai tie\u0161\u0101m v\u0113laties dz\u0113st sasaisti no \u0161\u012b uzdevuma?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Dz\u0113\u0161ot resursu tiek ar\u012b izdz\u0113sti uzdevumi, kam \u0161is resurss ir piesaist\u012bts. Vai tie\u0161\u0101m v\u0113laties dz\u0113st resursus? Resursi: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Uzdevums, kuru v\u0113laties p\u0101rvietot ir sasaist\u012bts ar citu uzdevumu. \u0160\u012b izmai\u0146a konflikt\u0113 ar sasaistes nosac\u012bjumiem. K\u0101 J\u016bs v\u0113l\u0113aties turpin\u0101t?",
            "dxGantt-dialogConstraintViolationMessage": "Uzdevums kuru v\u0113laties p\u0101rvietot ir saist\u012bts ar citu uzdevumu. K\u0101 J\u016bs v\u0113laties turpin\u0101t?",
            "dxGantt-dialogCancelOperationMessage": "Atcelt oper\u0101ciju",
            "dxGantt-dialogDeleteDependencyMessage": "Dz\u0113st sasaisti",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "P\u0101rvietot uzdevumu un saglab\u0101t sasaisti",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "Uzdevums kuru v\u0113laties p\u0101rvietot ir saist\u012bts ar citiem uzdevumiem. K\u0101 J\u016bs v\u0113laties turpin\u0101t?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "Uzdevums kuru v\u0113laties p\u0101rvietot ir saist\u012bts ar citu uzdevumu. K\u0101 J\u016bs v\u0113laties turpin\u0101t?",
            "dxGantt-dialogDeleteDependenciesMessage": "Dz\u0113st sasaistes",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "P\u0101rvietot uzdevumu un saglab\u0101t sasaistes",
            "dxGantt-undo": "Atcelt",
            "dxGantt-redo": "Atsaukt Atcel\u0161anu",
            "dxGantt-expandAll": "Izv\u0113rst Visu",
            "dxGantt-collapseAll": "Sav\u0113rst Visu",
            "dxGantt-addNewTask": "Pievienot Jaunu Uzdevumu",
            "dxGantt-deleteSelectedTask": "Dz\u0113st Izv\u0113l\u0113to Uzdevumu",
            "dxGantt-zoomIn": "Pietuvin\u0101t",
            "dxGantt-zoomOut": "Att\u0101lin\u0101t",
            "dxGantt-fullScreen": "Pilnekr\u0101ns",
            "dxGantt-quarter": "C{0}",
            "dxGantt-sortingAscendingText": "K\u0101rtot Augo\u0161i",
            "dxGantt-sortingDescendingText": "K\u0101rtot Dilsto\u0161i",
            "dxGantt-sortingClearText": "Not\u012br\u012bt K\u0101rto\u0161anu",
            "dxGantt-showResources": "R\u0101d\u012bt Resursus",
            "dxGantt-showDependencies": "R\u0101d\u012bt Sasaistes",
            "dxGantt-dialogStartDateValidation": "S\u0101kuma datumam j\u0101b\u016bt v\u0113l\u0101kam par {0}",
            "dxGantt-dialogEndDateValidation": "Beigu datumam j\u0101b\u016bt v\u0113l\u0101kam par {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "View",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
