/*!
* DevExtreme (dx.messages.fr.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        fr: {
            Yes: "Oui",
            No: "Non",
            Cancel: "Annuler",
            CheckState: "V\xe9rifier l'\xe9tat",
            Close: "Fermer",
            Clear: "Vider",
            Done: "Termin\xe9",
            Loading: "Chargement...",
            Select: "S\xe9lection...",
            Search: "Recherche",
            Back: "Retour",
            OK: "OK",
            Today: "Aujourd'hui",
            Yesterday: "Hier",
            "dxCollectionWidget-noDataText": "Pas de donn\xe9es",
            "dxDropDownEditor-selectLabel": "S\xe9lection",
            "validation-required": "Obligatoire",
            "validation-required-formatted": "{0} est obligatoire",
            "validation-numeric": "La valeur doit \xeatre un nombre",
            "validation-numeric-formatted": "{0} doit \xeatre un nombre",
            "validation-range": "La valeur ne se trouve pas dans la plage valide",
            "validation-range-formatted": "{0} ne se trouve pas dans la plage valide",
            "validation-stringLength": "La longueur de la valeur est incorrecte",
            "validation-stringLength-formatted": "La longueur de {0} est incorrecte",
            "validation-custom": "La valeur est invalide",
            "validation-custom-formatted": "{0} est invalide",
            "validation-async": "La valeur est invalide",
            "validation-async-formatted": "{0} est invalide",
            "validation-compare": "La valeur est inappropri\xe9e",
            "validation-compare-formatted": "{0} est inappropri\xe9e",
            "validation-pattern": "La valeur ne correspond pas au mod\xe8le",
            "validation-pattern-formatted": "{0} ne correspond pas au mod\xe8le",
            "validation-email": "L'adresse email est invalide",
            "validation-email-formatted": "{0} est invalide",
            "validation-mask": "La valeur est invalide",
            "dxLookup-searchPlaceholder": "Nombre minimum de caract\xe8res: {0}",
            "dxList-pullingDownText": "Tirez vers le bas pour actualiser...",
            "dxList-pulledDownText": "Relacher pour actualiser...",
            "dxList-refreshingText": "Actualisation...",
            "dxList-pageLoadingText": "Chargement...",
            "dxList-nextButtonText": "Suivant",
            "dxList-selectAll": "S\xe9lectionner tout",
            "dxList-listAriaLabel": "\xc9l\xe9ments",
            "dxList-listAriaLabel-deletable": "\xc9l\xe9ments supprimables",
            "dxListEditDecorator-delete": "Supprimer",
            "dxListEditDecorator-more": "Plus",
            "dxList-selectAll-indeterminate": "\xc0 moiti\xe9 v\xe9rifi\xe9",
            "dxList-selectAll-checked": "V\xe9rifi\xe9",
            "dxList-selectAll-notChecked": "Non v\xe9rifi\xe9",
            "dxList-ariaRoleDescription": "Liste",
            "dxList-listAriaLabel-itemContent": "Contenu de la liste",
            "dxScrollView-pullingDownText": "Tirez vers le bas pour actualiser...",
            "dxScrollView-pulledDownText": "Relacher pour actualiser...",
            "dxScrollView-refreshingText": "Mise \xe0 jour...",
            "dxScrollView-reachBottomText": "Chargement...",
            "dxDateBox-simulatedDataPickerTitleTime": "Choisissez l'heure",
            "dxDateBox-simulatedDataPickerTitleDate": "Choisissez la date",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Choisissez la date et l'heure",
            "dxDateBox-validation-datetime": "La valeur doit \xeatre une date ou une heure.",
            "dxDateRangeBox-invalidStartDateMessage": "La valeur de d\xe9part doit \xeatre une date",
            "dxDateRangeBox-invalidEndDateMessage": "La valeur de fin doit \xeatre une date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "La date de fin est hors limite",
            "dxDateRangeBox-startDateLabel": "Date de d\xe9but",
            "dxDateRangeBox-endDateLabel": "Date de fin",
            "dxFileUploader-selectFile": "Choisissez un fichier",
            "dxFileUploader-dropFile": "D\xe9posez un fichier",
            "dxFileUploader-bytes": "Bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "T\xe9l\xe9charger",
            "dxFileUploader-uploaded": "T\xe9l\xe9charg\xe9",
            "dxFileUploader-readyToUpload": "Pr\xeat \xe0 t\xe9l\xe9charger",
            "dxFileUploader-uploadAbortedMessage": "T\xe9l\xe9chargement annul\xe9",
            "dxFileUploader-uploadFailedMessage": "\xc9chec du t\xe9l\xe9chargement",
            "dxFileUploader-invalidFileExtension": "Type de fichier non autoris\xe9",
            "dxFileUploader-invalidMaxFileSize": "Fichier trop volumineux",
            "dxFileUploader-invalidMinFileSize": "Fichier trop petit",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "De {0}",
            "dxRangeSlider-ariaTill": "\xe0 {0}",
            "dxSwitch-switchedOnText": "ON",
            "dxSwitch-switchedOffText": "OFF",
            "dxForm-optionalMark": "optionnel",
            "dxForm-requiredMessage": "{0} est obligatoire",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "R\xe9initialiser",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "La valeur doit \xeatre un nombre",
            "dxNumberBox-noDataText": "Pas de donn\xe9es",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Utilisez {0} pour voir les colonnes",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Faites glisser une colonne depuis le panneau de groupe",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Utilisez {0} ou glisser une colonne depuis le panneau de groupe",
            "dxDataGrid-emptyHeaderColumnChooserText": "Choix des colonnes",
            "dxDataGrid-columnChooserTitle": "Choisir les colonnes",
            "dxDataGrid-columnChooserEmptyText": "Faites glisser une colonne ici pour la cacher",
            "dxDataGrid-groupContinuesMessage": "Suite \xe0 la page suivante",
            "dxDataGrid-groupContinuedMessage": "Suite de la page pr\xe9c\xe9dente",
            "dxDataGrid-groupHeaderText": "Grouper avec cette colonne",
            "dxDataGrid-ungroupHeaderText": "D\xe9grouper",
            "dxDataGrid-ungroupAllText": "D\xe9grouper tout",
            "dxDataGrid-editingEditRow": "Editer",
            "dxDataGrid-editingSaveRowChanges": "Sauvegarder",
            "dxDataGrid-editingCancelRowChanges": "Annuler",
            "dxDataGrid-editingDeleteRow": "Supprimer",
            "dxDataGrid-editingUndeleteRow": "Restaurer",
            "dxDataGrid-editingConfirmDeleteMessage": "\xcates-vous s\xfbr de vouloir supprimer cet \xe9l\xe9ment ?",
            "dxDataGrid-validationCancelChanges": "Annuler les changements",
            "dxDataGrid-groupPanelEmptyText": "Faites glisser une colonne ICI pour grouper par celle-ci",
            "dxDataGrid-noDataText": "Pas de donn\xe9es",
            "dxDataGrid-searchPanelPlaceholder": "Recherche...",
            "dxDataGrid-filterRowShowAllText": "(tous)",
            "dxDataGrid-filterRowResetOperationText": "R\xe9initialiser",
            "dxDataGrid-filterRowOperationEquals": "Egale",
            "dxDataGrid-filterRowOperationNotEquals": "Diff\xe9rent de",
            "dxDataGrid-filterRowOperationLess": "Plus petit",
            "dxDataGrid-filterRowOperationLessOrEquals": "Plus petit ou \xe9gal",
            "dxDataGrid-filterRowOperationGreater": "Plus grand",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Plus grand ou \xe9gal",
            "dxDataGrid-filterRowOperationStartsWith": "Commence par",
            "dxDataGrid-filterRowOperationContains": "Contient",
            "dxDataGrid-filterRowOperationNotContains": "Ne contient pas",
            "dxDataGrid-filterRowOperationEndsWith": "Termine par",
            "dxDataGrid-filterRowOperationBetween": "Entre",
            "dxDataGrid-filterRowOperationBetweenStartText": "D\xe9but",
            "dxDataGrid-filterRowOperationBetweenEndText": "Fin",
            "dxDataGrid-ariaSearchBox": "Bo\xeete de recherche",
            "dxDataGrid-applyFilterText": "Filtrer le texte",
            "dxDataGrid-trueText": "Vrai",
            "dxDataGrid-falseText": "Faux",
            "dxDataGrid-sortingAscendingText": "Tri croissant",
            "dxDataGrid-sortingDescendingText": "Tri d\xe9croissant",
            "dxDataGrid-sortingClearText": "Supprimer le tri",
            "dxDataGrid-ariaNotSortedColumn": "Colonne non tri\xe9e",
            "dxDataGrid-ariaSortedAscendingColumn": "Tri ascendant de la colonne",
            "dxDataGrid-ariaSortedDescendingColumn": "Tri descendant de la colonne",
            "dxDataGrid-ariaSortIndex": "Index de tri {0}",
            "dxDataGrid-editingSaveAllChanges": "Sauvegarder les changements",
            "dxDataGrid-editingCancelAllChanges": "Ignorer les changements",
            "dxDataGrid-editingAddRow": "Ajouter ligne",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Minimum de {1} est {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maximum de {1} est {0}",
            "dxDataGrid-summaryAvg": "Moy: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Moyenne de {1} est {0}",
            "dxDataGrid-summarySum": "Somme: {0}",
            "dxDataGrid-summarySumOtherColumn": "Somme de {1} est {0}",
            "dxDataGrid-summaryCount": "Total: {0}",
            "dxDataGrid-columnFixingFix": "Fixez la position",
            "dxDataGrid-columnFixingUnfix": "Liberrez",
            "dxDataGrid-columnFixingLeftPosition": "Gauche",
            "dxDataGrid-columnFixingRightPosition": "Droite",
            "dxDataGrid-columnFixingStickyPosition": "Colonne Fixe",
            "dxDataGrid-exportTo": "Exporter",
            "dxDataGrid-exportToExcel": "Exporter sous Excel",
            "dxDataGrid-exporting": "Exporter...",
            "dxDataGrid-excelFormat": "Fichier Excel",
            "dxDataGrid-selectedRows": "Lignes s\xe9lectionn\xe9es",
            "dxDataGrid-exportSelectedRows": "Exporter les lignes s\xe9lectionn\xe9es vers {0}",
            "dxDataGrid-exportAll": "Exporter tout vers {0}",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Montrer les options de filtre de la colonne '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(aucune valeur)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Annuler",
            "dxDataGrid-ariaAdaptiveCollapse": "Masquer les donn\xe9es suppl\xe9mentaires",
            "dxDataGrid-ariaAdaptiveExpand": "Afficher des donn\xe9es suppl\xe9mentaires",
            "dxDataGrid-ariaColumn": "Colonne",
            "dxDataGrid-ariaColumnHeader": "En-t\xeate de colonne",
            "dxDataGrid-ariaValue": "Valeur",
            "dxDataGrid-ariaError": "Erreur",
            "dxDataGrid-ariaRevertButton": "Appuyez sur \xc9chap pour annuler les modifications",
            "dxDataGrid-ariaFilterCell": "Filtre de cellule",
            "dxDataGrid-ariaCollapse": "R\xe9duire",
            "dxDataGrid-ariaModifiedCell": "Modifi\xe9",
            "dxDataGrid-ariaDeletedCell": "Supprim\xe9",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Etendre",
            "dxDataGrid-ariaCollapsedRow": "Ligne r\xe9duite",
            "dxDataGrid-ariaExpandedRow": "Ligne d\xe9velopp\xe9e",
            "dxDataGrid-ariaDataGrid": "Grille",
            "dxDataGrid-ariaSearchInGrid": "Rechercher dans la grille",
            "dxDataGrid-ariaSelectAll": "S\xe9lectionner tout",
            "dxDataGrid-ariaSelectRow": "S\xe9lectionner ligne",
            "dxDataGrid-ariaToolbar": "Barre d'outils de la grille de donn\xe9es",
            "dxDataGrid-ariaEditForm": "Modifier le formulaire",
            "dxDataGrid-filterBuilderPopupTitle": "Cr\xe9ation de filtre",
            "dxDataGrid-filterPanelCreateFilter": "Cr\xe9er un filtre",
            "dxDataGrid-filterPanelClearFilter": "Supprimer",
            "dxDataGrid-filterPanelFilterEnabledHint": "Activer le filtre",
            "dxDataGrid-masterDetail": "Cellule avec d\xe9tails",
            "dxDataGrid-moveColumnToTheRight": "D\xe9placer vers la droite",
            "dxDataGrid-moveColumnToTheLeft": "D\xe9placer vers la gauche",
            "dxTreeList-ariaTreeList": "Liste arborescente avec {0} lignes et {1} colonnes",
            "dxTreeList-ariaExpandableInstruction": "Appuyez sur Ctrl + fl\xe8che droite pour d\xe9velopper le noeud cibl\xe9 et sur Ctrl + fl\xe8che gauche pour le r\xe9duire",
            "dxTreeList-ariaSearchInGrid": "Rechercher dans l'arborescence",
            "dxTreeList-ariaToolbar": "Barre d'outils de la liste arborescente",
            "dxTreeList-editingAddRowToNode": "Ajouter",
            "dxPager-infoText": "Page {0} sur {1} ({2} \xe9lements)",
            "dxPager-pagesCountText": "sur",
            "dxPager-pageSize": "Elements par page : {0}",
            "dxPager-pageSizesAllText": "Tous",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "Page pr\xe9c\xe9dente",
            "dxPager-nextPage": "Page suivante",
            "dxPager-ariaLabel": "Navigation de la page",
            "dxPager-ariaPageSize": "Taille de la page",
            "dxPager-ariaPageNumber": "N\xb0 de page",
            "dxPagination-infoText": "Page {0} sur {1} ({2} \xe9lements)",
            "dxPagination-pagesCountText": "sur",
            "dxPagination-pageSize": "Elements par page : {0}",
            "dxPagination-pageSizesAllText": "Tous",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "Page pr\xe9c\xe9dente",
            "dxPagination-nextPage": "Page suivante",
            "dxPagination-ariaLabel": "Navigation de la page",
            "dxPagination-ariaPageSize": "Taille de la page",
            "dxPagination-ariaPageNumber": "N\xb0 de page",
            "dxPivotGrid-grandTotal": "Total g\xe9n\xe9ral",
            "dxPivotGrid-total": "Total {0}",
            "dxPivotGrid-fieldChooserTitle": "Liste des champs",
            "dxPivotGrid-showFieldChooser": "Afficher la liste des champs",
            "dxPivotGrid-expandAll": "Etendre tout",
            "dxPivotGrid-collapseAll": "R\xe9duire tout",
            "dxPivotGrid-sortColumnBySummary": 'Trier par colonne "{0}"',
            "dxPivotGrid-sortRowBySummary": 'Trier par ligne "{0}"',
            "dxPivotGrid-removeAllSorting": "Supprimer les tris",
            "dxPivotGrid-dataNotAvailable": "ND",
            "dxPivotGrid-rowFields": "Lignes",
            "dxPivotGrid-columnFields": "Colonnes",
            "dxPivotGrid-dataFields": "Valeurs",
            "dxPivotGrid-filterFields": "Filtres",
            "dxPivotGrid-allFields": "Tous les champs",
            "dxPivotGrid-columnFieldArea": "D\xe9poser les champs de colonne ici",
            "dxPivotGrid-dataFieldArea": "D\xe9poser les champs de donn\xe9es ici",
            "dxPivotGrid-rowFieldArea": "D\xe9poser les champs de ligne ici",
            "dxPivotGrid-filterFieldArea": "D\xe9poser les champs de filtre ici",
            "dxScheduler-dateRange": "de {0} \xe0 {1}",
            "dxScheduler-ariaLabel": "Agenda. {0} vue : {1} avec {2} rendez-vous",
            "dxScheduler-ariaLabel-currentIndicator-present": "L'indicateur de temps actuel est visible dans la vue",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "L'indicateur de l'heure actuelle n'est pas visible sur l'\xe9cran",
            "dxScheduler-appointmentAriaLabel-group": "Groupe : {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Rendez-vous r\xe9current",
            "dxScheduler-appointmentListAriaLabel": "Liste des rendez-vous ",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Titre",
            "dxScheduler-editorLabelStartDate": "Date de d\xe9but",
            "dxScheduler-editorLabelEndDate": "Date de fin",
            "dxScheduler-editorLabelDescription": "Description",
            "dxScheduler-editorLabelRecurrence": "R\xe9currence",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Aujourd'hui",
            "dxScheduler-navigationPrevious": "Page pr\xe9c\xe9dente",
            "dxScheduler-navigationNext": "Page suivante",
            "dxScheduler-openAppointment": "D\xe9finir un \xe9venement",
            "dxScheduler-recurrenceNever": "Jamais",
            "dxScheduler-recurrenceMinutely": "Par minute",
            "dxScheduler-recurrenceHourly": "Par heure",
            "dxScheduler-recurrenceDaily": "Quotidien",
            "dxScheduler-recurrenceWeekly": "Hebdomadaire",
            "dxScheduler-recurrenceMonthly": "Mensuel",
            "dxScheduler-recurrenceYearly": "Annuel",
            "dxScheduler-recurrenceRepeatEvery": "Chaque",
            "dxScheduler-recurrenceRepeatOn": "R\xe9p\xe8te tous les",
            "dxScheduler-recurrenceEnd": "Jusqu'\xe0",
            "dxScheduler-recurrenceAfter": "Apr\xe8s",
            "dxScheduler-recurrenceOn": "Le",
            "dxScheduler-recurrenceUntilDateLabel": "Date de fin de la r\xe9p\xe9tition",
            "dxScheduler-recurrenceOccurrenceLabel": "Nombre d'occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "Jour(s)",
            "dxScheduler-recurrenceRepeatWeekly": "Semaine(s)",
            "dxScheduler-recurrenceRepeatMonthly": "Mois(s)",
            "dxScheduler-recurrenceRepeatYearly": "Ann\xe9e(s)",
            "dxScheduler-switcherDay": "Jour",
            "dxScheduler-switcherWeek": "Semaine",
            "dxScheduler-switcherWorkWeek": "Semaine de travail",
            "dxScheduler-switcherMonth": "Mois",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Timeline Jour",
            "dxScheduler-switcherTimelineWeek": "Timeline Semaine",
            "dxScheduler-switcherTimelineWorkWeek": "Timeline Semaine de travail",
            "dxScheduler-switcherTimelineMonth": "Timeline Mois",
            "dxScheduler-recurrenceRepeatOnDate": "le",
            "dxScheduler-recurrenceRepeatCount": "occurence(s)",
            "dxScheduler-allDay": "Temps plein",
            "dxScheduler-ariaEditForm": "Modifier le formulaire",
            "dxScheduler-confirmRecurrenceEditTitle": "Modifier le rendez-vous r\xe9current",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Supprimer un rendez-vous r\xe9current",
            "dxScheduler-confirmRecurrenceEditMessage": "Voulez-vous \xe9diter cet \xe9venement ou la s\xe9rie enti\xe8re ?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Voulez-vous supprimer cet \xe9venement ou la s\xe9rie enti\xe8re ?",
            "dxScheduler-confirmRecurrenceEditSeries": "Editer serie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Supprimer serie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Editer \xe9venement",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Supprimer \xe9venement",
            "dxScheduler-noTimezoneTitle": "Pas de fuseau horaire",
            "dxScheduler-moreAppointments": "{0} en plus",
            "dxCalendar-currentDay": "Aujourd'hui",
            "dxCalendar-currentMonth": "Mois courant",
            "dxCalendar-currentYear": "Ann\xe9e courante",
            "dxCalendar-currentYearRange": "Plage de l'ann\xe9e en cours",
            "dxCalendar-todayButtonText": "Aujourd'hui",
            "dxCalendar-ariaWidgetName": "Calendrier",
            "dxCalendar-previousMonthButtonLabel": "Mois pr\xe9c\xe9dent",
            "dxCalendar-previousYearButtonLabel": "Ann\xe9e pr\xe9c\xe9dente",
            "dxCalendar-previousDecadeButtonLabel": "D\xe9cennie pr\xe9c\xe9dente",
            "dxCalendar-previousCenturyButtonLabel": "Si\xe8cle pr\xe9c\xe9dent",
            "dxCalendar-nextMonthButtonLabel": "Mois suivant",
            "dxCalendar-nextYearButtonLabel": "Ann\xe9e suivante",
            "dxCalendar-nextDecadeButtonLabel": "D\xe9cennie suivante",
            "dxCalendar-nextCenturyButtonLabel": "Si\xe8cle suivant",
            "dxCalendar-captionMonthLabel": "S\xe9lection du mois",
            "dxCalendar-captionYearLabel": "S\xe9lection de l'ann\xe9e",
            "dxCalendar-captionDecadeLabel": "S\xe9lection de la d\xe9cennie",
            "dxCalendar-captionCenturyLabel": "S\xe9lection du si\xe8cle",
            "dxCalendar-selectedDate": "La date s\xe9lectionn\xe9e est {0}",
            "dxCalendar-selectedDates": "Les dates s\xe9lectionn\xe9es",
            "dxCalendar-selectedDateRange": "La plage de dates s\xe9lectionn\xe9e est de {0} \xe0 {1}",
            "dxCalendar-selectedMultipleDateRange": "de {0} \xe0 {1}",
            "dxCalendar-selectedDateRangeCount": "Il y a {0} plages de dates s\xe9lectionn\xe9es",
            "dxCalendar-readOnlyLabel": "Calendrier en lecture seule",
            "dxCardView-ariaSearchInGrid": "Rechercher dans la vue carte",
            "dxCardView-ariaHeaderItemLabel": "Nom du champ {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Tri par ordre croissant",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Tri par ordre d\xe9croissant",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Index de tri {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Filtre d'en-t\xeate appliqu\xe9",
            "dxCardView-ariaSelectCard": "S\xe9lectionnez la carte",
            "dxCardView-ariaCardView": "Vue carte avec {0} cartes. Chaque carte comporte {1} champs.",
            "dxCardView-ariaCard": "Carte",
            "dxCardView-ariaEditableCard": "Carte modifiable",
            "dxCardView-ariaCardPosition": "Ligne {0}, colonne {1}",
            "dxCardView-ariaSelectedCardState": "S\xe9lectionn\xe9",
            "dxCardView-ariaNotSelectedCardState": "Non s\xe9lectionn\xe9",
            "dxCardView-selectAll": "Tout s\xe9lectionner",
            "dxCardView-clearSelection": "Effacer la s\xe9lection",
            "dxCardView-cardNoImageAriaLabel": "Pas d'image",
            "dxCardView-headerItemDropZoneText": "D\xe9posez l'\xe9l\xe9ment d'en-t\xeate ici",
            "dxCardView-emptyHeaderPanelText": "Utilisez {0} pour afficher les colonnes",
            "dxCardView-emptyHeaderPanelColumnChooserText": "s\xe9lecteur de colonnes",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Tapez un message",
            "dxChat-sendButtonAriaLabel": "Envoyer",
            "dxChat-cancelEditingButtonAriaLabel": "Annuler",
            "dxChat-editingMessageCaption": "Modifier le message",
            "dxChat-defaultUserName": "Utilisateur inconnu",
            "dxChat-messageListAriaLabel": "Liste des messages",
            "dxChat-alertListAriaLabel": "Liste d'erreurs",
            "dxChat-emptyListMessage": "Il n'y a aucun message dans ce chat",
            "dxChat-emptyListPrompt": "\xc9crivez votre premier message",
            "dxChat-typingMessageSingleUser": "{0} est en train d'\xe9crire...",
            "dxChat-typingMessageTwoUsers": "{0} et {1} sont en train d'\xe9crire...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} et {2} sont en train d'\xe9crire...",
            "dxChat-typingMessageMultipleUsers": "{0} et les autres sont en train d'\xe9crire...",
            "dxChat-editedMessageText": "\xc9dit\xe9",
            "dxChat-editingEditMessage": "Editer",
            "dxChat-editingDeleteMessage": "Supprimer",
            "dxChat-editingDeleteConfirmText": "\xcates-vous s\xfbr de vouloir supprimer ce message ?",
            "dxChat-deletedMessageText": "Le message a \xe9t\xe9 supprim\xe9",
            "dxChat-defaultImageAlt": "Image partag\xe9e dans le chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "Rouge",
            "dxColorView-ariaGreen": "Vert",
            "dxColorView-ariaBlue": "Bleu",
            "dxColorView-ariaAlpha": "Transparence",
            "dxColorView-ariaHex": "Code couleur",
            "dxTagBox-selected": "{0} selectionn\xe9s",
            "dxTagBox-allSelected": "Tous s\xe9lectionn\xe9s ({0})",
            "dxTagBox-moreSelected": "{0} en plus",
            "dxTagBox-tagRoleDescription": "Balise. Appuyez sur le bouton Supprimer pour supprimer cette balise.",
            "dxTagBox-ariaRoleDescription": "Bo\xeete \xe0 balise",
            "vizExport-printingButtonText": "Imprimer",
            "vizExport-titleMenuText": "Exporter/Imprimer",
            "vizExport-exportButtonText": "{0} fichier",
            "dxFilterBuilder-and": "Et",
            "dxFilterBuilder-or": "Ou",
            "dxFilterBuilder-notAnd": "Non Et",
            "dxFilterBuilder-notOr": "Non Ou",
            "dxFilterBuilder-addCondition": "Ajouter une condition",
            "dxFilterBuilder-addGroup": "Ajouter un groupe",
            "dxFilterBuilder-enterValueText": "<entrer une valeur>",
            "dxFilterBuilder-filterOperationEquals": "Est \xe9gal \xe0",
            "dxFilterBuilder-filterOperationNotEquals": "Est diff\xe9rent de",
            "dxFilterBuilder-filterOperationLess": "Est plus petit que",
            "dxFilterBuilder-filterOperationLessOrEquals": "Est plus petit ou \xe9gal \xe0",
            "dxFilterBuilder-filterOperationGreater": "Est plus grand que",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Est plus grand ou \xe9gal \xe0",
            "dxFilterBuilder-filterOperationStartsWith": "Commence par",
            "dxFilterBuilder-filterOperationContains": "Contient",
            "dxFilterBuilder-filterOperationNotContains": "Ne contient pas",
            "dxFilterBuilder-filterOperationEndsWith": "Finit par",
            "dxFilterBuilder-filterOperationIsBlank": "Est vide",
            "dxFilterBuilder-filterOperationIsNotBlank": "N'est pas vide",
            "dxFilterBuilder-filterOperationBetween": "Entre",
            "dxFilterBuilder-filterOperationAnyOf": "Est parmi",
            "dxFilterBuilder-filterOperationNoneOf": "N'est pas parmi",
            "dxFilterBuilder-filterAriaRootElement": "G\xe9n\xe9rateur de filtres",
            "dxFilterBuilder-filterAriaGroupLevel": "Niveau {0}",
            "dxFilterBuilder-filterAriaGroupItem": "\xc9l\xe9ment de groupe",
            "dxFilterBuilder-filterAriaOperationButton": "Op\xe9ration",
            "dxFilterBuilder-filterAriaAddButton": "Ajoute",
            "dxFilterBuilder-filterAriaRemoveButton": "Supprime {0}",
            "dxFilterBuilder-filterAriaItemField": "champs",
            "dxFilterBuilder-filterAriaItemOperation": "op\xe9ration",
            "dxFilterBuilder-filterAriaItemValue": "valeur",
            "dxHtmlEditor-dialogColorCaption": "Changer couleur police",
            "dxHtmlEditor-dialogBackgroundCaption": "Changer couleur fond",
            "dxHtmlEditor-dialogLinkCaption": "Ajouter un hyperlien",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Texte",
            "dxHtmlEditor-dialogLinkTargetField": "Ouvrir le lien dans une nouvelle fen\xeatre",
            "dxHtmlEditor-dialogImageCaption": "Ajouter image",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Texte alternatif",
            "dxHtmlEditor-dialogImageWidthField": "Largeur (px)",
            "dxHtmlEditor-dialogImageHeightField": "Hauteur (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Lignes",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Colonnes",
            "dxHtmlEditor-dialogInsertTableCaption": "Ins\xe9rer un tableau",
            "dxHtmlEditor-dialogUpdateImageCaption": "Actualiser l'image",
            "dxHtmlEditor-dialogImageUpdateButton": "Actualiser",
            "dxHtmlEditor-dialogImageAddButton": "Ajouter",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Depuis le Web",
            "dxHtmlEditor-dialogImageSelectFile": "Depuis cet appareil",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Conserver les proportions",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encoder en Base64",
            "dxHtmlEditor-heading": "Titre",
            "dxHtmlEditor-normalText": "Texte normal",
            "dxHtmlEditor-background": "Couleur de l'arri\xe8re plan",
            "dxHtmlEditor-bold": "Gras",
            "dxHtmlEditor-color": "Couleur de police",
            "dxHtmlEditor-font": "Police",
            "dxHtmlEditor-italic": "Italique",
            "dxHtmlEditor-link": "Ajouter un hyperlien",
            "dxHtmlEditor-image": "Ajouter une image",
            "dxHtmlEditor-size": "Taille",
            "dxHtmlEditor-strike": "Barr\xe9",
            "dxHtmlEditor-subscript": "Indice",
            "dxHtmlEditor-superscript": "Suscription",
            "dxHtmlEditor-underline": "Souligner",
            "dxHtmlEditor-blockquote": "Citation",
            "dxHtmlEditor-header": "Ent\xeate",
            "dxHtmlEditor-increaseIndent": "Augmenter le retrait",
            "dxHtmlEditor-decreaseIndent": "R\xe9duire le retrait",
            "dxHtmlEditor-orderedList": "Liste ordonn\xe9e",
            "dxHtmlEditor-bulletList": "Liste \xe0 puces",
            "dxHtmlEditor-alignLeft": "Aligner \xe0 gauche",
            "dxHtmlEditor-alignCenter": "Centrer",
            "dxHtmlEditor-alignRight": "Aligner \xe0 droite",
            "dxHtmlEditor-alignJustify": "Justifier",
            "dxHtmlEditor-codeBlock": "Bloc de code",
            "dxHtmlEditor-variable": "Ajouter une variable",
            "dxHtmlEditor-undo": "Annuler",
            "dxHtmlEditor-redo": "Refaire",
            "dxHtmlEditor-clear": "Supprimer le formattage",
            "dxHtmlEditor-insertTable": "Ins\xe9rer tableau",
            "dxHtmlEditor-insertHeaderRow": "Ins\xe9rer une ligne d'en-t\xeate",
            "dxHtmlEditor-insertRowAbove": "Ins\xe9rer une ligne au-dessus",
            "dxHtmlEditor-insertRowBelow": "Ins\xe9rer une ligne ci-dessous",
            "dxHtmlEditor-insertColumnLeft": "Ins\xe9rer une colonne \xe0 gauche",
            "dxHtmlEditor-insertColumnRight": "Ins\xe9rer une colonne \xe0 droite",
            "dxHtmlEditor-deleteColumn": "Supprimer la colonne",
            "dxHtmlEditor-deleteRow": "Supprimer la ligne",
            "dxHtmlEditor-deleteTable": "Supprimer le tableau",
            "dxHtmlEditor-cellProperties": "Propri\xe9t\xe9s de la cellule",
            "dxHtmlEditor-tableProperties": "Propri\xe9t\xe9s du tableau",
            "dxHtmlEditor-insert": "Ins\xe9rer",
            "dxHtmlEditor-delete": "Supprimer",
            "dxHtmlEditor-border": "Bordure",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "Largeur",
            "dxHtmlEditor-height": "Hauteur",
            "dxHtmlEditor-borderColor": "Couleur",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Arri\xe8re plan",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignement",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Rembourrage vertical",
            "dxHtmlEditor-paddingHorizontal": "Rembourrage horizontal",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "Liste",
            "dxHtmlEditor-ordered": "En ordre",
            "dxHtmlEditor-bullet": "Point",
            "dxHtmlEditor-align": "Aligner",
            "dxHtmlEditor-center": "Centrer",
            "dxHtmlEditor-left": "Gauche",
            "dxHtmlEditor-right": "Droite",
            "dxHtmlEditor-indent": "Retrait",
            "dxHtmlEditor-justify": "Justifier",
            "dxHtmlEditor-borderStyleNone": "rien",
            "dxHtmlEditor-borderStyleHidden": "cach\xe9",
            "dxHtmlEditor-borderStyleDotted": "en pointill\xe9",
            "dxHtmlEditor-borderStyleDashed": "en tiret",
            "dxHtmlEditor-borderStyleSolid": "solide",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Une erreur s'est produite. Veuillez r\xe9essayer.",
            "dxHtmlEditor-aiDialogCanceled": "G\xe9n\xe9ration annul\xe9e",
            "dxHtmlEditor-aiReplace": "Remplace",
            "dxHtmlEditor-aiInsertAbove": "Ins\xe9rer ci-dessus",
            "dxHtmlEditor-aiInsertBelow": "Ins\xe9rer ci-dessous",
            "dxHtmlEditor-aiCopy": "Copier",
            "dxHtmlEditor-aiRegenerate": "Reg\xe9n\xe9rer",
            "dxHtmlEditor-aiGenerate": "G\xe9n\xe9rer",
            "dxHtmlEditor-aiCancel": "Annuler",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "\xc9l\xe9ment de la barre d'outils de l'assistant AI",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Demandez \xe0 l'IA de modifier le texte",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "R\xe9pertoire sans titre",
            "dxFileManager-rootDirectoryName": "Fichiers",
            "dxFileManager-errorNoAccess": "Acc\xe8s interdit. L'op\xe9ration ne peut se terminer.",
            "dxFileManager-errorDirectoryExistsFormat": "R\xe9pertoire '{0}' existe d\xe9j\xe0.",
            "dxFileManager-errorFileExistsFormat": "Fichier '{0}' existe d\xe9j\xe0.",
            "dxFileManager-errorFileNotFoundFormat": "Impossible de trouver le fichier '{0}.'",
            "dxFileManager-errorDirectoryNotFoundFormat": "Impossible de trouver le r\xe9pertoire '{0}.'",
            "dxFileManager-errorWrongFileExtension": "Extension de fichier non permise.",
            "dxFileManager-errorMaxFileSizeExceeded": "Taille du fichier d\xe9passe la limite maximum permise.",
            "dxFileManager-errorInvalidSymbols": "Ce nom contient des caract\xe8res invalides.",
            "dxFileManager-errorDefault": "Erreur non sp\xe9cifi\xe9e.",
            "dxFileManager-errorDirectoryOpenFailed": "Le r\xe9pertoire ne peut s'ouvrir",
            "dxFileManager-commandCreate": "Nouveau r\xe9pertoire",
            "dxFileManager-commandRename": "Renommer",
            "dxFileManager-commandMove": "D\xe9placer",
            "dxFileManager-commandCopy": "Copier",
            "dxFileManager-commandDelete": "Supprimer",
            "dxFileManager-commandDownload": "T\xe9l\xe9charger",
            "dxFileManager-commandUpload": "T\xe9l\xe9verser des fichiers",
            "dxFileManager-commandRefresh": "Rafra\xeechir",
            "dxFileManager-commandThumbnails": "Mode vignette",
            "dxFileManager-commandDetails": "Mode d\xe9tails",
            "dxFileManager-commandClearSelection": "Vider s\xe9lection",
            "dxFileManager-commandShowNavPane": "Basculer le volet de navigation",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "D\xe9placer vers",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "D\xe9placer",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Copier vers",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Copier",
            "dxFileManager-dialogRenameItemTitle": "Renommer",
            "dxFileManager-dialogRenameItemButtonText": "Sauvegarder",
            "dxFileManager-dialogCreateDirectoryTitle": "Nouveau r\xe9pertoire",
            "dxFileManager-dialogCreateDirectoryButtonText": "Cr\xe9er",
            "dxFileManager-dialogDeleteItemTitle": "Supprimer",
            "dxFileManager-dialogDeleteItemButtonText": "Supprimer",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Voulez-vous vraiment supprimer {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Voulez-vous vraiment supprimer {0}?",
            "dxFileManager-dialogButtonCancel": "Annuler",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Cr\xe9er un r\xe9pertoire dans {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "R\xe9pertoire cr\xe9\xe9 dans {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "R\xe9pertoire n'est pas cr\xe9\xe9",
            "dxFileManager-editingCreateCommonErrorMessage": "R\xe9pertoire n'est pas cr\xe9\xe9",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renommer un item dans {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Element renomm\xe9 dans {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Element non renomm\xe9",
            "dxFileManager-editingRenameCommonErrorMessage": "Element non renomm\xe9",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Supprimer un \xe9lement de {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Supprimer {0} \xe9lements de {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Element supprim\xe9 de {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "{0} \xe9lements supprim\xe9s de {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Element non suprim\xe9",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} \xe9lements non supprim\xe9s",
            "dxFileManager-editingDeleteCommonErrorMessage": "Des \xe9lements ne sont pas supprim\xe9s",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "En train de d\xe9placer un \xe9lement vers {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "En train de d\xe9placer {0} \xe9lements vers {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Element d\xe9plac\xe9 vers {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "{0} \xe9lements d\xe9plac\xe9s vers {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Element non d\xe9plac\xe9",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} \xe9lements non d\xe9plac\xe9s",
            "dxFileManager-editingMoveCommonErrorMessage": "Des \xe9lements ne sont pas d\xe9plac\xe9s",
            "dxFileManager-editingCopySingleItemProcessingMessage": "En train de copier un \xe9lement vers {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "En train de copier {0} \xe9lementss vers {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Element copi\xe9 vers {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "{0} \xe9lements copi\xe9s vers {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Element non copi\xe9",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} \xe9lements non copi\xe9s",
            "dxFileManager-editingCopyCommonErrorMessage": "Des \xe9lements ne sont pas copi\xe9s",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "En train de t\xe9l\xe9verser un \xe9lement vers {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "En train de t\xe9l\xe9verser {0} \xe9lements vers {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Element t\xe9l\xe9vers\xe9 vers {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "{0} \xe9lements t\xe9l\xe9vers\xe9s vers {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Element non t\xe9l\xe9vers\xe9",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} \xe9lements non t\xe9l\xe9vers\xe9s",
            "dxFileManager-editingUploadCanceledMessage": "Annul\xe9",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "L'\xe9l\xe9ment n'a pas \xe9t\xe9 t\xe9l\xe9charg\xe9",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} \xe9l\xe9ments n'ont pas \xe9t\xe9 t\xe9l\xe9charg\xe9s",
            "dxFileManager-listDetailsColumnCaptionName": "Nom",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date modifi\xe9",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Taille de fichier",
            "dxFileManager-listThumbnailsTooltipTextSize": "Taille",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date modifi\xe9",
            "dxFileManager-notificationProgressPanelTitle": "En cours",
            "dxFileManager-notificationProgressPanelEmptyListText": "Aucune op\xe9ration",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Annul\xe9",
            "dxDiagram-categoryGeneral": "G\xe9n\xe9ral",
            "dxDiagram-categoryFlowchart": "Organigramme",
            "dxDiagram-categoryOrgChart": "Structure organisationnelle",
            "dxDiagram-categoryContainers": "Conteneurs",
            "dxDiagram-categoryCustom": "Personnalis\xe9",
            "dxDiagram-commandExportToSvg": "Exporter en SVG",
            "dxDiagram-commandExportToPng": "Exporter en PNG",
            "dxDiagram-commandExportToJpg": "Exporter en JPEG",
            "dxDiagram-commandUndo": "Annuler",
            "dxDiagram-commandRedo": "Refaire",
            "dxDiagram-commandFontName": "Nom de la police",
            "dxDiagram-commandFontSize": "Taille de la police",
            "dxDiagram-commandBold": "Gras",
            "dxDiagram-commandItalic": "Italique",
            "dxDiagram-commandUnderline": "Souligner",
            "dxDiagram-commandTextColor": "Couleur texte",
            "dxDiagram-commandLineColor": "Couleur ligne",
            "dxDiagram-commandLineWidth": "Largeur de ligne",
            "dxDiagram-commandLineStyle": "Style de ligne",
            "dxDiagram-commandLineStyleSolid": "Solide",
            "dxDiagram-commandLineStyleDotted": "Point\xe9",
            "dxDiagram-commandLineStyleDashed": "Pointill\xe9",
            "dxDiagram-commandFillColor": "Couleur remplissage",
            "dxDiagram-commandAlignLeft": "Aligner \xe0 gauche",
            "dxDiagram-commandAlignCenter": "Centrer",
            "dxDiagram-commandAlignRight": "Aligner \xe0 droite",
            "dxDiagram-commandConnectorLineType": "Type de ligne de connexion",
            "dxDiagram-commandConnectorLineStraight": "Droit",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonal",
            "dxDiagram-commandConnectorLineStart": "D\xe9but de la ligne de connexion",
            "dxDiagram-commandConnectorLineEnd": "Fin de la ligne de connexion",
            "dxDiagram-commandConnectorLineNone": "Aucun",
            "dxDiagram-commandConnectorLineArrow": "Fl\xe8che",
            "dxDiagram-commandFullscreen": "Plein \xe9cran",
            "dxDiagram-commandUnits": "Unit\xe9s",
            "dxDiagram-commandPageSize": "Taille de la page",
            "dxDiagram-commandPageOrientation": "Orientation de la page",
            "dxDiagram-commandPageOrientationLandscape": "Paysage",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Couleur de la page",
            "dxDiagram-commandShowGrid": "Afficher la grille",
            "dxDiagram-commandSnapToGrid": "Aligner sur la grille",
            "dxDiagram-commandGridSize": "Taille de la grille",
            "dxDiagram-commandZoomLevel": "Niveau de zoom",
            "dxDiagram-commandAutoZoom": "Zoom automatique",
            "dxDiagram-commandFitToContent": "Ajuster au contenu",
            "dxDiagram-commandFitToWidth": "Ajuster \xe0 la largeur",
            "dxDiagram-commandAutoZoomByContent": "Auto zoom par contenu",
            "dxDiagram-commandAutoZoomByWidth": "Auto zoom par largeur",
            "dxDiagram-commandSimpleView": "Vue simple",
            "dxDiagram-commandCut": "Couper",
            "dxDiagram-commandCopy": "Copier",
            "dxDiagram-commandPaste": "Coller",
            "dxDiagram-commandSelectAll": "Tout s\xe9lectionner",
            "dxDiagram-commandDelete": "Supprimer",
            "dxDiagram-commandBringToFront": "Amener au premier plan",
            "dxDiagram-commandSendToBack": "Envoyer \xe0 l'arri\xe8re",
            "dxDiagram-commandLock": "Verrouiller",
            "dxDiagram-commandUnlock": "D\xe9verrouiller",
            "dxDiagram-commandInsertShapeImage": "Ins\xe9rer une image...",
            "dxDiagram-commandEditShapeImage": "Changer image...",
            "dxDiagram-commandDeleteShapeImage": "Supprimer image",
            "dxDiagram-commandLayoutLeftToRight": "Gauche \xe0 droite",
            "dxDiagram-commandLayoutRightToLeft": "Droite \xe0 gauche",
            "dxDiagram-commandLayoutTopToBottom": "Haut en bas",
            "dxDiagram-commandLayoutBottomToTop": "Bas en haut",
            "dxDiagram-unitIn": "po",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Annuler",
            "dxDiagram-dialogInsertShapeImageTitle": "Ins\xe9rer une image",
            "dxDiagram-dialogEditShapeImageTitle": "Changer image",
            "dxDiagram-dialogEditShapeImageSelectButton": "S\xe9lectionner une image",
            "dxDiagram-dialogEditShapeImageLabelText": "ou d\xe9poser le fichier ici",
            "dxDiagram-uiExport": "Exporter",
            "dxDiagram-uiProperties": "Propri\xe9t\xe9s",
            "dxDiagram-uiSettings": "Param\xe8tres",
            "dxDiagram-uiShowToolbox": "Afficher les outils",
            "dxDiagram-uiSearch": "Recherche",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Disposition",
            "dxDiagram-uiLayoutTree": "Arbre",
            "dxDiagram-uiLayoutLayered": "Par couches",
            "dxDiagram-uiDiagram": "Diagramme",
            "dxDiagram-uiText": "Texte",
            "dxDiagram-uiObject": "Objet",
            "dxDiagram-uiConnector": "Connecteur",
            "dxDiagram-uiPage": "Page",
            "dxDiagram-shapeText": "Texte",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Croix",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "C\u0153ur",
            "dxDiagram-shapePentagon": "Pentagone",
            "dxDiagram-shapeHexagon": "Hexagone",
            "dxDiagram-shapeOctagon": "Octogone",
            "dxDiagram-shapeStar": "\xc9toile",
            "dxDiagram-shapeArrowLeft": "Fl\xe8che gauche",
            "dxDiagram-shapeArrowUp": "Fl\xe8che vers le haut",
            "dxDiagram-shapeArrowRight": "Fl\xe8che droite",
            "dxDiagram-shapeArrowDown": "Fl\xe8che vers le bas",
            "dxDiagram-shapeArrowUpDown": "Fl\xe8che haut bas",
            "dxDiagram-shapeArrowLeftRight": "Fl\xe8che gauche droite",
            "dxDiagram-shapeProcess": "Processus",
            "dxDiagram-shapeDecision": "D\xe9cision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Processus pr\xe9d\xe9fini",
            "dxDiagram-shapeDocument": "Document",
            "dxDiagram-shapeMultipleDocuments": "Documents multiples",
            "dxDiagram-shapeManualInput": "Entr\xe9e manuelle",
            "dxDiagram-shapePreparation": "Pr\xe9paration",
            "dxDiagram-shapeData": "Donn\xe9es",
            "dxDiagram-shapeDatabase": "Base de donn\xe9es",
            "dxDiagram-shapeHardDisk": "Disque dur",
            "dxDiagram-shapeInternalStorage": "Stockage interne",
            "dxDiagram-shapePaperTape": "Bande de papier",
            "dxDiagram-shapeManualOperation": "Op\xe9ration manuelle",
            "dxDiagram-shapeDelay": "Retard",
            "dxDiagram-shapeStoredData": "Les donn\xe9es stock\xe9es",
            "dxDiagram-shapeDisplay": "Afficher",
            "dxDiagram-shapeMerge": "Fusionner",
            "dxDiagram-shapeConnector": "Connecteur",
            "dxDiagram-shapeOr": "Ou",
            "dxDiagram-shapeSummingJunction": "Jonction de sommation",
            "dxDiagram-shapeContainerDefaultText": "R\xe9cipient",
            "dxDiagram-shapeVerticalContainer": "Conteneur vertical",
            "dxDiagram-shapeHorizontalContainer": "Conteneur horizontal",
            "dxDiagram-shapeCardDefaultText": "Nom de la personne",
            "dxDiagram-shapeCardWithImageOnLeft": "Carte avec image \xe0 gauche",
            "dxDiagram-shapeCardWithImageOnTop": "Carte avec image sur le dessus",
            "dxDiagram-shapeCardWithImageOnRight": "Carte avec image \xe0 droite",
            "dxGantt-dialogTitle": "Titre",
            "dxGantt-dialogStartTitle": "D\xe9part",
            "dxGantt-dialogEndTitle": "Fin",
            "dxGantt-dialogProgressTitle": "Progr\xe8s",
            "dxGantt-dialogResourcesTitle": "Ressources",
            "dxGantt-dialogResourceManagerTitle": "Gestionnaire de ressources",
            "dxGantt-dialogTaskDetailsTitle": "D\xe9tails de la t\xe2che",
            "dxGantt-dialogEditResourceListHint": "Modifier la liste des ressources",
            "dxGantt-dialogEditNoResources": "Pas de ressources",
            "dxGantt-dialogButtonAdd": "Ajouter",
            "dxGantt-contextMenuNewTask": "Nouvelle t\xe2che",
            "dxGantt-contextMenuNewSubtask": "Nouvelle sous-t\xe2che",
            "dxGantt-contextMenuDeleteTask": "Supprimer la t\xe2che",
            "dxGantt-contextMenuDeleteDependency": "Supprimer la d\xe9pendance",
            "dxGantt-dialogTaskDeleteConfirmation": "La suppression d'une t\xe2che supprime \xe9galement toutes ses d\xe9pendances et sous-t\xe2ches. \xcates-vous s\xfbr de vouloir supprimer cette t\xe2che?",
            "dxGantt-dialogDependencyDeleteConfirmation": "\xcates-vous s\xfbr de vouloir supprimer la d\xe9pendance de la t\xe2che?",
            "dxGantt-dialogResourcesDeleteConfirmation": "La suppression d'une ressource la supprime \xe9galement des t\xe2ches auxquelles cette ressource est affect\xe9e. Voulez-vous vraiment supprimer ces ressources? Ressources : {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "La t\xe2che que vous essayez de d\xe9placer est li\xe9e \xe0 une deuxi\xe8me t\xe2che par une relation de d\xe9pendance. Ce changement serait en conflit avec les r\xe8gles de d\xe9pendance. Comment aimeriez-vous proc\xe9der ?",
            "dxGantt-dialogConstraintViolationMessage": "La t\xe2che que vous essayez de d\xe9placer est li\xe9e \xe0 une deuxi\xe8me t\xe2che par une relation de d\xe9pendance. Comment aimeriez-vous proc\xe9der ?",
            "dxGantt-dialogCancelOperationMessage": "Annuler l'op\xe9ration",
            "dxGantt-dialogDeleteDependencyMessage": "Supprimer la d\xe9pendance",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "D\xe9placer la t\xe2che et conserver la d\xe9pendance",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "La t\xe2che que vous essayez de d\xe9placer est li\xe9e \xe0 une autre t\xe2che par des relations de d\xe9pendance. Ce changement serait en conflit avec les r\xe8gles de d\xe9pendance. Comment aimeriez-vous proc\xe9der ?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "La t\xe2che que vous essayez de d\xe9placer est li\xe9e \xe0 une autre t\xe2che par des relations de d\xe9pendance. Comment aimeriez-vous proc\xe9der ?",
            "dxGantt-dialogDeleteDependenciesMessage": "Supprimer les d\xe9pendances",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "D\xe9placer la t\xe2che et conserver les d\xe9pendances",
            "dxGantt-undo": "Annuler",
            "dxGantt-redo": "Refaire",
            "dxGantt-expandAll": "D\xe9velopper tout",
            "dxGantt-collapseAll": "Tout r\xe9duire",
            "dxGantt-addNewTask": "Ajouter une nouvelle t\xe2che",
            "dxGantt-deleteSelectedTask": "Supprimer la t\xe2che s\xe9lectionn\xe9e",
            "dxGantt-zoomIn": "Agrandir",
            "dxGantt-zoomOut": "D\xe9zoomer",
            "dxGantt-fullScreen": "Plein \xe9cran",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Tri croissant",
            "dxGantt-sortingDescendingText": "Tri d\xe9croissant",
            "dxGantt-sortingClearText": "Supprimer le tri",
            "dxGantt-showResources": "Afficher les ressources",
            "dxGantt-showDependencies": "Afficher les d\xe9pendances",
            "dxGantt-dialogStartDateValidation": "La date de d\xe9but doit \xeatre post\xe9rieure au {0}",
            "dxGantt-dialogEndDateValidation": "La date de fin doit \xeatre post\xe9rieure au {0}",
            "dxGallery-itemName": "\xc9l\xe9ment de la galerie",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Utilisez les touches fl\xe9ch\xe9es ou faites glisser pour naviguer entre les vues",
            "dxMultiView-itemAriaRoleDescription": "Vue",
            "dxMultiView-itemAriaLabel": "{0} de {1}",
            "dxSplitter-resizeHandleAriaLabel": "Barre de s\xe9paration",
            "dxSplitter-resizeHandleAriaRoleDescription": "S\xe9parateur",
            "dxStepper-optionalMark": "(Optionel)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
