/*!
* DevExtreme (dx.messages.da.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        da: {
            Yes: "Ja",
            No: "Nej",
            Cancel: "Annuller",
            CheckState: "Afkrydsningstilstand",
            Close: "Luk",
            Clear: "Ryd",
            Done: "Udf\xf8rt",
            Loading: "Indl\xe6ser...",
            Select: "V\xe6lg...",
            Search: "S\xf8g",
            Back: "Tilbage",
            OK: "OK",
            Today: "Idag",
            Yesterday: "Ig\xe5r",
            "dxCollectionWidget-noDataText": "Ingen data at vise",
            "dxDropDownEditor-selectLabel": "V\xe6lg",
            "validation-required": "P\xe5kr\xe6vet",
            "validation-required-formatted": "{0} er p\xe5kr\xe6vet",
            "validation-numeric": "V\xe6rdien skal v\xe6re et tal",
            "validation-numeric-formatted": "{0} skal v\xe6re et tal",
            "validation-range": "V\xe6rdien er uden for r\xe6kkevidde",
            "validation-range-formatted": "{0} er uden for r\xe6kkevidde",
            "validation-stringLength": "L\xe6ngden af v\xe6rdien er ikke korrekt",
            "validation-stringLength-formatted": "L\xe6ngden p\xe5 {0} er ikke korrekt",
            "validation-custom": "V\xe6rdien er ugyldig",
            "validation-custom-formatted": "{0} er ugyldig",
            "validation-async": "V\xe6rdien er ugyldig",
            "validation-async-formatted": "{0} er ugyldig",
            "validation-compare": "V\xe6rdierne stemmer ikke overens",
            "validation-compare-formatted": "{0} stemmer ikke overens",
            "validation-pattern": "V\xe6rdien stemmer ikke overens med m\xf8nsteret",
            "validation-pattern-formatted": "{0} stemmer ikke overens med m\xf8nsteret",
            "validation-email": "E-mailen er ugyldig",
            "validation-email-formatted": "{0} er ugyldig",
            "validation-mask": "V\xe6rdien er ugyldig",
            "dxLookup-searchPlaceholder": "Minimum antal tegn: {0}",
            "dxList-pullingDownText": "Tr\xe6k ned for at opdatere...",
            "dxList-pulledDownText": "Slip for at opdatere...",
            "dxList-refreshingText": "Opdaterer\u2026",
            "dxList-pageLoadingText": "Indl\xe6ser...",
            "dxList-nextButtonText": "Mere",
            "dxList-selectAll": "V\xe6lg alle",
            "dxList-listAriaLabel": "Elementer",
            "dxList-listAriaLabel-deletable": "Sletbare elementer",
            "dxListEditDecorator-delete": "Slet",
            "dxListEditDecorator-more": "Mere",
            "dxList-selectAll-indeterminate": "Halvafkrydset",
            "dxList-selectAll-checked": "Afkrydset",
            "dxList-selectAll-notChecked": "Ikke afkrydset",
            "dxList-ariaRoleDescription": "Liste",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Tr\xe6k ned for at opdatere...",
            "dxScrollView-pulledDownText": "Slip for at opdatere...",
            "dxScrollView-refreshingText": "Opdaterer\u2026",
            "dxScrollView-reachBottomText": "Indl\xe6ser...",
            "dxDateBox-simulatedDataPickerTitleTime": "V\xe6lg tid",
            "dxDateBox-simulatedDataPickerTitleDate": "V\xe6lg dato",
            "dxDateBox-simulatedDataPickerTitleDateTime": "V\xe6lg dato og tid",
            "dxDateBox-validation-datetime": "V\xe6rdien skal v\xe6re en dato eller en tid",
            "dxDateRangeBox-invalidStartDateMessage": "Startv\xe6rdi skal v\xe6re en dato",
            "dxDateRangeBox-invalidEndDateMessage": "Slutv\xe6rdien skal v\xe6re en dato",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Startdatoen er uden for intervallet",
            "dxDateRangeBox-endDateOutOfRangeMessage": "Slutdatoen er uden for intervallet",
            "dxDateRangeBox-startDateLabel": "Startdato",
            "dxDateRangeBox-endDateLabel": "Slutdato",
            "dxFileUploader-selectFile": "V\xe6lg en fil",
            "dxFileUploader-dropFile": "eller slip en fil her",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "Upload",
            "dxFileUploader-uploaded": "Uploadet",
            "dxFileUploader-readyToUpload": "Klar til at uploade",
            "dxFileUploader-uploadAbortedMessage": "Upload annulleret",
            "dxFileUploader-uploadFailedMessage": "Upload mislykkedes",
            "dxFileUploader-invalidFileExtension": "Filtype er ikke tilladt",
            "dxFileUploader-invalidMaxFileSize": "Filen er for stor",
            "dxFileUploader-invalidMinFileSize": "Filen er for lille",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "Fra",
            "dxRangeSlider-ariaTill": "Indtil",
            "dxSwitch-switchedOnText": "T\xc6NDT",
            "dxSwitch-switchedOffText": "SLUKKET",
            "dxForm-optionalMark": "valgfri",
            "dxForm-requiredMessage": "{0} er p\xe5kr\xe6vet",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "Nulstil",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "V\xe6rdien skal v\xe6re et tal",
            "dxNumberBox-noDataText": "Ingen data",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Brug {0} til at vise kolonner",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Tr\xe6k en kolonne fra gruppepanelet hertil",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Brug {0}, eller tr\xe6k en kolonne fra gruppepanelet",
            "dxDataGrid-emptyHeaderColumnChooserText": "kolonnev\xe6lger",
            "dxDataGrid-columnChooserTitle": "Kolonnev\xe6lger",
            "dxDataGrid-columnChooserEmptyText": "Tr\xe6k en kolonne hertil for at skjule den",
            "dxDataGrid-groupContinuesMessage": "Forts\xe6tter p\xe5 n\xe6ste side",
            "dxDataGrid-groupContinuedMessage": "Fortsat fra forrige side",
            "dxDataGrid-groupHeaderText": "Grupp\xe9r efter denne kolonne",
            "dxDataGrid-ungroupHeaderText": "Oph\xe6v grupperingen",
            "dxDataGrid-ungroupAllText": "Oph\xe6v grupperingen af alle",
            "dxDataGrid-editingEditRow": "Rediger",
            "dxDataGrid-editingSaveRowChanges": "Gem",
            "dxDataGrid-editingCancelRowChanges": "Annuller",
            "dxDataGrid-editingDeleteRow": "Slet",
            "dxDataGrid-editingUndeleteRow": "Fortryd sletning",
            "dxDataGrid-editingConfirmDeleteMessage": "Er du sikker p\xe5, at du vil slette denne post?",
            "dxDataGrid-validationCancelChanges": "Annuller \xe6ndringer",
            "dxDataGrid-groupPanelEmptyText": "Tr\xe6k en kolonneoverskrift her for at gruppere efter den kolonne",
            "dxDataGrid-noDataText": "Ingen data",
            "dxDataGrid-searchPanelPlaceholder": "S\xf8g...",
            "dxDataGrid-filterRowShowAllText": "(Alle)",
            "dxDataGrid-filterRowResetOperationText": "Nulstil",
            "dxDataGrid-filterRowOperationEquals": "Lig med",
            "dxDataGrid-filterRowOperationNotEquals": "Er ikke lig",
            "dxDataGrid-filterRowOperationLess": "Mindre end",
            "dxDataGrid-filterRowOperationLessOrEquals": "Mindre end eller lig med",
            "dxDataGrid-filterRowOperationGreater": "St\xf8rre end",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "St\xf8rre end eller lig med",
            "dxDataGrid-filterRowOperationStartsWith": "Starter med",
            "dxDataGrid-filterRowOperationContains": "Indeholder",
            "dxDataGrid-filterRowOperationNotContains": "Indeholder ikke",
            "dxDataGrid-filterRowOperationEndsWith": "Slutter med",
            "dxDataGrid-filterRowOperationBetween": "Mellem",
            "dxDataGrid-filterRowOperationBetweenStartText": "Start",
            "dxDataGrid-filterRowOperationBetweenEndText": "Slut",
            "dxDataGrid-ariaSearchBox": "S\xf8gefelt",
            "dxDataGrid-applyFilterText": "Anvend filter",
            "dxDataGrid-trueText": "sand",
            "dxDataGrid-falseText": "falsk",
            "dxDataGrid-sortingAscendingText": "Sorter stigende",
            "dxDataGrid-sortingDescendingText": "Sorter faldende",
            "dxDataGrid-sortingClearText": "Ryd sortering",
            "dxDataGrid-ariaNotSortedColumn": "Ikke sorteret kolonne",
            "dxDataGrid-ariaSortedAscendingColumn": "Kolonne sorteret i stigende r\xe6kkef\xf8lge",
            "dxDataGrid-ariaSortedDescendingColumn": "Kolonne sorteret i faldende r\xe6kkef\xf8lge",
            "dxDataGrid-ariaSortIndex": "Sorter indeks {0}",
            "dxDataGrid-editingSaveAllChanges": "Gem \xe6ndringer",
            "dxDataGrid-editingCancelAllChanges": "Kass\xe9r \xe6ndringer",
            "dxDataGrid-editingAddRow": "Tilf\xf8j en r\xe6kke",
            "dxDataGrid-summaryMin": "Min.: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min. af {1} er {0}",
            "dxDataGrid-summaryMax": "Maks.: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Maks. af {1} er {0}",
            "dxDataGrid-summaryAvg": "Gns.: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Gns. af {1} er {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Summen af {1} er {0}",
            "dxDataGrid-summaryCount": "Antal: {0}",
            "dxDataGrid-columnFixingFix": "Indstil fast position",
            "dxDataGrid-columnFixingUnfix": "Fjern rettelsen",
            "dxDataGrid-columnFixingLeftPosition": "Venstre",
            "dxDataGrid-columnFixingRightPosition": "H\xf8jre",
            "dxDataGrid-columnFixingStickyPosition": "Kl\xe6brig",
            "dxDataGrid-exportTo": "Eksporter",
            "dxDataGrid-exportToExcel": "Eksporter til Excel-fil",
            "dxDataGrid-exporting": "Eksporterer\u2026",
            "dxDataGrid-excelFormat": "Excel-fil",
            "dxDataGrid-selectedRows": "Valgte r\xe6kker",
            "dxDataGrid-exportSelectedRows": "Eksporter valgte r\xe6kker til {0}",
            "dxDataGrid-exportAll": "Eksporter alle data til {0}",
            "dxDataGrid-headerFilterLabel": "Filterindstillinger",
            "dxDataGrid-headerFilterIndicatorLabel": "Vis filterindstillinger for kolonne '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Tomme)",
            "dxDataGrid-headerFilterOK": "OK",
            "dxDataGrid-headerFilterCancel": "Annuller",
            "dxDataGrid-ariaAdaptiveCollapse": "Skjul yderligere data",
            "dxDataGrid-ariaAdaptiveExpand": "Vis yderligere data",
            "dxDataGrid-ariaColumn": "Kolonne",
            "dxDataGrid-ariaColumnHeader": "Kolonneoverskrift",
            "dxDataGrid-ariaValue": "V\xe6rdi",
            "dxDataGrid-ariaError": "Fejl",
            "dxDataGrid-ariaRevertButton": "Tryk p\xe5 Escape for at kassere \xe6ndringerne",
            "dxDataGrid-ariaFilterCell": "Filtercelle",
            "dxDataGrid-ariaCollapse": "Sammenklap",
            "dxDataGrid-ariaModifiedCell": "\xc6ndret",
            "dxDataGrid-ariaDeletedCell": "Slettet",
            "dxDataGrid-ariaEditableCell": "Redigerbar",
            "dxDataGrid-ariaExpand": "Udvid",
            "dxDataGrid-ariaCollapsedRow": "Sammenklappet r\xe6kke",
            "dxDataGrid-ariaExpandedRow": "Udvidet r\xe6kke",
            "dxDataGrid-ariaDataGrid": "Datagitter med {0} r\xe6kker og {1} kolonner",
            "dxDataGrid-ariaSearchInGrid": "S\xf8g i datagitteret",
            "dxDataGrid-ariaSelectAll": "V\xe6lg alle",
            "dxDataGrid-ariaSelectRow": "V\xe6lg r\xe6kke",
            "dxDataGrid-ariaToolbar": "V\xe6rkt\xf8jslinje for datagitter",
            "dxDataGrid-ariaEditForm": "Rediger formular",
            "dxDataGrid-filterBuilderPopupTitle": "Filterbygger",
            "dxDataGrid-filterPanelCreateFilter": "Opret filter",
            "dxDataGrid-filterPanelClearFilter": "Ryd",
            "dxDataGrid-filterPanelFilterEnabledHint": "Aktiver filteret",
            "dxDataGrid-masterDetail": "Celle med detaljer",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tr\xe6liste med {0} r\xe6kker og {1} kolonner",
            "dxTreeList-ariaExpandableInstruction": "Tryk p\xe5 Ctrl + h\xf8jre pil for at udvide den fokuserede node og Ctrl + venstre pil for at sammenklappe den",
            "dxTreeList-ariaSearchInGrid": "S\xf8g i tr\xe6listen",
            "dxTreeList-ariaToolbar": "Tr\xe6listev\xe6rkt\xf8jslinje",
            "dxTreeList-editingAddRowToNode": "Tilf\xf8j",
            "dxPager-infoText": "Side {0} af {1} ({2} elementer)",
            "dxPager-pagesCountText": "af",
            "dxPager-pageSize": "Elementer per side: {0}",
            "dxPager-pageSizesAllText": "Alle",
            "dxPager-page": "Side {0}",
            "dxPager-prevPage": "Forrige side",
            "dxPager-nextPage": "N\xe6ste side",
            "dxPager-ariaLabel": "Sidenavigation",
            "dxPager-ariaPageSize": "Sidest\xf8rrelse",
            "dxPager-ariaPageNumber": "Sidenummer",
            "dxPagination-infoText": "Side {0} af {1} ({2} elementer)",
            "dxPagination-pagesCountText": "af",
            "dxPagination-pageSize": "Elementer per side: {0}",
            "dxPagination-pageSizesAllText": "Alle",
            "dxPagination-page": "Side {0}",
            "dxPagination-prevPage": "Forrige side",
            "dxPagination-nextPage": "N\xe6ste side",
            "dxPagination-ariaLabel": "Sidenavigation",
            "dxPagination-ariaPageSize": "Sidest\xf8rrelse",
            "dxPagination-ariaPageNumber": "Sidenummer",
            "dxPivotGrid-grandTotal": "Total",
            "dxPivotGrid-total": "{0} i alt",
            "dxPivotGrid-fieldChooserTitle": "Feltv\xe6lger",
            "dxPivotGrid-showFieldChooser": "Vis feltv\xe6lger",
            "dxPivotGrid-expandAll": "Udvid alle",
            "dxPivotGrid-collapseAll": "Sammenklap alle",
            "dxPivotGrid-sortColumnBySummary": 'Sorter "{0}" efter denne kolonne',
            "dxPivotGrid-sortRowBySummary": 'Sorter "{0}" efter denne r\xe6kke',
            "dxPivotGrid-removeAllSorting": "Fjern al sortering",
            "dxPivotGrid-dataNotAvailable": "Ikke tilg\xe6ngelig",
            "dxPivotGrid-rowFields": "R\xe6kkefelter",
            "dxPivotGrid-columnFields": "Kolonnefelter",
            "dxPivotGrid-dataFields": "Datafelter",
            "dxPivotGrid-filterFields": "Filterfelter",
            "dxPivotGrid-allFields": "Alle felter",
            "dxPivotGrid-columnFieldArea": "Slip kolonnefelter her",
            "dxPivotGrid-dataFieldArea": "Slip datafelter her",
            "dxPivotGrid-rowFieldArea": "Slip r\xe6kkefelter her",
            "dxPivotGrid-filterFieldArea": "Slip filterfelter her",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Gruppe: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Tilbagevendende aftale",
            "dxScheduler-appointmentListAriaLabel": "Aftaleliste",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "Emne",
            "dxScheduler-editorLabelStartDate": "Startdato",
            "dxScheduler-editorLabelEndDate": "Slutdato",
            "dxScheduler-editorLabelDescription": "Beskrivelse",
            "dxScheduler-editorLabelRecurrence": "Gentag",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "Forrige side",
            "dxScheduler-navigationNext": "N\xe6ste side",
            "dxScheduler-openAppointment": "\xc5ben aftale",
            "dxScheduler-recurrenceNever": "Aldrig",
            "dxScheduler-recurrenceMinutely": "Hvert minut",
            "dxScheduler-recurrenceHourly": "Hver time",
            "dxScheduler-recurrenceDaily": "Daglig",
            "dxScheduler-recurrenceWeekly": "Ugentlig",
            "dxScheduler-recurrenceMonthly": "M\xe5nedlig",
            "dxScheduler-recurrenceYearly": "\xc5rligt",
            "dxScheduler-recurrenceRepeatEvery": "Gentag hver",
            "dxScheduler-recurrenceRepeatOn": "Gentag til",
            "dxScheduler-recurrenceEnd": "Slutgentagelse",
            "dxScheduler-recurrenceAfter": "Efter",
            "dxScheduler-recurrenceOn": "T\xe6ndt",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minut(er)",
            "dxScheduler-recurrenceRepeatHourly": "time(r)",
            "dxScheduler-recurrenceRepeatDaily": "dag(e)",
            "dxScheduler-recurrenceRepeatWeekly": "uge(r)",
            "dxScheduler-recurrenceRepeatMonthly": "m\xe5ned(er)",
            "dxScheduler-recurrenceRepeatYearly": "\xe5r",
            "dxScheduler-switcherDay": "Dag",
            "dxScheduler-switcherWeek": "Uge",
            "dxScheduler-switcherWorkWeek": "Arbejdsuge",
            "dxScheduler-switcherMonth": "M\xe5ned",
            "dxScheduler-switcherAgenda": "Dagsorden",
            "dxScheduler-switcherTimelineDay": "Tidslinje dag",
            "dxScheduler-switcherTimelineWeek": "Tidslinje uge",
            "dxScheduler-switcherTimelineWorkWeek": "Tidslinje arbejdsuge",
            "dxScheduler-switcherTimelineMonth": "Tidslinje m\xe5ned",
            "dxScheduler-recurrenceRepeatOnDate": "p\xe5 dato",
            "dxScheduler-recurrenceRepeatCount": "h\xe6ndelse(r)",
            "dxScheduler-allDay": "Hele dagen",
            "dxScheduler-ariaEditForm": "Rediger formular",
            "dxScheduler-confirmRecurrenceEditTitle": "Rediger tilbagevendende aftale",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Slet tilbagevendende aftale",
            "dxScheduler-confirmRecurrenceEditMessage": "Vil du kun redigere denne aftale eller hele serien?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Vil du kun slette denne aftale eller hele serien?",
            "dxScheduler-confirmRecurrenceEditSeries": "Rediger serie",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Slet serie",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Rediger aftale",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Slet aftale",
            "dxScheduler-noTimezoneTitle": "Ingen tidszone",
            "dxScheduler-moreAppointments": "{0} mere",
            "dxCalendar-currentDay": "Idag",
            "dxCalendar-currentMonth": "Nuv\xe6rende m\xe5ned",
            "dxCalendar-currentYear": "Nuv\xe6rende \xe5r",
            "dxCalendar-currentYearRange": "Nuv\xe6rende \xe5rsinterval",
            "dxCalendar-todayButtonText": "Idag",
            "dxCalendar-ariaWidgetName": "Kalender",
            "dxCalendar-previousMonthButtonLabel": "Forrige m\xe5ned",
            "dxCalendar-previousYearButtonLabel": "Forrige \xe5r",
            "dxCalendar-previousDecadeButtonLabel": "Forrige \xe5rti",
            "dxCalendar-previousCenturyButtonLabel": "Forrige \xe5rhundrede",
            "dxCalendar-nextMonthButtonLabel": "N\xe6ste m\xe5ned",
            "dxCalendar-nextYearButtonLabel": "N\xe6ste \xe5r",
            "dxCalendar-nextDecadeButtonLabel": "N\xe6ste \xe5rti",
            "dxCalendar-nextCenturyButtonLabel": "N\xe6ste \xe5rhundrede",
            "dxCalendar-captionMonthLabel": "Valg af m\xe5ned",
            "dxCalendar-captionYearLabel": "\xc5rsvalg",
            "dxCalendar-captionDecadeLabel": "\xc5rti valg",
            "dxCalendar-captionCenturyLabel": "\xc5rhundrede valg",
            "dxCalendar-selectedDate": "Den valgte dato er {0}",
            "dxCalendar-selectedDates": "De valgte datoer",
            "dxCalendar-selectedDateRange": "Det valgte datointerval er fra {0} til {1}",
            "dxCalendar-selectedMultipleDateRange": "fra {0} til {1}",
            "dxCalendar-selectedDateRangeCount": "Der er {0} valgte datointervaller",
            "dxCalendar-readOnlyLabel": "Skrivebeskyttet kalender",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Snak",
            "dxChat-textareaPlaceholder": "Skriv en besked",
            "dxChat-sendButtonAriaLabel": "Send",
            "dxChat-cancelEditingButtonAriaLabel": "Annuller",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Ukendt bruger",
            "dxChat-messageListAriaLabel": "Meddelelsesliste",
            "dxChat-alertListAriaLabel": "Fejlliste",
            "dxChat-emptyListMessage": "Der er ingen beskeder i denne chat",
            "dxChat-emptyListPrompt": "Skriv din f\xf8rste besked",
            "dxChat-typingMessageSingleUser": "{0} skriver...",
            "dxChat-typingMessageTwoUsers": "{0} og {1} skriver...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} og {2} skriver...",
            "dxChat-typingMessageMultipleUsers": "{0} og andre skriver...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "Rediger",
            "dxChat-editingDeleteMessage": "Slet",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "R\xf8d",
            "dxColorView-ariaGreen": "Gr\xf8n",
            "dxColorView-ariaBlue": "Bl\xe5",
            "dxColorView-ariaAlpha": "Gennemsigtighed",
            "dxColorView-ariaHex": "Farvekode",
            "dxTagBox-selected": "{0} valgt",
            "dxTagBox-allSelected": "Alle valgte ({0})",
            "dxTagBox-moreSelected": "{0} mere",
            "dxTagBox-tagRoleDescription": "Tag. Tryk p\xe5 sletteknappen for at fjerne dette tag",
            "dxTagBox-ariaRoleDescription": "Tag-felt",
            "vizExport-printingButtonText": "Udskriv",
            "vizExport-titleMenuText": "Eksportering/udskrivning",
            "vizExport-exportButtonText": "{0} fil",
            "dxFilterBuilder-and": "Og",
            "dxFilterBuilder-or": "Eller",
            "dxFilterBuilder-notAnd": "Ikke Og",
            "dxFilterBuilder-notOr": "Ikke eller",
            "dxFilterBuilder-addCondition": "Tilf\xf8j betingelse",
            "dxFilterBuilder-addGroup": "Tilf\xf8j gruppe",
            "dxFilterBuilder-enterValueText": "<indtast en v\xe6rdi>",
            "dxFilterBuilder-filterOperationEquals": "Lig med",
            "dxFilterBuilder-filterOperationNotEquals": "Er ikke lig",
            "dxFilterBuilder-filterOperationLess": "Er mindre end",
            "dxFilterBuilder-filterOperationLessOrEquals": "Er mindre end eller lig med",
            "dxFilterBuilder-filterOperationGreater": "Er st\xf8rre end",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Er st\xf8rre end eller lig med",
            "dxFilterBuilder-filterOperationStartsWith": "Starter med",
            "dxFilterBuilder-filterOperationContains": "Indeholder",
            "dxFilterBuilder-filterOperationNotContains": "Indeholder ikke",
            "dxFilterBuilder-filterOperationEndsWith": "Slutter med",
            "dxFilterBuilder-filterOperationIsBlank": "Er blank",
            "dxFilterBuilder-filterOperationIsNotBlank": "Er ikke blank",
            "dxFilterBuilder-filterOperationBetween": "Er mellem",
            "dxFilterBuilder-filterOperationAnyOf": "Er nogen af",
            "dxFilterBuilder-filterOperationNoneOf": "Er ingen af",
            "dxFilterBuilder-filterAriaRootElement": "Filterbygger",
            "dxFilterBuilder-filterAriaGroupLevel": "Niveau {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Gruppeelement",
            "dxFilterBuilder-filterAriaOperationButton": "Operation",
            "dxFilterBuilder-filterAriaAddButton": "Tilf\xf8j",
            "dxFilterBuilder-filterAriaRemoveButton": "Fjern {0}",
            "dxFilterBuilder-filterAriaItemField": "Elementfelt",
            "dxFilterBuilder-filterAriaItemOperation": "Elementoperation",
            "dxFilterBuilder-filterAriaItemValue": "Elementv\xe6rdi",
            "dxHtmlEditor-dialogColorCaption": "Skift skriftfarve",
            "dxHtmlEditor-dialogBackgroundCaption": "Skift baggrundsfarve",
            "dxHtmlEditor-dialogLinkCaption": "Tilf\xf8j link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "Tekst",
            "dxHtmlEditor-dialogLinkTargetField": "\xc5bn link i nyt vindue",
            "dxHtmlEditor-dialogImageCaption": "Tilf\xf8j billede",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternativ tekst",
            "dxHtmlEditor-dialogImageWidthField": "Bredde (px)",
            "dxHtmlEditor-dialogImageHeightField": "H\xf8jde (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "R\xe6kker",
            "dxHtmlEditor-dialogInsertTableColumnsField": "Kolonner",
            "dxHtmlEditor-dialogInsertTableCaption": "Inds\xe6t tabel",
            "dxHtmlEditor-dialogUpdateImageCaption": "Opdater billede",
            "dxHtmlEditor-dialogImageUpdateButton": "Opdater",
            "dxHtmlEditor-dialogImageAddButton": "Tilf\xf8j",
            "dxHtmlEditor-dialogImageSpecifyUrl": "Fra internettet",
            "dxHtmlEditor-dialogImageSelectFile": "Fra denne enhed",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Behold billedformat",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Indkodning til Base64",
            "dxHtmlEditor-heading": "Overskrift",
            "dxHtmlEditor-normalText": "Normal tekst",
            "dxHtmlEditor-background": "Baggrundsfarve",
            "dxHtmlEditor-bold": "Fed",
            "dxHtmlEditor-color": "Skrifttypefarve",
            "dxHtmlEditor-font": "Skrifttype",
            "dxHtmlEditor-italic": "Kursiv",
            "dxHtmlEditor-link": "Tilf\xf8j link",
            "dxHtmlEditor-image": "Tilf\xf8j billede",
            "dxHtmlEditor-size": "St\xf8rrelse",
            "dxHtmlEditor-strike": "Gennemstregning",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Understregning",
            "dxHtmlEditor-blockquote": "Blokcitat",
            "dxHtmlEditor-header": "Overskrift",
            "dxHtmlEditor-increaseIndent": "For\xf8g indrykning",
            "dxHtmlEditor-decreaseIndent": "Formindsk indrykning",
            "dxHtmlEditor-orderedList": "Sorteret liste",
            "dxHtmlEditor-bulletList": "Punktliste",
            "dxHtmlEditor-alignLeft": "Juster til venstre",
            "dxHtmlEditor-alignCenter": "Juster centreret",
            "dxHtmlEditor-alignRight": "Juster til h\xf8jre",
            "dxHtmlEditor-alignJustify": "Juster retf\xe6rdigt",
            "dxHtmlEditor-codeBlock": "Kodeblok",
            "dxHtmlEditor-variable": "Tilf\xf8j variabel",
            "dxHtmlEditor-undo": "Fortryd",
            "dxHtmlEditor-redo": "Gentag",
            "dxHtmlEditor-clear": "Ryd formatering",
            "dxHtmlEditor-insertTable": "Inds\xe6t tabel",
            "dxHtmlEditor-insertHeaderRow": "Inds\xe6t overskriftsr\xe6kke",
            "dxHtmlEditor-insertRowAbove": "Inds\xe6t r\xe6kke over",
            "dxHtmlEditor-insertRowBelow": "Inds\xe6t r\xe6kke under",
            "dxHtmlEditor-insertColumnLeft": "Inds\xe6t kolonne til venstre",
            "dxHtmlEditor-insertColumnRight": "Inds\xe6t kolonne til h\xf8jre",
            "dxHtmlEditor-deleteColumn": "Slet kolonne",
            "dxHtmlEditor-deleteRow": "Slet r\xe6kke",
            "dxHtmlEditor-deleteTable": "Slet tabel",
            "dxHtmlEditor-cellProperties": "Celleegenskaber",
            "dxHtmlEditor-tableProperties": "Tabelegenskaber",
            "dxHtmlEditor-insert": "Inds\xe6t",
            "dxHtmlEditor-delete": "Slet",
            "dxHtmlEditor-border": "Ramme",
            "dxHtmlEditor-style": "Stil",
            "dxHtmlEditor-width": "Bredde",
            "dxHtmlEditor-height": "H\xf8jde",
            "dxHtmlEditor-borderColor": "Farve",
            "dxHtmlEditor-borderWidth": "Rammebredde",
            "dxHtmlEditor-tableBackground": "Baggrund",
            "dxHtmlEditor-dimensions": "Dimensioner",
            "dxHtmlEditor-alignment": "Justering",
            "dxHtmlEditor-horizontal": "Vandret",
            "dxHtmlEditor-vertical": "Lodret",
            "dxHtmlEditor-paddingVertical": "Lodret polstring",
            "dxHtmlEditor-paddingHorizontal": "Vandret polstring",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "Liste",
            "dxHtmlEditor-ordered": "Sorteret",
            "dxHtmlEditor-bullet": "Punkt",
            "dxHtmlEditor-align": "Juster",
            "dxHtmlEditor-center": "Centrer",
            "dxHtmlEditor-left": "Venstre",
            "dxHtmlEditor-right": "H\xf8jre",
            "dxHtmlEditor-indent": "Indryk",
            "dxHtmlEditor-justify": "Retf\xe6rdigg\xf8r",
            "dxHtmlEditor-borderStyleNone": "ingen",
            "dxHtmlEditor-borderStyleHidden": "skjult",
            "dxHtmlEditor-borderStyleDotted": "prikket",
            "dxHtmlEditor-borderStyleDashed": "stiplet",
            "dxHtmlEditor-borderStyleSolid": "fast",
            "dxHtmlEditor-borderStyleDouble": "dobbelt",
            "dxHtmlEditor-borderStyleGroove": "rille",
            "dxHtmlEditor-borderStyleRidge": "ryg",
            "dxHtmlEditor-borderStyleInset": "indsat",
            "dxHtmlEditor-borderStyleOutset": "udsat",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Unavngivet mappe",
            "dxFileManager-rootDirectoryName": "Filer",
            "dxFileManager-errorNoAccess": "Adgang n\xe6gtet. Operationen kunne ikke fuldf\xf8res.",
            "dxFileManager-errorDirectoryExistsFormat": "Mappe '{0}' findes allerede.",
            "dxFileManager-errorFileExistsFormat": "Filen '{0}' findes allerede.",
            "dxFileManager-errorFileNotFoundFormat": "Filen '{0}' blev ikke fundet.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Mappe '{0}' blev ikke fundet.",
            "dxFileManager-errorWrongFileExtension": "Filtypenavn er ikke tilladt.",
            "dxFileManager-errorMaxFileSizeExceeded": "Filst\xf8rrelsen overstiger den maksimalt tilladte st\xf8rrelse.",
            "dxFileManager-errorInvalidSymbols": "Dette navn indeholder ugyldige tegn.",
            "dxFileManager-errorDefault": "Uspecificeret fejl.",
            "dxFileManager-errorDirectoryOpenFailed": "Mappen kan ikke \xe5bnes",
            "dxFileManager-commandCreate": "Ny mappe",
            "dxFileManager-commandRename": "Omd\xf8b",
            "dxFileManager-commandMove": "Flyt til",
            "dxFileManager-commandCopy": "Kopier til",
            "dxFileManager-commandDelete": "Slet",
            "dxFileManager-commandDownload": "Download",
            "dxFileManager-commandUpload": "Upload filer",
            "dxFileManager-commandRefresh": "Opdater",
            "dxFileManager-commandThumbnails": "Miniaturebilledevisning",
            "dxFileManager-commandDetails": "Detaljevisning",
            "dxFileManager-commandClearSelection": "Ryd valg",
            "dxFileManager-commandShowNavPane": "Skift navigationsrude",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Flyt til",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "Flyt",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "Kopier til",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "Kopier",
            "dxFileManager-dialogRenameItemTitle": "Omd\xf8b",
            "dxFileManager-dialogRenameItemButtonText": "Gem",
            "dxFileManager-dialogCreateDirectoryTitle": "Ny mappe",
            "dxFileManager-dialogCreateDirectoryButtonText": "Opret",
            "dxFileManager-dialogDeleteItemTitle": "Slet",
            "dxFileManager-dialogDeleteItemButtonText": "Slet",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Er du sikker p\xe5, at du vil slette {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Er du sikker p\xe5, at du vil slette {0} elementer?",
            "dxFileManager-dialogButtonCancel": "Annuller",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Opretter en mappe i {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Oprettede en mappe i {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Mappe blev ikke oprettet",
            "dxFileManager-editingCreateCommonErrorMessage": "Mappe blev ikke oprettet",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Omd\xf8bning af et element i {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Omd\xf8bte et element i {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Elementet blev ikke omd\xf8bt",
            "dxFileManager-editingRenameCommonErrorMessage": "Elementet blev ikke omd\xf8bt",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Sletning af et element fra {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Sletter {0} elementer fra {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Slettede et element fra {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Slettede {0} elementer fra {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Elementet blev ikke slettet",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} elementer blev ikke slettet",
            "dxFileManager-editingDeleteCommonErrorMessage": "Nogle elementer blev ikke slettet",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Flytter et element til {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Flytter {0} elementer til {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Flyttede et element til {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Flyttede {0} elementer til {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Elementet blev ikke flyttet",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} elementer blev ikke flyttet",
            "dxFileManager-editingMoveCommonErrorMessage": "Nogle elementer blev ikke flyttet",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Kopierer et element til {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Kopierer {0} elementer til {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Kopierede et element til {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Kopierede {0} elementer til {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Elementet blev ikke kopieret",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} elementer blev ikke kopieret",
            "dxFileManager-editingCopyCommonErrorMessage": "Nogle elementer blev ikke kopieret",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploader et element til {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploader {0} elementer til {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploadede et element til {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploadede {0} elementer til {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Elementet blev ikke uploadet",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} elementer blev ikke uploadet",
            "dxFileManager-editingUploadCanceledMessage": "Annulleret",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Elementet blev ikke downloadet",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} elementer blev ikke downloadet",
            "dxFileManager-listDetailsColumnCaptionName": "Navn",
            "dxFileManager-listDetailsColumnCaptionDateModified": "\xc6ndret dato",
            "dxFileManager-listDetailsColumnCaptionFileSize": "Filst\xf8rrelse",
            "dxFileManager-listThumbnailsTooltipTextSize": "St\xf8rrelse",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "\xc6ndret dato",
            "dxFileManager-notificationProgressPanelTitle": "Fremskridt",
            "dxFileManager-notificationProgressPanelEmptyListText": "Ingen operationer",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Annulleret",
            "dxDiagram-categoryGeneral": "Generel",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Organisationsdiagram",
            "dxDiagram-categoryContainers": "Beholdere",
            "dxDiagram-categoryCustom": "Brugerdefineret",
            "dxDiagram-commandExportToSvg": "Eksporter til SVG",
            "dxDiagram-commandExportToPng": "Eksporter til PNG",
            "dxDiagram-commandExportToJpg": "Eksporter til JPEG",
            "dxDiagram-commandUndo": "Fortryd",
            "dxDiagram-commandRedo": "Gentag",
            "dxDiagram-commandFontName": "Skrifttypenavn",
            "dxDiagram-commandFontSize": "Skrifttypest\xf8rrelse",
            "dxDiagram-commandBold": "Fed",
            "dxDiagram-commandItalic": "Kursiv",
            "dxDiagram-commandUnderline": "Understregning",
            "dxDiagram-commandTextColor": "Skrifttypefarve",
            "dxDiagram-commandLineColor": "Linjefarve",
            "dxDiagram-commandLineWidth": "Linjebredde",
            "dxDiagram-commandLineStyle": "Linjestil",
            "dxDiagram-commandLineStyleSolid": "Fast",
            "dxDiagram-commandLineStyleDotted": "Prikket",
            "dxDiagram-commandLineStyleDashed": "Stiplet",
            "dxDiagram-commandFillColor": "Fyld farve",
            "dxDiagram-commandAlignLeft": "Juster til venstre",
            "dxDiagram-commandAlignCenter": "Juster centreret",
            "dxDiagram-commandAlignRight": "Juster til h\xf8jre",
            "dxDiagram-commandConnectorLineType": "Type af tilslutningslinje",
            "dxDiagram-commandConnectorLineStraight": "Lige",
            "dxDiagram-commandConnectorLineOrthogonal": "Ortogonal",
            "dxDiagram-commandConnectorLineStart": "Start p\xe5 tilslutningslinje",
            "dxDiagram-commandConnectorLineEnd": "Slutning p\xe5 tilslutningslinje",
            "dxDiagram-commandConnectorLineNone": "Ingen",
            "dxDiagram-commandConnectorLineArrow": "Pil",
            "dxDiagram-commandFullscreen": "Fuldsk\xe6rm",
            "dxDiagram-commandUnits": "Enheder",
            "dxDiagram-commandPageSize": "Sidest\xf8rrelse",
            "dxDiagram-commandPageOrientation": "Sideorientering",
            "dxDiagram-commandPageOrientationLandscape": "Landskab",
            "dxDiagram-commandPageOrientationPortrait": "Portr\xe6t",
            "dxDiagram-commandPageColor": "Sidefarve",
            "dxDiagram-commandShowGrid": "Vis gitter",
            "dxDiagram-commandSnapToGrid": "Snap til gitter",
            "dxDiagram-commandGridSize": "Gitterst\xf8rrelse",
            "dxDiagram-commandZoomLevel": "Zoom niveau",
            "dxDiagram-commandAutoZoom": "Automatisk zoom",
            "dxDiagram-commandFitToContent": "Tilpas til indhold",
            "dxDiagram-commandFitToWidth": "Tilpas til bredden",
            "dxDiagram-commandAutoZoomByContent": "Automatisk zoom efter indhold",
            "dxDiagram-commandAutoZoomByWidth": "Automatisk zoom efter bredde",
            "dxDiagram-commandSimpleView": "Enkel visning",
            "dxDiagram-commandCut": "Klip",
            "dxDiagram-commandCopy": "Kopier",
            "dxDiagram-commandPaste": "Inds\xe6t",
            "dxDiagram-commandSelectAll": "V\xe6lg alle",
            "dxDiagram-commandDelete": "Slet",
            "dxDiagram-commandBringToFront": "Bring forrest",
            "dxDiagram-commandSendToBack": "Send tilbage",
            "dxDiagram-commandLock": "L\xe5s",
            "dxDiagram-commandUnlock": "L\xe5s op",
            "dxDiagram-commandInsertShapeImage": "Inds\xe6t billede...",
            "dxDiagram-commandEditShapeImage": "Skift billede...",
            "dxDiagram-commandDeleteShapeImage": "Slet billede",
            "dxDiagram-commandLayoutLeftToRight": "Venstre-til-h\xf8jre",
            "dxDiagram-commandLayoutRightToLeft": "H\xf8jre mod venstre",
            "dxDiagram-commandLayoutTopToBottom": "Top-til-bund",
            "dxDiagram-commandLayoutBottomToTop": "Bund-til-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "cm",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "OK",
            "dxDiagram-dialogButtonCancel": "Annuller",
            "dxDiagram-dialogInsertShapeImageTitle": "Inds\xe6t billede",
            "dxDiagram-dialogEditShapeImageTitle": "Skift billede",
            "dxDiagram-dialogEditShapeImageSelectButton": "V\xe6lg billede",
            "dxDiagram-dialogEditShapeImageLabelText": "eller slip en fil her",
            "dxDiagram-uiExport": "Eksporter",
            "dxDiagram-uiProperties": "Egenskaber",
            "dxDiagram-uiSettings": "Indstillinger",
            "dxDiagram-uiShowToolbox": "Vis v\xe6rkt\xf8jskasse",
            "dxDiagram-uiSearch": "S\xf8g",
            "dxDiagram-uiStyle": "Stil",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tr\xe6",
            "dxDiagram-uiLayoutLayered": "Lagdelt",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "Tekst",
            "dxDiagram-uiObject": "Objekt",
            "dxDiagram-uiConnector": "Tilslutning",
            "dxDiagram-uiPage": "Side",
            "dxDiagram-shapeText": "Tekst",
            "dxDiagram-shapeRectangle": "Rektangel",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Kryds",
            "dxDiagram-shapeTriangle": "Trekant",
            "dxDiagram-shapeDiamond": "Diamant",
            "dxDiagram-shapeHeart": "Hjerte",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Sekskant",
            "dxDiagram-shapeOctagon": "Oktagon",
            "dxDiagram-shapeStar": "Stjerne",
            "dxDiagram-shapeArrowLeft": "Venstre pil",
            "dxDiagram-shapeArrowUp": "Pil op",
            "dxDiagram-shapeArrowRight": "H\xf8jre pil",
            "dxDiagram-shapeArrowDown": "Pil ned",
            "dxDiagram-shapeArrowUpDown": "Pil op og ned",
            "dxDiagram-shapeArrowLeftRight": "Venstre h\xf8jre pil",
            "dxDiagram-shapeProcess": "Proces",
            "dxDiagram-shapeDecision": "Beslutning",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Foruddefineret proces",
            "dxDiagram-shapeDocument": "Dokument",
            "dxDiagram-shapeMultipleDocuments": "Flere dokumenter",
            "dxDiagram-shapeManualInput": "Manuel input",
            "dxDiagram-shapePreparation": "Forberedelse",
            "dxDiagram-shapeData": "Data",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Harddisk",
            "dxDiagram-shapeInternalStorage": "Intern opbevaring",
            "dxDiagram-shapePaperTape": "Papirtape",
            "dxDiagram-shapeManualOperation": "Manuel operation",
            "dxDiagram-shapeDelay": "Forsinke",
            "dxDiagram-shapeStoredData": "Lagrede data",
            "dxDiagram-shapeDisplay": "Visning",
            "dxDiagram-shapeMerge": "Sammenflet",
            "dxDiagram-shapeConnector": "Tilslutning",
            "dxDiagram-shapeOr": "Eller",
            "dxDiagram-shapeSummingJunction": "Opsummerende kryds",
            "dxDiagram-shapeContainerDefaultText": "Beholder",
            "dxDiagram-shapeVerticalContainer": "Lodret beholder",
            "dxDiagram-shapeHorizontalContainer": "Vandret beholder",
            "dxDiagram-shapeCardDefaultText": "Personens navn",
            "dxDiagram-shapeCardWithImageOnLeft": "Kort med billede til venstre",
            "dxDiagram-shapeCardWithImageOnTop": "Kort med billede p\xe5 toppen",
            "dxDiagram-shapeCardWithImageOnRight": "Kort med billede til h\xf8jre",
            "dxGantt-dialogTitle": "Titel",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "Slut",
            "dxGantt-dialogProgressTitle": "Fremskridt",
            "dxGantt-dialogResourcesTitle": "Ressourcer",
            "dxGantt-dialogResourceManagerTitle": "Ressourcechef",
            "dxGantt-dialogTaskDetailsTitle": "Opgavedetaljer",
            "dxGantt-dialogEditResourceListHint": "Rediger ressourceliste",
            "dxGantt-dialogEditNoResources": "Ingen ressourcer",
            "dxGantt-dialogButtonAdd": "Tilf\xf8j",
            "dxGantt-contextMenuNewTask": "Ny opgave",
            "dxGantt-contextMenuNewSubtask": "Ny underopgave",
            "dxGantt-contextMenuDeleteTask": "Slet opgave",
            "dxGantt-contextMenuDeleteDependency": "Slet afh\xe6ngighed",
            "dxGantt-dialogTaskDeleteConfirmation": "Sletning af en opgave sletter ogs\xe5 alle dens afh\xe6ngigheder og underopgaver. Er du sikker p\xe5, at du vil slette denne opgave?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Er du sikker p\xe5, at du vil slette afh\xe6ngigheden fra opgaven?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Sletning af en ressource sletter den ogs\xe5 fra opgaver, som denne ressource er tildelt. Er du sikker p\xe5, at du vil slette disse ressourcer? Ressourcer: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "Den opgave, du fors\xf8ger at flytte, er knyttet til en anden opgave af en afh\xe6ngighedsrelation. Denne \xe6ndring ville v\xe6re i strid med afh\xe6ngighedsreglerne. Hvordan vil du gerne komme videre?",
            "dxGantt-dialogConstraintViolationMessage": "Den opgave, du fors\xf8ger at flytte, er knyttet til en anden opgave af en afh\xe6ngighedsrelation. Hvordan vil du gerne komme videre?",
            "dxGantt-dialogCancelOperationMessage": "Annuller operationen",
            "dxGantt-dialogDeleteDependencyMessage": "Slet afh\xe6ngigheden",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Flyt opgaven og behold afh\xe6ngigheden",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "Den opgave, du fors\xf8ger at flytte, er knyttet til en anden opgave af afh\xe6ngighedsrelationer. Denne \xe6ndring ville v\xe6re i strid med afh\xe6ngighedsreglerne. Hvordan vil du gerne komme videre?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "Den opgave, du fors\xf8ger at flytte, er knyttet til en anden opgave af afh\xe6ngighedsrelationer. Hvordan vil du gerne komme videre?",
            "dxGantt-dialogDeleteDependenciesMessage": "Slet afh\xe6ngighedsrelationerne",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Flyt opgaven og behold afh\xe6ngighederne",
            "dxGantt-undo": "Fortryd",
            "dxGantt-redo": "Gentag",
            "dxGantt-expandAll": "Udvid alle",
            "dxGantt-collapseAll": "Sammenklap alle",
            "dxGantt-addNewTask": "Tilf\xf8j ny opgave",
            "dxGantt-deleteSelectedTask": "Slet den valgte opgave",
            "dxGantt-zoomIn": "Zoom ind",
            "dxGantt-zoomOut": "Zoom ud",
            "dxGantt-fullScreen": "Fuldsk\xe6rm",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sorter stigende",
            "dxGantt-sortingDescendingText": "Sorter faldende",
            "dxGantt-sortingClearText": "Ryd sortering",
            "dxGantt-showResources": "Vis ressourcer",
            "dxGantt-showDependencies": "Vis afh\xe6ngigheder",
            "dxGantt-dialogStartDateValidation": "Startdatoen skal v\xe6re efter {0}",
            "dxGantt-dialogEndDateValidation": "Slutdatoen skal v\xe6re efter {0}",
            "dxGallery-itemName": "Gallerielement",
            "dxMultiView-elementAriaRoleDescription": "Multivisning",
            "dxMultiView-elementAriaLabel": "Brug piletasterne eller stryg for at navigere mellem visninger",
            "dxMultiView-itemAriaRoleDescription": "Vis",
            "dxMultiView-itemAriaLabel": "{0} af {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
