/*!
* DevExtreme (dx.messages.bg.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";

! function(root, factory) {
    if ("function" === typeof define && define.amd) {
        define((function(require) {
            factory(require("devextreme/common/core/localization"))
        }))
    } else if ("object" === typeof module && module.exports) {
        factory(require("devextreme/common/core/localization"))
    } else {
        factory(DevExpress.localization)
    }
}(0, (function(localization) {
    localization.loadMessages({
        bg: {
            Yes: "\u0414\u0430",
            No: "\u041d\u0435",
            Cancel: "\u041e\u0442\u043a\u0430\u0437",
            CheckState: "Check state",
            Close: "\u0417\u0430\u0442\u0432\u0430\u0440\u044f\u043d\u0435",
            Clear: "\u0418\u0437\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435",
            Done: "Done",
            Loading: "Loading...",
            Select: "Select...",
            Search: "\u0422\u044a\u0440\u0441\u0435\u043d\u0435",
            Back: "\u041d\u0430\u0437\u0430\u0434",
            OK: "\u041e\u041a",
            Today: "Today",
            Yesterday: "Yesterday",
            "dxCollectionWidget-noDataText": "No data to display",
            "dxDropDownEditor-selectLabel": "\u0418\u0437\u0431\u043e\u0440",
            "validation-required": "Required",
            "validation-required-formatted": "{0} is required",
            "validation-numeric": "Value must be a number",
            "validation-numeric-formatted": "{0} must be a number",
            "validation-range": "Value is out of range",
            "validation-range-formatted": "{0} is out of range",
            "validation-stringLength": "The length of the value is not correct",
            "validation-stringLength-formatted": "The length of {0} is not correct",
            "validation-custom": "Value is invalid",
            "validation-custom-formatted": "{0} is invalid",
            "validation-async": "Value is invalid",
            "validation-async-formatted": "{0} is invalid",
            "validation-compare": "Values do not match",
            "validation-compare-formatted": "{0} does not match",
            "validation-pattern": "Value does not match pattern",
            "validation-pattern-formatted": "{0} does not match pattern",
            "validation-email": "Email is invalid",
            "validation-email-formatted": "{0} is invalid",
            "validation-mask": "Value is invalid",
            "dxLookup-searchPlaceholder": "Minimum character number: {0}",
            "dxList-pullingDownText": "Pull down to refresh...",
            "dxList-pulledDownText": "Release to refresh...",
            "dxList-refreshingText": "Refreshing...",
            "dxList-pageLoadingText": "Loading...",
            "dxList-nextButtonText": "\u041f\u043e\u0432\u0435\u0447\u0435",
            "dxList-selectAll": "\u0418\u0437\u0431\u0438\u0440\u0430\u043d\u0435 \u043d\u0430 \u0412\u0441\u0438\u0447\u043a\u0438",
            "dxList-listAriaLabel": "Items",
            "dxList-listAriaLabel-deletable": "Deletable items",
            "dxListEditDecorator-delete": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxListEditDecorator-more": "\u041f\u043e\u0432\u0435\u0447\u0435",
            "dxList-selectAll-indeterminate": "Half-checked",
            "dxList-selectAll-checked": "Checked",
            "dxList-selectAll-notChecked": "Not checked",
            "dxList-ariaRoleDescription": "List",
            "dxList-listAriaLabel-itemContent": "List item content",
            "dxScrollView-pullingDownText": "Pull down to refresh...",
            "dxScrollView-pulledDownText": "Release to refresh...",
            "dxScrollView-refreshingText": "Refreshing...",
            "dxScrollView-reachBottomText": "Loading...",
            "dxDateBox-simulatedDataPickerTitleTime": "Select time",
            "dxDateBox-simulatedDataPickerTitleDate": "Select date",
            "dxDateBox-simulatedDataPickerTitleDateTime": "Select date and time",
            "dxDateBox-validation-datetime": "Value must be a date or time",
            "dxDateRangeBox-invalidStartDateMessage": "Start value must be a date",
            "dxDateRangeBox-invalidEndDateMessage": "End value must be a date",
            "dxDateRangeBox-startDateOutOfRangeMessage": "Start date is out of range",
            "dxDateRangeBox-endDateOutOfRangeMessage": "End date is out of range",
            "dxDateRangeBox-startDateLabel": "\u041d\u0430\u0447\u0430\u043b\u043d\u0430 \u0434\u0430\u0442\u0430",
            "dxDateRangeBox-endDateLabel": "\u041a\u0440\u0430\u0435\u043d \u0441\u0440\u043e\u043a",
            "dxFileUploader-selectFile": "Select a file",
            "dxFileUploader-dropFile": "or Drop a file here",
            "dxFileUploader-bytes": "bytes",
            "dxFileUploader-kb": "KB",
            "dxFileUploader-Mb": "MB",
            "dxFileUploader-Gb": "GB",
            "dxFileUploader-upload": "\u041a\u0430\u0447\u0432\u0430\u043d\u0435",
            "dxFileUploader-uploaded": "Uploaded",
            "dxFileUploader-readyToUpload": "Ready to upload",
            "dxFileUploader-uploadAbortedMessage": "Upload cancelled",
            "dxFileUploader-uploadFailedMessage": "Upload failed",
            "dxFileUploader-invalidFileExtension": "File type is not allowed",
            "dxFileUploader-invalidMaxFileSize": "File is too large",
            "dxFileUploader-invalidMinFileSize": "File is too small",
            "dxFileUploader-fileListLabel": "File list",
            "dxFileUploader-removeFileButtonLabel": "Remove file {0}",
            "dxFileUploader-uploadFileButtonLabel": "Upload file {0}",
            "dxRangeSlider-ariaFrom": "\u041e\u0442",
            "dxRangeSlider-ariaTill": "Till",
            "dxSwitch-switchedOnText": "ON",
            "dxSwitch-switchedOffText": "OFF",
            "dxForm-optionalMark": "\u041d\u0435\u0437\u0430\u0434\u044a\u043b\u0436\u0438\u0442\u0435\u043b\u043d\u043e",
            "dxForm-requiredMessage": "{0} is required",
            "dxForm-smartPasteButtonText": "Smart Paste",
            "dxForm-resetButtonText": "\u041d\u0443\u043b\u0438\u0440\u0430\u043d\u0435",
            "dxForm-submitButtonText": "Submit",
            "dxNumberBox-invalidValueMessage": "Value must be a number",
            "dxNumberBox-noDataText": "\u041d\u044f\u043c\u0430 \u0434\u0430\u043d\u043d\u0438",
            "dxDataGrid-aiPromptEditorTitle": "AI Prompt Editor",
            "dxDataGrid-aiPromptEditorPlaceholder": "Prompt AI to generate the column's values",
            "dxDataGrid-aiPromptEditorApplyButton": "Apply",
            "dxDataGrid-aiPromptEditorRegenerateButton": "Regenerate Data",
            "dxDataGrid-aiPromptEditorStopButton": "Stop",
            "dxDataGrid-aiDropDownAutofill": "Autofill with AI",
            "dxDataGrid-aiDropDownClear": "Clear Data",
            "dxDataGrid-emptyHeaderWithColumnChooserText": "Use {0} to display columns",
            "dxDataGrid-emptyHeaderWithGroupPanelText": "Drag a column from the group panel here",
            "dxDataGrid-emptyHeaderWithColumnChooserAndGroupPanelText": "Use {0} or drag a column from the group panel",
            "dxDataGrid-emptyHeaderColumnChooserText": "column chooser",
            "dxDataGrid-columnChooserTitle": "Column Chooser",
            "dxDataGrid-columnChooserEmptyText": "Drag a column here to hide it",
            "dxDataGrid-groupContinuesMessage": "Continues on the next page",
            "dxDataGrid-groupContinuedMessage": "Continued from the previous page",
            "dxDataGrid-groupHeaderText": "Group by This Column",
            "dxDataGrid-ungroupHeaderText": "Ungroup",
            "dxDataGrid-ungroupAllText": "Ungroup All",
            "dxDataGrid-editingEditRow": "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0430\u043d\u0435",
            "dxDataGrid-editingSaveRowChanges": "\u0417\u0430\u043f\u0430\u0437\u0432\u0430\u043d\u0435",
            "dxDataGrid-editingCancelRowChanges": "\u041e\u0442\u043a\u0430\u0437",
            "dxDataGrid-editingDeleteRow": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxDataGrid-editingUndeleteRow": "Undelete",
            "dxDataGrid-editingConfirmDeleteMessage": "\u041f\u043e\u0442\u0432\u044a\u0440\u0436\u0434\u0435\u043d\u0438\u0435 \u0437\u0430 \u043f\u0440\u0435\u043c\u0430\u0445\u0432\u0430\u043d\u0435 \u043d\u0430 \u0442\u043e\u0437\u0438 \u0437\u0430\u043f\u0438\u0441?",
            "dxDataGrid-validationCancelChanges": "Cancel changes",
            "dxDataGrid-groupPanelEmptyText": "Drag a column header here to group by that column",
            "dxDataGrid-noDataText": "\u041d\u044f\u043c\u0430 \u0434\u0430\u043d\u043d\u0438",
            "dxDataGrid-searchPanelPlaceholder": "Search...",
            "dxDataGrid-filterRowShowAllText": "(All)",
            "dxDataGrid-filterRowResetOperationText": "\u041d\u0443\u043b\u0438\u0440\u0430\u043d\u0435",
            "dxDataGrid-filterRowOperationEquals": "Equals",
            "dxDataGrid-filterRowOperationNotEquals": "Does not equal",
            "dxDataGrid-filterRowOperationLess": "Less than",
            "dxDataGrid-filterRowOperationLessOrEquals": "Less than or equal to",
            "dxDataGrid-filterRowOperationGreater": "Greater than",
            "dxDataGrid-filterRowOperationGreaterOrEquals": "Greater than or equal to",
            "dxDataGrid-filterRowOperationStartsWith": "\u041d\u0430\u0447\u0430\u043b\u043e \u0441",
            "dxDataGrid-filterRowOperationContains": "\u0421\u044a\u0434\u044a\u0440\u0436\u0430\u043d",
            "dxDataGrid-filterRowOperationNotContains": "Does not contain",
            "dxDataGrid-filterRowOperationEndsWith": "Ends with",
            "dxDataGrid-filterRowOperationBetween": "Between",
            "dxDataGrid-filterRowOperationBetweenStartText": "Start",
            "dxDataGrid-filterRowOperationBetweenEndText": "End",
            "dxDataGrid-ariaSearchBox": "Search box",
            "dxDataGrid-applyFilterText": "Apply filter",
            "dxDataGrid-trueText": "true",
            "dxDataGrid-falseText": "false",
            "dxDataGrid-sortingAscendingText": "Sort Ascending",
            "dxDataGrid-sortingDescendingText": "Sort Descending",
            "dxDataGrid-sortingClearText": "Clear Sorting",
            "dxDataGrid-ariaNotSortedColumn": "Not sorted column",
            "dxDataGrid-ariaSortedAscendingColumn": "Column sorted in ascending order",
            "dxDataGrid-ariaSortedDescendingColumn": "Column sorted in descending order",
            "dxDataGrid-ariaSortIndex": "Sort index {0}",
            "dxDataGrid-editingSaveAllChanges": "Save changes",
            "dxDataGrid-editingCancelAllChanges": "Discard changes",
            "dxDataGrid-editingAddRow": "Add a row",
            "dxDataGrid-summaryMin": "Min: {0}",
            "dxDataGrid-summaryMinOtherColumn": "Min of {1} is {0}",
            "dxDataGrid-summaryMax": "Max: {0}",
            "dxDataGrid-summaryMaxOtherColumn": "Max of {1} is {0}",
            "dxDataGrid-summaryAvg": "Avg: {0}",
            "dxDataGrid-summaryAvgOtherColumn": "Avg of {1} is {0}",
            "dxDataGrid-summarySum": "Sum: {0}",
            "dxDataGrid-summarySumOtherColumn": "Sum of {1} is {0}",
            "dxDataGrid-summaryCount": "Count: {0}",
            "dxDataGrid-columnFixingFix": "Set Fixed Position",
            "dxDataGrid-columnFixingUnfix": "Unfix",
            "dxDataGrid-columnFixingLeftPosition": "\u041b\u044f\u0432\u043e",
            "dxDataGrid-columnFixingRightPosition": "\u0414\u044f\u0441\u043d\u043e",
            "dxDataGrid-columnFixingStickyPosition": "Sticky",
            "dxDataGrid-exportTo": "\u0418\u0437\u043d\u0430\u0441\u044f\u043d\u0435",
            "dxDataGrid-exportToExcel": "Export to Excel file",
            "dxDataGrid-exporting": "Exporting...",
            "dxDataGrid-excelFormat": "Excel file",
            "dxDataGrid-selectedRows": "Selected rows",
            "dxDataGrid-exportSelectedRows": "Export selected rows to {0}",
            "dxDataGrid-exportAll": "Export all data to {0}",
            "dxDataGrid-headerFilterLabel": "Filter options",
            "dxDataGrid-headerFilterIndicatorLabel": "Show filter options for column '{0}'",
            "dxDataGrid-headerFilterEmptyValue": "(Blanks)",
            "dxDataGrid-headerFilterOK": "\u041e\u041a",
            "dxDataGrid-headerFilterCancel": "\u041e\u0442\u043a\u0430\u0437",
            "dxDataGrid-ariaAdaptiveCollapse": "Hide additional data",
            "dxDataGrid-ariaAdaptiveExpand": "Display additional data",
            "dxDataGrid-ariaColumn": "Column",
            "dxDataGrid-ariaColumnHeader": "Column header",
            "dxDataGrid-ariaValue": "C\u0442\u043e\u0439\u043d\u043e\u0441\u0442",
            "dxDataGrid-ariaError": "\u0413\u0440\u0435\u0448\u043a\u0430",
            "dxDataGrid-ariaRevertButton": "Press Escape to discard the changes",
            "dxDataGrid-ariaFilterCell": "Filter cell",
            "dxDataGrid-ariaCollapse": "Collapse",
            "dxDataGrid-ariaModifiedCell": "Modified",
            "dxDataGrid-ariaDeletedCell": "\u0417\u0430\u043b\u0438\u0447\u0435\u043d\u043e",
            "dxDataGrid-ariaEditableCell": "Editable",
            "dxDataGrid-ariaExpand": "Expand",
            "dxDataGrid-ariaCollapsedRow": "Collapsed row",
            "dxDataGrid-ariaExpandedRow": "Expanded row",
            "dxDataGrid-ariaDataGrid": "Data grid with {0} rows and {1} columns",
            "dxDataGrid-ariaSearchInGrid": "Search in the data grid",
            "dxDataGrid-ariaSelectAll": "\u0418\u0437\u0431\u0438\u0440\u0430\u043d\u0435 \u043d\u0430 \u0412\u0441\u0438\u0447\u043a\u0438",
            "dxDataGrid-ariaSelectRow": "Select row",
            "dxDataGrid-ariaToolbar": "Data grid toolbar",
            "dxDataGrid-ariaEditForm": "Edit form",
            "dxDataGrid-filterBuilderPopupTitle": "Filter Builder",
            "dxDataGrid-filterPanelCreateFilter": "Create Filter",
            "dxDataGrid-filterPanelClearFilter": "\u0418\u0437\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435",
            "dxDataGrid-filterPanelFilterEnabledHint": "Enable the filter",
            "dxDataGrid-masterDetail": "Cell with details",
            "dxDataGrid-moveColumnToTheRight": "Move to the right",
            "dxDataGrid-moveColumnToTheLeft": "Move to the left",
            "dxTreeList-ariaTreeList": "Tree list with {0} rows and {1} columns",
            "dxTreeList-ariaExpandableInstruction": "Press Ctrl + right arrow to expand the focused node and Ctrl + left arrow to collapse it",
            "dxTreeList-ariaSearchInGrid": "Search in the tree list",
            "dxTreeList-ariaToolbar": "Tree list toolbar",
            "dxTreeList-editingAddRowToNode": "\u0414\u043e\u0431\u0430\u0432\u044f\u043d\u0435",
            "dxPager-infoText": "Page {0} of {1} ({2} items)",
            "dxPager-pagesCountText": "of",
            "dxPager-pageSize": "Items per page: {0}",
            "dxPager-pageSizesAllText": "\u0412\u0441\u0438\u0447\u043a\u0438",
            "dxPager-page": "Page {0}",
            "dxPager-prevPage": "\u041f\u0440\u0435\u0434\u0438\u0448\u043d\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxPager-nextPage": "\u0421\u043b\u0435\u0434\u0432\u0430\u0449\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxPager-ariaLabel": "Page navigation",
            "dxPager-ariaPageSize": "\u0420\u0430\u0437\u043c\u0435\u0440 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\u0442\u0430",
            "dxPager-ariaPageNumber": "Page number",
            "dxPagination-infoText": "Page {0} of {1} ({2} items)",
            "dxPagination-pagesCountText": "of",
            "dxPagination-pageSize": "Items per page: {0}",
            "dxPagination-pageSizesAllText": "\u0412\u0441\u0438\u0447\u043a\u0438",
            "dxPagination-page": "Page {0}",
            "dxPagination-prevPage": "\u041f\u0440\u0435\u0434\u0438\u0448\u043d\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxPagination-nextPage": "\u0421\u043b\u0435\u0434\u0432\u0430\u0449\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxPagination-ariaLabel": "Page navigation",
            "dxPagination-ariaPageSize": "\u0420\u0430\u0437\u043c\u0435\u0440 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\u0442\u0430",
            "dxPagination-ariaPageNumber": "Page number",
            "dxPivotGrid-grandTotal": "Grand Total",
            "dxPivotGrid-total": "{0} Total",
            "dxPivotGrid-fieldChooserTitle": "Field Chooser",
            "dxPivotGrid-showFieldChooser": "Show Field Chooser",
            "dxPivotGrid-expandAll": "\u041f\u043e\u043a\u0430\u0437\u0432\u0430\u043d\u0435 \u043d\u0430 \u0432\u0441\u0438\u0447\u043a\u043e",
            "dxPivotGrid-collapseAll": "\u0421\u043a\u0440\u0438\u0432\u0430\u043d\u0435 \u043d\u0430 \u0432\u0441\u0438\u0447\u043a\u043e",
            "dxPivotGrid-sortColumnBySummary": 'Sort "{0}" by This Column',
            "dxPivotGrid-sortRowBySummary": 'Sort "{0}" by This Row',
            "dxPivotGrid-removeAllSorting": "Remove All Sorting",
            "dxPivotGrid-dataNotAvailable": "\u041d\u0435 \u0435 \u043d\u0430\u043b\u0438\u0447\u043d\u043e",
            "dxPivotGrid-rowFields": "Row Fields",
            "dxPivotGrid-columnFields": "Column Fields",
            "dxPivotGrid-dataFields": "Data Fields",
            "dxPivotGrid-filterFields": "Filter Fields",
            "dxPivotGrid-allFields": "All Fields",
            "dxPivotGrid-columnFieldArea": "Drop Column Fields Here",
            "dxPivotGrid-dataFieldArea": "Drop Data Fields Here",
            "dxPivotGrid-rowFieldArea": "Drop Row Fields Here",
            "dxPivotGrid-filterFieldArea": "Drop Filter Fields Here",
            "dxScheduler-dateRange": "from {0} to {1}",
            "dxScheduler-ariaLabel": "Scheduler. {0} view: {1} with {2} appointments",
            "dxScheduler-ariaLabel-currentIndicator-present": "The current time indicator is visible in the view",
            "dxScheduler-ariaLabel-currentIndicator-not-present": "The current time indicator is not visible on the screen",
            "dxScheduler-appointmentAriaLabel-group": "Group: {0}",
            "dxScheduler-appointmentAriaLabel-recurring": "Recurring appointment",
            "dxScheduler-appointmentListAriaLabel": "Appointment list",
            "dxScheduler-newPopupTitle": "New Appointment",
            "dxScheduler-editPopupTitle": "Edit Appointment",
            "dxScheduler-editPopupSaveButtonText": "Save",
            "dxScheduler-editorLabelTitle": "\u0417\u0430\u0433\u043b\u0430\u0432\u0438\u0435",
            "dxScheduler-editorLabelStartDate": "\u041d\u0430\u0447\u0430\u043b\u043d\u0430 \u0434\u0430\u0442\u0430",
            "dxScheduler-editorLabelEndDate": "\u041a\u0440\u0430\u0435\u043d \u0441\u0440\u043e\u043a",
            "dxScheduler-editorLabelDescription": "\u041e\u043f\u0438\u0441\u0430\u043d\u0438\u0435",
            "dxScheduler-editorLabelRecurrence": "Repeat",
            "dxScheduler-noSubject": "(No subject)",
            "dxScheduler-navigationToday": "Today",
            "dxScheduler-navigationPrevious": "\u041f\u0440\u0435\u0434\u0438\u0448\u043d\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxScheduler-navigationNext": "\u0421\u043b\u0435\u0434\u0432\u0430\u0449\u0430 \u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxScheduler-openAppointment": "Open appointment",
            "dxScheduler-recurrenceNever": "\u041d\u0438\u043a\u043e\u0433\u0430",
            "dxScheduler-recurrenceMinutely": "Every minute",
            "dxScheduler-recurrenceHourly": "Hourly",
            "dxScheduler-recurrenceDaily": "Daily",
            "dxScheduler-recurrenceWeekly": "Weekly",
            "dxScheduler-recurrenceMonthly": "Monthly",
            "dxScheduler-recurrenceYearly": "Yearly",
            "dxScheduler-recurrenceRepeatEvery": "Repeat Every",
            "dxScheduler-recurrenceRepeatOn": "Repeat On",
            "dxScheduler-recurrenceEnd": "End repeat",
            "dxScheduler-recurrenceAfter": "\u0421\u043b\u0435\u0434",
            "dxScheduler-recurrenceOn": "On",
            "dxScheduler-recurrenceUntilDateLabel": "Date when repeat ends",
            "dxScheduler-recurrenceOccurrenceLabel": "Number of occurrences",
            "dxScheduler-recurrenceRepeatMinutely": "minute(s)",
            "dxScheduler-recurrenceRepeatHourly": "hour(s)",
            "dxScheduler-recurrenceRepeatDaily": "day(s)",
            "dxScheduler-recurrenceRepeatWeekly": "week(s)",
            "dxScheduler-recurrenceRepeatMonthly": "month(s)",
            "dxScheduler-recurrenceRepeatYearly": "year(s)",
            "dxScheduler-switcherDay": "\u0414\u0435\u043d",
            "dxScheduler-switcherWeek": "\u0421\u0435\u0434\u043c\u0438\u0446\u0430",
            "dxScheduler-switcherWorkWeek": "Work Week",
            "dxScheduler-switcherMonth": "\u041c\u0435\u0441\u0435\u0446",
            "dxScheduler-switcherAgenda": "Agenda",
            "dxScheduler-switcherTimelineDay": "Timeline Day",
            "dxScheduler-switcherTimelineWeek": "Timeline Week",
            "dxScheduler-switcherTimelineWorkWeek": "Timeline Work Week",
            "dxScheduler-switcherTimelineMonth": "Timeline Month",
            "dxScheduler-recurrenceRepeatOnDate": "on date",
            "dxScheduler-recurrenceRepeatCount": "occurrence(s)",
            "dxScheduler-allDay": "All day",
            "dxScheduler-ariaEditForm": "Edit form",
            "dxScheduler-confirmRecurrenceEditTitle": "Edit Recurring Appointment",
            "dxScheduler-confirmRecurrenceDeleteTitle": "Delete Recurring Appointment",
            "dxScheduler-confirmRecurrenceEditMessage": "Do you want to edit only this appointment or the whole series?",
            "dxScheduler-confirmRecurrenceDeleteMessage": "Do you want to delete only this appointment or the whole series?",
            "dxScheduler-confirmRecurrenceEditSeries": "Edit series",
            "dxScheduler-confirmRecurrenceDeleteSeries": "Delete series",
            "dxScheduler-confirmRecurrenceEditOccurrence": "Edit appointment",
            "dxScheduler-confirmRecurrenceDeleteOccurrence": "Delete appointment",
            "dxScheduler-noTimezoneTitle": "No timezone",
            "dxScheduler-moreAppointments": "{0} more",
            "dxCalendar-currentDay": "Today",
            "dxCalendar-currentMonth": "Current month",
            "dxCalendar-currentYear": "Current year",
            "dxCalendar-currentYearRange": "Current year range",
            "dxCalendar-todayButtonText": "Today",
            "dxCalendar-ariaWidgetName": "Calendar",
            "dxCalendar-previousMonthButtonLabel": "Previous month",
            "dxCalendar-previousYearButtonLabel": "Previous year",
            "dxCalendar-previousDecadeButtonLabel": "Previous decade",
            "dxCalendar-previousCenturyButtonLabel": "Previous century",
            "dxCalendar-nextMonthButtonLabel": "Next month",
            "dxCalendar-nextYearButtonLabel": "\u0421\u043b\u0435\u0434\u0432\u0430\u0449\u0430 \u0433\u043e\u0434\u0438\u043d\u0430",
            "dxCalendar-nextDecadeButtonLabel": "Next decade",
            "dxCalendar-nextCenturyButtonLabel": "Next century",
            "dxCalendar-captionMonthLabel": "Month selection",
            "dxCalendar-captionYearLabel": "Year selection",
            "dxCalendar-captionDecadeLabel": "Decade selection",
            "dxCalendar-captionCenturyLabel": "Century selection",
            "dxCalendar-selectedDate": "The selected date is {0}",
            "dxCalendar-selectedDates": "The selected dates",
            "dxCalendar-selectedDateRange": "The selected date range is from {0} to {1}",
            "dxCalendar-selectedMultipleDateRange": "from {0} to {1}",
            "dxCalendar-selectedDateRangeCount": "There are {0} selected date ranges",
            "dxCalendar-readOnlyLabel": "Read-only calendar",
            "dxCardView-ariaSearchInGrid": "Search in the card view",
            "dxCardView-ariaHeaderItemLabel": "Field name {0}",
            "dxCardView-ariaHeaderItemSortingAscendingLabel": "Sorted in ascending order",
            "dxCardView-ariaHeaderItemSortingDescendingLabel": "Sorted in descending order",
            "dxCardView-ariaHeaderItemSortingIndexLabel": "Sort index {0}",
            "dxCardView-ariaHeaderHasHeaderFilterLabel": "Header filter applied",
            "dxCardView-ariaSelectCard": "Select card",
            "dxCardView-ariaCardView": "Card view with {0} cards. Each card has {1} fields",
            "dxCardView-ariaCard": "Card",
            "dxCardView-ariaEditableCard": "Editable card",
            "dxCardView-ariaCardPosition": "Row {0}, column {1}",
            "dxCardView-ariaSelectedCardState": "Selected",
            "dxCardView-ariaNotSelectedCardState": "Not selected",
            "dxCardView-selectAll": "Select all",
            "dxCardView-clearSelection": "Clear selection",
            "dxCardView-cardNoImageAriaLabel": "No image",
            "dxCardView-headerItemDropZoneText": "Drop the header item here",
            "dxCardView-emptyHeaderPanelText": "Use {0} to display columns",
            "dxCardView-emptyHeaderPanelColumnChooserText": "column chooser",
            "dxAvatar-defaultImageAlt": "Avatar",
            "dxChat-elementAriaLabel": "Chat",
            "dxChat-textareaPlaceholder": "Type a message",
            "dxChat-sendButtonAriaLabel": "\u0418\u0437\u043f\u0440\u0430\u0449\u0430\u043d\u0435",
            "dxChat-cancelEditingButtonAriaLabel": "\u041e\u0442\u043a\u0430\u0437",
            "dxChat-editingMessageCaption": "Edit Message",
            "dxChat-defaultUserName": "Unknown User",
            "dxChat-messageListAriaLabel": "Message list",
            "dxChat-alertListAriaLabel": "Error list",
            "dxChat-emptyListMessage": "There are no messages in this chat",
            "dxChat-emptyListPrompt": "Write your first message",
            "dxChat-typingMessageSingleUser": "{0} is typing...",
            "dxChat-typingMessageTwoUsers": "{0} and {1} are typing...",
            "dxChat-typingMessageThreeUsers": "{0}, {1} and {2} are typing...",
            "dxChat-typingMessageMultipleUsers": "{0} and others are typing...",
            "dxChat-editedMessageText": "Edited",
            "dxChat-editingEditMessage": "\u0420\u0435\u0434\u0430\u043a\u0442\u0438\u0440\u0430\u043d\u0435",
            "dxChat-editingDeleteMessage": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxChat-editingDeleteConfirmText": "Are you sure you want to delete this message?",
            "dxChat-deletedMessageText": "This message was deleted",
            "dxChat-defaultImageAlt": "Image shared in chat",
            "dxChat-fileViewLabel": "File list",
            "dxChat-downloadButtonLabel": "Download file {0}",
            "dxChat-fileLimitReachedWarning": "You selected too many files. Select no more than {0} files and retry.",
            "dxColorView-ariaRed": "Red",
            "dxColorView-ariaGreen": "Green",
            "dxColorView-ariaBlue": "Blue",
            "dxColorView-ariaAlpha": "Transparency",
            "dxColorView-ariaHex": "Color code",
            "dxTagBox-selected": "{0} selected",
            "dxTagBox-allSelected": "All selected ({0})",
            "dxTagBox-moreSelected": "{0} more",
            "dxTagBox-tagRoleDescription": "Tag. Press the delete button to remove this tag",
            "dxTagBox-ariaRoleDescription": "Tag box",
            "vizExport-printingButtonText": "\u041f\u0440\u0438\u043d\u0442\u0438\u0440\u0430\u043d\u0435",
            "vizExport-titleMenuText": "Exporting/Printing",
            "vizExport-exportButtonText": "{0} file",
            "dxFilterBuilder-and": "And",
            "dxFilterBuilder-or": "\u0438\u043b\u0438",
            "dxFilterBuilder-notAnd": "Not And",
            "dxFilterBuilder-notOr": "Not Or",
            "dxFilterBuilder-addCondition": "Add Condition",
            "dxFilterBuilder-addGroup": "\u0414\u043e\u0431\u0430\u0432\u044f\u043d\u0435 \u043d\u0430 \u0433\u0440\u0443\u043f\u0430",
            "dxFilterBuilder-enterValueText": "<enter a value>",
            "dxFilterBuilder-filterOperationEquals": "Equals",
            "dxFilterBuilder-filterOperationNotEquals": "Does not equal",
            "dxFilterBuilder-filterOperationLess": "Is less than",
            "dxFilterBuilder-filterOperationLessOrEquals": "Is less than or equal to",
            "dxFilterBuilder-filterOperationGreater": "Is greater than",
            "dxFilterBuilder-filterOperationGreaterOrEquals": "Is greater than or equal to",
            "dxFilterBuilder-filterOperationStartsWith": "\u041d\u0430\u0447\u0430\u043b\u043e \u0441",
            "dxFilterBuilder-filterOperationContains": "\u0421\u044a\u0434\u044a\u0440\u0436\u0430\u043d",
            "dxFilterBuilder-filterOperationNotContains": "Does not contain",
            "dxFilterBuilder-filterOperationEndsWith": "Ends with",
            "dxFilterBuilder-filterOperationIsBlank": "Is blank",
            "dxFilterBuilder-filterOperationIsNotBlank": "Is not blank",
            "dxFilterBuilder-filterOperationBetween": "Is between",
            "dxFilterBuilder-filterOperationAnyOf": "Is any of",
            "dxFilterBuilder-filterOperationNoneOf": "Is none of",
            "dxFilterBuilder-filterAriaRootElement": "Filter builder",
            "dxFilterBuilder-filterAriaGroupLevel": "Level {0}",
            "dxFilterBuilder-filterAriaGroupItem": "Group item",
            "dxFilterBuilder-filterAriaOperationButton": "\u0423\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u0435",
            "dxFilterBuilder-filterAriaAddButton": "\u0414\u043e\u0431\u0430\u0432\u044f\u043d\u0435",
            "dxFilterBuilder-filterAriaRemoveButton": "Remove {0}",
            "dxFilterBuilder-filterAriaItemField": "Item field",
            "dxFilterBuilder-filterAriaItemOperation": "Item operation",
            "dxFilterBuilder-filterAriaItemValue": "Item value",
            "dxHtmlEditor-dialogColorCaption": "Change Font Color",
            "dxHtmlEditor-dialogBackgroundCaption": "Change Background Color",
            "dxHtmlEditor-dialogLinkCaption": "Add Link",
            "dxHtmlEditor-dialogLinkUrlField": "URL",
            "dxHtmlEditor-dialogLinkTextField": "\u0422\u0435\u043a\u0441\u0442",
            "dxHtmlEditor-dialogLinkTargetField": "Open link in new window",
            "dxHtmlEditor-dialogImageCaption": "Add Image",
            "dxHtmlEditor-dialogImageUrlField": "URL",
            "dxHtmlEditor-dialogImageAltField": "Alternate text",
            "dxHtmlEditor-dialogImageWidthField": "Width (px)",
            "dxHtmlEditor-dialogImageHeightField": "Height (px)",
            "dxHtmlEditor-dialogInsertTableRowsField": "Rows",
            "dxHtmlEditor-dialogInsertTableColumnsField": "\u041a\u043e\u043b\u043e\u043d\u0438",
            "dxHtmlEditor-dialogInsertTableCaption": "Insert Table",
            "dxHtmlEditor-dialogUpdateImageCaption": "Update Image",
            "dxHtmlEditor-dialogImageUpdateButton": "\u041e\u0431\u043d\u043e\u0432\u044f\u0432\u0430\u043d\u0435",
            "dxHtmlEditor-dialogImageAddButton": "\u0414\u043e\u0431\u0430\u0432\u044f\u043d\u0435",
            "dxHtmlEditor-dialogImageSpecifyUrl": "From the Web",
            "dxHtmlEditor-dialogImageSelectFile": "From This Device",
            "dxHtmlEditor-dialogImageKeepAspectRatio": "Keep Aspect Ratio",
            "dxHtmlEditor-dialogImageEncodeToBase64": "Encode to Base64",
            "dxHtmlEditor-heading": "Heading",
            "dxHtmlEditor-normalText": "Normal text",
            "dxHtmlEditor-background": "Background Color",
            "dxHtmlEditor-bold": "\u0423\u0434\u0435\u0431\u0435\u043b\u0435\u043d \u0448\u0440\u0438\u0444\u0442",
            "dxHtmlEditor-color": "Font Color",
            "dxHtmlEditor-font": "\u0428\u0440\u0438\u0444\u0442",
            "dxHtmlEditor-italic": "\u041d\u0430\u043a\u043b\u043e\u043d\u0435\u043d \u0448\u0440\u0438\u0444\u0442",
            "dxHtmlEditor-link": "Add Link",
            "dxHtmlEditor-image": "Add Image",
            "dxHtmlEditor-size": "Size",
            "dxHtmlEditor-strike": "Strikethrough",
            "dxHtmlEditor-subscript": "Subscript",
            "dxHtmlEditor-superscript": "Superscript",
            "dxHtmlEditor-underline": "Underline",
            "dxHtmlEditor-blockquote": "Blockquote",
            "dxHtmlEditor-header": "\u0413\u043e\u0440\u0435\u043d \u043a\u043e\u043b\u043e\u043d\u0442\u0438\u0442\u0443\u043b",
            "dxHtmlEditor-increaseIndent": "Increase Indent",
            "dxHtmlEditor-decreaseIndent": "Decrease Indent",
            "dxHtmlEditor-orderedList": "Ordered List",
            "dxHtmlEditor-bulletList": "Bullet List",
            "dxHtmlEditor-alignLeft": "Align Left",
            "dxHtmlEditor-alignCenter": "Align Center",
            "dxHtmlEditor-alignRight": "Align Right",
            "dxHtmlEditor-alignJustify": "Align Justify",
            "dxHtmlEditor-codeBlock": "Code Block",
            "dxHtmlEditor-variable": "Add Variable",
            "dxHtmlEditor-undo": "\u041e\u0442\u043c\u044f\u043d\u0430",
            "dxHtmlEditor-redo": "Redo",
            "dxHtmlEditor-clear": "Clear Formatting",
            "dxHtmlEditor-insertTable": "Insert Table",
            "dxHtmlEditor-insertHeaderRow": "Insert Header Row",
            "dxHtmlEditor-insertRowAbove": "Insert Row Above",
            "dxHtmlEditor-insertRowBelow": "Insert Row Below",
            "dxHtmlEditor-insertColumnLeft": "Insert Column Left",
            "dxHtmlEditor-insertColumnRight": "Insert Column Right",
            "dxHtmlEditor-deleteColumn": "Delete Column",
            "dxHtmlEditor-deleteRow": "Delete Row",
            "dxHtmlEditor-deleteTable": "Delete Table",
            "dxHtmlEditor-cellProperties": "Cell Properties",
            "dxHtmlEditor-tableProperties": "Table Properties",
            "dxHtmlEditor-insert": "Insert",
            "dxHtmlEditor-delete": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxHtmlEditor-border": "Border",
            "dxHtmlEditor-style": "Style",
            "dxHtmlEditor-width": "\u0428\u0438\u0440\u0438\u043d\u0430",
            "dxHtmlEditor-height": "\u0412\u0438\u0441\u043e\u0447\u0438\u043d\u0430",
            "dxHtmlEditor-borderColor": "Color",
            "dxHtmlEditor-borderWidth": "Border Width",
            "dxHtmlEditor-tableBackground": "Background",
            "dxHtmlEditor-dimensions": "Dimensions",
            "dxHtmlEditor-alignment": "Alignment",
            "dxHtmlEditor-horizontal": "Horizontal",
            "dxHtmlEditor-vertical": "Vertical",
            "dxHtmlEditor-paddingVertical": "Vertical Padding",
            "dxHtmlEditor-paddingHorizontal": "Horizontal Padding",
            "dxHtmlEditor-pixels": "Pixels",
            "dxHtmlEditor-list": "List",
            "dxHtmlEditor-ordered": "Ordered",
            "dxHtmlEditor-bullet": "Bullet",
            "dxHtmlEditor-align": "Align",
            "dxHtmlEditor-center": "Center",
            "dxHtmlEditor-left": "\u041b\u044f\u0432\u043e",
            "dxHtmlEditor-right": "\u0414\u044f\u0441\u043d\u043e",
            "dxHtmlEditor-indent": "Indent",
            "dxHtmlEditor-justify": "Justify",
            "dxHtmlEditor-borderStyleNone": "\u0411\u0435\u0437",
            "dxHtmlEditor-borderStyleHidden": "hidden",
            "dxHtmlEditor-borderStyleDotted": "dotted",
            "dxHtmlEditor-borderStyleDashed": "dashed",
            "dxHtmlEditor-borderStyleSolid": "\u0422\u0432\u044a\u0440\u0434\u043e",
            "dxHtmlEditor-borderStyleDouble": "double",
            "dxHtmlEditor-borderStyleGroove": "groove",
            "dxHtmlEditor-borderStyleRidge": "ridge",
            "dxHtmlEditor-borderStyleInset": "inset",
            "dxHtmlEditor-borderStyleOutset": "outset",
            "dxHtmlEditor-aiDialogTitle": "AI Assistant",
            "dxHtmlEditor-aiDialogError": "Something went wrong. Please try again.",
            "dxHtmlEditor-aiDialogCanceled": "Generation canceled",
            "dxHtmlEditor-aiReplace": "Replace",
            "dxHtmlEditor-aiInsertAbove": "Insert above",
            "dxHtmlEditor-aiInsertBelow": "Insert below",
            "dxHtmlEditor-aiCopy": "Copy",
            "dxHtmlEditor-aiRegenerate": "Regenerate",
            "dxHtmlEditor-aiGenerate": "Generate",
            "dxHtmlEditor-aiCancel": "Cancel",
            "dxHtmlEditor-aiToolbarItemAriaLabel": "AI Assistant toolbar item",
            "dxHtmlEditor-aiResultTextAreaAriaLabel": "AI Assistant result",
            "dxHtmlEditor-aiAskPlaceholder": "Ask AI to modify text",
            "dxHtmlEditor-aiCommandSummarize": "Summarize",
            "dxHtmlEditor-aiCommandProofread": "Proofread",
            "dxHtmlEditor-aiCommandExpand": "Expand",
            "dxHtmlEditor-aiCommandShorten": "Shorten",
            "dxHtmlEditor-aiCommandChangeStyle": "Change Style",
            "dxHtmlEditor-aiCommandChangeTone": "Change Tone",
            "dxHtmlEditor-aiCommandTranslate": "Translate",
            "dxHtmlEditor-aiCommandAskAI": "Ask AI",
            "dxHtmlEditor-aiCommandChangeStyleFormal": "Formal",
            "dxHtmlEditor-aiCommandChangeStyleInformal": "Informal",
            "dxHtmlEditor-aiCommandChangeStyleTechnical": "Technical",
            "dxHtmlEditor-aiCommandChangeStyleBusiness": "Business",
            "dxHtmlEditor-aiCommandChangeStyleCreative": "Creative",
            "dxHtmlEditor-aiCommandChangeStyleJournalistic": "Journalistic",
            "dxHtmlEditor-aiCommandChangeStyleAcademic": "Academic",
            "dxHtmlEditor-aiCommandChangeStylePersuasive": "Persuasive",
            "dxHtmlEditor-aiCommandChangeStyleNarrative": "Narrative",
            "dxHtmlEditor-aiCommandChangeStyleExpository": "Expository",
            "dxHtmlEditor-aiCommandChangeStyleDescriptive": "Descriptive",
            "dxHtmlEditor-aiCommandChangeStyleConversational": "Conversational",
            "dxHtmlEditor-aiCommandChangeToneProfessional": "Professional",
            "dxHtmlEditor-aiCommandChangeToneCasual": "Casual",
            "dxHtmlEditor-aiCommandChangeToneStraightforward": "Straightforward",
            "dxHtmlEditor-aiCommandChangeToneConfident": "Confident",
            "dxHtmlEditor-aiCommandChangeToneFriendly": "Friendly",
            "dxHtmlEditor-aiCommandTranslateArabic": "Arabic",
            "dxHtmlEditor-aiCommandTranslateChinese": "Chinese",
            "dxHtmlEditor-aiCommandTranslateEnglish": "English",
            "dxHtmlEditor-aiCommandTranslateFrench": "French",
            "dxHtmlEditor-aiCommandTranslateGerman": "German",
            "dxHtmlEditor-aiCommandTranslateJapanese": "Japanese",
            "dxHtmlEditor-aiCommandTranslateSpanish": "Spanish",
            "dxFileManager-newDirectoryName": "Untitled directory",
            "dxFileManager-rootDirectoryName": "\u0424\u0430\u0439\u043b\u043e\u0432\u0435",
            "dxFileManager-errorNoAccess": "Access Denied. Operation could not be completed.",
            "dxFileManager-errorDirectoryExistsFormat": "Directory '{0}' already exists.",
            "dxFileManager-errorFileExistsFormat": "File '{0}' already exists.",
            "dxFileManager-errorFileNotFoundFormat": "File '{0}' not found.",
            "dxFileManager-errorDirectoryNotFoundFormat": "Directory '{0}' not found.",
            "dxFileManager-errorWrongFileExtension": "File extension is not allowed.",
            "dxFileManager-errorMaxFileSizeExceeded": "File size exceeds the maximum allowed size.",
            "dxFileManager-errorInvalidSymbols": "This name contains invalid characters.",
            "dxFileManager-errorDefault": "Unspecified error.",
            "dxFileManager-errorDirectoryOpenFailed": "The directory cannot be opened",
            "dxFileManager-commandCreate": "New directory",
            "dxFileManager-commandRename": "Rename",
            "dxFileManager-commandMove": "Move to",
            "dxFileManager-commandCopy": "\u041a\u043e\u043f\u0438\u0440\u0430\u043d\u0435 \u043a\u044a\u043c",
            "dxFileManager-commandDelete": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxFileManager-commandDownload": "\u0414\u0430\u0443\u043d\u043b\u043e\u0443\u0434",
            "dxFileManager-commandUpload": "Upload files",
            "dxFileManager-commandRefresh": "\u041e\u0431\u043d\u043e\u0432\u044f\u0432\u0430\u043d\u0435",
            "dxFileManager-commandThumbnails": "Thumbnails View",
            "dxFileManager-commandDetails": "Details View",
            "dxFileManager-commandClearSelection": "\u0418\u0437\u0447\u0438\u0441\u0442\u0432\u0430\u043d\u0435 \u043d\u0430 \u0438\u0437\u0431\u0440\u0430\u043d\u0438\u0442\u0435",
            "dxFileManager-commandShowNavPane": "Toggle navigation pane",
            "dxFileManager-dialogDirectoryChooserMoveTitle": "Move to",
            "dxFileManager-dialogDirectoryChooserMoveButtonText": "\u041f\u0440\u0435\u043c\u0435\u0441\u0442\u0432\u0430\u043d\u0435",
            "dxFileManager-dialogDirectoryChooserCopyTitle": "\u041a\u043e\u043f\u0438\u0440\u0430\u043d\u0435 \u043a\u044a\u043c",
            "dxFileManager-dialogDirectoryChooserCopyButtonText": "\u041a\u043e\u043f\u0438\u0440\u0430\u043d\u0435",
            "dxFileManager-dialogRenameItemTitle": "Rename",
            "dxFileManager-dialogRenameItemButtonText": "\u0417\u0430\u043f\u0430\u0437\u0432\u0430\u043d\u0435",
            "dxFileManager-dialogCreateDirectoryTitle": "New directory",
            "dxFileManager-dialogCreateDirectoryButtonText": "\u0421\u044a\u0437\u0434\u0430\u0432\u0430\u043d\u0435",
            "dxFileManager-dialogDeleteItemTitle": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxFileManager-dialogDeleteItemButtonText": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxFileManager-dialogDeleteItemSingleItemConfirmation": "Are you sure you want to delete {0}?",
            "dxFileManager-dialogDeleteItemMultipleItemsConfirmation": "Are you sure you want to delete {0} items?",
            "dxFileManager-dialogButtonCancel": "\u041e\u0442\u043a\u0430\u0437",
            "dxFileManager-editingCreateSingleItemProcessingMessage": "Creating a directory inside {0}",
            "dxFileManager-editingCreateSingleItemSuccessMessage": "Created a directory inside {0}",
            "dxFileManager-editingCreateSingleItemErrorMessage": "Directory was not created",
            "dxFileManager-editingCreateCommonErrorMessage": "Directory was not created",
            "dxFileManager-editingRenameSingleItemProcessingMessage": "Renaming an item inside {0}",
            "dxFileManager-editingRenameSingleItemSuccessMessage": "Renamed an item inside {0}",
            "dxFileManager-editingRenameSingleItemErrorMessage": "Item was not renamed",
            "dxFileManager-editingRenameCommonErrorMessage": "Item was not renamed",
            "dxFileManager-editingDeleteSingleItemProcessingMessage": "Deleting an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsProcessingMessage": "Deleting {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemSuccessMessage": "Deleted an item from {0}",
            "dxFileManager-editingDeleteMultipleItemsSuccessMessage": "Deleted {0} items from {1}",
            "dxFileManager-editingDeleteSingleItemErrorMessage": "Item was not deleted",
            "dxFileManager-editingDeleteMultipleItemsErrorMessage": "{0} items were not deleted",
            "dxFileManager-editingDeleteCommonErrorMessage": "Some items were not deleted",
            "dxFileManager-editingMoveSingleItemProcessingMessage": "Moving an item to {0}",
            "dxFileManager-editingMoveMultipleItemsProcessingMessage": "Moving {0} items to {1}",
            "dxFileManager-editingMoveSingleItemSuccessMessage": "Moved an item to {0}",
            "dxFileManager-editingMoveMultipleItemsSuccessMessage": "Moved {0} items to {1}",
            "dxFileManager-editingMoveSingleItemErrorMessage": "Item was not moved",
            "dxFileManager-editingMoveMultipleItemsErrorMessage": "{0} items were not moved",
            "dxFileManager-editingMoveCommonErrorMessage": "Some items were not moved",
            "dxFileManager-editingCopySingleItemProcessingMessage": "Copying an item to {0}",
            "dxFileManager-editingCopyMultipleItemsProcessingMessage": "Copying {0} items to {1}",
            "dxFileManager-editingCopySingleItemSuccessMessage": "Copied an item to {0}",
            "dxFileManager-editingCopyMultipleItemsSuccessMessage": "Copied {0} items to {1}",
            "dxFileManager-editingCopySingleItemErrorMessage": "Item was not copied",
            "dxFileManager-editingCopyMultipleItemsErrorMessage": "{0} items were not copied",
            "dxFileManager-editingCopyCommonErrorMessage": "Some items were not copied",
            "dxFileManager-editingUploadSingleItemProcessingMessage": "Uploading an item to {0}",
            "dxFileManager-editingUploadMultipleItemsProcessingMessage": "Uploading {0} items to {1}",
            "dxFileManager-editingUploadSingleItemSuccessMessage": "Uploaded an item to {0}",
            "dxFileManager-editingUploadMultipleItemsSuccessMessage": "Uploaded {0} items to {1}",
            "dxFileManager-editingUploadSingleItemErrorMessage": "Item was not uploaded",
            "dxFileManager-editingUploadMultipleItemsErrorMessage": "{0} items were not uploaded",
            "dxFileManager-editingUploadCanceledMessage": "Canceled",
            "dxFileManager-editingDownloadSingleItemErrorMessage": "Item was not downloaded",
            "dxFileManager-editingDownloadMultipleItemsErrorMessage": "{0} items were not downloaded",
            "dxFileManager-listDetailsColumnCaptionName": "\u0418\u043c\u0435",
            "dxFileManager-listDetailsColumnCaptionDateModified": "Date Modified",
            "dxFileManager-listDetailsColumnCaptionFileSize": "File Size",
            "dxFileManager-listThumbnailsTooltipTextSize": "Size",
            "dxFileManager-listThumbnailsTooltipTextDateModified": "Date Modified",
            "dxFileManager-notificationProgressPanelTitle": "Progress",
            "dxFileManager-notificationProgressPanelEmptyListText": "No operations",
            "dxFileManager-notificationProgressPanelOperationCanceled": "Canceled",
            "dxDiagram-categoryGeneral": "O\u0431\u0449",
            "dxDiagram-categoryFlowchart": "Flowchart",
            "dxDiagram-categoryOrgChart": "Org Chart",
            "dxDiagram-categoryContainers": "Containers",
            "dxDiagram-categoryCustom": "Custom",
            "dxDiagram-commandExportToSvg": "Export to SVG",
            "dxDiagram-commandExportToPng": "Export to PNG",
            "dxDiagram-commandExportToJpg": "Export to JPEG",
            "dxDiagram-commandUndo": "\u041e\u0442\u043c\u044f\u043d\u0430",
            "dxDiagram-commandRedo": "Redo",
            "dxDiagram-commandFontName": "Font Name",
            "dxDiagram-commandFontSize": "Font Size",
            "dxDiagram-commandBold": "\u0423\u0434\u0435\u0431\u0435\u043b\u0435\u043d \u0448\u0440\u0438\u0444\u0442",
            "dxDiagram-commandItalic": "\u041d\u0430\u043a\u043b\u043e\u043d\u0435\u043d \u0448\u0440\u0438\u0444\u0442",
            "dxDiagram-commandUnderline": "Underline",
            "dxDiagram-commandTextColor": "Font Color",
            "dxDiagram-commandLineColor": "Line Color",
            "dxDiagram-commandLineWidth": "Line Width",
            "dxDiagram-commandLineStyle": "Line Style",
            "dxDiagram-commandLineStyleSolid": "\u0422\u0432\u044a\u0440\u0434\u043e",
            "dxDiagram-commandLineStyleDotted": "Dotted",
            "dxDiagram-commandLineStyleDashed": "Dashed",
            "dxDiagram-commandFillColor": "Fill Color",
            "dxDiagram-commandAlignLeft": "Align Left",
            "dxDiagram-commandAlignCenter": "Align Center",
            "dxDiagram-commandAlignRight": "Align Right",
            "dxDiagram-commandConnectorLineType": "Connector Line Type",
            "dxDiagram-commandConnectorLineStraight": "Straight",
            "dxDiagram-commandConnectorLineOrthogonal": "Orthogonal",
            "dxDiagram-commandConnectorLineStart": "Connector Line Start",
            "dxDiagram-commandConnectorLineEnd": "Connector Line End",
            "dxDiagram-commandConnectorLineNone": "\u0411\u0435\u0437",
            "dxDiagram-commandConnectorLineArrow": "Arrow",
            "dxDiagram-commandFullscreen": "Full Screen",
            "dxDiagram-commandUnits": "\u0415\u0434\u0438\u043d\u0438\u0446\u0438",
            "dxDiagram-commandPageSize": "\u0420\u0430\u0437\u043c\u0435\u0440 \u043d\u0430 \u0441\u0442\u0440\u0430\u043d\u0438\u0446\u0430\u0442\u0430",
            "dxDiagram-commandPageOrientation": "Page Orientation",
            "dxDiagram-commandPageOrientationLandscape": "Landscape",
            "dxDiagram-commandPageOrientationPortrait": "Portrait",
            "dxDiagram-commandPageColor": "Page Color",
            "dxDiagram-commandShowGrid": "Show Grid",
            "dxDiagram-commandSnapToGrid": "Snap to Grid",
            "dxDiagram-commandGridSize": "Grid Size",
            "dxDiagram-commandZoomLevel": "Zoom Level",
            "dxDiagram-commandAutoZoom": "Auto Zoom",
            "dxDiagram-commandFitToContent": "Fit to Content",
            "dxDiagram-commandFitToWidth": "Fit to Width",
            "dxDiagram-commandAutoZoomByContent": "Auto Zoom by Content",
            "dxDiagram-commandAutoZoomByWidth": "Auto Zoom by Width",
            "dxDiagram-commandSimpleView": "Simple View",
            "dxDiagram-commandCut": "Cut",
            "dxDiagram-commandCopy": "\u041a\u043e\u043f\u0438\u0440\u0430\u043d\u0435",
            "dxDiagram-commandPaste": "\u041f\u043e\u0441\u0442\u0430\u0432\u044f\u043d\u0435",
            "dxDiagram-commandSelectAll": "\u0418\u0437\u0431\u0438\u0440\u0430\u043d\u0435 \u043d\u0430 \u0412\u0441\u0438\u0447\u043a\u0438",
            "dxDiagram-commandDelete": "\u0418\u0437\u0442\u0440\u0438\u0432\u0430\u043d\u0435",
            "dxDiagram-commandBringToFront": "Bring to Front",
            "dxDiagram-commandSendToBack": "Send to Back",
            "dxDiagram-commandLock": "\u0417\u0430\u043a\u043b\u044e\u0447\u0432\u0430\u043d\u0435",
            "dxDiagram-commandUnlock": "\u041e\u0442\u043a\u043b\u044e\u0447\u0432\u0430\u043d\u0435",
            "dxDiagram-commandInsertShapeImage": "Insert Image...",
            "dxDiagram-commandEditShapeImage": "Change Image...",
            "dxDiagram-commandDeleteShapeImage": "Delete Image",
            "dxDiagram-commandLayoutLeftToRight": "Left-to-right",
            "dxDiagram-commandLayoutRightToLeft": "Right-to-left",
            "dxDiagram-commandLayoutTopToBottom": "Top-to-bottom",
            "dxDiagram-commandLayoutBottomToTop": "Bottom-to-top",
            "dxDiagram-unitIn": "in",
            "dxDiagram-unitCm": "\u0441\u043c",
            "dxDiagram-unitPx": "px",
            "dxDiagram-dialogButtonOK": "\u041e\u041a",
            "dxDiagram-dialogButtonCancel": "\u041e\u0442\u043a\u0430\u0437",
            "dxDiagram-dialogInsertShapeImageTitle": "Insert Image",
            "dxDiagram-dialogEditShapeImageTitle": "Change Image",
            "dxDiagram-dialogEditShapeImageSelectButton": "Select image",
            "dxDiagram-dialogEditShapeImageLabelText": "or drop a file here",
            "dxDiagram-uiExport": "\u0418\u0437\u043d\u0430\u0441\u044f\u043d\u0435",
            "dxDiagram-uiProperties": "Properties",
            "dxDiagram-uiSettings": "\u041d\u0430\u0441\u0442\u0440\u043e\u0439\u043a\u0438",
            "dxDiagram-uiShowToolbox": "Show Toolbox",
            "dxDiagram-uiSearch": "\u0422\u044a\u0440\u0441\u0435\u043d\u0435",
            "dxDiagram-uiStyle": "Style",
            "dxDiagram-uiLayout": "Layout",
            "dxDiagram-uiLayoutTree": "Tree",
            "dxDiagram-uiLayoutLayered": "Layered",
            "dxDiagram-uiDiagram": "Diagram",
            "dxDiagram-uiText": "\u0422\u0435\u043a\u0441\u0442",
            "dxDiagram-uiObject": "Object",
            "dxDiagram-uiConnector": "Connector",
            "dxDiagram-uiPage": "\u0421\u0442\u0440\u0430\u043d\u0438\u0446\u0430",
            "dxDiagram-shapeText": "\u0422\u0435\u043a\u0441\u0442",
            "dxDiagram-shapeRectangle": "Rectangle",
            "dxDiagram-shapeEllipse": "Ellipse",
            "dxDiagram-shapeCross": "Cross",
            "dxDiagram-shapeTriangle": "Triangle",
            "dxDiagram-shapeDiamond": "Diamond",
            "dxDiagram-shapeHeart": "Heart",
            "dxDiagram-shapePentagon": "Pentagon",
            "dxDiagram-shapeHexagon": "Hexagon",
            "dxDiagram-shapeOctagon": "Octagon",
            "dxDiagram-shapeStar": "Star",
            "dxDiagram-shapeArrowLeft": "Left Arrow",
            "dxDiagram-shapeArrowUp": "Up Arrow",
            "dxDiagram-shapeArrowRight": "Right Arrow",
            "dxDiagram-shapeArrowDown": "Down Arrow",
            "dxDiagram-shapeArrowUpDown": "Up Down Arrow",
            "dxDiagram-shapeArrowLeftRight": "Left Right Arrow",
            "dxDiagram-shapeProcess": "Process",
            "dxDiagram-shapeDecision": "Decision",
            "dxDiagram-shapeTerminator": "Terminator",
            "dxDiagram-shapePredefinedProcess": "Predefined Process",
            "dxDiagram-shapeDocument": "\u0414\u043e\u043a\u0443\u043c\u0435\u043d\u0442",
            "dxDiagram-shapeMultipleDocuments": "Multiple Documents",
            "dxDiagram-shapeManualInput": "Manual Input",
            "dxDiagram-shapePreparation": "Preparation",
            "dxDiagram-shapeData": "\u0414\u0430\u043d\u043d\u0438",
            "dxDiagram-shapeDatabase": "Database",
            "dxDiagram-shapeHardDisk": "Hard Disk",
            "dxDiagram-shapeInternalStorage": "Internal Storage",
            "dxDiagram-shapePaperTape": "Paper Tape",
            "dxDiagram-shapeManualOperation": "Manual Operation",
            "dxDiagram-shapeDelay": "Delay",
            "dxDiagram-shapeStoredData": "Stored Data",
            "dxDiagram-shapeDisplay": "Display",
            "dxDiagram-shapeMerge": "\u0421\u043b\u0438\u0432\u0430\u043d\u0435",
            "dxDiagram-shapeConnector": "Connector",
            "dxDiagram-shapeOr": "\u0438\u043b\u0438",
            "dxDiagram-shapeSummingJunction": "Summing Junction",
            "dxDiagram-shapeContainerDefaultText": "Container",
            "dxDiagram-shapeVerticalContainer": "Vertical Container",
            "dxDiagram-shapeHorizontalContainer": "Horizontal Container",
            "dxDiagram-shapeCardDefaultText": "Person's Name",
            "dxDiagram-shapeCardWithImageOnLeft": "Card with Image on the Left",
            "dxDiagram-shapeCardWithImageOnTop": "Card with Image on the Top",
            "dxDiagram-shapeCardWithImageOnRight": "Card with Image on the Right",
            "dxGantt-dialogTitle": "\u041e\u0431\u0440\u044a\u0449\u0435\u043d\u0438\u0435",
            "dxGantt-dialogStartTitle": "Start",
            "dxGantt-dialogEndTitle": "End",
            "dxGantt-dialogProgressTitle": "Progress",
            "dxGantt-dialogResourcesTitle": "Resources",
            "dxGantt-dialogResourceManagerTitle": "Resource Manager",
            "dxGantt-dialogTaskDetailsTitle": "Task Details",
            "dxGantt-dialogEditResourceListHint": "Edit Resource List",
            "dxGantt-dialogEditNoResources": "No resources",
            "dxGantt-dialogButtonAdd": "\u0414\u043e\u0431\u0430\u0432\u044f\u043d\u0435",
            "dxGantt-contextMenuNewTask": "New Task",
            "dxGantt-contextMenuNewSubtask": "New Subtask",
            "dxGantt-contextMenuDeleteTask": "Delete Task",
            "dxGantt-contextMenuDeleteDependency": "Delete Dependency",
            "dxGantt-dialogTaskDeleteConfirmation": "Deleting a task also deletes all its dependencies and subtasks. Are you sure you want to delete this task?",
            "dxGantt-dialogDependencyDeleteConfirmation": "Are you sure you want to delete the dependency from the task?",
            "dxGantt-dialogResourcesDeleteConfirmation": "Deleting a resource also deletes it from tasks to which this resource is assigned. Are you sure you want to delete these resources? Resources: {0}",
            "dxGantt-dialogConstraintCriticalViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationMessage": "The task you are attempting to move is linked to a second task by a dependency relation. How would you like to proceed?",
            "dxGantt-dialogCancelOperationMessage": "Cancel the operation",
            "dxGantt-dialogDeleteDependencyMessage": "Delete the dependency",
            "dxGantt-dialogMoveTaskAndKeepDependencyMessage": "Move the task and keep the dependency",
            "dxGantt-dialogConstraintCriticalViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. This change would conflict with dependency rules. How would you like to proceed?",
            "dxGantt-dialogConstraintViolationSeveralTasksMessage": "The task you are attempting to move is linked to another tasks by dependency relations. How would you like to proceed?",
            "dxGantt-dialogDeleteDependenciesMessage": "Delete the dependency relations",
            "dxGantt-dialogMoveTaskAndKeepDependenciesMessage": "Move the task and keep the dependencies",
            "dxGantt-undo": "\u041e\u0442\u043c\u044f\u043d\u0430",
            "dxGantt-redo": "Redo",
            "dxGantt-expandAll": "\u041f\u043e\u043a\u0430\u0437\u0432\u0430\u043d\u0435 \u043d\u0430 \u0432\u0441\u0438\u0447\u043a\u043e",
            "dxGantt-collapseAll": "\u0421\u043a\u0440\u0438\u0432\u0430\u043d\u0435 \u043d\u0430 \u0432\u0441\u0438\u0447\u043a\u043e",
            "dxGantt-addNewTask": "Add New Task",
            "dxGantt-deleteSelectedTask": "Delete Selected Task",
            "dxGantt-zoomIn": "\u041f\u0440\u0438\u0431\u043b\u0438\u0436\u0430\u0432\u0430\u043d\u0435",
            "dxGantt-zoomOut": "\u041e\u0442\u0434\u0430\u043b\u0435\u0447\u0430\u0432\u0430\u043d\u0435",
            "dxGantt-fullScreen": "Full Screen",
            "dxGantt-quarter": "Q{0}",
            "dxGantt-sortingAscendingText": "Sort Ascending",
            "dxGantt-sortingDescendingText": "Sort Descending",
            "dxGantt-sortingClearText": "Clear Sorting",
            "dxGantt-showResources": "Show Resources",
            "dxGantt-showDependencies": "Show Dependencies",
            "dxGantt-dialogStartDateValidation": "Start date must be after {0}",
            "dxGantt-dialogEndDateValidation": "End date must be after {0}",
            "dxGallery-itemName": "Gallery item",
            "dxMultiView-elementAriaRoleDescription": "MultiView",
            "dxMultiView-elementAriaLabel": "Use the arrow keys or swipe to navigate between views",
            "dxMultiView-itemAriaRoleDescription": "\u0418\u0437\u0433\u043b\u0435\u0434",
            "dxMultiView-itemAriaLabel": "{0} of {1}",
            "dxSplitter-resizeHandleAriaLabel": "Split bar",
            "dxSplitter-resizeHandleAriaRoleDescription": "Separator",
            "dxStepper-optionalMark": "(Optional)",
            "dxSpeechToText-ariaLabelStart": "Press to start voice transcription",
            "dxSpeechToText-ariaLabelStop": "Press to stop voice transcription"
        }
    })
}));
