/*!
 * DevExtreme (dx.web.debug.js)
 * Version: 25.2.3
 * Build date: Mon Dec 15 2025
 *
 * Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
(() => {
    var __webpack_modules__ = {
        57:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/macro_task_array/methods.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.macroTaskArrayMap = exports.macroTaskArrayForEach = exports.DEFAULT_STEPS_VALUE = exports.DEFAULT_MACRO_TASK_TIMEOUT = void 0;
                var _dispatcher = (e = __webpack_require__( /*! ./dispatcher */ 8710), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const DEFAULT_STEPS_VALUE = exports.DEFAULT_STEPS_VALUE = 100;
                const DEFAULT_MACRO_TASK_TIMEOUT = exports.DEFAULT_MACRO_TASK_TIMEOUT = 0;
                const macroTaskArrayForEach = async function(array, callback) {
                    let step = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : DEFAULT_STEPS_VALUE;
                    let macroTaskTimeoutMs = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : DEFAULT_MACRO_TASK_TIMEOUT;
                    const promises = [];
                    const batchesCount = Math.ceil(array.length / step);
                    for (let batchIdx = 0; batchIdx < batchesCount; batchIdx += 1) {
                        const scheduledTask = _dispatcher.default.schedule((() => {
                            const startIdx = batchIdx * step;
                            const maxIdx = startIdx + step;
                            for (let idx = startIdx; idx < maxIdx && void 0 !== array[idx]; idx += 1) {
                                callback(array[idx])
                            }
                        }), macroTaskTimeoutMs);
                        promises.push(scheduledTask)
                    }
                    await Promise.all(promises)
                };
                exports.macroTaskArrayForEach = macroTaskArrayForEach;
                exports.macroTaskArrayMap = async function(array, callback) {
                    let step = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : DEFAULT_STEPS_VALUE;
                    let macroTaskTimeoutMs = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : DEFAULT_MACRO_TASK_TIMEOUT;
                    const result = [];
                    await macroTaskArrayForEach(array, (item => {
                        result.push(callback(item))
                    }), step, macroTaskTimeoutMs);
                    return result
                }
            },
        87:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/radio_group/m_radio_collection.js ***!
              \*********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/editor/ui.data_expression */ 7632));
                var _collection_widget = _interopRequireDefault(__webpack_require__( /*! ../../ui/collection/collection_widget.edit */ 79839));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class RadioCollection extends _collection_widget.default {
                    _focusTarget() {
                        return (0, _renderer.default)(this.element()).parent()
                    }
                    _nullValueSelectionSupported() {
                        return true
                    }
                    _getDefaultOptions() {
                        const defaultOptions = super._getDefaultOptions();
                        return (0, _extend.extend)(defaultOptions, _ui.default._dataExpressionDefaultOptions(), {
                            _itemAttributes: {
                                role: "radio"
                            }
                        })
                    }
                    _initMarkup() {
                        super._initMarkup();
                        (0, _common.deferRender)((() => {
                            this._itemElements().addClass("dx-radiobutton")
                        }))
                    }
                    _keyboardEventBindingTarget() {
                        return this._focusTarget()
                    }
                    _postprocessRenderItem(args) {
                        const {
                            itemData: {
                                html: html
                            },
                            itemElement: itemElement
                        } = args;
                        if (!html) {
                            const $radio = (0, _renderer.default)("<div>").addClass("dx-radiobutton-icon");
                            (0, _renderer.default)("<div>").addClass("dx-radiobutton-icon-dot").appendTo($radio);
                            const $radioContainer = (0, _renderer.default)("<div>").append($radio).addClass("dx-radio-value-container");
                            (0, _renderer.default)(itemElement).prepend($radioContainer)
                        }
                        super._postprocessRenderItem(args)
                    }
                    _processSelectableItem($itemElement, isSelected) {
                        super._processSelectableItem($itemElement, isSelected);
                        $itemElement.toggleClass("dx-radiobutton-checked", isSelected).find(".dx-radiobutton-icon").first().toggleClass("dx-radiobutton-icon-checked", isSelected);
                        this.setAria("checked", isSelected, $itemElement)
                    }
                    _refreshContent() {
                        this._prepareContent();
                        this._renderContent()
                    }
                    _supportedKeys() {
                        const parent = super._supportedKeys();
                        return (0, _extend.extend)({}, parent, {
                            enter(e) {
                                e.preventDefault();
                                return parent.enter.apply(this, arguments)
                            },
                            space(e) {
                                e.preventDefault();
                                return parent.space.apply(this, arguments)
                            }
                        })
                    }
                    _itemElements() {
                        return this._itemContainer().children(this._itemSelector())
                    }
                    _setAriaSelectionAttribute() {}
                }
                exports.default = RadioCollection
            },
        174:
            /*!***************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/date_box/m_date_box.mask.js ***!
              \***************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/events/core/events_engine */ 92774));
                var _index = __webpack_require__( /*! ../../../common/core/events/utils/index */ 98834);
                var _default_date_names = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/localization/default_date_names */ 81179));
                var _date = __webpack_require__( /*! ../../../common/core/localization/ldml/date.format */ 83445);
                var _date2 = __webpack_require__( /*! ../../../common/core/localization/ldml/date.parser */ 46981);
                var _number = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/localization/number */ 52771));
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 65951));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/browser */ 48314));
                var _dom = __webpack_require__( /*! ../../../core/utils/dom */ 86858);
                var _math = __webpack_require__( /*! ../../../core/utils/math */ 50254);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _date3 = _interopRequireDefault(__webpack_require__( /*! ../../core/localization/date */ 45508));
                var _m_date_box = _interopRequireDefault(__webpack_require__( /*! ./m_date_box.base */ 10291));
                var _m_date_boxMask = __webpack_require__( /*! ./m_date_box.mask.parts */ 18674);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class DateBoxMask extends _m_date_box.default {
                    _supportedKeys() {
                        const originalHandlers = super._supportedKeys();
                        const callOriginalHandler = e => {
                            const originalHandler = originalHandlers[(0, _index.normalizeKeyName)(e)];
                            return null === originalHandler || void 0 === originalHandler ? void 0 : originalHandler.apply(this, [e])
                        };
                        const applyHandler = (e, maskHandler) => {
                            if (this._shouldUseOriginalHandler(e)) {
                                return callOriginalHandler.apply(this, [e])
                            }
                            return maskHandler.apply(this, [e])
                        };
                        return Object.assign({}, originalHandlers, {
                            del: e => applyHandler(e, (event => {
                                this._revertPart(1);
                                this._isAllSelected() || event.preventDefault()
                            })),
                            backspace: e => applyHandler(e, (event => {
                                this._revertPart(-1);
                                this._isAllSelected() || event.preventDefault()
                            })),
                            home: e => applyHandler(e, (event => {
                                this._selectFirstPart();
                                event.preventDefault()
                            })),
                            end: e => applyHandler(e, (event => {
                                this._selectLastPart();
                                event.preventDefault()
                            })),
                            escape: e => applyHandler(e, (() => {
                                this._revertChanges()
                            })),
                            enter: e => applyHandler(e, (() => {
                                this._enterHandler()
                            })),
                            leftArrow: e => applyHandler(e, (event => {
                                this._selectNextPart(-1);
                                event.preventDefault()
                            })),
                            rightArrow: e => applyHandler(e, (event => {
                                this._selectNextPart(1);
                                event.preventDefault()
                            })),
                            upArrow: e => applyHandler(e, (event => {
                                this._upDownArrowHandler(1);
                                event.preventDefault()
                            })),
                            downArrow: e => applyHandler(e, (event => {
                                this._upDownArrowHandler(-1);
                                event.preventDefault()
                            }))
                        })
                    }
                    _shouldUseOriginalHandler(e) {
                        const isNotDeletingInCalendar = this.option("opened") && e && !["backspace", "del"].includes((0, _index.normalizeKeyName)(e));
                        return !this._useMaskBehavior() || isNotDeletingInCalendar || e && e.altKey
                    }
                    _upDownArrowHandler(step) {
                        this._setNewDateIfEmpty();
                        const originalValue = this._getActivePartValue(this._initialMaskValue);
                        const currentValue = this._getActivePartValue();
                        const delta = currentValue - originalValue;
                        this._loadMaskValue(this._initialMaskValue);
                        this._changePartValue(delta + step, true)
                    }
                    _changePartValue(step, lockOtherParts) {
                        const activePartPattern = this._getActivePartProp("pattern");
                        const isAmPmPartActive = /^a{1,5}$/.test(activePartPattern);
                        if (isAmPmPartActive) {
                            this._toggleAmPm()
                        } else {
                            this._partIncrease(step, lockOtherParts)
                        }
                    }
                    _toggleAmPm() {
                        const currentValue = this._getActivePartProp("text");
                        const indexOfCurrentValue = _default_date_names.default.getPeriodNames().indexOf(currentValue);
                        const newValue = 1 ^ indexOfCurrentValue;
                        this._setActivePartValue(newValue)
                    }
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            useMaskBehavior: false,
                            emptyDateValue: new Date(2e3, 0, 1, 0, 0, 0)
                        })
                    }
                    _isSingleCharKey(_ref) {
                        let {
                            originalEvent: originalEvent,
                            alt: alt
                        } = _ref;
                        const key = originalEvent.data || originalEvent.key;
                        return "string" === typeof key && 1 === key.length && !alt && !(0, _index.isCommandKeyPressed)(originalEvent)
                    }
                    _isSingleDigitKey(e) {
                        var _e$originalEvent;
                        const data = null === (_e$originalEvent = e.originalEvent) || void 0 === _e$originalEvent ? void 0 : _e$originalEvent.data;
                        return 1 === (null === data || void 0 === data ? void 0 : data.length) && parseInt(data, 10)
                    }
                    _useBeforeInputEvent() {
                        return _devices.default.real().android
                    }
                    _keyInputHandler(e, key) {
                        const oldInputValue = this._input().val();
                        this._processInputKey(key);
                        e.preventDefault();
                        const isValueChanged = oldInputValue !== this._input().val();
                        isValueChanged && _events_engine.default.trigger(this._input(), "input")
                    }
                    _keyboardHandler(e) {
                        let {
                            key: key
                        } = e.originalEvent;
                        const result = super._keyboardHandler(e);
                        if (!this._useMaskBehavior() || this._useBeforeInputEvent()) {
                            return result
                        }
                        if (_browser.default.chrome && "Process" === e.key && 0 === e.code.indexOf("Digit")) {
                            key = e.code.replace("Digit", "");
                            this._processInputKey(key);
                            this._maskInputHandler = () => {
                                this._renderSelectedPart()
                            }
                        } else if (this._isSingleCharKey(e)) {
                            this._keyInputHandler(e.originalEvent, key)
                        }
                        return result
                    }
                    _maskBeforeInputHandler(e) {
                        this._maskInputHandler = null;
                        const {
                            inputType: inputType
                        } = e.originalEvent;
                        if ("insertCompositionText" === inputType) {
                            this._maskInputHandler = () => {
                                this._renderSelectedPart()
                            }
                        }
                        const isBackwardDeletion = "deleteContentBackward" === inputType;
                        const isForwardDeletion = "deleteContentForward" === inputType;
                        if (isBackwardDeletion || isForwardDeletion) {
                            const direction = isBackwardDeletion ? -1 : 1;
                            this._maskInputHandler = () => {
                                this._revertPart();
                                this._selectNextPart(direction)
                            }
                        }
                        if (!this._useMaskBehavior() || !this._isSingleCharKey(e)) {
                            return
                        }
                        const key = e.originalEvent.data;
                        this._keyInputHandler(e, key);
                        return true
                    }
                    _keyPressHandler(e) {
                        const {
                            originalEvent: event
                        } = e;
                        if ("insertCompositionText" === (null === event || void 0 === event ? void 0 : event.inputType) && this._isSingleDigitKey(e)) {
                            this._processInputKey(event.data);
                            this._renderDisplayText(this._getDisplayedText(this._maskValue));
                            this._selectNextPart()
                        }
                        super._keyPressHandler(e);
                        if (this._maskInputHandler) {
                            this._maskInputHandler();
                            this._maskInputHandler = null
                        }
                    }
                    _processInputKey(key) {
                        var _this$_dateParts;
                        const hasMultipleParts = (null === (_this$_dateParts = this._dateParts) || void 0 === _this$_dateParts ? void 0 : _this$_dateParts.length) > 1;
                        if (this._isAllSelected() && hasMultipleParts) {
                            this._activePartIndex = 0;
                            this._clearSearchValue()
                        }
                        this._setNewDateIfEmpty();
                        if (isNaN(parseInt(key))) {
                            this._searchString(key)
                        } else {
                            this._searchNumber(key)
                        }
                    }
                    _isAllSelected() {
                        const caret = this._caret();
                        const {
                            text: text
                        } = this.option();
                        return caret.end - caret.start === text.length
                    }
                    _getFormatPattern() {
                        if (this._formatPattern) {
                            return this._formatPattern
                        }
                        const format = this._strategy.getDisplayFormat(this.option("displayFormat"));
                        const isLDMLPattern = (0, _type.isString)(format) && !_date3.default._getPatternByFormat(format);
                        if (isLDMLPattern) {
                            this._formatPattern = format
                        } else {
                            this._formatPattern = (0, _date.getFormat)((value => _date3.default.format(value, format)))
                        }
                        return this._formatPattern
                    }
                    _setNewDateIfEmpty() {
                        if (!this._maskValue) {
                            const {
                                type: type
                            } = this.option();
                            const value = "time" === type ? new Date(null) : new Date;
                            this._maskValue = value;
                            this._initialMaskValue = value;
                            this._renderDateParts()
                        }
                    }
                    _partLimitsReached(max) {
                        const maxLimitLength = String(max).length;
                        const formatLength = this._getActivePartProp("pattern").length;
                        const isShortFormat = 1 === formatLength;
                        const maxSearchLength = isShortFormat ? maxLimitLength : Math.min(formatLength, maxLimitLength);
                        const isLengthExceeded = this._searchValue.length === maxSearchLength;
                        const isValueOverflowed = parseInt(`${this._searchValue}0`) > max;
                        return isLengthExceeded || isValueOverflowed
                    }
                    _searchNumber(char) {
                        const {
                            max: max
                        } = this._getActivePartLimits();
                        const maxLimitLength = String(max).length;
                        this._searchValue = (this._searchValue + char).substr(-maxLimitLength);
                        if (isNaN(this._searchValue)) {
                            this._searchValue = char
                        }
                        this._setActivePartValue(this._searchValue);
                        if (this._partLimitsReached(max)) {
                            this._selectNextPart(1)
                        }
                    }
                    _searchString(char) {
                        const text = this._getActivePartProp("text");
                        const convertedText = _number.default.convertDigits(text, true);
                        if (!isNaN(parseInt(convertedText, 10))) {
                            return
                        }
                        const limits = this._getActivePartProp("limits")(this._maskValue);
                        const startString = this._searchValue + char.toLowerCase();
                        const endLimit = limits.max - limits.min;
                        for (let i = 0; i <= endLimit; i++) {
                            this._loadMaskValue(this._initialMaskValue);
                            this._changePartValue(i + 1);
                            if (0 === this._getActivePartProp("text").toLowerCase().indexOf(startString)) {
                                this._searchValue = startString;
                                return
                            }
                        }
                        this._setNewDateIfEmpty();
                        if (this._searchValue) {
                            this._clearSearchValue();
                            this._searchString(char)
                        }
                    }
                    _clearSearchValue() {
                        this._searchValue = ""
                    }
                    _revertPart(direction) {
                        if (!this._isAllSelected()) {
                            const actual = this._getActivePartValue(this.option("emptyDateValue"));
                            this._setActivePartValue(actual);
                            this._selectNextPart(direction)
                        }
                        this._clearSearchValue()
                    }
                    _useMaskBehavior() {
                        const {
                            mode: mode
                        } = this.option();
                        return this.option("useMaskBehavior") && "text" === mode
                    }
                    _prepareRegExpInfo() {
                        this._regExpInfo = (0, _date2.getRegExpInfo)(this._getFormatPattern(), _date3.default);
                        const {
                            regexp: regexp
                        } = this._regExpInfo;
                        const {
                            source: source
                        } = regexp;
                        const {
                            flags: flags
                        } = regexp;
                        const quantifierRegexp = new RegExp(/(\{[0-9]+,?[0-9]*\})/);
                        const convertedSource = source.split(quantifierRegexp).map((sourcePart => quantifierRegexp.test(sourcePart) ? sourcePart : _number.default.convertDigits(sourcePart, false))).join("");
                        this._regExpInfo.regexp = new RegExp(convertedSource, flags)
                    }
                    _initMaskState() {
                        this._activePartIndex = 0;
                        this._formatPattern = null;
                        this._prepareRegExpInfo();
                        this._loadMaskValue()
                    }
                    _renderMask() {
                        super._renderMask();
                        this._detachMaskEvents();
                        this._clearMaskState();
                        if (this._useMaskBehavior()) {
                            this._attachMaskEvents();
                            this._initMaskState();
                            this._renderDateParts()
                        }
                    }
                    _renderDateParts() {
                        if (!this._useMaskBehavior()) {
                            return
                        }
                        const text = this.option("text") || this._getDisplayedText(this._maskValue);
                        if (text) {
                            this._dateParts = (0, _m_date_boxMask.renderDateParts)(text, this._regExpInfo);
                            if (!this._input().is(":hidden")) {
                                this._selectNextPart()
                            }
                        }
                    }
                    _detachMaskEvents() {
                        _events_engine.default.off(this._input(), ".dateBoxMask")
                    }
                    _attachMaskEvents() {
                        _events_engine.default.on(this._input(), (0, _index.addNamespace)("dxclick", "dateBoxMask"), this._maskClickHandler.bind(this));
                        _events_engine.default.on(this._input(), (0, _index.addNamespace)("paste", "dateBoxMask"), this._maskPasteHandler.bind(this));
                        _events_engine.default.on(this._input(), (0, _index.addNamespace)("drop", "dateBoxMask"), (() => {
                            this._renderSelectedPart()
                        }));
                        _events_engine.default.on(this._input(), (0, _index.addNamespace)("compositionend", "dateBoxMask"), this._maskCompositionEndHandler.bind(this));
                        if (this._useBeforeInputEvent()) {
                            _events_engine.default.on(this._input(), (0, _index.addNamespace)("beforeinput", "dateBoxMask"), this._maskBeforeInputHandler.bind(this))
                        }
                    }
                    _renderSelectedPart() {
                        this._renderDisplayText(this._getDisplayedText(this._maskValue));
                        this._selectNextPart()
                    }
                    _selectLastPart() {
                        if (this.option("text")) {
                            this._activePartIndex = this._dateParts.length;
                            this._selectNextPart(-1)
                        }
                    }
                    _selectFirstPart() {
                        if (this.option("text") && this._dateParts) {
                            this._activePartIndex = -1;
                            this._selectNextPart(1)
                        }
                    }
                    _hasMouseWheelHandler() {
                        return true
                    }
                    _onMouseWheel(e) {
                        if (this._useMaskBehavior()) {
                            this._partIncrease(e.delta > 0 ? 1 : -1, e)
                        }
                    }
                    _selectNextPart() {
                        let step = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : 0;
                        if (!this.option("text") || this._disposed) {
                            return
                        }
                        if (step) {
                            this._initialMaskValue = new Date(this._maskValue)
                        }
                        let index = (0, _math.fitIntoRange)(this._activePartIndex + step, 0, this._dateParts.length - 1);
                        if (this._dateParts[index].isStub) {
                            const isBoundaryIndex = 0 === index && step < 0 || index === this._dateParts.length - 1 && step > 0;
                            if (!isBoundaryIndex) {
                                this._selectNextPart(step >= 0 ? step + 1 : step - 1);
                                return
                            }
                            index = this._activePartIndex
                        }
                        if (this._activePartIndex !== index) {
                            this._clearSearchValue()
                        }
                        this._activePartIndex = index;
                        this._caret(this._getActivePartProp("caret"))
                    }
                    _getRealLimitsPattern() {
                        if ("d" === this._getActivePartProp("pattern")[0]) {
                            return "dM"
                        }
                    }
                    _getActivePartLimits(lockOtherParts) {
                        const limitFunction = this._getActivePartProp("limits");
                        return limitFunction(this._maskValue, lockOtherParts && this._getRealLimitsPattern())
                    }
                    _getActivePartValue(dateValue) {
                        dateValue = dateValue || this._maskValue;
                        const getter = this._getActivePartProp("getter");
                        return (0, _type.isFunction)(getter) ? getter(dateValue) : dateValue[getter]()
                    }
                    _addLeadingZeroes(value) {
                        const zeroes = /^0+/.exec(this._searchValue);
                        const limits = this._getActivePartLimits();
                        const maxLimitLength = String(limits.max).length;
                        return ((zeroes && zeroes[0] || "") + String(value)).substr(-maxLimitLength)
                    }
                    _setActivePartValue(value, dateValue) {
                        dateValue = dateValue || this._maskValue;
                        const setter = this._getActivePartProp("setter");
                        const limits = this._getActivePartLimits();
                        value = (0, _math.inRange)(value, limits.min, limits.max) ? value : value % 10;
                        value = this._addLeadingZeroes((0, _math.fitIntoRange)(value, limits.min, limits.max));
                        (0, _type.isFunction)(setter) ? setter(dateValue, value): dateValue[setter](value);
                        this._renderDisplayText(this._getDisplayedText(dateValue));
                        this._renderDateParts()
                    }
                    _getActivePartProp(property) {
                        if (!this._dateParts || !this._dateParts[this._activePartIndex]) {
                            return
                        }
                        return this._dateParts[this._activePartIndex][property]
                    }
                    _loadMaskValue() {
                        let value = arguments.length > 0 && void 0 !== arguments[0] ? arguments[0] : this.dateOption("value");
                        this._maskValue = value && new Date(value);
                        this._initialMaskValue = value && new Date(value)
                    }
                    _saveMaskValue() {
                        const value = this._maskValue && new Date(this._maskValue);
                        const {
                            type: type
                        } = this.option();
                        if (value && "date" === type) {
                            value.setHours(0, 0, 0, 0)
                        }
                        this._initialMaskValue = new Date(value);
                        if (this._applyInternalValidation(value).isValid) {
                            this.dateOption("value", value)
                        }
                    }
                    _revertChanges() {
                        this._loadMaskValue();
                        this._renderDisplayText(this._getDisplayedText(this._maskValue));
                        this._renderDateParts()
                    }
                    _renderDisplayText(text) {
                        super._renderDisplayText(text);
                        if (this._useMaskBehavior()) {
                            this.option("text", text)
                        }
                    }
                    _partIncrease(step, lockOtherParts) {
                        this._setNewDateIfEmpty();
                        const {
                            max: max,
                            min: min
                        } = this._getActivePartLimits(lockOtherParts);
                        let newValue = step + this._getActivePartValue();
                        if (newValue > max) {
                            newValue = this._applyLimits(newValue, {
                                limitBase: min,
                                limitClosest: max,
                                max: max
                            })
                        } else if (newValue < min) {
                            newValue = this._applyLimits(newValue, {
                                limitBase: max,
                                limitClosest: min,
                                max: max
                            })
                        }
                        this._setActivePartValue(newValue)
                    }
                    _applyLimits(newValue, _ref2) {
                        let {
                            limitBase: limitBase,
                            limitClosest: limitClosest,
                            max: max
                        } = _ref2;
                        const delta = (newValue - limitClosest) % max;
                        return delta ? limitBase + delta - 1 * (0, _math.sign)(delta) : limitClosest
                    }
                    _maskClickHandler() {
                        this._loadMaskValue(this._maskValue);
                        if (this.option("text")) {
                            this._activePartIndex = (0, _m_date_boxMask.getDatePartIndexByPosition)(this._dateParts, this._caret().start);
                            if (!this._isAllSelected()) {
                                this._clearSearchValue();
                                if ((0, _type.isDefined)(this._activePartIndex)) {
                                    this._caret(this._getActivePartProp("caret"))
                                } else {
                                    this._selectLastPart()
                                }
                            }
                        }
                    }
                    _maskCompositionEndHandler(e) {
                        this._input().val(this._getDisplayedText(this._maskValue));
                        this._selectNextPart();
                        this._maskInputHandler = () => {
                            this._renderSelectedPart()
                        }
                    }
                    _maskPasteHandler(e) {
                        const newText = this._replaceSelectedText(this.option("text"), this._caret(), (0, _dom.clipboardText)(e));
                        const date = _date3.default.parse(newText, this._getFormatPattern());
                        if (date && this._isDateValid(date)) {
                            this._maskValue = date;
                            this._renderDisplayText(this._getDisplayedText(this._maskValue));
                            this._renderDateParts();
                            this._selectNextPart()
                        }
                        e.preventDefault()
                    }
                    _isDateValid(date) {
                        return (0, _type.isDate)(date) && !isNaN(date)
                    }
                    _isValueDirty() {
                        const value = this.dateOption("value");
                        return (this._maskValue && this._maskValue.getTime()) !== (value && value.getTime())
                    }
                    _fireChangeEvent() {
                        this._clearSearchValue();
                        if (this._isValueDirty()) {
                            _events_engine.default.trigger(this._input(), "change")
                        }
                    }
                    _enterHandler() {
                        this._fireChangeEvent();
                        this._selectNextPart(1)
                    }
                    _focusOutHandler(e) {
                        const shouldFireChangeEvent = this._useMaskBehavior() && !e.isDefaultPrevented();
                        if (shouldFireChangeEvent) {
                            this._fireChangeEvent();
                            super._focusOutHandler(e);
                            this._selectFirstPart()
                        } else {
                            super._focusOutHandler(e)
                        }
                    }
                    _valueChangeEventHandler(e) {
                        const text = this.option("text");
                        if (this._useMaskBehavior()) {
                            this._saveValueChangeEvent(e);
                            if (!text) {
                                this._maskValue = null
                            } else if (null === this._maskValue) {
                                this._loadMaskValue(text)
                            }
                            this._saveMaskValue()
                        } else {
                            super._valueChangeEventHandler(e)
                        }
                    }
                    _optionChanged(args) {
                        switch (args.name) {
                            case "useMaskBehavior":
                                this._renderMask();
                                break;
                            case "displayFormat":
                            case "mode":
                                super._optionChanged(args);
                                this._renderMask();
                                break;
                            case "value":
                                this._loadMaskValue();
                                super._optionChanged(args);
                                this._renderDateParts();
                                break;
                            case "emptyDateValue":
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                    _clearMaskState() {
                        this._clearSearchValue();
                        delete this._dateParts;
                        delete this._activePartIndex;
                        delete this._maskValue
                    }
                    clear() {
                        this._clearMaskState();
                        this._activePartIndex = 0;
                        super.clear()
                    }
                    _clean() {
                        super._clean();
                        this._detachMaskEvents();
                        this._clearMaskState()
                    }
                }
                exports.default = DateBoxMask
            },
        198:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/appointments/appointment/m_appointment.js ***!
              \************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Appointment = void 0;
                var _translator = __webpack_require__( /*! ../../../../common/core/animation/translator */ 88603);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/core/events_engine */ 92774));
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/pointer */ 89797));
                var _index = __webpack_require__( /*! ../../../../common/core/events/utils/index */ 98834);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../../core/component_registrator */ 92848));
                var _dom_component = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_component */ 97832));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../../core/guid */ 19427));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 64553));
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _resizable = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/resizable */ 28416));
                var _m_tooltip = __webpack_require__( /*! ../../../ui/tooltip/m_tooltip */ 33476);
                var _m_classes = __webpack_require__( /*! ../../m_classes */ 80126);
                var _validate_rule = __webpack_require__( /*! ../../recurrence/validate_rule */ 25152);
                var _text_utils = __webpack_require__( /*! ./text_utils */ 46942);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const REDUCED_APPOINTMENT_POINTERENTER_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.enter, "dxSchedulerAppointment");
                const REDUCED_APPOINTMENT_POINTERLEAVE_EVENT_NAME = (0, _index.addNamespace)(_pointer.default.leave, "dxSchedulerAppointment");
                class Appointment extends _dom_component.default {
                    get coloredElement() {
                        return this.$element()
                    }
                    get rawAppointment() {
                        return this.option("data")
                    }
                    get dataAccessors() {
                        return this.option("dataAccessors")
                    }
                    _getDefaultOptions() {
                        return (0, _extend.extend)(super._getDefaultOptions(), {
                            data: {},
                            groupIndex: -1,
                            groups: [],
                            geometry: {
                                top: 0,
                                left: 0,
                                width: 0,
                                height: 0
                            },
                            allowDrag: true,
                            allowResize: true,
                            reduced: null,
                            isCompact: false,
                            direction: "vertical",
                            resizableConfig: {
                                keepAspectRatio: false
                            },
                            cellHeight: 0,
                            cellWidth: 0,
                            isDragSource: false
                        })
                    }
                    notifyObserver(funcName, args) {
                        this.invoke(funcName, ...args)
                    }
                    invoke(funcName) {
                        const notifyScheduler = this.option("notifyScheduler");
                        if (!notifyScheduler) {
                            return
                        }
                        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                            args[_key - 1] = arguments[_key]
                        }
                        return notifyScheduler.invoke(funcName, ...args)
                    }
                    _optionChanged(args) {
                        switch (args.name) {
                            case "data":
                            case "groupIndex":
                            case "groupTexts":
                            case "geometry":
                            case "allowDrag":
                            case "allowResize":
                            case "reduced":
                            case "sortedIndex":
                            case "isCompact":
                            case "direction":
                            case "resizableConfig":
                            case "cellHeight":
                            case "cellWidth":
                                this._invalidate();
                                break;
                            case "isDragSource":
                                this._renderDragSourceClass();
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                    _getHorizontalResizingRule() {
                        const reducedHandles = {
                            head: this.option("rtlEnabled") ? "right" : "left",
                            body: "",
                            tail: this.option("rtlEnabled") ? "left" : "right"
                        };
                        const getResizableStep = this.option("getResizableStep");
                        const step = getResizableStep ? getResizableStep() : 0;
                        return {
                            handles: this.option("reduced") ? reducedHandles[this.option("reduced")] : "left right",
                            minHeight: 0,
                            minWidth: this.invoke("getCellWidth"),
                            step: step,
                            roundStepValue: false
                        }
                    }
                    _getVerticalResizingRule() {
                        const height = Math.round(this.invoke("getCellHeight"));
                        return {
                            handles: "top bottom",
                            minWidth: 0,
                            minHeight: height,
                            step: height,
                            roundStepValue: true
                        }
                    }
                    _render() {
                        super._render();
                        this._renderAppointmentGeometry();
                        this._renderAriaLabel();
                        this._renderEmptyClass();
                        this._renderReducedAppointment();
                        this._renderAllDayClass();
                        this._renderDragSourceClass();
                        this._renderDirection();
                        this.$element().data("dxAppointmentStartDate", this.option("startDate"));
                        this.$element().attr("role", "button");
                        this._renderRecurrenceClass();
                        this._renderResizable();
                        this._setResourceColor()
                    }
                    _setResourceColor() {
                        const appointmentConfig = {
                            itemData: this.rawAppointment,
                            groupIndex: this.option("groupIndex") ?? 0
                        };
                        const resourceManager = this.option("getResourceManager")();
                        resourceManager.getAppointmentColor(appointmentConfig).then((color => {
                            if (color) {
                                this.coloredElement.css("backgroundColor", color);
                                this.coloredElement.addClass(_m_classes.APPOINTMENT_HAS_RESOURCE_COLOR_CLASS)
                            }
                        }))
                    }
                    _renderAriaLabel() {
                        const $element = this.$element();
                        $element.attr("aria-label", (0, _text_utils.getAriaLabel)(this.option()));
                        void(0, _text_utils.getAriaDescription)(this.option()).then((text => {
                            if (text) {
                                const id = `dx-${new _guid.default}`;
                                const $description = $element.find(`.${_m_classes.APPOINTMENT_CONTENT_CLASSES.ARIA_DESCRIPTION}`);
                                if ($description) {
                                    $element.attr("aria-describedby", id);
                                    $description.text(text).attr("id", id)
                                }
                            }
                        }))
                    }
                    _renderAppointmentGeometry() {
                        const geometry = this.option("geometry");
                        const $element = this.$element();
                        (0, _translator.move)($element, {
                            top: geometry.top,
                            left: geometry.left
                        });
                        $element.css({
                            width: geometry.width < 0 ? 0 : geometry.width,
                            height: geometry.height < 0 ? 0 : geometry.height
                        })
                    }
                    _renderEmptyClass() {
                        const geometry = this.option("geometry");
                        if (geometry.empty || this.option("isCompact")) {
                            this.$element().addClass(_m_classes.EMPTY_APPOINTMENT_CLASS)
                        }
                    }
                    _renderReducedAppointment() {
                        const reducedPart = this.option("reduced");
                        if (!reducedPart) {
                            return
                        }
                        this.$element().toggleClass(_m_classes.REDUCED_APPOINTMENT_CLASS, true).toggleClass(_m_classes.REDUCED_APPOINTMENT_PARTS_CLASSES[reducedPart], true);
                        this._renderAppointmentReducedIcon()
                    }
                    _renderAppointmentReducedIcon() {
                        const $icon = (0, _renderer.default)("<div>").addClass(_m_classes.REDUCED_APPOINTMENT_ICON).appendTo(this.$element());
                        _events_engine.default.off($icon, REDUCED_APPOINTMENT_POINTERENTER_EVENT_NAME);
                        _events_engine.default.on($icon, REDUCED_APPOINTMENT_POINTERENTER_EVENT_NAME, (() => {
                            (0, _m_tooltip.show)({
                                target: $icon,
                                content: (0, _text_utils.getReducedIconTooltip)(this.option())
                            })
                        }));
                        _events_engine.default.off($icon, REDUCED_APPOINTMENT_POINTERLEAVE_EVENT_NAME);
                        _events_engine.default.on($icon, REDUCED_APPOINTMENT_POINTERLEAVE_EVENT_NAME, (() => {
                            (0, _m_tooltip.hide)()
                        }))
                    }
                    _renderAllDayClass() {
                        this.$element().toggleClass(_m_classes.ALL_DAY_APPOINTMENT_CLASS, Boolean(this.option("allDay")))
                    }
                    _renderDragSourceClass() {
                        this.$element().toggleClass(_m_classes.APPOINTMENT_DRAG_SOURCE_CLASS, Boolean(this.option("isDragSource")))
                    }
                    _renderRecurrenceClass() {
                        const rule = this.dataAccessors.get("recurrenceRule", this.rawAppointment);
                        if ((0, _validate_rule.validateRRule)(rule)) {
                            this.$element().addClass(_m_classes.RECURRENCE_APPOINTMENT_CLASS)
                        }
                    }
                    _renderDirection() {
                        this.$element().addClass(_m_classes.DIRECTION_APPOINTMENT_CLASSES[this.option("direction")])
                    }
                    _createResizingConfig() {
                        const config = "vertical" === this.option("direction") ? this._getVerticalResizingRule() : this._getHorizontalResizingRule();
                        if (!this.invoke("isGroupedByDate")) {
                            config.stepPrecision = "strict"
                        }
                        return config
                    }
                    _renderResizable() {
                        if (this.option("allowResize")) {
                            this._createComponent(this.$element(), _resizable.default, (0, _extend.extend)(this._createResizingConfig(), this.option("resizableConfig")))
                        }
                    }
                    _useTemplates() {
                        return false
                    }
                }
                exports.Appointment = Appointment;
                (0, _component_registrator.default)("dxSchedulerAppointment", Appointment)
            },
        223:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/file_manager/ui.file_manager.file_uploader.js ***!
              \*********************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../core/guid */ 19427));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 57653);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                var _file_uploader = _interopRequireDefault(__webpack_require__( /*! ../../../ui/file_uploader */ 26980));
                var _widget = _interopRequireDefault(__webpack_require__( /*! ../../core/widget/widget */ 89275));
                var _uiFile_manager = __webpack_require__( /*! ../../ui/file_manager/ui.file_manager.common */ 62725);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class FileManagerFileUploader extends _widget.default {
                    _initMarkup() {
                        this._initActions();
                        this.$element().addClass("dx-filemanager-fileuploader");
                        this._uploaderInfos = [];
                        this._createInternalFileUploader();
                        this._createDropZonePlaceholder();
                        this._setDropZonePlaceholderVisible(false);
                        super._initMarkup()
                    }
                    _createInternalFileUploader() {
                        const {
                            chunkSize: chunkSize
                        } = this._getController();
                        const $fileUploader = (0, _renderer.default)("<div>").appendTo(this.$element());
                        const fileUploader = this._createComponent($fileUploader, _file_uploader.default, {
                            name: "file",
                            multiple: true,
                            showFileList: false,
                            activeStateEnabled: false,
                            focusStateEnabled: false,
                            hoverStateEnabled: false,
                            labelText: "",
                            readyToUploadMessage: "",
                            accept: "*",
                            chunkSize: chunkSize,
                            dropZone: this.option("dropZone"),
                            onValueChanged: e => this._onFileUploaderValueChanged(e),
                            onProgress: e => this._onFileUploaderProgress(e),
                            onUploaded: e => this._onFileUploaderUploaded(e),
                            onFilesUploaded: e => this._onFileUploaderAllFilesUploaded(e),
                            onUploadAborted: e => this._onFileUploaderUploadAborted(e),
                            onUploadError: e => this._onFileUploaderUploadError(e),
                            onDropZoneEnter: () => this._setDropZonePlaceholderVisible(true),
                            onDropZoneLeave: () => this._setDropZonePlaceholderVisible(false)
                        });
                        fileUploader.option({
                            uploadChunk: (file, chunksData) => this._fileUploaderUploadChunk(fileUploader, file, chunksData),
                            abortUpload: (file, chunksData) => this._fileUploaderAbortUpload(fileUploader, file, chunksData)
                        });
                        fileUploader._shouldRaiseDragLeaveBase = fileUploader._shouldRaiseDragLeave;
                        fileUploader._shouldRaiseDragLeave = e => this._shouldRaiseDragLeave(e, fileUploader);
                        const uploaderInfo = {
                            fileUploader: fileUploader
                        };
                        this._uploaderInfos.push(uploaderInfo)
                    }
                    tryUpload() {
                        const info = this._findAndUpdateAvailableUploaderInfo();
                        if (info) {
                            info.fileUploader._selectFileDialogClickHandler()
                        }
                    }
                    cancelUpload(sessionId) {
                        this._cancelUpload(sessionId)
                    }
                    cancelFileUpload(sessionId, fileIndex) {
                        this._cancelUpload(sessionId, fileIndex)
                    }
                    _cancelUpload(sessionId, fileIndex) {
                        const {
                            fileUploader: fileUploader
                        } = this._findUploaderInfoBySessionId(sessionId);
                        fileUploader.abortUpload(fileIndex)
                    }
                    _fileUploaderUploadChunk(fileUploader, file, chunksInfo) {
                        const {
                            session: session,
                            fileIndex: fileIndex
                        } = this._findSessionByFile(fileUploader, file);
                        const {
                            controller: controller
                        } = session;
                        chunksInfo.fileIndex = fileIndex;
                        return controller.uploadFileChunk(file, chunksInfo)
                    }
                    _fileUploaderAbortUpload(fileUploader, file, chunksInfo) {
                        const {
                            session: session,
                            fileIndex: fileIndex
                        } = this._findSessionByFile(fileUploader, file);
                        const {
                            controller: controller
                        } = session;
                        chunksInfo.fileIndex = fileIndex;
                        return controller.abortFileUpload(file, chunksInfo)
                    }
                    _onFileUploaderValueChanged(_ref) {
                        let {
                            component: component,
                            value: value
                        } = _ref;
                        if (0 === value.length) {
                            return
                        }
                        const files = value.slice();
                        const uploaderInfo = this._findUploaderInfo(component);
                        this._uploadFiles(uploaderInfo, files);
                        setTimeout((() => {
                            if (!this._findAndUpdateAvailableUploaderInfo()) {
                                this._createInternalFileUploader()
                            }
                        }))
                    }
                    _onFileUploaderProgress(_ref2) {
                        let {
                            component: component,
                            file: file,
                            bytesLoaded: bytesLoaded,
                            bytesTotal: bytesTotal
                        } = _ref2;
                        const {
                            session: session,
                            fileIndex: fileIndex
                        } = this._findSessionByFile(component, file);
                        const fileValue = 0 !== bytesTotal ? bytesLoaded / bytesTotal : 1;
                        const commonValue = component.option("progress") / 100;
                        const args = {
                            sessionId: session.id,
                            fileIndex: fileIndex,
                            commonValue: commonValue,
                            fileValue: fileValue
                        };
                        this._raiseUploadProgress(args)
                    }
                    _onFileUploaderAllFilesUploaded(_ref3) {
                        let {
                            component: component
                        } = _ref3;
                        const {
                            session: session
                        } = this._findSessionByFile(component, component._files[0].value);
                        this._raiseUploadFinished({
                            sessionId: session.id,
                            commonValue: component.option("progress") / 100
                        })
                    }
                    _onFileUploaderUploaded(_ref4) {
                        let {
                            component: component,
                            file: file
                        } = _ref4;
                        const deferred = this._getDeferredForFile(component, file);
                        deferred.resolve()
                    }
                    _onFileUploaderUploadAborted(_ref5) {
                        let {
                            component: component,
                            file: file
                        } = _ref5;
                        const deferred = this._getDeferredForFile(component, file);
                        deferred.resolve({
                            canceled: true
                        })
                    }
                    _onFileUploaderUploadError(_ref6) {
                        let {
                            component: component,
                            file: file,
                            error: error
                        } = _ref6;
                        const deferred = this._getDeferredForFile(component, file);
                        deferred.reject(error)
                    }
                    _createDropZonePlaceholder() {
                        const {
                            dropZonePlaceholderContainer: dropZonePlaceholderContainer
                        } = this.option();
                        this._$dropZonePlaceholder = (0, _renderer.default)("<div>").addClass("dx-filemanager-fileuploader-dropzone-placeholder").appendTo((0, _renderer.default)(dropZonePlaceholderContainer))
                    }
                    _adjustDropZonePlaceholder() {
                        var _this$_$dropZonePlace, _this$_$dropZonePlace2, _this$_$dropZonePlace3;
                        const {
                            dropZone: dropZone
                        } = this.option();
                        const $dropZoneTarget = dropZone;
                        if (!(0, _window.hasWindow)() || 0 === (null === $dropZoneTarget || void 0 === $dropZoneTarget ? void 0 : $dropZoneTarget.length)) {
                            return
                        }
                        const placeholderBorderTopWidth = parseFloat((null === (_this$_$dropZonePlace = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace ? void 0 : _this$_$dropZonePlace.css("borderTopWidth")) ?? "");
                        const placeholderBorderLeftWidth = parseFloat((null === (_this$_$dropZonePlace2 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace2 ? void 0 : _this$_$dropZonePlace2.css("borderLeftWidth")) ?? "");
                        const {
                            dropZonePlaceholderContainer: dropZonePlaceholderContainer
                        } = this.option();
                        const $placeholderContainer = dropZonePlaceholderContainer;
                        const containerBorderBottomWidth = parseFloat((null === $placeholderContainer || void 0 === $placeholderContainer ? void 0 : $placeholderContainer.css("borderBottomWidth")) ?? "");
                        const containerBorderLeftWidth = parseFloat((null === $placeholderContainer || void 0 === $placeholderContainer ? void 0 : $placeholderContainer.css("borderLeftWidth")) ?? "");
                        const containerHeight = (0, _size.getInnerHeight)($placeholderContainer);
                        const containerOffset = null === $placeholderContainer || void 0 === $placeholderContainer ? void 0 : $placeholderContainer.offset();
                        const dropZoneOffset = null === $dropZoneTarget || void 0 === $dropZoneTarget ? void 0 : $dropZoneTarget.offset();
                        null === (_this$_$dropZonePlace3 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace3 || _this$_$dropZonePlace3.css({
                            top: (null === dropZoneOffset || void 0 === dropZoneOffset ? void 0 : dropZoneOffset.top) - (null === containerOffset || void 0 === containerOffset ? void 0 : containerOffset.top) - containerHeight - containerBorderBottomWidth,
                            left: (null === dropZoneOffset || void 0 === dropZoneOffset ? void 0 : dropZoneOffset.left) - (null === containerOffset || void 0 === containerOffset ? void 0 : containerOffset.left) - containerBorderLeftWidth
                        });
                        (0, _size.setHeight)(this._$dropZonePlaceholder, (null === $dropZoneTarget || void 0 === $dropZoneTarget ? void 0 : $dropZoneTarget.get(0).offsetHeight) - 2 * placeholderBorderTopWidth);
                        (0, _size.setWidth)(this._$dropZonePlaceholder, (null === $dropZoneTarget || void 0 === $dropZoneTarget ? void 0 : $dropZoneTarget.get(0).offsetWidth) - 2 * placeholderBorderLeftWidth)
                    }
                    _setDropZonePlaceholderVisible(visible) {
                        if (visible) {
                            var _this$_$dropZonePlace4;
                            this._adjustDropZonePlaceholder();
                            null === (_this$_$dropZonePlace4 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace4 || _this$_$dropZonePlace4.css("display", "")
                        } else {
                            var _this$_$dropZonePlace5;
                            null === (_this$_$dropZonePlace5 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace5 || _this$_$dropZonePlace5.css("display", "none")
                        }
                    }
                    _shouldRaiseDragLeave(e, uploaderInstance) {
                        return uploaderInstance.isMouseOverElement(e, this.option("splitterElement")) || uploaderInstance._shouldRaiseDragLeaveBase(e, true)
                    }
                    _uploadFiles(uploaderInfo, files) {
                        this._setDropZonePlaceholderVisible(false);
                        const sessionId = (new _guid.default).toString();
                        const controller = this._getController();
                        const deferreds = files.map((() => new _deferred.Deferred));
                        uploaderInfo.session = {
                            id: sessionId,
                            controller: controller,
                            files: files,
                            deferreds: deferreds
                        };
                        const sessionInfo = {
                            sessionId: sessionId,
                            deferreds: deferreds,
                            files: files
                        };
                        this._raiseUploadSessionStarted(sessionInfo);
                        return (0, _uiFile_manager.whenSome)(deferreds).always((() => setTimeout((() => {
                            uploaderInfo.fileUploader.clear();
                            uploaderInfo.session = null
                        }))))
                    }
                    _getDeferredForFile(fileUploader, file) {
                        const {
                            session: session,
                            fileIndex: fileIndex
                        } = this._findSessionByFile(fileUploader, file);
                        return session.deferreds[fileIndex]
                    }
                    _findSessionByFile(fileUploader, file) {
                        const uploaderInfo = this._findUploaderInfo(fileUploader);
                        const {
                            session: session
                        } = uploaderInfo;
                        const fileIndex = session.files.indexOf(file);
                        return {
                            session: session,
                            fileIndex: fileIndex
                        }
                    }
                    _findUploaderInfoBySessionId(sessionId) {
                        for (let i = 0; i < (null === (_this$_uploaderInfos = this._uploaderInfos) || void 0 === _this$_uploaderInfos ? void 0 : _this$_uploaderInfos.length); i += 1) {
                            var _this$_uploaderInfos;
                            const uploaderInfo = this._uploaderInfos[i];
                            const {
                                session: session
                            } = uploaderInfo;
                            if (session && session.id === sessionId) {
                                return uploaderInfo
                            }
                        }
                        return null
                    }
                    _findAndUpdateAvailableUploaderInfo() {
                        var _info;
                        let info = null;
                        for (let i = 0; i < (null === (_this$_uploaderInfos2 = this._uploaderInfos) || void 0 === _this$_uploaderInfos2 ? void 0 : _this$_uploaderInfos2.length); i += 1) {
                            var _this$_uploaderInfos2;
                            const currentInfo = this._uploaderInfos[i];
                            currentInfo.fileUploader.option("dropZone", "");
                            if (!info && !currentInfo.session) {
                                info = currentInfo
                            }
                        }
                        const {
                            dropZone: dropZone
                        } = this.option();
                        null === (_info = info) || void 0 === _info || _info.fileUploader.option("dropZone", dropZone);
                        return info
                    }
                    _findUploaderInfo(fileUploader) {
                        for (let i = 0; i < (null === (_this$_uploaderInfos3 = this._uploaderInfos) || void 0 === _this$_uploaderInfos3 ? void 0 : _this$_uploaderInfos3.length); i += 1) {
                            var _this$_uploaderInfos3;
                            const info = this._uploaderInfos[i];
                            if (info.fileUploader === fileUploader) {
                                return info
                            }
                        }
                        return null
                    }
                    _getController() {
                        const {
                            getController: controllerGetter
                        } = this.option();
                        return null === controllerGetter || void 0 === controllerGetter ? void 0 : controllerGetter()
                    }
                    _raiseUploadSessionStarted(sessionInfo) {
                        var _this$_actions$onUplo, _this$_actions;
                        null === (_this$_actions$onUplo = (_this$_actions = this._actions).onUploadSessionStarted) || void 0 === _this$_actions$onUplo || _this$_actions$onUplo.call(_this$_actions, {
                            sessionInfo: sessionInfo
                        })
                    }
                    _raiseUploadProgress(args) {
                        var _this$_actions$onUplo2, _this$_actions2;
                        null === (_this$_actions$onUplo2 = (_this$_actions2 = this._actions).onUploadProgress) || void 0 === _this$_actions$onUplo2 || _this$_actions$onUplo2.call(_this$_actions2, args)
                    }
                    _raiseUploadFinished(args) {
                        var _this$_actions$onUplo3, _this$_actions3;
                        null === (_this$_actions$onUplo3 = (_this$_actions3 = this._actions).onUploadFinished) || void 0 === _this$_actions$onUplo3 || _this$_actions$onUplo3.call(_this$_actions3, args)
                    }
                    _initActions() {
                        this._actions = {
                            onUploadSessionStarted: this._createActionByOption("onUploadSessionStarted"),
                            onUploadProgress: this._createActionByOption("onUploadProgress"),
                            onUploadFinished: this._createActionByOption("onUploadFinished")
                        }
                    }
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            getController: void 0,
                            onUploadSessionStarted: void 0,
                            onUploadProgress: void 0,
                            onUploadFinished: void 0,
                            splitterElement: void 0
                        })
                    }
                    _optionChanged(args) {
                        var _this$_$dropZonePlace6, _this$_$dropZonePlace7;
                        const {
                            name: name,
                            value: value
                        } = args;
                        switch (name) {
                            case "getController":
                                this.repaint();
                                break;
                            case "onUploadSessionStarted":
                            case "onUploadProgress":
                            case "onUploadFinished":
                                this._actions[name] = this._createActionByOption(name);
                                break;
                            case "dropZone":
                                this._findAndUpdateAvailableUploaderInfo();
                                this._adjustDropZonePlaceholder();
                                break;
                            case "dropZonePlaceholderContainer":
                                null === (_this$_$dropZonePlace6 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace6 || _this$_$dropZonePlace6.detach();
                                null === (_this$_$dropZonePlace7 = this._$dropZonePlaceholder) || void 0 === _this$_$dropZonePlace7 || _this$_$dropZonePlace7.appendTo(value);
                                break;
                            case "splitterElement":
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                }
                exports.default = FileManagerFileUploader
            },
        334:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/appointments/resizing/get_delta_time.js ***!
              \**********************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getDeltaTime = void 0;
                var _date = (e = __webpack_require__( /*! ../../../../core/utils/date */ 41380), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _constants = __webpack_require__( /*! ../../constants */ 25307);
                const toMs = _date.default.dateToMilliseconds;
                exports.getDeltaTime = (args, initialSize, options) => {
                    const {
                        viewType: viewType,
                        resizableStep: resizableStep,
                        isAllDayPanel: isAllDayPanel
                    } = options;
                    switch (true) {
                        case ["timelineMonth", "month"].includes(viewType) || Boolean(isAllDayPanel):
                            return ((args, initialSize, resizableStep) => {
                                const intervalWidth = resizableStep || 2;
                                const initialWidth = initialSize.width;
                                return Math.round((args.width - initialWidth) / intervalWidth)
                            })(args, initialSize, resizableStep) * toMs("day");
                        case "agenda" === viewType:
                            return 0;
                        case _constants.VERTICAL_VIEW_TYPES.includes(viewType) && !isAllDayPanel:
                            return ((args, initialSize, _ref2) => {
                                let {
                                    cellSize: cellSize,
                                    cellDurationInMinutes: cellDurationInMinutes
                                } = _ref2;
                                const deltaHeight = args.height - initialSize.height;
                                const deltaTime = toMs("minute") * Math.round(deltaHeight * cellDurationInMinutes / cellSize.height);
                                return deltaTime
                            })(args, initialSize, options);
                        default:
                            return ((args, initialSize, _ref) => {
                                let {
                                    cellSize: cellSize,
                                    cellDurationInMinutes: cellDurationInMinutes
                                } = _ref;
                                const deltaWidth = args.width - initialSize.width;
                                const deltaTime = toMs("minute") * Math.round(deltaWidth * cellDurationInMinutes / cellSize.width);
                                return deltaTime
                            })(args, initialSize, options)
                    }
                }
            },
        453:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/integration/knockout.js ***!
              \********************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_error = _interopRequireDefault(__webpack_require__( /*! ../core/utils/m_error */ 40818));
                var _m_version = __webpack_require__( /*! ../core/utils/m_version */ 5388);
                var _knockout = _interopRequireDefault(__webpack_require__( /*! knockout */ 78117));
                __webpack_require__( /*! ./knockout/component_registrator */ 3794);
                __webpack_require__( /*! ./knockout/event_registrator */ 55445);
                __webpack_require__( /*! ./knockout/components */ 19856);
                __webpack_require__( /*! ./knockout/validation */ 61287);
                __webpack_require__( /*! ./knockout/variable_wrapper_utils */ 83518);
                __webpack_require__( /*! ./knockout/clean_node */ 76858);
                __webpack_require__( /*! ./knockout/clean_node_old */ 23204);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                if (_knockout.default) {
                    if ((0, _m_version.compare)(_knockout.default.version, [2, 3]) < 0) {
                        throw _m_error.default.Error("E0013")
                    }
                }
            },
        480:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/layout.js ***!
              \***************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ./utils */ 98013);
                const _min = Math.min;
                const _max = Math.max;
                const _round = Math.round;
                const horizontalAlignmentMap = {
                    left: 0,
                    center: 1,
                    right: 2
                };
                const verticalAlignmentMap = {
                    top: 0,
                    center: 1,
                    bottom: 2
                };
                const sideMap = {
                    horizontal: 0,
                    vertical: 1
                };
                const slicersMap = {};
                slicersMap[0] = function(a, b, size) {
                    return [a, _min(b, a + size)]
                };
                slicersMap[1] = function(a, b, size) {
                    return [_max(a, (a + b - size) / 2), _min(b, (a + b + size) / 2)]
                };
                slicersMap[2] = function(a, b, size) {
                    return [_max(a, b - size), b]
                };

                function pickValue(value, map, defaultValue) {
                    const val = (0, _utils.normalizeEnum)(value);
                    return val in map ? map[val] : defaultValue
                }

                function normalizeLayoutOptions(options) {
                    const side = pickValue(options.side, sideMap, 1);
                    const alignment = [pickValue(options.horizontalAlignment, horizontalAlignmentMap, 1), pickValue(options.verticalAlignment, verticalAlignmentMap, 0)];
                    return {
                        side: side,
                        primary: (primary = alignment[side], primary < 2 ? 0 : 2),
                        secondary: alignment[1 - side],
                        weak: options.weak,
                        priority: options.priority || 0,
                        header: options.header,
                        position: options.position
                    };
                    var primary
                }

                function getShrink(alignment, size) {
                    return (alignment > 0 ? -1 : 1) * size
                }

                function processForward(item, rect, minSize) {
                    const side = item.side;
                    const size = item.element.measure([rect[2] - rect[0], rect[3] - rect[1]]);
                    const minSide = "indside" === item.position ? 0 : minSize[side];
                    const isValid = size[side] < rect[2 + side] - rect[side] - minSide;
                    if (isValid) {
                        if ("inside" !== item.position) {
                            rect[item.primary + side] += getShrink(item.primary, size[side])
                        }
                        item.size = size
                    }
                    return isValid
                }

                function processRectBackward(item, rect, alignmentRect) {
                    const primarySide = item.side;
                    const secondarySide = (side = primarySide, 1 - side);
                    var side;
                    const itemRect = [];
                    const secondary = (alignment = item.secondary, a = alignmentRect[secondarySide], b = alignmentRect[2 + secondarySide], size = item.size[secondarySide], slicersMap[alignment](a, b, size));
                    var alignment, a, b, size;
                    itemRect[primarySide] = _round(itemRect[2 + primarySide] = rect[item.primary + primarySide] + ("inside" === item.position ? getShrink(item.primary, item.size[primarySide]) : 0));
                    itemRect[item.primary + primarySide] = _round(rect[item.primary + primarySide] - getShrink(item.primary, item.size[primarySide]));
                    if ("inside" !== item.position) {
                        rect[item.primary + primarySide] = itemRect[item.primary + primarySide]
                    }
                    itemRect[secondarySide] = _round(secondary[0]);
                    itemRect[2 + secondarySide] = _round(secondary[1]);
                    return itemRect
                }

                function processBackward(item, rect, alignmentRect, fitRect, size, targetRect) {
                    const itemRect = processRectBackward(item, rect, alignmentRect);
                    const itemFitRect = processRectBackward(item, fitRect, fitRect);
                    if (size[item.side] > 0) {
                        size[item.side] -= item.size[item.side];
                        targetRect[item.primary + item.side] = itemRect[item.primary + item.side];
                        item.element.freeSpace()
                    } else {
                        item.element.move(itemRect, itemFitRect)
                    }
                }

                function Layout() {
                    this._targets = []
                }
                Layout.prototype = {
                    constructor: Layout,
                    dispose() {
                        this._targets = null
                    },
                    add(target) {
                        this._targets.push(target)
                    },
                    forward(targetRect, minSize) {
                        const rect = targetRect.slice();
                        const targets = function(targets) {
                            let i;
                            const ii = targets.length;
                            let collection = [];
                            let layout;
                            for (i = 0; i < ii; ++i) {
                                layout = targets[i].layoutOptions();
                                if (layout) {
                                    layout = normalizeLayoutOptions(layout);
                                    layout.element = targets[i];
                                    collection.push(layout)
                                }
                            }
                            collection.sort(((a, b) => b.side - a.side || a.priority - b.priority));
                            collection = function(collection) {
                                const weakItem = collection.filter((item => true === item.weak))[0];
                                let headerItem;
                                if (weakItem) {
                                    headerItem = collection.filter((item => weakItem.primary === item.primary && item.side === weakItem.side && item !== weakItem))[0]
                                }
                                if (weakItem && headerItem) {
                                    return [makeHeader(headerItem, weakItem)].concat(collection.filter((item => !(item === headerItem || item === weakItem))))
                                }
                                return collection
                            }(collection);
                            return collection
                        }(this._targets);
                        let i;
                        const ii = targets.length;
                        const cache = [];
                        for (i = 0; i < ii; ++i) {
                            if (processForward(targets[i], rect, minSize)) {
                                cache.push(targets[i])
                            } else {
                                targets[i].element.freeSpace()
                            }
                        }
                        this._cache = cache.reverse();
                        return rect
                    },
                    backward(targetRect, alignmentRect) {
                        let size = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : [0, 0];
                        let backwardRect = targetRect.slice();
                        const fitRect = targetRect.slice();
                        const targets = this._cache;
                        let targetSide = 0;
                        let target;
                        let i;
                        const ii = targets.length;
                        for (i = 0; i < ii; ++i) {
                            target = targets[i];
                            if (target.side !== targetSide) {
                                backwardRect = targetRect.slice()
                            }
                            processBackward(target, backwardRect, alignmentRect, fitRect, size, targetRect);
                            targetSide = target.side
                        }
                        return size
                    }
                };

                function processBackwardHeaderRect(element, rect) {
                    const rectCopy = rect.slice();
                    const itemRect = processRectBackward(element, rectCopy, rectCopy);
                    itemRect[element.side] = rect[element.side];
                    itemRect[2 + element.side] = rect[2 + element.side];
                    return itemRect
                }

                function makeHeader(header, weakElement) {
                    const side = header.side;
                    const primary = header.primary;
                    const secondary = header.secondary;
                    return {
                        side: side,
                        primary: primary,
                        secondary: secondary,
                        priority: 0,
                        element: {
                            measure(targetSize) {
                                const result = targetSize.slice();
                                const weakSize = weakElement.element.measure(targetSize.slice());
                                targetSize[primary] -= weakSize[primary];
                                const headerSize = header.element.measure(targetSize.slice());
                                result[side] = weakSize[side] = headerSize[side] = Math.max(headerSize[side], weakSize[side]);
                                weakElement.size = weakSize;
                                header.size = headerSize;
                                return result
                            },
                            move(rect, fitRect) {
                                if (fitRect[2] - fitRect[0] < header.size[0] + weakElement.size[0] - 2) {
                                    this.freeSpace();
                                    return
                                }
                                const weakRect = processBackwardHeaderRect(weakElement, fitRect);
                                fitRect[2 + weakElement.primary] = weakRect[weakElement.primary];
                                const headerFitReact = processBackwardHeaderRect(header, fitRect);
                                if (fitRect[2 + weakElement.primary] < rect[2 + weakElement.primary] && header.size[header.primary] > rect[2 + header.primary] - rect[header.primary]) {
                                    rect[2 + weakElement.primary] = fitRect[2 + weakElement.primary]
                                }
                                let headerRect = processBackwardHeaderRect(header, rect);
                                if (headerRect[2 + weakElement.primary] > fitRect[2 + weakElement.primary]) {
                                    rect[2 + weakElement.primary] = fitRect[2 + weakElement.primary];
                                    headerRect = processBackwardHeaderRect(header, rect)
                                }
                                weakElement.element.move(weakRect);
                                header.element.move(headerRect, headerFitReact)
                            },
                            freeSpace() {
                                header.element.freeSpace();
                                weakElement.element.freeSpace()
                            }
                        }
                    }
                }
                exports.default = Layout
            },
        567:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/pagination/drop_down_editors/select_box.js ***!
              \***************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.SelectBox = exports.NumberBoxDefaultProps = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _index = __webpack_require__( /*! ../../core/r1/runtime/inferno/index */ 6257);
                var _select_box = (e = __webpack_require__( /*! ../../../ui/select_box */ 60695), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _dom_component_wrapper = __webpack_require__( /*! ../../core/r1/dom_component_wrapper */ 10922);
                var _editor_label_props = __webpack_require__( /*! ../editors/common/editor_label_props */ 71027);
                var _editor_props = __webpack_require__( /*! ../editors/common/editor_props */ 90650);
                var _editor_state_props = __webpack_require__( /*! ../editors/common/editor_state_props */ 49916);
                const NumberBoxDefaultProps = exports.NumberBoxDefaultProps = Object.assign({}, _editor_props.EditorDefaultProps, _editor_state_props.EditorStateDefaultProps, _editor_label_props.EditorLabelDefaultProps, {
                    placeholder: "",
                    hoverStateEnabled: true,
                    searchEnabled: false,
                    value: null,
                    isReactComponentWrapper: true
                });
                class SelectBox extends _index.BaseInfernoComponent {
                    constructor() {
                        super(...arguments);
                        this.state = {};
                        this.refs = null
                    }
                    get componentProps() {
                        return this.props
                    }
                    render() {
                        return (0, _inferno.createComponentVNode)(2, _dom_component_wrapper.DomComponentWrapper, {
                            componentType: _select_box.default,
                            componentProps: this.componentProps,
                            templateNames: ["dropDownButtonTemplate", "groupTemplate", "itemTemplate"]
                        })
                    }
                }
                exports.SelectBox = SelectBox;
                SelectBox.defaultProps = NumberBoxDefaultProps
            },
        638:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/hover.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                var _m_hover = __webpack_require__( /*! ../../../__internal/events/m_hover */ 57798);
                Object.keys(_m_hover).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _m_hover[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _m_hover[key]
                        }
                    })
                }))
            },
        673:
            /*!*****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/view_model/get_appointment_info.js ***!
              \*****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getAppointmentInfo = exports.getAgendaAppointmentInfo = void 0;
                var _m_utils_time_zone = (e = __webpack_require__( /*! ../m_utils_time_zone */ 18648), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const getAppointmentInfo = item => {
                    const appointment = {
                        allDay: item.allDay,
                        startDate: _m_utils_time_zone.default.createDateFromUTCWithLocalOffset(new Date(item.datesBeforeSplit.startDateUTC)),
                        endDate: _m_utils_time_zone.default.createDateFromUTCWithLocalOffset(new Date(item.datesBeforeSplit.endDateUTC))
                    };
                    const source = {
                        allDay: item.allDay,
                        startDate: new Date(item.source.startDate),
                        endDate: new Date(item.source.endDate)
                    };
                    return {
                        appointment: appointment,
                        sourceAppointment: source
                    }
                };
                exports.getAppointmentInfo = getAppointmentInfo;
                exports.getAgendaAppointmentInfo = item => Object.assign({}, getAppointmentInfo(item), {
                    partialDates: {
                        allDay: item.allDay,
                        startDate: _m_utils_time_zone.default.createDateFromUTCWithLocalOffset(new Date(item.datesAfterSplit.startDateUTC)),
                        endDate: _m_utils_time_zone.default.createDateFromUTCWithLocalOffset(new Date(item.datesAfterSplit.endDateUTC))
                    }
                })
            },
        686:
            /*!*********************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/workspaces/view_model/utils/view_provider_utils.js ***!
              \*********************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getViewDataGeneratorByViewType = void 0;
                var _constants_view = __webpack_require__( /*! ../../../utils/options/constants_view */ 43582);
                var _m_view_data_generator = __webpack_require__( /*! ../m_view_data_generator */ 91245);
                var _m_view_data_generator_day = __webpack_require__( /*! ../m_view_data_generator_day */ 61715);
                var _m_view_data_generator_month = __webpack_require__( /*! ../m_view_data_generator_month */ 55752);
                var _m_view_data_generator_timeline_month = __webpack_require__( /*! ../m_view_data_generator_timeline_month */ 73082);
                var _m_view_data_generator_week = __webpack_require__( /*! ../m_view_data_generator_week */ 40348);
                var _m_view_data_generator_work_week = __webpack_require__( /*! ../m_view_data_generator_work_week */ 33196);
                exports.getViewDataGeneratorByViewType = viewType => {
                    switch (viewType) {
                        case _constants_view.VIEWS.MONTH:
                            return new _m_view_data_generator_month.ViewDataGeneratorMonth(viewType);
                        case _constants_view.VIEWS.TIMELINE_MONTH:
                            return new _m_view_data_generator_timeline_month.ViewDataGeneratorTimelineMonth(viewType);
                        case _constants_view.VIEWS.DAY:
                        case _constants_view.VIEWS.TIMELINE_DAY:
                            return new _m_view_data_generator_day.ViewDataGeneratorDay(viewType);
                        case _constants_view.VIEWS.WEEK:
                        case _constants_view.VIEWS.TIMELINE_WEEK:
                            return new _m_view_data_generator_week.ViewDataGeneratorWeek(viewType);
                        case _constants_view.VIEWS.WORK_WEEK:
                        case _constants_view.VIEWS.TIMELINE_WORK_WEEK:
                            return new _m_view_data_generator_work_week.ViewDataGeneratorWorkWeek(viewType);
                        default:
                            return new _m_view_data_generator.ViewDataGenerator(viewType)
                    }
                }
            },
        725:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/pointer/base.js ***!
              \********************************************************************************/
            (module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "default", {
                    enumerable: true,
                    get: function() {
                        return _m_base.default
                    }
                });
                var _m_base = (e = __webpack_require__( /*! ../../../../__internal/events/pointer/m_base */ 37321), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        774:
            /*!**************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/column_headers.js ***!
              \**************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnHeadersView = void 0;
                var _m_column_headers = __webpack_require__( /*! ../../../grids/grid_core/column_headers/m_column_headers */ 88568);
                var _m_core = (e = __webpack_require__( /*! ../m_core */ 54353), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.ColumnHeadersView = _m_column_headers.columnHeadersModule.views.columnHeadersView;
                _m_core.default.registerModule("columnHeaders", _m_column_headers.columnHeadersModule)
            },
        869:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/localization/globalize/currency.js ***!
              \********************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                __webpack_require__( /*! ../../../../__internal/core/localization/globalize/currency */ 80811)
            },
        871:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_public_component.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
                    const data = (0, _element_data.data)($element.get(0));
                    const name = getName(componentInstance.constructor);
                    data[name] = componentInstance;
                    if (disposeFn) {
                        _events_engine.default.one($element, _remove.removeEvent, (function() {
                            disposeFn.call(componentInstance)
                        }))
                    }
                    if (!data[COMPONENT_NAMES_DATA_KEY]) {
                        data[COMPONENT_NAMES_DATA_KEY] = []
                    }
                    data[COMPONENT_NAMES_DATA_KEY].push(name)
                };
                exports.default = void 0;
                exports.getInstanceByElement = function($element, componentClass) {
                    const name = getName(componentClass);
                    return (0, _element_data.data)($element.get(0), name)
                };
                exports.name = void 0;
                var _events_engine = (e = __webpack_require__( /*! ../../../common/core/events/core/events_engine */ 92774), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _remove = __webpack_require__( /*! ../../../common/core/events/remove */ 28630);
                var _element_data = __webpack_require__( /*! ../../../core/element_data */ 74663);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const COMPONENT_NAMES_DATA_KEY = "dxComponents";
                const componentNames = new WeakMap;
                let nextAnonymousComponent = 0;
                const getName = function(componentClass, newName) {
                    if ((0, _type.isDefined)(newName)) {
                        componentNames.set(componentClass, newName);
                        return
                    }
                    if (!componentNames.has(componentClass)) {
                        const generatedName = "dxPrivateComponent" + nextAnonymousComponent++;
                        componentNames.set(componentClass, generatedName);
                        return generatedName
                    }
                    return componentNames.get(componentClass)
                };
                exports.name = getName;
                exports.default = {
                    name: getName
                }
            },
        1012:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/pkcs1.js ***!
              \******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.pad = function(hash) {
                    const dataLength = (8 * _key.PUBLIC_KEY.n.length + 6) / 8;
                    const data = (0, _byte_utils.concatBytes)((0, _byte_utils.hexToBytes)(ASN1_SHA1), hash);
                    if (data.length + 10 > dataLength) {
                        throw Error("Key is too short for SHA1 signing algorithm")
                    }
                    const padding = new Uint8Array(dataLength - data.length);
                    padding.fill(255, 0, padding.length - 1);
                    padding[0] = 0;
                    padding[1] = 1;
                    padding[padding.length - 1] = 0;
                    return (0, _byte_utils.concatBytes)(padding, data)
                };
                var _byte_utils = __webpack_require__( /*! ./byte_utils */ 22692);
                var _key = __webpack_require__( /*! ./key */ 78157);
                const ASN1_SHA1 = "3021300906052b0e03021a05000414"
            },
        1242:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/local_store.js ***!
              \*****************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _local_store = (e = __webpack_require__( /*! ../common/data/local_store */ 71790), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _local_store.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        1243:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/chat/messagebubble.js ***!
              \*********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.MESSAGE_DATA_KEY = exports.CHAT_MESSAGEBUBBLE_IMAGE_CLASS = exports.CHAT_MESSAGEBUBBLE_ICON_PROHIBITION_CLASS = exports.CHAT_MESSAGEBUBBLE_HAS_IMAGE_CLASS = exports.CHAT_MESSAGEBUBBLE_DELETED_CLASS = exports.CHAT_MESSAGEBUBBLE_CONTENT_CLASS = exports.CHAT_MESSAGEBUBBLE_CLASS = void 0;
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/localization/message */ 4671));
                var _element = __webpack_require__( /*! ../../../core/element */ 61404);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _m_icon = __webpack_require__( /*! ../../core/utils/m_icon */ 42463);
                var _widget = _interopRequireDefault(__webpack_require__( /*! ../../core/widget/widget */ 89275));
                var _file_view = _interopRequireDefault(__webpack_require__( /*! ../../ui/chat/file_view/file_view */ 83545));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const CHAT_MESSAGEBUBBLE_CLASS = exports.CHAT_MESSAGEBUBBLE_CLASS = "dx-chat-messagebubble";
                const CHAT_MESSAGEBUBBLE_DELETED_CLASS = exports.CHAT_MESSAGEBUBBLE_DELETED_CLASS = "dx-chat-messagebubble-deleted";
                const CHAT_MESSAGEBUBBLE_CONTENT_CLASS = exports.CHAT_MESSAGEBUBBLE_CONTENT_CLASS = "dx-chat-messagebubble-content";
                const CHAT_MESSAGEBUBBLE_ICON_PROHIBITION_CLASS = exports.CHAT_MESSAGEBUBBLE_ICON_PROHIBITION_CLASS = `${_m_icon.ICON_CLASS}-cursorprohibition`;
                const CHAT_MESSAGEBUBBLE_HAS_IMAGE_CLASS = exports.CHAT_MESSAGEBUBBLE_HAS_IMAGE_CLASS = "dx-has-image";
                const CHAT_MESSAGEBUBBLE_IMAGE_CLASS = exports.CHAT_MESSAGEBUBBLE_IMAGE_CLASS = "dx-chat-messagebubble-image";
                const MESSAGE_DATA_KEY = exports.MESSAGE_DATA_KEY = "dxMessageData";
                class MessageBubble extends _widget.default {
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            isDeleted: false,
                            isEdited: false,
                            text: "",
                            template: null
                        })
                    }
                    _initMarkup() {
                        const $element = (0, _renderer.default)(this.element());
                        $element.addClass(CHAT_MESSAGEBUBBLE_CLASS);
                        super._initMarkup();
                        this._renderContentContainer();
                        this._renderAttachmentsElement();
                        this._updateContent();
                        this._renderAttachments()
                    }
                    _renderContentContainer() {
                        this._$content = (0, _renderer.default)("<div>").addClass(CHAT_MESSAGEBUBBLE_CONTENT_CLASS).appendTo(this.$element())
                    }
                    _renderAttachmentsElement() {
                        var _this$_$attachments;
                        const {
                            attachments: attachments,
                            isDeleted: isDeleted
                        } = this.option();
                        null === (_this$_$attachments = this._$attachments) || void 0 === _this$_$attachments || _this$_$attachments.remove();
                        this._$attachments = void 0;
                        if (null !== attachments && void 0 !== attachments && attachments.length && !isDeleted) {
                            this._$attachments = (0, _renderer.default)("<div>").appendTo(this.$element())
                        }
                    }
                    _updateContent() {
                        const {
                            template: template,
                            type: type,
                            text: text,
                            src: src,
                            alt: alt,
                            isDeleted: isDeleted = false
                        } = this.option();
                        this.$element().removeClass(CHAT_MESSAGEBUBBLE_DELETED_CLASS).removeClass(CHAT_MESSAGEBUBBLE_HAS_IMAGE_CLASS);
                        this._$content.empty();
                        if (template) {
                            template({
                                type: type,
                                text: text,
                                src: src,
                                alt: alt
                            }, (0, _element.getPublicElement)(this._$content));
                            return
                        }
                        if (isDeleted) {
                            this.$element().addClass(CHAT_MESSAGEBUBBLE_DELETED_CLASS);
                            const icon = (0, _renderer.default)("<div>").addClass(_m_icon.ICON_CLASS).addClass(CHAT_MESSAGEBUBBLE_ICON_PROHIBITION_CLASS);
                            const deletedMessage = (0, _renderer.default)("<div>").text(_message.default.format("dxChat-deletedMessageText"));
                            this._$content.append(icon).append(deletedMessage);
                            return
                        }
                        if ("image" === type) {
                            this.$element().addClass(CHAT_MESSAGEBUBBLE_HAS_IMAGE_CLASS);
                            (0, _renderer.default)("<img>").attr("src", src ?? "").attr("alt", alt ?? _message.default.format("dxChat-defaultImageAlt")).addClass(CHAT_MESSAGEBUBBLE_IMAGE_CLASS).appendTo(this._$content)
                        } else {
                            this._$content.text(text ?? "")
                        }
                    }
                    _renderAttachments() {
                        const {
                            attachments: attachments,
                            onAttachmentDownloadClick: onAttachmentDownloadClick
                        } = this.option();
                        if (!this._$attachments) {
                            return
                        }
                        this._$attachments.empty();
                        if (null !== attachments && void 0 !== attachments && attachments.length) {
                            this._createComponent(this._$attachments, _file_view.default, {
                                files: attachments,
                                onDownload: onAttachmentDownloadClick
                            })
                        }
                    }
                    _updateMessageData(property, value) {
                        const messageData = this.$element().data(MESSAGE_DATA_KEY) || {};
                        messageData[property] = value;
                        this.$element().data(MESSAGE_DATA_KEY, messageData)
                    }
                    _optionChanged(args) {
                        const {
                            name: name,
                            value: value
                        } = args;
                        switch (name) {
                            case "text":
                            case "src":
                            case "alt":
                            case "isDeleted":
                                this._updateMessageData(name, value);
                                this._updateContent();
                                this._renderAttachmentsElement();
                                this._renderAttachments();
                                break;
                            case "type":
                                this._updateContent();
                                this._renderAttachmentsElement();
                                this._renderAttachments();
                                break;
                            case "template":
                                this._updateContent();
                                break;
                            case "isEdited":
                                this._updateMessageData(name, value);
                                break;
                            case "onAttachmentDownloadClick":
                            case "attachments":
                                this._renderAttachmentsElement();
                                this._renderAttachments();
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                }
                exports.default = MessageBubble
            },
        1261:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/filtering/header_filter/utils.js ***!
              \*************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.needCreateHeaderFilter = exports.mergeColumnHeaderFilterOptions = exports.isColumnFilterable = exports.getHeaderFilterValuesType = exports.getHeaderFilterInfoArray = exports.getHeaderFilterInfo = exports.getFilterOperator = exports.getComposedHeaderFilter = exports.getColumnName = exports.getColumnIdentifier = void 0;
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../../../../../core/errors */ 87129));
                var _type = __webpack_require__( /*! ../../../../../../core/utils/type */ 11528);
                var _filtering = _interopRequireDefault(__webpack_require__( /*! ../../../../../../ui/shared/filtering */ 56417));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../../../../../grids/grid_core/m_utils */ 53226));
                const _excluded = ["texts", "visible"];

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.mergeColumnHeaderFilterOptions = (column, rootOptions) => {
                    var _column$headerFilter;
                    const _ref = rootOptions ?? {},
                        restRootOptions = function(r, e) {
                            if (null == r) {
                                return {}
                            }
                            var t = {};
                            for (var n in r) {
                                if ({}.hasOwnProperty.call(r, n)) {
                                    if (e.includes(n)) {
                                        continue
                                    }
                                    t[n] = r[n]
                                }
                            }
                            return t
                        }(_ref, _excluded);
                    return Object.assign({}, column, {
                        allowHeaderFiltering: !!(null !== rootOptions && void 0 !== rootOptions && rootOptions.visible) && !!(null !== column && void 0 !== column && column.allowFiltering) && !!(null !== column && void 0 !== column && column.allowHeaderFiltering),
                        headerFilter: Object.assign({}, restRootOptions, null === column || void 0 === column ? void 0 : column.headerFilter, {
                            search: Object.assign({}, null === restRootOptions || void 0 === restRootOptions ? void 0 : restRootOptions.search, null === column || void 0 === column || null === (_column$headerFilter = column.headerFilter) || void 0 === _column$headerFilter ? void 0 : _column$headerFilter.search)
                        })
                    })
                };
                const getColumnIdentifier = column => column.name ?? column.dataField;
                exports.getColumnIdentifier = getColumnIdentifier;
                const getColumnName = column => {
                    const name = getColumnIdentifier(column);
                    if (!(0, _type.isDefined)(name)) {
                        throw _errors.default.Error("E1049", column.caption)
                    }
                    return name
                };
                exports.getColumnName = getColumnName;
                const getFilterOperator = (values, filterType) => {
                    const isInclude = !filterType || "include" === filterType;
                    const isValueArray = Array.isArray(values);
                    switch (true) {
                        case isValueArray && isInclude:
                            return "anyof";
                        case isValueArray && !isInclude:
                            return "noneof";
                        case !isValueArray && isInclude:
                            return "=";
                        case !isValueArray && !isInclude:
                            return "<>";
                        default:
                            throw new Error("Invalid state")
                    }
                };
                exports.getFilterOperator = getFilterOperator;
                const isFilteringAllowed = column => column.allowFiltering || column.allowHeaderFiltering;
                exports.isColumnFilterable = column => isFilteringAllowed(column);
                exports.needCreateHeaderFilter = column => {
                    const values = column.filterValues;
                    const hasSelectedItems = (0, _type.isDefined)(values) && values.length > 0;
                    return isFilteringAllowed(column) && hasSelectedItems
                };
                const getFilterExpression = (filterValues, column) => {
                    var _column$headerFilter2;
                    const columnName = getColumnName(column);
                    const hasGroupInterval = !!(null !== (_column$headerFilter2 = column.headerFilter) && void 0 !== _column$headerFilter2 && _column$headerFilter2.groupInterval);
                    const needNormalizeFilterValues = 1 === (null === filterValues || void 0 === filterValues ? void 0 : filterValues.length) && !hasGroupInterval;
                    const normalizedFilterValues = needNormalizeFilterValues ? filterValues[0] : filterValues;
                    const filterOperator = getFilterOperator(normalizedFilterValues, column.filterType);
                    return [columnName, filterOperator, normalizedFilterValues]
                };
                const getHeaderFilterValuesType = column => {
                    var _column$headerFilter3;
                    const {
                        filterValues: filterValues
                    } = column;
                    if (!(null !== filterValues && void 0 !== filterValues && filterValues.length)) {
                        return "empty"
                    }
                    const [firstFilterItem] = filterValues;
                    const hasGroupInterval = !!_filtering.default.getGroupInterval(column);
                    const hasCustomDataSource = !!(null !== (_column$headerFilter3 = column.headerFilter) && void 0 !== _column$headerFilter3 && _column$headerFilter3.dataSource);
                    const isSingleValue = 1 === filterValues.length && !Array.isArray(firstFilterItem) && (!hasGroupInterval && !hasCustomDataSource || 1 === filterValues.length && null === firstFilterItem);
                    return isSingleValue ? "single-value" : "values-or-condition"
                };
                exports.getHeaderFilterValuesType = getHeaderFilterValuesType;
                const getHeaderFilterInfo = column => {
                    if (!isFilteringAllowed(column)) {
                        return null
                    }
                    const columnId = getColumnIdentifier(column);
                    const headerFilterValueType = getHeaderFilterValuesType(column);
                    if ("empty" === headerFilterValueType) {
                        return {
                            type: "empty",
                            columnId: columnId,
                            filterType: "include",
                            filterValues: [],
                            composedFilterValues: []
                        }
                    }
                    const {
                        filterType: filterType,
                        filterValues: filterValues
                    } = column;
                    const normalizedFilterType = filterType ?? "include";
                    const normalizedFilterValues = Array.isArray(filterValues) ? filterValues : [filterValues];
                    const filterValuesWithExpressions = normalizedFilterValues.filter((value => Array.isArray(value)));
                    const filterValuesWithoutExpressions = normalizedFilterValues.filter((value => !Array.isArray(value)));
                    const filterExpression = filterValuesWithoutExpressions.length ? [getFilterExpression(filterValuesWithoutExpressions, column)] : [];
                    const composedFilterValues = _m_utils.default.combineFilters([...filterExpression, ...filterValuesWithExpressions], "or");
                    return {
                        type: headerFilterValueType,
                        columnId: columnId,
                        filterType: normalizedFilterType,
                        filterValues: filterValues,
                        composedFilterValues: composedFilterValues
                    }
                };
                exports.getHeaderFilterInfo = getHeaderFilterInfo;
                exports.getHeaderFilterInfoArray = columns => columns.map((column => getHeaderFilterInfo(column))).filter((info => !!info));
                exports.getComposedHeaderFilter = headerFilterInfoArray => headerFilterInfoArray.filter((_ref2 => {
                    let {
                        type: type
                    } = _ref2;
                    return "empty" !== type
                })).reduce(((result, _ref3, idx, infoArray) => {
                    let {
                        composedFilterValues: composedFilterValues
                    } = _ref3;
                    result.push(composedFilterValues);
                    if (idx < infoArray.length - 1) {
                        result.push("and")
                    }
                    return result
                }), [])
            },
        1270:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/shallow_equals.js ***!
              \****************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.shallowEquals = void 0;
                exports.shallowEquals = (firstObject, secondObject) => {
                    if (Object.keys(firstObject).length !== Object.keys(secondObject).length) {
                        return false
                    }
                    return Object.entries(firstObject).every((_ref => {
                        let [key, firstValue] = _ref;
                        const secondValue = secondObject[key];
                        if (firstValue instanceof Date && secondValue instanceof Date) {
                            return firstValue.getTime() === secondValue.getTime()
                        }
                        return firstValue === secondValue
                    }))
                }
            },
        1414:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/editing/m_editing_utils.js ***!
              \***************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getButtonIndex = exports.generateNewRowTempKey = exports.forEachFormItems = exports.createFailureHandler = void 0;
                exports.getButtonName = getButtonName;
                exports.getEditorType = exports.getEditingTexts = void 0;
                exports.isEditable = function($element) {
                    return $element && ($element.is("input") || $element.is("textarea"))
                };
                exports.isNewRowTempKey = exports.isEditingOrShowEditorAlwaysDataCell = exports.isEditingCell = void 0;
                var _guid = (e = __webpack_require__( /*! ../../../../core/guid */ 19427), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                exports.createFailureHandler = function(deferred) {
                    return function(arg) {
                        const error = arg instanceof Error ? arg : new Error(arg && String(arg) || "Unknown error");
                        deferred.reject(error)
                    }
                };
                const isEditingCell = function(isEditRow, cellOptions) {
                    return cellOptions.isEditing || isEditRow && cellOptions.column.allowEditing
                };
                exports.isEditingCell = isEditingCell;
                exports.isEditingOrShowEditorAlwaysDataCell = function(isEditRow, cellOptions) {
                    const isCommandCell = !!cellOptions.column.command;
                    const isEditing = isEditingCell(isEditRow, cellOptions);
                    const isEditorCell = !isCommandCell && (isEditing || cellOptions.column.showEditorAlways);
                    return "data" === cellOptions.rowType && isEditorCell
                };
                exports.getEditingTexts = options => {
                    const editingTexts = options.component.option("editing.texts") || {};
                    return {
                        save: editingTexts.saveRowChanges,
                        cancel: editingTexts.cancelRowChanges,
                        edit: editingTexts.editRow,
                        undelete: editingTexts.undeleteRow,
                        delete: editingTexts.deleteRow,
                        add: editingTexts.addRowToNode
                    }
                };
                exports.generateNewRowTempKey = () => `_DX_KEY_${new _guid.default}`;
                exports.isNewRowTempKey = key => "string" === typeof key && key.startsWith("_DX_KEY_") && 44 === key.length;
                exports.getButtonIndex = (buttons, name) => {
                    let result = -1;
                    buttons.some(((button, index) => {
                        if (getButtonName(button) === name) {
                            result = index;
                            return true
                        }
                    }));
                    return result
                };

                function getButtonName(button) {
                    return (0, _type.isObject)(button) ? button.name : button
                }
                exports.getEditorType = item => {
                    var _column$formItem;
                    const {
                        column: column
                    } = item;
                    return item.isCustomEditorType ? item.editorType : null === (_column$formItem = column.formItem) || void 0 === _column$formItem ? void 0 : _column$formItem.editorType
                };
                const forEachFormItems = (items, callBack) => {
                    items.forEach((item => {
                        if (item.items || item.tabs) {
                            forEachFormItems(item.items || item.tabs, callBack)
                        } else {
                            callBack(item)
                        }
                    }))
                };
                exports.forEachFormItems = forEachFormItems
            },
        1452:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/stepper/stepper_item.js ***!
              \***********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.STEP_VALID_ICON = exports.STEP_INVALID_ICON = exports.STEP_INVALID_CLASS = exports.STEP_COMPLETED_CLASS = void 0;
                var _item = (e = __webpack_require__( /*! ../../ui/collection/item */ 30845), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const STEP_COMPLETED_CLASS = exports.STEP_COMPLETED_CLASS = "dx-step-completed";
                const STEP_INVALID_CLASS = exports.STEP_INVALID_CLASS = "dx-step-invalid";
                exports.STEP_VALID_ICON = "check";
                exports.STEP_INVALID_ICON = "errorcircle";
                class StepperItem extends _item.default {
                    _renderWatchers() {
                        super._renderWatchers();
                        this._startWatcher("hint", (value => {
                            this._renderHint(value)
                        }))
                    }
                    _renderHint(hint) {
                        this._$element.attr("title", hint ?? null)
                    }
                    updateInvalidClass(isValid) {
                        this._$element.toggleClass(STEP_INVALID_CLASS, void 0 !== isValid && !isValid)
                    }
                    changeCompleted(isCompleted) {
                        this._$element.toggleClass(STEP_COMPLETED_CLASS, isCompleted)
                    }
                }
                exports.default = StepperItem
            },
        1522:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/environment/init_mobile_viewport.js ***!
              \*************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.initMobileViewport = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _m_devices = _interopRequireDefault(__webpack_require__( /*! ../../core/m_devices */ 98905));
                var _m_dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/m_dom_adapter */ 62018));
                var _m_extend = __webpack_require__( /*! ../../core/utils/m_extend */ 96298);
                var _m_resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_resize_callbacks */ 33717));
                var _m_size = __webpack_require__( /*! ../../core/utils/m_size */ 64587);
                var _m_style = __webpack_require__( /*! ../../core/utils/m_style */ 11953);
                var _m_support = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_support */ 85991));
                var _m_window = __webpack_require__( /*! ../../core/utils/m_window */ 14470);
                var _m_events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/m_events_engine */ 36306));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const window = (0, _m_window.getWindow)();
                exports.initMobileViewport = function(options) {
                    options = (0, _m_extend.extend)({}, options);
                    let realDevice = _m_devices.default.real();
                    const {
                        allowZoom: allowZoom
                    } = options;
                    const {
                        allowPan: allowPan
                    } = options;
                    const allowSelection = "allowSelection" in options ? options.allowSelection : "generic" === realDevice.platform;
                    if (!(0, _renderer.default)("meta[name=viewport]").length) {
                        (0, _renderer.default)("<meta>").attr("name", "viewport").appendTo("head")
                    }
                    const metaVerbs = ["width=device-width"];
                    const msTouchVerbs = [];
                    if (allowZoom) {
                        msTouchVerbs.push("pinch-zoom")
                    } else {
                        metaVerbs.push("initial-scale=1.0", "maximum-scale=1.0, user-scalable=no")
                    }
                    if (allowPan) {
                        msTouchVerbs.push("pan-x", "pan-y")
                    }
                    if (!allowPan && !allowZoom) {
                        (0, _renderer.default)("html, body").css({
                            msContentZooming: "none",
                            msUserSelect: "none",
                            overflow: "hidden"
                        })
                    } else {
                        (0, _renderer.default)("html").css("msOverflowStyle", "-ms-autohiding-scrollbar")
                    }
                    if (!allowSelection && _m_support.default.supportProp("userSelect")) {
                        (0, _renderer.default)(".dx-viewport").css((0, _m_style.styleProp)("userSelect"), "none")
                    }(0, _renderer.default)("meta[name=viewport]").attr("content", metaVerbs.join());
                    (0, _renderer.default)("html").css("msTouchAction", msTouchVerbs.join(" ") || "none");
                    realDevice = _m_devices.default.real();
                    if (_m_support.default.touch) {
                        _m_events_engine.default.off(_m_dom_adapter.default.getDocument(), ".dxInitMobileViewport");
                        _m_events_engine.default.on(_m_dom_adapter.default.getDocument(), "dxpointermove.dxInitMobileViewport", (e => {
                            const count = e.pointers.length;
                            const isTouchEvent = "touch" === e.pointerType;
                            const zoomDisabled = !allowZoom && count > 1;
                            const panDisabled = !allowPan && 1 === count && !e.isScrollingEvent;
                            if (isTouchEvent && (zoomDisabled || panDisabled)) {
                                e.preventDefault()
                            }
                        }))
                    }
                    if (realDevice.ios) {
                        const isPhoneGap = "file:" === _m_dom_adapter.default.getLocation().protocol;
                        if (!isPhoneGap) {
                            _m_resize_callbacks.default.add((() => {
                                const windowWidth = (0, _m_size.getWidth)(window);
                                (0, _m_size.setWidth)((0, _renderer.default)("body"), windowWidth)
                            }))
                        }
                    }
                    if (realDevice.android) {
                        _m_resize_callbacks.default.add((() => {
                            setTimeout((() => {
                                const activeElement = _m_dom_adapter.default.getActiveElement();
                                if (activeElement.scrollIntoViewIfNeeded) {
                                    activeElement.scrollIntoViewIfNeeded()
                                } else {
                                    activeElement.scrollIntoView(false)
                                }
                            }))
                        }))
                    }
                }
            },
        1542:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/pagination/page_size/selector.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.PageSizeSelector = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _index = __webpack_require__( /*! ../../core/r1/runtime/inferno/index */ 6257);
                var _consts = __webpack_require__( /*! ../common/consts */ 54623);
                var _pagination_props = __webpack_require__( /*! ../common/pagination_props */ 64522);
                var _compatibility_utils = __webpack_require__( /*! ../utils/compatibility_utils */ 4917);
                var _large = __webpack_require__( /*! ./large */ 40340);
                var _small = __webpack_require__( /*! ./small */ 54892);
                const PageSizeSelectorDefaultProps = {
                    isLargeDisplayMode: true,
                    pageSize: _pagination_props.PaginationDefaultProps.pageSize,
                    pageSizeChangedInternal: _pagination_props.PaginationDefaultProps.pageSizeChangedInternal,
                    allowedPageSizes: _pagination_props.PaginationDefaultProps.allowedPageSizes
                };
                class PageSizeSelector extends _index.InfernoComponent {
                    constructor(props) {
                        super(props);
                        this.state = {};
                        this.refs = null;
                        this.rootElementRef = (0, _inferno.createRef)();
                        this.htmlRef = (0, _inferno.createRef)();
                        this.__getterCache = {
                            normalizedPageSizes: void 0
                        };
                        this.setRootElementRef = this.setRootElementRef.bind(this)
                    }
                    createEffects() {
                        return [new _index.InfernoEffect(this.setRootElementRef, [])]
                    }
                    setRootElementRef() {
                        const {
                            rootElementRef: rootElementRef
                        } = this.props;
                        if (rootElementRef) {
                            rootElementRef.current = this.htmlRef.current
                        }
                    }
                    getAllText() {
                        return (0, _compatibility_utils.getLocalizationMessage)(this.context, "dxPagination-pageSizesAllText")
                    }
                    getNormalizedPageSizes() {
                        if (void 0 !== this.__getterCache.normalizedPageSizes) {
                            return this.__getterCache.normalizedPageSizes
                        }
                        const result = this.props.allowedPageSizes.map((p => "all" === p || 0 === p ? {
                            text: this.getAllText(),
                            value: 0
                        } : {
                            text: String(p),
                            value: p
                        }));
                        this.__getterCache.normalizedPageSizes = result;
                        return result
                    }
                    componentWillUpdate(nextProps) {
                        super.componentWillUpdate();
                        if (this.props.allowedPageSizes !== nextProps.allowedPageSizes) {
                            this.__getterCache.normalizedPageSizes = void 0
                        }
                    }
                    render() {
                        const normalizedPageSizes = this.getNormalizedPageSizes();
                        const {
                            pageSize: pageSize,
                            pageSizeChangedInternal: pageSizeChangedInternal,
                            isLargeDisplayMode: isLargeDisplayMode
                        } = this.props;
                        return (0, _inferno.createVNode)(1, "div", _consts.PAGINATION_PAGE_SIZES_CLASS, [isLargeDisplayMode && (0, _inferno.createComponentVNode)(2, _large.PageSizeLarge, {
                            allowedPageSizes: normalizedPageSizes,
                            pageSize: pageSize,
                            pageSizeChangedInternal: pageSizeChangedInternal
                        }), !isLargeDisplayMode && (0, _inferno.createComponentVNode)(2, _small.PageSizeSmall, {
                            parentRef: this.htmlRef,
                            allowedPageSizes: normalizedPageSizes,
                            pageSize: pageSize,
                            pageSizeChangedInternal: pageSizeChangedInternal
                        })], 0, null, null, this.htmlRef)
                    }
                }
                exports.PageSizeSelector = PageSizeSelector;
                PageSizeSelector.defaultProps = PageSizeSelectorDefaultProps
            },
        1614:
            /*!********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/menu.js ***!
              \********************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _menu = (e = __webpack_require__( /*! ../__internal/ui/menu/menu */ 81172), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _menu.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        1620:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/selection/m_selection.js ***!
              \*************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.selectionModule = exports.rowsViewSelectionExtenderMixin = exports.dataSelectionExtenderMixin = exports.columnHeadersSelectionExtenderMixin = exports.SelectionController = void 0;
                var _click = __webpack_require__( /*! ../../../../common/core/events/click */ 64044);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/core/events_engine */ 92774));
                var _hold = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/hold */ 68095));
                var _index = __webpack_require__( /*! ../../../../common/core/events/utils/index */ 98834);
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/localization/message */ 4671));
                var _array_utils = __webpack_require__( /*! ../../../../common/data/array_utils */ 43792);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 64553));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 87739);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/widget/ui.errors */ 35185));
                var _m_support = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/m_support */ 85991));
                var _selection = _interopRequireDefault(__webpack_require__( /*! ../../../ui/selection/selection */ 80876));
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 74854));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 53226));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const SHOW_CHECKBOXES_MODE = "selection.showCheckBoxesMode";
                const processLongTap = function(that, dxEvent) {
                    const rowsView = that.getView("rowsView");
                    const selectionController = that.getController("selection");
                    const $row = (0, _renderer.default)(dxEvent.target).closest(".dx-data-row");
                    const rowIndex = rowsView.getRowIndex($row);
                    if (rowIndex < 0) {
                        return
                    }
                    if ("onLongTap" === that.option(SHOW_CHECKBOXES_MODE)) {
                        if (selectionController.isSelectionWithCheckboxes()) {
                            selectionController.stopSelectionWithCheckboxes()
                        } else {
                            selectionController.startSelectionWithCheckboxes()
                        }
                    } else {
                        if ("onClick" === that.option(SHOW_CHECKBOXES_MODE)) {
                            selectionController.startSelectionWithCheckboxes()
                        }
                        if ("always" !== that.option(SHOW_CHECKBOXES_MODE)) {
                            selectionController.changeItemSelection(rowIndex, {
                                control: true
                            })
                        }
                    }
                };
                const selectionCellTemplate = (container, options) => {
                    const {
                        component: component
                    } = options;
                    const rowsView = component.getView("rowsView");
                    if (component.option("renderAsync") && !component.option("selection.deferred")) {
                        options.value = component.isRowSelected(options.row.key)
                    }
                    rowsView.renderSelectCheckBoxContainer((0, _renderer.default)(container), options)
                };
                const selectionHeaderTemplate = (container, options) => {
                    const {
                        column: column
                    } = options;
                    const $cellElement = (0, _renderer.default)(container);
                    const columnHeadersView = options.component.getView("columnHeadersView");
                    $cellElement.addClass("dx-editor-cell");
                    columnHeadersView._renderSelectAllCheckBox($cellElement, column);
                    columnHeadersView._attachSelectAllCheckBoxClickEvent($cellElement)
                };
                class SelectionController extends _m_modules.default.Controller {
                    init() {
                        const {
                            deferred: deferred,
                            selectAllMode: selectAllMode,
                            mode: mode
                        } = this.option("selection") ?? {};
                        if ("infinite" === this.option("scrolling.mode") && !deferred && "multiple" === mode && "allPages" === selectAllMode) {
                            _ui.default.log("W1018")
                        }
                        this._dataController = this.getController("data");
                        this._columnsController = this.getController("columns");
                        this._stateStoringController = this.getController("stateStoring");
                        this._selectionMode = mode;
                        this._isSelectionWithCheckboxes = false;
                        this._selection = this._createSelection();
                        this._updateSelectColumn();
                        this.createAction("onSelectionChanged", {
                            excludeValidators: ["disabled", "readOnly"]
                        });
                        if (!this._dataPushedHandler) {
                            this._dataPushedHandler = this._handleDataPushed.bind(this);
                            this._dataController.pushed.add(this._dataPushedHandler)
                        }
                    }
                    _handleDataPushed(changes) {
                        this._deselectRemovedOnPush(changes);
                        this._updateSelectedOnPush(changes)
                    }
                    _deselectRemovedOnPush(changes) {
                        const isDeferredSelection = this.option("selection.deferred");
                        let removedKeys = changes.filter((change => "remove" === change.type)).map((change => change.key));
                        if (isDeferredSelection) {
                            const selectedKeys = this._dataController.items().filter((item => item.isSelected)).map((item => item.key));
                            removedKeys = removedKeys.filter((key => selectedKeys.find((selectedKey => (0, _common.equalByValue)(selectedKey, key)))))
                        }
                        removedKeys.length && this.deselectRows(removedKeys)
                    }
                    _updateSelectedOnPush(changes) {
                        const isDeferredSelection = this.option("selection.deferred");
                        if (isDeferredSelection) {
                            return
                        }
                        const updateChanges = changes.filter((change => "update" === change.type));
                        const data = this.getSelectedRowsData();
                        (0, _array_utils.applyBatch)({
                            keyInfo: this._selection.options,
                            data: data,
                            changes: updateChanges
                        })
                    }
                    _getSelectionConfig() {
                        const dataController = this._dataController;
                        const columnsController = this._columnsController;
                        const selectionOptions = this.option("selection") ?? {};
                        const {
                            deferred: deferred
                        } = selectionOptions;
                        const scrollingMode = this.option("scrolling.mode");
                        const virtualPaging = "virtual" === scrollingMode || "infinite" === scrollingMode;
                        const allowSelectAll = this.option("selection.allowSelectAll");
                        const legacyScrollingMode = this.option("scrolling.legacyMode");
                        return {
                            selectedKeys: this.option("selectedRowKeys"),
                            mode: this._selectionMode,
                            deferred: deferred,
                            alwaysSelectByShift: selectionOptions.alwaysSelectByShift,
                            maxFilterLengthInRequest: selectionOptions.maxFilterLengthInRequest,
                            selectionFilter: this.option("selectionFilter"),
                            ignoreDisabledItems: true,
                            isVirtualPaging: virtualPaging,
                            sensitivity: this.option("selection.sensitivity"),
                            allowLoadByRange() {
                                const hasGroupColumns = columnsController.getGroupColumns().length > 0;
                                return virtualPaging && !legacyScrollingMode && !hasGroupColumns && allowSelectAll && !deferred
                            },
                            key: () => null === dataController || void 0 === dataController ? void 0 : dataController.key(),
                            keyOf: item => null === dataController || void 0 === dataController ? void 0 : dataController.keyOf(item),
                            dataFields() {
                                var _dataController$dataS;
                                return null === (_dataController$dataS = dataController.dataSource()) || void 0 === _dataController$dataS ? void 0 : _dataController$dataS.select()
                            },
                            load(options) {
                                var _dataController$dataS2;
                                return (null === (_dataController$dataS2 = dataController.dataSource()) || void 0 === _dataController$dataS2 ? void 0 : _dataController$dataS2.load(options)) || (new _deferred.Deferred).resolve([])
                            },
                            plainItems: cached => dataController.items(true),
                            isItemSelected: item => item.selected,
                            isSelectableItem: item => "data" === (null === item || void 0 === item ? void 0 : item.rowType) && !item.isNewRow,
                            getItemData: item => (0, _type.isDefined)(null === item || void 0 === item ? void 0 : item.rowType) ? (null === item || void 0 === item ? void 0 : item.oldData) || (null === item || void 0 === item ? void 0 : item.data) : item,
                            filter: () => dataController.getCombinedFilter(deferred),
                            totalCount: () => dataController.totalCount(),
                            getLoadOptions(loadItemIndex, focusedItemIndex, shiftItemIndex) {
                                var _dataController$dataS3;
                                const {
                                    sort: sort,
                                    filter: filter
                                } = (null === (_dataController$dataS3 = dataController.dataSource()) || void 0 === _dataController$dataS3 ? void 0 : _dataController$dataS3.lastLoadOptions()) ?? {};
                                let minIndex = Math.min(loadItemIndex, focusedItemIndex);
                                let maxIndex = Math.max(loadItemIndex, focusedItemIndex);
                                if ((0, _type.isDefined)(shiftItemIndex)) {
                                    minIndex = Math.min(shiftItemIndex, minIndex);
                                    maxIndex = Math.max(shiftItemIndex, maxIndex)
                                }
                                const take = maxIndex - minIndex + 1;
                                return {
                                    skip: minIndex,
                                    take: take,
                                    filter: filter,
                                    sort: sort
                                }
                            },
                            onSelectionChanged: this._updateSelectedItems.bind(this)
                        }
                    }
                    _updateSelectColumn() {
                        const columnsController = this._columnsController;
                        const isSelectColumnVisible = this.isSelectColumnVisible();
                        columnsController.addCommandColumn({
                            type: "selection",
                            command: "select",
                            visible: isSelectColumnVisible,
                            visibleIndex: -1,
                            dataType: "boolean",
                            alignment: "center",
                            cssClass: "dx-command-select",
                            width: "auto",
                            cellTemplate: selectionCellTemplate,
                            headerCellTemplate: selectionHeaderTemplate
                        });
                        columnsController.columnOption("command:select", "visible", isSelectColumnVisible)
                    }
                    _createSelection() {
                        const options = this._getSelectionConfig();
                        return new _selection.default(options)
                    }
                    _fireSelectionChanged(options) {
                        const argument = this.option("selection.deferred") ? {
                            selectionFilter: this.option("selectionFilter")
                        } : {
                            selectedRowKeys: this.option("selectedRowKeys")
                        };
                        this.selectionChanged.fire(argument);
                        if (options) {
                            this.executeAction("onSelectionChanged", options)
                        }
                    }
                    _updateCheckboxesState(options) {
                        const {
                            isDeferredMode: isDeferredMode
                        } = options;
                        const {
                            selectionFilter: selectionFilter
                        } = options;
                        const {
                            selectedItemKeys: selectedItemKeys
                        } = options;
                        const {
                            removedItemKeys: removedItemKeys
                        } = options;
                        if ("onClick" === this.option(SHOW_CHECKBOXES_MODE)) {
                            if (isDeferredMode ? selectionFilter && function(that, selectionFilter) {
                                    let keyIndex = 0;
                                    const store = that._dataController.store();
                                    const key = null === store || void 0 === store ? void 0 : store.key();
                                    const isComplexKey = Array.isArray(key);
                                    if (!selectionFilter.length) {
                                        return false
                                    }
                                    if (isComplexKey && Array.isArray(selectionFilter[0]) && "and" === selectionFilter[1]) {
                                        for (let i = 0; i < selectionFilter.length; i++) {
                                            if (Array.isArray(selectionFilter[i])) {
                                                if (selectionFilter[i][0] !== key[keyIndex] || "=" !== selectionFilter[i][1]) {
                                                    return true
                                                }
                                                keyIndex++
                                            }
                                        }
                                        return false
                                    }
                                    return key !== selectionFilter[0]
                                }(this, selectionFilter) : selectedItemKeys.length > 1) {
                                this.startSelectionWithCheckboxes()
                            } else if (isDeferredMode ? selectionFilter && !selectionFilter.length : 0 === selectedItemKeys.length && removedItemKeys.length) {
                                this.stopSelectionWithCheckboxes()
                            }
                        }
                    }
                    _updateSelectedItems(args) {
                        const that = this;
                        let selectionChangedOptions;
                        const isDeferredMode = that.option("selection.deferred");
                        const selectionFilter = that._selection.selectionFilter();
                        const dataController = that._dataController;
                        const items = dataController.items(true);
                        const visibleItems = dataController.items();
                        if (!items) {
                            return
                        }
                        const isSelectionWithCheckboxes = that.isSelectionWithCheckboxes();
                        const changedItemIndexes = that.getChangedItemIndexes(items);
                        const visibleChangedItemIndexes = that.getChangedItemIndexes(visibleItems);
                        that._updateCheckboxesState({
                            selectedItemKeys: args.selectedItemKeys,
                            removedItemKeys: args.removedItemKeys,
                            selectionFilter: selectionFilter,
                            isDeferredMode: isDeferredMode
                        });
                        if (changedItemIndexes.length || isSelectionWithCheckboxes !== that.isSelectionWithCheckboxes()) {
                            dataController.updateItems({
                                changeType: "updateSelection",
                                itemIndexes: visibleChangedItemIndexes
                            })
                        }
                        if (isDeferredMode) {
                            that.option("selectionFilter", selectionFilter);
                            selectionChangedOptions = {}
                        } else if (args.addedItemKeys.length || args.removedItemKeys.length) {
                            that._selectedItemsInternalChange = true;
                            that.option("selectedRowKeys", args.selectedItemKeys.slice(0));
                            that._selectedItemsInternalChange = false;
                            selectionChangedOptions = {
                                selectedRowsData: args.selectedItems.slice(0),
                                selectedRowKeys: args.selectedItemKeys.slice(0),
                                currentSelectedRowKeys: args.addedItemKeys.slice(0),
                                currentDeselectedRowKeys: args.removedItemKeys.slice(0)
                            }
                        }
                        that._fireSelectionChanged(selectionChangedOptions)
                    }
                    getChangedItemIndexes(items) {
                        const that = this;
                        const itemIndexes = [];
                        const isDeferredSelection = this.option("selection.deferred");
                        for (let i = 0, {
                                length: length
                            } = items; i < length; i++) {
                            const row = items[i];
                            const isItemSelected = that.isRowSelected(isDeferredSelection ? row.data : row.key);
                            if (that._selection.isDataItem(row) && row.isSelected !== isItemSelected) {
                                itemIndexes.push(i)
                            }
                        }
                        return itemIndexes
                    }
                    callbackNames() {
                        return ["selectionChanged"]
                    }
                    optionChanged(args) {
                        var _this$_selection;
                        super.optionChanged(args);
                        const selectionOptionsExists = !!(null !== (_this$_selection = this._selection) && void 0 !== _this$_selection && _this$_selection.options);
                        switch (args.name) {
                            case "selection": {
                                const oldSelectionMode = this._selectionMode;
                                this.init();
                                if (selectionOptionsExists && "selection.sensitivity" === args.fullName) {
                                    this._selection.options.sensitivity = args.value
                                }
                                if ("selection.showCheckBoxesMode" !== args.fullName) {
                                    const selectionMode = this._selectionMode;
                                    let selectedRowKeys = this.option("selectedRowKeys");
                                    if (oldSelectionMode !== selectionMode) {
                                        if ("single" === selectionMode) {
                                            if (selectedRowKeys.length > 1) {
                                                selectedRowKeys = [selectedRowKeys[0]]
                                            }
                                        } else if ("multiple" !== selectionMode) {
                                            selectedRowKeys = []
                                        }
                                    }
                                    this.selectRows(selectedRowKeys).always((() => {
                                        this._fireSelectionChanged()
                                    }))
                                } else {
                                    this.refresh().always((() => {
                                        this._fireSelectionChanged()
                                    }))
                                }
                                this._columnsController.updateColumns();
                                args.handled = true;
                                break
                            }
                            case "selectionFilter":
                                this._selection.selectionFilter(args.value);
                                args.handled = true;
                                break;
                            case "selectedRowKeys": {
                                const value = args.value || [];
                                if (Array.isArray(value) && !this._selectedItemsInternalChange && (this.component.getDataSource() || !value.length)) {
                                    this.selectRows(value)
                                }
                                args.handled = true;
                                break
                            }
                        }
                    }
                    publicMethods() {
                        return ["selectRows", "deselectRows", "selectRowsByIndexes", "getSelectedRowKeys", "getSelectedRowsData", "clearSelection", "selectAll", "deselectAll", "startSelectionWithCheckboxes", "stopSelectionWithCheckboxes", "isRowSelected"]
                    }
                    isRowSelected(arg) {
                        return this._selection.isItemSelected(arg)
                    }
                    isSelectColumnVisible() {
                        return "multiple" === this.option("selection.mode") && ("always" === this.option(SHOW_CHECKBOXES_MODE) || "onClick" === this.option(SHOW_CHECKBOXES_MODE) || this._isSelectionWithCheckboxes)
                    }
                    _isOnePageSelectAll() {
                        return "page" === this.option("selection.selectAllMode")
                    }
                    isSelectAll() {
                        return this._selection.getSelectAllState(this._isOnePageSelectAll())
                    }
                    selectAll() {
                        if ("onClick" === this.option(SHOW_CHECKBOXES_MODE)) {
                            this.startSelectionWithCheckboxes()
                        }
                        return this._selection.selectAll(this._isOnePageSelectAll())
                    }
                    deselectAll() {
                        return this._selection.deselectAll(this._isOnePageSelectAll())
                    }
                    clearSelection() {
                        return this.selectedItemKeys([])
                    }
                    refresh() {
                        const selectedRowKeys = this.option("selectedRowKeys") ?? [];
                        if (!this.option("selection.deferred") && selectedRowKeys.length) {
                            return this.selectedItemKeys(selectedRowKeys)
                        }
                        return (new _deferred.Deferred).resolve().promise()
                    }
                    selectedItemKeys(value, preserve, isDeselect, isSelectAll) {
                        return this._selection.selectedItemKeys(value, preserve, isDeselect, isSelectAll)
                    }
                    getSelectedRowKeys(mode) {
                        return this._selection.getSelectedItemKeys()
                    }
                    selectRows(keys, preserve) {
                        return this.selectedItemKeys(keys, preserve)
                    }
                    deselectRows(keys) {
                        return this.selectedItemKeys(keys, true, true)
                    }
                    selectRowsByIndexes(indexes) {
                        const items = this._dataController.items();
                        const keys = [];
                        if (!Array.isArray(indexes)) {
                            indexes = Array.prototype.slice.call(arguments, 0)
                        }(0, _iterator.each)(indexes, (function() {
                            const item = items[this];
                            if (item && "data" === item.rowType) {
                                keys.push(item.key)
                            }
                        }));
                        return this.selectRows(keys)
                    }
                    getSelectedRowsData(mode) {
                        return this._selection.getSelectedItems()
                    }
                    loadSelectedItemsWithFilter() {
                        return this._selection.loadSelectedItemsWithFilter()
                    }
                    changeItemSelection(visibleItemIndex, keys, setFocusOnly) {
                        keys = keys || {};
                        if (this.isSelectionWithCheckboxes()) {
                            keys.control = true
                        }
                        const loadedItemIndex = visibleItemIndex + this._dataController.getRowIndexOffset() - this._dataController.getRowIndexOffset(true);
                        return this._selection.changeItemSelection(loadedItemIndex, keys, setFocusOnly)
                    }
                    focusedItemIndex(itemIndex) {
                        const that = this;
                        if ((0, _type.isDefined)(itemIndex)) {
                            that._selection._focusedItemIndex = itemIndex
                        } else {
                            return that._selection._focusedItemIndex
                        }
                        return
                    }
                    isSelectionWithCheckboxes() {
                        return "multiple" === this.option("selection.mode") && ("always" === this.option(SHOW_CHECKBOXES_MODE) || this._isSelectionWithCheckboxes)
                    }
                    startSelectionWithCheckboxes() {
                        const that = this;
                        if ("multiple" === that.option("selection.mode") && !that.isSelectionWithCheckboxes()) {
                            that._isSelectionWithCheckboxes = true;
                            that._updateSelectColumn();
                            return true
                        }
                        return false
                    }
                    stopSelectionWithCheckboxes() {
                        const that = this;
                        if (that._isSelectionWithCheckboxes) {
                            that._isSelectionWithCheckboxes = false;
                            that._updateSelectColumn();
                            return true
                        }
                        return false
                    }
                }
                exports.SelectionController = SelectionController;
                const dataSelectionExtenderMixin = Base => class extends Base {
                    init() {
                        const isDeferredMode = this.option("selection.deferred");
                        super.init.apply(this, arguments);
                        if (isDeferredMode) {
                            this._selectionController._updateCheckboxesState({
                                isDeferredMode: true,
                                selectionFilter: this.option("selectionFilter")
                            })
                        }
                    }
                    _loadDataSource() {
                        const that = this;
                        return super._loadDataSource().always((() => {
                            that._selectionController.refresh()
                        }))
                    }
                    _processDataItem(item, options) {
                        const hasSelectColumn = this._selectionController.isSelectColumnVisible();
                        const isDeferredSelection = options.isDeferredSelection = void 0 === options.isDeferredSelection ? this.option("selection.deferred") : options.isDeferredSelection;
                        const dataItem = super._processDataItem.apply(this, arguments);
                        dataItem.isSelected = this._selectionController.isRowSelected(isDeferredSelection ? dataItem.data : dataItem.key);
                        if (hasSelectColumn && dataItem.values) {
                            for (let i = 0; i < options.visibleColumns.length; i++) {
                                if ("select" === options.visibleColumns[i].command) {
                                    dataItem.values[i] = dataItem.isSelected;
                                    break
                                }
                            }
                        }
                        return dataItem
                    }
                    refresh(options) {
                        const d = new _deferred.Deferred;
                        super.refresh(options).done((() => {
                            const skipSelectionRefresh = (0, _type.isObject)(options) && !options.selection;
                            if (skipSelectionRefresh) {
                                d.resolve();
                                return
                            }
                            this._selectionController.refresh().done(d.resolve).fail(d.reject)
                        })).fail(d.reject);
                        return d.promise()
                    }
                    _handleDataChanged(e) {
                        const hasLoadOperation = this.hasLoadOperation();
                        super._handleDataChanged.apply(this, arguments);
                        if (hasLoadOperation && !this._repaintChangesOnly) {
                            this._selectionController.focusedItemIndex(-1)
                        }
                    }
                    _applyChange(change) {
                        if (change && "updateSelection" === change.changeType) {
                            change.items.forEach(((item, index) => {
                                const currentItem = this._items[index];
                                if (currentItem) {
                                    currentItem.isSelected = item.isSelected;
                                    currentItem.values = item.values
                                }
                            }));
                            return
                        }
                        return super._applyChange.apply(this, arguments)
                    }
                    _endUpdateCore() {
                        const changes = this._changes;
                        const isUpdateSelection = changes.length > 1 && changes.every((change => "updateSelection" === change.changeType));
                        if (isUpdateSelection) {
                            const itemIndexes = changes.map((change => change.itemIndexes || [])).reduce(((a, b) => a.concat(b)));
                            this._changes = [{
                                changeType: "updateSelection",
                                itemIndexes: itemIndexes
                            }]
                        }
                        super._endUpdateCore.apply(this, arguments)
                    }
                };
                exports.dataSelectionExtenderMixin = dataSelectionExtenderMixin;
                const columnHeadersSelectionExtenderMixin = Base => class extends Base {
                    init() {
                        super.init();
                        this._selectionController.selectionChanged.add(this._updateSelectAllValue.bind(this))
                    }
                    _isSelectAllCheckBoxVisible() {
                        const isEmptyData = this._dataController.isEmpty();
                        const allowSelectAll = this.option("selection.allowSelectAll");
                        const isSelectAll = this._selectionController.isSelectAll();
                        return !isEmptyData && (allowSelectAll || false !== isSelectAll)
                    }
                    _updateSelectAllValue() {
                        const $element = this.element();
                        const $editor = null === $element || void 0 === $element ? void 0 : $element.find(".dx-select-checkbox");
                        if ($element && $editor.length && "multiple" === this.option("selection.mode")) {
                            const selectAllValue = this._selectionController.isSelectAll();
                            const isVisible = this._isSelectAllCheckBoxVisible();
                            $editor.dxCheckBox("instance").option({
                                visible: isVisible,
                                value: selectAllValue
                            })
                        }
                    }
                    _handleDataChanged(e) {
                        super._handleDataChanged(e);
                        if (!e || "refresh" === e.changeType || e.repaintChangesOnly && "update" === e.changeType) {
                            this.waitAsyncTemplates().done((() => {
                                this._updateSelectAllValue()
                            }))
                        }
                    }
                    _renderSelectAllCheckBox($container, column) {
                        const $checkbox = this._createSelectAllCheckboxElement(column);
                        $checkbox.appendTo($container);
                        return $checkbox
                    }
                    _createSelectAllCheckboxElement(column) {
                        const $groupElement = (0, _renderer.default)("<div>").addClass("dx-select-checkbox");
                        this.setAria("label", _message.default.format("dxDataGrid-ariaSelectAll"), $groupElement);
                        this._editorFactoryController.createEditor($groupElement, (0, _extend.extend)({}, column, {
                            parentType: "headerRow",
                            dataType: "boolean",
                            value: this._selectionController.isSelectAll(),
                            editorOptions: {
                                visible: this._isSelectAllCheckBoxVisible()
                            },
                            tabIndex: this.option("useLegacyKeyboardNavigation") ? -1 : this.option("tabIndex") || 0,
                            setValue: (value, e) => {
                                const allowSelectAll = this.option("selection.allowSelectAll");
                                e.component.option("visible", allowSelectAll || false !== e.component.option("value"));
                                if (!e.event || this._selectionController.isSelectAll() === value) {
                                    return
                                }
                                if (e.value && !allowSelectAll) {
                                    e.component.option("value", false)
                                } else {
                                    e.value ? this._selectionController.selectAll() : this._selectionController.deselectAll()
                                }
                                e.event.preventDefault()
                            }
                        }));
                        return $groupElement
                    }
                    _attachSelectAllCheckBoxClickEvent($element) {
                        _events_engine.default.on($element, _click.name, this.createAction((e => {
                            const {
                                event: event
                            } = e;
                            if (!this._isSelectAllCheckBoxVisible()) {
                                event.preventDefault();
                                return
                            }
                            if (!(0, _renderer.default)(event.target).closest(".dx-select-checkbox").length) {
                                _events_engine.default.trigger((0, _renderer.default)(event.currentTarget).children(".dx-select-checkbox"), _click.name)
                            }
                            event.preventDefault()
                        })))
                    }
                };
                exports.columnHeadersSelectionExtenderMixin = columnHeadersSelectionExtenderMixin;
                const rowsViewSelectionExtenderMixin = Base => class extends Base {
                    renderSelectCheckBoxContainer($container, options) {
                        if ("data" === options.rowType && !options.row.isNewRow) {
                            $container.addClass("dx-editor-cell");
                            this._attachCheckBoxClickEvent($container);
                            this._renderSelectCheckBox($container, options)
                        } else {
                            _m_utils.default.setEmptyText($container)
                        }
                    }
                    _renderSelectCheckBox(container, options) {
                        const groupElement = (0, _renderer.default)("<div>").addClass("dx-select-checkbox").appendTo(container);
                        this.setAria("label", _message.default.format("dxDataGrid-ariaSelectRow"), groupElement);
                        this._editorFactoryController.createEditor(groupElement, (0, _extend.extend)({}, options.column, {
                            parentType: "dataRow",
                            dataType: "boolean",
                            lookup: null,
                            value: options.value,
                            setValue(value, e) {
                                var _e$event;
                                if ("keydown" === (null === e || void 0 === e || null === (_e$event = e.event) || void 0 === _e$event ? void 0 : _e$event.type)) {
                                    _events_engine.default.trigger(e.element, _click.name, e)
                                }
                            },
                            row: options.row
                        }));
                        return groupElement
                    }
                    _attachCheckBoxClickEvent($element) {
                        _events_engine.default.on($element, _click.name, this.createAction((function(e) {
                            const {
                                event: event
                            } = e;
                            const rowIndex = this.getRowIndex((0, _renderer.default)(event.currentTarget).closest(".dx-row"));
                            if (rowIndex >= 0) {
                                this._selectionController.startSelectionWithCheckboxes();
                                this._selectionController.changeItemSelection(rowIndex, {
                                    shift: event.shiftKey
                                });
                                if ((0, _renderer.default)(event.target).closest(".dx-select-checkbox").length) {
                                    this._dataController.updateItems({
                                        changeType: "updateSelection",
                                        itemIndexes: [rowIndex]
                                    })
                                }
                            }
                        })))
                    }
                    _update(change) {
                        const that = this;
                        const tableElements = that.getTableElements();
                        if ("updateSelection" === change.changeType) {
                            if (tableElements.length > 0) {
                                (0, _iterator.each)(tableElements, ((_, tableElement) => {
                                    (0, _iterator.each)(change.itemIndexes || [], ((_, index) => {
                                        let $row;
                                        if (change.items[index]) {
                                            $row = that._getRowElements((0, _renderer.default)(tableElement)).eq(index);
                                            if ($row.length) {
                                                const {
                                                    isSelected: isSelected
                                                } = change.items[index];
                                                $row.toggleClass("dx-selection", void 0 === isSelected ? false : isSelected).find(".dx-select-checkbox").dxCheckBox("option", "value", isSelected);
                                                that.setAria("selected", isSelected, $row)
                                            }
                                        }
                                    }))
                                }));
                                that._updateCheckboxesClass()
                            }
                        } else {
                            super._update(change)
                        }
                    }
                    _createTable() {
                        const that = this;
                        const selectionMode = that.option("selection.mode");
                        const $table = super._createTable.apply(that, arguments);
                        if ("none" !== selectionMode) {
                            if ("onLongTap" === that.option(SHOW_CHECKBOXES_MODE) || !_m_support.default.touch) {
                                _events_engine.default.on($table, (0, _index.addNamespace)(_hold.default.name, "dxDataGridRowsView"), ".dx-data-row", that.createAction((e => {
                                    processLongTap(that.component, e.event);
                                    e.event.stopPropagation()
                                })))
                            }
                            _events_engine.default.on($table, "mousedown selectstart", that.createAction((e => {
                                const {
                                    event: event
                                } = e;
                                if (event.shiftKey) {
                                    event.preventDefault()
                                }
                            })))
                        }
                        return $table
                    }
                    _createRow(row) {
                        const $row = super._createRow.apply(this, arguments);
                        if (row) {
                            const {
                                isSelected: isSelected
                            } = row;
                            if (isSelected) {
                                $row.addClass("dx-selection")
                            }
                            const selectionMode = this.option("selection.mode");
                            if ("none" !== selectionMode) {
                                this.setAria("selected", isSelected, $row)
                            }
                        }
                        return $row
                    }
                    _rowClickForTreeList(e) {
                        super._rowClick(e)
                    }
                    _rowClick(e) {
                        const that = this;
                        const dxEvent = e.event;
                        const isSelectionDisabled = (0, _renderer.default)(dxEvent.target).closest(".dx-selection-disabled").length;
                        if (!that.isClickableElement((0, _renderer.default)(dxEvent.target))) {
                            if (!isSelectionDisabled && ("multiple" !== that.option("selection.mode") || "always" !== that.option(SHOW_CHECKBOXES_MODE))) {
                                if (that._selectionController.changeItemSelection(e.rowIndex, {
                                        control: (0, _index.isCommandKeyPressed)(dxEvent),
                                        shift: dxEvent.shiftKey
                                    })) {
                                    dxEvent.preventDefault();
                                    e.handled = true
                                }
                            }
                            super._rowClick(e)
                        }
                    }
                    isClickableElement($target) {
                        const isCommandSelect = $target.closest(".dx-command-select").length;
                        return !!isCommandSelect
                    }
                    _renderCore(change) {
                        const deferred = super._renderCore(change);
                        this._updateCheckboxesClass();
                        return deferred
                    }
                    _updateCheckboxesClass() {
                        const tableElements = this.getTableElements();
                        const isCheckBoxesHidden = this._selectionController.isSelectColumnVisible() && !this._selectionController.isSelectionWithCheckboxes();
                        (0, _iterator.each)(tableElements, ((_, tableElement) => {
                            (0, _renderer.default)(tableElement).toggleClass("dx-select-checkboxes-hidden", isCheckBoxesHidden)
                        }))
                    }
                };
                exports.rowsViewSelectionExtenderMixin = rowsViewSelectionExtenderMixin;
                exports.selectionModule = {
                    defaultOptions: () => ({
                        selection: {
                            mode: "none",
                            showCheckBoxesMode: "onClick",
                            allowSelectAll: true,
                            selectAllMode: "allPages",
                            deferred: false,
                            maxFilterLengthInRequest: 1500,
                            alwaysSelectByShift: false
                        },
                        selectionFilter: [],
                        selectedRowKeys: []
                    }),
                    controllers: {
                        selection: SelectionController
                    },
                    extenders: {
                        controllers: {
                            data: dataSelectionExtenderMixin,
                            contextMenu: Base => class extends Base {
                                _contextMenuPrepared(options) {
                                    const dxEvent = options.event;
                                    if (dxEvent.originalEvent && "dxhold" !== dxEvent.originalEvent.type || options.items && options.items.length > 0) {
                                        return
                                    }
                                    processLongTap(this, dxEvent)
                                }
                            }
                        },
                        views: {
                            columnHeadersView: columnHeadersSelectionExtenderMixin,
                            rowsView: rowsViewSelectionExtenderMixin
                        }
                    }
                }
            },
        1658:
            /*!***************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/filtering/header_filter/options.js ***!
              \***************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.defaultOptions = void 0;
                var _message = (e = __webpack_require__( /*! ../../../../../../common/core/localization/message */ 4671), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.defaultOptions = {
                    headerFilter: {
                        visible: false,
                        width: 252,
                        height: 325,
                        allowSelectAll: true,
                        search: {
                            enabled: false,
                            timeout: 500,
                            mode: "contains",
                            editorOptions: {}
                        },
                        texts: {
                            emptyValue: _message.default.format("dxDataGrid-headerFilterEmptyValue"),
                            ok: _message.default.format("dxDataGrid-headerFilterOK"),
                            cancel: _message.default.format("dxDataGrid-headerFilterCancel")
                        }
                    }
                }
            },
        1773:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_abstract_store.js ***!
              \*********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = __webpack_require__( /*! ../../common/data/errors */ 82812);
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../common/data/store_helper */ 66177));
                var _utils = __webpack_require__( /*! ../../common/data/utils */ 89358);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 55620));
                var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 2607);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const {
                    abstract: abstract
                } = _class.default;
                const {
                    queryByOptions: queryByOptions
                } = _store_helper.default;
                const storeImpl = {};
                const Store = _class.default.inherit({
                    _langParams: {},
                    ctor(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], ((_, optionName) => {
                            if (optionName in options) {
                                that.on(optionName.slice(2).toLowerCase(), options[optionName])
                            }
                        }));
                        this._key = options.key;
                        this._errorHandler = options.errorHandler;
                        this._useDefaultSearch = true
                    },
                    _clearCache: _common.noop,
                    _customLoadOptions: () => null,
                    key() {
                        return this._key
                    },
                    keyOf(obj) {
                        if (!this._keyGetter) {
                            this._keyGetter = (0, _data.compileGetter)(this.key())
                        }
                        return this._keyGetter(obj)
                    },
                    _requireKey() {
                        if (!this.key()) {
                            throw _errors.errors.Error("E4005")
                        }
                    },
                    load(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy.fireEvent("loading", [options]);
                        return this._withLock(this._loadImpl(options)).done((result => {
                            that._eventsStrategy.fireEvent("loaded", [result, options])
                        }))
                    },
                    _loadImpl(options) {
                        if (!(0, _type.isEmptyObject)(this._langParams)) {
                            options = options || {};
                            options._langParams = Object.assign({}, this._langParams, options._langParams)
                        }
                        return queryByOptions(this.createQuery(options), options).enumerate()
                    },
                    _withLock(task) {
                        const result = new _deferred.Deferred;
                        task.done((function() {
                            const that = this;
                            const args = arguments;
                            _utils.processRequestResultLock.promise().done((() => {
                                result.resolveWith(that, args)
                            }))
                        })).fail((function() {
                            result.rejectWith(this, arguments)
                        }));
                        return result
                    },
                    createQuery: abstract,
                    totalCount(options) {
                        return this._totalCountImpl(options)
                    },
                    _totalCountImpl(options) {
                        return queryByOptions(this.createQuery(options), options, true).count()
                    },
                    byKey(key, extraOptions) {
                        return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
                    },
                    _byKeyImpl: abstract,
                    insert(values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("inserting", [values]);
                        return that._addFailHandlers(that._insertImpl(values).done(((callbackValues, callbackKey) => {
                            that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _insertImpl: abstract,
                    update(key, values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("updating", [key, values]);
                        return that._addFailHandlers(that._updateImpl(key, values).done((() => {
                            that._eventsStrategy.fireEvent("updated", [key, values]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _updateImpl: abstract,
                    push(changes) {
                        const beforePushArgs = {
                            changes: changes,
                            waitFor: []
                        };
                        this._eventsStrategy.fireEvent("beforePushAggregation", [beforePushArgs]);
                        (0, _deferred.when)(...beforePushArgs.waitFor).done((() => {
                            this._pushImpl(changes);
                            this._eventsStrategy.fireEvent("beforePush", [{
                                changes: changes
                            }]);
                            this._eventsStrategy.fireEvent("push", [changes])
                        }))
                    },
                    _pushImpl: _common.noop,
                    remove(key) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("removing", [key]);
                        return that._addFailHandlers(that._removeImpl(key).done((callbackKey => {
                            that._eventsStrategy.fireEvent("removed", [callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _removeImpl: abstract,
                    _addFailHandlers(deferred) {
                        return deferred.fail(this._errorHandler).fail(_errors.handleError)
                    },
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                });
                Store.create = function(alias, options) {
                    if (!(alias in storeImpl)) {
                        throw _errors.errors.Error("E4020", alias)
                    }
                    return new storeImpl[alias](options)
                };
                Store.registerClass = function(type, alias) {
                    if (alias) {
                        storeImpl[alias] = type
                    }
                    return type
                };
                Store.inherit = (inheritor = Store.inherit, function(members, alias) {
                    const type = inheritor.apply(this, [members]);
                    Store.registerClass(type, alias);
                    return type
                });
                var inheritor;
                exports.default = Store
            },
        1811:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_renderer_base.js ***!
              \********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _dom_adapter = (e = __webpack_require__( /*! ../../core/dom_adapter */ 64960), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 74663);
                var _html_parser = __webpack_require__( /*! ../../core/utils/html_parser */ 23563);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _style = __webpack_require__( /*! ../../core/utils/style */ 58515);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                let renderer;
                const initRender = function(selector, context) {
                    if (!selector) {
                        this.length = 0;
                        return this
                    }
                    if ("string" === typeof selector) {
                        if ("body" === selector) {
                            this[0] = context ? context.body : _dom_adapter.default.getBody();
                            this.length = 1;
                            return this
                        }
                        context = context || _dom_adapter.default.getDocument();
                        if (selector.startsWith("<")) {
                            this[0] = _dom_adapter.default.createElement(selector.slice(1, -1), context);
                            this.length = 1;
                            return this
                        } [].push.apply(this, _dom_adapter.default.querySelectorAll(context, selector));
                        return this
                    }
                    if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                        this[0] = selector;
                        this.length = 1;
                        return this
                    }
                    if (Array.isArray(selector)) {
                        [].push.apply(this, selector);
                        return this
                    }
                    return renderer(selector.toArray ? selector.toArray() : [selector])
                };
                renderer = function(selector, context) {
                    return new initRender(selector, context)
                };
                renderer.fn = {
                    dxRenderer: true
                };
                initRender.prototype = renderer.fn;
                const repeatMethod = function(methodName, args) {
                    for (let i = 0; i < this.length; i++) {
                        const item = renderer(this[i]);
                        item[methodName].apply(item, args)
                    }
                    return this
                };
                const setAttributeValue = function(element, attrName, value) {
                    if (void 0 !== value && null !== value && false !== value) {
                        _dom_adapter.default.setAttribute(element, attrName, value)
                    } else {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }
                };
                initRender.prototype.show = function() {
                    return this.toggle(true)
                };
                initRender.prototype.hide = function() {
                    return this.toggle(false)
                };
                initRender.prototype.toggle = function(value) {
                    if (this[0]) {
                        this.toggleClass("dx-state-invisible", !value)
                    }
                    return this
                };
                initRender.prototype.attr = function(attrName, value) {
                    if (this.length > 1 && arguments.length > 1) {
                        return repeatMethod.call(this, "attr", arguments)
                    }
                    if (!this[0]) {
                        if ((0, _type.isObject)(attrName) || void 0 !== value) {
                            return this
                        }
                        return
                    }
                    if (!this[0].getAttribute) {
                        return this.prop(attrName, value)
                    }
                    if ("string" === typeof attrName && 1 === arguments.length) {
                        const result = this[0].getAttribute(attrName);
                        return null == result ? void 0 : result
                    }
                    if ((0, _type.isPlainObject)(attrName)) {
                        for (const key in attrName) {
                            this.attr(key, attrName[key])
                        }
                    } else {
                        setAttributeValue(this[0], attrName, value)
                    }
                    return this
                };
                initRender.prototype.removeAttr = function(attrName) {
                    this.each((function(_, element) {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }));
                    return this
                };
                initRender.prototype.prop = function(propName, value) {
                    if (!this[0]) {
                        return this
                    }
                    if ("string" === typeof propName && 1 === arguments.length) {
                        return this[0][propName]
                    }
                    if ((0, _type.isPlainObject)(propName)) {
                        for (const key in propName) {
                            this.prop(key, propName[key])
                        }
                    } else {
                        _dom_adapter.default.setProperty(this[0], propName, value)
                    }
                    return this
                };
                initRender.prototype.addClass = function(className) {
                    return this.toggleClass(className, true)
                };
                initRender.prototype.removeClass = function(className) {
                    return this.toggleClass(className, false)
                };
                initRender.prototype.hasClass = function(className) {
                    const classNames = className.split(" ");
                    for (let i = 0; i < this.length; i++) {
                        if (!this[i] || !this[i].className) {
                            continue
                        }
                        for (let j = 0; j < classNames.length; j++) {
                            if (this[i].classList.contains(classNames[j])) {
                                return true
                            }
                        }
                    }
                    return false
                };
                initRender.prototype.toggleClass = function(className, value) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "toggleClass", arguments)
                    }
                    if (!this[0] || !className) {
                        return this
                    }
                    value = void 0 === value ? !this.hasClass(className) : value;
                    const classNames = className.split(" ");
                    for (let i = 0; i < classNames.length; i++) {
                        _dom_adapter.default.setClass(this[0], classNames[i], value)
                    }
                    return this
                };
                initRender.prototype.html = function(value) {
                    if (!arguments.length) {
                        return this[0].innerHTML
                    }
                    this.empty();
                    if ("string" === typeof value && !(0, _html_parser.isTablePart)(value) || "number" === typeof value) {
                        this[0].innerHTML = value;
                        return this
                    }
                    return this.append((0, _html_parser.parseHTML)(value))
                };
                const appendElements = function(element, nextSibling) {
                    if (!this[0] || !element) {
                        return
                    }
                    if ("string" === typeof element) {
                        element = (0, _html_parser.parseHTML)(element)
                    } else if (element.nodeType) {
                        element = [element]
                    } else if ((0, _type.isNumeric)(element)) {
                        element = [_dom_adapter.default.createTextNode(element)]
                    }
                    for (let i = 0; i < element.length; i++) {
                        const item = element[i];
                        let container = this[0];
                        const wrapTR = "TABLE" === container.tagName && "TR" === item.tagName;
                        if (wrapTR && container.tBodies && container.tBodies.length) {
                            container = container.tBodies[0]
                        }
                        _dom_adapter.default.insertElement(container, item.nodeType ? item : item[0], nextSibling)
                    }
                };
                const setCss = function(name, value) {
                    if (!this[0] || !this[0].style) {
                        return
                    }
                    if (null === value || "number" === typeof value && isNaN(value)) {
                        return
                    }
                    name = (0, _style.styleProp)(name);
                    for (let i = 0; i < this.length; i++) {
                        this[i].style[name] = (0, _style.normalizeStyleProp)(name, value)
                    }
                };
                initRender.prototype.css = function(name, value) {
                    if ((0, _type.isString)(name)) {
                        if (2 === arguments.length) {
                            setCss.call(this, name, value)
                        } else {
                            if (!this[0]) {
                                return
                            }
                            name = (0, _style.styleProp)(name);
                            const result = window.getComputedStyle(this[0])[name] || this[0].style[name];
                            return (0, _type.isNumeric)(result) ? result.toString() : result
                        }
                    } else if ((0, _type.isPlainObject)(name)) {
                        for (const key in name) {
                            setCss.call(this, key, name[key])
                        }
                    }
                    return this
                };
                initRender.prototype.prepend = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.prepend(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element, this[0].firstChild]);
                    return this
                };
                initRender.prototype.append = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.append(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element]);
                    return this
                };
                initRender.prototype.prependTo = function(element) {
                    if (this.length > 1) {
                        for (let i = this.length - 1; i >= 0; i--) {
                            renderer(this[i]).prependTo(element)
                        }
                        return this
                    }
                    element = renderer(element);
                    if (element[0]) {
                        _dom_adapter.default.insertElement(element[0], this[0], element[0].firstChild)
                    }
                    return this
                };
                initRender.prototype.appendTo = function(element) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "appendTo", arguments)
                    }
                    _dom_adapter.default.insertElement(renderer(element)[0], this[0]);
                    return this
                };
                initRender.prototype.insertBefore = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0])
                    }
                    return this
                };
                initRender.prototype.insertAfter = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.before = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0])
                    }
                    return this
                };
                initRender.prototype.after = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.wrap = function(wrapper) {
                    if (this[0]) {
                        const wrap = renderer(wrapper);
                        wrap.insertBefore(this);
                        wrap.append(this)
                    }
                    return this
                };
                initRender.prototype.wrapInner = function(wrapper) {
                    const contents = this.contents();
                    if (contents.length) {
                        contents.wrap(wrapper)
                    } else {
                        this.append(wrapper)
                    }
                    return this
                };
                initRender.prototype.replaceWith = function(element) {
                    if (!(element && element[0])) {
                        return
                    }
                    if (element.is(this)) {
                        return this
                    }
                    element.insertBefore(this);
                    this.remove();
                    return element
                };
                initRender.prototype.remove = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "remove", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0], true);
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.detach = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "detach", arguments)
                    }
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.empty = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "empty", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0]);
                    _dom_adapter.default.setText(this[0], "");
                    return this
                };
                initRender.prototype.clone = function() {
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        result.push(this[i].cloneNode(true))
                    }
                    return renderer(result)
                };
                initRender.prototype.text = function(value) {
                    if (!arguments.length) {
                        let result = "";
                        for (let i = 0; i < this.length; i++) {
                            result += this[i] && this[i].textContent || ""
                        }
                        return result
                    }
                    const text = (0, _type.isFunction)(value) ? value() : value;
                    (0, _element_data.cleanDataRecursive)(this[0], false);
                    _dom_adapter.default.setText(this[0], (0, _type.isDefined)(text) ? text : "");
                    return this
                };
                initRender.prototype.val = function(value) {
                    if (1 === arguments.length) {
                        return this.prop("value", (0, _type.isDefined)(value) ? value : "")
                    }
                    return this.prop("value")
                };
                initRender.prototype.contents = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = [];
                    result.push.apply(result, this[0].childNodes);
                    return renderer(result)
                };
                initRender.prototype.find = function(selector) {
                    const result = renderer();
                    if (!selector) {
                        return result
                    }
                    const nodes = [];
                    let i;
                    if ("string" === typeof selector) {
                        selector = selector.trim();
                        for (i = 0; i < this.length; i++) {
                            const element = this[i];
                            if (_dom_adapter.default.isElementNode(element)) {
                                const elementId = element.getAttribute("id");
                                let queryId = elementId || "dx-query-children";
                                if (!elementId) {
                                    setAttributeValue(element, "id", queryId)
                                }
                                queryId = `[id='${queryId}'] `;
                                const querySelector = queryId + selector.replace(/([^\\])(,)/g, `$1, ${queryId}`);
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, querySelector));
                                setAttributeValue(element, "id", elementId)
                            } else if (_dom_adapter.default.isDocument(element) || _dom_adapter.default.isDocumentFragment(element)) {
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, selector))
                            }
                        }
                    } else {
                        for (i = 0; i < this.length; i++) {
                            selector = _dom_adapter.default.isNode(selector) ? selector : selector[0];
                            if (this[i] !== selector && this[i].contains(selector)) {
                                nodes.push(selector)
                            }
                        }
                    }
                    return result.add(nodes)
                };
                const isVisible = function(_, element) {
                    var _element$getClientRec, _element;
                    element = element.host ?? element;
                    if (!element.nodeType) {
                        return true
                    }
                    return !!(element.offsetWidth || element.offsetHeight || null !== (_element$getClientRec = (_element = element).getClientRects) && void 0 !== _element$getClientRec && _element$getClientRec.call(_element).length)
                };
                initRender.prototype.filter = function(selector) {
                    if (!selector) {
                        return renderer()
                    }
                    if (":visible" === selector) {
                        return this.filter(isVisible)
                    }
                    if (":hidden" === selector) {
                        return this.filter((function(_, element) {
                            return !isVisible(0, element)
                        }))
                    }
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        const item = this[i];
                        if (_dom_adapter.default.isElementNode(item) && "string" === (0, _type.type)(selector)) {
                            _dom_adapter.default.elementMatches(item, selector) && result.push(item)
                        } else if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                            selector === item && result.push(item)
                        } else if ((0, _type.isFunction)(selector)) {
                            selector.call(item, i, item) && result.push(item)
                        } else {
                            for (let j = 0; j < selector.length; j++) {
                                selector[j] === item && result.push(item)
                            }
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.not = function(selector) {
                    const result = [];
                    const nodes = this.filter(selector).toArray();
                    for (let i = 0; i < this.length; i++) {
                        if (-1 === nodes.indexOf(this[i])) {
                            result.push(this[i])
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.is = function(selector) {
                    return !!this.filter(selector).length
                };
                initRender.prototype.children = function(selector) {
                    let result = [];
                    for (let i = 0; i < this.length; i++) {
                        const nodes = this[i] ? this[i].childNodes : [];
                        for (let j = 0; j < nodes.length; j++) {
                            if (_dom_adapter.default.isElementNode(nodes[j])) {
                                result.push(nodes[j])
                            }
                        }
                    }
                    result = renderer(result);
                    return selector ? result.filter(selector) : result
                };
                initRender.prototype.siblings = function() {
                    const element = this[0];
                    if (!element || !element.parentNode) {
                        return renderer()
                    }
                    const result = [];
                    const parentChildNodes = element.parentNode.childNodes || [];
                    for (let i = 0; i < parentChildNodes.length; i++) {
                        const node = parentChildNodes[i];
                        if (_dom_adapter.default.isElementNode(node) && node !== element) {
                            result.push(node)
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.each = function(callback) {
                    for (let i = 0; i < this.length; i++) {
                        if (false === callback.call(this[i], i, this[i])) {
                            break
                        }
                    }
                };
                initRender.prototype.index = function(element) {
                    if (!element) {
                        return this.parent().children().index(this)
                    }
                    element = renderer(element);
                    return this.toArray().indexOf(element[0])
                };
                initRender.prototype.get = function(index) {
                    return this[index < 0 ? this.length + index : index]
                };
                initRender.prototype.eq = function(index) {
                    index = index < 0 ? this.length + index : index;
                    return renderer(this[index])
                };
                initRender.prototype.first = function() {
                    return this.eq(0)
                };
                initRender.prototype.last = function() {
                    return this.eq(-1)
                };
                initRender.prototype.select = function() {
                    for (let i = 0; i < this.length; i += 1) {
                        this[i].select && this[i].select()
                    }
                    return this
                };
                initRender.prototype.parent = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = renderer(this[0].parentNode);
                    return !selector || result.is(selector) ? result : renderer()
                };
                initRender.prototype.parents = function(selector) {
                    const result = [];
                    let parent = this.parent();
                    while (parent && parent[0] && !_dom_adapter.default.isDocument(parent[0])) {
                        if (_dom_adapter.default.isElementNode(parent[0])) {
                            if (!selector || parent.is(selector)) {
                                result.push(parent.get(0))
                            }
                        }
                        parent = parent.parent()
                    }
                    return renderer(result)
                };
                initRender.prototype.closest = function(selector) {
                    if (this.is(selector)) {
                        return this
                    }
                    let parent = this.parent();
                    while (parent && parent.length) {
                        if (parent.is(selector)) {
                            return parent
                        }
                        parent = parent.parent()
                    }
                    return renderer()
                };
                initRender.prototype.next = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    let next = renderer(this[0].nextSibling);
                    if (!arguments.length) {
                        return next
                    }
                    while (next && next.length) {
                        if (next.is(selector)) {
                            return next
                        }
                        next = next.next()
                    }
                    return renderer()
                };
                initRender.prototype.prev = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    return renderer(this[0].previousSibling)
                };
                initRender.prototype.add = function(selector) {
                    const targets = renderer(selector);
                    const result = this.toArray();
                    for (let i = 0; i < targets.length; i++) {
                        const target = targets[i];
                        if (-1 === result.indexOf(target)) {
                            result.push(target)
                        }
                    }
                    return renderer(result)
                };
                const emptyArray = [];
                initRender.prototype.splice = function() {
                    return renderer(emptyArray.splice.apply(this, arguments))
                };
                initRender.prototype.slice = function() {
                    return renderer(emptyArray.slice.apply(this, arguments))
                };
                initRender.prototype.toArray = function() {
                    return emptyArray.slice.call(this)
                };
                initRender.prototype.offset = function() {
                    if (!this[0]) {
                        return
                    }
                    return (0, _size.getOffset)(this[0])
                };
                initRender.prototype.offsetParent = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    let offsetParent = renderer(this[0].offsetParent);
                    while (offsetParent[0] && "static" === offsetParent.css("position")) {
                        offsetParent = renderer(offsetParent[0].offsetParent)
                    }
                    offsetParent = offsetParent[0] ? offsetParent : renderer(_dom_adapter.default.getDocumentElement());
                    return offsetParent
                };
                initRender.prototype.position = function() {
                    if (!this[0]) {
                        return
                    }
                    let offset;
                    const marginTop = parseFloat(this.css("marginTop"));
                    const marginLeft = parseFloat(this.css("marginLeft"));
                    if ("fixed" === this.css("position")) {
                        offset = this[0].getBoundingClientRect();
                        return {
                            top: offset.top - marginTop,
                            left: offset.left - marginLeft
                        }
                    }
                    offset = this.offset();
                    const offsetParent = this.offsetParent();
                    let parentOffset = {
                        top: 0,
                        left: 0
                    };
                    if ("HTML" !== offsetParent[0].nodeName) {
                        parentOffset = offsetParent.offset()
                    }
                    parentOffset = {
                        top: parentOffset.top + parseFloat(offsetParent.css("borderTopWidth")),
                        left: parentOffset.left + parseFloat(offsetParent.css("borderLeftWidth"))
                    };
                    return {
                        top: offset.top - parentOffset.top - marginTop,
                        left: offset.left - parentOffset.left - marginLeft
                    }
                };
                [{
                    name: "scrollLeft",
                    offsetProp: "pageXOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(value, win.pageYOffset)
                    }
                }, {
                    name: "scrollTop",
                    offsetProp: "pageYOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(win.pageXOffset, value)
                    }
                }].forEach((function(directionStrategy) {
                    const propName = directionStrategy.name;
                    initRender.prototype[propName] = function(value) {
                        if (!this[0]) {
                            return
                        }
                        const window = (0, _size.getWindowByElement)(this[0]);
                        if (void 0 === value) {
                            return window ? window[directionStrategy.offsetProp] : this[0][propName]
                        }
                        if (window) {
                            directionStrategy.scrollWindow(window, value)
                        } else {
                            this[0][propName] = value
                        }
                        return this
                    }
                }));
                initRender.prototype.data = function(key, value) {
                    if (!this[0]) {
                        return
                    }
                    if (arguments.length < 2) {
                        return _element_data.data.call(renderer, this[0], key)
                    }
                    _element_data.data.call(renderer, this[0], key, value);
                    return this
                };
                initRender.prototype.removeData = function(key) {
                    this[0] && (0, _element_data.removeData)(this[0], key);
                    return this
                };
                const rendererWrapper = function() {
                    return renderer.apply(this, arguments)
                };
                Object.defineProperty(rendererWrapper, "fn", {
                    enumerable: true,
                    configurable: true,
                    get: function() {
                        return renderer.fn
                    },
                    set: function(value) {
                        renderer.fn = value
                    }
                });
                exports.default = {
                    set: function(strategy) {
                        renderer = strategy
                    },
                    get: function() {
                        return rendererWrapper
                    }
                }
            },
        1881:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/search.js ***!
              \******************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_search = __webpack_require__( /*! ../../../grids/grid_core/search/m_search */ 7370);
                var _m_core = (e = __webpack_require__( /*! ../m_core */ 54353), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                _m_core.default.registerModule("search", _m_search.searchModule)
            },
        1896:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/options/option_manager.js ***!
              \****************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "OptionManager", {
                    enumerable: true,
                    get: function() {
                        return _m_option_manager.OptionManager
                    }
                });
                var _m_option_manager = __webpack_require__( /*! ../../__internal/core/options/m_option_manager */ 59830)
            },
        1927:
            /*!******************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/keyboard_navigation/navigation_strategy/matrix.js ***!
              \******************************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.NavigationStrategyMatrix = void 0;
                var _base = __webpack_require__( /*! ./base */ 59755);
                class NavigationStrategyMatrix extends _base.NavigationStrategyBase {
                    constructor(columnsCount) {
                        super();
                        this.columnsCount = columnsCount
                    }
                    updateColumnsCount(columnsCount) {
                        this.columnsCount = columnsCount
                    }
                    onKeyDown(event) {
                        return this.activeIdx >= 0 ? this.handleMovement(event) : false
                    }
                    handleMovement(event) {
                        switch (true) {
                            case "ArrowUp" === event.key:
                                this.moveActiveElement(-1, 0);
                                return true;
                            case "ArrowDown" === event.key:
                                this.moveActiveElement(1, 0);
                                return true;
                            case "ArrowLeft" === event.key:
                                this.moveActiveElement(0, -1);
                                return true;
                            case "ArrowRight" === event.key:
                                this.moveActiveElement(0, 1);
                                return true;
                            case event.ctrlKey && "Home" === event.key:
                                this.moveToFirstInFirstRow();
                                return true;
                            case "Home" === event.key:
                                this.moveToFirstInRow();
                                return true;
                            case event.ctrlKey && "End" === event.key:
                                this.moveToLastInLastRow();
                                return true;
                            case "End" === event.key:
                                this.moveToLastInRow();
                                return true;
                            default:
                                return false
                        }
                    }
                    moveActiveElement(rowShift, columnShift) {
                        const currentIdx = this.activeIdx;
                        const {
                            columnsCount: columnsCount,
                            items: {
                                length: itemsCount
                            }
                        } = this;
                        const rowCount = Math.ceil(itemsCount / columnsCount);
                        const currentColumnIdx = currentIdx % columnsCount;
                        const currentRowIdx = Math.floor(currentIdx / columnsCount);
                        const nextColumnIdx = currentColumnIdx + columnShift;
                        const nextRowIdx = currentRowIdx + rowShift;
                        const nextIdx = currentIdx + columnShift + columnsCount * rowShift;
                        if (nextIdx >= itemsCount || nextColumnIdx < 0 || nextColumnIdx >= columnsCount || nextRowIdx < 0 || nextRowIdx >= rowCount) {
                            this.focusActiveItem();
                            return
                        }
                        this.setActiveItem(nextIdx, true)
                    }
                    moveToFirstInRow() {
                        const currentIdx = this.activeIdx;
                        const {
                            columnsCount: columnsCount
                        } = this;
                        const currentColumnIdx = currentIdx % columnsCount;
                        if (0 === currentColumnIdx) {
                            return
                        }
                        this.moveActiveElement(0, -currentColumnIdx)
                    }
                    moveToLastInRow() {
                        const currentIdx = this.activeIdx;
                        const {
                            columnsCount: columnsCount
                        } = this;
                        const currentColumnIdx = currentIdx % columnsCount;
                        if (currentColumnIdx === columnsCount - 1) {
                            return
                        }
                        this.moveActiveElement(0, columnsCount - currentColumnIdx - 1)
                    }
                    moveToFirstInFirstRow() {
                        this.setActiveItem(0, true)
                    }
                    moveToLastInLastRow() {
                        const {
                            items: {
                                length: itemsCount
                            }
                        } = this;
                        this.setActiveItem(itemsCount - 1, true)
                    }
                }
                exports.NavigationStrategyMatrix = NavigationStrategyMatrix
            },
        1956:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/version.js ***!
              \*************************************************************/
            (__unused_webpack_module, exports) => {
                exports.version = exports.fullVersion = void 0;
                exports.version = "25.2.3";
                exports.fullVersion = "25.2.3"
            },
        1978:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/module_not_extended/virtual_scrolling.js ***!
              \*****************************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_virtual_scrolling = __webpack_require__( /*! ../../../grids/grid_core/virtual_scrolling/m_virtual_scrolling */ 21640);
                var _m_core = _interopRequireDefault(__webpack_require__( /*! ../m_core */ 54353));
                var _m_data_source_adapter = _interopRequireDefault(__webpack_require__( /*! ../m_data_source_adapter */ 72208));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                _m_core.default.registerModule("virtualScrolling", _m_virtual_scrolling.virtualScrollingModule);
                _m_data_source_adapter.default.extend(_m_virtual_scrolling.dataSourceAdapterExtender)
            },
        1979:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/number_box/m_number_box.spins.js ***!
              \********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/events/core/events_engine */ 92774));
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/events/pointer */ 89797));
                var _index = __webpack_require__( /*! ../../../common/core/events/utils/index */ 98834);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _m_button = _interopRequireDefault(__webpack_require__( /*! ../../ui/text_box/texteditor_button_collection/m_button */ 88244));
                var _m_number_box = _interopRequireDefault(__webpack_require__( /*! ./m_number_box.spin */ 47156));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class SpinButtons extends _m_button.default {
                    _attachEvents(instance, $spinContainer) {
                        const {
                            editor: editor
                        } = this;
                        if (!editor) {
                            return
                        }
                        const eventName = (0, _index.addNamespace)(_pointer.default.down, editor.NAME ?? "");
                        const $spinContainerChildren = $spinContainer.children();
                        const pointerDownAction = editor._createAction((e => {
                            var _this$editor;
                            null === (_this$editor = this.editor) || void 0 === _this$editor || _this$editor._spinButtonsPointerDownHandler(e)
                        }));
                        _events_engine.default.off($spinContainer, eventName);
                        _events_engine.default.on($spinContainer, eventName, (e => pointerDownAction({
                            event: e
                        })));
                        _m_number_box.default.getInstance($spinContainerChildren.eq(0)).option("onChange", (e => {
                            var _this$editor2;
                            null === (_this$editor2 = this.editor) || void 0 === _this$editor2 || _this$editor2._spinUpChangeHandler(e)
                        }));
                        _m_number_box.default.getInstance($spinContainerChildren.eq(1)).option("onChange", (e => {
                            var _this$editor3;
                            null === (_this$editor3 = this.editor) || void 0 === _this$editor3 || _this$editor3._spinDownChangeHandler(e)
                        }))
                    }
                    _create() {
                        const {
                            editor: editor
                        } = this;
                        const $spinContainer = (0, _renderer.default)("<div>").addClass("dx-numberbox-spin-container");
                        const $spinUp = (0, _renderer.default)("<div>").appendTo($spinContainer);
                        const $spinDown = (0, _renderer.default)("<div>").appendTo($spinContainer);
                        const options = this._getOptions();
                        this._addToContainer($spinContainer);
                        null === editor || void 0 === editor || editor._createComponent($spinUp, _m_number_box.default, (0, _extend.extend)({
                            direction: "up"
                        }, options));
                        null === editor || void 0 === editor || editor._createComponent($spinDown, _m_number_box.default, (0, _extend.extend)({
                            direction: "down"
                        }, options));
                        this._legacyRender(null === editor || void 0 === editor ? void 0 : editor.$element(), this._isTouchFriendly(), options.visible);
                        return {
                            instance: $spinContainer,
                            $element: $spinContainer
                        }
                    }
                    _getOptions() {
                        const {
                            editor: editor
                        } = this;
                        const visible = this._isVisible();
                        const disabled = null === editor || void 0 === editor ? void 0 : editor.option("disabled");
                        return {
                            visible: visible,
                            disabled: disabled
                        }
                    }
                    _isVisible() {
                        const {
                            editor: editor
                        } = this;
                        return super._isVisible() && (null === editor || void 0 === editor ? void 0 : editor.option("showSpinButtons"))
                    }
                    _isTouchFriendly() {
                        const {
                            editor: editor
                        } = this;
                        return (null === editor || void 0 === editor ? void 0 : editor.option("showSpinButtons")) && (null === editor || void 0 === editor ? void 0 : editor.option("useLargeSpinButtons"))
                    }
                    _legacyRender($editor, isTouchFriendly, isVisible) {
                        $editor.toggleClass("dx-numberbox-spin-touch-friendly", isTouchFriendly);
                        $editor.toggleClass("dx-numberbox-spin", isVisible)
                    }
                    update() {
                        const shouldUpdate = super.update();
                        if (shouldUpdate) {
                            const {
                                editor: editor,
                                instance: instance
                            } = this;
                            const $editor = null === editor || void 0 === editor ? void 0 : editor.$element();
                            const isVisible = this._isVisible();
                            const isTouchFriendly = this._isTouchFriendly();
                            const $spinButtons = instance.children();
                            const spinUp = _m_number_box.default.getInstance($spinButtons.eq(0));
                            const spinDown = _m_number_box.default.getInstance($spinButtons.eq(1));
                            const options = this._getOptions();
                            spinUp.option(options);
                            spinDown.option(options);
                            this._legacyRender($editor, isTouchFriendly, isVisible)
                        }
                    }
                }
                exports.default = SpinButtons
            },
        1990:
            /*!******************************************!*\
              !*** external "window.DevExpress.Gantt" ***!
              \******************************************/
            module => {
                module.exports = window.DevExpress.Gantt
            },
        2082:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/format_helper.js ***!
              \**************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _type = __webpack_require__( /*! ./core/utils/type */ 11528);
                var _date = _interopRequireDefault(__webpack_require__( /*! ./core/utils/date */ 41380));
                var _number = _interopRequireDefault(__webpack_require__( /*! ./common/core/localization/number */ 52771));
                var _date2 = _interopRequireDefault(__webpack_require__( /*! ./common/core/localization/date */ 38662));
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./core/utils/dependency_injector */ 89656));
                __webpack_require__( /*! ./common/core/localization/currency */ 17333);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = (0, _dependency_injector.default)({
                    format: function(value, format) {
                        const formatIsValid = (0, _type.isString)(format) && "" !== format || (0, _type.isPlainObject)(format) || (0, _type.isFunction)(format);
                        const valueIsValid = (0, _type.isNumeric)(value) || (0, _type.isDate)(value);
                        if (!formatIsValid || !valueIsValid) {
                            return (0, _type.isDefined)(value) ? value.toString() : ""
                        }
                        if ((0, _type.isFunction)(format)) {
                            return format(value)
                        }
                        if ((0, _type.isString)(format)) {
                            format = {
                                type: format
                            }
                        }
                        if ((0, _type.isNumeric)(value)) {
                            return _number.default.format(value, format)
                        }
                        if ((0, _type.isDate)(value)) {
                            return _date2.default.format(value, format)
                        }
                    },
                    getTimeFormat: function(showSecond) {
                        return showSecond ? "longtime" : "shorttime"
                    },
                    _normalizeFormat: function(format) {
                        if (!Array.isArray(format)) {
                            return format
                        }
                        if (1 === format.length) {
                            return format[0]
                        }
                        return function(date) {
                            return format.map((function(formatPart) {
                                return _date2.default.format(date, formatPart)
                            })).join(" ")
                        }
                    },
                    getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                        const resultFormat = [];
                        const needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                        if (needSpecialSecondFormatter) {
                            const secondFormatter = function(date) {
                                return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                            };
                            resultFormat.push(secondFormatter)
                        } else if (dateDifferences.millisecond) {
                            resultFormat.push("millisecond")
                        }
                        if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                            resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                        }
                        if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                            if (intervalFormat && "month" === intervalFormat) {
                                return "monthandyear"
                            } else {
                                resultFormat.unshift("shortdate");
                                return this._normalizeFormat(resultFormat)
                            }
                        }
                        if (dateDifferences.year && dateDifferences.month) {
                            return "monthandyear"
                        }
                        if (dateDifferences.year && dateDifferences.quarter) {
                            return "quarterandyear"
                        }
                        if (dateDifferences.year) {
                            return "year"
                        }
                        if (dateDifferences.quarter) {
                            return "quarter"
                        }
                        if (dateDifferences.month && dateDifferences.day) {
                            if (intervalFormat) {
                                const monthDayFormatter = function(date) {
                                    return _date2.default.getMonthNames("abbreviated")[date.getMonth()] + " " + _date2.default.format(date, "day")
                                };
                                resultFormat.unshift(monthDayFormatter)
                            } else {
                                resultFormat.unshift("monthandday")
                            }
                            return this._normalizeFormat(resultFormat)
                        }
                        if (dateDifferences.month) {
                            return "month"
                        }
                        if (dateDifferences.day) {
                            if (intervalFormat) {
                                resultFormat.unshift("day")
                            } else {
                                const dayFormatter = function(date) {
                                    return _date2.default.format(date, "dayofweek") + ", " + _date2.default.format(date, "day")
                                };
                                resultFormat.unshift(dayFormatter)
                            }
                            return this._normalizeFormat(resultFormat)
                        }
                        return this._normalizeFormat(resultFormat)
                    },
                    getDateFormatByTicks: function(ticks) {
                        let maxDiff;
                        let currentDiff;
                        let i;
                        if (ticks.length > 1) {
                            maxDiff = _date.default.getDatesDifferences(ticks[0], ticks[1]);
                            for (i = 1; i < ticks.length - 1; i++) {
                                currentDiff = _date.default.getDatesDifferences(ticks[i], ticks[i + 1]);
                                if (maxDiff.count < currentDiff.count) {
                                    maxDiff = currentDiff
                                }
                            }
                        } else {
                            maxDiff = {
                                year: true,
                                month: true,
                                day: true,
                                hour: ticks[0].getHours() > 0,
                                minute: ticks[0].getMinutes() > 0,
                                second: ticks[0].getSeconds() > 0,
                                millisecond: ticks[0].getMilliseconds() > 0
                            }
                        }
                        const resultFormat = this.getDateFormatByDifferences(maxDiff);
                        return resultFormat
                    },
                    getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                        let dateUnitInterval;
                        const correctDateDifferences = function(dateDifferences, tickInterval, value) {
                            switch (tickInterval) {
                                case "year":
                                case "quarter":
                                    dateDifferences.month = value;
                                case "month":
                                    dateDifferences.day = value;
                                case "week":
                                case "day":
                                    dateDifferences.hour = value;
                                case "hour":
                                    dateDifferences.minute = value;
                                case "minute":
                                    dateDifferences.second = value;
                                case "second":
                                    dateDifferences.millisecond = value
                            }
                        };
                        tickInterval = (0, _type.isString)(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                        const dateDifferences = _date.default.getDatesDifferences(startValue, endValue);
                        if (startValue !== endValue) {
                            ! function(differences, minDate, maxDate) {
                                if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                                    if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                        differences.millisecond = true;
                                        differences.second = false
                                    }
                                } else if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                    if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                        differences.second = true;
                                        differences.minute = false
                                    }
                                } else if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                    if (maxDate.getDate() - minDate.getDate() === 1) {
                                        differences.hour = true;
                                        differences.day = false
                                    }
                                } else if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                    if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                        differences.day = true;
                                        differences.month = false
                                    }
                                } else if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                    if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                        differences.month = true;
                                        differences.year = false
                                    }
                                }
                            }(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                        }
                        dateUnitInterval = _date.default.getDateUnitInterval(dateDifferences);
                        correctDateDifferences(dateDifferences, dateUnitInterval, true);
                        dateUnitInterval = _date.default.getDateUnitInterval(tickInterval || "second");
                        correctDateDifferences(dateDifferences, dateUnitInterval, false);
                        dateDifferences[{
                            week: "day"
                        } [dateUnitInterval] || dateUnitInterval] = true;
                        const resultFormat = this.getDateFormatByDifferences(dateDifferences);
                        return resultFormat
                    }
                });
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        2165:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/recurrence/days_from_by_day_rule.js ***!
              \******************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.daysFromByDayRule = void 0;
                const isString = str => Boolean(str);
                exports.daysFromByDayRule = rule => {
                    let result = [];
                    if (rule.byday) {
                        if (Array.isArray(rule.byday)) {
                            result = rule.byday
                        } else {
                            result = rule.byday.split(",")
                        }
                    }
                    return result.map((item => {
                        const match = /[A-Za-z]+/.exec(item);
                        return match && String(match[0])
                    })).filter(isString)
                }
            },
        2187:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/card_view/content_view/content/content.js ***!
              \************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Content = exports.CLASSES = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _utils = __webpack_require__( /*! ../../../../../../common/core/events/utils */ 98834);
                var _combine_classes = __webpack_require__( /*! ../../../../../core/utils/combine_classes */ 46190);
                var _utils2 = __webpack_require__( /*! ../../../../../grids/new/grid_core/accessibility/utils */ 94944);
                var _index = __webpack_require__( /*! ../../../../../grids/new/grid_core/keyboard_navigation/index */ 58529);
                var _card = __webpack_require__( /*! ./card/card */ 46715);
                const CLASSES = exports.CLASSES = {
                    content: "dx-cardview-content",
                    grid: "dx-cardview-content-grid",
                    selectCheckBoxesHidden: "dx-cardview-select-checkboxes-hidden",
                    wrapEnabled: "dx-cardview-word-wrap-enabled"
                };
                const CardWithKbn = (0, _index.withKeyDownHandler)((0, _index.withKbnNavigationItem)(_card.Card));
                class Content extends _inferno.Component {
                    constructor() {
                        super(...arguments);
                        this.containerRef = (0, _inferno.createRef)();
                        this.cardElementRefs = [];
                        this.focusFirstCardAfterReload = false
                    }
                    getCssVariables() {
                        var _this$props$cardProps, _this$props$cardProps3, _this$props$cardProps5, _this$props$cardProps7;
                        const variables = {};
                        if (this.props.cardsPerRow) {
                            variables["--dx-cardview-cardsperrow"] = this.props.cardsPerRow
                        }
                        if (null !== (_this$props$cardProps = this.props.cardProps) && void 0 !== _this$props$cardProps && _this$props$cardProps.minWidth) {
                            var _this$props$cardProps2;
                            variables["--dx-cardview-card-min-width"] = `${null===(_this$props$cardProps2=this.props.cardProps)||void 0===_this$props$cardProps2?void 0:_this$props$cardProps2.minWidth}px`
                        }
                        if (null !== (_this$props$cardProps3 = this.props.cardProps) && void 0 !== _this$props$cardProps3 && _this$props$cardProps3.maxWidth) {
                            var _this$props$cardProps4;
                            variables["--dx-cardview-card-max-width"] = `${null===(_this$props$cardProps4=this.props.cardProps)||void 0===_this$props$cardProps4?void 0:_this$props$cardProps4.maxWidth}px`
                        }
                        if (null !== (_this$props$cardProps5 = this.props.cardProps) && void 0 !== _this$props$cardProps5 && null !== (_this$props$cardProps5 = _this$props$cardProps5.cover) && void 0 !== _this$props$cardProps5 && _this$props$cardProps5.maxHeight) {
                            var _this$props$cardProps6;
                            variables["--dx-cardview-card-cover-max-height"] = `${null===(_this$props$cardProps6=this.props.cardProps)||void 0===_this$props$cardProps6||null===(_this$props$cardProps6=_this$props$cardProps6.cover)||void 0===_this$props$cardProps6?void 0:_this$props$cardProps6.maxHeight}px`
                        }
                        if (null !== (_this$props$cardProps7 = this.props.cardProps) && void 0 !== _this$props$cardProps7 && null !== (_this$props$cardProps7 = _this$props$cardProps7.cover) && void 0 !== _this$props$cardProps7 && _this$props$cardProps7.ratio) {
                            var _this$props$cardProps8;
                            variables["--dx-cardview-card-cover-ratio"] = `${null===(_this$props$cardProps8=this.props.cardProps)||void 0===_this$props$cardProps8||null===(_this$props$cardProps8=_this$props$cardProps8.cover)||void 0===_this$props$cardProps8?void 0:_this$props$cardProps8.ratio}`
                        }
                        return variables
                    }
                    render() {
                        const className = (0, _combine_classes.combineClasses)({
                            [CLASSES.content]: true,
                            [CLASSES.grid]: true,
                            [CLASSES.selectCheckBoxesHidden]: !!this.props.needToHiddenCheckBoxes,
                            [CLASSES.wrapEnabled]: !!this.props.wordWrapEnabled
                        });
                        const CardItem = this.props.kbnEnabled ? CardWithKbn : _card.Card;
                        this.cardElementRefs = new Array(this.props.items.length).fill(void 0).map((() => (0, _inferno.createRef)()));
                        return (0, _inferno.createComponentVNode)(2, _index.KbnNavigationContainer, {
                            enabled: this.props.kbnEnabled,
                            navigationStrategy: this.props.navigationStrategy,
                            onFocusMoved: (newIdx, element) => {
                                this.onCardFocusMoved(newIdx, element)
                            },
                            children: (0, _inferno.createVNode)(1, "div", className, this.props.items.map(((item, idx) => (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, CardItem, Object.assign({}, this.props.cardProps, {
                                elementRef: this.cardElementRefs[idx],
                                navigationIdx: idx,
                                kbnEnabled: this.props.kbnEnabled,
                                navigationStrategy: this.props.navigationStrategy,
                                keyDownConfig: {
                                    PageUp: () => {
                                        var _this$props$onPageCha, _this$props;
                                        null === (_this$props$onPageCha = (_this$props = this.props).onPageChange) || void 0 === _this$props$onPageCha || _this$props$onPageCha.call(_this$props, -1);
                                        this.focusFirstCardAfterReload = true
                                    },
                                    PageDown: () => {
                                        var _this$props$onPageCha2, _this$props2;
                                        null === (_this$props$onPageCha2 = (_this$props2 = this.props).onPageChange) || void 0 === _this$props$onPageCha2 || _this$props$onPageCha2.call(_this$props2, 1);
                                        this.focusFirstCardAfterReload = true
                                    },
                                    Space: event => {
                                        var _this$props$cardProps9, _this$props$cardProps10;
                                        null === (_this$props$cardProps9 = this.props.cardProps) || void 0 === _this$props$cardProps9 || null === (_this$props$cardProps10 = _this$props$cardProps9.selectCard) || void 0 === _this$props$cardProps10 || _this$props$cardProps10.call(_this$props$cardProps9, item, {
                                            control: (0, _utils.isCommandKeyPressed)(event),
                                            shift: event.shiftKey,
                                            needToUpdateCheckboxes: true
                                        })
                                    },
                                    "Space+shift": event => {
                                        var _this$props$cardProps11, _this$props$cardProps12;
                                        null === (_this$props$cardProps11 = this.props.cardProps) || void 0 === _this$props$cardProps11 || null === (_this$props$cardProps12 = _this$props$cardProps11.selectCard) || void 0 === _this$props$cardProps12 || _this$props$cardProps12.call(_this$props$cardProps11, item, {
                                            control: (0, _utils.isCommandKeyPressed)(event),
                                            shift: event.shiftKey,
                                            needToUpdateCheckboxes: true
                                        })
                                    },
                                    "a+ctrl": () => {
                                        var _this$props$cardProps13, _this$props$cardProps14;
                                        null === (_this$props$cardProps13 = this.props.cardProps) || void 0 === _this$props$cardProps13 || null === (_this$props$cardProps14 = _this$props$cardProps13.onSelectAllCards) || void 0 === _this$props$cardProps14 || _this$props$cardProps14.call(_this$props$cardProps13)
                                    },
                                    "f+ctrl": () => {
                                        var _this$props$cardProps15, _this$props$cardProps16;
                                        null === (_this$props$cardProps15 = this.props.cardProps) || void 0 === _this$props$cardProps15 || null === (_this$props$cardProps16 = _this$props$cardProps15.onSearchFocus) || void 0 === _this$props$cardProps16 || _this$props$cardProps16.call(_this$props$cardProps15)
                                    },
                                    "Enter+shift": () => {
                                        var _this$props$cardProps17, _this$props$cardProps18;
                                        null === (_this$props$cardProps17 = this.props.cardProps) || void 0 === _this$props$cardProps17 || null === (_this$props$cardProps18 = _this$props$cardProps17.onEdit) || void 0 === _this$props$cardProps18 || _this$props$cardProps18.call(_this$props$cardProps17, item.key, this.cardElementRefs[idx].current ?? void 0)
                                    },
                                    Delete: () => {
                                        var _this$props$cardProps19, _this$props$cardProps20;
                                        null === (_this$props$cardProps19 = this.props.cardProps) || void 0 === _this$props$cardProps19 || null === (_this$props$cardProps20 = _this$props$cardProps19.onDelete) || void 0 === _this$props$cardProps20 || _this$props$cardProps20.call(_this$props$cardProps19, item.key, this.cardElementRefs[idx].current ?? void 0)
                                    }
                                },
                                caughtEventPreventDefault: true,
                                card: item,
                                position: (0, _utils2.getPosition)(idx, this.props.cardsPerRow ?? 1),
                                onContextMenu: e => {
                                    var _this$props$showCardC, _this$props3;
                                    null === (_this$props$showCardC = (_this$props3 = this.props).showCardContextMenu) || void 0 === _this$props$showCardC || _this$props$showCardC.call(_this$props3, e, item, idx)
                                },
                                onFocusMoved: (newIdx, element) => {
                                    this.onCardFocusMoved(newIdx, element)
                                }
                            }), function(card) {
                                if ("string" === typeof card.key || "number" === typeof card.key) {
                                    return card.key
                                }
                                return
                            }(item))))), 0, {
                                style: this.getCssVariables()
                            }, null, this.containerRef)
                        })
                    }
                    updateSizesInfo() {
                        var _this$cardElementRefs, _this$props$onFirstEl, _this$props4, _this$props$onRowHeig, _this$props5, _this$props$onColumnG, _this$props6;
                        const firstCardElement = (null === (_this$cardElementRefs = this.cardElementRefs[0]) || void 0 === _this$cardElementRefs ? void 0 : _this$cardElementRefs.current) ?? void 0;
                        null === (_this$props$onFirstEl = (_this$props4 = this.props).onFirstElementChange) || void 0 === _this$props$onFirstEl || _this$props$onFirstEl.call(_this$props4, firstCardElement);
                        if (!firstCardElement || !this.containerRef.current) {
                            return
                        }
                        const cardHeight = firstCardElement.offsetHeight;
                        const rowGap = parseFloat(getComputedStyle(this.containerRef.current).rowGap);
                        const rowHeight = cardHeight + rowGap;
                        null === (_this$props$onRowHeig = (_this$props5 = this.props).onRowHeightChange) || void 0 === _this$props$onRowHeig || _this$props$onRowHeig.call(_this$props5, rowHeight);
                        const columnGap = parseFloat(getComputedStyle(this.containerRef.current).columnGap);
                        null === (_this$props$onColumnG = (_this$props6 = this.props).onColumnGapChange) || void 0 === _this$props$onColumnG || _this$props$onColumnG.call(_this$props6, columnGap)
                    }
                    componentDidMount() {
                        this.updateSizesInfo()
                    }
                    componentDidUpdate() {
                        this.handleFocusPageChange();
                        this.updateSizesInfo()
                    }
                    onCardFocusMoved(newIdx, element) {
                        var _cardProps$onFocusedC;
                        const {
                            items: items,
                            cardProps: cardProps
                        } = this.props;
                        null === cardProps || void 0 === cardProps || null === (_cardProps$onFocusedC = cardProps.onFocusedCardChanged) || void 0 === _cardProps$onFocusedC || _cardProps$onFocusedC.call(cardProps, items[newIdx], newIdx, element)
                    }
                    handleFocusPageChange() {
                        const {
                            isLoading: isLoading,
                            navigationStrategy: navigationStrategy
                        } = this.props;
                        if (!isLoading && this.focusFirstCardAfterReload) {
                            this.focusFirstCardAfterReload = false;
                            const [, newActiveItem] = navigationStrategy.getNewActiveItem((() => navigationStrategy.setActiveItem(0, true)));
                            if (newActiveItem) {
                                this.onCardFocusMoved(newActiveItem.idx, newActiveItem.element)
                            }
                        }
                    }
                }
                exports.Content = Content
            },
        2225:
            /*!**********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/viz/utils.js ***!
              \**********************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                var _utils = __webpack_require__( /*! ../__internal/viz/utils */ 49143);
                Object.keys(_utils).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _utils[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _utils[key]
                        }
                    })
                }))
            },
        2242:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/sorting/m_sorting_mixin.js ***!
              \***************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/localization/message */ 4671));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 64553));
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = Base => class extends Base {
                    _applyColumnState(options) {
                        const that = this;
                        let ariaSortState;
                        let $sortIndicator;
                        const sortingMode = that.option("sorting.mode");
                        const {
                            rootElement: rootElement
                        } = options;
                        const {
                            column: column
                        } = options;
                        const $indicatorsContainer = that._getIndicatorContainer(rootElement);
                        if ("sort" === options.name) {
                            rootElement.find(".dx-sort").remove();
                            !$indicatorsContainer.children().length && $indicatorsContainer.remove();
                            const isSortingAllowed = "none" !== sortingMode && column.allowSorting;
                            const hasSeveralSortIndexes = that.getController && !!that.getController("columns").columnOption("sortIndex:1");
                            if (!(0, _type.isDefined)(column.groupIndex) && (isSortingAllowed || (0, _type.isDefined)(column.sortOrder))) {
                                ariaSortState = "asc" === column.sortOrder ? "ascending" : "descending";
                                $sortIndicator = super._applyColumnState(options).toggleClass("dx-sort-up", "asc" === column.sortOrder).toggleClass("dx-sort-down", "desc" === column.sortOrder);
                                if (hasSeveralSortIndexes && that.option("sorting.showSortIndexes") && column.sortIndex >= 0) {
                                    (0, _renderer.default)("<span>").addClass("dx-sort-index-icon").text(column.sortIndex + 1).appendTo($sortIndicator);
                                    $sortIndicator.addClass("dx-sort-index")
                                }
                                if (isSortingAllowed) {
                                    options.rootElement.addClass(that.addWidgetPrefix("action"))
                                }
                            }
                            this._setAriaSortAttribute(column, ariaSortState, rootElement, hasSeveralSortIndexes);
                            return $sortIndicator
                        }
                        return super._applyColumnState(options)
                    }
                    _setAriaSortAttribute(column, ariaSortState, $rootElement, hasSeveralSortIndexes) {
                        $rootElement.removeAttr("aria-roledescription");
                        if (column.isGrouped) {
                            let description = this.localize("dxDataGrid-ariaNotSortedColumn");
                            if ((0, _type.isDefined)(column.sortOrder)) {
                                description = "asc" === column.sortOrder ? this.localize("dxDataGrid-ariaSortedAscendingColumn") : this.localize("dxDataGrid-ariaSortedDescendingColumn")
                            }
                            this.setAria("roledescription", description, $rootElement)
                        } else if (!(0, _type.isDefined)(column.sortOrder)) {
                            this.setAria("sort", "none", $rootElement)
                        } else {
                            this.setAria("sort", ariaSortState, $rootElement);
                            if (hasSeveralSortIndexes && column.sortIndex >= 0) {
                                const ariaColumnHeader = _message.default.format("dxDataGrid-ariaColumnHeader");
                                const ariaSortIndex = _message.default.format("dxDataGrid-ariaSortIndex", column.sortIndex + 1);
                                const description = `${ariaColumnHeader}, ${ariaSortIndex}`;
                                this.setAria("roledescription", description, $rootElement)
                            }
                        }
                    }
                    _getIndicatorClassName(name) {
                        if ("sort" === name) {
                            return "dx-sort"
                        }
                        if ("sortIndex" === name) {
                            return "dx-sort-index-icon"
                        }
                        return super._getIndicatorClassName(name)
                    }
                    _renderIndicator(options) {
                        const {
                            column: column
                        } = options;
                        const $container = options.container;
                        const $indicator = options.indicator;
                        if ("sort" === options.name) {
                            const rtlEnabled = this.option("rtlEnabled");
                            if (!(0, _type.isDefined)(column.sortOrder)) {
                                $indicator && $indicator.addClass("dx-sort-none")
                            }
                            if ($container.children().length && (!rtlEnabled && "left" === options.columnAlignment || rtlEnabled && "right" === options.columnAlignment)) {
                                $container.prepend($indicator);
                                return
                            }
                        }
                        super._renderIndicator(options)
                    }
                    _updateIndicator($cell, column, indicatorName) {
                        if ("sort" === indicatorName && (0, _type.isDefined)(column.groupIndex)) {
                            return
                        }
                        return super._updateIndicator.apply(this, arguments)
                    }
                    _getIndicatorElements($cell, returnAll) {
                        const $indicatorElements = super._getIndicatorElements($cell);
                        return returnAll ? $indicatorElements : $indicatorElements && $indicatorElements.not(".dx-sort-none")
                    }
                }
            },
        2302:
            /*!*********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/components/base/time_panel_table.js ***!
              \*********************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.TimePanelTableDefaultProps = exports.TimePanelTable = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _index = __webpack_require__( /*! ../../../../core/r1/runtime/inferno/index */ 6257);
                var _all_day_panel_title = __webpack_require__( /*! ./all_day_panel_title */ 4011);
                var _cell = __webpack_require__( /*! ./cell */ 85409);
                var _row = __webpack_require__( /*! ./row */ 21541);
                var _table = __webpack_require__( /*! ./table */ 46189);
                var _time_panel_cell = __webpack_require__( /*! ./time_panel_cell */ 88332);
                const _excluded = ["timePanelData", "viewContext", "tableRef", "timeCellTemplate"];
                const TimePanelTableDefaultProps = exports.TimePanelTableDefaultProps = {
                    timePanelData: {
                        groupedData: [],
                        leftVirtualCellCount: 0,
                        rightVirtualCellCount: 0,
                        topVirtualRowCount: 0,
                        bottomVirtualRowCount: 0
                    }
                };
                class TimePanelTable extends _index.InfernoWrapperComponent {
                    createEffects() {
                        return [(0, _index.createReRenderEffect)()]
                    }
                    render() {
                        const _this$props = this.props,
                            {
                                timePanelData: timePanelData,
                                viewContext: viewContext,
                                tableRef: tableRef,
                                timeCellTemplate: timeCellTemplate
                            } = _this$props,
                            restProps = function(r, e) {
                                if (null == r) {
                                    return {}
                                }
                                var t = {};
                                for (var n in r) {
                                    if ({}.hasOwnProperty.call(r, n)) {
                                        if (e.includes(n)) {
                                            continue
                                        }
                                        t[n] = r[n]
                                    }
                                }
                                return t
                            }(_this$props, _excluded);
                        const {
                            topVirtualRowHeight: topVirtualRowHeight,
                            bottomVirtualRowHeight: bottomVirtualRowHeight
                        } = timePanelData;
                        return (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, _table.Table, Object.assign({}, restProps, {
                            className: "dx-scheduler-time-panel",
                            topVirtualRowHeight: topVirtualRowHeight ?? 0,
                            bottomVirtualRowHeight: bottomVirtualRowHeight ?? 0,
                            virtualCellsCount: 1,
                            tableRef: tableRef,
                            children: timePanelData.groupedData.map((_ref => {
                                let {
                                    dateTable: dateTable,
                                    groupIndex: groupIndex,
                                    isGroupedAllDayPanel: isGroupedAllDayPanel,
                                    key: fragmentKey
                                } = _ref;
                                return (0, _inferno.createFragment)([isGroupedAllDayPanel && (0, _inferno.createComponentVNode)(2, _row.Row, {
                                    leftVirtualCellWidth: _row.RowDefaultProps.leftVirtualCellWidth,
                                    rightVirtualCellWidth: _row.RowDefaultProps.rightVirtualCellWidth,
                                    children: (0, _inferno.createComponentVNode)(2, _cell.CellBase, {
                                        className: "dx-scheduler-time-panel-title-cell",
                                        viewContext: viewContext,
                                        startDate: _cell.CellBaseDefaultProps.startDate,
                                        endDate: _cell.CellBaseDefaultProps.endDate,
                                        index: _cell.CellBaseDefaultProps.index,
                                        children: (0, _inferno.createComponentVNode)(2, _all_day_panel_title.AllDayPanelTitle)
                                    })
                                }), dateTable.map((_ref2 => {
                                    let {
                                        groups: groups,
                                        highlighted: highlighted,
                                        index: cellIndex,
                                        isFirstGroupCell: isFirstGroupCell,
                                        isLastGroupCell: isLastGroupCell,
                                        key: key,
                                        startDate: startDate,
                                        text: text
                                    } = _ref2;
                                    return (0, _inferno.createComponentVNode)(2, _row.Row, {
                                        className: "dx-scheduler-time-panel-row",
                                        leftVirtualCellWidth: _row.RowDefaultProps.leftVirtualCellWidth,
                                        rightVirtualCellWidth: _row.RowDefaultProps.rightVirtualCellWidth,
                                        children: (0, _inferno.createComponentVNode)(2, _time_panel_cell.TimePanelCell, {
                                            viewContext: viewContext,
                                            startDate: startDate,
                                            endDate: _cell.CellBaseDefaultProps.endDate,
                                            text: text,
                                            groups: groups,
                                            groupIndex: groupIndex,
                                            isFirstGroupCell: isFirstGroupCell,
                                            isLastGroupCell: isLastGroupCell,
                                            index: cellIndex,
                                            timeCellTemplate: timeCellTemplate,
                                            highlighted: highlighted
                                        })
                                    }, key)
                                }))], 0, fragmentKey)
                            }))
                        })))
                    }
                }
                exports.TimePanelTable = TimePanelTable;
                TimePanelTable.defaultProps = TimePanelTableDefaultProps
            },
        2308:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/list/modules/search.js ***!
              \**********************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _search_box_controller = _interopRequireDefault(__webpack_require__( /*! ../../../ui/collection/search_box_controller */ 47843));
                var _m_text_box = _interopRequireDefault(__webpack_require__( /*! ../../../ui/text_box/m_text_box */ 85968));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                _search_box_controller.default.setEditorClass(_m_text_box.default)
            },
        2425:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/diagram/ui.diagram.scroll_view.js ***!
              \*********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_widget_utils = __webpack_require__( /*! ../../../__internal/grids/pivot_grid/m_widget_utils */ 12062);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _size = __webpack_require__( /*! ../../../core/utils/size */ 57653);
                var _widget = _interopRequireDefault(__webpack_require__( /*! ../../core/widget/widget */ 89275));
                var _diagram = __webpack_require__( /*! ../../ui/diagram/diagram.importer */ 49206);
                var _scroll_view = _interopRequireDefault(__webpack_require__( /*! ../../ui/scroll_view/scroll_view */ 71100));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class DiagramScrollView extends _widget.default {
                    _init() {
                        super._init();
                        const {
                            EventDispatcher: EventDispatcher
                        } = (0, _diagram.getDiagram)();
                        this.onScroll = new EventDispatcher;
                        this._createOnCreateDiagramAction()
                    }
                    _initMarkup() {
                        super._initMarkup();
                        const $scrollViewWrapper = (0, _renderer.default)("<div>").appendTo(this.$element());
                        const options = {
                            direction: "both",
                            bounceEnabled: false,
                            scrollByContent: false,
                            onScroll: _ref => {
                                let {
                                    scrollOffset: scrollOffset
                                } = _ref;
                                this._raiseOnScroll(scrollOffset.left, scrollOffset.top)
                            }
                        };
                        const {
                            useNativeScrolling: useNativeScrolling
                        } = this.option();
                        if (void 0 !== useNativeScrolling) {
                            options.useNative = useNativeScrolling
                        }
                        this._scrollView = this._createComponent($scrollViewWrapper, _scroll_view.default, options);
                        this._onCreateDiagramAction({
                            $parent: (0, _renderer.default)(this._scrollView.content()),
                            scrollView: this
                        })
                    }
                    setScroll(left, top) {
                        var _this$_scrollView;
                        null === (_this$_scrollView = this._scrollView) || void 0 === _this$_scrollView || _this$_scrollView.scrollTo({
                            left: left,
                            top: top
                        });
                        this._raiseOnScrollWithoutPoint()
                    }
                    offsetScroll(left, top) {
                        var _this$_scrollView2;
                        null === (_this$_scrollView2 = this._scrollView) || void 0 === _this$_scrollView2 || _this$_scrollView2.scrollBy({
                            left: left,
                            top: top
                        });
                        this._raiseOnScrollWithoutPoint()
                    }
                    getSize() {
                        var _this$_scrollView3;
                        const {
                            Size: Size
                        } = (0, _diagram.getDiagram)();
                        const $element = null === (_this$_scrollView3 = this._scrollView) || void 0 === _this$_scrollView3 ? void 0 : _this$_scrollView3.$element();
                        return new Size(Math.floor((0, _size.getWidth)($element)), Math.floor((0, _size.getHeight)($element)))
                    }
                    getScrollContainer() {
                        var _this$_scrollView4;
                        return null === (_this$_scrollView4 = this._scrollView) || void 0 === _this$_scrollView4 ? void 0 : _this$_scrollView4.$element()[0]
                    }
                    getScrollBarWidth() {
                        const {
                            useNativeScrolling: useNativeScrolling
                        } = this.option();
                        return useNativeScrolling ? (0, _m_widget_utils.calculateScrollbarWidth)() : 0
                    }
                    detachEvents() {}
                    _raiseOnScroll(left, top) {
                        const {
                            Point: Point
                        } = (0, _diagram.getDiagram)();
                        this.onScroll.raise("notifyScrollChanged", (() => new Point(left, top)))
                    }
                    _raiseOnScrollWithoutPoint() {
                        const {
                            Point: Point
                        } = (0, _diagram.getDiagram)();
                        this.onScroll.raise("notifyScrollChanged", (() => {
                            var _this$_scrollView5, _this$_scrollView6;
                            return new Point(null === (_this$_scrollView5 = this._scrollView) || void 0 === _this$_scrollView5 ? void 0 : _this$_scrollView5.scrollLeft(), null === (_this$_scrollView6 = this._scrollView) || void 0 === _this$_scrollView6 ? void 0 : _this$_scrollView6.scrollTop())
                        }))
                    }
                    _createOnCreateDiagramAction() {
                        this._onCreateDiagramAction = this._createActionByOption("onCreateDiagram")
                    }
                    _optionChanged(args) {
                        const {
                            name: name
                        } = args;
                        switch (name) {
                            case "onCreateDiagram":
                                this._createOnCreateDiagramAction();
                                break;
                            case "useNativeScrolling":
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                }
                exports.default = DiagramScrollView
            },
        2607:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/events_strategy.js ***!
              \*********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "EventsStrategy", {
                    enumerable: true,
                    get: function() {
                        return _m_events_strategy.EventsStrategy
                    }
                });
                var _m_events_strategy = __webpack_require__( /*! ../__internal/core/m_events_strategy */ 14201)
            },
        2611:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/contrast.js ***!
              \********************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                const WHITE = "#ffffff";
                const BLACK = "#000000";
                exports.default = [{
                    baseThemeName: "generic.light",
                    theme: {
                        name: "generic.contrast",
                        defaultPalette: "Bright",
                        font: {
                            color: WHITE
                        },
                        backgroundColor: BLACK,
                        primaryTitleColor: WHITE,
                        secondaryTitleColor: WHITE,
                        gridColor: WHITE,
                        axisColor: WHITE,
                        export: {
                            backgroundColor: BLACK,
                            font: {
                                color: WHITE
                            },
                            button: {
                                default: {
                                    color: WHITE,
                                    borderColor: WHITE,
                                    backgroundColor: BLACK
                                },
                                hover: {
                                    color: WHITE,
                                    borderColor: WHITE,
                                    backgroundColor: "#cf00d7"
                                },
                                focus: {
                                    color: WHITE,
                                    borderColor: "#cf00d7",
                                    backgroundColor: BLACK
                                },
                                active: {
                                    color: BLACK,
                                    borderColor: WHITE,
                                    backgroundColor: WHITE
                                }
                            },
                            borderColor: WHITE,
                            menuButtonColor: BLACK,
                            activeBackgroundColor: WHITE,
                            activeColor: BLACK,
                            selectedBorderColor: "#cf00da",
                            selectedColor: "#cf00da",
                            shadowColor: "none"
                        },
                        tooltip: {
                            border: {
                                color: WHITE
                            },
                            font: {
                                color: WHITE
                            },
                            color: BLACK
                        },
                        "chart:common": {
                            commonSeriesSettings: {
                                valueErrorBar: {
                                    color: WHITE
                                },
                                hoverStyle: {
                                    hatching: {
                                        opacity: .5
                                    }
                                },
                                selectionStyle: {
                                    hatching: {
                                        opacity: .35
                                    }
                                },
                                label: {
                                    font: {
                                        color: WHITE
                                    },
                                    border: {
                                        color: WHITE
                                    }
                                }
                            }
                        },
                        "chart:common:axis": {
                            constantLineStyle: {
                                color: WHITE
                            }
                        },
                        "chart:common:annotation": {
                            font: {
                                color: WHITE
                            },
                            border: {
                                color: WHITE
                            },
                            color: BLACK
                        },
                        chart: {
                            commonSeriesSettings: {},
                            crosshair: {
                                color: "#cf00d7"
                            },
                            commonPaneSettings: {
                                backgroundColor: BLACK,
                                border: {
                                    color: WHITE
                                }
                            },
                            scrollBar: {
                                color: WHITE
                            },
                            commonAxisSettings: {
                                breakStyle: {
                                    color: "#cf00d7"
                                }
                            },
                            zoomAndPan: {
                                dragBoxStyle: {
                                    color: WHITE,
                                    opacity: .7
                                }
                            }
                        },
                        pie: {
                            commonSeriesSettings: {
                                pie: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                },
                                doughnut: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                },
                                donut: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                }
                            }
                        },
                        gauge: {
                            rangeContainer: {
                                backgroundColor: WHITE
                            },
                            valueIndicators: {
                                _default: {
                                    color: WHITE
                                },
                                rangebar: {
                                    color: WHITE,
                                    backgroundColor: BLACK
                                },
                                twocolorneedle: {
                                    secondColor: WHITE
                                },
                                trianglemarker: {
                                    color: WHITE
                                },
                                textcloud: {
                                    color: WHITE,
                                    text: {
                                        font: {
                                            color: BLACK
                                        }
                                    }
                                }
                            }
                        },
                        barGauge: {
                            backgroundColor: "#3c3c3c"
                        },
                        rangeSelector: {
                            scale: {
                                tick: {
                                    color: WHITE,
                                    opacity: .4
                                },
                                minorTick: {
                                    color: WHITE,
                                    opacity: .12
                                },
                                breakStyle: {
                                    color: "#cf00d7"
                                }
                            },
                            selectedRangeColor: "#cf00da",
                            sliderMarker: {
                                color: "#cf00da"
                            },
                            sliderHandle: {
                                color: "#cf00da",
                                opacity: 1
                            },
                            shutter: {
                                opacity: .75
                            },
                            background: {
                                color: BLACK
                            }
                        },
                        map: {
                            background: {
                                borderColor: WHITE
                            },
                            layer: {
                                label: {
                                    stroke: BLACK,
                                    font: {
                                        color: WHITE
                                    }
                                }
                            },
                            "layer:area": {
                                borderColor: BLACK,
                                color: "#686868",
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE,
                                label: {
                                    font: {
                                        opacity: 1
                                    }
                                }
                            },
                            "layer:line": {
                                color: "#267cff",
                                hoveredColor: "#f613ff",
                                selectedColor: WHITE
                            },
                            "layer:marker:dot": {
                                borderColor: BLACK,
                                color: "#f8ca00",
                                backColor: BLACK,
                                backOpacity: .32
                            },
                            "layer:marker:bubble": {
                                color: "#f8ca00",
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE
                            },
                            "layer:marker:pie": {
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE
                            },
                            controlBar: {
                                borderColor: WHITE,
                                color: BLACK,
                                opacity: .3
                            }
                        },
                        treeMap: {
                            tile: {
                                color: "#70c92f"
                            },
                            group: {
                                color: "#797979",
                                label: {
                                    font: {
                                        color: WHITE
                                    }
                                }
                            }
                        },
                        sparkline: {
                            pointColor: BLACK
                        },
                        bullet: {},
                        polar: {
                            commonSeriesSettings: {}
                        },
                        funnel: {
                            label: {
                                connector: {
                                    opacity: 1
                                }
                            }
                        },
                        sankey: {
                            label: {
                                font: {
                                    color: WHITE
                                },
                                shadow: {
                                    opacity: 0
                                }
                            },
                            node: {
                                border: {
                                    visible: true,
                                    width: 1,
                                    color: WHITE
                                }
                            },
                            link: {
                                opacity: .5,
                                border: {
                                    visible: true,
                                    width: 1,
                                    color: WHITE
                                },
                                hoverStyle: {
                                    opacity: .9
                                }
                            }
                        }
                    }
                }, {
                    baseThemeName: "generic.contrast",
                    theme: {
                        name: "generic.contrast.compact"
                    }
                }]
            },
        2639:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/gantt/ui.gantt.treelist.nodes_state.js ***!
              \**************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GanttTreeListNodesState = exports.GanttTreeListNodeState = void 0;
                class GanttTreeListNodeState {
                    constructor(treeListNode) {
                        var _treeListNode$parent;
                        this.collapsed = false;
                        this.key = treeListNode.key;
                        this.children = treeListNode.children.map((node => node.key));
                        this.parentKey = null === (_treeListNode$parent = treeListNode.parent) || void 0 === _treeListNode$parent ? void 0 : _treeListNode$parent.key
                    }
                    hasChildren() {
                        return this.children.length > 0
                    }
                    removeChild(state) {
                        const index = this.children.indexOf(state.key);
                        if (index > -1) {
                            this.children = this.children.splice(index, 1)
                        }
                    }
                    equal(state) {
                        if (!state || state.key !== this.key || state.parentKey !== this.parentKey) {
                            return false
                        }
                        if (this.children.length !== state.children.length || this.children.some(((value, index) => value !== state.children[index]))) {
                            return false
                        }
                        return true
                    }
                }
                exports.GanttTreeListNodeState = GanttTreeListNodeState;
                exports.GanttTreeListNodesState = class {
                    constructor() {
                        this._resetHash()
                    }
                    clear() {
                        this._resetHash()
                    }
                    applyNodes(nodes, rootValue) {
                        if (this._rootValue !== rootValue) {
                            this._resetHash();
                            this._rootValue = rootValue
                        }
                        this._removeNonExistentNodes(nodes.map((node => node.key)));
                        nodes.forEach((node => this._applyNode(node)));
                        this._validateHash()
                    }
                    saveExpandedState(expandedKeys) {
                        this._hasCollapsed = false;
                        this._forEachState((state => {
                            if (state.hasChildren() && !expandedKeys.includes(state.key)) {
                                state.collapsed = true;
                                this._hasCollapsed = true
                            }
                        }))
                    }
                    getExpandedKeys() {
                        if (this._hasCollapsed) {
                            const keys = [];
                            this._forEachState((state => {
                                if (state.hasChildren() && !state.collapsed) {
                                    keys.push(state.key)
                                }
                            }));
                            return keys
                        }
                        return null
                    }
                    _resetHash() {
                        this._nodeHash = {};
                        this._hasCollapsed = false
                    }
                    _getNodeState(key) {
                        return this._nodeHash[key]
                    }
                    _removeNonExistentNodes(existingKeys) {
                        if (existingKeys) {
                            this._forEachState((state => {
                                if (!existingKeys.includes(state.key)) {
                                    this._removeStateWithChildren(state)
                                }
                            }))
                        }
                    }
                    _removeStateWithChildren(key) {
                        const state = this._getNodeState(key);
                        if (state) {
                            var _this$_nodeHash;
                            state.children.forEach((child => this._removeStateWithChildren(child)));
                            const parent = this._getNodeState(state.parentKey);
                            if (parent) {
                                parent.removeChild(state)
                            }
                            null === (_this$_nodeHash = this._nodeHash) || void 0 === _this$_nodeHash || delete _this$_nodeHash[key]
                        }
                    }
                    _applyNode(node) {
                        const nodeState = new GanttTreeListNodeState(node);
                        const oldState = this._getNodeState(node.key);
                        if (!(null !== oldState && void 0 !== oldState && oldState.equal(nodeState))) {
                            this._nodeHash[node.key] = nodeState;
                            this._expandTreelineToNode(node.key)
                        }
                    }
                    _expandTreelineToNode(key) {
                        const state = this._getNodeState(key);
                        let parent = this._getNodeState(null === state || void 0 === state ? void 0 : state.parentKey);
                        while (parent) {
                            parent.collapsed = false;
                            parent = this._getNodeState(parent.parentKey)
                        }
                    }
                    _validateHash() {
                        Object.keys(this._nodeHash).forEach((key => {
                            const state = this._getNodeState(key);
                            const parentKey = null === state || void 0 === state ? void 0 : state.parentKey;
                            if (parentKey !== this._rootValue && !this._getNodeState(parentKey)) {
                                this._removeStateWithChildren(key)
                            }
                        }))
                    }
                    _forEachState(callback) {
                        Object.keys(this._nodeHash).forEach((key => {
                            var _this$_nodeHash2;
                            const state = null === (_this$_nodeHash2 = this._nodeHash) || void 0 === _this$_nodeHash2 ? void 0 : _this$_nodeHash2[key];
                            if (state) {
                                callback(state)
                            }
                        }))
                    }
                }
            },
        2739:
            /*!************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/date_box.js ***!
              \************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_date_box = (e = __webpack_require__( /*! ../__internal/ui/date_box/m_date_box */ 92782), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _m_date_box.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        2765:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/tree_list/module_not_extended/header_panel.js ***!
              \************************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_header_panel = __webpack_require__( /*! ../../../grids/grid_core/header_panel/m_header_panel */ 5542);
                var _m_core = (e = __webpack_require__( /*! ../m_core */ 99477), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                _m_core.default.registerModule("headerPanel", _m_header_panel.headerPanelModule)
            },
        2836:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/runtime/inferno/effect.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffect = void 0;
                exports.InfernoEffect = class {
                    constructor(effect, dependency) {
                        this.dependency = dependency;
                        this.effect = effect;
                        this.destroy = effect()
                    }
                    update(dependency) {
                        const currentDependency = this.dependency;
                        if (dependency) {
                            this.dependency = dependency
                        }
                        if (!dependency || dependency.some(((d, i) => currentDependency[i] !== d))) {
                            this.dispose();
                            this.destroy = this.effect()
                        }
                    }
                    dispose() {
                        if (this.destroy) {
                            this.destroy()
                        }
                    }
                }
            },
        2850:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/toolbar.js ***!
              \***********************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _ui = (e = __webpack_require__( /*! ./toolbar/ui.toolbar */ 8062), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _ui.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        2942:
            /*!*****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/file_manager/ui.file_manager.item_list.js ***!
              \*****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../common/core/events/core/events_engine */ 92774));
                var _double_click = __webpack_require__( /*! ../../../common/core/events/double_click */ 5636);
                var _index = __webpack_require__( /*! ../../../common/core/events/utils/index */ 98834);
                var _custom_store = __webpack_require__( /*! ../../../common/data/custom_store */ 63326);
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../../core/devices */ 65951));
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _icon = __webpack_require__( /*! ../../../core/utils/icon */ 69629);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                var _widget = _interopRequireDefault(__webpack_require__( /*! ../../core/widget/widget */ 89275));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class FileManagerItemListBase extends _widget.default {
                    _init() {
                        this._initActions();
                        this._lockFocusedItemProcessing = false;
                        this._focusedItemKey = this.option("focusedItemKey");
                        super._init()
                    }
                    _initMarkup() {
                        this._needResetScrollPosition = false;
                        this.$element().addClass("dx-filemanager-files-view");
                        const dblClickEventName = (0, _index.addNamespace)(_double_click.name, "dxFileManager_open");
                        _events_engine.default.on(this.$element(), dblClickEventName, this._getItemSelector(), this._onItemDblClick.bind(this));
                        super._initMarkup()
                    }
                    _initActions() {
                        this._actions = {
                            onError: this._createActionByOption("onError"),
                            onSelectionChanged: this._createActionByOption("onSelectionChanged"),
                            onFocusedItemChanged: this._createActionByOption("onFocusedItemChanged"),
                            onSelectedItemOpened: this._createActionByOption("onSelectedItemOpened"),
                            onContextMenuShowing: this._createActionByOption("onContextMenuShowing"),
                            onItemListDataLoaded: this._createActionByOption("onItemListDataLoaded")
                        }
                    }
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            selectionMode: "single",
                            selectedItemKeys: [],
                            focusedItemKey: void 0,
                            contextMenu: void 0,
                            getItems: void 0,
                            getItemThumbnail: void 0,
                            onError: void 0,
                            onSelectionChanged: void 0,
                            onFocusedItemChanged: void 0,
                            onSelectedItemOpened: void 0,
                            onContextMenuShowing: void 0
                        })
                    }
                    _optionChanged(args) {
                        const {
                            name: name
                        } = args;
                        switch (name) {
                            case "selectionMode":
                            case "contextMenu":
                            case "getItems":
                            case "getItemThumbnail":
                                this.repaint();
                                break;
                            case "selectedItemKeys":
                                this._setSelectedItemKeys(args.value);
                                break;
                            case "focusedItemKey":
                                if (!this._lockFocusedItemProcessing) {
                                    this._setFocusedItemKey(args.value)
                                }
                                break;
                            case "onError":
                            case "onSelectedItemOpened":
                            case "onSelectionChanged":
                            case "onFocusedItemChanged":
                            case "onContextMenuShowing":
                            case "onItemListDataLoaded":
                                this._actions[name] = this._createActionByOption(name);
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                    _getItems() {
                        return this._getItemsInternal().done((itemInfos => {
                            this._itemCount = itemInfos.length;
                            if (0 === this._itemCount) {
                                this._resetFocus()
                            }
                            const parentDirectoryItem = this._findParentDirectoryItem(itemInfos);
                            this._hasParentDirectoryItem = !!parentDirectoryItem;
                            this._parentDirectoryItemKey = parentDirectoryItem ? parentDirectoryItem.fileItem.key : null
                        })).always((() => {
                            this._onDataLoaded()
                        }))
                    }
                    _getItemsInternal() {
                        const {
                            getItems: itemsGetter
                        } = this.option();
                        const itemsResult = itemsGetter ? itemsGetter() : [];
                        return (0, _deferred.when)(itemsResult)
                    }
                    _raiseOnError(error) {
                        var _this$_actions$onErro, _this$_actions;
                        null === (_this$_actions$onErro = (_this$_actions = this._actions).onError) || void 0 === _this$_actions$onErro || _this$_actions$onErro.call(_this$_actions, {
                            error: error
                        })
                    }
                    _raiseSelectionChanged(args) {
                        var _this$_actions$onSele, _this$_actions2;
                        null === (_this$_actions$onSele = (_this$_actions2 = this._actions).onSelectionChanged) || void 0 === _this$_actions$onSele || _this$_actions$onSele.call(_this$_actions2, args)
                    }
                    _raiseFocusedItemChanged(args) {
                        var _this$_actions$onFocu, _this$_actions3;
                        null === (_this$_actions$onFocu = (_this$_actions3 = this._actions).onFocusedItemChanged) || void 0 === _this$_actions$onFocu || _this$_actions$onFocu.call(_this$_actions3, args)
                    }
                    _raiseSelectedItemOpened(fileItemInfo) {
                        var _this$_actions$onSele2, _this$_actions4;
                        null === (_this$_actions$onSele2 = (_this$_actions4 = this._actions).onSelectedItemOpened) || void 0 === _this$_actions$onSele2 || _this$_actions$onSele2.call(_this$_actions4, {
                            fileItemInfo: fileItemInfo
                        })
                    }
                    _raiseContextMenuShowing(e) {
                        var _this$_actions$onCont, _this$_actions5;
                        null === (_this$_actions$onCont = (_this$_actions5 = this._actions).onContextMenuShowing) || void 0 === _this$_actions$onCont || _this$_actions$onCont.call(_this$_actions5, e)
                    }
                    _raiseItemListDataLoaded() {
                        var _this$_actions$onItem, _this$_actions6;
                        null === (_this$_actions$onItem = (_this$_actions6 = this._actions).onItemListDataLoaded) || void 0 === _this$_actions$onItem || _this$_actions$onItem.call(_this$_actions6)
                    }
                    _onDataLoaded() {
                        var _this$_refreshDeferre;
                        this._raiseItemListDataLoaded();
                        null === (_this$_refreshDeferre = this._refreshDeferred) || void 0 === _this$_refreshDeferre || _this$_refreshDeferre.resolve()
                    }
                    _onContentReady() {
                        if (this._needResetScrollPosition) {
                            this._resetScrollTopPosition();
                            this._needResetScrollPosition = false
                        }
                    }
                    _tryRaiseSelectionChanged(_ref) {
                        let {
                            selectedItemInfos: selectedItemInfos,
                            selectedItems: selectedItems,
                            selectedItemKeys: selectedItemKeys,
                            currentSelectedItemKeys: currentSelectedItemKeys,
                            currentDeselectedItemKeys: currentDeselectedItemKeys
                        } = _ref;
                        const parentDirectoryItem = this._findParentDirectoryItem(this.getSelectedItems());
                        if (parentDirectoryItem) {
                            this._deselectItem(parentDirectoryItem)
                        }
                        let raiseEvent = !this._hasParentDirectoryItem;
                        raiseEvent = raiseEvent || this._hasValidKeys(currentSelectedItemKeys) || this._hasValidKeys(currentDeselectedItemKeys);
                        if (raiseEvent) {
                            selectedItemInfos = this._filterOutItemByPredicate(selectedItemInfos, (item => item.fileItem.key === this._parentDirectoryItemKey));
                            selectedItems = this._filterOutParentDirectory(selectedItems);
                            selectedItemKeys = this._filterOutParentDirectoryKey(selectedItemKeys, true);
                            currentSelectedItemKeys = this._filterOutParentDirectoryKey(currentSelectedItemKeys, true);
                            currentDeselectedItemKeys = this._filterOutParentDirectoryKey(currentDeselectedItemKeys, true);
                            this._raiseSelectionChanged({
                                selectedItemInfos: selectedItemInfos,
                                selectedItems: selectedItems,
                                selectedItemKeys: selectedItemKeys,
                                currentSelectedItemKeys: currentSelectedItemKeys,
                                currentDeselectedItemKeys: currentDeselectedItemKeys
                            })
                        }
                    }
                    _onFocusedItemChanged(args) {
                        if (this._focusedItemKey === args.itemKey) {
                            return
                        }
                        this._focusedItemKey = args.itemKey;
                        this._lockFocusedItemProcessing = true;
                        this.option("focusedItemKey", args.itemKey);
                        this._lockFocusedItemProcessing = false;
                        this._raiseFocusedItemChanged(args)
                    }
                    _resetFocus() {}
                    _resetScrollTopPosition() {
                        if (!(0, _window.hasWindow)()) {
                            return
                        }
                        setTimeout((() => {
                            var _this$_getScrollable;
                            return null === (_this$_getScrollable = this._getScrollable()) || void 0 === _this$_getScrollable ? void 0 : _this$_getScrollable.scrollTo(0)
                        }))
                    }
                    _getScrollable() {}
                    _getItemThumbnail(fileInfo) {
                        const {
                            getItemThumbnail: itemThumbnailGetter
                        } = this.option();
                        return itemThumbnailGetter ? itemThumbnailGetter(fileInfo) : {
                            thumbnail: ""
                        }
                    }
                    _getItemThumbnailContainer(fileInfo) {
                        var _getImageContainer;
                        const {
                            thumbnail: thumbnail,
                            cssClass: cssClass
                        } = this._getItemThumbnail(fileInfo);
                        const $itemThumbnail = null === (_getImageContainer = (0, _icon.getImageContainer)(thumbnail)) || void 0 === _getImageContainer ? void 0 : _getImageContainer.addClass(this._getItemThumbnailCssClass());
                        if (cssClass) {
                            null === $itemThumbnail || void 0 === $itemThumbnail || $itemThumbnail.addClass(cssClass)
                        }
                        return $itemThumbnail
                    }
                    _getItemThumbnailCssClass() {
                        return ""
                    }
                    _getItemSelector() {}
                    _onItemDblClick(e) {}
                    _isDesktop() {
                        return "desktop" === _devices.default.real().deviceType
                    }
                    _showContextMenu(items, element, event, target) {
                        this._contextMenu.showAt(items, element, event, target)
                    }
                    get _contextMenu() {
                        const {
                            contextMenu: contextMenu
                        } = this.option();
                        return contextMenu
                    }
                    _findParentDirectoryItem(itemInfos) {
                        for (let i = 0; i < itemInfos.length; i += 1) {
                            const itemInfo = itemInfos[i];
                            if (this._isParentDirectoryItem(itemInfo)) {
                                return itemInfo
                            }
                        }
                        return null
                    }
                    _getFileItemsForContextMenu(fileItem) {
                        const result = this.getSelectedItems();
                        if (this._isParentDirectoryItem(fileItem)) {
                            result.push(fileItem)
                        }
                        return result
                    }
                    _isParentDirectoryItem(itemInfo) {
                        return itemInfo.fileItem.isParentFolder
                    }
                    _hasValidKeys(keys) {
                        return keys.length > 1 || 1 === keys.length && keys[0] !== this._parentDirectoryItemKey
                    }
                    _filterOutParentDirectory(array, createNewArray) {
                        return this._filterOutItemByPredicate(array, (item => item.key === this._parentDirectoryItemKey), createNewArray)
                    }
                    _filterOutParentDirectoryKey(array, createNewArray) {
                        return this._filterOutItemByPredicate(array, (key => key === this._parentDirectoryItemKey), createNewArray)
                    }
                    _filterOutItemByPredicate(array, predicate, createNewArray) {
                        let result = array;
                        let index = -1;
                        for (let i = 0; i < array.length; i += 1) {
                            if (predicate(array[i])) {
                                index = i;
                                break
                            }
                        }
                        if (-1 !== index) {
                            if (createNewArray) {
                                result = [...array]
                            }
                            result.splice(index, 1)
                        }
                        return result
                    }
                    _isMultipleSelectionMode() {
                        const {
                            selectionMode: selectionMode
                        } = this.option();
                        return "multiple" === selectionMode
                    }
                    _deselectItem(item) {}
                    _setSelectedItemKeys(itemKeys) {}
                    _setFocusedItemKey(itemKey) {}
                    _createDataSource() {
                        return {
                            store: new _custom_store.CustomStore({
                                key: "fileItem.key",
                                load: this._getItems.bind(this)
                            })
                        }
                    }
                    getSelectedItems() {}
                    clearSelection() {}
                    selectItem() {}
                    refresh(options, operation) {}
                }
                exports.default = FileManagerItemListBase
            },
        2997:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/pivot_grid/fields_area/m_fields_area.js ***!
              \******************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.FieldsArea = void 0;
                __webpack_require__( /*! ../field_chooser/m_field_chooser_base */ 70317);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 64553));
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 21274);
                var _style = __webpack_require__( /*! ../../../../core/utils/style */ 58515);
                var _button = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/button */ 64973));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../ui/popup/ui.popup */ 10720));
                var _capitalize = __webpack_require__( /*! ../../../core/utils/capitalize */ 72928);
                var _m_area_item = __webpack_require__( /*! ../area_item/m_area_item */ 96273);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const DIV = "<div>";
                class FieldsArea extends _m_area_item.AreaItem {
                    constructor(component, area) {
                        super(component);
                        this._area = area
                    }
                    _getAreaName() {
                        return "fields"
                    }
                    _createGroupElement() {
                        return (0, _renderer.default)(DIV).addClass("dx-pivotgrid-fields-area").addClass("dx-area-fields").addClass("dx-pivotgrid-drag-action").attr("group", this._area)
                    }
                    isVisible() {
                        return !!this.option("fieldPanel.visible") && this.option(`fieldPanel.show${(0,_capitalize.capitalize)(this._area)}Fields`)
                    }
                    _renderButton(element) {
                        const that = this;
                        const container = (0, _renderer.default)("<td>").appendTo((0, _renderer.default)("<tr>").appendTo(element));
                        const button = that.component._createComponent((0, _renderer.default)(DIV).appendTo(container), _button.default, {
                            text: "Fields",
                            icon: "menu",
                            width: "auto",
                            onClick() {
                                const popup = that.tableElement().find(".dx-fields-area-popup").dxPopup("instance");
                                if (!popup.option("visible")) {
                                    popup.show()
                                }
                            }
                        });
                        button.$element().addClass("dx-pivotgrid-fields-area-hamburger")
                    }
                    _getPopupOptions(row, button) {
                        return {
                            contentTemplate: () => (0, _renderer.default)("<table>").addClass("dx-area-field-container").append((0, _renderer.default)("<thead>").addClass("dx-pivotgrid-fields-area-head").append(row)),
                            height: "auto",
                            width: "auto",
                            position: {
                                at: "left",
                                my: "left",
                                of: button
                            },
                            dragEnabled: false,
                            animation: {
                                show: {
                                    type: "pop",
                                    duration: 200
                                }
                            },
                            shading: false,
                            showTitle: false,
                            hideOnOutsideClick: true,
                            container: button.parent()
                        }
                    }
                    _renderPopup(tableElement, row) {
                        const that = this;
                        const button = tableElement.find(".dx-button");
                        const popupOptions = that._getPopupOptions(row, button);
                        const FieldChooserBase = that.component.$element().dxPivotGridFieldChooserBase("instance");
                        if (that._rowPopup) {
                            that._rowPopup.$element().remove()
                        }
                        that._rowPopup = that.component._createComponent((0, _renderer.default)(DIV).appendTo(tableElement), _ui.default, popupOptions);
                        that._rowPopup.$element().addClass("dx-fields-area-popup");
                        that._rowPopup.content().addClass("dx-pivotgrid-fields-container");
                        that._rowPopup.content().parent().attr("group", "row");
                        FieldChooserBase.subscribeToEvents(that._rowPopup.content());
                        FieldChooserBase.renderSortable(that._rowPopup.content())
                    }
                    _shouldCreateButton() {
                        return false
                    }
                    _renderTableContent(tableElement, data) {
                        const that = this;
                        const groupElement = this.groupElement();
                        const isVisible = this.isVisible();
                        const fieldChooserBase = that.component.$element().dxPivotGridFieldChooserBase("instance");
                        const head = (0, _renderer.default)("<thead>").addClass("dx-pivotgrid-fields-area-head").appendTo(tableElement);
                        const area = that._area;
                        const row = (0, _renderer.default)("<tr>");
                        groupElement.toggleClass("dx-hidden", !isVisible);
                        tableElement.addClass("dx-area-field-container");
                        if (!isVisible) {
                            return
                        }(0, _iterator.each)(data, ((index, field) => {
                            if (field.area === area && false !== field.visible) {
                                const td = (0, _renderer.default)("<td>").append(fieldChooserBase.renderField(field, "row" === field.area));
                                const indicators = td.find(".dx-column-indicators");
                                if (indicators.length && that._shouldCreateButton()) {
                                    indicators.insertAfter(indicators.next())
                                }
                                td.appendTo(row);
                                ! function(field, nextField, prevField, $container) {
                                    if (null !== prevField && void 0 !== prevField && prevField.groupName && prevField.groupName === field.groupName) {
                                        (0, _renderer.default)(DIV).addClass("dx-group-connector").addClass("dx-group-connector-prev").appendTo($container)
                                    }
                                    if (null !== nextField && void 0 !== nextField && nextField.groupName && nextField.groupName === field.groupName) {
                                        (0, _renderer.default)(DIV).addClass("dx-group-connector").addClass("dx-group-connector-next").appendTo($container)
                                    }
                                }(field, data[index + 1], data[index - 1], td)
                            }
                        }));
                        if (!row.children().length) {
                            (0, _renderer.default)("<td>").append((0, _renderer.default)(DIV).addClass("dx-empty-area-text").text(this.option(`fieldPanel.texts.${area}FieldArea`))).appendTo(row)
                        }
                        if (that._shouldCreateButton()) {
                            that._renderButton(head);
                            that._renderPopup(tableElement, row)
                        } else {
                            head.append(row)
                        }
                    }
                    setGroupWidth(value) {
                        (0, _style.setWidth)(this.groupElement(), value)
                    }
                    setGroupHeight(value) {
                        (0, _style.setHeight)(this.groupElement(), value)
                    }
                    reset() {
                        super.reset();
                        this.groupElement().css("marginTop", 0)
                    }
                    _renderVirtualContent() {}
                }
                exports.FieldsArea = FieldsArea;
                exports.default = {
                    FieldsArea: FieldsArea
                }
            },
        3011:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/form/form.layout_manager.utils.js ***!
              \*********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.EDITORS_WITHOUT_LABELS = void 0;
                exports.convertToLabelMarkOptions = convertToLabelMarkOptions;
                exports.convertToRenderFieldItemOptions = function(_ref5) {
                    let {
                        $parent: $parent,
                        rootElementCssClassList: rootElementCssClassList,
                        formOrLayoutManager: formOrLayoutManager,
                        createComponentCallback: createComponentCallback,
                        item: item,
                        template: template,
                        labelTemplate: labelTemplate,
                        name: name,
                        formLabelLocation: formLabelLocation,
                        requiredMessageTemplate: requiredMessageTemplate,
                        validationGroup: validationGroup,
                        editorValue: editorValue,
                        canAssignUndefinedValueToEditor: canAssignUndefinedValueToEditor,
                        editorValidationBoundary: editorValidationBoundary,
                        editorStylingMode: editorStylingMode,
                        showColonAfterLabel: showColonAfterLabel,
                        managerLabelLocation: managerLabelLocation,
                        itemId: itemId,
                        managerMarkOptions: managerMarkOptions,
                        labelMode: labelMode,
                        onLabelTemplateRendered: onLabelTemplateRendered
                    } = _ref5;
                    const isRequired = (0, _type.isDefined)(item.isRequired) ? item.isRequired : !!(rules = item.validationRules, null === rules || void 0 === rules ? void 0 : rules.some((rule => "required" === rule.type)));
                    var rules;
                    const isSimpleItem = item.itemType === _constants.SIMPLE_ITEM_TYPE;
                    const helpID = item.helpText ? `dx-${new _guid.default}` : null;
                    const labelOptions = function(_ref2) {
                        let {
                            item: item,
                            id: id,
                            isRequired: isRequired,
                            managerMarkOptions: managerMarkOptions,
                            showColonAfterLabel: showColonAfterLabel,
                            labelLocation: labelLocation,
                            labelTemplate: labelTemplate,
                            formLabelMode: formLabelMode,
                            onLabelTemplateRendered: onLabelTemplateRendered
                        } = _ref2;
                        const isEditorWithoutLabels = EDITORS_WITHOUT_LABELS.includes(item.editorType);
                        const labelOptions = (0, _extend.extend)({
                            showColon: showColonAfterLabel,
                            location: labelLocation,
                            id: id,
                            visible: "outside" === formLabelMode || isEditorWithoutLabels && "hidden" !== formLabelMode,
                            isRequired: isRequired
                        }, item ? item.label : {}, {
                            markOptions: convertToLabelMarkOptions(managerMarkOptions, isRequired),
                            labelTemplate: labelTemplate,
                            onLabelTemplateRendered: onLabelTemplateRendered
                        });
                        const editorsRequiringIdForLabel = ["dxRadioGroup", "dxCheckBox", "dxLookup", "dxSlider", "dxRangeSlider", "dxSwitch", "dxHtmlEditor", "dxDateRangeBox"];
                        if (editorsRequiringIdForLabel.includes(item.editorType)) {
                            labelOptions.labelID = `dx-label-${new _guid.default}`
                        }
                        if (!labelOptions.text && item.dataField) {
                            labelOptions.text = (0, _inflector.captionize)(item.dataField)
                        }
                        if (labelOptions.text) {
                            labelOptions.textWithoutColon = labelOptions.text;
                            labelOptions.text += labelOptions.showColon ? ":" : ""
                        }
                        return labelOptions
                    }({
                        item: item,
                        id: itemId,
                        isRequired: isRequired,
                        managerMarkOptions: managerMarkOptions,
                        showColonAfterLabel: showColonAfterLabel,
                        labelLocation: managerLabelLocation,
                        formLabelMode: labelMode,
                        labelTemplate: labelTemplate,
                        onLabelTemplateRendered: onLabelTemplateRendered
                    });
                    const needRenderLabel = !!labelOptions.visible && !!(labelOptions.text || labelOptions.labelTemplate && isSimpleItem);
                    const {
                        location: labelLocation,
                        labelID: labelID
                    } = labelOptions;
                    const labelNeedBaselineAlign = "top" !== labelLocation && ["dxTextArea", "dxRadioGroup", "dxCalendar", "dxHtmlEditor"].includes(item.editorType ?? "");
                    const editorOptions = function(_ref4) {
                        let {
                            $parent: $parent,
                            editorType: editorType,
                            defaultEditorName: defaultEditorName,
                            editorValue: editorValue,
                            canAssignUndefinedValueToEditor: canAssignUndefinedValueToEditor,
                            externalEditorOptions: externalEditorOptions,
                            editorInputId: editorInputId,
                            editorValidationBoundary: editorValidationBoundary,
                            editorStylingMode: editorStylingMode,
                            formLabelMode: formLabelMode,
                            labelText: labelText,
                            labelMark: labelMark
                        } = _ref4;
                        const editorOptionsWithValue = {};
                        if (void 0 !== editorValue || canAssignUndefinedValueToEditor) {
                            editorOptionsWithValue.value = editorValue
                        }
                        if (EDITORS_WITH_ARRAY_VALUE.includes(editorType)) {
                            editorOptionsWithValue.value = editorOptionsWithValue.value || []
                        }
                        let labelMode = null === externalEditorOptions || void 0 === externalEditorOptions ? void 0 : externalEditorOptions.labelMode;
                        if (!(0, _type.isDefined)(labelMode)) {
                            labelMode = "outside" === formLabelMode ? "hidden" : formLabelMode
                        }
                        const stylingMode = (null === externalEditorOptions || void 0 === externalEditorOptions ? void 0 : externalEditorOptions.stylingMode) || editorStylingMode;
                        const useSpecificLabelOptions = EDITORS_WITH_SPECIFIC_LABELS.includes(editorType);
                        const dropDownEditorOptions = function($parent, editorType, editorInputId) {
                            const isDropDownEditor = DROP_DOWN_EDITORS.includes(editorType);
                            if (!isDropDownEditor) {
                                return {}
                            }
                            return {
                                onPopupInitialized: _ref3 => {
                                    let {
                                        component: component,
                                        popup: popup
                                    } = _ref3;
                                    const {
                                        openOnFieldClick: openOnFieldClick
                                    } = component.option();
                                    const {
                                        hideOnOutsideClick: initialHideOnOutsideClick
                                    } = popup.option();
                                    if (openOnFieldClick && (0, _type.isFunction)(initialHideOnOutsideClick)) {
                                        const hideOnOutsideClick = e => {
                                            const $target = (0, _renderer.default)(e.target);
                                            const $label = $parent.find(`label[for="${editorInputId}"]`);
                                            const isLabelClicked = !!$target.closest($label).length;
                                            return !isLabelClicked && initialHideOnOutsideClick(e)
                                        };
                                        component.option("dropDownOptions", {
                                            hideOnOutsideClick: hideOnOutsideClick
                                        });
                                        popup.option({
                                            hideOnOutsideClick: hideOnOutsideClick
                                        })
                                    }
                                }
                            }
                        }($parent, editorType, editorInputId);
                        const result = (0, _extend.extend)(true, editorOptionsWithValue, externalEditorOptions, dropDownEditorOptions, {
                            inputAttr: {
                                id: editorInputId
                            },
                            validationBoundary: editorValidationBoundary,
                            stylingMode: stylingMode,
                            label: useSpecificLabelOptions ? null === externalEditorOptions || void 0 === externalEditorOptions ? void 0 : externalEditorOptions.label : labelText,
                            labelMode: labelMode,
                            labelMark: labelMark
                        });
                        if (externalEditorOptions) {
                            if (result.dataSource) {
                                result.dataSource = externalEditorOptions.dataSource
                            }
                            if (result.items) {
                                result.items = externalEditorOptions.items
                            }
                        }
                        if (defaultEditorName) {
                            if (EDITORS_WITH_MULTIPLE_INPUT_FIELDS.includes(editorType)) {
                                if ("dxRangeSlider" === editorType) {
                                    if (!result.startName) {
                                        result.startName = `${defaultEditorName}Start`
                                    }
                                    if (!result.endName) {
                                        result.endName = `${defaultEditorName}End`
                                    }
                                }
                                if ("dxDateRangeBox" === editorType) {
                                    if (!result.startDateName) {
                                        result.startDateName = `${defaultEditorName}Start`
                                    }
                                    if (!result.endDateName) {
                                        result.endDateName = `${defaultEditorName}End`
                                    }
                                }
                                return result
                            }
                            if (!result.name) {
                                result.name = defaultEditorName
                            }
                        }
                        return result
                    }({
                        $parent: $parent,
                        editorType: item.editorType,
                        editorValue: editorValue,
                        defaultEditorName: item.dataField,
                        canAssignUndefinedValueToEditor: canAssignUndefinedValueToEditor,
                        externalEditorOptions: item.editorOptions,
                        editorInputId: itemId,
                        editorValidationBoundary: editorValidationBoundary,
                        editorStylingMode: editorStylingMode,
                        formLabelMode: labelMode,
                        labelText: labelOptions.textWithoutColon,
                        labelMark: labelOptions.markOptions.showRequiredMark ? String.fromCharCode(160) + labelOptions.markOptions.requiredMark : ""
                    });
                    const needRenderOptionalMarkAsHelpText = labelOptions.markOptions.showOptionalMark && !labelOptions.visible && "hidden" !== editorOptions.labelMode && !(0, _type.isDefined)(item.helpText);
                    const helpText = needRenderOptionalMarkAsHelpText ? labelOptions.markOptions.optionalMark : item.helpText;
                    return {
                        $parent: $parent,
                        rootElementCssClassList: rootElementCssClassList,
                        formOrLayoutManager: formOrLayoutManager,
                        createComponentCallback: createComponentCallback,
                        labelOptions: labelOptions,
                        labelNeedBaselineAlign: labelNeedBaselineAlign,
                        labelLocation: labelLocation,
                        needRenderLabel: needRenderLabel,
                        item: item,
                        isSimpleItem: isSimpleItem,
                        isRequired: isRequired,
                        template: template,
                        helpID: helpID,
                        labelID: labelID,
                        name: name,
                        helpText: helpText,
                        formLabelLocation: formLabelLocation,
                        requiredMessageTemplate: requiredMessageTemplate,
                        validationGroup: validationGroup,
                        editorOptions: editorOptions
                    }
                };
                exports.getLabelMarkText = function(_ref6) {
                    let {
                        showRequiredMark: showRequiredMark,
                        requiredMark: requiredMark,
                        showOptionalMark: showOptionalMark,
                        optionalMark: optionalMark
                    } = _ref6;
                    if (!showRequiredMark && !showOptionalMark) {
                        return ""
                    }
                    return String.fromCharCode(160) + (showRequiredMark ? requiredMark : optionalMark)
                };
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../../core/guid */ 19427));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _inflector = __webpack_require__( /*! ../../../core/utils/inflector */ 53124);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _constants = __webpack_require__( /*! ../../ui/form/constants */ 96891);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const EDITORS_WITH_ARRAY_VALUE = ["dxTagBox", "dxRangeSlider", "dxDateRangeBox"];
                const EDITORS_WITH_MULTIPLE_INPUT_FIELDS = ["dxRangeSlider", "dxDateRangeBox"];
                const EDITORS_WITH_SPECIFIC_LABELS = ["dxRangeSlider", "dxSlider"];
                const EDITORS_WITHOUT_LABELS = exports.EDITORS_WITHOUT_LABELS = ["dxCalendar", "dxCheckBox", "dxHtmlEditor", "dxRadioGroup", "dxRangeSlider", "dxSlider", "dxSwitch"];
                const DROP_DOWN_EDITORS = ["dxSelectBox", "dxDropDownBox", "dxTagBox", "dxLookup", "dxAutocomplete", "dxColorBox", "dxDateBox", "dxDateRangeBox"];

                function convertToLabelMarkOptions(_ref, isRequired) {
                    let {
                        showRequiredMark: showRequiredMark,
                        requiredMark: requiredMark,
                        showOptionalMark: showOptionalMark,
                        optionalMark: optionalMark
                    } = _ref;
                    return {
                        showRequiredMark: showRequiredMark && isRequired,
                        requiredMark: requiredMark,
                        showOptionalMark: showOptionalMark && !isRequired,
                        optionalMark: optionalMark
                    }
                }
            },
        3024:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/keyboard_navigation/dom.js ***!
              \***************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GridCoreKeyboardNavigationDom = void 0;
                var _const = __webpack_require__( /*! ./const */ 24171);
                exports.GridCoreKeyboardNavigationDom = {
                    isDragCell: $cell => void 0 !== $cell.attr(_const.ATTRIBUTES.dragCell),
                    getCellToFocus: ($cellElements, columnIndex) => $cellElements.filter((columnIndex => [`[${_const.ATTRIBUTES.ariaColIndex}="${columnIndex+1}"]`, `:not([${_const.ATTRIBUTES.dragCell}])`, ":not([aria-hidden=true])"].join(""))(columnIndex)).first()
                }
            },
        3030:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/animation/position.js ***!
              \*******************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_position = (e = __webpack_require__( /*! ../../../__internal/common/core/animation/m_position */ 36972), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _m_position.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3104:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/window.js ***!
              \******************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "defaultScreenFactorFunc", {
                    enumerable: true,
                    get: function() {
                        return _m_window.defaultScreenFactorFunc
                    }
                });
                Object.defineProperty(exports, "getCurrentScreenFactor", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getCurrentScreenFactor
                    }
                });
                Object.defineProperty(exports, "getNavigator", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getNavigator
                    }
                });
                Object.defineProperty(exports, "getWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getWindow
                    }
                });
                Object.defineProperty(exports, "hasProperty", {
                    enumerable: true,
                    get: function() {
                        return _m_window.hasProperty
                    }
                });
                Object.defineProperty(exports, "hasWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.hasWindow
                    }
                });
                Object.defineProperty(exports, "setWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.setWindow
                    }
                });
                var _m_window = __webpack_require__( /*! ../../__internal/core/utils/m_window */ 14470)
            },
        3108:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/utils/themes.js ***!
              \*************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getThemeType = void 0;
                var _themes = __webpack_require__( /*! ../../../../ui/themes */ 52071);
                exports.getThemeType = () => {
                    const theme = (0, _themes.current)();
                    return {
                        isCompact: (0, _themes.isCompact)(theme),
                        isMaterial: (0, _themes.isMaterial)(theme),
                        isFluent: (0, _themes.isFluent)(theme),
                        isMaterialBased: (0, _themes.isMaterialBased)(theme)
                    }
                }
            },
        3111:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/events/m_hold.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/core/emitter */ 59e3));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/core/emitter_registrator */ 81411));
                var _index = __webpack_require__( /*! ../../common/core/events/utils/index */ 98834);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const {
                    abs: abs
                } = Math;
                const HoldEmitter = _emitter.default.inherit({
                    start(e) {
                        this._startEventData = (0, _index.eventData)(e);
                        this._startTimer(e)
                    },
                    _startTimer(e) {
                        const holdTimeout = "timeout" in this ? this.timeout : 750;
                        this._holdTimer = setTimeout((() => {
                            this._requestAccept(e);
                            this._fireEvent("dxhold", e, {
                                target: e.target
                            });
                            this._forgetAccept()
                        }), holdTimeout)
                    },
                    move(e) {
                        if (this._touchWasMoved(e)) {
                            this._cancel(e)
                        }
                    },
                    _touchWasMoved(e) {
                        const delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                        return abs(delta.x) > 5 || abs(delta.y) > 5
                    },
                    end() {
                        this._stopTimer()
                    },
                    _stopTimer() {
                        clearTimeout(this._holdTimer)
                    },
                    cancel() {
                        this._stopTimer()
                    },
                    dispose() {
                        this._stopTimer()
                    }
                });
                (0, _emitter_registrator.default)({
                    emitter: HoldEmitter,
                    bubble: true,
                    events: ["dxhold"]
                });
                exports.default = {
                    name: "dxhold"
                }
            },
        3120:
            /*!*********************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/data_source_adapter/m_data_source_adapter.js ***!
              \*********************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _array_store = _interopRequireDefault(__webpack_require__( /*! ../../../../common/data/array_store */ 80556));
                var _array_utils = __webpack_require__( /*! ../../../../common/data/array_utils */ 43792);
                var _callbacks = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/callbacks */ 84718));
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 87739);
                var _extend = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var _m_modules = _interopRequireDefault(__webpack_require__( /*! ../m_modules */ 74854));
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 53226));
                var _m_data_source_adapter_utils = __webpack_require__( /*! ./m_data_source_adapter_utils */ 39394);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class DataSourceAdapter extends _m_modules.default.Controller {
                    init(dataSource, remoteOperations) {
                        const that = this;
                        that._dataSource = dataSource;
                        that._remoteOperations = remoteOperations || {};
                        that._isLastPage = !dataSource.isLastPage();
                        that._hasLastPage = false;
                        that._currentTotalCount = 0;
                        that._cachedData = (0, _m_data_source_adapter_utils.createEmptyCachedData)();
                        that._lastOperationTypes = {};
                        that._eventsStrategy = dataSource._eventsStrategy;
                        that._totalCountCorrection = 0;
                        that._isLoadingAll = false;
                        that.changed = (0, _callbacks.default)();
                        that.loadingChanged = (0, _callbacks.default)();
                        that.loadError = (0, _callbacks.default)();
                        that.customizeStoreLoadOptions = (0, _callbacks.default)();
                        that.changing = (0, _callbacks.default)();
                        that.pushed = (0, _callbacks.default)();
                        that._dataChangedHandler = that._handleDataChanged.bind(that);
                        that._customizeStoreLoadOptionsHandler = that._handleCustomizeStoreLoadOptions.bind(that);
                        that._dataLoadedHandler = that._handleDataLoaded.bind(that);
                        that._loadingChangedHandler = that._handleLoadingChanged.bind(that);
                        that._loadErrorHandler = that._handleLoadError.bind(that);
                        that._pushHandler = that._handlePush.bind(that);
                        that._changingHandler = that._handleChanging.bind(that);
                        dataSource.on("changed", that._dataChangedHandler);
                        dataSource.on("customizeStoreLoadOptions", that._customizeStoreLoadOptionsHandler);
                        dataSource.on("customizeLoadResult", that._dataLoadedHandler);
                        dataSource.on("loadingChanged", that._loadingChangedHandler);
                        dataSource.on("loadError", that._loadErrorHandler);
                        dataSource.on("changing", that._changingHandler);
                        dataSource.store().on("beforePush", that._pushHandler);
                        (0, _iterator.each)(dataSource, ((memberName, member) => {
                            if (!that[memberName] && (0, _type.isFunction)(member)) {
                                that[memberName] = function() {
                                    return this._dataSource[memberName].apply(this._dataSource, arguments)
                                }
                            }
                        }))
                    }
                    dispose(isSharedDataSource) {
                        const dataSource = this._dataSource;
                        const store = dataSource.store();
                        dataSource.off("changed", this._dataChangedHandler);
                        dataSource.off("customizeStoreLoadOptions", this._customizeStoreLoadOptionsHandler);
                        dataSource.off("customizeLoadResult", this._dataLoadedHandler);
                        dataSource.off("loadingChanged", this._loadingChangedHandler);
                        dataSource.off("loadError", this._loadErrorHandler);
                        dataSource.off("changing", this._changingHandler);
                        store && store.off("beforePush", this._pushHandler);
                        if (!isSharedDataSource) {
                            dataSource.dispose()
                        }
                    }
                    remoteOperations() {
                        return this._remoteOperations
                    }
                    refresh(options, operationTypes) {
                        const that = this;
                        const dataSource = that._dataSource;
                        if (operationTypes.reload) {
                            that.resetCurrentTotalCount();
                            that._isLastPage = !dataSource.paginate();
                            that._hasLastPage = that._isLastPage
                        }
                    }
                    resetCurrentTotalCount() {
                        this._currentTotalCount = 0;
                        this._totalCountCorrection = 0
                    }
                    resetCache() {
                        this._cachedStoreData = void 0;
                        this._cachedPagingData = void 0
                    }
                    resetPagesCache(isLiveUpdate) {
                        this._cachedData = (0, _m_data_source_adapter_utils.createEmptyCachedData)()
                    }
                    _needClearStoreDataCache() {
                        const remoteOperations = this.remoteOperations();
                        const operationTypes = (0, _m_data_source_adapter_utils.calculateOperationTypes)(this._lastLoadOptions || {}, {});
                        const isLocalOperations = Object.keys(remoteOperations).every((operationName => !operationTypes[operationName] || !remoteOperations[operationName]));
                        return !isLocalOperations
                    }
                    push(changes, fromStore) {
                        const store = this.store();
                        if (this._needClearStoreDataCache()) {
                            this._cachedStoreData = void 0
                        }
                        this._cachedPagingData = void 0;
                        this.resetPagesCache(true);
                        if (this._cachedStoreData) {
                            (0, _array_utils.applyBatch)({
                                keyInfo: store,
                                data: this._cachedStoreData,
                                changes: changes
                            })
                        }
                        if (!fromStore) {
                            this._applyBatch(changes)
                        }
                        this.pushed.fire(changes)
                    }
                    getDataIndexGetter() {
                        if (!this._dataIndexGetter) {
                            let indexByKey;
                            let storeData;
                            const store = this.store();
                            this._dataIndexGetter = data => {
                                const isCacheUpdated = storeData && storeData !== this._cachedStoreData;
                                if (!indexByKey || isCacheUpdated) {
                                    storeData = this._cachedStoreData || [];
                                    indexByKey = {};
                                    for (let i = 0; i < storeData.length; i++) {
                                        indexByKey[(0, _common.getKeyHash)(store.keyOf(storeData[i]))] = i
                                    }
                                }
                                return indexByKey[(0, _common.getKeyHash)(store.keyOf(data))]
                            }
                        }
                        return this._dataIndexGetter
                    }
                    _getKeyInfo() {
                        return this.store()
                    }
                    _needToCopyDataObject() {
                        return true
                    }
                    _applyBatch(changes, fromStore) {
                        const keyInfo = this._getKeyInfo();
                        const dataSource = this._dataSource;
                        const groupCount = _m_utils.default.normalizeSortingInfo(this.group()).length;
                        const isReshapeMode = "reshape" === this.option("editing.refreshMode");
                        const isVirtualMode = "virtual" === this.option("scrolling.mode");
                        changes = changes.filter((change => !dataSource.paginate() || "insert" !== change.type || void 0 !== change.index));
                        const getItemCount = () => groupCount ? this.itemsCount() : this.items().length;
                        const oldItemCount = getItemCount();
                        (0, _array_utils.applyBatch)({
                            keyInfo: keyInfo,
                            data: this._items,
                            changes: changes,
                            groupCount: groupCount,
                            useInsertIndex: true,
                            skipCopying: !this._needToCopyDataObject()
                        });
                        (0, _array_utils.applyBatch)({
                            keyInfo: keyInfo,
                            data: dataSource.items(),
                            changes: changes,
                            groupCount: groupCount,
                            useInsertIndex: true,
                            skipCopying: !this._needToCopyDataObject()
                        });
                        const needUpdateTotalCountCorrection = this._currentTotalCount > 0 || (fromStore || !isReshapeMode) && isVirtualMode;
                        if (needUpdateTotalCountCorrection) {
                            this._totalCountCorrection += getItemCount() - oldItemCount
                        }
                        changes.splice(0, changes.length)
                    }
                    _handlePush(_ref) {
                        let {
                            changes: changes
                        } = _ref;
                        this.push(changes, true)
                    }
                    _handleChanging(e) {
                        this.changing.fire(e);
                        this._applyBatch(e.changes, true)
                    }
                    _needCleanCacheByOperation(operationType, remoteOperations) {
                        const operationTypesByOrder = ["filtering", "sorting", "paging"];
                        const operationTypeIndex = operationTypesByOrder.indexOf(operationType);
                        const currentOperationTypes = operationTypeIndex >= 0 ? operationTypesByOrder.slice(operationTypeIndex) : [operationType];
                        return currentOperationTypes.some((operationType => remoteOperations[operationType]))
                    }
                    _customizeRemoteOperations(options, operationTypes) {
                        let cachedStoreData = this._cachedStoreData;
                        let cachedPagingData = this._cachedPagingData;
                        let cachedData = this._cachedData;
                        if (options.storeLoadOptions.filter && !options.remoteOperations.filtering || options.storeLoadOptions.sort && !options.remoteOperations.sorting) {
                            options.remoteOperations = {
                                filtering: options.remoteOperations.filtering,
                                summary: options.remoteOperations.summary
                            }
                        }
                        if (operationTypes.fullReload) {
                            cachedStoreData = void 0;
                            cachedPagingData = void 0;
                            cachedData = (0, _m_data_source_adapter_utils.createEmptyCachedData)()
                        } else {
                            if (operationTypes.reload) {
                                cachedPagingData = void 0;
                                cachedData = (0, _m_data_source_adapter_utils.createEmptyCachedData)()
                            } else if (operationTypes.groupExpanding) {
                                cachedData = (0, _m_data_source_adapter_utils.createEmptyCachedData)()
                            }(0, _iterator.each)(operationTypes, ((operationType, value) => {
                                if (value && this._needCleanCacheByOperation(operationType, options.remoteOperations)) {
                                    cachedStoreData = void 0;
                                    cachedPagingData = void 0
                                }
                            }))
                        }
                        if (cachedPagingData) {
                            options.remoteOperations.paging = false
                        }
                        options.cachedStoreData = cachedStoreData;
                        options.cachedPagingData = cachedPagingData;
                        options.cachedData = cachedData;
                        if (!options.isCustomLoading) {
                            this._cachedStoreData = cachedStoreData;
                            this._cachedPagingData = cachedPagingData;
                            this._cachedData = cachedData
                        }
                    }
                    _handleCustomizeStoreLoadOptions(options) {
                        var _options$data;
                        this._handleDataLoading(options);
                        if (!(0 === (null === (_options$data = options.data) || void 0 === _options$data ? void 0 : _options$data.length))) {
                            options.data = (0, _m_data_source_adapter_utils.getPageDataFromCache)(options, true) || options.cachedStoreData
                        }
                    }
                    _handleDataLoading(options) {
                        const dataSource = this._dataSource;
                        const lastLoadOptions = this._lastLoadOptions;
                        this.customizeStoreLoadOptions.fire(options);
                        options.delay = this.option("loadingTimeout");
                        options.originalStoreLoadOptions = options.storeLoadOptions;
                        options.remoteOperations = (0, _extend.extend)({}, this.remoteOperations());
                        const isFullReload = !this.isLoaded() && !this._isRefreshing;
                        if (this.option("integrationOptions.renderedOnServer") && !this.isLoaded()) {
                            options.delay = void 0
                        }
                        const loadOptions = (0, _extend.extend)({
                            pageIndex: this.pageIndex(),
                            pageSize: this.pageSize()
                        }, options.storeLoadOptions);
                        const operationTypes = (0, _m_data_source_adapter_utils.calculateOperationTypes)(loadOptions, lastLoadOptions, isFullReload);
                        this._customizeRemoteOperations(options, operationTypes);
                        if (!options.isCustomLoading) {
                            const isRefreshing = this._isRefreshing;
                            options.pageIndex = dataSource.pageIndex();
                            options.lastLoadOptions = loadOptions;
                            options.operationTypes = operationTypes;
                            this._loadingOperationTypes = operationTypes;
                            this._isRefreshing = true;
                            (0, _deferred.when)(isRefreshing || this._isRefreshed || this.refresh(options, operationTypes)).done((() => {
                                if (this._lastOperationId === options.operationId) {
                                    this._isRefreshed = true;
                                    this.load().always((() => {
                                        this._isRefreshed = false
                                    }))
                                }
                            })).fail((() => {
                                dataSource.cancel(options.operationId)
                            })).always((() => {
                                this._isRefreshing = false
                            }));
                            dataSource.cancel(this._lastOperationId);
                            this._lastOperationId = options.operationId;
                            if (this._isRefreshing) {
                                dataSource.cancel(this._lastOperationId)
                            }
                        }
                        this._handleDataLoadingCore(options)
                    }
                    _handleDataLoadingCore(options) {
                        const {
                            remoteOperations: remoteOperations
                        } = options;
                        options.loadOptions = {};
                        const cachedExtra = options.cachedData.extra;
                        const localLoadOptionNames = {
                            filter: !remoteOperations.filtering,
                            sort: !remoteOperations.sorting,
                            group: !remoteOperations.grouping,
                            summary: !remoteOperations.summary,
                            skip: !remoteOperations.paging,
                            take: !remoteOperations.paging,
                            requireTotalCount: cachedExtra && "totalCount" in cachedExtra || !remoteOperations.paging,
                            langParams: !remoteOperations.filtering || !remoteOperations.sorting
                        };
                        (0, _iterator.each)(options.storeLoadOptions, ((optionName, optionValue) => {
                            if (localLoadOptionNames[optionName]) {
                                options.loadOptions[optionName] = optionValue;
                                delete options.storeLoadOptions[optionName]
                            }
                        }));
                        if (cachedExtra) {
                            options.extra = cachedExtra
                        }
                    }
                    _handleDataLoaded(options) {
                        const {
                            loadOptions: loadOptions
                        } = options;
                        const localPaging = options.remoteOperations && !options.remoteOperations.paging;
                        const {
                            cachedData: cachedData
                        } = options;
                        const {
                            storeLoadOptions: storeLoadOptions
                        } = options;
                        const needCache = false !== this.option("cacheEnabled") && storeLoadOptions;
                        const needPageCache = needCache && !options.isCustomLoading && cachedData && (!localPaging || storeLoadOptions.group);
                        const needPagingCache = needCache && localPaging;
                        const needStoreCache = needPagingCache && !options.isCustomLoading;
                        if (!loadOptions) {
                            this._dataSource.cancel(options.operationId);
                            return
                        }
                        if (localPaging) {
                            options.skip = loadOptions.skip;
                            options.take = loadOptions.take;
                            delete loadOptions.skip;
                            delete loadOptions.take
                        }
                        if (loadOptions.group) {
                            loadOptions.group = options.group || loadOptions.group
                        }
                        const groupCount = _m_utils.default.normalizeSortingInfo(options.group || storeLoadOptions.group || loadOptions.group).length;
                        if (options.cachedDataPartBegin) {
                            options.data = options.cachedDataPartBegin.concat(options.data)
                        }
                        if (options.cachedDataPartEnd) {
                            options.data = options.data.concat(options.cachedDataPartEnd)
                        }
                        if (!needPageCache || !(0, _m_data_source_adapter_utils.getPageDataFromCache)(options)) {
                            var _options$extra;
                            if (needPagingCache && options.cachedPagingData) {
                                options.data = (0, _m_data_source_adapter_utils.cloneItems)(options.cachedPagingData, groupCount)
                            } else {
                                if (needStoreCache) {
                                    if (!this._cachedStoreData) {
                                        this._cachedStoreData = (0, _m_data_source_adapter_utils.cloneItems)(options.data, _m_utils.default.normalizeSortingInfo(storeLoadOptions.group).length)
                                    } else if (options.mergeStoreLoadData) {
                                        options.data = this._cachedStoreData = this._cachedStoreData.concat(options.data)
                                    }
                                }
                                new _array_store.default(options.data).load(loadOptions).done((data => {
                                    options.data = data;
                                    if (needStoreCache) {
                                        this._cachedPagingData = (0, _m_data_source_adapter_utils.cloneItems)(options.data, groupCount)
                                    }
                                })).fail((error => {
                                    options.data = (new _deferred.Deferred).reject(error)
                                }))
                            }
                            if (loadOptions.requireTotalCount && localPaging) {
                                options.extra = (0, _type.isPlainObject)(options.extra) ? options.extra : {};
                                options.extra.totalCount = options.data.length
                            }
                            if (options.extra && options.extra.totalCount >= 0 && (false === storeLoadOptions.requireTotalCount || false === loadOptions.requireTotalCount)) {
                                options.extra.totalCount = -1
                            }
                            if (!loadOptions.data && (storeLoadOptions.requireTotalCount || ((null === (_options$extra = options.extra) || void 0 === _options$extra ? void 0 : _options$extra.totalCount) ?? -1) >= 0)) {
                                this._totalCountCorrection = 0
                            }
                            this._handleDataLoadedCore(options);
                            if (needPageCache) {
                                cachedData.extra = cachedData.extra || (0, _extend.extend)({}, options.extra);
                                (0, _deferred.when)(options.data).done((data => {
                                    (0, _m_data_source_adapter_utils.setPageDataToCache)(options, data, groupCount)
                                }))
                            }
                        }(0, _deferred.when)(options.data).done((() => {
                            if (options.lastLoadOptions) {
                                this._lastLoadOptions = options.lastLoadOptions;
                                Object.keys(options.operationTypes).forEach((operationType => {
                                    this._lastOperationTypes[operationType] = this._lastOperationTypes[operationType] || options.operationTypes[operationType]
                                }))
                            }
                        }));
                        options.storeLoadOptions = options.originalStoreLoadOptions
                    }
                    _handleDataLoadedCore(options) {
                        if (options.remoteOperations && !options.remoteOperations.paging && Array.isArray(options.data)) {
                            if (void 0 !== options.skip) {
                                options.data = options.data.slice(options.skip)
                            }
                            if (void 0 !== options.take) {
                                options.data = options.data.slice(0, options.take)
                            }
                        }
                    }
                    _handleLoadingChanged(isLoading) {
                        this.loadingChanged.fire(isLoading)
                    }
                    _handleLoadError(error) {
                        this.loadError.fire(error);
                        this.changed.fire({
                            changeType: "loadError",
                            error: error
                        })
                    }
                    _loadPageSize() {
                        return this.pageSize()
                    }
                    _handleDataChanged(args) {
                        let currentTotalCount;
                        const dataSource = this._dataSource;
                        let isLoading = false;
                        const isDataLoading = !args || (0, _type.isDefined)(args.changeType);
                        const itemsCount = this.itemsCount();
                        if (isDataLoading) {
                            this._isLastPage = !itemsCount || !this._loadPageSize() || itemsCount < this._loadPageSize();
                            if (this._isLastPage) {
                                this._hasLastPage = true
                            }
                        }
                        if (dataSource.totalCount() >= 0) {
                            if (dataSource.pageIndex() >= this.pageCount()) {
                                dataSource.pageIndex(this.pageCount() - 1);
                                this.pageIndex(dataSource.pageIndex());
                                this.resetPagesCache();
                                dataSource.load();
                                isLoading = true
                            }
                        } else if (isDataLoading) {
                            currentTotalCount = dataSource.pageIndex() * this.pageSize() + itemsCount;
                            if (currentTotalCount > this._currentTotalCount) {
                                this._currentTotalCount = currentTotalCount;
                                if (0 === dataSource.pageIndex() || !this.option("scrolling.legacyMode")) {
                                    this._totalCountCorrection = 0
                                }
                            }
                            if (0 === itemsCount && dataSource.pageIndex() >= this.pageCount()) {
                                dataSource.pageIndex(this.pageCount() - 1);
                                if ("infinite" !== this.option("scrolling.mode")) {
                                    dataSource.load();
                                    isLoading = true
                                }
                            }
                        }
                        if (!isLoading) {
                            this._operationTypes = this._lastOperationTypes;
                            this._lastOperationTypes = {};
                            this.component._optionCache = {};
                            this.changed.fire(args);
                            this.component._optionCache = void 0
                        }
                    }
                    _scheduleCustomLoadCallbacks(deferred) {
                        const that = this;
                        that._isCustomLoading = true;
                        deferred.always((() => {
                            that._isCustomLoading = false
                        }))
                    }
                    loadingOperationTypes() {
                        return this._loadingOperationTypes
                    }
                    operationTypes() {
                        return this._operationTypes
                    }
                    lastLoadOptions() {
                        return this._lastLoadOptions || {}
                    }
                    isLastPage() {
                        return this._isLastPage
                    }
                    _dataSourceTotalCount() {
                        return this._dataSource.totalCount()
                    }
                    _changeRowExpandCore(path) {}
                    changeRowExpand(path) {}
                    totalCount() {
                        return parseInt((this._currentTotalCount || this._dataSourceTotalCount()) + this._totalCountCorrection)
                    }
                    totalCountCorrection() {
                        return this._totalCountCorrection
                    }
                    items() {}
                    itemsCount() {
                        return this._dataSource.items().length
                    }
                    totalItemsCount() {
                        return this.totalCount()
                    }
                    pageSize() {
                        const dataSource = this._dataSource;
                        if (!arguments.length && !dataSource.paginate()) {
                            return 0
                        }
                        return dataSource.pageSize.apply(dataSource, arguments)
                    }
                    pageCount() {
                        const count = this.totalItemsCount() - this._totalCountCorrection;
                        const pageSize = this.pageSize();
                        if (pageSize && count > 0) {
                            return Math.max(1, Math.ceil(count / pageSize))
                        }
                        return 1
                    }
                    hasKnownLastPage() {
                        return this._hasLastPage || this._dataSource.totalCount() >= 0
                    }
                    loadFromStore(loadOptions, store) {
                        const dataSource = this._dataSource;
                        const d = new _deferred.Deferred;
                        if (!dataSource) {
                            return
                        }
                        store = store || dataSource.store();
                        store.load(loadOptions).done(((data, extra) => {
                            if (data && !Array.isArray(data) && Array.isArray(data.data)) {
                                extra = data;
                                data = data.data
                            }
                            d.resolve(data, extra)
                        })).fail(d.reject);
                        return d
                    }
                    isCustomLoading() {
                        return !!this._isCustomLoading
                    }
                    load(options) {
                        const that = this;
                        const dataSource = that._dataSource;
                        const d = new _deferred.Deferred;
                        if (options) {
                            const store = dataSource.store();
                            const dataSourceLoadOptions = dataSource.loadOptions();
                            const loadResult = {
                                storeLoadOptions: (0, _extend.extend)({}, options, {
                                    langParams: null === dataSourceLoadOptions || void 0 === dataSourceLoadOptions ? void 0 : dataSourceLoadOptions.langParams
                                }),
                                isCustomLoading: true
                            };
                            (0, _iterator.each)(store._customLoadOptions() || [], ((_, optionName) => {
                                if (!(optionName in loadResult.storeLoadOptions)) {
                                    loadResult.storeLoadOptions[optionName] = dataSourceLoadOptions[optionName]
                                }
                            }));
                            this._isLoadingAll = options.isLoadingAll;
                            that._scheduleCustomLoadCallbacks(d);
                            dataSource._scheduleLoadCallbacks(d);
                            that._handleCustomizeStoreLoadOptions(loadResult);
                            (0, _m_data_source_adapter_utils.executeTask)((() => {
                                if (!dataSource.store()) {
                                    return d.reject("canceled")
                                }(0, _deferred.when)(loadResult.data || that.loadFromStore(loadResult.storeLoadOptions)).done(((data, extra) => {
                                    loadResult.data = data;
                                    loadResult.extra = extra || {};
                                    that._handleDataLoaded(loadResult);
                                    if (options.requireTotalCount && void 0 === loadResult.extra.totalCount) {
                                        loadResult.extra.totalCount = store.totalCount(loadResult.storeLoadOptions)
                                    }(0, _deferred.when)(loadResult.data, loadResult.extra.totalCount).done(((data, totalCount) => {
                                        loadResult.extra.totalCount = totalCount;
                                        d.resolve(data, loadResult.extra)
                                    })).fail(d.reject)
                                })).fail(d.reject)
                            }), that.option("loadingTimeout"));
                            return d.fail((function() {
                                that._eventsStrategy.fireEvent("loadError", arguments)
                            })).always((() => {
                                this._isLoadingAll = false
                            })).promise()
                        }
                        return dataSource.load()
                    }
                    reload(full) {
                        return full ? this._dataSource.reload() : this._dataSource.load()
                    }
                    getCachedStoreData() {
                        return this._cachedStoreData
                    }
                    isLoaded() {}
                    pageIndex(pageIndex) {}
                }
                exports.default = DataSourceAdapter
            },
        3121:
            /*!********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/list.js ***!
              \********************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _list_light = (e = __webpack_require__( /*! ./list_light */ 80070), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                __webpack_require__( /*! ../__internal/ui/list/modules/selection */ 81400);
                __webpack_require__( /*! ../__internal/ui/list/modules/deleting */ 94660);
                __webpack_require__( /*! ../__internal/ui/list/modules/dragging */ 32061);
                __webpack_require__( /*! ../__internal/ui/list/modules/context */ 81745);
                __webpack_require__( /*! ../__internal/ui/list/modules/search */ 2308);
                exports.default = _list_light.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3122:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/ready_callbacks.js ***!
              \***************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_ready_callbacks = __webpack_require__( /*! ../../__internal/core/utils/m_ready_callbacks */ 18344);
                exports.default = _m_ready_callbacks.readyCallbacksModule;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3198:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_array_utils.js ***!
              \******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.applyBatch = applyBatch;
                exports.applyChanges = function(data, changes) {
                    let options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                    const {
                        keyExpr: keyExpr = "id",
                        immutable: immutable = true
                    } = options;
                    const keyGetter = (0, _data.compileGetter)(keyExpr);
                    const keyInfo = {
                        key: () => keyExpr,
                        keyOf: obj => keyGetter(obj)
                    };
                    return applyBatch({
                        keyInfo: keyInfo,
                        data: data,
                        changes: changes,
                        immutable: immutable,
                        disableCache: true,
                        logError: true
                    })
                };
                exports.createObjectWithChanges = createObjectWithChanges;
                exports.indexByKey = indexByKey;
                exports.insert = insert;
                exports.remove = remove;
                exports.update = update;
                var _errors = __webpack_require__( /*! ../../common/data/errors */ 82812);
                var _utils = __webpack_require__( /*! ../../common/data/utils */ 89358);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 66636));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 19427));
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _object = __webpack_require__( /*! ../../core/utils/object */ 22263);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }

                function findItems(keyInfo, items, key, groupCount) {
                    let childItems;
                    let result;
                    if (groupCount) {
                        for (let i = 0; i < items.length; i++) {
                            childItems = items[i].items || items[i].collapsedItems || [];
                            result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                            if (result) {
                                return result
                            }
                        }
                    } else if (indexByKey(keyInfo, items, key) >= 0) {
                        return items
                    }
                }

                function getItems(keyInfo, items, key, groupCount) {
                    if (groupCount) {
                        return findItems(keyInfo, items, key, groupCount) || []
                    }
                    return items
                }

                function setDataByKeyMapValue(array, key, data) {
                    if (array._dataByKeyMap) {
                        array._dataByKeyMap[JSON.stringify(key)] = data;
                        array._dataByKeyMapLength += data ? 1 : -1
                    }
                }

                function cloneInstanceWithChangedPaths(instance, changes, clonedInstances) {
                    clonedInstances = clonedInstances || new WeakMap;
                    const result = instance ? Object.create(Object.getPrototypeOf(instance)) : {};
                    if (instance) {
                        clonedInstances.set(instance, result)
                    }
                    const instanceWithoutPrototype = Object.assign({}, instance);
                    (0, _object.deepExtendArraySafe)(result, instanceWithoutPrototype, true, true, true);
                    for (const name in instanceWithoutPrototype) {
                        const value = instanceWithoutPrototype[name];
                        const change = null === changes || void 0 === changes ? void 0 : changes[name];
                        if ((0, _type.isObject)(value) && !(0, _type.isPlainObject)(value) && (0, _type.isObject)(change) && !clonedInstances.has(value)) {
                            result[name] = cloneInstanceWithChangedPaths(value, change, clonedInstances)
                        }
                    }
                    for (const name in result) {
                        const prop = result[name];
                        if ((0, _type.isObject)(prop) && clonedInstances.has(prop)) {
                            result[name] = clonedInstances.get(prop)
                        }
                    }
                    return result
                }

                function createObjectWithChanges(target, changes) {
                    const result = cloneInstanceWithChangedPaths(target, changes);
                    return (0, _object.deepExtendArraySafe)(result, changes, true, true, true)
                }

                function applyBatch(_ref) {
                    let {
                        keyInfo: keyInfo,
                        data: data,
                        changes: changes,
                        groupCount: groupCount,
                        useInsertIndex: useInsertIndex,
                        immutable: immutable,
                        disableCache: disableCache,
                        logError: logError,
                        skipCopying: skipCopying
                    } = _ref;
                    const resultItems = true === immutable ? [...data] : data;
                    changes.forEach((item => {
                        const items = "insert" === item.type ? resultItems : getItems(keyInfo, resultItems, item.key, groupCount);
                        !disableCache && function(keyInfo, array) {
                            if (keyInfo.key() && (!array._dataByKeyMap || array._dataByKeyMapLength !== array.length)) {
                                const dataByKeyMap = {};
                                const arrayLength = array.length;
                                for (let i = 0; i < arrayLength; i++) {
                                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                                }
                                array._dataByKeyMap = dataByKeyMap;
                                array._dataByKeyMapLength = arrayLength
                            }
                        }(keyInfo, items);
                        switch (item.type) {
                            case "update":
                                update(keyInfo, items, item.key, item.data, true, immutable, logError);
                                break;
                            case "insert":
                                insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true, logError, skipCopying);
                                break;
                            case "remove":
                                remove(keyInfo, items, item.key, true, logError)
                        }
                    }));
                    return resultItems
                }

                function getErrorResult(isBatch, logError, errorCode) {
                    return !isBatch ? (0, _utils.rejectedPromise)(_errors.errors.Error(errorCode)) : logError && _errors.errors.log(errorCode)
                }

                function update(keyInfo, array, key, data, isBatch, immutable, logError) {
                    let target;
                    const keyExpr = keyInfo.key();
                    if (keyExpr) {
                        if (function(target, keyOrKeys) {
                                let key;
                                const keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
                                while (keys.length) {
                                    key = keys.shift();
                                    if (key in target) {
                                        return true
                                    }
                                }
                                return false
                            }(data, keyExpr) && !(0, _utils.keysEqual)(keyExpr, key, keyInfo.keyOf(data))) {
                            return getErrorResult(isBatch, logError, "E4017")
                        }
                        target = function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                        }(array, key);
                        if (!target) {
                            const index = indexByKey(keyInfo, array, key);
                            if (index < 0) {
                                return getErrorResult(isBatch, logError, "E4009")
                            }
                            target = array[index];
                            if (true === immutable && (0, _type.isDefined)(target)) {
                                const newTarget = createObjectWithChanges(target, data);
                                array[index] = newTarget;
                                return !isBatch && (0, _utils.trivialPromise)(newTarget, key)
                            }
                        }
                    } else {
                        target = key
                    }(0, _object.deepExtendArraySafe)(target, data, true, false, true, true);
                    if (!isBatch) {
                        if ((0, _config.default)().useLegacyStoreResult) {
                            return (0, _utils.trivialPromise)(key, data)
                        }
                        return (0, _utils.trivialPromise)(target, key)
                    }
                }

                function insert(keyInfo, array, data, index, isBatch, logError, skipCopying) {
                    let keyValue;
                    const keyExpr = keyInfo.key();
                    const obj = (0, _type.isPlainObject)(data) && !skipCopying ? (0, _extend.extend)({}, data) : data;
                    if (keyExpr) {
                        keyValue = keyInfo.keyOf(obj);
                        if (void 0 === keyValue || "object" === typeof keyValue && (0, _type.isEmptyObject)(keyValue)) {
                            if (Array.isArray(keyExpr)) {
                                throw _errors.errors.Error("E4007")
                            }
                            keyValue = obj[keyExpr] = String(new _guid.default)
                        } else if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                            return getErrorResult(isBatch, logError, "E4008")
                        }
                    } else {
                        keyValue = obj
                    }
                    if (index >= 0) {
                        array.splice(index, 0, obj)
                    } else {
                        array.push(obj)
                    }
                    setDataByKeyMapValue(array, keyValue, obj);
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)((0, _config.default)().useLegacyStoreResult ? data : obj, keyValue)
                    }
                }

                function remove(keyInfo, array, key, isBatch, logError) {
                    const index = indexByKey(keyInfo, array, key);
                    if (index > -1) {
                        array.splice(index, 1);
                        setDataByKeyMapValue(array, key, null)
                    }
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)(key)
                    }
                    if (index < 0) {
                        return getErrorResult(isBatch, logError, "E4009")
                    }
                }

                function indexByKey(keyInfo, array, key) {
                    const keyExpr = keyInfo.key();
                    if (! function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                            return true
                        }(array, key)) {
                        return -1
                    }
                    for (let i = 0, arrayLength = array.length; i < arrayLength; i++) {
                        if ((0, _utils.keysEqual)(keyExpr, keyInfo.keyOf(array[i]), key)) {
                            return i
                        }
                    }
                    return -1
                }
            },
        3225:
            /*!*****************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/core/events/native_event_listener.js ***!
              \*****************************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.NativeEventListener = void 0;
                exports.NativeEventListener = class {
                    constructor() {
                        this.unsubscribeArray = []
                    }
                    add(elementRef, eventName, eventHandler) {
                        var _elementRef$current;
                        null === (_elementRef$current = elementRef.current) || void 0 === _elementRef$current || _elementRef$current.addEventListener(eventName, eventHandler);
                        this.unsubscribeArray.push((() => {
                            var _elementRef$current2;
                            null === (_elementRef$current2 = elementRef.current) || void 0 === _elementRef$current2 || _elementRef$current2.removeEventListener(eventName, eventHandler)
                        }));
                        return this
                    }
                    unsubscribe() {
                        this.unsubscribeArray.forEach((fn => fn()))
                    }
                }
            },
        3226:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_action.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.Action = void 0;
                var _renderer = (e = __webpack_require__( /*! ../../core/renderer */ 64553), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                class Action {
                    constructor(action, config) {
                        config = config || {};
                        this._action = action;
                        this._context = config.context || (0, _window.getWindow)();
                        this._beforeExecute = config.beforeExecute;
                        this._afterExecute = config.afterExecute;
                        this._component = config.component;
                        this._validatingTargetName = config.validatingTargetName;
                        const excludeValidators = this._excludeValidators = {};
                        if (config.excludeValidators) {
                            for (let i = 0; i < config.excludeValidators.length; i++) {
                                excludeValidators[config.excludeValidators[i]] = true
                            }
                        }
                    }
                    execute() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        const e = {
                            action: this._action,
                            args: Array.prototype.slice.call(args),
                            context: this._context,
                            component: this._component,
                            validatingTargetName: this._validatingTargetName,
                            cancel: false,
                            handled: false
                        };
                        const beforeExecute = this._beforeExecute;
                        const afterExecute = this._afterExecute;
                        const argsBag = e.args[0] || {};
                        if (!this._validateAction(e)) {
                            return
                        }
                        null === beforeExecute || void 0 === beforeExecute || beforeExecute.call(this._context, e);
                        if (e.cancel) {
                            return
                        }
                        const result = this._executeAction(e);
                        if (argsBag.cancel) {
                            return
                        }
                        null === afterExecute || void 0 === afterExecute || afterExecute.call(this._context, e);
                        return result
                    }
                    _validateAction(e) {
                        const excludeValidators = this._excludeValidators;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            if (!excludeValidators[name]) {
                                var _executor$validate;
                                const executor = executors[name];
                                null === (_executor$validate = executor.validate) || void 0 === _executor$validate || _executor$validate.call(executor, e);
                                if (e.cancel) {
                                    return false
                                }
                            }
                        }
                        return true
                    }
                    _executeAction(e) {
                        let result;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            var _executor$execute;
                            const executor = executors[name];
                            null === (_executor$execute = executor.execute) || void 0 === _executor$execute || _executor$execute.call(executor, e);
                            if (e.handled) {
                                result = e.result;
                                break
                            }
                        }
                        return result
                    }
                    static registerExecutor(name, executor) {
                        if ((0, _type.isPlainObject)(name)) {
                            (0, _iterator.each)(name, Action.registerExecutor);
                            return
                        }
                        Action.executors[name] = executor
                    }
                    static unregisterExecutor() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }(0, _iterator.each)(args, (function() {
                            delete Action.executors[this]
                        }))
                    }
                }
                exports.Action = Action;
                Action.executors = {};
                const createValidatorByTargetElement = condition => e => {
                    if (!e.args.length) {
                        return
                    }
                    const args = e.args[0];
                    const element = args[e.validatingTargetName] || args.element;
                    if (element && condition((0, _renderer.default)(element))) {
                        e.cancel = true
                    }
                };
                Action.registerExecutor({
                    disabled: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-disabled, .dx-state-disabled *")))
                    },
                    readOnly: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")))
                    },
                    undefined: {
                        execute: e => {
                            if (!e.action) {
                                e.result = void 0;
                                e.handled = true
                            }
                        }
                    },
                    func: {
                        execute: e => {
                            if ((0, _type.isFunction)(e.action)) {
                                e.result = e.action.call(e.context, e.args[0]);
                                e.handled = true
                            }
                        }
                    }
                });
                exports.default = Action
            },
        3234:
            /*!**********************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/components/base/group_panel_props.js ***!
              \**********************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupPanelRowDefaultProps = exports.GroupPanelCellDefaultProps = exports.GroupPanelBaseDefaultProps = void 0;
                exports.GroupPanelBaseDefaultProps = {
                    groupPanelData: {
                        groupPanelItems: [],
                        baseColSpan: 1
                    },
                    groupByDate: false,
                    styles: {}
                };
                exports.GroupPanelCellDefaultProps = {
                    id: 0,
                    text: "",
                    data: {
                        id: 0
                    },
                    className: ""
                };
                exports.GroupPanelRowDefaultProps = {
                    groupItems: [],
                    className: ""
                }
            },
        3311:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/localization/cldr-data/supplemental.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.supplementalCldr = void 0;
                // !!! AUTO-GENERATED FILE, DO NOT EDIT
                exports.supplementalCldr = {
                    supplemental: {
                        version: {
                            _unicodeVersion: "12.1.0",
                            _cldrVersion: "36"
                        },
                        likelySubtags: {
                            aa: "aa-Latn-ET",
                            aai: "aai-Latn-ZZ",
                            aak: "aak-Latn-ZZ",
                            aau: "aau-Latn-ZZ",
                            ab: "ab-Cyrl-GE",
                            abi: "abi-Latn-ZZ",
                            abq: "abq-Cyrl-ZZ",
                            abr: "abr-Latn-GH",
                            abt: "abt-Latn-ZZ",
                            aby: "aby-Latn-ZZ",
                            acd: "acd-Latn-ZZ",
                            ace: "ace-Latn-ID",
                            ach: "ach-Latn-UG",
                            ada: "ada-Latn-GH",
                            ade: "ade-Latn-ZZ",
                            adj: "adj-Latn-ZZ",
                            adp: "adp-Tibt-BT",
                            ady: "ady-Cyrl-RU",
                            adz: "adz-Latn-ZZ",
                            ae: "ae-Avst-IR",
                            aeb: "aeb-Arab-TN",
                            aey: "aey-Latn-ZZ",
                            af: "af-Latn-ZA",
                            agc: "agc-Latn-ZZ",
                            agd: "agd-Latn-ZZ",
                            agg: "agg-Latn-ZZ",
                            agm: "agm-Latn-ZZ",
                            ago: "ago-Latn-ZZ",
                            agq: "agq-Latn-CM",
                            aha: "aha-Latn-ZZ",
                            ahl: "ahl-Latn-ZZ",
                            aho: "aho-Ahom-IN",
                            ajg: "ajg-Latn-ZZ",
                            ak: "ak-Latn-GH",
                            akk: "akk-Xsux-IQ",
                            ala: "ala-Latn-ZZ",
                            ali: "ali-Latn-ZZ",
                            aln: "aln-Latn-XK",
                            alt: "alt-Cyrl-RU",
                            am: "am-Ethi-ET",
                            amm: "amm-Latn-ZZ",
                            amn: "amn-Latn-ZZ",
                            amo: "amo-Latn-NG",
                            amp: "amp-Latn-ZZ",
                            an: "an-Latn-ES",
                            anc: "anc-Latn-ZZ",
                            ank: "ank-Latn-ZZ",
                            ann: "ann-Latn-ZZ",
                            any: "any-Latn-ZZ",
                            aoj: "aoj-Latn-ZZ",
                            aom: "aom-Latn-ZZ",
                            aoz: "aoz-Latn-ID",
                            apc: "apc-Arab-ZZ",
                            apd: "apd-Arab-TG",
                            ape: "ape-Latn-ZZ",
                            apr: "apr-Latn-ZZ",
                            aps: "aps-Latn-ZZ",
                            apz: "apz-Latn-ZZ",
                            ar: "ar-Arab-EG",
                            arc: "arc-Armi-IR",
                            "arc-Nbat": "arc-Nbat-JO",
                            "arc-Palm": "arc-Palm-SY",
                            arh: "arh-Latn-ZZ",
                            arn: "arn-Latn-CL",
                            aro: "aro-Latn-BO",
                            arq: "arq-Arab-DZ",
                            ars: "ars-Arab-SA",
                            ary: "ary-Arab-MA",
                            arz: "arz-Arab-EG",
                            as: "as-Beng-IN",
                            asa: "asa-Latn-TZ",
                            ase: "ase-Sgnw-US",
                            asg: "asg-Latn-ZZ",
                            aso: "aso-Latn-ZZ",
                            ast: "ast-Latn-ES",
                            ata: "ata-Latn-ZZ",
                            atg: "atg-Latn-ZZ",
                            atj: "atj-Latn-CA",
                            auy: "auy-Latn-ZZ",
                            av: "av-Cyrl-RU",
                            avl: "avl-Arab-ZZ",
                            avn: "avn-Latn-ZZ",
                            avt: "avt-Latn-ZZ",
                            avu: "avu-Latn-ZZ",
                            awa: "awa-Deva-IN",
                            awb: "awb-Latn-ZZ",
                            awo: "awo-Latn-ZZ",
                            awx: "awx-Latn-ZZ",
                            ay: "ay-Latn-BO",
                            ayb: "ayb-Latn-ZZ",
                            az: "az-Latn-AZ",
                            "az-Arab": "az-Arab-IR",
                            "az-IQ": "az-Arab-IQ",
                            "az-IR": "az-Arab-IR",
                            "az-RU": "az-Cyrl-RU",
                            ba: "ba-Cyrl-RU",
                            bal: "bal-Arab-PK",
                            ban: "ban-Latn-ID",
                            bap: "bap-Deva-NP",
                            bar: "bar-Latn-AT",
                            bas: "bas-Latn-CM",
                            bav: "bav-Latn-ZZ",
                            bax: "bax-Bamu-CM",
                            bba: "bba-Latn-ZZ",
                            bbb: "bbb-Latn-ZZ",
                            bbc: "bbc-Latn-ID",
                            bbd: "bbd-Latn-ZZ",
                            bbj: "bbj-Latn-CM",
                            bbp: "bbp-Latn-ZZ",
                            bbr: "bbr-Latn-ZZ",
                            bcf: "bcf-Latn-ZZ",
                            bch: "bch-Latn-ZZ",
                            bci: "bci-Latn-CI",
                            bcm: "bcm-Latn-ZZ",
                            bcn: "bcn-Latn-ZZ",
                            bco: "bco-Latn-ZZ",
                            bcq: "bcq-Ethi-ZZ",
                            bcu: "bcu-Latn-ZZ",
                            bdd: "bdd-Latn-ZZ",
                            be: "be-Cyrl-BY",
                            bef: "bef-Latn-ZZ",
                            beh: "beh-Latn-ZZ",
                            bej: "bej-Arab-SD",
                            bem: "bem-Latn-ZM",
                            bet: "bet-Latn-ZZ",
                            bew: "bew-Latn-ID",
                            bex: "bex-Latn-ZZ",
                            bez: "bez-Latn-TZ",
                            bfd: "bfd-Latn-CM",
                            bfq: "bfq-Taml-IN",
                            bft: "bft-Arab-PK",
                            bfy: "bfy-Deva-IN",
                            bg: "bg-Cyrl-BG",
                            bgc: "bgc-Deva-IN",
                            bgn: "bgn-Arab-PK",
                            bgx: "bgx-Grek-TR",
                            bhb: "bhb-Deva-IN",
                            bhg: "bhg-Latn-ZZ",
                            bhi: "bhi-Deva-IN",
                            bhl: "bhl-Latn-ZZ",
                            bho: "bho-Deva-IN",
                            bhy: "bhy-Latn-ZZ",
                            bi: "bi-Latn-VU",
                            bib: "bib-Latn-ZZ",
                            big: "big-Latn-ZZ",
                            bik: "bik-Latn-PH",
                            bim: "bim-Latn-ZZ",
                            bin: "bin-Latn-NG",
                            bio: "bio-Latn-ZZ",
                            biq: "biq-Latn-ZZ",
                            bjh: "bjh-Latn-ZZ",
                            bji: "bji-Ethi-ZZ",
                            bjj: "bjj-Deva-IN",
                            bjn: "bjn-Latn-ID",
                            bjo: "bjo-Latn-ZZ",
                            bjr: "bjr-Latn-ZZ",
                            bjt: "bjt-Latn-SN",
                            bjz: "bjz-Latn-ZZ",
                            bkc: "bkc-Latn-ZZ",
                            bkm: "bkm-Latn-CM",
                            bkq: "bkq-Latn-ZZ",
                            bku: "bku-Latn-PH",
                            bkv: "bkv-Latn-ZZ",
                            blt: "blt-Tavt-VN",
                            bm: "bm-Latn-ML",
                            bmh: "bmh-Latn-ZZ",
                            bmk: "bmk-Latn-ZZ",
                            bmq: "bmq-Latn-ML",
                            bmu: "bmu-Latn-ZZ",
                            bn: "bn-Beng-BD",
                            bng: "bng-Latn-ZZ",
                            bnm: "bnm-Latn-ZZ",
                            bnp: "bnp-Latn-ZZ",
                            bo: "bo-Tibt-CN",
                            boj: "boj-Latn-ZZ",
                            bom: "bom-Latn-ZZ",
                            bon: "bon-Latn-ZZ",
                            bpy: "bpy-Beng-IN",
                            bqc: "bqc-Latn-ZZ",
                            bqi: "bqi-Arab-IR",
                            bqp: "bqp-Latn-ZZ",
                            bqv: "bqv-Latn-CI",
                            br: "br-Latn-FR",
                            bra: "bra-Deva-IN",
                            brh: "brh-Arab-PK",
                            brx: "brx-Deva-IN",
                            brz: "brz-Latn-ZZ",
                            bs: "bs-Latn-BA",
                            bsj: "bsj-Latn-ZZ",
                            bsq: "bsq-Bass-LR",
                            bss: "bss-Latn-CM",
                            bst: "bst-Ethi-ZZ",
                            bto: "bto-Latn-PH",
                            btt: "btt-Latn-ZZ",
                            btv: "btv-Deva-PK",
                            bua: "bua-Cyrl-RU",
                            buc: "buc-Latn-YT",
                            bud: "bud-Latn-ZZ",
                            bug: "bug-Latn-ID",
                            buk: "buk-Latn-ZZ",
                            bum: "bum-Latn-CM",
                            buo: "buo-Latn-ZZ",
                            bus: "bus-Latn-ZZ",
                            buu: "buu-Latn-ZZ",
                            bvb: "bvb-Latn-GQ",
                            bwd: "bwd-Latn-ZZ",
                            bwr: "bwr-Latn-ZZ",
                            bxh: "bxh-Latn-ZZ",
                            bye: "bye-Latn-ZZ",
                            byn: "byn-Ethi-ER",
                            byr: "byr-Latn-ZZ",
                            bys: "bys-Latn-ZZ",
                            byv: "byv-Latn-CM",
                            byx: "byx-Latn-ZZ",
                            bza: "bza-Latn-ZZ",
                            bze: "bze-Latn-ML",
                            bzf: "bzf-Latn-ZZ",
                            bzh: "bzh-Latn-ZZ",
                            bzw: "bzw-Latn-ZZ",
                            ca: "ca-Latn-ES",
                            can: "can-Latn-ZZ",
                            cbj: "cbj-Latn-ZZ",
                            cch: "cch-Latn-NG",
                            ccp: "ccp-Cakm-BD",
                            ce: "ce-Cyrl-RU",
                            ceb: "ceb-Latn-PH",
                            cfa: "cfa-Latn-ZZ",
                            cgg: "cgg-Latn-UG",
                            ch: "ch-Latn-GU",
                            chk: "chk-Latn-FM",
                            chm: "chm-Cyrl-RU",
                            cho: "cho-Latn-US",
                            chp: "chp-Latn-CA",
                            chr: "chr-Cher-US",
                            cic: "cic-Latn-US",
                            cja: "cja-Arab-KH",
                            cjm: "cjm-Cham-VN",
                            cjv: "cjv-Latn-ZZ",
                            ckb: "ckb-Arab-IQ",
                            ckl: "ckl-Latn-ZZ",
                            cko: "cko-Latn-ZZ",
                            cky: "cky-Latn-ZZ",
                            cla: "cla-Latn-ZZ",
                            cme: "cme-Latn-ZZ",
                            cmg: "cmg-Soyo-MN",
                            co: "co-Latn-FR",
                            cop: "cop-Copt-EG",
                            cps: "cps-Latn-PH",
                            cr: "cr-Cans-CA",
                            crh: "crh-Cyrl-UA",
                            crj: "crj-Cans-CA",
                            crk: "crk-Cans-CA",
                            crl: "crl-Cans-CA",
                            crm: "crm-Cans-CA",
                            crs: "crs-Latn-SC",
                            cs: "cs-Latn-CZ",
                            csb: "csb-Latn-PL",
                            csw: "csw-Cans-CA",
                            ctd: "ctd-Pauc-MM",
                            cu: "cu-Cyrl-RU",
                            "cu-Glag": "cu-Glag-BG",
                            cv: "cv-Cyrl-RU",
                            cy: "cy-Latn-GB",
                            da: "da-Latn-DK",
                            dad: "dad-Latn-ZZ",
                            daf: "daf-Latn-ZZ",
                            dag: "dag-Latn-ZZ",
                            dah: "dah-Latn-ZZ",
                            dak: "dak-Latn-US",
                            dar: "dar-Cyrl-RU",
                            dav: "dav-Latn-KE",
                            dbd: "dbd-Latn-ZZ",
                            dbq: "dbq-Latn-ZZ",
                            dcc: "dcc-Arab-IN",
                            ddn: "ddn-Latn-ZZ",
                            de: "de-Latn-DE",
                            ded: "ded-Latn-ZZ",
                            den: "den-Latn-CA",
                            dga: "dga-Latn-ZZ",
                            dgh: "dgh-Latn-ZZ",
                            dgi: "dgi-Latn-ZZ",
                            dgl: "dgl-Arab-ZZ",
                            dgr: "dgr-Latn-CA",
                            dgz: "dgz-Latn-ZZ",
                            dia: "dia-Latn-ZZ",
                            dje: "dje-Latn-NE",
                            dnj: "dnj-Latn-CI",
                            dob: "dob-Latn-ZZ",
                            doi: "doi-Arab-IN",
                            dop: "dop-Latn-ZZ",
                            dow: "dow-Latn-ZZ",
                            drh: "drh-Mong-CN",
                            dri: "dri-Latn-ZZ",
                            drs: "drs-Ethi-ZZ",
                            dsb: "dsb-Latn-DE",
                            dtm: "dtm-Latn-ML",
                            dtp: "dtp-Latn-MY",
                            dts: "dts-Latn-ZZ",
                            dty: "dty-Deva-NP",
                            dua: "dua-Latn-CM",
                            duc: "duc-Latn-ZZ",
                            dud: "dud-Latn-ZZ",
                            dug: "dug-Latn-ZZ",
                            dv: "dv-Thaa-MV",
                            dva: "dva-Latn-ZZ",
                            dww: "dww-Latn-ZZ",
                            dyo: "dyo-Latn-SN",
                            dyu: "dyu-Latn-BF",
                            dz: "dz-Tibt-BT",
                            dzg: "dzg-Latn-ZZ",
                            ebu: "ebu-Latn-KE",
                            ee: "ee-Latn-GH",
                            efi: "efi-Latn-NG",
                            egl: "egl-Latn-IT",
                            egy: "egy-Egyp-EG",
                            eka: "eka-Latn-ZZ",
                            eky: "eky-Kali-MM",
                            el: "el-Grek-GR",
                            ema: "ema-Latn-ZZ",
                            emi: "emi-Latn-ZZ",
                            en: "en-Latn-US",
                            "en-Shaw": "en-Shaw-GB",
                            enn: "enn-Latn-ZZ",
                            enq: "enq-Latn-ZZ",
                            eo: "eo-Latn-001",
                            eri: "eri-Latn-ZZ",
                            es: "es-Latn-ES",
                            esg: "esg-Gonm-IN",
                            esu: "esu-Latn-US",
                            et: "et-Latn-EE",
                            etr: "etr-Latn-ZZ",
                            ett: "ett-Ital-IT",
                            etu: "etu-Latn-ZZ",
                            etx: "etx-Latn-ZZ",
                            eu: "eu-Latn-ES",
                            ewo: "ewo-Latn-CM",
                            ext: "ext-Latn-ES",
                            fa: "fa-Arab-IR",
                            faa: "faa-Latn-ZZ",
                            fab: "fab-Latn-ZZ",
                            fag: "fag-Latn-ZZ",
                            fai: "fai-Latn-ZZ",
                            fan: "fan-Latn-GQ",
                            ff: "ff-Latn-SN",
                            "ff-Adlm": "ff-Adlm-GN",
                            ffi: "ffi-Latn-ZZ",
                            ffm: "ffm-Latn-ML",
                            fi: "fi-Latn-FI",
                            fia: "fia-Arab-SD",
                            fil: "fil-Latn-PH",
                            fit: "fit-Latn-SE",
                            fj: "fj-Latn-FJ",
                            flr: "flr-Latn-ZZ",
                            fmp: "fmp-Latn-ZZ",
                            fo: "fo-Latn-FO",
                            fod: "fod-Latn-ZZ",
                            fon: "fon-Latn-BJ",
                            for: "for-Latn-ZZ",
                            fpe: "fpe-Latn-ZZ",
                            fqs: "fqs-Latn-ZZ",
                            fr: "fr-Latn-FR",
                            frc: "frc-Latn-US",
                            frp: "frp-Latn-FR",
                            frr: "frr-Latn-DE",
                            frs: "frs-Latn-DE",
                            fub: "fub-Arab-CM",
                            fud: "fud-Latn-WF",
                            fue: "fue-Latn-ZZ",
                            fuf: "fuf-Latn-GN",
                            fuh: "fuh-Latn-ZZ",
                            fuq: "fuq-Latn-NE",
                            fur: "fur-Latn-IT",
                            fuv: "fuv-Latn-NG",
                            fuy: "fuy-Latn-ZZ",
                            fvr: "fvr-Latn-SD",
                            fy: "fy-Latn-NL",
                            ga: "ga-Latn-IE",
                            gaa: "gaa-Latn-GH",
                            gaf: "gaf-Latn-ZZ",
                            gag: "gag-Latn-MD",
                            gah: "gah-Latn-ZZ",
                            gaj: "gaj-Latn-ZZ",
                            gam: "gam-Latn-ZZ",
                            gan: "gan-Hans-CN",
                            gaw: "gaw-Latn-ZZ",
                            gay: "gay-Latn-ID",
                            gba: "gba-Latn-ZZ",
                            gbf: "gbf-Latn-ZZ",
                            gbm: "gbm-Deva-IN",
                            gby: "gby-Latn-ZZ",
                            gbz: "gbz-Arab-IR",
                            gcr: "gcr-Latn-GF",
                            gd: "gd-Latn-GB",
                            gde: "gde-Latn-ZZ",
                            gdn: "gdn-Latn-ZZ",
                            gdr: "gdr-Latn-ZZ",
                            geb: "geb-Latn-ZZ",
                            gej: "gej-Latn-ZZ",
                            gel: "gel-Latn-ZZ",
                            gez: "gez-Ethi-ET",
                            gfk: "gfk-Latn-ZZ",
                            ggn: "ggn-Deva-NP",
                            ghs: "ghs-Latn-ZZ",
                            gil: "gil-Latn-KI",
                            gim: "gim-Latn-ZZ",
                            gjk: "gjk-Arab-PK",
                            gjn: "gjn-Latn-ZZ",
                            gju: "gju-Arab-PK",
                            gkn: "gkn-Latn-ZZ",
                            gkp: "gkp-Latn-ZZ",
                            gl: "gl-Latn-ES",
                            glk: "glk-Arab-IR",
                            gmm: "gmm-Latn-ZZ",
                            gmv: "gmv-Ethi-ZZ",
                            gn: "gn-Latn-PY",
                            gnd: "gnd-Latn-ZZ",
                            gng: "gng-Latn-ZZ",
                            god: "god-Latn-ZZ",
                            gof: "gof-Ethi-ZZ",
                            goi: "goi-Latn-ZZ",
                            gom: "gom-Deva-IN",
                            gon: "gon-Telu-IN",
                            gor: "gor-Latn-ID",
                            gos: "gos-Latn-NL",
                            got: "got-Goth-UA",
                            grb: "grb-Latn-ZZ",
                            grc: "grc-Cprt-CY",
                            "grc-Linb": "grc-Linb-GR",
                            grt: "grt-Beng-IN",
                            grw: "grw-Latn-ZZ",
                            gsw: "gsw-Latn-CH",
                            gu: "gu-Gujr-IN",
                            gub: "gub-Latn-BR",
                            guc: "guc-Latn-CO",
                            gud: "gud-Latn-ZZ",
                            gur: "gur-Latn-GH",
                            guw: "guw-Latn-ZZ",
                            gux: "gux-Latn-ZZ",
                            guz: "guz-Latn-KE",
                            gv: "gv-Latn-IM",
                            gvf: "gvf-Latn-ZZ",
                            gvr: "gvr-Deva-NP",
                            gvs: "gvs-Latn-ZZ",
                            gwc: "gwc-Arab-ZZ",
                            gwi: "gwi-Latn-CA",
                            gwt: "gwt-Arab-ZZ",
                            gyi: "gyi-Latn-ZZ",
                            ha: "ha-Latn-NG",
                            "ha-CM": "ha-Arab-CM",
                            "ha-SD": "ha-Arab-SD",
                            hag: "hag-Latn-ZZ",
                            hak: "hak-Hans-CN",
                            ham: "ham-Latn-ZZ",
                            haw: "haw-Latn-US",
                            haz: "haz-Arab-AF",
                            hbb: "hbb-Latn-ZZ",
                            hdy: "hdy-Ethi-ZZ",
                            he: "he-Hebr-IL",
                            hhy: "hhy-Latn-ZZ",
                            hi: "hi-Deva-IN",
                            hia: "hia-Latn-ZZ",
                            hif: "hif-Latn-FJ",
                            hig: "hig-Latn-ZZ",
                            hih: "hih-Latn-ZZ",
                            hil: "hil-Latn-PH",
                            hla: "hla-Latn-ZZ",
                            hlu: "hlu-Hluw-TR",
                            hmd: "hmd-Plrd-CN",
                            hmt: "hmt-Latn-ZZ",
                            hnd: "hnd-Arab-PK",
                            hne: "hne-Deva-IN",
                            hnj: "hnj-Hmng-LA",
                            hnn: "hnn-Latn-PH",
                            hno: "hno-Arab-PK",
                            ho: "ho-Latn-PG",
                            hoc: "hoc-Deva-IN",
                            hoj: "hoj-Deva-IN",
                            hot: "hot-Latn-ZZ",
                            hr: "hr-Latn-HR",
                            hsb: "hsb-Latn-DE",
                            hsn: "hsn-Hans-CN",
                            ht: "ht-Latn-HT",
                            hu: "hu-Latn-HU",
                            hui: "hui-Latn-ZZ",
                            hy: "hy-Armn-AM",
                            hz: "hz-Latn-NA",
                            ia: "ia-Latn-001",
                            ian: "ian-Latn-ZZ",
                            iar: "iar-Latn-ZZ",
                            iba: "iba-Latn-MY",
                            ibb: "ibb-Latn-NG",
                            iby: "iby-Latn-ZZ",
                            ica: "ica-Latn-ZZ",
                            ich: "ich-Latn-ZZ",
                            id: "id-Latn-ID",
                            idd: "idd-Latn-ZZ",
                            idi: "idi-Latn-ZZ",
                            idu: "idu-Latn-ZZ",
                            ife: "ife-Latn-TG",
                            ig: "ig-Latn-NG",
                            igb: "igb-Latn-ZZ",
                            ige: "ige-Latn-ZZ",
                            ii: "ii-Yiii-CN",
                            ijj: "ijj-Latn-ZZ",
                            ik: "ik-Latn-US",
                            ikk: "ikk-Latn-ZZ",
                            ikt: "ikt-Latn-CA",
                            ikw: "ikw-Latn-ZZ",
                            ikx: "ikx-Latn-ZZ",
                            ilo: "ilo-Latn-PH",
                            imo: "imo-Latn-ZZ",
                            in: "in-Latn-ID",
                            inh: "inh-Cyrl-RU",
                            io: "io-Latn-001",
                            iou: "iou-Latn-ZZ",
                            iri: "iri-Latn-ZZ",
                            is: "is-Latn-IS",
                            it: "it-Latn-IT",
                            iu: "iu-Cans-CA",
                            iw: "iw-Hebr-IL",
                            iwm: "iwm-Latn-ZZ",
                            iws: "iws-Latn-ZZ",
                            izh: "izh-Latn-RU",
                            izi: "izi-Latn-ZZ",
                            ja: "ja-Jpan-JP",
                            jab: "jab-Latn-ZZ",
                            jam: "jam-Latn-JM",
                            jbo: "jbo-Latn-001",
                            jbu: "jbu-Latn-ZZ",
                            jen: "jen-Latn-ZZ",
                            jgk: "jgk-Latn-ZZ",
                            jgo: "jgo-Latn-CM",
                            ji: "ji-Hebr-UA",
                            jib: "jib-Latn-ZZ",
                            jmc: "jmc-Latn-TZ",
                            jml: "jml-Deva-NP",
                            jra: "jra-Latn-ZZ",
                            jut: "jut-Latn-DK",
                            jv: "jv-Latn-ID",
                            jw: "jw-Latn-ID",
                            ka: "ka-Geor-GE",
                            kaa: "kaa-Cyrl-UZ",
                            kab: "kab-Latn-DZ",
                            kac: "kac-Latn-MM",
                            kad: "kad-Latn-ZZ",
                            kai: "kai-Latn-ZZ",
                            kaj: "kaj-Latn-NG",
                            kam: "kam-Latn-KE",
                            kao: "kao-Latn-ML",
                            kbd: "kbd-Cyrl-RU",
                            kbm: "kbm-Latn-ZZ",
                            kbp: "kbp-Latn-ZZ",
                            kbq: "kbq-Latn-ZZ",
                            kbx: "kbx-Latn-ZZ",
                            kby: "kby-Arab-NE",
                            kcg: "kcg-Latn-NG",
                            kck: "kck-Latn-ZW",
                            kcl: "kcl-Latn-ZZ",
                            kct: "kct-Latn-ZZ",
                            kde: "kde-Latn-TZ",
                            kdh: "kdh-Arab-TG",
                            kdl: "kdl-Latn-ZZ",
                            kdt: "kdt-Thai-TH",
                            kea: "kea-Latn-CV",
                            ken: "ken-Latn-CM",
                            kez: "kez-Latn-ZZ",
                            kfo: "kfo-Latn-CI",
                            kfr: "kfr-Deva-IN",
                            kfy: "kfy-Deva-IN",
                            kg: "kg-Latn-CD",
                            kge: "kge-Latn-ID",
                            kgf: "kgf-Latn-ZZ",
                            kgp: "kgp-Latn-BR",
                            kha: "kha-Latn-IN",
                            khb: "khb-Talu-CN",
                            khn: "khn-Deva-IN",
                            khq: "khq-Latn-ML",
                            khs: "khs-Latn-ZZ",
                            kht: "kht-Mymr-IN",
                            khw: "khw-Arab-PK",
                            khz: "khz-Latn-ZZ",
                            ki: "ki-Latn-KE",
                            kij: "kij-Latn-ZZ",
                            kiu: "kiu-Latn-TR",
                            kiw: "kiw-Latn-ZZ",
                            kj: "kj-Latn-NA",
                            kjd: "kjd-Latn-ZZ",
                            kjg: "kjg-Laoo-LA",
                            kjs: "kjs-Latn-ZZ",
                            kjy: "kjy-Latn-ZZ",
                            kk: "kk-Cyrl-KZ",
                            "kk-AF": "kk-Arab-AF",
                            "kk-Arab": "kk-Arab-CN",
                            "kk-CN": "kk-Arab-CN",
                            "kk-IR": "kk-Arab-IR",
                            "kk-MN": "kk-Arab-MN",
                            kkc: "kkc-Latn-ZZ",
                            kkj: "kkj-Latn-CM",
                            kl: "kl-Latn-GL",
                            kln: "kln-Latn-KE",
                            klq: "klq-Latn-ZZ",
                            klt: "klt-Latn-ZZ",
                            klx: "klx-Latn-ZZ",
                            km: "km-Khmr-KH",
                            kmb: "kmb-Latn-AO",
                            kmh: "kmh-Latn-ZZ",
                            kmo: "kmo-Latn-ZZ",
                            kms: "kms-Latn-ZZ",
                            kmu: "kmu-Latn-ZZ",
                            kmw: "kmw-Latn-ZZ",
                            kn: "kn-Knda-IN",
                            knf: "knf-Latn-GW",
                            knp: "knp-Latn-ZZ",
                            ko: "ko-Kore-KR",
                            koi: "koi-Cyrl-RU",
                            kok: "kok-Deva-IN",
                            kol: "kol-Latn-ZZ",
                            kos: "kos-Latn-FM",
                            koz: "koz-Latn-ZZ",
                            kpe: "kpe-Latn-LR",
                            kpf: "kpf-Latn-ZZ",
                            kpo: "kpo-Latn-ZZ",
                            kpr: "kpr-Latn-ZZ",
                            kpx: "kpx-Latn-ZZ",
                            kqb: "kqb-Latn-ZZ",
                            kqf: "kqf-Latn-ZZ",
                            kqs: "kqs-Latn-ZZ",
                            kqy: "kqy-Ethi-ZZ",
                            kr: "kr-Latn-ZZ",
                            krc: "krc-Cyrl-RU",
                            kri: "kri-Latn-SL",
                            krj: "krj-Latn-PH",
                            krl: "krl-Latn-RU",
                            krs: "krs-Latn-ZZ",
                            kru: "kru-Deva-IN",
                            ks: "ks-Arab-IN",
                            ksb: "ksb-Latn-TZ",
                            ksd: "ksd-Latn-ZZ",
                            ksf: "ksf-Latn-CM",
                            ksh: "ksh-Latn-DE",
                            ksj: "ksj-Latn-ZZ",
                            ksr: "ksr-Latn-ZZ",
                            ktb: "ktb-Ethi-ZZ",
                            ktm: "ktm-Latn-ZZ",
                            kto: "kto-Latn-ZZ",
                            ktr: "ktr-Latn-MY",
                            ku: "ku-Latn-TR",
                            "ku-Arab": "ku-Arab-IQ",
                            "ku-LB": "ku-Arab-LB",
                            kub: "kub-Latn-ZZ",
                            kud: "kud-Latn-ZZ",
                            kue: "kue-Latn-ZZ",
                            kuj: "kuj-Latn-ZZ",
                            kum: "kum-Cyrl-RU",
                            kun: "kun-Latn-ZZ",
                            kup: "kup-Latn-ZZ",
                            kus: "kus-Latn-ZZ",
                            kv: "kv-Cyrl-RU",
                            kvg: "kvg-Latn-ZZ",
                            kvr: "kvr-Latn-ID",
                            kvx: "kvx-Arab-PK",
                            kw: "kw-Latn-GB",
                            kwj: "kwj-Latn-ZZ",
                            kwo: "kwo-Latn-ZZ",
                            kwq: "kwq-Latn-ZZ",
                            kxa: "kxa-Latn-ZZ",
                            kxc: "kxc-Ethi-ZZ",
                            kxe: "kxe-Latn-ZZ",
                            kxm: "kxm-Thai-TH",
                            kxp: "kxp-Arab-PK",
                            kxw: "kxw-Latn-ZZ",
                            kxz: "kxz-Latn-ZZ",
                            ky: "ky-Cyrl-KG",
                            "ky-Arab": "ky-Arab-CN",
                            "ky-CN": "ky-Arab-CN",
                            "ky-Latn": "ky-Latn-TR",
                            "ky-TR": "ky-Latn-TR",
                            kye: "kye-Latn-ZZ",
                            kyx: "kyx-Latn-ZZ",
                            kzj: "kzj-Latn-MY",
                            kzr: "kzr-Latn-ZZ",
                            kzt: "kzt-Latn-MY",
                            la: "la-Latn-VA",
                            lab: "lab-Lina-GR",
                            lad: "lad-Hebr-IL",
                            lag: "lag-Latn-TZ",
                            lah: "lah-Arab-PK",
                            laj: "laj-Latn-UG",
                            las: "las-Latn-ZZ",
                            lb: "lb-Latn-LU",
                            lbe: "lbe-Cyrl-RU",
                            lbu: "lbu-Latn-ZZ",
                            lbw: "lbw-Latn-ID",
                            lcm: "lcm-Latn-ZZ",
                            lcp: "lcp-Thai-CN",
                            ldb: "ldb-Latn-ZZ",
                            led: "led-Latn-ZZ",
                            lee: "lee-Latn-ZZ",
                            lem: "lem-Latn-ZZ",
                            lep: "lep-Lepc-IN",
                            leq: "leq-Latn-ZZ",
                            leu: "leu-Latn-ZZ",
                            lez: "lez-Cyrl-RU",
                            lg: "lg-Latn-UG",
                            lgg: "lgg-Latn-ZZ",
                            li: "li-Latn-NL",
                            lia: "lia-Latn-ZZ",
                            lid: "lid-Latn-ZZ",
                            lif: "lif-Deva-NP",
                            "lif-Limb": "lif-Limb-IN",
                            lig: "lig-Latn-ZZ",
                            lih: "lih-Latn-ZZ",
                            lij: "lij-Latn-IT",
                            lis: "lis-Lisu-CN",
                            ljp: "ljp-Latn-ID",
                            lki: "lki-Arab-IR",
                            lkt: "lkt-Latn-US",
                            lle: "lle-Latn-ZZ",
                            lln: "lln-Latn-ZZ",
                            lmn: "lmn-Telu-IN",
                            lmo: "lmo-Latn-IT",
                            lmp: "lmp-Latn-ZZ",
                            ln: "ln-Latn-CD",
                            lns: "lns-Latn-ZZ",
                            lnu: "lnu-Latn-ZZ",
                            lo: "lo-Laoo-LA",
                            loj: "loj-Latn-ZZ",
                            lok: "lok-Latn-ZZ",
                            lol: "lol-Latn-CD",
                            lor: "lor-Latn-ZZ",
                            los: "los-Latn-ZZ",
                            loz: "loz-Latn-ZM",
                            lrc: "lrc-Arab-IR",
                            lt: "lt-Latn-LT",
                            ltg: "ltg-Latn-LV",
                            lu: "lu-Latn-CD",
                            lua: "lua-Latn-CD",
                            luo: "luo-Latn-KE",
                            luy: "luy-Latn-KE",
                            luz: "luz-Arab-IR",
                            lv: "lv-Latn-LV",
                            lwl: "lwl-Thai-TH",
                            lzh: "lzh-Hans-CN",
                            lzz: "lzz-Latn-TR",
                            mad: "mad-Latn-ID",
                            maf: "maf-Latn-CM",
                            mag: "mag-Deva-IN",
                            mai: "mai-Deva-IN",
                            mak: "mak-Latn-ID",
                            man: "man-Latn-GM",
                            "man-GN": "man-Nkoo-GN",
                            "man-Nkoo": "man-Nkoo-GN",
                            mas: "mas-Latn-KE",
                            maw: "maw-Latn-ZZ",
                            maz: "maz-Latn-MX",
                            mbh: "mbh-Latn-ZZ",
                            mbo: "mbo-Latn-ZZ",
                            mbq: "mbq-Latn-ZZ",
                            mbu: "mbu-Latn-ZZ",
                            mbw: "mbw-Latn-ZZ",
                            mci: "mci-Latn-ZZ",
                            mcp: "mcp-Latn-ZZ",
                            mcq: "mcq-Latn-ZZ",
                            mcr: "mcr-Latn-ZZ",
                            mcu: "mcu-Latn-ZZ",
                            mda: "mda-Latn-ZZ",
                            mde: "mde-Arab-ZZ",
                            mdf: "mdf-Cyrl-RU",
                            mdh: "mdh-Latn-PH",
                            mdj: "mdj-Latn-ZZ",
                            mdr: "mdr-Latn-ID",
                            mdx: "mdx-Ethi-ZZ",
                            med: "med-Latn-ZZ",
                            mee: "mee-Latn-ZZ",
                            mek: "mek-Latn-ZZ",
                            men: "men-Latn-SL",
                            mer: "mer-Latn-KE",
                            met: "met-Latn-ZZ",
                            meu: "meu-Latn-ZZ",
                            mfa: "mfa-Arab-TH",
                            mfe: "mfe-Latn-MU",
                            mfn: "mfn-Latn-ZZ",
                            mfo: "mfo-Latn-ZZ",
                            mfq: "mfq-Latn-ZZ",
                            mg: "mg-Latn-MG",
                            mgh: "mgh-Latn-MZ",
                            mgl: "mgl-Latn-ZZ",
                            mgo: "mgo-Latn-CM",
                            mgp: "mgp-Deva-NP",
                            mgy: "mgy-Latn-TZ",
                            mh: "mh-Latn-MH",
                            mhi: "mhi-Latn-ZZ",
                            mhl: "mhl-Latn-ZZ",
                            mi: "mi-Latn-NZ",
                            mif: "mif-Latn-ZZ",
                            min: "min-Latn-ID",
                            mis: "mis-Hatr-IQ",
                            "mis-Medf": "mis-Medf-NG",
                            miw: "miw-Latn-ZZ",
                            mk: "mk-Cyrl-MK",
                            mki: "mki-Arab-ZZ",
                            mkl: "mkl-Latn-ZZ",
                            mkp: "mkp-Latn-ZZ",
                            mkw: "mkw-Latn-ZZ",
                            ml: "ml-Mlym-IN",
                            mle: "mle-Latn-ZZ",
                            mlp: "mlp-Latn-ZZ",
                            mls: "mls-Latn-SD",
                            mmo: "mmo-Latn-ZZ",
                            mmu: "mmu-Latn-ZZ",
                            mmx: "mmx-Latn-ZZ",
                            mn: "mn-Cyrl-MN",
                            "mn-CN": "mn-Mong-CN",
                            "mn-Mong": "mn-Mong-CN",
                            mna: "mna-Latn-ZZ",
                            mnf: "mnf-Latn-ZZ",
                            mni: "mni-Beng-IN",
                            mnw: "mnw-Mymr-MM",
                            mo: "mo-Latn-RO",
                            moa: "moa-Latn-ZZ",
                            moe: "moe-Latn-CA",
                            moh: "moh-Latn-CA",
                            mos: "mos-Latn-BF",
                            mox: "mox-Latn-ZZ",
                            mpp: "mpp-Latn-ZZ",
                            mps: "mps-Latn-ZZ",
                            mpt: "mpt-Latn-ZZ",
                            mpx: "mpx-Latn-ZZ",
                            mql: "mql-Latn-ZZ",
                            mr: "mr-Deva-IN",
                            mrd: "mrd-Deva-NP",
                            mrj: "mrj-Cyrl-RU",
                            mro: "mro-Mroo-BD",
                            ms: "ms-Latn-MY",
                            "ms-CC": "ms-Arab-CC",
                            "ms-ID": "ms-Arab-ID",
                            mt: "mt-Latn-MT",
                            mtc: "mtc-Latn-ZZ",
                            mtf: "mtf-Latn-ZZ",
                            mti: "mti-Latn-ZZ",
                            mtr: "mtr-Deva-IN",
                            mua: "mua-Latn-CM",
                            mur: "mur-Latn-ZZ",
                            mus: "mus-Latn-US",
                            mva: "mva-Latn-ZZ",
                            mvn: "mvn-Latn-ZZ",
                            mvy: "mvy-Arab-PK",
                            mwk: "mwk-Latn-ML",
                            mwr: "mwr-Deva-IN",
                            mwv: "mwv-Latn-ID",
                            mww: "mww-Hmnp-US",
                            mxc: "mxc-Latn-ZW",
                            mxm: "mxm-Latn-ZZ",
                            my: "my-Mymr-MM",
                            myk: "myk-Latn-ZZ",
                            mym: "mym-Ethi-ZZ",
                            myv: "myv-Cyrl-RU",
                            myw: "myw-Latn-ZZ",
                            myx: "myx-Latn-UG",
                            myz: "myz-Mand-IR",
                            mzk: "mzk-Latn-ZZ",
                            mzm: "mzm-Latn-ZZ",
                            mzn: "mzn-Arab-IR",
                            mzp: "mzp-Latn-ZZ",
                            mzw: "mzw-Latn-ZZ",
                            mzz: "mzz-Latn-ZZ",
                            na: "na-Latn-NR",
                            nac: "nac-Latn-ZZ",
                            naf: "naf-Latn-ZZ",
                            nak: "nak-Latn-ZZ",
                            nan: "nan-Hans-CN",
                            nap: "nap-Latn-IT",
                            naq: "naq-Latn-NA",
                            nas: "nas-Latn-ZZ",
                            nb: "nb-Latn-NO",
                            nca: "nca-Latn-ZZ",
                            nce: "nce-Latn-ZZ",
                            ncf: "ncf-Latn-ZZ",
                            nch: "nch-Latn-MX",
                            nco: "nco-Latn-ZZ",
                            ncu: "ncu-Latn-ZZ",
                            nd: "nd-Latn-ZW",
                            ndc: "ndc-Latn-MZ",
                            nds: "nds-Latn-DE",
                            ne: "ne-Deva-NP",
                            neb: "neb-Latn-ZZ",
                            new: "new-Deva-NP",
                            nex: "nex-Latn-ZZ",
                            nfr: "nfr-Latn-ZZ",
                            ng: "ng-Latn-NA",
                            nga: "nga-Latn-ZZ",
                            ngb: "ngb-Latn-ZZ",
                            ngl: "ngl-Latn-MZ",
                            nhb: "nhb-Latn-ZZ",
                            nhe: "nhe-Latn-MX",
                            nhw: "nhw-Latn-MX",
                            nif: "nif-Latn-ZZ",
                            nii: "nii-Latn-ZZ",
                            nij: "nij-Latn-ID",
                            nin: "nin-Latn-ZZ",
                            niu: "niu-Latn-NU",
                            niy: "niy-Latn-ZZ",
                            niz: "niz-Latn-ZZ",
                            njo: "njo-Latn-IN",
                            nkg: "nkg-Latn-ZZ",
                            nko: "nko-Latn-ZZ",
                            nl: "nl-Latn-NL",
                            nmg: "nmg-Latn-CM",
                            nmz: "nmz-Latn-ZZ",
                            nn: "nn-Latn-NO",
                            nnf: "nnf-Latn-ZZ",
                            nnh: "nnh-Latn-CM",
                            nnk: "nnk-Latn-ZZ",
                            nnm: "nnm-Latn-ZZ",
                            nnp: "nnp-Wcho-IN",
                            no: "no-Latn-NO",
                            nod: "nod-Lana-TH",
                            noe: "noe-Deva-IN",
                            non: "non-Runr-SE",
                            nop: "nop-Latn-ZZ",
                            nou: "nou-Latn-ZZ",
                            nqo: "nqo-Nkoo-GN",
                            nr: "nr-Latn-ZA",
                            nrb: "nrb-Latn-ZZ",
                            nsk: "nsk-Cans-CA",
                            nsn: "nsn-Latn-ZZ",
                            nso: "nso-Latn-ZA",
                            nss: "nss-Latn-ZZ",
                            ntm: "ntm-Latn-ZZ",
                            ntr: "ntr-Latn-ZZ",
                            nui: "nui-Latn-ZZ",
                            nup: "nup-Latn-ZZ",
                            nus: "nus-Latn-SS",
                            nuv: "nuv-Latn-ZZ",
                            nux: "nux-Latn-ZZ",
                            nv: "nv-Latn-US",
                            nwb: "nwb-Latn-ZZ",
                            nxq: "nxq-Latn-CN",
                            nxr: "nxr-Latn-ZZ",
                            ny: "ny-Latn-MW",
                            nym: "nym-Latn-TZ",
                            nyn: "nyn-Latn-UG",
                            nzi: "nzi-Latn-GH",
                            oc: "oc-Latn-FR",
                            ogc: "ogc-Latn-ZZ",
                            okr: "okr-Latn-ZZ",
                            okv: "okv-Latn-ZZ",
                            om: "om-Latn-ET",
                            ong: "ong-Latn-ZZ",
                            onn: "onn-Latn-ZZ",
                            ons: "ons-Latn-ZZ",
                            opm: "opm-Latn-ZZ",
                            or: "or-Orya-IN",
                            oro: "oro-Latn-ZZ",
                            oru: "oru-Arab-ZZ",
                            os: "os-Cyrl-GE",
                            osa: "osa-Osge-US",
                            ota: "ota-Arab-ZZ",
                            otk: "otk-Orkh-MN",
                            ozm: "ozm-Latn-ZZ",
                            pa: "pa-Guru-IN",
                            "pa-Arab": "pa-Arab-PK",
                            "pa-PK": "pa-Arab-PK",
                            pag: "pag-Latn-PH",
                            pal: "pal-Phli-IR",
                            "pal-Phlp": "pal-Phlp-CN",
                            pam: "pam-Latn-PH",
                            pap: "pap-Latn-AW",
                            pau: "pau-Latn-PW",
                            pbi: "pbi-Latn-ZZ",
                            pcd: "pcd-Latn-FR",
                            pcm: "pcm-Latn-NG",
                            pdc: "pdc-Latn-US",
                            pdt: "pdt-Latn-CA",
                            ped: "ped-Latn-ZZ",
                            peo: "peo-Xpeo-IR",
                            pex: "pex-Latn-ZZ",
                            pfl: "pfl-Latn-DE",
                            phl: "phl-Arab-ZZ",
                            phn: "phn-Phnx-LB",
                            pil: "pil-Latn-ZZ",
                            pip: "pip-Latn-ZZ",
                            pka: "pka-Brah-IN",
                            pko: "pko-Latn-KE",
                            pl: "pl-Latn-PL",
                            pla: "pla-Latn-ZZ",
                            pms: "pms-Latn-IT",
                            png: "png-Latn-ZZ",
                            pnn: "pnn-Latn-ZZ",
                            pnt: "pnt-Grek-GR",
                            pon: "pon-Latn-FM",
                            ppa: "ppa-Deva-IN",
                            ppo: "ppo-Latn-ZZ",
                            pra: "pra-Khar-PK",
                            prd: "prd-Arab-IR",
                            prg: "prg-Latn-001",
                            ps: "ps-Arab-AF",
                            pss: "pss-Latn-ZZ",
                            pt: "pt-Latn-BR",
                            ptp: "ptp-Latn-ZZ",
                            puu: "puu-Latn-GA",
                            pwa: "pwa-Latn-ZZ",
                            qu: "qu-Latn-PE",
                            quc: "quc-Latn-GT",
                            qug: "qug-Latn-EC",
                            rai: "rai-Latn-ZZ",
                            raj: "raj-Deva-IN",
                            rao: "rao-Latn-ZZ",
                            rcf: "rcf-Latn-RE",
                            rej: "rej-Latn-ID",
                            rel: "rel-Latn-ZZ",
                            res: "res-Latn-ZZ",
                            rgn: "rgn-Latn-IT",
                            rhg: "rhg-Arab-MM",
                            ria: "ria-Latn-IN",
                            rif: "rif-Tfng-MA",
                            "rif-NL": "rif-Latn-NL",
                            rjs: "rjs-Deva-NP",
                            rkt: "rkt-Beng-BD",
                            rm: "rm-Latn-CH",
                            rmf: "rmf-Latn-FI",
                            rmo: "rmo-Latn-CH",
                            rmt: "rmt-Arab-IR",
                            rmu: "rmu-Latn-SE",
                            rn: "rn-Latn-BI",
                            rna: "rna-Latn-ZZ",
                            rng: "rng-Latn-MZ",
                            ro: "ro-Latn-RO",
                            rob: "rob-Latn-ID",
                            rof: "rof-Latn-TZ",
                            roo: "roo-Latn-ZZ",
                            rro: "rro-Latn-ZZ",
                            rtm: "rtm-Latn-FJ",
                            ru: "ru-Cyrl-RU",
                            rue: "rue-Cyrl-UA",
                            rug: "rug-Latn-SB",
                            rw: "rw-Latn-RW",
                            rwk: "rwk-Latn-TZ",
                            rwo: "rwo-Latn-ZZ",
                            ryu: "ryu-Kana-JP",
                            sa: "sa-Deva-IN",
                            saf: "saf-Latn-GH",
                            sah: "sah-Cyrl-RU",
                            saq: "saq-Latn-KE",
                            sas: "sas-Latn-ID",
                            sat: "sat-Latn-IN",
                            sav: "sav-Latn-SN",
                            saz: "saz-Saur-IN",
                            sba: "sba-Latn-ZZ",
                            sbe: "sbe-Latn-ZZ",
                            sbp: "sbp-Latn-TZ",
                            sc: "sc-Latn-IT",
                            sck: "sck-Deva-IN",
                            scl: "scl-Arab-ZZ",
                            scn: "scn-Latn-IT",
                            sco: "sco-Latn-GB",
                            scs: "scs-Latn-CA",
                            sd: "sd-Arab-PK",
                            "sd-Deva": "sd-Deva-IN",
                            "sd-Khoj": "sd-Khoj-IN",
                            "sd-Sind": "sd-Sind-IN",
                            sdc: "sdc-Latn-IT",
                            sdh: "sdh-Arab-IR",
                            se: "se-Latn-NO",
                            sef: "sef-Latn-CI",
                            seh: "seh-Latn-MZ",
                            sei: "sei-Latn-MX",
                            ses: "ses-Latn-ML",
                            sg: "sg-Latn-CF",
                            sga: "sga-Ogam-IE",
                            sgs: "sgs-Latn-LT",
                            sgw: "sgw-Ethi-ZZ",
                            sgz: "sgz-Latn-ZZ",
                            shi: "shi-Tfng-MA",
                            shk: "shk-Latn-ZZ",
                            shn: "shn-Mymr-MM",
                            shu: "shu-Arab-ZZ",
                            si: "si-Sinh-LK",
                            sid: "sid-Latn-ET",
                            sig: "sig-Latn-ZZ",
                            sil: "sil-Latn-ZZ",
                            sim: "sim-Latn-ZZ",
                            sjr: "sjr-Latn-ZZ",
                            sk: "sk-Latn-SK",
                            skc: "skc-Latn-ZZ",
                            skr: "skr-Arab-PK",
                            sks: "sks-Latn-ZZ",
                            sl: "sl-Latn-SI",
                            sld: "sld-Latn-ZZ",
                            sli: "sli-Latn-PL",
                            sll: "sll-Latn-ZZ",
                            sly: "sly-Latn-ID",
                            sm: "sm-Latn-WS",
                            sma: "sma-Latn-SE",
                            smj: "smj-Latn-SE",
                            smn: "smn-Latn-FI",
                            smp: "smp-Samr-IL",
                            smq: "smq-Latn-ZZ",
                            sms: "sms-Latn-FI",
                            sn: "sn-Latn-ZW",
                            snc: "snc-Latn-ZZ",
                            snk: "snk-Latn-ML",
                            snp: "snp-Latn-ZZ",
                            snx: "snx-Latn-ZZ",
                            sny: "sny-Latn-ZZ",
                            so: "so-Latn-SO",
                            sog: "sog-Sogd-UZ",
                            sok: "sok-Latn-ZZ",
                            soq: "soq-Latn-ZZ",
                            sou: "sou-Thai-TH",
                            soy: "soy-Latn-ZZ",
                            spd: "spd-Latn-ZZ",
                            spl: "spl-Latn-ZZ",
                            sps: "sps-Latn-ZZ",
                            sq: "sq-Latn-AL",
                            sr: "sr-Cyrl-RS",
                            "sr-ME": "sr-Latn-ME",
                            "sr-RO": "sr-Latn-RO",
                            "sr-RU": "sr-Latn-RU",
                            "sr-TR": "sr-Latn-TR",
                            srb: "srb-Sora-IN",
                            srn: "srn-Latn-SR",
                            srr: "srr-Latn-SN",
                            srx: "srx-Deva-IN",
                            ss: "ss-Latn-ZA",
                            ssd: "ssd-Latn-ZZ",
                            ssg: "ssg-Latn-ZZ",
                            ssy: "ssy-Latn-ER",
                            st: "st-Latn-ZA",
                            stk: "stk-Latn-ZZ",
                            stq: "stq-Latn-DE",
                            su: "su-Latn-ID",
                            sua: "sua-Latn-ZZ",
                            sue: "sue-Latn-ZZ",
                            suk: "suk-Latn-TZ",
                            sur: "sur-Latn-ZZ",
                            sus: "sus-Latn-GN",
                            sv: "sv-Latn-SE",
                            sw: "sw-Latn-TZ",
                            swb: "swb-Arab-YT",
                            swc: "swc-Latn-CD",
                            swg: "swg-Latn-DE",
                            swp: "swp-Latn-ZZ",
                            swv: "swv-Deva-IN",
                            sxn: "sxn-Latn-ID",
                            sxw: "sxw-Latn-ZZ",
                            syl: "syl-Beng-BD",
                            syr: "syr-Syrc-IQ",
                            szl: "szl-Latn-PL",
                            ta: "ta-Taml-IN",
                            taj: "taj-Deva-NP",
                            tal: "tal-Latn-ZZ",
                            tan: "tan-Latn-ZZ",
                            taq: "taq-Latn-ZZ",
                            tbc: "tbc-Latn-ZZ",
                            tbd: "tbd-Latn-ZZ",
                            tbf: "tbf-Latn-ZZ",
                            tbg: "tbg-Latn-ZZ",
                            tbo: "tbo-Latn-ZZ",
                            tbw: "tbw-Latn-PH",
                            tbz: "tbz-Latn-ZZ",
                            tci: "tci-Latn-ZZ",
                            tcy: "tcy-Knda-IN",
                            tdd: "tdd-Tale-CN",
                            tdg: "tdg-Deva-NP",
                            tdh: "tdh-Deva-NP",
                            tdu: "tdu-Latn-MY",
                            te: "te-Telu-IN",
                            ted: "ted-Latn-ZZ",
                            tem: "tem-Latn-SL",
                            teo: "teo-Latn-UG",
                            tet: "tet-Latn-TL",
                            tfi: "tfi-Latn-ZZ",
                            tg: "tg-Cyrl-TJ",
                            "tg-Arab": "tg-Arab-PK",
                            "tg-PK": "tg-Arab-PK",
                            tgc: "tgc-Latn-ZZ",
                            tgo: "tgo-Latn-ZZ",
                            tgu: "tgu-Latn-ZZ",
                            th: "th-Thai-TH",
                            thl: "thl-Deva-NP",
                            thq: "thq-Deva-NP",
                            thr: "thr-Deva-NP",
                            ti: "ti-Ethi-ET",
                            tif: "tif-Latn-ZZ",
                            tig: "tig-Ethi-ER",
                            tik: "tik-Latn-ZZ",
                            tim: "tim-Latn-ZZ",
                            tio: "tio-Latn-ZZ",
                            tiv: "tiv-Latn-NG",
                            tk: "tk-Latn-TM",
                            tkl: "tkl-Latn-TK",
                            tkr: "tkr-Latn-AZ",
                            tkt: "tkt-Deva-NP",
                            tl: "tl-Latn-PH",
                            tlf: "tlf-Latn-ZZ",
                            tlx: "tlx-Latn-ZZ",
                            tly: "tly-Latn-AZ",
                            tmh: "tmh-Latn-NE",
                            tmy: "tmy-Latn-ZZ",
                            tn: "tn-Latn-ZA",
                            tnh: "tnh-Latn-ZZ",
                            to: "to-Latn-TO",
                            tof: "tof-Latn-ZZ",
                            tog: "tog-Latn-MW",
                            toq: "toq-Latn-ZZ",
                            tpi: "tpi-Latn-PG",
                            tpm: "tpm-Latn-ZZ",
                            tpz: "tpz-Latn-ZZ",
                            tqo: "tqo-Latn-ZZ",
                            tr: "tr-Latn-TR",
                            tru: "tru-Latn-TR",
                            trv: "trv-Latn-TW",
                            trw: "trw-Arab-ZZ",
                            ts: "ts-Latn-ZA",
                            tsd: "tsd-Grek-GR",
                            tsf: "tsf-Deva-NP",
                            tsg: "tsg-Latn-PH",
                            tsj: "tsj-Tibt-BT",
                            tsw: "tsw-Latn-ZZ",
                            tt: "tt-Cyrl-RU",
                            ttd: "ttd-Latn-ZZ",
                            tte: "tte-Latn-ZZ",
                            ttj: "ttj-Latn-UG",
                            ttr: "ttr-Latn-ZZ",
                            tts: "tts-Thai-TH",
                            ttt: "ttt-Latn-AZ",
                            tuh: "tuh-Latn-ZZ",
                            tul: "tul-Latn-ZZ",
                            tum: "tum-Latn-MW",
                            tuq: "tuq-Latn-ZZ",
                            tvd: "tvd-Latn-ZZ",
                            tvl: "tvl-Latn-TV",
                            tvu: "tvu-Latn-ZZ",
                            twh: "twh-Latn-ZZ",
                            twq: "twq-Latn-NE",
                            txg: "txg-Tang-CN",
                            ty: "ty-Latn-PF",
                            tya: "tya-Latn-ZZ",
                            tyv: "tyv-Cyrl-RU",
                            tzm: "tzm-Latn-MA",
                            ubu: "ubu-Latn-ZZ",
                            udm: "udm-Cyrl-RU",
                            ug: "ug-Arab-CN",
                            "ug-Cyrl": "ug-Cyrl-KZ",
                            "ug-KZ": "ug-Cyrl-KZ",
                            "ug-MN": "ug-Cyrl-MN",
                            uga: "uga-Ugar-SY",
                            uk: "uk-Cyrl-UA",
                            uli: "uli-Latn-FM",
                            umb: "umb-Latn-AO",
                            und: "en-Latn-US",
                            "und-002": "en-Latn-NG",
                            "und-003": "en-Latn-US",
                            "und-005": "pt-Latn-BR",
                            "und-009": "en-Latn-AU",
                            "und-011": "en-Latn-NG",
                            "und-013": "es-Latn-MX",
                            "und-014": "sw-Latn-TZ",
                            "und-015": "ar-Arab-EG",
                            "und-017": "sw-Latn-CD",
                            "und-018": "en-Latn-ZA",
                            "und-019": "en-Latn-US",
                            "und-021": "en-Latn-US",
                            "und-029": "es-Latn-CU",
                            "und-030": "zh-Hans-CN",
                            "und-034": "hi-Deva-IN",
                            "und-035": "id-Latn-ID",
                            "und-039": "it-Latn-IT",
                            "und-053": "en-Latn-AU",
                            "und-054": "en-Latn-PG",
                            "und-057": "en-Latn-GU",
                            "und-061": "sm-Latn-WS",
                            "und-142": "zh-Hans-CN",
                            "und-143": "uz-Latn-UZ",
                            "und-145": "ar-Arab-SA",
                            "und-150": "ru-Cyrl-RU",
                            "und-151": "ru-Cyrl-RU",
                            "und-154": "en-Latn-GB",
                            "und-155": "de-Latn-DE",
                            "und-202": "en-Latn-NG",
                            "und-419": "es-Latn-419",
                            "und-AD": "ca-Latn-AD",
                            "und-Adlm": "ff-Adlm-GN",
                            "und-AE": "ar-Arab-AE",
                            "und-AF": "fa-Arab-AF",
                            "und-Aghb": "lez-Aghb-RU",
                            "und-Ahom": "aho-Ahom-IN",
                            "und-AL": "sq-Latn-AL",
                            "und-AM": "hy-Armn-AM",
                            "und-AO": "pt-Latn-AO",
                            "und-AQ": "und-Latn-AQ",
                            "und-AR": "es-Latn-AR",
                            "und-Arab": "ar-Arab-EG",
                            "und-Arab-CC": "ms-Arab-CC",
                            "und-Arab-CN": "ug-Arab-CN",
                            "und-Arab-GB": "ks-Arab-GB",
                            "und-Arab-ID": "ms-Arab-ID",
                            "und-Arab-IN": "ur-Arab-IN",
                            "und-Arab-KH": "cja-Arab-KH",
                            "und-Arab-MM": "rhg-Arab-MM",
                            "und-Arab-MN": "kk-Arab-MN",
                            "und-Arab-MU": "ur-Arab-MU",
                            "und-Arab-NG": "ha-Arab-NG",
                            "und-Arab-PK": "ur-Arab-PK",
                            "und-Arab-TG": "apd-Arab-TG",
                            "und-Arab-TH": "mfa-Arab-TH",
                            "und-Arab-TJ": "fa-Arab-TJ",
                            "und-Arab-TR": "az-Arab-TR",
                            "und-Arab-YT": "swb-Arab-YT",
                            "und-Armi": "arc-Armi-IR",
                            "und-Armn": "hy-Armn-AM",
                            "und-AS": "sm-Latn-AS",
                            "und-AT": "de-Latn-AT",
                            "und-Avst": "ae-Avst-IR",
                            "und-AW": "nl-Latn-AW",
                            "und-AX": "sv-Latn-AX",
                            "und-AZ": "az-Latn-AZ",
                            "und-BA": "bs-Latn-BA",
                            "und-Bali": "ban-Bali-ID",
                            "und-Bamu": "bax-Bamu-CM",
                            "und-Bass": "bsq-Bass-LR",
                            "und-Batk": "bbc-Batk-ID",
                            "und-BD": "bn-Beng-BD",
                            "und-BE": "nl-Latn-BE",
                            "und-Beng": "bn-Beng-BD",
                            "und-BF": "fr-Latn-BF",
                            "und-BG": "bg-Cyrl-BG",
                            "und-BH": "ar-Arab-BH",
                            "und-Bhks": "sa-Bhks-IN",
                            "und-BI": "rn-Latn-BI",
                            "und-BJ": "fr-Latn-BJ",
                            "und-BL": "fr-Latn-BL",
                            "und-BN": "ms-Latn-BN",
                            "und-BO": "es-Latn-BO",
                            "und-Bopo": "zh-Bopo-TW",
                            "und-BQ": "pap-Latn-BQ",
                            "und-BR": "pt-Latn-BR",
                            "und-Brah": "pka-Brah-IN",
                            "und-Brai": "fr-Brai-FR",
                            "und-BT": "dz-Tibt-BT",
                            "und-Bugi": "bug-Bugi-ID",
                            "und-Buhd": "bku-Buhd-PH",
                            "und-BV": "und-Latn-BV",
                            "und-BY": "be-Cyrl-BY",
                            "und-Cakm": "ccp-Cakm-BD",
                            "und-Cans": "cr-Cans-CA",
                            "und-Cari": "xcr-Cari-TR",
                            "und-CD": "sw-Latn-CD",
                            "und-CF": "fr-Latn-CF",
                            "und-CG": "fr-Latn-CG",
                            "und-CH": "de-Latn-CH",
                            "und-Cham": "cjm-Cham-VN",
                            "und-Cher": "chr-Cher-US",
                            "und-CI": "fr-Latn-CI",
                            "und-CL": "es-Latn-CL",
                            "und-CM": "fr-Latn-CM",
                            "und-CN": "zh-Hans-CN",
                            "und-CO": "es-Latn-CO",
                            "und-Copt": "cop-Copt-EG",
                            "und-CP": "und-Latn-CP",
                            "und-Cprt": "grc-Cprt-CY",
                            "und-CR": "es-Latn-CR",
                            "und-CU": "es-Latn-CU",
                            "und-CV": "pt-Latn-CV",
                            "und-CW": "pap-Latn-CW",
                            "und-CY": "el-Grek-CY",
                            "und-Cyrl": "ru-Cyrl-RU",
                            "und-Cyrl-AL": "mk-Cyrl-AL",
                            "und-Cyrl-BA": "sr-Cyrl-BA",
                            "und-Cyrl-GE": "ab-Cyrl-GE",
                            "und-Cyrl-GR": "mk-Cyrl-GR",
                            "und-Cyrl-MD": "uk-Cyrl-MD",
                            "und-Cyrl-RO": "bg-Cyrl-RO",
                            "und-Cyrl-SK": "uk-Cyrl-SK",
                            "und-Cyrl-TR": "kbd-Cyrl-TR",
                            "und-Cyrl-XK": "sr-Cyrl-XK",
                            "und-CZ": "cs-Latn-CZ",
                            "und-DE": "de-Latn-DE",
                            "und-Deva": "hi-Deva-IN",
                            "und-Deva-BT": "ne-Deva-BT",
                            "und-Deva-FJ": "hif-Deva-FJ",
                            "und-Deva-MU": "bho-Deva-MU",
                            "und-Deva-PK": "btv-Deva-PK",
                            "und-DJ": "aa-Latn-DJ",
                            "und-DK": "da-Latn-DK",
                            "und-DO": "es-Latn-DO",
                            "und-Dogr": "doi-Dogr-IN",
                            "und-Dupl": "fr-Dupl-FR",
                            "und-DZ": "ar-Arab-DZ",
                            "und-EA": "es-Latn-EA",
                            "und-EC": "es-Latn-EC",
                            "und-EE": "et-Latn-EE",
                            "und-EG": "ar-Arab-EG",
                            "und-Egyp": "egy-Egyp-EG",
                            "und-EH": "ar-Arab-EH",
                            "und-Elba": "sq-Elba-AL",
                            "und-Elym": "arc-Elym-IR",
                            "und-ER": "ti-Ethi-ER",
                            "und-ES": "es-Latn-ES",
                            "und-ET": "am-Ethi-ET",
                            "und-Ethi": "am-Ethi-ET",
                            "und-EU": "en-Latn-GB",
                            "und-EZ": "de-Latn-EZ",
                            "und-FI": "fi-Latn-FI",
                            "und-FO": "fo-Latn-FO",
                            "und-FR": "fr-Latn-FR",
                            "und-GA": "fr-Latn-GA",
                            "und-GE": "ka-Geor-GE",
                            "und-Geor": "ka-Geor-GE",
                            "und-GF": "fr-Latn-GF",
                            "und-GH": "ak-Latn-GH",
                            "und-GL": "kl-Latn-GL",
                            "und-Glag": "cu-Glag-BG",
                            "und-GN": "fr-Latn-GN",
                            "und-Gong": "wsg-Gong-IN",
                            "und-Gonm": "esg-Gonm-IN",
                            "und-Goth": "got-Goth-UA",
                            "und-GP": "fr-Latn-GP",
                            "und-GQ": "es-Latn-GQ",
                            "und-GR": "el-Grek-GR",
                            "und-Gran": "sa-Gran-IN",
                            "und-Grek": "el-Grek-GR",
                            "und-Grek-TR": "bgx-Grek-TR",
                            "und-GS": "und-Latn-GS",
                            "und-GT": "es-Latn-GT",
                            "und-Gujr": "gu-Gujr-IN",
                            "und-Guru": "pa-Guru-IN",
                            "und-GW": "pt-Latn-GW",
                            "und-Hanb": "zh-Hanb-TW",
                            "und-Hang": "ko-Hang-KR",
                            "und-Hani": "zh-Hani-CN",
                            "und-Hano": "hnn-Hano-PH",
                            "und-Hans": "zh-Hans-CN",
                            "und-Hant": "zh-Hant-TW",
                            "und-Hatr": "mis-Hatr-IQ",
                            "und-Hebr": "he-Hebr-IL",
                            "und-Hebr-CA": "yi-Hebr-CA",
                            "und-Hebr-GB": "yi-Hebr-GB",
                            "und-Hebr-SE": "yi-Hebr-SE",
                            "und-Hebr-UA": "yi-Hebr-UA",
                            "und-Hebr-US": "yi-Hebr-US",
                            "und-Hira": "ja-Hira-JP",
                            "und-HK": "zh-Hant-HK",
                            "und-Hluw": "hlu-Hluw-TR",
                            "und-HM": "und-Latn-HM",
                            "und-Hmng": "hnj-Hmng-LA",
                            "und-Hmnp": "mww-Hmnp-US",
                            "und-HN": "es-Latn-HN",
                            "und-HR": "hr-Latn-HR",
                            "und-HT": "ht-Latn-HT",
                            "und-HU": "hu-Latn-HU",
                            "und-Hung": "hu-Hung-HU",
                            "und-IC": "es-Latn-IC",
                            "und-ID": "id-Latn-ID",
                            "und-IL": "he-Hebr-IL",
                            "und-IN": "hi-Deva-IN",
                            "und-IQ": "ar-Arab-IQ",
                            "und-IR": "fa-Arab-IR",
                            "und-IS": "is-Latn-IS",
                            "und-IT": "it-Latn-IT",
                            "und-Ital": "ett-Ital-IT",
                            "und-Jamo": "ko-Jamo-KR",
                            "und-Java": "jv-Java-ID",
                            "und-JO": "ar-Arab-JO",
                            "und-JP": "ja-Jpan-JP",
                            "und-Jpan": "ja-Jpan-JP",
                            "und-Kali": "eky-Kali-MM",
                            "und-Kana": "ja-Kana-JP",
                            "und-KE": "sw-Latn-KE",
                            "und-KG": "ky-Cyrl-KG",
                            "und-KH": "km-Khmr-KH",
                            "und-Khar": "pra-Khar-PK",
                            "und-Khmr": "km-Khmr-KH",
                            "und-Khoj": "sd-Khoj-IN",
                            "und-KM": "ar-Arab-KM",
                            "und-Knda": "kn-Knda-IN",
                            "und-Kore": "ko-Kore-KR",
                            "und-KP": "ko-Kore-KP",
                            "und-KR": "ko-Kore-KR",
                            "und-Kthi": "bho-Kthi-IN",
                            "und-KW": "ar-Arab-KW",
                            "und-KZ": "ru-Cyrl-KZ",
                            "und-LA": "lo-Laoo-LA",
                            "und-Lana": "nod-Lana-TH",
                            "und-Laoo": "lo-Laoo-LA",
                            "und-Latn-AF": "tk-Latn-AF",
                            "und-Latn-AM": "ku-Latn-AM",
                            "und-Latn-CN": "za-Latn-CN",
                            "und-Latn-CY": "tr-Latn-CY",
                            "und-Latn-DZ": "fr-Latn-DZ",
                            "und-Latn-ET": "en-Latn-ET",
                            "und-Latn-GE": "ku-Latn-GE",
                            "und-Latn-IR": "tk-Latn-IR",
                            "und-Latn-KM": "fr-Latn-KM",
                            "und-Latn-MA": "fr-Latn-MA",
                            "und-Latn-MK": "sq-Latn-MK",
                            "und-Latn-MM": "kac-Latn-MM",
                            "und-Latn-MO": "pt-Latn-MO",
                            "und-Latn-MR": "fr-Latn-MR",
                            "und-Latn-RU": "krl-Latn-RU",
                            "und-Latn-SY": "fr-Latn-SY",
                            "und-Latn-TN": "fr-Latn-TN",
                            "und-Latn-TW": "trv-Latn-TW",
                            "und-Latn-UA": "pl-Latn-UA",
                            "und-LB": "ar-Arab-LB",
                            "und-Lepc": "lep-Lepc-IN",
                            "und-LI": "de-Latn-LI",
                            "und-Limb": "lif-Limb-IN",
                            "und-Lina": "lab-Lina-GR",
                            "und-Linb": "grc-Linb-GR",
                            "und-Lisu": "lis-Lisu-CN",
                            "und-LK": "si-Sinh-LK",
                            "und-LS": "st-Latn-LS",
                            "und-LT": "lt-Latn-LT",
                            "und-LU": "fr-Latn-LU",
                            "und-LV": "lv-Latn-LV",
                            "und-LY": "ar-Arab-LY",
                            "und-Lyci": "xlc-Lyci-TR",
                            "und-Lydi": "xld-Lydi-TR",
                            "und-MA": "ar-Arab-MA",
                            "und-Mahj": "hi-Mahj-IN",
                            "und-Maka": "mak-Maka-ID",
                            "und-Mand": "myz-Mand-IR",
                            "und-Mani": "xmn-Mani-CN",
                            "und-Marc": "bo-Marc-CN",
                            "und-MC": "fr-Latn-MC",
                            "und-MD": "ro-Latn-MD",
                            "und-ME": "sr-Latn-ME",
                            "und-Medf": "mis-Medf-NG",
                            "und-Mend": "men-Mend-SL",
                            "und-Merc": "xmr-Merc-SD",
                            "und-Mero": "xmr-Mero-SD",
                            "und-MF": "fr-Latn-MF",
                            "und-MG": "mg-Latn-MG",
                            "und-MK": "mk-Cyrl-MK",
                            "und-ML": "bm-Latn-ML",
                            "und-Mlym": "ml-Mlym-IN",
                            "und-MM": "my-Mymr-MM",
                            "und-MN": "mn-Cyrl-MN",
                            "und-MO": "zh-Hant-MO",
                            "und-Modi": "mr-Modi-IN",
                            "und-Mong": "mn-Mong-CN",
                            "und-MQ": "fr-Latn-MQ",
                            "und-MR": "ar-Arab-MR",
                            "und-Mroo": "mro-Mroo-BD",
                            "und-MT": "mt-Latn-MT",
                            "und-Mtei": "mni-Mtei-IN",
                            "und-MU": "mfe-Latn-MU",
                            "und-Mult": "skr-Mult-PK",
                            "und-MV": "dv-Thaa-MV",
                            "und-MX": "es-Latn-MX",
                            "und-MY": "ms-Latn-MY",
                            "und-Mymr": "my-Mymr-MM",
                            "und-Mymr-IN": "kht-Mymr-IN",
                            "und-Mymr-TH": "mnw-Mymr-TH",
                            "und-MZ": "pt-Latn-MZ",
                            "und-NA": "af-Latn-NA",
                            "und-Nand": "sa-Nand-IN",
                            "und-Narb": "xna-Narb-SA",
                            "und-Nbat": "arc-Nbat-JO",
                            "und-NC": "fr-Latn-NC",
                            "und-NE": "ha-Latn-NE",
                            "und-Newa": "new-Newa-NP",
                            "und-NI": "es-Latn-NI",
                            "und-Nkoo": "man-Nkoo-GN",
                            "und-NL": "nl-Latn-NL",
                            "und-NO": "nb-Latn-NO",
                            "und-NP": "ne-Deva-NP",
                            "und-Nshu": "zhx-Nshu-CN",
                            "und-Ogam": "sga-Ogam-IE",
                            "und-Olck": "sat-Olck-IN",
                            "und-OM": "ar-Arab-OM",
                            "und-Orkh": "otk-Orkh-MN",
                            "und-Orya": "or-Orya-IN",
                            "und-Osge": "osa-Osge-US",
                            "und-Osma": "so-Osma-SO",
                            "und-PA": "es-Latn-PA",
                            "und-Palm": "arc-Palm-SY",
                            "und-Pauc": "ctd-Pauc-MM",
                            "und-PE": "es-Latn-PE",
                            "und-Perm": "kv-Perm-RU",
                            "und-PF": "fr-Latn-PF",
                            "und-PG": "tpi-Latn-PG",
                            "und-PH": "fil-Latn-PH",
                            "und-Phag": "lzh-Phag-CN",
                            "und-Phli": "pal-Phli-IR",
                            "und-Phlp": "pal-Phlp-CN",
                            "und-Phnx": "phn-Phnx-LB",
                            "und-PK": "ur-Arab-PK",
                            "und-PL": "pl-Latn-PL",
                            "und-Plrd": "hmd-Plrd-CN",
                            "und-PM": "fr-Latn-PM",
                            "und-PR": "es-Latn-PR",
                            "und-Prti": "xpr-Prti-IR",
                            "und-PS": "ar-Arab-PS",
                            "und-PT": "pt-Latn-PT",
                            "und-PW": "pau-Latn-PW",
                            "und-PY": "gn-Latn-PY",
                            "und-QA": "ar-Arab-QA",
                            "und-QO": "en-Latn-DG",
                            "und-RE": "fr-Latn-RE",
                            "und-Rjng": "rej-Rjng-ID",
                            "und-RO": "ro-Latn-RO",
                            "und-Rohg": "rhg-Rohg-MM",
                            "und-RS": "sr-Cyrl-RS",
                            "und-RU": "ru-Cyrl-RU",
                            "und-Runr": "non-Runr-SE",
                            "und-RW": "rw-Latn-RW",
                            "und-SA": "ar-Arab-SA",
                            "und-Samr": "smp-Samr-IL",
                            "und-Sarb": "xsa-Sarb-YE",
                            "und-Saur": "saz-Saur-IN",
                            "und-SC": "fr-Latn-SC",
                            "und-SD": "ar-Arab-SD",
                            "und-SE": "sv-Latn-SE",
                            "und-Sgnw": "ase-Sgnw-US",
                            "und-Shaw": "en-Shaw-GB",
                            "und-Shrd": "sa-Shrd-IN",
                            "und-SI": "sl-Latn-SI",
                            "und-Sidd": "sa-Sidd-IN",
                            "und-Sind": "sd-Sind-IN",
                            "und-Sinh": "si-Sinh-LK",
                            "und-SJ": "nb-Latn-SJ",
                            "und-SK": "sk-Latn-SK",
                            "und-SM": "it-Latn-SM",
                            "und-SN": "fr-Latn-SN",
                            "und-SO": "so-Latn-SO",
                            "und-Sogd": "sog-Sogd-UZ",
                            "und-Sogo": "sog-Sogo-UZ",
                            "und-Sora": "srb-Sora-IN",
                            "und-Soyo": "cmg-Soyo-MN",
                            "und-SR": "nl-Latn-SR",
                            "und-ST": "pt-Latn-ST",
                            "und-Sund": "su-Sund-ID",
                            "und-SV": "es-Latn-SV",
                            "und-SY": "ar-Arab-SY",
                            "und-Sylo": "syl-Sylo-BD",
                            "und-Syrc": "syr-Syrc-IQ",
                            "und-Tagb": "tbw-Tagb-PH",
                            "und-Takr": "doi-Takr-IN",
                            "und-Tale": "tdd-Tale-CN",
                            "und-Talu": "khb-Talu-CN",
                            "und-Taml": "ta-Taml-IN",
                            "und-Tang": "txg-Tang-CN",
                            "und-Tavt": "blt-Tavt-VN",
                            "und-TD": "fr-Latn-TD",
                            "und-Telu": "te-Telu-IN",
                            "und-TF": "fr-Latn-TF",
                            "und-Tfng": "zgh-Tfng-MA",
                            "und-TG": "fr-Latn-TG",
                            "und-Tglg": "fil-Tglg-PH",
                            "und-TH": "th-Thai-TH",
                            "und-Thaa": "dv-Thaa-MV",
                            "und-Thai": "th-Thai-TH",
                            "und-Thai-CN": "lcp-Thai-CN",
                            "und-Thai-KH": "kdt-Thai-KH",
                            "und-Thai-LA": "kdt-Thai-LA",
                            "und-Tibt": "bo-Tibt-CN",
                            "und-Tirh": "mai-Tirh-IN",
                            "und-TJ": "tg-Cyrl-TJ",
                            "und-TK": "tkl-Latn-TK",
                            "und-TL": "pt-Latn-TL",
                            "und-TM": "tk-Latn-TM",
                            "und-TN": "ar-Arab-TN",
                            "und-TO": "to-Latn-TO",
                            "und-TR": "tr-Latn-TR",
                            "und-TV": "tvl-Latn-TV",
                            "und-TW": "zh-Hant-TW",
                            "und-TZ": "sw-Latn-TZ",
                            "und-UA": "uk-Cyrl-UA",
                            "und-UG": "sw-Latn-UG",
                            "und-Ugar": "uga-Ugar-SY",
                            "und-UY": "es-Latn-UY",
                            "und-UZ": "uz-Latn-UZ",
                            "und-VA": "it-Latn-VA",
                            "und-Vaii": "vai-Vaii-LR",
                            "und-VE": "es-Latn-VE",
                            "und-VN": "vi-Latn-VN",
                            "und-VU": "bi-Latn-VU",
                            "und-Wara": "hoc-Wara-IN",
                            "und-Wcho": "nnp-Wcho-IN",
                            "und-WF": "fr-Latn-WF",
                            "und-WS": "sm-Latn-WS",
                            "und-XK": "sq-Latn-XK",
                            "und-Xpeo": "peo-Xpeo-IR",
                            "und-Xsux": "akk-Xsux-IQ",
                            "und-YE": "ar-Arab-YE",
                            "und-Yiii": "ii-Yiii-CN",
                            "und-YT": "fr-Latn-YT",
                            "und-Zanb": "cmg-Zanb-MN",
                            "und-ZW": "sn-Latn-ZW",
                            unr: "unr-Beng-IN",
                            "unr-Deva": "unr-Deva-NP",
                            "unr-NP": "unr-Deva-NP",
                            unx: "unx-Beng-IN",
                            uok: "uok-Latn-ZZ",
                            ur: "ur-Arab-PK",
                            uri: "uri-Latn-ZZ",
                            urt: "urt-Latn-ZZ",
                            urw: "urw-Latn-ZZ",
                            usa: "usa-Latn-ZZ",
                            utr: "utr-Latn-ZZ",
                            uvh: "uvh-Latn-ZZ",
                            uvl: "uvl-Latn-ZZ",
                            uz: "uz-Latn-UZ",
                            "uz-AF": "uz-Arab-AF",
                            "uz-Arab": "uz-Arab-AF",
                            "uz-CN": "uz-Cyrl-CN",
                            vag: "vag-Latn-ZZ",
                            vai: "vai-Vaii-LR",
                            van: "van-Latn-ZZ",
                            ve: "ve-Latn-ZA",
                            vec: "vec-Latn-IT",
                            vep: "vep-Latn-RU",
                            vi: "vi-Latn-VN",
                            vic: "vic-Latn-SX",
                            viv: "viv-Latn-ZZ",
                            vls: "vls-Latn-BE",
                            vmf: "vmf-Latn-DE",
                            vmw: "vmw-Latn-MZ",
                            vo: "vo-Latn-001",
                            vot: "vot-Latn-RU",
                            vro: "vro-Latn-EE",
                            vun: "vun-Latn-TZ",
                            vut: "vut-Latn-ZZ",
                            wa: "wa-Latn-BE",
                            wae: "wae-Latn-CH",
                            waj: "waj-Latn-ZZ",
                            wal: "wal-Ethi-ET",
                            wan: "wan-Latn-ZZ",
                            war: "war-Latn-PH",
                            wbp: "wbp-Latn-AU",
                            wbq: "wbq-Telu-IN",
                            wbr: "wbr-Deva-IN",
                            wci: "wci-Latn-ZZ",
                            wer: "wer-Latn-ZZ",
                            wgi: "wgi-Latn-ZZ",
                            whg: "whg-Latn-ZZ",
                            wib: "wib-Latn-ZZ",
                            wiu: "wiu-Latn-ZZ",
                            wiv: "wiv-Latn-ZZ",
                            wja: "wja-Latn-ZZ",
                            wji: "wji-Latn-ZZ",
                            wls: "wls-Latn-WF",
                            wmo: "wmo-Latn-ZZ",
                            wnc: "wnc-Latn-ZZ",
                            wni: "wni-Arab-KM",
                            wnu: "wnu-Latn-ZZ",
                            wo: "wo-Latn-SN",
                            wob: "wob-Latn-ZZ",
                            wos: "wos-Latn-ZZ",
                            wrs: "wrs-Latn-ZZ",
                            wsg: "wsg-Gong-IN",
                            wsk: "wsk-Latn-ZZ",
                            wtm: "wtm-Deva-IN",
                            wuu: "wuu-Hans-CN",
                            wuv: "wuv-Latn-ZZ",
                            wwa: "wwa-Latn-ZZ",
                            xav: "xav-Latn-BR",
                            xbi: "xbi-Latn-ZZ",
                            xcr: "xcr-Cari-TR",
                            xes: "xes-Latn-ZZ",
                            xh: "xh-Latn-ZA",
                            xla: "xla-Latn-ZZ",
                            xlc: "xlc-Lyci-TR",
                            xld: "xld-Lydi-TR",
                            xmf: "xmf-Geor-GE",
                            xmn: "xmn-Mani-CN",
                            xmr: "xmr-Merc-SD",
                            xna: "xna-Narb-SA",
                            xnr: "xnr-Deva-IN",
                            xog: "xog-Latn-UG",
                            xon: "xon-Latn-ZZ",
                            xpr: "xpr-Prti-IR",
                            xrb: "xrb-Latn-ZZ",
                            xsa: "xsa-Sarb-YE",
                            xsi: "xsi-Latn-ZZ",
                            xsm: "xsm-Latn-ZZ",
                            xsr: "xsr-Deva-NP",
                            xwe: "xwe-Latn-ZZ",
                            yam: "yam-Latn-ZZ",
                            yao: "yao-Latn-MZ",
                            yap: "yap-Latn-FM",
                            yas: "yas-Latn-ZZ",
                            yat: "yat-Latn-ZZ",
                            yav: "yav-Latn-CM",
                            yay: "yay-Latn-ZZ",
                            yaz: "yaz-Latn-ZZ",
                            yba: "yba-Latn-ZZ",
                            ybb: "ybb-Latn-CM",
                            yby: "yby-Latn-ZZ",
                            yer: "yer-Latn-ZZ",
                            ygr: "ygr-Latn-ZZ",
                            ygw: "ygw-Latn-ZZ",
                            yi: "yi-Hebr-001",
                            yko: "yko-Latn-ZZ",
                            yle: "yle-Latn-ZZ",
                            ylg: "ylg-Latn-ZZ",
                            yll: "yll-Latn-ZZ",
                            yml: "yml-Latn-ZZ",
                            yo: "yo-Latn-NG",
                            yon: "yon-Latn-ZZ",
                            yrb: "yrb-Latn-ZZ",
                            yre: "yre-Latn-ZZ",
                            yrl: "yrl-Latn-BR",
                            yss: "yss-Latn-ZZ",
                            yua: "yua-Latn-MX",
                            yue: "yue-Hant-HK",
                            "yue-CN": "yue-Hans-CN",
                            "yue-Hans": "yue-Hans-CN",
                            yuj: "yuj-Latn-ZZ",
                            yut: "yut-Latn-ZZ",
                            yuw: "yuw-Latn-ZZ",
                            za: "za-Latn-CN",
                            zag: "zag-Latn-SD",
                            zdj: "zdj-Arab-KM",
                            zea: "zea-Latn-NL",
                            zgh: "zgh-Tfng-MA",
                            zh: "zh-Hans-CN",
                            "zh-AU": "zh-Hant-AU",
                            "zh-BN": "zh-Hant-BN",
                            "zh-Bopo": "zh-Bopo-TW",
                            "zh-GB": "zh-Hant-GB",
                            "zh-GF": "zh-Hant-GF",
                            "zh-Hanb": "zh-Hanb-TW",
                            "zh-Hant": "zh-Hant-TW",
                            "zh-HK": "zh-Hant-HK",
                            "zh-ID": "zh-Hant-ID",
                            "zh-MO": "zh-Hant-MO",
                            "zh-MY": "zh-Hant-MY",
                            "zh-PA": "zh-Hant-PA",
                            "zh-PF": "zh-Hant-PF",
                            "zh-PH": "zh-Hant-PH",
                            "zh-SR": "zh-Hant-SR",
                            "zh-TH": "zh-Hant-TH",
                            "zh-TW": "zh-Hant-TW",
                            "zh-US": "zh-Hant-US",
                            "zh-VN": "zh-Hant-VN",
                            zhx: "zhx-Nshu-CN",
                            zia: "zia-Latn-ZZ",
                            zlm: "zlm-Latn-TG",
                            zmi: "zmi-Latn-MY",
                            zne: "zne-Latn-ZZ",
                            zu: "zu-Latn-ZA",
                            zza: "zza-Latn-TR"
                        },
                        timeData: {
                            AX: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            BQ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            CP: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            CZ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            DK: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            FI: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            ID: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            IS: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            ML: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            NE: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            RU: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SE: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SJ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SK: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            AS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            BT: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            DJ: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            ER: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            GH: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            IN: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            LS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            PG: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            PW: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            SO: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            TO: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            VU: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            WS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            "001": {
                                _allowed: "H h",
                                _preferred: "H"
                            },
                            AL: {
                                _allowed: "h H hB",
                                _preferred: "h"
                            },
                            TD: {
                                _allowed: "h H hB",
                                _preferred: "h"
                            },
                            ca_ES: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CM: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            fr_CA: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            gl_ES: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            it_CH: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            it_IT: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            LU: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            NP: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            PF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SC: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SM: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SN: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            TF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            VA: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CY: {
                                _allowed: "h H hb hB",
                                _preferred: "h"
                            },
                            GR: {
                                _allowed: "h H hb hB",
                                _preferred: "h"
                            },
                            CO: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            DO: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            KP: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            KR: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            NA: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            PA: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            PR: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            VE: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            AC: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            AI: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            BW: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            BZ: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CC: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CX: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            DG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            FK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GB: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GI: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IE: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IM: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IO: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            JE: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            LT: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MN: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MS: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NF: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NR: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NU: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            PN: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            SH: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            SX: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            TA: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            ZA: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            af_ZA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            AR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CL: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CU: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            EA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_BO: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_BR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_EC: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_ES: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_GQ: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_PE: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            GT: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            HN: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            IC: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            KG: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            KM: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            LK: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            MA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            MX: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            NI: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            PY: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            SV: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            UY: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            JP: {
                                _allowed: "H h K",
                                _preferred: "H"
                            },
                            AD: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AM: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AO: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AW: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BJ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CG: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CI: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CV: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            DE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            EE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            FR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GA: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GN: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GP: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GW: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            HR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            IL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            IT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            KZ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MC: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MD: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MQ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MZ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            NC: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            NL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            PM: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            PT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            RE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            RO: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            SI: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            SR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            ST: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            TG: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            TR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            WF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            YT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BD: {
                                _allowed: "h hB H",
                                _preferred: "h"
                            },
                            PK: {
                                _allowed: "h hB H",
                                _preferred: "h"
                            },
                            AZ: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            BA: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            BG: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            CH: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            GE: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            LI: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            ME: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            RS: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            UA: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            UZ: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            XK: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            AG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            AU: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BB: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BS: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            CA: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            DM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            en_001: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            FJ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            FM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GD: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GU: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GY: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            JM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KI: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KN: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KY: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            LC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            LR: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MH: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MP: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MW: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            NZ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SB: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SL: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SS: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SZ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            TC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            TT: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            UM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            US: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VI: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            ZM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BO: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            EC: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            ES: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            GQ: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            PE: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            AE: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            ar_001: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            BH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            DZ: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            EG: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            EH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            IQ: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            JO: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            KW: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            LB: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            LY: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            MR: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            OM: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            PH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            PS: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            QA: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SA: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SD: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SY: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            TN: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            YE: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            AF: {
                                _allowed: "H hb hB h",
                                _preferred: "H"
                            },
                            LA: {
                                _allowed: "H hb hB h",
                                _preferred: "H"
                            },
                            LV: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            TL: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            zu_ZA: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            CD: {
                                _allowed: "hB H",
                                _preferred: "H"
                            },
                            IR: {
                                _allowed: "hB H",
                                _preferred: "H"
                            },
                            hi_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            kn_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            ml_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            te_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            KH: {
                                _allowed: "hB h H hb",
                                _preferred: "h"
                            },
                            ta_IN: {
                                _allowed: "hB h hb H",
                                _preferred: "h"
                            },
                            BN: {
                                _allowed: "hb hB h H",
                                _preferred: "h"
                            },
                            MY: {
                                _allowed: "hb hB h H",
                                _preferred: "h"
                            },
                            CN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            ET: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            gu_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            HK: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            MO: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            mr_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            pa_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            TW: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            KE: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            MM: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            TZ: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            UG: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            }
                        },
                        weekData: {
                            minDays: {
                                "001": "1",
                                AD: "4",
                                AN: "4",
                                AT: "4",
                                AX: "4",
                                BE: "4",
                                BG: "4",
                                CH: "4",
                                CZ: "4",
                                DE: "4",
                                DK: "4",
                                EE: "4",
                                ES: "4",
                                FI: "4",
                                FJ: "4",
                                FO: "4",
                                FR: "4",
                                GB: "4",
                                GF: "4",
                                GG: "4",
                                GI: "4",
                                GP: "4",
                                GR: "4",
                                GU: "1",
                                HU: "4",
                                IE: "4",
                                IM: "4",
                                IS: "4",
                                IT: "4",
                                JE: "4",
                                LI: "4",
                                LT: "4",
                                LU: "4",
                                MC: "4",
                                MQ: "4",
                                NL: "4",
                                NO: "4",
                                PL: "4",
                                PT: "4",
                                RE: "4",
                                RU: "4",
                                SE: "4",
                                SJ: "4",
                                SK: "4",
                                SM: "4",
                                UM: "1",
                                US: "1",
                                VA: "4",
                                VI: "1"
                            },
                            firstDay: {
                                "001": "mon",
                                AD: "mon",
                                AE: "sat",
                                AF: "sat",
                                AG: "sun",
                                AI: "mon",
                                AL: "mon",
                                AM: "mon",
                                AN: "mon",
                                AR: "mon",
                                AS: "sun",
                                AT: "mon",
                                AU: "sun",
                                AX: "mon",
                                AZ: "mon",
                                BA: "mon",
                                BD: "sun",
                                BE: "mon",
                                BG: "mon",
                                BH: "sat",
                                BM: "mon",
                                BN: "mon",
                                BR: "sun",
                                BS: "sun",
                                BT: "sun",
                                BW: "sun",
                                BY: "mon",
                                BZ: "sun",
                                CA: "sun",
                                CH: "mon",
                                CL: "mon",
                                CM: "mon",
                                CN: "sun",
                                CO: "sun",
                                CR: "mon",
                                CY: "mon",
                                CZ: "mon",
                                DE: "mon",
                                DJ: "sat",
                                DK: "mon",
                                DM: "sun",
                                DO: "sun",
                                DZ: "sat",
                                EC: "mon",
                                EE: "mon",
                                EG: "sat",
                                ES: "mon",
                                ET: "sun",
                                FI: "mon",
                                FJ: "mon",
                                FO: "mon",
                                FR: "mon",
                                GB: "mon",
                                "GB-alt-variant": "sun",
                                GE: "mon",
                                GF: "mon",
                                GP: "mon",
                                GR: "mon",
                                GT: "sun",
                                GU: "sun",
                                HK: "sun",
                                HN: "sun",
                                HR: "mon",
                                HU: "mon",
                                ID: "sun",
                                IE: "mon",
                                IL: "sun",
                                IN: "sun",
                                IQ: "sat",
                                IR: "sat",
                                IS: "mon",
                                IT: "mon",
                                JM: "sun",
                                JO: "sat",
                                JP: "sun",
                                KE: "sun",
                                KG: "mon",
                                KH: "sun",
                                KR: "sun",
                                KW: "sat",
                                KZ: "mon",
                                LA: "sun",
                                LB: "mon",
                                LI: "mon",
                                LK: "mon",
                                LT: "mon",
                                LU: "mon",
                                LV: "mon",
                                LY: "sat",
                                MC: "mon",
                                MD: "mon",
                                ME: "mon",
                                MH: "sun",
                                MK: "mon",
                                MM: "sun",
                                MN: "mon",
                                MO: "sun",
                                MQ: "mon",
                                MT: "sun",
                                MV: "fri",
                                MX: "sun",
                                MY: "mon",
                                MZ: "sun",
                                NI: "sun",
                                NL: "mon",
                                NO: "mon",
                                NP: "sun",
                                NZ: "mon",
                                OM: "sat",
                                PA: "sun",
                                PE: "sun",
                                PH: "sun",
                                PK: "sun",
                                PL: "mon",
                                PR: "sun",
                                PT: "sun",
                                PY: "sun",
                                QA: "sat",
                                RE: "mon",
                                RO: "mon",
                                RS: "mon",
                                RU: "mon",
                                SA: "sun",
                                SD: "sat",
                                SE: "mon",
                                SG: "sun",
                                SI: "mon",
                                SK: "mon",
                                SM: "mon",
                                SV: "sun",
                                SY: "sat",
                                TH: "sun",
                                TJ: "mon",
                                TM: "mon",
                                TR: "mon",
                                TT: "sun",
                                TW: "sun",
                                UA: "mon",
                                UM: "sun",
                                US: "sun",
                                UY: "mon",
                                UZ: "mon",
                                VA: "mon",
                                VE: "sun",
                                VI: "sun",
                                VN: "mon",
                                WS: "sun",
                                XK: "mon",
                                YE: "sun",
                                ZA: "sun",
                                ZW: "sun"
                            },
                            weekendStart: {
                                "001": "sat",
                                AE: "fri",
                                AF: "thu",
                                BH: "fri",
                                DZ: "fri",
                                EG: "fri",
                                IL: "fri",
                                IN: "sun",
                                IQ: "fri",
                                IR: "fri",
                                JO: "fri",
                                KW: "fri",
                                LY: "fri",
                                OM: "fri",
                                QA: "fri",
                                SA: "fri",
                                SD: "fri",
                                SY: "fri",
                                UG: "sun",
                                YE: "fri"
                            },
                            weekendEnd: {
                                "001": "sun",
                                AE: "sat",
                                AF: "fri",
                                BH: "sat",
                                DZ: "sat",
                                EG: "sat",
                                IL: "sat",
                                IQ: "sat",
                                IR: "fri",
                                JO: "sat",
                                KW: "sat",
                                LY: "sat",
                                OM: "sat",
                                QA: "sat",
                                SA: "sat",
                                SD: "sat",
                                SY: "sat",
                                YE: "sat"
                            },
                            af: {
                                _ordering: "weekOfDate weekOfInterval weekOfMonth"
                            },
                            "am az bs cs cy da el et hi ky lt mk sk ta th": {
                                _ordering: "weekOfYear weekOfMonth"
                            },
                            "ar fil gu hu hy id kk ko": {
                                _ordering: "weekOfMonth"
                            },
                            "be ro ru": {
                                _ordering: "weekOfInterval weekOfMonth"
                            },
                            "bg de iw pt ur zh": {
                                _ordering: "weekOfDate weekOfMonth weekOfInterval"
                            },
                            "ca es fr gl": {
                                _ordering: "weekOfDate"
                            },
                            "en bn ja ka": {
                                _ordering: "weekOfDate weekOfMonth"
                            },
                            eu: {
                                _ordering: "weekOfMonth weekOfDate"
                            },
                            "fa hr it lv pl si sr uk uz": {
                                _ordering: "weekOfMonth weekOfInterval"
                            },
                            "fi zh-TW": {
                                _ordering: "weekOfYear weekOfDate weekOfMonth"
                            },
                            "is mn no sv vi": {
                                _ordering: "weekOfYear weekOfMonth weekOfInterval"
                            },
                            "km mr": {
                                _ordering: "weekOfMonth weekOfYear"
                            },
                            "kn ml pa": {
                                _ordering: "weekOfMonth weekOfDate weekOfYear"
                            },
                            "lo sq": {
                                _ordering: "weekOfMonth weekOfInterval weekOfDate weekOfYear"
                            },
                            "ms tr": {
                                _ordering: "weekOfMonth weekOfYear weekOfInterval weekOfDate"
                            },
                            nl: {
                                _ordering: "weekOfDate weekOfYear weekOfMonth"
                            },
                            sl: {
                                _ordering: "weekOfInterval"
                            },
                            "sw te": {
                                _ordering: "weekOfMonth weekOfInterval weekOfYear"
                            },
                            und: {
                                _ordering: "weekOfYear"
                            },
                            zu: {
                                _ordering: "weekOfYear weekOfInterval"
                            }
                        },
                        currencyData: {
                            fractions: {
                                ADP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                AFN: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ALL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                AMD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                BHD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                BIF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                BYN: {
                                    _rounding: "0",
                                    _digits: "2"
                                },
                                BYR: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                CAD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "5"
                                },
                                CHF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "5"
                                },
                                CLF: {
                                    _rounding: "0",
                                    _digits: "4"
                                },
                                CLP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                COP: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                CRC: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                CZK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                DEFAULT: {
                                    _rounding: "0",
                                    _digits: "2"
                                },
                                DJF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                DKK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "50"
                                },
                                ESP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                GNF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                GYD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                HUF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                IDR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                IQD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                IRR: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ISK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ITL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                JOD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                JPY: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KMF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KPW: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KRW: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KWD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                LAK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LBP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LUF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LYD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                MGA: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MGF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MMK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MNT: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                MRO: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MUR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                NOK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                OMR: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                PKR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                PYG: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                RSD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                RWF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SEK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                SLL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SOS: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                STD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SYP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TMM: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TND: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                TRL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TWD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                TZS: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                UGX: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                UYI: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                UYW: {
                                    _rounding: "0",
                                    _digits: "4"
                                },
                                UZS: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                VEF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                VND: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                VUV: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XAF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XOF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XPF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                YER: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ZMK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ZWD: {
                                    _rounding: "0",
                                    _digits: "0"
                                }
                            },
                            region: {
                                AC: [{
                                    SHP: {
                                        _from: "1976-01-01"
                                    }
                                }],
                                AD: [{
                                    ESP: {
                                        _from: "1873-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    ADP: {
                                        _from: "1936-01-01",
                                        _to: "2001-12-31"
                                    }
                                }, {
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AE: [{
                                    AED: {
                                        _from: "1973-05-19"
                                    }
                                }],
                                AF: [{
                                    AFA: {
                                        _from: "1927-03-14",
                                        _to: "2002-12-31"
                                    }
                                }, {
                                    AFN: {
                                        _from: "2002-10-07"
                                    }
                                }],
                                AG: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                AI: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                AL: [{
                                    ALK: {
                                        _from: "1946-11-01",
                                        _to: "1965-08-16"
                                    }
                                }, {
                                    ALL: {
                                        _from: "1965-08-16"
                                    }
                                }],
                                AM: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-11-22"
                                    }
                                }, {
                                    AMD: {
                                        _from: "1993-11-22"
                                    }
                                }],
                                AO: [{
                                    AOK: {
                                        _from: "1977-01-08",
                                        _to: "1991-03-01"
                                    }
                                }, {
                                    AON: {
                                        _from: "1990-09-25",
                                        _to: "2000-02-01"
                                    }
                                }, {
                                    AOR: {
                                        _from: "1995-07-01",
                                        _to: "2000-02-01"
                                    }
                                }, {
                                    AOA: {
                                        _from: "1999-12-13"
                                    }
                                }],
                                AQ: [{
                                    XXX: {
                                        _tender: "false"
                                    }
                                }],
                                AR: [{
                                    ARM: {
                                        _from: "1881-11-05",
                                        _to: "1970-01-01"
                                    }
                                }, {
                                    ARL: {
                                        _from: "1970-01-01",
                                        _to: "1983-06-01"
                                    }
                                }, {
                                    ARP: {
                                        _from: "1983-06-01",
                                        _to: "1985-06-14"
                                    }
                                }, {
                                    ARA: {
                                        _from: "1985-06-14",
                                        _to: "1992-01-01"
                                    }
                                }, {
                                    ARS: {
                                        _from: "1992-01-01"
                                    }
                                }],
                                AS: [{
                                    USD: {
                                        _from: "1904-07-16"
                                    }
                                }],
                                AT: [{
                                    ATS: {
                                        _from: "1947-12-04",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AU: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                AW: [{
                                    ANG: {
                                        _from: "1940-05-10",
                                        _to: "1986-01-01"
                                    }
                                }, {
                                    AWG: {
                                        _from: "1986-01-01"
                                    }
                                }],
                                AX: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AZ: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1994-01-01"
                                    }
                                }, {
                                    AZM: {
                                        _from: "1993-11-22",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    AZN: {
                                        _from: "2006-01-01"
                                    }
                                }],
                                BA: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1992-07-01"
                                    }
                                }, {
                                    YUR: {
                                        _from: "1992-07-01",
                                        _to: "1993-10-01"
                                    }
                                }, {
                                    BAD: {
                                        _from: "1992-07-01",
                                        _to: "1994-08-15"
                                    }
                                }, {
                                    BAN: {
                                        _from: "1994-08-15",
                                        _to: "1997-07-01"
                                    }
                                }, {
                                    BAM: {
                                        _from: "1995-01-01"
                                    }
                                }],
                                BB: [{
                                    XCD: {
                                        _from: "1965-10-06",
                                        _to: "1973-12-03"
                                    }
                                }, {
                                    BBD: {
                                        _from: "1973-12-03"
                                    }
                                }],
                                BD: [{
                                    INR: {
                                        _from: "1835-08-17",
                                        _to: "1948-04-01"
                                    }
                                }, {
                                    PKR: {
                                        _from: "1948-04-01",
                                        _to: "1972-01-01"
                                    }
                                }, {
                                    BDT: {
                                        _from: "1972-01-01"
                                    }
                                }],
                                BE: [{
                                    NLG: {
                                        _from: "1816-12-15",
                                        _to: "1831-02-07"
                                    }
                                }, {
                                    BEF: {
                                        _from: "1831-02-07",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    BEC: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    BEL: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                BF: [{
                                    XOF: {
                                        _from: "1984-08-04"
                                    }
                                }],
                                BG: [{
                                    BGO: {
                                        _from: "1879-07-08",
                                        _to: "1952-05-12"
                                    }
                                }, {
                                    BGM: {
                                        _from: "1952-05-12",
                                        _to: "1962-01-01"
                                    }
                                }, {
                                    BGL: {
                                        _from: "1962-01-01",
                                        _to: "1999-07-05"
                                    }
                                }, {
                                    BGN: {
                                        _from: "1999-07-05"
                                    }
                                }],
                                BH: [{
                                    BHD: {
                                        _from: "1965-10-16"
                                    }
                                }],
                                BI: [{
                                    BIF: {
                                        _from: "1964-05-19"
                                    }
                                }],
                                BJ: [{
                                    XOF: {
                                        _from: "1975-11-30"
                                    }
                                }],
                                BL: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                BM: [{
                                    BMD: {
                                        _from: "1970-02-06"
                                    }
                                }],
                                BN: [{
                                    MYR: {
                                        _from: "1963-09-16",
                                        _to: "1967-06-12"
                                    }
                                }, {
                                    BND: {
                                        _from: "1967-06-12"
                                    }
                                }],
                                BO: [{
                                    BOV: {
                                        _tender: "false"
                                    }
                                }, {
                                    BOL: {
                                        _from: "1863-06-23",
                                        _to: "1963-01-01"
                                    }
                                }, {
                                    BOP: {
                                        _from: "1963-01-01",
                                        _to: "1986-12-31"
                                    }
                                }, {
                                    BOB: {
                                        _from: "1987-01-01"
                                    }
                                }],
                                BQ: [{
                                    ANG: {
                                        _from: "2010-10-10",
                                        _to: "2011-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "2011-01-01"
                                    }
                                }],
                                BR: [{
                                    BRZ: {
                                        _from: "1942-11-01",
                                        _to: "1967-02-13"
                                    }
                                }, {
                                    BRB: {
                                        _from: "1967-02-13",
                                        _to: "1986-02-28"
                                    }
                                }, {
                                    BRC: {
                                        _from: "1986-02-28",
                                        _to: "1989-01-15"
                                    }
                                }, {
                                    BRN: {
                                        _from: "1989-01-15",
                                        _to: "1990-03-16"
                                    }
                                }, {
                                    BRE: {
                                        _from: "1990-03-16",
                                        _to: "1993-08-01"
                                    }
                                }, {
                                    BRR: {
                                        _from: "1993-08-01",
                                        _to: "1994-07-01"
                                    }
                                }, {
                                    BRL: {
                                        _from: "1994-07-01"
                                    }
                                }],
                                BS: [{
                                    BSD: {
                                        _from: "1966-05-25"
                                    }
                                }],
                                BT: [{
                                    INR: {
                                        _from: "1907-01-01"
                                    }
                                }, {
                                    BTN: {
                                        _from: "1974-04-16"
                                    }
                                }],
                                BU: [{
                                    BUK: {
                                        _from: "1952-07-01",
                                        _to: "1989-06-18"
                                    }
                                }],
                                BV: [{
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                BW: [{
                                    ZAR: {
                                        _from: "1961-02-14",
                                        _to: "1976-08-23"
                                    }
                                }, {
                                    BWP: {
                                        _from: "1976-08-23"
                                    }
                                }],
                                BY: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1994-11-08"
                                    }
                                }, {
                                    BYB: {
                                        _from: "1994-08-01",
                                        _to: "2000-12-31"
                                    }
                                }, {
                                    BYR: {
                                        _from: "2000-01-01",
                                        _to: "2017-01-01"
                                    }
                                }, {
                                    BYN: {
                                        _from: "2016-07-01"
                                    }
                                }],
                                BZ: [{
                                    BZD: {
                                        _from: "1974-01-01"
                                    }
                                }],
                                CA: [{
                                    CAD: {
                                        _from: "1858-01-01"
                                    }
                                }],
                                CC: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                CD: [{
                                    ZRZ: {
                                        _from: "1971-10-27",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    ZRN: {
                                        _from: "1993-11-01",
                                        _to: "1998-07-01"
                                    }
                                }, {
                                    CDF: {
                                        _from: "1998-07-01"
                                    }
                                }],
                                CF: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                CG: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                CH: [{
                                    CHE: {
                                        _tender: "false"
                                    }
                                }, {
                                    CHW: {
                                        _tender: "false"
                                    }
                                }, {
                                    CHF: {
                                        _from: "1799-03-17"
                                    }
                                }],
                                CI: [{
                                    XOF: {
                                        _from: "1958-12-04"
                                    }
                                }],
                                CK: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                CL: [{
                                    CLF: {
                                        _tender: "false"
                                    }
                                }, {
                                    CLE: {
                                        _from: "1960-01-01",
                                        _to: "1975-09-29"
                                    }
                                }, {
                                    CLP: {
                                        _from: "1975-09-29"
                                    }
                                }],
                                CM: [{
                                    XAF: {
                                        _from: "1973-04-01"
                                    }
                                }],
                                CN: [{
                                    CNY: {
                                        _from: "1953-03-01"
                                    }
                                }, {
                                    CNX: {
                                        _tender: "false",
                                        _from: "1979-01-01",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    CNH: {
                                        _tender: "false",
                                        _from: "2010-07-19"
                                    }
                                }],
                                CO: [{
                                    COU: {
                                        _tender: "false"
                                    }
                                }, {
                                    COP: {
                                        _from: "1905-01-01"
                                    }
                                }],
                                CP: [{
                                    XXX: {
                                        _tender: "false"
                                    }
                                }],
                                CR: [{
                                    CRC: {
                                        _from: "1896-10-26"
                                    }
                                }],
                                CS: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    CSD: {
                                        _from: "2002-05-15",
                                        _to: "2006-06-03"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2003-02-04",
                                        _to: "2006-06-03"
                                    }
                                }],
                                CU: [{
                                    CUP: {
                                        _from: "1859-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1899-01-01",
                                        _to: "1959-01-01"
                                    }
                                }, {
                                    CUC: {
                                        _from: "1994-01-01"
                                    }
                                }],
                                CV: [{
                                    PTE: {
                                        _from: "1911-05-22",
                                        _to: "1975-07-05"
                                    }
                                }, {
                                    CVE: {
                                        _from: "1914-01-01"
                                    }
                                }],
                                CW: [{
                                    ANG: {
                                        _from: "2010-10-10"
                                    }
                                }],
                                CX: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                CY: [{
                                    CYP: {
                                        _from: "1914-09-10",
                                        _to: "2008-01-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2008-01-01"
                                    }
                                }],
                                CZ: [{
                                    CSK: {
                                        _from: "1953-06-01",
                                        _to: "1993-03-01"
                                    }
                                }, {
                                    CZK: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                DD: [{
                                    DDM: {
                                        _from: "1948-07-20",
                                        _to: "1990-10-02"
                                    }
                                }],
                                DE: [{
                                    DEM: {
                                        _from: "1948-06-20",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                DG: [{
                                    USD: {
                                        _from: "1965-11-08"
                                    }
                                }],
                                DJ: [{
                                    DJF: {
                                        _from: "1977-06-27"
                                    }
                                }],
                                DK: [{
                                    DKK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                DM: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                DO: [{
                                    USD: {
                                        _from: "1905-06-21",
                                        _to: "1947-10-01"
                                    }
                                }, {
                                    DOP: {
                                        _from: "1947-10-01"
                                    }
                                }],
                                DZ: [{
                                    DZD: {
                                        _from: "1964-04-01"
                                    }
                                }],
                                EA: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                EC: [{
                                    ECS: {
                                        _from: "1884-04-01",
                                        _to: "2000-10-02"
                                    }
                                }, {
                                    ECV: {
                                        _tender: "false",
                                        _from: "1993-05-23",
                                        _to: "2000-01-09"
                                    }
                                }, {
                                    USD: {
                                        _from: "2000-10-02"
                                    }
                                }],
                                EE: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-06-20"
                                    }
                                }, {
                                    EEK: {
                                        _from: "1992-06-21",
                                        _to: "2010-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2011-01-01"
                                    }
                                }],
                                EG: [{
                                    EGP: {
                                        _from: "1885-11-14"
                                    }
                                }],
                                EH: [{
                                    MAD: {
                                        _from: "1976-02-26"
                                    }
                                }],
                                ER: [{
                                    ETB: {
                                        _from: "1993-05-24",
                                        _to: "1997-11-08"
                                    }
                                }, {
                                    ERN: {
                                        _from: "1997-11-08"
                                    }
                                }],
                                ES: [{
                                    ESP: {
                                        _from: "1868-10-19",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    ESB: {
                                        _tender: "false",
                                        _from: "1975-01-01",
                                        _to: "1994-12-31"
                                    }
                                }, {
                                    ESA: {
                                        _tender: "false",
                                        _from: "1978-01-01",
                                        _to: "1981-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                ET: [{
                                    ETB: {
                                        _from: "1976-09-15"
                                    }
                                }],
                                EU: [{
                                    XEU: {
                                        _tender: "false",
                                        _from: "1979-01-01",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                FI: [{
                                    FIM: {
                                        _from: "1963-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                FJ: [{
                                    FJD: {
                                        _from: "1969-01-13"
                                    }
                                }],
                                FK: [{
                                    FKP: {
                                        _from: "1901-01-01"
                                    }
                                }],
                                FM: [{
                                    JPY: {
                                        _from: "1914-10-03",
                                        _to: "1944-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                FO: [{
                                    DKK: {
                                        _from: "1948-01-01"
                                    }
                                }],
                                FR: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GA: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                GB: [{
                                    GBP: {
                                        _from: "1694-07-27"
                                    }
                                }],
                                GD: [{
                                    XCD: {
                                        _from: "1967-02-27"
                                    }
                                }],
                                GE: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-06-11"
                                    }
                                }, {
                                    GEK: {
                                        _from: "1993-04-05",
                                        _to: "1995-09-25"
                                    }
                                }, {
                                    GEL: {
                                        _from: "1995-09-23"
                                    }
                                }],
                                GF: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GG: [{
                                    GBP: {
                                        _from: "1830-01-01"
                                    }
                                }],
                                GH: [{
                                    GHC: {
                                        _from: "1979-03-09",
                                        _to: "2007-12-31"
                                    }
                                }, {
                                    GHS: {
                                        _from: "2007-07-03"
                                    }
                                }],
                                GI: [{
                                    GIP: {
                                        _from: "1713-01-01"
                                    }
                                }],
                                GL: [{
                                    DKK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                GM: [{
                                    GMD: {
                                        _from: "1971-07-01"
                                    }
                                }],
                                GN: [{
                                    GNS: {
                                        _from: "1972-10-02",
                                        _to: "1986-01-06"
                                    }
                                }, {
                                    GNF: {
                                        _from: "1986-01-06"
                                    }
                                }],
                                GP: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GQ: [{
                                    GQE: {
                                        _from: "1975-07-07",
                                        _to: "1986-06-01"
                                    }
                                }, {
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                GR: [{
                                    GRD: {
                                        _from: "1954-05-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2001-01-01"
                                    }
                                }],
                                GS: [{
                                    GBP: {
                                        _from: "1908-01-01"
                                    }
                                }],
                                GT: [{
                                    GTQ: {
                                        _from: "1925-05-27"
                                    }
                                }],
                                GU: [{
                                    USD: {
                                        _from: "1944-08-21"
                                    }
                                }],
                                GW: [{
                                    GWE: {
                                        _from: "1914-01-01",
                                        _to: "1976-02-28"
                                    }
                                }, {
                                    GWP: {
                                        _from: "1976-02-28",
                                        _to: "1997-03-31"
                                    }
                                }, {
                                    XOF: {
                                        _from: "1997-03-31"
                                    }
                                }],
                                GY: [{
                                    GYD: {
                                        _from: "1966-05-26"
                                    }
                                }],
                                HK: [{
                                    HKD: {
                                        _from: "1895-02-02"
                                    }
                                }],
                                HM: [{
                                    AUD: {
                                        _from: "1967-02-16"
                                    }
                                }],
                                HN: [{
                                    HNL: {
                                        _from: "1926-04-03"
                                    }
                                }],
                                HR: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1991-12-23"
                                    }
                                }, {
                                    HRD: {
                                        _from: "1991-12-23",
                                        _to: "1995-01-01"
                                    }
                                }, {
                                    HRK: {
                                        _from: "1994-05-30"
                                    }
                                }],
                                HT: [{
                                    HTG: {
                                        _from: "1872-08-26"
                                    }
                                }, {
                                    USD: {
                                        _from: "1915-01-01"
                                    }
                                }],
                                HU: [{
                                    HUF: {
                                        _from: "1946-07-23"
                                    }
                                }],
                                IC: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                ID: [{
                                    IDR: {
                                        _from: "1965-12-13"
                                    }
                                }],
                                IE: [{
                                    GBP: {
                                        _from: "1800-01-01",
                                        _to: "1922-01-01"
                                    }
                                }, {
                                    IEP: {
                                        _from: "1922-01-01",
                                        _to: "2002-02-09"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                IL: [{
                                    ILP: {
                                        _from: "1948-08-16",
                                        _to: "1980-02-22"
                                    }
                                }, {
                                    ILR: {
                                        _from: "1980-02-22",
                                        _to: "1985-09-04"
                                    }
                                }, {
                                    ILS: {
                                        _from: "1985-09-04"
                                    }
                                }],
                                IM: [{
                                    GBP: {
                                        _from: "1840-01-03"
                                    }
                                }],
                                IN: [{
                                    INR: {
                                        _from: "1835-08-17"
                                    }
                                }],
                                IO: [{
                                    USD: {
                                        _from: "1965-11-08"
                                    }
                                }],
                                IQ: [{
                                    EGP: {
                                        _from: "1920-11-11",
                                        _to: "1931-04-19"
                                    }
                                }, {
                                    INR: {
                                        _from: "1920-11-11",
                                        _to: "1931-04-19"
                                    }
                                }, {
                                    IQD: {
                                        _from: "1931-04-19"
                                    }
                                }],
                                IR: [{
                                    IRR: {
                                        _from: "1932-05-13"
                                    }
                                }],
                                IS: [{
                                    DKK: {
                                        _from: "1873-05-27",
                                        _to: "1918-12-01"
                                    }
                                }, {
                                    ISJ: {
                                        _from: "1918-12-01",
                                        _to: "1981-01-01"
                                    }
                                }, {
                                    ISK: {
                                        _from: "1981-01-01"
                                    }
                                }],
                                IT: [{
                                    ITL: {
                                        _from: "1862-08-24",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                JE: [{
                                    GBP: {
                                        _from: "1837-01-01"
                                    }
                                }],
                                JM: [{
                                    JMD: {
                                        _from: "1969-09-08"
                                    }
                                }],
                                JO: [{
                                    JOD: {
                                        _from: "1950-07-01"
                                    }
                                }],
                                JP: [{
                                    JPY: {
                                        _from: "1871-06-01"
                                    }
                                }],
                                KE: [{
                                    KES: {
                                        _from: "1966-09-14"
                                    }
                                }],
                                KG: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-05-10"
                                    }
                                }, {
                                    KGS: {
                                        _from: "1993-05-10"
                                    }
                                }],
                                KH: [{
                                    KHR: {
                                        _from: "1980-03-20"
                                    }
                                }],
                                KI: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                KM: [{
                                    KMF: {
                                        _from: "1975-07-06"
                                    }
                                }],
                                KN: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                KP: [{
                                    KPW: {
                                        _from: "1959-04-17"
                                    }
                                }],
                                KR: [{
                                    KRO: {
                                        _from: "1945-08-15",
                                        _to: "1953-02-15"
                                    }
                                }, {
                                    KRH: {
                                        _from: "1953-02-15",
                                        _to: "1962-06-10"
                                    }
                                }, {
                                    KRW: {
                                        _from: "1962-06-10"
                                    }
                                }],
                                KW: [{
                                    KWD: {
                                        _from: "1961-04-01"
                                    }
                                }],
                                KY: [{
                                    JMD: {
                                        _from: "1969-09-08",
                                        _to: "1971-01-01"
                                    }
                                }, {
                                    KYD: {
                                        _from: "1971-01-01"
                                    }
                                }],
                                KZ: [{
                                    KZT: {
                                        _from: "1993-11-05"
                                    }
                                }],
                                LA: [{
                                    LAK: {
                                        _from: "1979-12-10"
                                    }
                                }],
                                LB: [{
                                    LBP: {
                                        _from: "1948-02-02"
                                    }
                                }],
                                LC: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                LI: [{
                                    CHF: {
                                        _from: "1921-02-01"
                                    }
                                }],
                                LK: [{
                                    LKR: {
                                        _from: "1978-05-22"
                                    }
                                }],
                                LR: [{
                                    LRD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                LS: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    LSL: {
                                        _from: "1980-01-22"
                                    }
                                }],
                                LT: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-10-01"
                                    }
                                }, {
                                    LTT: {
                                        _from: "1992-10-01",
                                        _to: "1993-06-25"
                                    }
                                }, {
                                    LTL: {
                                        _from: "1993-06-25",
                                        _to: "2014-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2015-01-01"
                                    }
                                }],
                                LU: [{
                                    LUF: {
                                        _from: "1944-09-04",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    LUC: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    LUL: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                LV: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-07-20"
                                    }
                                }, {
                                    LVR: {
                                        _from: "1992-05-07",
                                        _to: "1993-10-17"
                                    }
                                }, {
                                    LVL: {
                                        _from: "1993-06-28",
                                        _to: "2013-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2014-01-01"
                                    }
                                }],
                                LY: [{
                                    LYD: {
                                        _from: "1971-09-01"
                                    }
                                }],
                                MA: [{
                                    MAF: {
                                        _from: "1881-01-01",
                                        _to: "1959-10-17"
                                    }
                                }, {
                                    MAD: {
                                        _from: "1959-10-17"
                                    }
                                }],
                                MC: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    MCF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MD: [{
                                    MDC: {
                                        _from: "1992-06-01",
                                        _to: "1993-11-29"
                                    }
                                }, {
                                    MDL: {
                                        _from: "1993-11-29"
                                    }
                                }],
                                ME: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    DEM: {
                                        _from: "1999-10-02",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2002-01-01"
                                    }
                                }],
                                MF: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MG: [{
                                    MGF: {
                                        _from: "1963-07-01",
                                        _to: "2004-12-31"
                                    }
                                }, {
                                    MGA: {
                                        _from: "1983-11-01"
                                    }
                                }],
                                MH: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                MK: [{
                                    MKN: {
                                        _from: "1992-04-26",
                                        _to: "1993-05-20"
                                    }
                                }, {
                                    MKD: {
                                        _from: "1993-05-20"
                                    }
                                }],
                                ML: [{
                                    XOF: {
                                        _from: "1958-11-24",
                                        _to: "1962-07-02"
                                    }
                                }, {
                                    MLF: {
                                        _from: "1962-07-02",
                                        _to: "1984-08-31"
                                    }
                                }, {
                                    XOF: {
                                        _from: "1984-06-01"
                                    }
                                }],
                                MM: [{
                                    BUK: {
                                        _from: "1952-07-01",
                                        _to: "1989-06-18"
                                    }
                                }, {
                                    MMK: {
                                        _from: "1989-06-18"
                                    }
                                }],
                                MN: [{
                                    MNT: {
                                        _from: "1915-03-01"
                                    }
                                }],
                                MO: [{
                                    MOP: {
                                        _from: "1901-01-01"
                                    }
                                }],
                                MP: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                MQ: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MR: [{
                                    XOF: {
                                        _from: "1958-11-28",
                                        _to: "1973-06-29"
                                    }
                                }, {
                                    MRO: {
                                        _from: "1973-06-29",
                                        _to: "2018-06-30"
                                    }
                                }, {
                                    MRU: {
                                        _from: "2018-01-01"
                                    }
                                }],
                                MS: [{
                                    XCD: {
                                        _from: "1967-02-27"
                                    }
                                }],
                                MT: [{
                                    MTP: {
                                        _from: "1914-08-13",
                                        _to: "1968-06-07"
                                    }
                                }, {
                                    MTL: {
                                        _from: "1968-06-07",
                                        _to: "2008-01-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2008-01-01"
                                    }
                                }],
                                MU: [{
                                    MUR: {
                                        _from: "1934-04-01"
                                    }
                                }],
                                MV: [{
                                    MVP: {
                                        _from: "1947-01-01",
                                        _to: "1981-07-01"
                                    }
                                }, {
                                    MVR: {
                                        _from: "1981-07-01"
                                    }
                                }],
                                MW: [{
                                    MWK: {
                                        _from: "1971-02-15"
                                    }
                                }],
                                MX: [{
                                    MXV: {
                                        _tender: "false"
                                    }
                                }, {
                                    MXP: {
                                        _from: "1822-01-01",
                                        _to: "1992-12-31"
                                    }
                                }, {
                                    MXN: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                MY: [{
                                    MYR: {
                                        _from: "1963-09-16"
                                    }
                                }],
                                MZ: [{
                                    MZE: {
                                        _from: "1975-06-25",
                                        _to: "1980-06-16"
                                    }
                                }, {
                                    MZM: {
                                        _from: "1980-06-16",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    MZN: {
                                        _from: "2006-07-01"
                                    }
                                }],
                                NA: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    NAD: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                NC: [{
                                    XPF: {
                                        _from: "1985-01-01"
                                    }
                                }],
                                NE: [{
                                    XOF: {
                                        _from: "1958-12-19"
                                    }
                                }],
                                NF: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                NG: [{
                                    NGN: {
                                        _from: "1973-01-01"
                                    }
                                }],
                                NI: [{
                                    NIC: {
                                        _from: "1988-02-15",
                                        _to: "1991-04-30"
                                    }
                                }, {
                                    NIO: {
                                        _from: "1991-04-30"
                                    }
                                }],
                                NL: [{
                                    NLG: {
                                        _from: "1813-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                NO: [{
                                    SEK: {
                                        _from: "1873-05-27",
                                        _to: "1905-06-07"
                                    }
                                }, {
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                NP: [{
                                    INR: {
                                        _from: "1870-01-01",
                                        _to: "1966-10-17"
                                    }
                                }, {
                                    NPR: {
                                        _from: "1933-01-01"
                                    }
                                }],
                                NR: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                NU: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                NZ: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                OM: [{
                                    OMR: {
                                        _from: "1972-11-11"
                                    }
                                }],
                                PA: [{
                                    PAB: {
                                        _from: "1903-11-04"
                                    }
                                }, {
                                    USD: {
                                        _from: "1903-11-18"
                                    }
                                }],
                                PE: [{
                                    PES: {
                                        _from: "1863-02-14",
                                        _to: "1985-02-01"
                                    }
                                }, {
                                    PEI: {
                                        _from: "1985-02-01",
                                        _to: "1991-07-01"
                                    }
                                }, {
                                    PEN: {
                                        _from: "1991-07-01"
                                    }
                                }],
                                PF: [{
                                    XPF: {
                                        _from: "1945-12-26"
                                    }
                                }],
                                PG: [{
                                    AUD: {
                                        _from: "1966-02-14",
                                        _to: "1975-09-16"
                                    }
                                }, {
                                    PGK: {
                                        _from: "1975-09-16"
                                    }
                                }],
                                PH: [{
                                    PHP: {
                                        _from: "1946-07-04"
                                    }
                                }],
                                PK: [{
                                    INR: {
                                        _from: "1835-08-17",
                                        _to: "1947-08-15"
                                    }
                                }, {
                                    PKR: {
                                        _from: "1948-04-01"
                                    }
                                }],
                                PL: [{
                                    PLZ: {
                                        _from: "1950-10-28",
                                        _to: "1994-12-31"
                                    }
                                }, {
                                    PLN: {
                                        _from: "1995-01-01"
                                    }
                                }],
                                PM: [{
                                    FRF: {
                                        _from: "1972-12-21",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                PN: [{
                                    NZD: {
                                        _from: "1969-01-13"
                                    }
                                }],
                                PR: [{
                                    ESP: {
                                        _from: "1800-01-01",
                                        _to: "1898-12-10"
                                    }
                                }, {
                                    USD: {
                                        _from: "1898-12-10"
                                    }
                                }],
                                PS: [{
                                    JOD: {
                                        _from: "1950-07-01",
                                        _to: "1967-06-01"
                                    }
                                }, {
                                    ILP: {
                                        _from: "1967-06-01",
                                        _to: "1980-02-22"
                                    }
                                }, {
                                    ILS: {
                                        _from: "1985-09-04"
                                    }
                                }, {
                                    JOD: {
                                        _from: "1996-02-12"
                                    }
                                }],
                                PT: [{
                                    PTE: {
                                        _from: "1911-05-22",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                PW: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                PY: [{
                                    PYG: {
                                        _from: "1943-11-01"
                                    }
                                }],
                                QA: [{
                                    QAR: {
                                        _from: "1973-05-19"
                                    }
                                }],
                                RE: [{
                                    FRF: {
                                        _from: "1975-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                RO: [{
                                    ROL: {
                                        _from: "1952-01-28",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    RON: {
                                        _from: "2005-07-01"
                                    }
                                }],
                                RS: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    CSD: {
                                        _from: "2002-05-15",
                                        _to: "2006-10-25"
                                    }
                                }, {
                                    RSD: {
                                        _from: "2006-10-25"
                                    }
                                }],
                                RU: [{
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    RUB: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                RW: [{
                                    RWF: {
                                        _from: "1964-05-19"
                                    }
                                }],
                                SA: [{
                                    SAR: {
                                        _from: "1952-10-22"
                                    }
                                }],
                                SB: [{
                                    AUD: {
                                        _from: "1966-02-14",
                                        _to: "1978-06-30"
                                    }
                                }, {
                                    SBD: {
                                        _from: "1977-10-24"
                                    }
                                }],
                                SC: [{
                                    SCR: {
                                        _from: "1903-11-01"
                                    }
                                }],
                                SD: [{
                                    EGP: {
                                        _from: "1889-01-19",
                                        _to: "1958-01-01"
                                    }
                                }, {
                                    GBP: {
                                        _from: "1889-01-19",
                                        _to: "1958-01-01"
                                    }
                                }, {
                                    SDP: {
                                        _from: "1957-04-08",
                                        _to: "1998-06-01"
                                    }
                                }, {
                                    SDD: {
                                        _from: "1992-06-08",
                                        _to: "2007-06-30"
                                    }
                                }, {
                                    SDG: {
                                        _from: "2007-01-10"
                                    }
                                }],
                                SE: [{
                                    SEK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                SG: [{
                                    MYR: {
                                        _from: "1963-09-16",
                                        _to: "1967-06-12"
                                    }
                                }, {
                                    SGD: {
                                        _from: "1967-06-12"
                                    }
                                }],
                                SH: [{
                                    SHP: {
                                        _from: "1917-02-15"
                                    }
                                }],
                                SI: [{
                                    SIT: {
                                        _from: "1992-10-07",
                                        _to: "2007-01-14"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2007-01-01"
                                    }
                                }],
                                SJ: [{
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                SK: [{
                                    CSK: {
                                        _from: "1953-06-01",
                                        _to: "1992-12-31"
                                    }
                                }, {
                                    SKK: {
                                        _from: "1992-12-31",
                                        _to: "2009-01-01"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2009-01-01"
                                    }
                                }],
                                SL: [{
                                    GBP: {
                                        _from: "1808-11-30",
                                        _to: "1966-02-04"
                                    }
                                }, {
                                    SLL: {
                                        _from: "1964-08-04"
                                    }
                                }],
                                SM: [{
                                    ITL: {
                                        _from: "1865-12-23",
                                        _to: "2001-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                SN: [{
                                    XOF: {
                                        _from: "1959-04-04"
                                    }
                                }],
                                SO: [{
                                    SOS: {
                                        _from: "1960-07-01"
                                    }
                                }],
                                SR: [{
                                    NLG: {
                                        _from: "1815-11-20",
                                        _to: "1940-05-10"
                                    }
                                }, {
                                    SRG: {
                                        _from: "1940-05-10",
                                        _to: "2003-12-31"
                                    }
                                }, {
                                    SRD: {
                                        _from: "2004-01-01"
                                    }
                                }],
                                SS: [{
                                    SDG: {
                                        _from: "2007-01-10",
                                        _to: "2011-09-01"
                                    }
                                }, {
                                    SSP: {
                                        _from: "2011-07-18"
                                    }
                                }],
                                ST: [{
                                    STD: {
                                        _from: "1977-09-08",
                                        _to: "2017-12-31"
                                    }
                                }, {
                                    STN: {
                                        _from: "2018-01-01"
                                    }
                                }],
                                SU: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }],
                                SV: [{
                                    SVC: {
                                        _from: "1919-11-11",
                                        _to: "2001-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "2001-01-01"
                                    }
                                }],
                                SX: [{
                                    ANG: {
                                        _from: "2010-10-10"
                                    }
                                }],
                                SY: [{
                                    SYP: {
                                        _from: "1948-01-01"
                                    }
                                }],
                                SZ: [{
                                    SZL: {
                                        _from: "1974-09-06"
                                    }
                                }],
                                TA: [{
                                    GBP: {
                                        _from: "1938-01-12"
                                    }
                                }],
                                TC: [{
                                    USD: {
                                        _from: "1969-09-08"
                                    }
                                }],
                                TD: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                TF: [{
                                    FRF: {
                                        _from: "1959-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                TG: [{
                                    XOF: {
                                        _from: "1958-11-28"
                                    }
                                }],
                                TH: [{
                                    THB: {
                                        _from: "1928-04-15"
                                    }
                                }],
                                TJ: [{
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1995-05-10"
                                    }
                                }, {
                                    TJR: {
                                        _from: "1995-05-10",
                                        _to: "2000-10-25"
                                    }
                                }, {
                                    TJS: {
                                        _from: "2000-10-26"
                                    }
                                }],
                                TK: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                TL: [{
                                    TPE: {
                                        _from: "1959-01-02",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    IDR: {
                                        _from: "1975-12-07",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    USD: {
                                        _from: "1999-10-20"
                                    }
                                }],
                                TM: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    TMM: {
                                        _from: "1993-11-01",
                                        _to: "2009-01-01"
                                    }
                                }, {
                                    TMT: {
                                        _from: "2009-01-01"
                                    }
                                }],
                                TN: [{
                                    TND: {
                                        _from: "1958-11-01"
                                    }
                                }],
                                TO: [{
                                    TOP: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                TP: [{
                                    TPE: {
                                        _from: "1959-01-02",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    IDR: {
                                        _from: "1975-12-07",
                                        _to: "2002-05-20"
                                    }
                                }],
                                TR: [{
                                    TRL: {
                                        _from: "1922-11-01",
                                        _to: "2005-12-31"
                                    }
                                }, {
                                    TRY: {
                                        _from: "2005-01-01"
                                    }
                                }],
                                TT: [{
                                    TTD: {
                                        _from: "1964-01-01"
                                    }
                                }],
                                TV: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                TW: [{
                                    TWD: {
                                        _from: "1949-06-15"
                                    }
                                }],
                                TZ: [{
                                    TZS: {
                                        _from: "1966-06-14"
                                    }
                                }],
                                UA: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1992-11-13"
                                    }
                                }, {
                                    UAK: {
                                        _from: "1992-11-13",
                                        _to: "1993-10-17"
                                    }
                                }, {
                                    UAH: {
                                        _from: "1996-09-02"
                                    }
                                }],
                                UG: [{
                                    UGS: {
                                        _from: "1966-08-15",
                                        _to: "1987-05-15"
                                    }
                                }, {
                                    UGX: {
                                        _from: "1987-05-15"
                                    }
                                }],
                                UM: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                US: [{
                                    USN: {
                                        _tender: "false"
                                    }
                                }, {
                                    USS: {
                                        _tender: "false",
                                        _to: "2014-03-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1792-01-01"
                                    }
                                }],
                                UY: [{
                                    UYI: {
                                        _tender: "false"
                                    }
                                }, {
                                    UYW: {
                                        _tender: "false"
                                    }
                                }, {
                                    UYP: {
                                        _from: "1975-07-01",
                                        _to: "1993-03-01"
                                    }
                                }, {
                                    UYU: {
                                        _from: "1993-03-01"
                                    }
                                }],
                                UZ: [{
                                    UZS: {
                                        _from: "1994-07-01"
                                    }
                                }],
                                VA: [{
                                    ITL: {
                                        _from: "1870-10-19",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                VC: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                VE: [{
                                    VEB: {
                                        _from: "1871-05-11",
                                        _to: "2008-06-30"
                                    }
                                }, {
                                    VEF: {
                                        _from: "2008-01-01",
                                        _to: "2018-08-20"
                                    }
                                }, {
                                    VES: {
                                        _from: "2018-08-20"
                                    }
                                }],
                                VG: [{
                                    USD: {
                                        _from: "1833-01-01"
                                    }
                                }, {
                                    GBP: {
                                        _from: "1833-01-01",
                                        _to: "1959-01-01"
                                    }
                                }],
                                VI: [{
                                    USD: {
                                        _from: "1837-01-01"
                                    }
                                }],
                                VN: [{
                                    VNN: {
                                        _from: "1978-05-03",
                                        _to: "1985-09-14"
                                    }
                                }, {
                                    VND: {
                                        _from: "1985-09-14"
                                    }
                                }],
                                VU: [{
                                    VUV: {
                                        _from: "1981-01-01"
                                    }
                                }],
                                WF: [{
                                    XPF: {
                                        _from: "1961-07-30"
                                    }
                                }],
                                WS: [{
                                    WST: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                XK: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "1999-09-30"
                                    }
                                }, {
                                    DEM: {
                                        _from: "1999-09-01",
                                        _to: "2002-03-09"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2002-01-01"
                                    }
                                }],
                                YD: [{
                                    YDD: {
                                        _from: "1965-04-01",
                                        _to: "1996-01-01"
                                    }
                                }],
                                YE: [{
                                    YER: {
                                        _from: "1990-05-22"
                                    }
                                }],
                                YT: [{
                                    KMF: {
                                        _from: "1975-01-01",
                                        _to: "1976-02-23"
                                    }
                                }, {
                                    FRF: {
                                        _from: "1976-02-23",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                YU: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1992-07-24"
                                    }
                                }, {
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }],
                                ZA: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    ZAL: {
                                        _tender: "false",
                                        _from: "1985-09-01",
                                        _to: "1995-03-13"
                                    }
                                }],
                                ZM: [{
                                    ZMK: {
                                        _from: "1968-01-16",
                                        _to: "2013-01-01"
                                    }
                                }, {
                                    ZMW: {
                                        _from: "2013-01-01"
                                    }
                                }],
                                ZR: [{
                                    ZRZ: {
                                        _from: "1971-10-27",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    ZRN: {
                                        _from: "1993-11-01",
                                        _to: "1998-07-31"
                                    }
                                }],
                                ZW: [{
                                    RHD: {
                                        _from: "1970-02-17",
                                        _to: "1980-04-18"
                                    }
                                }, {
                                    ZWD: {
                                        _from: "1980-04-18",
                                        _to: "2008-08-01"
                                    }
                                }, {
                                    ZWR: {
                                        _from: "2008-08-01",
                                        _to: "2009-02-02"
                                    }
                                }, {
                                    ZWL: {
                                        _from: "2009-02-02",
                                        _to: "2009-04-12"
                                    }
                                }, {
                                    USD: {
                                        _from: "2009-04-12"
                                    }
                                }],
                                ZZ: [{
                                    XAG: {
                                        _tender: "false"
                                    }
                                }, {
                                    XAU: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBA: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBB: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBC: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBD: {
                                        _tender: "false"
                                    }
                                }, {
                                    XDR: {
                                        _tender: "false"
                                    }
                                }, {
                                    XPD: {
                                        _tender: "false"
                                    }
                                }, {
                                    XPT: {
                                        _tender: "false"
                                    }
                                }, {
                                    XSU: {
                                        _tender: "false"
                                    }
                                }, {
                                    XTS: {
                                        _tender: "false"
                                    }
                                }, {
                                    XUA: {
                                        _tender: "false"
                                    }
                                }, {
                                    XXX: {
                                        _tender: "false"
                                    }
                                }, {
                                    XRE: {
                                        _tender: "false",
                                        _to: "1999-11-30"
                                    }
                                }, {
                                    XFU: {
                                        _tender: "false",
                                        _to: "2013-11-30"
                                    }
                                }, {
                                    XFO: {
                                        _tender: "false",
                                        _from: "1930-01-01",
                                        _to: "2003-04-01"
                                    }
                                }]
                            }
                        },
                        numberingSystems: {
                            adlm: {
                                _digits: "\ud83a\udd50\ud83a\udd51\ud83a\udd52\ud83a\udd53\ud83a\udd54\ud83a\udd55\ud83a\udd56\ud83a\udd57\ud83a\udd58\ud83a\udd59",
                                _type: "numeric"
                            },
                            ahom: {
                                _digits: "\ud805\udf30\ud805\udf31\ud805\udf32\ud805\udf33\ud805\udf34\ud805\udf35\ud805\udf36\ud805\udf37\ud805\udf38\ud805\udf39",
                                _type: "numeric"
                            },
                            arab: {
                                _digits: "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669",
                                _type: "numeric"
                            },
                            arabext: {
                                _digits: "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9",
                                _type: "numeric"
                            },
                            armn: {
                                _rules: "armenian-upper",
                                _type: "algorithmic"
                            },
                            armnlow: {
                                _rules: "armenian-lower",
                                _type: "algorithmic"
                            },
                            bali: {
                                _digits: "\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59",
                                _type: "numeric"
                            },
                            beng: {
                                _digits: "\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef",
                                _type: "numeric"
                            },
                            bhks: {
                                _digits: "\ud807\udc50\ud807\udc51\ud807\udc52\ud807\udc53\ud807\udc54\ud807\udc55\ud807\udc56\ud807\udc57\ud807\udc58\ud807\udc59",
                                _type: "numeric"
                            },
                            brah: {
                                _digits: "\ud804\udc66\ud804\udc67\ud804\udc68\ud804\udc69\ud804\udc6a\ud804\udc6b\ud804\udc6c\ud804\udc6d\ud804\udc6e\ud804\udc6f",
                                _type: "numeric"
                            },
                            cakm: {
                                _digits: "\ud804\udd36\ud804\udd37\ud804\udd38\ud804\udd39\ud804\udd3a\ud804\udd3b\ud804\udd3c\ud804\udd3d\ud804\udd3e\ud804\udd3f",
                                _type: "numeric"
                            },
                            cham: {
                                _digits: "\uaa50\uaa51\uaa52\uaa53\uaa54\uaa55\uaa56\uaa57\uaa58\uaa59",
                                _type: "numeric"
                            },
                            cyrl: {
                                _rules: "cyrillic-lower",
                                _type: "algorithmic"
                            },
                            deva: {
                                _digits: "\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f",
                                _type: "numeric"
                            },
                            ethi: {
                                _rules: "ethiopic",
                                _type: "algorithmic"
                            },
                            fullwide: {
                                _digits: "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19",
                                _type: "numeric"
                            },
                            geor: {
                                _rules: "georgian",
                                _type: "algorithmic"
                            },
                            gong: {
                                _digits: "\ud807\udda0\ud807\udda1\ud807\udda2\ud807\udda3\ud807\udda4\ud807\udda5\ud807\udda6\ud807\udda7\ud807\udda8\ud807\udda9",
                                _type: "numeric"
                            },
                            gonm: {
                                _digits: "\ud807\udd50\ud807\udd51\ud807\udd52\ud807\udd53\ud807\udd54\ud807\udd55\ud807\udd56\ud807\udd57\ud807\udd58\ud807\udd59",
                                _type: "numeric"
                            },
                            grek: {
                                _rules: "greek-upper",
                                _type: "algorithmic"
                            },
                            greklow: {
                                _rules: "greek-lower",
                                _type: "algorithmic"
                            },
                            gujr: {
                                _digits: "\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef",
                                _type: "numeric"
                            },
                            guru: {
                                _digits: "\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f",
                                _type: "numeric"
                            },
                            hanidays: {
                                _rules: "zh/SpelloutRules/spellout-numbering-days",
                                _type: "algorithmic"
                            },
                            hanidec: {
                                _digits: "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d",
                                _type: "numeric"
                            },
                            hans: {
                                _rules: "zh/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            hansfin: {
                                _rules: "zh/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            hant: {
                                _rules: "zh_Hant/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            hantfin: {
                                _rules: "zh_Hant/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            hebr: {
                                _rules: "hebrew",
                                _type: "algorithmic"
                            },
                            hmng: {
                                _digits: "\ud81a\udf50\ud81a\udf51\ud81a\udf52\ud81a\udf53\ud81a\udf54\ud81a\udf55\ud81a\udf56\ud81a\udf57\ud81a\udf58\ud81a\udf59",
                                _type: "numeric"
                            },
                            hmnp: {
                                _digits: "\ud838\udd40\ud838\udd41\ud838\udd42\ud838\udd43\ud838\udd44\ud838\udd45\ud838\udd46\ud838\udd47\ud838\udd48\ud838\udd49",
                                _type: "numeric"
                            },
                            java: {
                                _digits: "\ua9d0\ua9d1\ua9d2\ua9d3\ua9d4\ua9d5\ua9d6\ua9d7\ua9d8\ua9d9",
                                _type: "numeric"
                            },
                            jpan: {
                                _rules: "ja/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            jpanfin: {
                                _rules: "ja/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            jpanyear: {
                                _rules: "ja/SpelloutRules/spellout-numbering-year-latn",
                                _type: "algorithmic"
                            },
                            kali: {
                                _digits: "\ua900\ua901\ua902\ua903\ua904\ua905\ua906\ua907\ua908\ua909",
                                _type: "numeric"
                            },
                            khmr: {
                                _digits: "\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9",
                                _type: "numeric"
                            },
                            knda: {
                                _digits: "\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef",
                                _type: "numeric"
                            },
                            lana: {
                                _digits: "\u1a80\u1a81\u1a82\u1a83\u1a84\u1a85\u1a86\u1a87\u1a88\u1a89",
                                _type: "numeric"
                            },
                            lanatham: {
                                _digits: "\u1a90\u1a91\u1a92\u1a93\u1a94\u1a95\u1a96\u1a97\u1a98\u1a99",
                                _type: "numeric"
                            },
                            laoo: {
                                _digits: "\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9",
                                _type: "numeric"
                            },
                            latn: {
                                _digits: "0123456789",
                                _type: "numeric"
                            },
                            lepc: {
                                _digits: "\u1c40\u1c41\u1c42\u1c43\u1c44\u1c45\u1c46\u1c47\u1c48\u1c49",
                                _type: "numeric"
                            },
                            limb: {
                                _digits: "\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f",
                                _type: "numeric"
                            },
                            mathbold: {
                                _digits: "\ud835\udfce\ud835\udfcf\ud835\udfd0\ud835\udfd1\ud835\udfd2\ud835\udfd3\ud835\udfd4\ud835\udfd5\ud835\udfd6\ud835\udfd7",
                                _type: "numeric"
                            },
                            mathdbl: {
                                _digits: "\ud835\udfd8\ud835\udfd9\ud835\udfda\ud835\udfdb\ud835\udfdc\ud835\udfdd\ud835\udfde\ud835\udfdf\ud835\udfe0\ud835\udfe1",
                                _type: "numeric"
                            },
                            mathmono: {
                                _digits: "\ud835\udff6\ud835\udff7\ud835\udff8\ud835\udff9\ud835\udffa\ud835\udffb\ud835\udffc\ud835\udffd\ud835\udffe\ud835\udfff",
                                _type: "numeric"
                            },
                            mathsanb: {
                                _digits: "\ud835\udfec\ud835\udfed\ud835\udfee\ud835\udfef\ud835\udff0\ud835\udff1\ud835\udff2\ud835\udff3\ud835\udff4\ud835\udff5",
                                _type: "numeric"
                            },
                            mathsans: {
                                _digits: "\ud835\udfe2\ud835\udfe3\ud835\udfe4\ud835\udfe5\ud835\udfe6\ud835\udfe7\ud835\udfe8\ud835\udfe9\ud835\udfea\ud835\udfeb",
                                _type: "numeric"
                            },
                            mlym: {
                                _digits: "\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f",
                                _type: "numeric"
                            },
                            modi: {
                                _digits: "\ud805\ude50\ud805\ude51\ud805\ude52\ud805\ude53\ud805\ude54\ud805\ude55\ud805\ude56\ud805\ude57\ud805\ude58\ud805\ude59",
                                _type: "numeric"
                            },
                            mong: {
                                _digits: "\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819",
                                _type: "numeric"
                            },
                            mroo: {
                                _digits: "\ud81a\ude60\ud81a\ude61\ud81a\ude62\ud81a\ude63\ud81a\ude64\ud81a\ude65\ud81a\ude66\ud81a\ude67\ud81a\ude68\ud81a\ude69",
                                _type: "numeric"
                            },
                            mtei: {
                                _digits: "\uabf0\uabf1\uabf2\uabf3\uabf4\uabf5\uabf6\uabf7\uabf8\uabf9",
                                _type: "numeric"
                            },
                            mymr: {
                                _digits: "\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049",
                                _type: "numeric"
                            },
                            mymrshan: {
                                _digits: "\u1090\u1091\u1092\u1093\u1094\u1095\u1096\u1097\u1098\u1099",
                                _type: "numeric"
                            },
                            mymrtlng: {
                                _digits: "\ua9f0\ua9f1\ua9f2\ua9f3\ua9f4\ua9f5\ua9f6\ua9f7\ua9f8\ua9f9",
                                _type: "numeric"
                            },
                            newa: {
                                _digits: "\ud805\udc50\ud805\udc51\ud805\udc52\ud805\udc53\ud805\udc54\ud805\udc55\ud805\udc56\ud805\udc57\ud805\udc58\ud805\udc59",
                                _type: "numeric"
                            },
                            nkoo: {
                                _digits: "\u07c0\u07c1\u07c2\u07c3\u07c4\u07c5\u07c6\u07c7\u07c8\u07c9",
                                _type: "numeric"
                            },
                            olck: {
                                _digits: "\u1c50\u1c51\u1c52\u1c53\u1c54\u1c55\u1c56\u1c57\u1c58\u1c59",
                                _type: "numeric"
                            },
                            orya: {
                                _digits: "\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f",
                                _type: "numeric"
                            },
                            osma: {
                                _digits: "\ud801\udca0\ud801\udca1\ud801\udca2\ud801\udca3\ud801\udca4\ud801\udca5\ud801\udca6\ud801\udca7\ud801\udca8\ud801\udca9",
                                _type: "numeric"
                            },
                            rohg: {
                                _digits: "\ud803\udd30\ud803\udd31\ud803\udd32\ud803\udd33\ud803\udd34\ud803\udd35\ud803\udd36\ud803\udd37\ud803\udd38\ud803\udd39",
                                _type: "numeric"
                            },
                            roman: {
                                _rules: "roman-upper",
                                _type: "algorithmic"
                            },
                            romanlow: {
                                _rules: "roman-lower",
                                _type: "algorithmic"
                            },
                            saur: {
                                _digits: "\ua8d0\ua8d1\ua8d2\ua8d3\ua8d4\ua8d5\ua8d6\ua8d7\ua8d8\ua8d9",
                                _type: "numeric"
                            },
                            shrd: {
                                _digits: "\ud804\uddd0\ud804\uddd1\ud804\uddd2\ud804\uddd3\ud804\uddd4\ud804\uddd5\ud804\uddd6\ud804\uddd7\ud804\uddd8\ud804\uddd9",
                                _type: "numeric"
                            },
                            sind: {
                                _digits: "\ud804\udef0\ud804\udef1\ud804\udef2\ud804\udef3\ud804\udef4\ud804\udef5\ud804\udef6\ud804\udef7\ud804\udef8\ud804\udef9",
                                _type: "numeric"
                            },
                            sinh: {
                                _digits: "\u0de6\u0de7\u0de8\u0de9\u0dea\u0deb\u0dec\u0ded\u0dee\u0def",
                                _type: "numeric"
                            },
                            sora: {
                                _digits: "\ud804\udcf0\ud804\udcf1\ud804\udcf2\ud804\udcf3\ud804\udcf4\ud804\udcf5\ud804\udcf6\ud804\udcf7\ud804\udcf8\ud804\udcf9",
                                _type: "numeric"
                            },
                            sund: {
                                _digits: "\u1bb0\u1bb1\u1bb2\u1bb3\u1bb4\u1bb5\u1bb6\u1bb7\u1bb8\u1bb9",
                                _type: "numeric"
                            },
                            takr: {
                                _digits: "\ud805\udec0\ud805\udec1\ud805\udec2\ud805\udec3\ud805\udec4\ud805\udec5\ud805\udec6\ud805\udec7\ud805\udec8\ud805\udec9",
                                _type: "numeric"
                            },
                            talu: {
                                _digits: "\u19d0\u19d1\u19d2\u19d3\u19d4\u19d5\u19d6\u19d7\u19d8\u19d9",
                                _type: "numeric"
                            },
                            taml: {
                                _rules: "tamil",
                                _type: "algorithmic"
                            },
                            tamldec: {
                                _digits: "\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef",
                                _type: "numeric"
                            },
                            telu: {
                                _digits: "\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f",
                                _type: "numeric"
                            },
                            thai: {
                                _digits: "\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59",
                                _type: "numeric"
                            },
                            tibt: {
                                _digits: "\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29",
                                _type: "numeric"
                            },
                            tirh: {
                                _digits: "\ud805\udcd0\ud805\udcd1\ud805\udcd2\ud805\udcd3\ud805\udcd4\ud805\udcd5\ud805\udcd6\ud805\udcd7\ud805\udcd8\ud805\udcd9",
                                _type: "numeric"
                            },
                            vaii: {
                                _digits: "\ua620\ua621\ua622\ua623\ua624\ua625\ua626\ua627\ua628\ua629",
                                _type: "numeric"
                            },
                            wara: {
                                _digits: "\ud806\udce0\ud806\udce1\ud806\udce2\ud806\udce3\ud806\udce4\ud806\udce5\ud806\udce6\ud806\udce7\ud806\udce8\ud806\udce9",
                                _type: "numeric"
                            },
                            wcho: {
                                _digits: "\ud838\udef0\ud838\udef1\ud838\udef2\ud838\udef3\ud838\udef4\ud838\udef5\ud838\udef6\ud838\udef7\ud838\udef8\ud838\udef9",
                                _type: "numeric"
                            }
                        }
                    }
                }
            },
        3416:
            /*!***************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/workspaces/m_work_space_month.js ***!
              \***************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 92848));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _date = _interopRequireDefault(__webpack_require__( /*! ../../../core/utils/date */ 41380));
                var _position = __webpack_require__( /*! ../../../core/utils/position */ 41639);
                var _window = __webpack_require__( /*! ../../../core/utils/window */ 3104);
                var _index = __webpack_require__( /*! ../../scheduler/r1/components/index */ 19747);
                var _index2 = __webpack_require__( /*! ../../scheduler/r1/utils/index */ 34396);
                var _m_utils = __webpack_require__( /*! ../m_utils */ 5327);
                var _constants_view = __webpack_require__( /*! ../utils/options/constants_view */ 43582);
                var _m_work_space_indicator = _interopRequireDefault(__webpack_require__( /*! ./m_work_space_indicator */ 6523));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const toMs = _date.default.dateToMilliseconds;
                class SchedulerWorkSpaceMonth extends _m_work_space_indicator.default {
                    get type() {
                        return _constants_view.VIEWS.MONTH
                    }
                    _getElementClass() {
                        return "dx-scheduler-work-space-month"
                    }
                    _getFormat() {
                        return _index2.formatWeekday
                    }
                    _getIntervalBetween(currentDate) {
                        const firstViewDate = this.getStartViewDate();
                        const timeZoneOffset = _date.default.getTimezonesDifference(firstViewDate, currentDate);
                        return currentDate.getTime() - (firstViewDate.getTime() - 36e5 * this.option("startDayHour")) - timeZoneOffset
                    }
                    _getDateGenerationOptions() {
                        return Object.assign({}, super._getDateGenerationOptions(), {
                            cellCountInDay: 1
                        })
                    }
                    getCellWidth() {
                        return this.cache.memo("cellWidth", (() => {
                            let averageWidth = 0;
                            const cells = this._getCells().slice(0, 7);
                            cells.each(((index, element) => {
                                averageWidth += (0, _window.hasWindow)() ? (0, _position.getBoundingRect)(element).width : 0
                            }));
                            return 0 === cells.length ? void 0 : averageWidth / 7
                        }))
                    }
                    _insertAllDayRowsIntoDateTable() {
                        return false
                    }
                    _getCellCoordinatesByIndex(index) {
                        const rowIndex = Math.floor(index / this._getCellCount());
                        const columnIndex = index - this._getCellCount() * rowIndex;
                        return {
                            rowIndex: rowIndex,
                            columnIndex: columnIndex
                        }
                    }
                    _needCreateCrossScrolling() {
                        return this.option("crossScrollingEnabled") || this._isVerticalGroupedWorkSpace()
                    }
                    _getViewStartByOptions() {
                        return _index2.monthUtils.getViewStartByOptions(this.option("startDate"), this.option("currentDate"), this.option("intervalCount"), _date.default.getFirstMonthDate(this.option("startDate")))
                    }
                    _updateIndex(index) {
                        return index
                    }
                    isIndicationAvailable() {
                        return false
                    }
                    getIntervalDuration() {
                        return toMs("day")
                    }
                    getTimePanelWidth() {
                        return 0
                    }
                    supportAllDayRow() {
                        return false
                    }
                    keepOriginalHours() {
                        return true
                    }
                    getWorkSpaceLeftOffset() {
                        return 0
                    }
                    needApplyCollectorOffset() {
                        return true
                    }
                    _getHeaderDate() {
                        return this._getViewStartByOptions()
                    }
                    renderRAllDayPanel() {}
                    renderRTimeTable() {}
                    renderRDateTable() {
                        _m_utils.utils.renovation.renderComponent(this, this._$dateTable, _index.DateTableMonthComponent, "renovatedDateTable", this._getRDateTableProps())
                    }
                    _createWorkSpaceElements() {
                        if (this._isVerticalGroupedWorkSpace()) {
                            this._createWorkSpaceScrollableElements()
                        } else {
                            super._createWorkSpaceElements()
                        }
                    }
                    _updateAllDayVisibility() {
                        return (0, _common.noop)()
                    }
                    _updateAllDayHeight() {
                        return (0, _common.noop)()
                    }
                    _renderTimePanel() {
                        return (0, _common.noop)()
                    }
                    _renderAllDayPanel() {
                        return (0, _common.noop)()
                    }
                    _setMonthClassesToCell($cell, data) {
                        $cell.toggleClass("dx-scheduler-date-table-current-date", data.isCurrentDate).toggleClass("dx-scheduler-date-table-first-of-month", data.isFirstDayMonthHighlighting).toggleClass("dx-scheduler-date-table-other-month", data.otherMonth)
                    }
                    _createAllDayPanelElements() {}
                    _renderTableBody(options) {
                        options.getCellText = (rowIndex, columnIndex) => {
                            const date = this.viewDataProvider.completeViewDataMap[rowIndex][columnIndex].startDate;
                            return _index2.monthUtils.getCellText(date, this.option("intervalCount"))
                        };
                        options.getCellTextClass = "dx-scheduler-date-table-cell-text";
                        options.setAdditionalClasses = this._setMonthClassesToCell.bind(this);
                        super._renderTableBody(options)
                    }
                }(0, _component_registrator.default)("dxSchedulerWorkSpaceMonth", SchedulerWorkSpaceMonth);
                exports.default = SchedulerWorkSpaceMonth
            },
        3455:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/core/view.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.View = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _m_inferno_renderer = __webpack_require__( /*! ../../../../core/m_inferno_renderer */ 21327);
                var _base_component = __webpack_require__( /*! ../../../../core/r1/runtime/inferno/base_component */ 5428);
                var _index = __webpack_require__( /*! ../../../../core/state_manager/index */ 74636);
                var _m_window = __webpack_require__( /*! ../../../../core/utils/m_window */ 14470);
                exports.View = class {
                    constructor() {
                        this.firstRender = true
                    }
                    render(root) {
                        this.root = root;
                        const ViewComponent = this.component;
                        const props = this.getProps();
                        return (0, _index.effect)((() => {
                            this.props = props.value;
                            const content = (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, ViewComponent, Object.assign({}, props.value)));
                            _m_inferno_renderer.infernoRenderer.renderIntoContainer(content, root, !this.firstRender);
                            this.firstRender = false
                        }))
                    }
                    asInferno() {
                        return this.inferno ?? (this.inferno = this._asInferno())
                    }
                    _asInferno() {
                        const view = this;
                        return class extends _base_component.BaseInfernoComponent {
                            constructor() {
                                super();
                                const props = view.getProps();
                                this.unsubscribe = (0, _index.effect)((() => {
                                    view.props = props.value;
                                    this.state ?? (this.state = {
                                        props: props.value
                                    });
                                    if (this.state.props !== props.value && (0, _m_window.hasWindow)()) {
                                        this.setState({
                                            props: props.value
                                        })
                                    }
                                }))
                            }
                            componentWillUnmount() {
                                this.unsubscribe()
                            }
                            render() {
                                const ViewComponent = view.component;
                                return (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, ViewComponent, Object.assign({}, this.state.props)))
                            }
                        }
                    }
                }
            },
        3504:
            /*!************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/m_tooltip.js ***!
              \************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 92848));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 19427));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 64553));
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../ui/popover/ui.popover */ 98894));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class Tooltip extends _ui.default {
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            toolbarItems: [],
                            showCloseButton: false,
                            enableBodyScroll: true,
                            showTitle: false,
                            title: null,
                            titleTemplate: null,
                            onTitleRendered: null,
                            bottomTemplate: null,
                            preventScrollEvents: false,
                            propagateOutsideClick: true
                        })
                    }
                    _render() {
                        var _this$$wrapper;
                        this.$element().addClass("dx-tooltip");
                        null === (_this$$wrapper = this.$wrapper()) || void 0 === _this$$wrapper || _this$$wrapper.addClass("dx-tooltip-wrapper");
                        super._render()
                    }
                    _renderContent() {
                        super._renderContent();
                        this._toggleAriaAttributes()
                    }
                    _toggleAriaDescription(showing) {
                        const {
                            target: target
                        } = this.option();
                        const $target = (0, _renderer.default)(target);
                        const label = showing ? this._contentId : void 0;
                        if (!(0, _type.isWindow)($target.get(0))) {
                            this.setAria("describedby", label, $target)
                        }
                    }
                    _toggleAriaAttributes() {
                        this._contentId = `dx-${new _guid.default}`;
                        this.$overlayContent().attr({
                            id: this._contentId
                        });
                        this._toggleAriaDescription(true)
                    }
                }(0, _component_registrator.default)("dxTooltip", Tooltip);
                exports.default = Tooltip
            },
        3508:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/file_management/provider_base.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _date_serialization = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date_serialization */ 71051));
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _file_system_item = _interopRequireDefault(__webpack_require__( /*! ../file_management/file_system_item */ 50259));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = class {
                    constructor(options) {
                        options = (0, _common.ensureDefined)(options, {});
                        this._keyGetter = (0, _data.compileGetter)(this._getKeyExpr(options));
                        this._nameGetter = (0, _data.compileGetter)(this._getNameExpr(options));
                        this._isDirGetter = (0, _data.compileGetter)(this._getIsDirExpr(options));
                        this._sizeGetter = (0, _data.compileGetter)(this._getSizeExpr(options));
                        this._dateModifiedGetter = (0, _data.compileGetter)(this._getDateModifiedExpr(options));
                        this._thumbnailGetter = (0, _data.compileGetter)(this._getThumbnailExpr(options))
                    }
                    getItems(parentDirectory) {
                        const deferred = new _deferred.Deferred;
                        deferred.resolve([]);
                        return deferred.promise()
                    }
                    abortFileUpload(fileData, chunksInfo, destinationDirectory) {}
                    getItemsContent(items) {}
                    getFileUploadChunkSize() {
                        return 2e5
                    }
                    _convertDataObjectsToFileItems(entries, pathInfo) {
                        const result = [];
                        (0, _iterator.each)(entries, ((_, entry) => {
                            const fileItem = this._createFileItem(entry, pathInfo);
                            result.push(fileItem)
                        }));
                        return result
                    }
                    _createFileItem(dataObj, pathInfo) {
                        var _this$_keyGetter, _this$_nameGetter, _this$_isDirGetter, _this$_sizeGetter, _this$_dateModifiedGe, _this$_thumbnailGette;
                        const key = null === (_this$_keyGetter = this._keyGetter) || void 0 === _this$_keyGetter ? void 0 : _this$_keyGetter.call(this, dataObj);
                        const fileItem = new _file_system_item.default(pathInfo, null === (_this$_nameGetter = this._nameGetter) || void 0 === _this$_nameGetter ? void 0 : _this$_nameGetter.call(this, dataObj), !!(null !== (_this$_isDirGetter = this._isDirGetter) && void 0 !== _this$_isDirGetter && _this$_isDirGetter.call(this, dataObj)), key);
                        fileItem.size = null === (_this$_sizeGetter = this._sizeGetter) || void 0 === _this$_sizeGetter ? void 0 : _this$_sizeGetter.call(this, dataObj);
                        if (void 0 === fileItem.size) {
                            fileItem.size = 0
                        }
                        fileItem.dateModified = _date_serialization.default.deserializeDate(null === (_this$_dateModifiedGe = this._dateModifiedGetter) || void 0 === _this$_dateModifiedGe ? void 0 : _this$_dateModifiedGe.call(this, dataObj));
                        if (void 0 === fileItem.dateModified) {
                            fileItem.dateModified = new Date
                        }
                        if (fileItem.isDirectory) {
                            fileItem.hasSubDirectories = this._hasSubDirs(dataObj)
                        }
                        if (!key) {
                            fileItem.key = fileItem.relativeName
                        }
                        fileItem.thumbnail = (null === (_this$_thumbnailGette = this._thumbnailGetter) || void 0 === _this$_thumbnailGette ? void 0 : _this$_thumbnailGette.call(this, dataObj)) || "";
                        fileItem.dataItem = dataObj;
                        return fileItem
                    }
                    _hasSubDirs(dataObj) {
                        return true
                    }
                    _getKeyExpr(options) {
                        return options.keyExpr ?? this._defaultKeyExpr
                    }
                    _defaultKeyExpr(fileItem) {
                        if (2 === arguments.length) {
                            fileItem.__KEY__ = arguments[1];
                            return
                        }
                        return Object.prototype.hasOwnProperty.call(fileItem, "__KEY__") ? fileItem.__KEY__ : null
                    }
                    _getNameExpr(options) {
                        return options.nameExpr ?? "name"
                    }
                    _getIsDirExpr(options) {
                        return options.isDirectoryExpr ?? "isDirectory"
                    }
                    _getSizeExpr(options) {
                        return options.sizeExpr ?? "size"
                    }
                    _getDateModifiedExpr(options) {
                        return options.dateModifiedExpr ?? "dateModified"
                    }
                    _getThumbnailExpr(options) {
                        return options.thumbnailExpr ?? "thumbnail"
                    }
                    _executeActionAsDeferred(action, keepResult) {
                        const deferred = new _deferred.Deferred;
                        try {
                            const result = action();
                            if ((0, _type.isPromise)(result)) {
                                (0, _deferred.fromPromise)(result).done((userResult => deferred.resolve(keepResult ? userResult : void 0))).fail((error => deferred.reject(error)))
                            } else {
                                deferred.resolve(keepResult ? result : void 0)
                            }
                        } catch (error) {
                            return deferred.reject(error)
                        }
                        return deferred.promise()
                    }
                }
            },
        3535:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/check_box/generated_wrapper.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 92848));
                var _check_box = __webpack_require__( /*! ./check_box */ 54516);
                var _wrapper = _interopRequireDefault(__webpack_require__( /*! ./wrapper */ 81529));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class CheckBox extends _wrapper.default {
                    getProps() {
                        const props = super.getProps();
                        props.onKeyDown = this._wrapKeyDownHandler(props.onKeyDown);
                        return props
                    }
                    focus() {
                        var _this$viewRef;
                        return null === (_this$viewRef = this.viewRef) || void 0 === _this$viewRef ? void 0 : _this$viewRef.focus(...arguments)
                    }
                    blur() {
                        var _this$viewRef2;
                        return null === (_this$viewRef2 = this.viewRef) || void 0 === _this$viewRef2 ? void 0 : _this$viewRef2.blur(...arguments)
                    }
                    _getActionConfigs() {
                        return {
                            onFocusIn: {},
                            onClick: {}
                        }
                    }
                    get _propsInfo() {
                        return {
                            twoWay: [
                                ["value", "defaultValue", "valueChange"]
                            ],
                            allowNull: ["defaultValue", "validationError", "validationErrors", "value"],
                            elements: [],
                            templates: [],
                            props: ["text", "iconSize", "enableThreeStateBehavior", "activeStateEnabled", "hoverStateEnabled", "focusStateEnabled", "saveValueChangeEvent", "defaultValue", "valueChange", "readOnly", "name", "validationError", "validationErrors", "validationMessageMode", "validationMessagePosition", "validationStatus", "isValid", "isDirty", "inputAttr", "onFocusIn", "className", "accessKey", "disabled", "height", "hint", "onClick", "onKeyDown", "rtlEnabled", "tabIndex", "visible", "width", "aria", "value"]
                        }
                    }
                    get _viewComponent() {
                        return _check_box.CheckBox
                    }
                }
                exports.default = CheckBox;
                (0, _component_registrator.default)("dxCheckBox", CheckBox);
                CheckBox.defaultOptions = _check_box.defaultOptions
            },
        3538:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/content_view/options.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.defaultOptions = void 0;
                var _message = (e = __webpack_require__( /*! ../../../../../localization/message */ 33881), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.defaultOptions = {
                    errorRowEnabled: true,
                    noDataText: _message.default.format("dxDataGrid-noDataText")
                }
            },
        3559:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/button_group.js ***!
              \***************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.BUTTON_GROUP_CLASS = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 92848));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 64553));
                var _bindable_template = __webpack_require__( /*! ../../core/templates/bindable_template */ 27286);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _button = _interopRequireDefault(__webpack_require__( /*! ../../ui/button */ 64973));
                var _uiCollection_widget = _interopRequireDefault(__webpack_require__( /*! ../../ui/collection/ui.collection_widget.edit */ 7607));
                var _widget = _interopRequireDefault(__webpack_require__( /*! ../core/widget/widget */ 89275));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const BUTTON_GROUP_CLASS = exports.BUTTON_GROUP_CLASS = "dx-buttongroup";
                const BUTTON_GROUP_WRAPPER_CLASS = `${BUTTON_GROUP_CLASS}-wrapper`;
                const BUTTON_GROUP_ITEM_CLASS = `${BUTTON_GROUP_CLASS}-item`;
                const BUTTON_GROUP_FIRST_ITEM_CLASS = `${BUTTON_GROUP_CLASS}-first-item`;
                const BUTTON_GROUP_LAST_ITEM_CLASS = `${BUTTON_GROUP_CLASS}-last-item`;
                const BUTTON_GROUP_ITEM_HAS_WIDTH = `${BUTTON_GROUP_ITEM_CLASS}-has-width`;
                const BUTTON_GROUP_STYLING_MODE_CLASS = {
                    contained: "dx-buttongroup-mode-contained",
                    outlined: "dx-buttongroup-mode-outlined",
                    text: "dx-buttongroup-mode-text"
                };
                class ButtonCollection extends _uiCollection_widget.default {
                    _initTemplates() {
                        super._initTemplates();
                        this._templateManager.addDefaultTemplates({
                            item: new _bindable_template.BindableTemplate((($container, data, model) => {
                                this._prepareItemStyles($container);
                                const {
                                    buttonTemplate: buttonTemplate
                                } = this.option();
                                this._createComponent($container, _button.default, (0, _extend.extend)({}, model, data, this._getBasicButtonOptions(), {
                                    _templateData: this._hasCustomTemplate(buttonTemplate) ? model : {},
                                    template: model.template || buttonTemplate
                                }))
                            }), ["text", "type", "icon", "disabled", "visible", "hint"], this.option("integrationOptions.watchMethod"))
                        })
                    }
                    _getBasicButtonOptions() {
                        const {
                            hoverStateEnabled: hoverStateEnabled,
                            activeStateEnabled: activeStateEnabled,
                            stylingMode: stylingMode
                        } = this.option();
                        return {
                            focusStateEnabled: false,
                            onClick: null,
                            hoverStateEnabled: hoverStateEnabled,
                            activeStateEnabled: activeStateEnabled,
                            stylingMode: stylingMode
                        }
                    }
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            itemTemplateProperty: null
                        })
                    }
                    _hasCustomTemplate(template) {
                        return (0, _type.isFunction)(template) || this.option("integrationOptions.templates")[template]
                    }
                    _selectedItemClass() {
                        return "dx-item-selected dx-state-selected"
                    }
                    _prepareItemStyles($item) {
                        const itemIndex = $item.data("dxItemIndex");
                        if (0 === itemIndex) {
                            $item.addClass(BUTTON_GROUP_FIRST_ITEM_CLASS)
                        }
                        const {
                            items: items
                        } = this.option();
                        if (items && itemIndex === items.length - 1) {
                            $item.addClass(BUTTON_GROUP_LAST_ITEM_CLASS)
                        }
                        $item.addClass("dx-shape-standard")
                    }
                    _renderItemContent(args) {
                        args.container = (0, _renderer.default)(args.container).parent();
                        return super._renderItemContent(args)
                    }
                    _setAriaSelectionAttribute($target, value) {
                        this.setAria("pressed", value, $target)
                    }
                    _renderItemContentByNode(args, $node) {
                        args.container = (0, _renderer.default)(args.container).children().first();
                        return super._renderItemContentByNode(args, $node)
                    }
                    _focusTarget() {
                        return this.$element().parent()
                    }
                    _keyboardEventBindingTarget() {
                        return this._focusTarget()
                    }
                    _enterKeyHandler(e) {
                        e.preventDefault();
                        super._enterKeyHandler(e)
                    }
                    _refreshContent() {
                        this._prepareContent();
                        this._renderContent()
                    }
                    _itemClass() {
                        return BUTTON_GROUP_ITEM_CLASS
                    }
                    _itemSelectHandler(e) {
                        const {
                            selectionMode: selectionMode
                        } = this.option();
                        if ("single" === selectionMode && this.isItemSelected(e.currentTarget)) {
                            return
                        }
                        super._itemSelectHandler(e)
                    }
                }
                class ButtonGroup extends _widget.default {
                    _getDefaultOptions() {
                        return Object.assign({}, super._getDefaultOptions(), {
                            hoverStateEnabled: true,
                            focusStateEnabled: true,
                            selectionMode: "single",
                            selectedItems: [],
                            selectedItemKeys: [],
                            stylingMode: "contained",
                            keyExpr: "text",
                            items: [],
                            buttonTemplate: "content",
                            onSelectionChanged: null,
                            onItemClick: null
                        })
                    }
                    _init() {
                        super._init();
                        this._createItemClickAction()
                    }
                    _createItemClickAction() {
                        this._itemClickAction = this._createActionByOption("onItemClick")
                    }
                    _initMarkup() {
                        this.setAria("role", "group");
                        this.$element().addClass(BUTTON_GROUP_CLASS);
                        this._renderStylingMode();
                        this._renderButtons();
                        this._syncSelectionOptions();
                        super._initMarkup()
                    }
                    _renderStylingMode() {
                        const {
                            stylingMode: stylingMode
                        } = this.option();
                        for (const key in BUTTON_GROUP_STYLING_MODE_CLASS) {
                            this.$element().removeClass(BUTTON_GROUP_STYLING_MODE_CLASS[key])
                        }
                        this.$element().addClass(BUTTON_GROUP_STYLING_MODE_CLASS[stylingMode ?? "contained"])
                    }
                    _fireSelectionChangeEvent(addedItems, removedItems) {
                        this._createActionByOption("onSelectionChanged", {
                            excludeValidators: ["disabled", "readOnly"]
                        })({
                            addedItems: addedItems,
                            removedItems: removedItems
                        })
                    }
                    _renderButtons() {
                        const $buttons = (0, _renderer.default)("<div>").addClass(BUTTON_GROUP_WRAPPER_CLASS).appendTo(this.$element());
                        const {
                            selectedItems: selectedItems,
                            selectionMode: selectionMode,
                            items: items,
                            keyExpr: keyExpr,
                            buttonTemplate: buttonTemplate,
                            selectedItemKeys: selectedItemKeys,
                            focusStateEnabled: focusStateEnabled,
                            hoverStateEnabled: hoverStateEnabled,
                            activeStateEnabled: activeStateEnabled,
                            stylingMode: stylingMode,
                            accessKey: accessKey,
                            tabIndex: tabIndex
                        } = this.option();
                        const options = {
                            selectionMode: selectionMode,
                            items: items,
                            keyExpr: keyExpr,
                            buttonTemplate: buttonTemplate,
                            selectedItemKeys: selectedItemKeys,
                            focusStateEnabled: focusStateEnabled,
                            hoverStateEnabled: hoverStateEnabled,
                            activeStateEnabled: activeStateEnabled,
                            stylingMode: stylingMode,
                            accessKey: accessKey,
                            tabIndex: tabIndex,
                            noDataText: "",
                            selectionRequired: false,
                            onItemRendered: e => {
                                const {
                                    width: width
                                } = this.option();
                                if ((0, _type.isDefined)(width)) {
                                    (0, _renderer.default)(e.itemElement).addClass(BUTTON_GROUP_ITEM_HAS_WIDTH)
                                }
                            },
                            onSelectionChanged: e => {
                                this._syncSelectionOptions();
                                this._fireSelectionChangeEvent(e.addedItems, e.removedItems)
                            },
                            onItemClick: e => {
                                this._itemClickAction(e)
                            }
                        };
                        if ((0, _type.isDefined)(selectedItems) && selectedItems.length) {
                            options.selectedItems = selectedItems
                        }
                        this._buttonsCollection = this._createComponent($buttons, ButtonCollection, options)
                    }
                    _syncSelectionOptions() {
                        this._setOptionWithoutOptionChange("selectedItems", this._buttonsCollection.option("selectedItems"));
                        this._setOptionWithoutOptionChange("selectedItemKeys", this._buttonsCollection.option("selectedItemKeys"))
                    }
                    _optionChanged(args) {
                        const {
                            name: name,
                            value: value
                        } = args;
                        switch (name) {
                            case "stylingMode":
                            case "selectionMode":
                            case "keyExpr":
                            case "buttonTemplate":
                            case "items":
                            case "activeStateEnabled":
                            case "focusStateEnabled":
                            case "hoverStateEnabled":
                            case "tabIndex":
                                this._invalidate();
                                break;
                            case "selectedItemKeys":
                            case "selectedItems":
                                this._buttonsCollection.option(name, value);
                                break;
                            case "onItemClick":
                                this._createItemClickAction();
                                break;
                            case "onSelectionChanged":
                                break;
                            case "width":
                                super._optionChanged(args);
                                this._buttonsCollection.itemElements().toggleClass(BUTTON_GROUP_ITEM_HAS_WIDTH, !!value);
                                break;
                            default:
                                super._optionChanged(args)
                        }
                    }
                }(0, _component_registrator.default)("dxButtonGroup", ButtonGroup);
                exports.default = ButtonGroup
            },
        3596:
            /*!*************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/filtering/legacy_filter_custom_operations.js ***!
              \*************************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.anyOf = function(config) {
                    return (0, _extend.extend)(baseOperation(config), {
                        name: "anyof",
                        icon: "selectall",
                        caption: _message.default.format("dxFilterBuilder-filterOperationAnyOf")
                    })
                };
                exports.noneOf = function(config) {
                    const baseOp = baseOperation(config);
                    return (0, _extend.extend)({}, baseOp, {
                        calculateFilterExpression(filterValue, field, fields) {
                            const baseFilter = baseOp.calculateFilterExpression(filterValue, field, fields);
                            if (!baseFilter || 0 === baseFilter.length) {
                                return null
                            }
                            return "!" === baseFilter[0] ? baseFilter : ["!", baseFilter]
                        },
                        name: "noneof",
                        icon: "unselectall",
                        caption: _message.default.format("dxFilterBuilder-filterOperationNoneOf")
                    })
                };
                var _message = _interopRequireDefault(__webpack_require__( /*! ../../../../../common/core/localization/message */ 4671));
                var _data_source = __webpack_require__( /*! ../../../../../common/data/data_source/data_source */ 68216);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../../core/renderer */ 64553));
                var _deferred = __webpack_require__( /*! ../../../../../core/utils/deferred */ 87739);
                var _extend = __webpack_require__( /*! ../../../../../core/utils/extend */ 52576);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../../../ui/widget/ui.errors */ 35185));
                var _m_utils = __webpack_require__( /*! ../../../../filter_builder/m_utils */ 29498);
                var _legacy_header_filter = __webpack_require__( /*! ./header_filter/legacy_header_filter */ 65518);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }

                function baseOperation(config) {
                    const {
                        getHeaderFilterController: getHeaderFilterController
                    } = config;
                    const getFullText = function(itemText, parentText) {
                        return parentText ? `${parentText}/${itemText}` : itemText
                    };
                    const getSelectedItemsTexts = function(items, parentText) {
                        let result = [];
                        items.forEach((item => {
                            if (item.items) {
                                const selectedItemsTexts = getSelectedItemsTexts(item.items, getFullText(item.text, parentText));
                                result = result.concat(selectedItemsTexts)
                            }
                            item.selected && result.push(getFullText(item.text, parentText))
                        }));
                        return result
                    };
                    return {
                        dataTypes: ["string", "date", "datetime", "number", "boolean", "object"],
                        calculateFilterExpression: function(filterValue, field, fields) {
                            const result = [];
                            const lastIndex = filterValue.length - 1;
                            filterValue && filterValue.forEach(((value, index) => {
                                if ((0, _m_utils.isCondition)(value) || (0, _m_utils.isGroup)(value)) {
                                    const filterExpression = (0, _m_utils.getFilterExpression)(value, fields, [], "headerFilter");
                                    result.push(filterExpression)
                                } else {
                                    const filterExpression = (0, _m_utils.getFilterExpression)([field.dataField ?? field.name, "=", value], fields, [], "headerFilter");
                                    result.push(filterExpression)
                                }
                                index !== lastIndex && result.push("or")
                            }));
                            if (1 === result.length) {
                                return result[0]
                            }
                            return result
                        },
                        editorTemplate(conditionInfo, container) {
                            const headerFilterController = getHeaderFilterController();
                            const div = (0, _renderer.default)("<div>").addClass("dx-filterbuilder-item-value-text").appendTo(container);
                            const originalColumn = config.columnOption(conditionInfo.field.dataField);
                            const column = (0, _extend.extend)(true, {}, originalColumn);
                            (0, _m_utils.renderValueText)(div, conditionInfo.text && conditionInfo.text.split("|"));
                            column.filterType = "include";
                            column.filterValues = conditionInfo.value ? conditionInfo.value.slice() : [];
                            headerFilterController.showHeaderFilterMenuBase({
                                columnElement: div,
                                column: column,
                                customApply(filterValues) {
                                    value = filterValues, void conditionInfo.setValue(value);
                                    var value;
                                    headerFilterController.hideHeaderFilterMenu();
                                    conditionInfo.closeEditor()
                                },
                                onHidden() {
                                    conditionInfo.closeEditor()
                                },
                                isFilterBuilder: true
                            });
                            return container
                        },
                        customizeText: function(fieldInfo, options) {
                            options = options || {};
                            const headerFilterController = getHeaderFilterController();
                            const {
                                value: value
                            } = fieldInfo;
                            let column = config.columnOption(fieldInfo.field.dataField);
                            const headerFilter = column && column.headerFilter;
                            const lookup = column && column.lookup;
                            const values = options.values || [value];
                            if (headerFilter && headerFilter.dataSource || lookup && lookup.dataSource) {
                                const result = new _deferred.Deferred;
                                const itemsDeferred = options.items || new _deferred.Deferred;
                                if (!options.items) {
                                    column = (0, _extend.extend)({}, column, {
                                        filterType: "include",
                                        filterValues: values
                                    });
                                    const dataSourceOptions = headerFilterController.getDataSource(column);
                                    dataSourceOptions.paginate = false;
                                    const dataSource = new _data_source.DataSource(dataSourceOptions);
                                    const key = dataSource.store().key();
                                    if (key) {
                                        const {
                                            values: values
                                        } = options;
                                        if (values && values.length > 1) {
                                            const filter = values.reduce(((result, value) => {
                                                if (result.length) {
                                                    result.push("or")
                                                }
                                                result.push([key, "=", value]);
                                                return result
                                            }), []);
                                            dataSource.filter(filter)
                                        } else {
                                            dataSource.filter([key, "=", fieldInfo.value])
                                        }
                                    } else if (fieldInfo.field.calculateDisplayValue) {
                                        _ui.default.log("W1017")
                                    }
                                    options.items = itemsDeferred;
                                    dataSource.load().done(itemsDeferred.resolve)
                                }
                                itemsDeferred.done((items => {
                                    const index = values.indexOf(fieldInfo.value);
                                    result.resolve(getSelectedItemsTexts(items, null)[index])
                                }));
                                return result
                            }
                            const headerFilterOptions = config.getHeaderFilterOptions();
                            const text = (0, _legacy_header_filter.getHeaderItemText)(value, column, 0, headerFilterOptions);
                            return text
                        }
                    }
                }
            },
        3637:
            /*!***************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/card_view/content_view/content/card/field.js ***!
              \***************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Field = exports.CLASSES = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _caption = __webpack_require__( /*! ./caption */ 85799);
                var _value_text = __webpack_require__( /*! ./value_text */ 61044);
                const CLASSES = exports.CLASSES = {
                    fieldTemplate: "dx-cardview-field-template",
                    overflowHint: "dx-cardview-overflow-hint"
                };
                class Field extends _inferno.Component {
                    constructor(props) {
                        super(props);
                        this.containerRef = this.props.elementRef ?? (0, _inferno.createRef)()
                    }
                    componentDidMount() {
                        var _this$props$onPrepare, _this$props;
                        null === (_this$props$onPrepare = (_this$props = this.props).onPrepared) || void 0 === _this$props$onPrepare || _this$props$onPrepare.call(_this$props, this.containerRef.current)
                    }
                    render() {
                        const Template = this.props.template;
                        if (Template) {
                            return (0, _inferno.createVNode)(1, "div", CLASSES.fieldTemplate, (0, _inferno.createComponentVNode)(2, Template, {
                                field: this.props.field
                            }), 2)
                        }
                        return (0, _inferno.createFragment)([(0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, _caption.Caption, Object.assign({
                            field: this.props.field,
                            template: this.props.captionTemplate
                        }, this.props.captionProps))), (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, _value_text.ValueText, Object.assign({
                            fieldHintEnabled: this.props.fieldHintEnabled,
                            field: this.props.field,
                            template: this.props.valueTemplate
                        }, this.props.valueProps)))], 4)
                    }
                }
                exports.Field = Field
            },
        3716:
            /*!**********************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/data_grid/keyboard_navigation/m_column_keyboard_navigation_mixin.js ***!
              \**********************************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ColumnKeyboardNavigationMixin = void 0;
                var _utils = __webpack_require__( /*! ../../../../common/core/events/utils */ 98834);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var _const = __webpack_require__( /*! ../../../grids/grid_core/keyboard_navigation/const */ 24171);
                exports.ColumnKeyboardNavigationMixin = Base => class extends Base {
                    ungroupColumnByPressingKey(e) {
                        var _e$originalEvent;
                        const column = this.getColumnFromEvent(e);
                        const rowIndex = this.getRowIndexFromEvent(e);
                        this.ungroupColumn(column, rowIndex);
                        null === (_e$originalEvent = e.originalEvent) || void 0 === _e$originalEvent || _e$originalEvent.preventDefault()
                    }
                    getFocusedCellPositionByColumn(column) {
                        if (!column) {
                            return
                        }
                        const newRowIndex = this._columnsController.getRowIndex(column.index, true);
                        return {
                            rowIndex: newRowIndex,
                            columnIndex: this.getVisibleIndex(column, newRowIndex)
                        }
                    }
                    getRowIndexFromEvent(e) {
                        return 0
                    }
                    getColumnFromEvent(e) {}
                    getNewFocusedColumnBeforeUngrouping(column, rowIndex) {
                        return column
                    }
                    keyDownHandler(e) {
                        let isHandled = super.keyDownHandler(e);
                        if (isHandled) {
                            return true
                        }
                        if (this.canUngroupColumnByPressingKey(e)) {
                            this.ungroupColumnByPressingKey(e);
                            isHandled = true
                        } else if (this.canUngroupAllColumnByPressingKey(e)) {
                            this.ungroupAllColumns();
                            isHandled = true
                        }
                        return isHandled
                    }
                    changeGroupColumnIndex(groupIndex, column, newFocusedColumn) {
                        this._columnsController.beginUpdate();
                        this._columnsController.columnOption(column.dataField, "groupIndex", groupIndex);
                        const newFocusedCellPosition = this.getFocusedCellPositionByColumn(newFocusedColumn);
                        this.updateViewFocusPosition(newFocusedCellPosition);
                        this._columnsController.endUpdate()
                    }
                    canUngroupColumnByPressingKey(e) {
                        return e.which === _const.KEY_CODES.G && e.shift && (0, _utils.isCommandKeyPressed)(e.originalEvent)
                    }
                    canUngroupAllColumnByPressingKey(e) {
                        return e.which === _const.KEY_CODES.G && e.shift && e.alt
                    }
                    ungroupColumn(column) {
                        let rowIndex = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : 0;
                        if ((0, _type.isDefined)(null === column || void 0 === column ? void 0 : column.groupIndex)) {
                            const newFocusedColumn = this.getNewFocusedColumnBeforeUngrouping(column, rowIndex);
                            this.changeGroupColumnIndex(-1, column, newFocusedColumn)
                        }
                    }
                    ungroupAllColumns() {
                        this._columnsController.clearGrouping()
                    }
                }
            },
        3794:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/integration/knockout/component_registrator.js ***!
              \******************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.widget */ 11118));
                var _m_component_registrator_callbacks = __webpack_require__( /*! ../../core/m_component_registrator_callbacks */ 21233);
                var _m_config = _interopRequireDefault(__webpack_require__( /*! ../../core/m_config */ 34338));
                var _component_wrapper = __webpack_require__( /*! ../../core/r1/component_wrapper */ 34993);
                var _m_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_callbacks */ 63172));
                var _m_locker = __webpack_require__( /*! ../../core/utils/m_locker */ 24574);
                var _m_type = __webpack_require__( /*! ../../core/utils/m_type */ 39918);
                var _m_draggable = _interopRequireDefault(__webpack_require__( /*! ../../m_draggable */ 89983));
                var _editor = _interopRequireDefault(__webpack_require__( /*! ../../ui/editor/editor */ 24768));
                var _scroll_view = _interopRequireDefault(__webpack_require__( /*! ../../ui/scroll_view/scroll_view */ 71100));
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../../viz/core/m_base_widget */ 34506));
                var _knockout = _interopRequireDefault(__webpack_require__( /*! knockout */ 78117));
                var _template = __webpack_require__( /*! ./template */ 36390);
                var _utils = __webpack_require__( /*! ./utils */ 41983);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                if (_knockout.default) {
                    const LOCKS_DATA_KEY = "dxKoLocks";
                    const CREATED_WITH_KO_DATA_KEY = "dxKoCreation";
                    const editorsBindingHandlers = [];
                    const registerComponentKoBinding = function(componentName, componentClass) {
                        if (_editor.default.isEditor(componentClass.prototype)) {
                            editorsBindingHandlers.push(componentName)
                        }
                        _knockout.default.bindingHandlers[componentName] = {
                            init(domNode, valueAccessor) {
                                const $element = (0, _renderer.default)(domNode);
                                const optionChangedCallbacks = (0, _m_callbacks.default)();
                                let optionsByReference = {};
                                let component;
                                const knockoutConfig = (0, _m_config.default)().knockout;
                                const isBindingPropertyPredicateName = null === knockoutConfig || void 0 === knockoutConfig ? void 0 : knockoutConfig.isBindingPropertyPredicateName;
                                let isBindingPropertyPredicate;
                                let ctorOptions = {
                                    onInitializing(options) {
                                        optionsByReference = this._getOptionsByReference();
                                        _knockout.default.computed((() => {
                                            const model = _knockout.default.unwrap(valueAccessor());
                                            if (component) {
                                                component.beginUpdate()
                                            }
                                            isBindingPropertyPredicate = isBindingPropertyPredicateName && (null === model || void 0 === model ? void 0 : model[isBindingPropertyPredicateName]);
                                            unwrapModel(model);
                                            if (component) {
                                                component.endUpdate()
                                            } else {
                                                var _model$onInitializing;
                                                null === model || void 0 === model || null === (_model$onInitializing = model.onInitializing) || void 0 === _model$onInitializing || _model$onInitializing.call(this, options)
                                            }
                                        }), null, {
                                            disposeWhenNodeIsRemoved: domNode
                                        });
                                        component = this
                                    },
                                    modelByElement($element) {
                                        if ($element.length) {
                                            const node = (0, _utils.getClosestNodeWithContext)($element.get(0));
                                            return _knockout.default.dataFor(node)
                                        }
                                    },
                                    nestedComponentOptions: component => ({
                                        modelByElement: component.option("modelByElement"),
                                        nestedComponentOptions: component.option("nestedComponentOptions")
                                    }),
                                    _optionChangedCallbacks: optionChangedCallbacks,
                                    integrationOptions: {
                                        watchMethod(fn, callback, options) {
                                            options = options || {};
                                            let skipCallback = options.skipImmediate;
                                            const watcher = _knockout.default.computed((() => {
                                                const newValue = _knockout.default.unwrap(fn());
                                                if (!skipCallback) {
                                                    callback(newValue)
                                                }
                                                skipCallback = false
                                            }));
                                            return function() {
                                                watcher.dispose()
                                            }
                                        },
                                        templates: {
                                            "dx-polymorph-widget": {
                                                render(options) {
                                                    const widgetName = _knockout.default.utils.unwrapObservable(options.model.widget);
                                                    if (!widgetName) {
                                                        return
                                                    }
                                                    const markup = (0, _renderer.default)("<div>").attr("data-bind", `${widgetName}: options`).get(0);
                                                    (0, _renderer.default)(options.container).append(markup);
                                                    _knockout.default.applyBindings(options.model, markup)
                                                }
                                            }
                                        },
                                        createTemplate: element => new _template.KoTemplate(element)
                                    }
                                };
                                const optionNameToModelMap = {};
                                const applyModelValueToOption = function(optionName, modelValue, unwrap) {
                                    const locks = $element.data(LOCKS_DATA_KEY);
                                    const optionValue = unwrap ? _knockout.default.unwrap(modelValue) : modelValue;
                                    if (_knockout.default.isWriteableObservable(modelValue)) {
                                        optionNameToModelMap[optionName] = modelValue
                                    }
                                    if (component) {
                                        if (locks.locked(optionName)) {
                                            return
                                        }
                                        locks.obtain(optionName);
                                        try {
                                            if (_knockout.default.ignoreDependencies) {
                                                _knockout.default.ignoreDependencies(component.option, component, [optionName, optionValue])
                                            } else {
                                                component.option(optionName, optionValue)
                                            }
                                        } finally {
                                            locks.release(optionName)
                                        }
                                    } else {
                                        ctorOptions[optionName] = optionValue
                                    }
                                };
                                const handleOptionChanged = function(args) {
                                    const optionName = args.fullName;
                                    const optionValue = args.value;
                                    if (!(optionName in optionNameToModelMap)) {
                                        return
                                    }
                                    const $element = this._$element;
                                    const locks = $element.data(LOCKS_DATA_KEY);
                                    if (locks.locked(optionName)) {
                                        return
                                    }
                                    locks.obtain(optionName);
                                    try {
                                        optionNameToModelMap[optionName](optionValue)
                                    } finally {
                                        locks.release(optionName)
                                    }
                                };
                                const unwrapModelValue = function(currentModel, propertyName, propertyPath) {
                                    if (propertyPath === isBindingPropertyPredicateName) {
                                        return
                                    }
                                    if (!isBindingPropertyPredicate || isBindingPropertyPredicate(propertyPath, propertyName, currentModel)) {
                                        let unwrappedPropertyValue;
                                        _knockout.default.computed((() => {
                                            const propertyValue = currentModel[propertyName];
                                            applyModelValueToOption(propertyPath, propertyValue, true);
                                            unwrappedPropertyValue = _knockout.default.unwrap(propertyValue)
                                        }), null, {
                                            disposeWhenNodeIsRemoved: domNode
                                        });
                                        if ((0, _m_type.isPlainObject)(unwrappedPropertyValue)) {
                                            if (!optionsByReference[propertyPath]) {
                                                unwrapModel(unwrappedPropertyValue, propertyPath)
                                            }
                                        }
                                    } else {
                                        applyModelValueToOption(propertyPath, currentModel[propertyName], false)
                                    }
                                };

                                function unwrapModel(model, propertyPath) {
                                    for (const propertyName in model) {
                                        if (Object.prototype.hasOwnProperty.call(model, propertyName)) {
                                            unwrapModelValue(model, propertyName, propertyPath ? [propertyPath, propertyName].join(".") : propertyName)
                                        }
                                    }
                                }! function() {
                                    optionChangedCallbacks.add(handleOptionChanged);
                                    $element.data(CREATED_WITH_KO_DATA_KEY, true).data(LOCKS_DATA_KEY, new _m_locker.Locker);
                                    new componentClass($element, ctorOptions);
                                    ctorOptions = null
                                }();
                                return {
                                    controlsDescendantBindings: componentClass.subclassOf(_ui.default) || componentClass.subclassOf(_m_base_widget.default) || componentClass.subclassOf(_component_wrapper.ComponentWrapper) && !(component instanceof _scroll_view.default) || component instanceof _m_draggable.default
                                }
                            }
                        };
                        if ("dxValidator" === componentName) {
                            _knockout.default.bindingHandlers.dxValidator.after = editorsBindingHandlers
                        }
                    };
                    _m_component_registrator_callbacks.componentRegistratorCallbacks.add(((name, componentClass) => {
                        registerComponentKoBinding(name, componentClass)
                    }))
                }
            },
        3955:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/new/grid_core/di.js ***!
              \**********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.register = function(diContext) {
                    diContext.register(DataControllerModule.DataController);
                    diContext.register(DataControllerModule.CompatibilityDataController);
                    diContext.register(_items_controller.ItemsController);
                    diContext.register(ColumnsControllerModule.ColumnsController);
                    diContext.register(SelectionControllerModule.Controller);
                    diContext.register(ColumnsControllerModule.CompatibilityColumnsController);
                    diContext.register(SortingControllerModule.SortingController);
                    diContext.register(_controller4.ToolbarController);
                    diContext.register(_view4.ToolbarView);
                    diContext.register(_view2.PagerView);
                    diContext.register(_controller3.SearchController);
                    diContext.register(_view3.SearchView);
                    diContext.register(ColumnChooserModule.ColumnChooserController);
                    diContext.register(ColumnChooserModule.ColumnChooserView);
                    diContext.register(FilterControllerModule.FilterController);
                    diContext.register(FilterControllerModule.FilterPanelView);
                    diContext.register(_index6.HeaderFilterController);
                    diContext.register(_index6.HeaderFilterPopupView);
                    diContext.register(FilterSyncModule.FilterSyncController);
                    diContext.register(FilterSyncModule.CompatibilityFilterSyncController);
                    diContext.register(_index6.CompatibilityHeaderFilterController);
                    diContext.register(_error_controller.ErrorController);
                    diContext.register(_controller2.EditingController);
                    diContext.register(_confirm_controller.ConfirmController);
                    diContext.register(_view.EditPopupView);
                    diContext.register(_index.SearchUIController);
                    diContext.register(_view3.SearchView);
                    diContext.register(_view_controller.HeaderFilterViewController);
                    diContext.register(_index8.KeyboardNavigationController);
                    diContext.register(_controller.AccessibilityController);
                    diContext.register(_index10.OptionsValidationController);
                    diContext.register(Lifecycle.Controller)
                };
                var _index = __webpack_require__( /*! ../../../grids/new/grid_core/search/index */ 61519);
                var _controller = __webpack_require__( /*! ./accessibility/controller */ 95569);
                var ColumnChooserModule = _interopRequireWildcard(__webpack_require__( /*! ./column_chooser/index */ 45415));
                var ColumnsControllerModule = _interopRequireWildcard(__webpack_require__( /*! ./columns_controller/index */ 50875));
                var DataControllerModule = _interopRequireWildcard(__webpack_require__( /*! ./data_controller/index */ 61124));
                var _confirm_controller = __webpack_require__( /*! ./editing/confirm_controller */ 17720);
                var _controller2 = __webpack_require__( /*! ./editing/controller */ 64629);
                var _view = __webpack_require__( /*! ./editing/popup/view */ 32643);
                var _error_controller = __webpack_require__( /*! ./error_controller/error_controller */ 67921);
                var FilterSyncModule = _interopRequireWildcard(__webpack_require__( /*! ./filtering/filter_sync/index */ 69900));
                var _index6 = __webpack_require__( /*! ./filtering/header_filter/index */ 63108);
                var _view_controller = __webpack_require__( /*! ./filtering/header_filter/view_controller */ 58814);
                var FilterControllerModule = _interopRequireWildcard(__webpack_require__( /*! ./filtering/index */ 92743));
                var _items_controller = __webpack_require__( /*! ./items_controller/items_controller */ 58761);
                var _index8 = __webpack_require__( /*! ./keyboard_navigation/index */ 58529);
                var Lifecycle = _interopRequireWildcard(__webpack_require__( /*! ./lifecycle/index */ 29589));
                var _index10 = __webpack_require__( /*! ./options_validation/index */ 8927);
                var _view2 = __webpack_require__( /*! ./pager/view */ 93825);
                var _controller3 = __webpack_require__( /*! ./search/controller */ 28355);
                var _view3 = __webpack_require__( /*! ./search/view */ 29366);
                var SelectionControllerModule = _interopRequireWildcard(__webpack_require__( /*! ./selection/index */ 99779));
                var SortingControllerModule = _interopRequireWildcard(__webpack_require__( /*! ./sorting_controller/index */ 37386));
                var _controller4 = __webpack_require__( /*! ./toolbar/controller */ 34272);
                var _view4 = __webpack_require__( /*! ./toolbar/view */ 5061);

                function _getRequireWildcardCache(e) {
                    if ("function" != typeof WeakMap) {
                        return null
                    }
                    var r = new WeakMap,
                        t = new WeakMap;
                    return (_getRequireWildcardCache = function(e) {
                        return e ? t : r
                    })(e)
                }

                function _interopRequireWildcard(e, r) {
                    if (!r && e && e.__esModule) {
                        return e
                    }
                    if (null === e || "object" != typeof e && "function" != typeof e) {
                        return {
                            default: e
                        }
                    }
                    var t = _getRequireWildcardCache(r);
                    if (t && t.has(e)) {
                        return t.get(e)
                    }
                    var n = {
                            __proto__: null
                        },
                        a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var u in e) {
                        if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
                            var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
                            i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]
                        }
                    }
                    return n.default = e, t && t.set(e, n), n
                }
            },
        3962:
            /*!***********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/utils/week.js ***!
              \***********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getValidStartDate = exports.getTimePanelCellText = exports.getIntervalDuration = exports.calculateViewStartDate = exports.calculateStartViewDate = void 0;
                var _date = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/localization/date */ 38662));
                var _date2 = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/date */ 41380));
                var _base = __webpack_require__( /*! ./base */ 44611);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.getTimePanelCellText = (rowIndex, date, startViewDate, cellDuration, startDayHour, viewOffset) => {
                    if (rowIndex % 2 !== 0) {
                        return ""
                    }
                    const validTimeDate = (0, _base.getValidCellDateForLocalTimeFormat)(date, {
                        startViewDate: startViewDate,
                        startDayHour: startDayHour,
                        cellIndexShift: Math.round(cellDuration) * rowIndex,
                        viewOffset: viewOffset
                    });
                    return _date.default.format(validTimeDate, "shorttime")
                };
                exports.getIntervalDuration = intervalCount => 7 * _date2.default.dateToMilliseconds("day") * intervalCount;
                const getValidStartDate = (startDate, firstDayOfWeek) => startDate ? _date2.default.getFirstWeekDate(startDate, firstDayOfWeek) : void 0;
                exports.getValidStartDate = getValidStartDate;
                exports.calculateStartViewDate = (currentDate, startDayHour, startDate, intervalDuration, firstDayOfWeekOption) => {
                    const firstDayOfWeek = (0, _base.getCalculatedFirstDayOfWeek)(firstDayOfWeekOption);
                    const viewStart = (0, _base.getViewStartByOptions)(startDate, currentDate, intervalDuration, getValidStartDate(startDate, firstDayOfWeek));
                    const firstViewDate = _date2.default.getFirstWeekDate(viewStart, firstDayOfWeek);
                    return (0, _base.setOptionHour)(firstViewDate, startDayHour)
                };
                exports.calculateViewStartDate = (startDateOption, firstDayOfWeek) => {
                    const validFirstDayOfWeek = firstDayOfWeek ?? _date.default.firstDayOfWeekIndex();
                    return _date2.default.getFirstWeekDate(startDateOption, validFirstDayOfWeek)
                }
            },
        3967:
            /*!*************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/tree_list/module_not_extended/column_fixing.js ***!
              \*************************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_column_fixing = __webpack_require__( /*! ../../../grids/grid_core/column_fixing/m_column_fixing */ 54704);
                var _m_core = (e = __webpack_require__( /*! ../m_core */ 99477), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                _m_core.default.registerModule("columnFixing", _m_column_fixing.columnFixingModule)
            },
        4011:
            /*!************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/components/base/all_day_panel_title.js ***!
              \************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.AllDayPanelTitle = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _message = (e = __webpack_require__( /*! ../../../../../common/core/localization/message */ 4671), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _index = __webpack_require__( /*! ../../../../core/r1/runtime/inferno/index */ 6257);
                class AllDayPanelTitle extends _index.InfernoWrapperComponent {
                    createEffects() {
                        return [(0, _index.createReRenderEffect)()]
                    }
                    render() {
                        const text = _message.default.format("dxScheduler-allDay");
                        return (0, _inferno.createVNode)(1, "div", "dx-scheduler-all-day-title", text, 0)
                    }
                }
                exports.AllDayPanelTitle = AllDayPanelTitle;
                AllDayPanelTitle.defaultProps = {}
            },
        4053:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/components/base/virtual_row.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.VirtualRowDefaultProps = exports.VirtualRow = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _index = __webpack_require__( /*! ../../../../core/r1/runtime/inferno/index */ 6257);
                var _index2 = __webpack_require__( /*! ../../utils/index */ 34396);
                var _row = __webpack_require__( /*! ./row */ 21541);
                var _virtual_cell = __webpack_require__( /*! ./virtual_cell */ 46033);
                const VirtualRowDefaultProps = exports.VirtualRowDefaultProps = Object.assign({}, _row.RowDefaultProps, {
                    leftVirtualCellWidth: 0,
                    rightVirtualCellWidth: 0,
                    cellsCount: 1
                });
                class VirtualRow extends _index.BaseInfernoComponent {
                    constructor() {
                        super(...arguments);
                        this.virtualCells = null
                    }
                    getVirtualCells() {
                        if (null !== this.virtualCells) {
                            return this.virtualCells
                        }
                        const {
                            cellsCount: cellsCount
                        } = this.props;
                        this.virtualCells = [...Array(cellsCount)];
                        return this.virtualCells
                    }
                    componentWillUpdate(nextProps) {
                        if (this.props.cellsCount !== nextProps.cellsCount) {
                            this.virtualCells = null
                        }
                    }
                    render() {
                        const {
                            className: className,
                            leftVirtualCellCount: leftVirtualCellCount,
                            leftVirtualCellWidth: leftVirtualCellWidth,
                            rightVirtualCellCount: rightVirtualCellCount,
                            rightVirtualCellWidth: rightVirtualCellWidth,
                            styles: styles,
                            height: height
                        } = this.props;
                        const classes = `dx-scheduler-virtual-row ${className}`;
                        const modifiedStyles = _index2.renderUtils.addHeightToStyle(height, styles);
                        const virtualCells = this.getVirtualCells();
                        return (0, _inferno.createComponentVNode)(2, _row.Row, {
                            className: classes,
                            styles: modifiedStyles,
                            leftVirtualCellWidth: leftVirtualCellWidth,
                            rightVirtualCellWidth: rightVirtualCellWidth,
                            leftVirtualCellCount: leftVirtualCellCount,
                            rightVirtualCellCount: rightVirtualCellCount,
                            children: virtualCells.map(((_, index) => (0, _inferno.createComponentVNode)(2, _virtual_cell.VirtualCell, {
                                width: _virtual_cell.VirtualCellDefaultProps.width,
                                isHeaderCell: _virtual_cell.VirtualCellDefaultProps.isHeaderCell,
                                className: "dx-scheduler-cell-sizes-horizontal"
                            }, index.toString())))
                        })
                    }
                }
                exports.VirtualRow = VirtualRow;
                VirtualRow.defaultProps = VirtualRowDefaultProps
            },
        4108:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/list/modules/deleting.toggle.js ***!
              \*******************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                __webpack_require__( /*! ../../../ui/list/list.edit.decorator.switchable.button */ 38929)
            },
        4130:
            /*!***************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/r1/components/base/group_panel_horizontal.js ***!
              \***************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.GroupPanelHorizontal = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _index = __webpack_require__( /*! ../../../../core/r1/runtime/inferno/index */ 6257);
                var _group_panel_horizontal_row = __webpack_require__( /*! ./group_panel_horizontal_row */ 6305);
                var _group_panel_props = __webpack_require__( /*! ./group_panel_props */ 3234);
                class GroupPanelHorizontal extends _index.BaseInfernoComponent {
                    constructor() {
                        super(...arguments);
                        this._groupPanelItems = null
                    }
                    getGroupPanelItems() {
                        if (null !== this._groupPanelItems) {
                            return this._groupPanelItems
                        }
                        const {
                            groupPanelData: {
                                baseColSpan: baseColSpan,
                                groupPanelItems: groupPanelItems
                            }
                        } = this.props;
                        const colSpans = groupPanelItems.reduceRight(((currentColSpans, groupsRow, idx) => {
                            const nextColSpans = currentColSpans;
                            const currentLevelGroupCount = groupsRow.length;
                            const previousColSpan = idx === groupPanelItems.length - 1 ? baseColSpan : currentColSpans[idx + 1];
                            const previousLevelGroupCount = idx === groupPanelItems.length - 1 ? currentLevelGroupCount : groupPanelItems[idx + 1].length;
                            const groupCountDiff = previousLevelGroupCount / currentLevelGroupCount;
                            nextColSpans[idx] = groupCountDiff * previousColSpan;
                            return nextColSpans
                        }), [...new Array(groupPanelItems.length)]);
                        this._groupPanelItems = groupPanelItems.map(((groupsRenderRow, index) => {
                            const colSpan = colSpans[index];
                            return groupsRenderRow.map((groupItem => Object.assign({}, groupItem, {
                                colSpan: colSpan
                            })))
                        }));
                        return this._groupPanelItems
                    }
                    componentWillUpdate(nextProps) {
                        if (this.props.groupPanelData !== nextProps.groupPanelData) {
                            this._groupPanelItems = null
                        }
                    }
                    render() {
                        const {
                            resourceCellTemplate: resourceCellTemplate
                        } = this.props;
                        const groupPanelItems = this.getGroupPanelItems();
                        return (0, _inferno.createFragment)(groupPanelItems.map((group => (0, _inferno.createComponentVNode)(2, _group_panel_horizontal_row.GroupPanelHorizontalRow, {
                            groupItems: group,
                            cellTemplate: resourceCellTemplate
                        }, group[0].key))), 0)
                    }
                }
                exports.GroupPanelHorizontal = GroupPanelHorizontal;
                GroupPanelHorizontal.defaultProps = _group_panel_props.GroupPanelBaseDefaultProps
            },
        4203:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/macro_task_array/index.js ***!
              \**************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _dispatcher = (e = __webpack_require__( /*! ./dispatcher */ 8710), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _methods = __webpack_require__( /*! ./methods */ 57);
                exports.default = {
                    forEach: _methods.macroTaskArrayForEach,
                    map: _methods.macroTaskArrayMap,
                    dispose: _dispatcher.default.dispose
                }
            },
        4313:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/tree_view.js ***!
              \*************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _tree_view = (e = __webpack_require__( /*! ../__internal/ui/tree_view/tree_view.search */ 52192), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _tree_view.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4414:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/html_editor/ui.html_editor.js ***!
              \******************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _html_editor = (e = __webpack_require__( /*! ../../__internal/ui/html_editor/html_editor */ 90660), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _html_editor.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4445:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/localization/default_date_names.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_iterator = __webpack_require__( /*! ../../core/utils/m_iterator */ 26044);
                const MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                const DAYS = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                const PERIODS = ["AM", "PM"];
                const QUARTERS = ["Q1", "Q2", "Q3", "Q4"];
                const cutCaptions = (captions, format) => {
                    const lengthByFormat = {
                        abbreviated: 3,
                        short: 2,
                        narrow: 1
                    };
                    return (0, _m_iterator.map)(captions, (caption => caption.substr(0, lengthByFormat[format])))
                };
                exports.default = {
                    getMonthNames: format => cutCaptions(MONTHS, format),
                    getDayNames: format => cutCaptions(DAYS, format),
                    getQuarterNames: _format => QUARTERS,
                    getPeriodNames: _format => PERIODS
                }
            },
        4450:
            /*!******************************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/options_validator/options_validator_errors_handler.js ***!
              \******************************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.SchedulerOptionsValidatorErrorsHandler = void 0;
                var _ui = (e = __webpack_require__( /*! ../../../../ui/widget/ui.errors */ 35185), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _index = __webpack_require__( /*! ./core/index */ 30378);
                const GLOBAL_ERROR_HANDLER = {
                    logError: function(errorCode) {
                        for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
                            args[_key - 1] = arguments[_key]
                        }
                        _ui.default.log(errorCode, ...args)
                    },
                    throwError: function(errorCode) {
                        for (var _len2 = arguments.length, args = new Array(_len2 > 1 ? _len2 - 1 : 0), _key2 = 1; _key2 < _len2; _key2++) {
                            args[_key2 - 1] = arguments[_key2]
                        }
                        throw _ui.default.Error(errorCode, ...args)
                    }
                };
                class SchedulerOptionsValidatorErrorsHandler extends _index.OptionsValidatorErrorHandler {
                    constructor() {
                        super({
                            startDayHour: "E1058",
                            endDayHour: "E1058",
                            startDayHourAndEndDayHour: "E1058",
                            offset: "E1061",
                            cellDuration: "E1062",
                            cellDurationAndVisibleInterval: "E1062",
                            views: "W0008"
                        }, GLOBAL_ERROR_HANDLER)
                    }
                }
                exports.SchedulerOptionsValidatorErrorsHandler = SchedulerOptionsValidatorErrorsHandler
            },
        4517:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/light/sankey.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _contants = __webpack_require__( /*! ./contants */ 12462);
                exports.default = {
                    sankey: {
                        sourceField: "source",
                        targetField: "target",
                        weightField: "weight",
                        hoverEnabled: true,
                        alignment: _contants.CENTER,
                        adaptiveLayout: {
                            width: 80,
                            height: 80,
                            keepLabels: true
                        },
                        label: {
                            visible: true,
                            horizontalOffset: 8,
                            verticalOffset: 0,
                            overlappingBehavior: "ellipsis",
                            useNodeColors: false,
                            font: {
                                color: _contants.BLACK,
                                weight: 500
                            },
                            border: {
                                visible: false,
                                width: 2,
                                color: _contants.WHITE
                            },
                            customizeText: info => info.label,
                            shadow: {
                                opacity: .2,
                                offsetX: 0,
                                offsetY: 1,
                                blur: 1,
                                color: _contants.WHITE
                            }
                        },
                        title: {
                            margin: 10,
                            font: {
                                size: 28,
                                weight: 200
                            },
                            subtitle: {
                                font: {
                                    size: 16
                                }
                            }
                        },
                        tooltip: {
                            enabled: true
                        },
                        node: {
                            padding: 30,
                            width: 8,
                            opacity: 1,
                            border: {
                                color: _contants.WHITE,
                                width: 1,
                                visible: false
                            },
                            hoverStyle: {
                                hatching: {
                                    opacity: .75,
                                    step: 6,
                                    width: 2,
                                    direction: _contants.RIGHT
                                },
                                border: {}
                            }
                        },
                        link: {
                            color: "#888888",
                            colorMode: "none",
                            opacity: .3,
                            border: {
                                color: _contants.WHITE,
                                width: 1,
                                visible: false
                            },
                            hoverStyle: {
                                opacity: .5,
                                hatching: {
                                    opacity: .75,
                                    step: 6,
                                    width: 2,
                                    direction: _contants.RIGHT
                                },
                                border: {}
                            }
                        }
                    }
                }
            },
        4575:
            /*!***********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/ui/tag_box.js ***!
              \***********************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_tag_box = (e = __webpack_require__( /*! ../__internal/ui/m_tag_box */ 24341), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _m_tag_box.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4628:
            /*!*********************************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/grids/grid_core/keyboard_navigation/m_keyboard_navigation.js ***!
              \*********************************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.keyboardNavigationModule = exports.KeyboardNavigationController = void 0;
                var _click = __webpack_require__( /*! ../../../../common/core/events/click */ 64044);
                var _events_engine = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/core/events_engine */ 92774));
                var _pointer = _interopRequireDefault(__webpack_require__( /*! ../../../../common/core/events/pointer */ 89797));
                var _index = __webpack_require__( /*! ../../../../common/core/events/utils/index */ 98834);
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../../../core/dom_adapter */ 64960));
                var _element = __webpack_require__( /*! ../../../../core/element */ 61404);
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../../core/renderer */ 64553));
                var _browser = _interopRequireDefault(__webpack_require__( /*! ../../../../core/utils/browser */ 48314));
                var _deferred = __webpack_require__( /*! ../../../../core/utils/deferred */ 87739);
                var _size = __webpack_require__( /*! ../../../../core/utils/size */ 57653);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var accessibility = function(e, r) {
                    if (!r && e && e.__esModule) {
                        return e
                    }
                    if (null === e || "object" != typeof e && "function" != typeof e) {
                        return {
                            default: e
                        }
                    }
                    var t = _getRequireWildcardCache(r);
                    if (t && t.has(e)) {
                        return t.get(e)
                    }
                    var n = {
                            __proto__: null
                        },
                        a = Object.defineProperty && Object.getOwnPropertyDescriptor;
                    for (var u in e) {
                        if ("default" !== u && {}.hasOwnProperty.call(e, u)) {
                            var i = a ? Object.getOwnPropertyDescriptor(e, u) : null;
                            i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]
                        }
                    }
                    return n.default = e, t && t.set(e, n), n
                }(__webpack_require__( /*! ../../../../ui/shared/accessibility */ 16191));
                var _m_dom = __webpack_require__( /*! ../../../core/utils/m_dom */ 76400);
                var _m_selectors = __webpack_require__( /*! ../../../core/utils/m_selectors */ 62238);
                var _memoize = __webpack_require__( /*! ../../../utils/memoize */ 78698);
                var _const = __webpack_require__( /*! ../editing/const */ 69699);
                var _m_utils = _interopRequireDefault(__webpack_require__( /*! ../m_utils */ 53226));
                var _const2 = __webpack_require__( /*! ./const */ 24171);
                var _dom = __webpack_require__( /*! ./dom */ 3024);
                var _m_keyboard_navigation_core = __webpack_require__( /*! ./m_keyboard_navigation_core */ 59796);
                var _m_keyboard_navigation_utils = __webpack_require__( /*! ./m_keyboard_navigation_utils */ 93734);
                var _scrollable_a11y = __webpack_require__( /*! ./scrollable_a11y */ 47526);

                function _getRequireWildcardCache(e) {
                    if ("function" != typeof WeakMap) {
                        return null
                    }
                    var r = new WeakMap,
                        t = new WeakMap;
                    return (_getRequireWildcardCache = function(e) {
                        return e ? t : r
                    })(e)
                }

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                class KeyboardNavigationController extends _m_keyboard_navigation_core.KeyboardNavigationController {
                    constructor() {
                        super(...arguments);
                        this._needNavigationToCell = false
                    }
                    init() {
                        this._dataController = this.getController("data");
                        this._selectionController = this.getController("selection");
                        this._editingController = this.getController("editing");
                        this._headerPanel = this.getView("headerPanel");
                        this._editorFactory = this.getController("editorFactory");
                        this._focusController = this.getController("focus");
                        this._adaptiveColumnsController = this.getController("adaptiveColumns");
                        this._columnResizerController = this.getController("columnsResizer");
                        this._rowsView = this.getView("rowsView");
                        super.init();
                        this._memoFireFocusedCellChanged = (0, _memoize.memoize)(this._memoFireFocusedCellChanged.bind(this), {
                            compareType: "value"
                        });
                        this._memoFireFocusedRowChanged = (0, _memoize.memoize)(this._memoFireFocusedRowChanged.bind(this), {
                            compareType: "value"
                        });
                        this.focusedHandlerWithContext = this.focusedHandlerWithContext || this.focusedHandler.bind(this);
                        this.focusOutHandlerContext = this.focusOutHandlerContext ?? this.focusOutHandler.bind(this);
                        this._updateFocusTimeout = null;
                        this._fastEditingStarted = false;
                        this._canceledCellPosition = null;
                        if (this.isKeyboardEnabled()) {
                            var _this$_editorFactory;
                            accessibility.subscribeVisibilityChange();
                            null === (_this$_editorFactory = this._editorFactory) || void 0 === _this$_editorFactory || _this$_editorFactory.focused.add(this.focusedHandlerWithContext)
                        } else {
                            var _this$_editorFactory2;
                            accessibility.unsubscribeVisibilityChange();
                            null === (_this$_editorFactory2 = this._editorFactory) || void 0 === _this$_editorFactory2 || _this$_editorFactory2.focused.remove(this.focusedHandlerWithContext)
                        }
                        this.initDocumentHandlers()
                    }
                    dispose() {
                        super.dispose();
                        this._resetFocusedView();
                        _events_engine.default.off(_dom_adapter.default.getDocument(), (0, _index.addNamespace)(_pointer.default.down, "dxDataGridKeyboardNavigation"), this._documentClickHandler);
                        clearTimeout(this._updateFocusTimeout);
                        accessibility.unsubscribeVisibilityChange()
                    }
                    focusedHandler($element) {
                        this.setupFocusedView();
                        if (this._isNeedScroll) {
                            if ($element.is(":visible") && this._focusedView && this._focusedView.getScrollable()) {
                                this._focusedView._scrollToElement($element);
                                this._isNeedScroll = false
                            }
                        }
                    }
                    focusinHandler(event) {
                        const $element = (0, _renderer.default)(event.target);
                        const isRelatedTargetInRowsView = (0, _renderer.default)(event.relatedTarget).closest(this._rowsView.element()).length;
                        const isLink = $element.is("a");
                        if (event.relatedTarget && isLink && !isRelatedTargetInRowsView && this._isEventInCurrentGrid(event)) {
                            let $focusedCell = this._getFocusedCell();
                            $focusedCell = !(0, _m_keyboard_navigation_utils.isElementDefined)($focusedCell) ? this._rowsView.getCellElements(0).filter("[tabindex]").eq(0) : $focusedCell;
                            if (!$element.closest($focusedCell).length) {
                                event.preventDefault();
                                _events_engine.default.trigger($focusedCell, "focus")
                            }
                        }
                        const isCell = $element.is("td");
                        const needSetFocusPosition = (this.option("focusedRowIndex") ?? -1) < 0;
                        if (isCell && needSetFocusPosition) {
                            this._updateFocusedCellPosition($element)
                        }
                    }
                    focusOutHandler(e) {
                        const {
                            relatedTarget: relatedTarget
                        } = e;
                        this._toggleInertAttr(false);
                        if (relatedTarget && !this.isInsideFocusedView((0, _renderer.default)(relatedTarget))) {
                            this._isNeedFocus = false;
                            this._isHiddenFocus = false;
                            this._isNeedScroll = false
                        }
                    }
                    subscribeToRowsViewFocusEvent() {
                        var _this$_rowsView;
                        const $rowsView = null === (_this$_rowsView = this._rowsView) || void 0 === _this$_rowsView ? void 0 : _this$_rowsView.element();
                        _events_engine.default.on($rowsView, "focusin", this.focusinHandlerContext);
                        _events_engine.default.on($rowsView, "focusout", this.focusOutHandlerContext)
                    }
                    unsubscribeFromRowsViewFocusEvent() {
                        var _this$_rowsView2;
                        const $rowsView = null === (_this$_rowsView2 = this._rowsView) || void 0 === _this$_rowsView2 ? void 0 : _this$_rowsView2.element();
                        _events_engine.default.off($rowsView, "focusin", this.focusinHandlerContext);
                        _events_engine.default.off($rowsView, "focusout", this.focusOutHandlerContext)
                    }
                    resizeCompleted() {
                        var _this$_rowsView3;
                        if (this.navigationToCellInProgress()) {
                            this._resizeController.resetLastResizeTime()
                        }
                        if (!this.needToRestoreFocus) {
                            return
                        }
                        const scrollLeft = (null === (_this$_rowsView3 = this._rowsView) || void 0 === _this$_rowsView3 || null === (_this$_rowsView3 = _this$_rowsView3.getScrollable()) || void 0 === _this$_rowsView3 ? void 0 : _this$_rowsView3.scrollLeft()) ?? 0;
                        if (!this._columnsController.isNeedToRenderVirtualColumns(scrollLeft)) {
                            this.needToRestoreFocus = false;
                            this.focusFirstOrLastCell()
                        }
                    }
                    renderCompleted(e) {
                        const $rowsView = this._rowsView.element();
                        const isFullUpdate = !e || "refresh" === e.changeType;
                        const isFocusedViewCorrect = this._focusedView && this._focusedView.name === this._rowsView.name;
                        let needUpdateFocus = false;
                        const isAppend = e && ("append" === e.changeType || "prepend" === e.changeType);
                        const root = (0, _renderer.default)(_dom_adapter.default.getRootNode($rowsView.get && $rowsView.get(0)));
                        const $focusedElement = root.find(":focus");
                        const isFocusedElementCorrect = this._isFocusedElementCorrect($focusedElement, $rowsView, e);
                        this.unsubscribeFromRowsViewFocusEvent();
                        this.subscribeToRowsViewFocusEvent();
                        this.initPointerEventHandler();
                        this.initKeyDownHandler();
                        this._setRowsViewAttributes();
                        if (isFocusedViewCorrect && isFocusedElementCorrect) {
                            needUpdateFocus = this._isNeedFocus ? !isAppend : this._isHiddenFocus && isFullUpdate && !(null !== e && void 0 !== e && e.virtualColumnsScrolling);
                            if (needUpdateFocus) {
                                var _e$event;
                                const isScrollEvent = !!(null !== e && void 0 !== e && null !== (_e$event = e.event) && void 0 !== _e$event && _e$event.type);
                                const skipFocusEvent = (null === e || void 0 === e ? void 0 : e.virtualColumnsScrolling) && isScrollEvent;
                                this._updateFocus(true, skipFocusEvent)
                            }
                        }
                    }
                    _isFocusedElementCorrect($focusedElement, $rowsView, e) {
                        if ($focusedElement.length && !$focusedElement.closest($rowsView).length) {
                            return false
                        }
                        if (!$focusedElement.length && null !== e && void 0 !== e && e.virtualColumnsScrolling) {
                            var _this$_focusedCellPos;
                            const focusedColumnIndex = (null === (_this$_focusedCellPos = this._focusedCellPosition) || void 0 === _this$_focusedCellPos ? void 0 : _this$_focusedCellPos.columnIndex) ?? -1;
                            return this._isColumnRendered(focusedColumnIndex)
                        }
                        return true
                    }
                    initHandlers() {
                        this.unsubscribeFromRowsViewFocusEvent();
                        this.unsubscribeFromPointerEvent();
                        super.initHandlers()
                    }
                    initDocumentHandlers() {
                        const document = _dom_adapter.default.getDocument();
                        this._documentClickHandler = this._documentClickHandler || this.createAction((e => {
                            var _this$_columnResizerC;
                            const $target = (0, _renderer.default)(e.event.target);
                            const tableSelector = `.${this.addWidgetPrefix(_const2.TABLE_CLASS)}`;
                            const rowsViewSelector = `.${this.addWidgetPrefix(_const2.ROWS_VIEW_CLASS)}`;
                            const editorOverlaySelector = `.${_const2.DROPDOWN_EDITOR_OVERLAY_CLASS}`;
                            const needKeepFocus = !!$target.closest(tableSelector).length && !(0, _m_dom.isElementInDom)($target);
                            if (needKeepFocus) {
                                e.event.preventDefault();
                                return
                            }
                            const isRowsViewClick = this._isEventInCurrentGrid(e.event) && !!$target.closest(rowsViewSelector).length;
                            const isEditorOverlayClick = !!$target.closest(editorOverlaySelector).length;
                            const isColumnResizing = !!(null !== (_this$_columnResizerC = this._columnResizerController) && void 0 !== _this$_columnResizerC && _this$_columnResizerC.isResizing());
                            if (!isRowsViewClick && !isEditorOverlayClick && !isColumnResizing) {
                                const isClickOutsideFocusedView = this._focusedView ? 0 === $target.closest(this._focusedView.element()).length : true;
                                if (isClickOutsideFocusedView) {
                                    this._resetFocusedCell(true)
                                }
                                this._resetFocusedView()
                            }
                        }));
                        _events_engine.default.off(document, (0, _index.addNamespace)(_pointer.default.down, "dxDataGridKeyboardNavigation"), this._documentClickHandler);
                        if (this.isKeyboardEnabled()) {
                            _events_engine.default.on(document, (0, _index.addNamespace)(_pointer.default.down, "dxDataGridKeyboardNavigation"), this._documentClickHandler)
                        }
                    }
                    _setRowsViewAttributes() {
                        const $rowsView = this._getRowsViewElement();
                        const isGridEmpty = !this._dataController.getVisibleRows().length;
                        if (isGridEmpty) {
                            this._applyTabIndexToElement($rowsView)
                        }
                    }
                    unsubscribeFromPointerEvent() {
                        const pointerEventName = !(0, _m_keyboard_navigation_utils.isMobile)() ? _pointer.default.down : _click.name;
                        const $rowsView = this._getRowsViewElement();
                        this._pointerEventAction && _events_engine.default.off($rowsView, (0, _index.addNamespace)(pointerEventName, "dxDataGridKeyboardNavigation"), this._pointerEventAction)
                    }
                    subscribeToPointerEvent() {
                        const pointerEventName = !(0, _m_keyboard_navigation_utils.isMobile)() ? _pointer.default.down : _click.name;
                        const $rowsView = this._getRowsViewElement();
                        const clickSelector = `.${_const.ROW_CLASS} > td, .${_const.ROW_CLASS}`;
                        _events_engine.default.on($rowsView, (0, _index.addNamespace)(pointerEventName, "dxDataGridKeyboardNavigation"), clickSelector, this._pointerEventAction)
                    }
                    initPointerEventHandler() {
                        this._pointerEventAction = this._pointerEventAction || this.createAction(this._pointerEventHandler);
                        this.unsubscribeFromPointerEvent();
                        this.subscribeToPointerEvent()
                    }
                    isRowFocusType() {
                        return this.focusType === _const2.FOCUS_TYPE_ROW
                    }
                    isCellFocusType() {
                        return this.focusType === _const2.FOCUS_TYPE_CELL
                    }
                    setRowFocusType() {
                        if (this.option("focusedRowEnabled")) {
                            this.focusType = _const2.FOCUS_TYPE_ROW
                        }
                    }
                    setCellFocusType() {
                        this.focusType = _const2.FOCUS_TYPE_CELL
                    }
                    executeTabKey(event, options) {
                        const isEditing = this._editingController.isEditing();
                        const direction = event.shift ? "previous" : "next";
                        const eventTarget = event.originalEvent.target;
                        const {
                            editingOptions: editingOptions,
                            isLastValidCell: isLastValidCell
                        } = options;
                        let originalHandlerRequired = options.isOriginalHandlerRequired;
                        if (editingOptions && eventTarget && !originalHandlerRequired) {
                            if (isEditing) {
                                if (!this._editingCellTabHandler(event, direction)) {
                                    return
                                }
                            } else if (this._targetCellTabHandler(event, direction)) {
                                originalHandlerRequired = true
                            }
                        }
                        if (originalHandlerRequired) {
                            const $cell = this._getFocusedCell();
                            const isCommandCell = $cell.is(_const2.COMMAND_CELL_SELECTOR);
                            if (isLastValidCell && !isCommandCell) {
                                this._toggleInertAttr(true)
                            }
                            this._editorFactory.loseFocus();
                            if (this._editingController.isEditing() && !this._isRowEditMode()) {
                                this._resetFocusedCell(true);
                                this._resetFocusedView();
                                this._closeEditCell()
                            }
                            return
                        }
                        event.originalEvent.preventDefault()
                    }
                    keyDownHandler(e) {
                        var _this$_editingControl;
                        let needStopPropagation = true;
                        this._isNeedFocus = true;
                        this._isNeedScroll = true;
                        let isHandled = this.processOnKeyDown(e);
                        const isEditing = null === (_this$_editingControl = this._editingController) || void 0 === _this$_editingControl ? void 0 : _this$_editingControl.isEditing();
                        const {
                            originalEvent: originalEvent
                        } = e;
                        if (originalEvent.isDefaultPrevented()) {
                            this._isNeedFocus = false;
                            this._isNeedScroll = false;
                            return
                        }!_const2.FUNCTIONAL_KEYS.includes(e.keyName) && this._updateFocusedCellPositionByTarget(originalEvent.target);
                        if (!isHandled) {
                            switch (e.keyName) {
                                case "leftArrow":
                                case "rightArrow":
                                    this._leftRightKeysHandler(e, isEditing);
                                    isHandled = true;
                                    break;
                                case "upArrow":
                                case "downArrow":
                                    if (e.ctrl) {
                                        accessibility.selectView("rowsView", this, originalEvent)
                                    } else {
                                        this._upDownKeysHandler(e, isEditing)
                                    }
                                    isHandled = true;
                                    break;
                                case "pageUp":
                                case "pageDown":
                                    this._pageUpDownKeyHandler(e);
                                    isHandled = true;
                                    break;
                                case "space":
                                    isHandled = this._spaceKeyHandler(e, isEditing);
                                    break;
                                case "A":
                                    if ((0, _index.isCommandKeyPressed)(e.originalEvent)) {
                                        this._ctrlAKeyHandler(e, isEditing);
                                        isHandled = true
                                    } else {
                                        isHandled = this._beginFastEditing(e.originalEvent)
                                    }
                                    break;
                                case "tab":
                                    this._tabKeyHandler(e);
                                    isHandled = true;
                                    break;
                                case "enter":
                                    this._enterKeyHandler(e, isEditing);
                                    isHandled = true;
                                    break;
                                case "escape":
                                    isHandled = this._escapeKeyHandler(e, isEditing);
                                    break;
                                case "F":
                                    if ((0, _index.isCommandKeyPressed)(e.originalEvent)) {
                                        this._ctrlFKeyHandler(e);
                                        isHandled = true
                                    } else {
                                        isHandled = this._beginFastEditing(e.originalEvent)
                                    }
                                    break;
                                case "F2":
                                    this._f2KeyHandler();
                                    isHandled = true;
                                    break;
                                case "del":
                                case "backspace":
                                    if (this._isFastEditingAllowed() && !this._isFastEditingStarted()) {
                                        isHandled = this._beginFastEditing(originalEvent, true)
                                    }
                                    break;
                                case "home":
                                case "end":
                                    this.homeOrEndKeyHandler(e)
                            }
                            if (!isHandled && !this._beginFastEditing(originalEvent)) {
                                this._isNeedFocus = false;
                                this._isNeedScroll = false;
                                needStopPropagation = false
                            }
                            if (needStopPropagation) {
                                originalEvent.stopPropagation()
                            }
                        }
                    }
                    _closeEditCell() {
                        const d = (0, _deferred.Deferred)();
                        setTimeout((() => {
                            this._editingController.closeEditCell().always(d.resolve)
                        }));
                        return d
                    }
                    _leftRightKeysHandler(eventArgs, isEditing) {
                        const rowIndex = this.getVisibleRowIndex();
                        const {
                            originalEvent: originalEvent
                        } = eventArgs;
                        const $row = this._focusedView && this._focusedView.getRow(rowIndex);
                        const directionCode = this._getDirectionCodeByKey(eventArgs.keyName);
                        const isEditingNavigationMode = this._isFastEditingStarted();
                        const allowNavigate = (!isEditing || isEditingNavigationMode) && (0, _m_keyboard_navigation_utils.isDataRow)($row);
                        if (!allowNavigate) {
                            return
                        }
                        null === originalEvent || void 0 === originalEvent || originalEvent.preventDefault();
                        this.setCellFocusType();
                        if (isEditingNavigationMode) {
                            this._closeEditCell()
                        }
                        const focusNextCell = () => {
                            const $cell = this._getNextCell(directionCode);
                            if ((0, _m_keyboard_navigation_utils.isElementDefined)($cell)) {
                                this._arrowKeysHandlerFocusCell(originalEvent, $cell, directionCode)
                            }
                        };
                        if (this._isVirtualColumnRender()) {
                            this._processVirtualHorizontalPosition(directionCode, eventArgs).done(focusNextCell);
                            return
                        }
                        focusNextCell()
                    }
                    isInsideMasterDetail($target) {
                        const $masterDetail = $target.closest(`.${_const2.MASTER_DETAIL_CELL_CLASS}`);
                        return !!$masterDetail.get(0) && this.elementIsInsideGrid($masterDetail) && !$target.is($masterDetail)
                    }
                    _upDownKeysHandler(eventArgs, isEditing) {
                        var _this$_editingControl2, _this$_editingControl3;
                        const visibleRowIndex = this.getVisibleRowIndex();
                        const $row = this._focusedView && this._focusedView.getRow(visibleRowIndex);
                        const $event = eventArgs.originalEvent;
                        const isUpArrow = "upArrow" === eventArgs.keyName;
                        const dataSource = this._dataController.dataSource();
                        const isRowEditingInCurrentRow = null === (_this$_editingControl2 = this._editingController) || void 0 === _this$_editingControl2 || null === (_this$_editingControl3 = _this$_editingControl2.isEditRowByIndex) || void 0 === _this$_editingControl3 ? void 0 : _this$_editingControl3.call(_this$_editingControl2, visibleRowIndex);
                        const isEditingNavigationMode = this._isFastEditingStarted();
                        const isInsideMasterDetail = this.isInsideMasterDetail((0, _renderer.default)(null === $event || void 0 === $event ? void 0 : $event.target));
                        const allowNavigate = (!isRowEditingInCurrentRow || !isEditing || isEditingNavigationMode) && $row && !(0, _m_keyboard_navigation_utils.isEditForm)($row) && !isInsideMasterDetail;
                        if (allowNavigate) {
                            isEditingNavigationMode && this._closeEditCell();
                            if (!this._navigateNextCell($event, eventArgs.keyName)) {
                                if (this._isVirtualRowRender() && isUpArrow && dataSource && !dataSource.isLoading()) {
                                    const rowHeight = (0, _size.getOuterHeight)($row);
                                    const rowIndex = this._focusedCellPosition.rowIndex - 1;
                                    this._scrollBy(0, -rowHeight, rowIndex, $event)
                                }
                            }
                            $event && $event.preventDefault()
                        }
                    }
                    _pageUpDownKeyHandler(eventArgs) {
                        const pageIndex = this._dataController.pageIndex();
                        const pageCount = this._dataController.pageCount();
                        const pagingEnabled = this.option("paging.enabled");
                        const isPageUp = "pageUp" === eventArgs.keyName;
                        const pageStep = isPageUp ? -1 : 1;
                        const scrollable = this._rowsView.getScrollable();
                        if (pagingEnabled && !this._isVirtualScrolling()) {
                            if ((isPageUp ? pageIndex > 0 : pageIndex < pageCount - 1) && !this._isVirtualScrolling()) {
                                this._dataController.pageIndex(pageIndex + pageStep);
                                eventArgs.originalEvent.preventDefault()
                            }
                        } else if (scrollable && (0, _size.getHeight)(scrollable.container()) < (0, _size.getHeight)(scrollable.$content())) {
                            this._scrollBy(0, (0, _size.getHeight)(scrollable.container()) * pageStep);
                            eventArgs.originalEvent.preventDefault()
                        }
                    }
                    _spaceKeyHandler(eventArgs, isEditing) {
                        const rowIndex = this.getVisibleRowIndex();
                        const $target = (0, _renderer.default)(eventArgs.originalEvent && eventArgs.originalEvent.target);
                        if (this.option("selection") && "none" !== this.option("selection").mode && !isEditing) {
                            const isFocusedRowElement = "row" === this._getElementType($target) && this.isRowFocusType() && (0, _m_keyboard_navigation_utils.isDataRow)($target);
                            const isFocusedSelectionCell = $target.hasClass(_const2.COMMAND_SELECT_CLASS);
                            if (isFocusedSelectionCell && "onClick" === this.option("selection.showCheckBoxesMode")) {
                                this._selectionController.startSelectionWithCheckboxes()
                            }
                            if (isFocusedRowElement || $target.parent().hasClass(_const2.DATA_ROW_CLASS) || $target.hasClass(this.addWidgetPrefix(_const2.ROWS_VIEW_CLASS))) {
                                this._selectionController.changeItemSelection(rowIndex, {
                                    shift: eventArgs.shift,
                                    control: eventArgs.ctrl
                                });
                                eventArgs.originalEvent.preventDefault();
                                return true
                            }
                            return false
                        }
                        return this._beginFastEditing(eventArgs.originalEvent)
                    }
                    _ctrlAKeyHandler(eventArgs, isEditing) {
                        if (!isEditing && !eventArgs.alt && "multiple" === this.option("selection.mode") && this.option("selection.allowSelectAll")) {
                            this._selectionController.selectAll();
                            eventArgs.originalEvent.preventDefault()
                        }
                    }
                    _toggleInertAttr(value) {}
                    _tabKeyHandler(event) {
                        const direction = event.shift ? "previous" : "next";
                        const eventTarget = event.originalEvent.target;
                        const focusedViewElement = this._focusedView && this._focusedView.element();
                        const editingOptions = this.option("editing");
                        const hasFocusedCellPosition = (0, _type.isDefined)(this._focusedCellPosition) && !(0, _type.isEmptyObject)(this._focusedCellPosition);
                        const isFirstValidCell = event.shift && hasFocusedCellPosition ? this._isFirstValidCell(this._focusedCellPosition) : false;
                        const isLastValidCell = !event.shift && hasFocusedCellPosition ? this._isLastValidCell(this._focusedCellPosition) : false;
                        const isRowsViewElement = (0, _renderer.default)(eventTarget).hasClass(this.addWidgetPrefix(_const2.ROWS_VIEW_CLASS));
                        const isOriginalHandlerRequired = !hasFocusedCellPosition || isFirstValidCell || isLastValidCell;
                        const canHandleEditing = editingOptions && eventTarget && !isOriginalHandlerRequired;
                        const shouldResetFocusedCell = canHandleEditing && isRowsViewElement;
                        const shouldProcessVirtualPosition = canHandleEditing && this._isVirtualColumnRender();
                        const options = {
                            editingOptions: editingOptions,
                            isLastValidCell: isLastValidCell,
                            isOriginalHandlerRequired: isOriginalHandlerRequired
                        };
                        if (this._handleTabKeyOnMasterDetailCell(eventTarget, direction)) {
                            return
                        }(0, _renderer.default)(focusedViewElement).addClass(_const2.FOCUS_STATE_CLASS);
                        if (shouldResetFocusedCell) {
                            this._resetFocusedCell()
                        }
                        if (shouldProcessVirtualPosition) {
                            this._processVirtualHorizontalPosition(direction, event).done((() => {
                                this.executeTabKey(event, options)
                            }));
                            return
                        }
                        this.executeTabKey(event, options)
                    }
                    _getMaxVerticalOffset() {
                        const scrollable = this.component.getScrollable();
                        return scrollable ? scrollable.scrollHeight() - (0, _size.getHeight)(this._rowsView.element()) : 0
                    }
                    _getMaxHorizontalOffset() {
                        const scrollable = this.component.getScrollable();
                        return scrollable ? scrollable.scrollWidth() - (0, _size.getWidth)(this._rowsView.element()) : 0
                    }
                    _isColumnRendered(columnIndex) {
                        const allVisibleColumns = this._columnsController.getVisibleColumns(null, true);
                        const renderedVisibleColumns = this._columnsController.getVisibleColumns();
                        const column = allVisibleColumns[columnIndex];
                        let result = false;
                        if (column) {
                            result = renderedVisibleColumns.indexOf(column) >= 0
                        }
                        return result
                    }
                    _isFixedColumn(columnIndex) {
                        const allVisibleColumns = this._columnsController.getVisibleColumns(null, true);
                        const column = allVisibleColumns[columnIndex];
                        return !!column && !!column.fixed
                    }
                    _isColumnVirtual(columnIndex) {
                        const localColumnIndex = columnIndex - this._columnsController.getColumnIndexOffset();
                        const visibleColumns = this._columnsController.getVisibleColumns();
                        const column = visibleColumns[localColumnIndex];
                        return !!column && "virtual" === column.command
                    }
                    _processVirtualHorizontalPosition(direction, event) {
                        const columnIndex = this.getColumnIndex();
                        let nextColumnIndex;
                        let horizontalScrollPosition = 0;
                        let needToScroll = false;
                        switch (direction) {
                            case "next":
                            case "nextInRow": {
                                const columnsCount = this._getVisibleColumnCount();
                                nextColumnIndex = columnIndex + 1;
                                horizontalScrollPosition = this.option("rtlEnabled") ? this._getMaxHorizontalOffset() : 0;
                                if ("next" === direction) {
                                    needToScroll = columnsCount === nextColumnIndex || this._isFixedColumn(columnIndex) && !this._isColumnRendered(nextColumnIndex)
                                } else {
                                    needToScroll = columnsCount > nextColumnIndex && this._isFixedColumn(columnIndex) && !this._isColumnRendered(nextColumnIndex)
                                }
                                break
                            }
                            case "previous":
                            case "previousInRow":
                                nextColumnIndex = columnIndex - 1;
                                horizontalScrollPosition = this.option("rtlEnabled") ? 0 : this._getMaxHorizontalOffset();
                                if ("previous" === direction) {
                                    const columnIndexOffset = this._columnsController.getColumnIndexOffset();
                                    const leftEdgePosition = nextColumnIndex < 0 && 0 === columnIndexOffset;
                                    needToScroll = leftEdgePosition || this._isFixedColumn(columnIndex) && !this._isColumnRendered(nextColumnIndex)
                                } else {
                                    needToScroll = nextColumnIndex >= 0 && this._isFixedColumn(columnIndex) && !this._isColumnRendered(nextColumnIndex)
                                }
                        }
                        if (needToScroll) {
                            event.originalEvent.preventDefault();
                            return this.scrollLeft(horizontalScrollPosition)
                        }
                        if ((0, _type.isDefined)(nextColumnIndex) && (0, _type.isDefined)(direction) && this._isColumnVirtual(nextColumnIndex)) {
                            event.originalEvent.preventDefault();
                            return this.scrollToNextCell(null, direction)
                        }
                        return (0, _deferred.Deferred)().resolve().promise()
                    }
                    _editingCellTabHandler(eventArgs, direction) {
                        const eventTarget = eventArgs.originalEvent.target;
                        const $targetCell = this._getCellElementFromTarget(eventTarget);
                        const isCommandCell = $targetCell.is(_const2.COMMAND_CELL_SELECTOR);
                        if (this.isOriginalTabHandlerRequired($targetCell, eventArgs)) {
                            return false
                        }
                        if (isCommandCell) {
                            return !this._targetCellTabHandler(eventArgs, direction)
                        }
                        this._updateFocusedCellPosition($targetCell);
                        const elementType = this._getElementType(eventTarget);
                        const nextCellInfo = this._getNextCellByTabKey(eventArgs.originalEvent, direction, elementType);
                        const $nextCell = nextCellInfo.$cell;
                        if (!$nextCell || this._handleTabKeyOnMasterDetailCell($nextCell, direction)) {
                            return false
                        }
                        let isEditingAllowed = false;
                        const column = this._getColumnByCellElement($nextCell);
                        if (null !== column && void 0 !== column && column.allowEditing) {
                            const $row = $nextCell.parent();
                            const rowIndex = this._getLocalRowIndex($row);
                            const row = this._dataController.items()[rowIndex];
                            const isDataRow = !row || "data" === row.rowType;
                            isEditingAllowed = this._editingController.allowUpdating({
                                row: row
                            }) ? isDataRow : null === row || void 0 === row ? void 0 : row.isNewRow
                        }
                        if (!isEditingAllowed) {
                            this._closeEditCell()
                        }
                        const nextCellFocused = this._focusCell($nextCell, !nextCellInfo.isHighlighted);
                        if (nextCellFocused) {
                            const isRowMode = this._isRowEditMode();
                            if (!isRowMode && isEditingAllowed) {
                                this._editFocusedCell()
                            } else {
                                this._focusInteractiveElement($nextCell, eventArgs.shift)
                            }
                        }
                        return true
                    }
                    isOriginalTabHandlerRequired($cell, event) {
                        const eventTarget = event.originalEvent.target;
                        const elementType = this._getElementType(eventTarget);
                        const $lastInteractiveElement = (0, _m_keyboard_navigation_utils.getInteractiveElement)($cell, !event.shift);
                        if ("cell" !== elementType || 0 === $lastInteractiveElement.length) {
                            return false
                        }
                        return eventTarget !== $lastInteractiveElement.get(0)
                    }
                    _targetCellTabHandler(eventArgs, direction) {
                        const $event = eventArgs.originalEvent;
                        let eventTarget = $event.target;
                        let elementType = this._getElementType(eventTarget);
                        let $cell = this._getCellElementFromTarget(eventTarget);
                        if (!(0, _m_keyboard_navigation_utils.isEditorCell)(this, $cell) && this.isOriginalTabHandlerRequired($cell, eventArgs)) {
                            return true
                        }
                        if (void 0 === this._focusedCellPosition.rowIndex && (0, _renderer.default)(eventTarget).hasClass(_const.ROW_CLASS)) {
                            this._updateFocusedCellPosition($cell)
                        }
                        if (this.isRowFocusType()) {
                            this.setCellFocusType();
                            if ("row" === elementType && (0, _m_keyboard_navigation_utils.isDataRow)((0, _renderer.default)(eventTarget))) {
                                eventTarget = this.getFirstValidCellInRow((0, _renderer.default)(eventTarget));
                                elementType = this._getElementType(eventTarget)
                            }
                        }
                        const nextCellInfo = this._getNextCellByTabKey($event, direction, elementType);
                        $cell = nextCellInfo.$cell;
                        if (!$cell) {
                            return false
                        }
                        $cell = this._checkNewLineTransition($event, $cell);
                        if (!$cell) {
                            return false
                        }
                        this._focusCell($cell, !nextCellInfo.isHighlighted);
                        if (!(0, _m_keyboard_navigation_utils.isEditorCell)(this, $cell)) {
                            this._focusInteractiveElement($cell, eventArgs.shift)
                        }
                        return false
                    }
                    _getNextCellByTabKey($event, direction, elementType) {
                        let $cell = this._getNextCell(direction, elementType);
                        const args = $cell && this._fireFocusedCellChanging($event, $cell, true);
                        if (!args || args.cancel) {
                            return {}
                        }
                        if (args.$newCellElement) {
                            $cell = args.$newCellElement
                        }
                        return {
                            $cell: $cell,
                            isHighlighted: args.isHighlighted
                        }
                    }
                    _checkNewLineTransition($event, $cell) {
                        const rowIndex = this.getVisibleRowIndex();
                        const $row = $cell.parent();
                        if (rowIndex !== this._getRowIndex($row)) {
                            const cellPosition = this._getCellPosition($cell);
                            const args = this._fireFocusedRowChanging($event, $row);
                            if (args.cancel) {
                                return
                            }
                            if (args.rowIndexChanged && cellPosition) {
                                this.setFocusedColumnIndex(cellPosition.columnIndex);
                                $cell = this._getFocusedCell()
                            }
                        }
                        return $cell
                    }
                    _enterKeyHandler(eventArgs, isEditing) {
                        var _this$_focusedView, _this$getMasterDetail;
                        const rowIndex = this.getVisibleRowIndex();
                        const key = this._dataController.getKeyByRowIndex(rowIndex);
                        const $row = null === (_this$_focusedView = this._focusedView) || void 0 === _this$_focusedView ? void 0 : _this$_focusedView.getRow(rowIndex);
                        const $cell = this._getFocusedCell();
                        const needExpandGroupRow = this.option("grouping.allowCollapsing") && (0, _m_keyboard_navigation_utils.isGroupRow)($row);
                        const needExpandMasterDetailRow = this.option("masterDetail.enabled") && (null === $cell || void 0 === $cell ? void 0 : $cell.hasClass(_const2.COMMAND_EXPAND_CLASS));
                        const needExpandAdaptiveRow = null === $cell || void 0 === $cell ? void 0 : $cell.hasClass(_const2.ADAPTIVE_COLUMN_NAME_CLASS);
                        if (needExpandGroupRow || needExpandMasterDetailRow) {
                            const item = this._dataController.items()[rowIndex];
                            const isNotContinuation = (null === item || void 0 === item ? void 0 : item.data) && !item.data.isContinuation;
                            if ((0, _type.isDefined)(key) && isNotContinuation) {
                                this._dataController.changeRowExpand(key)
                            }
                        } else if (needExpandAdaptiveRow) {
                            this._adaptiveColumnsController.toggleExpandAdaptiveDetailRow(key);
                            this._updateFocusedCellPosition($cell)
                        } else if (null !== (_this$getMasterDetail = this.getMasterDetailCell($cell)) && void 0 !== _this$getMasterDetail && _this$getMasterDetail.is($cell)) {
                            if ($cell.is(":focus")) {
                                this.focusFirstInteractiveElementInside($cell)
                            }
                        } else if (!(null !== $cell && void 0 !== $cell && $cell.hasClass(_const2.COMMAND_EDIT_CLASS))) {
                            this._processEnterKeyForDataCell(eventArgs, isEditing)
                        }
                    }
                    focusFirstInteractiveElementInside($el) {
                        $el.find(_const2.INTERACTIVE_ELEMENTS_SELECTOR).get(0).focus()
                    }
                    _processEnterKeyForDataCell(eventArgs, isEditing) {
                        const direction = this._getEnterKeyDirection(eventArgs);
                        const allowEditingOnEnterKey = this._allowEditingOnEnterKey();
                        if (isEditing || !allowEditingOnEnterKey && direction) {
                            this._handleEnterKeyEditingCell(eventArgs.originalEvent).done((() => {
                                if ("next" === direction || "previous" === direction) {
                                    this._targetCellTabHandler(eventArgs, direction)
                                } else if ("upArrow" === direction || "downArrow" === direction) {
                                    this._navigateNextCell(eventArgs.originalEvent, direction)
                                }
                            }))
                        } else if (allowEditingOnEnterKey) {
                            this._startEditing(eventArgs)
                        }
                    }
                    _getEnterKeyDirection(eventArgs) {
                        const enterKeyDirection = this.option("keyboardNavigation.enterKeyDirection");
                        const isShift = eventArgs.shift;
                        if ("column" === enterKeyDirection) {
                            return isShift ? "upArrow" : "downArrow"
                        }
                        if ("row" === enterKeyDirection) {
                            return isShift ? "previous" : "next"
                        }
                        return
                    }
                    _handleEnterKeyEditingCell(event) {
                        const d = (0, _deferred.Deferred)();
                        const {
                            target: target
                        } = event;
                        const $cell = this._getCellElementFromTarget(target);
                        const isRowEditMode = this._isRowEditMode();
                        this._updateFocusedCellPosition($cell);
                        if (isRowEditMode) {
                            this._focusEditFormCell($cell);
                            setTimeout(this._editingController.saveEditData.bind(this._editingController));
                            d.resolve()
                        } else {
                            _events_engine.default.trigger((0, _renderer.default)(target), "change");
                            this._closeEditCell().always(d.resolve);
                            event.preventDefault()
                        }
                        return d
                    }
                    _escapeKeyHandler(eventArgs, isEditing) {
                        const $cell = this._getCellElementFromTarget(eventArgs.originalEvent.target);
                        if (isEditing) {
                            this._updateFocusedCellPosition($cell);
                            if (!this._isRowEditMode()) {
                                if ("cell" === this._editingController.getEditMode()) {
                                    this._editingController.cancelEditData()
                                } else {
                                    this._closeEditCell()
                                }
                            } else {
                                this._focusEditFormCell($cell);
                                this._editingController.cancelEditData();
                                if (0 === this._dataController.items().length) {
                                    this._resetFocusedCell();
                                    this._editorFactory.loseFocus()
                                }
                            }
                            eventArgs.originalEvent.preventDefault();
                            return true
                        }
                        const masterDetailCell = this.getMasterDetailCell($cell);
                        if (masterDetailCell) {
                            this._focusCell(masterDetailCell);
                            return true
                        }
                        return false
                    }
                    _ctrlFKeyHandler(eventArgs) {
                        if (this.option("searchPanel.visible")) {
                            const searchTextEditor = this._headerPanel.getSearchTextEditor();
                            if (searchTextEditor) {
                                searchTextEditor.focus();
                                eventArgs.originalEvent.preventDefault()
                            }
                        }
                    }
                    _f2KeyHandler() {
                        const isEditing = this._editingController.isEditing();
                        const rowIndex = this.getVisibleRowIndex();
                        const $row = this._focusedView && this._focusedView.getRow(rowIndex);
                        if (!isEditing && (0, _m_keyboard_navigation_utils.isDataRow)($row)) {
                            this._startEditing()
                        }
                    }
                    _navigateNextCell($event, keyCode) {
                        const $cell = this._getNextCell(keyCode);
                        const directionCode = this._getDirectionCodeByKey(keyCode);
                        const isCellValid = $cell && this._isCellValid($cell);
                        const result = isCellValid ? this._arrowKeysHandlerFocusCell($event, $cell, directionCode) : false;
                        return result
                    }
                    _arrowKeysHandlerFocusCell($event, $nextCell, direction) {
                        const isVerticalDirection = "prevRow" === direction || "nextRow" === direction;
                        const args = this._fireFocusChangingEvents($event, $nextCell, isVerticalDirection, true);
                        $nextCell = args.$newCellElement;
                        if (!args.cancel && this._isCellValid($nextCell)) {
                            this._focus($nextCell, !args.isHighlighted);
                            return true
                        }
                        return false
                    }
                    _beginFastEditing(originalEvent, isDeleting) {
                        if (!this._isFastEditingAllowed() || originalEvent.altKey || originalEvent.ctrlKey || this._editingController.isEditing()) {
                            return false
                        }
                        if (isDeleting) {
                            this._startEditing(originalEvent, _const2.FAST_EDITING_DELETE_KEY)
                        } else {
                            const {
                                key: key
                            } = originalEvent;
                            const keyCode = originalEvent.keyCode || originalEvent.which;
                            const fastEditingKey = key || keyCode && String.fromCharCode(keyCode);
                            if (fastEditingKey && (1 === fastEditingKey.length || fastEditingKey === _const2.FAST_EDITING_DELETE_KEY)) {
                                this._startEditing(originalEvent, fastEditingKey)
                            }
                        }
                        return true
                    }
                    isQuickNavigationPossible() {
                        var _this$_rowsView4, _this$_editingControl4, _this$_editingControl5;
                        const visibleRowIndex = this.getVisibleRowIndex();
                        const $row = null === (_this$_rowsView4 = this._rowsView) || void 0 === _this$_rowsView4 ? void 0 : _this$_rowsView4.getRow(visibleRowIndex);
                        const dataRowTemplate = this.option("dataRowTemplate");
                        const isEditRowByIndex = null === (_this$_editingControl4 = this._editingController) || void 0 === _this$_editingControl4 || null === (_this$_editingControl5 = _this$_editingControl4.isEditRowByIndex) || void 0 === _this$_editingControl5 ? void 0 : _this$_editingControl5.call(_this$_editingControl4, visibleRowIndex);
                        return !isEditRowByIndex && !dataRowTemplate && (0, _m_keyboard_navigation_utils.isDataRow)($row)
                    }
                    getFirstOrLastColumnIndex(needFirstColumnIndex) {
                        const allVisibleColumns = this._columnsController.getVisibleColumns(null, true);
                        const findColumnIndex = column => this.isFocusableColumn(column);
                        return needFirstColumnIndex ? allVisibleColumns.findIndex(findColumnIndex) : allVisibleColumns.findLastIndex(findColumnIndex)
                    }
                    getFirstOrLastRowIndex(needFirstRow) {
                        var _this$_dataController;
                        const rowCount = this._isVirtualScrolling() ? this._dataController.totalItemsCount() : null === (_this$_dataController = this._dataController.items(true)) || void 0 === _this$_dataController ? void 0 : _this$_dataController.length;
                        return needFirstRow ? 0 : rowCount - 1
                    }
                    calculateScrollLeft(needScrollToFirstCell) {
                        var _this$_columnsControl;
                        const result = needScrollToFirstCell ? 0 : this._getMaxHorizontalOffset();
                        const isNeedToRenderVirtualColumns = null === (_this$_columnsControl = this._columnsController) || void 0 === _this$_columnsControl ? void 0 : _this$_columnsControl.isNeedToRenderVirtualColumns(result);
                        return isNeedToRenderVirtualColumns ? result : -1
                    }
                    calculateScrollTop(needScrollToFirstCell) {
                        const maxVerticalOffset = this._getMaxVerticalOffset();
                        const hasScroll = maxVerticalOffset > 0;
                        const isVirtualRowRender = this._isVirtualRowRender();
                        if (isVirtualRowRender && hasScroll) {
                            return needScrollToFirstCell ? 0 : maxVerticalOffset
                        }
                        return -1
                    }
                    scrollTo(scrollOffset) {
                        var _this$_rowsView5;
                        const scrollable = null === (_this$_rowsView5 = this._rowsView) || void 0 === _this$_rowsView5 ? void 0 : _this$_rowsView5.getScrollable();
                        null === scrollable || void 0 === scrollable || scrollable.scrollTo(scrollOffset)
                    }
                    focusFirstOrLastCell(e) {
                        var _this$_rowsView$getSc;
                        const $cell = this._getFocusedCell();
                        this._focusElement($cell, true, e);
                        null === (_this$_rowsView$getSc = this._rowsView.getScrollable()) || void 0 === _this$_rowsView$getSc || _this$_rowsView$getSc.update()
                    }
                    navigateToFirstOrLastRow(needNavigateToFirstCell, e) {
                        const scrollTop = this.calculateScrollTop(needNavigateToFirstCell);
                        const firstOrLastRowIndex = this.getFirstOrLastRowIndex(needNavigateToFirstCell);
                        const firstOrLastColumnIndex = this.getFirstOrLastColumnIndex(needNavigateToFirstCell);
                        this.silentUpdateFocusedCellPosition({
                            columnIndex: firstOrLastColumnIndex,
                            rowIndex: firstOrLastRowIndex
                        });
                        if (scrollTop >= 0) {
                            this._needNavigationToCell = true;
                            this.scrollTo({
                                top: scrollTop
                            })
                        } else {
                            this.navigateToFirstOrLastCell(needNavigateToFirstCell, e)
                        }
                    }
                    homeOrEndKeyHandler(e) {
                        if (!this.isQuickNavigationPossible()) {
                            return
                        }
                        const needNavigateToFirstCell = "home" === e.keyName;
                        const {
                            originalEvent: originalEvent
                        } = e;
                        if ((0, _index.isCommandKeyPressed)(originalEvent)) {
                            this.navigateToFirstOrLastRow(needNavigateToFirstCell, originalEvent)
                        } else {
                            this.navigateToFirstOrLastCell(needNavigateToFirstCell, originalEvent)
                        }
                        originalEvent.preventDefault()
                    }
                    isFocusableColumn(column) {
                        return column.type !== _const2.DRAG_COLUMN_NAME
                    }
                    navigateToFirstOrLastCell(needNavigateToFirstCell, e) {
                        const firstOrLastColumnIndex = this.getFirstOrLastColumnIndex(needNavigateToFirstCell);
                        this._needNavigationToCell = false;
                        if (firstOrLastColumnIndex < 0) {
                            return
                        }
                        const scrollLeft = this.calculateScrollLeft(needNavigateToFirstCell);
                        this.silentUpdateFocusedCellPosition({
                            columnIndex: firstOrLastColumnIndex
                        });
                        if (scrollLeft >= 0) {
                            this.needToRestoreFocus = true;
                            this.scrollTo({
                                left: scrollLeft
                            })
                        } else {
                            this.focusFirstOrLastCell(e)
                        }
                    }
                    isQuickNavigationToFirstCell() {
                        var _this$_focusedCellPos2;
                        const firstColumnIndex = this.getFirstOrLastColumnIndex(true);
                        return (null === (_this$_focusedCellPos2 = this._focusedCellPosition) || void 0 === _this$_focusedCellPos2 ? void 0 : _this$_focusedCellPos2.columnIndex) === firstColumnIndex
                    }
                    _pointerEventHandler(e) {
                        var _this$_rowsView6;
                        const event = e.event || e;
                        let $target = (0, _renderer.default)(event.currentTarget);
                        const focusedViewElement = null === (_this$_rowsView6 = this._rowsView) || void 0 === _this$_rowsView6 ? void 0 : _this$_rowsView6.element();
                        const $parent = $target.parent();
                        const isInteractiveElement = (0, _renderer.default)(event.target).is(_const2.INTERACTIVE_ELEMENTS_SELECTOR);
                        const isRevertButton = !!(0, _renderer.default)(event.target).closest(`.${_const2.REVERT_BUTTON_CLASS}`).length;
                        const isExpandCommandCell = $target.hasClass(_const2.COMMAND_EXPAND_CLASS);
                        if (!this._isEventInCurrentGrid(event)) {
                            return
                        }
                        if (!isRevertButton && (this._isCellValid($target, !isInteractiveElement) || isExpandCommandCell)) {
                            $target = this._isInsideEditForm($target) ? (0, _renderer.default)(event.target) : $target;
                            this._focusView();
                            (0, _renderer.default)(focusedViewElement).removeClass(_const2.FOCUS_STATE_CLASS);
                            if ($parent.hasClass(_const2.FREESPACE_ROW_CLASS)) {
                                this._updateFocusedCellPosition($target);
                                this._applyTabIndexToElement(this._focusedView.element());
                                this._focusedView.focus(true)
                            } else if (!this.getMasterDetailCell($target)) {
                                this._clickTargetCellHandler(event, $target)
                            } else {
                                this._updateFocusedCellPosition($target)
                            }
                        } else if ($target.is("td")) {
                            this._resetFocusedCell()
                        }
                    }
                    _clickTargetCellHandler(event, $cell) {
                        const column = this._getColumnByCellElement($cell);
                        const isCellEditMode = this._isCellEditMode();
                        const isEditing = this._editingController.isEditing();
                        this.setCellFocusType();
                        const args = this._fireFocusChangingEvents(event, $cell, true);
                        $cell = args.$newCellElement;
                        if (!args.cancel) {
                            if (args.resetFocusedRow) {
                                this._focusController._resetFocusedRow();
                                return
                            }
                            if (args.rowIndexChanged) {
                                $cell = this._getFocusedCell()
                            }
                            if (!args.isHighlighted && !isCellEditMode) {
                                this.setRowFocusType()
                            }
                            this._updateFocusedCellPosition($cell);
                            if (this._allowRowUpdating() && isCellEditMode && column && column.allowEditing) {
                                this._isNeedFocus = false;
                                this._isHiddenFocus = false
                            } else {
                                $cell = this._getFocusedCell();
                                const $target = event && (0, _renderer.default)(event.target).closest(`${_const2.NON_FOCUSABLE_ELEMENTS_SELECTOR}, td`);
                                const skipFocusEvent = $target && $target.not($cell).is(_const2.NON_FOCUSABLE_ELEMENTS_SELECTOR);
                                const isEditCell = !(null !== column && void 0 !== column && column.command) && isEditing && $cell.hasClass(_const.EDITOR_CELL_CLASS);
                                const isDisabled = !isEditCell && (!args.isHighlighted || skipFocusEvent);
                                this._focus($cell, isDisabled, skipFocusEvent)
                            }
                        } else {
                            this.setRowFocusType();
                            this.setFocusedRowIndex(args.prevRowIndex);
                            if (isEditing && isCellEditMode) {
                                this._closeEditCell()
                            }
                        }
                    }
                    _allowRowUpdating() {
                        const rowIndex = this.getVisibleRowIndex();
                        const row = this._dataController.items()[rowIndex];
                        return this._editingController.allowUpdating({
                            row: row
                        }, "click")
                    }
                    focus(element) {
                        let activeElementSelector;
                        const focusedRowEnabled = this.option("focusedRowEnabled");
                        const isHighlighted = this._isCellElement((0, _renderer.default)(element));
                        if (!element) {
                            activeElementSelector = `.${this.addWidgetPrefix(_const2.ROWS_VIEW_CLASS)} .dx-row[tabindex]`;
                            if (!focusedRowEnabled) {
                                activeElementSelector += `, .${this.addWidgetPrefix(_const2.ROWS_VIEW_CLASS)} .dx-row > td[tabindex]`
                            }
                            element = this.component.$element().find(activeElementSelector).first()
                        }
                        element && this._focusElement((0, _renderer.default)(element), isHighlighted)
                    }
                    getFocusedView() {
                        return this.getView("rowsView")
                    }
                    setupFocusedView() {
                        if (this.isKeyboardEnabled() && !(0, _type.isDefined)(this._focusedView)) {
                            this._focusView()
                        }
                    }
                    _focusElement($element, isHighlighted, event) {
                        const rowsViewElement = (0, _renderer.default)(this._getRowsViewElement());
                        const $focusedView = $element.closest(rowsViewElement);
                        const isRowFocusType = this.isRowFocusType();
                        let args = {};
                        if (!$focusedView.length || this._isCellElement($element) && !this._isCellValid($element)) {
                            return
                        }
                        this._focusView();
                        this._isNeedFocus = true;
                        this._isNeedScroll = true;
                        if (this._isCellElement($element) || (0, _m_keyboard_navigation_utils.isGroupRow)($element)) {
                            this.setCellFocusType();
                            args = this._fireFocusChangingEvents(event, $element, true, isHighlighted);
                            $element = args.$newCellElement;
                            if (isRowFocusType && !args.isHighlighted) {
                                this.setRowFocusType()
                            }
                        }
                        if (!args.cancel) {
                            this._focus($element, !args.isHighlighted);
                            if ("row" !== this._getElementType($element) || (0, _m_keyboard_navigation_utils.isEditRow)($element)) {
                                this._focusInteractiveElement($element)
                            }
                        }
                    }
                    isInsideFocusedView($element) {
                        var _this$_focusedView2;
                        return 0 !== $element.closest(null === (_this$_focusedView2 = this._focusedView) || void 0 === _this$_focusedView2 ? void 0 : _this$_focusedView2.element()).length
                    }
                    _focusView() {
                        this._focusedView = this._rowsView
                    }
                    _resetFocusedView() {
                        this.setRowFocusType();
                        this._focusedView = null
                    }
                    _focusInteractiveElement($cell, isLast) {
                        if (!$cell) {
                            return
                        }
                        const $focusedElement = (0, _m_keyboard_navigation_utils.getInteractiveElement)($cell, isLast);
                        _m_utils.default.focusAndSelectElement(this, $focusedElement)
                    }
                    _focus($cell, disableFocus, skipFocusEvent) {
                        const $row = $cell && !$cell.hasClass(_const.ROW_CLASS) ? $cell.closest(`.${_const.ROW_CLASS}`) : $cell;
                        if ($row && (0, _m_keyboard_navigation_utils.isNotFocusedRow)($row)) {
                            return
                        }
                        const focusedView = this._focusedView;
                        const $focusViewElement = focusedView && focusedView.element();
                        let $focusElement;
                        this._isHiddenFocus = disableFocus;
                        const isRowFocus = (0, _m_keyboard_navigation_utils.isGroupRow)($row) || (0, _m_keyboard_navigation_utils.isGroupFooterRow)($row) || this.isRowFocusType();
                        if (isRowFocus) {
                            $focusElement = $row;
                            if (focusedView) {
                                this.setFocusedRowIndex(this._getRowIndex($row))
                            }
                        } else if (this._isCellElement($cell)) {
                            $focusElement = $cell;
                            this._updateFocusedCellPosition($cell)
                        }
                        if ($focusElement) {
                            if ($focusViewElement) {
                                $focusViewElement.find(".dx-row[tabindex], .dx-row > td[tabindex]").filter(((i, node) => _m_utils.default.isElementInCurrentGrid(this, (0, _renderer.default)(node)))).not($focusElement).removeClass(_const2.CELL_FOCUS_DISABLED_CLASS).removeClass(_const2.FOCUSED_CLASS).removeAttr("tabindex")
                            }
                            _events_engine.default.one($focusElement, "blur", (e => {
                                if (e.relatedTarget) {
                                    $focusElement.removeClass(_const2.CELL_FOCUS_DISABLED_CLASS).removeClass(_const2.FOCUSED_CLASS)
                                }
                            }));
                            if (!skipFocusEvent) {
                                this._applyTabIndexToElement($focusElement);
                                _events_engine.default.trigger($focusElement, "focus")
                            }
                            if (disableFocus) {
                                $focusElement.addClass(_const2.CELL_FOCUS_DISABLED_CLASS);
                                if (isRowFocus) {
                                    $cell.addClass(_const2.CELL_FOCUS_DISABLED_CLASS)
                                }
                            } else {
                                this._editorFactory.focus($focusElement)
                            }
                        }
                    }
                    _updateFocus(isRenderView) {
                        let skipFocusEvent = arguments.length > 1 && void 0 !== arguments[1] ? arguments[1] : false;
                        this._updateFocusTimeout = setTimeout((() => {
                            if (this._needFocusEditingCell()) {
                                this._editingController._focusEditingCell();
                                return
                            }
                            let $cell = this._getFocusedCell();
                            const isEditing = this._editingController.isEditing();
                            if (!this.getMasterDetailCell($cell) || this._isRowEditMode()) {
                                if (this._hasSkipRow($cell.parent())) {
                                    const direction = this._focusedCellPosition && this._focusedCellPosition.rowIndex > 0 ? "upArrow" : "downArrow";
                                    $cell = this._getNextCell(direction)
                                }
                                if ((0, _m_keyboard_navigation_utils.isElementDefined)($cell)) {
                                    if ($cell.is("td") || $cell.hasClass(this.addWidgetPrefix(_const2.EDIT_FORM_ITEM_CLASS))) {
                                        const isCommandCell = $cell.is(_const2.COMMAND_CELL_SELECTOR);
                                        const $focusedElementInsideCell = $cell.find(":focus");
                                        const isFocusedElementDefined = (0, _m_keyboard_navigation_utils.isElementDefined)($focusedElementInsideCell);
                                        const column = this._getColumnByCellElement($cell);
                                        if ((isRenderView || !isCommandCell) && this._editorFactory.focus()) {
                                            if (isCommandCell && isFocusedElementDefined) {
                                                _m_utils.default.focusAndSelectElement(this, $focusedElementInsideCell);
                                                return
                                            }!isFocusedElementDefined && this._focus($cell, false, skipFocusEvent)
                                        } else if (!isFocusedElementDefined && (this._isNeedFocus || this._isHiddenFocus)) {
                                            this._focus($cell, this._isHiddenFocus, skipFocusEvent)
                                        }
                                        if (isEditing && !(null !== column && void 0 !== column && column.showEditorAlways)) {
                                            this._focusInteractiveElement.bind(this)($cell)
                                        }
                                    } else {
                                        _events_engine.default.trigger($cell, "focus")
                                    }
                                }
                            }
                        }))
                    }
                    _needFocusEditingCell() {
                        const isCellEditMode = this._editingController.getEditMode() === _const.EDIT_MODE_CELL;
                        const isBatchEditMode = this._editingController.getEditMode() === _const.EDIT_MODE_BATCH;
                        const cellEditModeHasChanges = isCellEditMode && this._editingController.hasChanges();
                        const isNewRowBatchEditMode = isBatchEditMode && this._editingController.isNewRowInEditMode();
                        const $cell = this._getFocusedCell();
                        return (0 === $cell.children().length || $cell.find(_const.FOCUSABLE_ELEMENT_SELECTOR).length > 0) && (cellEditModeHasChanges || isNewRowBatchEditMode)
                    }
                    _updateFocusedCellPositionByTarget(target) {
                        var _this$_focusedCellPos3;
                        const elementType = this._getElementType(target);
                        if ("row" === elementType && (0, _type.isDefined)(null === (_this$_focusedCellPos3 = this._focusedCellPosition) || void 0 === _this$_focusedCellPos3 ? void 0 : _this$_focusedCellPos3.columnIndex)) {
                            const $row = (0, _renderer.default)(target);
                            this._focusedView && (0, _m_keyboard_navigation_utils.isGroupRow)($row) && this.setFocusedRowIndex(this._getRowIndex($row))
                        } else {
                            this._updateFocusedCellPosition(this._getCellElementFromTarget(target))
                        }
                    }
                    _focusCell($cell, isDisabled) {
                        if (this._isCellValid($cell)) {
                            this._focus($cell, isDisabled);
                            return true
                        }
                        return
                    }
                    _focusEditFormCell($cell) {
                        if ($cell.hasClass(_const2.MASTER_DETAIL_CELL_CLASS)) {
                            this._editorFactory.focus($cell, true)
                        }
                    }
                    _resetFocusedCell(preventScroll) {
                        var _this$_focusedView3;
                        const $cell = this._getFocusedCell();
                        (0, _m_keyboard_navigation_utils.isElementDefined)($cell) && $cell.removeAttr("tabindex").removeClass(_const2.CELL_FOCUS_DISABLED_CLASS);
                        this._isNeedFocus = false;
                        this._isNeedScroll = false;
                        this._focusedCellPosition = {};
                        clearTimeout(this._updateFocusTimeout);
                        null === (_this$_focusedView3 = this._focusedView) || void 0 === _this$_focusedView3 || _this$_focusedView3.renderFocusState({
                            preventScroll: preventScroll
                        })
                    }
                    restoreFocusableElement(rowIndex, $event) {
                        const that = this;
                        let args;
                        let $rowElement;
                        const isUpArrow = (0, _type.isDefined)(rowIndex);
                        const $rowsViewElement = this._rowsView.element();
                        const {
                            columnIndex: columnIndex
                        } = that._focusedCellPosition;
                        const rowIndexOffset = that._dataController.getRowIndexOffset();
                        rowIndex = isUpArrow ? rowIndex : this._rowsView.getTopVisibleItemIndex() + rowIndexOffset;
                        if (!isUpArrow) {
                            that._editorFactory.loseFocus();
                            that._applyTabIndexToElement($rowsViewElement);
                            _events_engine.default.trigger($rowsViewElement, "focus")
                        } else {
                            $rowElement = this._rowsView.getRow(rowIndex - rowIndexOffset);
                            args = that._fireFocusedRowChanging($event, $rowElement);
                            if (!args.cancel && args.rowIndexChanged) {
                                rowIndex = args.newRowIndex
                            }
                        }
                        if (!isUpArrow || !args.cancel) {
                            that.setFocusedCellPosition(rowIndex, columnIndex)
                        }
                        isUpArrow && that._updateFocus()
                    }
                    silentUpdateFocusedCellPosition(newFocusedCellPosition) {
                        this._focusedCellPosition = Object.assign({}, this._focusedCellPosition ?? {}, newFocusedCellPosition)
                    }
                    _getNewPositionByCode(cellPosition, elementType, code) {
                        let {
                            columnIndex: columnIndex
                        } = cellPosition;
                        let {
                            rowIndex: rowIndex
                        } = cellPosition;
                        let visibleColumnsCount;
                        if (void 0 === cellPosition.rowIndex && "next" === code) {
                            return {
                                columnIndex: 0,
                                rowIndex: 0
                            }
                        }
                        switch (code) {
                            case "nextInRow":
                            case "next":
                                visibleColumnsCount = this._getVisibleColumnCount();
                                if (columnIndex < visibleColumnsCount - 1 && "row" !== elementType && this._hasValidCellAfterPosition({
                                        columnIndex: columnIndex,
                                        rowIndex: rowIndex
                                    })) {
                                    columnIndex++
                                } else if (!this._isLastRow(rowIndex) && "next" === code) {
                                    columnIndex = 0;
                                    rowIndex++
                                }
                                break;
                            case "previousInRow":
                            case "previous":
                                if (columnIndex > 0 && "row" !== elementType && this._hasValidCellBeforePosition({
                                        columnIndex: columnIndex,
                                        rowIndex: rowIndex
                                    })) {
                                    columnIndex--
                                } else if (rowIndex > 0 && "previous" === code) {
                                    rowIndex--;
                                    visibleColumnsCount = this._getVisibleColumnCount();
                                    columnIndex = visibleColumnsCount - 1
                                }
                                break;
                            case "upArrow":
                                rowIndex = rowIndex > 0 ? rowIndex - 1 : rowIndex;
                                break;
                            case "downArrow":
                                rowIndex = !this._isLastRow(rowIndex) ? rowIndex + 1 : rowIndex
                        }
                        return {
                            columnIndex: columnIndex,
                            rowIndex: rowIndex
                        }
                    }
                    getRowIndex() {
                        return this._focusedCellPosition ? this._focusedCellPosition.rowIndex : -1
                    }
                    getColumnIndex() {
                        return this._focusedCellPosition ? this._focusedCellPosition.columnIndex : -1
                    }
                    getVisibleRowIndex() {
                        var _this$_focusedCellPos4;
                        const rowIndex = null === (_this$_focusedCellPos4 = this._focusedCellPosition) || void 0 === _this$_focusedCellPos4 ? void 0 : _this$_focusedCellPos4.rowIndex;
                        return !(0, _type.isDefined)(rowIndex) || rowIndex < 0 ? -1 : rowIndex - this._dataController.getRowIndexOffset()
                    }
                    getVisibleColumnIndex() {
                        var _this$_focusedCellPos5;
                        const columnIndex = null === (_this$_focusedCellPos5 = this._focusedCellPosition) || void 0 === _this$_focusedCellPos5 ? void 0 : _this$_focusedCellPos5.columnIndex;
                        return !(0, _type.isDefined)(columnIndex) ? -1 : columnIndex - this._columnsController.getColumnIndexOffset()
                    }
                    _isCellByPositionValid(cellPosition) {
                        const $cell = (0, _renderer.default)(this._getCell(cellPosition));
                        return this._isCellValid($cell)
                    }
                    _isLastRow(rowIndex) {
                        const dataController = this._dataController;
                        if (this._isVirtualRowRender()) {
                            return rowIndex >= dataController.getMaxRowIndex()
                        }
                        const lastVisibleIndex = Math.max(...dataController.items().map(((item, index) => false !== item.visible ? index : -1)));
                        return rowIndex === lastVisibleIndex
                    }
                    _isFirstValidCell(cellPosition) {
                        let isFirstValidCell = false;
                        if (0 === cellPosition.rowIndex && cellPosition.columnIndex >= 0) {
                            isFirstValidCell = isFirstValidCell || !this._hasValidCellBeforePosition(cellPosition)
                        }
                        return isFirstValidCell
                    }
                    _hasValidCellBeforePosition(cellPosition) {
                        let {
                            columnIndex: columnIndex
                        } = cellPosition;
                        let hasValidCells = false;
                        while (columnIndex > 0 && !hasValidCells) {
                            const checkingPosition = {
                                columnIndex: --columnIndex,
                                rowIndex: cellPosition.rowIndex
                            };
                            hasValidCells = this._isCellByPositionValid(checkingPosition)
                        }
                        return hasValidCells
                    }
                    _hasValidCellAfterPosition(cellPosition) {
                        let {
                            columnIndex: columnIndex
                        } = cellPosition;
                        let hasValidCells = false;
                        const visibleColumnCount = this._getVisibleColumnCount();
                        while (columnIndex < visibleColumnCount - 1 && !hasValidCells) {
                            const checkingPosition = {
                                columnIndex: ++columnIndex,
                                rowIndex: cellPosition.rowIndex
                            };
                            hasValidCells = this._isCellByPositionValid(checkingPosition)
                        }
                        return hasValidCells
                    }
                    _isLastValidCell(cellPosition) {
                        const nextColumnIndex = cellPosition.columnIndex >= 0 ? cellPosition.columnIndex + 1 : 0;
                        const {
                            rowIndex: rowIndex
                        } = cellPosition;
                        const checkingPosition = {
                            columnIndex: nextColumnIndex,
                            rowIndex: rowIndex
                        };
                        const visibleRows = this._dataController.getVisibleRows();
                        const row = visibleRows && visibleRows[rowIndex];
                        const isLastRow = this._isLastRow(rowIndex);
                        if (!isLastRow) {
                            return false
                        }
                        const isFullRowFocus = "group" === (null === row || void 0 === row ? void 0 : row.rowType) || "groupFooter" === (null === row || void 0 === row ? void 0 : row.rowType);
                        if (isFullRowFocus && cellPosition.columnIndex > 0) {
                            return true
                        }
                        if (cellPosition.columnIndex === this._getVisibleColumnCount() - 1) {
                            return true
                        }
                        if (this._isCellByPositionValid(checkingPosition)) {
                            return false
                        }
                        return this._isLastValidCell(checkingPosition)
                    }
                    _isCellValid($cell, isClick) {
                        if ((0, _m_keyboard_navigation_utils.isElementDefined)($cell)) {
                            const $row = $cell.parent();
                            const columnIndex = this._rowsView.getCellIndex($cell) + this._columnsController.getColumnIndexOffset();
                            const column = this._getColumnByCellElement($cell);
                            const visibleColumnCount = this._getVisibleColumnCount();
                            const editingController = this._editingController;
                            const isMasterDetailRow = (0, _m_keyboard_navigation_utils.isDetailRow)($row);
                            const isShowWhenGrouped = column && column.showWhenGrouped;
                            const isDataCell = column && !$cell.hasClass(_const2.COMMAND_EXPAND_CLASS) && (0, _m_keyboard_navigation_utils.isDataRow)($row);
                            const isValidGroupSpaceColumn = function() {
                                return !isMasterDetailRow && column && (!(0, _type.isDefined)(column.groupIndex) || isShowWhenGrouped && isDataCell) || parseInt($cell.attr("colspan"), 10) > 1
                            };
                            const isDragCell = _dom.GridCoreKeyboardNavigationDom.isDragCell($cell);
                            if (isDragCell) {
                                return false
                            }
                            if (this.getMasterDetailCell($cell)) {
                                return true
                            }
                            if (visibleColumnCount > columnIndex && isValidGroupSpaceColumn()) {
                                const rowItems = this._dataController.items();
                                const visibleRowIndex = this._rowsView.getRowIndex($row);
                                const row = rowItems[visibleRowIndex];
                                const isCellEditing = editingController && this._isCellEditMode() && editingController.isEditing();
                                const isRowEditingInCurrentRow = editingController && editingController.isEditRow(visibleRowIndex);
                                const isEditing = isRowEditingInCurrentRow || isCellEditing;
                                if (column.command) {
                                    if (this._isLegacyNavigation()) {
                                        return !isEditing && "expand" === column.command
                                    }
                                    if (isCellEditing) {
                                        return false
                                    }
                                    if (isRowEditingInCurrentRow) {
                                        return "select" !== column.command
                                    }
                                    return !isEditing
                                }
                                if (isCellEditing && row && "data" !== row.rowType) {
                                    return false
                                }
                                return !isEditing || column.allowEditing || isClick
                            }
                        }
                    }
                    getFirstValidCellInRow($row, columnIndex) {
                        const that = this;
                        const $cells = $row.find("> td");
                        let $cell;
                        let $result;
                        columnIndex = columnIndex || 0;
                        for (let i = columnIndex; i < $cells.length; ++i) {
                            $cell = $cells.eq(i);
                            if (that._isCellValid($cell)) {
                                $result = $cell;
                                break
                            }
                        }
                        return $result
                    }
                    _getNextCell(keyCode, elementType, cellPosition) {
                        const focusedCellPosition = cellPosition || this._focusedCellPosition;
                        const isRowFocusType = this.isRowFocusType();
                        const includeCommandCells = isRowFocusType || ["next", "previous"].includes(keyCode);
                        let $cell;
                        let $row;
                        if (this._focusedView && focusedCellPosition) {
                            const newFocusedCellPosition = this._getNewPositionByCode(focusedCellPosition, elementType, keyCode);
                            $cell = (0, _renderer.default)(this._getCell(newFocusedCellPosition));
                            const isLastCellOnDirection = "previous" === keyCode ? this._isFirstValidCell(newFocusedCellPosition) : this._isLastValidCell(newFocusedCellPosition);
                            if ((0, _m_keyboard_navigation_utils.isElementDefined)($cell) && !this._isCellValid($cell) && this._isCellInRow(newFocusedCellPosition, includeCommandCells) && !isLastCellOnDirection) {
                                if (isRowFocusType) {
                                    $cell = this.getFirstValidCellInRow($cell.parent(), newFocusedCellPosition.columnIndex)
                                } else {
                                    $cell = this._getNextCell(keyCode, "cell", newFocusedCellPosition)
                                }
                            }
                            $row = (0, _m_keyboard_navigation_utils.isElementDefined)($cell) && $cell.parent();
                            if (this._hasSkipRow($row)) {
                                const rowIndex = this._getRowIndex($row);
                                if (!this._isLastRow(rowIndex)) {
                                    $cell = this._getNextCell(keyCode, "row", {
                                        columnIndex: focusedCellPosition.columnIndex,
                                        rowIndex: rowIndex
                                    })
                                } else {
                                    return null
                                }
                            }
                            return (0, _m_keyboard_navigation_utils.isElementDefined)($cell) ? $cell : null
                        }
                        return null
                    }
                    _startEditing(eventArgs, fastEditingKey) {
                        const focusedCellPosition = this._focusedCellPosition;
                        const visibleRowIndex = this.getVisibleRowIndex();
                        const visibleColumnIndex = this.getVisibleColumnIndex();
                        const row = this._dataController.items()[visibleRowIndex];
                        const column = this._columnsController.getVisibleColumns()[visibleColumnIndex];
                        if (this._isAllowEditing(row, column)) {
                            if (this._isRowEditMode()) {
                                this._editingController.editRow(visibleRowIndex)
                            } else if (focusedCellPosition) {
                                this._startEditCell(eventArgs, fastEditingKey)
                            }
                        }
                    }
                    _isAllowEditing(row, column) {
                        return this._editingController.allowUpdating({
                            row: row
                        }) && column && column.allowEditing
                    }
                    _editFocusedCell() {
                        const rowIndex = this.getVisibleRowIndex();
                        const colIndex = this.getVisibleColumnIndex();
                        return this._editingController.editCell(rowIndex, colIndex)
                    }
                    _startEditCell(eventArgs, fastEditingKey) {
                        this._fastEditingStarted = (0, _type.isDefined)(fastEditingKey);
                        const editResult = this._editFocusedCell();
                        const isEditResultDeferred = (0, _type.isDeferred)(editResult);
                        const isFastEditingStarted = this._isFastEditingStarted();
                        if (!isFastEditingStarted || !isEditResultDeferred && !editResult) {
                            return
                        }
                        const editorValue = isEditResultDeferred && fastEditingKey === _const2.FAST_EDITING_DELETE_KEY ? "" : fastEditingKey;
                        const editResultDeferred = isEditResultDeferred ? editResult : (0, _deferred.Deferred)().resolve();
                        const waitTemplatesDeferred = this._rowsView.waitAsyncTemplates(true);
                        (0, _deferred.when)(editResultDeferred, waitTemplatesDeferred).done((() => {
                            this._editingCellHandler(eventArgs, editorValue)
                        }))
                    }
                    _editingCellHandler(eventArgs, editorValue) {
                        var _$inputElement$select;
                        const $input = this._getFocusedCell().find(_const2.INTERACTIVE_ELEMENTS_SELECTOR).eq(0);
                        const $inputElement = $input.get(0);
                        if (!$inputElement) {
                            return
                        }
                        const keyDownEvent = (0, _index.createEvent)(eventArgs, {
                            type: "keydown",
                            target: $inputElement
                        });
                        const keyPressEvent = (0, _index.createEvent)(eventArgs, {
                            type: "keypress",
                            target: $inputElement
                        });
                        const inputEvent = (0, _index.createEvent)(eventArgs, {
                            type: "input",
                            target: $inputElement
                        });
                        if (inputEvent.originalEvent) {
                            inputEvent.originalEvent = (0, _index.createEvent)(inputEvent.originalEvent, {
                                data: editorValue
                            })
                        }
                        null === (_$inputElement$select = $inputElement.select) || void 0 === _$inputElement$select || _$inputElement$select.call($inputElement);
                        _events_engine.default.trigger($input, keyDownEvent);
                        if (!keyDownEvent.isDefaultPrevented()) {
                            _events_engine.default.trigger($input, keyPressEvent);
                            if (!keyPressEvent.isDefaultPrevented()) {
                                const timeout = _browser.default.mozilla ? 25 : 0;
                                setTimeout((() => {
                                    const inputValue = this._getKeyPressInputValue($input, editorValue);
                                    $input.val(inputValue);
                                    const $widgetContainer = $input.closest(`.${_const2.WIDGET_CLASS}`);
                                    _events_engine.default.off($widgetContainer, "focusout");
                                    _events_engine.default.one($widgetContainer, "focusout", (() => {
                                        _events_engine.default.trigger($input, "change")
                                    }));
                                    _events_engine.default.trigger($input, inputEvent)
                                }), timeout)
                            }
                        }
                    }
                    _getKeyPressInputValue($input, editorValue) {
                        const inputCurrentValue = $input.val();
                        return "-" === editorValue && "-0" === inputCurrentValue ? "-0" : editorValue
                    }
                    _fireFocusChangingEvents($event, $cell, fireRowEvent, isHighlighted) {
                        let args = {};
                        const cellPosition = this._getCellPosition($cell) ?? {};
                        if (this.isCellFocusType()) {
                            args = this._fireFocusedCellChanging($event, $cell, isHighlighted);
                            if (!args.cancel) {
                                cellPosition.columnIndex = args.newColumnIndex;
                                cellPosition.rowIndex = args.newRowIndex;
                                isHighlighted = args.isHighlighted;
                                $cell = (0, _renderer.default)(this._getCell(cellPosition))
                            }
                        }
                        if (!args.cancel && fireRowEvent && $cell) {
                            args = this._fireFocusedRowChanging($event, $cell.parent());
                            if (!args.cancel) {
                                cellPosition.rowIndex = args.newRowIndex;
                                args.isHighlighted = isHighlighted
                            }
                        }
                        args.$newCellElement = (0, _renderer.default)(this._getCell(cellPosition));
                        if (!args.$newCellElement.length) {
                            args.$newCellElement = $cell
                        }
                        return args
                    }
                    _fireFocusedCellChanging($event, $cellElement, isHighlighted) {
                        const prevColumnIndex = this.option("focusedColumnIndex");
                        const prevRowIndex = this.option("focusedRowIndex");
                        const cellPosition = this._getCellPosition($cellElement);
                        const columnIndex = cellPosition ? cellPosition.columnIndex : -1;
                        const rowIndex = cellPosition ? cellPosition.rowIndex : -1;
                        const visibleRows = this._dataController.getVisibleRows();
                        const visibleColumns = this._columnsController.getVisibleColumns();
                        const args = {
                            cellElement: $cellElement,
                            prevColumnIndex: prevColumnIndex,
                            prevRowIndex: prevRowIndex,
                            newColumnIndex: columnIndex,
                            newRowIndex: rowIndex,
                            rows: visibleRows,
                            columns: visibleColumns,
                            event: $event,
                            isHighlighted: isHighlighted || false,
                            cancel: false
                        };
                        this._canceledCellPosition = null;
                        this.executeAction("onFocusedCellChanging", args);
                        if (args.newColumnIndex !== columnIndex || args.newRowIndex !== rowIndex) {
                            args.$newCellElement = (0, _renderer.default)(this._getCell({
                                columnIndex: args.newColumnIndex,
                                rowIndex: args.newRowIndex
                            }))
                        }
                        if (args.cancel) {
                            this._canceledCellPosition = {
                                rowIndex: rowIndex,
                                columnIndex: columnIndex
                            }
                        }
                        return args
                    }
                    _fireFocusedCellChanged($cell) {
                        const columnIndex = this._rowsView.getCellIndex($cell);
                        const rowOptions = null === $cell || void 0 === $cell ? void 0 : $cell.parent().data("options");
                        const focusedRowKey = null === rowOptions || void 0 === rowOptions ? void 0 : rowOptions.key;
                        this._memoFireFocusedCellChanged(focusedRowKey, columnIndex)
                    }
                    _memoFireFocusedCellChanged(rowKey, columnIndex) {
                        const $cell = this._getFocusedCell();
                        const $row = null === $cell || void 0 === $cell ? void 0 : $cell.parent();
                        const rowIndex = this.getRowIndex();
                        const localRowIndex = Math.min(this._getLocalRowIndex($row), this._dataController.items().length - 1);
                        const isEditingCell = this._editingController.isEditCell(localRowIndex, columnIndex);
                        if (isEditingCell) {
                            return
                        }
                        const row = this._dataController.items()[localRowIndex];
                        const column = this._columnsController.getVisibleColumns()[columnIndex];
                        this.executeAction("onFocusedCellChanged", {
                            cellElement: $cell ? (0, _element.getPublicElement)($cell) : void 0,
                            columnIndex: columnIndex,
                            rowIndex: rowIndex,
                            row: row,
                            column: column
                        })
                    }
                    _fireFocusedRowChanging(eventArgs, $newFocusedRow) {
                        const newRowIndex = this._getRowIndex($newFocusedRow);
                        const prevFocusedRowIndex = this.option("focusedRowIndex");
                        const loadingOperationTypes = this._dataController.loadingOperationTypes();
                        const args = {
                            rowElement: $newFocusedRow,
                            prevRowIndex: prevFocusedRowIndex,
                            newRowIndex: newRowIndex,
                            event: eventArgs,
                            rows: this._dataController.getVisibleRows(),
                            cancel: false
                        };
                        const loadingOperations = loadingOperationTypes.sorting || loadingOperationTypes.grouping || loadingOperationTypes.filtering || loadingOperationTypes.paging;
                        if (!this._dataController || this._dataController.isLoading() && loadingOperations) {
                            args.cancel = true;
                            return args
                        }
                        if (this.option("focusedRowEnabled")) {
                            this.executeAction("onFocusedRowChanging", args);
                            if (!args.cancel && args.newRowIndex !== newRowIndex) {
                                args.resetFocusedRow = args.newRowIndex < 0;
                                if (!args.resetFocusedRow) {
                                    this.setFocusedRowIndex(args.newRowIndex)
                                }
                                args.rowIndexChanged = true
                            }
                        }
                        return args
                    }
                    _fireFocusedRowChanged() {
                        var _this$_focusControlle;
                        const focusedRowEnabled = this.option("focusedRowEnabled");
                        const focusedRowKey = this.option("focusedRowKey");
                        const focusedRowIndex = null === (_this$_focusControlle = this._focusController) || void 0 === _this$_focusControlle ? void 0 : _this$_focusControlle.getFocusedRowIndexByKey(focusedRowKey);
                        if (!focusedRowEnabled || (0, _type.isDefined)(focusedRowKey) && focusedRowIndex < 0) {
                            return
                        }
                        this._memoFireFocusedRowChanged(focusedRowKey, focusedRowIndex)
                    }
                    _memoFireFocusedRowChanged(focusedRowKey, focusedRowIndex) {
                        const localRowIndex = focusedRowIndex - this._dataController.getRowIndexOffset();
                        this.executeAction("onFocusedRowChanged", {
                            rowElement: focusedRowIndex < 0 ? void 0 : this._rowsView.getRowElement(localRowIndex),
                            rowIndex: focusedRowIndex,
                            row: focusedRowIndex < 0 ? void 0 : this._dataController.getVisibleRows()[localRowIndex]
                        })
                    }
                    _isEventInCurrentGrid(event) {
                        return _m_utils.default.isElementInCurrentGrid(this, (0, _renderer.default)(event.target))
                    }
                    _isRowEditMode() {
                        const editMode = this._editingController.getEditMode();
                        return editMode === _const.EDIT_MODE_ROW || editMode === _const.EDIT_MODE_FORM
                    }
                    _isCellEditMode() {
                        const editMode = this._editingController.getEditMode();
                        return editMode === _const.EDIT_MODE_CELL || editMode === _const.EDIT_MODE_BATCH
                    }
                    _isFastEditingAllowed() {
                        return this._isCellEditMode() && this.option("keyboardNavigation.editOnKeyPress")
                    }
                    _applyTabIndexToElement($element) {
                        const tabIndex = this.option("tabIndex") ?? 0;
                        $element.attr("tabindex", tabIndex)
                    }
                    _getCell(cellPosition) {
                        if (this._focusedView && cellPosition) {
                            const rowIndexOffset = this._dataController.getRowIndexOffset();
                            const column = this._columnsController.getVisibleColumns(null, true)[cellPosition.columnIndex];
                            const columnIndexOffset = column && column.fixed ? this._getFixedColumnIndexOffset(column) : this._columnsController.getColumnIndexOffset();
                            const rowIndex = cellPosition.rowIndex >= 0 ? cellPosition.rowIndex - rowIndexOffset : -1;
                            const columnIndex = cellPosition.columnIndex >= 0 ? cellPosition.columnIndex - columnIndexOffset : -1;
                            return this._focusedView.getCell({
                                rowIndex: rowIndex,
                                columnIndex: columnIndex
                            })
                        }
                    }
                    _getRowIndex($row) {
                        let rowIndex = this._getLocalRowIndex($row);
                        if (rowIndex >= 0) {
                            rowIndex += this._dataController.getRowIndexOffset()
                        }
                        return rowIndex
                    }
                    _getLocalRowIndex($row) {
                        const rowIndex = this._rowsView.getRowIndex($row);
                        return rowIndex
                    }
                    getCellIndex($cell, rowIndex) {
                        return this._rowsView.getCellIndex($cell, rowIndex)
                    }
                    _hasSkipRow($row) {
                        const row = $row && $row.get(0);
                        return row && "none" === row.style.display
                    }
                    _allowEditingOnEnterKey() {
                        return "startEdit" === this.option("keyboardNavigation.enterKeyAction")
                    }
                    _isLegacyNavigation() {
                        return this.option("useLegacyKeyboardNavigation")
                    }
                    _getDirectionCodeByKey(key) {
                        let directionCode;
                        switch (key) {
                            case "upArrow":
                                directionCode = "prevRow";
                                break;
                            case "downArrow":
                                directionCode = "nextRow";
                                break;
                            case "leftArrow":
                                directionCode = this.option("rtlEnabled") ? "nextInRow" : "previousInRow";
                                break;
                            case "rightArrow":
                                directionCode = this.option("rtlEnabled") ? "previousInRow" : "nextInRow"
                        }
                        return directionCode
                    }
                    _isVirtualScrolling() {
                        const scrollingMode = this.option("scrolling.mode");
                        return "virtual" === scrollingMode || "infinite" === scrollingMode
                    }
                    _isVirtualRowRender() {
                        return this._isVirtualScrolling() || _m_utils.default.isVirtualRowRendering(this)
                    }
                    _scrollBy(left, top, rowIndex, $event) {
                        const that = this;
                        const scrollable = this._rowsView.getScrollable();
                        if (that._focusedCellPosition) {
                            const scrollHandler = function() {
                                scrollable.off("scroll", scrollHandler);
                                setTimeout(that.restoreFocusableElement.bind(that, rowIndex, $event))
                            };
                            scrollable.on("scroll", scrollHandler)
                        }
                        return scrollable.scrollBy({
                            left: left,
                            top: top
                        })
                    }
                    _isInsideEditForm(element) {
                        const $editForm = (0, _renderer.default)(element).closest(`.${this.addWidgetPrefix(_const.EDIT_FORM_CLASS)}`);
                        return $editForm.length && this.elementIsInsideGrid($editForm)
                    }
                    getMasterDetailCell(element) {
                        const $masterDetailCell = (0, _renderer.default)(element).closest(`.${_const2.MASTER_DETAIL_CELL_CLASS}`);
                        if ($masterDetailCell.length && this.elementIsInsideGrid($masterDetailCell)) {
                            return $masterDetailCell
                        }
                        return null
                    }
                    _processNextCellInMasterDetail($nextCell, _$cell) {
                        if (!this._isInsideEditForm($nextCell) && $nextCell) {
                            this._applyTabIndexToElement($nextCell)
                        }
                    }
                    _handleTabKeyOnMasterDetailCell(target, direction) {
                        if (this.getMasterDetailCell(target)) {
                            this._updateFocusedCellPosition((0, _renderer.default)(target), direction);
                            const $nextCell = this._getNextCell(direction, "row");
                            this._processNextCellInMasterDetail($nextCell, (0, _renderer.default)(target));
                            return true
                        }
                        return false
                    }
                    _getElementType(target) {
                        return (0, _renderer.default)(target).is("tr") ? "row" : "cell"
                    }
                    _isFastEditingStarted() {
                        return this._isFastEditingAllowed() && this._fastEditingStarted
                    }
                    _getVisibleColumnCount() {
                        return this._columnsController.getVisibleColumns(null, true).length
                    }
                    _isCellInRow(cellPosition, includeCommandCells) {
                        const {
                            columnIndex: columnIndex
                        } = cellPosition;
                        const visibleColumnsCount = this._getVisibleColumnCount();
                        return includeCommandCells ? columnIndex >= 0 && columnIndex <= visibleColumnsCount - 1 : columnIndex > 0 && columnIndex < visibleColumnsCount - 1
                    }
                    _isCellElement($element) {
                        return $element.length && "TD" === $element[0].tagName
                    }
                    _getCellElementFromTarget(target) {
                        const elementType = this._getElementType(target);
                        const $targetElement = (0, _renderer.default)(target);
                        let $cell;
                        if ("cell" === elementType) {
                            $cell = $targetElement.closest(`.${_const.ROW_CLASS} > td`)
                        } else {
                            $cell = $targetElement.children().not(`.${_const2.COMMAND_EXPAND_CLASS}`).first()
                        }
                        return $cell
                    }
                    _getRowsViewElement() {
                        var _this$_rowsView7;
                        return null === (_this$_rowsView7 = this._rowsView) || void 0 === _this$_rowsView7 ? void 0 : _this$_rowsView7.element()
                    }
                    _processCanceledEditCellPosition(rowIndex, columnIndex) {
                        if (this._canceledCellPosition) {
                            const isCanceled = this._canceledCellPosition.rowIndex === rowIndex && this._canceledCellPosition.columnIndex === columnIndex;
                            this._canceledCellPosition = null;
                            return isCanceled
                        }
                        return
                    }
                    updateFocusedRowIndex() {
                        const dataController = this._dataController;
                        const visibleRowIndex = this.getVisibleRowIndex();
                        const visibleItems = dataController.items();
                        const lastVisibleIndex = visibleItems.length ? visibleItems.length - 1 : -1;
                        const rowIndexOffset = dataController.getRowIndexOffset();
                        if (lastVisibleIndex >= 0 && visibleRowIndex > lastVisibleIndex) {
                            this.setFocusedRowIndex(lastVisibleIndex + rowIndexOffset)
                        }
                    }
                    needNavigationToCell() {
                        return this._needNavigationToCell
                    }
                    navigationToCellInProgress() {
                        return this.needToRestoreFocus || this.needNavigationToCell()
                    }
                }
                exports.KeyboardNavigationController = KeyboardNavigationController;
                exports.keyboardNavigationModule = {
                    defaultOptions: () => ({
                        useLegacyKeyboardNavigation: false,
                        keyboardNavigation: {
                            enabled: true,
                            enterKeyAction: "startEdit",
                            enterKeyDirection: "none",
                            editOnKeyPress: false
                        }
                    }),
                    controllers: {
                        keyboardNavigation: KeyboardNavigationController
                    },
                    extenders: {
                        views: {
                            rowsView: Base => class extends Base {
                                _rowClick(e) {
                                    const editRowIndex = this._editingController.getEditRowIndex();
                                    const isKeyboardEnabled = this._keyboardNavigationController.isKeyboardEnabled();
                                    if (editRowIndex === e.rowIndex) {
                                        this._keyboardNavigationController.setCellFocusType()
                                    }
                                    const needTriggerPointerEventHandler = ((0, _m_keyboard_navigation_utils.isMobile)() || !isKeyboardEnabled) && this.option("focusedRowEnabled");
                                    if (needTriggerPointerEventHandler) {
                                        this._triggerPointerDownEventHandler(e, !isKeyboardEnabled)
                                    }
                                    super._rowClick.apply(this, arguments)
                                }
                                _triggerPointerDownEventHandler(e, force) {
                                    const {
                                        originalEvent: originalEvent
                                    } = e.event;
                                    if (originalEvent) {
                                        const $cell = (0, _renderer.default)(originalEvent.target);
                                        const columnIndex = this.getCellIndex($cell);
                                        const column = this._columnsController.getVisibleColumns()[columnIndex];
                                        const row = this._dataController.items()[e.rowIndex];
                                        if (this._keyboardNavigationController._isAllowEditing(row, column) || force) {
                                            const eventArgs = (0, _index.createEvent)(originalEvent, {
                                                currentTarget: originalEvent.target
                                            });
                                            this._keyboardNavigationController._pointerEventHandler(eventArgs)
                                        }
                                    }
                                }
                                renderFocusState(params) {
                                    super.renderFocusState(params);
                                    if (this._keyboardNavigationController.navigationToCellInProgress()) {
                                        return
                                    }
                                    const {
                                        preventScroll: preventScroll,
                                        pageSizeChanged: pageSizeChanged
                                    } = params ?? {};
                                    const $rowsViewElement = this.element();
                                    if ($rowsViewElement && !(0, _m_selectors.focused)($rowsViewElement)) {
                                        $rowsViewElement.attr("tabindex", null)
                                    }
                                    pageSizeChanged && this._keyboardNavigationController.updateFocusedRowIndex();
                                    let rowIndex = this._keyboardNavigationController.getVisibleRowIndex();
                                    if (!(0, _type.isDefined)(rowIndex) || rowIndex < 0) {
                                        rowIndex = 0
                                    }
                                    const cellElements = this.getCellElements(rowIndex);
                                    if (this._keyboardNavigationController.isKeyboardEnabled() && null !== cellElements && void 0 !== cellElements && cellElements.length) {
                                        this.updateFocusElementTabIndex(cellElements, preventScroll)
                                    }
                                }
                                updateFocusElementTabIndex(cellElements, preventScroll) {
                                    const $row = cellElements.eq(0).parent();
                                    if ((0, _m_keyboard_navigation_utils.isGroupRow)($row)) {
                                        this._keyboardNavigationController._applyTabIndexToElement($row)
                                    } else {
                                        let columnIndex = this._keyboardNavigationController.getColumnIndex();
                                        if (!(0, _type.isDefined)(columnIndex) || columnIndex < 0) {
                                            columnIndex = 0
                                        }
                                        this._updateFocusedCellTabIndex(cellElements, columnIndex)
                                    }
                                }
                                _updateFocusedCellTabIndex(cellElements, columnIndex) {
                                    const keyboardController = this._keyboardNavigationController;
                                    const cellElementsLength = cellElements ? cellElements.length : -1;
                                    const updateCellTabIndex = function($cell) {
                                        const isMasterDetailCell = !!keyboardController.getMasterDetailCell($cell);
                                        const isValidCell = keyboardController._isCellValid($cell);
                                        if (!isMasterDetailCell && isValidCell && keyboardController._isCellElement($cell)) {
                                            keyboardController._applyTabIndexToElement($cell);
                                            keyboardController.setCellFocusType();
                                            return true
                                        }
                                        return
                                    };
                                    const $cell = _dom.GridCoreKeyboardNavigationDom.getCellToFocus(cellElements, columnIndex);
                                    if ($cell.length) {
                                        updateCellTabIndex($cell)
                                    } else {
                                        if (cellElementsLength <= columnIndex) {
                                            columnIndex = cellElementsLength - 1
                                        }
                                        for (let i = columnIndex; i < cellElementsLength; ++i) {
                                            if (updateCellTabIndex((0, _renderer.default)(cellElements[i]))) {
                                                break
                                            }
                                        }
                                    }
                                }
                                renderDelayedTemplates(change) {
                                    super.renderDelayedTemplates.apply(this, arguments);
                                    this.waitAsyncTemplates().done((() => {
                                        this._renderFocusByChange(change)
                                    }))
                                }
                                _renderFocusByChange(change) {
                                    const {
                                        operationTypes: operationTypes,
                                        repaintChangesOnly: repaintChangesOnly
                                    } = change ?? {};
                                    const {
                                        fullReload: fullReload,
                                        pageSize: pageSize
                                    } = operationTypes ?? {};
                                    if (!change || !repaintChangesOnly || fullReload || pageSize) {
                                        const preventScroll = (0, _m_keyboard_navigation_utils.shouldPreventScroll)(this);
                                        this.renderFocusState({
                                            preventScroll: preventScroll,
                                            pageSizeChanged: pageSize
                                        })
                                    }
                                }
                                _renderCore(change) {
                                    const deferred = super._renderCore.apply(this, arguments);
                                    this._renderFocusByChange(change);
                                    return deferred
                                }
                                _editCellPrepared($cell) {
                                    var _this$_keyboardNaviga;
                                    const editorInstance = this._getEditorInstance($cell);
                                    const isEditingNavigationMode = null === (_this$_keyboardNaviga = this._keyboardNavigationController) || void 0 === _this$_keyboardNaviga ? void 0 : _this$_keyboardNaviga._isFastEditingStarted();
                                    if (editorInstance && isEditingNavigationMode) {
                                        this._handleEditingNavigationMode(editorInstance)
                                    }
                                    super._editCellPrepared.apply(this, arguments)
                                }
                                _handleEditingNavigationMode(editorInstance) {
                                    ["downArrow", "upArrow"].forEach((keyName => {
                                        const originalKeyHandler = editorInstance._supportedKeys()[keyName];
                                        editorInstance.registerKeyHandler(keyName, (e => {
                                            const isDropDownOpened = "true" === editorInstance._input().attr("aria-expanded");
                                            if (isDropDownOpened) {
                                                return originalKeyHandler && originalKeyHandler.call(editorInstance, e)
                                            }
                                        }))
                                    }));
                                    editorInstance.registerKeyHandler("leftArrow", _common.noop);
                                    editorInstance.registerKeyHandler("rightArrow", _common.noop);
                                    const isDateBoxWithMask = editorInstance.NAME === _const2.DATEBOX_WIDGET_NAME && editorInstance.option("useMaskBehavior");
                                    if (isDateBoxWithMask) {
                                        editorInstance.registerKeyHandler("enter", _common.noop)
                                    }
                                }
                                _getEditorInstance($cell) {
                                    const $editor = $cell.find(".dx-texteditor").eq(0);
                                    return _m_utils.default.getWidgetInstance($editor)
                                }
                                _handleScroll(e) {
                                    super._handleScroll(e);
                                    if (this._keyboardNavigationController.needNavigationToCell()) {
                                        this._keyboardNavigationController.navigateToFirstOrLastCell(this._keyboardNavigationController.isQuickNavigationToFirstCell())
                                    }
                                }
                                init() {
                                    super.init();
                                    this._resizeController = this.getController("resizing")
                                }
                            }
                        },
                        controllers: {
                            editing: Base => class extends Base {
                                editCell(rowIndex, columnIndex) {
                                    if (this._keyboardNavigationController._processCanceledEditCellPosition(rowIndex, columnIndex)) {
                                        return false
                                    }
                                    const isCellEditing = super.editCell(rowIndex, columnIndex);
                                    if (isCellEditing) {
                                        this._keyboardNavigationController.setupFocusedView()
                                    }
                                    return isCellEditing
                                }
                                editRow(rowIndex) {
                                    const visibleColumnIndex = this._keyboardNavigationController.getVisibleColumnIndex();
                                    const column = this._columnsController.getVisibleColumns()[visibleColumnIndex];
                                    if (column && column.type || this.option("editing.mode") === _const.EDIT_MODE_FORM) {
                                        this._keyboardNavigationController._resetFocusedCell()
                                    }
                                    super.editRow(rowIndex);
                                    return
                                }
                                addRow(parentKey) {
                                    this._keyboardNavigationController.setupFocusedView();
                                    this._keyboardNavigationController.setCellFocusType();
                                    return super.addRow.apply(this, arguments)
                                }
                                getFocusedCellInRow(rowIndex) {
                                    let $cell = super.getFocusedCellInRow(rowIndex);
                                    const rowIndexOffset = this._dataController.getRowIndexOffset();
                                    const focusedRowIndex = this._keyboardNavigationController._focusedCellPosition.rowIndex - rowIndexOffset;
                                    if (this._keyboardNavigationController.isKeyboardEnabled() && focusedRowIndex === rowIndex) {
                                        const $focusedCell = this._keyboardNavigationController._getFocusedCell();
                                        if ((0, _m_keyboard_navigation_utils.isElementDefined)($focusedCell) && !$focusedCell.hasClass(_const2.COMMAND_EDIT_CLASS)) {
                                            $cell = $focusedCell
                                        }
                                    }
                                    return $cell
                                }
                                _processCanceledEditingCell() {
                                    this.closeEditCell().done((() => {
                                        this._keyboardNavigationController._updateFocus()
                                    }))
                                }
                                closeEditCell() {
                                    const keyboardNavigation = this._keyboardNavigationController;
                                    keyboardNavigation._fastEditingStarted = false;
                                    const result = super.closeEditCell.apply(this, arguments);
                                    const $focusedElement = this._getFocusedElement();
                                    const isFilterCell = !!$focusedElement.closest(`.${this.addWidgetPrefix(_const.FILTER_ROW_CLASS)}`).length;
                                    if (!isFilterCell) {
                                        keyboardNavigation._updateFocus()
                                    }
                                    return result
                                }
                                _getFocusedElement() {
                                    var _this$component$eleme, _this$component;
                                    const $element = (0, _renderer.default)(null === (_this$component$eleme = (_this$component = this.component).element) || void 0 === _this$component$eleme ? void 0 : _this$component$eleme.call(_this$component));
                                    const $focusedElement = $element.find(":focus");
                                    return $focusedElement
                                }
                                _delayedInputFocus() {
                                    this._keyboardNavigationController._isNeedScroll = true;
                                    super._delayedInputFocus.apply(this, arguments)
                                }
                                _isEditingStart() {
                                    const cancel = super._isEditingStart.apply(this, arguments);
                                    if (cancel && !this._keyboardNavigationController._isNeedFocus) {
                                        const $cell = this._keyboardNavigationController._getFocusedCell();
                                        this._keyboardNavigationController._focus($ce