/*!
 * DevExtreme (dx.viz.debug.js)
 * Version: 25.2.3
 * Build date: Mon Dec 15 2025
 *
 * Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
 */
"use strict";
(() => {
    var __webpack_modules__ = {
        57:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/macro_task_array/methods.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.macroTaskArrayMap = exports.macroTaskArrayForEach = exports.DEFAULT_STEPS_VALUE = exports.DEFAULT_MACRO_TASK_TIMEOUT = void 0;
                var _dispatcher = (e = __webpack_require__( /*! ./dispatcher */ 8710), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const DEFAULT_STEPS_VALUE = exports.DEFAULT_STEPS_VALUE = 100;
                const DEFAULT_MACRO_TASK_TIMEOUT = exports.DEFAULT_MACRO_TASK_TIMEOUT = 0;
                const macroTaskArrayForEach = async function(array, callback) {
                    let step = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : DEFAULT_STEPS_VALUE;
                    let macroTaskTimeoutMs = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : DEFAULT_MACRO_TASK_TIMEOUT;
                    const promises = [];
                    const batchesCount = Math.ceil(array.length / step);
                    for (let batchIdx = 0; batchIdx < batchesCount; batchIdx += 1) {
                        const scheduledTask = _dispatcher.default.schedule((() => {
                            const startIdx = batchIdx * step;
                            const maxIdx = startIdx + step;
                            for (let idx = startIdx; idx < maxIdx && void 0 !== array[idx]; idx += 1) {
                                callback(array[idx])
                            }
                        }), macroTaskTimeoutMs);
                        promises.push(scheduledTask)
                    }
                    await Promise.all(promises)
                };
                exports.macroTaskArrayForEach = macroTaskArrayForEach;
                exports.macroTaskArrayMap = async function(array, callback) {
                    let step = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : DEFAULT_STEPS_VALUE;
                    let macroTaskTimeoutMs = arguments.length > 3 && void 0 !== arguments[3] ? arguments[3] : DEFAULT_MACRO_TASK_TIMEOUT;
                    const result = [];
                    await macroTaskArrayForEach(array, (item => {
                        result.push(callback(item))
                    }), step, macroTaskTimeoutMs);
                    return result
                }
            },
        453:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/integration/knockout.js ***!
              \********************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _m_error = _interopRequireDefault(__webpack_require__( /*! ../core/utils/m_error */ 40818));
                var _m_version = __webpack_require__( /*! ../core/utils/m_version */ 5388);
                var _knockout = _interopRequireDefault(__webpack_require__( /*! knockout */ 78117));
                __webpack_require__( /*! ./knockout/component_registrator */ 3794);
                __webpack_require__( /*! ./knockout/event_registrator */ 55445);
                __webpack_require__( /*! ./knockout/components */ 19856);
                __webpack_require__( /*! ./knockout/validation */ 61287);
                __webpack_require__( /*! ./knockout/variable_wrapper_utils */ 83518);
                __webpack_require__( /*! ./knockout/clean_node */ 76858);
                __webpack_require__( /*! ./knockout/clean_node_old */ 23204);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                if (_knockout.default) {
                    if ((0, _m_version.compare)(_knockout.default.version, [2, 3]) < 0) {
                        throw _m_error.default.Error("E0013")
                    }
                }
            },
        480:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/layout.js ***!
              \***************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _utils = __webpack_require__( /*! ./utils */ 98013);
                const _min = Math.min;
                const _max = Math.max;
                const _round = Math.round;
                const horizontalAlignmentMap = {
                    left: 0,
                    center: 1,
                    right: 2
                };
                const verticalAlignmentMap = {
                    top: 0,
                    center: 1,
                    bottom: 2
                };
                const sideMap = {
                    horizontal: 0,
                    vertical: 1
                };
                const slicersMap = {};
                slicersMap[0] = function(a, b, size) {
                    return [a, _min(b, a + size)]
                };
                slicersMap[1] = function(a, b, size) {
                    return [_max(a, (a + b - size) / 2), _min(b, (a + b + size) / 2)]
                };
                slicersMap[2] = function(a, b, size) {
                    return [_max(a, b - size), b]
                };

                function pickValue(value, map, defaultValue) {
                    const val = (0, _utils.normalizeEnum)(value);
                    return val in map ? map[val] : defaultValue
                }

                function normalizeLayoutOptions(options) {
                    const side = pickValue(options.side, sideMap, 1);
                    const alignment = [pickValue(options.horizontalAlignment, horizontalAlignmentMap, 1), pickValue(options.verticalAlignment, verticalAlignmentMap, 0)];
                    return {
                        side: side,
                        primary: (primary = alignment[side], primary < 2 ? 0 : 2),
                        secondary: alignment[1 - side],
                        weak: options.weak,
                        priority: options.priority || 0,
                        header: options.header,
                        position: options.position
                    };
                    var primary
                }

                function getShrink(alignment, size) {
                    return (alignment > 0 ? -1 : 1) * size
                }

                function processForward(item, rect, minSize) {
                    const side = item.side;
                    const size = item.element.measure([rect[2] - rect[0], rect[3] - rect[1]]);
                    const minSide = "indside" === item.position ? 0 : minSize[side];
                    const isValid = size[side] < rect[2 + side] - rect[side] - minSide;
                    if (isValid) {
                        if ("inside" !== item.position) {
                            rect[item.primary + side] += getShrink(item.primary, size[side])
                        }
                        item.size = size
                    }
                    return isValid
                }

                function processRectBackward(item, rect, alignmentRect) {
                    const primarySide = item.side;
                    const secondarySide = (side = primarySide, 1 - side);
                    var side;
                    const itemRect = [];
                    const secondary = (alignment = item.secondary, a = alignmentRect[secondarySide], b = alignmentRect[2 + secondarySide], size = item.size[secondarySide], slicersMap[alignment](a, b, size));
                    var alignment, a, b, size;
                    itemRect[primarySide] = _round(itemRect[2 + primarySide] = rect[item.primary + primarySide] + ("inside" === item.position ? getShrink(item.primary, item.size[primarySide]) : 0));
                    itemRect[item.primary + primarySide] = _round(rect[item.primary + primarySide] - getShrink(item.primary, item.size[primarySide]));
                    if ("inside" !== item.position) {
                        rect[item.primary + primarySide] = itemRect[item.primary + primarySide]
                    }
                    itemRect[secondarySide] = _round(secondary[0]);
                    itemRect[2 + secondarySide] = _round(secondary[1]);
                    return itemRect
                }

                function processBackward(item, rect, alignmentRect, fitRect, size, targetRect) {
                    const itemRect = processRectBackward(item, rect, alignmentRect);
                    const itemFitRect = processRectBackward(item, fitRect, fitRect);
                    if (size[item.side] > 0) {
                        size[item.side] -= item.size[item.side];
                        targetRect[item.primary + item.side] = itemRect[item.primary + item.side];
                        item.element.freeSpace()
                    } else {
                        item.element.move(itemRect, itemFitRect)
                    }
                }

                function Layout() {
                    this._targets = []
                }
                Layout.prototype = {
                    constructor: Layout,
                    dispose() {
                        this._targets = null
                    },
                    add(target) {
                        this._targets.push(target)
                    },
                    forward(targetRect, minSize) {
                        const rect = targetRect.slice();
                        const targets = function(targets) {
                            let i;
                            const ii = targets.length;
                            let collection = [];
                            let layout;
                            for (i = 0; i < ii; ++i) {
                                layout = targets[i].layoutOptions();
                                if (layout) {
                                    layout = normalizeLayoutOptions(layout);
                                    layout.element = targets[i];
                                    collection.push(layout)
                                }
                            }
                            collection.sort(((a, b) => b.side - a.side || a.priority - b.priority));
                            collection = function(collection) {
                                const weakItem = collection.filter((item => true === item.weak))[0];
                                let headerItem;
                                if (weakItem) {
                                    headerItem = collection.filter((item => weakItem.primary === item.primary && item.side === weakItem.side && item !== weakItem))[0]
                                }
                                if (weakItem && headerItem) {
                                    return [makeHeader(headerItem, weakItem)].concat(collection.filter((item => !(item === headerItem || item === weakItem))))
                                }
                                return collection
                            }(collection);
                            return collection
                        }(this._targets);
                        let i;
                        const ii = targets.length;
                        const cache = [];
                        for (i = 0; i < ii; ++i) {
                            if (processForward(targets[i], rect, minSize)) {
                                cache.push(targets[i])
                            } else {
                                targets[i].element.freeSpace()
                            }
                        }
                        this._cache = cache.reverse();
                        return rect
                    },
                    backward(targetRect, alignmentRect) {
                        let size = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : [0, 0];
                        let backwardRect = targetRect.slice();
                        const fitRect = targetRect.slice();
                        const targets = this._cache;
                        let targetSide = 0;
                        let target;
                        let i;
                        const ii = targets.length;
                        for (i = 0; i < ii; ++i) {
                            target = targets[i];
                            if (target.side !== targetSide) {
                                backwardRect = targetRect.slice()
                            }
                            processBackward(target, backwardRect, alignmentRect, fitRect, size, targetRect);
                            targetSide = target.side
                        }
                        return size
                    }
                };

                function processBackwardHeaderRect(element, rect) {
                    const rectCopy = rect.slice();
                    const itemRect = processRectBackward(element, rectCopy, rectCopy);
                    itemRect[element.side] = rect[element.side];
                    itemRect[2 + element.side] = rect[2 + element.side];
                    return itemRect
                }

                function makeHeader(header, weakElement) {
                    const side = header.side;
                    const primary = header.primary;
                    const secondary = header.secondary;
                    return {
                        side: side,
                        primary: primary,
                        secondary: secondary,
                        priority: 0,
                        element: {
                            measure(targetSize) {
                                const result = targetSize.slice();
                                const weakSize = weakElement.element.measure(targetSize.slice());
                                targetSize[primary] -= weakSize[primary];
                                const headerSize = header.element.measure(targetSize.slice());
                                result[side] = weakSize[side] = headerSize[side] = Math.max(headerSize[side], weakSize[side]);
                                weakElement.size = weakSize;
                                header.size = headerSize;
                                return result
                            },
                            move(rect, fitRect) {
                                if (fitRect[2] - fitRect[0] < header.size[0] + weakElement.size[0] - 2) {
                                    this.freeSpace();
                                    return
                                }
                                const weakRect = processBackwardHeaderRect(weakElement, fitRect);
                                fitRect[2 + weakElement.primary] = weakRect[weakElement.primary];
                                const headerFitReact = processBackwardHeaderRect(header, fitRect);
                                if (fitRect[2 + weakElement.primary] < rect[2 + weakElement.primary] && header.size[header.primary] > rect[2 + header.primary] - rect[header.primary]) {
                                    rect[2 + weakElement.primary] = fitRect[2 + weakElement.primary]
                                }
                                let headerRect = processBackwardHeaderRect(header, rect);
                                if (headerRect[2 + weakElement.primary] > fitRect[2 + weakElement.primary]) {
                                    rect[2 + weakElement.primary] = fitRect[2 + weakElement.primary];
                                    headerRect = processBackwardHeaderRect(header, rect)
                                }
                                weakElement.element.move(weakRect);
                                header.element.move(headerRect, headerFitReact)
                            },
                            freeSpace() {
                                header.element.freeSpace();
                                weakElement.element.freeSpace()
                            }
                        }
                    }
                }
                exports.default = Layout
            },
        566:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/chart_components/crosshair.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Crosshair = Crosshair;
                exports.getMargins = function() {
                    return {
                        x: LABEL_BACKGROUND_PADDING_X,
                        y: LABEL_BACKGROUND_PADDING_Y
                    }
                };
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                const math = Math;
                const mathAbs = math.abs;
                const mathMin = math.min;
                const mathMax = math.max;
                const mathFloor = math.floor;
                const LABEL_BACKGROUND_PADDING_X = 8;
                const LABEL_BACKGROUND_PADDING_Y = 4;

                function getRectangleBBox(bBox) {
                    return {
                        x: bBox.x - LABEL_BACKGROUND_PADDING_X,
                        y: bBox.y - LABEL_BACKGROUND_PADDING_Y,
                        width: bBox.width + 2 * LABEL_BACKGROUND_PADDING_X,
                        height: bBox.height + 2 * LABEL_BACKGROUND_PADDING_Y
                    }
                }

                function getLabelCheckerPosition(x, y, isHorizontal, canvas) {
                    const params = isHorizontal ? ["x", "width", "y", "height", y, 0] : ["y", "height", "x", "width", x, 1];
                    return function(bBox, position, coord) {
                        const labelCoord = {
                            x: coord.x,
                            y: coord.y
                        };
                        const rectangleBBox = getRectangleBBox(bBox);
                        const delta = isHorizontal ? coord.y - bBox.y - bBox.height / 2 : coord.y - bBox.y;
                        labelCoord.y = isHorizontal || !isHorizontal && "bottom" === position ? coord.y + delta : coord.y;
                        if (rectangleBBox[params[0]] < 0) {
                            labelCoord[params[0]] -= rectangleBBox[params[0]]
                        } else if (rectangleBBox[params[0]] + rectangleBBox[params[1]] + delta * params[5] > canvas[params[1]]) {
                            labelCoord[params[0]] -= rectangleBBox[params[0]] + rectangleBBox[params[1]] + delta * params[5] - canvas[params[1]]
                        }
                        if (params[4] - rectangleBBox[params[3]] / 2 < 0) {
                            labelCoord[params[2]] -= params[4] - rectangleBBox[params[3]] / 2
                        } else if (params[4] + rectangleBBox[params[3]] / 2 > canvas[params[3]]) {
                            labelCoord[params[2]] -= params[4] + rectangleBBox[params[3]] / 2 - canvas[params[3]]
                        }
                        return labelCoord
                    }
                }

                function Crosshair(renderer, options, params, group) {
                    this._renderer = renderer;
                    this._crosshairGroup = group;
                    this._options = {};
                    this.update(options, params)
                }
                Crosshair.prototype = {
                    constructor: Crosshair,
                    update(options, params) {
                        const canvas = params.canvas;
                        this._canvas = {
                            top: canvas.top,
                            bottom: canvas.height - canvas.bottom,
                            left: canvas.left,
                            right: canvas.width - canvas.right,
                            width: canvas.width,
                            height: canvas.height
                        };
                        this._axes = params.axes;
                        this._panes = params.panes;
                        this._prepareOptions(options, "horizontal");
                        this._prepareOptions(options, "vertical")
                    },
                    dispose() {
                        this._renderer = this._crosshairGroup = this._options = this._axes = this._canvas = this._horizontalGroup = this._verticalGroup = this._horizontal = this._vertical = this._circle = this._panes = null
                    },
                    _prepareOptions(options, direction) {
                        const lineOptions = options[`${direction}Line`];
                        this._options[direction] = {
                            visible: lineOptions.visible,
                            line: {
                                stroke: lineOptions.color || options.color,
                                "stroke-width": lineOptions.width || options.width,
                                dashStyle: lineOptions.dashStyle || options.dashStyle,
                                opacity: lineOptions.opacity || options.opacity,
                                "stroke-linecap": "butt"
                            },
                            label: (0, _extend.extend)(true, {}, options.label, lineOptions.label)
                        }
                    },
                    _createLines(options, sharpParam, group) {
                        const lines = [];
                        const canvas = this._canvas;
                        const points = [canvas.left, canvas.top, canvas.left, canvas.top];
                        for (let i = 0; i < 2; i++) {
                            lines.push(this._renderer.path(points, "line").attr(options).sharp(sharpParam).append(group))
                        }
                        return lines
                    },
                    render() {
                        const that = this;
                        const renderer = that._renderer;
                        const options = that._options;
                        const verticalOptions = options.vertical;
                        const horizontalOptions = options.horizontal;
                        const extraOptions = horizontalOptions.visible ? horizontalOptions.line : verticalOptions.line;
                        const circleOptions = {
                            stroke: extraOptions.stroke,
                            "stroke-width": extraOptions["stroke-width"],
                            dashStyle: extraOptions.dashStyle,
                            opacity: extraOptions.opacity
                        };
                        const canvas = that._canvas;
                        that._horizontal = {};
                        that._vertical = {};
                        that._circle = renderer.circle(canvas.left, canvas.top, 0).attr(circleOptions).append(that._crosshairGroup);
                        that._horizontalGroup = renderer.g().append(that._crosshairGroup);
                        that._verticalGroup = renderer.g().append(that._crosshairGroup);
                        if (verticalOptions.visible) {
                            that._vertical.lines = that._createLines(verticalOptions.line, "h", that._verticalGroup);
                            that._vertical.labels = that._createLabels(that._axes[0], verticalOptions, false, that._verticalGroup)
                        }
                        if (horizontalOptions.visible) {
                            that._horizontal.lines = that._createLines(horizontalOptions.line, "v", that._horizontalGroup);
                            that._horizontal.labels = that._createLabels(that._axes[1], horizontalOptions, true, that._horizontalGroup)
                        }
                        that.hide()
                    },
                    _createLabels(axes, options, isHorizontal, group) {
                        const canvas = this._canvas;
                        const renderer = this._renderer;
                        let x;
                        let y;
                        let text;
                        const labels = [];
                        let background;
                        let currentLabelPos;
                        const labelOptions = options.label;
                        if (labelOptions.visible) {
                            axes.forEach((axis => {
                                const position = axis.getOptions().position;
                                if (axis.getTranslator().getBusinessRange().isEmpty()) {
                                    return
                                }
                                currentLabelPos = axis.getLabelsPosition();
                                if (isHorizontal) {
                                    y = canvas.top;
                                    x = currentLabelPos
                                } else {
                                    x = canvas.left;
                                    y = currentLabelPos
                                }
                                const align = "top" === position || "bottom" === position ? "center" : "right" === position ? "left" : "right";
                                background = renderer.rect(0, 0, 0, 0).attr({
                                    fill: labelOptions.backgroundColor || options.line.stroke
                                }).append(group);
                                text = renderer.text("0", 0, 0).css((0, _utils.patchFontOptions)(options.label.font)).attr({
                                    align: align,
                                    class: labelOptions.cssClass
                                }).append(group);
                                labels.push({
                                    text: text,
                                    background: background,
                                    axis: axis,
                                    options: labelOptions,
                                    pos: {
                                        coord: currentLabelPos,
                                        side: position
                                    },
                                    startXY: {
                                        x: x,
                                        y: y
                                    }
                                })
                            }))
                        }
                        return labels
                    },
                    _updateText(value, axisName, labels, point, func) {
                        const that = this;
                        labels.forEach((label => {
                            const axis = label.axis;
                            const coord = label.startXY;
                            const textElement = label.text;
                            const backgroundElement = label.background;
                            let text = "";
                            if (!axis.name || axis.name === axisName) {
                                text = axis.getFormattedValue(value, label.options, point)
                            }
                            if (text) {
                                textElement.attr({
                                    text: text,
                                    x: coord.x,
                                    y: coord.y
                                });
                                textElement.attr(func(textElement.getBBox(), label.pos.side, coord));
                                that._updateLinesCanvas(label);
                                backgroundElement.attr(getRectangleBBox(textElement.getBBox()))
                            } else {
                                textElement.attr({
                                    text: ""
                                });
                                backgroundElement.attr({
                                    x: 0,
                                    y: 0,
                                    width: 0,
                                    height: 0
                                })
                            }
                        }))
                    },
                    hide() {
                        this._crosshairGroup.attr({
                            visibility: "hidden"
                        })
                    },
                    _updateLinesCanvas(label) {
                        const position = label.pos.side;
                        const labelCoord = label.pos.coord;
                        const coords = this._linesCanvas;
                        const canvas = this._canvas;
                        coords[position] = coords[position] !== canvas[position] && mathAbs(coords[position] - canvas[position]) < mathAbs(labelCoord - canvas[position]) ? coords[position] : labelCoord
                    },
                    _updateLines(lines, x, y, r, isHorizontal) {
                        const coords = this._linesCanvas;
                        const canvas = this._canvas;
                        const points = isHorizontal ? [
                            [mathMin(x - r, coords.left), canvas.top, x - r, canvas.top],
                            [x + r, canvas.top, mathMax(coords.right, x + r), canvas.top]
                        ] : [
                            [canvas.left, mathMin(coords.top, y - r), canvas.left, y - r],
                            [canvas.left, y + r, canvas.left, mathMax(coords.bottom, y + r)]
                        ];
                        for (let i = 0; i < 2; i++) {
                            lines[i].attr({
                                points: points[i]
                            }).sharp(isHorizontal ? "v" : "h", isHorizontal ? y === canvas.bottom ? -1 : 1 : x === canvas.right ? -1 : 1)
                        }
                    },
                    _resetLinesCanvas() {
                        const canvas = this._canvas;
                        this._linesCanvas = {
                            left: canvas.left,
                            right: canvas.right,
                            top: canvas.top,
                            bottom: canvas.bottom
                        }
                    },
                    _getClipRectForPane(x, y) {
                        const panes = this._panes;
                        let i;
                        let coords;
                        for (i = 0; i < panes.length; i++) {
                            coords = panes[i].coords;
                            if (coords.left <= x && coords.right >= x && coords.top <= y && coords.bottom >= y) {
                                return panes[i].clipRect
                            }
                        }
                        return {
                            id: null
                        }
                    },
                    show(data) {
                        const that = this;
                        const point = data.point;
                        const pointData = point.getCrosshairData(data.x, data.y);
                        const r = point.getPointRadius();
                        const horizontal = that._horizontal;
                        const vertical = that._vertical;
                        const rad = !r ? 0 : r + 3;
                        const canvas = that._canvas;
                        const x = mathFloor(pointData.x);
                        const y = mathFloor(pointData.y);
                        if (x >= canvas.left && x <= canvas.right && y >= canvas.top && y <= canvas.bottom) {
                            that._crosshairGroup.attr({
                                visibility: "visible"
                            });
                            that._resetLinesCanvas();
                            that._circle.attr({
                                cx: x,
                                cy: y,
                                r: rad,
                                "clip-path": that._getClipRectForPane(x, y).id
                            });
                            if (horizontal.lines) {
                                that._updateText(pointData.yValue, pointData.axis, horizontal.labels, point, getLabelCheckerPosition(x, y, true, canvas));
                                that._updateLines(horizontal.lines, x, y, rad, true);
                                that._horizontalGroup.attr({
                                    translateY: y - canvas.top
                                })
                            }
                            if (vertical.lines) {
                                that._updateText(pointData.xValue, pointData.axis, vertical.labels, point, getLabelCheckerPosition(x, y, false, canvas));
                                that._updateLines(vertical.lines, x, y, rad, false);
                                that._verticalGroup.attr({
                                    translateX: x - canvas.left
                                })
                            }
                        } else {
                            that.hide()
                        }
                    }
                }
            },
        638:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/hover.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                var _m_hover = __webpack_require__( /*! ../../../__internal/events/m_hover */ 57798);
                Object.keys(_m_hover).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _m_hover[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _m_hover[key]
                        }
                    })
                }))
            },
        725:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/pointer/base.js ***!
              \********************************************************************************/
            (module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "default", {
                    enumerable: true,
                    get: function() {
                        return _m_base.default
                    }
                });
                var _m_base = (e = __webpack_require__( /*! ../../../../__internal/events/pointer/m_base */ 37321), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        869:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/localization/globalize/currency.js ***!
              \********************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                __webpack_require__( /*! ../../../../__internal/core/localization/globalize/currency */ 80811)
            },
        871:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_public_component.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.attachInstanceToElement = function($element, componentInstance, disposeFn) {
                    const data = (0, _element_data.data)($element.get(0));
                    const name = getName(componentInstance.constructor);
                    data[name] = componentInstance;
                    if (disposeFn) {
                        _events_engine.default.one($element, _remove.removeEvent, (function() {
                            disposeFn.call(componentInstance)
                        }))
                    }
                    if (!data[COMPONENT_NAMES_DATA_KEY]) {
                        data[COMPONENT_NAMES_DATA_KEY] = []
                    }
                    data[COMPONENT_NAMES_DATA_KEY].push(name)
                };
                exports.default = void 0;
                exports.getInstanceByElement = function($element, componentClass) {
                    const name = getName(componentClass);
                    return (0, _element_data.data)($element.get(0), name)
                };
                exports.name = void 0;
                var _events_engine = (e = __webpack_require__( /*! ../../../common/core/events/core/events_engine */ 92774), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _remove = __webpack_require__( /*! ../../../common/core/events/remove */ 28630);
                var _element_data = __webpack_require__( /*! ../../../core/element_data */ 74663);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                const COMPONENT_NAMES_DATA_KEY = "dxComponents";
                const componentNames = new WeakMap;
                let nextAnonymousComponent = 0;
                const getName = function(componentClass, newName) {
                    if ((0, _type.isDefined)(newName)) {
                        componentNames.set(componentClass, newName);
                        return
                    }
                    if (!componentNames.has(componentClass)) {
                        const generatedName = "dxPrivateComponent" + nextAnonymousComponent++;
                        componentNames.set(componentClass, generatedName);
                        return generatedName
                    }
                    return componentNames.get(componentClass)
                };
                exports.name = getName;
                exports.default = {
                    name: getName
                }
            },
        921:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/points/range_symbol_point.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var _label = __webpack_require__( /*! ../../../viz/series/points/label */ 95390);
                var _symbol_point = (e = __webpack_require__( /*! ../../../viz/series/points/symbol_point */ 8731), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const _extend = _extend2.extend;
                const _math = Math;
                const _abs = _math.abs;
                const _min = _math.min;
                const _max = _math.max;
                const _round = _math.round;
                exports.default = _extend({}, _symbol_point.default, {
                    deleteLabel() {
                        this._topLabel.dispose();
                        this._topLabel = null;
                        this._bottomLabel.dispose();
                        this._bottomLabel = null
                    },
                    hideMarker(type) {
                        const graphic = this.graphic;
                        const marker = graphic && graphic[`${type}Marker`];
                        const label = this[`_${type}Label`];
                        if (marker && "hidden" !== marker.attr("visibility")) {
                            marker.attr({
                                visibility: "hidden"
                            })
                        }
                        label.draw(false)
                    },
                    setInvisibility() {
                        this.hideMarker("top");
                        this.hideMarker("bottom")
                    },
                    clearVisibility() {
                        const graphic = this.graphic;
                        const topMarker = graphic && graphic.topMarker;
                        const bottomMarker = graphic && graphic.bottomMarker;
                        if (topMarker && topMarker.attr("visibility")) {
                            topMarker.attr({
                                visibility: null
                            })
                        }
                        if (bottomMarker && bottomMarker.attr("visibility")) {
                            bottomMarker.attr({
                                visibility: null
                            })
                        }
                    },
                    clearMarker() {
                        const graphic = this.graphic;
                        const topMarker = graphic && graphic.topMarker;
                        const bottomMarker = graphic && graphic.bottomMarker;
                        const emptySettings = this._emptySettings;
                        topMarker && topMarker.attr(emptySettings);
                        bottomMarker && bottomMarker.attr(emptySettings)
                    },
                    _getLabelPosition(markerType) {
                        let position;
                        const labelsInside = "inside" === this._options.label.position;
                        if (!this._options.rotated) {
                            position = "top" === markerType ^ labelsInside ? "top" : "bottom"
                        } else {
                            position = "top" === markerType ^ labelsInside ? "right" : "left"
                        }
                        return position
                    },
                    _getLabelMinFormatObject() {
                        return {
                            index: 0,
                            argument: this.initialArgument,
                            value: this.initialMinValue,
                            seriesName: this.series.name,
                            originalValue: this.originalMinValue,
                            originalArgument: this.originalArgument,
                            point: this
                        }
                    },
                    _updateLabelData() {
                        const maxFormatObject = this._getLabelFormatObject();
                        maxFormatObject.index = 1;
                        this._topLabel.setData(maxFormatObject);
                        this._bottomLabel.setData(this._getLabelMinFormatObject())
                    },
                    _updateLabelOptions() {
                        const options = this._options.label;
                        (!this._topLabel || !this._bottomLabel) && this._createLabel();
                        this._topLabel.setOptions(options);
                        this._bottomLabel.setOptions(options)
                    },
                    _createLabel() {
                        const options = {
                            renderer: this.series._renderer,
                            labelsGroup: this.series._labelsGroup,
                            point: this
                        };
                        this._topLabel = new _label.Label(options);
                        this._bottomLabel = new _label.Label(options)
                    },
                    _getGraphicBBox(location) {
                        const options = this._options;
                        const images = this._getImage(options.image);
                        const image = "top" === location ? this._checkImage(images.top) : this._checkImage(images.bottom);
                        let bBox;
                        const coord = this._getPositionFromLocation(location);
                        if (options.visible) {
                            bBox = image ? this._getImageBBox(coord.x, coord.y) : this._getSymbolBBox(coord.x, coord.y, options.styles.normal.r)
                        } else {
                            bBox = {
                                x: coord.x,
                                y: coord.y,
                                width: 0,
                                height: 0
                            }
                        }
                        return bBox
                    },
                    _getPositionFromLocation(location) {
                        let x;
                        let y;
                        const isTop = "top" === location;
                        if (!this._options.rotated) {
                            x = this.x;
                            y = isTop ? _min(this.y, this.minY) : _max(this.y, this.minY)
                        } else {
                            x = isTop ? _max(this.x, this.minX) : _min(this.x, this.minX);
                            y = this.y
                        }
                        return {
                            x: x,
                            y: y
                        }
                    },
                    _checkOverlay: (bottomCoord, topCoord, topValue) => bottomCoord < topCoord + topValue,
                    _getOverlayCorrections(topCoords, bottomCoords) {
                        const rotated = this._options.rotated;
                        const coordSelector = !rotated ? "y" : "x";
                        const valueSelector = !rotated ? "height" : "width";
                        const visibleArea = this.series.getValueAxis().getVisibleArea();
                        const minBound = visibleArea[0];
                        const maxBound = visibleArea[1];
                        let delta = _round((topCoords[coordSelector] + topCoords[valueSelector] - bottomCoords[coordSelector]) / 2);
                        let coord1 = topCoords[coordSelector] - delta;
                        let coord2 = bottomCoords[coordSelector] + delta;
                        if (coord1 < minBound) {
                            delta = minBound - coord1;
                            coord1 += delta;
                            coord2 += delta
                        } else if (coord2 + bottomCoords[valueSelector] > maxBound) {
                            delta = maxBound - coord2 - bottomCoords[valueSelector];
                            coord1 += delta;
                            coord2 += delta
                        }
                        return {
                            coord1: coord1,
                            coord2: coord2
                        }
                    },
                    _checkLabelsOverlay(topLocation) {
                        const that = this;
                        const topCoords = that._topLabel.getBoundingRect();
                        const bottomCoords = that._bottomLabel.getBoundingRect();
                        let corrections = {};
                        if (!that._options.rotated) {
                            if ("top" === topLocation) {
                                if (this._checkOverlay(bottomCoords.y, topCoords.y, topCoords.height)) {
                                    corrections = this._getOverlayCorrections(topCoords, bottomCoords);
                                    that._topLabel.shift(topCoords.x, corrections.coord1);
                                    that._bottomLabel.shift(bottomCoords.x, corrections.coord2)
                                }
                            } else if (this._checkOverlay(topCoords.y, bottomCoords.y, bottomCoords.height)) {
                                corrections = this._getOverlayCorrections(bottomCoords, topCoords);
                                that._topLabel.shift(topCoords.x, corrections.coord2);
                                that._bottomLabel.shift(bottomCoords.x, corrections.coord1)
                            }
                        } else if ("top" === topLocation) {
                            if (this._checkOverlay(topCoords.x, bottomCoords.x, bottomCoords.width)) {
                                corrections = this._getOverlayCorrections(bottomCoords, topCoords);
                                that._topLabel.shift(corrections.coord2, topCoords.y);
                                that._bottomLabel.shift(corrections.coord1, bottomCoords.y)
                            }
                        } else if (this._checkOverlay(bottomCoords.x, topCoords.x, topCoords.width)) {
                            corrections = this._getOverlayCorrections(topCoords, bottomCoords);
                            that._topLabel.shift(corrections.coord1, topCoords.y);
                            that._bottomLabel.shift(corrections.coord2, bottomCoords.y)
                        }
                    },
                    _drawLabel() {
                        const that = this;
                        const labels = [];
                        const notInverted = that._options.rotated ? that.x >= that.minX : that.y < that.minY;
                        const customVisibility = that._getCustomLabelVisibility();
                        const topLabel = that._topLabel;
                        const bottomLabel = that._bottomLabel;
                        topLabel.pointPosition = notInverted ? "top" : "bottom";
                        bottomLabel.pointPosition = notInverted ? "bottom" : "top";
                        if ((that.series.getLabelVisibility() || customVisibility) && that.hasValue() && false !== customVisibility) {
                            false !== that.visibleTopMarker && labels.push(topLabel);
                            false !== that.visibleBottomMarker && labels.push(bottomLabel);
                            (0, _iterator.each)(labels, ((_, label) => {
                                label.draw(true)
                            }));
                            that._checkLabelsOverlay(that._topLabel.pointPosition)
                        } else {
                            topLabel.draw(false);
                            bottomLabel.draw(false)
                        }
                    },
                    _getImage(imageOption) {
                        const image = {};
                        if ((0, _type.isDefined)(imageOption)) {
                            if ("string" === typeof imageOption) {
                                image.top = image.bottom = imageOption
                            } else {
                                image.top = {
                                    url: "string" === typeof imageOption.url ? imageOption.url : imageOption.url && imageOption.url.rangeMaxPoint,
                                    width: "number" === typeof imageOption.width ? imageOption.width : imageOption.width && imageOption.width.rangeMaxPoint,
                                    height: "number" === typeof imageOption.height ? imageOption.height : imageOption.height && imageOption.height.rangeMaxPoint
                                };
                                image.bottom = {
                                    url: "string" === typeof imageOption.url ? imageOption.url : imageOption.url && imageOption.url.rangeMinPoint,
                                    width: "number" === typeof imageOption.width ? imageOption.width : imageOption.width && imageOption.width.rangeMinPoint,
                                    height: "number" === typeof imageOption.height ? imageOption.height : imageOption.height && imageOption.height.rangeMinPoint
                                }
                            }
                        }
                        return image
                    },
                    _checkSymbol(oldOptions, newOptions) {
                        const oldSymbol = oldOptions.symbol;
                        const newSymbol = newOptions.symbol;
                        const symbolChanged = "circle" === oldSymbol && "circle" !== newSymbol || "circle" !== oldSymbol && "circle" === newSymbol;
                        const oldImages = this._getImage(oldOptions.image);
                        const newImages = this._getImage(newOptions.image);
                        const topImageChanged = this._checkImage(oldImages.top) !== this._checkImage(newImages.top);
                        const bottomImageChanged = this._checkImage(oldImages.bottom) !== this._checkImage(newImages.bottom);
                        return symbolChanged || topImageChanged || bottomImageChanged
                    },
                    _getSettingsForTwoMarkers(style) {
                        const options = this._options;
                        const settings = {};
                        const x = options.rotated ? _min(this.x, this.minX) : this.x;
                        const y = options.rotated ? this.y : _min(this.y, this.minY);
                        const radius = style.r;
                        const points = this._populatePointShape(options.symbol, radius);
                        settings.top = _extend({
                            translateX: x + this.width,
                            translateY: y,
                            r: radius
                        }, style);
                        settings.bottom = _extend({
                            translateX: x,
                            translateY: y + this.height,
                            r: radius
                        }, style);
                        if (points) {
                            settings.top.points = settings.bottom.points = points
                        }
                        return settings
                    },
                    _hasGraphic() {
                        return this.graphic && this.graphic.topMarker && this.graphic.bottomMarker
                    },
                    _drawOneMarker(renderer, markerType, imageSettings, settings) {
                        const that = this;
                        const graphic = that.graphic;
                        if (graphic[markerType]) {
                            that._updateOneMarker(markerType, settings)
                        } else {
                            graphic[markerType] = that._createMarker(renderer, graphic, imageSettings, settings)
                        }
                    },
                    _drawMarker(renderer, group, animationEnabled, firstDrawing, style) {
                        const that = this;
                        const settings = that._getSettingsForTwoMarkers(style || that._getStyle());
                        const image = that._getImage(that._options.image);
                        if (that._checkImage(image.top)) {
                            settings.top = that._getImageSettings(settings.top, image.top)
                        }
                        if (that._checkImage(image.bottom)) {
                            settings.bottom = that._getImageSettings(settings.bottom, image.bottom)
                        }
                        that.graphic = that.graphic || renderer.g().append(group);
                        that.visibleTopMarker && that._drawOneMarker(renderer, "topMarker", image.top, settings.top);
                        that.visibleBottomMarker && that._drawOneMarker(renderer, "bottomMarker", image.bottom, settings.bottom)
                    },
                    _getSettingsForTracker(radius) {
                        const rotated = this._options.rotated;
                        return {
                            translateX: rotated ? _min(this.x, this.minX) - radius : this.x - radius,
                            translateY: rotated ? this.y - radius : _min(this.y, this.minY) - radius,
                            width: this.width + 2 * radius,
                            height: this.height + 2 * radius
                        }
                    },
                    isInVisibleArea() {
                        const rotated = this._options.rotated;
                        const argument = !rotated ? this.x : this.y;
                        const maxValue = !rotated ? _max(this.minY, this.y) : _max(this.minX, this.x);
                        const minValue = !rotated ? _min(this.minY, this.y) : _min(this.minX, this.x);
                        let tmp;
                        let visibleTopMarker;
                        let visibleBottomMarker;
                        let visibleRangeArea = true;
                        const visibleArgArea = this.series.getArgumentAxis().getVisibleArea();
                        const visibleValArea = this.series.getValueAxis().getVisibleArea();
                        const notVisibleByArg = visibleArgArea[1] < argument || visibleArgArea[0] > argument;
                        const notVisibleByVal = visibleValArea[0] > minValue && visibleValArea[0] > maxValue || visibleValArea[1] < minValue && visibleValArea[1] < maxValue;
                        if (notVisibleByArg || notVisibleByVal) {
                            visibleTopMarker = visibleBottomMarker = visibleRangeArea = false
                        } else {
                            visibleTopMarker = visibleValArea[0] <= minValue && visibleValArea[1] > minValue;
                            visibleBottomMarker = visibleValArea[0] < maxValue && visibleValArea[1] >= maxValue;
                            if (rotated) {
                                tmp = visibleTopMarker;
                                visibleTopMarker = visibleBottomMarker;
                                visibleBottomMarker = tmp
                            }
                        }
                        this.visibleTopMarker = visibleTopMarker;
                        this.visibleBottomMarker = visibleBottomMarker;
                        return visibleRangeArea
                    },
                    getTooltipParams() {
                        const that = this;
                        let x;
                        let y;
                        const rotated = that._options.rotated;
                        const minValue = !rotated ? _min(that.y, that.minY) : _min(that.x, that.minX);
                        const side = !rotated ? "height" : "width";
                        const visibleArea = that._getVisibleArea();
                        const minVisible = rotated ? visibleArea.minX : visibleArea.minY;
                        const maxVisible = rotated ? visibleArea.maxX : visibleArea.maxY;
                        const min = _max(minVisible, minValue);
                        const max = _min(maxVisible, minValue + that[side]);
                        if (!rotated) {
                            x = that.x;
                            y = min + (max - min) / 2
                        } else {
                            y = that.y;
                            x = min + (max - min) / 2
                        }
                        return {
                            x: x,
                            y: y,
                            offset: 0
                        }
                    },
                    _translate() {
                        const rotated = this._options.rotated;
                        _symbol_point.default._translate.call(this);
                        this.height = rotated ? 0 : _abs(this.minY - this.y);
                        this.width = rotated ? _abs(this.x - this.minX) : 0
                    },
                    hasCoords() {
                        return _symbol_point.default.hasCoords.call(this) && !(null === this.minX || null === this.minY)
                    },
                    _updateData(data) {
                        _symbol_point.default._updateData.call(this, data);
                        this.minValue = this.initialMinValue = this.originalMinValue = data.minValue
                    },
                    _getImageSettings: (settings, image) => ({
                        href: image.url || image.toString(),
                        width: image.width || 20,
                        height: image.height || 20,
                        translateX: settings.translateX,
                        translateY: settings.translateY
                    }),
                    getCrosshairData(x, y) {
                        const rotated = this._options.rotated;
                        const minX = this.minX;
                        const minY = this.minY;
                        const vx = this.vx;
                        const vy = this.vy;
                        const value = this.value;
                        const minValue = this.minValue;
                        const argument = this.argument;
                        const coords = {
                            axis: this.series.axis,
                            x: vx,
                            y: vy,
                            yValue: value,
                            xValue: argument
                        };
                        if (rotated) {
                            coords.yValue = argument;
                            if (_abs(vx - x) < _abs(minX - x)) {
                                coords.xValue = value
                            } else {
                                coords.x = minX;
                                coords.xValue = minValue
                            }
                        } else if (_abs(vy - y) >= _abs(minY - y)) {
                            coords.y = minY;
                            coords.yValue = minValue
                        }
                        return coords
                    },
                    _updateOneMarker(markerType, settings) {
                        this.graphic && this.graphic[markerType] && this.graphic[markerType].attr(settings)
                    },
                    _updateMarker(animationEnabled, style) {
                        this._drawMarker(void 0, void 0, false, false, style)
                    },
                    _getFormatObject(tooltip) {
                        const initialMinValue = this.initialMinValue;
                        const initialValue = this.initialValue;
                        const initialArgument = this.initialArgument;
                        const minValue = tooltip.formatValue(initialMinValue);
                        const value = tooltip.formatValue(initialValue);
                        return {
                            argument: initialArgument,
                            argumentText: tooltip.formatValue(initialArgument, "argument"),
                            valueText: `${minValue} - ${value}`,
                            rangeValue1Text: minValue,
                            rangeValue2Text: value,
                            rangeValue1: initialMinValue,
                            rangeValue2: initialValue,
                            seriesName: this.series.name,
                            point: this,
                            originalMinValue: this.originalMinValue,
                            originalValue: this.originalValue,
                            originalArgument: this.originalArgument
                        }
                    },
                    getLabel() {
                        return [this._topLabel, this._bottomLabel]
                    },
                    getLabels() {
                        return [this._topLabel, this._bottomLabel]
                    },
                    getBoundingRect: _common.noop,
                    coordsIn(x, y) {
                        const trackerRadius = this._storeTrackerR();
                        const xCond = x >= this.x - trackerRadius && x <= this.x + trackerRadius;
                        const yCond = y >= this.y - trackerRadius && y <= this.y + trackerRadius;
                        if (this._options.rotated) {
                            return yCond && (xCond || x >= this.minX - trackerRadius && x <= this.minX + trackerRadius)
                        } else {
                            return xCond && (yCond || y >= this.minY - trackerRadius && y <= this.minY + trackerRadius)
                        }
                    },
                    getMaxValue() {
                        if ("discrete" !== this.series.valueAxisType) {
                            return this.minValue > this.value ? this.minValue : this.value
                        }
                        return this.value
                    },
                    getMinValue() {
                        if ("discrete" !== this.series.valueAxisType) {
                            return this.minValue < this.value ? this.minValue : this.value
                        }
                        return this.minValue
                    }
                })
            },
        1012:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/license/pkcs1.js ***!
              \******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.pad = function(hash) {
                    const dataLength = (8 * _key.PUBLIC_KEY.n.length + 6) / 8;
                    const data = (0, _byte_utils.concatBytes)((0, _byte_utils.hexToBytes)(ASN1_SHA1), hash);
                    if (data.length + 10 > dataLength) {
                        throw Error("Key is too short for SHA1 signing algorithm")
                    }
                    const padding = new Uint8Array(dataLength - data.length);
                    padding.fill(255, 0, padding.length - 1);
                    padding[0] = 0;
                    padding[1] = 1;
                    padding[padding.length - 1] = 0;
                    return (0, _byte_utils.concatBytes)(padding, data)
                };
                var _byte_utils = __webpack_require__( /*! ./byte_utils */ 22692);
                var _key = __webpack_require__( /*! ./key */ 78157);
                const ASN1_SHA1 = "3021300906052b0e03021a05000414"
            },
        1242:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/data/local_store.js ***!
              \*****************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _local_store = (e = __webpack_require__( /*! ../common/data/local_store */ 71790), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _local_store.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        1270:
            /*!****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/shallow_equals.js ***!
              \****************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.shallowEquals = void 0;
                exports.shallowEquals = (firstObject, secondObject) => {
                    if (Object.keys(firstObject).length !== Object.keys(secondObject).length) {
                        return false
                    }
                    return Object.entries(firstObject).every((_ref => {
                        let [key, firstValue] = _ref;
                        const secondValue = secondObject[key];
                        if (firstValue instanceof Date && secondValue instanceof Date) {
                            return firstValue.getTime() === secondValue.getTime()
                        }
                        return firstValue === secondValue
                    }))
                }
            },
        1522:
            /*!*************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/environment/init_mobile_viewport.js ***!
              \*************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.initMobileViewport = void 0;
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _m_devices = _interopRequireDefault(__webpack_require__( /*! ../../core/m_devices */ 98905));
                var _m_dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/m_dom_adapter */ 62018));
                var _m_extend = __webpack_require__( /*! ../../core/utils/m_extend */ 96298);
                var _m_resize_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_resize_callbacks */ 33717));
                var _m_size = __webpack_require__( /*! ../../core/utils/m_size */ 64587);
                var _m_style = __webpack_require__( /*! ../../core/utils/m_style */ 11953);
                var _m_support = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_support */ 85991));
                var _m_window = __webpack_require__( /*! ../../core/utils/m_window */ 14470);
                var _m_events_engine = _interopRequireDefault(__webpack_require__( /*! ../../events/core/m_events_engine */ 36306));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const window = (0, _m_window.getWindow)();
                exports.initMobileViewport = function(options) {
                    options = (0, _m_extend.extend)({}, options);
                    let realDevice = _m_devices.default.real();
                    const {
                        allowZoom: allowZoom
                    } = options;
                    const {
                        allowPan: allowPan
                    } = options;
                    const allowSelection = "allowSelection" in options ? options.allowSelection : "generic" === realDevice.platform;
                    if (!(0, _renderer.default)("meta[name=viewport]").length) {
                        (0, _renderer.default)("<meta>").attr("name", "viewport").appendTo("head")
                    }
                    const metaVerbs = ["width=device-width"];
                    const msTouchVerbs = [];
                    if (allowZoom) {
                        msTouchVerbs.push("pinch-zoom")
                    } else {
                        metaVerbs.push("initial-scale=1.0", "maximum-scale=1.0, user-scalable=no")
                    }
                    if (allowPan) {
                        msTouchVerbs.push("pan-x", "pan-y")
                    }
                    if (!allowPan && !allowZoom) {
                        (0, _renderer.default)("html, body").css({
                            msContentZooming: "none",
                            msUserSelect: "none",
                            overflow: "hidden"
                        })
                    } else {
                        (0, _renderer.default)("html").css("msOverflowStyle", "-ms-autohiding-scrollbar")
                    }
                    if (!allowSelection && _m_support.default.supportProp("userSelect")) {
                        (0, _renderer.default)(".dx-viewport").css((0, _m_style.styleProp)("userSelect"), "none")
                    }(0, _renderer.default)("meta[name=viewport]").attr("content", metaVerbs.join());
                    (0, _renderer.default)("html").css("msTouchAction", msTouchVerbs.join(" ") || "none");
                    realDevice = _m_devices.default.real();
                    if (_m_support.default.touch) {
                        _m_events_engine.default.off(_m_dom_adapter.default.getDocument(), ".dxInitMobileViewport");
                        _m_events_engine.default.on(_m_dom_adapter.default.getDocument(), "dxpointermove.dxInitMobileViewport", (e => {
                            const count = e.pointers.length;
                            const isTouchEvent = "touch" === e.pointerType;
                            const zoomDisabled = !allowZoom && count > 1;
                            const panDisabled = !allowPan && 1 === count && !e.isScrollingEvent;
                            if (isTouchEvent && (zoomDisabled || panDisabled)) {
                                e.preventDefault()
                            }
                        }))
                    }
                    if (realDevice.ios) {
                        const isPhoneGap = "file:" === _m_dom_adapter.default.getLocation().protocol;
                        if (!isPhoneGap) {
                            _m_resize_callbacks.default.add((() => {
                                const windowWidth = (0, _m_size.getWidth)(window);
                                (0, _m_size.setWidth)((0, _renderer.default)("body"), windowWidth)
                            }))
                        }
                    }
                    if (realDevice.android) {
                        _m_resize_callbacks.default.add((() => {
                            setTimeout((() => {
                                const activeElement = _m_dom_adapter.default.getActiveElement();
                                if (activeElement.scrollIntoViewIfNeeded) {
                                    activeElement.scrollIntoViewIfNeeded()
                                } else {
                                    activeElement.scrollIntoView(false)
                                }
                            }))
                        }))
                    }
                }
            },
        1747:
            /*!***********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/tree_map/tiling.squarified.base.js ***!
              \***********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = function(data, accumulate, isFixedStaticSide) {
                    const items = data.items;
                    const ii = items.length;
                    let i;
                    const context = {
                        sum: data.sum,
                        rect: data.rect,
                        directions: data.directions,
                        accumulate: accumulate
                    };
                    if (isFixedStaticSide) {
                        context.staticSideIndex = (0, _tiling.getStaticSideIndex)(context.rect)
                    }
                    items.sort(compare);
                    for (i = 0; i < ii;) {
                        i = doStep(items, i, context)
                    }
                };
                var _tiling = __webpack_require__( /*! ../../viz/tree_map/tiling */ 29355);
                const _max = Math.max;
                const _round = Math.round;

                function compare(a, b) {
                    return b.value - a.value
                }

                function doStep(nodes, head, context) {
                    const sidesData = (0, _tiling.buildSidesData)(context.rect, context.directions, context.staticSideIndex);
                    const area = (rect = context.rect, (rect[2] - rect[0]) * (rect[3] - rect[1]));
                    var rect;
                    const rowData = area > 0 ? function(nodes, head, context) {
                        let bestAspectRatio = 1 / 0;
                        let nextAspectRatio;
                        let sum = 0;
                        let nextSum;
                        let i;
                        let j;
                        const ii = nodes.length;
                        const coeff = context.areaToValue / context.staticSide;
                        let totalAspectRatio;
                        for (i = head; i < ii;) {
                            nextSum = sum + nodes[i].value;
                            totalAspectRatio = context.staticSide / coeff / nextSum;
                            nextAspectRatio = 0;
                            for (j = head; j <= i; ++j) {
                                nextAspectRatio = context.accumulate(nextAspectRatio, (value = totalAspectRatio * nodes[j].value / nextSum, _max(value, 1 / value)), j - head + 1)
                            }
                            if (nextAspectRatio < bestAspectRatio) {
                                bestAspectRatio = nextAspectRatio;
                                sum = nextSum;
                                ++i
                            } else {
                                break
                            }
                        }
                        var value;
                        return {
                            sum: sum,
                            count: i - head,
                            side: _round(coeff * sum)
                        }
                    }(nodes, head, {
                        areaToValue: area / context.sum,
                        accumulate: context.accumulate,
                        staticSide: sidesData.staticSide
                    }) : {
                        sum: 1,
                        side: sidesData.variedSide,
                        count: nodes.length - head
                    };
                    (0, _tiling.calculateRectangles)(nodes, head, context.rect, sidesData, rowData);
                    context.sum -= rowData.sum;
                    return head + rowData.count
                }
            },
        1773:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_abstract_store.js ***!
              \*********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _errors = __webpack_require__( /*! ../../common/data/errors */ 82812);
                var _store_helper = _interopRequireDefault(__webpack_require__( /*! ../../common/data/store_helper */ 66177));
                var _utils = __webpack_require__( /*! ../../common/data/utils */ 89358);
                var _class = _interopRequireDefault(__webpack_require__( /*! ../../core/class */ 55620));
                var _events_strategy = __webpack_require__( /*! ../../core/events_strategy */ 2607);
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const {
                    abstract: abstract
                } = _class.default;
                const {
                    queryByOptions: queryByOptions
                } = _store_helper.default;
                const storeImpl = {};
                const Store = _class.default.inherit({
                    _langParams: {},
                    ctor(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy = new _events_strategy.EventsStrategy(this);
                        (0, _iterator.each)(["onLoaded", "onLoading", "onInserted", "onInserting", "onUpdated", "onUpdating", "onPush", "onRemoved", "onRemoving", "onModified", "onModifying"], ((_, optionName) => {
                            if (optionName in options) {
                                that.on(optionName.slice(2).toLowerCase(), options[optionName])
                            }
                        }));
                        this._key = options.key;
                        this._errorHandler = options.errorHandler;
                        this._useDefaultSearch = true
                    },
                    _clearCache: _common.noop,
                    _customLoadOptions: () => null,
                    key() {
                        return this._key
                    },
                    keyOf(obj) {
                        if (!this._keyGetter) {
                            this._keyGetter = (0, _data.compileGetter)(this.key())
                        }
                        return this._keyGetter(obj)
                    },
                    _requireKey() {
                        if (!this.key()) {
                            throw _errors.errors.Error("E4005")
                        }
                    },
                    load(options) {
                        const that = this;
                        options = options || {};
                        this._eventsStrategy.fireEvent("loading", [options]);
                        return this._withLock(this._loadImpl(options)).done((result => {
                            that._eventsStrategy.fireEvent("loaded", [result, options])
                        }))
                    },
                    _loadImpl(options) {
                        if (!(0, _type.isEmptyObject)(this._langParams)) {
                            options = options || {};
                            options._langParams = Object.assign({}, this._langParams, options._langParams)
                        }
                        return queryByOptions(this.createQuery(options), options).enumerate()
                    },
                    _withLock(task) {
                        const result = new _deferred.Deferred;
                        task.done((function() {
                            const that = this;
                            const args = arguments;
                            _utils.processRequestResultLock.promise().done((() => {
                                result.resolveWith(that, args)
                            }))
                        })).fail((function() {
                            result.rejectWith(this, arguments)
                        }));
                        return result
                    },
                    createQuery: abstract,
                    totalCount(options) {
                        return this._totalCountImpl(options)
                    },
                    _totalCountImpl(options) {
                        return queryByOptions(this.createQuery(options), options, true).count()
                    },
                    byKey(key, extraOptions) {
                        return this._addFailHandlers(this._withLock(this._byKeyImpl(key, extraOptions)))
                    },
                    _byKeyImpl: abstract,
                    insert(values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("inserting", [values]);
                        return that._addFailHandlers(that._insertImpl(values).done(((callbackValues, callbackKey) => {
                            that._eventsStrategy.fireEvent("inserted", [callbackValues, callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _insertImpl: abstract,
                    update(key, values) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("updating", [key, values]);
                        return that._addFailHandlers(that._updateImpl(key, values).done((() => {
                            that._eventsStrategy.fireEvent("updated", [key, values]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _updateImpl: abstract,
                    push(changes) {
                        const beforePushArgs = {
                            changes: changes,
                            waitFor: []
                        };
                        this._eventsStrategy.fireEvent("beforePushAggregation", [beforePushArgs]);
                        (0, _deferred.when)(...beforePushArgs.waitFor).done((() => {
                            this._pushImpl(changes);
                            this._eventsStrategy.fireEvent("beforePush", [{
                                changes: changes
                            }]);
                            this._eventsStrategy.fireEvent("push", [changes])
                        }))
                    },
                    _pushImpl: _common.noop,
                    remove(key) {
                        const that = this;
                        that._eventsStrategy.fireEvent("modifying");
                        that._eventsStrategy.fireEvent("removing", [key]);
                        return that._addFailHandlers(that._removeImpl(key).done((callbackKey => {
                            that._eventsStrategy.fireEvent("removed", [callbackKey]);
                            that._eventsStrategy.fireEvent("modified")
                        })))
                    },
                    _removeImpl: abstract,
                    _addFailHandlers(deferred) {
                        return deferred.fail(this._errorHandler).fail(_errors.handleError)
                    },
                    on(eventName, eventHandler) {
                        this._eventsStrategy.on(eventName, eventHandler);
                        return this
                    },
                    off(eventName, eventHandler) {
                        this._eventsStrategy.off(eventName, eventHandler);
                        return this
                    }
                });
                Store.create = function(alias, options) {
                    if (!(alias in storeImpl)) {
                        throw _errors.errors.Error("E4020", alias)
                    }
                    return new storeImpl[alias](options)
                };
                Store.registerClass = function(type, alias) {
                    if (alias) {
                        storeImpl[alias] = type
                    }
                    return type
                };
                Store.inherit = (inheritor = Store.inherit, function(members, alias) {
                    const type = inheritor.apply(this, [members]);
                    Store.registerClass(type, alias);
                    return type
                });
                var inheritor;
                exports.default = Store
            },
        1811:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_renderer_base.js ***!
              \********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _dom_adapter = (e = __webpack_require__( /*! ../../core/dom_adapter */ 64960), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _element_data = __webpack_require__( /*! ../../core/element_data */ 74663);
                var _html_parser = __webpack_require__( /*! ../../core/utils/html_parser */ 23563);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _style = __webpack_require__( /*! ../../core/utils/style */ 58515);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                const window = (0, _window.getWindow)();
                let renderer;
                const initRender = function(selector, context) {
                    if (!selector) {
                        this.length = 0;
                        return this
                    }
                    if ("string" === typeof selector) {
                        if ("body" === selector) {
                            this[0] = context ? context.body : _dom_adapter.default.getBody();
                            this.length = 1;
                            return this
                        }
                        context = context || _dom_adapter.default.getDocument();
                        if (selector.startsWith("<")) {
                            this[0] = _dom_adapter.default.createElement(selector.slice(1, -1), context);
                            this.length = 1;
                            return this
                        } [].push.apply(this, _dom_adapter.default.querySelectorAll(context, selector));
                        return this
                    }
                    if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                        this[0] = selector;
                        this.length = 1;
                        return this
                    }
                    if (Array.isArray(selector)) {
                        [].push.apply(this, selector);
                        return this
                    }
                    return renderer(selector.toArray ? selector.toArray() : [selector])
                };
                renderer = function(selector, context) {
                    return new initRender(selector, context)
                };
                renderer.fn = {
                    dxRenderer: true
                };
                initRender.prototype = renderer.fn;
                const repeatMethod = function(methodName, args) {
                    for (let i = 0; i < this.length; i++) {
                        const item = renderer(this[i]);
                        item[methodName].apply(item, args)
                    }
                    return this
                };
                const setAttributeValue = function(element, attrName, value) {
                    if (void 0 !== value && null !== value && false !== value) {
                        _dom_adapter.default.setAttribute(element, attrName, value)
                    } else {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }
                };
                initRender.prototype.show = function() {
                    return this.toggle(true)
                };
                initRender.prototype.hide = function() {
                    return this.toggle(false)
                };
                initRender.prototype.toggle = function(value) {
                    if (this[0]) {
                        this.toggleClass("dx-state-invisible", !value)
                    }
                    return this
                };
                initRender.prototype.attr = function(attrName, value) {
                    if (this.length > 1 && arguments.length > 1) {
                        return repeatMethod.call(this, "attr", arguments)
                    }
                    if (!this[0]) {
                        if ((0, _type.isObject)(attrName) || void 0 !== value) {
                            return this
                        }
                        return
                    }
                    if (!this[0].getAttribute) {
                        return this.prop(attrName, value)
                    }
                    if ("string" === typeof attrName && 1 === arguments.length) {
                        const result = this[0].getAttribute(attrName);
                        return null == result ? void 0 : result
                    }
                    if ((0, _type.isPlainObject)(attrName)) {
                        for (const key in attrName) {
                            this.attr(key, attrName[key])
                        }
                    } else {
                        setAttributeValue(this[0], attrName, value)
                    }
                    return this
                };
                initRender.prototype.removeAttr = function(attrName) {
                    this.each((function(_, element) {
                        _dom_adapter.default.removeAttribute(element, attrName)
                    }));
                    return this
                };
                initRender.prototype.prop = function(propName, value) {
                    if (!this[0]) {
                        return this
                    }
                    if ("string" === typeof propName && 1 === arguments.length) {
                        return this[0][propName]
                    }
                    if ((0, _type.isPlainObject)(propName)) {
                        for (const key in propName) {
                            this.prop(key, propName[key])
                        }
                    } else {
                        _dom_adapter.default.setProperty(this[0], propName, value)
                    }
                    return this
                };
                initRender.prototype.addClass = function(className) {
                    return this.toggleClass(className, true)
                };
                initRender.prototype.removeClass = function(className) {
                    return this.toggleClass(className, false)
                };
                initRender.prototype.hasClass = function(className) {
                    const classNames = className.split(" ");
                    for (let i = 0; i < this.length; i++) {
                        if (!this[i] || !this[i].className) {
                            continue
                        }
                        for (let j = 0; j < classNames.length; j++) {
                            if (this[i].classList.contains(classNames[j])) {
                                return true
                            }
                        }
                    }
                    return false
                };
                initRender.prototype.toggleClass = function(className, value) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "toggleClass", arguments)
                    }
                    if (!this[0] || !className) {
                        return this
                    }
                    value = void 0 === value ? !this.hasClass(className) : value;
                    const classNames = className.split(" ");
                    for (let i = 0; i < classNames.length; i++) {
                        _dom_adapter.default.setClass(this[0], classNames[i], value)
                    }
                    return this
                };
                initRender.prototype.html = function(value) {
                    if (!arguments.length) {
                        return this[0].innerHTML
                    }
                    this.empty();
                    if ("string" === typeof value && !(0, _html_parser.isTablePart)(value) || "number" === typeof value) {
                        this[0].innerHTML = value;
                        return this
                    }
                    return this.append((0, _html_parser.parseHTML)(value))
                };
                const appendElements = function(element, nextSibling) {
                    if (!this[0] || !element) {
                        return
                    }
                    if ("string" === typeof element) {
                        element = (0, _html_parser.parseHTML)(element)
                    } else if (element.nodeType) {
                        element = [element]
                    } else if ((0, _type.isNumeric)(element)) {
                        element = [_dom_adapter.default.createTextNode(element)]
                    }
                    for (let i = 0; i < element.length; i++) {
                        const item = element[i];
                        let container = this[0];
                        const wrapTR = "TABLE" === container.tagName && "TR" === item.tagName;
                        if (wrapTR && container.tBodies && container.tBodies.length) {
                            container = container.tBodies[0]
                        }
                        _dom_adapter.default.insertElement(container, item.nodeType ? item : item[0], nextSibling)
                    }
                };
                const setCss = function(name, value) {
                    if (!this[0] || !this[0].style) {
                        return
                    }
                    if (null === value || "number" === typeof value && isNaN(value)) {
                        return
                    }
                    name = (0, _style.styleProp)(name);
                    for (let i = 0; i < this.length; i++) {
                        this[i].style[name] = (0, _style.normalizeStyleProp)(name, value)
                    }
                };
                initRender.prototype.css = function(name, value) {
                    if ((0, _type.isString)(name)) {
                        if (2 === arguments.length) {
                            setCss.call(this, name, value)
                        } else {
                            if (!this[0]) {
                                return
                            }
                            name = (0, _style.styleProp)(name);
                            const result = window.getComputedStyle(this[0])[name] || this[0].style[name];
                            return (0, _type.isNumeric)(result) ? result.toString() : result
                        }
                    } else if ((0, _type.isPlainObject)(name)) {
                        for (const key in name) {
                            setCss.call(this, key, name[key])
                        }
                    }
                    return this
                };
                initRender.prototype.prepend = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.prepend(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element, this[0].firstChild]);
                    return this
                };
                initRender.prototype.append = function(element) {
                    if (arguments.length > 1) {
                        for (let i = 0; i < arguments.length; i++) {
                            this.append(arguments[i])
                        }
                        return this
                    }
                    appendElements.apply(this, [element]);
                    return this
                };
                initRender.prototype.prependTo = function(element) {
                    if (this.length > 1) {
                        for (let i = this.length - 1; i >= 0; i--) {
                            renderer(this[i]).prependTo(element)
                        }
                        return this
                    }
                    element = renderer(element);
                    if (element[0]) {
                        _dom_adapter.default.insertElement(element[0], this[0], element[0].firstChild)
                    }
                    return this
                };
                initRender.prototype.appendTo = function(element) {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "appendTo", arguments)
                    }
                    _dom_adapter.default.insertElement(renderer(element)[0], this[0]);
                    return this
                };
                initRender.prototype.insertBefore = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0])
                    }
                    return this
                };
                initRender.prototype.insertAfter = function(element) {
                    if (element && element[0]) {
                        _dom_adapter.default.insertElement(element[0].parentNode, this[0], element[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.before = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0])
                    }
                    return this
                };
                initRender.prototype.after = function(element) {
                    if (this[0]) {
                        _dom_adapter.default.insertElement(this[0].parentNode, element[0], this[0].nextSibling)
                    }
                    return this
                };
                initRender.prototype.wrap = function(wrapper) {
                    if (this[0]) {
                        const wrap = renderer(wrapper);
                        wrap.insertBefore(this);
                        wrap.append(this)
                    }
                    return this
                };
                initRender.prototype.wrapInner = function(wrapper) {
                    const contents = this.contents();
                    if (contents.length) {
                        contents.wrap(wrapper)
                    } else {
                        this.append(wrapper)
                    }
                    return this
                };
                initRender.prototype.replaceWith = function(element) {
                    if (!(element && element[0])) {
                        return
                    }
                    if (element.is(this)) {
                        return this
                    }
                    element.insertBefore(this);
                    this.remove();
                    return element
                };
                initRender.prototype.remove = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "remove", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0], true);
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.detach = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "detach", arguments)
                    }
                    _dom_adapter.default.removeElement(this[0]);
                    return this
                };
                initRender.prototype.empty = function() {
                    if (this.length > 1) {
                        return repeatMethod.call(this, "empty", arguments)
                    }(0, _element_data.cleanDataRecursive)(this[0]);
                    _dom_adapter.default.setText(this[0], "");
                    return this
                };
                initRender.prototype.clone = function() {
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        result.push(this[i].cloneNode(true))
                    }
                    return renderer(result)
                };
                initRender.prototype.text = function(value) {
                    if (!arguments.length) {
                        let result = "";
                        for (let i = 0; i < this.length; i++) {
                            result += this[i] && this[i].textContent || ""
                        }
                        return result
                    }
                    const text = (0, _type.isFunction)(value) ? value() : value;
                    (0, _element_data.cleanDataRecursive)(this[0], false);
                    _dom_adapter.default.setText(this[0], (0, _type.isDefined)(text) ? text : "");
                    return this
                };
                initRender.prototype.val = function(value) {
                    if (1 === arguments.length) {
                        return this.prop("value", (0, _type.isDefined)(value) ? value : "")
                    }
                    return this.prop("value")
                };
                initRender.prototype.contents = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = [];
                    result.push.apply(result, this[0].childNodes);
                    return renderer(result)
                };
                initRender.prototype.find = function(selector) {
                    const result = renderer();
                    if (!selector) {
                        return result
                    }
                    const nodes = [];
                    let i;
                    if ("string" === typeof selector) {
                        selector = selector.trim();
                        for (i = 0; i < this.length; i++) {
                            const element = this[i];
                            if (_dom_adapter.default.isElementNode(element)) {
                                const elementId = element.getAttribute("id");
                                let queryId = elementId || "dx-query-children";
                                if (!elementId) {
                                    setAttributeValue(element, "id", queryId)
                                }
                                queryId = `[id='${queryId}'] `;
                                const querySelector = queryId + selector.replace(/([^\\])(,)/g, `$1, ${queryId}`);
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, querySelector));
                                setAttributeValue(element, "id", elementId)
                            } else if (_dom_adapter.default.isDocument(element) || _dom_adapter.default.isDocumentFragment(element)) {
                                nodes.push.apply(nodes, _dom_adapter.default.querySelectorAll(element, selector))
                            }
                        }
                    } else {
                        for (i = 0; i < this.length; i++) {
                            selector = _dom_adapter.default.isNode(selector) ? selector : selector[0];
                            if (this[i] !== selector && this[i].contains(selector)) {
                                nodes.push(selector)
                            }
                        }
                    }
                    return result.add(nodes)
                };
                const isVisible = function(_, element) {
                    var _element$getClientRec, _element;
                    element = element.host ?? element;
                    if (!element.nodeType) {
                        return true
                    }
                    return !!(element.offsetWidth || element.offsetHeight || null !== (_element$getClientRec = (_element = element).getClientRects) && void 0 !== _element$getClientRec && _element$getClientRec.call(_element).length)
                };
                initRender.prototype.filter = function(selector) {
                    if (!selector) {
                        return renderer()
                    }
                    if (":visible" === selector) {
                        return this.filter(isVisible)
                    }
                    if (":hidden" === selector) {
                        return this.filter((function(_, element) {
                            return !isVisible(0, element)
                        }))
                    }
                    const result = [];
                    for (let i = 0; i < this.length; i++) {
                        const item = this[i];
                        if (_dom_adapter.default.isElementNode(item) && "string" === (0, _type.type)(selector)) {
                            _dom_adapter.default.elementMatches(item, selector) && result.push(item)
                        } else if (_dom_adapter.default.isNode(selector) || (0, _type.isWindow)(selector)) {
                            selector === item && result.push(item)
                        } else if ((0, _type.isFunction)(selector)) {
                            selector.call(item, i, item) && result.push(item)
                        } else {
                            for (let j = 0; j < selector.length; j++) {
                                selector[j] === item && result.push(item)
                            }
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.not = function(selector) {
                    const result = [];
                    const nodes = this.filter(selector).toArray();
                    for (let i = 0; i < this.length; i++) {
                        if (-1 === nodes.indexOf(this[i])) {
                            result.push(this[i])
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.is = function(selector) {
                    return !!this.filter(selector).length
                };
                initRender.prototype.children = function(selector) {
                    let result = [];
                    for (let i = 0; i < this.length; i++) {
                        const nodes = this[i] ? this[i].childNodes : [];
                        for (let j = 0; j < nodes.length; j++) {
                            if (_dom_adapter.default.isElementNode(nodes[j])) {
                                result.push(nodes[j])
                            }
                        }
                    }
                    result = renderer(result);
                    return selector ? result.filter(selector) : result
                };
                initRender.prototype.siblings = function() {
                    const element = this[0];
                    if (!element || !element.parentNode) {
                        return renderer()
                    }
                    const result = [];
                    const parentChildNodes = element.parentNode.childNodes || [];
                    for (let i = 0; i < parentChildNodes.length; i++) {
                        const node = parentChildNodes[i];
                        if (_dom_adapter.default.isElementNode(node) && node !== element) {
                            result.push(node)
                        }
                    }
                    return renderer(result)
                };
                initRender.prototype.each = function(callback) {
                    for (let i = 0; i < this.length; i++) {
                        if (false === callback.call(this[i], i, this[i])) {
                            break
                        }
                    }
                };
                initRender.prototype.index = function(element) {
                    if (!element) {
                        return this.parent().children().index(this)
                    }
                    element = renderer(element);
                    return this.toArray().indexOf(element[0])
                };
                initRender.prototype.get = function(index) {
                    return this[index < 0 ? this.length + index : index]
                };
                initRender.prototype.eq = function(index) {
                    index = index < 0 ? this.length + index : index;
                    return renderer(this[index])
                };
                initRender.prototype.first = function() {
                    return this.eq(0)
                };
                initRender.prototype.last = function() {
                    return this.eq(-1)
                };
                initRender.prototype.select = function() {
                    for (let i = 0; i < this.length; i += 1) {
                        this[i].select && this[i].select()
                    }
                    return this
                };
                initRender.prototype.parent = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    const result = renderer(this[0].parentNode);
                    return !selector || result.is(selector) ? result : renderer()
                };
                initRender.prototype.parents = function(selector) {
                    const result = [];
                    let parent = this.parent();
                    while (parent && parent[0] && !_dom_adapter.default.isDocument(parent[0])) {
                        if (_dom_adapter.default.isElementNode(parent[0])) {
                            if (!selector || parent.is(selector)) {
                                result.push(parent.get(0))
                            }
                        }
                        parent = parent.parent()
                    }
                    return renderer(result)
                };
                initRender.prototype.closest = function(selector) {
                    if (this.is(selector)) {
                        return this
                    }
                    let parent = this.parent();
                    while (parent && parent.length) {
                        if (parent.is(selector)) {
                            return parent
                        }
                        parent = parent.parent()
                    }
                    return renderer()
                };
                initRender.prototype.next = function(selector) {
                    if (!this[0]) {
                        return renderer()
                    }
                    let next = renderer(this[0].nextSibling);
                    if (!arguments.length) {
                        return next
                    }
                    while (next && next.length) {
                        if (next.is(selector)) {
                            return next
                        }
                        next = next.next()
                    }
                    return renderer()
                };
                initRender.prototype.prev = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    return renderer(this[0].previousSibling)
                };
                initRender.prototype.add = function(selector) {
                    const targets = renderer(selector);
                    const result = this.toArray();
                    for (let i = 0; i < targets.length; i++) {
                        const target = targets[i];
                        if (-1 === result.indexOf(target)) {
                            result.push(target)
                        }
                    }
                    return renderer(result)
                };
                const emptyArray = [];
                initRender.prototype.splice = function() {
                    return renderer(emptyArray.splice.apply(this, arguments))
                };
                initRender.prototype.slice = function() {
                    return renderer(emptyArray.slice.apply(this, arguments))
                };
                initRender.prototype.toArray = function() {
                    return emptyArray.slice.call(this)
                };
                initRender.prototype.offset = function() {
                    if (!this[0]) {
                        return
                    }
                    return (0, _size.getOffset)(this[0])
                };
                initRender.prototype.offsetParent = function() {
                    if (!this[0]) {
                        return renderer()
                    }
                    let offsetParent = renderer(this[0].offsetParent);
                    while (offsetParent[0] && "static" === offsetParent.css("position")) {
                        offsetParent = renderer(offsetParent[0].offsetParent)
                    }
                    offsetParent = offsetParent[0] ? offsetParent : renderer(_dom_adapter.default.getDocumentElement());
                    return offsetParent
                };
                initRender.prototype.position = function() {
                    if (!this[0]) {
                        return
                    }
                    let offset;
                    const marginTop = parseFloat(this.css("marginTop"));
                    const marginLeft = parseFloat(this.css("marginLeft"));
                    if ("fixed" === this.css("position")) {
                        offset = this[0].getBoundingClientRect();
                        return {
                            top: offset.top - marginTop,
                            left: offset.left - marginLeft
                        }
                    }
                    offset = this.offset();
                    const offsetParent = this.offsetParent();
                    let parentOffset = {
                        top: 0,
                        left: 0
                    };
                    if ("HTML" !== offsetParent[0].nodeName) {
                        parentOffset = offsetParent.offset()
                    }
                    parentOffset = {
                        top: parentOffset.top + parseFloat(offsetParent.css("borderTopWidth")),
                        left: parentOffset.left + parseFloat(offsetParent.css("borderLeftWidth"))
                    };
                    return {
                        top: offset.top - parentOffset.top - marginTop,
                        left: offset.left - parentOffset.left - marginLeft
                    }
                };
                [{
                    name: "scrollLeft",
                    offsetProp: "pageXOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(value, win.pageYOffset)
                    }
                }, {
                    name: "scrollTop",
                    offsetProp: "pageYOffset",
                    scrollWindow: function(win, value) {
                        win.scrollTo(win.pageXOffset, value)
                    }
                }].forEach((function(directionStrategy) {
                    const propName = directionStrategy.name;
                    initRender.prototype[propName] = function(value) {
                        if (!this[0]) {
                            return
                        }
                        const window = (0, _size.getWindowByElement)(this[0]);
                        if (void 0 === value) {
                            return window ? window[directionStrategy.offsetProp] : this[0][propName]
                        }
                        if (window) {
                            directionStrategy.scrollWindow(window, value)
                        } else {
                            this[0][propName] = value
                        }
                        return this
                    }
                }));
                initRender.prototype.data = function(key, value) {
                    if (!this[0]) {
                        return
                    }
                    if (arguments.length < 2) {
                        return _element_data.data.call(renderer, this[0], key)
                    }
                    _element_data.data.call(renderer, this[0], key, value);
                    return this
                };
                initRender.prototype.removeData = function(key) {
                    this[0] && (0, _element_data.removeData)(this[0], key);
                    return this
                };
                const rendererWrapper = function() {
                    return renderer.apply(this, arguments)
                };
                Object.defineProperty(rendererWrapper, "fn", {
                    enumerable: true,
                    configurable: true,
                    get: function() {
                        return renderer.fn
                    },
                    set: function(value) {
                        renderer.fn = value
                    }
                });
                exports.default = {
                    set: function(strategy) {
                        renderer = strategy
                    },
                    get: function() {
                        return rendererWrapper
                    }
                }
            },
        1896:
            /*!****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/options/option_manager.js ***!
              \****************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "OptionManager", {
                    enumerable: true,
                    get: function() {
                        return _m_option_manager.OptionManager
                    }
                });
                var _m_option_manager = __webpack_require__( /*! ../../__internal/core/options/m_option_manager */ 59830)
            },
        1956:
            /*!*************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/version.js ***!
              \*************************************************************/
            (__unused_webpack_module, exports) => {
                exports.version = exports.fullVersion = void 0;
                exports.version = "25.2.3";
                exports.fullVersion = "25.2.3"
            },
        2082:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/format_helper.js ***!
              \**************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _type = __webpack_require__( /*! ./core/utils/type */ 11528);
                var _date = _interopRequireDefault(__webpack_require__( /*! ./core/utils/date */ 41380));
                var _number = _interopRequireDefault(__webpack_require__( /*! ./common/core/localization/number */ 52771));
                var _date2 = _interopRequireDefault(__webpack_require__( /*! ./common/core/localization/date */ 38662));
                var _dependency_injector = _interopRequireDefault(__webpack_require__( /*! ./core/utils/dependency_injector */ 89656));
                __webpack_require__( /*! ./common/core/localization/currency */ 17333);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = (0, _dependency_injector.default)({
                    format: function(value, format) {
                        const formatIsValid = (0, _type.isString)(format) && "" !== format || (0, _type.isPlainObject)(format) || (0, _type.isFunction)(format);
                        const valueIsValid = (0, _type.isNumeric)(value) || (0, _type.isDate)(value);
                        if (!formatIsValid || !valueIsValid) {
                            return (0, _type.isDefined)(value) ? value.toString() : ""
                        }
                        if ((0, _type.isFunction)(format)) {
                            return format(value)
                        }
                        if ((0, _type.isString)(format)) {
                            format = {
                                type: format
                            }
                        }
                        if ((0, _type.isNumeric)(value)) {
                            return _number.default.format(value, format)
                        }
                        if ((0, _type.isDate)(value)) {
                            return _date2.default.format(value, format)
                        }
                    },
                    getTimeFormat: function(showSecond) {
                        return showSecond ? "longtime" : "shorttime"
                    },
                    _normalizeFormat: function(format) {
                        if (!Array.isArray(format)) {
                            return format
                        }
                        if (1 === format.length) {
                            return format[0]
                        }
                        return function(date) {
                            return format.map((function(formatPart) {
                                return _date2.default.format(date, formatPart)
                            })).join(" ")
                        }
                    },
                    getDateFormatByDifferences: function(dateDifferences, intervalFormat) {
                        const resultFormat = [];
                        const needSpecialSecondFormatter = intervalFormat && dateDifferences.millisecond && !(dateDifferences.year || dateDifferences.month || dateDifferences.day);
                        if (needSpecialSecondFormatter) {
                            const secondFormatter = function(date) {
                                return date.getSeconds() + date.getMilliseconds() / 1e3 + "s"
                            };
                            resultFormat.push(secondFormatter)
                        } else if (dateDifferences.millisecond) {
                            resultFormat.push("millisecond")
                        }
                        if (dateDifferences.hour || dateDifferences.minute || !needSpecialSecondFormatter && dateDifferences.second) {
                            resultFormat.unshift(this.getTimeFormat(dateDifferences.second))
                        }
                        if (dateDifferences.year && dateDifferences.month && dateDifferences.day) {
                            if (intervalFormat && "month" === intervalFormat) {
                                return "monthandyear"
                            } else {
                                resultFormat.unshift("shortdate");
                                return this._normalizeFormat(resultFormat)
                            }
                        }
                        if (dateDifferences.year && dateDifferences.month) {
                            return "monthandyear"
                        }
                        if (dateDifferences.year && dateDifferences.quarter) {
                            return "quarterandyear"
                        }
                        if (dateDifferences.year) {
                            return "year"
                        }
                        if (dateDifferences.quarter) {
                            return "quarter"
                        }
                        if (dateDifferences.month && dateDifferences.day) {
                            if (intervalFormat) {
                                const monthDayFormatter = function(date) {
                                    return _date2.default.getMonthNames("abbreviated")[date.getMonth()] + " " + _date2.default.format(date, "day")
                                };
                                resultFormat.unshift(monthDayFormatter)
                            } else {
                                resultFormat.unshift("monthandday")
                            }
                            return this._normalizeFormat(resultFormat)
                        }
                        if (dateDifferences.month) {
                            return "month"
                        }
                        if (dateDifferences.day) {
                            if (intervalFormat) {
                                resultFormat.unshift("day")
                            } else {
                                const dayFormatter = function(date) {
                                    return _date2.default.format(date, "dayofweek") + ", " + _date2.default.format(date, "day")
                                };
                                resultFormat.unshift(dayFormatter)
                            }
                            return this._normalizeFormat(resultFormat)
                        }
                        return this._normalizeFormat(resultFormat)
                    },
                    getDateFormatByTicks: function(ticks) {
                        let maxDiff;
                        let currentDiff;
                        let i;
                        if (ticks.length > 1) {
                            maxDiff = _date.default.getDatesDifferences(ticks[0], ticks[1]);
                            for (i = 1; i < ticks.length - 1; i++) {
                                currentDiff = _date.default.getDatesDifferences(ticks[i], ticks[i + 1]);
                                if (maxDiff.count < currentDiff.count) {
                                    maxDiff = currentDiff
                                }
                            }
                        } else {
                            maxDiff = {
                                year: true,
                                month: true,
                                day: true,
                                hour: ticks[0].getHours() > 0,
                                minute: ticks[0].getMinutes() > 0,
                                second: ticks[0].getSeconds() > 0,
                                millisecond: ticks[0].getMilliseconds() > 0
                            }
                        }
                        const resultFormat = this.getDateFormatByDifferences(maxDiff);
                        return resultFormat
                    },
                    getDateFormatByTickInterval: function(startValue, endValue, tickInterval) {
                        let dateUnitInterval;
                        const correctDateDifferences = function(dateDifferences, tickInterval, value) {
                            switch (tickInterval) {
                                case "year":
                                case "quarter":
                                    dateDifferences.month = value;
                                case "month":
                                    dateDifferences.day = value;
                                case "week":
                                case "day":
                                    dateDifferences.hour = value;
                                case "hour":
                                    dateDifferences.minute = value;
                                case "minute":
                                    dateDifferences.second = value;
                                case "second":
                                    dateDifferences.millisecond = value
                            }
                        };
                        tickInterval = (0, _type.isString)(tickInterval) ? tickInterval.toLowerCase() : tickInterval;
                        const dateDifferences = _date.default.getDatesDifferences(startValue, endValue);
                        if (startValue !== endValue) {
                            ! function(differences, minDate, maxDate) {
                                if (!maxDate.getMilliseconds() && maxDate.getSeconds()) {
                                    if (maxDate.getSeconds() - minDate.getSeconds() === 1) {
                                        differences.millisecond = true;
                                        differences.second = false
                                    }
                                } else if (!maxDate.getSeconds() && maxDate.getMinutes()) {
                                    if (maxDate.getMinutes() - minDate.getMinutes() === 1) {
                                        differences.second = true;
                                        differences.minute = false
                                    }
                                } else if (!maxDate.getMinutes() && maxDate.getHours()) {
                                    if (maxDate.getHours() - minDate.getHours() === 1) {
                                        differences.minute = true;
                                        differences.hour = false
                                    }
                                } else if (!maxDate.getHours() && maxDate.getDate() > 1) {
                                    if (maxDate.getDate() - minDate.getDate() === 1) {
                                        differences.hour = true;
                                        differences.day = false
                                    }
                                } else if (1 === maxDate.getDate() && maxDate.getMonth()) {
                                    if (maxDate.getMonth() - minDate.getMonth() === 1) {
                                        differences.day = true;
                                        differences.month = false
                                    }
                                } else if (!maxDate.getMonth() && maxDate.getFullYear()) {
                                    if (maxDate.getFullYear() - minDate.getFullYear() === 1) {
                                        differences.month = true;
                                        differences.year = false
                                    }
                                }
                            }(dateDifferences, startValue > endValue ? endValue : startValue, startValue > endValue ? startValue : endValue)
                        }
                        dateUnitInterval = _date.default.getDateUnitInterval(dateDifferences);
                        correctDateDifferences(dateDifferences, dateUnitInterval, true);
                        dateUnitInterval = _date.default.getDateUnitInterval(tickInterval || "second");
                        correctDateDifferences(dateDifferences, dateUnitInterval, false);
                        dateDifferences[{
                            week: "day"
                        } [dateUnitInterval] || dateUnitInterval] = true;
                        const resultFormat = this.getDateFormatByDifferences(dateDifferences);
                        return resultFormat
                    }
                });
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        2146:
            /*!*********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/points/range_bar_point.js ***!
              \*********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _bar_point = _interopRequireDefault(__webpack_require__( /*! ../../../viz/series/points/bar_point */ 9820));
                var _range_symbol_point = _interopRequireDefault(__webpack_require__( /*! ../../../viz/series/points/range_symbol_point */ 921));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const _extend = _extend2.extend;
                exports.default = _extend({}, _bar_point.default, {
                    deleteLabel: _range_symbol_point.default.deleteLabel,
                    _getFormatObject: _range_symbol_point.default._getFormatObject,
                    clearVisibility() {
                        const graphic = this.graphic;
                        if (graphic && graphic.attr("visibility")) {
                            graphic.attr({
                                visibility: null
                            })
                        }
                    },
                    setInvisibility() {
                        const graphic = this.graphic;
                        if (graphic && "hidden" !== graphic.attr("visibility")) {
                            graphic.attr({
                                visibility: "hidden"
                            })
                        }
                        this._topLabel.draw(false);
                        this._bottomLabel.draw(false)
                    },
                    getTooltipParams(location) {
                        const that = this;
                        const edgeLocation = "edge" === location;
                        let x;
                        let y;
                        if (that._options.rotated) {
                            x = edgeLocation ? that.x + that.width : that.x + that.width / 2;
                            y = that.y + that.height / 2
                        } else {
                            x = that.x + that.width / 2;
                            y = edgeLocation ? that.y : that.y + that.height / 2
                        }
                        return {
                            x: x,
                            y: y,
                            offset: 0
                        }
                    },
                    _translate() {
                        const that = this;
                        const barMethods = _bar_point.default;
                        barMethods._translate.call(that);
                        if (that._options.rotated) {
                            that.width = that.width || 1
                        } else {
                            that.height = that.height || 1
                        }
                    },
                    hasCoords: _range_symbol_point.default.hasCoords,
                    _updateData: _range_symbol_point.default._updateData,
                    _getLabelPosition: _range_symbol_point.default._getLabelPosition,
                    _getLabelMinFormatObject: _range_symbol_point.default._getLabelMinFormatObject,
                    _updateLabelData: _range_symbol_point.default._updateLabelData,
                    _updateLabelOptions: _range_symbol_point.default._updateLabelOptions,
                    getCrosshairData: _range_symbol_point.default.getCrosshairData,
                    _createLabel: _range_symbol_point.default._createLabel,
                    _checkOverlay: _range_symbol_point.default._checkOverlay,
                    _checkLabelsOverlay: _range_symbol_point.default._checkLabelsOverlay,
                    _getOverlayCorrections: _range_symbol_point.default._getOverlayCorrections,
                    _drawLabel: _range_symbol_point.default._drawLabel,
                    _getLabelCoords: _range_symbol_point.default._getLabelCoords,
                    getLabel: _range_symbol_point.default.getLabel,
                    getLabels: _range_symbol_point.default.getLabels,
                    getBoundingRect: _common.noop,
                    getMinValue: _range_symbol_point.default.getMinValue,
                    getMaxValue: _range_symbol_point.default.getMaxValue
                })
            },
        2155:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/funnel/tracker.js ***!
              \******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.plugin = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _tracker = __webpack_require__( /*! ../../viz/components/tracker */ 21823);
                var _funnel = (e = __webpack_require__( /*! ../../viz/funnel/funnel */ 71059), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                let dataKeyModifier = 0;
                const proto = _funnel.default.prototype;
                proto._eventsMap.onItemClick = {
                    name: "itemClick"
                };
                proto._eventsMap.onLegendClick = {
                    name: "legendClick"
                };
                exports.plugin = {
                    name: "tracker",
                    init() {
                        const that = this;
                        const dataKey = "__funnel_data_" + dataKeyModifier++;
                        const getProxyData = function(e) {
                            const rootOffset = that._renderer.getRootOffset();
                            const x = Math.floor(e.pageX - rootOffset.left);
                            const y = Math.floor(e.pageY - rootOffset.top);
                            return that._hitTestTargets(x, y)
                        };
                        that._tracker = new _tracker.Tracker({
                            widget: that,
                            root: that._renderer.root,
                            getData(e, tooltipData) {
                                const target = e.target;
                                const data = target[dataKey];
                                if ((0, _type.isDefined)(data)) {
                                    return data
                                }
                                const proxyData = getProxyData(e);
                                if (tooltipData && proxyData && "inside-label" !== proxyData.type) {
                                    return
                                }
                                return proxyData && proxyData.id
                            },
                            getNode: index => that._items[index],
                            click(e) {
                                const proxyData = getProxyData(e.event);
                                const dataType = proxyData && proxyData.type;
                                const event = "legend" === dataType ? "legendClick" : "itemClick";
                                that._eventTrigger(event, {
                                    item: e.node,
                                    event: e.event
                                })
                            }
                        });
                        this._dataKey = dataKey
                    },
                    dispose() {
                        this._tracker.dispose()
                    },
                    extenders: {
                        _change_TILING() {
                            const dataKey = this._dataKey;
                            this._items.forEach(((item, index) => {
                                item.element.data(dataKey, index)
                            }))
                        }
                    }
                }
            },
        2211:
            /*!********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/bundles/modules/viz.js ***!
              \********************************************************************/
            (module, __unused_webpack_exports, __webpack_require__) => {
                __webpack_require__( /*! ./core */ 92307);
                module.exports = DevExpress.viz = DevExpress.viz || {}
            },
        2225:
            /*!**********************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/viz/utils.js ***!
              \**********************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                var _utils = __webpack_require__( /*! ../__internal/viz/utils */ 49143);
                Object.keys(_utils).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _utils[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _utils[key]
                        }
                    })
                }))
            },
        2607:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/events_strategy.js ***!
              \*********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "EventsStrategy", {
                    enumerable: true,
                    get: function() {
                        return _m_events_strategy.EventsStrategy
                    }
                });
                var _m_events_strategy = __webpack_require__( /*! ../__internal/core/m_events_strategy */ 14201)
            },
        2611:
            /*!********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/contrast.js ***!
              \********************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                const WHITE = "#ffffff";
                const BLACK = "#000000";
                exports.default = [{
                    baseThemeName: "generic.light",
                    theme: {
                        name: "generic.contrast",
                        defaultPalette: "Bright",
                        font: {
                            color: WHITE
                        },
                        backgroundColor: BLACK,
                        primaryTitleColor: WHITE,
                        secondaryTitleColor: WHITE,
                        gridColor: WHITE,
                        axisColor: WHITE,
                        export: {
                            backgroundColor: BLACK,
                            font: {
                                color: WHITE
                            },
                            button: {
                                default: {
                                    color: WHITE,
                                    borderColor: WHITE,
                                    backgroundColor: BLACK
                                },
                                hover: {
                                    color: WHITE,
                                    borderColor: WHITE,
                                    backgroundColor: "#cf00d7"
                                },
                                focus: {
                                    color: WHITE,
                                    borderColor: "#cf00d7",
                                    backgroundColor: BLACK
                                },
                                active: {
                                    color: BLACK,
                                    borderColor: WHITE,
                                    backgroundColor: WHITE
                                }
                            },
                            borderColor: WHITE,
                            menuButtonColor: BLACK,
                            activeBackgroundColor: WHITE,
                            activeColor: BLACK,
                            selectedBorderColor: "#cf00da",
                            selectedColor: "#cf00da",
                            shadowColor: "none"
                        },
                        tooltip: {
                            border: {
                                color: WHITE
                            },
                            font: {
                                color: WHITE
                            },
                            color: BLACK
                        },
                        "chart:common": {
                            commonSeriesSettings: {
                                valueErrorBar: {
                                    color: WHITE
                                },
                                hoverStyle: {
                                    hatching: {
                                        opacity: .5
                                    }
                                },
                                selectionStyle: {
                                    hatching: {
                                        opacity: .35
                                    }
                                },
                                label: {
                                    font: {
                                        color: WHITE
                                    },
                                    border: {
                                        color: WHITE
                                    }
                                }
                            }
                        },
                        "chart:common:axis": {
                            constantLineStyle: {
                                color: WHITE
                            }
                        },
                        "chart:common:annotation": {
                            font: {
                                color: WHITE
                            },
                            border: {
                                color: WHITE
                            },
                            color: BLACK
                        },
                        chart: {
                            commonSeriesSettings: {},
                            crosshair: {
                                color: "#cf00d7"
                            },
                            commonPaneSettings: {
                                backgroundColor: BLACK,
                                border: {
                                    color: WHITE
                                }
                            },
                            scrollBar: {
                                color: WHITE
                            },
                            commonAxisSettings: {
                                breakStyle: {
                                    color: "#cf00d7"
                                }
                            },
                            zoomAndPan: {
                                dragBoxStyle: {
                                    color: WHITE,
                                    opacity: .7
                                }
                            }
                        },
                        pie: {
                            commonSeriesSettings: {
                                pie: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                },
                                doughnut: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                },
                                donut: {
                                    hoverStyle: {
                                        hatching: {
                                            opacity: .5
                                        }
                                    },
                                    selectionStyle: {
                                        hatching: {
                                            opacity: .35
                                        }
                                    }
                                }
                            }
                        },
                        gauge: {
                            rangeContainer: {
                                backgroundColor: WHITE
                            },
                            valueIndicators: {
                                _default: {
                                    color: WHITE
                                },
                                rangebar: {
                                    color: WHITE,
                                    backgroundColor: BLACK
                                },
                                twocolorneedle: {
                                    secondColor: WHITE
                                },
                                trianglemarker: {
                                    color: WHITE
                                },
                                textcloud: {
                                    color: WHITE,
                                    text: {
                                        font: {
                                            color: BLACK
                                        }
                                    }
                                }
                            }
                        },
                        barGauge: {
                            backgroundColor: "#3c3c3c"
                        },
                        rangeSelector: {
                            scale: {
                                tick: {
                                    color: WHITE,
                                    opacity: .4
                                },
                                minorTick: {
                                    color: WHITE,
                                    opacity: .12
                                },
                                breakStyle: {
                                    color: "#cf00d7"
                                }
                            },
                            selectedRangeColor: "#cf00da",
                            sliderMarker: {
                                color: "#cf00da"
                            },
                            sliderHandle: {
                                color: "#cf00da",
                                opacity: 1
                            },
                            shutter: {
                                opacity: .75
                            },
                            background: {
                                color: BLACK
                            }
                        },
                        map: {
                            background: {
                                borderColor: WHITE
                            },
                            layer: {
                                label: {
                                    stroke: BLACK,
                                    font: {
                                        color: WHITE
                                    }
                                }
                            },
                            "layer:area": {
                                borderColor: BLACK,
                                color: "#686868",
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE,
                                label: {
                                    font: {
                                        opacity: 1
                                    }
                                }
                            },
                            "layer:line": {
                                color: "#267cff",
                                hoveredColor: "#f613ff",
                                selectedColor: WHITE
                            },
                            "layer:marker:dot": {
                                borderColor: BLACK,
                                color: "#f8ca00",
                                backColor: BLACK,
                                backOpacity: .32
                            },
                            "layer:marker:bubble": {
                                color: "#f8ca00",
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE
                            },
                            "layer:marker:pie": {
                                hoveredBorderColor: WHITE,
                                selectedBorderColor: WHITE
                            },
                            controlBar: {
                                borderColor: WHITE,
                                color: BLACK,
                                opacity: .3
                            }
                        },
                        treeMap: {
                            tile: {
                                color: "#70c92f"
                            },
                            group: {
                                color: "#797979",
                                label: {
                                    font: {
                                        color: WHITE
                                    }
                                }
                            }
                        },
                        sparkline: {
                            pointColor: BLACK
                        },
                        bullet: {},
                        polar: {
                            commonSeriesSettings: {}
                        },
                        funnel: {
                            label: {
                                connector: {
                                    opacity: 1
                                }
                            }
                        },
                        sankey: {
                            label: {
                                font: {
                                    color: WHITE
                                },
                                shadow: {
                                    opacity: 0
                                }
                            },
                            node: {
                                border: {
                                    visible: true,
                                    width: 1,
                                    color: WHITE
                                }
                            },
                            link: {
                                opacity: .5,
                                border: {
                                    visible: true,
                                    width: 1,
                                    color: WHITE
                                },
                                hoverStyle: {
                                    opacity: .9
                                }
                            }
                        }
                    }
                }, {
                    baseThemeName: "generic.contrast",
                    theme: {
                        name: "generic.contrast.compact"
                    }
                }]
            },
        2836:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/runtime/inferno/effect.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoEffect = void 0;
                exports.InfernoEffect = class {
                    constructor(effect, dependency) {
                        this.dependency = dependency;
                        this.effect = effect;
                        this.destroy = effect()
                    }
                    update(dependency) {
                        const currentDependency = this.dependency;
                        if (dependency) {
                            this.dependency = dependency
                        }
                        if (!dependency || dependency.some(((d, i) => currentDependency[i] !== d))) {
                            this.dispose();
                            this.destroy = this.effect()
                        }
                    }
                    dispose() {
                        if (this.destroy) {
                            this.destroy()
                        }
                    }
                }
            },
        3030:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/animation/position.js ***!
              \*******************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_position = (e = __webpack_require__( /*! ../../../__internal/common/core/animation/m_position */ 36972), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _m_position.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3104:
            /*!******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/window.js ***!
              \******************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "defaultScreenFactorFunc", {
                    enumerable: true,
                    get: function() {
                        return _m_window.defaultScreenFactorFunc
                    }
                });
                Object.defineProperty(exports, "getCurrentScreenFactor", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getCurrentScreenFactor
                    }
                });
                Object.defineProperty(exports, "getNavigator", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getNavigator
                    }
                });
                Object.defineProperty(exports, "getWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.getWindow
                    }
                });
                Object.defineProperty(exports, "hasProperty", {
                    enumerable: true,
                    get: function() {
                        return _m_window.hasProperty
                    }
                });
                Object.defineProperty(exports, "hasWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.hasWindow
                    }
                });
                Object.defineProperty(exports, "setWindow", {
                    enumerable: true,
                    get: function() {
                        return _m_window.setWindow
                    }
                });
                var _m_window = __webpack_require__( /*! ../../__internal/core/utils/m_window */ 14470)
            },
        3111:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/events/m_hold.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/core/emitter */ 59e3));
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/core/emitter_registrator */ 81411));
                var _index = __webpack_require__( /*! ../../common/core/events/utils/index */ 98834);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const {
                    abs: abs
                } = Math;
                const HoldEmitter = _emitter.default.inherit({
                    start(e) {
                        this._startEventData = (0, _index.eventData)(e);
                        this._startTimer(e)
                    },
                    _startTimer(e) {
                        const holdTimeout = "timeout" in this ? this.timeout : 750;
                        this._holdTimer = setTimeout((() => {
                            this._requestAccept(e);
                            this._fireEvent("dxhold", e, {
                                target: e.target
                            });
                            this._forgetAccept()
                        }), holdTimeout)
                    },
                    move(e) {
                        if (this._touchWasMoved(e)) {
                            this._cancel(e)
                        }
                    },
                    _touchWasMoved(e) {
                        const delta = (0, _index.eventDelta)(this._startEventData, (0, _index.eventData)(e));
                        return abs(delta.x) > 5 || abs(delta.y) > 5
                    },
                    end() {
                        this._stopTimer()
                    },
                    _stopTimer() {
                        clearTimeout(this._holdTimer)
                    },
                    cancel() {
                        this._stopTimer()
                    },
                    dispose() {
                        this._stopTimer()
                    }
                });
                (0, _emitter_registrator.default)({
                    emitter: HoldEmitter,
                    bubble: true,
                    events: ["dxhold"]
                });
                exports.default = {
                    name: "dxhold"
                }
            },
        3122:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/ready_callbacks.js ***!
              \***************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_ready_callbacks = __webpack_require__( /*! ../../__internal/core/utils/m_ready_callbacks */ 18344);
                exports.default = _m_ready_callbacks.readyCallbacksModule;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        3198:
            /*!******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_array_utils.js ***!
              \******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.applyBatch = applyBatch;
                exports.applyChanges = function(data, changes) {
                    let options = arguments.length > 2 && void 0 !== arguments[2] ? arguments[2] : {};
                    const {
                        keyExpr: keyExpr = "id",
                        immutable: immutable = true
                    } = options;
                    const keyGetter = (0, _data.compileGetter)(keyExpr);
                    const keyInfo = {
                        key: () => keyExpr,
                        keyOf: obj => keyGetter(obj)
                    };
                    return applyBatch({
                        keyInfo: keyInfo,
                        data: data,
                        changes: changes,
                        immutable: immutable,
                        disableCache: true,
                        logError: true
                    })
                };
                exports.createObjectWithChanges = createObjectWithChanges;
                exports.indexByKey = indexByKey;
                exports.insert = insert;
                exports.remove = remove;
                exports.update = update;
                var _errors = __webpack_require__( /*! ../../common/data/errors */ 82812);
                var _utils = __webpack_require__( /*! ../../common/data/utils */ 89358);
                var _config = _interopRequireDefault(__webpack_require__( /*! ../../core/config */ 66636));
                var _guid = _interopRequireDefault(__webpack_require__( /*! ../../core/guid */ 19427));
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _extend = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _object = __webpack_require__( /*! ../../core/utils/object */ 22263);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }

                function findItems(keyInfo, items, key, groupCount) {
                    let childItems;
                    let result;
                    if (groupCount) {
                        for (let i = 0; i < items.length; i++) {
                            childItems = items[i].items || items[i].collapsedItems || [];
                            result = findItems(keyInfo, childItems || [], key, groupCount - 1);
                            if (result) {
                                return result
                            }
                        }
                    } else if (indexByKey(keyInfo, items, key) >= 0) {
                        return items
                    }
                }

                function getItems(keyInfo, items, key, groupCount) {
                    if (groupCount) {
                        return findItems(keyInfo, items, key, groupCount) || []
                    }
                    return items
                }

                function setDataByKeyMapValue(array, key, data) {
                    if (array._dataByKeyMap) {
                        array._dataByKeyMap[JSON.stringify(key)] = data;
                        array._dataByKeyMapLength += data ? 1 : -1
                    }
                }

                function cloneInstanceWithChangedPaths(instance, changes, clonedInstances) {
                    clonedInstances = clonedInstances || new WeakMap;
                    const result = instance ? Object.create(Object.getPrototypeOf(instance)) : {};
                    if (instance) {
                        clonedInstances.set(instance, result)
                    }
                    const instanceWithoutPrototype = Object.assign({}, instance);
                    (0, _object.deepExtendArraySafe)(result, instanceWithoutPrototype, true, true, true);
                    for (const name in instanceWithoutPrototype) {
                        const value = instanceWithoutPrototype[name];
                        const change = null === changes || void 0 === changes ? void 0 : changes[name];
                        if ((0, _type.isObject)(value) && !(0, _type.isPlainObject)(value) && (0, _type.isObject)(change) && !clonedInstances.has(value)) {
                            result[name] = cloneInstanceWithChangedPaths(value, change, clonedInstances)
                        }
                    }
                    for (const name in result) {
                        const prop = result[name];
                        if ((0, _type.isObject)(prop) && clonedInstances.has(prop)) {
                            result[name] = clonedInstances.get(prop)
                        }
                    }
                    return result
                }

                function createObjectWithChanges(target, changes) {
                    const result = cloneInstanceWithChangedPaths(target, changes);
                    return (0, _object.deepExtendArraySafe)(result, changes, true, true, true)
                }

                function applyBatch(_ref) {
                    let {
                        keyInfo: keyInfo,
                        data: data,
                        changes: changes,
                        groupCount: groupCount,
                        useInsertIndex: useInsertIndex,
                        immutable: immutable,
                        disableCache: disableCache,
                        logError: logError,
                        skipCopying: skipCopying
                    } = _ref;
                    const resultItems = true === immutable ? [...data] : data;
                    changes.forEach((item => {
                        const items = "insert" === item.type ? resultItems : getItems(keyInfo, resultItems, item.key, groupCount);
                        !disableCache && function(keyInfo, array) {
                            if (keyInfo.key() && (!array._dataByKeyMap || array._dataByKeyMapLength !== array.length)) {
                                const dataByKeyMap = {};
                                const arrayLength = array.length;
                                for (let i = 0; i < arrayLength; i++) {
                                    dataByKeyMap[JSON.stringify(keyInfo.keyOf(array[i]))] = array[i]
                                }
                                array._dataByKeyMap = dataByKeyMap;
                                array._dataByKeyMapLength = arrayLength
                            }
                        }(keyInfo, items);
                        switch (item.type) {
                            case "update":
                                update(keyInfo, items, item.key, item.data, true, immutable, logError);
                                break;
                            case "insert":
                                insert(keyInfo, items, item.data, useInsertIndex && (0, _type.isDefined)(item.index) ? item.index : -1, true, logError, skipCopying);
                                break;
                            case "remove":
                                remove(keyInfo, items, item.key, true, logError)
                        }
                    }));
                    return resultItems
                }

                function getErrorResult(isBatch, logError, errorCode) {
                    return !isBatch ? (0, _utils.rejectedPromise)(_errors.errors.Error(errorCode)) : logError && _errors.errors.log(errorCode)
                }

                function update(keyInfo, array, key, data, isBatch, immutable, logError) {
                    let target;
                    const keyExpr = keyInfo.key();
                    if (keyExpr) {
                        if (function(target, keyOrKeys) {
                                let key;
                                const keys = "string" === typeof keyOrKeys ? keyOrKeys.split() : keyOrKeys.slice();
                                while (keys.length) {
                                    key = keys.shift();
                                    if (key in target) {
                                        return true
                                    }
                                }
                                return false
                            }(data, keyExpr) && !(0, _utils.keysEqual)(keyExpr, key, keyInfo.keyOf(data))) {
                            return getErrorResult(isBatch, logError, "E4017")
                        }
                        target = function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                        }(array, key);
                        if (!target) {
                            const index = indexByKey(keyInfo, array, key);
                            if (index < 0) {
                                return getErrorResult(isBatch, logError, "E4009")
                            }
                            target = array[index];
                            if (true === immutable && (0, _type.isDefined)(target)) {
                                const newTarget = createObjectWithChanges(target, data);
                                array[index] = newTarget;
                                return !isBatch && (0, _utils.trivialPromise)(newTarget, key)
                            }
                        }
                    } else {
                        target = key
                    }(0, _object.deepExtendArraySafe)(target, data, true, false, true, true);
                    if (!isBatch) {
                        if ((0, _config.default)().useLegacyStoreResult) {
                            return (0, _utils.trivialPromise)(key, data)
                        }
                        return (0, _utils.trivialPromise)(target, key)
                    }
                }

                function insert(keyInfo, array, data, index, isBatch, logError, skipCopying) {
                    let keyValue;
                    const keyExpr = keyInfo.key();
                    const obj = (0, _type.isPlainObject)(data) && !skipCopying ? (0, _extend.extend)({}, data) : data;
                    if (keyExpr) {
                        keyValue = keyInfo.keyOf(obj);
                        if (void 0 === keyValue || "object" === typeof keyValue && (0, _type.isEmptyObject)(keyValue)) {
                            if (Array.isArray(keyExpr)) {
                                throw _errors.errors.Error("E4007")
                            }
                            keyValue = obj[keyExpr] = String(new _guid.default)
                        } else if (void 0 !== array[indexByKey(keyInfo, array, keyValue)]) {
                            return getErrorResult(isBatch, logError, "E4008")
                        }
                    } else {
                        keyValue = obj
                    }
                    if (index >= 0) {
                        array.splice(index, 0, obj)
                    } else {
                        array.push(obj)
                    }
                    setDataByKeyMapValue(array, keyValue, obj);
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)((0, _config.default)().useLegacyStoreResult ? data : obj, keyValue)
                    }
                }

                function remove(keyInfo, array, key, isBatch, logError) {
                    const index = indexByKey(keyInfo, array, key);
                    if (index > -1) {
                        array.splice(index, 1);
                        setDataByKeyMapValue(array, key, null)
                    }
                    if (!isBatch) {
                        return (0, _utils.trivialPromise)(key)
                    }
                    if (index < 0) {
                        return getErrorResult(isBatch, logError, "E4009")
                    }
                }

                function indexByKey(keyInfo, array, key) {
                    const keyExpr = keyInfo.key();
                    if (! function(array, key) {
                            if (array._dataByKeyMap) {
                                return array._dataByKeyMap[JSON.stringify(key)]
                            }
                            return true
                        }(array, key)) {
                        return -1
                    }
                    for (let i = 0, arrayLength = array.length; i < arrayLength; i++) {
                        if ((0, _utils.keysEqual)(keyExpr, keyInfo.keyOf(array[i]), key)) {
                            return i
                        }
                    }
                    return -1
                }
            },
        3226:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_action.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = exports.Action = void 0;
                var _renderer = (e = __webpack_require__( /*! ../../core/renderer */ 64553), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                class Action {
                    constructor(action, config) {
                        config = config || {};
                        this._action = action;
                        this._context = config.context || (0, _window.getWindow)();
                        this._beforeExecute = config.beforeExecute;
                        this._afterExecute = config.afterExecute;
                        this._component = config.component;
                        this._validatingTargetName = config.validatingTargetName;
                        const excludeValidators = this._excludeValidators = {};
                        if (config.excludeValidators) {
                            for (let i = 0; i < config.excludeValidators.length; i++) {
                                excludeValidators[config.excludeValidators[i]] = true
                            }
                        }
                    }
                    execute() {
                        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
                            args[_key] = arguments[_key]
                        }
                        const e = {
                            action: this._action,
                            args: Array.prototype.slice.call(args),
                            context: this._context,
                            component: this._component,
                            validatingTargetName: this._validatingTargetName,
                            cancel: false,
                            handled: false
                        };
                        const beforeExecute = this._beforeExecute;
                        const afterExecute = this._afterExecute;
                        const argsBag = e.args[0] || {};
                        if (!this._validateAction(e)) {
                            return
                        }
                        null === beforeExecute || void 0 === beforeExecute || beforeExecute.call(this._context, e);
                        if (e.cancel) {
                            return
                        }
                        const result = this._executeAction(e);
                        if (argsBag.cancel) {
                            return
                        }
                        null === afterExecute || void 0 === afterExecute || afterExecute.call(this._context, e);
                        return result
                    }
                    _validateAction(e) {
                        const excludeValidators = this._excludeValidators;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            if (!excludeValidators[name]) {
                                var _executor$validate;
                                const executor = executors[name];
                                null === (_executor$validate = executor.validate) || void 0 === _executor$validate || _executor$validate.call(executor, e);
                                if (e.cancel) {
                                    return false
                                }
                            }
                        }
                        return true
                    }
                    _executeAction(e) {
                        let result;
                        const {
                            executors: executors
                        } = Action;
                        for (const name in executors) {
                            var _executor$execute;
                            const executor = executors[name];
                            null === (_executor$execute = executor.execute) || void 0 === _executor$execute || _executor$execute.call(executor, e);
                            if (e.handled) {
                                result = e.result;
                                break
                            }
                        }
                        return result
                    }
                    static registerExecutor(name, executor) {
                        if ((0, _type.isPlainObject)(name)) {
                            (0, _iterator.each)(name, Action.registerExecutor);
                            return
                        }
                        Action.executors[name] = executor
                    }
                    static unregisterExecutor() {
                        for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
                            args[_key2] = arguments[_key2]
                        }(0, _iterator.each)(args, (function() {
                            delete Action.executors[this]
                        }))
                    }
                }
                exports.Action = Action;
                Action.executors = {};
                const createValidatorByTargetElement = condition => e => {
                    if (!e.args.length) {
                        return
                    }
                    const args = e.args[0];
                    const element = args[e.validatingTargetName] || args.element;
                    if (element && condition((0, _renderer.default)(element))) {
                        e.cancel = true
                    }
                };
                Action.registerExecutor({
                    disabled: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-disabled, .dx-state-disabled *")))
                    },
                    readOnly: {
                        validate: createValidatorByTargetElement(($target => $target.is(".dx-state-readonly, .dx-state-readonly *:not(.dx-state-independent)")))
                    },
                    undefined: {
                        execute: e => {
                            if (!e.action) {
                                e.result = void 0;
                                e.handled = true
                            }
                        }
                    },
                    func: {
                        execute: e => {
                            if ((0, _type.isFunction)(e.action)) {
                                e.result = e.action.call(e.context, e.args[0]);
                                e.handled = true
                            }
                        }
                    }
                });
                exports.default = Action
            },
        3311:
            /*!****************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/localization/cldr-data/supplemental.js ***!
              \****************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.supplementalCldr = void 0;
                // !!! AUTO-GENERATED FILE, DO NOT EDIT
                exports.supplementalCldr = {
                    supplemental: {
                        version: {
                            _unicodeVersion: "12.1.0",
                            _cldrVersion: "36"
                        },
                        likelySubtags: {
                            aa: "aa-Latn-ET",
                            aai: "aai-Latn-ZZ",
                            aak: "aak-Latn-ZZ",
                            aau: "aau-Latn-ZZ",
                            ab: "ab-Cyrl-GE",
                            abi: "abi-Latn-ZZ",
                            abq: "abq-Cyrl-ZZ",
                            abr: "abr-Latn-GH",
                            abt: "abt-Latn-ZZ",
                            aby: "aby-Latn-ZZ",
                            acd: "acd-Latn-ZZ",
                            ace: "ace-Latn-ID",
                            ach: "ach-Latn-UG",
                            ada: "ada-Latn-GH",
                            ade: "ade-Latn-ZZ",
                            adj: "adj-Latn-ZZ",
                            adp: "adp-Tibt-BT",
                            ady: "ady-Cyrl-RU",
                            adz: "adz-Latn-ZZ",
                            ae: "ae-Avst-IR",
                            aeb: "aeb-Arab-TN",
                            aey: "aey-Latn-ZZ",
                            af: "af-Latn-ZA",
                            agc: "agc-Latn-ZZ",
                            agd: "agd-Latn-ZZ",
                            agg: "agg-Latn-ZZ",
                            agm: "agm-Latn-ZZ",
                            ago: "ago-Latn-ZZ",
                            agq: "agq-Latn-CM",
                            aha: "aha-Latn-ZZ",
                            ahl: "ahl-Latn-ZZ",
                            aho: "aho-Ahom-IN",
                            ajg: "ajg-Latn-ZZ",
                            ak: "ak-Latn-GH",
                            akk: "akk-Xsux-IQ",
                            ala: "ala-Latn-ZZ",
                            ali: "ali-Latn-ZZ",
                            aln: "aln-Latn-XK",
                            alt: "alt-Cyrl-RU",
                            am: "am-Ethi-ET",
                            amm: "amm-Latn-ZZ",
                            amn: "amn-Latn-ZZ",
                            amo: "amo-Latn-NG",
                            amp: "amp-Latn-ZZ",
                            an: "an-Latn-ES",
                            anc: "anc-Latn-ZZ",
                            ank: "ank-Latn-ZZ",
                            ann: "ann-Latn-ZZ",
                            any: "any-Latn-ZZ",
                            aoj: "aoj-Latn-ZZ",
                            aom: "aom-Latn-ZZ",
                            aoz: "aoz-Latn-ID",
                            apc: "apc-Arab-ZZ",
                            apd: "apd-Arab-TG",
                            ape: "ape-Latn-ZZ",
                            apr: "apr-Latn-ZZ",
                            aps: "aps-Latn-ZZ",
                            apz: "apz-Latn-ZZ",
                            ar: "ar-Arab-EG",
                            arc: "arc-Armi-IR",
                            "arc-Nbat": "arc-Nbat-JO",
                            "arc-Palm": "arc-Palm-SY",
                            arh: "arh-Latn-ZZ",
                            arn: "arn-Latn-CL",
                            aro: "aro-Latn-BO",
                            arq: "arq-Arab-DZ",
                            ars: "ars-Arab-SA",
                            ary: "ary-Arab-MA",
                            arz: "arz-Arab-EG",
                            as: "as-Beng-IN",
                            asa: "asa-Latn-TZ",
                            ase: "ase-Sgnw-US",
                            asg: "asg-Latn-ZZ",
                            aso: "aso-Latn-ZZ",
                            ast: "ast-Latn-ES",
                            ata: "ata-Latn-ZZ",
                            atg: "atg-Latn-ZZ",
                            atj: "atj-Latn-CA",
                            auy: "auy-Latn-ZZ",
                            av: "av-Cyrl-RU",
                            avl: "avl-Arab-ZZ",
                            avn: "avn-Latn-ZZ",
                            avt: "avt-Latn-ZZ",
                            avu: "avu-Latn-ZZ",
                            awa: "awa-Deva-IN",
                            awb: "awb-Latn-ZZ",
                            awo: "awo-Latn-ZZ",
                            awx: "awx-Latn-ZZ",
                            ay: "ay-Latn-BO",
                            ayb: "ayb-Latn-ZZ",
                            az: "az-Latn-AZ",
                            "az-Arab": "az-Arab-IR",
                            "az-IQ": "az-Arab-IQ",
                            "az-IR": "az-Arab-IR",
                            "az-RU": "az-Cyrl-RU",
                            ba: "ba-Cyrl-RU",
                            bal: "bal-Arab-PK",
                            ban: "ban-Latn-ID",
                            bap: "bap-Deva-NP",
                            bar: "bar-Latn-AT",
                            bas: "bas-Latn-CM",
                            bav: "bav-Latn-ZZ",
                            bax: "bax-Bamu-CM",
                            bba: "bba-Latn-ZZ",
                            bbb: "bbb-Latn-ZZ",
                            bbc: "bbc-Latn-ID",
                            bbd: "bbd-Latn-ZZ",
                            bbj: "bbj-Latn-CM",
                            bbp: "bbp-Latn-ZZ",
                            bbr: "bbr-Latn-ZZ",
                            bcf: "bcf-Latn-ZZ",
                            bch: "bch-Latn-ZZ",
                            bci: "bci-Latn-CI",
                            bcm: "bcm-Latn-ZZ",
                            bcn: "bcn-Latn-ZZ",
                            bco: "bco-Latn-ZZ",
                            bcq: "bcq-Ethi-ZZ",
                            bcu: "bcu-Latn-ZZ",
                            bdd: "bdd-Latn-ZZ",
                            be: "be-Cyrl-BY",
                            bef: "bef-Latn-ZZ",
                            beh: "beh-Latn-ZZ",
                            bej: "bej-Arab-SD",
                            bem: "bem-Latn-ZM",
                            bet: "bet-Latn-ZZ",
                            bew: "bew-Latn-ID",
                            bex: "bex-Latn-ZZ",
                            bez: "bez-Latn-TZ",
                            bfd: "bfd-Latn-CM",
                            bfq: "bfq-Taml-IN",
                            bft: "bft-Arab-PK",
                            bfy: "bfy-Deva-IN",
                            bg: "bg-Cyrl-BG",
                            bgc: "bgc-Deva-IN",
                            bgn: "bgn-Arab-PK",
                            bgx: "bgx-Grek-TR",
                            bhb: "bhb-Deva-IN",
                            bhg: "bhg-Latn-ZZ",
                            bhi: "bhi-Deva-IN",
                            bhl: "bhl-Latn-ZZ",
                            bho: "bho-Deva-IN",
                            bhy: "bhy-Latn-ZZ",
                            bi: "bi-Latn-VU",
                            bib: "bib-Latn-ZZ",
                            big: "big-Latn-ZZ",
                            bik: "bik-Latn-PH",
                            bim: "bim-Latn-ZZ",
                            bin: "bin-Latn-NG",
                            bio: "bio-Latn-ZZ",
                            biq: "biq-Latn-ZZ",
                            bjh: "bjh-Latn-ZZ",
                            bji: "bji-Ethi-ZZ",
                            bjj: "bjj-Deva-IN",
                            bjn: "bjn-Latn-ID",
                            bjo: "bjo-Latn-ZZ",
                            bjr: "bjr-Latn-ZZ",
                            bjt: "bjt-Latn-SN",
                            bjz: "bjz-Latn-ZZ",
                            bkc: "bkc-Latn-ZZ",
                            bkm: "bkm-Latn-CM",
                            bkq: "bkq-Latn-ZZ",
                            bku: "bku-Latn-PH",
                            bkv: "bkv-Latn-ZZ",
                            blt: "blt-Tavt-VN",
                            bm: "bm-Latn-ML",
                            bmh: "bmh-Latn-ZZ",
                            bmk: "bmk-Latn-ZZ",
                            bmq: "bmq-Latn-ML",
                            bmu: "bmu-Latn-ZZ",
                            bn: "bn-Beng-BD",
                            bng: "bng-Latn-ZZ",
                            bnm: "bnm-Latn-ZZ",
                            bnp: "bnp-Latn-ZZ",
                            bo: "bo-Tibt-CN",
                            boj: "boj-Latn-ZZ",
                            bom: "bom-Latn-ZZ",
                            bon: "bon-Latn-ZZ",
                            bpy: "bpy-Beng-IN",
                            bqc: "bqc-Latn-ZZ",
                            bqi: "bqi-Arab-IR",
                            bqp: "bqp-Latn-ZZ",
                            bqv: "bqv-Latn-CI",
                            br: "br-Latn-FR",
                            bra: "bra-Deva-IN",
                            brh: "brh-Arab-PK",
                            brx: "brx-Deva-IN",
                            brz: "brz-Latn-ZZ",
                            bs: "bs-Latn-BA",
                            bsj: "bsj-Latn-ZZ",
                            bsq: "bsq-Bass-LR",
                            bss: "bss-Latn-CM",
                            bst: "bst-Ethi-ZZ",
                            bto: "bto-Latn-PH",
                            btt: "btt-Latn-ZZ",
                            btv: "btv-Deva-PK",
                            bua: "bua-Cyrl-RU",
                            buc: "buc-Latn-YT",
                            bud: "bud-Latn-ZZ",
                            bug: "bug-Latn-ID",
                            buk: "buk-Latn-ZZ",
                            bum: "bum-Latn-CM",
                            buo: "buo-Latn-ZZ",
                            bus: "bus-Latn-ZZ",
                            buu: "buu-Latn-ZZ",
                            bvb: "bvb-Latn-GQ",
                            bwd: "bwd-Latn-ZZ",
                            bwr: "bwr-Latn-ZZ",
                            bxh: "bxh-Latn-ZZ",
                            bye: "bye-Latn-ZZ",
                            byn: "byn-Ethi-ER",
                            byr: "byr-Latn-ZZ",
                            bys: "bys-Latn-ZZ",
                            byv: "byv-Latn-CM",
                            byx: "byx-Latn-ZZ",
                            bza: "bza-Latn-ZZ",
                            bze: "bze-Latn-ML",
                            bzf: "bzf-Latn-ZZ",
                            bzh: "bzh-Latn-ZZ",
                            bzw: "bzw-Latn-ZZ",
                            ca: "ca-Latn-ES",
                            can: "can-Latn-ZZ",
                            cbj: "cbj-Latn-ZZ",
                            cch: "cch-Latn-NG",
                            ccp: "ccp-Cakm-BD",
                            ce: "ce-Cyrl-RU",
                            ceb: "ceb-Latn-PH",
                            cfa: "cfa-Latn-ZZ",
                            cgg: "cgg-Latn-UG",
                            ch: "ch-Latn-GU",
                            chk: "chk-Latn-FM",
                            chm: "chm-Cyrl-RU",
                            cho: "cho-Latn-US",
                            chp: "chp-Latn-CA",
                            chr: "chr-Cher-US",
                            cic: "cic-Latn-US",
                            cja: "cja-Arab-KH",
                            cjm: "cjm-Cham-VN",
                            cjv: "cjv-Latn-ZZ",
                            ckb: "ckb-Arab-IQ",
                            ckl: "ckl-Latn-ZZ",
                            cko: "cko-Latn-ZZ",
                            cky: "cky-Latn-ZZ",
                            cla: "cla-Latn-ZZ",
                            cme: "cme-Latn-ZZ",
                            cmg: "cmg-Soyo-MN",
                            co: "co-Latn-FR",
                            cop: "cop-Copt-EG",
                            cps: "cps-Latn-PH",
                            cr: "cr-Cans-CA",
                            crh: "crh-Cyrl-UA",
                            crj: "crj-Cans-CA",
                            crk: "crk-Cans-CA",
                            crl: "crl-Cans-CA",
                            crm: "crm-Cans-CA",
                            crs: "crs-Latn-SC",
                            cs: "cs-Latn-CZ",
                            csb: "csb-Latn-PL",
                            csw: "csw-Cans-CA",
                            ctd: "ctd-Pauc-MM",
                            cu: "cu-Cyrl-RU",
                            "cu-Glag": "cu-Glag-BG",
                            cv: "cv-Cyrl-RU",
                            cy: "cy-Latn-GB",
                            da: "da-Latn-DK",
                            dad: "dad-Latn-ZZ",
                            daf: "daf-Latn-ZZ",
                            dag: "dag-Latn-ZZ",
                            dah: "dah-Latn-ZZ",
                            dak: "dak-Latn-US",
                            dar: "dar-Cyrl-RU",
                            dav: "dav-Latn-KE",
                            dbd: "dbd-Latn-ZZ",
                            dbq: "dbq-Latn-ZZ",
                            dcc: "dcc-Arab-IN",
                            ddn: "ddn-Latn-ZZ",
                            de: "de-Latn-DE",
                            ded: "ded-Latn-ZZ",
                            den: "den-Latn-CA",
                            dga: "dga-Latn-ZZ",
                            dgh: "dgh-Latn-ZZ",
                            dgi: "dgi-Latn-ZZ",
                            dgl: "dgl-Arab-ZZ",
                            dgr: "dgr-Latn-CA",
                            dgz: "dgz-Latn-ZZ",
                            dia: "dia-Latn-ZZ",
                            dje: "dje-Latn-NE",
                            dnj: "dnj-Latn-CI",
                            dob: "dob-Latn-ZZ",
                            doi: "doi-Arab-IN",
                            dop: "dop-Latn-ZZ",
                            dow: "dow-Latn-ZZ",
                            drh: "drh-Mong-CN",
                            dri: "dri-Latn-ZZ",
                            drs: "drs-Ethi-ZZ",
                            dsb: "dsb-Latn-DE",
                            dtm: "dtm-Latn-ML",
                            dtp: "dtp-Latn-MY",
                            dts: "dts-Latn-ZZ",
                            dty: "dty-Deva-NP",
                            dua: "dua-Latn-CM",
                            duc: "duc-Latn-ZZ",
                            dud: "dud-Latn-ZZ",
                            dug: "dug-Latn-ZZ",
                            dv: "dv-Thaa-MV",
                            dva: "dva-Latn-ZZ",
                            dww: "dww-Latn-ZZ",
                            dyo: "dyo-Latn-SN",
                            dyu: "dyu-Latn-BF",
                            dz: "dz-Tibt-BT",
                            dzg: "dzg-Latn-ZZ",
                            ebu: "ebu-Latn-KE",
                            ee: "ee-Latn-GH",
                            efi: "efi-Latn-NG",
                            egl: "egl-Latn-IT",
                            egy: "egy-Egyp-EG",
                            eka: "eka-Latn-ZZ",
                            eky: "eky-Kali-MM",
                            el: "el-Grek-GR",
                            ema: "ema-Latn-ZZ",
                            emi: "emi-Latn-ZZ",
                            en: "en-Latn-US",
                            "en-Shaw": "en-Shaw-GB",
                            enn: "enn-Latn-ZZ",
                            enq: "enq-Latn-ZZ",
                            eo: "eo-Latn-001",
                            eri: "eri-Latn-ZZ",
                            es: "es-Latn-ES",
                            esg: "esg-Gonm-IN",
                            esu: "esu-Latn-US",
                            et: "et-Latn-EE",
                            etr: "etr-Latn-ZZ",
                            ett: "ett-Ital-IT",
                            etu: "etu-Latn-ZZ",
                            etx: "etx-Latn-ZZ",
                            eu: "eu-Latn-ES",
                            ewo: "ewo-Latn-CM",
                            ext: "ext-Latn-ES",
                            fa: "fa-Arab-IR",
                            faa: "faa-Latn-ZZ",
                            fab: "fab-Latn-ZZ",
                            fag: "fag-Latn-ZZ",
                            fai: "fai-Latn-ZZ",
                            fan: "fan-Latn-GQ",
                            ff: "ff-Latn-SN",
                            "ff-Adlm": "ff-Adlm-GN",
                            ffi: "ffi-Latn-ZZ",
                            ffm: "ffm-Latn-ML",
                            fi: "fi-Latn-FI",
                            fia: "fia-Arab-SD",
                            fil: "fil-Latn-PH",
                            fit: "fit-Latn-SE",
                            fj: "fj-Latn-FJ",
                            flr: "flr-Latn-ZZ",
                            fmp: "fmp-Latn-ZZ",
                            fo: "fo-Latn-FO",
                            fod: "fod-Latn-ZZ",
                            fon: "fon-Latn-BJ",
                            for: "for-Latn-ZZ",
                            fpe: "fpe-Latn-ZZ",
                            fqs: "fqs-Latn-ZZ",
                            fr: "fr-Latn-FR",
                            frc: "frc-Latn-US",
                            frp: "frp-Latn-FR",
                            frr: "frr-Latn-DE",
                            frs: "frs-Latn-DE",
                            fub: "fub-Arab-CM",
                            fud: "fud-Latn-WF",
                            fue: "fue-Latn-ZZ",
                            fuf: "fuf-Latn-GN",
                            fuh: "fuh-Latn-ZZ",
                            fuq: "fuq-Latn-NE",
                            fur: "fur-Latn-IT",
                            fuv: "fuv-Latn-NG",
                            fuy: "fuy-Latn-ZZ",
                            fvr: "fvr-Latn-SD",
                            fy: "fy-Latn-NL",
                            ga: "ga-Latn-IE",
                            gaa: "gaa-Latn-GH",
                            gaf: "gaf-Latn-ZZ",
                            gag: "gag-Latn-MD",
                            gah: "gah-Latn-ZZ",
                            gaj: "gaj-Latn-ZZ",
                            gam: "gam-Latn-ZZ",
                            gan: "gan-Hans-CN",
                            gaw: "gaw-Latn-ZZ",
                            gay: "gay-Latn-ID",
                            gba: "gba-Latn-ZZ",
                            gbf: "gbf-Latn-ZZ",
                            gbm: "gbm-Deva-IN",
                            gby: "gby-Latn-ZZ",
                            gbz: "gbz-Arab-IR",
                            gcr: "gcr-Latn-GF",
                            gd: "gd-Latn-GB",
                            gde: "gde-Latn-ZZ",
                            gdn: "gdn-Latn-ZZ",
                            gdr: "gdr-Latn-ZZ",
                            geb: "geb-Latn-ZZ",
                            gej: "gej-Latn-ZZ",
                            gel: "gel-Latn-ZZ",
                            gez: "gez-Ethi-ET",
                            gfk: "gfk-Latn-ZZ",
                            ggn: "ggn-Deva-NP",
                            ghs: "ghs-Latn-ZZ",
                            gil: "gil-Latn-KI",
                            gim: "gim-Latn-ZZ",
                            gjk: "gjk-Arab-PK",
                            gjn: "gjn-Latn-ZZ",
                            gju: "gju-Arab-PK",
                            gkn: "gkn-Latn-ZZ",
                            gkp: "gkp-Latn-ZZ",
                            gl: "gl-Latn-ES",
                            glk: "glk-Arab-IR",
                            gmm: "gmm-Latn-ZZ",
                            gmv: "gmv-Ethi-ZZ",
                            gn: "gn-Latn-PY",
                            gnd: "gnd-Latn-ZZ",
                            gng: "gng-Latn-ZZ",
                            god: "god-Latn-ZZ",
                            gof: "gof-Ethi-ZZ",
                            goi: "goi-Latn-ZZ",
                            gom: "gom-Deva-IN",
                            gon: "gon-Telu-IN",
                            gor: "gor-Latn-ID",
                            gos: "gos-Latn-NL",
                            got: "got-Goth-UA",
                            grb: "grb-Latn-ZZ",
                            grc: "grc-Cprt-CY",
                            "grc-Linb": "grc-Linb-GR",
                            grt: "grt-Beng-IN",
                            grw: "grw-Latn-ZZ",
                            gsw: "gsw-Latn-CH",
                            gu: "gu-Gujr-IN",
                            gub: "gub-Latn-BR",
                            guc: "guc-Latn-CO",
                            gud: "gud-Latn-ZZ",
                            gur: "gur-Latn-GH",
                            guw: "guw-Latn-ZZ",
                            gux: "gux-Latn-ZZ",
                            guz: "guz-Latn-KE",
                            gv: "gv-Latn-IM",
                            gvf: "gvf-Latn-ZZ",
                            gvr: "gvr-Deva-NP",
                            gvs: "gvs-Latn-ZZ",
                            gwc: "gwc-Arab-ZZ",
                            gwi: "gwi-Latn-CA",
                            gwt: "gwt-Arab-ZZ",
                            gyi: "gyi-Latn-ZZ",
                            ha: "ha-Latn-NG",
                            "ha-CM": "ha-Arab-CM",
                            "ha-SD": "ha-Arab-SD",
                            hag: "hag-Latn-ZZ",
                            hak: "hak-Hans-CN",
                            ham: "ham-Latn-ZZ",
                            haw: "haw-Latn-US",
                            haz: "haz-Arab-AF",
                            hbb: "hbb-Latn-ZZ",
                            hdy: "hdy-Ethi-ZZ",
                            he: "he-Hebr-IL",
                            hhy: "hhy-Latn-ZZ",
                            hi: "hi-Deva-IN",
                            hia: "hia-Latn-ZZ",
                            hif: "hif-Latn-FJ",
                            hig: "hig-Latn-ZZ",
                            hih: "hih-Latn-ZZ",
                            hil: "hil-Latn-PH",
                            hla: "hla-Latn-ZZ",
                            hlu: "hlu-Hluw-TR",
                            hmd: "hmd-Plrd-CN",
                            hmt: "hmt-Latn-ZZ",
                            hnd: "hnd-Arab-PK",
                            hne: "hne-Deva-IN",
                            hnj: "hnj-Hmng-LA",
                            hnn: "hnn-Latn-PH",
                            hno: "hno-Arab-PK",
                            ho: "ho-Latn-PG",
                            hoc: "hoc-Deva-IN",
                            hoj: "hoj-Deva-IN",
                            hot: "hot-Latn-ZZ",
                            hr: "hr-Latn-HR",
                            hsb: "hsb-Latn-DE",
                            hsn: "hsn-Hans-CN",
                            ht: "ht-Latn-HT",
                            hu: "hu-Latn-HU",
                            hui: "hui-Latn-ZZ",
                            hy: "hy-Armn-AM",
                            hz: "hz-Latn-NA",
                            ia: "ia-Latn-001",
                            ian: "ian-Latn-ZZ",
                            iar: "iar-Latn-ZZ",
                            iba: "iba-Latn-MY",
                            ibb: "ibb-Latn-NG",
                            iby: "iby-Latn-ZZ",
                            ica: "ica-Latn-ZZ",
                            ich: "ich-Latn-ZZ",
                            id: "id-Latn-ID",
                            idd: "idd-Latn-ZZ",
                            idi: "idi-Latn-ZZ",
                            idu: "idu-Latn-ZZ",
                            ife: "ife-Latn-TG",
                            ig: "ig-Latn-NG",
                            igb: "igb-Latn-ZZ",
                            ige: "ige-Latn-ZZ",
                            ii: "ii-Yiii-CN",
                            ijj: "ijj-Latn-ZZ",
                            ik: "ik-Latn-US",
                            ikk: "ikk-Latn-ZZ",
                            ikt: "ikt-Latn-CA",
                            ikw: "ikw-Latn-ZZ",
                            ikx: "ikx-Latn-ZZ",
                            ilo: "ilo-Latn-PH",
                            imo: "imo-Latn-ZZ",
                            in: "in-Latn-ID",
                            inh: "inh-Cyrl-RU",
                            io: "io-Latn-001",
                            iou: "iou-Latn-ZZ",
                            iri: "iri-Latn-ZZ",
                            is: "is-Latn-IS",
                            it: "it-Latn-IT",
                            iu: "iu-Cans-CA",
                            iw: "iw-Hebr-IL",
                            iwm: "iwm-Latn-ZZ",
                            iws: "iws-Latn-ZZ",
                            izh: "izh-Latn-RU",
                            izi: "izi-Latn-ZZ",
                            ja: "ja-Jpan-JP",
                            jab: "jab-Latn-ZZ",
                            jam: "jam-Latn-JM",
                            jbo: "jbo-Latn-001",
                            jbu: "jbu-Latn-ZZ",
                            jen: "jen-Latn-ZZ",
                            jgk: "jgk-Latn-ZZ",
                            jgo: "jgo-Latn-CM",
                            ji: "ji-Hebr-UA",
                            jib: "jib-Latn-ZZ",
                            jmc: "jmc-Latn-TZ",
                            jml: "jml-Deva-NP",
                            jra: "jra-Latn-ZZ",
                            jut: "jut-Latn-DK",
                            jv: "jv-Latn-ID",
                            jw: "jw-Latn-ID",
                            ka: "ka-Geor-GE",
                            kaa: "kaa-Cyrl-UZ",
                            kab: "kab-Latn-DZ",
                            kac: "kac-Latn-MM",
                            kad: "kad-Latn-ZZ",
                            kai: "kai-Latn-ZZ",
                            kaj: "kaj-Latn-NG",
                            kam: "kam-Latn-KE",
                            kao: "kao-Latn-ML",
                            kbd: "kbd-Cyrl-RU",
                            kbm: "kbm-Latn-ZZ",
                            kbp: "kbp-Latn-ZZ",
                            kbq: "kbq-Latn-ZZ",
                            kbx: "kbx-Latn-ZZ",
                            kby: "kby-Arab-NE",
                            kcg: "kcg-Latn-NG",
                            kck: "kck-Latn-ZW",
                            kcl: "kcl-Latn-ZZ",
                            kct: "kct-Latn-ZZ",
                            kde: "kde-Latn-TZ",
                            kdh: "kdh-Arab-TG",
                            kdl: "kdl-Latn-ZZ",
                            kdt: "kdt-Thai-TH",
                            kea: "kea-Latn-CV",
                            ken: "ken-Latn-CM",
                            kez: "kez-Latn-ZZ",
                            kfo: "kfo-Latn-CI",
                            kfr: "kfr-Deva-IN",
                            kfy: "kfy-Deva-IN",
                            kg: "kg-Latn-CD",
                            kge: "kge-Latn-ID",
                            kgf: "kgf-Latn-ZZ",
                            kgp: "kgp-Latn-BR",
                            kha: "kha-Latn-IN",
                            khb: "khb-Talu-CN",
                            khn: "khn-Deva-IN",
                            khq: "khq-Latn-ML",
                            khs: "khs-Latn-ZZ",
                            kht: "kht-Mymr-IN",
                            khw: "khw-Arab-PK",
                            khz: "khz-Latn-ZZ",
                            ki: "ki-Latn-KE",
                            kij: "kij-Latn-ZZ",
                            kiu: "kiu-Latn-TR",
                            kiw: "kiw-Latn-ZZ",
                            kj: "kj-Latn-NA",
                            kjd: "kjd-Latn-ZZ",
                            kjg: "kjg-Laoo-LA",
                            kjs: "kjs-Latn-ZZ",
                            kjy: "kjy-Latn-ZZ",
                            kk: "kk-Cyrl-KZ",
                            "kk-AF": "kk-Arab-AF",
                            "kk-Arab": "kk-Arab-CN",
                            "kk-CN": "kk-Arab-CN",
                            "kk-IR": "kk-Arab-IR",
                            "kk-MN": "kk-Arab-MN",
                            kkc: "kkc-Latn-ZZ",
                            kkj: "kkj-Latn-CM",
                            kl: "kl-Latn-GL",
                            kln: "kln-Latn-KE",
                            klq: "klq-Latn-ZZ",
                            klt: "klt-Latn-ZZ",
                            klx: "klx-Latn-ZZ",
                            km: "km-Khmr-KH",
                            kmb: "kmb-Latn-AO",
                            kmh: "kmh-Latn-ZZ",
                            kmo: "kmo-Latn-ZZ",
                            kms: "kms-Latn-ZZ",
                            kmu: "kmu-Latn-ZZ",
                            kmw: "kmw-Latn-ZZ",
                            kn: "kn-Knda-IN",
                            knf: "knf-Latn-GW",
                            knp: "knp-Latn-ZZ",
                            ko: "ko-Kore-KR",
                            koi: "koi-Cyrl-RU",
                            kok: "kok-Deva-IN",
                            kol: "kol-Latn-ZZ",
                            kos: "kos-Latn-FM",
                            koz: "koz-Latn-ZZ",
                            kpe: "kpe-Latn-LR",
                            kpf: "kpf-Latn-ZZ",
                            kpo: "kpo-Latn-ZZ",
                            kpr: "kpr-Latn-ZZ",
                            kpx: "kpx-Latn-ZZ",
                            kqb: "kqb-Latn-ZZ",
                            kqf: "kqf-Latn-ZZ",
                            kqs: "kqs-Latn-ZZ",
                            kqy: "kqy-Ethi-ZZ",
                            kr: "kr-Latn-ZZ",
                            krc: "krc-Cyrl-RU",
                            kri: "kri-Latn-SL",
                            krj: "krj-Latn-PH",
                            krl: "krl-Latn-RU",
                            krs: "krs-Latn-ZZ",
                            kru: "kru-Deva-IN",
                            ks: "ks-Arab-IN",
                            ksb: "ksb-Latn-TZ",
                            ksd: "ksd-Latn-ZZ",
                            ksf: "ksf-Latn-CM",
                            ksh: "ksh-Latn-DE",
                            ksj: "ksj-Latn-ZZ",
                            ksr: "ksr-Latn-ZZ",
                            ktb: "ktb-Ethi-ZZ",
                            ktm: "ktm-Latn-ZZ",
                            kto: "kto-Latn-ZZ",
                            ktr: "ktr-Latn-MY",
                            ku: "ku-Latn-TR",
                            "ku-Arab": "ku-Arab-IQ",
                            "ku-LB": "ku-Arab-LB",
                            kub: "kub-Latn-ZZ",
                            kud: "kud-Latn-ZZ",
                            kue: "kue-Latn-ZZ",
                            kuj: "kuj-Latn-ZZ",
                            kum: "kum-Cyrl-RU",
                            kun: "kun-Latn-ZZ",
                            kup: "kup-Latn-ZZ",
                            kus: "kus-Latn-ZZ",
                            kv: "kv-Cyrl-RU",
                            kvg: "kvg-Latn-ZZ",
                            kvr: "kvr-Latn-ID",
                            kvx: "kvx-Arab-PK",
                            kw: "kw-Latn-GB",
                            kwj: "kwj-Latn-ZZ",
                            kwo: "kwo-Latn-ZZ",
                            kwq: "kwq-Latn-ZZ",
                            kxa: "kxa-Latn-ZZ",
                            kxc: "kxc-Ethi-ZZ",
                            kxe: "kxe-Latn-ZZ",
                            kxm: "kxm-Thai-TH",
                            kxp: "kxp-Arab-PK",
                            kxw: "kxw-Latn-ZZ",
                            kxz: "kxz-Latn-ZZ",
                            ky: "ky-Cyrl-KG",
                            "ky-Arab": "ky-Arab-CN",
                            "ky-CN": "ky-Arab-CN",
                            "ky-Latn": "ky-Latn-TR",
                            "ky-TR": "ky-Latn-TR",
                            kye: "kye-Latn-ZZ",
                            kyx: "kyx-Latn-ZZ",
                            kzj: "kzj-Latn-MY",
                            kzr: "kzr-Latn-ZZ",
                            kzt: "kzt-Latn-MY",
                            la: "la-Latn-VA",
                            lab: "lab-Lina-GR",
                            lad: "lad-Hebr-IL",
                            lag: "lag-Latn-TZ",
                            lah: "lah-Arab-PK",
                            laj: "laj-Latn-UG",
                            las: "las-Latn-ZZ",
                            lb: "lb-Latn-LU",
                            lbe: "lbe-Cyrl-RU",
                            lbu: "lbu-Latn-ZZ",
                            lbw: "lbw-Latn-ID",
                            lcm: "lcm-Latn-ZZ",
                            lcp: "lcp-Thai-CN",
                            ldb: "ldb-Latn-ZZ",
                            led: "led-Latn-ZZ",
                            lee: "lee-Latn-ZZ",
                            lem: "lem-Latn-ZZ",
                            lep: "lep-Lepc-IN",
                            leq: "leq-Latn-ZZ",
                            leu: "leu-Latn-ZZ",
                            lez: "lez-Cyrl-RU",
                            lg: "lg-Latn-UG",
                            lgg: "lgg-Latn-ZZ",
                            li: "li-Latn-NL",
                            lia: "lia-Latn-ZZ",
                            lid: "lid-Latn-ZZ",
                            lif: "lif-Deva-NP",
                            "lif-Limb": "lif-Limb-IN",
                            lig: "lig-Latn-ZZ",
                            lih: "lih-Latn-ZZ",
                            lij: "lij-Latn-IT",
                            lis: "lis-Lisu-CN",
                            ljp: "ljp-Latn-ID",
                            lki: "lki-Arab-IR",
                            lkt: "lkt-Latn-US",
                            lle: "lle-Latn-ZZ",
                            lln: "lln-Latn-ZZ",
                            lmn: "lmn-Telu-IN",
                            lmo: "lmo-Latn-IT",
                            lmp: "lmp-Latn-ZZ",
                            ln: "ln-Latn-CD",
                            lns: "lns-Latn-ZZ",
                            lnu: "lnu-Latn-ZZ",
                            lo: "lo-Laoo-LA",
                            loj: "loj-Latn-ZZ",
                            lok: "lok-Latn-ZZ",
                            lol: "lol-Latn-CD",
                            lor: "lor-Latn-ZZ",
                            los: "los-Latn-ZZ",
                            loz: "loz-Latn-ZM",
                            lrc: "lrc-Arab-IR",
                            lt: "lt-Latn-LT",
                            ltg: "ltg-Latn-LV",
                            lu: "lu-Latn-CD",
                            lua: "lua-Latn-CD",
                            luo: "luo-Latn-KE",
                            luy: "luy-Latn-KE",
                            luz: "luz-Arab-IR",
                            lv: "lv-Latn-LV",
                            lwl: "lwl-Thai-TH",
                            lzh: "lzh-Hans-CN",
                            lzz: "lzz-Latn-TR",
                            mad: "mad-Latn-ID",
                            maf: "maf-Latn-CM",
                            mag: "mag-Deva-IN",
                            mai: "mai-Deva-IN",
                            mak: "mak-Latn-ID",
                            man: "man-Latn-GM",
                            "man-GN": "man-Nkoo-GN",
                            "man-Nkoo": "man-Nkoo-GN",
                            mas: "mas-Latn-KE",
                            maw: "maw-Latn-ZZ",
                            maz: "maz-Latn-MX",
                            mbh: "mbh-Latn-ZZ",
                            mbo: "mbo-Latn-ZZ",
                            mbq: "mbq-Latn-ZZ",
                            mbu: "mbu-Latn-ZZ",
                            mbw: "mbw-Latn-ZZ",
                            mci: "mci-Latn-ZZ",
                            mcp: "mcp-Latn-ZZ",
                            mcq: "mcq-Latn-ZZ",
                            mcr: "mcr-Latn-ZZ",
                            mcu: "mcu-Latn-ZZ",
                            mda: "mda-Latn-ZZ",
                            mde: "mde-Arab-ZZ",
                            mdf: "mdf-Cyrl-RU",
                            mdh: "mdh-Latn-PH",
                            mdj: "mdj-Latn-ZZ",
                            mdr: "mdr-Latn-ID",
                            mdx: "mdx-Ethi-ZZ",
                            med: "med-Latn-ZZ",
                            mee: "mee-Latn-ZZ",
                            mek: "mek-Latn-ZZ",
                            men: "men-Latn-SL",
                            mer: "mer-Latn-KE",
                            met: "met-Latn-ZZ",
                            meu: "meu-Latn-ZZ",
                            mfa: "mfa-Arab-TH",
                            mfe: "mfe-Latn-MU",
                            mfn: "mfn-Latn-ZZ",
                            mfo: "mfo-Latn-ZZ",
                            mfq: "mfq-Latn-ZZ",
                            mg: "mg-Latn-MG",
                            mgh: "mgh-Latn-MZ",
                            mgl: "mgl-Latn-ZZ",
                            mgo: "mgo-Latn-CM",
                            mgp: "mgp-Deva-NP",
                            mgy: "mgy-Latn-TZ",
                            mh: "mh-Latn-MH",
                            mhi: "mhi-Latn-ZZ",
                            mhl: "mhl-Latn-ZZ",
                            mi: "mi-Latn-NZ",
                            mif: "mif-Latn-ZZ",
                            min: "min-Latn-ID",
                            mis: "mis-Hatr-IQ",
                            "mis-Medf": "mis-Medf-NG",
                            miw: "miw-Latn-ZZ",
                            mk: "mk-Cyrl-MK",
                            mki: "mki-Arab-ZZ",
                            mkl: "mkl-Latn-ZZ",
                            mkp: "mkp-Latn-ZZ",
                            mkw: "mkw-Latn-ZZ",
                            ml: "ml-Mlym-IN",
                            mle: "mle-Latn-ZZ",
                            mlp: "mlp-Latn-ZZ",
                            mls: "mls-Latn-SD",
                            mmo: "mmo-Latn-ZZ",
                            mmu: "mmu-Latn-ZZ",
                            mmx: "mmx-Latn-ZZ",
                            mn: "mn-Cyrl-MN",
                            "mn-CN": "mn-Mong-CN",
                            "mn-Mong": "mn-Mong-CN",
                            mna: "mna-Latn-ZZ",
                            mnf: "mnf-Latn-ZZ",
                            mni: "mni-Beng-IN",
                            mnw: "mnw-Mymr-MM",
                            mo: "mo-Latn-RO",
                            moa: "moa-Latn-ZZ",
                            moe: "moe-Latn-CA",
                            moh: "moh-Latn-CA",
                            mos: "mos-Latn-BF",
                            mox: "mox-Latn-ZZ",
                            mpp: "mpp-Latn-ZZ",
                            mps: "mps-Latn-ZZ",
                            mpt: "mpt-Latn-ZZ",
                            mpx: "mpx-Latn-ZZ",
                            mql: "mql-Latn-ZZ",
                            mr: "mr-Deva-IN",
                            mrd: "mrd-Deva-NP",
                            mrj: "mrj-Cyrl-RU",
                            mro: "mro-Mroo-BD",
                            ms: "ms-Latn-MY",
                            "ms-CC": "ms-Arab-CC",
                            "ms-ID": "ms-Arab-ID",
                            mt: "mt-Latn-MT",
                            mtc: "mtc-Latn-ZZ",
                            mtf: "mtf-Latn-ZZ",
                            mti: "mti-Latn-ZZ",
                            mtr: "mtr-Deva-IN",
                            mua: "mua-Latn-CM",
                            mur: "mur-Latn-ZZ",
                            mus: "mus-Latn-US",
                            mva: "mva-Latn-ZZ",
                            mvn: "mvn-Latn-ZZ",
                            mvy: "mvy-Arab-PK",
                            mwk: "mwk-Latn-ML",
                            mwr: "mwr-Deva-IN",
                            mwv: "mwv-Latn-ID",
                            mww: "mww-Hmnp-US",
                            mxc: "mxc-Latn-ZW",
                            mxm: "mxm-Latn-ZZ",
                            my: "my-Mymr-MM",
                            myk: "myk-Latn-ZZ",
                            mym: "mym-Ethi-ZZ",
                            myv: "myv-Cyrl-RU",
                            myw: "myw-Latn-ZZ",
                            myx: "myx-Latn-UG",
                            myz: "myz-Mand-IR",
                            mzk: "mzk-Latn-ZZ",
                            mzm: "mzm-Latn-ZZ",
                            mzn: "mzn-Arab-IR",
                            mzp: "mzp-Latn-ZZ",
                            mzw: "mzw-Latn-ZZ",
                            mzz: "mzz-Latn-ZZ",
                            na: "na-Latn-NR",
                            nac: "nac-Latn-ZZ",
                            naf: "naf-Latn-ZZ",
                            nak: "nak-Latn-ZZ",
                            nan: "nan-Hans-CN",
                            nap: "nap-Latn-IT",
                            naq: "naq-Latn-NA",
                            nas: "nas-Latn-ZZ",
                            nb: "nb-Latn-NO",
                            nca: "nca-Latn-ZZ",
                            nce: "nce-Latn-ZZ",
                            ncf: "ncf-Latn-ZZ",
                            nch: "nch-Latn-MX",
                            nco: "nco-Latn-ZZ",
                            ncu: "ncu-Latn-ZZ",
                            nd: "nd-Latn-ZW",
                            ndc: "ndc-Latn-MZ",
                            nds: "nds-Latn-DE",
                            ne: "ne-Deva-NP",
                            neb: "neb-Latn-ZZ",
                            new: "new-Deva-NP",
                            nex: "nex-Latn-ZZ",
                            nfr: "nfr-Latn-ZZ",
                            ng: "ng-Latn-NA",
                            nga: "nga-Latn-ZZ",
                            ngb: "ngb-Latn-ZZ",
                            ngl: "ngl-Latn-MZ",
                            nhb: "nhb-Latn-ZZ",
                            nhe: "nhe-Latn-MX",
                            nhw: "nhw-Latn-MX",
                            nif: "nif-Latn-ZZ",
                            nii: "nii-Latn-ZZ",
                            nij: "nij-Latn-ID",
                            nin: "nin-Latn-ZZ",
                            niu: "niu-Latn-NU",
                            niy: "niy-Latn-ZZ",
                            niz: "niz-Latn-ZZ",
                            njo: "njo-Latn-IN",
                            nkg: "nkg-Latn-ZZ",
                            nko: "nko-Latn-ZZ",
                            nl: "nl-Latn-NL",
                            nmg: "nmg-Latn-CM",
                            nmz: "nmz-Latn-ZZ",
                            nn: "nn-Latn-NO",
                            nnf: "nnf-Latn-ZZ",
                            nnh: "nnh-Latn-CM",
                            nnk: "nnk-Latn-ZZ",
                            nnm: "nnm-Latn-ZZ",
                            nnp: "nnp-Wcho-IN",
                            no: "no-Latn-NO",
                            nod: "nod-Lana-TH",
                            noe: "noe-Deva-IN",
                            non: "non-Runr-SE",
                            nop: "nop-Latn-ZZ",
                            nou: "nou-Latn-ZZ",
                            nqo: "nqo-Nkoo-GN",
                            nr: "nr-Latn-ZA",
                            nrb: "nrb-Latn-ZZ",
                            nsk: "nsk-Cans-CA",
                            nsn: "nsn-Latn-ZZ",
                            nso: "nso-Latn-ZA",
                            nss: "nss-Latn-ZZ",
                            ntm: "ntm-Latn-ZZ",
                            ntr: "ntr-Latn-ZZ",
                            nui: "nui-Latn-ZZ",
                            nup: "nup-Latn-ZZ",
                            nus: "nus-Latn-SS",
                            nuv: "nuv-Latn-ZZ",
                            nux: "nux-Latn-ZZ",
                            nv: "nv-Latn-US",
                            nwb: "nwb-Latn-ZZ",
                            nxq: "nxq-Latn-CN",
                            nxr: "nxr-Latn-ZZ",
                            ny: "ny-Latn-MW",
                            nym: "nym-Latn-TZ",
                            nyn: "nyn-Latn-UG",
                            nzi: "nzi-Latn-GH",
                            oc: "oc-Latn-FR",
                            ogc: "ogc-Latn-ZZ",
                            okr: "okr-Latn-ZZ",
                            okv: "okv-Latn-ZZ",
                            om: "om-Latn-ET",
                            ong: "ong-Latn-ZZ",
                            onn: "onn-Latn-ZZ",
                            ons: "ons-Latn-ZZ",
                            opm: "opm-Latn-ZZ",
                            or: "or-Orya-IN",
                            oro: "oro-Latn-ZZ",
                            oru: "oru-Arab-ZZ",
                            os: "os-Cyrl-GE",
                            osa: "osa-Osge-US",
                            ota: "ota-Arab-ZZ",
                            otk: "otk-Orkh-MN",
                            ozm: "ozm-Latn-ZZ",
                            pa: "pa-Guru-IN",
                            "pa-Arab": "pa-Arab-PK",
                            "pa-PK": "pa-Arab-PK",
                            pag: "pag-Latn-PH",
                            pal: "pal-Phli-IR",
                            "pal-Phlp": "pal-Phlp-CN",
                            pam: "pam-Latn-PH",
                            pap: "pap-Latn-AW",
                            pau: "pau-Latn-PW",
                            pbi: "pbi-Latn-ZZ",
                            pcd: "pcd-Latn-FR",
                            pcm: "pcm-Latn-NG",
                            pdc: "pdc-Latn-US",
                            pdt: "pdt-Latn-CA",
                            ped: "ped-Latn-ZZ",
                            peo: "peo-Xpeo-IR",
                            pex: "pex-Latn-ZZ",
                            pfl: "pfl-Latn-DE",
                            phl: "phl-Arab-ZZ",
                            phn: "phn-Phnx-LB",
                            pil: "pil-Latn-ZZ",
                            pip: "pip-Latn-ZZ",
                            pka: "pka-Brah-IN",
                            pko: "pko-Latn-KE",
                            pl: "pl-Latn-PL",
                            pla: "pla-Latn-ZZ",
                            pms: "pms-Latn-IT",
                            png: "png-Latn-ZZ",
                            pnn: "pnn-Latn-ZZ",
                            pnt: "pnt-Grek-GR",
                            pon: "pon-Latn-FM",
                            ppa: "ppa-Deva-IN",
                            ppo: "ppo-Latn-ZZ",
                            pra: "pra-Khar-PK",
                            prd: "prd-Arab-IR",
                            prg: "prg-Latn-001",
                            ps: "ps-Arab-AF",
                            pss: "pss-Latn-ZZ",
                            pt: "pt-Latn-BR",
                            ptp: "ptp-Latn-ZZ",
                            puu: "puu-Latn-GA",
                            pwa: "pwa-Latn-ZZ",
                            qu: "qu-Latn-PE",
                            quc: "quc-Latn-GT",
                            qug: "qug-Latn-EC",
                            rai: "rai-Latn-ZZ",
                            raj: "raj-Deva-IN",
                            rao: "rao-Latn-ZZ",
                            rcf: "rcf-Latn-RE",
                            rej: "rej-Latn-ID",
                            rel: "rel-Latn-ZZ",
                            res: "res-Latn-ZZ",
                            rgn: "rgn-Latn-IT",
                            rhg: "rhg-Arab-MM",
                            ria: "ria-Latn-IN",
                            rif: "rif-Tfng-MA",
                            "rif-NL": "rif-Latn-NL",
                            rjs: "rjs-Deva-NP",
                            rkt: "rkt-Beng-BD",
                            rm: "rm-Latn-CH",
                            rmf: "rmf-Latn-FI",
                            rmo: "rmo-Latn-CH",
                            rmt: "rmt-Arab-IR",
                            rmu: "rmu-Latn-SE",
                            rn: "rn-Latn-BI",
                            rna: "rna-Latn-ZZ",
                            rng: "rng-Latn-MZ",
                            ro: "ro-Latn-RO",
                            rob: "rob-Latn-ID",
                            rof: "rof-Latn-TZ",
                            roo: "roo-Latn-ZZ",
                            rro: "rro-Latn-ZZ",
                            rtm: "rtm-Latn-FJ",
                            ru: "ru-Cyrl-RU",
                            rue: "rue-Cyrl-UA",
                            rug: "rug-Latn-SB",
                            rw: "rw-Latn-RW",
                            rwk: "rwk-Latn-TZ",
                            rwo: "rwo-Latn-ZZ",
                            ryu: "ryu-Kana-JP",
                            sa: "sa-Deva-IN",
                            saf: "saf-Latn-GH",
                            sah: "sah-Cyrl-RU",
                            saq: "saq-Latn-KE",
                            sas: "sas-Latn-ID",
                            sat: "sat-Latn-IN",
                            sav: "sav-Latn-SN",
                            saz: "saz-Saur-IN",
                            sba: "sba-Latn-ZZ",
                            sbe: "sbe-Latn-ZZ",
                            sbp: "sbp-Latn-TZ",
                            sc: "sc-Latn-IT",
                            sck: "sck-Deva-IN",
                            scl: "scl-Arab-ZZ",
                            scn: "scn-Latn-IT",
                            sco: "sco-Latn-GB",
                            scs: "scs-Latn-CA",
                            sd: "sd-Arab-PK",
                            "sd-Deva": "sd-Deva-IN",
                            "sd-Khoj": "sd-Khoj-IN",
                            "sd-Sind": "sd-Sind-IN",
                            sdc: "sdc-Latn-IT",
                            sdh: "sdh-Arab-IR",
                            se: "se-Latn-NO",
                            sef: "sef-Latn-CI",
                            seh: "seh-Latn-MZ",
                            sei: "sei-Latn-MX",
                            ses: "ses-Latn-ML",
                            sg: "sg-Latn-CF",
                            sga: "sga-Ogam-IE",
                            sgs: "sgs-Latn-LT",
                            sgw: "sgw-Ethi-ZZ",
                            sgz: "sgz-Latn-ZZ",
                            shi: "shi-Tfng-MA",
                            shk: "shk-Latn-ZZ",
                            shn: "shn-Mymr-MM",
                            shu: "shu-Arab-ZZ",
                            si: "si-Sinh-LK",
                            sid: "sid-Latn-ET",
                            sig: "sig-Latn-ZZ",
                            sil: "sil-Latn-ZZ",
                            sim: "sim-Latn-ZZ",
                            sjr: "sjr-Latn-ZZ",
                            sk: "sk-Latn-SK",
                            skc: "skc-Latn-ZZ",
                            skr: "skr-Arab-PK",
                            sks: "sks-Latn-ZZ",
                            sl: "sl-Latn-SI",
                            sld: "sld-Latn-ZZ",
                            sli: "sli-Latn-PL",
                            sll: "sll-Latn-ZZ",
                            sly: "sly-Latn-ID",
                            sm: "sm-Latn-WS",
                            sma: "sma-Latn-SE",
                            smj: "smj-Latn-SE",
                            smn: "smn-Latn-FI",
                            smp: "smp-Samr-IL",
                            smq: "smq-Latn-ZZ",
                            sms: "sms-Latn-FI",
                            sn: "sn-Latn-ZW",
                            snc: "snc-Latn-ZZ",
                            snk: "snk-Latn-ML",
                            snp: "snp-Latn-ZZ",
                            snx: "snx-Latn-ZZ",
                            sny: "sny-Latn-ZZ",
                            so: "so-Latn-SO",
                            sog: "sog-Sogd-UZ",
                            sok: "sok-Latn-ZZ",
                            soq: "soq-Latn-ZZ",
                            sou: "sou-Thai-TH",
                            soy: "soy-Latn-ZZ",
                            spd: "spd-Latn-ZZ",
                            spl: "spl-Latn-ZZ",
                            sps: "sps-Latn-ZZ",
                            sq: "sq-Latn-AL",
                            sr: "sr-Cyrl-RS",
                            "sr-ME": "sr-Latn-ME",
                            "sr-RO": "sr-Latn-RO",
                            "sr-RU": "sr-Latn-RU",
                            "sr-TR": "sr-Latn-TR",
                            srb: "srb-Sora-IN",
                            srn: "srn-Latn-SR",
                            srr: "srr-Latn-SN",
                            srx: "srx-Deva-IN",
                            ss: "ss-Latn-ZA",
                            ssd: "ssd-Latn-ZZ",
                            ssg: "ssg-Latn-ZZ",
                            ssy: "ssy-Latn-ER",
                            st: "st-Latn-ZA",
                            stk: "stk-Latn-ZZ",
                            stq: "stq-Latn-DE",
                            su: "su-Latn-ID",
                            sua: "sua-Latn-ZZ",
                            sue: "sue-Latn-ZZ",
                            suk: "suk-Latn-TZ",
                            sur: "sur-Latn-ZZ",
                            sus: "sus-Latn-GN",
                            sv: "sv-Latn-SE",
                            sw: "sw-Latn-TZ",
                            swb: "swb-Arab-YT",
                            swc: "swc-Latn-CD",
                            swg: "swg-Latn-DE",
                            swp: "swp-Latn-ZZ",
                            swv: "swv-Deva-IN",
                            sxn: "sxn-Latn-ID",
                            sxw: "sxw-Latn-ZZ",
                            syl: "syl-Beng-BD",
                            syr: "syr-Syrc-IQ",
                            szl: "szl-Latn-PL",
                            ta: "ta-Taml-IN",
                            taj: "taj-Deva-NP",
                            tal: "tal-Latn-ZZ",
                            tan: "tan-Latn-ZZ",
                            taq: "taq-Latn-ZZ",
                            tbc: "tbc-Latn-ZZ",
                            tbd: "tbd-Latn-ZZ",
                            tbf: "tbf-Latn-ZZ",
                            tbg: "tbg-Latn-ZZ",
                            tbo: "tbo-Latn-ZZ",
                            tbw: "tbw-Latn-PH",
                            tbz: "tbz-Latn-ZZ",
                            tci: "tci-Latn-ZZ",
                            tcy: "tcy-Knda-IN",
                            tdd: "tdd-Tale-CN",
                            tdg: "tdg-Deva-NP",
                            tdh: "tdh-Deva-NP",
                            tdu: "tdu-Latn-MY",
                            te: "te-Telu-IN",
                            ted: "ted-Latn-ZZ",
                            tem: "tem-Latn-SL",
                            teo: "teo-Latn-UG",
                            tet: "tet-Latn-TL",
                            tfi: "tfi-Latn-ZZ",
                            tg: "tg-Cyrl-TJ",
                            "tg-Arab": "tg-Arab-PK",
                            "tg-PK": "tg-Arab-PK",
                            tgc: "tgc-Latn-ZZ",
                            tgo: "tgo-Latn-ZZ",
                            tgu: "tgu-Latn-ZZ",
                            th: "th-Thai-TH",
                            thl: "thl-Deva-NP",
                            thq: "thq-Deva-NP",
                            thr: "thr-Deva-NP",
                            ti: "ti-Ethi-ET",
                            tif: "tif-Latn-ZZ",
                            tig: "tig-Ethi-ER",
                            tik: "tik-Latn-ZZ",
                            tim: "tim-Latn-ZZ",
                            tio: "tio-Latn-ZZ",
                            tiv: "tiv-Latn-NG",
                            tk: "tk-Latn-TM",
                            tkl: "tkl-Latn-TK",
                            tkr: "tkr-Latn-AZ",
                            tkt: "tkt-Deva-NP",
                            tl: "tl-Latn-PH",
                            tlf: "tlf-Latn-ZZ",
                            tlx: "tlx-Latn-ZZ",
                            tly: "tly-Latn-AZ",
                            tmh: "tmh-Latn-NE",
                            tmy: "tmy-Latn-ZZ",
                            tn: "tn-Latn-ZA",
                            tnh: "tnh-Latn-ZZ",
                            to: "to-Latn-TO",
                            tof: "tof-Latn-ZZ",
                            tog: "tog-Latn-MW",
                            toq: "toq-Latn-ZZ",
                            tpi: "tpi-Latn-PG",
                            tpm: "tpm-Latn-ZZ",
                            tpz: "tpz-Latn-ZZ",
                            tqo: "tqo-Latn-ZZ",
                            tr: "tr-Latn-TR",
                            tru: "tru-Latn-TR",
                            trv: "trv-Latn-TW",
                            trw: "trw-Arab-ZZ",
                            ts: "ts-Latn-ZA",
                            tsd: "tsd-Grek-GR",
                            tsf: "tsf-Deva-NP",
                            tsg: "tsg-Latn-PH",
                            tsj: "tsj-Tibt-BT",
                            tsw: "tsw-Latn-ZZ",
                            tt: "tt-Cyrl-RU",
                            ttd: "ttd-Latn-ZZ",
                            tte: "tte-Latn-ZZ",
                            ttj: "ttj-Latn-UG",
                            ttr: "ttr-Latn-ZZ",
                            tts: "tts-Thai-TH",
                            ttt: "ttt-Latn-AZ",
                            tuh: "tuh-Latn-ZZ",
                            tul: "tul-Latn-ZZ",
                            tum: "tum-Latn-MW",
                            tuq: "tuq-Latn-ZZ",
                            tvd: "tvd-Latn-ZZ",
                            tvl: "tvl-Latn-TV",
                            tvu: "tvu-Latn-ZZ",
                            twh: "twh-Latn-ZZ",
                            twq: "twq-Latn-NE",
                            txg: "txg-Tang-CN",
                            ty: "ty-Latn-PF",
                            tya: "tya-Latn-ZZ",
                            tyv: "tyv-Cyrl-RU",
                            tzm: "tzm-Latn-MA",
                            ubu: "ubu-Latn-ZZ",
                            udm: "udm-Cyrl-RU",
                            ug: "ug-Arab-CN",
                            "ug-Cyrl": "ug-Cyrl-KZ",
                            "ug-KZ": "ug-Cyrl-KZ",
                            "ug-MN": "ug-Cyrl-MN",
                            uga: "uga-Ugar-SY",
                            uk: "uk-Cyrl-UA",
                            uli: "uli-Latn-FM",
                            umb: "umb-Latn-AO",
                            und: "en-Latn-US",
                            "und-002": "en-Latn-NG",
                            "und-003": "en-Latn-US",
                            "und-005": "pt-Latn-BR",
                            "und-009": "en-Latn-AU",
                            "und-011": "en-Latn-NG",
                            "und-013": "es-Latn-MX",
                            "und-014": "sw-Latn-TZ",
                            "und-015": "ar-Arab-EG",
                            "und-017": "sw-Latn-CD",
                            "und-018": "en-Latn-ZA",
                            "und-019": "en-Latn-US",
                            "und-021": "en-Latn-US",
                            "und-029": "es-Latn-CU",
                            "und-030": "zh-Hans-CN",
                            "und-034": "hi-Deva-IN",
                            "und-035": "id-Latn-ID",
                            "und-039": "it-Latn-IT",
                            "und-053": "en-Latn-AU",
                            "und-054": "en-Latn-PG",
                            "und-057": "en-Latn-GU",
                            "und-061": "sm-Latn-WS",
                            "und-142": "zh-Hans-CN",
                            "und-143": "uz-Latn-UZ",
                            "und-145": "ar-Arab-SA",
                            "und-150": "ru-Cyrl-RU",
                            "und-151": "ru-Cyrl-RU",
                            "und-154": "en-Latn-GB",
                            "und-155": "de-Latn-DE",
                            "und-202": "en-Latn-NG",
                            "und-419": "es-Latn-419",
                            "und-AD": "ca-Latn-AD",
                            "und-Adlm": "ff-Adlm-GN",
                            "und-AE": "ar-Arab-AE",
                            "und-AF": "fa-Arab-AF",
                            "und-Aghb": "lez-Aghb-RU",
                            "und-Ahom": "aho-Ahom-IN",
                            "und-AL": "sq-Latn-AL",
                            "und-AM": "hy-Armn-AM",
                            "und-AO": "pt-Latn-AO",
                            "und-AQ": "und-Latn-AQ",
                            "und-AR": "es-Latn-AR",
                            "und-Arab": "ar-Arab-EG",
                            "und-Arab-CC": "ms-Arab-CC",
                            "und-Arab-CN": "ug-Arab-CN",
                            "und-Arab-GB": "ks-Arab-GB",
                            "und-Arab-ID": "ms-Arab-ID",
                            "und-Arab-IN": "ur-Arab-IN",
                            "und-Arab-KH": "cja-Arab-KH",
                            "und-Arab-MM": "rhg-Arab-MM",
                            "und-Arab-MN": "kk-Arab-MN",
                            "und-Arab-MU": "ur-Arab-MU",
                            "und-Arab-NG": "ha-Arab-NG",
                            "und-Arab-PK": "ur-Arab-PK",
                            "und-Arab-TG": "apd-Arab-TG",
                            "und-Arab-TH": "mfa-Arab-TH",
                            "und-Arab-TJ": "fa-Arab-TJ",
                            "und-Arab-TR": "az-Arab-TR",
                            "und-Arab-YT": "swb-Arab-YT",
                            "und-Armi": "arc-Armi-IR",
                            "und-Armn": "hy-Armn-AM",
                            "und-AS": "sm-Latn-AS",
                            "und-AT": "de-Latn-AT",
                            "und-Avst": "ae-Avst-IR",
                            "und-AW": "nl-Latn-AW",
                            "und-AX": "sv-Latn-AX",
                            "und-AZ": "az-Latn-AZ",
                            "und-BA": "bs-Latn-BA",
                            "und-Bali": "ban-Bali-ID",
                            "und-Bamu": "bax-Bamu-CM",
                            "und-Bass": "bsq-Bass-LR",
                            "und-Batk": "bbc-Batk-ID",
                            "und-BD": "bn-Beng-BD",
                            "und-BE": "nl-Latn-BE",
                            "und-Beng": "bn-Beng-BD",
                            "und-BF": "fr-Latn-BF",
                            "und-BG": "bg-Cyrl-BG",
                            "und-BH": "ar-Arab-BH",
                            "und-Bhks": "sa-Bhks-IN",
                            "und-BI": "rn-Latn-BI",
                            "und-BJ": "fr-Latn-BJ",
                            "und-BL": "fr-Latn-BL",
                            "und-BN": "ms-Latn-BN",
                            "und-BO": "es-Latn-BO",
                            "und-Bopo": "zh-Bopo-TW",
                            "und-BQ": "pap-Latn-BQ",
                            "und-BR": "pt-Latn-BR",
                            "und-Brah": "pka-Brah-IN",
                            "und-Brai": "fr-Brai-FR",
                            "und-BT": "dz-Tibt-BT",
                            "und-Bugi": "bug-Bugi-ID",
                            "und-Buhd": "bku-Buhd-PH",
                            "und-BV": "und-Latn-BV",
                            "und-BY": "be-Cyrl-BY",
                            "und-Cakm": "ccp-Cakm-BD",
                            "und-Cans": "cr-Cans-CA",
                            "und-Cari": "xcr-Cari-TR",
                            "und-CD": "sw-Latn-CD",
                            "und-CF": "fr-Latn-CF",
                            "und-CG": "fr-Latn-CG",
                            "und-CH": "de-Latn-CH",
                            "und-Cham": "cjm-Cham-VN",
                            "und-Cher": "chr-Cher-US",
                            "und-CI": "fr-Latn-CI",
                            "und-CL": "es-Latn-CL",
                            "und-CM": "fr-Latn-CM",
                            "und-CN": "zh-Hans-CN",
                            "und-CO": "es-Latn-CO",
                            "und-Copt": "cop-Copt-EG",
                            "und-CP": "und-Latn-CP",
                            "und-Cprt": "grc-Cprt-CY",
                            "und-CR": "es-Latn-CR",
                            "und-CU": "es-Latn-CU",
                            "und-CV": "pt-Latn-CV",
                            "und-CW": "pap-Latn-CW",
                            "und-CY": "el-Grek-CY",
                            "und-Cyrl": "ru-Cyrl-RU",
                            "und-Cyrl-AL": "mk-Cyrl-AL",
                            "und-Cyrl-BA": "sr-Cyrl-BA",
                            "und-Cyrl-GE": "ab-Cyrl-GE",
                            "und-Cyrl-GR": "mk-Cyrl-GR",
                            "und-Cyrl-MD": "uk-Cyrl-MD",
                            "und-Cyrl-RO": "bg-Cyrl-RO",
                            "und-Cyrl-SK": "uk-Cyrl-SK",
                            "und-Cyrl-TR": "kbd-Cyrl-TR",
                            "und-Cyrl-XK": "sr-Cyrl-XK",
                            "und-CZ": "cs-Latn-CZ",
                            "und-DE": "de-Latn-DE",
                            "und-Deva": "hi-Deva-IN",
                            "und-Deva-BT": "ne-Deva-BT",
                            "und-Deva-FJ": "hif-Deva-FJ",
                            "und-Deva-MU": "bho-Deva-MU",
                            "und-Deva-PK": "btv-Deva-PK",
                            "und-DJ": "aa-Latn-DJ",
                            "und-DK": "da-Latn-DK",
                            "und-DO": "es-Latn-DO",
                            "und-Dogr": "doi-Dogr-IN",
                            "und-Dupl": "fr-Dupl-FR",
                            "und-DZ": "ar-Arab-DZ",
                            "und-EA": "es-Latn-EA",
                            "und-EC": "es-Latn-EC",
                            "und-EE": "et-Latn-EE",
                            "und-EG": "ar-Arab-EG",
                            "und-Egyp": "egy-Egyp-EG",
                            "und-EH": "ar-Arab-EH",
                            "und-Elba": "sq-Elba-AL",
                            "und-Elym": "arc-Elym-IR",
                            "und-ER": "ti-Ethi-ER",
                            "und-ES": "es-Latn-ES",
                            "und-ET": "am-Ethi-ET",
                            "und-Ethi": "am-Ethi-ET",
                            "und-EU": "en-Latn-GB",
                            "und-EZ": "de-Latn-EZ",
                            "und-FI": "fi-Latn-FI",
                            "und-FO": "fo-Latn-FO",
                            "und-FR": "fr-Latn-FR",
                            "und-GA": "fr-Latn-GA",
                            "und-GE": "ka-Geor-GE",
                            "und-Geor": "ka-Geor-GE",
                            "und-GF": "fr-Latn-GF",
                            "und-GH": "ak-Latn-GH",
                            "und-GL": "kl-Latn-GL",
                            "und-Glag": "cu-Glag-BG",
                            "und-GN": "fr-Latn-GN",
                            "und-Gong": "wsg-Gong-IN",
                            "und-Gonm": "esg-Gonm-IN",
                            "und-Goth": "got-Goth-UA",
                            "und-GP": "fr-Latn-GP",
                            "und-GQ": "es-Latn-GQ",
                            "und-GR": "el-Grek-GR",
                            "und-Gran": "sa-Gran-IN",
                            "und-Grek": "el-Grek-GR",
                            "und-Grek-TR": "bgx-Grek-TR",
                            "und-GS": "und-Latn-GS",
                            "und-GT": "es-Latn-GT",
                            "und-Gujr": "gu-Gujr-IN",
                            "und-Guru": "pa-Guru-IN",
                            "und-GW": "pt-Latn-GW",
                            "und-Hanb": "zh-Hanb-TW",
                            "und-Hang": "ko-Hang-KR",
                            "und-Hani": "zh-Hani-CN",
                            "und-Hano": "hnn-Hano-PH",
                            "und-Hans": "zh-Hans-CN",
                            "und-Hant": "zh-Hant-TW",
                            "und-Hatr": "mis-Hatr-IQ",
                            "und-Hebr": "he-Hebr-IL",
                            "und-Hebr-CA": "yi-Hebr-CA",
                            "und-Hebr-GB": "yi-Hebr-GB",
                            "und-Hebr-SE": "yi-Hebr-SE",
                            "und-Hebr-UA": "yi-Hebr-UA",
                            "und-Hebr-US": "yi-Hebr-US",
                            "und-Hira": "ja-Hira-JP",
                            "und-HK": "zh-Hant-HK",
                            "und-Hluw": "hlu-Hluw-TR",
                            "und-HM": "und-Latn-HM",
                            "und-Hmng": "hnj-Hmng-LA",
                            "und-Hmnp": "mww-Hmnp-US",
                            "und-HN": "es-Latn-HN",
                            "und-HR": "hr-Latn-HR",
                            "und-HT": "ht-Latn-HT",
                            "und-HU": "hu-Latn-HU",
                            "und-Hung": "hu-Hung-HU",
                            "und-IC": "es-Latn-IC",
                            "und-ID": "id-Latn-ID",
                            "und-IL": "he-Hebr-IL",
                            "und-IN": "hi-Deva-IN",
                            "und-IQ": "ar-Arab-IQ",
                            "und-IR": "fa-Arab-IR",
                            "und-IS": "is-Latn-IS",
                            "und-IT": "it-Latn-IT",
                            "und-Ital": "ett-Ital-IT",
                            "und-Jamo": "ko-Jamo-KR",
                            "und-Java": "jv-Java-ID",
                            "und-JO": "ar-Arab-JO",
                            "und-JP": "ja-Jpan-JP",
                            "und-Jpan": "ja-Jpan-JP",
                            "und-Kali": "eky-Kali-MM",
                            "und-Kana": "ja-Kana-JP",
                            "und-KE": "sw-Latn-KE",
                            "und-KG": "ky-Cyrl-KG",
                            "und-KH": "km-Khmr-KH",
                            "und-Khar": "pra-Khar-PK",
                            "und-Khmr": "km-Khmr-KH",
                            "und-Khoj": "sd-Khoj-IN",
                            "und-KM": "ar-Arab-KM",
                            "und-Knda": "kn-Knda-IN",
                            "und-Kore": "ko-Kore-KR",
                            "und-KP": "ko-Kore-KP",
                            "und-KR": "ko-Kore-KR",
                            "und-Kthi": "bho-Kthi-IN",
                            "und-KW": "ar-Arab-KW",
                            "und-KZ": "ru-Cyrl-KZ",
                            "und-LA": "lo-Laoo-LA",
                            "und-Lana": "nod-Lana-TH",
                            "und-Laoo": "lo-Laoo-LA",
                            "und-Latn-AF": "tk-Latn-AF",
                            "und-Latn-AM": "ku-Latn-AM",
                            "und-Latn-CN": "za-Latn-CN",
                            "und-Latn-CY": "tr-Latn-CY",
                            "und-Latn-DZ": "fr-Latn-DZ",
                            "und-Latn-ET": "en-Latn-ET",
                            "und-Latn-GE": "ku-Latn-GE",
                            "und-Latn-IR": "tk-Latn-IR",
                            "und-Latn-KM": "fr-Latn-KM",
                            "und-Latn-MA": "fr-Latn-MA",
                            "und-Latn-MK": "sq-Latn-MK",
                            "und-Latn-MM": "kac-Latn-MM",
                            "und-Latn-MO": "pt-Latn-MO",
                            "und-Latn-MR": "fr-Latn-MR",
                            "und-Latn-RU": "krl-Latn-RU",
                            "und-Latn-SY": "fr-Latn-SY",
                            "und-Latn-TN": "fr-Latn-TN",
                            "und-Latn-TW": "trv-Latn-TW",
                            "und-Latn-UA": "pl-Latn-UA",
                            "und-LB": "ar-Arab-LB",
                            "und-Lepc": "lep-Lepc-IN",
                            "und-LI": "de-Latn-LI",
                            "und-Limb": "lif-Limb-IN",
                            "und-Lina": "lab-Lina-GR",
                            "und-Linb": "grc-Linb-GR",
                            "und-Lisu": "lis-Lisu-CN",
                            "und-LK": "si-Sinh-LK",
                            "und-LS": "st-Latn-LS",
                            "und-LT": "lt-Latn-LT",
                            "und-LU": "fr-Latn-LU",
                            "und-LV": "lv-Latn-LV",
                            "und-LY": "ar-Arab-LY",
                            "und-Lyci": "xlc-Lyci-TR",
                            "und-Lydi": "xld-Lydi-TR",
                            "und-MA": "ar-Arab-MA",
                            "und-Mahj": "hi-Mahj-IN",
                            "und-Maka": "mak-Maka-ID",
                            "und-Mand": "myz-Mand-IR",
                            "und-Mani": "xmn-Mani-CN",
                            "und-Marc": "bo-Marc-CN",
                            "und-MC": "fr-Latn-MC",
                            "und-MD": "ro-Latn-MD",
                            "und-ME": "sr-Latn-ME",
                            "und-Medf": "mis-Medf-NG",
                            "und-Mend": "men-Mend-SL",
                            "und-Merc": "xmr-Merc-SD",
                            "und-Mero": "xmr-Mero-SD",
                            "und-MF": "fr-Latn-MF",
                            "und-MG": "mg-Latn-MG",
                            "und-MK": "mk-Cyrl-MK",
                            "und-ML": "bm-Latn-ML",
                            "und-Mlym": "ml-Mlym-IN",
                            "und-MM": "my-Mymr-MM",
                            "und-MN": "mn-Cyrl-MN",
                            "und-MO": "zh-Hant-MO",
                            "und-Modi": "mr-Modi-IN",
                            "und-Mong": "mn-Mong-CN",
                            "und-MQ": "fr-Latn-MQ",
                            "und-MR": "ar-Arab-MR",
                            "und-Mroo": "mro-Mroo-BD",
                            "und-MT": "mt-Latn-MT",
                            "und-Mtei": "mni-Mtei-IN",
                            "und-MU": "mfe-Latn-MU",
                            "und-Mult": "skr-Mult-PK",
                            "und-MV": "dv-Thaa-MV",
                            "und-MX": "es-Latn-MX",
                            "und-MY": "ms-Latn-MY",
                            "und-Mymr": "my-Mymr-MM",
                            "und-Mymr-IN": "kht-Mymr-IN",
                            "und-Mymr-TH": "mnw-Mymr-TH",
                            "und-MZ": "pt-Latn-MZ",
                            "und-NA": "af-Latn-NA",
                            "und-Nand": "sa-Nand-IN",
                            "und-Narb": "xna-Narb-SA",
                            "und-Nbat": "arc-Nbat-JO",
                            "und-NC": "fr-Latn-NC",
                            "und-NE": "ha-Latn-NE",
                            "und-Newa": "new-Newa-NP",
                            "und-NI": "es-Latn-NI",
                            "und-Nkoo": "man-Nkoo-GN",
                            "und-NL": "nl-Latn-NL",
                            "und-NO": "nb-Latn-NO",
                            "und-NP": "ne-Deva-NP",
                            "und-Nshu": "zhx-Nshu-CN",
                            "und-Ogam": "sga-Ogam-IE",
                            "und-Olck": "sat-Olck-IN",
                            "und-OM": "ar-Arab-OM",
                            "und-Orkh": "otk-Orkh-MN",
                            "und-Orya": "or-Orya-IN",
                            "und-Osge": "osa-Osge-US",
                            "und-Osma": "so-Osma-SO",
                            "und-PA": "es-Latn-PA",
                            "und-Palm": "arc-Palm-SY",
                            "und-Pauc": "ctd-Pauc-MM",
                            "und-PE": "es-Latn-PE",
                            "und-Perm": "kv-Perm-RU",
                            "und-PF": "fr-Latn-PF",
                            "und-PG": "tpi-Latn-PG",
                            "und-PH": "fil-Latn-PH",
                            "und-Phag": "lzh-Phag-CN",
                            "und-Phli": "pal-Phli-IR",
                            "und-Phlp": "pal-Phlp-CN",
                            "und-Phnx": "phn-Phnx-LB",
                            "und-PK": "ur-Arab-PK",
                            "und-PL": "pl-Latn-PL",
                            "und-Plrd": "hmd-Plrd-CN",
                            "und-PM": "fr-Latn-PM",
                            "und-PR": "es-Latn-PR",
                            "und-Prti": "xpr-Prti-IR",
                            "und-PS": "ar-Arab-PS",
                            "und-PT": "pt-Latn-PT",
                            "und-PW": "pau-Latn-PW",
                            "und-PY": "gn-Latn-PY",
                            "und-QA": "ar-Arab-QA",
                            "und-QO": "en-Latn-DG",
                            "und-RE": "fr-Latn-RE",
                            "und-Rjng": "rej-Rjng-ID",
                            "und-RO": "ro-Latn-RO",
                            "und-Rohg": "rhg-Rohg-MM",
                            "und-RS": "sr-Cyrl-RS",
                            "und-RU": "ru-Cyrl-RU",
                            "und-Runr": "non-Runr-SE",
                            "und-RW": "rw-Latn-RW",
                            "und-SA": "ar-Arab-SA",
                            "und-Samr": "smp-Samr-IL",
                            "und-Sarb": "xsa-Sarb-YE",
                            "und-Saur": "saz-Saur-IN",
                            "und-SC": "fr-Latn-SC",
                            "und-SD": "ar-Arab-SD",
                            "und-SE": "sv-Latn-SE",
                            "und-Sgnw": "ase-Sgnw-US",
                            "und-Shaw": "en-Shaw-GB",
                            "und-Shrd": "sa-Shrd-IN",
                            "und-SI": "sl-Latn-SI",
                            "und-Sidd": "sa-Sidd-IN",
                            "und-Sind": "sd-Sind-IN",
                            "und-Sinh": "si-Sinh-LK",
                            "und-SJ": "nb-Latn-SJ",
                            "und-SK": "sk-Latn-SK",
                            "und-SM": "it-Latn-SM",
                            "und-SN": "fr-Latn-SN",
                            "und-SO": "so-Latn-SO",
                            "und-Sogd": "sog-Sogd-UZ",
                            "und-Sogo": "sog-Sogo-UZ",
                            "und-Sora": "srb-Sora-IN",
                            "und-Soyo": "cmg-Soyo-MN",
                            "und-SR": "nl-Latn-SR",
                            "und-ST": "pt-Latn-ST",
                            "und-Sund": "su-Sund-ID",
                            "und-SV": "es-Latn-SV",
                            "und-SY": "ar-Arab-SY",
                            "und-Sylo": "syl-Sylo-BD",
                            "und-Syrc": "syr-Syrc-IQ",
                            "und-Tagb": "tbw-Tagb-PH",
                            "und-Takr": "doi-Takr-IN",
                            "und-Tale": "tdd-Tale-CN",
                            "und-Talu": "khb-Talu-CN",
                            "und-Taml": "ta-Taml-IN",
                            "und-Tang": "txg-Tang-CN",
                            "und-Tavt": "blt-Tavt-VN",
                            "und-TD": "fr-Latn-TD",
                            "und-Telu": "te-Telu-IN",
                            "und-TF": "fr-Latn-TF",
                            "und-Tfng": "zgh-Tfng-MA",
                            "und-TG": "fr-Latn-TG",
                            "und-Tglg": "fil-Tglg-PH",
                            "und-TH": "th-Thai-TH",
                            "und-Thaa": "dv-Thaa-MV",
                            "und-Thai": "th-Thai-TH",
                            "und-Thai-CN": "lcp-Thai-CN",
                            "und-Thai-KH": "kdt-Thai-KH",
                            "und-Thai-LA": "kdt-Thai-LA",
                            "und-Tibt": "bo-Tibt-CN",
                            "und-Tirh": "mai-Tirh-IN",
                            "und-TJ": "tg-Cyrl-TJ",
                            "und-TK": "tkl-Latn-TK",
                            "und-TL": "pt-Latn-TL",
                            "und-TM": "tk-Latn-TM",
                            "und-TN": "ar-Arab-TN",
                            "und-TO": "to-Latn-TO",
                            "und-TR": "tr-Latn-TR",
                            "und-TV": "tvl-Latn-TV",
                            "und-TW": "zh-Hant-TW",
                            "und-TZ": "sw-Latn-TZ",
                            "und-UA": "uk-Cyrl-UA",
                            "und-UG": "sw-Latn-UG",
                            "und-Ugar": "uga-Ugar-SY",
                            "und-UY": "es-Latn-UY",
                            "und-UZ": "uz-Latn-UZ",
                            "und-VA": "it-Latn-VA",
                            "und-Vaii": "vai-Vaii-LR",
                            "und-VE": "es-Latn-VE",
                            "und-VN": "vi-Latn-VN",
                            "und-VU": "bi-Latn-VU",
                            "und-Wara": "hoc-Wara-IN",
                            "und-Wcho": "nnp-Wcho-IN",
                            "und-WF": "fr-Latn-WF",
                            "und-WS": "sm-Latn-WS",
                            "und-XK": "sq-Latn-XK",
                            "und-Xpeo": "peo-Xpeo-IR",
                            "und-Xsux": "akk-Xsux-IQ",
                            "und-YE": "ar-Arab-YE",
                            "und-Yiii": "ii-Yiii-CN",
                            "und-YT": "fr-Latn-YT",
                            "und-Zanb": "cmg-Zanb-MN",
                            "und-ZW": "sn-Latn-ZW",
                            unr: "unr-Beng-IN",
                            "unr-Deva": "unr-Deva-NP",
                            "unr-NP": "unr-Deva-NP",
                            unx: "unx-Beng-IN",
                            uok: "uok-Latn-ZZ",
                            ur: "ur-Arab-PK",
                            uri: "uri-Latn-ZZ",
                            urt: "urt-Latn-ZZ",
                            urw: "urw-Latn-ZZ",
                            usa: "usa-Latn-ZZ",
                            utr: "utr-Latn-ZZ",
                            uvh: "uvh-Latn-ZZ",
                            uvl: "uvl-Latn-ZZ",
                            uz: "uz-Latn-UZ",
                            "uz-AF": "uz-Arab-AF",
                            "uz-Arab": "uz-Arab-AF",
                            "uz-CN": "uz-Cyrl-CN",
                            vag: "vag-Latn-ZZ",
                            vai: "vai-Vaii-LR",
                            van: "van-Latn-ZZ",
                            ve: "ve-Latn-ZA",
                            vec: "vec-Latn-IT",
                            vep: "vep-Latn-RU",
                            vi: "vi-Latn-VN",
                            vic: "vic-Latn-SX",
                            viv: "viv-Latn-ZZ",
                            vls: "vls-Latn-BE",
                            vmf: "vmf-Latn-DE",
                            vmw: "vmw-Latn-MZ",
                            vo: "vo-Latn-001",
                            vot: "vot-Latn-RU",
                            vro: "vro-Latn-EE",
                            vun: "vun-Latn-TZ",
                            vut: "vut-Latn-ZZ",
                            wa: "wa-Latn-BE",
                            wae: "wae-Latn-CH",
                            waj: "waj-Latn-ZZ",
                            wal: "wal-Ethi-ET",
                            wan: "wan-Latn-ZZ",
                            war: "war-Latn-PH",
                            wbp: "wbp-Latn-AU",
                            wbq: "wbq-Telu-IN",
                            wbr: "wbr-Deva-IN",
                            wci: "wci-Latn-ZZ",
                            wer: "wer-Latn-ZZ",
                            wgi: "wgi-Latn-ZZ",
                            whg: "whg-Latn-ZZ",
                            wib: "wib-Latn-ZZ",
                            wiu: "wiu-Latn-ZZ",
                            wiv: "wiv-Latn-ZZ",
                            wja: "wja-Latn-ZZ",
                            wji: "wji-Latn-ZZ",
                            wls: "wls-Latn-WF",
                            wmo: "wmo-Latn-ZZ",
                            wnc: "wnc-Latn-ZZ",
                            wni: "wni-Arab-KM",
                            wnu: "wnu-Latn-ZZ",
                            wo: "wo-Latn-SN",
                            wob: "wob-Latn-ZZ",
                            wos: "wos-Latn-ZZ",
                            wrs: "wrs-Latn-ZZ",
                            wsg: "wsg-Gong-IN",
                            wsk: "wsk-Latn-ZZ",
                            wtm: "wtm-Deva-IN",
                            wuu: "wuu-Hans-CN",
                            wuv: "wuv-Latn-ZZ",
                            wwa: "wwa-Latn-ZZ",
                            xav: "xav-Latn-BR",
                            xbi: "xbi-Latn-ZZ",
                            xcr: "xcr-Cari-TR",
                            xes: "xes-Latn-ZZ",
                            xh: "xh-Latn-ZA",
                            xla: "xla-Latn-ZZ",
                            xlc: "xlc-Lyci-TR",
                            xld: "xld-Lydi-TR",
                            xmf: "xmf-Geor-GE",
                            xmn: "xmn-Mani-CN",
                            xmr: "xmr-Merc-SD",
                            xna: "xna-Narb-SA",
                            xnr: "xnr-Deva-IN",
                            xog: "xog-Latn-UG",
                            xon: "xon-Latn-ZZ",
                            xpr: "xpr-Prti-IR",
                            xrb: "xrb-Latn-ZZ",
                            xsa: "xsa-Sarb-YE",
                            xsi: "xsi-Latn-ZZ",
                            xsm: "xsm-Latn-ZZ",
                            xsr: "xsr-Deva-NP",
                            xwe: "xwe-Latn-ZZ",
                            yam: "yam-Latn-ZZ",
                            yao: "yao-Latn-MZ",
                            yap: "yap-Latn-FM",
                            yas: "yas-Latn-ZZ",
                            yat: "yat-Latn-ZZ",
                            yav: "yav-Latn-CM",
                            yay: "yay-Latn-ZZ",
                            yaz: "yaz-Latn-ZZ",
                            yba: "yba-Latn-ZZ",
                            ybb: "ybb-Latn-CM",
                            yby: "yby-Latn-ZZ",
                            yer: "yer-Latn-ZZ",
                            ygr: "ygr-Latn-ZZ",
                            ygw: "ygw-Latn-ZZ",
                            yi: "yi-Hebr-001",
                            yko: "yko-Latn-ZZ",
                            yle: "yle-Latn-ZZ",
                            ylg: "ylg-Latn-ZZ",
                            yll: "yll-Latn-ZZ",
                            yml: "yml-Latn-ZZ",
                            yo: "yo-Latn-NG",
                            yon: "yon-Latn-ZZ",
                            yrb: "yrb-Latn-ZZ",
                            yre: "yre-Latn-ZZ",
                            yrl: "yrl-Latn-BR",
                            yss: "yss-Latn-ZZ",
                            yua: "yua-Latn-MX",
                            yue: "yue-Hant-HK",
                            "yue-CN": "yue-Hans-CN",
                            "yue-Hans": "yue-Hans-CN",
                            yuj: "yuj-Latn-ZZ",
                            yut: "yut-Latn-ZZ",
                            yuw: "yuw-Latn-ZZ",
                            za: "za-Latn-CN",
                            zag: "zag-Latn-SD",
                            zdj: "zdj-Arab-KM",
                            zea: "zea-Latn-NL",
                            zgh: "zgh-Tfng-MA",
                            zh: "zh-Hans-CN",
                            "zh-AU": "zh-Hant-AU",
                            "zh-BN": "zh-Hant-BN",
                            "zh-Bopo": "zh-Bopo-TW",
                            "zh-GB": "zh-Hant-GB",
                            "zh-GF": "zh-Hant-GF",
                            "zh-Hanb": "zh-Hanb-TW",
                            "zh-Hant": "zh-Hant-TW",
                            "zh-HK": "zh-Hant-HK",
                            "zh-ID": "zh-Hant-ID",
                            "zh-MO": "zh-Hant-MO",
                            "zh-MY": "zh-Hant-MY",
                            "zh-PA": "zh-Hant-PA",
                            "zh-PF": "zh-Hant-PF",
                            "zh-PH": "zh-Hant-PH",
                            "zh-SR": "zh-Hant-SR",
                            "zh-TH": "zh-Hant-TH",
                            "zh-TW": "zh-Hant-TW",
                            "zh-US": "zh-Hant-US",
                            "zh-VN": "zh-Hant-VN",
                            zhx: "zhx-Nshu-CN",
                            zia: "zia-Latn-ZZ",
                            zlm: "zlm-Latn-TG",
                            zmi: "zmi-Latn-MY",
                            zne: "zne-Latn-ZZ",
                            zu: "zu-Latn-ZA",
                            zza: "zza-Latn-TR"
                        },
                        timeData: {
                            AX: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            BQ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            CP: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            CZ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            DK: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            FI: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            ID: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            IS: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            ML: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            NE: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            RU: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SE: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SJ: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            SK: {
                                _allowed: "H",
                                _preferred: "H"
                            },
                            AS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            BT: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            DJ: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            ER: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            GH: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            IN: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            LS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            PG: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            PW: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            SO: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            TO: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            VU: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            WS: {
                                _allowed: "h H",
                                _preferred: "h"
                            },
                            "001": {
                                _allowed: "H h",
                                _preferred: "H"
                            },
                            AL: {
                                _allowed: "h H hB",
                                _preferred: "h"
                            },
                            TD: {
                                _allowed: "h H hB",
                                _preferred: "h"
                            },
                            ca_ES: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CM: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            fr_CA: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            gl_ES: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            it_CH: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            it_IT: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            LU: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            NP: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            PF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SC: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SM: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            SN: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            TF: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            VA: {
                                _allowed: "H h hB",
                                _preferred: "H"
                            },
                            CY: {
                                _allowed: "h H hb hB",
                                _preferred: "h"
                            },
                            GR: {
                                _allowed: "h H hb hB",
                                _preferred: "h"
                            },
                            CO: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            DO: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            KP: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            KR: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            NA: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            PA: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            PR: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            VE: {
                                _allowed: "h H hB hb",
                                _preferred: "h"
                            },
                            AC: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            AI: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            BW: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            BZ: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CC: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            CX: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            DG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            FK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GB: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            GI: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IE: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IM: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            IO: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            JE: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            LT: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MK: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MN: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            MS: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NF: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NG: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NR: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            NU: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            PN: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            SH: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            SX: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            TA: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            ZA: {
                                _allowed: "H h hb hB",
                                _preferred: "H"
                            },
                            af_ZA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            AR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CL: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            CU: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            EA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_BO: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_BR: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_EC: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_ES: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_GQ: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            es_PE: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            GT: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            HN: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            IC: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            KG: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            KM: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            LK: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            MA: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            MX: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            NI: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            PY: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            SV: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            UY: {
                                _allowed: "H h hB hb",
                                _preferred: "H"
                            },
                            JP: {
                                _allowed: "H h K",
                                _preferred: "H"
                            },
                            AD: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AM: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AO: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            AW: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BJ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CG: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CI: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            CV: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            DE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            EE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            FR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GA: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GN: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GP: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            GW: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            HR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            IL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            IT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            KZ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MC: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MD: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MQ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            MZ: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            NC: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            NL: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            PM: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            PT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            RE: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            RO: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            SI: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            SR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            ST: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            TG: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            TR: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            WF: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            YT: {
                                _allowed: "H hB",
                                _preferred: "H"
                            },
                            BD: {
                                _allowed: "h hB H",
                                _preferred: "h"
                            },
                            PK: {
                                _allowed: "h hB H",
                                _preferred: "h"
                            },
                            AZ: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            BA: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            BG: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            CH: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            GE: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            LI: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            ME: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            RS: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            UA: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            UZ: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            XK: {
                                _allowed: "H hB h",
                                _preferred: "H"
                            },
                            AG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            AU: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BB: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BS: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            CA: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            DM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            en_001: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            FJ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            FM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GD: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GU: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            GY: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            JM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KI: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KN: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            KY: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            LC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            LR: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MH: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MP: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            MW: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            NZ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SB: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SL: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SS: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            SZ: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            TC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            TT: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            UM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            US: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VC: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VG: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            VI: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            ZM: {
                                _allowed: "h hb H hB",
                                _preferred: "h"
                            },
                            BO: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            EC: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            ES: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            GQ: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            PE: {
                                _allowed: "H hB h hb",
                                _preferred: "H"
                            },
                            AE: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            ar_001: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            BH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            DZ: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            EG: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            EH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            IQ: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            JO: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            KW: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            LB: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            LY: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            MR: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            OM: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            PH: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            PS: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            QA: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SA: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SD: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            SY: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            TN: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            YE: {
                                _allowed: "h hB hb H",
                                _preferred: "h"
                            },
                            AF: {
                                _allowed: "H hb hB h",
                                _preferred: "H"
                            },
                            LA: {
                                _allowed: "H hb hB h",
                                _preferred: "H"
                            },
                            LV: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            TL: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            zu_ZA: {
                                _allowed: "H hB hb h",
                                _preferred: "H"
                            },
                            CD: {
                                _allowed: "hB H",
                                _preferred: "H"
                            },
                            IR: {
                                _allowed: "hB H",
                                _preferred: "H"
                            },
                            hi_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            kn_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            ml_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            te_IN: {
                                _allowed: "hB h H",
                                _preferred: "h"
                            },
                            KH: {
                                _allowed: "hB h H hb",
                                _preferred: "h"
                            },
                            ta_IN: {
                                _allowed: "hB h hb H",
                                _preferred: "h"
                            },
                            BN: {
                                _allowed: "hb hB h H",
                                _preferred: "h"
                            },
                            MY: {
                                _allowed: "hb hB h H",
                                _preferred: "h"
                            },
                            CN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            ET: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            gu_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            HK: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            MO: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            mr_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            pa_IN: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            TW: {
                                _allowed: "hB hb h H",
                                _preferred: "h"
                            },
                            KE: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            MM: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            TZ: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            },
                            UG: {
                                _allowed: "hB hb H h",
                                _preferred: "H"
                            }
                        },
                        weekData: {
                            minDays: {
                                "001": "1",
                                AD: "4",
                                AN: "4",
                                AT: "4",
                                AX: "4",
                                BE: "4",
                                BG: "4",
                                CH: "4",
                                CZ: "4",
                                DE: "4",
                                DK: "4",
                                EE: "4",
                                ES: "4",
                                FI: "4",
                                FJ: "4",
                                FO: "4",
                                FR: "4",
                                GB: "4",
                                GF: "4",
                                GG: "4",
                                GI: "4",
                                GP: "4",
                                GR: "4",
                                GU: "1",
                                HU: "4",
                                IE: "4",
                                IM: "4",
                                IS: "4",
                                IT: "4",
                                JE: "4",
                                LI: "4",
                                LT: "4",
                                LU: "4",
                                MC: "4",
                                MQ: "4",
                                NL: "4",
                                NO: "4",
                                PL: "4",
                                PT: "4",
                                RE: "4",
                                RU: "4",
                                SE: "4",
                                SJ: "4",
                                SK: "4",
                                SM: "4",
                                UM: "1",
                                US: "1",
                                VA: "4",
                                VI: "1"
                            },
                            firstDay: {
                                "001": "mon",
                                AD: "mon",
                                AE: "sat",
                                AF: "sat",
                                AG: "sun",
                                AI: "mon",
                                AL: "mon",
                                AM: "mon",
                                AN: "mon",
                                AR: "mon",
                                AS: "sun",
                                AT: "mon",
                                AU: "sun",
                                AX: "mon",
                                AZ: "mon",
                                BA: "mon",
                                BD: "sun",
                                BE: "mon",
                                BG: "mon",
                                BH: "sat",
                                BM: "mon",
                                BN: "mon",
                                BR: "sun",
                                BS: "sun",
                                BT: "sun",
                                BW: "sun",
                                BY: "mon",
                                BZ: "sun",
                                CA: "sun",
                                CH: "mon",
                                CL: "mon",
                                CM: "mon",
                                CN: "sun",
                                CO: "sun",
                                CR: "mon",
                                CY: "mon",
                                CZ: "mon",
                                DE: "mon",
                                DJ: "sat",
                                DK: "mon",
                                DM: "sun",
                                DO: "sun",
                                DZ: "sat",
                                EC: "mon",
                                EE: "mon",
                                EG: "sat",
                                ES: "mon",
                                ET: "sun",
                                FI: "mon",
                                FJ: "mon",
                                FO: "mon",
                                FR: "mon",
                                GB: "mon",
                                "GB-alt-variant": "sun",
                                GE: "mon",
                                GF: "mon",
                                GP: "mon",
                                GR: "mon",
                                GT: "sun",
                                GU: "sun",
                                HK: "sun",
                                HN: "sun",
                                HR: "mon",
                                HU: "mon",
                                ID: "sun",
                                IE: "mon",
                                IL: "sun",
                                IN: "sun",
                                IQ: "sat",
                                IR: "sat",
                                IS: "mon",
                                IT: "mon",
                                JM: "sun",
                                JO: "sat",
                                JP: "sun",
                                KE: "sun",
                                KG: "mon",
                                KH: "sun",
                                KR: "sun",
                                KW: "sat",
                                KZ: "mon",
                                LA: "sun",
                                LB: "mon",
                                LI: "mon",
                                LK: "mon",
                                LT: "mon",
                                LU: "mon",
                                LV: "mon",
                                LY: "sat",
                                MC: "mon",
                                MD: "mon",
                                ME: "mon",
                                MH: "sun",
                                MK: "mon",
                                MM: "sun",
                                MN: "mon",
                                MO: "sun",
                                MQ: "mon",
                                MT: "sun",
                                MV: "fri",
                                MX: "sun",
                                MY: "mon",
                                MZ: "sun",
                                NI: "sun",
                                NL: "mon",
                                NO: "mon",
                                NP: "sun",
                                NZ: "mon",
                                OM: "sat",
                                PA: "sun",
                                PE: "sun",
                                PH: "sun",
                                PK: "sun",
                                PL: "mon",
                                PR: "sun",
                                PT: "sun",
                                PY: "sun",
                                QA: "sat",
                                RE: "mon",
                                RO: "mon",
                                RS: "mon",
                                RU: "mon",
                                SA: "sun",
                                SD: "sat",
                                SE: "mon",
                                SG: "sun",
                                SI: "mon",
                                SK: "mon",
                                SM: "mon",
                                SV: "sun",
                                SY: "sat",
                                TH: "sun",
                                TJ: "mon",
                                TM: "mon",
                                TR: "mon",
                                TT: "sun",
                                TW: "sun",
                                UA: "mon",
                                UM: "sun",
                                US: "sun",
                                UY: "mon",
                                UZ: "mon",
                                VA: "mon",
                                VE: "sun",
                                VI: "sun",
                                VN: "mon",
                                WS: "sun",
                                XK: "mon",
                                YE: "sun",
                                ZA: "sun",
                                ZW: "sun"
                            },
                            weekendStart: {
                                "001": "sat",
                                AE: "fri",
                                AF: "thu",
                                BH: "fri",
                                DZ: "fri",
                                EG: "fri",
                                IL: "fri",
                                IN: "sun",
                                IQ: "fri",
                                IR: "fri",
                                JO: "fri",
                                KW: "fri",
                                LY: "fri",
                                OM: "fri",
                                QA: "fri",
                                SA: "fri",
                                SD: "fri",
                                SY: "fri",
                                UG: "sun",
                                YE: "fri"
                            },
                            weekendEnd: {
                                "001": "sun",
                                AE: "sat",
                                AF: "fri",
                                BH: "sat",
                                DZ: "sat",
                                EG: "sat",
                                IL: "sat",
                                IQ: "sat",
                                IR: "fri",
                                JO: "sat",
                                KW: "sat",
                                LY: "sat",
                                OM: "sat",
                                QA: "sat",
                                SA: "sat",
                                SD: "sat",
                                SY: "sat",
                                YE: "sat"
                            },
                            af: {
                                _ordering: "weekOfDate weekOfInterval weekOfMonth"
                            },
                            "am az bs cs cy da el et hi ky lt mk sk ta th": {
                                _ordering: "weekOfYear weekOfMonth"
                            },
                            "ar fil gu hu hy id kk ko": {
                                _ordering: "weekOfMonth"
                            },
                            "be ro ru": {
                                _ordering: "weekOfInterval weekOfMonth"
                            },
                            "bg de iw pt ur zh": {
                                _ordering: "weekOfDate weekOfMonth weekOfInterval"
                            },
                            "ca es fr gl": {
                                _ordering: "weekOfDate"
                            },
                            "en bn ja ka": {
                                _ordering: "weekOfDate weekOfMonth"
                            },
                            eu: {
                                _ordering: "weekOfMonth weekOfDate"
                            },
                            "fa hr it lv pl si sr uk uz": {
                                _ordering: "weekOfMonth weekOfInterval"
                            },
                            "fi zh-TW": {
                                _ordering: "weekOfYear weekOfDate weekOfMonth"
                            },
                            "is mn no sv vi": {
                                _ordering: "weekOfYear weekOfMonth weekOfInterval"
                            },
                            "km mr": {
                                _ordering: "weekOfMonth weekOfYear"
                            },
                            "kn ml pa": {
                                _ordering: "weekOfMonth weekOfDate weekOfYear"
                            },
                            "lo sq": {
                                _ordering: "weekOfMonth weekOfInterval weekOfDate weekOfYear"
                            },
                            "ms tr": {
                                _ordering: "weekOfMonth weekOfYear weekOfInterval weekOfDate"
                            },
                            nl: {
                                _ordering: "weekOfDate weekOfYear weekOfMonth"
                            },
                            sl: {
                                _ordering: "weekOfInterval"
                            },
                            "sw te": {
                                _ordering: "weekOfMonth weekOfInterval weekOfYear"
                            },
                            und: {
                                _ordering: "weekOfYear"
                            },
                            zu: {
                                _ordering: "weekOfYear weekOfInterval"
                            }
                        },
                        currencyData: {
                            fractions: {
                                ADP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                AFN: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ALL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                AMD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                BHD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                BIF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                BYN: {
                                    _rounding: "0",
                                    _digits: "2"
                                },
                                BYR: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                CAD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "5"
                                },
                                CHF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "5"
                                },
                                CLF: {
                                    _rounding: "0",
                                    _digits: "4"
                                },
                                CLP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                COP: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                CRC: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                CZK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                DEFAULT: {
                                    _rounding: "0",
                                    _digits: "2"
                                },
                                DJF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                DKK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "50"
                                },
                                ESP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                GNF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                GYD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                HUF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                IDR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                IQD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                IRR: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ISK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ITL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                JOD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                JPY: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KMF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KPW: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KRW: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                KWD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                LAK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LBP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LUF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                LYD: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                MGA: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MGF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MMK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MNT: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                MRO: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                MUR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                NOK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                OMR: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                PKR: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                PYG: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                RSD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                RWF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SEK: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                SLL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SOS: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                STD: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                SYP: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TMM: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TND: {
                                    _rounding: "0",
                                    _digits: "3"
                                },
                                TRL: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                TWD: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                TZS: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                UGX: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                UYI: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                UYW: {
                                    _rounding: "0",
                                    _digits: "4"
                                },
                                UZS: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                VEF: {
                                    _rounding: "0",
                                    _digits: "2",
                                    _cashRounding: "0",
                                    _cashDigits: "0"
                                },
                                VND: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                VUV: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XAF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XOF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                XPF: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                YER: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ZMK: {
                                    _rounding: "0",
                                    _digits: "0"
                                },
                                ZWD: {
                                    _rounding: "0",
                                    _digits: "0"
                                }
                            },
                            region: {
                                AC: [{
                                    SHP: {
                                        _from: "1976-01-01"
                                    }
                                }],
                                AD: [{
                                    ESP: {
                                        _from: "1873-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    ADP: {
                                        _from: "1936-01-01",
                                        _to: "2001-12-31"
                                    }
                                }, {
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AE: [{
                                    AED: {
                                        _from: "1973-05-19"
                                    }
                                }],
                                AF: [{
                                    AFA: {
                                        _from: "1927-03-14",
                                        _to: "2002-12-31"
                                    }
                                }, {
                                    AFN: {
                                        _from: "2002-10-07"
                                    }
                                }],
                                AG: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                AI: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                AL: [{
                                    ALK: {
                                        _from: "1946-11-01",
                                        _to: "1965-08-16"
                                    }
                                }, {
                                    ALL: {
                                        _from: "1965-08-16"
                                    }
                                }],
                                AM: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-11-22"
                                    }
                                }, {
                                    AMD: {
                                        _from: "1993-11-22"
                                    }
                                }],
                                AO: [{
                                    AOK: {
                                        _from: "1977-01-08",
                                        _to: "1991-03-01"
                                    }
                                }, {
                                    AON: {
                                        _from: "1990-09-25",
                                        _to: "2000-02-01"
                                    }
                                }, {
                                    AOR: {
                                        _from: "1995-07-01",
                                        _to: "2000-02-01"
                                    }
                                }, {
                                    AOA: {
                                        _from: "1999-12-13"
                                    }
                                }],
                                AQ: [{
                                    XXX: {
                                        _tender: "false"
                                    }
                                }],
                                AR: [{
                                    ARM: {
                                        _from: "1881-11-05",
                                        _to: "1970-01-01"
                                    }
                                }, {
                                    ARL: {
                                        _from: "1970-01-01",
                                        _to: "1983-06-01"
                                    }
                                }, {
                                    ARP: {
                                        _from: "1983-06-01",
                                        _to: "1985-06-14"
                                    }
                                }, {
                                    ARA: {
                                        _from: "1985-06-14",
                                        _to: "1992-01-01"
                                    }
                                }, {
                                    ARS: {
                                        _from: "1992-01-01"
                                    }
                                }],
                                AS: [{
                                    USD: {
                                        _from: "1904-07-16"
                                    }
                                }],
                                AT: [{
                                    ATS: {
                                        _from: "1947-12-04",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AU: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                AW: [{
                                    ANG: {
                                        _from: "1940-05-10",
                                        _to: "1986-01-01"
                                    }
                                }, {
                                    AWG: {
                                        _from: "1986-01-01"
                                    }
                                }],
                                AX: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                AZ: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1994-01-01"
                                    }
                                }, {
                                    AZM: {
                                        _from: "1993-11-22",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    AZN: {
                                        _from: "2006-01-01"
                                    }
                                }],
                                BA: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1992-07-01"
                                    }
                                }, {
                                    YUR: {
                                        _from: "1992-07-01",
                                        _to: "1993-10-01"
                                    }
                                }, {
                                    BAD: {
                                        _from: "1992-07-01",
                                        _to: "1994-08-15"
                                    }
                                }, {
                                    BAN: {
                                        _from: "1994-08-15",
                                        _to: "1997-07-01"
                                    }
                                }, {
                                    BAM: {
                                        _from: "1995-01-01"
                                    }
                                }],
                                BB: [{
                                    XCD: {
                                        _from: "1965-10-06",
                                        _to: "1973-12-03"
                                    }
                                }, {
                                    BBD: {
                                        _from: "1973-12-03"
                                    }
                                }],
                                BD: [{
                                    INR: {
                                        _from: "1835-08-17",
                                        _to: "1948-04-01"
                                    }
                                }, {
                                    PKR: {
                                        _from: "1948-04-01",
                                        _to: "1972-01-01"
                                    }
                                }, {
                                    BDT: {
                                        _from: "1972-01-01"
                                    }
                                }],
                                BE: [{
                                    NLG: {
                                        _from: "1816-12-15",
                                        _to: "1831-02-07"
                                    }
                                }, {
                                    BEF: {
                                        _from: "1831-02-07",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    BEC: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    BEL: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                BF: [{
                                    XOF: {
                                        _from: "1984-08-04"
                                    }
                                }],
                                BG: [{
                                    BGO: {
                                        _from: "1879-07-08",
                                        _to: "1952-05-12"
                                    }
                                }, {
                                    BGM: {
                                        _from: "1952-05-12",
                                        _to: "1962-01-01"
                                    }
                                }, {
                                    BGL: {
                                        _from: "1962-01-01",
                                        _to: "1999-07-05"
                                    }
                                }, {
                                    BGN: {
                                        _from: "1999-07-05"
                                    }
                                }],
                                BH: [{
                                    BHD: {
                                        _from: "1965-10-16"
                                    }
                                }],
                                BI: [{
                                    BIF: {
                                        _from: "1964-05-19"
                                    }
                                }],
                                BJ: [{
                                    XOF: {
                                        _from: "1975-11-30"
                                    }
                                }],
                                BL: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                BM: [{
                                    BMD: {
                                        _from: "1970-02-06"
                                    }
                                }],
                                BN: [{
                                    MYR: {
                                        _from: "1963-09-16",
                                        _to: "1967-06-12"
                                    }
                                }, {
                                    BND: {
                                        _from: "1967-06-12"
                                    }
                                }],
                                BO: [{
                                    BOV: {
                                        _tender: "false"
                                    }
                                }, {
                                    BOL: {
                                        _from: "1863-06-23",
                                        _to: "1963-01-01"
                                    }
                                }, {
                                    BOP: {
                                        _from: "1963-01-01",
                                        _to: "1986-12-31"
                                    }
                                }, {
                                    BOB: {
                                        _from: "1987-01-01"
                                    }
                                }],
                                BQ: [{
                                    ANG: {
                                        _from: "2010-10-10",
                                        _to: "2011-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "2011-01-01"
                                    }
                                }],
                                BR: [{
                                    BRZ: {
                                        _from: "1942-11-01",
                                        _to: "1967-02-13"
                                    }
                                }, {
                                    BRB: {
                                        _from: "1967-02-13",
                                        _to: "1986-02-28"
                                    }
                                }, {
                                    BRC: {
                                        _from: "1986-02-28",
                                        _to: "1989-01-15"
                                    }
                                }, {
                                    BRN: {
                                        _from: "1989-01-15",
                                        _to: "1990-03-16"
                                    }
                                }, {
                                    BRE: {
                                        _from: "1990-03-16",
                                        _to: "1993-08-01"
                                    }
                                }, {
                                    BRR: {
                                        _from: "1993-08-01",
                                        _to: "1994-07-01"
                                    }
                                }, {
                                    BRL: {
                                        _from: "1994-07-01"
                                    }
                                }],
                                BS: [{
                                    BSD: {
                                        _from: "1966-05-25"
                                    }
                                }],
                                BT: [{
                                    INR: {
                                        _from: "1907-01-01"
                                    }
                                }, {
                                    BTN: {
                                        _from: "1974-04-16"
                                    }
                                }],
                                BU: [{
                                    BUK: {
                                        _from: "1952-07-01",
                                        _to: "1989-06-18"
                                    }
                                }],
                                BV: [{
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                BW: [{
                                    ZAR: {
                                        _from: "1961-02-14",
                                        _to: "1976-08-23"
                                    }
                                }, {
                                    BWP: {
                                        _from: "1976-08-23"
                                    }
                                }],
                                BY: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1994-11-08"
                                    }
                                }, {
                                    BYB: {
                                        _from: "1994-08-01",
                                        _to: "2000-12-31"
                                    }
                                }, {
                                    BYR: {
                                        _from: "2000-01-01",
                                        _to: "2017-01-01"
                                    }
                                }, {
                                    BYN: {
                                        _from: "2016-07-01"
                                    }
                                }],
                                BZ: [{
                                    BZD: {
                                        _from: "1974-01-01"
                                    }
                                }],
                                CA: [{
                                    CAD: {
                                        _from: "1858-01-01"
                                    }
                                }],
                                CC: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                CD: [{
                                    ZRZ: {
                                        _from: "1971-10-27",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    ZRN: {
                                        _from: "1993-11-01",
                                        _to: "1998-07-01"
                                    }
                                }, {
                                    CDF: {
                                        _from: "1998-07-01"
                                    }
                                }],
                                CF: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                CG: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                CH: [{
                                    CHE: {
                                        _tender: "false"
                                    }
                                }, {
                                    CHW: {
                                        _tender: "false"
                                    }
                                }, {
                                    CHF: {
                                        _from: "1799-03-17"
                                    }
                                }],
                                CI: [{
                                    XOF: {
                                        _from: "1958-12-04"
                                    }
                                }],
                                CK: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                CL: [{
                                    CLF: {
                                        _tender: "false"
                                    }
                                }, {
                                    CLE: {
                                        _from: "1960-01-01",
                                        _to: "1975-09-29"
                                    }
                                }, {
                                    CLP: {
                                        _from: "1975-09-29"
                                    }
                                }],
                                CM: [{
                                    XAF: {
                                        _from: "1973-04-01"
                                    }
                                }],
                                CN: [{
                                    CNY: {
                                        _from: "1953-03-01"
                                    }
                                }, {
                                    CNX: {
                                        _tender: "false",
                                        _from: "1979-01-01",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    CNH: {
                                        _tender: "false",
                                        _from: "2010-07-19"
                                    }
                                }],
                                CO: [{
                                    COU: {
                                        _tender: "false"
                                    }
                                }, {
                                    COP: {
                                        _from: "1905-01-01"
                                    }
                                }],
                                CP: [{
                                    XXX: {
                                        _tender: "false"
                                    }
                                }],
                                CR: [{
                                    CRC: {
                                        _from: "1896-10-26"
                                    }
                                }],
                                CS: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    CSD: {
                                        _from: "2002-05-15",
                                        _to: "2006-06-03"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2003-02-04",
                                        _to: "2006-06-03"
                                    }
                                }],
                                CU: [{
                                    CUP: {
                                        _from: "1859-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1899-01-01",
                                        _to: "1959-01-01"
                                    }
                                }, {
                                    CUC: {
                                        _from: "1994-01-01"
                                    }
                                }],
                                CV: [{
                                    PTE: {
                                        _from: "1911-05-22",
                                        _to: "1975-07-05"
                                    }
                                }, {
                                    CVE: {
                                        _from: "1914-01-01"
                                    }
                                }],
                                CW: [{
                                    ANG: {
                                        _from: "2010-10-10"
                                    }
                                }],
                                CX: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                CY: [{
                                    CYP: {
                                        _from: "1914-09-10",
                                        _to: "2008-01-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2008-01-01"
                                    }
                                }],
                                CZ: [{
                                    CSK: {
                                        _from: "1953-06-01",
                                        _to: "1993-03-01"
                                    }
                                }, {
                                    CZK: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                DD: [{
                                    DDM: {
                                        _from: "1948-07-20",
                                        _to: "1990-10-02"
                                    }
                                }],
                                DE: [{
                                    DEM: {
                                        _from: "1948-06-20",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                DG: [{
                                    USD: {
                                        _from: "1965-11-08"
                                    }
                                }],
                                DJ: [{
                                    DJF: {
                                        _from: "1977-06-27"
                                    }
                                }],
                                DK: [{
                                    DKK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                DM: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                DO: [{
                                    USD: {
                                        _from: "1905-06-21",
                                        _to: "1947-10-01"
                                    }
                                }, {
                                    DOP: {
                                        _from: "1947-10-01"
                                    }
                                }],
                                DZ: [{
                                    DZD: {
                                        _from: "1964-04-01"
                                    }
                                }],
                                EA: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                EC: [{
                                    ECS: {
                                        _from: "1884-04-01",
                                        _to: "2000-10-02"
                                    }
                                }, {
                                    ECV: {
                                        _tender: "false",
                                        _from: "1993-05-23",
                                        _to: "2000-01-09"
                                    }
                                }, {
                                    USD: {
                                        _from: "2000-10-02"
                                    }
                                }],
                                EE: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-06-20"
                                    }
                                }, {
                                    EEK: {
                                        _from: "1992-06-21",
                                        _to: "2010-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2011-01-01"
                                    }
                                }],
                                EG: [{
                                    EGP: {
                                        _from: "1885-11-14"
                                    }
                                }],
                                EH: [{
                                    MAD: {
                                        _from: "1976-02-26"
                                    }
                                }],
                                ER: [{
                                    ETB: {
                                        _from: "1993-05-24",
                                        _to: "1997-11-08"
                                    }
                                }, {
                                    ERN: {
                                        _from: "1997-11-08"
                                    }
                                }],
                                ES: [{
                                    ESP: {
                                        _from: "1868-10-19",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    ESB: {
                                        _tender: "false",
                                        _from: "1975-01-01",
                                        _to: "1994-12-31"
                                    }
                                }, {
                                    ESA: {
                                        _tender: "false",
                                        _from: "1978-01-01",
                                        _to: "1981-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                ET: [{
                                    ETB: {
                                        _from: "1976-09-15"
                                    }
                                }],
                                EU: [{
                                    XEU: {
                                        _tender: "false",
                                        _from: "1979-01-01",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                FI: [{
                                    FIM: {
                                        _from: "1963-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                FJ: [{
                                    FJD: {
                                        _from: "1969-01-13"
                                    }
                                }],
                                FK: [{
                                    FKP: {
                                        _from: "1901-01-01"
                                    }
                                }],
                                FM: [{
                                    JPY: {
                                        _from: "1914-10-03",
                                        _to: "1944-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                FO: [{
                                    DKK: {
                                        _from: "1948-01-01"
                                    }
                                }],
                                FR: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GA: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                GB: [{
                                    GBP: {
                                        _from: "1694-07-27"
                                    }
                                }],
                                GD: [{
                                    XCD: {
                                        _from: "1967-02-27"
                                    }
                                }],
                                GE: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-06-11"
                                    }
                                }, {
                                    GEK: {
                                        _from: "1993-04-05",
                                        _to: "1995-09-25"
                                    }
                                }, {
                                    GEL: {
                                        _from: "1995-09-23"
                                    }
                                }],
                                GF: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GG: [{
                                    GBP: {
                                        _from: "1830-01-01"
                                    }
                                }],
                                GH: [{
                                    GHC: {
                                        _from: "1979-03-09",
                                        _to: "2007-12-31"
                                    }
                                }, {
                                    GHS: {
                                        _from: "2007-07-03"
                                    }
                                }],
                                GI: [{
                                    GIP: {
                                        _from: "1713-01-01"
                                    }
                                }],
                                GL: [{
                                    DKK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                GM: [{
                                    GMD: {
                                        _from: "1971-07-01"
                                    }
                                }],
                                GN: [{
                                    GNS: {
                                        _from: "1972-10-02",
                                        _to: "1986-01-06"
                                    }
                                }, {
                                    GNF: {
                                        _from: "1986-01-06"
                                    }
                                }],
                                GP: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                GQ: [{
                                    GQE: {
                                        _from: "1975-07-07",
                                        _to: "1986-06-01"
                                    }
                                }, {
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                GR: [{
                                    GRD: {
                                        _from: "1954-05-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2001-01-01"
                                    }
                                }],
                                GS: [{
                                    GBP: {
                                        _from: "1908-01-01"
                                    }
                                }],
                                GT: [{
                                    GTQ: {
                                        _from: "1925-05-27"
                                    }
                                }],
                                GU: [{
                                    USD: {
                                        _from: "1944-08-21"
                                    }
                                }],
                                GW: [{
                                    GWE: {
                                        _from: "1914-01-01",
                                        _to: "1976-02-28"
                                    }
                                }, {
                                    GWP: {
                                        _from: "1976-02-28",
                                        _to: "1997-03-31"
                                    }
                                }, {
                                    XOF: {
                                        _from: "1997-03-31"
                                    }
                                }],
                                GY: [{
                                    GYD: {
                                        _from: "1966-05-26"
                                    }
                                }],
                                HK: [{
                                    HKD: {
                                        _from: "1895-02-02"
                                    }
                                }],
                                HM: [{
                                    AUD: {
                                        _from: "1967-02-16"
                                    }
                                }],
                                HN: [{
                                    HNL: {
                                        _from: "1926-04-03"
                                    }
                                }],
                                HR: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1991-12-23"
                                    }
                                }, {
                                    HRD: {
                                        _from: "1991-12-23",
                                        _to: "1995-01-01"
                                    }
                                }, {
                                    HRK: {
                                        _from: "1994-05-30"
                                    }
                                }],
                                HT: [{
                                    HTG: {
                                        _from: "1872-08-26"
                                    }
                                }, {
                                    USD: {
                                        _from: "1915-01-01"
                                    }
                                }],
                                HU: [{
                                    HUF: {
                                        _from: "1946-07-23"
                                    }
                                }],
                                IC: [{
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                ID: [{
                                    IDR: {
                                        _from: "1965-12-13"
                                    }
                                }],
                                IE: [{
                                    GBP: {
                                        _from: "1800-01-01",
                                        _to: "1922-01-01"
                                    }
                                }, {
                                    IEP: {
                                        _from: "1922-01-01",
                                        _to: "2002-02-09"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                IL: [{
                                    ILP: {
                                        _from: "1948-08-16",
                                        _to: "1980-02-22"
                                    }
                                }, {
                                    ILR: {
                                        _from: "1980-02-22",
                                        _to: "1985-09-04"
                                    }
                                }, {
                                    ILS: {
                                        _from: "1985-09-04"
                                    }
                                }],
                                IM: [{
                                    GBP: {
                                        _from: "1840-01-03"
                                    }
                                }],
                                IN: [{
                                    INR: {
                                        _from: "1835-08-17"
                                    }
                                }],
                                IO: [{
                                    USD: {
                                        _from: "1965-11-08"
                                    }
                                }],
                                IQ: [{
                                    EGP: {
                                        _from: "1920-11-11",
                                        _to: "1931-04-19"
                                    }
                                }, {
                                    INR: {
                                        _from: "1920-11-11",
                                        _to: "1931-04-19"
                                    }
                                }, {
                                    IQD: {
                                        _from: "1931-04-19"
                                    }
                                }],
                                IR: [{
                                    IRR: {
                                        _from: "1932-05-13"
                                    }
                                }],
                                IS: [{
                                    DKK: {
                                        _from: "1873-05-27",
                                        _to: "1918-12-01"
                                    }
                                }, {
                                    ISJ: {
                                        _from: "1918-12-01",
                                        _to: "1981-01-01"
                                    }
                                }, {
                                    ISK: {
                                        _from: "1981-01-01"
                                    }
                                }],
                                IT: [{
                                    ITL: {
                                        _from: "1862-08-24",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                JE: [{
                                    GBP: {
                                        _from: "1837-01-01"
                                    }
                                }],
                                JM: [{
                                    JMD: {
                                        _from: "1969-09-08"
                                    }
                                }],
                                JO: [{
                                    JOD: {
                                        _from: "1950-07-01"
                                    }
                                }],
                                JP: [{
                                    JPY: {
                                        _from: "1871-06-01"
                                    }
                                }],
                                KE: [{
                                    KES: {
                                        _from: "1966-09-14"
                                    }
                                }],
                                KG: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-05-10"
                                    }
                                }, {
                                    KGS: {
                                        _from: "1993-05-10"
                                    }
                                }],
                                KH: [{
                                    KHR: {
                                        _from: "1980-03-20"
                                    }
                                }],
                                KI: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                KM: [{
                                    KMF: {
                                        _from: "1975-07-06"
                                    }
                                }],
                                KN: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                KP: [{
                                    KPW: {
                                        _from: "1959-04-17"
                                    }
                                }],
                                KR: [{
                                    KRO: {
                                        _from: "1945-08-15",
                                        _to: "1953-02-15"
                                    }
                                }, {
                                    KRH: {
                                        _from: "1953-02-15",
                                        _to: "1962-06-10"
                                    }
                                }, {
                                    KRW: {
                                        _from: "1962-06-10"
                                    }
                                }],
                                KW: [{
                                    KWD: {
                                        _from: "1961-04-01"
                                    }
                                }],
                                KY: [{
                                    JMD: {
                                        _from: "1969-09-08",
                                        _to: "1971-01-01"
                                    }
                                }, {
                                    KYD: {
                                        _from: "1971-01-01"
                                    }
                                }],
                                KZ: [{
                                    KZT: {
                                        _from: "1993-11-05"
                                    }
                                }],
                                LA: [{
                                    LAK: {
                                        _from: "1979-12-10"
                                    }
                                }],
                                LB: [{
                                    LBP: {
                                        _from: "1948-02-02"
                                    }
                                }],
                                LC: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                LI: [{
                                    CHF: {
                                        _from: "1921-02-01"
                                    }
                                }],
                                LK: [{
                                    LKR: {
                                        _from: "1978-05-22"
                                    }
                                }],
                                LR: [{
                                    LRD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                LS: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    LSL: {
                                        _from: "1980-01-22"
                                    }
                                }],
                                LT: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-10-01"
                                    }
                                }, {
                                    LTT: {
                                        _from: "1992-10-01",
                                        _to: "1993-06-25"
                                    }
                                }, {
                                    LTL: {
                                        _from: "1993-06-25",
                                        _to: "2014-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2015-01-01"
                                    }
                                }],
                                LU: [{
                                    LUF: {
                                        _from: "1944-09-04",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    LUC: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    LUL: {
                                        _tender: "false",
                                        _from: "1970-01-01",
                                        _to: "1990-03-05"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                LV: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1992-07-20"
                                    }
                                }, {
                                    LVR: {
                                        _from: "1992-05-07",
                                        _to: "1993-10-17"
                                    }
                                }, {
                                    LVL: {
                                        _from: "1993-06-28",
                                        _to: "2013-12-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2014-01-01"
                                    }
                                }],
                                LY: [{
                                    LYD: {
                                        _from: "1971-09-01"
                                    }
                                }],
                                MA: [{
                                    MAF: {
                                        _from: "1881-01-01",
                                        _to: "1959-10-17"
                                    }
                                }, {
                                    MAD: {
                                        _from: "1959-10-17"
                                    }
                                }],
                                MC: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    MCF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MD: [{
                                    MDC: {
                                        _from: "1992-06-01",
                                        _to: "1993-11-29"
                                    }
                                }, {
                                    MDL: {
                                        _from: "1993-11-29"
                                    }
                                }],
                                ME: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    DEM: {
                                        _from: "1999-10-02",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2002-01-01"
                                    }
                                }],
                                MF: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MG: [{
                                    MGF: {
                                        _from: "1963-07-01",
                                        _to: "2004-12-31"
                                    }
                                }, {
                                    MGA: {
                                        _from: "1983-11-01"
                                    }
                                }],
                                MH: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                MK: [{
                                    MKN: {
                                        _from: "1992-04-26",
                                        _to: "1993-05-20"
                                    }
                                }, {
                                    MKD: {
                                        _from: "1993-05-20"
                                    }
                                }],
                                ML: [{
                                    XOF: {
                                        _from: "1958-11-24",
                                        _to: "1962-07-02"
                                    }
                                }, {
                                    MLF: {
                                        _from: "1962-07-02",
                                        _to: "1984-08-31"
                                    }
                                }, {
                                    XOF: {
                                        _from: "1984-06-01"
                                    }
                                }],
                                MM: [{
                                    BUK: {
                                        _from: "1952-07-01",
                                        _to: "1989-06-18"
                                    }
                                }, {
                                    MMK: {
                                        _from: "1989-06-18"
                                    }
                                }],
                                MN: [{
                                    MNT: {
                                        _from: "1915-03-01"
                                    }
                                }],
                                MO: [{
                                    MOP: {
                                        _from: "1901-01-01"
                                    }
                                }],
                                MP: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                MQ: [{
                                    FRF: {
                                        _from: "1960-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                MR: [{
                                    XOF: {
                                        _from: "1958-11-28",
                                        _to: "1973-06-29"
                                    }
                                }, {
                                    MRO: {
                                        _from: "1973-06-29",
                                        _to: "2018-06-30"
                                    }
                                }, {
                                    MRU: {
                                        _from: "2018-01-01"
                                    }
                                }],
                                MS: [{
                                    XCD: {
                                        _from: "1967-02-27"
                                    }
                                }],
                                MT: [{
                                    MTP: {
                                        _from: "1914-08-13",
                                        _to: "1968-06-07"
                                    }
                                }, {
                                    MTL: {
                                        _from: "1968-06-07",
                                        _to: "2008-01-31"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2008-01-01"
                                    }
                                }],
                                MU: [{
                                    MUR: {
                                        _from: "1934-04-01"
                                    }
                                }],
                                MV: [{
                                    MVP: {
                                        _from: "1947-01-01",
                                        _to: "1981-07-01"
                                    }
                                }, {
                                    MVR: {
                                        _from: "1981-07-01"
                                    }
                                }],
                                MW: [{
                                    MWK: {
                                        _from: "1971-02-15"
                                    }
                                }],
                                MX: [{
                                    MXV: {
                                        _tender: "false"
                                    }
                                }, {
                                    MXP: {
                                        _from: "1822-01-01",
                                        _to: "1992-12-31"
                                    }
                                }, {
                                    MXN: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                MY: [{
                                    MYR: {
                                        _from: "1963-09-16"
                                    }
                                }],
                                MZ: [{
                                    MZE: {
                                        _from: "1975-06-25",
                                        _to: "1980-06-16"
                                    }
                                }, {
                                    MZM: {
                                        _from: "1980-06-16",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    MZN: {
                                        _from: "2006-07-01"
                                    }
                                }],
                                NA: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    NAD: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                NC: [{
                                    XPF: {
                                        _from: "1985-01-01"
                                    }
                                }],
                                NE: [{
                                    XOF: {
                                        _from: "1958-12-19"
                                    }
                                }],
                                NF: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                NG: [{
                                    NGN: {
                                        _from: "1973-01-01"
                                    }
                                }],
                                NI: [{
                                    NIC: {
                                        _from: "1988-02-15",
                                        _to: "1991-04-30"
                                    }
                                }, {
                                    NIO: {
                                        _from: "1991-04-30"
                                    }
                                }],
                                NL: [{
                                    NLG: {
                                        _from: "1813-01-01",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                NO: [{
                                    SEK: {
                                        _from: "1873-05-27",
                                        _to: "1905-06-07"
                                    }
                                }, {
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                NP: [{
                                    INR: {
                                        _from: "1870-01-01",
                                        _to: "1966-10-17"
                                    }
                                }, {
                                    NPR: {
                                        _from: "1933-01-01"
                                    }
                                }],
                                NR: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                NU: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                NZ: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                OM: [{
                                    OMR: {
                                        _from: "1972-11-11"
                                    }
                                }],
                                PA: [{
                                    PAB: {
                                        _from: "1903-11-04"
                                    }
                                }, {
                                    USD: {
                                        _from: "1903-11-18"
                                    }
                                }],
                                PE: [{
                                    PES: {
                                        _from: "1863-02-14",
                                        _to: "1985-02-01"
                                    }
                                }, {
                                    PEI: {
                                        _from: "1985-02-01",
                                        _to: "1991-07-01"
                                    }
                                }, {
                                    PEN: {
                                        _from: "1991-07-01"
                                    }
                                }],
                                PF: [{
                                    XPF: {
                                        _from: "1945-12-26"
                                    }
                                }],
                                PG: [{
                                    AUD: {
                                        _from: "1966-02-14",
                                        _to: "1975-09-16"
                                    }
                                }, {
                                    PGK: {
                                        _from: "1975-09-16"
                                    }
                                }],
                                PH: [{
                                    PHP: {
                                        _from: "1946-07-04"
                                    }
                                }],
                                PK: [{
                                    INR: {
                                        _from: "1835-08-17",
                                        _to: "1947-08-15"
                                    }
                                }, {
                                    PKR: {
                                        _from: "1948-04-01"
                                    }
                                }],
                                PL: [{
                                    PLZ: {
                                        _from: "1950-10-28",
                                        _to: "1994-12-31"
                                    }
                                }, {
                                    PLN: {
                                        _from: "1995-01-01"
                                    }
                                }],
                                PM: [{
                                    FRF: {
                                        _from: "1972-12-21",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                PN: [{
                                    NZD: {
                                        _from: "1969-01-13"
                                    }
                                }],
                                PR: [{
                                    ESP: {
                                        _from: "1800-01-01",
                                        _to: "1898-12-10"
                                    }
                                }, {
                                    USD: {
                                        _from: "1898-12-10"
                                    }
                                }],
                                PS: [{
                                    JOD: {
                                        _from: "1950-07-01",
                                        _to: "1967-06-01"
                                    }
                                }, {
                                    ILP: {
                                        _from: "1967-06-01",
                                        _to: "1980-02-22"
                                    }
                                }, {
                                    ILS: {
                                        _from: "1985-09-04"
                                    }
                                }, {
                                    JOD: {
                                        _from: "1996-02-12"
                                    }
                                }],
                                PT: [{
                                    PTE: {
                                        _from: "1911-05-22",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                PW: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                PY: [{
                                    PYG: {
                                        _from: "1943-11-01"
                                    }
                                }],
                                QA: [{
                                    QAR: {
                                        _from: "1973-05-19"
                                    }
                                }],
                                RE: [{
                                    FRF: {
                                        _from: "1975-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                RO: [{
                                    ROL: {
                                        _from: "1952-01-28",
                                        _to: "2006-12-31"
                                    }
                                }, {
                                    RON: {
                                        _from: "2005-07-01"
                                    }
                                }],
                                RS: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }, {
                                    CSD: {
                                        _from: "2002-05-15",
                                        _to: "2006-10-25"
                                    }
                                }, {
                                    RSD: {
                                        _from: "2006-10-25"
                                    }
                                }],
                                RU: [{
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1998-12-31"
                                    }
                                }, {
                                    RUB: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                RW: [{
                                    RWF: {
                                        _from: "1964-05-19"
                                    }
                                }],
                                SA: [{
                                    SAR: {
                                        _from: "1952-10-22"
                                    }
                                }],
                                SB: [{
                                    AUD: {
                                        _from: "1966-02-14",
                                        _to: "1978-06-30"
                                    }
                                }, {
                                    SBD: {
                                        _from: "1977-10-24"
                                    }
                                }],
                                SC: [{
                                    SCR: {
                                        _from: "1903-11-01"
                                    }
                                }],
                                SD: [{
                                    EGP: {
                                        _from: "1889-01-19",
                                        _to: "1958-01-01"
                                    }
                                }, {
                                    GBP: {
                                        _from: "1889-01-19",
                                        _to: "1958-01-01"
                                    }
                                }, {
                                    SDP: {
                                        _from: "1957-04-08",
                                        _to: "1998-06-01"
                                    }
                                }, {
                                    SDD: {
                                        _from: "1992-06-08",
                                        _to: "2007-06-30"
                                    }
                                }, {
                                    SDG: {
                                        _from: "2007-01-10"
                                    }
                                }],
                                SE: [{
                                    SEK: {
                                        _from: "1873-05-27"
                                    }
                                }],
                                SG: [{
                                    MYR: {
                                        _from: "1963-09-16",
                                        _to: "1967-06-12"
                                    }
                                }, {
                                    SGD: {
                                        _from: "1967-06-12"
                                    }
                                }],
                                SH: [{
                                    SHP: {
                                        _from: "1917-02-15"
                                    }
                                }],
                                SI: [{
                                    SIT: {
                                        _from: "1992-10-07",
                                        _to: "2007-01-14"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2007-01-01"
                                    }
                                }],
                                SJ: [{
                                    NOK: {
                                        _from: "1905-06-07"
                                    }
                                }],
                                SK: [{
                                    CSK: {
                                        _from: "1953-06-01",
                                        _to: "1992-12-31"
                                    }
                                }, {
                                    SKK: {
                                        _from: "1992-12-31",
                                        _to: "2009-01-01"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2009-01-01"
                                    }
                                }],
                                SL: [{
                                    GBP: {
                                        _from: "1808-11-30",
                                        _to: "1966-02-04"
                                    }
                                }, {
                                    SLL: {
                                        _from: "1964-08-04"
                                    }
                                }],
                                SM: [{
                                    ITL: {
                                        _from: "1865-12-23",
                                        _to: "2001-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                SN: [{
                                    XOF: {
                                        _from: "1959-04-04"
                                    }
                                }],
                                SO: [{
                                    SOS: {
                                        _from: "1960-07-01"
                                    }
                                }],
                                SR: [{
                                    NLG: {
                                        _from: "1815-11-20",
                                        _to: "1940-05-10"
                                    }
                                }, {
                                    SRG: {
                                        _from: "1940-05-10",
                                        _to: "2003-12-31"
                                    }
                                }, {
                                    SRD: {
                                        _from: "2004-01-01"
                                    }
                                }],
                                SS: [{
                                    SDG: {
                                        _from: "2007-01-10",
                                        _to: "2011-09-01"
                                    }
                                }, {
                                    SSP: {
                                        _from: "2011-07-18"
                                    }
                                }],
                                ST: [{
                                    STD: {
                                        _from: "1977-09-08",
                                        _to: "2017-12-31"
                                    }
                                }, {
                                    STN: {
                                        _from: "2018-01-01"
                                    }
                                }],
                                SU: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }],
                                SV: [{
                                    SVC: {
                                        _from: "1919-11-11",
                                        _to: "2001-01-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "2001-01-01"
                                    }
                                }],
                                SX: [{
                                    ANG: {
                                        _from: "2010-10-10"
                                    }
                                }],
                                SY: [{
                                    SYP: {
                                        _from: "1948-01-01"
                                    }
                                }],
                                SZ: [{
                                    SZL: {
                                        _from: "1974-09-06"
                                    }
                                }],
                                TA: [{
                                    GBP: {
                                        _from: "1938-01-12"
                                    }
                                }],
                                TC: [{
                                    USD: {
                                        _from: "1969-09-08"
                                    }
                                }],
                                TD: [{
                                    XAF: {
                                        _from: "1993-01-01"
                                    }
                                }],
                                TF: [{
                                    FRF: {
                                        _from: "1959-01-01",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                TG: [{
                                    XOF: {
                                        _from: "1958-11-28"
                                    }
                                }],
                                TH: [{
                                    THB: {
                                        _from: "1928-04-15"
                                    }
                                }],
                                TJ: [{
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1995-05-10"
                                    }
                                }, {
                                    TJR: {
                                        _from: "1995-05-10",
                                        _to: "2000-10-25"
                                    }
                                }, {
                                    TJS: {
                                        _from: "2000-10-26"
                                    }
                                }],
                                TK: [{
                                    NZD: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                TL: [{
                                    TPE: {
                                        _from: "1959-01-02",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    IDR: {
                                        _from: "1975-12-07",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    USD: {
                                        _from: "1999-10-20"
                                    }
                                }],
                                TM: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    TMM: {
                                        _from: "1993-11-01",
                                        _to: "2009-01-01"
                                    }
                                }, {
                                    TMT: {
                                        _from: "2009-01-01"
                                    }
                                }],
                                TN: [{
                                    TND: {
                                        _from: "1958-11-01"
                                    }
                                }],
                                TO: [{
                                    TOP: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                TP: [{
                                    TPE: {
                                        _from: "1959-01-02",
                                        _to: "2002-05-20"
                                    }
                                }, {
                                    IDR: {
                                        _from: "1975-12-07",
                                        _to: "2002-05-20"
                                    }
                                }],
                                TR: [{
                                    TRL: {
                                        _from: "1922-11-01",
                                        _to: "2005-12-31"
                                    }
                                }, {
                                    TRY: {
                                        _from: "2005-01-01"
                                    }
                                }],
                                TT: [{
                                    TTD: {
                                        _from: "1964-01-01"
                                    }
                                }],
                                TV: [{
                                    AUD: {
                                        _from: "1966-02-14"
                                    }
                                }],
                                TW: [{
                                    TWD: {
                                        _from: "1949-06-15"
                                    }
                                }],
                                TZ: [{
                                    TZS: {
                                        _from: "1966-06-14"
                                    }
                                }],
                                UA: [{
                                    SUR: {
                                        _from: "1961-01-01",
                                        _to: "1991-12-25"
                                    }
                                }, {
                                    RUR: {
                                        _from: "1991-12-25",
                                        _to: "1992-11-13"
                                    }
                                }, {
                                    UAK: {
                                        _from: "1992-11-13",
                                        _to: "1993-10-17"
                                    }
                                }, {
                                    UAH: {
                                        _from: "1996-09-02"
                                    }
                                }],
                                UG: [{
                                    UGS: {
                                        _from: "1966-08-15",
                                        _to: "1987-05-15"
                                    }
                                }, {
                                    UGX: {
                                        _from: "1987-05-15"
                                    }
                                }],
                                UM: [{
                                    USD: {
                                        _from: "1944-01-01"
                                    }
                                }],
                                US: [{
                                    USN: {
                                        _tender: "false"
                                    }
                                }, {
                                    USS: {
                                        _tender: "false",
                                        _to: "2014-03-01"
                                    }
                                }, {
                                    USD: {
                                        _from: "1792-01-01"
                                    }
                                }],
                                UY: [{
                                    UYI: {
                                        _tender: "false"
                                    }
                                }, {
                                    UYW: {
                                        _tender: "false"
                                    }
                                }, {
                                    UYP: {
                                        _from: "1975-07-01",
                                        _to: "1993-03-01"
                                    }
                                }, {
                                    UYU: {
                                        _from: "1993-03-01"
                                    }
                                }],
                                UZ: [{
                                    UZS: {
                                        _from: "1994-07-01"
                                    }
                                }],
                                VA: [{
                                    ITL: {
                                        _from: "1870-10-19",
                                        _to: "2002-02-28"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                VC: [{
                                    XCD: {
                                        _from: "1965-10-06"
                                    }
                                }],
                                VE: [{
                                    VEB: {
                                        _from: "1871-05-11",
                                        _to: "2008-06-30"
                                    }
                                }, {
                                    VEF: {
                                        _from: "2008-01-01",
                                        _to: "2018-08-20"
                                    }
                                }, {
                                    VES: {
                                        _from: "2018-08-20"
                                    }
                                }],
                                VG: [{
                                    USD: {
                                        _from: "1833-01-01"
                                    }
                                }, {
                                    GBP: {
                                        _from: "1833-01-01",
                                        _to: "1959-01-01"
                                    }
                                }],
                                VI: [{
                                    USD: {
                                        _from: "1837-01-01"
                                    }
                                }],
                                VN: [{
                                    VNN: {
                                        _from: "1978-05-03",
                                        _to: "1985-09-14"
                                    }
                                }, {
                                    VND: {
                                        _from: "1985-09-14"
                                    }
                                }],
                                VU: [{
                                    VUV: {
                                        _from: "1981-01-01"
                                    }
                                }],
                                WF: [{
                                    XPF: {
                                        _from: "1961-07-30"
                                    }
                                }],
                                WS: [{
                                    WST: {
                                        _from: "1967-07-10"
                                    }
                                }],
                                XK: [{
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "1999-09-30"
                                    }
                                }, {
                                    DEM: {
                                        _from: "1999-09-01",
                                        _to: "2002-03-09"
                                    }
                                }, {
                                    EUR: {
                                        _from: "2002-01-01"
                                    }
                                }],
                                YD: [{
                                    YDD: {
                                        _from: "1965-04-01",
                                        _to: "1996-01-01"
                                    }
                                }],
                                YE: [{
                                    YER: {
                                        _from: "1990-05-22"
                                    }
                                }],
                                YT: [{
                                    KMF: {
                                        _from: "1975-01-01",
                                        _to: "1976-02-23"
                                    }
                                }, {
                                    FRF: {
                                        _from: "1976-02-23",
                                        _to: "2002-02-17"
                                    }
                                }, {
                                    EUR: {
                                        _from: "1999-01-01"
                                    }
                                }],
                                YU: [{
                                    YUD: {
                                        _from: "1966-01-01",
                                        _to: "1990-01-01"
                                    }
                                }, {
                                    YUN: {
                                        _from: "1990-01-01",
                                        _to: "1992-07-24"
                                    }
                                }, {
                                    YUM: {
                                        _from: "1994-01-24",
                                        _to: "2002-05-15"
                                    }
                                }],
                                ZA: [{
                                    ZAR: {
                                        _from: "1961-02-14"
                                    }
                                }, {
                                    ZAL: {
                                        _tender: "false",
                                        _from: "1985-09-01",
                                        _to: "1995-03-13"
                                    }
                                }],
                                ZM: [{
                                    ZMK: {
                                        _from: "1968-01-16",
                                        _to: "2013-01-01"
                                    }
                                }, {
                                    ZMW: {
                                        _from: "2013-01-01"
                                    }
                                }],
                                ZR: [{
                                    ZRZ: {
                                        _from: "1971-10-27",
                                        _to: "1993-11-01"
                                    }
                                }, {
                                    ZRN: {
                                        _from: "1993-11-01",
                                        _to: "1998-07-31"
                                    }
                                }],
                                ZW: [{
                                    RHD: {
                                        _from: "1970-02-17",
                                        _to: "1980-04-18"
                                    }
                                }, {
                                    ZWD: {
                                        _from: "1980-04-18",
                                        _to: "2008-08-01"
                                    }
                                }, {
                                    ZWR: {
                                        _from: "2008-08-01",
                                        _to: "2009-02-02"
                                    }
                                }, {
                                    ZWL: {
                                        _from: "2009-02-02",
                                        _to: "2009-04-12"
                                    }
                                }, {
                                    USD: {
                                        _from: "2009-04-12"
                                    }
                                }],
                                ZZ: [{
                                    XAG: {
                                        _tender: "false"
                                    }
                                }, {
                                    XAU: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBA: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBB: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBC: {
                                        _tender: "false"
                                    }
                                }, {
                                    XBD: {
                                        _tender: "false"
                                    }
                                }, {
                                    XDR: {
                                        _tender: "false"
                                    }
                                }, {
                                    XPD: {
                                        _tender: "false"
                                    }
                                }, {
                                    XPT: {
                                        _tender: "false"
                                    }
                                }, {
                                    XSU: {
                                        _tender: "false"
                                    }
                                }, {
                                    XTS: {
                                        _tender: "false"
                                    }
                                }, {
                                    XUA: {
                                        _tender: "false"
                                    }
                                }, {
                                    XXX: {
                                        _tender: "false"
                                    }
                                }, {
                                    XRE: {
                                        _tender: "false",
                                        _to: "1999-11-30"
                                    }
                                }, {
                                    XFU: {
                                        _tender: "false",
                                        _to: "2013-11-30"
                                    }
                                }, {
                                    XFO: {
                                        _tender: "false",
                                        _from: "1930-01-01",
                                        _to: "2003-04-01"
                                    }
                                }]
                            }
                        },
                        numberingSystems: {
                            adlm: {
                                _digits: "\ud83a\udd50\ud83a\udd51\ud83a\udd52\ud83a\udd53\ud83a\udd54\ud83a\udd55\ud83a\udd56\ud83a\udd57\ud83a\udd58\ud83a\udd59",
                                _type: "numeric"
                            },
                            ahom: {
                                _digits: "\ud805\udf30\ud805\udf31\ud805\udf32\ud805\udf33\ud805\udf34\ud805\udf35\ud805\udf36\ud805\udf37\ud805\udf38\ud805\udf39",
                                _type: "numeric"
                            },
                            arab: {
                                _digits: "\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669",
                                _type: "numeric"
                            },
                            arabext: {
                                _digits: "\u06f0\u06f1\u06f2\u06f3\u06f4\u06f5\u06f6\u06f7\u06f8\u06f9",
                                _type: "numeric"
                            },
                            armn: {
                                _rules: "armenian-upper",
                                _type: "algorithmic"
                            },
                            armnlow: {
                                _rules: "armenian-lower",
                                _type: "algorithmic"
                            },
                            bali: {
                                _digits: "\u1b50\u1b51\u1b52\u1b53\u1b54\u1b55\u1b56\u1b57\u1b58\u1b59",
                                _type: "numeric"
                            },
                            beng: {
                                _digits: "\u09e6\u09e7\u09e8\u09e9\u09ea\u09eb\u09ec\u09ed\u09ee\u09ef",
                                _type: "numeric"
                            },
                            bhks: {
                                _digits: "\ud807\udc50\ud807\udc51\ud807\udc52\ud807\udc53\ud807\udc54\ud807\udc55\ud807\udc56\ud807\udc57\ud807\udc58\ud807\udc59",
                                _type: "numeric"
                            },
                            brah: {
                                _digits: "\ud804\udc66\ud804\udc67\ud804\udc68\ud804\udc69\ud804\udc6a\ud804\udc6b\ud804\udc6c\ud804\udc6d\ud804\udc6e\ud804\udc6f",
                                _type: "numeric"
                            },
                            cakm: {
                                _digits: "\ud804\udd36\ud804\udd37\ud804\udd38\ud804\udd39\ud804\udd3a\ud804\udd3b\ud804\udd3c\ud804\udd3d\ud804\udd3e\ud804\udd3f",
                                _type: "numeric"
                            },
                            cham: {
                                _digits: "\uaa50\uaa51\uaa52\uaa53\uaa54\uaa55\uaa56\uaa57\uaa58\uaa59",
                                _type: "numeric"
                            },
                            cyrl: {
                                _rules: "cyrillic-lower",
                                _type: "algorithmic"
                            },
                            deva: {
                                _digits: "\u0966\u0967\u0968\u0969\u096a\u096b\u096c\u096d\u096e\u096f",
                                _type: "numeric"
                            },
                            ethi: {
                                _rules: "ethiopic",
                                _type: "algorithmic"
                            },
                            fullwide: {
                                _digits: "\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19",
                                _type: "numeric"
                            },
                            geor: {
                                _rules: "georgian",
                                _type: "algorithmic"
                            },
                            gong: {
                                _digits: "\ud807\udda0\ud807\udda1\ud807\udda2\ud807\udda3\ud807\udda4\ud807\udda5\ud807\udda6\ud807\udda7\ud807\udda8\ud807\udda9",
                                _type: "numeric"
                            },
                            gonm: {
                                _digits: "\ud807\udd50\ud807\udd51\ud807\udd52\ud807\udd53\ud807\udd54\ud807\udd55\ud807\udd56\ud807\udd57\ud807\udd58\ud807\udd59",
                                _type: "numeric"
                            },
                            grek: {
                                _rules: "greek-upper",
                                _type: "algorithmic"
                            },
                            greklow: {
                                _rules: "greek-lower",
                                _type: "algorithmic"
                            },
                            gujr: {
                                _digits: "\u0ae6\u0ae7\u0ae8\u0ae9\u0aea\u0aeb\u0aec\u0aed\u0aee\u0aef",
                                _type: "numeric"
                            },
                            guru: {
                                _digits: "\u0a66\u0a67\u0a68\u0a69\u0a6a\u0a6b\u0a6c\u0a6d\u0a6e\u0a6f",
                                _type: "numeric"
                            },
                            hanidays: {
                                _rules: "zh/SpelloutRules/spellout-numbering-days",
                                _type: "algorithmic"
                            },
                            hanidec: {
                                _digits: "\u3007\u4e00\u4e8c\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d",
                                _type: "numeric"
                            },
                            hans: {
                                _rules: "zh/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            hansfin: {
                                _rules: "zh/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            hant: {
                                _rules: "zh_Hant/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            hantfin: {
                                _rules: "zh_Hant/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            hebr: {
                                _rules: "hebrew",
                                _type: "algorithmic"
                            },
                            hmng: {
                                _digits: "\ud81a\udf50\ud81a\udf51\ud81a\udf52\ud81a\udf53\ud81a\udf54\ud81a\udf55\ud81a\udf56\ud81a\udf57\ud81a\udf58\ud81a\udf59",
                                _type: "numeric"
                            },
                            hmnp: {
                                _digits: "\ud838\udd40\ud838\udd41\ud838\udd42\ud838\udd43\ud838\udd44\ud838\udd45\ud838\udd46\ud838\udd47\ud838\udd48\ud838\udd49",
                                _type: "numeric"
                            },
                            java: {
                                _digits: "\ua9d0\ua9d1\ua9d2\ua9d3\ua9d4\ua9d5\ua9d6\ua9d7\ua9d8\ua9d9",
                                _type: "numeric"
                            },
                            jpan: {
                                _rules: "ja/SpelloutRules/spellout-cardinal",
                                _type: "algorithmic"
                            },
                            jpanfin: {
                                _rules: "ja/SpelloutRules/spellout-cardinal-financial",
                                _type: "algorithmic"
                            },
                            jpanyear: {
                                _rules: "ja/SpelloutRules/spellout-numbering-year-latn",
                                _type: "algorithmic"
                            },
                            kali: {
                                _digits: "\ua900\ua901\ua902\ua903\ua904\ua905\ua906\ua907\ua908\ua909",
                                _type: "numeric"
                            },
                            khmr: {
                                _digits: "\u17e0\u17e1\u17e2\u17e3\u17e4\u17e5\u17e6\u17e7\u17e8\u17e9",
                                _type: "numeric"
                            },
                            knda: {
                                _digits: "\u0ce6\u0ce7\u0ce8\u0ce9\u0cea\u0ceb\u0cec\u0ced\u0cee\u0cef",
                                _type: "numeric"
                            },
                            lana: {
                                _digits: "\u1a80\u1a81\u1a82\u1a83\u1a84\u1a85\u1a86\u1a87\u1a88\u1a89",
                                _type: "numeric"
                            },
                            lanatham: {
                                _digits: "\u1a90\u1a91\u1a92\u1a93\u1a94\u1a95\u1a96\u1a97\u1a98\u1a99",
                                _type: "numeric"
                            },
                            laoo: {
                                _digits: "\u0ed0\u0ed1\u0ed2\u0ed3\u0ed4\u0ed5\u0ed6\u0ed7\u0ed8\u0ed9",
                                _type: "numeric"
                            },
                            latn: {
                                _digits: "0123456789",
                                _type: "numeric"
                            },
                            lepc: {
                                _digits: "\u1c40\u1c41\u1c42\u1c43\u1c44\u1c45\u1c46\u1c47\u1c48\u1c49",
                                _type: "numeric"
                            },
                            limb: {
                                _digits: "\u1946\u1947\u1948\u1949\u194a\u194b\u194c\u194d\u194e\u194f",
                                _type: "numeric"
                            },
                            mathbold: {
                                _digits: "\ud835\udfce\ud835\udfcf\ud835\udfd0\ud835\udfd1\ud835\udfd2\ud835\udfd3\ud835\udfd4\ud835\udfd5\ud835\udfd6\ud835\udfd7",
                                _type: "numeric"
                            },
                            mathdbl: {
                                _digits: "\ud835\udfd8\ud835\udfd9\ud835\udfda\ud835\udfdb\ud835\udfdc\ud835\udfdd\ud835\udfde\ud835\udfdf\ud835\udfe0\ud835\udfe1",
                                _type: "numeric"
                            },
                            mathmono: {
                                _digits: "\ud835\udff6\ud835\udff7\ud835\udff8\ud835\udff9\ud835\udffa\ud835\udffb\ud835\udffc\ud835\udffd\ud835\udffe\ud835\udfff",
                                _type: "numeric"
                            },
                            mathsanb: {
                                _digits: "\ud835\udfec\ud835\udfed\ud835\udfee\ud835\udfef\ud835\udff0\ud835\udff1\ud835\udff2\ud835\udff3\ud835\udff4\ud835\udff5",
                                _type: "numeric"
                            },
                            mathsans: {
                                _digits: "\ud835\udfe2\ud835\udfe3\ud835\udfe4\ud835\udfe5\ud835\udfe6\ud835\udfe7\ud835\udfe8\ud835\udfe9\ud835\udfea\ud835\udfeb",
                                _type: "numeric"
                            },
                            mlym: {
                                _digits: "\u0d66\u0d67\u0d68\u0d69\u0d6a\u0d6b\u0d6c\u0d6d\u0d6e\u0d6f",
                                _type: "numeric"
                            },
                            modi: {
                                _digits: "\ud805\ude50\ud805\ude51\ud805\ude52\ud805\ude53\ud805\ude54\ud805\ude55\ud805\ude56\ud805\ude57\ud805\ude58\ud805\ude59",
                                _type: "numeric"
                            },
                            mong: {
                                _digits: "\u1810\u1811\u1812\u1813\u1814\u1815\u1816\u1817\u1818\u1819",
                                _type: "numeric"
                            },
                            mroo: {
                                _digits: "\ud81a\ude60\ud81a\ude61\ud81a\ude62\ud81a\ude63\ud81a\ude64\ud81a\ude65\ud81a\ude66\ud81a\ude67\ud81a\ude68\ud81a\ude69",
                                _type: "numeric"
                            },
                            mtei: {
                                _digits: "\uabf0\uabf1\uabf2\uabf3\uabf4\uabf5\uabf6\uabf7\uabf8\uabf9",
                                _type: "numeric"
                            },
                            mymr: {
                                _digits: "\u1040\u1041\u1042\u1043\u1044\u1045\u1046\u1047\u1048\u1049",
                                _type: "numeric"
                            },
                            mymrshan: {
                                _digits: "\u1090\u1091\u1092\u1093\u1094\u1095\u1096\u1097\u1098\u1099",
                                _type: "numeric"
                            },
                            mymrtlng: {
                                _digits: "\ua9f0\ua9f1\ua9f2\ua9f3\ua9f4\ua9f5\ua9f6\ua9f7\ua9f8\ua9f9",
                                _type: "numeric"
                            },
                            newa: {
                                _digits: "\ud805\udc50\ud805\udc51\ud805\udc52\ud805\udc53\ud805\udc54\ud805\udc55\ud805\udc56\ud805\udc57\ud805\udc58\ud805\udc59",
                                _type: "numeric"
                            },
                            nkoo: {
                                _digits: "\u07c0\u07c1\u07c2\u07c3\u07c4\u07c5\u07c6\u07c7\u07c8\u07c9",
                                _type: "numeric"
                            },
                            olck: {
                                _digits: "\u1c50\u1c51\u1c52\u1c53\u1c54\u1c55\u1c56\u1c57\u1c58\u1c59",
                                _type: "numeric"
                            },
                            orya: {
                                _digits: "\u0b66\u0b67\u0b68\u0b69\u0b6a\u0b6b\u0b6c\u0b6d\u0b6e\u0b6f",
                                _type: "numeric"
                            },
                            osma: {
                                _digits: "\ud801\udca0\ud801\udca1\ud801\udca2\ud801\udca3\ud801\udca4\ud801\udca5\ud801\udca6\ud801\udca7\ud801\udca8\ud801\udca9",
                                _type: "numeric"
                            },
                            rohg: {
                                _digits: "\ud803\udd30\ud803\udd31\ud803\udd32\ud803\udd33\ud803\udd34\ud803\udd35\ud803\udd36\ud803\udd37\ud803\udd38\ud803\udd39",
                                _type: "numeric"
                            },
                            roman: {
                                _rules: "roman-upper",
                                _type: "algorithmic"
                            },
                            romanlow: {
                                _rules: "roman-lower",
                                _type: "algorithmic"
                            },
                            saur: {
                                _digits: "\ua8d0\ua8d1\ua8d2\ua8d3\ua8d4\ua8d5\ua8d6\ua8d7\ua8d8\ua8d9",
                                _type: "numeric"
                            },
                            shrd: {
                                _digits: "\ud804\uddd0\ud804\uddd1\ud804\uddd2\ud804\uddd3\ud804\uddd4\ud804\uddd5\ud804\uddd6\ud804\uddd7\ud804\uddd8\ud804\uddd9",
                                _type: "numeric"
                            },
                            sind: {
                                _digits: "\ud804\udef0\ud804\udef1\ud804\udef2\ud804\udef3\ud804\udef4\ud804\udef5\ud804\udef6\ud804\udef7\ud804\udef8\ud804\udef9",
                                _type: "numeric"
                            },
                            sinh: {
                                _digits: "\u0de6\u0de7\u0de8\u0de9\u0dea\u0deb\u0dec\u0ded\u0dee\u0def",
                                _type: "numeric"
                            },
                            sora: {
                                _digits: "\ud804\udcf0\ud804\udcf1\ud804\udcf2\ud804\udcf3\ud804\udcf4\ud804\udcf5\ud804\udcf6\ud804\udcf7\ud804\udcf8\ud804\udcf9",
                                _type: "numeric"
                            },
                            sund: {
                                _digits: "\u1bb0\u1bb1\u1bb2\u1bb3\u1bb4\u1bb5\u1bb6\u1bb7\u1bb8\u1bb9",
                                _type: "numeric"
                            },
                            takr: {
                                _digits: "\ud805\udec0\ud805\udec1\ud805\udec2\ud805\udec3\ud805\udec4\ud805\udec5\ud805\udec6\ud805\udec7\ud805\udec8\ud805\udec9",
                                _type: "numeric"
                            },
                            talu: {
                                _digits: "\u19d0\u19d1\u19d2\u19d3\u19d4\u19d5\u19d6\u19d7\u19d8\u19d9",
                                _type: "numeric"
                            },
                            taml: {
                                _rules: "tamil",
                                _type: "algorithmic"
                            },
                            tamldec: {
                                _digits: "\u0be6\u0be7\u0be8\u0be9\u0bea\u0beb\u0bec\u0bed\u0bee\u0bef",
                                _type: "numeric"
                            },
                            telu: {
                                _digits: "\u0c66\u0c67\u0c68\u0c69\u0c6a\u0c6b\u0c6c\u0c6d\u0c6e\u0c6f",
                                _type: "numeric"
                            },
                            thai: {
                                _digits: "\u0e50\u0e51\u0e52\u0e53\u0e54\u0e55\u0e56\u0e57\u0e58\u0e59",
                                _type: "numeric"
                            },
                            tibt: {
                                _digits: "\u0f20\u0f21\u0f22\u0f23\u0f24\u0f25\u0f26\u0f27\u0f28\u0f29",
                                _type: "numeric"
                            },
                            tirh: {
                                _digits: "\ud805\udcd0\ud805\udcd1\ud805\udcd2\ud805\udcd3\ud805\udcd4\ud805\udcd5\ud805\udcd6\ud805\udcd7\ud805\udcd8\ud805\udcd9",
                                _type: "numeric"
                            },
                            vaii: {
                                _digits: "\ua620\ua621\ua622\ua623\ua624\ua625\ua626\ua627\ua628\ua629",
                                _type: "numeric"
                            },
                            wara: {
                                _digits: "\ud806\udce0\ud806\udce1\ud806\udce2\ud806\udce3\ud806\udce4\ud806\udce5\ud806\udce6\ud806\udce7\ud806\udce8\ud806\udce9",
                                _type: "numeric"
                            },
                            wcho: {
                                _digits: "\ud838\udef0\ud838\udef1\ud838\udef2\ud838\udef3\ud838\udef4\ud838\udef5\ud838\udef6\ud838\udef7\ud838\udef8\ud838\udef9",
                                _type: "numeric"
                            }
                        }
                    }
                }
            },
        3444:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/sankey/node_item.js ***!
              \********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                const states = ["normal", "hover"];

                function compileAttrs(color, itemOptions, itemBaseOptions) {
                    const border = itemOptions.border;
                    const baseBorder = itemBaseOptions.border;
                    const borderVisible = (0, _type.isDefined)(border.visible) ? border.visible : baseBorder.visible;
                    const borderWidth = (0, _type.isDefined)(border.width) ? border.width : baseBorder.width;
                    const borderOpacity = (0, _type.isDefined)(border.opacity) ? border.opacity : (0, _type.isDefined)(baseBorder.opacity) ? baseBorder.opacity : 1;
                    const opacity = (0, _type.isDefined)(itemOptions.opacity) ? itemOptions.opacity : (0, _type.isDefined)(itemBaseOptions.opacity) ? itemBaseOptions.opacity : 1;
                    return {
                        fill: itemOptions.color || color,
                        "stroke-width": borderVisible ? borderWidth : 0,
                        stroke: itemOptions.border.color || itemBaseOptions.border.color,
                        "stroke-opacity": borderOpacity,
                        opacity: opacity,
                        hatching: itemOptions.hatching
                    }
                }

                function Node(widget, params) {
                    const widgetOffset = widget._renderer.getRootOffset();
                    this.code = 0;
                    this.widget = widget;
                    this.color = params.color;
                    this.options = params.options;
                    this.rect = params.rect;
                    this.label = params.rect._name;
                    this.coords = {
                        x: params.rect.x + params.rect.width / 2 + widgetOffset.left,
                        y: params.rect.y + params.rect.height / 2 + widgetOffset.top
                    };
                    this.id = params.id;
                    this.linksIn = params.linksIn;
                    this.linksOut = params.linksOut;
                    this.states = {
                        normal: compileAttrs(this.color, this.options, this.options),
                        hover: compileAttrs(this.color, this.options.hoverStyle, this.options)
                    }
                }
                Node.prototype = {
                    compileAttrs() {
                        return compileAttrs(this.color, this.options)
                    },
                    getState() {
                        return states[this.code]
                    },
                    isHovered() {
                        return !!(1 & this.code)
                    },
                    setState(code, state) {
                        if (state) {
                            this.code |= code
                        } else {
                            this.code &= ~code
                        }
                        if (state) {
                            this.linksIn.concat(this.linksOut).forEach((adjacentLink => {
                                this.widget._links[adjacentLink.index].setAdjacentNodeHover(true)
                            }))
                        } else {
                            this.widget._links.forEach((link => {
                                link.isAdjacentNodeHovered() && link.adjacentNodeHover(false)
                            }));
                            this.hideTooltip()
                        }
                        this.widget._applyNodesAppearance();
                        this.widget._applyLinksAppearance()
                    },
                    hover(state) {
                        if (!this.widget._getOption("hoverEnabled", true) || state === this.isHovered()) {
                            return
                        }
                        this.widget._suspend();
                        state && this.widget.clearHover();
                        this.setState(1, state);
                        this.widget._eventTrigger("nodeHoverChanged", {
                            target: this
                        });
                        this.widget._resume()
                    },
                    setHover() {
                        this.hover(true)
                    },
                    showTooltip(coords) {
                        this.widget._getOption("hoverEnabled", true) && this.widget._tooltip && this.widget._tooltip.show({
                            type: "node",
                            info: {
                                label: this.label,
                                title: this.label,
                                weightIn: this.linksIn.reduce(((previousValue, currentValue) => previousValue + currentValue.weight), 0),
                                weightOut: this.linksOut.reduce(((previousValue, currentValue) => previousValue + currentValue.weight), 0)
                            }
                        }, "undefined" !== typeof coords ? {
                            x: coords[0],
                            y: coords[1]
                        } : this.coords)
                    },
                    hideTooltip() {
                        this.widget._tooltip && this.widget._tooltip.hide()
                    },
                    getLabelAttributes(labelSettings, filter) {
                        return function(labelOptions, filter, node) {
                            const _patchFontOptions = _utils.patchFontOptions;
                            if (labelOptions.useNodeColors) {
                                labelOptions.font.color = node.color
                            }
                            const borderVisible = (0, _type.isDefined)(labelOptions.border.visible) ? labelOptions.border.visible : false;
                            const borderWidth = (0, _type.isDefined)(labelOptions.border.width) ? labelOptions.border.width : 0;
                            const borderColor = (0, _type.isDefined)(labelOptions.border.color) ? labelOptions.border.color : labelOptions.font.color;
                            const borderOpacity = (0, _type.isDefined)(labelOptions.border.opacity) ? labelOptions.border.opacity : 1;
                            const attr = {
                                filter: filter
                            };
                            if (borderVisible && borderWidth) {
                                attr.stroke = borderColor;
                                attr["stroke-width"] = borderVisible ? borderWidth : 0;
                                attr["stroke-opacity"] = borderOpacity
                            }
                            return {
                                attr: attr,
                                css: _patchFontOptions(labelOptions.font)
                            }
                        }(labelSettings, filter, this)
                    }
                };
                exports.default = Node
            },
        3508:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/file_management/provider_base.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _data = __webpack_require__( /*! ../../core/utils/data */ 31e3);
                var _date_serialization = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/date_serialization */ 71051));
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _file_system_item = _interopRequireDefault(__webpack_require__( /*! ../file_management/file_system_item */ 50259));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = class {
                    constructor(options) {
                        options = (0, _common.ensureDefined)(options, {});
                        this._keyGetter = (0, _data.compileGetter)(this._getKeyExpr(options));
                        this._nameGetter = (0, _data.compileGetter)(this._getNameExpr(options));
                        this._isDirGetter = (0, _data.compileGetter)(this._getIsDirExpr(options));
                        this._sizeGetter = (0, _data.compileGetter)(this._getSizeExpr(options));
                        this._dateModifiedGetter = (0, _data.compileGetter)(this._getDateModifiedExpr(options));
                        this._thumbnailGetter = (0, _data.compileGetter)(this._getThumbnailExpr(options))
                    }
                    getItems(parentDirectory) {
                        const deferred = new _deferred.Deferred;
                        deferred.resolve([]);
                        return deferred.promise()
                    }
                    abortFileUpload(fileData, chunksInfo, destinationDirectory) {}
                    getItemsContent(items) {}
                    getFileUploadChunkSize() {
                        return 2e5
                    }
                    _convertDataObjectsToFileItems(entries, pathInfo) {
                        const result = [];
                        (0, _iterator.each)(entries, ((_, entry) => {
                            const fileItem = this._createFileItem(entry, pathInfo);
                            result.push(fileItem)
                        }));
                        return result
                    }
                    _createFileItem(dataObj, pathInfo) {
                        var _this$_keyGetter, _this$_nameGetter, _this$_isDirGetter, _this$_sizeGetter, _this$_dateModifiedGe, _this$_thumbnailGette;
                        const key = null === (_this$_keyGetter = this._keyGetter) || void 0 === _this$_keyGetter ? void 0 : _this$_keyGetter.call(this, dataObj);
                        const fileItem = new _file_system_item.default(pathInfo, null === (_this$_nameGetter = this._nameGetter) || void 0 === _this$_nameGetter ? void 0 : _this$_nameGetter.call(this, dataObj), !!(null !== (_this$_isDirGetter = this._isDirGetter) && void 0 !== _this$_isDirGetter && _this$_isDirGetter.call(this, dataObj)), key);
                        fileItem.size = null === (_this$_sizeGetter = this._sizeGetter) || void 0 === _this$_sizeGetter ? void 0 : _this$_sizeGetter.call(this, dataObj);
                        if (void 0 === fileItem.size) {
                            fileItem.size = 0
                        }
                        fileItem.dateModified = _date_serialization.default.deserializeDate(null === (_this$_dateModifiedGe = this._dateModifiedGetter) || void 0 === _this$_dateModifiedGe ? void 0 : _this$_dateModifiedGe.call(this, dataObj));
                        if (void 0 === fileItem.dateModified) {
                            fileItem.dateModified = new Date
                        }
                        if (fileItem.isDirectory) {
                            fileItem.hasSubDirectories = this._hasSubDirs(dataObj)
                        }
                        if (!key) {
                            fileItem.key = fileItem.relativeName
                        }
                        fileItem.thumbnail = (null === (_this$_thumbnailGette = this._thumbnailGetter) || void 0 === _this$_thumbnailGette ? void 0 : _this$_thumbnailGette.call(this, dataObj)) || "";
                        fileItem.dataItem = dataObj;
                        return fileItem
                    }
                    _hasSubDirs(dataObj) {
                        return true
                    }
                    _getKeyExpr(options) {
                        return options.keyExpr ?? this._defaultKeyExpr
                    }
                    _defaultKeyExpr(fileItem) {
                        if (2 === arguments.length) {
                            fileItem.__KEY__ = arguments[1];
                            return
                        }
                        return Object.prototype.hasOwnProperty.call(fileItem, "__KEY__") ? fileItem.__KEY__ : null
                    }
                    _getNameExpr(options) {
                        return options.nameExpr ?? "name"
                    }
                    _getIsDirExpr(options) {
                        return options.isDirectoryExpr ?? "isDirectory"
                    }
                    _getSizeExpr(options) {
                        return options.sizeExpr ?? "size"
                    }
                    _getDateModifiedExpr(options) {
                        return options.dateModifiedExpr ?? "dateModified"
                    }
                    _getThumbnailExpr(options) {
                        return options.thumbnailExpr ?? "thumbnail"
                    }
                    _executeActionAsDeferred(action, keepResult) {
                        const deferred = new _deferred.Deferred;
                        try {
                            const result = action();
                            if ((0, _type.isPromise)(result)) {
                                (0, _deferred.fromPromise)(result).done((userResult => deferred.resolve(keepResult ? userResult : void 0))).fail((error => deferred.reject(error)))
                            } else {
                                deferred.resolve(keepResult ? result : void 0)
                            }
                        } catch (error) {
                            return deferred.reject(error)
                        }
                        return deferred.promise()
                    }
                }
            },
        3590:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/vector_map/control_bar/control_bar.js ***!
              \**************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.ControlBar = ControlBar;
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 98013);
                var _utils2 = __webpack_require__( /*! ../../../viz/vector_map/control_bar/utils */ 91548);
                const _math = Math;
                const _min = _math.min;
                const _max = _math.max;
                const _round = _math.round;
                const _floor = _math.floor;
                const _sqrt = _math.sqrt;
                const parseHorizontalAlignment = (0, _utils.enumParser)(["left", "center", "right"]);
                const parseVerticalAlignment = (0, _utils.enumParser)(["top", "bottom"]);
                const SIZE_OPTIONS = {
                    bigCircleSize: 58,
                    smallCircleSize: 28,
                    buttonSize: 10,
                    arrowButtonOffset: 20,
                    incDecButtonSize: 11,
                    incButtonOffset: 66,
                    decButtonOffset: 227,
                    sliderLineStartOffset: 88.5,
                    sliderLineEndOffset: 205.5,
                    sliderLength: 20,
                    sliderWidth: 8,
                    trackerGap: 4
                };
                let COMMAND_TO_TYPE_MAP = {};
                COMMAND_TO_TYPE_MAP["command-reset"] = ResetCommand;
                COMMAND_TO_TYPE_MAP["command-move-up"] = COMMAND_TO_TYPE_MAP["command-move-right"] = COMMAND_TO_TYPE_MAP["command-move-down"] = COMMAND_TO_TYPE_MAP["command-move-left"] = MoveCommand;
                COMMAND_TO_TYPE_MAP["command-zoom-in"] = COMMAND_TO_TYPE_MAP["command-zoom-out"] = ZoomCommand;
                COMMAND_TO_TYPE_MAP["command-zoom-drag"] = ZoomDragCommand;

                function ControlBar(parameters) {
                    this._params = parameters;
                    this._createElements(parameters.renderer, parameters.container, parameters.dataKey);
                    parameters.layoutControl.addItem(this);
                    this._subscribeToProjection(parameters.projection);
                    this._subscribeToTracker(parameters.tracker);
                    this._createCallbacks(parameters.projection)
                }
                ControlBar.prototype = {
                    constructor: ControlBar,
                    _flags: 0,
                    dispose() {
                        this._params.layoutControl.removeItem(this);
                        this._root.linkRemove().linkOff();
                        this._offProjection();
                        this._offTracker();
                        this._params = this._root = this._offProjection = this._offTracker = this._callbacks = null
                    },
                    _subscribeToProjection(projection) {
                        const that = this;
                        that._offProjection = projection.on({
                            engine() {
                                that._update()
                            },
                            zoom: updateZoom,
                            "max-zoom": function() {
                                that._zoomPartition = projection.getZoomScalePartition();
                                that._sliderUnitLength = that._sliderLineLength / that._zoomPartition;
                                updateZoom()
                            }
                        });

                        function updateZoom() {
                            that._adjustZoom(projection.getScaledZoom())
                        }
                    },
                    _subscribeToTracker(tracker) {
                        const that = this;
                        let isActive = false;
                        that._offTracker = tracker.on({
                            start(arg) {
                                isActive = "control-bar" === arg.data.name;
                                if (isActive) {
                                    that._processStart(arg.data.index, arg)
                                }
                            },
                            move(arg) {
                                if (isActive) {
                                    that._processMove(arg.data.index, arg)
                                }
                            },
                            end() {
                                if (isActive) {
                                    that._processEnd();
                                    isActive = false
                                }
                            }
                        })
                    },
                    _createCallbacks(projection) {
                        this._callbacks = {
                            reset(isCenter, isZoom) {
                                if (isCenter) {
                                    projection.setCenter(null)
                                }
                                if (isZoom) {
                                    projection.setZoom(null)
                                }
                            },
                            beginMove() {
                                projection.beginMoveCenter()
                            },
                            endMove() {
                                projection.endMoveCenter()
                            },
                            move(shift) {
                                projection.moveCenter(shift)
                            },
                            zoom(zoom) {
                                projection.setScaledZoom(zoom)
                            }
                        }
                    },
                    _createElements(renderer, container, dataKey) {
                        this._root = renderer.g().attr({
                            class: "dxm-control-bar"
                        }).linkOn(container, "control-bar");
                        const panControl = this._panControl = (0, _utils2.createVisibilityGroup)(renderer, this._root, "dxm-pan-control");
                        const zoomBar = this._zoomBar = (0, _utils2.createVisibilityGroup)(renderer, this._root, "dxm-zoom-bar");
                        const trackersPan = this._trackersPan = (0, _utils2.createTracker)(renderer, this._root);
                        const trackersZoom = this._trackersZoom = (0, _utils2.createTracker)(renderer, this._root);
                        this._createTrackersPan(renderer, dataKey, trackersPan);
                        this._createTrackersZoom(renderer, dataKey, trackersZoom);
                        this._createPanControl(renderer, dataKey, panControl);
                        this._createZoomBar(renderer, dataKey, zoomBar)
                    },
                    _createPanControl(renderer, dataKey, group) {
                        const options = SIZE_OPTIONS;
                        const size = options.buttonSize / 2;
                        const offset1 = options.arrowButtonOffset - size;
                        const offset2 = options.arrowButtonOffset;
                        const directionOptions = {
                            "stroke-linecap": "square",
                            fill: "none"
                        };
                        renderer.circle(0, 0, options.bigCircleSize / 2).append(group);
                        renderer.circle(0, 0, size).attr({
                            fill: "none"
                        }).append(group);
                        renderer.path([-size, -offset1, 0, -offset2, size, -offset1], "line").attr(directionOptions).append(group);
                        renderer.path([offset1, -size, offset2, 0, offset1, size], "line").attr(directionOptions).append(group);
                        renderer.path([size, offset1, 0, offset2, -size, offset1], "line").attr(directionOptions).append(group);
                        renderer.path([-offset1, size, -offset2, 0, -offset1, -size], "line").attr(directionOptions).append(group)
                    },
                    _createZoomBar(renderer, dataKey, group) {
                        const options = SIZE_OPTIONS;
                        const incDecButtonSize = options.incDecButtonSize / 2;
                        renderer.circle(0, options.incButtonOffset, options.smallCircleSize / 2).append(group);
                        renderer.path([
                            [-incDecButtonSize, options.incButtonOffset, incDecButtonSize, options.incButtonOffset],
                            [0, options.incButtonOffset - incDecButtonSize, 0, options.incButtonOffset + incDecButtonSize]
                        ], "area").append(group);
                        renderer.circle(0, options.decButtonOffset, options.smallCircleSize / 2).append(group);
                        renderer.path([-incDecButtonSize, options.decButtonOffset, incDecButtonSize, options.decButtonOffset], "area").append(group);
                        this._zoomLine = renderer.path([], "line").append(group);
                        this._zoomDrag = renderer.rect(_floor(-options.sliderLength / 2), _floor(options.sliderLineEndOffset - options.sliderWidth / 2), options.sliderLength, options.sliderWidth).append(group);
                        this._sliderLineLength = options.sliderLineEndOffset - options.sliderLineStartOffset
                    },
                    _createTrackersPan(renderer, dataKey, group) {
                        const options = SIZE_OPTIONS;
                        const size = _round((options.arrowButtonOffset - options.trackerGap) / 2);
                        const offset1 = options.arrowButtonOffset - size;
                        const offset2 = _round(_sqrt(options.bigCircleSize * options.bigCircleSize / 4 - size * size));
                        const size2 = offset2 - offset1;
                        renderer.rect(-size, -size, 2 * size, 2 * size).data(dataKey, {
                            index: "command-reset",
                            name: "control-bar"
                        }).append(group);
                        renderer.rect(-size, -offset2, 2 * size, size2).data(dataKey, {
                            index: "command-move-up",
                            name: "control-bar"
                        }).append(group);
                        renderer.rect(offset1, -size, size2, 2 * size).data(dataKey, {
                            index: "command-move-right",
                            name: "control-bar"
                        }).append(group);
                        renderer.rect(-size, offset1, 2 * size, size2).data(dataKey, {
                            index: "command-move-down",
                            name: "control-bar"
                        }).append(group);
                        renderer.rect(-offset2, -size, size2, 2 * size).data(dataKey, {
                            index: "command-move-left",
                            name: "control-bar"
                        }).append(group)
                    },
                    _createTrackersZoom(renderer, dataKey, group) {
                        const options = SIZE_OPTIONS;
                        renderer.circle(0, options.incButtonOffset, options.smallCircleSize / 2).data(dataKey, {
                            index: "command-zoom-in",
                            name: "control-bar"
                        }).append(group);
                        renderer.circle(0, options.decButtonOffset, options.smallCircleSize / 2).data(dataKey, {
                            index: "command-zoom-out",
                            name: "control-bar"
                        }).append(group);
                        renderer.rect(-2, options.sliderLineStartOffset - 2, 4, options.sliderLineEndOffset - options.sliderLineStartOffset + 4).css({
                            cursor: "default"
                        }).data(dataKey, {
                            index: "command-zoom-drag-line",
                            name: "control-bar"
                        }).append(group);
                        this._zoomDragTracker = renderer.rect(-options.sliderLength / 2, options.sliderLineEndOffset - options.sliderWidth / 2, options.sliderLength, options.sliderWidth).data(dataKey, {
                            index: "command-zoom-drag",
                            name: "control-bar"
                        }).append(group)
                    },
                    resize(size) {
                        if (this._isActive) {
                            this._root.attr({
                                visibility: null !== size ? null : "hidden"
                            })
                        }
                    },
                    getLayoutOptions() {
                        return this._isActive ? this._layoutOptions : null
                    },
                    locate(x, y) {
                        this._root.attr({
                            translateX: x + this._margin + 30.5,
                            translateY: y + this._margin + 30.5
                        })
                    },
                    _update() {
                        const that = this;
                        that._isActive = that._isEnabled && that._flags && that._params.projection.isInvertible();
                        const groupPan = [that._panControl, that._trackersPan];
                        const groupZoom = [that._zoomBar, that._trackersZoom];
                        if (that._isActive) {
                            that._root.linkAppend();
                            (0, _utils2.toggleDisplay)(groupPan, that._isPanVisible);
                            (0, _utils2.toggleDisplay)(groupZoom, that._isZoomVisible)
                        } else {
                            that._root.linkRemove()
                        }
                        that._processEnd();
                        that.updateLayout()
                    },
                    setInteraction(interaction) {
                        const that = this;
                        if ((0, _utils.parseScalar)(interaction.centeringEnabled, true)) {
                            that._flags |= 1
                        } else {
                            that._flags &= -2
                        }
                        if ((0, _utils.parseScalar)(interaction.zoomingEnabled, true)) {
                            that._flags |= 2
                        } else {
                            that._flags &= -3
                        }
                        that._update()
                    },
                    setOptions(options) {
                        const styleSvg = {
                            "stroke-width": options.borderWidth,
                            stroke: options.borderColor,
                            fill: options.color,
                            "fill-opacity": options.opacity
                        };
                        this._isEnabled = !!(0, _utils.parseScalar)(options.enabled, true);
                        this._margin = options.margin || 0;
                        this._layoutOptions = {
                            width: 2 * this._margin + 61,
                            height: 2 * this._margin + 274,
                            horizontalAlignment: parseHorizontalAlignment(options.horizontalAlignment, "left"),
                            verticalAlignment: parseVerticalAlignment(options.verticalAlignment, "top")
                        };
                        this._isPanVisible = !!(0, _utils.parseScalar)(options.panVisible, true);
                        this._isZoomVisible = !!(0, _utils.parseScalar)(options.zoomVisible, true);
                        this._panControl.attr(styleSvg);
                        this._zoomBar.attr(styleSvg);
                        this._update()
                    },
                    _adjustZoom(zoom) {
                        const start = SIZE_OPTIONS.sliderLineStartOffset;
                        const end = SIZE_OPTIONS.sliderLineEndOffset;
                        const h = SIZE_OPTIONS.sliderWidth;
                        this._zoomFactor = _max(_min(_round(zoom), this._zoomPartition), 0);
                        const transform = {
                            translateY: -_round(this._zoomFactor * this._sliderUnitLength)
                        };
                        const y = end - h / 2 + transform.translateY;
                        this._zoomLine.attr({
                            points: [
                                [0, start, 0, _max(start, y)],
                                [0, _min(end, y + h), 0, end]
                            ]
                        });
                        this._zoomDrag.attr(transform);
                        this._zoomDragTracker.attr(transform)
                    },
                    _applyZoom() {
                        this._callbacks.zoom(this._zoomFactor)
                    },
                    _processStart(command, arg) {
                        let commandType;
                        if (this._isActive) {
                            commandType = COMMAND_TO_TYPE_MAP[command];
                            this._command = commandType && commandType.flags & this._flags ? new commandType(this, command, arg) : null
                        }
                    },
                    _processMove(command, arg) {
                        this._command && this._command.update(command, arg)
                    },
                    _processEnd() {
                        this._command && this._command.finish();
                        this._command = null
                    }
                };

                function disposeCommand(command) {
                    delete command._owner;
                    command.update = function() {};
                    command.finish = function() {}
                }

                function ResetCommand(owner, command) {
                    this._owner = owner;
                    this._command = command
                }
                ResetCommand.flags = 3;
                ResetCommand.prototype.update = function(command) {
                    command !== this._command && disposeCommand(this)
                };
                ResetCommand.prototype.finish = function() {
                    const flags = this._owner._flags;
                    this._owner._callbacks.reset(!!(1 & flags), !!(2 & flags));
                    disposeCommand(this)
                };

                function MoveCommand(owner, command, arg) {
                    this._command = command;
                    let timeout = null;
                    let dx = 0;
                    let dy = 0;
                    switch (this._command) {
                        case "command-move-up":
                            dy = -10;
                            break;
                        case "command-move-right":
                            dx = 10;
                            break;
                        case "command-move-down":
                            dy = 10;
                            break;
                        case "command-move-left":
                            dx = -10
                    }
                    this._stop = function() {
                        clearTimeout(timeout);
                        owner._callbacks.endMove();
                        this._stop = owner = null;
                        return this
                    };
                    0;
                    owner._callbacks.beginMove();
                    ! function callback() {
                        owner._callbacks.move([dx, dy]);
                        timeout = setTimeout(callback, 100)
                    }()
                }
                MoveCommand.flags = 1;
                MoveCommand.prototype.update = function(command) {
                    this._command !== command && this.finish()
                };
                MoveCommand.prototype.finish = function() {
                    disposeCommand(this._stop())
                };

                function ZoomCommand(owner, command) {
                    this._owner = owner;
                    this._command = command;
                    let timeout = null;
                    const dZoom = "command-zoom-in" === this._command ? 1 : -1;
                    this._stop = function() {
                        clearTimeout(timeout);
                        this._stop = owner = null;
                        return this
                    };
                    ! function callback() {
                        owner._adjustZoom(owner._zoomFactor + dZoom);
                        timeout = setTimeout(callback, 150)
                    }()
                }
                ZoomCommand.flags = 2;
                ZoomCommand.prototype.update = function(command) {
                    this._command !== command && this.finish()
                };
                ZoomCommand.prototype.finish = function() {
                    this._owner._applyZoom();
                    disposeCommand(this._stop())
                };

                function ZoomDragCommand(owner, command, arg) {
                    this._owner = owner;
                    this._zoomFactor = owner._zoomFactor;
                    this._pos = arg.y
                }
                ZoomDragCommand.flags = 2;
                ZoomDragCommand.prototype.update = function(command, arg) {
                    const owner = this._owner;
                    owner._adjustZoom(this._zoomFactor + owner._zoomPartition * (this._pos - arg.y) / owner._sliderLineLength)
                };
                ZoomDragCommand.prototype.finish = function() {
                    this._owner._applyZoom();
                    disposeCommand(this)
                }
            },
        3664:
            /*!*******************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/axes/polar_axes.js ***!
              \*******************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.linearSpider = exports.linear = exports.circularSpider = exports.circular = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _axes_constants = _interopRequireDefault(__webpack_require__( /*! ../../viz/axes/axes_constants */ 42919));
                var _axes_utils = __webpack_require__( /*! ../../viz/axes/axes_utils */ 9399);
                var _tick = __webpack_require__( /*! ../../viz/axes/tick */ 33565);
                var _xy_axes = _interopRequireDefault(__webpack_require__( /*! ../../viz/axes/xy_axes */ 38231));
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const {
                    PI: PI,
                    abs: abs,
                    atan: atan,
                    round: round
                } = Math;
                const _min = Math.min;
                const _max = Math.max;
                const xyAxesLinear = _xy_axes.default.linear;

                function getPolarQuarter(angle) {
                    let quarter;
                    angle = (0, _utils.normalizeAngle)(angle);
                    if (angle >= 315 && angle <= 360 || angle < 45 && angle >= 0) {
                        quarter = 1
                    } else if (angle >= 45 && angle < 135) {
                        quarter = 2
                    } else if (angle >= 135 && angle < 225) {
                        quarter = 3
                    } else if (angle >= 225 && angle < 315) {
                        quarter = 4
                    }
                    return quarter
                }
                const circularAxes = {
                    _calculateValueMargins(ticks) {
                        let {
                            minVisible: minVisible,
                            maxVisible: maxVisible
                        } = this._getViewportRange();
                        if (ticks && ticks.length > 1) {
                            minVisible = minVisible < ticks[0].value ? minVisible : ticks[0].value;
                            maxVisible = minVisible > ticks[ticks.length - 1].value ? maxVisible : ticks[ticks.length - 1].value
                        }
                        return {
                            minValue: minVisible,
                            maxValue: maxVisible
                        }
                    },
                    applyMargins() {
                        const margins = this._calculateValueMargins(this._majorTicks);
                        const br = this._translator.getBusinessRange();
                        br.addRange({
                            minVisible: margins.minValue,
                            maxVisible: margins.maxValue,
                            interval: this._calculateRangeInterval(br.interval)
                        });
                        this._translator.updateBusinessRange(br)
                    },
                    _getTranslatorOptions() {
                        return {
                            isHorizontal: true,
                            conversionValue: true,
                            addSpiderCategory: this._getSpiderCategoryOption(),
                            stick: this._getStick()
                        }
                    },
                    getCenter() {
                        return this._center
                    },
                    getRadius() {
                        return this._radius
                    },
                    getAngles() {
                        const options = this._options;
                        return [options.startAngle, options.endAngle]
                    },
                    _updateRadius(canvas) {
                        const rad = _min(canvas.width - canvas.left - canvas.right, canvas.height - canvas.top - canvas.bottom) / 2;
                        this._radius = rad < 0 ? 0 : rad
                    },
                    _updateCenter(canvas) {
                        this._center = {
                            x: canvas.left + (canvas.width - canvas.right - canvas.left) / 2,
                            y: canvas.top + (canvas.height - canvas.top - canvas.bottom) / 2
                        }
                    },
                    _processCanvas(canvas) {
                        this._updateRadius(canvas);
                        this._updateCenter(canvas);
                        return {
                            left: 0,
                            right: 0,
                            width: this._getScreenDelta()
                        }
                    },
                    _createAxisElement() {
                        return this._renderer.circle()
                    },
                    _updateAxisElementPosition() {
                        const center = this.getCenter();
                        this._axisElement.attr({
                            cx: center.x,
                            cy: center.y,
                            r: this.getRadius()
                        })
                    },
                    _boundaryTicksVisibility: {
                        min: true
                    },
                    _getSpiderCategoryOption() {
                        return this._options.firstPointOnStartAngle
                    },
                    _validateOptions(options) {
                        const that = this;
                        let originValue = options.originValue;
                        const wholeRange = options.wholeRange = {};
                        const period = options.period;
                        if ((0, _type.isDefined)(originValue)) {
                            originValue = that.validateUnit(originValue)
                        }
                        if (period > 0 && options.argumentType === _axes_constants.default.numeric) {
                            originValue = originValue || 0;
                            wholeRange.endValue = originValue + period;
                            that._viewport = (0, _utils.getVizRangeObject)([originValue, wholeRange.endValue])
                        }
                        if ((0, _type.isDefined)(originValue)) {
                            wholeRange.startValue = originValue
                        }
                    },
                    getMargins() {
                        const tickOptions = this._options.tick;
                        const tickOuterLength = _max(tickOptions.visible ? tickOptions.length / 2 + tickOptions.shift : 0, 0);
                        const radius = this.getRadius();
                        const {
                            x: x,
                            y: y
                        } = this._center;
                        const labelBoxes = this._majorTicks.map((t => t.label && t.label.getBBox())).filter((b => b));
                        const canvas = (0, _extend.extend)({}, this._canvas, {
                            left: x - radius,
                            top: y - radius,
                            right: this._canvas.width - (x + radius),
                            bottom: this._canvas.height - (y + radius)
                        });
                        const margins = (0, _axes_utils.calculateCanvasMargins)(labelBoxes, canvas);
                        Object.keys(margins).forEach((k => margins[k] = margins[k] < tickOuterLength ? tickOuterLength : margins[k]));
                        return margins
                    },
                    _updateLabelsPosition() {
                        (0, _axes_utils.measureLabels)(this._majorTicks);
                        this._adjustLabelsCoord(0, 0, true);
                        this._checkBoundedLabelsOverlapping(this._majorTicks, this._majorTicks.map((t => t.labelBBox)))
                    },
                    _setVisualRange: _common.noop,
                    applyVisualRangeSetter: _common.noop,
                    _getStick() {
                        return this._options.firstPointOnStartAngle || this._options.type !== _axes_constants.default.discrete
                    },
                    _getTranslatedCoord(value, offset) {
                        return this._translator.translate(value, offset) - 90
                    },
                    _getCanvasStartEnd: () => ({
                        start: -90,
                        end: 270
                    }),
                    _getStripGraphicAttributes(fromAngle, toAngle) {
                        const center = this.getCenter();
                        const angle = this.getAngles()[0];
                        const r = this.getRadius();
                        return {
                            x: center.x,
                            y: center.y,
                            innerRadius: 0,
                            outerRadius: r,
                            startAngle: -toAngle - angle,
                            endAngle: -fromAngle - angle
                        }
                    },
                    _createStrip(coords) {
                        return this._renderer.arc(coords.x, coords.y, coords.innerRadius, coords.outerRadius, coords.startAngle, coords.endAngle)
                    },
                    _getStripLabelCoords(from, to) {
                        const coords = this._getStripGraphicAttributes(from, to);
                        const angle = coords.startAngle + (coords.endAngle - coords.startAngle) / 2;
                        const cosSin = (0, _utils.getCosAndSin)(angle);
                        const halfRad = this.getRadius() / 2;
                        const center = this.getCenter();
                        const x = round(center.x + halfRad * cosSin.cos);
                        const y = round(center.y - halfRad * cosSin.sin);
                        return {
                            x: x,
                            y: y,
                            align: _axes_constants.default.center
                        }
                    },
                    _getConstantLineGraphicAttributes(value) {
                        const center = this.getCenter();
                        const r = this.getRadius();
                        return {
                            points: [center.x, center.y, center.x + r, center.y]
                        }
                    },
                    _createConstantLine(value, attr) {
                        return this._createPathElement(this._getConstantLineGraphicAttributes(value).points, attr)
                    },
                    _rotateConstantLine(line, value) {
                        const {
                            x: x,
                            y: y
                        } = this.getCenter();
                        line.rotate(value + this.getAngles()[0], x, y)
                    },
                    _getConstantLineLabelsCoords(value) {
                        const cosSin = (0, _utils.getCosAndSin)(-value - this.getAngles()[0]);
                        const halfRad = this.getRadius() / 2;
                        const center = this.getCenter();
                        const x = round(center.x + halfRad * cosSin.cos);
                        const y = round(center.y - halfRad * cosSin.sin);
                        return {
                            x: x,
                            y: y
                        }
                    },
                    _checkAlignmentConstantLineLabels: _common.noop,
                    _adjustDivisionFactor(val) {
                        return 180 * val / (this.getRadius() * PI)
                    },
                    _getScreenDelta() {
                        const angles = this.getAngles();
                        return abs(angles[0] - angles[1])
                    },
                    _getTickMarkPoints(coords, length, _ref) {
                        let {
                            shift: shift = 0
                        } = _ref;
                        const center = this.getCenter();
                        const radiusWithTicks = this.getRadius() + length * {
                            inside: -1,
                            center: -.5,
                            outside: 0
                        } [this._options.tickOrientation || "center"];
                        return [center.x + radiusWithTicks + shift, center.y, center.x + radiusWithTicks + length + shift, center.y]
                    },
                    _getLabelAdjustedCoord(tick, _offset, _maxWidth, checkCanvas) {
                        const that = this;
                        const labelCoords = tick.labelCoords;
                        const labelY = labelCoords.y;
                        const labelAngle = labelCoords.angle;
                        const cosSin = (0, _utils.getCosAndSin)(labelAngle);
                        const cos = cosSin.cos;
                        const sin = cosSin.sin;
                        const box = tick.labelBBox;
                        const halfWidth = box.width / 2;
                        const halfHeight = box.height / 2;
                        const indentFromAxis = that._options.label.indentFromAxis || 0;
                        const x = labelCoords.x + indentFromAxis * cos;
                        const y = labelY + (labelY - box.y - halfHeight) + indentFromAxis * sin;
                        let shiftX = 0;
                        let shiftY = 0;
                        switch (getPolarQuarter(labelAngle)) {
                            case 1:
                                shiftX = halfWidth;
                                shiftY = halfHeight * sin;
                                break;
                            case 2:
                                shiftX = halfWidth * cos;
                                shiftY = halfHeight;
                                break;
                            case 3:
                                shiftX = -halfWidth;
                                shiftY = halfHeight * sin;
                                break;
                            case 4:
                                shiftX = halfWidth * cos;
                                shiftY = -halfHeight
                        }
                        if (checkCanvas) {
                            const canvas = that._canvas;
                            const boxShiftX = x - labelCoords.x + shiftX;
                            const boxShiftY = y - labelCoords.y + shiftY;
                            if (box.x + boxShiftX < canvas.originalLeft) {
                                shiftX -= box.x + boxShiftX - canvas.originalLeft
                            }
                            if (box.x + box.width + boxShiftX > canvas.width - canvas.originalRight) {
                                shiftX -= box.x + box.width + boxShiftX - (canvas.width - canvas.originalRight)
                            }
                            if (box.y + boxShiftY < canvas.originalTop) {
                                shiftY -= box.y + boxShiftY - canvas.originalTop
                            }
                            if (box.y + box.height + boxShiftY > canvas.height - canvas.originalBottom) {
                                shiftY -= box.y + box.height + boxShiftY - (canvas.height - canvas.originalBottom)
                            }
                        }
                        return {
                            x: x + shiftX,
                            y: y + shiftY
                        }
                    },
                    _getGridLineDrawer() {
                        const that = this;
                        return function(tick, gridStyle) {
                            const center = that.getCenter();
                            return that._createPathElement(that._getGridPoints().points, gridStyle).rotate(tick.coords.angle, center.x, center.y)
                        }
                    },
                    _getGridPoints() {
                        const r = this.getRadius();
                        const center = this.getCenter();
                        return {
                            points: [center.x, center.y, center.x + r, center.y]
                        }
                    },
                    _getTranslatedValue(value, offset) {
                        const startAngle = this.getAngles()[0];
                        const angle = this._translator.translate(value, -offset);
                        const coords = (0, _utils.convertPolarToXY)(this.getCenter(), startAngle, angle, this.getRadius());
                        return {
                            x: coords.x,
                            y: coords.y,
                            angle: this.getTranslatedAngle(angle)
                        }
                    },
                    _getAdjustedStripLabelCoords(strip) {
                        const box = strip.labelBBox;
                        return {
                            translateY: strip.label.attr("y") - box.y - box.height / 2
                        }
                    },
                    coordsIn(x, y) {
                        return (0, _utils.convertXYToPolar)(this.getCenter(), x, y).r > this.getRadius()
                    },
                    _rotateTick(element, coords) {
                        const center = this.getCenter();
                        element.rotate(coords.angle, center.x, center.y)
                    },
                    _validateOverlappingMode: mode => _axes_constants.default.validateOverlappingMode(mode),
                    _validateDisplayMode: () => "standard",
                    _getStep(boxes) {
                        const radius = this.getRadius() + (this._options.label.indentFromAxis || 0);
                        const maxLabelBox = boxes.reduce(((prevValue, box) => {
                            const curValue = prevValue;
                            if (prevValue.width < box.width) {
                                curValue.width = box.width
                            }
                            if (prevValue.height < box.height) {
                                curValue.height = box.height
                            }
                            return curValue
                        }), {
                            width: 0,
                            height: 0
                        });
                        const angle1 = abs(2 * atan(maxLabelBox.height / (2 * radius - maxLabelBox.width)) * 180 / PI);
                        const angle2 = abs(2 * atan(maxLabelBox.width / (2 * radius - maxLabelBox.height)) * 180 / PI);
                        return _axes_constants.default.getTicksCountInRange(this._majorTicks, "angle", _max(angle1, angle2))
                    },
                    _checkBoundedLabelsOverlapping(majorTicks, boxes, mode) {
                        const labelOpt = this._options.label;
                        mode = mode || this._validateOverlappingMode(labelOpt.overlappingBehavior);
                        if ("hide" !== mode) {
                            return
                        }
                        const lastVisibleLabelIndex = majorTicks.reduce(((lastVisibleLabelIndex, tick, index) => tick.label ? index : lastVisibleLabelIndex), null);
                        if (!lastVisibleLabelIndex) {
                            return
                        }
                        if (_axes_constants.default.areLabelsOverlap(boxes[0], boxes[lastVisibleLabelIndex], labelOpt.minSpacing, _axes_constants.default.center)) {
                            "first" === labelOpt.hideFirstOrLast ? majorTicks[0].removeLabel() : majorTicks[lastVisibleLabelIndex].removeLabel()
                        }
                    },
                    shift(margins) {
                        this._axisGroup.attr({
                            translateX: margins.right,
                            translateY: margins.bottom
                        });
                        this._axisElementsGroup.attr({
                            translateX: margins.right,
                            translateY: margins.bottom
                        })
                    },
                    getTranslatedAngle(angle) {
                        const startAngle = this.getAngles()[0];
                        return angle + startAngle - 90
                    }
                };
                exports.circular = circularAxes;
                const circularSpider = exports.circularSpider = (0, _extend.extend)({}, circularAxes, {
                    _createAxisElement() {
                        return this._renderer.path([], "area")
                    },
                    _updateAxisElementPosition() {
                        this._axisElement.attr({
                            points: (0, _utils.map)(this.getSpiderTicks(), (tick => ({
                                x: tick.coords.x,
                                y: tick.coords.y
                            })))
                        })
                    },
                    _getStick: () => true,
                    _getSpiderCategoryOption: () => true,
                    getSpiderTicks() {
                        const ticks = this.getFullTicks();
                        this._spiderTicks = ticks.map((0, _tick.tick)(this, this.renderer, {}, {}, this._getSkippedCategory(ticks), true));
                        this._spiderTicks.forEach((tick => {
                            tick.initCoords()
                        }));
                        return this._spiderTicks
                    },
                    _getStripGraphicAttributes(fromAngle, toAngle) {
                        const center = this.getCenter();
                        const spiderTicks = this.getSpiderTicks();
                        let firstTick;
                        let lastTick;
                        let nextTick;
                        let tick;
                        const points = [];
                        let i = 0;
                        const len = spiderTicks.length;
                        while (i < len) {
                            tick = spiderTicks[i].coords;
                            if (tick.angle >= fromAngle && tick.angle <= toAngle) {
                                if (!firstTick) {
                                    firstTick = (spiderTicks[i - 1] || spiderTicks[spiderTicks.length - 1]).coords;
                                    points.push((tick.x + firstTick.x) / 2, (tick.y + firstTick.y) / 2)
                                }
                                points.push(tick.x, tick.y);
                                nextTick = (spiderTicks[i + 1] || spiderTicks[0]).coords;
                                lastTick = {
                                    x: (tick.x + nextTick.x) / 2,
                                    y: (tick.y + nextTick.y) / 2
                                }
                            }
                            i++
                        }
                        points.push(lastTick.x, lastTick.y);
                        points.push(center.x, center.y);
                        return {
                            points: points
                        }
                    },
                    _createStrip(_ref2) {
                        let {
                            points: points
                        } = _ref2;
                        return this._renderer.path(points, "area")
                    },
                    _getTranslatedCoord(value, offset) {
                        return this._translator.translate(value, offset) - 90
                    },
                    _setTickOffset() {
                        this._tickOffset = false
                    }
                });
                const linear = exports.linear = {
                    _resetMargins() {
                        this._reinitTranslator(this._getViewportRange())
                    },
                    _getStick: xyAxesLinear._getStick,
                    _getSpiderCategoryOption: _common.noop,
                    _getTranslatorOptions() {
                        return {
                            isHorizontal: true,
                            stick: this._getStick()
                        }
                    },
                    getRadius: circularAxes.getRadius,
                    getCenter: circularAxes.getCenter,
                    getAngles: circularAxes.getAngles,
                    _updateRadius: circularAxes._updateRadius,
                    _updateCenter: circularAxes._updateCenter,
                    _processCanvas(canvas) {
                        this._updateRadius(canvas);
                        this._updateCenter(canvas);
                        return {
                            left: 0,
                            right: 0,
                            startPadding: canvas.startPadding,
                            endPadding: canvas.endPadding,
                            width: this.getRadius()
                        }
                    },
                    _createAxisElement: xyAxesLinear._createAxisElement,
                    _updateAxisElementPosition() {
                        const centerCoord = this.getCenter();
                        this._axisElement.attr({
                            points: [centerCoord.x, centerCoord.y, centerCoord.x + this.getRadius(), centerCoord.y]
                        }).rotate(this.getAngles()[0] - 90, centerCoord.x, centerCoord.y)
                    },
                    _getScreenDelta() {
                        return this.getRadius()
                    },
                    _getTickMarkPoints: (coords, length) => [coords.x - length / 2, coords.y, coords.x + length / 2, coords.y],
                    _getLabelAdjustedCoord(tick) {
                        const labelCoords = tick.labelCoords;
                        const labelY = labelCoords.y;
                        const cosSin = (0, _utils.getCosAndSin)(labelCoords.angle);
                        const indentFromAxis = this._options.label.indentFromAxis || 0;
                        const box = tick.labelBBox;
                        const x = labelCoords.x - abs(indentFromAxis * cosSin.sin) + abs(box.width / 2 * cosSin.cos) - box.width / 2;
                        const y = labelY + (labelY - box.y) - abs(box.height / 2 * cosSin.sin) + abs(indentFromAxis * cosSin.cos);
                        return {
                            x: x,
                            y: y
                        }
                    },
                    _getGridLineDrawer() {
                        const that = this;
                        return function(tick, gridStyle) {
                            const grid = that._getGridPoints(tick.coords);
                            return that._renderer.circle(grid.cx, grid.cy, grid.r).attr(gridStyle).sharp()
                        }
                    },
                    _getGridPoints(coords) {
                        const pos = this.getCenter();
                        const radius = (0, _utils.getDistance)(pos.x, pos.y, coords.x, coords.y);
                        if (radius > this.getRadius()) {
                            return {
                                cx: null,
                                cy: null,
                                r: null
                            }
                        }
                        return {
                            cx: pos.x,
                            cy: pos.y,
                            r: radius
                        }
                    },
                    _getTranslatedValue(value, offset) {
                        const startAngle = this.getAngles()[0];
                        const xy = (0, _utils.convertPolarToXY)(this.getCenter(), startAngle, 0, this._translator.translate(value, offset));
                        return {
                            x: xy.x,
                            y: xy.y,
                            angle: startAngle - 90
                        }
                    },
                    _getTranslatedCoord(value, offset) {
                        return this._translator.translate(value, offset)
                    },
                    _getCanvasStartEnd() {
                        const invert = this.getTranslator().getBusinessRange().invert;
                        const coords = [0, this.getRadius()];
                        invert && coords.reverse();
                        return {
                            start: coords[0],
                            end: coords[1]
                        }
                    },
                    _getStripGraphicAttributes(fromPoint, toPoint) {
                        const center = this.getCenter();
                        return {
                            x: center.x,
                            y: center.y,
                            innerRadius: fromPoint,
                            outerRadius: toPoint
                        }
                    },
                    _createStrip(attrs) {
                        return this._renderer.arc(attrs.x, attrs.y, attrs.innerRadius, attrs.outerRadius, 0, 360)
                    },
                    _getAdjustedStripLabelCoords: circularAxes._getAdjustedStripLabelCoords,
                    _getStripLabelCoords(from, to) {
                        const labelPos = from + (to - from) / 2;
                        const center = this.getCenter();
                        const y = round(center.y - labelPos);
                        return {
                            x: center.x,
                            y: y,
                            align: _axes_constants.default.center
                        }
                    },
                    _getConstantLineGraphicAttributes(value) {
                        const center = this.getCenter();
                        return {
                            cx: center.x,
                            cy: center.y,
                            r: value
                        }
                    },
                    _createConstantLine(value, attr) {
                        const attrs = this._getConstantLineGraphicAttributes(value);
                        return this._renderer.circle(attrs.cx, attrs.cy, attrs.r).attr(attr).sharp()
                    },
                    _getConstantLineLabelsCoords(value) {
                        const center = this.getCenter();
                        const y = round(center.y - value);
                        return {
                            x: center.x,
                            y: y
                        }
                    },
                    _checkAlignmentConstantLineLabels: _common.noop,
                    _rotateTick(element, coords, isGridLine) {
                        !isGridLine && element.rotate(coords.angle + 90, coords.x, coords.y)
                    },
                    _validateOverlappingMode: circularAxes._validateOverlappingMode,
                    _validateDisplayMode: circularAxes._validateDisplayMode,
                    _getStep(boxes) {
                        const quarter = getPolarQuarter(this.getAngles()[0]);
                        const spacing = this._options.label.minSpacing;
                        const func = 2 === quarter || 4 === quarter ? function(box) {
                            return box.width + spacing
                        } : function(box) {
                            return box.height
                        };
                        const maxLabelLength = boxes.reduce(((prevValue, box) => _max(prevValue, func(box))), 0);
                        return _axes_constants.default.getTicksCountInRange(this._majorTicks, 2 === quarter || 4 === quarter ? "x" : "y", maxLabelLength)
                    }
                };
                exports.linearSpider = (0, _extend.extend)({}, linear, {
                    _createPathElement(points, attr) {
                        return this._renderer.path(points, "area").attr(attr).sharp()
                    },
                    setSpiderTicks(ticks) {
                        this._spiderTicks = ticks
                    },
                    _getGridLineDrawer() {
                        const that = this;
                        return function(tick, gridStyle) {
                            return that._createPathElement(that._getGridPoints(tick.coords).points, gridStyle)
                        }
                    },
                    _getGridPoints(coords) {
                        const pos = this.getCenter();
                        const radius = (0, _utils.getDistance)(pos.x, pos.y, coords.x, coords.y);
                        return this._getGridPointsByRadius(radius)
                    },
                    _getGridPointsByRadius(radius) {
                        const pos = this.getCenter();
                        if (radius > this.getRadius()) {
                            return {
                                points: null
                            }
                        }
                        return {
                            points: (0, _utils.map)(this._spiderTicks, (tick => {
                                const cosSin = (0, _utils.getCosAndSin)(tick.coords.angle);
                                return {
                                    x: round(pos.x + radius * cosSin.cos),
                                    y: round(pos.y + radius * cosSin.sin)
                                }
                            }))
                        }
                    },
                    _getStripGraphicAttributes(fromPoint, toPoint) {
                        const innerPoints = this._getGridPointsByRadius(toPoint).points;
                        const outerPoints = this._getGridPointsByRadius(fromPoint).points;
                        return {
                            points: [outerPoints, innerPoints.reverse()]
                        }
                    },
                    _createStrip: circularSpider._createStrip,
                    _getConstantLineGraphicAttributes(value) {
                        return this._getGridPointsByRadius(value)
                    },
                    _createConstantLine(value, attr) {
                        return this._createPathElement(this._getConstantLineGraphicAttributes(value).points, attr)
                    }
                })
            },
        3794:
            /*!******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/integration/knockout/component_registrator.js ***!
              \******************************************************************************************************/
            (__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../../core/renderer */ 64553));
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../../ui/widget/ui.widget */ 11118));
                var _m_component_registrator_callbacks = __webpack_require__( /*! ../../core/m_component_registrator_callbacks */ 21233);
                var _m_config = _interopRequireDefault(__webpack_require__( /*! ../../core/m_config */ 34338));
                var _component_wrapper = __webpack_require__( /*! ../../core/r1/component_wrapper */ 34993);
                var _m_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/m_callbacks */ 63172));
                var _m_locker = __webpack_require__( /*! ../../core/utils/m_locker */ 24574);
                var _m_type = __webpack_require__( /*! ../../core/utils/m_type */ 39918);
                var _m_draggable = _interopRequireDefault(__webpack_require__( /*! ../../m_draggable */ 89983));
                var _editor = _interopRequireDefault(__webpack_require__( /*! ../../ui/editor/editor */ 24768));
                var _scroll_view = _interopRequireDefault(__webpack_require__( /*! ../../ui/scroll_view/scroll_view */ 71100));
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../../viz/core/m_base_widget */ 34506));
                var _knockout = _interopRequireDefault(__webpack_require__( /*! knockout */ 78117));
                var _template = __webpack_require__( /*! ./template */ 36390);
                var _utils = __webpack_require__( /*! ./utils */ 41983);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                if (_knockout.default) {
                    const LOCKS_DATA_KEY = "dxKoLocks";
                    const CREATED_WITH_KO_DATA_KEY = "dxKoCreation";
                    const editorsBindingHandlers = [];
                    const registerComponentKoBinding = function(componentName, componentClass) {
                        if (_editor.default.isEditor(componentClass.prototype)) {
                            editorsBindingHandlers.push(componentName)
                        }
                        _knockout.default.bindingHandlers[componentName] = {
                            init(domNode, valueAccessor) {
                                const $element = (0, _renderer.default)(domNode);
                                const optionChangedCallbacks = (0, _m_callbacks.default)();
                                let optionsByReference = {};
                                let component;
                                const knockoutConfig = (0, _m_config.default)().knockout;
                                const isBindingPropertyPredicateName = null === knockoutConfig || void 0 === knockoutConfig ? void 0 : knockoutConfig.isBindingPropertyPredicateName;
                                let isBindingPropertyPredicate;
                                let ctorOptions = {
                                    onInitializing(options) {
                                        optionsByReference = this._getOptionsByReference();
                                        _knockout.default.computed((() => {
                                            const model = _knockout.default.unwrap(valueAccessor());
                                            if (component) {
                                                component.beginUpdate()
                                            }
                                            isBindingPropertyPredicate = isBindingPropertyPredicateName && (null === model || void 0 === model ? void 0 : model[isBindingPropertyPredicateName]);
                                            unwrapModel(model);
                                            if (component) {
                                                component.endUpdate()
                                            } else {
                                                var _model$onInitializing;
                                                null === model || void 0 === model || null === (_model$onInitializing = model.onInitializing) || void 0 === _model$onInitializing || _model$onInitializing.call(this, options)
                                            }
                                        }), null, {
                                            disposeWhenNodeIsRemoved: domNode
                                        });
                                        component = this
                                    },
                                    modelByElement($element) {
                                        if ($element.length) {
                                            const node = (0, _utils.getClosestNodeWithContext)($element.get(0));
                                            return _knockout.default.dataFor(node)
                                        }
                                    },
                                    nestedComponentOptions: component => ({
                                        modelByElement: component.option("modelByElement"),
                                        nestedComponentOptions: component.option("nestedComponentOptions")
                                    }),
                                    _optionChangedCallbacks: optionChangedCallbacks,
                                    integrationOptions: {
                                        watchMethod(fn, callback, options) {
                                            options = options || {};
                                            let skipCallback = options.skipImmediate;
                                            const watcher = _knockout.default.computed((() => {
                                                const newValue = _knockout.default.unwrap(fn());
                                                if (!skipCallback) {
                                                    callback(newValue)
                                                }
                                                skipCallback = false
                                            }));
                                            return function() {
                                                watcher.dispose()
                                            }
                                        },
                                        templates: {
                                            "dx-polymorph-widget": {
                                                render(options) {
                                                    const widgetName = _knockout.default.utils.unwrapObservable(options.model.widget);
                                                    if (!widgetName) {
                                                        return
                                                    }
                                                    const markup = (0, _renderer.default)("<div>").attr("data-bind", `${widgetName}: options`).get(0);
                                                    (0, _renderer.default)(options.container).append(markup);
                                                    _knockout.default.applyBindings(options.model, markup)
                                                }
                                            }
                                        },
                                        createTemplate: element => new _template.KoTemplate(element)
                                    }
                                };
                                const optionNameToModelMap = {};
                                const applyModelValueToOption = function(optionName, modelValue, unwrap) {
                                    const locks = $element.data(LOCKS_DATA_KEY);
                                    const optionValue = unwrap ? _knockout.default.unwrap(modelValue) : modelValue;
                                    if (_knockout.default.isWriteableObservable(modelValue)) {
                                        optionNameToModelMap[optionName] = modelValue
                                    }
                                    if (component) {
                                        if (locks.locked(optionName)) {
                                            return
                                        }
                                        locks.obtain(optionName);
                                        try {
                                            if (_knockout.default.ignoreDependencies) {
                                                _knockout.default.ignoreDependencies(component.option, component, [optionName, optionValue])
                                            } else {
                                                component.option(optionName, optionValue)
                                            }
                                        } finally {
                                            locks.release(optionName)
                                        }
                                    } else {
                                        ctorOptions[optionName] = optionValue
                                    }
                                };
                                const handleOptionChanged = function(args) {
                                    const optionName = args.fullName;
                                    const optionValue = args.value;
                                    if (!(optionName in optionNameToModelMap)) {
                                        return
                                    }
                                    const $element = this._$element;
                                    const locks = $element.data(LOCKS_DATA_KEY);
                                    if (locks.locked(optionName)) {
                                        return
                                    }
                                    locks.obtain(optionName);
                                    try {
                                        optionNameToModelMap[optionName](optionValue)
                                    } finally {
                                        locks.release(optionName)
                                    }
                                };
                                const unwrapModelValue = function(currentModel, propertyName, propertyPath) {
                                    if (propertyPath === isBindingPropertyPredicateName) {
                                        return
                                    }
                                    if (!isBindingPropertyPredicate || isBindingPropertyPredicate(propertyPath, propertyName, currentModel)) {
                                        let unwrappedPropertyValue;
                                        _knockout.default.computed((() => {
                                            const propertyValue = currentModel[propertyName];
                                            applyModelValueToOption(propertyPath, propertyValue, true);
                                            unwrappedPropertyValue = _knockout.default.unwrap(propertyValue)
                                        }), null, {
                                            disposeWhenNodeIsRemoved: domNode
                                        });
                                        if ((0, _m_type.isPlainObject)(unwrappedPropertyValue)) {
                                            if (!optionsByReference[propertyPath]) {
                                                unwrapModel(unwrappedPropertyValue, propertyPath)
                                            }
                                        }
                                    } else {
                                        applyModelValueToOption(propertyPath, currentModel[propertyName], false)
                                    }
                                };

                                function unwrapModel(model, propertyPath) {
                                    for (const propertyName in model) {
                                        if (Object.prototype.hasOwnProperty.call(model, propertyName)) {
                                            unwrapModelValue(model, propertyName, propertyPath ? [propertyPath, propertyName].join(".") : propertyName)
                                        }
                                    }
                                }! function() {
                                    optionChangedCallbacks.add(handleOptionChanged);
                                    $element.data(CREATED_WITH_KO_DATA_KEY, true).data(LOCKS_DATA_KEY, new _m_locker.Locker);
                                    new componentClass($element, ctorOptions);
                                    ctorOptions = null
                                }();
                                return {
                                    controlsDescendantBindings: componentClass.subclassOf(_ui.default) || componentClass.subclassOf(_m_base_widget.default) || componentClass.subclassOf(_component_wrapper.ComponentWrapper) && !(component instanceof _scroll_view.default) || component instanceof _m_draggable.default
                                }
                            }
                        };
                        if ("dxValidator" === componentName) {
                            _knockout.default.bindingHandlers.dxValidator.after = editorsBindingHandlers
                        }
                    };
                    _m_component_registrator_callbacks.componentRegistratorCallbacks.add(((name, componentClass) => {
                        registerComponentKoBinding(name, componentClass)
                    }))
                }
            },
        3830:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/m_chart.js ***!
              \***********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../core/component_registrator */ 92848));
                var _common = __webpack_require__( /*! ../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _math = __webpack_require__( /*! ../../core/utils/math */ 50254);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                var _crosshair = __webpack_require__( /*! ../viz/chart_components/crosshair */ 566);
                var _layout_manager = __webpack_require__( /*! ../viz/chart_components/layout_manager */ 23146);
                var _multi_axes_synchronizer = _interopRequireDefault(__webpack_require__( /*! ../viz/chart_components/multi_axes_synchronizer */ 37898));
                var _scroll_bar = __webpack_require__( /*! ../viz/chart_components/scroll_bar */ 52175);
                var _shutter_zoom = _interopRequireDefault(__webpack_require__( /*! ../viz/chart_components/shutter_zoom */ 48857));
                var _zoom_and_pan = _interopRequireDefault(__webpack_require__( /*! ../viz/chart_components/zoom_and_pan */ 38577));
                var _annotations = __webpack_require__( /*! ../viz/core/annotations */ 77438);
                var _utils = __webpack_require__( /*! ../viz/core/utils */ 98013);
                var _range_data_calculator = _interopRequireDefault(__webpack_require__( /*! ../viz/series/helpers/range_data_calculator */ 41971));
                var _range = __webpack_require__( /*! ../viz/translators/range */ 8315);
                var _utils2 = __webpack_require__( /*! ../viz/utils */ 49143);
                var _m_advanced_chart = __webpack_require__( /*! ./chart_components/m_advanced_chart */ 78609);
                var _m_base_chart = __webpack_require__( /*! ./chart_components/m_base_chart */ 9410);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const DEFAULT_PANES = [{
                    name: "default",
                    border: {}
                }];
                const {
                    isArray: isArray
                } = Array;

                function changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility) {
                    const gridOpt = axis.getOptions().grid;
                    const minorGridOpt = axis.getOptions().minorGrid;
                    gridOpt.visible = gridVisibility;
                    minorGridOpt && (minorGridOpt.visible = minorGridVisibility)
                }

                function findAxis(paneName, axisName, axes) {
                    const axisByName = axes.find((axis => axis.name === axisName && axis.pane === paneName));
                    if (axisByName) {
                        return axisByName
                    }
                    if (paneName) {
                        return findAxis(void 0, axisName, axes)
                    }
                }

                function compareAxes(a, b) {
                    return a.priority - b.priority
                }

                function doesPaneExist(panes, paneName) {
                    let found = false;
                    (0, _iterator.each)(panes, ((_, pane) => {
                        if (pane.name === paneName) {
                            found = true;
                            return false
                        }
                        return
                    }));
                    return found
                }

                function accumulate(field, src1, src2, auxSpacing) {
                    const val1 = src1[field] || 0;
                    const val2 = src2[field] || 0;
                    return val1 + val2 + (val1 && val2 ? auxSpacing : 0)
                }

                function pickMax(field, src1, src2) {
                    return pickMaxValue(src1[field], src2[field])
                }

                function pickMaxValue(val1, val2) {
                    return Math.max(val1 || 0, val2 || 0)
                }

                function getAxisMargins(axis) {
                    return axis.getMargins()
                }

                function getHorizontalAxesMargins(axes, getMarginsFunc) {
                    return axes.reduce(((margins, axis) => {
                        var _axis$getOrthogonalAx;
                        const axisMargins = getMarginsFunc(axis);
                        const paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        const spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = accumulate("top", paneMargins, axisMargins, spacing);
                        paneMargins.bottom = accumulate("bottom", paneMargins, axisMargins, spacing);
                        paneMargins.left = pickMax("left", paneMargins, axisMargins);
                        paneMargins.right = pickMax("right", paneMargins, axisMargins);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        const orthogonalAxis = null === (_axis$getOrthogonalAx = axis.getOrthogonalAxis) || void 0 === _axis$getOrthogonalAx ? void 0 : _axis$getOrthogonalAx.call(axis);
                        const shouldResetPositionMargin = (null === orthogonalAxis || void 0 === orthogonalAxis ? void 0 : orthogonalAxis.customPositionIsAvailable()) && (!axis.customPositionIsBoundaryOrthogonalAxis() || !orthogonalAxis.customPositionEqualsToPredefined());
                        if (shouldResetPositionMargin) {
                            margins[orthogonalAxis.getResolvedBoundaryPosition()] = 0
                        }
                        return margins
                    }), {
                        panes: {}
                    })
                }

                function getVerticalAxesMargins(axes) {
                    return axes.reduce(((margins, axis) => {
                        const axisMargins = axis.getMargins();
                        const paneMargins = margins.panes[axis.pane] = margins.panes[axis.pane] || {};
                        const spacing = axis.getMultipleAxesSpacing();
                        paneMargins.top = pickMax("top", paneMargins, axisMargins);
                        paneMargins.bottom = pickMax("bottom", paneMargins, axisMargins);
                        paneMargins.left = accumulate("left", paneMargins, axisMargins, spacing);
                        paneMargins.right = accumulate("right", paneMargins, axisMargins, spacing);
                        margins.top = pickMax("top", paneMargins, margins);
                        margins.bottom = pickMax("bottom", paneMargins, margins);
                        margins.left = pickMax("left", paneMargins, margins);
                        margins.right = pickMax("right", paneMargins, margins);
                        return margins
                    }), {
                        panes: {}
                    })
                }

                function performActionOnAxes(axes, action, actionArgument1, actionArgument2, actionArgument3) {
                    axes.forEach((axis => {
                        axis[action](null === actionArgument1 || void 0 === actionArgument1 ? void 0 : actionArgument1[axis.pane], (null === actionArgument2 || void 0 === actionArgument2 ? void 0 : actionArgument2[axis.pane]) || actionArgument2, actionArgument3)
                    }))
                }

                function shrinkCanvases(isRotated, canvases, sizes, verticalMargins, horizontalMargins) {
                    function getMargin(side, margins, pane) {
                        const m = !(isRotated ? ["left", "right"] : ["top", "bottom"]).includes(side) ? margins : margins.panes[pane] || {};
                        return m[side]
                    }

                    function getMaxMargin(side, margins1, margins2, pane) {
                        return pickMaxValue(getMargin(side, margins1, pane), getMargin(side, margins2, pane))
                    }
                    const getOriginalField = field => `original${field[0].toUpperCase()}${field.slice(1)}`;

                    function shrink(canvases, paneNames, sizeField, startMargin, endMargin, oppositeMargins) {
                        paneNames = paneNames.sort(((p1, p2) => canvases[p2][startMargin] - canvases[p1][startMargin]));
                        paneNames.forEach((pane => {
                            const canvas = canvases[pane];
                            oppositeMargins.forEach((margin => {
                                canvas[margin] = canvas[getOriginalField(margin)] + getMaxMargin(margin, verticalMargins, horizontalMargins, pane)
                            }))
                        }));
                        const firstPane = canvases[paneNames[0]];
                        const initialEmptySpace = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - canvases[paneNames.at(-1)][getOriginalField(startMargin)];
                        let emptySpace = paneNames.reduce(((space, paneName) => {
                            const maxStartMargin = getMaxMargin(startMargin, verticalMargins, horizontalMargins, paneName);
                            const maxEndMargin = getMaxMargin(endMargin, verticalMargins, horizontalMargins, paneName);
                            return space - maxStartMargin - maxEndMargin
                        }), initialEmptySpace) - _utils.PANE_PADDING * (paneNames.length - 1);
                        emptySpace -= Object.keys(sizes).reduce(((prev, key) => {
                            const currentHeight = !(0, _utils.isRelativeHeightPane)(sizes[key]) ? sizes[key].height : 0;
                            return prev + currentHeight
                        }), 0);
                        const initialOffset = firstPane[sizeField] - firstPane[getOriginalField(endMargin)] - (emptySpace < 0 ? emptySpace : 0);
                        paneNames.reduce(((offset, pane) => {
                            const canvas = canvases[pane];
                            const paneSize = sizes[pane];
                            offset -= getMaxMargin(endMargin, verticalMargins, horizontalMargins, pane);
                            canvas[endMargin] = firstPane[sizeField] - offset;
                            offset -= !(0, _utils.isRelativeHeightPane)(paneSize) ? paneSize.height : Math.floor(emptySpace * paneSize.height);
                            canvas[startMargin] = offset;
                            offset -= getMaxMargin(startMargin, verticalMargins, horizontalMargins, pane) + _utils.PANE_PADDING;
                            return offset
                        }), initialOffset)
                    }
                    const paneNames = Object.keys(canvases);
                    if (!isRotated) {
                        shrink(canvases, paneNames, "height", "top", "bottom", ["left", "right"])
                    } else {
                        shrink(canvases, paneNames, "width", "left", "right", ["top", "bottom"])
                    }
                    return canvases
                }

                function drawAxesWithTicks(axes, condition, canvases, panesBorderOptions) {
                    if (condition) {
                        performActionOnAxes(axes, "createTicks", canvases);
                        _multi_axes_synchronizer.default.synchronize(axes)
                    }
                    performActionOnAxes(axes, "draw", !condition && canvases, panesBorderOptions)
                }

                function shiftAxis(side1, side2) {
                    const shifts = {};
                    return function(axis) {
                        if (!axis.customPositionIsAvailable() || axis.customPositionEqualsToPredefined()) {
                            const shift = shifts[axis.pane] = shifts[axis.pane] || {
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            };
                            const spacing = axis.getMultipleAxesSpacing();
                            const margins = axis.getMargins();
                            axis.shift(shift);
                            shift[side1] = accumulate(side1, shift, margins, spacing);
                            shift[side2] = accumulate(side2, shift, margins, spacing)
                        } else {
                            axis.shift({
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            })
                        }
                    }
                }

                function getCommonSize(side, margins) {
                    let size = 0;
                    let paneMargins;
                    Object.keys(margins.panes).forEach((pane => {
                        paneMargins = margins.panes[pane];
                        size += "height" === side ? paneMargins.top + paneMargins.bottom : paneMargins.left + paneMargins.right
                    }));
                    return size
                }

                function checkUsedSpace(sizeShortage, side, axes, getMarginFunc) {
                    let size = 0;
                    if (sizeShortage[side] > 0) {
                        size = getCommonSize(side, getMarginFunc(axes, getAxisMargins));
                        performActionOnAxes(axes, "hideTitle");
                        sizeShortage[side] -= size - getCommonSize(side, getMarginFunc(axes, getAxisMargins))
                    }
                    if (sizeShortage[side] > 0) {
                        performActionOnAxes(axes, "hideOuterElements")
                    }
                }
                const isOverlay = (currentPoint, overlayPoint, pointRadius) => {
                    const pointHitsLeftBorder = overlayPoint.x - pointRadius <= currentPoint.x;
                    const pointHitsRightBorder = overlayPoint.x + pointRadius >= currentPoint.x;
                    const pointHitsTopBorder = overlayPoint.y - pointRadius <= currentPoint.y;
                    const pointHitsBottomBorder = overlayPoint.y + pointRadius >= currentPoint.y;
                    const isPointOverlappedHorizontally = pointHitsLeftBorder && pointHitsRightBorder;
                    const isPointOverlappedVertically = pointHitsTopBorder && pointHitsBottomBorder;
                    return isPointOverlappedHorizontally && isPointOverlappedVertically
                };
                const isPointOverlapped = (currentPoint, points, skipSamePointsComparing) => {
                    const radiusPoint = currentPoint.getOptions().size / 2;
                    for (let i = 0; i < points.length; i += 1) {
                        if (!skipSamePointsComparing) {
                            const isXCoordinateSame = points[i].x === currentPoint.x;
                            const isYCoordinateSame = points[i].y === currentPoint.y;
                            if (isXCoordinateSame && isYCoordinateSame) {
                                continue
                            }
                        }
                        if (isOverlay(currentPoint, points[i], radiusPoint)) {
                            return true
                        }
                    }
                    return false
                };
                const dxChart = _m_advanced_chart.AdvancedChart.inherit({
                    _themeSection: "chart",
                    _fontFields: ["crosshair.label.font"],
                    _initCore() {
                        this.paneAxis = {};
                        this.callBase()
                    },
                    _init() {
                        this._containerInitialHeight = (0, _window.hasWindow)() ? (0, _size.getHeight)(this._$element) : 0;
                        this.callBase()
                    },
                    _correctAxes() {
                        this._correctValueAxes(true)
                    },
                    _getExtraOptions: _common.noop,
                    _createPanes() {
                        let panes = this.option("panes");
                        let panesNameCounter = 0;
                        let defaultPane;
                        if (!panes || isArray(panes) && !panes.length) {
                            panes = DEFAULT_PANES
                        }
                        this.callBase();
                        defaultPane = this.option("defaultPane");
                        panes = (0, _extend2.extend)(true, [], isArray(panes) ? panes : [panes]);
                        (0, _iterator.each)(panes, ((_, pane) => {
                            pane.name = !(0, _type.isDefined)(pane.name) ? "default" + panesNameCounter++ : pane.name
                        }));
                        if ((0, _type.isDefined)(defaultPane)) {
                            if (!doesPaneExist(panes, defaultPane)) {
                                this._incidentOccurred("W2101", [defaultPane]);
                                defaultPane = panes[panes.length - 1].name
                            }
                        } else {
                            defaultPane = panes[panes.length - 1].name
                        }
                        this.defaultPane = defaultPane;
                        panes = this._isRotated() ? panes.reverse() : panes;
                        return panes
                    },
                    _getAxisRenderingOptions: () => ({
                        axisType: "xyAxes",
                        drawingType: "linear"
                    }),
                    _prepareAxisOptions(typeSelector, userOptions, rotated) {
                        return {
                            isHorizontal: "argumentAxis" === typeSelector !== rotated,
                            containerColor: this._themeManager.getOptions("containerBackgroundColor")
                        }
                    },
                    _checkPaneName(seriesTheme) {
                        const paneList = (0, _utils.map)(this.panes, (pane => pane.name));
                        seriesTheme.pane = seriesTheme.pane || this.defaultPane;
                        return paneList.includes(seriesTheme.pane)
                    },
                    _initCustomPositioningAxes() {
                        const argumentAxis = this.getArgumentAxis();
                        const valueAxisName = argumentAxis.getOptions().customPositionAxis;
                        const valueAxis = this._valueAxes.find((v => v.pane === argumentAxis.pane && (!valueAxisName || valueAxisName === v.name)));
                        this._valueAxes.forEach((v => {
                            if (argumentAxis !== v.getOrthogonalAxis()) {
                                v.getOrthogonalAxis = () => argumentAxis;
                                v.customPositionIsBoundaryOrthogonalAxis = () => argumentAxis.customPositionIsBoundary()
                            }
                        }));
                        if ((0, _type.isDefined)(valueAxis) && valueAxis !== argumentAxis.getOrthogonalAxis()) {
                            argumentAxis.getOrthogonalAxis = () => valueAxis;
                            argumentAxis.customPositionIsBoundaryOrthogonalAxis = () => this._valueAxes.some((v => v.customPositionIsBoundary()))
                        } else if ((0, _type.isDefined)(argumentAxis.getOrthogonalAxis()) && !(0, _type.isDefined)(valueAxis)) {
                            argumentAxis.getOrthogonalAxis = _common.noop
                        }
                    },
                    _getAllAxes() {
                        return this._argumentAxes.concat(this._valueAxes)
                    },
                    _resetAxesAnimation(isFirstDrawing, isHorizontal) {
                        let axes;
                        if ((0, _type.isDefined)(isHorizontal)) {
                            axes = isHorizontal ^ this._isRotated() ? this._argumentAxes : this._valueAxes
                        } else {
                            axes = this._getAllAxes()
                        }
                        axes.forEach((a => {
                            a.resetApplyingAnimation(isFirstDrawing)
                        }))
                    },
                    _axesBoundaryPositioning() {
                        const allAxes = this._getAllAxes();
                        let boundaryStateChanged = false;
                        allAxes.forEach((a => {
                            if (!a.customPositionIsAvailable()) {
                                return
                            }
                            const prevBoundaryState = a.customPositionIsBoundary();
                            a._customBoundaryPosition = a.getCustomBoundaryPosition();
                            boundaryStateChanged = boundaryStateChanged || prevBoundaryState !== a.customPositionIsBoundary()
                        }));
                        return boundaryStateChanged
                    },
                    _getCrosshairMargins() {
                        const crosshairOptions = this._getCrosshairOptions() || {};
                        const crosshairEnabled = crosshairOptions.enabled;
                        const margins = (0, _crosshair.getMargins)();
                        const horizontalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.horizontalLine.label);
                        const verticalLabel = (0, _extend2.extend)(true, {}, crosshairOptions.label, crosshairOptions.verticalLine.label);
                        return {
                            x: crosshairEnabled && crosshairOptions.horizontalLine.visible && horizontalLabel.visible ? margins.x : 0,
                            y: crosshairEnabled && crosshairOptions.verticalLine.visible && verticalLabel.visible ? margins.y : 0
                        }
                    },
                    _getValueAxis(paneName, axisName) {
                        const valueAxes = this._valueAxes;
                        const valueAxisOptions = this.option("valueAxis") || {};
                        const valueAxesOptions = isArray(valueAxisOptions) ? valueAxisOptions : [valueAxisOptions];
                        const rotated = this._isRotated();
                        const crosshairMargins = this._getCrosshairMargins();
                        let axisOptions;
                        let axis;
                        axisName = axisName || function(axes, paneName, defaultPane) {
                            let result;
                            for (let i = 0; i < axes.length; i += 1) {
                                if (axes[i].pane === paneName || void 0 === axes[i].pane && paneName === defaultPane) {
                                    result = axes[i].name;
                                    break
                                }
                            }
                            if (!result) {
                                result = axes[0].name
                            }
                            return result
                        }(valueAxes, paneName, this.defaultPane);
                        axis = findAxis(paneName, axisName, valueAxes);
                        if (!axis) {
                            axisOptions = function(valueAxes, valueAxesOptions, axisName) {
                                let result;
                                let axInd;
                                for (axInd = 0; axInd < valueAxesOptions.length; axInd += 1) {
                                    if (valueAxesOptions[axInd].name === axisName) {
                                        result = valueAxesOptions[axInd];
                                        result.priority = axInd;
                                        break
                                    }
                                }
                                if (!result) {
                                    for (axInd = 0; axInd < valueAxes.length; axInd += 1) {
                                        if (valueAxes[axInd].name === axisName) {
                                            result = valueAxes[axInd].getOptions();
                                            result.priority = valueAxes[axInd].priority;
                                            break
                                        }
                                    }
                                }
                                return result
                            }(valueAxes, valueAxesOptions, axisName);
                            if (!axisOptions) {
                                this._incidentOccurred("W2102", [axisName]);
                                axisOptions = {
                                    name: axisName,
                                    priority: valueAxes.length
                                }
                            }
                            axis = this._createAxis(false, this._populateAxesOptions("valueAxis", axisOptions, {
                                pane: paneName,
                                name: axisName,
                                optionPath: isArray(valueAxisOptions) ? `valueAxis[${axisOptions.priority}]` : "valueAxis",
                                crosshairMargin: rotated ? crosshairMargins.y : crosshairMargins.x
                            }, rotated));
                            axis.applyVisualRangeSetter(this._getVisualRangeSetter());
                            valueAxes.push(axis)
                        }
                        axis.setPane(paneName);
                        return axis
                    },
                    _correctValueAxes(needHideGrids) {
                        const synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        const valueAxes = this._valueAxes;
                        const paneWithAxis = {};
                        this.series.forEach((series => {
                            const axis = series.getValueAxis();
                            paneWithAxis[axis.pane] = true
                        }));
                        this.panes.forEach((pane => {
                            const paneName = pane.name;
                            if (!paneWithAxis[paneName]) {
                                this._getValueAxis(paneName)
                            }
                            if (needHideGrids && synchronizeMultiAxes) {
                                ! function(axesForPane) {
                                    let axisShown = false;
                                    const hiddenStubAxis = [];
                                    const minorGridVisibility = axesForPane.some((axis => {
                                        const minorGridOptions = axis.getOptions().minorGrid;
                                        return null === minorGridOptions || void 0 === minorGridOptions ? void 0 : minorGridOptions.visible
                                    }));
                                    const gridVisibility = axesForPane.some((axis => {
                                        const gridOptions = axis.getOptions().grid;
                                        return null === gridOptions || void 0 === gridOptions ? void 0 : gridOptions.visible
                                    }));
                                    if (axesForPane.length > 1) {
                                        axesForPane.forEach((axis => {
                                            const gridOpt = axis.getOptions().grid;
                                            if (axisShown) {
                                                changeVisibilityAxisGrids(axis, false, false)
                                            } else if (null !== gridOpt && void 0 !== gridOpt && gridOpt.visible) {
                                                if (axis.getTranslator().getBusinessRange().isEmpty()) {
                                                    changeVisibilityAxisGrids(axis, false, false);
                                                    hiddenStubAxis.push(axis)
                                                } else {
                                                    axisShown = true;
                                                    changeVisibilityAxisGrids(axis, gridVisibility, minorGridVisibility)
                                                }
                                            }
                                        }));
                                        if (!axisShown && hiddenStubAxis.length) {
                                            changeVisibilityAxisGrids(hiddenStubAxis[0], gridVisibility, minorGridVisibility)
                                        }
                                    }
                                }(valueAxes.filter((axis => axis.pane === paneName)))
                            }
                        }));
                        this._valueAxes = valueAxes.filter((axis => {
                            if (!axis.pane) {
                                axis.setPane(this.defaultPane)
                            }
                            const paneExists = doesPaneExist(this.panes, axis.pane);
                            if (!paneExists) {
                                axis.dispose();
                                axis = null
                            }
                            return paneExists
                        })).sort(compareAxes);
                        const defaultAxis = this.getValueAxis();
                        this._valueAxes.forEach((axis => {
                            const {
                                optionPath: optionPath
                            } = axis.getOptions();
                            if (optionPath) {
                                const axesWithSamePath = this._valueAxes.filter((a => a.getOptions().optionPath === optionPath));
                                if (axesWithSamePath.length > 1) {
                                    if (axesWithSamePath.some((a => a === defaultAxis))) {
                                        axesWithSamePath.forEach((a => {
                                            if (a !== defaultAxis) {
                                                a.getOptions().optionPath = null
                                            }
                                        }))
                                    } else {
                                        axesWithSamePath.forEach(((a, i) => {
                                            if (0 !== i) {
                                                a.getOptions().optionPath = null
                                            }
                                        }))
                                    }
                                }
                            }
                        }))
                    },
                    _getSeriesForPane(paneName) {
                        const paneSeries = [];
                        (0, _iterator.each)(this.series, ((_, oneSeries) => {
                            if (oneSeries.pane === paneName) {
                                paneSeries.push(oneSeries)
                            }
                        }));
                        return paneSeries
                    },
                    _createPanesBorderOptions() {
                        const commonBorderOptions = this._themeManager.getOptions("commonPaneSettings").border;
                        const panesBorderOptions = {};
                        this.panes.forEach((pane => {
                            panesBorderOptions[pane.name] = (0, _extend2.extend)(true, {}, commonBorderOptions, pane.border)
                        }));
                        return panesBorderOptions
                    },
                    _createScrollBar() {
                        const scrollBarOptions = this._themeManager.getOptions("scrollBar") || {};
                        const scrollBarGroup = this._scrollBarGroup;
                        if (scrollBarOptions.visible) {
                            scrollBarOptions.rotated = this._isRotated();
                            this._scrollBar = (this._scrollBar || new _scroll_bar.ScrollBar(this._renderer, scrollBarGroup)).update(scrollBarOptions)
                        } else {
                            var _this$_scrollBar;
                            scrollBarGroup.linkRemove();
                            null === (_this$_scrollBar = this._scrollBar) || void 0 === _this$_scrollBar || _this$_scrollBar.dispose();
                            this._scrollBar = null
                        }
                    },
                    _executeAppendAfterSeries(append) {
                        append()
                    },
                    _prepareToRender() {
                        const panesBorderOptions = this._createPanesBorderOptions();
                        this._createPanesBackground();
                        this._appendAxesGroups();
                        this._adjustViewport();
                        return panesBorderOptions
                    },
                    _adjustViewport() {
                        const adjustOnZoom = this._themeManager.getOptions("adjustOnZoom");
                        if (!adjustOnZoom) {
                            return
                        }
                        this._valueAxes.forEach((axis => axis.adjust()))
                    },
                    _recreateSizeDependentObjects(isCanvasChanged) {
                        const series = this._getVisibleSeries();
                        const useAggregation = series.some((s => s.useAggregation()));
                        const zoomChanged = this._isZooming();
                        if (!useAggregation) {
                            return
                        }
                        this._argumentAxes.forEach((axis => {
                            axis.updateCanvas(this._canvas, true)
                        }));
                        series.forEach((series => {
                            if (series.useAggregation() && (isCanvasChanged || zoomChanged || !series._useAllAggregatedPoints)) {
                                series.createPoints()
                            }
                        }));
                        this._processSeriesFamilies()
                    },
                    _isZooming() {
                        const argumentAxis = this.getArgumentAxis();
                        if (!(null !== argumentAxis && void 0 !== argumentAxis && argumentAxis.getTranslator())) {
                            return false
                        }
                        const businessRange = argumentAxis.getTranslator().getBusinessRange();
                        const zoomRange = argumentAxis.getViewport();
                        let min = zoomRange ? zoomRange.min : 0;
                        let max = zoomRange ? zoomRange.max : 0;
                        if ("logarithmic" === businessRange.axisType) {
                            min = (0, _utils.getLog)(min, businessRange.base);
                            max = (0, _utils.getLog)(max, businessRange.base)
                        }
                        const viewportDistance = "discrete" === businessRange.axisType ? (0, _utils.getCategoriesInfo)(businessRange.categories, min, max).categories.length : Math.abs(max - min);
                        let precision = (0, _math.getPrecision)(viewportDistance);
                        precision = precision > 1 ? 10 ** (precision - 2) : 1;
                        const zoomChanged = Math.round((this._zoomLength - viewportDistance) * precision) / precision !== 0;
                        this._zoomLength = viewportDistance;
                        return zoomChanged
                    },
                    _handleSeriesDataUpdated() {
                        const viewport = new _range.Range;
                        this.series.forEach((s => {
                            viewport.addRange(s.getArgumentRange())
                        }));
                        this._argumentAxes.forEach((axis => {
                            axis.updateCanvas(this._canvas, true);
                            axis.setBusinessRange(viewport, this._axesReinitialized)
                        }));
                        this.callBase()
                    },
                    _isLegendInside() {
                        return this._legend && "inside" === this._legend.getPosition()
                    },
                    _isRotated() {
                        return this._themeManager.getOptions("rotated")
                    },
                    _getLayoutTargets() {
                        return this.panes
                    },
                    _applyClipRects(panesBorderOptions) {
                        this._drawPanesBorders(panesBorderOptions);
                        this._createClipRectsForPanes();
                        this._applyClipRectsForAxes();
                        this._fillPanesBackground()
                    },
                    _updateLegendPosition(drawOptions, legendHasInsidePosition) {
                        if (drawOptions.drawLegend && this._legend && legendHasInsidePosition) {
                            const {
                                panes: panes
                            } = this;
                            const newCanvas = (0, _extend2.extend)({}, panes[0].canvas);
                            const layoutManager = new _layout_manager.LayoutManager;
                            newCanvas.right = panes[panes.length - 1].canvas.right;
                            newCanvas.bottom = panes[panes.length - 1].canvas.bottom;
                            layoutManager.layoutInsideLegend(this._legend, newCanvas)
                        }
                    },
                    _allowLegendInsidePosition: () => true,
                    _applyExtraSettings(series) {
                        const paneIndex = this._getPaneIndex(series.pane);
                        const panesClipRects = this._panesClipRects;
                        const wideClipRect = panesClipRects.wide[paneIndex];
                        series.setClippingParams(panesClipRects.base[paneIndex].id, null === wideClipRect || void 0 === wideClipRect ? void 0 : wideClipRect.id, this._getPaneBorderVisibility(paneIndex))
                    },
                    _updatePanesCanvases(drawOptions) {
                        if (!drawOptions.recreateCanvas) {
                            return
                        }(0, _utils.updatePanesCanvases)(this.panes, this._canvas, this._isRotated())
                    },
                    _normalizePanesHeight() {
                        (0, _utils.normalizePanesHeight)(this.panes)
                    },
                    _renderScaleBreaks() {
                        this._valueAxes.concat(this._argumentAxes).forEach((axis => {
                            axis.drawScaleBreaks()
                        }))
                    },
                    _getArgFilter() {
                        return _range_data_calculator.default.getViewPortFilter(this.getArgumentAxis().visualRange() || {})
                    },
                    _hidePointsForSingleSeriesIfNeeded(series) {
                        const seriesPoints = series.getPoints();
                        let overlappedPointsCount = 0;
                        for (let i = 0; i < seriesPoints.length; i += 1) {
                            const currentPoint = seriesPoints[i];
                            const overlappingPoints = seriesPoints.slice(i + 1);
                            overlappedPointsCount += Number(isPointOverlapped(currentPoint, overlappingPoints));
                            if (overlappedPointsCount > seriesPoints.length / 2) {
                                series.autoHidePointMarkers = true;
                                break
                            }
                        }
                    },
                    _applyAutoHidePointMarkers(filteredSeries) {
                        let overlappingPoints = [];
                        const overlappedPointsCalculator = (pointsCount, currentPoint) => pointsCount + isPointOverlapped(currentPoint, overlappingPoints, true);
                        for (let i = filteredSeries.length - 1; i >= 0; i -= 1) {
                            const currentSeries = filteredSeries[i];
                            if (!currentSeries.autoHidePointMarkersEnabled()) {
                                continue
                            }
                            currentSeries.autoHidePointMarkers = false;
                            this._hidePointsForSingleSeriesIfNeeded(currentSeries);
                            if (!currentSeries.autoHidePointMarkers) {
                                const seriesPoints = currentSeries.getPoints();
                                const overlappingPointsCount = seriesPoints.reduce(overlappedPointsCalculator, 0);
                                if (overlappingPointsCount < seriesPoints.length) {
                                    overlappingPoints = overlappingPoints.concat(seriesPoints)
                                } else {
                                    currentSeries.autoHidePointMarkers = true
                                }
                            }
                        }
                    },
                    _applyPointMarkersAutoHiding() {
                        const allSeries = this.series;
                        if (!this._themeManager.getOptions("autoHidePointMarkers")) {
                            allSeries.forEach((s => {
                                s.autoHidePointMarkers = false
                            }));
                            return
                        }
                        this.panes.forEach((_ref => {
                            let {
                                borderCoords: borderCoords,
                                name: name
                            } = _ref;
                            const series = allSeries.filter((s => s.pane === name && s.usePointsToDefineAutoHiding()));
                            series.forEach((singleSeries => {
                                singleSeries.prepareCoordinatesForPoints()
                            }));
                            const argAxis = this.getArgumentAxis();
                            const markersInfo = function(allSeries, filteredSeries, argAxis) {
                                const series = [];
                                const overloadedSeries = {};
                                const argVisualRange = argAxis.visualRange();
                                const argTranslator = argAxis.getTranslator();
                                const argViewPortFilter = _range_data_calculator.default.getViewPortFilter(argVisualRange || {});
                                filteredSeries.forEach((s => {
                                    const valAxis = s.getValueAxis();
                                    const valVisualRange = valAxis.getCanvasRange();
                                    const valTranslator = valAxis.getTranslator();
                                    const seriesIndex = allSeries.indexOf(s);
                                    const valViewPortFilter = _range_data_calculator.default.getViewPortFilter(valVisualRange || {});
                                    overloadedSeries[seriesIndex] = {};
                                    filteredSeries.forEach((sr => {
                                        overloadedSeries[seriesIndex][allSeries.indexOf(sr)] = 0
                                    }));
                                    const seriesPoints = [];
                                    const pointsInViewport = s.getPoints().filter((p => p.getOptions().visible && argViewPortFilter(p.argument) && (valViewPortFilter(p.getMinValue(true)) || valViewPortFilter(p.getMaxValue(true)))));
                                    pointsInViewport.forEach((p => {
                                        const tp = {
                                            seriesIndex: seriesIndex,
                                            argument: p.argument,
                                            value: p.getMaxValue(true),
                                            size: p.bubbleSize || p.getOptions().size,
                                            x: void 0,
                                            y: void 0
                                        };
                                        if (p.getMinValue(true) !== p.getMaxValue(true)) {
                                            const mp = (0, _extend2.extend)({}, tp);
                                            mp.value = p.getMinValue(true);
                                            mp.x = argTranslator.to(mp.argument, 1);
                                            mp.y = valTranslator.to(mp.value, 1);
                                            seriesPoints.push(mp)
                                        }
                                        tp.x = argTranslator.to(tp.argument, 1);
                                        tp.y = valTranslator.to(tp.value, 1);
                                        seriesPoints.push(tp)
                                    }));
                                    overloadedSeries[seriesIndex].pointsCount = seriesPoints.length;
                                    overloadedSeries[seriesIndex].total = 0;
                                    overloadedSeries[seriesIndex].continuousSeries = 0;
                                    series.push({
                                        name: s.name,
                                        index: seriesIndex,
                                        points: seriesPoints
                                    })
                                }));
                                return {
                                    series: series,
                                    overloadedSeries: overloadedSeries
                                }
                            }(allSeries, series, argAxis);
                            ! function(canvas, markersInfo, series) {
                                const area = canvas.width * canvas.height;
                                const seriesPoints = markersInfo.series;
                                for (let i = seriesPoints.length - 1; i >= 0; i -= 1) {
                                    const currentSeries = series.filter((s => s.name === seriesPoints[i].name))[0];
                                    const {
                                        points: points
                                    } = seriesPoints[i];
                                    const pointSize = points.length ? points[0].size : 0;
                                    const pointsArea = pointSize * pointSize * points.length;
                                    if (currentSeries.autoHidePointMarkersEnabled() && pointsArea >= area / seriesPoints.length) {
                                        const {
                                            index: index
                                        } = seriesPoints[i];
                                        currentSeries.autoHidePointMarkers = true;
                                        seriesPoints.splice(i, 1);
                                        series.splice(series.indexOf(currentSeries), 1);
                                        markersInfo.overloadedSeries[index] = null
                                    }
                                }
                            }(borderCoords, markersInfo, series);
                            if (markersInfo.series.length) {
                                const argVisualRange = argAxis.visualRange();
                                const argAxisIsDiscrete = "discrete" === argAxis.getOptions().type;
                                const sortingCallback = argAxisIsDiscrete ? (p1, p2) => argVisualRange.categories.indexOf(p1.argument) - argVisualRange.categories.indexOf(p2.argument) : (p1, p2) => p1.argument - p2.argument;
                                let points = [];
                                markersInfo.series.forEach((s => {
                                    points = points.concat(s.points)
                                }));
                                points.sort(sortingCallback);
                                ! function(points, overloadedSeries) {
                                    let isContinuousSeries = false;
                                    for (let i = 0; i < points.length - 1; i += 1) {
                                        const curPoint = points[i];
                                        const {
                                            size: size
                                        } = curPoint;
                                        if ((0, _type.isDefined)(curPoint.x) && (0, _type.isDefined)(curPoint.y)) {
                                            for (let j = i + 1; j < points.length; j += 1) {
                                                const nextPoint = points[j];
                                                const nextX = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.x;
                                                const nextY = null === nextPoint || void 0 === nextPoint ? void 0 : nextPoint.y;
                                                if (!(0, _type.isDefined)(nextX) || Math.abs(curPoint.x - nextX) >= size) {
                                                    isContinuousSeries = isContinuousSeries && j !== i + 1;
                                                    break
                                                } else {
                                                    const distance = (0, _type.isDefined)(nextX) && (0, _type.isDefined)(nextY) && Math.sqrt((curPoint.x - nextX) ** 2 + (curPoint.y - nextY) ** 2);
                                                    if (distance && distance < size) {
                                                        overloadedSeries[curPoint.seriesIndex][nextPoint.seriesIndex] += 1;
                                                        overloadedSeries[curPoint.seriesIndex].total += 1;
                                                        if (!isContinuousSeries) {
                                                            overloadedSeries[curPoint.seriesIndex].continuousSeries += 1;
                                                            isContinuousSeries = true
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }(points, markersInfo.overloadedSeries);
                                this._applyAutoHidePointMarkers(series)
                            }
                        }))
                    },
                    _renderAxes(drawOptions, panesBorderOptions) {
                        function calculateTitlesWidth(axes) {
                            return axes.map((axis => {
                                if (!axis.getTitle) {
                                    return 0
                                }
                                const title = axis.getTitle();
                                return title ? title.bBox.width : 0
                            }))
                        }
                        const rotated = this._isRotated();
                        const synchronizeMultiAxes = this._themeManager.getOptions("synchronizeMultiAxes");
                        const scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        const extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        const verticalAxes = rotated ? this._argumentAxes : this._valueAxes;
                        const verticalElements = rotated ? extendedArgAxes : this._valueAxes;
                        const horizontalAxes = rotated ? this._valueAxes : this._argumentAxes;
                        const horizontalElements = rotated ? this._valueAxes : extendedArgAxes;
                        const allAxes = verticalAxes.concat(horizontalAxes);
                        const allElements = allAxes.concat(scrollBar);
                        const verticalAxesFirstDrawing = verticalAxes.some((v => v.isFirstDrawing()));
                        this._normalizePanesHeight();
                        this._updatePanesCanvases(drawOptions);
                        let panesCanvases = this.panes.reduce(((canvases, pane) => {
                            canvases[pane.name] = (0, _extend2.extend)({}, pane.canvas);
                            return canvases
                        }), {});
                        const paneSizes = this.panes.reduce(((sizes, pane) => {
                            sizes[pane.name] = {
                                height: pane.height,
                                unit: pane.unit
                            };
                            return sizes
                        }), {});
                        const cleanPanesCanvases = (0, _extend2.extend)(true, {}, panesCanvases);
                        this._initCustomPositioningAxes();
                        const needCustomAdjustAxes = this._axesBoundaryPositioning();
                        if (!drawOptions.adjustAxes && !needCustomAdjustAxes) {
                            drawAxesWithTicks(verticalAxes, !rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            drawAxesWithTicks(horizontalAxes, rotated && synchronizeMultiAxes, panesCanvases, panesBorderOptions);
                            performActionOnAxes(allAxes, "prepareAnimation");
                            this._renderScaleBreaks();
                            horizontalAxes.forEach((a => a.resolveOverlappingForCustomPositioning(verticalAxes)));
                            verticalAxes.forEach((a => a.resolveOverlappingForCustomPositioning(horizontalAxes)));
                            return false
                        }
                        if (needCustomAdjustAxes) {
                            allAxes.forEach((a => a.customPositionIsAvailable() && a.shift({
                                top: 0,
                                left: 0,
                                bottom: 0,
                                right: 0
                            })))
                        }
                        if (this._scrollBar) {
                            this._scrollBar.setPane(this.panes)
                        }
                        let vAxesMargins = {
                            panes: {},
                            left: 0,
                            right: 0
                        };
                        let hAxesMargins = getHorizontalAxesMargins(horizontalElements, (axis => axis.estimateMargins(panesCanvases[axis.pane])));
                        panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                        const drawAxesAndSetCanvases = isHorizontal => {
                            const axes = isHorizontal ? horizontalAxes : verticalAxes;
                            const condition = (isHorizontal ? rotated : !rotated) && synchronizeMultiAxes;
                            drawAxesWithTicks(axes, condition, panesCanvases, panesBorderOptions);
                            if (isHorizontal) {
                                hAxesMargins = getHorizontalAxesMargins(horizontalElements, getAxisMargins)
                            } else {
                                vAxesMargins = getVerticalAxesMargins(verticalElements)
                            }
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins)
                        };
                        drawAxesAndSetCanvases(false);
                        drawAxesAndSetCanvases(true);
                        if (!this._changesApplying && this._estimateTickIntervals(verticalAxes, panesCanvases)) {
                            drawAxesAndSetCanvases(false)
                        }
                        let oldTitlesWidth = calculateTitlesWidth(verticalAxes);
                        const visibleSeries = this._getVisibleSeries();
                        const pointsToAnimation = this._getPointsToAnimation(visibleSeries);
                        const axesIsAnimated = function(drawOptions, pointsToAnimation) {
                            const pointsCount = pointsToAnimation.reduce(((sum, count) => sum + count), 0) / pointsToAnimation.length;
                            return drawOptions.animate && pointsCount <= drawOptions.animationPointsLimit
                        }(drawOptions, pointsToAnimation);
                        performActionOnAxes(allElements, "updateSize", panesCanvases, axesIsAnimated);
                        horizontalElements.forEach(shiftAxis("top", "bottom"));
                        verticalElements.forEach(shiftAxis("left", "right"));
                        this._renderScaleBreaks();
                        this.panes.forEach((pane => {
                            (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name])
                        }));
                        this._valueAxes.forEach((axis => {
                            axis.setInitRange()
                        }));
                        verticalAxes.forEach(((axis, i) => {
                            var _axis$hasWrap;
                            if (null !== (_axis$hasWrap = axis.hasWrap) && void 0 !== _axis$hasWrap && _axis$hasWrap.call(axis)) {
                                const title = axis.getTitle();
                                const newTitleWidth = title ? title.bBox.width : 0;
                                const offset = newTitleWidth - oldTitlesWidth[i];
                                if ("right" === axis.getOptions().position) {
                                    vAxesMargins.right += offset
                                } else {
                                    vAxesMargins.left += offset;
                                    this.panes.forEach((_ref2 => {
                                        let {
                                            name: name
                                        } = _ref2;
                                        vAxesMargins.panes[name].left += offset
                                    }))
                                }
                                panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, vAxesMargins, hAxesMargins);
                                performActionOnAxes(allElements, "updateSize", panesCanvases, false, false);
                                oldTitlesWidth = calculateTitlesWidth(verticalAxes)
                            }
                        }));
                        if (verticalAxes.some((v => v.customPositionIsAvailable() && v.getCustomPosition() !== v._axisPosition))) {
                            axesIsAnimated && this._resetAxesAnimation(verticalAxesFirstDrawing, false);
                            performActionOnAxes(verticalAxes, "updateSize", panesCanvases, axesIsAnimated)
                        }
                        horizontalAxes.forEach((a => a.resolveOverlappingForCustomPositioning(verticalAxes)));
                        verticalAxes.forEach((a => a.resolveOverlappingForCustomPositioning(horizontalAxes)));
                        return cleanPanesCanvases
                    },
                    _getExtraTemplatesItems() {
                        const allAxes = (this._argumentAxes || []).concat(this._valueAxes || []);
                        const elements = this._collectTemplatesFromItems(allAxes);
                        return {
                            items: elements.items,
                            groups: elements.groups,
                            launchRequest() {
                                allAxes.forEach((a => {
                                    a.setRenderedState(true)
                                }))
                            },
                            doneRequest() {
                                allAxes.forEach((a => {
                                    a.setRenderedState(false)
                                }))
                            }
                        }
                    },
                    _estimateTickIntervals: (axes, canvases) => axes.some((axis => axis.estimateTickInterval(canvases[axis.pane]))),
                    checkForMoreSpaceForPanesCanvas() {
                        const rotated = this._isRotated();
                        const panesAreCustomSized = this.panes.filter((p => p.unit)).length === this.panes.length;
                        let needSpace = false;
                        if (panesAreCustomSized) {
                            let needHorizontalSpace = 0;
                            let needVerticalSpace = 0;
                            if (rotated) {
                                const argAxisRightMargin = this.getArgumentAxis().getMargins().right;
                                const rightPanesIndent = Math.min(...this.panes.map((p => p.canvas.right)));
                                needHorizontalSpace = this._canvas.right + argAxisRightMargin - rightPanesIndent
                            } else {
                                const argAxisBottomMargin = this.getArgumentAxis().getMargins().bottom;
                                const bottomPanesIndent = Math.min(...this.panes.map((p => p.canvas.bottom)));
                                needVerticalSpace = this._canvas.bottom + argAxisBottomMargin - bottomPanesIndent
                            }
                            needSpace = needHorizontalSpace > 0 || needVerticalSpace > 0 ? {
                                width: needHorizontalSpace,
                                height: needVerticalSpace
                            } : false;
                            if (0 !== needVerticalSpace) {
                                const realSize = this.getSize();
                                const customSize = this.option("size");
                                const container = this._$element[0];
                                const containerHasStyledHeight = !!parseInt(container.style.height, 10) || 0 !== this._containerInitialHeight;
                                if (!rotated && !(null !== customSize && void 0 !== customSize && customSize.height) && !containerHasStyledHeight) {
                                    this._forceResize(realSize.width, realSize.height + needVerticalSpace);
                                    needSpace = false
                                }
                            }
                        } else {
                            needSpace = this.layoutManager.needMoreSpaceForPanesCanvas(this._getLayoutTargets(), rotated, (pane => ({
                                width: rotated && !!pane.unit,
                                height: !rotated && !!pane.unit
                            })))
                        }
                        return needSpace
                    },
                    _forceResize(width, height) {
                        this._renderer.resize(width, height);
                        this._updateSize(true);
                        this._setContentSize();
                        this._preserveOriginalCanvas();
                        this._updateCanvasClipRect(this._canvas)
                    },
                    _shrinkAxes(sizeShortage, panesCanvases) {
                        if (!sizeShortage || !panesCanvases) {
                            return
                        }
                        this._renderer.stopAllAnimations(true);
                        const rotated = this._isRotated();
                        const scrollBar = this._scrollBar ? [this._scrollBar] : [];
                        const extendedArgAxes = this._isArgumentAxisBeforeScrollBar() ? this._argumentAxes.concat(scrollBar) : scrollBar.concat(this._argumentAxes);
                        const verticalAxes = rotated ? extendedArgAxes : this._valueAxes;
                        const horizontalAxes = rotated ? this._valueAxes : extendedArgAxes;
                        const allAxes = verticalAxes.concat(horizontalAxes);
                        if (sizeShortage.width || sizeShortage.height) {
                            checkUsedSpace(sizeShortage, "height", horizontalAxes, getHorizontalAxesMargins);
                            checkUsedSpace(sizeShortage, "width", verticalAxes, getVerticalAxesMargins);
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            const paneSizes = this.panes.reduce(((sizes, pane) => {
                                sizes[pane.name] = {
                                    height: pane.height,
                                    unit: pane.unit
                                };
                                return sizes
                            }), {});
                            panesCanvases = shrinkCanvases(rotated, panesCanvases, paneSizes, getVerticalAxesMargins(verticalAxes), getHorizontalAxesMargins(horizontalAxes, getAxisMargins));
                            performActionOnAxes(allAxes, "updateSize", panesCanvases);
                            horizontalAxes.forEach(shiftAxis("top", "bottom"));
                            verticalAxes.forEach(shiftAxis("left", "right"));
                            this.panes.forEach((pane => (0, _extend2.extend)(pane.canvas, panesCanvases[pane.name])))
                        }
                    },
                    _isArgumentAxisBeforeScrollBar() {
                        const argumentAxis = this.getArgumentAxis();
                        if (this._scrollBar) {
                            var _argumentAxis$getOpti;
                            const argAxisPosition = argumentAxis.getResolvedBoundaryPosition();
                            const argAxisLabelPosition = null === (_argumentAxis$getOpti = argumentAxis.getOptions().label) || void 0 === _argumentAxis$getOpti ? void 0 : _argumentAxis$getOpti.position;
                            const scrollBarPosition = this._scrollBar.getOptions().position;
                            return argumentAxis.hasNonBoundaryPosition() || scrollBarPosition === argAxisPosition && argAxisLabelPosition !== scrollBarPosition
                        }
                        return false
                    },
                    _getPanesParameters() {
                        const {
                            panes: panes
                        } = this;
                        const params = [];
                        for (let i = 0; i < panes.length; i += 1) {
                            if (this._getPaneBorderVisibility(i)) {
                                params.push({
                                    coords: panes[i].borderCoords,
                                    clipRect: this._panesClipRects.fixed[i]
                                })
                            }
                        }
                        return params
                    },
                    _createCrosshairCursor() {
                        const options = this._themeManager.getOptions("crosshair") || {};
                        const argumentAxis = this.getArgumentAxis();
                        const axes = this._isRotated() ? [this._valueAxes, [argumentAxis]] : [
                            [argumentAxis], this._valueAxes
                        ];
                        const parameters = {
                            canvas: this._getCommonCanvas(),
                            panes: this._getPanesParameters(),
                            axes: axes
                        };
                        if (!(null !== options && void 0 !== options && options.enabled)) {
                            return
                        }
                        if (this._crosshair) {
                            this._crosshair.update(options, parameters)
                        } else {
                            this._crosshair = new _crosshair.Crosshair(this._renderer, options, parameters, this._crosshairCursorGroup)
                        }
                        this._crosshair.render()
                    },
                    _getCommonCanvas() {
                        let commonCanvas;
                        const {
                            panes: panes
                        } = this;
                        for (let i = 0; i < panes.length; i += 1) {
                            const {
                                canvas: canvas
                            } = panes[i];
                            if (!commonCanvas) {
                                commonCanvas = (0, _extend2.extend)({}, canvas)
                            } else {
                                commonCanvas.right = canvas.right;
                                commonCanvas.bottom = canvas.bottom
                            }
                        }
                        return commonCanvas
                    },
                    _createPanesBackground() {
                        const defaultBackgroundColor = this._themeManager.getOptions("commonPaneSettings").backgroundColor;
                        const renderer = this._renderer;
                        const rects = [];
                        this._panesBackgroundGroup.clear();
                        for (let i = 0; i < this.panes.length; i += 1) {
                            const backgroundColor = this.panes[i].backgroundColor || defaultBackgroundColor;
                            if (!backgroundColor || "none" === backgroundColor) {
                                rects.push(null);
                                continue
                            }
                            const rect = renderer.rect(0, 0, 0, 0).attr({
                                fill: (0, _utils.extractColor)(backgroundColor),
                                "stroke-width": 0
                            }).append(this._panesBackgroundGroup);
                            rects.push(rect)
                        }
                        this.panesBackground = rects
                    },
                    _fillPanesBackground() {
                        (0, _iterator.each)(this.panes, ((i, pane) => {
                            const bc = pane.borderCoords;
                            if (null !== this.panesBackground[i]) {
                                this.panesBackground[i].attr({
                                    x: bc.left,
                                    y: bc.top,
                                    width: bc.width,
                                    height: bc.height
                                })
                            }
                        }))
                    },
                    _calcPaneBorderCoords(pane) {
                        const {
                            canvas: canvas
                        } = pane;
                        const bc = pane.borderCoords = pane.borderCoords || {};
                        bc.left = canvas.left;
                        bc.top = canvas.top;
                        bc.right = canvas.width - canvas.right;
                        bc.bottom = canvas.height - canvas.bottom;
                        bc.width = Math.max(bc.right - bc.left, 0);
                        bc.height = Math.max(bc.bottom - bc.top, 0)
                    },
                    _drawPanesBorders(panesBorderOptions) {
                        const rotated = this._isRotated();
                        this._panesBorderGroup.linkRemove().clear();
                        (0, _iterator.each)(this.panes, ((i, pane) => {
                            const borderOptions = panesBorderOptions[pane.name];
                            const attr = {
                                fill: "none",
                                stroke: borderOptions.color,
                                "stroke-opacity": borderOptions.opacity,
                                "stroke-width": borderOptions.width,
                                dashStyle: borderOptions.dashStyle,
                                "stroke-linecap": "square"
                            };
                            this._calcPaneBorderCoords(pane, rotated);
                            if (!borderOptions.visible) {
                                return
                            }
                            const bc = pane.borderCoords;
                            const segmentRectParams = (0, _utils2.prepareSegmentRectPoints)(bc.left, bc.top, bc.width, bc.height, borderOptions);
                            this._renderer.path(segmentRectParams.points, segmentRectParams.pathType).attr(attr).append(this._panesBorderGroup)
                        }));
                        this._panesBorderGroup.linkAppend()
                    },
                    _createClipRect(clipArray, index, left, top, width, height) {
                        let clipRect = clipArray[index];
                        if (!clipRect) {
                            clipRect = this._renderer.clipRect(left, top, width, height);
                            clipArray[index] = clipRect
                        } else {
                            clipRect.attr({
                                x: left,
                                y: top,
                                width: width,
                                height: height
                            })
                        }
                    },
                    _createClipRectsForPanes() {
                        const canvas = this._canvas;
                        (0, _iterator.each)(this.panes, ((i, pane) => {
                            let needWideClipRect = false;
                            const bc = pane.borderCoords;
                            let {
                                left: left
                            } = bc;
                            let {
                                top: top
                            } = bc;
                            let {
                                width: width
                            } = bc;
                            let {
                                height: height
                            } = bc;
                            const panesClipRects = this._panesClipRects;
                            this._createClipRect(panesClipRects.fixed, i, left, top, width, height);
                            this._createClipRect(panesClipRects.base, i, left, top, width, height);
                            (0, _iterator.each)(this.series, ((_, series) => {
                                if (series.pane === pane.name && (series.isFinancialSeries() || series.areErrorBarsVisible())) {
                                    needWideClipRect = true
                                }
                            }));
                            if (needWideClipRect) {
                                if (this._isRotated()) {
                                    top = 0;
                                    height = canvas.height
                                } else {
                                    left = 0;
                                    width = canvas.width
                                }
                                this._createClipRect(panesClipRects.wide, i, left, top, width, height)
                            } else {
                                panesClipRects.wide[i] = null
                            }
                        }))
                    },
                    _applyClipRectsForAxes() {
                        const axes = this._getAllAxes();
                        const chartCanvasClipRectID = this._getCanvasClipRectID();
                        for (let i = 0; i < axes.length; i += 1) {
                            const elementsClipRectID = this._getElementsClipRectID(axes[i].pane);
                            axes[i].applyClipRects(elementsClipRectID, chartCanvasClipRectID)
                        }
                    },
                    _getPaneBorderVisibility(paneIndex) {
                        var _pane$border;
                        const commonPaneBorderVisible = this._themeManager.getOptions("commonPaneSettings").border.visible;
                        const pane = this.panes[paneIndex];
                        const paneVisibility = null === pane || void 0 === pane || null === (_pane$border = pane.border) || void 0 === _pane$border ? void 0 : _pane$border.visible;
                        return void 0 === paneVisibility ? commonPaneBorderVisible : paneVisibility
                    },
                    _getCanvasForPane(paneName) {
                        var _this$panes$find;
                        return null === (_this$panes$find = this.panes.find((pane => pane.name === paneName))) || void 0 === _this$panes$find ? void 0 : _this$panes$find.canvas
                    },
                    _getTrackerSettings() {
                        return (0, _extend2.extend)(this.callBase(), {
                            chart: this,
                            rotated: this._isRotated(),
                            crosshair: this._getCrosshairOptions().enabled ? this._crosshair : null,
                            stickyHovering: this._themeManager.getOptions("stickyHovering")
                        })
                    },
                    _resolveLabelOverlappingStack() {
                        const isRotated = this._isRotated();
                        const shiftDirection = isRotated ? (box, length) => ({
                            x: box.x - length,
                            y: box.y
                        }) : (box, length) => ({
                            x: box.x,
                            y: box.y - length
                        });
                        const processor = (a, b) => {
                            const coordPosition = isRotated ? 1 : 0;
                            const figureCenter1 = a.labels[0].getFigureCenter()[coordPosition];
                            const figureCenter12 = b.labels[0].getFigureCenter()[coordPosition];
                            if (figureCenter1 - figureCenter12 === 0) {
                                const translator = a.labels[0].getPoint().series.getValueAxis().getTranslator();
                                const direction = translator.isInverted() ? -1 : 1;
                                return (a.value() - b.value()) * direction
                            }
                            return 0
                        };
                        (0, _iterator.each)(this._getStackPoints(), ((_, stacks) => {
                            (0, _iterator.each)(stacks, ((_, points) => {
                                const isInverted = points[0].series.getValueAxis().getOptions().inverted;
                                _m_base_chart.overlapping.resolveLabelOverlappingInOneDirection(points, this._getCommonCanvas(), isRotated, isInverted, shiftDirection, processor)
                            }))
                        }))
                    },
                    _getStackPoints() {
                        const stackPoints = {};
                        const visibleSeries = this._getVisibleSeries();
                        (0, _iterator.each)(visibleSeries, ((_, singleSeries) => {
                            const points = singleSeries.getPoints();
                            const stackName = singleSeries.getStackName() || null;
                            (0, _iterator.each)(points, ((_, point) => {
                                const {
                                    argument: argument
                                } = point;
                                if (!stackPoints[argument]) {
                                    stackPoints[argument] = {}
                                }
                                if (!stackPoints[argument][stackName]) {
                                    stackPoints[argument][stackName] = []
                                }
                                stackPoints[argument][stackName].push(point)
                            }))
                        }));
                        return stackPoints
                    },
                    _getCrosshairOptions() {
                        return this._getOption("crosshair")
                    },
                    zoomArgument(min, max) {
                        if (!this._initialized || !(0, _type.isDefined)(min) && !(0, _type.isDefined)(max)) {
                            return
                        }
                        this.getArgumentAxis().visualRange([min, max])
                    },
                    resetVisualRange() {
                        const axes = this._argumentAxes;
                        const nonVirtualArgumentAxis = this.getArgumentAxis();
                        axes.forEach((axis => {
                            axis.resetVisualRange(nonVirtualArgumentAxis !== axis);
                            this._applyCustomVisualRangeOption(axis)
                        }));
                        this.callBase()
                    },
                    getVisibleArgumentBounds() {
                        const translator = this._argumentAxes[0].getTranslator();
                        const range = translator.getBusinessRange();
                        const isDiscrete = "discrete" === range.axisType;
                        const {
                            categories: categories
                        } = range;
                        return {
                            minVisible: isDiscrete ? range.minVisible || categories[0] : range.minVisible,
                            maxVisible: isDiscrete ? range.maxVisible || categories[categories.length - 1] : range.maxVisible
                        }
                    },
                    _change_FULL_RENDER() {
                        this.callBase();
                        if (this._changes.has("VISUAL_RANGE")) {
                            this._raiseZoomEndHandlers()
                        }
                    },
                    _getAxesForScaling() {
                        return [this.getArgumentAxis()].concat(this._valueAxes)
                    },
                    _applyVisualRangeByVirtualAxes(axis, range) {
                        if (axis.isArgumentAxis) {
                            if (axis !== this.getArgumentAxis()) {
                                return true
                            }
                            this._argumentAxes.filter((a => a !== axis)).forEach((a => a.visualRange(range, {
                                start: true,
                                end: true
                            })))
                        }
                        return false
                    },
                    _raiseZoomEndHandlers() {
                        this._argumentAxes.forEach((axis => axis.handleZoomEnd()));
                        this.callBase()
                    },
                    _setOptionsByReference() {
                        this.callBase();
                        (0, _extend2.extend)(this._optionsByReference, {
                            "argumentAxis.visualRange": true
                        })
                    },
                    option() {
                        const option = this.callBase(...arguments);
                        const valueAxis = this._options.silent("valueAxis");
                        if ("array" === (0, _type.type)(valueAxis)) {
                            for (let i = 0; i < valueAxis.length; i += 1) {
                                const optionPath = `valueAxis[${i}].visualRange`;
                                this._optionsByReference[optionPath] = true
                            }
                        }
                        return option
                    },
                    _notifyVisualRange() {
                        const argAxis = this._argumentAxes[0];
                        const argumentVisualRange = (0, _utils.convertVisualRangeObject)(argAxis.visualRange(), !isArray(this.option("argumentAxis.visualRange")));
                        if (!argAxis.skipEventRising || !(0, _utils.rangesAreEqual)(argumentVisualRange, this.option("argumentAxis.visualRange"))) {
                            this.option("argumentAxis.visualRange", argumentVisualRange)
                        } else {
                            argAxis.skipEventRising = null
                        }
                        this.callBase()
                    }
                });
                dxChart.addPlugin(_shutter_zoom.default);
                dxChart.addPlugin(_zoom_and_pan.default);
                dxChart.addPlugin(_annotations.plugins.core);
                dxChart.addPlugin(_annotations.plugins.chart);
                (0, _component_registrator.default)("dxChart", dxChart);
                exports.default = dxChart
            },
        4203:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/macro_task_array/index.js ***!
              \**************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _dispatcher = (e = __webpack_require__( /*! ./dispatcher */ 8710), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _methods = __webpack_require__( /*! ./methods */ 57);
                exports.default = {
                    forEach: _methods.macroTaskArrayForEach,
                    map: _methods.macroTaskArrayMap,
                    dispose: _dispatcher.default.dispose
                }
            },
        4249:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/vector_map/map_layer.js ***!
              \************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.MapLayerCollection = MapLayerCollection;
                exports.getMaxBound = getMaxBound;
                var _data = __webpack_require__( /*! ../../../common/data */ 11036);
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                const _noop = _common.noop;
                const _extend = _extend2.extend;
                const _each = _iterator.each;
                const _concat = Array.prototype.concat;
                const STATE_TO_INDEX = [0, 1, 2, 2];
                const SELECTIONS = {
                    none: null,
                    single: -1,
                    multiple: NaN
                };
                const _isArray = Array.isArray;
                const _Number = Number;
                const _String = String;
                const _abs = Math.abs;
                const _round = Math.round;
                const _min = Math.min;
                const _max = Math.max;
                const _sqrt = Math.sqrt;

                function getMaxBound(arr) {
                    return arr.reduce(((a, c) => c ? [_min(a[0], c[0]), _min(a[1], c[1]), _max(a[2], c[2]), _max(a[3], c[3])] : a), arr[0])
                }

                function getName(opt, index) {
                    return (opt[index] || {}).name
                }

                function EmptySource() {}
                EmptySource.prototype.count = function() {
                    return 0
                };

                function ArraySource(raw) {
                    this.raw = raw
                }
                ArraySource.prototype = {
                    constructor: ArraySource,
                    count() {
                        return this.raw.length
                    },
                    item(index) {
                        return this.raw[index]
                    },
                    geometry: item => ({
                        coordinates: item.coordinates
                    }),
                    attributes: item => item.attributes,
                    getBBox(index) {
                        return 0 === arguments.length ? void 0 : this.raw[index].bbox
                    }
                };

                function GeoJsonSource(raw) {
                    this.raw = raw
                }
                GeoJsonSource.prototype = {
                    constructor: GeoJsonSource,
                    count() {
                        return this.raw.features.length
                    },
                    item(index) {
                        return this.raw.features[index]
                    },
                    geometry: item => item.geometry,
                    attributes: item => item.properties,
                    getBBox(index) {
                        return 0 === arguments.length ? this.raw.bbox : this.raw.features[index].bbox
                    }
                };

                function isGeoJsonObject(obj) {
                    return _isArray(obj.features)
                }

                function setAreaLabelVisibility(label) {
                    label.text.attr({
                        visibility: label.size[0] / label.spaceSize[0] < 1 && label.size[1] / label.spaceSize[1] < 1 ? null : "hidden"
                    })
                }

                function setLineLabelVisibility(label) {
                    label.text.attr({
                        visibility: label.size[0] / label.spaceSize[0] < 1 || label.size[1] / label.spaceSize[1] < 1 ? null : "hidden"
                    })
                }

                function getDataValue(proxy, dataField) {
                    return proxy.attribute(dataField)
                }
                const TYPE_TO_TYPE_MAP = {
                    Point: "marker",
                    MultiPoint: "line",
                    LineString: "line",
                    MultiLineString: "line",
                    Polygon: "area",
                    MultiPolygon: "area"
                };

                function pick(a, b) {
                    return void 0 !== a ? a : b
                }
                const emptyStrategy = {
                    setup: _noop,
                    reset: _noop,
                    arrange: _noop,
                    updateGrouping: _noop,
                    getDefaultColor: _noop
                };
                const strategiesByType = {};
                const strategiesByGeometry = {};
                const strategiesByElementType = {};
                let groupByColor;
                let groupBySize;
                let selectStrategy = function(options, data) {
                    let type = (0, _utils.normalizeEnum)(options.type);
                    let elementType = (0, _utils.normalizeEnum)(options.elementType);
                    let sample;
                    const strategy = _extend({}, emptyStrategy);
                    if (data.count() > 0) {
                        sample = data.geometry(data.item(0));
                        type = strategiesByType[type] ? type : function(sample) {
                            let type = TYPE_TO_TYPE_MAP[sample.type];
                            const coordinates = sample.coordinates;
                            if (!type) {
                                if ("number" === typeof coordinates[0]) {
                                    type = "marker"
                                } else if ("number" === typeof coordinates[0][0]) {
                                    type = "line"
                                } else {
                                    type = "area"
                                }
                            }
                            return type
                        }(sample);
                        _extend(strategy, strategiesByType[type]);
                        strategy.fullType = strategy.type = type;
                        if (strategiesByGeometry[type]) {
                            _extend(strategy, strategiesByGeometry[type](sample))
                        }
                        if (strategiesByElementType[type]) {
                            elementType = strategiesByElementType[type][elementType] ? elementType : strategiesByElementType[type]._default;
                            _extend(strategy, strategiesByElementType[type][elementType]);
                            strategy.elementType = elementType;
                            strategy.fullType += `:${elementType}`
                        }
                    }
                    return strategy
                };

                function applyElementState(figure, styles, state, field) {
                    figure[field].attr(styles[field][state])
                }
                strategiesByType.area = {
                    projectLabel: function(coordinates) {
                        let i;
                        const ii = coordinates.length;
                        let centroid;
                        let resultCentroid;
                        let maxArea = 0;
                        for (i = 0; i < ii; ++i) {
                            centroid = calculatePolygonCentroid(coordinates[i]);
                            if (centroid.area > maxArea) {
                                maxArea = centroid.area;
                                resultCentroid = centroid
                            }
                        }
                        return resultCentroid ? [resultCentroid.center, [_sqrt(resultCentroid.area), _sqrt(resultCentroid.area)]] : [
                            [],
                            []
                        ]
                    },
                    transform: transformPointList,
                    transformLabel: function(label, projection, coordinates) {
                        const data = projection.transform(coordinates[0]);
                        label.spaceSize = projection.getSquareSize(coordinates[1]);
                        label.text.attr({
                            translateX: data[0],
                            translateY: data[1]
                        });
                        setAreaLabelVisibility(label)
                    },
                    draw(context, figure, data) {
                        figure.root = context.renderer.path([], "area").data(context.dataKey, data)
                    },
                    refresh: _noop,
                    getLabelOffset(label) {
                        setAreaLabelVisibility(label);
                        return [0, 0]
                    },
                    getStyles(settings) {
                        const color = settings.color || null;
                        const borderColor = settings.borderColor || null;
                        const borderWidth = pick(settings.borderWidth, null);
                        const opacity = pick(settings.opacity, null);
                        return {
                            root: [{
                                class: "dxm-area",
                                stroke: borderColor,
                                "stroke-width": borderWidth,
                                fill: color,
                                opacity: opacity
                            }, {
                                class: "dxm-area dxm-area-hovered",
                                stroke: settings.hoveredBorderColor || borderColor,
                                "stroke-width": pick(settings.hoveredBorderWidth, borderWidth),
                                fill: settings.hoveredColor || color,
                                opacity: pick(settings.hoveredOpacity, opacity)
                            }, {
                                class: "dxm-area dxm-area-selected",
                                stroke: settings.selectedBorderColor || borderColor,
                                "stroke-width": pick(settings.selectedBorderWidth, borderWidth),
                                fill: settings.selectedColor || color,
                                opacity: pick(settings.selectedOpacity, opacity)
                            }]
                        }
                    },
                    setState(figure, styles, state) {
                        applyElementState(figure, styles, state, "root")
                    },
                    hasLabelsGroup: true,
                    updateGrouping(context) {
                        groupByColor(context)
                    },
                    getDefaultColor: _noop
                };
                strategiesByType.line = {
                    projectLabel: function(coordinates) {
                        let i;
                        const ii = coordinates.length;
                        let maxLength = 0;
                        let data;
                        let resultData;
                        for (i = 0; i < ii; ++i) {
                            data = calculateLineStringData(coordinates[i]);
                            if (data[2] > maxLength) {
                                maxLength = data[2];
                                resultData = data
                            }
                        }
                        return resultData || [
                            [],
                            []
                        ]
                    },
                    transform: transformPointList,
                    transformLabel: function(label, projection, coordinates) {
                        const data = projection.transform(coordinates[0]);
                        label.spaceSize = projection.getSquareSize(coordinates[1]);
                        label.text.attr({
                            translateX: data[0],
                            translateY: data[1]
                        });
                        setLineLabelVisibility(label)
                    },
                    draw(context, figure, data) {
                        figure.root = context.renderer.path([], "line").data(context.dataKey, data)
                    },
                    refresh: _noop,
                    getLabelOffset(label) {
                        setLineLabelVisibility(label);
                        return [0, 0]
                    },
                    getStyles(settings) {
                        const color = settings.color || settings.borderColor || null;
                        const width = pick(settings.borderWidth, null);
                        const opacity = pick(settings.opacity, null);
                        return {
                            root: [{
                                class: "dxm-line",
                                stroke: color,
                                "stroke-width": width,
                                opacity: opacity
                            }, {
                                class: "dxm-line dxm-line-hovered",
                                stroke: settings.hoveredColor || settings.hoveredBorderColor || color,
                                "stroke-width": pick(settings.hoveredBorderWidth, width),
                                opacity: pick(settings.hoveredOpacity, opacity)
                            }, {
                                class: "dxm-line dxm-line-selected",
                                stroke: settings.selectedColor || settings.selectedBorderColor || color,
                                "stroke-width": pick(settings.selectedBorderWidth, width),
                                opacity: pick(settings.selectedOpacity, opacity)
                            }]
                        }
                    },
                    setState(figure, styles, state) {
                        applyElementState(figure, styles, state, "root")
                    },
                    hasLabelsGroup: true,
                    updateGrouping(context) {
                        groupByColor(context)
                    },
                    getDefaultColor: _noop
                };
                strategiesByType.marker = {
                    project: function(projection, coordinates) {
                        return projection.project(coordinates)
                    },
                    transform: function(content, projection, coordinates) {
                        const data = projection.transform(coordinates);
                        content.root.attr({
                            translateX: data[0],
                            translateY: data[1]
                        })
                    },
                    draw(context, figure, data) {
                        figure.root = context.renderer.g();
                        this._draw(context, figure, data)
                    },
                    refresh: _noop,
                    hasLabelsGroup: false,
                    getLabelOffset: (label, settings) => [_round((label.size[0] + _max(settings.size || 0, 0)) / 2) + 2, 0],
                    getStyles(settings) {
                        const styles = {
                            root: [{
                                class: "dxm-marker"
                            }, {
                                class: "dxm-marker dxm-marker-hovered"
                            }, {
                                class: "dxm-marker dxm-marker-selected"
                            }]
                        };
                        this._getStyles(styles, settings);
                        return styles
                    },
                    setState(figure, styles, state) {
                        applyElementState(figure, styles, state, "root");
                        this._setState(figure, styles, state)
                    },
                    updateGrouping(context) {
                        groupByColor(context);
                        groupBySize(context)
                    },
                    getDefaultColor: (ctx, palette) => ctx.params.themeManager.getAccentColor(palette)
                };
                strategiesByGeometry.area = function(sample) {
                    return {
                        project: (projection, coordinates) => coordinates[0] && coordinates[0][0] && coordinates[0][0][0] && "number" === typeof coordinates[0][0][0][0] ? function(projection, coordinates) {
                            const output = [];
                            let i;
                            const ii = output.length = coordinates.length;
                            for (i = 0; i < ii; ++i) {
                                output[i] = projectPolygon(projection, coordinates[i])
                            }
                            return _concat.apply([], output)
                        }(projection, coordinates) : projectPolygon(projection, coordinates)
                    }
                };
                strategiesByGeometry.line = function(sample) {
                    const coordinates = sample.coordinates;
                    return {
                        project: coordinates[0] && coordinates[0][0] && "number" === typeof coordinates[0][0][0] ? projectPolygon : projectLineString
                    }
                };
                strategiesByElementType.marker = {
                    _default: "dot",
                    dot: {
                        setup(context) {
                            context.filter = context.renderer.shadowFilter("-40%", "-40%", "180%", "200%", 0, 1, 1, "#000000", .2)
                        },
                        reset(context) {
                            context.filter.dispose();
                            context.filter = null
                        },
                        _draw(ctx, figure, data) {
                            figure.back = ctx.renderer.circle().sharp().data(ctx.dataKey, data).append(figure.root);
                            figure.dot = ctx.renderer.circle().sharp().data(ctx.dataKey, data).append(figure.root)
                        },
                        refresh(ctx, figure, data, proxy, settings) {
                            figure.dot.attr({
                                filter: settings.shadow ? ctx.filter.id : null
                            })
                        },
                        _getStyles(styles, style) {
                            const size = style.size > 0 ? _Number(style.size) : 0;
                            const hoveredSize = size;
                            const selectedSize = size + (style.selectedStep > 0 ? _Number(style.selectedStep) : 0);
                            const hoveredBackSize = hoveredSize + (style.backStep > 0 ? _Number(style.backStep) : 0);
                            const selectedBackSize = selectedSize + (style.backStep > 0 ? _Number(style.backStep) : 0);
                            const color = style.color || null;
                            const borderColor = style.borderColor || null;
                            const borderWidth = pick(style.borderWidth, null);
                            const opacity = pick(style.opacity, null);
                            const backColor = style.backColor || null;
                            const backOpacity = pick(style.backOpacity, null);
                            styles.dot = [{
                                r: size / 2,
                                stroke: borderColor,
                                "stroke-width": borderWidth,
                                fill: color,
                                opacity: opacity
                            }, {
                                r: hoveredSize / 2,
                                stroke: style.hoveredBorderColor || borderColor,
                                "stroke-width": pick(style.hoveredBorderWidth, borderWidth),
                                fill: style.hoveredColor || color,
                                opacity: pick(style.hoveredOpacity, opacity)
                            }, {
                                r: selectedSize / 2,
                                stroke: style.selectedBorderColor || borderColor,
                                "stroke-width": pick(style.selectedBorderWidth, borderWidth),
                                fill: style.selectedColor || color,
                                opacity: pick(style.selectedOpacity, opacity)
                            }];
                            styles.back = [{
                                r: size / 2,
                                stroke: "none",
                                "stroke-width": 0,
                                fill: backColor,
                                opacity: backOpacity
                            }, {
                                r: hoveredBackSize / 2,
                                stroke: "none",
                                "stroke-width": 0,
                                fill: backColor,
                                opacity: backOpacity
                            }, {
                                r: selectedBackSize / 2,
                                stroke: "none",
                                "stroke-width": 0,
                                fill: backColor,
                                opacity: backOpacity
                            }]
                        },
                        _setState(figure, styles, state) {
                            applyElementState(figure, styles, state, "dot");
                            applyElementState(figure, styles, state, "back")
                        }
                    },
                    bubble: {
                        _draw(ctx, figure, data) {
                            figure.bubble = ctx.renderer.circle().sharp().data(ctx.dataKey, data).append(figure.root)
                        },
                        refresh(ctx, figure, data, proxy, settings) {
                            figure.bubble.attr({
                                r: settings.size / 2
                            })
                        },
                        _getStyles(styles, style) {
                            const color = style.color || null;
                            const borderColor = style.borderColor || null;
                            const borderWidth = pick(style.borderWidth, null);
                            const opacity = pick(style.opacity, null);
                            styles.bubble = [{
                                stroke: borderColor,
                                "stroke-width": borderWidth,
                                fill: color,
                                opacity: opacity
                            }, {
                                stroke: style.hoveredBorderColor || borderColor,
                                "stroke-width": pick(style.hoveredBorderWidth, borderWidth),
                                fill: style.hoveredColor || style.color,
                                opacity: pick(style.hoveredOpacity, opacity)
                            }, {
                                stroke: style.selectedBorderColor || borderColor,
                                "stroke-width": pick(style.selectedBorderWidth, borderWidth),
                                fill: style.selectedColor || style.color,
                                opacity: pick(style.selectedOpacity, opacity)
                            }]
                        },
                        _setState(figure, styles, state) {
                            applyElementState(figure, styles, state, "bubble")
                        },
                        arrange(context, handles) {
                            const values = [];
                            let i;
                            const ii = values.length = handles.length;
                            const settings = context.settings;
                            const dataField = settings.dataField;
                            const minSize = settings.minSize > 0 ? _Number(settings.minSize) : 0;
                            const maxSize = settings.maxSize > minSize ? _Number(settings.maxSize) : minSize;
                            if (settings.sizeGroups) {
                                return
                            }
                            for (i = 0; i < ii; ++i) {
                                values[i] = _max(getDataValue(handles[i].proxy, dataField) || 0, 0)
                            }
                            const minValue = _min.apply(null, values);
                            const maxValue = _max.apply(null, values);
                            const deltaValue = maxValue - minValue || 1;
                            const deltaSize = maxSize - minSize;
                            for (i = 0; i < ii; ++i) {
                                handles[i]._settings.size = minSize + deltaSize * (values[i] - minValue) / deltaValue
                            }
                        },
                        updateGrouping(context) {
                            const dataField = context.settings.dataField;
                            strategiesByType.marker.updateGrouping(context);
                            groupBySize(context, (proxy => getDataValue(proxy, dataField)))
                        }
                    },
                    pie: {
                        _draw(ctx, figure, data) {
                            figure.pie = ctx.renderer.g().append(figure.root);
                            figure.border = ctx.renderer.circle().sharp().data(ctx.dataKey, data).append(figure.root)
                        },
                        refresh(ctx, figure, data, proxy, settings) {
                            const values = getDataValue(proxy, ctx.settings.dataField) || [];
                            const colors = settings._colors;
                            let sum = 0;
                            const pie = figure.pie;
                            const renderer = ctx.renderer;
                            const dataKey = ctx.dataKey;
                            const r = (settings.size > 0 ? _Number(settings.size) : 0) / 2;
                            let start = 90;
                            let end = start;
                            let zeroSum = false;
                            sum = values.reduce(((total, item) => total + (item || 0)), 0);
                            if (0 === sum) {
                                zeroSum = true;
                                sum = 360 / values.length
                            }
                            values.forEach(((item, i) => {
                                start = end;
                                end += zeroSum ? sum : (item || 0) / sum * 360;
                                renderer.arc(0, 0, 0, r, start, end).attr({
                                    "stroke-linejoin": "round",
                                    fill: colors[i]
                                }).data(dataKey, data).append(pie)
                            }));
                            figure.border.attr({
                                r: r
                            })
                        },
                        _getStyles(styles, style) {
                            const opacity = pick(style.opacity, null);
                            const borderColor = style.borderColor || null;
                            const borderWidth = pick(style.borderWidth, null);
                            styles.pie = [{
                                opacity: opacity
                            }, {
                                opacity: pick(style.hoveredOpacity, opacity)
                            }, {
                                opacity: pick(style.selectedOpacity, opacity)
                            }];
                            styles.border = [{
                                stroke: borderColor,
                                "stroke-width": borderWidth
                            }, {
                                stroke: style.hoveredBorderColor || borderColor,
                                "stroke-width": pick(style.hoveredBorderWidth, borderWidth)
                            }, {
                                stroke: style.selectedBorderColor || borderColor,
                                "stroke-width": pick(style.selectedBorderWidth, borderWidth)
                            }]
                        },
                        _setState(figure, styles, state) {
                            applyElementState(figure, styles, state, "pie");
                            applyElementState(figure, styles, state, "border")
                        },
                        arrange(context, handles) {
                            let i;
                            const ii = handles.length;
                            const dataField = context.settings.dataField;
                            let values;
                            let count = 0;
                            let palette;
                            for (i = 0; i < ii; ++i) {
                                values = getDataValue(handles[i].proxy, dataField);
                                if (values && values.length > count) {
                                    count = values.length
                                }
                            }
                            if (count > 0) {
                                palette = context.params.themeManager.createPalette(context.settings.palette, {
                                    useHighlight: true,
                                    extensionMode: "alternate"
                                });
                                values = palette.generateColors(count);
                                context.settings._colors = values;
                                context.grouping.color = {
                                    callback: _noop,
                                    field: "",
                                    partition: [],
                                    values: []
                                };
                                context.params.dataExchanger.set(context.name, "color", {
                                    partition: [],
                                    values: values
                                })
                            }
                        }
                    },
                    image: {
                        _draw(ctx, figure, data) {
                            figure.image = ctx.renderer.image(null, null, null, null, null, "center").attr({
                                "pointer-events": "visible"
                            }).data(ctx.dataKey, data).append(figure.root)
                        },
                        refresh(ctx, figure, data, proxy) {
                            figure.image.attr({
                                href: getDataValue(proxy, ctx.settings.dataField)
                            })
                        },
                        _getStyles(styles, style) {
                            const size = style.size > 0 ? _Number(style.size) : 0;
                            const hoveredSize = size + (style.hoveredStep > 0 ? _Number(style.hoveredStep) : 0);
                            const selectedSize = size + (style.selectedStep > 0 ? _Number(style.selectedStep) : 0);
                            const opacity = pick(style.opacity, null);
                            styles.image = [{
                                x: -size / 2,
                                y: -size / 2,
                                width: size,
                                height: size,
                                opacity: opacity
                            }, {
                                x: -hoveredSize / 2,
                                y: -hoveredSize / 2,
                                width: hoveredSize,
                                height: hoveredSize,
                                opacity: pick(style.hoveredOpacity, opacity)
                            }, {
                                x: -selectedSize / 2,
                                y: -selectedSize / 2,
                                width: selectedSize,
                                height: selectedSize,
                                opacity: pick(style.selectedOpacity, opacity)
                            }]
                        },
                        _setState(figure, styles, state) {
                            applyElementState(figure, styles, state, "image")
                        }
                    }
                };

                function projectPointList(projection, coordinates) {
                    const output = [];
                    let i;
                    const ii = output.length = coordinates.length;
                    for (i = 0; i < ii; ++i) {
                        output[i] = projection.project(coordinates[i])
                    }
                    return output
                }

                function projectLineString(projection, coordinates) {
                    return [projectPointList(projection, coordinates)]
                }

                function projectPolygon(projection, coordinates) {
                    const output = [];
                    let i;
                    const ii = output.length = coordinates.length;
                    for (i = 0; i < ii; ++i) {
                        output[i] = projectPointList(projection, coordinates[i])
                    }
                    return output
                }

                function transformList(projection, coordinates) {
                    const output = [];
                    let i;
                    const ii = coordinates.length;
                    let item;
                    let k = 0;
                    output.length = 2 * ii;
                    for (i = 0; i < ii; ++i) {
                        item = projection.transform(coordinates[i]);
                        output[k++] = item[0];
                        output[k++] = item[1]
                    }
                    return output
                }

                function transformPointList(content, projection, coordinates) {
                    const output = [];
                    let i;
                    const ii = output.length = coordinates.length;
                    for (i = 0; i < ii; ++i) {
                        output[i] = transformList(projection, coordinates[i])
                    }
                    content.root.attr({
                        points: output
                    })
                }

                function getItemSettings(context, proxy, settings) {
                    const result = combineSettings(context.settings, settings);
                    ! function(grouping, proxy, settings) {
                        _each(grouping, ((name, data) => {
                            const index = findGroupingIndex(data.callback(proxy, data.field), data.partition);
                            if (index >= 0) {
                                settings[name] = data.values[index]
                            }
                        }))
                    }(context.grouping, proxy, result);
                    if (void 0 === settings.color && settings.paletteIndex >= 0) {
                        result.color = result._colors[settings.paletteIndex]
                    }
                    return result
                }

                function findGroupingIndex(value, partition) {
                    let start = 0;
                    let end = partition.length - 1;
                    let index = -1;
                    let middle;
                    if (partition[start] <= value && value <= partition[end]) {
                        if (value === partition[end]) {
                            index = end - 1
                        } else {
                            while (end - start > 1) {
                                middle = start + end >> 1;
                                if (value < partition[middle]) {
                                    end = middle
                                } else {
                                    start = middle
                                }
                            }
                            index = start
                        }
                    }
                    return index
                }

                function raiseChanged(context, handle, state, name) {
                    context.params.eventTrigger(name, {
                        target: handle.proxy,
                        state: state
                    })
                }

                function combineSettings(common, partial) {
                    const obj = _extend({}, common, partial);
                    obj.label = _extend({}, common.label, obj.label);
                    obj.label.font = _extend({}, common.label.font, obj.label.font);
                    return obj
                }

                function valueCallback(proxy, dataField) {
                    return proxy.attribute(dataField)
                }
                let performGrouping = function(context, partition, settingField, dataField, valuesCallback) {
                    let values;
                    if (dataField && partition && partition.length > 1) {
                        values = valuesCallback(partition.length - 1);
                        context.grouping[settingField] = {
                            callback: (0, _type.isFunction)(dataField) ? dataField : valueCallback,
                            field: dataField,
                            partition: partition,
                            values: values
                        };
                        context.params.dataExchanger.set(context.name, settingField, {
                            partition: partition,
                            values: values,
                            defaultColor: context.settings.color
                        })
                    }
                };

                function dropGrouping(context) {
                    const name = context.name;
                    const dataExchanger = context.params.dataExchanger;
                    _each(context.grouping, (field => {
                        dataExchanger.set(name, field, null)
                    }));
                    context.grouping = {}
                }
                groupByColor = function(context) {
                    performGrouping(context, context.settings.colorGroups, "color", context.settings.colorGroupingField, (count => {
                        const _palette = context.params.themeManager.createDiscretePalette(context.settings.palette, count);
                        let i;
                        const list = [];
                        for (i = 0; i < count; ++i) {
                            list.push(_palette.getColor(i))
                        }
                        return list
                    }))
                };
                groupBySize = function(context, valueCallback) {
                    const settings = context.settings;
                    performGrouping(context, settings.sizeGroups, "size", valueCallback || settings.sizeGroupingField, (count => {
                        const minSize = settings.minSize > 0 ? _Number(settings.minSize) : 0;
                        const maxSize = settings.maxSize >= minSize ? _Number(settings.maxSize) : 0;
                        let i = 0;
                        const sizes = [];
                        if (count > 1) {
                            for (i = 0; i < count; ++i) {
                                sizes.push((minSize * (count - i - 1) + maxSize * i) / (count - 1))
                            }
                        } else if (1 === count) {
                            sizes.push((minSize + maxSize) / 2)
                        }
                        return sizes
                    }))
                };

                function setFlag(flags, flag, state) {
                    if (state) {
                        flags |= flag
                    } else {
                        flags &= ~flag
                    }
                    return flags
                }

                function hasFlag(flags, flag) {
                    return !!(flags & flag)
                }
                let MapLayerElement;
                let MapLayer = function(params, container, name, index) {
                    this._params = params;
                    this._onProjection();
                    this.proxy = function(layer, name, index) {
                        const proxy = {
                            index: index,
                            name: name,
                            getElements: () => layer.getProxies(),
                            clearSelection(_noEvent) {
                                layer.clearSelection(_noEvent);
                                return proxy
                            },
                            getDataSource: () => layer.getDataSource(),
                            getBounds: () => layer.getBounds()
                        };
                        return proxy
                    }(this, name, index);
                    this._context = {
                        name: name,
                        layer: this.proxy,
                        renderer: params.renderer,
                        projection: params.projection,
                        params: params,
                        dataKey: params.dataKey,
                        str: emptyStrategy,
                        hover: false,
                        selection: null,
                        grouping: {},
                        root: params.renderer.g().attr({
                            class: "dxm-layer"
                        }).linkOn(container, name).linkAppend()
                    };
                    this._container = container;
                    this._options = {};
                    this._handles = [];
                    this._data = new EmptySource;
                    this._dataSourceLoaded = null
                };
                MapLayer.prototype = _extend({
                    constructor: MapLayer,
                    getDataReadyCallback() {
                        return this._dataSourceLoaded
                    },
                    _onProjection() {
                        const that = this;
                        that._removeHandlers = that._params.projection.on({
                            engine() {
                                that._project()
                            },
                            screen() {
                                that._transform()
                            },
                            center() {
                                that._transformCore()
                            },
                            zoom() {
                                that._transform()
                            }
                        })
                    },
                    getData() {
                        return this._data
                    },
                    _dataSourceLoadErrorHandler() {
                        this._dataSourceChangedHandler()
                    },
                    _dataSourceChangedHandler() {
                        this._data = function(source) {
                            let sourceType;
                            if (source) {
                                if (isGeoJsonObject(source)) {
                                    sourceType = GeoJsonSource
                                } else if (1 === source.length && source[0] && isGeoJsonObject(source[0])) {
                                    sourceType = GeoJsonSource;
                                    source = source[0]
                                } else if (_isArray(source)) {
                                    sourceType = ArraySource
                                }
                            }
                            sourceType = sourceType || EmptySource;
                            return new sourceType(source)
                        }(this._dataSource && this._dataSource.items());
                        this._update(true)
                    },
                    _dataSourceOptions: () => ({
                        paginate: false
                    }),
                    _getSpecificDataSourceOption() {
                        return this._specificDataSourceOption
                    },
                    _normalizeDataSource(dataSource) {
                        const store = dataSource.store();
                        if ("raw" === store._loadMode) {
                            store._loadMode = void 0
                        }
                        return dataSource
                    },
                    _offProjection() {
                        this._removeHandlers();
                        this._removeHandlers = null
                    },
                    dispose() {
                        this._disposeDataSource();
                        this._destroyHandles();
                        dropGrouping(this._context);
                        this._context.root.linkRemove().linkOff();
                        this._context.labelRoot && this._context.labelRoot.linkRemove().linkOff();
                        this._context.str.reset(this._context);
                        this._offProjection();
                        this._params = this._container = this._context = this.proxy = null;
                        return this
                    },
                    setOptions(options) {
                        const that = this;
                        options = that._options = options || {};
                        that._dataSourceLoaded = (0, _deferred.Deferred)();
                        if ("dataSource" in options && options.dataSource !== that._options_dataSource) {
                            that._options_dataSource = options.dataSource;
                            that._params.notifyDirty();
                            that._specificDataSourceOption = (option = options.dataSource, option ? isGeoJsonObject(option) ? [option] : option : []);
                            that._refreshDataSource()
                        } else if (that._data.count() > 0) {
                            that._params.notifyDirty();
                            that._update(void 0 !== options.type && options.type !== that._context.str.type || void 0 !== options.elementType && options.elementType !== that._context.str.elementType)
                        }
                        var option;
                        that._transformCore()
                    },
                    _update(isContextChanged) {
                        const that = this;
                        const context = that._context;
                        if (isContextChanged) {
                            context.str.reset(context);
                            context.root.clear();
                            context.labelRoot && context.labelRoot.clear();
                            that._params.tracker.reset();
                            that._destroyHandles();
                            context.str = selectStrategy(that._options, that._data);
                            context.str.setup(context);
                            that.proxy.type = context.str.type;
                            that.proxy.elementType = context.str.elementType
                        }
                        context.settings = function(context, options) {
                            const themeManager = context.params.themeManager;
                            const strategy = context.str;
                            const settings = combineSettings(_extend({
                                label: {},
                                color: strategy.getDefaultColor(context, options.palette)
                            }, themeManager.theme(`layer:${strategy.fullType}`)), options);
                            let colors;
                            let i;
                            let palette;
                            if (settings.paletteSize > 0) {
                                palette = themeManager.createDiscretePalette(settings.palette, settings.paletteSize);
                                for (i = 0, colors = []; i < settings.paletteSize; ++i) {
                                    colors.push(palette.getColor(i))
                                }
                                settings._colors = colors
                            }
                            return settings
                        }(context, that._options);
                        context.hasSeparateLabel = !!(context.settings.label.enabled && context.str.hasLabelsGroup);
                        context.hover = !!(0, _utils.parseScalar)(context.settings.hoverEnabled, true);
                        if (context.selection) {
                            _each(context.selection.state, ((_, handle) => {
                                handle && handle.resetSelected()
                            }))
                        }
                        context.selection = function(selectionMode) {
                            let selection = (0, _utils.normalizeEnum)(selectionMode);
                            selection = selection in SELECTIONS ? SELECTIONS[selection] : SELECTIONS.single;
                            if (null !== selection) {
                                selection = {
                                    state: {},
                                    single: selection
                                }
                            }
                            return selection
                        }(context.settings.selectionMode);
                        if (context.hasSeparateLabel) {
                            if (!context.labelRoot) {
                                context.labelRoot = context.renderer.g().attr({
                                    class: "dxm-layer-labels"
                                }).linkOn(that._container, {
                                    name: `${context.name}-labels`,
                                    after: context.name
                                }).linkAppend();
                                that._transformCore()
                            }
                        } else if (context.labelRoot) {
                            context.labelRoot.linkRemove().linkOff();
                            context.labelRoot = null
                        }
                        if (isContextChanged) {
                            that._createHandles()
                        }
                        dropGrouping(context);
                        context.str.arrange(context, that._handles);
                        context.str.updateGrouping(context);
                        that._updateHandles();
                        that._params.notifyReady();
                        if (that._dataSourceLoaded) {
                            that._dataSourceLoaded.resolve();
                            that._dataSourceLoaded = null
                        } else {
                            that._params.dataReady()
                        }
                    },
                    getBounds() {
                        return getMaxBound(this._handles.map((_ref => {
                            let {
                                proxy: proxy
                            } = _ref;
                            return proxy.coordinates().map((coords => {
                                if (!_isArray(coords)) {
                                    return
                                }
                                const coordsToBoundsSearch = _isArray(coords[0][0]) ? coords.reduce(((ac, val) => ac.concat(val)), []) : coords;
                                const initValue = coordsToBoundsSearch[0];
                                return coordsToBoundsSearch.reduce(((min, c) => [_min(min[0], c[0]), _min(min[1], c[1]), _max(min[2], c[0]), _max(min[3], c[1])]), [initValue[0], initValue[1], initValue[0], initValue[1]])
                            }))
                        })).map(getMaxBound))
                    },
                    _destroyHandles() {
                        this._handles.forEach((h => h.dispose()));
                        if (this._context.selection) {
                            this._context.selection.state = {}
                        }
                        this._handles = []
                    },
                    _createHandles() {
                        const handles = this._handles = [];
                        const data = this._data;
                        let i;
                        const ii = handles.length = data.count();
                        const context = this._context;
                        const geometry = data.geometry;
                        const attributes = data.attributes;
                        let handle;
                        let dataItem;
                        for (i = 0; i < ii; ++i) {
                            dataItem = data.item(i);
                            handles[i] = new MapLayerElement(context, i, geometry(dataItem), attributes(dataItem))
                        }(0, _type.isFunction)(this._options.customize) && (proxies = this.getProxies(), callback = this._options.customize, widget = this._params.widget, void callback.call(widget, proxies));
                        var proxies, callback, widget;
                        for (i = 0; i < ii; ++i) {
                            handle = handles[i];
                            handle.project();
                            handle.draw();
                            handle.transform()
                        }
                        if (context.selection) {
                            _each(context.selection.state, ((_, handle) => {
                                handle && handle.restoreSelected()
                            }))
                        }
                    },
                    _updateHandles() {
                        const handles = this._handles;
                        let i;
                        const ii = handles.length;
                        for (i = 0; i < ii; ++i) {
                            handles[i].refresh()
                        }
                        if (this._context.settings.label.enabled) {
                            for (i = 0; i < ii; ++i) {
                                handles[i].measureLabel()
                            }
                            for (i = 0; i < ii; ++i) {
                                handles[i].adjustLabel()
                            }
                        }
                    },
                    _transformCore() {
                        const transform = this._params.projection.getTransform();
                        this._context.root.attr(transform);
                        this._context.labelRoot && this._context.labelRoot.attr(transform)
                    },
                    _project() {
                        const handles = this._handles;
                        let i;
                        const ii = handles.length;
                        for (i = 0; i < ii; ++i) {
                            handles[i].project()
                        }
                    },
                    _transform() {
                        const handles = this._handles;
                        let i;
                        const ii = handles.length;
                        this._transformCore();
                        for (i = 0; i < ii; ++i) {
                            handles[i].transform()
                        }
                    },
                    getProxies() {
                        return this._handles.map((p => p.proxy))
                    },
                    getProxy(index) {
                        return this._handles[index].proxy
                    },
                    raiseClick(i, dxEvent) {
                        this._params.eventTrigger("click", {
                            target: this._handles[i].proxy,
                            event: dxEvent
                        })
                    },
                    hoverItem(i, state) {
                        this._handles[i].setHovered(state)
                    },
                    selectItem(i, state, _noEvent) {
                        this._handles[i].setSelected(state, _noEvent)
                    },
                    clearSelection() {
                        const selection = this._context.selection;
                        if (selection) {
                            _each(selection.state, ((_, handle) => {
                                handle && handle.setSelected(false)
                            }));
                            selection.state = {}
                        }
                    }
                }, _data.DataHelperMixin);
                MapLayerElement = function(context, index, geometry, attributes) {
                    const proxy = this.proxy = function(handle, coords, attrs) {
                        const proxy = {
                            coordinates: () => coords,
                            attribute(name, value) {
                                if (arguments.length > 1) {
                                    attrs[name] = value;
                                    return proxy
                                } else {
                                    return arguments.length > 0 ? attrs[name] : attrs
                                }
                            },
                            selected(state, _noEvent) {
                                if (arguments.length > 0) {
                                    handle.setSelected(state, _noEvent);
                                    return proxy
                                } else {
                                    return handle.isSelected()
                                }
                            },
                            applySettings(settings) {
                                handle.update(settings);
                                return proxy
                            }
                        };
                        return proxy
                    }(this, geometry.coordinates, _extend({}, attributes));
                    this._ctx = context;
                    this._index = index;
                    this._fig = this._label = null;
                    this._state = 0;
                    this._coordinates = geometry.coordinates;
                    this._settings = {
                        label: {}
                    };
                    proxy.index = index;
                    proxy.layer = context.layer;
                    this._data = {
                        name: context.name,
                        index: index
                    }
                };
                MapLayerElement.prototype = {
                    constructor: MapLayerElement,
                    dispose() {
                        this._ctx = this.proxy = this._settings = this._fig = this._label = this.data = null;
                        return this
                    },
                    project() {
                        const context = this._ctx;
                        this._projection = context.str.project(context.projection, this._coordinates);
                        if (context.hasSeparateLabel && this._label) {
                            this._projectLabel()
                        }
                    },
                    _projectLabel() {
                        this._labelProjection = this._ctx.str.projectLabel(this._projection)
                    },
                    draw() {
                        const context = this._ctx;
                        context.str.draw(context, this._fig = {}, this._data);
                        this._fig.root.append(context.root)
                    },
                    transform() {
                        const that = this;
                        const context = that._ctx;
                        context.str.transform(that._fig, context.projection, that._projection);
                        if (context.hasSeparateLabel && that._label) {
                            that._transformLabel()
                        }
                    },
                    _transformLabel() {
                        this._ctx.str.transformLabel(this._label, this._ctx.projection, this._labelProjection)
                    },
                    refresh() {
                        const strategy = this._ctx.str;
                        const settings = getItemSettings(this._ctx, this.proxy, this._settings);
                        this._styles = strategy.getStyles(settings);
                        strategy.refresh(this._ctx, this._fig, this._data, this.proxy, settings);
                        this._refreshLabel(settings);
                        this._setState()
                    },
                    _refreshLabel(settings) {
                        const that = this;
                        const context = that._ctx;
                        const labelSettings = settings.label;
                        let label = that._label;
                        if (context.settings.label.enabled) {
                            if (!label) {
                                label = that._label = {
                                    root: context.labelRoot || that._fig.root,
                                    text: context.renderer.text().attr({
                                        class: "dxm-label"
                                    }),
                                    size: [0, 0]
                                };
                                if (context.hasSeparateLabel) {
                                    that._projectLabel();
                                    that._transformLabel()
                                }
                            }
                            label.value = _String(that.proxy.text || that.proxy.attribute(labelSettings.dataField) || "");
                            if (label.value) {
                                label.text.attr({
                                    text: label.value,
                                    x: 0,
                                    y: 0
                                }).css((0, _utils.patchFontOptions)(labelSettings.font)).attr({
                                    align: "center",
                                    stroke: labelSettings.stroke,
                                    "stroke-width": labelSettings["stroke-width"],
                                    "stroke-opacity": labelSettings["stroke-opacity"]
                                }).data(context.dataKey, that._data).append(label.root);
                                label.settings = settings
                            }
                        } else if (label) {
                            label.text.remove();
                            that._label = null
                        }
                    },
                    measureLabel() {
                        const label = this._label;
                        let bBox;
                        if (label.value) {
                            bBox = label.text.getBBox();
                            label.size = [bBox.width, bBox.height, -bBox.y - bBox.height / 2]
                        }
                    },
                    adjustLabel() {
                        const label = this._label;
                        let offset;
                        if (label.value) {
                            offset = this._ctx.str.getLabelOffset(label, label.settings);
                            label.settings = null;
                            label.text.attr({
                                x: offset[0],
                                y: offset[1] + label.size[2]
                            })
                        }
                    },
                    update(settings) {
                        const that = this;
                        that._settings = combineSettings(that._settings, settings);
                        if (that._fig) {
                            that.refresh();
                            if (that._label && that._label.value) {
                                that.measureLabel();
                                that.adjustLabel()
                            }
                        }
                    },
                    _setState() {
                        this._ctx.str.setState(this._fig, this._styles, STATE_TO_INDEX[this._state])
                    },
                    _setForeground() {
                        const root = this._fig.root;
                        this._state ? root.toForeground() : root.toBackground()
                    },
                    setHovered(state) {
                        const that = this;
                        const currentState = hasFlag(that._state, 1);
                        const newState = !!state;
                        if (that._ctx.hover && currentState !== newState) {
                            that._state = setFlag(that._state, 1, newState);
                            that._setState();
                            that._setForeground();
                            raiseChanged(that._ctx, that, newState, "hoverChanged")
                        }
                        return that
                    },
                    setSelected(state, _noEvent) {
                        const that = this;
                        const currentState = hasFlag(that._state, 2);
                        const newState = !!state;
                        const selection = that._ctx.selection;
                        let tmp;
                        if (selection && currentState !== newState) {
                            that._state = setFlag(that._state, 2, newState);
                            tmp = selection.state[selection.single];
                            selection.state[selection.single] = null;
                            if (tmp) {
                                tmp.setSelected(false)
                            }
                            selection.state[selection.single || that._index] = state ? that : null;
                            if (that._fig) {
                                that._setState();
                                that._setForeground();
                                if (!_noEvent) {
                                    raiseChanged(that._ctx, that, newState, "selectionChanged")
                                }
                            }
                        }
                    },
                    isSelected() {
                        return hasFlag(this._state, 2)
                    },
                    resetSelected() {
                        this._state = setFlag(this._state, 2, false)
                    },
                    restoreSelected() {
                        this._fig.root.toForeground()
                    }
                };

                function calculatePolygonCentroid(coordinates) {
                    let i;
                    const length = coordinates.length;
                    let v1;
                    let v2 = coordinates[length - 1];
                    let cross;
                    let cx = 0;
                    let cy = 0;
                    let area = 0;
                    let minX = 1 / 0;
                    let maxX = -1 / 0;
                    let minY = 1 / 0;
                    let maxY = -1 / 0;
                    for (i = 0; i < length; ++i) {
                        v1 = v2;
                        v2 = coordinates[i];
                        cross = v1[0] * v2[1] - v2[0] * v1[1];
                        area += cross;
                        cx += (v1[0] + v2[0]) * cross;
                        cy += (v1[1] + v2[1]) * cross;
                        minX = _min(minX, v2[0]);
                        maxX = _max(maxX, v2[0]);
                        minY = _min(minY, v2[1]);
                        maxY = _max(maxY, v2[1])
                    }
                    return {
                        area: _abs(area) / 2,
                        center: [2 * cx / 3 / area - (minX + maxX) / 2, 2 * cy / 3 / area - (minY + maxY) / 2]
                    }
                }

                function calculateLineStringData(coordinates) {
                    let i;
                    const ii = coordinates.length;
                    let v1;
                    let v2 = coordinates[0] || [];
                    let totalLength = 0;
                    const items = [0];
                    let min0 = v2[0];
                    let max0 = v2[0];
                    let min1 = v2[1];
                    let max1 = v2[1];
                    for (i = 1; i < ii; ++i) {
                        v1 = v2;
                        v2 = coordinates[i];
                        totalLength += _sqrt((v1[0] - v2[0]) * (v1[0] - v2[0]) + (v1[1] - v2[1]) * (v1[1] - v2[1]));
                        items[i] = totalLength;
                        min0 = _min(min0, v2[0]);
                        max0 = _max(max0, v2[0]);
                        min1 = _min(min1, v2[1]);
                        max1 = _max(max1, v2[1])
                    }
                    i = findGroupingIndex(totalLength / 2, items);
                    v1 = coordinates[i];
                    v2 = coordinates[i + 1];
                    const t = (totalLength / 2 - items[i]) / (items[i + 1] - items[i]);
                    return ii ? [
                        [v1[0] * (1 - t) + v2[0] * t, v1[1] * (1 - t) + v2[1] * t],
                        [max0 - min0, max1 - min1], totalLength
                    ] : []
                }

                function MapLayerCollection(params) {
                    const renderer = params.renderer;
                    this._params = params;
                    this._layers = [];
                    this._layerByName = {};
                    this._rect = [0, 0, 0, 0];
                    this._clip = renderer.clipRect();
                    this._background = renderer.rect().attr({
                        class: "dxm-background"
                    }).data(params.dataKey, {
                        name: "background"
                    }).append(renderer.root);
                    this._container = renderer.g().attr({
                        class: "dxm-layers",
                        "clip-path": this._clip.id
                    }).append(renderer.root).enableLinks();
                    this._subscribeToTracker(params.tracker, renderer, params.eventTrigger);
                    this._dataReady = params.dataReady
                }
                MapLayerCollection.prototype = {
                    constructor: MapLayerCollection,
                    dispose() {
                        this._clip.dispose();
                        this._layers.forEach((l => l.dispose()));
                        this._offTracker();
                        this._params = this._offTracker = this._layers = this._layerByName = this._clip = this._background = this._container = null
                    },
                    _subscribeToTracker(tracker, renderer, eventTrigger) {
                        const that = this;
                        that._offTracker = tracker.on({
                            click(arg) {
                                const offset = renderer.getRootOffset();
                                const layer = that.byName(arg.data.name);
                                arg.$event.x = arg.x - offset.left;
                                arg.$event.y = arg.y - offset.top;
                                if (layer) {
                                    layer.raiseClick(arg.data.index, arg.$event)
                                } else if ("background" === arg.data.name) {
                                    eventTrigger("click", {
                                        event: arg.$event
                                    })
                                }
                            },
                            "hover-on": function(arg) {
                                const layer = that.byName(arg.data.name);
                                if (layer) {
                                    layer.hoverItem(arg.data.index, true)
                                }
                            },
                            "hover-off": function(arg) {
                                const layer = that.byName(arg.data.name);
                                if (layer) {
                                    layer.hoverItem(arg.data.index, false)
                                }
                            }
                        })
                    },
                    setOptions(options) {
                        const that = this;
                        const optionList = options ? _isArray(options) ? options : [options] : [];
                        let layers = that._layers;
                        let readyCallbacks = [];
                        const needToCreateLayers = optionList.length !== layers.length || layers.some(((l, i) => {
                            const name = getName(optionList, i);
                            return (0, _type.isDefined)(name) && name !== l.proxy.name
                        }));
                        if (needToCreateLayers) {
                            that._params.tracker.reset();
                            that._layers.forEach((l => l.dispose()));
                            const layerByName = that._layerByName = {};
                            that._layers = layers = [];
                            for (let i = 0, ii = optionList.length; i < ii; ++i) {
                                const name = getName(optionList, i) || `map-layer-${i}`;
                                const layer = layers[i] = new MapLayer(that._params, that._container, name, i);
                                layerByName[name] = layer
                            }
                        }
                        layers.forEach(((l, i) => {
                            l.setOptions(optionList[i])
                        }));
                        readyCallbacks = layers.map((l => l.getDataReadyCallback()));
                        readyCallbacks.length && _deferred.when.apply(void 0, readyCallbacks).done(that._dataReady)
                    },
                    _updateClip() {
                        const rect = this._rect;
                        const bw = this._borderWidth;
                        this._clip.attr({
                            x: rect[0] + bw,
                            y: rect[1] + bw,
                            width: _max(rect[2] - 2 * bw, 0),
                            height: _max(rect[3] - 2 * bw, 0)
                        })
                    },
                    setBackgroundOptions(options) {
                        this._background.attr({
                            stroke: options.borderColor,
                            "stroke-width": options.borderWidth,
                            fill: options.color
                        });
                        this._borderWidth = _max(options.borderWidth, 0);
                        this._updateClip()
                    },
                    setRect(rect) {
                        this._rect = rect;
                        this._background.attr({
                            x: rect[0],
                            y: rect[1],
                            width: rect[2],
                            height: rect[3]
                        });
                        this._updateClip()
                    },
                    byIndex(index) {
                        return this._layers[index]
                    },
                    byName(name) {
                        return this._layerByName[name]
                    },
                    items() {
                        return this._layers
                    }
                }
            },
        4381:
            /*!**************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/viz/pie_chart.js ***!
              \**************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _m_pie_chart = (e = __webpack_require__( /*! ../__internal/viz/m_pie_chart */ 98895), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _m_pie_chart.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4445:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/localization/default_date_names.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _m_iterator = __webpack_require__( /*! ../../core/utils/m_iterator */ 26044);
                const MONTHS = ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"];
                const DAYS = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
                const PERIODS = ["AM", "PM"];
                const QUARTERS = ["Q1", "Q2", "Q3", "Q4"];
                const cutCaptions = (captions, format) => {
                    const lengthByFormat = {
                        abbreviated: 3,
                        short: 2,
                        narrow: 1
                    };
                    return (0, _m_iterator.map)(captions, (caption => caption.substr(0, lengthByFormat[format])))
                };
                exports.default = {
                    getMonthNames: format => cutCaptions(MONTHS, format),
                    getDayNames: format => cutCaptions(DAYS, format),
                    getQuarterNames: _format => QUARTERS,
                    getPeriodNames: _format => PERIODS
                }
            },
        4517:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/light/sankey.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _contants = __webpack_require__( /*! ./contants */ 12462);
                exports.default = {
                    sankey: {
                        sourceField: "source",
                        targetField: "target",
                        weightField: "weight",
                        hoverEnabled: true,
                        alignment: _contants.CENTER,
                        adaptiveLayout: {
                            width: 80,
                            height: 80,
                            keepLabels: true
                        },
                        label: {
                            visible: true,
                            horizontalOffset: 8,
                            verticalOffset: 0,
                            overlappingBehavior: "ellipsis",
                            useNodeColors: false,
                            font: {
                                color: _contants.BLACK,
                                weight: 500
                            },
                            border: {
                                visible: false,
                                width: 2,
                                color: _contants.WHITE
                            },
                            customizeText: info => info.label,
                            shadow: {
                                opacity: .2,
                                offsetX: 0,
                                offsetY: 1,
                                blur: 1,
                                color: _contants.WHITE
                            }
                        },
                        title: {
                            margin: 10,
                            font: {
                                size: 28,
                                weight: 200
                            },
                            subtitle: {
                                font: {
                                    size: 16
                                }
                            }
                        },
                        tooltip: {
                            enabled: true
                        },
                        node: {
                            padding: 30,
                            width: 8,
                            opacity: 1,
                            border: {
                                color: _contants.WHITE,
                                width: 1,
                                visible: false
                            },
                            hoverStyle: {
                                hatching: {
                                    opacity: .75,
                                    step: 6,
                                    width: 2,
                                    direction: _contants.RIGHT
                                },
                                border: {}
                            }
                        },
                        link: {
                            color: "#888888",
                            colorMode: "none",
                            opacity: .3,
                            border: {
                                color: _contants.WHITE,
                                width: 1,
                                visible: false
                            },
                            hoverStyle: {
                                opacity: .5,
                                hatching: {
                                    opacity: .75,
                                    step: 6,
                                    width: 2,
                                    direction: _contants.RIGHT
                                },
                                border: {}
                            }
                        }
                    }
                }
            },
        4655:
            /*!*****************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/viz/linear_gauge.js ***!
              \*****************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _linear_gauge = (e = __webpack_require__( /*! ../__internal/viz/gauges/linear_gauge */ 98442), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _linear_gauge.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4671:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/localization/message.js ***!
              \*********************************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _message = (e = __webpack_require__( /*! ../../../__internal/core/localization/message */ 18205), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = _message.default;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        4702:
            /*!***********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/light/index.js ***!
              \***********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _bar_gauge = _interopRequireDefault(__webpack_require__( /*! ./bar_gauge */ 39599));
                var _bullet = _interopRequireDefault(__webpack_require__( /*! ./bullet */ 5828));
                var _chart = _interopRequireDefault(__webpack_require__( /*! ./chart */ 67322));
                var _contants = __webpack_require__( /*! ./contants */ 12462);
                var _funnel = _interopRequireDefault(__webpack_require__( /*! ./funnel */ 60980));
                var _gauge = _interopRequireDefault(__webpack_require__( /*! ./gauge */ 77393));
                var _pie_chart = _interopRequireDefault(__webpack_require__( /*! ./pie_chart */ 82611));
                var _polar_chart = _interopRequireDefault(__webpack_require__( /*! ./polar_chart */ 53949));
                var _range_selector = _interopRequireDefault(__webpack_require__( /*! ./range_selector */ 11055));
                var _sankey = _interopRequireDefault(__webpack_require__( /*! ./sankey */ 4517));
                var _sparkline = _interopRequireDefault(__webpack_require__( /*! ./sparkline */ 72513));
                var _tree_map = _interopRequireDefault(__webpack_require__( /*! ./tree_map */ 47661));
                var _vector_map = _interopRequireDefault(__webpack_require__( /*! ./vector_map */ 44062));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.default = [{
                    baseThemeName: void 0,
                    theme: Object.assign({
                        name: "generic.light",
                        isDefault: true,
                        font: {
                            color: _contants.SECONDARY_TITLE_COLOR,
                            family: "-apple-system, BlinkMacSystemFont, 'avenir next', avenir, 'segoe ui', 'helvetica neue', 'adwaita sans', cantarell, ubuntu, roboto, noto, helvetica, arial, sans-serif",
                            weight: 400,
                            size: 12,
                            cursor: "default"
                        },
                        redrawOnResize: true,
                        backgroundColor: _contants.WHITE,
                        primaryTitleColor: _contants.PRIMARY_TITLE_COLOR,
                        secondaryTitleColor: _contants.SECONDARY_TITLE_COLOR,
                        gridColor: _contants.LIGHT_GREY,
                        axisColor: _contants.SECONDARY_TITLE_COLOR,
                        title: {
                            backgroundColor: _contants.WHITE,
                            font: {
                                size: 28,
                                family: "-apple-system, BlinkMacSystemFont, 'avenir next', avenir, 'segoe ui', 'helvetica neue', 'adwaita sans', cantarell, ubuntu, roboto, noto, helvetica, arial, sans-serif",
                                weight: 200
                            },
                            subtitle: {
                                font: {
                                    size: 16
                                },
                                offset: 0,
                                wordWrap: "normal",
                                textOverflow: "ellipsis"
                            },
                            wordWrap: "normal",
                            textOverflow: "ellipsis"
                        },
                        loadingIndicator: {
                            text: "Loading..."
                        },
                        export: {
                            backgroundColor: _contants.WHITE,
                            margin: 10,
                            font: {
                                size: 14,
                                color: _contants.PRIMARY_TITLE_COLOR,
                                weight: 400
                            },
                            button: {
                                margin: {
                                    top: 8,
                                    left: 10,
                                    right: 10,
                                    bottom: 8
                                },
                                default: {
                                    color: "#333",
                                    borderColor: "#ddd",
                                    backgroundColor: _contants.WHITE
                                },
                                hover: {
                                    color: "#333",
                                    borderColor: "#bebebe",
                                    backgroundColor: "#e6e6e6"
                                },
                                focus: {
                                    color: _contants.BLACK,
                                    borderColor: "#9d9d9d",
                                    backgroundColor: "#e6e6e6"
                                },
                                active: {
                                    color: "#333",
                                    borderColor: "#9d9d9d",
                                    backgroundColor: "#d4d4d4"
                                }
                            },
                            shadowColor: _contants.LIGHT_GREY
                        },
                        tooltip: {
                            enabled: false,
                            border: {
                                width: 1,
                                color: _contants.LIGHT_GREY,
                                dashStyle: _contants.SOLID,
                                visible: true
                            },
                            font: {
                                color: _contants.PRIMARY_TITLE_COLOR
                            },
                            color: _contants.WHITE,
                            arrowLength: 10,
                            paddingLeftRight: 18,
                            paddingTopBottom: 15,
                            textAlignment: "center",
                            shared: false,
                            location: _contants.CENTER,
                            shadow: {
                                opacity: .4,
                                offsetX: 0,
                                offsetY: 4,
                                blur: 2,
                                color: _contants.BLACK
                            },
                            interactive: false
                        },
                        legend: {
                            hoverMode: "includePoints",
                            verticalAlignment: _contants.TOP,
                            horizontalAlignment: _contants.RIGHT,
                            position: _contants.OUTSIDE,
                            visible: true,
                            margin: 10,
                            markerSize: 12,
                            border: {
                                visible: false,
                                width: 1,
                                cornerRadius: 0,
                                dashStyle: _contants.SOLID
                            },
                            paddingLeftRight: 20,
                            paddingTopBottom: 15,
                            columnCount: 0,
                            rowCount: 0,
                            columnItemSpacing: 20,
                            rowItemSpacing: 8,
                            title: {
                                backgroundColor: _contants.WHITE,
                                margin: {
                                    left: 0,
                                    bottom: 9,
                                    right: 0,
                                    top: 0
                                },
                                font: {
                                    size: 18,
                                    weight: 200
                                },
                                subtitle: {
                                    offset: 0,
                                    font: {
                                        size: 14
                                    },
                                    wordWrap: "none",
                                    textOverflow: "ellipsis"
                                },
                                wordWrap: "none",
                                textOverflow: "ellipsis"
                            }
                        }
                    }, _chart.default, _funnel.default, _gauge.default, _bar_gauge.default, _vector_map.default, _pie_chart.default, _polar_chart.default, _range_selector.default, _sankey.default, _sparkline.default, _bullet.default, _tree_map.default)
                }, {
                    baseThemeName: "generic.light",
                    theme: {
                        name: "generic.light.compact"
                    }
                }]
            },
        4785:
            /*!*******************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/core/utils/support.js ***!
              \*******************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "animation", {
                    enumerable: true,
                    get: function() {
                        return _m_support.animation
                    }
                });
                Object.defineProperty(exports, "inputType", {
                    enumerable: true,
                    get: function() {
                        return _m_support.inputType
                    }
                });
                Object.defineProperty(exports, "nativeScrolling", {
                    enumerable: true,
                    get: function() {
                        return _m_support.nativeScrolling
                    }
                });
                Object.defineProperty(exports, "pointerEvents", {
                    enumerable: true,
                    get: function() {
                        return _m_support.pointerEvents
                    }
                });
                Object.defineProperty(exports, "styleProp", {
                    enumerable: true,
                    get: function() {
                        return _m_support.styleProp
                    }
                });
                Object.defineProperty(exports, "stylePropPrefix", {
                    enumerable: true,
                    get: function() {
                        return _m_support.stylePropPrefix
                    }
                });
                Object.defineProperty(exports, "supportProp", {
                    enumerable: true,
                    get: function() {
                        return _m_support.supportProp
                    }
                });
                Object.defineProperty(exports, "touch", {
                    enumerable: true,
                    get: function() {
                        return _m_support.touch
                    }
                });
                Object.defineProperty(exports, "touchEvents", {
                    enumerable: true,
                    get: function() {
                        return _m_support.touchEvents
                    }
                });
                Object.defineProperty(exports, "transition", {
                    enumerable: true,
                    get: function() {
                        return _m_support.transition
                    }
                });
                Object.defineProperty(exports, "transitionEndEventName", {
                    enumerable: true,
                    get: function() {
                        return _m_support.transitionEndEventName
                    }
                });
                var _m_support = __webpack_require__( /*! ../../__internal/core/utils/m_support */ 85991)
            },
        4845:
            /*!*****************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/sankey/sankey.js ***!
              \*****************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 92848));
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _data_source = __webpack_require__( /*! ../../viz/core/data_source */ 98972);
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../../viz/core/m_base_widget */ 34506));
                var _constants = __webpack_require__( /*! ../../viz/sankey/constants */ 78676);
                var _layout = __webpack_require__( /*! ../../viz/sankey/layout */ 48342);
                var _link_item = _interopRequireDefault(__webpack_require__( /*! ../../viz/sankey/link_item */ 15768));
                var _node_item = _interopRequireDefault(__webpack_require__( /*! ../../viz/sankey/node_item */ 3444));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }

                function getConnectedLinks(layout, nodeName, linkType) {
                    const result = [];
                    const attrName = "in" === linkType ? "_to" : "_from";
                    const invertedAttrName = "in" === linkType ? "_from" : "_to";
                    layout.links.map((link => link[attrName]._name === nodeName)).forEach(((connected, idx) => {
                        connected && result.push({
                            index: idx,
                            weight: layout.links[idx]._weight,
                            node: layout.links[idx][invertedAttrName]._name
                        })
                    }));
                    return result
                }
                const dxSankey = _m_base_widget.default.inherit({
                    _rootClass: "dxs-sankey",
                    _rootClassPrefix: "dxs",
                    _proxyData: [],
                    _optionChangesMap: {
                        dataSource: "DATA_SOURCE",
                        sortData: "DATA_SOURCE",
                        alignment: "DATA_SOURCE",
                        node: "BUILD_LAYOUT",
                        label: "LABELS",
                        link: "BUILD_LAYOUT",
                        palette: "BUILD_LAYOUT",
                        paletteExtensionMode: "BUILD_LAYOUT"
                    },
                    _themeDependentChanges: ["BUILD_LAYOUT"],
                    _getDefaultSize: () => ({
                        width: 400,
                        height: 400
                    }),
                    _themeSection: "sankey",
                    _fontFields: ["label.font"],
                    _optionChangesOrder: ["DATA_SOURCE"],
                    _initialChanges: ["DATA_SOURCE"],
                    _initCore() {
                        this._groupLinks = this._renderer.g().append(this._renderer.root);
                        this._groupNodes = this._renderer.g().append(this._renderer.root);
                        this._groupLabels = this._renderer.g().attr({
                            class: `${this._rootClassPrefix}-labels`
                        }).append(this._renderer.root);
                        this._drawLabels = true;
                        this._nodes = [];
                        this._links = [];
                        this._gradients = []
                    },
                    _disposeCore: _common.noop,
                    _applySize(rect) {
                        this._rect = rect.slice();
                        const adaptiveLayout = this._getOption("adaptiveLayout");
                        if (adaptiveLayout.keepLabels || this._rect[2] - this._rect[0] > adaptiveLayout.width) {
                            this._drawLabels = true
                        } else {
                            this._drawLabels = false
                        }
                        this._change(["BUILD_LAYOUT"]);
                        return this._rect
                    },
                    _eventsMap: {
                        onNodeHoverChanged: {
                            name: "nodeHoverChanged"
                        },
                        onLinkHoverChanged: {
                            name: "linkHoverChanged"
                        }
                    },
                    _customChangesOrder: ["BUILD_LAYOUT", "NODES_DRAW", "LINKS_DRAW", "LABELS", "DRAWN"],
                    _dataSourceChangedHandler() {
                        this._requestChange(["BUILD_LAYOUT"])
                    },
                    _change_DRAWN() {
                        this._drawn()
                    },
                    _change_DATA_SOURCE() {
                        this._change(["DRAWN"]);
                        this._updateDataSource()
                    },
                    _change_LABELS() {
                        this._applyLabelsAppearance()
                    },
                    _change_BUILD_LAYOUT() {
                        this._groupNodes.clear();
                        this._groupLinks.clear();
                        this._groupLabels.clear();
                        this._buildLayout()
                    },
                    _change_NODES_DRAW() {
                        const that = this;
                        const nodes = that._nodes;
                        nodes.forEach(((node, index) => {
                            const element = that._renderer.rect().attr(node.rect).append(that._groupNodes);
                            node.element = element
                        }));
                        this._applyNodesAppearance()
                    },
                    _change_LINKS_DRAW() {
                        const that = this;
                        const links = that._links;
                        links.forEach(((link, index) => {
                            const group = that._renderer.g().attr({
                                class: "link",
                                "data-link-idx": index
                            }).append(that._groupLinks);
                            link.overlayElement = that._renderer.path([], "area").attr({
                                d: link.d
                            }).append(group);
                            link.element = that._renderer.path([], "area").attr({
                                d: link.d
                            }).append(group)
                        }));
                        this._applyLinksAppearance()
                    },
                    _suspend() {
                        if (!this._applyingChanges) {
                            this._suspendChanges()
                        }
                    },
                    _resume() {
                        if (!this._applyingChanges) {
                            this._resumeChanges()
                        }
                    },
                    _showTooltip: _common.noop,
                    hideTooltip: _common.noop,
                    clearHover() {
                        this._suspend();
                        this._nodes.forEach((node => {
                            node.isHovered() && node.hover(false)
                        }));
                        this._links.forEach((link => {
                            link.isHovered() && link.hover(false);
                            link.isAdjacentNodeHovered() && link.adjacentNodeHover(false)
                        }));
                        this._resume()
                    },
                    _applyNodesAppearance() {
                        this._nodes.forEach((node => {
                            const state = node.getState();
                            node.element.smartAttr(node.states[state])
                        }))
                    },
                    _applyLinksAppearance() {
                        this._links.forEach((link => {
                            const state = link.getState();
                            link.element.smartAttr(link.states[state]);
                            link.overlayElement.smartAttr(link.overlayStates[state])
                        }))
                    },
                    _hitTestTargets(x, y) {
                        const that = this;
                        let data;
                        this._proxyData.some((callback => {
                            data = callback.call(that, x, y);
                            if (data) {
                                return true
                            }
                        }));
                        return data
                    },
                    _getData() {
                        const that = this;
                        const data = that._dataSourceItems() || [];
                        const sourceField = that._getOption("sourceField", true);
                        const targetField = that._getOption("targetField", true);
                        const weightField = that._getOption("weightField", true);
                        const processedData = [];
                        data.forEach((item => {
                            const hasItemOwnProperty = Object.prototype.hasOwnProperty.bind(item);
                            if (!hasItemOwnProperty(sourceField)) {
                                that._incidentOccurred("E2007", sourceField)
                            } else if (!hasItemOwnProperty(targetField)) {
                                that._incidentOccurred("E2007", targetField)
                            } else if (!hasItemOwnProperty(weightField)) {
                                that._incidentOccurred("E2007", weightField)
                            } else if (!(0, _type.isString)(item[sourceField])) {
                                that._incidentOccurred("E2008", sourceField)
                            } else if (!(0, _type.isString)(item[targetField])) {
                                that._incidentOccurred("E2008", targetField)
                            } else if (!(0, _type.isNumeric)(item[weightField]) || item[weightField] <= 0) {
                                that._incidentOccurred("E2009", weightField)
                            } else {
                                processedData.push([item[sourceField], item[targetField], item[weightField]])
                            }
                        }));
                        return processedData
                    },
                    _buildLayout() {
                        const that = this;
                        const data = that._getData();
                        const availableRect = this._rect;
                        const nodeOptions = that._getOption("node");
                        const sortData = that._getOption("sortData");
                        const layoutBuilder = that._getOption("layoutBuilder", true) || _layout.layout;
                        const rect = {
                            x: availableRect[0],
                            y: availableRect[1],
                            width: availableRect[2] - availableRect[0],
                            height: availableRect[3] - availableRect[1]
                        };
                        const layout = layoutBuilder.computeLayout(data, sortData, {
                            availableRect: rect,
                            nodePadding: nodeOptions.padding,
                            nodeWidth: nodeOptions.width,
                            nodeAlign: that._getOption("alignment", true)
                        }, that._incidentOccurred);
                        that._layoutMap = layout;
                        if (!Object.prototype.hasOwnProperty.call(layout, "error")) {
                            const nodeColors = {};
                            let nodeIdx = 0;
                            const linkOptions = that._getOption("link");
                            const totalNodesNum = layout.nodes.map((item => item.length)).reduce(((previousValue, currentValue) => previousValue + currentValue), 0);
                            const palette = that._themeManager.createPalette(that._getOption("palette", true), {
                                useHighlight: true,
                                extensionMode: that._getOption("paletteExtensionMode", true),
                                count: totalNodesNum
                            });
                            that._nodes = [];
                            that._links = [];
                            that._gradients.forEach((gradient => {
                                gradient.dispose()
                            }));
                            that._gradients = [];
                            that._shadowFilter && that._shadowFilter.dispose();
                            layout.nodes.forEach((cascadeNodes => {
                                cascadeNodes.forEach((node => {
                                    const color = nodeOptions.color || palette.getNextColor();
                                    const nodeItem = new _node_item.default(that, {
                                        id: nodeIdx,
                                        color: color,
                                        rect: node,
                                        options: nodeOptions,
                                        linksIn: getConnectedLinks(layout, node._name, "in"),
                                        linksOut: getConnectedLinks(layout, node._name, "out")
                                    });
                                    that._nodes.push(nodeItem);
                                    nodeIdx++;
                                    nodeColors[node._name] = color
                                }))
                            }));
                            layout.links.forEach((link => {
                                let gradient = null;
                                if (linkOptions.colorMode === _constants.COLOR_MODE_GRADIENT) {
                                    gradient = that._renderer.linearGradient([{
                                        offset: "0%",
                                        "stop-color": nodeColors[link._from._name]
                                    }, {
                                        offset: "100%",
                                        "stop-color": nodeColors[link._to._name]
                                    }]);
                                    this._gradients.push(gradient)
                                }
                                let color = linkOptions.color;
                                if (linkOptions.colorMode === _constants.COLOR_MODE_SOURCE) {
                                    color = nodeColors[link._from._name]
                                } else if (linkOptions.colorMode === _constants.COLOR_MODE_TARGET) {
                                    color = nodeColors[link._to._name]
                                }
                                const linkItem = new _link_item.default(that, {
                                    d: link.d,
                                    boundingRect: link._boundingRect,
                                    color: color,
                                    options: linkOptions,
                                    connection: {
                                        source: link._from._name,
                                        target: link._to._name,
                                        weight: link._weight
                                    },
                                    gradient: gradient
                                });
                                that._links.push(linkItem)
                            }));
                            that._renderer.initDefsElements();
                            that._change(["NODES_DRAW", "LINKS_DRAW", "LABELS"])
                        }
                        that._change(["DRAWN"])
                    },
                    _applyLabelsAppearance() {
                        const that = this;
                        const labelOptions = that._getOption("label");
                        const availableWidth = that._rect[2] - that._rect[0];
                        const nodeOptions = that._getOption("node");
                        that._shadowFilter = that._renderer.shadowFilter("-50%", "-50%", "200%", "200%").attr(labelOptions.shadow);
                        that._groupLabels.clear();
                        if (that._drawLabels && labelOptions.visible) {
                            const availableLabelWidth = (availableWidth - (nodeOptions.width + labelOptions.horizontalOffset) - that._layoutMap.cascades.length * nodeOptions.width) / (that._layoutMap.cascades.length - 1) - labelOptions.horizontalOffset;
                            that._nodes.forEach((node => {
                                that._createLabel(node, labelOptions, that._shadowFilter.id);
                                ! function(node, labelOptions, availableLabelWidth, rect) {
                                    if (node._label.getBBox().width > availableLabelWidth) {
                                        node.labelText.applyEllipsis(availableLabelWidth)
                                    }
                                    const bBox = node._label.getBBox();
                                    const verticalOffset = labelOptions.verticalOffset;
                                    const horizontalOffset = labelOptions.horizontalOffset;
                                    let labelOffsetY = Math.round(node.rect.y + node.rect.height / 2 - bBox.y - bBox.height / 2) + verticalOffset;
                                    let labelOffsetX = node.rect.x + horizontalOffset + node.rect.width - bBox.x;
                                    if (labelOffsetX + bBox.width >= rect[2] - rect[0]) {
                                        labelOffsetX = node.rect.x - horizontalOffset - bBox.x - bBox.width
                                    }
                                    if (labelOffsetY >= rect[3]) {
                                        labelOffsetY = rect[3]
                                    }
                                    if (labelOffsetY - bBox.height < rect[1]) {
                                        labelOffsetY = node.rect.y - bBox.y + verticalOffset
                                    }
                                    node.labelText.attr({
                                        translateX: labelOffsetX,
                                        translateY: labelOffsetY
                                    })
                                }(node, labelOptions, availableLabelWidth, that._rect)
                            }));
                            if ("none" !== labelOptions.overlappingBehavior) {
                                that._nodes.forEach((thisNode => {
                                    const thisBox = thisNode._label.getBBox();
                                    that._nodes.forEach((otherNode => {
                                        const otherBox = otherNode._label.getBBox();
                                        if (thisNode.id !== otherNode.id && _layout.layout.overlap(thisBox, otherBox)) {
                                            if ("ellipsis" === labelOptions.overlappingBehavior) {
                                                thisNode.labelText.applyEllipsis(otherBox.x - thisBox.x)
                                            } else if ("hide" === labelOptions.overlappingBehavior) {
                                                thisNode.labelText.remove()
                                            }
                                        }
                                    }))
                                }))
                            }
                        }
                    },
                    _createLabel(node, labelOptions, filter) {
                        const textData = labelOptions.customizeText(node);
                        const settings = node.getLabelAttributes(labelOptions, filter);
                        if (textData) {
                            node._label = this._renderer.g().append(this._groupLabels);
                            node.labelText = this._renderer.text(textData).attr(settings.attr).css(settings.css);
                            node.labelText.append(node._label)
                        }
                    },
                    _getMinSize() {
                        const adaptiveLayout = this._getOption("adaptiveLayout");
                        return [adaptiveLayout.width, adaptiveLayout.height]
                    },
                    getAllNodes() {
                        return this._nodes.slice()
                    },
                    getAllLinks() {
                        return this._links.slice()
                    }
                });
                (0, _component_registrator.default)("dxSankey", dxSankey);
                exports.default = dxSankey;
                dxSankey.addPlugin(_data_source.plugin)
            },
        4866:
            /*!**********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/themes.js ***!
              \**********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.addCacheItem = function(target) {
                    const cacheUid = ++nextCacheUid;
                    target._cache = cacheUid;
                    widgetsCache[cacheUid] = target
                };
                exports.currentTheme = currentTheme;
                exports.getTheme = getTheme;
                exports.refreshTheme = function() {
                    Object.keys(widgetsCache).forEach((key => {
                        widgetsCache[key].refresh()
                    }));
                    return this
                };
                exports.registerTheme = registerTheme;
                exports.registerThemeSchemeAlias = function(from, to) {
                    themesSchemeMapping[from] = to
                };
                exports.removeCacheItem = function(target) {
                    delete widgetsCache[target._cache]
                };
                var _extend2 = __webpack_require__( /*! ../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../core/utils/type */ 11528);
                var _themes = __webpack_require__( /*! ../../ui/themes */ 52071);
                var _index = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/fluent/index */ 12638));
                var _carmine = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/carmine */ 58208));
                var _contrast = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/contrast */ 2611));
                var _dark = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/dark */ 52541));
                var _darkmoon = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/darkmoon */ 9940));
                var _darkviolet = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/darkviolet */ 26374));
                var _greenmist = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/greenmist */ 29431));
                var _index2 = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/light/index */ 4702));
                var _softblue = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/generic/softblue */ 56829));
                var _index3 = _interopRequireDefault(__webpack_require__( /*! ../viz/core/themes/material/index */ 55073));
                var _utils = __webpack_require__( /*! ../viz/core/utils */ 98013);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const themes = {};
                const themesMapping = {};
                const themesSchemeMapping = {};
                const _extend = _extend2.extend;
                let currentThemeName = null;
                let defaultTheme;
                let nextCacheUid = 0;
                const widgetsCache = {};

                function getTheme(themeName) {
                    const name = (0, _utils.normalizeEnum)(themeName);
                    return themes[name] || themes[themesMapping[name] || currentTheme()]
                }

                function findThemeNameByName(name, scheme) {
                    const fullThemeKey = `${name}.${scheme}`;
                    return themesMapping[fullThemeKey] || themesSchemeMapping[fullThemeKey] || themesMapping[name]
                }

                function currentTheme(themeName, colorScheme) {
                    if (!arguments.length) {
                        return currentThemeName || findThemeNameByName((0, _themes.current)()) || defaultTheme
                    }
                    const scheme = (0, _utils.normalizeEnum)(colorScheme);
                    currentThemeName = (null !== themeName && void 0 !== themeName && themeName.platform ? function(platform, version, scheme) {
                        return findThemeNameByName(platform + version, scheme) || findThemeNameByName(platform, scheme)
                    }((0, _utils.normalizeEnum)(themeName.platform), themeName.version, scheme) : findThemeNameByName((0, _utils.normalizeEnum)(themeName), scheme)) || currentThemeName;
                    return this
                }

                function registerTheme(theme, baseThemeName) {
                    const themeName = (0, _utils.normalizeEnum)(theme && theme.name);
                    if (themeName) {
                        theme.isDefault && (defaultTheme = themeName);
                        ! function(themeName, targetThemeName) {
                            const themeInfo = function(themeName, splitter) {
                                const k = themeName.indexOf(splitter);
                                return k > 0 ? {
                                    name: themeName.substring(0, k),
                                    scheme: themeName.substring(k + 1)
                                } : null
                            }(themeName, ".") || {
                                name: themeName
                            };
                            const name = themeInfo.name;
                            const scheme = themeInfo.scheme;
                            if (scheme) {
                                const fullThemeKey = `${name}.${scheme}`;
                                themesMapping[name] = themesMapping[name] || targetThemeName;
                                themesMapping[fullThemeKey] = targetThemeName
                            } else {
                                themesMapping[name] = targetThemeName
                            }
                        }(themeName, themeName);
                        themes[themeName] = _extend(true, {}, getTheme(baseThemeName), function(theme) {
                            theme = _extend(true, {
                                loadingIndicator: {
                                    font: {}
                                },
                                export: {
                                    font: {}
                                },
                                legend: {
                                    font: {},
                                    border: {}
                                },
                                title: {
                                    font: {}
                                },
                                tooltip: {
                                    font: {}
                                },
                                "chart:common": {},
                                "chart:common:axis": {
                                    grid: {},
                                    minorGrid: {},
                                    tick: {},
                                    minorTick: {},
                                    title: {
                                        font: {}
                                    },
                                    label: {
                                        font: {}
                                    }
                                },
                                "chart:common:annotation": {
                                    font: {},
                                    border: {}
                                },
                                chart: {
                                    commonSeriesSettings: {
                                        candlestick: {}
                                    }
                                },
                                pie: {},
                                polar: {},
                                gauge: {
                                    scale: {
                                        tick: {},
                                        minorTick: {},
                                        label: {
                                            font: {}
                                        }
                                    }
                                },
                                barGauge: {},
                                funnel: {},
                                sankey: {},
                                map: {
                                    background: {}
                                },
                                treeMap: {
                                    tile: {
                                        selectionStyle: {
                                            border: {}
                                        }
                                    },
                                    group: {
                                        border: {},
                                        selectionStyle: {
                                            border: {}
                                        },
                                        label: {
                                            font: {}
                                        }
                                    }
                                },
                                rangeSelector: {
                                    scale: {
                                        tick: {},
                                        minorTick: {},
                                        label: {
                                            font: {}
                                        }
                                    },
                                    chart: {}
                                },
                                sparkline: {},
                                bullet: {}
                            }, theme);
                            mergeScalar(theme.loadingIndicator, "backgroundColor", theme);
                            mergeScalar(theme.chart.commonSeriesSettings.candlestick, "innerColor", null, theme.backgroundColor);
                            mergeScalar(theme.map.background, "color", null, theme.backgroundColor);
                            mergeScalar(theme.title.font, "color", null, theme.primaryTitleColor);
                            mergeObject(theme.title, "subtitle", null, theme.title);
                            mergeScalar(theme.legend.font, "color", null, theme.secondaryTitleColor);
                            mergeScalar(theme.legend.border, "color", null, theme.gridColor);
                            ! function(theme) {
                                const commonAxisSettings = theme["chart:common:axis"];
                                const colorFieldName = "color";
                                [commonAxisSettings.grid, commonAxisSettings.minorGrid].forEach((obj => {
                                    mergeScalar(obj, colorFieldName, null, theme.gridColor)
                                }));
                                [commonAxisSettings, commonAxisSettings.tick, commonAxisSettings.minorTick, commonAxisSettings.label.font].forEach((obj => {
                                    mergeScalar(obj, colorFieldName, null, theme.axisColor)
                                }));
                                mergeScalar(commonAxisSettings.title.font, colorFieldName, null, theme.secondaryTitleColor);
                                mergeScalar(theme.gauge.scale.label.font, colorFieldName, null, theme.axisColor);
                                mergeScalar(theme.gauge.scale.tick, colorFieldName, null, theme.backgroundColor);
                                mergeScalar(theme.gauge.scale.minorTick, colorFieldName, null, theme.backgroundColor);
                                mergeScalar(theme.rangeSelector.scale.label.font, colorFieldName, null, theme.axisColor)
                            }(theme);
                            ["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sparkline", "bullet", "sankey"].forEach((section => {
                                mergeScalar(theme[section], "redrawOnResize", theme);
                                mergeScalar(theme[section], "containerBackgroundColor", null, theme.backgroundColor);
                                mergeObject(theme[section], "tooltip", theme);
                                mergeObject(theme[section], "export", theme)
                            }));
                            ["chart", "pie", "polar", "gauge", "barGauge", "map", "treeMap", "funnel", "rangeSelector", "sankey"].forEach((section => {
                                mergeObject(theme[section], "loadingIndicator", theme);
                                mergeObject(theme[section], "legend", theme);
                                mergeObject(theme[section], "title", theme)
                            }));
                            ["chart", "pie", "polar"].forEach((section => {
                                mergeObject(theme, section, null, theme["chart:common"])
                            }));
                            ["chart", "polar"].forEach((section => {
                                theme[section] = theme[section] || {};
                                mergeObject(theme[section], "commonAxisSettings", null, theme["chart:common:axis"])
                            }));
                            ["chart", "polar", "map", "pie"].forEach((section => {
                                theme[section] = theme[section] || {};
                                mergeObject(theme[section], "commonAnnotationSettings", null, theme["chart:common:annotation"])
                            }));
                            mergeObject(theme.rangeSelector.chart, "commonSeriesSettings", theme.chart);
                            mergeObject(theme.rangeSelector.chart, "dataPrepareSettings", theme.chart);
                            mergeScalar(theme.treeMap.group.border, "color", null, theme.gridColor);
                            mergeScalar(theme.treeMap.tile.selectionStyle.border, "color", null, theme.primaryTitleColor);
                            mergeScalar(theme.treeMap.group.selectionStyle.border, "color", null, theme.primaryTitleColor);
                            mergeScalar(theme.map.legend, "backgroundColor", theme);
                            ! function(theme) {
                                const map = theme.map;
                                ["area", "line", "marker"].forEach((section => {
                                    mergeObject(map, `layer:${section}`, null, map.layer)
                                }));
                                ["dot", "bubble", "pie", "image"].forEach((section => {
                                    mergeObject(map, `layer:marker:${section}`, null, map["layer:marker"])
                                }))
                            }(theme);
                            return theme
                        }(theme))
                    }
                }

                function mergeScalar(target, field, source, sourceValue) {
                    const _value = (null === source || void 0 === source ? void 0 : source[field]) ?? sourceValue;
                    if (void 0 !== _value && void 0 === target[field]) {
                        target[field] = _value
                    }
                }

                function mergeObject(target, field, source, sourceValue) {
                    const _value = (null === source || void 0 === source ? void 0 : source[field]) ?? sourceValue;
                    if (void 0 !== _value) {
                        target[field] = _extend(true, {}, _value, target[field])
                    }
                }
                if ((0, _type.isEmptyObject)(themes) && (0, _type.isEmptyObject)(themesMapping) && !defaultTheme) {
                    [].concat(_index2.default, _carmine.default, _dark.default, _contrast.default, _darkmoon.default, _darkviolet.default, _greenmist.default, _softblue.default, _index3.default, _index.default).forEach((t => {
                        registerTheme(t.theme, t.baseThemeName)
                    }))
                }
            },
        5028:
            /*!************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/axes/datetime_breaks.js ***!
              \************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.generateDateBreaks = function(min, max, workWeek, singleWorkdays, holidays) {
                    const weekendDayIndices = function(workDays) {
                        const indices = (workdays = workDays, days.filter((day => !workdays.some((workDay => workDay === day)))));
                        var workdays;
                        if (indices.length < 7) {
                            while (getNextDayIndex(indices[indices.length - 1]) === indices[0]) {
                                indices.unshift(indices.pop())
                            }
                        }
                        return indices
                    }(workWeek);
                    const breaks = function(min, max, weekendDayIndices) {
                        let day = min.getDate();
                        const breaks = [];
                        const weekends = weekendDayIndices.reduce(((obj, day) => {
                            let currentWeekEnd = obj[1];
                            if (void 0 === currentWeekEnd.start) {
                                currentWeekEnd = {
                                    start: day,
                                    end: getNextDayIndex(day)
                                };
                                obj[0].push(currentWeekEnd);
                                return [obj[0], currentWeekEnd]
                            }
                            if (currentWeekEnd.end === day) {
                                currentWeekEnd.end = getNextDayIndex(day);
                                return obj
                            }
                            currentWeekEnd = {
                                start: day,
                                end: getNextDayIndex(day)
                            };
                            obj[0].push(currentWeekEnd);
                            return [obj[0], currentWeekEnd]
                        }), [
                            [], {}
                        ]);
                        weekends[0].forEach((weekend => {
                            let currentDate = new Date(min);
                            currentDate = _date.default.trimTime(currentDate);
                            while (currentDate < max) {
                                day = currentDate.getDay();
                                const date = currentDate.getDate();
                                if (dayBetweenWeekend(weekend, day)) {
                                    const from = new Date(currentDate);
                                    currentDate.setDate(date + getDaysDistance(day, weekend.end));
                                    const to = new Date(currentDate);
                                    breaks.push({
                                        from: from,
                                        to: to
                                    })
                                }
                                currentDate.setDate(currentDate.getDate() + 1)
                            }
                        }));
                        return breaks
                    }(min, max, weekendDayIndices);
                    breaks.push.apply(breaks, function(min, max, holidays, weekendDayIndices) {
                        let day;
                        const dayInWeekend = function(dayIndex) {
                            return dayIndex === day
                        };
                        const adjustedMin = _date.default.trimTime(min);
                        const adjustedMax = _date.default.trimTime(max);
                        adjustedMax.setDate(max.getDate() + 1);
                        return holidays.reduce(((breaks, holiday) => {
                            let holidayStart;
                            let holidayEnd;
                            holiday = new Date(holiday);
                            day = holiday.getDay();
                            if (!weekendDayIndices.some(dayInWeekend) && holiday >= adjustedMin && holiday <= adjustedMax) {
                                holidayStart = _date.default.trimTime(holiday);
                                holidayEnd = new Date(holidayStart);
                                holidayEnd.setDate(holidayStart.getDate() + 1);
                                breaks.push({
                                    from: holidayStart,
                                    to: holidayEnd
                                })
                            }
                            return breaks
                        }), [])
                    }(min, max, holidays || [], weekendDayIndices));
                    return function(breaks) {
                        return breaks.map((b => ({
                            from: b.from,
                            to: b.to,
                            gapSize: _date.default.convertMillisecondsToDateUnits(b.to - b.from)
                        })))
                    }(function(breaks, exactWorkDays) {
                        const result = breaks.slice();
                        let i;
                        const processWorkDay = function(workday) {
                            workday = _date.default.trimTime(new Date(workday));
                            if (result[i].from <= workday && result[i].to > workday) {
                                const separatedBreak = function(scaleBreak, day) {
                                    const result = [];
                                    const dayEnd = new Date(day);
                                    dayEnd.setDate(day.getDate() + 1);
                                    if (day > scaleBreak.from) {
                                        result.push({
                                            from: scaleBreak.from,
                                            to: day
                                        })
                                    }
                                    if (dayEnd < scaleBreak.to) {
                                        result.push({
                                            from: dayEnd,
                                            to: scaleBreak.to
                                        })
                                    }
                                    return result
                                }(result[i], workday);
                                if (2 === separatedBreak.length) {
                                    result.splice(i, 1, separatedBreak[0], separatedBreak[1])
                                } else if (1 === separatedBreak.length) {
                                    result.splice(i, 1, separatedBreak[0])
                                } else {
                                    result.splice(i, 1)
                                }
                            }
                        };
                        for (i = 0; i < result.length; i++) {
                            exactWorkDays.forEach(processWorkDay)
                        }
                        return result
                    }(breaks, singleWorkdays || []))
                };
                var _date = (e = __webpack_require__( /*! ../../../core/utils/date */ 41380), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                const days = [0, 1, 2, 3, 4, 5, 6];

                function getNextDayIndex(dayIndex) {
                    return (dayIndex + 1) % 7
                }

                function dayBetweenWeekend(weekend, day) {
                    let {
                        start: start
                    } = weekend;
                    const {
                        end: end
                    } = weekend;
                    while (start !== end) {
                        if (start === day) {
                            return true
                        }
                        start = getNextDayIndex(start)
                    }
                    return false
                }

                function getDaysDistance(day, end) {
                    let length = 0;
                    while (day !== end) {
                        day = getNextDayIndex(day);
                        length++
                    }
                    return length
                }
            },
        5037:
            /*!**********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/axes/constant_line.js ***!
              \**********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = function(axis, options) {
                    const labelOptions = options.label || {};
                    const labelPosition = labelOptions.position || "inside";
                    let parsedValue;
                    let valueIsParsed = false;
                    let lastStoredCoordinates;
                    axis._checkAlignmentConstantLineLabels(labelOptions);
                    let storedCoord;
                    return {
                        options: options,
                        labelOptions: labelOptions,
                        labelPosition: labelPosition,
                        label: null,
                        line: null,
                        getParsedValue() {
                            if (!valueIsParsed) {
                                parsedValue = axis.validateUnit(options.value, "E2105", "constantLine");
                                valueIsParsed = true;
                                return parsedValue
                            }
                            return parsedValue
                        },
                        draw() {
                            if (!(0, _type.isDefined)(options.value) || axis._translator.getBusinessRange().isEmpty()) {
                                return this
                            }
                            const canvas = axis._getCanvasStartEnd();
                            const parsedValue = this.getParsedValue();
                            this.coord = axis._getConstantLinePos(parsedValue, canvas.start, canvas.end);
                            const rootGroup = options.displayBehindSeries ? axis._axisConstantLineGroups.under : axis._axisConstantLineGroups.above;
                            let group = rootGroup[labelPosition];
                            if (!group) {
                                const side = axis._isHorizontal ? labelOptions.verticalAlignment : labelOptions.horizontalAlignment;
                                group = rootGroup[side]
                            }
                            if (!(0, _type.isDefined)(this.coord)) {
                                return this
                            }
                            const path = axis._createConstantLine(this.coord, {
                                stroke: options.color,
                                "stroke-width": options.width,
                                dashStyle: options.dashStyle
                            });
                            this.line = path.append(rootGroup.inside);
                            this.label = labelOptions.visible ? axis._drawConstantLineLabels(parsedValue, labelOptions, this.coord, group) : null;
                            this.updatePosition();
                            return this
                        },
                        getContentContainer() {
                            return this.label
                        },
                        removeLabel() {
                            this.label && this.label.remove()
                        },
                        updatePosition(animate) {
                            const canvas = axis._getCanvasStartEnd();
                            const coord = axis._getConstantLinePos(this.getParsedValue(), canvas.start, canvas.end);
                            if (!(0, _type.isDefined)(coord)) {
                                return
                            }
                            this.coord = coord;
                            if (animate && storedCoord) {
                                this.label && this.label.attr(axis._getConstantLineLabelsCoords(storedCoord, this.labelOptions));
                                this.line && this.line.attr(axis._getConstantLineGraphicAttributes(storedCoord));
                                this.label && this.label.animate(axis._getConstantLineLabelsCoords(this.coord, this.labelOptions));
                                this.line && this.line.animate(axis._getConstantLineGraphicAttributes(this.coord))
                            } else {
                                this.label && this.label.attr(axis._getConstantLineLabelsCoords(this.coord, this.labelOptions));
                                this.line && this.line.attr(axis._getConstantLineGraphicAttributes(this.coord));
                                axis._rotateConstantLine(this.line, this.coord)
                            }
                        },
                        saveCoords() {
                            lastStoredCoordinates = storedCoord;
                            storedCoord = this.coord
                        },
                        resetCoordinates() {
                            storedCoord = lastStoredCoordinates
                        }
                    }
                };
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528)
            },
        5285:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/collection/m_data_controller.js ***!
              \*******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _deferred = __webpack_require__( /*! ../../../core/utils/deferred */ 87739);
                const DataControllerMock = {
                    load: () => (0, _deferred.Deferred)().reject(),
                    loadSingle: () => (0, _deferred.Deferred)().reject(),
                    loadFromStore: () => (0, _deferred.Deferred)().reject(),
                    loadNextPage: () => (0, _deferred.Deferred)().reject(),
                    loadOptions: _common.noop,
                    userData: _common.noop,
                    cancel: _common.noop,
                    cancelAll: _common.noop,
                    filter: _common.noop,
                    addSearchFilter: _common.noop,
                    group: _common.noop,
                    paginate: _common.noop,
                    pageSize: _common.noop,
                    pageIndex: _common.noop,
                    resetDataSourcePageIndex: _common.noop,
                    totalCount: _common.noop,
                    isLastPage: _common.noop,
                    isLoading: _common.noop,
                    isLoaded: _common.noop,
                    searchValue: _common.noop,
                    searchOperation: _common.noop,
                    searchExpr: _common.noop,
                    select: _common.noop,
                    key: _common.noop,
                    keyOf: _common.noop,
                    store: _common.noop,
                    items: _common.noop,
                    applyMapFunction: _common.noop,
                    getDataSource: _common.noop,
                    reload: _common.noop,
                    on: _common.noop,
                    off: _common.noop
                };
                exports.default = class {
                    constructor(dataSource) {
                        if (!dataSource) {
                            return DataControllerMock
                        }
                        this._dataSource = dataSource
                    }
                    load() {
                        return this._dataSource.load()
                    }
                    loadSingle(propName, propValue) {
                        if (arguments.length < 2) {
                            propValue = propName;
                            propName = this.key()
                        }
                        return this._dataSource.loadSingle(propName, propValue)
                    }
                    loadFromStore(loadOptions) {
                        return this.store().load(loadOptions)
                    }
                    loadNextPage() {
                        this.pageIndex(1 + this.pageIndex());
                        return this.load()
                    }
                    loadOptions() {
                        return this._dataSource.loadOptions()
                    }
                    userData() {
                        return this._dataSource._userData
                    }
                    cancel(operationId) {
                        this._dataSource.cancel(operationId)
                    }
                    cancelAll() {
                        this._dataSource.cancelAll()
                    }
                    filter(filter) {
                        return this._dataSource.filter(filter)
                    }
                    addSearchFilter(storeLoadOptions) {
                        this._dataSource._addSearchFilter(storeLoadOptions)
                    }
                    group(group) {
                        return this._dataSource.group(group)
                    }
                    paginate() {
                        return this._dataSource.paginate()
                    }
                    pageSize() {
                        return this._dataSource._pageSize
                    }
                    pageIndex(pageIndex) {
                        return this._dataSource.pageIndex(pageIndex)
                    }
                    resetDataSourcePageIndex() {
                        if (this.pageIndex()) {
                            this.pageIndex(0);
                            this.load()
                        }
                    }
                    totalCount() {
                        return this._dataSource.totalCount()
                    }
                    isLastPage() {
                        return this._dataSource.isLastPage() || !this._dataSource._pageSize
                    }
                    isLoading() {
                        return this._dataSource.isLoading()
                    }
                    isLoaded() {
                        return this._dataSource.isLoaded()
                    }
                    searchValue(value) {
                        if (!arguments.length) {
                            return this._dataSource.searchValue()
                        }
                        return this._dataSource.searchValue(value)
                    }
                    searchOperation(operation) {
                        return this._dataSource.searchOperation(operation)
                    }
                    searchExpr(expr) {
                        if (!arguments.length) {
                            return this._dataSource.searchExpr()
                        }
                        return this._dataSource.searchExpr(expr)
                    }
                    select() {
                        return this._dataSource.select(...arguments)
                    }
                    key() {
                        return this._dataSource.key()
                    }
                    keyOf(item) {
                        return this.store().keyOf(item)
                    }
                    store() {
                        return this._dataSource.store()
                    }
                    items() {
                        return this._dataSource.items()
                    }
                    applyMapFunction(data) {
                        return this._dataSource._applyMapFunction(data)
                    }
                    getDataSource() {
                        return this._dataSource || null
                    }
                    reload() {
                        return this._dataSource.reload()
                    }
                    on(event, handler) {
                        this._dataSource.on(event, handler)
                    }
                    off(event, handler) {
                        this._dataSource.off(event, handler)
                    }
                }
            },
        5365:
            /*!***************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/financial_series.js ***!
              \***************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.stock = exports.candlestick = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                var _bar_series = __webpack_require__( /*! ./bar_series */ 48971);
                var _scatter_series = __webpack_require__( /*! ./scatter_series */ 39294);
                const barSeries = _bar_series.chart.bar;
                const stock = exports.stock = (0, _extend2.extend)({}, _scatter_series.chart, {
                    _animate: _common.noop,
                    _applyMarkerClipRect(settings) {
                        settings["clip-path"] = this._forceClipping ? this._paneClipRectID : this._widePaneClipRectID
                    },
                    _updatePointsVisibility: barSeries._updatePointsVisibility,
                    _getOptionsForPoint: barSeries._getOptionsForPoint,
                    _createErrorBarGroup: _common.noop,
                    areErrorBarsVisible: _common.noop,
                    _createGroups: _scatter_series.chart._createGroups,
                    _setMarkerGroupSettings() {
                        const markersGroup = this._markersGroup;
                        const styles = this._createPointStyles(this._getMarkerGroupOptions());
                        const defaultStyle = (0, _extend2.extend)(styles.normal, {
                            class: "default-markers"
                        });
                        const defaultPositiveStyle = (0, _extend2.extend)(styles.positive.normal, {
                            class: "default-positive-markers"
                        });
                        const reductionStyle = (0, _extend2.extend)(styles.reduction.normal, {
                            class: "reduction-markers"
                        });
                        const reductionPositiveStyle = (0, _extend2.extend)(styles.reductionPositive.normal, {
                            class: "reduction-positive-markers"
                        });
                        const markerSettings = {
                            class: "dxc-markers"
                        };
                        this._applyMarkerClipRect(markerSettings);
                        markersGroup.attr(markerSettings);
                        this._createGroup("defaultMarkersGroup", markersGroup, markersGroup, defaultStyle);
                        this._createGroup("reductionMarkersGroup", markersGroup, markersGroup, reductionStyle);
                        this._createGroup("defaultPositiveMarkersGroup", markersGroup, markersGroup, defaultPositiveStyle);
                        this._createGroup("reductionPositiveMarkersGroup", markersGroup, markersGroup, reductionPositiveStyle)
                    },
                    _setGroupsSettings() {
                        _scatter_series.chart._setGroupsSettings.call(this, false)
                    },
                    _getCreatingPointOptions() {
                        const that = this;
                        let defaultPointOptions;
                        let creatingPointOptions = that._predefinedPointOptions;
                        if (!creatingPointOptions) {
                            defaultPointOptions = this._getPointOptions();
                            that._predefinedPointOptions = creatingPointOptions = (0, _extend2.extend)(true, {
                                styles: {}
                            }, defaultPointOptions);
                            creatingPointOptions.styles.normal = creatingPointOptions.styles.positive.normal = creatingPointOptions.styles.reduction.normal = creatingPointOptions.styles.reductionPositive.normal = {
                                "stroke-width": defaultPointOptions.styles && defaultPointOptions.styles.normal && defaultPointOptions.styles.normal["stroke-width"]
                            }
                        }
                        return creatingPointOptions
                    },
                    _checkData(data, skippedFields) {
                        const valueFields = this.getValueFields();
                        return _scatter_series.chart._checkData.call(this, data, skippedFields, {
                            openValue: valueFields[0],
                            highValue: valueFields[1],
                            lowValue: valueFields[2],
                            closeValue: valueFields[3]
                        }) && data.highValue === data.highValue && data.lowValue === data.lowValue
                    },
                    _getPointDataSelector(data, options) {
                        const that = this;
                        let level;
                        const valueFields = that.getValueFields();
                        const argumentField = that.getArgumentField();
                        const openValueField = valueFields[0];
                        const highValueField = valueFields[1];
                        const lowValueField = valueFields[2];
                        const closeValueField = valueFields[3];
                        that.level = that._options.reduction.level;
                        switch ((0, _utils.normalizeEnum)(that.level)) {
                            case "open":
                                level = openValueField;
                                break;
                            case "high":
                                level = highValueField;
                                break;
                            case "low":
                                level = lowValueField;
                                break;
                            default:
                                level = closeValueField;
                                that.level = "close"
                        }
                        let prevLevelValue;
                        return data => {
                            const reductionValue = data[level];
                            let isReduction = false;
                            if ((0, _type.isDefined)(reductionValue)) {
                                if ((0, _type.isDefined)(prevLevelValue)) {
                                    isReduction = reductionValue < prevLevelValue
                                }
                                prevLevelValue = reductionValue
                            }
                            return {
                                argument: data[argumentField],
                                highValue: this._processEmptyValue(data[highValueField]),
                                lowValue: this._processEmptyValue(data[lowValueField]),
                                closeValue: this._processEmptyValue(data[closeValueField]),
                                openValue: this._processEmptyValue(data[openValueField]),
                                reductionValue: reductionValue,
                                tag: data[that.getTagField()],
                                isReduction: isReduction,
                                data: data
                            }
                        }
                    },
                    _parsePointStyle(style, defaultColor, innerColor) {
                        const color = (0, _utils.extractColor)(style.color, true);
                        return {
                            stroke: color || defaultColor,
                            "stroke-width": style.width,
                            fill: color || innerColor
                        }
                    },
                    _getDefaultStyle(options) {
                        const mainPointColor = (0, _utils.extractColor)(options.color, true) || this._options.mainSeriesColor;
                        return {
                            normal: this._parsePointStyle(options, mainPointColor, mainPointColor),
                            hover: this._parsePointStyle(options.hoverStyle, mainPointColor, mainPointColor),
                            selection: this._parsePointStyle(options.selectionStyle, mainPointColor, mainPointColor)
                        }
                    },
                    _getReductionStyle(options) {
                        const reductionColor = options.reduction.color;
                        return {
                            normal: this._parsePointStyle({
                                color: reductionColor,
                                width: options.width,
                                hatching: options.hatching
                            }, reductionColor, reductionColor),
                            hover: this._parsePointStyle(options.hoverStyle, reductionColor, reductionColor),
                            selection: this._parsePointStyle(options.selectionStyle, reductionColor, reductionColor)
                        }
                    },
                    _createPointStyles(pointOptions) {
                        const innerColor = this._options.innerColor;
                        const styles = this._getDefaultStyle(pointOptions);
                        const positiveStyle = (0, _extend2.extend)(true, {}, styles);
                        const reductionStyle = this._getReductionStyle(pointOptions);
                        const reductionPositiveStyle = (0, _extend2.extend)(true, {}, reductionStyle);
                        positiveStyle.normal.fill = positiveStyle.hover.fill = positiveStyle.selection.fill = innerColor;
                        reductionPositiveStyle.normal.fill = reductionPositiveStyle.hover.fill = reductionPositiveStyle.selection.fill = innerColor;
                        styles.positive = positiveStyle;
                        styles.reduction = reductionStyle;
                        styles.reductionPositive = reductionPositiveStyle;
                        styles.labelColor = this._options.mainSeriesColor;
                        return styles
                    },
                    _endUpdateData() {
                        delete this._predefinedPointOptions
                    },
                    _defaultAggregator: "ohlc",
                    _aggregators: {
                        ohlc: (_ref, series) => {
                            let {
                                intervalStart: intervalStart,
                                intervalEnd: intervalEnd,
                                data: data
                            } = _ref;
                            if (!data.length) {
                                return
                            }
                            let result = {};
                            const valueFields = series.getValueFields();
                            const highValueField = valueFields[1];
                            const lowValueField = valueFields[2];
                            result[highValueField] = -1 / 0;
                            result[lowValueField] = 1 / 0;
                            result = data.reduce(((result, item) => {
                                if (null !== item[highValueField]) {
                                    result[highValueField] = Math.max(result[highValueField], item[highValueField])
                                }
                                if (null !== item[lowValueField]) {
                                    result[lowValueField] = Math.min(result[lowValueField], item[lowValueField])
                                }
                                return result
                            }), result);
                            result[valueFields[0]] = data[0][valueFields[0]];
                            result[valueFields[3]] = data[data.length - 1][valueFields[3]];
                            if (!isFinite(result[highValueField])) {
                                result[highValueField] = null
                            }
                            if (!isFinite(result[lowValueField])) {
                                result[lowValueField] = null
                            }
                            result[series.getArgumentField()] = series._getIntervalCenter(intervalStart, intervalEnd);
                            return result
                        }
                    },
                    getValueFields() {
                        const options = this._options;
                        return [options.openValueField || "open", options.highValueField || "high", options.lowValueField || "low", options.closeValueField || "close"]
                    },
                    getArgumentField() {
                        return this._options.argumentField || "date"
                    },
                    _patchMarginOptions(options) {
                        const pointOptions = this._getCreatingPointOptions();
                        const styles = pointOptions.styles;
                        const border = [styles.normal, styles.hover, styles.selection].reduce(((max, style) => Math.max(max, style["stroke-width"])), 0);
                        options.size = 10 + border;
                        options.sizePointNormalState = 10;
                        return options
                    },
                    getSeriesPairCoord(coord, isArgument) {
                        let oppositeCoord = null;
                        const points = this.getVisiblePoints();
                        for (let i = 0; i < points.length; i++) {
                            const p = points[i];
                            let tmpCoord;
                            if (isArgument) {
                                tmpCoord = p.vx === coord ? (p.openY + p.closeY) / 2 : void 0
                            } else {
                                const coords = [Math.min(p.lowY, p.highY), Math.max(p.lowY, p.highY)];
                                tmpCoord = coord >= coords[0] && coord <= coords[1] ? p.vx : void 0
                            }
                            if (this._checkAxisVisibleAreaCoord(!isArgument, tmpCoord)) {
                                oppositeCoord = tmpCoord;
                                break
                            }
                        }
                        return oppositeCoord
                    },
                    usePointsToDefineAutoHiding: () => false
                });
                exports.candlestick = (0, _extend2.extend)({}, stock, {
                    _parsePointStyle(style, defaultColor, innerColor) {
                        const color = (0, _utils.extractColor)(style.color, true) || innerColor;
                        const base = stock._parsePointStyle.call(this, style, defaultColor, color);
                        base.fill = color;
                        base.hatching = style.hatching;
                        return base
                    }
                })
            },
        5388:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/utils/m_version.js ***!
              \********************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.compare = function(x, y, maxLevel) {
                    function normalizeArg(value) {
                        if ("string" === typeof value) {
                            return value.split(".")
                        }
                        if ("number" === typeof value) {
                            return [value]
                        }
                        return value
                    }
                    x = normalizeArg(x);
                    y = normalizeArg(y);
                    let length = Math.max(x.length, y.length);
                    if (isFinite(maxLevel)) {
                        length = Math.min(length, maxLevel)
                    }
                    for (let i = 0; i < length; i++) {
                        const xItem = parseInt(x[i] || 0, 10);
                        const yItem = parseInt(y[i] || 0, 10);
                        if (xItem < yItem) {
                            return -1
                        }
                        if (xItem > yItem) {
                            return 1
                        }
                    }
                    return 0
                }
            },
        5428:
            /*!**************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/runtime/inferno/base_component.js ***!
              \**************************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.InfernoWrapperComponent = exports.InfernoComponent = exports.BaseInfernoComponent = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                var _effect_host = __webpack_require__( /*! ./effect_host */ 23405);
                const areObjectsEqual = (firstObject, secondObject) => {
                    const bothAreObjects = firstObject instanceof Object && secondObject instanceof Object;
                    if (!bothAreObjects) {
                        return firstObject === secondObject
                    }
                    const firstObjectKeys = Object.keys(firstObject);
                    const secondObjectKeys = Object.keys(secondObject);
                    if (firstObjectKeys.length !== secondObjectKeys.length) {
                        return false
                    }
                    const hasDifferentElement = firstObjectKeys.some((key => firstObject[key] !== secondObject[key]));
                    return !hasDifferentElement
                };
                class BaseInfernoComponent extends _inferno.Component {
                    constructor() {
                        super(...arguments);
                        this._pendingContext = this.context
                    }
                    componentWillReceiveProps(_, context) {
                        this._pendingContext = context ?? {}
                    }
                    shouldComponentUpdate(nextProps, nextState) {
                        return !areObjectsEqual(this.props, nextProps) || !areObjectsEqual(this.state, nextState) || !areObjectsEqual(this.context, this._pendingContext)
                    }
                }
                exports.BaseInfernoComponent = BaseInfernoComponent;
                class InfernoComponent extends BaseInfernoComponent {
                    constructor() {
                        super(...arguments);
                        this._effects = []
                    }
                    createEffects() {
                        return []
                    }
                    updateEffects() {}
                    componentWillMount() {
                        _effect_host.InfernoEffectHost.lock()
                    }
                    componentWillUpdate(_nextProps, _nextState, _context) {
                        _effect_host.InfernoEffectHost.lock()
                    }
                    componentDidMount() {
                        _effect_host.InfernoEffectHost.callbacks.push((() => {
                            this._effects = this.createEffects()
                        }));
                        _effect_host.InfernoEffectHost.callEffects()
                    }
                    componentDidUpdate() {
                        _effect_host.InfernoEffectHost.callbacks.push((() => this.updateEffects()));
                        _effect_host.InfernoEffectHost.callEffects()
                    }
                    destroyEffects() {
                        this._effects.forEach((e => e.dispose()))
                    }
                    componentWillUnmount() {
                        this.destroyEffects()
                    }
                }
                exports.InfernoComponent = InfernoComponent;
                exports.InfernoWrapperComponent = class extends InfernoComponent {
                    constructor() {
                        super(...arguments);
                        this.vDomElement = null
                    }
                    vDomUpdateClasses() {
                        var _el$className;
                        const el = this.vDomElement;
                        const currentClasses = null !== (_el$className = el.className) && void 0 !== _el$className && _el$className.length ? el.className.split(" ") : [];
                        const addedClasses = currentClasses.filter((className => !el.dxClasses.previous.includes(className)));
                        const removedClasses = el.dxClasses.previous.filter((className => !currentClasses.includes(className)));
                        addedClasses.forEach((value => {
                            const indexInRemoved = el.dxClasses.removed.indexOf(value);
                            if (indexInRemoved > -1) {
                                el.dxClasses.removed.splice(indexInRemoved, 1)
                            }
                            if (!el.dxClasses.added.includes(value)) {
                                el.dxClasses.added.push(value)
                            }
                        }));
                        removedClasses.forEach((value => {
                            const indexInAdded = el.dxClasses.added.indexOf(value);
                            if (indexInAdded > -1) {
                                el.dxClasses.added.splice(indexInAdded, 1)
                            }
                            if (!el.dxClasses.removed.includes(value)) {
                                el.dxClasses.removed.push(value)
                            }
                        }))
                    }
                    componentDidMount() {
                        var _el$className2;
                        const el = (0, _inferno.findDOMFromVNode)(this.$LI, true);
                        this.vDomElement = el;
                        super.componentDidMount();
                        el.dxClasses = el.dxClasses || {
                            removed: [],
                            added: [],
                            previous: []
                        };
                        el.dxClasses.previous = null !== el && void 0 !== el && null !== (_el$className2 = el.className) && void 0 !== _el$className2 && _el$className2.length ? el.className.split(" ") : []
                    }
                    componentDidUpdate() {
                        super.componentDidUpdate();
                        const el = this.vDomElement;
                        if (null !== el) {
                            var _el$className3;
                            el.dxClasses.added.forEach((className => el.classList.add(className)));
                            el.dxClasses.removed.forEach((className => el.classList.remove(className)));
                            el.dxClasses.previous = null !== (_el$className3 = el.className) && void 0 !== _el$className3 && _el$className3.length ? el.className.split(" ") : []
                        }
                    }
                    shouldComponentUpdate(nextProps, nextState) {
                        const shouldUpdate = super.shouldComponentUpdate(nextProps, nextState);
                        if (shouldUpdate) {
                            this.vDomUpdateClasses()
                        }
                        return shouldUpdate
                    }
                }
            },
        5583:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_errors.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _error = (e = __webpack_require__( /*! ../../core/utils/error */ 67264), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.default = (0, _error.default)({
                    E0001: "Method is not implemented",
                    E0002: "Member name collision: {0}",
                    E0003: "A class must be instantiated using the 'new' keyword",
                    E0004: "The NAME property of the component is not specified",
                    E0005: "Unknown device",
                    E0006: "Unknown endpoint key is requested",
                    E0007: "'Invalidate' method is called outside the update transaction",
                    E0008: "Type of the option name is not appropriate to create an action",
                    E0009: "Component '{0}' has not been initialized for an element",
                    E0010: "Animation configuration with the '{0}' type requires '{1}' configuration as {2}",
                    E0011: "Unknown animation type '{0}'",
                    E0012: "jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",
                    E0013: "KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",
                    E0014: "The 'release' method shouldn't be called for an unlocked Lock object",
                    E0015: "Queued task returned an unexpected result",
                    E0017: "Event namespace is not defined",
                    E0018: "DevExpress.ui.DevExpressPopup widget is required",
                    E0020: "Template engine '{0}' is not supported",
                    E0021: "Unknown theme is set: {0}",
                    E0022: "LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",
                    E0023: "Template name is not specified",
                    E0024: "DevExtreme bundle already included",
                    E0025: "Unexpected argument type",
                    E0100: "Unknown validation type is detected",
                    E0101: "Misconfigured range validation rule is detected",
                    E0102: "Misconfigured comparison validation rule is detected",
                    E0103: "validationCallback of an asynchronous rule should return a jQuery or a native promise",
                    E0110: "Unknown validation group is detected",
                    E0120: "Adapter for a DevExpressValidator component cannot be configured",
                    E0121: "The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",
                    E0122: "AIIntegration: The sendRequest method is missing.",
                    W0000: "'{0}' is deprecated in {1}. {2}",
                    W0001: "{0} - '{1}' option is deprecated in {2}. {3}",
                    W0002: "{0} - '{1}' method is deprecated in {2}. {3}",
                    W0003: "{0} - '{1}' property is deprecated in {2}. {3}",
                    W0004: "Timeout for theme loading is over: {0}",
                    W0005: "'{0}' event is deprecated in {1}. {2}",
                    W0006: "Invalid recurrence rule: '{0}'",
                    W0007: "'{0}' Globalize culture is not defined",
                    W0008: "Invalid view type: {0}",
                    W0009: "Invalid time zone name: '{0}'",
                    W0010: "{0} is deprecated in {1}. {2}",
                    W0011: "Number parsing is invoked while the parser is not defined",
                    W0012: "Date parsing is invoked while the parser is not defined",
                    W0013: "'{0}' file is deprecated in {1}. {2}",
                    W0014: "{0} - '{1}' type is deprecated in {2}. {3}",
                    W0015: "Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",
                    W0016: 'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',
                    W0017: 'Setting the "{0}" property with a function is deprecated since v21.2',
                    W0018: 'Setting the "position" property with a function is deprecated since v21.2',
                    W0019: "DevExtreme: Unable to Locate a Valid License Key.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nIf you are using a 30-day trial version of DevExtreme, you must uninstall all copies of DevExtreme once your 30-day trial period expires. For terms and conditions that govern use of DevExtreme UI components/libraries, please refer to the DevExtreme End User License Agreement: https://js.devexpress.com/EULAs/DevExtremeComplete.\n\nTo use DevExtreme in a commercial project, you must purchase a license. For pricing/licensing options, please visit: https://js.devexpress.com/Buy.\n\nIf you have licensing-related questions or need help with a purchase, please email clientservices@devexpress.com.\n\n",
                    W0020: "DevExtreme: License Key Has Expired.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nA mismatch exists between the license key used and the DevExtreme version referenced in this project.\n\nTo proceed, you can:\n\u2022 use a version of DevExtreme linked to your license key: https://www.devexpress.com/ClientCenter/DownloadManager\n\u2022 renew your DevExpress Subscription: https://www.devexpress.com/buy/renew (once you renew your subscription, you will be entitled to product updates and support service as defined in the DevExtreme End User License Agreement)\n\nIf you have licensing-related questions or need help with a renewal, please email clientservices@devexpress.com.\n\n",
                    W0021: "DevExtreme: License Key Verification Has Failed.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nTo verify your DevExtreme license, make certain to specify a correct key in the GlobalConfig. If you continue to encounter this error, please visit https://www.devexpress.com/ClientCenter/DownloadManager to obtain a valid license key.\n\nIf you have a valid license and this problem persists, please submit a support ticket via the DevExpress Support Center. We will be happy to follow-up: https://supportcenter.devexpress.com/ticket/create.\n\n",
                    W0022: "DevExtreme: Pre-release software. Not suitable for commercial use.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nPre-release software may contain deficiencies and as such, should not be considered for use or integrated in any mission critical application.\n\n",
                    W0023: "DevExtreme: the following 'devextreme' package version does not match versions of other DevExpress products used in this application:\n\n{0}\n\nInteroperability between different versions of the products listed herein cannot be guaranteed.\n\n",
                    W0024: "DevExtreme: Use Your DevExtreme License Key - Not Your DevExpress .NET License Key\n\nInvalid/incorrect license key. You used your DevExpress .NET license key instead of your DevExtreme (React, Angular, Vue, JS) license key. Please copy your DevExtreme license key and try again. \n\nGo to https://www.devexpress.com/ClientCenter/DownloadManager (navigate to the DevExtreme Subscription section) to obtain a valid DevExtreme license key. To validate your license, specify the correct key within GlobalConfig.\n\nFor detailed license/registration information, visit https://js.devexpress.com/Documentation/Licensing/.\n\nIf you have a valid license and the issue persists, submit a support ticket via the DevExpress Support Center. We will be happy to follow-up: https://supportcenter.devexpress.com/ticket/create.\n\n"
                })
            },
        5600:
            /*!**********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/viz/gauges/base_gauge.js ***!
              \**********************************************************************/
            (module, exports, __webpack_require__) => {
                exports.default = void 0;
                var _base_gauge = __webpack_require__( /*! ../../__internal/viz/gauges/base_gauge */ 90678);
                exports.default = _base_gauge.BaseGauge;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        5636:
            /*!********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/double_click.js ***!
              \********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "name", {
                    enumerable: true,
                    get: function() {
                        return _m_dblclick.name
                    }
                });
                var _m_dblclick = __webpack_require__( /*! ../../../__internal/events/m_dblclick */ 36212);
                var _event_registrator = (e = __webpack_require__( /*! ./core/event_registrator */ 15273), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                (0, _event_registrator.default)(_m_dblclick.name, _m_dblclick.dblClick)
            },
        5828:
            /*!************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/core/themes/generic/light/bullet.js ***!
              \************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                exports.default = {
                    bullet: {
                        color: "#e8c267",
                        targetColor: "#666666",
                        targetWidth: 4,
                        showTarget: true,
                        showZeroLevel: true,
                        tooltip: {
                            enabled: true
                        }
                    }
                }
            },
        5842:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/data/query_adapters.js ***!
              \***************************************************************************/
            (module, exports) => {
                exports.default = void 0;
                exports.default = {};
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        5882:
            /*!***********************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/points/candlestick_point.js ***!
              \***********************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _extend2 = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _bar_point = _interopRequireDefault(__webpack_require__( /*! ../../../viz/series/points/bar_point */ 9820));
                var _symbol_point = _interopRequireDefault(__webpack_require__( /*! ../../../viz/series/points/symbol_point */ 8731));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const _math = Math;
                const _abs = _math.abs;
                const _min = _math.min;
                const _max = _math.max;
                const _round = _math.round;
                exports.default = (0, _extend2.extend)({}, _bar_point.default, {
                    _getContinuousPoints(openCoord, closeCoord) {
                        const that = this;
                        const x = that.x;
                        const createPoint = that._options.rotated ? function(x, y) {
                            return [y, x]
                        } : function(x, y) {
                            return [x, y]
                        };
                        const width = that.width;
                        const highCoord = that.highY;
                        const max = _abs(highCoord - openCoord) < _abs(highCoord - closeCoord) ? openCoord : closeCoord;
                        const min = max === closeCoord ? openCoord : closeCoord;
                        let points;
                        if (min === max) {
                            points = [].concat(createPoint(x, that.highY)).concat(createPoint(x, that.lowY)).concat(createPoint(x, that.closeY)).concat(createPoint(x - width / 2, that.closeY)).concat(createPoint(x + width / 2, that.closeY)).concat(createPoint(x, that.closeY))
                        } else {
                            points = [].concat(createPoint(x, that.highY)).concat(createPoint(x, max)).concat(createPoint(x + width / 2, max)).concat(createPoint(x + width / 2, min)).concat(createPoint(x, min)).concat(createPoint(x, that.lowY)).concat(createPoint(x, min)).concat(createPoint(x - width / 2, min)).concat(createPoint(x - width / 2, max)).concat(createPoint(x, max))
                        }
                        return points
                    },
                    _getCrockPoints(y) {
                        const x = this.x;
                        const createPoint = this._options.rotated ? function(x, y) {
                            return [y, x]
                        } : function(x, y) {
                            return [x, y]
                        };
                        return [].concat(createPoint(x, this.highY)).concat(createPoint(x, this.lowY)).concat(createPoint(x, y)).concat(createPoint(x - this.width / 2, y)).concat(createPoint(x + this.width / 2, y)).concat(createPoint(x, y))
                    },
                    _getPoints() {
                        const that = this;
                        let points;
                        const closeCoord = that.closeY;
                        const openCoord = that.openY;
                        if (null !== closeCoord && null !== openCoord) {
                            points = that._getContinuousPoints(openCoord, closeCoord)
                        } else if (openCoord === closeCoord) {
                            points = [that.x, that.highY, that.x, that.lowY]
                        } else {
                            points = that._getCrockPoints(null !== openCoord ? openCoord : closeCoord)
                        }
                        return points
                    },
                    getColor() {
                        return this._isReduction ? this._options.reduction.color : this._styles.normal.stroke || this.series.getColor()
                    },
                    _drawMarkerInGroup(group, attributes, renderer) {
                        this.graphic = renderer.path(this._getPoints(), "area").attr({
                            "stroke-linecap": "square"
                        }).attr(attributes).data({
                            "chart-data-point": this
                        }).sharp().append(group)
                    },
                    _fillStyle() {
                        const that = this;
                        const styles = that._options.styles;
                        if (that._isReduction && that._isPositive) {
                            that._styles = styles.reductionPositive
                        } else if (that._isReduction) {
                            that._styles = styles.reduction
                        } else if (that._isPositive) {
                            that._styles = styles.positive
                        } else {
                            that._styles = styles
                        }
                    },
                    _getMinTrackerWidth() {
                        return 2 + 2 * this._styles.normal["stroke-width"]
                    },
                    correctCoordinates(correctOptions) {
                        const minWidth = this._getMinTrackerWidth();
                        let width = correctOptions.width;
                        width = width < minWidth ? minWidth : width > 10 ? 10 : width;
                        this.width = width + width % 2;
                        this.xCorrection = correctOptions.offset
                    },
                    _getMarkerGroup(group) {
                        let markerGroup;
                        if (this._isReduction && this._isPositive) {
                            markerGroup = group.reductionPositiveMarkersGroup
                        } else if (this._isReduction) {
                            markerGroup = group.reductionMarkersGroup
                        } else if (this._isPositive) {
                            markerGroup = group.defaultPositiveMarkersGroup
                        } else {
                            markerGroup = group.defaultMarkersGroup
                        }
                        return markerGroup
                    },
                    _drawMarker(renderer, group) {
                        this._drawMarkerInGroup(this._getMarkerGroup(group), this._getStyle(), renderer)
                    },
                    _getSettingsForTracker() {
                        const that = this;
                        let highY = that.highY;
                        let lowY = that.lowY;
                        const rotated = that._options.rotated;
                        let x;
                        let y;
                        let width;
                        let height;
                        if (highY === lowY) {
                            highY = rotated ? highY + 2 : highY - 2;
                            lowY = rotated ? lowY - 2 : lowY + 2
                        }
                        if (rotated) {
                            x = _min(lowY, highY);
                            y = that.x - that.width / 2;
                            width = _abs(lowY - highY);
                            height = that.width
                        } else {
                            x = that.x - that.width / 2;
                            y = _min(lowY, highY);
                            width = that.width;
                            height = _abs(lowY - highY)
                        }
                        return {
                            x: x,
                            y: y,
                            width: width,
                            height: height
                        }
                    },
                    _getGraphicBBox(location) {
                        const that = this;
                        const rotated = that._options.rotated;
                        const x = that.x;
                        const width = that.width;
                        let lowY = that.lowY;
                        let highY = that.highY;
                        if (location) {
                            const valVisibleArea = that.series.getValueAxis().getVisibleArea();
                            highY = that._truncateCoord(highY, valVisibleArea);
                            lowY = that._truncateCoord(lowY, valVisibleArea)
                        }
                        const bBox = {
                            x: !rotated ? x - _round(width / 2) : lowY,
                            y: !rotated ? highY : x - _round(width / 2),
                            width: !rotated ? width : highY - lowY,
                            height: !rotated ? lowY - highY : width
                        };
                        if (location) {
                            const isTop = "top" === location;
                            if (!this._options.rotated) {
                                bBox.y = isTop ? bBox.y : bBox.y + bBox.height;
                                bBox.height = 0
                            } else {
                                bBox.x = isTop ? bBox.x + bBox.width : bBox.x;
                                bBox.width = 0
                            }
                        }
                        return bBox
                    },
                    getTooltipParams(location) {
                        const that = this;
                        if (that.graphic) {
                            const minValue = _min(that.lowY, that.highY);
                            const maxValue = _max(that.lowY, that.highY);
                            const visibleArea = that._getVisibleArea();
                            const rotated = that._options.rotated;
                            const minVisible = rotated ? visibleArea.minX : visibleArea.minY;
                            const maxVisible = rotated ? visibleArea.maxX : visibleArea.maxY;
                            const min = _max(minVisible, minValue);
                            const max = _min(maxVisible, maxValue);
                            const centerCoord = that.getCenterCoord();
                            if ("edge" === location) {
                                centerCoord[rotated ? "x" : "y"] = rotated ? max : min
                            }
                            centerCoord.offset = 0;
                            return centerCoord
                        }
                    },
                    getCenterCoord() {
                        if (this.graphic) {
                            const that = this;
                            let x;
                            let y;
                            const minValue = _min(that.lowY, that.highY);
                            const maxValue = _max(that.lowY, that.highY);
                            const visibleArea = that._getVisibleArea();
                            const rotated = that._options.rotated;
                            const minVisible = rotated ? visibleArea.minX : visibleArea.minY;
                            const maxVisible = rotated ? visibleArea.maxX : visibleArea.maxY;
                            const min = _max(minVisible, minValue);
                            const max = _min(maxVisible, maxValue);
                            const center = min + (max - min) / 2;
                            if (rotated) {
                                y = that.x;
                                x = center
                            } else {
                                x = that.x;
                                y = center
                            }
                            return {
                                x: x,
                                y: y
                            }
                        }
                    },
                    hasValue() {
                        return null !== this.highValue && null !== this.lowValue
                    },
                    hasCoords() {
                        return null !== this.x && null !== this.lowY && null !== this.highY
                    },
                    _translate() {
                        const valTranslator = this._getValTranslator();
                        const x = this._getArgTranslator().translate(this.argument);
                        this.vx = this.vy = this.x = null === x ? x : x + (this.xCorrection || 0);
                        this.openY = null !== this.openValue ? valTranslator.translate(this.openValue) : null;
                        this.highY = valTranslator.translate(this.highValue);
                        this.lowY = valTranslator.translate(this.lowValue);
                        this.closeY = null !== this.closeValue ? valTranslator.translate(this.closeValue) : null;
                        const minValue = Math.min(this.lowY, this.highY);
                        const height = Math.abs(this.lowY - this.highY);
                        if (this._options.rotated) {
                            this._calculateVisibility(minValue, this.x, height, 0)
                        } else {
                            this._calculateVisibility(this.x, minValue, 0, height)
                        }
                    },
                    getCrosshairData(x, y) {
                        const that = this;
                        const rotated = that._options.rotated;
                        const origY = rotated ? x : y;
                        let yValue;
                        const argument = that.argument;
                        let coords;
                        let coord = "low";
                        if (_abs(that.lowY - origY) < _abs(that.closeY - origY)) {
                            yValue = that.lowY
                        } else {
                            yValue = that.closeY;
                            coord = "close"
                        }
                        if (_abs(yValue - origY) >= _abs(that.openY - origY)) {
                            yValue = that.openY;
                            coord = "open"
                        }
                        if (_abs(yValue - origY) >= _abs(that.highY - origY)) {
                            yValue = that.highY;
                            coord = "high"
                        }
                        if (rotated) {
                            coords = {
                                y: that.vy,
                                x: yValue,
                                xValue: that[`${coord}Value`],
                                yValue: argument
                            }
                        } else {
                            coords = {
                                x: that.vx,
                                y: yValue,
                                xValue: argument,
                                yValue: that[`${coord}Value`]
                            }
                        }
                        coords.axis = that.series.axis;
                        return coords
                    },
                    _updateData(data) {
                        const label = this._label;
                        const reductionColor = this._options.reduction.color;
                        this.value = this.initialValue = data.reductionValue;
                        this.originalValue = data.value;
                        this.lowValue = this.originalLowValue = data.lowValue;
                        this.highValue = this.originalHighValue = data.highValue;
                        this.openValue = this.originalOpenValue = data.openValue;
                        this.closeValue = this.originalCloseValue = data.closeValue;
                        this._isPositive = data.openValue < data.closeValue;
                        this._isReduction = data.isReduction;
                        if (this._isReduction) {
                            label.setColor(reductionColor)
                        }
                    },
                    _updateMarker(animationEnabled, style, group) {
                        const graphic = this.graphic;
                        graphic.attr({
                            points: this._getPoints()
                        }).smartAttr(style).sharp();
                        group && graphic.append(this._getMarkerGroup(group))
                    },
                    _getLabelFormatObject() {
                        return {
                            openValue: this.openValue,
                            highValue: this.highValue,
                            lowValue: this.lowValue,
                            closeValue: this.closeValue,
                            reductionValue: this.initialValue,
                            argument: this.initialArgument,
                            value: this.initialValue,
                            seriesName: this.series.name,
                            originalOpenValue: this.originalOpenValue,
                            originalCloseValue: this.originalCloseValue,
                            originalLowValue: this.originalLowValue,
                            originalHighValue: this.originalHighValue,
                            originalArgument: this.originalArgument,
                            point: this
                        }
                    },
                    _getFormatObject(tooltip) {
                        const highValue = tooltip.formatValue(this.highValue);
                        const openValue = tooltip.formatValue(this.openValue);
                        const closeValue = tooltip.formatValue(this.closeValue);
                        const lowValue = tooltip.formatValue(this.lowValue);
                        const symbolMethods = _symbol_point.default;
                        const formatObject = symbolMethods._getFormatObject.call(this, tooltip);
                        return (0, _extend2.extend)({}, formatObject, {
                            valueText: `h: ${highValue}${""!==openValue?` o: ${openValue}`:""}${""!==closeValue?` c: ${closeValue}`:""} l: ${lowValue}`,
                            highValueText: highValue,
                            openValueText: openValue,
                            closeValueText: closeValue,
                            lowValueText: lowValue
                        })
                    },
                    getMaxValue() {
                        return this.highValue
                    },
                    getMinValue() {
                        return this.lowValue
                    }
                })
            },
        5911:
            /*!*************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/vector_map/vector_map.js ***!
              \*************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                __webpack_require__( /*! ../../viz/vector_map/projection */ 56984);
                var _component_registrator = _interopRequireDefault(__webpack_require__( /*! ../../../core/component_registrator */ 92848));
                var _annotations = __webpack_require__( /*! ../../viz/core/annotations */ 77438);
                var _export = __webpack_require__( /*! ../../viz/core/export */ 43452);
                var _loading_indicator = __webpack_require__( /*! ../../viz/core/loading_indicator */ 71126);
                var _m_base_widget = _interopRequireDefault(__webpack_require__( /*! ../../viz/core/m_base_widget */ 34506));
                var _title = __webpack_require__( /*! ../../viz/core/title */ 69638);
                var _tooltip = __webpack_require__( /*! ../../viz/core/tooltip */ 94371);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                var _control_bar = __webpack_require__( /*! ../../viz/vector_map/control_bar/control_bar */ 3590);
                var _data_exchanger = __webpack_require__( /*! ../../viz/vector_map/data_exchanger */ 66879);
                var _gesture_handler = __webpack_require__( /*! ../../viz/vector_map/gesture_handler */ 48605);
                var _layout = __webpack_require__( /*! ../../viz/vector_map/layout */ 47943);
                var _legend = __webpack_require__( /*! ../../viz/vector_map/legend */ 89492);
                var _map_layer = __webpack_require__( /*! ../../viz/vector_map/map_layer */ 4249);
                var _projection2 = __webpack_require__( /*! ../../viz/vector_map/projection.main */ 8593);
                var _tooltip_viewer = __webpack_require__( /*! ../../viz/vector_map/tooltip_viewer */ 43803);
                var _tracker = __webpack_require__( /*! ../../viz/vector_map/tracker */ 92673);
                var _vector_map = __webpack_require__( /*! ../../viz/vector_map/vector_map.utils */ 53980);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }

                function mergeBounds(sumBounds, dataBounds) {
                    return dataBounds ? [Math.min(dataBounds[0], dataBounds[2], sumBounds[0]), Math.min(dataBounds[1], dataBounds[3], sumBounds[3]), Math.max(dataBounds[0], dataBounds[2], sumBounds[2]), Math.max(dataBounds[1], dataBounds[3], sumBounds[1])] : sumBounds
                }
                const dxVectorMap = _m_base_widget.default.inherit({
                    _eventsMap: {
                        onClick: {
                            name: "click"
                        },
                        onCenterChanged: {
                            name: "centerChanged"
                        },
                        onZoomFactorChanged: {
                            name: "zoomFactorChanged"
                        },
                        onHoverChanged: {
                            name: "hoverChanged"
                        },
                        onSelectionChanged: {
                            name: "selectionChanged"
                        }
                    },
                    _rootClassPrefix: "dxm",
                    _rootClass: "dxm-vector-map",
                    _themeSection: "map",
                    _fontFields: ["layer:area.label.font", "layer:marker:dot.label.font", "layer:marker:bubble.label.font", "layer:marker:pie.label.font", "layer:marker:image.label.font", "legend.font", "legend.title.font", "legend.title.subtitle.font"],
                    _initLayerCollection(dataKey) {
                        const that = this;
                        that._layerCollection = new _map_layer.MapLayerCollection({
                            renderer: that._renderer,
                            projection: that._projection,
                            themeManager: that._themeManager,
                            tracker: that._tracker,
                            dataKey: dataKey,
                            eventTrigger: that._eventTrigger,
                            dataExchanger: that._dataExchanger,
                            tooltip: that._tooltip,
                            notifyDirty: that._notifyDirty,
                            notifyReady: that._notifyReady,
                            dataReady() {
                                let bounds;
                                if (that.option("getBoundsFromData") && !that.option("bounds")) {
                                    that._preventProjectionEvents();
                                    bounds = that._getBoundsFromData();
                                    that._projection.setBounds(bounds);
                                    that._allowProjectionEvents()
                                }
                                if (!that.option("projection")) {
                                    bounds = bounds || that._getBoundsFromData();
                                    if (Math.ceil(bounds[0]) < -180 || Math.ceil(bounds[3]) < -90 || Math.floor(bounds[2]) > 180 || Math.floor(bounds[1]) > 90) {
                                        const longitudeLength = bounds[2] - bounds[0];
                                        const latitudeLength = bounds[1] - bounds[3];
                                        that._projection.setEngine({
                                            to: coordinates => [2 * (coordinates[0] - bounds[0]) / longitudeLength - 1, 2 * (coordinates[1] - bounds[3]) / latitudeLength - 1],
                                            from: coordinates => [(coordinates[0] + 1) * longitudeLength / 2 + bounds[0], (coordinates[1] + 1) * latitudeLength / 2 + bounds[3]]
                                        })
                                    }
                                }
                            }
                        })
                    },
                    _getBoundsFromData() {
                        let bounds = this._getBoundingBoxFromDataSource();
                        if (!bounds) {
                            const layersBounds = this.getLayers().map((l => l.getBounds())).filter((x => void 0 !== x));
                            const boundsByData = (0, _map_layer.getMaxBound)(layersBounds);
                            if (boundsByData) {
                                bounds = boundsByData
                            }
                        }
                        bounds = bounds || [];
                        bounds = [bounds[0], bounds[3], bounds[2], bounds[1]];
                        return bounds
                    },
                    _initLegendsControl() {
                        this._legendsControl = new _legend.LegendsControl({
                            renderer: this._renderer,
                            container: this._root,
                            widget: this,
                            layoutControl: this._layoutControl,
                            themeManager: this._themeManager,
                            dataExchanger: this._dataExchanger,
                            notifyDirty: this._notifyDirty,
                            notifyReady: this._notifyReady
                        })
                    },
                    _initControlBar(dataKey) {
                        this._controlBar = new _control_bar.ControlBar({
                            renderer: this._renderer,
                            container: this._root,
                            layoutControl: this._layoutControl,
                            projection: this._projection,
                            tracker: this._tracker,
                            dataKey: dataKey
                        })
                    },
                    _initElements() {
                        const that = this;
                        const dataKey = (0, _vector_map.generateDataKey)();
                        let notifyCounter = 0;
                        let preventProjectionEvents;
                        that._preventProjectionEvents = function() {
                            preventProjectionEvents = true
                        };
                        that._allowProjectionEvents = function() {
                            preventProjectionEvents = false
                        };
                        that._notifyDirty = function() {
                            that._resetIsReady();
                            ++notifyCounter
                        };
                        that._notifyReady = function() {
                            that._allowProjectionEvents();
                            if (0 === --notifyCounter) {
                                that._drawn()
                            }
                        };
                        that._preventProjectionEvents();
                        that._dataExchanger = new _data_exchanger.DataExchanger;
                        that._projection = new _projection2.Projection({
                            centerChanged(value) {
                                if (!preventProjectionEvents) {
                                    that._eventTrigger("centerChanged", {
                                        center: value
                                    })
                                }
                            },
                            zoomChanged(value) {
                                if (!preventProjectionEvents) {
                                    that._eventTrigger("zoomFactorChanged", {
                                        zoomFactor: value
                                    })
                                }
                            }
                        });
                        that._tracker = new _tracker.Tracker({
                            root: that._root,
                            projection: that._projection,
                            dataKey: dataKey
                        });
                        that._gestureHandler = new _gesture_handler.GestureHandler({
                            projection: that._projection,
                            renderer: that._renderer,
                            tracker: that._tracker
                        });
                        that._layoutControl = new _layout.LayoutControl(that);
                        that._layoutControl.suspend();
                        that._initLayerCollection(dataKey);
                        that._createHtmlStructure();
                        that._initControlBar(dataKey);
                        that._initLegendsControl();
                        that._prepareExtraElements();
                        that._tooltipViewer = new _tooltip_viewer.TooltipViewer({
                            tracker: that._tracker,
                            tooltip: that._tooltip,
                            layerCollection: that._layerCollection
                        })
                    },
                    _change_RESUME_LAYOUT() {
                        this._layoutControl.resume()
                    },
                    _initialChanges: ["PROJECTION", "RESUME_LAYOUT", "LAYOUT_INIT", "BOUNDS", "MAX_ZOOM_FACTOR", "ZOOM_FACTOR", "CENTER"],
                    _layoutChangesOrder: ["RESUME_LAYOUT", "LAYERS"],
                    _customChangesOrder: ["EXTRA_ELEMENTS"],
                    _initCore() {
                        this._root = this._renderer.root.attr({
                            align: "center",
                            cursor: "default"
                        });
                        this._initElements()
                    },
                    _disposeCore() {
                        this._controlBar.dispose();
                        this._gestureHandler.dispose();
                        this._tracker.dispose();
                        this._legendsControl.dispose();
                        this._layerCollection.dispose();
                        this._layoutControl.dispose();
                        this._tooltipViewer.dispose();
                        this._dataExchanger.dispose();
                        this._projection.dispose();
                        this._dataExchanger = this._gestureHandler = this._projection = this._tracker = this._layoutControl = this._root = this._layerCollection = this._controlBar = this._legendsControl = null
                    },
                    _setupInteraction() {
                        const options = {
                            centeringEnabled: !!(0, _utils.parseScalar)(this._getOption("panningEnabled", true), true),
                            zoomingEnabled: !!(0, _utils.parseScalar)(this._getOption("zoomingEnabled", true), true)
                        };
                        this._gestureHandler.setInteraction(options);
                        this._controlBar.setInteraction(options)
                    },
                    _getDefaultSize: () => ({
                        width: 800,
                        height: 400
                    }),
                    _applySize(rect) {
                        const layout = {
                            left: rect[0],
                            top: rect[1],
                            width: rect[2] - rect[0],
                            height: rect[3] - rect[1],
                            right: 0,
                            bottom: 0
                        };
                        this._projection.setSize(layout);
                        this._layoutControl.setSize(layout);
                        this._layerCollection.setRect([layout.left, layout.top, layout.width, layout.height]);
                        this._requestChange(["EXTRA_ELEMENTS"])
                    },
                    _optionChanging(name, currentValue, nextValue) {
                        if (currentValue && nextValue) {
                            if (name.startsWith("layers")) {
                                if (currentValue.dataSource && nextValue.dataSource && currentValue !== nextValue) {
                                    currentValue.dataSource = null
                                } else if (name.endsWith(".dataSource")) {
                                    this.option(name, null)
                                }
                            }
                        }
                    },
                    _applyChanges() {
                        this._notifyDirty();
                        this.callBase.apply(this, arguments);
                        this._notifyReady()
                    },
                    _optionChangesMap: {
                        background: "BACKGROUND",
                        layers: "LAYERS",
                        extraElements: "EXTRA_ELEMENTS",
                        controlBar: "CONTROL_BAR",
                        legends: "LEGENDS",
                        touchEnabled: "TRACKER",
                        wheelEnabled: "TRACKER",
                        panningEnabled: "INTERACTION",
                        zoomingEnabled: "INTERACTION",
                        projection: "PROJECTION",
                        bounds: "BOUNDS",
                        maxZoomFactor: "MAX_ZOOM_FACTOR",
                        zoomFactor: "ZOOM_FACTOR",
                        center: "CENTER"
                    },
                    _optionChangesOrder: ["PROJECTION", "BOUNDS", "MAX_ZOOM_FACTOR", "ZOOM_FACTOR", "CENTER", "BACKGROUND", "CONTROL_BAR", "LEGENDS", "TRACKER", "INTERACTION"],
                    _change_PROJECTION() {
                        this._setProjection()
                    },
                    _change_BOUNDS() {
                        this._setBounds()
                    },
                    _change_MAX_ZOOM_FACTOR() {
                        this._setMaxZoom()
                    },
                    _change_ZOOM_FACTOR() {
                        this._setZoom()
                    },
                    _change_CENTER() {
                        this._setCenter()
                    },
                    _change_BACKGROUND() {
                        this._setBackgroundOptions()
                    },
                    _change_LAYERS() {
                        this._setLayerCollectionOptions()
                    },
                    _change_CONTROL_BAR() {
                        this._setControlBarOptions()
                    },
                    _change_EXTRA_ELEMENTS() {
                        this._renderExtraElements()
                    },
                    _change_LEGENDS() {
                        this._setLegendsOptions()
                    },
                    _change_TRACKER() {
                        this._setTrackerOptions()
                    },
                    _change_INTERACTION() {
                        this._setupInteraction()
                    },
                    _themeDependentChanges: ["BACKGROUND", "LAYERS", "CONTROL_BAR", "LEGENDS", "TRACKER", "INTERACTION"],
                    _setProjection() {
                        this._projection.setEngine(this.option("projection"))
                    },
                    _setBounds() {
                        this._projection.setBounds(this.option("bounds"))
                    },
                    _setMaxZoom() {
                        this._projection.setMaxZoom(this.option("maxZoomFactor"))
                    },
                    _setZoom() {
                        this._projection.setZoom(this.option("zoomFactor"))
                    },
                    _setCenter() {
                        this._projection.setCenter(this.option("center"))
                    },
                    _setBackgroundOptions() {
                        this._layerCollection.setBackgroundOptions(this._getOption("background"))
                    },
                    _setLayerCollectionOptions() {
                        this._layerCollection.setOptions(this.option("layers"))
                    },
                    _getBoundingBoxFromDataSource() {
                        const layers = this._layerCollection.items();
                        const infinityBounds = [1 / 0, -1 / 0, -1 / 0, 1 / 0];
                        const resultBBox = layers && layers.length ? layers.reduce(((sumBBox, l) => {
                            const layerData = l.getData();
                            const itemCount = layerData.count();
                            if (itemCount > 0) {
                                const rootBBox = layerData.getBBox();
                                if (rootBBox) {
                                    sumBBox = mergeBounds(sumBBox, rootBBox)
                                } else {
                                    for (let i = 0; i < itemCount; i++) {
                                        sumBBox = mergeBounds(sumBBox, layerData.getBBox(i))
                                    }
                                }
                            }
                            return sumBBox
                        }), infinityBounds) : void 0;
                        return resultBBox === infinityBounds ? void 0 : resultBBox
                    },
                    _setControlBarOptions() {
                        this._controlBar.setOptions(this._getOption("controlBar"))
                    },
                    _setLegendsOptions() {
                        this._legendsControl.setOptions(this.option("legends"))
                    },
                    _setTrackerOptions() {
                        this._tracker.setOptions({
                            touchEnabled: this._getOption("touchEnabled", true),
                            wheelEnabled: this._getOption("wheelEnabled", true)
                        })
                    },
                    getLayers() {
                        return this._layerCollection.items().map((l => l.proxy))
                    },
                    getLayerByIndex(index) {
                        const layer = this._layerCollection.byIndex(index);
                        return layer ? layer.proxy : null
                    },
                    getLayerByName(name) {
                        const layer = this._layerCollection.byName(name);
                        return layer ? layer.proxy : null
                    },
                    clearSelection(_noEvent) {
                        const layers = this._layerCollection.items();
                        let i;
                        const ii = layers.length;
                        for (i = 0; i < ii; ++i) {
                            layers[i].clearSelection(_noEvent)
                        }
                        return this
                    },
                    center(value) {
                        const that = this;
                        if (void 0 === value) {
                            return that._projection.getCenter()
                        } else {
                            that._projection.setCenter(value);
                            return that
                        }
                    },
                    zoomFactor(value) {
                        const that = this;
                        if (void 0 === value) {
                            return that._projection.getZoom()
                        } else {
                            that._projection.setZoom(value);
                            return that
                        }
                    },
                    viewport(value) {
                        const that = this;
                        if (void 0 === value) {
                            return that._projection.getViewport()
                        } else {
                            that._projection.setViewport(value);
                            return that
                        }
                    },
                    convertToGeo(x, y) {
                        return this._projection.fromScreenPoint([x, y])
                    },
                    convertToXY(longitude, latitude) {
                        return this._projection.toScreenPoint([longitude, latitude])
                    }
                });
                (0, _component_registrator.default)("dxVectorMap", dxVectorMap);
                exports.default = dxVectorMap;
                dxVectorMap.addPlugin(_export.plugin);
                dxVectorMap.addPlugin(_title.plugin);
                dxVectorMap.addPlugin(_tooltip.plugin);
                dxVectorMap.addPlugin(_loading_indicator.plugin);
                dxVectorMap.addPlugin(_annotations.plugins.core);
                dxVectorMap.addPlugin(_annotations.plugins.vectorMap)
            },
        5930:
            /*!*************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/data/m_errors.js ***!
              \*************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.setErrorHandler = exports.handleError = exports.errors = exports.errorHandler = void 0;
                var _errors = _interopRequireDefault(__webpack_require__( /*! ../../core/errors */ 87129));
                var _error = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/error */ 67264));

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                exports.errors = (0, _error.default)(_errors.default.ERROR_MESSAGES, {
                    E4000: "[DevExpress.data]: {0}",
                    E4001: "Unknown aggregating function is detected: '{0}'",
                    E4002: "Unsupported OData protocol version is used",
                    E4003: "Unknown filter operation is used: {0}",
                    E4004: "The thenby() method is called before the sortby() method",
                    E4005: "Store requires a key expression for this operation",
                    E4006: "ArrayStore 'data' option must be an array",
                    E4007: "Compound keys cannot be auto-generated",
                    E4008: "Attempt to insert an item with a duplicated key",
                    E4009: "Data item cannot be found",
                    E4010: "CustomStore does not support creating queries",
                    E4011: "Custom Store method is not implemented or is not a function: {0}",
                    E4012: "Custom Store method returns an invalid value: {0}",
                    E4013: "Local Store requires the 'name' configuration option is specified",
                    E4014: "Unknown data type is specified for ODataStore: {0}",
                    E4015: "Unknown entity name or alias is used: {0}",
                    E4016: "The compileSetter(expr) method is called with 'self' passed as a parameter",
                    E4017: "Keys cannot be modified",
                    E4018: "The server has returned a non-numeric value in a response to an item count request",
                    E4019: "Mixing of group operators inside a single group of filter expression is not allowed",
                    E4020: "Unknown store type is detected: {0}",
                    E4021: "The server response does not provide the totalCount value",
                    E4022: "The server response does not provide the groupCount value",
                    E4023: "Could not parse the following XML: {0}",
                    E4024: "String function {0} cannot be used with the data field {1} of type {2}.",
                    W4000: "Data returned from the server has an incorrect structure",
                    W4001: 'The {0} field is listed in both "keyType" and "fieldTypes". The value of "fieldTypes" is used.',
                    W4002: "Data loading has failed for some cells due to the following error: {0}"
                });
                let errorHandler = exports.errorHandler = null;
                exports.handleError = function(error) {
                    var _errorHandler;
                    null === (_errorHandler = errorHandler) || void 0 === _errorHandler || _errorHandler(error)
                };
                exports.setErrorHandler = handler => exports.errorHandler = errorHandler = handler
            },
        5949:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/core/events/pointer/mouse.js ***!
              \*********************************************************************************/
            (module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "default", {
                    enumerable: true,
                    get: function() {
                        return _m_mouse.default
                    }
                });
                var _m_mouse = (e = __webpack_require__( /*! ../../../../__internal/events/pointer/m_mouse */ 45841), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        5954:
            /*!*******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/exporter/jspdf/export_data_grid.js ***!
              \*******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.exportDataGrid = function(options) {
                    return _export.Export.export(function(options) {
                        if (!((0, _type.isDefined)(options) && (0, _type.isObject)(options))) {
                            throw Error('The "exportDataGrid" method requires a configuration object.')
                        }
                        if (!((0, _type.isDefined)(options.component) && (0, _type.isObject)(options.component) && "dxDataGrid" === options.component.NAME)) {
                            throw Error('The "component" field must contain a DataGrid instance.')
                        }
                        if (!((0, _type.isDefined)(options.jsPDFDocument) && (0, _type.isObject)(options.jsPDFDocument))) {
                            throw Error('The "jsPDFDocument" field must contain a jsPDF instance.')
                        }
                        if ((0, _type.isDefined)(options.autoTableOptions)) {
                            _errors.default.log("W0001", "Export", "autoTableOptions", "22.1", `You can migrate from exporting to PDF with the AutoTable plugin to a new export system. See the following topic for more information: ${HOW_TO_MIGRATE_ARTICLE}`)
                        }
                        return _export.Export.getFullOptions(options)
                    }(options))
                };
                var _errors = (e = __webpack_require__( /*! ../../../core/errors */ 87129), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _export = __webpack_require__( /*! ./common/export */ 14400);
                const HOW_TO_MIGRATE_ARTICLE = "https://supportcenter.devexpress.com/ticket/details/t1077554"
            },
        5995:
            /*!***************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/data/abstract_store.js ***!
              \***************************************************************************/
            (module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "default", {
                    enumerable: true,
                    get: function() {
                        return _m_abstract_store.default
                    }
                });
                var _m_abstract_store = (e = __webpack_require__( /*! ../../__internal/data/m_abstract_store */ 1773), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                module.exports = exports.default;
                module.exports.default = exports.default
            },
        6013:
            /*!*********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/ui/themes.js ***!
              \*********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.attachCssClasses = attachCssClasses;
                exports.current = current;
                exports.default = void 0;
                exports.detachCssClasses = detachCssClasses;
                exports.init = init;
                exports.initialized = initialized;
                exports.isCompact = isCompact;
                exports.isDark = isDark;
                exports.isFluent = isFluent;
                exports.isGeneric = isGeneric;
                exports.isMaterial = isMaterial;
                exports.isMaterialBased = isMaterialBased;
                exports.isPendingThemeLoaded = isPendingThemeLoaded;
                exports.isWebFontLoaded = isWebFontLoaded;
                exports.ready = themeReady;
                exports.resetTheme = resetTheme;
                exports.setDefaultTimeout = setDefaultTimeout;
                exports.waitForThemeLoad = waitForThemeLoad;
                exports.waitWebFont = waitWebFont;
                var _devices = _interopRequireDefault(__webpack_require__( /*! ../../core/devices */ 65951));
                var _dom_adapter = _interopRequireDefault(__webpack_require__( /*! ../../core/dom_adapter */ 64960));
                var _renderer = _interopRequireDefault(__webpack_require__( /*! ../../core/renderer */ 64553));
                var _deferred = __webpack_require__( /*! ../../core/utils/deferred */ 87739);
                var _html_parser = __webpack_require__( /*! ../../core/utils/html_parser */ 23563);
                var _iterator = __webpack_require__( /*! ../../core/utils/iterator */ 21274);
                var _ready_callbacks = _interopRequireDefault(__webpack_require__( /*! ../../core/utils/ready_callbacks */ 3122));
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);
                var _view_port = __webpack_require__( /*! ../../core/utils/view_port */ 55355);
                var _window = __webpack_require__( /*! ../../core/utils/window */ 3104);
                var _ui = _interopRequireDefault(__webpack_require__( /*! ../../ui/widget/ui.errors */ 35185));
                var _m_common = __webpack_require__( /*! ../core/utils/m_common */ 39315);
                var _m_themes_callback = __webpack_require__( /*! ../ui/m_themes_callback */ 68831);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const window = (0, _window.getWindow)();
                const ready = _ready_callbacks.default.add;
                const viewPort = _view_port.value;
                const viewPortChanged = _view_port.changeCallback;
                let initDeferred = new _deferred.Deferred;
                const DX_LINK_SELECTOR = "link[rel=dx-theme]";
                const THEME_ATTR = "data-theme";
                const ACTIVE_ATTR = "data-active";
                const DX_HAIRLINES_CLASS = "dx-hairlines";
                const ANY_THEME = "any";
                let context;
                let $activeThemeLink;
                let knownThemes;
                let currentThemeName;
                let pendingThemeName;
                let defaultTimeout = 15e3;
                const THEME_MARKER_PREFIX = "dx.";

                function readThemeMarker() {
                    if (!(0, _window.hasWindow)()) {
                        return null
                    }
                    const element = (0, _renderer.default)("<div>", context).addClass("dx-theme-marker").appendTo(context.documentElement);
                    let result;
                    try {
                        result = window.getComputedStyle(element.get(0)).fontFamily;
                        if (!result) {
                            return null
                        }
                        result = result.replace(/["']/g, "");
                        if (result.substr(0, THEME_MARKER_PREFIX.length) !== THEME_MARKER_PREFIX) {
                            return null
                        }
                        return result.substr(THEME_MARKER_PREFIX.length)
                    } finally {
                        element.remove()
                    }
                }

                function isPendingThemeLoaded() {
                    if (!pendingThemeName) {
                        return true
                    }
                    const anyThemePending = pendingThemeName === ANY_THEME;
                    if ("resolved" === initDeferred.state() && anyThemePending) {
                        return true
                    }
                    const themeMarker = readThemeMarker();
                    if (themeMarker && anyThemePending) {
                        return true
                    }
                    return themeMarker === pendingThemeName
                }

                function waitForThemeLoad(themeName) {
                    let waitStartTime;
                    let timerId;
                    let intervalCleared = true;
                    pendingThemeName = themeName;

                    function handleLoaded() {
                        pendingThemeName = null;
                        clearInterval(timerId);
                        intervalCleared = true;
                        _m_themes_callback.themeReadyCallback.fire();
                        _m_themes_callback.themeReadyCallback.empty();
                        initDeferred.resolve()
                    }
                    if (isPendingThemeLoaded() || !defaultTimeout) {
                        handleLoaded()
                    } else {
                        if (!intervalCleared) {
                            if (pendingThemeName) {
                                pendingThemeName = themeName
                            }
                            return
                        }
                        waitStartTime = Date.now();
                        intervalCleared = false;
                        timerId = setInterval((() => {
                            const isLoaded = isPendingThemeLoaded();
                            const isTimeout = !isLoaded && Date.now() - waitStartTime > defaultTimeout;
                            if (isTimeout) {
                                _ui.default.log("W0004", pendingThemeName)
                            }
                            if (isLoaded || isTimeout) {
                                handleLoaded()
                            }
                        }), 10)
                    }
                }
                let themeClasses;

                function _attachCssClasses(element, themeName) {
                    themeClasses = function(themeName) {
                        var _themeName;
                        themeName = themeName || current();
                        const result = [];
                        const themeNameParts = null === (_themeName = themeName) || void 0 === _themeName ? void 0 : _themeName.split(".");
                        if (themeNameParts) {
                            result.push(`dx-theme-${themeNameParts[0]}`, `dx-theme-${themeNameParts[0]}-typography`);
                            if (themeNameParts.length > 1) {
                                result.push(`dx-color-scheme-${themeNameParts[1]}${isMaterialBased(themeName)?`-${themeNameParts[2]}`:""}`)
                            }
                        }
                        return result
                    }(themeName).join(" ");
                    (0, _renderer.default)(element).addClass(themeClasses);
                    (() => {
                        const pixelRatio = (0, _window.hasWindow)() && window.devicePixelRatio;
                        if (!pixelRatio || pixelRatio < 2) {
                            return
                        }
                        const $tester = (0, _renderer.default)("<div>");
                        $tester.css("border", ".5px solid transparent");
                        (0, _renderer.default)("body").append($tester);
                        if (1 === (0, _size.getOuterHeight)($tester)) {
                            (0, _renderer.default)(element).addClass(DX_HAIRLINES_CLASS);
                            themeClasses += ` ${DX_HAIRLINES_CLASS}`
                        }
                        $tester.remove()
                    })()
                }

                function attachCssClasses(element, themeName) {
                    (0, _deferred.when)(_m_common.uiLayerInitialized).done((() => {
                        _attachCssClasses(element, themeName)
                    }))
                }

                function detachCssClasses(element) {
                    (0, _deferred.when)(_m_common.uiLayerInitialized).done((() => {
                        (0, _renderer.default)(element).removeClass(themeClasses)
                    }))
                }

                function current(options) {
                    if (!arguments.length) {
                        currentThemeName = currentThemeName || readThemeMarker();
                        return currentThemeName
                    }
                    detachCssClasses(viewPort());
                    options = options || {};
                    if ("string" === typeof options) {
                        options = {
                            theme: options
                        }
                    }
                    const isAutoInit = options._autoInit;
                    const {
                        loadCallback: loadCallback
                    } = options;
                    let currentThemeData;
                    currentThemeName = function(desiredThemeName) {
                        const desiredThemeParts = desiredThemeName ? desiredThemeName.split(".") : [];
                        let result = null;
                        if (knownThemes) {
                            if (desiredThemeName in knownThemes) {
                                return desiredThemeName
                            }(0, _iterator.each)(knownThemes, ((knownThemeName, themeData) => {
                                const knownThemeParts = knownThemeName.split(".");
                                if (desiredThemeParts[0] && knownThemeParts[0] !== desiredThemeParts[0]) {
                                    return
                                }
                                if (desiredThemeParts[1] && desiredThemeParts[1] !== knownThemeParts[1]) {
                                    return
                                }
                                if (desiredThemeParts[2] && desiredThemeParts[2] !== knownThemeParts[2]) {
                                    return
                                }
                                if (!result || themeData.isActive) {
                                    result = knownThemeName
                                }
                                if (themeData.isActive) {
                                    return false
                                }
                            }))
                        }
                        return result
                    }(options.theme || currentThemeName);
                    if (currentThemeName) {
                        currentThemeData = knownThemes[currentThemeName]
                    }
                    if (loadCallback) {
                        _m_themes_callback.themeReadyCallback.add(loadCallback)
                    }
                    if (currentThemeData) {
                        $activeThemeLink.attr("href", knownThemes[currentThemeName].url);
                        if (_m_themes_callback.themeReadyCallback.has() || "resolved" !== initDeferred.state() || options._forceTimeout) {
                            waitForThemeLoad(currentThemeName)
                        }
                    } else if (isAutoInit) {
                        if ((0, _window.hasWindow)()) {
                            waitForThemeLoad(ANY_THEME)
                        }
                        _m_themes_callback.themeReadyCallback.fire();
                        _m_themes_callback.themeReadyCallback.empty()
                    } else {
                        throw _ui.default.Error("E0021", currentThemeName)
                    }
                    initDeferred.done((() => attachCssClasses((0, _view_port.originalViewPort)(), currentThemeName)))
                }

                function init(options) {
                    options = options || {};
                    ! function(newContext) {
                        try {
                            if (newContext !== context) {
                                knownThemes = null
                            }
                        } catch (x) {
                            knownThemes = null
                        }
                        context = newContext
                    }(options.context || _dom_adapter.default.getDocument());
                    if (!context) {
                        return
                    }! function() {
                        const $allThemeLinks = (0, _renderer.default)(DX_LINK_SELECTOR, context);
                        if (!$allThemeLinks.length) {
                            return
                        }
                        knownThemes = {};
                        $activeThemeLink = (0, _renderer.default)((0, _html_parser.parseHTML)("<link rel=stylesheet>"), context);
                        $allThemeLinks.each((function() {
                            const link = (0, _renderer.default)(this, context);
                            const fullThemeName = link.attr(THEME_ATTR);
                            const url = link.attr("href");
                            const isActive = "true" === link.attr(ACTIVE_ATTR);
                            knownThemes[fullThemeName] = {
                                url: url,
                                isActive: isActive
                            }
                        }));
                        $allThemeLinks.last().after($activeThemeLink);
                        $allThemeLinks.remove()
                    }();
                    currentThemeName = void 0;
                    current(options)
                }

                function isTheme(themeRegExp, themeName) {
                    if (!themeName) {
                        themeName = currentThemeName || readThemeMarker()
                    }
                    return new RegExp(themeRegExp).test(themeName)
                }

                function isMaterial(themeName) {
                    return isTheme("material", themeName)
                }

                function isFluent(themeName) {
                    return isTheme("fluent", themeName)
                }

                function isMaterialBased(themeName) {
                    return isMaterial(themeName) || isFluent(themeName)
                }

                function isGeneric(themeName) {
                    return isTheme("generic", themeName)
                }

                function isDark(themeName) {
                    return isTheme("dark", themeName)
                }

                function isCompact(themeName) {
                    return isTheme("compact", themeName)
                }

                function themeReady(callback) {
                    _m_themes_callback.themeReadyCallback.add(callback)
                }

                function isWebFontLoaded(text, fontWeight) {
                    var _testElement$parentNo;
                    const document = _dom_adapter.default.getDocument();
                    const testElement = document.createElement("span");
                    testElement.style.position = "absolute";
                    testElement.style.top = "-9999px";
                    testElement.style.left = "-9999px";
                    testElement.style.visibility = "hidden";
                    testElement.style.fontFamily = "arial";
                    testElement.style.fontSize = "250px";
                    testElement.style.fontWeight = fontWeight;
                    testElement.innerHTML = text;
                    document.body.appendChild(testElement);
                    const etalonFontWidth = testElement.offsetWidth;
                    testElement.style.fontFamily = "roboto, 'roboto fallback', arial";
                    const testedFontWidth = testElement.offsetWidth;
                    null === (_testElement$parentNo = testElement.parentNode) || void 0 === _testElement$parentNo || _testElement$parentNo.removeChild(testElement);
                    return etalonFontWidth !== testedFontWidth
                }

                function waitWebFont(text, fontWeight) {
                    return new Promise((resolve => {
                        const clear = () => {
                            clearInterval(intervalId);
                            clearTimeout(timeoutId);
                            resolve()
                        };
                        const intervalId = setInterval((() => {
                            if (isWebFontLoaded(text, fontWeight)) {
                                clear()
                            }
                        }), 15);
                        const timeoutId = setTimeout(clear, 2e3)
                    }))
                }

                function autoInit() {
                    init({
                        _autoInit: true,
                        _forceTimeout: true
                    });
                    if ((0, _renderer.default)(DX_LINK_SELECTOR, context).length) {
                        throw _ui.default.Error("E0022")
                    }
                }
                if ((0, _window.hasWindow)()) {
                    autoInit()
                } else {
                    ready(autoInit)
                }
                viewPortChanged.add(((viewPort, prevViewPort) => {
                    initDeferred.done((() => {
                        detachCssClasses(prevViewPort);
                        attachCssClasses(viewPort)
                    }))
                }));
                _devices.default.changed.add((() => {
                    init({
                        _autoInit: true
                    })
                }));

                function resetTheme() {
                    var _$activeThemeLink;
                    null === (_$activeThemeLink = $activeThemeLink) || void 0 === _$activeThemeLink || _$activeThemeLink.attr("href", "about:blank");
                    currentThemeName = null;
                    pendingThemeName = null;
                    initDeferred = new _deferred.Deferred
                }

                function initialized(callback) {
                    initDeferred.done(callback)
                }

                function setDefaultTimeout(timeout) {
                    defaultTimeout = timeout
                }
                exports.default = {
                    setDefaultTimeout: setDefaultTimeout,
                    init: init,
                    initialized: initialized,
                    resetTheme: resetTheme,
                    ready: themeReady,
                    waitWebFont: waitWebFont,
                    isWebFontLoaded: isWebFontLoaded,
                    isCompact: isCompact,
                    isDark: isDark,
                    isGeneric: isGeneric,
                    isMaterial: isMaterial,
                    isFluent: isFluent,
                    isMaterialBased: isMaterialBased,
                    detachCssClasses: detachCssClasses,
                    attachCssClasses: attachCssClasses,
                    current: current,
                    waitForThemeLoad: waitForThemeLoad,
                    isPendingThemeLoaded: isPendingThemeLoaded
                }
            },
        6066:
            /*!**************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/events/m_swipe.js ***!
              \**************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.swipe = exports.start = exports.end = void 0;
                var _emitter_registrator = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/core/emitter_registrator */ 81411));
                var _emitter = _interopRequireDefault(__webpack_require__( /*! ../../common/core/events/gesture/emitter.gesture */ 85915));
                var _utils = __webpack_require__( /*! ../../common/core/events/utils */ 98834);
                var _size = __webpack_require__( /*! ../../core/utils/size */ 57653);

                function _interopRequireDefault(e) {
                    return e && e.__esModule ? e : {
                        default: e
                    }
                }
                const SWIPE_START_EVENT = exports.start = "dxswipestart";
                const SWIPE_EVENT = exports.swipe = "dxswipe";
                const SWIPE_END_EVENT = exports.end = "dxswipeend";
                const HorizontalStrategy = {
                    defaultItemSizeFunc() {
                        return (0, _size.getWidth)(this.getElement())
                    },
                    getBounds() {
                        return [this._maxLeftOffset, this._maxRightOffset]
                    },
                    calcOffsetRatio(e) {
                        const endEventData = (0, _utils.eventData)(e);
                        return (endEventData.x - (this._savedEventData && this._savedEventData.x || 0)) / this._itemSizeFunc().call(this, e)
                    },
                    isFastSwipe(e) {
                        const endEventData = (0, _utils.eventData)(e);
                        return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.x - this._tickData.x) >= endEventData.time - this._tickData.time
                    }
                };
                const VerticalStrategy = {
                    defaultItemSizeFunc() {
                        return (0, _size.getHeight)(this.getElement())
                    },
                    getBounds() {
                        return [this._maxTopOffset, this._maxBottomOffset]
                    },
                    calcOffsetRatio(e) {
                        const endEventData = (0, _utils.eventData)(e);
                        return (endEventData.y - (this._savedEventData && this._savedEventData.y || 0)) / this._itemSizeFunc().call(this, e)
                    },
                    isFastSwipe(e) {
                        const endEventData = (0, _utils.eventData)(e);
                        return this.FAST_SWIPE_SPEED_LIMIT * Math.abs(endEventData.y - this._tickData.y) >= endEventData.time - this._tickData.time
                    }
                };
                const STRATEGIES = {
                    horizontal: HorizontalStrategy,
                    vertical: VerticalStrategy
                };
                const SwipeEmitter = _emitter.default.inherit({
                    TICK_INTERVAL: 300,
                    FAST_SWIPE_SPEED_LIMIT: 10,
                    ctor(element) {
                        this.callBase(element);
                        this.direction = "horizontal";
                        this.elastic = true
                    },
                    _getStrategy() {
                        return STRATEGIES[this.direction]
                    },
                    _defaultItemSizeFunc() {
                        return this._getStrategy().defaultItemSizeFunc.call(this)
                    },
                    _itemSizeFunc() {
                        return this.itemSizeFunc || this._defaultItemSizeFunc
                    },
                    _init(e) {
                        this._tickData = (0, _utils.eventData)(e)
                    },
                    _start(e) {
                        this._savedEventData = (0, _utils.eventData)(e);
                        e = this._fireEvent(SWIPE_START_EVENT, e);
                        if (!e.cancel) {
                            this._maxLeftOffset = e.maxLeftOffset;
                            this._maxRightOffset = e.maxRightOffset;
                            this._maxTopOffset = e.maxTopOffset;
                            this._maxBottomOffset = e.maxBottomOffset
                        }
                    },
                    _move(e) {
                        const strategy = this._getStrategy();
                        const moveEventData = (0, _utils.eventData)(e);
                        let offset = strategy.calcOffsetRatio.call(this, e);
                        offset = this._fitOffset(offset, this.elastic);
                        if (moveEventData.time - this._tickData.time > this.TICK_INTERVAL) {
                            this._tickData = moveEventData
                        }
                        this._fireEvent(SWIPE_EVENT, e, {
                            offset: offset
                        });
                        if (false !== e.cancelable) {
                            e.preventDefault()
                        }
                    },
                    _end(e) {
                        const strategy = this._getStrategy();
                        const offsetRatio = strategy.calcOffsetRatio.call(this, e);
                        const isFast = strategy.isFastSwipe.call(this, e);
                        let startOffset = offsetRatio;
                        let targetOffset = this._calcTargetOffset(offsetRatio, isFast);
                        startOffset = this._fitOffset(startOffset, this.elastic);
                        targetOffset = this._fitOffset(targetOffset, false);
                        this._fireEvent(SWIPE_END_EVENT, e, {
                            offset: startOffset,
                            targetOffset: targetOffset
                        })
                    },
                    _fitOffset(offset, elastic) {
                        const strategy = this._getStrategy();
                        const bounds = strategy.getBounds.call(this);
                        if (offset < -bounds[0]) {
                            return elastic ? (-2 * bounds[0] + offset) / 3 : -bounds[0]
                        }
                        if (offset > bounds[1]) {
                            return elastic ? (2 * bounds[1] + offset) / 3 : bounds[1]
                        }
                        return offset
                    },
                    _calcTargetOffset(offsetRatio, isFast) {
                        let result;
                        if (isFast) {
                            result = Math.ceil(Math.abs(offsetRatio));
                            if (offsetRatio < 0) {
                                result = -result
                            }
                        } else {
                            result = Math.round(offsetRatio)
                        }
                        return result
                    }
                });
                (0, _emitter_registrator.default)({
                    emitter: SwipeEmitter,
                    events: [SWIPE_START_EVENT, SWIPE_EVENT, SWIPE_END_EVENT]
                })
            },
        6257:
            /*!*****************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/runtime/inferno/index.js ***!
              \*****************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                var _base_component = __webpack_require__( /*! ./base_component */ 5428);
                Object.keys(_base_component).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _base_component[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _base_component[key]
                        }
                    })
                }));
                var _create_context = __webpack_require__( /*! ./create_context */ 34781);
                Object.keys(_create_context).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _create_context[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _create_context[key]
                        }
                    })
                }));
                var _effect = __webpack_require__( /*! ./effect */ 2836);
                Object.keys(_effect).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _effect[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _effect[key]
                        }
                    })
                }));
                var _effect_host = __webpack_require__( /*! ./effect_host */ 23405);
                Object.keys(_effect_host).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _effect_host[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _effect_host[key]
                        }
                    })
                }));
                var _hydrate = __webpack_require__( /*! ./mocked/hydrate */ 11934);
                Object.keys(_hydrate).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _hydrate[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _hydrate[key]
                        }
                    })
                }));
                var _normalize_styles = __webpack_require__( /*! ./normalize_styles */ 75467);
                Object.keys(_normalize_styles).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _normalize_styles[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _normalize_styles[key]
                        }
                    })
                }));
                var _portal = __webpack_require__( /*! ./portal */ 37695);
                Object.keys(_portal).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _portal[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _portal[key]
                        }
                    })
                }));
                var _re_render_effect = __webpack_require__( /*! ./re_render_effect */ 31603);
                Object.keys(_re_render_effect).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _re_render_effect[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _re_render_effect[key]
                        }
                    })
                }));
                var _render_template = __webpack_require__( /*! ./render_template */ 90626);
                Object.keys(_render_template).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _render_template[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _render_template[key]
                        }
                    })
                }))
            },
        6285:
            /*!***************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/excel_exporter.js ***!
              \***************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "exportDataGrid", {
                    enumerable: true,
                    get: function() {
                        return _excel.exportDataGrid
                    }
                });
                Object.defineProperty(exports, "exportPivotGrid", {
                    enumerable: true,
                    get: function() {
                        return _excel.exportPivotGrid
                    }
                });
                var _excel = __webpack_require__( /*! ./common/export/excel */ 54594)
            },
        6909:
            /*!**************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/r1/utils/get_template.js ***!
              \**************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.getTemplate = void 0;
                var _inferno = __webpack_require__( /*! inferno */ 76231);
                exports.getTemplate = TemplateProp => TemplateProp && (TemplateProp.defaultProps ? props => (0, _inferno.normalizeProps)((0, _inferno.createComponentVNode)(2, TemplateProp, Object.assign({}, props))) : TemplateProp)
            },
        7201:
            /*!***********************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/core/m_guid.js ***!
              \***********************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Guid = void 0;
                var _class = (e = __webpack_require__( /*! ../../core/class */ 55620), e && e.__esModule ? e : {
                    default: e
                });
                var e;
                exports.Guid = _class.default.inherit({
                    ctor: function(value) {
                        if (value) {
                            value = String(value)
                        }
                        this._value = this._normalize(value || this._generate())
                    },
                    _normalize: function(value) {
                        value = value.replace(/[^a-f0-9]/gi, "").toLowerCase();
                        while (value.length < 32) {
                            value += "0"
                        }
                        return [value.substr(0, 8), value.substr(8, 4), value.substr(12, 4), value.substr(16, 4), value.substr(20, 12)].join("-")
                    },
                    _generate: function() {
                        let value = "";
                        for (let i = 0; i < 32; i++) {
                            value += Math.round(15 * Math.random()).toString(16)
                        }
                        return value
                    },
                    toString: function() {
                        return this._value
                    },
                    valueOf: function() {
                        return this._value
                    },
                    toJSON: function() {
                        return this._value
                    }
                })
            },
        8022:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/pie_series.js ***!
              \*********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.pie = exports.doughnut = exports.donut = void 0;
                var _common = __webpack_require__( /*! ../../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../core/utils/iterator */ 21274);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                var _bar_series = __webpack_require__( /*! ./bar_series */ 48971);
                var _scatter_series = __webpack_require__( /*! ./scatter_series */ 39294);
                const chartScatterSeries = _scatter_series.chart;
                const barSeries = _bar_series.chart.bar;
                const _extend = _extend2.extend;
                const _each = _iterator.each;
                const _noop = _common.noop;
                const _map = _utils.map;
                const _isFinite = isFinite;
                const _max = Math.max;
                const pie = exports.pie = _extend({}, barSeries, {
                    _setGroupsSettings() {
                        chartScatterSeries._setGroupsSettings.apply(this, arguments);
                        this._labelsGroup.attr({
                            "pointer-events": null
                        })
                    },
                    _createErrorBarGroup: _noop,
                    _drawPoint(options) {
                        const point = options.point;
                        const legendCallback = this._legendCallback;
                        chartScatterSeries._drawPoint.call(this, options);
                        !point.isVisible() && point.setInvisibility();
                        point.isSelected() && legendCallback()
                    },
                    _getOldPoint(data, oldPointsByArgument, index) {
                        const point = (this._points || [])[index];
                        if (point) {
                            oldPointsByArgument[point.argument.valueOf()] = oldPointsByArgument[point.argument.valueOf()].filter((p => p !== point))
                        }
                        return point
                    },
                    adjustLabels(moveLabelsFromCenter) {
                        return (this._points || []).reduce(((r, p) => {
                            if (p._label.isVisible()) {
                                p.setLabelTrackerData();
                                r = p.applyWordWrap(moveLabelsFromCenter) || r;
                                p.updateLabelCoord(moveLabelsFromCenter);
                                return r
                            }
                        }), false)
                    },
                    _applyElementsClipRect: _noop,
                    getColor: _noop,
                    areErrorBarsVisible: _noop,
                    drawLabelsWOPoints() {
                        if ("inside" === this._options.label.position) {
                            return false
                        }
                        this._labelsGroup.append(this._extGroups.labelsGroup);
                        (this._points || []).forEach((point => {
                            point.drawLabel()
                        }));
                        return true
                    },
                    getPointsCount() {
                        return this._data.filter((d => this._checkData(d))).length
                    },
                    setMaxPointsCount(count) {
                        this._pointsCount = count
                    },
                    _getCreatingPointOptions(data, dataIndex) {
                        return this._getPointOptions(data, dataIndex)
                    },
                    _updateOptions(options) {
                        this.labelSpace = 0;
                        this.innerRadius = "pie" === this.type ? 0 : options.innerRadius
                    },
                    _checkData(data, skippedFields) {
                        const base = barSeries._checkData.call(this, data, skippedFields, {
                            value: this.getValueFields()[0]
                        });
                        return this._options.paintNullPoints ? base : base && null !== data.value
                    },
                    _createGroups: chartScatterSeries._createGroups,
                    _setMarkerGroupSettings() {
                        this._markersGroup.attr({
                            class: "dxc-markers"
                        })
                    },
                    _getMainColor(data, point) {
                        const pointsByArg = this.getPointsByArg(data.argument);
                        const argumentIndex = point ? pointsByArg.indexOf(point) : pointsByArg.length;
                        return this._options.mainSeriesColor(data.argument, argumentIndex, this._pointsCount)
                    },
                    _getPointOptions(data) {
                        return this._parsePointOptions(this._preparePointOptions(), this._options.label, data)
                    },
                    _getRangeData() {
                        return this._rangeData
                    },
                    _createPointStyles(pointOptions, data, point) {
                        var _pointOptions$color;
                        const that = this;
                        const mainColor = (0, _utils.extractColor)(pointOptions.color, true) || that._getMainColor(data, point);
                        const colorId = null === (_pointOptions$color = pointOptions.color) || void 0 === _pointOptions$color ? void 0 : _pointOptions$color.fillId;
                        const hoverStyle = pointOptions.hoverStyle || {};
                        const selectionStyle = pointOptions.selectionStyle || {};
                        if (colorId) {
                            that._turnOffHatching(hoverStyle, selectionStyle)
                        }
                        return {
                            labelColor: mainColor,
                            normal: that._parsePointStyle(pointOptions, mainColor, mainColor),
                            hover: that._parsePointStyle(hoverStyle, colorId || mainColor, mainColor),
                            selection: that._parsePointStyle(selectionStyle, colorId || mainColor, mainColor),
                            legendStyles: {
                                normal: that._createLegendState(pointOptions, mainColor),
                                hover: that._createLegendState(hoverStyle, colorId || mainColor),
                                selection: that._createLegendState(selectionStyle, colorId || mainColor)
                            }
                        }
                    },
                    _getArrangeMinShownValue(points, total) {
                        const minSegmentSize = this._options.minSegmentSize;
                        let totalMinSegmentSize = 0;
                        let totalNotMinValues = 0;
                        total = total || points.length;
                        _each(points, ((_, point) => {
                            if (point.isVisible()) {
                                if (point.normalInitialValue < minSegmentSize * total / 360) {
                                    totalMinSegmentSize += minSegmentSize
                                } else {
                                    totalNotMinValues += point.normalInitialValue
                                }
                            }
                        }));
                        return totalMinSegmentSize < 360 ? minSegmentSize * totalNotMinValues / (360 - totalMinSegmentSize) : 0
                    },
                    _applyArrangeCorrection(points, minShownValue, total) {
                        const options = this._options;
                        const isClockWise = "anticlockwise" !== options.segmentsDirection;
                        const shiftedAngle = _isFinite(options.startAngle) ? (0, _utils.normalizeAngle)(options.startAngle) : 0;
                        const minSegmentSize = options.minSegmentSize;
                        let percent;
                        let correction = 0;
                        let zeroTotalCorrection = 0;
                        if (0 === total) {
                            total = points.filter((el => el.isVisible())).length;
                            zeroTotalCorrection = 1
                        }
                        _each(isClockWise ? points : points.concat([]).reverse(), ((_, point) => {
                            const val = point.isVisible() ? zeroTotalCorrection || point.normalInitialValue : 0;
                            let updatedZeroValue;
                            if (minSegmentSize && point.isVisible() && val < minShownValue) {
                                updatedZeroValue = minShownValue
                            }
                            percent = val / total;
                            point.correctValue(correction, percent, zeroTotalCorrection + (updatedZeroValue || 0));
                            point.shiftedAngle = shiftedAngle;
                            correction += updatedZeroValue || val
                        }));
                        this._rangeData = {
                            val: {
                                min: 0,
                                max: correction
                            }
                        }
                    },
                    _removePoint(point) {
                        const points = this.getPointsByArg(point.argument);
                        points.splice(points.indexOf(point), 1);
                        point.dispose()
                    },
                    arrangePoints() {
                        const that = this;
                        const originalPoints = that._points || [];
                        const minSegmentSize = that._options.minSegmentSize;
                        let minShownValue;
                        let isAllPointsNegative = true;
                        let i = 0;
                        const len = originalPoints.length;
                        while (i < len && isAllPointsNegative) {
                            isAllPointsNegative = originalPoints[i].value <= 0;
                            i++
                        }
                        const points = that._points = _map(originalPoints, (point => {
                            if (null === point.value || !isAllPointsNegative && point.value < 0) {
                                that._removePoint(point);
                                return null
                            } else {
                                return point
                            }
                        }));
                        const maxValue = points.reduce(((max, p) => _max(max, Math.abs(p.initialValue))), 0);
                        points.forEach((p => {
                            p.normalInitialValue = p.initialValue / (0 !== maxValue ? maxValue : 1)
                        }));
                        const total = points.reduce(((total, point) => total + (point.isVisible() ? point.normalInitialValue : 0)), 0);
                        if (minSegmentSize) {
                            minShownValue = this._getArrangeMinShownValue(points, total)
                        }
                        that._applyArrangeCorrection(points, minShownValue, total)
                    },
                    correctPosition(correction, canvas) {
                        _each(this._points, ((_, point) => {
                            point.correctPosition(correction)
                        }));
                        this.setVisibleArea(canvas)
                    },
                    correctRadius(correction) {
                        this._points.forEach((point => {
                            point.correctRadius(correction)
                        }))
                    },
                    correctLabelRadius(labelRadius) {
                        this._points.forEach((point => {
                            point.correctLabelRadius(labelRadius)
                        }))
                    },
                    setVisibleArea(canvas) {
                        this._visibleArea = {
                            minX: canvas.left,
                            maxX: canvas.width - canvas.right,
                            minY: canvas.top,
                            maxY: canvas.height - canvas.bottom
                        }
                    },
                    _applyVisibleArea: _noop,
                    _animate(firstDrawing) {
                        const that = this;
                        const points = that._points;
                        const pointsCount = points && points.length;
                        const completeFunc = function() {
                            that._animateComplete()
                        };
                        let animatePoint;
                        if (firstDrawing) {
                            animatePoint = function(p, i) {
                                p.animate(i === pointsCount - 1 ? completeFunc : void 0, .7, (1 - .7) * i / (pointsCount - 1))
                            }
                        } else {
                            animatePoint = function(p, i) {
                                p.animate(i === pointsCount - 1 ? completeFunc : void 0)
                            }
                        }
                        points.forEach(animatePoint)
                    },
                    getVisiblePoints() {
                        return _map(this._points, (p => p.isVisible() ? p : null))
                    },
                    getPointsByKeys(arg, argumentIndex) {
                        const pointsByArg = this.getPointsByArg(arg);
                        return pointsByArg[argumentIndex] && [pointsByArg[argumentIndex]] || []
                    }
                });
                exports.doughnut = pie;
                exports.donut = pie
            },
        8056:
            /*!************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/common/data/odata/utils.js ***!
              \************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                var _m_utils = __webpack_require__( /*! ../../../__internal/data/odata/m_utils */ 14606);
                Object.keys(_m_utils).forEach((function(key) {
                    if ("default" === key || "__esModule" === key) {
                        return
                    }
                    if (key in exports && exports[key] === _m_utils[key]) {
                        return
                    }
                    Object.defineProperty(exports, key, {
                        enumerable: true,
                        get: function() {
                            return _m_utils[key]
                        }
                    })
                }))
            },
        8315:
            /*!*********************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/translators/range.js ***!
              \*********************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.Range = void 0;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _type = __webpack_require__( /*! ../../../core/utils/type */ 11528);
                var _utils = __webpack_require__( /*! ../../viz/core/utils */ 98013);
                const _isDefined = _type.isDefined;
                const _isDate = _type.isDate;
                const _isFunction = _type.isFunction;

                function otherLessThan(thisValue, otherValue) {
                    return otherValue < thisValue
                }

                function otherGreaterThan(thisValue, otherValue) {
                    return otherValue > thisValue
                }

                function compareAndReplace(thisValue, otherValue, setValue, compare) {
                    const otherValueDefined = _isDefined(otherValue);
                    if (_isDefined(thisValue)) {
                        if (otherValueDefined && compare(thisValue, otherValue)) {
                            setValue(otherValue)
                        }
                    } else if (otherValueDefined) {
                        setValue(otherValue)
                    }
                }
                const Range = function(range) {
                    range && (0, _extend.extend)(this, range)
                };
                exports.Range = Range;
                const _Range = Range;
                _Range.prototype = {
                    constructor: _Range,
                    addRange(otherRange) {
                        const that = this;
                        const {
                            categories: categories
                        } = that;
                        const otherCategories = otherRange.categories;
                        const isDiscrete = "discrete" === that.axisType;
                        const compareAndReplaceByField = function(field, compare) {
                            compareAndReplace(that[field], otherRange[field], (value => {
                                that[field] = value
                            }), compare)
                        };
                        const controlValuesByVisibleBounds = function(valueField, visibleValueField, compare) {
                            compareAndReplace(that[valueField], that[visibleValueField], (value => {
                                _isDefined(that[valueField]) && (that[valueField] = value)
                            }), compare)
                        };
                        const checkField = function(field) {
                            that[field] = that[field] || otherRange[field]
                        };
                        checkField("invert");
                        checkField("containsConstantLine");
                        checkField("axisType");
                        checkField("dataType");
                        checkField("isSpacedMargin");
                        if ("logarithmic" === that.axisType) {
                            checkField("base")
                        } else {
                            that.base = void 0
                        }
                        compareAndReplaceByField("min", otherLessThan);
                        compareAndReplaceByField("max", otherGreaterThan);
                        if (isDiscrete) {
                            checkField("minVisible");
                            checkField("maxVisible")
                        } else {
                            compareAndReplaceByField("minVisible", otherLessThan);
                            compareAndReplaceByField("maxVisible", otherGreaterThan)
                        }
                        compareAndReplaceByField("interval", otherLessThan);
                        if (!isDiscrete) {
                            controlValuesByVisibleBounds("min", "minVisible", otherLessThan);
                            controlValuesByVisibleBounds("min", "maxVisible", otherLessThan);
                            controlValuesByVisibleBounds("max", "maxVisible", otherGreaterThan);
                            controlValuesByVisibleBounds("max", "minVisible", otherGreaterThan)
                        }
                        if (void 0 === categories) {
                            that.categories = otherCategories
                        } else {
                            that.categories = otherCategories ? (0, _utils.unique)(categories.concat(otherCategories)) : categories
                        }
                        if ("logarithmic" === that.axisType) {
                            checkField("allowNegatives");
                            compareAndReplaceByField("linearThreshold", otherLessThan)
                        }
                        return that
                    },
                    isEmpty() {
                        return (!_isDefined(this.min) || !_isDefined(this.max)) && (!this.categories || 0 === this.categories.length)
                    },
                    correctValueZeroLevel() {
                        const that = this;
                        if (_isDate(that.max) || _isDate(that.min)) {
                            return that
                        }

                        function setZeroLevel(min, max) {
                            that[min] < 0 && that[max] < 0 && (that[max] = 0);
                            that[min] > 0 && that[max] > 0 && (that[min] = 0)
                        }
                        setZeroLevel("min", "max");
                        setZeroLevel("minVisible", "maxVisible");
                        return that
                    },
                    sortCategories(sort) {
                        if (false === sort || !this.categories) {
                            return
                        }
                        if (Array.isArray(sort)) {
                            const sortValues = sort.map((item => item.valueOf()));
                            const filteredSeriesCategories = this.categories.filter((item => !sortValues.includes(item.valueOf())));
                            this.categories = sort.concat(filteredSeriesCategories)
                        } else {
                            const notAFunction = !_isFunction(sort);
                            if (notAFunction && "string" !== this.dataType) {
                                sort = (a, b) => a.valueOf() - b.valueOf()
                            } else if (notAFunction) {
                                sort = false
                            }
                            sort && this.categories.sort(sort)
                        }
                    }
                }
            },
        8593:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/vector_map/projection.main.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.projection = exports.Projection = void 0;
                var _extend = __webpack_require__( /*! ../../../core/utils/extend */ 52576);
                var _event_emitter = __webpack_require__( /*! ../../viz/vector_map/event_emitter */ 13612);
                const _Number = Number;
                const _min = Math.min;
                const _max = Math.max;
                const _abs = Math.abs;
                const _round = Math.round;
                const _ln = Math.log;
                const TWO_TO_LN2 = 2 / Math.LN2;
                const DEFAULT_CENTER = [NaN, NaN];

                function floatsEqual(f1, f2) {
                    return _abs(f1 - f2) < 1e-8
                }

                function arraysEqual(a1, a2) {
                    return floatsEqual(a1[0], a2[0]) && floatsEqual(a1[1], a2[1])
                }

                function parseAndClamp(value, minValue, maxValue, defaultValue) {
                    const val = _Number(value);
                    return isFinite(val) ? _min(_max(val, minValue), maxValue) : defaultValue
                }

                function parseAndClampArray(value, minValue, maxValue, defaultValue) {
                    return [parseAndClamp(value[0], minValue[0], maxValue[0], defaultValue[0]), parseAndClamp(value[1], minValue[1], maxValue[1], defaultValue[1])]
                }

                function getEngine(engine) {
                    return engine instanceof Engine && engine || projection.get(engine) || projection(engine) || projection.get("mercator")
                }
                const Projection = function(parameters) {
                    this._initEvents();
                    this._params = parameters;
                    this._engine = getEngine();
                    this._center = this._engine.center();
                    this._adjustCenter()
                };
                exports.Projection = Projection;
                Projection.prototype = {
                    constructor: Projection,
                    _minZoom: 1,
                    _maxZoom: 256,
                    _zoom: 1,
                    _center: DEFAULT_CENTER,
                    _canvas: {},
                    _scale: [],
                    dispose() {
                        this._disposeEvents()
                    },
                    setEngine(value) {
                        const that = this;
                        const engine = getEngine(value);
                        if (that._engine !== engine) {
                            that._engine = engine;
                            that._fire("engine");
                            if (that._changeCenter(engine.center())) {
                                that._triggerCenterChanged()
                            }
                            if (that._changeZoom(that._minZoom)) {
                                that._triggerZoomChanged()
                            }
                            that._adjustCenter();
                            that._setupScreen()
                        }
                    },
                    setBounds(bounds) {
                        if (void 0 !== bounds) {
                            this.setEngine(this._engine.original().bounds(bounds))
                        }
                    },
                    _setupScreen() {
                        const that = this;
                        const canvas = that._canvas;
                        const width = canvas.width;
                        const height = canvas.height;
                        const engine = that._engine;
                        const aspectRatio = engine.ar();
                        that._x0 = canvas.left + width / 2;
                        that._y0 = canvas.top + height / 2;
                        const min = [that.project([engine.min()[0], 0])[0], that.project([0, engine.min()[1]])[1]];
                        const max = [that.project([engine.max()[0], 0])[0], that.project([0, engine.max()[1]])[1]];
                        const screenAR = width / height;
                        const boundsAR = _abs(max[0] - min[0]) / _abs(max[1] - min[1]);
                        let correction;
                        if (isNaN(boundsAR) || 0 === boundsAR || _min(screenAR, aspectRatio) <= aspectRatio * boundsAR && aspectRatio * boundsAR <= _max(screenAR, aspectRatio)) {
                            correction = 1
                        } else {
                            correction = boundsAR > 1 ? boundsAR : 1 / boundsAR
                        }
                        if (aspectRatio * boundsAR >= screenAR) {
                            that._xRadius = width / 2 / correction;
                            that._yRadius = width / 2 / (aspectRatio * correction)
                        } else {
                            that._xRadius = height / 2 * (aspectRatio / correction);
                            that._yRadius = height / 2 / correction
                        }
                        that._fire("screen")
                    },
                    setSize(canvas) {
                        this._canvas = canvas;
                        this._setupScreen()
                    },
                    getCanvas() {
                        return this._canvas
                    },
                    _toScreen(coordinates) {
                        return [this._x0 + this._xRadius * coordinates[0], this._y0 + this._yRadius * coordinates[1]]
                    },
                    _fromScreen(coordinates) {
                        return [(coordinates[0] - this._x0) / this._xRadius, (coordinates[1] - this._y0) / this._yRadius]
                    },
                    _toTransformed(coordinates) {
                        return [coordinates[0] * this._zoom + this._xCenter, coordinates[1] * this._zoom + this._yCenter]
                    },
                    _toTransformedFast(coordinates) {
                        return [coordinates[0] * this._zoom, coordinates[1] * this._zoom]
                    },
                    _fromTransformed(coordinates) {
                        return [(coordinates[0] - this._xCenter) / this._zoom, (coordinates[1] - this._yCenter) / this._zoom]
                    },
                    _adjustCenter() {
                        const center = this._engine.project(this._center);
                        this._xCenter = -center[0] * this._zoom || 0;
                        this._yCenter = -center[1] * this._zoom || 0
                    },
                    project(coordinates) {
                        return this._engine.project(coordinates)
                    },
                    transform(coordinates) {
                        return this._toScreen(this._toTransformedFast(coordinates))
                    },
                    isInvertible() {
                        return this._engine.isInvertible()
                    },
                    getSquareSize(size) {
                        return [size[0] * this._zoom * this._xRadius, size[1] * this._zoom * this._yRadius]
                    },
                    getZoom() {
                        return this._zoom
                    },
                    _changeZoom(value) {
                        const that = this;
                        const oldZoom = that._zoom;
                        const newZoom = that._zoom = parseAndClamp(value, that._minZoom, that._maxZoom, that._minZoom);
                        const isChanged = !floatsEqual(oldZoom, newZoom);
                        if (isChanged) {
                            that._adjustCenter();
                            that._fire("zoom")
                        }
                        return isChanged
                    },
                    setZoom(value) {
                        if (this._engine.isInvertible() && this._changeZoom(value)) {
                            this._triggerZoomChanged()
                        }
                    },
                    getScaledZoom() {
                        return _round((this._scale.length - 1) * _ln(this._zoom) / _ln(this._maxZoom))
                    },
                    setScaledZoom(scaledZoom) {
                        this.setZoom(this._scale[_round(scaledZoom)])
                    },
                    changeScaledZoom(deltaZoom) {
                        this.setZoom(this._scale[_max(_min(_round(this.getScaledZoom() + deltaZoom), this._scale.length - 1), 0)])
                    },
                    getZoomScalePartition() {
                        return this._scale.length - 1
                    },
                    _setupScaling() {
                        const that = this;
                        const k = _max(_round(TWO_TO_LN2 * _ln(that._maxZoom)), 4);
                        const step = that._maxZoom ** (1 / k);
                        let zoom = that._minZoom;
                        that._scale = [zoom];
                        for (let i = 1; i <= k; ++i) {
                            that._scale.push(zoom *= step)
                        }
                    },
                    setMaxZoom(maxZoom) {
                        const that = this;
                        that._minZoom = 1;
                        that._maxZoom = parseAndClamp(maxZoom, that._minZoom, _Number.MAX_VALUE, 256);
                        that._setupScaling();
                        if (that._zoom > that._maxZoom) {
                            that.setZoom(that._maxZoom)
                        }
                        that._fire("max-zoom")
                    },
                    getCenter() {
                        return this._center.slice()
                    },
                    setCenter(value) {
                        if (this._engine.isInvertible() && this._changeCenter(value || [])) {
                            this._triggerCenterChanged()
                        }
                    },
                    _changeCenter(value) {
                        const that = this;
                        const engine = that._engine;
                        const oldCenter = that._center;
                        const newCenter = that._center = parseAndClampArray(value, engine.min(), engine.max(), engine.center());
                        const isChanged = !arraysEqual(oldCenter, newCenter);
                        if (isChanged) {
                            that._adjustCenter();
                            that._fire("center")
                        }
                        return isChanged
                    },
                    _triggerCenterChanged() {
                        this._params.centerChanged(this.getCenter())
                    },
                    _triggerZoomChanged() {
                        this._params.zoomChanged(this.getZoom())
                    },
                    setCenterByPoint(coordinates, screenPosition) {
                        const p = this._engine.project(coordinates);
                        const q = this._fromScreen(screenPosition);
                        this.setCenter(this._engine.unproject([-q[0] / this._zoom + p[0], -q[1] / this._zoom + p[1]]))
                    },
                    beginMoveCenter() {
                        if (this._engine.isInvertible()) {
                            this._moveCenter = this._center
                        }
                    },
                    endMoveCenter() {
                        const that = this;
                        if (that._moveCenter) {
                            if (!arraysEqual(that._moveCenter, that._center)) {
                                that._triggerCenterChanged()
                            }
                            that._moveCenter = null
                        }
                    },
                    moveCenter(shift) {
                        const that = this;
                        if (that._moveCenter) {
                            const current = that.toScreenPoint(that._center);
                            that._changeCenter(that.fromScreenPoint([current[0] + shift[0], current[1] + shift[1]]))
                        }
                    },
                    getViewport() {
                        const unproject = this._engine.unproject;
                        const lt = unproject(this._fromTransformed([-1, -1]));
                        const lb = unproject(this._fromTransformed([-1, 1]));
                        const rt = unproject(this._fromTransformed([1, -1]));
                        const rb = unproject(this._fromTransformed([1, 1]));
                        const minMax = findMinMax([selectFarthestPoint(lt[0], lb[0], rt[0], rb[0]), selectFarthestPoint(lt[1], rt[1], lb[1], rb[1])], [selectFarthestPoint(rt[0], rb[0], lt[0], lb[0]), selectFarthestPoint(lb[1], rb[1], lt[1], rt[1])]);
                        return [].concat(minMax.min[0], minMax.max[1], minMax.max[0], minMax.min[1])
                    },
                    setViewport(viewport) {
                        const engine = this._engine;
                        const data = viewport ? function(project, unproject, viewport) {
                            const lt = project([viewport[0], viewport[3]]);
                            const lb = project([viewport[0], viewport[1]]);
                            const rt = project([viewport[2], viewport[3]]);
                            const rb = project([viewport[2], viewport[1]]);
                            const l = selectClosestPoint(lt[0], lb[0], rt[0], rb[0]);
                            const r = selectClosestPoint(rt[0], rb[0], lt[0], lb[0]);
                            const t = selectClosestPoint(lt[1], rt[1], lb[1], rb[1]);
                            const b = selectClosestPoint(lb[1], rb[1], lt[1], rt[1]);
                            return [2 / _max(_abs(l - r), _abs(t - b)), unproject([(l + r) / 2, (t + b) / 2])]
                        }(engine.project, engine.unproject, viewport) : [this._minZoom, engine.center()];
                        this.setZoom(data[0]);
                        this.setCenter(data[1])
                    },
                    getTransform() {
                        return {
                            translateX: this._xCenter * this._xRadius,
                            translateY: this._yCenter * this._yRadius
                        }
                    },
                    fromScreenPoint(coordinates) {
                        return this._engine.unproject(this._fromTransformed(this._fromScreen(coordinates)))
                    },
                    toScreenPoint(coordinates) {
                        return this._toScreen(this._toTransformed(this._engine.project(coordinates)))
                    },
                    _eventNames: ["engine", "screen", "center", "zoom", "max-zoom"]
                };
                (0, _event_emitter.makeEventEmitter)(Projection);

                function selectFarthestPoint(point1, point2, basePoint1, basePoint2) {
                    const basePoint = (basePoint1 + basePoint2) / 2;
                    return _abs(point1 - basePoint) > _abs(point2 - basePoint) ? point1 : point2
                }

                function selectClosestPoint(point1, point2, basePoint1, basePoint2) {
                    const basePoint = (basePoint1 + basePoint2) / 2;
                    return _abs(point1 - basePoint) < _abs(point2 - basePoint) ? point1 : point2
                }

                function setMinMax(engine, p1, p2) {
                    const {
                        min: min,
                        max: max
                    } = findMinMax(p1, p2);
                    engine.min = returnArray(min);
                    engine.max = returnArray(max)
                }
                const Engine = class {
                    constructor(parameters) {
                        const project = (method = parameters.to, arg => invertVerticalAxis(method(arg)));
                        var method;
                        const unproject = parameters.from ? function(method) {
                            return arg => method(invertVerticalAxis(arg))
                        }(parameters.from) : returnValue(DEFAULT_CENTER);
                        this.project = project;
                        this.unproject = unproject;
                        this.original = returnValue(this);
                        this.source = function() {
                            return (0, _extend.extend)({}, parameters)
                        };
                        this.isInvertible = returnValue(!!parameters.from);
                        this.ar = returnValue(parameters.aspectRatio > 0 ? _Number(parameters.aspectRatio) : 1);
                        this.center = returnArray(unproject([0, 0]));
                        setMinMax(this, [unproject([-1, 0])[0], unproject([0, 1])[1]], [unproject([1, 0])[0], unproject([0, -1])[1]])
                    }
                    aspectRatio(aspectRatio) {
                        const engine = new Engine((0, _extend.extend)(this.source(), {
                            aspectRatio: aspectRatio
                        }));
                        engine.original = this.original;
                        engine.min = this.min;
                        engine.max = this.max;
                        return engine
                    }
                    bounds(bounds) {
                        bounds = bounds || [];
                        const parameters = this.source();
                        const min = this.min();
                        const max = this.max();
                        const b1 = parseAndClampArray([bounds[0], bounds[1]], min, max, min);
                        const b2 = parseAndClampArray([bounds[2], bounds[3]], min, max, max);
                        const p1 = parameters.to(b1);
                        const p2 = parameters.to(b2);
                        const delta = _min(_abs(p2[0] - p1[0]) > 1.54320987654321e-7 ? _abs(p2[0] - p1[0]) : 2, _abs(p2[1] - p1[1]) > 1.54320987654321e-7 ? _abs(p2[1] - p1[1]) : 2);
                        if (delta < 2) {
                            (0, _extend.extend)(parameters, function(project, unproject, p1, p2, delta) {
                                const x0 = (p1[0] + p2[0]) / 2 - delta / 2;
                                const y0 = (p1[1] + p2[1]) / 2 - delta / 2;
                                const k = 2 / delta;
                                return {
                                    to(coordinates) {
                                        const [p0, p1] = project(coordinates);
                                        return [(p0 - x0) * k - 1, (p1 - y0) * k - 1]
                                    },
                                    from: coordinates => unproject([x0 + (coordinates[0] + 1) / k, y0 + (coordinates[1] + 1) / k])
                                }
                            }(parameters.to, parameters.from, p1, p2, delta))
                        }
                        const engine = new Engine(parameters);
                        engine.original = this.original;
                        setMinMax(engine, b1, b2);
                        return engine
                    }
                };

                function invertVerticalAxis(pair) {
                    return [pair[0], -pair[1]]
                }

                function returnValue(value) {
                    return () => value
                }

                function returnArray(value) {
                    return () => value.slice()
                }

                function findMinMax(p1, p2) {
                    return {
                        min: [_min(p1[0], p2[0]), _min(p1[1], p2[1])],
                        max: [_max(p1[0], p2[0]), _max(p1[1], p2[1])]
                    }
                }
                const projection = function(parameters) {
                    return parameters && parameters.to ? new Engine(parameters) : null
                };
                exports.projection = projection;
                const projectionsCache = {};
                projection.get = function(name) {
                    return projectionsCache[name] || null
                };
                projection.add = function(name, engine) {
                    engine = engine instanceof Engine && engine || projection(engine);
                    if (!projectionsCache[name] && engine) {
                        projectionsCache[name] = engine
                    }
                    return projection
                }
            },
        8710:
            /*!*******************************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/scheduler/utils/macro_task_array/dispatcher.js ***!
              \*******************************************************************************************************/
            (__unused_webpack_module, exports) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.macroTaskIdSet = exports.default = void 0;
                const macroTaskIdSet = exports.macroTaskIdSet = new Set;
                exports.default = {
                    schedule: async (callback, macroTaskTimeoutMs) => new Promise((resolve => {
                        const taskId = setTimeout((() => {
                            callback();
                            macroTaskIdSet.delete(taskId);
                            resolve()
                        }), macroTaskTimeoutMs);
                        macroTaskIdSet.add(taskId)
                    })),
                    dispose: () => {
                        Array.from(macroTaskIdSet).forEach((id => {
                            clearTimeout(id);
                            macroTaskIdSet.delete(id)
                        }))
                    }
                }
            },
        8731:
            /*!******************************************************************************************!*\
              !*** ./artifacts/transpiled-renovation-npm/__internal/viz/series/points/symbol_point.js ***!
              \******************************************************************************************/
            (__unused_webpack_module, exports, __webpack_require__) => {
                Object.defineProperty(exports, "__esModule", {
                    value: true
                });
                exports.default = void 0;
                var _common = __webpack_require__( /*! ../../../../core/utils/common */ 17781);
                var _extend2 = __webpack_require__( /*! ../../../../core/utils/extend */ 52576);
                var _iterator = __webpack_require__( /*! ../../../../core/utils/iterator */ 21274);
                var _type = __webpack_require__( /*! ../../../../core/utils/type */ 11528);
                var _window = __webpack_require__( /*! ../../../../core/utils/window */ 3104);
                var _utils = __webpack_require__( /*! ../../../viz/core/utils */ 98013);
                var _label = __webpack_require__( /*! ../../../viz/series/points/label */ 95390);
                const window = (0, _window.getWindow)();
                const _extend = _extend2.extend;
                const _math = Math;
                const _round = _math.round;
                const _floor = _math.floor;
                const _ceil = _math.ceil;
                exports.default = {
                    deleteLabel() {
                        this._label.dispose();
                        this._label = null
                    },
                    _hasGraphic() {
                        return this.graphic
                    },
                    clearVisibility() {
                        const graphic = this.graphic;
                        if (graphic && graphic.attr("visibility")) {
                            graphic.attr({
                                visibility: null
                            })
                        }
                    },
                    isVisible() {
                        return this.inVisibleArea && this.series.isVisible()
                    },
                    setInvisibility() {
                        const graphic = this.graphic;
                        if (graphic && "hidden" !== graphic.attr("visibility")) {
                            graphic.attr({
                                visibility: "hidden"
                            })
                        }
                        this._errorBar && this._errorBar.attr({
                            visibility: "hidden"
                        });
                        this._label.draw(false)
                    },
                    clearMarker() {
                        const graphic = this.graphic;
                        graphic && graphic.attr(this._emptySettings)
                    },
                    _createLabel() {
                        this._label = new _label.Label({
                            renderer: this.series._renderer,
                            labelsGroup: this.series._labelsGroup,
                            point: this
                        })
                    },
                    _calculateVisibility(x, y) {
                        const {
                            minX: minX,
                            maxX: maxX,
                            minY: minY,
                            maxY: maxY
                        } = this._getVisibleArea();
                        this.inVisibleArea = minX <= x && maxX >= x && minY <= y && maxY >= y
                    },
                    _updateLabelData() {
                        this._label.setData(this._getLabelFormatObject())
                    },
                    _updateLabelOptions() {
                        !this._label && this._createLabel();
                        this._label.setOptions(this._options.label)
                    },
                    _checkImage: image => (0, _type.isDefined)(image) && ("string" === typeof image || (0, _type.isDefined)(image.url)),
                    _fillStyle() {
                        this._styles = this._options.styles
                    },
                    _checkSymbol(oldOptions, newOptions) {
                        const oldSymbol = oldOptions.symbol;
                        const newSymbol = newOptions.symbol;
                        const symbolChanged = "circle" === oldSymbol && "circle" !== newSymbol || "circle" !== oldSymbol && "circle" === newSymbol;
                        const imageChanged = this._checkImage(oldOptions.image) !== this._checkImage(newOptions.image);
                        return !!(symbolChanged || imageChanged)
                    },
                    _populatePointShape(symbol, radius) {
                        switch (symbol) {
                            case "square":
                                return function(radius) {
                                    return [-radius, -radius, radius, -radius, radius, radius, -radius, radius, -radius, -radius]
                                }(radius);
                            case "polygon":
                                return function(radius) {
                                    const r = _ceil(radius);
                                    return [-r, 0, 0, -r, r, 0, 0, r, -r, 0]
                                }(radius);
                            case "triangle":
                            case "triangleDown":
                                return function(radius) {
                                    return [-radius, -radius, radius, -radius, 0, radius, -radius, -radius]
                                }(radius);
                            case "triangleUp":
                                return function(radius) {
                                    return [-radius, radius, radius, radius, 0, -radius, -radius, radius]
                                }(radius);
                            case "cross":
                                return function(radius) {
                                    const r = _ceil(radius);
                                    const floorHalfRadius = _floor(r / 2);
                                    const ceilHalfRadius = _ceil(r / 2);
                                    return [-r, -floorHalfRadius, -floorHalfRadius, -r, 0, -ceilHalfRadius, floorHalfRadius, -r, r, -floorHalfRadius, ceilHalfRadius, 0, r, floorHalfRadius, floorHalfRadius, r, 0, ceilHalfRadius, -floorHalfRadius, r, -r, floorHalfRadius, -ceilHalfRadius, 0]
                                }(radius)
                        }
                    },
                    hasCoords() {
                        return null !== this.x && null !== this.y
                    },
                    correctValue(correction) {
                        const that = this;
                        const axis = that.series.getValueAxis();
                        if (that.hasValue()) {
                            that.value = that.properValue = axis.validateUnit(that.initialValue.valueOf() + correction.valueOf());
                            that.minValue = axis.validateUnit(correction)
                        }
                    },
                    resetCorrection() {
                        this.value = this.properValue = this.initialValue;
                        this.minValue = "canvas_position_default"
                    },
                    resetValue() {
                        const that = this;
                        if (that.hasValue()) {
                            that.value = that.properValue = that.initialValue = 0;
                            that.minValue = 0;
                            that._label.setDataField("value", that.value)
                        }
                    },
                    _getTranslates(animationEnabled) {
                        let translateX = this.x;
                        let translateY = this.y;
                        if (animationEnabled) {
                            if (this._options.rotated) {
                                translateX = this.defaultX
                            } else {
                                translateY = this.defaultY
                            }
                        }
                        return {
                            x: translateX,
                            y: translateY
                        }
                    },
                    _createImageMarker(renderer, settings, options) {
                        const width = options.width || 20;
                        const height = options.height || 20;
                        return renderer.image(-_ro