/*!
* DevExtreme (dx.ai-integration.js)
* Version: 25.2.3
* Build date: Mon Dec 15 2025
*
* Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
* Read about DevExtreme licensing here: https://js.devexpress.com/Licensing/
*/
"use strict";(()=>{var e={1956:(e,t)=>{t.version=t.fullVersion=void 0;t.version="25.2.3",t.fullVersion="25.2.3"},5583:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;var r,a=(r=n(67264))&&r.__esModule?r:{default:r};t.default=(0,a.default)({E0001:"Method is not implemented",E0002:"Member name collision: {0}",E0003:"A class must be instantiated using the 'new' keyword",E0004:"The NAME property of the component is not specified",E0005:"Unknown device",E0006:"Unknown endpoint key is requested",E0007:"'Invalidate' method is called outside the update transaction",E0008:"Type of the option name is not appropriate to create an action",E0009:"Component '{0}' has not been initialized for an element",E0010:"Animation configuration with the '{0}' type requires '{1}' configuration as {2}",E0011:"Unknown animation type '{0}'",E0012:"jQuery version is too old. Please upgrade jQuery to 1.10.0 or later",E0013:"KnockoutJS version is too old. Please upgrade KnockoutJS to 2.3.0 or later",E0014:"The 'release' method shouldn't be called for an unlocked Lock object",E0015:"Queued task returned an unexpected result",E0017:"Event namespace is not defined",E0018:"DevExpress.ui.DevExpressPopup widget is required",E0020:"Template engine '{0}' is not supported",E0021:"Unknown theme is set: {0}",E0022:"LINK[rel=DevExpress-theme] tags must go before DevExpress included scripts",E0023:"Template name is not specified",E0024:"DevExtreme bundle already included",E0025:"Unexpected argument type",E0100:"Unknown validation type is detected",E0101:"Misconfigured range validation rule is detected",E0102:"Misconfigured comparison validation rule is detected",E0103:"validationCallback of an asynchronous rule should return a jQuery or a native promise",E0110:"Unknown validation group is detected",E0120:"Adapter for a DevExpressValidator component cannot be configured",E0121:"The 'customItem' parameter of the 'onCustomItemCreating' function is empty or contains invalid data. Assign a custom object or a Promise that is resolved after the item is created.",E0122:"AIIntegration: The sendRequest method is missing.",W0000:"'{0}' is deprecated in {1}. {2}",W0001:"{0} - '{1}' option is deprecated in {2}. {3}",W0002:"{0} - '{1}' method is deprecated in {2}. {3}",W0003:"{0} - '{1}' property is deprecated in {2}. {3}",W0004:"Timeout for theme loading is over: {0}",W0005:"'{0}' event is deprecated in {1}. {2}",W0006:"Invalid recurrence rule: '{0}'",W0007:"'{0}' Globalize culture is not defined",W0008:"Invalid view type: {0}",W0009:"Invalid time zone name: '{0}'",W0010:"{0} is deprecated in {1}. {2}",W0011:"Number parsing is invoked while the parser is not defined",W0012:"Date parsing is invoked while the parser is not defined",W0013:"'{0}' file is deprecated in {1}. {2}",W0014:"{0} - '{1}' type is deprecated in {2}. {3}",W0015:"Instead of returning a value from the '{0}' function, write it into the '{1}' field of the function's parameter.",W0016:'The "{0}" option does not accept the "{1}" value since v{2}. {3}.',W0017:'Setting the "{0}" property with a function is deprecated since v21.2',W0018:'Setting the "position" property with a function is deprecated since v21.2',W0019:"DevExtreme: Unable to Locate a Valid License Key.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nIf you are using a 30-day trial version of DevExtreme, you must uninstall all copies of DevExtreme once your 30-day trial period expires. For terms and conditions that govern use of DevExtreme UI components/libraries, please refer to the DevExtreme End User License Agreement: https://js.devexpress.com/EULAs/DevExtremeComplete.\n\nTo use DevExtreme in a commercial project, you must purchase a license. For pricing/licensing options, please visit: https://js.devexpress.com/Buy.\n\nIf you have licensing-related questions or need help with a purchase, please email clientservices@devexpress.com.\n\n",W0020:"DevExtreme: License Key Has Expired.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nA mismatch exists between the license key used and the DevExtreme version referenced in this project.\n\nTo proceed, you can:\n\u2022 use a version of DevExtreme linked to your license key: https://www.devexpress.com/ClientCenter/DownloadManager\n\u2022 renew your DevExpress Subscription: https://www.devexpress.com/buy/renew (once you renew your subscription, you will be entitled to product updates and support service as defined in the DevExtreme End User License Agreement)\n\nIf you have licensing-related questions or need help with a renewal, please email clientservices@devexpress.com.\n\n",W0021:"DevExtreme: License Key Verification Has Failed.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nTo verify your DevExtreme license, make certain to specify a correct key in the GlobalConfig. If you continue to encounter this error, please visit https://www.devexpress.com/ClientCenter/DownloadManager to obtain a valid license key.\n\nIf you have a valid license and this problem persists, please submit a support ticket via the DevExpress Support Center. We will be happy to follow-up: https://supportcenter.devexpress.com/ticket/create.\n\n",W0022:"DevExtreme: Pre-release software. Not suitable for commercial use.\n\nDetailed license/registration related information and instructions: https://js.devexpress.com/Documentation/Licensing/.\n\nPre-release software may contain deficiencies and as such, should not be considered for use or integrated in any mission critical application.\n\n",W0023:"DevExtreme: the following 'devextreme' package version does not match versions of other DevExpress products used in this application:\n\n{0}\n\nInteroperability between different versions of the products listed herein cannot be guaranteed.\n\n",W0024:"DevExtreme: Use Your DevExtreme License Key - Not Your DevExpress .NET License Key\n\nInvalid/incorrect license key. You used your DevExpress .NET license key instead of your DevExtreme (React, Angular, Vue, JS) license key. Please copy your DevExtreme license key and try again. \n\nGo to https://www.devexpress.com/ClientCenter/DownloadManager (navigate to the DevExtreme Subscription section) to obtain a valid DevExtreme license key. To validate your license, specify the correct key within GlobalConfig.\n\nFor detailed license/registration information, visit https://js.devexpress.com/Documentation/Licensing/.\n\nIf you have a valid license and the issue persists, submit a support ticket via the DevExpress Support Center. We will be happy to follow-up: https://supportcenter.devexpress.com/ticket/create.\n\n"})},5654:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ChangeStyleCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"changeStyle"}buildPromptData(e){return{system:{writingStyle:e.writingStyle},user:{text:e.text}}}parseResult(e){return e}}t.ChangeStyleCommand=a},11121:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ProofreadCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"proofread"}buildPromptData(e){return{user:{text:e.text}}}parseResult(e){return e}}t.ProofreadCommand=a},11528:(e,t,n)=>{Object.defineProperty(t,"isBoolean",{enumerable:!0,get:function(){return r.isBoolean}}),Object.defineProperty(t,"isDate",{enumerable:!0,get:function(){return r.isDate}}),Object.defineProperty(t,"isDeferred",{enumerable:!0,get:function(){return r.isDeferred}}),Object.defineProperty(t,"isDefined",{enumerable:!0,get:function(){return r.isDefined}}),Object.defineProperty(t,"isEmptyObject",{enumerable:!0,get:function(){return r.isEmptyObject}}),Object.defineProperty(t,"isEvent",{enumerable:!0,get:function(){return r.isEvent}}),Object.defineProperty(t,"isExponential",{enumerable:!0,get:function(){return r.isExponential}}),Object.defineProperty(t,"isFunction",{enumerable:!0,get:function(){return r.isFunction}}),Object.defineProperty(t,"isNumeric",{enumerable:!0,get:function(){return r.isNumeric}}),Object.defineProperty(t,"isObject",{enumerable:!0,get:function(){return r.isObject}}),Object.defineProperty(t,"isPlainObject",{enumerable:!0,get:function(){return r.isPlainObject}}),Object.defineProperty(t,"isPrimitive",{enumerable:!0,get:function(){return r.isPrimitive}}),Object.defineProperty(t,"isPromise",{enumerable:!0,get:function(){return r.isPromise}}),Object.defineProperty(t,"isRenderer",{enumerable:!0,get:function(){return r.isRenderer}}),Object.defineProperty(t,"isString",{enumerable:!0,get:function(){return r.isString}}),Object.defineProperty(t,"isWindow",{enumerable:!0,get:function(){return r.isWindow}}),Object.defineProperty(t,"type",{enumerable:!0,get:function(){return r.type}});var r=n(39918)},15162:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.SummarizeCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"summarize"}buildPromptData(e){return{user:{text:e.text}}}parseResult(e){return e}}t.SummarizeCommand=a},15436:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ExecuteCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"execute"}buildPromptData(e){return{user:{text:e.text}}}parseResult(e){return e}}t.ExecuteCommand=a},16927:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ChangeToneCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"changeTone"}buildPromptData(e){return{system:{tone:e.tone},user:{text:e.text}}}parseResult(e){return e}}t.ChangeToneCommand=a},17083:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.RequestManager=void 0;var r,a=(r=n(87129))&&r.__esModule?r:{default:r};t.RequestManager=class{constructor(e){this.provider=e,this.validateProvider()}validateProvider(){if("function"!=typeof this.provider.sendRequest)throw a.default.Error("E0122")}sendRequest(e,t,n){let r=!1;const a={prompt:e,data:n,onChunk:e=>{var n;r||(null==t||null===(n=t.onChunk)||void 0===n||n.call(t,e))}},{promise:o,abort:i}=this.provider.sendRequest(a);o.then((e=>{var n;r||(null==t||null===(n=t.onComplete)||void 0===n||n.call(t,e))})).catch((e=>{var n;r||(null==t||null===(n=t.onError)||void 0===n||n.call(t,e))}));return()=>{r=!0,null==i||i()}}}},31764:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.templates=void 0;t.templates={changeStyle:{system:"Rewrite the text provided to match the {{writingStyle}} writing style. Ensure the rewritten text follows the grammatical rules and stylistic conventions of the specified style. Preserve the original meaning and context. Use complete sentences and a professional tone. Return answer with no markdown formatting."},changeTone:{system:"Rewrite the following text to keep its original meaning but change its tone to {{tone}}. Provide only the rewritten text as plain text without any comments or formatting."},execute:{system:"Return answer with no markdown formatting."},expand:{system:"Expand the following text by adding relevant details, examples, and context while keeping the main point intact. Ensure the expanded text is coherent and logically structured. Return answer with no markdown formatting."},proofread:{system:"Proofread the following text for grammar, punctuation, and style errors. Make corrections to ensure clarity and conciseness while preserving the original meaning. Use a formal writing style unless otherwise specified. Return only the revised text without any formatting or explanations."},shorten:{system:"Please shorten the text provided by summarizing its content while retaining the main point and essential details. Aim to reduce the text to approximately 50% of its original length. Ensure that the key message remains clear and intact. Return answer with no markdown formatting."},summarize:{system:"First, identify the key points of the provided text. Then, generate an abstractive summary by paraphrasing these points, ensuring the summary captures the core ideas and is approximately 20% of the text's length. Return answer with no markdown formatting."},translate:{system:"Translate the text provided into {{lang}}. Ensure the translation retains the original meaning and tone. Provide only the translated text in your response, without any additional formatting or commentary."},smartPaste:{system:"You are a helpful assistant that helps to fill fields based on the text provided. You will get a text and a list of fields that should be filled using info from the text. It can include the name of field, suitable format, optionally some additional instruction about what it should include. You need to return data for all the fields in the following format without any preamble, introduction, or explanatory text: {fieldName}:::{fieldValue};;;{fieldName}:::{fieldValue} and so on, where {fieldName} - is a variable for a field name and {fieldValue} - is a variable for a string to fill. If there is no info to fill, field value should be empty (like Name:::;;;)- do not use placeholders like (empty), N/A, null, or similar. Only fill in date fields if a complete date is explicitly present. If the date is missing or incomplete, leave the field empty.",user:"Text: {{text}}. Fields: {{fields}}."},generateGridColumn:{system:'You are a helpful AI assistant that generates values for a new column in a dataset, based on a given user instruction and existing row data. Input: A user prompt that describes what should be generated. A dataset in the format: { "rowKey1": {column1: value1, column2: value2, ...}, "rowKey2": {...}, ... }. Task: Generate a single value for each row that satisfies the user\'s prompt, using the provided row data as context. Instructions: Output your result strictly in this format: { "rowKey1": "generatedValue1", "rowKey2": "generatedValue2", ... }. The output must be a valid JSON string, directly parsable by JSON.parse. Do not include any explanation, markdown, or formatting \u2014 only the raw JSON object. If a value cannot be generated for a specific row, assign an empty string ("") for that row. Example Output: { "rowKey1": "valueA", "rowKey2": "" }. You must follow this output format exactly. Any deviation will result in a parsing error.',user:"User prompt text: {{text}}. Dataset: {{data}}."}}},32067:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.SmartPasteCommand=void 0;var r=s(n(43101)),a=s(n(35185)),o=n(55390),i=n(55594);function s(e){return e&&e.__esModule?e:{default:e}}class d extends o.BaseCommand{static toTyped(e,t,n){const o=JSON.stringify(e),s=e.length<=1?e[0]:void 0,d=e.length>1?e:void 0;if(s||d)switch(t){case"color":if(new r.default(s).colorIsInvalid)throw a.default.Error("E1064",n,o,"color");return s;case"boolean":if("true"===s)return!0;if("false"===s)return!1;throw a.default.Error("E1064",n,o,"boolean");case"string":if(!s)throw a.default.Error("E1064",n,o,"string");return s;case"stringArray":if(!d)throw a.default.Error("E1064",n,o,"string array");return d;case"number":if(void 0===s||!Number.isFinite(parseFloat(s)))throw a.default.Error("E1064",n,o,"number");return parseFloat(s);case"numberRange":{if(!d||d.length>2)throw a.default.Error("E1064",n,o,"number range");const e=d.map((e=>parseFloat(e)));if(!e.every(Number.isFinite))throw a.default.Error("E1064",n,o,"number range");return[e[0],e[1]]}case"date":if(!i.dateUtilsTs.isValidDate(s))throw a.default.Error("E1064",n,o,"date");return new Date(s);case"dateRange":if(!d||d.length>2||!d.every(i.dateUtilsTs.isValidDate))throw a.default.Error("E1064",n,o,"date range");return d.map((e=>new Date(e)));default:return d??s}}getTemplateName(){return"smartPaste"}buildPromptData(e){const t=this.generateFieldsInstructions(e.fields);return{user:{text:e.text,fields:t}}}parseResult(e,t){const n=[];return e.split(";;;").forEach((e=>{if(!e)return;const[r,...a]=e.split(":::"),o=a.map((e=>e.trim())),i=t.fields.find((e=>e.name===r)),s=d.toTyped(o,null==i?void 0:i.type,null==i?void 0:i.name);s&&n.push({name:r,value:s})})),n}generateFieldsInstructions(e){return e.map((e=>{const t=e.instruction??"";return`fieldName: ${e.name}, format: ${e.format}${t?`, instruction: ${t}`:""}`})).join(";;;")}}t.SmartPasteCommand=d},32527:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.encodeHtml=void 0,t.format=function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),a=1;a<t;a++)n[a-1]=arguments[a];if((0,r.isFunction)(e))return e(...n);return n.forEach(((t,n)=>{(0,r.isString)(t)&&(t=t.replace(/\$/g,"$$$$"));const a=new RegExp(`\\{${n}\\}`,"gm");e=e.replace(a,t)})),e},t.quadToObject=t.isEmpty=void 0;var r=n(11528);t.encodeHtml=function(){const e=[new RegExp("&","g"),new RegExp('"',"g"),new RegExp("'","g"),new RegExp("<","g"),new RegExp(">","g")];return function(t){return String(t).replace(e[0],"&amp;").replace(e[1],"&quot;").replace(e[2],"&#39;").replace(e[3],"&lt;").replace(e[4],"&gt;")}}();t.quadToObject=function(e){const t=function(e){switch(typeof e){case"string":return e.split(/\s+/,4);case"object":return[e.x||e.h||e.left,e.y||e.v||e.top,e.x||e.h||e.right,e.y||e.v||e.bottom];case"number":return[e];default:return e}}(e);let n=parseInt(t&&t[0],10),r=parseInt(t&&t[1],10),a=parseInt(t&&t[2],10),o=parseInt(t&&t[3],10);return isFinite(n)||(n=0),isFinite(r)||(r=n),isFinite(a)||(a=n),isFinite(o)||(o=r),{top:r,right:a,bottom:o,left:n}};t.isEmpty=function(){const e=/\s/g;return function(t){return!t||!t.replace(e,"")}}()},35005:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.logger=t.default=t.debug=void 0;var r=n(11528);const a=function(){},o=function(e){return"undefined"!=typeof console&&(0,r.isFunction)(console[e])?console[e].bind(console):a},i=t.logger={log:o("log"),info:o("info"),warn:o("warn"),error:o("error")},s=t.debug=function(){function e(e,t){if(!e)throw new Error(t)}return{assert:e,assertParam:function(t,n){e(null!=t,n)}}}();t.default={logger:i,debug:s}},35185:(e,t,n)=>{t.default=void 0;var r=o(n(67264)),a=o(n(87129));function o(e){return e&&e.__esModule?e:{default:e}}t.default=(0,r.default)(a.default.ERROR_MESSAGES,{E1001:"Module '{0}'. Controller '{1}' is already registered",E1002:"Module '{0}'. Controller '{1}' does not inherit from DevExpress.ui.dxDataGrid.Controller",E1003:"Module '{0}'. View '{1}' is already registered",E1004:"Module '{0}'. View '{1}' does not inherit from DevExpress.ui.dxDataGrid.View",E1005:"Public method '{0}' is already registered",E1006:"Public method '{0}.{1}' does not exist",E1007:"State storing cannot be provided due to the restrictions of the browser",E1010:"The template does not contain the TextBox widget",E1011:'Items cannot be deleted from the List. Implement the "remove" function in the data store',E1012:"Editing type '{0}' with the name '{1}' is unsupported",E1016:"Unexpected type of data source is provided for a lookup column",E1018:"The 'collapseAll' method cannot be called if you use a remote data source",E1019:"Search mode '{0}' is unavailable",E1020:"The type cannot be changed after initialization",E1021:"{0} '{1}' you are trying to remove does not exist",E1022:'The "markers" option is given an invalid value. Assign an array instead',E1023:'The "routes" option is given an invalid value. Assign an array instead',E1025:"This layout is too complex to render",E1026:'The "calculateCustomSummary" function is missing from a field whose "summaryType" option is set to "custom"',E1031:"Unknown subscription in the Scheduler widget: '{0}'",E1032:"Unknown start date in an appointment: '{0}'",E1033:"Unknown step in the date navigator: '{0}'",E1034:"The browser does not implement an API for saving files",E1035:"The editor cannot be created: {0}",E1037:"Invalid structure of grouped data",E1038:"The browser does not support local storages for local web pages",E1039:"A cell's position cannot be calculated",E1040:"The '{0}' key value is not unique within the data array",E1041:"The '{0}' script is referenced after the DevExtreme scripts or not referenced at all",E1042:"{0} requires the key field to be specified",E1043:"Changes cannot be processed due to the incorrectly set key",E1044:"The key field specified by the keyExpr option does not match the key field specified in the data store",E1045:"Editing requires the key field to be specified in the data store",E1046:"The '{0}' key field is not found in data objects",E1047:'The "{0}" field is not found in the fields array',E1048:'The "{0}" operation is not found in the filterOperations array',E1049:"Column '{0}': filtering is allowed but the 'dataField' or 'name' option is not specified",E1050:"The validationRules option does not apply to third-party editors defined in the editCellTemplate",E1052:'{0} should have the "dataSource" option specified',E1053:'The "buttons" option accepts an array that contains only objects or string values',E1054:"All text editor buttons must have names",E1055:'One or several text editor buttons have invalid or non-unique "name" values',E1056:'The {0} widget does not support buttons of the "{1}" type',E1058:'The "startDayHour" and "endDayHour" options must be integers in the [0, 24] range, with "endDayHour" being greater than "startDayHour".',E1059:"The following column names are not unique: {0}",E1060:"All editable columns must have names",E1061:'The "offset" option must be an integer in the [-1440, 1440] range, divisible by 5 without a remainder.',E1062:'The "cellDuration" must be a positive integer, evenly dividing the ("endDayHour" - "startDayHour") interval into minutes.',E1063:"The 'smartPaste(text)' method was called, but 'aiIntegration' is not configured.",E1064:"AI returned {1} for the {0} field, but this field only accepts {2} values. Update the 'instruction' for this field.",E1065:"The browser does not support Web Speech API (SpeechRecognition)",E1066:"All AI columns must have names.",E1067:"'aiIntegration' is not configured in the {0} column.",W1001:'The "key" option cannot be modified after initialization',W1002:"An item with the key '{0}' does not exist",W1003:"A group with the key '{0}' in which you are trying to select items does not exist",W1004:"The item '{0}' you are trying to select in the group '{1}' does not exist",W1005:"Due to column data types being unspecified, data has been loaded twice in order to apply initial filter settings. To resolve this issue, specify data types for all grid columns.",W1006:"The map service returned the following error: '{0}'",W1007:"No item with key {0} was found in the data source, but this key was used as the parent key for item {1}",W1008:"Cannot scroll to the '{0}' date because it does not exist on the current view",W1009:"Searching works only if data is specified using the dataSource option",W1010:"The capability to select all items works with source data of plain structure only",W1011:'The "keyExpr" option is not applied when dataSource is not an array',W1012:"The '{0}' key field is not found in data objects",W1013:'The "message" field in the dialog component was renamed to "messageHtml". Change your code correspondingly. In addition, if you used HTML code in the message, make sure that it is secure',W1014:"The Floating Action Button exceeds the recommended speed dial action count. If you need to display more speed dial actions, increase the maxSpeedDialActionCount option value in the global config.",W1017:"The 'key' property is not specified for a lookup data source. Please specify it to prevent requests for the entire dataset when users filter data.",W1018:"Infinite scrolling may not work properly with multiple selection. To use these features together, set 'selection.deferred' to true or set 'selection.selectAllMode' to 'page'.",W1019:"Filter query string exceeds maximum length limit of {0} characters.",W1020:"hideEvent is ignored when the shading property is true",W1021:"The '{0}' is not rendered because none of the DOM elements match the value of the \"container\" property.",W1022:"{0} JSON parsing error: '{1}'",W1023:"Appointments require unique keys. Otherwise, the agenda view may not work correctly.",W1024:"The client-side export is enabled. Implement the 'onExporting' function.",W1025:"'scrolling.mode' is set to 'virtual' or 'infinite'. Specify the height of the component.",W1026:"The 'ai' toolbar item is defined, but aiIntegration is missing.",W1027:"A prompt should be specified for a custom command.",W1028:"Nested/banded columns do not support the following properties: {0}."});e.exports=t.default,e.exports.default=t.default},36050:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ShortenCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"shorten"}buildPromptData(e){return{user:{text:e.text}}}parseResult(e){return e}}t.ShortenCommand=a},37025:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.TranslateCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"translate"}buildPromptData(e){return{system:{lang:e.lang},user:{text:e.text}}}parseResult(e){return e}}t.TranslateCommand=a},37887:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.ExpandCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"expand"}buildPromptData(e){return{user:{text:e.text}}}parseResult(e){return e}}t.ExpandCommand=a},39171:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),Object.defineProperty(t,"BaseCommand",{enumerable:!0,get:function(){return r.BaseCommand}}),Object.defineProperty(t,"ChangeStyleCommand",{enumerable:!0,get:function(){return a.ChangeStyleCommand}}),Object.defineProperty(t,"ChangeToneCommand",{enumerable:!0,get:function(){return o.ChangeToneCommand}}),Object.defineProperty(t,"ExecuteCommand",{enumerable:!0,get:function(){return i.ExecuteCommand}}),Object.defineProperty(t,"ExpandCommand",{enumerable:!0,get:function(){return s.ExpandCommand}}),Object.defineProperty(t,"ProofreadCommand",{enumerable:!0,get:function(){return d.ProofreadCommand}}),Object.defineProperty(t,"ShortenCommand",{enumerable:!0,get:function(){return l.ShortenCommand}}),Object.defineProperty(t,"SmartPasteCommand",{enumerable:!0,get:function(){return u.SmartPasteCommand}}),Object.defineProperty(t,"SummarizeCommand",{enumerable:!0,get:function(){return c.SummarizeCommand}}),Object.defineProperty(t,"TranslateCommand",{enumerable:!0,get:function(){return f.TranslateCommand}});var r=n(55390),a=n(5654),o=n(16927),i=n(15436),s=n(37887),d=n(11121),l=n(36050),u=n(32067),c=n(15162),f=n(37025)},39918:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.type=t.isWindow=t.isString=t.isRenderer=t.isPromise=t.isPrimitive=t.isPlainObject=t.isObject=t.isNumeric=t.isFunction=t.isExponential=t.isEvent=t.isEmptyObject=t.isDefined=t.isDeferred=t.isDate=t.isBoolean=t.default=void 0;const n={"[object Array]":"array","[object Date]":"date","[object Object]":"object","[object String]":"string"},r=function(e){if(null===e)return"null";const t=Object.prototype.toString.call(e);return"object"==typeof e?n[t]||"object":typeof e};t.type=r;const a=function(e){return"boolean"==typeof e};t.isBoolean=a;const o=function(e){return u(e)&&-1!==e.toString().indexOf("e")};t.isExponential=o;const i=function(e){return"date"===r(e)};t.isDate=i;const s=function(e){return null!=e};t.isDefined=s;const d=function(e){return"function"==typeof e};t.isFunction=d;const l=function(e){return"string"==typeof e};t.isString=l;const u=function(e){return"number"==typeof e&&isFinite(e)||!isNaN(e-parseFloat(e))};t.isNumeric=u;const c=function(e){return"object"===r(e)};t.isObject=c;const f=function(e){let t;for(t in e)return!1;return!0};t.isEmptyObject=f;const m=function(e){if(!e||"object"!==r(e))return!1;const t=Object.getPrototypeOf(e);if(!t)return!0;const n=Object.hasOwnProperty.call(t,"constructor")&&t.constructor;return"function"==typeof n&&Object.toString.call(n)===Object.toString.call(Object)};t.isPlainObject=m;const p=function(e){return!["object","array","function"].includes(r(e))};t.isPrimitive=p;const h=function(e){return null!=e&&e===e.window};t.isWindow=h;const g=function(e){return!(!e||!e.jquery&&!e.dxRenderer)};t.isRenderer=g;const b=function(e){return!!e&&d(e.then)};t.isPromise=b;const y=function(e){return!!e&&d(e.done)&&d(e.fail)};t.isDeferred=y;const v=function(e){return!(!e||!e.preventDefault)};t.isEvent=v;t.default={isBoolean:a,isDate:i,isDeferred:y,isDefined:s,isEmptyObject:f,isEvent:v,isExponential:o,isFunction:d,isNumeric:u,isObject:c,isPlainObject:m,isPrimitive:p,isPromise:b,isRenderer:g,isString:l,isWindow:h,type:r}},40818:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0,t.error=l;var r,a=n(52576),o=n(54497),i=n(1956),s=(r=n(35005))&&r.__esModule?r:{default:r};const d=`https://js.devexpress.com/error/${i.version.split(".").slice(0,2).join("_")}/`;function l(e,t){const n={ERROR_MESSAGES:(0,a.extend)(t,e),Error:function(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];return function(e){const t=e[0];e=e.slice(1);const n=r(t,e),o=l(t),s=i(t,n);return(0,a.extend)(new Error(s),{__id:t,__details:n,url:o})}(t)},log(){for(var e=arguments.length,t=new Array(e),n=0;n<e;n++)t[n]=arguments[n];const a=t[0];let o="log";/^E\d+$/.test(a)?o="error":/^W\d+$/.test(a)&&(o="warn"),s.default.logger[o]("log"===o?a:function(e){const t=e[0];return e=e.slice(1),i(t,r(t,e))}(t))}};function r(e,t){return t=[n.ERROR_MESSAGES[e]].concat(t),o.format.apply(this,t).replace(/\.*\s*?$/,"")}function i(e,t){const n=null!=e&&e.startsWith("W")?"warning":"error";return o.format.apply(this,["{0} - {1}.\n\nFor additional information on this {2} message, see: {3}",e,t,n,l(e)])}function l(e){return d+e}return n}t.default=l},43101:(e,t,n)=>{t.default=void 0;var r,a=(r=n(54699))&&r.__esModule?r:{default:r};t.default=a.default;e.exports=t.default,e.exports.default=t.default},49691:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.CommandNames=t.COMMANDS=t.AIIntegration=void 0;var r,a=n(39171),o=n(76542),i=n(17083),s=n(88890);!function(e){e.ChangeStyle="changeStyle",e.ChangeTone="changeTone",e.Execute="execute",e.Expand="expand",e.Proofread="proofread",e.Shorten="shorten",e.Summarize="summarize",e.Translate="translate",e.SmartPaste="smartPaste",e.GenerateGridColumn="generateGridColumn"}(r||(t.CommandNames=r={}));const d=t.COMMANDS={[r.ChangeStyle]:a.ChangeStyleCommand,[r.ChangeTone]:a.ChangeToneCommand,[r.Execute]:a.ExecuteCommand,[r.Expand]:a.ExpandCommand,[r.Proofread]:a.ProofreadCommand,[r.Shorten]:a.ShortenCommand,[r.Summarize]:a.SummarizeCommand,[r.Translate]:a.TranslateCommand,[r.SmartPaste]:a.SmartPasteCommand,[r.GenerateGridColumn]:s.GenerateGridColumnCommand};t.AIIntegration=class{constructor(e){this.promptManager=new o.PromptManager,this.requestManager=new i.RequestManager(e),this.commands=new Map}executeCommand(e,t,n){let r=this.commands.get(e);if(!r){r=new(0,d[e])(this.promptManager,this.requestManager),this.commands.set(e,r)}return r.execute(t,n)}changeStyle(e,t){return this.executeCommand(r.ChangeStyle,e,t)}changeTone(e,t){return this.executeCommand(r.ChangeTone,e,t)}execute(e,t){return this.executeCommand(r.Execute,e,t)}expand(e,t){return this.executeCommand(r.Expand,e,t)}proofread(e,t){return this.executeCommand(r.Proofread,e,t)}shorten(e,t){return this.executeCommand(r.Shorten,e,t)}summarize(e,t){return this.executeCommand(r.Summarize,e,t)}translate(e,t){return this.executeCommand(r.Translate,e,t)}smartPaste(e,t){return this.executeCommand(r.SmartPaste,e,t)}generateGridColumn(e,t){return this.executeCommand(r.GenerateGridColumn,e,t)}}},52576:(e,t,n)=>{Object.defineProperty(t,"extend",{enumerable:!0,get:function(){return r.extend}}),Object.defineProperty(t,"extendFromObject",{enumerable:!0,get:function(){return r.extendFromObject}});var r=n(96298)},54497:(e,t,n)=>{Object.defineProperty(t,"encodeHtml",{enumerable:!0,get:function(){return r.encodeHtml}}),Object.defineProperty(t,"format",{enumerable:!0,get:function(){return r.format}}),Object.defineProperty(t,"isEmpty",{enumerable:!0,get:function(){return r.isEmpty}}),Object.defineProperty(t,"quadToObject",{enumerable:!0,get:function(){return r.quadToObject}});var r=n(32527)},54699:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.default=void 0;const n={aliceblue:"f0f8ff",antiquewhite:"faebd7",aqua:"00ffff",aquamarine:"7fffd4",azure:"f0ffff",beige:"f5f5dc",bisque:"ffe4c4",black:"000000",blanchedalmond:"ffebcd",blue:"0000ff",blueviolet:"8a2be2",brown:"a52a2a",burlywood:"deb887",cadetblue:"5f9ea0",chartreuse:"7fff00",chocolate:"d2691e",coral:"ff7f50",cornflowerblue:"6495ed",cornsilk:"fff8dc",crimson:"dc143c",cyan:"00ffff",darkblue:"00008b",darkcyan:"008b8b",darkgoldenrod:"b8860b",darkgray:"a9a9a9",darkgreen:"006400",darkgrey:"a9a9a9",darkkhaki:"bdb76b",darkmagenta:"8b008b",darkolivegreen:"556b2f",darkorange:"ff8c00",darkorchid:"9932cc",darkred:"8b0000",darksalmon:"e9967a",darkseagreen:"8fbc8f",darkslateblue:"483d8b",darkslategray:"2f4f4f",darkslategrey:"2f4f4f",darkturquoise:"00ced1",darkviolet:"9400d3",deeppink:"ff1493",deepskyblue:"00bfff",dimgray:"696969",dimgrey:"696969",dodgerblue:"1e90ff",feldspar:"d19275",firebrick:"b22222",floralwhite:"fffaf0",forestgreen:"228b22",fuchsia:"ff00ff",gainsboro:"dcdcdc",ghostwhite:"f8f8ff",gold:"ffd700",goldenrod:"daa520",gray:"808080",green:"008000",greenyellow:"adff2f",grey:"808080",honeydew:"f0fff0",hotpink:"ff69b4",indianred:"cd5c5c",indigo:"4b0082",ivory:"fffff0",khaki:"f0e68c",lavender:"e6e6fa",lavenderblush:"fff0f5",lawngreen:"7cfc00",lemonchiffon:"fffacd",lightblue:"add8e6",lightcoral:"f08080",lightcyan:"e0ffff",lightgoldenrodyellow:"fafad2",lightgray:"d3d3d3",lightgreen:"90ee90",lightgrey:"d3d3d3",lightpink:"ffb6c1",lightsalmon:"ffa07a",lightseagreen:"20b2aa",lightskyblue:"87cefa",lightslateblue:"8470ff",lightslategray:"778899",lightslategrey:"778899",lightsteelblue:"b0c4de",lightyellow:"ffffe0",lime:"00ff00",limegreen:"32cd32",linen:"faf0e6",magenta:"ff00ff",maroon:"800000",mediumaquamarine:"66cdaa",mediumblue:"0000cd",mediumorchid:"ba55d3",mediumpurple:"9370d8",mediumseagreen:"3cb371",mediumslateblue:"7b68ee",mediumspringgreen:"00fa9a",mediumturquoise:"48d1cc",mediumvioletred:"c71585",midnightblue:"191970",mintcream:"f5fffa",mistyrose:"ffe4e1",moccasin:"ffe4b5",navajowhite:"ffdead",navy:"000080",oldlace:"fdf5e6",olive:"808000",olivedrab:"6b8e23",orange:"ffa500",orangered:"ff4500",orchid:"da70d6",palegoldenrod:"eee8aa",palegreen:"98fb98",paleturquoise:"afeeee",palevioletred:"d87093",papayawhip:"ffefd5",peachpuff:"ffdab9",peru:"cd853f",pink:"ffc0cb",plum:"dda0dd",powderblue:"b0e0e6",purple:"800080",rebeccapurple:"663399",red:"ff0000",rosybrown:"bc8f8f",royalblue:"4169e1",saddlebrown:"8b4513",salmon:"fa8072",sandybrown:"f4a460",seagreen:"2e8b57",seashell:"fff5ee",sienna:"a0522d",silver:"c0c0c0",skyblue:"87ceeb",slateblue:"6a5acd",slategray:"708090",slategrey:"708090",snow:"fffafa",springgreen:"00ff7f",steelblue:"4682b4",tan:"d2b48c",teal:"008080",thistle:"d8bfd8",tomato:"ff6347",turquoise:"40e0d0",violet:"ee82ee",violetred:"d02090",wheat:"f5deb3",white:"ffffff",whitesmoke:"f5f5f5",yellow:"ffff00",yellowgreen:"9acd32"},r=[{re:/^rgb\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process:e=>[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10)]},{re:/^rgba\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3}),\s*(\d*\.*\d+)\)$/,process:e=>[parseInt(e[1],10),parseInt(e[2],10),parseInt(e[3],10),parseFloat(e[4])]},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:e=>[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16)]},{re:/^#([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})([a-f0-9]{2})$/,process:e=>[parseInt(e[1],16),parseInt(e[2],16),parseInt(e[3],16),Number((parseInt(e[4],16)/255).toFixed(2))]},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:e=>[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16),Number((parseInt(e[4]+e[4],16)/255).toFixed(2))]},{re:/^#([a-f0-9]{1})([a-f0-9]{1})([a-f0-9]{1})$/,process:e=>[parseInt(e[1]+e[1],16),parseInt(e[2]+e[2],16),parseInt(e[3]+e[3],16)]},{re:/^hsv\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process(e){const t=parseInt(e[1],10),n=parseInt(e[2],10),r=parseInt(e[3],10),a=s(t,n,r);return[a[0],a[1],a[2],1,[t,n,r]]}},{re:/^hsl\((\d{1,3}),\s*(\d{1,3}),\s*(\d{1,3})\)$/,process(e){const t=parseInt(e[1],10),n=parseInt(e[2],10),r=parseInt(e[3],10),a=u(t,n,r);return[a[0],a[1],a[2],1,null,[t,n,r]]}}],a=Math.round;function o(e){let t;this.baseColor=e,e&&(t=String(e).toLowerCase().replace(/ /g,""),t=n[t]?`#${n[t]}`:t,t=function(e){if("transparent"===e)return[0,0,0,0];let t=0;const n=r.length;let a;for(;t<n;++t)if(a=r[t].re.exec(e),a)return r[t].process(a);return null}(t)),t||(this.colorIsInvalid=!0),t=t||{},this.r=i(t[0]),this.g=i(t[1]),this.b=i(t[2]),this.a=i(t[3],1,1),t[4]?this.hsv={h:t[4][0],s:t[4][1],v:t[4][2]}:this.hsv=function(e,t,n){const r=Math.max(e,t,n),a=Math.min(e,t,n),o=r-a;let i,s,d=r;if(s=0===r?0:1-a/r,r===a)i=0;else switch(r){case e:i=(t-n)/o*60,t<n&&(i+=360);break;case t:i=(n-e)/o*60+120;break;case n:i=(e-t)/o*60+240}return s*=100,d*=100/255,{h:Math.round(i),s:Math.round(s),v:Math.round(d)}}(this.r,this.g,this.b),t[5]?this.hsl={h:t[5][0],s:t[5][1],l:t[5][2]}:this.hsl=function(e,t,n){e=c(e,255),t=c(t,255),n=c(n,255);const r=Math.max(e,t,n),o=Math.min(e,t,n),i=r+o;let s,d;const l=i/2;if(r===o)s=d=0;else{const a=r-o;d=l>.5?a/(2-i):a/i,s=function(e,t,n,r){switch(Math.max(e,t,n)){case e:return(t-n)/r+(t<n?6:0);case t:return(n-e)/r+2;case n:return(e-t)/r+4;default:return}}(e,t,n,a),s/=6}return{h:a(360*s),s:a(100*d),l:a(100*l)}}(this.r,this.g,this.b)}function i(e,t,n){return t=t||0,n=n||255,e<0||isNaN(e)?t:e>n?n:e}function s(e,t,n){const r=(100-t)*n/100,a=e%60/60*(n-r),o=r+a,i=n-a;let s,d,l;switch(Math.floor(e%360/60)){case 0:s=n,d=o,l=r;break;case 1:s=i,d=n,l=r;break;case 2:s=r,d=n,l=o;break;case 3:s=r,d=i,l=n;break;case 4:s=o,d=r,l=n;break;case 5:s=n,d=r,l=i}return[Math.round(2.55*s),Math.round(2.55*d),Math.round(2.55*l)]}function d(e,t){let n=t;return"r"===e&&(n=t+1/3),"b"===e&&(n=t-1/3),n}function l(e,t,n){return(n=function(e){return e<0&&(e+=1),e>1&&(e-=1),e}(n))<1/6?e+6*(t-e)*n:n<.5?t:n<2/3?e+(t-e)*(2/3-n)*6:e}function u(e,t,n){let r,o,i;if(e=c(e,360),t=c(t,100),n=c(n,100),0===t)r=o=i=n;else{const a=n<.5?n*(1+t):n+t-n*t,s=2*n-a;r=l(s,a,d("r",e)),o=l(s,a,d("g",e)),i=l(s,a,d("b",e))}return[a(255*r),a(255*o),a(255*i)]}function c(e,t){return e=Math.min(t,Math.max(0,parseFloat(e))),Math.abs(e-t)<1e-6?1:e%t/parseFloat(t)}function f(e,t,n){return t=t||0,n=n||255,!(e%1!=0||e<t||e>n||"number"!=typeof e||isNaN(e))}o.prototype={constructor:o,highlight(e){return e=e||10,this.alter(e).toHex()},darken(e){return e=e||10,this.alter(-e).toHex()},alter(e){const t=new o;return t.r=i(this.r+e),t.g=i(this.g+e),t.b=i(this.b+e),t},blend(e,t){const n=e instanceof o?e:new o(e),r=new o;return r.r=i(a(this.r*(1-t)+n.r*t)),r.g=i(a(this.g*(1-t)+n.g*t)),r.b=i(a(this.b*(1-t)+n.b*t)),r},toHex(){return e=this.r,t=this.g,n=this.b,`#${(16777216|e<<16|t<<8|n).toString(16).slice(1)}`;var e,t,n},getPureColor(){return new o(`rgb(${s(this.hsv.h,100,100).join(",")})`)},isValidHex:e=>/(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(e),isValidRGB:(e,t,n)=>!!(f(e)&&f(t)&&f(n)),isValidAlpha:e=>!(isNaN(e)||e<0||e>1||"number"!=typeof e),colorIsInvalid:!1,fromHSL(e){const t=new o,n=u(e.h,e.s,e.l);return t.r=n[0],t.g=n[1],t.b=n[2],t}};t.default=o},55390:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.BaseCommand=void 0;t.BaseCommand=class{constructor(e,t){this.promptManager=e,this.requestManager=t}execute(e,t){const n=this.getTemplateName(),r=this.buildPromptData(e),a=this.promptManager.buildPrompt(n,r),o={onChunk:e=>{var n;null==t||null===(n=t.onChunk)||void 0===n||n.call(t,e)},onComplete:n=>{var r;const a=this.parseResult(n,e);null==t||null===(r=t.onComplete)||void 0===r||r.call(t,a)},onError:e=>{var n;null==t||null===(n=t.onError)||void 0===n||n.call(t,e)}};return this.requestManager.sendRequest(a,o,e)}}},55594:(e,t)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.dateUtilsTs=void 0;t.dateUtilsTs={addOffsets:function(e){for(var t=arguments.length,n=new Array(t>1?t-1:0),r=1;r<t;r++)n[r-1]=arguments[r];const a=n.reduce(((e,t)=>e+t),e.getTime());return new Date(a)},isValidDate:e=>Boolean(e&&!isNaN(new Date(e).valueOf()))}},63223:(e,t,n)=>{var r=n(94977);e.exports=DevExpress.aiIntegration=r.AIIntegration},67264:(e,t,n)=>{t.default=void 0;var r=n(40818);t.default=r.error;e.exports=t.default,e.exports.default=t.default},76542:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.PromptManager=t.ERROR_MESSAGES=void 0;var r=n(31764);const a=t.ERROR_MESSAGES={TEMPLATE_NOT_FOUND:"Template not found"};t.PromptManager=class{constructor(){this.templates=new Map(Object.entries(r.templates))}buildPrompt(e,t){const n=this.templates.get(e);if(!n)throw new Error(a.TEMPLATE_NOT_FOUND);return{system:this.generateMessage(n.system,t.system),user:this.generateMessage(n.user,t.user)}}generateMessage(e,t){if(!t&&!e)return;if(!e&&t)return Object.keys(t).reduce(((e,n)=>`${e} ${t[n]}`),"").trim();if(!t&&e)return e;return this.replacePlaceholders(e,t)}replacePlaceholders(e,t){return Object.entries(t).reduce(((e,t)=>{let[n,r]=t;return e.replaceAll(`{{${n}}}`,r)}),e)}}},87129:(e,t,n)=>{t.default=void 0;var r,a=(r=n(5583))&&r.__esModule?r:{default:r};t.default=a.default;e.exports=t.default,e.exports.default=t.default},88890:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.GenerateGridColumnCommand=void 0;var r=n(55390);class a extends r.BaseCommand{getTemplateName(){return"generateGridColumn"}buildPromptData(e){const t=this.generateDataDescription(e.data);return{user:{text:e.text,data:t}}}parseResult(e){if("string"==typeof e)return""===e?{data:{}}:{data:JSON.parse(e)};return{data:"string"==typeof e.data?JSON.parse(e.data):e.data}}generateDataDescription(e){return JSON.stringify(e)}}t.GenerateGridColumnCommand=a},94977:(e,t,n)=>{Object.defineProperty(t,"AIIntegration",{enumerable:!0,get:function(){return r.AIIntegration}});var r=n(49691)},96298:(e,t,n)=>{Object.defineProperty(t,"__esModule",{value:!0}),t.extendFromObject=t.extend=void 0;var r=n(11528);t.extendFromObject=function(e,t,n){e=e||{};for(const r in t)if(Object.prototype.hasOwnProperty.call(t,r)){const a=t[r];r in e&&!n||(e[r]=a)}return e};const a=function(e){let t=1,n=!1;for("boolean"==typeof(e=e||{})&&(n=e,e=arguments[1]||{},t++);t<arguments.length;t++){const o=arguments[t];if(null!=o)for(const t in o){const i=e[t],s=o[t];let d,l=!1;"__proto__"!==t&&"constructor"!==t&&e!==s&&(n&&s&&((0,r.isPlainObject)(s)||(l=Array.isArray(s)))?(d=l?i&&Array.isArray(i)?i:[]:i&&(0,r.isPlainObject)(i)?i:{},e[t]=a(n,d,s)):void 0!==s&&(e[t]=s))}}return e};t.extend=a}},t={};(function n(r){var a=t[r];if(void 0!==a)return a.exports;var o=t[r]={exports:{}};return e[r](o,o.exports,n),o.exports})(63223)})();
