/*!
 * DevExpress Diagram (dx-diagram)
 * Version: 2.2.24
 * Build date: Tue Sep 23 2025
 *
 * Copyright (c) 2012 - 2025 Developer Express Inc. ALL RIGHTS RESERVED
 * Read about DevExpress licensing here: https://www.devexpress.com/Support/EULAs
 */
(function webpackUniversalModuleDefinition(root, factory) {
    if(typeof exports === 'object' && typeof module === 'object')
        module.exports = factory();
    else if(typeof define === 'function' && define.amd)
        define([], factory);
    else if(typeof exports === 'object')
        exports["DevExpress"] = factory();
    else
        root["DevExpress"] = root["DevExpress"] || {}, root["DevExpress"]["diagram"] = factory();
})(this, () => {
return /******/ (() => { // webpackBootstrap
/******/ 	"use strict";
/******/ 	var __webpack_modules__ = ({

/***/ 4:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImagePrimitive = void 0;
var RenderHelper_1 = __webpack_require__(8509);
var Primitive_1 = __webpack_require__(8309);
var ImagePrimitive = (function (_super) {
    __extends(ImagePrimitive, _super);
    function ImagePrimitive(x, y, width, height, url, preserveAspectRatio, style, className) {
        if (preserveAspectRatio === void 0) { preserveAspectRatio = "none"; }
        var _this = _super.call(this, style, className) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.url = url;
        _this.preserveAspectRatio = preserveAspectRatio;
        return _this;
    }
    ImagePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderHelper_1.svgNS, "image");
    };
    ImagePrimitive.prototype.applyElementProperties = function (element, measurer) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        this.setPositionCorrectionAttribute(element);
        element.setAttribute("href", this.url);
        element.setAttribute("preserveAspectRatio", this.preserveAspectRatio);
        _super.prototype.applyElementProperties.call(this, element, measurer);
    };
    return ImagePrimitive;
}(Primitive_1.SvgPrimitive));
exports.ImagePrimitive = ImagePrimitive;


/***/ }),

/***/ 18:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerToolboxDraggingState = exports.MouseHandlerBeforeToolboxDraggingState = void 0;
var Event_1 = __webpack_require__(5428);
var point_1 = __webpack_require__(5327);
var AddShapeHistoryItem_1 = __webpack_require__(8214);
var SetSelectionHistoryItem_1 = __webpack_require__(6512);
var MouseHandlerDraggingState_1 = __webpack_require__(2815);
var DeleteShapeHistoryItem_1 = __webpack_require__(1785);
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerStateBase_1 = __webpack_require__(9589);
var ModelOperationSettings_1 = __webpack_require__(5225);
var NON_DOCUMENT_TIMER = 500;
var LOCK_UPDATEPAGESIZE_TIMER = 300;
var MouseHandlerBeforeToolboxDraggingState = (function (_super) {
    __extends(MouseHandlerBeforeToolboxDraggingState, _super);
    function MouseHandlerBeforeToolboxDraggingState(handler, history, model, selection, visualizerManager, shapeDescriptionManager) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        _this.isModelEmpty = model.items.length === 0;
        return _this;
    }
    MouseHandlerBeforeToolboxDraggingState.prototype.cancelChanges = function () {
        this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onDragEnd = function (evt) {
        this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.onMouseMove = function (evt) {
        var _this = this;
        if (evt.source.type > Event_1.MouseEventElementType.Background) {
            this.tryRemoveTimer();
            this.switchToDraggingState(evt, false);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.Background && !this.isModelEmpty) {
            this.savedEvt = evt;
            if (this.nonPageAreaTimer === undefined)
                this.nonPageAreaTimer = setTimeout(function () { return _this.switchToDraggingState(_this.savedEvt, true); }, NON_DOCUMENT_TIMER);
        }
        else if (this.nonPageAreaTimer !== undefined)
            this.tryRemoveTimer();
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.switchToDraggingState = function (evt, skipLockUpdatePageSize) {
        this.handler.switchState(new MouseHandlerToolboxDraggingState(this.handler, this.history, this.model, this.selection, this.visualizerManager, this.shapeDescriptionManager, skipLockUpdatePageSize));
        this.handler.state.onDragStart(this.dragging);
        this.handler.state.onMouseMove(evt);
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.tryRemoveTimer = function () {
        if (this.nonPageAreaTimer !== undefined) {
            clearTimeout(this.nonPageAreaTimer);
            delete this.nonPageAreaTimer;
        }
    };
    MouseHandlerBeforeToolboxDraggingState.prototype.finish = function () {
        this.tryRemoveTimer();
    };
    return MouseHandlerBeforeToolboxDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerBeforeToolboxDraggingState = MouseHandlerBeforeToolboxDraggingState;
var MouseHandlerToolboxDraggingState = (function (_super) {
    __extends(MouseHandlerToolboxDraggingState, _super);
    function MouseHandlerToolboxDraggingState(handler, history, model, selection, visualizerManager, shapeDescriptionManager, skipLockUpdatePageSize) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        if (!skipLockUpdatePageSize)
            _this.updatePageSizeTimer = setTimeout(function () {
                _this.processAndRemoveUpdatePageSizeTimer();
            }, LOCK_UPDATEPAGESIZE_TIMER);
        return _this;
    }
    MouseHandlerToolboxDraggingState.prototype.cancelChanges = function () {
        this.tryRemoveUpdatePageSizeTimer();
        _super.prototype.cancelChanges.call(this);
    };
    MouseHandlerToolboxDraggingState.prototype.tryRemoveUpdatePageSizeTimer = function () {
        if (this.updatePageSizeTimer !== undefined) {
            clearTimeout(this.updatePageSizeTimer);
            delete this.updatePageSizeTimer;
        }
    };
    MouseHandlerToolboxDraggingState.prototype.processAndRemoveUpdatePageSizeTimer = function () {
        if (this.updatePageSizeTimer !== undefined) {
            this.handler.tryUpdateModelSize();
            delete this.updatePageSizeTimer;
        }
    };
    MouseHandlerToolboxDraggingState.prototype.onMouseMove = function (evt) {
        _super.prototype.onMouseMove.call(this, evt);
        var shape = this.model.findShape(this.shapeKey);
        if (shape) {
            this.visualizerManager.setExtensionLines([shape]);
            var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
            if (container && this.allowInsertToContainer(evt, shape, container))
                this.visualizerManager.setContainerTarget(container, evt.source.type);
            else
                this.visualizerManager.resetContainerTarget();
        }
    };
    MouseHandlerToolboxDraggingState.prototype.getDraggingElementKeys = function () {
        return this.shapeKey === undefined ? [] : [this.shapeKey];
    };
    MouseHandlerToolboxDraggingState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        if (evt.source.type === Event_1.MouseEventElementType.Undefined) {
            this.dragging.onCaptured(false);
            if (this.shapeKey !== undefined && !this.deleteHistoryItem) {
                var shape = this.model.findShape(this.shapeKey);
                ModelUtils_1.ModelUtils.detachConnectors(this.history, shape);
                ModelUtils_1.ModelUtils.removeFromContainer(this.history, this.model, shape);
                this.deleteHistoryItem = new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(this.shapeKey, true);
                this.history.addAndRedo(this.deleteHistoryItem);
            }
        }
        else {
            this.dragging.onCaptured(true);
            if (this.shapeKey === undefined) {
                this.startPoint = evt.modelPoint;
                this.shapeKey = this.insertToolboxItem(evt);
                var shape_1 = this.model.findShape(this.shapeKey);
                if (shape_1)
                    this.handler.addInteractingItem(shape_1, ModelOperationSettings_1.DiagramModelOperation.AddShape);
            }
            if (this.deleteHistoryItem) {
                this.history.undoTransactionTo(this.deleteHistoryItem);
                delete this.deleteHistoryItem;
            }
            var pos = this.getPosition(evt, this.startShapePosition);
            var shape = this.model.findShape(this.shapeKey);
            ModelUtils_1.ModelUtils.setShapePosition(this.history, this.model, shape, pos);
            ModelUtils_1.ModelUtils.updateMovingShapeConnections(this.history, shape, this.connectorsWithoutBeginItemInfo, this.connectorsWithoutEndItemInfo, function () {
                _this.visualizerManager.resetConnectionTarget();
                _this.visualizerManager.resetConnectionPoints();
            }, function (shape, connectionPointIndex) {
                _this.visualizerManager.setConnectionTarget(shape, Event_1.MouseEventElementType.Shape);
                _this.visualizerManager.setConnectionPoints(shape, Event_1.MouseEventElementType.Shape, connectionPointIndex, true);
            }, function (connector) { return _this.handler.addInteractingItem(connector); });
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(this.history, this.model, shape);
            var container = ModelUtils_1.ModelUtils.findContainerByEventKey(this.model, this.selection, evt.source.key);
            if (shape && container && this.allowInsertToContainer(evt, shape, container))
                ModelUtils_1.ModelUtils.insertToContainer(this.history, this.model, shape, container);
            else
                ModelUtils_1.ModelUtils.removeFromContainer(this.history, this.model, shape);
            if (this.updatePageSizeTimer === undefined)
                this.handler.tryUpdateModelSize(function (offsetLeft, offsetTop) {
                    _this.connectorsWithoutBeginItemInfo.forEach(function (pi) {
                        pi.point.x += offsetLeft;
                        pi.point.y += offsetTop;
                    });
                    _this.connectorsWithoutEndItemInfo.forEach(function (pi) {
                        pi.point.x += offsetLeft;
                        pi.point.y += offsetTop;
                    });
                });
        }
    };
    MouseHandlerToolboxDraggingState.prototype.onFinishWithChanges = function () {
        if (!this.deleteHistoryItem)
            this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.shapeKey]));
    };
    MouseHandlerToolboxDraggingState.prototype.onDragStart = function (evt) {
        this.dragging = evt;
        this.connectorsWithoutBeginItemInfo = ModelUtils_1.ModelUtils.getConnectorsWithoutBeginItemInfo(this.model);
        this.connectorsWithoutEndItemInfo = ModelUtils_1.ModelUtils.getConnectorsWithoutEndItemInfo(this.model);
    };
    MouseHandlerToolboxDraggingState.prototype.onDragEnd = function (evt) {
        if (this.shapeKey !== undefined && evt.source.type === Event_1.MouseEventElementType.Undefined)
            this.cancelChanges();
        this.handler.switchToDefaultState();
    };
    MouseHandlerToolboxDraggingState.prototype.finish = function () {
        this.visualizerManager.resetExtensionLines();
        this.visualizerManager.resetContainerTarget();
        this.visualizerManager.resetConnectionTarget();
        this.visualizerManager.resetConnectionPoints();
        this.processAndRemoveUpdatePageSizeTimer();
        this.dragging.onFinishDragging();
        _super.prototype.finish.call(this);
    };
    MouseHandlerToolboxDraggingState.prototype.insertToolboxItem = function (evt) {
        var description = this.shapeDescriptionManager.get(this.dragging.data);
        this.startShapePosition = this.getSnappedPoint(evt, new point_1.Point(evt.modelPoint.x - description.defaultSize.width / 2, evt.modelPoint.y - description.defaultSize.height / 2));
        var historyItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(description, this.startShapePosition);
        this.history.addAndRedo(historyItem);
        ModelUtils_1.ModelUtils.updateNewShapeProperties(this.history, this.selection, historyItem.shapeKey);
        return historyItem.shapeKey;
    };
    MouseHandlerToolboxDraggingState.prototype.allowInsertToContainer = function (evt, item, container) {
        if (this.handler.canMultipleSelection(evt))
            return false;
        return container && container.expanded && ModelUtils_1.ModelUtils.canInsertToContainer(this.model, item, container);
    };
    MouseHandlerToolboxDraggingState.prototype.getPosition = function (evt, basePoint) {
        return this.getSnappedPoint(evt, new point_1.Point(basePoint.x + evt.modelPoint.x - this.startPoint.x, basePoint.y + evt.modelPoint.y - this.startPoint.y));
    };
    return MouseHandlerToolboxDraggingState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerToolboxDraggingState = MouseHandlerToolboxDraggingState;


/***/ }),

/***/ 41:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EventUtils = exports.HtmlFocusUtils = exports.ObjectUtils = exports.GeometryUtils = exports.Utils = exports.EventDispatcher = exports.Range = exports.LineEquation = void 0;
__webpack_require__(4092);
var size_1 = __webpack_require__(3844);
var point_1 = __webpack_require__(5327);
var rectangle_1 = __webpack_require__(4412);
var search_1 = __webpack_require__(124);
var metrics_1 = __webpack_require__(4496);
var math_1 = __webpack_require__(594);
var vector_1 = __webpack_require__(4166);
var segment_1 = __webpack_require__(476);
var Style_1 = __webpack_require__(5059);
var browser_1 = __webpack_require__(8424);
var evt_1 = __webpack_require__(8451);
var LineEquation = (function () {
    function LineEquation(aParam, bParam, cParam) {
        this.aParam = aParam;
        this.bParam = bParam;
        this.cParam = cParam;
    }
    LineEquation.fromPoints = function (pointA, pointB, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return !GeometryUtils.areDuplicatedPoints(pointA, pointB, accuracy) ?
            new LineEquation(pointB.y - pointA.y, pointA.x - pointB.x, pointB.x * pointA.y - pointA.x * pointB.y) : undefined;
    };
    LineEquation.prototype.getPointIntersection = function (other, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        var A1 = this.aParam;
        var B1 = this.bParam;
        var C1 = this.cParam;
        var A2 = other.aParam;
        var B2 = other.bParam;
        var C2 = other.cParam;
        var v = A2 * B1 - A1 * B2;
        if (math_1.MathUtils.numberCloseTo(v, 0, accuracy))
            return null;
        if (A1 === 0) {
            var x = (B2 * C1 - C2 * B1) / (B1 * A2);
            return this.createPoint(x, -C1 / B1);
        }
        var y = (C2 * A1 - C1 * A2) / v;
        return this.createPoint((-B1 * y - C1) / A1, y);
    };
    LineEquation.prototype.containsPoint = function (point, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return math_1.MathUtils.numberCloseTo(this.aParam * point.x + this.bParam * point.y + this.cParam, 0, accuracy);
    };
    LineEquation.prototype.createPoint = function (x, y, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return new point_1.Point(math_1.MathUtils.numberCloseTo(x, 0, accuracy) ? 0 : x, math_1.MathUtils.numberCloseTo(y, 0, accuracy) ? 0 : y);
    };
    return LineEquation;
}());
exports.LineEquation = LineEquation;
var Range = (function () {
    function Range(from, to) {
        this.from = from;
        this.to = to !== undefined ? to : from;
    }
    Object.defineProperty(Range.prototype, "length", {
        get: function () {
            return Math.abs(this.to - this.from);
        },
        enumerable: false,
        configurable: true
    });
    Range.prototype.extend = function (range) {
        this.from = Math.min(range.from, this.from);
        this.to = Math.max(range.to, this.to);
    };
    Range.prototype.includes = function (value) {
        return value >= this.from && value <= this.to;
    };
    Range.fromLength = function (from, length) {
        return new Range(from, from + length);
    };
    return Range;
}());
exports.Range = Range;
var EventDispatcher = (function () {
    function EventDispatcher() {
        this.listeners = [];
    }
    EventDispatcher.prototype.add = function (listener) {
        if (!listener)
            throw new Error("Not Implemented");
        if (!this.hasEventListener(listener))
            this.listeners.push(listener);
    };
    EventDispatcher.prototype.remove = function (listener) {
        for (var i = 0, currentListener = void 0; currentListener = this.listeners[i]; i++)
            if (currentListener === listener) {
                this.listeners.splice(i, 1);
                break;
            }
    };
    EventDispatcher.prototype.raise = function (funcName) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        for (var i = 0, listener = void 0; listener = this.listeners[i]; i++) {
            var func = listener[funcName];
            func && func.apply(listener, args);
        }
    };
    EventDispatcher.prototype.raise1 = function (action) {
        for (var i = 0, listener = void 0; listener = this.listeners[i]; i++)
            action(listener);
    };
    EventDispatcher.prototype.hasEventListener = function (listener) {
        for (var i = 0, l = this.listeners.length; i < l; i++)
            if (this.listeners[i] === listener)
                return true;
        return false;
    };
    return EventDispatcher;
}());
exports.EventDispatcher = EventDispatcher;
var Utils = (function () {
    function Utils() {
    }
    Utils.flatten = function (arr) {
        return [].concat.apply([], arr);
    };
    return Utils;
}());
exports.Utils = Utils;
var GeometryUtils = (function () {
    function GeometryUtils() {
    }
    GeometryUtils.arePointsOfOrthogonalLine = function (point1, point2, isHorizontal) {
        return isHorizontal ? (point1.y === point2.y) : (point1.x === point2.x);
    };
    GeometryUtils.getCommonRectangle = function (rects) {
        if (!rects.length)
            return new rectangle_1.Rectangle(0, 0, 0, 0);
        var minX = Number.MAX_VALUE;
        var maxX = -Number.MAX_VALUE;
        var minY = Number.MAX_VALUE;
        var maxY = -Number.MAX_VALUE;
        rects.forEach(function (rect) {
            minX = Math.min(minX, rect.x);
            maxX = Math.max(maxX, rect.right);
            minY = Math.min(minY, rect.y);
            maxY = Math.max(maxY, rect.bottom);
        });
        return new rectangle_1.Rectangle(minX, minY, maxX - minX, maxY - minY);
    };
    GeometryUtils.findFreeSpace = function (rects, size, exact, targetRect) {
        var xs = [targetRect ? targetRect.x : 0];
        var ys = [targetRect ? targetRect.y : 0];
        rects.forEach(function (r) {
            xs.push(r.x);
            xs.push(r.right);
            ys.push(r.y);
            ys.push(r.bottom);
        });
        xs = xs.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (xs[index - 1] !== v && acc.push(v) && acc) || acc; }, []);
        ys = ys.sort(function (a, b) { return a - b; }).reduce(function (acc, v, index) { return (ys[index - 1] !== v && acc.push(v) && acc) || acc; }, []);
        var matrix = ys.map(function (y) { return xs.map(function (x, i) { return xs[i + 1] - x; }); });
        var _loop_1 = function (i, rect) {
            var xi0 = search_1.SearchUtils.binaryIndexOf(xs, function (a) { return a - rect.x; });
            var xi1 = search_1.SearchUtils.binaryIndexOf(xs, function (a) { return a - rect.right; });
            var yi0 = search_1.SearchUtils.binaryIndexOf(ys, function (a) { return a - rect.y; });
            var yi1 = search_1.SearchUtils.binaryIndexOf(ys, function (a) { return a - rect.bottom; });
            for (var y = yi0; y < yi1; y++)
                for (var x = xi0; x < xi1; x++)
                    matrix[y][x] *= -1;
        };
        for (var i = 0, rect = void 0; rect = rects[i]; i++) {
            _loop_1(i, rect);
        }
        for (var yi = 0; yi < ys.length; yi++)
            for (var xi = 0; xi < xs.length - 1; xi++) {
                var checkResult = this.checkRect(matrix, ys, xs, yi, xi, size, exact);
                if (checkResult > 0)
                    xi = checkResult;
                else if (checkResult === 0)
                    return new point_1.Point(xs[xi], ys[yi]);
            }
        return null;
    };
    GeometryUtils.checkRect = function (matrix, ys, xs, yimin, ximin, size, exact) {
        var height = 0;
        var width = 0;
        var ximax = xs.length - 2;
        for (var yi = yimin; yi < ys.length; yi++) {
            height = ys[yi + 1] - ys[yimin];
            for (var xi = ximin; xi <= ximax; xi++) {
                if (matrix[yi][xi] < 0)
                    return xi === 0 ? -1 : xi;
                width = xs[xi + 1] - xs[ximin];
                if (size.width <= width || (!exact && xi === xs.length - 2 && size.width / 2 <= width)) {
                    if (size.height <= height || (!exact && yi === ys.length - 2 && size.height / 2 <= height))
                        return 0;
                    ximax = xi;
                }
            }
        }
    };
    GeometryUtils.getArrowPoints = function (point, directionPoint, arrowHeight, arrowWidth) {
        if (point.x === directionPoint.x && point.y === directionPoint.y)
            return { point1: point.clone(), point2: point.clone(), point3: point.clone() };
        var catX = directionPoint.x - point.x;
        var catY = directionPoint.y - point.y;
        var hypotenuse = Math.sqrt(Math.pow(catX, 2) + Math.pow(catY, 2));
        var cos = catX / hypotenuse;
        var sin = catY / hypotenuse;
        var x1 = point.x + arrowHeight * cos + arrowWidth * sin;
        var y1 = point.y + arrowHeight * sin - arrowWidth * cos;
        var x2 = point.x + arrowHeight * cos - arrowWidth * sin;
        var y2 = point.y + arrowHeight * sin + arrowWidth * cos;
        var x3 = point.x + arrowHeight * cos;
        var y3 = point.y + arrowHeight * sin;
        return { point1: new point_1.Point(x1, y1), point2: new point_1.Point(x2, y2), point3: new point_1.Point(x3, y3) };
    };
    GeometryUtils.createSegments = function (points) {
        var result = [];
        for (var i = 1; i < points.length; i++)
            result.push(new segment_1.Segment(points[i - 1], points[i]));
        return result;
    };
    GeometryUtils.createRectagle = function (points) {
        var xarr = points.map(function (p) { return p.x; });
        var yarr = points.map(function (p) { return p.y; });
        var minX = xarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
        var maxX = xarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
        var minY = yarr.reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
        var maxY = yarr.reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
        return new rectangle_1.Rectangle(minX, minY, maxX - minX, maxY - minY);
    };
    GeometryUtils.createSegmentsFromRectangle = function (rect) {
        var result = [];
        var topLeft = new point_1.Point(rect.x, rect.y);
        var topRight = new point_1.Point(rect.right, rect.y);
        var bottomRight = new point_1.Point(rect.right, rect.bottom);
        var bottomLeft = new point_1.Point(rect.x, rect.bottom);
        result.push(new segment_1.Segment(topLeft, topRight));
        result.push(new segment_1.Segment(topRight, bottomRight));
        result.push(new segment_1.Segment(bottomRight, bottomLeft));
        result.push(new segment_1.Segment(bottomLeft, topLeft));
        return result;
    };
    GeometryUtils.areSegmentsCutRectangle = function (segments, rect) {
        if (!rect)
            return false;
        var rectanlePolygonalChain = GeometryUtils.createSegmentsFromRectangle(rect);
        var hasSegmentIn = false;
        var hasSegmentOut = false;
        var _loop_2 = function (i) {
            if (hasSegmentIn && hasSegmentOut)
                return { value: true };
            var segment = segments[i];
            if (segment.isIntersectedByRect(rect)) {
                var startPoint_1 = segment.startPoint;
                var endPoint_1 = segment.endPoint;
                var currentContainsStart = rect.containsPoint(startPoint_1);
                var currentContainsEnd = rect.containsPoint(endPoint_1);
                if (!currentContainsStart && !currentContainsEnd)
                    return { value: true };
                if (currentContainsStart && !currentContainsEnd) {
                    var rectLinesContainsStart_1 = rectanlePolygonalChain.filter(function (s) { return s.containsPoint(startPoint_1); });
                    if (rectLinesContainsStart_1.length > 0) {
                        var otherRectSegments = rectanlePolygonalChain.filter(function (s) {
                            if (rectLinesContainsStart_1.length === 1)
                                return !s.containsPoint(rectLinesContainsStart_1[0].startPoint) && !s.containsPoint(rectLinesContainsStart_1[0].endPoint);
                            return s !== rectLinesContainsStart_1[0] && s !== rectLinesContainsStart_1[1];
                        });
                        if (otherRectSegments.some(function (s) { return segment.isIntersected(s); }) && !hasSegmentIn)
                            hasSegmentIn = true;
                    }
                    if (!hasSegmentOut)
                        hasSegmentOut = true;
                    return "continue";
                }
                if (!currentContainsStart && currentContainsEnd) {
                    if (!hasSegmentIn) {
                        hasSegmentIn = true;
                        if (hasSegmentOut)
                            hasSegmentOut = false;
                    }
                    var rectLinesContainsEnd_1 = rectanlePolygonalChain.filter(function (s) { return s.containsPoint(endPoint_1); });
                    if (rectLinesContainsEnd_1.length > 0) {
                        var otherRectSegments = rectanlePolygonalChain.filter(function (s) {
                            if (rectLinesContainsEnd_1.length === 1)
                                return !s.containsPoint(rectLinesContainsEnd_1[0].startPoint) && !s.containsPoint(rectLinesContainsEnd_1[0].endPoint);
                            return s !== rectLinesContainsEnd_1[0] && s !== rectLinesContainsEnd_1[1];
                        });
                        if (otherRectSegments.some(function (s) { return segment.isIntersected(s); }) && !hasSegmentOut)
                            hasSegmentOut = true;
                    }
                    return "continue";
                }
                var rectLinesContainsStart = rectanlePolygonalChain.filter(function (s) { return s.containsPoint(startPoint_1); });
                var rectLinesContainsEnd = rectanlePolygonalChain.filter(function (s) { return s.containsPoint(endPoint_1); });
                if (rectLinesContainsStart.length === 2 && rectLinesContainsEnd.length === 2)
                    return { value: true };
                if (rectLinesContainsStart.length === 1 && rectLinesContainsEnd.length === 1 &&
                    rectLinesContainsStart[0] !== rectLinesContainsEnd[0])
                    return { value: true };
                if (!hasSegmentOut && rectLinesContainsEnd.length === 1 && !rectLinesContainsStart.length)
                    hasSegmentOut = true;
                if (!hasSegmentIn && rectLinesContainsStart.length === 1 && !rectLinesContainsEnd.length) {
                    hasSegmentIn = true;
                    if (hasSegmentOut)
                        hasSegmentOut = false;
                }
            }
        };
        for (var i = 0; i < segments.length; i++) {
            var state_1 = _loop_2(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return hasSegmentIn && hasSegmentOut;
    };
    GeometryUtils.areIntersectedSegments = function (segments, otherSegments) {
        if (!otherSegments)
            return false;
        var segmentIndex = 0;
        var segment;
        while (segment = segments[segmentIndex]) {
            var otherSegmentIndex = 0;
            var otherSegment = void 0;
            while (otherSegment = otherSegments[otherSegmentIndex]) {
                if (otherSegment.isIntersected(segment))
                    return true;
                otherSegmentIndex++;
            }
            segmentIndex++;
        }
        return false;
    };
    GeometryUtils.isLineIntersected = function (beginLinePoint, endLinePoint, segment, excludeBeginPoint, excludeEndPoint) {
        var line = LineEquation.fromPoints(beginLinePoint, endLinePoint);
        var segmentStartPoint = segment.startPoint;
        var segmentEndPoint = segment.endPoint;
        if (line.containsPoint(segmentStartPoint) && line.containsPoint(segmentEndPoint))
            return !excludeBeginPoint && !excludeEndPoint;
        var segmentLine = LineEquation.fromPoints(segmentStartPoint, segmentEndPoint);
        var intersection = segmentLine.getPointIntersection(line);
        if (!intersection || !segment.containsPoint(intersection))
            return false;
        if (excludeBeginPoint)
            return !GeometryUtils.areDuplicatedPoints(segmentStartPoint, intersection);
        if (excludeEndPoint)
            return !GeometryUtils.areDuplicatedPoints(segmentEndPoint, intersection);
        return true;
    };
    GeometryUtils.removeUnnecessaryPoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        this.removeUnnecessaryPointsCore(points, removeCallback, checkCallback, accuracy);
        this.removeBackwardPoints(points, removeCallback, checkCallback, accuracy);
        this.removeUnnecessaryPointsCore(points, removeCallback, checkCallback, accuracy);
    };
    GeometryUtils.removeUnnecessaryRightAnglePoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        this.removeUnnecessaryPointsCore(points, removeCallback, checkCallback, accuracy);
        this.removeBackwardPoints(points, removeCallback, checkCallback, accuracy);
        this.removeNotRightAnglePoints(points, removeCallback, checkCallback, accuracy);
        this.removeUnnecessaryPointsCore(points, removeCallback, checkCallback, accuracy);
    };
    GeometryUtils.removeUnnecessaryPointsCore = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        this.removeDuplicatedPoints(points, removeCallback, checkCallback, accuracy);
        this.removeNotCornersPoints(points, removeCallback, checkCallback, accuracy);
    };
    GeometryUtils.removeNotRightAnglePoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        var index = 0;
        var point;
        while ((point = points[index]) && points.length > 2) {
            var nextPoint = this.getNextPoint(points, index, 1, checkCallback);
            var prevPoint = this.getNextPoint(points, index, -1, checkCallback);
            if (!prevPoint || !nextPoint ||
                GeometryUtils.isRightAngleCorner(prevPoint, point, nextPoint, accuracy) ||
                !removeCallback(point, index))
                index++;
        }
    };
    GeometryUtils.removeDuplicatedPoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        var index = 0;
        var point;
        while ((point = points[index]) && points.length > 2) {
            var nextPoint = this.getNextPoint(points, index, 1, checkCallback);
            if (nextPoint && GeometryUtils.areDuplicatedPoints(point, nextPoint, accuracy)) {
                var actualIndex = index === points.length - 2 ? index : index + 1;
                if (removeCallback(points[actualIndex], actualIndex))
                    continue;
            }
            index++;
        }
    };
    GeometryUtils.removeNotCornersPoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        var index = 0;
        var point;
        while ((point = points[index]) && points.length > 2) {
            var nextPoint = this.getNextPoint(points, index, 1, checkCallback);
            var prevPoint = this.getNextPoint(points, index, -1, checkCallback);
            if (!prevPoint || !nextPoint || GeometryUtils.isCorner(prevPoint, point, nextPoint, accuracy))
                index++;
            else if (!removeCallback(point, index))
                index++;
        }
    };
    GeometryUtils.removeBackwardPoints = function (points, removeCallback, checkCallback, accuracy) {
        if (checkCallback === void 0) { checkCallback = function (p) { return p !== undefined; }; }
        if (accuracy === void 0) { accuracy = 0.00001; }
        var index = 0;
        var point;
        while ((point = points[index]) && points.length > 2) {
            var nextPoint = this.getNextPoint(points, index, 1, checkCallback);
            var prevPoint = this.getNextPoint(points, index, -1, checkCallback);
            if (!prevPoint || !nextPoint ||
                !GeometryUtils.isBackwardPoint(prevPoint, point, nextPoint, accuracy) ||
                !removeCallback(point, index))
                index++;
        }
    };
    GeometryUtils.isRightAngleCorner = function (prev, current, next, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return math_1.MathUtils.numberCloseTo(GeometryUtils.createAngle(prev, current, next), Math.PI / 2.0, accuracy) ||
            math_1.MathUtils.numberCloseTo(GeometryUtils.createAngle(prev, current, next), Math.PI, accuracy) ||
            math_1.MathUtils.numberCloseTo(GeometryUtils.createAngle(prev, current, next), 3.0 * Math.PI / 2.0, accuracy);
    };
    GeometryUtils.isCorner = function (prev, current, next, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return !math_1.MathUtils.numberCloseTo(GeometryUtils.createAngle(prev, current, next), 0, accuracy);
    };
    GeometryUtils.areDuplicatedPoints = function (current, next, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return (math_1.MathUtils.numberCloseTo(current.x, next.x, accuracy) && math_1.MathUtils.numberCloseTo(current.y, next.y, accuracy));
    };
    GeometryUtils.isBackwardPoint = function (prev, current, next, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return math_1.MathUtils.numberCloseTo(GeometryUtils.createAngle(prev, current, next), Math.PI, accuracy);
    };
    GeometryUtils.createAngle = function (prev, current, next) {
        var vector1 = vector_1.Vector.fromPoints(current, next);
        var vector2 = vector_1.Vector.fromPoints(prev, current);
        var vector1X = vector1.x;
        var vector1Y = vector1.y;
        var vector2X = vector2.x;
        var vector2Y = vector2.y;
        var atan = Math.atan2(vector1X * vector2Y - vector2X * vector1Y, vector1X * vector2X + vector1Y * vector2Y);
        return atan < 0 ? 2 * Math.PI + atan : atan;
    };
    GeometryUtils.getNextPoint = function (points, index, step, checkCallback) {
        var result;
        var newIndex = index + step;
        while (result = points[newIndex]) {
            if (checkCallback(result))
                return result;
            newIndex = newIndex + step;
        }
    };
    GeometryUtils.addSelectedLinesTo = function (prevPt, pt, nextPt, offsetX, offsetY, offsetXNegative, offsetYNegative, nextOffsetX, nextOffsetY, nextOffsetXNegative, nextOffsetYNegative, addSelectedLine, addSelectedLineWB, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        var a1 = pt.y - prevPt.y;
        var a2 = nextPt.y - pt.y;
        var b1 = prevPt.x - pt.x;
        var b2 = pt.x - nextPt.x;
        var det = a1 * b2 - a2 * b1;
        if (!math_1.MathUtils.numberCloseTo(det, 0, accuracy)) {
            var c1 = a1 * (prevPt.x + offsetX) + b1 * (prevPt.y + offsetY);
            var c2 = a2 * (pt.x + nextOffsetX) + b2 * (pt.y + nextOffsetY);
            addSelectedLine((b2 * c1 - b1 * c2) / det, (a1 * c2 - a2 * c1) / det);
            var c1WB = a1 * (prevPt.x + offsetXNegative) + b1 * (prevPt.y + offsetYNegative);
            var c2WB = a2 * (pt.x + nextOffsetXNegative) + b2 * (pt.y + nextOffsetYNegative);
            addSelectedLineWB((b2 * c1WB - b1 * c2WB) / det, (a1 * c2WB - a2 * c1WB) / det);
        }
    };
    GeometryUtils.getSelectionOffsetPoint = function (prev, current, distance) {
        return new point_1.Point((prev.y - current.y) / distance, (current.x - prev.x) / distance);
    };
    GeometryUtils.getSelectionTextStartEndPoints = function (prev, current, distance, center, size, align) {
        var cos = (current.x - prev.x) / distance;
        var sin = (current.y - prev.y) / distance;
        var width = size.width * cos + size.height * sin;
        switch (align) {
            case Style_1.TextAlignment.Left:
                return [center, new point_1.Point(center.x + cos * width, center.y + sin * width)];
            case Style_1.TextAlignment.Right:
                return [new point_1.Point(center.x - cos * width, center.y - sin * width), center];
            default:
                return [
                    new point_1.Point(center.x - 0.5 * cos * width, center.y - 0.5 * sin * width),
                    new point_1.Point(center.x + 0.5 * cos * width, center.y + 0.5 * sin * width)
                ];
        }
    };
    GeometryUtils.getPathLength = function (points) {
        var length = 0;
        var prevPt;
        points.forEach(function (pt) {
            if (prevPt !== undefined)
                length += metrics_1.Metrics.euclideanDistance(pt, prevPt);
            prevPt = pt;
        });
        return length;
    };
    GeometryUtils.getPathPointByPosition = function (points, relativePosition) {
        if (!points.length)
            throw new Error("Invalid points");
        if (0 > relativePosition || relativePosition > 1)
            throw new Error("Invalid relative position");
        var length = this.getPathLength(points);
        if (points.length <= 2 && length === 0 || relativePosition === 0)
            return [points[0], 0];
        var targetLength = length * relativePosition;
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var lineLength = metrics_1.Metrics.euclideanDistance(points[i], points[i - 1]);
            if (currentLength + lineLength >= targetLength) {
                var delta = targetLength - currentLength;
                var cos = (points[i].x - points[i - 1].x) / lineLength;
                var sin = (points[i].y - points[i - 1].y) / lineLength;
                return [new point_1.Point(points[i - 1].x + cos * delta, points[i - 1].y + sin * delta), i];
            }
            currentLength += lineLength;
        }
        return [points[points.length - 1], points.length - 1];
    };
    GeometryUtils.getLineAngle = function (beginPoint, endPoint) {
        return Math.atan2(endPoint.y - beginPoint.y, endPoint.x - beginPoint.x);
    };
    GeometryUtils.getTriangleBeginAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var beginPointAngle = this.getLineAngle(beginPoint, point);
        return Math.abs(beginPointAngle - lineAngle);
    };
    GeometryUtils.getTriangleEndAngle = function (beginPoint, endPoint, point) {
        var lineAngle = this.getLineAngle(beginPoint, endPoint);
        var endPointAngle = this.getLineAngle(point, endPoint);
        return Math.abs(lineAngle - endPointAngle);
    };
    GeometryUtils.getPathPointByPoint = function (points, point) {
        if (!points.length)
            throw new Error("Invalid points");
        if (points.length === 1)
            return points[0];
        var distance = Number.MAX_VALUE;
        var result;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            if (point.equals(beginPoint)) {
                result = beginPoint.clone();
                break;
            }
            if (point.equals(endPoint)) {
                result = endPoint.clone();
                break;
            }
            var beginAngle = this.getTriangleBeginAngle(beginPoint, endPoint, point);
            var endAngle = this.getTriangleEndAngle(beginPoint, endPoint, point);
            var beginDistance = metrics_1.Metrics.euclideanDistance(point, beginPoint);
            var endDistance = metrics_1.Metrics.euclideanDistance(point, endPoint);
            var orthOffset = beginDistance * Math.sin(beginAngle);
            var currentDistance = void 0;
            if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                currentDistance = beginDistance;
            else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                currentDistance = endDistance;
            else
                currentDistance = Math.abs(orthOffset);
            if (currentDistance < distance) {
                distance = currentDistance;
                if (Math.PI / 2 <= beginAngle && beginAngle <= Math.PI * 3 / 2)
                    result = beginPoint.clone();
                else if (Math.PI / 2 <= endAngle && endAngle <= Math.PI * 3 / 2)
                    result = endPoint.clone();
                else {
                    var round = Math.fround || Math.round;
                    var lineAngle = this.getLineAngle(beginPoint, endPoint);
                    var offsetX = round(Math.abs(orthOffset * Math.sin(lineAngle)));
                    var offsetY = round(Math.abs(orthOffset * Math.cos(lineAngle)));
                    var isAbove = point.y - beginPoint.y < round((point.x - beginPoint.x) * Math.tan(lineAngle));
                    if (0 <= lineAngle && lineAngle <= Math.PI / 2) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (Math.PI / 2 <= lineAngle && lineAngle <= Math.PI) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (0 >= lineAngle && lineAngle >= -Math.PI / 2) {
                        offsetX *= isAbove ? 1 : -1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    else if (-Math.PI / 2 >= lineAngle && lineAngle >= -Math.PI) {
                        offsetX *= isAbove ? -1 : 1;
                        offsetY *= isAbove ? 1 : -1;
                    }
                    result = point.clone().offset(offsetX, offsetY);
                }
            }
        }
        return result;
    };
    GeometryUtils.getPathPositionByPoint = function (points, point, maxPositionCount) {
        if (maxPositionCount === void 0) { maxPositionCount = 100; }
        point = this.getPathPointByPoint(points, point);
        var length = this.getPathLength(points);
        var currentLength = 0;
        for (var i = 1; i < points.length; i++) {
            var beginPoint = points[i - 1];
            var endPoint = points[i];
            var lineLength = metrics_1.Metrics.euclideanDistance(endPoint, beginPoint);
            var angle = Math.atan((endPoint.y - beginPoint.y) / (endPoint.x - beginPoint.x));
            var round = Math.fround || Math.round;
            if ((point.x === endPoint.x && point.x === beginPoint.x) || (point.y === endPoint.y && point.y === beginPoint.y) ||
                round(point.y - beginPoint.y) === round((point.x - beginPoint.x) * Math.tan(angle))) {
                if (Math.sin(angle) !== 0)
                    currentLength += Math.abs((point.y - beginPoint.y) / Math.sin(angle));
                else
                    currentLength += Math.abs(point.x - beginPoint.x);
                return Math.round(currentLength * maxPositionCount / length) / maxPositionCount;
            }
            currentLength += lineLength;
        }
        return 1;
    };
    GeometryUtils.arePointsEqual = function (points1, points2) {
        var count1 = points1.length;
        var count2 = points2.length;
        if (count1 !== count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (!points1[i].equals(points2[i]))
                return false;
        return true;
    };
    GeometryUtils.getMaxRectangleEnscribedInEllipse = function (ellipseSize) {
        var dx = ellipseSize.width * Math.sqrt(2) / 2;
        var dy = ellipseSize.height * Math.sqrt(2) / 2;
        return new size_1.Size(dx, dy);
    };
    GeometryUtils.getEllipseByEnscribedRectangle = function (rectSize) {
        return new size_1.Size(2 * rectSize.width / Math.sqrt(2), 2 * rectSize.height / Math.sqrt(2));
    };
    return GeometryUtils;
}());
exports.GeometryUtils = GeometryUtils;
var ObjectUtils = (function () {
    function ObjectUtils() {
    }
    ObjectUtils.cloneObject = function (source) {
        return source && Object.assign({}, source);
    };
    ObjectUtils.compareObjects = function (obj1, obj2) {
        if (obj1 === obj2)
            return true;
        if (typeof obj1 === "object" && typeof obj2 === "object")
            return this.isDeepEqual(obj1, obj2);
        return false;
    };
    ObjectUtils.isDeepEqual = function (obj1, obj2) {
        var props1 = obj1 ? Object.getOwnPropertyNames(obj1) : [];
        var props2 = obj2 ? Object.getOwnPropertyNames(obj2) : [];
        if (props1.length !== props2.length)
            return false;
        for (var i = 0; i < props1.length; i++) {
            var property = props1[i];
            switch (typeof obj1[property]) {
                case "object": {
                    if (!this.isDeepEqual(obj1[property], obj2[property]))
                        return false;
                    break;
                }
                case "number": {
                    if (!isNaN(obj1[property]) || !isNaN(obj2[property]))
                        if (obj1[property] !== obj2[property])
                            return false;
                    break;
                }
                default: {
                    if (obj1[property] !== obj2[property])
                        return false;
                }
            }
        }
        return true;
    };
    return ObjectUtils;
}());
exports.ObjectUtils = ObjectUtils;
var HtmlFocusUtils = (function () {
    function HtmlFocusUtils() {
    }
    HtmlFocusUtils.focusWithPreventScroll = function (element) {
        try {
            var isPreventScrollNotSupported = browser_1.Browser.Safari;
            var savedDocumentScrollPosition = isPreventScrollNotSupported && this.getHtmlScrollPosition();
            if (isPreventScrollNotSupported) {
                var parentPos = element.parentElement && element.parentElement.getBoundingClientRect();
                if (parentPos) {
                    var left = parentPos.left < 0 ? -parentPos.left + 1 : 0;
                    var top_1 = parentPos.top < 0 ? -parentPos.top + 1 : 0;
                    var iframePos = window.frameElement && window.frameElement.getBoundingClientRect();
                    if (iframePos) {
                        if (iframePos.top < 0 && (-iframePos.top > parentPos.top))
                            top_1 = -iframePos.top - parentPos.top + 1;
                        if (iframePos.left < 0 && (-iframePos.left > parentPos.left))
                            left = -iframePos.left - parentPos.left + 1;
                    }
                    element.style.setProperty("left", left + "px", "important");
                    element.style.setProperty("top", top_1 + "px", "important");
                }
            }
            element.focus({ preventScroll: true });
            if (isPreventScrollNotSupported) {
                var newDocumentScrollPosition = this.getHtmlScrollPosition();
                if (!ObjectUtils.compareObjects(savedDocumentScrollPosition, newDocumentScrollPosition))
                    this.setHtmlScrollPosition(savedDocumentScrollPosition);
                element.style.setProperty("left", "-1000px", "important");
                element.style.setProperty("top", "-1000px", "important");
            }
        }
        catch (e) {
        }
    };
    HtmlFocusUtils.getHtmlScrollPosition = function () {
        return {
            pos: this.getDocumentScrollPosition(window, document),
            iframePos: window.top !== window && this.getDocumentScrollPosition(window.top, window.top.document)
        };
    };
    HtmlFocusUtils.getDocumentScrollPosition = function (win, doc) {
        return {
            left: win.pageXOffset || doc.documentElement.scrollLeft || doc.body.scrollLeft,
            top: win.pageYOffset || doc.documentElement.scrollTop || doc.body.scrollTop
        };
    };
    HtmlFocusUtils.setHtmlScrollPosition = function (position) {
        this.setDocumentScrollPosition(document, position.pos);
        if (window.top !== window && position.iframePos)
            this.setDocumentScrollPosition(window.top.document, position.iframePos);
    };
    HtmlFocusUtils.setDocumentScrollPosition = function (doc, pos) {
        doc.documentElement.scrollTop = pos.top;
        doc.documentElement.scrollLeft = pos.left;
        doc.body.scrollTop = pos.top;
        doc.body.scrollLeft = pos.left;
    };
    return HtmlFocusUtils;
}());
exports.HtmlFocusUtils = HtmlFocusUtils;
var EventUtils = (function () {
    function EventUtils() {
    }
    EventUtils.isLeftButtonPressed = function (evt) {
        return evt_1.EvtUtils.isLeftButtonPressed(evt);
    };
    EventUtils.isPointerEvents = function () {
        return window.PointerEvent;
    };
    EventUtils.isMousePointer = function (evt) {
        return this.isPointerEvents() && ((evt.pointerType && evt.pointerType === "mouse") || (browser_1.Browser.Firefox && evt.type === "click"));
    };
    EventUtils.isTouchMode = function () {
        return browser_1.Browser.TouchUI || (window.navigator && window.navigator.maxTouchPoints > 0);
    };
    EventUtils.isTouchEvent = function (evt) {
        return browser_1.Browser.TouchUI || !EventUtils.isMousePointer(evt);
    };
    return EventUtils;
}());
exports.EventUtils = EventUtils;


/***/ }),

/***/ 78:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveShapeState = void 0;
var MouseHandlerDragDiagramItemStateBase_1 = __webpack_require__(9993);
var MouseHandlerMoveShapeState = (function (_super) {
    __extends(MouseHandlerMoveShapeState, _super);
    function MouseHandlerMoveShapeState(handler, history, model, selection, visualizerManager) {
        var _this = _super.call(this, handler, history, model, selection, visualizerManager) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    Object.defineProperty(MouseHandlerMoveShapeState.prototype, "areValidDraggingShapes", {
        get: function () {
            return this.shouldClone || this.dragHelper.draggingShapes.length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MouseHandlerMoveShapeState.prototype, "areValidDraggingConnectors", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    return MouseHandlerMoveShapeState;
}(MouseHandlerDragDiagramItemStateBase_1.MouseHandlerDragDiagramItemStateBase));
exports.MouseHandlerMoveShapeState = MouseHandlerMoveShapeState;


/***/ }),

/***/ 94:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RectanglePrimitive = void 0;
var RenderHelper_1 = __webpack_require__(8509);
var Primitive_1 = __webpack_require__(8309);
var RectanglePrimitive = (function (_super) {
    __extends(RectanglePrimitive, _super);
    function RectanglePrimitive(x, y, width, height, style, className, clipPathId, onApplyProperties) {
        var _this = _super.call(this, style, className, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    RectanglePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderHelper_1.svgNS, "rect");
    };
    RectanglePrimitive.prototype.applyElementProperties = function (element, measurer) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        this.setUnitAttribute(element, "width", this.width);
        this.setUnitAttribute(element, "height", this.height);
        this.setPositionCorrectionAttribute(element);
        _super.prototype.applyElementProperties.call(this, element, measurer);
    };
    return RectanglePrimitive;
}(Primitive_1.SvgPrimitive));
exports.RectanglePrimitive = RectanglePrimitive;


/***/ }),

/***/ 113:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextInputHandler = void 0;
var ChangeShapeTextHistoryItem_1 = __webpack_require__(6476);
var Event_1 = __webpack_require__(5428);
var key_1 = __webpack_require__(6537);
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(1914);
var TextInputHandler = (function () {
    function TextInputHandler(control) {
        this.control = control;
    }
    TextInputHandler.prototype.startTextInput = function (item, position) {
        if (item.isLocked || !item.enableText || !item.allowEditText || this.control.settings.readOnly || !this.canFinishTextEditing())
            return;
        this.control.beginUpdate();
        this.textInputItem = item;
        var allowed = true;
        if (this.textInputItem instanceof Shape_1.Shape) {
            var textRect = this.textInputItem.textEditRectangle;
            allowed = this.control.permissionsProvider.canChangeShapeText(this.textInputItem);
            if (allowed)
                this.control.eventManager.raiseTextInputStart(this.textInputItem, this.textInputItem.text, textRect.createPosition(), textRect.createSize());
        }
        else if (this.textInputItem instanceof Connector_1.Connector) {
            this.textInputPosition = position;
            allowed = this.control.permissionsProvider.canChangeConnectorText(this.textInputItem, this.textInputPosition);
            if (allowed)
                this.control.eventManager.raiseTextInputStart(this.textInputItem, this.textInputItem.getText(this.textInputPosition), this.textInputItem.getTextPoint(this.textInputPosition));
        }
        if (!allowed) {
            delete this.textInputItem;
            this.control.endUpdate();
        }
    };
    TextInputHandler.prototype.endTextInput = function (captureFocus) {
        var textInputItem = this.textInputItem;
        delete this.textInputItem;
        this.control.eventManager.raiseTextInputEnd(textInputItem, captureFocus);
        this.control.endUpdate();
        this.control.barManager.updateItemsState();
    };
    TextInputHandler.prototype.raiseTextInputPermissionsCheck = function (allowed) {
        this.control.eventManager.raiseTextInputPermissionsCheck(this.textInputItem, allowed);
    };
    TextInputHandler.prototype.applyTextInput = function (text, captureFocus) {
        if (!this.canFinishTextEditing(text))
            return;
        var textInputItem = this.textInputItem;
        var textInputPosition = this.textInputPosition;
        this.endTextInput(captureFocus);
        if (textInputItem instanceof Shape_1.Shape) {
            if (textInputItem.text !== text)
                this.control.history.addAndRedo(new ChangeShapeTextHistoryItem_1.ChangeShapeTextHistoryItem(textInputItem, text));
        }
        else if (textInputItem instanceof Connector_1.Connector)
            if (textInputItem.getText(textInputPosition) !== text)
                this.control.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(textInputItem, textInputPosition, text));
    };
    TextInputHandler.prototype.canFinishTextEditing = function (text) {
        var allowed = true;
        if (this.isTextInputActive()) {
            var newText = text || this.getTextInputElementValue();
            if (this.textInputItem instanceof Shape_1.Shape)
                allowed = this.control.permissionsProvider.canApplyShapeTextChange(this.textInputItem, newText);
            else if (this.textInputItem instanceof Connector_1.Connector)
                allowed = this.control.permissionsProvider.canApplyConnectorTextChange(this.textInputItem, this.textInputPosition, newText);
            this.raiseTextInputPermissionsCheck(allowed);
        }
        return allowed;
    };
    TextInputHandler.prototype.getTextInputElementValue = function () {
        if (this.control.render)
            return this.control.render.input.getTextInputElementValue();
        return "";
    };
    TextInputHandler.prototype.cancelTextInput = function () {
        this.raiseTextInputPermissionsCheck(true);
        this.endTextInput(true);
    };
    TextInputHandler.prototype.isTextInputActive = function () {
        return this.textInputItem !== undefined;
    };
    TextInputHandler.prototype.processDblClick = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Shape) {
            var shape = this.control.model.findShape(evt.source.key);
            this.startTextInput(shape);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.Connector) {
            var connector = this.control.model.findConnector(evt.source.key);
            var position = connector.getTextPositionByPoint(evt.modelPoint);
            this.startTextInput(connector, position);
        }
        else if (evt.source.type === Event_1.MouseEventElementType.ConnectorText) {
            var connector = this.control.model.findConnector(evt.source.key);
            var position = parseFloat(evt.source.value);
            this.startTextInput(connector, position);
        }
    };
    TextInputHandler.prototype.onDblClick = function (evt) {
        var _this = this;
        setTimeout(function () {
            _this.processDblClick(evt);
        }, 10);
    };
    TextInputHandler.prototype.onKeyDown = function (evt) {
        if (!this.isTextInputActive())
            return;
        if (evt.keyCode === 13 && this.hasCtrlModifier(evt.modifiers)) {
            evt.preventDefault = true;
            this.applyTextInput(evt.inputText, true);
        }
        if (evt.keyCode === 27)
            this.cancelTextInput();
    };
    TextInputHandler.prototype.onBlur = function (evt) {
        if (this.isTextInputActive())
            this.applyTextInput(evt.inputText);
    };
    TextInputHandler.prototype.onFocus = function (_) {
    };
    TextInputHandler.prototype.reset = function () {
        delete this.textInputItem;
    };
    TextInputHandler.prototype.hasCtrlModifier = function (key) {
        return (key & key_1.ModifierKey.Ctrl) > 0;
    };
    return TextInputHandler;
}());
exports.TextInputHandler = TextInputHandler;


/***/ }),

/***/ 124:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SearchUtils = void 0;
var SearchUtils = (function () {
    function SearchUtils() {
    }
    SearchUtils.binaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var findFromZeroPosition = minIndex === 0;
        if (maxIndex === -2)
            maxIndex = array.length - 1;
        while (minIndex <= maxIndex) {
            var currentIndex = (minIndex + ((maxIndex - minIndex) >> 1));
            var compare = comparer(array[currentIndex]);
            if (compare < 0)
                minIndex = currentIndex + 1;
            else if (compare > 0)
                maxIndex = currentIndex - 1;
            else
                return currentIndex;
        }
        return findFromZeroPosition ? ~minIndex : -1;
    };
    SearchUtils.normedBinaryIndexOf = function (array, comparer, minIndex, maxIndex) {
        if (minIndex === void 0) { minIndex = 0; }
        if (maxIndex === void 0) { maxIndex = -2; }
        var index = SearchUtils.binaryIndexOf(array, comparer, minIndex, maxIndex);
        return SearchUtils.binaryIndexNormalizator(index);
    };
    SearchUtils.binaryIndexNormalizator = function (index) {
        return index < 0 ? ~index - 1 : index;
    };
    SearchUtils.normedInterpolationIndexOf = function (array, getValue, toFind, lowIndex, highIndex) {
        if (lowIndex === void 0) { lowIndex = 0; }
        if (highIndex === void 0) { highIndex = -2; }
        if (highIndex === -2)
            highIndex = array.length - 1;
        var firstObject = array[Math.min(lowIndex, highIndex)];
        if (firstObject === undefined || toFind < getValue(firstObject))
            return -1;
        var lowValue = getValue(array[lowIndex]);
        var highValue = getValue(array[highIndex]);
        while (true) {
            if (toFind > lowValue && toFind < highValue) {
                var midIndex = lowIndex + Math.floor(((toFind - lowValue) * (highIndex - lowIndex)) / (highValue - lowValue));
                var midValue = getValue(array[midIndex]);
                if (toFind > midValue) {
                    lowIndex = midIndex + 1;
                    lowValue = getValue(array[lowIndex]);
                    if (toFind < lowValue)
                        return midIndex;
                }
                else if (toFind < midValue) {
                    highIndex = midIndex - 1;
                    highValue = getValue(array[highIndex]);
                }
                else
                    return midIndex;
            }
            else
                return toFind === lowValue ? lowIndex : highIndex;
        }
    };
    return SearchUtils;
}());
exports.SearchUtils = SearchUtils;


/***/ }),

/***/ 128:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextPrimitive270degRenderHelper = exports.TextPrimitive180degRenderHelper = exports.TextPrimitive90degRenderHelper = exports.TextPrimitiveRenderHelper = exports.TextPrimitive = exports.TextAngle = void 0;
var unit_converter_1 = __webpack_require__(9500);
var RenderHelper_1 = __webpack_require__(8509);
var Primitive_1 = __webpack_require__(8309);
var Utils_1 = __webpack_require__(2136);
var TextUtils_1 = __webpack_require__(1842);
var TextAngle;
(function (TextAngle) {
    TextAngle[TextAngle["Angle0deg"] = 0] = "Angle0deg";
    TextAngle[TextAngle["Angle90deg"] = 90] = "Angle90deg";
    TextAngle[TextAngle["Angle180deg"] = 180] = "Angle180deg";
    TextAngle[TextAngle["Angle270deg"] = 270] = "Angle270deg";
})(TextAngle = exports.TextAngle || (exports.TextAngle = {}));
var TextPrimitive = (function (_super) {
    __extends(TextPrimitive, _super);
    function TextPrimitive(x, y, text, owner, textWidth, textHeight, textSpacing, style, reverseTextAhchor, clipPathId, filterId, angle, onApplyProperties) {
        var _this = _super.call(this, style, "", clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.text = text;
        _this.owner = owner;
        _this.textWidth = textWidth;
        _this.textHeight = textHeight;
        _this.textSpacing = textSpacing;
        _this.reverseTextAhchor = reverseTextAhchor;
        _this.angle = angle;
        _this.filterId = filterId;
        _this.textSegmens = (0, TextUtils_1.textToParagraphs)(_this.text);
        _this.renderHelper = _this.createRenderHelper();
        if (_this.textWidth !== undefined && _this.textWidth !== undefined) {
            _this.x = _this.renderHelper.getTextX(_this.x);
            _this.y = _this.renderHelper.getTextY(_this.y);
        }
        return _this;
    }
    TextPrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderHelper_1.svgNS, "text");
    };
    TextPrimitive.prototype.applyElementProperties = function (element, measurer) {
        this.setUnitAttribute(element, "x", this.x);
        this.setUnitAttribute(element, "y", this.y);
        if (this.filterId)
            element.setAttribute("filter", Utils_1.RenderUtils.getUrlPathById(this.filterId));
        _super.prototype.applyElementProperties.call(this, element, measurer);
        if (element.getAttribute("appliedText") !== this.text || element.getAttribute("appliedSize") !== (this.fitToSize && this.fitToSize.toString())) {
            this.createTSpanElements(element, measurer);
            element.setAttribute("appliedText", this.text);
            element.setAttribute("appliedSize", (this.fitToSize && this.fitToSize.toString()));
        }
        else
            this.prepareTSpanElements(element);
        this.renderHelper.prepareMainElement(element, this.x, this.y);
    };
    TextPrimitive.prototype.createTSpanElements = function (element, measurer) {
        var _this = this;
        Utils_1.RenderUtils.removeContent(element);
        this.textSegmens.forEach(function (txt, index) {
            if (!txt && _this.textSegmens.length > 1) {
                var span = _this.createTSpanElement(element);
                span.textContent = " ";
            }
            else if (_this.fitToSize) {
                var words_1 = (0, TextUtils_1.textToWords)(txt);
                var lines = (0, TextUtils_1.wordsByLines)(unit_converter_1.UnitConverter.twipsToPixels(_this.fitToSize), words_1, function () { return measurer.measureWords(words_1, _this.style, _this.owner); });
                lines.forEach(function (line) {
                    var span = _this.createTSpanElement(element);
                    span.textContent = line;
                });
                if (!lines.length) {
                    var span = _this.createTSpanElement(element);
                    span.textContent = " ";
                }
            }
            else {
                var tSpan = _this.createTSpanElement(element);
                tSpan.textContent = txt;
            }
        });
        var firstTSpan = element.firstChild;
        if (firstTSpan)
            this.prepareFirstTSpanElement(firstTSpan, element.childNodes.length);
    };
    TextPrimitive.prototype.createTSpanElement = function (parent) {
        var tSpan = document.createElementNS(RenderHelper_1.svgNS, "tspan");
        parent.appendChild(tSpan);
        this.prepareTSpanElement(tSpan);
        return tSpan;
    };
    TextPrimitive.prototype.prepareTSpanElements = function (element) {
        for (var i = 0; i < element.childNodes.length; i++) {
            var tSpan = element.childNodes[i];
            this.prepareTSpanElement(tSpan);
        }
        var firstTSpan = element.firstChild;
        if (firstTSpan)
            this.prepareFirstTSpanElement(firstTSpan, element.childNodes.length);
    };
    TextPrimitive.prototype.prepareTSpanElement = function (tSpan) {
        this.renderHelper.prepareTSpanElement(tSpan, this.x, this.y);
    };
    TextPrimitive.prototype.prepareFirstTSpanElement = function (tSpan, lineCount) {
        this.renderHelper.prepareFirstTSpanElement(tSpan, lineCount);
    };
    TextPrimitive.prototype.applyElementStyleProperties = function (element) {
        this.applyElementStylePropertiesCore(element, this.reverseTextAhchor);
    };
    Object.defineProperty(TextPrimitive.prototype, "fitToSize", {
        get: function () { return this.renderHelper.fitToSize; },
        enumerable: false,
        configurable: true
    });
    TextPrimitive.prototype.createRenderHelper = function () {
        switch (this.angle) {
            case TextAngle.Angle90deg:
                return new TextPrimitive90degRenderHelper(this);
            case TextAngle.Angle180deg:
                return new TextPrimitive180degRenderHelper(this);
            case TextAngle.Angle270deg:
                return new TextPrimitive270degRenderHelper(this);
            default:
                return new TextPrimitiveRenderHelper(this);
        }
    };
    TextPrimitive.baselineCorrection = 0.35;
    return TextPrimitive;
}(Primitive_1.SvgPrimitive));
exports.TextPrimitive = TextPrimitive;
var TextPrimitiveRenderHelper = (function () {
    function TextPrimitiveRenderHelper(primitive) {
        this.primitive = primitive;
    }
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "textWidth", {
        get: function () { return this.primitive.textWidth; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "textHeight", {
        get: function () { return this.primitive.textHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "fitToSize", {
        get: function () { return this.textWidth; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "textAnchor", {
        get: function () { return this.primitive.style["text-anchor"]; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "textSpacing", {
        get: function () { return this.primitive.textSpacing; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "angle", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitiveRenderHelper.prototype, "needRotation", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    TextPrimitiveRenderHelper.prototype.prepareMainElement = function (element, x, y) {
        if (this.needRotation)
            element.setAttribute("transform", "rotate(" + this.angle + ", " +
                unit_converter_1.UnitConverter.twipsToPixels(x) + ", " + unit_converter_1.UnitConverter.twipsToPixels(y) + ")");
    };
    TextPrimitiveRenderHelper.prototype.prepareTSpanElement = function (tSpan, x, y) {
        this.primitive.setUnitAttribute(tSpan, "x", x);
        tSpan.setAttribute("dy", TextUtils_1.LINE_HEIGHT + "em");
    };
    TextPrimitiveRenderHelper.prototype.prepareFirstTSpanElement = function (tSpan, lineCount) {
        var dy = -((lineCount - 1) / 2) + TextPrimitive.baselineCorrection;
        tSpan.setAttribute("dy", dy.toFixed(2) + "em");
    };
    TextPrimitiveRenderHelper.prototype.getTextX = function (x) {
        if (!this.textAnchor || this.textAnchor === "middle")
            return x + this.textWidth / 2;
        else if (this.textAnchor === "end")
            return x + this.textWidth - this.textSpacing;
        else if (this.textAnchor === "start")
            return x + this.textSpacing;
        return x;
    };
    TextPrimitiveRenderHelper.prototype.getTextY = function (y) {
        return y + this.textHeight / 2;
    };
    TextPrimitiveRenderHelper.prototype.setUnitAttribute = function (element, key, value) {
        this.primitive.setUnitAttribute(element, key, value);
    };
    return TextPrimitiveRenderHelper;
}());
exports.TextPrimitiveRenderHelper = TextPrimitiveRenderHelper;
var TextPrimitive90degRenderHelper = (function (_super) {
    __extends(TextPrimitive90degRenderHelper, _super);
    function TextPrimitive90degRenderHelper(primitive) {
        return _super.call(this, primitive) || this;
    }
    Object.defineProperty(TextPrimitive90degRenderHelper.prototype, "fitToSize", {
        get: function () { return this.textHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitive90degRenderHelper.prototype, "angle", {
        get: function () { return 90; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitive90degRenderHelper.prototype, "needRotation", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    TextPrimitive90degRenderHelper.prototype.getTextX = function (x) {
        return x + this.textWidth / 2;
    };
    TextPrimitive90degRenderHelper.prototype.getTextY = function (y) {
        if (!this.textAnchor || this.textAnchor === "middle")
            return y + this.textHeight / 2;
        else if (this.textAnchor === "end")
            return y + this.textHeight - this.textSpacing;
        else if (this.textAnchor === "start")
            return y + this.textSpacing;
        return y;
    };
    return TextPrimitive90degRenderHelper;
}(TextPrimitiveRenderHelper));
exports.TextPrimitive90degRenderHelper = TextPrimitive90degRenderHelper;
var TextPrimitive180degRenderHelper = (function (_super) {
    __extends(TextPrimitive180degRenderHelper, _super);
    function TextPrimitive180degRenderHelper(primitive) {
        return _super.call(this, primitive) || this;
    }
    Object.defineProperty(TextPrimitive180degRenderHelper.prototype, "angle", {
        get: function () { return 180; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TextPrimitive180degRenderHelper.prototype, "needRotation", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    TextPrimitive180degRenderHelper.prototype.getTextX = function (x) {
        if (!this.textAnchor || this.textAnchor === "middle")
            return x + this.textWidth / 2;
        else if (this.textAnchor === "start")
            return x + this.textWidth - this.textSpacing;
        else if (this.textAnchor === "end")
            return x + this.textSpacing;
        return x;
    };
    return TextPrimitive180degRenderHelper;
}(TextPrimitiveRenderHelper));
exports.TextPrimitive180degRenderHelper = TextPrimitive180degRenderHelper;
var TextPrimitive270degRenderHelper = (function (_super) {
    __extends(TextPrimitive270degRenderHelper, _super);
    function TextPrimitive270degRenderHelper(primitive) {
        return _super.call(this, primitive) || this;
    }
    Object.defineProperty(TextPrimitive270degRenderHelper.prototype, "angle", {
        get: function () { return 270; },
        enumerable: false,
        configurable: true
    });
    TextPrimitive270degRenderHelper.prototype.getTextY = function (y) {
        if (!this.textAnchor || this.textAnchor === "middle")
            return y + this.textHeight / 2;
        else if (this.textAnchor === "start")
            return y + this.textHeight - this.textSpacing;
        else if (this.textAnchor === "end")
            return y + this.textSpacing;
        return y;
    };
    return TextPrimitive270degRenderHelper;
}(TextPrimitive90degRenderHelper));
exports.TextPrimitive270degRenderHelper = TextPrimitive270degRenderHelper;


/***/ }),

/***/ 131:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveShapeEventArgs = exports.MoveShapeRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var MoveShapeRequestedEntity = (function (_super) {
    __extends(MoveShapeRequestedEntity, _super);
    function MoveShapeRequestedEntity(apiController, shape, oldPosition, position) {
        var _this = _super.call(this, apiController) || this;
        _this.shape = shape;
        _this.oldPosition = oldPosition;
        _this.position = position;
        return _this;
    }
    Object.defineProperty(MoveShapeRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.MoveShape;
        },
        enumerable: false,
        configurable: true
    });
    MoveShapeRequestedEntity.prototype.createEventArgs = function () {
        return new MoveShapeEventArgs(this.apiController.createNativeShape(this.shape), this.apiController.convertPoint(this.oldPosition), this.apiController.convertPoint(this.position));
    };
    Object.defineProperty(MoveShapeRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "moveShape";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MoveShapeRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.shape && this.shape.key);
        },
        enumerable: false,
        configurable: true
    });
    MoveShapeRequestedEntity.prototype.equals = function (other) {
        if (other instanceof MoveShapeRequestedEntity)
            return this.shape === other.shape && this.oldPosition.equals(other.oldPosition) && this.position.equals(other.position);
        return false;
    };
    return MoveShapeRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.MoveShapeRequestedEntity = MoveShapeRequestedEntity;
var MoveShapeEventArgs = (function (_super) {
    __extends(MoveShapeEventArgs, _super);
    function MoveShapeEventArgs(shape, oldPosition, position) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        _this.oldPosition = oldPosition;
        _this.position = position;
        return _this;
    }
    return MoveShapeEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.MoveShapeEventArgs = MoveShapeEventArgs;


/***/ }),

/***/ 132:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportPngCommand = void 0;
var ExportImageCommand_1 = __webpack_require__(6634);
var ExportPngCommand = (function (_super) {
    __extends(ExportPngCommand, _super);
    function ExportPngCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportPngCommand.prototype.getExtension = function () { return "png"; };
    ExportPngCommand.prototype.getExportFunc = function () {
        return this.exporter.exportPng;
    };
    return ExportPngCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportPngCommand = ExportPngCommand;


/***/ }),

/***/ 149:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseObjectsIterator = void 0;
var tslib_1 = __webpack_require__(5215);
var iterator_1 = __webpack_require__(1454);
var SparseObjectsIterator = (function (_super) {
    tslib_1.__extends(SparseObjectsIterator, _super);
    function SparseObjectsIterator(sparseIntervals, objects) {
        var _this = _super.call(this, sparseIntervals) || this;
        _this.objects = objects;
        return _this;
    }
    SparseObjectsIterator.prototype.initObject = function () {
        this.obj = this.objects[this.index];
    };
    return SparseObjectsIterator;
}(iterator_1.SparseIntervalsIterator));
exports.SparseObjectsIterator = SparseObjectsIterator;


/***/ }),

/***/ 156:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PredefinedProcessShapeDescription = exports.PredefinedProcessEdgeParameterName = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var ShapeParameters_1 = __webpack_require__(4636);
var ShapeParameterPoint_1 = __webpack_require__(9763);
var point_1 = __webpack_require__(5327);
var PathPrimitive_1 = __webpack_require__(6208);
exports.PredefinedProcessEdgeParameterName = "e";
var PredefinedProcessShapeDescription = (function (_super) {
    __extends(PredefinedProcessShapeDescription, _super);
    function PredefinedProcessShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(PredefinedProcessShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.PredefinedProcess; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PredefinedProcessShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    PredefinedProcessShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom;
        var x1 = left + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var x2 = right - shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        var primitives = _super.prototype.createShapePrimitives.call(this, shape);
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom)
            ], shape.style)
        ]);
    };
    PredefinedProcessShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addIfNotExists(new ShapeParameters_1.ShapeParameter(exports.PredefinedProcessEdgeParameterName, this.defaultSize.width * 0.1));
    };
    PredefinedProcessShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return Math.max(PredefinedProcessShapeDescription.minEdge, Math.min(shape.size.width * 0.3, p.value)); });
    };
    PredefinedProcessShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.PredefinedProcessEdgeParameterName, function (p) { return p.value + deltaX; });
        this.normalizeParameters(shape, parameters);
    };
    PredefinedProcessShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new point_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value), shape.position.y))
        ];
    };
    PredefinedProcessShapeDescription.prototype.getTextRectangle = function (shape) {
        var rect = shape.rectangle;
        var dx = shape.parameters.get(exports.PredefinedProcessEdgeParameterName).value;
        return rect.clone().resize(-2 * dx, 0).clone().moveRectangle(dx, 0);
    };
    PredefinedProcessShapeDescription.minEdge = 72;
    return PredefinedProcessShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PredefinedProcessShapeDescription = PredefinedProcessShapeDescription;


/***/ }),

/***/ 166:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArrowDownShapeDescription = void 0;
var PathPrimitive_1 = __webpack_require__(6208);
var ShapeParameterPoint_1 = __webpack_require__(9763);
var point_1 = __webpack_require__(5327);
var ArrowVerticalShapeDescription_1 = __webpack_require__(7436);
var ShapeTypes_1 = __webpack_require__(3255);
var DiagramItem_1 = __webpack_require__(4824);
var ArrowDownShapeDescription = (function (_super) {
    __extends(ArrowDownShapeDescription, _super);
    function ArrowDownShapeDescription() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ArrowDownShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowDown; },
        enumerable: false,
        configurable: true
    });
    ArrowDownShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var p1dx = (width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2;
        var p0dy = height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        var p1x1 = shape.normalizeX(left + p1dx);
        var p0y1 = shape.normalizeY(top + p0dy);
        var p1x2 = shape.normalizeX(right - p1dx);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(p1x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x2, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p0y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p1x1, p0y1),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowDownShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName, function (p) { return p.value - deltaY; });
        this.changeParameterValue(parameters, ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowDownShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new point_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalLineWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + shape.size.height - shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value)))
        ];
    };
    ArrowDownShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleHeight = shape.parameters.get(ArrowVerticalShapeDescription_1.ArrowVerticalTriangleHeightParameterName).value;
        if (point.y > shape.position.y + shape.size.height - triangleHeight) {
            var tg = shape.size.width / 2 / triangleHeight;
            var delta = (point.y - (shape.position.y + shape.size.height - triangleHeight)) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.x -= delta;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.x += delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowDownShapeDescription;
}(ArrowVerticalShapeDescription_1.ArrowVerticalShapeDescription));
exports.ArrowDownShapeDescription = ArrowDownShapeDescription;


/***/ }),

/***/ 195:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportCommand = void 0;
var Exporter_1 = __webpack_require__(8762);
var ExportImportCommandBase_1 = __webpack_require__(6089);
var ExportCommand = (function (_super) {
    __extends(ExportCommand, _super);
    function ExportCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportCommand.prototype.executeCore = function (state, parameter) {
        var exporter = new Exporter_1.Exporter();
        var data = exporter.export(this.control.model);
        parameter(data);
        return true;
    };
    return ExportCommand;
}(ExportImportCommandBase_1.ExportImportCommandBase));
exports.ExportCommand = ExportCommand;


/***/ }),

/***/ 268:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentShapeDescription = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var PathPrimitive_1 = __webpack_require__(6208);
var DiagramItem_1 = __webpack_require__(4824);
var DocumentShapeDescription = (function (_super) {
    __extends(DocumentShapeDescription, _super);
    function DocumentShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(DocumentShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Document; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DocumentShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    DocumentShapeDescription.prototype.createShapePrimitives = function (shape) {
        return this.createDocumentPrimitives(shape.rectangle, shape.style);
    };
    DocumentShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * DocumentShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    DocumentShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * DocumentShapeDescription.curveOffsetRatio;
    };
    DocumentShapeDescription.prototype.getTextRectangle = function (shape) {
        var rect = shape.rectangle;
        return rect.clone().resize(0, -rect.height * DocumentShapeDescription.curveOffsetRatio);
    };
    DocumentShapeDescription.curveOffsetRatio = 0.1;
    return DocumentShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DocumentShapeDescription = DocumentShapeDescription;


/***/ }),

/***/ 281:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShapeDescriptionManager = void 0;
var ProcessShapeDescription_1 = __webpack_require__(5290);
var DecisionShapeDescription_1 = __webpack_require__(9415);
var ManualInputShapeDescription_1 = __webpack_require__(5005);
var DataShapeDescription_1 = __webpack_require__(3489);
var TerminatorShapeDescription_1 = __webpack_require__(7368);
var PredefinedProcessShapeDescription_1 = __webpack_require__(156);
var ArrowUpDownShapeDescription_1 = __webpack_require__(7443);
var ArrowRightShapeDescription_1 = __webpack_require__(2444);
var ArrowUpShapeDescription_1 = __webpack_require__(6855);
var CrossShapeDescription_1 = __webpack_require__(3415);
var DiamondShapeDescription_1 = __webpack_require__(7763);
var EllipseShapeDescription_1 = __webpack_require__(9829);
var HeartShapeDescription_1 = __webpack_require__(7727);
var RectangleShapeDescription_1 = __webpack_require__(3190);
var TextShapeDescription_1 = __webpack_require__(8278);
var PentagonShapeDescription_1 = __webpack_require__(3165);
var HexagonShapeDescription_1 = __webpack_require__(9543);
var OctagonShapeDescription_1 = __webpack_require__(9496);
var StarShapeDescription_1 = __webpack_require__(8005);
var ArrowDownShapeDescription_1 = __webpack_require__(166);
var ArrowLeftRightShapeDescription_1 = __webpack_require__(3475);
var ArrowLeftShapeDescription_1 = __webpack_require__(5455);
var TriangleShapeDescription_1 = __webpack_require__(1833);
var DocumentShapeDescription_1 = __webpack_require__(268);
var MultipleDocumentsShapeDescription_1 = __webpack_require__(9901);
var PreparationShapeDescription_1 = __webpack_require__(7450);
var HardDiskShapeDescription_1 = __webpack_require__(2781);
var DatabaseShapeDescription_1 = __webpack_require__(9968);
var InternalStorageShapeDescription_1 = __webpack_require__(9613);
var PaperTapeShapeDescription_1 = __webpack_require__(1381);
var ManualOperationShapeDescription_1 = __webpack_require__(2392);
var DelayShapeDescription_1 = __webpack_require__(9904);
var StoredDataShapeDescription_1 = __webpack_require__(9758);
var MergeShapeDescription_1 = __webpack_require__(5803);
var DisplayShapeDescription_1 = __webpack_require__(8321);
var OrShapeDescription_1 = __webpack_require__(2092);
var SummingJunctionShapeDescription_1 = __webpack_require__(1493);
var CustomShapeDescription_1 = __webpack_require__(2567);
var VerticalContainerDescription_1 = __webpack_require__(6621);
var HorizontalContainerDescription_1 = __webpack_require__(6283);
var CardWithImageOnTopDescription_1 = __webpack_require__(7837);
var ShapeTypes_1 = __webpack_require__(3255);
var ConnectorShapeDescription_1 = __webpack_require__(5656);
var Utils_1 = __webpack_require__(41);
var CardWithHorizontalImageDescription_1 = __webpack_require__(321);
var ShapeDescriptionManager = (function () {
    function ShapeDescriptionManager() {
        this.descriptions = {};
        this.descriptionTypes = {};
        this.descriptionCategories = {};
        this.onShapeDecriptionChanged = new Utils_1.EventDispatcher();
        this.register(new TextShapeDescription_1.TextShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new RectangleShapeDescription_1.RectangleShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new EllipseShapeDescription_1.EllipseShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new CrossShapeDescription_1.CrossShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new TriangleShapeDescription_1.TriangleShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new DiamondShapeDescription_1.DiamondShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new HeartShapeDescription_1.HeartShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new PentagonShapeDescription_1.PentagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new HexagonShapeDescription_1.HexagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new OctagonShapeDescription_1.OctagonShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new StarShapeDescription_1.StarShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowUpShapeDescription_1.ArrowUpShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowDownShapeDescription_1.ArrowDownShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowLeftShapeDescription_1.ArrowLeftShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowRightShapeDescription_1.ArrowRightShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowUpDownShapeDescription_1.ArrowUpDownShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ArrowLeftRightShapeDescription_1.ArrowLeftRightShapeDescription(), ShapeTypes_1.ShapeCategories.General);
        this.register(new ProcessShapeDescription_1.ProcessShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DecisionShapeDescription_1.DecisionShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new TerminatorShapeDescription_1.TerminatorShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new PredefinedProcessShapeDescription_1.PredefinedProcessShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DocumentShapeDescription_1.DocumentShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new MultipleDocumentsShapeDescription_1.MultipleDocumentsShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new ManualInputShapeDescription_1.ManualInputShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new PreparationShapeDescription_1.PreparationShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DataShapeDescription_1.DataShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DatabaseShapeDescription_1.DatabaseShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new HardDiskShapeDescription_1.HardDiskShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new InternalStorageShapeDescription_1.InternalStorageShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new PaperTapeShapeDescription_1.PaperTapeShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new ManualOperationShapeDescription_1.ManualOperationShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DelayShapeDescription_1.DelayShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new StoredDataShapeDescription_1.StoredDataShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new DisplayShapeDescription_1.DisplayShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new MergeShapeDescription_1.MergeShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new ConnectorShapeDescription_1.ConnectorShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new OrShapeDescription_1.OrShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new SummingJunctionShapeDescription_1.SummingJunctionShapeDescription(), ShapeTypes_1.ShapeCategories.Flowchart);
        this.register(new CardWithHorizontalImageDescription_1.CardWithImageOnLeftDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
        this.register(new CardWithHorizontalImageDescription_1.CardWithImageOnRightDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
        this.register(new CardWithImageOnTopDescription_1.CardWithImageOnTopDescription(), ShapeTypes_1.ShapeCategories.OrgChart);
        this.register(new VerticalContainerDescription_1.VerticalContainerDescription(), ShapeTypes_1.ShapeCategories.Containers);
        this.register(new HorizontalContainerDescription_1.HorizontalContainerDescription(), ShapeTypes_1.ShapeCategories.Containers);
    }
    Object.defineProperty(ShapeDescriptionManager, "default", {
        get: function () {
            return ShapeDescriptionManager.defaultInstance;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescriptionManager, "defaultContainer", {
        get: function () {
            return ShapeDescriptionManager.defaultContainerInstance;
        },
        enumerable: false,
        configurable: true
    });
    ShapeDescriptionManager.prototype.get = function (type) {
        return this.descriptions[type];
    };
    ShapeDescriptionManager.prototype.getTypesByCategory = function (category) {
        return this.descriptionTypes[category] || [];
    };
    ShapeDescriptionManager.prototype.getCategoryByType = function (type) {
        return this.descriptionCategories[type];
    };
    ShapeDescriptionManager.prototype.getCategoryByDescription = function (description) {
        return this.getCategoryByType(description.key);
    };
    ShapeDescriptionManager.prototype.register = function (description, category, type) {
        if (type === void 0) { type = description.key; }
        if (this.descriptions[type] !== undefined)
            throw Error("Description key is duplicated");
        this.descriptions[type] = description;
        if (!this.descriptionTypes[category])
            this.descriptionTypes[category] = [];
        this.descriptionTypes[category].push(type);
        this.descriptionCategories[type] = category;
        description.onChanged.add(this);
    };
    ShapeDescriptionManager.prototype.registerCustomShape = function (shape) {
        if (shape.type === undefined)
            throw Error("Custom shape type is not defined");
        if (this.descriptions[shape.type] !== undefined)
            throw Error("Custom shape type is duplicated");
        var baseDescription = shape.baseType && this.descriptions[shape.baseType];
        if (shape.minWidth > shape.maxWidth)
            shape.maxWidth = shape.minWidth;
        if (shape.minHeight > shape.maxHeight)
            shape.maxHeight = shape.minHeight;
        this.register(new CustomShapeDescription_1.CustomShapeDescription(shape, baseDescription), shape.category || ShapeTypes_1.ShapeCategories.Custom);
    };
    ShapeDescriptionManager.prototype.unregisterCustomShape = function (shapeType) {
        var description = this.descriptions[shapeType];
        if (description instanceof CustomShapeDescription_1.CustomShapeDescription) {
            description.onChanged.remove(this);
            var category = this.descriptionCategories[shapeType];
            delete this.descriptions[shapeType];
            delete this.descriptionCategories[shapeType];
            var index = this.descriptionTypes[category].indexOf(shapeType);
            this.descriptionTypes[category].splice(index, 1);
            if (this.descriptionTypes[category].length === 0)
                delete this.descriptionTypes[category];
        }
    };
    ShapeDescriptionManager.prototype.unregisterAllCustomShapes = function () {
        var _this = this;
        Object.keys(this.descriptions).forEach(function (shapeType) {
            _this.unregisterCustomShape(shapeType);
        });
    };
    ShapeDescriptionManager.prototype.notifyShapeDescriptionChanged = function (description) {
        this.onShapeDecriptionChanged.raise1(function (l) { return l.notifyShapeDescriptionChanged(description); });
    };
    ShapeDescriptionManager.defaultInstance = new RectangleShapeDescription_1.RectangleShapeDescription();
    ShapeDescriptionManager.defaultContainerInstance = new VerticalContainerDescription_1.VerticalContainerDescription();
    return ShapeDescriptionManager;
}());
exports.ShapeDescriptionManager = ShapeDescriptionManager;


/***/ }),

/***/ 321:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CardWithImageOnRightDescription = exports.CardWithImageOnLeftDescription = void 0;
var ShapeDescription_1 = __webpack_require__(1280);
var ShapeTypes_1 = __webpack_require__(3255);
var CardBaseDescription_1 = __webpack_require__(5311);
var size_1 = __webpack_require__(3844);
var CardWithHorizontalImageDescription = (function (_super) {
    __extends(CardWithHorizontalImageDescription, _super);
    function CardWithHorizontalImageDescription() {
        var _this = _super.call(this, new size_1.Size(1.5 * ShapeDescription_1.ShapeDefaultDimension, 0.5 * ShapeDescription_1.ShapeDefaultDimension)) || this;
        _this.isHorizontal = true;
        return _this;
    }
    CardWithHorizontalImageDescription.prototype.getToolboxHeightToWidthRatio = function (_width, _height) {
        return 26 / 46;
    };
    CardWithHorizontalImageDescription.prototype.getImageSize = function (shapeSize, includeMargins, forToolbox) {
        var imageSize = Math.min(shapeSize.height, shapeSize.width);
        if (!includeMargins)
            imageSize = Math.max(0, imageSize - 2 * this.getImageMargin(forToolbox));
        return new size_1.Size(imageSize, imageSize);
    };
    CardWithHorizontalImageDescription.prototype.getImageSizeByTextBlockSize = function (textBlockSize) {
        return this.getImageSize(new size_1.Size(Number.MAX_VALUE, textBlockSize.height), true);
    };
    return CardWithHorizontalImageDescription;
}(CardBaseDescription_1.CardBaseDescription));
var CardWithImageOnLeftDescription = (function (_super) {
    __extends(CardWithImageOnLeftDescription, _super);
    function CardWithImageOnLeftDescription() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isTextAfterImage = true;
        return _this;
    }
    Object.defineProperty(CardWithImageOnLeftDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.CardWithImageOnLeft; },
        enumerable: false,
        configurable: true
    });
    return CardWithImageOnLeftDescription;
}(CardWithHorizontalImageDescription));
exports.CardWithImageOnLeftDescription = CardWithImageOnLeftDescription;
var CardWithImageOnRightDescription = (function (_super) {
    __extends(CardWithImageOnRightDescription, _super);
    function CardWithImageOnRightDescription() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isTextAfterImage = false;
        return _this;
    }
    Object.defineProperty(CardWithImageOnRightDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.CardWithImageOnRight; },
        enumerable: false,
        configurable: true
    });
    return CardWithImageOnRightDescription;
}(CardWithHorizontalImageDescription));
exports.CardWithImageOnRightDescription = CardWithImageOnRightDescription;


/***/ }),

/***/ 401:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorSideState = void 0;
var MouseHandlerDraggingState_1 = __webpack_require__(2815);
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerMoveConnectorSideState = (function (_super) {
    __extends(MouseHandlerMoveConnectorSideState, _super);
    function MouseHandlerMoveConnectorSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.connectorKey = evt.source.key;
        this.pointIndex = parseInt(evt.source.value) + 1;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorSideState.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        var connector = this.model.findConnector(this.connectorKey);
        if (!this.pointCreated) {
            this.handler.addInteractingItem(connector);
            ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connectorKey, this.pointIndex, point.clone());
            this.pointCreated = true;
        }
        else
            ModelUtils_1.ModelUtils.moveConnectorPoint(this.history, connector, this.pointIndex, point);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorSideState.prototype.onFinishWithChanges = function () {
        var connector = this.model.findConnector(this.connectorKey);
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, connector);
        ModelUtils_1.ModelUtils.fixConnectorBeginEndConnectionIndex(this.history, connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorSideState.prototype.getDraggingElementKeys = function () {
        return [this.connectorKey];
    };
    return MouseHandlerMoveConnectorSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorSideState = MouseHandlerMoveConnectorSideState;


/***/ }),

/***/ 455:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramModel = void 0;
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var Utils_1 = __webpack_require__(41);
var rectangle_1 = __webpack_require__(4412);
var size_1 = __webpack_require__(3844);
var point_1 = __webpack_require__(5327);
var ImageCache_1 = __webpack_require__(4062);
var color_1 = __webpack_require__(9553);
var Enums_1 = __webpack_require__(9254);
var ModelUtils_1 = __webpack_require__(1922);
var DiagramModel = (function () {
    function DiagramModel(pageSize) {
        if (pageSize === void 0) { pageSize = new size_1.Size(8400, 11910); }
        this.items = [];
        this.itemIndexByKey = {};
        this.keyCounter = 0;
        this.pageSize = new size_1.Size(8400, 11910);
        this.pageLandscape = false;
        this.pageColor = DiagramModel.defaultPageColor;
        this.units = Enums_1.DiagramUnit.In;
        this.snapStartPoint = new point_1.Point(0, 0);
        this.pageSize = pageSize;
        this.size = this.pageSize.clone();
        this.rectangle = rectangle_1.Rectangle.fromGeometry(new point_1.Point(0, 0), new size_1.Size(0, 0));
        this.initializeKeyCounter();
    }
    Object.defineProperty(DiagramModel.prototype, "pageWidth", {
        get: function () {
            return this.pageLandscape ? this.pageSize.height : this.pageSize.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DiagramModel.prototype, "pageHeight", {
        get: function () {
            return this.pageLandscape ? this.pageSize.width : this.pageSize.height;
        },
        enumerable: false,
        configurable: true
    });
    DiagramModel.prototype.getRectangle = function (forceUpdate) {
        if (forceUpdate)
            this.rectangle = ModelUtils_1.ModelUtils.createRectangle(this.items);
        return this.rectangle;
    };
    DiagramModel.prototype.pushItem = function (item) {
        var index = this.items.push(item);
        this.itemIndexByKey[item.key] = index - 1;
        if (item instanceof Shape_1.Shape && !item.image.isEmpty)
            this.cacheShapeImage(item);
    };
    DiagramModel.prototype.removeItem = function (item) {
        var index = this.getItemIndex(item);
        delete this.itemIndexByKey[item.key];
        this.items.splice(index, 1);
        this.updateIndicesHash(index);
    };
    DiagramModel.prototype.updateIndicesHash = function (startIndex) {
        for (var i = startIndex; i < this.items.length; i++)
            this.itemIndexByKey[this.items[i].key] = i;
    };
    DiagramModel.prototype.getItemIndex = function (item) {
        return this.itemIndexByKey[item.key];
    };
    DiagramModel.prototype.findShape = function (key) {
        var shape = this.findItem(key);
        return shape instanceof Shape_1.Shape ? shape : undefined;
    };
    DiagramModel.prototype.findShapesCore = function (callback) {
        var shapes = [];
        this.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                if (callback(item)) {
                    shapes.push(item);
                    return;
                }
        });
        return shapes;
    };
    DiagramModel.prototype.findShapeCore = function (callback) {
        for (var i = 0; i < this.items.length; i++) {
            var item = this.items[i];
            if (item instanceof Shape_1.Shape)
                if (callback(item))
                    return item;
        }
    };
    DiagramModel.prototype.findShapeAtPosition = function (position) {
        return this.findShapeCore(function (shape) { return shape.position.equals(position); });
    };
    DiagramModel.prototype.findShapeByDataKey = function (key) {
        return this.findShapeCore(function (shape) { return shape.dataKey === key; });
    };
    DiagramModel.prototype.findShapesByImageUrl = function (imageUrl) {
        return this.findShapesCore(function (shape) { return shape.image.url === imageUrl; });
    };
    DiagramModel.prototype.findShapesByDescription = function (description) {
        return this.findShapesCore(function (shape) { return shape.description.key === description.key; });
    };
    DiagramModel.prototype.cacheShapeImage = function (shape) {
        var cacheImageInfo = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(shape.image);
        if (cacheImageInfo.isLoaded)
            shape.image.loadBase64Content(cacheImageInfo.base64);
    };
    DiagramModel.prototype.loadAllImages = function (imageLoader) {
        ImageCache_1.ImageCache.instance.loadAllImages(imageLoader);
    };
    DiagramModel.prototype.findContainer = function (key) {
        var shape = this.findShape(key);
        return shape && shape.enableChildren ? shape : undefined;
    };
    DiagramModel.prototype.findNearestContainer = function (key) {
        var shape = this.findShape(key);
        if (shape)
            return shape.enableChildren ? shape : shape.container;
        else
            return undefined;
    };
    DiagramModel.prototype.getChildren = function (container) {
        var _this = this;
        return container.children.map(function (child) { return _this.findItem(child.key); }).filter(function (item) { return item; });
    };
    DiagramModel.prototype.findChild = function (container, key, recursive) {
        var _this = this;
        if (recursive === void 0) { recursive = true; }
        var result;
        container.children.forEach(function (child) {
            if (result)
                return;
            if (child.key === key) {
                result = child;
                return;
            }
            if (recursive && child instanceof Shape_1.Shape) {
                result = _this.findChild(child, key, recursive);
                if (result)
                    return;
            }
        });
        return result;
    };
    DiagramModel.prototype.findItemContainerCore = function (item, callback) {
        var container = item.container;
        while (container) {
            if (!callback || callback(container))
                break;
            container = container.container;
        }
        return container;
    };
    DiagramModel.prototype.findItemContainer = function (item) {
        return this.findItemContainerCore(item);
    };
    DiagramModel.prototype.findItemCollapsedContainer = function (item) {
        return this.findItemContainerCore(item, function (c) { return !c.expanded; });
    };
    DiagramModel.prototype.findItemTopCollapsedContainer = function (item) {
        var container = item.container;
        var collapsedContainer;
        while (container) {
            if (!container.expanded)
                collapsedContainer = container;
            container = container.container;
        }
        return collapsedContainer;
    };
    DiagramModel.prototype.isContainerItem = function (container, item) {
        return this.findItemContainerCore(item, function (c) { return c.key === container.key; }) !== undefined;
    };
    DiagramModel.prototype.findConnector = function (key) {
        var connector = this.findItem(key);
        return connector instanceof Connector_1.Connector ? connector : undefined;
    };
    DiagramModel.prototype.findConnectorCore = function (callback) {
        for (var i = 0; i < this.items.length; i++) {
            var item = this.items[i];
            if (item instanceof Connector_1.Connector)
                if (callback(item))
                    return item;
        }
    };
    DiagramModel.prototype.findConnectorAtPoints = function (points) {
        return this.findConnectorCore(function (connector) { return Utils_1.GeometryUtils.arePointsEqual(connector.points, points); });
    };
    DiagramModel.prototype.findConnectorByDataKey = function (key) {
        return this.findConnectorCore(function (connector) { return connector.dataKey === key; });
    };
    DiagramModel.prototype.findConnectorByBeginEndDataKeys = function (beginDataKey, endDataKey) {
        return this.findConnectorCore(function (connector) { return (connector.beginItem && connector.beginItem.dataKey === beginDataKey) &&
            (connector.endItem && connector.endItem.dataKey === endDataKey); });
    };
    DiagramModel.prototype.findConnectorsCore = function (callback) {
        var result = [];
        this.items.forEach(function (item) {
            if (item instanceof Connector_1.Connector)
                if (callback(item)) {
                    result.push(item);
                    return;
                }
        });
        return result;
    };
    DiagramModel.prototype.findConnectorsWithoutBeginItem = function () {
        return this.findConnectorsCore(function (connector) { return !connector.beginItem; });
    };
    DiagramModel.prototype.findConnectorsWithoutEndItem = function () {
        return this.findConnectorsCore(function (connector) { return !connector.endItem; });
    };
    DiagramModel.prototype.findItem = function (key) {
        return this.items[this.itemIndexByKey[key]];
    };
    DiagramModel.prototype.findItemByDataKey = function (key) {
        return this.findItemCore(function (item) { return item.dataKey === key; });
    };
    DiagramModel.prototype.findItemCore = function (callback) {
        for (var i = 0; i < this.items.length; i++)
            if (callback(this.items[i]))
                return this.items[i];
    };
    DiagramModel.isIntersectedItems = function (item1, item2) {
        var result = false;
        if (item1 instanceof Shape_1.Shape)
            result = item2.intersectedByRect(item1.rectangle);
        else if (item1 instanceof Connector_1.Connector)
            item1.getSegments().forEach(function (s1) {
                if (item2 instanceof Shape_1.Shape)
                    result = result || s1.isIntersectedByRect(item2.rectangle);
                else if (item2 instanceof Connector_1.Connector)
                    item2.getSegments().forEach(function (s2) {
                        result = result || s1.isIntersected(s2);
                    });
            });
        return result;
    };
    DiagramModel.prototype.getIntersectItems = function (item) {
        var result = [];
        this.items.forEach(function (i) {
            if (i.container !== item.container)
                return;
            if (item !== i && (!(i instanceof Connector_1.Connector) || item.attachedConnectors.indexOf(i) === -1) &&
                DiagramModel.isIntersectedItems(i, item))
                result.push(i);
        });
        return result;
    };
    DiagramModel.prototype.getIntersectItemsMinZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.min(prev, cur); }, Number.MAX_VALUE);
    };
    DiagramModel.prototype.getIntersectItemsMaxZIndex = function (item) {
        var items = this.getIntersectItems(item);
        return items.map(function (i) { return i.zIndex; }).reduce(function (prev, cur) { return Math.max(prev, cur); }, -Number.MAX_VALUE);
    };
    DiagramModel.prototype.iterateItems = function (callback) {
        this.items.forEach(callback);
    };
    DiagramModel.prototype.getNextKey = function () {
        return (this.keyCounter++).toString();
    };
    DiagramModel.prototype.initializeKeyCounter = function () {
        this.keyCounter = this.items.reduce(function (prev, cur) {
            var num = parseInt(cur.key);
            return Math.max(prev, isNaN(num) ? 0 : num + 1);
        }, this.items.length);
    };
    DiagramModel.defaultPageColor = color_1.ColorUtils.LIGHT_COLOR;
    return DiagramModel;
}());
exports.DiagramModel = DiagramModel;


/***/ }),

/***/ 459:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeViewUnitsCommand = exports.ChangeUnitsCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(1540);
var ChangeUnitsHistoryItem_1 = __webpack_require__(8437);
var SimpleCommandBase_1 = __webpack_require__(3913);
var LocalizationService_1 = __webpack_require__(820);
var ChangeUnitsCommand = (function (_super) {
    __extends(ChangeUnitsCommand, _super);
    function ChangeUnitsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeUnitsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeUnitsCommand.prototype.getValue = function () {
        return this.control.model.units;
    };
    ChangeUnitsCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangeUnitsHistoryItem_1.ChangeUnitsHistoryItem(parameter)];
    };
    ChangeUnitsCommand.prototype.getItems = function () {
        return Object.keys(LocalizationService_1.DiagramLocalizationService.unitItems).map(function (key) {
            return { value: parseInt(key), text: LocalizationService_1.DiagramLocalizationService.unitItems[key] };
        });
    };
    return ChangeUnitsCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangeUnitsCommand = ChangeUnitsCommand;
var ChangeViewUnitsCommand = (function (_super) {
    __extends(ChangeViewUnitsCommand, _super);
    function ChangeViewUnitsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeViewUnitsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeViewUnitsCommand.prototype.getValue = function () {
        return this.control.settings.viewUnits;
    };
    ChangeViewUnitsCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.viewUnits = parameter;
        return true;
    };
    ChangeViewUnitsCommand.prototype.getItems = function () {
        return Object.keys(LocalizationService_1.DiagramLocalizationService.unitItems).map(function (key) {
            return { value: parseInt(key), text: LocalizationService_1.DiagramLocalizationService.unitItems[key] };
        });
    };
    return ChangeViewUnitsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeViewUnitsCommand = ChangeViewUnitsCommand;


/***/ }),

/***/ 472:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeImageHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ImageInfo_1 = __webpack_require__(9406);
var ChangeShapeImageHistoryItem = (function (_super) {
    __extends(ChangeShapeImageHistoryItem, _super);
    function ChangeShapeImageHistoryItem(item, imageUrl) {
        var _this = _super.call(this) || this;
        _this.shapeKey = item.key;
        _this.imageUrl = imageUrl;
        return _this;
    }
    ChangeShapeImageHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        this.oldImage = item.image;
        manipulator.changeShapeImage(item, new ImageInfo_1.ImageInfo(this.imageUrl));
    };
    ChangeShapeImageHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeImage(item, this.oldImage);
    };
    return ChangeShapeImageHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeImageHistoryItem = ChangeShapeImageHistoryItem;


/***/ }),

/***/ 476:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Segment = void 0;
var math_1 = __webpack_require__(594);
var metrics_1 = __webpack_require__(4496);
var point_1 = __webpack_require__(5327);
var rectangle_1 = __webpack_require__(4412);
var Segment = (function () {
    function Segment(startPoint, endPoint) {
        this.startPoint = startPoint;
        this.endPoint = endPoint;
    }
    Object.defineProperty(Segment.prototype, "length", {
        get: function () {
            return metrics_1.Metrics.euclideanDistance(this.startPoint, this.endPoint);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "xLength", {
        get: function () {
            return Math.abs(this.endPoint.x - this.startPoint.x);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "yLength", {
        get: function () {
            return Math.abs(this.endPoint.y - this.startPoint.y);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Segment.prototype, "center", {
        get: function () {
            return new point_1.Point(this.startPoint.x + (this.endPoint.x - this.startPoint.x) / 2, this.startPoint.y + (this.endPoint.y - this.startPoint.y) / 2);
        },
        enumerable: false,
        configurable: true
    });
    Segment.prototype.isIntersected = function (segment) {
        return this.startPoint.equals(segment.startPoint) || this.endPoint.equals(segment.startPoint) ||
            this.startPoint.equals(segment.endPoint) || this.endPoint.equals(segment.endPoint) ||
            (this.intersectCore(segment) && segment.intersectCore(this));
    };
    Segment.prototype.containsPoint = function (point, accuracy) {
        if (accuracy === void 0) { accuracy = 0.0000001; }
        return this.startPoint.equals(point) || this.endPoint.equals(point) ||
            math_1.MathUtils.numberCloseTo(this.length, metrics_1.Metrics.euclideanDistance(this.startPoint, point) + metrics_1.Metrics.euclideanDistance(this.endPoint, point), accuracy);
    };
    Segment.prototype.isIntersectedByRect = function (rect) {
        if (rectangle_1.Rectangle.containsPoint(rect, this.startPoint) || rectangle_1.Rectangle.containsPoint(rect, this.endPoint))
            return true;
        var left = rect.x;
        var right = rect.x + rect.width;
        var top = rect.y;
        var bottom = rect.y + rect.height;
        return this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(left, bottom))) ||
            this.isIntersected(new Segment(new point_1.Point(right, top), new point_1.Point(right, bottom))) ||
            this.isIntersected(new Segment(new point_1.Point(left, top), new point_1.Point(right, top))) ||
            this.isIntersected(new Segment(new point_1.Point(left, bottom), new point_1.Point(right, bottom)));
    };
    Segment.prototype.intersectCore = function (segment) {
        if (this.startPoint.x === this.endPoint.x) {
            if (this.startPoint.x - segment.endPoint.x !== 0)
                return (this.startPoint.x - segment.startPoint.x) / (this.startPoint.x - segment.endPoint.x) <= 0;
            if (segment.endPoint.y - this.endPoint.y !== 0)
                return (segment.endPoint.y - this.startPoint.y) / (segment.endPoint.y - this.endPoint.y) <= 0;
        }
        if (this.startPoint.y === this.endPoint.y) {
            if (this.startPoint.y - segment.endPoint.y !== 0)
                return (this.startPoint.y - segment.startPoint.y) / (this.startPoint.y - segment.endPoint.y) <= 0;
            if (segment.endPoint.x - this.endPoint.x !== 0)
                return (segment.endPoint.x - this.startPoint.x) / (segment.endPoint.x - this.endPoint.x) <= 0;
        }
        var tg = (this.endPoint.y - this.startPoint.y) / (this.endPoint.x - this.startPoint.x);
        var y1 = this.startPoint.y + (segment.startPoint.x - this.startPoint.x) * tg;
        var y2 = this.startPoint.y + (segment.endPoint.x - this.startPoint.x) * tg;
        var dy1 = segment.startPoint.y - y1;
        var dy2 = segment.endPoint.y - y2;
        if (dy1 === 0 && dy2 === 0) {
            return (this.startPoint.y - y1) / (this.endPoint.y - y1) <= 0 ||
                (this.startPoint.y - y2) / (this.endPoint.y - y2) <= 0;
        }
        return dy1 === 0 || dy2 === 0 || dy1 / dy2 < 0;
    };
    return Segment;
}());
exports.Segment = Segment;


/***/ }),

/***/ 481:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IconToolbox = void 0;
var Toolbox_1 = __webpack_require__(5037);
var RenderHelper_1 = __webpack_require__(8509);
var Shape_1 = __webpack_require__(8408);
var unit_converter_1 = __webpack_require__(9500);
var point_1 = __webpack_require__(5327);
var TextShapeDescription_1 = __webpack_require__(8278);
var Style_1 = __webpack_require__(5059);
var CustomShapeDescription_1 = __webpack_require__(2567);
var RectaglePrimitive_1 = __webpack_require__(94);
var DEFAULT_SHAPE_ICON_SIZE = 32;
var SHRINK_TEXT_SHAPE_ICON_SIZE = 26;
var SHRINKED_TEXT = "T";
var IconToolbox = (function (_super) {
    __extends(IconToolbox, _super);
    function IconToolbox(parent, readonly, allowDragging, shapeDescriptionManager, shapeTypes, getAllowedShapeTypes, options, measurer, instanceId) {
        var _this = _super.call(this, parent, readonly, allowDragging, shapeDescriptionManager, shapeTypes, getAllowedShapeTypes) || this;
        _this.options = options;
        _this.measurer = measurer;
        _this.instanceId = instanceId;
        return _this;
    }
    IconToolbox.prototype.createElements = function (element, shapeTypes) {
        var svgElement = document.createElementNS(RenderHelper_1.svgNS, "svg");
        svgElement.className.baseVal = "dxdi-canvas";
        element.appendChild(svgElement);
        this.drawShapeIcons(svgElement, shapeTypes, this.options.toolboxWidth || svgElement.getBoundingClientRect().width);
    };
    IconToolbox.prototype.drawShapeIcons = function (parent, shapeTypes, svgWidth) {
        var _this = this;
        var lineWidth = Style_1.DEFAULT_STROKE_WIDTH;
        var targetWidth = svgWidth - 2 * lineWidth;
        var shapeIconSize = this.options.shapeIconSize;
        if (!shapeIconSize && this.options.shapeIconSpacing && this.options.shapeIconCountInRow)
            shapeIconSize = Math.floor((targetWidth - (this.options.shapeIconCountInRow - 1) * this.options.shapeIconSpacing) / this.options.shapeIconCountInRow);
        if (!shapeIconSize)
            shapeIconSize = DEFAULT_SHAPE_ICON_SIZE;
        shapeIconSize = Math.max(shapeIconSize, this.options.shapeIconSpacing / 2);
        var width = shapeIconSize;
        var iconCountInRow = this.options.shapeIconCountInRow;
        if (!iconCountInRow) {
            iconCountInRow = 1;
            while (width < targetWidth) {
                width += this.options.shapeIconSpacing + shapeIconSize;
                if (width < targetWidth)
                    iconCountInRow++;
            }
        }
        var shapeIconSpacing = (iconCountInRow > 1) ? (targetWidth - shapeIconSize * iconCountInRow) / (iconCountInRow - 1) : 0;
        var xPos = lineWidth;
        var yPos = lineWidth;
        var size = unit_converter_1.UnitConverter.pixelsToTwips(shapeIconSize);
        shapeTypes.forEach(function (shapeType, index) {
            if (index > 0 && index % iconCountInRow === 0) {
                xPos = lineWidth;
                yPos += shapeIconSize + shapeIconSpacing;
            }
            var shapeDescription = _this.shapeDescriptionManager.get(shapeType);
            var shape = _this.createShape(shapeDescription, xPos, yPos, shapeIconSize < SHRINK_TEXT_SHAPE_ICON_SIZE);
            _this.updateShapeIconBounds(shape, shapeIconSize);
            var shapeEl = _this.drawShape(parent, shape);
            _this.drawSelector(shapeEl, unit_converter_1.UnitConverter.pixelsToTwips(xPos), unit_converter_1.UnitConverter.pixelsToTwips(yPos), size);
            xPos += shapeIconSize + shapeIconSpacing;
        });
        parent.style.height = yPos + shapeIconSize + lineWidth + "px";
        parent.style.width = svgWidth + "px";
    };
    IconToolbox.prototype.drawShape = function (parent, shape) {
        var _this = this;
        var primitives = shape.description.createPrimitives(shape, this.instanceId, true);
        var gEl = document.createElementNS(RenderHelper_1.svgNS, "g");
        gEl.setAttribute("data-tb-type", shape.description.key.toString());
        gEl.setAttribute("class", "toolbox-item");
        gEl.setAttribute("title", shape.description.getTitle());
        if (this.options.shapeIconAttributes)
            for (var key in this.options.shapeIconAttributes)
                if (Object.prototype.hasOwnProperty.call(this.options.shapeIconAttributes, key))
                    gEl.setAttribute(key, this.options.shapeIconAttributes[key]);
        parent.appendChild(gEl);
        primitives.forEach(function (pr) {
            var el = pr.createElement(function (e) { return gEl.appendChild(e); });
            pr.applyElementProperties(el, _this.measurer);
        });
        return gEl;
    };
    IconToolbox.prototype.drawSelector = function (parent, x, y, size) {
        var _this = this;
        var selectorRect = new RectaglePrimitive_1.RectanglePrimitive(x, y, size, size, undefined, "selector");
        selectorRect.createElement(function (el) {
            selectorRect.applyElementProperties(el, _this.measurer);
            parent.appendChild(el);
        });
    };
    IconToolbox.prototype.createShape = function (shapeDescription, xPos, yPos, shrinkText) {
        var xPosT = unit_converter_1.UnitConverter.pixelsToTwips(xPos);
        var yPosT = unit_converter_1.UnitConverter.pixelsToTwips(yPos);
        var shape = new Shape_1.Shape(shapeDescription, new point_1.Point(xPosT, yPosT), true);
        if (this.needResetShapeText(shapeDescription))
            shape.text = "";
        else if (shrinkText)
            shape.text = SHRINKED_TEXT;
        return shape;
    };
    IconToolbox.prototype.needResetShapeText = function (shapeDescription) {
        if (shapeDescription instanceof TextShapeDescription_1.TextShapeDescription)
            return false;
        if (shapeDescription instanceof CustomShapeDescription_1.CustomShapeDescription && shapeDescription.baseDescription instanceof TextShapeDescription_1.TextShapeDescription)
            return false;
        return true;
    };
    IconToolbox.prototype.updateShapeIconBounds = function (shape, shapeIconSize) {
        var shapeSizeT = unit_converter_1.UnitConverter.pixelsToTwips(shapeIconSize);
        shape.size.height = shape.size.width * shape.getToolboxHeightToWidthRatio();
        if (shape.size.width > shape.size.height) {
            var ratio = shape.size.height / shape.size.width;
            shape.size.width = shapeSizeT;
            shape.size.height = shapeSizeT * ratio;
            shape.position.y = shape.position.y + (shapeSizeT - shape.size.height) / 2;
            shape.parameters.forEach(function (p) { p.value = p.value * shapeSizeT / shape.description.defaultSize.width; });
        }
        else if (shape.size.width < shape.size.height) {
            var ratio = shape.size.width / shape.size.height;
            shape.size.height = shapeSizeT;
            shape.size.width = shapeSizeT * ratio;
            shape.position.x = shape.position.x + (shapeSizeT - shape.size.width) / 2;
            shape.parameters.forEach(function (p) { p.value = p.value * shapeSizeT / shape.description.defaultSize.height; });
        }
        else {
            shape.size.width = shapeSizeT;
            shape.size.height = shapeSizeT;
            shape.parameters.forEach(function (p) { p.value = p.value * shapeSizeT / shape.description.defaultSize.width; });
        }
    };
    IconToolbox.prototype.createDraggingElement = function (draggingObject) {
        var element = document.createElement("DIV");
        element.setAttribute("class", "dxdi-toolbox-drag-item");
        document.body.appendChild(element);
        var svgElement = document.createElementNS(RenderHelper_1.svgNS, "svg");
        svgElement.className.baseVal = "dxdi-canvas";
        element.appendChild(svgElement);
        var shapeDescription = this.shapeDescriptionManager.get(draggingObject.evt.data);
        var shape = this.createShape(shapeDescription, Style_1.DEFAULT_STROKE_WIDTH, Style_1.DEFAULT_STROKE_WIDTH);
        this.drawShape(svgElement, shape);
        element.style.width = unit_converter_1.UnitConverter.twipsToPixels(shape.size.width) + 2 * Style_1.DEFAULT_STROKE_WIDTH + "px";
        element.style.height = unit_converter_1.UnitConverter.twipsToPixels(shape.size.height) + 2 * Style_1.DEFAULT_STROKE_WIDTH + "px";
        return element;
    };
    return IconToolbox;
}(Toolbox_1.Toolbox));
exports.IconToolbox = IconToolbox;


/***/ }),

/***/ 506:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImportConnectorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ImportConnectorHistoryItem = (function (_super) {
    __extends(ImportConnectorHistoryItem, _super);
    function ImportConnectorHistoryItem(connector) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        return _this;
    }
    ImportConnectorHistoryItem.prototype.redo = function (manipulator) {
        this.connectorKey = this.connector.key;
        manipulator.insertConnector(this.connector);
    };
    ImportConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.removeConnector(connector);
    };
    return ImportConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ImportConnectorHistoryItem = ImportConnectorHistoryItem;


/***/ }),

/***/ 522:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalWestSideCalculator = void 0;
var DiagramItem_1 = __webpack_require__(4824);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(3976);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ConnectorPointsOrthogonalWestSideCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalWestSideCalculator, _super);
    function ConnectorPointsOrthogonalWestSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.x > originRect.x)
            originPoint = originPoint.clone().offset(originRect.x - originPoint.x, 0);
        return originPoint;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
            case DiagramItem_1.ConnectionPointSide.South:
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                return [originPoint.clone().offset(this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
        }
        return [];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                if (originPoint.x > targetPoint.x)
                    if (originPoint.y < targetPoint.y)
                        return [];
                    else
                        return [originPoint.clone().offset(-this.getMinOffset(), 0)];
                if (originPoint.x < this.endRect.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.South:
                if (originPoint.x > targetPoint.x)
                    if (originPoint.y > targetPoint.y)
                        return [];
                    else
                        return [originPoint.clone().offset(-this.getMinOffset(), 0)];
                if (originPoint.x < this.endRect.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.y < targetPoint.y);
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East: {
                var offset = -this.getMinOffset();
                if (this.beginRect.x < originPoint.x)
                    offset -= originPoint.x - this.beginRect.x;
                return [originPoint.clone().offset(offset, 0)];
            }
            case DiagramItem_1.ConnectionPointSide.West:
                return [originPoint.clone().offset(-this.getMinOffset(), 0)];
            case DiagramItem_1.ConnectionPointSide.North:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.y > targetPoint.y)
                    return [originPoint.clone().offset(-this.getMinOffset(), 0)];
                return [];
            case DiagramItem_1.ConnectionPointSide.South:
                if (targetPoint.x > originPoint.x)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.y < targetPoint.y)
                    return [originPoint.clone().offset(-this.getMinOffset(), 0)];
                return [];
        }
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(-this.getScaleableOffsetX(originPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(-this.getScaleableOffsetX(originPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedY())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.East:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.clone().offset(-this.getScaleableOffsetX(originPoint, false), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedY()) {
            var direction = this.beginRect.center.y > this.endRect.center.y;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.clone().offset(-this.getScaleableOffsetX(originPoint, true), 0)];
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.y < originPoint.y;
            if (direction)
                points.push(originPoint.clone().offset(-offset, -(originPoint.y - originRect.y + asideOffset)));
            else
                points.push(originPoint.clone().offset(-offset, (originRect.bottom - originPoint.y + asideOffset)));
        }
        points.push(originPoint.clone().offset(-offset, 0));
        return points;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetX(originPoint, isEnd);
        var asideOffset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetX = function (originPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.x - this.beginRect.right : originPoint.x - this.endRect.right;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect)
            if (!isEnd && !this.isBeginEndOverlappedY()) {
                var distance = void 0;
                if (targetPoint.y < originPoint.y)
                    distance = this.beginRect.y - this.endRect.bottom;
                else
                    distance = this.endRect.y - this.beginRect.bottom;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.x < originPoint.x;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.East || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalWestSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cx = targetPoint.x + (originPoint.x - targetPoint.x) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, originPoint.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(cx, targetPoint.y)
        ];
    };
    return ConnectorPointsOrthogonalWestSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalWestSideCalculator = ConnectorPointsOrthogonalWestSideCalculator;


/***/ }),

/***/ 531:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeFontColorCommand = void 0;
var ChangeStyleTextPropertyCommand_1 = __webpack_require__(6994);
var color_1 = __webpack_require__(9553);
var ChangeFontColorCommand = (function (_super) {
    __extends(ChangeFontColorCommand, _super);
    function ChangeFontColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeFontColorCommand.prototype.processParameter = function (parameter) {
        return color_1.ColorUtils.stringToHash(parameter);
    };
    ChangeFontColorCommand.prototype.getStyleProperty = function () {
        return "fill";
    };
    return ChangeFontColorCommand;
}(ChangeStyleTextPropertyCommand_1.ChangeStyleTextPropertyCommand));
exports.ChangeFontColorCommand = ChangeFontColorCommand;


/***/ }),

/***/ 540:
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
// extracted by mini-css-extract-plugin


/***/ }),

/***/ 564:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BeforeChangeConnectorTextEventArgs = exports.BeforeChangeConnectorTextRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var BeforeChangeConnectorTextRequestedEntity = (function (_super) {
    __extends(BeforeChangeConnectorTextRequestedEntity, _super);
    function BeforeChangeConnectorTextRequestedEntity(apiController, connector, position) {
        var _this = _super.call(this, apiController) || this;
        _this.connector = connector;
        _this.position = position;
        return _this;
    }
    Object.defineProperty(BeforeChangeConnectorTextRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.BeforeChangeConnectorText;
        },
        enumerable: false,
        configurable: true
    });
    BeforeChangeConnectorTextRequestedEntity.prototype.createEventArgs = function () {
        return new BeforeChangeConnectorTextEventArgs(this.apiController.createNativeConnector(this.connector), this.position, this.connector.texts.map(function (t) { return t; }).sort(function (a, b) { return a.position - b.position; }).indexOf(this.connector.texts.get(this.position)));
    };
    Object.defineProperty(BeforeChangeConnectorTextRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "changeConnectorText";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BeforeChangeConnectorTextRequestedEntity.prototype, "storageKey", {
        get: function () {
            return "before" + this.settingsKey + "_" + (this.connector && this.connector.key);
        },
        enumerable: false,
        configurable: true
    });
    BeforeChangeConnectorTextRequestedEntity.prototype.equals = function (other) {
        if (other instanceof BeforeChangeConnectorTextRequestedEntity)
            return this.connector === other.connector && this.position === other.position && this.connector.texts.get(this.position) === other.connector.texts.get(other.position);
        return false;
    };
    return BeforeChangeConnectorTextRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.BeforeChangeConnectorTextRequestedEntity = BeforeChangeConnectorTextRequestedEntity;
var BeforeChangeConnectorTextEventArgs = (function (_super) {
    __extends(BeforeChangeConnectorTextEventArgs, _super);
    function BeforeChangeConnectorTextEventArgs(connector, position, index) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        _this.position = position;
        _this.index = index;
        return _this;
    }
    return BeforeChangeConnectorTextEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.BeforeChangeConnectorTextEventArgs = BeforeChangeConnectorTextEventArgs;


/***/ }),

/***/ 594:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MathUtils = void 0;
var list_1 = __webpack_require__(2892);
var MathUtils = (function () {
    function MathUtils() {
    }
    MathUtils.round = function (value, digits) {
        if (digits === void 0) { digits = 0; }
        var factor = MathUtils.powFactor[digits];
        return Math.round(value * factor) / factor;
    };
    MathUtils.numberCloseTo = function (num, to, accuracy) {
        if (accuracy === void 0) { accuracy = 0.00001; }
        return Math.abs(num - to) < accuracy;
    };
    MathUtils.restrictValue = function (val, minVal, maxVal) {
        if (maxVal < minVal)
            maxVal = minVal;
        if (val > maxVal)
            return maxVal;
        else if (val < minVal)
            return minVal;
        return val;
    };
    MathUtils.getRandomInt = function (min, max) {
        return Math.floor(Math.random() * (max - min + 1)) + min;
    };
    MathUtils.generateGuid = function () {
        return 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function (c) {
            var r = Math.random() * 16 | 0;
            var v = c === 'x' ? r : (r & 0x3 | 0x8);
            return v.toString(16);
        });
    };
    MathUtils.powFactor = list_1.ListUtils.initByCallback(20, function (ind) { return Math.pow(10, ind); });
    MathUtils.somePrimes = [1009, 1013,
        1019, 1021, 1031, 1033, 1039, 1049, 1051, 1061, 1063, 1069,
        1087, 1091, 1093, 1097, 1103, 1109, 1117, 1123, 1129, 1151,
        1153, 1163, 1171, 1181, 1187, 1193, 1201, 1213, 1217, 1223,
        1229, 1231, 1237, 1249, 1259, 1277, 1279, 1283, 1289, 1291,
        1297, 1301, 1303, 1307, 1319, 1321, 1327, 1361, 1367, 1373,
        1381, 1399, 1409, 1423, 1427, 1429, 1433, 1439, 1447, 1451,
        1453, 1459, 1471, 1481, 1483, 1487, 1489, 1493, 1499, 1511,
        1523, 1531, 1543, 1549, 1553, 1559, 1567, 1571, 1579, 1583,
        1597, 1601, 1607, 1609, 1613, 1619, 1621, 1627, 1637, 1657,
        1663, 1667, 1669, 1693, 1697, 1699, 1709, 1721, 1723, 1733,
        1741, 1747, 1753, 1759, 1777, 1783, 1787, 1789, 1801, 1811,
        1823, 1831, 1847, 1861, 1867, 1871, 1873, 1877, 1879, 1889,
        1901, 1907, 1913, 1931, 1933, 1949, 1951, 1973, 1979, 1987,
        1993, 1997, 1999, 2003];
    return MathUtils;
}());
exports.MathUtils = MathUtils;


/***/ }),

/***/ 618:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RightAngleConnectorRoutingMathOperations = void 0;
var segment_1 = __webpack_require__(476);
var math_1 = __webpack_require__(594);
var AStarMetrics_1 = __webpack_require__(8671);
var Utils_1 = __webpack_require__(41);
var DiagramItem_1 = __webpack_require__(4824);
var RightAngleConnectorRoutingMathOperations = (function () {
    function RightAngleConnectorRoutingMathOperations() {
    }
    RightAngleConnectorRoutingMathOperations.createUnionSegments = function (segments, shouldCreateSegment) {
        var result = [];
        var startRenderPoint = segments[0].startPoint;
        var endRenderPoint = segments[0].endPoint;
        for (var i = 1; i < segments.length; i++) {
            var currentSegment = segments[i];
            if (shouldCreateSegment(endRenderPoint, currentSegment.startPoint)) {
                result.push(new segment_1.Segment(startRenderPoint.clone(), endRenderPoint.clone()));
                startRenderPoint = currentSegment.startPoint;
            }
            endRenderPoint = currentSegment.endPoint;
        }
        result.push(new segment_1.Segment(startRenderPoint, endRenderPoint));
        return result;
    };
    RightAngleConnectorRoutingMathOperations.unionPoints = function (points) {
        var index = 0;
        while (index < points.length - 2)
            if (Utils_1.GeometryUtils.isCorner(points[index], points[index + 1], points[index + 2]))
                index++;
            else {
                points.splice(index + 1, 1);
                index = Math.max(0, index - 1);
            }
    };
    RightAngleConnectorRoutingMathOperations.getTurnDirection = function (angle) {
        if (math_1.MathUtils.numberCloseTo(angle, 0))
            return AStarMetrics_1.RightAngleTurnDirection.Straight;
        if (math_1.MathUtils.numberCloseTo(angle, Math.PI))
            return AStarMetrics_1.RightAngleTurnDirection.Backwards;
        return angle < Math.PI ? AStarMetrics_1.RightAngleTurnDirection.Left : AStarMetrics_1.RightAngleTurnDirection.Right;
    };
    RightAngleConnectorRoutingMathOperations.isSegmentNormal = function (segment, isHorizontal) {
        return isHorizontal ? math_1.MathUtils.numberCloseTo(segment.startPoint.y, segment.endPoint.y) : math_1.MathUtils.numberCloseTo(segment.startPoint.x, segment.endPoint.x);
    };
    RightAngleConnectorRoutingMathOperations.isConnectionRectanleLineIntersected = function (rect, segment, side, excludeBeginPoint, excludeEndPoint, createPoint) {
        switch (side) {
            case DiagramItem_1.ConnectionPointSide.North:
                return Utils_1.GeometryUtils.isLineIntersected(createPoint(rect.x, rect.y), createPoint(rect.right, rect.y), segment, excludeBeginPoint, excludeEndPoint);
            case DiagramItem_1.ConnectionPointSide.South:
                return Utils_1.GeometryUtils.isLineIntersected(createPoint(rect.right, rect.bottom), createPoint(rect.x, rect.bottom), segment, excludeBeginPoint, excludeEndPoint);
            case DiagramItem_1.ConnectionPointSide.West:
                return Utils_1.GeometryUtils.isLineIntersected(createPoint(rect.x, rect.y), createPoint(rect.x, rect.bottom), segment, excludeBeginPoint, excludeEndPoint);
            case DiagramItem_1.ConnectionPointSide.East:
                return Utils_1.GeometryUtils.isLineIntersected(createPoint(rect.right, rect.y), createPoint(rect.right, rect.bottom), segment, excludeBeginPoint, excludeEndPoint);
            default:
                return false;
        }
    };
    RightAngleConnectorRoutingMathOperations.createBeginConnectionSegment = function (beginConnectionSide, beginPoint, offset, createPoint) {
        switch (beginConnectionSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                return new segment_1.Segment(beginPoint, createPoint(beginPoint.x, beginPoint.y - offset));
            case DiagramItem_1.ConnectionPointSide.South:
                return new segment_1.Segment(beginPoint, createPoint(beginPoint.x, beginPoint.y + offset));
            case DiagramItem_1.ConnectionPointSide.West:
                return new segment_1.Segment(beginPoint, createPoint(beginPoint.x - offset, beginPoint.y));
            case DiagramItem_1.ConnectionPointSide.East:
                return new segment_1.Segment(beginPoint, createPoint(beginPoint.x + offset, beginPoint.y));
            default:
                return beginPoint;
        }
    };
    RightAngleConnectorRoutingMathOperations.createEndConnectionSegment = function (endConnectionSide, endPoint, offset, createPoint) {
        switch (endConnectionSide) {
            case DiagramItem_1.ConnectionPointSide.North:
                return new segment_1.Segment(createPoint(endPoint.x, endPoint.y - offset), endPoint);
            case DiagramItem_1.ConnectionPointSide.South:
                return new segment_1.Segment(createPoint(endPoint.x, endPoint.y + offset), endPoint);
            case DiagramItem_1.ConnectionPointSide.West:
                return new segment_1.Segment(createPoint(endPoint.x - offset, endPoint.y), endPoint);
            case DiagramItem_1.ConnectionPointSide.East:
                return new segment_1.Segment(createPoint(endPoint.x + offset, endPoint.y), endPoint);
            default:
                return endPoint;
        }
    };
    return RightAngleConnectorRoutingMathOperations;
}());
exports.RightAngleConnectorRoutingMathOperations = RightAngleConnectorRoutingMathOperations;


/***/ }),

/***/ 672:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeZindexHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangeZindexHistoryItem = (function (_super) {
    __extends(ChangeZindexHistoryItem, _super);
    function ChangeZindexHistoryItem(item, zIndex) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.zIndex = zIndex;
        return _this;
    }
    ChangeZindexHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldZIndex = item.zIndex;
        manipulator.changeZIndex(item, this.zIndex);
    };
    ChangeZindexHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeZIndex(item, this.oldZIndex);
    };
    return ChangeZindexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeZindexHistoryItem = ChangeZindexHistoryItem;


/***/ }),

/***/ 701:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramControl = void 0;
var point_1 = __webpack_require__(5327);
var ModelManipulator_1 = __webpack_require__(2703);
var CommandManager_1 = __webpack_require__(5031);
var EventManager_1 = __webpack_require__(6309);
var Model_1 = __webpack_require__(455);
var Selection_1 = __webpack_require__(3099);
var History_1 = __webpack_require__(7059);
var BarManager_1 = __webpack_require__(6695);
var RenderManager_1 = __webpack_require__(4306);
var ShapeDescriptionManager_1 = __webpack_require__(281);
var DocumentDataSource_1 = __webpack_require__(1581);
var Settings_1 = __webpack_require__(9307);
var ModelOperationSettings_1 = __webpack_require__(5225);
var ViewController_1 = __webpack_require__(3659);
var ModelUtils_1 = __webpack_require__(1922);
var ToolboxManager_1 = __webpack_require__(1659);
var Utils_1 = __webpack_require__(41);
var ApiController_1 = __webpack_require__(8315);
var ImageCache_1 = __webpack_require__(4062);
var PermissionsProvider_1 = __webpack_require__(1040);
var ConnectorRoutingModel_1 = __webpack_require__(5130);
var TextMeasurer_1 = __webpack_require__(6727);
var Connector_1 = __webpack_require__(6320);
var DataLayoutParameters_1 = __webpack_require__(2175);
var ReloadContentParameters_1 = __webpack_require__(5718);
var Utils_2 = __webpack_require__(2136);
var _1 = __webpack_require__(8156);
var math_1 = __webpack_require__(594);
var DiagramControl = (function () {
    function DiagramControl() {
        this.updateLockCount = 0;
        this.shouldUpdateItemsByModel = false;
        this.reloadContentNeeded = false;
        this.reloadContentParameters = new ReloadContentParameters_1.ReloadContentParameters();
        this.reloadContentByExternalChangesParameters = new ReloadContentParameters_1.ReloadContentParameters();
        this.instanceId = math_1.MathUtils.generateGuid();
        this.settings = new Settings_1.DiagramSettings();
        this.shapeDescriptionManager = new ShapeDescriptionManager_1.ShapeDescriptionManager();
        this.shapeDescriptionManager.onShapeDecriptionChanged.add(this);
        this.model = new Model_1.DiagramModel();
        this.selection = new Selection_1.Selection(this.model);
        this.onNativeAction = new Utils_1.EventDispatcher();
        this.apiController = new ApiController_1.ApiController(this.onNativeAction, this.selection, this.model);
        this.permissionsProvider = new PermissionsProvider_1.PermissionsProvider(this.apiController);
        this.permissionsProvider.onRequestOperation.add(this);
        this.routingModel = new ConnectorRoutingModel_1.ConnectorRoutingModel();
        this.modelManipulator = new ModelManipulator_1.ModelManipulator(this.model, this.routingModel, this.permissionsProvider, this.shapeDescriptionManager);
        this.modelManipulator.onModelChanged.add(this.permissionsProvider);
        this.history = new History_1.History(this.modelManipulator, this);
        this.barManager = new BarManager_1.BarManager(this);
        this.view = new ViewController_1.ViewController(this.settings, this.barManager);
        this.commandManager = new CommandManager_1.CommandManager(this);
        this.eventManager = new EventManager_1.EventManager(this);
        this.settings.onReadOnlyChanged.add(this.eventManager.mouseHandler);
        this.settings.onReadOnlyChanged.add(this.eventManager.visualizersManager);
        this.selection.onChanged.add(this.barManager);
        this.selection.onChanged.add(this.apiController);
        this.selection.onChanged.add(this.permissionsProvider);
        this.modelManipulator.commitItemsCreateChanges();
        this.history.onChanged.add(this);
        this.toolboxManager = new ToolboxManager_1.ToolboxManager(this.shapeDescriptionManager);
        this.settings.onConnectorRoutingModeChanged.add(this.routingModel);
        ImageCache_1.ImageCache.instance.onReadyStateChanged.add(this);
    }
    Object.defineProperty(DiagramControl.prototype, "operationSettings", {
        get: function () {
            return this.permissionsProvider.operationSettings;
        },
        enumerable: false,
        configurable: true
    });
    DiagramControl.prototype.cleanMarkup = function (removeElement) {
        removeElement = removeElement || (function (element) { Utils_2.RenderUtils.removeElement(element); });
        this.toolboxManager.clean(removeElement);
        this.barManager.clean();
        if (this.render) {
            this.settings.onZoomChanged.remove(this.render.view);
            this.settings.onViewChanged.remove(this.render.page);
            this.settings.onViewChanged.remove(this.render.view);
            this.settings.onReadOnlyChanged.remove(this.render);
            this.settings.onReadOnlyChanged.remove(this.render.selection);
            this.eventManager.cleanToolboxes(this.settings.onReadOnlyChanged);
            this.eventManager.onTextInputOperation.remove(this.render.input);
            this.eventManager.onTextInputOperation.remove(this.render.items);
            this.eventManager.onTextInputOperation.remove(this.render.selection);
            this.eventManager.onMouseOperation.remove(this.render.items);
            this.eventManager.onMouseOperation.remove(this.render.selection);
            this.eventManager.onMouseOperation.remove(this.render.view);
            this.eventManager.onMouseOperation.remove(this.render);
            this.eventManager.onVisualizersUpdate.remove(this.render.selection);
            this.modelManipulator.onModelSizeChanged.remove(this.render.view);
            this.modelManipulator.onModelSizeChanged.remove(this.render.page);
            this.modelManipulator.onModelChanged.remove(this.render.items);
            this.modelManipulator.onModelChanged.remove(this.render.page);
            this.modelManipulator.onModelChanged.remove(this.render.selection);
            this.selection.onChanged.remove(this.render.selection);
            this.selection.onChanged.remove(this.render.items);
            this.render.clean(removeElement);
            this.render = undefined;
        }
        if (this.measurer && this.measurer instanceof TextMeasurer_1.TextMeasurer)
            this.measurer.clean();
    };
    DiagramControl.prototype.dispose = function () {
        ImageCache_1.ImageCache.instance.onReadyStateChanged.remove(this);
    };
    DiagramControl.prototype.createDocument = function (parent, scrollView, focusElementsParent) {
        if (!this.measurer)
            this.initMeasurer(parent);
        if (this.render)
            this.render.replaceParent(parent, scrollView);
        else {
            this.render = new RenderManager_1.RenderManager(parent, this.eventManager, this.measurer, {
                pageColor: this.model.pageColor,
                modelSize: this.model.size,
                pageLandscape: this.model.pageLandscape,
                pageSize: this.model.pageSize,
                simpleView: this.settings.simpleView,
                readOnly: this.settings.readOnly,
                contextMenuEnabled: this.settings.contextMenuEnabled,
                gridSize: this.settings.gridSize,
                gridVisible: this.settings.showGrid,
                zoomLevel: this.settings.zoomLevel,
                autoZoom: this.settings.autoZoom,
                rectangle: this.model.getRectangle(true)
            }, this.instanceId, scrollView, focusElementsParent);
            this.settings.onZoomChanged.add(this.render.view);
            this.settings.onViewChanged.add(this.render.page);
            this.settings.onViewChanged.add(this.render.view);
            this.settings.onReadOnlyChanged.add(this.render);
            this.settings.onReadOnlyChanged.add(this.render.selection);
            this.eventManager.onTextInputOperation.add(this.render.input);
            this.eventManager.onTextInputOperation.add(this.render.items);
            this.eventManager.onTextInputOperation.add(this.render.selection);
            this.eventManager.onTextInputOperation.add(this);
            this.eventManager.onMouseOperation.add(this.render.items);
            this.eventManager.onMouseOperation.add(this.render.selection);
            this.eventManager.onMouseOperation.add(this.render.view);
            this.eventManager.onMouseOperation.add(this.render);
            this.eventManager.onVisualizersUpdate.add(this.render.selection);
            this.modelManipulator.onModelSizeChanged.add(this.render.view);
            this.modelManipulator.onModelSizeChanged.add(this.render.page);
            this.modelManipulator.onModelChanged.add(this.render.items);
            this.modelManipulator.onModelChanged.add(this.render.page);
            this.modelManipulator.onModelChanged.add(this.render.selection);
            this.selection.onChanged.add(this.render.selection);
            this.selection.onChanged.add(this.render.items);
            this.render.update(false);
            this.render.onNewModel(this.model.items);
            this.modelManipulator.commitItemsCreateChanges();
            this.view.initialize(this.render.view);
            if (this.settings.zoomLevelWasChanged)
                this.raiseCanvasViewActualZoomChanged();
            this.selection.raiseSelectionChanged();
        }
    };
    DiagramControl.prototype.createToolbox = function (parent, renderAsText, shapes, options) {
        var toolbox = this.toolboxManager.create(parent, this.settings.readOnly, true, renderAsText, shapes, this.getToolboxAllowedShapeTypes.bind(this), this.instanceId, options);
        this.settings.onReadOnlyChanged.add(toolbox);
        toolbox.onDragOperation.add(this);
        toolbox.onDragOperation.add(this.apiController);
        this.eventManager.registerToolbox(toolbox);
    };
    DiagramControl.prototype.createContextToolbox = function (parent, renderAsText, shapes, options, onClick) {
        this.cleanContextToolbox();
        this.contextToolbox = this.toolboxManager.create(parent, this.settings.readOnly, false, renderAsText, shapes, this.getToolboxAllowedShapeTypes.bind(this), this.instanceId, options);
        this.contextToolbox.onClickOperation.add(this);
        this.contextToolboxOnClick = onClick;
    };
    DiagramControl.prototype.getToolboxAllowedShapeTypes = function (shapeTypes) {
        var _this = this;
        var allowedShapeTypes = [];
        this.permissionsProvider.beginUpdateUI();
        shapeTypes.forEach(function (shapeType) {
            if (_this.permissionsProvider.canAddShapeFromToolbox(shapeType))
                allowedShapeTypes.push(shapeType);
        });
        this.permissionsProvider.endUpdateUI();
        return allowedShapeTypes;
    };
    DiagramControl.prototype.cleanContextToolbox = function () {
        if (this.contextToolbox) {
            this.toolboxManager.clean(undefined, this.contextToolbox);
            this.contextToolbox = undefined;
            this.contextToolboxOnClick = undefined;
        }
    };
    DiagramControl.prototype.refreshToolbox = function (toolboxes) {
        this.permissionsProvider.clearCache(ModelOperationSettings_1.DiagramModelOperation.AddShapeFromToolbox);
        this.toolboxManager.refresh(toolboxes);
    };
    DiagramControl.prototype.applyToolboxFilter = function (shapeSubstring, toolboxes) {
        return this.toolboxManager.applyFilter(shapeSubstring, toolboxes);
    };
    DiagramControl.prototype.notifyToolboxClick = function (shapeType) {
        if (this.contextToolboxOnClick)
            this.contextToolboxOnClick(shapeType);
    };
    DiagramControl.prototype.initMeasurer = function (parent) {
        this.measurer = new TextMeasurer_1.TextMeasurer(parent);
    };
    DiagramControl.prototype.onDimensionChanged = function () {
        if (!_1.Browser.TouchUI)
            this.updateLayout(true);
    };
    DiagramControl.prototype.updateLayout = function (resetScroll) {
        if (resetScroll === void 0) { resetScroll = false; }
        this.render && this.render.update(!resetScroll);
    };
    DiagramControl.prototype.captureFocus = function () {
        this.render && this.render.input.captureFocus();
    };
    DiagramControl.prototype.isFocused = function () {
        return !this.render || this.render.input.isFocused();
    };
    DiagramControl.prototype.registerBar = function (bar) {
        this.barManager.registerBar(bar);
    };
    DiagramControl.prototype.updateBarItemsState = function (bar, queryCommands) {
        this.barManager.updateBarItemsState(bar, queryCommands);
    };
    DiagramControl.prototype.getCommand = function (key) {
        return this.commandManager.getCommand(key);
    };
    DiagramControl.prototype.getNativeItemByKey = function (key) {
        var item = this.model.findItem(key);
        return item && this.apiController.createNativeItem(item);
    };
    DiagramControl.prototype.getNativeItemByDataKey = function (dataKey) {
        var item = this.model.findItemByDataKey(dataKey);
        return item && this.apiController.createNativeItem(item);
    };
    DiagramControl.prototype.getNativeItems = function () {
        var _this = this;
        return this.model.items.map(function (item) { return _this.apiController.createNativeItem(item); });
    };
    DiagramControl.prototype.getNativeSelectedItems = function () {
        var _this = this;
        return this.selection.getKeys().map(function (key) { return _this.apiController.createNativeItem(_this.model.findItem(key)); });
    };
    DiagramControl.prototype.setSelectedItems = function (keys) {
        this.selection.set(keys);
    };
    DiagramControl.prototype.scrollToItems = function (keys) {
        var _this = this;
        var rectangle = Utils_1.GeometryUtils.getCommonRectangle(keys.map(function (key) { return _this.model.findItem(key).rectangle; }));
        this.view.scrollIntoView(rectangle);
    };
    DiagramControl.prototype.setInitialStyleProperties = function (style) {
        this.selection.inputPosition.setInitialStyleProperties(style);
    };
    DiagramControl.prototype.setInitialTextStyleProperties = function (style) {
        this.selection.inputPosition.setInitialTextStyleProperties(style);
    };
    DiagramControl.prototype.setInitialConnectorProperties = function (properties) {
        this.selection.inputPosition.setInitialConnectorProperties(properties);
    };
    DiagramControl.prototype.addCustomShapes = function (shapes) {
        var _this = this;
        shapes.forEach(function (shape) {
            shape.apiController = _this.apiController;
            if (shape.defaultWidth)
                shape.defaultWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.defaultWidth);
            if (shape.defaultHeight)
                shape.defaultHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.defaultHeight);
            if (shape.minWidth)
                shape.minWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.minWidth);
            if (shape.minHeight)
                shape.minHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.minHeight);
            if (shape.maxWidth)
                shape.maxWidth = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.maxWidth);
            if (shape.maxHeight)
                shape.maxHeight = ModelUtils_1.ModelUtils.getTwipsValue(_this.model.units, shape.maxHeight);
            _this.shapeDescriptionManager.registerCustomShape(shape);
        });
    };
    DiagramControl.prototype.removeCustomShapes = function (shapeTypes) {
        var _this = this;
        shapeTypes.forEach(function (shapeType) {
            _this.shapeDescriptionManager.unregisterCustomShape(shapeType);
        });
    };
    DiagramControl.prototype.removeAllCustomShapes = function () {
        this.shapeDescriptionManager.unregisterAllCustomShapes();
    };
    DiagramControl.prototype.importModel = function (model) {
        model.units = this.model.units;
        this.model = model;
        this.model.initializeKeyCounter();
        this.apiController.model = model;
        this.onImportData();
    };
    DiagramControl.prototype.importItemsData = function () {
        this.onImportData();
    };
    DiagramControl.prototype.onImportData = function () {
        if (this.render) {
            this.render.clear();
            this.render.onNewModel(this.model.items);
        }
        this.permissionsProvider.clearCache();
        this.selection.initialize(this.model);
        this.modelManipulator.initialize(this.model, this.routingModel);
        this.history.clear();
        this.eventManager.initialize();
        this.modelManipulator.commitPageChanges();
        this.modelManipulator.commitItemsCreateChanges();
        this.notifyViewChanged();
        this.notifyHistoryChanged();
    };
    DiagramControl.prototype.createDocumentDataSource = function (nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) {
        this.documentDataSource = new DocumentDataSource_1.DocumentDataSource(this, nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter);
        this.apiController.setDataSource(this.documentDataSource);
        return this.documentDataSource;
    };
    DiagramControl.prototype.deleteDocumentDataSource = function () {
        this.apiController.setDataSource(null);
        delete this.documentDataSource;
    };
    DiagramControl.prototype.applyShapeSizeSettings = function (settings) {
        this.settings.applyShapeSizeSettings(settings, this.model.units);
    };
    DiagramControl.prototype.applyOperationSettings = function (settings) {
        this.permissionsProvider.operationSettings.applySettings(settings);
    };
    DiagramControl.prototype.beginUpdateCanvas = function () {
        if (this.render) {
            this.render.items.beginUpdate();
            this.render.selection.beginUpdate();
        }
    };
    DiagramControl.prototype.endUpdateCanvas = function () {
        if (this.render) {
            this.render.items.endUpdate();
            this.render.selection.endUpdate();
        }
    };
    DiagramControl.prototype.beginUpdate = function () {
        this.barManager.beginUpdate();
        this.apiController.beginUpdate();
        this.eventManager.beginUpdate();
    };
    DiagramControl.prototype.endUpdate = function () {
        this.barManager.endUpdate();
        this.apiController.endUpdate();
        this.eventManager.endUpdate();
    };
    DiagramControl.prototype.notifyEdgeInserted = function (data, callback, errorCallback) {
        if (this.onEdgeInserted)
            this.onEdgeInserted(data, callback, errorCallback);
        else
            callback(data);
    };
    DiagramControl.prototype.notifyEdgeUpdated = function (key, data, callback, errorCallback) {
        if (this.onEdgeUpdated)
            this.onEdgeUpdated(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyEdgeRemoved = function (key, data, callback, errorCallback) {
        if (this.onEdgeUpdated)
            this.onEdgeRemoved(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyNodeInserted = function (data, callback, errorCallback) {
        if (this.onNodeInserted)
            this.onNodeInserted(data, callback, errorCallback);
        else
            callback(data);
    };
    DiagramControl.prototype.notifyNodeUpdated = function (key, data, callback, errorCallback) {
        if (this.onNodeUpdated)
            this.onNodeUpdated(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.notifyNodeRemoved = function (key, data, callback, errorCallback) {
        if (this.onNodeRemoved)
            this.onNodeRemoved(key, data, callback, errorCallback);
        else
            callback(key, data);
    };
    DiagramControl.prototype.reloadInsertedItem = function (dataKey) {
        if (this.settings.reloadInsertedItemRequired)
            this.reloadContent(dataKey);
    };
    DiagramControl.prototype.reloadContent = function (dataKey, getData, layoutParameters, isExternalChanges) {
        if (!this.documentDataSource)
            return;
        if (this.isChangesLocked())
            this.reloadContentNeeded = true;
        var addNewHistoryItem = isExternalChanges === true || (isExternalChanges === undefined && !this.reloadContentNeeded);
        var reloadContentParameters = addNewHistoryItem ? this.reloadContentByExternalChangesParameters : this.reloadContentParameters;
        reloadContentParameters.add(dataKey, getData, layoutParameters);
        if (!this.isChangesLocked()) {
            this.reloadContentCore(reloadContentParameters, addNewHistoryItem);
            this.barManager.updateItemsState();
        }
    };
    DiagramControl.prototype.reloadContentCore = function (parameters, addNewHistoryItem) {
        var _this = this;
        var data = parameters.getData && parameters.getData();
        var changes = this.documentDataSource.refetchData(data && data.nodeDataSource, data && data.edgeDataSource);
        this.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        this.documentDataSource.updateModelItems(this.history, this.model, this.shapeDescriptionManager, this.selection, new DataLayoutParameters_1.DataLayoutParameters(this.settings, parameters.layoutParameters), addNewHistoryItem, parameters.dataKeys, function (item) {
            _this.modelManipulator.commitItemUpdateChanges(item);
        }, changes, this.settings.snapToGrid, this.settings.gridSize, this.measurer);
        this.permissionsProvider.unlockPermissions();
        this.endUpdateCanvas();
        parameters.clear();
    };
    DiagramControl.prototype.notifyHistoryChanged = function () {
        if (this.documentDataSource) {
            this.shouldUpdateItemsByModel = true;
            if (!this.settings.readOnly)
                this.notifyDataChanges();
        }
        else
            this.raiseOnChanged();
    };
    DiagramControl.prototype.notifyViewChanged = function () {
        this.settings.notifyViewChanged();
    };
    DiagramControl.prototype.notifyToolboxDragStart = function (evt) {
        this.render.notifyToolboxDragStart(evt);
        if (this.onToolboxDragStart)
            this.onToolboxDragStart();
    };
    DiagramControl.prototype.notifyToolboxDragEnd = function (evt) {
        this.render.notifyToolboxDragEnd(evt);
        if (this.onToolboxDragEnd)
            this.onToolboxDragEnd();
    };
    DiagramControl.prototype.notifyToolboxDraggingMouseMove = function (evt) {
        if (this.render)
            this.render.notifyToolboxDraggingMouseMove(evt);
    };
    DiagramControl.prototype.notifyTextInputStart = function (item, text, position, size) {
        if (this.onTextInputStart)
            this.onTextInputStart();
    };
    DiagramControl.prototype.notifyTextInputEnd = function (item, captureFocus) {
        if (this.onTextInputEnd)
            this.onTextInputEnd();
    };
    DiagramControl.prototype.notifyTextInputPermissionsCheck = function (item, allowed) { };
    DiagramControl.prototype.notifyToggleFullscreen = function (value) {
        if (this.onToggleFullscreen)
            this.onToggleFullscreen(value);
    };
    DiagramControl.prototype.notifyShowContextMenu = function (eventPoint, modelPoint) {
        if (this.onShowContextMenu && this.render) {
            var selection = void 0;
            var selectedItems = this.selection.getSelectedItems(true);
            if (selectedItems.length > 0) {
                var rect = ModelUtils_1.ModelUtils.createRectangle(this.selection.getSelectedItems(true));
                var pos = this.render.getEventPointByModelPoint(rect.createPosition());
                var size = this.render.view.getAbsoluteSize(rect.createSize());
                selection = { x: pos.x, y: pos.y, width: size.width, height: size.height };
            }
            if (eventPoint) {
                this.contextMenuPosition = new point_1.Point(eventPoint.x, eventPoint.y);
                this.onShowContextMenu(eventPoint.x, eventPoint.y, selection);
            }
            else if (modelPoint) {
                var point = this.render.getEventPointByModelPoint(modelPoint);
                this.contextMenuPosition = point.clone();
                this.onShowContextMenu(point.x, point.y, selection);
            }
        }
    };
    DiagramControl.prototype.notifyHideContextMenu = function () {
        if (this.onHideContextMenu && this.render)
            this.onHideContextMenu();
    };
    DiagramControl.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) {
        if (this.onShowContextToolbox && this.render) {
            var point = this.render.getEventPointByModelPoint(modelPoint);
            this.onShowContextToolbox(point.x, point.y, side, category, callback);
            this.render.view.notifyShowContextToolbox();
        }
    };
    DiagramControl.prototype.notifyHideContextToolbox = function () {
        if (this.onHideContextToolbox && this.render) {
            this.onHideContextToolbox();
            this.render.view.notifyHideContextToolbox();
        }
        this.cleanContextToolbox();
    };
    DiagramControl.prototype.notifyShapeDescriptionChanged = function (description) {
        this.modelManipulator.updateShapeDescription(description);
    };
    DiagramControl.prototype.notifyImageCacheReadyStateChanged = function (ready) {
        this.barManager.updateItemsState();
    };
    DiagramControl.prototype.raiseCanvasViewActualZoomChanged = function () {
        this.render.view.raiseActualZoomChanged();
    };
    DiagramControl.prototype.notifyRequestOperation = function (operation, args) {
        if (this.requestOperationByDataSource(operation, args))
            return;
        if (this.onRequestOperation)
            this.onRequestOperation(operation, args);
    };
    DiagramControl.prototype.requestOperationByDataSource = function (operation, args) {
        if (!(this.documentDataSource && (this.documentDataSource.IsNodeParentIdMode() || this.documentDataSource.IsNodeItemsMode())))
            return false;
        if (operation === ModelOperationSettings_1.DiagramModelOperation.ChangeConnection) {
            var e = args;
            var shape = e.shape && this.model.findItem(e.shape.id);
            var connector = e.connector && this.model.findItem(e.connector.id);
            if (!(shape && connector))
                return;
            if (e.position === Connector_1.ConnectorPosition.End)
                for (var i = 0; i < shape.attachedConnectors.length; i++) {
                    var attachedConnector = shape.attachedConnectors[i];
                    if (attachedConnector !== connector && attachedConnector.endItem && attachedConnector.endItem === shape) {
                        e.allowed = false;
                        break;
                    }
                }
            if (e.allowed && connector.beginItem && connector.endItem && this.isShapeParent(connector.endItem, connector.beginItem))
                e.allowed = false;
        }
        return !args.allowed;
    };
    DiagramControl.prototype.isShapeParent = function (parentShape, shape) {
        if (parentShape === shape)
            return true;
        for (var i = 0; i < parentShape.attachedConnectors.length; i++) {
            var attachedConnector = parentShape.attachedConnectors[i];
            if (attachedConnector.beginItem === parentShape && attachedConnector.endItem) {
                var childShape = attachedConnector.endItem;
                if (childShape === shape || this.isShapeParent(childShape, shape))
                    return true;
            }
        }
        return false;
    };
    DiagramControl.prototype.isChangesLocked = function () {
        return this.updateLockCount > 0;
    };
    DiagramControl.prototype.beginChangesNotification = function () {
        if (!this.isChangesLocked())
            if (this.changesLockChanged)
                this.changesLockChanged(true);
        this.updateLockCount++;
    };
    DiagramControl.prototype.endChangesNotification = function (preventNotifyReloadContent) {
        var _this = this;
        this.updateLockCount--;
        if (!this.isChangesLocked()) {
            this.changesLockChanged(false);
            if (!preventNotifyReloadContent)
                setTimeout(function () {
                    _this.notifyReloadContent();
                    _this.notifyDataChanges();
                }, 0);
        }
    };
    DiagramControl.prototype.changesLockChanged = function (locked) {
        if (locked)
            this.lockedReadOnly = this.settings.readOnly;
        else
            locked = this.lockedReadOnly;
        this.commandManager.getCommand(CommandManager_1.DiagramCommand.ToggleReadOnly).execute(locked);
    };
    DiagramControl.prototype.notifyDataChanges = function () {
        if (this.isChangesLocked())
            return;
        if (this.shouldUpdateItemsByModel) {
            this.documentDataSource.updateItemsByModel(this.model);
            this.shouldUpdateItemsByModel = false;
        }
        this.raiseOnChanged();
    };
    DiagramControl.prototype.notifyReloadContent = function () {
        if (this.reloadContentNeeded) {
            if (!this.reloadContentParameters.empty)
                this.reloadContentCore(this.reloadContentParameters, false);
            if (!this.reloadContentByExternalChangesParameters.empty)
                this.reloadContentCore(this.reloadContentByExternalChangesParameters, true);
            this.reloadContentNeeded = false;
        }
    };
    DiagramControl.prototype.raiseOnChanged = function () {
        if (this.onChanged)
            this.onChanged();
    };
    return DiagramControl;
}());
exports.DiagramControl = DiagramControl;


/***/ }),

/***/ 720:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeVerticalBottomToTopCommand = void 0;
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutTreeVerticalCommand_1 = __webpack_require__(1893);
var AutoLayoutTreeVerticalBottomToTopCommand = (function (_super) {
    __extends(AutoLayoutTreeVerticalBottomToTopCommand, _super);
    function AutoLayoutTreeVerticalBottomToTopCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalBottomToTopCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutTreeVerticalBottomToTopCommand;
}(AutoLayoutTreeVerticalCommand_1.AutoLayoutTreeVerticalCommand));
exports.AutoLayoutTreeVerticalBottomToTopCommand = AutoLayoutTreeVerticalBottomToTopCommand;


/***/ }),

/***/ 728:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorRoutingModeCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(3913);
var Settings_1 = __webpack_require__(9307);
var ChangeConnectorRoutingModeCommand = (function (_super) {
    __extends(ChangeConnectorRoutingModeCommand, _super);
    function ChangeConnectorRoutingModeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorRoutingModeCommand.prototype.getValue = function () {
        return this.control.settings.connectorRoutingMode;
    };
    ChangeConnectorRoutingModeCommand.prototype.executeCore = function (state, parameter) {
        var mode = parameter !== undefined ? parameter : Settings_1.ConnectorRoutingMode.None;
        this.control.settings.connectorRoutingMode = mode;
        return true;
    };
    return ChangeConnectorRoutingModeCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeConnectorRoutingModeCommand = ChangeConnectorRoutingModeCommand;


/***/ }),

/***/ 750:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DomUtils = void 0;
var browser_1 = __webpack_require__(8424);
var common_1 = __webpack_require__(961);
var math_1 = __webpack_require__(594);
var string_1 = __webpack_require__(4989);
var DomUtils = (function () {
    function DomUtils() {
    }
    DomUtils.clearInnerHtml = function (element) {
        while (element.firstChild)
            element.removeChild(element.firstChild);
    };
    DomUtils.setStylePosition = function (style, point) {
        style.left = math_1.MathUtils.round(point.x, 3) + 'px';
        style.top = math_1.MathUtils.round(point.y, 3) + 'px';
    };
    DomUtils.setStyleSize = function (style, size) {
        style.width = math_1.MathUtils.round(size.width, 3) + 'px';
        style.height = math_1.MathUtils.round(size.height, 3) + 'px';
    };
    DomUtils.setStyleSizeAndPosition = function (style, rectangle) {
        DomUtils.setStylePosition(style, rectangle);
        DomUtils.setStyleSize(style, rectangle);
    };
    DomUtils.hideNode = function (node) {
        if (node) {
            var parentNode = node.parentNode;
            if (parentNode)
                parentNode.removeChild(node);
        }
    };
    DomUtils.isHTMLElementNode = function (node) {
        return node.nodeType === Node.ELEMENT_NODE;
    };
    DomUtils.isTextNode = function (node) {
        return node.nodeType === Node.TEXT_NODE;
    };
    DomUtils.isElementNode = function (node) {
        return node.nodeType === Node.ELEMENT_NODE;
    };
    DomUtils.isHTMLTableRowElement = function (element) {
        return element.tagName === 'TR';
    };
    DomUtils.isItParent = function (parentElement, element) {
        if (!parentElement || !element)
            return false;
        while (element) {
            if (element === parentElement)
                return true;
            if (element.tagName === 'BODY')
                return false;
            element = element.parentNode;
        }
        return false;
    };
    DomUtils.getParentByTagName = function (element, tagName) {
        tagName = tagName.toUpperCase();
        while (element) {
            if (element.tagName === 'BODY')
                return null;
            if (element.tagName === tagName)
                return element;
            element = element.parentNode;
        }
        return null;
    };
    DomUtils.getDocumentScrollTop = function () {
        var isScrollBodyIE = browser_1.Browser.IE && DomUtils.getCurrentStyle(document.body).overflow === 'hidden' && document.body.scrollTop > 0;
        if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge || isScrollBodyIE) {
            if (browser_1.Browser.MacOSMobilePlatform)
                return window.pageYOffset;
            if (browser_1.Browser.WebKitFamily)
                return document.documentElement.scrollTop || document.body.scrollTop;
            return document.body.scrollTop;
        }
        else
            return document.documentElement.scrollTop;
    };
    DomUtils.getDocumentScrollLeft = function () {
        var isScrollBodyIE = browser_1.Browser.IE && DomUtils.getCurrentStyle(document.body).overflow === 'hidden' && document.body.scrollLeft > 0;
        if (browser_1.Browser.Edge || isScrollBodyIE)
            return document.body ? document.body.scrollLeft : document.documentElement.scrollLeft;
        if (browser_1.Browser.WebKitFamily)
            return document.documentElement.scrollLeft || document.body.scrollLeft;
        return document.documentElement.scrollLeft;
    };
    DomUtils.getCurrentStyle = function (element) {
        if (element.currentStyle)
            return element.currentStyle;
        else if (document.defaultView && document.defaultView.getComputedStyle) {
            var result = document.defaultView.getComputedStyle(element, null);
            if (!result && browser_1.Browser.Firefox && window.frameElement) {
                var changes = [];
                var curElement = window.frameElement;
                while (!(result = document.defaultView.getComputedStyle(element, null))) {
                    changes.push([curElement, curElement.style.display]);
                    curElement.style.setProperty('display', 'block', 'important');
                    curElement = curElement.tagName === 'BODY' ? curElement.ownerDocument.defaultView.frameElement : curElement.parentNode;
                }
                result = cloneObject(result);
                for (var ch = void 0, i = 0; ch = changes[i]; i++)
                    ch[0].style.display = ch[1];
                document.body.offsetWidth;
            }
            return result;
        }
        return window.getComputedStyle(element, null);
    };
    DomUtils.setFocus = function (element) {
        function focusCore() {
            try {
                element.focus();
                if (browser_1.Browser.IE && document.activeElement !== element)
                    element.focus();
            }
            catch (e) {
            }
        }
        if (browser_1.Browser.MacOSMobilePlatform)
            focusCore();
        else {
            setTimeout(function () {
                focusCore();
            }, 100);
        }
    };
    DomUtils.hasClassName = function (element, className) {
        try {
            var classNames = className.split(' ');
            var classList = element.classList;
            if (classList) {
                for (var i = classNames.length - 1; i >= 0; i--) {
                    if (!classList.contains(classNames[i]))
                        return false;
                }
            }
            else {
                var elementClassName = element.getAttribute && element.getAttribute('class');
                if (!elementClassName)
                    return false;
                var elementClasses = elementClassName.split(' ');
                for (var i = classNames.length - 1; i >= 0; i--) {
                    if (elementClasses.indexOf(classNames[i]) < 0)
                        return false;
                }
            }
            return true;
        }
        catch (e) {
            return false;
        }
    };
    DomUtils.addClassName = function (element, className) {
        if (!DomUtils.hasClassName(element, className)) {
            var elementClassName = element.getAttribute && element.getAttribute('class');
            element.setAttribute('class', elementClassName === '' ? className : elementClassName + " " + className);
        }
    };
    DomUtils.removeClassName = function (element, className) {
        var elementClassName = element.getAttribute && element.getAttribute('class');
        var updClassName = " " + elementClassName + " ";
        var newClassName = updClassName.replace(" " + className + " ", ' ');
        if (updClassName.length !== newClassName.length)
            element.setAttribute('class', string_1.StringUtils.trim(newClassName));
    };
    DomUtils.toggleClassName = function (element, className, toggle) {
        if (toggle === undefined) {
            if (DomUtils.hasClassName(element, className))
                DomUtils.removeClassName(element, className);
            else
                DomUtils.addClassName(element, className);
        }
        else {
            if (toggle)
                DomUtils.addClassName(element, className);
            else
                DomUtils.removeClassName(element, className);
        }
    };
    DomUtils.pxToInt = function (px) {
        return pxToNumber(px, parseInt);
    };
    DomUtils.pxToFloat = function (px) {
        return pxToNumber(px, parseFloat);
    };
    DomUtils.getAbsolutePositionY = function (element) {
        function getAbsolutePositionY_IE(element) {
            return browser_1.Browser.IE && element.parentNode === null ?
                0 :
                element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop();
        }
        function getAbsolutePositionY_FF3(element) {
            return Math.round(element.getBoundingClientRect().top + DomUtils.getDocumentScrollTop());
        }
        function getAbsolutePositionY_NS(curEl) {
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, false);
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetTop;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollTop;
                if (!isFirstCycle && browser_1.Browser.Firefox) {
                    var style = DomUtils.getCurrentStyle(curEl);
                    if (curEl.tagName === 'DIV' && style.overflow !== 'visible')
                        pos += DomUtils.pxToInt(style.borderTopWidth);
                }
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        function getAbsolutePositionY_Other(curEl) {
            var pos = 0;
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetTop;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollTop;
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        if (!element)
            return 0;
        if (browser_1.Browser.IE)
            return getAbsolutePositionY_IE(element);
        else if (browser_1.Browser.Firefox && browser_1.Browser.Version >= 3)
            return getAbsolutePositionY_FF3(element);
        else if (browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3))
            return getAbsolutePositionY_NS(element);
        else if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge)
            return getAbsolutePositionY_FF3(element);
        return getAbsolutePositionY_Other(element);
    };
    DomUtils.getAbsolutePositionX = function (element) {
        function getAbsolutePositionX_IE(element) {
            return browser_1.Browser.IE && element.parentNode === null ?
                0 :
                element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft();
        }
        function getAbsolutePositionX_FF3(element) {
            return Math.round(element.getBoundingClientRect().left + DomUtils.getDocumentScrollLeft());
        }
        function getAbsolutePositionX_Opera(curEl) {
            var isFirstCycle = true;
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle)
                    pos -= curEl.scrollLeft;
                curEl = curEl.offsetParent;
                isFirstCycle = false;
            }
            pos += document.body.scrollLeft;
            return pos;
        }
        function getAbsolutePositionX_NS(curEl) {
            var pos = getAbsoluteScrollOffset_OperaFF(curEl, true);
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollLeft;
                if (!isFirstCycle && browser_1.Browser.Firefox) {
                    var style = DomUtils.getCurrentStyle(curEl);
                    if (curEl.tagName === 'DIV' && style.overflow !== 'visible')
                        pos += DomUtils.pxToInt(style.borderLeftWidth);
                }
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        function getAbsolutePositionX_Other(curEl) {
            var pos = 0;
            var isFirstCycle = true;
            while (curEl != null) {
                pos += curEl.offsetLeft;
                if (!isFirstCycle && curEl.offsetParent != null)
                    pos -= curEl.scrollLeft;
                isFirstCycle = false;
                curEl = curEl.offsetParent;
            }
            return pos;
        }
        if (!element)
            return 0;
        if (browser_1.Browser.IE)
            return getAbsolutePositionX_IE(element);
        else if (browser_1.Browser.Firefox && browser_1.Browser.Version >= 3)
            return getAbsolutePositionX_FF3(element);
        else if (browser_1.Browser.Opera && browser_1.Browser.Version <= 12)
            return getAbsolutePositionX_Opera(element);
        else if (browser_1.Browser.NetscapeFamily && (!browser_1.Browser.Firefox || browser_1.Browser.Version < 3))
            return getAbsolutePositionX_NS(element);
        else if (browser_1.Browser.WebKitFamily || browser_1.Browser.Edge)
            return getAbsolutePositionX_FF3(element);
        else
            return getAbsolutePositionX_Other(element);
    };
    DomUtils.isInteractiveControl = function (element) {
        return ['A', 'INPUT', 'SELECT', 'OPTION', 'TEXTAREA', 'BUTTON', 'IFRAME'].indexOf(element.tagName) > -1;
    };
    DomUtils.getClearClientHeight = function (element) {
        return element.offsetHeight - (DomUtils.getTopBottomPaddings(element) + DomUtils.getVerticalBordersWidth(element));
    };
    DomUtils.getTopBottomPaddings = function (element, style) {
        var currentStyle = style ? style : DomUtils.getCurrentStyle(element);
        return DomUtils.pxToInt(currentStyle.paddingTop) + DomUtils.pxToInt(currentStyle.paddingBottom);
    };
    DomUtils.getVerticalBordersWidth = function (element, style) {
        if (!common_1.isDefined(style))
            style = (browser_1.Browser.IE && browser_1.Browser.MajorVersion !== 9 && window.getComputedStyle) ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element);
        var res = 0;
        if (style.borderTopStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderTopWidth);
        if (style.borderBottomStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderBottomWidth);
        return res;
    };
    DomUtils.getNodes = function (parent, predicate) {
        var collection = parent.all || parent.getElementsByTagName('*');
        var result = [];
        for (var i = 0; i < collection.length; i++) {
            var element = collection[i];
            if (predicate(element))
                result.push(element);
        }
        return result;
    };
    DomUtils.getChildNodes = function (parent, predicate) {
        var collection = parent.childNodes;
        var result = [];
        for (var i = 0; i < collection.length; i++) {
            var element = collection[i];
            if (predicate(element))
                result.push(element);
        }
        return result;
    };
    DomUtils.getNodesByClassName = function (parent, className) {
        if (parent.querySelectorAll) {
            var children = parent.querySelectorAll("." + className);
            var result_1 = [];
            children.forEach(function (element) { return result_1.push(element); });
            return result_1;
        }
        else
            return DomUtils.getNodes(parent, function (elem) { return DomUtils.hasClassName(elem, className); });
    };
    DomUtils.getChildNodesByClassName = function (parent, className) {
        function nodeListToArray(nodeList, filter) {
            var result = [];
            for (var i = 0; i < nodeList.length; i++) {
                var element = nodeList[i];
                if (filter(element))
                    result.push(element);
            }
            return result;
        }
        if (parent.querySelectorAll) {
            var children = parent.querySelectorAll("." + className);
            return nodeListToArray(children, function (element) { return element.parentNode === parent; });
        }
        else {
            return DomUtils.getChildNodes(parent, function (elem) {
                if (DomUtils.isElementNode(elem))
                    return common_1.isNonNullString(elem.className) && DomUtils.hasClassName(elem, elem.className);
                else
                    return false;
            });
        }
    };
    DomUtils.getVerticalScrollBarWidth = function () {
        if (DomUtils.verticalScrollBarWidth === undefined) {
            var container = document.createElement('DIV');
            container.style.cssText = 'position: absolute; top: 0px; left: 0px; visibility: hidden; width: 200px; height: 150px; overflow: hidden; box-sizing: content-box';
            document.body.appendChild(container);
            var child = document.createElement('P');
            container.appendChild(child);
            child.style.cssText = 'width: 100%; height: 200px;';
            var widthWithoutScrollBar = child.offsetWidth;
            container.style.overflow = 'scroll';
            var widthWithScrollBar = child.offsetWidth;
            if (widthWithoutScrollBar === widthWithScrollBar)
                widthWithScrollBar = container.clientWidth;
            DomUtils.verticalScrollBarWidth = widthWithoutScrollBar - widthWithScrollBar;
            document.body.removeChild(container);
        }
        return DomUtils.verticalScrollBarWidth;
    };
    DomUtils.getHorizontalBordersWidth = function (element, style) {
        if (!common_1.isDefined(style))
            style = (browser_1.Browser.IE && window.getComputedStyle) ? window.getComputedStyle(element) : DomUtils.getCurrentStyle(element);
        var res = 0;
        if (style.borderLeftStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderLeftWidth);
        if (style.borderRightStyle !== 'none')
            res += DomUtils.pxToFloat(style.borderRightWidth);
        return res;
    };
    DomUtils.getFontFamiliesFromCssString = function (cssString) {
        return cssString.split(',').map(function (fam) { return string_1.StringUtils.trim(fam.replace(/'|"/gi, '')); });
    };
    DomUtils.getInnerText = function (container) {
        if (browser_1.Browser.Safari && browser_1.Browser.MajorVersion <= 5) {
            if (DomUtils.html2PlainTextFilter === null) {
                DomUtils.html2PlainTextFilter = document.createElement('DIV');
                DomUtils.html2PlainTextFilter.style.width = '0';
                DomUtils.html2PlainTextFilter.style.height = '0';
                DomUtils.html2PlainTextFilter.style.overflow = 'visible';
                DomUtils.html2PlainTextFilter.style.display = 'none';
                document.body.appendChild(DomUtils.html2PlainTextFilter);
            }
            var filter = DomUtils.html2PlainTextFilter;
            filter.innerHTML = container.innerHTML;
            filter.style.display = '';
            var innerText = filter.innerText;
            filter.style.display = 'none';
            return innerText;
        }
        else if (browser_1.Browser.NetscapeFamily || browser_1.Browser.WebKitFamily || (browser_1.Browser.IE && browser_1.Browser.Version >= 9) || browser_1.Browser.Edge)
            return container.textContent;
        else
            return container.innerText;
    };
    DomUtils.html2PlainTextFilter = null;
    DomUtils.verticalScrollBarWidth = undefined;
    return DomUtils;
}());
exports.DomUtils = DomUtils;
function cloneObject(srcObject) {
    if (typeof (srcObject) !== 'object' || !common_1.isDefined(srcObject))
        return srcObject;
    var newObject = {};
    for (var i in srcObject)
        newObject[i] = srcObject[i];
    return newObject;
}
function pxToNumber(px, parseFunction) {
    var result = 0;
    if (common_1.isDefined(px) && px !== '') {
        try {
            var indexOfPx = px.indexOf('px');
            if (indexOfPx > -1)
                result = parseFunction(px.substr(0, indexOfPx));
        }
        catch (e) { }
    }
    return result;
}
function getAbsoluteScrollOffset_OperaFF(curEl, isX) {
    var pos = 0;
    var isFirstCycle = true;
    while (curEl != null) {
        if (curEl.tagName === 'BODY')
            break;
        var style = DomUtils.getCurrentStyle(curEl);
        if (style.position === 'absolute')
            break;
        if (!isFirstCycle && curEl.tagName === 'DIV' && (style.position === '' || style.position === 'static'))
            pos -= isX ? curEl.scrollLeft : curEl.scrollTop;
        curEl = curEl.parentNode;
        isFirstCycle = false;
    }
    return pos;
}


/***/ }),

/***/ 779:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandler = void 0;
var MouseHandlerDefaultState_1 = __webpack_require__(7011);
var Event_1 = __webpack_require__(5428);
var point_1 = __webpack_require__(5327);
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerDefaultReadOnlyTouchState_1 = __webpack_require__(9782);
var MouseHandlerDefaultReadOnlyState_1 = __webpack_require__(9157);
var MouseHandlerDefaultTouchState_1 = __webpack_require__(6696);
var key_1 = __webpack_require__(6537);
var Utils_1 = __webpack_require__(41);
var MouseHandler = (function () {
    function MouseHandler(history, selection, model, eventManager, readOnly, view, visualizerManager, contextToolboxHandler, shapeDescriptionManager, settings, permissionsProvider) {
        this.history = history;
        this.selection = selection;
        this.model = model;
        this.eventManager = eventManager;
        this.readOnly = readOnly;
        this.view = view;
        this.visualizerManager = visualizerManager;
        this.contextToolboxHandler = contextToolboxHandler;
        this.shapeDescriptionManager = shapeDescriptionManager;
        this.settings = settings;
        this.permissionsProvider = permissionsProvider;
        this.finishStateLock = 0;
        this.initialize(model);
        this.selection.onChanged.add(this);
    }
    MouseHandler.prototype.initialize = function (model) {
        this.model = model;
        this.allowMultipleSelection = true;
        this.allowCopyDiagramItems = true;
        this.allowSnapToCellOnDragDiagramItem = true;
        this.allowSnapToCellOnDragPoint = true;
        this.allowSnapToCellOnResizeShape = true;
        this.allowFixedDrag = true;
        this.allowZoomOnWheel = true;
        this.allowScrollPage = true;
        this.shouldScrollPage = false;
        this.copyDiagramItemsByCtrlAndShift = false;
        this.startScrollingPageByCtrl = false;
        this.initializeDefaultState();
    };
    MouseHandler.prototype.initializeDefaultState = function () {
        this.defaultState = this.readOnly ?
            (Utils_1.EventUtils.isTouchMode() ?
                new MouseHandlerDefaultReadOnlyTouchState_1.MouseHandlerDefaultReadOnlyTouchState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings) :
                new MouseHandlerDefaultReadOnlyState_1.MouseHandlerDefaultReadOnlyState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings)) :
            (Utils_1.EventUtils.isTouchMode() ?
                new MouseHandlerDefaultTouchState_1.MouseHandlerDefaultTouchState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings) :
                new MouseHandlerDefaultState_1.MouseHandlerDefaultState(this, this.history, this.selection, this.model, this.view, this.visualizerManager, this.shapeDescriptionManager, this.settings));
        this.switchToDefaultState();
    };
    MouseHandler.prototype.onMouseDown = function (evt) {
        this.mouseDownEvent = evt;
        this.state.onMouseDown(evt);
    };
    MouseHandler.prototype.onMouseMove = function (evt) {
        this.state.onMouseMove(evt);
    };
    MouseHandler.prototype.onMouseUp = function (evt) {
        this.state.onMouseUp(evt);
    };
    MouseHandler.prototype.onMouseDblClick = function (evt) {
        this.state.onMouseDblClick(evt);
    };
    MouseHandler.prototype.onMouseClick = function (evt) {
        this.state.onMouseClick(evt);
    };
    MouseHandler.prototype.onLongTouch = function (evt) {
        if (!evt.touches || evt.touches.length > 1)
            return;
        var key = evt.source.key;
        if (key === undefined)
            this.selection.clear();
        else if (this.selection.hasKey(key))
            this.selection.remove(key);
        else
            this.selection.add(key);
    };
    MouseHandler.prototype.onShortcut = function (code) {
        return this.state.onShortcut(code);
    };
    MouseHandler.prototype.onWheel = function (evt) {
        return this.state.onMouseWheel(evt);
    };
    MouseHandler.prototype.onDragStart = function (evt) {
        this.state.onDragStart(evt);
    };
    MouseHandler.prototype.onDragEnd = function (evt) {
        this.state.onDragEnd(evt);
    };
    MouseHandler.prototype.onKeyDown = function (evt) {
        this.state.onKeyDown(evt);
    };
    MouseHandler.prototype.onKeyUp = function (evt) {
        this.state.onKeyUp(evt);
    };
    MouseHandler.prototype.showContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, applyCallback, cancelCallback) {
        this.contextToolboxHandler.showContextToolbox(modelPoint, getPositionToInsertShapeTo, side, category, applyCallback, cancelCallback);
    };
    MouseHandler.prototype.hideContextToolbox = function (applyed) {
        this.contextToolboxHandler.hideContextToolbox(applyed);
    };
    MouseHandler.prototype.canScrollPage = function (evt) {
        if (this.startScrollingPageByCtrl) {
            if (!this.hasCtrlModifier(evt.modifiers))
                return false;
            if (!this.copyDiagramItemsByCtrlAndShift)
                return true;
            return !evt.source.isConnector && !evt.source.isShape;
        }
        return this.allowScrollPage && this.shouldScrollPage;
    };
    MouseHandler.prototype.canMultipleSelection = function (evt) {
        return this.allowMultipleSelection && this.hasCtrlOrShiftModifier(evt.modifiers);
    };
    MouseHandler.prototype.canCopySelectedItems = function (evt) {
        if (!this.allowCopyDiagramItems)
            return false;
        return this.copyDiagramItemsByCtrlAndShift ? this.hasCtrlAndShiftModifier(evt.modifiers) : this.hasAltModifier(evt.modifiers);
    };
    MouseHandler.prototype.canCalculateFixedPosition = function (evt) {
        if (!this.allowFixedDrag || !this.hasShiftModifier(evt.modifiers))
            return false;
        if (this.copyDiagramItemsByCtrlAndShift && this.hasCtrlModifier(evt.modifiers))
            return false;
        return true;
    };
    MouseHandler.prototype.canStartZoomOnWheel = function (evt) {
        return this.allowZoomOnWheel && this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.canFinishZoomOnWheel = function (evt) {
        return this.allowZoomOnWheel && !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.onStartScrollPageByKeyboard = function (evt) {
        if (this.canStartScrollingPageByKeyboard(evt)) {
            this.raiseDragScrollStart();
            this.shouldScrollPage = true;
        }
    };
    MouseHandler.prototype.onFinishScrollPageByKeyboard = function (evt) {
        if (this.canEndScrollingPageByKeyboard(evt))
            this.finishScrollingPage();
    };
    MouseHandler.prototype.onFinishScrollPageByMouse = function (evt) {
        if (this.canEndScrollingPage(evt))
            this.finishScrollingPage();
    };
    MouseHandler.prototype.finishScrollingPage = function () {
        this.shouldScrollPage = false;
        this.raiseDragScrollEnd();
        this.switchToDefaultState();
    };
    MouseHandler.prototype.hasCtrlOrShiftModifier = function (key) {
        return this.hasCtrlModifier(key) || this.hasShiftModifier(key);
    };
    MouseHandler.prototype.hasCtrlAndShiftModifier = function (key) {
        return this.hasCtrlModifier(key) && this.hasShiftModifier(key);
    };
    MouseHandler.prototype.hasCtrlModifier = function (key) {
        return (key & key_1.ModifierKey.Ctrl) > 0;
    };
    MouseHandler.prototype.hasAltModifier = function (key) {
        return (key & key_1.ModifierKey.Alt) > 0;
    };
    MouseHandler.prototype.hasShiftModifier = function (key) {
        return (key & key_1.ModifierKey.Shift) > 0;
    };
    MouseHandler.prototype.canStartScrollingPageByKeyboard = function (evt) {
        return !this.startScrollingPageByCtrl && !this.shouldScrollPage && evt.keyCode === key_1.KeyCode.Space;
    };
    MouseHandler.prototype.canEndScrollingPageByKeyboard = function (evt) {
        return !this.startScrollingPageByCtrl && evt.keyCode === key_1.KeyCode.Space;
    };
    MouseHandler.prototype.canEndScrollingPage = function (evt) {
        return this.startScrollingPageByCtrl ? this.hasCtrlModifier(evt.modifiers) : true;
    };
    MouseHandler.prototype.getSnappedPointOnDragDiagramItem = function (evt, basePoint, fixedX, fixedY, startPoint) {
        var snapToCell = this.getSnapToCellOnDragDiagramItem(evt);
        return new point_1.Point(this.getSnappedPos(this.getFixedXPosition(evt, basePoint, fixedX, startPoint), true, snapToCell), this.getSnappedPos(this.getFixedYPosition(evt, basePoint, fixedY, startPoint), false, snapToCell));
    };
    MouseHandler.prototype.getSnappedPointOnDragPoint = function (evt, point, additionalSnappedPoint) {
        var snapToCell = this.getSnapToCellOnDragPoint(evt);
        var x = this.getSnappedPos(point.x, true, snapToCell);
        var y = this.getSnappedPos(point.y, false, snapToCell);
        if (additionalSnappedPoint === undefined)
            return new point_1.Point(x, y);
        else if (Math.pow(point.x - x, 2) + Math.pow(point.y - y, 2) < Math.pow(point.x - additionalSnappedPoint.x, 2) + Math.pow(point.y - additionalSnappedPoint.y, 2))
            return new point_1.Point(x, y);
        else
            return additionalSnappedPoint;
    };
    MouseHandler.prototype.getSnappedOffsetOnDragPoint = function (evt, startPoint) {
        var snapToCell = this.getSnapToCellOnDragPoint(evt);
        return new point_1.Point(this.getSnappedPos(evt.modelPoint.x - startPoint.x, true, snapToCell), this.getSnappedPos(evt.modelPoint.y - startPoint.y, false, snapToCell));
    };
    MouseHandler.prototype.lockAspectRatioOnShapeResize = function (evt) {
        return this.hasShiftModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnappedPositionOnResizeShape = function (evt, pos, isHorizontal) {
        if (!this.getSnapToCellOnResizeShape(evt))
            return pos;
        return ModelUtils_1.ModelUtils.getSnappedPos(this.model, this.settings.gridSize, pos, isHorizontal);
    };
    MouseHandler.prototype.getSnappedPos = function (pos, isHorizontal, snapToCell) {
        return snapToCell ? ModelUtils_1.ModelUtils.getSnappedPos(this.model, this.settings.gridSize, pos, isHorizontal) : pos;
    };
    MouseHandler.prototype.getFixedXPosition = function (evt, basePoint, fixedX, startPoint) {
        return fixedX ? basePoint.x : basePoint.x + evt.modelPoint.x - startPoint.x;
    };
    MouseHandler.prototype.getFixedYPosition = function (evt, basePoint, fixedY, startPoint) {
        return fixedY ? basePoint.y : basePoint.y + evt.modelPoint.y - startPoint.y;
    };
    MouseHandler.prototype.getSnapToCellOnDragDiagramItem = function (evt) {
        return this.allowSnapToCellOnDragDiagramItem &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnapToCellOnDragPoint = function (evt) {
        return this.allowSnapToCellOnDragPoint &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.getSnapToCellOnResizeShape = function (evt) {
        return this.allowSnapToCellOnResizeShape &&
            this.settings.snapToGrid &&
            !this.hasCtrlModifier(evt.modifiers);
    };
    MouseHandler.prototype.tryUpdateModelSize = function (processPoints) {
        this.lockPermissions();
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.history, processPoints);
        this.unlockPermissions();
    };
    MouseHandler.prototype.canAddDiagramItemToSelection = function (evt) {
        return evt.source.key && (evt.button === Event_1.MouseButton.Left || evt.button === Event_1.MouseButton.Right);
    };
    MouseHandler.prototype.addDiagramItemToSelection = function (evt) {
        this.pressedDiagramItemKey = evt.source.key;
        this.pressedDiagramItemInSelection = this.selection.hasKey(this.pressedDiagramItemKey);
        if (this.canMultipleSelection(evt))
            this.selection.add(evt.source.key);
        else
            this.changeSingleSelection(evt.source.key);
    };
    MouseHandler.prototype.canRemoveDiagramItemToSelection = function (evt) {
        return this.pressedDiagramItemKey &&
            evt.source.key &&
            this.pressedDiagramItemKey === evt.source.key &&
            (evt.button === Event_1.MouseButton.Left || evt.button === Event_1.MouseButton.Right);
    };
    MouseHandler.prototype.removeDiagramItemFromSelection = function (button, sourceKey) {
        if (this.pressedDiagramItemInSelection && this.selection.getKeys().length > 1 && button === Event_1.MouseButton.Left)
            this.selection.remove(sourceKey);
    };
    MouseHandler.prototype.changeSingleSelection = function (key) {
        if (!this.selection.hasKey(key))
            this.selection.set([key]);
    };
    MouseHandler.prototype.notifySelectionChanged = function (selection) {
        if (this.pressedDiagramItemKey && !this.selection.hasKey(this.pressedDiagramItemKey)) {
            this.pressedDiagramItemKey = undefined;
            this.pressedDiagramItemInSelection = false;
        }
    };
    MouseHandler.prototype.raiseDragStart = function (keys) {
        this.eventManager.onDocumentDragStart(keys);
    };
    MouseHandler.prototype.raiseDragEnd = function (keys) {
        this.eventManager.onDocumentDragEnd(keys);
    };
    MouseHandler.prototype.raiseDragScrollStart = function () {
        this.eventManager.onDocumentDragScrollStart();
    };
    MouseHandler.prototype.raiseDragScrollEnd = function () {
        this.eventManager.onDocumentDragScrollEnd();
    };
    MouseHandler.prototype.raiseClick = function (keys) {
        this.eventManager.onDocumentClick(keys);
    };
    MouseHandler.prototype.beginStorePermissions = function () {
        this.permissionsProvider.beginStorePermissions();
    };
    MouseHandler.prototype.endStorePermissions = function () {
        this.permissionsProvider.endStorePermissions();
    };
    MouseHandler.prototype.isStoredPermissionsGranted = function () {
        return this.permissionsProvider.isStoredPermissionsGranted();
    };
    MouseHandler.prototype.lockPermissions = function () {
        this.permissionsProvider.lockPermissions();
    };
    MouseHandler.prototype.unlockPermissions = function () {
        this.permissionsProvider.unlockPermissions();
    };
    MouseHandler.prototype.canPerformChangeConnection = function (connector, operationParams) {
        var allowed = true;
        if (connector)
            allowed = this.permissionsProvider.canChangeConnection(connector, operationParams.item, operationParams.oldItem, operationParams.position, operationParams.connectionPointIndex);
        else if (operationParams.item)
            allowed = this.permissionsProvider.canChangeConnection(undefined, operationParams.item, operationParams.oldItem, operationParams.position, operationParams.connectionPointIndex);
        return allowed;
    };
    MouseHandler.prototype.canPerformChangeConnectionOnUpdateUI = function (connector, operationParams) {
        this.permissionsProvider.beginUpdateUI();
        var allowed = this.canPerformChangeConnection(connector, operationParams);
        this.permissionsProvider.endUpdateUI();
        return allowed;
    };
    MouseHandler.prototype.canFinishTextEditing = function () {
        return this.eventManager.canFinishTextEditing();
    };
    MouseHandler.prototype.restartState = function () {
        if (this.state && !this.finishStateLock) {
            this.finishStateLock++;
            this.state.finish();
            this.finishStateLock--;
        }
        this.state.start();
    };
    MouseHandler.prototype.switchToDefaultState = function () {
        this.switchState(this.defaultState);
    };
    MouseHandler.prototype.switchState = function (state) {
        this.newState = state;
        if (this.state && !this.finishStateLock) {
            this.finishStateLock++;
            this.state.finish();
            this.finishStateLock--;
        }
        if (this.newState) {
            this.state = this.newState;
            this.state.start();
            this.newState = undefined;
        }
    };
    MouseHandler.prototype.addInteractingItem = function (item, operation) {
        this.permissionsProvider.addInteractingItem(item, operation);
    };
    MouseHandler.prototype.clearInteractingItems = function () {
        this.permissionsProvider.clearInteractingItems();
    };
    MouseHandler.prototype.notifyReadOnlyChanged = function (readOnly) {
        this.readOnly = readOnly;
        this.initializeDefaultState();
    };
    MouseHandler.prototype.notifySelectionRectShow = function (rect) { };
    MouseHandler.prototype.notifySelectionRectHide = function () { };
    MouseHandler.prototype.notifyResizeInfoShow = function (point, text) { };
    MouseHandler.prototype.notifyResizeInfoHide = function () { };
    MouseHandler.prototype.notifyConnectionPointsShow = function (key, points, activePointIndex, outsideRectangle) {
        this.state.onConnectionPointsShow(key, points);
    };
    MouseHandler.prototype.notifyConnectionPointsHide = function () { };
    MouseHandler.prototype.notifyConnectionTargetShow = function (key, info) {
        this.state.onConnectionTargetShow(key, info);
    };
    MouseHandler.prototype.notifyConnectionTargetHide = function () { };
    MouseHandler.prototype.notifyContainerTargetShow = function (key, info) { };
    MouseHandler.prototype.notifyContainerTargetHide = function () { };
    MouseHandler.prototype.notifyExtensionLinesShow = function (lines) { };
    MouseHandler.prototype.notifyExtensionLinesHide = function () { };
    return MouseHandler;
}());
exports.MouseHandler = MouseHandler;


/***/ }),

/***/ 807:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Base64Utils = void 0;
var file_1 = __webpack_require__(1930);
var mime_type_1 = __webpack_require__(3233);
var Base64Utils = (function () {
    function Base64Utils() {
    }
    Base64Utils.normalizeToDataUrl = function (base64, mimeType) {
        if (!Base64Utils.checkPrependDataUrl(base64))
            base64 = Base64Utils.prependByDataUrl(base64, mimeType);
        return base64;
    };
    Base64Utils.prependByDataUrl = function (base64, mimeType) {
        return "data:" + mimeType + ";base64," + base64;
    };
    Base64Utils.checkPrependDataUrl = function (base64) {
        return Base64Utils.dataUrl.test(base64);
    };
    Base64Utils.deleteDataUrlPrefix = function (base64DataUrl) {
        return base64DataUrl.replace(Base64Utils.dataUrl, '');
    };
    Base64Utils.getUint8Array = function (base64) {
        base64 = atob(base64);
        var n = base64.length;
        var arr = new Uint8Array(n);
        while (n--)
            arr[n] = base64.charCodeAt(n);
        return arr;
    };
    Base64Utils.fromArrayBuffer = function (buffer) {
        var binary = [];
        var bytes = new Uint8Array(buffer);
        var len = bytes.byteLength;
        for (var i = 0; i < len; i++)
            binary.push(String.fromCharCode(bytes[i]));
        return window.btoa(binary.join(''));
    };
    Base64Utils.getFileFromBase64 = function (base64, fileName, options) {
        if (fileName === void 0) { fileName = ''; }
        var data = Base64Utils.getUint8Array(base64);
        return file_1.FileUtils.createFile([data], fileName, options);
    };
    Base64Utils.getMimeTypeAsString = function (base64) {
        var match = base64.match(Base64Utils.dataUrl);
        return match ? match[1] : null;
    };
    Base64Utils.getKnownMimeType = function (base64) {
        var match = base64.match(Base64Utils.dataUrl);
        return match ? mime_type_1.MimeTypeUtils.stringTypeToType(match[1]) : mime_type_1.DxMimeType.Unknown;
    };
    Base64Utils.fromBlobAsArrayBuffer = function (blob, callback) {
        var reader = new FileReader();
        reader.onloadend = function () { return callback(Base64Utils.fromArrayBuffer(reader.result)); };
        reader.readAsArrayBuffer(blob);
    };
    Base64Utils.fromBlobAsDataUrl = function (blob, callback) {
        var reader = new FileReader();
        reader.onloadend = function () { return callback(reader.result); };
        reader.readAsDataURL(blob);
    };
    Base64Utils.dataUrl = /^data:(.*?)(;(.*?))??(;base64)?,/;
    return Base64Utils;
}());
exports.Base64Utils = Base64Utils;


/***/ }),

/***/ 815:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EmptyBatchUpdatableObject = exports.BatchUpdatableObject = void 0;
var BatchUpdatableObject = (function () {
    function BatchUpdatableObject() {
        this.suspendUpdateCount = 0;
        this.occurredEvents = 0;
    }
    BatchUpdatableObject.prototype.beginUpdate = function () {
        if (this.suspendUpdateCount === 0)
            this.onUpdateLocked();
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount--;
        else
            this.suspendUpdateCount++;
    };
    BatchUpdatableObject.prototype.endUpdate = function () {
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount++;
        else if (this.suspendUpdateCount > 0)
            this.suspendUpdateCount--;
        if (!this.isUpdateLocked()) {
            var occurredEvents = this.occurredEvents;
            this.occurredEvents = 0;
            this.onUpdateUnlocked(occurredEvents);
        }
    };
    BatchUpdatableObject.prototype.suspendUpdate = function () {
        if (this.suspendUpdateCount > 0) {
            this.suspendUpdateCount *= -1;
            var occurredEvents = this.occurredEvents;
            this.occurredEvents = 0;
            this.onUpdateUnlocked(occurredEvents);
        }
    };
    BatchUpdatableObject.prototype.continueUpdate = function () {
        if (this.suspendUpdateCount < 0)
            this.suspendUpdateCount *= -1;
    };
    BatchUpdatableObject.prototype.isUpdateLocked = function () {
        return this.suspendUpdateCount > 0;
    };
    BatchUpdatableObject.prototype.onUpdateLocked = function () { };
    BatchUpdatableObject.prototype.registerOccurredEvent = function (eventMask) {
        this.occurredEvents |= eventMask;
    };
    BatchUpdatableObject.prototype.resetOccurredEvents = function () {
        this.occurredEvents = 0;
    };
    BatchUpdatableObject.prototype.isLocked = function () {
        return this.suspendUpdateCount !== 0;
    };
    return BatchUpdatableObject;
}());
exports.BatchUpdatableObject = BatchUpdatableObject;
var EmptyBatchUpdatableObject = (function () {
    function EmptyBatchUpdatableObject() {
    }
    EmptyBatchUpdatableObject.prototype.beginUpdate = function () { };
    EmptyBatchUpdatableObject.prototype.endUpdate = function () { };
    return EmptyBatchUpdatableObject;
}());
exports.EmptyBatchUpdatableObject = EmptyBatchUpdatableObject;


/***/ }),

/***/ 820:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DiagramLocalizationService = void 0;
var ShapeTypes_1 = __webpack_require__(3255);
var Enums_1 = __webpack_require__(9254);
var DiagramLocalizationService = (function () {
    function DiagramLocalizationService() {
    }
    DiagramLocalizationService.unitItems = {};
    DiagramLocalizationService.formatUnit = function (value) { return value.toString(); };
    DiagramLocalizationService.shapeTexts = {};
    return DiagramLocalizationService;
}());
exports.DiagramLocalizationService = DiagramLocalizationService;
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.In] = "in";
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.Cm] = "cm";
DiagramLocalizationService.unitItems[Enums_1.DiagramUnit.Px] = "px";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Text] = "Text";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Rectangle] = "Rectangle";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Ellipse] = "Ellipse";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Cross] = "Cross";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Triangle] = "Triangle";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Diamond] = "Diamond";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Heart] = "Heart";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Pentagon] = "Pentagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Hexagon] = "Hexagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Octagon] = "Octagon";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Star] = "Star";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowLeft] = "Left Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowUp] = "Up Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowRight] = "Right Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowDown] = "Down Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowUpDown] = "Up Down Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ArrowLeftRight] = "Left Right Arrow";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Process] = "Process";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Decision] = "Decision";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Terminator] = "Terminator";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.PredefinedProcess] = "Predefined Process";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Document] = "Document";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.MultipleDocuments] = "Multiple Documents";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ManualInput] = "Manual Input";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Preparation] = "Preparation";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Data] = "Data";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Database] = "Database";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.HardDisk] = "Hard Disk";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.InternalStorage] = "Internal Storage";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.PaperTape] = "Paper Tape";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.ManualOperation] = "Manual Operation";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Delay] = "Delay";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.StoredData] = "Stored Data";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Display] = "Display";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Merge] = "Merge";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Connector] = "Connector";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Or] = "Or";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.SummingJunction] = "Summing Junction";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Container] = "Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.VerticalContainer] = "Vertical Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.HorizontalContainer] = "Horizontal Container";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.Card] = "Person's Name";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnLeft] = "Card with Image on the Left";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnTop] = "Card with Image on the Top";
DiagramLocalizationService.shapeTexts[ShapeTypes_1.ShapeTypes.CardWithImageOnRight] = "Card with Image on the Right";


/***/ }),

/***/ 868:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerToggleShapeExpandedState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(9589);
var ToggleShapeExpandedHistoryItem_1 = __webpack_require__(946);
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerToggleShapeExpandedState = (function (_super) {
    __extends(MouseHandlerToggleShapeExpandedState, _super);
    function MouseHandlerToggleShapeExpandedState(handler, history, model, selection) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        _this.model = model;
        _this.selection = selection;
        return _this;
    }
    MouseHandlerToggleShapeExpandedState.prototype.onMouseUp = function (evt) {
        var shape = this.model.findShape(evt.source.key);
        if (shape && !shape.isLocked) {
            this.history.beginTransaction();
            this.history.addAndRedo(new ToggleShapeExpandedHistoryItem_1.ToggleShapeExpandedHistoryItem(shape));
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(this.history, this.model, shape);
            ModelUtils_1.ModelUtils.updateContainerConnectorsAttachedPoints(this.history, this.model, shape);
            ModelUtils_1.ModelUtils.updateSelection(this.history, this.selection);
            this.handler.tryUpdateModelSize();
            this.history.endTransaction();
            this.handler.raiseClick([shape.key]);
        }
        this.handler.switchToDefaultState();
    };
    return MouseHandlerToggleShapeExpandedState;
}(MouseHandlerStateBase_1.MouseHandlerStateBase));
exports.MouseHandlerToggleShapeExpandedState = MouseHandlerToggleShapeExpandedState;


/***/ }),

/***/ 871:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleAutoZoomCommand = exports.ToggleAutoZoomToWidthCommand = exports.ToggleAutoZoomToContentCommand = exports.SwitchAutoZoomCommand = exports.FitToWidthCommand = exports.FitToScreenCommand = exports.ChangeZoomLevelItemsCommand = exports.ChangeZoomLevelTo200Command = exports.ChangeZoomLevelTo150Command = exports.ChangeZoomLevelTo125Command = exports.ChangeZoomLevelTo100Command = exports.ChangeZoomLevelTo75Command = exports.ChangeZoomLevelTo50Command = exports.ChangeZoomLevelTo25Command = exports.ChangeZoomLevelInPercentageCommand = exports.ChangeZoomLevelCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(3913);
var Settings_1 = __webpack_require__(9307);
var ChangeZoomLevelCommand = (function (_super) {
    __extends(ChangeZoomLevelCommand, _super);
    function ChangeZoomLevelCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeZoomLevelCommand.prototype.getValue = function () {
        return this.control.view.getZoom();
    };
    ChangeZoomLevelCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.zoomLevel = parameter;
        this.control.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
        this.control.updateLayout(true);
        return true;
    };
    ChangeZoomLevelCommand.prototype.getItems = function () {
        return this.control.settings.zoomLevelItems.map(function (l) {
            return { value: l, text: l * 100 + "%" };
        });
    };
    return ChangeZoomLevelCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeZoomLevelCommand = ChangeZoomLevelCommand;
var ChangeZoomLevelInPercentageCommand = (function (_super) {
    __extends(ChangeZoomLevelInPercentageCommand, _super);
    function ChangeZoomLevelInPercentageCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelInPercentageCommand.prototype.executeCore = function (state, parameter) {
        return _super.prototype.executeCore.call(this, state, parameter / 100);
    };
    ChangeZoomLevelInPercentageCommand.prototype.getValue = function () {
        return this.control.view.getZoom() * 100;
    };
    return ChangeZoomLevelInPercentageCommand;
}(ChangeZoomLevelCommand));
exports.ChangeZoomLevelInPercentageCommand = ChangeZoomLevelInPercentageCommand;
var ChangeZoomLevelExactlyCommand = (function (_super) {
    __extends(ChangeZoomLevelExactlyCommand, _super);
    function ChangeZoomLevelExactlyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelExactlyCommand.prototype.getValue = function () {
        return this.control.view.getZoom() === this.exactValue;
    };
    ChangeZoomLevelExactlyCommand.prototype.executeCore = function (state, parameter) {
        _super.prototype.executeCore.call(this, state, this.exactValue);
        return true;
    };
    ChangeZoomLevelExactlyCommand.prototype.getItems = function () {
        return undefined;
    };
    return ChangeZoomLevelExactlyCommand;
}(ChangeZoomLevelCommand));
var ChangeZoomLevelTo25Command = (function (_super) {
    __extends(ChangeZoomLevelTo25Command, _super);
    function ChangeZoomLevelTo25Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.25;
        return _this;
    }
    return ChangeZoomLevelTo25Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo25Command = ChangeZoomLevelTo25Command;
var ChangeZoomLevelTo50Command = (function (_super) {
    __extends(ChangeZoomLevelTo50Command, _super);
    function ChangeZoomLevelTo50Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.5;
        return _this;
    }
    return ChangeZoomLevelTo50Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo50Command = ChangeZoomLevelTo50Command;
var ChangeZoomLevelTo75Command = (function (_super) {
    __extends(ChangeZoomLevelTo75Command, _super);
    function ChangeZoomLevelTo75Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 0.75;
        return _this;
    }
    return ChangeZoomLevelTo75Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo75Command = ChangeZoomLevelTo75Command;
var ChangeZoomLevelTo100Command = (function (_super) {
    __extends(ChangeZoomLevelTo100Command, _super);
    function ChangeZoomLevelTo100Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1;
        return _this;
    }
    return ChangeZoomLevelTo100Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo100Command = ChangeZoomLevelTo100Command;
var ChangeZoomLevelTo125Command = (function (_super) {
    __extends(ChangeZoomLevelTo125Command, _super);
    function ChangeZoomLevelTo125Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1.25;
        return _this;
    }
    return ChangeZoomLevelTo125Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo125Command = ChangeZoomLevelTo125Command;
var ChangeZoomLevelTo150Command = (function (_super) {
    __extends(ChangeZoomLevelTo150Command, _super);
    function ChangeZoomLevelTo150Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 1.5;
        return _this;
    }
    return ChangeZoomLevelTo150Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo150Command = ChangeZoomLevelTo150Command;
var ChangeZoomLevelTo200Command = (function (_super) {
    __extends(ChangeZoomLevelTo200Command, _super);
    function ChangeZoomLevelTo200Command() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.exactValue = 2;
        return _this;
    }
    return ChangeZoomLevelTo200Command;
}(ChangeZoomLevelExactlyCommand));
exports.ChangeZoomLevelTo200Command = ChangeZoomLevelTo200Command;
var ChangeZoomLevelItemsCommand = (function (_super) {
    __extends(ChangeZoomLevelItemsCommand, _super);
    function ChangeZoomLevelItemsCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeZoomLevelItemsCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ChangeZoomLevelItemsCommand.prototype.getValue = function () {
        return this.control.settings.zoomLevelItems;
    };
    ChangeZoomLevelItemsCommand.prototype.executeCore = function (state, parameter) {
        this.control.settings.zoomLevelItems = parameter;
        return true;
    };
    return ChangeZoomLevelItemsCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeZoomLevelItemsCommand = ChangeZoomLevelItemsCommand;
var FitZoomCommandBase = (function (_super) {
    __extends(FitZoomCommandBase, _super);
    function FitZoomCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitZoomCommandBase.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !!this.control.render;
    };
    FitZoomCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    FitZoomCommandBase.prototype.executeCore = function (state) {
        var zoomLevel = this.getZoomLevel();
        this.control.settings.zoomLevel = zoomLevel;
        this.control.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
        this.control.updateLayout(true);
        return true;
    };
    return FitZoomCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
var FitToScreenCommand = (function (_super) {
    __extends(FitToScreenCommand, _super);
    function FitToScreenCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitToScreenCommand.prototype.getZoomLevel = function () {
        return this.control.render.view.getActualAutoZoomLevel(Settings_1.AutoZoomMode.FitContent);
    };
    return FitToScreenCommand;
}(FitZoomCommandBase));
exports.FitToScreenCommand = FitToScreenCommand;
var FitToWidthCommand = (function (_super) {
    __extends(FitToWidthCommand, _super);
    function FitToWidthCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    FitToWidthCommand.prototype.getZoomLevel = function () {
        return this.control.render.view.getActualAutoZoomLevel(Settings_1.AutoZoomMode.FitToWidth);
    };
    return FitToWidthCommand;
}(FitZoomCommandBase));
exports.FitToWidthCommand = FitToWidthCommand;
var SwitchAutoZoomCommand = (function (_super) {
    __extends(SwitchAutoZoomCommand, _super);
    function SwitchAutoZoomCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SwitchAutoZoomCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    SwitchAutoZoomCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom;
    };
    SwitchAutoZoomCommand.prototype.executeCore = function (state, value) {
        value = parseInt(value);
        if (this.control.settings.autoZoom === value)
            return false;
        if (value === Settings_1.AutoZoomMode.Disabled)
            this.control.settings.zoomLevel = this.control.view.getZoom();
        this.control.settings.autoZoom = value;
        this.control.updateLayout(true);
        return true;
    };
    return SwitchAutoZoomCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SwitchAutoZoomCommand = SwitchAutoZoomCommand;
var ToggleAutoZoomToContentCommand = (function (_super) {
    __extends(ToggleAutoZoomToContentCommand, _super);
    function ToggleAutoZoomToContentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomToContentCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom === Settings_1.AutoZoomMode.FitContent;
    };
    ToggleAutoZoomToContentCommand.prototype.executeCore = function (state, value) {
        return _super.prototype.executeCore.call(this, state, Settings_1.AutoZoomMode.FitContent);
    };
    return ToggleAutoZoomToContentCommand;
}(SwitchAutoZoomCommand));
exports.ToggleAutoZoomToContentCommand = ToggleAutoZoomToContentCommand;
var ToggleAutoZoomToWidthCommand = (function (_super) {
    __extends(ToggleAutoZoomToWidthCommand, _super);
    function ToggleAutoZoomToWidthCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomToWidthCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom === Settings_1.AutoZoomMode.FitToWidth;
    };
    ToggleAutoZoomToWidthCommand.prototype.executeCore = function (state, value) {
        return _super.prototype.executeCore.call(this, state, Settings_1.AutoZoomMode.FitToWidth);
    };
    return ToggleAutoZoomToWidthCommand;
}(SwitchAutoZoomCommand));
exports.ToggleAutoZoomToWidthCommand = ToggleAutoZoomToWidthCommand;
var ToggleAutoZoomCommand = (function (_super) {
    __extends(ToggleAutoZoomCommand, _super);
    function ToggleAutoZoomCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleAutoZoomCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !!this.control.render;
    };
    ToggleAutoZoomCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleAutoZoomCommand.prototype.getValue = function () {
        return this.control.settings.autoZoom;
    };
    ToggleAutoZoomCommand.prototype.executeCore = function (state, value) {
        var newValue;
        if (value === undefined)
            newValue = this.control.settings.autoZoom === Settings_1.AutoZoomMode.Disabled ? Settings_1.AutoZoomMode.FitContent : Settings_1.AutoZoomMode.Disabled;
        else
            newValue = value ? Settings_1.AutoZoomMode.FitContent : Settings_1.AutoZoomMode.Disabled;
        if (this.control.settings.autoZoom === newValue)
            return false;
        if (!newValue)
            this.control.settings.zoomLevel = this.control.view.getZoom();
        this.control.settings.autoZoom = newValue;
        this.control.updateLayout(true);
        return true;
    };
    return ToggleAutoZoomCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleAutoZoomCommand = ToggleAutoZoomCommand;


/***/ }),

/***/ 877:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EditShapeImageCommandBase = void 0;
var ChangeShapeImageHistoryItem_1 = __webpack_require__(472);
var SimpleCommandBase_1 = __webpack_require__(3913);
var EditShapeImageCommandBase = (function (_super) {
    __extends(EditShapeImageCommandBase, _super);
    function EditShapeImageCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    EditShapeImageCommandBase.prototype.isEnabled = function () {
        var selectedShape = this.getSelectedShape();
        return _super.prototype.isEnabled.call(this) && !!selectedShape && !selectedShape.locked && selectedShape.enableImage && selectedShape.allowEditImage;
    };
    EditShapeImageCommandBase.prototype.getValue = function () {
        var selectedShape = this.getSelectedShape();
        var imageUrl = (selectedShape) ? selectedShape.image.exportUrl : undefined;
        return imageUrl;
    };
    EditShapeImageCommandBase.prototype.getSelectedShape = function () {
        var selectedShapes = this.control.selection.getSelectedShapes(true);
        return (selectedShapes.length === 1) ? selectedShapes[0] : undefined;
    };
    EditShapeImageCommandBase.prototype.executeCore = function (state, parameter) {
        this.control.history.beginTransaction();
        var selectedUnlockedShapes = this.control.selection.getSelectedShapes(false);
        this.control.history.addAndRedo(new ChangeShapeImageHistoryItem_1.ChangeShapeImageHistoryItem(selectedUnlockedShapes[0], parameter));
        this.control.history.endTransaction();
        return true;
    };
    return EditShapeImageCommandBase;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.EditShapeImageCommandBase = EditShapeImageCommandBase;


/***/ }),

/***/ 946:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleShapeExpandedHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ToggleShapeExpandedHistoryItem = (function (_super) {
    __extends(ToggleShapeExpandedHistoryItem, _super);
    function ToggleShapeExpandedHistoryItem(shape) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shape.key;
        _this.expanded = shape.expanded;
        return _this;
    }
    ToggleShapeExpandedHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeExpanded(shape, !this.expanded);
    };
    ToggleShapeExpandedHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.changeShapeExpanded(shape, this.expanded);
    };
    return ToggleShapeExpandedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ToggleShapeExpandedHistoryItem = ToggleShapeExpandedHistoryItem;


/***/ }),

/***/ 961:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.numberToStringHex = exports.numberToStringBin = exports.isOdd = exports.isEven = exports.isNonNullString = exports.isString = exports.isNumber = exports.boolToString = exports.boolToInt = exports.isDefined = void 0;
var string_1 = __webpack_require__(4989);
function isDefined(value) {
    return value !== undefined && value !== null;
}
exports.isDefined = isDefined;
function boolToInt(value) {
    return value ? 1 : 0;
}
exports.boolToInt = boolToInt;
function boolToString(value) {
    return value ? '1' : '0';
}
exports.boolToString = boolToString;
function isNumber(obj) {
    return typeof obj === 'number';
}
exports.isNumber = isNumber;
function isString(obj) {
    return typeof obj === 'string';
}
exports.isString = isString;
function isNonNullString(str) {
    return !!str;
}
exports.isNonNullString = isNonNullString;
function isEven(num) {
    return (num % 2) !== 0;
}
exports.isEven = isEven;
function isOdd(num) {
    return (num % 2) === 0;
}
exports.isOdd = isOdd;
function numberToStringBin(num, minLength) {
    if (minLength === void 0) { minLength = 0; }
    return string_1.StringUtils.padLeft(num.toString(2), minLength, '0');
}
exports.numberToStringBin = numberToStringBin;
function numberToStringHex(num, minLength) {
    if (minLength === void 0) { minLength = 0; }
    return string_1.StringUtils.padLeft(num.toString(16), minLength, '0');
}
exports.numberToStringHex = numberToStringHex;


/***/ }),

/***/ 1040:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PermissionsProvider = void 0;
var Shape_1 = __webpack_require__(8408);
var Utils_1 = __webpack_require__(41);
var ModelOperationSettings_1 = __webpack_require__(5225);
var Connector_1 = __webpack_require__(6320);
var AddShape_1 = __webpack_require__(1425);
var DeleteShape_1 = __webpack_require__(3505);
var DeleteConnector_1 = __webpack_require__(1891);
var AddShapeFromToolbox_1 = __webpack_require__(5678);
var ChangeConnection_1 = __webpack_require__(1245);
var ChangeConnectorPoints_1 = __webpack_require__(5261);
var BeforeChangeShapeText_1 = __webpack_require__(3490);
var BeforeChangeConnectorText_1 = __webpack_require__(564);
var ChangeShapeText_1 = __webpack_require__(1675);
var ChangeConnectorText_1 = __webpack_require__(6547);
var PermissionsProviderStorage_1 = __webpack_require__(1387);
var ResizeShape_1 = __webpack_require__(8128);
var MoveShape_1 = __webpack_require__(131);
var PermissionsProvider = (function () {
    function PermissionsProvider(apiController) {
        this.onRequestOperation = new Utils_1.EventDispatcher();
        this.cache = [];
        this.permissionsLockCount = 0;
        this.requestDeleteItems = {};
        this.updateUICount = 0;
        this.apiController = apiController;
        this.operationSettings = new ModelOperationSettings_1.ModelOperationSettings();
        this.storage = new PermissionsProviderStorage_1.PermissionsProviderStorage();
    }
    PermissionsProvider.prototype.notifySelectionChanged = function (_selection) {
        this.clearCache();
    };
    PermissionsProvider.prototype.notifyModelChanged = function (changes) {
        this.clearCache();
    };
    PermissionsProvider.prototype.notifyPageColorChanged = function (color) { };
    PermissionsProvider.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) { };
    PermissionsProvider.prototype.clearCache = function (operation) {
        if (operation !== undefined)
            this.cache = this.cache.filter(function (entry) { return entry.operation !== operation; });
        else
            this.cache = [];
    };
    PermissionsProvider.prototype.canDeleteItems = function (items) {
        var _this = this;
        var allowed = true;
        items.forEach(function (item) {
            var entity;
            if (item instanceof Shape_1.Shape)
                entity = new DeleteShape_1.DeleteShapeRequestedEntity(_this.apiController, item);
            if (item instanceof Connector_1.Connector)
                entity = new DeleteConnector_1.DeleteConnectorRequestedEntity(_this.apiController, item);
            allowed = allowed && _this.requestOperation(entity);
        });
        return allowed;
    };
    PermissionsProvider.prototype.canAddItems = function (items) {
        var _this = this;
        var allowed = true;
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                allowed = allowed && _this.requestOperation(new AddShape_1.AddShapeRequestedEntity(_this.apiController, item));
            if (item instanceof Connector_1.Connector) {
                allowed = allowed && _this.canChangeConnection(item, item.beginItem, undefined, Connector_1.ConnectorPosition.Begin, item.beginConnectionPointIndex);
                allowed = allowed && _this.canChangeConnection(item, item.endItem, undefined, Connector_1.ConnectorPosition.End, item.endConnectionPointIndex);
            }
        });
        return allowed;
    };
    PermissionsProvider.prototype.canAddShapeFromToolbox = function (itemType) {
        return this.requestOperation(new AddShapeFromToolbox_1.AddShapeFromToolboxRequestedEntity(this.apiController, itemType));
    };
    PermissionsProvider.prototype.canChangeConnection = function (connector, item, oldItem, position, connectionPointIndex) {
        if (connector && this.requestDeleteItems[connector.key])
            return true;
        if (item === undefined || item === null || item instanceof Shape_1.Shape)
            return this.requestOperation(new ChangeConnection_1.ChangeConnectionRequestedEntity(this.apiController, connector, item, oldItem, position, connectionPointIndex));
        return true;
    };
    PermissionsProvider.prototype.canChangeConnectorPoints = function (connector, oldPoints, points) {
        if (connector && this.requestDeleteItems[connector.key])
            return true;
        return this.requestOperation(new ChangeConnectorPoints_1.ChangeConnectorPointsRequestedEntity(this.apiController, connector, oldPoints, points));
    };
    PermissionsProvider.prototype.canChangeShapeText = function (shape) {
        return this.requestOperation(new BeforeChangeShapeText_1.BeforeChangeShapeTextRequestedEntity(this.apiController, shape));
    };
    PermissionsProvider.prototype.canChangeConnectorText = function (connector, position) {
        return this.requestOperation(new BeforeChangeConnectorText_1.BeforeChangeConnectorTextRequestedEntity(this.apiController, connector, position));
    };
    PermissionsProvider.prototype.canApplyShapeTextChange = function (shape, textToApply) {
        return this.requestOperation(new ChangeShapeText_1.ChangeShapeTextRequestedEntity(this.apiController, shape, textToApply));
    };
    PermissionsProvider.prototype.canApplyConnectorTextChange = function (connector, position, textToApply) {
        return this.requestOperation(new ChangeConnectorText_1.ChangeConnectorTextRequestedEntity(this.apiController, connector, position, textToApply));
    };
    PermissionsProvider.prototype.canResizeShapes = function (shapeInfo) {
        var _this = this;
        var allowed = true;
        shapeInfo.forEach(function (info) {
            allowed = allowed && _this.requestOperation(new ResizeShape_1.ResizeShapeRequestedEntity(_this.apiController, info.shape, info.oldSize, info.size));
        });
        return allowed;
    };
    PermissionsProvider.prototype.canMoveShapes = function (shapeInfo) {
        var _this = this;
        var allowed = true;
        shapeInfo.forEach(function (info) {
            allowed = allowed && _this.requestOperation(new MoveShape_1.MoveShapeRequestedEntity(_this.apiController, info.shape, info.oldPosition, info.position));
        });
        return allowed;
    };
    PermissionsProvider.prototype.requestOperation = function (entity) {
        var allowed = true;
        if (!this.permissionsLockCount) {
            var cachedEntity_1;
            if (this.updateUICount > 0)
                this.cache.forEach(function (item) {
                    if (item.equals(entity)) {
                        cachedEntity_1 = item;
                        return;
                    }
                });
            if (cachedEntity_1)
                allowed = cachedEntity_1.allowed;
            else {
                this.requestOperationCore(entity);
                if (this.updateUICount > 0)
                    this.cache.push(entity);
                allowed = entity.allowed;
            }
            if (this.updateUICount === 0 && this.storage.needStorePermissions()) {
                this.storage.storePermission(entity.storageKey, allowed);
                return this.storage.isStoredPermissionsGranted();
            }
        }
        return allowed;
    };
    PermissionsProvider.prototype.requestOperationCore = function (entity) {
        entity.eventArgs.allowed = this.operationSettings[entity.settingsKey];
        entity.eventArgs.updateUI = this.updateUICount > 0;
        if (entity.allowed)
            this.onRequestOperation.raise("notifyRequestOperation", entity.operation, entity.eventArgs);
    };
    PermissionsProvider.prototype.lockPermissions = function () {
        this.permissionsLockCount++;
    };
    PermissionsProvider.prototype.unlockPermissions = function () {
        this.permissionsLockCount--;
    };
    PermissionsProvider.prototype.beginDeleteItems = function (items) {
        var _this = this;
        items.forEach(function (item) { return _this.requestDeleteItems[item.key] = item; });
    };
    PermissionsProvider.prototype.endDeleteItems = function () {
        this.requestDeleteItems = {};
    };
    PermissionsProvider.prototype.beginUpdateUI = function () {
        this.updateUICount++;
    };
    PermissionsProvider.prototype.endUpdateUI = function () {
        this.updateUICount--;
    };
    PermissionsProvider.prototype.addInteractingItem = function (item, operation) {
        this.storage.addInteractingItem(item, operation);
    };
    PermissionsProvider.prototype.getInteractingItem = function (item, operation) {
        return this.storage.getInteractingItem(item, operation);
    };
    PermissionsProvider.prototype.getInteractingItemCount = function () {
        return this.storage.getInteractingItemCount();
    };
    PermissionsProvider.prototype.clearInteractingItems = function () {
        this.storage.clearInteractingItems();
    };
    PermissionsProvider.prototype.beginStorePermissions = function () {
        this.storage.beginStorePermissions();
    };
    PermissionsProvider.prototype.endStorePermissions = function () {
        this.storage.endStorePermissions();
    };
    PermissionsProvider.prototype.isStoredPermissionsGranted = function () {
        return this.permissionsLockCount > 0 || this.storage.isStoredPermissionsGranted();
    };
    return PermissionsProvider;
}());
exports.PermissionsProvider = PermissionsProvider;


/***/ }),

/***/ 1065:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TouchUtils = void 0;
var browser_1 = __webpack_require__(8424);
var common_1 = __webpack_require__(961);
var TouchUtils = (function () {
    function TouchUtils() {
    }
    TouchUtils.onEventAttachingToDocument = function (eventName, func) {
        if (browser_1.Browser.MacOSMobilePlatform && TouchUtils.isTouchEventName(eventName)) {
            if (!TouchUtils.documentTouchHandlers[eventName])
                TouchUtils.documentTouchHandlers[eventName] = [];
            TouchUtils.documentTouchHandlers[eventName].push(func);
            return TouchUtils.documentEventAttachingAllowed;
        }
        return true;
    };
    TouchUtils.isTouchEventName = function (eventName) {
        return browser_1.Browser.WebKitTouchUI && (eventName.indexOf('touch') > -1 || eventName.indexOf('gesture') > -1);
    };
    TouchUtils.isTouchEvent = function (evt) {
        return browser_1.Browser.WebKitTouchUI && common_1.isDefined(evt.changedTouches);
    };
    TouchUtils.getEventX = function (evt) {
        return browser_1.Browser.IE ? evt.pageX : evt.changedTouches[0].pageX;
    };
    TouchUtils.getEventY = function (evt) {
        return browser_1.Browser.IE ? evt.pageY : evt.changedTouches[0].pageY;
    };
    TouchUtils.touchMouseDownEventName = browser_1.Browser.WebKitTouchUI ? 'touchstart' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointerdown' : 'mousedown');
    TouchUtils.touchMouseUpEventName = browser_1.Browser.WebKitTouchUI ? 'touchend' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointerup' : 'mouseup');
    TouchUtils.touchMouseMoveEventName = browser_1.Browser.WebKitTouchUI ? 'touchmove' : (browser_1.Browser.Edge && browser_1.Browser.MSTouchUI && window.PointerEvent ? 'pointermove' : 'mousemove');
    TouchUtils.msTouchDraggableClassName = 'dxMSTouchDraggable';
    TouchUtils.documentTouchHandlers = {};
    TouchUtils.documentEventAttachingAllowed = true;
    return TouchUtils;
}());
exports.TouchUtils = TouchUtils;


/***/ }),

/***/ 1114:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CycleRemover = void 0;
var Graph_1 = __webpack_require__(9071);
var Structures_1 = __webpack_require__(8573);
var ListUtils_1 = __webpack_require__(6961);
var CycleRemover = (function () {
    function CycleRemover() {
    }
    CycleRemover.removeCycles = function (graph) {
        var feedbackSet = this.getFeedbackSet(graph);
        return this.reverseEdges(graph, feedbackSet);
    };
    CycleRemover.getFeedbackSet = function (graph) {
        var _this = this;
        var feedbackSet = {};
        var nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(graph);
        while (nonTrivialStronglyConnectedComponents.length) {
            nonTrivialStronglyConnectedComponents.forEach(function (g) {
                var maxCyclicEdges = _this.getMaxCyclicEdges(g);
                maxCyclicEdges.forEach(function (e) { return delete feedbackSet[e.reverse().getHashKey()]; });
                maxCyclicEdges.forEach(function (e) { return feedbackSet[e.getHashKey()] = true; });
            });
            nonTrivialStronglyConnectedComponents = this.getNonTrivialStronglyConnectedComponents(this.reverseEdges(graph, feedbackSet).graph);
        }
        return feedbackSet;
    };
    CycleRemover.getMaxCyclicEdges = function (graph) {
        var black = {};
        var gray = {};
        var edgeCycleCount = {};
        var visitedEdges = [];
        var cycles = [];
        var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            gray[n.key] = true;
        };
        iterator.skipNode = function (n) {
            if (gray[n.key]) {
                var cycle = [];
                for (var i = 0; i < visitedEdges.length; i++) {
                    var e = visitedEdges[i];
                    if (edgeCycleCount[e.key] === undefined)
                        edgeCycleCount[e.key] = 0;
                    edgeCycleCount[e.key]++;
                    cycle.push(e);
                    if (e.from === n.key)
                        break;
                }
                cycles.push(cycle);
            }
            return gray[n.key] || black[n.key];
        };
        iterator.skipEdge = function (e) { return false; };
        iterator.onEdge = function (e) {
            visitedEdges.splice(0, 0, e);
        };
        iterator.onAfterEdge = function (e) {
            visitedEdges.splice(0, 1);
        };
        iterator.onAllEdges = function (e) {
            black[e.key] = true;
            gray[e.key] = false;
        };
        iterator.iterate(graph.nodes[0]);
        var edgeSet = new ListUtils_1.HashSet([], function (e) { return e.key; });
        cycles.forEach(function (c) {
            edgeSet.tryPush(c.reduce(function (max, curr) { return edgeCycleCount[curr.key] > edgeCycleCount[max.key] ? curr : max; }, c[0]));
        });
        return edgeSet.list();
    };
    CycleRemover.reverseEdges = function (graph, feedbackSet) {
        var edges = new ListUtils_1.HashSet([], function (e) { return e.getHashKey(); });
        var reversedEdges = {};
        var removedEdges = {};
        graph.edges.forEach(function (e) {
            if (feedbackSet[e.getHashKey()]) {
                e = e.reverse();
                reversedEdges[e.key] = true;
            }
            if (!edges.tryPush(e)) {
                removedEdges[e.key] = true;
                delete reversedEdges[e.key];
            }
        });
        return {
            graph: new Graph_1.Graph(graph.nodes.map(function (n) { return graph.getNode(n); }), edges.list()),
            reversedEdges: reversedEdges,
            removedEdges: removedEdges
        };
    };
    CycleRemover.getNonTrivialStronglyConnectedComponents = function (graph) {
        return this.getStronglyConnectedComponents(graph).filter(function (g) { return g.edges.length; });
    };
    CycleRemover.getStronglyConnectedComponents = function (graph) {
        var _this = this;
        var nodesStack = [];
        var index = 0;
        var lowIndex = {};
        var lowLink = {};
        var onStack = {};
        var components = [];
        var visitedNodes = {};
        for (var i = 0; i < graph.nodes.length; i++) {
            var nodeKey = graph.nodes[i];
            var iterator = graph.createIterator(Structures_1.ConnectionMode.Outgoing);
            iterator.visitEachEdgeOnce = false;
            iterator.visitEachNodeOnce = false;
            iterator.onNode = function (n) {
                visitedNodes[n.key] = true;
                nodesStack.push(n);
                onStack[n.key] = true;
                lowLink[n.key] = index;
                lowIndex[n.key] = index;
                index++;
            };
            iterator.skipNode = function (n) { return visitedNodes[n.key]; };
            iterator.skipEdge = function (e) {
                var isVisited = visitedNodes[e.to];
                if (isVisited && onStack[e.to])
                    lowLink[e.from] = Math.min(lowLink[e.from], lowIndex[e.to]);
                return isVisited;
            };
            iterator.onAfterEdge = function (e) {
                lowLink[e.from] = Math.min(lowLink[e.from], lowLink[e.to]);
            };
            iterator.onAllEdges = function (n, outgoing) {
                if (outgoing && lowLink[n.key] === lowIndex[n.key])
                    components.push(_this.getStronglyConnectedComponent(graph, n, nodesStack, onStack));
            };
            iterator.iterate(nodeKey);
        }
        return components;
    };
    CycleRemover.getStronglyConnectedComponent = function (graph, root, nodesStack, onStack) {
        var itemsMap = {};
        var nodes = [];
        var edges = [];
        var topStackNode;
        do {
            topStackNode = nodesStack.pop();
            if (!itemsMap[topStackNode.key])
                nodes.push(topStackNode);
            itemsMap[topStackNode.key] = true;
            onStack[topStackNode.key] = false;
        } while (topStackNode !== root);
        nodes.forEach(function (n) {
            var aEdges = graph.getAdjacentEdges(n.key, Structures_1.ConnectionMode.Outgoing);
            edges = edges.concat(aEdges.filter(function (e) { return !itemsMap[e.key] && itemsMap[e.to]; }));
            aEdges.forEach(function (e) { return itemsMap[e.key] = true; });
        });
        return new Graph_1.Graph(nodes, edges);
    };
    return CycleRemover;
}());
exports.CycleRemover = CycleRemover;


/***/ }),

/***/ 1118:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextFloodFilterPrimitive = exports.TextFilterPrimitive = void 0;
var RenderHelper_1 = __webpack_require__(8509);
var FilterPrimitive_1 = __webpack_require__(9707);
var Model_1 = __webpack_require__(455);
var color_1 = __webpack_require__(9553);
var TextFilterPrimitive = (function (_super) {
    __extends(TextFilterPrimitive, _super);
    function TextFilterPrimitive(id, x, y, width, height) {
        if (x === void 0) { x = "-0.05"; }
        if (y === void 0) { y = "-0.05"; }
        if (width === void 0) { width = "1.1"; }
        if (height === void 0) { height = "1.1"; }
        var _this = _super.call(this, id, x, y, width, height) || this;
        _this.id = id;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    TextFilterPrimitive.prototype.createChildElements = function (parent) {
        var feFlood = document.createElementNS(RenderHelper_1.svgNS, "feFlood");
        parent.appendChild(feFlood);
        var feComposite = document.createElementNS(RenderHelper_1.svgNS, "feComposite");
        feComposite.setAttribute("in", "SourceGraphic");
        feComposite.setAttribute("operator", "atop");
        parent.appendChild(feComposite);
    };
    return TextFilterPrimitive;
}(FilterPrimitive_1.FilterPrimitive));
exports.TextFilterPrimitive = TextFilterPrimitive;
var TextFloodFilterPrimitive = (function (_super) {
    __extends(TextFloodFilterPrimitive, _super);
    function TextFloodFilterPrimitive(id, floodColor, x, y, width, height) {
        if (x === void 0) { x = "-0.05"; }
        if (y === void 0) { y = "-0.05"; }
        if (width === void 0) { width = "1.1"; }
        if (height === void 0) { height = "1.1"; }
        var _this = _super.call(this, id, x, y, width, height) || this;
        _this.id = id;
        _this.floodColor = floodColor;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        return _this;
    }
    TextFloodFilterPrimitive.prototype.applyChildrenProperties = function (element) {
        for (var child = void 0, i = 0; child = element.childNodes[i]; i++)
            if (child.nodeName && child.nodeName.toUpperCase() === "FEFLOOD") {
                this.prepareFEFloodNode(child);
                break;
            }
    };
    TextFloodFilterPrimitive.prototype.prepareFEFloodNode = function (node) {
        var colorHash = color_1.ColorUtils.colorToHash(this.floodColor);
        node.setAttribute("flood-color", colorHash);
        node.setAttribute("class", "text-filter-flood");
        if (this.floodColor !== Model_1.DiagramModel.defaultPageColor)
            node.style.setProperty("flood-color", colorHash);
        else
            node.style.setProperty("flood-color", "");
    };
    return TextFloodFilterPrimitive;
}(TextFilterPrimitive));
exports.TextFloodFilterPrimitive = TextFloodFilterPrimitive;


/***/ }),

/***/ 1188:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AStarCalculator = void 0;
var AStarCalculator = (function () {
    function AStarCalculator() {
    }
    AStarCalculator.calculate = function (context) {
        if (context) {
            var callBack = this.start(context);
            while (callBack)
                callBack = callBack(context);
        }
    };
    AStarCalculator.start = function (context) {
        context.start();
        return context.shouldStartContinue ? AStarCalculator.startContinue : AStarCalculator.finishWithPath;
    };
    AStarCalculator.startContinue = function (context) {
        context.startContinue();
        return context.shouldFinish ? AStarCalculator.finishWithPath : AStarCalculator.endContinue;
    };
    AStarCalculator.endContinue = function (context) {
        context.endContinue();
        return context.shouldStartContinue ? AStarCalculator.startContinue : AStarCalculator.finishWithoutPath;
    };
    AStarCalculator.finishWithPath = function (context) {
        context.finishWithPath();
    };
    AStarCalculator.finishWithoutPath = function (context) {
        context.finishWithoutPath();
    };
    return AStarCalculator;
}());
exports.AStarCalculator = AStarCalculator;


/***/ }),

/***/ 1245:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectionEventArgs = exports.ChangeConnectionRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var ChangeConnectionRequestedEntity = (function (_super) {
    __extends(ChangeConnectionRequestedEntity, _super);
    function ChangeConnectionRequestedEntity(apiController, connector, shape, oldShape, position, connectionPointIndex) {
        var _this = _super.call(this, apiController) || this;
        _this.connector = connector;
        _this.shape = shape;
        _this.oldShape = oldShape;
        _this.position = position;
        _this.connectionPointIndex = connectionPointIndex;
        return _this;
    }
    Object.defineProperty(ChangeConnectionRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.ChangeConnection;
        },
        enumerable: false,
        configurable: true
    });
    ChangeConnectionRequestedEntity.prototype.createEventArgs = function () {
        return new ChangeConnectionEventArgs(this.apiController.createNativeConnector(this.connector), this.apiController.createNativeShape(this.shape), this.apiController.createNativeShape(this.oldShape), this.position, this.connectionPointIndex);
    };
    Object.defineProperty(ChangeConnectionRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "changeConnection";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChangeConnectionRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.connector && this.connector.key) + "_" + this.position;
        },
        enumerable: false,
        configurable: true
    });
    ChangeConnectionRequestedEntity.prototype.equals = function (other) {
        if (other instanceof ChangeConnectionRequestedEntity) {
            var connectorsAreEqual = (!this.connector && !other.connector) || (this.connector && other.connector && this.connector === other.connector);
            var shapesAreEqual = (!this.shape && !other.shape) || (this.shape && other.shape && this.shape === other.shape);
            var oldShapesAreEqual = (!this.oldShape && !other.oldShape) || (this.oldShape && other.oldShape && this.oldShape === other.oldShape);
            return shapesAreEqual && oldShapesAreEqual && connectorsAreEqual && this.position === other.position && this.connectionPointIndex === other.connectionPointIndex;
        }
        return false;
    };
    return ChangeConnectionRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.ChangeConnectionRequestedEntity = ChangeConnectionRequestedEntity;
var ChangeConnectionEventArgs = (function (_super) {
    __extends(ChangeConnectionEventArgs, _super);
    function ChangeConnectionEventArgs(connector, shape, oldShape, position, connectionPointIndex) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        _this.shape = shape;
        _this.oldShape = oldShape;
        _this.position = position;
        _this.connectionPointIndex = connectionPointIndex;
        return _this;
    }
    return ChangeConnectionEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.ChangeConnectionEventArgs = ChangeConnectionEventArgs;


/***/ }),

/***/ 1280:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShapeDescription = exports.ShapeTextPadding = exports.ShapeDefaultSize = exports.ShapeMinDimension = exports.ShapeDefaultDimension = void 0;
var unit_converter_1 = __webpack_require__(9500);
var size_1 = __webpack_require__(3844);
var LocalizationService_1 = __webpack_require__(820);
var ITextMeasurer_1 = __webpack_require__(5650);
var RectaglePrimitive_1 = __webpack_require__(94);
var TextPrimitive_1 = __webpack_require__(128);
var Utils_1 = __webpack_require__(41);
var ConnectionPoint_1 = __webpack_require__(4856);
var DiagramItem_1 = __webpack_require__(4824);
exports.ShapeDefaultDimension = 1440;
exports.ShapeMinDimension = 360;
exports.ShapeDefaultSize = new size_1.Size(exports.ShapeDefaultDimension, exports.ShapeDefaultDimension);
exports.ShapeTextPadding = unit_converter_1.UnitConverter.pixelsToTwips(10);
var ShapeDescription = (function () {
    function ShapeDescription(defaultSize, hasDefaultText) {
        if (defaultSize === void 0) { defaultSize = exports.ShapeDefaultSize.clone(); }
        this.defaultSize = defaultSize;
        this.hasDefaultText = hasDefaultText;
        this.onChanged = new Utils_1.EventDispatcher();
        this.connectionPoints = this.createConnectionPoints();
    }
    Object.defineProperty(ShapeDescription.prototype, "enableText", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "allowEditText", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "enableImage", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "allowEditImage", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "hasTemplate", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "enableChildren", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "minWidth", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "minHeight", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "maxWidth", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "maxHeight", {
        get: function () { return undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ShapeDescription.prototype, "toolboxSize", {
        get: function () { return this.defaultSize; },
        enumerable: false,
        configurable: true
    });
    ShapeDescription.prototype.getTitle = function () {
        return LocalizationService_1.DiagramLocalizationService.shapeTexts[this.key];
    };
    ShapeDescription.prototype.getDefaultText = function () {
        return this.hasDefaultText ? LocalizationService_1.DiagramLocalizationService.shapeTexts[this.key] : "";
    };
    ShapeDescription.prototype.getDefaultImageUrl = function () {
        return "";
    };
    ShapeDescription.prototype.getConnectionPoints = function () {
        return this.connectionPoints;
    };
    ShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(1, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    ShapeDescription.prototype.processConnectionPoint = function (shape, point) {
    };
    ShapeDescription.prototype.getConnectionPointIndexForItem = function (item, connectionPointIndex) {
        return connectionPointIndex;
    };
    ShapeDescription.prototype.getConnectionPointIndexForSide = function (side) {
        return side;
    };
    ShapeDescription.getConnectionPointSideByGeometry = function (point) {
        if (point.x >= point.y && (point.x > 0 || point.y > 0)) {
            if (point.x < 0.5 || (1 - point.x) >= point.y)
                return DiagramItem_1.ConnectionPointSide.North;
            return DiagramItem_1.ConnectionPointSide.East;
        }
        else {
            if (point.x > 0.5 || (1 - point.x) <= point.y)
                return DiagramItem_1.ConnectionPointSide.South;
            return DiagramItem_1.ConnectionPointSide.West;
        }
    };
    ShapeDescription.prototype.createParameters = function (parameters) {
    };
    ShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
    };
    ShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        throw Error("Not implemented");
    };
    ShapeDescription.prototype.changeParameterValue = function (parameters, key, change) {
        var p = parameters.get(key);
        p.value = change(p);
    };
    ShapeDescription.prototype.getParameterPoints = function (shape) {
        return [];
    };
    ShapeDescription.prototype.getExpandedSize = function (shape) {
        return shape.size;
    };
    ShapeDescription.prototype.getCollapsedSize = function (shape) {
        return shape.size;
    };
    ShapeDescription.prototype.getToolboxHeightToWidthRatio = function (width, height) {
        return height / width;
    };
    ShapeDescription.prototype.allowResizeHorizontally = function (_shape) {
        return true;
    };
    ShapeDescription.prototype.allowResizeVertically = function (_shape) {
        return true;
    };
    ShapeDescription.prototype.createPrimitives = function (shape, instanceId, forToolbox) {
        var primitives = [];
        primitives = primitives.concat(this.createShapePrimitives(shape, forToolbox));
        if (this.enableImage)
            primitives = primitives.concat(this.createImagePrimitives(shape, forToolbox));
        if (this.enableText)
            primitives = primitives.concat(this.createTextPrimitives(shape, forToolbox));
        return primitives;
    };
    ShapeDescription.prototype.createImagePrimitives = function (_shape, _forToolbox) {
        return [];
    };
    ShapeDescription.prototype.createTextPrimitives = function (shape, forToolbox) {
        if (shape.text === undefined || shape.text === "")
            return [];
        var rect = this.getTextRectangle(shape);
        return [
            new TextPrimitive_1.TextPrimitive(rect.x, rect.y, shape.text, ITextMeasurer_1.TextOwner.Shape, rect.width, rect.height, ShapeDescription.textSpacing, shape.styleText, false, this.getTextClipPathId(forToolbox), undefined, this.getTextAngle())
        ];
    };
    ShapeDescription.prototype.getTextClipPathId = function (_forToolbox) {
        return undefined;
    };
    ShapeDescription.prototype.getTextAngle = function () {
        return TextPrimitive_1.TextAngle.Angle0deg;
    };
    ShapeDescription.prototype.getClientRectangle = function (shape) {
        return shape.rectangle;
    };
    ShapeDescription.prototype.getTextEditRectangle = function (shape) {
        return this.getTextRectangle(shape);
    };
    ShapeDescription.prototype.createSelectorPrimitives = function (shape) {
        return [
            new RectaglePrimitive_1.RectanglePrimitive(shape.position.x, shape.position.y, shape.size.width, shape.size.height, null, "selector")
        ];
    };
    ShapeDescription.prototype.raiseShapeDescriptionChanged = function (description) {
        this.onChanged.raise1(function (l) { return l.notifyShapeDescriptionChanged(description); });
    };
    ShapeDescription.textSpacing = unit_converter_1.UnitConverter.pixelsToTwips(2);
    return ShapeDescription;
}());
exports.ShapeDescription = ShapeDescription;


/***/ }),

/***/ 1311:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ClipboardCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(3913);
var ClipboardCommand = (function (_super) {
    __extends(ClipboardCommand, _super);
    function ClipboardCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ClipboardCommand.prototype.setClipboardData = function (data) {
        if (this.control.render)
            this.control.render.input.setClipboardData(data);
        ClipboardCommand.clipboardData = data;
    };
    ClipboardCommand.prototype.getClipboardData = function (callback) {
        if (this.control.render && this.isPasteSupportedByBrowser())
            this.control.render.input.getClipboardData(callback);
        else
            callback(ClipboardCommand.clipboardData);
    };
    ClipboardCommand.prototype.isPasteSupportedByBrowser = function () {
        return this.control.render && this.control.render.input.isPasteSupportedByBrowser();
    };
    return ClipboardCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ClipboardCommand = ClipboardCommand;


/***/ }),

/***/ 1377:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CanvasViewManager = exports.CROP_OFFSET = exports.CANVAS_SCROLL_PADDING = exports.CANVAS_MIN_PADDING = void 0;
var CanvasManagerBase_1 = __webpack_require__(5707);
var Settings_1 = __webpack_require__(9307);
var Utils_1 = __webpack_require__(41);
var offsets_1 = __webpack_require__(8601);
var size_1 = __webpack_require__(3844);
var point_1 = __webpack_require__(5327);
var GroupPrimitive_1 = __webpack_require__(6709);
var ClipPathPrimitive_1 = __webpack_require__(5654);
var RectaglePrimitive_1 = __webpack_require__(94);
var Utils_2 = __webpack_require__(2136);
var ShadowFilterPrimitive_1 = __webpack_require__(9299);
var Style_1 = __webpack_require__(5059);
var dom_1 = __webpack_require__(750);
var unit_converter_1 = __webpack_require__(9500);
exports.CANVAS_MIN_PADDING = 8;
exports.CANVAS_SCROLL_PADDING = 18;
exports.CROP_OFFSET = 40;
var DRAG_SCROLL_CSSCLASS = "dxdi-drag-scroll";
var DRAG_ITEM_CSSCLASS = "dxdi-drag-item";
var CanvasViewManager = (function (_super) {
    __extends(CanvasViewManager, _super);
    function CanvasViewManager(scrollView, svgElement, modelSize, fixedZoomLevel, autoZoom, simpleView, rectangle, dom, instanceId) {
        var _this = _super.call(this, fixedZoomLevel, dom, instanceId) || this;
        _this.svgElement = svgElement;
        _this.paddings = new offsets_1.Offsets(0, 0, 0, 0);
        _this.scroll = new point_1.Point(0, 0);
        _this.crop = offsets_1.Offsets.empty();
        _this.lockAutoZoom = false;
        _this.autoScrollLocker = 0;
        _this.pageClipPathId = Utils_2.RenderUtils.generateSvgElementId("page-clip");
        _this.pageShadowId = Utils_2.RenderUtils.generateSvgElementId("page-shadow");
        _this.onViewChanged = new Utils_1.EventDispatcher();
        scrollView.onScroll.add(_this);
        modelSize = modelSize.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF);
        _this.scrollView = scrollView;
        _this.modelSize = modelSize;
        _this.simpleView = simpleView;
        _this.fixedZoomLevel = fixedZoomLevel;
        _this.autoZoom = autoZoom;
        _this.crop = _this.rectangleToCrop(rectangle, modelSize);
        _this.updateElements(modelSize.clone().multiply(fixedZoomLevel, fixedZoomLevel), point_1.Point.zero(), simpleView);
        _this.getOrCreateElement("shadow", new ShadowFilterPrimitive_1.ShadowFilterPrimitive(_this.pageShadowId), _this.svgElement);
        _this.containerSize = scrollView.getSize();
        return _this;
    }
    CanvasViewManager.prototype.adjust = function (resetPaddings, saveVerticalScroll) {
        var offset;
        if (!resetPaddings) {
            resetPaddings = { vertical: false, horizontal: false };
            offset = offsets_1.Offsets.empty();
        }
        this.containerSize = this.scrollView.getSize();
        this.adjustCore(this.modelSize, this.fixedZoomLevel, this.autoZoom, this.simpleView, this.crop, resetPaddings, this.containerSize, offset, saveVerticalScroll);
        this.tryNormalizePaddings();
    };
    CanvasViewManager.prototype.notifyModelSizeChanged = function (size, offset) {
        size = size.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF);
        var resetPaddings = { horizontal: !offset, vertical: !offset };
        this.adjustCore(size, this.fixedZoomLevel, this.autoZoom, this.simpleView, this.crop, resetPaddings, this.containerSize, offset && offset.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF));
        this.modelSize = size;
    };
    CanvasViewManager.prototype.notifyModelRectangleChanged = function (rectangle) {
        var crop = this.rectangleToCrop(rectangle, this.modelSize);
        if (!this.crop || !this.crop.equals(crop)) {
            if (this.simpleView)
                this.adjustCore(this.modelSize, this.fixedZoomLevel, this.autoZoom, this.simpleView, crop, { horizontal: false, vertical: false }, this.containerSize, offsets_1.Offsets.empty());
            this.crop = crop;
        }
    };
    CanvasViewManager.prototype.notifySnapPointPositionChanged = function (point) { };
    CanvasViewManager.prototype.notifyZoomChanged = function (fixedZoomLevel, autoZoom) {
        this.adjustCore(this.modelSize, fixedZoomLevel, autoZoom, this.simpleView, this.crop, {
            horizontal: false,
            vertical: false
        }, this.containerSize);
        this.fixedZoomLevel = fixedZoomLevel;
        this.autoZoom = autoZoom;
    };
    CanvasViewManager.prototype.notifyViewChanged = function (simpleView) {
        this.adjustCore(this.modelSize, this.fixedZoomLevel, this.autoZoom, simpleView, this.crop, { vertical: true, horizontal: true }, this.containerSize);
        this.simpleView = simpleView;
    };
    CanvasViewManager.prototype.notifyGridChanged = function (showGrid, gridSize) { };
    CanvasViewManager.prototype.notifyDragStart = function (itemKeys) {
        this.lockAutoZoom = true;
        dom_1.DomUtils.addClassName(this.svgElement, DRAG_ITEM_CSSCLASS);
    };
    CanvasViewManager.prototype.notifyDragEnd = function (itemKeys) {
        this.lockAutoZoom = false;
        dom_1.DomUtils.removeClassName(this.svgElement, DRAG_ITEM_CSSCLASS);
        this.adjustAfterDragEnd();
    };
    CanvasViewManager.prototype.adjustAfterDragEnd = function () {
        if (this.autoZoom && !this.autoZoomLocked)
            this.adjust({ horizontal: true, vertical: this.autoZoom === Settings_1.AutoZoomMode.FitContent }, this.autoZoom === Settings_1.AutoZoomMode.FitToWidth);
    };
    CanvasViewManager.prototype.notifyShowContextToolbox = function () {
        this.autoZoomLocked = true;
    };
    CanvasViewManager.prototype.notifyHideContextToolbox = function () {
        this.autoZoomLocked = false;
        this.adjustAfterDragEnd();
    };
    CanvasViewManager.prototype.notifyDragScrollStart = function () {
        dom_1.DomUtils.addClassName(this.svgElement, DRAG_SCROLL_CSSCLASS);
    };
    CanvasViewManager.prototype.notifyDragScrollEnd = function () {
        dom_1.DomUtils.removeClassName(this.svgElement, DRAG_SCROLL_CSSCLASS);
    };
    CanvasViewManager.prototype.notifyScrollChanged = function (getScroll) {
        this.scroll = getScroll();
    };
    CanvasViewManager.prototype.checkFitToCanvas = function (containerSize) {
        containerSize = containerSize || this.containerSize;
        var scrollSize = this.scrollView.getScrollBarWidth();
        containerSize = containerSize.clone().offset(-exports.CANVAS_MIN_PADDING * 2, -exports.CANVAS_MIN_PADDING * 2).nonNegativeSize();
        var modelAbsSize = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop).clone().multiply(this.actualZoom, this.actualZoom);
        var scrollbars = this.checkScrollBars(containerSize, scrollSize, modelAbsSize, offsets_1.Offsets.empty());
        containerSize = containerSize.clone().offset(scrollbars.vertical ? -scrollSize : 0, scrollbars.horizontal ? -scrollSize : 0).nonNegativeSize();
        return {
            vertical: containerSize.height >= modelAbsSize.height,
            horizontal: containerSize.width >= modelAbsSize.width
        };
    };
    CanvasViewManager.prototype.rectangleToCrop = function (rectangle, modelSize) {
        var absRectangle = rectangle.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF);
        return new offsets_1.Offsets(this.correctCrop(absRectangle.x), this.correctCrop(modelSize.width - absRectangle.right), this.correctCrop(absRectangle.y), this.correctCrop(modelSize.height - absRectangle.bottom));
    };
    CanvasViewManager.prototype.correctCrop = function (newVal) {
        return exports.CROP_OFFSET * Math.floor(newVal / exports.CROP_OFFSET);
    };
    CanvasViewManager.prototype.setActualZoom = function (actualZoom) {
        if (this.actualZoom !== actualZoom) {
            this.actualZoom = actualZoom;
            this.raiseActualZoomChanged();
        }
    };
    CanvasViewManager.prototype.getActualAutoZoomLevel = function (autoZoom) {
        if (autoZoom === Settings_1.AutoZoomMode.Disabled)
            return this.actualZoom;
        var containerSize = this.containerSize;
        var scrollbarWidth = this.scrollView.getScrollBarWidth();
        var actualModelSizeWithoutZoom = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop);
        return this.getActualAutoZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom);
    };
    CanvasViewManager.prototype.getActualZoom = function (containerSize, scrollbarWidth, actualModelSizeWithoutZoom, fixedZoom, autoZoom) {
        return this.lockAutoZoom ? this.actualZoom :
            autoZoom === Settings_1.AutoZoomMode.Disabled ? fixedZoom : this.getActualAutoZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom);
    };
    CanvasViewManager.prototype.getActualAutoZoom = function (containerSize, scrollbarWidth, actualModelSizeWithoutZoom, autoZoom) {
        if (containerSize.width === 0 || containerSize.height === 0)
            return 1;
        if (autoZoom === Settings_1.AutoZoomMode.FitContent)
            return Math.min((containerSize.width - exports.CANVAS_MIN_PADDING * 2) / actualModelSizeWithoutZoom.width, (containerSize.height - exports.CANVAS_MIN_PADDING * 2) / actualModelSizeWithoutZoom.height, 1);
        return Math.min((containerSize.width - exports.CANVAS_MIN_PADDING * 2 - scrollbarWidth) / actualModelSizeWithoutZoom.width, 1);
    };
    CanvasViewManager.prototype.raiseActualZoomChanged = function () {
        var _this = this;
        this.onViewChanged.raise1(function (l) { return l.notifyActualZoomChanged(_this.actualZoom); });
    };
    CanvasViewManager.prototype.tryNormalizePaddings = function () {
        var scrollbarWidth = this.scrollView.getScrollBarWidth();
        var actualModelSize = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop).clone().multiply(this.actualZoom, this.actualZoom);
        var translate = new point_1.Point(this.paddings.left, this.paddings.top);
        var currentTail = new size_1.Size(this.paddings.right, this.paddings.bottom);
        var tail = this.getTailSpace(translate, this.scroll, actualModelSize, this.containerSize, scrollbarWidth);
        if (!tail.equals(currentTail))
            this.applyChanges(new offsets_1.Offsets(translate.x, tail.width, translate.y, tail.height), actualModelSize, this.simpleView, this.crop.clone().multiply(this.actualZoom));
    };
    CanvasViewManager.prototype.scrollBy = function (offset) {
        var _a, _b, _c;
        var scroll = this.scroll;
        var containerSize = this.containerSize;
        var scrollbarWidth = this.scrollView.getScrollBarWidth();
        var actualModelSize = this.getActualModelSizeWithoutZoom(this.modelSize, this.simpleView, this.crop).clone().multiply(this.actualZoom, this.actualZoom);
        var scrollbars = this.checkScrollBars(containerSize, scrollbarWidth, actualModelSize, this.paddings);
        var translate = new point_1.Point(this.paddings.left, this.paddings.top);
        var tail = new size_1.Size(this.paddings.right, this.paddings.bottom);
        (_a = this.changeScrollByOffset(translate, scroll, tail, actualModelSize, offset, containerSize, scrollbars), scroll = _a.scroll, offset = _a.offset);
        (_b = this.changeTranslateByOffset(translate, tail, offset, scrollbars), translate = _b.translate, offset = _b.offset);
        (_c = this.cropHiddenHead(translate, scroll), translate = _c.translate, scroll = _c.scroll);
        tail = this.getTailSpace(translate, scroll, actualModelSize, containerSize, scrollbarWidth);
        this.applyChanges(new offsets_1.Offsets(translate.x, tail.width, translate.y, tail.height), actualModelSize, this.simpleView, this.crop.clone().multiply(this.actualZoom), scroll);
        return offset;
    };
    CanvasViewManager.prototype.changeScrollByOffset = function (curTranslate, curScroll, curTail, modelSize, curOffset, containerSize, scrollbars) {
        var scroll = curScroll.clone();
        var offset = curOffset.clone();
        if (curOffset.x && scrollbars.horizontal)
            scroll.x -= (offset.x = -this.getScrollDeltaByOffset(curOffset.x, curScroll.x, curTranslate.x + modelSize.width + curTail.width, containerSize.width, scrollbars.vertical));
        if (curOffset.y && scrollbars.vertical)
            scroll.y -= (offset.y = -this.getScrollDeltaByOffset(curOffset.y, curScroll.y, curTranslate.y + modelSize.height + curTail.height, containerSize.height, scrollbars.horizontal));
        return { scroll: scroll, offset: offset };
    };
    CanvasViewManager.prototype.changeTranslateByOffset = function (curTranslate, curTail, curOffset, scrollbars) {
        var translate = curTranslate.clone();
        var offset = curOffset.clone();
        if (curOffset.x && !scrollbars.horizontal)
            translate.x += (offset.x = this.getTranslateDeltaByOffset(curOffset.x, translate.x, curTail.width));
        if (curOffset.y && !scrollbars.vertical)
            translate.y += (offset.y = this.getTranslateDeltaByOffset(curOffset.y, translate.y, curTail.height));
        return { translate: translate, offset: offset };
    };
    CanvasViewManager.prototype.getScrollDeltaByOffset = function (offset, scroll, commonWidth, containerWidth, hasScrollbar) {
        if (offset > 0)
            return -Math.min(scroll, offset);
        var maxScroll = commonWidth - (containerWidth - (hasScrollbar ? this.scrollView.getScrollBarWidth() : 0));
        return Math.min(maxScroll - scroll, -offset);
    };
    CanvasViewManager.prototype.getTranslateDeltaByOffset = function (offset, headPadding, tailPadding) {
        if (!offset)
            return 0;
        return offset < 0 ?
            -Math.min(headPadding - exports.CANVAS_MIN_PADDING, -offset) :
            Math.min(tailPadding - exports.CANVAS_MIN_PADDING, offset);
    };
    CanvasViewManager.prototype.getActualModelSizeWithoutZoom = function (originModelSize, simpleView, crop) {
        return simpleView && crop ? originModelSize.clone().offset(-crop.horizontal, -crop.vertical).nonNegativeSize() : originModelSize;
    };
    CanvasViewManager.prototype.setScrollTo = function (modelPoint, offsetPoint) {
        var containerSize = this.containerSize;
        var shift = this.getVisibileAreaAbsShift();
        var absPoint = modelPoint
            .clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF)
            .clone().multiply(this.actualZoom, this.actualZoom)
            .clone().offset(shift.x, shift.y);
        var scroll = this.scroll;
        if (!offsetPoint) {
            if (absPoint.x < 0)
                scroll.x += absPoint.x - exports.CANVAS_MIN_PADDING;
            if (absPoint.y < 0)
                scroll.y += absPoint.y - exports.CANVAS_MIN_PADDING;
            if (absPoint.x > containerSize.width)
                scroll.x += (absPoint.x - containerSize.width + exports.CANVAS_MIN_PADDING);
            if (absPoint.y > containerSize.height)
                scroll.y += (absPoint.y - containerSize.height + exports.CANVAS_MIN_PADDING);
        }
        else {
            scroll.x += absPoint.x - offsetPoint.x;
            scroll.y += absPoint.y - offsetPoint.y;
        }
        this.setScroll(scroll);
    };
    CanvasViewManager.prototype.scrollIntoView = function (rectangle) {
        var shift = this.getVisibileAreaAbsShift(true);
        rectangle = rectangle
            .clone()
            .applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF)
            .multiply(this.actualZoom, this.actualZoom)
            .moveRectangle(shift.x, shift.y);
        var scroll = this.scroll;
        var container = this.containerSize;
        if (rectangle.x >= scroll.x && rectangle.y >= scroll.y && rectangle.right <= scroll.x + container.width && rectangle.bottom <= scroll.y + container.height)
            return;
        var newScroll = scroll.clone();
        if (rectangle.x < scroll.x)
            newScroll.x = rectangle.x - exports.CANVAS_SCROLL_PADDING;
        else if (rectangle.right > scroll.x + container.width)
            newScroll.x = Math.min(rectangle.x - exports.CANVAS_SCROLL_PADDING, rectangle.right + exports.CANVAS_SCROLL_PADDING - container.width);
        if (rectangle.y < scroll.y)
            newScroll.y = rectangle.y - exports.CANVAS_SCROLL_PADDING;
        else
            newScroll.y = Math.min(rectangle.y - exports.CANVAS_SCROLL_PADDING, rectangle.bottom + exports.CANVAS_SCROLL_PADDING - container.height);
        this.setScroll(newScroll);
    };
    CanvasViewManager.prototype.setScroll = function (pt) {
        var _this = this;
        var modelAbsSize = this.modelSize.clone().multiply(this.actualZoom, this.actualZoom);
        pt.x = Math.max(0, Math.min(pt.x, modelAbsSize.width + this.paddings.horizontal - this.containerSize.width));
        pt.y = Math.max(0, Math.min(pt.y, modelAbsSize.height + this.paddings.vertical - this.containerSize.height));
        this.dom.changeByFunc(null, function () {
            _this.scrollView.setScroll(pt.x, pt.y);
        });
        this.scroll = pt.clone();
    };
    CanvasViewManager.prototype.updateElements = function (modelAbsSize, translate, simpleView) {
        this.updatePageElement(modelAbsSize, translate, simpleView);
        this.updateCanvasElement(translate);
    };
    CanvasViewManager.prototype.updateCanvasElement = function (translate) {
        this.canvasElement = this.getOrCreateElement("dxdi-main", new GroupPrimitive_1.GroupPrimitive([], "dxdi-main", null, null, function (el) {
            el.setAttribute("transform", "translate(".concat(Math.round(translate.x), ", ").concat(Math.round(translate.y), ")"));
        }), this.svgElement);
    };
    CanvasViewManager.prototype.updatePageElement = function (modelAbsSize, translate, simpleView) {
        if (simpleView)
            this.updatePageElementCore("", 0, 0, modelAbsSize.width, modelAbsSize.height);
        else {
            var x = translate.x;
            var y = translate.y;
            var modelAbsWidth = modelAbsSize.width;
            var modelAbsHeight = modelAbsSize.height;
            this.createPageShadow(x, y, modelAbsWidth, modelAbsHeight);
            this.updatePageElementCore(this.pageClipPathId, Math.round(x), Math.round(y), modelAbsWidth, modelAbsHeight);
        }
    };
    CanvasViewManager.prototype.createPageShadow = function (left, top, width, height) {
        this.getOrCreateElement("pageShadowRect", new RectaglePrimitive_1.RectanglePrimitive(left.toString(), top.toString(), width.toString(), height.toString(), new Style_1.EmptyStyle({ "filter": Utils_2.RenderUtils.getUrlPathById(this.pageShadowId) }), "dxdi-page-shadow"), this.svgElement, this.svgElement.firstChild);
    };
    CanvasViewManager.prototype.updatePageElementCore = function (groupClipPathId, translateX, translateY, modelAbsWidth, modelAbsHeight) {
        this.pageElement = this.getOrCreateElement("page", new GroupPrimitive_1.GroupPrimitive([], "dxdi-page", null, groupClipPathId, function (el) {
            el.setAttribute("transform", "translate(".concat(translateX, ", ").concat(translateY, ")"));
        }), this.svgElement);
        this.getOrCreateElement("pageClip", this.createPageClipPathPrimitive(modelAbsWidth, modelAbsHeight), this.svgElement);
    };
    CanvasViewManager.prototype.createPageClipPathPrimitive = function (modelAbsWidth, modelAbsHeight) {
        return new ClipPathPrimitive_1.ClipPathPrimitive(this.pageClipPathId, [new RectaglePrimitive_1.RectanglePrimitive(0, 0, modelAbsWidth.toString(), modelAbsHeight.toString())]);
    };
    CanvasViewManager.prototype.adjustCore = function (newModelSize, fixedZoomLevel, autoZoom, simpleView, crop, resetPaddings, containerSize, offset, saveVerticalScroll) {
        var actualModelSizeWithoutZoom = this.getActualModelSizeWithoutZoom(newModelSize, simpleView, crop);
        if (!this.lockAutoZoom && (autoZoom || !offset || !this.modelSize)) {
            var scrollbarWidth = this.scrollView.getScrollBarWidth();
            var actualZoom = this.getActualZoom(containerSize, scrollbarWidth, actualModelSizeWithoutZoom, fixedZoomLevel, autoZoom);
            if (autoZoom && actualZoom === this.actualZoom && (!resetPaddings.horizontal || (!resetPaddings.vertical && !saveVerticalScroll)))
                this.resizeView(actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, crop, offset || offsets_1.Offsets.empty());
            else {
                this.resetView(actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, crop, resetPaddings);
                this.setActualZoom(actualZoom);
            }
        }
        else
            this.resizeView(actualModelSizeWithoutZoom, this.actualZoom, containerSize, simpleView, crop, offset || offsets_1.Offsets.empty());
    };
    CanvasViewManager.prototype.resetView = function (actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, cropWithoutZoom, toReset) {
        var actualModelSize = actualModelSizeWithoutZoom.clone().multiply(actualZoom, actualZoom);
        var paddings = offsets_1.Offsets.fromNumber(exports.CANVAS_MIN_PADDING);
        toReset = toReset || { horizontal: true, vertical: true };
        if (!toReset.horizontal && this.paddings) {
            paddings.left = this.paddings.left;
            paddings.right = this.paddings.right;
        }
        if (!toReset.vertical && this.paddings) {
            paddings.top = this.paddings.top;
            paddings.bottom = this.paddings.bottom;
        }
        var scrollbars = this.checkScrollBars(containerSize, this.scrollView.getScrollBarWidth(), actualModelSize, paddings);
        var scrollBarWidth = this.scrollView.getScrollBarWidth();
        var scroll = (toReset.horizontal || toReset.vertical) ? this.scroll : undefined;
        if (toReset.horizontal) {
            var paddingsH = Math.max((containerSize.width - (scrollbars.vertical ? scrollBarWidth : 0) - actualModelSize.width) / 2, exports.CANVAS_MIN_PADDING);
            paddings.left = paddingsH;
            paddings.right = paddingsH;
            scroll.x = 0;
        }
        if (toReset.vertical) {
            var paddingsV = Math.max((containerSize.height - (scrollbars.horizontal ? scrollBarWidth : 0) - actualModelSize.height) / 2, exports.CANVAS_MIN_PADDING);
            paddings.top = paddingsV;
            paddings.bottom = paddingsV;
            scroll.y = 0;
        }
        this.applyChanges(paddings, actualModelSize, simpleView, cropWithoutZoom.clone().multiply(actualZoom), scroll);
    };
    CanvasViewManager.prototype.resizeView = function (actualModelSizeWithoutZoom, actualZoom, containerSize, simpleView, cropWithoutZoom, offset) {
        var _a, _b;
        var oldZoom = this.actualZoom;
        var oldCrop = this.simpleView && this.crop ? this.crop.clone().multiply(oldZoom) : offsets_1.Offsets.empty();
        var actualModelSize = actualModelSizeWithoutZoom.clone().multiply(actualZoom, actualZoom);
        offset = offset.clone().multiply(actualZoom);
        var newCrop = simpleView && cropWithoutZoom ? cropWithoutZoom.clone().multiply(actualZoom) : offsets_1.Offsets.empty();
        var translate = new point_1.Point(this.paddings.left, this.paddings.top);
        var scroll = this.scroll;
        (_a = this.applyOffset(translate, scroll, oldCrop, newCrop, offset), translate = _a.translate, scroll = _a.scroll);
        (_b = this.cropHiddenHead(translate, scroll), translate = _b.translate, scroll = _b.scroll);
        var tailSpace = this.getTailSpace(translate, scroll, actualModelSize, containerSize, this.scrollView.getScrollBarWidth());
        if (!simpleView) {
            var maxTailSpaceWidth = containerSize.width - exports.CANVAS_SCROLL_PADDING;
            var maxTailSpaceHeight = containerSize.height - exports.CANVAS_SCROLL_PADDING;
            if (offset.left < 0)
                if (translate.x > maxTailSpaceWidth) {
                    translate.x = maxTailSpaceWidth;
                    scroll.x = 0;
                }
            if (offset.right < 0)
                if (tailSpace.width > maxTailSpaceWidth) {
                    tailSpace.width = maxTailSpaceWidth;
                    if (scroll.x > actualModelSize.width)
                        scroll.x = actualModelSize.width;
                }
            if (offset.top < 0)
                if (translate.y > maxTailSpaceHeight) {
                    translate.y = maxTailSpaceHeight;
                    scroll.y = 0;
                }
            if (offset.bottom < 0)
                if (tailSpace.height > maxTailSpaceHeight) {
                    tailSpace.height = maxTailSpaceHeight;
                    if (scroll.y > actualModelSize.height)
                        scroll.y = actualModelSize.height;
                }
        }
        var newPaddings = new offsets_1.Offsets(translate.x, tailSpace.width, translate.y, tailSpace.height);
        this.applyChanges(newPaddings, actualModelSize, simpleView, newCrop, scroll);
    };
    CanvasViewManager.prototype.applyChanges = function (paddings, actualModelSize, simpleView, crop, scroll) {
        var _this = this;
        var translate = new point_1.Point(paddings.left, paddings.top);
        if (simpleView && crop)
            translate = translate.clone().offset(-crop.left, -crop.top);
        this.updateElements(actualModelSize, translate, simpleView);
        this.setSvgSize(actualModelSize.width + paddings.horizontal, actualModelSize.height + paddings.vertical);
        this.onViewChanged.raise1(function (l) { return l.notifyViewAdjusted(new point_1.Point(translate.x, translate.y)); });
        if (scroll) {
            this.lockAutoScroll();
            scroll && this.dom.changeByFunc(this.scrollView, function (s) {
                s.setScroll(scroll.x, scroll.y);
                _this.unlockAutoScroll();
            });
            this.scroll = scroll;
        }
        this.paddings = paddings;
    };
    CanvasViewManager.prototype.isAutoScrollLocked = function () {
        return this.autoScrollLocker !== 0;
    };
    CanvasViewManager.prototype.lockAutoScroll = function () {
        this.autoScrollLocker++;
    };
    CanvasViewManager.prototype.unlockAutoScroll = function () {
        this.autoScrollLocker--;
    };
    CanvasViewManager.prototype.applyOffset = function (curTranslate, curScroll, oldCrop, newCrop, modelOffset) {
        var translate = curTranslate.clone();
        var scroll = curScroll.clone();
        var offset = this.getActualOffset(oldCrop, newCrop, modelOffset);
        if (offset.left) {
            translate.x = Math.max(exports.CANVAS_MIN_PADDING, translate.x - offset.left);
            scroll.x += offset.left - (curTranslate.x - translate.x);
        }
        if (offset.top) {
            translate.y = Math.max(exports.CANVAS_MIN_PADDING, translate.y - offset.top);
            scroll.y += offset.top - (curTranslate.y - translate.y);
        }
        return { translate: translate, scroll: scroll };
    };
    CanvasViewManager.prototype.cropHiddenHead = function (curTranslate, curScroll) {
        var scroll = curScroll.clone();
        var translate = curTranslate.clone();
        if (scroll.x && translate.x > exports.CANVAS_MIN_PADDING) {
            var delta = translate.x - Math.max(exports.CANVAS_MIN_PADDING, translate.x - scroll.x);
            translate.x -= delta;
            scroll.x -= delta;
        }
        if (scroll.y && translate.y > exports.CANVAS_MIN_PADDING) {
            var delta = translate.y - Math.max(exports.CANVAS_MIN_PADDING, translate.y - scroll.y);
            translate.y -= delta;
            scroll.y -= delta;
        }
        return { translate: translate, scroll: scroll };
    };
    CanvasViewManager.prototype.getTailSpace = function (curTranslate, curScroll, newModelAbsSize, containerSize, scrollbarWidth) {
        var translate = curTranslate.clone();
        var scroll = curScroll.clone();
        var right = Math.max(containerSize.width + scroll.x - (translate.x + newModelAbsSize.width), exports.CANVAS_MIN_PADDING);
        var bottom = Math.max(containerSize.height + scroll.y - (translate.y + newModelAbsSize.height), exports.CANVAS_MIN_PADDING);
        var scrollbars = this.checkScrollBars(containerSize, scrollbarWidth, newModelAbsSize, new offsets_1.Offsets(translate.x, right, translate.y, bottom));
        if (scrollbars.vertical)
            right = Math.max(exports.CANVAS_MIN_PADDING, right - scrollbarWidth);
        if (scrollbars.horizontal)
            bottom = Math.max(exports.CANVAS_MIN_PADDING, bottom - scrollbarWidth);
        return new size_1.Size(right, bottom);
    };
    CanvasViewManager.prototype.getActualOffset = function (oldCrop, newCrop, docOffset) {
        return new offsets_1.Offsets(-(newCrop.left - oldCrop.left) + docOffset.left, -(newCrop.right - oldCrop.right) + docOffset.right, -(newCrop.top - oldCrop.top) + docOffset.top, -(newCrop.bottom - oldCrop.bottom) + docOffset.bottom);
    };
    CanvasViewManager.prototype.checkScrollBars = function (containerSize, scrollBarWidth, modelAbsSize, paddings) {
        var hasHorizontalScroll = containerSize.width < modelAbsSize.width + paddings.horizontal;
        var hasVerticalScroll = containerSize.height < modelAbsSize.height + paddings.vertical;
        if (hasHorizontalScroll && !hasVerticalScroll)
            hasVerticalScroll = containerSize.height - scrollBarWidth < modelAbsSize.height + paddings.vertical;
        if (hasVerticalScroll && !hasHorizontalScroll)
            hasHorizontalScroll = containerSize.width - scrollBarWidth < modelAbsSize.width + paddings.horizontal;
        return { horizontal: hasHorizontalScroll, vertical: hasVerticalScroll };
    };
    CanvasViewManager.prototype.setSvgSize = function (width, height) {
        if (width !== this.lastWidth || height !== this.lastHeight) {
            this.dom.changeByFunc(this.svgElement, function (e) { return Utils_2.RenderUtils.updateSvgElementSize(e, width, height); });
            this.lastWidth = width;
            this.lastHeight = height;
        }
    };
    CanvasViewManager.prototype.getVisibileAreaAbsShift = function (excludeScroll) {
        var scroll = this.scroll;
        var paddings = this.paddings.clone();
        var simpleView = this.simpleView;
        var cropLeft = simpleView && this.crop ? this.crop.left * this.actualZoom : 0;
        var cropTop = simpleView && this.crop ? this.crop.top * this.actualZoom : 0;
        return new point_1.Point(paddings.left - cropLeft - (excludeScroll ? 0 : scroll.x), paddings.top - cropTop - (excludeScroll ? 0 : scroll.y));
    };
    CanvasViewManager.prototype.getModelPoint = function (absolutePoint, checkScrollArea) {
        var shift = this.getVisibileAreaAbsShift();
        var modelPoint = absolutePoint
            .clone().offset(-shift.x, -shift.y)
            .multiply(1 / this.actualZoom, 1 / this.actualZoom);
        if (checkScrollArea) {
            var scrollSize = this.containerSize;
            if (absolutePoint.x < 0 || absolutePoint.y < 0 || absolutePoint.x > scrollSize.width || absolutePoint.y > scrollSize.height)
                return null;
            if (modelPoint.x < 0 || modelPoint.y < 0)
                return null;
            if (modelPoint.x > this.modelSize.width || modelPoint.y > this.modelSize.height)
                return null;
        }
        return modelPoint.clone().applyConverter(unit_converter_1.UnitConverter.pixelsToTwips);
    };
    CanvasViewManager.prototype.getAbsolutePoint = function (modelPoint, excludeScroll, checkScrollArea) {
        var shift = this.getVisibileAreaAbsShift(excludeScroll);
        var absPoint = modelPoint
            .clone().multiply(this.actualZoom, this.actualZoom)
            .clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF)
            .clone().offset(shift.x, shift.y);
        if (checkScrollArea) {
            if (absPoint.x < 0 || absPoint.y < 0)
                return null;
            var scrollSize = this.containerSize;
            if (absPoint.x > scrollSize.width || absPoint.y > scrollSize.height)
                return null;
        }
        return absPoint;
    };
    return CanvasViewManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasViewManager = CanvasViewManager;


/***/ }),

/***/ 1381:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PaperTapeShapeDescription = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var PathPrimitive_1 = __webpack_require__(6208);
var DiagramItem_1 = __webpack_require__(4824);
var ShapeDescription_1 = __webpack_require__(1280);
var size_1 = __webpack_require__(3844);
var PaperTapeShapeDescription = (function (_super) {
    __extends(PaperTapeShapeDescription, _super);
    function PaperTapeShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(PaperTapeShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.PaperTape; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PaperTapeShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    PaperTapeShapeDescription.prototype.createShapePrimitives = function (shape) {
        return this.createDocumentPrimitives(shape.rectangle, shape.style);
    };
    PaperTapeShapeDescription.prototype.createDocumentPrimitives = function (rect, style) {
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var dy = height * PaperTapeShapeDescription.curveOffsetRatio;
        var primitives = [];
        return primitives.concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, top + 2 * dy, cx, top + dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, top - dy, right, top + dy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(right - width * 0.25, bottom - 2 * dy, cx, bottom - dy),
                new PathPrimitive_1.PathPrimitiveQuadraticCurveToCommand(left + width * 0.25, bottom + dy, left, bottom - dy),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], style)
        ]);
    };
    PaperTapeShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.North)
            point.y += shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
        if (side === DiagramItem_1.ConnectionPointSide.South)
            point.y -= shape.size.height * PaperTapeShapeDescription.curveOffsetRatio;
    };
    PaperTapeShapeDescription.prototype.getTextRectangle = function (shape) {
        var rect = shape.rectangle;
        return rect.clone().inflate(ShapeDescription_1.ShapeTextPadding, -rect.height * PaperTapeShapeDescription.curveOffsetRatio);
    };
    PaperTapeShapeDescription.prototype.getSizeByText = function (textSize, _shape) {
        return new size_1.Size(textSize.width + ShapeDescription_1.ShapeTextPadding * 2, textSize.height / (1 - 2 * PaperTapeShapeDescription.curveOffsetRatio));
    };
    PaperTapeShapeDescription.curveOffsetRatio = 0.1;
    return PaperTapeShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.PaperTapeShapeDescription = PaperTapeShapeDescription;


/***/ }),

/***/ 1387:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PermissionsProviderStorage = void 0;
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var PermissionsProviderStorage = (function () {
    function PermissionsProviderStorage() {
        this.interactingItems = {};
        this.storedPermissions = {};
    }
    PermissionsProviderStorage.prototype.addInteractingItem = function (item, operation) {
        var key = this.getInteractingItemKey(item, operation);
        if (this.interactingItems[key] === undefined && (item instanceof Shape_1.Shape || item instanceof Connector_1.Connector))
            this.interactingItems[key] = item.clone();
    };
    PermissionsProviderStorage.prototype.getInteractingItem = function (item, operation) {
        var key = this.getInteractingItemKey(item, operation);
        return this.interactingItems[key];
    };
    PermissionsProviderStorage.prototype.getInteractingItemCount = function () {
        return Object.keys(this.interactingItems).length;
    };
    PermissionsProviderStorage.prototype.clearInteractingItems = function () {
        this.interactingItems = {};
    };
    PermissionsProviderStorage.prototype.getInteractingItemKey = function (item, operation) {
        return item.key + (operation !== undefined ? "_" + operation.toString() : "");
    };
    PermissionsProviderStorage.prototype.needStorePermissions = function () {
        return this.storePermissions;
    };
    PermissionsProviderStorage.prototype.beginStorePermissions = function () {
        this.storePermissions = true;
    };
    PermissionsProviderStorage.prototype.endStorePermissions = function () {
        this.storePermissions = false;
        this.storedPermissions = {};
    };
    PermissionsProviderStorage.prototype.isStoredPermissionsGranted = function () {
        var keys = Object.keys(this.storedPermissions);
        var granted = true;
        for (var i = 0; i < keys.length; i++)
            granted = granted && this.storedPermissions[keys[i]];
        return granted;
    };
    PermissionsProviderStorage.prototype.storePermission = function (key, allowed) {
        this.storedPermissions[key] = allowed;
    };
    return PermissionsProviderStorage;
}());
exports.PermissionsProviderStorage = PermissionsProviderStorage;


/***/ }),

/***/ 1416:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DraggingConnector = exports.SelectionDragHelper = void 0;
var vector_1 = __webpack_require__(4166);
var ChangeConnectorPointsHistoryItem_1 = __webpack_require__(8818);
var ConnectorRenderPointsContext_1 = __webpack_require__(5359);
var ModelUtils_1 = __webpack_require__(1922);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ModelOperationSettings_1 = __webpack_require__(5225);
var SelectionDragHelper = (function () {
    function SelectionDragHelper(history, model, permissionsProvider, startPoint, selectedItems) {
        var _this = this;
        this.history = history;
        this.model = model;
        this.permissionsProvider = permissionsProvider;
        this.startPoint = startPoint;
        this.draggingShapes = [];
        this.draggingConnectors = [];
        this.selectedItems = {};
        this.draggingConnectorsIndexByKey = {};
        selectedItems.forEach(function (i) { return _this.selectedItems[i.key] = i; });
    }
    SelectionDragHelper.prototype.initDraggingShapes = function (shapes, shouldClone) {
        var _this = this;
        this.draggingShapes = shapes.map(function (s) { return new DraggingShape(s); });
        if (!shouldClone)
            this.draggingShapes.forEach(function (draggingShape) { return _this.permissionsProvider.addInteractingItem(draggingShape.shape, ModelOperationSettings_1.DiagramModelOperation.MoveShape); });
    };
    SelectionDragHelper.prototype.initDraggingConnectors = function (connectors, shouldClone) {
        var _this = this;
        this.draggingConnectors = [];
        this.draggingConnectorsIndexByKey = {};
        connectors.forEach(function (c) { return _this.registerConnector(c); });
        if (!shouldClone)
            this.draggingShapes.forEach(function (x) {
                var attachedConnectors = x.shape.attachedConnectors;
                if (attachedConnectors)
                    attachedConnectors.forEach(function (c) {
                        if (!_this.containsDraggingConnectorByKey(c.key))
                            _this.registerConnector(c);
                    });
            });
        this.modelConnectorsWithoutBeginItemInfo = this.createModelConnectorsWithoutBeginItemInfo();
        this.modelConnectorsWithoutEndItemInfo = this.createModelConnectorsWithoutEndItemInfo();
    };
    SelectionDragHelper.prototype.move = function (shouldClone, getMovePoint, resetTargetCallback, updateTargetCallback) {
        var _this = this;
        if (this.draggingShapes.length) {
            var selectedShapes_1 = this.draggingShapes.map(function (ds) { return ds.shape; });
            this.draggingShapes.forEach(function (ds) {
                var shape = ds.shape;
                while (shape.container) {
                    if (selectedShapes_1.indexOf(shape.container) !== -1)
                        return false;
                    shape = shape.container;
                }
                _this.moveShape(ds, getMovePoint, resetTargetCallback, updateTargetCallback);
            });
            var firstDraggingShape = this.draggingShapes[0];
            var offset_1 = vector_1.Vector.fromPoints(firstDraggingShape.startPosition.clone(), firstDraggingShape.shape.position.clone());
            if (offset_1.x || offset_1.y)
                this.draggingConnectors.forEach(function (dc) { return _this.moveConnectorCore(dc.connector, dc.startPoints, dc.startRenderContext, offset_1, shouldClone); });
        }
        else
            this.draggingConnectors.forEach(function (x) { return _this.moveConnector(x, shouldClone, getMovePoint); });
    };
    SelectionDragHelper.prototype.containsDraggingConnectorByKey = function (key) {
        return this.draggingConnectorsIndexByKey[key] !== undefined;
    };
    SelectionDragHelper.prototype.onTryUpdateModelSize = function (offsetLeft, offsetTop) {
        this.modelConnectorsWithoutBeginItemInfo.forEach(function (pi) {
            pi.point.x += offsetLeft;
            pi.point.y += offsetTop;
        });
        this.modelConnectorsWithoutEndItemInfo.forEach(function (pi) {
            pi.point.x += offsetLeft;
            pi.point.y += offsetTop;
        });
    };
    SelectionDragHelper.prototype.finish = function () {
        this.draggingConnectors.forEach(function (c) { return c.connector.unlockCreateRenderPoints(); });
    };
    SelectionDragHelper.prototype.moveConnector = function (dc, shouldClone, getMovePoint) {
        var startPoints = dc.startPoints;
        var offset = vector_1.Vector.fromPoints(startPoints[0].clone(), getMovePoint(startPoints[0]).clone());
        if (offset.x || offset.y)
            this.moveConnectorCore(dc.connector, startPoints, dc.startRenderContext, offset, shouldClone);
    };
    SelectionDragHelper.prototype.moveConnectorCore = function (connector, startPoints, startRenderContext, offset, shouldClone) {
        if (shouldClone || ModelUtils_1.ModelUtils.canMoveConnector(this.selectedItems, connector))
            this.offsetConnector(connector, startPoints, startRenderContext, offset);
        else
            this.changeConnector(connector);
    };
    SelectionDragHelper.prototype.moveShape = function (ds, getMovePoint, resetTargetCallback, updateTargetCallback) {
        var _this = this;
        var shape = ds.shape;
        var position = getMovePoint(ds.startPosition);
        ModelUtils_1.ModelUtils.setShapePosition(this.history, this.model, shape, position);
        ModelUtils_1.ModelUtils.updateMovingShapeConnections(this.history, shape, this.modelConnectorsWithoutBeginItemInfo, this.modelConnectorsWithoutEndItemInfo, resetTargetCallback, updateTargetCallback, function (connector) { return _this.permissionsProvider.addInteractingItem(connector); });
        if (!this.draggingConnectors.filter(function (dc) { return !!_this.selectedItems[dc.connector.key]; }).length)
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(this.history, this.model, shape);
    };
    SelectionDragHelper.prototype.offsetConnector = function (connector, startPoints, startRenderContext, offset) {
        var _this = this;
        var newPoints = startPoints.map(function (p) { return _this.offsetPoint(p, offset); });
        if (!newPoints[0].equals(connector.points[0]))
            this.history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ChangeConnectorPointsHistoryItem(connector.key, newPoints, this.offsetRenderContext(startRenderContext, offset)));
    };
    SelectionDragHelper.prototype.offsetRenderContext = function (context, offset) {
        var _this = this;
        if (context === undefined)
            return undefined;
        return new ConnectorRenderPointsContext_1.ConnectorRenderPointsContext(context.renderPoints.map(function (p) {
            var newPoint = _this.offsetPoint(p, offset);
            return new ConnectorRenderPoint_1.ConnectorRenderPoint(newPoint.x, newPoint.y, p.pointIndex, p.skipped);
        }), true, context.actualRoutingMode);
    };
    SelectionDragHelper.prototype.offsetPoint = function (point, offset) {
        var pointOffset = vector_1.Vector.fromPoints(point, this.startPoint);
        return this.startPoint.clone().offset(offset.x - pointOffset.x, offset.y - pointOffset.y);
    };
    SelectionDragHelper.prototype.changeConnector = function (connector) {
        ModelUtils_1.ModelUtils.tryRemoveConnectorIntermediatePoints(this.history, connector);
        ModelUtils_1.ModelUtils.updateConnectorAttachedPoints(this.history, this.model, connector);
    };
    SelectionDragHelper.prototype.registerConnector = function (connector) {
        this.draggingConnectorsIndexByKey[connector.key] = this.draggingConnectors.push(new DraggingConnector(connector)) - 1;
    };
    SelectionDragHelper.prototype.createModelConnectorsWithoutBeginItemInfo = function () {
        var _this = this;
        var connectors = this.model.findConnectorsCore(function (c) { return !c.beginItem && !_this.containsDraggingConnectorByKey(c.key); });
        return connectors.map(function (c) {
            return {
                connector: c,
                point: c.points[0].clone()
            };
        });
    };
    SelectionDragHelper.prototype.createModelConnectorsWithoutEndItemInfo = function () {
        var _this = this;
        var connectors = this.model.findConnectorsCore(function (c) { return !c.endItem && !_this.containsDraggingConnectorByKey(c.key); });
        return connectors.map(function (c) {
            return {
                connector: c,
                point: c.points[c.points.length - 1].clone()
            };
        });
    };
    return SelectionDragHelper;
}());
exports.SelectionDragHelper = SelectionDragHelper;
var DraggingConnector = (function () {
    function DraggingConnector(connector) {
        this.connector = connector;
        this.startPoints = connector.points.map(function (x) { return x.clone(); });
        this.startRenderContext = connector.tryCreateRenderPointsContext();
    }
    return DraggingConnector;
}());
exports.DraggingConnector = DraggingConnector;
var DraggingShape = (function () {
    function DraggingShape(shape) {
        this.shape = shape;
        this.startPosition = shape.position.clone();
    }
    return DraggingShape;
}());


/***/ }),

/***/ 1425:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddShapeEventArgs = exports.AddShapeRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var AddShapeRequestedEntity = (function (_super) {
    __extends(AddShapeRequestedEntity, _super);
    function AddShapeRequestedEntity(apiController, shape) {
        var _this = _super.call(this, apiController) || this;
        _this.shape = shape;
        return _this;
    }
    Object.defineProperty(AddShapeRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.AddShape;
        },
        enumerable: false,
        configurable: true
    });
    AddShapeRequestedEntity.prototype.createEventArgs = function () {
        return new AddShapeEventArgs(this.apiController.createNativeShape(this.shape), this.apiController.convertPoint(this.shape.position));
    };
    Object.defineProperty(AddShapeRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "addShape";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AddShapeRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.shape && this.shape.key);
        },
        enumerable: false,
        configurable: true
    });
    AddShapeRequestedEntity.prototype.equals = function (other) {
        if (other instanceof AddShapeRequestedEntity)
            return this.shape === other.shape && this.shape.position.equals(other.shape.position);
        return false;
    };
    return AddShapeRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.AddShapeRequestedEntity = AddShapeRequestedEntity;
var AddShapeEventArgs = (function (_super) {
    __extends(AddShapeEventArgs, _super);
    function AddShapeEventArgs(shape, position) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        _this.position = position;
        return _this;
    }
    return AddShapeEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.AddShapeEventArgs = AddShapeEventArgs;


/***/ }),

/***/ 1441:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GraphLayout = void 0;
var Utils_1 = __webpack_require__(41);
var NodeLayout_1 = __webpack_require__(8501);
var GraphLayout = (function () {
    function GraphLayout() {
        this.nodeKeys = [];
        this.nodeToLayout = {};
        this.edgeToPosition = {};
    }
    GraphLayout.prototype.forEachNode = function (callback) {
        var _this = this;
        this.nodeKeys.forEach(function (nk) { return callback(_this.nodeToLayout[nk], nk); });
    };
    GraphLayout.prototype.reduce = function (callback, initValue) {
        var _this = this;
        return this.nodeKeys.reduce(function (acc, key, index) { return callback(acc, _this.nodeToLayout[key], index); }, initValue);
    };
    GraphLayout.prototype.addNode = function (nodeLayout) {
        if (this.nodeToLayout[nodeLayout.key])
            throw Error("Node layout is already registered");
        this.nodeKeys.push(nodeLayout.key);
        this.nodeToLayout[nodeLayout.key] = nodeLayout;
        return nodeLayout;
    };
    GraphLayout.prototype.hasNode = function (key) {
        return !!this.nodeToLayout[key];
    };
    GraphLayout.prototype.addEdge = function (edgeLayout) {
        if (this.edgeToPosition[edgeLayout.key])
            throw Error("Edge layout is already registered");
        this.edgeToPosition[edgeLayout.key] = edgeLayout;
    };
    GraphLayout.prototype.getRectangle = function (includeMargins) {
        var _this = this;
        return Utils_1.GeometryUtils.getCommonRectangle(this.nodeKeys.map(function (nk) { return _this.nodeToLayout[nk].rectangle; }));
    };
    GraphLayout.prototype.offsetNodes = function (deltaX, deltaY) {
        var _this = this;
        if (deltaX === void 0) { deltaX = 0; }
        if (deltaY === void 0) { deltaY = 0; }
        var layout = new GraphLayout();
        this.nodeKeys.forEach(function (nk) {
            var nl = _this.nodeToLayout[nk];
            layout.addNode(new NodeLayout_1.NodeLayout(nl.info, nl.position.clone().offset(deltaX, deltaY)));
        });
        layout.copyEdges(this);
        return layout;
    };
    GraphLayout.prototype.extend = function (layout) {
        var _this = this;
        layout.forEachNode(function (nl) { return _this.addNode(nl); });
        this.copyEdges(layout);
    };
    GraphLayout.prototype.copyEdges = function (source) {
        var _this = this;
        Object.keys(source.edgeToPosition).forEach(function (e) {
            var edge = source.edgeToPosition[e];
            _this.addEdge(new NodeLayout_1.EdgeLayout(edge.key, edge.beginIndex, edge.endIndex));
        });
    };
    return GraphLayout;
}());
exports.GraphLayout = GraphLayout;


/***/ }),

/***/ 1454:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseIntervalsIterator = void 0;
var SparseIntervalsIterator = (function () {
    function SparseIntervalsIterator(sparseIntervals) {
        this.sparseIntervals = sparseIntervals;
        this.intervalIndex = -1;
    }
    Object.defineProperty(SparseIntervalsIterator.prototype, "isStarted", {
        get: function () {
            return !!this.curr;
        },
        enumerable: false,
        configurable: true
    });
    SparseIntervalsIterator.prototype.moveNext = function () {
        if (this.curr && this.posInInterval + 1 < this.curr.length) {
            this.posInInterval++;
            this.index++;
            this.initObject();
            return true;
        }
        if (this.intervalIndex + 1 < this.sparseIntervals.numIntervals) {
            this.intervalIndex++;
            this.curr = this.sparseIntervals.getInterval(this.intervalIndex);
            if (!this.curr.length)
                return this.moveNext();
            this.posInInterval = 0;
            this.index = this.curr.start;
            this.initObject();
            return true;
        }
        return false;
    };
    SparseIntervalsIterator.prototype.movePrev = function () {
        if (this.curr && this.posInInterval - 1 >= this.curr.start) {
            this.posInInterval--;
            this.index--;
            this.initObject();
            return true;
        }
        if (!this.isStarted)
            this.intervalIndex = this.sparseIntervals.numIntervals;
        if (this.intervalIndex - 1 >= 0) {
            this.intervalIndex--;
            this.curr = this.sparseIntervals.getInterval(this.intervalIndex);
            this.posInInterval = Math.max(this.curr.length - 1, this.curr.start);
            this.index = this.curr.start;
            this.initObject();
            return true;
        }
        return false;
    };
    SparseIntervalsIterator.prototype.initObject = function () { };
    return SparseIntervalsIterator;
}());
exports.SparseIntervalsIterator = SparseIntervalsIterator;


/***/ }),

/***/ 1493:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SummingJunctionShapeDescription = void 0;
var ShapeTypes_1 = __webpack_require__(3255);
var size_1 = __webpack_require__(3844);
var ShapeDescription_1 = __webpack_require__(1280);
var EllipseShapeDescription_1 = __webpack_require__(9829);
var PathPrimitive_1 = __webpack_require__(6208);
var SummingJunctionShapeDescription = (function (_super) {
    __extends(SummingJunctionShapeDescription, _super);
    function SummingJunctionShapeDescription() {
        var _this = _super.call(this, true) || this;
        _this.defaultSize = new size_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.SummingJunction; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SummingJunctionShapeDescription.prototype, "enableText", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    SummingJunctionShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var width = rect.width, height = rect.height;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var rx = width / 2;
        var ry = height / 2;
        var angle = Math.atan(ry / rx);
        var ex = 1 / Math.sqrt(1 / Math.pow(rx, 2) + Math.pow(Math.tan(angle), 2) / Math.pow(ry, 2));
        var ey = ex * Math.tan(angle);
        var primitives = [];
        return primitives
            .concat(_super.prototype.createShapePrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy - ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx - ex, cy + ey),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx + ex, cy - ey)
            ], shape.style)
        ]);
    };
    return SummingJunctionShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.SummingJunctionShapeDescription = SummingJunctionShapeDescription;


/***/ }),

/***/ 1530:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.InputPosition = void 0;
var InputPositionProperties_1 = __webpack_require__(5075);
var Data_1 = __webpack_require__(2620);
var InputPosition = (function () {
    function InputPosition(selection) {
        this.selection = selection;
        this.initialProperties = new InputPositionProperties_1.InputPositionProperties(this.selection);
        this.defaultProperties = new InputPositionProperties_1.InputPositionProperties(this.selection, this.initialProperties, true);
        this.currentProperties = new InputPositionProperties_1.InputPositionProperties(this.selection, this.defaultProperties);
    }
    InputPosition.prototype.initialize = function () {
        this.reset();
        this.defaultProperties.reset();
    };
    InputPosition.prototype.reset = function () {
        this.currentProperties.reset();
    };
    InputPosition.prototype.getDefaultConnectorProperties = function () {
        return this.defaultProperties.getConnectorProperties();
    };
    InputPosition.prototype.getDefaultConnectorPropertyValue = function (propertyName) {
        return this.defaultProperties.getConnectorPropertyValue(propertyName);
    };
    InputPosition.prototype.getCurrentConnectorPropertyValue = function (propertyName) {
        return this.currentProperties.getConnectorPropertyValue(propertyName);
    };
    InputPosition.prototype.setConnectorPropertyValue = function (propertyName, value) {
        this.currentProperties.setConnectorPropertyValue(propertyName, value);
        if (this.selection.isEmpty(true))
            this.defaultProperties.setConnectorPropertyValue(propertyName, value);
    };
    InputPosition.prototype.setInitialConnectorProperties = function (properties) {
        this.defaultProperties.reset();
        this.currentProperties.reset();
        for (var propertyName in properties)
            if (Object.prototype.hasOwnProperty.call(properties, propertyName))
                this.initialProperties.setConnectorPropertyValue(propertyName, properties[propertyName]);
    };
    InputPosition.prototype.getDefaultStyle = function () {
        return this.defaultProperties.getStyle();
    };
    InputPosition.prototype.getDefaultStylePropertyValue = function (propertyName) {
        return this.defaultProperties.getStylePropertyValue(propertyName);
    };
    InputPosition.prototype.getDefaultTextStyle = function () {
        return this.defaultProperties.getTextStyle();
    };
    InputPosition.prototype.getDefaultTextStylePropertyValue = function (propertyName) {
        return this.defaultProperties.getTextStylePropertyValue(propertyName);
    };
    InputPosition.prototype.getCurrentStylePropertyValue = function (propertyName) {
        return this.currentProperties.getStylePropertyValue(propertyName);
    };
    InputPosition.prototype.getCurrentTextStylePropertyValue = function (propertyName) {
        return this.currentProperties.getTextStylePropertyValue(propertyName);
    };
    InputPosition.prototype.setStylePropertyValue = function (propertyName, value) {
        this.currentProperties.setStylePropertyValue(propertyName, value);
        if (this.selection.isEmpty(true))
            this.defaultProperties.setStylePropertyValue(propertyName, value);
    };
    InputPosition.prototype.setTextStylePropertyValue = function (propertyName, value) {
        this.currentProperties.setTextStylePropertyValue(propertyName, value);
        if (this.selection.isEmpty(true))
            this.defaultProperties.setTextStylePropertyValue(propertyName, value);
    };
    InputPosition.prototype.setInitialStyleProperties = function (style) {
        this.defaultProperties.reset();
        this.currentProperties.reset();
        var styleObj = typeof style === "string" ? Data_1.Data.cssTextToObject(style) : style;
        for (var propertyName in styleObj)
            if (Object.prototype.hasOwnProperty.call(styleObj, propertyName))
                this.initialProperties.setStylePropertyValue(propertyName, styleObj[propertyName]);
    };
    InputPosition.prototype.setInitialTextStyleProperties = function (style) {
        this.defaultProperties.reset();
        this.currentProperties.reset();
        var styleObj = typeof style === "string" ? Data_1.Data.cssTextToObject(style) : style;
        for (var propertyName in styleObj)
            if (Object.prototype.hasOwnProperty.call(styleObj, propertyName))
                this.initialProperties.setTextStylePropertyValue(propertyName, styleObj[propertyName]);
    };
    InputPosition.prototype.notifySelectionChanged = function (selection) {
        this.reset();
    };
    return InputPosition;
}());
exports.InputPosition = InputPosition;


/***/ }),

/***/ 1532:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsCalculatorBase = void 0;
var ConnectorPointsCalculatorBase = (function () {
    function ConnectorPointsCalculatorBase(connector) {
        this.connector = connector;
    }
    return ConnectorPointsCalculatorBase;
}());
exports.ConnectorPointsCalculatorBase = ConnectorPointsCalculatorBase;


/***/ }),

/***/ 1540:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePagePropertyCommand = void 0;
var ModelUtils_1 = __webpack_require__(1922);
var SimpleCommandBase_1 = __webpack_require__(3913);
var ChangePagePropertyCommand = (function (_super) {
    __extends(ChangePagePropertyCommand, _super);
    function ChangePagePropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePagePropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.createHistoryItems(parameter);
        items.forEach(function (item) { _this.control.history.addAndRedo(item); });
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history);
        this.control.history.endTransaction();
        return true;
    };
    ChangePagePropertyCommand.prototype.getItems = function () {
        return null;
    };
    return ChangePagePropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangePagePropertyCommand = ChangePagePropertyCommand;


/***/ }),

/***/ 1548:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageColorCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(1540);
var ChangePageColorHistoryItem_1 = __webpack_require__(3158);
var Model_1 = __webpack_require__(455);
var color_1 = __webpack_require__(9553);
var ChangePageColorCommand = (function (_super) {
    __extends(ChangePageColorCommand, _super);
    function ChangePageColorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageColorCommand.prototype.getValue = function () {
        return color_1.ColorUtils.colorToHash(this.control.model.pageColor);
    };
    ChangePageColorCommand.prototype.getDefaultValue = function () {
        return color_1.ColorUtils.colorToHash(Model_1.DiagramModel.defaultPageColor);
    };
    ChangePageColorCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageColorHistoryItem_1.ChangePageColorHistoryItem(color_1.ColorUtils.fromString(parameter))];
    };
    return ChangePageColorCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageColorCommand = ChangePageColorCommand;


/***/ }),

/***/ 1550:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorEndLineEndingCommand = exports.ChangeConnectorStartLineEndingCommand = void 0;
var ChangeConnectorPropertyCommand_1 = __webpack_require__(2078);
var ConnectorProperties_1 = __webpack_require__(4385);
var ChangeConnectorStartLineEndingCommand = (function (_super) {
    __extends(ChangeConnectorStartLineEndingCommand, _super);
    function ChangeConnectorStartLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyName = function () {
        return "startLineEnding";
    };
    ChangeConnectorStartLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.None;
    };
    return ChangeConnectorStartLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorStartLineEndingCommand = ChangeConnectorStartLineEndingCommand;
var ChangeConnectorEndLineEndingCommand = (function (_super) {
    __extends(ChangeConnectorEndLineEndingCommand, _super);
    function ChangeConnectorEndLineEndingCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyName = function () {
        return "endLineEnding";
    };
    ChangeConnectorEndLineEndingCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineEnding.Arrow;
    };
    return ChangeConnectorEndLineEndingCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorEndLineEndingCommand = ChangeConnectorEndLineEndingCommand;


/***/ }),

/***/ 1581:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DocumentDataSource = exports.UpdateNodeKeyRelatedObjectsStackAction = exports.UpdateNodeKeyRelatedObjectsStackItem = void 0;
var ShapeTypes_1 = __webpack_require__(3255);
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var DataSource_1 = __webpack_require__(8716);
var ModelUtils_1 = __webpack_require__(1922);
var Data_1 = __webpack_require__(2620);
var Utils_1 = __webpack_require__(41);
var string_1 = __webpack_require__(4989);
var math_1 = __webpack_require__(594);
var UpdateNodeKeyRelatedObjectsStackItem = (function () {
    function UpdateNodeKeyRelatedObjectsStackItem(shape, nodeObj) {
        this.shape = shape;
        this.nodeObj = nodeObj;
    }
    return UpdateNodeKeyRelatedObjectsStackItem;
}());
exports.UpdateNodeKeyRelatedObjectsStackItem = UpdateNodeKeyRelatedObjectsStackItem;
var UpdateNodeKeyRelatedObjectsStackAction = (function () {
    function UpdateNodeKeyRelatedObjectsStackAction(kind, nodeObj) {
        this.kind = kind;
        this.nodeObj = nodeObj;
    }
    return UpdateNodeKeyRelatedObjectsStackAction;
}());
exports.UpdateNodeKeyRelatedObjectsStackAction = UpdateNodeKeyRelatedObjectsStackAction;
var DocumentDataSource = (function (_super) {
    __extends(DocumentDataSource, _super);
    function DocumentDataSource(changesListener, nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) {
        var _this = _super.call(this, "Document", nodeDataSource, edgeDataSource, parameters, nodeDataImporter, edgeDataImporter) || this;
        _this.changesListener = changesListener;
        _this.nodeInsertingLockCount = 0;
        _this.updateNodeKeyRelatedObjectsCount = 0;
        _this.updateNodeKeyRelatedObjectsStack = [];
        _this.updateNodeKeyRelatedObjectsStackActions = [];
        return _this;
    }
    DocumentDataSource.prototype.updateItemsByModel = function (model) {
        var _this = this;
        this.beginChangesNotification();
        var nodeNotifications = {
            inserts: [],
            updates: [],
            deletes: []
        };
        this.deleteNodes(model, nodeNotifications);
        model.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                _this.updateNode(model, item, nodeNotifications);
        });
        model.items.forEach(function (item) {
            if (item instanceof Shape_1.Shape)
                _this.updateNodeObjectConnectedProperties(item, _this.findNode(item.dataKey), _this.changesListener);
        });
        this.applyDelayedNodeNotifications(nodeNotifications);
        this.deleteEdges(model);
        model.items.forEach(function (item) {
            if (item instanceof Connector_1.Connector)
                _this.updateEdge(model, item);
        });
        this.endChangesNotification(false);
    };
    DocumentDataSource.prototype.applyDelayedNodeNotifications = function (notification) {
        var _this = this;
        notification.deletes.forEach(function (element) {
            _this.beginChangesNotification();
            _this.changesListener.notifyNodeRemoved.call(_this.changesListener, element[0], element[1].dataObj, function (_key, _data) {
                _this.endChangesNotification(false);
            }, function (_error) {
                _this.endChangesNotification(false);
            });
        });
        notification.inserts.forEach(function (element) {
            _this.beginChangesNotification();
            _this.beginNodeInserting();
            _this.changesListener.notifyNodeInserted.call(_this.changesListener, element[1].dataObj, function (data) {
                _this.updateNodeObjectKey(element[0], element[1], data);
                _this.endNodeInserting();
                _this.endChangesNotification(false);
            }, function (_) {
                _this.endNodeInserting();
                _this.endChangesNotification(false);
            });
        });
        notification.updates.forEach(function (element) {
            _this.beginChangesNotification();
            _this.changesListener.notifyNodeUpdated.call(_this.changesListener, _this.nodeDataImporter.getKey(element[1].dataObj || element[1].key), element[1].dataObj, function (_key, _data) {
                _this.endChangesNotification(false);
            }, function (_error) {
                _this.endChangesNotification(false);
            });
        });
    };
    DocumentDataSource.prototype.isItemObjectModified = function (item, itemObj, importer) {
        var modified = (importer.setLocked && itemObj.locked !== item.locked) ||
            (importer.setZIndex && itemObj.zIndex !== item.zIndex) ||
            (importer.setCustomData && !Utils_1.ObjectUtils.compareObjects(itemObj.customData, item.customData));
        if (!modified && importer.setStyle) {
            var defaultStyle_1 = item.style.getDefaultInstance();
            item.style.forEach(function (key) {
                if (item.style[key] !== defaultStyle_1[key] && item.style[key] !== (itemObj.style && itemObj.style[key]))
                    modified = true;
            });
        }
        if (!modified && importer.setStyleText) {
            var defaultTextStyle_1 = item.styleText.getDefaultInstance();
            item.styleText.forEach(function (key) {
                if (item.styleText[key] !== defaultTextStyle_1[key] && item.styleText[key] !== (itemObj.styleText && itemObj.styleText[key]))
                    modified = true;
            });
        }
        return modified;
    };
    DocumentDataSource.prototype.setDataObjectKeyRelatedProperty = function (method, dataObj, key, allowAutoGeneratedProperty) {
        if (allowAutoGeneratedProperty || this.autoGeneratedDataKeys[key] === undefined)
            method(dataObj, key);
    };
    DocumentDataSource.prototype.updateItemObjectProperties = function (itemObj, item, importer) {
        if (importer.setCustomData) {
            itemObj.customData = Utils_1.ObjectUtils.cloneObject(item.customData);
            if (itemObj.dataObj && itemObj.customData !== undefined)
                importer.setCustomData(itemObj.dataObj, item.customData);
        }
        if (importer.setLocked) {
            itemObj.locked = item.locked;
            if (itemObj.dataObj && itemObj.locked !== undefined)
                importer.setLocked(itemObj.dataObj, item.locked);
        }
        if (importer.setStyle) {
            var styleObj = item.style.toObject();
            itemObj.style = styleObj;
            if (itemObj.dataObj && itemObj.style !== undefined)
                importer.setStyle(itemObj.dataObj, Data_1.Data.objectToCssText(styleObj));
        }
        if (importer.setStyleText) {
            var styleTextObj = item.styleText.toObject();
            itemObj.styleText = styleTextObj;
            if (itemObj.dataObj && itemObj.styleText !== undefined)
                importer.setStyleText(itemObj.dataObj, Data_1.Data.objectToCssText(styleTextObj));
        }
        if (importer.setZIndex) {
            itemObj.zIndex = item.zIndex;
            if (itemObj.dataObj && itemObj.zIndex !== undefined)
                importer.setZIndex(itemObj.dataObj, item.zIndex);
        }
    };
    DocumentDataSource.prototype.deleteItems = function (dataSourceItems, findItem, getParentArray, callback) {
        var items = dataSourceItems.slice();
        items.forEach(function (item) {
            if (item.key !== undefined && item.key !== null && !findItem(item.key)) {
                var parentArray = getParentArray(item);
                var index = parentArray.indexOf(item.dataObj);
                parentArray.splice(index, 1);
                callback(item, index > -1);
            }
        });
    };
    DocumentDataSource.prototype.updateNode = function (model, shape, notifications) {
        var nodeObj = this.findNode(shape.dataKey);
        if (!nodeObj) {
            var dataObj = {};
            if (shape.dataKey !== undefined && shape.dataKey !== null)
                this.nodeDataImporter.setKey(dataObj, shape.dataKey);
            nodeObj = this.addNodeInternal(dataObj, shape.description.key, shape.text);
            this.nodeDataSource.push(nodeObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setKey, dataObj, nodeObj.key, this.addInternalKeyOnInsert);
            this.updateNodeObjectProperties(shape, nodeObj, model.units);
            this.updateNodeObjectConnectedProperties(shape, nodeObj);
            this.updateNodeObjectKey(shape, nodeObj, nodeObj.dataObj);
            notifications.inserts.push([shape, nodeObj]);
        }
        else if (this.isNodeObjectModified(shape, nodeObj, model.units)) {
            this.updateNodeObjectProperties(shape, nodeObj, model.units);
            this.updateNodeObjectConnectedProperties(shape, nodeObj);
            notifications.updates.push([shape, nodeObj]);
        }
        else
            this.updateNodeObjectConnectedProperties(shape, nodeObj, this.changesListener);
    };
    DocumentDataSource.prototype.areImageUrlsEqual = function (url1, url2) {
        return (url1 === url2) ||
            (string_1.StringUtils.isNullOrEmpty(url1) && string_1.StringUtils.isNullOrEmpty(url2));
    };
    DocumentDataSource.prototype.isNodeObjectModified = function (shape, nodeObj, units) {
        return this.isItemObjectModified(shape, nodeObj, this.nodeDataImporter) ||
            (nodeObj.type !== shape.description.key && !(nodeObj.type === undefined && shape.description.key === ShapeTypes_1.ShapeTypes.Rectangle)) ||
            !this.compareStrings(nodeObj.text, shape.text) ||
            (this.nodeDataImporter.setImage && !this.areImageUrlsEqual(nodeObj.image, shape.image.actualUrl)) ||
            (this.nodeDataImporter.setLeft && !math_1.MathUtils.numberCloseTo(nodeObj.left, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.x))) ||
            (this.nodeDataImporter.setTop && !math_1.MathUtils.numberCloseTo(nodeObj.top, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.y))) ||
            (this.nodeDataImporter.setWidth && !math_1.MathUtils.numberCloseTo(nodeObj.width, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.width))) ||
            (this.nodeDataImporter.setHeight && !math_1.MathUtils.numberCloseTo(nodeObj.height, ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.height)));
    };
    DocumentDataSource.prototype.updateNodeObjectProperties = function (shape, nodeObj, units) {
        this.updateItemObjectProperties(nodeObj, shape, this.nodeDataImporter);
        if (this.nodeDataImporter.setType) {
            nodeObj.type = shape.description.key;
            this.nodeDataImporter.setType(nodeObj.dataObj, shape.description.key);
        }
        if (this.nodeDataImporter.setText) {
            nodeObj.text = shape.text;
            this.nodeDataImporter.setText(nodeObj.dataObj, shape.text);
        }
        if (this.nodeDataImporter.setImage) {
            nodeObj.image = shape.image.actualUrl;
            this.nodeDataImporter.setImage(nodeObj.dataObj, shape.image.actualUrl === undefined ? null : shape.image.actualUrl);
        }
        if (this.nodeDataImporter.setLeft) {
            var left = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.x);
            nodeObj.left = left;
            this.nodeDataImporter.setLeft(nodeObj.dataObj, left);
        }
        if (this.nodeDataImporter.setTop) {
            var top_1 = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.position.y);
            nodeObj.top = top_1;
            this.nodeDataImporter.setTop(nodeObj.dataObj, top_1);
        }
        if (this.nodeDataImporter.setWidth) {
            var width = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.width);
            nodeObj.width = width;
            this.nodeDataImporter.setWidth(nodeObj.dataObj, width);
        }
        if (this.nodeDataImporter.setHeight) {
            var height = ModelUtils_1.ModelUtils.getlUnitValue(units, shape.size.height);
            nodeObj.height = height;
            this.nodeDataImporter.setHeight(nodeObj.dataObj, height);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectConnectedProperties = function (shape, nodeObj, changesListener) {
        if (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined) {
            var parentKey = this.getParentItemKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectParentKey(nodeObj, parentItem, changesListener);
        }
        if (this.useNodeContainerId && this.nodeDataImporter.setContainerKey !== undefined) {
            var containerKey = this.getContainerShapeKey(shape);
            var containerItem = this.findNode(containerKey);
            this.updateNodeObjectContainerKey(nodeObj, containerItem, changesListener);
        }
        if (this.useNodeItems && this.nodeDataImporter.setItems !== undefined) {
            var parentKey = this.getParentItemKey(shape);
            var parentItem = this.findNode(parentKey);
            this.updateNodeObjectItems(nodeObj, parentItem, changesListener);
        }
        if (this.useNodeChildren && this.nodeDataImporter.setChildren !== undefined) {
            var containerKey = this.getContainerShapeKey(shape);
            var containerItem = this.findNode(containerKey);
            this.updateNodeObjectChildren(nodeObj, containerItem, changesListener);
        }
    };
    DocumentDataSource.prototype.IsNodeParentIdMode = function () {
        return (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined);
    };
    DocumentDataSource.prototype.IsNodeItemsMode = function () {
        return (this.useNodeItems && this.nodeDataImporter.setItems !== undefined);
    };
    DocumentDataSource.prototype.updateNodeObjectParentKey = function (nodeObj, parentNodeObj, changesListener) {
        var parentKey = this.nodeDataImporter.getParentKey(nodeObj.dataObj);
        var newParentKey = parentNodeObj ? this.nodeDataImporter.getKey(parentNodeObj.dataObj) : undefined;
        if (parentKey !== newParentKey && !(this.isRootParentKey(parentKey) && this.isRootParentKey(newParentKey))) {
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setParentKey, nodeObj.dataObj, newParentKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("shape", nodeObj);
                else
                    this.updateNodeObjectContainerOrParentKeyInternal(nodeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectParentKeyInternal = function (nodeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (_key, _data) {
            _this.endChangesNotification(false);
        }, function (_error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.updateNodeObjectContainerKey = function (nodeObj, containerNodeObj, changesListener) {
        var containerKey = this.nodeDataImporter.getContainerKey(nodeObj.dataObj);
        var newContainerKey = containerNodeObj ? this.nodeDataImporter.getKey(containerNodeObj.dataObj) : undefined;
        if (containerKey !== newContainerKey && !(this.isRootParentKey(containerKey) && this.isRootParentKey(newContainerKey))) {
            this.setDataObjectKeyRelatedProperty(this.nodeDataImporter.setContainerKey, nodeObj.dataObj, newContainerKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("shape", nodeObj);
                else
                    this.updateNodeObjectContainerOrParentKeyInternal(nodeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateNodeObjectContainerOrParentKeyInternal = function (nodeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (_key, _data) {
            _this.endChangesNotification(false);
        }, function (_error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.isRootParentKey = function (key) {
        return key === undefined || key === null || !this.findNode(key);
    };
    DocumentDataSource.prototype.updateNodeObjectItems = function (nodeObj, parentNodeObj, changesListener) {
        var _this = this;
        if (parentNodeObj && nodeObj.parentDataObj !== parentNodeObj.dataObj ||
            !parentNodeObj && nodeObj.parentDataObj)
            if (!parentNodeObj || !this.checkNodeCyrcleItems(nodeObj.dataObj, parentNodeObj.dataObj)) {
                var oldItemsArray = nodeObj.parentDataObj ? this.nodeDataImporter.getItems(nodeObj.parentDataObj) : this.nodeDataSource;
                var index = oldItemsArray.indexOf(nodeObj.dataObj);
                oldItemsArray.splice(index, 1);
                var itemsArray = parentNodeObj ? this.nodeDataImporter.getItems(parentNodeObj.dataObj) : this.nodeDataSource;
                if (!itemsArray)
                    this.nodeDataImporter.setItems(parentNodeObj.dataObj, [nodeObj.dataObj]);
                else
                    itemsArray.push(nodeObj.dataObj);
                nodeObj.parentDataObj = parentNodeObj && parentNodeObj.dataObj;
                if (changesListener) {
                    this.beginChangesNotification();
                    changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (_key, _data) {
                        _this.endChangesNotification(false);
                    }, function (_error) {
                        _this.endChangesNotification(false);
                    });
                }
            }
    };
    DocumentDataSource.prototype.updateNodeObjectChildren = function (nodeObj, containerNodeObj, changesListener) {
        var _this = this;
        if (containerNodeObj && nodeObj.containerDataObj !== containerNodeObj.dataObj ||
            !containerNodeObj && nodeObj.containerDataObj) {
            var oldChildrenArray = nodeObj.containerDataObj ? this.nodeDataImporter.getChildren(nodeObj.containerDataObj) : this.nodeDataSource;
            var index = oldChildrenArray.indexOf(nodeObj.dataObj);
            oldChildrenArray.splice(index, 1);
            var childrenArray = containerNodeObj ? this.nodeDataImporter.getChildren(containerNodeObj.dataObj) : this.nodeDataSource;
            if (!childrenArray)
                this.nodeDataImporter.setChildren(containerNodeObj.dataObj, [nodeObj.dataObj]);
            else
                childrenArray.push(nodeObj.dataObj);
            nodeObj.containerDataObj = containerNodeObj && containerNodeObj.dataObj;
            if (changesListener) {
                this.beginChangesNotification();
                changesListener.notifyNodeUpdated.call(changesListener, this.nodeDataImporter.getKey(nodeObj.dataObj) || nodeObj.key, nodeObj.dataObj, function (_key, _data) {
                    _this.endChangesNotification(false);
                }, function (_error) {
                    _this.endChangesNotification(false);
                });
            }
        }
    };
    DocumentDataSource.prototype.checkNodeCyrcleItems = function (nodeDataObj, parentDataObjCandidate) {
        var _this = this;
        var result = false;
        var items = this.nodeDataImporter.getItems(nodeDataObj);
        if (items)
            items.forEach(function (childDataObj) {
                result = result || childDataObj === parentDataObjCandidate ||
                    _this.checkNodeCyrcleItems(childDataObj, parentDataObjCandidate);
            });
        return result;
    };
    DocumentDataSource.prototype.updateNodeObjectKey = function (shape, nodeObj, dataObj) {
        var key = this.nodeDataImporter.getKey(dataObj);
        var dataKeyChanged = false;
        if (key !== undefined && key !== null && key !== nodeObj.key) {
            delete this.autoGeneratedDataKeys[nodeObj.key];
            nodeObj.key = key;
            dataKeyChanged = true;
        }
        shape.dataKey = nodeObj.key;
        if (nodeObj.dataObj !== dataObj) {
            var parentArray = this.getNodeArray(nodeObj);
            var index = parentArray.indexOf(nodeObj.dataObj);
            parentArray.splice(index, 1, dataObj);
            nodeObj.dataObj = dataObj;
        }
        if (dataKeyChanged)
            this.updateNodeKeyRelatedObjects(shape, nodeObj);
    };
    DocumentDataSource.prototype.updateNodeKeyRelatedObjects = function (shape, nodeObj) {
        var _this = this;
        if (this.isInNodeInserting()) {
            this.addToUpdateNodeKeyRelatedObjectsStack(shape, nodeObj);
            return;
        }
        if (this.useNodeParentId && this.nodeDataImporter.setParentKey !== undefined) {
            var childItems = this.getChildItems(shape);
            childItems.forEach(function (item) {
                var childNodeObj = _this.findNode(item.dataKey);
                if (childNodeObj)
                    _this.updateNodeObjectParentKey(childNodeObj, nodeObj, _this.changesListener);
            });
        }
        if (this.useNodeContainerId && this.nodeDataImporter.setContainerKey !== undefined)
            shape.children.forEach(function (item) {
                var childNodeObj = item instanceof Shape_1.Shape ? _this.findNode(item.dataKey) : undefined;
                if (childNodeObj)
                    _this.updateNodeObjectContainerKey(childNodeObj, nodeObj, _this.changesListener);
            });
        if (this.useEdgesArray())
            shape.attachedConnectors.forEach(function (connector) {
                var edgeObj = _this.findEdge(connector.dataKey);
                if (edgeObj) {
                    if (shape === connector.beginItem)
                        _this.updateEdgeObjectFromProperty(nodeObj, edgeObj, _this.changesListener);
                    if (shape === connector.endItem)
                        _this.updateEdgeObjectToProperty(nodeObj, edgeObj, _this.changesListener);
                }
            });
    };
    DocumentDataSource.prototype.deleteNodes = function (model, notifications) {
        var _this = this;
        this.deleteItems(this.nodes, function (key) { return model.findShapeByDataKey(key); }, function (item) { return _this.getNodeArray(item); }, function (item, dataModified) {
            var key = (item.dataObj && _this.nodeDataImporter.getKey(item.dataObj)) || item.key;
            var nodeObj = _this.findNode(key);
            if (nodeObj)
                _this.nodes.splice(_this.nodes.indexOf(nodeObj), 1);
            if (dataModified)
                notifications.deletes.push([key, item]);
        });
    };
    DocumentDataSource.prototype.getParentItem = function (shape) {
        for (var i = 0; i < shape.attachedConnectors.length; i++)
            if (shape.attachedConnectors[i].endItem === shape)
                return shape.attachedConnectors[i].beginItem;
    };
    DocumentDataSource.prototype.getParentItemKey = function (shape) {
        var parent = this.getParentItem(shape);
        return parent && parent.dataKey;
    };
    DocumentDataSource.prototype.getNodeArray = function (item) {
        var items;
        if (this.useNodeItems && item.parentDataObj)
            items = this.nodeDataImporter.getItems(item.parentDataObj);
        else if (item.containerDataObj)
            items = this.nodeDataImporter.getChildren(item.containerDataObj);
        return items || this.nodeDataSource;
    };
    DocumentDataSource.prototype.getContainerShapeKey = function (shape) {
        return shape.container && shape.container.dataKey;
    };
    DocumentDataSource.prototype.getChildItems = function (shape) {
        var items = [];
        for (var i = 0; i < shape.attachedConnectors.length; i++)
            if (shape.attachedConnectors[i].beginItem === shape)
                if (shape.attachedConnectors[i].endItem)
                    items.push(shape.attachedConnectors[i].endItem);
        return items;
    };
    DocumentDataSource.prototype.updateEdge = function (model, connector) {
        var _this = this;
        var beginDataKey = connector.beginItem ? connector.beginItem.dataKey : undefined;
        var endDataKey = connector.endItem ? connector.endItem.dataKey : undefined;
        var edgeObj = this.findEdge(connector.dataKey);
        if (!edgeObj) {
            var dataObj = this.useEdgesArray() && this.canUpdateEdgeDataSource ? {} : undefined;
            if (dataObj && connector.dataKey !== undefined && connector.dataKey !== null)
                this.edgeDataImporter.setKey(dataObj, connector.dataKey);
            edgeObj = this.addEdgeInternal(dataObj, beginDataKey, endDataKey);
            if (dataObj) {
                this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setKey, dataObj, edgeObj.key, this.addInternalKeyOnInsert);
                this.edgeDataSource.push(edgeObj.dataObj);
            }
            this.updateEdgeObjectProperties(connector, edgeObj, model.units);
            this.updateEdgeObjectKey(connector, edgeObj, edgeObj.dataObj);
            if (dataObj) {
                this.beginChangesNotification();
                this.beginNodeInserting();
                this.changesListener.notifyEdgeInserted.call(this.changesListener, edgeObj.dataObj, function (data) {
                    _this.updateEdgeObjectKey(connector, edgeObj, data);
                    _this.endNodeInserting();
                    _this.endChangesNotification(false);
                }, function (_error) {
                    _this.endNodeInserting();
                    _this.endChangesNotification(false);
                });
            }
        }
        else if (this.isEdgeObjectModified(connector, edgeObj, model.units)) {
            this.updateEdgeObjectProperties(connector, edgeObj, model.units);
            if (edgeObj.dataObj) {
                this.beginChangesNotification();
                this.changesListener.notifyEdgeUpdated.call(this.changesListener, this.edgeDataImporter.getKey(edgeObj.dataObj) || edgeObj.key, edgeObj.dataObj, function (_key, _data) {
                    _this.endChangesNotification(false);
                }, function (_error) {
                    _this.endChangesNotification(false);
                });
            }
        }
    };
    DocumentDataSource.prototype.isEdgeObjectModified = function (connector, edgeObj, units) {
        return this.isItemObjectModified(connector, edgeObj, this.edgeDataImporter) ||
            (edgeObj.from !== null ? edgeObj.from : undefined) !== (connector.beginItem ? connector.beginItem.dataKey : undefined) ||
            (edgeObj.to === null ? undefined : edgeObj.to) !== (connector.endItem ? connector.endItem.dataKey : undefined) ||
            (this.edgeDataImporter.setFromPointIndex && edgeObj.fromPointIndex !== connector.beginConnectionPointIndex) ||
            (this.edgeDataImporter.setToPointIndex && edgeObj.toPointIndex !== connector.endConnectionPointIndex) ||
            (this.edgeDataImporter.setPoints && (!edgeObj.points ||
                !this.pointsAreEqual(edgeObj.points.map(function (ptObj) { return ptObj.x; }), connector.points.map(function (pt) { return ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x); })) ||
                !this.pointsAreEqual(edgeObj.points.map(function (ptObj) { return ptObj.y; }), connector.points.map(function (pt) { return ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y); })))) ||
            (this.edgeDataImporter.setText && !this.compareTexts(edgeObj, connector)) ||
            (this.edgeDataImporter.setLineOption && edgeObj.lineOption !== connector.properties.lineOption) ||
            (this.edgeDataImporter.setStartLineEnding && edgeObj.startLineEnding !== connector.properties.startLineEnding) ||
            (this.edgeDataImporter.setEndLineEnding && edgeObj.endLineEnding !== connector.properties.endLineEnding);
    };
    DocumentDataSource.prototype.pointsAreEqual = function (a, b) {
        var aLen = a.length;
        var bLen = a.length;
        if (aLen !== bLen)
            return false;
        for (var i = 0; i < aLen; i++)
            if (!math_1.MathUtils.numberCloseTo(a[i], b[i]))
                return false;
        return true;
    };
    DocumentDataSource.prototype.updateEdgeObjectFromProperty = function (fromObj, edgeObj, changesListener) {
        edgeObj.from = fromObj && fromObj.key;
        if (edgeObj.dataObj) {
            var fromKey = fromObj && fromObj.dataObj && this.nodeDataImporter.getKey(fromObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setFrom, edgeObj.dataObj, fromKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("edge", edgeObj);
                else
                    this.updateEdgeObjectFromOrToPropertyInternal(edgeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectFromOrToPropertyInternal = function (edgeObj, changesListener) {
        var _this = this;
        this.beginChangesNotification();
        changesListener.notifyEdgeUpdated.call(changesListener, this.nodeDataImporter.getKey(edgeObj.dataObj) || edgeObj.key, edgeObj.dataObj, function (_key, _data) {
            _this.endChangesNotification(false);
        }, function (_error) {
            _this.endChangesNotification(false);
        });
    };
    DocumentDataSource.prototype.updateEdgeObjectToProperty = function (toObj, edgeObj, changesListener) {
        edgeObj.to = toObj && toObj.key;
        if (edgeObj.dataObj) {
            var toKey = toObj && toObj.dataObj && this.nodeDataImporter.getKey(toObj.dataObj);
            this.setDataObjectKeyRelatedProperty(this.edgeDataImporter.setTo, edgeObj.dataObj, toKey, false);
            if (changesListener)
                if (this.isInUpdateNodeKeyRelatedObjects())
                    this.addToUpdateNodeKeyRelatedObjectsStackAction("edge", edgeObj);
                else
                    this.updateEdgeObjectFromOrToPropertyInternal(edgeObj, changesListener);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectProperties = function (connector, edgeObj, units) {
        this.updateItemObjectProperties(edgeObj, connector, this.edgeDataImporter);
        if (this.edgeDataImporter.setFrom) {
            var fromObj = this.findNode(connector.beginItem && connector.beginItem.dataKey);
            this.updateEdgeObjectFromProperty(fromObj, edgeObj);
        }
        if (this.edgeDataImporter.setTo) {
            var toObj = this.findNode(connector.endItem && connector.endItem.dataKey);
            this.updateEdgeObjectToProperty(toObj, edgeObj);
        }
        if (this.edgeDataImporter.setFromPointIndex) {
            edgeObj.fromPointIndex = connector.beginConnectionPointIndex;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setFromPointIndex(edgeObj.dataObj, connector.beginConnectionPointIndex);
        }
        if (this.edgeDataImporter.setToPointIndex) {
            edgeObj.toPointIndex = connector.endConnectionPointIndex;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setToPointIndex(edgeObj.dataObj, connector.endConnectionPointIndex);
        }
        if (this.edgeDataImporter.setPoints) {
            var points = connector.points.map(function (pt) {
                return {
                    x: ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x),
                    y: ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y)
                };
            });
            edgeObj.points = points;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setPoints(edgeObj.dataObj, points);
        }
        if (this.edgeDataImporter.setText) {
            var text = void 0;
            if (connector.getTextCount() === 1 && connector.getText())
                text = connector.getText();
            var texts_1 = {};
            connector.texts.forEach(function (text) {
                texts_1[text.position] = text.value;
            });
            edgeObj.texts = texts_1;
            if (edgeObj.dataObj) {
                var textVal = "";
                if (text)
                    textVal = text;
                else if (texts_1 && Object.keys(texts_1).length)
                    textVal = texts_1;
                this.edgeDataImporter.setText(edgeObj.dataObj, textVal);
            }
        }
        if (this.edgeDataImporter.setLineOption) {
            edgeObj.lineOption = connector.properties.lineOption;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setLineOption(edgeObj.dataObj, connector.properties.lineOption);
        }
        if (this.edgeDataImporter.setStartLineEnding) {
            edgeObj.startLineEnding = connector.properties.startLineEnding;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setStartLineEnding(edgeObj.dataObj, connector.properties.startLineEnding);
        }
        if (this.edgeDataImporter.setEndLineEnding) {
            edgeObj.endLineEnding = connector.properties.endLineEnding;
            if (edgeObj.dataObj)
                this.edgeDataImporter.setEndLineEnding(edgeObj.dataObj, connector.properties.endLineEnding);
        }
    };
    DocumentDataSource.prototype.updateEdgeObjectKey = function (connector, edgeObj, dataObj) {
        var key = dataObj && this.edgeDataImporter.getKey(dataObj);
        if (key !== undefined && key !== null && key !== edgeObj.key) {
            delete this.autoGeneratedDataKeys[edgeObj.key];
            edgeObj.key = key;
        }
        connector.dataKey = edgeObj.key;
        if (edgeObj.dataObj !== dataObj) {
            var parentArray = this.edgeDataSource;
            var index = parentArray.indexOf(edgeObj.dataObj);
            parentArray.splice(index, 1, dataObj);
            edgeObj.dataObj = dataObj;
        }
    };
    DocumentDataSource.prototype.deleteEdges = function (model) {
        var _this = this;
        this.deleteItems(this.edges, function (key) { return model.findConnectorByDataKey(key); }, function (_item) { return _this.edgeDataSource; }, function (item, dataModified) {
            var key = (item.dataObj && _this.edgeDataImporter.getKey(item.dataObj)) || item.key;
            var edgeObj = _this.findEdge(key);
            if (edgeObj)
                _this.edges.splice(_this.edges.indexOf(edgeObj), 1);
            if (dataModified) {
                _this.beginChangesNotification();
                _this.changesListener.notifyEdgeRemoved.call(_this.changesListener, key, item.dataObj, function (_key, _data) {
                    _this.endChangesNotification(false);
                }, function (_error) {
                    _this.endChangesNotification(false);
                });
            }
        });
    };
    DocumentDataSource.prototype.beginNodeInserting = function () {
        this.nodeInsertingLockCount++;
    };
    DocumentDataSource.prototype.endNodeInserting = function () {
        this.nodeInsertingLockCount--;
        if (this.nodeInsertingLockCount === 0)
            this.raiseNodeInsertingStack();
    };
    DocumentDataSource.prototype.isInNodeInserting = function () {
        return this.nodeInsertingLockCount > 0;
    };
    DocumentDataSource.prototype.addToUpdateNodeKeyRelatedObjectsStack = function (shape, nodeObj) {
        var item = new UpdateNodeKeyRelatedObjectsStackItem(shape, nodeObj);
        this.updateNodeKeyRelatedObjectsStack.push(item);
    };
    DocumentDataSource.prototype.raiseNodeInsertingStack = function () {
        this.beginUpdateNodeKeyRelatedObjects();
        while (this.updateNodeKeyRelatedObjectsStack.length > 0) {
            var item = this.updateNodeKeyRelatedObjectsStack[0];
            this.updateNodeKeyRelatedObjects(item.shape, item.nodeObj);
            this.updateNodeKeyRelatedObjectsStack.splice(0, 1);
            if (item.shape.description.hasTemplate && item.nodeObj)
                this.changesListener.reloadInsertedItem(item.nodeObj.key);
        }
        this.endUpdateNodeKeyRelatedObjects();
    };
    DocumentDataSource.prototype.beginUpdateNodeKeyRelatedObjects = function () {
        this.updateNodeKeyRelatedObjectsCount++;
    };
    DocumentDataSource.prototype.endUpdateNodeKeyRelatedObjects = function () {
        this.updateNodeKeyRelatedObjectsCount--;
        if (this.updateNodeKeyRelatedObjectsCount === 0)
            this.raiseUpdateNodeKeyRelatedObjectsStack();
    };
    DocumentDataSource.prototype.isInUpdateNodeKeyRelatedObjects = function () {
        return this.updateNodeKeyRelatedObjectsCount > 0;
    };
    DocumentDataSource.prototype.addToUpdateNodeKeyRelatedObjectsStackAction = function (kind, nodeObj) {
        var item = new UpdateNodeKeyRelatedObjectsStackAction(kind, nodeObj);
        for (var i = 0; i < this.updateNodeKeyRelatedObjectsStackActions.length; i++)
            if ((this.updateNodeKeyRelatedObjectsStackActions[i].kind === kind) && (this.updateNodeKeyRelatedObjectsStackActions[i].nodeObj === nodeObj))
                return;
        this.updateNodeKeyRelatedObjectsStackActions.push(item);
    };
    DocumentDataSource.prototype.raiseUpdateNodeKeyRelatedObjectsStack = function () {
        while (this.updateNodeKeyRelatedObjectsStackActions.length > 0) {
            var item = this.updateNodeKeyRelatedObjectsStackActions[0];
            switch (item.kind) {
                case "shape":
                    this.updateNodeObjectContainerOrParentKeyInternal(item.nodeObj, this.changesListener);
                    break;
                case "edge":
                    this.updateEdgeObjectFromOrToPropertyInternal(item.nodeObj, this.changesListener);
                    break;
            }
            this.updateNodeKeyRelatedObjectsStackActions.splice(0, 1);
        }
    };
    DocumentDataSource.prototype.beginChangesNotification = function () {
        this.changesListener.beginChangesNotification();
    };
    DocumentDataSource.prototype.endChangesNotification = function (preventNotifyChanges) {
        this.changesListener.endChangesNotification(preventNotifyChanges);
    };
    return DocumentDataSource;
}(DataSource_1.DataSource));
exports.DocumentDataSource = DocumentDataSource;


/***/ }),

/***/ 1616:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorState = void 0;
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerDragDiagramItemStateBase_1 = __webpack_require__(9993);
var MouseHandlerMoveConnectorState = (function (_super) {
    __extends(MouseHandlerMoveConnectorState, _super);
    function MouseHandlerMoveConnectorState(handler, history, model, selection, visualizerManager) {
        var _this = _super.call(this, handler, history, model, selection, visualizerManager) || this;
        _this.model = model;
        _this.selection = selection;
        _this.visualizerManager = visualizerManager;
        return _this;
    }
    Object.defineProperty(MouseHandlerMoveConnectorState.prototype, "areValidDraggingShapes", {
        get: function () {
            return true;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(MouseHandlerMoveConnectorState.prototype, "areValidDraggingConnectors", {
        get: function () {
            var _this = this;
            if (this.shouldClone)
                return this.dragHelper.draggingShapes.length > 0 || this.dragHelper.draggingConnectors.length > 0;
            if (!this.dragHelper.draggingConnectors.length)
                return false;
            if (!this.dragHelper.draggingShapes.length)
                return !this.dragHelper.draggingConnectors.some(function (x) { return !ModelUtils_1.ModelUtils.canMoveConnector(_this.dragHelper.selectedItems, x.connector); });
            return ModelUtils_1.ModelUtils.canMoveConnector(this.dragHelper.selectedItems, this.dragHelper.draggingConnectors[this.dragHelper.draggingConnectorsIndexByKey[this.handler.mouseDownEvent.source.key]].connector);
        },
        enumerable: false,
        configurable: true
    });
    return MouseHandlerMoveConnectorState;
}(MouseHandlerDragDiagramItemStateBase_1.MouseHandlerDragDiagramItemStateBase));
exports.MouseHandlerMoveConnectorState = MouseHandlerMoveConnectorState;


/***/ }),

/***/ 1659:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToolboxManager = void 0;
var TextToolbox_1 = __webpack_require__(2651);
var IconToolbox_1 = __webpack_require__(481);
var TextMeasurer_1 = __webpack_require__(6727);
var math_1 = __webpack_require__(594);
var ToolboxManager = (function () {
    function ToolboxManager(shapeDescriptionManager) {
        this.shapeDescriptionManager = shapeDescriptionManager;
        this.toolboxes = [];
        this.measurers = {};
    }
    ToolboxManager.prototype.create = function (parent, readOnly, allowDragging, renderAsText, shapes, getAllowedShapeTypes, instanceId, options) {
        var shapeTypes = Array.isArray(shapes) ? shapes : this.shapeDescriptionManager.getTypesByCategory(shapes);
        var toolbox = renderAsText ?
            new TextToolbox_1.TextToolbox(parent, readOnly, allowDragging, this.shapeDescriptionManager, shapeTypes, getAllowedShapeTypes) :
            new IconToolbox_1.IconToolbox(parent, readOnly, allowDragging, this.shapeDescriptionManager, shapeTypes, getAllowedShapeTypes, options, this.getOrCreateMeasurer(parent), instanceId);
        toolbox.render();
        this.toolboxes.push(toolbox);
        return toolbox;
    };
    ToolboxManager.prototype.clean = function (removeElement, toolbox) {
        var _this = this;
        if (toolbox) {
            toolbox.clean(removeElement);
            this.toolboxes.splice(this.toolboxes.indexOf(toolbox), 1);
            Object.keys(this.measurers).forEach(function (key) {
                if (_this.measurers[key] === toolbox.measurer)
                    delete _this.measurers[key];
            });
        }
        else {
            for (var i = 0; i < this.toolboxes.length; i++)
                this.toolboxes[i].clean(removeElement);
            this.toolboxes = [];
            this.measurers = {};
        }
    };
    ToolboxManager.prototype.refresh = function (toolboxes) {
        this.toolboxes.forEach(function (toolbox, index) {
            if (!toolboxes || (Array.isArray(toolboxes) && toolboxes.indexOf(index) > -1) || index === toolboxes)
                toolbox.render();
        });
    };
    ToolboxManager.prototype.applyFilter = function (str, toolboxes) {
        var _this = this;
        return this.toolboxes.reduce(function (aggr, toolbox, index) {
            if (!toolboxes || (Array.isArray(toolboxes) && toolboxes.indexOf(index) > -1) || index === toolboxes)
                toolbox.render(function (shapeType) { return _this.searchFilter(shapeType, str, index); }) && aggr.push(index);
            return aggr;
        }, []);
    };
    ToolboxManager.prototype.searchFilter = function (shapeType, str, toolboxIndex, filteringToolboxes) {
        if (!str || (filteringToolboxes && filteringToolboxes.indexOf(toolboxIndex) === -1))
            return true;
        str = str.toLowerCase();
        var shapeDescription = this.shapeDescriptionManager.get(shapeType);
        return shapeDescription.getTitle().toLowerCase().indexOf(str) > -1 ||
            shapeDescription.getDefaultText().toLowerCase().indexOf(str) > -1;
    };
    ToolboxManager.prototype.getOrCreateMeasurer = function (parent) {
        var id = parent.getAttribute("data-dxdiMeasurerID");
        if (!id || !this.measurers[id]) {
            id = math_1.MathUtils.generateGuid();
            this.measurers[id] = new TextMeasurer_1.TextMeasurer(parent);
            parent.setAttribute("data-dxdiMeasurerID", id);
        }
        return this.measurers[id];
    };
    return ToolboxManager;
}());
exports.ToolboxManager = ToolboxManager;


/***/ }),

/***/ 1675:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeTextEventArgs = exports.ChangeShapeTextRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var ChangeShapeTextRequestedEntity = (function (_super) {
    __extends(ChangeShapeTextRequestedEntity, _super);
    function ChangeShapeTextRequestedEntity(apiController, shape, text) {
        var _this = _super.call(this, apiController) || this;
        _this.shape = shape;
        _this.text = text;
        return _this;
    }
    Object.defineProperty(ChangeShapeTextRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.ChangeShapeText;
        },
        enumerable: false,
        configurable: true
    });
    ChangeShapeTextRequestedEntity.prototype.createEventArgs = function () {
        return new ChangeShapeTextEventArgs(this.apiController.createNativeShape(this.shape), this.text);
    };
    Object.defineProperty(ChangeShapeTextRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "changeShapeText";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChangeShapeTextRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.shape && this.shape.key);
        },
        enumerable: false,
        configurable: true
    });
    ChangeShapeTextRequestedEntity.prototype.equals = function (other) {
        if (other instanceof ChangeShapeTextRequestedEntity)
            return this.shape === other.shape && this.text === other.text;
        return false;
    };
    return ChangeShapeTextRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.ChangeShapeTextRequestedEntity = ChangeShapeTextRequestedEntity;
var ChangeShapeTextEventArgs = (function (_super) {
    __extends(ChangeShapeTextEventArgs, _super);
    function ChangeShapeTextEventArgs(shape, text) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        _this.text = text;
        return _this;
    }
    return ChangeShapeTextEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.ChangeShapeTextEventArgs = ChangeShapeTextEventArgs;


/***/ }),

/***/ 1684:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeLockedHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangeLockedHistoryItem = (function (_super) {
    __extends(ChangeLockedHistoryItem, _super);
    function ChangeLockedHistoryItem(item, locked) {
        var _this = _super.call(this) || this;
        _this.itemKey = item.key;
        _this.locked = locked;
        return _this;
    }
    ChangeLockedHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldLocked = item.locked;
        manipulator.changeLocked(item, this.locked);
    };
    ChangeLockedHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeLocked(item, this.oldLocked);
    };
    return ChangeLockedHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeLockedHistoryItem = ChangeLockedHistoryItem;


/***/ }),

/***/ 1785:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var DeleteShapeHistoryItem = (function (_super) {
    __extends(DeleteShapeHistoryItem, _super);
    function DeleteShapeHistoryItem(shapeKey, allowed) {
        if (allowed === void 0) { allowed = true; }
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.allowed = allowed;
        return _this;
    }
    DeleteShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.shape = shape.clone();
        manipulator.deleteShape(shape, this.allowed);
    };
    DeleteShapeHistoryItem.prototype.undo = function (manipulator) {
        manipulator.addShape(this.shape, this.shape.key);
    };
    return DeleteShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.DeleteShapeHistoryItem = DeleteShapeHistoryItem;


/***/ }),

/***/ 1833:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TriangleShapeDescription = void 0;
var ShapeDescription_1 = __webpack_require__(1280);
var PathPrimitive_1 = __webpack_require__(6208);
var ShapeTypes_1 = __webpack_require__(3255);
var ConnectionPoint_1 = __webpack_require__(4856);
var DiagramItem_1 = __webpack_require__(4824);
var rectangle_1 = __webpack_require__(4412);
var size_1 = __webpack_require__(3844);
var TriangleShapeDescription = (function (_super) {
    __extends(TriangleShapeDescription, _super);
    function TriangleShapeDescription(hasDefaultText) {
        var _this = _super.call(this, undefined, hasDefaultText) || this;
        _this.defaultSize.height = _this.calculateHeight(ShapeDescription_1.ShapeDefaultDimension);
        return _this;
    }
    Object.defineProperty(TriangleShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Triangle; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(TriangleShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    TriangleShapeDescription.prototype.createConnectionPoints = function () {
        return [
            new ConnectionPoint_1.ConnectionPoint(0.5, 0, DiagramItem_1.ConnectionPointSide.North),
            new ConnectionPoint_1.ConnectionPoint(0.75, 0.5, DiagramItem_1.ConnectionPointSide.East),
            new ConnectionPoint_1.ConnectionPoint(0.5, 1, DiagramItem_1.ConnectionPointSide.South),
            new ConnectionPoint_1.ConnectionPoint(0.25, 0.5, DiagramItem_1.ConnectionPointSide.West)
        ];
    };
    TriangleShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(rect.center.x, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    TriangleShapeDescription.prototype.calculateHeight = function (width) {
        return Math.sqrt(Math.pow(width, 2) - Math.pow(width / 2, 2));
    };
    TriangleShapeDescription.prototype.getTextRectangle = function (shape) {
        return new rectangle_1.Rectangle(shape.position.x + shape.size.width / 4, shape.position.y + shape.size.height / 2, shape.size.width / 2, shape.size.height / 2 - ShapeDescription_1.ShapeTextPadding)
            .nonNegativeSize();
    };
    TriangleShapeDescription.prototype.getSizeByText = function (textSize, _shape) {
        return new size_1.Size(textSize.width * 2, textSize.height * 2 + ShapeDescription_1.ShapeTextPadding);
    };
    return TriangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.TriangleShapeDescription = TriangleShapeDescription;


/***/ }),

/***/ 1842:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.getLineHeight = exports.getTextHeight = exports.getTextLineSize = exports.getOptimalTextRectangle = exports.TEXTRECT_RATIO_EPS = exports.textToParagraphs = exports.textToWords = exports.wordsByLines = exports.LINE_HEIGHT = void 0;
var Utils_1 = __webpack_require__(41);
var size_1 = __webpack_require__(3844);
var Data_1 = __webpack_require__(2620);
var WHITESPACES = /\s/gm;
exports.LINE_HEIGHT = 1.05;
function wordsByLines(absLineWidth, words, measureWords) {
    if (words.length === 1)
        return words;
    var measuredWords = measureWords();
    var spaceWidth = measuredWords.words[" "].width;
    var result = [];
    var lastLineWidth = 0;
    var lastLineIndex = -1;
    for (var i = 0; i < words.length; i++) {
        var word = words[i];
        var wordWidth = measuredWords.words[word].width;
        if (lastLineIndex === -1 || lastLineWidth + spaceWidth + wordWidth > absLineWidth) {
            lastLineIndex = result.push(word) - 1;
            lastLineWidth = wordWidth;
        }
        else {
            lastLineWidth += spaceWidth + wordWidth;
            result[lastLineIndex] += " " + word;
        }
    }
    return result;
}
exports.wordsByLines = wordsByLines;
function textToWords(text) {
    return text.split(WHITESPACES).filter(function (t) { return t.length; });
}
exports.textToWords = textToWords;
function textToParagraphs(text) {
    return text.split("\n");
}
exports.textToParagraphs = textToParagraphs;
exports.TEXTRECT_RATIO_EPS = 1.2;
var TEXTRECT_WIDTH_DIFF_EPS = 1;
function getOptimalTextRectangle(text, style, owner, measurer, initialSize, keepRatio, minWidth, maxWidth, minHeight, maxHeight) {
    if (minWidth === void 0) { minWidth = 0; }
    if (maxWidth === void 0) { maxWidth = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE; }
    if (minHeight === void 0) { minHeight = 0; }
    if (maxHeight === void 0) { maxHeight = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE; }
    if (!text)
        return new size_1.Size(Data_1.Data.byRange(initialSize.width, minWidth, maxWidth), Data_1.Data.byRange(initialSize.height, minHeight, maxHeight));
    if (minWidth > maxWidth || minHeight > maxHeight)
        throw new Error("Min size cannot exceed max size");
    if (minWidth === maxWidth && minHeight === maxHeight)
        return new size_1.Size(minWidth, minHeight);
    var measureResult = measurer.measureWords(text, style, owner);
    var paragraphs = textToParagraphs(text);
    var maxWordWidth = Object.keys(measureResult.words).reduce(function (acc, word) { return Math.max(acc, measureResult.words[word].width); }, 0);
    var xRange = new Utils_1.Range(Data_1.Data.byRange(Math.max(initialSize.width, maxWordWidth), minWidth, maxWidth), maxWidth);
    var yRange = new Utils_1.Range(Data_1.Data.byRange(initialSize.height, minHeight, maxHeight), maxHeight);
    if (maxWordWidth <= initialSize.width && getTextHeight(paragraphs, initialSize.width, measureResult, false) <= initialSize.height && xRange.includes(initialSize.width) && yRange.includes(initialSize.height))
        return initialSize;
    var ratio = initialSize.width / initialSize.height;
    return getOptimalTextRectangleCore(paragraphs, measureResult, ratio, xRange, yRange, keepRatio);
}
exports.getOptimalTextRectangle = getOptimalTextRectangle;
function getOptimalTextRectangleCore(paragraphs, measureResult, initRatio, xRange, yRange, incHeightToRatio) {
    var _a;
    var maxParagraphWidth = paragraphs.reduce(function (acc, val) { return Math.max(acc, getTextLineSize(val, measureResult).width); }, 0);
    var size = new size_1.Size(0, 0);
    var newSize = new size_1.Size(0, 0);
    var newFitToHeight;
    var deltaWidth = 0;
    var error = 0;
    for (var attempt = 0; attempt < 5; attempt++) {
        if (attempt === 0)
            newSize.width = calcByFit(maxParagraphWidth, xRange)[0];
        else if (Math.abs(deltaWidth) > TEXTRECT_WIDTH_DIFF_EPS)
            newSize.width = calcByFit(size.width + deltaWidth, xRange)[0];
        else
            break;
        _a = calcHeight(paragraphs, newSize.width, measureResult, yRange), newSize.height = _a[0], newFitToHeight = _a[1];
        if (attempt === 0) {
            size = newSize.clone();
            error = (size.width / size.height) / initRatio;
        }
        if (attempt === 0 && !newFitToHeight)
            break;
        var newRatio = (newSize.width / newSize.height);
        var newError = newRatio / initRatio;
        if (attempt === 0)
            deltaWidth = (newSize.width / newError - newSize.width) / 2;
        else if (!newFitToHeight)
            deltaWidth /= 2;
        else if (!compareRatio(initRatio, newRatio, exports.TEXTRECT_RATIO_EPS)) {
            size = newSize.clone();
            error = newError;
            break;
        }
        else if (compareRatio(error, newError, 1) < 0) {
            size = newSize.clone();
            error = newError;
            deltaWidth = (newSize.width / newError - newSize.width) / 2;
            if (newError < 1)
                deltaWidth /= 2;
        }
        else
            break;
    }
    if (incHeightToRatio)
        size.height = Data_1.Data.byRange(size.width / initRatio, size.height, yRange.to);
    return size;
}
function compareRatio(a, b, eps) {
    var an = a < 1 ? 1 / a : a;
    var bn = b < 1 ? 1 / b : b;
    var e = an / bn;
    var en = e < 1 ? 1 / e : e;
    return en <= eps ? 0 : bn > an ? 1 : -1;
}
function calcHeight(paragraphs, width, measureResult, yRange) {
    var height = getTextHeight(paragraphs, width, measureResult, false);
    return calcByFit(height, yRange);
}
function calcByFit(value, range) {
    return [
        Data_1.Data.byRange(value, range.from, range.to),
        value <= range.to
    ];
}
function getTextLineSize(text, measureResult) {
    var words = textToWords(text);
    return words.reduce(function (acc, word, index) {
        var wordSize = measureResult.words[word];
        acc.width += wordSize.width;
        acc.height = Math.max(acc.height, wordSize.height);
        if (index > 0)
            acc.width += measureResult.words[" "].width;
        return acc;
    }, new size_1.Size(0, 0));
}
exports.getTextLineSize = getTextLineSize;
function getTextHeight(textOrParagraphs, width, measureResult, emptyTextAsSingleLine) {
    var paragraphs = Array.isArray(textOrParagraphs) ? textOrParagraphs : textToParagraphs(textOrParagraphs);
    if (emptyTextAsSingleLine && (!paragraphs.length || (paragraphs.length === 1 && !paragraphs[0].length)))
        return getLineHeight(measureResult);
    return paragraphs.reduce(function (acc, line) { return acc + wordsByLines(width, textToWords(line), function () { return measureResult; }).length; }, 0) * getLineHeight(measureResult);
}
exports.getTextHeight = getTextHeight;
function getLineHeight(measureResult) {
    return measureResult.fontSize * exports.LINE_HEIGHT;
}
exports.getLineHeight = getLineHeight;


/***/ }),

/***/ 1851:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFontBoldCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(3210);
var ToggleFontBoldCommand = (function (_super) {
    __extends(ToggleFontBoldCommand, _super);
    function ToggleFontBoldCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontBoldCommand.prototype.getStyleProperty = function () {
        return "font-weight";
    };
    ToggleFontBoldCommand.prototype.getStylePropertyValue = function () {
        return "bold";
    };
    return ToggleFontBoldCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontBoldCommand = ToggleFontBoldCommand;


/***/ }),

/***/ 1891:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteConnectorEventArgs = exports.DeleteConnectorRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var DeleteConnectorRequestedEntity = (function (_super) {
    __extends(DeleteConnectorRequestedEntity, _super);
    function DeleteConnectorRequestedEntity(apiController, connector) {
        var _this = _super.call(this, apiController) || this;
        _this.connector = connector;
        return _this;
    }
    Object.defineProperty(DeleteConnectorRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.DeleteConnector;
        },
        enumerable: false,
        configurable: true
    });
    DeleteConnectorRequestedEntity.prototype.createEventArgs = function () {
        return new DeleteConnectorEventArgs(this.apiController.createNativeConnector(this.connector));
    };
    Object.defineProperty(DeleteConnectorRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "deleteConnector";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DeleteConnectorRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.connector && this.connector.key);
        },
        enumerable: false,
        configurable: true
    });
    DeleteConnectorRequestedEntity.prototype.equals = function (other) {
        if (other instanceof DeleteConnectorRequestedEntity)
            return this.connector === other.connector;
        return false;
    };
    return DeleteConnectorRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.DeleteConnectorRequestedEntity = DeleteConnectorRequestedEntity;
var DeleteConnectorEventArgs = (function (_super) {
    __extends(DeleteConnectorEventArgs, _super);
    function DeleteConnectorEventArgs(connector) {
        var _this = _super.call(this) || this;
        _this.connector = connector;
        return _this;
    }
    return DeleteConnectorEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.DeleteConnectorEventArgs = DeleteConnectorEventArgs;


/***/ }),

/***/ 1893:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeVerticalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8674);
var WideTree_1 = __webpack_require__(8533);
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutTreeVerticalCommand = (function (_super) {
    __extends(AutoLayoutTreeVerticalCommand, _super);
    function AutoLayoutTreeVerticalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeVerticalCommand.prototype.createLayoutSettings = function () {
        var gridSize = this.control.settings.snapToGrid ? this.control.settings.gridSize : undefined;
        var settings = new LayoutSettings_1.TreeLayoutSettings(gridSize);
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Vertical;
        return settings;
    };
    AutoLayoutTreeVerticalCommand.prototype.createLayout = function (settings, graph) {
        return new WideTree_1.TreeLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutTreeVerticalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutTreeVerticalCommand = AutoLayoutTreeVerticalCommand;


/***/ }),

/***/ 1914:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorTextHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangeConnectorTextHistoryItem = (function (_super) {
    __extends(ChangeConnectorTextHistoryItem, _super);
    function ChangeConnectorTextHistoryItem(connector, position, text) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.text = text;
        _this.position = position;
        return _this;
    }
    ChangeConnectorTextHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldText = connector.getText(this.position);
        manipulator.changeConnectorText(connector, this.text, this.position);
    };
    ChangeConnectorTextHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorText(connector, this.oldText, this.position);
    };
    return ChangeConnectorTextHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextHistoryItem = ChangeConnectorTextHistoryItem;


/***/ }),

/***/ 1917:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeSnapToGridCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(3913);
var ChangeSnapToGridCommand = (function (_super) {
    __extends(ChangeSnapToGridCommand, _super);
    function ChangeSnapToGridCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeSnapToGridCommand.prototype.executeCore = function (state, parameter) {
        var newValue = parameter === undefined ? !this.control.settings.snapToGrid : !!parameter;
        if (this.control.settings.snapToGrid !== newValue) {
            this.control.settings.snapToGrid = newValue;
            return true;
        }
        return false;
    };
    ChangeSnapToGridCommand.prototype.getValue = function () {
        return this.control.settings.snapToGrid;
    };
    return ChangeSnapToGridCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeSnapToGridCommand = ChangeSnapToGridCommand;


/***/ }),

/***/ 1922:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModelUtils = void 0;
var unit_converter_1 = __webpack_require__(9500);
var metrics_1 = __webpack_require__(4496);
var point_1 = __webpack_require__(5327);
var rectangle_1 = __webpack_require__(4412);
var size_1 = __webpack_require__(3844);
var vector_1 = __webpack_require__(4166);
var math_1 = __webpack_require__(594);
var Enums_1 = __webpack_require__(9254);
var AddConnectionHistoryItem_1 = __webpack_require__(4139);
var AddConnectorHistoryItem_1 = __webpack_require__(4048);
var AddConnectorPointHistoryItem_1 = __webpack_require__(8226);
var AddShapeHistoryItem_1 = __webpack_require__(8214);
var ChangeConnectorPointsHistoryItem_1 = __webpack_require__(8818);
var ChangeShapeParametersHistoryItem_1 = __webpack_require__(7489);
var DeleteConnectionHistoryItem_1 = __webpack_require__(6155);
var DeleteConnectorHistoryItem_1 = __webpack_require__(7392);
var DeleteShapeHistoryItem_1 = __webpack_require__(1785);
var InsertToContainerHistoryItem_1 = __webpack_require__(5323);
var MoveConnectorPointHistoryItem_1 = __webpack_require__(6904);
var MoveShapeHistoryItem_1 = __webpack_require__(3312);
var RemoveFromContainerHistoryItem_1 = __webpack_require__(7271);
var ResizeShapeHistoryItem_1 = __webpack_require__(5685);
var SetSelectionHistoryItem_1 = __webpack_require__(6512);
var ModelResizeHistoryItem_1 = __webpack_require__(6035);
var UpdatePositionsOnPageResizeHistoryItem_1 = __webpack_require__(4715);
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(2448);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(1914);
var ChangeCustomDataHistoryItem_1 = __webpack_require__(9735);
var ChangeLockedHistoryItem_1 = __webpack_require__(1684);
var ChangeStyleHistoryItem_1 = __webpack_require__(3550);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(5755);
var Graph_1 = __webpack_require__(9071);
var GraphInfo_1 = __webpack_require__(3903);
var Structures_1 = __webpack_require__(8573);
var Utils_1 = __webpack_require__(41);
var Connector_1 = __webpack_require__(6320);
var ConnectorProperties_1 = __webpack_require__(4385);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ConnectorRenderPointsContext_1 = __webpack_require__(5359);
var Shape_1 = __webpack_require__(8408);
var ChangeShapeTypeHistoryItem_1 = __webpack_require__(2389);
var ModelUtils = (function () {
    function ModelUtils() {
    }
    ModelUtils.setShapePosition = function (history, model, shape, newPosition, includeChildren) {
        if (includeChildren === void 0) { includeChildren = true; }
        if (!shape.position.equals(newPosition)) {
            var delta_1 = newPosition.clone().offset(-shape.position.x, -shape.position.y);
            history.addAndRedo(new MoveShapeHistoryItem_1.MoveShapeHistoryItem(shape.key, newPosition));
            if (includeChildren)
                shape.children.forEach(function (child) {
                    if (child instanceof Shape_1.Shape) {
                        var childPosition = child.position.clone().offset(delta_1.x, delta_1.y);
                        ModelUtils.setShapePosition(history, model, child, childPosition);
                    }
                });
            return true;
        }
        return false;
    };
    ModelUtils.setShapeSize = function (history, model, shape, newPosition, newSize) {
        if (!shape.size.equals(newSize) || !shape.position.equals(newPosition)) {
            history.addAndRedo(new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(shape.key, newPosition, newSize));
            return true;
        }
        return false;
    };
    ModelUtils.addConnectorPoint = function (history, connectorKey, pointIndex, position) {
        history.addAndRedo(new AddConnectorPointHistoryItem_1.AddConnectorPointHistoryItem(connectorKey, pointIndex, position));
    };
    ModelUtils.deleteConnectorCustomPoints = function (history, connector) {
        if (connector.points.length > 2) {
            var oldContext = connector.tryCreateRenderPointsContext();
            if (connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight || !oldContext)
                history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ReplaceConnectorPointsHistoryItem(connector.key, [
                    connector.points[0].clone(),
                    connector.points[connector.points.length - 1].clone()
                ]));
            else {
                var beginPoint = connector.points[0].clone();
                var lastPoint = connector.points[connector.points.length - 1].clone();
                history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ChangeConnectorPointsHistoryItem(connector.key, [beginPoint, lastPoint], new ConnectorRenderPointsContext_1.ConnectorRenderPointsContext([
                    new ConnectorRenderPoint_1.ConnectorRenderPoint(beginPoint.x, beginPoint.y, 0),
                    new ConnectorRenderPoint_1.ConnectorRenderPoint(lastPoint.x, lastPoint.y, 1)
                ], false, oldContext.actualRoutingMode)));
            }
        }
    };
    ModelUtils.deleteConnectorUnnecessaryPoints = function (history, connector) {
        var oldRenderPoints = connector.getRenderPoints(true).map(function (p) { return p.clone(); });
        if (connector.properties.lineOption === ConnectorProperties_1.ConnectorLineOption.Straight) {
            var unnecessaryPoints = ModelUtils.createUnnecessaryRenderPoints(oldRenderPoints.filter(function (p) { return !p.skipped; }).map(function (p) { return p.clone(); }), connector.skippedRenderPoints, function (removedPoint) { return ModelUtils.findFirstPointIndex(oldRenderPoints, function (p) { return ConnectorRenderPoint_1.ConnectorRenderPoint.equal(p, removedPoint); }); });
            if (Object.keys(unnecessaryPoints).length)
                history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ReplaceConnectorPointsHistoryItem(connector.key, ModelUtils.createNecessaryPoints(connector.points.map(function (p) { return p.clone(); }), unnecessaryPoints)));
        }
        else {
            var oldContext = connector.tryCreateRenderPointsContext(true);
            var newRenderPoints = oldRenderPoints.filter(function (p) { return !p.skipped; }).map(function (p) { return p.clone(); });
            var unnecessaryPoints = ModelUtils.createUnnecessaryRightAngleRenderPoints(newRenderPoints, connector.skippedRenderPoints, function (removedPoint) { return ModelUtils.findFirstPointIndex(oldRenderPoints, function (p) { return ConnectorRenderPoint_1.ConnectorRenderPoint.equal(p, removedPoint); }); });
            if (Object.keys(unnecessaryPoints).length) {
                var newPoints = ModelUtils.createNecessaryPoints(connector.points.map(function (p) { return p.clone(); }), unnecessaryPoints);
                var newRenderContext = new ConnectorRenderPointsContext_1.ConnectorRenderPointsContext(ModelUtils.validateRenderPointIndexes(newPoints, newRenderPoints, 0), oldContext.lockCreateRenderPoints, oldContext.actualRoutingMode);
                history.addAndRedo(new ChangeConnectorPointsHistoryItem_1.ChangeConnectorPointsHistoryItem(connector.key, newPoints, newRenderContext));
            }
        }
    };
    ModelUtils.fixConnectorBeginEndConnectionIndex = function (history, connector) {
        if (connector.beginItem && connector.beginConnectionPointIndex === -1) {
            var beginConnectionPointIndex = connector.beginItem.getNearestConnectionPoint(connector.points[0]);
            history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, beginConnectionPointIndex, Connector_1.ConnectorPosition.Begin));
        }
        if (connector.endItem && connector.endConnectionPointIndex === -1) {
            var endConnectionPointIndex = connector.endItem.getNearestConnectionPoint(connector.points[connector.points.length - 1]);
            history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, endConnectionPointIndex, Connector_1.ConnectorPosition.End));
        }
    };
    ModelUtils.skipUnnecessaryRenderPoints = function (points, removeExcessPoints) {
        Utils_1.GeometryUtils.removeUnnecessaryPoints(points, function (pt, index) { return ModelUtils.removeUnnecessaryPoint(points, pt, index, removeExcessPoints); }, function (pt) { return pt !== undefined && !pt.skipped; });
        points[0].skipped = false;
        points[points.length - 1].skipped = false;
    };
    ModelUtils.skipUnnecessaryRightAngleRenderPoints = function (points, removeExcessPoints) {
        Utils_1.GeometryUtils.removeUnnecessaryRightAnglePoints(points, function (p, index) { return ModelUtils.removeUnnecessaryPoint(points, p, index, removeExcessPoints); }, function (p) { return p !== undefined && !p.skipped; });
        points[0].skipped = false;
        points[points.length - 1].skipped = false;
    };
    ModelUtils.createUnnecessaryRenderPoints = function (renderPointsWithoutSkipped, skippedRenderPoints, getPosition, predicate) {
        if (predicate === void 0) { predicate = function (_) { return true; }; }
        var result = {};
        Utils_1.GeometryUtils.removeUnnecessaryPoints(renderPointsWithoutSkipped, function (removedPoint, removedIndex) {
            return ModelUtils.collectNotSkippedRenderPoints(result, renderPointsWithoutSkipped, removedPoint, removedIndex, getPosition, predicate);
        });
        ModelUtils.collectSkippedRenderPoints(result, skippedRenderPoints, getPosition, predicate);
        return result;
    };
    ModelUtils.createUnnecessaryRightAngleRenderPoints = function (renderPointsWithoutSkipped, skippedRenderPoints, getPosition, predicate) {
        if (predicate === void 0) { predicate = function (_) { return true; }; }
        var result = {};
        Utils_1.GeometryUtils.removeUnnecessaryRightAnglePoints(renderPointsWithoutSkipped, function (removedPoint, removedIndex) {
            return ModelUtils.collectNotSkippedRenderPoints(result, renderPointsWithoutSkipped, removedPoint, removedIndex, getPosition, predicate);
        });
        ModelUtils.collectSkippedRenderPoints(result, skippedRenderPoints, getPosition, predicate);
        return result;
    };
    ModelUtils.createNecessaryPoints = function (points, unnecessaryPoints) {
        var _this = this;
        var result = [];
        var lastPointIndex = points.length - 1;
        points.forEach(function (p, index) {
            if (index === 0 || index === lastPointIndex || _this.isNecessaryPoint(p, index, unnecessaryPoints))
                result.push(p.clone());
        });
        return result;
    };
    ModelUtils.isNecessaryPoint = function (point, pointIndex, unnecessaryPoints) {
        return !Object.keys(unnecessaryPoints).some(function (key) {
            var unnecessaryPoint = unnecessaryPoints[key];
            return unnecessaryPoint.pointIndex === pointIndex && Utils_1.GeometryUtils.areDuplicatedPoints(point, unnecessaryPoint);
        });
    };
    ModelUtils.collectSkippedRenderPoints = function (targetRenderPoints, skippedRenderPoints, getPosition, predicate) {
        if (predicate === void 0) { predicate = function (_) { return true; }; }
        skippedRenderPoints && skippedRenderPoints.forEach(function (skippedPoint) {
            if (predicate(skippedPoint)) {
                var positionIndex = getPosition(skippedPoint);
                if (targetRenderPoints[positionIndex] === undefined)
                    targetRenderPoints[positionIndex] = skippedPoint;
            }
        });
    };
    ModelUtils.collectNotSkippedRenderPoints = function (targetRenderPoints, sourceRenderPoints, removedPoint, removedIndex, getPosition, predicate) {
        if (predicate === void 0) { predicate = function (_) { return true; }; }
        if (predicate(removedPoint)) {
            var positionIndex = getPosition(removedPoint);
            if (targetRenderPoints[positionIndex] === undefined) {
                targetRenderPoints[positionIndex] = removedPoint;
                removedPoint.skipped = true;
                sourceRenderPoints.splice(removedIndex, 1);
                return true;
            }
        }
        return false;
    };
    ModelUtils.removeUnnecessaryPoint = function (points, point, removedIndex, removeExcessPoints) {
        if (removeExcessPoints && point.pointIndex === -1) {
            points.splice(removedIndex, 1);
            return true;
        }
        point.skipped = true;
        return false;
    };
    ModelUtils.validateRenderPointIndexes = function (points, renderPoints, startIndex) {
        var _this = this;
        var result = renderPoints.map(function (rp, i) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(rp.x, rp.y, i >= startIndex && rp.pointIndex >= 0 ? _this.findFirstPointIndex(points, function (p) { return p.equals(rp); }) : rp.pointIndex, rp.skipped); });
        result[0].skipped = false;
        result[result.length - 1].skipped = false;
        return result;
    };
    ModelUtils.findFirstPointIndex = function (points, predicate) {
        if (!points || !predicate)
            return -1;
        for (var i = 0; i < points.length; i++)
            if (predicate(points[i]))
                return i;
        return -1;
    };
    ModelUtils.moveConnectorRightAnglePoints = function (history, connector, firstPointIndex, lastPointIndex, newX, newY) {
        if (!connector.points.slice(firstPointIndex, lastPointIndex + 1).some(function (p) { return !Utils_1.GeometryUtils.areDuplicatedPoints(p, new point_1.Point(newX === undefined ? p.x : newX, newY === undefined ? p.y : newY)); }))
            return;
        history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorRightAnglePointsHistoryItem(connector.key, firstPointIndex, lastPointIndex, newX, newY));
    };
    ModelUtils.moveConnectorPoint = function (history, connector, pointIndex, newPosition) {
        if (!connector.points[pointIndex].equals(newPosition)) {
            history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(connector.key, pointIndex, newPosition));
            return true;
        }
        return false;
    };
    ModelUtils.updateConnectorAttachedPoints = function (history, model, connector) {
        history.beginTransaction();
        var beginContainer = connector.beginItem && model.findItemCollapsedContainer(connector.beginItem);
        var beginAttachedToContainer = beginContainer && (!connector.endItem || !model.isContainerItem(beginContainer, connector.endItem));
        var endContainer = connector.endItem && model.findItemCollapsedContainer(connector.endItem);
        var endAttachedToContainer = endContainer && (!connector.beginItem || !model.isContainerItem(endContainer, connector.beginItem));
        var changed = false;
        if (beginAttachedToContainer)
            changed = this.updateConnectorBeginPoint(history, connector, beginContainer, (endAttachedToContainer && endContainer) || connector.endItem, function (index) { return beginContainer.getConnectionPointIndexForItem(connector.beginItem, index); }) || changed;
        else
            changed = this.updateConnectorBeginPoint(history, connector, connector.beginItem, (endAttachedToContainer && endContainer) || connector.endItem) || changed;
        if (endAttachedToContainer)
            changed = this.updateConnectorEndPoint(history, connector, endContainer, function (index) { return endContainer.getConnectionPointIndexForItem(connector.beginItem, index); }) || changed;
        else
            changed = this.updateConnectorEndPoint(history, connector, connector.endItem) || changed;
        history.endTransaction();
        return changed;
    };
    ModelUtils.updateConnectorBeginPoint = function (history, connector, beginItem, endItem, getConnectionPointIndex) {
        if (beginItem) {
            var connectionPointIndex = getConnectionPointIndex !== undefined ?
                getConnectionPointIndex(connector.beginConnectionPointIndex) : connector.beginConnectionPointIndex;
            var targetPoint = connector.points[1];
            if (endItem && connector.points.length === 2)
                if (connector.endConnectionPointIndex !== -1)
                    targetPoint = endItem.getConnectionPointPosition(connector.endConnectionPointIndex, point_1.Point.zero());
                else
                    targetPoint = endItem.rectangle.center;
            var newPoint = beginItem.getConnectionPointPosition(connectionPointIndex, targetPoint);
            return this.moveConnectorPoint(history, connector, 0, newPoint.clone());
        }
    };
    ModelUtils.updateConnectorEndPoint = function (history, connector, endItem, getConnectionPointIndex) {
        if (endItem) {
            var connectionPointIndex = getConnectionPointIndex !== undefined ?
                getConnectionPointIndex(connector.endConnectionPointIndex) : connector.endConnectionPointIndex;
            var newPoint = endItem.getConnectionPointPosition(connectionPointIndex, connector.points[connector.points.length - 2]);
            return this.moveConnectorPoint(history, connector, connector.points.length - 1, newPoint);
        }
    };
    ModelUtils.updateContainerConnectorsAttachedPoints = function (history, model, rootContainer, container) {
        var _this = this;
        if (container === void 0) { container = rootContainer; }
        history.beginTransaction();
        var children = model.getChildren(container);
        children.forEach(function (child) {
            if (child instanceof Shape_1.Shape) {
                child.attachedConnectors.forEach(function (connector) {
                    var beginItemInContainer = connector.beginItem && model.isContainerItem(container, connector.beginItem);
                    var endItemInContainer = connector.endItem && model.isContainerItem(container, connector.endItem);
                    if (beginItemInContainer && !endItemInContainer) {
                        var collapsedContainer = model.findItemTopCollapsedContainer(connector.beginItem);
                        var endCollapsedContainer = connector.endItem && model.findItemTopCollapsedContainer(connector.endItem);
                        if (!collapsedContainer)
                            _this.updateConnectorBeginPoint(history, connector, connector.beginItem, endCollapsedContainer || connector.endItem);
                        else
                            _this.updateConnectorBeginPoint(history, connector, collapsedContainer, endCollapsedContainer || connector.endItem, function (index) { return rootContainer.getConnectionPointIndexForItem(connector.beginItem, index); });
                    }
                    if (endItemInContainer && !beginItemInContainer) {
                        var collapsedContainer = model.findItemTopCollapsedContainer(connector.endItem);
                        if (!collapsedContainer)
                            _this.updateConnectorEndPoint(history, connector, connector.endItem);
                        else
                            _this.updateConnectorEndPoint(history, connector, collapsedContainer, function (index) { return rootContainer.getConnectionPointIndexForItem(connector.endItem, index); });
                    }
                });
                _this.updateContainerConnectorsAttachedPoints(history, model, rootContainer, child);
            }
        });
        history.endTransaction();
    };
    ModelUtils.getConnectorsWithoutBeginItemInfo = function (model) {
        var connectors = model.findConnectorsWithoutBeginItem();
        return connectors.map(function (c) {
            return {
                connector: c,
                point: c.points[0].clone()
            };
        });
    };
    ModelUtils.getConnectorsWithoutEndItemInfo = function (model) {
        var connectors = model.findConnectorsWithoutEndItem();
        return connectors.map(function (c) {
            return {
                connector: c,
                point: c.points[c.points.length - 1].clone()
            };
        });
    };
    ModelUtils.updateShapeAttachedConnectors = function (history, model, shape) {
        var _this = this;
        shape.attachedConnectors.forEach(function (connector) {
            _this.tryRemoveConnectorIntermediatePoints(history, connector);
            _this.updateConnectorAttachedPoints(history, model, connector);
        });
    };
    ModelUtils.updateMovingShapeConnections = function (history, shape, beginPointsInfo, endPointsInfo, resetTargetCallback, updateTargetCallback, beforeAttachConnectorCallback) {
        var _this = this;
        resetTargetCallback();
        beginPointsInfo.forEach(function (pi) {
            var connectionPointIndex = _this.getMovingShapeConnectionPointIndex(shape, pi.point);
            if (shape.rectangle.containsPoint(pi.point) || connectionPointIndex > -1) {
                updateTargetCallback(shape, connectionPointIndex);
                if (connectionPointIndex !== pi.connector.beginConnectionPointIndex && pi.connector.beginItem)
                    history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(pi.connector, Connector_1.ConnectorPosition.Begin));
                beforeAttachConnectorCallback(pi.connector);
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(pi.connector, shape, connectionPointIndex, Connector_1.ConnectorPosition.Begin));
            }
            else if (pi.connector.beginItem) {
                history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(pi.connector, Connector_1.ConnectorPosition.Begin));
                history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(pi.connector.key, 0, pi.point));
            }
        });
        endPointsInfo.forEach(function (pi) {
            var connectionPointIndex = _this.getMovingShapeConnectionPointIndex(shape, pi.point);
            if (shape.rectangle.containsPoint(pi.point) || connectionPointIndex > -1) {
                updateTargetCallback(shape, connectionPointIndex);
                if (connectionPointIndex !== pi.connector.endConnectionPointIndex && pi.connector.endItem)
                    history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(pi.connector, Connector_1.ConnectorPosition.End));
                beforeAttachConnectorCallback(pi.connector);
                history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(pi.connector, shape, connectionPointIndex, Connector_1.ConnectorPosition.End));
            }
            else if (pi.connector.endItem) {
                history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(pi.connector, Connector_1.ConnectorPosition.End));
                history.addAndRedo(new MoveConnectorPointHistoryItem_1.MoveConnectorPointHistoryItem(pi.connector.key, pi.connector.points.length - 1, pi.point));
            }
        });
    };
    ModelUtils.getMovingShapeConnectionPointIndex = function (shape, point) {
        var _this = this;
        var connectionPointIndex = -1;
        shape.getConnectionPoints().forEach(function (pt, index) {
            if (metrics_1.Metrics.euclideanDistance(point, pt) < _this.connectionPointActionSize)
                connectionPointIndex = index;
        });
        return connectionPointIndex;
    };
    ModelUtils.shouldRemoveConnectorIntermediatePoints = function (connector, shapes) {
        if (connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal || connector.points.length === 2 || !shapes || !shapes.length)
            return false;
        var index = 0;
        var shape;
        while (shape = shapes[index]) {
            if (this.isShapeIntersectConnectorCustomPoints(shape, connector))
                return true;
            index++;
        }
        return false;
    };
    ModelUtils.tryRemoveConnectorIntermediatePoints = function (history, connector) {
        if (this.shouldRemoveConnectorIntermediatePoints(connector, [connector.beginItem, connector.endItem]))
            this.deleteConnectorCustomPoints(history, connector);
    };
    ModelUtils.isShapeIntersectConnectorCustomPoints = function (shape, connector) {
        if (!shape)
            return false;
        var customRenderPoints = connector.getCustomRenderPoints(true);
        if (!customRenderPoints.length)
            return false;
        var offset = Connector_1.Connector.minOffset - unit_converter_1.UnitConverter.pixelsToTwips(1);
        return Utils_1.GeometryUtils.areIntersectedSegments(Utils_1.GeometryUtils.createSegments(customRenderPoints), Utils_1.GeometryUtils.createSegmentsFromRectangle(shape.rectangle.clone().inflate(offset, offset)));
    };
    ModelUtils.getSnappedPos = function (model, gridSize, pos, isHorizontal) {
        var snapOffset = isHorizontal ? model.snapStartPoint.x : model.snapStartPoint.y;
        return Math.round((pos - snapOffset) / gridSize) * gridSize + snapOffset;
    };
    ModelUtils.tryUpdateModelRectangle = function (history, processPoints) {
        var offset = history.modelManipulator.getModelSizeUpdateOffset();
        if (!offset.isEmpty()) {
            history.addAndRedo(new ModelResizeHistoryItem_1.ModelResizeHistoryItem(offset));
            if (offset.left || offset.top) {
                history.addAndRedo(new UpdatePositionsOnPageResizeHistoryItem_1.UpdatePositionsOnPageResizeHistoryItem(new vector_1.Vector(offset.left, offset.top)));
                if (processPoints !== undefined)
                    processPoints(offset.left, offset.top);
            }
            history.modelManipulator.raiseModelRectangleChanged(history.modelManipulator.model.getRectangle(true));
        }
    };
    ModelUtils.deleteItems = function (history, model, selection, items, deleteLocked) {
        history.beginTransaction();
        var itemsHash = {};
        items.forEach(function (item) { return itemsHash[item.key] = item; });
        var selectionKeys = selection.getKeys().filter(function (key) { return !itemsHash[key]; });
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, selectionKeys));
        this.deleteItemsCore(history, model, items, deleteLocked);
        this.tryUpdateModelRectangle(history);
        history.endTransaction();
    };
    ModelUtils.deleteItemsCore = function (history, model, items, deleteLocked) {
        var _this = this;
        items.sort(function (a, b) {
            var v1 = (a instanceof Connector_1.Connector) ? 0 : 1;
            var v2 = (b instanceof Connector_1.Connector) ? 0 : 1;
            return v1 - v2;
        });
        items.forEach(function (item) {
            if (item.container)
                _this.removeFromContainer(history, model, item);
            if (item instanceof Shape_1.Shape) {
                var children = model.getChildren(item);
                if (children.length) {
                    children.forEach(function (child) {
                        history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(child));
                        _this.updateAttachedConnectorsContainer(history, model, child);
                    });
                    _this.deleteItemsCore(history, model, children.filter(function (child) { return !child.locked || deleteLocked; }), deleteLocked);
                }
                if (model.findItem(item.key))
                    _this.deleteShape(history, item);
            }
            if (item instanceof Connector_1.Connector)
                if (model.findItem(item.key))
                    _this.deleteConnector(history, item);
        });
    };
    ModelUtils.detachConnectors = function (history, shape) {
        history.beginTransaction();
        while (shape.attachedConnectors.length > 0) {
            var connector = shape.attachedConnectors[0];
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, connector.beginItem === shape ? Connector_1.ConnectorPosition.Begin : Connector_1.ConnectorPosition.End));
        }
        history.endTransaction();
    };
    ModelUtils.deleteShape = function (history, shape) {
        var allowed = history.modelManipulator.permissionsProvider.canDeleteItems([shape]);
        history.beginTransaction();
        this.detachConnectors(history, shape);
        history.addAndRedo(new DeleteShapeHistoryItem_1.DeleteShapeHistoryItem(shape.key, allowed));
        history.endTransaction();
    };
    ModelUtils.deleteConnector = function (history, connector) {
        history.beginTransaction();
        if (connector.beginItem)
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.Begin));
        if (connector.endItem)
            history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(connector, Connector_1.ConnectorPosition.End));
        history.addAndRedo(new DeleteConnectorHistoryItem_1.DeleteConnectorHistoryItem(connector.key));
        history.endTransaction();
    };
    ModelUtils.deleteAllItems = function (history, model, selection) {
        this.deleteItems(history, model, selection, model.items.slice(), true);
    };
    ModelUtils.deleteSelection = function (history, model, selection) {
        this.deleteItems(history, model, selection, selection.getSelectedItems());
    };
    ModelUtils.changeSelectionLocked = function (history, model, selection, locked) {
        history.beginTransaction();
        var items = selection.getSelectedItems(true);
        items.forEach(function (item) {
            history.addAndRedo(new ChangeLockedHistoryItem_1.ChangeLockedHistoryItem(item, locked));
        });
        ModelUtils.updateSelection(history, selection);
        history.endTransaction();
    };
    ModelUtils.copyStylesToItem = function (history, model, fromItem, newItemKey) {
        var toItem = model.findItem(newItemKey);
        fromItem.styleText.forEach(function (propertyName) {
            if (fromItem.styleText[propertyName] !== toItem.styleText[propertyName])
                history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(newItemKey, propertyName, fromItem.styleText[propertyName]));
        });
        fromItem.style.forEach(function (propertyName) {
            if (fromItem.style[propertyName] !== toItem.style[propertyName])
                history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(newItemKey, propertyName, fromItem.style[propertyName]));
        });
    };
    ModelUtils.updateSelection = function (history, selection) {
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, selection.getKeys(), true));
    };
    ModelUtils.cloneShapeToOffset = function (history, model, shape, dx, dy) {
        history.beginTransaction();
        var newPosition = shape.position.clone().offset(dx, dy);
        var addHistoryItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(shape.description, newPosition, shape.text);
        history.addAndRedo(addHistoryItem);
        var newKey = addHistoryItem.shapeKey;
        history.addAndRedo(new ResizeShapeHistoryItem_1.ResizeShapeHistoryItem(newKey, newPosition, shape.size.clone()));
        history.addAndRedo(new ChangeCustomDataHistoryItem_1.ChangeCustomDataHistoryItem(newKey, Utils_1.ObjectUtils.cloneObject(shape.customData)));
        history.addAndRedo(new ChangeShapeParametersHistoryItem_1.ChangeShapeParametersHistoryItem(newKey, shape.parameters.clone()));
        this.copyStylesToItem(history, model, shape, newKey);
        history.endTransaction();
        return newKey;
    };
    ModelUtils.applyOffsetToConnectorRenderPointsContext = function (context, dx, dy) {
        return context && context.renderPoints ? new ConnectorRenderPointsContext_1.ConnectorRenderPointsContext(context.renderPoints.map(function (p) { return p.clone().offset(dx, dy); }), true, context.actualRoutingMode) : undefined;
    };
    ModelUtils.cloneConnectorToOffset = function (history, model, connector, beginItemKey, endItemKey, dx, dy) {
        history.beginTransaction();
        var newPoints = connector.points.map(function (p) { return p.clone().offset(dx, dy); });
        var addHistoryItem = new AddConnectorHistoryItem_1.AddConnectorHistoryItem(newPoints, undefined, this.applyOffsetToConnectorRenderPointsContext(connector.tryCreateRenderPointsContext(), dx, dy));
        history.addAndRedo(addHistoryItem);
        var newKey = addHistoryItem.connectorKey;
        var newConnector = model.findConnector(newKey);
        connector.properties.forEach(function (propertyName) {
            if (connector.properties[propertyName] !== newConnector.properties[propertyName])
                history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(newKey, propertyName, connector.properties[propertyName]));
        });
        if (beginItemKey) {
            var from = model.findShape(beginItemKey);
            history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(newConnector, from, connector.beginConnectionPointIndex, Connector_1.ConnectorPosition.Begin));
        }
        if (endItemKey) {
            var to = model.findShape(endItemKey);
            history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(newConnector, to, connector.endConnectionPointIndex, Connector_1.ConnectorPosition.End));
        }
        var newTexts = connector.texts.clone();
        newTexts.forEach(function (connectorText) {
            history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(newConnector, connectorText.position, connectorText.value));
        });
        this.copyStylesToItem(history, model, connector, newKey);
        history.endTransaction();
        return newKey;
    };
    ModelUtils.cloneSelectionToOffset = function (history, model, onItemAdded, selection, dx, dy) {
        var _this = this;
        history.beginTransaction();
        var newShapes = {};
        var ids = [];
        selection.getSelectedShapes().forEach(function (shape) {
            var newKey = _this.cloneShapeToOffset(history, model, shape, dx, dy);
            newShapes[shape.key] = newKey;
            ids.push(newKey);
            if (onItemAdded)
                onItemAdded(newKey);
        });
        selection.getSelectedConnectors().forEach(function (connector) {
            var beginItemKey = connector.beginItem ? newShapes[connector.beginItem.key] : null;
            var endItemKey = connector.endItem ? newShapes[connector.endItem.key] : null;
            var newKey = _this.cloneConnectorToOffset(history, model, connector, beginItemKey, endItemKey, dx, dy);
            ids.push(newKey);
            if (onItemAdded)
                onItemAdded(newKey);
        });
        history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(selection, ids));
        ModelUtils.tryUpdateModelRectangle(history);
        history.endTransaction();
    };
    ModelUtils.findContainerByEventKey = function (model, selection, key) {
        var container = model.findContainer(key);
        if (container && !container.isLocked)
            return container;
        else {
            var shape = model.findShape(key);
            if (shape && shape.container && !selection.hasKey(shape.key))
                return ModelUtils.findContainerByEventKey(model, selection, shape.container.key);
        }
    };
    ModelUtils.canInsertToContainer = function (model, item, container) {
        if (item === container)
            return false;
        if (item instanceof Shape_1.Shape)
            if (model.findChild(item, container.key))
                return false;
        return true;
    };
    ModelUtils.canInsertSelectionToContainer = function (model, selection, container) {
        var result = true;
        selection.getSelectedItems().forEach(function (item) {
            if (item === container) {
                result = false;
                return;
            }
            if (item instanceof Shape_1.Shape)
                if (model.findChild(item, container.key)) {
                    result = false;
                    return;
                }
        });
        return result;
    };
    ModelUtils.insertToContainer = function (history, model, item, container) {
        if (!container.enableChildren)
            throw Error("Inpossible to add children to non-container shape.");
        if (!this.canInsertToContainer(model, item, container))
            return;
        var oldContainer = item.container;
        if (oldContainer !== container) {
            history.beginTransaction();
            if (oldContainer) {
                history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
                item.attachedConnectors.forEach(function (connector) {
                    if (connector.container)
                        history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(connector));
                });
            }
            history.addAndRedo(new InsertToContainerHistoryItem_1.InsertToContainerHistoryItem(item, container));
            this.updateAttachedConnectorsContainer(history, model, item);
            history.endTransaction();
        }
    };
    ModelUtils.removeFromContainer = function (history, model, item) {
        if (item.container) {
            history.beginTransaction();
            history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
            this.updateAttachedConnectorsContainer(history, model, item);
            history.endTransaction();
        }
    };
    ModelUtils.insertSelectionToContainer = function (history, model, selection, container) {
        var _this = this;
        history.beginTransaction();
        var selectedItems = selection.getSelectedItems();
        var items = selectedItems.filter(function (item) { return !item.container || selectedItems.indexOf(item.container) === -1; });
        items.forEach(function (item) {
            _this.insertToContainer(history, model, item, container);
        });
        history.endTransaction();
    };
    ModelUtils.removeSelectionFromContainer = function (history, model, selection) {
        var _this = this;
        history.beginTransaction();
        selection.getSelectedItems().forEach(function (item) {
            if (item.container && !selection.hasKey(item.container.key)) {
                history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(item));
                _this.updateAttachedConnectorsContainer(history, model, item);
            }
        });
        history.endTransaction();
    };
    ModelUtils.getConnectorContainer = function (connector) {
        if (connector.beginItem && connector.endItem) {
            var beginItemContainers = {};
            var containerForBeginItem = connector.beginItem.container;
            while (containerForBeginItem) {
                beginItemContainers[containerForBeginItem.key] = true;
                containerForBeginItem = containerForBeginItem.container;
            }
            var containerForEndItem = connector.endItem.container;
            while (containerForEndItem) {
                if (beginItemContainers[containerForEndItem.key] !== undefined)
                    return containerForEndItem;
                containerForEndItem = containerForEndItem.container;
            }
        }
    };
    ModelUtils.updateAttachedConnectorsContainer = function (history, model, item) {
        var _this = this;
        history.beginTransaction();
        item.attachedConnectors.forEach(function (connector) {
            _this.updateConnectorContainer(history, model, connector);
        });
        history.endTransaction();
    };
    ModelUtils.updateConnectorContainer = function (history, model, connector) {
        var container = this.getConnectorContainer(connector);
        if (container)
            history.addAndRedo(new InsertToContainerHistoryItem_1.InsertToContainerHistoryItem(connector, container));
        else if (connector.container)
            history.addAndRedo(new RemoveFromContainerHistoryItem_1.RemoveFromContainerHistoryItem(connector));
    };
    ModelUtils.updateNewShapeProperties = function (history, selection, itemKey) {
        var style = selection.inputPosition.getDefaultStyle();
        style.forEach(function (propertyName) {
            history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(itemKey, propertyName, selection.inputPosition.getDefaultStylePropertyValue(propertyName)));
        });
        var textStyle = selection.inputPosition.getDefaultTextStyle();
        textStyle.forEach(function (propertyName) {
            history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(itemKey, propertyName, selection.inputPosition.getDefaultTextStylePropertyValue(propertyName)));
        });
    };
    ModelUtils.updateNewConnectorProperties = function (history, selection, itemKey) {
        var connectorProperties = selection.inputPosition.getDefaultConnectorProperties();
        connectorProperties.forEach(function (propertyName) {
            history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(itemKey, propertyName, selection.inputPosition.getDefaultConnectorPropertyValue(propertyName)));
        });
        var style = selection.inputPosition.getDefaultStyle();
        style.forEach(function (propertyName) {
            history.addAndRedo(new ChangeStyleHistoryItem_1.ChangeStyleHistoryItem(itemKey, propertyName, selection.inputPosition.getDefaultStylePropertyValue(propertyName)));
        });
        var textStyle = selection.inputPosition.getDefaultTextStyle();
        textStyle.forEach(function (propertyName) {
            history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(itemKey, propertyName, selection.inputPosition.getDefaultTextStylePropertyValue(propertyName)));
        });
    };
    ModelUtils.applyLayout = function (history, model, container, graph, layout, nonGraphItems, settings, snapToGrid, gridSize, skipPointIndices) {
        history.beginTransaction();
        var occupiedRectangles = this.getOccupiedRectangles(nonGraphItems, container);
        layout = this.offsetLayoutToFreeSpace(layout, container && container.clientRectangle, occupiedRectangles, settings.containerPadding);
        if (snapToGrid)
            this.adjustLayoutToSnapGrid(model, layout, gridSize);
        if (container)
            this.resizeContainerOnLayout(history, model, layout, container, settings.containerPadding);
        this.applyLayoutToNodes(history, model, layout, graph.edges.map(function (e) { return model.findConnector(e.key); }));
        this.applyLayoutToConnectors(history, model, layout, graph.edges.map(function (e) { return model.findConnector(e.key); }), skipPointIndices);
        history.endTransaction();
        return layout.getRectangle(true);
    };
    ModelUtils.getNonGraphItems = function (model, container, nodeKeyMap, shapes, connectors) {
        var allItems = container ? model.getChildren(container) : model.items.filter(function (item) { return !item.container; });
        return allItems.filter(function (item) {
            if (item instanceof Connector_1.Connector)
                return (!item.beginItem || !nodeKeyMap[item.beginItem.key]) && (!item.endItem || !nodeKeyMap[item.endItem.key]) &&
                    connectors.indexOf(item) === -1;
            if (item instanceof Shape_1.Shape)
                return !nodeKeyMap[item.key] &&
                    shapes.indexOf(item) === -1;
        });
    };
    ModelUtils.getOccupiedRectangles = function (nonGraphItems, container) {
        var occupiedRectangles = nonGraphItems.map(function (i) { return i.rectangle; });
        if (container && occupiedRectangles.length) {
            var rect = container.clientRectangle;
            occupiedRectangles.push(new rectangle_1.Rectangle(rect.right, rect.y, 1, 1));
            occupiedRectangles.push(new rectangle_1.Rectangle(rect.right, rect.bottom, 1, 1));
        }
        return occupiedRectangles;
    };
    ModelUtils.offsetLayoutToFreeSpace = function (layout, containerRect, occupiedRectangles, spacing) {
        var graphItemRect = layout.getRectangle(true);
        var freePoint = Utils_1.GeometryUtils.findFreeSpace(occupiedRectangles, graphItemRect.createSize().offset(spacing, spacing).nonNegativeSize(), false, containerRect);
        if (freePoint) {
            var x = freePoint.x + spacing;
            var y = freePoint.y + spacing;
            return layout.offsetNodes(x, y);
        }
        var maxX = occupiedRectangles && occupiedRectangles.length ?
            occupiedRectangles.reduce(function (max, rect) { return rect.right > max ? rect.right : max; }, 0) :
            (containerRect ? containerRect.x : 0);
        var minY = containerRect ? containerRect.y : Math.max(0, graphItemRect.y);
        return layout.offsetNodes(maxX + spacing, minY + spacing);
    };
    ModelUtils.resizeContainerOnLayout = function (history, model, layout, container, spacing) {
        var layoutRect = layout.getRectangle(true);
        var nonLayoutRectangles = container.children
            .filter(function (item) {
            if (item instanceof Shape_1.Shape)
                return layout.nodeKeys.indexOf(item.key) === -1;
            if (item instanceof Connector_1.Connector && item.beginItem && item.endItem)
                return layout.nodeKeys.indexOf(item.beginItem.key) === -1 && layout.nodeKeys.indexOf(item.endItem.key) === -1;
            return false;
        })
            .map(function (item) { return item.rectangle; });
        var right = nonLayoutRectangles.map(function (rect) { return rect.right; }).reduce(function (prev, cur) { return Math.max(prev, cur); }, layoutRect.right);
        var bottom = nonLayoutRectangles.map(function (rect) { return rect.bottom; }).reduce(function (prev, cur) { return Math.max(prev, cur); }, layoutRect.bottom);
        var width = container.rectangle.width + right + spacing - container.rectangle.right;
        var height = container.rectangle.height + bottom + spacing - container.rectangle.bottom;
        ModelUtils.setShapeSize(history, model, container, container.position, new size_1.Size(width, height));
        ModelUtils.updateShapeAttachedConnectors(history, model, container);
    };
    ModelUtils.applyLayoutToNodes = function (history, model, layout, connectors) {
        var _this = this;
        var connectorsSet = connectors.reduce(function (acc, c) { return acc[c.key] =  true && acc; }, {});
        layout.forEachNode(function (nl, nk) {
            var shape = model.findShape(nk);
            _this.applyLayoutToNode(history, model, shape, nl.position, connectorsSet);
        });
    };
    ModelUtils.applyLayoutToNode = function (history, model, shape, position, connectorsSet) {
        var _this = this;
        var delta = position.clone().offset(-shape.position.x, -shape.position.y);
        ModelUtils.setShapePosition(history, model, shape, position, false);
        if (delta.x !== 0 || delta.y !== 0) {
            shape.attachedConnectors
                .filter(function (c) { return !connectorsSet[c.key]; })
                .forEach(function (connector) {
                _this.updateConnectorAttachedPoints(history, model, connector);
                var beginPointIndex = connector.beginItem ? 1 : 0;
                var endPointIndex = connector.endItem ? (connector.points.length - 2) : (connector.points.length - 1);
                for (var i = beginPointIndex; i <= endPointIndex; i++)
                    _this.moveConnectorPoint(history, connector, i, connector.points[i].offset(delta.x, delta.y));
            });
            model.getChildren(shape).forEach(function (child) {
                if (child instanceof Shape_1.Shape) {
                    var childPosition = child.position.clone().offset(delta.x, delta.y);
                    _this.applyLayoutToNode(history, model, child, childPosition, connectorsSet);
                }
            });
        }
    };
    ModelUtils.applyLayoutToConnectors = function (history, model, layout, connectors, skipPointIndices) {
        var _this = this;
        connectors.filter(function (c) { return c.beginItem || c.endItem; }).forEach(function (connector) {
            var edgeLayout = layout.edgeToPosition[connector.key];
            if (connector.beginItem && connector.endItem && !skipPointIndices && edgeLayout) {
                var beginIndex = connector.beginItem.getConnectionPointIndexForSide(edgeLayout.beginIndex);
                if (beginIndex !== connector.beginConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, beginIndex, Connector_1.ConnectorPosition.Begin));
                var endIndex = connector.endItem.getConnectionPointIndexForSide(edgeLayout.endIndex);
                if (endIndex !== connector.endConnectionPointIndex)
                    history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, endIndex, Connector_1.ConnectorPosition.End));
            }
            _this.updateConnectorAttachedPoints(history, model, connector);
            if (edgeLayout)
                _this.deleteConnectorCustomPoints(history, connector);
        });
    };
    ModelUtils.adjustLayoutToSnapGrid = function (model, layout, gridSize) {
        var _this = this;
        layout.nodeKeys.forEach(function (key) {
            layout.nodeToLayout[key].position.x = _this.getSnappedPos(model, gridSize, layout.nodeToLayout[key].position.x, true);
            layout.nodeToLayout[key].position.y = _this.getSnappedPos(model, gridSize, layout.nodeToLayout[key].position.y, false);
        });
    };
    ModelUtils.getGraphInfoByItems = function (model, shapes, connectors, isDatabinding) {
        if (isDatabinding === void 0) { isDatabinding = true; }
        var itemsByContainerKey = {};
        var items = [].concat(shapes).concat(connectors);
        items.forEach(function (item) {
            var containerKey = item.container && item.container.key;
            if (!itemsByContainerKey[containerKey])
                itemsByContainerKey[containerKey] = [];
            itemsByContainerKey[containerKey].push(item);
        });
        var result = [];
        for (var key in itemsByContainerKey) {
            if (!Object.prototype.hasOwnProperty.call(itemsByContainerKey, key))
                continue;
            var container = key && model.findContainer(key);
            if (!container || (container.expanded && !model.findItemCollapsedContainer(container))) {
                var containerKey = container && container.key;
                var graph = this.getGraphByItems(model, itemsByContainerKey[key], containerKey, !isDatabinding);
                var allowCreateInfo = false;
                if (graph.nodes.length > 1)
                    allowCreateInfo = true;
                else if (graph.nodes.length)
                    if (isDatabinding)
                        allowCreateInfo = true;
                    else if (container && itemsByContainerKey[container.container && container.container.key])
                        allowCreateInfo = true;
                if (allowCreateInfo)
                    result.push(new GraphInfo_1.GraphInfo(container, graph));
            }
        }
        return result.sort(function (a, b) { return b.level - a.level; });
    };
    ModelUtils.getGraphByItems = function (model, items, containerKey, skipLocked) {
        var _this = this;
        var graph = new Graph_1.Graph([], []);
        var knownIds = {};
        items.forEach(function (item) {
            _this.extendByConnectedComponents(item, graph, containerKey, knownIds, skipLocked);
        });
        graph.nodes.sort(function (a, b) { return model.getItemIndex(model.findItem(a)) - model.getItemIndex(model.findItem(b)); });
        graph.edges.sort(function (a, b) { return model.getItemIndex(model.findItem(a.key)) - model.getItemIndex(model.findItem(b.key)); });
        graph.edges = graph.edges.filter(function (e) { return graph.getNode(e.from) && graph.getNode(e.to); });
        return graph;
    };
    ModelUtils.extendByConnectedComponents = function (item, graph, containerKey, knownIds, skipLocked) {
        var _this = this;
        if (!item || (skipLocked && item.locked) || knownIds[item.key])
            return;
        knownIds[item.key] = true;
        if (item instanceof Connector_1.Connector && (item.container && item.container.key) === containerKey &&
            item.beginItem && (!item.beginItem.locked || !skipLocked) && item.endItem && (!item.endItem.locked || !skipLocked) &&
            item.beginItem !== item.endItem) {
            graph.addEdge(new Structures_1.Edge(item.key, item.beginItem && item.beginItem.key, item.endItem && item.endItem.key));
            this.extendByConnectedComponents(item.beginItem, graph, containerKey, knownIds, skipLocked);
            this.extendByConnectedComponents(item.endItem, graph, containerKey, knownIds, skipLocked);
        }
        else if (item instanceof Shape_1.Shape && (item.container && item.container.key) === containerKey) {
            graph.addNode(item);
            item.attachedConnectors.forEach(function (c) { return _this.extendByConnectedComponents(c, graph, containerKey, knownIds, skipLocked); });
        }
    };
    ModelUtils.getlUnitValue = function (units, twipsValue) {
        switch (units) {
            case Enums_1.DiagramUnit.Cm:
                return unit_converter_1.UnitConverter.twipsToCentimeters(twipsValue);
            case Enums_1.DiagramUnit.In:
                return unit_converter_1.UnitConverter.twipsToInches(twipsValue);
            case Enums_1.DiagramUnit.Px:
                return unit_converter_1.UnitConverter.twipsToPixels(twipsValue);
        }
    };
    ModelUtils.getUnitText = function (units, unitItems, formatUnit, twipsValue, fractionDigits) {
        if (fractionDigits === void 0) { fractionDigits = 2; }
        var unitItemText = unitItems[units] ? " " + unitItems[units] : "";
        var unitValue = this.getlUnitValue(units, twipsValue);
        switch (units) {
            case Enums_1.DiagramUnit.Cm:
                return formatUnit(+unitValue.toFixed(fractionDigits)) + unitItemText;
            case Enums_1.DiagramUnit.In:
                return formatUnit(+unitValue.toFixed(fractionDigits)) + unitItemText;
            case Enums_1.DiagramUnit.Px:
                return formatUnit(+unitValue.toFixed(0)) + unitItemText;
        }
    };
    ModelUtils.getTwipsValue = function (units, value) {
        switch (units) {
            case Enums_1.DiagramUnit.Cm:
                return unit_converter_1.UnitConverter.centimetersToTwips(value);
            case Enums_1.DiagramUnit.In:
                return unit_converter_1.UnitConverter.inchesToTwips(value);
            case Enums_1.DiagramUnit.Px:
                return unit_converter_1.UnitConverter.pixelsToTwips(value);
        }
    };
    ModelUtils.getGuidItemKey = function () {
        return math_1.MathUtils.generateGuid();
    };
    ModelUtils.createSelectedItems = function (selection) {
        var result = {};
        selection.getSelectedItems(true).forEach(function (i) { return result[i.key] = i; });
        return result;
    };
    ModelUtils.canMoveConnector = function (selectedItems, connector) {
        var beginItem = connector.beginItem;
        var endItem = connector.endItem;
        if (!beginItem && !endItem)
            return !connector.isLocked;
        if (!selectedItems[connector.key])
            return false;
        if (beginItem === endItem)
            return !!selectedItems[beginItem.key];
        if (!beginItem)
            return !!selectedItems[endItem.key];
        if (!endItem)
            return !!selectedItems[beginItem.key];
        return !!selectedItems[beginItem.key] && !!selectedItems[endItem.key];
    };
    ModelUtils.createRectangle = function (items) {
        return Utils_1.GeometryUtils.getCommonRectangle(items.map(function (i) { return i.rectangle; }));
    };
    ModelUtils.changeShapeType = function (history, model, shape, shapeType) {
        if (shape.description.key === shapeType)
            return false;
        history.beginTransaction();
        var oldConPts = shape.getConnectionPoints();
        var oldConPtsSides = oldConPts.map(function (p) { return shape.getConnectionPointSide(p); });
        history.addAndRedo(new ChangeShapeTypeHistoryItem_1.ChangeShapeTypeHistoryItem(shape, shapeType));
        var newConPts = shape.getConnectionPoints();
        var newConPtsSides = newConPts.map(function (p) { return shape.getConnectionPointSide(p); });
        for (var i = 0, connector = void 0; connector = shape.attachedConnectors[i]; i++) {
            if (connector.beginItem === shape)
                this.updateConnectionIndexByNewShapeType(history, connector, Connector_1.ConnectorPosition.Begin, connector.beginConnectionPointIndex, oldConPts, oldConPtsSides, newConPts, newConPtsSides);
            if (connector.endItem === shape)
                this.updateConnectionIndexByNewShapeType(history, connector, Connector_1.ConnectorPosition.End, connector.endConnectionPointIndex, oldConPts, oldConPtsSides, newConPts, newConPtsSides);
            this.updateConnectorAttachedPoints(history, model, connector);
        }
        history.endTransaction();
        return true;
    };
    ModelUtils.updateConnectionIndexByNewShapeType = function (history, connector, position, oldPointIndex, oldConPts, oldConPtsSides, newConPts, newConPtsSides) {
        if (oldPointIndex < 0)
            return;
        var oldSide = oldConPtsSides[oldPointIndex];
        var oldPt = oldConPts[oldPointIndex];
        if (oldPointIndex < newConPts.length && oldSide === newConPtsSides[oldPointIndex])
            return;
        var newIndex = this.findNearestPointIndex(newConPts, oldPt, function (i) { return newConPtsSides[i] === oldSide; });
        if (newIndex === -1)
            newIndex = this.findNearestPointIndex(newConPts, oldPt, function () { return true; });
        if (newIndex !== oldPointIndex)
            history.addAndRedo(new AddConnectionHistoryItem_1.SetConnectionPointIndexHistoryItem(connector, newIndex, position));
    };
    ModelUtils.findNearestPointIndex = function (points, initPoint, condition) {
        return points.reduce(function (acc, val, index) {
            if (condition(index)) {
                var dist = metrics_1.Metrics.euclideanDistance(initPoint, points[index]);
                if (acc.index === -1 || acc.distance > dist) {
                    acc.index = index;
                    acc.distance = dist;
                }
            }
            return acc;
        }, { distance: Number.MAX_SAFE_INTEGER, index: -1 }).index;
    };
    ModelUtils.connectionPointActionSize = unit_converter_1.UnitConverter.pixelsToTwips(8);
    return ModelUtils;
}());
exports.ModelUtils = ModelUtils;


/***/ }),

/***/ 1930:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FileUtils = void 0;
var browser_1 = __webpack_require__(8424);
var base64_1 = __webpack_require__(807);
var common_1 = __webpack_require__(961);
var FileUtils = (function () {
    function FileUtils() {
    }
    FileUtils.loadJavascriptFile = function (srcUri, callback) {
        var _a;
        var headElem = document.getElementsByTagName('head')[0];
        if (!headElem) {
            headElem = document.createElement('head');
            var bodyElem = document.getElementsByTagName('body')[0];
            (_a = bodyElem.parentNode) === null || _a === void 0 ? void 0 : _a.insertBefore(headElem, bodyElem);
        }
        var scriptElem = document.createElement('script');
        scriptElem.onload = callback;
        scriptElem.src = srcUri;
        headElem.appendChild(scriptElem);
        return { htmlScriptElement: scriptElem };
    };
    FileUtils.startDownloadFileLocal = function (content, fileName) {
        if (content instanceof ArrayBuffer)
            content = base64_1.Base64Utils.fromArrayBuffer(content);
        if (common_1.isString(content))
            content = base64_1.Base64Utils.getFileFromBase64(content);
        if (window.navigator.msSaveOrOpenBlob)
            window.navigator.msSaveOrOpenBlob(content, fileName);
        else {
            var a_1 = document.createElement('a');
            var url_1 = URL.createObjectURL(content);
            a_1.href = url_1;
            a_1.download = fileName;
            document.body.appendChild(a_1);
            a_1.click();
            setTimeout(function () {
                document.body.removeChild(a_1);
                window.URL.revokeObjectURL(url_1);
            }, 0);
        }
    };
    FileUtils.createFile = function (fileBits, fileName, options) {
        var _a;
        if (browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86) {
            var blob = new Blob(fileBits, options);
            blob['lastModifiedDate'] = (_a = options === null || options === void 0 ? void 0 : options.lastModified) !== null && _a !== void 0 ? _a : Date.now();
            blob['name'] = fileName;
            return blob;
        }
        else
            return new File(fileBits, fileName, options);
    };
    FileUtils.isFile = function (file) {
        if (browser_1.Browser.IE || browser_1.Browser.Edge && browser_1.Browser.MajorVersion < 86)
            return (file instanceof File) || (file instanceof Blob && common_1.isDefined(file.name));
        else
            return file instanceof File;
    };
    return FileUtils;
}());
exports.FileUtils = FileUtils;


/***/ }),

/***/ 1932:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStrokeStyleCommand = void 0;
var ChangeStylePropertyCommand_1 = __webpack_require__(5963);
var ChangeStrokeStyleCommand = (function (_super) {
    __extends(ChangeStrokeStyleCommand, _super);
    function ChangeStrokeStyleCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeStrokeStyleCommand.prototype.getStyleProperty = function () {
        return "stroke-dasharray";
    };
    return ChangeStrokeStyleCommand;
}(ChangeStylePropertyCommand_1.ChangeStylePropertyCommand));
exports.ChangeStrokeStyleCommand = ChangeStrokeStyleCommand;


/***/ }),

/***/ 1960:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorLineEndingFilledTriangleStrategy = exports.ConnectorLineEndingOutlinedTriangleStrategy = exports.ConnectorLineEndingArrowStrategy = exports.ConnectorLineEndingNoneStrategy = exports.ConnectorLineEndingStrategy = void 0;
var Utils_1 = __webpack_require__(41);
var PathPrimitive_1 = __webpack_require__(6208);
var ConnectorLineEndingStrategy = (function () {
    function ConnectorLineEndingStrategy(style) {
        this.style = style;
    }
    ConnectorLineEndingStrategy.prototype.hasCommands = function () {
        return true;
    };
    ConnectorLineEndingStrategy.prototype.needCreateSeparatePrimitive = function () {
        return false;
    };
    ConnectorLineEndingStrategy.prototype.createPrimitive = function () {
        return new PathPrimitive_1.PathPrimitive([], this.getStyle(), this.getCssClass());
    };
    ConnectorLineEndingStrategy.prototype.createCommands = function (point, directionPoint) {
        return [];
    };
    ConnectorLineEndingStrategy.prototype.getStyle = function () {
        var style = this.style.clone();
        style.resetStrokeDashArray();
        return style;
    };
    ConnectorLineEndingStrategy.prototype.getCssClass = function () {
        return undefined;
    };
    return ConnectorLineEndingStrategy;
}());
exports.ConnectorLineEndingStrategy = ConnectorLineEndingStrategy;
var ConnectorLineEndingNoneStrategy = (function (_super) {
    __extends(ConnectorLineEndingNoneStrategy, _super);
    function ConnectorLineEndingNoneStrategy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorLineEndingNoneStrategy.prototype.hasCommands = function () {
        return false;
    };
    return ConnectorLineEndingNoneStrategy;
}(ConnectorLineEndingStrategy));
exports.ConnectorLineEndingNoneStrategy = ConnectorLineEndingNoneStrategy;
var ConnectorLineEndingArrowStrategy = (function (_super) {
    __extends(ConnectorLineEndingArrowStrategy, _super);
    function ConnectorLineEndingArrowStrategy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ConnectorLineEndingArrowStrategy.prototype, "arrowHeight", {
        get: function () { return this.style.strokeWidth * 6; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorLineEndingArrowStrategy.prototype, "arrowWidth", {
        get: function () { return this.style.strokeWidth * 2; },
        enumerable: false,
        configurable: true
    });
    ConnectorLineEndingArrowStrategy.prototype.needCreateSeparatePrimitive = function () {
        return !this.style.isDefaultStrokeDashArray();
    };
    ConnectorLineEndingArrowStrategy.prototype.createCommands = function (point, directionPoint) {
        var arrowPoints = this.getArrowPoints(point, directionPoint);
        var commands = [
            new PathPrimitive_1.PathPrimitiveMoveToCommand(arrowPoints.point1.x, arrowPoints.point1.y),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x, point.y),
            new PathPrimitive_1.PathPrimitiveLineToCommand(arrowPoints.point2.x, arrowPoints.point2.y)
        ];
        if (!this.style.isDefaultStrokeDashArray())
            commands = commands.concat([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(point.x, point.y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(arrowPoints.point3.x, arrowPoints.point3.y)
            ]);
        return commands;
    };
    ConnectorLineEndingArrowStrategy.prototype.getArrowPoints = function (point, directionPoint) {
        var arrowHeight = this.arrowHeight;
        if (point.x === directionPoint.x) {
            var distance = Math.abs(point.y - directionPoint.y);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        if (point.y === directionPoint.y) {
            var distance = Math.abs(point.x - directionPoint.x);
            if (distance < arrowHeight)
                arrowHeight = distance;
        }
        return Utils_1.GeometryUtils.getArrowPoints(point, directionPoint, arrowHeight, this.arrowWidth);
    };
    return ConnectorLineEndingArrowStrategy;
}(ConnectorLineEndingStrategy));
exports.ConnectorLineEndingArrowStrategy = ConnectorLineEndingArrowStrategy;
var ConnectorLineEndingOutlinedTriangleStrategy = (function (_super) {
    __extends(ConnectorLineEndingOutlinedTriangleStrategy, _super);
    function ConnectorLineEndingOutlinedTriangleStrategy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorLineEndingOutlinedTriangleStrategy.prototype.needCreateSeparatePrimitive = function () {
        return true;
    };
    ConnectorLineEndingOutlinedTriangleStrategy.prototype.createCommands = function (point, directionPoint) {
        var arrowPoints = this.getArrowPoints(point, directionPoint);
        return [
            new PathPrimitive_1.PathPrimitiveMoveToCommand(arrowPoints.point1.x, arrowPoints.point1.y),
            new PathPrimitive_1.PathPrimitiveLineToCommand(point.x, point.y),
            new PathPrimitive_1.PathPrimitiveLineToCommand(arrowPoints.point2.x, arrowPoints.point2.y),
            new PathPrimitive_1.PathPrimitiveClosePathCommand()
        ];
    };
    ConnectorLineEndingOutlinedTriangleStrategy.prototype.getCssClass = function () {
        return "outlined-line-ending";
    };
    return ConnectorLineEndingOutlinedTriangleStrategy;
}(ConnectorLineEndingArrowStrategy));
exports.ConnectorLineEndingOutlinedTriangleStrategy = ConnectorLineEndingOutlinedTriangleStrategy;
var ConnectorLineEndingFilledTriangleStrategy = (function (_super) {
    __extends(ConnectorLineEndingFilledTriangleStrategy, _super);
    function ConnectorLineEndingFilledTriangleStrategy() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorLineEndingFilledTriangleStrategy.prototype.getStyle = function () {
        var style = _super.prototype.getStyle.call(this);
        style["fill"] = style["stroke"];
        return style;
    };
    ConnectorLineEndingFilledTriangleStrategy.prototype.getCssClass = function () {
        return "filled-line-ending";
    };
    return ConnectorLineEndingFilledTriangleStrategy;
}(ConnectorLineEndingOutlinedTriangleStrategy));
exports.ConnectorLineEndingFilledTriangleStrategy = ConnectorLineEndingFilledTriangleStrategy;


/***/ }),

/***/ 1988:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorOrthogonalSideState = void 0;
var point_1 = __webpack_require__(5327);
var Connector_1 = __webpack_require__(6320);
var DiagramItem_1 = __webpack_require__(4824);
var ModelUtils_1 = __webpack_require__(1922);
var MouseHandlerDraggingState_1 = __webpack_require__(2815);
var Utils_1 = __webpack_require__(41);
var MouseHandlerMoveConnectorOrthogonalSideState = (function (_super) {
    __extends(MouseHandlerMoveConnectorOrthogonalSideState, _super);
    function MouseHandlerMoveConnectorOrthogonalSideState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        _this.canCreatePoints = true;
        return _this;
    }
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.saveSidePoints = function (markLeftRenderPointIndex, markRightRenderPointIndex) {
        var _this = this;
        var renderPoints = this.connector.getRenderPoints(true);
        this.isHorizontal = renderPoints[markLeftRenderPointIndex].y === renderPoints[markRightRenderPointIndex].y;
        this.iterateRenderPoints(renderPoints, markLeftRenderPointIndex, false, function (pt, i) {
            if (pt.pointIndex !== -1)
                _this.leftPointIndex = pt.pointIndex;
            _this.leftRenderPointIndex = i;
        }, function (pt) { return !Utils_1.GeometryUtils.arePointsOfOrthogonalLine(renderPoints[markLeftRenderPointIndex], pt, _this.isHorizontal); });
        this.iterateRenderPoints(renderPoints, this.leftRenderPointIndex, true, function (pt, i) {
            if (pt.pointIndex !== -1)
                _this.rightPointIndex = pt.pointIndex;
            _this.rightRenderPointIndex = i;
        }, function (pt) { return !Utils_1.GeometryUtils.arePointsOfOrthogonalLine(renderPoints[markLeftRenderPointIndex], pt, _this.isHorizontal); });
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.iterateRenderPoints = function (renderPoints, startIndex, direction, callback, stopPredicate) {
        for (var i = startIndex; direction ? i < renderPoints.length : i >= 0; direction ? i++ : i--) {
            var point = renderPoints[i];
            if (stopPredicate && stopPredicate(point, i))
                break;
            callback(point, i);
        }
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onMouseDown = function (evt) {
        this.startPoint = evt.modelPoint;
        this.connector = this.model.findConnector(evt.source.key);
        this.handler.addInteractingItem(this.connector);
        var renderPointIndexes = evt.source.value.split("_");
        this.saveSidePoints(parseInt(renderPointIndexes[0]), parseInt(renderPointIndexes[1]));
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.shouldCreatePoint = function (isLeft) {
        if (!this.canCreatePoints)
            return false;
        if (isLeft && (this.leftPointIndex === undefined || this.leftPointIndex === 0))
            return true;
        if (!isLeft && (this.rightPointIndex === undefined || this.rightPointIndex === this.connector.points.length - 1))
            return true;
        var renderPoints = this.connector.getRenderPoints(true);
        if (isLeft && !this.connector.points[this.leftPointIndex].equals(renderPoints[this.leftRenderPointIndex]))
            return true;
        if (!isLeft && !this.connector.points[this.rightPointIndex].equals(renderPoints[this.rightRenderPointIndex]))
            return true;
        return false;
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onApplyChanges = function (evt) {
        var _this = this;
        if (this.shouldCreatePoint(true) || this.shouldCreatePoint(false)) {
            var renderPoints = this.connector.getRenderPoints(true);
            var leftRenderPoint = renderPoints[this.leftRenderPointIndex];
            var rightRenderPoint = renderPoints[this.rightRenderPointIndex];
            if (this.shouldCreatePoint(true)) {
                var leftPoint = new point_1.Point(leftRenderPoint.x, leftRenderPoint.y);
                if (this.leftPointIndex === 0) {
                    this.leftPointIndex = 1;
                    this.correctEdgePoint(leftPoint, rightRenderPoint, this.connector.beginItem, this.connector.beginConnectionPointIndex);
                }
                else if (this.leftPointIndex === undefined)
                    this.iterateRenderPoints(renderPoints, this.leftRenderPointIndex, true, function (pt) {
                        if (pt.pointIndex !== -1)
                            _this.leftPointIndex = pt.pointIndex;
                    }, function () { return _this.leftPointIndex !== undefined; });
                ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connector.key, this.leftPointIndex, leftPoint);
                if (this.rightPointIndex !== undefined)
                    this.rightPointIndex++;
            }
            if (this.shouldCreatePoint(false)) {
                renderPoints = this.connector.getRenderPoints(true);
                var rightPoint = new point_1.Point(rightRenderPoint.x, rightRenderPoint.y);
                if (this.rightPointIndex === this.connector.points.length - 1) {
                    this.correctEdgePoint(rightPoint, leftRenderPoint, this.connector.endItem, this.connector.endConnectionPointIndex);
                    this.rightPointIndex--;
                }
                else if (this.rightPointIndex === undefined)
                    this.iterateRenderPoints(renderPoints, this.rightRenderPointIndex, false, function (pt) {
                        if (pt.pointIndex !== -1)
                            _this.rightPointIndex = pt.pointIndex;
                    }, function () { return _this.rightPointIndex === _this.leftPointIndex; });
                this.rightPointIndex++;
                ModelUtils_1.ModelUtils.addConnectorPoint(this.history, this.connector.key, this.rightPointIndex, rightPoint);
            }
        }
        this.canCreatePoints = false;
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        ModelUtils_1.ModelUtils.moveConnectorRightAnglePoints(this.history, this.connector, this.leftPointIndex, this.rightPointIndex, this.isHorizontal ? undefined : point.x, this.isHorizontal ? point.y : undefined);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.onFinishWithChanges = function () {
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, this.connector);
        ModelUtils_1.ModelUtils.fixConnectorBeginEndConnectionIndex(this.history, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.correctEdgePoint = function (point, directionPoint, item, connectionPointIndex) {
        var offset = 0;
        if (item) {
            var side = item.getConnectionPointSideByIndex(connectionPointIndex);
            var rect = item.rectangle;
            offset = Connector_1.Connector.minOffset;
            switch (side) {
                case DiagramItem_1.ConnectionPointSide.South:
                    offset += rect.bottom - point.y;
                    break;
                case DiagramItem_1.ConnectionPointSide.North:
                    offset += point.y - rect.y;
                    break;
                case DiagramItem_1.ConnectionPointSide.East:
                    offset += rect.right - point.x;
                    break;
                case DiagramItem_1.ConnectionPointSide.West:
                    offset += point.x - rect.x;
                    break;
            }
        }
        if (this.isHorizontal)
            if (point.x > directionPoint.x)
                point.x -= Math.min(offset, point.x - directionPoint.x);
            else
                point.x += Math.min(offset, directionPoint.x - point.x);
        else if (point.y > directionPoint.y)
            point.y -= Math.min(offset, point.y - directionPoint.y);
        else
            point.y += Math.min(offset, directionPoint.y - point.y);
    };
    MouseHandlerMoveConnectorOrthogonalSideState.prototype.getDraggingElementKeys = function () {
        return [this.connector.key];
    };
    return MouseHandlerMoveConnectorOrthogonalSideState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorOrthogonalSideState = MouseHandlerMoveConnectorOrthogonalSideState;


/***/ }),

/***/ 1998:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveStepDownCommand = exports.MoveDownCommand = exports.MoveStepUpCommand = exports.MoveUpCommand = exports.MoveStepRightCommand = exports.MoveRightCommand = exports.MoveStepLeftCommand = exports.MoveLeftCommand = exports.MoveCommand = void 0;
var point_1 = __webpack_require__(5327);
var ModelUtils_1 = __webpack_require__(1922);
var unit_converter_1 = __webpack_require__(9500);
var SimpleCommandBase_1 = __webpack_require__(3913);
var DragHelper_1 = __webpack_require__(1416);
var MoveCommand = (function (_super) {
    __extends(MoveCommand, _super);
    function MoveCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveCommand.prototype.isEnabled = function () {
        return _super.prototype.isEnabled.call(this) && !this.control.selection.isEmpty();
    };
    MoveCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var selection = this.control.selection;
        var helper = new DragHelper_1.SelectionDragHelper(this.control.history, this.control.model, this.permissionsProvider, new point_1.Point(0, 0), selection.getSelectedItems(true));
        helper.initDraggingShapes(selection.getSelectedShapes(false, true), false);
        helper.initDraggingConnectors(selection.getSelectedConnectors(false, true), false);
        helper.move(false, function (p) { return _this.getPosition(p); }, function () { }, function () { });
        helper.finish();
        ModelUtils_1.ModelUtils.tryUpdateModelRectangle(this.control.history, function (offsetLeft, offsetTop) { return helper.onTryUpdateModelSize(offsetLeft, offsetTop); });
        this.control.history.endTransaction();
        return true;
    };
    Object.defineProperty(MoveCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    return MoveCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.MoveCommand = MoveCommand;
var MoveLeftCommand = (function (_super) {
    __extends(MoveLeftCommand, _super);
    function MoveLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveLeftCommand.prototype.getPosition = function (position) {
        return position.clone().offset(-unit_converter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveLeftCommand;
}(MoveCommand));
exports.MoveLeftCommand = MoveLeftCommand;
var MoveStepLeftCommand = (function (_super) {
    __extends(MoveStepLeftCommand, _super);
    function MoveStepLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepLeftCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.x - (this.control.settings.gridSize / 2 + 2), true), position.y);
        else
            return position.clone().offset(-this.control.settings.gridSize, 0);
    };
    return MoveStepLeftCommand;
}(MoveCommand));
exports.MoveStepLeftCommand = MoveStepLeftCommand;
var MoveRightCommand = (function (_super) {
    __extends(MoveRightCommand, _super);
    function MoveRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveRightCommand.prototype.getPosition = function (position) {
        return position.clone().offset(unit_converter_1.UnitConverter.pixelsToTwips(1), 0);
    };
    return MoveRightCommand;
}(MoveCommand));
exports.MoveRightCommand = MoveRightCommand;
var MoveStepRightCommand = (function (_super) {
    __extends(MoveStepRightCommand, _super);
    function MoveStepRightCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepRightCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.x + (this.control.settings.gridSize / 2 + 2), true), position.y);
        else
            return position.clone().offset(this.control.settings.gridSize, 0);
    };
    return MoveStepRightCommand;
}(MoveCommand));
exports.MoveStepRightCommand = MoveStepRightCommand;
var MoveUpCommand = (function (_super) {
    __extends(MoveUpCommand, _super);
    function MoveUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveUpCommand.prototype.getPosition = function (position) {
        return position.clone().offset(0, -unit_converter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveUpCommand;
}(MoveCommand));
exports.MoveUpCommand = MoveUpCommand;
var MoveStepUpCommand = (function (_super) {
    __extends(MoveStepUpCommand, _super);
    function MoveStepUpCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepUpCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.y - (this.control.settings.gridSize / 2 + 2), false));
        else
            return position.clone().offset(0, -this.control.settings.gridSize);
    };
    return MoveStepUpCommand;
}(MoveCommand));
exports.MoveStepUpCommand = MoveStepUpCommand;
var MoveDownCommand = (function (_super) {
    __extends(MoveDownCommand, _super);
    function MoveDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveDownCommand.prototype.getPosition = function (position) {
        return position.clone().offset(0, unit_converter_1.UnitConverter.pixelsToTwips(1));
    };
    return MoveDownCommand;
}(MoveCommand));
exports.MoveDownCommand = MoveDownCommand;
var MoveStepDownCommand = (function (_super) {
    __extends(MoveStepDownCommand, _super);
    function MoveStepDownCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MoveStepDownCommand.prototype.getPosition = function (position) {
        if (this.control.settings.snapToGrid)
            return new point_1.Point(position.x, ModelUtils_1.ModelUtils.getSnappedPos(this.control.model, this.control.settings.gridSize, position.y + (this.control.settings.gridSize / 2 + 2), false));
        else
            return position.clone().offset(0, this.control.settings.gridSize);
    };
    return MoveStepDownCommand;
}(MoveCommand));
exports.MoveStepDownCommand = MoveStepDownCommand;


/***/ }),

/***/ 2016:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TargetVisualizerBase = void 0;
var TargetVisualizerBase = (function () {
    function TargetVisualizerBase(dispatcher) {
        this.dispatcher = dispatcher;
    }
    TargetVisualizerBase.prototype.getKey = function () {
        return this.key;
    };
    TargetVisualizerBase.prototype.setTargetRect = function (key, targetRect, targetStrokeWidth) {
        if (this.key !== key) {
            this.key = key;
            this.targetRect = targetRect;
            this.targetStrokeWidth = targetStrokeWidth;
            this.raiseShow();
        }
    };
    TargetVisualizerBase.prototype.reset = function () {
        if (this.key !== "-1") {
            this.key = "-1";
            this.targetRect = undefined;
            this.targetStrokeWidth = 0;
            this.raiseHide();
        }
    };
    return TargetVisualizerBase;
}());
exports.TargetVisualizerBase = TargetVisualizerBase;


/***/ }),

/***/ 2037:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorTextState = void 0;
var MouseHandlerDraggingState_1 = __webpack_require__(2815);
var ChangeConnectorTextPositionHistoryItem_1 = __webpack_require__(2771);
var ChangeConnectorTextHistoryItem_1 = __webpack_require__(1914);
var MouseHandlerMoveConnectorTextState = (function (_super) {
    __extends(MouseHandlerMoveConnectorTextState, _super);
    function MouseHandlerMoveConnectorTextState(handler, history, model) {
        var _this = _super.call(this, handler, history) || this;
        _this.model = model;
        return _this;
    }
    MouseHandlerMoveConnectorTextState.prototype.onMouseDown = function (evt) {
        this.connector = this.model.findConnector(evt.source.key);
        this.position = parseFloat(evt.source.value);
        this.text = this.connector.getText(this.position);
        this.savedText = "";
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorTextState.prototype.onApplyChanges = function (evt) {
        var newPosition = this.connector.getTextPositionByPoint(evt.modelPoint);
        if (newPosition !== this.position) {
            var text = this.connector.getText(newPosition);
            if (text !== "" && text !== this.text) {
                this.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(this.connector, newPosition, ""));
                this.savedText = text;
            }
            this.history.addAndRedo(new ChangeConnectorTextPositionHistoryItem_1.ChangeConnectorTextPositionHistoryItem(this.connector, this.position, newPosition));
            if (this.savedText !== "" && this.savedText !== text) {
                this.history.addAndRedo(new ChangeConnectorTextHistoryItem_1.ChangeConnectorTextHistoryItem(this.connector, this.position, this.savedText));
                this.savedText = "";
            }
            this.position = newPosition;
        }
    };
    MouseHandlerMoveConnectorTextState.prototype.getDraggingElementKeys = function () {
        return [this.connector.key];
    };
    return MouseHandlerMoveConnectorTextState;
}(MouseHandlerDraggingState_1.MouseHandlerDraggingState));
exports.MouseHandlerMoveConnectorTextState = MouseHandlerMoveConnectorTextState;


/***/ }),

/***/ 2078:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorPropertyCommand = void 0;
var ChangeConnectorPropertyHistoryItem_1 = __webpack_require__(2448);
var SimpleCommandBase_1 = __webpack_require__(3913);
var ChangeConnectorPropertyCommand = (function (_super) {
    __extends(ChangeConnectorPropertyCommand, _super);
    function ChangeConnectorPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorPropertyCommand.prototype.getValue = function () {
        return this.control.selection.inputPosition.getCurrentConnectorPropertyValue(this.getPropertyName());
    };
    ChangeConnectorPropertyCommand.prototype.getDefaultValue = function () {
        return this.getPropertyDefaultValue();
    };
    ChangeConnectorPropertyCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var connectors = this.control.selection.getSelectedConnectors();
        connectors.forEach(function (connector) {
            var propertyName = _this.getPropertyName();
            _this.control.history.addAndRedo(new ChangeConnectorPropertyHistoryItem_1.ChangeConnectorPropertyHistoryItem(connector.key, propertyName, parameter));
        });
        this.control.selection.inputPosition.setConnectorPropertyValue(this.getPropertyName(), parameter);
        this.control.history.endTransaction();
        return true;
    };
    ChangeConnectorPropertyCommand.prototype.lockInputPositionUpdating = function () {
        return true;
    };
    ChangeConnectorPropertyCommand.prototype.isEnabled = function () {
        var connectors = this.control.selection.getSelectedConnectors();
        return _super.prototype.isEnabled.call(this) && connectors.length > 0;
    };
    return ChangeConnectorPropertyCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ChangeConnectorPropertyCommand = ChangeConnectorPropertyCommand;


/***/ }),

/***/ 2092:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.OrShapeDescription = void 0;
var ShapeTypes_1 = __webpack_require__(3255);
var size_1 = __webpack_require__(3844);
var ShapeDescription_1 = __webpack_require__(1280);
var EllipseShapeDescription_1 = __webpack_require__(9829);
var PathPrimitive_1 = __webpack_require__(6208);
var OrShapeDescription = (function (_super) {
    __extends(OrShapeDescription, _super);
    function OrShapeDescription() {
        var _this = _super.call(this, true) || this;
        _this.defaultSize = new size_1.Size(ShapeDescription_1.ShapeDefaultDimension * 0.5, ShapeDescription_1.ShapeDefaultDimension * 0.5);
        return _this;
    }
    Object.defineProperty(OrShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Or; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(OrShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(OrShapeDescription.prototype, "enableText", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    OrShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom;
        var _a = rect.center, cx = _a.x, cy = _a.y;
        var primitives = [];
        return primitives
            .concat(_super.prototype.createShapePrimitives.call(this, shape))
            .concat([
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(cx, bottom),
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy)
            ], shape.style)
        ]);
    };
    return OrShapeDescription;
}(EllipseShapeDescription_1.EllipseShapeDescription));
exports.OrShapeDescription = OrShapeDescription;


/***/ }),

/***/ 2095:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.IntervalAlgorithms = void 0;
var list_1 = __webpack_require__(2892);
var search_1 = __webpack_require__(124);
var fixed_1 = __webpack_require__(2871);
var collector_1 = __webpack_require__(5725);
var IntervalAlgorithms = (function () {
    function IntervalAlgorithms() {
    }
    IntervalAlgorithms.oneConstainsOtherArraysOfInterval = function (mergedIntervalsA, intervalsB) {
        var shouldBeContais = list_1.ListUtils.deepCopy(intervalsB);
        var currenInterval = shouldBeContais.pop();
        while (currenInterval) {
            if (!list_1.ListUtils.unsafeAnyOf(mergedIntervalsA, function (mergedInterval) { return mergedInterval.containsInterval(currenInterval); }))
                return false;
            currenInterval = shouldBeContais.pop();
        }
        return true;
    };
    IntervalAlgorithms.getIntersection = function (intervalA, intervalB) {
        return IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, intervalA);
    };
    IntervalAlgorithms.getIntersectionTemplate = function (intervalA, intervalB, template) {
        var start = Math.max(intervalA.start, intervalB.start);
        var end = Math.min(intervalA.end, intervalB.end);
        if (start > end)
            return null;
        return template.makeByStartEnd(start, end);
    };
    IntervalAlgorithms.getIntersectionNonNullLength = function (intervalA, intervalB) {
        return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(intervalA, intervalB, intervalA);
    };
    IntervalAlgorithms.getIntersectionNonNullLengthTemplate = function (intervalA, intervalB, template) {
        var inters = IntervalAlgorithms.getIntersectionTemplate(intervalA, intervalB, template);
        return inters && inters.length ? inters : null;
    };
    IntervalAlgorithms.getIntersectionsTwoArraysOfInterval = function (intervalsA, intervalsB) {
        return IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate(intervalsA, intervalsB, intervalsA[0]);
    };
    IntervalAlgorithms.getIntersectionsTwoArraysOfIntervalTemplate = function (intervalsA, intervalsB, template) {
        var result = [];
        var lengthIntervalsA = intervalsA.length;
        var lengthIntervalsB = intervalsB.length;
        var intervalsAIndex = 0;
        var intervalsBIndex = 0;
        var currAInterval = intervalsA[intervalsAIndex];
        var currBInterval = intervalsB[intervalsBIndex];
        var currResultInterval = null;
        while (intervalsAIndex < lengthIntervalsA && intervalsBIndex < lengthIntervalsB) {
            var intersection = IntervalAlgorithms.getIntersectionTemplate(currAInterval, currBInterval, template);
            if (intersection) {
                if (currResultInterval && currResultInterval.end === intersection.start)
                    currResultInterval.length += intersection.length;
                else {
                    currResultInterval = intersection;
                    result.push(currResultInterval);
                }
            }
            if (currAInterval.end < currBInterval.end) {
                intervalsAIndex++;
                currAInterval = intervalsA[intervalsAIndex];
            }
            else {
                intervalsBIndex++;
                currBInterval = intervalsB[intervalsBIndex];
            }
        }
        return result;
    };
    IntervalAlgorithms.getAffectedObjects = function (objects, intervals, getFirstIndex, conflictResolver) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        if (conflictResolver === void 0) { conflictResolver = function (objectInterval, touchingIntervalLength, touchPoint) {
            return objectInterval.start === touchPoint && touchingIntervalLength === 0;
        }; }
        return IntervalAlgorithms.getAffectedObjectsTemplate(objects, intervals, intervals[0], getFirstIndex, conflictResolver);
    };
    IntervalAlgorithms.getAffectedObjectsTemplate = function (objects, intervals, template, getFirstIndex, conflictResolver) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        if (conflictResolver === void 0) { conflictResolver = function (objectInterval, touchingIntervalLength, touchPoint) {
            return objectInterval.start === touchPoint && touchingIntervalLength === 0;
        }; }
        var collector = new collector_1.SparseIntervalsCollector(template);
        for (var _i = 0, intervals_1 = intervals; _i < intervals_1.length; _i++) {
            var interval = intervals_1[_i];
            var ind = Math.max(0, getFirstIndex(interval.start, objects));
            for (var obj = void 0; obj = objects[ind]; ind++) {
                var objInterval = obj.interval;
                if (objInterval.start > interval.end)
                    break;
                var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                if (intersection && (intersection.length || conflictResolver(objInterval, interval.length, intersection.start)))
                    collector.add(ind);
            }
        }
        return collector.getIntervals();
    };
    IntervalAlgorithms.handleAffectedObjects = function (objects, intervals, callback, getFirstIndex) {
        if (getFirstIndex === void 0) { getFirstIndex = function (start) {
            return search_1.SearchUtils.normedInterpolationIndexOf(objects, function (obj) { return obj.interval.start; }, start);
        }; }
        var template = new fixed_1.FixedInterval(0, 0);
        for (var _i = 0, intervals_2 = intervals; _i < intervals_2.length; _i++) {
            var interval = intervals_2[_i];
            var ind = Math.max(0, getFirstIndex(interval.start, objects));
            for (var obj = void 0; obj = objects[ind]; ind++) {
                var objInterval = obj.interval;
                if (objInterval.start > interval.end)
                    break;
                var intersection = IntervalAlgorithms.getIntersectionTemplate(objInterval, interval, template);
                if (intersection)
                    callback(obj, ind, interval, intersection);
            }
        }
    };
    IntervalAlgorithms.getMergedIntervals = function (intervals, needSort) {
        return IntervalAlgorithms.getMergedIntervalsTemplate(intervals, needSort, intervals[0]);
    };
    IntervalAlgorithms.getMergedIntervalsTemplate = function (intervals, needSort, template) {
        if (intervals.length < 2)
            return intervals.length > 0 ? [template.makeByStartLength(intervals[0].start, intervals[0].length)] : [];
        var sortedIntervals = needSort ?
            [].concat(intervals).sort(function (a, b) { return a.start - b.start; }) :
            intervals;
        var result = [];
        for (var i = 0, interval = void 0; interval = sortedIntervals[i];) {
            var minBound = interval.start;
            var maxBound = interval.end;
            for (++i; (interval = sortedIntervals[i]) !== undefined && (interval.start <= maxBound); i++) {
                if (interval.end > maxBound)
                    maxBound = interval.end;
            }
            result.push(template.makeByStartEnd(minBound, maxBound));
        }
        return result;
    };
    IntervalAlgorithms.reflectIntervals = function (intervals, bounds) {
        return IntervalAlgorithms.reflectIntervalsTemplate(intervals, bounds, bounds);
    };
    IntervalAlgorithms.reflectIntervalsTemplate = function (intervals, bounds, template) {
        if (!intervals.length)
            return [template.makeByStartLength(bounds.start, bounds.length)];
        var lastIntervalEnd = list_1.ListUtils.last(intervals).end;
        var result = list_1.ListUtils.reducedMap(intervals, function (curr, i) {
            return IntervalAlgorithms.getIntersectionNonNullLengthTemplate(template.makeByStartEnd(intervals[i - 1].end, curr.start), bounds, template);
        }, 1);
        if (bounds.start < intervals[0].start)
            result.unshift(template.makeByStartEnd(bounds.start, intervals[0].start));
        if (bounds.end > lastIntervalEnd)
            result.push(template.makeByStartEnd(lastIntervalEnd, bounds.end));
        return result;
    };
    IntervalAlgorithms.reflectionOfPointOnInterval = function (value, valInterval, targetInterval) {
        return (value - valInterval.start) / valInterval.length * targetInterval.length + targetInterval.start;
    };
    return IntervalAlgorithms;
}());
exports.IntervalAlgorithms = IntervalAlgorithms;


/***/ }),

/***/ 2136:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.raiseEvent = exports.RenderUtils = void 0;
var Event_1 = __webpack_require__(5428);
var math_1 = __webpack_require__(594);
var RenderUtils = (function () {
    function RenderUtils() {
    }
    RenderUtils.updateSvgElementSize = function (svgElement, width, height, forExport) {
        svgElement.style.width = width + "px";
        svgElement.style.height = height + "px";
        svgElement.setAttribute("viewBox", "0 0 " + width + " " + height);
        if (forExport) {
            svgElement.setAttribute("width", width.toString());
            svgElement.setAttribute("height", height.toString());
        }
    };
    RenderUtils.removeElement = function (element) {
        element && element.parentNode && element.parentNode.removeChild(element);
    };
    RenderUtils.removeContent = function (element) {
        while (element && element.firstChild)
            element.removeChild(element.firstChild);
    };
    RenderUtils.setElementEventData = function (element, type, key, value) {
        if (type === Event_1.MouseEventElementType.Undefined)
            return;
        element.setAttribute("data-type", type.toString());
        if (key !== undefined)
            element.setAttribute("data-key", key.toString());
        if (value !== undefined)
            element.setAttribute("data-value", value.toString());
    };
    RenderUtils.getElementEventData = function (element) {
        if (element.getAttribute && element.getAttribute("data-type"))
            return new Event_1.MouseEventSource(parseInt(element.getAttribute("data-type")), element.getAttribute("data-key"), element.getAttribute("data-value"));
        var className = element.getAttribute && element.getAttribute("class");
        if (className === "dxdi-page" || className === "dxdi-main")
            return new Event_1.MouseEventSource(Event_1.MouseEventElementType.Document);
    };
    RenderUtils.getHtmlElementStylePropertyName = function (propertyName) {
        switch (propertyName) {
            case "fill":
                return "color";
            case "text-anchor":
                return "text-align";
        }
        return propertyName;
    };
    RenderUtils.getTextAnchorValue = function (propertyValue, reverseTextAnchor) {
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        if (reverseTextAnchor) {
            if (propertyValue === "start")
                return "end";
            if (propertyValue === "end")
                return "start";
        }
        return propertyValue;
    };
    RenderUtils.getStrokeDasharrayValue = function (propertyValue, strokeWidth) {
        if (strokeWidth) {
            var dashArray = propertyValue && propertyValue.toString();
            var dashArrayParts = dashArray ? dashArray.split(/[\s,]+/) : [];
            return dashArrayParts.map(function (v) { return parseInt(v) / 2 * strokeWidth; }).join(",");
        }
        return propertyValue;
    };
    RenderUtils.applyStyleToElement = function (style, element, reverseTextAnchor) {
        var _this = this;
        if (reverseTextAnchor === void 0) { reverseTextAnchor = false; }
        var defaultStyle = style.getDefaultInstance();
        style.forEach(function (propertyName) {
            var propertyValue = style[propertyName];
            var elPropertyName = (element instanceof HTMLElement) ? _this.getHtmlElementStylePropertyName(propertyName) : propertyName;
            if (propertyValue !== undefined && propertyValue !== "" && propertyValue !== defaultStyle[propertyName]) {
                switch (propertyName) {
                    case "text-anchor":
                        propertyValue = _this.getTextAnchorValue(propertyValue, reverseTextAnchor);
                        break;
                    case "stroke-dasharray":
                        propertyValue = _this.getStrokeDasharrayValue(propertyValue, parseInt(style["stroke-width"]));
                        break;
                }
                element.style.setProperty(elPropertyName, propertyValue);
            }
            else
                element.style.setProperty(elPropertyName, "");
        });
    };
    RenderUtils.generateSvgElementId = function (prefix) {
        return prefix + "_" + math_1.MathUtils.generateGuid();
    };
    RenderUtils.getUrlPathById = function (id) {
        return "url(#" + id + ")";
    };
    return RenderUtils;
}());
exports.RenderUtils = RenderUtils;
function raiseEvent(evt, _evt, raiseFunc) {
    raiseFunc(_evt);
    if (_evt.preventDefault)
        evt.preventDefault();
}
exports.raiseEvent = raiseEvent;


/***/ }),

/***/ 2175:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataLayoutParameters = exports.DataLayoutType = void 0;
var LayoutSettings_1 = __webpack_require__(9212);
var WideTree_1 = __webpack_require__(8533);
var Sugiyama_1 = __webpack_require__(2626);
var DataLayoutType;
(function (DataLayoutType) {
    DataLayoutType[DataLayoutType["Tree"] = 0] = "Tree";
    DataLayoutType[DataLayoutType["Sugiyama"] = 1] = "Sugiyama";
})(DataLayoutType = exports.DataLayoutType || (exports.DataLayoutType = {}));
var DataLayoutParameters = (function () {
    function DataLayoutParameters(sizeSettings, parameter) {
        this.sizeSettings = sizeSettings;
        if (parameter) {
            if (parameter.type !== undefined) {
                this.layoutType = parameter.type;
                this.layoutSettings = this.layoutType === DataLayoutType.Sugiyama ? new LayoutSettings_1.LayoutSettings() : new LayoutSettings_1.TreeLayoutSettings();
            }
            if (parameter.orientation !== undefined)
                this.layoutSettings.orientation = parameter.orientation;
            this.skipPointIndices = parameter.skipPointIndices;
            this.autoSizeEnabled = parameter.autoSizeEnabled;
        }
    }
    Object.defineProperty(DataLayoutParameters.prototype, "needAutoLayout", {
        get: function () { return this.layoutType !== undefined; },
        enumerable: false,
        configurable: true
    });
    DataLayoutParameters.prototype.getLayoutBuilder = function (graph) {
        return (this.layoutType === DataLayoutType.Tree) ?
            new WideTree_1.TreeLayoutBuilder(this.layoutSettings, graph) :
            new Sugiyama_1.SugiyamaLayoutBuilder(this.layoutSettings, graph);
    };
    return DataLayoutParameters;
}());
exports.DataLayoutParameters = DataLayoutParameters;


/***/ }),

/***/ 2198:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageLandscapeCommand = void 0;
var ChangePagePropertyCommand_1 = __webpack_require__(1540);
var ChangePageLandscapeHistoryItem_1 = __webpack_require__(8912);
var ChangePageLandscapeCommand = (function (_super) {
    __extends(ChangePageLandscapeCommand, _super);
    function ChangePageLandscapeCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangePageLandscapeCommand.prototype.getValue = function () {
        return this.control.model.pageLandscape;
    };
    ChangePageLandscapeCommand.prototype.createHistoryItems = function (parameter) {
        return [new ChangePageLandscapeHistoryItem_1.ChangePageLandscapeHistoryItem(parameter)];
    };
    return ChangePageLandscapeCommand;
}(ChangePagePropertyCommand_1.ChangePagePropertyCommand));
exports.ChangePageLandscapeCommand = ChangePageLandscapeCommand;


/***/ }),

/***/ 2270:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerZoomOnPinchState = void 0;
var Settings_1 = __webpack_require__(9307);
var point_1 = __webpack_require__(5327);
var MouseHandlerScrollingState_1 = __webpack_require__(2325);
var metrics_1 = __webpack_require__(4496);
var PINCH_CHANGE_DISTANCE = 1;
var MouseHandlerZoomOnPinchState = (function (_super) {
    __extends(MouseHandlerZoomOnPinchState, _super);
    function MouseHandlerZoomOnPinchState(handler, selection, settings, view) {
        var _this = _super.call(this, handler, view, selection) || this;
        _this.selection = selection;
        _this.settings = settings;
        _this.view = view;
        return _this;
    }
    MouseHandlerZoomOnPinchState.prototype.onMouseDown = function (evt) {
        _super.prototype.onMouseDown.call(this, evt);
        if (evt.touches.length > 1) {
            this.startDistance = this.getTouchDistance(evt);
            this.startZoomLevel = this.settings.zoomLevel;
            this.prevDistance = this.startDistance;
        }
    };
    MouseHandlerZoomOnPinchState.prototype.onMouseMove = function (evt) {
        if (evt.touches.length > 1) {
            var distance = this.getTouchDistance(evt);
            if (Math.abs(this.prevDistance - distance) > PINCH_CHANGE_DISTANCE) {
                this.settings.zoomLevel = this.startZoomLevel * (distance / this.startDistance);
                this.view.scrollTo(this.getMiddleLayoutPoint(evt), this.getMiddleAbsPoint(evt));
                this.view.normalize();
                this.prevDistance = distance;
            }
        }
        _super.prototype.onMouseMove.call(this, evt);
    };
    MouseHandlerZoomOnPinchState.prototype.onMouseUp = function (evt) {
        if (evt.touches.length === 0)
            setTimeout(function () {
                this.handler.switchToDefaultState();
            }.bind(this), 1);
    };
    MouseHandlerZoomOnPinchState.prototype.start = function () {
        _super.prototype.start.call(this);
        this.settings.zoomLevel = this.view.getZoom();
        this.settings.autoZoom = Settings_1.AutoZoomMode.Disabled;
    };
    MouseHandlerZoomOnPinchState.prototype.getTouchDistance = function (evt) {
        var pt0 = new point_1.Point(evt.touches[0].offsetPoint.x, evt.touches[0].offsetPoint.y);
        var pt1 = new point_1.Point(evt.touches[1].offsetPoint.x, evt.touches[1].offsetPoint.y);
        return metrics_1.Metrics.euclideanDistance(pt0, pt1);
    };
    MouseHandlerZoomOnPinchState.prototype.getPointByEvent = function (evt) {
        return this.getMiddleAbsPoint(evt);
    };
    MouseHandlerZoomOnPinchState.prototype.getMiddleAbsPoint = function (evt) {
        if (evt.touches.length > 1)
            return MouseHandlerZoomOnPinchState.getMiddlePointByEvent(evt, function (touch) { return touch.offsetPoint; });
        return evt.offsetPoint;
    };
    MouseHandlerZoomOnPinchState.prototype.getMiddleLayoutPoint = function (evt) {
        if (evt.touches.length > 1)
            return MouseHandlerZoomOnPinchState.getMiddlePointByEvent(evt, function (touch) { return touch.modelPoint; });
        return evt.modelPoint;
    };
    MouseHandlerZoomOnPinchState.getMiddlePointByEvent = function (evt, getPoint) {
        if (evt.touches.length > 1)
            return new point_1.Point((getPoint(evt.touches[0]).x + getPoint(evt.touches[1]).x) / 2, (getPoint(evt.touches[0]).y + getPoint(evt.touches[1]).y) / 2);
    };
    return MouseHandlerZoomOnPinchState;
}(MouseHandlerScrollingState_1.MouseHandlerScrollingState));
exports.MouseHandlerZoomOnPinchState = MouseHandlerZoomOnPinchState;


/***/ }),

/***/ 2325:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerScrollingState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(9589);
var Event_1 = __webpack_require__(5428);
var point_1 = __webpack_require__(5327);
var MouseHandlerScrollingState = (function (_super) {
    __extends(MouseHandlerScrollingState, _super);
    function MouseHandlerScrollingState(handler, view, selection) {
        var _this = _super.call(this, handler) || this;
        _this.view = view;
        _this.selection = selection;
        _this.lastOffset = new point_1.Point(0, 0);
        return _this;
    }
    MouseHandlerScrollingState.prototype.onKeyUp = function (evt) {
        this.handler.onFinishScrollPageByKeyboard(evt);
    };
    MouseHandlerScrollingState.prototype.onMouseDown = function (evt) {
        evt.preventDefault = true;
        this.startPoint = this.getPointByEvent(evt);
    };
    MouseHandlerScrollingState.prototype.onMouseMove = function (evt) {
        if (evt.button !== Event_1.MouseButton.Left) {
            this.handler.onFinishScrollPageByMouse(evt);
            return;
        }
        var prevPoint = this.currentPoint || this.startPoint;
        evt.preventDefault = true;
        var point = this.getPointByEvent(evt);
        var actualOffset = this.view.scrollBy(new point_1.Point(point.x - prevPoint.x, point.y - prevPoint.y));
        this.lastOffset = this.lastOffset.clone().offset(actualOffset.x, actualOffset.y);
        this.currentPoint = point;
    };
    MouseHandlerScrollingState.prototype.onMouseUp = function (evt) {
        if (evt.button === Event_1.MouseButton.Left)
            this.handler.onFinishScrollPageByMouse(evt);
        this.handler.switchToDefaultState();
    };
    MouseHandlerScrollingState.prototype.cancelChanges = function () {
        if (this.currentPoint)
            this.view.scrollBy(this.lastOffset.clone().multiply(-1, -1));
    };
    MouseHandlerScrollingState.prototype.finish = function () {
        if (!this.currentPoint || !this.startPoint || this.currentPoint.equals(this.startPoint))
            this.selection.set([]);
        _super.prototype.finish.call(this);
    };
    MouseHandlerScrollingState.prototype.getPointByEvent = function (evt) {
        return evt.offsetPoint;
    };
    return MouseHandlerScrollingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerScrollingState = MouseHandlerScrollingState;


/***/ }),

/***/ 2383:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExportSvgCommand = void 0;
var ExportImageCommand_1 = __webpack_require__(6634);
var ExportSvgCommand = (function (_super) {
    __extends(ExportSvgCommand, _super);
    function ExportSvgCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExportSvgCommand.prototype.getExtension = function () { return "svg"; };
    ExportSvgCommand.prototype.getExportFunc = function () {
        return this.exporter.exportSvg;
    };
    return ExportSvgCommand;
}(ExportImageCommand_1.ExportImageCommand));
exports.ExportSvgCommand = ExportSvgCommand;


/***/ }),

/***/ 2389:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeShapeTypeHistoryItem = void 0;
var ShapeParameters_1 = __webpack_require__(4636);
var HistoryItem_1 = __webpack_require__(2616);
var ChangeShapeTypeHistoryItem = (function (_super) {
    __extends(ChangeShapeTypeHistoryItem, _super);
    function ChangeShapeTypeHistoryItem(shape, newType) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shape.key;
        _this.newType = newType;
        return _this;
    }
    ChangeShapeTypeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldType = shape.description.key;
        this.oldParameters = shape.parameters.clone();
        manipulator.updateShapeType(shape, this.newType, new ShapeParameters_1.ShapeParameters());
    };
    ChangeShapeTypeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.updateShapeType(shape, this.oldType, this.oldParameters);
    };
    return ChangeShapeTypeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeShapeTypeHistoryItem = ChangeShapeTypeHistoryItem;


/***/ }),

/***/ 2392:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ManualOperationShapeDescription = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var PathPrimitive_1 = __webpack_require__(6208);
var DiagramItem_1 = __webpack_require__(4824);
var ShapeDescription_1 = __webpack_require__(1280);
var ManualOperationShapeDescription = (function (_super) {
    __extends(ManualOperationShapeDescription, _super);
    function ManualOperationShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(ManualOperationShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ManualOperation; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ManualOperationShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    ManualOperationShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var _a = shape.rectangle, left = _a.x, top = _a.y, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(ManualOperationShapeDescription.slopeAngle)), width);
        var cx = rect.center.x;
        var x1 = Math.min(left + px, cx);
        var x2 = Math.max(right - px, cx);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ManualOperationShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var offset = shape.size.height / Math.tan(ManualOperationShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    ManualOperationShapeDescription.prototype.getTextRectangle = function (shape) {
        var px = Math.min(Math.max(0, shape.size.height / Math.tan(ManualOperationShapeDescription.slopeAngle)), shape.size.width);
        return shape.rectangle.clone()
            .moveRectangle(px, ShapeDescription_1.ShapeTextPadding)
            .resize(-px * 2, -ShapeDescription_1.ShapeTextPadding * 2)
            .nonNegativeSize();
    };
    ManualOperationShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return ManualOperationShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.ManualOperationShapeDescription = ManualOperationShapeDescription;


/***/ }),

/***/ 2394:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextMenuTouchHandler = void 0;
var Event_1 = __webpack_require__(5428);
var ContextMenuHandler_1 = __webpack_require__(2803);
var ModelUtils_1 = __webpack_require__(1922);
var SELECTION_CHANGED_EVENT = 1;
var ContextMenuTouchHandler = (function (_super) {
    __extends(ContextMenuTouchHandler, _super);
    function ContextMenuTouchHandler(selection) {
        var _this = _super.call(this) || this;
        _this.selection = selection;
        _this.contextToolboxVisible = false;
        _this.selection.onChanged.add(_this);
        return _this;
    }
    ContextMenuTouchHandler.prototype.onMouseDown = function (evt) {
        if (evt.source.key === undefined)
            this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.onMouseUp = function (evt) {
    };
    ContextMenuTouchHandler.prototype.onFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showContextMenuAtSelection(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideContextMenu(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onTextInputFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideContextMenu(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onTextInputBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showContextMenuAtSelection(); }, 1);
    };
    ContextMenuTouchHandler.prototype.onLongTouch = function (evt) {
        if (evt.source.type === Event_1.MouseEventElementType.Document)
            this.showContextMenuAtEmptySelection(evt.modelPoint);
    };
    ContextMenuTouchHandler.prototype.onKeyDown = function (evt) {
    };
    ContextMenuTouchHandler.prototype.onShortcut = function (evt) {
    };
    ContextMenuTouchHandler.prototype.getSelectedItems = function () {
        return this.selection.getSelectedItems(true);
    };
    ContextMenuTouchHandler.prototype.showContextMenuAtSelection = function () {
        if (this.contextToolboxVisible)
            return;
        var items = this.getSelectedItems();
        if (items.length !== 0)
            this.showContextMenu(undefined, ModelUtils_1.ModelUtils.createRectangle(items).createPosition());
    };
    ContextMenuTouchHandler.prototype.showContextMenuAtEmptySelection = function (point) {
        if (this.contextToolboxVisible)
            return;
        var items = this.getSelectedItems();
        if (items.length === 0)
            this.showContextMenu(undefined, point);
    };
    ContextMenuTouchHandler.prototype.notifyDragStart = function (itemKeys) {
        this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.notifyDragEnd = function (itemKeys) {
        this.showContextMenuAtSelection();
    };
    ContextMenuTouchHandler.prototype.notifySelectionChanged = function (selection) {
        if (this.isUpdateLocked())
            this.registerOccurredEvent(SELECTION_CHANGED_EVENT);
        else
            this.raiseSelectionChanged();
    };
    ContextMenuTouchHandler.prototype.raiseSelectionChanged = function () {
        var items = this.getSelectedItems();
        if (items.length !== 0)
            this.showContextMenuAtSelection();
        else
            this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.onUpdateUnlocked = function (occurredEvents) {
        if (occurredEvents & SELECTION_CHANGED_EVENT)
            this.raiseSelectionChanged();
    };
    ContextMenuTouchHandler.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) {
        this.contextToolboxVisible = true;
        this.hideContextMenu();
    };
    ContextMenuTouchHandler.prototype.notifyHideContextToolbox = function () {
        this.contextToolboxVisible = false;
        this.showContextMenuAtSelection();
    };
    return ContextMenuTouchHandler;
}(ContextMenuHandler_1.ContextMenuHandler));
exports.ContextMenuTouchHandler = ContextMenuTouchHandler;


/***/ }),

/***/ 2408:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SendToBackCommand = void 0;
var ChangeZindexHistoryItem_1 = __webpack_require__(672);
var SimpleCommandBase_1 = __webpack_require__(3913);
var SendToBackCommand = (function (_super) {
    __extends(SendToBackCommand, _super);
    function SendToBackCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SendToBackCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length > 0 && this.needSendToBack(items);
    };
    SendToBackCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMinZIndex(item) - 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    SendToBackCommand.prototype.needSendToBack = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMinZIndex(items[i]);
            if (zIndex < items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) < _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return SendToBackCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.SendToBackCommand = SendToBackCommand;


/***/ }),

/***/ 2428:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SparseIntervals = void 0;
var iterator_1 = __webpack_require__(1454);
var objects_iterator_1 = __webpack_require__(149);
var SparseIntervals = (function () {
    function SparseIntervals(list) {
        if (list === void 0) { list = []; }
        this.list = list;
        this._count = 0;
        this._numIntervals = 0;
        for (var _i = 0, list_1 = list; _i < list_1.length; _i++) {
            var curr = list_1[_i];
            this._count += curr.length;
            this._numIntervals++;
        }
    }
    Object.defineProperty(SparseIntervals.prototype, "count", {
        get: function () {
            return this._count;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(SparseIntervals.prototype, "numIntervals", {
        get: function () {
            return this._numIntervals;
        },
        enumerable: false,
        configurable: true
    });
    SparseIntervals.prototype.getInterval = function (index) {
        return this.list[index];
    };
    SparseIntervals.prototype.getNativeIterator = function () {
        return new iterator_1.SparseIntervalsIterator(this);
    };
    SparseIntervals.prototype.getObjectsIterator = function (objects) {
        return new objects_iterator_1.SparseObjectsIterator(this, objects);
    };
    return SparseIntervals;
}());
exports.SparseIntervals = SparseIntervals;


/***/ }),

/***/ 2444:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArrowRightShapeDescription = void 0;
var PathPrimitive_1 = __webpack_require__(6208);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(9090);
var ShapeParameterPoint_1 = __webpack_require__(9763);
var point_1 = __webpack_require__(5327);
var ShapeTypes_1 = __webpack_require__(3255);
var DiagramItem_1 = __webpack_require__(4824);
var ArrowRightShapeDescription = (function (_super) {
    __extends(ArrowRightShapeDescription, _super);
    function ArrowRightShapeDescription() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ArrowRightShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowRight; },
        enumerable: false,
        configurable: true
    });
    ArrowRightShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cy = rect.center.y;
        var p0dx = width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowRightShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value - deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowRightShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new point_1.Point(shape.normalizeX(shape.position.x + shape.size.width - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    ArrowRightShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var triangleWidth = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        if (point.x > shape.position.x + shape.size.width - triangleWidth) {
            var tg = shape.size.height / 2 / triangleWidth;
            var delta = (point.x - (shape.position.x + shape.size.width - triangleWidth)) * tg;
            var side = shape.getConnectionPointSide(point);
            if (side === DiagramItem_1.ConnectionPointSide.North)
                point.y += delta;
            else if (side === DiagramItem_1.ConnectionPointSide.South)
                point.y -= delta;
        }
        else
            _super.prototype.processConnectionPoint.call(this, shape, point);
    };
    return ArrowRightShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowRightShapeDescription = ArrowRightShapeDescription;


/***/ }),

/***/ 2448:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorPropertyHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangeConnectorPropertyHistoryItem = (function (_super) {
    __extends(ChangeConnectorPropertyHistoryItem, _super);
    function ChangeConnectorPropertyHistoryItem(connectorKey, propertyName, value) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connectorKey;
        _this.propertyName = propertyName;
        _this.value = value;
        return _this;
    }
    ChangeConnectorPropertyHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldValue = connector.properties[this.propertyName];
        manipulator.changeConnectorProperty(connector, this.propertyName, this.value);
    };
    ChangeConnectorPropertyHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorProperty(connector, this.propertyName, this.oldValue);
    };
    return ChangeConnectorPropertyHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorPropertyHistoryItem = ChangeConnectorPropertyHistoryItem;


/***/ }),

/***/ 2564:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalNorthSideCalculator = void 0;
var DiagramItem_1 = __webpack_require__(4824);
var ConnectorPointsOrthogonalSideCalculatorBase_1 = __webpack_require__(3976);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ConnectorPointsOrthogonalNorthSideCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalNorthSideCalculator, _super);
    function ConnectorPointsOrthogonalNorthSideCalculator(parent) {
        return _super.call(this, parent) || this;
    }
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getCorrectOriginPoint = function (originPoint, originRect) {
        if (originPoint.y > originRect.y)
            originPoint = originPoint.clone().offset(0, originRect.y - originPoint.y);
        return originPoint;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getSameShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
            case DiagramItem_1.ConnectionPointSide.West:
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset());
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getOverlappedPointsOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.South:
                return [originPoint.clone().offset(0, this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
        }
        return [];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (originPoint.y > targetPoint.y)
                    if (originPoint.x > targetPoint.x)
                        return [];
                    else
                        return [originPoint.clone().offset(0, -this.getMinOffset())];
                if (originPoint.y < this.endRect.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.West:
                if (originPoint.y > targetPoint.y)
                    if (originPoint.x < targetPoint.x)
                        return [];
                    else
                        return [originPoint.clone().offset(0, -this.getMinOffset())];
                if (originPoint.y < this.endRect.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), originPoint.x < targetPoint.x);
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOverlappedShapeOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), false);
                if (originPoint.x < targetPoint.x)
                    return [originPoint.clone().offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.West:
                if (targetPoint.y > originPoint.y)
                    return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, this.getMinOffset(), this.getMinOffset(), true);
                if (originPoint.x > targetPoint.x)
                    return [originPoint.clone().offset(0, -this.getMinOffset())];
                return [];
            case DiagramItem_1.ConnectionPointSide.North:
                return [originPoint.clone().offset(0, -this.getMinOffset())];
            case DiagramItem_1.ConnectionPointSide.South: {
                var offset = -this.getMinOffset();
                if (this.beginRect.y < originPoint.y)
                    offset -= originPoint.y - this.beginRect.y;
                return [originPoint.clone().offset(0, offset)];
            }
        }
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOnSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getBeginOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        switch (targetSide) {
            case DiagramItem_1.ConnectionPointSide.East:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, false);
                break;
            case DiagramItem_1.ConnectionPointSide.West:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false, true);
                break;
            case DiagramItem_1.ConnectionPointSide.North:
                if (this.isBeginEndOverlappedX())
                    return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
                break;
            case DiagramItem_1.ConnectionPointSide.Undefined:
            case DiagramItem_1.ConnectionPointSide.South:
                return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, false);
        }
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, false))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getEndOffSideOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        if (targetSide === DiagramItem_1.ConnectionPointSide.Undefined)
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true);
        else if (this.isBeginEndOverlappedX()) {
            var direction = this.beginRect.center.x > this.endRect.center.x;
            return this.getScaleableAsideOffsetPoints(originPoint, targetPoint, originRect, true, direction);
        }
        return [originPoint.clone().offset(0, -this.getScaleableOffsetY(originPoint, targetPoint, true))];
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getAsideOffsetPoints = function (originPoint, targetPoint, originRect, offset, asideOffset, direction) {
        var points = [];
        if (originRect !== undefined) {
            if (direction === undefined)
                direction = targetPoint.x < originPoint.x;
            if (direction)
                points.push(originPoint.clone().offset(-(originPoint.x - originRect.x + asideOffset), -offset));
            else
                points.push(originPoint.clone().offset((originRect.right - originPoint.x + asideOffset), -offset));
        }
        points.push(originPoint.clone().offset(0, -offset));
        return points;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableAsideOffsetPoints = function (originPoint, targetPoint, originRect, isEnd, direction) {
        var offset = this.getScaleableOffsetY(originPoint, targetPoint, isEnd);
        var asideOffset = this.getScaleableOffsetX(originPoint, targetPoint, isEnd);
        return this.getAsideOffsetPoints(originPoint, targetPoint, originRect, offset, asideOffset, direction);
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetX = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect)
            if (!isEnd && !this.isBeginEndOverlappedX()) {
                var distance = void 0;
                if (targetPoint.x < originPoint.x)
                    distance = this.beginRect.x - this.endRect.right;
                else
                    distance = this.endRect.x - this.beginRect.right;
                if (distance < this.getMinOffset() * 2)
                    return distance / 2;
            }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getScaleableOffsetY = function (originPoint, targetPoint, isEnd) {
        if (this.beginRect && this.endRect) {
            var distance = isEnd ? originPoint.y - this.beginRect.bottom : originPoint.y - this.endRect.bottom;
            if (distance > 0 && distance < this.getMinOffset() * 2)
                return distance / 2;
        }
        return this.getMinOffset();
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isOnSidePoint = function (originPoint, targetPoint) {
        return targetPoint.y < originPoint.y;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.isDirectConnectionAllowed = function (targetSide, originPoint, targetPoint) {
        return targetSide === DiagramItem_1.ConnectionPointSide.South || targetSide === DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalNorthSideCalculator.prototype.getDirectConnectionPoints = function (originPoint, targetPoint) {
        var cy = targetPoint.y + (originPoint.y - targetPoint.y) / 2;
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(originPoint.x, cy),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(targetPoint.x, cy)
        ];
    };
    return ConnectorPointsOrthogonalNorthSideCalculator;
}(ConnectorPointsOrthogonalSideCalculatorBase_1.ConnectorPointsOrthogonalSideCalculatorBase));
exports.ConnectorPointsOrthogonalNorthSideCalculator = ConnectorPointsOrthogonalNorthSideCalculator;


/***/ }),

/***/ 2567:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CustomShapeDescription = void 0;
var ImagePrimitive_1 = __webpack_require__(4);
var rectangle_1 = __webpack_require__(4412);
var size_1 = __webpack_require__(3844);
var point_1 = __webpack_require__(5327);
var ConnectionPoint_1 = __webpack_require__(4856);
var DiagramItem_1 = __webpack_require__(4824);
var ShapeWithImageDescription_1 = __webpack_require__(7185);
var ShapeDescription_1 = __webpack_require__(1280);
var ImageInfo_1 = __webpack_require__(9406);
var ImageCache_1 = __webpack_require__(4062);
var ImageLoader_1 = __webpack_require__(7841);
var SvgElementPrimitive_1 = __webpack_require__(9551);
var CustomShapeDescription = (function (_super) {
    __extends(CustomShapeDescription, _super);
    function CustomShapeDescription(properties, baseDescription) {
        var _this = _super.call(this, new size_1.Size(properties.defaultWidth || baseDescription && baseDescription.defaultSize.width || ShapeDescription_1.ShapeDefaultDimension, properties.defaultHeight || baseDescription && baseDescription.defaultSize.height || ShapeDescription_1.ShapeDefaultDimension)) || this;
        _this.properties = properties;
        _this.baseDescription = baseDescription;
        _this.imageLoader = new ImageLoader_1.ImageLoader(_this.updateSvgImage.bind(_this));
        _this.defaultText = properties.defaultText !== undefined ? properties.defaultText : baseDescription && baseDescription.getDefaultText();
        _this.defaultImageUrl = properties.defaultImageUrl || baseDescription && baseDescription.getDefaultImageUrl();
        _this.title = properties.title || baseDescription && baseDescription.getTitle() || _this.defaultText || "";
        _this.connectionPoints = _this.createConnectionPoints();
        if (properties.svgUrl) {
            _this.svgImage = new ImageInfo_1.ImageInfo(properties.svgUrl);
            var cachedImage = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(_this.svgImage);
            _this.imageLoader.load(cachedImage);
        }
        if (properties.svgToolboxUrl) {
            _this.svgToolboxImage = new ImageInfo_1.ImageInfo(properties.svgToolboxUrl);
            var cachedImage = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(_this.svgToolboxImage);
            _this.imageLoader.load(cachedImage);
        }
        return _this;
    }
    Object.defineProperty(CustomShapeDescription.prototype, "key", {
        get: function () { return this.properties.type; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "allowEditText", {
        get: function () { return this.properties.allowEditText !== false; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "allowEditImage", {
        get: function () { return this.baseDescription ? this.baseDescription.allowEditImage : this.properties.allowEditImage === true; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "enableChildren", {
        get: function () { return this.baseDescription && this.baseDescription.enableChildren; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "hasTemplate", {
        get: function () { return !!this.properties.createTemplate; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "minWidth", {
        get: function () { return this.properties.minWidth || this.baseDescription && this.baseDescription.minWidth; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "minHeight", {
        get: function () { return this.properties.minHeight || this.baseDescription && this.baseDescription.minHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "maxWidth", {
        get: function () { return this.properties.maxWidth || this.baseDescription && this.baseDescription.maxWidth; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "maxHeight", {
        get: function () { return this.properties.maxHeight || this.baseDescription && this.baseDescription.maxHeight; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return this.properties.keepRatioOnAutoSize; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CustomShapeDescription.prototype, "toolboxSize", {
        get: function () {
            if (this.properties.toolboxWidthToHeightRatio)
                return new size_1.Size(this.defaultSize.width, this.defaultSize.width / this.properties.toolboxWidthToHeightRatio);
            return this.defaultSize;
        },
        enumerable: false,
        configurable: true
    });
    CustomShapeDescription.prototype.getTextAngle = function () {
        return (this.baseDescription && this.baseDescription.getTextAngle()) || _super.prototype.getTextAngle.call(this);
    };
    CustomShapeDescription.prototype.getTitle = function () {
        return this.title !== undefined ? this.title : _super.prototype.getTitle.call(this);
    };
    CustomShapeDescription.prototype.getDefaultText = function () {
        return this.defaultText !== undefined ? this.defaultText : _super.prototype.getDefaultText.call(this);
    };
    CustomShapeDescription.prototype.getDefaultImageUrl = function () {
        return this.defaultImageUrl !== undefined ? this.defaultImageUrl : _super.prototype.getDefaultImageUrl.call(this);
    };
    CustomShapeDescription.prototype.allowResizeHorizontally = function (shape) {
        if (this.properties.allowResize === false)
            return false;
        if (this.baseDescription)
            return this.baseDescription.allowResizeHorizontally(shape);
        return _super.prototype.allowResizeHorizontally.call(this, shape);
    };
    CustomShapeDescription.prototype.allowResizeVertically = function (shape) {
        if (this.properties.allowResize === false)
            return false;
        if (this.baseDescription)
            return this.baseDescription.allowResizeVertically(shape);
        return _super.prototype.allowResizeVertically.call(this, shape);
    };
    CustomShapeDescription.prototype.createConnectionPoints = function () {
        if (this.properties && this.properties.connectionPoints && this.properties.connectionPoints.length)
            return this.properties.connectionPoints.map(function (ptObj) {
                if (ptObj && typeof ptObj["x"] === "number" && typeof ptObj["y"] === "number") {
                    var side = typeof ptObj["side"] === "number" ? ptObj["side"] : DiagramItem_1.ConnectionPointSide.Undefined;
                    return new ConnectionPoint_1.ConnectionPoint(ptObj["x"], ptObj["y"], side);
                }
            }).filter(function (pt) { return pt; });
        return _super.prototype.createConnectionPoints.call(this);
    };
    CustomShapeDescription.prototype.getConnectionPointSides = function () {
        var result = {};
        for (var i = 0; i < this.connectionPoints.length; i++) {
            var pointSide = ShapeDescription_1.ShapeDescription.getConnectionPointSideByGeometry(this.connectionPoints[i]);
            if (!result[pointSide])
                result[pointSide] = [];
            result[pointSide].push(i);
        }
        return result;
    };
    CustomShapeDescription.prototype.getConnectionPointIndexForSide = function (side) {
        var connectionPointSides = this.getConnectionPointSides();
        var pointIndexes = connectionPointSides[side];
        if (pointIndexes) {
            var index = Math.floor(pointIndexes.length / 2);
            if (pointIndexes.length % 2 === 0)
                index--;
            return pointIndexes[index];
        }
        else {
            pointIndexes = connectionPointSides[(side + 1) % 4];
            if (pointIndexes)
                return pointIndexes[0];
            else {
                pointIndexes = connectionPointSides[(side + 3) % 4];
                if (pointIndexes)
                    return pointIndexes[pointIndexes.length - 1];
                else {
                    pointIndexes = connectionPointSides[(side + 2) % 4];
                    if (pointIndexes)
                        return pointIndexes[0];
                }
            }
        }
        return side;
    };
    CustomShapeDescription.prototype.createImagePrimitives = function (shape, forToolbox) {
        if (this.baseDescription)
            return this.baseDescription.createImagePrimitives(shape, forToolbox);
        return _super.prototype.createImagePrimitives.call(this, shape, forToolbox);
    };
    CustomShapeDescription.prototype.createShapePrimitives = function (shape, forToolbox) {
        var primitives = [];
        var _a = shape.rectangle, left = _a.x, top = _a.y, width = _a.width, height = _a.height;
        if (this.baseDescription)
            primitives = this.baseDescription.createShapePrimitives(shape, forToolbox);
        else {
            var svgImage = forToolbox && this.svgToolboxImage ? this.svgToolboxImage : this.svgImage;
            if (svgImage) {
                var svgLeft = left + (this.properties.svgLeft && !forToolbox ? this.properties.svgLeft * width : 0);
                var svgTop = top + (this.properties.svgTop && !forToolbox ? this.properties.svgTop * height : 0);
                var svgWidth = this.properties.svgWidth && !forToolbox ? this.properties.svgWidth * width : width;
                var svgHeight = this.properties.svgHeight && !forToolbox ? this.properties.svgHeight * height : height;
                primitives = primitives.concat([
                    new ImagePrimitive_1.ImagePrimitive(svgLeft, svgTop, svgWidth, svgHeight, svgImage.exportUrl)
                ]);
            }
        }
        var createTemplate = forToolbox && this.properties.createToolboxTemplate || this.properties.createTemplate;
        if (createTemplate) {
            var templateLeft = left + (this.properties.templateLeft && !forToolbox ? this.properties.templateLeft * width : 0);
            var templateTop = top + (this.properties.templateTop && !forToolbox ? this.properties.templateTop * height : 0);
            var templateWidth = this.properties.templateWidth && !forToolbox ? this.properties.templateWidth * width : width;
            var templateHeight = this.properties.templateHeight && !forToolbox ? this.properties.templateHeight * height : height;
            var nativeShape = this.properties.apiController ? this.properties.apiController.createNativeShape(shape) : shape.toNative();
            primitives = primitives.concat([
                new SvgElementPrimitive_1.SvgElementPrimitive(templateLeft, templateTop, templateWidth, templateHeight, createTemplate, this.properties.destroyTemplate, nativeShape)
            ]);
        }
        return primitives;
    };
    CustomShapeDescription.prototype.createParameters = function (parameters) {
        if (this.baseDescription)
            return this.baseDescription.createParameters(parameters);
        else
            return _super.prototype.createParameters.call(this, parameters);
    };
    CustomShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        if (this.baseDescription)
            this.baseDescription.normalizeParameters(shape, parameters);
        else
            _super.prototype.normalizeParameters.call(this, shape, parameters);
    };
    CustomShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        if (this.baseDescription)
            this.baseDescription.modifyParameters(shape, parameters, deltaX, deltaY);
        else
            _super.prototype.modifyParameters.call(this, shape, parameters, deltaX, deltaY);
    };
    CustomShapeDescription.prototype.getParameterPoints = function (shape) {
        if (this.baseDescription)
            return this.baseDescription.getParameterPoints(shape);
        else
            return _super.prototype.getParameterPoints.call(this, shape);
    };
    CustomShapeDescription.prototype.getTextRectangle = function (shape) {
        if (this.baseDescription)
            return this.baseDescription.getTextRectangle(shape);
        else {
            var _a = shape.rectangle, left = _a.x, top_1 = _a.y, width = _a.width, height = _a.height;
            return new rectangle_1.Rectangle(left + (this.properties.textLeft ? this.properties.textLeft * width : 0), top_1 + (this.properties.textTop ? this.properties.textTop * height : 0), this.properties.textWidth ? this.properties.textWidth * width : width, this.properties.textHeight ? this.properties.textHeight * height : height);
        }
    };
    CustomShapeDescription.prototype.getSizeByText = function (textSize, shape) {
        if (this.baseDescription)
            return this.baseDescription.getSizeByText(textSize, shape);
        else {
            var textWidth = this.properties.textWidth;
            if (!textWidth)
                textWidth = 1;
            var textHeight = this.properties.textHeight;
            if (!textHeight)
                textHeight = 1;
            return new size_1.Size(textSize.width / textWidth, textSize.height / textHeight);
        }
    };
    CustomShapeDescription.prototype.getImageSize = function (shapeSize, includeMargins, forToolbox) {
        if (this.baseDescription) {
            if (this.baseDescription instanceof ShapeWithImageDescription_1.ShapeWithImageDescription)
                return this.baseDescription.getImageSize(shapeSize, includeMargins, forToolbox);
            return size_1.Size.empty();
        }
        return new size_1.Size(this.properties.imageWidth ? this.properties.imageWidth * shapeSize.width : shapeSize.width, this.properties.imageHeight ? this.properties.imageHeight * shapeSize.height : shapeSize.height)
            .nonNegativeSize();
    };
    CustomShapeDescription.prototype.getImagePlacementRectangle = function (rect, forToolbox) {
        if (this.baseDescription) {
            if (this.baseDescription instanceof ShapeWithImageDescription_1.ShapeWithImageDescription)
                return this.baseDescription.getImagePlacementRectangle(rect, forToolbox);
            return rectangle_1.Rectangle.fromGeometry(point_1.Point.zero(), size_1.Size.empty());
        }
        var left = rect.x, top = rect.y, width = rect.width, height = rect.height;
        return new rectangle_1.Rectangle(left + (this.properties.imageLeft && !forToolbox ? this.properties.imageLeft * width : 0), top + (this.properties.imageTop && !forToolbox ? this.properties.imageTop * height : 0), this.properties.imageWidth && !forToolbox ? this.properties.imageWidth * width : width, this.properties.imageHeight && !forToolbox ? this.properties.imageHeight * height : height);
    };
    CustomShapeDescription.prototype.updateSvgImage = function (cacheImageInfo) {
        var isToolboxImage = this.svgToolboxImage && cacheImageInfo.imageUrl && cacheImageInfo.imageUrl === this.properties.svgToolboxUrl;
        var svgImage = isToolboxImage ? this.svgToolboxImage : this.svgImage;
        if (cacheImageInfo.base64)
            svgImage.loadBase64Content(cacheImageInfo.base64);
        else
            svgImage.setUnableToLoadFlag();
        if (!isToolboxImage)
            this.raiseShapeDescriptionChanged(this);
    };
    return CustomShapeDescription;
}(ShapeWithImageDescription_1.ShapeWithImageDescription));
exports.CustomShapeDescription = CustomShapeDescription;


/***/ }),

/***/ 2616:
/***/ (function(__unused_webpack_module, exports) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CompositionHistoryItem = exports.HistoryItem = void 0;
var HistoryItem = (function () {
    function HistoryItem() {
        this.uniqueId = -1;
    }
    HistoryItem.prototype.changeModified = function () {
        return true;
    };
    HistoryItem.prototype.getName = function () {
        return this.constructor.name;
    };
    return HistoryItem;
}());
exports.HistoryItem = HistoryItem;
var CompositionHistoryItem = (function (_super) {
    __extends(CompositionHistoryItem, _super);
    function CompositionHistoryItem() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.historyItems = [];
        _this.dataSyncItems = [];
        return _this;
    }
    CompositionHistoryItem.prototype.changeModified = function () {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            if (item.changeModified())
                return true;
        return false;
    };
    CompositionHistoryItem.prototype.redo = function (manipulator) {
        var item;
        for (var i = 0; item = this.historyItems[i]; i++)
            item.redo(manipulator);
    };
    CompositionHistoryItem.prototype.undo = function (manipulator) {
        var item;
        for (var i = this.dataSyncItems.length - 1; item = this.dataSyncItems[i]; i--)
            item.undo(manipulator);
        this.dataSyncItems = [];
        for (var i = this.historyItems.length - 1; item = this.historyItems[i]; i--)
            item.undo(manipulator);
    };
    CompositionHistoryItem.prototype.add = function (historyItem) {
        if (historyItem == null)
            throw new Error("cannot be null");
        this.historyItems.push(historyItem);
    };
    return CompositionHistoryItem;
}(HistoryItem));
exports.CompositionHistoryItem = CompositionHistoryItem;


/***/ }),

/***/ 2620:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Data = exports.SetAbsoluteY = exports.SetAbsoluteX = void 0;
var dom_1 = __webpack_require__(750);
var common_1 = __webpack_require__(961);
function IsNumber(str) {
    return !isNaN(parseFloat(str)) && isFinite(str);
}
function SetAbsoluteX(element, x) {
    element.style.left = prepareClientPosForElement(x, element, true) + "px";
}
exports.SetAbsoluteX = SetAbsoluteX;
function SetAbsoluteY(element, y) {
    element.style.top = prepareClientPosForElement(y, element, false) + "px";
}
exports.SetAbsoluteY = SetAbsoluteY;
function prepareClientPosForElement(pos, element, isX) {
    pos -= getPositionElementOffset(element, isX);
    return pos;
}
function getPositionElementOffset(element, isX) {
    var div = createElementMock(element);
    if (div.style.position === "static")
        div.style.position = "absolute";
    element.parentNode.appendChild(div);
    var realPos = isX ? dom_1.DomUtils.getAbsolutePositionX(div) : dom_1.DomUtils.getAbsolutePositionY(div);
    element.parentNode.removeChild(div);
    return Math.round(realPos);
}
function createElementMock(element) {
    var div = document.createElement("DIV");
    div.style.top = "0px";
    div.style.left = "0px";
    div.style.visibility = "hidden";
    div.style.position = dom_1.DomUtils.getCurrentStyle(element).position;
    return div;
}
var Data = (function () {
    function Data() {
    }
    Data.ArrayInsert = function (array, element, position) {
        if (0 <= position && position < array.length) {
            for (var i = array.length; i > position; i--)
                array[i] = array[i - 1];
            array[position] = element;
        }
        else
            array.push(element);
    };
    Data.ArrayRemove = function (array, element) {
        var index = Data.ArrayIndexOf(array, element);
        if (index > -1)
            Data.ArrayRemoveAt(array, index);
    };
    Data.ArrayRemoveAt = function (array, index) {
        if (index >= 0 && index < array.length) {
            for (var i = index; i < array.length - 1; i++)
                array[i] = array[i + 1];
            array.pop();
        }
    };
    Data.ArrayClear = function (array) {
        while (array.length > 0)
            array.pop();
    };
    Data.ArrayIndexOf = function (array, element, comparer) {
        if (!comparer)
            for (var i = 0; i < array.length; i++) {
                if (array[i] === element)
                    return i;
            }
        else
            for (var i = 0; i < array.length; i++)
                if (comparer(array[i], element))
                    return i;
        return -1;
    };
    Data.ArrayContains = function (array, element) {
        return Data.ArrayIndexOf(array, element) >= 0;
    };
    Data.ArrayEqual = function (array1, array2) {
        var count1 = array1.length;
        var count2 = array2.length;
        if (count1 !== count2)
            return false;
        for (var i = 0; i < count1; i++)
            if (array1[i] !== array2[i])
                return false;
        return true;
    };
    Data.ArraySame = function (array1, array2) {
        if (array1.length !== array2.length)
            return false;
        return array1.every(function (elem) { return Data.ArrayContains(array2, elem); });
    };
    Data.ArrayGetIntegerEdgeValues = function (array) {
        var arrayToSort = Data.CollectionToArray(array);
        Data.ArrayIntegerAscendingSort(arrayToSort);
        return {
            start: arrayToSort[0],
            end: arrayToSort[arrayToSort.length - 1]
        };
    };
    Data.ArrayIntegerAscendingSort = function (array) {
        Data.ArrayIntegerSort(array, false);
    };
    Data.ArrayIntegerSort = function (array, desc) {
        array.sort(function (i1, i2) {
            var res = 0;
            if (i1 > i2)
                res = 1;
            else if (i1 < i2)
                res = -1;
            if (desc)
                res *= -1;
            return res;
        });
    };
    Data.CollectionsUnionToArray = function (firstCollection, secondCollection) {
        var result = [];
        var firstCollectionLength = firstCollection.length;
        var secondCollectionLength = secondCollection.length;
        for (var i = 0; i < firstCollectionLength + secondCollectionLength; i++)
            if (i < firstCollectionLength)
                result.push(firstCollection[i]);
            else
                result.push(secondCollection[i - firstCollectionLength]);
        return result;
    };
    Data.CollectionToArray = function (collection) {
        var array = [];
        for (var i = 0; i < collection.length; i++)
            array.push(collection[i]);
        return array;
    };
    Data.CreateHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = 1;
        return hash;
    };
    Data.CreateIndexHashTableFromArray = function (array) {
        var hash = [];
        for (var i = 0; i < array.length; i++)
            hash[array[i]] = i;
        return hash;
    };
    Data.ArrayToHash = function (array, getKeyFunc, getValueFunc) {
        if (!(array instanceof Array))
            return {};
        return array.reduce(function (map, element, index) {
            var key = getKeyFunc(element, index);
            var value = getValueFunc(element, index);
            map[key] = value;
            return map;
        }, {});
    };
    Data.Sum = function (array, getValueFunc) {
        if (!(array instanceof Array))
            return 0;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!IsNumber(value))
                value = 0;
            return prevValue + value;
        }, 0);
    };
    Data.Min = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, false); };
    Data.Max = function (array, getValueFunc) { return Data.CalculateArrayMinMax(array, getValueFunc, true); };
    Data.NearestLeftBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        var leftPoint = arrayElement < value;
        var lastLeftPoint = leftPoint && index === array.length - 1;
        var nearestLeftPoint = lastLeftPoint || (leftPoint && array[index + 1] >= value);
        if (nearestLeftPoint)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    Data.ArrayBinarySearch = function (array, value, binarySearchComparer, startIndex, length) {
        if (!binarySearchComparer)
            binarySearchComparer = Data.defaultBinarySearchComparer;
        if (!(0, common_1.isDefined)(startIndex))
            startIndex = 0;
        if (!(0, common_1.isDefined)(length))
            length = array.length - startIndex;
        var endIndex = (startIndex + length) - 1;
        while (startIndex <= endIndex) {
            var middle = (startIndex + ((endIndex - startIndex) >> 1));
            var compareResult = binarySearchComparer(array, middle, value);
            if (compareResult === 0)
                return middle;
            if (compareResult < 0)
                startIndex = middle + 1;
            else
                endIndex = middle - 1;
        }
        return -(startIndex + 1);
    };
    Data.ArrayFlatten = function (arrayOfArrays) {
        var result = [];
        arrayOfArrays.forEach(function (arr) {
            result = result.concat(arr);
        });
        return result;
    };
    Data.GetDistinctArray = function (array) {
        var resultArray = [];
        for (var i = 0; i < array.length; i++) {
            var currentEntry = array[i];
            if (Data.ArrayIndexOf(resultArray, currentEntry) === -1)
                resultArray.push(currentEntry);
        }
        return resultArray;
    };
    Data.ForEach = function (arr, callback) {
        if (Array.prototype.forEach)
            Array.prototype.forEach.call(arr, callback);
        else
            for (var i = 0, len = arr.length; i < len; i++)
                callback(arr[i], i, arr);
    };
    Data.MergeHashTables = function (target, object) {
        if (!object || typeof (object) === "string")
            return target;
        if (!target)
            target = {};
        for (var key in object)
            if (key && !(key in target))
                target[key] = object[key];
        return target;
    };
    Data.Range = function (count, start) {
        count = parseInt(count) || 0;
        start = parseInt(start) || 0;
        if (count < 0)
            count = 0;
        if (start < 0)
            start = 0;
        var result = Array(count);
        return result.map(function (_val, i) { return start + i; });
    };
    Data.CalculateArrayMinMax = function (array, getValueFunc, isMax) {
        if (!(array instanceof Array))
            return 0;
        var startValue = isMax ? Number.NEGATIVE_INFINITY : Number.POSITIVE_INFINITY;
        return array.reduce(function (prevValue, item) {
            var value = getValueFunc ? getValueFunc(item) : item;
            if (!IsNumber(value))
                value = startValue;
            var func = isMax ? Math.max : Math.min;
            return func(value, prevValue);
        }, startValue);
    };
    Data.byRange = function (value, min, max) {
        return Math.min(Math.max(value, min), max);
    };
    Data.defaultBinarySearchComparer = function (array, index, value) {
        var arrayElement = array[index];
        if (arrayElement === value)
            return 0;
        else
            return arrayElement < value ? -1 : 1;
    };
    Data.cssTextToObject = function (cssText) {
        if (!cssText)
            return {};
        cssText = cssText.replace(/\/\*(.|\s)*?\*\//g, "").replace(/\s+/g, " ");
        return cssText.split(";").reduce(function (acc, val) {
            if (val) {
                var matches = /\s*([^:]+?)\s*:\s*([^;]*)\s*$/.exec(val);
                if (matches) {
                    var name_1 = matches[1], value = matches[2];
                    name_1 && value && (acc[name_1.trim()] = value.trim());
                }
                return acc;
            }
            return acc;
        }, {});
    };
    Data.objectToCssText = function (obj) {
        if (!obj)
            return "";
        return Object.keys(obj).reduce(function (acc, key) {
            var name = key.trim();
            var value = obj[key];
            if (name && value)
                acc.push(name + ": " + value.toString().trim());
            return acc;
        }, []).join("; ");
    };
    return Data;
}());
exports.Data = Data;


/***/ }),

/***/ 2626:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.EdgeOnLayer = exports.NodeOnLayer = exports.SugiyamaNodesOrderer = exports.SugiyamaLayerDistributor = exports.SugiyamaLayoutBuilder = void 0;
var BaseBuilder_1 = __webpack_require__(8464);
var Graph_1 = __webpack_require__(9071);
var NodeLayout_1 = __webpack_require__(8501);
var Structures_1 = __webpack_require__(8573);
var ListUtils_1 = __webpack_require__(6961);
var search_1 = __webpack_require__(124);
var point_1 = __webpack_require__(5327);
var LayoutSettings_1 = __webpack_require__(9212);
var GraphLayout_1 = __webpack_require__(1441);
var Connector_1 = __webpack_require__(6320);
var CycleRemover_1 = __webpack_require__(1114);
var SugiyamaLayoutBuilder = (function (_super) {
    __extends(SugiyamaLayoutBuilder, _super);
    function SugiyamaLayoutBuilder() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SugiyamaLayoutBuilder.prototype.build = function () {
        var _this = this;
        var offset = 0;
        var layout = new GraphLayout_1.GraphLayout();
        var nodeOrderer = new SugiyamaNodesOrderer();
        this.graph.getConnectedComponents()
            .forEach(function (component) {
            var acyclicGraphInfo = CycleRemover_1.CycleRemover.removeCycles(component);
            var layers = SugiyamaLayerDistributor.getLayers(acyclicGraphInfo.graph);
            var orderedGraph = nodeOrderer.orderNodes(acyclicGraphInfo.graph, layers);
            var removedEdges = Object.keys(acyclicGraphInfo.removedEdges).map(function (ek) { return component.getEdge(ek); });
            var coordinatedGraph = nodeOrderer.assignAbsCoordinates(orderedGraph);
            var componentLayout = _this.createInfoGraphLayout(coordinatedGraph, acyclicGraphInfo.reversedEdges, removedEdges);
            layout.extend(_this.setComponentOffset(componentLayout, offset));
            offset += _this.getComponentOffset(componentLayout);
        });
        return layout;
    };
    SugiyamaLayoutBuilder.prototype.createInfoGraphLayout = function (coordinatedGraph, reversedEdges, removedEdges) {
        var _this = this;
        var currentPosition = new point_1.Point(0, 0);
        var items = coordinatedGraph.items;
        var sortedLayers = new ListUtils_1.HashSet(items.map(function (n) { return n.layer; }).sort(function (a, b) { return a - b; }));
        var absOffsetInfo = this.getAbsOffsetInfo(coordinatedGraph.items);
        var positions = {};
        var totalDepth = 0;
        var leftEdge = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var rightEdge = Number.MIN_SAFE_INTEGER || Number.MAX_VALUE;
        var _loop_1 = function (i) {
            var layer = sortedLayers.item(i);
            var maxDepthLayer = 0;
            items
                .filter(function (n) { return n.layer === layer; })
                .sort(function (a, b) { return a.position - b.position; })
                .forEach(function (n) {
                var depthNodeSize = _this.getDepthNodeSize(n);
                var directionOffset = _this.chooseDirectionValue(0, depthNodeSize);
                var absPosition = _this.getAbsPosition(n.position, _this.getBreadthNodeSize(n), absOffsetInfo);
                currentPosition = _this.setBreadth(currentPosition, absPosition);
                var nodePosition = _this.setDepthOffset(currentPosition, -directionOffset);
                positions[n.key] = nodePosition;
                if (n.isDummy)
                    return;
                var breadth = _this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal ? nodePosition.y : nodePosition.x;
                leftEdge = Math.min(leftEdge, breadth);
                rightEdge = Math.max(rightEdge, breadth + _this.getBreadthNodeSize(n));
                maxDepthLayer = Math.max(maxDepthLayer, _this.getDepthNodeSize(n));
            });
            totalDepth += maxDepthLayer;
            currentPosition = this_1.setBreadth(currentPosition, 0);
            currentPosition = this_1.setDepthOffset(currentPosition, this_1.getDirectionValue(maxDepthLayer + this_1.settings.layerSpacing));
        };
        var this_1 = this;
        for (var i = 0; i < sortedLayers.length; i++) {
            _loop_1(i);
        }
        totalDepth += (sortedLayers.length - 1) * this.settings.layerSpacing;
        var layout = new GraphLayout_1.GraphLayout();
        this.createNodesLayout(coordinatedGraph, layout, leftEdge, totalDepth, positions);
        this.createEdgesLayout(coordinatedGraph, layout, reversedEdges, removedEdges);
        return layout;
    };
    SugiyamaLayoutBuilder.prototype.createNodesLayout = function (infoGraph, layout, leftEdge, totalDepth, positions) {
        var _this = this;
        var offset = this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical ?
            new point_1.Point(-leftEdge, this.chooseDirectionValue(0, totalDepth)) :
            new point_1.Point(this.chooseDirectionValue(0, totalDepth), -leftEdge);
        infoGraph.items.forEach(function (n) {
            if (!n.isDummy) {
                var node = _this.graph.getNode(n.key);
                layout.addNode(new NodeLayout_1.NodeLayout(node, positions[n.key].clone().offset(offset.x, offset.y)));
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.createEdgesLayout = function (infoGraph, layout, reversedEdges, removedEdges) {
        var DIRECT = this.getDirectEdgeLayout();
        var TOP_TO_BOTTOM = this.getDiffLevelEdgeLayout(true);
        var BOTTOM_TO_TOP = this.getDiffLevelEdgeLayout(false);
        var TOP_TO_TOP = this.getSameLevelEdgeLayout(true);
        var BOTTOM_TO_BOTTOM = this.getSameLevelEdgeLayout(false);
        var occupied = {};
        infoGraph.edges
            .filter(function (e) { return !e.isDummy; })
            .concat(removedEdges.map(function (e) { return new EdgeOnLayer(e.key, false, e.from, e.to); }))
            .sort(function (a, b) {
            return (infoGraph.getNode(a.originFrom).layer - infoGraph.getNode(b.originFrom).layer) ||
                (infoGraph.getNode(a.to).layer - infoGraph.getNode(b.to).layer);
        })
            .forEach(function (e) {
            var isReversed = reversedEdges[e.key];
            var from = infoGraph.getNode(isReversed ? e.to : e.originFrom);
            var to = infoGraph.getNode(isReversed ? e.originFrom : e.to);
            if (to.layer - from.layer === 1)
                layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, DIRECT.from, DIRECT.to));
            else {
                var candidates_1 = [];
                if (to.position - from.position >= 1) {
                    candidates_1.push(TOP_TO_BOTTOM);
                    candidates_1.push({ from: DIRECT.from, to: TOP_TO_BOTTOM.to });
                    candidates_1.push({ from: TOP_TO_BOTTOM.from, to: DIRECT.to });
                }
                else if (to.position - from.position <= -1) {
                    candidates_1.push(BOTTOM_TO_TOP);
                    candidates_1.push({ from: DIRECT.from, to: BOTTOM_TO_TOP.to });
                    candidates_1.push({ from: BOTTOM_TO_TOP.from, to: DIRECT.to });
                }
                else {
                    var oneliner = from.position === to.position && to.position === 0 ? [TOP_TO_TOP, BOTTOM_TO_BOTTOM] : [BOTTOM_TO_BOTTOM, TOP_TO_TOP];
                    oneliner.forEach(function (c) { return candidates_1.push(c); });
                    oneliner.forEach(function (c) {
                        candidates_1.push({ from: c.from, to: DIRECT.to });
                        candidates_1.push({ from: DIRECT.from, to: c.to });
                    });
                }
                candidates_1.push(DIRECT);
                for (var i = 0, candidate = void 0; candidate = candidates_1[i]; i++) {
                    var fromKey = from.key + "_" + candidate.from;
                    var toKey = to.key + "_" + candidate.to;
                    if (occupied[fromKey] !== Connector_1.ConnectorPosition.End && occupied[toKey] !== Connector_1.ConnectorPosition.Begin) {
                        layout.addEdge(new NodeLayout_1.EdgeLayout(e.key, candidate.from, candidate.to));
                        occupied[fromKey] = Connector_1.ConnectorPosition.Begin;
                        occupied[toKey] = Connector_1.ConnectorPosition.End;
                        break;
                    }
                }
            }
        });
    };
    SugiyamaLayoutBuilder.prototype.getDirectEdgeLayout = function () {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 1, to: 3 } : { from: 3, to: 1 };
        return this.settings.direction === LayoutSettings_1.LogicalDirectionKind.Forward ? { from: 2, to: 0 } : { from: 0, to: 2 };
    };
    SugiyamaLayoutBuilder.prototype.getDiffLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 2, to: 0 } : { from: 0, to: 2 };
        return topToBottom ? { from: 3, to: 1 } : { from: 1, to: 3 };
    };
    SugiyamaLayoutBuilder.prototype.getSameLevelEdgeLayout = function (topToBottom) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return topToBottom ? { from: 0, to: 0 } : { from: 2, to: 2 };
        return topToBottom ? { from: 3, to: 3 } : { from: 1, to: 1 };
    };
    SugiyamaLayoutBuilder.prototype.getAbsOffsetInfo = function (nodesInfos) {
        var _this = this;
        var absOffsetMatrix = {};
        var addCell = function (n, intAbsCoord) {
            if (absOffsetMatrix[intAbsCoord] === undefined)
                absOffsetMatrix[intAbsCoord] = _this.getBreadthNodeSize(n);
            absOffsetMatrix[intAbsCoord] = Math.max(absOffsetMatrix[intAbsCoord], _this.getBreadthNodeSize(n));
        };
        nodesInfos.forEach(function (n) {
            var intAbsCoord = trunc(n.position);
            addCell(n, intAbsCoord);
            if (absOffsetMatrix[intAbsCoord] % 1 !== 0)
                addCell(n, intAbsCoord + 1);
        });
        var absOffsetInfo = {};
        var leftOffset = 0;
        Object.keys(absOffsetMatrix).sort(function (a, b) { return parseFloat(a) - parseFloat(b); }).forEach(function (coord) {
            absOffsetInfo[coord] = { leftOffset: leftOffset, width: absOffsetMatrix[coord] };
            leftOffset += absOffsetMatrix[coord] + _this.settings.columnSpacing;
        });
        return absOffsetInfo;
    };
    SugiyamaLayoutBuilder.prototype.setBreadth = function (position, breadthPosition) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Vertical)
            return new point_1.Point(breadthPosition, position.y);
        return new point_1.Point(position.x, breadthPosition);
    };
    SugiyamaLayoutBuilder.prototype.setDepthOffset = function (position, offset) {
        if (this.settings.orientation === LayoutSettings_1.DataLayoutOrientation.Horizontal)
            return new point_1.Point(position.x + offset, position.y);
        return new point_1.Point(position.x, position.y + offset);
    };
    SugiyamaLayoutBuilder.prototype.getAbsPosition = function (absCoordinate, itemSize, absoluteOffsetInfo) {
        var intAbsCoord = trunc(absCoordinate);
        var absLeftOffset = absoluteOffsetInfo[intAbsCoord].leftOffset;
        var cellWidth = absoluteOffsetInfo[intAbsCoord].width;
        if (absCoordinate % 1 === 0)
            return absLeftOffset + (cellWidth - itemSize) / 2;
        return absLeftOffset + cellWidth - (itemSize - this.settings.columnSpacing) / 2;
    };
    SugiyamaLayoutBuilder.prototype.getBreadthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getBreadthNodeSizeCore(this.graph.getNode(node.key));
    };
    SugiyamaLayoutBuilder.prototype.getDepthNodeSize = function (node) {
        return node.isDummy ? 0 : this.getDepthNodeSizeCore(this.graph.getNode(node.key));
    };
    return SugiyamaLayoutBuilder;
}(BaseBuilder_1.LayoutBuilder));
exports.SugiyamaLayoutBuilder = SugiyamaLayoutBuilder;
var SugiyamaLayerDistributor = (function () {
    function SugiyamaLayerDistributor() {
    }
    SugiyamaLayerDistributor.getLayers = function (acyclicGraph) {
        var feasibleTree = this.getFeasibleTree(acyclicGraph);
        return this.calcNodesLayers(feasibleTree);
    };
    SugiyamaLayerDistributor.getFeasibleTree = function (graph) {
        var layers = this.initLayerAssignment(graph);
        return graph.getSpanningGraph(graph.nodes[0], Structures_1.ConnectionMode.OutgoingAndIncoming, function (e) { return layers[e.to] - layers[e.from]; });
    };
    SugiyamaLayerDistributor.initLayerAssignment = function (graph) {
        var layers = {};
        var currentLayer = 0;
        var actualAssignedNodes = {};
        var assigningNodes = graph.nodes.filter(function (n) { return !graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).length; });
        var _loop_2 = function () {
            assigningNodes.forEach(function (n) {
                layers[n] = currentLayer;
                actualAssignedNodes[n] = true;
            });
            Object.keys(actualAssignedNodes).forEach(function (n) {
                if (graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing).filter(function (e) { return layers[e.to] === undefined; }).length === 0)
                    delete actualAssignedNodes[n];
            });
            var assigningNodesSet = {};
            Object.keys(actualAssignedNodes).forEach(function (n) {
                graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Outgoing)
                    .map(function (e) { return e.to; })
                    .filter(function (n) { return layers[n] === undefined && graph.getAdjacentEdges(n, Structures_1.ConnectionMode.Incoming).reduce(function (acc, e) { return acc && layers[e.from] !== undefined; }, true); })
                    .forEach(function (n) { return assigningNodesSet[n] = true; });
            });
            assigningNodes = Object.keys(assigningNodesSet);
            currentLayer++;
        };
        while (assigningNodes.length) {
            _loop_2();
        }
        return layers;
    };
    SugiyamaLayerDistributor.calcNodesLayers = function (graph) {
        var layers = {};
        var minLayer = Number.MAX_SAFE_INTEGER || Number.MAX_VALUE;
        var currentLevel = 0;
        var iterator = graph.createIterator(Structures_1.ConnectionMode.OutgoingAndIncoming);
        iterator.visitEachEdgeOnce = false;
        iterator.onNode = function (n) {
            layers[n.key] = currentLevel;
            minLayer = Math.min(minLayer, currentLevel);
        };
        iterator.skipNode = function (n) { return layers[n.key] !== undefined; };
        iterator.skipEdge = function (e) { return layers[e.from] !== undefined && layers[e.to] !== undefined; };
        iterator.onEdge = function (e, out) {
            if (out)
                currentLevel = layers[e.from] + 1;
            else
                currentLevel = layers[e.to] - 1;
        };
        iterator.iterate(graph.nodes[0]);
        for (var key in layers) {
            if (!Object.prototype.hasOwnProperty.call(layers, key))
                continue;
            layers[key] -= minLayer;
        }
        return layers;
    };
    return SugiyamaLayerDistributor;
}());
exports.SugiyamaLayerDistributor = SugiyamaLayerDistributor;
var SugiyamaNodesOrderer = (function () {
    function SugiyamaNodesOrderer() {
        this.idCounter = -10000;
    }
    SugiyamaNodesOrderer.prototype.orderNodes = function (graph, layers) {
        var maxIteration = 14;
        var currentIteration = 1;
        var graphInfo = this.initGraphInfo(graph, layers);
        var nodeInfos = graphInfo.items;
        var orderInfo = this.initOrder(nodeInfos);
        var bestNodesPositions = this.getNodeToPositionMap(nodeInfos);
        var bestCrossCount = this.getCrossCount(orderInfo, graphInfo);
        var isParentToChildren = true;
        while (currentIteration < maxIteration && bestCrossCount !== 0) {
            orderInfo = this.getNodesOrder(orderInfo, graphInfo, isParentToChildren);
            var crossCount = this.getCrossCount(orderInfo, graphInfo);
            if (crossCount < bestCrossCount) {
                bestNodesPositions = this.getNodeToPositionMap(graphInfo.items);
                bestCrossCount = crossCount;
            }
            isParentToChildren = !isParentToChildren;
            currentIteration++;
        }
        graphInfo.items.forEach(function (n) { return n.position = bestNodesPositions[n.key]; });
        return graphInfo;
    };
    SugiyamaNodesOrderer.prototype.getNodesOrder = function (current, graph, isParentToChildren) {
        var _this = this;
        var order = {};
        var _loop_3 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(current, layer))
                return "continue";
            var nodePositions = {};
            var nodeKeys = [];
            current[layer].forEach(function (ni) {
                var adjacentNodesPositions = (isParentToChildren ? graph.getChildren(ni.key) : graph.getParents(ni.key))
                    .map(function (nk) { return graph.getNode(nk).position; });
                nodeKeys.push(ni.key);
                nodePositions[ni.key] = _this.getNodePosition(adjacentNodesPositions);
            });
            order[layer] = this_2.sortNodes(nodeKeys, nodePositions, graph);
        };
        var this_2 = this;
        for (var layer in current) {
            _loop_3(layer);
        }
        return order;
    };
    SugiyamaNodesOrderer.prototype.sortNodes = function (nodeKeys, nodePositions, graph) {
        return nodeKeys
            .sort(function (a, b) { return nodePositions[a] - nodePositions[b]; })
            .map(function (nk, index) {
            var node = graph.getNode(nk);
            node.position = index;
            return node;
        });
    };
    SugiyamaNodesOrderer.prototype.getNodePosition = function (adjacentNodesPositions) {
        adjacentNodesPositions = adjacentNodesPositions.sort(function (a, b) { return a - b; });
        if (!adjacentNodesPositions.length)
            return 0;
        var medianIndex = Math.floor(adjacentNodesPositions.length / 2);
        if (adjacentNodesPositions.length === 2 || adjacentNodesPositions.length % 2 === 1)
            return adjacentNodesPositions[medianIndex];
        var leftMedianPosition = adjacentNodesPositions[medianIndex - 1] - adjacentNodesPositions[0];
        var rightMedianPosition = adjacentNodesPositions[adjacentNodesPositions.length - 1] - adjacentNodesPositions[medianIndex];
        return Math.floor((adjacentNodesPositions[medianIndex - 1] * rightMedianPosition + adjacentNodesPositions[medianIndex] * leftMedianPosition) /
            (leftMedianPosition + rightMedianPosition));
    };
    SugiyamaNodesOrderer.prototype.initOrder = function (nodeInfos) {
        var result = {};
        nodeInfos.forEach(function (ni) { return (result[ni.layer] || (result[ni.layer] = [])).push(ni); });
        return result;
    };
    SugiyamaNodesOrderer.prototype.getCrossCount = function (orderInfo, graph) {
        var count = 0;
        var _loop_4 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(orderInfo, layer))
                return "continue";
            var viewedAdjacentNodesPositions = [];
            orderInfo[layer].forEach(function (n) {
                var positions = graph.getChildren(n.key).map(function (c) { return graph.getNode(c).position; });
                positions.forEach(function (p) {
                    count += viewedAdjacentNodesPositions.filter(function (vp) { return p < vp; }).length;
                });
                viewedAdjacentNodesPositions = viewedAdjacentNodesPositions.concat(positions);
            });
        };
        for (var layer in orderInfo) {
            _loop_4(layer);
        }
        return count;
    };
    SugiyamaNodesOrderer.prototype.initGraphInfo = function (graph, layers) {
        var _this = this;
        var countNodesOnLayer = {};
        var nodesInfoMap = {};
        var nodeInfos = [];
        var edgeInfos = [];
        graph.nodes.forEach(function (n) {
            var layer = layers[n];
            if (countNodesOnLayer[layer] === undefined)
                countNodesOnLayer[layer] = 0;
            var info = new NodeOnLayer(n, false, layer, countNodesOnLayer[layer]++);
            nodesInfoMap[n] = info;
            nodeInfos.push(info);
        });
        graph.edges.forEach(function (e) {
            var span = layers[e.to] - layers[e.from];
            if (span > 1) {
                var prevNodeInfo = nodesInfoMap[e.from];
                for (var delta = 1; delta < span; delta++) {
                    var dNodeInfo = new NodeOnLayer(_this.createDummyID(), true, layers[e.from] + delta, countNodesOnLayer[layers[e.from] + delta]++);
                    edgeInfos.push(new EdgeOnLayer(_this.createDummyID(), true, prevNodeInfo.key, dNodeInfo.key));
                    nodeInfos.push(dNodeInfo);
                    prevNodeInfo = dNodeInfo;
                }
                edgeInfos.push(new EdgeOnLayer(e.key, false, prevNodeInfo.key, nodesInfoMap[e.to].key, nodesInfoMap[e.from].key));
            }
            else
                edgeInfos.push(new EdgeOnLayer(e.key, false, nodesInfoMap[e.from].key, nodesInfoMap[e.to].key));
        });
        return new Graph_1.FastGraph(nodeInfos, edgeInfos);
    };
    SugiyamaNodesOrderer.prototype.createDummyID = function () {
        return "dummy_" + --this.idCounter;
    };
    SugiyamaNodesOrderer.prototype.getNodeToPositionMap = function (nodeInfos) {
        return nodeInfos.reduce(function (acc, ni) {
            acc[ni.key] = ni.position;
            return acc;
        }, {});
    };
    SugiyamaNodesOrderer.prototype.assignAbsCoordinates = function (graph) {
        var absCoordinates = this.getAbsCoodinate(graph);
        return new Graph_1.FastGraph(graph.items.map(function (n) { return new NodeOnLayer(n.key, n.isDummy, n.layer, absCoordinates[n.key]); }), graph.edges.slice(0));
    };
    SugiyamaNodesOrderer.prototype.getAbsCoodinate = function (graph) {
        var _this = this;
        var orderInfo = graph.items.reduce(function (acc, n) {
            acc[n.layer] = acc[n.layer] || [];
            var pos = search_1.SearchUtils.binaryIndexOf(acc[n.layer], function (ni) { return ni.position - n.position; });
            acc[n.layer].splice(pos < 0 ? ~pos : pos, 0, n);
            return acc;
        }, {});
        var medianPositions = [MedianAlignmentMode.TopLeft, MedianAlignmentMode.TopRight, MedianAlignmentMode.BottomLeft, MedianAlignmentMode.BottomRight]
            .map(function (alignment) { return _this.getPositionByMedian(graph, alignment, orderInfo); });
        var nodeToPosition = {};
        graph.items.forEach(function (n) {
            var posList = medianPositions.map(function (positions) { return positions[n.key]; }).sort(function (a, b) { return a - b; });
            nodeToPosition[n.key] = (posList[1] + posList[2]) / 2;
        });
        return nodeToPosition;
    };
    SugiyamaNodesOrderer.prototype.getPositionByMedian = function (graph, alignment, orderInfo) {
        var nodeInfos = graph.items;
        var positions = this.getNodeToPositionMap(nodeInfos);
        var medians = this.getMedians(graph, nodeInfos, alignment);
        medians = this.resolveMedianConflicts(graph, orderInfo, medians, alignment);
        this.getSortedBlocks(graph, nodeInfos, medians, alignment)
            .forEach(function (block) {
            var maxPos = block.reduce(function (acc, n) { return positions[n.key] > acc ? positions[n.key] : acc; }, -2);
            block.forEach(function (n) {
                var delta = maxPos - positions[n.key];
                if (delta > 0)
                    orderInfo[n.layer]
                        .filter(function (ln) { return ln.position > n.position; })
                        .forEach(function (ln) { return positions[ln.key] += delta; });
                positions[n.key] = maxPos;
            });
        });
        return positions;
    };
    SugiyamaNodesOrderer.prototype.getSortedBlocks = function (graph, nodeInfos, medians, alignment) {
        var blocks = [];
        var isBottom = alignment === MedianAlignmentMode.BottomLeft || alignment === MedianAlignmentMode.BottomRight;
        var allNodesInfo = new ListUtils_1.HashSet(nodeInfos.slice(0).sort(function (a, b) { return isBottom ? (a.layer - b.layer) : (b.layer - a.layer); }), function (n) { return n.key; });
        var knownNodes = new ListUtils_1.HashSet();
        while (allNodesInfo.length) {
            var firstNode = allNodesInfo.item(0);
            var block = this.getBlock(graph, firstNode, medians, alignment).filter(function (n) { return knownNodes.tryPush(n.key); });
            blocks.push(block);
            block.forEach(function (n) { return allNodesInfo.remove(n); });
        }
        blocks.sort(function (x, y) {
            var xMinNodeInfo = x.reduce(function (min, n) { return n.position < min.position ? n : min; }, x[0]);
            var yOnMinXLayer = y.filter(function (n) { return n.layer === xMinNodeInfo.layer; })[0];
            if (yOnMinXLayer)
                return xMinNodeInfo.position > yOnMinXLayer.position ? 1 : -1;
            var yMinNodeInfo = y.reduce(function (min, n) { return n.position < min.position ? n : min; }, y[0]);
            var xOnMinYLayer = x.filter(function (n) { return n.layer === yMinNodeInfo.layer; })[0];
            if (xOnMinYLayer)
                return xOnMinYLayer.position > yMinNodeInfo.position ? 1 : -1;
            return xMinNodeInfo.layer > yMinNodeInfo.layer ? 1 : -1;
        });
        return blocks;
    };
    SugiyamaNodesOrderer.prototype.getBlock = function (graph, root, medians, alignment) {
        var block = [];
        var median = null;
        do {
            if (median)
                root = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? graph.getNode(median.from) : graph.getNode(median.to);
            block.push(root);
            median = medians[root.key];
        } while (median);
        return block;
    };
    SugiyamaNodesOrderer.prototype.resolveMedianConflicts = function (graph, layers, medians, alignment) {
        var _this = this;
        var filteredMedians = {};
        var _loop_5 = function (layer) {
            if (!Object.prototype.hasOwnProperty.call(layers, layer))
                return "continue";
            var minPos;
            var maxPos;
            var nodeInfos = layers[layer];
            if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
                nodeInfos = nodeInfos.slice(0).sort(function (a, b) { return b.position - a.position; });
            nodeInfos.forEach(function (n) {
                var median = medians[n.key];
                if (!median)
                    filteredMedians[n.key] = null;
                else {
                    var medianItemKey = alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight ? median.from : median.to;
                    var medianPosition = graph.getNode(medianItemKey).position;
                    if (_this.checkMedianConfict(minPos, maxPos, medianPosition, alignment))
                        filteredMedians[n.key] = null;
                    else {
                        minPos = minPos === undefined ? medianPosition : Math.min(minPos, medianPosition);
                        maxPos = maxPos === undefined ? medianPosition : Math.max(maxPos, medianPosition);
                        filteredMedians[n.key] = median;
                    }
                }
            });
        };
        for (var layer in layers) {
            _loop_5(layer);
        }
        return filteredMedians;
    };
    SugiyamaNodesOrderer.prototype.checkMedianConfict = function (min, max, medianPosition, alignment) {
        if (min === undefined || max === undefined)
            return false;
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return max >= medianPosition;
        return min <= medianPosition;
    };
    SugiyamaNodesOrderer.prototype.getMedians = function (graph, nodeInfos, alignment) {
        var _this = this;
        var medians = {};
        nodeInfos.forEach(function (n) {
            var actualAdjacentEdges = _this.getActualAdjacentEdges(graph, n, alignment);
            var medianPosition = _this.getMedianPosition(actualAdjacentEdges.length, alignment);
            medians[n.key] = actualAdjacentEdges[medianPosition];
        });
        return medians;
    };
    SugiyamaNodesOrderer.prototype.getMedianPosition = function (length, alignment) {
        if (length === 0)
            return -1;
        if (length % 2 !== 0)
            return Math.floor(length / 2);
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.BottomLeft)
            return Math.floor(length / 2) - 1;
        if (alignment === MedianAlignmentMode.TopRight || alignment === MedianAlignmentMode.BottomRight)
            return Math.floor(length / 2);
        throw new Error("Invalid Operation");
    };
    SugiyamaNodesOrderer.prototype.getActualAdjacentEdges = function (graph, node, alignment) {
        if (alignment === MedianAlignmentMode.TopLeft || alignment === MedianAlignmentMode.TopRight)
            return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Incoming).sort(function (a, b) { return graph.getNode(a.from).position - graph.getNode(b.from).position; });
        return graph.getAdjacentEdges(node.key, Structures_1.ConnectionMode.Outgoing).sort(function (a, b) { return graph.getNode(a.to).position - graph.getNode(b.to).position; });
    };
    return SugiyamaNodesOrderer;
}());
exports.SugiyamaNodesOrderer = SugiyamaNodesOrderer;
var NodeOnLayer = (function () {
    function NodeOnLayer(key, isDummy, layer, position) {
        this.key = key;
        this.isDummy = isDummy;
        this.layer = layer;
        this.position = position;
    }
    NodeOnLayer.prototype.getHashCode = function () {
        return this.key.toString();
    };
    return NodeOnLayer;
}());
exports.NodeOnLayer = NodeOnLayer;
var EdgeOnLayer = (function () {
    function EdgeOnLayer(key, isDummy, from, to, originFrom) {
        this.key = key;
        this.isDummy = isDummy;
        this.from = from;
        this.to = to;
        this._originFrom = originFrom;
    }
    EdgeOnLayer.prototype.getHashCode = function () {
        return this.from + "-" + this.to;
    };
    Object.defineProperty(EdgeOnLayer.prototype, "originFrom", {
        get: function () {
            return this._originFrom !== undefined ? this._originFrom : this.from;
        },
        enumerable: false,
        configurable: true
    });
    return EdgeOnLayer;
}());
exports.EdgeOnLayer = EdgeOnLayer;
var MedianAlignmentMode;
(function (MedianAlignmentMode) {
    MedianAlignmentMode[MedianAlignmentMode["TopLeft"] = 0] = "TopLeft";
    MedianAlignmentMode[MedianAlignmentMode["TopRight"] = 1] = "TopRight";
    MedianAlignmentMode[MedianAlignmentMode["BottomLeft"] = 2] = "BottomLeft";
    MedianAlignmentMode[MedianAlignmentMode["BottomRight"] = 3] = "BottomRight";
})(MedianAlignmentMode || (MedianAlignmentMode = {}));
function trunc(val) {
    if (Math.trunc)
        return Math.trunc(val);
    if (!isFinite(val))
        return val;
    return (val - val % 1) || (val < 0 ? -0 : val === 0 ? val : 0);
}


/***/ }),

/***/ 2638:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFontItalicCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(3210);
var ToggleFontItalicCommand = (function (_super) {
    __extends(ToggleFontItalicCommand, _super);
    function ToggleFontItalicCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFontItalicCommand.prototype.getStyleProperty = function () {
        return "font-style";
    };
    ToggleFontItalicCommand.prototype.getStylePropertyValue = function () {
        return "italic";
    };
    return ToggleFontItalicCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ToggleFontItalicCommand = ToggleFontItalicCommand;


/***/ }),

/***/ 2651:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextToolbox = void 0;
var Toolbox_1 = __webpack_require__(5037);
var TextToolbox = (function (_super) {
    __extends(TextToolbox, _super);
    function TextToolbox(parent, readOnly, allowDragging, shapeDescriptionManager, shapeTypes, getAllowedShapeTypes) {
        return _super.call(this, parent, readOnly, allowDragging, shapeDescriptionManager, shapeTypes, getAllowedShapeTypes) || this;
    }
    TextToolbox.prototype.createElements = function (element, shapeTypes) {
        var _this = this;
        shapeTypes.forEach(function (shapeType) {
            var description = _this.shapeDescriptionManager.get(shapeType);
            var itemEl = document.createElement("div");
            itemEl.setAttribute("class", "toolbox-text-item");
            itemEl.setAttribute("data-tb-type", shapeType);
            itemEl.textContent = description.getDefaultText() || description.getTitle();
            element.appendChild(itemEl);
        });
    };
    TextToolbox.prototype.createDraggingElement = function (draggingObject) {
        var element = document.createElement("DIV");
        element.setAttribute("class", "dxdi-toolbox-drag-text-item");
        var shapeDescription = this.shapeDescriptionManager.get(draggingObject.evt.data);
        element.textContent = shapeDescription.getDefaultText() || shapeDescription.getTitle();
        document.body.appendChild(element);
        return element;
    };
    return TextToolbox;
}(Toolbox_1.Toolbox));
exports.TextToolbox = TextToolbox;


/***/ }),

/***/ 2703:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ModelManipulator = void 0;
var offsets_1 = __webpack_require__(8601);
var size_1 = __webpack_require__(3844);
var Diagnostics_1 = __webpack_require__(9196);
var ImageCache_1 = __webpack_require__(4062);
var ImageLoader_1 = __webpack_require__(7841);
var ModelOperationSettings_1 = __webpack_require__(5225);
var Utils_1 = __webpack_require__(41);
var Connector_1 = __webpack_require__(6320);
var ModelChange_1 = __webpack_require__(3427);
var ModelUtils_1 = __webpack_require__(1922);
var ModelManipulator = (function () {
    function ModelManipulator(model, routingModel, permissionsProvider, descriptionManager) {
        this.onModelChanged = new Utils_1.EventDispatcher();
        this.onModelSizeChanged = new Utils_1.EventDispatcher();
        this.initializeCore(model, routingModel);
        this.permissionsProvider = permissionsProvider;
        this.descriptionManager = descriptionManager;
        this.imageLoader = new ImageLoader_1.ImageLoader(this.updateShapeImage.bind(this));
    }
    ModelManipulator.prototype.initialize = function (model, routingModel) {
        this.initializeCore(model, routingModel);
        this.model.loadAllImages(this.imageLoader);
        this.updateModelSize();
    };
    ModelManipulator.prototype.initializeCore = function (model, routingModel) {
        var _this = this;
        this.model = model;
        this.routingModel = routingModel;
        if (this.routingModel) {
            this.routingModel.initialize(model);
            model.iterateItems(function (item) {
                if (item instanceof Connector_1.Connector) {
                    var routingStrategy = _this.routingModel.createStrategy(item.properties.lineOption);
                    if (routingStrategy)
                        item.changeRoutingStrategy(routingStrategy);
                    else
                        item.invalidateRenderPoints();
                }
            });
        }
    };
    ModelManipulator.prototype.commitPageChanges = function () {
        this.raisePageSizeChanged(this.model.pageSize.clone(), this.model.pageLandscape);
        this.raiseModelSizeChanged(this.model.size.clone());
        this.raisePageColorChanged(this.model.pageColor);
        this.raiseModelRectangleChanged(ModelUtils_1.ModelUtils.createRectangle(this.model.items));
    };
    ModelManipulator.prototype.commitItemsCreateChanges = function () {
        Diagnostics_1.Diagnostics.timer("new model: model changes");
        this.commitItemsChangesCore(ModelChange_1.ItemChangeType.Create, this.model.items);
        Diagnostics_1.Diagnostics.endTimer();
    };
    ModelManipulator.prototype.commitItemUpdateChanges = function (item) {
        this.commitItemsChangesCore(ModelChange_1.ItemChangeType.UpdateStructure, [item]);
    };
    ModelManipulator.prototype.commitItemsChangesCore = function (changeType, items) {
        var changes = [];
        items.forEach(function (item) {
            changes.push(new ModelChange_1.ItemChange(item, changeType));
        });
        if (changes.length)
            this.raiseModelChanged(changes);
    };
    ModelManipulator.prototype.insertToContainer = function (item, container) {
        if (item.container && container && item.container.key !== container.key)
            throw Error("To insert an item to a container it's necessary to remove it from the current container.");
        if (container) {
            if (container.children.indexOf(item) === -1)
                container.children.push(item);
            item.container = container;
            this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.Update)]);
        }
    };
    ModelManipulator.prototype.removeFromContainer = function (item) {
        if (item.container) {
            var index = item.container.children.indexOf(item);
            item.container.children.splice(index, 1);
            item.container = undefined;
            this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.Update)]);
        }
    };
    ModelManipulator.prototype.changeStyle = function (item, styleProperty, styleValue) {
        this.changeStyleCore(item, item.style, styleProperty, styleValue);
    };
    ModelManipulator.prototype.changeStyleText = function (item, styleProperty, styleValue) {
        this.changeStyleCore(item, item.styleText, styleProperty, styleValue);
    };
    ModelManipulator.prototype.changeStyleCore = function (item, styleObj, styleProperty, styleValue) {
        if (styleValue !== undefined)
            styleObj[styleProperty] = styleValue;
        else
            delete styleObj[styleProperty];
        this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.UpdateProperties)]);
    };
    ModelManipulator.prototype.changeZIndex = function (item, zIndex) {
        item.zIndex = zIndex;
        this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.Update)]);
    };
    ModelManipulator.prototype.changeLocked = function (item, locked) {
        item.locked = locked;
        this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.UpdateClassName)]);
    };
    ModelManipulator.prototype.changeCustomData = function (item, data) {
        item.customData = Utils_1.ObjectUtils.cloneObject(data);
        this.raiseModelChanged([new ModelChange_1.ItemChange(item, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.addShape = function (shape, key) {
        if (shape.attachedConnectors.length)
            throw Error("A creating shape should not contain existing connectors.");
        shape.key = key !== undefined ? key : this.model.getNextKey();
        return this.insertShape(shape);
    };
    ModelManipulator.prototype.insertShape = function (shape) {
        this.model.pushItem(shape);
        var allowed = this.permissionsProvider.canAddItems([shape]);
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.Create, allowed)]);
        this.model.loadAllImages(this.imageLoader);
        return shape;
    };
    ModelManipulator.prototype.resizeShape = function (shape, position, size) {
        shape.position = position;
        shape.size = size;
        var allowed = this.permissionsProvider.isStoredPermissionsGranted();
        var resizeInteractingItem = this.getInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.ResizeShape);
        if (resizeInteractingItem) {
            var oldSize = resizeInteractingItem.size.clone();
            var size_2 = shape.size.clone();
            if (!size_2.equals(oldSize))
                allowed = this.permissionsProvider.canResizeShapes([{ shape: shape, size: size_2, oldSize: oldSize }]);
        }
        var moveInteractingItem = this.getInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.MoveShape);
        if (moveInteractingItem) {
            var oldPosition = moveInteractingItem.position.clone();
            var position_1 = shape.position.clone();
            if (!position_1.equals(oldPosition))
                allowed = this.permissionsProvider.canMoveShapes([{ shape: shape, position: position_1, oldPosition: oldPosition }]);
        }
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.moveShape = function (shape, position) {
        shape.position = position;
        var allowed = this.permissionsProvider.isStoredPermissionsGranted();
        var addInteractingItem = this.getInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.AddShape);
        if (addInteractingItem)
            allowed = this.permissionsProvider.canAddItems([shape]);
        var moveInteractingItem = this.getInteractingItem(shape, ModelOperationSettings_1.DiagramModelOperation.MoveShape);
        if (moveInteractingItem) {
            var oldPosition = moveInteractingItem.position.clone();
            var position_2 = shape.position.clone();
            if (!position_2.equals(oldPosition))
                allowed = this.permissionsProvider.canMoveShapes([{ shape: shape, position: position_2, oldPosition: oldPosition }]);
        }
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.changeShapeParameters = function (shape, parameters) {
        shape.parameters.forEach(function (p) {
            var parameter = parameters.get(p.key);
            if (parameter)
                p.value = parameter.value;
        });
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateProperties)]);
    };
    ModelManipulator.prototype.changeShapeText = function (shape, text) {
        shape.text = text;
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.changeShapeImage = function (shape, image) {
        shape.image = image;
        var cachedImage = ImageCache_1.ImageCache.instance.createUnloadedInfoByShapeImageInfo(image);
        this.imageLoader.load(cachedImage);
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.changeShapeExpanded = function (shape, expanded) {
        shape.expanded = expanded;
        shape.toggleExpandedSize();
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.deleteShape = function (shape, allowed) {
        if (shape.attachedConnectors.length)
            throw Error("A removing shape should not contain existing connectors.");
        this.removeShape(shape, allowed);
    };
    ModelManipulator.prototype.removeShape = function (shape, allowed) {
        this.model.removeItem(shape);
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.Remove, allowed)]);
    };
    ModelManipulator.prototype.updateShapeImage = function (cacheImageInfo) {
        if (!cacheImageInfo.imageUrl)
            return;
        var shapes = this.model.findShapesByImageUrl(cacheImageInfo.imageUrl);
        shapes.forEach(function (shape) {
            if (cacheImageInfo.base64)
                shape.image.loadBase64Content(cacheImageInfo.base64);
            else
                shape.image.setUnableToLoadFlag();
        });
        this.commitItemsChangesCore(ModelChange_1.ItemChangeType.UpdateStructure, shapes);
    };
    ModelManipulator.prototype.updateShapeDescription = function (description) {
        var shapes = this.model.findShapesByDescription(description);
        this.commitItemsChangesCore(ModelChange_1.ItemChangeType.UpdateProperties, shapes);
    };
    ModelManipulator.prototype.updateShapeType = function (shape, typeKey, shapeParameters) {
        var description = this.descriptionManager.get(typeKey);
        shape.description = description;
        shape.parameters = shapeParameters;
        description.createParameters(shapeParameters);
        this.raiseModelChanged([new ModelChange_1.ItemChange(shape, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.addConnector = function (connector, key) {
        if (connector.beginItem || connector.endItem)
            throw Error("Creating connector should not contain begin/end items");
        connector.key = key !== undefined ? key : this.model.getNextKey();
        return this.insertConnector(connector);
    };
    ModelManipulator.prototype.insertConnector = function (connector) {
        this.model.pushItem(connector);
        var routingStrategy = this.routingModel.createStrategy(connector.properties.lineOption);
        if (routingStrategy)
            connector.changeRoutingStrategy(routingStrategy);
        else
            connector.clearRoutingStrategy();
        var allowed = this.permissionsProvider.canAddItems([connector]);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.Create, allowed)]);
        return connector;
    };
    ModelManipulator.prototype.deleteConnector = function (connector) {
        if (connector.beginItem || connector.endItem)
            throw Error("Creating connector should not contain begin/end items");
        this.removeConnector(connector);
    };
    ModelManipulator.prototype.removeConnector = function (connector) {
        this.model.removeItem(connector);
        var allowed = this.permissionsProvider.canDeleteItems([connector]);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.Remove, allowed)]);
    };
    ModelManipulator.prototype.addDeleteConnectorPoint = function (connector, callBack) {
        var oldConnectorPoints = this.getConnectorInteractingPoints(connector);
        callBack(connector);
        this.addDeleteConnectorPointCore(connector, oldConnectorPoints);
    };
    ModelManipulator.prototype.moveConnectorPoint = function (connector, pointIndex, callBack) {
        callBack(connector);
        this.moveConnectorPointCore(connector, pointIndex);
    };
    ModelManipulator.prototype.changeConnectorPoints = function (connector, callBack) {
        var _this = this;
        callBack(connector);
        connector.points.forEach(function (_, i) { return _this.moveConnectorPointCore(connector, i); });
    };
    ModelManipulator.prototype.moveConnectorPointCore = function (connector, pointIndex) {
        var interactingItem = this.getInteractingItem(connector);
        var allowed = this.permissionsProvider.isStoredPermissionsGranted();
        if (interactingItem) {
            var changeConnectionPoints = (0 < pointIndex && pointIndex < connector.points.length - 1);
            changeConnectionPoints = changeConnectionPoints || (pointIndex === 0 && !connector.beginItem);
            changeConnectionPoints = changeConnectionPoints || (pointIndex === connector.points.length - 1 && !connector.endItem);
            if (changeConnectionPoints) {
                var oldConnectorPoints = interactingItem.points.map(function (p) { return p.clone(); });
                var newConnectorPoints = connector.points.map(function (p) { return p.clone(); });
                if (!Utils_1.GeometryUtils.arePointsEqual(oldConnectorPoints, newConnectorPoints))
                    allowed = this.permissionsProvider.canChangeConnectorPoints(connector, oldConnectorPoints, newConnectorPoints);
            }
        }
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.getConnectorInteractingPoints = function (connector) {
        var interactingItem = this.getInteractingItem(connector);
        return interactingItem ? interactingItem.points.map(function (p) { return p.clone(); }) : connector.points.map(function (p) { return p.clone(); });
    };
    ModelManipulator.prototype.addDeleteConnectorPointCore = function (connector, oldConnectorPoints) {
        var allowed = this.permissionsProvider.isStoredPermissionsGranted();
        var newConnectorPoints = connector.points.map(function (p) { return p.clone(); });
        if (!Utils_1.GeometryUtils.arePointsEqual(oldConnectorPoints, newConnectorPoints))
            allowed = this.permissionsProvider.canChangeConnectorPoints(connector, oldConnectorPoints, newConnectorPoints);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.addConnection = function (connector, item, connectionPointIndex, position) {
        var existingItem = connector.getExtremeItem(position);
        var existingConnectionPointIndex = connector.getExtremeConnectionPointIndex(position);
        if (existingItem === item && existingConnectionPointIndex === connectionPointIndex)
            return;
        else if (existingItem)
            throw Error("Connector is already connected");
        item.attachedConnectors.push(connector);
        if (position === Connector_1.ConnectorPosition.Begin) {
            connector.beginItem = item;
            connector.beginConnectionPointIndex = connectionPointIndex;
        }
        else {
            connector.endItem = item;
            connector.endConnectionPointIndex = connectionPointIndex;
        }
        connector.invalidateRenderPoints();
        var allowed = this.permissionsProvider.canChangeConnection(connector, item, undefined, position, connectionPointIndex);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.setConnectionPointIndex = function (connector, connectionPointIndex, position) {
        if (!connector.getExtremeItem(position))
            throw Error("Connection should be connected");
        if (position === Connector_1.ConnectorPosition.Begin)
            connector.beginConnectionPointIndex = connectionPointIndex;
        else
            connector.endConnectionPointIndex = connectionPointIndex;
        connector.invalidateRenderPoints();
        var item = connector.getExtremeItem(position);
        var allowed = this.permissionsProvider.canChangeConnection(connector, item, item, position, connectionPointIndex);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.deleteConnection = function (connector, position) {
        var item = connector.getExtremeItem(position);
        if (!item)
            return;
        item.attachedConnectors.splice(item.attachedConnectors.indexOf(connector), 1);
        if (position === Connector_1.ConnectorPosition.Begin) {
            connector.beginItem = null;
            connector.beginConnectionPointIndex = -1;
        }
        else {
            connector.endItem = null;
            connector.endConnectionPointIndex = -1;
        }
        connector.invalidateRenderPoints();
        var allowed = this.permissionsProvider.canChangeConnection(connector, undefined, item, position, -1);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties, allowed)]);
    };
    ModelManipulator.prototype.changeConnectorProperty = function (connector, propertyName, value) {
        connector.properties[propertyName] = value;
        if (propertyName === "lineOption") {
            var routingStrategy = this.routingModel ? this.routingModel.createStrategy(connector.properties.lineOption) : undefined;
            if (routingStrategy)
                connector.changeRoutingStrategy(routingStrategy);
            else
                connector.clearRoutingStrategy();
        }
        else
            connector.invalidateRenderPoints();
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties)]);
    };
    ModelManipulator.prototype.changeConnectorText = function (connector, text, position) {
        connector.setText(text, position);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateStructure)]);
    };
    ModelManipulator.prototype.changeConnectorTextPosition = function (connector, position, newPosition) {
        var text = connector.getText(position);
        connector.setText(null, position);
        connector.setText(text, newPosition);
        this.raiseModelChanged([new ModelChange_1.ItemChange(connector, ModelChange_1.ItemChangeType.UpdateProperties)]);
    };
    ModelManipulator.prototype.changeModelSize = function (size, offset) {
        this.model.size.width = size.width;
        this.model.size.height = size.height;
        this.raiseModelSizeChanged(this.model.size.clone(), offset);
        if (offset.left || offset.top) {
            this.model.snapStartPoint = this.model.snapStartPoint.clone().offset(offset.left, offset.top);
            this.raiseSnapPointChange(this.model.snapStartPoint);
        }
    };
    ModelManipulator.prototype.changePageSize = function (value) {
        if (!this.model.pageSize.equals(value)) {
            this.model.pageSize = value;
            this.model.size = new size_1.Size(this.model.pageWidth, this.model.pageHeight);
            this.raiseModelSizeChanged(this.model.size.clone());
            this.raisePageSizeChanged(this.model.pageSize, this.model.pageLandscape);
        }
    };
    ModelManipulator.prototype.changePageLandscape = function (value) {
        if (this.model.pageLandscape !== value) {
            this.model.pageLandscape = value;
            if (this.model.pageSize.width !== this.model.pageSize.height) {
                this.model.size = new size_1.Size(this.model.pageWidth, this.model.pageHeight);
                this.raiseModelSizeChanged(this.model.size.clone());
                this.raisePageSizeChanged(this.model.pageSize, this.model.pageLandscape);
            }
        }
    };
    ModelManipulator.prototype.changePageColor = function (value) {
        if (this.model.pageColor !== value) {
            this.model.pageColor = value;
            this.raisePageColorChanged(value);
        }
    };
    ModelManipulator.prototype.updateModelSize = function () {
        var offset = this.getModelSizeUpdateOffset();
        if (!offset.isEmpty()) {
            var newWidth = Math.max(this.model.size.width + offset.left + offset.right, this.model.pageWidth);
            var newHeight = Math.max(this.model.size.height + offset.top + offset.bottom, this.model.pageHeight);
            this.model.size = new size_1.Size(newWidth, newHeight);
        }
    };
    ModelManipulator.prototype.getModelSizeUpdateOffset = function () {
        var oldRectangle = this.model.getRectangle(false);
        var newRectangle = this.model.getRectangle(true);
        if (!newRectangle.equals(oldRectangle))
            this.raiseModelRectangleChanged(newRectangle);
        return this.createModelRectangleOffset(newRectangle);
    };
    ModelManipulator.prototype.createModelRectangleOffset = function (rectangle) {
        var pageWidth = this.model.pageWidth;
        var pageHeight = this.model.pageHeight;
        var size = this.model.size;
        return new offsets_1.Offsets(-Math.floor(rectangle.x / pageWidth) * pageWidth, -Math.floor((size.width - rectangle.right) / pageWidth) * pageWidth, -Math.floor(rectangle.y / pageHeight) * this.model.pageHeight, -Math.floor((size.height - rectangle.bottom) / pageHeight) * pageHeight);
    };
    ModelManipulator.prototype.raiseModelChanged = function (changes) {
        this.onModelChanged.raise1(function (l) { return l.notifyModelChanged(changes); });
    };
    ModelManipulator.prototype.raisePageColorChanged = function (color) {
        this.onModelChanged.raise1(function (l) { return l.notifyPageColorChanged(color); });
    };
    ModelManipulator.prototype.raisePageSizeChanged = function (pageSize, pageLandscape) {
        this.onModelChanged.raise1(function (l) { return l.notifyPageSizeChanged(pageSize, pageLandscape); });
    };
    ModelManipulator.prototype.raiseModelSizeChanged = function (size, offset) {
        this.onModelSizeChanged.raise1(function (l) { return l.notifyModelSizeChanged(size, offset); });
    };
    ModelManipulator.prototype.raiseModelRectangleChanged = function (rectangle) {
        this.onModelSizeChanged.raise1(function (l) { return l.notifyModelRectangleChanged(rectangle); });
    };
    ModelManipulator.prototype.raiseSnapPointChange = function (point) {
        this.onModelSizeChanged.raise1(function (l) { return l.notifySnapPointPositionChanged(point); });
    };
    ModelManipulator.prototype.getInteractingItem = function (item, operation) {
        return this.permissionsProvider.getInteractingItem(item, operation);
    };
    return ModelManipulator;
}());
exports.ModelManipulator = ModelManipulator;


/***/ }),

/***/ 2721:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UniqueAStarNodePositions = void 0;
var UniqueAStarNodePositions = (function () {
    function UniqueAStarNodePositions(getKey) {
        if (getKey === void 0) { getKey = function (key) { return key.toString(); }; }
        this.getKey = getKey;
        this.items = {};
        this.length = 0;
    }
    Object.defineProperty(UniqueAStarNodePositions.prototype, "count", {
        get: function () { return this.length; },
        enumerable: false,
        configurable: true
    });
    UniqueAStarNodePositions.prototype.getNode = function (position) {
        var item = this.items[this.getKey(position)];
        return item !== undefined ? item.node : undefined;
    };
    UniqueAStarNodePositions.prototype.add = function (position, node) {
        var key = this.getKey(position);
        if (this.items[key] === undefined) {
            this.length++;
            this.items[key] = { position: position, node: node };
        }
    };
    UniqueAStarNodePositions.prototype.remove = function (position) {
        var key = this.getKey(position);
        if (this.items[key] !== undefined) {
            this.length--;
            delete this.items[key];
        }
    };
    return UniqueAStarNodePositions;
}());
exports.UniqueAStarNodePositions = UniqueAStarNodePositions;


/***/ }),

/***/ 2740:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AStarNode = void 0;
var AStarNode = (function () {
    function AStarNode(position, distance) {
        this.position = position;
        this.distance = distance;
        this.penalty = 0;
    }
    Object.defineProperty(AStarNode.prototype, "key", {
        get: function () { return this.distance + this.penalty; },
        enumerable: false,
        configurable: true
    });
    AStarNode.prototype.getPath = function () {
        var result = [];
        var currentNode = this;
        while (currentNode !== undefined) {
            result.splice(0, 0, currentNode.position);
            currentNode = currentNode.parent;
        }
        return result;
    };
    return AStarNode;
}());
exports.AStarNode = AStarNode;


/***/ }),

/***/ 2748:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BringToFrontCommand = void 0;
var ChangeZindexHistoryItem_1 = __webpack_require__(672);
var SimpleCommandBase_1 = __webpack_require__(3913);
var BringToFrontCommand = (function (_super) {
    __extends(BringToFrontCommand, _super);
    function BringToFrontCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BringToFrontCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length > 0 && this.needBringToFront(items);
    };
    BringToFrontCommand.prototype.executeCore = function (state, parameter) {
        var _this = this;
        this.control.history.beginTransaction();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            var newZIndex = _this.control.model.getIntersectItemsMaxZIndex(item) + 1;
            _this.control.history.addAndRedo(new ChangeZindexHistoryItem_1.ChangeZindexHistoryItem(item, newZIndex));
        });
        this.control.history.endTransaction();
        return true;
    };
    BringToFrontCommand.prototype.needBringToFront = function (items) {
        var _this = this;
        var _loop_1 = function (i) {
            var zIndex = this_1.control.model.getIntersectItemsMaxZIndex(items[i]);
            if (zIndex > items[i].zIndex)
                return { value: true };
            if (zIndex === items[i].zIndex) {
                var result_1 = false;
                var sameZIndexItems = this_1.control.model.getIntersectItems(items[i]).filter(function (item) { return item.zIndex === items[i].zIndex; });
                sameZIndexItems.forEach(function (item) {
                    if (_this.control.model.getItemIndex(item) > _this.control.model.getItemIndex(items[i])) {
                        result_1 = true;
                        return;
                    }
                });
                return { value: result_1 };
            }
        };
        var this_1 = this;
        for (var i = 0; i < items.length; i++) {
            var state_1 = _loop_1(i);
            if (typeof state_1 === "object")
                return state_1.value;
        }
        return false;
    };
    return BringToFrontCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.BringToFrontCommand = BringToFrontCommand;


/***/ }),

/***/ 2771:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorTextPositionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangeConnectorTextPositionHistoryItem = (function (_super) {
    __extends(ChangeConnectorTextPositionHistoryItem, _super);
    function ChangeConnectorTextPositionHistoryItem(connector, position, newPosition) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.position = position;
        _this.newPosition = newPosition;
        return _this;
    }
    ChangeConnectorTextPositionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorTextPosition(connector, this.position, this.newPosition);
    };
    ChangeConnectorTextPositionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.changeConnectorTextPosition(connector, this.newPosition, this.position);
    };
    return ChangeConnectorTextPositionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangeConnectorTextPositionHistoryItem = ChangeConnectorTextPositionHistoryItem;


/***/ }),

/***/ 2781:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.HardDiskShapeDescription = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var PathPrimitive_1 = __webpack_require__(6208);
var EllipsePrimitive_1 = __webpack_require__(7345);
var ShapeDescription_1 = __webpack_require__(1280);
var size_1 = __webpack_require__(3844);
var HardDiskShapeDescription = (function (_super) {
    __extends(HardDiskShapeDescription, _super);
    function HardDiskShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(HardDiskShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.HardDisk; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HardDiskShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    HardDiskShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width;
        var cy = rect.center.y;
        var dx = width * HardDiskShapeDescription.arcWidthRatio;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(right - dx / 2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left + dx / 2, top),
                new PathPrimitive_1.PathPrimitiveArcToCommand(dx / 2, (bottom - top) / 2, 0, false, false, left + dx / 2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right - dx / 2, bottom),
            ], shape.style),
            new EllipsePrimitive_1.EllipsePrimitive(right - dx / 2, cy, dx / 2, (bottom - top) / 2, shape.style)
        ];
    };
    HardDiskShapeDescription.prototype.getTextRectangle = function (shape) {
        var rect = shape.rectangle;
        var dx = rect.width * HardDiskShapeDescription.arcWidthRatio * 1.5;
        return rect.clone()
            .resize(-dx - 2 * ShapeDescription_1.ShapeTextPadding, -2 * ShapeDescription_1.ShapeTextPadding)
            .moveRectangle(ShapeDescription_1.ShapeTextPadding, ShapeDescription_1.ShapeTextPadding)
            .nonNegativeSize();
    };
    HardDiskShapeDescription.prototype.getSizeByText = function (textSize, shape) {
        return new size_1.Size((textSize.width + ShapeDescription_1.ShapeTextPadding * 2) / (1 - 1.5 * HardDiskShapeDescription.arcWidthRatio), shape.size.height + ShapeDescription_1.ShapeTextPadding);
    };
    HardDiskShapeDescription.arcWidthRatio = 0.2;
    return HardDiskShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.HardDiskShapeDescription = HardDiskShapeDescription;


/***/ }),

/***/ 2803:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ContextMenuHandler = void 0;
var Utils_1 = __webpack_require__(41);
var Event_1 = __webpack_require__(5428);
var key_1 = __webpack_require__(6537);
var batch_updatable_1 = __webpack_require__(815);
var browser_1 = __webpack_require__(8424);
var ContextMenuHandler = (function (_super) {
    __extends(ContextMenuHandler, _super);
    function ContextMenuHandler() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.contextMenuVisible = false;
        _this.textInputStarted = false;
        _this.canHideContextMenu = true;
        _this.onVisibilityChanged = new Utils_1.EventDispatcher();
        return _this;
    }
    ContextMenuHandler.prototype.onMouseDown = function (evt) {
        if (evt.button === Event_1.MouseButton.Left && evt.source.type !== Event_1.MouseEventElementType.Undefined)
            this.hideContextMenu();
    };
    ContextMenuHandler.prototype.onMouseUp = function (evt) {
        if (!browser_1.Browser.MacOSPlatform || browser_1.Browser.MacOSPlatform && this.canHideContextMenu)
            this.hideContextMenu();
        this.canHideContextMenu = true;
    };
    ContextMenuHandler.prototype.onContextMenu = function (evt) {
        if (browser_1.Browser.MacOSPlatform)
            this.canHideContextMenu = false;
        this.showContextMenu(evt.eventPoint, evt.modelPoint);
    };
    ContextMenuHandler.prototype.onFocus = function (evt) { };
    ContextMenuHandler.prototype.onBlur = function (evt) { };
    ContextMenuHandler.prototype.onTextInputFocus = function (evt) { };
    ContextMenuHandler.prototype.onTextInputBlur = function (evt) { };
    ContextMenuHandler.prototype.onLongTouch = function (evt) { };
    ContextMenuHandler.prototype.onKeyDown = function (evt) {
        if (evt.keyCode === key_1.KeyCode.Esc)
            this.hideContextMenu();
    };
    ContextMenuHandler.prototype.onShortcut = function (evt) {
        this.hideContextMenu();
    };
    ContextMenuHandler.prototype.showContextMenu = function (eventPoint, modelPoint) {
        var _this = this;
        if (this.textInputStarted)
            return;
        window.setTimeout(function () {
            _this.onVisibilityChanged.raise1(function (l) { return l.notifyShowContextMenu(eventPoint, modelPoint); });
            _this.contextMenuVisible = true;
        }, 1);
    };
    ContextMenuHandler.prototype.hideContextMenu = function () {
        var _this = this;
        if (this.contextMenuVisible)
            window.setTimeout(function () {
                _this.onVisibilityChanged.raise1(function (l) { return l.notifyHideContextMenu(); });
                _this.contextMenuVisible = false;
            }, 1);
    };
    ContextMenuHandler.prototype.notifyDragStart = function (itemKeys) { };
    ContextMenuHandler.prototype.notifyDragEnd = function (itemKeys) { };
    ContextMenuHandler.prototype.notifyDragScrollStart = function () { };
    ContextMenuHandler.prototype.notifyDragScrollEnd = function () { };
    ContextMenuHandler.prototype.notifyShowContextToolbox = function (modelPoint, getPositionToInsertShapeTo, side, category, callback) { };
    ContextMenuHandler.prototype.notifyHideContextToolbox = function () { };
    ContextMenuHandler.prototype.notifyTextInputStart = function (item, text, position, size) {
        this.textInputStarted = true;
    };
    ContextMenuHandler.prototype.notifyTextInputEnd = function (item, captureFocus) {
        this.textInputStarted = false;
    };
    ContextMenuHandler.prototype.notifyTextInputPermissionsCheck = function (item, allowed) { };
    ContextMenuHandler.prototype.onUpdateUnlocked = function (occurredEvents) { };
    return ContextMenuHandler;
}(batch_updatable_1.BatchUpdatableObject));
exports.ContextMenuHandler = ContextMenuHandler;


/***/ }),

/***/ 2807:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MutableInterval = void 0;
var tslib_1 = __webpack_require__(5215);
var const_1 = __webpack_require__(7446);
var MutableInterval = (function (_super) {
    tslib_1.__extends(MutableInterval, _super);
    function MutableInterval() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MutableInterval.prototype.normalizeLength = function () {
        if (this.length < 0)
            this.length = 0;
        return this;
    };
    return MutableInterval;
}(const_1.ConstInterval));
exports.MutableInterval = MutableInterval;


/***/ }),

/***/ 2815:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerDraggingState = void 0;
var MouseHandlerStateBase_1 = __webpack_require__(9589);
var Event_1 = __webpack_require__(5428);
var unit_converter_1 = __webpack_require__(9500);
var MouseHandlerDraggingState = (function (_super) {
    __extends(MouseHandlerDraggingState, _super);
    function MouseHandlerDraggingState(handler, history) {
        var _this = _super.call(this, handler) || this;
        _this.history = history;
        return _this;
    }
    MouseHandlerDraggingState.prototype.canApplyChangesOnMouseMove = function (initPosition, position) {
        return !initPosition || !position ||
            Math.abs(initPosition.x - position.x) > MouseHandlerDraggingState.dragStartLimit ||
            Math.abs(initPosition.y - position.y) > MouseHandlerDraggingState.dragStartLimit;
    };
    MouseHandlerDraggingState.prototype.onAfterApplyChanges = function () {
        if (!this.modified)
            this.handler.raiseDragStart(this.getDraggingElementKeys());
        this.modified = true;
        this.mouseDownPoint = undefined;
    };
    MouseHandlerDraggingState.prototype.onMouseDown = function (evt) {
        this.mouseDownPoint = evt.modelPoint.clone();
    };
    MouseHandlerDraggingState.prototype.onMouseMove = function (evt) {
        this.mouseMoveEvent = evt;
        if (evt.button !== Event_1.MouseButton.Left) {
            this.cancelChanges();
            this.handler.switchToDefaultState();
        }
        else if (evt.button === Event_1.MouseButton.Left && this.canApplyChangesOnMouseMove(this.mouseDownPoint, evt.modelPoint)) {
            this.onApplyChanges(evt);
            this.onAfterApplyChanges();
        }
    };
    MouseHandlerDraggingState.prototype.onKeyDown = function (evt) {
        if (this.mouseMoveEvent && (evt.keyCode === 16 || evt.keyCode === 17 || evt.keyCode === 18))
            this.performMouseMoveEvent(evt.modifiers);
    };
    MouseHandlerDraggingState.prototype.onKeyUp = function (evt) {
        if (this.mouseMoveEvent && (evt.keyCode === 16 || evt.keyCode === 17 || evt.keyCode === 18))
            this.performMouseMoveEvent(evt.modifiers);
    };
    MouseHandlerDraggingState.prototype.onMouseUp = function (evt) {
        this.mouseDownPoint = undefined;
        this.mouseMoveEvent = undefined;
        this.handler.switchToDefaultState();
    };
    MouseHandlerDraggingState.prototype.performMouseMoveEvent = function (modifiers) {
        this.mouseMoveEvent.modifiers = modifiers;
        this.onMouseMove(this.mouseMoveEvent);
    };
    MouseHandlerDraggingState.prototype.start = function () {
        this.handler.beginStorePermissions();
        this.history.beginTransaction();
    };
    MouseHandlerDraggingState.prototype.finish = function () {
        this.checkStoredPermissionsOnFinish();
        if (this.modified) {
            this.onFinishWithChanges();
            this.modified = false;
            this.history.endTransaction();
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        }
        else
            this.history.endTransaction();
        this.handler.endStorePermissions();
        this.handler.clearInteractingItems();
    };
    MouseHandlerDraggingState.prototype.checkStoredPermissionsOnFinish = function () {
        if (!this.handler.isStoredPermissionsGranted()) {
            this.cancelChanges();
            this.modified = false;
        }
    };
    MouseHandlerDraggingState.prototype.onFinishWithChanges = function () { };
    MouseHandlerDraggingState.prototype.cancelChanges = function () {
        this.handler.lockPermissions();
        this.history.undoTransaction();
        this.handler.unlockPermissions();
        if (this.modified)
            this.handler.raiseDragEnd(this.getDraggingElementKeys());
        this.modified = false;
    };
    MouseHandlerDraggingState.prototype.getSnappedPoint = function (evt, point) {
        return this.handler.getSnappedPointOnDragPoint(evt, point);
    };
    MouseHandlerDraggingState.dragStartLimit = unit_converter_1.UnitConverter.pixelsToTwips(4);
    return MouseHandlerDraggingState;
}(MouseHandlerStateBase_1.MouseHandlerCancellableState));
exports.MouseHandlerDraggingState = MouseHandlerDraggingState;


/***/ }),

/***/ 2871:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.FixedInterval = void 0;
var tslib_1 = __webpack_require__(5215);
var mutable_1 = __webpack_require__(2807);
var FixedInterval = (function (_super) {
    tslib_1.__extends(FixedInterval, _super);
    function FixedInterval(start, length) {
        var _this = _super.call(this) || this;
        _this.start = start;
        _this.length = length;
        return _this;
    }
    Object.defineProperty(FixedInterval.prototype, "end", {
        get: function () {
            return this.start + this.length;
        },
        set: function (newEnd) {
            this.length = newEnd - this.start;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FixedInterval.prototype, "center", {
        get: function () {
            return this.start + this.length / 2;
        },
        enumerable: false,
        configurable: true
    });
    FixedInterval.prototype.copyFrom = function (obj) {
        this.start = obj.start;
        this.length = obj.length;
    };
    FixedInterval.prototype.equals = function (obj) {
        return obj && this.start === obj.start && this.length === obj.length;
    };
    FixedInterval.prototype.clone = function () {
        return new FixedInterval(this.start, this.length);
    };
    FixedInterval.prototype.makeByStartEnd = function (start, end) {
        return new FixedInterval(start, end - start);
    };
    FixedInterval.prototype.makeByStartLength = function (start, length) {
        return new FixedInterval(start, length);
    };
    FixedInterval.prototype.makeByLengthEnd = function (length, end) {
        return new FixedInterval(end - length, length);
    };
    FixedInterval.fromPositions = function (start, end) {
        return new FixedInterval(start, end - start);
    };
    FixedInterval.makeByConstInterval = function (interval) {
        return new FixedInterval(interval.start, interval.length);
    };
    FixedInterval.prototype.expand = function (interval) {
        var end = Math.max(interval.end, this.end);
        this.start = Math.min(interval.start, this.start);
        this.end = end;
        return this;
    };
    return FixedInterval;
}(mutable_1.MutableInterval));
exports.FixedInterval = FixedInterval;


/***/ }),

/***/ 2892:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ListUtils = void 0;
var min_max_1 = __webpack_require__(3196);
var comparers_1 = __webpack_require__(3262);
var ListUtils = (function () {
    function ListUtils() {
    }
    ListUtils.remove = function (list, element) {
        var index = list.indexOf(element, 0);
        if (index >= 0)
            list.splice(index, 1);
    };
    ListUtils.removeBy = function (list, callback) {
        var len = list.length;
        for (var index = 0; index < len; index++) {
            if (callback(list[index], index))
                return list.splice(index, 1)[0];
        }
        return null;
    };
    ListUtils.shallowCopy = function (list) {
        return list.slice();
    };
    ListUtils.deepCopy = function (list) {
        return ListUtils.map(list, function (val) { return val.clone(); });
    };
    ListUtils.initByValue = function (numElements, initValue) {
        var result = [];
        for (; numElements > 0; numElements--)
            result.push(initValue);
        return result;
    };
    ListUtils.initByCallback = function (numElements, initCallback) {
        var result = [];
        for (var index = 0; index < numElements; index++)
            result.push(initCallback(index));
        return result;
    };
    ListUtils.forEachOnInterval = function (interval, callback) {
        var end = interval.end;
        for (var index = interval.start; index < end; index++)
            callback(index);
    };
    ListUtils.reverseForEachOnInterval = function (interval, callback) {
        var start = interval.start;
        for (var index = interval.end - 1; index >= start; index--)
            callback(index);
    };
    ListUtils.reducedMap = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++) {
            var newItem = callback(list[index], index);
            if (newItem !== null)
                result.push(newItem);
        }
        return result;
    };
    ListUtils.filter = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++) {
            var item = list[index];
            if (callback(item, index))
                result.push(item);
        }
        return result;
    };
    ListUtils.map = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var result = [];
        for (var index = startIndex; index < endIndex; index++)
            result.push(callback(list[index], index));
        return result;
    };
    ListUtils.indexBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var ind = startIndex; ind < endIndex; ind++) {
            if (callback(list[ind], ind))
                return ind;
        }
        return -1;
    };
    ListUtils.reverseIndexBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var ind = startIndex; ind >= endIndex; ind--) {
            if (callback(list[ind], ind))
                return ind;
        }
        return -1;
    };
    ListUtils.elementBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var ind = ListUtils.indexBy(list, callback, startIndex, endIndex);
        return ind < 0 ? null : list[ind];
    };
    ListUtils.reverseElementBy = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        var ind = ListUtils.reverseIndexBy(list, callback, startIndex, endIndex);
        return ind < 0 ? null : list[ind];
    };
    ListUtils.last = function (list) {
        return list[list.length - 1];
    };
    ListUtils.setLast = function (list, newVal) {
        return list[list.length - 1] = newVal;
    };
    ListUtils.incLast = function (list) {
        return ++list[list.length - 1];
    };
    ListUtils.decLast = function (list) {
        return --list[list.length - 1];
    };
    ListUtils.equals = function (a, b) {
        return a.length === b.length && ListUtils.allOf2(a, b, function (a, b) { return a.equals(b); });
    };
    ListUtils.equalsByReference = function (a, b) {
        var aLen = a.length;
        var bLen = a.length;
        if (aLen !== bLen)
            return false;
        for (var i = 0; i < aLen; i++) {
            if (a[i] !== b[i])
                return false;
        }
        return true;
    };
    ListUtils.unique = function (list, cmp, equal, finalizeObj) {
        if (equal === void 0) { equal = cmp; }
        if (finalizeObj === void 0) { finalizeObj = function () { }; }
        var len = list.length;
        if (len === 0)
            return [];
        list = list.sort(cmp);
        var prevValue = list[0];
        var result = ListUtils.reducedMap(list, function (v) {
            if (equal(prevValue, v) !== 0) {
                prevValue = v;
                return v;
            }
            finalizeObj(v);
            return null;
        }, 1, len);
        result.unshift(list[0]);
        return result;
    };
    ListUtils.uniqueNumber = function (list) {
        list = list.sort(comparers_1.Comparers.number);
        var prevValue = Number.NaN;
        for (var i = list.length - 1; i >= 0; i--) {
            if (prevValue === list[i])
                list.splice(i, 1);
            else
                prevValue = list[i];
        }
        return list;
    };
    ListUtils.forEach = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++)
            callback(list[index], index);
    };
    ListUtils.forEach2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++)
            callback(listA[index], listB[index], index);
    };
    ListUtils.reverseForEach = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--)
            callback(list[index], index);
    };
    ListUtils.reverseIndexOf = function (list, element, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            if (list[index] === element)
                return index;
        }
        return -1;
    };
    ListUtils.accumulate = function (list, initAccValue, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var acc = initAccValue;
        for (var ind = startIndex; ind < endIndex; ind++)
            acc = callback(acc, list[ind], ind);
        return acc;
    };
    ListUtils.accumulateNumber = function (list, callback, initAccValue, startIndex, endIndex) {
        if (initAccValue === void 0) { initAccValue = 0; }
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var acc = initAccValue;
        for (var ind = startIndex; ind < endIndex; ind++)
            acc += callback(list[ind], ind, acc);
        return acc;
    };
    ListUtils.anyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (callback(list[index], index))
                return true;
        }
        return false;
    };
    ListUtils.unsafeAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            var currResult = callback(list[index], index);
            if (currResult)
                return currResult;
        }
        return null;
    };
    ListUtils.reverseAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            if (callback(list[index], index))
                return true;
        }
        return false;
    };
    ListUtils.unsafeReverseAnyOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = list.length - 1; }
        if (endIndex === void 0) { endIndex = 0; }
        for (var index = startIndex; index >= endIndex; index--) {
            var currResult = callback(list[index], index);
            if (currResult)
                return currResult;
        }
        return null;
    };
    ListUtils.anyOf2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (callback(listA[index], listB[index], index))
                return true;
        }
        return false;
    };
    ListUtils.allOf = function (list, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (!callback(list[index], index))
                return false;
        }
        return true;
    };
    ListUtils.allOf2 = function (listA, listB, callback, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = listA.length; }
        for (var index = startIndex; index < endIndex; index++) {
            if (!callback(listA[index], listB[index], index))
                return false;
        }
        return true;
    };
    ListUtils.allOfOnInterval = function (interval, callback) {
        var endIndex = interval.end;
        for (var index = interval.start; index < endIndex; index++) {
            if (!callback(index))
                return false;
        }
        return true;
    };
    ListUtils.addListOnTail = function (resultList, addedList) {
        for (var i = 0, elem = void 0; elem = addedList[i]; i++)
            resultList.push(elem);
        return resultList;
    };
    ListUtils.joinLists = function (converter) {
        var lists = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            lists[_i - 1] = arguments[_i];
        }
        return ListUtils.accumulate(lists, [], function (accList, list) {
            ListUtils.addListOnTail(accList, converter(list));
            return accList;
        });
    };
    ListUtils.push = function (list, element) {
        list.push(element);
        return list;
    };
    ListUtils.countIf = function (list, callback) {
        return ListUtils.accumulateNumber(list, function (elem, ind) { return callback(elem, ind) ? 1 : 0; });
    };
    ListUtils.clear = function (list) {
        list.splice(0);
    };
    ListUtils.merge = function (list, cmp, shouldMerge, merge, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        list = list.slice(startIndex, endIndex);
        if (endIndex - startIndex < 2)
            return list;
        list = list.sort(cmp);
        var prevObj = list[startIndex];
        var result = [prevObj];
        for (var ind = startIndex + 1; ind < endIndex; ind++) {
            var obj = list[ind];
            if (shouldMerge(prevObj, obj))
                merge(prevObj, obj);
            else {
                prevObj = obj;
                result.push(prevObj);
            }
        }
        return result;
    };
    ListUtils.min = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.minExtended(list, getValue, startIndex, endIndex);
        return res ? res.minElement : null;
    };
    ListUtils.max = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.maxExtended(list, getValue, startIndex, endIndex);
        return res ? res.maxElement : null;
    };
    ListUtils.minMax = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        var res = ListUtils.minMaxExtended(list, getValue, startIndex, endIndex);
        return res ? new min_max_1.MinMax(res.minElement, res.maxElement) : null;
    };
    ListUtils.minExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var minElement = list[startIndex];
        var minValue = getValue(minElement);
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue < minValue) {
                minValue = elemValue;
                minElement = elem;
            }
        }
        return new min_max_1.ExtendedMin(minElement, minValue);
    };
    ListUtils.maxExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var maxElement = list[startIndex];
        var maxValue = getValue(maxElement);
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue > maxValue) {
                maxValue = elemValue;
                maxElement = elem;
            }
        }
        return new min_max_1.ExtendedMax(maxElement, maxValue);
    };
    ListUtils.minMaxExtended = function (list, getValue, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var minElement = list[startIndex];
        var maxElement = minElement;
        var minValue = getValue(minElement);
        var maxValue = minValue;
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var elemValue = getValue(elem);
            if (elemValue < minValue) {
                minValue = elemValue;
                minElement = elem;
            }
            else if (elemValue > maxValue) {
                maxValue = elemValue;
                maxElement = elem;
            }
        }
        return new min_max_1.ExtendedMinMax(minElement, minValue, maxElement, maxValue);
    };
    ListUtils.minByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var found = list[startIndex];
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            if (cmp(elem, found) < 0)
                found = elem;
        }
        return found;
    };
    ListUtils.maxByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var found = list[startIndex];
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            if (cmp(elem, found) > 0)
                found = elem;
        }
        return found;
    };
    ListUtils.minMaxByCmp = function (list, cmp, startIndex, endIndex) {
        if (startIndex === void 0) { startIndex = 0; }
        if (endIndex === void 0) { endIndex = list.length; }
        if (list.length === 0)
            return null;
        var min = list[startIndex];
        var max = min;
        for (var index = startIndex + 1; index < endIndex; index++) {
            var elem = list[index];
            var res = cmp(elem, min);
            if (res > 0)
                max = elem;
            else if (res < 0)
                min = elem;
        }
        return new min_max_1.MinMax(min, max);
    };
    return ListUtils;
}());
exports.ListUtils = ListUtils;


/***/ }),

/***/ 2899:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutTreeHorizontalRightToLeftCommand = void 0;
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutTreeHorizontalCommand_1 = __webpack_require__(7283);
var AutoLayoutTreeHorizontalRightToLeftCommand = (function (_super) {
    __extends(AutoLayoutTreeHorizontalRightToLeftCommand, _super);
    function AutoLayoutTreeHorizontalRightToLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutTreeHorizontalRightToLeftCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutTreeHorizontalRightToLeftCommand;
}(AutoLayoutTreeHorizontalCommand_1.AutoLayoutTreeHorizontalCommand));
exports.AutoLayoutTreeHorizontalRightToLeftCommand = AutoLayoutTreeHorizontalRightToLeftCommand;


/***/ }),

/***/ 2993:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteCommand = void 0;
var ModelUtils_1 = __webpack_require__(1922);
var SimpleCommandBase_1 = __webpack_require__(3913);
var DeleteCommand = (function (_super) {
    __extends(DeleteCommand, _super);
    function DeleteCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    DeleteCommand.prototype.isEnabled = function () {
        var items = this.control.selection.getSelectedItems();
        return _super.prototype.isEnabled.call(this) && items.length && (items.length > 1 || this.permissionsProvider.canDeleteItems(items));
    };
    DeleteCommand.prototype.executeCore = function (state) {
        var items = this.control.selection.getSelectedItems(true, true);
        this.permissionsProvider.beginDeleteItems(items);
        ModelUtils_1.ModelUtils.deleteSelection(this.control.history, this.control.model, this.control.selection);
        this.permissionsProvider.endDeleteItems();
        return true;
    };
    Object.defineProperty(DeleteCommand.prototype, "isPermissionsRequired", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    return DeleteCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.DeleteCommand = DeleteCommand;


/***/ }),

/***/ 3039:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PasteSelectionInPositionCommand = void 0;
var PasteSelectionCommandBase_1 = __webpack_require__(5451);
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var point_1 = __webpack_require__(5327);
var PasteSelectionInPositionCommand = (function (_super) {
    __extends(PasteSelectionInPositionCommand, _super);
    function PasteSelectionInPositionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    PasteSelectionInPositionCommand.prototype.getEventPositionOffset = function (items, evtPosition) {
        if (!evtPosition)
            return point_1.Point.zero();
        var selectionPos = items.reduce(function (min, i) {
            return {
                x: Math.min(min.x, i instanceof Shape_1.Shape ? i.position.x : i instanceof Connector_1.Connector ? i.getMinX() : Number.MAX_VALUE),
                y: Math.min(min.y, i instanceof Shape_1.Shape ? i.position.y : i instanceof Connector_1.Connector ? i.getMinY() : Number.MAX_VALUE)
            };
        }, {
            x: Number.MAX_VALUE,
            y: Number.MAX_VALUE
        });
        var newSelectionPos = this.control.render.getModelPointByEventPoint(evtPosition.x, evtPosition.y);
        return new point_1.Point(newSelectionPos.x - selectionPos.x, newSelectionPos.y - selectionPos.y);
    };
    return PasteSelectionInPositionCommand;
}(PasteSelectionCommandBase_1.PasteSelectionCommandBase));
exports.PasteSelectionInPositionCommand = PasteSelectionInPositionCommand;


/***/ }),

/***/ 3054:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BindDocumentCommand = void 0;
var DataLayoutParameters_1 = __webpack_require__(2175);
var SimpleCommandBase_1 = __webpack_require__(3913);
var BindDocumentCommand = (function (_super) {
    __extends(BindDocumentCommand, _super);
    function BindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    BindDocumentCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    BindDocumentCommand.prototype.executeCore = function (state, parameter) {
        if (!parameter || !Array.isArray(parameter.nodeDataSource))
            throw Error("Format exception");
        this.performImportData(parameter);
        this.control.updateLayout(true);
        return true;
    };
    BindDocumentCommand.prototype.performImportData = function (parameter) {
        var dataSource = this.control.createDocumentDataSource(parameter.nodeDataSource, parameter.edgeDataSource, parameter.dataParameters, parameter.nodeDataImporter, parameter.edgeDataImporter);
        this.control.beginUpdateCanvas();
        this.permissionsProvider.lockPermissions();
        var layoutParameters = new DataLayoutParameters_1.DataLayoutParameters(this.control.settings, parameter.layoutParameters);
        dataSource.createModelItems(this.control.history, this.control.model, this.control.shapeDescriptionManager, this.control.selection, layoutParameters, this.control.settings.snapToGrid, this.control.settings.gridSize, this.control.measurer);
        this.permissionsProvider.unlockPermissions();
        this.control.endUpdateCanvas();
    };
    return BindDocumentCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.BindDocumentCommand = BindDocumentCommand;


/***/ }),

/***/ 3099:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Selection = void 0;
var Utils_1 = __webpack_require__(41);
var InputPosition_1 = __webpack_require__(1530);
var Shape_1 = __webpack_require__(8408);
var Connector_1 = __webpack_require__(6320);
var Data_1 = __webpack_require__(2620);
var Selection = (function () {
    function Selection(model) {
        this.onChanged = new Utils_1.EventDispatcher();
        this.inputPosition = new InputPosition_1.InputPosition(this);
        this.onChanged.add(this.inputPosition);
        this.initialize(model);
    }
    Selection.prototype.initialize = function (model) {
        this.model = model;
        this.keys = [];
        this.inputPosition.initialize();
    };
    Selection.prototype.add = function (key) {
        if (this.keys.indexOf(key) < 0) {
            this.keys.push(key);
            this.raiseSelectionChanged();
        }
    };
    Selection.prototype.remove = function (key) {
        if (this.keys.indexOf(key) >= 0) {
            this.keys.splice(this.keys.indexOf(key), 1);
            this.raiseSelectionChanged();
        }
    };
    Selection.prototype.clear = function () {
        if (this.keys.length > 0) {
            this.keys = [];
            this.raiseSelectionChanged();
        }
    };
    Selection.prototype.set = function (keys, forceChange) {
        if (forceChange || !Data_1.Data.ArrayEqual(keys, this.keys)) {
            this.keys = keys;
            this.raiseSelectionChanged();
        }
    };
    Selection.prototype.getKeys = function () {
        return this.keys;
    };
    Selection.prototype.getKey = function (index) {
        return this.keys[index];
    };
    Selection.prototype.getSelectedItemsInsideContainers = function (items) {
        var _this = this;
        var result = items.slice();
        items.forEach(function (item) {
            if (item instanceof Shape_1.Shape) {
                var children = _this.getSelectedItemsInsideContainers(_this.model.getChildren(item));
                children.forEach(function (child) {
                    if (result.indexOf(child) === -1 && !_this.hasKey(child.key))
                        result.push(child);
                });
            }
        });
        return result;
    };
    Selection.prototype.getSelectedItemsCore = function (includeLocked) {
        var _this = this;
        return this.keys.map(function (key) { return _this.model.findItem(key); })
            .filter(function (item) { return item && (includeLocked || !item.isLocked); });
    };
    Selection.prototype.getSelectedItems = function (includeLocked, includeInsideContainers) {
        if (includeInsideContainers)
            return this.getSelectedItemsInsideContainers(this.getSelectedItemsCore(includeLocked));
        return this.getSelectedItemsCore(includeLocked);
    };
    Selection.prototype.getSelectedShapes = function (includeLocked, includeInsideContainers) {
        var _this = this;
        if (includeInsideContainers) {
            var items = this.getSelectedItemsCore(includeLocked);
            return this.getSelectedItemsInsideContainers(items)
                .map(function (item) { return item instanceof Shape_1.Shape ? item : undefined; })
                .filter(function (shape) { return shape; });
        }
        else
            return this.keys.map(function (key) { return _this.model.findShape(key); })
                .filter(function (shape) { return shape && (includeLocked || !shape.isLocked); });
    };
    Selection.prototype.getSelectedConnectors = function (includeLocked, includeInsideContainers) {
        var _this = this;
        if (includeInsideContainers) {
            var items = this.keys.map(function (key) { return _this.model.findItem(key); });
            return this.getSelectedItemsInsideContainers(items)
                .map(function (item) { return item instanceof Connector_1.Connector ? item : undefined; })
                .filter(function (connector) { return connector && (includeLocked || !connector.isLocked); });
        }
        else
            return this.keys.map(function (key) { return _this.model.findConnector(key); })
                .filter(function (conn) { return conn && (includeLocked || !conn.isLocked); });
    };
    Selection.prototype.hasKey = function (key) {
        return this.keys.indexOf(key) >= 0;
    };
    Selection.prototype.isEmpty = function (includeLocked) {
        return !this.getSelectedItems(includeLocked).length;
    };
    Selection.prototype.selectRect = function (rect) {
        var keys = [];
        this.model.iterateItems(function (item) {
            if (item.intersectedByRect(rect))
                keys.push(item.key);
        });
        this.set(keys);
    };
    Selection.prototype.raiseSelectionChanged = function () {
        this.onChanged.raise("notifySelectionChanged", this);
    };
    return Selection;
}());
exports.Selection = Selection;


/***/ }),

/***/ 3105:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsCalculator = void 0;
var ConnectorPointsCalculatorBase_1 = __webpack_require__(1532);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ConnectorPointsCalculator = (function (_super) {
    __extends(ConnectorPointsCalculator, _super);
    function ConnectorPointsCalculator() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConnectorPointsCalculator.prototype.getPoints = function () {
        return this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
    };
    return ConnectorPointsCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsCalculator = ConnectorPointsCalculator;


/***/ }),

/***/ 3158:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangePageColorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ChangePageColorHistoryItem = (function (_super) {
    __extends(ChangePageColorHistoryItem, _super);
    function ChangePageColorHistoryItem(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    ChangePageColorHistoryItem.prototype.redo = function (manipulator) {
        this.oldValue = manipulator.model.pageColor;
        manipulator.changePageColor(this.value);
    };
    ChangePageColorHistoryItem.prototype.undo = function (manipulator) {
        manipulator.changePageColor(this.oldValue);
    };
    return ChangePageColorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ChangePageColorHistoryItem = ChangePageColorHistoryItem;


/***/ }),

/***/ 3165:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.PentagonShapeDescription = void 0;
var PathPrimitive_1 = __webpack_require__(6208);
var ShapeTypes_1 = __webpack_require__(3255);
var PolygonShapeDescription_1 = __webpack_require__(4717);
var DiagramItem_1 = __webpack_require__(4824);
var Utils_1 = __webpack_require__(41);
var rectangle_1 = __webpack_require__(4412);
var PentagonShapeDescription = (function (_super) {
    __extends(PentagonShapeDescription, _super);
    function PentagonShapeDescription(hasDefaultText) {
        var _this = _super.call(this, hasDefaultText) || this;
        _this.defaultRatio = _this.defaultSize.height / _this.defaultSize.width;
        return _this;
    }
    Object.defineProperty(PentagonShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Pentagon; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(PentagonShapeDescription.prototype, "angleCount", {
        get: function () { return 5; },
        enumerable: false,
        configurable: true
    });
    PentagonShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var cx = rect.center.x;
        var ratio = height / width / this.defaultRatio;
        var angle = Math.PI - this.angle;
        var py = width / 2 * Math.tan(angle / 2) * ratio;
        var y = top + py;
        var px = (height - py) / Math.tan(angle) / ratio;
        var x1 = left + px;
        var x2 = right - px;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(cx, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, y),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, y),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    PentagonShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East || side === DiagramItem_1.ConnectionPointSide.West) {
            var rect = shape.rectangle;
            var top_1 = rect.y, width = rect.width, height = rect.height;
            var ratio = height / width / this.defaultRatio;
            var angle = Math.PI - this.angle;
            var py = width / 2 * Math.tan(angle / 2) * ratio;
            var y = top_1 + py;
            if (side === DiagramItem_1.ConnectionPointSide.East)
                point.y = y;
            else if (side === DiagramItem_1.ConnectionPointSide.West)
                point.y = y;
        }
    };
    PentagonShapeDescription.prototype.calculateHeight = function (width) {
        var angle = Math.PI - this.angle;
        var h1 = width / 2 * Math.tan(angle / 2);
        var side = width / 2 / Math.cos(angle / 2);
        var h2 = side * Math.sin(angle);
        return h1 + h2;
    };
    PentagonShapeDescription.prototype.getTextRectangle = function (shape) {
        var textSize = Utils_1.GeometryUtils.getMaxRectangleEnscribedInEllipse(shape.size);
        return rectangle_1.Rectangle.fromGeometry(shape.position.clone().offset((shape.size.width - textSize.width) / 2, (shape.size.height - textSize.height) / 2), textSize);
    };
    PentagonShapeDescription.prototype.getSizeByText = function (textSize, _shape) {
        return Utils_1.GeometryUtils.getEllipseByEnscribedRectangle(textSize);
    };
    return PentagonShapeDescription;
}(PolygonShapeDescription_1.PolygonShapeDescription));
exports.PentagonShapeDescription = PentagonShapeDescription;


/***/ }),

/***/ 3188:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.TextRightAlignCommand = exports.TextCenterAlignCommand = exports.TextLeftAlignCommand = exports.ChangeTextAlignCommand = void 0;
var ToggleStyleTextPropertyCommand_1 = __webpack_require__(3210);
var ChangeTextAlignCommand = (function (_super) {
    __extends(ChangeTextAlignCommand, _super);
    function ChangeTextAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeTextAlignCommand.prototype.getStyleProperty = function () {
        return "text-anchor";
    };
    return ChangeTextAlignCommand;
}(ToggleStyleTextPropertyCommand_1.ToggleStyleTextPropertyCommand));
exports.ChangeTextAlignCommand = ChangeTextAlignCommand;
var TextLeftAlignCommand = (function (_super) {
    __extends(TextLeftAlignCommand, _super);
    function TextLeftAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextLeftAlignCommand.prototype.getStylePropertyValue = function () {
        return "start";
    };
    return TextLeftAlignCommand;
}(ChangeTextAlignCommand));
exports.TextLeftAlignCommand = TextLeftAlignCommand;
var TextCenterAlignCommand = (function (_super) {
    __extends(TextCenterAlignCommand, _super);
    function TextCenterAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextCenterAlignCommand.prototype.getStylePropertyValue = function () {
        return "middle";
    };
    return TextCenterAlignCommand;
}(ChangeTextAlignCommand));
exports.TextCenterAlignCommand = TextCenterAlignCommand;
var TextRightAlignCommand = (function (_super) {
    __extends(TextRightAlignCommand, _super);
    function TextRightAlignCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    TextRightAlignCommand.prototype.getStylePropertyValue = function () {
        return "end";
    };
    return TextRightAlignCommand;
}(ChangeTextAlignCommand));
exports.TextRightAlignCommand = TextRightAlignCommand;


/***/ }),

/***/ 3190:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RectangleShapeDescription = void 0;
var ShapeDescription_1 = __webpack_require__(1280);
var size_1 = __webpack_require__(3844);
var RectaglePrimitive_1 = __webpack_require__(94);
var ShapeTypes_1 = __webpack_require__(3255);
var RectangleShapeDescription = (function (_super) {
    __extends(RectangleShapeDescription, _super);
    function RectangleShapeDescription(defaultSize, hasDefaultText) {
        if (defaultSize === void 0) { defaultSize = new size_1.Size(ShapeDescription_1.ShapeDefaultDimension, ShapeDescription_1.ShapeDefaultDimension * 0.75); }
        return _super.call(this, defaultSize, hasDefaultText) || this;
    }
    Object.defineProperty(RectangleShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Rectangle; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(RectangleShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    RectangleShapeDescription.prototype.createShapePrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.x, top = _a.y, width = _a.width, height = _a.height;
        return [
            new RectaglePrimitive_1.RectanglePrimitive(left, top, width, height, shape.style),
        ];
    };
    RectangleShapeDescription.prototype.getTextRectangle = function (shape) {
        return shape.rectangle.clone().inflate(-ShapeDescription_1.ShapeTextPadding, -ShapeDescription_1.ShapeTextPadding);
    };
    RectangleShapeDescription.prototype.getSizeByText = function (textSize, _shape) {
        return textSize.clone().offset(ShapeDescription_1.ShapeTextPadding * 2, ShapeDescription_1.ShapeTextPadding * 2);
    };
    return RectangleShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.RectangleShapeDescription = RectangleShapeDescription;


/***/ }),

/***/ 3196:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtendedMinMax = exports.ExtendedMax = exports.ExtendedMin = exports.MinMaxNumber = exports.MinMax = void 0;
var tslib_1 = __webpack_require__(5215);
var MinMax = (function () {
    function MinMax(minElement, maxElement) {
        this.minElement = minElement;
        this.maxElement = maxElement;
    }
    return MinMax;
}());
exports.MinMax = MinMax;
var MinMaxNumber = (function (_super) {
    tslib_1.__extends(MinMaxNumber, _super);
    function MinMaxNumber() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(MinMaxNumber.prototype, "length", {
        get: function () {
            return this.maxElement - this.minElement;
        },
        enumerable: false,
        configurable: true
    });
    return MinMaxNumber;
}(MinMax));
exports.MinMaxNumber = MinMaxNumber;
var ExtendedMin = (function () {
    function ExtendedMin(minElement, minValue) {
        this.minElement = minElement;
        this.minValue = minValue;
    }
    return ExtendedMin;
}());
exports.ExtendedMin = ExtendedMin;
var ExtendedMax = (function () {
    function ExtendedMax(maxElement, maxValue) {
        this.maxElement = maxElement;
        this.maxValue = maxValue;
    }
    return ExtendedMax;
}());
exports.ExtendedMax = ExtendedMax;
var ExtendedMinMax = (function (_super) {
    tslib_1.__extends(ExtendedMinMax, _super);
    function ExtendedMinMax(minElement, minValue, maxElement, maxValue) {
        var _this = _super.call(this, minElement, maxElement) || this;
        _this.minValue = minValue;
        _this.maxValue = maxValue;
        return _this;
    }
    return ExtendedMinMax;
}(MinMax));
exports.ExtendedMinMax = ExtendedMinMax;


/***/ }),

/***/ 3210:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleStyleTextPropertyCommand = void 0;
var StylePropertyCommandBase_1 = __webpack_require__(7418);
var ChangeStyleTextHistoryItem_1 = __webpack_require__(5755);
var Style_1 = __webpack_require__(5059);
var ToggleStyleTextPropertyCommand = (function (_super) {
    __extends(ToggleStyleTextPropertyCommand, _super);
    function ToggleStyleTextPropertyCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleStyleTextPropertyCommand.prototype.getValue = function () {
        var value = this.control.selection.inputPosition.getCurrentTextStylePropertyValue(this.getStyleProperty());
        return value === this.getStylePropertyValue();
    };
    ToggleStyleTextPropertyCommand.prototype.executeCore = function (state) {
        var _this = this;
        this.control.history.beginTransaction();
        var styleProperty = this.getStyleProperty();
        var styleValue = state.value ? Style_1.TextStyle.defaultInstance[styleProperty] : this.getStylePropertyValue();
        var items = this.control.selection.getSelectedItems();
        items.forEach(function (item) {
            _this.control.history.addAndRedo(new ChangeStyleTextHistoryItem_1.ChangeStyleTextHistoryItem(item.key, styleProperty, styleValue));
        });
        this.control.selection.inputPosition.setTextStylePropertyValue(this.getStyleProperty(), styleValue);
        this.control.history.endTransaction();
        return true;
    };
    ToggleStyleTextPropertyCommand.prototype.getStyleObj = function (item) {
        return item.styleText;
    };
    ToggleStyleTextPropertyCommand.prototype.getDefaultStyleObj = function () {
        return new Style_1.TextStyle();
    };
    return ToggleStyleTextPropertyCommand;
}(StylePropertyCommandBase_1.StylePropertyCommandBase));
exports.ToggleStyleTextPropertyCommand = ToggleStyleTextPropertyCommand;


/***/ }),

/***/ 3233:
/***/ ((__unused_webpack_module, exports) => {


var _a, _b, _c;
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MimeTypeUtils = exports.DxMimeType = exports.ImageWebpMimeType = exports.ImageWbmpMimeType = exports.ImageIcoMimeType = exports.ImageTiffMimeType = exports.ImageSvgMimeType = exports.ImagePjpegMimeType = exports.ImageJpegMimeType = exports.ImageGifMimeType = exports.ImagePngMimeType = exports.DocmMimeType = exports.HtmlMimeType = exports.PlainTextMimeType = exports.RtfMimeType = exports.OpenXmlMimeType = void 0;
exports.OpenXmlMimeType = 'application/vnd.openxmlformats-officedocument.wordprocessingml.document';
exports.RtfMimeType = 'application/rtf';
exports.PlainTextMimeType = 'text/plain';
exports.HtmlMimeType = 'text/html';
exports.DocmMimeType = 'application/vnd.ms-word.document.macroEnabled.12';
exports.ImagePngMimeType = 'image/png';
exports.ImageGifMimeType = 'image/gif';
exports.ImageJpegMimeType = 'image/jpeg';
exports.ImagePjpegMimeType = 'image/pjpeg';
exports.ImageSvgMimeType = 'image/svg+xml';
exports.ImageTiffMimeType = 'image/tiff';
exports.ImageIcoMimeType = 'image/vnd.microsoft.icon';
exports.ImageWbmpMimeType = 'image/vnd.wap.wbmp';
exports.ImageWebpMimeType = 'image/webp';
var DxMimeType;
(function (DxMimeType) {
    DxMimeType[DxMimeType["Unknown"] = 0] = "Unknown";
    DxMimeType[DxMimeType["OpenXml"] = 1] = "OpenXml";
    DxMimeType[DxMimeType["Rtf"] = 2] = "Rtf";
    DxMimeType[DxMimeType["PlainText"] = 3] = "PlainText";
    DxMimeType[DxMimeType["Docm"] = 4] = "Docm";
    DxMimeType[DxMimeType["Png"] = 5] = "Png";
    DxMimeType[DxMimeType["Gif"] = 6] = "Gif";
    DxMimeType[DxMimeType["Jpeg"] = 7] = "Jpeg";
    DxMimeType[DxMimeType["Pjpeg"] = 8] = "Pjpeg";
    DxMimeType[DxMimeType["Svg"] = 9] = "Svg";
    DxMimeType[DxMimeType["Tiff"] = 10] = "Tiff";
    DxMimeType[DxMimeType["Ico"] = 11] = "Ico";
    DxMimeType[DxMimeType["Wbmp"] = 12] = "Wbmp";
    DxMimeType[DxMimeType["Webp"] = 13] = "Webp";
    DxMimeType[DxMimeType["Html"] = 14] = "Html";
})(DxMimeType = exports.DxMimeType || (exports.DxMimeType = {}));
var MimeTypeUtils = (function () {
    function MimeTypeUtils() {
    }
    MimeTypeUtils.stringTypeToExtension = function (mimeTypeAsStr) {
        var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
        return mimeType === undefined ? '' : MimeTypeUtils.typeToExtensionMap[mimeType];
    };
    MimeTypeUtils.typeToExtension = function (mimeType) {
        var ext = MimeTypeUtils.typeToExtensionMap[mimeType];
        return ext !== null && ext !== void 0 ? ext : '';
    };
    MimeTypeUtils.extensionToType = function (extension) {
        extension = extension.toLowerCase();
        if (extension[0] !== '.')
            extension += '.';
        var mimeType = MimeTypeUtils.extensionToTypeMap[extension];
        return mimeType !== null && mimeType !== void 0 ? mimeType : DxMimeType.Unknown;
    };
    MimeTypeUtils.typeToStringType = function (mimeType) {
        var str = MimeTypeUtils.typeToStringTypeMap[mimeType];
        return str !== null && str !== void 0 ? str : '';
    };
    MimeTypeUtils.stringTypeToType = function (mimeTypeAsStr) {
        var mimeType = MimeTypeUtils.stringTypeToTypeMap[mimeTypeAsStr];
        return mimeType === undefined ? DxMimeType.Unknown : mimeType;
    };
    MimeTypeUtils.stringTypeToTypeMap = (_a = {},
        _a[exports.OpenXmlMimeType] = DxMimeType.OpenXml,
        _a[exports.RtfMimeType] = DxMimeType.Rtf,
        _a[exports.PlainTextMimeType] = DxMimeType.PlainText,
        _a[exports.DocmMimeType] = DxMimeType.Docm,
        _a[exports.HtmlMimeType] = DxMimeType.Html,
        _a[exports.ImagePngMimeType] = DxMimeType.Png,
        _a[exports.ImageGifMimeType] = DxMimeType.Gif,
        _a[exports.ImageJpegMimeType] = DxMimeType.Jpeg,
        _a[exports.ImagePjpegMimeType] = DxMimeType.Pjpeg,
        _a[exports.ImageSvgMimeType] = DxMimeType.Svg,
        _a[exports.ImageTiffMimeType] = DxMimeType.Tiff,
        _a[exports.ImageIcoMimeType] = DxMimeType.Ico,
        _a[exports.ImageWbmpMimeType] = DxMimeType.Wbmp,
        _a[exports.ImageWebpMimeType] = DxMimeType.Webp,
        _a);
    MimeTypeUtils.typeToStringTypeMap = (_b = {},
        _b[DxMimeType.Unknown] = undefined,
        _b[DxMimeType.OpenXml] = exports.OpenXmlMimeType,
        _b[DxMimeType.Rtf] = exports.RtfMimeType,
        _b[DxMimeType.PlainText] = exports.PlainTextMimeType,
        _b[DxMimeType.Docm] = exports.DocmMimeType,
        _b[DxMimeType.Html] = exports.HtmlMimeType,
        _b[DxMimeType.Png] = exports.ImagePngMimeType,
        _b[DxMimeType.Gif] = exports.ImageGifMimeType,
        _b[DxMimeType.Jpeg] = exports.ImageJpegMimeType,
        _b[DxMimeType.Pjpeg] = exports.ImagePjpegMimeType,
        _b[DxMimeType.Svg] = exports.ImageSvgMimeType,
        _b[DxMimeType.Tiff] = exports.ImageTiffMimeType,
        _b[DxMimeType.Ico] = exports.ImageIcoMimeType,
        _b[DxMimeType.Wbmp] = exports.ImageWbmpMimeType,
        _b[DxMimeType.Webp] = exports.ImageWebpMimeType,
        _b);
    MimeTypeUtils.typeToExtensionMap = (_c = {},
        _c[DxMimeType.Unknown] = undefined,
        _c[DxMimeType.OpenXml] = '.docx',
        _c[DxMimeType.Rtf] = '.rtf',
        _c[DxMimeType.PlainText] = '.txt',
        _c[DxMimeType.Docm] = '.docm',
        _c[DxMimeType.Html] = '.html',
        _c[DxMimeType.Png] = '.png',
        _c[DxMimeType.Gif] = '.gif',
        _c[DxMimeType.Jpeg] = '.jpeg',
        _c[DxMimeType.Pjpeg] = '.pjpeg',
        _c[DxMimeType.Svg] = '.svg',
        _c[DxMimeType.Tiff] = '.tiff',
        _c[DxMimeType.Ico] = '.ico',
        _c[DxMimeType.Wbmp] = '.wbmp',
        _c[DxMimeType.Webp] = '.webp',
        _c);
    MimeTypeUtils.extensionToTypeMap = {
        '.docx': DxMimeType.OpenXml,
        '.rtf': DxMimeType.Rtf,
        '.txt': DxMimeType.PlainText,
        '.docm': DxMimeType.Docm,
        '.html': DxMimeType.Html,
        '.htm': DxMimeType.Html,
        '.png': DxMimeType.Png,
        '.gif': DxMimeType.Gif,
        '.jpeg': DxMimeType.Jpeg,
        '.pjpeg': DxMimeType.Pjpeg,
        '.svg': DxMimeType.Svg,
        '.tiff': DxMimeType.Tiff,
        '.ico': DxMimeType.Ico,
        '.wbmp': DxMimeType.Wbmp,
        '.webp': DxMimeType.Webp,
    };
    return MimeTypeUtils;
}());
exports.MimeTypeUtils = MimeTypeUtils;


/***/ }),

/***/ 3255:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ShapeType = exports.ShapeTypes = exports.ShapeCategories = void 0;
var ShapeCategories = (function () {
    function ShapeCategories() {
    }
    ShapeCategories.General = "general";
    ShapeCategories.Flowchart = "flowchart";
    ShapeCategories.OrgChart = "orgChart";
    ShapeCategories.Containers = "containers";
    ShapeCategories.Custom = "custom";
    return ShapeCategories;
}());
exports.ShapeCategories = ShapeCategories;
var ShapeTypes = (function () {
    function ShapeTypes() {
    }
    ShapeTypes.Text = "text";
    ShapeTypes.Rectangle = "rectangle";
    ShapeTypes.Ellipse = "ellipse";
    ShapeTypes.Cross = "cross";
    ShapeTypes.Triangle = "triangle";
    ShapeTypes.Diamond = "diamond";
    ShapeTypes.Heart = "heart";
    ShapeTypes.Pentagon = "pentagon";
    ShapeTypes.Hexagon = "hexagon";
    ShapeTypes.Octagon = "octagon";
    ShapeTypes.Star = "star";
    ShapeTypes.ArrowLeft = "arrowLeft";
    ShapeTypes.ArrowUp = "arrowTop";
    ShapeTypes.ArrowRight = "arrowRight";
    ShapeTypes.ArrowDown = "arrowBottom";
    ShapeTypes.ArrowUpDown = "arrowNorthSouth";
    ShapeTypes.ArrowLeftRight = "arrowEastWest";
    ShapeTypes.Process = "process";
    ShapeTypes.Decision = "decision";
    ShapeTypes.Terminator = "terminator";
    ShapeTypes.PredefinedProcess = "predefinedProcess";
    ShapeTypes.Document = "document";
    ShapeTypes.MultipleDocuments = "multipleDocuments";
    ShapeTypes.ManualInput = "manualInput";
    ShapeTypes.Preparation = "preparation";
    ShapeTypes.Data = "data";
    ShapeTypes.Database = "database";
    ShapeTypes.HardDisk = "hardDisk";
    ShapeTypes.InternalStorage = "internalStorage";
    ShapeTypes.PaperTape = "paperTape";
    ShapeTypes.ManualOperation = "manualOperation";
    ShapeTypes.Delay = "delay";
    ShapeTypes.StoredData = "storedData";
    ShapeTypes.Display = "display";
    ShapeTypes.Merge = "merge";
    ShapeTypes.Connector = "connector";
    ShapeTypes.Or = "or";
    ShapeTypes.SummingJunction = "summingJunction";
    ShapeTypes.Container = "container";
    ShapeTypes.VerticalContainer = "verticalContainer";
    ShapeTypes.HorizontalContainer = "horizontalContainer";
    ShapeTypes.Card = "card";
    ShapeTypes.CardWithImageOnLeft = "cardWithImageOnLeft";
    ShapeTypes.CardWithImageOnTop = "cardWithImageOnTop";
    ShapeTypes.CardWithImageOnRight = "cardWithImageOnRight";
    return ShapeTypes;
}());
exports.ShapeTypes = ShapeTypes;
var ShapeType;
(function (ShapeType) {
    ShapeType[ShapeType["text"] = 0] = "text";
    ShapeType[ShapeType["rectangle"] = 1] = "rectangle";
    ShapeType[ShapeType["ellipse"] = 2] = "ellipse";
    ShapeType[ShapeType["cross"] = 3] = "cross";
    ShapeType[ShapeType["triangle"] = 4] = "triangle";
    ShapeType[ShapeType["diamond"] = 5] = "diamond";
    ShapeType[ShapeType["heart"] = 6] = "heart";
    ShapeType[ShapeType["pentagon"] = 7] = "pentagon";
    ShapeType[ShapeType["hexagon"] = 8] = "hexagon";
    ShapeType[ShapeType["octagon"] = 9] = "octagon";
    ShapeType[ShapeType["star"] = 10] = "star";
    ShapeType[ShapeType["arrowLeft"] = 11] = "arrowLeft";
    ShapeType[ShapeType["arrowTop"] = 12] = "arrowTop";
    ShapeType[ShapeType["arrowRight"] = 13] = "arrowRight";
    ShapeType[ShapeType["arrowBottom"] = 14] = "arrowBottom";
    ShapeType[ShapeType["arrowNorthSouth"] = 15] = "arrowNorthSouth";
    ShapeType[ShapeType["arrowEastWest"] = 16] = "arrowEastWest";
    ShapeType[ShapeType["process"] = 17] = "process";
    ShapeType[ShapeType["decision"] = 18] = "decision";
    ShapeType[ShapeType["terminator"] = 19] = "terminator";
    ShapeType[ShapeType["predefinedProcess"] = 20] = "predefinedProcess";
    ShapeType[ShapeType["document"] = 21] = "document";
    ShapeType[ShapeType["multipleDocuments"] = 22] = "multipleDocuments";
    ShapeType[ShapeType["manualInput"] = 23] = "manualInput";
    ShapeType[ShapeType["preparation"] = 24] = "preparation";
    ShapeType[ShapeType["data"] = 25] = "data";
    ShapeType[ShapeType["database"] = 26] = "database";
    ShapeType[ShapeType["hardDisk"] = 27] = "hardDisk";
    ShapeType[ShapeType["internalStorage"] = 28] = "internalStorage";
    ShapeType[ShapeType["paperTape"] = 29] = "paperTape";
    ShapeType[ShapeType["manualOperation"] = 30] = "manualOperation";
    ShapeType[ShapeType["delay"] = 31] = "delay";
    ShapeType[ShapeType["storedData"] = 32] = "storedData";
    ShapeType[ShapeType["display"] = 33] = "display";
    ShapeType[ShapeType["merge"] = 34] = "merge";
    ShapeType[ShapeType["connector"] = 35] = "connector";
    ShapeType[ShapeType["or"] = 36] = "or";
    ShapeType[ShapeType["summingJunction"] = 37] = "summingJunction";
    ShapeType[ShapeType["verticalContainer"] = 38] = "verticalContainer";
    ShapeType[ShapeType["horizontalContainer"] = 39] = "horizontalContainer";
    ShapeType[ShapeType["cardWithImageOnLeft"] = 40] = "cardWithImageOnLeft";
    ShapeType[ShapeType["cardWithImageOnTop"] = 41] = "cardWithImageOnTop";
    ShapeType[ShapeType["cardWithImageOnRight"] = 42] = "cardWithImageOnRight";
})(ShapeType = exports.ShapeType || (exports.ShapeType = {}));


/***/ }),

/***/ 3262:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Equals = exports.Comparers = void 0;
var Comparers = (function () {
    function Comparers() {
    }
    Comparers.number = function (a, b) {
        return a - b;
    };
    Comparers.string = function (a, b) {
        return ((a === b) ? 0 : ((a > b) ? 1 : -1));
    };
    Comparers.stringIgnoreCase = function (a, b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        return ((a === b) ? 0 : ((a > b) ? 1 : -1));
    };
    return Comparers;
}());
exports.Comparers = Comparers;
var Equals = (function () {
    function Equals() {
    }
    Equals.simpleType = function (a, b) {
        return a === b;
    };
    Equals.object = function (a, b) {
        return a && b && (a === b || a.equals(b));
    };
    return Equals;
}());
exports.Equals = Equals;


/***/ }),

/***/ 3283:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CanvasPageManager = void 0;
var Style_1 = __webpack_require__(5059);
var RectaglePrimitive_1 = __webpack_require__(94);
var PathPrimitive_1 = __webpack_require__(6208);
var PatternPrimitive_1 = __webpack_require__(7301);
var ClipPathPrimitive_1 = __webpack_require__(5654);
var CanvasManagerBase_1 = __webpack_require__(5707);
var size_1 = __webpack_require__(3844);
var point_1 = __webpack_require__(5327);
var Utils_1 = __webpack_require__(2136);
var color_1 = __webpack_require__(9553);
var unit_converter_1 = __webpack_require__(9500);
var GRID_PAGES_LINEWIDTH = 2;
var CanvasPageManager = (function (_super) {
    __extends(CanvasPageManager, _super);
    function CanvasPageManager(parent, settings, dom, instanceId) {
        var _this = _super.call(this, settings.zoomLevel, dom, instanceId) || this;
        _this.snapPoint = new point_1.Point(0, 0);
        _this.gridPatternId = Utils_1.RenderUtils.generateSvgElementId("gridPattern");
        _this.pagesGridPatternId = Utils_1.RenderUtils.generateSvgElementId("pagesGridPattern");
        _this.pagesGridClipId = Utils_1.RenderUtils.generateSvgElementId("pagesGridClip");
        _this.pageColor = settings.pageColor;
        _this.modelSize = settings.modelSize;
        _this.simpleView = settings.simpleView;
        _this.gridSize = settings.gridSize;
        _this.gridVisible = settings.gridVisible;
        _this.pageSize = settings.pageLandscape ? new size_1.Size(settings.pageSize.height, settings.pageSize.width) : settings.pageSize;
        _this.canvasViewOffset = new point_1.Point(0, 0);
        _this.initContainers(parent);
        return _this;
    }
    CanvasPageManager.prototype.initContainers = function (parent) {
        this.backgroundContainer = parent;
    };
    CanvasPageManager.prototype.redraw = function () {
        this.redrawPage(this.pageColor);
        this.redrawGrid();
    };
    CanvasPageManager.prototype.redrawPage = function (color) {
        var style = new Style_1.Style();
        style["fill"] = color_1.ColorUtils.colorToHash(color);
        this.getOrCreateElement("page-bg", new RectaglePrimitive_1.RectanglePrimitive(0, 0, "100%", "100%", style, "page"), this.backgroundContainer);
        this.createTextFloodFilter(this.instanceId, "page-bg-textflood-filter", this.backgroundContainer, color);
    };
    CanvasPageManager.prototype.redrawGrid = function () {
        this.updateGridElements();
        this.updatePagesGridElements();
    };
    CanvasPageManager.prototype.getGridRectElement = function (primitive) {
        if (this.gridRectElement === undefined)
            this.gridRectElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridRectElement;
    };
    CanvasPageManager.prototype.getGridPatternElement = function (primitive) {
        if (this.gridPatternElement === undefined)
            this.gridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.gridPatternElement;
    };
    CanvasPageManager.prototype.updateGridElements = function () {
        var _this = this;
        var gridRectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "grid", null, function (element) {
            element.style.setProperty("fill", Utils_1.RenderUtils.getUrlPathById(_this.gridPatternId));
        });
        var rectEl = this.getGridRectElement(gridRectPrimitive);
        if (!this.gridVisible)
            rectEl.style.display = "none";
        else {
            rectEl.style.display = "";
            this.changePrimitiveElement(gridRectPrimitive, rectEl);
            var absGridSize_1 = unit_converter_1.UnitConverter.twipsToPixelsF(this.gridSize) * this.actualZoom;
            var sizes = [0, 1, 2, 3, 4].map(function (i) { return Math.round(absGridSize_1 * i); });
            var outerPathCommands = [
                new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[4].toString(), "0"),
                new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[4].toString()),
                new PathPrimitive_1.PathPrimitiveLineToCommand("0", sizes[4].toString())
            ];
            var innerPathCommands = [];
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand(sizes[i].toString(), "0"));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[i].toString(), sizes[4].toString()));
            }
            for (var i = 1; i <= 3; i++) {
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveMoveToCommand("0", sizes[i].toString()));
                innerPathCommands.push(new PathPrimitive_1.PathPrimitiveLineToCommand(sizes[4].toString(), sizes[i].toString()));
            }
            var commonSize = absGridSize_1 * 4;
            var canvasViewOffset = this.simpleView ? this.canvasViewOffset : point_1.Point.zero();
            var gridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.gridPatternId, [
                this.createGridPathPrimitive(outerPathCommands, "grid-outer-line"),
                this.createGridPathPrimitive(innerPathCommands, "grid-inner-line")
            ], this.createGridPatternPrimitivePosition(canvasViewOffset.x, this.snapPoint.x, commonSize), this.createGridPatternPrimitivePosition(canvasViewOffset.y, this.snapPoint.y, commonSize), commonSize.toString(), commonSize.toString());
            this.changePrimitiveElement(gridPatternPrimitive, this.getGridPatternElement(gridPatternPrimitive));
        }
    };
    CanvasPageManager.prototype.createGridPatternPrimitivePosition = function (offset, coord, commonSize) {
        return (((offset + coord * this.actualZoom) % commonSize - commonSize) % commonSize).toString();
    };
    CanvasPageManager.prototype.createGridPathPrimitive = function (commands, className) {
        return new PathPrimitive_1.PathPrimitive(commands, Style_1.StrokeStyle.default1pxNegativeOffsetInstance, className);
    };
    CanvasPageManager.prototype.getPagesGridRectElement = function (primitive) {
        return this.getOrCreateElement("grid-pages-rect", primitive, this.backgroundContainer);
    };
    CanvasPageManager.prototype.getPagesGridClipPathElement = function (primitive) {
        if (this.pagesGridClipPathElement === undefined)
            this.pagesGridClipPathElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridClipPathElement;
    };
    CanvasPageManager.prototype.getPagesGridPatternElement = function (primitive) {
        if (this.pagesGridPatternElement === undefined)
            this.pagesGridPatternElement = this.createPrimitiveElement(primitive, this.backgroundContainer);
        return this.pagesGridPatternElement;
    };
    CanvasPageManager.prototype.updatePagesGridElements = function () {
        var _this = this;
        var pageAbsSize = this.getAbsoluteSize(this.pageSize);
        var rectPrimitive = new RectaglePrimitive_1.RectanglePrimitive("0", "0", "100%", "100%", null, "grid-page", this.pagesGridClipId, function (element) {
            element.style.setProperty("fill", Utils_1.RenderUtils.getUrlPathById(_this.pagesGridPatternId));
            element.style.setProperty("display", _this.simpleView ? "none" : "");
        });
        this.getPagesGridRectElement(rectPrimitive);
        if (!this.simpleView) {
            var modelSize = this.modelSize.clone().multiply(this.actualZoom, this.actualZoom);
            var pageGridPathCommands = [
                new PathPrimitive_1.PathPrimitiveMoveToCommand((pageAbsSize.width - GRID_PAGES_LINEWIDTH / 2).toString(), "0"),
                new PathPrimitive_1.PathPrimitiveLineToCommand((pageAbsSize.width - GRID_PAGES_LINEWIDTH / 2).toString(), (pageAbsSize.height - GRID_PAGES_LINEWIDTH / 2).toString()),
                new PathPrimitive_1.PathPrimitiveLineToCommand("0", (pageAbsSize.height - GRID_PAGES_LINEWIDTH / 2).toString())
            ];
            var pagesGridPatternPrimitive = new PatternPrimitive_1.PatternPrimitive(this.pagesGridPatternId, [
                new PathPrimitive_1.PathPrimitive(pageGridPathCommands, null, "pages-grid-line")
            ], 0, 0, pageAbsSize.width.toString(), pageAbsSize.height.toString());
            this.changePrimitiveElement(pagesGridPatternPrimitive, this.getPagesGridPatternElement(pagesGridPatternPrimitive));
            var pagesGridClipPathPrimitive = new ClipPathPrimitive_1.ClipPathPrimitive(this.pagesGridClipId, [
                new RectaglePrimitive_1.RectanglePrimitive(0, 0, (unit_converter_1.UnitConverter.twipsToPixelsF(modelSize.width) - GRID_PAGES_LINEWIDTH * 2).toString(), (unit_converter_1.UnitConverter.twipsToPixelsF(modelSize.height) - GRID_PAGES_LINEWIDTH * 2).toString())
            ]);
            this.changePrimitiveElement(pagesGridClipPathPrimitive, this.getPagesGridClipPathElement(pagesGridClipPathPrimitive));
        }
    };
    CanvasPageManager.prototype.notifyModelSizeChanged = function (size, offset) {
        this.modelSize = size.clone();
        this.redraw();
    };
    CanvasPageManager.prototype.notifyModelRectangleChanged = function (rectangle) { };
    CanvasPageManager.prototype.notifySnapPointPositionChanged = function (point) {
        this.snapPoint = point.clone().applyConverter(unit_converter_1.UnitConverter.twipsToPixelsF);
        this.redrawGrid();
    };
    CanvasPageManager.prototype.notifyPageColorChanged = function (color) {
        this.pageColor = color;
        this.redrawPage(this.pageColor);
    };
    CanvasPageManager.prototype.notifyModelChanged = function (changes) { };
    CanvasPageManager.prototype.notifyPageSizeChanged = function (pageSize, pageLandscape) {
        this.pageSize = pageLandscape ? new size_1.Size(pageSize.height, pageSize.width) : pageSize.clone();
        this.redraw();
    };
    CanvasPageManager.prototype.notifyActualZoomChanged = function (actualZoom) {
        this.actualZoom = actualZoom;
        this.redraw();
    };
    CanvasPageManager.prototype.notifyViewAdjusted = function (canvasViewOffset) {
        if (!this.canvasViewOffset.equals(canvasViewOffset)) {
            this.canvasViewOffset = canvasViewOffset;
            if (this.simpleView)
                this.redraw();
        }
    };
    CanvasPageManager.prototype.notifyViewChanged = function (simpleView) {
        this.simpleView = simpleView;
        this.redraw();
    };
    CanvasPageManager.prototype.notifyGridChanged = function (showGrid, gridSize) {
        this.gridVisible = showGrid;
        this.gridSize = gridSize;
        this.redraw();
    };
    return CanvasPageManager;
}(CanvasManagerBase_1.CanvasManagerBase));
exports.CanvasPageManager = CanvasPageManager;


/***/ }),

/***/ 3312:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MoveShapeHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var MoveShapeHistoryItem = (function (_super) {
    __extends(MoveShapeHistoryItem, _super);
    function MoveShapeHistoryItem(shapeKey, position) {
        var _this = _super.call(this) || this;
        _this.shapeKey = shapeKey;
        _this.position = position;
        return _this;
    }
    MoveShapeHistoryItem.prototype.redo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        this.oldPosition = shape.position.clone();
        manipulator.moveShape(shape, this.position);
    };
    MoveShapeHistoryItem.prototype.undo = function (manipulator) {
        var shape = manipulator.model.findShape(this.shapeKey);
        manipulator.moveShape(shape, this.oldPosition);
    };
    return MoveShapeHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.MoveShapeHistoryItem = MoveShapeHistoryItem;


/***/ }),

/***/ 3377:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.VisualizerTouchManager = void 0;
var VisualizersManager_1 = __webpack_require__(9860);
var Event_1 = __webpack_require__(5428);
var SELECTION_CHANGED_EVENT = 1;
var VisualizerTouchManager = (function (_super) {
    __extends(VisualizerTouchManager, _super);
    function VisualizerTouchManager(selection, model, eventManager, settings, readOnly) {
        if (readOnly === void 0) { readOnly = settings.readOnly; }
        var _this = _super.call(this, selection, model, eventManager, settings, readOnly) || this;
        selection.onChanged.add(_this);
        return _this;
    }
    VisualizerTouchManager.prototype.onBlur = function (evt) {
        var _this = this;
        setTimeout(function () { _this.hideConnections(); }, 1);
    };
    VisualizerTouchManager.prototype.onFocus = function (evt) {
        var _this = this;
        setTimeout(function () { _this.showConnections(); }, 1);
    };
    VisualizerTouchManager.prototype.hideConnections = function () {
        if (this.readOnly)
            return;
        this.resetConnectionPoints();
    };
    VisualizerTouchManager.prototype.showConnections = function () {
        if (this.readOnly)
            return;
        if (this.needShowConnections()) {
            var shapes = this.selection.getSelectedShapes();
            if (shapes.length === 1)
                this.setConnectionPoints(shapes[0], Event_1.MouseEventElementType.ShapeConnectionPoint, -1, (!shapes[0].allowResizeHorizontally && !shapes[0].allowResizeVertically) || shapes[0].isLocked);
        }
    };
    VisualizerTouchManager.prototype.needShowConnections = function () {
        var items = this.selection.getSelectedItems();
        var shapes = this.selection.getSelectedShapes();
        return (items.length === 1 && shapes.length === 1);
    };
    VisualizerTouchManager.prototype.notifySelectionChanged = function (selection) {
        if (this.isUpdateLocked())
            this.registerOccurredEvent(SELECTION_CHANGED_EVENT);
        else
            this.raiseSelectionChanged();
    };
    VisualizerTouchManager.prototype.raiseSelectionChanged = function () {
        if (this.needShowConnections())
            this.showConnections();
        else
            this.hideConnections();
    };
    VisualizerTouchManager.prototype.onUpdateUnlocked = function (occurredEvents) {
        if (occurredEvents & SELECTION_CHANGED_EVENT)
            this.raiseSelectionChanged();
    };
    VisualizerTouchManager.prototype.notifyDragStart = function (itemKeys) {
        this.hideConnections();
    };
    VisualizerTouchManager.prototype.notifyDragEnd = function (itemKeys) {
        this.showConnections();
    };
    return VisualizerTouchManager;
}(VisualizersManager_1.VisualizerManager));
exports.VisualizerTouchManager = VisualizerTouchManager;


/***/ }),

/***/ 3393:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Flag = void 0;
var Flag = (function () {
    function Flag(initValue) {
        if (initValue === void 0) { initValue = 0; }
        this.value = initValue;
    }
    Flag.prototype.get = function (enumVal) {
        return (this.value & enumVal) === enumVal;
    };
    Flag.prototype.set = function (enumVal, newValue) {
        var currVal = (this.value & enumVal) === enumVal;
        if (currVal !== newValue) {
            if (newValue)
                this.value |= enumVal;
            else
                this.value ^= enumVal;
        }
        return this;
    };
    Flag.prototype.add = function (value) {
        this.value |= value;
    };
    Flag.prototype.anyOf = function () {
        var flags = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            flags[_i] = arguments[_i];
        }
        for (var _a = 0, flags_1 = flags; _a < flags_1.length; _a++) {
            var flag = flags_1[_a];
            if ((this.value & flag) === flag)
                return true;
        }
        return false;
    };
    Flag.prototype.getValue = function () {
        return this.value;
    };
    Flag.prototype.clone = function () {
        return new Flag(this.value);
    };
    return Flag;
}());
exports.Flag = Flag;


/***/ }),

/***/ 3415:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CrossShapeDescription = exports.CrossVerticalWidthParameterName = exports.CrossHorizontalWidthParameterName = void 0;
var ShapeDescription_1 = __webpack_require__(1280);
var point_1 = __webpack_require__(5327);
var ShapeParameters_1 = __webpack_require__(4636);
var ShapeParameterPoint_1 = __webpack_require__(9763);
var PathPrimitive_1 = __webpack_require__(6208);
var ShapeTypes_1 = __webpack_require__(3255);
exports.CrossHorizontalWidthParameterName = "chw";
exports.CrossVerticalWidthParameterName = "cvw";
var CrossShapeDescription = (function (_super) {
    __extends(CrossShapeDescription, _super);
    function CrossShapeDescription() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(CrossShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Cross; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CrossShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return true; },
        enumerable: false,
        configurable: true
    });
    CrossShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, width = rect.width, height = rect.height;
        var p0dx = (width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2;
        var p1dy = (height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, p1y2),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    CrossShapeDescription.prototype.createParameters = function (parameters) {
        parameters.addRangeIfNotExists([
            new ShapeParameters_1.ShapeParameter(exports.CrossHorizontalWidthParameterName, this.defaultSize.width * 0.2),
            new ShapeParameters_1.ShapeParameter(exports.CrossVerticalWidthParameterName, this.defaultSize.height * 0.2)
        ]);
    };
    CrossShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width, p.value)); });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    CrossShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, exports.CrossHorizontalWidthParameterName, function (p) { return p.value - deltaX * 2; });
        this.changeParameterValue(parameters, exports.CrossVerticalWidthParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    CrossShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new point_1.Point(shape.normalizeX(shape.position.x + (shape.size.width - shape.parameters.get(exports.CrossHorizontalWidthParameterName).value) / 2), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(exports.CrossVerticalWidthParameterName).value) / 2)))
        ];
    };
    CrossShapeDescription.prototype.getTextRectangle = function (shape) {
        return shape.rectangle.clone().inflate(-ShapeDescription_1.ShapeTextPadding, -ShapeDescription_1.ShapeTextPadding);
    };
    CrossShapeDescription.prototype.getSizeByText = function (textSize, _shape) {
        return textSize.clone().offset(ShapeDescription_1.ShapeTextPadding * 2, ShapeDescription_1.ShapeTextPadding * 2);
    };
    return CrossShapeDescription;
}(ShapeDescription_1.ShapeDescription));
exports.CrossShapeDescription = CrossShapeDescription;


/***/ }),

/***/ 3427:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ItemChange = exports.ItemChangeType = void 0;
var ItemChangeType;
(function (ItemChangeType) {
    ItemChangeType[ItemChangeType["Create"] = 0] = "Create";
    ItemChangeType[ItemChangeType["UpdateProperties"] = 1] = "UpdateProperties";
    ItemChangeType[ItemChangeType["UpdateStructure"] = 2] = "UpdateStructure";
    ItemChangeType[ItemChangeType["Update"] = 3] = "Update";
    ItemChangeType[ItemChangeType["Remove"] = 4] = "Remove";
    ItemChangeType[ItemChangeType["UpdateClassName"] = 5] = "UpdateClassName";
})(ItemChangeType = exports.ItemChangeType || (exports.ItemChangeType = {}));
var ItemChange = (function () {
    function ItemChange(item, type, isValid) {
        if (isValid === void 0) { isValid = true; }
        this.item = item;
        this.type = type;
        this.isValid = isValid;
    }
    Object.defineProperty(ItemChange.prototype, "key", {
        get: function () { return this.item.key; },
        enumerable: false,
        configurable: true
    });
    return ItemChange;
}());
exports.ItemChange = ItemChange;


/***/ }),

/***/ 3475:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ArrowLeftRightShapeDescription = void 0;
var PathPrimitive_1 = __webpack_require__(6208);
var ArrowHorizontalShapeDescription_1 = __webpack_require__(9090);
var ShapeParameterPoint_1 = __webpack_require__(9763);
var point_1 = __webpack_require__(5327);
var ShapeTypes_1 = __webpack_require__(3255);
var ArrowLeftRightShapeDescription = (function (_super) {
    __extends(ArrowLeftRightShapeDescription, _super);
    function ArrowLeftRightShapeDescription() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ArrowLeftRightShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.ArrowLeftRight; },
        enumerable: false,
        configurable: true
    });
    ArrowLeftRightShapeDescription.prototype.createShapePrimitives = function (shape) {
        var rect = shape.rectangle;
        var left = rect.x, top = rect.y, right = rect.right, bottom = rect.bottom, height = rect.height;
        var cy = rect.center.y;
        var p0dx = shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value;
        var p1dy = (height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2;
        var p0x1 = shape.normalizeX(left + p0dx);
        var p1y1 = shape.normalizeY(top + p1dy);
        var p0x2 = shape.normalizeX(right - p0dx);
        var p1y2 = shape.normalizeY(bottom - p1dy);
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(left, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y1),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, cy),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x2, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, p1y2),
                new PathPrimitive_1.PathPrimitiveLineToCommand(p0x1, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    ArrowLeftRightShapeDescription.prototype.normalizeParameters = function (shape, parameters) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return Math.max(0, Math.min(shape.size.width / 2 - 2 * shape.strokeWidth, p.value)); });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return Math.max(0, Math.min(shape.size.height, p.value)); });
    };
    ArrowLeftRightShapeDescription.prototype.modifyParameters = function (shape, parameters, deltaX, deltaY) {
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName, function (p) { return p.value + deltaX; });
        this.changeParameterValue(parameters, ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName, function (p) { return p.value - deltaY * 2; });
        this.normalizeParameters(shape, parameters);
    };
    ArrowLeftRightShapeDescription.prototype.getParameterPoints = function (shape) {
        return [
            new ShapeParameterPoint_1.ShapeParameterPoint("c", new point_1.Point(shape.normalizeX(shape.position.x + shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalTriangleWidthParameterName).value), shape.normalizeY(shape.position.y + (shape.size.height - shape.parameters.get(ArrowHorizontalShapeDescription_1.ArrowVerticalLineHeightParameterName).value) / 2)))
        ];
    };
    return ArrowLeftRightShapeDescription;
}(ArrowHorizontalShapeDescription_1.ArrowHorizontalShapeDescription));
exports.ArrowLeftRightShapeDescription = ArrowLeftRightShapeDescription;


/***/ }),

/***/ 3489:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataShapeDescription = void 0;
var RectangleShapeDescription_1 = __webpack_require__(3190);
var ShapeTypes_1 = __webpack_require__(3255);
var PathPrimitive_1 = __webpack_require__(6208);
var DiagramItem_1 = __webpack_require__(4824);
var ShapeDescription_1 = __webpack_require__(1280);
var DataShapeDescription = (function (_super) {
    __extends(DataShapeDescription, _super);
    function DataShapeDescription() {
        return _super.call(this, undefined, true) || this;
    }
    Object.defineProperty(DataShapeDescription.prototype, "key", {
        get: function () { return ShapeTypes_1.ShapeTypes.Data; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DataShapeDescription.prototype, "keepRatioOnAutoSize", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    DataShapeDescription.prototype.createShapePrimitives = function (shape) {
        var _a = shape.rectangle, left = _a.x, top = _a.y, right = _a.right, bottom = _a.bottom, width = _a.width, height = _a.height;
        var px = Math.min(Math.max(0, height / Math.tan(DataShapeDescription.slopeAngle)), width);
        var x1 = left + px;
        var x2 = right - px;
        return [
            new PathPrimitive_1.PathPrimitive([
                new PathPrimitive_1.PathPrimitiveMoveToCommand(x1, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(right, top),
                new PathPrimitive_1.PathPrimitiveLineToCommand(x2, bottom),
                new PathPrimitive_1.PathPrimitiveLineToCommand(left, bottom),
                new PathPrimitive_1.PathPrimitiveClosePathCommand()
            ], shape.style)
        ];
    };
    DataShapeDescription.prototype.processConnectionPoint = function (shape, point) {
        var offset = shape.size.height / Math.tan(DataShapeDescription.slopeAngle);
        var side = shape.getConnectionPointSide(point);
        if (side === DiagramItem_1.ConnectionPointSide.East)
            point.x -= offset / 2;
        else if (side === DiagramItem_1.ConnectionPointSide.West)
            point.x += offset / 2;
    };
    DataShapeDescription.prototype.getTextRectangle = function (shape) {
        var px = Math.min(Math.max(0, shape.size.height / Math.tan(DataShapeDescription.slopeAngle)), shape.size.width);
        return shape.rectangle.clone().moveRectangle(px, ShapeDescription_1.ShapeTextPadding).resize(-px * 2, -ShapeDescription_1.ShapeTextPadding * 2);
    };
    DataShapeDescription.slopeAngle = 81 * Math.PI / 180;
    return DataShapeDescription;
}(RectangleShapeDescription_1.RectangleShapeDescription));
exports.DataShapeDescription = DataShapeDescription;


/***/ }),

/***/ 3490:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.BeforeChangeShapeTextEventArgs = exports.BeforeChangeShapeTextRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var BeforeChangeShapeTextRequestedEntity = (function (_super) {
    __extends(BeforeChangeShapeTextRequestedEntity, _super);
    function BeforeChangeShapeTextRequestedEntity(apiController, shape) {
        var _this = _super.call(this, apiController) || this;
        _this.shape = shape;
        return _this;
    }
    Object.defineProperty(BeforeChangeShapeTextRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.BeforeChangeShapeText;
        },
        enumerable: false,
        configurable: true
    });
    BeforeChangeShapeTextRequestedEntity.prototype.createEventArgs = function () {
        return new BeforeChangeShapeTextEventArgs(this.apiController.createNativeShape(this.shape));
    };
    Object.defineProperty(BeforeChangeShapeTextRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "changeShapeText";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BeforeChangeShapeTextRequestedEntity.prototype, "storageKey", {
        get: function () {
            return "before" + this.settingsKey + "_" + (this.shape && this.shape.key);
        },
        enumerable: false,
        configurable: true
    });
    BeforeChangeShapeTextRequestedEntity.prototype.equals = function (other) {
        if (other instanceof BeforeChangeShapeTextRequestedEntity)
            return this.shape === other.shape && this.shape.text === other.shape.text;
        return false;
    };
    return BeforeChangeShapeTextRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.BeforeChangeShapeTextRequestedEntity = BeforeChangeShapeTextRequestedEntity;
var BeforeChangeShapeTextEventArgs = (function (_super) {
    __extends(BeforeChangeShapeTextEventArgs, _super);
    function BeforeChangeShapeTextEventArgs(shape) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        return _this;
    }
    return BeforeChangeShapeTextEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.BeforeChangeShapeTextEventArgs = BeforeChangeShapeTextEventArgs;


/***/ }),

/***/ 3505:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DeleteShapeEventArgs = exports.DeleteShapeRequestedEntity = void 0;
var ModelOperationSettings_1 = __webpack_require__(5225);
var RequestedEntity_1 = __webpack_require__(5102);
var DeleteShapeRequestedEntity = (function (_super) {
    __extends(DeleteShapeRequestedEntity, _super);
    function DeleteShapeRequestedEntity(apiController, shape) {
        var _this = _super.call(this, apiController) || this;
        _this.shape = shape;
        return _this;
    }
    Object.defineProperty(DeleteShapeRequestedEntity.prototype, "operation", {
        get: function () {
            return ModelOperationSettings_1.DiagramModelOperation.DeleteShape;
        },
        enumerable: false,
        configurable: true
    });
    DeleteShapeRequestedEntity.prototype.createEventArgs = function () {
        return new DeleteShapeEventArgs(this.apiController.createNativeShape(this.shape));
    };
    Object.defineProperty(DeleteShapeRequestedEntity.prototype, "settingsKey", {
        get: function () {
            return "deleteShape";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DeleteShapeRequestedEntity.prototype, "storageKey", {
        get: function () {
            return this.settingsKey + "_" + (this.shape && this.shape.key);
        },
        enumerable: false,
        configurable: true
    });
    DeleteShapeRequestedEntity.prototype.equals = function (other) {
        if (other instanceof DeleteShapeRequestedEntity)
            return this.shape === other.shape;
        return false;
    };
    return DeleteShapeRequestedEntity;
}(RequestedEntity_1.RequestedEntity));
exports.DeleteShapeRequestedEntity = DeleteShapeRequestedEntity;
var DeleteShapeEventArgs = (function (_super) {
    __extends(DeleteShapeEventArgs, _super);
    function DeleteShapeEventArgs(shape) {
        var _this = _super.call(this) || this;
        _this.shape = shape;
        return _this;
    }
    return DeleteShapeEventArgs;
}(RequestedEntity_1.PermissionRequestEventArgs));
exports.DeleteShapeEventArgs = DeleteShapeEventArgs;


/***/ }),

/***/ 3550:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeStyleHistoryItem = void 0;
var ChangeStyleHistoryItemBase_1 = __webpack_require__(8371);
var ChangeStyleHistoryItem = (function (_super) {
    __extends(ChangeStyleHistoryItem, _super);
    function ChangeStyleHistoryItem(itemKey, styleProperty, styleValue) {
        return _super.call(this, itemKey, styleProperty, styleValue) || this;
    }
    ChangeStyleHistoryItem.prototype.redo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        this.oldStyleValue = item.style[this.styleProperty];
        manipulator.changeStyle(item, this.styleProperty, this.styleValue);
    };
    ChangeStyleHistoryItem.prototype.undo = function (manipulator) {
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.changeStyle(item, this.styleProperty, this.oldStyleValue);
    };
    return ChangeStyleHistoryItem;
}(ChangeStyleHistoryItemBase_1.ChangeStyleHistoryItemBase));
exports.ChangeStyleHistoryItem = ChangeStyleHistoryItem;


/***/ }),

/***/ 3577:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.LockCommand = void 0;
var ChangeLockedCommand_1 = __webpack_require__(9314);
var LockCommand = (function (_super) {
    __extends(LockCommand, _super);
    function LockCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LockCommand.prototype.getLockState = function () {
        return true;
    };
    return LockCommand;
}(ChangeLockedCommand_1.ChangeLockedCommand));
exports.LockCommand = LockCommand;


/***/ }),

/***/ 3589:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredHorizontalRightToLeftCommand = void 0;
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutLayeredHorizontalCommand_1 = __webpack_require__(4214);
var AutoLayoutLayeredHorizontalRightToLeftCommand = (function (_super) {
    __extends(AutoLayoutLayeredHorizontalRightToLeftCommand, _super);
    function AutoLayoutLayeredHorizontalRightToLeftCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredHorizontalRightToLeftCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutLayeredHorizontalRightToLeftCommand;
}(AutoLayoutLayeredHorizontalCommand_1.AutoLayoutLayeredHorizontalCommand));
exports.AutoLayoutLayeredHorizontalRightToLeftCommand = AutoLayoutLayeredHorizontalRightToLeftCommand;


/***/ }),

/***/ 3591:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.UnbindDocumentCommand = void 0;
var ModelUtils_1 = __webpack_require__(1922);
var SimpleCommandBase_1 = __webpack_require__(3913);
var UnbindDocumentCommand = (function (_super) {
    __extends(UnbindDocumentCommand, _super);
    function UnbindDocumentCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    UnbindDocumentCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    UnbindDocumentCommand.prototype.executeCore = function (state) {
        this.permissionsProvider.lockPermissions();
        this.control.deleteDocumentDataSource();
        ModelUtils_1.ModelUtils.deleteAllItems(this.control.history, this.control.model, this.control.selection);
        this.control.history.clear();
        this.permissionsProvider.unlockPermissions();
        return true;
    };
    return UnbindDocumentCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.UnbindDocumentCommand = UnbindDocumentCommand;


/***/ }),

/***/ 3659:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ViewController = void 0;
var CommandManager_1 = __webpack_require__(5031);
var LOG_MIN_ZOOM = Math.log(0.05);
var LOG_MAX_ZOOM = Math.log(3);
var ZOOM_STEPS = 40;
var ZERO_STEP = getStepByZoom(1);
var ZOOMLEVEL_COMMANDS = [CommandManager_1.DiagramCommand.ZoomLevel, CommandManager_1.DiagramCommand.ZoomLevelInPercentage, CommandManager_1.DiagramCommand.Zoom100, CommandManager_1.DiagramCommand.Zoom125, CommandManager_1.DiagramCommand.Zoom200, CommandManager_1.DiagramCommand.Zoom25, CommandManager_1.DiagramCommand.Zoom50, CommandManager_1.DiagramCommand.Zoom75];
var AUTOZOOM_COMMANDS = [CommandManager_1.DiagramCommand.SwitchAutoZoom, CommandManager_1.DiagramCommand.ToggleAutoZoom, CommandManager_1.DiagramCommand.AutoZoomToContent, CommandManager_1.DiagramCommand.AutoZoomToWidth];
var ViewController = (function () {
    function ViewController(settings, bars) {
        this.settings = settings;
        this.bars = bars;
        settings.onZoomChanged.add(this);
        this.autoZoom = settings.autoZoom;
    }
    ViewController.prototype.initialize = function (view) {
        this.view = view;
        this.view.onViewChanged.add(this);
    };
    ViewController.prototype.scrollTo = function (modelPoint, offsetPoint) {
        if (this.view)
            this.view.setScrollTo(modelPoint, offsetPoint);
    };
    ViewController.prototype.scrollBy = function (offset) {
        if (this.view && (offset.x !== 0 || offset.y !== 0))
            return this.view.scrollBy(offset);
        return offset;
    };
    ViewController.prototype.scrollIntoView = function (rectangle) {
        this.view && this.view.scrollIntoView(rectangle);
    };
    ViewController.prototype.normalize = function () {
        this.view.tryNormalizePaddings();
    };
    ViewController.prototype.getNextStepZoom = function (increase) {
        var currentZoomStep = this.getNearestCurrentZoomStep();
        var delta = increase ? 1 : -1;
        var step = Math.min(ZOOM_STEPS - 1, Math.max(0, currentZoomStep + delta));
        if (step !== ZERO_STEP) {
            var logZoom = LOG_MIN_ZOOM + (LOG_MAX_ZOOM - LOG_MIN_ZOOM) * step / (ZOOM_STEPS - 1);
            return Math.exp(logZoom);
        }
        return 1;
    };
    ViewController.prototype.getNearestCurrentZoomStep = function () {
        var zoom = this.getZoom();
        return getStepByZoom(zoom);
    };
    ViewController.prototype.getZoom = function () {
        return this.view ? this.view.actualZoom : this.settings.zoomLevel;
    };
    ViewController.prototype.resetScroll = function () {
        this.view.adjust({ horizontal: true, vertical: true });
    };
    ViewController.prototype.notifyViewAdjusted = function (canvasOffset) { };
    ViewController.prototype.notifyActualZoomChanged = function (actualZoom) {
        this.bars.updateItemsState(ZOOMLEVEL_COMMANDS);
    };
    ViewController.prototype.notifyZoomChanged = function (fixedZoomLevel, autoZoom) {
        if (this.autoZoom !== autoZoom) {
            this.autoZoom = autoZoom;
            this.bars.updateItemsState(AUTOZOOM_COMMANDS);
        }
    };
    return ViewController;
}());
exports.ViewController = ViewController;
function getStepByZoom(zoom) {
    var logZoom = Math.log(zoom);
    return Math.round((logZoom - LOG_MIN_ZOOM) * (ZOOM_STEPS - 1) / (LOG_MAX_ZOOM - LOG_MIN_ZOOM));
}


/***/ }),

/***/ 3763:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RoundedRectanglePrimitive = void 0;
var RenderHelper_1 = __webpack_require__(8509);
var RectaglePrimitive_1 = __webpack_require__(94);
var RoundedRectanglePrimitive = (function (_super) {
    __extends(RoundedRectanglePrimitive, _super);
    function RoundedRectanglePrimitive(x, y, width, height, rx, ry, style, className, clipPathId, onApplyProperties) {
        if (rx === void 0) { rx = 0; }
        if (ry === void 0) { ry = 0; }
        var _this = _super.call(this, x, y, width, height, style, className, clipPathId, onApplyProperties) || this;
        _this.x = x;
        _this.y = y;
        _this.width = width;
        _this.height = height;
        _this.rx = rx;
        _this.ry = ry;
        return _this;
    }
    RoundedRectanglePrimitive.prototype.createMainElement = function () {
        return document.createElementNS(RenderHelper_1.svgNS, "rect");
    };
    RoundedRectanglePrimitive.prototype.applyElementProperties = function (element, measurer) {
        this.setUnitAttribute(element, "rx", this.rx);
        this.setUnitAttribute(element, "ry", this.ry);
        _super.prototype.applyElementProperties.call(this, element, measurer);
    };
    return RoundedRectanglePrimitive;
}(RectaglePrimitive_1.RectanglePrimitive));
exports.RoundedRectanglePrimitive = RoundedRectanglePrimitive;


/***/ }),

/***/ 3788:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ExtensionLinesVisualizer = exports.ExtensionLine = exports.ExtensionLineType = void 0;
var ExtensionLineType;
(function (ExtensionLineType) {
    ExtensionLineType[ExtensionLineType["LeftToLeftAbove"] = 0] = "LeftToLeftAbove";
    ExtensionLineType[ExtensionLineType["LeftToLeftBelow"] = 1] = "LeftToLeftBelow";
    ExtensionLineType[ExtensionLineType["RightToRightAbove"] = 2] = "RightToRightAbove";
    ExtensionLineType[ExtensionLineType["RightToRightBelow"] = 3] = "RightToRightBelow";
    ExtensionLineType[ExtensionLineType["LeftToRightAbove"] = 4] = "LeftToRightAbove";
    ExtensionLineType[ExtensionLineType["LeftToRightBelow"] = 5] = "LeftToRightBelow";
    ExtensionLineType[ExtensionLineType["RightToLeftAbove"] = 6] = "RightToLeftAbove";
    ExtensionLineType[ExtensionLineType["RightToLeftBelow"] = 7] = "RightToLeftBelow";
    ExtensionLineType[ExtensionLineType["TopToTopBefore"] = 8] = "TopToTopBefore";
    ExtensionLineType[ExtensionLineType["TopToTopAfter"] = 9] = "TopToTopAfter";
    ExtensionLineType[ExtensionLineType["BottomToBottomBefore"] = 10] = "BottomToBottomBefore";
    ExtensionLineType[ExtensionLineType["BottomToBottomAfter"] = 11] = "BottomToBottomAfter";
    ExtensionLineType[ExtensionLineType["TopToBottomBefore"] = 12] = "TopToBottomBefore";
    ExtensionLineType[ExtensionLineType["TopToBottomAfter"] = 13] = "TopToBottomAfter";
    ExtensionLineType[ExtensionLineType["BottomToTopBefore"] = 14] = "BottomToTopBefore";
    ExtensionLineType[ExtensionLineType["BottomToTopAfter"] = 15] = "BottomToTopAfter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterAbove"] = 16] = "HorizontalCenterAbove";
    ExtensionLineType[ExtensionLineType["HorizontalCenterBelow"] = 17] = "HorizontalCenterBelow";
    ExtensionLineType[ExtensionLineType["VerticalCenterBefore"] = 18] = "VerticalCenterBefore";
    ExtensionLineType[ExtensionLineType["VerticalCenterAfter"] = 19] = "VerticalCenterAfter";
    ExtensionLineType[ExtensionLineType["VerticalCenterToPageCenter"] = 20] = "VerticalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["HorizontalCenterToPageCenter"] = 21] = "HorizontalCenterToPageCenter";
    ExtensionLineType[ExtensionLineType["LeftToPageCenter"] = 22] = "LeftToPageCenter";
    ExtensionLineType[ExtensionLineType["RightToPageCenter"] = 23] = "RightToPageCenter";
    ExtensionLineType[ExtensionLineType["TopToPageCenter"] = 24] = "TopToPageCenter";
    ExtensionLineType[ExtensionLineType["BottomToPageCenter"] = 25] = "BottomToPageCenter";
})(ExtensionLineType = exports.ExtensionLineType || (exports.ExtensionLineType = {}));
var ExtensionLine = (function () {
    function ExtensionLine(type, segment, text) {
        this.type = type;
        this.segment = segment;
        this.text = text;
    }
    return ExtensionLine;
}());
exports.ExtensionLine = ExtensionLine;
var ExtensionLinesVisualizer = (function () {
    function ExtensionLinesVisualizer(dispatcher) {
        this.dispatcher = dispatcher;
        this.lines = [];
        this.lineIndexByType = {};
    }
    ExtensionLinesVisualizer.prototype.addSegment = function (type, segment, text) {
        var curIndex = this.lineIndexByType[type];
        if (curIndex === undefined) {
            var line = new ExtensionLine(type, segment, text);
            var index = this.lines.push(line);
            this.lineIndexByType[line.type] = index - 1;
            this.raiseShow();
        }
        else if (segment.length < this.lines[curIndex].segment.length) {
            var line = new ExtensionLine(type, segment, text);
            this.lines.splice(curIndex, 1, line);
            this.raiseShow();
        }
    };
    ExtensionLinesVisualizer.prototype.update = function () {
        this.raiseShow();
    };
    ExtensionLinesVisualizer.prototype.reset = function () {
        if (this.lines.length) {
            this.lines = [];
            this.lineIndexByType = {};
            this.raiseHide();
        }
    };
    ExtensionLinesVisualizer.prototype.raiseShow = function () {
        var _this = this;
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesShow(_this.lines); });
    };
    ExtensionLinesVisualizer.prototype.raiseHide = function () {
        this.dispatcher.raise1(function (l) { return l.notifyExtensionLinesHide(); });
    };
    return ExtensionLinesVisualizer;
}());
exports.ExtensionLinesVisualizer = ExtensionLinesVisualizer;


/***/ }),

/***/ 3831:
/***/ (function(__unused_webpack_module, exports) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.DataSourceEdgeDataImporter = exports.DataSourceNodeDataImporter = exports.DataSourceItemDataImporter = void 0;
var DataSourceItemDataImporter = (function () {
    function DataSourceItemDataImporter() {
        this.getKey = function (obj) { return obj["id"]; };
        this.setKey = function (obj, value) { obj["id"] = value; };
        this.getCustomData = undefined;
        this.setCustomData = undefined;
        this.getLocked = undefined;
        this.setLocked = undefined;
        this.getStyle = undefined;
        this.setStyle = undefined;
        this.getStyleText = undefined;
        this.setStyleText = undefined;
        this.getZIndex = undefined;
        this.setZIndex = undefined;
    }
    return DataSourceItemDataImporter;
}());
exports.DataSourceItemDataImporter = DataSourceItemDataImporter;
var DataSourceNodeDataImporter = (function (_super) {
    __extends(DataSourceNodeDataImporter, _super);
    function DataSourceNodeDataImporter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.getType = undefined;
        _this.setType = undefined;
        _this.getText = undefined;
        _this.setText = undefined;
        _this.getImage = undefined;
        _this.setImage = undefined;
        _this.getLeft = undefined;
        _this.setLeft = undefined;
        _this.getTop = undefined;
        _this.setTop = undefined;
        _this.getWidth = undefined;
        _this.setWidth = undefined;
        _this.getHeight = undefined;
        _this.setHeight = undefined;
        _this.getChildren = undefined;
        _this.setChildren = undefined;
        _this.getParentKey = undefined;
        _this.setParentKey = undefined;
        _this.getItems = undefined;
        _this.setItems = undefined;
        _this.getContainerKey = undefined;
        _this.setContainerKey = undefined;
        return _this;
    }
    return DataSourceNodeDataImporter;
}(DataSourceItemDataImporter));
exports.DataSourceNodeDataImporter = DataSourceNodeDataImporter;
var DataSourceEdgeDataImporter = (function (_super) {
    __extends(DataSourceEdgeDataImporter, _super);
    function DataSourceEdgeDataImporter() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.getFrom = function (obj) { return obj["from"]; };
        _this.setFrom = function (obj, value) { obj["from"] = value; };
        _this.getFromPointIndex = undefined;
        _this.setFromPointIndex = undefined;
        _this.getTo = function (obj) { return obj["to"]; };
        _this.setTo = function (obj, value) { obj["to"] = value; };
        _this.getToPointIndex = undefined;
        _this.setToPointIndex = undefined;
        _this.getPoints = undefined;
        _this.setPoints = undefined;
        _this.getText = undefined;
        _this.setText = undefined;
        _this.getLineOption = undefined;
        _this.setLineOption = undefined;
        _this.getStartLineEnding = undefined;
        _this.setStartLineEnding = undefined;
        _this.getEndLineEnding = undefined;
        _this.setEndLineEnding = undefined;
        return _this;
    }
    return DataSourceEdgeDataImporter;
}(DataSourceItemDataImporter));
exports.DataSourceEdgeDataImporter = DataSourceEdgeDataImporter;


/***/ }),

/***/ 3844:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Size = void 0;
var Size = (function () {
    function Size(width, height) {
        this.width = width;
        this.height = height;
    }
    Size.empty = function () {
        return new Size(0, 0);
    };
    Size.fromNumber = function (num) {
        return new Size(num, num);
    };
    Size.initByCommonAction = function (action) {
        var widthAdp = function (s) { return s.width; };
        var heightAdp = function (s) { return s.height; };
        return new Size(action(widthAdp, heightAdp), action(heightAdp, widthAdp));
    };
    Size.prototype.isEmpty = function () {
        return this.width === 0 && this.height === 0;
    };
    Size.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Size.prototype.nonNegativeSize = function () {
        if (this.width < 0)
            this.width = 0;
        if (this.height < 0)
            this.height = 0;
        return this;
    };
    Size.prototype.offset = function (offsetWidth, offsetHeight) {
        this.width = this.width + offsetWidth;
        this.height = this.height + offsetHeight;
        return this;
    };
    Size.prototype.multiply = function (multiplierW, multiplierH) {
        this.width *= multiplierW;
        this.height *= multiplierH;
        return this;
    };
    Size.prototype.equals = function (obj) {
        return this.width === obj.width && this.height === obj.height;
    };
    Size.prototype.clone = function () {
        return new Size(this.width, this.height);
    };
    Size.prototype.copyFrom = function (obj) {
        this.width = obj.width;
        this.height = obj.height;
    };
    Size.prototype.applyConverter = function (conv) {
        this.width = conv(this.width);
        this.height = conv(this.height);
        return this;
    };
    Size.equals = function (a, b) {
        return a.width === b.width && a.height === b.height;
    };
    return Size;
}());
exports.Size = Size;


/***/ }),

/***/ 3858:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RTree = void 0;
var rectangle_1 = __webpack_require__(4412);
var RTree = (function () {
    function RTree(maxWidth) {
        if (maxWidth === void 0) { maxWidth = 6; }
        this.maxWidth = maxWidth;
        this.minWidth = Math.floor(maxWidth / 2);
        this.root = new RTreeNodeBranch(new rectangle_1.Rectangle(0, 0, 0, 0), []);
    }
    RTree.prototype.search = function (point) {
        var result = [];
        if (!this.root.rect.containsPoint(point))
            return result;
        var hitsStack = [];
        hitsStack.push(this.root.nodes);
        while (hitsStack.length) {
            var nodes = hitsStack.pop();
            for (var i = nodes.length - 1, node = void 0; node = nodes[i]; i--)
                if (node.rect.containsPoint(point))
                    if (isBranch(node))
                        hitsStack.push(node.nodes);
                    else
                        result.push(node.obj);
        }
        return result;
    };
    RTree.prototype.insert = function (rect, obj) {
        var newLeaf = new RTreeNodeLeaf(rect.clone(), obj);
        if (!this.root.nodes.length) {
            this.root.rect = rect.clone();
            this.root.nodes.push(newLeaf);
            return;
        }
        var treeStack = this.chooseLeafSubtree(newLeaf);
        var retObj = newLeaf;
        var current;
        var previous;
        while (treeStack.length) {
            if (current && isBranch(current) && !current.nodes.length) {
                previous = current;
                current = treeStack.pop();
                for (var i = 0, node = void 0; node = current.nodes[i]; i++) {
                    if (isBranch(node) && (node === previous || !node.nodes.length)) {
                        node.nodes.splice(i, 1);
                        break;
                    }
                }
            }
            else
                current = treeStack.pop();
            if (retObj instanceof RTreeNode || Array.isArray(retObj)) {
                if (Array.isArray(retObj)) {
                    for (var i = 0, retObjChild = void 0; retObjChild = retObj[i]; i++) {
                        expandRect(current.rect, retObjChild.rect);
                    }
                    current.nodes = current.nodes.concat(retObj);
                }
                else {
                    expandRect(current.rect, retObj.rect);
                    current.nodes.push(retObj);
                }
                if (current.nodes.length <= this.maxWidth) {
                    retObj = current.rect.clone();
                }
                else {
                    var a = this.linearSplit(current.nodes);
                    retObj = a;
                    if (!treeStack.length) {
                        current.nodes.push(a[0]);
                        treeStack.push(current);
                        retObj = a[1];
                    }
                }
            }
            else {
                expandRect(current.rect, retObj);
                retObj = current.rect.clone();
            }
        }
    };
    RTree.prototype.chooseLeafSubtree = function (newLeaf) {
        var result = [];
        var bestChoiceIndex = -1;
        var bestChoiceArea;
        var first = true;
        result.push(this.root);
        var nodes = this.root.nodes;
        while (first || bestChoiceIndex !== -1) {
            if (first)
                first = false;
            else {
                result.push(nodes[bestChoiceIndex]);
                nodes = nodes[bestChoiceIndex].nodes;
                bestChoiceIndex = -1;
            }
            for (var i = nodes.length - 1, ltree = void 0; ltree = nodes[i]; i--) {
                if (!isBranch(ltree)) {
                    bestChoiceIndex = -1;
                    break;
                }
                var oldLRatio = squarifiedRatio(ltree.rect.width, ltree.rect.height, ltree.nodes.length + 1);
                var nw = Math.max(ltree.rect.x + ltree.rect.width, newLeaf.rect.x + newLeaf.rect.width) - Math.min(ltree.rect.x, newLeaf.rect.x);
                var nh = Math.max(ltree.rect.y + ltree.rect.height, newLeaf.rect.y + newLeaf.rect.height) - Math.min(ltree.rect.y, newLeaf.rect.y);
                var lratio = squarifiedRatio(nw, nh, ltree.nodes.length + 2);
                if (bestChoiceIndex < 0 || Math.abs(lratio - oldLRatio) < bestChoiceArea) {
                    bestChoiceArea = Math.abs(lratio - oldLRatio);
                    bestChoiceIndex = i;
                }
            }
        }
        return result;
    };
    RTree.prototype.linearSplit = function (nodes) {
        var n = this.pickLinear(nodes);
        while (nodes.length > 0) {
            this.pickNext(nodes, n[0], n[1]);
        }
        return n;
    };
    RTree.prototype.pickLinear = function (nodes) {
        var lowestHighX = nodes.length - 1;
        var highestLowX = 0;
        var lowestHighY = nodes.length - 1;
        var highestLowY = 0;
        var t1;
        var t2;
        for (var i = nodes.length - 2, l = void 0; l = nodes[i]; i--) {
            if (l.rect.x > nodes[highestLowX].rect.x)
                highestLowX = i;
            else if (l.rect.right < nodes[lowestHighX].rect.right)
                lowestHighX = i;
            if (l.rect.y > nodes[highestLowY].rect.y)
                highestLowY = i;
            else if (l.rect.bottom < nodes[lowestHighY].rect.bottom)
                lowestHighY = i;
        }
        var dx = Math.abs((nodes[lowestHighX].rect.right) - nodes[highestLowX].rect.x);
        var dy = Math.abs((nodes[lowestHighY].rect.bottom) - nodes[highestLowY].rect.y);
        if (dx > dy) {
            if (lowestHighX > highestLowX) {
                t1 = nodes.splice(lowestHighX, 1)[0];
                t2 = nodes.splice(highestLowX, 1)[0];
            }
            else {
                t2 = nodes.splice(highestLowX, 1)[0];
                t1 = nodes.splice(lowestHighX, 1)[0];
            }
        }
        else {
            if (lowestHighY > highestLowY) {
                t1 = nodes.splice(lowestHighY, 1)[0];
                t2 = nodes.splice(highestLowY, 1)[0];
            }
            else {
                t2 = nodes.splice(highestLowY, 1)[0];
                t1 = nodes.splice(lowestHighY, 1)[0];
            }
        }
        return [
            new RTreeNodeBranch(t1.rect.clone(), [t1]),
            new RTreeNodeBranch(t2.rect.clone(), [t2])
        ];
    };
    RTree.prototype.pickNext = function (nodes, a, b) {
        var areaA = squarifiedRatio(a.rect.width, a.rect.height, a.nodes.length + 1);
        var areaB = squarifiedRatio(b.rect.width, b.rect.height, b.nodes.length + 1);
        var highAreaDelta;
        var highAreaNode;
        var lowestGrowthGroup;
        for (var i = nodes.length - 1, l = void 0; l = nodes[i]; i--) {
            var newAreaA = new rectangle_1.Rectangle(Math.min(a.rect.x, l.rect.x), Math.min(a.rect.y, l.rect.y), 0, 0);
            newAreaA.width = Math.max(a.rect.right, l.rect.right) - newAreaA.x;
            newAreaA.height = Math.max(a.rect.bottom, l.rect.bottom) - newAreaA.y;
            var changeNewAreaA = Math.abs(squarifiedRatio(newAreaA.width, newAreaA.height, a.nodes.length + 2) - areaA);
            var newAreaB = new rectangle_1.Rectangle(Math.min(b.rect.x, l.rect.x), Math.min(b.rect.y, l.rect.y), 0, 0);
            newAreaB.width = Math.max(b.rect.right, l.rect.right) - newAreaB.x;
            newAreaB.height = Math.max(b.rect.bottom, l.rect.bottom) - newAreaB.y;
            var changeNewAreaB = Math.abs(squarifiedRatio(newAreaB.width, newAreaB.height, b.nodes.length + 2) - areaB);
            if (!highAreaNode || !highAreaDelta || Math.abs(changeNewAreaB - changeNewAreaA) < highAreaDelta) {
                highAreaNode = i;
                highAreaDelta = Math.abs(changeNewAreaB - changeNewAreaA);
                lowestGrowthGroup = changeNewAreaB < changeNewAreaA ? b : a;
            }
        }
        var tmp = nodes.splice(highAreaNode, 1)[0];
        if (a.nodes.length + nodes.length + 1 <= this.minWidth) {
            a.nodes.push(tmp);
            expandRect(a.rect, tmp.rect);
        }
        else if (b.nodes.length + nodes.length + 1 <= this.minWidth) {
            b.nodes.push(tmp);
            expandRect(b.rect, tmp.rect);
        }
        else {
            lowestGrowthGroup.nodes.push(tmp);
            expandRect(lowestGrowthGroup.rect, tmp.rect);
        }
    };
    return RTree;
}());
exports.RTree = RTree;
var RTreeNode = (function () {
    function RTreeNode(rect) {
        this.rect = rect;
    }
    return RTreeNode;
}());
var RTreeNodeLeaf = (function (_super) {
    __extends(RTreeNodeLeaf, _super);
    function RTreeNodeLeaf(rect, obj) {
        var _this = _super.call(this, rect) || this;
        _this.obj = obj;
        return _this;
    }
    return RTreeNodeLeaf;
}(RTreeNode));
var RTreeNodeBranch = (function (_super) {
    __extends(RTreeNodeBranch, _super);
    function RTreeNodeBranch(rect, nodes) {
        var _this = _super.call(this, rect) || this;
        _this.nodes = nodes;
        return _this;
    }
    return RTreeNodeBranch;
}(RTreeNode));
function isBranch(node) {
    return "nodes" in node;
}
function squarifiedRatio(width, height, fill) {
    var lperi = (width + height) / 2;
    var larea = width * height;
    var lgeo = larea / (lperi * lperi);
    return larea * fill / lgeo;
}
function expandRect(rect, other) {
    var rx = Math.max(rect.right, other.right);
    var ry = Math.max(rect.bottom, other.bottom);
    rect.x = Math.min(rect.x, other.x);
    rect.y = Math.min(rect.y, other.y);
    rect.width = rx - rect.x;
    rect.height = ry - rect.y;
}


/***/ }),

/***/ 3894:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerMoveConnectorPointState = void 0;
var point_1 = __webpack_require__(5327);
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(8619);
var Connector_1 = __webpack_require__(6320);
var ModelUtils_1 = __webpack_require__(1922);
var ConnectorProperties_1 = __webpack_require__(4385);
var MouseHandlerMoveConnectorPointState = (function (_super) {
    __extends(MouseHandlerMoveConnectorPointState, _super);
    function MouseHandlerMoveConnectorPointState() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    MouseHandlerMoveConnectorPointState.prototype.onMouseDown = function (evt) {
        this.connector = this.model.findConnector(evt.source.key);
        this.pointIndex = parseInt(evt.source.value);
        if (this.pointIndex === 0)
            this.pointPosition = Connector_1.ConnectorPosition.Begin;
        else if (this.pointIndex === this.connector.points.length - 1)
            this.pointPosition = Connector_1.ConnectorPosition.End;
        this.handler.addInteractingItem(this.connector);
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onApplyChanges = function (evt) {
        if (this.connector.properties.lineOption !== ConnectorProperties_1.ConnectorLineOption.Orthogonal ||
            this.pointIndex === 0 || this.pointIndex === this.connector.points.length - 1)
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerMoveConnectorPointState.prototype.onFinishWithChanges = function () {
        _super.prototype.onFinishWithChanges.call(this);
        ModelUtils_1.ModelUtils.deleteConnectorUnnecessaryPoints(this.history, this.connector);
        this.handler.tryUpdateModelSize();
    };
    MouseHandlerMoveConnectorPointState.prototype.getSnappedPoint = function (evt, point) {
        var points = this.connector.points;
        var index = this.pointIndex;
        if (0 < index && index < points.length - 1) {
            var tg = (points[index + 1].y - points[index - 1].y) / (points[index + 1].x - points[index - 1].x);
            var x = point.x;
            var y = points[index + 1].y - (points[index + 1].x - x) * tg;
            return this.handler.getSnappedPointOnDragPoint(evt, point, new point_1.Point(x, y));
        }
        return this.handler.getSnappedPointOnDragPoint(evt, point);
    };
    return MouseHandlerMoveConnectorPointState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerMoveConnectorPointState = MouseHandlerMoveConnectorPointState;


/***/ }),

/***/ 3903:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.GraphInfo = void 0;
var LayoutUtils_1 = __webpack_require__(8060);
var GraphInfo = (function () {
    function GraphInfo(container, sourceGraph) {
        this.container = container;
        this.sourceGraph = sourceGraph;
    }
    Object.defineProperty(GraphInfo.prototype, "graph", {
        get: function () {
            return this._graph || (this._graph = this.getNodeInfoGraph());
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(GraphInfo.prototype, "level", {
        get: function () {
            return this._level !== undefined ? this._level : (this._level = this.getLevel());
        },
        enumerable: false,
        configurable: true
    });
    GraphInfo.prototype.getNodeInfoGraph = function () {
        return this.sourceGraph.cast(LayoutUtils_1.LayoutUtils.shapeToLayout);
    };
    GraphInfo.prototype.getLevel = function () {
        var level = 0;
        if (this.container)
            level = this.getContainerLevel(this.container);
        return level;
    };
    GraphInfo.prototype.getContainerLevel = function (container) {
        var level = 1;
        var parentContainer = container.container;
        if (parentContainer)
            level += this.getContainerLevel(parentContainer);
        return level;
    };
    return GraphInfo;
}());
exports.GraphInfo = GraphInfo;


/***/ }),

/***/ 3913:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SimpleCommandBase = void 0;
var CommandBase_1 = __webpack_require__(4339);
var CommandStates_1 = __webpack_require__(4424);
var ModelUtils_1 = __webpack_require__(1922);
var LocalizationService_1 = __webpack_require__(820);
var SimpleCommandBase = (function (_super) {
    __extends(SimpleCommandBase, _super);
    function SimpleCommandBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    SimpleCommandBase.prototype.getState = function () {
        return new CommandStates_1.SimpleCommandState(this.isEnabled(), this.getValue(), this.getDefaultValue(), this.getItems(), this.isVisible());
    };
    SimpleCommandBase.prototype.isVisible = function () {
        return true;
    };
    SimpleCommandBase.prototype.isEnabled = function () {
        return !this.control.settings.readOnly || this.isEnabledInReadOnlyMode();
    };
    SimpleCommandBase.prototype.isEnabledInReadOnlyMode = function () {
        return false;
    };
    SimpleCommandBase.prototype.getValue = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getDefaultValue = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getItems = function () {
        return undefined;
    };
    SimpleCommandBase.prototype.getModelUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getModelUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.model.units, LocalizationService_1.DiagramLocalizationService.unitItems, LocalizationService_1.DiagramLocalizationService.formatUnit, value);
    };
    SimpleCommandBase.prototype.getModelUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.model.units, value);
    };
    SimpleCommandBase.prototype.getViewUnit = function (value) {
        return ModelUtils_1.ModelUtils.getlUnitValue(this.control.settings.viewUnits, value);
    };
    SimpleCommandBase.prototype.getViewUnitText = function (value) {
        return ModelUtils_1.ModelUtils.getUnitText(this.control.settings.viewUnits, LocalizationService_1.DiagramLocalizationService.unitItems, LocalizationService_1.DiagramLocalizationService.formatUnit, value);
    };
    SimpleCommandBase.prototype.getViewUnitTwipsValue = function (value) {
        return ModelUtils_1.ModelUtils.getTwipsValue(this.control.settings.viewUnits, value);
    };
    return SimpleCommandBase;
}(CommandBase_1.CommandBase));
exports.SimpleCommandBase = SimpleCommandBase;


/***/ }),

/***/ 3918:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalCalculator = void 0;
var rectangle_1 = __webpack_require__(4412);
var DiagramItem_1 = __webpack_require__(4824);
var ConnectorPointsCalculatorBase_1 = __webpack_require__(1532);
var ConnectorPointsOrthogonalUndefinedSideCalculator_1 = __webpack_require__(8535);
var ConnectorPointsOrthogonalSouthSideCalculator_1 = __webpack_require__(5442);
var ConnectorPointsOrthogonalNorthSideCalculator_1 = __webpack_require__(2564);
var ConnectorPointsOrthogonalEastSideCalculator_1 = __webpack_require__(6568);
var ConnectorPointsOrthogonalWestSideCalculator_1 = __webpack_require__(522);
var ConnectorRenderPoint_1 = __webpack_require__(9956);
var ModelUtils_1 = __webpack_require__(1922);
var ConnectorPointsOrthogonalCalculator = (function (_super) {
    __extends(ConnectorPointsOrthogonalCalculator, _super);
    function ConnectorPointsOrthogonalCalculator(connector) {
        var _this = _super.call(this, connector) || this;
        _this.sideCalculators = {};
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.Undefined] = new ConnectorPointsOrthogonalUndefinedSideCalculator_1.ConnectorPointsOrthogonalUndefinedSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.South] = new ConnectorPointsOrthogonalSouthSideCalculator_1.ConnectorPointsOrthogonalSouthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.North] = new ConnectorPointsOrthogonalNorthSideCalculator_1.ConnectorPointsOrthogonalNorthSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.East] = new ConnectorPointsOrthogonalEastSideCalculator_1.ConnectorPointsOrthogonalEastSideCalculator(_this);
        _this.sideCalculators[DiagramItem_1.ConnectionPointSide.West] = new ConnectorPointsOrthogonalWestSideCalculator_1.ConnectorPointsOrthogonalWestSideCalculator(_this);
        return _this;
    }
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "beginRect", {
        get: function () { return this.connector.beginItem ? this.connector.beginItem.rectangle : undefined; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalCalculator.prototype, "endRect", {
        get: function () { return this.connector.endItem ? this.connector.endItem.rectangle : undefined; },
        enumerable: false,
        configurable: true
    });
    ConnectorPointsOrthogonalCalculator.prototype.getPoints = function () {
        var points = this.connector.points.map(function (pt, index) { return new ConnectorRenderPoint_1.ConnectorRenderPoint(pt.x, pt.y, index); });
        ModelUtils_1.ModelUtils.skipUnnecessaryRenderPoints(points, true);
        var beginIndex = 0;
        var endIndex = points.length - 1;
        var beginSide = this.getPointSide(points, 0);
        var beginNextSide = this.getPointSide(points, 1);
        var endSide = this.getPointSide(points, points.length - 1);
        var endPrevSide = this.getPointSide(points, points.length - 1 - 1);
        var beginSideCalculator = this.getSideCalculator(beginSide);
        var endSideCalculator = this.getSideCalculator(endSide);
        var originRect = this.beginRect;
        var originPoint = beginSideCalculator.getCorrectOriginPoint(points[beginIndex], originRect);
        var targetPoint = points[beginIndex + 1];
        if (points.length === 2 && beginSideCalculator.isOnSidePoint(originPoint, targetPoint) &&
            beginSideCalculator.isDirectConnectionAllowed(beginNextSide, originPoint, targetPoint)) {
            var directConnectionPoints = beginSideCalculator.getDirectConnectionPoints(originPoint, targetPoint);
            directConnectionPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
                beginIndex++;
                endIndex++;
            });
        }
        else {
            var bOffsetPoints = beginSideCalculator.getBeginOffsetPoints(beginNextSide, points[beginIndex], points[beginIndex + 1], this.beginRect);
            bOffsetPoints.forEach(function (pt) {
                points.splice(beginIndex + 1, 0, pt);
            });
            beginIndex += bOffsetPoints.length;
            endIndex += bOffsetPoints.length;
            var eOffsetPoints = endSideCalculator.getEndOffsetPoints(endPrevSide, points[endIndex], points[endIndex - 1], this.endRect);
            eOffsetPoints.forEach(function (pt, index) {
                points.splice(endIndex + index, 0, pt);
            });
            this.addMiddlePoints(points, beginIndex, endIndex);
        }
        ModelUtils_1.ModelUtils.skipUnnecessaryRenderPoints(points, true);
        return points;
    };
    ConnectorPointsOrthogonalCalculator.prototype.getSideCalculator = function (side) {
        return this.sideCalculators[side];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getPointSide = function (points, index) {
        if (index === 0 && this.connector.beginItem) {
            var connectionPointIndex = this.connector.beginConnectionPointIndex;
            return this.connector.beginItem.getConnectionPointSideByIndex(connectionPointIndex, points[1]);
        }
        if (index === points.length - 1 && this.connector.endItem) {
            var connectionPointIndex = this.connector.endConnectionPointIndex;
            return this.connector.endItem.getConnectionPointSideByIndex(connectionPointIndex, points[points.length - 2]);
        }
        return DiagramItem_1.ConnectionPointSide.Undefined;
    };
    ConnectorPointsOrthogonalCalculator.prototype.addMiddlePoints = function (points, beginIndex, endIndex) {
        for (var index = beginIndex; index < endIndex; index++) {
            var nextIndex = index + 1;
            var middlePoint = this.getMiddlePoint(points[index], points[index - 1], index - 1 === 0, points[nextIndex], points[nextIndex + 1], nextIndex + 1 === points.length - 1);
            if (middlePoint !== undefined) {
                points.splice(index + 1, 0, middlePoint);
                index++;
                endIndex++;
            }
        }
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoints = function (point1, point2) {
        if (point1.x === point2.x || point1.y === point2.y)
            return [];
        return [
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point1.x, point2.y),
            new ConnectorRenderPoint_1.ConnectorRenderPoint(point2.x, point1.y)
        ];
    };
    ConnectorPointsOrthogonalCalculator.prototype.getMiddlePoint = function (point1, directionPoint1, nextToBegin, point2, directionPoint2, nextToEnd) {
        var _this = this;
        var point;
        var points = this.getMiddlePoints(point1, point2);
        points.forEach(function (pt) {
            var rect1 = _this.createPointsRect(point1, pt);
            var rect2 = _this.createPointsRect(pt, point2);
            var itemRect1 = _this.connector.beginItem ? _this.connector.beginItem.rectangle : undefined;
            var itemRect2 = _this.connector.endItem ? _this.connector.endItem.rectangle : undefined;
            if (itemRect1)
                if (rectangle_1.Rectangle.areIntersected(itemRect1, rect1) || rectangle_1.Rectangle.areIntersected(itemRect1, rect2))
                    return;
            if (itemRect2)
                if (rectangle_1.Rectangle.areIntersected(itemRect2, rect1) || rectangle_1.Rectangle.areIntersected(itemRect2, rect2))
                    return;
            if ((!_this.isReturnPoint(pt, point1, directionPoint1) || _this.isIntermediatePoints(point1, directionPoint1)) &&
                (!_this.isReturnPoint(pt, point2, directionPoint2) || _this.isIntermediatePoints(point2, directionPoint2)))
                if (point === undefined)
                    point = pt;
                else if (_this.isPriorMiddlePoint(pt, point1, directionPoint1, point2, directionPoint2))
                    point = pt;
        });
        if (point === undefined && points.length > 0)
            point = points[0];
        return point;
    };
    ConnectorPointsOrthogonalCalculator.prototype.createPointsRect = function (point1, point2) {
        var result = rectangle_1.Rectangle.fromPoints(point1, point2);
        if (result.width > 0)
            result = result.clone().inflate(-1, 0);
        if (result.height > 0)
            result = result.clone().inflate(0, -1);
        return result;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isPriorMiddlePoint = function (point, point1, directionPoint1, point2, directionPoint2) {
        if (directionPoint1)
            if (point.x === directionPoint1.x || point.y === directionPoint1.y)
                return true;
        if (directionPoint2)
            if (point.x === directionPoint2.x || point.y === directionPoint2.y)
                return true;
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isReturnPoint = function (point, point1, point2) {
        if (point1 !== undefined && point2 !== undefined) {
            if (point.x === point2.x)
                if (point1.y < point.y && point.y < point2.y || point1.y > point.y && point.y > point2.y)
                    return true;
            if (point.y === point2.y)
                if (point1.x < point.x && point.x < point2.x || point1.x > point.x && point.x > point2.x)
                    return true;
        }
        return false;
    };
    ConnectorPointsOrthogonalCalculator.prototype.isIntermediatePoints = function (point1, point2) {
        return 0 < point1.pointIndex && point1.pointIndex < this.connector.points.length - 1 &&
            0 < point2.pointIndex && point2.pointIndex < this.connector.points.length - 1;
    };
    return ConnectorPointsOrthogonalCalculator;
}(ConnectorPointsCalculatorBase_1.ConnectorPointsCalculatorBase));
exports.ConnectorPointsOrthogonalCalculator = ConnectorPointsOrthogonalCalculator;


/***/ }),

/***/ 3974:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredVerticalBottomToTopCommand = void 0;
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutLayeredVerticalCommand_1 = __webpack_require__(8827);
var AutoLayoutLayeredVerticalBottomToTopCommand = (function (_super) {
    __extends(AutoLayoutLayeredVerticalBottomToTopCommand, _super);
    function AutoLayoutLayeredVerticalBottomToTopCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredVerticalBottomToTopCommand.prototype.createLayoutSettings = function () {
        var settings = _super.prototype.createLayoutSettings.call(this);
        settings.direction = LayoutSettings_1.LogicalDirectionKind.Backward;
        return settings;
    };
    return AutoLayoutLayeredVerticalBottomToTopCommand;
}(AutoLayoutLayeredVerticalCommand_1.AutoLayoutLayeredVerticalCommand));
exports.AutoLayoutLayeredVerticalBottomToTopCommand = AutoLayoutLayeredVerticalBottomToTopCommand;


/***/ }),

/***/ 3976:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorPointsOrthogonalSideCalculatorBase = void 0;
var rectangle_1 = __webpack_require__(4412);
var DiagramItem_1 = __webpack_require__(4824);
var Connector_1 = __webpack_require__(6320);
var ConnectorPointsOrthogonalSideCalculatorBase = (function () {
    function ConnectorPointsOrthogonalSideCalculatorBase(parent) {
        this.parent = parent;
    }
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "connector", {
        get: function () { return this.parent.connector; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "beginRect", {
        get: function () { return this.parent.beginRect; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ConnectorPointsOrthogonalSideCalculatorBase.prototype, "endRect", {
        get: function () { return this.parent.endRect; },
        enumerable: false,
        configurable: true
    });
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getBeginOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(originPoint, targetPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getBeginOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getBeginOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getBeginOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getEndOffsetPoints = function (targetSide, originPoint, targetPoint, originRect) {
        originPoint = this.getCorrectOriginPoint(originPoint, originRect);
        if (targetSide !== DiagramItem_1.ConnectionPointSide.Undefined) {
            if (this.isBeginEndSame())
                return this.getSameShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlappedPoints(targetPoint, originPoint))
                return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
            else if (this.isBeginEndOverlapped())
                return this.getEndOverlappedShapeOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        }
        else if (this.isOriginRectContainsTargetPoint(originRect, targetPoint))
            return this.getOverlappedPointsOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        if (this.isOnSidePoint(originPoint, targetPoint))
            return this.getEndOnSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
        return this.getEndOffSideOffsetPoints(targetSide, originPoint, targetPoint, originRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSide = function (originPoint, targetPoint) {
        var diffX = Math.abs(targetPoint.x - originPoint.x);
        var diffY = Math.abs(targetPoint.y - originPoint.y);
        if (diffX > diffY)
            if (targetPoint.x > originPoint.x)
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.West;
        else if (targetPoint.y > originPoint.y)
            return DiagramItem_1.ConnectionPointSide.South;
        else
            return DiagramItem_1.ConnectionPointSide.North;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getSideCalculator = function (originPoint, targetPoint) {
        return this.parent.getSideCalculator(this.getSide(originPoint, targetPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.getMinOffset = function () {
        return Connector_1.Connector.minOffset;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndSame = function () {
        return this.connector.beginItem === this.connector.endItem;
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlapped = function () {
        return this.beginRect && this.endRect && rectangle_1.Rectangle.areIntersected(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedX = function () {
        return this.beginRect && this.endRect && !!rectangle_1.Rectangle.getHorizIntersection(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedY = function () {
        return this.beginRect && this.endRect && !!rectangle_1.Rectangle.getVertIntersection(this.beginRect, this.endRect);
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isBeginEndOverlappedPoints = function (beginPoint, endPoint) {
        return this.beginRect && this.endRect && (this.beginRect.containsPoint(endPoint) || this.endRect.containsPoint(beginPoint));
    };
    ConnectorPointsOrthogonalSideCalculatorBase.prototype.isOriginRectContainsTargetPoint = function (originRect, targetPoint) {
        return originRect && targetPoint && originRect.containsPoint(targetPoint);
    };
    return ConnectorPointsOrthogonalSideCalculatorBase;
}());
exports.ConnectorPointsOrthogonalSideCalculatorBase = ConnectorPointsOrthogonalSideCalculatorBase;


/***/ }),

/***/ 4009:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ToggleFullscreenCommand = void 0;
var SimpleCommandBase_1 = __webpack_require__(3913);
var ToggleFullscreenCommand = (function (_super) {
    __extends(ToggleFullscreenCommand, _super);
    function ToggleFullscreenCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ToggleFullscreenCommand.prototype.isEnabledInReadOnlyMode = function () {
        return true;
    };
    ToggleFullscreenCommand.prototype.getValue = function () {
        return this.control.settings.fullscreen;
    };
    ToggleFullscreenCommand.prototype.executeCore = function (state, parameter) {
        var newValue = typeof parameter === "boolean" ? parameter : !state.value;
        if (this.control.settings.fullscreen !== newValue) {
            this.control.settings.fullscreen = !state.value;
            this.control.notifyToggleFullscreen(this.control.settings.fullscreen);
        }
        return true;
    };
    return ToggleFullscreenCommand;
}(SimpleCommandBase_1.SimpleCommandBase));
exports.ToggleFullscreenCommand = ToggleFullscreenCommand;


/***/ }),

/***/ 4044:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ScrollIntoViewOnUndoHistoryItem = exports.ScrollIntoViewOnRedoHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var ScrollIntoViewOnRedoHistoryItem = (function (_super) {
    __extends(ScrollIntoViewOnRedoHistoryItem, _super);
    function ScrollIntoViewOnRedoHistoryItem(view, rectangle) {
        var _this = _super.call(this) || this;
        _this.view = view;
        _this.rectangle = rectangle;
        _this.view = view;
        _this.rectangle = rectangle.clone();
        return _this;
    }
    ScrollIntoViewOnRedoHistoryItem.prototype.redo = function (manipulator) {
        this.view.scrollIntoView(this.rectangle);
    };
    ScrollIntoViewOnRedoHistoryItem.prototype.undo = function (manipulator) { };
    return ScrollIntoViewOnRedoHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ScrollIntoViewOnRedoHistoryItem = ScrollIntoViewOnRedoHistoryItem;
var ScrollIntoViewOnUndoHistoryItem = (function (_super) {
    __extends(ScrollIntoViewOnUndoHistoryItem, _super);
    function ScrollIntoViewOnUndoHistoryItem(view, rectangle) {
        var _this = _super.call(this) || this;
        _this.view = view;
        _this.rectangle = rectangle;
        _this.view = view;
        _this.rectangle = rectangle.clone();
        return _this;
    }
    ScrollIntoViewOnUndoHistoryItem.prototype.redo = function (manipulator) { };
    ScrollIntoViewOnUndoHistoryItem.prototype.undo = function (manipulator) {
        this.view.scrollIntoView(this.rectangle);
    };
    return ScrollIntoViewOnUndoHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.ScrollIntoViewOnUndoHistoryItem = ScrollIntoViewOnUndoHistoryItem;


/***/ }),

/***/ 4045:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AStarContext = exports.AStarContextBase = void 0;
var SortedQueues_1 = __webpack_require__(6210);
var UniqueAStarNodePositions_1 = __webpack_require__(2721);
var AStarNode_1 = __webpack_require__(2740);
var segment_1 = __webpack_require__(476);
var RightAngleConnectorRoutingMathOperations_1 = __webpack_require__(618);
var Utils_1 = __webpack_require__(41);
var AStarContextBase = (function () {
    function AStarContextBase(startPosition, targetPosition, maxStepsCount) {
        this.startPosition = startPosition;
        this.targetPosition = targetPosition;
        this.maxStepsCount = maxStepsCount;
        this.prohibitedPoints = {};
    }
    Object.defineProperty(AStarContextBase.prototype, "shouldStartContinue", {
        get: function () {
            return this.updatableSet.count > 0 && this.stepsCount < this.maxStepsCount;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(AStarContextBase.prototype, "shouldFinish", {
        get: function () {
            return this.currentNode.position.equals(this.targetPosition);
        },
        enumerable: false,
        configurable: true
    });
    AStarContextBase.prototype.start = function () {
        this.generalSet = new SortedQueues_1.SortedQueues(function (x) { return x.key; });
        this.updatableSet = new UniqueAStarNodePositions_1.UniqueAStarNodePositions();
        var currentNode = new AStarNode_1.AStarNode(this.startPosition, this.getDistance(this.startPosition, this.targetPosition));
        this.currentNode = currentNode;
        this.generalSet.enqueue(currentNode);
        this.updatableSet.add(currentNode.position, currentNode);
        this.stepsCount = 0;
        this.openNode = undefined;
    };
    AStarContextBase.prototype.startContinue = function () {
        this.currentNode = this.generalSet.dequeueMin();
    };
    AStarContextBase.prototype.endContinue = function () {
        var _this = this;
        var currentPosition = this.currentNode.position;
        this.updatableSet.remove(currentPosition);
        this.addProhibitedPoint(currentPosition);
        this.getNeighborPoints(currentPosition).forEach(function (nextPosition) {
            var penalty = _this.getPenalty(_this.currentNode, nextPosition);
            var openNode = _this.updatableSet.getNode(nextPosition);
            if (openNode === undefined) {
                openNode = new AStarNode_1.AStarNode(nextPosition, _this.getDistance(nextPosition, _this.targetPosition));
                openNode.parent = _this.currentNode;
                openNode.penalty = penalty;
                _this.generalSet.enqueue(openNode);
                _this.updatableSet.add(nextPosition, openNode);
            }
            else if (openNode.penalty > penalty) {
                var generalSet = _this.generalSet;
                generalSet.remove(openNode);
                openNode.parent = _this.currentNode;
                openNode.penalty = penalty;
                generalSet.enqueue(openNode);
            }
            _this.openNode = openNode;
        });
        this.stepsCount++;
    };
    AStarContextBase.prototype.finishWithPath = function () {
        this.path = this.currentNode.getPath();
    };
    AStarContextBase.prototype.finishWithoutPath = function () {
        this.path = [];
    };
    return AStarContextBase;
}());
exports.AStarContextBase = AStarContextBase;
var AStarContext = (function (_super) {
    __extends(AStarContext, _super);
    function AStarContext(routingContext, startPosition, targetPosition, prohibitedSegments, grid, metrics) {
        var _this = _super.call(this, startPosition, targetPosition, 10000) || this;
        _this.routingContext = routingContext;
        _this.startPosition = startPosition;
        _this.targetPosition = targetPosition;
        _this.prohibitedSegments = prohibitedSegments;
        _this.grid = grid;
        _this.metrics = metrics;
        return _this;
    }
    AStarContext.prototype.addProhibitedPoint = function (point) {
        this.prohibitedPoints[point.x + "_" + point.y] = point;
    };
    AStarContext.prototype.getNeighborPoints = function (point) {
        var _this = this;
        return this.grid.getNeighborPoints(point).filter(function (p) { return _this.allowPoint(p); });
    };
    AStarContext.prototype.getDistance = function (startPoint, endPoint) {
        return this.metrics.distance(startPoint, endPoint);
    };
    AStarContext.prototype.getPenalty = function (node, nextPoint) {
        var parent = node.parent;
        var currentPosition = node.position;
        var turnDirection = this.getTurnDirection(parent ? Utils_1.GeometryUtils.createAngle(parent.position, currentPosition, nextPoint) : 0);
        var distance = this.getDistance(currentPosition, nextPoint);
        var middlePosition = new segment_1.Segment(currentPosition, nextPoint).center;
        return node.penalty + this.metrics.penalty(distance, middlePosition, turnDirection, this.getIntersectedItems(middlePosition));
    };
    AStarContext.prototype.allowPoint = function (p) {
        return !((p.x + "_" + p.y) in this.prohibitedPoints) && (!this.prohibitedSegments || this.prohibitedSegments.allowPoint(p));
    };
    AStarContext.prototype.getTurnDirection = function (angle) {
        return RightAngleConnectorRoutingMathOperations_1.RightAngleConnectorRoutingMathOperations.getTurnDirection(angle);
    };
    AStarContext.prototype.getIntersectedItems = function (position) {
        var _this = this;
        var margin = this.routingContext.shapeMargins;
        return this.routingContext.getIntersectedItems(position, margin)
            .filter(function (i) { return _this.hasOneShapeConnection(i) || !_this.itemContainsConnectionPoints(i); });
    };
    AStarContext.prototype.itemContainsConnectionPoints = function (item) {
        var rectangle = item.rectangle;
        return rectangle.containsPoint(this.routingContext.beginPoint) && rectangle.containsPoint(this.routingContext.endPoint);
    };
    AStarContext.prototype.hasOneShapeConnection = function (item) {
        var connectionPoints = item.getConnectionPoints();
        return this.isConnectionPoint(connectionPoints, this.routingContext.beginPoint) &&
            this.isConnectionPoint(connectionPoints, this.routingContext.endPoint);
    };
    AStarContext.prototype.isConnectionPoint = function (connectionPoints, point) {
        return connectionPoints.filter(function (p) { return p.equals(point); }).length > 0;
    };
    return AStarContext;
}(AStarContextBase));
exports.AStarContext = AStarContext;


/***/ }),

/***/ 4048:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AddConnectorHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var Connector_1 = __webpack_require__(6320);
var AddConnectorHistoryItem = (function (_super) {
    __extends(AddConnectorHistoryItem, _super);
    function AddConnectorHistoryItem(points, dataKey, renderPointsContext) {
        var _this = _super.call(this) || this;
        _this.points = points;
        _this.dataKey = dataKey;
        _this.renderPointsContext = renderPointsContext;
        return _this;
    }
    AddConnectorHistoryItem.prototype.redo = function (manipulator) {
        var connector = new Connector_1.Connector(this.points);
        if (this.dataKey !== undefined)
            connector.dataKey = this.dataKey;
        if (this.renderPointsContext !== undefined)
            connector.replaceRenderPoints(this.renderPointsContext);
        manipulator.addConnector(connector, this.connectorKey);
        this.connectorKey = connector.key;
    };
    AddConnectorHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnector(connector);
    };
    return AddConnectorHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectorHistoryItem = AddConnectorHistoryItem;


/***/ }),

/***/ 4062:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ImageCache = exports.CacheImageInfo = void 0;
var base64_1 = __webpack_require__(807);
var ImageInfo_1 = __webpack_require__(9406);
var Utils_1 = __webpack_require__(41);
var CacheImageInfo = (function () {
    function CacheImageInfo(base64, actualId, imageUrl, referenceInfo, isLoaded) {
        this._base64 = base64 !== undefined ? base64_1.Base64Utils.normalizeToDataUrl(base64, "image/png") : undefined;
        this.actualId = actualId;
        this._referenceInfo = referenceInfo;
        this._isLoaded = isLoaded !== undefined ? isLoaded : false;
        this.imageUrl = imageUrl;
    }
    Object.defineProperty(CacheImageInfo.prototype, "isLoaded", {
        get: function () { return this._referenceInfo ? this._referenceInfo._isLoaded : this._isLoaded; },
        set: function (val) { this._isLoaded = val; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "base64", {
        get: function () { return this._base64; },
        set: function (val) { this._base64 = base64_1.Base64Utils.normalizeToDataUrl(val, "image/png"); },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "referenceInfo", {
        get: function () { return this._referenceInfo; },
        set: function (val) {
            this._referenceInfo = val;
            this._base64 = undefined;
            this._isLoaded = undefined;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CacheImageInfo.prototype, "isLoading", {
        get: function () { return this._referenceInfo ? this.referenceInfo._isLoading : this._isLoading; },
        enumerable: false,
        configurable: true
    });
    CacheImageInfo.prototype.startLoading = function () {
        if (this._referenceInfo)
            this._referenceInfo.startLoading();
        else
            this._isLoading = true;
    };
    CacheImageInfo.prototype.finalizeLoading = function () {
        if (this._referenceInfo)
            this._referenceInfo.finalizeLoading();
        else
            this._isLoading = false;
    };
    return CacheImageInfo;
}());
exports.CacheImageInfo = CacheImageInfo;
var ImageCache = (function () {
    function ImageCache() {
        this.emptyImageId = 0;
        this.lastActualId = 0;
        this.onReadyStateChanged = new Utils_1.EventDispatcher();
        this.cache = [];
        this.nonLoadedImages = [];
        var emptyImage = this.createUnloadedInfoByBase64(ImageInfo_1.ImageInfo.transparentOnePixelImage);
        emptyImage.isLoaded = true;
    }
    ImageCache.prototype.reset = function () {
        this.cache.splice(1);
        this.nonLoadedImages = [];
        this.lastActualId = 1;
    };
    Object.defineProperty(ImageCache.prototype, "emptyImage", {
        get: function () { return this.cache[this.emptyImageId]; },
        enumerable: false,
        configurable: true
    });
    ImageCache.prototype.getImageData = function (id) {
        return this.cache[id];
    };
    ImageCache.prototype.createUnloadedInfoByUrl = function (imageUrl) {
        var info = this.findInfoByUrl(imageUrl);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(undefined, this.getNextActualId(), imageUrl));
    };
    ImageCache.prototype.createUnloadedInfoByBase64 = function (base64) {
        var info = this.findInfoByBase64(base64);
        if (info)
            return info;
        return this.registerImageData(new CacheImageInfo(base64, this.getNextActualId()));
    };
    ImageCache.prototype.createUnloadedInfoByShapeImageInfo = function (imageInfo) {
        var data = imageInfo.exportUrl;
        return base64_1.Base64Utils.checkPrependDataUrl(data) ?
            this.createUnloadedInfoByBase64(data) :
            this.createUnloadedInfoByUrl(data);
    };
    ImageCache.prototype.registerImageData = function (data) {
        var existingData = this.cache[data.actualId];
        if (!existingData)
            existingData = data;
        if (data.actualId !== undefined)
            this.cache[data.actualId] = existingData;
        if (data.actualId !== 0) {
            this.nonLoadedImages.push(data);
            if (this.nonLoadedImages.length === 1)
                this.raiseReadyStateChanged(false);
        }
        return existingData;
    };
    ImageCache.prototype.loadAllImages = function (loader) {
        var _this = this;
        this.cache.forEach(function (cacheInfo) {
            if (_this.emptyImageId !== cacheInfo.actualId && !cacheInfo.isLoaded && !cacheInfo.isLoading)
                loader.load(cacheInfo);
        });
    };
    ImageCache.prototype.finalizeLoading = function (existingInfo, loadedInfo) {
        existingInfo.finalizeLoading();
        existingInfo.isLoaded = true;
        var imageInfoIndex = this.nonLoadedImages.indexOf(existingInfo);
        this.nonLoadedImages.splice(imageInfoIndex, 1);
        if (this.nonLoadedImages.length === 0)
            this.raiseReadyStateChanged(true);
        if (existingInfo.referenceInfo)
            return;
        if (loadedInfo.base64) {
            var base64_2 = base64_1.Base64Utils.normalizeToDataUrl(loadedInfo.base64, "image/png");
            this.cache.forEach(function (cacheElem) {
                var isReference = cacheElem.base64 === base64_2 && cacheElem !== existingInfo && cacheElem.isLoaded;
                if (isReference)
                    existingInfo.referenceInfo = cacheElem.referenceInfo ? cacheElem.referenceInfo : cacheElem;
                return isReference;
            });
            existingInfo.base64 = base64_2;
        }
    };
    ImageCache.prototype.hasNonLoadedImages = function () {
        return this.nonLoadedImages.length !== 0;
    };
    ImageCache.prototype.getNextActualId = function () {
        return this.lastActualId++;
    };
    ImageCache.prototype.findInfoByBase64 = function (base64) {
        base64 = base64_1.Base64Utils.normalizeToDataUrl(base64, "image/png");
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.base64 === base64; });
    };
    ImageCache.prototype.findInfoByUrl = function (imageUrl) {
        return this.findInfoCore(function (cacheImageInfo) { return cacheImageInfo.imageUrl === imageUrl; });
    };
    ImageCache.prototype.findInfoCore = function (callback) {
        var cacheInfo;
        this.cache.forEach(function (item) {
            if (callback(item))
                cacheInfo = item;
        });
        return cacheInfo;
    };
    ImageCache.prototype.raiseReadyStateChanged = function (ready) {
        this.onReadyStateChanged.raise1(function (l) { return l.notifyImageCacheReadyStateChanged(ready); });
    };
    ImageCache.instance = new ImageCache();
    return ImageCache;
}());
exports.ImageCache = ImageCache;


/***/ }),

/***/ 4092:
/***/ ((__unused_webpack_module, __unused_webpack_exports, __webpack_require__) => {



(__webpack_require__(9491).polyfill)();


/***/ }),

/***/ 4139:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.SetConnectionPointIndexHistoryItem = exports.AddConnectionHistoryItem = void 0;
var HistoryItem_1 = __webpack_require__(2616);
var Connector_1 = __webpack_require__(6320);
var AddConnectionHistoryItem = (function (_super) {
    __extends(AddConnectionHistoryItem, _super);
    function AddConnectionHistoryItem(connector, item, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.itemKey = item.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    AddConnectionHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        var item = manipulator.model.findItem(this.itemKey);
        manipulator.addConnection(connector, item, this.connectionPointIndex, this.position);
    };
    AddConnectionHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.deleteConnection(connector, this.position);
    };
    return AddConnectionHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.AddConnectionHistoryItem = AddConnectionHistoryItem;
var SetConnectionPointIndexHistoryItem = (function (_super) {
    __extends(SetConnectionPointIndexHistoryItem, _super);
    function SetConnectionPointIndexHistoryItem(connector, connectionPointIndex, position) {
        var _this = _super.call(this) || this;
        _this.connectorKey = connector.key;
        _this.connectionPointIndex = connectionPointIndex;
        _this.position = position;
        return _this;
    }
    SetConnectionPointIndexHistoryItem.prototype.redo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        this.oldConnectionPointIndex = this.position === Connector_1.ConnectorPosition.Begin ? connector.beginConnectionPointIndex : connector.endConnectionPointIndex;
        manipulator.setConnectionPointIndex(connector, this.connectionPointIndex, this.position);
    };
    SetConnectionPointIndexHistoryItem.prototype.undo = function (manipulator) {
        var connector = manipulator.model.findConnector(this.connectorKey);
        manipulator.setConnectionPointIndex(connector, this.oldConnectionPointIndex, this.position);
    };
    return SetConnectionPointIndexHistoryItem;
}(HistoryItem_1.HistoryItem));
exports.SetConnectionPointIndexHistoryItem = SetConnectionPointIndexHistoryItem;


/***/ }),

/***/ 4166:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.Vector = void 0;
var Vector = (function () {
    function Vector(x, y) {
        if (x === void 0) { x = 0; }
        if (y === void 0) { y = 0; }
        this.x = x;
        this.y = y;
    }
    Object.defineProperty(Vector.prototype, "length", {
        get: function () {
            return Math.sqrt(this.x * this.x + this.y * this.y);
        },
        enumerable: false,
        configurable: true
    });
    Vector.fromPoints = function (begin, end) {
        return new Vector(end.x - begin.x, end.y - begin.y);
    };
    Vector.fromSegment = function (segment) {
        return new Vector(segment.endPoint.x - segment.startPoint.x, segment.endPoint.y - segment.startPoint.y);
    };
    Vector.prototype.normalize = function () {
        var length = this.length;
        if (length !== 0) {
            this.x /= length;
            this.y /= length;
        }
        return this;
    };
    Vector.prototype.negative = function () {
        this.x *= -1;
        this.y *= -1;
        return this;
    };
    Object.defineProperty(Vector, "axisX", {
        get: function () {
            return new Vector(1, 0);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Vector, "axisY", {
        get: function () {
            return new Vector(0, 1);
        },
        enumerable: false,
        configurable: true
    });
    Vector.angleBetween = function (a, b) {
        var cosFi = Vector.scalarProduct(a, b) / (a.length * b.length);
        return Math.acos(cosFi);
    };
    Vector.scalarProduct = function (a, b) {
        return a.x * b.x + a.y * b.y;
    };
    return Vector;
}());
exports.Vector = Vector;


/***/ }),

/***/ 4214:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.AutoLayoutLayeredHorizontalCommand = void 0;
var AutoLayoutCommandBase_1 = __webpack_require__(8674);
var Sugiyama_1 = __webpack_require__(2626);
var LayoutSettings_1 = __webpack_require__(9212);
var AutoLayoutLayeredHorizontalCommand = (function (_super) {
    __extends(AutoLayoutLayeredHorizontalCommand, _super);
    function AutoLayoutLayeredHorizontalCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    AutoLayoutLayeredHorizontalCommand.prototype.createLayoutSettings = function () {
        var settings = new LayoutSettings_1.LayoutSettings();
        settings.orientation = LayoutSettings_1.DataLayoutOrientation.Horizontal;
        return settings;
    };
    AutoLayoutLayeredHorizontalCommand.prototype.createLayout = function (settings, graph) {
        return new Sugiyama_1.SugiyamaLayoutBuilder(settings, graph).build();
    };
    return AutoLayoutLayeredHorizontalCommand;
}(AutoLayoutCommandBase_1.AutoLayoutCommandBase));
exports.AutoLayoutLayeredHorizontalCommand = AutoLayoutLayeredHorizontalCommand;


/***/ }),

/***/ 4235:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.NativeConnector = exports.NativeShape = exports.NativeItem = void 0;
var ModelUtils_1 = __webpack_require__(1922);
var NativeItem = (function () {
    function NativeItem(id, key) {
        this.id = id;
        this.key = key;
        this.unitsApplied = false;
    }
    NativeItem.prototype.applyUnits = function (units) {
        if (!this.unitsApplied && units !== undefined) {
            this.applyUnitsCore(units);
            this.unitsApplied = true;
        }
    };
    return NativeItem;
}());
exports.NativeItem = NativeItem;
var NativeShape = (function (_super) {
    __extends(NativeShape, _super);
    function NativeShape() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NativeShape.prototype.applyUnitsCore = function (units) {
        this.position.x = ModelUtils_1.ModelUtils.getlUnitValue(units, this.position.x);
        this.position.y = ModelUtils_1.ModelUtils.getlUnitValue(units, this.position.y);
        this.size.width = ModelUtils_1.ModelUtils.getlUnitValue(units, this.size.width);
        this.size.height = ModelUtils_1.ModelUtils.getlUnitValue(units, this.size.height);
    };
    return NativeShape;
}(NativeItem));
exports.NativeShape = NativeShape;
var NativeConnector = (function (_super) {
    __extends(NativeConnector, _super);
    function NativeConnector() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    NativeConnector.prototype.applyUnitsCore = function (units) {
        this.points.forEach(function (pt) {
            pt.x = ModelUtils_1.ModelUtils.getlUnitValue(units, pt.x);
            pt.y = ModelUtils_1.ModelUtils.getlUnitValue(units, pt.y);
        });
    };
    return NativeConnector;
}(NativeItem));
exports.NativeConnector = NativeConnector;


/***/ }),

/***/ 4237:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.MouseHandlerCreateConnectorState = void 0;
var Connector_1 = __webpack_require__(6320);
var AddConnectionHistoryItem_1 = __webpack_require__(4139);
var AddConnectorHistoryItem_1 = __webpack_require__(4048);
var DiagramItem_1 = __webpack_require__(4824);
var MouseHandlerMoveConnectorPointStateBase_1 = __webpack_require__(8619);
var SetSelectionHistoryItem_1 = __webpack_require__(6512);
var AddShapeHistoryItem_1 = __webpack_require__(8214);
var ModelUtils_1 = __webpack_require__(1922);
var DeleteConnectionHistoryItem_1 = __webpack_require__(6155);
var DeleteConnectorHistoryItem_1 = __webpack_require__(7392);
var MouseHandlerCreateConnectorState = (function (_super) {
    __extends(MouseHandlerCreateConnectorState, _super);
    function MouseHandlerCreateConnectorState(handler, history, model, visualizerManager, shapeDescriptionManager, selection, connectionPointIndex) {
        var _this = _super.call(this, handler, history, model, visualizerManager) || this;
        _this.shapeDescriptionManager = shapeDescriptionManager;
        _this.selection = selection;
        _this.connectionPointIndex = connectionPointIndex;
        return _this;
    }
    MouseHandlerCreateConnectorState.prototype.onMouseDown = function (evt) {
        if (this.connectionPointIndex === undefined)
            this.connectionPointIndex = parseInt(evt.source.value);
        this.connectedItem = this.model.findItem(evt.source.key);
        this.pointIndex = 1;
        this.pointPosition = Connector_1.ConnectorPosition.End;
        _super.prototype.onMouseDown.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onMouseUp = function (evt) {
        if (this.connector && !this.connector.endItem)
            this.createNewShapeAtConnectorEnd(evt);
        _super.prototype.onMouseUp.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.onApplyChanges = function (evt) {
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        if (!this.connector) {
            var historyItem = new AddConnectorHistoryItem_1.AddConnectorHistoryItem([this.connectedItem.getConnectionPointPosition(this.connectionPointIndex, point), point]);
            this.history.addAndRedo(historyItem);
            this.connector = this.model.findConnector(historyItem.connectorKey);
            this.handler.addInteractingItem(this.connector);
            this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(this.connector, this.connectedItem, this.connectionPointIndex, Connector_1.ConnectorPosition.Begin));
            ModelUtils_1.ModelUtils.updateNewConnectorProperties(this.history, this.selection, this.connector.key);
        }
        else
            _super.prototype.onApplyChanges.call(this, evt);
    };
    MouseHandlerCreateConnectorState.prototype.checkStoredPermissionsOnFinish = function () {
        if (this.connector && this.connector.endItem)
            _super.prototype.checkStoredPermissionsOnFinish.call(this);
    };
    MouseHandlerCreateConnectorState.prototype.onFinishWithChanges = function () {
        _super.prototype.onFinishWithChanges.call(this);
        this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, [this.connector.key]));
    };
    MouseHandlerCreateConnectorState.prototype.createNewShapeAtConnectorEnd = function (evt) {
        var _this = this;
        var beginShape = this.connector && this.connector.beginItem;
        if (!beginShape)
            return;
        if (this.connector && !this.handler.canPerformChangeConnection(this.connector, { position: Connector_1.ConnectorPosition.End, connectionPointIndex: -1 })) {
            this.cancelChanges();
            return;
        }
        var side = this.getNewShapeSide(this.connector);
        var point = this.getSnappedPoint(evt, evt.modelPoint);
        var category = this.shapeDescriptionManager.getCategoryByDescription(beginShape.description);
        var getPositionToInsertShapeTo = function (shape) {
            var clonedShape = shape.clone();
            clonedShape.position = point.clone();
            var position = _this.getNewShapePosition(clonedShape, side);
            return _this.handler.getSnappedPointOnDragPoint(evt, position);
        };
        this.handler.showContextToolbox(point, getPositionToInsertShapeTo, side, category, function (shapeType) {
            if (!shapeType)
                return;
            _this.handler.beginStorePermissions();
            _this.history.beginTransaction();
            var historyItem = new AddShapeHistoryItem_1.AddShapeHistoryItem(_this.shapeDescriptionManager.get(shapeType), point);
            _this.history.addAndRedo(historyItem);
            var shape = _this.model.findShape(historyItem.shapeKey);
            var container = _this.targetItem && _this.model.findNearestContainer(_this.targetItem.key);
            if (container)
                ModelUtils_1.ModelUtils.insertToContainer(_this.history, _this.model, shape, container);
            var newPosition = _this.getNewShapePosition(shape, side);
            ModelUtils_1.ModelUtils.setShapePosition(_this.history, _this.model, shape, _this.getSnappedPoint(evt, newPosition));
            ModelUtils_1.ModelUtils.updateNewShapeProperties(_this.history, _this.selection, shape.key);
            _this.history.addAndRedo(new AddConnectionHistoryItem_1.AddConnectionHistoryItem(_this.connector, shape, shape.getConnectionPointIndexForSide(side), Connector_1.ConnectorPosition.End));
            if (container)
                ModelUtils_1.ModelUtils.updateConnectorContainer(_this.history, _this.model, _this.connector);
            ModelUtils_1.ModelUtils.updateShapeAttachedConnectors(_this.history, _this.model, shape);
            if (!_this.handler.isStoredPermissionsGranted()) {
                _this.handler.lockPermissions();
                _this.history.undoTransaction();
                _this.handler.unlockPermissions();
                _this.checkNewConnectorPermissions();
            }
            else {
                _this.handler.tryUpdateModelSize();
                _this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(_this.selection, [shape.key]));
            }
            _this.history.endTransaction();
            _this.handler.endStorePermissions();
            _this.handler.hideContextToolbox(true);
        }, function () {
            _this.checkNewConnectorPermissions();
        });
    };
    MouseHandlerCreateConnectorState.prototype.checkNewConnectorPermissions = function () {
        if (this.connector && !this.handler.canPerformChangeConnection(this.connector, { position: Connector_1.ConnectorPosition.End, connectionPointIndex: -1 })) {
            this.handler.lockPermissions();
            this.history.beginTransaction();
            this.history.addAndRedo(new SetSelectionHistoryItem_1.SetSelectionHistoryItem(this.selection, []));
            if (this.connector.beginItem)
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, Connector_1.ConnectorPosition.Begin));
            if (this.connector.endItem)
                this.history.addAndRedo(new DeleteConnectionHistoryItem_1.DeleteConnectionHistoryItem(this.connector, Connector_1.ConnectorPosition.End));
            this.history.addAndRedo(new DeleteConnectorHistoryItem_1.DeleteConnectorHistoryItem(this.connector.key));
            this.history.endTransaction();
            this.handler.unlockPermissions();
        }
    };
    MouseHandlerCreateConnectorState.prototype.getNewShapePosition = function (shape, side) {
        switch (side) {
            case DiagramItem_1.ConnectionPointSide.North:
                return shape.position.clone().offset(-shape.size.width / 2, 0);
            case DiagramItem_1.ConnectionPointSide.South:
                return shape.position.clone().offset(-shape.size.width / 2, -shape.size.height);
            case DiagramItem_1.ConnectionPointSide.East:
                return shape.position.clone().offset(-shape.size.width, -shape.size.height / 2);
            case DiagramItem_1.ConnectionPointSide.West:
                return shape.position.clone().offset(0, -shape.size.height / 2);
        }
    };
    MouseHandlerCreateConnectorState.prototype.getNewShapeSide = function (connector) {
        var renderPoints = connector.getRenderPoints();
        return MouseHandlerCreateConnectorState.getNewShapeSideByConnectorPoints(renderPoints[renderPoints.length - 1], renderPoints[renderPoints.length - 2]);
    };
    MouseHandlerCreateConnectorState.prototype.getSourceItem = function () {
        return this.connectedItem;
    };
    MouseHandlerCreateConnectorState.getNewShapeSideByConnectorPoints = function (point, directionPoint) {
        if (point.x === directionPoint.x)
            if (point.y > directionPoint.y)
                return DiagramItem_1.ConnectionPointSide.North;
            else
                return DiagramItem_1.ConnectionPointSide.South;
        else if (point.x > directionPoint.x)
            if (point.y === directionPoint.y)
                return DiagramItem_1.ConnectionPointSide.West;
            else if (point.y > directionPoint.y)
                if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                    return DiagramItem_1.ConnectionPointSide.West;
                else
                    return DiagramItem_1.ConnectionPointSide.North;
            else if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                return DiagramItem_1.ConnectionPointSide.West;
            else
                return DiagramItem_1.ConnectionPointSide.South;
        else if (point.y === directionPoint.y)
            return DiagramItem_1.ConnectionPointSide.East;
        else if (point.y > directionPoint.y)
            if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
                return DiagramItem_1.ConnectionPointSide.East;
            else
                return DiagramItem_1.ConnectionPointSide.North;
        else if (Math.abs(point.x - directionPoint.x) > Math.abs(point.y - directionPoint.y))
            return DiagramItem_1.ConnectionPointSide.East;
        else
            return DiagramItem_1.ConnectionPointSide.South;
    };
    return MouseHandlerCreateConnectorState;
}(MouseHandlerMoveConnectorPointStateBase_1.MouseHandlerMoveConnectorPointStateBase));
exports.MouseHandlerCreateConnectorState = MouseHandlerCreateConnectorState;


/***/ }),

/***/ 4276:
/***/ (function(__unused_webpack_module, exports, __webpack_require__) {


var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ChangeConnectorLineOptionCommand = void 0;
var ChangeConnectorPropertyCommand_1 = __webpack_require__(2078);
var ConnectorProperties_1 = __webpack_require__(4385);
var ChangeConnectorLineOptionCommand = (function (_super) {
    __extends(ChangeConnectorLineOptionCommand, _super);
    function ChangeConnectorLineOptionCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ChangeConnectorLineOptionCommand.prototype.getPropertyName = function () {
        return "lineOption";
    };
    ChangeConnectorLineOptionCommand.prototype.getPropertyDefaultValue = function () {
        return ConnectorProperties_1.ConnectorLineOption.Straight;
    };
    return ChangeConnectorLineOptionCommand;
}(ChangeConnectorPropertyCommand_1.ChangeConnectorPropertyCommand));
exports.ChangeConnectorLineOptionCommand = ChangeConnectorLineOptionCommand;


/***/ }),

/***/ 4306:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RenderManager = exports.DBL_CLICK_TIMEOUT = exports.LONG_TOUCH_TIMEOUT = void 0;
var Event_1 = __webpack_require__(5428);
var evt_1 = __webpack_require__(8451);
var dom_1 = __webpack_require__(750);
var point_1 = __webpack_require__(5327);
var key_1 = __webpack_require__(6537);
var browser_1 = __webpack_require__(8424);
var Utils_1 = __webpack_require__(2136);
var CanvasItemsManager_1 = __webpack_require__(9922);
var ScrollView_1 = __webpack_require__(7281);
var Settings_1 = __webpack_require__(9307);
var InputManager_1 = __webpack_require__(7169);
var CanvasPageManager_1 = __webpack_require__(3283);
var CanvasViewManager_1 = __webpack_require__(1377);
var CanvasSelectionManager_1 = __webpack_require__(9700);
var AutoScrollController_1 = __webpack_require__(7611);
var TextMeasurer_1 = __webpack_require__(6727);
var RenderHelper_1 = __webpack_require__(8509);
var DOMManipulator_1 = __webpack_require__(6873);
var Utils_2 = __webpack_require__(41);
var READONLY_CSSCLASS = "dxdi-read-only";
var TOUCH_ACTION_CSSCLASS = "dxdi-touch-action";
exports.LONG_TOUCH_TIMEOUT = 500;
exports.DBL_CLICK_TIMEOUT = 500;
var RenderManager = (function () {
    function RenderManager(parent, events, measurer, settings, instanceId, scrollView, focusElementsParent) {
        this.moveLocked = false;
        this.lockMouseMoveTimer = -1;
        this.lastClickElement = undefined;
        this.longTouchTimer = undefined;
        this.dblTouchTimer = undefined;
        this.pointers = {};
        var mainElement = RenderHelper_1.RenderHelper.createMainElement(parent);
        var svgElement = RenderHelper_1.RenderHelper.createSvgElement(mainElement);
        this.instanceId = instanceId;
        this.scroll = scrollView || new ScrollView_1.NativeScrollView(parent);
        this.measurer = measurer;
        this.dom = new DOMManipulator_1.DOMManipulator(this.measurer);
        this.view = new CanvasViewManager_1.CanvasViewManager(this.scroll, svgElement, settings.modelSize, settings.zoomLevel, settings.autoZoom, settings.simpleView, settings.rectangle, this.dom, this.instanceId);
        this.input = new InputManager_1.InputManager(mainElement, this.view, events, this.measurer, settings.zoomLevel, focusElementsParent);
        this.items = new CanvasItemsManager_1.CanvasItemsManager(this.view.canvasElement, settings.zoomLevel, this.dom, this.instanceId);
        this.page = new CanvasPageManager_1.CanvasPageManager(this.view.pageElement, settings, this.dom, this.instanceId);
        this.selection = new CanvasSelectionManager_1.CanvasSelectionManager(this.view.canvasElement, settings.zoomLevel, settings.readOnly, this.dom, this.instanceId);
        this.contextMenuEnabled = settings.contextMenuEnabled;
        this.view.onViewChanged.add(this.page);
        this.view.onViewChanged.add(this.items);
        this.view.onViewChanged.add(this.selection);
        this.view.onViewChanged.add(this.input);
        this.autoScroll = new AutoScrollController_1.AutoScrollController(this.scroll, svgElement, this.view, this.dom);
        this.attachEvents(svgElement);
        this.mainElement = mainElement;
        this.svgElement = svgElement;
        this.events = events;
        this.notifyReadOnlyChanged(settings.readOnly);
    }
    RenderManager.prototype.clean = function (removeElement) {
        this.killLockMouseMoveTimer();
        this.clearLastMouseDownEvent();
        this.detachEvents(this.svgElement);
        this.scroll.detachEvents();
        this.input.detachEvents();
        this.dom.cancelAnimation();
        if (removeElement)
            removeElement(this.mainElement);
    };
    RenderManager.prototype.replaceParent = function (parent, scroll) {
        if (this.mainElement && this.mainElement.parentNode !== parent)
            parent.appendChild(this.mainElement);
        if (scroll && scroll !== this.scroll) {
            this.scroll && this.scroll.detachEvents();
            this.scroll = scroll;
        }
        if (this.measurer instanceof TextMeasurer_1.TextMeasurer)
            this.measurer.replaceParent(parent);
    };
    RenderManager.prototype.update = function (saveScrollPosition) {
        this.view.adjust({ horizontal: !saveScrollPosition, vertical: !saveScrollPosition });
        this.page.redraw();
    };
    RenderManager.prototype.onNewModel = function (items) {
        this.measurer.onNewModel(items, this.dom);
    };
    RenderManager.prototype.clear = function () {
        this.items.clear();
        this.selection.clear();
        this.input.clear();
    };
    RenderManager.prototype.attachPointerEvents = function (svgElement) {
        dom_1.DomUtils.addClassName(svgElement, TOUCH_ACTION_CSSCLASS);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "pointerdown", this.onPointerDownHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "mousedown", this.onSvgMouseDownHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "mousemove", this.onSvgMouseMoveHandler);
        RenderHelper_1.RenderHelper.addEventListener(browser_1.Browser.TouchUI ? svgElement : document, "pointerup", this.onPointerUpHandler);
        RenderHelper_1.RenderHelper.addEventListener(browser_1.Browser.TouchUI ? svgElement : document, "pointermove", this.onPointerMoveHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "pointercancel", this.onPointerCancelHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "pointerleave", this.onPointerLeaveHandler);
    };
    RenderManager.prototype.detachPointerEvents = function (svgElement) {
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "pointerdown", this.onPointerDownHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "mousedown", this.onSvgMouseDownHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "mousemove", this.onSvgMouseMoveHandler);
        RenderHelper_1.RenderHelper.removeEventListener(browser_1.Browser.TouchUI ? svgElement : document, "pointerup", this.onPointerUpHandler);
        RenderHelper_1.RenderHelper.removeEventListener(browser_1.Browser.TouchUI ? svgElement : document, "pointermove", this.onPointerMoveHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "pointercancel", this.onPointerCancelHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "pointerleave", this.onPointerLeaveHandler);
        dom_1.DomUtils.removeClassName(svgElement, TOUCH_ACTION_CSSCLASS);
    };
    RenderManager.prototype.attachEvents = function (svgElement) {
        this.onPointerDownHandler = this.onPointerDown.bind(this);
        this.onPointerUpHandler = this.onPointerUp.bind(this);
        this.onPointerMoveHandler = this.onPointerMove.bind(this);
        this.onPointerCancelHandler = this.onPointerCancel.bind(this);
        this.onPointerLeaveHandler = this.onPointerLeave.bind(this);
        this.onSvgMouseDownHandler = this.onSvgMouseDown.bind(this);
        this.onSvgMouseMoveHandler = this.onSvgMouseMove.bind(this);
        this.onMouseWheelHandler = this.onMouseWheel.bind(this);
        this.onMouseDblClickHandler = this.onMouseDblClick.bind(this);
        this.onContextMenuHandler = this.onContextMenu.bind(this);
        this.onWindowResizelHandler = this.onWindowResize.bind(this);
        this.onOrientationChangeHandler = this.onOrientationChange.bind(this);
        this.onMouseClickHandler = this.onMouseClick.bind(this);
        this.attachPointerEvents(svgElement);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "wheel", this.onMouseWheelHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "dblclick", this.onMouseDblClickHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "click", this.onMouseClickHandler);
        RenderHelper_1.RenderHelper.addEventListener(svgElement, "contextmenu", this.onContextMenuHandler);
        RenderHelper_1.RenderHelper.addEventListener(window, "resize", this.onWindowResizelHandler);
        RenderHelper_1.RenderHelper.addEventListener(window, "orientationchange", this.onOrientationChangeHandler);
        this.input.mouseWheelHandler = this.onMouseWheelHandler;
    };
    RenderManager.prototype.detachEvents = function (svgElement) {
        this.detachPointerEvents(svgElement);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "wheel", this.onMouseWheelHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "dblclick", this.onMouseDblClickHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "contextmenu", this.onContextMenuHandler);
        RenderHelper_1.RenderHelper.removeEventListener(svgElement, "click", this.onMouseClickHandler);
        RenderHelper_1.RenderHelper.removeEventListener(window, "resize", this.onWindowResizelHandler);
        RenderHelper_1.RenderHelper.removeEventListener(window, "orientationchange", this.onOrientationChangeHandler);
    };
    RenderManager.prototype.setPointerPosition = function (evt) {
        this.pointers[evt.pointerId] = {
            clientX: evt.clientX,
            clientY: evt.clientY
        };
    };
    RenderManager.prototype.clearPointerPosition = function (evt) {
        delete this.pointers[evt.pointerId];
    };
    RenderManager.prototype.onPointerUp = function (evt) {
        this.clearPointerPosition(evt);
        this.onMouseUp(evt);
    };
    RenderManager.prototype.onPointerMove = function (evt) {
        if ((browser_1.Browser.TouchUI && !Utils_2.EventUtils.isMousePointer(evt)) || Utils_2.EventUtils.isLeftButtonPressed(evt))
            this.setPointerPosition(evt);
        this.onDocumentMouseMove(evt);
    };
    RenderManager.prototype.onPointerCancel = function (evt) {
        this.clearPointerPosition(evt);
    };
    RenderManager.prototype.onPointerLeave = function (evt) {
        if (Utils_2.EventUtils.isMousePointer(evt))
            this.onMouseLeave(evt);
        this.clearPointerPosition(evt);
    };
    RenderManager.prototype.onPointerDown = function (evt) {
        var _this = this;
        this.setPointerPosition(evt);
        if (this.getPointerCount() > 2)
            this.pointers = {};
        this.lockMouseMove();
        this.input.lockFocus();
        this.autoScroll.onMouseDown(evt);
        this.lastDownMouseEvent = this.createDiagramMouseEvent(evt);
        (0, Utils_1.raiseEvent)(evt, this.lastDownMouseEvent, function (e) { return _this.events.onMouseDown(e); });
        if (this.events.canFinishTextEditing())
            this.input.captureFocus();
        if (Utils_2.EventUtils.isTouchEvent(evt))
            this.processTouchDown(evt);
    };
    RenderManager.prototype.onSvgMouseDown = function (evt) {
        evt_1.EvtUtils.preventEvent(evt);
    };
    RenderManager.prototype.onDocumentMouseMove = function (evt) {
        var _this = this;
        if (this.moveLocked)
            return;
        this.autoScroll.onMouseMove(evt, function () { return _this.onMouseMoveCore(evt); });
        this.onMouseMoveCore(evt);
        browser_1.Browser.IE && this.lockMouseMove();
        if (Utils_2.EventUtils.isTouchEvent(evt))
            this.processTouchMove(evt);
    };
    RenderManager.prototype.onSvgMouseMove = function (evt) {
        evt_1.EvtUtils.preventEventAndBubble(evt);
    };
    RenderManager.prototype.onMouseMoveCore = function (evt) {
        var _this = this;
        (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseMove(e); });
    };
    RenderManager.prototype.onMouseUp = function (evt) {
        var _this = this;
        this.lockMouseMove();
        var mouseEvent = this.createDiagramMouseEvent(evt);
        (0, Utils_1.raiseEvent)(evt, mouseEvent, function (e) { return _this.events.onMouseUp(e); });
        this.autoScroll.onMouseUp(evt);
        if (mouseEvent.source.type !== Event_1.MouseEventElementType.Undefined)
            this.input.captureFocus(true);
        if (Utils_2.EventUtils.isTouchEvent(evt))
            this.processTouchUp(evt);
    };
    RenderManager.prototype.onMouseEnter = function (evt) {
        var _this = this;
        this.autoScroll.onMouseEnter(evt);
        (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseEnter(e); });
    };
    RenderManager.prototype.onMouseLeave = function (evt) {
        var _this = this;
        (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onMouseLeave(e); });
    };
    RenderManager.prototype.onMouseDblClick = function (evt) {
        var _this = this;
        (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onDblClick(e); });
    };
    RenderManager.prototype.onMouseClick = function (evt) {
        var _this = this;
        if (!Utils_2.EventUtils.isTouchEvent(evt))
            (0, Utils_1.raiseEvent)(evt, this.createActualMouseClickEvent(evt), function (e) { return _this.events.onClick(e); });
        else if (!Utils_2.EventUtils.isMousePointer(evt))
            this.input.captureFocus();
    };
    RenderManager.prototype.createActualMouseClickEvent = function (evt) {
        if (!this.lastDownMouseEvent)
            return this.createDiagramMouseEvent(evt);
        return new Event_1.DiagramMouseEvent(this.lastDownMouseEvent.modifiers, this.lastDownMouseEvent.button, this.lastDownMouseEvent.offsetPoint.clone(), this.lastDownMouseEvent.modelPoint.clone(), this.lastDownMouseEvent.source, this.createDiagramMouseEventTouches(evt));
    };
    RenderManager.prototype.onContextMenu = function (evt) {
        var _this = this;
        if (!this.contextMenuEnabled)
            return;
        if (evt.buttons !== 1)
            (0, Utils_1.raiseEvent)(evt, this.createDiagramContextMenuEvent(evt), function (e) { return _this.events.onContextMenu(e); });
        this.input.captureFocus();
        return evt_1.EvtUtils.preventEventAndBubble(evt);
    };
    RenderManager.prototype.processTouchDown = function (evt) {
        var _this = this;
        this.touchDownPoint = this.getTouchPointFromEvent(evt);
        this.resetLongTouch();
        this.longTouchTimer = setTimeout(function () {
            (0, Utils_1.raiseEvent)(evt, _this.createDiagramMouseEvent(evt), function (e) { return _this.events.onLongTouch(e); });
            _this.resetLongTouch();
            _this.resetDblClick();
        }, exports.LONG_TOUCH_TIMEOUT);
    };
    RenderManager.prototype.processTouchMove = function (evt) {
        var currentTouchPoint = this.getTouchPointFromEvent(evt);
        if (this.touchDownPoint && currentTouchPoint && (Math.abs(this.touchDownPoint.x - currentTouchPoint.x) > RenderManager.touchPositionLimit ||
            Math.abs(this.touchDownPoint.y - currentTouchPoint.y) > RenderManager.touchPositionLimit)) {
            this.resetLongTouch();
            this.resetDblClick();
        }
    };
    RenderManager.prototype.getPointers = function () {
        var _this = this;
        return Object.keys(this.pointers).map(function (k) { return _this.pointers[k]; });
    };
    RenderManager.prototype.getPointerCount = function () {
        return Object.keys(this.pointers).length;
    };
    RenderManager.prototype.getTouchPointFromEvent = function (evt) {
        var touchPosition;
        var touches = evt["touches"];
        if (touches && touches.length > 0)
            touchPosition = new point_1.Point(touches[0].clientX, touches[0].clientY);
        else {
            var pointers = this.getPointers();
            if (pointers.length)
                touchPosition = new point_1.Point(pointers[0].clientX, pointers[0].clientY);
        }
        return touchPosition;
    };
    RenderManager.prototype.processTouchUp = function (evt) {
        var _this = this;
        if (this.longTouchTimer !== undefined) {
            (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onClick(e); });
            var element = evt_1.EvtUtils.getEventSource(evt);
            if (this.dblTouchTimer !== undefined && this.lastClickElement === element) {
                (0, Utils_1.raiseEvent)(evt, this.createDiagramMouseEvent(evt), function (e) { return _this.events.onDblClick(e); });
                this.resetDblClick();
            }
            else {
                this.resetDblClick();
                this.dblTouchTimer = setTimeout(function () { return _this.dblTouchTimer = undefined; }, exports.DBL_CLICK_TIMEOUT);
            }
            this.lastClickElement = element;
        }
        this.resetLongTouch();
        this.touchDownPoint = undefined;
    };
    RenderManager.prototype.resetLongTouch = function () {
        if (this.longTouchTimer !== undefined)
            clearTimeout(this.longTouchTimer);
        this.longTouchTimer = undefined;
    };
    RenderManager.prototype.resetDblClick = function () {
        if (this.dblTouchTimer !== undefined)
            clearTimeout(this.dblTouchTimer);
        this.dblTouchTimer = undefined;
    };
    RenderManager.prototype.onOrientationChange = function () {
        var _this = this;
        setTimeout(function () { return _this.onWindowResize(); }, 100);
    };
    RenderManager.prototype.onWindowResize = function () {
        var resetTo = { horizontal: false, vertical: false };
        if (this.view.autoZoom !== Settings_1.AutoZoomMode.Disabled) {
            resetTo.horizontal = true;
            resetTo.vertical = true;
        }
        else {
            var oldFitInfo = this.view.checkFitToCanvas();
            var newFitInfo = this.view.checkFitToCanvas(this.scroll.getSize());
            resetTo = { horizontal: oldFitInfo.horizontal !== newFitInfo.horizontal || newFitInfo.horizontal, vertical: oldFitInfo.vertical !== newFitInfo.vertical || newFitInfo.vertical };
        }
        this.view.adjust(resetTo);
    };
    RenderManager.prototype.onMouseWheel = function (evt) {
        var _this = this;
        (0, Utils_1.raiseEvent)(evt, this.createDiagramWheelEvent(evt), function (e) { return _this.events.onMouseWheel(e); });
    };
    RenderManager.prototype.notifyModelSizeChanged = function (size, offset) {
        this.view.notifyModelSizeChanged(size, offset);
    };
    RenderManager.prototype.notifyModelRectangleChanged = function (rectangle) {
        this.view.notifyModelRectangleChanged(rectangle);
    };
    RenderManager.prototype.notifyReadOnlyChanged = function (readOnly) {
        dom_1.DomUtils.toggleClassName(this.mainElement, READONLY_CSSCLASS, readOnly);
    };
    RenderManager.prototype.notifyDragStart = function (_itemKeys) { };
    RenderManager.prototype.notifyDragEnd = function (_itemKeys) { };
    RenderManager.prototype.notifyDragScrollStart = function () {
        this.autoScroll.onDragScrollStart();
    };
    RenderManager.prototype.notifyDragScrollEnd = function () {
        this.autoScroll.onDragScrollEnd();
    };
    RenderManager.prototype.notifyToolboxDragStart = function (evt) {
        this.onMouseEnter(evt);
    };
    RenderManager.prototype.notifyToolboxDragEnd = function (evt) {
        if (evt && Utils_2.EventUtils.isPointerEvents())
            this.onMouseUp(evt);
    };
    RenderManager.prototype.notifyToolboxDraggingMouseMove = function (evt) {
        this.onDocumentMouseMove(evt);
    };
    RenderManager.prototype.createDiagramMouseEvent = function (evt) {
        var modifiers = key_1.KeyUtils.getKeyModifiers(evt);
        var button = isLeftButtonPressed(evt) ? Event_1.MouseButton.Left : Event_1.MouseButton.Right;
        var offsetPoint = this.getOffsetPointByEvent(evt);
        var modelPoint = this.getModelPoint(offsetPoint);
        var isTouchMode = Utils_2.EventUtils.isTouchEvent(evt);
        var eventSource = this.getEventSource(evt, isTouchMode);
        var touches = this.createDiagramMouseEventTouches(evt);
        return new Event_1.DiagramMouseEvent(modifiers, button, offsetPoint, modelPoint, eventSource, touches, isTouchMode);
    };
    RenderManager.prototype.createDiagramMouseEventTouches = function (evt) {
        var touches = [];
        if (evt["touches"])
            for (var i = 0; i < evt["touches"].length; i++) {
                var x = evt["touches"][i].clientX;
                var y = evt["touches"][i].clientY;
                var offsetPoint = this.getOffsetPointByEventPoint(x, y);
                var modelPoint = this.getModelPoint(offsetPoint);
                touches.push(new Event_1.DiagramMouseEventTouch(offsetPoint, modelPoint));
            }
        else {
            var pointers = this.getPointers();
            for (var i = 0; i < pointers.length; i++) {
                var x = pointers[i].clientX;
                var y = pointers[i].clientY;
                var offsetPoint = this.getOffsetPointByEventPoint(x, y);
                var modelPoint = this.getModelPoint(offsetPoint);
                touches.push(new Event_1.DiagramMouseEventTouch(offsetPoint, modelPoint));
            }
        }
        return touches;
    };
    RenderManager.prototype.createDiagramContextMenuEvent = function (evt) {
        var modifiers = key_1.KeyUtils.getKeyModifiers(evt);
        var eventPoint = new point_1.Point(evt.pageX, evt.pageY);
        var offsetPoint = this.getOffsetPointByEvent(evt);
        var modelPoint = this.getModelPoint(offsetPoint);
        return new Event_1.DiagramContextMenuEvent(modifiers, eventPoint, modelPoint);
    };
    RenderManager.prototype.createDiagramWheelEvent = function (evt) {
        var modifiers = key_1.KeyUtils.getKeyModifiers(evt);
        var offsetPoint = this.getOffsetPointByEvent(evt);
        var modelPoint = this.view.getModelPoint(offsetPoint);
        var eventSource = this.getEventSource(evt);
        var deltaX = evt.deltaX || (evt["originalEvent"] && evt["originalEvent"].deltaX);
        var deltaY = evt.deltaY || (evt["originalEvent"] && evt["originalEvent"].deltaY);
        return new Event_1.DiagramWheelEvent(modifiers, deltaX, deltaY, offsetPoint, modelPoint, eventSource);
    };
    RenderManager.prototype.getEventSource = function (evt, findByPosition) {
        var element = findByPosition ? evt_1.EvtUtils.getEventSourceByPosition(evt) : evt_1.EvtUtils.getEventSource(evt);
        if (this.isDiagramControl(element))
            while (element && !this.isDocumentContainer(element)) {
                var src_1 = Utils_1.RenderUtils.getElementEventData(element);
                if (src_1 !== undefined)
                    return src_1;
                if (this.input.isTextInputElement(element))
                    return new Event_1.MouseEventSource(Event_1.MouseEventElementType.Document);
                element = element.parentNode;
            }
        var src = new Event_1.MouseEventSource(Event_1.MouseEventElementType.Undefined);
        if (element && this.isDocumentContainer(element))
            src.type = Event_1.MouseEventElementType.Background;
        return src;
    };
    RenderManager.prototype.isDiagramControl = function (element) {
        while (element) {
            if (this.isDocumentContainer(element))
                return true;
            element = element.parentNode;
        }
        return false;
    };
    RenderManager.prototype.isDocumentContainer = function (element) {
        return element === this.mainElement;
    };
    RenderManager.prototype.lockMouseMove = function () {
        var _this = this;
        this.moveLocked = true;
        this.lockMouseMoveTimer = setTimeout(function () {
            _this.moveLocked = false;
            _this.lockMouseMoveTimer = -1;
        }, 10);
    };
    RenderManager.prototype.killLockMouseMoveTimer = function () {
        if (this.lockMouseMoveTimer !== -1) {
            clearTimeout(this.lockMouseMoveTimer);
            this.lockMouseMoveTimer = -1;
        }
    };
    RenderManager.prototype.clearLastMouseDownEvent = function () {
        this.lastDownMouseEvent = undefined;
    };
    RenderManager.prototype.getModelPoint = function (offsetPoint) {
        return this.view.getModelPoint(offsetPoint);
    };
    RenderManager.prototype.getOffsetPointByEvent = function (evt) {
        var clientX = evt_1.EvtUtils.getEventX(evt);
        var clientY = evt_1.EvtUtils.getEventY(evt);
        return this.getOffsetPointByEventPoint(clientX, clientY);
    };
    RenderManager.prototype.getOffsetPointByEventPoint = function (clientX, clientY) {
        var scrollContainer = this.scroll.getScrollContainer();
        var containerX = dom_1.DomUtils.getAbsolutePositionX(scrollContainer);
        var containerY = dom_1.DomUtils.getAbsolutePositionY(scrollContainer);
        return new point_1.Point(clientX - containerX, clientY - containerY);
    };
    RenderManager.prototype.getModelPointByEventPoint = function (clientX, clientY) {
        var offsetPoint = this.getOffsetPointByEventPoint(clientX, clientY);
        return this.view.getModelPoint(offsetPoint);
    };
    RenderManager.prototype.getEventPointByModelPoint = function (point) {
        var pos = this.view.getAbsolutePoint(point);
        var scrollContainer = this.scroll.getScrollContainer();
        return new point_1.Point(dom_1.DomUtils.getAbsolutePositionX(scrollContainer) + pos.x, dom_1.DomUtils.getAbsolutePositionY(scrollContainer) + pos.y);
    };
    RenderManager.touchPositionLimit = 4;
    return RenderManager;
}());
exports.RenderManager = RenderManager;
function isLeftButtonPressed(evt) {
    return !browser_1.Browser.MSTouchUI ? Utils_2.EventUtils.isLeftButtonPressed(evt) : evt.button !== 2;
}


/***/ }),

/***/ 4339:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.CommandBase = void 0;
var CommandBase = (function () {
    function CommandBase(control) {
        this.control = control;
    }
    CommandBase.prototype.execute = function (parameter) {
        if (this.isPermissionsRequired)
            this.permissionsProvider.lockPermissions();
        var state = this.getState();
        if (this.isPermissionsRequired)
            this.permissionsProvider.unlockPermissions();
        if (!state.enabled)
            return false;
        this.control.beginUpdate();
        var executed = false;
        if (this.isPermissionsRequired)
            executed = this.executeWithPermissions(state, parameter);
        else
            executed = this.executeCore(state, parameter);
        this.control.endUpdate();
        if (executed)
            this.updateControlState();
        return executed;
    };
    CommandBase.prototype.executeWithPermissions = function (state, parameter) {
        var executed = false;
        this.permissionsProvider.beginStorePermissions();
        this.control.history.beginTransaction();
        executed = this.executeCore(state, parameter);
        if (!this.permissionsProvider.isStoredPermissionsGranted()) {
            this.permissionsProvider.lockPermissions();
            this.control.history.undoTransaction();
            this.permissionsProvider.unlockPermissions();
            executed = false;
        }
        this.control.history.endTransaction();
        this.permissionsProvider.endStorePermissions();
        return executed;
    };
    CommandBase.prototype.updateControlState = function () {
        if (!this.lockInputPositionUpdating())
            this.control.selection.inputPosition.reset();
        if (!this.lockUIUpdating())
            this.control.barManager.updateItemsState();
    };
    Object.defineProperty(CommandBase.prototype, "permissionsProvider", {
        get: function () { return this.control && this.control.permissionsProvider; },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CommandBase.prototype, "isPermissionsRequired", {
        get: function () { return false; },
        enumerable: false,
        configurable: true
    });
    CommandBase.prototype.lockUIUpdating = function () {
        return false;
    };
    CommandBase.prototype.lockInputPositionUpdating = function () {
        return false;
    };
    return CommandBase;
}());
exports.CommandBase = CommandBase;


/***/ }),

/***/ 4385:
/***/ ((__unused_webpack_module, exports) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.ConnectorProperties = exports.DEFAULT_CONNECTOR_ENDLINEENDING = exports.DEFAULT_CONNECTOR_STARTLINEENDING = exports.DEFAULT_CONNECTOR_LINEOPTION = exports.ConnectorLineEnding = exports.ConnectorLineOption = void 0;
var ConnectorLineOption;
(function (ConnectorLineOption) {
    ConnectorLineOption[ConnectorLineOption["Straight"] = 0] = "Straight";
    ConnectorLineOption[ConnectorLineOption["Orthogonal"] = 1] = "Orthogonal";
})(ConnectorLineOption = exports.ConnectorLineOption || (exports.ConnectorLineOption = {}));
var ConnectorLineEnding;
(function (ConnectorLineEnding) {
    ConnectorLineEnding[ConnectorLineEnding["None"] = 0] = "None";
    ConnectorLineEnding[ConnectorLineEnding["Arrow"] = 1] = "Arrow";
    ConnectorLineEnding[ConnectorLineEnding["OutlinedTriangle"] = 2] = "OutlinedTriangle";
    ConnectorLineEnding[ConnectorLineEnding["FilledTriangle"] = 3] = "FilledTriangle";
})(ConnectorLineEnding = exports.ConnectorLineEnding || (exports.ConnectorLineEnding = {}));
exports.DEFAULT_CONNECTOR_LINEOPTION = ConnectorLineOption.Orthogonal;
exports.DEFAULT_CONNECTOR_STARTLINEENDING = ConnectorLineEnding.None;
exports.DEFAULT_CONNECTOR_ENDLINEENDING = ConnectorLineEnding.Arrow;
var ConnectorProperties = (function () {
    function ConnectorProperties() {
        this.lineOption = exports.DEFAULT_CONNECTOR_LINEOPTION;
        this.startLineEnding = exports.DEFAULT_CONNECTOR_STARTLINEENDING;
        this.endLineEnding = exports.DEFAULT_CONNECTOR_ENDLINEENDING;
    }
    ConnectorProperties.prototype.clone = function () {
        var clone = new ConnectorProperties();
        clone.lineOption = this.lineOption;
        clone.startLineEnding = this.startLineEnding;
        clone.endLineEnding = this.endLineEnding;
        return clone;
    };
    ConnectorProperties.prototype.forEach = function (callback) {
        for (var propertyName in this)
            if (Object.prototype.hasOwnProperty.call(this, propertyName))
                callback(propertyName);
    };
    ConnectorProperties.prototype.toObject = function () {
        var result = {};
        var modified = false;
        if (this.lineOption !== exports.DEFAULT_CONNECTOR_LINEOPTION) {
            result["lineOption"] = this.lineOption;
            modified = true;
        }
        if (this.startLineEnding !== exports.DEFAULT_CONNECTOR_STARTLINEENDING) {
            result["startLineEnding"] = this.startLineEnding;
            modified = true;
        }
        if (this.endLineEnding !== exports.DEFAULT_CONNECTOR_ENDLINEENDING) {
            result["endLineEnding"] = this.endLineEnding;
            modified = true;
        }
        return modified ? result : null;
    };
    ConnectorProperties.prototype.fromObject = function (obj) {
        if (typeof obj["lineOption"] === "number")
            this.lineOption = obj["lineOption"];
        if (typeof obj["startLineEnding"] === "number")
            this.startLineEnding = obj["startLineEnding"];
        if (typeof obj["endLineEnding"] === "number")
            this.endLineEnding = obj["endLineEnding"];
    };
    return ConnectorProperties;
}());
exports.ConnectorProperties = ConnectorProperties;


/***/ }),

/***/ 4412:
/***/ ((__unused_webpack_module, exports, __webpack_require__) => {


Object.defineProperty(exports, "__esModule", ({ value: true }));
exports.RectangleDeviation = exports.HitTestDeviation = exports.Rectangle = void 0;
var flag_1 = __webpack_require__(3393);
var algorithms_1 = __webpack_require__(2095);
var fixed_1 = __webpack_require__(2871);
var point_1 = __webpack_require__(5327);
var size_1 = __webpack_require__(3844);
var Rectangle = (function () {
    function Rectangle(x, y, width, height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }
    Object.defineProperty(Rectangle.prototype, "right", {
        get: function () {
            return this.x + this.width;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "bottom", {
        get: function () {
            return this.y + this.height;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Rectangle.prototype, "center", {
        get: function () {
            return Rectangle.center(this);
        },
        enumerable: false,
        configurable: true
    });
    Rectangle.prototype.createRectangle = function () {
        return new Rectangle(this.x, this.y, this.width, this.height);
    };
    Rectangle.prototype.createSize = function () {
        return new size_1.Size(this.width, this.height);
    };
    Rectangle.prototype.createPosition = function () {
        return new point_1.Point(this.x, this.y);
    };
    Rectangle.prototype.createVerticalInterval = function () {
        return new fixed_1.FixedInterval(this.y, this.height);
    };
    Rectangle.prototype.createHorizontalInterval = function () {
        return new fixed_1.FixedInterval(this.x, this.width);
    };
    Rectangle.fromGeometry = function (point, size) {
        return new Rectangle(point.x, point.y, size.width, size.height);
    };
    Rectangle.fromPoints = function (pointA, pointB) {
        var x = Math.min(pointA.x, pointB.x);
        var y = Math.min(pointA.y, pointB.y);
        var width = Math.abs(pointA.x - pointB.x);
        var height = Math.abs(pointA.y - pointB.y);
        return new Rectangle(x, y, width, height);
    };
    Rectangle.fromPositions = function (x1, y1, x2, y2) {
        var x = Math.min(x1, x2);
        var y = Math.min(y1, y2);
        var width = Math.abs(x2 - x1);
        var height = Math.abs(y2 - y1);
        return new Rectangle(x, y, width, height);
    };
    Rectangle.fromCenter = function (center, minRadius) {
        return new Rectangle(center.x - minRadius, center.y - minRadius, minRadius * 2, minRadius * 2);
    };
    Rectangle.prototype.isCollapsed = function () {
        return this.width === 0 || this.height === 0;
    };
    Rectangle.prototype.isEmpty = function () {
        return this.x === 0 && this.y === 0 &&
            this.width === 0 && this.height === 0;
    };
    Rectangle.prototype.toString = function () {
        return JSON.stringify(this);
    };
    Rectangle.prototype.setPosition = function (pos) {
        this.x = pos.x;
        this.y = pos.y;
        return this;
    };
    Rectangle.prototype.setSize = function (size) {
        this.width = size.width;
        this.height = size.height;
        return this;
    };
    Rectangle.prototype.setGeomerty = function (rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    };
    Rectangle.prototype.moveRectangle = function (offsetX, offsetY) {
        this.x += offsetX;
        this.y += offsetY;
        return this;
    };
    Rectangle.prototype.moveRectangleByPoint = function (offset) {
        this.x += offset.x;
        this.y += offset.y;
        return this;
    };
    Rectangle.prototype.resize = function (deltaX, deltaY) {
        this.width += deltaX;
        this.height += deltaY;
        return this;
    };
    Rectangle.prototype.nonNegativeSize = function () {
        if (this.width < 0)
            this.width = 0;
        if (this.height < 0)
            this.height = 0;
        return this;
    };
    Rectangle.prototype.multiply = function (multiplierX, multiplierY) {
        this.x *= multiplierX;
        this.y *= multiplierY;
        this.width *= multiplierX;
        this.height *= multiplierY;
        return this;
    };
    Rectangle.prototype.equals = function (obj) {
        return Rectangle.equals(this, obj);
    };
    Rectangle.prototype.clone = function () {
        var rect = new Rectangle(0, 0, 0, 0);
        rect.copyFrom(this);
        return rect;
    };
    Rectangle.prototype.copyFrom = function (obj) {
        this.x = obj.x;
        this.y = obj.y;
        this.width = obj.width;
        this.height = obj.height;
    };
    Rectangle.prototype.containsPoint = function (point) {
        return Rectangle.containsPoint(this, point);
    };
    Rectangle.prototype.containsRectangle = function (rectangle) {
        return this.x <= rectangle.x &&
            this.right >= rectangle.right &&
            this.y <= rectangle.y &&
            this.bottom >= rectangle.bottom;
    };
    Rectangle.prototype.inflate = function (deltaX, deltaY) {
        if (deltaY === void 0) { deltaY = deltaX; }
        this.x -= deltaX;
        this.y -= deltaY;
        this.width += deltaX * 2;
        this.height += deltaY * 2;
        return this;
    };
    Rectangle.pro